/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.util;

public class FpsCounter {
    protected double t1;
    protected double t2;
    protected double time;
    protected int count = 0;
    protected double avgTime;

    public double getFramesPerSecond() {
        return 1.0E9 / this.time;
    }

    public double getLastFrameTimeInSeconds() {
        return this.time / 1.0E9;
    }

    public int getAverageMeasureCount() {
        return this.count;
    }

    public double getAverageFramesPerSecond() {
        return 1.0E9 / (this.avgTime / (double)this.count);
    }

    public double getAverageFrameTimeInSeconds() {
        return this.avgTime / (double)this.count * 1.0E9;
    }

    public void resetAverages() {
        this.count = 0;
        this.avgTime = 0.0;
    }

    public void beginFrame() {
        this.t1 = System.nanoTime();
    }

    public void endFrame() {
        if (this.count > 1000000) {
            this.count = 0;
            this.avgTime = 0.0;
        }
        this.t2 = System.nanoTime();
        this.time = this.t2 - this.t1;
        this.avgTime += this.time;
        ++this.count;
    }
}

