/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph.test;

import java.awt.Color;
import java.util.HashSet;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.spriteManager.Sprite;
import org.graphstream.ui.spriteManager.SpriteManager;
import org.junit.Assert;
import org.junit.Test;

public class TestGraphicGraph {
    protected Graph inGraph;
    protected GraphicGraph outGraph;
    protected static String styleSheet1 = "graph  { fill-color: black; }node   { fill-color: white; }edge   { fill-color: white; }node#A { fill-color: red;   }node#B { fill-color: blue;  }";

    @Test
    public void basicTest() {
        this.outGraph = new GraphicGraph("GraphicGraph");
        this.outGraph.addNode("A");
        this.outGraph.addNode("B");
        this.outGraph.addNode("C");
        this.outGraph.addEdge("AB", "A", "B", false);
        this.outGraph.addEdge("BC", "B", "C", true);
        this.outGraph.addEdge("CA", "C", "A", false);
        Assert.assertEquals((long)3L, (long)this.outGraph.getNodeCount());
        Assert.assertEquals((long)3L, (long)this.outGraph.getEdgeCount());
        Assert.assertEquals((long)0L, (long)this.outGraph.getSpriteCount());
        Assert.assertFalse((boolean)this.outGraph.getEdge("AB").isDirected());
        Assert.assertTrue((boolean)this.outGraph.getEdge("BC").isDirected());
        Assert.assertFalse((boolean)this.outGraph.getEdge("CA").isDirected());
        this.outGraph.addEdge("AB2", "A", "B", true);
        Assert.assertEquals((long)4L, (long)this.outGraph.getEdgeCount());
        Assert.assertFalse((boolean)this.outGraph.getEdge("AB").isDirected());
        Assert.assertTrue((boolean)this.outGraph.getEdge("AB2").isDirected());
        this.outGraph.addEdge("CA2", "C", "A");
        this.outGraph.removeEdge("CA");
        Assert.assertEquals((long)4L, (long)this.outGraph.getEdgeCount());
        Assert.assertEquals(null, this.outGraph.getEdge("CA"));
        Assert.assertTrue((this.outGraph.getEdge("CA2") != null ? 1 : 0) != 0);
        this.outGraph.removeNode("C");
        Assert.assertEquals((long)2L, (long)this.outGraph.getNodeCount());
        Assert.assertEquals((long)2L, (long)this.outGraph.getEdgeCount());
        Assert.assertEquals(null, this.outGraph.getNode("C"));
        Assert.assertEquals(null, this.outGraph.getEdge("BC"));
        Assert.assertEquals(null, this.outGraph.getEdge("CA"));
        this.outGraph.removeNode("A");
        Assert.assertEquals((long)1L, (long)this.outGraph.getNodeCount());
        Assert.assertEquals((long)0L, (long)this.outGraph.getEdgeCount());
        Assert.assertEquals(null, this.outGraph.getNode("A"));
        Assert.assertEquals(null, this.outGraph.getEdge("AB"));
        Assert.assertEquals(null, this.outGraph.getEdge("AB2"));
        this.outGraph.clear();
        Assert.assertEquals((long)0L, (long)this.outGraph.getNodeCount());
        Assert.assertEquals((long)0L, (long)this.outGraph.getEdgeCount());
        Assert.assertEquals((long)0L, (long)this.outGraph.getSpriteCount());
    }

    @Test
    public void testStyleSheetLoading() {
        this.outGraph = new GraphicGraph("GraphicGraph");
        this.outGraph.addNode("A");
        this.outGraph.addNode("B");
        this.outGraph.addNode("C");
        this.outGraph.addEdge("AB", "A", "B");
        this.outGraph.addEdge("BC", "B", "C");
        this.outGraph.addEdge("CA", "C", "A");
        Assert.assertNotNull((Object)this.outGraph.getStyle());
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("A")).getStyle());
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("B")).getStyle());
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("C")).getStyle());
        this.testStyle(this.outGraph.getStyle(), Color.WHITE);
        this.testStyle(((GraphicNode)this.outGraph.getNode("A")).getStyle(), Color.BLACK);
        this.testStyle(((GraphicNode)this.outGraph.getNode("B")).getStyle(), Color.BLACK);
        this.testStyle(((GraphicNode)this.outGraph.getNode("C")).getStyle(), Color.BLACK);
        this.outGraph.addAttribute("stylesheet", styleSheet1);
        Assert.assertNotNull((Object)this.outGraph.getStyle());
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("A")).getStyle());
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("B")).getStyle());
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("C")).getStyle());
        this.testStyle(this.outGraph.getStyle(), Color.BLACK);
        this.testStyle(((GraphicNode)this.outGraph.getNode("A")).getStyle(), Color.RED);
        this.testStyle(((GraphicNode)this.outGraph.getNode("B")).getStyle(), Color.BLUE);
        this.testStyle(((GraphicNode)this.outGraph.getNode("C")).getStyle(), Color.WHITE);
        this.outGraph.addAttribute("stylesheet", "node#A { fill-color: green; }");
        Assert.assertNotNull((Object)this.outGraph.getStyle());
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("A")).getStyle());
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("B")).getStyle());
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("C")).getStyle());
        this.testStyle(this.outGraph.getStyle(), Color.BLACK);
        this.testStyle(((GraphicNode)this.outGraph.getNode("A")).getStyle(), Color.GREEN);
        this.testStyle(((GraphicNode)this.outGraph.getNode("B")).getStyle(), Color.BLUE);
        this.testStyle(((GraphicNode)this.outGraph.getNode("C")).getStyle(), Color.WHITE);
        this.outGraph.getNode("A").addAttribute("ui.style", "fill-color: blue;");
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("A")).getStyle());
        this.testStyle(((GraphicNode)this.outGraph.getNode("A")).getStyle(), Color.BLUE);
        this.outGraph.getStyleSheet().clear();
        Assert.assertNotNull((Object)this.outGraph.getStyle());
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("A")).getStyle());
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("B")).getStyle());
        Assert.assertNotNull((Object)((GraphicNode)this.outGraph.getNode("C")).getStyle());
        this.testStyle(this.outGraph.getStyle(), Color.WHITE);
        this.testStyle(((GraphicNode)this.outGraph.getNode("A")).getStyle(), Color.BLACK);
        this.testStyle(((GraphicNode)this.outGraph.getNode("B")).getStyle(), Color.BLACK);
        this.testStyle(((GraphicNode)this.outGraph.getNode("C")).getStyle(), Color.BLACK);
    }

    protected void testStyle(Style style, Color colorBase) {
        Assert.assertTrue((style.getFillColors() != null && style.getFillColors().size() == 1 ? 1 : 0) != 0);
        Color color = style.getFillColor(0);
        Assert.assertEquals((Object)((Object)StyleConstants.FillMode.PLAIN), (Object)((Object)style.getFillMode()));
        Assert.assertEquals((Object)((Object)StyleConstants.StrokeMode.NONE), (Object)((Object)style.getStrokeMode()));
        Assert.assertEquals((Object)colorBase, (Object)color);
    }

    @Test
    public void testAsOutput() {
        this.inGraph = new MultiGraph("inputGraph");
        this.outGraph = new GraphicGraph("GraphicGraph");
        this.inGraph.addSink(this.outGraph);
        this.inGraph.addNode("A");
        this.inGraph.addNode("B");
        this.inGraph.addNode("C");
        this.inGraph.addEdge("AB", "A", "B", false);
        this.inGraph.addEdge("BC", "B", "C", true);
        this.inGraph.addEdge("CA", "C", "A", false);
        Assert.assertEquals((long)3L, (long)this.outGraph.getNodeCount());
        Assert.assertEquals((long)3L, (long)this.outGraph.getEdgeCount());
        Assert.assertEquals((long)0L, (long)this.outGraph.getSpriteCount());
        Assert.assertFalse((boolean)this.outGraph.getEdge("AB").isDirected());
        Assert.assertTrue((boolean)this.outGraph.getEdge("BC").isDirected());
        Assert.assertFalse((boolean)this.outGraph.getEdge("CA").isDirected());
        this.inGraph.removeNode("A");
        this.inGraph.removeEdge("BC");
        Assert.assertEquals((long)2L, (long)this.outGraph.getNodeCount());
        Assert.assertEquals((long)0L, (long)this.outGraph.getEdgeCount());
        Assert.assertNull(this.outGraph.getNode("A"));
        Assert.assertNotNull(this.outGraph.getNode("B"));
        Assert.assertNotNull(this.outGraph.getNode("C"));
        Assert.assertNull(this.outGraph.getEdge("AB"));
        Assert.assertNull(this.outGraph.getEdge("BC"));
        Assert.assertNull(this.outGraph.getEdge("CA"));
    }

    @Test
    public void testAsOutputSprites() {
        this.inGraph = new MultiGraph("inputGraph");
        this.outGraph = new GraphicGraph("GraphicGraph");
        this.inGraph.addSink(this.outGraph);
        SpriteManager sman = new SpriteManager(this.inGraph);
        this.inGraph.addNode("A");
        this.inGraph.addNode("B");
        this.inGraph.addNode("C");
        this.inGraph.addEdge("AB", "A", "B", false);
        this.inGraph.addEdge("BC", "B", "C", true);
        this.inGraph.addEdge("CA", "C", "A", false);
        Assert.assertEquals((long)3L, (long)this.outGraph.getNodeCount());
        Assert.assertEquals((long)3L, (long)this.outGraph.getEdgeCount());
        Assert.assertEquals((long)0L, (long)this.outGraph.getSpriteCount());
        Sprite s1 = sman.addSprite("S1");
        Sprite s2 = sman.addSprite("S2");
        HashSet<String> spriteIds = new HashSet<String>();
        Assert.assertTrue((boolean)sman.hasSprite("S1"));
        Assert.assertTrue((boolean)sman.hasSprite("S2"));
        Assert.assertEquals((Object)s1, (Object)sman.getSprite("S1"));
        Assert.assertEquals((Object)s2, (Object)sman.getSprite("S2"));
        Assert.assertEquals((long)2L, (long)sman.getSpriteCount());
        spriteIds.add("S1");
        spriteIds.add("S2");
        for (Sprite sprite : sman) {
            if (!spriteIds.contains(sprite.getId())) continue;
            spriteIds.remove(sprite.getId());
        }
        Assert.assertTrue((boolean)spriteIds.isEmpty());
        Assert.assertEquals((long)2L, (long)this.outGraph.getSpriteCount());
        spriteIds.add("S1");
        spriteIds.add("S2");
        for (GraphicSprite graphicSprite : this.outGraph.spriteSet()) {
            if (!spriteIds.contains(graphicSprite.getId())) continue;
            spriteIds.remove(graphicSprite.getId());
        }
        Assert.assertTrue((boolean)spriteIds.isEmpty());
        sman.removeSprite("S2");
        Assert.assertEquals((long)1L, (long)sman.getSpriteCount());
        Assert.assertEquals((long)1L, (long)this.outGraph.getSpriteCount());
        Assert.assertNotNull((Object)this.outGraph.getSprite("S1"));
        Assert.assertNull((Object)this.outGraph.getSprite("S2"));
        s1.addAttribute("ui.foo", "bar");
        s1.addAttribute("ui.foo1", 1, 2, 3);
        s1.addAttribute("foo", "bar");
        GraphicSprite graphicSprite = this.outGraph.getSprite("S1");
        this.testSprite1(s1);
        this.testSprite1(graphicSprite);
        Assert.assertTrue((boolean)s1.hasLabel("foo"));
        Assert.assertEquals((Object)"bar", (Object)s1.getLabel("foo"));
        Assert.assertFalse((boolean)graphicSprite.hasLabel("foo"));
        s1.removeAttribute("ui.foo1");
        s1.removeAttribute("foo");
        Assert.assertFalse((boolean)s1.hasAttribute("ui.foo1"));
        Assert.assertFalse((boolean)graphicSprite.hasAttribute("ui.foo1"));
        Assert.assertFalse((boolean)s1.hasAttribute("foo"));
        Assert.assertFalse((boolean)graphicSprite.hasAttribute("foo"));
        Assert.assertEquals((double)0.0, (double)graphicSprite.getX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)graphicSprite.getY(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)graphicSprite.getZ(), (double)0.0);
        s1.setPosition(0.5);
        Assert.assertEquals((double)0.5, (double)graphicSprite.getX(), (double)0.0);
        s1.setPosition(0.5, 0.5, 0.5);
        Assert.assertEquals((double)0.5, (double)graphicSprite.getX(), (double)0.0);
        Assert.assertEquals((double)0.5, (double)graphicSprite.getY(), (double)0.0);
        Assert.assertEquals((double)0.5, (double)graphicSprite.getZ(), (double)0.0);
        s2 = sman.addSprite("S2");
        Sprite s3 = sman.addSprite("S3");
        s2.addAttribute("ui.foo", "bar");
        s3.addAttribute("ui.foo", "bar");
        Assert.assertEquals((long)3L, (long)sman.getSpriteCount());
        Assert.assertEquals((long)3L, (long)this.outGraph.getSpriteCount());
        Assert.assertNotNull((Object)sman.getSprite("S1"));
        Assert.assertNotNull((Object)sman.getSprite("S2"));
        Assert.assertNotNull((Object)sman.getSprite("S3"));
        Assert.assertNotNull((Object)this.outGraph.getSprite("S1"));
        Assert.assertNotNull((Object)this.outGraph.getSprite("S2"));
        Assert.assertNotNull((Object)this.outGraph.getSprite("S3"));
        sman.detach();
        SpriteManager sman2 = new SpriteManager(this.inGraph);
        Assert.assertEquals((long)3L, (long)sman2.getSpriteCount());
        Assert.assertEquals((long)3L, (long)this.outGraph.getSpriteCount());
        Assert.assertNotNull((Object)sman2.getSprite("S1"));
        Assert.assertNotNull((Object)sman2.getSprite("S2"));
        Assert.assertNotNull((Object)sman2.getSprite("S3"));
        Assert.assertNotNull((Object)this.outGraph.getSprite("S1"));
        Assert.assertNotNull((Object)this.outGraph.getSprite("S2"));
        Assert.assertNotNull((Object)this.outGraph.getSprite("S3"));
        SpriteManager sman3 = new SpriteManager(this.inGraph);
        Assert.assertEquals((long)3L, (long)sman3.getSpriteCount());
        Assert.assertNotNull((Object)sman3.getSprite("S1"));
        Assert.assertNotNull((Object)sman3.getSprite("S2"));
        Assert.assertNotNull((Object)sman3.getSprite("S3"));
        this.outGraph.addAttributeSink(this.inGraph);
        this.outGraph.addSprite("S4");
        Assert.assertNotNull((Object)sman2.getSprite("S4"));
        Assert.assertNotNull((Object)sman3.getSprite("S4"));
        Assert.assertNull((Object)sman.getSprite("S4"));
        this.outGraph.removeAttributeSink(this.inGraph);
        sman2.removeSprite("S4");
        Assert.assertNull((Object)sman3.getSprite("S4"));
    }

    protected void testSprite1(Element e) {
        Object[] values = new Object[]{1, 2, 3};
        Assert.assertTrue((boolean)e.hasLabel("ui.foo"));
        Assert.assertTrue((boolean)e.hasAttribute("ui.foo"));
        Assert.assertEquals((Object)"bar", (Object)e.getLabel("ui.foo"));
        Assert.assertEquals((Object)"bar", e.getAttribute("ui.foo"));
        Assert.assertTrue((boolean)e.hasArray("ui.foo1"));
        Assert.assertTrue((boolean)e.hasAttribute("ui.foo1"));
        Assert.assertArrayEquals((Object[])values, (Object[])e.getArray("ui.foo1"));
    }

    @Test
    public void testAsPipe() {
        this.inGraph = new MultiGraph("input graph");
        this.outGraph = new GraphicGraph("GraphicGraph");
        this.inGraph.addSink(this.outGraph);
        this.outGraph.addSink(this.inGraph);
        this.inGraph.addNode("A");
        this.outGraph.addNode("B");
        Assert.assertNotNull(this.outGraph.getNode("A"));
        Assert.assertNotNull(this.inGraph.getNode("B"));
        this.inGraph.addNode("C");
        this.outGraph.addEdge("AB", "A", "B");
        this.inGraph.addEdge("BC", "B", "C");
        this.outGraph.addEdge("CA", "C", "A");
        Assert.assertNotNull(this.outGraph.getNode("C"));
        Assert.assertNotNull(this.inGraph.getEdge("AB"));
        Assert.assertNotNull(this.outGraph.getEdge("BC"));
        Assert.assertNotNull(this.inGraph.getEdge("CA"));
        this.inGraph.addAttribute("ui.foo", "bar");
        this.outGraph.addAttribute("ui.bar", "foo");
        this.inGraph.getNode("A").addAttribute("ui.foo", "bar");
        this.outGraph.getNode("A").addAttribute("ui.bar", "foo");
        this.inGraph.getEdge("AB").addAttribute("ui.foo", "bar");
        this.outGraph.getEdge("AB").addAttribute("ui.bar", "foo");
        Assert.assertEquals((Object)"bar", this.outGraph.getAttribute("ui.foo"));
        Assert.assertEquals((Object)"foo", this.inGraph.getAttribute("ui.bar"));
        Assert.assertEquals((Object)"bar", this.outGraph.getNode("A").getAttribute("ui.foo"));
        Assert.assertEquals((Object)"foo", this.inGraph.getNode("A").getAttribute("ui.bar"));
        Assert.assertEquals((Object)"bar", this.outGraph.getEdge("AB").getAttribute("ui.foo"));
        Assert.assertEquals((Object)"foo", this.inGraph.getEdge("AB").getAttribute("ui.bar"));
        SpriteManager sman = new SpriteManager(this.inGraph);
        Sprite s1 = sman.addSprite("S1");
        GraphicSprite gs1 = this.outGraph.getSprite("S1");
        Assert.assertNotNull((Object)gs1);
        s1.addAttribute("ui.foo", "bar");
        gs1.addAttribute("ui.bar", "foo");
        Assert.assertEquals((Object)"bar", gs1.getAttribute("ui.foo"));
        Assert.assertEquals((Object)"foo", s1.getAttribute("ui.bar"));
        s1.removeAttribute("ui.foo");
        gs1.removeAttribute("ui.bar");
        Assert.assertNull(gs1.getAttribute("ui.foo"));
        Assert.assertNull(s1.getAttribute("ui.bar"));
        GraphicSprite gs2 = this.outGraph.addSprite("S2");
        Sprite s2 = sman.getSprite("S2");
        Assert.assertNotNull((Object)s2);
        gs2.addAttribute("ui.foo", "bar");
        s2.addAttribute("ui.bar", "foo");
        Assert.assertEquals((Object)"bar", s2.getAttribute("ui.foo"));
        Assert.assertEquals((Object)"foo", gs2.getAttribute("ui.bar"));
        gs2.removeAttribute("ui.foo");
        s2.removeAttribute("ui.bar");
        Assert.assertNull(s2.getAttribute("ui.foo"));
        Assert.assertNull(gs2.getAttribute("ui.bar"));
        this.outGraph.removeSprite("S2");
        Assert.assertNull((Object)sman.getSprite("S2"));
    }
}

