/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.AccessControlException;
import java.util.HashMap;
import javax.swing.Timer;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.Source;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.layout.LayoutRunner;
import org.graphstream.ui.layout.Layouts;
import org.graphstream.ui.swingViewer.DefaultView;
import org.graphstream.ui.swingViewer.GraphRenderer;
import org.graphstream.ui.swingViewer.View;
import org.graphstream.ui.swingViewer.ViewerPipe;
import org.graphstream.ui.swingViewer.basicRenderer.SwingBasicGraphRenderer;

public class Viewer
implements ActionListener {
    public static String DEFAULT_VIEW_ID = "defaultView";
    protected boolean graphInAnotherThread = true;
    protected GraphicGraph graph;
    protected ProxyPipe pumpPipe;
    protected Source sourceInSameThread;
    protected Timer timer;
    protected int delay = 40;
    protected HashMap<String, View> views = new HashMap();
    protected CloseFramePolicy closeFramePolicy = CloseFramePolicy.EXIT;
    protected LayoutRunner optLayout = null;
    protected ProxyPipe layoutPipeIn = null;

    public Viewer(ProxyPipe source) {
        this.graphInAnotherThread = true;
        this.init(new GraphicGraph(this.newGGId()), source, null);
    }

    public Viewer(GraphicGraph graph) {
        this.graphInAnotherThread = false;
        this.init(graph, null, null);
    }

    public Viewer(Graph graph, ThreadingModel threadingModel) {
        switch (threadingModel) {
            case GRAPH_IN_SWING_THREAD: {
                this.graphInAnotherThread = false;
                this.init(new GraphicGraph(this.newGGId()), null, graph);
                this.enableXYZfeedback(true);
                break;
            }
            case GRAPH_IN_ANOTHER_THREAD: {
                this.graphInAnotherThread = true;
                ThreadProxyPipe tpp = new ThreadProxyPipe();
                tpp.init(graph, true);
                this.init(new GraphicGraph(this.newGGId()), tpp, null);
                this.enableXYZfeedback(false);
                break;
            }
            case GRAPH_ON_NETWORK: {
                throw new RuntimeException("TO DO, sorry !:-)");
            }
        }
    }

    protected String newGGId() {
        return String.format("GraphicGraph_%d", (int)(Math.random() * 10000.0));
    }

    protected void init(GraphicGraph graph, ProxyPipe ppipe, Source source) {
        this.graph = graph;
        this.pumpPipe = ppipe;
        this.sourceInSameThread = source;
        this.timer = new Timer(this.delay, this);
        assert (ppipe != null && source == null || ppipe == null && source != null);
        if (this.pumpPipe != null) {
            this.pumpPipe.addSink(graph);
        }
        if (this.sourceInSameThread != null) {
            if (source instanceof Graph) {
                this.replayGraph((Graph)source);
            }
            this.sourceInSameThread.addSink(graph);
        }
        this.timer.setCoalesce(true);
        this.timer.setRepeats(true);
        this.timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HashMap<String, View> hashMap = this.views;
        synchronized (hashMap) {
            this.disableAutoLayout();
            for (View view : this.views.values()) {
                view.close(this.graph);
            }
            this.timer.stop();
            this.timer.removeActionListener(this);
            if (this.pumpPipe != null) {
                this.pumpPipe.removeSink(this.graph);
            }
            if (this.sourceInSameThread != null) {
                this.sourceInSameThread.removeSink(this.graph);
            }
            this.graph = null;
            this.pumpPipe = null;
            this.sourceInSameThread = null;
            this.timer = null;
        }
    }

    public static GraphRenderer newGraphRenderer() {
        String rendererClassName;
        try {
            rendererClassName = System.getProperty("gs.ui.renderer");
            if (rendererClassName != null) {
                System.err.printf("\"gs.ui.renderer\" is deprecated,", new Object[0]);
                System.err.printf("use \"org.graphstream.ui.renderer\" instead\n", new Object[0]);
            } else {
                rendererClassName = System.getProperty("org.graphstream.ui.renderer");
            }
        }
        catch (AccessControlException e) {
            rendererClassName = null;
        }
        if (rendererClassName == null) {
            return new SwingBasicGraphRenderer();
        }
        try {
            Class<?> c = Class.forName(rendererClassName);
            Object object = c.newInstance();
            if (object instanceof GraphRenderer) {
                return (GraphRenderer)object;
            }
            System.err.printf("class '%s' is not a 'GraphRenderer'%n", object);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.printf("Cannot create graph renderer, 'GraphRenderer' class not found : " + e.getMessage(), new Object[0]);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.err.printf("Cannot create graph renderer, class '" + rendererClassName + "' error : " + e.getMessage(), new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.err.printf("Cannot create graph renderer, class '" + rendererClassName + "' illegal access : " + e.getMessage(), new Object[0]);
        }
        return new SwingBasicGraphRenderer();
    }

    public CloseFramePolicy getCloseFramePolicy() {
        return this.closeFramePolicy;
    }

    public ProxyPipe newThreadProxyOnGraphicGraph() {
        ThreadProxyPipe tpp = new ThreadProxyPipe();
        tpp.init(this.graph);
        return tpp;
    }

    public ViewerPipe newViewerPipe() {
        ThreadProxyPipe tpp = new ThreadProxyPipe();
        tpp.init(this.graph, false);
        this.enableXYZfeedback(true);
        return new ViewerPipe(String.format("viewer_%d", (int)(Math.random() * 10000.0)), tpp);
    }

    public GraphicGraph getGraphicGraph() {
        return this.graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getView(String id) {
        HashMap<String, View> hashMap = this.views;
        synchronized (hashMap) {
            return this.views.get(id);
        }
    }

    public View getDefaultView() {
        return this.getView(DEFAULT_VIEW_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View addDefaultView(boolean openInAFrame) {
        HashMap<String, View> hashMap = this.views;
        synchronized (hashMap) {
            DefaultView view = new DefaultView(this, DEFAULT_VIEW_ID, Viewer.newGraphRenderer());
            this.addView(view);
            if (openInAFrame) {
                ((View)view).openInAFrame(true);
            }
            return view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View addView(View view) {
        HashMap<String, View> hashMap = this.views;
        synchronized (hashMap) {
            View old = this.views.put(view.getId(), view);
            if (old != null && old != view) {
                old.close(this.graph);
            }
            return old;
        }
    }

    public View addView(String id, GraphRenderer renderer) {
        return this.addView(id, renderer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View addView(String id, GraphRenderer renderer, boolean openInAFrame) {
        HashMap<String, View> hashMap = this.views;
        synchronized (hashMap) {
            DefaultView view = new DefaultView(this, id, renderer);
            this.addView(view);
            if (openInAFrame) {
                ((View)view).openInAFrame(true);
            }
            return view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeView(String id) {
        HashMap<String, View> hashMap = this.views;
        synchronized (hashMap) {
            this.views.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        HashMap<String, View> hashMap = this.views;
        synchronized (hashMap) {
            boolean changed;
            if (this.pumpPipe != null) {
                this.pumpPipe.pump();
            }
            if (this.layoutPipeIn != null) {
                this.layoutPipeIn.pump();
            }
            if (changed = this.graph.graphChangedFlag()) {
                this.computeGraphMetrics();
                for (View view : this.views.values()) {
                    view.display(this.graph, changed);
                }
            }
            this.graph.resetGraphChangedFlag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeGraphMetrics() {
        this.graph.computeBounds();
        HashMap<String, View> hashMap = this.views;
        synchronized (hashMap) {
            Point3 lo = this.graph.getMinPos();
            Point3 hi = this.graph.getMaxPos();
            for (View view : this.views.values()) {
                view.getCamera().setBounds(lo.x, lo.y, lo.z, hi.x, hi.y, hi.z);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCloseFramePolicy(CloseFramePolicy policy) {
        HashMap<String, View> hashMap = this.views;
        synchronized (hashMap) {
            this.closeFramePolicy = policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableXYZfeedback(boolean on) {
        HashMap<String, View> hashMap = this.views;
        synchronized (hashMap) {
            this.graph.feedbackXYZ(on);
        }
    }

    public void enableAutoLayout() {
        this.enableAutoLayout(Layouts.newLayoutAlgorithm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableAutoLayout(Layout layoutAlgorithm) {
        HashMap<String, View> hashMap = this.views;
        synchronized (hashMap) {
            if (this.optLayout == null) {
                this.optLayout = new LayoutRunner(this.graph, layoutAlgorithm, true, false);
                this.graph.replay();
                this.layoutPipeIn = this.optLayout.newLayoutPipe();
                this.layoutPipeIn.addAttributeSink(this.graph);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAutoLayout() {
        HashMap<String, View> hashMap = this.views;
        synchronized (hashMap) {
            if (this.optLayout != null) {
                ((ThreadProxyPipe)this.layoutPipeIn).unregisterFromSource();
                this.layoutPipeIn.removeSink(this.graph);
                this.layoutPipeIn = null;
                this.optLayout.release();
                this.optLayout = null;
            }
        }
    }

    protected void replayGraph(Graph graph) {
        if (graph.getAttributeKeySet() != null) {
            for (String key : graph.getAttributeKeySet()) {
                this.graph.addAttribute(key, graph.getAttribute(key));
            }
        }
        for (Node node : graph) {
            Object n = this.graph.addNode(node.getId());
            if (node.getAttributeKeySet() == null) continue;
            for (String key : node.getAttributeKeySet()) {
                n.addAttribute(key, node.getAttribute(key));
            }
        }
        for (Edge edge : graph.getEachEdge()) {
            Object e = this.graph.addEdge(edge.getId(), edge.getSourceNode().getId(), edge.getTargetNode().getId(), edge.isDirected());
            if (edge.getAttributeKeySet() == null) continue;
            for (String key : edge.getAttributeKeySet()) {
                e.addAttribute(key, edge.getAttribute(key));
            }
        }
    }

    public static enum CloseFramePolicy {
        CLOSE_VIEWER,
        HIDE_ONLY,
        EXIT;

    }

    public static enum ThreadingModel {
        GRAPH_IN_SWING_THREAD,
        GRAPH_IN_ANOTHER_THREAD,
        GRAPH_ON_NETWORK;

    }
}

