/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.thread.test;

import java.io.IOException;
import java.io.StringWriter;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.file.FileSinkDGS;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.junit.Assert;
import org.junit.Test;

public class TestThreadProxyPipe {
    public static void main(String[] args) {
        new TestThreadProxyPipe();
    }

    @Test
    public void Test1_GraphToWardGraph() {
        MultiGraph source = new MultiGraph("g1");
        MultiGraph target = new MultiGraph("g2");
        source.addNode("A");
        source.addNode("B");
        source.addNode("C");
        source.addEdge("AB", "A", "B");
        source.addEdge("BC", "B", "C");
        source.addEdge("CA", "C", "A");
        source.getNode("A").addAttribute("A1", "foo");
        source.getNode("A").addAttribute("A2", "foo");
        ThreadProxyPipe proxy = new ThreadProxyPipe();
        proxy.addSink(target);
        proxy.init(source, true);
        Thread other = new Thread(new AnotherThread(this, proxy, target){

            @Override
            public void run() {
                boolean loop = true;
                do {
                    this.proxy.pump();
                    if (!this.target.hasAttribute("STOP!")) continue;
                    loop = false;
                } while (loop);
            }
        });
        other.start();
        source.addNode("X");
        source.addNode("Y");
        source.addNode("Z");
        source.addEdge("XY", "X", "Y");
        source.addEdge("YZ", "Y", "Z");
        source.addEdge("ZX", "Z", "X");
        source.addEdge("XA", "X", "A");
        source.removeEdge("AB");
        source.removeNode("B");
        source.getNode("X").addAttribute("X1", "foo");
        source.getNode("X").setAttribute("X1", "bar");
        source.getNode("A").removeAttribute("A1");
        source.addAttribute("STOP!", new Object[0]);
        try {
            other.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void test() {
        try {
            int i = 0;
            while (i < 100) {
                this.testOne();
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testOne() throws IOException {
        AdjacencyListGraph g = new AdjacencyListGraph("g");
        ThreadProxyPipe tpp = new ThreadProxyPipe();
        tpp.init(g);
        FileSinkDGS dgs1 = new FileSinkDGS();
        FileSinkDGS dgs2 = new FileSinkDGS();
        StringWriter w1 = new StringWriter();
        StringWriter w2 = new StringWriter();
        Actor a = new Actor(tpp);
        Thread t = new Thread(a);
        g.addSink(dgs1);
        tpp.addSink(dgs2);
        dgs1.begin(w1);
        dgs2.begin(w2);
        t.start();
        this.generateRandom(g, 1000);
        try {
            Thread.yield();
            a.alive = false;
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        w1.close();
        w2.close();
        String str1 = w1.toString();
        String str2 = w2.toString();
        Assert.assertTrue((str1.length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)str1, (Object)str2);
    }

    protected int ri(int size) {
        return (int)(Math.random() * (double)size);
    }

    protected Object rv() {
        int i = this.ri(3);
        switch (i) {
            case 0: {
                return this.ri(1000);
            }
            case 1: {
                return Math.random() * 1000.0;
            }
            case 2: {
                StringBuilder sb = new StringBuilder();
                String chars = "abcedfghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
                int j = 0;
                while (j < 16) {
                    sb.append(chars.charAt(this.ri(chars.length())));
                    ++j;
                }
                return sb.toString();
            }
        }
        return null;
    }

    protected void generateRandom(Graph g, int size) {
        String[] attributes = new String[]{"a", "b", "c", "d", "e", "f", "g"};
        int i = 0;
        while (i < size) {
            Object n = g.addNode(String.format("%d", i));
            int j = 0;
            while (j < 3) {
                n.setAttribute(attributes[this.ri(attributes.length)], this.rv());
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            Object b;
            Object a = g.getNode((int)(Math.random() * (double)size));
            while (a == (b = g.getNode((int)(Math.random() * (double)size)))) {
            }
            Object e = g.addEdge(String.format("edge%d", i), (Node)a, (Node)b);
            int j = 0;
            while (j < 3) {
                e.setAttribute(attributes[this.ri(attributes.length)], this.rv());
                ++j;
            }
            ++i;
        }
    }

    static class Actor
    implements Runnable {
        ThreadProxyPipe pipe;
        boolean alive;

        public Actor(ThreadProxyPipe pipe) {
            this.pipe = pipe;
            this.alive = true;
        }

        @Override
        public void run() {
            do {
                this.pipe.pump();
            } while (this.alive || this.pipe.hasPostRemaining());
        }
    }

    public abstract class AnotherThread
    implements Runnable {
        protected ThreadProxyPipe proxy;
        protected Graph target;

        public AnotherThread(ThreadProxyPipe proxy, Graph target) {
            this.proxy = proxy;
            this.target = target;
        }
    }
}

