/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.util;

import java.awt.Font;
import java.util.HashMap;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.swingViewer.util.FontSlot;

public class FontCache {
    protected Font defaultFont;
    protected HashMap<String, FontSlot> cache = new HashMap();
    public static FontCache defaultFontCache;

    public FontCache() {
        this.defaultFont = new Font("SansSerif", 0, 11);
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public static FontCache defaultFontCache() {
        if (defaultFontCache == null) {
            defaultFontCache = new FontCache();
        }
        return defaultFontCache;
    }

    public Font getDefaultFont(StyleConstants.TextStyle style, int size) {
        return this.getFont("SansSerif", style, size);
    }

    public Font getFont(String name, StyleConstants.TextStyle style, int size) {
        FontSlot slot = this.cache.get(name);
        if (slot == null) {
            slot = new FontSlot(name, style, size);
            this.cache.put(name, slot);
        }
        return slot.getFont(style, size);
    }
}

