/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout;

import java.security.AccessControlException;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.layout.springbox.implementations.SpringBox;

public class Layouts {
    public static Layout newLayoutAlgorithm() {
        String layoutClassName;
        try {
            layoutClassName = System.getProperty("gs.ui.layout");
            if (layoutClassName != null) {
                System.err.printf("\"gs.ui.layout\" is deprecated,", new Object[0]);
                System.err.printf("use \"org.graphstream.ui.layout\" instead\n", new Object[0]);
            } else {
                layoutClassName = System.getProperty("org.graphstream.ui.layout");
            }
        }
        catch (AccessControlException e) {
            layoutClassName = null;
        }
        if (layoutClassName != null) {
            try {
                Class<?> c = Class.forName(layoutClassName);
                Object object = c.newInstance();
                if (object instanceof Layout) {
                    return (Layout)object;
                }
                System.err.printf("class '%s' is not a 'GraphRenderer'%n", object);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                System.err.printf("Cannot create layout, 'GraphRenderer' class not found : " + e.getMessage(), new Object[0]);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                System.err.printf("Cannot create layout, class '" + layoutClassName + "' error : " + e.getMessage(), new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                System.err.printf("Cannot create layout, class '" + layoutClassName + "' illegal access : " + e.getMessage(), new Object[0]);
            }
        }
        return new SpringBox(false);
    }
}

