/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal;

import java.lang.reflect.Array;
import org.junit.Assert;
import org.junit.internal.ArrayComparisonFailure;

public class InexactComparisonCriteria {
    public double fDelta;

    public InexactComparisonCriteria(double delta) {
        this.fDelta = delta;
    }

    public void internalArrayEquals(String message, Object expecteds, Object actuals) throws ArrayComparisonFailure {
        if (expecteds == actuals) {
            return;
        }
        String header = message == null ? "" : message + ": ";
        int expectedsLength = Assert.assertArraysAreSameLength(expecteds, actuals, header);
        for (int i = 0; i < expectedsLength; ++i) {
            Object expected = Array.get(expecteds, i);
            Object actual = Array.get(actuals, i);
            if (Assert.isArray(expected) && Assert.isArray(actual)) {
                try {
                    this.internalArrayEquals(message, expected, actual);
                    continue;
                }
                catch (ArrayComparisonFailure e) {
                    e.addDimension(i);
                    throw e;
                }
            }
            try {
                if (expected instanceof Double) {
                    Assert.assertEquals((Double)expected, (double)((Double)actual), this.fDelta);
                    continue;
                }
                Assert.assertEquals(((Float)expected).floatValue(), (double)((Float)actual).floatValue(), this.fDelta);
                continue;
            }
            catch (AssertionError e) {
                throw new ArrayComparisonFailure(header, e, i);
            }
        }
    }
}

