/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph.parser.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.StyleGroupSet;
import org.graphstream.ui.graphicGraph.stylesheet.Rule;
import org.graphstream.ui.graphicGraph.stylesheet.StyleSheet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStyleSheet {
    Graph graph;
    Node A;
    Node B;
    Node C;
    Node D;
    Edge AB;
    Edge BC;
    Edge CD;
    Edge DA;
    StyleSheet stylesheet;
    public static String styleSheet1 = "graph            { fill-color: white,black; }node             { fill-color: blue;        }edge             { fill-color: green;       }sprite           { fill-color: cyan;        }node#A           { fill-color: magenta;     }edge#AB          { fill-color: yellow;      }node.foo         { fill-color: orange;      }node.bar         { fill-color: grey;        }node:clicked     { stroke-width: 1px;       }node#A:clicked   { stroke-width: 2px;       }node.foo:clicked { stroke-width: 3px;       }node#A:selected  { stroke-width: 4px;       }";
    public static String styleSheet2 = "node { fill-color: yellow; stroke-width: 10px; }";
    public static String styleSheet3 = "node#B { stroke-width: 5px; }";
    public static String styleSheet4 = "edge.foo { stroke-width: 2px; }";
    public static String styleSheet10 = "node.foo { fill-mode: dyn-plain; fill-color: red, green, blue; }";
    public static String styleSheet5 = "node { z-index: 1; }edge { z-index: 2; }";
    public static String styleSheet6 = "node.foo { z-index: 5; }";
    public static String styleSheet7 = "edge#DA { z-index: 7; }";
    public static String styleSheet8 = "node { shadow-mode: plain; }";
    public static String styleSheet9 = "edge#AB { shadow-mode: plain; }";

    public static void main(String[] args) {
        TestStyleSheet tss = new TestStyleSheet();
        tss.setUp();
        tss.testInitialParsing();
        tss.testRuleQuery();
        tss.testStyleGroups();
        tss.testStyleEvents();
    }

    @Before
    public void setUp() {
        this.graph = new DefaultGraph("g1");
        this.A = this.graph.addNode("A");
        this.B = this.graph.addNode("B");
        this.C = this.graph.addNode("C");
        this.D = this.graph.addNode("D");
        this.AB = this.graph.addEdge("AB", "A", "B");
        this.BC = this.graph.addEdge("BC", "B", "C");
        this.CD = this.graph.addEdge("CD", "C", "D");
        this.DA = this.graph.addEdge("DA", "D", "A");
        this.B.addAttribute("ui.class", "foo");
        this.C.addAttribute("ui.class", "foo");
        this.D.addAttribute("ui.class", "bar", "foo");
        this.AB.addAttribute("ui.class", "foo");
        this.BC.addAttribute("ui.class", "foo");
        this.stylesheet = new StyleSheet();
        try {
            this.stylesheet.parseFromString(styleSheet1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testInitialParsing() {
        Assert.assertEquals((long)0L, (long)this.stylesheet.getGraphStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getGraphStyleNameSpace().getClassRulesCount());
        Assert.assertEquals((long)1L, (long)this.stylesheet.getNodeStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)2L, (long)this.stylesheet.getNodeStyleNameSpace().getClassRulesCount());
        Assert.assertEquals((long)1L, (long)this.stylesheet.getEdgeStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getEdgeStyleNameSpace().getClassRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getSpriteStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getSpriteStyleNameSpace().getClassRulesCount());
    }

    @Test
    public void testRuleQuery() {
        ArrayList<Rule> rulesA = this.stylesheet.getRulesFor(this.A);
        String idA = this.stylesheet.getStyleGroupIdFor(this.A, rulesA);
        ArrayList<Rule> rulesB = this.stylesheet.getRulesFor(this.B);
        String idB = this.stylesheet.getStyleGroupIdFor(this.B, rulesB);
        ArrayList<Rule> rulesC = this.stylesheet.getRulesFor(this.C);
        String idC = this.stylesheet.getStyleGroupIdFor(this.C, rulesC);
        ArrayList<Rule> rulesD = this.stylesheet.getRulesFor(this.D);
        String idD = this.stylesheet.getStyleGroupIdFor(this.D, rulesD);
        ArrayList<Rule> rulesAB = this.stylesheet.getRulesFor(this.AB);
        String idAB = this.stylesheet.getStyleGroupIdFor(this.AB, rulesAB);
        ArrayList<Rule> rulesBC = this.stylesheet.getRulesFor(this.BC);
        String idBC = this.stylesheet.getStyleGroupIdFor(this.BC, rulesBC);
        ArrayList<Rule> rulesCD = this.stylesheet.getRulesFor(this.CD);
        String idCD = this.stylesheet.getStyleGroupIdFor(this.CD, rulesCD);
        ArrayList<Rule> rulesDA = this.stylesheet.getRulesFor(this.DA);
        String idDA = this.stylesheet.getStyleGroupIdFor(this.DA, rulesDA);
        Assert.assertTrue((boolean)idA.equals("n_A"));
        Assert.assertTrue((boolean)idB.equals("n(foo)"));
        Assert.assertTrue((boolean)idC.equals("n(foo)"));
        Assert.assertTrue((boolean)idD.equals("n(bar,foo)"));
        Assert.assertTrue((boolean)idAB.equals("e_AB"));
        Assert.assertTrue((boolean)idBC.equals("e"));
        Assert.assertTrue((boolean)idCD.equals("e"));
        Assert.assertTrue((boolean)idDA.equals("e"));
        System.err.printf("----%n", new Object[0]);
        System.err.printf("A %s%n", this.displayGroup(idA, rulesA));
        System.err.printf("B %s%n", this.displayGroup(idB, rulesB));
        System.err.printf("C %s%n", this.displayGroup(idC, rulesC));
        System.err.printf("D %s%n", this.displayGroup(idD, rulesD));
        System.err.printf("----%n", new Object[0]);
        System.err.printf("AB %s%n", this.displayGroup(idAB, rulesAB));
        System.err.printf("BC %s%n", this.displayGroup(idBC, rulesBC));
        System.err.printf("CD %s%n", this.displayGroup(idCD, rulesCD));
        System.err.printf("DA %s%n", this.displayGroup(idDA, rulesDA));
    }

    protected void populateGroupSet(StyleGroupSet sgs) {
        sgs.addElement(this.graph);
        sgs.addElement(this.A);
        sgs.addElement(this.B);
        sgs.addElement(this.C);
        sgs.addElement(this.D);
        sgs.addElement(this.AB);
        sgs.addElement(this.BC);
        sgs.addElement(this.CD);
        sgs.addElement(this.DA);
    }

    @Test
    public void testStyleGroups() {
        StyleGroupSet sgs = new StyleGroupSet(this.stylesheet);
        this.populateGroupSet(sgs);
        System.err.printf("There are %d groups !!%n", sgs.getGroupCount());
        Iterator<? extends StyleGroup> i = sgs.getGroupIterator();
        while (i.hasNext()) {
            System.err.printf("  %s", i.next().toString());
        }
        Assert.assertTrue((sgs.getGroupCount() == 6 ? 1 : 0) != 0);
        System.err.printf("----%n", new Object[0]);
        System.err.printf(sgs.toString(), new Object[0]);
        StyleGroup sG = sgs.getStyleForElement(this.graph);
        StyleGroup sA = sgs.getStyleForElement(this.A);
        StyleGroup sB = sgs.getStyleForElement(this.B);
        StyleGroup sC = sgs.getStyleForElement(this.C);
        StyleGroup sD = sgs.getStyleForElement(this.D);
        StyleGroup sAB = sgs.getStyleForElement(this.AB);
        StyleGroup sBC = sgs.getStyleForElement(this.BC);
        StyleGroup sCD = sgs.getStyleForElement(this.CD);
        StyleGroup sDA = sgs.getStyleForElement(this.DA);
        Assert.assertEquals((long)2L, (long)sG.getFillColorCount());
        Assert.assertEquals((long)1L, (long)sA.getFillColorCount());
        Assert.assertEquals((long)1L, (long)sB.getFillColorCount());
        Assert.assertEquals((long)1L, (long)sC.getFillColorCount());
        Assert.assertEquals((long)1L, (long)sD.getFillColorCount());
        Assert.assertTrue((sG.getFillColor(0).getRed() == 255 && sG.getFillColor(0).getGreen() == 255 && sG.getFillColor(0).getBlue() == 255 ? 1 : 0) != 0);
        Assert.assertTrue((sG.getFillColor(1).getRed() == 0 && sG.getFillColor(1).getGreen() == 0 && sG.getFillColor(1).getBlue() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sA.getFillColor(0).getRed() == 255 && sA.getFillColor(0).getGreen() == 0 && sA.getFillColor(0).getBlue() == 255 ? 1 : 0) != 0);
        Assert.assertTrue((sB.getFillColor(0).getRed() == 255 && sB.getFillColor(0).getGreen() == 165 && sB.getFillColor(0).getBlue() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sC.getFillColor(0).getRed() == 255 && sC.getFillColor(0).getGreen() == 165 && sC.getFillColor(0).getBlue() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sD.getFillColor(0).getRed() == 190 && sD.getFillColor(0).getGreen() == 190 && sD.getFillColor(0).getBlue() == 190 ? 1 : 0) != 0);
        Assert.assertEquals((double)1.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sD.getStrokeWidth().value, (double)0.0);
        Assert.assertTrue((sAB.getFillColor(0).getRed() == 255 && sAB.getFillColor(0).getGreen() == 255 && sAB.getFillColor(0).getBlue() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sBC.getFillColor(0).getRed() == 0 && sBC.getFillColor(0).getGreen() == 255 && sBC.getFillColor(0).getBlue() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sCD.getFillColor(0).getRed() == 0 && sCD.getFillColor(0).getGreen() == 255 && sCD.getFillColor(0).getBlue() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sDA.getFillColor(0).getRed() == 0 && sDA.getFillColor(0).getGreen() == 255 && sDA.getFillColor(0).getBlue() == 0 ? 1 : 0) != 0);
        sgs.release();
    }

    protected String displayGroup(String id, ArrayList<Rule> rules) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(id);
        builder.append(") ");
        builder.append(rules.size());
        builder.append(" [ ");
        int i = 0;
        while (i < rules.size()) {
            builder.append(rules.get((int)i).selector.toString());
            builder.append(" ");
            ++i;
        }
        builder.append("]");
        return builder.toString();
    }

    @Test
    public void testStyleEvents() {
        StyleGroupSet sgs = new StyleGroupSet(this.stylesheet);
        this.populateGroupSet(sgs);
        StyleGroup sA = sgs.getStyleForElement(this.A);
        StyleGroup sB = sgs.getStyleForElement(this.B);
        StyleGroup sC = sgs.getStyleForElement(this.C);
        StyleGroup sD = sgs.getStyleForElement(this.D);
        Assert.assertEquals((double)1.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sD.getStrokeWidth().value, (double)0.0);
        sgs.pushEvent("clicked");
        sA = sgs.getStyleForElement(this.A);
        sB = sgs.getStyleForElement(this.B);
        sC = sgs.getStyleForElement(this.C);
        sD = sgs.getStyleForElement(this.D);
        Assert.assertEquals((double)2.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)3.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)3.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)3.0, (double)sD.getStrokeWidth().value, (double)0.0);
        sgs.popEvent("clicked");
        sA = sgs.getStyleForElement(this.A);
        sB = sgs.getStyleForElement(this.B);
        sC = sgs.getStyleForElement(this.C);
        sD = sgs.getStyleForElement(this.D);
        Assert.assertEquals((double)1.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sD.getStrokeWidth().value, (double)0.0);
        sgs.pushEvent("clicked");
        sgs.pushEvent("selected");
        sA = sgs.getStyleForElement(this.A);
        sB = sgs.getStyleForElement(this.B);
        sC = sgs.getStyleForElement(this.C);
        sD = sgs.getStyleForElement(this.D);
        Assert.assertEquals((double)4.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)3.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)3.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)3.0, (double)sD.getStrokeWidth().value, (double)0.0);
        sgs.popEvent("clicked");
        sgs.popEvent("selected");
        sA = sgs.getStyleForElement(this.A);
        Assert.assertFalse((boolean)sA.hasEventElements());
        sgs.pushEventFor(this.A, "clicked");
        sgs.pushEventFor(this.B, "clicked");
        sA = sgs.getStyleForElement(this.A);
        sB = sgs.getStyleForElement(this.B);
        sC = sgs.getStyleForElement(this.C);
        sD = sgs.getStyleForElement(this.D);
        Assert.assertTrue((boolean)sA.hasEventElements());
        Assert.assertEquals((double)1.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sD.getStrokeWidth().value, (double)0.0);
        sA.activateEventsFor(this.A);
        Assert.assertEquals((double)2.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sD.getStrokeWidth().value, (double)0.0);
        sA.deactivateEvents();
        sB.activateEventsFor(this.B);
        Assert.assertEquals((double)1.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)3.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)3.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sD.getStrokeWidth().value, (double)0.0);
        sB.deactivateEvents();
        sgs.popEventFor(this.A, "clicked");
        sgs.popEventFor(this.B, "clicked");
        sgs.pushEventFor(this.A, "clicked");
        sgs.pushEventFor(this.A, "selected");
        sA = sgs.getStyleForElement(this.A);
        sB = sgs.getStyleForElement(this.B);
        sC = sgs.getStyleForElement(this.C);
        sD = sgs.getStyleForElement(this.D);
        Assert.assertEquals((double)1.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sD.getStrokeWidth().value, (double)0.0);
        sA.activateEventsFor(this.A);
        Assert.assertEquals((double)4.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sD.getStrokeWidth().value, (double)0.0);
        sA.deactivateEvents();
        sgs.popEventFor(this.A, "clicked");
        sgs.popEventFor(this.A, "selected");
        sgs.release();
    }

    @Test
    public void testStyleChange() throws IOException {
        StyleGroupSet sgs = new StyleGroupSet(this.stylesheet);
        this.populateGroupSet(sgs);
        Assert.assertTrue((sgs.getGroupCount() == 6 ? 1 : 0) != 0);
        this.stylesheet.parseFromString(styleSheet2);
        Assert.assertEquals((long)6L, (long)sgs.getGroupCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getGraphStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getGraphStyleNameSpace().getClassRulesCount());
        Assert.assertEquals((long)1L, (long)this.stylesheet.getNodeStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)2L, (long)this.stylesheet.getNodeStyleNameSpace().getClassRulesCount());
        Assert.assertEquals((long)1L, (long)this.stylesheet.getEdgeStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getEdgeStyleNameSpace().getClassRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getSpriteStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getSpriteStyleNameSpace().getClassRulesCount());
        StyleGroup sA = sgs.getStyleForElement(this.A);
        StyleGroup sB = sgs.getStyleForElement(this.B);
        StyleGroup sC = sgs.getStyleForElement(this.C);
        StyleGroup sD = sgs.getStyleForElement(this.D);
        Assert.assertEquals((double)10.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)10.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)10.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)10.0, (double)sD.getStrokeWidth().value, (double)0.0);
        sgs.pushEvent("clicked");
        sA = sgs.getStyleForElement(this.A);
        sB = sgs.getStyleForElement(this.B);
        sC = sgs.getStyleForElement(this.C);
        sD = sgs.getStyleForElement(this.D);
        Assert.assertEquals((double)2.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)3.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)3.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)3.0, (double)sD.getStrokeWidth().value, (double)0.0);
        sgs.popEvent("clicked");
        sA = sgs.getStyleForElement(this.A);
        sB = sgs.getStyleForElement(this.B);
        sC = sgs.getStyleForElement(this.C);
        sD = sgs.getStyleForElement(this.D);
        Assert.assertEquals((double)10.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)10.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)10.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)10.0, (double)sD.getStrokeWidth().value, (double)0.0);
        this.stylesheet.parseFromString(styleSheet3);
        Assert.assertEquals((long)7L, (long)sgs.getGroupCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getGraphStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getGraphStyleNameSpace().getClassRulesCount());
        Assert.assertEquals((long)2L, (long)this.stylesheet.getNodeStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)2L, (long)this.stylesheet.getNodeStyleNameSpace().getClassRulesCount());
        Assert.assertEquals((long)1L, (long)this.stylesheet.getEdgeStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getEdgeStyleNameSpace().getClassRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getSpriteStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getSpriteStyleNameSpace().getClassRulesCount());
        sA = sgs.getStyleForElement(this.A);
        sB = sgs.getStyleForElement(this.B);
        sC = sgs.getStyleForElement(this.C);
        sD = sgs.getStyleForElement(this.D);
        Assert.assertEquals((double)10.0, (double)sA.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)5.0, (double)sB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)10.0, (double)sC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)10.0, (double)sD.getStrokeWidth().value, (double)0.0);
        this.stylesheet.parseFromString(styleSheet4);
        Assert.assertEquals((long)8L, (long)sgs.getGroupCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getGraphStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getGraphStyleNameSpace().getClassRulesCount());
        Assert.assertEquals((long)2L, (long)this.stylesheet.getNodeStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)2L, (long)this.stylesheet.getNodeStyleNameSpace().getClassRulesCount());
        Assert.assertEquals((long)1L, (long)this.stylesheet.getEdgeStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)1L, (long)this.stylesheet.getEdgeStyleNameSpace().getClassRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getSpriteStyleNameSpace().getIdRulesCount());
        Assert.assertEquals((long)0L, (long)this.stylesheet.getSpriteStyleNameSpace().getClassRulesCount());
        StyleGroup sAB = sgs.getStyleForElement(this.AB);
        StyleGroup sBC = sgs.getStyleForElement(this.BC);
        StyleGroup sCD = sgs.getStyleForElement(this.CD);
        StyleGroup sDA = sgs.getStyleForElement(this.DA);
        Assert.assertEquals((double)2.0, (double)sAB.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)2.0, (double)sBC.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sCD.getStrokeWidth().value, (double)0.0);
        Assert.assertEquals((double)1.0, (double)sDA.getStrokeWidth().value, (double)0.0);
        System.err.printf("After adding new style sheets, there are %d groups !!%n", sgs.getGroupCount());
        Iterator<? extends StyleGroup> i = sgs.getGroupIterator();
        while (i.hasNext()) {
            System.err.printf("  %s", i.next().toString());
        }
        sgs.release();
    }

    @Test
    public void testZIndex() throws IOException {
        StyleGroupSet sgs = new StyleGroupSet(this.stylesheet);
        this.populateGroupSet(sgs);
        Assert.assertTrue((sgs.getGroupCount() == 6 ? 1 : 0) != 0);
        Iterator<HashSet<StyleGroup>> zIndex = sgs.getZIterator();
        HashSet<String> groups1 = new HashSet<String>();
        HashSet<String> groups2 = new HashSet<String>();
        HashSet<String> groups3 = new HashSet<String>();
        HashSet<String> groups4 = new HashSet<String>();
        HashSet<String> groups5 = new HashSet<String>();
        groups1.add("g");
        groups2.add("e");
        groups2.add("e_AB");
        groups3.add("n_A");
        groups3.add("n(foo)");
        groups3.add("n(bar,foo)");
        System.err.printf("---- zIndex ----%n", new Object[0]);
        Assert.assertTrue((boolean)zIndex.hasNext());
        HashSet<StyleGroup> cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups1.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups2.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups3.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 2 ? 1 : 0) != 0);
        }
        Assert.assertTrue((!zIndex.hasNext() ? 1 : 0) != 0);
        System.err.printf("The Z index is :%n", new Object[0]);
        System.err.printf("%s", sgs.getZIndex().toString());
        System.err.printf("---- zIndex 2 ----%n", new Object[0]);
        this.stylesheet.parseFromString(styleSheet5);
        Assert.assertTrue((sgs.getGroupCount() == 6 ? 1 : 0) != 0);
        zIndex = sgs.getZIterator();
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups1.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups3.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups2.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 2 ? 1 : 0) != 0);
        }
        Assert.assertTrue((!zIndex.hasNext() ? 1 : 0) != 0);
        System.err.printf("The Z index is : %n", new Object[0]);
        System.err.printf("%s", sgs.getZIndex().toString());
        System.err.printf("---- zIndex 3 ----%n", new Object[0]);
        this.stylesheet.parseFromString(styleSheet6);
        Assert.assertTrue((sgs.getGroupCount() == 6 ? 1 : 0) != 0);
        groups2.clear();
        groups3.clear();
        groups2.add("n_A");
        groups3.add("e");
        groups3.add("e_AB");
        groups4.add("n(bar,foo)");
        groups4.add("n(foo)");
        zIndex = sgs.getZIterator();
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups1.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups2.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups3.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 2 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups4.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 5 ? 1 : 0) != 0);
        }
        Assert.assertTrue((!zIndex.hasNext() ? 1 : 0) != 0);
        System.err.printf("The Z index is : %n", new Object[0]);
        System.err.printf("%s", sgs.getZIndex().toString());
        System.err.printf("---- zIndex 4 ----%n", new Object[0]);
        this.stylesheet.parseFromString(styleSheet7);
        Assert.assertTrue((sgs.getGroupCount() == 7 ? 1 : 0) != 0);
        groups5.add("e_DA");
        zIndex = sgs.getZIterator();
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups1.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups2.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups3.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 2 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups4.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 5 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)zIndex.hasNext());
        cell = zIndex.next();
        for (StyleGroup g : cell) {
            Assert.assertTrue((boolean)groups5.contains(g.getId()));
            Assert.assertTrue((g.getZIndex() == 7 ? 1 : 0) != 0);
        }
        System.err.printf("The Z index is : %n", new Object[0]);
        System.err.printf("%s", sgs.getZIndex().toString());
    }

    @Test
    public void testShadow() throws IOException {
        StyleGroup g;
        StyleGroupSet sgs = new StyleGroupSet(this.stylesheet);
        this.populateGroupSet(sgs);
        Iterator<StyleGroup> shadow = sgs.getShadowIterator();
        int count = 0;
        while (shadow.hasNext()) {
            shadow.next();
            ++count;
        }
        Assert.assertTrue((count == 0 ? 1 : 0) != 0);
        this.stylesheet.parseFromString(styleSheet8);
        Assert.assertTrue((sgs.getGroupCount() == 6 ? 1 : 0) != 0);
        HashSet<String> groups = new HashSet<String>();
        groups.add("n_A");
        groups.add("n(bar,foo)");
        groups.add("n(foo)");
        shadow = sgs.getShadowIterator();
        count = 0;
        while (shadow.hasNext()) {
            g = shadow.next();
            Assert.assertTrue((boolean)groups.contains(g.getId()));
            ++count;
        }
        Assert.assertTrue((count == 3 ? 1 : 0) != 0);
        this.stylesheet.parseFromString(styleSheet9);
        Assert.assertTrue((sgs.getGroupCount() == 6 ? 1 : 0) != 0);
        groups.add("e_AB");
        shadow = sgs.getShadowIterator();
        count = 0;
        while (shadow.hasNext()) {
            g = shadow.next();
            Assert.assertTrue((boolean)groups.contains(g.getId()));
            ++count;
        }
        Assert.assertTrue((count == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testStyleGroupIterators() {
        try {
            this.stylesheet.parseFromString(styleSheet10);
        }
        catch (IOException e) {
            Assert.assertFalse((boolean)true);
        }
        StyleGroupSet sgs = new StyleGroupSet(this.stylesheet);
        this.populateGroupSet(sgs);
        StyleGroup sA = sgs.getStyleForElement(this.A);
        StyleGroup sB = sgs.getStyleForElement(this.B);
        StyleGroup sC = sgs.getStyleForElement(this.C);
        StyleGroup sD = sgs.getStyleForElement(this.D);
        Assert.assertTrue((sB == sC ? 1 : 0) != 0);
        Assert.assertFalse((sA == sB ? 1 : 0) != 0);
        Assert.assertFalse((sB == sD ? 1 : 0) != 0);
        HashSet<String> expected = new HashSet<String>();
        expected.add("B");
        expected.add("C");
        for (Element element : sB) {
            Assert.assertTrue((boolean)expected.contains(element.getId()));
            expected.remove(element.getId());
        }
        Assert.assertEquals((long)0L, (long)expected.size());
        this.B.addAttribute("ui.color", 2);
        sgs.pushEventFor(this.B, "clicked");
        sgs.pushElementAsDynamic(this.B);
        sA = sgs.getStyleForElement(this.A);
        sB = sgs.getStyleForElement(this.B);
        sC = sgs.getStyleForElement(this.C);
        sD = sgs.getStyleForElement(this.D);
        Assert.assertTrue((sB == sC ? 1 : 0) != 0);
        Assert.assertFalse((sA == sB ? 1 : 0) != 0);
        Assert.assertFalse((sB == sD ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sB.elementHasEvents(this.B));
        Assert.assertTrue((boolean)sB.elementIsDynamic(this.B));
        expected.add("B");
        for (Element element : sB.dynamicElements()) {
            Assert.assertTrue((boolean)expected.contains(element.getId()));
            expected.remove(element.getId());
        }
        Assert.assertEquals((long)0L, (long)expected.size());
        expected.add("B");
        for (StyleGroup.ElementEvents elementEvents : sB.elementsEvents()) {
            Assert.assertTrue((boolean)expected.contains(elementEvents.getElement().getId()));
            Assert.assertEquals((long)1L, (long)elementEvents.events().length);
            Assert.assertEquals((Object)"clicked", (Object)elementEvents.events()[0]);
            expected.remove(elementEvents.getElement().getId());
        }
        Assert.assertEquals((long)0L, (long)expected.size());
        expected.add("C");
        for (Element element : sB.bulkElements()) {
            Assert.assertTrue((boolean)expected.contains(element.getId()));
            expected.remove(element.getId());
        }
        Assert.assertEquals((long)0L, (long)expected.size());
        sgs.popEventFor(this.B, "clicked");
    }
}

