/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.file.FileSink;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.StyleGroupSet;
import org.graphstream.ui.graphicGraph.stylesheet.Colors;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.StyleSheet;
import org.graphstream.ui.graphicGraph.stylesheet.Value;
import org.graphstream.ui.graphicGraph.stylesheet.Values;

public class FileSinkSVG2
implements FileSink {
    @Override
    public void begin(String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void begin(OutputStream stream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void begin(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void end() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void writeAll(Graph graph, String fileName) throws IOException {
        FileWriter out = new FileWriter(fileName);
        this.writeAll(graph, out);
        out.close();
    }

    @Override
    public void writeAll(Graph graph, OutputStream stream) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(stream);
        this.writeAll(graph, out);
    }

    @Override
    public void writeAll(Graph g, Writer w) throws IOException {
        XMLWriter out = new XMLWriter();
        SVGContext ctx = new SVGContext();
        try {
            out.start(w);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        try {
            ctx.init(out, g);
            ctx.writeElements(out, g);
            ctx.end(out);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        try {
            out.end();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private static String d(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }

    private static double getX(Node n) {
        Object[] xyz;
        Object[] xy;
        if (n.hasNumber("x")) {
            return n.getNumber("x");
        }
        if (n.hasArray("xy") && (xy = n.getArray("xy")) != null && xy.length > 0 && xy[0] instanceof Number) {
            return ((Number)xy[0]).doubleValue();
        }
        if (n.hasArray("xyz") && (xyz = n.getArray("xyz")) != null && xyz.length > 0 && xyz[0] instanceof Number) {
            return ((Number)xyz[0]).doubleValue();
        }
        System.err.printf("[WARNING] no x attribute for node \"%s\" %s\n", n.getId(), n.hasAttribute("xyz"));
        return Math.random();
    }

    private static double getY(Node n) {
        Object[] xyz;
        Object[] xy;
        if (n.hasNumber("y")) {
            return n.getNumber("y");
        }
        if (n.hasArray("xy") && (xy = n.getArray("xy")) != null && xy.length > 1 && xy[1] instanceof Number) {
            return ((Number)xy[1]).doubleValue();
        }
        if (n.hasArray("xyz") && (xyz = n.getArray("xyz")) != null && xyz.length > 1 && xyz[1] instanceof Number) {
            return ((Number)xyz[1]).doubleValue();
        }
        return Math.random();
    }

    private static String getSize(Value v) {
        String u = v.units.name().toLowerCase();
        return String.format(Locale.ROOT, "%f%s", v.value, u);
    }

    private static String getSize(Values v, int index) {
        String u = v.units.name().toLowerCase();
        return String.format(Locale.ROOT, "%f%s", v.get(index), u);
    }

    private static void concat(StringBuilder buffer, Object ... args) {
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                buffer.append(args[i].toString());
                ++i;
            }
        }
    }

    private static String toHexColor(Color c) {
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
    }

    static class SVGContext {
        StyleGroupSet groups;
        StyleSheet stylesheet = new StyleSheet();
        HashMap<StyleGroup, SVGStyle> svgStyles;
        ViewBox viewBox;

        public SVGContext() {
            this.groups = new StyleGroupSet(this.stylesheet);
            this.svgStyles = new HashMap();
            this.viewBox = new ViewBox(0.0, 0.0, 1000.0, 1000.0);
        }

        public void init(XMLWriter out, Graph g) throws IOException, XMLStreamException {
            if (g.hasAttribute("ui.stylesheet")) {
                this.stylesheet.load((String)g.getAttribute("ui.stylesheet"));
            }
            this.groups.addElement(g);
            this.viewBox.compute(g, this.groups.getStyleFor(g));
            out.open("svg");
            out.attribute("xmlns", "http://www.w3.org/2000/svg");
            out.attribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
            out.attribute("xmlns:cc", "http://creativecommons.org/ns#");
            out.attribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            out.attribute("xmlns:svg", "http://www.w3.org/2000/svg");
            out.attribute("viewBox", String.format(Locale.ROOT, "%f %f %f %f", this.viewBox.x1, this.viewBox.y1, this.viewBox.x2, this.viewBox.y2));
            out.attribute("id", g.getId());
            out.attribute("version", "1.1");
            for (Edge edge : g.getEachEdge()) {
                this.groups.addElement(edge);
                if (edge.hasAttribute("ui.style")) {
                    this.stylesheet.parseStyleFromString(new Selector(Selector.Type.EDGE, edge.getId(), null), (String)edge.getAttribute("ui.style"));
                }
                this.groups.checkElementStyleGroup(edge);
            }
            for (Node node : g.getEachNode()) {
                this.groups.addElement(node);
                if (node.hasAttribute("ui.style")) {
                    this.stylesheet.parseStyleFromString(new Selector(Selector.Type.NODE, node.getId(), null), (String)node.getAttribute("ui.style"));
                }
                this.groups.checkElementStyleGroup(node);
            }
            for (StyleGroup styleGroup : this.groups.groups()) {
                this.svgStyles.put(styleGroup, new SVGStyle(styleGroup));
            }
            out.open("defs");
            for (SVGStyle sVGStyle : this.svgStyles.values()) {
                sVGStyle.writeDef(out);
            }
            out.close();
        }

        public void end(XMLWriter out) throws XMLStreamException {
            out.close();
        }

        public void writeElements(XMLWriter out, Graph g) throws XMLStreamException {
            out.open("g");
            out.attribute("id", "graph-misc");
            this.writeElement(out, g);
            out.close();
            Iterator<HashSet<StyleGroup>> it = this.groups.getZIterator();
            out.open("g");
            out.attribute("id", "elements");
            while (it.hasNext()) {
                HashSet<StyleGroup> set = it.next();
                for (StyleGroup sg : set) {
                    for (Element element : sg.elements()) {
                        this.writeElement(out, element);
                    }
                }
            }
            out.close();
        }

        public void writeElement(XMLWriter out, Element e) throws XMLStreamException {
            String id = "";
            SVGStyle style = null;
            String transform = null;
            if (e instanceof Edge) {
                id = String.format("egde-%s", e.getId());
                style = this.svgStyles.get(this.groups.getStyleFor((Edge)e));
            } else if (e instanceof Node) {
                id = String.format("node-%s", e.getId());
                style = this.svgStyles.get(this.groups.getStyleFor((Node)e));
                transform = String.format(Locale.ROOT, "translate(%f,%f)", this.viewBox.convertX((Node)e), this.viewBox.convertY((Node)e));
            } else if (e instanceof Graph) {
                id = "graph-background";
                style = this.svgStyles.get(this.groups.getStyleFor((Graph)e));
            }
            out.open("g");
            out.attribute("id", id);
            out.open("path");
            if (style != null) {
                out.attribute("style", style.getElementStyle(e));
            }
            if (transform != null) {
                out.attribute("transform", transform);
            }
            out.attribute("d", this.getPath(e, style));
            out.close();
            if (e.hasLabel("label")) {
                this.writeElementText(out, (String)e.getAttribute("label"), e, style.group);
            }
            out.close();
        }

        public void writeElementText(XMLWriter out, String text, Element e, StyleGroup style) throws XMLStreamException {
            if (style == null || style.getTextVisibilityMode() != StyleConstants.TextVisibilityMode.HIDDEN) {
                double x = 0.0;
                double y = 0.0;
                if (e instanceof Node) {
                    x = this.viewBox.convertX((Node)e);
                    y = this.viewBox.convertY((Node)e);
                } else if (e instanceof Edge) {
                    Object n0 = ((Edge)e).getNode0();
                    Object n1 = ((Edge)e).getNode0();
                    x = this.viewBox.convertX((FileSinkSVG2.getX(n0) + FileSinkSVG2.getX(n1)) / 2.0);
                    y = this.viewBox.convertY((FileSinkSVG2.getY(n0) + FileSinkSVG2.getY(n1)) / 2.0);
                }
                out.open("g");
                out.open("text");
                out.attribute("x", FileSinkSVG2.d(x));
                out.attribute("y", FileSinkSVG2.d(y));
                if (style != null) {
                    if (style.getTextColorCount() > 0) {
                        out.attribute("fill", FileSinkSVG2.toHexColor(style.getTextColor(0)));
                    }
                    switch (style.getTextAlignment()) {
                        case CENTER: {
                            out.attribute("text-anchor", "middle");
                            out.attribute("alignment-baseline", "central");
                            break;
                        }
                        case LEFT: {
                            out.attribute("text-anchor", "start");
                            break;
                        }
                        case RIGHT: {
                            out.attribute("text-anchor", "end");
                            break;
                        }
                    }
                    switch (style.getTextSize().units) {
                        case PX: 
                        case GU: {
                            out.attribute("font-size", FileSinkSVG2.d(style.getTextSize().value));
                            break;
                        }
                        case PERCENTS: {
                            out.attribute("font-size", String.valueOf(FileSinkSVG2.d(style.getTextSize().value)) + "%");
                        }
                    }
                    if (style.getTextFont() != null) {
                        out.attribute("font-family", style.getTextFont());
                    }
                    switch (style.getTextStyle()) {
                        case NORMAL: {
                            break;
                        }
                        case ITALIC: {
                            out.attribute("font-style", "italic");
                            break;
                        }
                        case BOLD: {
                            out.attribute("font-weight", "bold");
                            break;
                        }
                        case BOLD_ITALIC: {
                            out.attribute("font-weight", "bold");
                            out.attribute("font-style", "italic");
                        }
                    }
                }
                out.characters(text);
                out.close();
                out.close();
            }
        }

        public String getPath(Element e, SVGStyle style) {
            StringBuilder buffer = new StringBuilder();
            if (e instanceof Node) {
                Values size = style.group.getSize();
                double sx = this.getValue(size.get(0), size.units, true);
                double sy = size.getValueCount() > 1 ? this.getValue(size.get(1), size.units, false) : this.getValue(size.get(0), size.units, false);
                switch (style.group.getShape()) {
                    case ROUNDED_BOX: {
                        double rx = Math.min(5.0, sx / 2.0);
                        double ry = Math.min(5.0, sy / 2.0);
                        FileSinkSVG2.concat(buffer, new Object[]{" m ", FileSinkSVG2.d(-sx / 2.0 + rx), " ", FileSinkSVG2.d(-sy / 2.0)});
                        FileSinkSVG2.concat(buffer, new Object[]{" h ", FileSinkSVG2.d(sx - 2.0 * rx)});
                        FileSinkSVG2.concat(buffer, new Object[]{" a ", FileSinkSVG2.d(rx), ",", FileSinkSVG2.d(ry), " 0 0 1 ", FileSinkSVG2.d(rx), ",", FileSinkSVG2.d(ry)});
                        FileSinkSVG2.concat(buffer, new Object[]{" v ", FileSinkSVG2.d(sy - 2.0 * ry)});
                        FileSinkSVG2.concat(buffer, new Object[]{" a ", FileSinkSVG2.d(rx), ",", FileSinkSVG2.d(ry), " 0 0 1 -", FileSinkSVG2.d(rx), ",", FileSinkSVG2.d(ry)});
                        FileSinkSVG2.concat(buffer, new Object[]{" h ", FileSinkSVG2.d(-sx + 2.0 * rx)});
                        FileSinkSVG2.concat(buffer, new Object[]{" a ", FileSinkSVG2.d(rx), ",", FileSinkSVG2.d(ry), " 0 0 1 -", FileSinkSVG2.d(rx), ",-", FileSinkSVG2.d(ry)});
                        FileSinkSVG2.concat(buffer, new Object[]{" v ", FileSinkSVG2.d(-sy + 2.0 * ry)});
                        FileSinkSVG2.concat(buffer, new Object[]{" a ", FileSinkSVG2.d(rx), ",", FileSinkSVG2.d(ry), " 0 0 1 ", FileSinkSVG2.d(rx), "-", FileSinkSVG2.d(ry)});
                        FileSinkSVG2.concat(buffer, new Object[]{" z"});
                        break;
                    }
                    case BOX: {
                        FileSinkSVG2.concat(buffer, new Object[]{" m ", FileSinkSVG2.d(-sx / 2.0), " ", FileSinkSVG2.d(-sy / 2.0)});
                        FileSinkSVG2.concat(buffer, new Object[]{" h ", FileSinkSVG2.d(sx)});
                        FileSinkSVG2.concat(buffer, new Object[]{" v ", FileSinkSVG2.d(sy)});
                        FileSinkSVG2.concat(buffer, new Object[]{" h ", FileSinkSVG2.d(-sx)});
                        FileSinkSVG2.concat(buffer, new Object[]{" z"});
                        break;
                    }
                    case DIAMOND: {
                        FileSinkSVG2.concat(buffer, new Object[]{" m ", FileSinkSVG2.d(-sx / 2.0), " 0"});
                        FileSinkSVG2.concat(buffer, new Object[]{" l ", FileSinkSVG2.d(sx / 2.0), " ", FileSinkSVG2.d(-sy / 2.0)});
                        FileSinkSVG2.concat(buffer, new Object[]{" l ", FileSinkSVG2.d(sx / 2.0), " ", FileSinkSVG2.d(sy / 2.0)});
                        FileSinkSVG2.concat(buffer, new Object[]{" l ", FileSinkSVG2.d(-sx / 2.0), " ", FileSinkSVG2.d(sy / 2.0)});
                        FileSinkSVG2.concat(buffer, new Object[]{" z"});
                        break;
                    }
                    case TRIANGLE: {
                        FileSinkSVG2.concat(buffer, new Object[]{" m ", FileSinkSVG2.d(0.0), " ", FileSinkSVG2.d(-sy / 2.0)});
                        FileSinkSVG2.concat(buffer, new Object[]{" l ", FileSinkSVG2.d(sx / 2.0), " ", FileSinkSVG2.d(sy)});
                        FileSinkSVG2.concat(buffer, new Object[]{" h ", FileSinkSVG2.d(-sx)});
                        FileSinkSVG2.concat(buffer, new Object[]{" z"});
                        break;
                    }
                    default: {
                        FileSinkSVG2.concat(buffer, new Object[]{" m ", FileSinkSVG2.d(-sx / 2.0), " 0"});
                        FileSinkSVG2.concat(buffer, new Object[]{" a ", FileSinkSVG2.d(sx / 2.0), ",", FileSinkSVG2.d(sy / 2.0), " 0 1 0 ", FileSinkSVG2.d(sx), ",0"});
                        FileSinkSVG2.concat(buffer, new Object[]{" ", FileSinkSVG2.d(sx / 2.0), ",", FileSinkSVG2.d(sy / 2.0), " 0 1 0 -", FileSinkSVG2.d(sx), ",0"});
                        FileSinkSVG2.concat(buffer, new Object[]{" z"});
                        break;
                    }
                }
            } else if (e instanceof Graph) {
                FileSinkSVG2.concat(buffer, new Object[]{" M ", FileSinkSVG2.d(this.viewBox.x1), " ", FileSinkSVG2.d(this.viewBox.y1)});
                FileSinkSVG2.concat(buffer, new Object[]{" L ", FileSinkSVG2.d(this.viewBox.x2), " ", FileSinkSVG2.d(this.viewBox.y1)});
                FileSinkSVG2.concat(buffer, new Object[]{" L ", FileSinkSVG2.d(this.viewBox.x2), " ", FileSinkSVG2.d(this.viewBox.y2)});
                FileSinkSVG2.concat(buffer, new Object[]{" L ", FileSinkSVG2.d(this.viewBox.x1), " ", FileSinkSVG2.d(this.viewBox.y2)});
                FileSinkSVG2.concat(buffer, new Object[]{" Z"});
            } else if (e instanceof Edge) {
                Object src = ((Edge)e).getSourceNode();
                Object trg = ((Edge)e).getTargetNode();
                double x1 = this.viewBox.convertX((Node)src);
                double y1 = this.viewBox.convertY((Node)src);
                double x2 = this.viewBox.convertX((Node)trg);
                double y2 = this.viewBox.convertY((Node)trg);
                FileSinkSVG2.concat(buffer, new Object[]{" M ", FileSinkSVG2.d(x1), " ", FileSinkSVG2.d(y1)});
                FileSinkSVG2.concat(buffer, new Object[]{" L ", FileSinkSVG2.d(x2), " ", FileSinkSVG2.d(y2)});
            }
            return buffer.toString();
        }

        public double getValue(Value v, boolean horizontal) {
            return this.getValue(v.value, v.units, horizontal);
        }

        public double getValue(double d, StyleConstants.Units units, boolean horizontal) {
            switch (units) {
                case PX: {
                    return d;
                }
                case GU: {
                    return d;
                }
                case PERCENTS: {
                    if (horizontal) {
                        return (this.viewBox.x2 - this.viewBox.x1) * d / 100.0;
                    }
                    return (this.viewBox.y2 - this.viewBox.y1) * d / 100.0;
                }
            }
            return d;
        }
    }

    static class SVGStyle {
        static int gradientId = 0;
        String style;
        StyleGroup group;
        boolean gradient;
        boolean dynfill;

        public SVGStyle(StyleGroup group) throws XMLStreamException {
            this.group = group;
            this.gradient = false;
            this.dynfill = false;
            switch (group.getType()) {
                case EDGE: {
                    this.buildEdgeStyle();
                    break;
                }
                case NODE: {
                    this.buildNodeStyle();
                    break;
                }
                case GRAPH: {
                    this.buildGraphStyle();
                    break;
                }
            }
        }

        void buildNodeStyle() {
            StringBuilder styleSB = new StringBuilder();
            switch (this.group.getFillMode()) {
                case GRADIENT_RADIAL: 
                case GRADIENT_HORIZONTAL: 
                case GRADIENT_VERTICAL: 
                case GRADIENT_DIAGONAL1: 
                case GRADIENT_DIAGONAL2: {
                    FileSinkSVG2.concat(styleSB, new Object[]{"fill:url(#%gradient-id%);"});
                    this.gradient = true;
                    break;
                }
                case PLAIN: {
                    FileSinkSVG2.concat(styleSB, new Object[]{"fill:", FileSinkSVG2.toHexColor(this.group.getFillColor(0)), ";"});
                    FileSinkSVG2.concat(styleSB, new Object[]{"fill-opacity:", FileSinkSVG2.d((double)this.group.getFillColor(0).getAlpha() / 255.0), ";"});
                    break;
                }
                case DYN_PLAIN: {
                    this.dynfill = true;
                    FileSinkSVG2.concat(styleSB, new Object[]{"fill:%fill-color%;"});
                    FileSinkSVG2.concat(styleSB, new Object[]{"fill-opacity:%fill-opacity%;"});
                    break;
                }
            }
            FileSinkSVG2.concat(styleSB, new Object[]{"fill-rule:nonzero;"});
            if (this.group.getStrokeMode() != StyleConstants.StrokeMode.NONE) {
                FileSinkSVG2.concat(styleSB, new Object[]{"stroke:", FileSinkSVG2.toHexColor(this.group.getStrokeColor(0)), ";"});
                FileSinkSVG2.concat(styleSB, new Object[]{"stroke-width:", FileSinkSVG2.getSize(this.group.getStrokeWidth()), ";"});
            }
            this.style = styleSB.toString();
        }

        void buildGraphStyle() {
            this.buildNodeStyle();
        }

        void buildEdgeStyle() {
            StringBuilder styleSB = new StringBuilder();
            switch (this.group.getFillMode()) {
                case GRADIENT_RADIAL: 
                case GRADIENT_HORIZONTAL: 
                case GRADIENT_VERTICAL: 
                case GRADIENT_DIAGONAL1: 
                case GRADIENT_DIAGONAL2: {
                    FileSinkSVG2.concat(styleSB, new Object[]{"stroke:url(#%gradient-id%);"});
                    this.gradient = true;
                    break;
                }
                case PLAIN: 
                case DYN_PLAIN: {
                    FileSinkSVG2.concat(styleSB, new Object[]{"stroke:", FileSinkSVG2.toHexColor(this.group.getFillColor(0)), ";"});
                    break;
                }
            }
            FileSinkSVG2.concat(styleSB, new Object[]{"stroke-width:", FileSinkSVG2.getSize(this.group.getSize(), 0), ";"});
            this.style = styleSB.toString();
        }

        public void writeDef(XMLWriter out) throws XMLStreamException {
            if (this.gradient) {
                String gid = String.format("gradient%x", gradientId++);
                String type = "linearGradient";
                String x1 = null;
                String x2 = null;
                String y1 = null;
                String y2 = null;
                switch (this.group.getFillMode()) {
                    case GRADIENT_RADIAL: {
                        type = "radialGradient";
                        break;
                    }
                    case GRADIENT_HORIZONTAL: {
                        x1 = "0%";
                        y1 = "50%";
                        x2 = "100%";
                        y2 = "50%";
                        break;
                    }
                    case GRADIENT_VERTICAL: {
                        x1 = "50%";
                        y1 = "0%";
                        x2 = "50%";
                        y2 = "100%";
                        break;
                    }
                    case GRADIENT_DIAGONAL1: {
                        x1 = "0%";
                        y1 = "0%";
                        x2 = "100%";
                        y2 = "100%";
                        break;
                    }
                    case GRADIENT_DIAGONAL2: {
                        x1 = "100%";
                        y1 = "100%";
                        x2 = "0%";
                        y2 = "0%";
                        break;
                    }
                }
                out.open(type);
                out.attribute("id", gid);
                out.attribute("gradientUnits", "objectBoundingBox");
                if (type.equals("linearGradient")) {
                    out.attribute("x1", x1);
                    out.attribute("y1", y1);
                    out.attribute("x2", x2);
                    out.attribute("y2", y2);
                }
                int i = 0;
                while (i < this.group.getFillColorCount()) {
                    out.open("stop");
                    out.attribute("stop-color", FileSinkSVG2.toHexColor(this.group.getFillColor(i)));
                    out.attribute("stop-opacity", FileSinkSVG2.d((double)this.group.getFillColor(i).getAlpha() / 255.0));
                    out.attribute("offset", Double.toString((double)i / (double)(this.group.getFillColorCount() - 1)));
                    out.close();
                    ++i;
                }
                out.close();
                this.style = this.style.replace("%gradient-id%", gid);
            }
        }

        public String getElementStyle(Element e) {
            String st = this.style;
            if (this.dynfill && this.group.getFillColorCount() > 1) {
                double d = e.hasNumber("ui.color") ? e.getNumber("ui.color") : 0.0;
                Colors colors = this.group.getFillColors();
                int s = Math.min((int)(d * (double)this.group.getFillColorCount()), colors.size() - 2);
                double a = (double)s / (double)(colors.size() - 1);
                double b = (double)(s + 1) / (double)(colors.size() - 1);
                d = (d - a) / (b - a);
                Color c1 = (Color)colors.get(s);
                Color c2 = (Color)colors.get(s + 1);
                String color = String.format("#%02x%02x%02x", (int)((double)c1.getRed() + d * (double)(c2.getRed() - c1.getRed())), (int)((double)c1.getGreen() + d * (double)(c2.getGreen() - c1.getGreen())), (int)((double)c1.getBlue() + d * (double)(c2.getBlue() - c1.getBlue())));
                String opacity = Double.toString(((double)c1.getAlpha() + d * (double)(c2.getAlpha() - c1.getAlpha())) / 255.0);
                st = st.replace("%fill-color%", color);
                st = st.replace("%fill-opacity%", opacity);
            }
            return st;
        }
    }

    static class ViewBox {
        double x1;
        double y1;
        double x2;
        double y2;
        double x3;
        double y3;
        double x4;
        double y4;
        double[] padding = new double[]{0.0, 0.0};

        ViewBox(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        void compute(Graph g, StyleGroup style) {
            this.y3 = Double.MAX_VALUE;
            this.x3 = Double.MAX_VALUE;
            this.y4 = Double.MIN_VALUE;
            this.x4 = Double.MIN_VALUE;
            for (Node n : g.getEachNode()) {
                this.x3 = Math.min(this.x3, FileSinkSVG2.getX(n));
                this.y3 = Math.min(this.y3, FileSinkSVG2.getY(n));
                this.x4 = Math.max(this.x4, FileSinkSVG2.getX(n));
                this.y4 = Math.max(this.y4, FileSinkSVG2.getY(n));
            }
            Values v = style.getPadding();
            if (v.getValueCount() > 0) {
                this.padding[0] = v.get(0);
                this.padding[1] = v.getValueCount() > 1 ? v.get(1) : v.get(0);
            }
        }

        double convertX(double x) {
            return (this.x2 - this.x1 - 2.0 * this.padding[0]) * (x - this.x3) / (this.x4 - this.x3) + this.x1 + this.padding[0];
        }

        double convertX(Node n) {
            return this.convertX(FileSinkSVG2.getX(n));
        }

        double convertY(double y) {
            return (this.y2 - this.y1 - 2.0 * this.padding[1]) * (y - this.y3) / (this.y4 - this.y3) + this.y1 + this.padding[1];
        }

        double convertY(Node n) {
            return this.convertY(FileSinkSVG2.getY(n));
        }
    }

    static class XMLWriter {
        XMLStreamWriter out;
        int depth;
        boolean closed;

        XMLWriter() {
        }

        void start(Writer w) throws XMLStreamException, FactoryConfigurationError, IOException {
            if (this.out != null) {
                this.end();
            }
            this.out = XMLOutputFactory.newInstance().createXMLStreamWriter(w);
            this.out.writeStartDocument();
        }

        void end() throws XMLStreamException {
            this.out.writeEndDocument();
            this.out.flush();
            this.out.close();
            this.out = null;
        }

        void open(String name) throws XMLStreamException {
            this.out.writeCharacters("\n");
            int i = 0;
            while (i < this.depth) {
                this.out.writeCharacters("  ");
                ++i;
            }
            this.out.writeStartElement(name);
            ++this.depth;
        }

        void close() throws XMLStreamException {
            this.out.writeEndElement();
            --this.depth;
        }

        void attribute(String key, String value) throws XMLStreamException {
            this.out.writeAttribute(key, value);
        }

        void characters(String data) throws XMLStreamException {
            this.out.writeCharacters(data);
        }
    }
}

