/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Vector;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SinkAdapter;
import org.graphstream.stream.netstream.NetStreamReceiver;
import org.graphstream.stream.netstream.NetStreamSender;
import org.graphstream.stream.netstream.packing.Base64Packer;
import org.graphstream.stream.netstream.packing.Base64Unpacker;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.junit.Assert;
import org.junit.Test;

public class TestNetStream {
    final Vector<String> errors = new Vector();
    boolean debug = false;

    @Test
    public void testNetStreamAttributesChanges() {
        this.errors.clear();
        NetStreamReceiver net = null;
        try {
            net = new NetStreamReceiver("localhost", 2000, this.debug);
        }
        catch (UnknownHostException e1) {
            Assert.fail((String)e1.toString());
        }
        catch (IOException e1) {
            Assert.fail((String)e1.toString());
        }
        try {
            try {
                ThreadProxyPipe pipe = net.getDefaultStream();
                pipe.addSink(new SinkAdapter(){

                    @Override
                    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
                    }
                });
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        MultiGraph g = new MultiGraph("G", false, true);
                        NetStreamSender nsc = null;
                        try {
                            nsc = new NetStreamSender("localhost", 2000);
                        }
                        catch (UnknownHostException e1) {
                            TestNetStream.this.error(e1.toString());
                            return;
                        }
                        catch (IOException e1) {
                            TestNetStream.this.error(e1.toString());
                            return;
                        }
                        g.addSink(nsc);
                        g.addAttribute("attribute", "foo");
                        g.changeAttribute("attribute", false);
                        Object e = g.addEdge("AB", "A", "B");
                        e.addAttribute("attribute", "foo");
                        e.changeAttribute("attribute", false);
                        Object n = e.getNode0();
                        n.addAttribute("attribute", "foo");
                        n.changeAttribute("attribute", false);
                        try {
                            nsc.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
                t.start();
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    Assert.fail((String)e.getMessage());
                }
                while (pipe.hasPostRemaining() || net.hasActiveConnections()) {
                    pipe.pump();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (ClassCastException cce) {
                Assert.fail((String)"Bad cast in attribute change.");
                try {
                    net.quit();
                    net.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            try {
                net.quit();
                net.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Test
    public void testNetStreamTypes() {
        this.errors.clear();
        NetStreamReceiver net = null;
        try {
            net = new NetStreamReceiver("localhost", 2001, this.debug);
        }
        catch (UnknownHostException e1) {
            Assert.fail((String)e1.toString());
        }
        catch (IOException e1) {
            Assert.fail((String)e1.toString());
        }
        net.setUnpacker(new Base64Unpacker());
        ThreadProxyPipe pipe = net.getDefaultStream();
        pipe.addSink(new SinkAdapter(){

            @Override
            public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
                this.validate(attribute, value);
            }

            @Override
            public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
                this.validate(attribute, newValue);
            }

            private void validate(String attribute, Object value) {
                String valueType = null;
                Class<?> valueClass = value.getClass();
                boolean isArray = valueClass.isArray();
                if (isArray) {
                    valueClass = ((Object[])value)[0].getClass();
                }
                if (valueClass.equals(Boolean.class)) {
                    if (isArray) {
                        valueType = "booleanArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Boolean[])value)));
                    } else {
                        valueType = "boolean";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(Byte.class)) {
                    if (isArray) {
                        valueType = "byteArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Byte[])value)));
                    } else {
                        valueType = "byte";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(Short.class)) {
                    if (isArray) {
                        valueType = "shortArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Short[])value)));
                    } else {
                        valueType = "short";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(Integer.class)) {
                    if (isArray) {
                        valueType = "intArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Integer[])value)));
                    } else {
                        valueType = "int";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(Long.class)) {
                    if (isArray) {
                        valueType = "longArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Long[])value)));
                    } else {
                        valueType = "long";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(Float.class)) {
                    if (isArray) {
                        valueType = "floatArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Float[])value)));
                    } else {
                        valueType = "float";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(Double.class)) {
                    if (isArray) {
                        valueType = "doubleArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Double[])value)));
                    } else {
                        valueType = "double";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                } else if (valueClass.equals(String.class)) {
                    if (isArray) {
                        valueType = "typeArray";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, Arrays.toString((Object[])((Boolean[])value)));
                    } else {
                        valueType = "string";
                        System.out.printf("found a %s for attribute %s=%s%n", valueType, attribute, value.toString());
                    }
                }
                Assert.assertTrue((boolean)valueType.equals(attribute));
            }
        });
        Thread t = new Thread(){

            @Override
            public void run() {
                MultiGraph g = new MultiGraph("G");
                NetStreamSender nsc = null;
                try {
                    nsc = new NetStreamSender("localhost", 2001);
                }
                catch (UnknownHostException e1) {
                    TestNetStream.this.error(e1.toString());
                    return;
                }
                catch (IOException e1) {
                    TestNetStream.this.error(e1.toString());
                    return;
                }
                nsc.setPacker(new Base64Packer());
                g.addSink(nsc);
                g.addAttribute("intArray", 0, Integer.MAX_VALUE, Integer.MIN_VALUE);
                g.addAttribute("floatArray", Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE));
                g.addAttribute("doubleArray", 0.0, Double.MAX_VALUE, Double.MIN_VALUE);
                g.addAttribute("shortArray", (short)0, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE);
                g.addAttribute("longArray", 0L, Long.MAX_VALUE, Long.MIN_VALUE);
                g.addAttribute("byteArray", (byte)0, (byte)127, (byte)-128);
                g.addAttribute("booleanArray", true, false);
                g.addAttribute("int", 1);
                g.addAttribute("float", Float.valueOf(1.0f));
                g.addAttribute("double", 1.0);
                g.addAttribute("short", (short)0);
                g.addAttribute("long", 1L);
                g.addAttribute("byte", (byte)0);
                g.addAttribute("boolean", true);
                g.addAttribute("string", "true");
                try {
                    nsc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
        while (pipe.hasPostRemaining() || net.hasActiveConnections()) {
            pipe.pump();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.errors.size() > 0) {
            for (String s : this.errors) {
                System.err.println(s);
                Assert.fail((String)s);
            }
        }
        try {
            net.quit();
            net.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testNetStreamMultiThreadSenders() {
        this.errors.clear();
        MultiGraph g1 = new MultiGraph("G1");
        MultiGraph g2 = new MultiGraph("G2");
        NetStreamReceiver net = null;
        try {
            net = new NetStreamReceiver("localhost", 2002, this.debug);
        }
        catch (UnknownHostException e1) {
            Assert.fail((String)e1.toString());
        }
        catch (IOException e1) {
            Assert.fail((String)e1.toString());
        }
        ThreadProxyPipe pipe1 = net.getStream("G1");
        ThreadProxyPipe pipe2 = net.getStream("G2");
        pipe1.addSink(g1);
        pipe2.addSink(g2);
        Thread t1 = this.launchClient(2002, "G1", "0");
        Thread t2 = this.launchClient(2002, "G1", "1");
        Thread t3 = this.launchClient(2002, "G2", "0");
        try {
            t1.join();
            t2.join();
            t3.join();
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
        while (pipe1.hasPostRemaining() || pipe2.hasPostRemaining() || net.hasActiveConnections()) {
            pipe1.pump();
            pipe2.pump();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.errors.size() > 0) {
            for (String s : this.errors) {
                System.err.println(s);
                Assert.fail((String)s);
            }
        }
        Assert.assertEquals((Object)"G1", g1.getAttribute("id"));
        Assert.assertEquals((Object)"G2", g2.getAttribute("id"));
        Assert.assertEquals((long)180L, (long)g1.getNodeCount());
        Assert.assertEquals((long)90L, (long)g2.getNodeCount());
        try {
            net.quit();
            net.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Thread launchClient(final int port, final String id, final String prefix) {
        Thread t = new Thread(){

            @Override
            public void run() {
                MultiGraph g = new MultiGraph(String.valueOf(id) + prefix);
                NetStreamSender nsc = null;
                try {
                    nsc = new NetStreamSender(id, "localhost", port);
                }
                catch (UnknownHostException e1) {
                    TestNetStream.this.error(e1.toString());
                    return;
                }
                catch (IOException e1) {
                    TestNetStream.this.error(e1.toString());
                    return;
                }
                g.addSink(nsc);
                g.addAttribute("id", id);
                int i = 0;
                while (i < 30) {
                    g.addNode(String.valueOf(prefix) + i + "_1");
                    g.addNode(String.valueOf(prefix) + i + "_0");
                    g.addNode(String.valueOf(prefix) + i + "_2");
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                try {
                    nsc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        return t;
    }

    @Test
    public void testNetStreamEvents() {
        this.errors.clear();
        DefaultGraph g1 = new DefaultGraph("G");
        NetStreamReceiver net = null;
        try {
            net = new NetStreamReceiver("localhost", 2002, this.debug);
        }
        catch (UnknownHostException e1) {
            Assert.fail((String)e1.toString());
        }
        catch (IOException e1) {
            Assert.fail((String)e1.toString());
        }
        ThreadProxyPipe pipe = net.getDefaultStream();
        pipe.addSink(g1);
        g1.addSink(new Sink(){

            @Override
            public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
                Assert.assertEquals((Object)0, (Object)value);
                Assert.assertEquals((Object)"graphAttribute", (Object)attribute);
            }

            @Override
            public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
                Assert.assertTrue(((Integer)newValue == 0 || (Integer)newValue == 1 ? 1 : 0) != 0);
                Assert.assertEquals((Object)"graphAttribute", (Object)attribute);
            }

            @Override
            public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
                Assert.assertEquals((Object)"graphAttribute", (Object)attribute);
            }

            @Override
            public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
                Assert.assertEquals((Object)0, (Object)value);
                Assert.assertEquals((Object)"nodeAttribute", (Object)attribute);
            }

            @Override
            public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
                Assert.assertTrue(((Integer)newValue == 0 || (Integer)newValue == 1 ? 1 : 0) != 0);
                Assert.assertEquals((Object)"nodeAttribute", (Object)attribute);
            }

            @Override
            public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
                Assert.assertEquals((Object)"nodeAttribute", (Object)attribute);
            }

            @Override
            public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
                Assert.assertEquals((Object)0, (Object)value);
                Assert.assertEquals((Object)"edgeAttribute", (Object)attribute);
            }

            @Override
            public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
                Assert.assertTrue(((Integer)newValue == 0 || (Integer)newValue == 1 ? 1 : 0) != 0);
                Assert.assertEquals((Object)"edgeAttribute", (Object)attribute);
            }

            @Override
            public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
                Assert.assertEquals((Object)"edgeAttribute", (Object)attribute);
            }

            @Override
            public void nodeAdded(String sourceId, long timeId, String nodeId) {
                Assert.assertTrue(("node0".equals(nodeId) || "node1".equals(nodeId) ? 1 : 0) != 0);
            }

            @Override
            public void nodeRemoved(String sourceId, long timeId, String nodeId) {
                Assert.assertTrue(("node0".equals(nodeId) || "node1".equals(nodeId) ? 1 : 0) != 0);
            }

            @Override
            public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
                Assert.assertEquals((Object)"edge", (Object)edgeId);
                Assert.assertEquals((Object)"node0", (Object)fromNodeId);
                Assert.assertEquals((Object)"node1", (Object)toNodeId);
                Assert.assertEquals((Object)true, (Object)directed);
            }

            @Override
            public void edgeRemoved(String sourceId, long timeId, String edgeId) {
                Assert.assertEquals((Object)"edge", (Object)edgeId);
            }

            @Override
            public void graphCleared(String sourceId, long timeId) {
            }

            @Override
            public void stepBegins(String sourceId, long timeId, double step) {
                Assert.assertEquals((double)1.1, (double)step);
            }
        });
        Thread t = new Thread(){

            @Override
            public void run() {
                MultiGraph g = new MultiGraph("G", false, true);
                NetStreamSender nsc = null;
                try {
                    nsc = new NetStreamSender("localhost", 2002);
                }
                catch (UnknownHostException e1) {
                    TestNetStream.this.error(e1.toString());
                    return;
                }
                catch (IOException e1) {
                    TestNetStream.this.error(e1.toString());
                    return;
                }
                g.addSink(nsc);
                Object node0 = g.addNode("node0");
                Object edge = g.addEdge("edge", "node0", "node1", true);
                node0.addAttribute("nodeAttribute", 0);
                node0.changeAttribute("nodeAttribute", 1);
                node0.removeAttribute("nodeAttribute");
                edge.addAttribute("edgeAttribute", 0);
                edge.changeAttribute("edgeAttribute", 1);
                edge.removeAttribute("edgeAttribute");
                g.addAttribute("graphAttribute", 0);
                g.changeAttribute("graphAttribute", 1);
                g.removeAttribute("graphAttribute");
                g.stepBegins(1.1);
                g.removeEdge("edge");
                g.removeNode("node0");
                g.clear();
                try {
                    nsc.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
        while (pipe.hasPostRemaining() || net.hasActiveConnections()) {
            pipe.pump();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.errors.size() > 0) {
            for (String s : this.errors) {
                System.err.println(s);
                Assert.fail((String)s);
            }
        }
        try {
            net.quit();
            net.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testNetStreamVarint() {
        NetStreamReceiver net = null;
        try {
            net = new NetStreamReceiver("localhost", 2004, false);
        }
        catch (UnknownHostException e1) {
            Assert.fail((String)e1.toString());
        }
        catch (IOException e1) {
            Assert.fail((String)e1.toString());
        }
        NetStreamSender nss = null;
        try {
            nss = new NetStreamSender(2004);
        }
        catch (UnknownHostException e) {
            Assert.fail((String)e.toString());
        }
        catch (IOException e) {
            Assert.fail((String)e.toString());
        }
        ByteBuffer buff = nss.encodeVarint(300);
        buff.rewind();
        Assert.assertEquals((long)buff.capacity(), (long)2L);
        byte bt = buff.get(0);
        Assert.assertEquals((long)216L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(1);
        Assert.assertEquals((long)4L, (long)((bt & 0x7F) + (bt & 0x80)));
        buff = nss.encodeVarint(-16384);
        buff.rewind();
        Assert.assertEquals((long)buff.capacity(), (long)3L);
        bt = buff.get(0);
        Assert.assertEquals((long)129L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(1);
        Assert.assertEquals((long)128L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(2);
        Assert.assertEquals((long)2L, (long)((bt & 0x7F) + (bt & 0x80)));
        buff = nss.encodeVarint((short)Short.MAX_VALUE);
        buff.rewind();
        Assert.assertEquals((long)buff.capacity(), (long)3L);
        bt = buff.get(0);
        Assert.assertEquals((long)254L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(1);
        Assert.assertEquals((long)255L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(2);
        Assert.assertEquals((long)3L, (long)((bt & 0x7F) + (bt & 0x80)));
        buff = nss.encodeVarint((short)Short.MIN_VALUE);
        buff.rewind();
        Assert.assertEquals((long)buff.capacity(), (long)3L);
        bt = buff.get(0);
        Assert.assertEquals((long)129L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(1);
        Assert.assertEquals((long)128L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(2);
        Assert.assertEquals((long)4L, (long)((bt & 0x7F) + (bt & 0x80)));
        Integer[] array = new Integer[]{300, -16384};
        buff = nss.encodeVarintArray(array);
        buff.rewind();
        Assert.assertEquals((long)buff.capacity(), (long)6L);
        bt = buff.get(0);
        Assert.assertEquals((long)2L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(1);
        Assert.assertEquals((long)216L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(2);
        Assert.assertEquals((long)4L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(3);
        Assert.assertEquals((long)129L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(4);
        Assert.assertEquals((long)128L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(5);
        Assert.assertEquals((long)2L, (long)((bt & 0x7F) + (bt & 0x80)));
        buff = nss.encodeUnsignedVarint(300);
        buff.rewind();
        Assert.assertEquals((long)buff.capacity(), (long)2L);
        bt = buff.get(0);
        Assert.assertEquals((long)172L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(1);
        Assert.assertEquals((long)2L, (long)((bt & 0x7F) + (bt & 0x80)));
        buff = nss.encodeUnsignedVarint((short)Short.MAX_VALUE);
        buff.rewind();
        Assert.assertEquals((long)buff.capacity(), (long)3L);
        bt = buff.get(0);
        Assert.assertEquals((long)255L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(1);
        Assert.assertEquals((long)255L, (long)((bt & 0x7F) + (bt & 0x80)));
        bt = buff.get(2);
        Assert.assertEquals((long)1L, (long)((bt & 0x7F) + (bt & 0x80)));
    }

    private void outBuffer(ByteBuffer buf) {
        System.out.println(buf.toString());
        int nbytes = buf.capacity();
        int at = buf.position();
        int i = 0;
        while (i < nbytes) {
            int bt = buf.get(at + i);
            if (bt < 0) {
                bt = (bt & 0x7F) + (bt & 0x80);
            }
            System.out.printf("%d ", bt);
            ++i;
        }
        System.out.println();
    }

    synchronized void error(String s) {
        this.errors.add(s);
    }

    public static void main(String[] args) {
        new TestNetStream().testNetStreamAttributesChanges();
    }
}

