// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// eoRealParticle.h
// (c) OPAC 2007
/*
    Contact: paradiseo-help@lists.gforge.inria.fr
 */
//-----------------------------------------------------------------------------

#ifndef _EOREALPARTICLE_H
#define _EOREALPARTICLE_H


#include <eoVectorParticle.h>


/** eoRealParticle: Implementation of a real-coded particle. Positions, velocities and best positions are real-coded.
*/
template < class FitT> class eoRealParticle: public eoVectorParticle<FitT,double,double>

{
public:

    eoRealParticle(unsigned size = 0, double positions = 0.0,double velocities = 0.0,double bestPositions = 0.0): eoVectorParticle<FitT, double,double> (size, positions,velocities,bestPositions) {}

    virtual std::string className() const
    {
        return "eoRealParticle";
    }
};

#endif /*_EOREALPARTICLE_H*/
