/** @mainpage Welcome to Evolving Objects

@section intro Introduction

EO is a templates-based, ANSI-C++ compliant evolutionary computation library. It
contains classes for almost any kind of evolutionary computation you might come
up to - at least for the ones we could think of. It is component-based, so that
if you don't find the class you need in it, it is very easy to subclass existing
abstract or concrete classes.



@section tutorial Tutorial

The best place to learn about the features and approaches of EO is to look at
the <a href="../../tutorial/html/eoTutorial.html">tutorial</a>.



@section install Installation

The installation procedure of the package is detailed in the <a
href="../../README">README</a> file in the top-directory of the source-tree.



@section design Overall Design

For an introduction to the design of EO you can look at the <a
href="http://eodev.sourceforge.net/eo/doc/LeCreusot.pdf">slides</a> from a talk
at EA 2001 or the corresponding <a
href="http://eodev.sourceforge.net/eo/doc/EO_EA2001.pdf">article</a> in <a
href="http://portal.acm.org/citation.cfm?id=727742"><em>Lecture Notes In
Computer Science</em> <b>2310</b>, <em>Selected Papers from the 5th European
Conference on Artificial Evolution</em></a>.
*/



/** @page webpages Related webpages

- EO <a href="http://eodev.sourceforge.net">homepage</a>
- EO <a href="../../tutorial/html/eoTutorial.html">Tutorial</a>.
- SourceForge <a href="https://sourceforge.net/projects/eodev">project page</a>
- <a href="../../README">README</a>
- <a href="../../NEWS">NEWS</a>
*/



/** @page Related Projects

<h1>ParadisEO</h1>

<a href="http://paradiseo.gforge.inria.fr">ParadisEO</a> is a project that
extends EO for the flexible design of single solution-based metaheuristics,
metaheuristics for multi objective optimization as well as hybrid, parallel and distributed
metaheuristics.
*/



/** An old TODO list for EO, this could be updated...

@todo (old) Provide a way to easily manipulate the algorithm in runtime, be it from
grafically or text; expand command-line capabities?

@todo (old) Provide a graphical interface for Windows, in VC++ or BBuilder.

@todo (old) Create more examples of the objects of which there is only one instance:
algorithms, evaluators. Try to adapt most well-know algorithms to EO

@todo (old) Integrate the gTK interface seamlessly in the library.

@todo Complete documentation.

@todo (for release 1.1) Update README, INSTALL, ... for cmake based build system.
*/



// Local Variables:
// coding: iso-8859-1
// mode: C++
// c-file-offsets: ((c . 0))
// c-file-style: "Stroustrup"
// fill-column: 80
// End:
