/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Graphics;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import ptolemy.plot.PlotBox;

public class Histogram
extends PlotBox {
    protected int _currentdataset = -1;
    protected Vector _points = new Vector();
    protected Vector _histogram = new Vector();
    private double _barwidth = 0.5;
    private double _baroffset = 0.15;
    private double _binWidth = 1.0;
    private double _binOffset = 0.5;
    private String _filename = null;
    private boolean _showing = false;

    public void addLegend(int dataset, String legend) {
        this._checkDatasetIndex(dataset);
        super.addLegend(dataset, legend);
    }

    public synchronized void addPoint(final int dataset, final double value) {
        Runnable doAddPoint = new Runnable(){

            public void run() {
                Histogram.this._addPoint(dataset, value);
            }
        };
        this.deferIfNecessary(doAddPoint);
    }

    public synchronized void addPoint(int dataset, double x, double y, boolean connected) {
        this.addPoint(dataset, y);
    }

    public synchronized void clear(final boolean format) {
        Runnable doClear = new Runnable(){

            public void run() {
                Histogram.this._clear(format);
            }
        };
        this.deferIfNecessary(doClear);
    }

    public synchronized void exportToPlot(PrintWriter output, String dtd) {
        if (dtd == null) {
            output.println("<?xml version=\"1.0\" standalone=\"yes\"?>");
            output.println("<!DOCTYPE plot PUBLIC \"-//UC Berkeley//DTD PlotML 1//EN\"");
            output.println("    \"http://ptolemy.eecs.berkeley.edu/xml/dtd/PlotML_1.dtd\">");
        } else {
            output.println("<?xml version=\"1.0\" standalone=\"no\"?>");
            output.println("<!DOCTYPE plot SYSTEM \"" + dtd + "\">");
        }
        output.println("<plot>");
        output.println("<!-- Ptolemy plot, version 5.5 , PlotML format. Exported from Histogram. -->");
        super.writeFormat(output);
        output.println("<barGraph width=\"" + this._barwidth * this._binWidth + "\" offset=\"" + this._baroffset * this._binWidth + "\"/>");
        int dataset = 0;
        while (dataset < this._points.size()) {
            String legend = this.getLegend(dataset);
            if (legend != null) {
                output.println("<dataset name=\"" + legend + "\" connected=\"no\">");
            } else {
                output.println("<dataset connected=\"no\">");
            }
            Hashtable data = (Hashtable)this._histogram.elementAt(dataset);
            Enumeration keys = data.keys();
            while (keys.hasMoreElements()) {
                Integer bin = (Integer)keys.nextElement();
                Integer count = (Integer)data.get(bin);
                int xValue = (int)((double)bin.intValue() * this._binWidth + this._binOffset);
                output.println("<p x=\"" + xValue + "\" y=\"" + count + "\"/>");
            }
            output.println("</dataset>");
            ++dataset;
        }
        output.println("</plot>");
        output.flush();
    }

    public synchronized void fillPlot() {
        Runnable doFill = new Runnable(){

            public void run() {
                Histogram.this._fillPlot();
            }
        };
        this.deferIfNecessary(doFill);
    }

    public synchronized void samplePlot() {
        this.clear(true);
        this.setTitle("Sample histogram");
        this.setXLabel("values");
        this.setYLabel("count");
        Random random = new Random();
        int i = 0;
        while (i <= 1000) {
            this.addPoint(0, 5.0 * Math.cos(Math.PI * (double)i / 500.0));
            this.addPoint(1, 10.0 * random.nextDouble() - 5.0);
            this.addPoint(2, 2.0 * random.nextGaussian());
            ++i;
        }
        this.repaint();
    }

    public synchronized void setBars(double width, double offset) {
        this._plotImage = null;
        this._barwidth = width;
        this._baroffset = offset;
    }

    public synchronized void setBinOffset(double offset) {
        this._plotImage = null;
        this._binOffset = offset;
    }

    public void setBinWidth(double width) {
        this._plotImage = null;
        this._binWidth = width;
    }

    public synchronized void write(Writer out, String dtd) {
        PrintWriter output = new PrintWriter((Writer)new BufferedWriter(out), false);
        this.exportToPlot(output, dtd);
    }

    public synchronized void writeData(PrintWriter output) {
        super.writeData(output);
        int dataset = 0;
        while (dataset < this._points.size()) {
            String legend = this.getLegend(dataset);
            if (legend != null) {
                output.println("<dataset name=\"" + legend + "\">");
            } else {
                output.println("<dataset>");
            }
            Vector pts = (Vector)this._points.elementAt(dataset);
            int pointnum = 0;
            while (pointnum < pts.size()) {
                Double pt = (Double)pts.elementAt(pointnum);
                output.println("<p y=\"" + pt + "\"/>");
                ++pointnum;
            }
            output.println("</dataset>");
            ++dataset;
        }
    }

    public synchronized void writeFormat(PrintWriter output) {
        super.writeFormat(output);
        output.println("<barGraph width=\"" + this._barwidth + "\" offset=\"" + this._baroffset + "\"/>");
        output.println("<bin width=\"" + this._binWidth + "\" offset=\"" + this._binOffset + "\"/>");
    }

    /*
     * Unable to fully structure code
     */
    protected void _checkDatasetIndex(int dataset) {
        if (dataset >= 0) ** GOTO lbl5
        throw new IllegalArgumentException("Plot._checkDatasetIndex: Cannot give a negative number for the data set index.");
lbl-1000:
        // 1 sources

        {
            this._points.addElement(new Vector<E>());
            this._histogram.addElement(new Hashtable<K, V>());
lbl5:
            // 2 sources

            ** while (dataset >= this._points.size())
        }
lbl6:
        // 1 sources

    }

    protected void _drawBar(Graphics graphics, int dataset, long xpos, long ypos, boolean clip) {
        if (clip) {
            if (ypos < (long)this._uly) {
                ypos = this._uly;
            }
            if (ypos > (long)this._lry) {
                ypos = this._lry;
            }
        }
        if (ypos <= (long)this._lry && xpos <= (long)this._lrx && xpos >= (long)this._ulx) {
            long zeroypos;
            int barlx = (int)((double)xpos - this._barwidth * this._binWidth * this._xscale / 2.0 + (double)dataset * this._baroffset * this._binWidth * this._xscale);
            int barrx = (int)((double)barlx + this._barwidth * this._binWidth * this._xscale);
            if (barlx < this._ulx) {
                barlx = this._ulx;
            }
            if (barrx > this._lrx) {
                barrx = this._lrx;
            }
            if (barlx >= barrx) {
                barrx = barlx + 1;
            }
            if ((long)this._lry < (zeroypos = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale))) {
                zeroypos = this._lry;
            }
            if ((long)this._uly > zeroypos) {
                zeroypos = this._uly;
            }
            if (this._yMin >= 0.0 || ypos <= zeroypos) {
                graphics.fillRect(barlx, (int)ypos, barrx - barlx, (int)(zeroypos - ypos));
            } else {
                graphics.fillRect(barlx, (int)zeroypos, barrx - barlx, (int)(ypos - zeroypos));
            }
        }
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean clearfirst) {
        super._drawPlot(graphics, clearfirst);
        this._showing = true;
        int dataset = this._points.size() - 1;
        while (dataset >= 0) {
            Hashtable data = (Hashtable)this._histogram.elementAt(dataset);
            Enumeration keys = data.keys();
            while (keys.hasMoreElements()) {
                Integer bin = (Integer)keys.nextElement();
                Integer count = (Integer)data.get(bin);
                this._drawPlotPoint(graphics, dataset, bin, count);
            }
            --dataset;
        }
    }

    protected boolean _parseLine(String line) {
        if (super._parseLine(line)) {
            return true;
        }
        String lcLine = line.toLowerCase();
        if (lcLine.startsWith("dataset:")) {
            String legend;
            ++this._currentdataset;
            if (lcLine.length() > 0 && (legend = line.substring(8).trim()) != null && legend.length() > 0) {
                this.addLegend(this._currentdataset, legend);
            }
            return true;
        }
        if (lcLine.startsWith("bars:") || lcLine.startsWith("bargraph:")) {
            String barwidth;
            int comma = line.indexOf(",", 5);
            String baroffset = null;
            if (comma > 0) {
                barwidth = line.substring(5, comma).trim();
                baroffset = line.substring(comma + 1).trim();
            } else {
                barwidth = line.substring(5).trim();
            }
            try {
                Double bwidth = new Double(barwidth);
                double boffset = this._baroffset;
                if (baroffset != null) {
                    boffset = new Double(baroffset);
                }
                this.setBars(bwidth, boffset);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return true;
        }
        if (lcLine.startsWith("binwidth:")) {
            String binwidth = line.substring(9).trim();
            try {
                Double bwidth = new Double(binwidth);
                this.setBinWidth(bwidth);
            }
            catch (NumberFormatException bwidth) {
                // empty catch block
            }
            return true;
        }
        if (lcLine.startsWith("binoffset:")) {
            String binoffset = line.substring(10).trim();
            try {
                Double boffset = new Double(binoffset);
                this.setBinOffset(boffset);
            }
            catch (NumberFormatException boffset) {
                // empty catch block
            }
            return true;
        }
        if (lcLine.startsWith("numsets:")) {
            return true;
        }
        if (line.startsWith("move:")) {
            line = line.substring(5, line.length()).trim();
        } else if (line.startsWith("move")) {
            line = line.substring(4, line.length()).trim();
        } else if (line.startsWith("draw:")) {
            line = line.substring(5, line.length()).trim();
        } else if (line.startsWith("draw")) {
            line = line.substring(4, line.length()).trim();
        }
        line = line.trim();
        int fieldsplit = line.indexOf(",");
        if (fieldsplit == -1) {
            fieldsplit = line.indexOf(" ");
        }
        if (fieldsplit == -1) {
            fieldsplit = line.indexOf("\t");
        }
        if (fieldsplit == -1) {
            try {
                Double xpt = new Double(line);
                this.addPoint(this._currentdataset, xpt);
                return true;
            }
            catch (NumberFormatException e) {}
        } else {
            String y = line.substring(fieldsplit + 1).trim();
            try {
                Double ypt = new Double(y);
                this.addPoint(this._currentdataset, ypt);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private void _addPoint(int dataset, double value) {
        double xtop;
        int count;
        this._plotImage = null;
        this._checkDatasetIndex(dataset);
        int bin = (int)Math.round((value - this._binOffset) / this._binWidth);
        Integer binobj = new Integer(bin);
        Hashtable bins = (Hashtable)this._histogram.elementAt(dataset);
        if (bins.containsKey(binobj)) {
            count = 1 + (Integer)bins.get(binobj);
            bins.put(binobj, new Integer(count));
        } else {
            count = 1;
            bins.put(binobj, new Integer(count));
        }
        double x = (double)bin * this._binWidth + this._binOffset;
        if (x < this._xBottom) {
            this._xBottom = x;
        }
        if ((xtop = x + this._binWidth / 2.0) > this._xTop) {
            this._xTop = xtop;
        }
        if ((double)count > this._yTop) {
            this._yTop = count;
        }
        this._yBottom = 0.0;
        Vector pts = (Vector)this._points.elementAt(dataset);
        pts.addElement(new Double(value));
        Graphics graphics = this.getGraphics();
        if (this._showing && graphics != null) {
            int pendingDataset = dataset;
            int pendingBin = bin;
            int pendingCount = count;
            this._drawPlotPoint(graphics, pendingDataset, pendingBin, pendingCount);
        }
    }

    private void _clear(boolean format) {
        this._plotImage = null;
        super.clear(format);
        this._currentdataset = -1;
        this._points = new Vector();
        this._histogram = new Vector();
        this._filename = null;
        this._showing = false;
        if (format) {
            this._barwidth = 0.5;
            this._baroffset = 0.15;
            this._binWidth = 1.0;
            this._binOffset = 0.5;
        }
    }

    private void _drawPlotPoint(Graphics graphics, int dataset, int bin, int count) {
        if (this._usecolor) {
            int color = dataset % PlotBox._colors.length;
            graphics.setColor(PlotBox._colors[color]);
        } else {
            graphics.setColor(this._foreground);
        }
        double y = count;
        double x = this._binWidth * (double)bin + this._binOffset;
        if (this._xlog) {
            if (x <= 0.0) {
                System.err.println("Can't plot non-positive X values when the logarithmic X axis value is specified: " + x);
                return;
            }
            x = Math.log(x) * PlotBox._LOG10SCALE;
        }
        if (this._ylog) {
            if (y <= 0.0) {
                System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: " + y);
                return;
            }
            y = Math.log(y) * PlotBox._LOG10SCALE;
        }
        long ypos = (long)this._lry - (long)((y - this._yMin) * this._yscale);
        long xpos = (long)this._ulx + (long)((x - this._xMin) * this._xscale);
        this._drawBar(graphics, dataset, xpos, ypos, true);
        graphics.setColor(this._foreground);
    }

    private void _fillPlot() {
        super.fillPlot();
    }
}

