encapsulated package SimCodeQSS
"
  file:        SimCodeQSS.mo
  package:     SimCodeQSS
  description: Generated by Susan.
  
  $Id: SimCodeQSS.mo 8700 2011-04-19 12:05:34Z fbergero $
"

public import Tpl;

public import SimCode;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import RTOpts;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
protected import SimCodeC;

protected function fun_24
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simulationSettingsOpt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text txt_0;

    case ( txt,
           NONE(),
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode )
      equation
        txt_0 = SimCodeC.simulationInitFile(Tpl.emptyTxt, a_simCode);
        Tpl.textFile(txt_0, "model_init.txt");
      then txt;
  end matchcontinue;
end fun_24;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_qssInfo)
    local
      Tpl.Text txt;
      BackendQSS.QSSinfo a_qssInfo;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      list<DAE.Exp> i_literals;
      list<SimCode.RecordDeclaration> i_recordDecls;
      list<SimCode.Function> i_modelInfo_functions;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = i_modelInfo_functions), fileNamePrefix = i_fileNamePrefix, recordDecls = i_recordDecls, literals = i_literals, simulationSettingsOpt = i_simulationSettingsOpt)),
           a_qssInfo )
      equation
        txt_0 = simulationFile(Tpl.emptyTxt, i_simCode, a_qssInfo);
        Tpl.textFile(txt_0, "modelica_funcs.cpp");
        txt_1 = SimCodeC.simulationFunctionsHeaderFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_recordDecls);
        Tpl.textFile(txt_1, "model_functions.h");
        txt_2 = simulationFunctionsFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_literals);
        Tpl.textFile(txt_2, "model_functions.cpp");
        txt_3 = SimCodeC.recordsFile(Tpl.emptyTxt, i_fileNamePrefix, i_recordDecls);
        Tpl.textFile(txt_3, "model_records.c");
        txt_4 = simulationMakefile(Tpl.emptyTxt, i_simCode);
        txt_5 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_4, Tpl.textString(txt_5));
        txt_6 = structureFile(Tpl.emptyTxt, i_simCode, a_qssInfo);
        Tpl.textFile(txt_6, "modelica_structure.pds");
        txt = fun_24(txt, i_simulationSettingsOpt, i_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end translateModel;

public function simulationFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_qssInfo)
    local
      Tpl.Text txt;
      BackendQSS.QSSinfo a_qssInfo;
      list<DAE.Statement> i_algorithmAndEquationAsserts;
      list<DAE.ComponentRef> i_discreteModelVars;
      list<SimCode.SimEqSystem> i_removedEquations;
      list<SimCode.SimEqSystem> i_algebraicEquations;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_initialEquations;
      SimCode.DelayedExpression i_delayedExps;
      list<SimCode.SimEqSystem> i_sampleEquations;
      list<SimCode.SampleCondition> i_sampleConditions;
      SimCode.ExtObjInfo i_extObjInfo;
      list<SimCode.HelpVarInfo> i_helpVarInfo;
      list<SimCode.SimWhenClause> i_whenClauses;
      Integer i_modelInfo_varInfo_numStateVars;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<SimCode.SimEqSystem> i_odeEquations;
      Integer i_modelInfo_varInfo_numZeroCrossings;
      list<String> i_externalFunctionIncludes;
      list<SimCode.SimEqSystem> i_residualEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.JacobianMatrix> i_JacobianMatrixes;
      String i_fileNamePrefix;
      SimCode.ModelInfo i_modelInfo;
      String i_modelInfo_directory;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      list<SimCode.SimWhenClause> ret_2;
      list<SimCode.SimEqSystem> ret_1;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = i_modelInfo_varInfo_numZeroCrossings, numStateVars = i_modelInfo_varInfo_numStateVars), name = i_modelInfo_name, directory = i_modelInfo_directory)), fileNamePrefix = i_fileNamePrefix, JacobianMatrixes = i_JacobianMatrixes, allEquations = i_allEquations, residualEquations = i_residualEquations, externalFunctionIncludes = i_externalFunctionIncludes, odeEquations = i_odeEquations, zeroCrossings = i_zeroCrossings, whenClauses = i_whenClauses, helpVarInfo = i_helpVarInfo, extObjInfo = i_extObjInfo, sampleConditions = i_sampleConditions, sampleEquations = i_sampleEquations, delayedExps = i_delayedExps, initialEquations = i_initialEquations, parameterEquations = i_parameterEquations, algebraicEquations = i_algebraicEquations, removedEquations = i_removedEquations, discreteModelVars = i_discreteModelVars, algorithmAndEquationAsserts = i_algorithmAndEquationAsserts)),
           a_qssInfo )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef _OMC_QSS\n",
                                    "extern \"C\" { // adrpo: this is needed for Visual C++ compilation to work!\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *model_name=\""));
        txt = SimCodeC.dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "const char *model_fileprefix=\"model\";\n",
                                    "const char *model_dir=\""
                                }, false));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "#endif\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = SimCodeC.globalData(txt, i_modelInfo, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_0 = SimCode.appendAllequation(i_JacobianMatrixes);
        ret_1 = SimCode.appendLists(ret_0, i_allEquations);
        txt = SimCodeC.equationInfo(txt, ret_1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionInitialResidual(txt, i_residualEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionExtraResiduals(txt, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.externalFunctionIncludes(txt, i_externalFunctionIncludes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionODE_residual(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "int measure_time_flag = 1;\n",
                                    "#else\n",
                                    "int measure_time_flag = 0;\n",
                                    "#endif\n",
                                    "\n",
                                    "// fbergero, xfloros: Code for QSS methods\n",
                                    "#ifdef _OMC_QSS\n",
                                    "\n",
                                    "int\n",
                                    "startInteractiveSimulation(int, char**);\n",
                                    "int\n",
                                    "startNonInteractiveSimulation(int, char**);\n",
                                    "int\n",
                                    "initRuntimeAndSimulation(int, char**);\n",
                                    "extern int interactiveSimulation;\n",
                                    "char incidenceMatrix[0];\n",
                                    "char inputMatrix[0];\n",
                                    "char outputMatrix[0];\n",
                                    "\n",
                                    "#ifndef _OMC_OMPD\n",
                                    "int\n",
                                    "main(int argc, char**argv)\n",
                                    "{\n",
                                    "  int retVal = -1;\n",
                                    "\n",
                                    "  if (initRuntimeAndSimulation(argc, argv)) //initRuntimeAndSimulation returns 1 if an error occurs\n",
                                    "    return 1;\n",
                                    "\n",
                                    "  if (interactiveSimuation) {\n",
                                    "    //cout << \"startInteractiveSimulation: \" << version << endl;\n",
                                    "    retVal = startInteractiveSimulation(argc, argv);\n",
                                    "  } else {\n",
                                    "    //cout << \"startNonInteractiveSimulation: \" << version << endl;\n",
                                    "    retVal = startNonInteractiveSimulation(argc, argv);\n",
                                    "  }\n",
                                    "\n",
                                    "  deInitializeDataStruc(globalData);\n",
                                    "  free(globalData);\n",
                                    "  fflush(NULL);\n",
                                    "  EXIT(retVal);\n",
                                    "}\n",
                                    "#endif\n",
                                    "\n",
                                    "#define condition_rettype bool\n",
                                    "void init_ompd();\n",
                                    "void clean_ompd();\n",
                                    "\n",
                                    "bool cond["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_modelInfo_varInfo_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "];\n",
                                    "\n",
                                    "void set_condition_to(unsigned int c, bool b) { cond[c]=b; }\n",
                                    "bool condition(unsigned int c) { return cond[c]; }\n",
                                    "\n",
                                    "//for QSS solver\n",
                                    "double rel_accuracy = 1e-5;\n",
                                    "double abs_accuracy = 1e-5;\n",
                                    "char* method = (char*)\"QSS3\";\n",
                                    "\n",
                                    "double state_values(int state)\n",
                                    "{\n",
                                    "  switch (state)\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = generateStateValues(txt, a_qssInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n",
                                    "double quantum_values(int state)\n",
                                    "{\n",
                                    "  return 0.0;\n",
                                    "}\n",
                                    "\n",
                                    "// integration method\n",
                                    "char* int_method() {\n",
                                    "  return method;\n",
                                    "}\n",
                                    "\n",
                                    "// settings\n",
                                    "double function_rel_acc() {\n",
                                    "  return rel_accuracy;\n",
                                    "}\n",
                                    "\n",
                                    "double function_abs_acc() {\n",
                                    "  return abs_accuracy;\n",
                                    "}\n",
                                    "\n",
                                    "int init_runtime()\n",
                                    "{\n",
                                    "  static bool init=false;\n",
                                    "  if (!init)\n",
                                    "  {\n",
                                    "    init=true;\n",
                                    "    init_ompd();\n",
                                    "  }\n",
                                    "  return 0;\n",
                                    "}\n",
                                    "\n",
                                    "void clean_runtime()\n",
                                    "{\n",
                                    "  static bool clean=false;\n",
                                    "  if (!clean)\n",
                                    "  {\n",
                                    "    clean=true;\n",
                                    "    clean_ompd();\n",
                                    "  }\n",
                                    "}\n"
                                }, true));
        txt = functionQssStaticBlocks(txt, i_odeEquations, i_zeroCrossings, a_qssInfo, i_modelInfo_varInfo_numStateVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_2 = BackendQSS.replaceCondWhens(i_whenClauses, i_helpVarInfo, i_zeroCrossings);
        txt = functionQssWhen(txt, ret_2, i_helpVarInfo, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionQssSample(txt, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionQssUpdateDiscrete(txt, i_allEquations, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt = SimCodeC.functionGetName(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionSetLocalData(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionInitializeDataStruc(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionCallExternalObjectConstructors(txt, i_extObjInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionDeInitializeDataStruc(txt, i_extObjInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionInput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionOutput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionInitSample(txt, i_sampleConditions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionSampleEquations(txt, i_sampleEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionStoreDelayed(txt, i_delayedExps);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionInitial(txt, i_initialEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionBoundParameters(txt, i_parameterEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionODE(txt, i_odeEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionAlgebraic(txt, i_algebraicEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionAliasEquation(txt, i_removedEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionDAE(txt, i_allEquations, i_whenClauses, i_helpVarInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionOnlyZeroCrossing(txt, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionCheckForDiscreteChanges(txt, i_discreteModelVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionAssertsforCheck(txt, i_algorithmAndEquationAsserts);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.generateLinearMatrixes(txt, i_JacobianMatrixes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = SimCodeC.functionlinearmodel(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end simulationFile;

protected function fun_27
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_connections;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_connections, in_a_qssInfo)
    local
      Tpl.Text txt;
      Tpl.Text a_connections;
      BackendQSS.QSSinfo a_qssInfo;
      list<SimCode.HelpVarInfo> i_helpVarInfo;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      Integer i_varInfo_numStateVars;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars)), zeroCrossings = i_zeroCrossings, whenClauses = i_whenClauses, helpVarInfo = i_helpVarInfo),
           a_connections,
           a_qssInfo )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Root-Coordinator\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = generateIntegrators(txt, i_varInfo_numStateVars);
        txt = Tpl.softNewLine(txt);
        txt = generateStaticBlocks(txt, a_qssInfo, i_varInfo_numStateVars);
        txt = Tpl.softNewLine(txt);
        txt = generateZeroCrossingFunctions(txt, i_zeroCrossings, a_qssInfo, i_varInfo_numStateVars);
        txt = Tpl.softNewLine(txt);
        txt = generateCrossingDetector(txt, i_zeroCrossings, a_qssInfo);
        txt = Tpl.softNewLine(txt);
        txt = generateWhenBlocks(txt, i_whenClauses, i_helpVarInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Simulator\n",
                                    "  {\n",
                                    "    Path = modelica/outvars.h\n",
                                    "    Parameters = 0.0\n",
                                    "  }\n",
                                    "EIC\n",
                                    "  {\n",
                                    "  }\n",
                                    "EIC\n",
                                    "  {\n",
                                    "  }\n",
                                    "IC\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_connections);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  }\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_27;

public function structureFile
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input BackendQSS.QSSinfo a_qssInfo;

  output Tpl.Text out_txt;
protected
  list<list<Integer>> ret_2;
  Tpl.Text l_connections;
  Tpl.Text l_models;
algorithm
  l_models := Tpl.emptyTxt;
  ret_2 := BackendQSS.generateConnections(a_qssInfo);
  l_connections := generateConnections(Tpl.emptyTxt, ret_2);
  out_txt := fun_27(txt, a_simCode, l_connections, a_qssInfo);
end structureFile;

public function functionQssSample
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_sampleCode;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_sampleCode, l_varDecls) := functionQssSample2(Tpl.emptyTxt, a_zeroCrossings, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "void functionQssSample(unsigned int sampleIndex, double *out)\n",
                                   "{\n",
                                   "  state mem_state;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "mem_state = get_memory_state();\n",
                                       "switch (sampleIndex)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_sampleCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "restore_memory_state(mem_state);\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionQssSample;

protected function lm_30
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_interval;
      DAE.Exp i_start;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {i_start, i_interval})) :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = functionQssSample3(txt, x_i0, i_start, i_interval, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_30(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_30(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_30;

public function functionQssSample2
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_30(out_txt, a_zeroCrossings, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end functionQssSample2;

public function functionQssSample3
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_start;
  input DAE.Exp a_interval;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_e2;
  Tpl.Text l_e1;
  Tpl.Text l_preExp;
algorithm
  l_preExp := Tpl.emptyTxt;
  (l_e1, l_preExp, out_a_varDecls) := SimCodeC.daeExp(Tpl.emptyTxt, a_start, SimCode.contextOther, l_preExp, a_varDecls);
  (l_e2, l_preExp, out_a_varDecls) := SimCodeC.daeExp(Tpl.emptyTxt, a_interval, SimCode.contextOther, l_preExp, out_a_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("case "));
  out_txt := Tpl.writeStr(out_txt, intString(a_index1));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(":\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_preExp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("out[0] = "));
  out_txt := Tpl.writeText(out_txt, l_e1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ";\n",
                                       "out[1] = "
                                   }, false));
  out_txt := Tpl.writeText(out_txt, l_e2);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ";\n",
                                       "break;"
                                   }, false));
  out_txt := Tpl.popBlock(out_txt);
end functionQssSample3;

public function functionQssWhen
  input Tpl.Text txt;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.HelpVarInfo> a_helpVars;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_whenCases;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_whenCases, l_varDecls) := functionQssWhen2(Tpl.emptyTxt, a_whenClauses, a_helpVars, l_varDecls, a_zeroCrossings);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "bool functionQssWhen(unsigned int whenIndex, double t,double *out, double *in)\n",
                                   "{\n",
                                   "  state mem_state;\n",
                                   "  time = t;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "mem_state = get_memory_state();\n",
                                       "switch (whenIndex)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(3));
  out_txt := Tpl.writeText(out_txt, l_whenCases);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "return false;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionQssWhen;

protected function lm_34
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_zeroCrossings, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      Tpl.Text a_varDecls;
      Integer x_i0;
      Option<BackendDAE.WhenEquation> i_whenEq;
      list<BackendDAE.WhenOperator> i_reinits;
      list<tuple<DAE.Exp, Integer>> i_conditions;
      Tpl.Text l_equations;
      Tpl.Text l_cond;
      Tpl.Text l_saves;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(conditions = i_conditions, reinits = i_reinits, whenEq = i_whenEq) :: rest,
           a_zeroCrossings,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        l_saves = Tpl.emptyTxt;
        (l_cond, a_varDecls, l_preExp) = functionPreWhenCondition(Tpl.emptyTxt, i_conditions, a_varDecls, l_preExp, a_zeroCrossings);
        (l_equations, a_varDecls) = generateWhenEquations(Tpl.emptyTxt, i_reinits, i_whenEq, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":\n",
                                    "  #ifdef _OMC_OMPD\n",
                                    "  // Read inputs from in[]\n",
                                    "  #endif\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_cond);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_equations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_saves);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "restore_memory_state(mem_state);\n",
                                    "return true;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("} else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeText(txt, l_saves);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  restore_memory_state(mem_state);\n",
                                    "  return false;\n",
                                    "}\n",
                                    "break;"
                                }, false));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_34(txt, rest, a_zeroCrossings, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_zeroCrossings,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_34(txt, rest, a_zeroCrossings, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_34;

public function functionQssWhen2
  input Tpl.Text txt;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.HelpVarInfo> a_helpVars;
  input Tpl.Text a_varDecls;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_34(out_txt, a_whenClauses, a_zeroCrossings, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end functionQssWhen2;

protected function fun_36
  input Tpl.Text in_txt;
  input Option<BackendDAE.WhenEquation> in_a_whenEq;
  input list<BackendDAE.WhenOperator> in_a_reinits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_whenEq, in_a_reinits, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.WhenOperator> a_reinits;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_left;
      DAE.Exp i_right;
      Tpl.Text l_exp;
      Tpl.Text l_preExp;

    case ( txt,
           SOME(BackendDAE.WHEN_EQ(right = i_right, left = i_left)),
           a_reinits,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_exp, l_preExp, a_varDecls) = SimCodeC.daeExp(Tpl.emptyTxt, i_right, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = SimCodeC.cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  = "));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        (txt, a_varDecls) = generateReinits(txt, a_reinits, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           NONE(),
           a_reinits,
           a_varDecls )
      equation
        (txt, a_varDecls) = generateReinits(txt, a_reinits, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_36;

public function generateWhenEquations
  input Tpl.Text txt;
  input list<BackendDAE.WhenOperator> a_reinits;
  input Option<BackendDAE.WhenEquation> a_whenEq;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_36(txt, a_whenEq, a_reinits, a_varDecls);
end generateWhenEquations;

protected function lm_38
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.WhenOperator> rest;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.REINIT(stateVar = i_stateVar, value = i_value) :: rest,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp, a_varDecls) = SimCodeC.daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = SimCodeC.cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // Reinit of var "));
        txt = SimCodeC.cref(txt, i_stateVar);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_38(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_38(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_38;

public function generateReinits
  input Tpl.Text txt;
  input list<BackendDAE.WhenOperator> a_reinits;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_38(out_txt, a_reinits, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end generateReinits;

protected function fun_40
  input Tpl.Text in_txt;
  input DAE.Exp in_a_e;
  input Integer in_a_hvar;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_e, in_a_hvar, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_hvar;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_e;
      Integer i_i;
      Tpl.Text l_helpInit;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "samplecondition"), expLst = {DAE.ICONST(integer = i_i)}),
           _,
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("condition("));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_e,
           a_hvar,
           a_varDecls,
           a_preExp )
      equation
        (l_helpInit, a_preExp, a_varDecls) = SimCodeC.daeExp(Tpl.emptyTxt, i_e, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("localData->helpVars["));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_hvar));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("] = "));
        a_preExp = Tpl.writeText(a_preExp, l_helpInit);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "\n"
                                          }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("edge(localData->helpVars["));
        txt = Tpl.writeStr(txt, intString(a_hvar));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_40;

protected function lm_41
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer i_hvar;
      DAE.Exp i_e;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hvar) :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = fun_40(txt, i_e, i_hvar, a_varDecls, a_preExp);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_41(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_41(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_41;

public function functionPreWhenCondition
  input Tpl.Text txt;
  input list<tuple<DAE.Exp, Integer>> a_conditions;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_preExp;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls, out_a_preExp) := lm_41(out_txt, a_conditions, a_varDecls, a_preExp);
  out_txt := Tpl.popIter(out_txt);
end functionPreWhenCondition;

protected function fun_43
  input Tpl.Text in_txt;
  input BackendQSS.QSSinfo in_a_qssInfo;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;
  input Integer in_a_nStates;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_qssInfo, in_a_derivativEquations, in_a_zeroCrossings, in_a_nStates)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_derivativEquations;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      Integer a_nStates;
      list<BackendDAE.Var> i_outVarLst;
      BackendQSS.DevsStruct i_DEVSstructure;
      list<list<SimCode.SimEqSystem>> i_eqs;
      Integer ret_5;
      Tpl.Text l_zeroCross;
      Tpl.Text l_staticFun;
      Integer ret_2;
      Tpl.Text l_numStatic;
      Tpl.Text l_varDecls;

    case ( txt,
           BackendQSS.QSSINFO(eqs = i_eqs, DEVSstructure = i_DEVSstructure, outVarLst = i_outVarLst),
           a_derivativEquations,
           a_zeroCrossings,
           a_nStates )
      equation
        l_varDecls = Tpl.emptyTxt;
        ret_2 = listLength(i_eqs);
        l_numStatic = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        (l_staticFun, l_varDecls) = generateStaticFunc(Tpl.emptyTxt, a_derivativEquations, a_zeroCrossings, l_varDecls, i_DEVSstructure, i_eqs, i_outVarLst, a_nStates);
        ret_5 = listLength(i_eqs);
        (l_zeroCross, l_varDecls) = generateZeroCrossingsEq(Tpl.emptyTxt, ret_5, a_zeroCrossings, l_varDecls, i_DEVSstructure, i_outVarLst, a_nStates);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int staticBlocks = "));
        txt = Tpl.writeText(txt, l_numStatic);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "void function_staticBlocks(int staticFunctionIndex, double t, double *in, double *out)\n",
                                    "{\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Number of Static blocks: "));
        txt = Tpl.writeText(txt, l_numStatic);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "time = t;\n",
                                    "mem_state = get_memory_state();\n",
                                    "switch (staticFunctionIndex)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_staticFun);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("// Start of zero crossings functions\n"));
        txt = Tpl.writeText(txt, l_zeroCross);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "restore_memory_state(mem_state);\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_43;

public function functionQssStaticBlocks
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input BackendQSS.QSSinfo a_qssInfo;
  input Integer a_nStates;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_43(txt, a_qssInfo, a_derivativEquations, a_zeroCrossings, a_nStates);
end functionQssStaticBlocks;

protected function lm_45
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input list<BackendDAE.Var> in_a_varLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_varLst)
    local
      Tpl.Text txt;
      list<Integer> rest;
      list<BackendDAE.Var> a_varLst;
      Integer x_i0;
      Integer i_i;
      DAE.ComponentRef ret_5;
      BackendDAE.Var ret_4;
      Integer ret_3;
      String ret_2;
      BackendDAE.Var ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_i :: rest,
           a_varLst )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Output "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" is var "));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] =  "));
        ret_0 = intAdd(i_i, -1);
        ret_1 = listNth(a_varLst, ret_0);
        ret_2 = BackendQSS.derPrefix(ret_1);
        txt = Tpl.writeStr(txt, ret_2);
        ret_3 = intAdd(i_i, -1);
        ret_4 = listNth(a_varLst, ret_3);
        ret_5 = BackendVariable.varCref(ret_4);
        txt = SimCodeC.cref(txt, ret_5);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_45(txt, rest, a_varLst);
      then txt;

    case ( txt,
           _ :: rest,
           a_varLst )
      equation
        txt = lm_45(txt, rest, a_varLst);
      then txt;
  end matchcontinue;
end lm_45;

public function generateOutputs
  input Tpl.Text txt;
  input BackendQSS.DevsStruct a_devsst;
  input Integer a_index;
  input list<BackendDAE.Var> a_varLst;
  input Integer a_nStates;

  output Tpl.Text out_txt;
protected
  list<Integer> ret_2;
  Integer ret_1;
  Integer ret_0;
algorithm
  ret_0 := intAdd(1, a_nStates);
  ret_1 := intAdd(a_index, ret_0);
  ret_2 := BackendQSS.getOutputs(a_devsst, ret_1);
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_45(out_txt, ret_2, a_varLst);
  out_txt := Tpl.popIter(out_txt);
end generateOutputs;

protected function lm_47
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input list<BackendDAE.Var> in_a_varLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_varLst)
    local
      Tpl.Text txt;
      list<Integer> rest;
      list<BackendDAE.Var> a_varLst;
      Integer x_i0;
      Integer i_i;
      DAE.ComponentRef ret_2;
      BackendDAE.Var ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_i :: rest,
           a_varLst )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Input "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" is var "));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.softNewLine(txt);
        ret_0 = intAdd(i_i, -1);
        ret_1 = listNth(a_varLst, ret_0);
        ret_2 = BackendVariable.varCref(ret_1);
        txt = SimCodeC.cref(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = in["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_47(txt, rest, a_varLst);
      then txt;

    case ( txt,
           _ :: rest,
           a_varLst )
      equation
        txt = lm_47(txt, rest, a_varLst);
      then txt;
  end matchcontinue;
end lm_47;

public function generateInputs
  input Tpl.Text txt;
  input BackendQSS.DevsStruct a_devsst;
  input Integer a_index;
  input list<BackendDAE.Var> a_varLst;
  input Integer a_nStates;

  output Tpl.Text out_txt;
protected
  list<Integer> ret_0;
algorithm
  ret_0 := BackendQSS.getInputs(a_devsst, a_index);
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_47(out_txt, ret_0, a_varLst);
  out_txt := Tpl.popIter(out_txt);
end generateInputs;

protected function lm_49
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_zeroCrossings)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      SimCode.SimEqSystem i_eq;
      SimCode.SimEqSystem ret_0;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_varDecls,
           a_zeroCrossings )
      equation
        ret_0 = BackendQSS.replaceZC(i_eq, a_zeroCrossings);
        (txt, a_varDecls) = SimCodeC.equation_(txt, ret_0, SimCode.contextSimulationNonDiscrete, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_49(txt, rest, a_varDecls, a_zeroCrossings);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_zeroCrossings )
      equation
        (txt, a_varDecls) = lm_49(txt, rest, a_varDecls, a_zeroCrossings);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_varDecls;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;
  input list<BackendDAE.Var> in_a_varLst;
  input Integer in_a_nStates;
  input BackendQSS.DevsStruct in_a_devsst;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_zeroCrossings, in_a_varLst, in_a_nStates, in_a_devsst)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Tpl.Text a_varDecls;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      list<BackendDAE.Var> a_varLst;
      Integer a_nStates;
      BackendQSS.DevsStruct a_devsst;
      Integer x_i0;
      list<SimCode.SimEqSystem> i_eqs;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           a_varDecls,
           _,
           _,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_varDecls,
           a_zeroCrossings,
           a_varLst,
           a_nStates,
           a_devsst )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "case "
                                }, false));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":\n",
                                    "  {\n",
                                    "  // Read inputs from in[]\n",
                                    "  #ifdef _OMC_OMPD\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_0 = intAdd(x_i0, a_nStates);
        ret_1 = intAdd(ret_0, 1);
        txt = generateInputs(txt, a_devsst, ret_1, a_varLst, a_nStates);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endif\n",
                                    "\n",
                                    "// Evalute the static function\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_49(txt, i_eqs, a_varDecls, a_zeroCrossings);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "// Write outputs to out[]\n",
                                    "#ifdef _OMC_OMPD\n"
                                }, true));
        txt = generateOutputs(txt, a_devsst, x_i0, a_varLst, a_nStates);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endif\n",
                                    "break;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_50(txt, rest, a_varDecls, a_zeroCrossings, a_varLst, a_nStates, a_devsst);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_zeroCrossings,
           a_varLst,
           a_nStates,
           a_devsst )
      equation
        (txt, a_varDecls) = lm_50(txt, rest, a_varDecls, a_zeroCrossings, a_varLst, a_nStates, a_devsst);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_50;

public function generateStaticFunc
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_odeEq;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;
  input BackendQSS.DevsStruct a_devsst;
  input list<list<SimCode.SimEqSystem>> a_BLTblocks;
  input list<BackendDAE.Var> a_varLst;
  input Integer a_nStates;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_50(out_txt, a_BLTblocks, a_varDecls, a_zeroCrossings, a_varLst, a_nStates, a_devsst);
  out_txt := Tpl.popIter(out_txt);
end generateStaticFunc;

public function generateRelation
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;
  input String in_a_e1;
  input String in_a_e2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_op, in_a_e1, in_a_e2)
    local
      Tpl.Text txt;
      String a_e1;
      String a_e2;

    case ( txt,
           DAE.LESS(ty = _),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeStr(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeStr(txt, a_e2);
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeStr(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeStr(txt, a_e2);
      then txt;

    case ( txt,
           DAE.GREATER(ty = _),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeStr(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeStr(txt, a_e1);
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeStr(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeStr(txt, a_e1);
      then txt;

    case ( txt,
           DAE.EQUAL(ty = _),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeStr(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeStr(txt, a_e2);
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = _),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeStr(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeStr(txt, a_e1);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end generateRelation;

public function generateZCExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      Tpl.Text txt_3;
      String ret_3;
      Tpl.Text l_sub;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           DAE.RELATION(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e1, a_preExp, a_varDecls) = SimCodeC.daeExp(Tpl.emptyTxt, i_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = SimCodeC.daeExp(Tpl.emptyTxt, i_exp2, a_context, a_preExp, a_varDecls);
        l_sub = generateRelation(Tpl.emptyTxt, i_operator, Tpl.textString(l_e1), Tpl.textString(l_e2));
        txt = Tpl.writeText(txt, l_sub);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_3 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unhandled expression in SimCodeQSS.generateZCExp: "));
        ret_3 = ExpressionDump.printExpStr(i_exp);
        txt_3 = Tpl.writeStr(txt_3, ret_3);
        txt = SimCodeC.error(txt, Tpl.sourceInfo("SimCodeQSS.tpl", 545, 23), Tpl.textString(txt_3));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end generateZCExp;

protected function fun_54
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relation__;
  input Tpl.Text in_a_zcExp;
  input Tpl.Text in_a_preExp;
  input list<BackendDAE.Var> in_a_varLst;
  input Integer in_a_nStates;
  input BackendQSS.DevsStruct in_a_devsst;
  input Integer in_a_offset;
  input Integer in_a_i0;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_relation__, in_a_zcExp, in_a_preExp, in_a_varLst, in_a_nStates, in_a_devsst, in_a_offset, in_a_i0)
    local
      Tpl.Text txt;
      Tpl.Text a_zcExp;
      Tpl.Text a_preExp;
      list<BackendDAE.Var> a_varLst;
      Integer a_nStates;
      BackendQSS.DevsStruct a_devsst;
      Integer a_offset;
      Integer a_i0;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample")),
           _,
           _,
           _,
           _,
           _,
           a_offset,
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "case "
                                }, false));
        ret_0 = intAdd(a_i0, a_offset);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":\n",
                                    "  // This zero crossing is a sample. This case should not be called\n",
                                    "  break;"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_zcExp,
           a_preExp,
           a_varLst,
           a_nStates,
           a_devsst,
           a_offset,
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "case "
                                }, false));
        ret_1 = intAdd(a_i0, a_offset);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":\n",
                                    "  {\n",
                                    "  #ifdef _OMC_OMPD\n",
                                    "  // Read inputs from in[]\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_2 = intAdd(1, a_nStates);
        ret_3 = intAdd(a_i0, ret_2);
        ret_4 = intAdd(a_offset, ret_3);
        txt = generateInputs(txt, a_devsst, ret_4, a_varLst, a_nStates);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endif\n",
                                    "// Evalute the ZeroCrossing function\n"
                                }, true));
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Write outputs to out[]\n",
                                    "out[0] = "
                                }, false));
        txt = Tpl.writeText(txt, a_zcExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "break;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_54;

protected function lm_55
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input list<BackendDAE.Var> in_a_varLst;
  input Integer in_a_nStates;
  input BackendQSS.DevsStruct in_a_devsst;
  input Integer in_a_offset;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varLst, in_a_nStates, in_a_devsst, in_a_offset, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      list<BackendDAE.Var> a_varLst;
      Integer a_nStates;
      BackendQSS.DevsStruct a_devsst;
      Integer a_offset;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_relation__;
      Tpl.Text l_zcExp;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest,
           a_varLst,
           a_nStates,
           a_devsst,
           a_offset,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_zcExp, l_preExp, a_varDecls) = generateZCExp(Tpl.emptyTxt, i_relation__, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = fun_54(txt, i_relation__, l_zcExp, l_preExp, a_varLst, a_nStates, a_devsst, a_offset, x_i0);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_55(txt, rest, a_varLst, a_nStates, a_devsst, a_offset, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varLst,
           a_nStates,
           a_devsst,
           a_offset,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_55(txt, rest, a_varLst, a_nStates, a_devsst, a_offset, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_55;

public function generateZeroCrossingsEq
  input Tpl.Text txt;
  input Integer a_offset;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;
  input BackendQSS.DevsStruct a_devsst;
  input list<BackendDAE.Var> a_varLst;
  input Integer a_nStates;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_55(out_txt, a_zeroCrossings, a_varLst, a_nStates, a_devsst, a_offset, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end generateZeroCrossingsEq;

protected function lm_57
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_zeroCrossings)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      SimCode.SimEqSystem i_eq;
      SimCode.SimEqSystem ret_0;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_varDecls,
           a_zeroCrossings )
      equation
        ret_0 = BackendQSS.replaceZC(i_eq, a_zeroCrossings);
        (txt, a_varDecls) = generateDiscUpdate(txt, ret_0, a_zeroCrossings, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_57(txt, rest, a_varDecls, a_zeroCrossings);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_zeroCrossings )
      equation
        (txt, a_varDecls) = lm_57(txt, rest, a_varDecls, a_zeroCrossings);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_57;

public function functionQssUpdateDiscrete
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqs;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_eqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqs, l_varDecls) := lm_57(l_eqs, a_allEquationsPlusWhen, l_varDecls, a_zeroCrossings);
  l_eqs := Tpl.popIter(l_eqs);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "void function_updateDepend(double t, int index)\n",
                                   "{\n",
                                   "  state mem_state;\n",
                                   "  time = t;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("mem_state = get_memory_state();\n"));
  out_txt := Tpl.writeText(out_txt, l_eqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("restore_memory_state(mem_state);\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionQssUpdateDiscrete;

protected function lm_59
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preDisc;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref) :: rest,
           a_varDecls )
      equation
        l_preDisc = Tpl.emptyTxt;
        (l_expPart, l_preDisc, a_varDecls) = SimCodeC.daeExp(Tpl.emptyTxt, i_exp, SimCode.contextSimulationDiscrete, l_preDisc, a_varDecls);
        txt = Tpl.writeText(txt, l_preDisc);
        txt = Tpl.softNewLine(txt);
        txt = SimCodeC.cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_59(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_59(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_59;

protected function fun_60
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> i_discEqs;
      Tpl.Text l_disc;

    case ( txt,
           SimCode.SES_MIXED(discEqs = i_discEqs),
           a_varDecls )
      equation
        l_disc = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_disc, a_varDecls) = lm_59(l_disc, i_discEqs, a_varDecls);
        l_disc = Tpl.popIter(l_disc);
        txt = Tpl.writeText(txt, l_disc);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_60;

public function generateDiscUpdate
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_60(txt, a_eq, a_varDecls);
end generateDiscUpdate;

protected function lm_62
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Simulator\n",
                                    "  {\n",
                                    "    Path = modelica/modelica_qss_integrator.h\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Parameters = "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".0 // Index\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
        txt = Tpl.nextIter(txt);
        txt = lm_62(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_62(txt, rest);
      then txt;
  end matchcontinue;
end lm_62;

public function generateIntegrators
  input Tpl.Text txt;
  input Integer a_nStates;

  output Tpl.Text out_txt;
protected
  list<Integer> ret_0;
algorithm
  ret_0 := Util.listFill(0, a_nStates);
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_62(out_txt, ret_0);
  out_txt := Tpl.popIter(out_txt);
end generateIntegrators;

protected function lm_64
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input Integer in_a_nStates;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_nStates, in_a_qssInfo)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Integer a_nStates;
      BackendQSS.QSSinfo a_qssInfo;
      Integer x_i0;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_nStates,
           a_qssInfo )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Simulator\n",
                                    "  {\n",
                                    "    Path = modelica/modelica_qss_static.h\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Parameters = "));
        ret_0 = intAdd(1, a_nStates);
        ret_1 = intAdd(x_i0, ret_0);
        ret_2 = BackendQSS.numInputs(a_qssInfo, ret_1);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".0, "));
        ret_3 = intAdd(1, a_nStates);
        ret_4 = intAdd(x_i0, ret_3);
        ret_5 = BackendQSS.numOutputs(a_qssInfo, ret_4);
        txt = Tpl.writeStr(txt, intString(ret_5));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".0, "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".0 // Inputs, Outputs, Index\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
        txt = Tpl.nextIter(txt);
        txt = lm_64(txt, rest, a_nStates, a_qssInfo);
      then txt;

    case ( txt,
           _ :: rest,
           a_nStates,
           a_qssInfo )
      equation
        txt = lm_64(txt, rest, a_nStates, a_qssInfo);
      then txt;
  end matchcontinue;
end lm_64;

public function generateStaticBlocks
  input Tpl.Text in_txt;
  input BackendQSS.QSSinfo in_a_qssInfo;
  input Integer in_a_nStates;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_qssInfo, in_a_nStates)
    local
      Tpl.Text txt;
      Integer a_nStates;
      BackendQSS.QSSinfo i_qssInfo;
      list<list<SimCode.SimEqSystem>> i_eqs;

    case ( txt,
           (i_qssInfo as BackendQSS.QSSINFO(DEVSstructure = BackendQSS.DEVS_STRUCT(outLinks = _), eqs = i_eqs)),
           a_nStates )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_64(txt, i_eqs, a_nStates, i_qssInfo);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end generateStaticBlocks;

protected function lm_66
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input BackendQSS.QSSinfo in_a_qssInfo;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input Integer in_a_nStates;
  input list<list<SimCode.SimEqSystem>> in_a_eqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_qssInfo, in_a_varDecls, in_a_preExp, in_a_nStates, in_a_eqs)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      BackendQSS.QSSinfo a_qssInfo;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer a_nStates;
      list<list<SimCode.SimEqSystem>> a_eqs;
      Integer x_i0;
      DAE.Exp i_relation__;
      Integer ret_9;
      Integer ret_8;
      Integer ret_7;
      Integer ret_6;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = (i_relation__ as DAE.RELATION(exp1 = _))) :: rest,
           a_qssInfo,
           a_varDecls,
           a_preExp,
           a_nStates,
           a_eqs )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Simulator // Block # "));
        ret_0 = listLength(a_eqs);
        ret_1 = intAdd(ret_0, a_nStates);
        ret_2 = intAdd(ret_1, x_i0);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Path = modelica/modelica_qss_static.h // Crossing function "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" for "));
        (txt, a_preExp, a_varDecls) = SimCodeC.daeExp(txt, i_relation__, SimCode.contextOther, a_preExp, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Parameters = "));
        ret_3 = listLength(a_eqs);
        ret_4 = intAdd(a_nStates, 1);
        ret_5 = intAdd(ret_3, ret_4);
        ret_6 = intAdd(x_i0, ret_5);
        ret_7 = BackendQSS.numInputs(a_qssInfo, ret_6);
        txt = Tpl.writeStr(txt, intString(ret_7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".0, 1.0, "));
        ret_8 = listLength(a_eqs);
        ret_9 = intAdd(x_i0, ret_8);
        txt = Tpl.writeStr(txt, intString(ret_9));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".0 // Inputs, Outputs, Index\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_66(txt, rest, a_qssInfo, a_varDecls, a_preExp, a_nStates, a_eqs);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_qssInfo,
           a_varDecls,
           a_preExp,
           a_nStates,
           a_eqs )
      equation
        (txt, a_varDecls, a_preExp) = lm_66(txt, rest, a_qssInfo, a_varDecls, a_preExp, a_nStates, a_eqs);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_66;

protected function fun_67
  input Tpl.Text in_txt;
  input BackendQSS.QSSinfo in_a_qssInfo;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;
  input Integer in_a_nStates;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_qssInfo, in_a_zeroCrossings, in_a_nStates)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      Integer a_nStates;
      BackendQSS.QSSinfo i_qssInfo;
      list<list<SimCode.SimEqSystem>> i_eqs;
      Tpl.Text l_preExp;
      Integer ret_2;
      Tpl.Text l_numStatic;
      Tpl.Text l_varDecls;

    case ( txt,
           (i_qssInfo as BackendQSS.QSSINFO(eqs = i_eqs)),
           a_zeroCrossings,
           a_nStates )
      equation
        l_varDecls = Tpl.emptyTxt;
        ret_2 = listLength(i_eqs);
        l_numStatic = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_preExp = Tpl.emptyTxt;
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varDecls, l_preExp) = lm_66(txt, a_zeroCrossings, i_qssInfo, l_varDecls, l_preExp, a_nStates, i_eqs);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_67;

public function generateZeroCrossingFunctions
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input BackendQSS.QSSinfo a_qssInfo;
  input Integer a_nStates;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_67(txt, a_qssInfo, a_zeroCrossings, a_nStates);
end generateZeroCrossingFunctions;

protected function lm_69
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer x_i0;
      DAE.Exp i_relation__;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = (i_relation__ as DAE.RELATION(exp1 = _))) :: rest,
           a_varDecls,
           a_preExp )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Simulator\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Path = modelica/modelica_qss_cross_detect.h // Crossing detector "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" for "));
        (txt, a_preExp, a_varDecls) = SimCodeC.daeExp(txt, i_relation__, SimCode.contextOther, a_preExp, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Parameters = "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".0\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_69(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_69(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_69;

protected function fun_70
  input Tpl.Text in_txt;
  input BackendQSS.QSSinfo in_a_qssInfo;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_qssInfo, in_a_zeroCrossings)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      list<list<SimCode.SimEqSystem>> i_eqs;
      Tpl.Text l_preExp;
      Integer ret_2;
      Tpl.Text l_numStatic;
      Tpl.Text l_varDecls;

    case ( txt,
           BackendQSS.QSSINFO(eqs = i_eqs),
           a_zeroCrossings )
      equation
        l_varDecls = Tpl.emptyTxt;
        ret_2 = listLength(i_eqs);
        l_numStatic = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_preExp = Tpl.emptyTxt;
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varDecls, l_preExp) = lm_69(txt, a_zeroCrossings, l_varDecls, l_preExp);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_70;

public function generateCrossingDetector
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input BackendQSS.QSSinfo a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_70(txt, a_qssInfo, a_zeroCrossings);
end generateCrossingDetector;

protected function lm_72
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Simulator\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Path = modelica/modelica_when_discrete.h // When clause "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Parameters = (double)("));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("),2.0,3.0\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
        txt = Tpl.nextIter(txt);
        txt = lm_72(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_72(txt, rest);
      then txt;
  end matchcontinue;
end lm_72;

public function generateWhenBlocks
  input Tpl.Text txt;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.HelpVarInfo> a_helpVars;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_72(out_txt, a_whenClauses);
  out_txt := Tpl.popIter(out_txt);
end generateWhenBlocks;

protected function lm_74
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer x_i0;
      DAE.Exp i_interval;
      DAE.Exp i_start;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {i_start, i_interval})) :: rest,
           a_varDecls,
           a_preExp )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_e1, a_preExp, a_varDecls) = SimCodeC.daeExp(Tpl.emptyTxt, i_start, SimCode.contextOther, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = SimCodeC.daeExp(Tpl.emptyTxt, i_interval, SimCode.contextOther, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Simulator\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Path = modelica/modelica_sample.h // Sample block "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" for sample("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "Parameters = (double)("
                                }, false));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_74(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_74(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_74;

public function generateSampleBlocks
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_preExp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_preExp := Tpl.emptyTxt;
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, l_varDecls, l_preExp) := lm_74(out_txt, a_zeroCrossings, l_varDecls, l_preExp);
  out_txt := Tpl.popIter(out_txt);
end generateSampleBlocks;

protected function lm_76
  input Tpl.Text in_txt;
  input list<list<Integer>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<Integer>> rest;
      list<Integer> i_c;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_c :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        ret_0 = listNth(i_c, 0);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_1 = listNth(i_c, 1);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") ; ("));
        ret_2 = listNth(i_c, 2);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_3 = listNth(i_c, 3);
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_76(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_76(txt, rest);
      then txt;
  end matchcontinue;
end lm_76;

public function generateConnections
  input Tpl.Text txt;
  input list<list<Integer>> a_conns;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_76(out_txt, a_conns);
  out_txt := Tpl.popIter(out_txt);
end generateConnections;

protected function lm_78
  input Tpl.Text in_txt;
  input list<BackendDAE.Var> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.Var> rest;
      Integer x_i0;
      BackendDAE.Var i_var;
      DAE.ComponentRef ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return  "));
        ret_0 = BackendVariable.varCref(i_var);
        txt = SimCodeC.cref(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_78(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_78(txt, rest);
      then txt;
  end matchcontinue;
end lm_78;

public function generateStateValues
  input Tpl.Text txt;
  input BackendQSS.QSSinfo a_qssInfo;

  output Tpl.Text out_txt;
protected
  list<BackendDAE.Var> ret_0;
algorithm
  ret_0 := BackendQSS.getStates(a_qssInfo);
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_78(out_txt, ret_0);
  out_txt := Tpl.popIter(out_txt);
end generateStateValues;

protected function fun_80
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end matchcontinue;
end fun_80;

protected function lm_81
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_81(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_81(txt, rest);
      then txt;
  end matchcontinue;
end lm_81;

protected function fun_82
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_82;

protected function fun_83
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end matchcontinue;
end fun_83;

protected function fun_84
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end matchcontinue;
end fun_84;

protected function fun_85
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER"));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_85;

protected function fun_86
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_84(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_85(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_86;

protected function fun_87
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "OSX" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lf2c"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-Wl,-Bstatic -lf2c -Wl,-Bdynamic"));
      then txt;
  end matchcontinue;
end fun_87;

public function simulationMakefile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      String i_makefileParams_senddatalibs;
      String i_makefileParams_ldflags;
      String i_makefileParams_cflags;
      String i_makefileParams_omhome;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      String ret_5;
      Tpl.Text l_extraCflags;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, omhome = i_makefileParams_omhome, cflags = i_makefileParams_cflags, ldflags = i_makefileParams_ldflags, senddatalibs = i_makefileParams_senddatalibs), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix) )
      equation
        l_dirExtra = fun_80(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_81(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_82(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_83(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_extraCflags = fun_86(Tpl.emptyTxt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O3 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=\n",
                                    "CC="
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS_BASED_ON_INIT_FILE="));
        txt = Tpl.writeText(txt, l_extraCflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS=$(CFLAGS_BASED_ON_INIT_FILE) -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc\" "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " -D_OMC_QSS -g\n",
                                    "LDFLAGS=-L\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" "));
        txt = Tpl.writeStr(txt, i_makefileParams_ldflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SENDDATALIBS="));
        txt = Tpl.writeStr(txt, i_makefileParams_senddatalibs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "PERL=perl\n",
                                    "\n",
                                    ".PHONY: "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv.cpp "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.cpp "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CXX) -I. -o "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(EXEEXT) "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv.cpp "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.cpp "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -lsim_ompd -linteractive $(CFLAGS) $(SENDDATALIBS) $(LDFLAGS) "));
        ret_5 = System.os();
        txt = fun_87(txt, ret_5);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv.cpp: "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".cpp\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(PERL) "));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/share/omc/scripts/convert_lines.pl $< $@.tmp\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" @mv $@.tmp $@"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end simulationMakefile;

public function simulationFileHeader
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), extObjInfo = SimCode.EXTOBJINFO(includes = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Simulation code for "));
        txt = SimCodeC.dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
        ret_0 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".\n",
                                    "\n",
                                    "#include \"modelica.h\"\n",
                                    "#include \"assert.h\"\n",
                                    "#include \"string.h\"\n",
                                    "#include \"simulation_runtime.h\"\n",
                                    "\n",
                                    "#include \"model_functions.h\"\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end simulationFileHeader;

protected function lm_90
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = SimCodeC.literalExpConst(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_90(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_90(txt, rest);
      then txt;
  end matchcontinue;
end lm_90;

public function simulationFunctionsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "#include \"model_functions.h\"\n",
                                   "extern \"C\" {\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_90(out_txt, a_literals);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := SimCodeC.functionBodies(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "\n"
                                   }, true));
end simulationFunctionsFile;

end SimCodeQSS;