package SimCodeCpp

import interface SimCodeTV;

// SECTION: SIMULATION TARGET, ROOT TEMPLATE

template translateModel(SimCode simCode) ::=
  match simCode
  case SIMCODE(modelInfo = MODELINFO(__)) then
  let()= textFile(simulationHeaderFile(simCode), '<%fileNamePrefix%>.h')
  let()= textFile(simulationCppFile(simCode), '<%fileNamePrefix%>.cpp')
  //let()= textFile(simulationInitFile(simCode), '<%fileNamePrefix%>_init.txt')
  //let()= textFile(simulationFunctionsHeaderFile(fileNamePrefix, modelInfo.functions, externalFunctionIncludes, recordDecls), '<%fileNamePrefix%>_functions.h')
  //let()= textFile(simulationFunctionsFile(fileNamePrefix, modelInfo.functions, literals), '<%fileNamePrefix%>_functions.cpp')
  //let()= textFile(recordsFile(fileNamePrefix, recordDecls), '<%fileNamePrefix%>_records.c')
  //let()= textFile(simulationMakefile(simCode), '<%fileNamePrefix%>.makefile')
     "" // empty result of the top-level template .., only side effects
end translateModel;

template translateFunctions(FunctionCode functionCode)
 "Generates C code and Makefile for compiling and calling Modelica and
  MetaModelica functions." 
::=
  match functionCode
  case FUNCTIONCODE(__) then
  
  "" // Return empty result since result written to files directly
end translateFunctions;

template simulationHeaderFile(SimCode simCode)
 "Generates code for main cpp file for simulation target."
::=
match simCode
case SIMCODE(__) then
  <<
   <%generateHeaderInlcudeString(simCode)%>
   <%generateClassDeclarationCode(simCode)%>
  
   
   >>
end simulationHeaderFile;

template simulationCppFile(SimCode simCode)
 "Generates code for main cpp file for simulation target."
::=
match simCode
case SIMCODE(__) then
  <<
   #include "stdafx.h "
   #include "SecondOrderWithSin.h "
      
   using boost::extensions::factory;
   BOOST_EXTENSION_TYPE_MAP_FUNCTION {
	types.get<std::map<std::string, factory<IDAESystem,IGlobalSettings&> > >()
	["ModelicaSystem"].set<<%fileNamePrefix%>>();
    }
    
    <%fileNamePrefix%>::<%fileNamePrefix%>(IGlobalSettings& globalSettings) 
   :SystemDefaultImplementation()
     <%simulationInitFile(simCode)%>
    { 
       // Number of equations
       <%dimension1(simCode)%>
      //DAE's are not supported yet, Index reduction is enabled
	  _dimAE = 0; // algebraic equations
	  // Initialize the state vector
	  SystemDefaultImplementation::init();
	  //Instantiate auxiliary object for event handling functionality
	  _event_handling.resetHelpVar =  boost::bind(&<%fileNamePrefix%>::resetHelpVar, this, _1);
	  _historyImpl = new HistoryImplType(globalSettings);
    }
    
    <%fileNamePrefix%>::~<%fileNamePrefix%>() 
    { 
    delete _historyImpl;
    }
   <%init(simCode)%> 
   <%writeoutput(simCode)%>
   <%DefaultImplementationCode(simCode)%>
   <%saveall(modelInfo)%>
    
   >>
end simulationCppFile;

template init(SimCode simCode)
::=
match simCode
case SIMCODE(__) then
  <<
   void <%fileNamePrefix%>::init(double ts,double te)
   {  
   <%initvar(modelInfo)%>
   <%functionInitial(initialEquations,simCode)%>
    _event_handling.init(this,<%helpvarlength(simCode)%>);
    saveAll();
    <%functionOnlyZeroCrossing(zeroCrossings,simCode)%>
    <%eventHandlingInit(modelInfo)%>
    vector<unsigned int> var_ouputs_idx;
    
   _historyImpl->setOutputs(var_ouputs_idx);
   _historyImpl->clear();
   
  
   }
  >>
end init;
  
  
template writeoutput(SimCode simCode)
::=
match simCode
case SIMCODE(__) then
  <<  
   void SecondOrderWithSin::writeOutput(const OUTPUT command)
   {
  	//Write head line
	if (command & HEAD_LINE)
	{
	vector<string> head;
	head+= <%writeoutput1(modelInfo)%>
	_historyImpl->write(head);
	}
	//Write the current values
	else
	{
	HistoryImplType::value_type_v v(<%numAlgvars(modelInfo)%>+<%numStatevars(modelInfo)%>);
	HistoryImplType::value_type_dv v2(<%numDerivativevars(modelInfo)%>);
	 <%writeoutput2(modelInfo)%>
	}
   }
  >>
end writeoutput;

template generateHeaderInlcudeString(SimCode simCode)
 "Generates header part of simulation file."
::=
match simCode
case SIMCODE(modelInfo=MODELINFO(__), extObjInfo=EXTOBJINFO(__)) then
  <<
  #pragma once
  #define BOOST_EXTENSION_SYSTEM_DECL BOOST_EXTENSION_IMPORT_DECL
  #define BOOST_EXTENSION_EVENTHANDLING_DECL BOOST_EXTENSION_IMPORT_DECL
  #include "../Implementation/SystemDefaultImplementation.h"
  #include "../../Math/Implementation/ArrayOperations.h"
  #include "../Implementation/EventHandling.h"
  #include "../../Settingsfactory/Interfaces/IGlobalSettings.h"
  #include "../../DataExchange/Interfaces/IHistory.h"
  #include "HistoryImpl.h"
  #include "policies/TextFileWriter.h"
  
  #include "Functions.h"
  /*****************************************************************************
  * 
  * Simulation code for <%fileNamePrefix%> generated by the OpenModelica Compiler.
  * System class <%fileNamePrefix%> implements the Interface IDAESystem
  *
  *****************************************************************************/
  >>
end generateHeaderInlcudeString;

template generateClassDeclarationCode(SimCode simCode)
 "Generates class declarations."
::=
match simCode
case SIMCODE(__) then
  <<
  class <%fileNamePrefix%>: public IDAESystem ,public IContinous ,public IEvent ,public ISystemProperties, public SystemDefaultImplementation
  { 
  public: 
      <%fileNamePrefix%>(IGlobalSettings& globalSettings); 
      ~<%fileNamePrefix%>();
      
       <%generateMethodDeclarationCode(simCode)%>
  
  private:    
    //Methods:
	//Saves all variables before an event is handled, is needed for the pre, edge and change operator
     void saveAll();

	 void resetHelpVar(const int index);
	 
	 //Variables:
	 EventHandling _event_handling;
	 
     <%MemberVariable(modelInfo)%>
     
     Functions _functions;
     HistoryImplType* _historyImpl;
   }
  >>
end generateClassDeclarationCode;

template DefaultImplementationCode(SimCode simCode)

::=
match simCode
case SIMCODE(__) then
<< 
  // Release instance
void <%fileNamePrefix%>::destroy()
{
	delete this;
}

// Set current integration time 
void <%fileNamePrefix%>::setTime(const double& t)
{
	SystemDefaultImplementation::setTime(t);
}

// Returns the vector with all time events 
event_times_type <%fileNamePrefix%>::getTimeEvents()
{
	return _event_handling.getTimeEvents();
}

// Provide number (dimension) of variables according to the index
int <%fileNamePrefix%>::getDimVars(const INDEX index) const
{
	return(SystemDefaultImplementation::getDimVars(index));
}

// Provide number (dimension) of right hand sides (equations and/or residuals) according to the index
int <%fileNamePrefix%>::getDimRHS(const INDEX index ) const
{
	 return(SystemDefaultImplementation::getDimRHS(index));
}

// Provide variables with given index to the system
void <%fileNamePrefix%>::giveVars(double* z, const INDEX index)
{	
	SystemDefaultImplementation::giveVars(z,index);
}

// Set variables with given index to the system
void <%fileNamePrefix%>::setVars(const double* z, const INDEX index)
{
	SystemDefaultImplementation::setVars(z,index);
}
 
// Provide the right hand side (according to the index)
void <%fileNamePrefix%>::giveRHS(double* f, const INDEX index)
{
	SystemDefaultImplementation::giveRHS(f,index);
}
void <%fileNamePrefix%>::giveJacobianSparsityPattern(SparcityPattern pattern)
{
  throw std::runtime_error("giveJacobianSparsityPattern is not yet implemented");	
}

void <%fileNamePrefix%>::giveJacobian(SparseMatrix matrix)
{
  throw std::runtime_error("giveJacobian is not yet implemented");	
}

void <%fileNamePrefix%>::giveMassSparsityPattern(SparcityPattern pattern)
{
  throw std::runtime_error("giveMassSparsityPattern is not yet implemented");	
}

void <%fileNamePrefix%>::giveMassMatrix(SparseMatrix matrix)
{
  throw std::runtime_error("giveMassMatrix is not yet implemented");	
}

void <%fileNamePrefix%>::giveConstraintSparsityPattern(SparcityPattern pattern)
{
  throw std::runtime_error("giveConstraintSparsityPattern is not yet implemented");	
}

void <%fileNamePrefix%>::giveConstraint(SparseMatrix matrix)
{
  throw std::runtime_error("giveConstraint is not yet implemented");	
}

bool <%fileNamePrefix%>::isAutonomous()
{
  throw std::runtime_error("isAutonomous is not yet implemented");	
}

bool <%fileNamePrefix%>::isTimeInvariant()
{
  throw std::runtime_error("isTimeInvariant is not yet implemented");	
}
>>
end DefaultImplementationCode;

template generateMethodDeclarationCode(SimCode simCode)

::=
match simCode
case SIMCODE(__) then
<< 
     //Releases the Modelica System 
	virtual void destroy();
    //provide number (dimension) of variables according to the index
	virtual int getDimVars(const INDEX index = ALL_VARS) const;
	//Provide number (dimension) of right hand sides (equations and/or residuals) according to the index 
	virtual int getDimRHS(const INDEX index = ALL_VARS)const;
    //(Re-) initialize the system of equations
	virtual void init(double ts,double te);
	//Resets all time events
	virtual void resetTimeEvents();
	//Set current integration time 
    virtual void setTime(const double& t);
	//Provide variables with given index to the system 
    virtual void giveVars(double* z, const INDEX index = ALL_VARS);
	//Set variables with given index to the system
	virtual void setVars(const double* z, const INDEX index = ALL_VARS);
	//Update transfer behavior of the system of equations according to command given by solver
	virtual void update(const UPDATE command =", CSYSTEM,"::UNDEF_UPDATE);
	//Provide the right hand side (according to the index)
	virtual void giveRHS(double* f, const INDEX index = ALL_VARS);
	//Output routine (to be called by the solver after every successful integration step)
	virtual void writeOutput(const OUTPUT command = UNDEF_OUTPUT);
	//Provide pattern for Jacobian
	virtual void giveJacobianSparsityPattern(SparcityPattern pattern);
	//Provide Jacobian
	virtual void giveJacobian(SparseMatrix matrix);
	//Provide pattern for mass matrix
	virtual void giveMassSparsityPattern(SparcityPattern pattern); 
	//Provide mass matrix 
	virtual void giveMassMatrix(SparseMatrix matrix);
	//Provide pattern for global constraint jacobian 
	virtual void giveConstraintSparsityPattern(SparcityPattern pattern);
	//Provide global constraint jacobian 
	virtual void giveConstraint(SparseMatrix matrix);
	//Provide number (dimension) of zero functions 
	virtual int getDimZeroFunc();
	//Provides current values of root/zero functions 
	 virtual void giveZeroFunc(double* f,const double& eps);
	//Called to handle all  events occured at same time  
	virtual void handleSystemEvents(const bool* events,update_events_type update_event);
	//Called to handle an event  
	virtual void handleEvent(unsigned long index);
	//Checks if a discrete variable has changed and triggers an event 
	virtual bool checkForDiscreteEvents();
	//Returns the vector with all time events 
	virtual event_times_type getTimeEvents();
	// No input
	virtual bool isAutonomous();
	// Time is not present
	virtual bool isTimeInvariant();
	// M is regular 
	virtual bool isODE();
	// M is singular 
	virtual bool isAlgebraic();
	//M = identity 
	virtual bool isExplicit(); 
	// M does not depend on t, z 
	virtual bool hasConstantMass(); 
	// M depends on z 
	virtual bool hasStateDependentMass(); 
	// System is able to provide the Jacobian symbolically 
	virtual bool provideSymbolicJacobian(); 
>>
end generateMethodDeclarationCode;

template MemberVariable(ModelInfo modelInfo)
 "Define membervariable in simulation file."
::=
match modelInfo
case MODELINFO(vars=SIMVARS(__)) then
  <<
  <%vars.algVars |> var =>
    MemberVariableDefine(var, "algebraics")
  ;separator="\n"%>
  <%vars.paramVars |> var =>
    MemberVariableDefine(var, "parameters")
  ;separator="\n"%>
  <%vars.intAlgVars |> var =>
    MemberVariableDefine(var, "intVariables.algebraics")
  ;separator="\n"%>
  <%vars.intParamVars |> var =>
    MemberVariableDefine(var, "intVariables.parameters")
  ;separator="\n"%>
  <%vars.boolAlgVars |> var =>
    MemberVariableDefine(var, "boolVariables.algebraics")
  ;separator="\n"%>
  <%vars.boolParamVars |> var =>
    MemberVariableDefine(var, "boolVariables.parameters")
  ;separator="\n"%>  
  <%vars.stringAlgVars |> var =>
    MemberVariableDefine(var, "stringVariables.algebraics")
  ;separator="\n"%>
  <%vars.stringParamVars |> var =>
    MemberVariableDefine(var, "stringVariables.parameters")
  ;separator="\n"%>
   <%vars.constVars |> var =>
    MemberVariableDefine(var, "constvariables")
  ;separator="\n"%>
  >>
end MemberVariable;


template MemberVariableDefine(SimVar simVar, String arrayName)
 "Generates a define statement for a varable in the global data section."
::=
match arrayName
case "algebraics" then
 	match simVar
  	case SIMVAR(__) then
      <<
       <%variableType(type_)%> <%cref(name)%>;
       >>
         end match
case "parameters" then
    match simVar
  	case SIMVAR(__) then
        << 
         <%variableType(type_)%> <%cref(name)%>;
         >>
         end match
case "intVariables.algebraics" then
    match simVar
  	case SIMVAR(__) then
        << 
          <%variableType(type_)%> <%cref(name)%>;
         >>
         end match
case "intVariables.parameters" then
    match simVar
  	case SIMVAR(__) then
        << 
           <%variableType(type_)%> <%cref(name)%>;
         >>
         end match
case "boolVariables.algebraics" then
    match simVar
  	case SIMVAR(__) then
        << 
          <%variableType(type_)%> <%cref(name)%>;
         >>
         end match
case "boolVariables.parameters" then
    match simVar
  	case SIMVAR(__) then
        << 
          <%variableType(type_)%> <%cref(name)%>;
         >>
         end match
case "stringVariables.algebraics" then
    match simVar
  	case SIMVAR(__) then
        << 
          <%variableType(type_)%> <%cref(name)%>;
         >>
         end match
case "stringVariables.parameters" then
    match simVar
  	case SIMVAR(__) then
        << 
           <%variableType(type_)%> <%cref(name)%>;
         >>
         end match
case "constvariables" then
    match simVar
  	case SIMVAR(__) then
        << 
           const <%variableType(type_)%> <%cref(name)%>;
         >>
         end match

end MemberVariableDefine;

template variableType(DAE.ExpType type)
 "Generates integer for use in arrays in global data section."
::=
  match type
  case ET_REAL(__)        then "double"
  case ET_STRING(__)      then "string"
  case ET_INT(__)         then "int"
  case ET_BOOL(__)        then "boolean"
end variableType;

template cref(ComponentRef cr)
 "Generates C equivalent name for component reference."
::=
  match cr
  case CREF_IDENT(ident = "xloc") then crefStr(cr)
  case CREF_IDENT(ident = "time") then "time"
  case WILD(__) then ''
  else "$" + crefToCStr(cr)
end cref;

template crefToCStr(ComponentRef cr)
 "Helper function to cref."
::=
  match cr
  case CREF_IDENT(__) then '<%ident%><%subscriptsToCStr(subscriptLst)%>'
  case CREF_QUAL(__) then '<%ident%><%subscriptsToCStr(subscriptLst)%>$P<%crefToCStr(componentRef)%>'
  case WILD(__) then ''
  else "CREF_NOT_IDENT_OR_QUAL"
end crefToCStr;

template subscriptsToCStr(list<Subscript> subscripts)
::=
  if subscripts then
    '$lB<%subscripts |> s => subscriptToCStr(s) ;separator="$c"%>$rB'
end subscriptsToCStr;

template subscriptToCStr(Subscript subscript)
::=
  match subscript
  case INDEX(exp=ICONST(integer=i)) then i
  case SLICE(exp=ICONST(integer=i)) then i
  case WHOLEDIM(__) then "WHOLEDIM"
  else "UNKNOWN_SUBSCRIPT"
end subscriptToCStr;

template crefStr(ComponentRef cr)
 "Generates the name of a variable for variable name array."
::=
  match cr
  case CREF_IDENT(__) then '<%ident%><%subscriptsStr(subscriptLst)%>'
  // Are these even needed? Function context should only have CREF_IDENT :)
  case CREF_QUAL(ident = "$DER") then 'der(<%crefStr(componentRef)%>)'
  case CREF_QUAL(__) then '<%ident%><%subscriptsStr(subscriptLst)%>.<%crefStr(componentRef)%>'
  else "CREF_NOT_IDENT_OR_QUAL"
end crefStr;

template subscriptsStr(list<Subscript> subscripts)
 "Generares subscript part of the name."
::=
  if subscripts then
    '[<%subscripts |> s => subscriptStr(s) ;separator=","%>]'
end subscriptsStr;

template subscriptStr(Subscript subscript)
 "Generates a single subscript.
  Only works for constant integer indicies."
::=
  match subscript
  case INDEX(exp=ICONST(integer=i)) then i
  case SLICE(exp=ICONST(integer=i)) then i
  case WHOLEDIM(__) then "WHOLEDIM"
  else "UNKNOWN_SUBSCRIPT"
end subscriptStr;

template simulationInitFile(SimCode simCode)
 "Generates the contents of the makefile for the simulation case."
::=
match simCode
case SIMCODE(modelInfo = MODELINFO(varInfo = vi as VARINFO(__), vars = vars as SIMVARS(__))) 
  then
  <<
  <%initVals(vars.paramVars)%>
  <%initVals(vars.intParamVars)%>
  <%initVals(vars.boolParamVars)%>
  <%initVals(vars.stringParamVars)%>
  >>
end simulationInitFile;

template initVals(list<SimVar> varsLst) ::=
  varsLst |> SIMVAR(__) =>
  <<
    ,<%cref(name)%>(<%match initialValue 
    case SOME(v) then initVal(v)
      else ""
    %>) 
    >>  
  ;separator="\n"
end initVals;

template initVal(Exp initialValue) 
::=
  match initialValue 
  case ICONST(__) then integer
  case RCONST(__) then real
  case SCONST(__) then '"<%Util.escapeModelicaStringToCString(string)%>"'
  case BCONST(__) then if bool then "true" else "false"
  case ENUM_LITERAL(__) then '<%index%>/*ENUM:<%dotPath(name)%>*/'
  else "*ERROR* initial value of unknown type"
end initVal;

template dotPath(Path path)
 "Generates paths with components separated by dots."
::=
  match path
  case QUALIFIED(__)      then '<%name%>.<%dotPath(path)%>'

  case IDENT(__)          then name
  case FULLYQUALIFIED(__) then dotPath(path)
end dotPath;

template writeoutput1(ModelInfo modelInfo)
 "Generates global data in simulation file."
::=
match modelInfo
case MODELINFO(vars=SIMVARS(__)) then
  <<  
      <%{(vars.algVars |> SIMVAR(__) =>
        ' "<%crefStr(name)%>" '
      ;separator=","),
      (vars.intAlgVars |> SIMVAR(__) =>
        ' "<%crefStr(name)%>" '
      ;separator=","),
      (vars.boolAlgVars |> SIMVAR(__) =>
        ' "<%crefStr(name)%>" '
      ;separator=","),
      (vars.stateVars |> SIMVAR(__) =>
        ' "<%crefStr(name)%>" '
      ;separator=","),
      (vars.derivativeVars |> SIMVAR(__) =>
        ' "<%crefStr(name)%>" '
      ;separator=",")}
    ;separator=","%>;
  >>    
end writeoutput1;

template numStatevars(ModelInfo modelInfo)
::=
match modelInfo
case MODELINFO(varInfo=VARINFO(__)) then
<<
  <%varInfo.numStateVars%>
>>
end numStatevars;

template numAlgvars(ModelInfo modelInfo)
::=
match modelInfo
case MODELINFO(varInfo=VARINFO(__)) then
<<
  <%varInfo.numAlgVars%>+<%varInfo.numIntAlgVars%>+<%varInfo.numBoolAlgVars%>
>>
end numAlgvars;

template numDerivativevars(ModelInfo modelInfo)
::=
match modelInfo
case MODELINFO(varInfo=VARINFO(__)) then
<<
  <%varInfo.dimODE1stOrder%>+<%varInfo.dimODE2ndOrder%>
>>
end numDerivativevars;


template writeoutput2(ModelInfo modelInfo)

::=
match modelInfo
case MODELINFO(vars=SIMVARS(__)) then
 <<  
     <%vars.algVars |> SIMVAR(__) =>'v(<%index%>)=<%cref(name)%>;'%>
     <%vars.intAlgVars |> SIMVAR(__) =>'v(<%index%>)=<%cref(name)%>;'%>
     <%vars.boolAlgVars |> SIMVAR(__) =>'v(<%index%>)=<%cref(name)%>;'%>
     <%(vars.stateVars  |> SIMVAR(__) =>' v(<%numAlgvars(modelInfo)%>+<%index%>)=_z[<%index%>]; ')%>
     <%(vars.derivativeVars  |> SIMVAR(__) =>' v2(<%index%>)=_zDot[<%index%>]; ')%>
   
 
 >>
end writeoutput2;

template saveall(ModelInfo modelInfo)
 
::=
match modelInfo
case MODELINFO(vars=SIMVARS(__)) then
  <<  
    void SecondOrderWithSin::saveAll()
    { 
      <%{(vars.algVars |> SIMVAR(__) =>
        '_event_handling.save(<%cref(name)%>,"<%cref(name)%>");'
      ;separator="\n"),
      (vars.intAlgVars |> SIMVAR(__) =>
       '_event_handling.save(<%cref(name)%>,"<%cref(name)%>");'
      ;separator="\n"),
      (vars.boolAlgVars |> SIMVAR(__) =>
        '_event_handling.save(<%cref(name)%>,"<%cref(name)%>");'
      ;separator="\n"),
      (vars.stateVars |> SIMVAR(__) =>
        '_event_handling.save(_z[<%index%>],"<%cref(name)%>");'
      ;separator="\n")}
     ;separator="\n"%>
     _event_handling.saveH();
    }
  >>    
end saveall;

template initvar(ModelInfo modelInfo)
::=
match modelInfo
case MODELINFO(vars=SIMVARS(__)) then
 <<  
     <%vars.algVars |> SIMVAR(__) =>'<%cref(name)%>=<%match initialValue 
    case SOME(v) then 
                << v; >>
      else "0.0;"%> ';separator="\n"%>
     <%vars.intAlgVars |> SIMVAR(__) =>'<%cref(name)%>=<%match initialValue 
    case SOME(v) then 
                << v; >>
      else "0.0;"%> ';separator="\n"%>
     <%vars.boolAlgVars |> SIMVAR(__) =>'<%cref(name)%>=<%match initialValue 
    case SOME(v) then 
                << v; >>
      else "0.0;"%> ';separator="\n"%>
 >>
end initvar;

template eventHandlingInit(ModelInfo modelInfo)

::=
match modelInfo
case MODELINFO(varInfo=VARINFO(__)) then
  << 
      for(int i=<%varInfo.numTimeEvents%>;i<<%varInfo.numZeroCrossings%>;++i) { handleEvent(i); }
  >>
end eventHandlingInit;
  

template dimension1(SimCode simCode)
::=
match simCode
case SIMCODE(modelInfo = MODELINFO(varInfo = vi as VARINFO(__)))
then
 <<
    <%modelInfo.varInfo |> VARINFO(__) =>'<%match dimODE1stOrder 
    case SOME(v) then 
               <<
                 _dimODE1stOrder = <%vi.dimODE1stOrder%>;
               >>
      else ""%> ';separator=";\n"%>
    <%modelInfo.varInfo |> VARINFO(__) =>'<%match dimODE2ndOrder 
    case SOME(v) then 
                <<
                 _dimODE2ndOrder = <%vi.dimODE2ndOrder%>;
               >> 
      else ""%> ';separator=";\n"%>
  
 >>
end dimension1;














template contextArrayCref(ComponentRef cr, Context context)
 "Generates code for an array component reference depending on the context."
::=
  match context
  case FUNCTION_CONTEXT(__) then "_" + arrayCrefStr(cr)
  else arrayCrefCStr(cr)
end contextArrayCref;

template arrayCrefStr(ComponentRef cr)
::=
  match cr
  case CREF_IDENT(__) then '<%ident%>'
  case CREF_QUAL(__) then '<%ident%>.<%arrayCrefStr(componentRef)%>'
  else "CREF_NOT_IDENT_OR_QUAL"
end arrayCrefStr;

template expTypeFlag(DAE.ExpType ty, Integer flag)
 "Generate type helper."
::=
  match flag
  case 1 then
    // we want the short type
    expTypeShort(ty)
  case 2 then
    // we want the "modelica type"
    match ty case ET_COMPLEX(complexClassType=EXTERNAL_OBJ(__)) then
      'modelica_<%expTypeShort(ty)%>'
    else match ty case ET_COMPLEX(__) then
      'struct <%underscorePath(name)%>'
    else
      'modelica_<%expTypeShort(ty)%>'
  case 3 then
    // we want the "array type"
    '<%expTypeShort(ty)%>_array'
  case 4 then
    // we want the "array type" only if type is array, otherwise "modelica type"
    match ty
    case ET_ARRAY(__) then '<%expTypeShort(ty)%>_array'
    else expTypeFlag(ty, 2)
end expTypeFlag;

template expTypeArray(DAE.ExpType ty)
 "Generate type helper."
::=
  expTypeFlag(ty, 3)
end expTypeArray;

template expTypeShort(DAE.ExpType type)
 "Generate type helper."
::=
  match type
  case ET_INT(__)         then "integer"  
  case ET_REAL(__)        then "real"
  case ET_STRING(__)      then if acceptMetaModelicaGrammar() then "metatype" else "string"
  case ET_BOOL(__)        then "boolean"
  case ET_ENUMERATION(__) then "integer"  
  case ET_OTHER(__)       then "complex"
  case ET_ARRAY(__)       then expTypeShort(ty)   
  case ET_COMPLEX(complexClassType=EXTERNAL_OBJ(__))
                      then "complex"
  case ET_COMPLEX(__)     then 'struct <%underscorePath(name)%>'  
  case ET_METATYPE(__) case ET_BOXED(__)    then "metatype"
  case ET_FUNCTION_REFERENCE_VAR(__) then "fnptr"
  else "expTypeShort:ERROR"
end expTypeShort;

template dimension(Dimension d)
::=
  match d
  case DAE.DIM_INTEGER(__) then integer
  case DAE.DIM_ENUM(__) then size
  case DAE.DIM_UNKNOWN(__) then ":"
  else "INVALID_DIMENSION"
end dimension;

template arrayCrefCStr(ComponentRef cr)
::= '$P<%arrayCrefCStr2(cr)%>'
end arrayCrefCStr;

template arrayCrefCStr2(ComponentRef cr)
::=
  match cr
  case CREF_IDENT(__) then '<%unquoteIdentifier(ident)%>'
  case CREF_QUAL(__) then '<%unquoteIdentifier(ident)%>$P<%arrayCrefCStr2(componentRef)%>'
  else "CREF_NOT_IDENT_OR_QUAL"
end arrayCrefCStr2;

template underscorePath(Path path)
 "Generate paths with components separated by underscores.
  Replaces also the . in identifiers with _. 
  The dot might happen for world.gravityAccleration"
::=
  match path
  case QUALIFIED(__) then
    '<%replaceDotAndUnderscore(name)%>_<%underscorePath(path)%>'
  case IDENT(__) then
    replaceDotAndUnderscore(name)
  case FULLYQUALIFIED(__) then
    underscorePath(path)
end underscorePath;

template replaceDotAndUnderscore(String str)
 "Replace _ with __ and dot in identifiers with _"
::=
  match str
  case name then
    let str_dots = System.stringReplace(name,".", "_")  
    let str_underscores = System.stringReplace(str_dots, "_", "__")
    '<%str_underscores%>'
end replaceDotAndUnderscore;

template tempDecl(String ty, Text &varDecls /*BUFP*/)
 "Declares a temporary variable in varDecls and returns the name."
::=
  let newVar = 'tmp<%System.tmpTick()%>'
  let initVarAddRoot 
         = match ty /* TODO! FIXME! UGLY! UGLY! hack! */ 
             case "modelica_metatype"
             case "metamodelica_string"
             case "metamodelica_string_const"
             case "stringListStringChar_rettype"
             case "stringAppendList_rettype"
             case "stringGetStringChar_rettype"
             case "stringUpdateStringChar_rettype"
             case "listReverse_rettype"
             case "listAppend_rettype"
             case "listGet_rettype"
             case "listDelete_rettype"
             case "listRest_rettype"
             case "listFirst_rettype"
             case "arrayGet_rettype"
             case "arrayCreate_rettype"
             case "arrayList_rettype"
             case "listArray_rettype"
             case "arrayUpdate_rettype"
             case "arrayCopy_rettype"
             case "arrayAdd_rettype"
             case "getGlobalRoot_rettype"
               then ' = NULL;  mmc_GC_add_root(&<%newVar%>, mmc_GC_local_state, "<%newVar%>");' else ';'
  let &varDecls += '<%ty%> <%newVar%><%initVarAddRoot%><%\n%>'
  newVar
end tempDecl;

template contextCref(ComponentRef cr, Context context)
  "Generates code for a component reference depending on which context we're in."
::=
  match context
  case FUNCTION_CONTEXT(__) then "_" + crefStr(cr)
  else cref(cr)
end contextCref;

template crefFunctionName(ComponentRef cr)
::=
  match cr
  case CREF_IDENT(__) then 
    System.stringReplace(unquoteIdentifier(ident), "_", "__")
  case CREF_QUAL(__) then 
    '<%System.stringReplace(unquoteIdentifier(ident), "_", "__")%>_<%crefFunctionName(componentRef)%>'
end crefFunctionName;

template functionInitial(list<SimEqSystem> initialEquations,SimCode simCode)
 "Generates function in simulation file."
::=
  let &varDecls = buffer "" /*BUFD*/
  let eqPart = (initialEquations |> eq as SES_SIMPLE_ASSIGN(__) =>
      equation_(eq, contextOther, &varDecls /*BUFD*/,simCode)
    ;separator="\n")
  <<
    <%varDecls%>
    <%eqPart%>
  >>
end functionInitial;


template equation_(SimEqSystem eq, Context context, Text &preExp, SimCode simCode)
 "Generates an equation.
  This template should not be used for a SES_RESIDUAL.
  Residual equations are handled differently."
::=
  match eq
  case e as SES_SIMPLE_ASSIGN(__)
    then equationSimpleAssign(e, context, &preExp,simCode)
  case e as SES_ALGORITHM(__)
    then ""
 
  else
    "NOT IMPLEMENTED EQUATION"
end equation_;

template equationSimpleAssign(SimEqSystem eq, Context context,Text &varDecls,
                              SimCode simCode)
 "Generates an equation that is just a simple assignment."
::=
match eq
case SES_SIMPLE_ASSIGN(__) then
  let &preExp = buffer "" /*BUFD*/
  let expPart = daeExp(exp, context, &preExp /*BUFC*/, &varDecls /*BUFD*/,simCode)
  <<
  <%preExp%>
  <%cref1(cref, simCode)%>=<%expPart%>;
  >>

end equationSimpleAssign;



template daeExp(Exp exp, Context context, Text &preExp /*BUFP*/, Text &varDecls /*BUFP*/,SimCode simCode)
 "Generates code for an expression."
::=
  match exp
  case e as ICONST(__)          then '(modelica_integer) <%integer%>' /* Yes, we need to cast int to long on 64-bit arch... */
  case e as RCONST(__)          then real
  case e as CREF(__)            then daeExpCrefRhs(e, context, &preExp /*BUFC*/, &varDecls /*BUFD*/,simCode)
  case SCONST(__)          then daeExpSconst(string, context, &preExp /*BUFC*/, &varDecls /*BUFD*/,simCode)
  case BINARY(__)          then daeExpBinary(operator, exp1, exp2, context, &preExp, &varDecls,simCode)
  case IFEXP(__)           then daeExpIf(expCond, expThen, expElse, context, &preExp /*BUFC*/, &varDecls /*BUFD*/, simCode)
  case RELATION(__)        then daeExpRelation(operator, exp1, exp2, context, &preExp, &varDecls,simCode)
  else ""
end daeExp;

template daeExpBinary(Operator it, Exp exp1, Exp exp2, Context context, Text &preExp,Text &varDecls /*BUFP*/, SimCode simCode) ::=
  let e1 = daeExp(exp1, context, &preExp, &varDecls, simCode)
  let e2 = daeExp(exp2, context, &preExp, &varDecls, simCode)
  match it
  case ADD(__) then '(<%e1%> + <%e2%>)'
  case SUB(__) then '(<%e1%> - <%e2%>)'
  case MUL(__) then '(<%e1%> * <%e2%>)'
  case DIV(__) then '(<%e1%> / <%e2%>)'
  case POW(__) then 'Math.Pow(<%e1%>, <%e2%>)'
  case AND(__) then '(<%e1%> && <%e2%>)'
  case OR(__)  then '(<%e1%> || <%e2%>)'
  case _   then "daeExpBinary:ERR"
end daeExpBinary;

template daeExpSconst(String string, Context context, Text &preExp /*BUFP*/, Text &varDecls /*BUFP*/,SimCode simCode)
 "Generates code for a string constant."
::=
  '"<%Util.escapeModelicaStringToCString(string)%>"'
end daeExpSconst;


template daeExpCrefRhs(Exp exp, Context context, Text &preExp /*BUFP*/,
                       Text &varDecls /*BUFP*/,SimCode simCode)
 "Generates code for a component reference on the right hand side of an
 expression."
::=
  match exp
  // A record cref without subscripts (i.e. a record instance) is handled
  // by daeExpRecordCrefRhs only in a simulation context, not in a function.
  case CREF(componentRef = cr, ty = t as ET_COMPLEX(complexClassType = RECORD(path = _))) then
    match context case FUNCTION_CONTEXT(__) then
      daeExpCrefRhs2(exp, context, &preExp, &varDecls,simCode)
    else
      daeExpRecordCrefRhs(t, cr, context, &preExp /*BUFC*/, &varDecls /*BUFD*/,simCode)
  case CREF(componentRef = cr, ty = ET_FUNCTION_REFERENCE_FUNC(__)) then
    '((modelica_fnptr)boxptr_<%crefFunctionName(cr)%>)'
  case CREF(componentRef = cr, ty = ET_FUNCTION_REFERENCE_VAR(__)) then
    '((modelica_fnptr) _<%crefStr(cr)%>)'
  else daeExpCrefRhs2(exp, context, &preExp, &varDecls,simCode)
end daeExpCrefRhs;

template daeExpRecordCrefRhs(DAE.ExpType ty, ComponentRef cr, Context context, Text &preExp /*BUFP*/,
                       Text &varDecls /*BUFP*/,SimCode simCode)
::=
match ty
case ET_COMPLEX(name = record_path, varLst = var_lst) then
  let vars = var_lst |> v => daeExp(makeCrefRecordExp(cr,v), context, &preExp, &varDecls,simCode) 
             ;separator=", "
  let record_type_name = underscorePath(record_path)
  let ret_type = '<%record_type_name%>_rettype'
  let ret_var = tempDecl(ret_type, &varDecls)
  let &preExp += '<%ret_var%> = _<%record_type_name%>(<%vars%>);<%\n%>'
  '<%ret_var%>.<%ret_type%>_1'
end daeExpRecordCrefRhs;

template daeExpCrefRhs2(Exp ecr, Context context, Text &preExp /*BUFP*/,
                       Text &varDecls /*BUFP*/,SimCode simCode)
 "Generates code for a component reference."
::=
  match ecr
  case ecr as CREF(componentRef=cr, ty=ty) then
      let box = daeExpCrefRhsArrayBox(ecr, context, &preExp, &varDecls,simCode)
    if box then
      box
    else if crefIsScalar(cr, context) then
      let cast = match ty case ET_INT(__) then "(modelica_integer)"
                          case ET_ENUMERATION(__) then "(modelica_integer)" //else ""
      '<%cast%><%contextCref(cr,context)%>'
    else 
     if crefSubIsScalar(cr) then
      // The array subscript results in a scalar
      let arrName = contextCref(crefStripLastSubs(cr), context)
      let arrayType = expTypeArray(ty)
      let dimsLenStr = listLength(crefSubs(cr))
      let dimsValuesStr = (crefSubs(cr) |> INDEX(__) =>
          daeExp(exp, context, &preExp /*BUFC*/, &varDecls /*BUFD*/,simCode)
        ;separator=", ")
      match arrayType
        case "metatype_array" then
          'arrayGet(<%arrName%>,<%dimsValuesStr%>) /* DAE.CREF */'
        else
          <<
          (*<%arrayType%>_element_addr(&<%arrName%>, <%dimsLenStr%>, <%dimsValuesStr%>))
          >>
    else
      // The array subscript denotes a slice
      let arrName = contextArrayCref(cr, context)
      let arrayType = expTypeArray(ty)
      let tmp = tempDecl(arrayType, &varDecls /*BUFD*/)
      let spec1 = daeExpCrefRhsIndexSpec(crefSubs(cr), context, &preExp /*BUFC*/, &varDecls /*BUFD*/,simCode)
      let &preExp += 'index_alloc_<%arrayType%>(&<%arrName%>, &<%spec1%>, &<%tmp%>);<%\n%>'
      tmp
end daeExpCrefRhs2;

template daeExpCrefRhsIndexSpec(list<Subscript> subs, Context context,
                                Text &preExp /*BUFP*/, Text &varDecls /*BUFP*/,SimCode simCode)
 "Helper to daeExpCrefRhs."
::=
  let nridx_str = listLength(subs)
  let idx_str = (subs |> sub =>
      match sub
      case INDEX(__) then
        let expPart = daeExp(exp, context, &preExp /*BUFC*/, &varDecls /*BUFD*/,simCode)
        <<
        (0), make_index_array(1, (int) <%expPart%>), 'S'

        >>
      case WHOLEDIM(__) then
        <<
        (1), (int*)0, 'W'
        >>
      case SLICE(__) then
        let expPart = daeExp(exp, context, &preExp /*BUFC*/, &varDecls /*BUFD*/,simCode)
        let tmp = tempDecl("modelica_integer", &varDecls /*BUFD*/)
        let &preExp += '<%tmp%> = size_of_dimension_integer_array(<%expPart%>, 1);<%\n%>'
        <<
        (int) <%tmp%>, integer_array_make_index_array(&<%expPart%>), 'A'
        >>
    ;separator=", ")
  let tmp = tempDecl("index_spec_t", &varDecls /*BUFD*/)
  let &preExp += 'create_index_spec(&<%tmp%>, <%nridx_str%>, <%idx_str%>);<%\n%>'
  tmp
end daeExpCrefRhsIndexSpec;

template daeExpCrefRhsArrayBox(Exp ecr, Context context, Text &preExp /*BUFP*/,
                               Text &varDecls /*BUFP*/,SimCode simCode)
 "Helper to daeExpCrefRhs."
::=
match ecr
case ecr as CREF(ty=ET_ARRAY(ty=aty,arrayDimensions=dims)) then
  match context
  case FUNCTION_CONTEXT(__) then ''
  else
    // For context simulation and other array variables must be boxed into a real_array
    // object since they are represented only in a double array.
    let tmpArr = tempDecl(expTypeArray(aty), &varDecls /*BUFD*/)
    let dimsLenStr = listLength(dims)
    let type = expTypeShort(aty)
     let &preExp += '<%type%>_array_create(&<%tmpArr%>, ((modelica_<%type%>*)&(<%arrayCrefCStr(ecr.componentRef)%>)), <%dimsLenStr%>);<%\n%>'
    tmpArr
    
end daeExpCrefRhsArrayBox;


template cref1(ComponentRef cr, SimCode simCode) ::=
  match cr
  case CREF_IDENT(ident = "xloc") then ""
  case CREF_IDENT(ident = "time") then "time"
  else '<%representationCref(cr, simCode) %>'
end cref1;

template representationCref(ComponentRef inCref, SimCode simCode) ::=
  cref2simvar(inCref, simCode) |> SIMVAR(__) =>
	'<%representationArrayName(varKind, type_)%>[<%index%>]'
end representationCref;

template representationArrayName(VarKind varKind, ExpType type_) ::=
  match varKind 
  case STATE(__)       then "_z"
  case STATE_DER(__)   then "_zDot"
  else "BAD_VARKIND"
end representationArrayName;

template helpvarlength(SimCode simCode) 
::=
match simCode
case SIMCODE(__) then
  let size = listLength(helpVarInfo)
  <<
   <%size%>
  >>
end helpvarlength;


template daeExpRelation(Operator op, Exp exp1, Exp exp2, Context context, Text &preExp,Text &varDecls,SimCode simCode) ::=
  let e1 = daeExp(exp1, context, &preExp, &varDecls,simCode)
  let e2 = daeExp(exp2, context, &preExp, &varDecls,simCode)
  let simrel = daeExpSimRelation(context, op, e1, e2, &preExp) 
  if  simrel then simrel
  else //non-SIMULATION context or precise equality 
    match op
    case LESS(ty = ET_BOOL(__))        then '(!<%e1%> && <%e2%>)'
    case LESS(ty = ET_STRING(__))      then "# string comparison not supported\n"
    case LESS(ty = ET_INT(__))
    case LESS(ty = ET_REAL(__))        then '(<%e1%> < <%e2%>)'
    case GREATER(ty = ET_BOOL(__))     then '(<%e1%> && !<%e2%>)'
    case GREATER(ty = ET_STRING(__))   then "# string comparison not supported\n"
    case GREATER(ty = ET_INT(__))
    case GREATER(ty = ET_REAL(__))     then '(<%e1%> > <%e2%>)'
    case LESSEQ(ty = ET_BOOL(__))      then '(!<%e1%> || <%e2%>)'
    case LESSEQ(ty = ET_STRING(__))    then "# string comparison not supported\n"
    case LESSEQ(ty = ET_INT(__))
    case LESSEQ(ty = ET_REAL(__))      then '(<%e1%> <= <%e2%>)'
    case GREATEREQ(ty = ET_BOOL(__))   then '(<%e1%> || !<%e2%>)'
    case GREATEREQ(ty = ET_STRING(__)) then "# string comparison not supported\n"
    case GREATEREQ(ty = ET_INT(__))
    case GREATEREQ(ty = ET_REAL(__))   then '(<%e1%> >= <%e2%>)'
    case EQUAL(ty = ET_BOOL(__))       then '((!<%e1%> && !<%e2%>) || (<%e1%> && <%e2%>))'
    case EQUAL(ty = ET_STRING(__))
    case EQUAL(ty = ET_INT(__))
    case EQUAL(ty = ET_REAL(__))       then '(<%e1%> == <%e2%>)'
    case NEQUAL(ty = ET_BOOL(__))      then '((!<%e1%> && <%e2%>) || (<%e1%> && !<%e2%>))'
    case NEQUAL(ty = ET_STRING(__))
    case NEQUAL(ty = ET_INT(__))
    case NEQUAL(ty = ET_REAL(__))      then '(<%e1%> != <%e2%>)'
    case _                         then "daeExpRelation:ERR"
end daeExpRelation;


template daeExpSimRelation(Context it, Operator op, Text e1, Text e2, Text &preExp) ::=
	match it
	case SIMULATION(__) then 
	   match op
	   case LESS(__)      then SimRelationSimple(e1, e2, " <", &preExp)
	   case LESSEQ(__)    then SimRelationEqual(e1, e2, " <", &preExp)
	   case GREATER(__)   then SimRelationSimple(e1, e2, " >", &preExp)
	   case GREATEREQ(__) then SimRelationEqual(e1, e2, " >", &preExp)
	   end match
end daeExpSimRelation;


template SimRelationSimple(Text e1, Text e2, String op, Text &preExp) ::=
  let &res = buffer ""    
  let &preExp += 
    <<
    // RELATION( <%e1%><%op%> <%e2%> ) macro expansion
    <%tempDecl("bool", res)%> = <%e1%><%op%> <%e2%>; <%\n%>
    >>
  res 
end SimRelationSimple;


template SimRelationEqual(Text e1, Text e2, String op, Text &preExp) ::=
  let &res = buffer ""    
  let &preExp += 
    <<
    // RELATION( <%e1%><%op%>= <%e2%> ) macro expansion
    <%tempDecl("bool", res)%>; <%\n%>
    >>
  res
end SimRelationEqual;

template daeExpIf(Exp cond, Exp then_, Exp else_, Context context, Text &preExp, Text &varDecls,SimCode simCode) ::=
  let condExp = daeExp(cond, context, &preExp, &varDecls,simCode)
 
    <<
     <%condExp%>
    >>
  
end daeExpIf;

template algStatement(DAE.Statement it, Context context, Text &preExp, Text &varDecls,SimCode simCode) ::=
  match it
  case STMT_ASSIGN(exp1 = CREF(componentRef = WILD(__)), exp = e) then
    let &preExp = buffer "" 
    let expPart = daeExp(e, context, &preExp, &varDecls, simCode)
    <<
    <%preExp%>
    <%expPart%>
    >>
  case STMT_ASSIGN(exp1 = CREF(__)) then
    let &preExp = buffer ""
    let expPart = daeExp(exp, context, &preExp,&varDecls, simCode)
    <<
    <%preExp%>
    <%scalarLhsCref(exp1, context, &preExp, &varDecls, simCode)%> = <%expPart%>;
    >>  
  case STMT_ASSIGN(__) then
    let &preExp = buffer ""
    let expPart1 = daeExp(exp1, context, &preExp, &varDecls,simCode)
    let expPart2 = daeExp(exp, context, &preExp, &varDecls,simCode)
    <<
    <%preExp%>
    <%expPart1%> = <%expPart2%>;
    >>  
  case STMT_ASSIGN_ARR(componentRef = CREF_IDENT(subscriptLst=subs as (_ :: _))) then
     let &preExp = buffer ""
     let expPart = daeExp(exp, context, &preExp,&varDecls, simCode)
     let spec = daeExpCrefRhsIndexSpec(subs, context, &preExp, &varDecls, simCode)
     <<
     <%preExp%>
     <%componentRef.ident%>.AssignSpec(<%spec%>, <%expPart%>.A);
     >>
  case STMT_ASSIGN_ARR(__) then
     let &preExp = buffer ""
     let expPart = daeExp(exp, context, &preExp, &varDecls,simCode)
     <<
     <%preExp%>
     ArrayCopy(<%expPart%>.A, <%contextCref(componentRef, context)%>.A);
     >>  
  case STMT_IF(__) then
    let &preExp = buffer ""
    let condExp = daeExp(exp, context, &preExp,&varDecls, simCode)
    <<
    <%preExp%>
    if (<%condExp%>) {
      <%statementLst |> it => algStatement(it, context, &preExp,&varDecls,simCode) ;separator="\n"%>
    }
    <%elseExpr(else_, context,&preExp, &varDecls, simCode)%>
    >>

  
  case STMT_WHILE(__)  then
    let &preExp = buffer ""
    let var = daeExp(exp, context, &preExp,&varDecls, simCode)
    <<
    for(;;) {
      <%preExp%>
      if (!<%var%>) break;
      <%statementLst |> stmt => algStatement(stmt, context, &preExp,&varDecls,simCode) ;separator="\n"%>
    }
    >>
  
   case _ then "NOT_IMPLEMENTED_ALG_STATEMENT"
      
end algStatement;

template scalarLhsCref(Exp ecr, Context context, Text &preExp,Text &varDecls, SimCode simCode) ::=
match ecr
case ecr as CREF(componentRef=CREF_IDENT(subscriptLst=subs)) then
  if crefNoSub(ecr.componentRef) then
    contextCref(ecr.componentRef, context)
  else
    daeExpCrefRhs(ecr, context, &preExp, &varDecls, simCode)
case ecr as CREF(componentRef=CREF_QUAL(__)) then
    contextCref(ecr.componentRef, context)
else
    "ONLY_IDENT_OR_QUAL_CREF_SUPPORTED_SLHS"
end scalarLhsCref;

template elseExpr(DAE.Else it, Context context, Text &preExp, Text &varDecls,SimCode simCode) ::= 
  match it
  case NOELSE(__) then ""
  case ELSEIF(__) then
    let &preExp = buffer ""
    let condExp = daeExp(exp, context, &preExp, &varDecls,simCode)
    <<
    else {
    <%preExp%>
    if (<%condExp%>) {
      <%statementLst |> it => algStatement(it, context, &preExp, &varDecls,simCode) ;separator="\n"%>
    }
    <%elseExpr(else_, context, &preExp, &varDecls,simCode)%>
    }
    >>
  case ELSE(__) then
    <<
    else {
      <%statementLst |> it => algStatement(it, context, &preExp, &varDecls,simCode) ;separator="\n"%>
    }
    >>
end elseExpr;



template expType(DAE.ExpType ty, Boolean isArray)
 "Generate type helper."
::=
  if isArray 
  then 'expType_<%expTypeArray1(ty,0)%>_NOT_YET'
  else expTypeShort(ty)
end expType;

template expTypeArray1(DAE.ExpType ty, Integer dims) ::=
<<
 SimArray<%dims%><<%expTypeShort(ty)%>>
>>
end expTypeArray1;


template functionOnlyZeroCrossing(list<ZeroCrossing> zeroCrossings,SimCode simCode)
  "Generates function in simulation file."
::=
  let &varDecls = buffer "" /*BUFD*/
  let zeroCrossingsCode = zeroCrossingsTpl2(zeroCrossings, &varDecls /*BUFD*/, simCode)
  <<
    <%varDecls%>
    <%zeroCrossingsCode%>
  
  >>
end functionOnlyZeroCrossing;

template zeroCrossingsTpl2(list<ZeroCrossing> zeroCrossings, Text &varDecls /*BUFP*/,SimCode simCode)
 "Generates code for zero crossings."
::=

  (zeroCrossings |> ZERO_CROSSING(__) hasindex i0 =>
    zeroCrossingTpl2(i0, relation_, &varDecls /*BUFD*/,simCode)
  ;separator="\n")
end zeroCrossingsTpl2;


template zeroCrossingTpl2(Integer index1, Exp relation, Text &varDecls /*BUFP*/,SimCode simCode)
 "Generates code for a zero crossing."
::=
  match relation
  case RELATION(__) then
    let &preExp = buffer "" /*BUFD*/
    let e1 = daeExp(exp1, contextOther, &preExp /*BUFC*/, &varDecls /*BUFD*/,simCode)
    let op = zeroCrossingOpFunc(operator)
    let e2 = daeExp(exp2, contextOther, &preExp /*BUFC*/, &varDecls /*BUFD*/,simCode)
    let res = tempDecl("bool", &varDecls /*BUFC*/)
    <<
    <%preExp%>
    <%res%>=(<%e1%><%op%><%e2%>);
    >>

  else
    <<
     ""
    >>
 
end zeroCrossingTpl2;

template zeroCrossingOpFunc(Operator op)
 "Generates zero crossing function name for operator."
::=
  match op
  case LESS(__)      then "<"
  case GREATER(__)   then ">"
  case LESSEQ(__)    then "<="
  case GREATEREQ(__) then ">="
end zeroCrossingOpFunc;



end SimCodeCpp;