﻿// $Id$
/**
 * This file is part of OpenModelica.
 *
 * Copyright (c) 1998-CurrentYear, Open Source Modelica Consortium (OSMC),
 * c/o Linköpings universitet, Department of Computer and Information Science,
 * SE-58183 Linköping, Sweden.
 *
 * All rights reserved.
 *
 * THIS PROGRAM IS PROVIDED UNDER THE TERMS OF GPL VERSION 3 LICENSE OR 
 * THIS OSMC PUBLIC LICENSE (OSMC-PL). 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS PROGRAM CONSTITUTES RECIPIENT'S ACCEPTANCE
 * OF THE OSMC PUBLIC LICENSE OR THE GPL VERSION 3, ACCORDING TO RECIPIENTS CHOICE. 
 *
 * The OpenModelica software and the Open Source Modelica
 * Consortium (OSMC) Public License (OSMC-PL) are obtained
 * from OSMC, either from the above address,
 * from the URLs: http://www.ida.liu.se/projects/OpenModelica or  
 * http://www.openmodelica.org, and in the OpenModelica distribution. 
 * GNU version 3 is obtained from: http://www.gnu.org/copyleft/gpl.html.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without
 * even the implied warranty of  MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE, EXCEPT AS EXPRESSLY SET FORTH
 * IN THE BY RECIPIENT SELECTED SUBSIDIARY LICENSE CONDITIONS OF OSMC-PL.
 *
 * See the full OSMC Public License conditions for more details.
 *
 * Main contributor 2010, Hubert Thierot, CEP - ARMINES (France)

 	@file WidgetOneSimVars.h
 	@brief Comments for file documentation.
 	@author Hubert Thieriot, hubert.thieriot@mines-paristech.fr
 	Company : CEP - ARMINES (France)
 	http://www-cep.ensmp.fr/english/
 	@version 0.9 
*/

#ifndef WidgetOneSimVars_H
#define WidgetOneSimVars_H

#include <QtGui/QWidget>
#include "OneSimulation.h"
#include "ui_WidgetOneSimVars.h"
#include <QtGui/QSortFilterProxyModel>
#include <QtGui/QHeaderView>
#include "Project.h"
#include "MOTab.h"
#include "WidgetTableStreams.h"

namespace Ui {
    class WidgetOneSimVarsClass;
}

class WidgetOneSimVars : public QWidget {
    Q_OBJECT

public:
    WidgetOneSimVars(Project *project, OneSimulation *problem, QWidget *parent = 0);
    ~WidgetOneSimVars();

	Ui::WidgetOneSimVarsClass *_ui;

	Project *_project;
	OneSimulation *_problem;
	MOVector<Variable> *_variables;


	QSortFilterProxyModel *_variableProxyModel;
	QSortFilterProxyModel *_overVariableProxyModel;
	QSortFilterProxyModel *_scannedVariableProxyModel;

public slots :
	void addModVariables();
	void deleteModVariables();
	void addScannedVariables();
	void deleteScannedVariables();
	void simulate();

    
};

#endif // WidgetOneSimVarsCLASS_H
