package Modelica "Modelica Standard Library (Version 3.0)"
extends Icons.Library;

annotation (
  preferredView="info",
  version="3.0",
  versionBuild="$Rev: 1169 $",
  versionDate="$Date:: 2008-09-29 08:39:42 +0200 #$",
  conversion(
    from(version="2.1", script="Scripts/ConvertModelica_from_2.2.2_to_3.0.mos"),
    from(version="2.2", script="Scripts/ConvertModelica_from_2.2.2_to_3.0.mos"),
    from(version="2.2.1", script="Scripts/ConvertModelica_from_2.2.2_to_3.0.mos"),
    from(version="2.2.2", script="Scripts/ConvertModelica_from_2.2.2_to_3.0.mos")),
  Settings(NewStateSelection=true),
  Dymola(checkSum="3361815935:1146681636"),
  Documentation(info="<HTML>
<p>
Package <b>Modelica</b> is a <b>standardized</b> and <b>free</b> package
that is developed together with the Modelica language from the
Modelica Association, see
<a href=\"http://www.Modelica.org\">http://www.Modelica.org</a>.
It is also called <b>Modelica Standard Library</b>.
It provides model components in many domains that are based on 
standardized interface definitions. Some typical examples are shown
in the next figure:
</p>
 
<p>
<img src=\"../Images/UsersGuide/ModelicaLibraries.png\">
</p>
 
<p>
For an introduction, have especially a look at:
</p>
<ul>
<li> <a href=\"Modelica://Modelica.UsersGuide.Overview\">Overview</a>
     provides an overview of the Modelica Standard Library
     inside the <a href=\"Modelica://Modelica.UsersGuide\">User's Guide</a>.</li>
<li><a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes\">Release Notes</a>
    summarizes the changes of new versions of this package.</li>
<li> <a href=\"Modelica://Modelica.UsersGuide.Contact\">Contact</a>
     lists the contributors of the Modelica Standard Library.</li>
<li> <a href=\"../help/Documentation/ModelicaStandardLibrary.pdf\">ModelicaStandardLibrary.pdf</a>
     is the complete documentation of the library in pdf format.
<li> The <b>Examples</b> packages in the various libraries, demonstrate
     how to use the components of the corresponding sublibrary.</li>
</ul>

<p>
This version of the Modelica Standard Library consists of
</p>
<ul>
<li> <b>777</b> models and blocks, and</li>
<li> <b>549</b> functions
</ul>
<p>
that are directly usable (= number of public, non-partial classes).
</p>

<p>
Copyright &copy; 1998-2008, Modelica Association.
</p>
<p>
<i>This Modelica package is <b>free</b> software; it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b> 
<a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
</p>
</HTML>
"));

package UsersGuide "User's Guide of Modelica library"

  annotation (__Dymola_DocumentationClass=true, Documentation(info="<html>
<p>
Package <b>Modelica</b> is a <b>standardized</b> and <b>pre-defined</b> package
that is developed together with the Modelica language from the
Modelica Association, see
<a href=\"http://www.Modelica.org\">http://www.Modelica.org</a>.
It is also called <b>Modelica Standard Library</b>.
It provides constants, types, connectors, partial models and model
components in various disciplines.
</p>
<p>
This is a short <b>User's Guide</b> for 
the overall library. Some of the main sublibraries have their own
User's Guides that can be accessed by the following links:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><td valign=\"top\"><a href=\"Modelica://Modelica.Electrical.Digital.UsersGuide\">Digital</a>
    </td>
      <td valign=\"top\">Library for digital electrical components based on the VHDL standard 
         (2-,3-,4-,9-valued logic)</td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.UsersGuide\">MultiBody</a>
             </td>
      <td valign=\"top\">Library to model 3-dimensional mechanical systems</td>
  </tr>

  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.Rotational.UsersGuide\">Rotational</a>
             </td>
      <td valign=\"top\">Library to model 1-dimensional mechanical systems</td>
  </tr>

  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Media.UsersGuide\">Media</a>
             </td>
      <td valign=\"top\">Property models of media</td>
  </tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.SIunits.UsersGuide\">SIunits</a> </td>
      <td valign=\"top\">Type definitions based on SI units according to ISO 31-1992</td>
  </tr>

  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.StateGraph.UsersGuide\">StateGraph</a>
             </td>
      <td valign=\"top\">Library to model discrete event and reactive systems by hierarchical state machines</td>
  </tr>


  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Utilities.UsersGuide\">Utilities</a>
             </td>
      <td valign=\"top\">Utility functions especially for scripting (Files, Streams, Strings, System)</td>
  </tr>
</table>

</html>"));

  class Overview "Overview of Modelica Library"

    annotation (Documentation(info="<html>
<p>
The Modelica Standard Library consists of the following
main sub-libraries:
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th>Library Components</th> <th>Description</th></tr>

<tr><td valign=\"top\"> 
    <img src=\"../Images/UsersGuide/Lib-Electrical.png\">
    </td>
    <td valign=\"top\">
    <a href=\"Modelica://Modelica.Electrical.Analog\">Analog</a><br>
    Analog electric and electronic components, such as <br> 
    resistor, capacitor, transformers, diodes, transistors,<br>
    transmission lines, switches, sources, sensors.
    </td>
</tr>

<tr><td valign=\"top\"> 
    <img src=\"../Images/UsersGuide/Lib-Digital.png\">
    </td>
    <td valign=\"top\">
    <a href=\"Modelica://Modelica.Electrical.Digital\">Digital</a><br>
    Digital electrical components based on the VHDL standard, <br>
    like basic logic blocks with 9-value logic, delays, gates, <br>
    sources, converters between 2-, 3-, 4-, and 9-valued logic.
    </td>
</tr>

<tr><td valign=\"top\"> 
    <img src=\"../Images/UsersGuide/Lib-Machines.png\">
    </td>
    <td valign=\"top\">
    <a href=\"Modelica://Modelica.Electrical.Machines\">Machines</a><br>
    Electrical asynchronous-, synchronous-, and DC-machines<br>
    (motors and generators) as well as 3-phase transformers.
    </td>
</tr>

<tr><td valign=\"top\"> 
    <img src=\"../Images/UsersGuide/Lib-Translational.png\">
    </td>
    <td valign=\"top\">
    <a href=\"Modelica://Modelica.Mechanics.Translational\">Translational</a><br>
    1-dim. mechanical, translational systems, e.g.,  <br>
    sliding mass, mass with stops, spring, damper.
    </td>
</tr>

<tr><td valign=\"top\"> 
    <img src=\"../Images/UsersGuide/Lib-Rotational.png\">
    </td>
    <td valign=\"top\">
    <a href=\"Modelica://Modelica.Mechanics.Rotational\">Rotational</a><br>
    1-dim. mechanical, rotational systems, e.g., inertias, gears, <br>
    planetary gears, convenient definition of speed/torque dependent friction<br>
    (clutches, brakes, bearings, ..)
    </td>
</tr>

<tr><td valign=\"top\"> 
    <img src=\"../Images/UsersGuide/Lib-MultiBody1.png\"><br>
    <img src=\"../Images/UsersGuide/Lib-MultiBody2.png\">
    </td>
    <td valign=\"top\">
    <a href=\"Modelica://Modelica.Mechanics.MultiBody\">MultiBody</a><br>
    3-dim. mechanical systems consisting of joints, bodies, force and <br>
    sensor elements. Joints can be driven by drive trains defined by<br>
    1-dim. mechanical system library (Rotational).<br>
    Every component has a default animation.<br>
    Components can be arbitrarily connected together.
    </td>
</tr>

<tr><td valign=\"top\"> 
    <img src=\"../Images/UsersGuide/Lib-Media.png\">
    </td>
    <td valign=\"top\">
    <a href=\"Modelica://Modelica.Media\">Media</a><br>
    Large media library providing models and functions<br>
    to compute media properties, such as h = h(p,T), d = d(p,T),<br>
    for the following media:
    <ul>
    <li> 1240 gases and mixtures between these gases.</li>
    <li> incompressible, table based liquids (h = h(T), etc.).</li>
    <li> compressible liquids</li>
    <li> dry and moist air</li>
    <li> high precision model for water (IF97).</li>
    </ul>
    </td>
</tr>

<tr><td valign=\"top\"> 
    <img src=\"../Images/UsersGuide/Lib-Thermal.png\">
    </td>
    <td valign=\"top\">
    <a href=\"Modelica://Modelica.Thermal.FluidHeatFlow\">FluidHeatFlow</a>, 
    <a href=\"Modelica://Modelica.Thermal.HeatTransfer\">HeatTransfer</a><br>
    Simple thermo-fluid pipe flow, especially to model cooling of machines <br>
    with air or water (pipes, pumps, valves, ambient, sensors, sources) and<br>
    lumped heat transfer with heat capacitors, thermal conductors, convection,<br>
    body radiation, sources and sensors.
    </td>
</tr>

<tr><td valign=\"top\"> 
    <img src=\"../Images/UsersGuide/Lib-Blocks1.png\"><br>
    <img src=\"../Images/UsersGuide/Lib-Blocks2.png\">
    </td>
    <td valign=\"top\">
    <a href=\"Modelica://Modelica.Blocks\">Blocks</a><br>
    Input/output blocks to model block diagrams and logical networks, e.g.,<br>
    integerator, PI, PID, transfer function, linear state space system,<br>
    sampler, unit delay, discrete transfer function, and/or blocks,<br>
    timer, hysteresis, nonlinear and routing blocks, sources, tables.
    </td>
</tr>

<tr><td valign=\"top\"> 
    <img src=\"../Images/UsersGuide/Lib-StateGraph.png\">
    </td>
    <td valign=\"top\">
    <a href=\"Modelica://Modelica.StateGraph\">StateGraph</a><br>
    Hierarchical state machines with a similar modeling power as Statecharts. <br>
    Modelica is used as synchronous action language, i.e. deterministic <br>
    behavior is guaranteed
    </td>
</tr>


<tr><td valign=\"top\"> 
    <pre>
    A = [1,2,3; 
         3,4,5;
         2,1,4];
    b = {10,22,12};
    x = Matrices.solve(A,b); 
    Matrices.eigenValues(A); 
    </pre>
    </td>
    <td valign=\"top\">
    <a href=\"Modelica://Modelica.Math\">Math</a>, 
    <a href=\"Modelica://Modelica.Utilities\">Utilities</a><br>
    Functions operating on vectors and matrices, such as for solving <br>
    linear systems, eigen and singular values etc.,  and <br>
    functions operating on strings, streams, files, e.g., <br>
    to copy and remove a file or sort a vector of strings.
    </td>
</tr>

</table>

</html>
"));
  end Overview;

  class Connectors "Connectors"

    annotation (Documentation(info="<html>

<p>
The Modelica standard library defines the most important 
<b>elementary connectors</b> in various domains. If any possible, 
a user should utilize these connectors in order that components
from the Modelica Standard Library and from other libraries
can be combined without problems. The following elementary
connectors are defined (potential variables are connector variables
without the flow attribute, flow variables are connector variables
that have the flow attribute):
</p>
 
<table border=1 cellspacing=0 cellpadding=1>
  <tr><td valign=\"top\"><b>domain</b></td>
      <td valign=\"top\"><b>pot. variables</b></td>
      <td valign=\"top\"><b>flow variables</b></td>
      <td valign=\"top\"><b>connector definition</b></td>
      <td valign=\"top\"><b>icons</b></td></tr>
 
  <tr><td valign=\"top\"><b>electrical<br>analog</b></td>
      <td valign=\"top\">electrical potential</td>
      <td valign=\"top\">electrical current</td>
      <td valign=\"top\"><a href=\"Modelica://Modelica.Electrical.Analog.Interfaces\">Modelica.Electrical.Analog.Interfaces</a>
           <br>Pin, PositivePin, NegativePin</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/ElectricalPins.png\"></td></tr>

  <tr><td valign=\"top\"><b>electrical<br>multi-phase</b></td>
      <td colspan=\"2\">vector of electrical pins</td>
      <td valign=\"top\"><a href=\"Modelica://Modelica.Electrical.MultiPhase.Interfaces\">Modelica.Electrical.MultiPhase.Interfaces</a>
           <br>Plug, PositivePlug, NegativePlug</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/ElectricalPlugs.png\"></td></tr>
  
  <tr><td valign=\"top\"><b>electrical <br>sphace phasor</b></td>
      <td valign=\"top\">2 electrical potentials</td>
      <td valign=\"top\">2 electrical currents</td>
      <td valign=\"top\"><a href=\"Modelica://Modelica.Electrical.Machines.Interfaces\">Modelica.Electrical.Machines.Interfaces</a>
           <br>SpacePhasor</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/SpacePhasor.png\"></td></tr>
  
  <tr><td valign=\"top\"><b>electrical <br>digital</b></td>
      <td valign=\"top\">Integer (1..9)</td>
      <td valign=\"top\">---</td>
      <td valign=\"top\"><a href=\"Modelica://Modelica.Electrical.Digital.Interfaces\">Modelica.Electrical.Digital.Interfaces</a>
           <br>DigitalSignal, DigitalInput, DigitalOutput</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/Digital.png\"></td></tr>
  
  <tr><td valign=\"top\"><b>translational</b></td>
      <td valign=\"top\">distance</td>
      <td valign=\"top\">cut-force</td>
      <td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.Translational.Interfaces\">Modelica.Mechanics.Translational.Interfaces</a>
           <br>Flange_a, Flange_b</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/TranslationalFlanges.png\"></td></tr>
 
  <tr><td valign=\"top\"><b>rotational</b></td>
      <td valign=\"top\">angle</td>
      <td valign=\"top\">cut-torque</td>
      <td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.Rotational.Interfaces\">Modelica.Mechanics.Rotational.Interfaces</a>
           <br>Flange_a, Flange_b</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/RotationalFlanges.png\"></td></tr>

  <tr><td valign=\"top\"><b>3-dim.<br>mechanics</b></td>
      <td valign=\"top\">position vector<br>
          orientation object</td>
      <td valign=\"top\">cut-force vector<br>
          cut-torque vector</td>
      <td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody.Interfaces\">Modelica.Mechanics.MultiBody.Interfaces</a>
           <br>Frame, Frame_a, Frame_b, Frame_resolve</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/MultiBodyFrames.png\"></td></tr>

  <tr><td valign=\"top\"><b>simple<br>fluid flow</b></td>
      <td valign=\"top\">pressure<br>
          specific enthalpy</td>
      <td valign=\"top\">mass flow rate<br>
          enthalpy flow rate</td>
      <td valign=\"top\"><a href=\"Modelica://Modelica.Thermal.FluidHeatFlow.Interfaces\">Modelica.Thermal.FluidHeatFlow.Interfaces</a>
           <br>FlowPort, FlowPort_a, FlowPort_b</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/FluidHeatFlowPorts.png\"></td></tr>

  <tr><td valign=\"top\"><b>heat<br>transfer</b></td>
      <td valign=\"top\">temperature</td>
      <td valign=\"top\">heat flow rate</td>
      <td valign=\"top\"><a href=\"Modelica://Modelica.Thermal.HeatTransfer.Interfaces\">Modelica.Thermal.HeatTransfer.Interfaces</a>
           <br>HeatPort, HeatPort_a, HeatPort_b</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/ThermalHeatPorts.png\"></td></tr>
 
  <tr><td valign=\"top\"><b>block<br>diagram</b></td>
      <td valign=\"top\">Real variable<br>
          Integer variable<br>
          Boolean variable</td>
      <td valign=\"top\">---</td>
      <td valign=\"top\"><a href=\"Modelica://Modelica.Blocks.Interfaces\">Modelica.Blocks.Interfaces</a>
           <br>RealSignal, RealInput, RealOutput<br>
               IntegerSignal, IntegerInput, IntegerOutput<br>
               BooleanSignal, BooleanInput, BooleanOutput</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/Signals.png\"></tr>

  <tr><td valign=\"top\"><b>state<br>machine</b></td>
      <td valign=\"top\">Boolean variables<br>
          (occupied, set, <br>
           available, reset)</td>
      <td valign=\"top\">---</td>
      <td valign=\"top\"><a href=\"Modelica://Modelica.StateGraph.Interfaces\">Modelica.StateGraph.Interfaces</a>
           <br>Step_in, Step_out, Transition_in, Transition_out</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/StateGraphPorts.png\"></td></tr>

  <tr><td colspan=\"5\">&nbsp;<br><b>Connectors from libraries that will be included in one of 
                                   the next releases of package Modelica</b></td></tr>

  <tr><td valign=\"top\"><b>thermo<br>fluid flow</b></td>
      <td valign=\"top\">pressure<br>
          specific enthalpy<br>
          mass fractions</td>
      <td valign=\"top\">mass flow rate<br>
          enthalpy flow rate<br>
          subst. mass flow rates</td>
      <td valign=\"top\">Modelica_Fluid.Interfaces
           <br>FluidPort, FluidPort_a, FluidPort_b</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/FluidPorts.png\"></td></tr>

  <tr><td valign=\"top\"><b>magnetic</b></td>
      <td valign=\"top\">magnetic potential</td>
      <td valign=\"top\">magnetic flux</td>
      <td valign=\"top\">Magnetic.Interfaces
           <br>MagneticPort, PositiveMagneticPort, <br>NegativeMagneticPort</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/MagneticPorts.png\"></td></tr>


  <tr><td colspan=\"5\">&nbsp;<br><b>Connectors from other libraries</b></td></tr>

  <tr><td valign=\"top\"><b>hydraulic</b></td>
      <td valign=\"top\">pressure</td>
      <td valign=\"top\">volume flow rate</td>
      <td valign=\"top\">HyLibLight.Interfaces
           <br>Port_A, Port_b</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/HydraulicPorts.png\"></td></tr>

  <tr><td valign=\"top\"><b>pneumatic</b></td>
      <td valign=\"top\">pressure</td>
      <td valign=\"top\">mass flow rate</td>
      <td valign=\"top\">PneuLibLight.Interfaces
           <br>Port_1, Port_2</td>
      <td valign=\"top\"><img src=\"../Images/UsersGuide/PneumaticPorts.png\"></td></tr>
</table>

<p>
In all domains, usually 2 connectors are defined. The variable declarations
are <b>identical</b>, only the icons are different in order that it is easy
to distinguish connectors of the same domain that are attached at the same
component.
</p>

<p>
Modelica supports also hierarchical connectors, in a similar way as hierarchical models. 
As a result, it is, e.g., possible, to collect elementary connectors together. 
For example, an electrical plug consisting of two electrical pins can be defined as:
</p>

<pre>   <b>connector</b> Plug
      <b>import</b> Modelica.Electrical.Analog.Interfaces;
      Interfaces.PositivePin phase;
      Interfaces.NegativePin ground;
   <b>end</b> Plug;
</pre>

<p>
With one connect(..) equation, either two plugs can be connected 
(and therefore implicitly also the phase and ground pins) or a 
Pin connector can be directly connected to the phase or ground of 
a Plug connector, such as \"connect(resistor.p, plug.phase)\".
</p>


</html>
"));
  end Connectors;

  class Conventions "Conventions"

    annotation (Documentation(info="<html>

<p>
Note, in the html documentation of any Modelica library, 
the headings \"h1, h2, h3\" should not be used,
because they are utilized from the automatically generated documentation/headings.
Additional headings in the html documentation should start with \"h4\".
</p>

<p>
In the Modelica package the following conventions are used:
</p>
<ol>
<li> Class and instance names are written in upper and lower case
     letters, e.g., \"ElectricCurrent\". An underscore is only used
     at the end of a name to characterize a lower or upper index,
     e.g., \"pin_a\".<br>&nbsp;</li>

<li> <b>Class names</b> start always with an upper case letter.<br>&nbsp;</li>

<li> <b>Instance names</b>, i.e., names of component instances and
     of variables (with the exception of constants), 
     start usually with a lower case letter with only
     a few exceptions if this is common sense 
     (such as \"T\" for a temperature variable).<br>&nbsp;</li>

<li> <b>Constant names</b>, i.e., names of variables declared with the
     \"constant\" prefix, follow the usual naming conventions 
     (= upper and lower case letters) and start usually with an 
     upper case letter, e.g. UniformGravity, SteadyState.<br>&nbsp;<li>

<li> The two connectors of a domain that have identical declarations
     and different icons are usually distinguished by \"_a\", \"_b\"
     or \"_p\", \"_n\", e.g., Flange_a/Flange_b, HeatPort_a, HeatPort_b.<br>&nbsp;</li>

<li> The <b>instance name</b> of a component is always displayed in its icon
     (= text string \"%name\") in <b>blue color</b>. A connector class has the instance
     name definition in the diagram layer and not in the icon layer.
     <b>Parameter</b> values, e.g., resistance, mass, gear ratio, are displayed
     in the icon in <b>black color</b> in a smaller font size as the instance name.
    <br>&nbsp;<li>

<li> A main package has usually the following subpackages:
     <ul>
     <li><b>UsersGuide</b> containing an overall description of the library
         and how to use it.</li>  
     <li><b>Examples</b> containing models demonstrating the
         usage of the library.</li>  
     <li><b>Interfaces</b> containing connectors and partial
         models.</li>  
     <li><b>Types</b> containing type, enumeration and choice
         definitions.</li>
     </ul>
     </li>
</ol>

</html>
"));
  end Conventions;

  class ParameterDefaults "Parameter defaults"

    annotation (Documentation(info="<html>

<p>
In this section the convention is summarized how default parameters are
handled in the Modelica Standard Library (since version 3.0).
</p>

<p>
Many models in this library have parameter declarations to define
constants of a model that might be changed before simulation starts.
Example:
</p>

<blockquote>
<pre>
<b>model</b> SpringDamper
   <b>parameter</b> Real c(final unit=\"N.m/rad\")    = 1e5 \"Spring constant\";
   <b>parameter</b> Real d(final unit=\"N.m.s/rad\")  = 0   \"Damping constant\";
   <b>parameter</b> Modelica.SIunits.Angle phi_rel0 = 0   \"Unstretched spring angle\";
   ...
<b>end</b> SpringDamper;
</pre>
</blockquote>

<p>
In Modelica it is possible to define a default value of a parameter in
the parameter declaration. In the example above, this is performed for
all parameters. Providing default values for all parameters can lead to
errors that are difficult to detect, since a modeler may have forgotten
to provide a meaningful value (the model simulates but gives wrong
results due to wrong parameter values). In general the following basic
situations are present:
</p>

<ol>
<li> The parameter value could be anything (e.g., a spring constant or
     a resistance value) and therefore the user should provide a value in
     all cases. A Modelica translator should warn, if no value is provided.
     <br><br></li>

<li> The parameter value is not changed in &gt; 95 % of the cases
     (e.g. initialization or visualization parameters, or parameter phi_rel0
     in the example above). In this case a default parameter value should be
     provided, in order that the model or function can be conveniently
     used by a modeler.
     <br><br></li>

<li> A modeler would like to quickly utilize a model, e.g.,
     <ul>
     <li> to automatically check that the model still translates and/or simulates
          (after some changes in the library),</li>
     <li> to make a quick demo of a library by drag-and-drop of components,</li>
     <li> to implement a simple test model in order to get a better understanding
          of the desired component.</li>
     </ul>
     In all these cases, it would be not practical, if the modeler would
     have to provide explicit values for all parameters first.
     </li>
</ol>

<p>
To handle the conflicting goals of (1) and (3), the Modelica Standard Library
uses two approaches to define default parameters, as demonstrated with the
following example:
</p>

<blockquote>
<pre>
<b>model</b> SpringDamper
   <b>parameter</b> Real c(final unit=\"N.m/rad\"  , start=1e5) \"Spring constant\";
   <b>parameter</b> Real d(final unit=\"N.m.s/rad\", start=  0) \"Damping constant\";
   <b>parameter</b> Modelica.SIunits.Angle phi_rel0 = 0       \"Unstretched spring angle\";
   ...
<b>end</b> SpringDamper;

SpringDamper sp1;              // warning for \"c\" and \"d\"
SpringDamper sp2(c=1e4, d=0);  // fine, no warning
</pre>
</blockquote>

<p>
Both definition forms, using a \"start\" value (for \"c\" and \"d\") and providing
a declaration equation (for \"phi_rel0\"), are valid Modelica and define the value
of the parameter. By convention, it is expected that Modelica translators will
trigger a warning message for parameters that are <b>not</b> defined by a declaration
equation, by a modifier equation or in an initial equation/algorithm section. 
A Modelica translator might have options to change this behavior, especially,
that no messages are printed in such cases and/or that an error is triggered
instead of a warning.
</p>

</html>
"));
  end ParameterDefaults;

  package ReleaseNotes "Release notes"
  class Version_3_0_BugFixes "Version 3.0 with bug fixes"

      annotation (Documentation(info="<html>
 
<p>
In this section bug fixes are summarized that have been incorporated
since the release of version 3.0.
</p>
 
<p><br>
The following <b style=\"color:red\">critical errors</b> have been fixed (i.e. errors
that can lead to wrong simulation results):
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Forces</b></td></tr>
  <tr><td valign=\"top\"> WorldTorque </td>
      <td valign=\"top\"> Parameter \"ResolveInFrame\" was not propagated and therefore
                        always the default (resolved in world frame) was used, independently
                        of the setting of this parameter. </td> 
  </tr>
  <tr><td valign=\"top\"> WorldForceAndTorque </td>
      <td valign=\"top\"> Parameter \"ResolveInFrame\" was not propagated and therefore
                        always the default (resolved in world frame) was used, independently
                        of the setting of this parameter.<br>
                        Furthermore, internally WorldTorque was used instead of
                        Internal.BasicWorldTorque and therefore the visualization of
                        worldTorque was performed twice. </td> 
  </tr>
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Sensors</b></td></tr>
  <tr><td valign=\"top\"> AbsoluteSensor </td>
      <td valign=\"top\"> Velocity, acceleration and angular acceleration were computed
                          by differentiating in the resolveInFrame frame. This has been corrected, by
                          first transforming the vectors in to the world frame, differentiating here
                          and then transforming into resolveInFrame. The parameter in the Advanced menue
                          resolveInFrameAfterDifferentiation is then superfluous and was removed . </td> 
  </tr>
  <tr><td valign=\"top\"> AbsoluteVelocity </td>
      <td valign=\"top\"> The velocity was computed
                          by differentiating in the resolveInFrame frame. This has been corrected, by
                          first transforming the velocity in to the world frame, differentiating here
                          and then transforming into resolveInFrame </td> 
  </tr>
  <tr><td valign=\"top\"> RelativeSensor </td>
      <td valign=\"top\"> If resolveInFrame &lt;&gt; frame_resolve and 
                           resolveInFrameAfterDifferentiation = frame_resolve, a translation
                        error occured, since frame_resolve was not enabled in this situation.
                        This has been corrected.</td> 
  </tr>
  <tr><td valign=\"top\"> RelativeVelocity </td>
      <td valign=\"top\"> The velocity has have been computed
                          by differentiating in the resolveInFrame frame. This has been corrected, by
                          first transforming the relative position in to frame_a, differentiating here
                          and then transforming into resolveInFrame </td> 
  </tr>
  <tr><td valign=\"top\"> TransformRelativeVector </td>
      <td valign=\"top\"> The transformation was wrong, since the parameters frame_r_in and frame_r_out
                        have not been propagated to the submodel that performs the transformation.
                        This has been corrected. </td> 
  </tr>

  <tr><td colspan=\"2\"><b>Mechanics.Translational.Components.</b></td></tr>
  <tr><td valign=\"top\"> SupportFriction<br>
                        Brake </td>
      <td valign=\"top\"> The sign of the friction force was wrong and therefore friction accelerated
                        instead of decelerated. This was fixed. In order to test the changes,
                        Translational.Examples.Friction was enhanced to use also the SupportFriction
                        component and a new example Translational.Examples.Brake was introduced. </td> 
  </tr>
 
</table>
 
 
<p><br>
The following <b style=\"color:red\">uncritical errors</b> have been fixed (i.e. errors
that do <b style=\"color:red\">not</b> lead to wrong simulation results, but, e.g., 
units are wrong or errors in documentation):
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
  <tr><td colspan=\"2\"><b>Blocks.Math.</b></td></tr>
  <tr><td valign=\"top\"> InverseBlockConstraint </td>
      <td valign=\"top\"> Changed annotation preserveAspectRatio from true to false.</td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Blocks.Sources.</b></td></tr>
  <tr><td valign=\"top\"> RealExpression<br>
                        IntegerExpression<br>
                        BooleanExpression </td>
      <td valign=\"top\"> Changed annotation preserveAspectRatio from true to false.</td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Analog.Basic.</b></td></tr>
  <tr><td valign=\"top\"> SaturatingInductor</td>
      <td valign=\"top\"> Replaced non-standard \"arctan\" by \"atan\" function.</td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Interfaces.PartialSimpleMedium</b></td></tr>
  <tr><td valign=\"top\"> pressure<br> 
                        temperature<br>
                        density<br>
                        specificEnthalpy </td>
      <td valign=\"top\"> Missing functions added.</td> 
  </tr>
</table>
                                                
</html>"));
  end Version_3_0_BugFixes;

    annotation (Documentation(info="<html>

<p>
This section summarizes the changes that have been performed
on the Modelica standard library.
</p>

<ul>
<li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_3_0\">Version 3.0</a> (Jan., 2008)</li>
<li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_2_2_2\">Version 2.2.2</a> (Aug. 31, 2007)</li>
<li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_2_2_1\">Version 2.2.1</a> (March 24, 2006)</li>
<li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_2_2\">Version 2.2</a> (April 6, 2005)</li>
<li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_2_1\">Version 2.1</a> (Nov. 11, 2004)</li>
<li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_1_6\">Version 1.6</a> (June 21, 2004)</li>
<li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_1_5\">Version 1.5</a> (Dec. 16, 2002)</li>
<li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_1_4\">Version 1.4</a> (June 28, 2001
     and previous versions)</li>
</ul>

<p>
Maintenance of the Modelica Standard Library is performed with
three branches on the subversion server of the Modelica Association:
</p>

<h4>Released branch</h4>
<p>
Example: \"Modelica/tags/V2_2_1/Modelica\"
</p>

<p>
This branch contains the released Modelica versions (e.g. version 2.2.1),
where all available test cases and compatibility checks with other Modelica
libraries have been performed on the respective release. This version is
usually shipped with a Modelica modelling and simulation environment and
utilized by a Modelica user.
</p>

<h4>Development branch</h4>
<p>
Example: \"Modelica/trunk/Modelica\"
</p>

<p>
This branch contains the actual development version, i.e., all bug fixes
and new features based on the last Modelica release.
New features should have been tested before including them.
However, the exhaustive tests for a new version are (usually) not performed.
This version is usually only be used by the developers of the
Modelica Standard Library and is not utilized by Modelica users.
</p>


<h4>Maintenance branch</h4>
<p>
Example: \"Modelica/branches/maintenance/2.2.1/Modelica\"
</p>

<p>
This branch contains the released Modelica version (e.g. version 2.2.1)
where all bug fixes since this release date are included (up to a  new release,
when becoming available; i.e., after a new release, the previous maintenance
versions are no longer changed).
These bug fixes might be not yet tested with all test cases or with
other Modelica libraries. The goal is that a vendor may take this version at
any time for a new release of its software, in order to incorporate the latest
bug fixes, without changing the version number of the Modelica Standard Library.
</p>

<p>
Incorporation of bug fixes (subversion \"commit\") shall be performed in the following way:
</p>

<ul>
<li> One person is fixing the bug and another person is checking whether the 
     fix is fine.</li>
<li> It is up to the library developer, whether he opens a new branch for
     testing and then merges it with the \"head\" maintenance branch or not.</li>
<li> Every change to the maintenance branch has to be done at the development 
     branch (see above) as well.</li>
<li> Every change to the maintenance branch requires introducing a
     description of the bug fix under
     Modelica.UsersGuide.ReleaseNotes.&lt;release-number&gt;_bugFixes.</li>
<li> Every change to the maintenance branch requires changing the date 
     and the subversion build number in the version annotation. This is automatically
     performed once a committ of file Modelica\\package.mo is performed.
     Example:<br>
     <pre>annotation(version=\"3.0\", versionBuild=\"$Rev: 1169 $\",versionDate=\"$Date:: 2008-09-29 08:39:42 +0200 #$\").</pre></li>
<li> If time does not permit, a vendor makes the bug fix in its local version
     and then has to include it in the maintenance version. It would be best to make these
     changes at a new branch in order to get a unique release number.</li>
</ul>

<p>
A valid \"commit\" to the maintenance branch may contain one or
more of the following changes.
</p>

<ul>
<li> Correcting an equation.</li>
<li> Correcting attributes quantity/unit/defaultUnit in a declaration.</li>
<li> Improving/fixing the documentation.</li>
<li> Introducing a new name in the public section of a class
     (model, package, ...) or in any section of a partial class is <b>not</b> allowed.
     Since otherwise, a user might use this new name and when storing its model
     and loading it with an older build-version, an error would occur.</li>
<li> Introducing a new name in the protected section of a non-partial
     class should only be done if absolutely necessary to fix a bug. 
     The problem is that this might be non-backward compatible,
     because a user might already extend from this class and already using the same name.</li> 
</ul>
</html>
"));

  class Version_3_0 "Version 3.0 (Feb., 2008)"

      annotation (Documentation(info="<html>
<p>
Version 3.0 is <b>not</b> backward compatible to previous versions.
A conversion script is provided to transform models and libraries
of previous versions to the new version. Therefore, conversion 
should be automatic.
</p>

<p>
The following changes are present for the whole library:
</p>

<ul>
<li> In the Modelican language version 3.0, several restrictions have been
     introduced to allow better checking, e.g., models on all levels must be balanced
     (number of equations = number of unknown variables - unknown variables that have
     to be defined when using the component). A few models of the Modelica
     Standard Library did not fulfill these new restrictions and had
     either to be moved to library ObsoleteModelica3 (e.g. Blocks.Math.TwoInputs)
     or had to be differently implemented 
     (e.g. Media.Interfaces.PartialMedium.BaseProperties).
     The Modelica Standard Library version 3.0 fulfills all the restrictions of
     the Modelica Language version 3.0.<br>&nbsp;
     </li>

<li> The graphical annotations describing the layout of icon and diagram layer
     are changed from Modelica language version 1 to Modelica language version 3.
     This gives several significant improvements:<br>Especially, the coordinate systems
     of icon and diagram layers are no longer coupled and therefore the size of the
     icon layer can be changed independently of the size of the diagram layer.
     Also it can be defined that the aspect ratio of a component icon is kept when changing
     its size in a model. This flag is set so that all icons of the Modelica
     Standard Library keep its aspect ratios. This is slightly non-backward compatible:
     If the aspect ratio was not kept when using a component from the Modelica
     Standard Library, it is now resized so that the aspect ratio is maintained.<br>&nbsp; </li>

<li> All non-standard annotations removed by:<br>
     (1) Removing the annotation since without effect 
         (e.g., \"experimentSetupOutput\", \"Window\", \"Terminal\" removed).<br>
     (2) Renaming the annotation to a standard name (e.g., \"Hide\" renamed to \"HideResult\").<br>
     (3) Renaming the annotation to a vendor specific name 
         (e.g., \"checkBox\" renamed to \"__Dymola_checkBox\").<br>&nbsp; </li>

<li> All emulated enumerations (defined via packages and constants) have been 
     replaced by \"real\" enumerations. User models are automatically correctly
     converted, provided the user models used the package constants previously.
     <b>Existing models that use directly literal values for enumerations, might give in 
     some cases wrong results</b> (if the first constant of the emulated enumeration
     had value zero, whereas the first value of an enumeration is one).<br>&nbsp; </li>

<li> The operator \"cardinality\" will be removed in one of the next versions of the
     Modelica language, since it is a reflective operator and its usage significantly
     reduces the possibilities of advanced model checks (e.g. to guarantee that a model
     is \"balanced\", i.e., the number of equations and unknowns is identical,
     for all valid usages of the component). As a preparation for this change, all
     models that contain the \"cardinality(..)\" operator are rewritten: If possible
     the operator is removed. If this is not possible, it is only used in asserts to
     check that, e.g., a connector is connected at least once or is connected exactly
     once. In the next Modelica language version new language elements will be introduced
     to specifiy such a property check without the cardinality operator. Once these
     language elements are available, the cardinality operator will be removed completely
     from the Modelica Standard Library.<br>
     The changes with respect to the cardinality(..) operator are usually not backward
     compatible. This is the reason for the changes of the
     Rotational and Translational library (see below).<br>&nbsp;</li>

<li> The design of the <b>Rotational</b> and <b>Translational</b> libraries have been changed
     (especially to remove the cardinality(..) operator, see above):
     <ul>
     <li> Components have a <b>useSupport</b> flag to enable or disable a support flange.
          If the support flange is enabled, it must be connected. If it is disabled, it must
          not be connected and the component is then internally grounded. The grounding
          is visualized in the icon.</li>
     <li> The relative angle/distance and the relative speed of all force/torque elements
          (that need the relative speed) are by default defined with \"StateSelect.prefer\", i.e.,
          to use these variables as preferred states. This improves the numerics if the
          absolute angle or the absolute distance are continuously increasing during
          operation (e.g. driving shaft of the wheels of a car). The effect is that relative
          angles/distances and speeds are used as states and the size of these variables is
          limited. Previously, the default was to use the absolute angle/distance
          and absolute speed of every inertia/mass which has the disadvantage that the absolute
          angle and or distance are state variables that grow in size continuously.<br>
          A significant advantage is also, that default initialization is usually better,
          because a default value of zero for a relative angle/distance is usually what the
          user would like to have. Previously, say, the load was initialized to a non-zero
          angle and then the elastically coupled motor inertia had to be explicitly
          also initialized with this value. This is now, no longer needed. Since the default
          nominal value of 1 is usually too large for a relative quantity, the nominal 
          values of the relative angle/distance was changed to 1e-4.</li>
     <li> The two libraries have been restructured in sublibraries to cope
          with the growing number of components.</li>
     <li> Finally, the Translational library has been
          made as similar as possible to the Rotational library by, e.g., adding missing
          components.<br>&nbsp;</li>
     </ul></li>

<li> The initialization of the MultiBody, Rotational and Translational libraries have
     been signficantly simplified by removing the \"initType\" parameters and only
     using start/fixed values. This design assumes that a tool has special support
     for start/fixed values in the parameter menu.<br>&nbsp;</li>

<li> Nearly all parameters defined in the Modelica Standard Library had been
     defined with a default equation, e.g.,
     <pre>   <b>parameter</b> Modelica.SIunits.Resistance R=1; </pre>
     Physical parameters, such as a resistance, mass, gear ratio, do not have a meaningful
     default and in nearly all cases, the user of the corresponding component has to
     provide values for such parameters. If the user forgets this, a tool
     cannot provide diagnostics, since a default value is present in the library
     (such as 1 Ohm for the resistance). In most cases the model will simulate but will
     give wrong results due to wrong parameter values. To improve this situation, all physical
     parameter declarations in the Modelica Standard Library have been changed, so
     that the previous default becomes a start value. For example, the above
     declaration is changed to:
     <pre>   <b>parameter</b> Modelica.SIunits.Resistance R(start=1);  </pre>
     This is a backward compatible change and completely equivalent from the perspective
     of the Modelica language. It is, however, adviced that tools will print a warning
     or optionally an error message, if the start value of a parameter is defined, but
     no value for the parameter is given via a modification. Furthermore, it is expected,
     that the input field of a parameter menu is empty, if no default equation is defined,
     but only a start value. This shows clearly to the modeler that a value has to 
     be provided.</li>
</ul>

<p><br>
The following <b style=\"color:blue\">new components</b> have been added 
to <b style=\"color:blue\">existing</b> libraries (note, the names in paranthesis
are the new sublibrary names that are introduced in version 3.0):
</p>

<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
  <tr><td colspan=\"2\"><b>Blocks.Examples.</b></td></tr>
  <tr><td valign=\"top\">InverseModel</td>
      <td valign=\"top\"> Demonstrates the construction of an inverse model.</td> </tr>

  <tr><td colspan=\"2\"><b>Blocks.Math.</b></td></tr>
  <tr><td valign=\"top\">InverseBlockConstraints</td>
      <td valign=\"top\"> Construct inverse model by requiring that two inputs 
                        and two outputs are identical (replaces the previously, 
                        unbalanced, TwoInputs and TwoOutputs blocks).</td> </tr>

  <tr><td colspan=\"2\"><b>Electrical.Machines.Utilities</b></td></tr>
  <tr><td valign=\"top\">TransformerData</td>
      <td valign=\"top\"> A record that calculates required impedances (parameters) from nominal data of transformers.</td> </tr>

  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Examples.Rotational3DEffects</b></td></tr>
  <tr><td valign=\"top\"> GyroscopicEffects<br>
                        ActuatedDrive<br> 
                        MovingActuatedDrive<br>
                        GearConstraint </td>
      <td valign=\"top\"> New examples to demonstrate the usage of the Rotational library
                        in combination with multi-body components. </td> 
  </tr>

  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Sensors</b></td></tr>
  <tr><td valign=\"top\"> AbsolutePosition<br>
                        AbsoluteVelocity<br>
                        AbsoluteAngles<br>
                        AbsoluteAngularVelocity<br>
                        RelativePosition<br>
                        RelativeVelocity<br>
                        RelativeAngles<br>
                        RelativeAngularVelocity</td>
      <td valign=\"top\"> New sensors to measure one vector. </td> 
  </tr>
  <tr><td valign=\"top\"> TransformAbsoluteVector<br>
                        TransformRelativeVector</td>
      <td valign=\"top\"> Transform absolute and/or relative vector into another frame. </td> 
  </tr>

  <tr><td colspan=\"2\"><b>Mechanics.Rotational.(Components)</b></td></tr>
  <tr><td valign=\"top\"> Disc </td>
      <td valign=\"top\"> Right flange is rotated by a fixed angle with respect to left flange</td> </tr>
  <tr><td valign=\"top\"> IdealRollingWheel </td>
      <td valign=\"top\"> Simple 1-dim. model of an ideal rolling wheel without inertia</td> </tr>


  <tr><td colspan=\"2\"><b>Mechanics.Translational.Sensors</b></td></tr>
  <tr><td valign=\"top\">RelPositionSensor<br>RelSpeedSensor<br>RelAccSensor<br>PowerSensor</td>
      <td valign=\"top\"> Relative position sensor, i.e. distance between two flanges<br>
                        Relative speed sensor<br>
                        Relative acceleration sensor<br>
                        Ideal power sensor</td> </tr>
  <tr><td colspan=\"2\"><b>Mechanics.Translational(.Components)</b></td></tr>
  <tr><td valign=\"top\">SupportFriction<br>Brake<br>InitializeFlange</td>
      <td valign=\"top\"> Model of friction due to support<br>
                        Model of a brake, base on Coulomb friction<br>
                        Initializes a flange with pre-defined postion, speed and acceleration .</td> </tr>
  <tr><td colspan=\"2\"><b>Mechanics.Translational(.Sources)</b></td></tr>
  <tr><td valign=\"top\">Force2<br>LinearSpeedDependentForce<br>QuadraticSpeedDependentForce<br>
                       ConstantForce<br>ConstantSpeed<br>ForceStep</td>
      <td valign=\"top\"> Force acting on 2 flanges<br> 
                        Force linearly dependent on flange speed<br>
                        Force quadratic dependent on flange speed<br>
                        Constant force source<br>
                        Constant speed source<br>
                        Force step</td> </tr>
</tr>
</table>


<p><br>
The following <b style=\"color:blue\">existing components</b>
have been <b style=\"color:blue\">changed</b> in a
<b style=\"color:blue\">non-backward compatible</b> way
(the conversion script transforms models and libraries
of previous versions to the new version. Therefore, conversion 
should be automatic):
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
  <tr><td colspan=\"2\"><b>Blocks.Continuous.</b></td></tr>
  <tr><td valign=\"top\"> CriticalDamping </td>
      <td valign=\"top\"> New parameter \"normalized\" to define whether filter is provided
                        in normalized or non-normalized form. Default is \"normalized = true\".
                        The previous implementation was a non-normalized filter.
                        The conversion script automatically introduces the modifier
                        \"normalized=false\" for existing models.</td> </tr>

  <tr><td colspan=\"2\"><b>Blocks.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> RealInput<br>
                        RealOutput</td>
      <td valign=\"top\"> Removed \"SignalType\", since extending from a replaceable class 
                        and this is not allowed in Modelica 3.<br>The conversion script
                        removes modifiers to SignalType.</td> </tr>

  <tr><td valign=\"top\"> RealSignal<br>
                        IntegerSignal<br>
                        BooleanSignal</td>
      <td valign=\"top\"> Moved to library ObsoleteModelica3, since these connectors
                        are no longer allowed in Modelica 3<br>
                        (prefixes input and/or output are required). </td> </tr>

  <tr><td colspan=\"2\"><b>Blocks.Interfaces.Adaptors.</b></td></tr>
  <tr><td valign=\"top\"> AdaptorReal<br>
                        AdaptorBoolean<br>
                        AdaptorInteger</td>
      <td valign=\"top\"> Moved to library ObsoleteModelica3, since the models are not \"balanced\".
                        These are completely obsolete adaptors<br>between the Real, Boolean, Integer
                        signal connectors of version 1.6 and version &ge; 2.1 of the Modelica 
                        Standard Library. </td> </tr>
                    

  <tr><td colspan=\"2\"><b>Blocks.Math.</b></td></tr>
  <tr><td valign=\"top\"> ConvertAllUnits</td>
      <td valign=\"top\"> Moved to library ObsoleteModelica3, since extending from a replaceable class
                        and this is not allowed in Modelica 3.<br> It would be possible to rewrite this
                        model to use a replaceable component. However, the information about the
                        conversion<br> cannot be visualized in the icon in this case.</td> </tr>

  <tr><td colspan=\"2\"><b>Blocks.Math.UnitConversions.</b></td></tr>
  <tr><td valign=\"top\"> TwoInputs<br>
                        TwoOutputs</td>
      <td valign=\"top\"> Moved to library ObsoleteModelica3, since the models are not \"balanced\".
                        A new component<br>\"InverseBlockConstraints\"
                        is provided instead that has the same feature, but is \"balanced\".</td> </tr>

  <tr><td colspan=\"2\"><b>Electrical.Analog.Baisc.</b></td></tr>
  <tr><td valign=\"top\"> HeatingResistor</td>
      <td valign=\"top\"> The heatPort has to be connected; otherwise the component Resistor (without heatPort) has to be used.<br>
                        cardinality() is only used to check whether the heatPort is connected.</td> </tr>

  <tr><td colspan=\"2\"><b>Electrical.MultiPhase.Examples.</b></td></tr>
  <tr><td valign=\"top\"> </td>
      <td valign=\"top\"> Changed the instance names of components used in the examples to more up-to-date style.</td> </tr>

  <tr><td colspan=\"2\"><b>Electrical.Machines.</b></td></tr>
  <tr><td valign=\"top\"> </td>
      <td valign=\"top\"> Moved package <tt>Machines.Examples.Utilities</tt> to <tt>Machines.Utilities</tt></td> </tr>
  <tr><td valign=\"top\"> </td>
      <td valign=\"top\"> Removed all nonSIunits; especially in DCMachines<br>
                        parameter NonSIunits.AngularVelocity_rpm rpmNominal was replaced by<br>
                        parameter SIunits.AngularVelocity wNominal</td> </tr>
  <tr><td valign=\"top\"> </td>
      <td valign=\"top\"> Changed the following component variable and parameter names to be more concise:<br>
                        Removed suffix \"DamperCage\" from all synchronous induction machines 
                        since the user can choose whether the damper cage is present or not.<br><tt>
                        RotorAngle ... RotorDisplacementAngle<br>
                        J_Rotor ... Jr<br>
                        Rr ........ Rrd (damper of synchronous induction machines)<br>
                        Lrsigma ... Lrsigmad (damper of synchronous induction machines)<br>
                        phi_mechanical ... phiMechanical<br>
                        w_mechanical ..... wMechanical<br>
                        rpm_mechanical ... rpmMechanical<br>
                        tau_electrical ... tauElectrical<br>
                        tau_shaft ........ tauShaft<br>
                        TurnsRatio ....... turnsRatio    (AIMS)<br>
                        VsNom ............ VsNominal     (AIMS)<br>
                        Vr_Lr ............ VrLockedRotor (AIMS)<br>
                        DamperCage ....... useDamperCage (synchronous induction machines)<br>
                        V0 ............... VsOpenCicuit  (SMPM)<br>
                        Ie0 .............. IeOpenCicuit  (SMEE)
                        </tt></td> </tr>
  <tr><td valign=\"top\">Interfaces.</td>
      <td valign=\"top\"> Moved as much code as possible from specific machine models to partials to reduce redundant code.</td> </tr>
  <tr><td valign=\"top\">Interfaces.Adapter</td>
      <td valign=\"top\"> Removed to avoid cardinality; instead, the following solution has been implemented:</td> </tr>
  <tr><td valign=\"top\">Sensors.RotorDisplacementAngle<br>Interfaces.PartialBasicMachine</td>
      <td valign=\"top\"> Introduced <tt>parameter Boolean useSupport=false \"enable / disable (=fixed stator) support\"</tt><br>
                        The rotational support connector is only present with <tt>useSupport = true;</tt><br>
                        otherwise the stator is fixed internally.</td> </tr>

  <tr><td colspan=\"2\"><b>Electrical.Machines.Examples.</b></td></tr>
  <tr><td valign=\"top\"> </td>
      <td valign=\"top\"> Changed the names of the examples to more meaninglful names.<br>
                        Changed the instance names of components used in the examples to more up-to-date style.</td> </tr>
  <tr><td valign=\"top\">SMEE_Generator</td>
      <td valign=\"top\"> Initialization of <tt>smee.phiMechanical</tt> with <tt>fixed=true</tt></td> </tr>

  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.</b></td></tr>
  <tr><td valign=\"top\"> World</td>
      <td valign=\"top\"> Changed default value of parameter driveTrainMechanics3D from false to true.<br>
                        3-dim. effects in Rotor1D, Mounting1D and BevelGear1D are therefore taken<br>
                        into account by default (previously this was only the case, if 
                        world.driveTrainMechanics3D was explicitly set).</td> </tr>

  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Forces.</b></td></tr>
  <tr><td valign=\"top\"> FrameForce<br>
                        FrameTorque<br>
                        FrameForceAndTorque</td>
      <td valign=\"top\"> Models removed, since functionality now available via Force, Torque, ForceAndTorque</td> </tr>
  <tr><td valign=\"top\"> WorldForce<br>
                        WorldTorque<br>
                        WorldForceAndTorque<br>
                        Force<br>
                        Torque<br>
                        ForceAndTorque</td>
      <td valign=\"top\"> Connector frame_resolve is optionally enabled via parameter resolveInFrame<br>.
                        Forces and torques and be resolved in all meaningful frames defined
                        by enumeration resolveInFrame.</td> </tr>

  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Frames.</b></td></tr>
  <tr><td valign=\"top\"> length<br>
                        normalize</td>
      <td valign=\"top\"> Removed functions, since available also in Modelica.Math.Vectors
                        <br>The conversion script changes the references correspondingly.</td> </tr>

  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Joints.</b></td></tr>
  <tr><td valign=\"top\"> Prismatic<br>
                        ActuatedPrismatic<br>
                        Revolute<br>
                        ActuatedRevolute<br>
                        Cylindrical<br>
                        Universal<br>
                        Planar<br>
                        Spherical<br>
                        FreeMotion</td>
      <td valign=\"top\"> Changed initialization, by replacing initial value parameters with
                        start/fixed attributes.<br>
                        When start/fixed attributes are properly supported
                        in the parameter menu by a Modelica tool,<br>
                        the initialization is considerably simplified for the
                        user and the implementation is much simpler.<br>
                        Replaced parameter \"enforceStates\" by the more general 
                        built-in enumeration stateSelect=StateSelection.xxx.<br>
                        The conversion script automatically
                        transforms from the \"old\" to the \"new\" forms.</td> </tr>
  <tr><td valign=\"top\"> Revolute<br>
                        ActuatedRevolute</td>
      <td valign=\"top\"> Parameter \"planarCutJoint\" in the \"Advanced\" menu of \"Revolute\" and of
                        \"ActuatedRevolute\" removed.<br>
                        A new joint \"RevolutePlanarLoopConstraint\" introduced that defines the constraints
                        of a revolute joint<br> as cut-joint in a planar loop.
                        This change was needed in order that the revolute joint can be
                        properly used<br>in advanced model checking.<br>
                        ActuatedRevolute joint removed. Flange connectors of Revolute joint<br>
                        can be enabled with parameter useAxisFlange.</td> </tr>
  <tr><td valign=\"top\"> Prismatic<br>
                        ActuatedPrismatic</td>
      <td valign=\"top\"> ActuatedPrismatic joint removed. Flange connectors of Prismatic joint<br>
                        can be enabled with parameter useAxisFlange.</td> </tr>
  <tr><td valign=\"top\"> Assemblies</td>
      <td valign=\"top\"> Assembly joint implementation slightly changed, so that
                        annotation \"structurallyIncomplete\" <br>could be removed
                        (all Assembly joint models are now \"balanced\").</td> </tr>


  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Joints.Internal</b></td></tr>
  <tr><td valign=\"top\"> RevoluteWithLengthConstraint<br>
                        PrismaticWithLengthConstraint</td>
      <td valign=\"top\"> These joints should not be used by a user of the MultiBody library. 
                        They are only provided to built-up the
                        MultiBody.Joints.Assemblies.JointXYZ joints.
                        These two joints have been changed in a slightly not backward compatible
                        way, in order that the usage in the Assemblies.JointXYZ joints results in 
                        balanced models (<b>no conversion is provided for this change since the
                        user should not have used these joints and the conversion would be too
                        complicated</b>): 
                        In releases before version 3.0 of the Modelica Standard Library, 
                        it was possible to activate the torque/force projection equation 
                        (= cut-torque/-force projected to the rotation/translation
                        axis must be identical to
                        the drive torque/force of flange axis) via parameter <b>axisTorqueBalance</b>.
                        This is no longer possible, since otherwise this model would not be
                        \"balanced\" (= same number of unknowns as equations). Instead, when
                        using this model in version 3.0 and later versions, the torque/force
                        projection equation must be provided in the Advanced menu of joints
                        Joints.SphericalSpherical and Joints.UniversalSpherical
                        via the new parameter \"constraintResidue\".</td> </tr>

  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Parts.</b></td></tr>
  <tr><td valign=\"top\"> BodyBox<br>
                        BodyCylinder</td>
      <td valign=\"top\"> Changed unit of parameter density from g/cm3 to the SI unit kg/m3
                        in order to allow stricter unit checking.<br>The conversion script multiplies
                        previous density values with 1000.</td> </tr>
  <tr><td valign=\"top\"> Body<br>
                        BodyShape<br>
                        BodyBox<br>
                        BodyCylinder<br>
                        PointMass
                        Rotor1D</td>
      <td valign=\"top\"> Changed initialization, by replacing initial value parameters with
                        start/fixed attributes.<br>
                        When start/fixed attributes are properly supported
                        in the parameter menu by a Modelica tool,<br>
                        the initialization is considerably simplified for the
                        user and the implementation is much simpler.<br>The conversion script automatically
                        transforms from the \"old\" to the \"new\" form of initialization.</td> </tr>

  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Sensors.</b></td></tr>
  <tr><td valign=\"top\"> AbsoluteSensor<br>
                        RelativeSensor<br>
                        CutForceAndTorque</td>
      <td valign=\"top\"> New design of sensor components: Via Boolean parameters<br>
                        signal connectors for the respective vectors are enabled/disabled.<br>
                        It is not possible to automatically convert models to this new design.<br>
                        Instead, references in existing models are changed to ObsoleteModelice3.<br>
                        This means that these models must be manually adapted.</td> </tr>
  <tr><td valign=\"top\"> CutForce<br>
                        CutTorque</td>
      <td valign=\"top\"> Slightly new design. The force and/or torque component can be
                        resolved in world, frame_a, or frame_resolved.<br>
                        Existing models are automatically converted.</td> </tr>

  <tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
  <tr><td valign=\"top\"> </td>
      <td valign=\"top\"> Moved components to structured sub-packages (Sources, Components)</td> </tr>
  <tr><td valign=\"top\"> Inertia<br>
                        SpringDamper<br>
                        RelativeStates</td>
      <td valign=\"top\"> Changed initialization, by replacing initial value parameters with
                        start/fixed attributes.<br>
                        When start/fixed attributes are properly supported
                        in the parameter menu by a Modelica tool,<br>
                        the initialization is considerably simplified for the
                        user and the implementation is much simpler.<br>
                        Parameter \"stateSelection\" in \"Inertia\" and \"SpringDamper\" replaced
                        by the built-in enumeration<br>stateSelect=StateSelection.xxx.
                        Introduced the \"stateSelect\" enumeration in \"RelativeStates\".<br>
                        The conversion script automatically
                        transforms from the \"old\" to the \"new\" forms.</td> </tr>
  <tr><td valign=\"top\"> LossyGear<br>
                        GearBox</td>
      <td valign=\"top\"> Renamed gear ratio parameter \"i\" to \"ratio\", in order to have a
                        consistent naming convention.<br>
                        Existing models are automatically converted. </td> </tr>
  <tr><td valign=\"top\"> SpringDamper<br>
                        ElastoBacklash<br>
                        Clutch<br>
                        OneWayClutch</td>
      <td valign=\"top\"> Relative quantities (phi_rel, w_rel) are used as states, if possible 
                        (due to StateSelect.prefer). <br>
                        In most cases, relative states in drive trains are better suited as
                        absolute states. <br> This change might give changes in the selected states
                        of existing models.<br>
                        This might give rise to problems if, e.g., the initialization was not
                        completely defined in a user model,<br> since the default
                        initialization heuristic may give different initial values.</td> </tr>

  <tr><td colspan=\"2\"><b>Mechanics.Translational.</b></td></tr>
  <tr><td valign=\"top\"> </td>
      <td valign=\"top\"> Moved components to structured sub-packages (Sources, Components)</td> </tr>
  <tr><td valign=\"top\"> </td>
      <td valign=\"top\"> Adaptions corresponding to Rotational</td> </tr>
  <tr><td valign=\"top\"> Stop</td>
      <td valign=\"top\"> Renamed to Components.MassWithStopAndFriction to be more concise.<br>
                        MassWithStopAndFriction is not available with a support connector, <br>
                        since the reaction force can't be modeled in a meaningful way due to reinit of velocity v.<br>
                        Until a sound implementation of a hard stop is available, the old model may be used.</td> </tr>
  <tr><td colspan=\"" + "2\"><b>Media.</b></td></tr>
  <tr><td valign=\"top\"> constant nX <br>
                        constant nXi <br>
                        constant reference_X<br>
                        BaseProperties</td>
      <td valign=\"top\"> The package constant nX = nS, now always, even for single species media. This also allows to define mixtures with only 1 element. The package constant nXi=if fixedX then 0 else if reducedX or nS==1 then nS - 1 else nS. This required that all BaseProperties for single species media get an additional equation to define the composition X as {1.0} (or reference_X, which is {1.0} for single species). This will also mean that all user defined single species media need to be updated by that equation.</td> </tr>

  <tr><td colspan=\"2\"><b>SIunits.</b></td></tr>
  <tr><td valign=\"top\"> CelsiusTemperature </td>
      <td valign=\"top\"> Removed, since no SI unit. The conversion script changes references to 
                        SIunits.Conversions.NonSIunits.Temperature_degC </td> </tr>
  <tr><td valign=\"top\"> ThermodynamicTemperature <br>
                        TemperatureDifference</td>
      <td valign=\"top\"> Added annotation \"__Dymola_absoluteValue=true/false\"
                        in order that unit checking is possible<br> 
                        (the unit checker needs to know for a unit that has an offset,
                        whether it is used as absolute or as a relative number)</td> </tr>

  <tr><td colspan=\"2\"><b>SIunits.Conversions.NonSIunits.</b></td></tr>
  <tr><td valign=\"top\"> Temperature_degC<br>
                        Temperature_degF<br>
                        Temperature_degRk </td>
      <td valign=\"top\"> Added annotation \"__Dymola_absoluteValue=true\"
                        in order that unit checking is possible<br> 
                        (the unit checker needs to know for a unit that has an offset,
                        whether it is used as absolute or as a relative number)</td> </tr>

  <tr><td colspan=\"2\"><b>StateGraph.Examples.</b></td></tr>
  <tr><td valign=\"top\"> ControlledTanks </td>
      <td valign=\"top\"> The connectors of the ControlledTanks did not fulfill the new
                        restrictions of Modelica 3. This has been fixed.</td> </tr>
  <tr><td valign=\"top\"> Utilities </td>
      <td valign=\"top\"> Replacing inflow, outflow by connectors inflow1, inflow2, 
                        outflow1, outflow2 with appropriate input/output prefixes in 
                        order to fufill the restrictions of Modelica 3 to arrive
                        at balanced models. No conversion is provided, since
                        too difficult and since the non-backward compatible change is in
                        an example. </td> </tr>

  <tr><td colspan=\"2\"><b>Thermal.FluidHeatFlow.Sensors.</b></td></tr>
  <tr><td valign=\"top\"> <br>
                        pSensor<br>TSensor<br>dpSensor<br>dTSensor<br>m_flowSensor<br>V_flowSensor<br>H_flowSensor</td>
      <td valign=\"top\"> renamed to:<br>
                        PressureSensor<br>TemperatureSensor<br>RelPressureSensor<br>RelTemperatureSensor<br>MassFlowSensor<br>VolumeFlowSensor<br>EnthalpyFlowSensor
                        </td> </tr>

  <tr><td colspan=\"2\"><b>Thermal.FluidHeatFlow.Sources.</b></td></tr>
  <tr><td valign=\"top\"> Ambient<br>PrescribedAmbient</td>
      <td valign=\"top\"> available as one combined component Ambient<br>
                        Boolean parameters usePressureInput and useTemperatureInput decide 
                        whether pressure and/or temperature are constant or prescribed</td> </tr>
  <tr><td valign=\"top\"> ConstantVolumeFlow<br>PrescribedVolumeFlow</td>
      <td valign=\"top\"> available as one combined component VolumeFlow<br>
                        Boolean parameter useVolumeFlowInput decides 
                        whether volume flow is constant or prescribed</td> </tr>
  <tr><td valign=\"top\"> ConstantPressureIncrease<br>PrescribedPressureIncrease</td>
      <td valign=\"top\"> available as one combined component PressureIncrease<br>
                        Boolean parameter usePressureIncreaseInput decides 
                        whether pressure increase is constant or prescribed</td> </tr>

  <tr><td colspan=\"2\"><b>Thermal.FluidHeatFlow.Examples.</b></td></tr>
  <tr><td valign=\"top\"> </td>
      <td valign=\"top\"> Changed the instance names of components used in the examples to more up-to-date style.</td> </tr>

  <tr><td colspan=\"2\"><b>Thermal.HeatTransfer.(Components)</b></td></tr>
  <tr><td valign=\"top\"> HeatCapacitor</td>
      <td valign=\"top\"> Initialization changed: SteadyStateStart removed. Instead
                        start/fixed values for T and der_T<br>(initial temperature and its derivative).</td> </tr>

  <tr><td valign=\"top\"> <br><br>HeatCapacitor<br>ThermalConductor<br>ThermalConvection<br>BodyRadiation<br><br>
                        TemperatureSensor<br>RelTemperatureSensor<br>HeatFlowSensor<br><br>
                        FixedTemperature<br>PrescribedTemperature<br>FixedHeatFlow<br>PrescribedHeatFlow</td>
      <td valign=\"top\"> Moved components to sub-packages:<br><br>
                        Components.HeatCapacitor<br>Components.ThermalConductor<br>Components.ThermalConvection<br>Components.BodyRadiation<br><br>
                        Sensors.TemperatureSensor<br>Sensors.RelTemperatureSensor<br>Sensors.HeatFlowSensor<br><br>
                        Sources.FixedTemperature<br>Sources.PrescribedTemperature<br>Sources.FixedHeatFlow<br>Sources.PrescribedHeatFlow
                        </tt></td> </tr>

  <tr><td colspan=\"2\"><b>Thermal.FluidHeatFlow.Examples.</b></td></tr>
  <tr><td valign=\"top\"> </td>
      <td valign=\"top\"> Changed the instance names of components used in the examples to more up-to-date style.</td> </tr>
</table>



<p><br>
The following <b style=\"color:blue\">existing components</b>
have been <b style=\"color:blue\">improved</b> in a
<b style=\"color:blue\">backward compatible</b> way:
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
  <tr><td valign=\"top\"> <b>Modelica.*</b> </td>
      <td valign=\"top\"> Parameter declarations, input and output function arguments without description
                        strings improved<br> by providing meaningful description texts.
                        </td> </tr>

  <tr><td colspan=\"2\"><b>Modelica.Blocks.Continuous.</b></td></tr>
  <tr><td valign=\"top\"> TransferFunction </td>
      <td valign=\"top\"> Internal scaling of the controller canonical states introduced
                        in order to enlarge the range of transfer functions where the default
                        relative tolerance of the simulator is sufficient.</td> 
  </tr>

  <tr><td valign=\"top\"> Butterworth<br>CriticalDamping </td>
      <td valign=\"top\"> Documentation improved and plots of the filter characteristics added.</td> </tr>

  <tr><td colspan=\"2\"><b>Electrical.Analog.Basic.</b></td></tr>
  <tr><td valign=\"top\"> EMF </td>
      <td valign=\"top\"> New parameter \"useSupport\" to optionally enable a support connector.</td> </tr>


  <tr><td colspan=\"2\"><b>Icons.</b></td></tr>
  <tr><td valign=\"top\"> TranslationalSensor<br>
                        RotationalSensor</td>
      <td valign=\"top\"> Removed drawing from the diagram layer (kept drawing only in 
                        icon layer),<br> in order that this icon can be used in situations
                        where components are dragged in the diagram layer.</td> </tr>

  <tr><td colspan=\"2\"><b>Math.Vectors.</b></td></tr>
  <tr><td valign=\"top\"> normalize</td>
      <td valign=\"top\"> Implementation changed, so that the result is awalys continuous<br>
                        (previously, this was not the case for small vectors: normalize(eps,eps)).
                        </td> </tr>

  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.</b></td></tr>
  <tr><td valign=\"top\"> </td>
      <td valign=\"top\"> Renamed non-standard keywords defineBranch, defineRoot, definePotentialRoot, 
                        isRooted to the standard names:<br>
                        Connections.branch/.root/.potentialRoot/.isRooted.</td> </tr>
  <tr><td valign=\"top\"> Frames </td>
      <td valign=\"top\"> Added annotation \"Inline=true\" to all one-line functions
                        (which should be all inlined).</td> </tr>
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Parts.</b></td></tr>
  <tr><td valign=\"top\"> Mounting1D<br>
                        Rotor1D<br>
                        BevelGear1D</td>
      <td valign=\"top\"> Changed implementation so that no longer modifiers for connector
                        variables are used,<br>because this violates the restrictions on
                        \"balanced models\" of Modelica 3. </td> </tr>

  <tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
  <tr><td valign=\"top\"> InitializeFlange</td>
      <td valign=\"top\"> Changed implementation so that counting unknowns and
                        equations is possible without actual values of parameters.</td> </tr>

  <tr><td colspan=\"2\"><b>Thermal.FluidHeatFlow.Interfaces.Partials.</b></td></tr>
  <tr><td valign=\"top\">TwoPort</td>
      <td valign=\"top\"> Introduced <tt>parameter Real tapT(final min=0, final max=1)=1</tt> <br> that defines the temperature of the heatPort
                        betwen inlet and outlet.</td> </tr>

  <tr><td colspan=\"2\"><b>StateGraph.</b></td></tr>
  <tr><td valign=\"top\"> InitialStep<br>
                        InitialStepWithSignal<br>
                        Step<br>
                        StepWithSignal</td>
      <td valign=\"top\"> Changed implementation so that no longer modifiers for output
                        variables are used,<br>because this violates the restrictions on
                        \"balanced models\" of Modelica 3. </td> </tr>

</table>


<p><br>
The following <b style=\"color:red\">critical errors</b> have been fixed (i.e. errors
that can lead to wrong simulation results):
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
  <tr><td colspan=\"2\"><b>Electrical.Analog.Examples.</b></td></tr>
  <tr><td valign=\"top\"> CauerLowPassSC </td>
      <td valign=\"top\"> Wrong calculation of Capacitor1 both in Rn and Rp corrected
                        (C=clock/R instead of C=clock*R) </td> 
  </tr>


  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Parts.</b></td></tr>
  <tr><td valign=\"top\"> Rotor1D </td>
      <td valign=\"top\"> The 3D reaction torque was not completely correct and gave in 
                        some situations a wrong result. This bug should not influence the
                        movement of a multi-body system, but only the constraint torques
                        are sometimes not correct. </td> 
  </tr>

  <tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
  <tr><td valign=\"top\"> ElastoBacklash </td>
      <td valign=\"top\"> If the damping torque was too large, the reaction torque 
                        could \"pull\" which is unphysical. The component was
                        newly written by limiting the damping torque in such a case
                        so that \"pulling\" torques can no longer occur. Furthermore,
                        during initialization the characteristics is made continuous
                        to reduce numerical errors. The relative angle and relative
                        angular velocities are used as states, if possible
                        (StateSelect.prefer), since relative quantities lead usually
                        to better behavior.  </td> 
  </tr>
  <tr><td valign=\"top\"> Position<br>Speed<br>Accelerate<br>Move</td>
      <td valign=\"top\"> The movement of the flange was wrongly defined as absolute;
                        this is corrected as relative to connector support.<br>
                        For Accelerate, it was necessary to rename
                        RealInput a to a_ref, as well as the start values
                        phi_start to phi.start and w_start to w.start.
                        The conversion script performs the necessary conversion of  
                        existing models automatically.</td> 
  </tr>
  <tr><td colspan=\"2\"><b>Media.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> PartialSimpleIdealGasMedium </td>
      <td valign=\"top\"> Inconsisteny in reference temperature corrected. This may give
                        different results for functions:<br>
                        specificEnthalpy, specificInternalEnergy, specificGibbsEnergy,
                        specificHelmholtzEnergy. </td> 
  </tr>
  <tr><td colspan=\"2\"><b>Media.Air.</b></td></tr>
  <tr><td valign=\"top\"> specificEntropy </td>
      <td valign=\"top\"> Small bug in entropy computation of ideal gas mixtures corrected.</td> 
  </tr>
  <tr><td colspan=\"2\"><b>Media.IdealGases.Common.MixtureGasNasa</b></td></tr>
  <tr><td valign=\"top\"> specificEntropy </td>
      <td valign=\"top\"> Small bug in entropy computation of ideal gas mixtures corrected.</td> 
  </tr>
</table>
 
 
<p><br>
The following <b style=\"color:red\">uncritical errors</b> have been fixed (i.e. errors
that do <b style=\"color:red\">not</b> lead to wrong simulation results, but, e.g., 
units are wrong or errors in documentation):
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
  <tr><td colspan=\"2\"><b>Blocks.Tables.</b></td></tr>
  <tr><td valign=\"top\"> CombiTable2D</td>
      <td valign=\"top\"> Documentation improved.</td> 
  </tr>

  <tr><td colspan=\"2\"><b>Electrica.Digital.Gates</b></td></tr>
  <tr><td valign=\"top\"> AndGate<br>
                        NandGate<br>
                        OrGate<br>
                        NorGate<br>
                        XorGate<br>
                        XnorGate</td>
      <td valign=\"top\"> The number of inputs was not correctly propagated
                        to the included base model.<br> 
                        This gave a translation error, if the number
                        of inputs was changed (and not the default used).</td> 
  </tr>

  <tr><td colspan=\"2\"><b>Electrica.Digital.Sources</b></td></tr>
  <tr><td valign=\"top\"> Pulse </td>
      <td valign=\"top\"> Model differently implemented, so that 
                        warning message about \"cannot properly initialize\" is gone.</td> 
  </tr>


  <tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
  <tr><td valign=\"top\"> BearingFriction<br>
                        Clutch<br>
                        OneWayClutch<br>
                        Brake <br>
                        Gear </td>
      <td valign=\"top\"> Declaration of table parameter changed from
                        table[:,:] to table[:,2].</td> 
  </tr>

  <tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Examples.Loops.Utilities.</b></td></tr>
  <tr><td valign=\"top\"> GasForce </td>
      <td valign=\"top\"> Unit of variable \"press\" corrected (from Pa to bar)</td> 
  </tr>

  <tr><td colspan=\"2\"><b>StateGraph.Examples.</b></td></tr>
  <tr><td valign=\"top\">SimpleFriction</td>
      <td valign=\"top\"> The internal parameter k is defined and calculated with the appropriate unit.</td> </tr>


  <tr><td colspan=\"2\"><b>Thermal.FluidHeatFlow.Interfaces.Partials.</b></td></tr>
  <tr><td valign=\"top\">SimpleFriction</td>
      <td valign=\"top\"> The internal parameter k is defined and calculated with the appropriate unit.</td> </tr>

</table>
                               
</html>"));
  end Version_3_0;

  class Version_2_2_2 "Version 2.2.2 (Aug. 31, 2007)"

      annotation (Documentation(info="<html>
<p>
Version 2.2.2 is backward compatible to version 2.2.1 and 2.2 with 
the following exceptions:
</p>
<ul>
<li> Removal of package Modelica.Media.Interfaces.PartialTwoPhaseMediumWithCache
     (this was not yet utilized).</li>
<li> Removal of the media packages in
     Modelica.Media.IdealGases.SingleGases that are not type compatible
     to Modelica.Media.Interfaces.PartialMedium, because a FluidConstants
     record definition is missing, 
     for details, see 
      <a href=\"Modelica://Modelica.Media.IdealGases\">Modelica.Media.IdealGases</a>
     (this is seen as a bug fix).
</ul>

<p>
An overview of the differences between version 2.2.2 and the previous
version 2.2.1 is given below. The exact differences (but without
differences in the documentation) are available
<a href=\"../help/Documentation/Differences-Modelica-221-222.html\">here</a>.
This comparison file was generated automatically with Dymolas
ModelManagement.compare function.
</p>
 
<p>
In this version, <b>no</b> new libraries have been added. The <b>documentation</b>
of the whole library was improved. Especially, the documentation is now also
available as
<a href=\"../help/Documentation/ModelicaStandardLibrary.pdf\">one pdf file</a>.
</p>
 
 
<p><br>
The following <b style=\"color:blue\">new components</b> have been added 
to <b style=\"color:blue\">existing</b> libraries:
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
  <tr><td colspan=\"2\"><b>Blocks.Logical.</b></td></tr>
  <tr><td valign=\"top\"> TerminateSimulation</td>
      <td valign=\"top\"> Terminate a simulation by a given condition.</td>
  </tr>
 
  <tr><td colspan=\"2\"><b>Blocks.Routing.</b></td></tr>
  <tr><td valign=\"top\"> RealPassThrough<br>
           IntegerPassThrough<br>
           BooleanPassThrough</td>
      <td valign=\"top\"> Pass a signal from input to output
           (useful in combination with a bus due to restrictions 
           of expandable connectors).</td>
  </tr>
 
  <tr><td colspan=\"2\"><b>Blocks.Sources.</b></td></tr>
  <tr><td valign=\"top\"> KinematicPTP2 </td>
      <td valign=\"top\"> Directly gives q,qd,qdd as output (and not just qdd as KinematicPTP).
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Machines.Examples.</b></td></tr>
  <tr><td valign=\"top\"> TransformerTestbench </td>
      <td valign=\"top\"> Transformer Testbench
      </td>
  <tr><td valign=\"top\"> Rectifier6pulse </td>
      <td valign=\"top\"> 6-pulse rectifier with 1 transformer
      </td>
  </tr>
  <tr><td valign=\"top\"> Rectifier12pulse </td>
      <td valign=\"top\"> 12-pulse rectifier with 2 transformers
      </td>
  </tr>
  <tr><td valign=\"top\"> AIMC_Steinmetz </td>
      <td valign=\"top\"> Asynchronous induction machine squirrel cage with Steinmetz connection 
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Machines.BasicMachines.Components.</b></td></tr>
  <tr><td valign=\"top\"> BasicAIM </td>
      <td valign=\"top\"> Partial model for asynchronous induction machine
      </td>
  <tr><td valign=\"top\"> BasicSM </td>
      <td valign=\"top\"> Partial model for synchronous induction machine
      </td>
  <tr><td valign=\"top\"> PartialAirGap </td>
      <td valign=\"top\"> Partial airgap model
      </td>
  <tr><td valign=\"top\"> BasicDCMachine </td>
      <td valign=\"top\"> Partial model for DC machine
      </td>
  <tr><td valign=\"top\"> PartialAirGapDC </td>
      <td valign=\"top\"> Partial airgap model of a DC machine
      </td>
  <tr><td valign=\"top\"> BasicTransformer </td>
      <td valign=\"top\"> Partial model of threephase transformer
      </td>
  <tr><td valign=\"top\"> PartialCore </td>
      <td valign=\"top\"> Partial model of transformer core with 3 windings
      </td>
  <tr><td valign=\"top\"> IdealCore </td>
      <td valign=\"top\"> Ideal transformer with 3 windings
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Machines.BasicMachines.</b></td></tr>
  <tr><td valign=\"top\"> Transformers </td>
      <td valign=\"top\"> Sub-Library for technical 3phase transformers
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Machines.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> Adapter </td>
      <td valign=\"top\"> Adapter to model housing of electrical machine
      </td>
  </tr>

 <tr><td colspan=\"2\"><b>Math.</b></td></tr>
  <tr><td valign=\"top\"> Vectors </td>
      <td valign=\"top\"> New library of functions operating on vectors
      </td>
  </tr>
  <tr><td valign=\"top\"> atan3 </td>
      <td valign=\"top\"> Four quadrant inverse tangens (select solution that is closest to given angle y0)
      </td>
  </tr>
  <tr><td valign=\"top\"> asinh </td>
      <td valign=\"top\"> Inverse of sinh (area hyperbolic sine)
      </td>
  </tr>
  <tr><td valign=\"top\"> acosh </td>
      <td valign=\"top\"> Inverse of cosh (area hyperbolic cosine)
      </td>
  </tr>

 <tr><td colspan=\"2\"><b>Math.Vectors</b></td></tr>
  <tr><td valign=\"top\"> isEqual </td>
      <td valign=\"top\"> Determine if two Real vectors are numerically identical
      </td>
  </tr>
  <tr><td valign=\"top\"> norm </td>
      <td valign=\"top\"> Return the p-norm of a vector
      </td></tr>
  <tr><td valign=\"top\"> length </td>
      <td valign=\"top\"> Return length of a vector (better as norm(), if further symbolic processing is performed)
      </td></tr>
  <tr><td valign=\"top\"> normalize </td>
      <td valign=\"top\"> Return normalized vector such that length = 1 and prevent zero-division for zero vector
      </td></tr>
  <tr><td valign=\"top\"> reverse </td>
      <td valign=\"top\"> Reverse vector elements (e.g. v[1] becomes last element)
      </td></tr>
  <tr><td valign=\"top\"> sort </td>
      <td valign=\"top\"> Sort elements of vector in ascending or descending order
      </td></tr>

 <tr><td colspan=\"2\"><b>Math.Matrices</b></td></tr>
  <tr><td valign=\"top\"> solve2 </td>
      <td valign=\"top\"> Solve real system of linear equations A*X=B with a B matrix
           (Gaussian elemination with partial pivoting)
      </td>
  </tr>
  <tr><td valign=\"top\"> LU_solve2 </td>
      <td valign=\"top\"> Solve real system of linear equations P*L*U*X=B with a B matrix 
           and an LU decomposition (from LU(..))
      </td></tr>

 
  <tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
  <tr><td valign=\"top\"> InitializeFlange </td>
      <td valign=\"top\"> Initialize a flange according to given signals
           (useful if initialization signals are provided by a signal bus).
      </td>
  </tr>

 
  <tr><td colspan=\"2\"><b>Media.Interfaces.PartialMedium.</b></td></tr>
  <tr><td valign=\"top\"> density_pTX </td>
      <td valign=\"top\"> Return density from p, T, and X or Xi
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Interfaces.PartialTwoPhaseMedium.</b></td></tr>
  <tr><td valign=\"top\"> BaseProperties </td>
      <td valign=\"top\"> Base properties (p, d, T, h, u, R, MM, x) of a two phase medium
      </td>
  </tr>
  <tr><td valign=\"top\"> molarMass </td>
      <td valign=\"top\"> Return the molar mass of the medium
      </td>
  </tr>
  <tr><td valign=\"top\"> saturationPressure_sat </td>
      <td valign=\"top\"> Return saturation pressure
      </td>
  </tr>
  <tr><td valign=\"top\"> saturationTemperature_sat </td>
      <td valign=\"top\"> Return saturation temperature
      </td>
  </tr>  
  <tr><td valign=\"top\"> saturationTemperature_derp_sat </td>
      <td valign=\"top\"> Return derivative of saturation temperature w.r.t. pressure
      </td>
  </tr>  <tr><td valign=\"top\"> setState_px </td>
      <td valign=\"top\"> Return thermodynamic state from pressure and vapour quality
      </td>
  </tr>  <tr><td valign=\"top\"> setState_Tx </td>
      <td valign=\"top\"> Return thermodynamic state from temperature and vapour quality
      </td>
  </tr>  <tr><td valign=\"top\"> vapourQuality </td>
      <td valign=\"top\"> Return vapour quality
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> PartialLinearFluid </td>
      <td valign=\"top\"> Generic pure liquid model with constant cp, 
           compressibility and thermal expansion coefficients
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Air.MoistAir.</b></td></tr>
  <tr><td valign=\"top\"> massFraction_pTphi </td>
      <td valign=\"top\"> Return the steam mass fraction from relative humidity and T
      </td>
  </tr>
  <tr><td valign=\"top\"> saturationTemperature </td>
      <td valign=\"top\"> Return saturation temperature from (partial) pressure 
           via numerical inversion of function saturationPressure
      </td>
  </tr>
  <tr><td valign=\"top\"> enthalpyOfWater </td>
      <td valign=\"top\"> Return specific enthalpy of water (solid/liquid) near 
           atmospheric pressure from temperature
      </td>
  </tr>
  <tr><td valign=\"top\"> enthalpyOfWater_der </td>
      <td valign=\"top\"> Return derivative of enthalpyOfWater()\" function
      </td>
  </tr>
  <tr><td valign=\"top\"> PsychrometricData </td>
      <td valign=\"top\"> Model to generate plot data for psychrometric chart
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.CompressibleLiquids.</b><br>
      New sub-library for simple compressible liquid models</td></tr>
  <tr><td valign=\"top\"> LinearColdWater </td>
      <td valign=\"top\"> Cold water model with linear compressibility
      </td>
  <tr><td valign=\"top\"> LinerWater_pT_Ambient </td>
      <td valign=\"top\"> Liquid, linear compressibility water model at 1.01325 bar 
           and 25 degree Celsius
      </td>
 
  <tr><td colspan=\"2\"><b>SIunits.</b></td></tr>
  <tr><td valign=\"top\"> TemperatureDifference </td>
      <td valign=\"top\"> Type for temperature difference
      </td>
</table> 
 
 
<p><br>
The following <b style=\"color:blue\">existing components</b>
have been <b style=\"color:blue\">improved</b>:
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
  <tr><td colspan=\"2\"><b>Blocks.Examples.</b></td></tr>
  <tr><td valign=\"top\"> BusUsage</td>
      <td valign=\"top\"> Example changed from the \"old\" to the \"new\" bus concept with
           expandable connectors.</td> </tr>
 
  <tr><td colspan=\"2\"><b>Blocks.Discrete.</b></td></tr>
  <tr><td valign=\"top\"> ZeroOrderHold</td>
      <td valign=\"top\"> Sample output ySample moved from \"protected\" to \"public\"
           section with new attributes (start=0, fixed=true).
      </td> 
  </tr>
  <tr><td valign=\"top\"> TransferFunction</td>
      <td valign=\"top\"> Discrete state x with new attributes (each start=0, each fixed=0).
      </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.</b></td></tr>
  <tr><td valign=\"top\"> Analog<br>MultiPhase</td>
      <td valign=\"top\"> Improved some icons.
      </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Digital.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> MISO</td>
      <td valign=\"top\"> Removed \"algorithm\" from this partial block.
      </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Digital.Delay.</b></td></tr>
  <tr><td valign=\"top\"> DelayParams</td>
      <td valign=\"top\"> Removed \"algorithm\" from this partial block.
      </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Digital.Delay.</b></td></tr>
  <tr><td valign=\"top\"> DelayParams</td>
      <td valign=\"top\"> Removed \"algorithm\" from this partial block.
      </td> 
  </tr>
  <tr><td valign=\"top\"> TransportDelay</td>
      <td valign=\"top\">  If delay time is zero, an infinitely small delay is 
            introduced via pre(x) (previously \"x\" was used). 
      </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Digital.Sources.</b></td></tr>
  <tr><td valign=\"top\"> Clock<br>Step</td>
      <td valign=\"top\"> Changed if-conditions from \"xxx < time\" to \"time >= xxx\"
           (according to the Modelica specification, in the second case 
           a time event should be triggered, i.e., this change leads 
           potentially to a faster simulation).
      </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Digital.Converters.</b></td></tr>
  <tr><td valign=\"top\"> BooleanToLogic<br>
           LogicToBoolean<br>
           RealToLogic<br>
           LogicToReal</td>
      <td valign=\"top\"> Changed from \"algorithm\" to \"equation\" section
           to allow better symbolic preprocessing
      </td> 
  </tr>
  
  <tr><td colspan=\"2\"><b>Electrical.</b></td></tr>
  <tr><td valign=\"top\"> Machines</td>
      <td valign=\"top\"> Slightly improved documentation, typos in 
           documentation corrected
      </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Machines.Examples.</b></td></tr>
  <tr><td valign=\"top\"> AIMS_start</td>
      <td valign=\"top\"> Changed QuadraticLoadTorque1(TorqueDirection=true) to
           QuadraticLoadTorque1(TorqueDirection=false) since more realistic
      </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Machines.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> PartialBasicMachine</td>
      <td valign=\"top\"> Introduced support flange to model the 
           reaction torque to the housing
      </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Machines.Sensors.</b></td></tr>
  <tr><td valign=\"top\"> Rotorangle</td>
      <td valign=\"top\"> Introduced support flange to model the 
           reaction torque to the housing
      </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Examples.Elementary.</b></td></tr>
  <tr><td valign=\"top\"> PointMassesWithGravity</td>
      <td valign=\"top\"> Added two point masses connected by a line force to demonstrate
           additionally how this works. Connections of point masses
           with 3D-elements are demonstrated in the new example
           PointMassesWithGravity (there is the difficulty that the orientation
           is not defined in a PointMass object and therefore some
           special handling is needed in case of a connection with
           3D-elements, where the orientation of the point mass is not
           determined by these elements.</td>
  </tr>
  
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Examples.Systems.</b></td></tr>
  <tr><td valign=\"top\"> RobotR3</td>
      <td valign=\"top\"> Changed from the \"old\" to the \"new\" bus concept with expandable connectors.
           Replaced the non-standard Modelica function \"constrain()\" by
           standard Modelica components. As a result, the non-standard function
           constrain() is no longer used in the Modelica Standard Library.</td>
  </tr>
  
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Frames.Orientation.</b></td></tr>
  <tr><td valign=\"top\"> equalityConstraint</td>
      <td valign=\"top\"> Use a better residual for the equalityConstraint function.
           As a result, the non-linear equation system of a kinematic
           loop is formulated in a better way (the range where the
           desired result is a unique solution of the non-linear
           system of equations becomes much larger).</td>
  </tr>
    

  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.</b></td></tr>
  <tr><td valign=\"top\"> Visualizers.</td>
      <td valign=\"top\"> Removed (misleading) annotation \"structurallyIncomplete\" 
           in the models of this sub-library
      </td>
  </tr>
  
  <tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
  <tr><td valign=\"top\"> Examples</td>
      <td valign=\"top\"> For all models in this sub-library:
           <ul>
           <li> Included a housing object in all examples to compute
                all support torques.</li>
           <li> Replaced initialization by modifiers via the
                initialization menu parameters of Inertia components.</li>
           <li> Removed \"encapsulated\" and unnecessary \"import\". </li>
           <li> Included \"StopTime\" in the annotations.</li>
           </ul>
      </td>
  </tr>
   
  <tr><td colspan=\"2\"><b>Mechanics.Rotational.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> FrictionBase</td>
      <td valign=\"top\"> Introduced \"fixed=true\" for Boolean variables startForward, 
           startBackward, mode.
      </td>
  </tr>
  
  <tr><td colspan=\"2\"><b>Mechanics.Translational.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> FrictionBase</td>
      <td valign=\"top\"> Introduced \"fixed=true\" for Boolean variables startForward, 
           startBackward, mode.
      </td>
  </tr>
  
  <tr><td colspan=\"2\"><b>Media.UsersGuide.MediumUsage.</b></td></tr>
  <tr><td valign=\"top\"> TwoPhase</td>
      <td valign=\"top\"> Improved documentation and demonstrating the newly introduced functions
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Examples.</b></td></tr>
  <tr><td valign=\"top\"> WaterIF97</td>
      <td valign=\"top\"> Provided (missing) units for variables V, dV, H_flow_ext, m, U.
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b> Media.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> PartialMedium</td>
      <td valign=\"top\"> Final modifiers are removed from nX and nXi, to allow
           customized medium models such as mixtures of refrigerants with oil, etc.
      </td>
  </tr>
  <tr><td valign=\"top\"> PartialCondensingGases</td>
      <td valign=\"top\"> Included attributes \"min=1, max=2\" for input argument FixedPhase
           for functions setDewState and setBubbleState (in order to guarantee
           that input arguments are correct).
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b> Media.Interfaces.PartialMedium.</b></td></tr>
  <tr><td valign=\"top\"> BaseProperties</td>
      <td valign=\"top\"> New Boolean parameter \"standardOrderComponents\".
           If true, last element vector X is computed from 1-sum(Xi) (= default)
           otherwise, no equation is provided for it in PartialMedium.
      </td>
  </tr>
  <tr><td valign=\"top\"> IsentropicExponent</td>
      <td valign=\"top\"> \"max\" value changed from 1.7 to 500000
      </td>
  </tr>
  <tr><td valign=\"top\"> setState_pTX<br>
           setState_phX<br>        
           setState_psX<br>        
           setState_dTX<br>        
           specificEnthalpy_pTX<br>
           temperature_phX<br>     
           density_phX<br>         
           temperature_psX<br>     
           density_psX<br>         
           specificEnthalpy_psX</td>
      <td valign=\"top\"> Introduced defaut value \"reference_X\" for input argument \"X\".
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b> Media.Interfaces.PartialSimpleMedium.</b></td></tr>
  <tr><td valign=\"top\"> setState_pTX<br>
           setState_phX<br>
           setState_psX<br>
           setState_dTX</td>
      <td valign=\"top\"> Introduced defaut value \"reference_X\" for input argument \"X\".
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b> Media.Interfaces.PartialSimpleIdealGasMedium.</b></td></tr>
  <tr><td valign=\"top\"> setState_pTX<br>
           setState_phX<br>
           setState_psX<br>
           setState_dTX</td>
      <td valign=\"top\"> Introduced defaut value \"reference_X\" for input argument \"X\".
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b> Media.Air.MoistAir.</b></td></tr>
  <tr><td valign=\"top\"> setState_pTX<br>
           setState_phX<br>
           setState_dTX</td>
      <td valign=\"top\"> Introduced defaut value \"reference_X\" for input argument \"X\".
      </td>
  </tr>
  
  <tr><td colspan=\"2\"><b> Media.IdealGases.Common.SingleGasNasa.</b></td></tr>
  <tr><td valign=\"top\"> setState_pTX<br>
           setState_phX<br>
           setState_psX<br>
           setState_dTX</td>
      <td valign=\"top\"> Introduced defaut value \"reference_X\" for input argument \"X\".
      </td>
  </tr>
  
  <tr><td colspan=\"2\"><b> Media.IdealGases.Common.MixtureGasNasa.</b></td></tr>
  <tr><td valign=\"top\"> setState_pTX<br>
           setState_phX<br>
           setState_psX<br>
           setState_dTX<br>
           h_TX</td>
      <td valign=\"top\"> Introduced defaut value \"reference_X\" for input argument \"X\".
      </td>
  </tr>
 
  <tr><td colspan=\"2\"><b> Media.Common.</b></td></tr>
  <tr><td valign=\"top\"> IF97PhaseBoundaryProperties<br>
           gibbsToBridgmansTables </td>
      <td valign=\"top\"> Introduced unit for variables vt, vp.
      </td>
  </tr>
  <tr><td valign=\"top\"> SaturationProperties</td>
      <td valign=\"top\"> Introduced unit for variable dpT.
      </td>
  </tr>     
  <tr><td valign=\"top\"> BridgmansTables</td>
      <td valign=\"top\"> Introduced unit for dfs, dgs.
      </td>
  </tr>   
 
  <tr><td colspan=\"2\"><b> Media.Common.ThermoFluidSpecial.</b></td></tr>
  <tr><td valign=\"top\"> gibbsToProps_ph<br>
           gibbsToProps_ph  <br>   
           gibbsToBoundaryProps<br>
           gibbsToProps_dT<br>     
           gibbsToProps_pT</td>
      <td valign=\"top\"> Introduced unit for variables vt, vp.
      </td>
  <tr><td valign=\"top\"> TwoPhaseToProps_ph</td>
      <td valign=\"top\"> Introduced unit for variables dht, dhd, detph.
      </td>
  </tr>     
 
  <tr><td colspan=\"2\"><b> Media.</b></td></tr>
  <tr><td valign=\"top\"> MoistAir</td>
      <td valign=\"top\"> Documentation of moist air model significantly improved.
      </td>
  </tr>     
 
  <tr><td colspan=\"2\"><b> Media.MoistAir.</b></td></tr>
  <tr><td valign=\"top\"> enthalpyOfVaporization</td>
      <td valign=\"top\"> Replaced by linear correlation since simpler and more 
           accurate in the entire region.
      </td>
  </tr>     
 
  <tr><td colspan=\"2\"><b> Media.Water.IF97_Utilities.BaseIF97.Regions.</b></td></tr>
  <tr><td valign=\"top\"> drhovl_dp</td>
      <td valign=\"top\"> Introduced unit for variable dd_dp.
      </td>
  </tr>   
 
  <tr><td colspan=\"2\"><b> Thermal.</b></td></tr>
  <tr><td valign=\"top\"> FluidHeatFlow</td>
      <td valign=\"top\"> Introduced new parameter tapT (0..1) to define the
           temperature of the HeatPort as linear combination of the
           flowPort_a (tapT=0) and flowPort_b (tapT=1) temperatures.
      </td>
  </tr> 
</table> 
 
 
 
<p><br>
The following <b style=\"color:red\">critical errors</b> have been fixed (i.e. errors
that can lead to wrong simulation results):
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
  <tr><td colspan=\"2\"><b>Electrical.Machines.BasicMachines.Components.</b></td></tr>
  <tr><td valign=\"top\"> ElectricalExcitation</td>
      <td valign=\"top\"> Excitation voltage ve is calculated as
           \"spacePhasor_r.v_[1]*TurnsRatio*3/2\" instead of
           \"spacePhasor_r.v_[1]*TurnsRatio
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Parts.</b></td></tr>
  <tr><td valign=\"top\"> FixedRotation</td>
      <td valign=\"top\"> Bug corrected that the torque balance was wrong in the 
           following cases (since vector r was not transformed
           from frame_a to frame_b; note this special case occurs very seldomly in practice):
           <ul><li> frame_b is in the spanning tree closer to the root
                    (usually this is frame_a).</li>
               <li> vector r from frame_a to frame_b is not zero.</li>
           </ul>
       </td> 
  </tr>
 
 <tr><td valign=\"top\"> PointMass</td>
     <td valign=\"top\"> If a PointMass model is connected so that no equations are present
          to compute its orientation object, the orientation was arbitrarily
          set to a unit rotation. In some cases this can lead to a wrong overall
          model, depending on how the PointMass model is used. For this reason,
          such cases lead now to an error (via an assert(..)) with an explanation
          how to fix this.
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Interfaces.PartialPureSubstance.</b></td></tr>
  <tr><td valign=\"top\"> pressure_dT<br>
           specificEnthalpy_dT
      </td>
      <td valign=\"top\"> Changed wrong call from \"setState_pTX\" to \"setState_dTX\"
       </td> 
  </tr>
 
 
  <tr><td colspan=\"2\"><b>Media.Interfaces.PartialTwoPhaseMedium.</b></td></tr>
  <tr><td valign=\"top\"> pressure_dT<br>        
           specificEnthalpy_dT
      </td>
      <td valign=\"top\"> Changed wrong call from \"setState_pTX\" to \"setState_dTX\"
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Common.ThermoFluidSpecial.</b></td></tr>
  <tr><td valign=\"top\"> gibbsToProps_dT<br>    
           helmholtzToProps_ph<br>
           helmholtzToProps_pT<br>
           helmholtzToProps_dT</td>
      <td valign=\"top\"> Bugs in equations corrected </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Common.</b></td></tr>
  <tr><td valign=\"top\"> helmholtzToBridgmansTables<br>            
           helmholtzToExtraDerivs</td>
      <td valign=\"top\"> Bugs in equations corrected </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.IdealGases.Common.SingleGasNasa.</b></td></tr>
  <tr><td valign=\"top\"> density_derp_T</td>
      <td valign=\"top\"> Bug in equation of partial derivative corrected </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Water.IF97_Utilities.</b></td></tr>
  <tr><td valign=\"top\"> BaseIF97.Inverses.dtofps3<br>  
           isentropicExponent_props_ph<br> 
           isentropicExponent_props_pT<br>
           isentropicExponent_props_dT</td>         
      <td valign=\"top\"> Bugs in equations corrected </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Air.MoistAir.</b></td></tr>
  <tr><td valign=\"top\"> h_pTX</td>         
      <td valign=\"top\"> Bug in setState_phX due to wrong vector size in h_pTX corrected.
           Furthermore, syntactical errors corrected:  
           <ul><li> In function massFractionpTphi an equation 
                    sign is used in an algorithm.</li>
               <li> Two consecutive semicolons removed</li>
           </ul>
      </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Water.</b></td></tr>
  <tr><td valign=\"top\"> waterConstants</td>         
      <td valign=\"top\"> Bug in equation of criticalMolarVolume corrected.
      </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Water.IF97_Utilities.BaseIF97.Regions.</b></td></tr>
  <tr><td valign=\"top\"> region_ph<br>
           region_ps</td>         
      <td valign=\"top\"> Bug in region determination corrected.
      </td> 
  </tr>
 
  <tr><td valign=\"top\"> boilingcurve_p<br>
           dewcurve_p</td>         
      <td valign=\"top\"> Bug in equation of plim corrected.
      </td> 
  </tr>
</table>
 
 
<p><br>
The following <b style=\"color:red\">uncritical errors</b> have been fixed (i.e. errors
that do <b style=\"color:red\">not</b> lead to wrong simulation results, but, e.g., 
units are wrong or errors in documentation):
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2 style=\"border-collapse:collapse;\">
  <tr><td colspan=\"2\"><b>Blocks.</b></td></tr>
  <tr><td valign=\"top\"> Examples</td>
      <td valign=\"top\"> Corrected typos in description texts of bus example models.
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Blocks.Continuous.</b></td></tr>
  <tr><td valign=\"top\"> LimIntegrator</td>
      <td valign=\"top\"> removed incorrect smooth(0,..) because expression might be discontinuous.
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Blocks.Math.UnitConversions.</b></td></tr>
  <tr><td valign=\"top\"> block_To_kWh<br>block_From_kWh</td>
      <td valign=\"top\"> Corrected unit from \"kWh\" to (syntactically correct) \"kW.h\".
       </td> 
  </tr>

  <tr><td colspan=\"2\"><b>Electrical.Analog.Examples.</b></td></tr>
  <tr><td valign=\"top\"> HeatingNPN_OrGate</td>
      <td valign=\"top\"> Included start values, so that initialization is
                        successful </td> 
  </tr>

  <tr><td colspan=\"2\"><b>Electrical.Analog.Lines.</b></td></tr>
  <tr><td valign=\"top\"> OLine</td>
      <td valign=\"top\"> Corrected unit from \"Siemens/m\" to \"S/m\".
       </td> 
  <tr><td valign=\"top\"> TLine2</td>
      <td valign=\"top\"> Changed wrong type of parameter NL (normalized length) from
           SIunits.Length to Real.
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Digital.Delay.</b></td></tr>
  <tr><td valign=\"top\"> TransportDelay</td>
      <td valign=\"top\"> Syntax error corrected
           (\":=\" in equation section is converted by Dymola silently to \"=\").
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.Digital</b></td></tr>
  <tr><td valign=\"top\"> Converters</td>
      <td valign=\"top\"> Syntax error corrected
           (\":=\" in equation section is converted by Dymola silently to \"=\").
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.MultiPhase.Basic.</b></td></tr>
  <tr><td valign=\"top\"> Conductor</td>
      <td valign=\"top\"> Changed wrong type of parameter G from SIunits.Resistance to
           SIunits.Conductance.
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.MultiPhase.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> Plug<br></td>
      <td valign=\"top\"> Made used \"pin\" connectors non-graphical (otherwise, 
           there are difficulties to connect to Plug).
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Electrical.MultiPhase.Sources.</b></td></tr>
  <tr><td valign=\"top\"> SineCurrent</td>
      <td valign=\"top\"> Changed wrong type of parameter offset from SIunits.Voltage to
           SIunits.Current.
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Examples.Loops.</b></td></tr>
  <tr><td valign=\"top\"> EngineV6</td>
      <td valign=\"top\"> Corrected wrong crankAngleOffset of some cylinders
           and improved the example.
       </td> 
  </tr>
 
 
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Examples.Loops.Utilities.</b></td></tr>
  <tr><td valign=\"top\"> GasForce</td>
      <td valign=\"top\"> Wrong units corrected:
           \"SIunitsPosition x,y\" to \"Real x,y\";
" + "           \"SIunits.Pressure press\" to \"SIunits.Conversions.NonSIunits.Pressure_bar\"
       </td> 
  </tr>
  <tr><td valign=\"top\"> GasForce2</td>
      <td valign=\"top\"> Wrong unit corrected: \"SIunits.Position x\" to \"Real x\".
       </td> 
  </tr>
  <tr><td valign=\"top\"> EngineV6_analytic</td>
      <td valign=\"top\"> Corrected wrong crankAngleOffset of some cylinders.
       </td> 
  </tr>
 
 
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> PartialLineForce</td>
      <td valign=\"top\"> Corrected wrong unit: \"SIunits.Position eRod_a\" to \"Real eRod_a\";
       </td> 
  </tr>
  <tr><td valign=\"top\"> FlangeWithBearingAdaptor </td>
      <td valign=\"top\"> If includeBearingConnector = false, connector \"fr\"
               + \"ame\" was not
           removed. As long as the connecting element to \"frame\" determines
           the non-flow variables, this is fine. In the corrected version, \"frame\"
           is conditionally removed in this case.</td>
  </tr>

 
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Forces.</b></td></tr>
  <tr><td valign=\"top\"> ForceAndTorque</td>
      <td valign=\"top\"> Corrected wrong unit: \"SIunits.Force t_b_0\" to \"SIunits.Torque t_b_0\".
       </td> 
  </tr>
  <tr><td valign=\"top\"> LineForceWithTwoMasses</td>
      <td valign=\"top\"> Corrected wrong unit: \"SIunits.Position e_rel_0\" to \"Real e_rel_0\".
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Frames.</b></td></tr>
  <tr><td valign=\"top\"> axisRotation</td>
      <td valign=\"top\"> Corrected wrong unit: \"SIunits.Angle der_angle\" to
            \"SIunits.AngularVelocity der_angle\".
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Joints.Assemblies.</b></td></tr>
  <tr><td valign=\"top\"> JointUSP<br>JointSSP</td>
      <td valign=\"top\"> Corrected wrong unit: \"SIunits.Position aux\"  to \"Real\"
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Sensors.</b></td></tr>
  <tr><td valign=\"top\"> AbsoluteSensor</td>
      <td valign=\"top\"> Corrected wrong units: \"SIunits.Acceleration angles\" to
           \"SIunits.Angle angles\" and
           \"SIunits.Velocity w_abs_0\" to \"SIunits.AngularVelocity w_abs_0\"
       </td> 
  </tr>
  <tr><td valign=\"top\"> RelativeSensor</td>
      <td valign=\"top\"> Corrected wrong units: \"SIunits.Acceleration angles\" to
           \"SIunits.Angle angles\"
       </td> 
  </tr>
  <tr><td valign=\"top\"> Distance</td>
      <td valign=\"top\"> Corrected wrong units: \"SIunits.Length L2\" to \"SIunits.Area L2\" and
           SIunits.Length s_small2\" to \"SIunits.Area s_small2\"
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Mechanics.MultiBody.Visualizers.Advanced.</b></td></tr>
  <tr><td valign=\"top\"> Shape</td>
      <td valign=\"top\"> Changed \"MultiBody.Types.Color color\" to \"Real color[3]\", since
           \"Types.Color\" is \"Integer color[3]\" and there have been backward
           compatibility problems with models using \"color\" before it was changed
           to \"Types.Color\".
       </td> 
  </tr>  
 
  <tr><td colspan=\"2\"><b>Mechanics.Rotational.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> FrictionBase</td>
      <td valign=\"top\"> Rewrote equations with new variables \"unitAngularAcceleration\" and
           \"unitTorque\" in order that the equations are correct with respect
           to units (previously, variable \"s\" can be both a torque and an 
           angular acceleration and this lead to unit incompatibilities)
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Mechanics.Rotational.</b></td></tr>
  <tr><td valign=\"top\"> OneWayClutch<br>LossyGear</td>
      <td valign=\"top\"> Rewrote equations with new variables \"unitAngularAcceleration\" and
           \"unitTorque\" in order that the equations are correct with respect
           to units (previously, variable \"s\" can be both a torque and an 
           angular acceleration and this lead to unit incompatibilities)
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Mechanics.Translational.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> FrictionBase</td>
      <td valign=\"top\"> Rewrote equations with new variables \"unitAngularAcceleration\" and
           \"unitTorque\" in order that the equations are correct with respect
           to units (previously, variable \"s\" can be both a torque and an 
           angular acceleration and this lead to unit incompatibilities)
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Mechanics.Translational.</b></td></tr>
  <tr><td valign=\"top\"> Speed</td>
      <td valign=\"top\"> Corrected unit of v_ref from SIunits.Position to SIunits.Velocity
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Examples.Tests.Components.</b></td></tr>
  <tr><td valign=\"top\"> PartialTestModel<br>PartialTestModel2</td>
      <td valign=\"top\"> Corrected unit of h_start from \"SIunits.Density\" to \"SIunits.SpecificEnthalpy\"
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Examples.SolveOneNonlinearEquation.</b></td></tr>
  <tr><td valign=\"top\"> Inverse_sh_T
           InverseIncompressible_sh_T<br>
           Inverse_sh_TX</td>
      <td valign=\"top\"> Rewrote equations so that dimensional (unit) analysis is correct\"
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Incompressible.Examples.</b></td></tr>
  <tr><td valign=\"top\"> TestGlycol</td>
      <td valign=\"top\"> Rewrote equations so that dimensional (unit) analysis is correct\"
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Interfaces.PartialTwoPhaseMedium.</b></td></tr>
  <tr><td valign=\"top\"> dBubbleDensity_dPressure<br>dDewDensity_dPressure</td>
      <td valign=\"top\"> Changed wrong type of ddldp from \"DerDensityByEnthalpy\"
           to \"DerDensityByPressure\".
       </td> 
  </tr>
 
  <tr><td colspan=\"2\"><b>Media.Common.ThermoFluidSpecial.</b></td></tr>
  <tr><td valign=\"top\"> ThermoProperties</td>
      <td valign=\"top\"> Changed wrong units:
           \"SIunits.DerEnergyByPressure dupT\" to \"Real dupT\" and
           \"SIunits.DerEnergyByDensity dudT\" to \"Real dudT\"
       </td> 
  </tr>
  <tr><td valign=\"top\"> ThermoProperties_ph</td>
      <td valign=\"top\"> Changed wrong unit from \"SIunits.DerEnergyByPressure duph\" to \"Real duph\"
       </td> 
  </tr>
  <tr><td valign=\"top\"> ThermoProperties_pT</td>
      <td valign=\"top\"> Changed wrong unit from \"SIunits.DerEnergyByPressure dupT\" to \"Real dupT\"
       </td> 
  </tr>  
  <tr><td valign=\"top\"> ThermoProperties_dT</td>
      <td valign=\"top\">  Changed wrong unit from \"SIunits.DerEnergyByDensity dudT\" to \"Real dudT\"
       </td> 
  </tr>
  
  <tr><td colspan=\"2\"><b>Media.IdealGases.Common.SingleGasNasa.</b></td></tr>
  <tr><td valign=\"top\"> cp_Tlow_der</td>
      <td valign=\"top\"> Changed wrong unit from \"SIunits.Temperature dT\" to \"Real dT\".
       </td> 
  </tr>
  
  <tr><td colspan=\"2\"><b>Media.Water.IF97_Utilities.BaseIF97.Basic.</b></td></tr>
  <tr><td valign=\"top\"> p1_hs<br>
           h2ab_s<br> 
           p2a_hs<br> 
           p2b_hs<br> 
           p2c_hs<br> 
           h3ab_p<br> 
           T3a_ph<br> 
           T3b_ph<br> 
           v3a_ph<br> 
           v3b_ph<br> 
           T3a_ps<br> 
           T3b_ps<br> 
           v3a_ps<br> 
           v3b_ps</td>
      <td valign=\"top\"> Changed wrong unit of variables h/hstar, s, sstar from
           \"SIunits.Enthalpy\" to \"SIunits.SpecificEnthalpy\",
           \"SIunits.SpecificEntropy\", \"SIunits.SpecificEntropy
       </td> 
  </tr>
  
  <tr><td colspan=\"2\"><b>Media.Water.IF97_Utilities.BaseIF97.Transport.</b></td></tr>
  <tr><td valign=\"top\"> cond_dTp</td>
      <td valign=\"top\"> Changed wrong unit of TREL, rhoREL, lambdaREL from
           \"SIunits.Temperature\", \"SIunit.Density\", \"SIunits.ThermalConductivity\"
           to \"Real\".
       </td> 
  </tr>
  
  <tr><td colspan=\"2\"><b>Media.Water.IF97_Utilities.BaseIF97.Inverses.</b></td></tr>
  <tr><td valign=\"top\"> tofps5<br>tofpst5</td>
      <td valign=\"top\"> Changed wrong unit of pros from \"SIunits.SpecificEnthalpy\" to
           \"SIunits.SpecificEntropy\".
       </td> 
  </tr>
  
  <tr><td colspan=\"2\"><b>Media.Water.IF97_Utilities.</b></td></tr>
  <tr><td valign=\"top\"> waterBaseProp_ph</td>
      <td valign=\"top\"> Improved calculation at the limits of the validity.
       </td> 
  </tr>
 
    <tr><td colspan=\"2\"><b>Thermal.</b></td></tr>
  <tr><td valign=\"top\"> FluidHeatFlow<br>HeatTransfer</td>
      <td valign=\"top\"> Corrected wrong unit \"SIunits.Temperature\" of difference temperature
            variables with \"SIunits.TemperatureDifference\".
       </td> 
  </tr>
 
</table>
                               
</html>"));
  end Version_2_2_2;

  class Version_2_2_1 "Version 2.2.1 (March 24, 2006)"

      annotation (Documentation(info="<html>

<p>
Version 2.2.1 is backward compatible to version 2.2.
</p>
 
<p>
In this version, <b>no</b> new libraries have been added.
The following major improvements have been made:
</p>
 
<ul>
<li> The <b>Documentation</b> of the Modelica standard library was
     considerably improved:<br>
     In Dymola 6, the new feature was introduced to automatically add tables
     for class content and component interface definitions (parameters and 
     connectors) to the info layer. For this reason, the corresponding (partial)
     tables previously present in the Modelica Standard Library have been
     removed. The new feature of Dymola 6 has the significant advantage that
     all tables are now guaranteed to be up-to-date.<br>
     Additionally, the documentation has been improved by adding appropriate
     description texts to parameters, connector instances, function input
     and output arguments etc., in order that the automatically generated
     tables do not have empty entries. Also new User's Guides for sublibraries
     Rotational and SIunits have been added and the User's Guide on top
     level (Modelica.UsersGuide) has been improved.<br>&nbsp;</li>
 
<li> Initialization options have been added to the Modelica.Blocks.<b>Continuous</b>
     blocks (NoInit, SteadyState, InitialState, InitialOutput). If InitialOutput
     is selected, the block output is provided as initial condition. The states
     of the block are then initialized as close as possible to steady state.
     Furthermore, the Continuous.LimPID block has been significantly
     improved and much better documented.<br>&nbsp;</li>
 
<li> The Modelica.<b>Media</b> library has been significantly improved:<br>
     New functions setState_pTX, setState_phX, setState_psX, setState_dTX
     have been added to PartialMedium to compute the independent medium variables
     (= state of medium) from p,T,X, or from p,h,X or from p,s,X or from
     d,T,X. Then functions are provided for all interesting medium variables
     to compute them from its medium state. All these functions are
     implemented in a robust way for all media (with a few exceptions, if the
     generic function does not make sense for a particular medium).</li>
</ul>
 
<p>
The following <b>new components</b> have been added to <b>existing</b> libraries:
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2>
  <tr><td colspan=\"2\"><b>Modelica.Blocks.Examples.</b></td></tr>
  <tr><td valign=\"top\"> PID_Controller</td>
      <td valign=\"top\"> Example to demonstrate the usage of the
           Blocks.Continuous.LimPID block.</td> </tr>
  <tr><td colspan=\"2\"><b>Modelica.Blocks.Math.</b></td></tr>
  <tr><td valign=\"top\"> UnitConversions.*</td>
      <td valign=\"top\"> New package that provides blocks for unit conversions.
           UnitConversions.ConvertAllBlocks allows to select all
           available conversions from a menu.</td> </tr>
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.BasicMachines.SynchronousInductionMachines.</b></td></tr>
  <tr><td valign=\"top\"> SM_ElectricalExcitedDamperCage</td>
      <td valign=\"top\"> Electrical excited synchronous induction machine with damper cage</td> </tr>
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.BasicMachines.Components.</b></td></tr>
  <tr><td valign=\"top\"> ElectricalExcitation </td>
      <td valign=\"top\"> Electrical excitation for electrical excited synchronous 
           induction machines</td> </tr>
  <tr><td valign=\"top\"> DamperCage</td>
      <td valign=\"top\"> Unsymmetrical damper cage for electrical excited synchronous 
           induction machines. At least the user has to specify the dampers
           resistance and stray inductance in d-axis; if he omits the
           parameters of the q-axis, the same values as for the d.axis 
           are used, assuming a symmetrical damper.</td> </tr>
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.Examples.</b></td></tr>
  <tr><td valign=\"top\"> SMEE_Gen </td>
      <td valign=\"top\"> Test example 7: ElectricalExcitedSynchronousInductionMachine 
           as Generator</td> </tr>
  <tr><td valign=\"top\"> Utilities.TerminalBox</td>
      <td valign=\"top\"> Terminal box for three-phase induction machines to choose  
           either star (wye) ? or delta ? connection</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Math.Matrices.</b></td></tr>
  <tr><td valign=\"top\"> equalityLeastSquares</td>
      <td valign=\"top\"> Solve a linear equality constrained least squares problem:<br>
          min|A*x-a|^2 subject to B*x=b</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.</b></td></tr>
  <tr><td valign=\"top\"> Parts.PointMass</td>
      <td valign=\"top\"> Point mass, i.e., body where inertia tensor is neglected.</td> </tr>
  <tr><td valign=\"top\"> Interfaces.FlangeWithBearing</td>
      <td valign=\"top\"> Connector consisting of 1-dim. rotational flange and its 
           3-dim. bearing frame.</td> </tr>
  <tr><td valign=\"top\"> Interfaces.FlangeWithBearingAdaptor</td>
      <td valign=\"top\"> Adaptor to allow direct connections to the sub-connectors 
           of FlangeWithBearing.</td> </tr>
  <tr><td valign=\"top\"> Types.SpecularCoefficient</td>
      <td valign=\"top\"> New type to define a specular coefficient.</td> </tr>
  <tr><td valign=\"top\"> Types.ShapeExtra</td>
      <td valign=\"top\"> New type to define the extra data for visual shape objects and to
           have a central place for the documentation of this data.</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Examples.Elementary</b></td></tr>
  <tr><td valign=\"top\"> PointGravityWithPointMasses</td>
      <td valign=\"top\"> Example of two point masses in a central gravity field.</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
  <tr><td valign=\"top\">UsersGuide</td>
      <td valign=\"top\"> A User's Guide has been added by using the documentation previously
           present in the package documentation of Rotational.</td> </tr>
  <tr><td valign=\"top\">Sensors.PowerSensor</td>
      <td valign=\"top\"> New component to measure the energy flow between two connectors
           of the Rotational library.</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Mechanics.Translational.</b></td></tr>
  <tr><td valign=\"top\">Speed</td>
      <td valign=\"top\"> New component to move a translational flange 
           according to a reference speed</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Media.Interfaces.PartialMedium.</b></td></tr>
  <tr><td valign=\"top\">specificEnthalpy_pTX</td>
      <td valign=\"top\"> New function to compute specific enthalpy from pressure, temperature
           and mass fractions.</td> </tr>
  <tr><td valign=\"top\">temperature_phX</td>
      <td valign=\"top\"> New function to compute temperature from pressure, specific enthalpy,
           and mass fractions.</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Icons.</b></td></tr>
  <tr><td valign=\"top\"> SignalBus</td>
      <td valign=\"top\"> Icon for signal bus</td> </tr>
  <tr><td valign=\"top\"> SignalSubBus</td>
      <td valign=\"top\"> Icon for signal sub-bus</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.SIunits.</b></td></tr>
  <tr><td valign=\"top\">UsersGuide</td>
      <td valign=\"top\"> A User's Guide has been added that describes unit handling.</td> </tr>
  <tr><td valign=\"top\"> Resistance<br>
           Conductance</td>
      <td valign=\"top\"> Attribute 'min=0' removed from these types.</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Thermal.FluidHeatFlow.</b></td></tr>
  <tr><td valign=\"top\"> Components.Valve</td>
      <td valign=\"top\"> Simple controlled valve with either linear or 
           exponential characteristic.</td> </tr>
  <tr><td valign=\"top\"> Sources. IdealPump </td>
      <td valign=\"top\"> Simple ideal pump (resp. fan)  dependent on the shaft?s speed;
           pressure increase versus volume flow is defined as a linear 
           function. Torque * Speed = Pressure invrease * Volume flow 
           (without losses).</td> </tr>
  <tr><td valign=\"top\"> Examples.PumpAndValve </td>
      <td valign=\"top\"> Test example for valves.</td> </tr>
  <tr><td valign=\"top\"> Examples.PumpDropOut </td>
      <td valign=\"top\"> Drop out of 1 pump to test behavior of semiLinear.</td> </tr>
  <tr><td valign=\"top\"> Examples.ParallelPumpDropOut </td>
      <td valign=\"top\"> Drop out of 2 parallel pumps to test behavior of semiLinear.</td> </tr>
  <tr><td valign=\"top\"> Examples.OneMass </td>
      <td valign=\"top\"> Cooling of 1 hot mass to test behavior of semiLinear.</td> </tr>
  <tr><td valign=\"top\"> Examples.TwoMass </td>
      <td valign=\"top\"> Cooling of 2 hot masses to test behavior of semiLinear.</td> </tr>
</table> 
 
<p>
The following <b>components</b> have been improved:
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2>
  <tr><td colspan=\"2\"><b>Modelica.</b></td></tr>
  <tr><td valign=\"top\"> UsersGuide</td>
      <td valign=\"top\"> User's Guide and package description of Modelica Standard Library improved.</td> </tr>
  <tr><td colspan=\"2\"><b>Modelica.Blocks.Interfaces.</b></td></tr>
  <tr><td valign=\"top\"> RealInput<br>
           BooleanInput<br>
           IntegerInput</td>
      <td valign=\"top\"> When dragging one of these connectors the width and height
           is a factor of 2 larger as a standard icon. Previously,
           these connectors have been dragged and then manually enlarged
           by a factor of 2 in the Modelica standard library.</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Blocks.</b></td></tr>
  <tr><td valign=\"top\"> Continuous.*</td>
      <td valign=\"top\"> Initialization options added to all blocks
           (NoInit, SteadyState, InitialState, InitialOutput).
           New parameter limitsAtInit to switch off the limits
           of LimIntegrator or LimPID during initialization</td> </tr>
  <tr><td valign=\"top\"> Continuous.LimPID</td>
      <td valign=\"top\"> Option to select P, PI, PD, PID controller.
           Documentation significantly improved.</td> </tr>
  <tr><td valign=\"top\"> Nonlinear.Limiter<br>
           Nonlinear.VariableLimiter<br>
           Nonlinear.Deadzone</td>
      <td valign=\"top\"> New parameter limitsAtInit/deadZoneAtInit to switch off the limits
           or the dead zone during initialization</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog. </b></td></tr>
  <tr><td valign=\"top\"> Sources</td>
      <td valign=\"top\"> Icon improved (+/- added to voltage sources, arrow added to
           current sources).</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Semiconductors. </b></td></tr>
  <tr><td valign=\"top\"> Diode</td>
      <td valign=\"top\"> smooth() operator included to improve numerics.</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.BasicMachines.SynchronousInductionMachines. </b></td></tr>
  <tr><td valign=\"top\"> SM_PermanentMagnetDamperCage<br>
           SM_ElectricalExcitedDamperCage<br>
           SM_ReluctanceRotorDamperCage</td>
      <td valign=\"top\"> The user can choose \"DamperCage = false\" (default: true) 
           to remove all equations for the damper cage from the model.</td> </tr>
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Machines.BasicMachines.AsynchronousInductionMachines. </b></td></tr>
  <tr><td valign=\"top\"> AIM_SlipRing</td>
      <td valign=\"top\"> Easier parameterization: if the user selects \"useTrunsRatio = false\" 
           (default: true, this is the same behavior as before), 
            parameter TurnsRatio is calculated internally from 
            Nominal stator voltage and Locked-rotor voltage.</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Math.Matrices.</b></td></tr>
  <tr><td valign=\"top\">leastSquares</td>
      <td valign=\"top\">The A matrix in the least squares problem might be rank deficient.
          Previously, it was required that A has full rank.</td>
 
  <tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.</b></td></tr>
  <tr><td valign=\"top\">all models</td>
      <td valign=\"top\"> <ul> 
           <li> All components with animation information have a new variable
                <b>specularCoefficient</b> to define the reflection of ambient light. 
                The default value is world.defaultSpecularCoefficient which has
                a default of 0.7. By changing world.defaultSpecularCoefficient, the
                specularCoefficient of all components is changed that are not
                explicitly set differently. Since specularCoefficient is a variable
                (and no parameter), it can be changed during simulation. Since
                annotation(Dialog) is set, this variable still appears in the
                parameter menus.<br>
                Previously, a constant specularCoefficient of 0.7 was used
                for all components.</li>
           <li> Variable <b>color</b> of all components is no longer a parameter
                but an input variable. Also all parameters in package <b>Visualizers</b>,
                with the exception of <b>shapeType</b> are no longer parameters but
                defined as input variables with annotation(Dialog). As a result,
                all these variables appear still in parameter menus, but they can
                be changed during simulation (e.g., color might be used to
                display the temperature of a part).</li>
           <li> All menus have been changed to follow the Modelica 2.2 annotations
                \"Dialog, group, tab, enable\" (previously, a non-standard Dymola
                definition for menus was used). Also, the \"enable\" annotation 
                is used in all menus
                to disable input fields if the input would be ignored.</li>
           <li> All visual shapes are now defined with conditional declarations
                (to remove them, if animation is switched off). Previously,
                these (protected) objects have been defined by arrays with
                dimension 0 or 1.</li>
           </ul></td></tr>
 
  <tr><td valign=\"top\">Frames.resolveRelative</td>
      <td valign=\"top\"> The derivative of this function added as function and defined via
           an annotation. In certain situations, tools had previously
           difficulties to differentiate the inlined function automatically.</td>
 
 
  <tr><td valign=\"top\">Forces.*</td>
      <td valign=\"top\"> The scaling factors N_to_m and Nm_to_m have no longer a default
           value of 1000 but a default value of world.defaultN_to_m (=1000) 
           and world.defaultNm_to_m (=1000). This allows to change the
           scaling factors for all forces and torques in the world
           object.</td>
  <tr><td valign=\"top\">Interfaces.Frame.a<br>
          Interfaces.Frame.b<br>
          Interfaces.Frame_resolve</td>
      <td valign=\"top\"> The Frame connectors are now centered around the origin to ease
           the usage. The shape was changed, such that the icon is a factor
           of 1.6 larger as a standard icon (previously, the icon had a 
           standard size when dragged and then the icon was manually enlarged
           by a factor of 1.5 in the y-direction in the MultiBody library;
           the height of 16 allows easy positioning on the standard grid size of 2).
           The double line width of the border in icon and diagram layer was changed
           to a single line width and when making a connection the connection
           line is dark grey and no longer black which looks better.</td>
  <tr><td valign=\"top\">Joints.Assemblies.*</td>
      <td valign=\"top\"> When dragging an assembly joint, the icon is a factor of 2
           larger as a standard icon. Icon texts and connectors have a 
           standard size in this enlarged icon (and are not a factor of 2
           larger as previously). </td>
  <tr><td valign=\"top\">Types.*</td>
      <td valign=\"top\"> All types have a corresponding icon now to visualize the content
           in the package browser (previously, the types did not have an icon).</td>
 
  <tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
  <tr><td valign=\"top\"> Inertia</td>
      <td valign=\"top\"> Initialization and state selection added.</td> </tr>
  <tr><td valign=\"top\"> SpringDamper</td>
      <td valign=\"top\"> Initialization and state selection added.</td> </tr>
  <tr><td valign=\"top\"> Move</td>
      <td valign=\"top\"> New implementation based solely on Modelica 2.2 language
           (previously, the Dymola specific constrain(..) function was used).</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Mechanics.Translational.</b></td></tr>
  <tr><td valign=\"top\"> Move</td>
      <td valign=\"top\"> New implementation based solely on Modelica 2.2 language
           (previously, the Dymola specific constrain(..) function was used).</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Thermal.FluidHeatFlow.Interfaces.Partials.</b></td></tr>
  <tr><td valign=\"top\"> SimpleFriction</td>
      <td valign=\"top\"> Calculates friction losses from pressure drop and volume flow.</td> </tr>
  <tr><td colspan=\"2\"><b>Modelica.Thermal.FluidHeatFlow.Components.</b></td></tr>
  <tr><td valign=\"top\"> IsolatedPipe <br>
           HeatedPipe</td>
      <td valign=\"top\"> Added geodetic height as a source of pressure change;
           feeds friction losses as calculated by simple friction to  
           the energy balance of the medium.</td> </tr>
  <tr><td colspan=\"2\"><b>Modelica.Media.Interfaces.PartialMedium.FluidConstants.</b></td></tr>
  <tr><td valign=\"top\">HCRIT0</td><td valign=\"top\">Critical specifc enthalpy of the fundamental
          equation (base formulation of the fluid medium model). </td></tr>
  <tr><td valign=\"top\">SCRIT0</td><td valign=\"top\">Critical specifc entropy of the fundamental
          equation (base formulation of the fluid medium model). </td></tr>
  <tr><td valign=\"top\">deltah</td><td valign=\"top\">Enthalpy offset (default: 0) between the
          specific enthalpy of the fluid model and the user-visible
          specific enthalpy in the model: deltah = h_model - h_fundamentalEquation.
</td></tr>
  <tr><td valign=\"top\">deltas</td><td valign=\"top\">Entropy offset (default: 0) between the
          specific entropy of the fluid model and the user-visible
          specific entropy in the model: deltas = s_model - s_fundamentalEquation.</td></tr>
  <tr><td valign=\"top\">T_default</td><td valign=\"top\">Default value for temperature of medium (for initialization)</td></tr>
  <tr><td valign=\"top\">h_default</td><td valign=\"top\">Default value for specific enthalpy of medium (for initialization)</td></tr>
  <tr><td valign=\"top\">p_default</td><td valign=\"top\">Default value for pressure of medium (for initialization)</td></tr>
  <tr><td valign=\"top\">X_default</td><td valign=\"top\">Default value for mass fractions of medium (for initialization)</td></tr>
</table> 
<p>
The following <b>errors</b> have been fixed:
</p>
 
<table border=\"1\" cellspacing=0 cellpadding=2>
  <tr><td colspan=\"2\"><b>Modelica.Blocks.Tables.</b></td></tr>
  <tr><td valign=\"top\">CombiTable1D<br>
          CombiTable1Ds<br>
          CombiTable2D</td>
      <td valign=\"top\"> Parameter \"tableOnFile\" determines now whether a table is read from
           file or used from parameter \"table\". Previously, if \"fileName\" was not
           \"NoName\", a table was always read from file \"fileName\", independently
           of the setting of \"tableOnFile\". This has been corrected.<br>
           Furthermore, the initialization of a table is now performed in a 
           when-clause and no longer in a parameter declaration, because some
           tools evaluate the parameter declaration in some situation more than
           once and then the table is unnecessarily read several times    
           (and occupies also more memory).</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Blocks.Sources.</b></td></tr>
  <tr><td valign=\"top\">CombiTimeTable</td>
      <td valign=\"top\"> Same bug fix/improvement as for the tables from Modelica.Blocks.Tables 
           as outlined above.</td> </tr>
 
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Semiconductors. </b></td></tr>
  <tr><td valign=\"top\"> PMOS<br>
           NMOS<br>
           HeatingPMOS<br>
           HeatingNMOS</td>
      <td valign=\"top\"> The Drain-Source-Resistance RDS had actually a resistance of
           RDS/v, with v=Beta*(W+dW)/(L+dL). The correct formula is without
           the divison by \"v\". This has now been corrected.<br>
           This bug fix should not have an essential effect in most applications.
           In the default case (Beta=1e-5), the Drain-Source-Resistance was
           a factor of 1e5 too large and had in the default case the
           wrong value 1e12, although it should have the value 1e7. The effect
           was that this resistance had practically no effect.</td> </tr>
 
  <tr><td colspan=\"2\"> <b>Modelica.Media.IdealGases.Common.SingleGasNasa.</b></td></tr>
  <tr><td valign=\"top\"> dynamicViscosityLowPressure</td>
      <td valign=\"top\"> Viscosity and thermal conductivity (which needs viscosity as input) 
           were computed wrong for polar gases and gas mixtures 
           (i.e. if dipole moment not 0.0). This has been fixed in version 2.2.1.</td> </tr>
  <tr><td colspan=\"2\"><b>Modelica.Utilities.Streams.</b></td></tr>
  <tr><td valign=\"top\">readLine</td>
      <td valign=\"top\"> Depending on the C-implementation, the stream was not correctly closed.
           This has been corrected by adding a \"Streams.close(..)\" 
           after reading the file content.</td> </tr>
 
</table>                                 
</html>
"));
  end Version_2_2_1;

  class Version_2_2 "Version 2.2 (April 6, 2005)"

      annotation (Documentation(info="<html>

<p>
Version 2.2 is backward compatible to version 2.1.
</p>
The following <b>new libraries</b> have been added:
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Media\">Modelica.Media</a></td>
      <td valign=\"top\"> Property models of liquids and gases, especially
           <ul>
           <li>1241 detailed gas models,</li>
           <li> moist air,</li>
           <li> high precision water model (according to IAPWS/IF97 standard), </li>
           <li> incompressible media defined by tables (cp(T), rho(t), eta(T), etc. are defined by tables).</li>
           </ul>
           The user can conveniently define mixtures of gases between the 
           1241 gas models. The models are
           designed to work well in dynamic simulations. They
           are based on a new standard interface for media with
           single and multiple substances and one or multiple phases
           with the following features:
           <ul>
           <li> The independent variables of a medium model do not influence the 
                definition of a fluid connector port or how the
                balance equations have to be implemented.<br>
                Used independent variables: \"p,T\", \"p,T,X\", \"p,h\", \"d,T\".</li>
           <li> Optional variables, e.g., dynamic viscosity, are only computed 
                if needed.<li>
           <li> The medium models are implemented with regards to efficient 
                dynamic simulation.</li>
           </ul>
      </td><tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Thermal.FluidHeatFlow\">Modelica.Thermal.FluidHeatFlow</a></td>
      <td valign=\"top\"> Simple components for 1-dim., incompressible thermo-fluid flow 
           to model coolant flows, e.g., of electrical machines.
           Components can be connected arbitrarily together (= ideal mixing
           at connection points) and fluid may reverse direction of flow. 
  </td><tr>
</table>
<p>
The following <b>changes</b> have been performed in the
<b>Modelica.Mechanics.MultiBody</b> library:
</p>
<ul>
<li> Component MultiBody.World has a new parameter
     <b>driveTrainMechanics3D</b>. If set to <b>true</b>, 3D mechanical effects
     of MultiBody.Parts.Mounting1D/Rotor1D/BevelGear1D are taken into account. If set to 
     <b>false</b> (= default), 3D mechanical effects in these elements
     are not taken into account and the
     frame connectors to connect to 3D parts are disabled (all
     connections to such a disabled connector are also disabled, due to the
     new feature of conditional declarations in Modelica language 2.2)</li>
<li> All references to \"MultiBody.xxx\" have
     been changed to \"Modelica.Mechanics.MultiBodys.xxx\" in order that after
     copying of a component outside of the Modelica library, the references
     still remain valid.</li>
</ul>
</html>
"));
  end Version_2_2;

  class Version_2_1 "Version 2.1 (Nov. 11, 2004)"

      annotation (Documentation(info="<html>

<p> This is a major change with respect to previous versions of the
    Modelica Standard Library, because <b>many new libraries</b> and components
    are included and because the input/output blocks (Modelica.Blocks)
    have been considerably simplified:
</p>
<ul>
<li> An input/output connector is defined <b>without</b> a hierarchy (this is possible
     due to new features of the Modelica language). For example, the input
     signal of a block \"FirstOrder\" was previously accessed as \"FirstOrder.inPort.signal[1]\".
     Now it is accessed as \"FirstOrder.u\". This simplifies the understanding and usage 
     especially for beginners.</li>
<li> De-vectorized the <b>Modelica.Blocks</b> library. All blocks in the
     Modelica.Blocks library are now scalar blocks. As a result,
     the parameters of the Blocks are scalars and no vectors any
     more. For example, a parameter \"amplitude\" that might had
     a value of \"{1}\" previously, has now a value of \"1\". This simplifies
     the understanding and usage especially for beginners.<br>
     If a vector of blocks is needed, this can be easily
     accomplished by adding a dimension to the instance. For example
     \"Constant const[3](k={1,2,3}\" defines three Constant blocks. 
     An additional advantage of the new approach is that
     the implementation of Modelica.Blocks is much simpler and is easier to
     understand.
</li>
</ul>
     
<p>
The discussed changes of Modelica.Blocks are not backward compatible.
A script to <b>automatically</b> convert models to this new version is
provided. There might be rare cases, where this script does not convert. 
In this case models have to be manually converted.
In any case you should make a back-up copy of your model
before automatic conversion is performed. 
</p>
<p>
The following <b>new libraries</b> have been added:
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Electrical.Digital\">Modelica.Electrical.Digital</a></td>
      <td valign=\"top\">Digital electrical components based on 2-,3-,4-, and 9-valued logic<br>
          according to the VHDL standard</td><tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Electrical.Machines\">Modelica.Electrical.Machines</a></td>
      <td valign=\"top\">Asynchronous, synchronous and DC motor and generator models</td><tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Math.Matrices\">Modelica.Math.Matrices</a></td>
      <td valign=\"top\">Functions operatinng on matrices such as solve() (A*x=b), leastSquares(),<br>
          norm(), LU(), QR(),  eigenValues(), singularValues(), exp(), ...</td><tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.StateGraph\">Modelica.StateGraph</a></td>
      <td valign=\"top\"> Modeling of <b>discrete event</b> and <b>reactive</b> systems in a convenient way using<br>
           <b>hierarchical state machines</b> and <b>Modelica</b> as <b>action language</b>. <br>
           It is based on JGraphChart and Grafcet and  has a similar modeling power as <br>
           StateCharts. It avoids deficiences of usually used action languages. <br>
           This library makes the ModelicaAdditions.PetriNets library obsolet.</td></tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Utilities.Files\">Modelica.Utilities.Files</a></td>
      <td valign=\"top\">Functions to operate on files and directories (copy, move, remove files etc.)</td></tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Utilities.Streams\">Modelica.Utilities.Streams</a></td>
      <td valign=\"top\">Read from files and write to files (print, readLine, readFile, error, ...)</td></tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Utilities.Strings\">Modelica.Utilities.Strings</a></td>
      <td valign=\"top\">Operations on strings (substring, find, replace, sort, scanToken, ...)</td></tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Utilities.System\">Modelica.Utilities.System</a></td>
      <td valign=\"top\">Get/set current directory, get/set environment variable, execute shell command, etc.</td></tr>
</table>
<p>
The following existing libraries outside of the Modelica standard library
have been improved and added as <b>new libraries</b>
(models using the previous libraries are automatically converted
to the new sublibraries inside package Modelica):
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Blocks.Discrete\">Modelica.Blocks.Discrete</a></td>
      <td valign=\"top\"> Discrete input/output blocks with fixed sample period<br>
           (from ModelicaAdditions.Blocks.Discrete)</td></tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Blocks.Logical\">Modelica.Blocks.Logical</a></td>
      <td valign=\"top\"> Logical components with Boolean input and output signals<br>
           (from ModelicaAdditions.Blocks.Logical)</td></tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Blocks.Nonlinear\">Modelica.Blocks.Nonlinear</a></td>
      <td valign=\"top\"> Discontinuous or non-differentiable algebraic control blocks such as variable limiter,<br>
           fixed, variable and Pade delay etc. (from ModelicaAdditions.Blocks.Nonlinear)</td></tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Blocks.Routing\">Modelica.Blocks.Routing</a></td>
      <td valign=\"top\"> Blocks to combine and extract signals, such as multiplexer<br>
           (from ModelicaAdditions.Blocks.Multiplexer)</td></tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Blocks.Tables\">Modelica.Blocks.Tables</a></td>
      <td valign=\"top\"> One and two-dimensional interpolation in tables. CombiTimeTable is available<br>
           in Modelica.Blocks.Sources (from ModelicaAdditions.Tables)</td></tr>
  <tr><td valign=\"top\"><a href=\"Modelica://Modelica.Mechanics.MultiBody\">Modelica.Mechanics.MultiBody</a></td>
      <td valign=\"top\"> Components to model the movement of 3-dimensional mechanical systems. Contains <br>
           body, joint, force and sensor components, analytic handling of kinematic loops,<br>
           force elements with mass, series/parallel connection of 3D force elements etc.<br>
           (from MultiBody 1.0 where the new signal connectors are used;<br>
           makes the ModelicaAdditions.MultiBody library obsolet)</td></tr>
</table>
<p>
As a result, the ModelicaAdditions library is obsolet, because all components
are either included in the Modelica library or are replaced by much more
powerful libraries (MultiBody, StateGraph).
</p>
<p>
The following <b>new components</b> have been added to <b>existing</b> libraries.
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
  <tr><td colspan=\"2\"><b>Modelica.Blocks.Logical.</b></td></tr>
  <tr><td valign=\"top\">Pre</td>
      <td valign=\"top\">y = pre(u): Breaks algebraic loops by an infinitesimal small <br>
          time delay (event iteration continues until u = pre(u))</td></tr>
  <tr><td valign=\"top\">Edge</td>
      <td valign=\"top\">y = edge(u): Output y is true, if the input u has a rising edge </td></tr>
  <tr><td valign=\"top\">FallingEdge</td>
      <td valign=\"top\">y = edge(not u): Output y is true, if the input u has a falling edge </td></tr>
  <tr><td valign=\"top\">Change</td>
      <td valign=\"top\">y = change(u): Output y is true, if the input u has a rising or falling edge </td></tr>
  <tr><td valign=\"top\">GreaterEqual</td>
      <td valign=\"top\">Output y is true, if input u1 is greater or equal as input u2 </td></tr>
  <tr><td valign=\"top\">Less</td>
      <td valign=\"top\">Output y is true, if input u1 is less as input u2 </td></tr>
  <tr><td valign=\"top\">LessEqual</td>
      <td valign=\"top\">Output y is true, if input u1 is less or equal as input u2 </td></tr>
  <tr><td valign=\"top\">Timer</td>
      <td valign=\"top\">Timer measuring the time from the time instant where the <br>
          Boolean input became true </td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Blocks.Math.</b></td></tr>
  <tr><td valign=\"top\">BooleanToReal</td>
      <td valign=\"top\">Convert Boolean to Real signal</td></tr>
  <tr><td valign=\"top\">BooleanToInteger</td>
      <td valign=\"top\">Convert Boolean to Integer signal</td></tr>
  <tr><td valign=\"top\">RealToBoolean</td>
      <td valign=\"top\">Convert Real to Boolean signal</td></tr>
  <tr><td valign=\"top\">IntegerToBoolean</td>
      <td valign=\"top\">Convert Integer to Boolean signal</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Blocks.Sources.</b></td></tr>
  <tr><td valign=\"top\">RealExpression</td>
      <td valign=\"top\">Set output signal to a time varying Real expression</td></tr>
  <tr><td valign=\"top\">IntegerExpression</td>
      <td valign=\"top\">Set output signal to a time varying Integer expression</td></tr>
  <tr><td valign=\"top\">BooleanExpression</td>
      <td valign=\"top\">Set output signal to a time varying Boolean expression</td></tr>
  <tr><td valign=\"top\">BooleanTable</td>
      <td valign=\"top\">Generate a Boolean output signal based on a vector of time instants</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.</b></td></tr>
  <tr><td valign=\"top\">Frames.from_T2</td>
      <td valign=\"top\">Return orientation object R from transformation matrix T and its derivative der(T)</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
  <tr><td valign=\"top\">LinearSpeedDependentTorque</td>
      <td valign=\"top\">Linear dependency of torque versus speed (acts as load torque)</td></tr>
  <tr><td valign=\"top\">QuadraticSpeedDependentTorque</td>
      <td valign=\"top\">Quadratic dependency of torque versus speed (acts as load torque)</td></tr>
  <tr><td valign=\"top\">ConstantTorque</td>
      <td valign=\"top\">Constant torque, not dependent on speed (acts as load torque)</td></tr>
  <tr><td valign=\"top\">ConstantSpeed</td>
      <td valign=\"top\">Constant speed, not dependent on torque (acts as load torque)</td></tr>
  <tr><td valign=\"top\">TorqueStep</td>
      <td valign=\"top\">Constant torque, not dependent on speed (acts as load torque)</td></tr>
</table>
<p>
The following <b>bugs</b> have been <b>corrected</b>:
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
  <tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Forces.</b></td></tr>
  <tr><td valign=\"top\">LineForceWithMass<br>
          Spring</td>
      <td valign=\"top\">If mass of the line force or spring component is not zero, the<br>
          mass was (implicitly) treated as \"mass*mass\" instead of as \"mass\"</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
  <tr><td valign=\"top\">Speed</td>
      <td valign=\"top\">If parameter exact=<b>false</b>, the filter was wrong<br>
          (position was filtered and not the speed input signal)</td></tr>
</table> 
<p>
Other changes:
</p>
<ul>
<li> All connectors are now smaller in the diagram layer. This gives
     a nicer layout when connectors and components are used together
     in a diagram</li>
<li> Default instance names are defined for all connectors, according
     to a new annotation introduced in Modelica 2.1. For example,
     when dragging connector \"Flange_a\" from the Rotational library to
     the diagram layer, the default connector instance name is
     \"flange_a\" and not \"Flange_a1\".</li>
<li> The Modelica.Mechanics.Rotational connectors are changed from
     a square to a circle</li>
<li> The Modelica.Mechanics.Translational connectors are changed from a
     green to a dark green color in order that connection lines
     can be better seen, especially when printed.</li>
<li> The Modelica.Blocks connectors for Real signals are changed from
     blue to dark blue in order to distinguish them from electrical signals.</li>
</ul>
</html>
"));
  end Version_2_1;

  class Version_1_6 "Version 1.6 (June 21, 2004)"

      annotation (Documentation(info="<html>

<p> Added 1 new library (Electrical.MultiPhase), 17 new components, 
    improved 3 existing components
    in the Modelica.Electrical library and improved 3 types
    in the Modelica.SIunits library. Furthermore,
    this User's Guide has been started. The improvements
    in more detail:
</p>
<p>
<b>New components</b>
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Basic.</b></td></tr>
  <tr><td valign=\"top\">SaturatingInductor</td>
      <td valign=\"top\">Simple model of an inductor with saturation</td></tr>
  <tr><td valign=\"top\">VariableResistor</td>
      <td valign=\"top\">Ideal linear electrical resistor with variable resistance</td></tr>
  <tr><td valign=\"top\">VariableConductor</td>
      <td valign=\"top\">Ideal linear electrical conductor with variable conductance</td></tr>
  <tr><td valign=\"top\">VariableCapacitor</td>
      <td valign=\"top\">Ideal linear electrical capacitor with variable capacitance</td></tr>
  <tr><td valign=\"top\">VariableInductor</td>
      <td valign=\"top\">Ideal linear electrical inductor with variable inductance</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Semiconductors.</b></td></tr>
  <tr><td valign=\"top\">HeadingDiode</td>
      <td valign=\"top\">Simple diode with heating port</td></tr>
  <tr><td valign=\"top\">HeadingNMOS</td>
      <td valign=\"top\">Simple MOS Transistor with heating port</td></tr>
  <tr><td valign=\"top\">HeadingPMOS</td>
      <td valign=\"top\">Simple PMOS Transistor with heating port</td></tr>
  <tr><td valign=\"top\">HeadingNPN</td>
      <td valign=\"top\">Simple NPN BJT according to Ebers-Moll with heating port</td></tr>
  <tr><td valign=\"top\">HeadingPNP</td>
      <td valign=\"top\">Simple PNP BJT according to Ebers-Moll with heating port</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Electrical.MultiPhase</b><br>
      A new library for multi-phase electrical circuits</td></tr>
</table>
<p>
<b>New examples</b>
</p>
<p>
The following new examples have been added to 
Modelica.Electrical.Analog.Examples:
</p>
<p>
CharacteristicThyristors, 
CharacteristicIdealDiodes,
HeatingNPN_OrGate,
HeatingMOSInverter,
HeatingRectifier,
Rectifier,
ShowSaturatingInductor
ShowVariableResistor
</p>
<p>
<b>Improved existing components</b>
</p>
<p>In the library Modelica.Electrical.Analog.Ideal,
   a knee voltage has been introduced for the components
   IdealThyristor, IdealGTOThyristor, IdealDiode in order
   that the approximation of these ideal elements is improved
   with not much computational effort.</p>
<p> In the Modelica.SIunits library, the following changes
    have been made:</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\">Inductance</td>
      <td valign=\"top\">min=0 removed</td></tr>
  <tr><td valign=\"top\">SelfInductance</td>
      <td valign=\"top\">min=0 added</td></tr>
  <tr><td valign=\"top\">ThermodynamicTemperature</td>
      <td valign=\"top\">min=0 added</td></tr>
</table>
</html>
"));
  end Version_1_6;

  class Version_1_5 "Version 1.5 (Dec. 16, 2002)"

      annotation (Documentation(info="<html>

<p> Added 55 new components. In particular, added new package
    <b>Thermal.HeatTransfer</b> for modeling of lumped
    heat transfer, added model <b>LossyGear</b> in Mechanics.Rotational
    to model gear efficiency and bearing friction according to a new
    theory in a robust way, added 10 new models in Electrical.Analog and 
    added several other new models and improved existing models. 
</p>
<p>
<b>New components</b>
</p>
<table border=\"1\" cellspacing=0 cellpadding=2>
  <tr><td colspan=\"2\"><b>Modelica.Blocks.</b></td></tr>
  <tr><td valign=\"top\">Continuous.Der</td><td valign=\"top\">Derivative of input (= analytic differentations)</td></tr>
  <tr><td valign=\"top\"><b><i>Examples</i></b></td><td valign=\"top\">Demonstration examples of the components of this package</td></tr>
  <tr><td valign=\"top\">Nonlinear.VariableLimiter</td><td valign=\"top\">Limit the range of a signal with variable limits</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Blocks.Interfaces.</b></td></tr>
  <tr><td valign=\"top\">RealPort</td><td valign=\"top\">Real port (both input/output possible)</td></tr>
  <tr><td valign=\"top\">IntegerPort</td><td valign=\"top\">Integer port (both input/output possible)</td></tr>
  <tr><td valign=\"top\">BooleanPort</td><td valign=\"top\">Boolean port (both input/output possible)</td></tr>
  <tr><td valign=\"top\">SIMO</td><td valign=\"top\">Single Input Multiple Output continuous control block</td></tr>
  <tr><td valign=\"top\">IntegerBlockIcon</td><td valign=\"top\">Basic graphical layout of Integer block</td></tr>
  <tr><td valign=\"top\">IntegerMO</td><td valign=\"top\">Multiple Integer Output continuous control block</td></tr>
  <tr><td valign=\"top\">IntegerSignalSource</td><td valign=\"top\">Base class for continuous Integer signal source</td></tr>
  <tr><td valign=\"top\">IntegerMIBooleanMOs</td><td valign=\"top\">Multiple Integer Input Multiple Boolean Output continuous control block with same number of inputs and outputs</td></tr>
  <tr><td valign=\"top\">BooleanMIMOs</td><td valign=\"top\">Multiple Input Multiple Output continuous control block with same number of inputs and outputs of boolean type</td></tr>
  <tr><td valign=\"top\"><b><i>BusAdaptors</i></b></td><td valign=\"top\">Components to send signals to the bus or receive signals from the bus</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Blocks.Math.</b></td></tr>
  <tr><td valign=\"top\">RealToInteger</td><td valign=\"top\">Convert real to integer signals</td></tr>
  <tr><td valign=\"top\">IntegerToReal</td><td valign=\"top\">Convert integer to real signals</td></tr>
  <tr><td valign=\"top\">Max</td><td valign=\"top\">Pass through the largest signal</td></tr>
  <tr><td valign=\"top\">Min</td><td valign=\"top\">Pass through the smallest signal</td></tr>
  <tr><td valign=\"top\">Edge</td><td valign=\"top\">Indicates rising edge of boolean signal</td></tr>
  <tr><td valign=\"top\">BooleanChange</td><td valign=\"top\">Indicates boolean signal changing</td></tr>
  <tr><td valign=\"top\">IntegerChange</td><td valign=\"top\">Indicates integer signal changing</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Blocks.Sources.</b></td></tr>
  <tr><td valign=\"top\">IntegerConstant</td><td valign=\"top\">Generate constant signals of type Integer</td></tr>
  <tr><td valign=\"top\">IntegerStep</td><td valign=\"top\">Generate step signals of type Integer</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Basic.</b></td></tr>
  <tr><td valign=\"top\">HeatingResistor</td><td valign=\"top\">Temperature dependent electrical resistor</td></tr>
  <tr><td valign=\"top\">OpAmp</td><td valign=\"top\">Simple nonideal model of an OpAmp with limitation</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Ideal.</b></td></tr>
  <tr><td valign=\"top\">IdealCommutingSwitch</td><td valign=\"top\">Ideal commuting switch</td></tr>
  <tr><td valign=\"top\">IdealIntermediateSwitch</td><td valign=\"top\">Ideal intermediate switch</td></tr>
  <tr><td valign=\"top\">ControlledIdealCommutingSwitch</td><td valign=\"top\">Controlled ideal commuting switch</td></tr>
  <tr><td valign=\"top\">ControlledIdealIntermediateSwitch</td><td valign=\"top\">Controlled ideal intermediate switch</td></tr>
  <tr><td valign=\"top\">IdealOpAmpLimited</td><td valign=\"top\">Ideal operational amplifier with limitation</td></tr>
  <tr><td valign=\"top\">IdealOpeningSwitch</td><td valign=\"top\">Ideal opener</td></tr>
  <tr><td valign=\"top\">IdealClosingSwitch</td><td valign=\"top\">Ideal closer</td></tr>
  <tr><td valign=\"top\">ControlledIdealOpeningSwitch</td><td valign=\"top\">Controlled ideal opener</td></tr>
  <tr><td valign=\"top\">ControlledIdealClosingSwitch</td><td valign=\"top\">Controlled ideal closer</td></tr>
  
  <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Lines.</b></td></tr>
  <tr><td valign=\"top\">TLine1</td><td valign=\"top\">Lossless transmission line (Z0, TD)</td></tr>
  <tr><td valign=\"top\">TLine2</td><td valign=\"top\">Lossless transmission line (Z0, F, NL)</td></tr>
  <tr><td valign=\"top\">TLine2</td><td valign=\"top\">Lossless transmission line (Z0, F)</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Icons.</b></td></tr>
  <tr><td valign=\"top\">Function</td><td valign=\"top\">Icon for a function</td></tr>
  <tr><td valign=\"top\">Record</td><td valign=\"top\">Icon for a record</td></tr>
  <tr><td valign=\"top\">Enumeration</td><td valign=\"top\">Icon for an enumeration</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Math.</b></td></tr>
  <tr><td valign=\"top\">tempInterpol2</td><td valign=\"top\">temporary routine for vectorized linear interpolation (will be removed)</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
  <tr><td valign=\"top\">Examples.LossyGearDemo1</td><td valign=\"top\">Example to show that gear efficiency may lead to stuck motion</td></tr>
  <tr><td valign=\"top\">Examples.LossyGearDemo2</td><td valign=\"top\">Example to show combination of LossyGear and BearingFriction</td></tr>
  <tr><td valign=\"top\">LossyGear</td><td valign=\"top\">Gear with mesh efficiency and bearing friction (stuck/rolling possible)</td></tr>
  <tr><td valign=\"top\">Gear2</td><td valign=\"top\">Realistic model of a gearbox (based on LossyGear)</td></tr>
  <tr><td colspan=\"2\"><b>Modelica.SIunits.</b></td></tr>
  <tr><td valign=\"top\"><b><i>Conversions</i></b></td><td valign=\"top\">Conversion functions to/from non SI units and type definitions of non SI units</td></tr>
  <tr><td valign=\"top\">EnergyFlowRate</td><td valign=\"top\">Same definition as <i>Power</i></td></tr>
  <tr><td valign=\"top\">EnthalpyFlowRate</td><td valign=\"top\"><tt>Real (final quantity=\"EnthalpyFlowRate\", final unit=\"W\")</tt></td></tr>
  <tr><td colspan=\"2\"><b>Modelica.</b></td></tr>
  <tr><td valign=\"top\"><b><i>Thermal.HeatTransfer</i></b></td><td valign=\"top\">1-dimensional heat transfer with lumped elements</td></tr>
  <tr><td colspan=\"2\"><b>ModelicaAdditions.Blocks.Discrete.</b></td></tr>
  <tr><td valign=\"top\">TriggeredSampler</td><td valign=\"top\">Triggered sampling of continuous signals</td></tr>
  <tr><td valign=\"top\">TriggeredMax</td><td valign=\"top\">Compute maximum, absolute value of continuous signal at trigger instants</td></tr>
  <tr><td colspan=\"2\"><b>ModelicaAdditions.Blocks.Logical.Interfaces.</b></td></tr>
  <tr><td valign=\"top\">BooleanMIRealMOs</td><td valign=\"top\">Multiple Boolean Input Multiple Real Output continuous control block with same number of inputs and outputs</td></tr>
  <tr><td valign=\"top\">RealMIBooleanMOs</td><td valign=\"top\">Multiple Real Input Multiple Boolean Output continuous control block with same number of inputs and outputs</td></tr>
  <tr><td colspan=\"2\"><b>ModelicaAdditions.Blocks.Logical.</b></td></tr>
  <tr><td valign=\"top\">TriggeredTrapezoid</td><td valign=\"top\">Triggered trapezoid generator</td></tr>
  <tr><td valign=\"top\">Hysteresis</td><td valign=\"top\">Transform Real to Boolean with Hysteresis</td></tr>
  <tr><td valign=\"top\">OnOffController</td><td valign=\"top\">On-off controller</td></tr>
  <tr><td valign=\"top\">Compare</td><td valign=\"top\">True, if signal of inPort1 is larger than signal of inPort2</td></tr>
  <tr><td valign=\"top\">ZeroCrossing</td><td valign=\"top\">Trigger zero crossing of input signal</td></tr>
  <tr><td colspan=\"2\"><b>ModelicaAdditions.</b></td></tr>
  <tr><td valign=\"top\">Blocks.Multiplexer.Extractor</td><td valign=\"top\">Extract scalar signal out of signal vector dependent on IntegerRealInput index</td></tr>
  <tr><td valign=\"top\">Tables.CombiTable1Ds</td><td valign=\"top\">Table look-up in one dimension (matrix/file) with only single input</td></tr>
</table>
<p>
<b>Package-specific Changes</b>
</p>
<ul>
  <li>All example models made <b>encapsulated</b></li>
  <li>Upper case constants changed to lower case (cf. Modelica.Constants)</li>
  <li>Introduced Modelica.SIunits.Wavelength due to typo \"Wavelenght\"</li>
  <li>Introduced ModelicaAdditions.Blocks.Logical.Interfaces.Comparison due to typo \"Comparision\"</li>
  <li>Changed these components of *.Blocks to <tt>block</tt> class, which have not been already of block type</li>
  <li>Changed *.Interfaces.RelativeSensor to <tt>partial</tt> models</li>
</ul>
<p>
<b>Class-specific Changes</b>
</p>
<p>
<i>Modelica.SIunits</i>
</p>
<p>Removed <tt>final</tt> from quantity attribute for <i>Mass</i> and <i>MassFlowRate</i>.</p>
<p>
<i>Modelica.Blocks.Math.Sum</i>
</p>
<p>Implemented avoiding algorithm section, which would lead to expensive function calls.</p>
<p><i>Modelica.Blocks.Sources.Step</i></p>
<pre>
  block Step \"Generate step signals of type Real\"
    parameter Real height[:]={1} \"Heights of steps\";
<b> // parameter Real offset[:]={0} \"Offsets of output signals\";
 // parameter SIunits.Time startTime[:]={0} \"Output = offset for time < startTime\";
 // extends Interfaces.MO          (final nout=max([size(height, 1); size(offset, 1); size(startTime, 1)]));
    extends Interfaces.SignalSource(final nout=max([size(height, 1); size(offset, 1); size(startTime, 1)]));</b>
</pre>
<p><i>Modelica.Blocks.Sources.Exponentials</i></p>
<p>Replaced usage of built-in function <tt>exp</tt> by Modelica.Math.exp.</p>
<p><i>Modelica.Blocks.Sources.TimeTable</i></p>
<p>Interface definition changed from</p>
<pre>    parameter Real table[:, :]=[0, 0; 1, 1; 2, 4] \"Table matrix (time = first column)\";
</pre>
<p>to</p>
<pre>    parameter Real table[:, <b>2</b>]=[0, 0; 1, 1; 2, 4] \"Table matrix (time = first column)\";
</pre>
<p>Did the same for subfunction <i>getInterpolationCoefficients</i>.</p>
<p>Bug in <i>getInterpolationCoefficients</i> for startTime <> 0 fixed:</p>
<pre>        ...
        end if;
      end if;
      <b>// Take into account startTime \"a*(time - startTime) + b\"
      b := b - a*startTime;</b>
    end getInterpolationCoefficients;
</pre>
<p><i>Modelica.Blocks.Sources.BooleanStep</i></p>
<pre>
  block BooleanStep \"Generate step signals of type Boolean\"
    parameter SIunits.Time startTime[:]={0} \"Time instants of steps\";
    <b>parameter Boolean startValue[size(startTime, 1)]=fill(false, size(startTime, 1)) \"Output before startTime\";</b>
    extends Interfaces.BooleanSignalSource(final nout=size(startTime, 1));
  equation
    for i in 1:nout loop
 <b>//   outPort.signal[i] = time >= startTime[i];
      outPort.signal[i] = if time >= startTime[i] then not startValue[i] else startValue[i];</b>
    end for;
  end BooleanStep;
</pre>
<p>
<i>Modelica.Electrical.Analog</i></p>
<p>Corrected table of values and default for Beta by dividing them by 1000
(consistent with the values used in the NAND-example model):
</p>
<ul>
<li>Semiconductors.PMOS</li>
<li>Semiconductors.NMOS</li>
</ul>
<p>Corrected parameter defaults, unit and description for TrapezoidCurrent.
This makes the parameters consistent with their use in the model.
Models specifying parameter values are not changed.
Models not specifying parameter values did not generate trapezoids previously.
</p>
<p>Icon layer background changed from transparent to white:</p>
<ul>
  <li>Basic.Gyrator</li>
  <li>Basic.EMF</li>
  <li>Ideal.Idle</li>
  <li>Ideal.Short</li>
</ul>
<p>Basic.Transformer: Replaced invalid escape characters '\\ ' and '\\[newline]' in documentation by '|'.</p>
<p><i>Modelica.Mechanics.Rotational</i></p>
<p>Removed arrows and names documentation from flanges in diagram layer</p>
<p><i>Modelica.Mechanics.Rotational.Interfaces.FrictionBase</i></p>
<p><i>Modelica.Mechanics.Rotational.Position</i></p>
<p>Replaced <tt>reinit</tt> by <tt>initial equation</tt></p>
<p><i>Modelica.Mechanics.Rotational.RelativeStates</i></p>
<p>Bug corrected by using modifier <tt>stateSelect = StateSelect.prefer</tt> as implementation</p>
<p><i>Modelica.Mechanics.Translational.Interfaces.flange_b</i></p>
<p>Attribute <b>fillColor=7</b> added to Rectangle on Icon layer, i.e. it is now
filled with white and not transparent any more.</p>
<p><i>Modelica.Mechanics.Translational.Position</i></p>
<p>Replaced <tt>reinit</tt> by <tt>initial equation</tt></p>
<p><i>Modelica.Mechanics.Translational.RelativeStates</i></p>
<p>Bug corrected by using modifier <tt>stateSelect = StateSelect.prefer</tt> as implementation</p>
<p><i>Modelica.Mechanics.Translational.Stop</i></p>
<p>Use <tt>stateSelect = StateSelect.prefer</tt>.</p>
<p><i>Modelica.Mechanics.Translational.Examples.PreLoad</i></p>
<p>Improved documentation and coordinate system used for example.</p>
<p><i>ModelicaAdditions.Blocks.Nonlinear.PadeDelay</i></p>
<p>Replaced <tt>reinit</tt> by <tt>initial equation</tt></p>
<p><i>ModelicaAdditions.HeatFlow1D.Interfaces</i></p>
<p>Definition of connectors <i>Surface_a</i> and <i>Surface_b</i>:<br>
<tt>flow SIunits.HeatFlux q;</tt> changed to <tt>flow SIunits.HeatFlowRate q;</tt></p>
<p><i>MultiBody.Parts.InertialSystem</i></p>
<p>Icon corrected.</p>
</html>
"));
  end Version_1_5;

  class Version_1_4 "Version 1.4 (June 28, 2001)"

  annotation (Documentation(info="<html>

<ul>
<li>Several minor bugs fixed. </li>
<li>New models:<br>
    Modelica.Blocks.Interfaces.IntegerRealInput/IntegerRealOutput,<br>
    Modelica.Blocks.Math.TwoInputs/TwoOutputs<br>
    Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin,<br>
    Modelica.Mechanics.Rotational.Move,<br>
    Modelica.Mechanics.Translational.Move.<br>
    </li>
</ul>
<hr>
<h4>Version 1.4.1beta1 (February 12, 2001)</h4>
<p> Adapted to Modelica 1.4</p>
<hr>
<h4>Version 1.3.2beta2 (June 20, 2000)</h4>
<ul>
    <li>New subpackage Modelica.Mechanics.<b>Translational</b></li>
    <li>Changes to Modelica.Mechanics.<b>Rotational</b>:<br>
       New elements:
<pre>
   IdealGearR2T    Ideal gear transforming rotational in translational motion.
   Position        Forced movement of a flange with a reference angle
                   given as input signal
   RelativeStates  Definition of relative state variables
</pre>
</li>
    <li>Changes to Modelica.<b>SIunits</b>:<br>
      Introduced new types:<br>
      type Temperature = ThermodynamicTemperature;<br>
      types DerDensityByEnthalpy, DerDensityByPressure,
      DerDensityByTemperature, DerEnthalpyByPressure,
      DerEnergyByDensity, DerEnergyByPressure<br>
      Attribute \"final\" removed from min and max values
      in order that these values can still be changed to narrow
      the allowed range of values.<br>
      Quantity=\"Stress\" removed from type \"Stress\", in order
      that a type \"Stress\" can be connected to a type \"Pressure\".</li>
    <li>Changes to Modelica.<b>Icons</b>:<br>
       New icons for motors and gearboxes.</li>
    <li>Changes to Modelica.<b>Blocks.Interfaces</b>:<br>
       Introduced a replaceable signal type into
       Blocks.Interfaces.RealInput/RealOutput:
<pre>
   replaceable type SignalType = Real
</pre>
       in order that the type of the signal of an input/output block
       can be changed to a physical type, for example:
<pre>
   Sine sin1(outPort(redeclare type SignalType=Modelica.SIunits.Torque))
</pre>
</li>
</ul>
<hr>
<h4>Version 1.3.1 (Dec. 13, 1999)</h4>
<p>
First official release of the library.
</p>
</html>
"));
  end Version_1_4;
  end ReleaseNotes;

  class ModelicaLicense "Modelica License (Version 1.1 of June 30, 2000)"

    annotation (Documentation(info="<html>

<p>Redistribution and use in source and binary forms, with or without
modification are permitted, provided that the following conditions are met:
<ol>
<li>
The author and copyright notices in the source files, these license conditions
and the disclaimer below are (a) retained and (b) reproduced in the documentation
provided with the distribution.</li>
<li>
Modifications of the original source files are allowed, provided that a
prominent notice is inserted in each changed file and the accompanying
documentation, stating how and when the file was modified, and provided
that the conditions under (1) are met.</li>
<li>
It is not allowed to charge a fee for the original version or a modified
version of the software, besides a reasonable fee for distribution and support.
Distribution in aggregate with other (possibly commercial) programs
as part of a larger (possibly commercial) software distribution is permitted,
provided that it is not advertised as a product of your own.</li>
</ol>

<h4>Disclaimer</h4>
<p>The software (sources, binaries, etc.) in their original or in a modified
form are provided
\"as is\" and the copyright holders assume no responsibility for its contents
what so ever. Any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are <b>disclaimed</b>. <b>In no event</b> shall the
copyright holders, or any party who modify and/or redistribute the package,
<b>be liable</b> for any direct, indirect, incidental, special, exemplary, or
consequential damages, arising in any way out of the use of this software,
even if advised of the possibility of such damage.
</p>
</html>
"));

  end ModelicaLicense;

  class Contact "Contact"

    annotation (Documentation(info="<html>

<dl>
<dt>The development of the Modelica package is organized by<br>&nbsp;</dt>
<dd><a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
    Deutsches Zentrum f&uuml;r Luft und Raumfahrt e.V. (DLR)<br>
    Institut f&uuml;r Robotik und Mechatronik<br> 
    Abteilung f&uuml;r Systemdynamik und Regelungstechnik<br>
    Postfach 1116<br>
    D-82230 Wessling<br>
    Germany<br>
    email: <A HREF=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</A><br></dd>
</dl>

<p>
Since end of 2007, the development of the sublibraries of package Modelica
is organized by personal and/or organizational <b>library officers</b> assigned by the
Modelica Association. They are responsible for the maintenance and
for the further organization of the development. Other persons may
also contribute, but the final decision for library improvements and/or changes
is performed by the responsible library officer(s). In order that a new
sublibrary or a new version of a sublibrary is ready to be released,
the responsible library officers report the changes to the members of
the Modelica Association and the library is made available for beta testing to
interested parties before a final decision. A new release of a sublibrary
is formally decided by voting of the Modelica Association members.
</p>

<p>
The following library officers are currently assigned:
</p>

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>Sublibrary</b> </td
      <td valign=\"top\"><b>Library officers</td>
  </tr>

  <tr><td valign=\"top\"> Blocks <br> Constants </td>
      <td valign=\"top\"> DLR Institute of Robotics and Mechatronics, Oberpfaffenhofen, Germany<br>
                       (Martin Otter)</td>
  </tr>

  <tr><td valign=\"top\"> Electrical.Analog, <br> Electrical.Digital </td>
      <td valign=\"top\"> Fraunhofer Institute for Integrated Circuits, Dresden, Germany<br>
                        (Christoph Clauss)</td>
  </tr>

  <tr><td valign=\"top\"> Electrical.Machines<br>
                        Electrical.MultiPhase </td>
      <td valign=\"top\"> Anton Haumer, Consultant, St.Andrae-Woerdern, Austria, and<br>
                        arsenal research, Vienna, Austria (Christian Kral)</td>
  </tr>

  <tr><td valign=\"top\"> Icons </td>
      <td valign=\"top\"> Modelon AB, Lund, Sweden (Johan Andreasson) </td>
  </tr>

  <tr><td valign=\"top\"> Math </td>
      <td valign=\"top\"> DLR Institute of Robotics and Mechatronics, Oberpfaffenhofen, Germany<br>
                        (Martin Otter)</td>
  </tr>

  <tr><td valign=\"top\"> Mechanics.MultiBody </td>
      <td valign=\"top\"> DLR Institute of Robotics and Mechatronics, Oberpfaffenhofen, Germany<br>
                        (Martin Otter),<br>
                         Modelon AB, Lund, Sweden (Johan Andreasson) </td>
  </tr>

  <tr><td valign=\"top\"> Mechanics.Rotational </td>
      <td valign=\"top\"> DLR Institute of Robotics and Mechatronics, Oberpfaffenhofen, Germany<br>
                        (Martin Otter)<br>
                        Anton Haumer, Consultant, St.Andrae-Woerdern, Austria,<br>
                        arsenal research, Vienna, Austria (Christian Kral),<br>
                        Modelon AB, Lund, Sweden (Johan Andreasson)</td>
  </tr>

  <tr><td valign=\"top\"> Mechanics.Translational </td>
      <td valign=\"top\"> Anton Haumer, Consultant, St.Andrae-Woerdern, Austria,<br>
                        arsenal research, Vienna, Austria (Christian Kral), <br>
                        DLR Institute of Robotics and Mechatronics, Oberpfaffenhofen, Germany<br>
                        (Martin Otter)<br>
                         Modelon AB, Lund, Sweden (Johan Andreasson)</td>
  </tr>


  <tr><td valign=\"top\"> Media </td>
      <td valign=\"top\"> Modelon AB, Lund, Sweden (Hubertus Tummescheit) </td>
  </tr>

  <tr><td valign=\"top\"> SIunits <br>
                        StateGraph </td>
      <td valign=\"top\"> DLR Institute of Robotics and Mechatronics, Oberpfaffenhofen, Germany<br>
                        (Martin Otter)</td>
  </tr>

  <tr><td valign=\"top\"> Thermal.FluidHeatFlow <br>
                        Thermal.HeatTransfer </td>
      <td valign=\"top\"> Anton Haumer, Consultant, St.Andrae-Woerdern, Austria, and<br>
                        arsenal research, Vienna, Austria (Christian Kral)</td>

  <tr><td valign=\"top\"> Utilities </td>
      <td valign=\"top\"> DLR Institute of Robotics and Mechatronics, Oberpfaffenhofen, Germany<br>
                        (Martin Otter)<br>
                        Dynasim AB, Lund, Sweden (Hans Olsson)</td>
  </tr>
</table>


<p>
The following people have directly contributed to the implementation
of the Modelica package (many more people have contributed to the design):
</p>

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>Peter Beater</b> </td
      <td valign=\"top\"> University of Paderborn, Germany</td>
      <td valign=\"top\"> Modelica.Mechanics.Translational </td>
  </tr>
  <tr><td valign=\"top\"><b>Dag Br&uuml;ck</b> </td
      <td valign=\"top\"> Dynasim AB, Lund, Sweden</td>
      <td valign=\"top\"> Modelica.Utilities</td>
  </tr>

  <tr><td valign=\"top\"><b>Francesco Casella</b> </td
      <td valign=\"top\"> Politecnico di Milano, Milano, Italy</td>
      <td valign=\"top\"> Modelica.Media</td>
  </tr>

  <tr><td valign=\"top\"><b>Christoph Clauss</b> </td
      <td valign=\"top\"> Fraunhofer Institute for Integrated Circuits,<br> Dresden, Germany</td>
      <td valign=\"top\"> Modelica.Electrical.Analog<br> 
           Modelica.Electrical.Digital</td>
  </tr>

  <tr><td valign=\"top\"><b>Jonas Eborn</b> </td
      <td valign=\"top\"> Modelon AB, Lund, Sweden</td>
      <td valign=\"top\"> Modelica.Media</td>
  </tr>

  <tr><td valign=\"top\"><b>Hilding Elmqvist</b> </td
      <td valign=\"top\"> Dynasim AB, Lund, Sweden</td>
      <td valign=\"top\"> Modelica.Mechanics.MultiBody<br>
           Modelica.Media<br>
           Modelica.StateGraph<br>
           Modelica.Utilities<br>
           Conversion from 1.6 to 2.0</td>
  </tr>

  <tr><td valign=\"top\"><b>R&uuml;diger Franke</b> </td
      <td valign=\"top\"> ABB Corporate Research,<br>Ladenburg, German</td>
      <td valign=\"top\"> Modelica.Media</td>
  </tr>

  <tr><td valign=\"top\"><b>Anton Haumer</b> </td
      <td valign=\"top\"> Consultant, St.Andrae-Woerdern,<br>Austria</td>
      <td valign=\"top\"> Modelica.Electrical.Machines<br>
           Modelica.Electrical.Multiphase<br>
           Modelica.Mechanics.Rotational<br>
           Modelica.Mechanics.Translational<br>
           Modelica.Thermal.FluidHeatFlow<br>
           Modelica.Thermal.HeatTransfer<br>
           Conversion from 1.6 to 2.0<br>
           Conversion from 2.2 to 3.0</td>
  </tr>

  <tr><td valign=\"top\"><b>Hans-Dieter Joos</b> </td
      <td valign=\"top\"> Institute of Robotics and Mechatronics<br>
           DLR, German Aerospace Center, <br>
           Oberpfaffenhofen, Germany</td>
      <td valign=\"top\"> Modelica.Math.Matrices</td>
  </tr>

  <tr><td valign=\"top\"><b>Christian Kral</b> </td
      <td valign=\"top\"> arsenal research, Vienna, Austria</td>
      <td valign=\"top\"> Modelica.Electrical.Machines<br>
           Modelica.Thermal.FluidHeatFlow</td>
  </tr>

  <tr><td valign=\"top\"><b>Sven Erik Mattsson</b> </td
      <td valign=\"top\"> Dynasim AB, Lund, Sweden</td>
      <td valign=\"top\"> Modelica.Mechanics.MultiBody</td>
  </tr>
  <tr><td valign=\"top\"><b>Hans Olsson</b> </td
      <td valign=\"top\"> Dynasim AB, Lund, Sweden</td>
      <td valign=\"top\"> Modelica.Blocks<br>
           Modelica.Math.Matrices<br>
           Modelica.Utilities<br>
           Conversion from 1.6 to 2.0<br>
           Conversion from 2.2 to 3.0</td>
  </tr>
  <tr><td valign=\"top\"><b>Martin Otter</b> </td
      <td valign=\"top\"> Institute of Robotics and Mechatronics<br>
           DLR, German Aerospace Center, <br>
           Oberpfaffenhofen, Germany</td>
      <td valign=\"top\"> Modelica.Blocks<br> 
           Modelica.Mechanics.MultiBody<br>
           Modelica.Mechanics.Rotational<br>
           Modelica.Mechanics.Translational<br>
           Modelica.Math<br>
           Modelica.Media<br>
           Modelica.SIunits<br>
           Modelica.StateGraph<br>
           Modelica.Thermal.HeatTransfer<br>
           Modelica.Utilities<br>
           ModelicaReference<br>
           Conversion from 1.6 to 2.0<br>
           Conversion from 2.2 to 3.0</td>
  </tr>

  <tr><td valign=\"top\"><b>Katrin Pr&ouml;l&szlig;</b> </td
      <td valign=\"top\"> Department of Technical Thermodynamics,<br>
           Technical University Hamburg-Harburg,<br>Germany</td>
      <td valign=\"top\"> Modelica.Media</td>
  </tr>

  <tr><td valign=\"top\"><b>Christoph C. Richter</b> </td
      <td valign=\"top\"> Institut f&uuml;r Thermodynamik, <br>
           Technische Universit&auml;t Braunschweig, <br>
           Germany</td>
      <td valign=\"top\"> Modelica.Media</td>
  </tr>

  <tr><td valign=\"top\"><b>Andr&eacute; Schneider</b> </td
      <td valign=\"top\"> Fraunhofer Institute for Integrated Circuits,<br> Dresden, Germany</td>
      <td valign=\"top\"> Modelica.Electrical.Analog<br> 
           Modelica.Electrical.Digital</td>
  </tr>
  <tr><td valign=\"top\"><b>Christian Schweiger</b> </td
      <td valign=\"top\"> Until 2006:<br>
           Institute of Robotics and Mechatronics,<br>
           DLR, German Aerospace Center,<br> 
           Oberpfaffenhofen, Germany</td>
      <td valign=\"top\"> Modelica.Mechanics.Rotational<br>
           ModelicaReference<br>
           Conversion from 1.6 to 2.0</td>
  </tr>
  <tr><td valign=\"top\"><b>Michael Tiller</b> </td
      <td valign=\"top\"> Emmeskay, Inc., Dearborn, MI, U.S.A, <br>
           (previously Ford Motor Company, Dearborn) </td>
      <td valign=\"top\"> Modelica.Media<br>
           Modelica.Thermal.HeatTransfer</td>
  </tr>
  <tr><td valign=\"top\"><b>Hubertus Tummescheit</b> </td
      <td valign=\"top\"> Modelon AB, Lund, Sweden </td>
      <td valign=\"top\"> Modelica.Media<br>
           Modelica.Thermal.HeatTransfer</td>
  </tr>
  <tr><td valign=\"top\"><b>Nico Walter</b> </td
      <td valign=\"top\"> Master thesis at HTWK Leipzig<br>
           (Prof. R. M&uuml;ller) and<br>
           DLR Oberpfaffenhofen, Germany</td>
      <td valign=\"top\"> Modelica.Math.Matrices</td>
  </tr>
</table>
</html>
"));

  end Contact;

end UsersGuide;

  package Blocks
    "Library of basic input/output control blocks (continuous, discrete, logical, table blocks)"
    import SI = Modelica.SIunits;

  extends Modelica.Icons.Library2;

  annotation (
    Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
              100}}), graphics={
          Rectangle(extent={{-32,-6},{16,-35}}, lineColor={0,0,0}),
          Rectangle(extent={{-32,-56},{16,-85}}, lineColor={0,0,0}),
          Line(points={{16,-20},{49,-20},{49,-71},{16,-71}}, color={0,0,0}),
          Line(points={{-32,-72},{-64,-72},{-64,-21},{-32,-21}}, color={0,0,0}), 

          Polygon(
            points={{16,-71},{29,-67},{29,-74},{16,-71}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid),
          Polygon(
            points={{-32,-21},{-46,-17},{-46,-25},{-32,-21}},
            lineColor={0,0,0},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid)}),
                            Documentation(info="<html>
<p>
This library contains input/output blocks to build up block diagrams.
</p>

<dl>
<dt><b>Main Author:</b>
<dd><a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
    Deutsches Zentrum f&uuml;r Luft und Raumfahrt e. V. (DLR)<br>
    Oberpfaffenhofen<br>
    Postfach 1116<br>
    D-82230 Wessling<br>
    email: <A HREF=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</A><br>
</dl>
<p>
Copyright &copy; 1998-2008, Modelica Association and DLR.
</p>
<p>
<i>This Modelica package is <b>free</b> software; it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b>
<a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
</p>
</HTML>
",   revisions="<html>
<ul>
<li><i>June 23, 2004</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Introduced new block connectors and adapated all blocks to the new connectors.
       Included subpackages Continuous, Discrete, Logical, Nonlinear from
       package ModelicaAdditions.Blocks.
       Included subpackage ModelicaAdditions.Table in Modelica.Blocks.Sources
       and in the new package Modelica.Blocks.Tables.
       Added new blocks to Blocks.Sources and Blocks.Logical.
       </li>
<li><i>October 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
       and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       New subpackage Examples, additional components.
       </li>
<li><i>June 20, 2000</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a> and
       Michael Tiller:<br>
       Introduced a replaceable signal type into
       Blocks.Interfaces.RealInput/RealOutput:
<pre>
   replaceable type SignalType = Real
</pre>
       in order that the type of the signal of an input/output block
       can be changed to a physical type, for example:
<pre>
   Sine sin1(outPort(redeclare type SignalType=Modelica.SIunits.Torque))
</pre>
      </li>
<li><i>Sept. 18, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Renamed to Blocks. New subpackages Math, Nonlinear.
       Additional components in subpackages Interfaces, Continuous
       and Sources. </li>
<li><i>June 30, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized a first version, based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist.</li>
</ul>
</html>"));

  package Examples
      "Library of examples to demonstrate the usage of package Blocks"

    extends Icons.Library;

    model PID_Controller
        "Demonstrates the usage of a Continuous.LimPID controller"
      extends Modelica.Icons.Example;
      parameter Modelica.SIunits.Angle driveAngle=1.57
          "Reference distance to move";
      Modelica.Blocks.Continuous.LimPID PI(
        k=100,
        Ti=0.1,
        yMax=12,
        Ni=0.1,
        initType=Modelica.Blocks.Types.Init.SteadyState,
        limitsAtInit=false,
        controllerType=Modelica.Blocks.Types.SimpleController.PI) 
        annotation (Placement(transformation(extent={{-56,-20},{-36,0}}, rotation=
               0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia1(
                                                     a(fixed=true), phi(fixed=
              true, start=0))                   annotation (Placement(
            transformation(extent={{2,-20},{22,0}}, rotation=0)));
      annotation (
        Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={
            Rectangle(extent={{-99,48},{-32,8}}, lineColor={255,0,0}),
            Text(
              extent={{-98,59},{-31,51}},
              lineColor={255,0,0},
              textString="reference speed generation"),
            Text(
              extent={{-98,-46},{-60,-52}},
              lineColor={255,0,0},
              textString="PI controller"),
            Line(
              points={{-76,-44},{-57,-23}},
              color={255,0,0},
              arrow={Arrow.None,Arrow.Filled}),
            Rectangle(extent={{-25,6},{99,-50}}, lineColor={255,0,0}),
            Text(
              extent={{4,14},{71,7}},
              lineColor={255,0,0},
              textString="plant (simple drive train)")}),
        experiment(StopTime=4),
        Documentation(info="<html>

<p>
This is a simple drive train controlled by a PID controller:
</p>

<ul>
<li> The two blocks \"kinematic_PTP\" and \"integrator\" are used to generate
     the reference speed (= constant acceleration phase, constant speed phase,
     constant deceleration phase until inertia is at rest). To check
     whether the system starts in steady state, the reference speed is
     zero until time = 0.5 s and then follows the sketched trajectory.</li>

<li> The block \"PI\" is an instance of \"Blocks.Continuous.LimPID\" which is
     a PID controller where several practical important aspects, such as
     anti-windup-compensation has been added. In this case, the control block
     is used as PI controller.</li>

<li> The output of the controller is a torque that drives a motor inertia
     \"inertia1\". Via a compliant spring/damper component, the load
     inertia \"inertia2\" is attached. A constant external torque of 10 Nm
     is acting on the load inertia.</li>
</ul>

<p>
The PI controller settings included \"limitAtInit=false\", in order that
the controller output limits of 12 Nm are removed from the initialization
problem.
</p>

<p>
The PI controller is initialized in steady state (initType=SteadyState)
and the drive shall also be initialized in steady state.
However, it is not possible to initialize \"inertia1\" in SteadyState, because
\"der(inertia1.phi)=inertia1.w=0\" is an input to the PI controller that
defines that the derivative of the integrator state is zero (= the same
condition that was already defined by option SteadyState of the PI controller).
Furthermore, one initial condition is missing, because the absolute position
of inertia1 or inertia2 is not defined. The solution shown in this examples is
to initialize the angle and the angular acceleration of \"inertia1\".
</p>

<p>
In the following figure, results of a typical simulation are shown:
</p>

<p>
<img src=\"../Images/Blocks/PID_controller.png\"><br>
<img src=\"../Images/Blocks/PID_controller2.png\">
</p>

<p>
In the upper figure the reference speed (= integrator.y) and
the actual speed (= inertia1.w) are shown. As can be seen,
the system initializes in steady state, since no transients
are present. The inertia follows the reference speed quite good
until the end of the constant speed phase. Then there is a deviation.
In the lower figure the reason can be seen: The output of the
controller (PI.y) is in its limits. The anti-windup compensation
works reasonably, since the input to the limiter (PI.limiter.u)
is forced back to its limit after a transient phase.
</p>

</html>"));

      Modelica.Mechanics.Rotational.Sources.Torque torque 
        annotation (Placement(transformation(extent={{-25,-20},{-5,0}}, rotation=
                0)));
      Modelica.Mechanics.Rotational.Components.SpringDamper spring(
                                                        c=1e4, d=100,
        stateSelect=StateSelect.prefer,
        w_rel(fixed=true)) 
        annotation (Placement(transformation(extent={{32,-20},{52,0}}, rotation=0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia2(
                                                     J=2) 
        annotation (Placement(transformation(extent={{60,-20},{80,0}}, rotation=0)));
      Modelica.Blocks.Sources.KinematicPTP kinematicPTP(startTime=0.5, deltaq={
            driveAngle},
        qd_max={1},
        qdd_max={1})     annotation (Placement(transformation(extent={{-92,20},{
                -72,40}}, rotation=0)));
      Modelica.Blocks.Continuous.Integrator integrator(initType=Modelica.Blocks.
            Types.Init.InitialState) annotation (Placement(transformation(extent=
                {{-63,20},{-43,40}}, rotation=0)));
      Modelica.Mechanics.Rotational.Sensors.SpeedSensor speedSensor 
        annotation (Placement(transformation(extent={{22,-50},{2,-30}}, rotation=
                0)));
      Modelica.Mechanics.Rotational.Sources.ConstantTorque loadTorque(
                                                              tau_constant=10,
          useSupport=false) 
        annotation (Placement(transformation(extent={{98,-15},{88,-5}}, rotation=
                0)));
    initial equation
      der(spring.w_rel) = 0;
    equation
      connect(spring.flange_b,inertia2. flange_a) 
        annotation (Line(points={{52,-10},{60,-10}}, color={0,0,0}));
      connect(inertia1.flange_b, spring.flange_a) 
        annotation (Line(points={{22,-10},{32,-10}}, color={0,0,0}));
      connect(torque.flange, inertia1.flange_a) 
        annotation (Line(points={{-5,-10},{2,-10}}, color={0,0,0}));
      connect(kinematicPTP.y[1], integrator.u) annotation (Line(points={{-71,30},
              {-65,30}}, color={0,0,127}));
      connect(speedSensor.flange, inertia1.flange_b) 
        annotation (Line(points={{22,-40},{22,-10}}, color={0,0,0}));
      connect(loadTorque.flange, inertia2.flange_b) 
        annotation (Line(points={{88,-10},{80,-10}}, color={0,0,0}));
      connect(PI.y, torque.tau)  annotation (Line(points={{-35,-10},{-27,-10}},
            color={0,0,127}));
      connect(speedSensor.w, PI.u_m)  annotation (Line(points={{1,-40},{-46,-40},
              {-46,-22}}, color={0,0,127}));
      connect(integrator.y, PI.u_s)  annotation (Line(points={{-42,30},{-37,30},{
              -37,11},{-67,11},{-67,-10},{-58,-10}}, color={0,0,127}));
    end PID_Controller;

    model InverseModel "Demonstrates the construction of an inverse model"
      extends Modelica.Icons.Example;

      Continuous.FirstOrder firstOrder1(
        k=1,
        T=0.3,
        initType=Modelica.Blocks.Types.Init.SteadyState) 
        annotation (Placement(transformation(extent={{20,20},{0,40}})));
      Sources.Sine sine(
        freqHz=2,
        offset=1,
        startTime=0.2) 
        annotation (Placement(transformation(extent={{-80,20},{-60,40}})));
      annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{
                -100,-100},{100,100}}), graphics), Documentation(info="<html>
<p>
This example demonstrates how to construct an inverse model in Modelica
(for more details see <a href=\"http://www.modelica.org/events/Conference2005/online_proceedings/Session3/Session3c3.pdf\">Looye, Th&uuml;mmel, Kurze, Otter, Bals: Nonlinear Inverse Models for Control</a>).
</p>

<p>
For a linear, single input, single output system
</p>

<pre>
   y = n(s)/d(s) * u   // plant model
</pre>

<p>
the inverse model is derived by simply exchanging the numerator and
the denominator polynomial:
</p>

<pre>
   u = d(s)/n(s) * y   // inverse plant model
</pre>

<p>
If the denominator polynomial d(s) has a higher degree as the
numerator polynomial n(s) (which is usually the case for plant models),
then the inverse model is no longer proper, i.e., it is not causal.
To avoid this, an approximate inverse model is constructed by adding
a sufficient number of poles to the denominator of the inverse model.
This can be interpreted as filtering the desired output signal y:
</p>

<pre>
   u = d(s)/(n(s)*f(s)) * y  // inverse plant model with filtered y
</pre>

<p>
With Modelica it is in principal possible to construct inverse models not only
for linear but also for non-linear models and in particular for every
Modelica model. The basic construction mechanism is explained at hand
of this example:
</p>

<p>
<img src=\"../Images/Blocks/InverseModelSchematic.png\">
</p>

<p>
Here the first order block \"firstOrder1\" shall be inverted. This is performed
by connecting its inputs and outputs with an instance of block
Modelica.Blocks.Math.<b>InverseBlockConstraints</b>. By this connection,
the inputs and outputs are exchanged. The goal is to compute the input of the
\"firstOrder1\" block so that its output follows a given sine signal.
For this, the sine signal \"sin\" is first filtered with a \"CriticalDamping\"
filter of order 1 and then the output of this filter is connected to the output
of the \"firstOrder1\" block (via the InverseBlockConstraints block, since
2 outputs cannot be connected directly together in a block diagram).
</p>

<p>
In order to check the inversion, the computed input of \"firstOrder1\" is used
as input in an identical block \"firstOrder2\". The output of \"firstOrder2\" should
be the given \"sine\" function. The difference is constructed with the \"feedback\"
block. Since the \"sine\" function is filtered, one cannot expect that this difference
is zero. The higher the cut-off frequency of the filter, the closer is the
agreement. A typical simulation result is shown in the next figure:
</p>

<p>
<img src=\"../Images/Blocks/InverseModel.png\">
</p>

</html>"));
      Math.InverseBlockConstraints inverseBlockConstraints 
        annotation (Placement(transformation(extent={{-10,20},{30,40}})));
      Continuous.FirstOrder firstOrder2(
        k=1,
        T=0.3,
        initType=Modelica.Blocks.Types.Init.SteadyState) 
        annotation (Placement(transformation(extent={{20,-20},{0,0}})));
      Math.Feedback feedback 
        annotation (Placement(transformation(extent={{-40,0},{-60,-20}})));
      Continuous.CriticalDamping criticalDamping(n=1, f=50*sine.freqHz) 
        annotation (Placement(transformation(extent={{-40,20},{-20,40}})));
    equation
      connect(firstOrder1.y, inverseBlockConstraints.u2) annotation (Line(
          points={{-1,30},{-6,30}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(inverseBlockConstraints.y2, firstOrder1.u) annotation (Line(
          points={{27,30},{22,30}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(firstOrder2.y, feedback.u1) annotation (Line(
          points={{-1,-10},{-42,-10}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(sine.y, criticalDamping.u) annotation (Line(
          points={{-59,30},{-42,30}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(criticalDamping.y, inverseBlockConstraints.u1) annotation (Line(
          points={{-19,30},{-12,30}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(sine.y, feedback.u2) annotation (Line(
          points={{-59,30},{-50,30},{-50,-2}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(inverseBlockConstraints.y1, firstOrder2.u) annotation (Line(
          points={{31,30},{40,30},{40,-10},{22,-10}},
          color={0,0,127},
          smooth=Smooth.None));
    end InverseModel;

       model ShowLogicalSources
        "Demonstrates the usage of logical sources together with their diagram animation"
         extends Modelica.Icons.Example;
         Sources.BooleanTable table(table={2,4,6,8}) 
                                         annotation (Placement(transformation(
              extent={{-60,-100},{-40,-80}}, rotation=0)));
         Sources.BooleanConstant const    annotation (Placement(transformation(
              extent={{-60,60},{-40,80}}, rotation=0)));
         Sources.BooleanStep step(startTime=4) annotation (Placement(
            transformation(extent={{-60,20},{-40,40}}, rotation=0)));
         Sources.BooleanPulse pulse(period=1.5) annotation (Placement(
            transformation(extent={{-60,-20},{-40,0}}, rotation=0)));
         annotation(Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                -100},{100,100}}),
                            graphics),
        experiment(StopTime=10),
        Documentation(info="<html>
<p>
This simple example demonstrates the logical sources in
<a href=\"Modelica://Modelica.Blocks.Sources\">Modelica.Blocks.Sources</a> and demonstrate
their diagram animation (see \"small circle\" close to the output connector).
The \"booleanExpression\" source shows how a logical expression can be defined
in its parameter menu refering to variables available on this level of the
model.
</p>

</html>"));

        Sources.SampleTrigger sample(
                            period=0.5) annotation (Placement(transformation(
              extent={{-60,-60},{-40,-40}}, rotation=0)));
        Sources.BooleanExpression booleanExpression(
                                                  y=pulse.y and step.y) 
        annotation (Placement(transformation(extent={{20,20},{80,40}}, rotation=0)));
       end ShowLogicalSources;

      model LogicalNetwork1 "Demonstrates the usage of logical blocks"

      extends Modelica.Icons.Example;
      Sources.BooleanTable table2(table={1,3,5,7}) annotation (Placement(
            transformation(extent={{-80,-20},{-60,0}}, rotation=0)));
      Sources.BooleanTable table1(table={2,4,6,8}) annotation (Placement(
            transformation(extent={{-80,20},{-60,40}}, rotation=0)));
      Logical.Not Not1 annotation (Placement(transformation(extent={{-40,-20},{
                -20,0}}, rotation=0)));

      annotation(Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                -100},{100,100}}),
                         graphics),
          experiment(StopTime=10),
        Documentation(info="<html>
<p>
This example demonstrates a network of logical blocks. Note, that
the Boolean values of the input and output signals are visualized
in the diagram animation, by the small \"circles\" close to the connectors.
If a \"circle\" is \"white\", the signal is <b>false</b>. It a
\"circle\" is \"green\", the signal is <b>true</b>.
</p>
</html>"));

      Logical.And And1 annotation (Placement(transformation(extent={{0,-20},{20,0}},
              rotation=0)));
      Logical.Or Or1 annotation (Placement(transformation(extent={{40,20},{60,40}},
              rotation=0)));
      Logical.Pre Pre1 annotation (Placement(transformation(extent={{-40,-60},{
                -20,-40}}, rotation=0)));
      equation

      connect(table2.y, Not1.u) annotation (Line(points={{-59,-10},{-42,-10}},
            color={255,0,255}));
      connect(And1.y, Or1.u2) annotation (Line(points={{21,-10},{28,-10},{28,22},
              {38,22}}, color={255,0,255}));
      connect(table1.y, Or1.u1) annotation (Line(points={{-59,30},{38,30}}, color=
             {255,0,255}));
      connect(Not1.y, And1.u1) annotation (Line(points={{-19,-10},{-2,-10}},
            color={255,0,255}));
      connect(Pre1.y, And1.u2) annotation (Line(points={{-19,-50},{-10,-50},{-10,
              -18},{-2,-18}}, color={255,0,255}));
      connect(Or1.y, Pre1.u) annotation (Line(points={{61,30},{68,30},{68,-70},{
              -60,-70},{-60,-50},{-42,-50}}, color={255,0,255}));

      end LogicalNetwork1;

    annotation (Documentation(info="<html>
<p>
This package contains example models to demonstrate the
usage of package blocks.
</p>
</HTML>
"));

    model BusUsage "Demonstrates the usage of a signal bus"
      extends Modelica.Icons.Example;

      annotation (Documentation(info="<html>
<p><b>Signal bus concept</b></p>
<p>
In technical systems, such as vehicles, robots or satellites, many signals
are exchanged between components. In a simulation system, these signals
are  usually modelled by signal connections of input/output blocks.
Unfortunately, the signal connection structure may become very complicated,
especially for hierarchical models.
</p>

<p>
The same is also true for real technical systems. To reduce complexity
and get higher flexibility, many technical systems use data buses to
exchange data between components. For the same reasons, it is often better
to use a \"signal bus\" concept also in a Modelica model. This is demonstrated
at hand of this model (Modelica.Blocks.Examples.BusUsage):
</p>

<p align=\"center\">
<img src=\"../Images/Blocks/BusUsage.png\">
</p>

<ul>
<li> Connector instance \"controlBus\" is a hierarchical connector that is
     used to exchange signals between different components. It is
     defined as \"expandable connector\" in order that <b>no</b> central definition
     of the connector is needed but is automatically constructed by the
     signals connected to it (see also Modelica specification 2.2.1).</li>
<li> Input/output signals can be directly connected to the \"controlBus\".</li>
<li> A component, such as \"part\", can be directly connected to the \"controlBus\",
     provided it has also a bus connector, or the \"part\" connector is a
     sub-connector contained in the \"controlBus\". </li>
</ul>

<p>
The control and sub-control bus icons are provided within Modelica.Icons.
In <a href=\"Modelica://Modelica.Blocks.Examples.BusUsage_Utilities.Interfaces\">Modelica.Blocks.Examples.BusUsage_Utilities.Interfaces</a>
the buses for this example are defined. Both the \"ControlBus\" and the \"SubControlBus\" are
<b>expandable</b> connectors that do not define any variable. For example,
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage_Utilities.Interfaces.ControlBus#text\">Interfaces.ControlBus</a>
is defined as:
</p>
<pre>  <b>expandable connector</b> ControlBus
      <b>extends</b> Modelica.Icons.ControlBus;
      <b>annotation</b> (Icon(Rectangle(extent=[-20, 2; 22, -2],
                       style(rgbcolor={255,204,51}, thickness=0.5))));
  <b>end</b> ControlBus;
</pre>
<p>
Note, the \"annotation\" in the connector is important since the color
and thickness of a connector line are taken from the first
line element in the icon annotation of a connector class. Above, a small rectangle in the
color of the bus is defined (and therefore this rectangle is not
visible). As a result, when connecting from an instance of this
connector to another connector instance, the connecting line has
the color of the \"ControlBus\" with double width (due to \"thickness=0.5\").
</p>

<p>
An <b>expandable</b> connector is a connector where the content of the connector
is constructed by the variables connected to instances of this connector.
For example, if \"sine.y\" is connected to the \"controlBus\", the following
menu pops-up in Dymola:
</p>

<p align=\"center\">
<img src=\"../Images/Blocks/BusUsage2.png\">
</p>

<p>
The \"Add variable/New name\" field allows the user to define the name of the signal on
the \"controlBus\". When typing \"realSignal1\" as \"New name\", a connection of the form:
</p>

<pre>     <b>connect</b>(sine.y, controlBus.realSignal1)
</pre>

<p>
is generated and the \"controlBus\" contains the new signal \"realSignal1\". Modelica tools
may give more support in order to list potential signals for a connection.
For example, in Dymola all variables are listed in the menu that are contained in
connectors which are derived by inheritance from \"controlBus\". Therefore, in
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage_Utilities.Interfaces.InternalConnectors\">BusUsage_Utilities.Interfaces.InternalConnectors</a>
the expected implementation of the \"ControlBus\" and of the \"SubControlBus\" are given.
For example \"Internal.ControlBus\" is defined as:
</p>

<pre>  <b>expandable connector</b> StandardControlBus
    <b>extends</b> BusUsage_Utilities.Interfaces.ControlBus;

    <b>import</b> SI = Modelica.SIunits;
    SI.AngularVelocity    realSignal1   \"First Real signal\";
    SI.Velocity           realSignal2   \"Second Real signal\";
    Integer               integerSignal \"Integer signal\";
    Boolean               booleanSignal \"Boolean signal\";
    StandardSubControlBus subControlBus \"Combined signal\";
  <b>end</b> StandardControlBus;
</pre>

<p>
Consequently, when connecting now from \"sine.y\" to \"controlBus\", the menu
looks differently:
</p>
<p align=\"center\">
<img src=\"../Images/Blocks/BusUsage3.png\">
</p>
<p>
Note, even if the signals from \"Internal.StandardControlBus\" are listed, these are
just potential signals. The user might still add different signal names.
</p>

</html>"),   Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                -100},{100,100}}),
                     graphics),
        experiment(StopTime=2));
      public
      Modelica.Blocks.Sources.IntegerStep integerStep(
        height=1,
        offset=2,
        startTime=0.5)   annotation (Placement(transformation(extent={{-60,-40},{
                -40,-20}}, rotation=0)));
      Modelica.Blocks.Sources.BooleanStep booleanStep(startTime=0.5) 
                                                                 annotation (Placement(
            transformation(extent={{-58,0},{-38,20}}, rotation=0)));
      Modelica.Blocks.Sources.Sine sine 
                                       annotation (Placement(transformation(
              extent={{-60,40},{-40,60}}, rotation=0)));

      Modelica.Blocks.Examples.BusUsage_Utilities.Part part 
                annotation (Placement(transformation(extent={{-60,-80},{-40,-60}},
              rotation=0)));
      Modelica.Blocks.Math.Gain gain 
        annotation (Placement(transformation(extent={{-40,70},{-60,90}}, rotation=
               0)));
      protected
      BusUsage_Utilities.Interfaces.ControlBus controlBus 
        annotation (Placement(transformation(
            origin={30,10},
            extent={{-20,20},{20,-20}},
            rotation=90)));
    equation

      connect(sine.y, controlBus.realSignal1) annotation (Line(
          points={{-39,50},{12,50},{12,14},{30,14},{30,10}},
          color={0,0,127},
          smooth=Smooth.None));
      connect(booleanStep.y, controlBus.booleanSignal) annotation (Line(
          points={{-37,10},{28,10}},
          color={255,0,255},
          smooth=Smooth.None));
      connect(integerStep.y, controlBus.integerSignal) annotation (Line(
          points={{-39,-30},{0,-30},{0,6},{30,6}},
          color={255,127,0},
          smooth=Smooth.None));
      connect(part.subControlBus, controlBus.subControlBus) annotation (Line(
          points={{-40,-70},{30,-70},{30,2}},
          color={255,204,51},
          thickness=0.5,
          smooth=Smooth.None));
      connect(gain.u, controlBus.realSignal1) annotation (Line(
          points={{-38,80},{20,80},{20,18},{28,18}},
          color={0,0,127},
          smooth=Smooth.None));
    end BusUsage;

    package BusUsage_Utilities
        "Utility models and connectors for example Modelica.Blocks.Examples.BusUsage"
      annotation (Documentation(info="<html>
<p>
This package contains utility models and bus definitions needed for the
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a> example.
</p>
</html>"),   Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-100,
                -100},{100,100}}),
                     graphics));
    package Interfaces "Interfaces specialised for this example"

        expandable connector ControlBus
            "Empty control bus that is adapted to the signals connected to it"
          extends Modelica.Icons.SignalBus;

          annotation (
            Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                    100,100}}), graphics={Rectangle(
                  extent={{-20,2},{22,-2}},
                  lineColor={255,204,51},
                  lineThickness=0.5)}),
            Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                    {100,100}}),
                    graphics),
            Documentation(info="<html>
<p>
This connector defines the \"expandable connector\" ControlBus that
is used as bus in the
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a> example.
Note, this connector is \"empty\". When using it, the actual content is
constructed by the signals connected to this bus.
</p>
</html>"));

        end ControlBus;

        expandable connector SubControlBus
            "Empty sub-control bus that is adapted to the signals connected to it"
          extends Modelica.Icons.SignalSubBus;

          annotation (defaultComponentPrefixes="protected",
                      Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Rectangle(
                  extent={{-20,2},{22,-2}},
                  lineColor={255,204,51},
                  lineThickness=0.5)}),
            Documentation(info="<html>
<p>
This connector defines the \"expandable connector\" SubControlBus that
is used as sub-bus in the
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a> example.
Note, this connector is \"empty\". When using it, the actual content is
constructed by the signals connected to this bus.
</p>
</html>"));

        end SubControlBus;

      package InternalConnectors
            "Internal definitions that are usually not utilized (only indirectly via the expandable connectors)"
          expandable connector StandardControlBus
              "Used to build up the standard control bus (do not use this connector)"
            extends
                Modelica.Blocks.Examples.BusUsage_Utilities.Interfaces.ControlBus;

            import SI = Modelica.SIunits;
            SI.AngularVelocity realSignal1
                "First Real signal (angular velocity)";
            SI.Velocity realSignal2 "Second Real signal";
            Integer integerSignal "Integer signal";
            Boolean booleanSignal "Boolean signal";
            StandardSubControlBus subControlBus "Combined signal";

            annotation (
              Icon(graphics={Rectangle(
                    extent={{-20,2},{22,-2}},
                    lineColor={255,204,51},
                    lineThickness=0.5)}),
              Diagram(graphics),
              Documentation(info="<html>
<p>
This connector is used to show default signals that might be added
to the
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage_Utilities.Interfaces.ControlBus\">ControlBus</a>.
</p>
</html>"));

          end StandardControlBus;

          expandable connector StandardSubControlBus
              "Used to build up the standard sub-control bus (do not use this connector)"
            extends
                Modelica.Blocks.Examples.BusUsage_Utilities.Interfaces.SubControlBus;

            Real myRealSignal;
            Boolean myBooleanSignal;

            annotation (defaultComponentPrefixes="protected",
                        Icon(graphics={Rectangle(
                    extent={{-20,2},{22,-2}},
                    lineColor={255,204,51},
                    lineThickness=0.5)}),
              Documentation(info="<html>
<p>
This connector is used to show default signals that might be added
to the
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage_Utilities.Interfaces.SubControlBus\">SubControlBus</a>.
</p>
</html>"));
          end StandardSubControlBus;
          annotation (Documentation(info="<html>
<p>
This package contains the \"actual\" default bus definitions needed for the
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a> example.
The bus definitions in this package are the default definitions shown in the
bus menu when connecting a signal to an expandable connector (here: ControlBus
or SubControlBus). Usually, the connectors of this package should not be
utilized by a user.
</p>
</html>"));
      end InternalConnectors;
        annotation (Documentation(info="<html>
<p>
This package contains the bus definitions needed for the
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a> example.
</p>
</html>"));
    end Interfaces;

     model Part "Component with sub-control bus"

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Rectangle(
                extent={{-100,60},{100,-60}},
                fillColor={159,159,223},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}), Text(
                extent={{-106,124},{114,68}},
                fillColor={159,159,223},
                fillPattern=FillPattern.Solid,
                textString="%name",
                lineColor={0,0,255})}),
                                Diagram(coordinateSystem(preserveAspectRatio=true,
                extent={{-100,-100},{100,100}}),
                                        graphics),
          Documentation(info="<html>
<p>
<p>
This model is used to demonstrate the bus usage in example
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</p>
</html>"));
       Interfaces.SubControlBus subControlBus 
         annotation (Placement(transformation(
              origin={100,0},
              extent={{-20,-20},{20,20}},
              rotation=270)));
       Sources.RealExpression realExpression(y=time) 
         annotation (Placement(transformation(extent={{-6,0},{20,20}}, rotation=0)));
       Sources.BooleanExpression booleanExpression(y=time > 0.5) 
         annotation (Placement(transformation(extent={{-6,-30},{20,-10}},
                rotation=0)));
     equation
        connect(realExpression.y, subControlBus.myRealSignal) annotation (Line(
            points={{21.3,10},{88,10},{88,4},{96,4}},
            color={0,0,127},
            smooth=Smooth.None));
        connect(booleanExpression.y, subControlBus.myBooleanSignal) annotation (
            Line(
            points={{21.3,-20},{60,-20},{60,-2},{98,-2}},
            color={255,0,255},
            smooth=Smooth.None));
     end Part;

    end BusUsage_Utilities;
  end Examples;

    package Continuous
      "Library of continuous control blocks with internal states"

      import Modelica.Blocks.Interfaces;
      import Modelica.SIunits;
      extends Modelica.Icons.Library;

      annotation (
        Documentation(info="<html>
<p>
This package contains basic <b>continuous</b> input/output blocks
described by differential equations.
</p>

<p>
All blocks of this package can be initialized in different
ways controlled by parameter <b>initType</b>. The possible
values of initType are defined in 
<a href=\"Modelica://Modelica.Blocks.Types.Init\">Modelica.Blocks.Types.Init</a>:
</p>

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>Name</b></td>
      <td valign=\"top\"><b>Description</b></td></tr>

  <tr><td valign=\"top\"><b>Init.NoInit</b></td>
      <td valign=\"top\">no initialization (start values are used as guess values with fixed=false)</td></tr>

  <tr><td valign=\"top\"><b>Init.SteadyState</b></td>
      <td valign=\"top\">steady state initialization (derivatives of states are zero)</td></tr>

  <tr><td valign=\"top\"><b>Init.InitialState</b></td>
      <td valign=\"top\">Initialization with initial states</td></tr>

  <tr><td valign=\"top\"><b>Init.InitialOutput</b></td>
      <td valign=\"top\">Initialization with initial outputs (and steady state of the states if possibles)</td></tr>
</table>

<p>
For backward compatibility reasons the default of all blocks is
<b>Init.NoInit</b>, with the exception of Integrator and LimIntegrator 
where the default is <b>Init.InitialState</b> (this was the initialization
defined in version 2.2 of the Modelica standard library).
</p>

<p>
In many cases, the most useful initial condition is
<b>Init.SteadyState</b> because initial transients are then no longer
present. The drawback is that in combination with a non-linear
plant, non-linear algebraic equations occur that might be
difficult to solve if appropriate guess values for the
iteration variables are not provided (i.e. start values with fixed=false). 
However, it is often already useful to just initialize
the linear blocks from the Continuous blocks library in SteadyState.
This is uncritical, because only linear algebraic equations occur.
If Init.NoInit is set, then the start values for the states are
interpreted as <b>guess</b> values and are propagated to the
states with fixed=<b>false</b>.
</p>

<p>
Note, initialization with Init.SteadyState is usually difficult 
for a block that contains an integrator
(Integrator, LimIntegrator, PI, PID, LimPID).
This is due to the basic equation of an integrator:
</p>

<pre>
  <b>initial equation</b>
     <b>der</b>(y) = 0;   // Init.SteadyState
  <b>equation</b>
     <b>der</b>(y) = k*u;
</pre>

<p>
The steady state equation leads to the condition that the input to the
integrator is zero. If the input u is already (directly or indirectly) defined
by another initial condition, then the initialization problem is <b>singular</b>
(has none or infinitely many solutions). This situation occurs often
for mechanical systems, where, e.g., u = desiredSpeed - measuredSpeed and
since speed is both a state and a derivative, it is always defined by
Init.InitialState or Init.SteadyState initializtion.
</p>

<p>
In such a case, <b>Init.NoInit</b> has to be selected for the integrator
and an additional initial equation has to be added to the system
to which the integrator is connected. E.g., useful initial conditions
for a 1-dim. rotational inertia controlled by a PI controller are that
<b>angle</b>, <b>speed</b>, and <b>acceleration</b> of the inertia are zero.
</p>

</html>
"));

      block Integrator "Output the integral of the input signal"
        import Modelica.Blocks.Types.Init;
        parameter Real k=1 "Integrator gain";

        /* InitialState is the default, because it was the default in Modelica 2.2
     and therefore this setting is backward compatible
  */
        parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.InitialState
          "Type of initialization (1: no init, 2: steady state, 3,4: initial output)"
                                                                                          annotation(Evaluate=true,
            Dialog(group="Initialization"));
        parameter Real y_start=0 "Initial or guess value of output (= state)" 
          annotation (Dialog(group="Initialization"));
        extends Interfaces.SISO(y(start=y_start));

        annotation (
          Documentation(info="<html>
<p>
This blocks computes output <b>y</b> (element-wise) as
<i>integral</i> of the input <b>u</b> multiplied with
the gain <i>k</i>:
</p>
<pre>
         k
     y = - u
         s
</pre>

<p>
It might be difficult to initialize the integrator in steady state.
This is discussed in the description of package
<a href=\"Modelica://Modelica.Blocks.Continuous#info\">Continuous</a>.
</p>

</html>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-80},{68,-72},{68,-88},{90,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{0,-10},{60,-70}},
                lineColor={192,192,192},
                textString="I"),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="k=%k"),
              Line(points={{-80,-80},{80,80}}, color={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Line(points={{-100,0},{-60,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255}),
              Text(
                extent={{-36,60},{32,2}},
                lineColor={0,0,0},
                textString="k"),
              Text(
                extent={{-32,0},{36,-58}},
                lineColor={0,0,0},
                textString="s"),
              Line(points={{-46,0},{46,0}}, color={0,0,0})}));

      initial equation
        if initType == Init.SteadyState then
           der(y) = 0;
        elseif initType == Init.InitialState or 
               initType == Init.InitialOutput then
          y = y_start;
        end if;
      equation
        der(y) = k*u;
      end Integrator;

      block LimIntegrator "Integrator with limited value of the output"
        import Modelica.Blocks.Types.Init;
        parameter Real k=1 "Integrator gain";
        parameter Real outMax(start=1) "Upper limit of output";
        parameter Real outMin=-outMax "Lower limit of output";
        parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.InitialState
          "Type of initialization (1: no init, 2: steady state, 3/4: initial output)"
          annotation(Evaluate=true, Dialog(group="Initialization"));
        parameter Boolean limitsAtInit = true
          "= false, if limits are ignored during initializiation (i.e., der(y)=k*u)"
          annotation(Evaluate=true, Dialog(group="Initialization"));
        parameter Real y_start=0
          "Initial or guess value of output (must be in the limits outMin .. outMax)"
          annotation (Dialog(group="Initialization"));
        extends Interfaces.SISO(y(start=y_start));
        annotation (
          Documentation(info="<html>
<p>
This blocks computes <b>y</b> (element-wise) as <i>integral</i>
of the input <b>u</b> multiplied with the gain <i>k</i>. If the
integral reaches a given upper or lower <i>limit</i> and the
input will drive the integral outside of this bound, the
integration is halted and only restarted if the input drives
the integral away from the bounds.
</p>

<p>
It might be difficult to initialize the integrator in steady state.
This is discussed in the description of package
<a href=\"Modelica://Modelica.Blocks.Continuous#info\">Continuous</a>.
</p>

<p>
If parameter <b>limitAtInit</b> = <b>false</b>, the limits of the
integrator are removed from the initialization problem which 
leads to a much simpler equation system. After initialization has been
performed, it is checked via an assert whether the output is in the
defined limits. For backward compatibility reasons 
<b>limitAtInit</b> = <b>true</b>. In most cases it is best
to use <b>limitAtInit</b> = <b>false</b>.
</p>
</html>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-80},{68,-72},{68,-88},{90,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{20,20},{80,20}}, color={0,0,127}),
              Text(
                extent={{0,-10},{60,-70}},
                lineColor={192,192,192},
                textString="I"),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="k=%k")}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Text(
                extent={{-54,46},{-4,-48}},
                lineColor={0,0,0},
                textString="lim"),
              Line(points={{-100,0},{-60,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255}),
              Text(
                extent={{-8,60},{60,2}},
                lineColor={0,0,0},
                textString="k"),
              Text(
                extent={{-8,-2},{60,-60}},
                lineColor={0,0,0},
                textString="s"),
              Line(points={{4,0},{46,0}}, color={0,0,0})}));

      initial equation
        if initType == Init.SteadyState then
           der(y) = 0;
        elseif initType == Init.InitialState or 
               initType == Init.InitialOutput then
          y = y_start;
        end if;
      equation
        if initial() and not limitsAtInit then
           der(y) = k*u;
           assert(y >= outMin - 0.01*abs(outMin) and 
                  y <= outMax + 0.01*abs(outMax),
                 "LimIntegrator: During initialization the limits have been ignored.\n"+
                 "However, the result is that the output y is not within the required limits:\n"+
                 "  y = " + String(y) + ", outMin = " + String(outMin) + ", outMax = " + String(outMax));
        else
           der(y) = if y < outMin and u < 0 or y > outMax and u > 0 then 0 else k*u;
        end if;
      end LimIntegrator;

      block Derivative "Approximated derivative block"
        import Modelica.Blocks.Types.Init;
        parameter Real k=1 "Gains";
        parameter SIunits.Time T(min=Modelica.Constants.small) = 0.01
          "Time constants (T>0 required; T=0 is ideal derivative block)";
        parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
          "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                                                                          annotation(Evaluate=true,
            Dialog(group="Initialization"));
        parameter Real x_start=0 "Initial or guess value of state" 
          annotation (Dialog(group="Initialization"));
        parameter Real y_start=0 "Initial value of output (= state)" 
          annotation(Dialog(enable=initType == Init.InitialOutput, group=
                "Initialization"));
        extends Interfaces.SISO;

        output Real x(start=x_start) "State of block";

        annotation (
          Documentation(info="
<HTML>
<p>
This blocks defines the transfer function between the
input u and the output y
(element-wise) as <i>approximated derivative</i>:
</p>
<pre>
             k * s
     y = ------------ * u
            T * s + 1
</pre>
<p>
If you would like to be able to change easily between different
transfer functions (FirstOrder, SecondOrder, ... ) by changing
parameters, use the general block <b>TransferFunction</b> instead
and model a derivative block with parameters<br>
b = {k,0}, a = {T, 1}.
</p>
 
<p>
If k=0, the block reduces to y=0.
</p>
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-80},{68,-72},{68,-88},{90,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-80,60},{-70,17.95},{-60,-11.46},{-50,-32.05},
                    {-40,-46.45},{-30,-56.53},{-20,-63.58},{-10,-68.51},{0,-71.96},
                    {10,-74.37},{20,-76.06},{30,-77.25},{40,-78.07},{50,-78.65},{60,
                    -79.06}}, color={0,0,127}),
              Text(
                extent={{-30,14},{86,60}},
                lineColor={192,192,192},
                textString="DT1"),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="k=%k")}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-54,52},{50,10}},
                lineColor={0,0,0},
                textString="k s"),
              Text(
                extent={{-54,-6},{52,-52}},
                lineColor={0,0,0},
                textString="T s + 1"),
              Line(points={{-50,0},{50,0}}, color={0,0,0}),
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Line(points={{-100,0},{-60,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255})}));
      protected
        parameter Boolean zeroGain = abs(k) < Modelica.Constants.eps;
      initial equation
        if initType == Init.SteadyState then
          der(x) = 0;
        elseif initType == Init.InitialState then
          x = x_start;
        elseif initType == Init.InitialOutput then
          if zeroGain then
             x = u;
          else
             y = y_start;
          end if;
        end if;
      equation
        der(x) = if zeroGain then 0 else (u - x)/T;
        y = if zeroGain then 0 else (k/T)*(u - x);
      end Derivative;

      block FirstOrder "First order transfer function block (= 1 pole)"
        import Modelica.Blocks.Types.Init;
        parameter Real k=1 "Gain";
        parameter SIunits.Time T(start=1) "Time Constant";
        parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
          "Type of initialization (1: no init, 2: steady state, 3/4: initial output)"
                                                                                          annotation(Evaluate=true,
            Dialog(group="Initialization"));
        parameter Real y_start=0 "Initial or guess value of output (= state)" 
          annotation (Dialog(group="Initialization"));

        extends Interfaces.SISO(y(start=y_start));

        annotation (
          Documentation(info="<HTML>
<p>
This blocks defines the transfer function between the input u
and the output y (element-wise) as <i>first order</i> system:
</p>
<pre>
               k
     y = ------------ * u
            T * s + 1
</pre>
<p>
If you would like to be able to change easily between different
transfer functions (FirstOrder, SecondOrder, ... ) by changing
parameters, use the general block <b>TransferFunction</b> instead
and model a first order SISO system with parameters<br>
b = {k}, a = {T, 1}.
</p>
<pre>
Example:
   parameter: k = 0.3, T = 0.4
   results in:
             0.3
      y = ----------- * u
          0.4 s + 1.0
</pre>

</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,88},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-80},{68,-72},{68,-88},{90,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-70,-45.11},{-60,-19.58},{-50,-0.9087},{-40,
                    12.75},{-30,22.75},{-20,30.06},{-10,35.41},{0,39.33},{10,42.19},
                    {20,44.29},{30,45.82},{40,46.94},{50,47.76},{60,48.36},{70,48.8},
                    {80,49.12}}, color={0,0,127}),
              Text(
                extent={{0,0},{60,-60}},
                lineColor={192,192,192},
                textString="PT1"),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="T=%T")}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-48,52},{50,8}},
                lineColor={0,0,0},
                textString="k"),
              Text(
                extent={{-54,-6},{56,-56}},
                lineColor={0,0,0},
                textString="T s + 1"),
              Line(points={{-50,0},{50,0}}, color={0,0,0}),
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Line(points={{-100,0},{-60,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255})}));
      initial equation
        if initType == Init.SteadyState then
          der(y) = 0;
        elseif initType == Init.InitialState or initType == Init.InitialOutput then
          y = y_start;
        end if;
      equation
        der(y) = (k*u - y)/T;
      end FirstOrder;

      block SecondOrder "Second order transfer function block (= 2 poles)"
        import Modelica.Blocks.Types.Init;
        parameter Real k=1 "Gain";
        parameter Real w(start=1) "Angular frequency";
        parameter Real D(start=1) "Damping";
        parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
          "Type of initialization (1: no init, 2: steady state, 3/4: initial output)"
                                                                                          annotation(Evaluate=true,
            Dialog(group="Initialization"));
        parameter Real y_start=0 "Initial or guess value of output (= state)" 
          annotation (Dialog(group="Initialization"));
        parameter Real yd_start=0
          "Initial or guess value of derivative of output (= state)" 
          annotation (Dialog(group="Initialization"));

        extends Interfaces.SISO(y(start=y_start));
        output Real yd(start=yd_start) "Derivative of y";
        annotation (
          Documentation(info="<HTML>
<p>
This blocks defines the transfer function between the input u and
the output y (element-wise) as <i>second order</i> system:
</p>
<pre>
                             k
     y = ---------------------------------------- * u
            ( s / w )^2 + 2*D*( s / w ) + 1
</pre>
<p>
If you would like to be able to change easily between different
transfer functions (FirstOrder, SecondOrder, ... ) by changing
parameters, use the general model class <b>TransferFunction</b>
instead and model a second order SISO system with parameters<br>
b = {k}, a = {1/w^2, 2*D/w, 1}.
</p>
<pre>
Example:

   parameter: k =  0.3,  w = 0.5,  D = 0.4
   results in:
                  0.3
      y = ------------------- * u
          4.0 s^2 + 1.6 s + 1
</pre>

</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,88},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-80},{68,-72},{68,-88},{90,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-72,-68.53},{-64,-39.5},{-56,-2.522},{-48,
                    32.75},{-40,58.8},{-32,71.51},{-24,70.49},{-16,58.45},{-8,40.06},
                    {0,20.55},{8,4.459},{16,-5.271},{24,-7.629},{32,-3.428},{40,
                    5.21},{48,15.56},{56,25.03},{64,31.66},{72,34.5},{80,33.61}},
                  color={0,0,127}),
              Text(
                extent={{0,-10},{60,-70}},
                lineColor={192,192,192},
                textString="PT2"),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="w=%w")}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Text(
                extent={{-60,60},{60,14}},
                lineColor={0,0,0},
                textString="k"),
              Text(
                extent={{-60,8},{-32,-20}},
                lineColor={0,0,0},
                textString="s"),
              Line(points={{-100,0},{-60,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255}),
              Line(points={{-50,14},{50,14}}, color={0,0,0}),
              Line(points={{-54,-20},{-38,-20}}, color={0,0,0}),
              Text(
                extent={{-52,-26},{-36,-48}},
                lineColor={0,0,0},
                textString="w"),
              Line(points={{-50,2},{-56,-8},{-56,-28},{-52,-46}}, color={0,0,0}),
              Line(points={{-40,2},{-34,-10},{-34,-30},{-38,-46}}, color={0,0,0}),
              Text(
                extent={{-34,8},{-22,-10}},
                lineColor={0,0,0},
                textString="2"),
              Text(
                extent={{-34,-6},{6,-36}},
                lineColor={0,0,0},
                textString="+2D"),
              Text(
                extent={{2,8},{30,-20}},
                lineColor={0,0,0},
                textString="s"),
              Line(points={{8,-20},{24,-20}}, color={0,0,0}),
              Text(
                extent={{10,-26},{26,-48}},
                lineColor={0,0,0},
                textString="w"),
              Line(points={{12,2},{6,-8},{6,-28},{10,-46}}, color={0,0,0}),
              Line(points={{22,2},{28,-10},{28,-30},{24,-46}}, color={0,0,0}),
              Text(
                extent={{30,2},{58,-42}},
                lineColor={0,0,0},
                textString="+1")}));

      initial equation
        if initType == Init.SteadyState then
          der(y) = 0;
          der(yd) = 0;
        elseif initType == Init.InitialState or initType == Init.InitialOutput then
          y = y_start;
          yd = yd_start;
        end if;
      equation
        der(y) = yd;
        der(yd) = w*(w*(k*u - y) - 2*D*yd);
      end SecondOrder;

      block PI "Proportional-Integral controller"
        import Modelica.Blocks.Types.Init;
        parameter Real k=1 "Gain";
        parameter SIunits.Time T(start=1,min=Modelica.Constants.small)
          "Time Constant (T>0 required)";
        parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
          "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                                                                  annotation(Evaluate=true,
            Dialog(group="Initialization"));
        parameter Real x_start=0 "Initial or guess value of state" 
          annotation (Dialog(group="Initialization"));
        parameter Real y_start=0 "Initial value of output" 
          annotation(Dialog(enable=initType == Init.SteadyState or initType == Init.InitialOutput, group=
                "Initialization"));

        extends Interfaces.SISO;
        output Real x(start=x_start) "State of block";

        annotation (defaultComponentName="PI",
          Documentation(info="
<HTML>
<p>
This blocks defines the transfer function between the input u and
the output y (element-wise) as <i>PI</i> system:
</p>
<pre>
                 1
   y = k * (1 + ---) * u
                T*s
           T*s + 1
     = k * ------- * u
             T*s
</pre>
<p>
If you would like to be able to change easily between different
transfer functions (FirstOrder, SecondOrder, ... ) by changing
parameters, use the general model class <b>TransferFunction</b>
instead and model a PI SISO system with parameters<br>
b = {k*T, k}, a = {T, 0}.
</p>
<pre>
Example:
 
   parameter: k = 0.3,  T = 0.4
 
   results in:
               0.4 s + 1
      y = 0.3 ----------- * u
                 0.4 s
</pre>

<p>
It might be difficult to initialize the PI component in steady state
due to the integrator part.
This is discussed in the description of package
<a href=\"Modelica://Modelica.Blocks.Continuous#info\">Continuous</a>.
</p>
 
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,88},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-80},{68,-72},{68,-88},{90,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-80,-20},{60,80}}, color={0,0,127}),
              Text(
                extent={{0,6},{60,-56}},
                lineColor={192,192,192},
                textString="PI"),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="T=%T")}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Text(
                extent={{-68,24},{-24,-18}},
                lineColor={0,0,0},
                textString="k"),
              Text(
                extent={{-32,48},{60,0}},
                lineColor={0,0,0},
                textString="T s + 1"),
              Text(
                extent={{-30,-8},{52,-40}},
                lineColor={0,0,0},
                textString="T s"),
              Line(points={{-24,0},{54,0}}, color={0,0,0}),
              Line(points={{-100,0},{-60,0}}, color={0,0,255}),
              Line(points={{62,0},{100,0}}, color={0,0,255})}));
      initial equation
        if initType == Init.SteadyState then
          der(x) = 0;
        elseif initType == Init.InitialState then
          x = x_start;
        elseif initType == Init.InitialOutput then
          y = y_start;
        end if;
      equation
        der(x) = u/T;
        y = k*(x + u);
      end PI;

      block PID "PID-controller in additive description form"
        import Modelica.Blocks.Types.InitPID;
        extends Interfaces.SISO;

        parameter Real k=1 "Gain";
        parameter SIunits.Time Ti(min=Modelica.Constants.small, start=0.5)
          "Time Constant of Integrator";
        parameter SIunits.Time Td(min=0, start=0.1)
          "Time Constant of Derivative block";
        parameter Real Nd(min=Modelica.Constants.small) = 10
          "The higher Nd, the more ideal the derivative block";
        parameter Modelica.Blocks.Types.InitPID initType= Modelica.Blocks.Types.InitPID.DoNotUse_InitialIntegratorState
          "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                           annotation(Evaluate=true,
            Dialog(group="Initialization"));
        parameter Real xi_start=0
          "Initial or guess value value for integrator output (= integrator state)"
          annotation (Dialog(group="Initialization"));
        parameter Real xd_start=0
          "Initial or guess value for state of derivative block" 
          annotation (Dialog(group="Initialization"));
        parameter Real y_start=0 "Initial value of output" 
          annotation(Dialog(enable=initType == Init.InitialOutput, group=
                "Initialization"));

        annotation (defaultComponentName="PID",
          Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-80},{68,-72},{68,-88},{90,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-80,50},{-80,-20},{60,80}}, color={0,0,127}),
              Text(
                extent={{-20,-20},{80,-60}},
                lineColor={192,192,192},
                textString="PID"),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="Ti=%Ti")}),
          Documentation(info="<HTML>
<p>
This is the text-book version of a PID-controller.
For a more practically useful PID-controller, use
block LimPID.
</p>
 
<p>
The PID block can be initialized in different
ways controlled by parameter <b>initType</b>. The possible
values of initType are defined in 
<a href=\"Modelica://Modelica.Blocks.Types.InitPID\">Modelica.Blocks.Types.InitPID</a>.
This type is identical to 
<a href=\"Modelica://Modelica.Blocks.Types.Init\">Types.Init</a>, 
with the only exception that the additional option
<b>DoNotUse_InitialIntegratorState</b> is added for
backward compatibility reasons (= integrator is initialized with
InitialState whereas differential part is initialized with
NoInit which was the initialization in version 2.2 of the Modelica
standard library).
</p>
 
<p>
Based on the setting of initType, the integrator (I) and derivative (D)
blocks inside the PID controller are initialized according to the following table:
</p>
 
<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>initType</b></td>
      <td valign=\"top\"><b>I.initType</b></td>
      <td valign=\"top\"><b>D.initType</b></td></tr>
 
  <tr><td valign=\"top\"><b>NoInit</b></td>
      <td valign=\"top\">NoInit</td>
      <td valign=\"top\">NoInit</td></tr>
 
  <tr><td valign=\"top\"><b>SteadyState</b></td>
      <td valign=\"top\">SteadyState</td>
      <td valign=\"top\">SteadyState</td></tr>
 
  <tr><td valign=\"top\"><b>InitialState</b></td>
      <td valign=\"top\">InitialState</td>
      <td valign=\"top\">InitialState</td></tr>
 
  <tr><td valign=\"top\"><b>InitialOutput</b><br>
          and initial equation: y = y_start</td>
      <td valign=\"top\">NoInit</td>
      <td valign=\"top\">SteadyState</td></tr>
 
  <tr><td valign=\"top\"><b>DoNotUse_InitialIntegratorState</b></td>
      <td valign=\"top\">InitialState</td>
      <td valign=\"top\">NoInit</td></tr>
</table>
 
<p>
In many cases, the most useful initial condition is
<b>SteadyState</b> because initial transients are then no longer
present. If initType = InitPID.SteadyState, then in some
cases difficulties might occur. The reason is the 
equation of the integrator:
</p>
 
<pre>
   <b>der</b>(y) = k*u;
</pre>
 
<p>
The steady state equation \"der(x)=0\" leads to the condition that the input u to the
integrator is zero. If the input u is already (directly or indirectly) defined
by another initial condition, then the initialization problem is <b>singular</b>
(has none or infinitely many solutions). This situation occurs often
for mechanical systems, where, e.g., u = desiredSpeed - measuredSpeed and
since speed is both a state and a derivative, it is natural to
initialize it with zero. As sketched this is, however, not possible.
The solution is to not initialize u or the variable that is used
to compute u by an algebraic equation.
</p>

 
</HTML>
"),       Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics));

        Blocks.Math.Gain P "Proportional part of PID controller" 
          annotation (Placement(transformation(extent={{-60,60},{-20,100}},
                rotation=0)));
        Blocks.Continuous.Integrator I(k=1/Ti, y_start=xi_start,
          initType=if initType==InitPID.SteadyState then 
                      InitPID.SteadyState else 
                   if initType==InitPID.InitialState or 
                      initType==InitPID.DoNotUse_InitialIntegratorState then 
                      InitPID.InitialState else InitPID.NoInit)
          "Integral part of PID controller" 
          annotation (Placement(transformation(extent={{-60,-20},{-20,20}},
                rotation=0)));
        Blocks.Continuous.Derivative D(k=Td, T=max([Td/Nd, 100*Modelica.
              Constants.eps]), x_start=xd_start,
          initType=if initType==InitPID.SteadyState or 
                      initType==InitPID.InitialOutput then InitPID.SteadyState else 
                   if initType==InitPID.InitialState then InitPID.InitialState else 
                      InitPID.NoInit) "Derivative part of PID controller" 
          annotation (Placement(transformation(extent={{-60,-100},{-20,-60}},
                rotation=0)));
        Blocks.Math.Gain Gain(k=k) "Gain of PID controller" 
          annotation (Placement(transformation(extent={{60,-10},{80,10}}, rotation=
                  0)));
        Blocks.Math.Add3 Add annotation (Placement(transformation(extent={{20,-10},
                  {40,10}}, rotation=0)));
      initial equation
        if initType==InitPID.InitialOutput then
           y = y_start;
        end if;

      equation
        connect(u, P.u) annotation (Line(points={{-120,0},{-80,0},{-80,80},{-64,80}},
              color={0,0,127}));
        connect(u, I.u) 
          annotation (Line(points={{-120,0},{-64,0}}, color={0,0,127}));
        connect(u, D.u) annotation (Line(points={{-120,0},{-80,0},{-80,-80},{-64,
                -80}}, color={0,0,127}));
        connect(P.y, Add.u1) annotation (Line(points={{-18,80},{0,80},{0,8},{18,8}},
              color={0,0,127}));
        connect(I.y, Add.u2) 
          annotation (Line(points={{-18,0},{18,0}}, color={0,0,127}));
        connect(D.y, Add.u3) annotation (Line(points={{-18,-80},{0,-80},{0,-8},{18,
                -8}}, color={0,0,127}));
        connect(Add.y, Gain.u) 
          annotation (Line(points={{41,0},{58,0}}, color={0,0,127}));
        connect(Gain.y, y) 
          annotation (Line(points={{81,0},{110,0}}, color={0,0,127}));
      end PID;

      block LimPID
        "P, PI, PD, and PID controller with limited output, anti-windup compensation and setpoint weighting"
        import Modelica.Blocks.Types.InitPID;
        import Modelica.Blocks.Types.SimpleController;
        extends Interfaces.SVcontrol;
        output Real controlError = u_s - u_m
          "Control error (set point - measurement)";

        parameter Modelica.Blocks.Types.SimpleController controllerType=
               Modelica.Blocks.Types.SimpleController.PID "Type of controller";
        parameter Real k(min=0) = 1 "Gain of controller";
        parameter SIunits.Time Ti(min=Modelica.Constants.small, start=0.5)
          "Time constant of Integrator block" 
           annotation(Dialog(enable=controllerType==SimpleController.PI or 
                                    controllerType==SimpleController.PID));
        parameter SIunits.Time Td(min=0, start= 0.1)
          "Time constant of Derivative block" 
             annotation(Dialog(enable=controllerType==SimpleController.PD or 
                                      controllerType==SimpleController.PID));
        parameter Real yMax(start=1) "Upper limit of output";
        parameter Real yMin=-yMax "Lower limit of output";
        parameter Real wp(min=0) = 1
          "Set-point weight for Proportional block (0..1)";
        parameter Real wd(min=0) = 0
          "Set-point weight for Derivative block (0..1)" 
             annotation(Dialog(enable=controllerType==SimpleController.PD or 
                                      controllerType==SimpleController.PID));
        parameter Real Ni(min=100*Modelica.Constants.eps) = 0.9
          "Ni*Ti is time constant of anti-windup compensation" 
           annotation(Dialog(enable=controllerType==SimpleController.PI or 
                                    controllerType==SimpleController.PID));
        parameter Real Nd(min=100*Modelica.Constants.eps) = 10
          "The higher Nd, the more ideal the derivative block" 
             annotation(Dialog(enable=controllerType==SimpleController.PD or 
                                      controllerType==SimpleController.PID));
        parameter Modelica.Blocks.Types.InitPID initType= Modelica.Blocks.Types.InitPID.DoNotUse_InitialIntegratorState
          "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                           annotation(Evaluate=true,
            Dialog(group="Initialization"));
        parameter Boolean limitsAtInit = true
          "= false, if limits are ignored during initializiation" 
          annotation(Evaluate=true, Dialog(group="Initialization",
                             enable=controllerType==SimpleController.PI or 
                                    controllerType==SimpleController.PID));
        parameter Real xi_start=0
          "Initial or guess value value for integrator output (= integrator state)"
          annotation (Dialog(group="Initialization",
                      enable=controllerType==SimpleController.PI or 
                             controllerType==SimpleController.PID));
        parameter Real xd_start=0
          "Initial or guess value for state of derivative block" 
          annotation (Dialog(group="Initialization",
                               enable=controllerType==SimpleController.PD or 
                                      controllerType==SimpleController.PID));
        parameter Real y_start=0 "Initial value of output" 
          annotation(Dialog(enable=initType == InitPID.InitialOutput, group=
                "Initialization"));

        annotation (defaultComponentName="PID",
          Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-80},{68,-72},{68,-88},{90,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-80,50},{-80,-20},{30,60},{80,60}}, color={0,
                    0,127}),
              Text(
                extent={{-20,-20},{80,-60}},
                lineColor={192,192,192},
                textString="PID")}),
          Documentation(info="<HTML>
<p>
Via parameter <b>controllerType</b> either <b>P</b>, <b>PI</b>, <b>PD</b>, 
or <b>PID</b> can be selected. If, e.g., PI is selected, all components belonging to the
D-part are removed from the block (via conditional declarations).
The example model
<a href=\"Modelica://Modelica.Blocks.Examples.PID_Controller\">Modelica.Blocks.Examples.PID_Controller</a>
demonstrates the usage of this controller.
Several practical aspects of PID controller design are incorporated
according to chapter 3 of the book:
</p>

<dl>
<dt>Astroem K.J., and Haegglund T.:</dt>
<dd> <b>PID Controllers: Theory, Design, and Tuning</b>.
     Instrument Society of America, 2nd edition, 1995.
     Information from:
     <a href=\"http://www.control.lth.se/publications/books/asthagg95.html\">http://www.control.lth.se/publications/books/asthagg95.html</a>
     </dd>
</dl>

<p>
Besides the additive <b>proportional, integral</b> and <b>derivative</b>
part of this controller, the following features are present:
</p>
<ul>
<li> The output of this controller is limited. If the controller is
     in its limits, anti-windup compensation is activated to drive
     the integrator state to zero. </li>
<li> The high-frequency gain of the derivative part is limited
     to avoid excessive amplification of measurement noise.</li>
<li> Setpoint weighting is present, which allows to weight
     the setpoint in the proportional and the derivative part
     independantly from the measurement. The controller will respond
     to load disturbances and measurement noise independantly of this setting
     (parameters wp, wd). However, setpoint changes will depend on this
     setting. For example, it is useful to set the setpoint weight wd
     for the derivative part to zero, if steps may occur in the
     setpoint signal.</li>
</ul>

<p>
The parameters of the controller can be manually adjusted by performing
simulations of the closed loop system (= controller + plant connected
together) and using the following strategy:
</p>

<ol>
<li> Set very large limits, e.g., yMax = Modelica.Constants.inf</li>
<li> Select a <b>P</b>-controller and manually enlarge parameter <b>k</b>
     (the total gain of the controller) until the closed-loop response
     cannot be improved any more.</li>
<li> Select a <b>PI</b>-controller and manually adjust parameters
     <b>k</b> and <b>Ti</b> (the time constant of the integrator).
     The first value of Ti can be selected, such that it is in the
     order of the time constant of the oscillations occuring with
     the P-controller. If, e.g., vibrations in the order of T=10 ms
     occur in the previous step, start with Ti=0.01 s.</li>
<li> If you want to make the reaction of the control loop faster
     (but probably less robust against disturbances and measurement noise)
     select a <b>PID</b>-Controller and manually adjust parameters 
     <b>k</b>, <b>Ti</b>, <b>Td</b> (time constant of derivative block).</li>
<li> Set the limits yMax and yMin according to your specification.</li>
<li> Perform simulations such that the output of the PID controller
     goes in its limits. Tune <b>Ni</b> (Ni*Ti is the time constant of 
     the anti-windup compensation) such that the input to the limiter
     block (= limiter.u) goes quickly enough back to its limits.
     If Ni is decreased, this happens faster. If Ni=infinity, the
     anti-windup compensation is switched off and the controller works bad.</li>
</ol>
 
<p>
<b>Initialization</b>
</p>

<p>
This block can be initialized in different
ways controlled by parameter <b>initType</b>. The possible
values of initType are defined in 
<a href=\"Modelica://Modelica.Blocks.Types.InitPID\">Modelica.Blocks.Types.InitPID</a>.
This type is identical to 
<a href=\"Modelica://Modelica.Blocks.Types.Init\">Types.Init</a>, 
with the only exception that the additional option
<b>DoNotUse_InitialIntegratorState</b> is added for
backward compatibility reasons (= integrator is initialized with
InitialState whereas differential part is initialized with
NoInit which was the initialization in version 2.2 of the Modelica
standard library).
</p>
 
<p>
Based on the setting of initType, the integrator (I) and derivative (D)
blocks inside the PID controller are initialized according to the following table:
</p>
 
<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>initType</b></td>
      <td valign=\"top\"><b>I.initType</b></td>
      <td valign=\"top\"><b>D.initType</b></td></tr>
 
  <tr><td valign=\"top\"><b>NoInit</b></td>
      <td valign=\"top\">NoInit</td>
      <td valign=\"top\">NoInit</td></tr>
 
  <tr><td valign=\"top\"><b>SteadyState</b></td>
      <td valign=\"top\">SteadyState</td>
      <td valign=\"top\">SteadyState</td></tr>
 
  <tr><td valign=\"top\"><b>InitialState</b></td>
      <td valign=\"top\">InitialState</td>
      <td valign=\"top\">InitialState</td></tr>
 
  <tr><td valign=\"top\"><b>InitialOutput</b><br>
          and initial equation: y = y_start</td>
      <td valign=\"top\">NoInit</td>
      <td valign=\"top\">SteadyState</td></tr>
 
  <tr><td valign=\"top\"><b>DoNotUse_InitialIntegratorState</b></td>
      <td valign=\"top\">InitialState</td>
      <td valign=\"top\">NoInit</td></tr>
</table>
 
<p>
In many cases, the most useful initial condition is
<b>SteadyState</b> because initial transients are then no longer
present. If initType = InitPID.SteadyState, then in some
cases difficulties might occur. The reason is the 
equation of the integrator:
</p>
 
<pre>
   <b>der</b>(y) = k*u;
</pre>
 
<p>
The steady state equation \"der(x)=0\" leads to the condition that the input u to the
integrator is zero. If the input u is already (directly or indirectly) defined
by another initial condition, then the initialization problem is <b>singular</b>
(has none or infinitely many solutions). This situation occurs often
for mechanical systems, where, e.g., u = desiredSpeed - measuredSpeed and
since speed is both a state and a derivative, it is natural to
initialize it with zero. As sketched this is, however, not possible.
The solution is to not initialize u_m or the variable that is used
to compute u_m by an algebraic equation.
</p>

<p>
If parameter <b>limitAtInit</b> = <b>false</b>, the limits at the
output of this controller block are removed from the initialization problem which 
leads to a much simpler equation system. After initialization has been
performed, it is checked via an assert whether the output is in the
defined limits. For backward compatibility reasons 
<b>limitAtInit</b> = <b>true</b>. In most cases it is best
to use <b>limitAtInit</b> = <b>false</b>.
</p>
</HTML>
"),       Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics));
        Blocks.Math.Add addP(k1=wp, k2=-1) 
          annotation (Placement(transformation(extent={{-80,40},{-60,60}}, rotation=
                 0)));
        Blocks.Math.Add addD(k1=wd, k2=-1) if with_D 
          annotation (Placement(transformation(extent={{-80,-10},{-60,10}},
                rotation=0)));
        Blocks.Math.Gain P annotation (Placement(transformation(extent={{-40,40},{
                  -20,60}}, rotation=0)));
        Blocks.Continuous.Integrator I(k=1/Ti, y_start=xi_start,
          initType=if initType==InitPID.SteadyState then 
                      InitPID.SteadyState else 
                   if initType==InitPID.InitialState or 
                      initType==InitPID.DoNotUse_InitialIntegratorState then 
                      InitPID.InitialState else InitPID.NoInit) if with_I 
          annotation (Placement(transformation(extent={{-40,-60},{-20,-40}},
                rotation=0)));
        Blocks.Continuous.Derivative D(k=Td, T=max([Td/Nd, 1.e-14]), x_start=xd_start,
          initType=if initType==InitPID.SteadyState or 
                      initType==InitPID.InitialOutput then InitPID.SteadyState else 
                   if initType==InitPID.InitialState then InitPID.InitialState else 
                      InitPID.NoInit) if with_D 
          annotation (Placement(transformation(extent={{-40,-10},{-20,10}},
                rotation=0)));
        Blocks.Math.Gain gainPID(k=k) annotation (Placement(transformation(extent={
                  {30,-10},{50,10}}, rotation=0)));
        Blocks.Math.Add3 addPID annotation (Evaluate=true, Placement(transformation(
                extent={{0,-10},{20,10}}, rotation=0)));
        Blocks.Math.Add3 addI(k2=-1) if with_I annotation (Evaluate=true, Placement(
              transformation(extent={{-80,-60},{-60,-40}}, rotation=0)));
        Blocks.Math.Add addSat(k1=+1, k2=-1) if 
                                         with_I 
          annotation (Evaluate=true, Placement(transformation(
              origin={80,-50},
              extent={{-10,-10},{10,10}},
              rotation=270)));
        Blocks.Math.Gain gainTrack(k=1/(k*Ni)) if with_I 
          annotation (Placement(transformation(extent={{40,-80},{20,-60}}, rotation=
                 0)));
        Blocks.Nonlinear.Limiter limiter(uMax=yMax, uMin=yMin, limitsAtInit=limitsAtInit) 
          annotation (Placement(transformation(extent={{70,-10},{90,10}}, rotation=
                  0)));
      protected
        parameter Boolean with_I = controllerType==SimpleController.PI or 
                                   controllerType==SimpleController.PID annotation(Evaluate=true, HideResult=true);
        parameter Boolean with_D = controllerType==SimpleController.PD or 
                                   controllerType==SimpleController.PID annotation(Evaluate=true, HideResult=true);
      public
        Sources.Constant Dzero(k=0) if not with_D 
          annotation (Placement(transformation(extent={{-30,20},{-20,30}}, rotation=
                 0)));
        Sources.Constant Izero(k=0) if not with_I 
          annotation (Placement(transformation(extent={{10,-55},{0,-45}}, rotation=
                  0)));
      initial equation
        if initType==InitPID.InitialOutput then
           y = y_start;
        end if;
      equation
        assert(yMax >= yMin, "LimPID: Limits must be consistent. However, yMax (=" + String(yMax) +
                             ") < yMin (=" + String(yMin) + ")");
        if initType == InitPID.InitialOutput and (y_start < yMin or y_start > yMax) then
            Modelica.Utilities.Streams.error("LimPID: Start value y_start (=" + String(y_start) +
               ") is outside of the limits of yMin (=" + String(yMin) +") and yMax (=" + String(yMax) + ")");
        end if;
        assert(limitsAtInit or not limitsAtInit and y >= yMin and y <= yMax,
               "LimPID: During initialization the limits have been switched off.\n" +
               "After initialization, the output y (=" + String(y) +
               ") is outside of the limits of yMin (=" + String(yMin) +") and yMax (=" + String(yMax) + ")");

        connect(u_s, addP.u1) annotation (Line(points={{-120,0},{-96,0},{-96,56},{
                -82,56}}, color={0,0,127}));
        connect(u_s, addD.u1) annotation (Line(points={{-120,0},{-96,0},{-96,6},{
                -82,6}}, color={0,0,127}));
        connect(u_s, addI.u1) annotation (Line(points={{-120,0},{-96,0},{-96,-42},{
                -82,-42}}, color={0,0,127}));
        connect(addP.y, P.u) annotation (Line(points={{-59,50},{-42,50}}, color={0,
                0,127}));
        connect(addD.y, D.u) 
          annotation (Line(points={{-59,0},{-42,0}}, color={0,0,127}));
        connect(addI.y, I.u) annotation (Line(points={{-59,-50},{-42,-50}}, color={
                0,0,127}));
        connect(P.y, addPID.u1) annotation (Line(points={{-19,50},{-10,50},{-10,8},
                {-2,8}}, color={0,0,127}));
        connect(D.y, addPID.u2) 
          annotation (Line(points={{-19,0},{-2,0}}, color={0,0,127}));
        connect(I.y, addPID.u3) annotation (Line(points={{-19,-50},{-10,-50},{-10,
                -8},{-2,-8}}, color={0,0,127}));
        connect(addPID.y, gainPID.u) 
          annotation (Line(points={{21,0},{28,0}}, color={0,0,127}));
        connect(gainPID.y, addSat.u2) annotation (Line(points={{51,0},{60,0},{60,
                -20},{74,-20},{74,-38}}, color={0,0,127}));
        connect(gainPID.y, limiter.u) 
          annotation (Line(points={{51,0},{68,0}}, color={0,0,127}));
        connect(limiter.y, addSat.u1) annotation (Line(points={{91,0},{94,0},{94,
                -20},{86,-20},{86,-38}}, color={0,0,127}));
        connect(limiter.y, y) 
          annotation (Line(points={{91,0},{110,0}}, color={0,0,127}));
        connect(addSat.y, gainTrack.u) annotation (Line(points={{80,-61},{80,-70},{
                42,-70}}, color={0,0,127}));
        connect(gainTrack.y, addI.u3) annotation (Line(points={{19,-70},{-88,-70},{
                -88,-58},{-82,-58}}, color={0,0,127}));
        connect(u_m, addP.u2) annotation (Line(
            points={{0,-120},{0,-92},{-92,-92},{-92,44},{-82,44}},
            color={0,0,127},
            thickness=0.5));
        connect(u_m, addD.u2) annotation (Line(
            points={{0,-120},{0,-92},{-92,-92},{-92,-6},{-82,-6}},
            color={0,0,127},
            thickness=0.5));
        connect(u_m, addI.u2) annotation (Line(
            points={{0,-120},{0,-92},{-92,-92},{-92,-50},{-82,-50}},
            color={0,0,127},
            thickness=0.5));
        connect(Dzero.y, addPID.u2) annotation (Line(points={{-19.5,25},{-14,25},{
                -14,0},{-2,0}}, color={0,0,127}));
        connect(Izero.y, addPID.u3) annotation (Line(points={{-0.5,-50},{-10,-50},{
                -10,-8},{-2,-8}}, color={0,0,127}));
      end LimPID;

      block TransferFunction "Linear transfer function"
        import Modelica.Blocks.Types.Init;
        extends Interfaces.SISO;

        parameter Real b[:]={1} "Numerator coefficients of transfer function" 
          annotation(Dialog(group="y = (2*s+3)/(4*s^2+5*s+6)*u is defined as b={2,3}, a={4,5,6}"));
        parameter Real a[:] "Denominator coefficients of transfer function" 
          annotation(Dialog(group="y = (2*s+3)/(4*s^2+5*s+6)*u is defined as b={2,3}, a={4,5,6}"));
        parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
          "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                           annotation(Evaluate=true, Dialog(group=
                "Initialization"));
        parameter Real x_start[size(a, 1) - 1]=zeros(nx)
          "Initial or guess values of states" 
          annotation (Dialog(group="Initialization"));
        parameter Real y_start=0
          "Initial value of output (derivatives of y are zero upto nx-1-th derivative)"
          annotation(Dialog(enable=initType == Init.InitialOutput, group=
                "Initialization"));
        output Real x[size(a, 1) - 1](start=x_start)
          "State of transfer function from controller canonical form";
      protected
        parameter Integer na=size(a, 1)
          "Size of Denominator of transfer function.";
        parameter Integer nb=size(b, 1)
          "Size of Numerator of transfer function.";
        parameter Integer nx=size(a, 1) - 1;
        parameter Real bb[:] = vector([zeros(max(0,na-nb),1);b]);
        parameter Real d = bb[1]/a[1];
        parameter Real a_end = if a[end] > 100*Modelica.Constants.eps*sqrt(a*a) then a[end] else 1.0;
        Real x_scaled[size(x,1)] "Scaled vector x";
        annotation (
          Documentation(info="<html>
<p>
This block defines the transfer function between the input
u and the output y
as (nb = dimension of b, na = dimension of a):
</p>
<pre>
           b[1]*s^[nb-1] + b[2]*s^[nb-2] + ... + b[nb]
   y(s) = --------------------------------------------- * u(s)
           a[1]*s^[na-1] + a[2]*s^[na-2] + ... + a[na]
</pre>
<p>
State variables <b>x</b> are defined according to <b>controller canonical</b>
form. Internally, vector <b>x</b> is scaled to improve the numerics (the states in versions before version 3.0 of the Modelica Standard Library have been not scaled). This scaling is
not visible from the outside of this block because the non-scaled vector <b>x</b>
is provided as output signal and the start value is with respect to the non-scaled
vector <b>x</b>.
Initial values of the states <b>x</b> can be set via parameter <b>x_start</b>.
</p>

<p>
Example:
</p>
<pre>
     TransferFunction g(b = {2,4}, a = {1,3});
</pre>
<p>
results in the following transfer function:
</p>
<pre>
        2*s + 4
   y = --------- * u
         s + 3
</pre>
</html>"),Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,0},{80,0}}, color={0,0,127}),
              Text(
                extent={{-90,10},{90,90}},
                textString="b(s)",
                lineColor={0,0,127}),
              Text(
                extent={{-90,-10},{90,-90}},
                textString="a(s)",
                lineColor={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{40,0},{-40,0}}, color={0,0,0}),
              Text(
                extent={{-55,55},{55,5}},
                lineColor={0,0,0},
                textString="b(s)"),
              Text(
                extent={{-55,-5},{55,-55}},
                lineColor={0,0,0},
                textString="a(s)"),
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Line(points={{-100,0},{-60,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255})}));

      initial equation
        if initType == Init.SteadyState then
          der(x_scaled) = zeros(nx);
        elseif initType == Init.InitialState then
          x_scaled = x_start*a_end;
        elseif initType == Init.InitialOutput then
          y = y_start;
          der(x_scaled[2:nx]) = zeros(nx-1);
        end if;
      equation
        assert(size(b,1) <= size(a,1), "Transfer function is not proper");
        if nx == 0 then
           y = d*u;
        else
           der(x_scaled[1])    = (-a[2:na]*x_scaled + a_end*u)/a[1];
           der(x_scaled[2:nx]) = x_scaled[1:nx-1];
           y = ((bb[2:na] - d*a[2:na])*x_scaled)/a_end + d*u;
           x = x_scaled/a_end;
        end if;
      end TransferFunction;

      block StateSpace "Linear state space system"
        import Modelica.Blocks.Types.Init;
        parameter Real A[:, size(A, 1)]
          "Matrix A of state space model (e.g. A=[1, 0; 0, 1])";
        parameter Real B[size(A, 1), :]
          "Matrix B of state space model (e.g. B=[1; 1])";
        parameter Real C[:, size(A, 1)]
          "Matrix C of state space model (e.g. C=[1, 1])";
        parameter Real D[size(C, 1), size(B, 2)]=zeros(size(C, 1), size(B, 2))
          "Matrix D of state space model";
        parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
          "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                                                                          annotation(Evaluate=true,
            Dialog(group="Initialization"));
        parameter Real x_start[nx]=zeros(nx)
          "Initial or guess values of states" 
          annotation (Dialog(group="Initialization"));
        parameter Real y_start[ny]=zeros(ny)
          "Initial values of outputs (remaining states are in steady state if possible)"
          annotation(Dialog(enable=initType == Init.InitialOutput, group=
                "Initialization"));

        extends Interfaces.MIMO(final nin=size(B, 2), final nout=size(C, 1));
        output Real x[size(A, 1)](start=x_start) "State vector";
        annotation (
          Documentation(info="<HTML>
<p>
The State Space block defines the relation
between the input u and the output
y in state space form:
</p>
<pre>
 
    der(x) = A * x + B * u
        y  = C * x + D * u
</pre>
<p>
The input is a vector of length nu, the output is a vector
of length ny and nx is the number of states. Accordingly
</p>
<pre>
        A has the dimension: A(nx,nx),
        B has the dimension: B(nx,nu),
        C has the dimension: C(ny,nx),
        D has the dimension: D(ny,nu)
</pre>
<p>
Example:
</p>
<pre>
     parameter: A = [0.12, 2;3, 1.5]
     parameter: B = [2, 7;3, 1]
     parameter: C = [0.1, 2]
     parameter: D = zeros(ny,nu)
results in the following equations:
  [der(x[1])]   [0.12  2.00] [x[1]]   [2.0  7.0] [u[1]]
  [         ] = [          ]*[    ] + [        ]*[    ]
  [der(x[2])]   [3.00  1.50] [x[2]]   [0.1  2.0] [u[2]]
                             [x[1]]            [u[1]]
       y[1]   = [0.1  2.0] * [    ] + [0  0] * [    ]
                             [x[2]]            [u[2]]
</pre>
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-90,10},{-10,90}},
                textString="A",
                lineColor={0,0,127}),
              Text(
                extent={{10,10},{90,90}},
                textString="B",
                lineColor={0,0,127}),
              Text(
                extent={{-90,-10},{-10,-90}},
                textString="C",
                lineColor={0,0,127}),
              Text(
                extent={{10,-10},{90,-90}},
                textString="D",
                lineColor={0,0,127}),
              Line(points={{0,-90},{0,90}}, color={192,192,192}),
              Line(points={{-90,0},{90,0}}, color={192,192,192})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Text(
                extent={{-60,40},{60,0}},
                lineColor={0,0,0},
                textString="sx=Ax+Bu"),
              Text(
                extent={{-60,0},{60,-40}},
                lineColor={0,0,0},
                textString=" y=Cx+Du"),
              Line(points={{-100,0},{-60,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255})}));

      protected
        parameter Integer nx = size(A, 1) "number of states";
        parameter Integer ny = size(C, 1) "number of outputs";
      initial equation
        if initType == Init.SteadyState then
          der(x) = zeros(nx);
        elseif initType == Init.InitialState then
          x = x_start;
        elseif initType == Init.InitialOutput then
          x = Modelica.Math.Matrices.equalityLeastSquares(A, -B*u, C, y_start - D*u);
        end if;
      equation
        der(x) = A*x + B*u;
        y = C*x + D*u;
      end StateSpace;

      block Der "Derivative of input (= analytic differentations)"
          extends Interfaces.SISO;

          annotation (defaultComponentName="der1",
       Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
              graphics={Text(
                extent={{-80,76},{80,-82}},
                textString="der()",
                lineColor={0,0,127})}),
              Documentation(info="<HTML>
<p>
Defines that the output y is the <i>derivative</i>
of the input u. Note, that Modelica.Blocks.Continuous.Derivative
computes the derivative in an approximate sense, where as this block computes
the derivative exactly. This requires that the input u is differentiated
by the Modelica translator, if this derivative is not yet present in
the model.
</p>
</HTML>"));
      equation
        y = der(u);
      end Der;

      block LowpassButterworth
        "Output the input signal filtered with a low pass Butterworth filter of any order"

        import Modelica.Math.*;
        import Modelica.Blocks.Types.Init;

        extends Modelica.Blocks.Interfaces.SISO;

        parameter Integer n(min=1) = 2 "Order of filter";
        parameter SI.Frequency f(start=1) "Cut-off frequency";
        parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
          "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                                                                          annotation(Evaluate=true,
            Dialog(group="Initialization"));
        parameter Real x1_start[m]=zeros(m)
          "Initial or guess values of states 1 (der(x1)=x2))" 
          annotation (Dialog(group="Initialization"));
        parameter Real x2_start[m]=zeros(m)
          "Initial or guess values of states 2" 
          annotation (Dialog(group="Initialization"));
        parameter Real xr_start=0.0
          "Initial or guess value of real pole for uneven order otherwise dummy"
          annotation (Dialog(group="Initialization"));
        parameter Real y_start=0.0
          "Initial value of output (states are initialized in steady state if possible)"
           annotation(Dialog(enable=initType == Init.InitialOutput, group=
                "Initialization"));

        output Real x1[m](start=x1_start)
          "states 1 of second order filters (der(x1) = x2)";
        output Real x2[m](start=x2_start) "states 2 of second order filters";
        output Real xr(start=xr_start)
          "state of real pole for uneven order otherwise dummy";
        annotation (
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Line(points={{-80,78},{-80,-90}}, color={192,192,192}),
              Polygon(
                points={{-79.5584,91.817},{-87.5584,69.817},{-71.5584,69.817},{-79.5584,
                    89.817},{-79.5584,91.817}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-72,-68.53},{-64,-39.5},{-56,-2.522},{-48,
                    32.75},{-40,58.8},{-32,71.51},{-24,70.49},{-16,58.45},{-8,40.06},
                    {0,20.55},{8,4.459},{16,-5.271},{24,-7.629},{32,-3.428},{40,
                    5.21},{48,15.56},{56,25.03},{64,31.66},{72,34.5},{80,33.61}},
                  color={0,0,127}),
              Line(points={{-90.9779,-80.7697},{81.0221,-80.7697}}, color={192,192,
                    192}),
              Polygon(
                points={{91.3375,-79.8233},{69.3375,-71.8233},{69.3375,-87.8233},{
                    91.3375,-79.8233}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-45.1735,-11.47},{92,-68}},
                lineColor={192,192,192},
                textString="LowpassButterworthFilter"),
              Text(
                extent={{8,-106},{8,-146}},
                lineColor={0,0,0},
                textString="f=%f"),
              Text(
                extent={{-2,94},{94,48}},
                lineColor={192,192,192},
                textString="%n")}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Line(points={{40,0},{-40,0}}, color={0,0,0}),
              Text(
                extent={{-55,55},{55,5}},
                lineColor={0,0,0},
                textString="1"),
              Text(
                extent={{-55,-5},{55,-55}},
                lineColor={0,0,0},
                textString="a(s)"),
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Line(points={{-100,0},{-60,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255})}),
          Documentation(info="<html>
<p>
This block defines the transfer function between the input u
and the output y as an n-th order low pass filter with <i>Butterworth</i>
characteristics and cut-off frequency f. It is implemented as
a series of second order filters and a first order filter.
Butterworth filters have the feature that the amplitude at the
cut-off frequency f is 1/sqrt(2) (= 3 dB), i.e., they are 
always \"normalized\". Step responses of the Butterworth filter of
different orders are shown in the next figure:
</p>

<p>
<img src=\"../Images/Blocks/Butterworth.png\">
</p>

<p>
If transients at the simulation start shall be avoided, the filter
should be initialized in steady state (e.g., using option
initType=Modelica.Blocks.Types.Init.SteadyState).
</p>


</html>
"));
      protected
        constant Real pi=Modelica.Constants.pi;
        parameter Integer m=integer(n/2);
        parameter Boolean evenOrder = 2*m == n;
        parameter Real w=2*pi*f;
        Real z[m + 1];
        Real polereal[m];
        Real poleimag[m];
        Real realpol;
        Real k2[m];
        Real D[m];
        Real w0[m];
        Real k1;
        Real T;
      initial equation
        if initType == Init.SteadyState then
          der(x1) = zeros(m);
          der(x2) = zeros(m);
          if not evenOrder then
            der(xr) = 0.0;
          end if;
        elseif initType == Init.InitialState then
          x1 = x1_start;
          x2 = x2_start;
          if not evenOrder then
            xr = xr_start;
          end if;
        elseif initType == Init.InitialOutput then
          y = y_start;
          der(x1) = zeros(m);
          if evenOrder then
            if m > 1 then
              der(x2[1:m-1]) = zeros(m-1);
            end if;
          else
            der(x1) = zeros(m);
          end if;
        end if;
      equation
        k2 = ones(m);
        k1 = 1;
        z[1] = u;

        // calculate filter parameters
        for i in 1:m loop
          // poles of prototype lowpass
          polereal[i] = cos(pi/2 + pi/n*(i - 0.5));
          poleimag[i] = sin(pi/2 + pi/n*(i - 0.5));
          // scaling and calculation of secon order filter coefficients
          w0[i] = (polereal[i]^2 + poleimag[i]^2)*w;
          D[i] = -polereal[i]/w0[i]*w;
        end for;
        realpol = 1*w;
        T = 1/realpol;

        // calculate second order filters
        for i in 1:m loop
          der(x1[i]) = x2[i];
          der(x2[i]) = k2[i]*w0[i]^2*z[i] - 2*D[i]*w0[i]*x2[i] - w0[i]^2*x1[i];
          z[i + 1] = x1[i];
        end for;

        // calculate first order filter if necessary
        if evenOrder then
          // even order
          xr = 0;
          y = z[m + 1];
        else
          // uneven order
          der(xr) = (k1*z[m + 1] - xr)/T;
          y = xr;
        end if;
      end LowpassButterworth;

      block CriticalDamping
        "Output the input signal filtered with an n-th order filter with critical damping"

        import Modelica.Blocks.Types.Init;
        extends Modelica.Blocks.Interfaces.SISO;

        parameter Integer n=2 "Order of filter";
        parameter Modelica.SIunits.Frequency f(start=1) "Cut-off frequency";
        parameter Boolean normalized = true
          "= true, if amplitude at f_cut is 3 dB, otherwise unmodified filter";
        parameter Modelica.Blocks.Types.Init initType=Modelica.Blocks.Types.Init.NoInit
          "Type of initialization (1: no init, 2: steady state, 3: initial state, 4: initial output)"
                                                                                          annotation(Evaluate=true,
            Dialog(group="Initialization"));
        parameter Real x_start[n]=zeros(n) "Initial or guess values of states" 
          annotation (Dialog(group="Initialization"));
        parameter Real y_start=0.0
          "Initial value of output (remaining states are in steady state)" 
          annotation(Dialog(enable=initType == Init.InitialOutput, group=
                "Initialization"));

        output Real x[n](start=x_start) "Filter states";
        annotation (
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Line(points={{-80.6897,77.6256},{-80.6897,-90.3744}}, color={192,192,
                    192}),
              Polygon(
                points={{-79.7044,90.6305},{-87.7044,68.6305},{-71.7044,68.6305},{-79.7044,
                    88.6305},{-79.7044,90.6305}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-80},{82,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-80},{68,-72},{68,-88},{90,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{0,0},{60,-60}},
                lineColor={192,192,192},
                textString="PTn"),
              Line(points={{-80.7599,-80.5082},{-70.7599,-74.5082},{-56,-60},{-48,-42},
                    {-42,-18},{-36,4},{-26,20},{-10.7599,34.9018},{-0.759907,
                    38.8218},{9.24009,41.6818},{19.2401,43.7818},{29.2401,45.3118},
                    {39.2401,46.4318},{49.2401,47.2518},{59.2401,47.8518},{69.2401,
                    48.2918},{79.2401,48.6118}}, color={0,0,127}),
              Text(
                extent={{-70,94},{26,48}},
                lineColor={192,192,192},
                textString="%n"),
              Text(
                extent={{8,-106},{8,-146}},
                lineColor={0,0,0},
                textString="f=%f")}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Line(points={{40,0},{-40,0}}, color={0,0,0}),
              Text(
                extent={{-55,55},{55,5}},
                lineColor={0,0,0},
                textString="1"),
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Line(points={{-100,0},{-60,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255}),
              Text(
                extent={{-54,-6},{44,-56}},
                lineColor={0,0,0},
                textString="(s/w + 1)"),
              Text(
                extent={{38,-10},{58,-30}},
                lineColor={0,0,0},
                textString="n")}),
          Documentation(info="<html>
<p>This block defines the transfer function between the
input u and the output y
as an n-th order filter with <i>critical damping</i>
characteristics and cut-off frequency f. It is
implemented as a series of first order filters.
This filter type is especially useful to filter the input of an
inverse model, since the filter does not introduce any transients.
</p>

<p>
If parameter <b>normalized</b> = <b>true</b> (default), the filter
is normalized such that the amplitude of the filter transfer function
at the cut-off frequency f is 1/sqrt(2) (= 3 dB). Otherwise, the filter
is not normalized, i.e., it is unmodified. A normalized filter is usually
much better for applications, since filters of different orders are
\"comparable\", whereas non-normalized filters usually require to adapt the
cut-off frequency, when the order of the filter is changed.
Figures of the filter step responses are shown below.
Note, in versions before version 3.0 of the Modelica Standard library,
the CriticalDamping filter was provided only in non-normalzed form.
</p>

<p>If transients at the simulation start shall be avoided, the filter
should be initialized in steady state (e.g., using option
initType=Modelica.Blocks.Types.Init.SteadyState).
</p>

<p>
The critical damping filter is defined as
</p>

<pre>
    &alpha; = <b>if</b> normalized <b>then</b> <b>sqrt</b>(2^(1/n) - 1) <b>else</b> 1 // frequency correction factor
    &omega; = 2*&pi;*f/&alpha;
              1
    y = ------------- * u
         (s/w + 1)^n

</pre>
 
<p>
<img src=\"../Images/Blocks/CriticalDampingNormalized.png\">
</p>

<p>
<img src=\"../Images/Blocks/CriticalDampingNonNormalized.png\">
</p>

</html>
"));
      protected
        parameter Real alpha=if normalized then sqrt(2^(1/n) - 1) else 1.0
          "Frequency correction factor for normalized filter";
        parameter Real w=2*Modelica.Constants.pi*f/alpha;
      initial equation
        if initType == Init.SteadyState then
          der(x) = zeros(n);
        elseif initType == Init.InitialState then
          x = x_start;
        elseif initType == Init.InitialOutput then
          y = y_start;
          der(x[1:n-1]) = zeros(n-1);
        end if;
      equation
        der(x[1]) = (u - x[1])*w;
        for i in 2:n loop
          der(x[i]) = (x[i - 1] - x[i])*w;
        end for;
        y = x[n];
      end CriticalDamping;

    end Continuous;

    package Discrete
      "Library of discrete input/output blocks with fixed sample period"

      extends Modelica.Icons.Library;

      annotation (Documentation(info="<html>
<p>
This package contains <b>discrete control blocks</b>
with <b>fixed sample period</b>.
Every component of this package is structured in the following way:
</p>
<ol>
<li> A component has <b>continuous real</b> input and output signals.</li>
<li> The <b>input</b> signals are <b>sampled</b> by the given sample period
     defined via parameter <b>samplePeriod</b>.
     The first sample instant is defined by parameter <b>startTime</b>.
<li> The <b>output</b> signals are computed from the sampled input signals.
</ol>
<p>
A <b>sampled data system</b> may consist of components of package <b>Discrete</b>
and of every other purely <b>algebraic</b> input/output block, such
as the components of packages <b>Modelica.Blocks.Math</b>,
<b>Modelica.Blocks.Nonlinear</b> or <b>Modelica.Blocks.Sources</b>.
</p>

</HTML>
",     revisions="<html>
<ul>
<li><i>October 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       New components TriggeredSampler and TriggeredMax added.</li>
<li><i>June 18, 2000</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized based on a corresponding library of Dieter Moormann and
       Hilding Elmqvist.</li>
</ul>
</html>"));

      block Sampler "Ideal sampling of continuous signals"
        extends Interfaces.DiscreteSISO;

        annotation (
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Ellipse(
                extent={{-25,-10},{-45,10}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{45,-10},{25,10}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{-45,0}}, color={0,0,127}),
              Line(points={{45,0},{100,0}}, color={0,0,127}),
              Line(points={{-35,0},{30,35}}, color={0,0,127})}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Ellipse(
                extent={{-25,-10},{-45,10}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{45,-10},{25,10}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{-45,0}}, color={0,0,255}),
              Line(points={{45,0},{100,0}}, color={0,0,255}),
              Line(points={{-35,0},{30,35}}, color={0,0,255})}),
          Documentation(info="<HTML>
<p>
Samples the continues input signal with a sampling rate defined
via parameter <b>samplePeriod</b>.
</p>
</HTML>
"));
      equation
        when {sampleTrigger, initial()} then
          y = u;
        end when;
      end Sampler;

      block ZeroOrderHold "Zero order hold of a sampled-data system"
        extends Interfaces.DiscreteSISO;
        output Real ySample(start=0, fixed=true);
        annotation (
          Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={Line(points={{-78,-42},{-52,-42},{-52,0},{-26,
                    0},{-26,24},{-6,24},{-6,64},{18,64},{18,20},{38,20},{38,0},{44,
                    0},{44,0},{62,0}}, color={0,0,127})}),
          Documentation(info="<HTML>
<p>
The output is identical to the sampled input signal at sample
time instants and holds the output at the value of the last
sample instant during the sample points.
</p>
</HTML>
"));

      equation
        when {sampleTrigger, initial()} then
          ySample = u;
        end when;
        /* Define y=ySample with an infinitesimal delay to break potential
       algebraic loops if both the continuous and the discrete part have
       direct feedthrough
    */
        y = pre(ySample);
      end ZeroOrderHold;

      block FirstOrderHold "First order hold of a sampled-data system"
        extends Interfaces.DiscreteSISO;
      protected
        Real ySample;
        Modelica.SIunits.Time tSample;
        Real c;
        annotation (
          Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={Line(points={{-79,-41},{-59,-33},{-40,1},{-20,
                    9},{0,63},{21,20},{41,10},{60,20}}, color={0,0,127}), Line(
                  points={{60,19},{81,10}}, color={0,0,255})}),
          Documentation(info="<HTML>
<p>
The output signal is the extrapolation through the
values of the last two sampled input signals.
</p>
</HTML>
"));

      equation
        when sampleTrigger then
          ySample = u;
          tSample = time;
          c = if firstTrigger then 0 else (ySample - pre(ySample))/samplePeriod;
        end when;
        /* Use pre(ySample) and pre(c) to break potential algebraic loops by an
       infinitesimal delay if both the continuous and the discrete part
       have direct feedthrough.
    */
        y = pre(ySample) + pre(c)*(time - tSample);
      end FirstOrderHold;

      block UnitDelay "Unit Delay Block"
        parameter Real y_start=0 "Initial value of output signal";
        extends Interfaces.DiscreteSISO;

        annotation (
          Documentation(info="<html>
<p>
This block describes a unit delay:
</p>
<pre>
          1
     y = --- * u
          z
</pre>
<p>
that is, the output signal y is the input signal u of the
previous sample instant. Before the second sample instant,
the output y is identical to parameter yStart.
</p>

</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-30,0},{30,0}}, color={0,0,127}),
              Text(
                extent={{-90,10},{90,90}},
                textString="1",
                lineColor={0,0,127}),
              Text(
                extent={{-90,-10},{90,-90}},
                textString="z",
                lineColor={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Text(
                extent={{-160,10},{-140,-10}},
                textString="u",
                lineColor={0,0,255}),
              Text(
                extent={{115,10},{135,-10}},
                textString="y",
                lineColor={0,0,255}),
              Line(points={{-100,0},{-60,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255}),
              Line(points={{40,0},{-40,0}}, color={0,0,0}),
              Text(
                extent={{-55,55},{55,5}},
                lineColor={0,0,0},
                textString="1"),
              Text(
                extent={{-55,-5},{55,-55}},
                lineColor={0,0,0},
                textString="z")}));

      equation
        when sampleTrigger then
          y = pre(u);
        end when;

      initial equation
          y = y_start;
      end UnitDelay;

      block TransferFunction "Discrete Transfer Function block"
        parameter Real b[:]={1} "Numerator coefficients of transfer function.";
        parameter Real a[:] "Denominator coefficients of transfer function.";
        extends Interfaces.DiscreteSISO;
        output Real x[size(a, 1) - 1](each start=0, each fixed=true)
          "State of transfer function from controller canonical form";
      protected
        parameter Integer nb=size(b, 1)
          "Size of Numerator of transfer function";
        parameter Integer na=size(a, 1)
          "Size of Denominator of transfer function";
        Real x1;
        Real xext[size(a, 1)];
        annotation (
          Documentation(info="<html>
<p>The <b>discrete transfer function</b> block defines the
transfer function between the input signal u and the output
signal y. The numerator has the order nb-1, the denominator
has the order na-1.</p>
<pre>          b(1)*z^(nb-1) + b(2)*z^(nb-2) + ... + b(nb)
   y(z) = -------------------------------------------- * u(z)
          a(1)*z^(na-1) + a(2)*z^(na-2) + ... + a(na)
</pre>
<p>State variables <b>x</b> are defined according to
<b>controller canonical</b> form. Initial values of the
states can be set as start values of <b>x</b>.<p>
<p>Example:</p>
<pre>     Blocks.Discrete.TransferFunction g(b = {2,4}, a = {1,3});
</pre>
<p>results in the following transfer function:</p>
<pre>        2*z + 4
   y = --------- * u
         z + 3
</pre>

</HTML>
",     revisions="<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>November 15, 2000</i>
    by <a href=\"http://www.dynasim.se\">Hans Olsson</a>:<br>
    Converted to when-semantics of Modelica 1.4 with special
    care to avoid unnecessary algebraic loops.</li>
<li><i>June 18, 2000</i>
    by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
    Realized based on a corresponding model of Dieter Moormann
    and Hilding Elmqvist.</li>
</ul>
</html>"),Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{82,0},{-84,0}}, color={0,0,127}),
              Text(
                extent={{-92,92},{86,12}},
                lineColor={0,0,127},
                textString="b(z)"),
              Text(
                extent={{-90,-12},{90,-90}},
                lineColor={0,0,127},
                textString="a(z)")}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Line(
                points={{40,0},{-44,0}},
                color={0,0,0},
                thickness=0.5),
              Text(
                extent={{-54,54},{54,4}},
                lineColor={0,0,0},
                textString="b(z)"),
              Text(
                extent={{-54,-6},{56,-56}},
                lineColor={0,0,0},
                textString="a(z)"),
              Line(points={{-100,0},{-60,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255})}));

      equation
        when sampleTrigger then
          /* State variables x are defined according to
       controller canonical form. */
          x1 = (u - a[2:size(a, 1)]*pre(x))/a[1];
          xext = vector([x1; pre(x)]);
          x = xext[1:size(x, 1)];
          y = vector([zeros(na - nb, 1); b])*xext;
        end when;
        /* This is a non-sampled equation and above there are two separate
       when-clauses. This breaks feeback loops without direct terms,
       since in that case y will be independent of x1 (and only dependent
       on pre(x)).
    */
        /* Corresponding (simpler) version using when-semantics of Modelica 1.3:
   equation
     when sampleTrigger then
      [x; xn] = [x1; pre(x)];
      [u] = transpose([a])*[x1; pre(x)];
      [y] = transpose([zeros(na - nb, 1); b])*[x1; pre(x)];
     end when;
*/
      end TransferFunction;

      block StateSpace "Discrete State Space block"
        parameter Real A[:, size(A, 1)] "Matrix A of state space model";
        parameter Real B[size(A, 1), :] "Matrix B of state space model";
        parameter Real C[:, size(A, 1)] "Matrix C of state space model";
        parameter Real D[size(C, 1), size(B, 2)]=zeros(size(C, 1), size(B, 2))
          "Matrix D of state space model";

        extends Interfaces.DiscreteMIMO(final nin=size(B, 2), final nout=size(C, 1));
        output Real x[size(A, 1)] "State vector";

        annotation (
          Documentation(info="<html>
<p>
The <b>discrete state space</b> block defines the relation
between the input u=inPort.signal and the output
y=outPort.signal in state space form:
</p>
<pre>
    x = A * pre(x) + B * u
    y = C * pre(x) + D * u
</pre>
<p>
where pre(x) is the value of the discrete state x at
the previous sample time instant.
The input is a vector of length nu, the output is a vector
of length ny and nx is the number of states. Accordingly
</p>
<pre>
        A has the dimension: A(nx,nx),
        B has the dimension: B(nx,nu),
        C has the dimension: C(ny,nx),
        D has the dimension: D(ny,nu)
</pre>
<p>
Example:
</p>
<pre>
     parameter: A = [0.12, 2;3, 1.5]
     parameter: B = [2, 7;3, 1]
     parameter: C = [0.1, 2]
     parameter: D = zeros(ny,nu)

results in the following equations:
  [x[1]]   [0.12  2.00] [pre(x[1])]   [2.0  7.0] [u[1]]
  [    ] = [          ]*[         ] + [        ]*[    ]
  [x[2]]   [3.00  1.50] [pre(x[2])]   [0.1  2.0] [u[2]]
                             [pre(x[1])]            [u[1]]
       y[1]   = [0.1  2.0] * [         ] + [0  0] * [    ]
                             [pre(x[2])]            [u[2]]
</pre>
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-90,15},{-15,90}},
                textString="A",
                lineColor={0,0,127}),
              Text(
                extent={{15,15},{90,90}},
                textString="B",
                lineColor={0,0,127}),
              Text(
                extent={{-52,28},{54,-20}},
                textString="z",
                lineColor={0,0,127}),
              Text(
                extent={{-90,-15},{-15,-90}},
                textString="C",
                lineColor={0,0,127}),
              Text(
                extent={{15,-15},{90,-90}},
                textString="D",
                lineColor={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
              Text(
                extent={{-54,50},{52,-10}},
                lineColor={0,0,0},
                fillColor={128,128,128},
                fillPattern=FillPattern.None,
                textString="zx=Ax+Bu"),
              Text(
                extent={{-56,14},{54,-50}},
                lineColor={0,0,0},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid,
                textString="  y=Cx+Du"),
              Line(points={{-102,0},{-60,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255})}));

      equation
        when sampleTrigger then
          x = A*pre(x) + B*u;
          y = C*pre(x) + D*u;
        end when;
      end StateSpace;

      block TriggeredSampler "Triggered sampling of continuous signals"
        extends Interfaces.DiscreteBlockIcon;
        parameter Real y_start=0 "initial value of output signal";

        annotation (
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Ellipse(
                extent={{-25,-10},{-45,10}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{45,-10},{25,10}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{-45,0}}, color={0,0,127}),
              Line(points={{45,0},{100,0}}, color={0,0,127}),
              Line(points={{0,-100},{0,-26}}, color={255,0,255}),
              Line(points={{-35,0},{28,-48}}, color={0,0,127})}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Ellipse(
                extent={{-25,-10},{-45,10}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{45,-10},{25,10}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{-45,0}}, color={0,0,255}),
              Line(points={{45,0},{100,0}}, color={0,0,255}),
              Line(points={{-35,0},{28,-48}}, color={0,0,255}),
              Line(points={{0,-100},{0,-26}}, color={255,0,255})}),
          Documentation(info="<HTML>
<p>
Samples the continuous input signal whenever the trigger input
signal is rising (i.e., trigger changes from <b>false</b> to
<b>true</b>) and provides the sampled input signal as output.
Before the first sampling, the output signal is equal to
the initial value defined via parameter <b>y0</b>.
</p>
</HTML>
"));
        Modelica.Blocks.Interfaces.RealInput u
          "Connector with a Real input signal"                annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y
          "Connector with a Real output signal"                annotation (Placement(
              transformation(extent={{100,-10},{120,10}}, rotation=0)));
        Modelica.Blocks.Interfaces.BooleanInput trigger annotation (Placement(
              transformation(
              origin={0,-118},
              extent={{-20,-20},{20,20}},
              rotation=90)));
      equation
        when trigger then
          y = u;
        end when;
      initial equation
        y = y_start;
      end TriggeredSampler;

      block TriggeredMax
        "Compute maximum, absolute value of continuous signal at trigger instants"

        extends Interfaces.DiscreteBlockIcon;
        annotation (
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Ellipse(
                extent={{-25,-10},{-45,10}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{45,-10},{25,10}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{-45,0}}, color={0,0,127}),
              Line(points={{45,0},{100,0}}, color={0,0,127}),
              Line(points={{0,-100},{0,-26}}, color={255,0,255}),
              Line(points={{-35,0},{28,-48}}, color={0,0,127}),
              Text(
                extent={{-86,82},{82,24}},
                lineColor={0,0,0},
                textString="max")}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Ellipse(
                extent={{-25,-10},{-45,10}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{45,-10},{25,10}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{-45,0}}, color={0,0,255}),
              Line(points={{45,0},{100,0}}, color={0,0,255}),
              Line(points={{-35,0},{28,-48}}, color={0,0,255}),
              Line(points={{0,-100},{0,-26}}, color={255,0,255})}),
          Documentation(info="<HTML>
<p>
Samples the continuous input signal whenever the trigger input
signal is rising (i.e., trigger changes from <b>false</b> to
<b>true</b>). The maximum, absolute value of the input signal
at the sampling point is provided as output signal.
</p>
</HTML>
"));
        Modelica.Blocks.Interfaces.RealInput u
          "Connector with a Real input signal" annotation (Placement(transformation(
                extent={{-140,-20},{-100,20}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y
          "Connector with a Real output signal" annotation (Placement(
              transformation(extent={{100,-10},{120,10}}, rotation=0)));
        Modelica.Blocks.Interfaces.BooleanInput trigger annotation (Placement(
              transformation(
              origin={0,-118},
              extent={{-20,-20},{20,20}},
              rotation=90)));
      equation
        when trigger then
           y = max(pre(y), abs(u));
        end when;
      initial equation
        y = 0;
      end TriggeredMax;
    end Discrete;

    package Interfaces
      "Library of connectors and partial models for input/output blocks"
      import Modelica.SIunits;
        extends Modelica.Icons.Library;

        annotation (
          Documentation(info="<HTML>
<p>
This package contains interface definitions for
<b>continuous</b> input/output blocks with Real,
Integer and Boolean signals. Furthermore, it contains
partial models for continuous and discrete blocks.
</p>

</HTML>
",     revisions="<html>
<ul>
<li><i>Oct. 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
       and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       Added several new interfaces. <a href=\"../Documentation/ChangeNotes1.5.html\">Detailed description</a> available.
<li><i>Oct. 24, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       RealInputSignal renamed to RealInput. RealOutputSignal renamed to
       output RealOutput. GraphBlock renamed to BlockIcon. SISOreal renamed to
       SISO. SOreal renamed to SO. I2SOreal renamed to M2SO.
       SignalGenerator renamed to SignalSource. Introduced the following
       new models: MIMO, MIMOs, SVcontrol, MVcontrol, DiscreteBlockIcon,
       DiscreteBlock, DiscreteSISO, DiscreteMIMO, DiscreteMIMOs,
       BooleanBlockIcon, BooleanSISO, BooleanSignalSource, MI2BooleanMOs.</li>
<li><i>June 30, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized a first version, based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist.</li>
</ul>
</html>
"));

    connector RealInput = input Real "'input Real' as connector" 
      annotation (defaultComponentName="u",
      Icon(graphics={Polygon(
              points={{-100,100},{100,0},{-100,-100},{-100,100}},
              lineColor={0,0,127},
              fillColor={0,0,127},
              fillPattern=FillPattern.Solid)},
           coordinateSystem(extent={{-100,-100},{100,100}}, preserveAspectRatio=true, initialScale=0.2)),
      Diagram(coordinateSystem(
            preserveAspectRatio=true, initialScale=0.2,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={Polygon(
              points={{0,50},{100,0},{0,-50},{0,50}},
              lineColor={0,0,127},
              fillColor={0,0,127},
              fillPattern=FillPattern.Solid), Text(
              extent={{-10,85},{-10,60}},
              lineColor={0,0,127},
              textString="%name")}),
        Documentation(info="<html>
<p>
Connector with one input signal of type Real.
</p>
</html>"));

    connector RealOutput = output Real "'output Real' as connector" 
      annotation (defaultComponentName="y",
      Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={Polygon(
              points={{-100,100},{100,0},{-100,-100},{-100,100}},
              lineColor={0,0,127},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid)}),
      Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={Polygon(
              points={{-100,50},{0,0},{-100,-50},{-100,50}},
              lineColor={0,0,127},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid), Text(
              extent={{30,110},{30,60}},
              lineColor={0,0,127},
              textString="%name")}),
        Documentation(info="<html>
<p>
Connector with one output signal of type Real.
</p>
</html>"));

    connector BooleanInput = input Boolean "'input Boolean' as connector" 
      annotation (defaultComponentName="u",
           Icon(graphics={Polygon(
              points={{-100,100},{100,0},{-100,-100},{-100,100}},
              lineColor={255,0,255},
              fillColor={255,0,255},
              fillPattern=FillPattern.Solid)},
                coordinateSystem(extent={{-100,-100},{100,100}},
            preserveAspectRatio=true, initialScale=0.2)),    Diagram(coordinateSystem(
            preserveAspectRatio=true, initialScale=0.2,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={Polygon(
              points={{0,50},{100,0},{0,-50},{0,50}},
              lineColor={255,0,255},
              fillColor={255,0,255},
              fillPattern=FillPattern.Solid), Text(
              extent={{-10,85},{-10,60}},
              lineColor={255,0,255},
              textString="%name")}),
        Documentation(info="<html>
<p>
Connector with one input signal of type Boolean.
</p>
</html>"));

    connector BooleanOutput = output Boolean "'output Boolean' as connector" 
                                      annotation (defaultComponentName="y",
      Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={Polygon(
              points={{-100,100},{100,0},{-100,-100},{-100,100}},
              lineColor={255,0,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid)}),
      Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={Polygon(
              points={{-100,50},{0,0},{-100,-50},{-100,50}},
              lineColor={255,0,255},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid), Text(
              extent={{30,110},{30,60}},
              lineColor={255,0,255},
              textString="%name")}),
        Documentation(info="<html>
<p>
Connector with one output signal of type Boolean.
</p>
</html>"));

    connector IntegerInput = input Integer "'input Integer' as connector" 
      annotation (defaultComponentName="u",
      Icon(graphics={Polygon(
              points={{-100,100},{100,0},{-100,-100},{-100,100}},
              lineColor={255,127,0},
              fillColor={255,127,0},
              fillPattern=FillPattern.Solid)},
           coordinateSystem(extent={{-100,-100},{100,100}}, preserveAspectRatio=true,
                     initialScale=0.2)),
      Diagram(coordinateSystem(
            preserveAspectRatio=true, initialScale=0.2,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={Polygon(
              points={{0,50},{100,0},{0,-50},{0,50}},
              lineColor={255,127,0},
              fillColor={255,127,0},
              fillPattern=FillPattern.Solid), Text(
              extent={{-10,85},{-10,60}},
              lineColor={255,127,0},
              textString="%name")}),
        Documentation(info="<html>
<p>
Connector with one input signal of type Integer.
</p>
</html>"));

    connector IntegerOutput = output Integer "'output Integer' as connector" 
                                      annotation (defaultComponentName="y",
      Icon(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={Polygon(
              points={{-100,100},{100,0},{-100,-100},{-100,100}},
              lineColor={255,127,0},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid)}),
      Diagram(coordinateSystem(
            preserveAspectRatio=true,
            extent={{-100,-100},{100,100}},
            grid={1,1}), graphics={Polygon(
              points={{-100,50},{0,0},{-100,-50},{-100,50}},
              lineColor={255,127,0},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid), Text(
              extent={{30,110},{30,60}},
              lineColor={255,127,0},
              textString="%name")}),
        Documentation(info="<html>
<p>
Connector with one output signal of type Integer.
</p>
</html>"));

        partial block BlockIcon "Basic graphical layout of input/output block"

          annotation (
            Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                  {100,100}}), graphics={Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid), Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255})}),
          Documentation(info="<html>
<p>
Block that has only the basic icon for an input/output
block (no declarations, no equations). Most blocks
of package Modelica.Blocks inherit directly or indirectly
from this block.
</p>
</html>"));

        end BlockIcon;

        partial block SO "Single Output continuous control block"
          extends BlockIcon;

          RealOutput y "Connector of Real output signal" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
          annotation (
            Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics),
          Documentation(info="<html>
<p>
Block has one continuous Real output signal.
</p>
</html>"));

        end SO;

        partial block MO "Multiple Output continuous control block"
          extends BlockIcon;

          parameter Integer nout(min=1) = 1 "Number of outputs";
          RealOutput y[nout] "Connector of Real output signals" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
          annotation (
            Documentation(info="<html>
<p>
Block has one continuous Real output signal vector.
</p>
</html>"));

        end MO;

        partial block SISO
        "Single Input Single Output continuous control block"
          extends BlockIcon;

          RealInput u "Connector of Real input signal" 
            annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
          RealOutput y "Connector of Real output signal" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
          annotation (
          Documentation(info="<html>
<p>
Block has one continuous Real input and one continuous Real output signal.
</p>
</html>"));
        end SISO;

        partial block SI2SO
        "2 Single Input / 1 Single Output continuous control block"
          extends BlockIcon;

          RealInput u1 "Connector of Real input signal 1" 
            annotation (Placement(transformation(extent={{-140,40},{-100,80}},
                rotation=0)));
          RealInput u2 "Connector of Real input signal 2" 
            annotation (Placement(transformation(extent={{-140,-80},{-100,-40}},
                rotation=0)));
          RealOutput y "Connector of Real output signal" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));

          annotation (
            Documentation(info="<html>
<p>
Block has two continuous Real input signals u1 and u2 and one
continuous Real output signal y.
</p>
</html>"),  Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics));

        end SI2SO;

    partial block SIMO "Single Input Multiple Output continuous control block"
      extends BlockIcon;
      parameter Integer nout=1 "Number of outputs";
          RealInput u "Connector of Real input signal" 
            annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
          RealOutput y[nout] "Connector of Real output signals" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));

      annotation (Documentation(info="<HTML>
<p> Block has one continuous Real input signal and a
    vector of continuous Real output signals.</p>

</HTML>
"));
    end SIMO;

        partial block MISO
        "Multiple Input Single Output continuous control block"

          extends BlockIcon;
          parameter Integer nin=1 "Number of inputs";
          RealInput u[nin] "Connector of Real input signals" 
            annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
          RealOutput y "Connector of Real output signal" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
          annotation (Documentation(info="<HTML>
<p>
Block has a vector of continuous Real input signals and
one continuous Real output signal.
</p>
</HTML>
"));
        end MISO;

        partial block MIMO
        "Multiple Input Multiple Output continuous control block"

          extends BlockIcon;
          parameter Integer nin=1 "Number of inputs";
          parameter Integer nout=1 "Number of outputs";
          RealInput u[nin] "Connector of Real input signals" 
            annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
          RealOutput y[nout] "Connector of Real output signals" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
          annotation (Documentation(info="<HTML>
<p>
Block has a continuous Real input and a continuous Real output signal vector.
The signal sizes of the input and output vector may be different.
</p>
</HTML>
"));
        end MIMO;

        partial block MIMOs
        "Multiple Input Multiple Output continuous control block with same number of inputs and outputs"

          extends BlockIcon;
          parameter Integer n=1 "Number of inputs (= number of outputs)";
          RealInput u[n] "Connector of Real input signals" 
            annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
          RealOutput y[n] "Connector of Real output signals" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
          annotation (
            Documentation(info="<HTML>
<p>
Block has a continuous Real input and a continuous Real output signal vector
where the signal sizes of the input and output vector are identical.
</p>
</HTML>
"));
        end MIMOs;

        partial block MI2MO
        "2 Multiple Input / Multiple Output continuous control block"
          extends BlockIcon;

          parameter Integer n=1 "Dimension of input and output vectors.";

          RealInput u1[n] "Connector 1 of Real input signals" 
            annotation (Placement(transformation(extent={{-140,40},{-100,80}},
                rotation=0)));
          RealInput u2[n] "Connector 2 of Real input signals" 
            annotation (Placement(transformation(extent={{-140,-80},{-100,-40}},
                rotation=0)));
          RealOutput y[n] "Connector of Real output signals" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
          annotation (
            Documentation(info="<html>
<p>
Block has two continuous Real input vectors u1 and u2 and one
continuous Real output vector y.
All vectors have the same number of elements.
</p>
</html>"),  Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics));

        end MI2MO;

        partial block SignalSource "Base class for continuous signal source"
          extends SO;
          parameter Real offset=0 "Offset of output signal y";
          parameter SIunits.Time startTime=0
          "Output y = offset for time < startTime";
        annotation (Documentation(info="<html>
<p>
Basic block for Real sources of package Blocks.Sources.
This component has one continuous Real output signal y
and two parameters (offset, startTime) to shift the
generated signal.
</p>
</html>"));
        end SignalSource;

        partial block SVcontrol "Single-Variable continuous controller"
          extends BlockIcon;

          RealInput u_s "Connector of setpoint input signal" 
            annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
          RealInput u_m "Connector of measurement input signal" 
            annotation (Placement(transformation(
              origin={0,-120},
              extent={{20,-20},{-20,20}},
              rotation=270)));
          RealOutput y "Connector of actuator output signal" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
          annotation (
            Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-102,34},{-142,24}},
                textString="(setpoint)",
                lineColor={0,0,255}),
              Text(
                extent={{100,24},{140,14}},
                textString="(actuator)",
                lineColor={0,0,255}),
              Text(
                extent={{-83,-112},{-33,-102}},
                textString=" (measurement)",
                lineColor={0,0,255})}),
          Documentation(info="<html>
<p>
Block has two continuous Real input signals and one
continuous Real output signal. The block is designed
to be used as base class for a corresponding controller.
</p>
</html>"));
        end SVcontrol;

        partial block MVcontrol "Multi-Variable continuous controller"
          extends BlockIcon;

          parameter Integer nu_s=1 "Number of setpoint inputs";
          parameter Integer nu_m=1 "Number of measurement inputs";
          parameter Integer ny=1 "Number of actuator outputs";
          RealInput u_s[nu_s] "Connector of setpoint input signals" 
            annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
          RealInput u_m[nu_m] "Connector of measurement input signals" 
            annotation (Placement(transformation(
              origin={0,-120},
              extent={{20,-20},{-20,20}},
              rotation=270)));
          RealOutput y[ny] "Connector of actuator output signals" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
          annotation (
            Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-100,36},{-140,26}},
                textString="(setpoint)",
                lineColor={0,0,255}),
              Text(
                extent={{102,24},{142,14}},
                textString="(actuator)",
                lineColor={0,0,255}),
              Text(
                extent={{-75,-108},{-25,-98}},
                textString=" (measurement)",
                lineColor={0,0,255})}),
          Documentation(info="<html>
<p>
Block has two continuous Real input signal vectors and one
continuous Real output signal vector. The block is designed
to be used as base class for a corresponding controller.
</p>
</html>"));
        end MVcontrol;

        partial block DiscreteBlockIcon
        "Graphical layout of discrete block component icon"

          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,127},
                fillColor={223,223,159},
                fillPattern=FillPattern.Solid), Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255})}),
                               Documentation(info="<html>
<p>
Block that has only the basic icon for an input/output,
discrete block (no declarations, no equations), e.g.,
from Blocks.Discrete.
</p>
</html>"));
        equation

        end DiscreteBlockIcon;

        partial block DiscreteBlock "Base class of discrete control blocks"
          extends DiscreteBlockIcon;

          parameter SI.Time samplePeriod(min=100*Modelica.Constants.eps, start = 0.1)
          "Sample period of component";
          parameter SI.Time startTime=0 "First sample time instant";
      protected
          output Boolean sampleTrigger "True, if sample time instant";
          output Boolean firstTrigger
          "Rising edge signals first sample instant";
        equation
          sampleTrigger = sample(startTime, samplePeriod);
          when sampleTrigger then
            firstTrigger = time <= startTime + samplePeriod/2;
          end when;
        annotation (Documentation(info="<html>
<p>
Basic definitions of a discrete block of library
Blocks.Discrete.
</p>
</html>"));
        end DiscreteBlock;

        partial block DiscreteSISO
        "Single Input Single Output discrete control block"

          extends DiscreteBlock;

          Modelica.Blocks.Interfaces.RealInput u "Continuous input signal" 
                                      annotation (Placement(transformation(extent={
                  {-140,-20},{-100,20}}, rotation=0)));
          Modelica.Blocks.Interfaces.RealOutput y "Continuous output signal" 
                                       annotation (Placement(transformation(extent=
                  {{100,-10},{120,10}}, rotation=0)));
        annotation (Documentation(info="<html>
<p>
Block has one continuous input and one continuous output signal
which are sampled due to the defined <b>samplePeriod</b> parameter.
</p>
</html>"));
        end DiscreteSISO;

        partial block DiscreteMIMO
        "Multiple Input Multiple Output discrete control block"

          extends DiscreteBlock;
          parameter Integer nin=1 "Number of inputs";
          parameter Integer nout=1 "Number of outputs";

          Modelica.Blocks.Interfaces.RealInput u[nin]
          "Continuous input signals"   annotation (Placement(transformation(extent=
                  {{-140,-20},{-100,20}}, rotation=0)));
          Modelica.Blocks.Interfaces.RealOutput y[nout]
          "Continuous output signals"   annotation (Placement(transformation(extent=
                 {{100,-10},{120,10}}, rotation=0)));

          annotation (Documentation(info="<html>
<p>
Block has a continuous input and a continuous output signal vector
which are sampled due to the defined <b>samplePeriod</b> parameter.
</p>
</HTML>
"));
        end DiscreteMIMO;

        partial block DiscreteMIMOs
        "Multiple Input Multiple Output discrete control block"
          parameter Integer n=1 "Number of inputs (= number of outputs)";
          extends DiscreteBlock;

          Modelica.Blocks.Interfaces.RealInput u[n] "Continuous input signals" 
                                       annotation (Placement(transformation(extent=
                  {{-140,-20},{-100,20}}, rotation=0)));
          Modelica.Blocks.Interfaces.RealOutput y[n]
          "Continuous output signals"   annotation (Placement(transformation(extent=
                 {{100,-10},{120,10}}, rotation=0)));

          annotation (Documentation(info="<html>
<p>
Block has a continuous input and a continuous output signal vector
where the signal sizes of the input and output vector are identical.
These signals are sampled due to the defined <b>samplePeriod</b> parameter.
</p>
</HTML>
"));

        end DiscreteMIMOs;

        partial block SVdiscrete "Discrete Single-Variable controller"
          extends DiscreteBlock;

          Discrete.Sampler sampler_s(
            final samplePeriod=samplePeriod,
            final startTime=startTime) annotation (Placement(transformation(extent=
                  {{-100,-10},{-80,10}}, rotation=0)));
          Discrete.Sampler sampler_m(
            final samplePeriod=samplePeriod,
            final startTime=startTime) annotation (Placement(transformation(
              origin={0,-90},
              extent={{-10,-10},{10,10}},
              rotation=90)));
          Modelica.Blocks.Interfaces.RealInput u_s
          "Continuous scalar setpoint input signal"   annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
          Modelica.Blocks.Interfaces.RealInput u_m
          "Continuous scalar measurement input signal"   annotation (Placement(
              transformation(
              origin={0,-120},
              extent={{20,-20},{-20,20}},
              rotation=270)));
          Modelica.Blocks.Interfaces.RealOutput y
          "Continuous scalar actuator output signal"   annotation (Placement(
              transformation(extent={{100,-10},{120,10}}, rotation=0)));
          annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Text(
                extent={{-100,34},{-140,24}},
                lineColor={0,0,0},
                textString="(setpoint)"),
              Text(
                extent={{100,22},{130,14}},
                lineColor={0,0,0},
                textString="(actuator)"),
              Text(
                extent={{-70,-112},{-20,-102}},
                lineColor={0,0,0},
                textString=" (measurement)")}),
                                  Documentation(info="<html>
<p>
Block has two continuous Real input signals and one
continuous Real output signal
that are sampled due to the defined <b>samplePeriod</b> parameter.
The block is designed
to be used as base class for a corresponding controller.
</p>
</html>"));
        equation
          connect(u_s, sampler_s.u)           annotation (Line(points={{-120,0},{
                -102,0}}));
          connect(u_m, sampler_m.u)           annotation (Line(points={{0,-120},{0,
                -111},{0,-102},{-7.34788e-016,-102}}));
        end SVdiscrete;

        partial block MVdiscrete "Discrete Multi-Variable controller"
          extends DiscreteBlock;
          parameter Integer nu_s=1 "Number of setpoint inputs";
          parameter Integer nu_m=1 "Number of measurement inputs";
          parameter Integer ny=1 "Number of actuator outputs";
          Discrete.Sampler sampler_s[nu_s](
            each final samplePeriod=samplePeriod,
            each final startTime=startTime) 
                                       annotation (Placement(transformation(extent=
                  {{-90,-10},{-70,10}}, rotation=0)));
          Discrete.Sampler sampler_m[nu_m](
            each final samplePeriod=samplePeriod,
            each final startTime=startTime) 
                                       annotation (Placement(transformation(
              origin={0,-80},
              extent={{-10,-10},{10,10}},
              rotation=90)));
          Modelica.Blocks.Interfaces.RealInput u_s[nu_s]
          "Continuous setpoint input signals"   annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
          Modelica.Blocks.Interfaces.RealInput u_m[nu_m]
          "Continuous measurement input signals"   annotation (Placement(
              transformation(
              origin={0,-120},
              extent={{20,-20},{-20,20}},
              rotation=270)));
          Modelica.Blocks.Interfaces.RealOutput y[ny]
          "Continuous actuator output signals"   annotation (Placement(
              transformation(extent={{100,-10},{120,10}}, rotation=0)));
          annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Text(
                extent={{-100,-10},{-80,-30}},
                textString="u_s",
                lineColor={0,0,255}),
              Text(
                extent={{-98,34},{-138,24}},
                lineColor={0,0,0},
                textString="(setpoint)"),
              Text(
                extent={{98,24},{138,14}},
                lineColor={0,0,0},
                textString="(actuator)"),
              Text(
                extent={{-62,-110},{-12,-100}},
                lineColor={0,0,0},
                textString=" (measurement)")}),
                                  Documentation(info="<html>
<p>
Block has two continuous Real input signal vectors and one
continuous Real output signal vector. The vector signals
are sampled due to the defined <b>samplePeriod</b> parameter.
The block is designed
to be used as base class for a corresponding controller.
</p>
</html>"));
        equation
          connect(u_s, sampler_s.u)           annotation (Line(points={{-120,0},{
                -92,0}}));
          connect(u_m, sampler_m.u)           annotation (Line(points={{0,-120},{0,
                -106},{0,-92},{-7.34788e-016,-92}}));
        end MVdiscrete;

        partial block BooleanBlockIcon
        "Basic graphical layout of Boolean block"

          annotation (
            Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={255,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid), Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255})}),
          Documentation(info="<html>
<p>
Block that has only the basic icon for an input/output,
Boolean block (no declarations, no equations).
</p>
</html>"));

        end BooleanBlockIcon;

        partial block BooleanSISO
        "Single Input Single Output control block with signals of type Boolean"

          extends BooleanBlockIcon;

      public
          BooleanInput u "Connector of Boolean input signal" 
            annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
          BooleanOutput y "Connector of Boolean output signal" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));

          annotation (
          Documentation(info="<html>
<p>
Block has one continuous Boolean input and one continuous Boolean output signal.
</p>
</html>"));
        end BooleanSISO;

    partial block BooleanMIMOs
        "Multiple Input Multiple Output continuous control block with same number of inputs and outputs of boolean type"

      extends BooleanBlockIcon;
      parameter Integer n=1 "Number of inputs (= number of outputs)";
      BooleanInput u[n] "Connector of Boolean input signals" 
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
      BooleanOutput y[n] "Connector of Boolean output signals" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}}, rotation=
                  0)));
      annotation (Documentation(info="<HTML>
<p>
Block has a continuous Boolean input and a continuous Boolean output signal vector
where the signal sizes of the input and output vector are identical.
</p>
</HTML>
"));
    end BooleanMIMOs;

    partial block MI2BooleanMOs
        "2 Multiple Input / Boolean Multiple Output block with same signal lengths"

      extends BooleanBlockIcon;
      parameter Integer n=1 "Dimension of input and output vectors.";
      RealInput u1[n] "Connector 1 of Boolean input signals" 
        annotation (Placement(transformation(extent={{-140,40},{-100,80}}, rotation=
                 0)));
      RealInput u2[n] "Connector 2 of Boolean input signals" 
        annotation (Placement(transformation(extent={{-140,-80},{-100,-40}},
                rotation=0)));
      BooleanOutput y[n] "Connector of Boolean output signals" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}}, rotation=
                  0)));
      annotation (Documentation(info="<html>
<p>Block has two Boolean input vectors u1 and u2 and one Boolean output
vector y. All vectors have the same number of elements.</p>
</html>
"));
    end MI2BooleanMOs;

        partial block SI2BooleanSO
        "2 Single Input / Boolean Single Output block"

          extends BooleanBlockIcon;
          input RealInput u1 "Connector 1 of Boolean input signals" 
            annotation (Placement(transformation(extent={{-140,40},{-100,80}},
                rotation=0)));
          input RealInput u2 "Connector 2 of Boolean input signals" 
            annotation (Placement(transformation(extent={{-140,-80},{-100,-40}},
                rotation=0)));
          output BooleanOutput y "Connector of Boolean output signals" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
          annotation (
            Documentation(info="<html>
<p>
Block has two Boolean input signals u1 and u2 and one Boolean output signal y.
</p>
</html>
"));

        end SI2BooleanSO;

        partial block BooleanSignalSource
        "Base class for Boolean signal sources"

          extends BooleanBlockIcon;
          BooleanOutput y "Connector of Boolean output signal" 
            annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
          annotation (
            Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-70},{68,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid)}),
            Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics),
          Documentation(info="<html>
<p>
Basic block for Boolean sources of package Blocks.Sources.
This component has one continuous Boolean output signal y.
</p>
</html>"));

        end BooleanSignalSource;

    partial block IntegerBlockIcon "Basic graphical layout of Integer block"

      annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={255,127,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid), Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255})}),
            Documentation(info="<html>
<p>
Block that has only the basic icon for an input/output,
Integer block (no declarations, no equations).
</p>
</html>"));
    equation

    end IntegerBlockIcon;

    partial block IntegerSO "Single Integer Output continuous control block"
      extends IntegerBlockIcon;

      IntegerOutput y "Connector of Integer output signal" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}}, rotation=
                  0)));
        annotation (Documentation(info="<html>
<p>
Block has one continuous Integer output signal.
</p>
</html>"));
    end IntegerSO;

    partial block IntegerMO "Multiple Integer Output continuous control block"
      extends IntegerBlockIcon;

      parameter Integer nout(min=1) = 1 "Number of outputs";
      IntegerOutput y[nout] "Connector of Integer output signals" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}}, rotation=
                  0)));
        annotation (Documentation(info="<html>
<p>
Block has one continuous Integer output signal vector.
</p>
</html>"));
    end IntegerMO;

    partial block IntegerSignalSource
        "Base class for continuous Integer signal source"
      extends IntegerSO;
      parameter Integer offset=0 "Offset of output signal y";
      parameter SI.Time startTime=0 "Output y = offset for time < startTime";
        annotation (Documentation(info="<html>
<p>
Basic block for Integer sources of package Blocks.Sources.
This component has one continuous Integer output signal y
and two parameters (offset, startTime) to shift the
generated signal.
</p>
</html>"));
    end IntegerSignalSource;

    partial block IntegerSIBooleanSO
        "Integer Input Boolean Output continuous control block"

      extends BooleanBlockIcon;
      IntegerInput u "Connector of Integer input signal" 
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
      BooleanOutput y "Connector of Boolean output signal" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}}, rotation=
                  0)));
      annotation (Documentation(info="<HTML>
<p>
Block has a continuous Integer input and a continuous Boolean output signal.
</p>
</HTML>
"));
    end IntegerSIBooleanSO;

    partial block IntegerMIBooleanMOs
        "Multiple Integer Input Multiple Boolean Output continuous control block with same number of inputs and outputs"

      extends BooleanBlockIcon;
      parameter Integer n=1 "Number of inputs (= number of outputs)";
      IntegerInput u[n] "Connector of Integer input signals" 
        annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
      BooleanOutput y[n] "Connector of Boolean output signals" 
        annotation (Placement(transformation(extent={{100,-10},{120,10}}, rotation=
                  0)));
      annotation (Documentation(info="<HTML>
<p>
Block has a continuous Integer input and a continuous Boolean output signal vector
where the signal sizes of the input and output vector are identical.
</p>
</HTML>
"));
    end IntegerMIBooleanMOs;

      partial block partialBooleanBlockIcon
        "Basic graphical layout of logical block"

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,0},
                fillColor={210,210,210},
                fillPattern=FillPattern.Solid,
                borderPattern=BorderPattern.Raised), Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255})}),                        Documentation(info="<html>
<p>
Block that has only the basic icon for an input/output,
Boolean block (no declarations, no equations) used especially
in the Blocks.Logical library.
</p>
</html>"));
      equation

      end partialBooleanBlockIcon;

      partial block partialBooleanSISO
        "Partial block with 1 input and 1 output Boolean signal"
        extends partialBooleanBlockIcon;
               Blocks.Interfaces.BooleanInput u
          "Connector of Boolean input signal"   annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
               Blocks.Interfaces.BooleanOutput y
          "Connector of Boolean output signal"   annotation (Placement(
              transformation(extent={{100,-10},{120,10}}, rotation=0)));

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Ellipse(
                extent={{-71,7},{-85,-7}},
                lineColor=DynamicSelect({235,235,235}, if u > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if u > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid), Ellipse(
                extent={{71,7},{85,-7}},
                lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid)}),
                                  Documentation(info="<html>
<p>
Block has one continuous Boolean input and one continuous Boolean output signal
with a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

      end partialBooleanSISO;

      partial block partialBooleanSI2SO
        "Partial block with 2 input and 1 output Boolean signal"
        extends partialBooleanBlockIcon;
               Blocks.Interfaces.BooleanInput u1
          "Connector of first Boolean input signal" 
                                                 annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
               Blocks.Interfaces.BooleanInput u2
          "Connector of second Boolean input signal" 
                                                 annotation (Placement(
              transformation(extent={{-140,-100},{-100,-60}}, rotation=0)));
               Blocks.Interfaces.BooleanOutput y
          "Connector of Boolean output signal"   annotation (Placement(
              transformation(extent={{100,-10},{120,10}}, rotation=0)));

        annotation (Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Ellipse(
                extent={{-71,7},{-85,-7}},
                lineColor=DynamicSelect({235,235,235}, if u1 > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if u1 > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{-71,-74},{-85,-88}},
                lineColor=DynamicSelect({235,235,235}, if u2 > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if u2 > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{71,7},{85,-7}},
                lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid)}),
          Documentation(info="<html>
<p>
Block has two continuous Boolean input and one continuous Boolean output signal
with a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

      end partialBooleanSI2SO;

      partial block partialBooleanSI3SO
        "Partial block with 3 input and 1 output Boolean signal"
        extends partialBooleanBlockIcon;
               Blocks.Interfaces.BooleanInput u1
          "Connector of first Boolean input signal" 
                                                 annotation (Placement(
              transformation(extent={{-140,60},{-100,100}}, rotation=0)));
               Blocks.Interfaces.BooleanInput u2
          "Connector of second Boolean input signal" 
                                                 annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
               Blocks.Interfaces.BooleanInput u3
          "Connector of third Boolean input signal" 
                                                 annotation (Placement(
              transformation(extent={{-140,-100},{-100,-60}}, rotation=0)));
               Blocks.Interfaces.BooleanOutput y
          "Connector of Boolean output signal"   annotation (Placement(
              transformation(extent={{100,-10},{120,10}}, rotation=0)));

        annotation (Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Ellipse(
                extent={{-71,74},{-85,88}},
                lineColor=DynamicSelect({235,235,235}, if u1 > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if u1 > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{-71,7},{-85,-7}},
                lineColor=DynamicSelect({235,235,235}, if u2 > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if u2 > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{-71,-74},{-85,-88}},
                lineColor=DynamicSelect({235,235,235}, if u3 > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if u3 > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{71,7},{85,-7}},
                lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid)}),
          Documentation(info="<html>
Block has three continuous Boolean input and one continuous Boolean output signal
with a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

      end partialBooleanSI3SO;

      partial block partialBooleanSI
        "Partial block with 1 input Boolean signal"
        extends partialBooleanBlockIcon;

               Blocks.Interfaces.BooleanInput u
          "Connector of Boolean input signal"   annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}}, rotation=0)));

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Ellipse(
                extent={{-71,7},{-85,-7}},
                lineColor=DynamicSelect({235,235,235}, if u > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if u > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid)}),
                                  Documentation(info="<html>
<p>
Block has one continuous Boolean input signal
with a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

      end partialBooleanSI;

      partial block partialBooleanSO
        "Partial block with 1 output Boolean signal"

               Blocks.Interfaces.BooleanOutput y
          "Connector of Boolean output signal"   annotation (Placement(
              transformation(extent={{100,-10},{120,10}}, rotation=0)));
        extends partialBooleanBlockIcon;

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Ellipse(
                extent={{71,7},{85,-7}},
                lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid)}),
                                  Documentation(info="<html>
<p>
Block has one continuous Boolean output signal
with a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

      end partialBooleanSO;

      partial block partialBooleanSource
        "Partial source block (has 1 output Boolean signal and an appropriate default icon)"
        extends partialBooleanBlockIcon;

        Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" 
          annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Polygon(
                points={{-80,88},{-88,66},{-72,66},{-80,88}},
                lineColor={255,0,255},
                fillColor={255,0,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,66},{-80,-82}}, color={255,0,255}),
              Line(points={{-90,-70},{72,-70}}, color={255,0,255}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={255,0,255},
                fillColor={255,0,255},
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{71,7},{85,-7}},
                lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid)}),
            Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                  {100,100}}), graphics={
              Polygon(
                points={{-70,92},{-76,70},{-64,70},{-70,92}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-70,70},{-70,-88}}, color={95,95,95}),
              Line(points={{-90,-70},{68,-70}}, color={95,95,95}),
              Polygon(
                points={{90,-70},{68,-64},{68,-76},{90,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{54,-80},{106,-92}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Text(
                extent={{-64,92},{-46,74}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y")}),
          Documentation(info="<html>
<p>
Basic block for Boolean sources of package Blocks.Sources.
This component has one continuous Boolean output signal y
and a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

      end partialBooleanSource;

      partial block partialBooleanThresholdComparison
        "Partial block to compare the Real input u with a threshold and provide the result as 1 Boolean output signal"

        parameter Real threshold=0 "Comparison with respect to threshold";

        Blocks.Interfaces.RealInput u "Connector of Boolean input signal" 
                                      annotation (Placement(transformation(extent={
                  {-140,-20},{-100,20}}, rotation=0)));
        Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" 
                                          annotation (Placement(transformation(
                extent={{100,-10},{120,10}}, rotation=0)));

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,0},
                fillColor={210,210,210},
                fillPattern=FillPattern.Solid,
                borderPattern=BorderPattern.Raised),
              Text(
                extent={{-150,-140},{150,-110}},
                lineColor={0,0,0},
                textString="%threshold"),
              Ellipse(
                extent={{71,7},{85,-7}},
                lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid)}),
            Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                  {100,100}}),
                    graphics),
          Documentation(info="<html>
<p>
Block has one continuous Real input and one continuous Boolean output signal
as well as a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

      end partialBooleanThresholdComparison;

      partial block partialBooleanComparison
        "Partial block with 2 Real input and 1 Boolean output signal (the result of a comparison of the two Real inputs"

        Blocks.Interfaces.RealInput u1
          "Connector of first Boolean input signal" 
                                       annotation (Placement(transformation(extent=
                  {{-140,-20},{-100,20}}, rotation=0)));
        Blocks.Interfaces.RealInput u2
          "Connector of second Boolean input signal" 
                                       annotation (Placement(transformation(extent=
                  {{-140,-100},{-100,-60}}, rotation=0)));
        Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" 
          annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,0},
                fillColor={210,210,210},
                fillPattern=FillPattern.Solid,
                borderPattern=BorderPattern.Raised),
              Ellipse(
                extent={{73,7},{87,-7}},
                lineColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillColor=DynamicSelect({235,235,235}, if y > 0.5 then {0,255,0} else 
                          {235,235,235}),
                fillPattern=FillPattern.Solid),
              Ellipse(extent={{32,10},{52,-10}}, lineColor={0,0,255}),
              Line(points={{-100,-80},{42,-80},{42,0}}, color={0,0,255})}),
            Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                  {100,100}}),
                    graphics),
          Documentation(info="<html>
<p>
Block has two continuous Real input and one continuous Boolean output signal
as a result of the comparision of the two input signals. The block
has a 3D icon (e.g. used in Blocks.Logical library).
</p>
</html>"));

      end partialBooleanComparison;

    package Adaptors
        "Obsolete package with components to send signals to a bus or receive signals from a bus (only for backward compatibility)"

      extends Modelica.Icons.Library;

      block SendReal "Obsolete block to send Real signal to bus"
        RealOutput toBus "Output signal to be connected to bus" annotation (Placement(
                transformation(extent={{100,-10},{120,10}}, rotation=0)));
        RealInput u "Input signal to be send to bus" annotation (Placement(
                transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={
                Rectangle(
                  extent={{-100,40},{100,-40}},
                  lineColor={0,0,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Text(
                  extent={{-144,96},{144,46}},
                  lineColor={0,0,0},
                  textString="%name"),
                Text(
                  extent={{-100,30},{100,-30}},
                  lineColor={0,0,255},
                  fillColor={191,0,0},
                  fillPattern=FillPattern.Solid,
                  textString="send")}),        Documentation(info="<html>
<p>
Obsolete block that was previously used to connect a Real signal
to a signal in a connector. This block is only provided for
backward compatibility.
</p>
 
<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example 
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>
"));
      equation
        toBus = u;
      end SendReal;

      block SendBoolean "Obsolete block to send Boolean signal to bus"
        BooleanOutput toBus "Output signal to be connected to bus" annotation (Placement(
                transformation(extent={{100,-10},{120,10}}, rotation=0)));
        BooleanInput u "Input signal to be send to bus" annotation (Placement(
                transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={
                Rectangle(
                  extent={{-100,40},{100,-40}},
                  lineColor={255,0,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Text(
                  extent={{-144,96},{144,46}},
                  lineColor={0,0,0},
                  textString="%name"),
                Text(
                  extent={{-100,30},{100,-30}},
                  lineColor={255,0,255},
                  fillColor={191,0,0},
                  fillPattern=FillPattern.Solid,
                  textString="send")}),        Documentation(info="<html>
<p>
Obsolete block that was previously used to connect a Boolean signal
to a signal in a connector. This block is only provided for
backward compatibility.
</p>
 
<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example 
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>
"));
      equation
        toBus = u;
      end SendBoolean;

      block SendInteger "Obsolete block to send Integer signal to bus"
        IntegerOutput toBus "Output signal to be connected to bus" annotation (Placement(
                transformation(extent={{100,-10},{120,10}}, rotation=0)));
        IntegerInput u "Input signal to be send to bus" annotation (Placement(
                transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={
                Rectangle(
                  extent={{-100,40},{100,-40}},
                  lineColor={255,127,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Text(
                  extent={{-144,96},{144,46}},
                  lineColor={0,0,0},
                  textString="%name"),
                Text(
                  extent={{-100,30},{100,-30}},
                  lineColor={255,127,0},
                  fillColor={191,0,0},
                  fillPattern=FillPattern.Solid,
                  textString="send")}),        Documentation(info="<html>
<p>
Obsolete block that was previously used to connect an Integer signal
to a signal in a connector. This block is only provided for
backward compatibility.
</p>
 
<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example 
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
      equation
        toBus = u;
      end SendInteger;

      block ReceiveReal "Obsolete block to receive Real signal from bus"
        RealInput fromBus "To be connected with signal on bus" annotation (Placement(
                transformation(extent={{-120,-10},{-100,10}}, rotation=0)));
        RealOutput y "Output signal to be received from bus" annotation (Placement(
                transformation(extent={{100,-10},{120,10}}, rotation=0)));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={
                Rectangle(
                  extent={{-100,40},{100,-40}},
                  lineColor={0,0,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Text(
                  extent={{-100,30},{100,-30}},
                  lineColor={0,0,255},
                  fillColor={191,0,0},
                  fillPattern=FillPattern.Solid,
                  textString="receive"),
                Text(
                  extent={{-144,96},{144,46}},
                  lineColor={0,0,0},
                  textString="%name")}),
                                Documentation(info="<html>
<p>
Obsolete block that was previously used to connect a Real signal
in a connector to an input of a block. This block is only provided for
backward compatibility.
</p>
 
<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example 
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
      equation
        y = fromBus;
      end ReceiveReal;

      block ReceiveBoolean "Obsolete block to receive Boolean signal from bus"
        BooleanInput fromBus "To be connected with signal on bus" annotation (Placement(
                transformation(extent={{-120,-10},{-100,10}}, rotation=0)));
        BooleanOutput y "Output signal to be received from bus" annotation (Placement(
                transformation(extent={{100,-10},{120,10}}, rotation=0)));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={
                Rectangle(
                  extent={{-100,40},{100,-40}},
                  lineColor={255,0,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Text(
                  extent={{-100,30},{100,-30}},
                  lineColor={255,0,255},
                  fillColor={191,0,0},
                  fillPattern=FillPattern.Solid,
                  textString="receive"),
                Text(
                  extent={{-144,96},{144,46}},
                  lineColor={0,0,0},
                  textString="%name")}),
                                Documentation(info="<html>
<p>
Obsolete block that was previously used to connect a Boolean signal
in a connector to an input of a block. This block is only provided for
backward compatibility.
</p>
 
<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example 
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
      equation
        y = fromBus;
      end ReceiveBoolean;

      block ReceiveInteger "Obsolete block to receive Integer signal from bus"
        IntegerInput fromBus "To be connected with signal on bus" annotation (Placement(
                transformation(extent={{-120,-10},{-100,10}}, rotation=0)));
        IntegerOutput y "Output signal to be received from bus" annotation (Placement(
                transformation(extent={{100,-10},{120,10}}, rotation=0)));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={
                Rectangle(
                  extent={{-100,40},{100,-40}},
                  lineColor={255,127,0},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Text(
                  extent={{-100,30},{100,-30}},
                  lineColor={255,127,0},
                  fillColor={191,0,0},
                  fillPattern=FillPattern.Solid,
                  textString="receive"),
                Text(
                  extent={{-144,96},{144,46}},
                  lineColor={0,0,0},
                  textString="%name")}),
                                Documentation(info="<html>
<p>
Obsolete block that was previously used to connect an Integer signal
in a connector to an input of a block. This block is only provided for
backward compatibility.
</p>
 
<p>
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example 
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>
"));
      equation
        y = fromBus;
      end ReceiveInteger;

        annotation (Documentation(info="<html>
<p>
The components of this package should no longer be used.
They are only provided for backward compatibility.
It is much more convenient and more powerful to use \"expandable connectors\"
for signal buses, see example 
<a href=\"Modelica://Modelica.Blocks.Examples.BusUsage\">BusUsage</a>.
</p>
</html>"));
    end Adaptors;

      partial block PartialConversionBlock
        "Partial block defining the interface for conversion blocks"

        RealInput u "Connector of Real input signal to be converted" 
          annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
        RealOutput y
          "Connector of Real output signal containing input signal u in another unit"
          annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Rectangle(
                extent={{-100,100},{100,-100}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,0},{30,0}}, color={191,0,0}),
              Polygon(
                points={{90,0},{30,20},{30,-20},{90,0}},
                lineColor={191,0,0},
                fillColor={191,0,0},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-115,155},{115,105}},
                textString="%name",
                lineColor={0,0,255})}),                                      Documentation(info="<html>
<p>
This block defines the interface of a conversion block that
converts from one unit into another one.
</p>

</html>"));

      end PartialConversionBlock;
    end Interfaces;

    package Logical
      "Library of components with Boolean input and output signals"
        extends Modelica.Icons.Library;

      annotation(Documentation(info="<html>
<p>
This package provides blocks with Boolean input and output signals
to describe logical networks. A typical example for a logical
network built with package Logical is shown in the next figure:
</p>
<p align=\"center\">
<img src=\"../Images/Blocks/LogicalNetwork1.png\">
</p>

<p>
The actual value of Boolean input and/or output signals is displayed
in the respective block icon as \"circle\", where \"white\" color means
value <b>false</b> and \"green\" color means value <b>true</b>. These
values are visualized in a diagram animation.
</p>
</html>"));

      model And "Logical 'and': y = u1 and u2"
        extends Blocks.Interfaces.partialBooleanSI2SO;
        annotation (defaultComponentName="and1",
               Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                  {100,100}}), graphics={Text(
                extent={{-90,40},{90,-40}},
                lineColor={0,0,0},
                textString="and")}),
                                  Diagram(coordinateSystem(preserveAspectRatio=
                  false, extent={{-100,-100},{100,100}}),
                                          graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if all inputs are <b>true</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      equation
        y = u1 and u2;
      end And;

      model Or "Logical 'or': y = u1 or u2"
        extends Blocks.Interfaces.partialBooleanSI2SO;
        annotation (defaultComponentName="or1",
               Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                  {100,100}}), graphics={Text(
                extent={{-90,40},{90,-40}},
                lineColor={0,0,0},
                textString="or")}),
                                  Diagram(coordinateSystem(preserveAspectRatio=
                  false, extent={{-100,-100},{100,100}}),
                                          graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if at least one input is <b>true</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      equation
        y = u1 or u2;
      end Or;

      model Xor "Logical 'xor': y = u1 xor u2"
        extends Blocks.Interfaces.partialBooleanSI2SO;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,40},{90,-40}},
                lineColor={0,0,0},
                textString="xor")}),
                                  Diagram(coordinateSystem(preserveAspectRatio=
                  false, extent={{-100,-100},{100,100}}),
                                          graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if exactly one input is <b>true</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      equation
        y =not  ( (u1 and u2) or (not u1 and not u2));
      end Xor;

      model Nor "Logical 'nor': y = not (u1 or u2)"
        extends Blocks.Interfaces.partialBooleanSI2SO;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,40},{90,-40}},
                lineColor={0,0,0},
                textString="nor")}),
                                  Diagram(coordinateSystem(preserveAspectRatio=
                  false, extent={{-100,-100},{100,100}}),
                                          graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if none of the inputs is <b>true</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      equation
        y =not  ( u1 or u2);
      end Nor;

      model Nand "Logical 'nand': y = not (u1 and u2)"
        extends Blocks.Interfaces.partialBooleanSI2SO;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,40},{90,-40}},
                lineColor={0,0,0},
                textString="nand")}),
                                  Diagram(coordinateSystem(preserveAspectRatio=
                  false, extent={{-100,-100},{100,100}}),
                                          graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if at least one input is <b>false</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      equation
        y =not  ( u1 and u2);
      end Nand;

      model Not "Logical 'not': y = not u"
        extends Blocks.Interfaces.partialBooleanSISO;

        annotation (defaultComponentName="not1",
             Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={Text(
                extent={{-90,40},{90,-40}},
                lineColor={0,0,0},
                textString="not")}),
                                Diagram(coordinateSystem(preserveAspectRatio=true,
                extent={{-100,-100},{100,100}}),
                                        graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if the input is <b>false</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      equation
        y =not  u;
      end Not;

      model Pre
        "Breaks algebraic loops by an infinitesimal small time delay (y = pre(u): event iteration continues until u = pre(u))"

        parameter Boolean pre_u_start = false
          "Start value of pre(u) at initial time";
        extends Blocks.Interfaces.partialBooleanSISO;

        annotation (defaultComponentName="pre1",
             Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={Text(
                extent={{-90,40},{90,-40}},
                lineColor={0,0,0},
                textString="pre")}),
                                Diagram(coordinateSystem(preserveAspectRatio=true,
                extent={{-100,-100},{100,100}}),
                                        graphics),
          Documentation(info="<html>
<p>
This block delays the Boolean input by an infinitesimal small time delay and 
therefore breaks algebraic loops. In a network of logical blocks, in every
\"closed connection loop\" at least one logical block must have a delay,
since algebraic systems of Boolean equations are not solveable.
</p>

<p>
The \"Pre\" block returns the value of the \"input\" signal from the
last \"event iteration\". The \"event iteration\" stops, once both
values are identical (u = pre(u)).
</p>
</html>"));
      initial equation
        pre(u) = pre_u_start;
      equation
        y = pre(u);
      end Pre;

      model Edge
        "Output y is true, if the input u has a rising edge (y = edge(u))"

        parameter Boolean pre_u_start = false
          "Start value of pre(u) at initial time";
        extends Blocks.Interfaces.partialBooleanSISO;

        annotation (defaultComponentName="edge1",
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={Text(
                extent={{-90,40},{90,-40}},
                lineColor={0,0,0},
                textString="edge")}),
                                Diagram(coordinateSystem(preserveAspectRatio=true,
                extent={{-100,-100},{100,100}}),
                                        graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if the Boolean input has a rising edge
from <b>false</b> to <b>true</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      initial equation
        pre(u) = pre_u_start;
      equation
        y = edge(u);
      end Edge;

      model FallingEdge
        "Output y is true, if the input u has a falling edge (y = edge(not u))"

        parameter Boolean pre_u_start = false
          "Start value of pre(u) at initial time";
        extends Blocks.Interfaces.partialBooleanSISO;

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,40},{90,-40}},
                lineColor={0,0,0},
                textString="falling")}),
                                Diagram(coordinateSystem(preserveAspectRatio=true,
                extent={{-100,-100},{100,100}}),
                                        graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if the Boolean input has a falling edge
from <b>true</b> to <b>false</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      protected
       Boolean not_u=not u;
      initial equation
        pre(not_u) =not  pre_u_start;
      equation
        y = edge(not_u);
      end FallingEdge;

      model Change
        "Output y is true, if the input u has a rising or falling edge (y = change(u))"

        parameter Boolean pre_u_start = false
          "Start value of pre(u) at initial time";
        extends Blocks.Interfaces.partialBooleanSISO;

        annotation (defaultComponentName="change1",
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={Text(
                extent={{-90,40},{90,-40}},
                lineColor={0,0,0},
                textString="change")}),
                                Diagram(coordinateSystem(preserveAspectRatio=true,
                extent={{-100,-100},{100,100}}),
                                        graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if the Boolean input has either a rising edge
from <b>false</b> to <b>true</b> or a falling edge from
<b>true</b> to <b>false</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      initial equation
        pre(u) = pre_u_start;
      equation
        y = change(u);
      end Change;

      block GreaterThreshold
        "Output y is true, if input u is greater than threshold"
        extends Blocks.Interfaces.partialBooleanThresholdComparison;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,-40},{60,40}},
                lineColor={0,0,0},
                textString=">")}),
                            Diagram(coordinateSystem(preserveAspectRatio=true,
                extent={{-100,-100},{100,100}}),
                                    graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if the Real input is greater than 
parameter <b>threshold</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      equation
        y = u > threshold;
      end GreaterThreshold;

      block GreaterEqualThreshold
        "Output y is true, if input u is greater or equal than threshold"

        extends Blocks.Interfaces.partialBooleanThresholdComparison;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,-40},{60,40}},
                lineColor={0,0,0},
                textString=">=")}),
                                Diagram(coordinateSystem(preserveAspectRatio=true,
                extent={{-100,-100},{100,100}}),
                                        graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if the Real input is greater than or equal to
parameter <b>threshold</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      equation
        y = u >= threshold;
      end GreaterEqualThreshold;

      block LessThreshold "Output y is true, if input u is less than threshold"

        extends Blocks.Interfaces.partialBooleanThresholdComparison;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,-40},{60,40}},
                lineColor={0,0,0},
                textString="<")}),
                                Diagram(coordinateSystem(preserveAspectRatio=true,
                extent={{-100,-100},{100,100}}),
                                        graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if the Real input is less than 
parameter <b>threshold</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      equation
        y = u < threshold;
      end LessThreshold;

      block LessEqualThreshold
        "Output y is true, if input u is less or equal than threshold"
        extends Blocks.Interfaces.partialBooleanThresholdComparison;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,-40},{60,40}},
                lineColor={0,0,0},
                textString="<=")}),
                                Diagram(coordinateSystem(preserveAspectRatio=true,
                extent={{-100,-100},{100,100}}),
                                        graphics),
          Documentation(info="<html>
<p>
The output is <b>true</b> if the Real input is less than or equal to
parameter <b>threshold</b>, otherwise
the output is <b>false</b>.
</p>
</html>"));
      equation
        y = u <= threshold;
      end LessEqualThreshold;

      block Greater "Output y is true, if input u1 is greater as input u2"
        extends Blocks.Interfaces.partialBooleanComparison;

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Ellipse(extent={{32,10},{52,-10}}, lineColor={0,0,255}),
              Line(points={{-100,-80},{42,-80},{42,0}}, color={0,0,255}),
              Text(
                extent={{-80,-60},{20,60}},
                lineColor={0,0,0},
                textString=">")}),
            Documentation(info="<html>
<p>
The output is <b>true</b> if Real input u1 is greater than
Real input u2, otherwise the output is <b>false</b>.
</p>
</html>"));

      equation
        y = u1 > u2;
      end Greater;

      block GreaterEqual
        "Output y is true, if input u1 is greater or equal as input u2"
        extends Blocks.Interfaces.partialBooleanComparison;

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Ellipse(extent={{32,10},{52,-10}}, lineColor={0,0,255}),
              Line(points={{-100,-80},{42,-80},{42,0}}, color={0,0,255}),
              Text(
                extent={{-80,-60},{20,60}},
                lineColor={0,0,0},
                textString=">=")}),
            Documentation(info="<html>
<p>
The output is <b>true</b> if Real input u1 is greater than or equal to
Real input u2, otherwise the output is <b>false</b>.
</p>
</html>"));

      equation
        y = u1 >= u2;
      end GreaterEqual;

      block Less "Output y is true, if input u1 is less as input u2"
        extends Blocks.Interfaces.partialBooleanComparison;

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Ellipse(extent={{32,10},{52,-10}}, lineColor={0,0,255}),
              Line(points={{-100,-80},{42,-80},{42,0}}, color={0,0,255}),
              Text(
                extent={{-80,-60},{20,60}},
                lineColor={0,0,0},
                textString="<")}),
            Documentation(info="<html>
<p>
The output is <b>true</b> if Real input u1 is less than
Real input u2, otherwise the output is <b>false</b>.
</p>
</html>"));

      equation
        y = u1 < u2;
      end Less;

      block LessEqual
        "Output y is true, if input u1 is less or equal as input u2"
        extends Blocks.Interfaces.partialBooleanComparison;

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Ellipse(extent={{32,10},{52,-10}}, lineColor={0,0,255}),
              Line(points={{-100,-80},{42,-80},{42,0}}, color={0,0,255}),
              Text(
                extent={{-80,-60},{20,60}},
                lineColor={0,0,0},
                textString="<=")}),
            Documentation(info="<html>
<p>
The output is <b>true</b> if Real input u1 is less than or equal to
Real input u2, otherwise the output is <b>false</b>.
</p>
</html>"));

      equation
        y = u1 <= u2;
      end LessEqual;

      block ZeroCrossing "Trigger zero crossing of input u"
        extends Blocks.Interfaces.partialBooleanSO;
        Blocks.Interfaces.RealInput u annotation (Placement(transformation(extent={
                  {-140,-20},{-100,20}}, rotation=0)));
        Blocks.Interfaces.BooleanInput enable
          "Zero input crossing is triggered if the enable input signal is true"
          annotation (Placement(transformation(
              origin={0,-120},
              extent={{-20,-20},{20,20}},
              rotation=90)));

        annotation (Documentation(info="<HTML>
<p>
The output \"y\" is <b>true</b> at the
time instant when the input \"u\" becomes
zero, provided the input \"enable\" is
<b>true</b>. At all other time instants, the output \"y\" is <b>false</b>.
If the input \"u\" is zero at a time instant when the \"enable\"
input changes its value, then the output y is <b>false</b>.
</p>
<p>
Note, that in the plot window of a Modelica simulator, the output of
this block is usually identically to <b>false</b>, because the output
may only be <b>true</b> at an event instant, but not during
continuous integration. In order to check that this component is
actually working as expected, one should connect its output to, e.g.,
component <i>ModelicaAdditions.Blocks.Discrete.TriggeredSampler</i>.
</p>
</HTML>"),     Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                  {100,100}}), graphics={
              Line(points={{-78,68},{-78,-80}}, color={192,192,192}),
              Polygon(
                points={{-78,90},{-86,68},{-70,68},{-78,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-88,0},{70,0}}, color={192,192,192}),
              Line(points={{-78,0},{-73.2,32.3},{-70,50.3},{-66.7,64.5},{-63.5,74.2},
                    {-60.3,79.3},{-57.1,79.6},{-53.9,75.3},{-50.7,67.1},{-46.6,52.2},
                    {-41,25.8},{-33,-13.9},{-28.2,-33.7},{-24.1,-45.9},{-20.1,-53.2},
                    {-16.1,-55.3},{-12.1,-52.5},{-8.1,-45.3},{-3.23,-32.1},{10.44,
                    13.7},{15.3,26.4},{20.1,34.8},{24.1,38},{28.9,37.2},{33.8,31.8},
                    {40.2,19.4},{53.1,-10.5},{59.5,-21.2},{65.1,-25.9},{70.7,-25.9},
                    {77.2,-20.5},{82,-13.8}}, color={192,192,192}),
              Polygon(
                points={{92,0},{70,8},{70,-8},{92,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-36,-59},{-36,81}}, color={255,0,255}),
              Line(points={{6,-59},{6,81}}, color={255,0,255}),
              Line(points={{49,-59},{49,81}}, color={255,0,255}),
              Line(points={{-78,0},{70,0}}, color={255,0,255})}));
      protected
        Boolean disable=not   enable;
        Boolean u_pos;
      initial equation
        pre(u_pos)  = false;
        pre(enable) = false;
        pre(disable) =not  pre(enable);
      equation
        u_pos = enable and u >= 0;
        y = change(u_pos) and not edge(enable) and not edge(disable);
      end ZeroCrossing;

      block LogicalSwitch "Logical Switch"
        extends Blocks.Interfaces.partialBooleanSI3SO;

        annotation (
          Documentation(info="<html>
<p>The LogicalSwitch switches, depending on the
Boolean u2 connector (the middle connector),
between the two possible input signals
u1 (upper connector) and u3 (lower connector).</p>
<p>If u2 is true, connector y is set equal to
u1, else it is set equal to u2.</p>
</html>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(
                points={{12,0},{100,0}},
                color={255,0,255},
                pattern=LinePattern.Solid,
                thickness=0.25,
                arrow={Arrow.None,Arrow.None}),
              Line(
                points={{-100,0},{-40,0}},
                color={255,0,255},
                pattern=LinePattern.Solid,
                thickness=0.25,
                arrow={Arrow.None,Arrow.None}),
              Line(
                points={{-100,-80},{-40,-80},{-40,-80}},
                color={255,0,255},
                pattern=LinePattern.Solid,
                thickness=0.25,
                arrow={Arrow.None,Arrow.None}),
              Line(points={{-40,12},{-40,-10}}, color={255,0,255}),
              Line(points={{-100,80},{-40,80}}, color={255,0,255}),
              Line(
                points={{-40,80},{8,2}},
                color={255,0,127},
                thickness=1),
              Ellipse(
                extent={{2,8},{18,-6}},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics));

      equation
        y = if u2 then u1 else u3;
      end LogicalSwitch;

      block Switch "Switch between two Real signals"
        extends Blocks.Interfaces.partialBooleanBlockIcon;
        Blocks.Interfaces.RealInput u1 "Connector of first Real input signal" 
                                       annotation (Placement(transformation(extent=
                  {{-140,60},{-100,100}}, rotation=0)));
        Blocks.Interfaces.BooleanInput u2 "Connector of Boolean input signal" 
                                          annotation (Placement(transformation(
                extent={{-140,-20},{-100,20}}, rotation=0)));
        Blocks.Interfaces.RealInput u3 "Connector of second Real input signal" 
                                       annotation (Placement(transformation(extent=
                  {{-140,-100},{-100,-60}}, rotation=0)));
        Blocks.Interfaces.RealOutput y "Connector of Real output signal" 
                                       annotation (Placement(transformation(extent=
                  {{100,-10},{120,10}}, rotation=0)));

        annotation (defaultComponentName="switch1",
          Documentation(info="<html>
<p>The Logical.Switch switches, depending on the
logical connector u2 (the middle connector)
between the two possible input signals
u1 (upper connector) and u3 (lower connector).</p>
<p>If u2 is <b>true</b>, the output signal y is set equal to
u1, else it is set equal to u3.</p>
</html>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(
                points={{12,0},{100,0}},
                pattern=LinePattern.Solid,
                thickness=0.25,
                arrow={Arrow.None,Arrow.None},
                color={0,0,255}),
              Line(
                points={{-100,0},{-40,0}},
                color={255,0,127},
                pattern=LinePattern.Solid,
                thickness=0.25,
                arrow={Arrow.None,Arrow.None}),
              Line(
                points={{-100,-80},{-40,-80},{-40,-80}},
                pattern=LinePattern.Solid,
                thickness=0.25,
                arrow={Arrow.None,Arrow.None},
                color={0,0,255}),
              Line(points={{-40,12},{-40,-12}}, color={255,0,127}),
              Line(points={{-100,80},{-38,80}}, color={0,0,255}),
              Line(
                points={{-38,80},{6,2}},
                thickness=1,
                color={0,0,255}),
              Ellipse(
                extent={{2,8},{18,-6}},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics));
      equation
        y = if u2 then u1 else u3;
      end Switch;

      block Hysteresis "Transform Real to Boolean signal with Hysteresis"

        extends Blocks.Interfaces.partialBooleanBlockIcon;
        parameter Real uLow(start=0) "if y=true and u<=uLow, switch to y=false";
        parameter Real uHigh(start=1)
          "if y=false and u>=uHigh, switch to y=true";
        parameter Boolean pre_y_start = false "Value of pre(y) at initial time";

        Blocks.Interfaces.RealInput u annotation (Placement(transformation(extent={
                  {-140,-20},{-100,20}}, rotation=0)));
        Blocks.Interfaces.BooleanOutput y 
          annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));

        annotation (
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Polygon(
                points={{-65,89},{-73,67},{-57,67},{-65,89}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-65,67},{-65,-81}}, color={192,192,192}),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{70,-80},{94,-100}},
                lineColor={160,160,164},
                textString="u"),
              Text(
                extent={{-65,93},{-12,75}},
                lineColor={160,160,164},
                textString="y"),
              Line(
                points={{-80,-70},{30,-70}},
                color={0,0,0},
                thickness=0.5),
              Line(
                points={{-50,10},{80,10}},
                color={0,0,0},
                thickness=0.5),
              Line(
                points={{-50,10},{-50,-70}},
                color={0,0,0},
                thickness=0.5),
              Line(
                points={{30,10},{30,-70}},
                color={0,0,0},
                thickness=0.5),
              Line(
                points={{-10,-65},{0,-70},{-10,-75}},
                color={0,0,0},
                thickness=0.5),
              Line(
                points={{-10,15},{-20,10},{-10,5}},
                color={0,0,0},
                thickness=0.5),
              Line(
                points={{-55,-20},{-50,-30},{-44,-20}},
                color={0,0,0},
                thickness=0.5),
              Line(
                points={{25,-30},{30,-19},{35,-30}},
                color={0,0,0},
                thickness=0.5),
              Text(
                extent={{-99,2},{-70,18}},
                lineColor={160,160,164},
                textString="true"),
              Text(
                extent={{-98,-87},{-66,-73}},
                lineColor={160,160,164},
                textString="false"),
              Text(
                extent={{19,-87},{44,-70}},
                lineColor={0,0,0},
                textString="uHigh"),
              Text(
                extent={{-63,-88},{-38,-71}},
                lineColor={0,0,0},
                textString="uLow"),
              Line(points={{-69,10},{-60,10}}, color={160,160,164})}),
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-29}}, color={192,192,192}),
              Polygon(
                points={{92,-29},{70,-21},{70,-37},{92,-29}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-79,-29},{84,-29}}, color={192,192,192}),
              Line(points={{-79,-29},{41,-29}}, color={0,0,0}),
              Line(points={{-15,-21},{1,-29},{-15,-36}}, color={0,0,0}),
              Line(points={{41,51},{41,-29}}, color={0,0,0}),
              Line(points={{33,3},{41,22},{50,3}}, color={0,0,0}),
              Line(points={{-49,51},{81,51}}, color={0,0,0}),
              Line(points={{-4,59},{-19,51},{-4,43}}, color={0,0,0}),
              Line(points={{-59,29},{-49,11},{-39,29}}, color={0,0,0}),
              Line(points={{-49,51},{-49,-29}}, color={0,0,0}),
              Text(
                extent={{-92,-49},{-9,-92}},
                lineColor={192,192,192},
                textString="%uLow"),
              Text(
                extent={{2,-49},{91,-92}},
                lineColor={192,192,192},
                textString="%uHigh"),
              Rectangle(extent={{-91,-49},{-8,-92}}, lineColor={192,192,192}),
              Line(points={{-49,-29},{-49,-49}}, color={192,192,192}),
              Rectangle(extent={{2,-49},{91,-92}}, lineColor={192,192,192}),
              Line(points={{41,-29},{41,-49}}, color={192,192,192})}),
          Documentation(info="<HTML>
<p>
This block transforms a <b>Real</b> input signal into a <b>Boolean</b>
output signal:
</p>
<ul>
<li> When the output was <b>false</b> and the input becomes
     <b>greater</b> than parameter <b>uHigh</b>, the output
     switches to <b>true</b>.</li>
<li> When the output was <b>true</b> and the input becomes
     <b>less</b> than parameter <b>uLow</b>, the output
     switches to <b>false</b>.</li>
</ul>
<p>
The start value of the output is defined via parameter
<b>pre_y_start</b> (= value of pre(y) at initial time).
The default value of this parameter is <b>false</b>.
</p>
</HTML>
"));
      initial equation
        pre(y) = pre_y_start;
      equation
         y = u > uHigh or pre(y) and u >= uLow;
      end Hysteresis;

      block OnOffController "On-off controller"
        extends Interfaces.partialBooleanBlockIcon;
        Blocks.Interfaces.RealInput reference
          "Connector of Real input signal used as reference signal" 
                                              annotation (Placement(transformation(
                extent={{-140,80},{-100,40}}, rotation=0)));
        Blocks.Interfaces.RealInput u
          "Connector of Real input signal used as measurement signal" 
                                      annotation (Placement(transformation(extent={
                  {-140,-40},{-100,-80}}, rotation=0)));
        Blocks.Interfaces.BooleanOutput y
          "Connector of Real output signal used as actuator signal" 
                                          annotation (Placement(transformation(
                extent={{100,-10},{120,10}}, rotation=0)));

        parameter Real bandwidth(start=0.1) "Bandwidth around reference signal";
        parameter Boolean pre_y_start = false "Value of pre(y) at initial time";

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Text(
                extent={{-92,74},{44,44}},
                lineColor={0,0,0},
                lineThickness=0.5,
                textString="reference"),
              Text(
                extent={{-94,-52},{-34,-74}},
                lineColor={0,0,0},
                textString="u"),
              Line(points={{-76,-32},{-68,-6},{-50,26},{-24,40},{-2,42},{16,36},{32,
                    28},{48,12},{58,-6},{68,-28}}, color={0,0,255}),
              Line(points={{-78,-2},{-6,18},{82,-12}}, color={255,0,0}),
              Line(points={{-78,12},{-6,30},{82,0}}, color={0,0,0}),
              Line(points={{-78,-16},{-6,4},{82,-26}}, color={0,0,0}),
              Line(points={{-82,-18},{-56,-18},{-56,-40},{64,-40},{64,-20},{90,-20}},
                  color={255,0,255})}),         Documentation(info="<html>
<p>The block OnOffController sets the output signal <b>y</b> to <b>true</b> when
the input signal <b>u</b> falls below the <b>reference</b> signal minus half of
the bandwidth and sets the output signal <b>y</b> to <b>false</b> when the input
signal <b>u</b> exceeds the <b>reference</b> signal plus half of the bandwidth.</p>
</html>
"));
      initial equation
        pre(y) = pre_y_start;
      equation
        y = pre(y) and (u < reference + bandwidth/2) or (u < reference - bandwidth/2);
      end OnOffController;

      block TriggeredTrapezoid "Triggered trapezoid generator"
        extends Interfaces.partialBooleanBlockIcon;

        parameter Real amplitude=1 "Amplitude of trapezoid";
        parameter Modelica.SIunits.Time rising(final min=0)=0
          "Rising duration of trapezoid";
        parameter Modelica.SIunits.Time falling(final min=0)=rising
          "Falling duration of trapezoid";
        parameter Real offset=0 "Offset of output signal";

        Blocks.Interfaces.BooleanInput u "Connector of Boolean input signal" 
                                         annotation (Placement(transformation(
                extent={{-140,-20},{-100,20}}, rotation=0)));
        Blocks.Interfaces.RealOutput y "Connector of Real output signal" 
          annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));

        annotation (
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Line(points={{-60,-70},{-60,-70},{-30,40},{8,40},{40,-70},{40,-70}},
                  color={0,0,255}),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-70},{-60,-70},{-60,24},{8,24},{8,-70},{60,-70}},
                  color={255,0,255})}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Line(points={{-80,-20},{-60,-20},{-30,40},{8,40},{40,-20},{60,-20}},
                  color={0,0,255}),
              Line(points={{-90,-70},{82,-70}}, color={0,0,0}),
              Line(points={{-80,68},{-80,-80}}, color={0,0,0}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-68},{-60,-68},{-60,-42},{8,-42},{8,-68},{60,-68}},
                  color={255,0,255}),
              Line(
                points={{-60,40},{-60,-42}},
                color={0,0,0},
                pattern=LinePattern.Dot),
              Line(
                points={{8,-42},{8,40}},
                color={0,0,0},
                pattern=LinePattern.Dot),
              Line(points={{-60,40},{-30,40}}, color={0,0,0}),
              Line(points={{8,-20},{40,-20}}, color={0,0,0}),
              Line(points={{-20,40},{-20,-20}}, color={0,0,0}),
              Line(points={{-20,-20},{-20,-70}}, color={0,0,0}),
              Text(
                extent={{-44,50},{-44,40}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid,
                textString="rising"),
              Text(
                extent={{24,-10},{24,-20}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid,
                textString="falling"),
              Polygon(
                points={{-60,40},{-56,42},{-56,38},{-60,40}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-30,40},{-34,42},{-34,38},{-30,40}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{8,-20},{12,-18},{12,-22},{8,-20}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{40,-20},{36,-18},{36,-22},{40,-20}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-22,-24},{-20,-20},{-18,-24},{-22,-24}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-18,-66},{-22,-66},{-20,-70},{-18,-66}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-22,36},{-20,40},{-18,36},{-22,36}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-18,-16},{-22,-16},{-20,-20},{-18,-16}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-40,6},{0,-4}},
                lineColor={255,255,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-20,6},{-20,-4}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid,
                textString="amplitude"),
              Rectangle(
                extent={{-40,-48},{0,-58}},
                lineColor={255,255,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-20,-48},{-20,-58}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Text(
                extent={{60,-82},{94,-92}},
                lineColor={0,0,0},
                textString="time"),
              Text(
                extent={{-88,-4},{-54,-14}},
                lineColor={0,0,0},
                textString="y"),
              Text(
                extent={{-88,-46},{-54,-56}},
                lineColor={0,0,0},
                textString="u")}),
          Documentation(info="<HTML>
<p>The block TriggeredTrapezoid has a boolean input and a real
output signal and requires the parameters <i>amplitude</i>,
<i>rising</i>, <i>falling</i> and <i>offset</i>. The
output signal <b>y</b> represents a trapezoidal signal dependent on the
input signal <b>u</b>.
</p>
<p>The behaviour is as follows: Assume the initial input to be false. In this
case, the output will be <i>offset</i>. After a rising edge (i.e. the input
changes from false to true), the output is rising during <i>rising</i> to the
sum of <i>offset</i> and <i>amplitude</i>. In contrast, after a falling
edge (i.e. the input changes from true to false), the output is falling
during <i>falling</i> to a value of <i>offset</i>.
</p>
<p>Note, that the case of edges before expiration of rising or falling is
handled properly.</p>
</HTML>
"));

      protected
        discrete Real endValue "Value of y at time of recent edge";
        discrete Real rate "Current rising/falling rate";
        discrete Modelica.SIunits.Time T
          "Predicted time of output reaching endValue";
      initial equation
        /* A start value of y is set, because pre(y) is present
     to avoid a warning message from the compiler. However,
     this setting does not have an effect, because y is initialized
     correctly, before pre(y) is used
  */
        pre(y) = 0;
      equation
          y = if time < T then endValue - (T - time)*rate else  endValue;

          when {initial(),u,not u} then
            endValue = if u then offset + amplitude else offset;
            rate = if u and (rising > 0) then amplitude/rising else 
              if not u and (falling > 0) then -amplitude/falling else 0;
            T = if u and not (rising > 0) or not u and not (falling
               > 0) or not abs(amplitude) > 0 or initial() then time else time
               + (endValue - pre(y))/rate;
          end when;
      end TriggeredTrapezoid;

      block Timer
        "Timer measuring the time from the time instant where the Boolean input became true"

        extends Interfaces.partialBooleanBlockIcon;
        Blocks.Interfaces.BooleanInput u "Connector of Boolean input signal" 
                                         annotation (Placement(transformation(
                extent={{-140,-20},{-100,20}}, rotation=0)));
        Blocks.Interfaces.RealOutput y "Connector of Real output signal" 
          annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));

        annotation (
          Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-70},{-60,-70},{-60,-26},{38,-26},{38,-70},{66,-70}},
                  color={255,0,255}),
              Line(points={{-80,0},{-62,0},{40,90},{40,0},{68,0}}, color={0,0,255})}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Line(points={{-90,-70},{82,-70}}, color={0,0,0}),
              Line(points={{-80,68},{-80,-80}}, color={0,0,0}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={0,0,0},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-68},{-60,-68},{-60,-40},{20,-40},{20,-68},{60,-68}},
                  color={255,0,255}),
              Line(points={{-80,-20},{-60,-20},{20,60},{20,-20},{60,-20},{60,-20}},
                  color={0,0,255}),
              Text(
                extent={{-88,6},{-54,-4}},
                lineColor={0,0,0},
                textString="y"),
              Text(
                extent={{48,-80},{84,-88}},
                lineColor={0,0,0},
                textString="time"),
              Text(
                extent={{-88,-36},{-54,-46}},
                lineColor={0,0,0},
                textString="u")}),
          Documentation(info="<HTML>
<p> When the Boolean input \"u\" becomes <b>true</b>, the timer is started
and the output \"y\" is the time from the time instant where u became true.
The timer is stopped and the output is reset to zero, once the
input becomes false.
</p>
</HTML>
"));
      protected
        discrete Modelica.SIunits.Time entryTime
          "Time instant when u became true";
      initial equation
        pre(entryTime) = 0;
      equation
        when u then
          entryTime = time;
        end when;
        y = if u then time - entryTime else 0.0;
      end Timer;

      block TerminateSimulation
        "Terminate simulation if condition is fullfilled"

        Modelica.Blocks.Interfaces.BooleanOutput condition=false
          "Terminate simulation when condition becomes true" 
          annotation (Dialog, Placement(transformation(extent={{200,-10},{220,10}},
                rotation=0)));
        parameter String terminationText = "... End condition reached"
          "Text that will be displayed when simulation is terminated";
        annotation (
          Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-200,-20},{200,20}},
              grid={2,2},
              initialScale=0.2), graphics={
              Rectangle(
                extent={{-200,20},{200,-20}},
                lineColor={0,0,0},
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid,
                borderPattern=BorderPattern.Raised),
              Text(
                extent={{-166,15},{194,-15}},
                lineColor={0,0,0},
                fillColor={0,255,0},
                fillPattern=FillPattern.Solid,
                textString="%condition"),
              Rectangle(
                extent={{-194,14},{-168,-14}},
                lineColor={0,0,0},
                fillColor={255,0,0},
                fillPattern=FillPattern.Solid,
                borderPattern=BorderPattern.Raised),
              Text(
                extent={{-200,46},{200,22}},
                lineColor={0,0,255},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                textString="%name")}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-200,-20},{200,20}},
              grid={2,2},
              initialScale=0.2), graphics),
          Documentation(info="<html>
<p>
In the parameter menu, a <b>time varying</b> expression can be defined 
via variable <b>condition</b>, for example \"condition = x &lt; 0\",
where \"x\" is a variable that is declared in the model in which the
\"TerminateSimulation\" block is present.
If this expression becomes <b>true</b>,
the simulation is (successfully) terminated. A termination message
explaining the reason for the termination can be given via
parameter \"terminationText\".
</p>
 
</html>"));

      equation
        when condition then
           terminate(terminationText);
        end when;
      end TerminateSimulation;
    end Logical;

    package Math "Library of mathematical functions as input/output blocks"
      import Modelica.SIunits;
      import Modelica.Blocks.Interfaces;
      extends Modelica.Icons.Library;

      annotation (
        Documentation(info="
<HTML>
<p>
This package contains basic <b>mathematical operations</b>,
such as summation and multiplication, and basic <b>mathematical
functions</b>, such as <b>sqrt</b> and <b>sin</b>, as
input/output blocks. All blocks of this library can be either
connected with continuous blocks or with sampled-data blocks.
</p>
</HTML>
",     revisions="<html>
<ul>
<li><i>October 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
       and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       New blocks added: RealToInteger, IntegerToReal, Max, Min, Edge, BooleanChange, IntegerChange.</li>
<li><i>August 7, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized (partly based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist).
</li>
</ul>
</html>"));

      encapsulated package UnitConversions
        "Conversion blocks to convert between SI and non-SI unit signals"
        import Modelica;
        import SI = Modelica.SIunits;
        import NonSI = Modelica.SIunits.Conversions.NonSIunits;

        block To_degC "Convert from Kelvin to Celsius"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="K"), y(
                unit="degC"));

          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="K"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="C")}),
                               Documentation(info="<html>
<p>
This block converts the input signal from Kelvin to Celsius and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_degC(u);
        end To_degC;

        block From_degC "Convert from Celsius to Kelvin"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="degC"),
              y(unit="K"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="C"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="K")}),
                              Documentation(info="<html>
<p>
This block converts the input signal from Celsius to Kelvin and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_degC(u);
        end From_degC;

        block To_degF "Convert from Kelvin to Fahrenheit"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="K"), y(
                unit="degF"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="K"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="F")}),
                               Documentation(info="<html>
<p>
This block converts the input signal from Kelvin to Fahrenheit and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_degF(u);
        end To_degF;

        block From_degF "Convert from Fahrenheit to Kelvin"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="degF"),
              y(unit="K"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="F"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="K")}),
                              Documentation(info="<html>
<p>
This block converts the input signal from Fahrenheit to Kelvin and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_degF(u);
        end From_degF;

        block To_degRk "Convert from Kelvin to Rankine"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="K"), y(
                unit="degRk"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="K"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="Rk")}),
                                Documentation(info="<html>
<p>
This block converts the input signal from Kelvin to Rankine and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_degRk(u);
        end To_degRk;

        block From_degRk "Convert from Rankine to Kelvin"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="degRk"),
              y(unit="K"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="Rk"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="K")}),
                              Documentation(info="<html>
<p>
This block converts the input signal from Rankine to Kelvin and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_degRk(u);
        end From_degRk;

        block To_deg "Convert from radian to degree"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="rad"),
              y(unit="deg"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="rad"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="deg")}),
                                Documentation(info="<html>
<p>
This block converts the input signal from radian to degree and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_deg(u);
        end To_deg;

        block From_deg "Convert from degree to radian"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="deg"),
              y(unit="rad"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="deg"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="rad")}),
                                Documentation(info="<html>
<p>
This block converts the input signal from degree to radian and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_deg(u);
        end From_deg;

        block To_rpm "Convert from radian per second to revolutions per minute"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="rad/s"),
              y(unit="1/min"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{26,82},{-98,50}},
                  lineColor={0,0,0},
                  textString="rad/s"), Text(
                  extent={{100,-42},{-62,-74}},
                  lineColor={0,0,0},
                  textString="1/min")}),
                                  Documentation(info="<html>
<p>
This block converts the input signal from radian per second to revolutions per minute and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_rpm(u);
        end To_rpm;

        block From_rpm
          "Convert from revolutions per minute to radian per second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit=
                  "1/min"), y(unit="rad/s"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{50,84},{-94,56}},
                  lineColor={0,0,0},
                  textString="1/min"), Text(
                  extent={{94,-42},{-26,-74}},
                  lineColor={0,0,0},
                  textString="rad/s")}),
                                  Documentation(info="<html>
<p>
This block converts the input signal from revolutions per minute to radian per second and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_rpm(u);
        end From_rpm;

        block To_kmh "Convert from metre per second to kilometre per hour"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="m/s"),
              y(unit="km/h"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{0,82},{-96,42}},
                  lineColor={0,0,0},
                  textString="m/s"), Text(
                  extent={{92,-40},{-14,-84}},
                  lineColor={0,0,0},
                  textString="km/h")}),
                                 Documentation(info="<html>
<p>
This block converts the input signal from metre per second to kilometre per hour and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_kmh(u);
        end To_kmh;

        block From_kmh "Convert from kilometre per hour to metre per second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="km/h"),
              y(unit="m/s"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{26,80},{-96,48}},
                  lineColor={0,0,0},
                  textString="km/h"), Text(
                  extent={{92,-46},{-20,-82}},
                  lineColor={0,0,0},
                  textString="m/s")}),
                                Documentation(info="<html>
<p>
This block converts the input signal from kilometre per hour to metre per second and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_kmh(u);
        end From_kmh;

        block To_day "Convert from second to day"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="s"), y(
                unit="d"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="s"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="day")}),
                                Documentation(info="<html>
<p>
This block converts the input signal from second to day and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_day(u);
        end To_day;

        block From_day "Convert from day to second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="d"), y(
                unit="s"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="day"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="s")}),
                              Documentation(info="<html>
<p>
This block converts the input signal from day to second and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_day(u);
        end From_day;

        block To_hour "Convert from second to hour"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="s"), y(
                unit="h"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="s"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="hour")}),
                                 Documentation(info="<html>
<p>
This block converts the input signal from second to hour and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_hour(u);
        end To_hour;

        block From_hour "Convert from hour to second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="h"), y(
                unit="s"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="hour"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="s")}),
                              Documentation(info="<html>
<p>
This block converts the input signal from hour to second and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_hour(u);
        end From_hour;

        block To_minute "Convert from second to minute"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="s"), y(
                unit="min"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="s"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="minute")}),
                                   Documentation(info="<html>
<p>
This block converts the input signal from second to minute and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_minute(u);
        end To_minute;

        block From_minute "Convert from minute to second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="min"),
              y(unit="s"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="minute"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="s")}),
                              Documentation(info="<html>
<p>
This block converts the input signal from minute to second and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_minute(u);
        end From_minute;

        block To_litre "Convert from cubic metre to litre"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="m3"), y(
                unit="l"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="m3"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="litre")}),
                                  Documentation(info="<html>
<p>
This block converts the input signal from metre to litre and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_litre(u);
        end To_litre;

        block From_litre "Convert from litre to cubic metre"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="l"), y(
                unit="m3"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="litre"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="m3")}),
                               Documentation(info="<html>
<p>
This block converts the input signal from litre to cubic metre and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_litre(u);
        end From_litre;

        block To_kWh "Convert from Joule to kilo Watt hour"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="J"), y(
                unit="kW.h"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="J"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="kW.h")}),
                                 Documentation(info="<html>
<p>
This block converts the input signal from Joule to kilo Watt hour and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_kWh(u);
        end To_kWh;

        block From_kWh "Convert from kilo Watt hour to Joule"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="kW.h"),
              y(unit="J"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="kW.h"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="J")}),
                              Documentation(info="<html>
<p>
This block converts the input signal from kilo Watt hour to Joule and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_kWh(u);
        end From_kWh;

        block To_bar "Convert from Pascal to bar"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="Pa"), y(
                unit="bar"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="Pa"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="bar")}),
                                Documentation(info="<html>
<p>
This block converts the input signal from Pascal to bar and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_bar(u);
        end To_bar;

        block From_bar "Convert from bar to Pascal"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="bar"),
              y(unit="Pa"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="bar"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="Pa")}),
                               Documentation(info="<html>
<p>
This block converts the input signal from bar to Pascal and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_bar(u);
        end From_bar;

        block To_gps "Convert from kilogram per second to gram per second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="kg/s"),
              y(unit="g/s"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="kg/s"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="g/s")}),
                                Documentation(info="<html>
<p>
This block converts the input signal from kilogram per second to gram per seconds and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.to_gps(u);
        end To_gps;

        block From_gps "Convert from gram per second to kilogram per second"
          extends Modelica.Blocks.Interfaces.PartialConversionBlock(u(unit="g/s"),
              y(unit="kg/s"));
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-20,100},{-100,20}},
                  lineColor={0,0,0},
                  textString="g/s"), Text(
                  extent={{100,-20},{20,-100}},
                  lineColor={0,0,0},
                  textString="kg/s")}),
                                 Documentation(info="<html>
<p>
This block converts the input signal from gram per second to kilogram per second and returns
the result as output signal.
</p>
</html>"));
        equation
          y = SI.Conversions.from_gps(u);
        end From_gps;
        annotation (Documentation(info="<html>
<p>
This package consists of blocks that convert an input signal 
with a specific unit to an output signal in another unit
(e.g. conversion of an angle signal from \"deg\" to \"rad\").
Block \"ConvertAllUnits\" converts between a set of units that
can be selected in a pull-down menu of the parameter menu.
All other blocks convert exactly between two different units.
</p>
 
</html>"));
      end UnitConversions;

      block InverseBlockConstraints
        "Construct inverse model by requiring that two inputs and two outputs are identical (replaces the previously, unbalanced, TwoInputs and TwoOutputs blocks)"

        Modelica.Blocks.Interfaces.RealInput u1 "Input signal 1 (u1 = u2)" 
                                annotation (Placement(transformation(extent={{-240,
                  -20},{-200,20}}, rotation=0), iconTransformation(extent={{-240,-20},
                  {-200,20}})));
        Modelica.Blocks.Interfaces.RealInput u2 "Input signal 2 (u1 = u2)" 
                                annotation (Placement(transformation(extent={{-140,
                  -20},{-180,20}}, rotation=0), iconTransformation(extent={{-140,-20},
                  {-180,20}})));
        Modelica.Blocks.Interfaces.RealOutput y1 "Output signal 1 (y1 = y2)" 
                                 annotation (Placement(transformation(extent={{200,-10},
                  {220,10}},      rotation=0), iconTransformation(extent={{200,-10},{
                  220,10}})));
        Modelica.Blocks.Interfaces.RealOutput y2 "Output signal 2 (y2 = y2)" 
                                 annotation (Placement(transformation(extent={{10,-10},
                  {-10,10}},       rotation=0,
              origin={170,0}),  iconTransformation(extent={{180,-10},{160,10}})));

        annotation(__Dymola_structurallyIncomplete=true,
          Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-200,-100},{
                  200,100}}),
                  graphics),
          Icon(coordinateSystem(preserveAspectRatio=false, extent={{-200,-100},{200,
                  100}}), graphics={
              Line(
                points={{180,0},{200,0}},
                color={0,0,127},
                smooth=Smooth.None),
              Line(
                points={{-200,0},{-180,0}},
                color={0,0,127},
                smooth=Smooth.None),
              Rectangle(
                extent={{-190,110},{190,-110}},
                lineColor={135,135,135},
                lineThickness=0.5)}),
          Documentation(info="<html>
<p>
Exchange input and ouput signals of a block, i.e., the previous
block inputs become block outputs and the previous block outputs become
block inputs. This block is used to construct inverse models.
Its usage is demonstrated in example:
<a href=\"Modelica://Modelica.Blocks.Examples.InverseModel\">Modelica.Blocks.Examples.InverseModel</a>.
</p>
 
<p>
Note, if a block shall be inverted that has several input and output blocks,
then this can be easily achieved by using a vector of InverseBlockConstraints 
instances:
</p>
 
<pre>
   InverseBlockConstraint invert[3];  // Block to be inverted has 3 input signals
</pre>
</html>"));
      equation
        u1 = u2;
        y1 = y2;
      end InverseBlockConstraints;

          block Gain "Output the product of a gain value with the input signal"

            parameter Real k(start=1) "Gain value multiplied with input signal";
      public
            Interfaces.RealInput u "Input signal connector" 
              annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
            Interfaces.RealOutput y "Output signal connector" 
              annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
            annotation (
              Documentation(info="
<HTML>
<p>
This block computes output <i>y</i> as
<i>product</i> of gain <i>k</i> with the
input <i>u</i>:
</p>
<pre>
    y = k * u;
</pre>

</HTML>
"),           Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Polygon(
                points={{-100,-100},{-100,100},{100,0},{-100,-100}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-150,-140},{150,-100}},
                lineColor={0,0,0},
                textString="k=%k"),
              Text(
                extent={{-150,140},{150,100}},
                textString="%name",
                lineColor={0,0,255})}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={Polygon(
                points={{-100,-100},{-100,100},{100,0},{-100,-100}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid), Text(
                extent={{-76,38},{0,-34}},
                textString="k",
                lineColor={0,0,255})}));

          equation
            y = k*u;
          end Gain;

          block MatrixGain
        "Output the product of a gain matrix with the input signal vector"

            parameter Real K[:, :]=[1, 0; 0, 1]
          "Gain matrix which is multiplied with the input";
            extends Interfaces.MIMO(final nin=size(K, 2), final nout=size(K, 1));
            annotation (
              Documentation(info="
<HTML>
<p>
This blocks computes output vector <b>y</b> as <i>product</i> of the
gain matrix <b>K</b> with the input signal vector <b>u</b>:
</p>
<pre>
    <b>y</b> = <b>K</b> * <b>u</b>;
</pre>
<p>
Example:
</p>
<pre>
   parameter: <b>K</b> = [0.12 2; 3 1.5]

   results in the following equations:

     | y[1] |     | 0.12  2.00 |   | u[1] |
     |      |  =  |            | * |      |
     | y[2] |     | 3.00  1.50 |   | u[2] |
</pre>

</HTML>
"),           Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={Text(
                extent={{-90,-60},{90,60}},
                lineColor={160,160,164},
                textString="*K"), Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255})}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid), Text(
                extent={{-90,-60},{90,60}},
                lineColor={160,160,164},
                textString="*K")}));
          equation
            y = K*u;
          end MatrixGain;

          block Sum "Output the sum of the elements of the input vector"
            extends Interfaces.MISO;
            parameter Real k[nin]=ones(nin) "Optional: sum coefficients";
            annotation (defaultComponentName="sum1",
              Documentation(info="
<HTML>
<p>
This blocks computes output <b>y</b> as
<i>sum</i> of the elements of the input signal vector
<b>u</b>:
</p>
<pre>
    <b>y</b> = <b>u</b>[1] + <b>u</b>[2] + ...;
</pre>
<p>
Example:
</p>
<pre>
     parameter:   nin = 3;

  results in the following equations:

     y = u[1] + u[2] + u[3];
</pre>

</HTML>
"),           Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={Line(
                points={{26,42},{-34,42},{6,2},{-34,-38},{26,-38}},
                color={0,0,0},
                thickness=0.25), Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255})}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid), Line(
                points={{26,42},{-34,42},{6,2},{-34,-38},{26,-38}},
                color={0,0,0},
                thickness=0.25)}));
          equation
            y = k*u;
          end Sum;

          block Feedback
        "Output difference between commanded and feedback input"

            input Interfaces.RealInput u1 annotation (Placement(transformation(
                extent={{-100,-20},{-60,20}}, rotation=0)));
            input Interfaces.RealInput u2 
              annotation (Placement(transformation(
              origin={0,-80},
              extent={{-20,-20},{20,20}},
              rotation=90)));
            output Interfaces.RealOutput y annotation (Placement(transformation(
                extent={{80,-10},{100,10}}, rotation=0)));
            annotation (
              Documentation(info="
<HTML>
<p>
This blocks computes output <b>y</b> as <i>difference</i> of the
commanded input <b>u1</b> and the feedback
input <b>u2</b>:
</p>
<pre>
    <b>y</b> = <b>u1</b> - <b>u2</b>;
</pre>
<p>
Example:
</p>
<pre>
     parameter:   n = 2

  results in the following equations:

     y = u1 - u2
</pre>

</HTML>
"),           Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Ellipse(
                extent={{-20,20},{20,-20}},
                lineColor={0,0,127},
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid),
              Line(points={{-60,0},{-20,0}}, color={0,0,127}),
              Line(points={{20,0},{80,0}}, color={0,0,127}),
              Line(points={{0,-20},{0,-60}}, color={0,0,127}),
              Text(
                extent={{-14,0},{82,-94}},
                lineColor={0,0,0},
                textString="-"),
              Text(
                extent={{-100,110},{100,60}},
                textString="%name",
                lineColor={0,0,255})}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Ellipse(
                extent={{-20,20},{20,-20}},
                pattern=LinePattern.Solid,
                lineThickness=0.25,
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Line(points={{-60,0},{-20,0}}, color={0,0,255}),
              Line(points={{20,0},{80,0}}, color={0,0,255}),
              Line(points={{0,-20},{0,-60}}, color={0,0,255}),
              Text(
                extent={{-12,10},{84,-84}},
                lineColor={0,0,0},
                textString="-")}));

          equation
            y = u1 - u2;
          end Feedback;

          block Add "Output the sum of the two inputs"
            extends Interfaces.SI2SO;
            parameter Real k1=+1 "Gain of upper input";
            parameter Real k2=+1 "Gain of lower input";
            annotation (
              Documentation(info="
<HTML>
<p>
This blocks computes output <b>y</b> as <i>sum</i> of the
two input signals <b>u1</b> and <b>u2</b>:
</p>
<pre>
    <b>y</b> = k1*<b>u1</b> + k2*<b>u2</b>;
</pre>
<p>
Example:
</p>
<pre>
     parameter:   k1= +2, k2= -3

  results in the following equations:

     y = 2 * u1 - 3 * u2
</pre>

</HTML>
"),           Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-98,-52},{7,-92}},
                lineColor={0,0,0},
                textString="%k2"),
              Text(
                extent={{-100,90},{5,50}},
                lineColor={0,0,0},
                textString="%k1"),
              Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255}),
              Line(points={{-100,60},{-40,60},{-30,40}}, color={0,0,255}),
              Ellipse(extent={{-50,50},{50,-50}}, lineColor={0,0,255}),
              Line(points={{-100,-60},{-40,-60},{-30,-40}}, color={0,0,255}),
              Line(points={{-15,-25.99},{15,25.99}}, color={0,0,0}),
              Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{50,0},{100,0}}, color={0,0,255}),
              Line(points={{-100,60},{-74,24},{-44,24}}, color={0,0,127}),
              Line(points={{-100,-60},{-74,-28},{-42,-28}}, color={0,0,127}),
              Ellipse(extent={{-50,50},{50,-50}}, lineColor={0,0,127}),
              Line(points={{50,0},{100,0}}, color={0,0,127}),
              Text(
                extent={{-38,34},{38,-34}},
                lineColor={0,0,0},
                textString="+"),
              Text(
                extent={{-100,52},{5,92}},
                lineColor={0,0,0},
                textString="%k1"),
              Text(
                extent={{-100,-52},{5,-92}},
                lineColor={0,0,0},
                textString="%k2")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-98,-52},{7,-92}},
                lineColor={0,0,0},
                textString="%k2"),
              Text(
                extent={{-100,90},{5,50}},
                lineColor={0,0,0},
                textString="%k1"),
              Line(points={{-100,60},{-40,60},{-30,40}}, color={0,0,255}),
              Ellipse(extent={{-50,50},{50,-50}}, lineColor={0,0,255}),
              Line(points={{-100,-60},{-40,-60},{-30,-40}}, color={0,0,255}),
              Line(points={{-15,-25.99},{15,25.99}}, color={0,0,0}),
              Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{50,0},{100,0}}, color={0,0,255}),
              Line(points={{-100,60},{-74,24},{-44,24}}, color={0,0,127}),
              Line(points={{-100,-60},{-74,-28},{-42,-28}}, color={0,0,127}),
              Ellipse(extent={{-50,50},{50,-50}}, lineColor={0,0,127}),
              Line(points={{50,0},{100,0}}, color={0,0,127}),
              Text(
                extent={{-38,34},{38,-34}},
                lineColor={0,0,0},
                textString="+"),
              Text(
                extent={{-100,52},{5,92}},
                lineColor={0,0,0},
                textString="k1"),
              Text(
                extent={{-100,-52},{5,-92}},
                lineColor={0,0,0},
                textString="k2")}));

          equation
            y = k1*u1 + k2*u2;
          end Add;

          block Add3 "Output the sum of the three inputs"
            extends Interfaces.BlockIcon;

            parameter Real k1=+1 "Gain of upper input";
            parameter Real k2=+1 "Gain of middle input";
            parameter Real k3=+1 "Gain of lower input";
            input Interfaces.RealInput u1 "Connector 1 of Real input signals" 
              annotation (Placement(transformation(extent={{-140,60},{-100,100}},
                rotation=0)));
            input Interfaces.RealInput u2 "Connector 2 of Real input signals" 
              annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
            input Interfaces.RealInput u3 "Connector 3 of Real input signals" 
              annotation (Placement(transformation(extent={{-140,-100},{-100,-60}},
                rotation=0)));
            output Interfaces.RealOutput y "Connector of Real output signals" 
              annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
            annotation (
              Documentation(info="
<HTML>
<p>
This blocks computes output <b>y</b> as <i>sum</i> of the
three input signals <b>u1</b>, <b>u2</b> and <b>u3</b>:
</p>
<pre>
    <b>y</b> = k1*<b>u1</b> + k2*<b>u2</b> + k3*<b>u3</b>;
</pre>
<p>
Example:
</p>
<pre>
     parameter:   k1= +2, k2= -3, k3=1;

  results in the following equations:

     y = 2 * u1 - 3 * u2 + u3;
</pre>
 
</HTML>
"),           Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-100,50},{5,90}},
                lineColor={0,0,0},
                textString="%k1"),
              Text(
                extent={{-100,-20},{5,20}},
                lineColor={0,0,0},
                textString="%k2"),
              Text(
                extent={{-100,-50},{5,-90}},
                lineColor={0,0,0},
                textString="%k3"),
              Text(
                extent={{2,36},{100,-44}},
                lineColor={0,0,0},
                textString="+")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-100,50},{5,90}},
                lineColor={0,0,0},
                textString="%k1"),
              Text(
                extent={{-100,-20},{5,20}},
                lineColor={0,0,0},
                textString="%k2"),
              Text(
                extent={{-100,-50},{5,-90}},
                lineColor={0,0,0},
                textString="%k3"),
              Text(
                extent={{2,36},{100,-44}},
                lineColor={0,0,0},
                textString="+"),
              Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-100,50},{5,90}},
                lineColor={0,0,0},
                textString="k1"),
              Text(
                extent={{-100,-20},{5,20}},
                lineColor={0,0,0},
                textString="k2"),
              Text(
                extent={{-100,-50},{5,-90}},
                lineColor={0,0,0},
                textString="k3"),
              Text(
                extent={{2,36},{100,-44}},
                lineColor={0,0,0},
                textString="+")}));

          equation
            y = k1*u1 + k2*u2 + k3*u3;
          end Add3;

          block Product "Output product of the two inputs"
            extends Interfaces.SI2SO;
            annotation (
              Documentation(info="
<HTML>
<p>
This blocks computes the output <b>y</b> (element-wise)
as <i>product</i> of the corresponding elements of
the two inputs <b>u1</b> and <b>u2</b>:
</p>
<pre>
    y = u1 * u2;
</pre>

</HTML>
"),           Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-100,60},{-40,60},{-30,40}}, color={0,0,127}),
              Line(points={{-100,-60},{-40,-60},{-30,-40}}, color={0,0,127}),
              Line(points={{50,0},{100,0}}, color={0,0,127}),
              Line(points={{-30,0},{30,0}}, color={0,0,0}),
              Line(points={{-15,25.99},{15,-25.99}}, color={0,0,0}),
              Line(points={{-15,-25.99},{15,25.99}}, color={0,0,0}),
              Ellipse(extent={{-50,50},{50,-50}}, lineColor={0,0,127})}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,60},{-40,60},{-30,40}}, color={0,0,255}),
              Line(points={{-100,-60},{-40,-60},{-30,-40}}, color={0,0,255}),
              Line(points={{50,0},{100,0}}, color={0,0,255}),
              Line(points={{-30,0},{30,0}}, color={0,0,0}),
              Line(points={{-15,25.99},{15,-25.99}}, color={0,0,0}),
              Line(points={{-15,-25.99},{15,25.99}}, color={0,0,0}),
              Ellipse(extent={{-50,50},{50,-50}}, lineColor={0,0,255})}));

          equation
            y = u1*u2;
          end Product;

          block Division "Output first input divided by second input"
            extends Interfaces.SI2SO;
            annotation (
              Documentation(info="
<HTML>
<p>
This block computes the output <b>y</b> (element-wise)
by <i>dividing</i> the corresponding elements of
the two inputs <b>u1</b> and <b>u2</b>:
</p>
<pre>
    y = u1 / u2;
</pre>

</HTML>
"),           Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{50,0},{100,0}}, color={0,0,127}),
              Line(points={{-30,0},{30,0}}, color={0,0,0}),
              Ellipse(
                extent={{-5,20},{5,30}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{-5,-20},{5,-30}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid),
              Ellipse(extent={{-50,50},{50,-50}}, lineColor={0,0,127}),
              Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255}),
              Line(points={{-100,60},{-66,60},{-40,30}}, color={0,0,127}),
              Line(points={{-100,-60},{0,-60},{0,-50}}, color={0,0,127})}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{50,0},{100,0}}, color={0,0,255}),
              Line(points={{-30,0},{30,0}}, color={0,0,0}),
              Ellipse(
                extent={{-5,20},{5,30}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{-5,-20},{5,-30}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid),
              Ellipse(extent={{-50,50},{50,-50}}, lineColor={0,0,255}),
              Line(points={{-100,60},{-66,60},{-40,30}}, color={0,0,255}),
              Line(points={{-100,-60},{0,-60},{0,-50}}, color={0,0,255})}));

          equation
            y = u1/u2;
          end Division;

          block Abs "Output the absolute value of the input"
            extends Interfaces.SISO;
            annotation (defaultComponentName="abs1",
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Polygon(
                points={{92,0},{70,8},{70,-8},{92,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,80},{0,0},{80,80}}, color={0,0,0}),
              Line(points={{0,-14},{0,68}}, color={192,192,192}),
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-34,-28},{38,-76}},
                lineColor={192,192,192},
                textString="abs"),
              Line(points={{-88,0},{76,0}}, color={192,192,192})}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-100,0},{76,0}}, color={192,192,192}),
              Polygon(
                points={{92,0},{76,6},{76,-6},{92,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,80},{0,0},{80,80}}, color={0,0,0}),
              Line(points={{0,-80},{0,68}}, color={192,192,192}),
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{0,-80},{0,68}}, color={192,192,192}),
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{7,98},{34,78}},
                lineColor={160,160,164},
                textString="u"),
              Text(
                extent={{74,-8},{96,-28}},
                lineColor={160,160,164},
                textString="y"),
              Text(
                extent={{52,-3},{72,-23}},
                textString="1",
                lineColor={0,0,255}),
              Text(
                extent={{-86,-1},{-66,-21}},
                textString="-1",
                lineColor={0,0,255}),
              Text(
                extent={{-28,79},{-8,59}},
                textString="1",
                lineColor={0,0,255})}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b>
as <i>absolute value</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>abs</b>( u );
</pre>

</HTML>
"));
          equation
            y = abs(u);
          end Abs;

          block Sign "Output the sign of the input"
            extends Interfaces.SISO;
            annotation (defaultComponentName="sign1",
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{0,-80}}, color={0,0,0}),
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{0,-80},{0,68}}, color={192,192,192}),
              Text(
                extent={{-90,72},{-18,24}},
                lineColor={192,192,192},
                textString="sign"),
              Line(points={{0,80},{80,80}}, color={0,0,0}),
              Rectangle(
                extent={{-2,2},{2,-4}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid)}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{0,-80}}, color={0,0,0}),
              Line(points={{-0.01,0},{0.01,0}}, color={0,0,0}),
              Line(points={{0,80},{80,80}}, color={0,0,0}),
              Rectangle(
                extent={{-2,2},{2,-4}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{0,100},{-6,84},{6,84},{0,100}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{0,-90},{0,84}}, color={192,192,192}),
              Text(
                extent={{7,102},{32,82}},
                lineColor={160,160,164},
                textString="y"),
              Text(
                extent={{70,-6},{94,-26}},
                lineColor={160,160,164},
                textString="u"),
              Text(
                extent={{-25,86},{-5,70}},
                textString="1",
                lineColor={0,0,255}),
              Text(
                extent={{5,-72},{25,-88}},
                textString="-1",
                lineColor={0,0,255})}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b>
as <b>sign</b> of the input <b>u</b>:
</p>
<pre>
         1  <b>if</b> u > 0
    y =  0  <b>if</b> u == 0
        -1  <b>if</b> u < 0
</pre>

</HTML>
"));
          equation
            y = sign(u);
          end Sign;

          block Sqrt
        "Output the square root of the input (input >= 0 required)"
            extends Interfaces.SISO;
            annotation (defaultComponentName="sqrt1",
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-90,-80},{68,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-80},{68,-72},{68,-88},{90,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-79.2,-68.7},{-78.4,-64},{-76.8,-57.3},{-73.6,
                    -47.9},{-67.9,-36.1},{-59.1,-22.2},{-46.2,-6.49},{-28.5,10.7},{
                    -4.42,30},{27.7,51.3},{69.5,74.7},{80,80}}, color={0,0,0}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-88},{-80,68}}, color={192,192,192}),
              Text(
                extent={{-8,-4},{64,-52}},
                lineColor={192,192,192},
                textString="sqrt")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-92,-80},{84,-80}}, color={192,192,192}),
              Polygon(
                points={{100,-80},{84,-74},{84,-86},{100,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-79.2,-68.7},{-78.4,-64},{-76.8,-57.3},{-73.6,
                    -47.9},{-67.9,-36.1},{-59.1,-22.2},{-46.2,-6.49},{-28.5,10.7},{
                    -4.42,30},{27.7,51.3},{69.5,74.7},{80,80}}, color={0,0,0}),
              Polygon(
                points={{-80,98},{-86,82},{-74,82},{-80,98}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-90},{-80,84}}, color={192,192,192}),
              Text(
                extent={{-71,98},{-44,78}},
                lineColor={160,160,164},
                textString="y"),
              Text(
                extent={{60,-52},{84,-72}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b>
as <i>square root</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>sqrt</b>( u );
</pre>
<p>
All elements of the input vector shall be zero or positive.
Otherwise an error occurs.
</p>

</HTML>
"));

          equation
            y = sqrt(u);
          end Sqrt;

          block Sin "Output the sine of the input"
            extends Interfaces.SISO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-80,68}}, color={192,192,192}),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Line(points={{-80,0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,
                    74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,
                    59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,
                    -64.2},{29.3,-73.1},{35,-78.4},{40.6,-80},{46.2,-77.6},{51.9,-71.5},
                    {57.5,-61.9},{63.9,-47.2},{72,-24.8},{80,0}}, color={0,0,0}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{12,84},{84,36}},
                lineColor={192,192,192},
                textString="sin")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,80},{-88,80}}, color={192,192,192}),
              Line(points={{-80,-80},{-88,-80}}, color={192,192,192}),
              Line(points={{-80,-90},{-80,84}}, color={192,192,192}),
              Text(
                extent={{-75,98},{-46,78}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{-80,96},{-86,80},{-74,80},{-80,96}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,
                    74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,
                    59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,
                    -64.2},{29.3,-73.1},{35,-78.4},{40.6,-80},{46.2,-77.6},{51.9,-71.5},
                    {57.5,-61.9},{63.9,-47.2},{72,-24.8},{80,0}}, color={0,0,0}),
              Text(
                extent={{-105,72},{-85,88}},
                textString="1",
                lineColor={0,0,255}),
              Text(
                extent={{70,25},{90,5}},
                textString="2*pi",
                lineColor={0,0,255}),
              Text(
                extent={{-105,-72},{-85,-88}},
                textString="-1",
                lineColor={0,0,255}),
              Text(
                extent={{76,-10},{98,-30}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b>
as <b>sine</b> of the input <b>u</b>:
</p>
<pre>
    y = <b>sin</b>( u );
</pre>

<p>
<img src=\"../Images/Math/sin.png\">
</p>

</HTML>
"));
          equation
            y = Modelica.Math.sin(u);
          end Sin;

          block Cos "Output the cosine of the input"
            extends Interfaces.SISO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-80,68}}, color={192,192,192}),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,80},{-74.4,78.1},{-68.7,72.3},{-63.1,63},{-56.7,
                    48.7},{-48.6,26.6},{-29.3,-32.5},{-22.1,-51.7},{-15.7,-65.3},{-10.1,
                    -73.8},{-4.42,-78.8},{1.21,-79.9},{6.83,-77.1},{12.5,-70.6},{
                    18.1,-60.6},{24.5,-45.7},{32.6,-23},{50.3,31.3},{57.5,50.7},{
                    63.9,64.6},{69.5,73.4},{75.2,78.6},{80,80}}, color={0,0,0}),
              Text(
                extent={{-36,82},{36,34}},
                lineColor={192,192,192},
                textString="cos")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,80},{-88,80}}, color={192,192,192}),
              Line(points={{-80,-80},{-88,-80}}, color={192,192,192}),
              Line(points={{-80,-90},{-80,84}}, color={192,192,192}),
              Text(
                extent={{-75,102},{-48,82}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{-80,100},{-86,84},{-74,84},{-80,100}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-103,72},{-83,88}},
                textString="1",
                lineColor={0,0,255}),
              Text(
                extent={{-79,-72},{-59,-88}},
                textString="-1",
                lineColor={0,0,255}),
              Text(
                extent={{70,25},{90,5}},
                textString="2*pi",
                lineColor={0,0,255}),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,80},{-74.4,78.1},{-68.7,72.3},{-63.1,63},{-56.7,
                    48.7},{-48.6,26.6},{-29.3,-32.5},{-22.1,-51.7},{-15.7,-65.3},{-10.1,
                    -73.8},{-4.42,-78.8},{1.21,-79.9},{6.83,-77.1},{12.5,-70.6},{
                    18.1,-60.6},{24.5,-45.7},{32.6,-23},{50.3,31.3},{57.5,50.7},{
                    63.9,64.6},{69.5,73.4},{75.2,78.6},{80,80}}, color={0,0,0}),
              Text(
                extent={{74,-4},{98,-24}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b>
as <b>cos</b> of the input <b>u</b>:
</p>
<pre>
    y = <b>cos</b>( u );
</pre>

<p>
<img src=\"../Images/Math/cos.png\">
</p>

</HTML>
"));

          equation
            y = Modelica.Math.cos(u);
          end Cos;

          block Tan "Output the tangent of the input"
            extends Interfaces.SISO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{0,-80},{0,68}}, color={192,192,192}),
              Line(points={{-80,-80},{-78.4,-68.4},{-76.8,-59.7},{-74.4,-50},{-71.2,
                    -40.9},{-67.1,-33},{-60.7,-24.8},{-51.1,-17.2},{-35.8,-9.98},{-4.42,
                    -1.07},{33.4,9.12},{49.4,16.2},{59.1,23.2},{65.5,30.6},{70.4,
                    39.1},{73.6,47.4},{76,56.1},{77.6,63.8},{80,80}}, color={0,0,0}),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-90,72},{-18,24}},
                lineColor={192,192,192},
                textString="tan")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,80},{-8,80}}, color={192,192,192}),
              Line(points={{0,-80},{-8,-80}}, color={192,192,192}),
              Line(points={{0,-88},{0,86}}, color={192,192,192}),
              Text(
                extent={{11,100},{38,80}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{0,102},{-6,86},{6,86},{0,102}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-37,-72},{-17,-88}},
                textString="-5.8",
                lineColor={0,0,255}),
              Text(
                extent={{-33,86},{-13,70}},
                textString=" 5.8",
                lineColor={0,0,255}),
              Text(
                extent={{70,25},{90,5}},
                textString="1.4",
                lineColor={0,0,255}),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-78.4,-68.4},{-76.8,-59.7},{-74.4,-50},{-71.2,
                    -40.9},{-67.1,-33},{-60.7,-24.8},{-51.1,-17.2},{-35.8,-9.98},{-4.42,
                    -1.07},{33.4,9.12},{49.4,16.2},{59.1,23.2},{65.5,30.6},{70.4,
                    39.1},{73.6,47.4},{76,56.1},{77.6,63.8},{80,80}}, color={0,0,0}),
              Text(
                extent={{70,-6},{94,-26}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b>
as <b>tan</b> of the input <b>u</b>:
</p>
<pre>
    y = <b>tan</b>( u );
</pre>

<p>
<img src=\"../Images/Math/tan.png\">
</p>

</HTML>
"));

          equation
            y = Modelica.Math.tan(u);
          end Tan;

          block Asin "Output the arc sine of the input"
            extends Interfaces.SISO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{0,-80},{0,68}}, color={192,192,192}),
              Line(points={{-80,-80},{-79.2,-72.8},{-77.6,-67.5},{-73.6,-59.4},{-66.3,
                    -49.8},{-53.5,-37.3},{-30.2,-19.7},{37.4,24.8},{57.5,40.8},{
                    68.7,52.7},{75.2,62.2},{77.6,67.5},{80,80}}, color={0,0,0}),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-88,78},{-16,30}},
                lineColor={192,192,192},
                textString="asin")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,80},{-8,80}}, color={192,192,192}),
              Line(points={{0,-80},{-8,-80}}, color={192,192,192}),
              Line(points={{0,-90},{0,84}}, color={192,192,192}),
              Text(
                extent={{9,102},{36,82}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{0,100},{-6,84},{6,84},{0,100}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-40,-72},{-15,-88}},
                textString="-pi/2",
                lineColor={0,0,255}),
              Text(
                extent={{-38,88},{-13,72}},
                textString=" pi/2",
                lineColor={0,0,255}),
              Text(
                extent={{70,25},{90,5}},
                textString="+1",
                lineColor={0,0,255}),
              Text(
                extent={{-90,21},{-70,1}},
                textString="-1",
                lineColor={0,0,255}),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-79.2,-72.8},{-77.6,-67.5},{-73.6,-59.4},{-66.3,
                    -49.8},{-53.5,-37.3},{-30.2,-19.7},{37.4,24.8},{57.5,40.8},{
                    68.7,52.7},{75.2,62.2},{77.6,67.5},{80,80}}, color={0,0,0}),
              Text(
                extent={{74,-4},{100,-26}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>sine-inverse</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>asin</b>( u );
</pre>
<p>
The absolute values of the elements of the input <b>u</b> need to
be less or equal to one (<b>abs</b>( u ) <= 1).
Otherwise an error occurs.
</p>

<p>
<img src=\"../Images/Math/asin.png\">
</p>

</HTML>
"));

          equation
            y = Modelica.Math.asin(u);
          end Asin;

          block Acos "Output the arc cosine of the input"
            extends Interfaces.SISO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,80},{-79.2,72.8},{-77.6,67.5},{-73.6,59.4},{-66.3,
                    49.8},{-53.5,37.3},{-30.2,19.7},{37.4,-24.8},{57.5,-40.8},{68.7,
                    -52.7},{75.2,-62.2},{77.6,-67.5},{80,-80}}, color={0,0,0}),
              Line(points={{0,-88},{0,68}}, color={192,192,192}),
              Line(points={{-90,-80},{68,-80}}, color={192,192,192}),
              Polygon(
                points={{90,-80},{68,-72},{68,-88},{90,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-86,-14},{-14,-62}},
                lineColor={192,192,192},
                textString="acos")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,80},{-8,80}}, color={192,192,192}),
              Line(points={{0,-80},{-8,-80}}, color={192,192,192}),
              Line(points={{0,-90},{0,84}}, color={192,192,192}),
              Text(
                extent={{13,100},{42,82}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{0,100},{-6,84},{6,84},{0,100}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,-80},{84,-80}}, color={192,192,192}),
              Polygon(
                points={{100,-80},{84,-74},{84,-86},{100,-80}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,80},{-79.2,72.8},{-77.6,67.5},{-73.6,59.4},{-66.3,
                    49.8},{-53.5,37.3},{-30.2,19.7},{37.4,-24.8},{57.5,-40.8},{68.7,
                    -52.7},{75.2,-62.2},{77.6,-67.5},{80,-80}}, color={0,0,0}),
              Text(
                extent={{-30,88},{-5,72}},
                textString=" pi",
                lineColor={0,0,255}),
              Text(
                extent={{-94,-57},{-74,-77}},
                textString="-1",
                lineColor={0,0,255}),
              Text(
                extent={{80,-45},{100,-65}},
                textString="+1",
                lineColor={0,0,255}),
              Text(
                extent={{76,-84},{102,-102}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>cosine-inverse</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>acos</b>( u );
</pre>
<p>
The absolute values of the elements of the input <b>u</b> need to
be less or equal to one (<b>abs</b>( u ) <= 1).
Otherwise an error occurs.
</p>

<p>
<img src=\"../Images/Math/acos.png\">
</p>

</HTML>
"));
          equation
            y = Modelica.Math.acos(u);
          end Acos;

          block Atan "Output the arc tangent of the input"
            extends Interfaces.SISO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{0,-80},{0,68}}, color={192,192,192}),
              Line(points={{-80,-80},{-52.7,-75.2},{-37.4,-69.7},{-26.9,-63},{-19.7,
                    -55.2},{-14.1,-45.8},{-10.1,-36.4},{-6.03,-23.9},{-1.21,-5.06},
                    {5.23,21},{9.25,34.1},{13.3,44.2},{18.1,52.9},{24.5,60.8},{33.4,
                    67.6},{47,73.6},{69.5,78.6},{80,80}}, color={0,0,0}),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-86,68},{-14,20}},
                lineColor={192,192,192},
                textString="atan")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,80},{-8,80}}, color={192,192,192}),
              Line(points={{0,-80},{-8,-80}}, color={192,192,192}),
              Line(points={{0,-90},{0,84}}, color={192,192,192}),
              Text(
                extent={{13,102},{42,82}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{0,100},{-6,84},{6,84},{0,100}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-52.7,-75.2},{-37.4,-69.7},{-26.9,-63},{-19.7,
                    -55.2},{-14.1,-45.8},{-10.1,-36.4},{-6.03,-23.9},{-1.21,-5.06},
                    {5.23,21},{9.25,34.1},{13.3,44.2},{18.1,52.9},{24.5,60.8},{33.4,
                    67.6},{47,73.6},{69.5,78.6},{80,80}}, color={0,0,0}),
              Text(
                extent={{-32,91},{-12,71}},
                textString="1.4",
                lineColor={0,0,255}),
              Text(
                extent={{-32,-71},{-12,-91}},
                textString="-1.4",
                lineColor={0,0,255}),
              Text(
                extent={{73,26},{93,10}},
                textString=" 5.8",
                lineColor={0,0,255}),
              Text(
                extent={{-103,20},{-83,4}},
                textString="-5.8",
                lineColor={0,0,255}),
              Text(
                extent={{66,-8},{94,-28}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>tangent-inverse</i> of the input <b>u</b>:
</p>
<pre>
    y= <b>atan</b>( u );
</pre>

<p>
<img src=\"../Images/Math/atan.png\">
</p>

</HTML>
"));
          equation
            y = Modelica.Math.atan(u);
          end Atan;

          block Atan2 "Output atan(u1/u2) of the inputs u1 and u2"
            extends Interfaces.SI2SO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255}),
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{0,-80},{0,68}}, color={192,192,192}),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-34.9},{-46.1,-31.4},{-29.4,-27.1},{-18.3,-21.5},{-10.3,
                    -14.5},{-2.03,-3.17},{7.97,11.6},{15.5,19.4},{24.3,25},{39,30},
                    {62.1,33.5},{80,34.9}}, color={0,0,0}),
              Line(points={{-80,45.1},{-45.9,48.7},{-29.1,52.9},{-18.1,58.6},{-10.2,
                    65.8},{-1.82,77.2},{0,80}}, color={0,0,0}),
              Line(points={{0,-80},{8.93,-67.2},{17.1,-59.3},{27.3,-53.6},{42.1,-49.4},
                    {69.9,-45.8},{80,-45.1}}, color={0,0,0}),
              Text(
                extent={{-90,-46},{-18,-94}},
                lineColor={192,192,192},
                textString="atan2")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,80},{-8,80}}, color={192,192,192}),
              Line(points={{0,-80},{-8,-80}}, color={192,192,192}),
              Line(points={{0,-90},{0,84}}, color={192,192,192}),
              Text(
                extent={{11,98},{42,78}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{0,100},{-6,84},{6,84},{0,100}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{0,-80},{8.93,-67.2},{17.1,-59.3},{27.3,-53.6},{42.1,-49.4},
                    {69.9,-45.8},{80,-45.1}}, color={0,0,0}),
              Line(points={{-80,-34.9},{-46.1,-31.4},{-29.4,-27.1},{-18.3,-21.5},{-10.3,
                    -14.5},{-2.03,-3.17},{7.97,11.6},{15.5,19.4},{24.3,25},{39,30},
                    {62.1,33.5},{80,34.9}}, color={0,0,0}),
              Line(points={{-80,45.1},{-45.9,48.7},{-29.1,52.9},{-18.1,58.6},{-10.2,
                    65.8},{-1.82,77.2},{0,80}}, color={0,0,0}),
              Text(
                extent={{-30,89},{-10,70}},
                textString="pi",
                lineColor={0,0,255}),
              Text(
                extent={{-30,-69},{-10,-88}},
                textString="-pi",
                lineColor={0,0,255}),
              Text(
                extent={{-30,49},{-10,30}},
                textString="pi/2",
                lineColor={0,0,255}),
              Line(points={{0,40},{-8,40}}, color={192,192,192}),
              Line(points={{0,-40},{-8,-40}}, color={192,192,192}),
              Text(
                extent={{-30,-31},{-10,-50}},
                textString="-pi/2",
                lineColor={0,0,255}),
              Text(
                extent={{48,0},{100,-34}},
                lineColor={160,160,164},
                textString="u1 / u2")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>tangent-inverse</i> of the input <b>u1</b> divided by
input <b>u2</b>:
</p>
<pre>
    y = <b>atan2</b>( u1, u2 );
</pre>
<p>
u1 and u2 shall not be zero at the same time instant.
<b>Atan2</b> uses the sign of u1 and u2 in order to construct
the solution in the range -180 deg &le; y &le; 180 deg, whereas
block <b>Atan</b> gives a solution in the range
-90 deg &le; y &le; 90 deg.
</p>

<p>
<img src=\"../Images/Math/atan2.png\">
</p>

</HTML>
"));
          equation
            y = Modelica.Math.atan2(u1, u2);
          end Atan2;

          block Sinh "Output the hyperbolic sine of the input"
            extends Interfaces.SISO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-86,80},{-14,32}},
                lineColor={192,192,192},
                textString="sinh"),
              Line(points={{0,-80},{0,68}}, color={192,192,192}),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Line(points={{-80,-80},{-76,-65.4},{-71.2,-51.4},{-65.5,-38.8},{-59.1,
                    -28.1},{-51.1,-18.7},{-41.4,-11.4},{-27.7,-5.5},{-4.42,-0.653},
                    {24.5,4.57},{39,10.1},{49.4,17.2},{57.5,25.9},{63.9,35.8},{69.5,
                    47.4},{74.4,60.4},{78.4,73.8},{80,80}}, color={0,0,0}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid)}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,80},{-8,80}}, color={192,192,192}),
              Line(points={{0,-80},{-8,-80}}, color={192,192,192}),
              Line(points={{0,-90},{0,84}}, color={192,192,192}),
              Text(
                extent={{9,98},{34,78}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{0,100},{-6,84},{6,84},{0,100}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-76,-65.4},{-71.2,-51.4},{-65.5,-38.8},{-59.1,
                    -28.1},{-51.1,-18.7},{-41.4,-11.4},{-27.7,-5.5},{-4.42,-0.653},
                    {24.5,4.57},{39,10.1},{49.4,17.2},{57.5,25.9},{63.9,35.8},{69.5,
                    47.4},{74.4,60.4},{78.4,73.8},{80,80}}, color={0,0,0}),
              Text(
                extent={{-31,72},{-11,88}},
                textString="27",
                lineColor={0,0,255}),
              Text(
                extent={{-35,-88},{-15,-72}},
                textString="-27",
                lineColor={0,0,255}),
              Text(
                extent={{70,25},{90,5}},
                textString="4",
                lineColor={0,0,255}),
              Text(
                extent={{-98,21},{-78,1}},
                textString="-4",
                lineColor={0,0,255}),
              Text(
                extent={{72,-6},{96,-26}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>hyperbolic sine</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>sinh</b>( u );
</pre>

<p>
<img src=\"../Images/Math/sinh.png\">
</p>

</HTML>
"));

          equation
            y = Modelica.Math.sinh(u);
          end Sinh;

          block Cosh "Output the hyperbolic cosine of the input"
            extends Interfaces.SISO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{0,-80},{0,68}}, color={192,192,192}),
              Text(
                extent={{4,66},{66,20}},
                lineColor={192,192,192},
                textString="cosh"),
              Line(points={{-80,80},{-77.6,61.1},{-74.4,39.3},{-71.2,20.7},{-67.1,
                    1.29},{-63.1,-14.6},{-58.3,-29.8},{-52.7,-43.5},{-46.2,-55.1},{
                    -39,-64.3},{-30.2,-71.7},{-18.9,-77.1},{-4.42,-79.9},{10.9,-79.1},
                    {23.7,-75.2},{34.2,-68.7},{42.2,-60.6},{48.6,-51.2},{54.3,-40},
                    {59.1,-27.5},{63.1,-14.6},{67.1,1.29},{71.2,20.7},{74.4,39.3},{
                    77.6,61.1},{80,80}}, color={0,0,0}),
              Line(points={{-90,-86.083},{68,-86.083}}, color={192,192,192}),
              Polygon(
                points={{90,-86.083},{68,-78.083},{68,-94.083},{90,-86.083}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid)}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,80},{-8,80}}, color={192,192,192}),
              Line(points={{0,-80},{-8,-80}}, color={192,192,192}),
              Line(points={{0,-90},{0,84}}, color={192,192,192}),
              Text(
                extent={{11,98},{38,78}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{0,100},{-6,84},{6,84},{0,100}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,-86.083},{84,-86.083}}, color={192,192,192}),
              Polygon(
                points={{100,-86.083},{84,-80.083},{84,-92.083},{100,-86.083}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,80},{-77.6,61.1},{-74.4,39.3},{-71.2,20.7},{-67.1,
                    1.29},{-63.1,-14.6},{-58.3,-29.8},{-52.7,-43.5},{-46.2,-55.1},{
                    -39,-64.3},{-30.2,-71.7},{-18.9,-77.1},{-4.42,-79.9},{10.9,-79.1},
                    {23.7,-75.2},{34.2,-68.7},{42.2,-60.6},{48.6,-51.2},{54.3,-40},
                    {59.1,-27.5},{63.1,-14.6},{67.1,1.29},{71.2,20.7},{74.4,39.3},{
                    77.6,61.1},{80,80}}, color={0,0,0}),
              Text(
                extent={{-31,72},{-11,88}},
                textString="27",
                lineColor={0,0,255}),
              Text(
                extent={{62,-67},{82,-87}},
                textString="4",
                lineColor={0,0,255}),
              Text(
                extent={{-104,-63},{-84,-83}},
                textString="-4",
                lineColor={0,0,255}),
              Text(
                extent={{78,-54},{100,-74}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>hyperbolic cosine</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>cosh</b>( u );
</pre>

<p>
<img src=\"../Images/Math/cosh.png\">
</p>

</HTML>
"));
          equation
            y = Modelica.Math.cosh(u);
          end Cosh;

          block Tanh "Output the hyperbolic tangent of the input"
            extends Interfaces.SISO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,-90},{0,84}}, color={192,192,192}),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Line(points={{-80,-80},{-47.8,-78.7},{-35.8,-75.7},{-27.7,-70.6},{-22.1,
                    -64.2},{-17.3,-55.9},{-12.5,-44.3},{-7.64,-29.2},{-1.21,-4.82},
                    {6.83,26.3},{11.7,42},{16.5,54.2},{21.3,63.1},{26.9,69.9},{34.2,
                    75},{45.4,78.4},{72,79.9},{80,80}}, color={0,0,0}),
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-88,72},{-16,24}},
                lineColor={192,192,192},
                textString="tanh"),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid)}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,80},{-8,80}}, color={192,192,192}),
              Line(points={{0,-80},{-8,-80}}, color={192,192,192}),
              Line(points={{0,-90},{0,84}}, color={192,192,192}),
              Text(
                extent={{9,98},{42,80}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{0,100},{-6,84},{6,84},{0,100}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-47.8,-78.7},{-35.8,-75.7},{-27.7,-70.6},{-22.1,
                    -64.2},{-17.3,-55.9},{-12.5,-44.3},{-7.64,-29.2},{-1.21,-4.82},
                    {6.83,26.3},{11.7,42},{16.5,54.2},{21.3,63.1},{26.9,69.9},{34.2,
                    75},{45.4,78.4},{72,79.9},{80,80}}, color={0,0,0}),
              Text(
                extent={{70,25},{90,5}},
                textString="4",
                lineColor={0,0,255}),
              Text(
                extent={{-106,21},{-86,1}},
                textString="-4",
                lineColor={0,0,255}),
              Text(
                extent={{-29,72},{-9,88}},
                textString="1",
                lineColor={0,0,255}),
              Text(
                extent={{3,-72},{23,-88}},
                textString="-1",
                lineColor={0,0,255}),
              Text(
                extent={{72,-8},{98,-26}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>hyperbolic tangent</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>tanh</b>( u );
</pre>

<p>
<img src=\"../Images/Math/tanh.png\">
</p>

</HTML>
"));
          equation
            y = Modelica.Math.tanh(u);
          end Tanh;

          block Exp "Output the exponential (base e) of the input"
            extends Interfaces.SISO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,-80},{0,68}}, color={192,192,192}),
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-86,50},{-14,2}},
                lineColor={192,192,192},
                textString="exp"),
              Line(points={{-80,-80},{-31,-77.9},{-6.03,-74},{10.9,-68.4},{23.7,-61},
                    {34.2,-51.6},{43,-40.3},{50.3,-27.8},{56.7,-13.5},{62.3,2.23},{
                    67.1,18.6},{72,38.2},{76,57.6},{80,80}}, color={0,0,0}),
              Line(points={{-90,-80.3976},{68,-80.3976}}, color={192,192,192}),
              Polygon(
                points={{90,-80.3976},{68,-72.3976},{68,-88.3976},{90,-80.3976}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid)}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,80},{-8,80}}, color={192,192,192}),
              Line(points={{0,-80},{-8,-80}}, color={192,192,192}),
              Line(points={{0,-90},{0,84}}, color={192,192,192}),
              Text(
                extent={{9,100},{40,80}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{0,100},{-6,84},{6,84},{0,100}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,-80.3976},{84,-80.3976}}, color={192,192,192}),
              Polygon(
                points={{100,-80.3976},{84,-74.3976},{84,-86.3976},{100,-80.3976}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-31,-77.9},{-6.03,-74},{10.9,-68.4},{23.7,-61},
                    {34.2,-51.6},{43,-40.3},{50.3,-27.8},{56.7,-13.5},{62.3,2.23},{
                    67.1,18.6},{72,38.2},{76,57.6},{80,80}}, color={0,0,0}),
              Text(
                extent={{-31,72},{-11,88}},
                textString="20",
                lineColor={0,0,255}),
              Text(
                extent={{-92,-83},{-72,-103}},
                textString="-3",
                lineColor={0,0,255}),
              Text(
                extent={{70,-83},{90,-103}},
                textString="3",
                lineColor={0,0,255}),
              Text(
                extent={{-18,-53},{2,-73}},
                textString="1",
                lineColor={0,0,255}),
              Text(
                extent={{66,-52},{96,-72}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>exponential</i> (of base e) of the input <b>u</b>:
</p>
<pre>
    y = <b>exp</b>( u );
</pre>

<p>
<img src=\"../Images/Math/exp.png\">
</p>

</HTML>
"));

          equation
            y = Modelica.Math.exp(u);
          end Exp;

          block Log
        "Output the natural (base e) logarithm of the input (input > 0 required)"

            extends Interfaces.SISO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,-80},{-80,68}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-79.2,-50.6},{-78.4,-37},{-77.6,-28},{-76.8,-21.3},
                    {-75.2,-11.4},{-72.8,-1.31},{-69.5,8.08},{-64.7,17.9},{-57.5,28},
                    {-47,38.1},{-31.8,48.1},{-10.1,58},{22.1,68},{68.7,78.1},{80,80}},
                  color={0,0,0}),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-6,-24},{66,-72}},
                lineColor={192,192,192},
                textString="log")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,80},{-88,80}}, color={192,192,192}),
              Line(points={{-80,-80},{-88,-80}}, color={192,192,192}),
              Line(points={{-80,-90},{-80,84}}, color={192,192,192}),
              Text(
                extent={{-67,98},{-40,80}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{-80,100},{-86,84},{-74,84},{-80,100}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-79.2,-50.6},{-78.4,-37},{-77.6,-28},{-76.8,-21.3},
                    {-75.2,-11.4},{-72.8,-1.31},{-69.5,8.08},{-64.7,17.9},{-57.5,28},
                    {-47,38.1},{-31.8,48.1},{-10.1,58},{22.1,68},{68.7,78.1},{80,80}},
                  color={0,0,0}),
              Text(
                extent={{-105,72},{-85,88}},
                textString="3",
                lineColor={0,0,255}),
              Text(
                extent={{-109,-88},{-89,-72}},
                textString="-3",
                lineColor={0,0,255}),
              Text(
                extent={{70,-3},{90,-23}},
                textString="20",
                lineColor={0,0,255}),
              Text(
                extent={{-78,-1},{-58,-21}},
                textString="1",
                lineColor={0,0,255}),
              Text(
                extent={{68,28},{94,8}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>natural (base e) logarithm</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>log</b>( u );
</pre>
<p>
An error occurs if the elements of the input <b>u</b> are
zero or negative.
</p>

<p>
<img src=\"../Images/Math/log.png\">
</p>

</HTML>
"));
          equation
            y = Modelica.Math.log(u);
          end Log;

          block Log10
        "Output the base 10 logarithm of the input (input > 0 required)"

            extends Interfaces.SISO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Line(points={{-79.8,-80},{-79.2,-50.6},{-78.4,-37},{-77.6,-28},{-76.8,
                    -21.3},{-75.2,-11.4},{-72.8,-1.31},{-69.5,8.08},{-64.7,17.9},{-57.5,
                    28},{-47,38.1},{-31.8,48.1},{-10.1,58},{22.1,68},{68.7,78.1},{
                    80,80}}, color={0,0,0}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-80},{-80,68}}, color={192,192,192}),
              Text(
                extent={{-30,-22},{60,-70}},
                lineColor={192,192,192},
                textString="log10")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,80},{-88,80}}, color={192,192,192}),
              Line(points={{-80,-80},{-88,-80}}, color={192,192,192}),
              Line(points={{-80,-90},{-80,84}}, color={192,192,192}),
              Text(
                extent={{-65,96},{-38,78}},
                lineColor={160,160,164},
                textString="y"),
              Polygon(
                points={{-80,100},{-86,84},{-74,84},{-80,100}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-79.8,-80},{-79.2,-50.6},{-78.4,-37},{-77.6,-28},{-76.8,
                    -21.3},{-75.2,-11.4},{-72.8,-1.31},{-69.5,8.08},{-64.7,17.9},{-57.5,
                    28},{-47,38.1},{-31.8,48.1},{-10.1,58},{22.1,68},{68.7,78.1},{
                    80,80}}, color={0,0,0}),
              Text(
                extent={{70,-3},{90,-23}},
                textString="20",
                lineColor={0,0,255}),
              Text(
                extent={{-78,-1},{-58,-21}},
                textString="1",
                lineColor={0,0,255}),
              Text(
                extent={{-109,72},{-89,88}},
                textString=" 1.3",
                lineColor={0,0,255}),
              Text(
                extent={{-109,-88},{-89,-72}},
                textString="-1.3",
                lineColor={0,0,255}),
              Text(
                extent={{62,30},{90,10}},
                lineColor={160,160,164},
                textString="u")}),
              Documentation(info="<HTML>
<p>
This blocks computes the output <b>y</b> as the
<i>base 10 logarithm</i> of the input <b>u</b>:
</p>
<pre>
    y = <b>log10</b>( u );
</pre>
<p>
An error occurs if the elements of the input <b>u</b> are
zero or negative.
</p>

<p>
<img src=\"../Images/Math/log10.png\">
</p>

</HTML>
"));
          equation
            y = Modelica.Math.log10(u);
          end Log10;

      block RealToInteger "Convert Real to Integer signal"
        extends Interfaces.IntegerBlockIcon;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Text(
                extent={{-100,60},{0,-60}},
                textString="R",
                lineColor={0,0,255}),
              Text(
                extent={{20,60},{120,-60}},
                lineColor={255,127,0},
                textString="I"),
              Polygon(
                points={{50,0},{30,20},{30,10},{0,10},{0,-10},{30,-10},{30,-20},{50,
                    0}},
                lineColor={255,127,0},
                fillColor={255,127,0},
                fillPattern=FillPattern.Solid)}),            Documentation(info="<html>
<p>
This block computes the output <b>y</b>
as <i>nearest integer value</i> of the input <b>u</b>:
</p>
<pre>    y = <b>integer</b>( <b>floor</b>( u + 0.5 ) )  for  u &gt; 0;
    y = <b>integer</b>( <b>ceil </b>( u - 0.5 ) )  for  u &lt; 0;
</pre>
</html>
"));
      public
        Interfaces.RealInput u "Connector of Real input signal" 
                               annotation (Placement(transformation(extent={{-140,
                  -20},{-100,20}}, rotation=0)));
        Interfaces.IntegerOutput y "Connector of Integer output signal" 
                                   annotation (Placement(transformation(extent={{
                  100,-10},{120,10}}, rotation=0)));
      equation
         y = if (u > 0) then integer(floor(u + 0.5)) else 
                             integer(ceil( u - 0.5));
      end RealToInteger;

      block IntegerToReal "Convert integer to real signals"
        extends Interfaces.BlockIcon;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Text(
                extent={{-120,60},{-20,-60}},
                lineColor={255,127,0},
                textString="I"),
              Text(
                extent={{0,60},{100,-60}},
                textString="R",
                lineColor={0,0,255}),
              Polygon(
                points={{10,0},{-10,20},{-10,10},{-40,10},{-40,-10},{-10,-10},{-10,
                    -20},{10,0}},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255})}),                   Documentation(info="<html>
<p>
This block computes the output <b>y</b>
as <i>Real equivalent</i> of the Integer input <b>u</b>:
</p>
<pre>    y = u;
</pre>
<p>where <b>u</b> is of Integer and <b>y</b> of Real type.</p>
</html>
"));
        Interfaces.IntegerInput u "Connector of Integer input signal" 
                                                                   annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
        Interfaces.RealOutput y "Connector of Real output signal"  annotation (Placement(
              transformation(extent={{100,-10},{120,10}}, rotation=0)));
      equation
        y = u;
      end IntegerToReal;

      block BooleanToReal "Convert Boolean to Real signal"
        extends Interfaces.partialBooleanSI;
        parameter Real realTrue=1.0 "Output signal for true Boolean input";
        parameter Real realFalse=0.0 "Output signal for false Boolean input";

        Blocks.Interfaces.RealOutput y "Connector of Real output signal" 
          annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));

        annotation (
          Documentation(info="<html>
<p>
This block computes the output <b>y</b>
as <i>Real equivalent</i> of the Boolean input <b>u</b>:
</p>
<pre>    y = <b>if</b> u <b>then</b> realTrue <b>else</b> realFalse;
</pre>
<p>where <b>u</b> is of Boolean and <b>y</b> of Real type,
and <b>realTrue</b> and <b>realFalse</b> are parameters.
</p>
</html>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-86,92},{-6,10}},
                lineColor={255,0,255},
                textString="B"),
              Polygon(
                points={{-12,-46},{-32,-26},{-32,-36},{-64,-36},{-64,-56},{-32,-56},
                    {-32,-66},{-12,-46}},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Text(
                extent={{8,-4},{92,-94}},
                textString="R",
                lineColor={0,0,255})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics));

      equation
        y = if u then realTrue else realFalse;
      end BooleanToReal;

      block BooleanToInteger "Convert Boolean to Integer signal"
        extends Interfaces.partialBooleanSI;
        parameter Integer integerTrue=1 "Output signal for true Boolean input";
        parameter Integer integerFalse=0
          "Output signal for false Boolean input";

        Blocks.Interfaces.IntegerOutput y "Connector of Integer output signal" 
          annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));

        annotation (
          Documentation(info="<html>
<p>
This block computes the output <b>y</b>
as <i>Integer equivalent</i> of the Boolean input <b>u</b>:
</p>
<pre>    y = <b>if</b> u <b>then</b> integerTrue <b>else</b> integerFalse;
</pre>
<p>where <b>u</b> is of Boolean and <b>y</b> of Integer type,
and <b>integerTrue</b> and <b>integerFalse</b> are parameters.
</p>
</html>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-86,92},{-6,10}},
                lineColor={255,0,255},
                textString="B"),
              Polygon(
                points={{-12,-46},{-32,-26},{-32,-36},{-64,-36},{-64,-56},{-32,-56},
                    {-32,-66},{-12,-46}},
                lineColor={255,170,85},
                fillColor={255,170,85},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{8,-4},{92,-94}},
                lineColor={255,170,85},
                textString="I")}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics));

      equation
        y = if u then integerTrue else integerFalse;
      end BooleanToInteger;

      block RealToBoolean "Convert Real to Boolean signal"

        Blocks.Interfaces.RealInput u "Connector of Real input signal"  annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
        extends Interfaces.partialBooleanSO;
        parameter Real threshold=0.5
          "Output signal y is true, if input u >= threshold";

        annotation (
          Documentation(info="<html>
<p>
This block computes the Boolean output <b>y</b>
from the Real input <b> u</b> by the equation:
</p>

<pre>    y = u &ge; threshold;
</pre>

<p>
where <b>threshold</b> is a parameter.
</p>
</html>"),Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-86,92},{-6,10}},
                lineColor={0,0,255},
                textString="R"),
              Polygon(
                points={{-12,-46},{-32,-26},{-32,-36},{-64,-36},{-64,-56},{-32,-56},
                    {-32,-66},{-12,-46}},
                lineColor={255,0,255},
                fillColor={255,0,255},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{8,-4},{92,-94}},
                lineColor={255,0,255},
                textString="B")}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics));

      equation
        y = u >= threshold;
      end RealToBoolean;

      block IntegerToBoolean "Convert Integer to Boolean signal"

        Blocks.Interfaces.IntegerInput u "Connector of Integer input signal" annotation (Placement(
              transformation(extent={{-140,-20},{-100,20}}, rotation=0)));
        extends Interfaces.partialBooleanSO;
        parameter Integer threshold=1
          "Output signal y is true, if input u >= threshold";

        annotation (
          Documentation(info="<html>
<p>
This block computes the Boolean output <b>y</b>
from the Integer input <b> u</b> by the equation:
</p>

<pre>    y = u &ge; threshold;
</pre>

<p>
where <b>threshold</b> is a parameter.
</p>
</html>"),Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-86,92},{-6,10}},
                lineColor={255,128,0},
                textString="I"),
              Polygon(
                points={{-12,-46},{-32,-26},{-32,-36},{-64,-36},{-64,-56},{-32,-56},
                    {-32,-66},{-12,-46}},
                lineColor={255,0,255},
                fillColor={255,0,255},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{8,-4},{92,-94}},
                lineColor={255,0,255},
                textString="B")}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics));

      equation
        y = u >= threshold;
      end IntegerToBoolean;

      block Max "Pass through the largest signal"
        extends Interfaces.SI2SO;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,36},{90,-36}},
                lineColor={160,160,164},
                textString="max()")}),
                                Documentation(info="<html>
<p>
This block computes the output <b>y</b> as <i>maximum</i>
of the two Real inputs <b>u1</b> and <b>u2</b>:
</p>
<pre>    y = <b>max</b> ( u1 , u2 );
</pre>
</html>
"));
      equation
        y = max(u1, u2);
      end Max;

      block Min "Pass through the smallest signal"
        extends Interfaces.SI2SO;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,36},{90,-36}},
                lineColor={160,160,164},
                textString="min()")}),
                                Documentation(info="<html>
<p>
This block computes the output <b>y</b> as <i>minimum</i> of
the two Real inputs <b>u1</b> and <b>u2</b>:
</p>
<pre>    y = <b>min</b> ( u1 , u2 );
</pre>
</html>
"));
      equation
         y = min(u1, u2);
      end Min;

      block Edge "Indicates rising edge of boolean signal"
        extends Interfaces.BooleanSISO;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,36},{90,-36}},
                lineColor={160,160,164},
                textString="edge()")}),
                                 Documentation(info="<html>
<p>
This block sets the Boolean output <b>y</b> to true,
when the Boolean input <b>u</b> shows a <i>rising edge</i>:
</p>
<pre>    y = <b>edge</b>( u );
</pre>
</html>
"));
      equation
        y = edge(u);
      end Edge;

      block BooleanChange "Indicates boolean signal changing"
        extends Interfaces.BooleanSISO;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,36},{90,-36}},
                lineColor={160,160,164},
                textString="change()")}),
                                   Documentation(info="<html>
<p>
This block sets the Boolean output <b>y</b> to true, when the
Boolean input <b>u</b> shows a <i>rising or falling edge</i>,
i.e., when the signal changes:
</p>
<pre>    y = <b>change</b>( u );
</pre>
</html>
"));
      equation
        y = change(u);
      end BooleanChange;

      block IntegerChange "Indicates integer signal changing"
        extends Interfaces.IntegerSIBooleanSO;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Text(
                extent={{-90,36},{90,-36}},
                lineColor={160,160,164},
                textString="change()")}),
                                   Documentation(info="<html>
<p>
This block sets the Boolean output <b>y</b> to true, when the
Integer input <b>u</b> changes:
</p>
<pre>    y = <b>change</b>( u );
</pre>
</html>
"));
      equation
        y = change(u);
      end IntegerChange;

    end Math;

    package Nonlinear
      "Library of discontinuous or non-differentiable algebraic control blocks"
      import Modelica.Blocks.Interfaces;
          extends Modelica.Icons.Library;

          annotation (
            Documentation(info="
<HTML>
<p>
This package contains <b>discontinuous</b> and
<b>non-differentiable, algebraic</b> input/output blocks.
</p>
</HTML>
",     revisions="<html>
<ul>
<li><i>October 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       New block VariableLimiter added.
<li><i>August 22, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized, based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist.
</li>
</ul>
</html>
"));

          block Limiter "Limit the range of a signal"
            parameter Real uMax(start=1) "Upper limits of input signals";
            parameter Real uMin= -uMax "Lower limits of input signals";
            parameter Boolean limitsAtInit = true
          "= false, if limits are ignored during initializiation (i.e., y=u)";
            extends Interfaces.SISO;

            annotation (
              Documentation(info="
<HTML>
<p>
The Limiter block passes its input signal as output signal
as long as the input is within the specified upper and lower
limits. If this is not the case, the corresponding limits are passed
as output.
</p>
</HTML>
"),           Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,-90},{0,68}}, color={192,192,192}),
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,-8},{68,8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-70},{-50,-70},{50,70},{80,70}}, color={0,0,0}),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="uMax=%uMax"),
              Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255})}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{0,-60},{0,50}}, color={192,192,192}),
              Polygon(
                points={{0,60},{-5,50},{5,50},{0,60}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-60,0},{50,0}}, color={192,192,192}),
              Polygon(
                points={{60,0},{50,-5},{50,5},{60,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-50,-40},{-30,-40},{30,40},{50,40}}, color={0,0,0}),
              Text(
                extent={{46,-6},{68,-18}},
                lineColor={128,128,128},
                textString="u"),
              Text(
                extent={{-30,70},{-5,50}},
                lineColor={128,128,128},
                textString="y"),
              Text(
                extent={{-58,-54},{-28,-42}},
                lineColor={128,128,128},
                textString="uMin"),
              Text(
                extent={{26,40},{66,56}},
                lineColor={128,128,128},
                textString="uMax")}));

          equation
            assert(uMax >= uMin, "Limiter: Limits must be consistent. However, uMax (=" + String(uMax) +
                                 ") < uMin (=" + String(uMin) + ")");
            if initial() and not limitsAtInit then
               y = u;
               assert(u >= uMin - 0.01*abs(uMin) and 
                      u <= uMax + 0.01*abs(uMax),
                     "Limiter: During initialization the limits have been ignored.\n"+
                     "However, the result is that the input u is not within the required limits:\n"+
                     "  u = " + String(u) + ", uMin = " + String(uMin) + ", uMax = " + String(uMax));
            else
               y = smooth(0,if u > uMax then uMax else if u < uMin then uMin else u);
            end if;
          end Limiter;

      block VariableLimiter "Limit the range of a signal with variable limits"
        extends Interfaces.SISO;
        parameter Boolean limitsAtInit = true
          "= false, if limits are ignored during initializiation (i.e., y=u)";
        Interfaces.RealInput limit1
          "Connector of Real input signal used as maximum of input u" 
                                    annotation (Placement(transformation(extent={{
                  -140,60},{-100,100}}, rotation=0)));
        Interfaces.RealInput limit2
          "Connector of Real input signal used as minimum of input u" 
                                    annotation (Placement(transformation(extent={{
                  -140,-100},{-100,-60}}, rotation=0)));
      protected
        Real uMax;
        Real uMin;

        annotation (
          Documentation(info="<html>
<p>
The Limiter block passes its input signal as output signal
as long as the input is within the upper and lower
limits specified by the two additional inputs limit1 and
limit2. If this is not the case, the corresponding limit
is passed as output.
</p>
</HTML>
"),       Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Line(points={{0,-90},{0,68}}, color={192,192,192}),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,-8},{68,8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-70},{-50,-70},{50,70},{80,70}}, color={0,0,0}),
              Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255}),
              Line(points={{-100,80},{66,80},{66,70}}, color={0,0,127}),
              Line(points={{-100,-80},{-64,-80},{-64,-70}}, color={0,0,127}),
              Polygon(points={{-64,-70},{-66,-74},{-62,-74},{-64,-70}}, lineColor={
                    0,0,127}),
              Polygon(points={{66,70},{64,74},{68,74},{66,70}}, lineColor={0,0,127}),
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Line(points={{0,-60},{0,50}}, color={192,192,192}),
              Polygon(
                points={{0,60},{-5,50},{5,50},{0,60}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-60,0},{50,0}}, color={192,192,192}),
              Polygon(
                points={{60,0},{50,-5},{50,5},{60,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-50,-40},{-30,-40},{30,40},{50,40}}, color={0,0,0}),
              Text(
                extent={{46,-6},{68,-18}},
                lineColor={128,128,128},
                textString="inPort"),
              Text(
                extent={{-30,70},{-5,50}},
                lineColor={128,128,128},
                textString="outPort"),
              Text(
                extent={{-66,-40},{-26,-20}},
                lineColor={128,128,128},
                textString="uMin"),
              Text(
                extent={{30,20},{70,40}},
                lineColor={128,128,128},
                textString="uMax"),
              Line(points={{-100,80},{40,80},{40,40}}, color={0,0,255}),
              Line(points={{-100,-80},{-40,-80},{-40,-40}}, color={0,0,255}),
              Polygon(points={{40,40},{35,50},{45,50},{40,40}}, lineColor={0,0,255}),
              Polygon(points={{-40,-40},{-45,-50},{-35,-50},{-40,-40}}, lineColor={
                    0,0,255})}));

      equation
        uMax = max(limit1, limit2);
        uMin = min(limit1, limit2);

        if initial() and not limitsAtInit then
           y = u;
           assert(u >= uMin - 0.01*abs(uMin) and 
                  u <= uMax + 0.01*abs(uMax),
                 "VariableLimiter: During initialization the limits have been ignored.\n"+
                 "However, the result is that the input u is not within the required limits:\n"+
                 "  u = " + String(u) + ", uMin = " + String(uMin) + ", uMax = " + String(uMax));
        else
           y = smooth(0,if u > uMax then uMax else if u < uMin then uMin else u);
        end if;
      end VariableLimiter;

          block DeadZone "Provide a region of zero output"
            parameter Real uMax(start=1) "Upper limits of dead zones";
            parameter Real uMin=-uMax "Lower limits of dead zones";
            parameter Boolean deadZoneAtInit = true
          "= false, if dead zone is ignored during initializiation (i.e., y=u)";
            extends Interfaces.SISO;

            annotation (
              Documentation(info="
<HTML>
<p>
The DeadZone block defines a region of zero output.
</p>
<p>
If the input is within uMin ... uMax, the output
is zero. Outside of this zone, the output is a linear
function of the input with a slope of 1.
</p>
</HTML>
"),           Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{0,-90},{0,68}}, color={192,192,192}),
              Polygon(
                points={{0,90},{-8,68},{8,68},{0,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,-8},{68,8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-60},{-20,0},{20,0},{80,60}}, color={0,0,0}),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={160,160,164},
                textString="uMax=%uMax"),
              Text(
                extent={{-150,150},{150,110}},
                textString="%name",
                lineColor={0,0,255})}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{0,-60},{0,50}}, color={192,192,192}),
              Polygon(
                points={{0,60},{-5,50},{5,50},{0,60}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-76,0},{74,0}}, color={192,192,192}),
              Polygon(
                points={{84,0},{74,-5},{74,5},{84,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-81,-40},{-38,0},{40,0},{80,40}}, color={0,0,0}),
              Text(
                extent={{62,-7},{88,-25}},
                lineColor={128,128,128},
                textString="u"),
              Text(
                extent={{-36,72},{-5,50}},
                lineColor={128,128,128},
                textString="y"),
              Text(
                extent={{-51,1},{-28,19}},
                lineColor={128,128,128},
                textString="uMin"),
              Text(
                extent={{27,21},{52,5}},
                lineColor={128,128,128},
                textString="uMax")}));

          equation
            assert(uMax >= uMin, "DeadZone: Limits must be consistent. However, uMax (=" + String(uMax) +
                                 ") < uMin (=" + String(uMin) + ")");

            if initial() and not deadZoneAtInit then
               y = u;
            else
               y = smooth(0,if u > uMax then u - uMax else if u < uMin then u - uMin else 0);
            end if;
          end DeadZone;

      block FixedDelay "Delay block with fixed DelayTime"
        extends Modelica.Blocks.Interfaces.SISO;
        parameter SI.Time delayTime(start=1)
          "Delay time of output with respect to input signal";

        annotation (
          Documentation(info="<html>
<p>
The Input signal is delayed by a given time instant, or more precisely:
</p>
<pre>
   y = u(time - delayTime) for time &gt; time.start + delayTime
     = u(time.start)       for time &le; time.start + delayTime
</pre>
</html>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{8,-102},{8,-142}},
                lineColor={0,0,0},
                textString="delayTime=%delayTime"),
              Line(points={{-92,0},{-80.7,34.2},{-73.5,53.1},{-67.1,66.4},{-61.4,
                    74.6},{-55.8,79.1},{-50.2,79.8},{-44.6,76.6},{-38.9,69.7},{-33.3,
                    59.4},{-26.9,44.1},{-18.83,21.2},{-1.9,-30.8},{5.3,-50.2},{11.7,
                    -64.2},{17.3,-73.1},{23,-78.4},{28.6,-80},{34.2,-77.6},{39.9,-71.5},
                    {45.5,-61.9},{51.9,-47.2},{60,-24.8},{68,0}}, color={0,0,127}),
              Line(points={{-62,0},{-50.7,34.2},{-43.5,53.1},{-37.1,66.4},{-31.4,
                    74.6},{-25.8,79.1},{-20.2,79.8},{-14.6,76.6},{-8.9,69.7},{-3.3,
                    59.4},{3.1,44.1},{11.17,21.2},{28.1,-30.8},{35.3,-50.2},{41.7,-64.2},
                    {47.3,-73.1},{53,-78.4},{58.6,-80},{64.2,-77.6},{69.9,-71.5},{
                    75.5,-61.9},{81.9,-47.2},{90,-24.8},{98,0}}, color={160,160,164})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,80},{-88,80}}, color={192,192,192}),
              Line(points={{-80,-80},{-88,-80}}, color={192,192,192}),
              Line(points={{-80,-88},{-80,86}}, color={192,192,192}),
              Text(
                extent={{-75,98},{-46,78}},
                lineColor={0,0,255},
                textString="outPort"),
              Polygon(
                points={{-80,96},{-86,80},{-74,80},{-80,96}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,
                    74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,
                    59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,
                    -64.2},{29.3,-73.1},{35,-78.4},{40.6,-80},{46.2,-77.6},{51.9,-71.5},
                    {57.5,-61.9},{63.9,-47.2},{72,-24.8},{80,0}}, color={0,0,255}),
              Text(
                extent={{-24,98},{-2,78}},
                lineColor={0,0,0},
                textString="inPort"),
              Line(points={{-64,0},{-52.7,34.2},{-45.5,53.1},{-39.1,66.4},{-33.4,
                    74.6},{-27.8,79.1},{-22.2,79.8},{-16.6,76.6},{-10.9,69.7},{-5.3,
                    59.4},{1.1,44.1},{9.17,21.2},{26.1,-30.8},{33.3,-50.2},{39.7,-64.2},
                    {45.3,-73.1},{51,-78.4},{56.6,-80},{62.2,-77.6},{67.9,-71.5},{
                    73.5,-61.9},{79.9,-47.2},{88,-24.8},{96,0}}, color={0,0,0}),
              Text(
                extent={{67,22},{96,6}},
                lineColor={160,160,164},
                textString="time"),
              Line(points={{-64,-30},{-64,0}}, color={192,192,192}),
              Text(
                extent={{-58,-42},{-58,-32}},
                textString="delayTime",
                lineColor={0,0,255}),
              Line(points={{-94,-26},{-80,-26}}, color={192,192,192}),
              Line(points={{-64,-26},{-50,-26}}, color={192,192,192}),
              Polygon(
                points={{-80,-26},{-88,-24},{-88,-28},{-80,-26}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-56,-24},{-64,-26},{-56,-28},{-56,-24}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid)}));

      equation
        y = delay(u, delayTime);
      end FixedDelay;

      block PadeDelay "Pade approximation of delay block with fixed DelayTime "
        extends Modelica.Blocks.Interfaces.SISO;
        parameter SI.Time delayTime(start=1)
          "Delay time of output with respect to input signal";
        parameter Integer n(min=1) = 1 "Order of pade approximation";
        parameter Integer m(
          min=1,
          max=n) = n "Order of numerator";

      protected
        Real x1dot "Derivative of first state of TransferFcn";
        Real xn "Highest order state of TransferFcn";
        Real a[n + 1];
        Real b[m + 1];

      public
        final output Real x[n]
          "State of transfer function from controller canonical form";
        annotation (
          Documentation(info="<html>
<p>
The Input signal is delayed by a given time instant, or more precisely:
</p>
<pre>
   y = u(time - delayTime) for time &gt; time.start + delayTime
     = u(time.start)       for time &le; time.start + delayTime
</pre>
<p>
The delay is approximated by a Pade approximation, i.e., by
a transfer function
</p>
<pre>
           b[1]*s^m + b[2]*s^[m-1] + ... + b[m+1]
   y(s) = --------------------------------------------- * u(s)
           a[1]*s^n + a[2]*s^[n-1] + ... + a[n+1]
</pre>
<p>
where the coefficients b[:] and a[:] are calculated such that the
coefficients of the Taylor expansion of the delay exp(-T*s) around s=0
are identical upto order n+m.
</p>
<p>
The main advantage of this approach is that the delay is
approximated by a linear differential equation system, which
is continuous and continuously differentiable. For example, it
is uncritical to linearize a system containing a Pade-approximated
delay.
</p>
<p>
The standard text book version uses order \"m=n\", which is
also the default setting of this block. The setting
\"m=n-1\" may yield a better approximation in certain cases.
<p>
<p>
Literature:<br>
Otto Foellinger: Regelungstechnik, 8. Auflage,
chapter 11.9, page 412-414, Huethig Verlag Heidelberg, 1994
</p>
</html>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{8,-102},{8,-142}},
                lineColor={0,0,0},
                textString="delayTime=%delayTime"),
              Line(points={{-94,0},{-82.7,34.2},{-75.5,53.1},{-69.1,66.4},{-63.4,
                    74.6},{-57.8,79.1},{-52.2,79.8},{-46.6,76.6},{-40.9,69.7},{-35.3,
                    59.4},{-28.9,44.1},{-20.83,21.2},{-3.9,-30.8},{3.3,-50.2},{9.7,
                    -64.2},{15.3,-73.1},{21,-78.4},{26.6,-80},{32.2,-77.6},{37.9,-71.5},
                    {43.5,-61.9},{49.9,-47.2},{58,-24.8},{66,0}}, color={0,0,127}),
              Line(points={{-72,0},{-60.7,34.2},{-53.5,53.1},{-47.1,66.4},{-41.4,
                    74.6},{-35.8,79.1},{-30.2,79.8},{-24.6,76.6},{-18.9,69.7},{-13.3,
                    59.4},{-6.9,44.1},{1.17,21.2},{18.1,-30.8},{25.3,-50.2},{31.7,-64.2},
                    {37.3,-73.1},{43,-78.4},{48.6,-80},{54.2,-77.6},{59.9,-71.5},{
                    65.5,-61.9},{71.9,-47.2},{80,-24.8},{88,0}}, color={160,160,164}),
              Text(
                extent={{-10,100},{100,38}},
                lineColor={160,160,164},
                textString="m=%m"),
              Text(
                extent={{-98,-34},{6,-96}},
                lineColor={160,160,164},
                textString="n=%n")}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,80},{-88,80}}, color={192,192,192}),
              Line(points={{-80,-80},{-88,-80}}, color={192,192,192}),
              Line(points={{-80,-88},{-80,86}}, color={192,192,192}),
              Text(
                extent={{-75,98},{-46,78}},
                lineColor={0,0,255},
                textString="outPort"),
              Polygon(
                points={{-80,96},{-86,80},{-74,80},{-80,96}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,
                    74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,
                    59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,
                    -64.2},{29.3,-73.1},{35,-78.4},{40.6,-80},{46.2,-77.6},{51.9,-71.5},
                    {57.5,-61.9},{63.9,-47.2},{72,-24.8},{80,0}}, color={0,0,255}),
              Text(
                extent={{-24,98},{-2,78}},
                lineColor={0,0,0},
                textString="inPort"),
              Line(points={{-64,0},{-52.7,34.2},{-45.5,53.1},{-39.1,66.4},{-33.4,
                    74.6},{-27.8,79.1},{-22.2,79.8},{-16.6,76.6},{-10.9,69.7},{-5.3,
                    59.4},{1.1,44.1},{9.17,21.2},{26.1,-30.8},{33.3,-50.2},{39.7,-64.2},
                    {45.3,-73.1},{51,-78.4},{56.6,-80},{62.2,-77.6},{67.9,-71.5},{
                    73.5,-61.9},{79.9,-47.2},{88,-24.8},{96,0}}, color={0,0,0}),
              Text(
                extent={{67,22},{96,6}},
                lineColor={160,160,164},
                textString="time"),
              Line(points={{-64,-30},{-64,0}}, color={192,192,192}),
              Text(
                extent={{-58,-42},{-58,-32}},
                textString="delayTime",
                lineColor={0,0,255}),
              Line(points={{-94,-26},{-80,-26}}, color={192,192,192}),
              Line(points={{-64,-26},{-50,-26}}, color={192,192,192}),
              Polygon(
                points={{-80,-26},{-88,-24},{-88,-28},{-80,-26}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-56,-24},{-64,-26},{-56,-28},{-56,-24}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid)}));

      protected
        function padeCoefficients
          input Real T "delay time";
          input Integer n "order of denominator";
          input Integer m "order of numerator";
          output Real b[m + 1] "numerator coefficients of transfer function";
          output Real a[n + 1] "denominator coefficients of transfer function";
        protected
          Real nm;
        algorithm
          a[1] := 1;
          b[1] := 1;
          nm := n + m;

          for i in 1:n loop
            a[i + 1] := a[i]*(T*((n - i + 1)/(nm - i + 1))/i);
            if i <= m then
              b[i + 1] := -b[i]*(T*((m - i + 1)/(nm - i + 1))/i);
            end if;
          end for;

          b := b[m + 1:-1:1];
          a := a[n + 1:-1:1];
        end padeCoefficients;
      equation

        (b,a) = padeCoefficients(delayTime, n, m);

        [der(x); xn] = [x1dot; x];
        [u] = transpose([a])*[x1dot; x];
        [y] = transpose([zeros(n - m, 1); b])*[x1dot; x];

      initial equation
        x[n] = u;
      end PadeDelay;

      block VariableDelay "Delay block with variable DelayTime"
        extends Modelica.Blocks.Interfaces.SISO;
        parameter Real delayMax(min=0, start=1) "maximum delay time";
        annotation (
          Documentation(info="<html>
<p>
The Input signal is delayed by a given time instant, or more precisely:
</p>
<pre>
   y = u(time - delayTime) for time &gt; time.start + delayTime
     = u(time.start)       for time &le; time.start + delayTime
</pre>
<p>
where delayTime is an additional input signal which must follow
the following relationship:
</p>
<pre>  0 &le; delayTime &le; delayMax
</pre>
</html>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Text(
                extent={{-100,-108},{100,-148}},
                lineColor={0,0,0},
                textString="delayMax=%delayMax"),
              Line(points={{-92,0},{-80.7,34.2},{-73.5,53.1},{-67.1,66.4},{-61.4,
                    74.6},{-55.8,79.1},{-50.2,79.8},{-44.6,76.6},{-38.9,69.7},{-33.3,
                    59.4},{-26.9,44.1},{-18.83,21.2},{-1.9,-30.8},{5.3,-50.2},{11.7,
                    -64.2},{17.3,-73.1},{23,-78.4},{28.6,-80},{34.2,-77.6},{39.9,-71.5},
                    {45.5,-61.9},{51.9,-47.2},{60,-24.8},{68,0}}, color={0,0,127}),
              Line(points={{-64,0},{-52.7,34.2},{-45.5,53.1},{-39.1,66.4},{-33.4,
                    74.6},{-27.8,79.1},{-22.2,79.8},{-16.6,76.6},{-10.9,69.7},{-5.3,
                    59.4},{1.1,44.1},{9.17,21.2},{26.1,-30.8},{33.3,-50.2},{39.7,-64.2},
                    {45.3,-73.1},{51,-78.4},{56.6,-80},{62.2,-77.6},{67.9,-71.5},{
                    73.5,-61.9},{79.9,-47.2},{88,-24.8},{96,0}}, color={0,0,0}),
              Polygon(
                points={{6,4},{-14,-2},{-6,-12},{6,4}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid),
              Line(points={{-100,-60},{-76,-60},{-8,-6}}, color={0,0,0})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(
                extent={{-100,-100},{100,100}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-80,96},{-86,80},{-74,80},{-80,96}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-69,98},{-40,78}},
                lineColor={0,0,255},
                textString="outPort"),
              Line(points={{-64,0},{-52.7,34.2},{-45.5,53.1},{-39.1,66.4},{-33.4,
                    74.6},{-27.8,79.1},{-22.2,79.8},{-16.6,76.6},{-10.9,69.7},{-5.3,
                    59.4},{1.1,44.1},{9.17,21.2},{26.1,-30.8},{33.3,-50.2},{39.7,-64.2},
                    {45.3,-73.1},{51,-78.4},{56.6,-80},{62.2,-77.6},{67.9,-71.5},{
                    73.5,-61.9},{79.9,-47.2},{88,-24.8},{96,0}}, color={0,0,0}),
              Line(points={{-80,0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,
                    74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,
                    59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,
                    -64.2},{29.3,-73.1},{35,-78.4},{40.6,-80},{46.2,-77.6},{51.9,-71.5},
                    {57.5,-61.9},{63.9,-47.2},{72,-24.8},{80,0}}, color={0,0,255}),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{67,22},{96,6}},
                lineColor={160,160,164},
                textString="time"),
              Text(
                extent={{-58,-42},{-58,-32}},
                textString="delayTime",
                lineColor={0,0,255}),
              Line(points={{-80,-88},{-80,86}}, color={192,192,192}),
              Text(
                extent={{-24,98},{-2,78}},
                lineColor={0,0,0},
                textString="inPort"),
              Text(
                extent={{-24,98},{-2,78}},
                lineColor={0,0,0},
                textString="inPort"),
              Polygon(
                points={{-80,-26},{-88,-24},{-88,-28},{-80,-26}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-56,-24},{-64,-26},{-56,-28},{-56,-24}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-64,-26},{-50,-26}}, color={192,192,192}),
              Line(points={{-94,-26},{-80,-26}}, color={192,192,192}),
              Text(
                extent={{-58,-42},{-58,-32}},
                textString="delayTime",
                lineColor={0,0,255}),
              Line(
                points={{-100,-60},{-70,-60},{-64,-44}},
                arrow={Arrow.None,Arrow.Filled},
                color={0,0,255}),
              Line(points={{-80,-88},{-80,86}}, color={192,192,192}),
              Line(points={{-100,0},{84,0}}, color={192,192,192}),
              Line(points={{-64,0},{-52.7,34.2},{-45.5,53.1},{-39.1,66.4},{-33.4,
                    74.6},{-27.8,79.1},{-22.2,79.8},{-16.6,76.6},{-10.9,69.7},{-5.3,
                    59.4},{1.1,44.1},{9.17,21.2},{26.1,-30.8},{33.3,-50.2},{39.7,-64.2},
                    {45.3,-73.1},{51,-78.4},{56.6,-80},{62.2,-77.6},{67.9,-71.5},{
                    73.5,-61.9},{79.9,-47.2},{88,-24.8},{96,0}}, color={0,0,0}),
              Polygon(
                points={{-80,96},{-86,80},{-74,80},{-80,96}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,
                    74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,
                    59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,
                    -64.2},{29.3,-73.1},{35,-78.4},{40.6,-80},{46.2,-77.6},{51.9,-71.5},
                    {57.5,-61.9},{63.9,-47.2},{72,-24.8},{80,0}}, color={0,0,255}),
              Text(
                extent={{-69,98},{-40,78}},
                lineColor={0,0,255},
                textString="outPort"),
              Text(
                extent={{-24,98},{-2,78}},
                lineColor={0,0,0},
                textString="inPort"),
              Text(
                extent={{67,22},{96,6}},
                lineColor={160,160,164},
                textString="time"),
              Polygon(
                points={{100,0},{84,6},{84,-6},{100,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-64,-30},{-64,0}}, color={192,192,192})}));

        Modelica.Blocks.Interfaces.RealInput delayTime         annotation (Placement(
              transformation(extent={{-140,-80},{-100,-40}}, rotation=0)));
      equation
        y = delay(u, delayTime, delayMax);
      end VariableDelay;

    end Nonlinear;

    package Routing "Library of blocks to combine and extract signals"
      extends Icons.Library;

    block ExtractSignal "Extract signals from an input signal vector"
      extends Modelica.Blocks.Interfaces.MIMO;
      parameter Integer extract[nout]=1:nout "Extracting vector";
      annotation (
        Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Rectangle(
                extent={{-90,51},{-50,-49}},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Rectangle(
                extent={{50,50},{90,-50}},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Polygon(
                points={{-94.4104,1.90792},{-94.4104,-2.09208},{-90.4104,-0.0920762},
                    {-94.4104,1.90792}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Line(points={{-72,2},{-60.1395,12.907},{-49.1395,12.907}}, color={0,0,
                    127}),
              Line(points={{-73,4},{-59,40},{-49,40}}, color={0,0,127}),
              Line(points={{-113,0},{-76.0373,-0.0180176}}, color={0,0,127}),
              Ellipse(
                extent={{-81.0437,4.59255},{-71.0437,-4.90745}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Line(points={{-73,-5},{-60,-40},{-49,-40}}, color={0,0,127}),
              Line(points={{-72,-2},{-60.0698,-12.907},{-49.0698,-12.907}}, color={
                    0,0,127}),
              Polygon(
                points={{-48.8808,-11},{-48.8808,-15},{-44.8808,-13},{-48.8808,-11}},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Line(points={{-46,13},{-35,13},{35,-30},{45,-30}}, color={0,0,127}),
              Line(points={{-45,40},{-35,40},{35,0},{44,0}}, color={0,0,127}),
              Line(points={{-45,-40},{-34,-40},{35,30},{44,30}}, color={0,0,127}),
              Polygon(
                points={{-49,42},{-49,38},{-45,40},{-49,42}},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Polygon(
                points={{-48.8728,-38.0295},{-48.8728,-42.0295},{-44.8728,-40.0295},
                    {-48.8728,-38.0295}},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Polygon(
                points={{-48.9983,14.8801},{-48.9983,10.8801},{-44.9983,12.8801},{-48.9983,
                    14.8801}},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Ellipse(
                extent={{69.3052,4.12743},{79.3052,-5.37257}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Line(points={{80,0},{100,0}}, color={0,0,127}),
              Polygon(
                points={{43.1618,32.3085},{43.1618,28.3085},{47.1618,30.3085},{
                    43.1618,32.3085}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Polygon(
                points={{43.2575,1.80443},{43.2575,-2.19557},{47.2575,-0.195573},{
                    43.2575,1.80443}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Polygon(
                points={{43.8805,-28.1745},{43.8805,-32.1745},{47.8805,-30.1745},{
                    43.8805,-28.1745}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Line(points={{48,0},{70,0}}, color={0,0,127}),
              Line(points={{47,30},{60,30},{73,3}}, color={0,0,127}),
              Line(points={{49,-30},{60,-30},{74,-4}}, color={0,0,127}),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="extract=%extract")}),
        Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Rectangle(
                extent={{-90,50},{-50,-50}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{50,50},{90,-50}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-94.4104,1.90792},{-94.4104,-2.09208},{-90.4104,-0.0920762},
                    {-94.4104,1.90792}},
                lineColor={0,0,255},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid),
              Line(points={{-72,2},{-60.1395,12.907},{-49.1395,12.907}}, color={0,0,
                    255}),
              Line(points={{-73,4},{-59,40},{-49,40}}, color={0,0,255}),
              Line(points={{-112,0},{-75.0373,-0.0180176}}, color={0,0,255}),
              Ellipse(
                extent={{-80.0437,4.59255},{-70.0437,-4.90745}},
                lineColor={0,0,255},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-73,-5},{-60,-40},{-49,-40}}, color={0,0,255}),
              Line(points={{-72,-2},{-60.0698,-12.907},{-49.0698,-12.907}}, color={
                    0,0,255}),
              Polygon(
                points={{-48.8808,-11},{-48.8808,-15},{-44.8808,-13},{-48.8808,-11}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Line(points={{-46,13},{-35,13},{35,-30},{45,-30}}, color={0,0,255}),
              Line(points={{-45,40},{-35,40},{35,0},{44,0}}, color={0,0,255}),
              Line(points={{-45,-40},{-34,-40},{35,30},{44,30}}, color={0,0,255}),
              Polygon(
                points={{-49,42},{-49,38},{-45,40},{-49,42}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-48.8728,-38.0295},{-48.8728,-42.0295},{-44.8728,-40.0295},
                    {-48.8728,-38.0295}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-48.9983,14.8801},{-48.9983,10.8801},{-44.9983,12.8801},{-48.9983,
                    14.8801}},
                lineColor={0,0,255},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Ellipse(
                extent={{70.3052,4.12743},{80.3052,-5.37257}},
                lineColor={0,0,255},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid),
              Line(points={{80,0},{105,0}}, color={0,0,255}),
              Polygon(
                points={{44.1618,32.3085},{44.1618,28.3085},{48.1618,30.3085},{
                    44.1618,32.3085}},
                lineColor={0,0,255},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{44.2575,1.80443},{44.2575,-2.19557},{48.2575,-0.195573},{
                    44.2575,1.80443}},
                lineColor={0,0,255},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{44.8805,-28.1745},{44.8805,-32.1745},{48.8805,-30.1745},{
                    44.8805,-28.1745}},
                lineColor={0,0,255},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid),
              Line(points={{48,0},{70,0}}, color={0,0,255}),
              Line(points={{47,30},{60,30},{73,3}}, color={0,0,255}),
              Line(points={{49,-30},{60,-30},{74,-4}}, color={0,0,255}),
              Rectangle(extent={{-100,80},{100,-81}}, lineColor={0,0,255})}),
        Documentation(info="<HTML>
<p>Extract signals from the input connector and transfer them
to the output connector.</p>
<p>The extracting scheme is given by the integer vector 'extract'.
This vector specifies, which input signals are taken and in which
order they are transfered to the output vector. Note, that the
dimension of 'extract' has to match the number of outputs.
Additionally, the dimensions of the input connector signals and
the output connector signals have to be explicitly defined via the
parameters 'nin' and 'nout'.</p>
<p>Example:</p>
<pre>     nin = 7 \"Number of inputs\";
     nout = 4 \"Number of outputs\";
     extract[nout] = {6,3,3,2} \"Extracting vector\";
</pre>
<p>extracts four output signals (nout=4) from the seven elements of the
input vector (nin=7):</p>
<pre>   output no. 1 is set equal to input no. 6
   output no. 2 is set equal to input no. 3
   output no. 3 is set equal to input no. 3
   output no. 4 is set equal to input no. 2
</pre>
</HTML>
"));

    equation
      for i in 1:nout loop
        y[i] = u[extract[i]];

      end for;
    end ExtractSignal;

    block Extractor
        "Extract scalar signal out of signal vector dependent on IntegerRealInput index"

      extends Modelica.Blocks.Interfaces.MISO;

      parameter Boolean allowOutOfRange=false "Index may be out of range";
      parameter Real outOfRangeValue=1e10
          "Output signal if index is out of range";

      annotation (Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Rectangle(
                extent={{-80,50},{-40,-50}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-84.4104,1.9079},{-84.4104,-2.09208},{-80.4104,-0.09208},{
                    -84.4104,1.9079}},
                lineColor={0,0,127},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid),
              Line(points={{-62,2},{-50.1395,12.907},{-39.1395,12.907}}, color={0,0,
                    127}),
              Line(points={{-63,4},{-49,40},{-39,40}}, color={0,0,127}),
              Line(points={{-102,0},{-65.0373,-0.01802}}, color={0,0,127}),
              Ellipse(
                extent={{-70.0437,4.5925},{-60.0437,-4.90745}},
                lineColor={0,0,127},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid),
              Line(points={{-63,-5},{-50,-40},{-39,-40}}, color={0,0,127}),
              Line(points={{-62,-2},{-50.0698,-12.907},{-39.0698,-12.907}}, color={
                    0,0,127}),
              Polygon(
                points={{-38.8808,-11},{-38.8808,-15},{-34.8808,-13},{-38.8808,-11}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-39,42},{-39,38},{-35,40},{-39,42}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-38.8728,-38.0295},{-38.8728,-42.0295},{-34.8728,-40.0295},
                    {-38.8728,-38.0295}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-38.9983,14.8801},{-38.9983,10.8801},{-34.9983,12.8801},{-38.9983,
                    14.8801}},
                lineColor={0,0,127},
                fillColor={255,255,255},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-30,50},{30,-50}},
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Line(points={{100,0},{0,0}}, color={0,0,127}),
              Line(points={{0,2},{0,-104}}, color={255,128,0}),
              Line(points={{-35,40},{-20,40}}, color={0,0,127}),
              Line(points={{-35,13},{-20,13}}, color={0,0,127}),
              Line(points={{-35,-13},{-20,-13}}, color={0,0,127}),
              Line(points={{-35,-40},{-20,-40}}, color={0,0,127}),
              Polygon(points={{0,0},{-20,13},{-20,13},{0,0},{0,0}}, lineColor={0,0,
                    127}),
              Ellipse(
                extent={{-6,6},{6,-6}},
                lineColor={255,128,0},
                fillColor={255,128,0},
                fillPattern=FillPattern.Solid)}),
                                Documentation(info="<html>
<p>This block extracts a scalar output signal out the
vector of input signals dependent on the Integer
value of the additional u index:</p>
<pre>    y = u [ index ] ;
</pre>
<p>where index is an additional Integer input signal.</p>
</html>"),Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1})));

      Modelica.Blocks.Interfaces.IntegerInput index             annotation (Placement(
              transformation(
              origin={0,-120},
              extent={{-20,-20},{20,20}},
              rotation=90)));
      protected
      Real k[nin];
    equation

      when {initial(),change(index)} then

        for i in 1:nin loop
          k[i] = if index == i then 1 else 0;

        end for;

      end when;

      y = if not allowOutOfRange or index > 0 and index <= nin then 
                  k*u else outOfRangeValue;
    end Extractor;

      block Multiplex2 "Multiplexer block for two input connectors"
        extends Modelica.Blocks.Interfaces.BlockIcon;
        parameter Integer n1=1 "dimension of input signal connector 1";
        parameter Integer n2=1 "dimension of input signal connector 2";
        Modelica.Blocks.Interfaces.RealInput u1[n1]
          "Connector of Real input signals 1" annotation (Placement(transformation(
                extent={{-140,40},{-100,80}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u2[n2]
          "Connector of Real input signals 2" annotation (Placement(transformation(
                extent={{-140,-80},{-100,-40}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y[n1 + n2]
          "Connector of Real output signals" annotation (Placement(transformation(
                extent={{100,-10},{120,10}}, rotation=0)));
        annotation (
          Documentation(info="<HTML>
<p>
The output connector is the <b>concatenation</b> of the two input connectors.
Note, that the dimensions of the input connector signals have to be
explicitly defined via parameters n1 and n2.
</p>
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{8,0},{102,0}}, color={0,0,127}),
              Ellipse(
                extent={{-14,16},{16,-14}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Line(points={{-98,60},{-60,60},{-4,6}}, color={0,0,127}),
              Line(points={{-98,-60},{-60,-60},{-4,-4}}, color={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-98,60},{-60,60},{-4,6}}, color={0,0,255}),
              Line(points={{-98,-60},{-60,-60},{-4,-4}}, color={0,0,255}),
              Line(points={{8,0},{102,0}}, color={0,0,255}),
              Ellipse(
                extent={{-14,16},{16,-14}},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255})}));

      equation
        [y] = [u1; u2];
      end Multiplex2;

      block Multiplex3 "Multiplexer block for three input connectors"
        extends Modelica.Blocks.Interfaces.BlockIcon;
        parameter Integer n1=1 "dimension of input signal connector 1";
        parameter Integer n2=1 "dimension of input signal connector 2";
        parameter Integer n3=1 "dimension of input signal connector 3";
        Modelica.Blocks.Interfaces.RealInput u1[n1]
          "Connector of Real input signals 1" annotation (Placement(transformation(
                extent={{-140,50},{-100,90}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u2[n2]
          "Connector of Real input signals 2" annotation (Placement(transformation(
                extent={{-140,-20},{-100,20}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u3[n3]
          "Connector of Real input signals 3" annotation (Placement(transformation(
                extent={{-140,-90},{-100,-50}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y[n1 + n2 + n3]
          "Connector of Real output signals" annotation (Placement(transformation(
                extent={{100,-10},{120,10}}, rotation=0)));
        annotation (
          Documentation(info="<HTML>
<p>
The output connector is the <b>concatenation</b> of the three input connectors.
Note, that the dimensions of the input connector signals have to be
explicitly defined via parameters n1, n2 and n3.
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{8,0},{102,0}}, color={0,0,127}),
              Line(points={{-100,70},{-60,70},{-4,6}}, color={0,0,127}),
              Line(points={{-100,0},{-12,0}}, color={0,0,127}),
              Line(points={{-100,-70},{-62,-70},{-4,-4}}, color={0,0,127}),
              Ellipse(
                extent={{-14,16},{16,-14}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-100,70},{-60,70},{-4,6}}, color={0,0,255}),
              Line(points={{-100,-70},{-62,-70},{-4,-4}}, color={0,0,255}),
              Line(points={{8,0},{102,0}}, color={0,0,255}),
              Ellipse(
                extent={{-14,16},{16,-14}},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Line(points={{-100,0},{-12,0}}, color={0,0,255})}));

      equation
        [y] = [u1; u2; u3];
      end Multiplex3;

      block Multiplex4 "Multiplexer block for four input connectors"
        extends Modelica.Blocks.Interfaces.BlockIcon;
        parameter Integer n1=1 "dimension of input signal connector 1";
        parameter Integer n2=1 "dimension of input signal connector 2";
        parameter Integer n3=1 "dimension of input signal connector 3";
        parameter Integer n4=1 "dimension of input signal connector 4";
        Modelica.Blocks.Interfaces.RealInput u1[n1]
          "Connector of Real input signals 1" annotation (Placement(transformation(
                extent={{-140,70},{-100,110}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u2[n2]
          "Connector of Real input signals 2" annotation (Placement(transformation(
                extent={{-140,10},{-100,50}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u3[n3]
          "Connector of Real input signals 3" annotation (Placement(transformation(
                extent={{-140,-50},{-100,-10}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u4[n4]
          "Connector of Real input signals 4" annotation (Placement(transformation(
                extent={{-140,-110},{-100,-70}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y[n1 + n2 + n3 + n4]
          "Connector of Real output signals" annotation (Placement(transformation(
                extent={{100,-10},{120,10}}, rotation=0)));
        annotation (
          Documentation(info="<HTML>
<p>
The output connector is the <b>concatenation</b> of the four input connectors.
Note, that the dimensions of the input connector signals have to be
explicitly defined via parameters n1, n2, n3 and n4.
</p>
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{8,0},{102,0}}, color={0,0,127}),
              Line(points={{-100,90},{-60,90},{-3,4}}, color={0,0,127}),
              Line(points={{-100,30},{-60,30},{-9,0}}, color={0,0,127}),
              Line(points={{-99,-30},{-59,-30},{-10,-5}}, color={0,0,127}),
              Line(points={{-100,-90},{-60,-90},{-5,-6}}, color={0,0,127}),
              Ellipse(
                extent={{-15,15},{15,-15}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-100,90},{-60,90},{-3,4}}, color={0,0,255}),
              Line(points={{-100,-90},{-60,-90},{-5,-6}}, color={0,0,255}),
              Line(points={{8,0},{102,0}}, color={0,0,255}),
              Ellipse(
                extent={{-15,15},{15,-15}},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Line(points={{-100,30},{-60,30},{-9,0}}, color={0,0,255}),
              Line(points={{-99,-30},{-59,-30},{-10,-5}}, color={0,0,255})}));

      equation
        [y] = [u1; u2; u3; u4];
      end Multiplex4;

      block Multiplex5 "Multiplexer block for five input connectors"
        extends Modelica.Blocks.Interfaces.BlockIcon;
        parameter Integer n1=1 "dimension of input signal connector 1";
        parameter Integer n2=1 "dimension of input signal connector 2";
        parameter Integer n3=1 "dimension of input signal connector 3";
        parameter Integer n4=1 "dimension of input signal connector 4";
        parameter Integer n5=1 "dimension of input signal connector 5";
        Modelica.Blocks.Interfaces.RealInput u1[n1]
          "Connector of Real input signals 1" annotation (Placement(transformation(
                extent={{-140,80},{-100,120}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u2[n2]
          "Connector of Real input signals 2" annotation (Placement(transformation(
                extent={{-140,30},{-100,70}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u3[n3]
          "Connector of Real input signals 3" annotation (Placement(transformation(
                extent={{-140,-20},{-100,20}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u4[n4]
          "Connector of Real input signals 4" annotation (Placement(transformation(
                extent={{-140,-70},{-100,-30}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u5[n5]
          "Connector of Real input signals 5" annotation (Placement(transformation(
                extent={{-140,-120},{-100,-80}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y[n1 + n2 + n3 + n4 + n5]
          "Connector of Real output signals" annotation (Placement(transformation(
                extent={{100,-10},{120,10}}, rotation=0)));
        annotation (
          Documentation(info="<HTML>
<p>
The output connector is the <b>concatenation</b> of the five input connectors.
Note, that the dimensions of the input connector signals have to be
explicitly defined via parameters n1, n2, n3, n4 and n5.
</p>
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{8,0},{102,0}}, color={0,0,255}),
              Line(points={{-100,100},{-60,100},{-4,6}}, color={0,0,127}),
              Line(points={{-99,50},{-60,50},{-8,5}}, color={0,0,127}),
              Line(points={{-100,0},{-7,0}}, color={0,0,127}),
              Line(points={{-99,-50},{-60,-50},{-9,-6}}, color={0,0,127}),
              Line(points={{-100,-100},{-60,-100},{-4,-4}}, color={0,0,127}),
              Ellipse(
                extent={{-15,15},{15,-15}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-100,100},{-60,100},{-4,6}}, color={0,0,255}),
              Line(points={{-100,-100},{-60,-100},{-4,-4}}, color={0,0,255}),
              Line(points={{8,0},{102,0}}, color={0,0,255}),
              Ellipse(
                extent={{-15,15},{15,-15}},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Line(points={{-99,50},{-60,50},{-8,5}}, color={0,0,255}),
              Line(points={{-100,0},{-7,0}}, color={0,0,255}),
              Line(points={{-99,-50},{-60,-50},{-9,-6}}, color={0,0,255})}));

      equation
        [y] = [u1; u2; u3; u4; u5];
      end Multiplex5;

      block Multiplex6 "Multiplexer block for six input connectors"
        extends Modelica.Blocks.Interfaces.BlockIcon;
        parameter Integer n1=1 "dimension of input signal connector 1";
        parameter Integer n2=1 "dimension of input signal connector 2";
        parameter Integer n3=1 "dimension of input signal connector 3";
        parameter Integer n4=1 "dimension of input signal connector 4";
        parameter Integer n5=1 "dimension of input signal connector 5";
        parameter Integer n6=1 "dimension of input signal connector 6";
        Modelica.Blocks.Interfaces.RealInput u1[n1]
          "Connector of Real input signals 1" annotation (Placement(transformation(
                extent={{-124,73},{-100,97}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u2[n2]
          "Connector of Real input signals 2" annotation (Placement(transformation(
                extent={{-124,39},{-100,63}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u3[n3]
          "Connector of Real input signals 3" annotation (Placement(transformation(
                extent={{-124,5},{-100,29}}, rotation=0)));

        Modelica.Blocks.Interfaces.RealInput u4[n4]
          "Connector of Real input signals 4" annotation (Placement(transformation(
                extent={{-124,-29},{-100,-5}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u5[n5]
          "Connector of Real input signals 5" annotation (Placement(transformation(
                extent={{-124,-63},{-100,-39}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealInput u6[n6]
          "Connector of Real input signals 6" annotation (Placement(transformation(
                extent={{-124,-97},{-100,-73}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y[n1 + n2 + n3 + n4 + n5 + n6]
          "Connector of Real output signals" annotation (Placement(transformation(
                extent={{100,-10},{120,10}}, rotation=0)));
        annotation (
          Documentation(info="<HTML>
<p>
The output connector is the <b>concatenation</b> of the six input connectors.
Note, that the dimensions of the input connector signals have to be
explicitly defined via parameters n1, n2, n3, n4, n5 and n6.
</p>
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{8,0},{102,0}}, color={0,0,127}),
              Ellipse(
                extent={{-15,15},{15,-15}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Line(points={{-99,85},{-61,85},{-3,11}}, color={0,0,127}),
              Line(points={{-100,51},{-61,51},{-7,6}}, color={0,0,127}),
              Line(points={{-101,17},{-60,17},{-9,2}}, color={0,0,127}),
              Line(points={{-100,-18},{-60,-18},{-11,-4}}, color={0,0,127}),
              Line(points={{-99,-50},{-60,-50},{-9,-6}}, color={0,0,127}),
              Line(points={{-100,-85},{-60,-85},{-3,-10}}, color={0,0,255})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-99,85},{-61,85},{-3,11}}, color={0,0,255}),
              Line(points={{-100,-85},{-60,-85},{-3,-10}}, color={0,0,255}),
              Line(points={{8,0},{102,0}}, color={0,0,255}),
              Ellipse(
                extent={{-15,15},{15,-15}},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Line(points={{-100,51},{-61,51},{-7,6}}, color={0,0,255}),
              Line(points={{-99,-50},{-60,-50},{-9,-6}}, color={0,0,255}),
              Line(points={{-101,17},{-60,17},{-9,2}}, color={0,0,255}),
              Line(points={{-100,-18},{-60,-18},{-11,-4}}, color={0,0,255})}));

      equation
        [y] = [u1; u2; u3; u4; u5; u6];
      end Multiplex6;

      block DeMultiplex2 "DeMultiplexer block for two output connectors"
        extends Modelica.Blocks.Interfaces.BlockIcon;
        parameter Integer n1=1 "dimension of output signal connector 1";
        parameter Integer n2=1 "dimension of output signal connector 2";
        Modelica.Blocks.Interfaces.RealInput u[n1 + n2]
          "Connector of Real input signals" annotation (Placement(transformation(
                extent={{-140,-20},{-100,20}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y1[n1]
          "Connector of Real output signals 1" annotation (Placement(transformation(
                extent={{100,50},{120,70}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y2[n2]
          "Connector of Real output signals 2" annotation (Placement(transformation(
                extent={{100,-70},{120,-50}}, rotation=0)));
        annotation (
          Documentation(info="<HTML>
<p>
The input connector is <b>splitted</b> up into two output connectors.
Note, that the dimensions of the output connector signals have to be
explicitly defined via parameters n1 and n2.
</p>
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{100,60},{60,60},{10,8}}, color={0,0,127}),
              Ellipse(
                extent={{-14,16},{16,-14}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Line(points={{100,-60},{60,-60},{8,-8}}, color={0,0,127}),
              Line(points={{-100,0},{-6,0}}, color={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{100,60},{60,60},{10,8}}, color={0,0,255}),
              Line(points={{100,-60},{60,-60},{8,-8}}, color={0,0,255}),
              Line(points={{-100,0},{-6,0}}, color={0,0,255}),
              Ellipse(
                extent={{-14,16},{16,-14}},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255})}));

      equation
        [u] = [y1; y2];
      end DeMultiplex2;

      block DeMultiplex3 "DeMultiplexer block for three output connectors"
        extends Modelica.Blocks.Interfaces.BlockIcon;
        parameter Integer n1=1 "dimension of output signal connector 1";
        parameter Integer n2=1 "dimension of output signal connector 2";
        parameter Integer n3=1 "dimension of output signal connector 3";
        Modelica.Blocks.Interfaces.RealInput u[n1 + n2 + n3]
          "Connector of Real input signals" annotation (Placement(transformation(
                extent={{-140,-20},{-100,20}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y1[n1]
          "Connector of Real output signals 1" annotation (Placement(transformation(
                extent={{100,60},{120,80}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y2[n2]
          "Connector of Real output signals 2" annotation (Placement(transformation(
                extent={{100,-10},{120,10}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y3[n3]
          "Connector of Real output signals 3" annotation (Placement(transformation(
                extent={{100,-80},{120,-60}}, rotation=0)));
        annotation (
          Documentation(info="<HTML>
<p>
The input connector is <b>splitted</b> up into three output connectors.
Note, that the dimensions of the output connector signals have to be
explicitly defined via parameters n1, n2 and n3.
</p>
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Ellipse(
                extent={{-14,16},{16,-14}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Line(points={{-100,0},{-6,0}}, color={0,0,127}),
              Line(points={{100,70},{60,70},{4,5}}, color={0,0,127}),
              Line(points={{0,0},{101,0}}, color={0,0,127}),
              Line(points={{100,-70},{61,-70},{5,-5}}, color={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{100,70},{60,70},{4,5}}, color={0,0,255}),
              Line(points={{100,-70},{61,-70},{5,-5}}, color={0,0,255}),
              Line(points={{-100,0},{-6,0}}, color={0,0,255}),
              Ellipse(
                extent={{-16,15},{14,-15}},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Line(points={{0,0},{101,0}}, color={0,0,255})}));

      equation
        [u] = [y1; y2; y3];
      end DeMultiplex3;

      block DeMultiplex4 "DeMultiplexer block for four output connectors"

        extends Modelica.Blocks.Interfaces.BlockIcon;
        parameter Integer n1=1 "dimension of output signal connector 1";
        parameter Integer n2=1 "dimension of output signal connector 2";
        parameter Integer n3=1 "dimension of output signal connector 3";
        parameter Integer n4=1 "dimension of output signal connector 4";
        Modelica.Blocks.Interfaces.RealInput u[n1 + n2 + n3 + n4]
          "Connector of Real input signals" annotation (Placement(transformation(
                extent={{-140,-20},{-100,20}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y1[n1]
          "Connector of Real output signals 1" annotation (Placement(transformation(
                extent={{100,80},{120,100}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y2[n2]
          "Connector of Real output signals 2" annotation (Placement(transformation(
                extent={{100,20},{120,40}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y3[n3]
          "Connector of Real output signals 3" annotation (Placement(transformation(
                extent={{100,-40},{120,-20}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y4[n4]
          "Connector of Real output signals 4" annotation (Placement(transformation(
                extent={{100,-100},{120,-80}}, rotation=0)));
        annotation (
          Documentation(info="<HTML>
<p>
The input connector is <b>splitted</b> up into four output connectors.
Note, that the dimensions of the output connector signals have to be
explicitly defined via parameters n1, n2, n3 and n4.
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Ellipse(
                extent={{-14,16},{16,-14}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Line(points={{-100,0},{-6,0}}, color={0,0,127}),
              Line(points={{100,90},{60,90},{6,5}}, color={0,0,127}),
              Line(points={{100,30},{60,30},{9,2}}, color={0,0,127}),
              Line(points={{100,-30},{60,-30},{8,-4}}, color={0,0,127}),
              Line(points={{99,-90},{60,-90},{6,-6}}, color={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{100,90},{60,90},{6,5}}, color={0,0,255}),
              Line(points={{99,-90},{60,-90},{6,-6}}, color={0,0,255}),
              Line(points={{-100,0},{-6,0}}, color={0,0,255}),
              Line(points={{100,30},{60,30},{9,2}}, color={0,0,255}),
              Line(points={{100,-30},{60,-30},{8,-4}}, color={0,0,255}),
              Ellipse(
                extent={{-16,15},{14,-15}},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255})}));

      equation
        [u] = [y1; y2; y3; y4];
      end DeMultiplex4;

      block DeMultiplex5 "DeMultiplexer block for five output connectors"

        extends Modelica.Blocks.Interfaces.BlockIcon;
        parameter Integer n1=1 "dimension of output signal connector 1";
        parameter Integer n2=1 "dimension of output signal connector 2";
        parameter Integer n3=1 "dimension of output signal connector 3";
        parameter Integer n4=1 "dimension of output signal connector 4";
        parameter Integer n5=1 "dimension of output signal connector 5";
        Modelica.Blocks.Interfaces.RealInput u[n1 + n2 + n3 + n4 + n5]
          "Connector of Real input signals" annotation (Placement(transformation(
                extent={{-140,-20},{-100,20}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y1[n1]
          "Connector of Real output signals 1" annotation (Placement(transformation(
                extent={{100,70},{120,90}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y2[n2]
          "Connector of Real output signals 2" annotation (Placement(transformation(
                extent={{100,30},{120,50}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y3[n3]
          "Connector of Real output signals 3" annotation (Placement(transformation(
                extent={{100,-10},{120,10}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y4[n4]
          "Connector of Real output signals 4" annotation (Placement(transformation(
                extent={{100,-50},{120,-30}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y5[n5]
          "Connector of Real output signals 5" annotation (Placement(transformation(
                extent={{100,-90},{120,-70}}, rotation=0)));
        annotation (
          Documentation(info="<HTML>
<p>
The input connector is <b>splitted</b> up into five output connectors.
Note, that the dimensions of the output connector signals have to be
explicitly defined via parameters n1, n2, n3, n4 and n5.
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Ellipse(
                extent={{-14,16},{16,-14}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Line(points={{-100,0},{-6,0}}, color={0,0,127}),
              Line(points={{99,80},{60,80},{6,5}}, color={0,0,127}),
              Line(points={{100,40},{60,40},{10,3}}, color={0,0,127}),
              Line(points={{100,0},{10,0}}, color={0,0,127}),
              Line(points={{100,-40},{61,-40},{11,-7}}, color={0,0,127}),
              Line(points={{100,-80},{60,-80},{7,-5}}, color={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{99,80},{60,80},{6,5}}, color={0,0,255}),
              Line(points={{100,-80},{60,-80},{7,-5}}, color={0,0,255}),
              Line(points={{-100,0},{-6,0}}, color={0,0,255}),
              Ellipse(
                extent={{-14,15},{16,-15}},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Line(points={{100,40},{60,40},{10,3}}, color={0,0,255}),
              Line(points={{100,0},{10,0}}, color={0,0,255}),
              Line(points={{100,-40},{61,-40},{11,-7}}, color={0,0,255})}));

      equation
        [u] = [y1; y2; y3; y4; y5];
      end DeMultiplex5;

      block DeMultiplex6 "DeMultiplexer block for six output connectors"
        extends Modelica.Blocks.Interfaces.BlockIcon;
        parameter Integer n1=1 "dimension of output signal connector 1";
        parameter Integer n2=1 "dimension of output signal connector 2";
        parameter Integer n3=1 "dimension of output signal connector 3";
        parameter Integer n4=1 "dimension of output signal connector 4";
        parameter Integer n5=1 "dimension of output signal connector 5";
        parameter Integer n6=1 "dimension of output signal connector 6";
        Modelica.Blocks.Interfaces.RealInput u[n1 + n2 + n3 + n4 + n5 + n6]
          "Connector of Real input signals" annotation (Placement(transformation(
                extent={{-140,-20},{-100,20}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y1[n1]
          "Connector of Real output signals 1" annotation (Placement(transformation(
                extent={{100,80},{120,100}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y2[n2]
          "Connector of Real output signals 2" annotation (Placement(transformation(
                extent={{100,44},{120,64}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y3[n3]
          "Connector of Real output signals 3" annotation (Placement(transformation(
                extent={{100,8},{120,28}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y4[n4]
          "Connector of Real output signals 4" annotation (Placement(transformation(
                extent={{100,-28},{120,-8}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y5[n5]
          "Connector of Real output signals 5" annotation (Placement(transformation(
                extent={{100,-64},{120,-44}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y6[n6]
          "Connector of Real output signals 6" annotation (Placement(transformation(
                extent={{100,-100},{120,-80}}, rotation=0)));
        annotation (
          Documentation(info="<HTML>
<p>
The input connector is <b>splitted</b> up into six output connectors.
Note, that the dimensions of the output connector signals have to be
explicitly defined via parameters n1, n2, n3, n4, n5 and n6.
</HTML>
"),       Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Ellipse(
                extent={{-14,16},{16,-14}},
                fillColor={0,0,127},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,127}),
              Line(points={{-100,0},{-6,0}}, color={0,0,127}),
              Line(points={{99,90},{60,90},{5,10}}, color={0,0,127}),
              Line(points={{100,53},{60,53},{8,6}}, color={0,0,127}),
              Line(points={{100,18},{59,18},{7,2}}, color={0,0,127}),
              Line(points={{100,-19},{60,-19},{13,-2}}, color={0,0,127}),
              Line(points={{99,-54},{60,-54},{9,-1}}, color={0,0,127}),
              Line(points={{100,-91},{60,-91},{3,-7}}, color={0,0,127})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{99,90},{60,90},{5,10}}, color={0,0,255}),
              Line(points={{100,-91},{60,-91},{3,-7}}, color={0,0,255}),
              Line(points={{-100,0},{-6,0}}, color={0,0,255}),
              Ellipse(
                extent={{-14,15},{16,-15}},
                fillColor={0,0,255},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Line(points={{100,53},{60,53},{8,6}}, color={0,0,255}),
              Line(points={{99,-54},{60,-54},{9,-1}}, color={0,0,255}),
              Line(points={{100,18},{59,18},{7,2}}, color={0,0,255}),
              Line(points={{100,-19},{60,-19},{13,-2}}, color={0,0,255})}));

      equation
        [u] = [y1; y2; y3; y4; y5; y6];
      end DeMultiplex6;

      annotation (Documentation(info="<html>
<p>
This package contains blocks to combine and extract signals.
</p>
</html>"));
      model RealPassThrough "Pass a Real signal through without modification"

        extends Modelica.Blocks.Interfaces.BlockIcon;

        Modelica.Blocks.Interfaces.RealInput u "Input signal" 
          annotation (HideResult=true, Placement(transformation(extent={{-140,-20},{-100,
                  20}}, rotation=0)));
        Modelica.Blocks.Interfaces.RealOutput y "Output signal" 
          annotation (HideResult=true, Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Line(points={{-100,0},{100,0}},
                  color={0,0,127})}),
                          Documentation(info="<html>
<p>
Passes a Real signal through without modification.  Enables signals to be read out of one bus, have their name changed and be sent back to a bus.
</p>
</html>"));
      equation
        y = u;
      end RealPassThrough;

      model IntegerPassThrough
        "Pass a Integer signal through without modification"
        extends Modelica.Blocks.Interfaces.IntegerBlockIcon;

        Modelica.Blocks.Interfaces.IntegerInput u "Input signal" 
          annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
        Modelica.Blocks.Interfaces.IntegerOutput y "Output signal" 
          annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Line(points={{-100,0},{100,0}},
                  color={255,128,0})}),
                          Documentation(info="<html>
<p>Passes a Integer signal through without modification.  Enables signals to be read out of one bus, have their name changed and be sent back to a bus.</p>
</html>"));
      equation
        y = u;

      end IntegerPassThrough;

      model BooleanPassThrough
        "Pass a Boolean signal through without modification"
        extends Modelica.Blocks.Interfaces.BooleanBlockIcon;

        Modelica.Blocks.Interfaces.BooleanInput u "Input signal" 
          annotation (Placement(transformation(extent={{-140,-20},{-100,20}},
                rotation=0)));
        Modelica.Blocks.Interfaces.BooleanOutput y "Output signal" 
          annotation (Placement(transformation(extent={{100,-10},{120,10}},
                rotation=0)));
        annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{
                  -100,-100},{100,100}}),
                            graphics),
                             Documentation(info="<html>
<p>Passes a Boolean signal through without modification.  Enables signals to be read out of one bus, have their name changed and be sent back to a bus.</p>
</html>"),Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={Line(points={{-100,0},{100,0}}, color={255,0,
                    255})}));
      equation
        y = u;
      end BooleanPassThrough;
    end Routing;

    package Sources
      "Library of signal source blocks generating Real and Boolean signals"
      block RealExpression
        "Set output signal to a time varying Real expression"

        Modelica.Blocks.Interfaces.RealOutput y=0.0 "Value of Real output" 
          annotation (                            Dialog(group=
                "Time varying output signal"), Placement(transformation(extent={{
                  100,-10},{120,10}}, rotation=0)));

        annotation (
          Icon(coordinateSystem(
              preserveAspectRatio=false,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(
                extent={{-100,40},{100,-40}},
                lineColor={0,0,0},
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid,
                borderPattern=BorderPattern.Raised),
              Text(
                extent={{-96,15},{96,-15}},
                lineColor={0,0,0},
                fillColor={0,255,0},
                fillPattern=FillPattern.Solid,
                textString="%y"),
              Text(
                extent={{-150,90},{140,50}},
                textString="%name",
                lineColor={0,0,255})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics),
          Documentation(info="<html>
<p>
The (time varying) Real output signal of this block can be defined in its
parameter menu via variable <b>y</b>. The purpose is to support the
easy definition of Real expressions in a block diagram. For example,
in the y-menu the definition \"if time &lt; 1 then 0 else 1\" can be given in order
to define that the output signal is one, if time &ge; 1 and otherwise
it is zero. Note, that \"time\" is a built-in variable that is always
accessible and represents the \"model time\" and that 
Variable <b>y</b> is both a variable and a connector.
</p>
</html>"));

      end RealExpression;

      block IntegerExpression
        "Set output signal to a time varying Integer expression"

        Modelica.Blocks.Interfaces.IntegerOutput y=0 "Value of Integer output" 
          annotation (                            Dialog(group=
                "Time varying output signal"), Placement(transformation(extent={{
                  100,-10},{120,10}}, rotation=0)));

        annotation (
          Icon(coordinateSystem(
              preserveAspectRatio=false,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(
                extent={{-100,40},{100,-40}},
                lineColor={0,0,0},
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid,
                borderPattern=BorderPattern.Raised),
              Text(
                extent={{-96,15},{96,-15}},
                lineColor={0,0,0},
                fillColor={0,255,0},
                fillPattern=FillPattern.Solid,
                textString="%y"),
              Text(
                extent={{-150,90},{140,50}},
                textString="%name",
                lineColor={0,0,255})}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics),
          Documentation(info="<html>
<p>
The (time varying) Integer output signal of this block can be defined in its
parameter menu via variable <b>y</b>. The purpose is to support the
easy definition of Integer expressions in a block diagram. For example,
in the y-menu the definition \"if time &lt; 1 then 0 else 1\" can be given in order
to define that the output signal is one, if time &ge; 1 and otherwise
it is zero. Note, that \"time\" is a built-in variable that is always
accessible and represents the \"model time\" and that 
Variable <b>y</b> is both a variable and a connector.
</p>
</html>"));

      end IntegerExpression;

      block BooleanExpression
        "Set output signal to a time varying Boolean expression"

        Modelica.Blocks.Interfaces.BooleanOutput y=false
          "Value of Boolean output" 
          annotation (                            Dialog(group=
                "Time varying output signal"), Placement(transformation(extent={{
                  100,-10},{120,10}}, rotation=0)));

        annotation (
          Icon(coordinateSystem(
              preserveAspectRatio=false,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Rectangle(
                extent={{-100,40},{100,-40}},
                lineColor={0,0,0},
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid,
                borderPattern=BorderPattern.Raised),
              Text(
                extent={{-96,15},{96,-15}},
                lineColor={0,0,0},
                fillColor={0,255,0},
                fillPattern=FillPattern.Solid,
                textString="%y"),
              Text(
                extent={{-150,90},{140,50}},
                textString="%name",
                lineColor={0,0,255}),
              Polygon(
                points={{100,10},{120,0},{100,-10},{100,10}},
                lineColor=DynamicSelect({255,0,255}, if y > 0.5 then {0,255,0} else 
                          {255,0,255}),
                fillColor=DynamicSelect({255,255,255}, if y > 0.5 then {0,255,0} else 
                          {255,255,255}),
                fillPattern=FillPattern.Solid)}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics),
          Documentation(info="<html>
<p>
The (time varying) Boolean output signal of this block can be defined in its
parameter menu via variable <b>y</b>. The purpose is to support the
easy definition of Boolean expressions in a block diagram. For example,
in the y-menu the definition \"time &gt;= 1 and time &lt;= 2\" can be given in order
to define that the output signal is <b>true</b> in the time interval
1 &le; time &le; 2 and otherwise it is <b>false</b>.
Note, that \"time\" is a built-in variable that is always
accessible and represents the \"model time\" and that 
Variable <b>y</b> is both a variable and a connector.
</p>
</html>"));

      end BooleanExpression;
      import Modelica.Blocks.Interfaces;
      import Modelica.SIunits;
          extends Modelica.Icons.Library;

          annotation (
            Documentation(info="<HTML>
<p>
This package contains <b>source</b> components, i.e., blocks which
have only output signals. These blocks are used as signal generators
for Real, Integer and Boolean signals.
</p>

<p>
All Real source signals (with the exception of the Constant source)
have at least the following two parameters:
</p>

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td valign=\"top\"><b>offset</b></td>
      <td valign=\"top\">Value which is added to the signal</td>
  </tr>
  <tr><td valign=\"top\"><b>startTime</b></td>
      <td valign=\"top\">Start time of signal. For time &lt; startTime,
                the output y is set to offset.</td>
  </tr>
</table>

<p>
The <b>offset</b> parameter is especially useful in order to shift
the corresponding source, such that at initial time the system
is stationary. To determine the corresponding value of offset,
usually requires a trimming calculation.
</p>
</HTML>
",     revisions="<html>
<ul>
<li><i>October 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
       and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       Integer sources added. Step, TimeTable and BooleanStep slightly changed.</li>
<li><i>Nov. 8, 1999</i>
       by <a href=\"mailto:clauss@eas.iis.fhg.de\">Christoph Clau&szlig;</a>,
       <A HREF=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</A>,
       <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       New sources: Exponentials, TimeTable. Trapezoid slightly enhanced
       (nperiod=-1 is an infinite number of periods).</li>
<li><i>Oct. 31, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       <a href=\"mailto:clauss@eas.iis.fhg.de\">Christoph Clau&szlig;</a>,
       <A HREF=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</A>,
       All sources vectorized. New sources: ExpSine, Trapezoid,
       BooleanConstant, BooleanStep, BooleanPulse, SampleTrigger.
       Improved documentation, especially detailed description of
       signals in diagram layer.</li>
<li><i>June 29, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized a first version, based on an existing Dymola library
       of Dieter Moormann and Hilding Elmqvist.</li>
</ul>
</html>"));

          block Clock "Generate actual time signal "
            parameter Modelica.SIunits.Time offset=0 "Offset of output signal";
            parameter Modelica.SIunits.Time startTime=0
          "Output = offset for time < startTime";
            extends Interfaces.SO;

            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Ellipse(extent={{-80,80},{80,-80}}, lineColor={160,160,164}),
              Line(points={{0,80},{0,60}}, color={160,160,164}),
              Line(points={{80,0},{60,0}}, color={160,160,164}),
              Line(points={{0,-80},{0,-60}}, color={160,160,164}),
              Line(points={{-80,0},{-60,0}}, color={160,160,164}),
              Line(points={{37,70},{26,50}}, color={160,160,164}),
              Line(points={{70,38},{49,26}}, color={160,160,164}),
              Line(points={{71,-37},{52,-27}}, color={160,160,164}),
              Line(points={{39,-70},{29,-51}}, color={160,160,164}),
              Line(points={{-39,-70},{-29,-52}}, color={160,160,164}),
              Line(points={{-71,-37},{-50,-26}}, color={160,160,164}),
              Line(points={{-71,37},{-54,28}}, color={160,160,164}),
              Line(points={{-38,70},{-28,51}}, color={160,160,164}),
              Line(
                points={{0,0},{-50,50}},
                color={0,0,0},
                thickness=0.5),
              Line(
                points={{0,0},{40,0}},
                color={0,0,0},
                thickness=0.5),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="startTime=%startTime")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Polygon(
                points={{-80,90},{-85,68},{-75,68},{-80,90}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
              Line(
                points={{-80,0},{-10,0},{60,70}},
                color={0,0,255},
                thickness=0.5),
              Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
              Polygon(
                points={{90,-70},{68,-64},{68,-76},{90,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-34,0},{-37,-13},{-30,-13},{-34,0}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-34,-13},{-34,-70}}, color={95,95,95}),
              Polygon(
                points={{-34,-69},{-37,-56},{-31,-56},{-34,-69},{-34,-69}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-77,-28},{-35,-40}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Text(
                extent={{-30,-73},{18,-86}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Text(
                extent={{-81,91},{-40,71}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y"),
              Text(
                extent={{63,-79},{94,-89}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Line(points={{-10,0},{-10,-70}}, color={95,95,95}),
              Line(points={{-10,0},{50,0}}, color={95,95,95}),
              Line(points={{50,0},{50,60}}, color={95,95,95}),
              Text(
                extent={{35,33},{50,23}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="1"),
              Text(
                extent={{14,13},{32,1}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="1")}),
          Documentation(info="<html>
<p>
The Real output y is a clock signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Clock.png\">
</p>
</html>"));

          equation
            y = offset + (if time < startTime then 0 else time - startTime);
          end Clock;

          block Constant "Generate constant signal of type Real"
            parameter Real k(start=1) "Constant output value";
            extends Interfaces.SO;

            annotation (defaultComponentName="const",
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,0},{80,0}}, color={0,0,0}),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="k=%k")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Polygon(
                points={{-80,90},{-86,68},{-74,68},{-80,90}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
              Line(
                points={{-80,0},{80,0}},
                color={0,0,255},
                thickness=0.5),
              Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
              Polygon(
                points={{90,-70},{68,-64},{68,-76},{90,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-83,92},{-30,74}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y"),
              Text(
                extent={{70,-80},{94,-100}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Text(
                extent={{-101,8},{-81,-12}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="k")}),
          Documentation(info="<html>
<p>
The Real output y is a constant signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Constant.png\">
</p>
</html>"));
          equation
            y = k;
          end Constant;

          block Step "Generate step signal of type Real"
            parameter Real height=1 "Height of step";
            extends Interfaces.SignalSource;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-70},{0,-70},{0,50},{80,50}}, color={0,0,0}),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="startTime=%startTime")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Polygon(
                points={{-80,90},{-86,68},{-74,68},{-80,90}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
              Line(
                points={{-80,-18},{0,-18},{0,50},{80,50}},
                color={0,0,255},
                thickness=0.5),
              Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
              Polygon(
                points={{90,-70},{68,-64},{68,-76},{90,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{70,-80},{94,-100}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Text(
                extent={{-21,-72},{25,-90}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Line(points={{0,-17},{0,-71}}, color={95,95,95}),
              Text(
                extent={{-68,-36},{-22,-54}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Line(points={{-13,50},{-13,-17}}, color={95,95,95}),
              Polygon(
                points={{2,50},{-19,50},{2,50}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-13,-17},{-16,-4},{-10,-4},{-13,-17},{-13,-17}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-13,50},{-16,37},{-9,37},{-13,50}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-68,26},{-22,8}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="height"),
              Polygon(
                points={{-13,-69},{-16,-56},{-10,-56},{-13,-69},{-13,-69}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-13,-18},{-13,-70}}, color={95,95,95}),
              Polygon(
                points={{-13,-18},{-16,-31},{-9,-31},{-13,-18}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-72,100},{-31,80}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y")}),
          Documentation(info="<html>
<p>
The Real output y is a step signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Step.png\">
</p>

</html>"));

          equation
            y = offset + (if time < startTime then 0 else height);
          end Step;

          block Ramp "Generate ramp signal"
            parameter Real height=1 "Height of ramps";
            parameter Modelica.SIunits.Time duration(min=Modelica.Constants.small, start = 2)
          "Durations of ramp";
            parameter Real offset=0 "Offset of output signal";
            parameter Modelica.SIunits.Time startTime=0
          "Output = offset for time < startTime";
            extends Interfaces.SO;

            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-70},{-40,-70},{31,38}}, color={0,0,0}),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="duration=%duration"),
              Line(points={{31,38},{86,38}}, color={0,0,0})}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Polygon(
                points={{-80,90},{-86,68},{-74,68},{-80,90}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
              Line(
                points={{-80,-20},{-20,-20},{50,50}},
                color={0,0,255},
                thickness=0.5),
              Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
              Polygon(
                points={{90,-70},{68,-64},{68,-76},{90,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-40,-20},{-42,-30},{-37,-30},{-40,-20}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(
                points={{-40,-20},{-40,-70}},
                color={95,95,95},
                thickness=0.25,
                arrow={Arrow.None,Arrow.None}),
              Polygon(
                points={{-40,-70},{-43,-60},{-38,-60},{-40,-70},{-40,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-72,-39},{-34,-50}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Text(
                extent={{-38,-72},{6,-83}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Text(
                extent={{-78,92},{-37,72}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y"),
              Text(
                extent={{70,-80},{94,-91}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Line(points={{-20,-20},{-20,-70}}, color={95,95,95}),
              Line(
                points={{-19,-20},{50,-20}},
                color={95,95,95},
                thickness=0.25,
                arrow={Arrow.None,Arrow.None}),
              Line(
                points={{50,50},{101,50}},
                color={0,0,255},
                thickness=0.5),
              Line(
                points={{50,50},{50,-20}},
                color={95,95,95},
                thickness=0.25,
                arrow={Arrow.None,Arrow.None}),
              Polygon(
                points={{50,-20},{42,-18},{42,-22},{50,-20}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-20,-20},{-11,-18},{-11,-22},{-20,-20}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{50,50},{48,40},{53,40},{50,50}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{50,-20},{47,-10},{52,-10},{50,-20},{50,-20}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{53,23},{82,10}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="height"),
              Text(
                extent={{-2,-21},{37,-33}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="duration")}),
          Documentation(info="<html>
<p>
The Real output y is a ramp signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Ramp.png\">
</p>
</html>"));

          equation
            y = offset + (if time < startTime then 0 else if time < (startTime +
              duration) then (time - startTime)*height/duration else height);
          end Ramp;

          block Sine "Generate sine signal"
            parameter Real amplitude=1 "Amplitude of sine wave";
            parameter SIunits.Frequency freqHz(start=1)
          "Frequency of sine wave";
            parameter SIunits.Angle phase=0 "Phase of sine wave";
            parameter Real offset=0 "Offset of output signal";
            parameter SIunits.Time startTime=0
          "Output = offset for time < startTime";
            extends Interfaces.SO;
      protected
            constant Real pi=Modelica.Constants.pi;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,
                    74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,
                    59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,
                    -64.2},{29.3,-73.1},{35,-78.4},{40.6,-80},{46.2,-77.6},{51.9,-71.5},
                    {57.5,-61.9},{63.9,-47.2},{72,-24.8},{80,0}}, color={0,0,0}),
              Text(
                extent={{-147,-152},{153,-112}},
                lineColor={0,0,0},
                textString="freqHz=%freqHz")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-80,-90},{-80,84}}, color={95,95,95}),
              Polygon(
                points={{-80,97},{-84,81},{-76,81},{-80,97}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-99,-40},{85,-40}}, color={95,95,95}),
              Polygon(
                points={{97,-40},{81,-36},{81,-45},{97,-40}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(
                points={{-41,-2},{-31.6,34.2},{-26.1,53.1},{-21.3,66.4},{-17.1,74.6},
                    {-12.9,79.1},{-8.64,79.8},{-4.42,76.6},{-0.201,69.7},{4.02,59.4},
                    {8.84,44.1},{14.9,21.2},{27.5,-30.8},{33,-50.2},{37.8,-64.2},{
                    42,-73.1},{46.2,-78.4},{50.5,-80},{54.7,-77.6},{58.9,-71.5},{
                    63.1,-61.9},{67.9,-47.2},{74,-24.8},{80,0}},
                color={0,0,255},
                thickness=0.5),
              Line(
                points={{-41,-2},{-80,-2}},
                color={0,0,255},
                thickness=0.5),
              Text(
                extent={{-87,12},{-40,0}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Line(points={{-41,-2},{-41,-40}}, color={95,95,95}),
              Text(
                extent={{-60,-43},{-14,-54}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Text(
                extent={{75,-47},{100,-60}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Text(
                extent={{-80,99},{-40,82}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y"),
              Line(points={{-9,79},{43,79}}, color={95,95,95}),
              Line(points={{-41,-2},{50,-2}}, color={95,95,95}),
              Polygon(
                points={{33,79},{30,66},{37,66},{33,79}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{37,57},{83,39}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="amplitude"),
              Polygon(
                points={{33,-2},{30,11},{36,11},{33,-2},{33,-2}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{33,77},{33,-2}}, color={95,95,95})}),
          Documentation(info="<html>
<p>
The Real output y is a sine signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Sine.png\">
</p>
</html>"));

          equation
            y = offset + (if time < startTime then 0 else amplitude*
              Modelica.Math.sin(2*pi*freqHz*(time - startTime) + phase));
          end Sine;

          block ExpSine "Generate exponentially damped sine signal"
            parameter Real amplitude=1 "Amplitude of sine wave";
            parameter SIunits.Frequency freqHz(start=2)
          "Frequency of sine wave";
            parameter SIunits.Angle phase=0 "Phase of sine wave";
            parameter SIunits.Damping damping(start=1)
          "Damping coefficient of sine wave";
            parameter Real offset=0 "Offset of output signal";
            parameter SIunits.Time startTime=0
          "Output = offset for time < startTime";
            extends Interfaces.SO;
      protected
            constant Real pi=Modelica.Constants.pi;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,0},{68,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,0},{-75.2,32.3},{-72,50.3},{-68.7,64.5},{-65.5,74.2},
                    {-62.3,79.3},{-59.1,79.6},{-55.9,75.3},{-52.7,67.1},{-48.6,52.2},
                    {-43,25.8},{-35,-13.9},{-30.2,-33.7},{-26.1,-45.9},{-22.1,-53.2},
                    {-18.1,-55.3},{-14.1,-52.5},{-10.1,-45.3},{-5.23,-32.1},{8.44,
                    13.7},{13.3,26.4},{18.1,34.8},{22.1,38},{26.9,37.2},{31.8,31.8},
                    {38.2,19.4},{51.1,-10.5},{57.5,-21.2},{63.1,-25.9},{68.7,-25.9},
                    {75.2,-20.5},{80,-13.8}}, color={0,0,0}),
              Text(
                extent={{-147,-152},{153,-112}},
                lineColor={0,0,0},
                textString="freqHz=%freqHz")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-86,-90},{-86,84}}, color={95,95,95}),
              Polygon(
                points={{-86,98},{-90,82},{-82,82},{-86,98}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-99,-40},{85,-40}}, color={95,95,95}),
              Polygon(
                points={{97,-40},{81,-35},{81,-44},{97,-40}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(
                points={{-50,0},{-46.1,28.2},{-43.5,44},{-40.9,56.4},{-38.2,64.9},{
                    -35.6,69.4},{-33,69.6},{-30.4,65.9},{-27.8,58.7},{-24.5,45.7},{
                    -19.9,22.5},{-13.4,-12.2},{-9.5,-29.5},{-6.23,-40.1},{-2.96,-46.5},
                    {0.302,-48.4},{3.57,-45.9},{6.83,-39.6},{10.8,-28.1},{21.9,12},
                    {25.8,23.1},{29.7,30.5},{33,33.3},{36.9,32.5},{40.8,27.8},{46,
                    16.9},{56.5,-9.2},{61.7,-18.6},{66.3,-22.7},{70.9,-22.6},{76.1,
                    -18},{80,-12.1}},
                color={0,0,255},
                thickness=0.5),
              Text(
                extent={{-80,17},{-57,-3}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Text(
                extent={{-72,-43},{-25,-53}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Text(
                extent={{77,-53},{101,-64}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Text(
                extent={{-89,99},{-49,82}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y"),
              Line(points={{-50,0},{18,0}}, color={95,95,95}),
              Line(
                points={{-50,0},{-86,0}},
                color={0,0,255},
                thickness=0.5),
              Line(points={{-50,77},{-50,0}}, color={95,95,95}),
              Line(points={{18,-1},{18,76}}, color={95,95,95}),
              Line(points={{18,73},{-50,73}}, color={95,95,95}),
              Text(
                extent={{-42,83},{9,74}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="1/freqHz"),
              Polygon(
                points={{-49,73},{-40,75},{-40,71},{-49,73}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{18,73},{10,75},{10,71},{18,73}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-50,-61},{-19,-61}}, color={95,95,95}),
              Polygon(
                points={{-18,-61},{-26,-59},{-26,-63},{-18,-61}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-51,-63},{-27,-75}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="t"),
              Text(
                extent={{-83,-69},{100,-96}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="amplitude*exp(-damping*t)*sin(2*pi*freqHz*t+phase)"),
              Line(points={{-50,0},{-50,-40}}, color={95,95,95}),
              Line(points={{-50,-54},{-50,-72}}, color={95,95,95}),
              Line(points={{-15,-77},{-1,-48}}, color={95,95,95})}),
          Documentation(info="<html>
<p>
The Real output y is a sine signal with exponentially changing amplitude:
</p>

<p>
<img src=\"../Images/Blocks/Sources/ExpSine.png\">
</p>
</html>"));

          equation
            y = offset + (if time < startTime then 0 else amplitude*
              Modelica.Math.exp(-(time - startTime)*damping)*Modelica.Math.sin(2*pi
              *freqHz*(time - startTime) + phase));
          end ExpSine;

          model Exponentials "Generate a rising and falling exponential signal"

            parameter Real outMax=1 "Height of output for infinite riseTime";
            parameter SIunits.Time riseTime(min=0,start = 0.5) "Rise time";
            parameter SIunits.Time riseTimeConst(min=Modelica.Constants.small)=0.1
          "Rise time constant; rising is defined as outMax*(1-exp(-riseTime/riseTimeConst))";
            parameter SIunits.Time fallTimeConst(min=Modelica.Constants.small)=
              riseTimeConst "Fall time constant";
            parameter Real offset=0 "Offset of output signal";
            parameter SIunits.Time startTime=0
          "Output = offset for time < startTime";
            extends Interfaces.SO;
      protected
            Real y_riseTime;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-90,-70},{68,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-70},{-77.2,-55.3},{-74.3,-42.1},{-70.8,-27.6},{-67.3,
                    -15},{-63.7,-4.08},{-59.5,7.18},{-55.3,16.7},{-50.3,26},{-44.6,
                    34.5},{-38.3,42.1},{-31.2,48.6},{-22.7,54.3},{-12.1,59.2},{-10,
                    60},{-7.88,47.5},{-5.05,32.7},{-2.22,19.8},{0.606,8.45},{4.14,-3.7},
                    {7.68,-14},{11.9,-24.2},{16.2,-32.6},{21.1,-40.5},{26.8,-47.4},
                    {33.1,-53.3},{40.9,-58.5},{50.8,-62.8},{60,-65.4}}, color={0,0,
                    0}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="riseTime=%riseTime")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-90,-74},{84,-74}}, color={95,95,95}),
              Polygon(
                points={{97,-74},{81,-70},{81,-78},{97,-74}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(
                points={{-40,-34},{-37.2,-19.3},{-34.3,-6.1},{-30.8,8.4},{-27.3,21},
                    {-23.7,31.92},{-19.5,43.18},{-15.3,52.7},{-10.3,62},{-4.6,70.5},
                    {1.7,78.1},{8.8,84.6},{17.3,90.3},{27.9,95.2},{30,96},{32.12,
                    83.5},{34.95,68.7},{37.78,55.8},{40.606,44.45},{44.14,32.3},{
                    47.68,22},{51.9,11.8},{56.2,3.4},{61.1,-4.5},{66.8,-11.4},{73.1,
                    -17.3},{80.9,-22.5},{90.8,-26.8},{100,-29.4}},
                color={0,0,255},
                thickness=0.5),
              Polygon(
                points={{-80,86},{-86,64},{-74,64},{-80,86}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,64},{-80,-84}}, color={95,95,95}),
              Text(
                extent={{-81,87},{-40,67}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y"),
              Text(
                extent={{-71,-46},{-38,-55}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Polygon(
                points={{-40,-74},{-43,-64},{-38,-64},{-40,-74},{-40,-74}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-40,-33},{-40,-64}}, color={95,95,95}),
              Polygon(
                points={{-40,-34},{-42,-44},{-37,-44},{-40,-34}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(
                points={{-39,-34},{-80,-34}},
                color={0,0,255},
                thickness=0.5),
              Text(
                extent={{-62,-76},{-17,-85}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Polygon(
                points={{-41,-34},{-32,-32},{-32,-36},{-41,-34}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-40,-34},{29,-34}}, color={95,95,95}),
              Polygon(
                points={{29,-34},{21,-32},{21,-36},{29,-34}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-26,-22},{19,-32}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="riseTime"),
              Text(
                extent={{75,-79},{98,-90}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Line(points={{30,96},{30,-38}}, color={95,95,95})}),
          Documentation(info="<html>
<p>
The Real output y is a rising exponential followed
by a falling exponential signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Exponentials.png\">
</p>
</html>"));

          equation
            y_riseTime = outMax*(1 - Modelica.Math.exp(-riseTime/riseTimeConst));
            y = offset + (if (time < startTime) then 0 else if (time < (startTime
               + riseTime)) then outMax*(1 - Modelica.Math.exp(-(time - startTime)/riseTimeConst)) else 
                    y_riseTime*Modelica.Math.exp(-(time - startTime - riseTime)/
              fallTimeConst));

          end Exponentials;

          block Pulse "Generate pulse signal of type Real"
            parameter Real amplitude=1 "Amplitude of pulse";
            parameter Real width(
              final min=Modelica.Constants.small,
              final max=100) = 50 "Width of pulse in % of period";
            parameter Modelica.SIunits.Time period(final min=Modelica.Constants.small,start=1)
          "Time for one period";
            parameter Real offset=0 "Offset of output signals";
            parameter Modelica.SIunits.Time startTime=0
          "Output = offset for time < startTime";
            extends Modelica.Blocks.Interfaces.SO;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-70},{-40,-70},{-40,44},{0,44},{0,-70},{40,-70},{40,
                    44},{79,44}}, color={0,0,0}),
              Text(
                extent={{-147,-152},{153,-112}},
                lineColor={0,0,0},
                textString="period=%period")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Polygon(
                points={{-80,90},{-85,68},{-74,68},{-80,90}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
              Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
              Polygon(
                points={{90,-70},{68,-65},{68,-76},{90,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-34,1},{-37,-12},{-30,-12},{-34,1}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-34,-1},{-34,-70}}, color={95,95,95}),
              Polygon(
                points={{-34,-70},{-37,-57},{-31,-57},{-34,-70},{-34,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-78,-24},{-35,-36}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Text(
                extent={{-30,-72},{16,-81}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Text(
                extent={{-82,96},{-49,79}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y"),
              Text(
                extent={{66,-79},{87,-89}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Line(points={{-10,0},{-10,-70}}, color={95,95,95}),
              Line(
                points={{-80,0},{-10,0},{-10,50},{30,50},{30,0},{50,0},{50,50},{90,
                    50}},
                color={0,0,255},
                thickness=0.5),
              Line(points={{-10,88},{-10,49}}, color={95,95,95}),
              Line(points={{30,74},{30,50}}, color={95,95,95}),
              Line(points={{50,88},{50,50}}, color={95,95,95}),
              Line(points={{-10,83},{51,83}}, color={95,95,95}),
              Line(points={{-10,69},{30,69}}, color={95,95,95}),
              Text(
                extent={{-3,93},{39,84}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="period"),
              Text(
                extent={{-7,78},{30,69}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="width"),
              Line(points={{-43,50},{-10,50}}, color={95,95,95}),
              Line(points={{-34,50},{-34,1}}, color={95,95,95}),
              Text(
                extent={{-77,30},{-37,21}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="amplitude"),
              Polygon(
                points={{-34,49},{-37,36},{-30,36},{-34,49}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-34,1},{-37,14},{-31,14},{-34,1},{-34,1}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(
                points={{90,50},{90,0},{100,0}},
                color={0,0,255},
                thickness=0.5),
              Polygon(
                points={{-10,69},{-1,71},{-1,67},{-10,69}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{30,69},{22,71},{22,67},{30,69}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-10,83},{-1,85},{-1,81},{-10,83}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{50,83},{42,85},{42,81},{50,83}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid)}),
          Documentation(info="<html>
<p>
The Real output y is a pulse signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Pulse.png\">
</p>
</html>"));

      protected
            Modelica.SIunits.Time T0(final start=startTime)
          "Start time of current period";
            Modelica.SIunits.Time T_width = period*width/100;
          equation
            when sample(startTime, period) then
              T0 = time;
            end when;
            y = offset + (if time < startTime or time >= T0 + T_width then 0 else 
              amplitude);
          end Pulse;

          block SawTooth "Generate saw tooth signal"
            parameter Real amplitude=1 "Amplitude of saw tooth";
            parameter SIunits.Time period(final min=Modelica.Constants.small,start = 1)
          "Time for one period";
            parameter Real offset=0 "Offset of output signals";
            parameter SIunits.Time startTime=0
          "Output = offset for time < startTime";
            extends Interfaces.SO;
      protected
            SIunits.Time T0(final start=startTime)
          "Start time of current period";
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-70},{-60,-70},{0,40},{0,-70},{60,41},{60,-70}},
                  color={0,0,0}),
              Text(
                extent={{-147,-152},{153,-112}},
                lineColor={0,0,0},
                textString="period=%period")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Polygon(
                points={{-80,90},{-86,68},{-74,68},{-80,90}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
              Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
              Polygon(
                points={{90,-70},{68,-65},{68,-75},{90,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-34,-19},{-37,-32},{-30,-32},{-34,-19}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-34,-20},{-34,-70}}, color={95,95,95}),
              Polygon(
                points={{-34,-70},{-37,-57},{-31,-57},{-34,-70},{-34,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-65,-39},{-29,-47}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Text(
                extent={{-29,-72},{13,-80}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Text(
                extent={{-82,92},{-43,76}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y"),
              Text(
                extent={{67,-78},{88,-87}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Line(points={{-10,-20},{-10,-70}}, color={95,95,95}),
              Line(points={{-10,88},{-10,-20}}, color={95,95,95}),
              Line(points={{30,88},{30,59}}, color={95,95,95}),
              Line(points={{-10,83},{30,83}}, color={95,95,95}),
              Text(
                extent={{-12,94},{34,85}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="period"),
              Line(points={{-44,60},{30,60}}, color={95,95,95}),
              Line(points={{-34,47},{-34,-7}}, color={95,95,95}),
              Text(
                extent={{-73,25},{-36,16}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="amplitude"),
              Polygon(
                points={{-34,60},{-37,47},{-30,47},{-34,60}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-34,-20},{-37,-7},{-31,-7},{-34,-20},{-34,-20}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-10,83},{-1,85},{-1,81},{-10,83}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{30,83},{22,85},{22,81},{30,83}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(
                points={{-80,-20},{-10,-20},{30,60},{30,-20},{72,60},{72,-20}},
                color={0,0,255},
                thickness=0.5)}),
          Documentation(info="<html>
<p>
The Real output y is a saw tooth signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/SawTooth.png\">
</p>
</html>"));

          equation
            when sample(startTime, period) then
              T0 = time;
            end when;
            y = offset + (if time < startTime then 0 else (amplitude/period)*(time
               - T0));
          end SawTooth;

          block Trapezoid "Generate trapezoidal signal of type Real"
            parameter Real amplitude=1 "Amplitude of trapezoid";
            parameter SIunits.Time rising(final min=0) = 0
          "Rising duration of trapezoid";
            parameter SIunits.Time width(final min=0) = 0.5
          "Width duration of trapezoid";
            parameter SIunits.Time falling(final min=0) = 0
          "Falling duration of trapezoid";
            parameter SIunits.Time period(final min=Modelica.Constants.small, start= 1)
          "Time for one period";
            parameter Integer nperiod=-1
          "Number of periods (< 0 means infinite number of periods)";
            parameter Real offset=0 "Offset of output signal";
            parameter SIunits.Time startTime=0
          "Output = offset for time < startTime";
            extends Interfaces.SO;
      protected
            parameter SIunits.Time T_rising=rising
          "End time of rising phase within one period";
            parameter SIunits.Time T_width=T_rising + width
          "End time of width phase within one period";
            parameter SIunits.Time T_falling=T_width + falling
          "End time of falling phase within one period";
            SIunits.Time T0(final start=startTime)
          "Start time of current period";
            Integer counter(start=nperiod) "Period counter";
            Integer counter2(start=nperiod);
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-147,-152},{153,-112}},
                lineColor={0,0,0},
                textString="period=%period"),
              Line(points={{-81,-70},{-60,-70},{-30,40},{9,40},{39,-70},{61,-70},{
                    90,40}}, color={0,0,0})}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Polygon(
                points={{-81,90},{-87,68},{-75,68},{-81,90}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-81,68},{-81,-80}}, color={95,95,95}),
              Line(points={{-91,-70},{81,-70}}, color={95,95,95}),
              Polygon(
                points={{89,-70},{67,-65},{67,-76},{89,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-46,-30},{-48,-41},{-44,-41},{-46,-30}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(
                points={{-46,-31},{-46,-70}},
                color={95,95,95},
                pattern=LinePattern.Solid,
                arrow={Arrow.None,Arrow.None}),
              Polygon(
                points={{-46,-70},{-48,-60},{-44,-60},{-46,-70},{-46,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-80,-46},{-42,-55}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Text(
                extent={{-49,-71},{-6,-81}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Text(
                extent={{-80,95},{-47,80}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y"),
              Text(
                extent={{66,-78},{89,-89}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Line(
                points={{-30,82},{-31,-70}},
                color={95,95,95},
                pattern=LinePattern.Dash),
              Line(
                points={{-11,59},{-11,40}},
                color={95,95,95},
                pattern=LinePattern.Dash),
              Line(
                points={{19,59},{19,39}},
                color={95,95,95},
                pattern=LinePattern.Dash),
              Line(
                points={{39,59},{39,-30}},
                color={95,95,95},
                pattern=LinePattern.Dash),
              Line(points={{-21,76},{60,76}}, color={95,95,95}),
              Line(points={{-30,56},{39,56}}, color={95,95,95}),
              Text(
                extent={{-3,86},{24,77}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="period"),
              Text(
                extent={{-11,68},{18,59}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="width"),
              Line(
                points={{-43,40},{-11,40}},
                color={95,95,95},
                pattern=LinePattern.Dash),
              Line(
                points={{-40,40},{-40,-19}},
                color={95,95,95},
                pattern=LinePattern.Solid,
                arrow={Arrow.None,Arrow.None}),
              Text(
                extent={{-77,11},{-44,1}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="amplitude"),
              Polygon(
                points={{-30,56},{-23,58},{-23,54},{-30,56}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-11,56},{-18,58},{-18,54},{-11,56}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-30,76},{-21,78},{-21,74},{-30,76}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{60,76},{52,78},{52,74},{60,76}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(
                points={{-81,-30},{-31,-30},{-11,40},{19,40},{39,-30},{59,-30},{79,
                    40},{99,40}},
                color={0,0,255},
                thickness=0.5),
              Polygon(
                points={{-40,40},{-42,29},{-38,29},{-40,40}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-40,-29},{-42,-19},{-38,-19},{-40,-29},{-40,-29}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(
                points={{60,84},{59,-30}},
                color={95,95,95},
                pattern=LinePattern.Dash),
              Polygon(
                points={{38,56},{31,58},{31,54},{38,56}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{19,56},{26,58},{26,54},{19,56}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{19,56},{12,58},{12,54},{19,56}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-13,56},{-6,58},{-6,54},{-13,56}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-35,68},{-6,60}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="rising"),
              Text(
                extent={{16,68},{44,60}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="falling")}),
          Documentation(info="<html>
<p>
The Real output y is a trapezoid signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Trapezoid.png\">
</p>
</html>"));

          equation
            when pre(counter2) <> 0 and sample(startTime, period) then
              T0 = time;
              counter2 = pre(counter);
              counter = pre(counter) - (if pre(counter) > 0 then 1 else 0);
            end when;
            y = offset + (if (time < startTime or counter2 == 0 or time >= T0 +
              T_falling) then 0 else if (time < T0 + T_rising) then (time - T0)*
              amplitude/T_rising else if (time < T0 + T_width) then amplitude else 
              (T0 + T_falling - time)*amplitude/(T_falling - T_width));
          end Trapezoid;

          block KinematicPTP
        "Move as fast as possible along a distance within given kinematic constraints"

            parameter Real deltaq[:] "Distance to move";
            parameter Real qd_max[:](final min=Modelica.Constants.small)
          "Maximum velocities der(q)";
            parameter Real qdd_max[:](final min=Modelica.Constants.small)
          "Maximum accelerations der(qd)";
            parameter SIunits.Time startTime=0
          "Time instant at which movement starts";

            extends Interfaces.MO(final nout=max([size(deltaq, 1); size(qd_max, 1);
                   size(qdd_max, 1)]));

      protected
            parameter Real p_deltaq[nout]=(if size(deltaq, 1) == 1 then ones(nout)*
                deltaq[1] else deltaq);
            parameter Real p_qd_max[nout]=(if size(qd_max, 1) == 1 then ones(nout)*
                qd_max[1] else qd_max);
            parameter Real p_qdd_max[nout]=(if size(qdd_max, 1) == 1 then ones(nout)
                *qdd_max[1] else qdd_max);
            Real sd_max;
            Real sdd_max;
            Real sdd;
            Real aux1[nout];
            Real aux2[nout];
            SIunits.Time Ta1;
            SIunits.Time Ta2;
            SIunits.Time Tv;
            SIunits.Time Te;
            Boolean noWphase;
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-80,78},{-80,-82}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,88},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,0},{82,0}}, color={192,192,192}),
              Polygon(
                points={{90,0},{68,8},{68,-8},{90,0}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(
                points={{-80,0},{-70,0},{-70,70},{-30,70},{-30,0},{20,0},{20,-70},{
                    60,-70},{60,0},{68,0}},
                color={0,0,0},
                thickness=0.25),
              Text(
                extent={{2,80},{80,20}},
                lineColor={192,192,192},
                textString="acc"),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="deltaq=%deltaq")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-80,78},{-80,-72}}, color={95,95,95}),
              Polygon(
                points={{-80,91},{-86,71},{-75,71},{-80,91},{-80,91}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,0},{82,0}}, color={95,95,95}),
              Polygon(
                points={{89,0},{68,5},{68,-5},{89,0}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(
                points={{-80,0},{-70,0},{-70,70},{-30,70},{-30,0},{20,0},{20,-70},{
                    60,-70},{60,0},{68,0}},
                color={0,0,255},
                thickness=0.5),
              Text(
                extent={{-73,95},{-16,80}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="acceleration"),
              Text(
                extent={{66,20},{88,8}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time")}),
              Documentation(info="<HTML>
<p>
The goal is to move as <b>fast</b> as possible along a distance
<b>deltaq</b>
under given <b>kinematical constraints</b>. The distance can be a positional or
angular range. In robotics such a movement is called <b>PTP</b> (Point-To-Point).
This source block generates the <b>acceleration</b> qdd of this signal
as output:
</p>

<p>
<img src=\"../Images/Blocks/Sources/KinematicPTP.png\">
</p>

<p>
After integrating the output two times, the position q is
obtained. The signal is constructed in such a way that it is not possible
to move faster, given the <b>maximally</b> allowed <b>velocity</b> qd_max and
the <b>maximally</b> allowed <b>acceleration</b> qdd_max.
</p>
<p>
If several distances are given (vector deltaq has more than 1 element),
an acceleration output vector is constructed such that all signals
are in the same periods in the acceleration, constant velocity
and deceleration phase. This means that only one of the signals
is at its limits whereas the others are sychnronized in such a way
that the end point is reached at the same time instant.
</p>

<p>
This element is useful to generate a reference signal for a controller
which controls a drive train or in combination with model
Modelica.Mechanics.Rotational.<b>Accelerate</b> to drive
a flange according to a given acceleration.
</p>

</HTML>
", revisions =   "<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>June 27, 2001</i>
       by Bernhard Bachmann.<br>
       Bug fixed that element is also correct if startTime is not zero.</li>
<li><i>Nov. 3, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Vectorized and moved from Rotational to Blocks.Sources.</li>
<li><i>June 29, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       realized.</li>
</ul>
</html>"));

          equation
            for i in 1:nout loop
              aux1[i] = p_deltaq[i]/p_qd_max[i];
              aux2[i] = p_deltaq[i]/p_qdd_max[i];
            end for;
            sd_max = 1/max(abs(aux1));
            sdd_max = 1/max(abs(aux2));

            Ta1 = sqrt(1/sdd_max);
            Ta2 = sd_max/sdd_max;
            noWphase = Ta2 >= Ta1;
            Tv = if noWphase then Ta1 else 1/sd_max;
            Te = if noWphase then Ta1 + Ta1 else Tv + Ta2;

            // path-acceleration
            sdd = if time < startTime then 0 else ((if noWphase then (if time < Ta1
               + startTime then sdd_max else (if time < Te + startTime then -
              sdd_max else 0)) else (if time < Ta2 + startTime then sdd_max else (
              if time < Tv + startTime then 0 else (if time < Te + startTime then -
              sdd_max else 0)))));

            // acceleration
            y = p_deltaq*sdd;
          end KinematicPTP;

      block KinematicPTP2
        "Move as fast as possible from start to end position within given kinematic constraints with output signals q, qd=der(q), qdd=der(qd)"
        import SI = Modelica.SIunits;
        parameter Real q_begin[:] = {0} "Start position";
        parameter Real q_end[:] "End position";
        parameter Real qd_max[:](final min=Modelica.Constants.small)
          "Maximum velocities der(q)";
        parameter Real qdd_max[:](final min=Modelica.Constants.small)
          "Maximum accelerations der(qd)";
        parameter Modelica.SIunits.Time startTime=0
          "Time instant at which movement starts";

        extends Modelica.Blocks.Interfaces.BlockIcon;
        final parameter Integer nout=max([size(q_begin, 1); size(q_end, 1); size(
            qd_max, 1); size(qdd_max, 1)])
          "Number of output signals (= dimension of q, qd, qdd, moving)";
        output Modelica.SIunits.Time endTime
          "Time instant at which movement stops";

        Modelica.Blocks.Interfaces.RealOutput q[nout]
          "Reference position of path planning" 
          annotation (Placement(transformation(extent={{100,70},{120,90}}, rotation=
                 0)));
        Modelica.Blocks.Interfaces.RealOutput qd[nout]
          "Reference speed of path planning" 
          annotation (Placement(transformation(extent={{100,20},{120,40}}, rotation=
                 0)));
        Modelica.Blocks.Interfaces.RealOutput qdd[nout]
          "Reference acceleration of path planning" 
          annotation (Placement(transformation(extent={{100,-40},{120,-20}},
                rotation=0)));
        Modelica.Blocks.Interfaces.BooleanOutput moving[nout]
          "= true, if end position not yet reached; = false, if end position reached or axis is completely at rest"
          annotation (Placement(transformation(extent={{100,-90},{120,-70}},
                rotation=0)));

        annotation (defaultComponentName="kinematicPTP",
          Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,78},{-80,-82}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,88},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,0},{17,0}}, color={192,192,192}),
              Line(
                points={{-80,0},{-70,0},{-70,70},{-50,70},{-50,0},{-15,0},{-15,-70},
                    {5,-70},{5,0},{18,0}},
                color={0,0,0},
                thickness=0.25),
              Text(
                extent={{34,96},{94,66}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid,
                textString="q"),
              Text(
                extent={{40,44},{96,14}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid,
                textString="qd"),
              Text(
                extent={{32,-18},{99,-44}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid,
                textString="qdd"),
              Text(
                extent={{-32,-74},{97,-96}},
                lineColor={0,0,0},
                fillColor={0,0,0},
                fillPattern=FillPattern.Solid,
                textString="moving")}),
          Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(points={{-80,78},{-80,-70}}, color={95,95,95}),
              Polygon(
                points={{-80,94},{-86,74},{-74,74},{-80,94},{-80,94}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,0},{82,0}}, color={95,95,95}),
              Polygon(
                points={{90,0},{68,6},{68,-6},{90,0}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(
                points={{-80,0},{-70,0},{-70,70},{-30,70},{-30,0},{20,0},{20,-70},{
                    60,-70},{60,0},{68,0}},
                color={0,0,255},
                thickness=0.5),
              Text(
                extent={{-72,96},{-15,81}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="acceleration"),
              Text(
                extent={{69,18},{91,6}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time")}),
          Documentation(info="<html>
<p>
The goal is to move as <b>fast</b> as possible from start position <b>q_begin</b>
to end position <b>q_end</b> 
under given <b>kinematical constraints</b>. The positions can be translational or
rotational definitions (i.e., q_begin/q_end is given). In robotics such a movement is called <b>PTP</b> (Point-To-Point).
This source block generates the <b>position</b> q(t), the
<b>speed</b> qd(t) = der(q), and the <b>acceleration</b> qdd = der(qd)
as output. The signals are constructed in such a way that it is not possible
to move faster, given the <b>maximally</b> allowed <b>velocity</b> qd_max and
the <b>maximally</b> allowed <b>acceleration</b> qdd_max:
</p>

<p>
<img src=\"../Images/Blocks/Sources/KinematicPTP2.png\">
</p>

<p>
If vectors q_begin/q_end have more than 1 element,
the output vectors are constructed such that all signals
are in the same periods in the acceleration, constant velocity
and deceleration phase. This means that only one of the signals
is at its limits whereas the others are sychnronized in such a way
that the end point is reached at the same time instant.
</p>

<p>
This element is useful to generate a reference signal for a controller
which controls, e.g., a drive train, or to drive
a flange according to a given acceleration.
</p>
 
</html>
",       revisions="<html>
<ul>
<li><i>March 24, 2007</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Non-standard Modelica function \"constrain(..)\" replaced by standard
       Modelica implementation (via internal function position()).<br>
       New output signal \"moving\" added.</li>
<li><i>June 27, 2001</i>
       by Bernhard Bachmann.<br>
       Bug fixed that element is also correct if startTime is not zero.</li>
<li><i>Nov. 3, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Vectorized and moved from Rotational to Blocks.Sources.</li>
<li><i>June 29, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       realized.</li>
</ul>
</html>"));
      protected
        parameter Real p_q_begin[nout]=(if size(q_begin, 1) == 1 then ones(nout)*
            q_begin[1] else q_begin);
        parameter Real p_q_end[nout]=(if size(q_end, 1) == 1 then ones(nout)*
            q_end[1] else q_end);
        parameter Real p_qd_max[nout]=(if size(qd_max, 1) == 1 then ones(nout)*
            qd_max[1] else qd_max);
        parameter Real p_qdd_max[nout]=(if size(qdd_max, 1) == 1 then ones(nout)*
            qdd_max[1] else qdd_max);
        parameter Real p_deltaq[nout]=p_q_end - p_q_begin;
        constant Real eps=10*Modelica.Constants.eps;
        Boolean motion_ref;
        Real sd_max_inv;
        Real sdd_max_inv;
        Real sd_max;
        Real sdd_max;
        Real sdd;
        Real aux1[nout];
        Real aux2[nout];
        SI.Time Ta1;
        SI.Time Ta2;
        SI.Time Tv;
        SI.Time Te;
        Boolean noWphase;
        SI.Time Ta1s;
        SI.Time Ta2s;
        SI.Time Tvs;
        SI.Time Tes;
        Real sd_max2;
        Real s1;
        Real s2;
        Real s3;
        Real s;
        Real sd;
        Real r_s;
        Real r_sd;
        Real r_sdd;

        function position
           input Real q_qd_qdd[3]
            "Required values for position, speed, acceleration";
           input Real dummy
            "Just to have one input signal that should be differentiated to avoid possible problems in the Modelica tool (is not used)";
           output Real q;
          annotation (derivative(noDerivative=q_qd_qdd) = position_der,
              __Dymola_InlineAfterIndexReduction=true);
        algorithm
          q :=q_qd_qdd[1];
        end position;

        function position_der
           input Real q_qd_qdd[3]
            "Required values for position, speed, acceleration";
           input Real dummy
            "Just to have one input signal that should be differentiated to avoid possible problems in the Modelica tool (is not used)";
           input Real dummy_der;
           output Real qd;
          annotation (derivative(noDerivative=q_qd_qdd) = position_der2,
              __Dymola_InlineAfterIndexReduction=true);
        algorithm
          qd :=q_qd_qdd[2];
        end position_der;

        function position_der2
           input Real q_qd_qdd[3]
            "Required values for position, speed, acceleration";
           input Real dummy
            "Just to have one input signal that should be differentiated to avoid possible problems in the Modelica tool (is not used)";
           input Real dummy_der;
           input Real dummy_der2;
           output Real qdd;
        algorithm
          qdd :=q_qd_qdd[3];
        end position_der2;
      equation
        for i in 1:nout loop
          aux1[i] = p_deltaq[i]/p_qd_max[i];
          aux2[i] = p_deltaq[i]/p_qdd_max[i];
        end for;

        sd_max_inv = max(abs(aux1));
        sdd_max_inv = max(abs(aux2));

        if sd_max_inv <= eps or sdd_max_inv <= eps then
          sd_max = 0;
          sdd_max = 0;
          Ta1 = 0;
          Ta2 = 0;
          noWphase = false;
          Tv = 0;
          Te = 0;
          Ta1s = 0;
          Ta2s = 0;
          Tvs = 0;
          Tes = 0;
          sd_max2 = 0;
          s1 = 0;
          s2 = 0;
          s3 = 0;
          r_sdd = 0;
          r_sd = 0;
          r_s = 0;
        else
          sd_max = 1/max(abs(aux1));
          sdd_max = 1/max(abs(aux2));
          Ta1 = sqrt(1/sdd_max);
          Ta2 = sd_max/sdd_max;
          noWphase = Ta2 >= Ta1;
          Tv = if noWphase then Ta1 else 1/sd_max;
          Te = if noWphase then Ta1 + Ta1 else Tv + Ta2;
          Ta1s = Ta1 + startTime;
          Ta2s = Ta2 + startTime;
          Tvs = Tv + startTime;
          Tes = Te + startTime;
          sd_max2 = sdd_max*Ta1;
          s1 = sdd_max*(if noWphase then Ta1*Ta1 else Ta2*Ta2)/2;
          s2 = s1 + (if noWphase then sd_max2*(Te - Ta1) - (sdd_max/2)*(Te - Ta1)
            ^2 else sd_max*(Tv - Ta2));
          s3 = s2 + sd_max*(Te - Tv) - (sdd_max/2)*(Te - Tv)*(Te - Tv);

          if time < startTime then
            r_sdd = 0;
            r_sd = 0;
            r_s = 0;
          elseif noWphase then
            if time < Ta1s then
              r_sdd = sdd_max;
              r_sd = sdd_max*(time - startTime);
              r_s = (sdd_max/2)*(time - startTime)*(time - startTime);
            elseif time < Tes then
              r_sdd = -sdd_max;
              r_sd = sd_max2 - sdd_max*(time - Ta1s);
              r_s = s1 + sd_max2*(time - Ta1s) - (sdd_max/2)*(time - Ta1s)*(time
                 - Ta1s);
            else
              r_sdd = 0;
              r_sd = 0;
              r_s = s2;
            end if;
          elseif time < Ta2s then
            r_sdd = sdd_max;
            r_sd = sdd_max*(time - startTime);
            r_s = (sdd_max/2)*(time - startTime)*(time - startTime);
          elseif time < Tvs then
            r_sdd = 0;
            r_sd = sd_max;
            r_s = s1 + sd_max*(time - Ta2s);
          elseif time < Tes then
            r_sdd = -sdd_max;
            r_sd = sd_max - sdd_max*(time - Tvs);
            r_s = s2 + sd_max*(time - Tvs) - (sdd_max/2)*(time - Tvs)*(time - Tvs);
          else
            r_sdd = 0;
            r_sd = 0;
            r_s = s3;
          end if;

        end if;

        // acceleration
        qdd = p_deltaq*sdd;
        qd = p_deltaq*sd;
        q = p_q_begin + p_deltaq*s;
        endTime = Tes;

        s = position({r_s, r_sd, r_sdd}, time);
        sd = der(s);
        sdd = der(sd);

        // report when axis is moving
        motion_ref = time <= endTime;
        for i in 1:nout loop
          moving[i] = if abs(q_begin[i] - q_end[i]) > eps then motion_ref else false;
        end for;

      end KinematicPTP2;

          block TimeTable
        "Generate a (possibly discontinuous) signal by linear interpolation in a table"

            parameter Real table[:, 2]
          "Table matrix (time = first column; e.g. table=[0, 0; 1, 1; 2, 4])";
            parameter Real offset=0 "Offset of output signal";
            parameter SIunits.Time startTime=0
          "Output = offset for time < startTime";
            extends Interfaces.SO;
      protected
            Real a "Interpolation coefficients a of actual interval (y=a*x+b)";
            Real b "Interpolation coefficients b of actual interval (y=a*x+b)";
            Integer last(start=1) "Last used lower grid index";
            SIunits.Time nextEvent(start=0, fixed=true) "Next event instant";
            annotation (
              Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-48,70},{2,-50}},
                lineColor={255,255,255},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-48,-50},{-48,70},{52,70},{52,-50},{-48,-50},{-48,-20},
                    {52,-20},{52,10},{-48,10},{-48,40},{52,40},{52,70},{2,70},{2,-51}},
                  color={0,0,0}),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="offset=%offset")}),
              Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Polygon(
                points={{-80,90},{-85,68},{-74,68},{-80,90}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
              Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
              Polygon(
                points={{88,-70},{68,-65},{68,-74},{88,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-20,90},{30,-30}},
                lineColor={255,255,255},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-20,-30},{-20,90},{80,90},{80,-30},{-20,-30},{-20,0},{
                    80,0},{80,30},{-20,30},{-20,60},{80,60},{80,90},{30,90},{30,-31}},
                  color={0,0,0}),
              Text(
                extent={{-70,-42},{-32,-54}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Polygon(
                points={{-31,-30},{-33,-40},{-28,-40},{-31,-30}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-31,-70},{-34,-60},{-29,-60},{-31,-70},{-31,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-31,-32},{-31,-70}}, color={95,95,95}),
              Line(points={{-20,-30},{-20,-70}}, color={95,95,95}),
              Text(
                extent={{-38,-73},{8,-83}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Line(points={{-20,-30},{-80,-30}}, color={95,95,95}),
              Text(
                extent={{-76,93},{-44,75}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y"),
              Text(
                extent={{66,-78},{90,-88}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Text(
                extent={{-15,83},{24,68}},
                lineColor={0,0,0},
                textString="time"),
              Text(
                extent={{33,83},{76,67}},
                lineColor={0,0,0},
                textString="y")}),
              Documentation(info="<HTML>
<p>
This block generates an output signal by <b>linear interpolation</b> in
a table. The time points and function values are stored in a matrix
<b>table[i,j]</b>, where the first column table[:,1] contains the
time points and the second column contains the data to be interpolated.
The table interpolation has the following proporties:
</p>
<ul>
<li>The time points need to be <b>monotonically increasing</b>. </li>
<li><b>Discontinuities</b> are allowed, by providing the same
    time point twice in the table. </li>
<li>Values <b>outside</b> of the table range, are computed by
    <b>extrapolation</b> through the last or first two points of the
    table.</li>
<li>If the table has only <b>one row</b>, no interpolation is performed and
    the function value is just returned independantly of the
    actual time instant.</li>
<li>Via parameters <b>startTime</b> and <b>offset</b> the curve defined
    by the table can be shifted both in time and in the ordinate value.
<li>The table is implemented in a numerically sound way by
    generating <b>time events</b> at interval boundaries,
    in order to not integrate over a discontinuous or not differentiable
    points.
</li>
</ul>
<p>
Example:
</p>
<pre>
   table = [0  0
            1  0
            1  1
            2  4
            3  9
            4 16]
If, e.g., time = 1.0, the output y =  0.0 (before event), 1.0 (after event)
    e.g., time = 1.5, the output y =  2.5,
    e.g., time = 2.0, the output y =  4.0,
    e.g., time = 5.0, the output y = 23.0 (i.e. extrapolation).
</pre>
 
 
<p>
<img src=\"../Images/Blocks/Sources/TimeTable.png\">
</p>
 
</HTML>
",           revisions=
                 "<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Oct. 21, 2002</i>
       by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       Corrected interface from
<pre>
    parameter Real table[:, :]=[0, 0; 1, 1; 2, 4];
</pre>
       to
<pre>
    parameter Real table[:, <b>2</b>]=[0, 0; 1, 1; 2, 4];
</pre>
       </li>
<li><i>Nov. 7, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized.</li>
</ul>
</html>"));

            function getInterpolationCoefficients
          "Determine interpolation coefficients and next time event"
              input Real table[:, 2] "Table for interpolation";
              input Real offset "y-offset";
              input Real startTime "time-offset";
              input Real t "Actual time instant";
              input Integer last "Last used lower grid index";
              input Real TimeEps
            "Relative epsilon to check for identical time instants";
              output Real a "Interpolation coefficients a (y=a*x + b)";
              output Real b "Interpolation coefficients b (y=a*x + b)";
              output Real nextEvent "Next event instant";
              output Integer next "New lower grid index";
        protected
              Integer columns=2 "Column to be interpolated";
              Integer ncol=2 "Number of columns to be interpolated";
              Integer nrow=size(table, 1) "Number of table rows";
              Integer next0;
              Real tp;
              Real dt;
            algorithm
              next := last;
              nextEvent := t - TimeEps*abs(t);
              // in case there are no more time events
              tp := t + TimeEps*abs(t) - startTime;

              if tp < 0.0 then
                // First event not yet reached
                nextEvent := startTime;
                a := 0;
                b := offset;
              elseif nrow < 2 then
                // Special action if table has only one row
                a := 0;
                b := offset + table[1, columns];
              else

                  // Find next time event instant. Note, that two consecutive time instants
                // in the table may be identical due to a discontinuous point.
                while next < nrow and tp >= table[next, 1] loop
                  next := next + 1;
                end while;

                // Define next time event, if last table entry not reached
                if next < nrow then
                  nextEvent := startTime + table[next, 1];
                end if;

                // Determine interpolation coefficients
                next0 := next - 1;
                dt := table[next, 1] - table[next0, 1];
                if dt <= TimeEps*abs(table[next, 1]) then
                  // Interpolation interval is not big enough, use "next" value
                  a := 0;
                  b := offset + table[next, columns];
                else
                  a := (table[next, columns] - table[next0, columns])/dt;
                  b := offset + table[next0, columns] - a*table[next0, 1];
                end if;
              end if;
              // Take into account startTime "a*(time - startTime) + b"
              b := b - a*startTime;
            end getInterpolationCoefficients;
          algorithm
            when {time >= pre(nextEvent),initial()} then
              (a,b,nextEvent,last) := getInterpolationCoefficients(table, offset,
                startTime, time, last, 100*Modelica.Constants.eps);
            end when;
          equation
            y = a*time + b;
          end TimeTable;

      model CombiTimeTable
        "Table look-up with respect to time and linear/perodic extrapolation methods (data from matrix/file)"

        parameter Boolean tableOnFile=false
          "= true, if table is defined on file or in function usertab" 
          annotation(Dialog(group="table data definition"));
        parameter Real table[:, :] = fill(0.0,0,2)
          "Table matrix (time = first column; e.g. table=[0,2])" 
             annotation(Dialog(group="table data definition", enable = not tableOnFile));
        parameter String tableName="NoName"
          "Table name on file or in function usertab (see docu)" 
             annotation(Dialog(group="table data definition", enable = tableOnFile));
        parameter String fileName="NoName" "File where matrix is stored" 
             annotation(Dialog(group="table data definition", enable = tableOnFile,
                               __Dymola_loadSelector(filter="Text files (*.txt);;Matlab files (*.mat)",
                               caption="Open file in which table is present")));
        parameter Integer columns[:]=2:size(table, 2)
          "Columns of table to be interpolated" 
        annotation(Dialog(group="table data interpretation"));
        parameter Modelica.Blocks.Types.Smoothness smoothness=Modelica.Blocks.Types.Smoothness.LinearSegments
          "Smoothness of table interpolation" 
        annotation(Dialog(group="table data interpretation"));
        parameter Modelica.Blocks.Types.Extrapolation extrapolation=Modelica.Blocks.Types.Extrapolation.LastTwoPoints
          "Extrapolation of data outside the definition range" 
        annotation(Dialog(group="table data interpretation"));
        parameter Real offset[:]={0} "Offsets of output signals" 
        annotation(Dialog(group="table data interpretation"));
        parameter Modelica.SIunits.Time startTime=0
          "Output = offset for time < startTime" 
        annotation(Dialog(group="table data interpretation"));
        extends Modelica.Blocks.Interfaces.MO(final nout=max([size(columns, 1); size(offset, 1)]));
        final parameter Real t_min(fixed=false)
          "Minimum abscissa value defined in table";
        final parameter Real t_max(fixed=false)
          "Maximum abscissa value defined in table";

        annotation (
          Documentation(info="<HTML>
<p>
This block generates an output signal y[:] by <b>linear interpolation</b> in
a table. The time points and function values are stored in a matrix
<b>table[i,j]</b>, where the first column table[:,1] contains the
time points and the other columns contain the data to be interpolated.
</p>
 
<p>
<img src=\"../Images/Blocks/Sources/CombiTimeTable.png\">
</p>
 
<p>
Via parameter <b>columns</b> it can be defined which columns of the
table are interpolated. If, e.g., columns={2,4}, it is assumed that
2 output signals are present and that the first output is computed
by interpolation of column 2 and the second output is computed
by interpolation of column 4 of the table matrix.
The table interpolation has the following properties:
</p>
<ul>
<li>The time points need to be <b>monotonically increasing</b>. </li>
<li><b>Discontinuities</b> are allowed, by providing the same
    time point twice in the table. </li>
<li>Values <b>outside</b> of the table range, are computed by
    extrapolation according to the setting of parameter
    <b>extrapolation</b>:
<pre>
  extrapolation = 0: hold the first or last value of the table,
                     if outside of the range.
                = 1: extrapolate through the last or first two
                     points of the table.
                = 2: periodically repeat the table data
                     (periodical function).
</pre></li>
<li>Via parameter <b>smoothness</b> it is defined how the data is interpolated:
<pre>
  smoothness = 0: linear interpolation
             = 1: smooth interpolation with Akima Splines such
                  that der(y) is continuous.
</pre></li>
<li>If the table has only <b>one row</b>, no interpolation is performed and
    the table values of this row are just returned.</li>
<li>Via parameters <b>startTime</b> and <b>offset</b> the curve defined
    by the table can be shifted both in time and in the ordinate value.
    The time instants stored in the table are therefore <b>relative</b>
    to <b>startTime</b>.
    If time &lt; startTime, no interpolation is performed and the offset
    is used as ordinate value for all outputs.
<li>The table is implemented in a numerically sound way by
    generating <b>time events</b> at interval boundaries,
    in order to not integrate over a discontinuous or not differentiable
    points.
<li>For special applications it is sometimes needed to know the minimum
    and maximum time instant defined in the table as a parameter. For this
    reason parameters <b>t_min</b> and <b>t_max</b> are provided and can be access from
    the outside of the table object.
</li>
</ul>
<p>
Example:
</p>
<pre>
   table = [0  0
            1  0
            1  1
            2  4
            3  9
            4 16]; extrapolation = 1 (default)
If, e.g., time = 1.0, the output y =  0.0 (before event), 1.0 (after event)
    e.g., time = 1.5, the output y =  2.5,
    e.g., time = 2.0, the output y =  4.0,
    e.g., time = 5.0, the output y = 23.0 (i.e. extrapolation via last 2 points).
</pre>
<p>
The table matrix can be defined in the following ways:
</p>
<ol>
<li> Explicitly supplied as <b>parameter matrix</b> \"table\",
     and the other parameters have the following values:
<pre>
   tableName is \"NoName\" or has only blanks,
   fileName  is \"NoName\" or has only blanks.
</pre></li>
<li> <b>Read</b> from a <b>file</b> \"fileName\" where the matrix is stored as
      \"tableName\". Both ASCII and binary file format is possible.
      (the ASCII format is described below).
      It is most convenient to generate the binary file from Matlab
      (Matlab 4 storage format), e.g., by command
<pre>
   save tables.mat tab1 tab2 tab3 -V4
</pre>
      when the three tables tab1, tab2, tab3 should be
      used from the model.</li>
<li>  Statically stored in function \"usertab\" in file \"usertab.c\".
      The matrix is identified by \"tableName\". Parameter
      fileName = \"NoName\" or has only blanks.</li>
</ol>
<p>
Table definition methods (1) and (3) do <b>not</b> allocate dynamic memory,
and do not access files, whereas method (2) does. Therefore (1) and (3)
are suited for hardware-in-the-loop simulation (e.g. with dSpace hardware).
When the constant \"NO_FILE\" is defined in \"usertab.c\", all parts of the
source code of method (2) are removed by the C-preprocessor, such that
no dynamic memory allocation and no access to files takes place.
</p>
<p>
If tables are read from an ASCII-file, the file need to have the
following structure (\"-----\" is not part of the file content):
</p>
<pre>
-----------------------------------------------------
#1
double tab1(6,2)   # comment line
  0   0
  1   0
  1   1
  2   4
  3   9
  4  16
double tab2(6,2)   # another comment line
  0   0
  2   0
  2   2
  4   8
  6  18
  8  32
-----------------------------------------------------
</pre>
<p>
Note, that the first two characters in the file need to be
\"#1\". Afterwards, the corresponding matrix has to be declared
with type, name and actual dimensions. Finally, in successive
rows of the file, the elements of the matrix have to be given.
Several matrices may be defined one after another.
</p>
 
</HTML>
",     revisions="<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>March 31, 2001</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Used CombiTableTime as a basis and added the
       arguments <b>extrapolation, columns, startTime</b>.
       This allows periodic function definitions. </li>
</ul>
</html>"),Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-48,70},{2,-50}},
                lineColor={255,255,255},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Line(points={{-48,-50},{-48,70},{52,70},{52,-50},{-48,-50},{-48,-20},
                    {52,-20},{52,10},{-48,10},{-48,40},{52,40},{52,70},{2,70},{2,-51}},
                  color={0,0,0})}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
              Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-20,90},{20,-30}},
                lineColor={255,255,255},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-20,-30},{-20,90},{80,90},{80,-30},{-20,-30},{-20,0},{
                    80,0},{80,30},{-20,30},{-20,60},{80,60},{80,90},{20,90},{20,-30}},
                  color={0,0,0}),
              Text(
                extent={{-71,-42},{-32,-54}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Polygon(
                points={{-31,-30},{-33,-40},{-28,-40},{-31,-30}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-31,-70},{-34,-60},{-29,-60},{-31,-70},{-31,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-31,-31},{-31,-70}}, color={95,95,95}),
              Line(points={{-20,-30},{-20,-70}}, color={95,95,95}),
              Text(
                extent={{-42,-74},{6,-84}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Line(points={{-20,-30},{-80,-30}}, color={95,95,95}),
              Text(
                extent={{-73,93},{-44,74}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y"),
              Text(
                extent={{66,-81},{92,-92}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Text(
                extent={{-19,83},{20,68}},
                lineColor={0,0,0},
                textString="time"),
              Text(
                extent={{21,82},{50,68}},
                lineColor={0,0,0},
                textString="y[1]"),
              Line(points={{50,90},{50,-30}}, color={0,0,0}),
              Line(points={{80,0},{100,0}}, color={0,0,255}),
              Text(
                extent={{34,-30},{71,-42}},
                textString="columns",
                lineColor={0,0,255}),
              Text(
                extent={{51,82},{80,68}},
                lineColor={0,0,0},
                textString="y[2]")}));
      protected
        final parameter Real p_offset[nout]=(if size(offset, 1) == 1 then ones(nout)
             *offset[1] else offset);

        Integer tableID;

        function tableTimeInit
          input String tableName;
          input String fileName;
          input Real table[ :, :];
          input Real startTime;
          input Modelica.Blocks.Types.Smoothness smoothness;
          input Modelica.Blocks.Types.Extrapolation extrapolation;
          output Integer tableID;
        external "C" tableID = ModelicaTables_CombiTimeTable_init(
                       tableName, fileName, table, size(table, 1), size(table, 2),
                       startTime, smoothness, extrapolation);
          annotation(Library="ModelicaExternalC");
        end tableTimeInit;

        function tableTimeIpo
          input Integer tableID;
          input Integer icol;
          input Real timeIn;
          output Real value;
        external "C" value = 
                           ModelicaTables_CombiTimeTable_interpolate(tableID, icol, timeIn);
          annotation(Library="ModelicaExternalC");
        end tableTimeIpo;

        function tableTimeTmin
          input Integer tableID;
          output Real Tmin "minimum time value in table";
        external "C" Tmin = 
                          ModelicaTables_CombiTimeTable_minimumTime(tableID);
          annotation(Library="ModelicaExternalC");
        end tableTimeTmin;

        function tableTimeTmax
          input Integer tableID;
          output Real Tmax "maximum time value in table";
        external "C" Tmax = 
                          ModelicaTables_CombiTimeTable_maximumTime(tableID);
          annotation(Library="ModelicaExternalC");
        end tableTimeTmax;

      equation
        if tableOnFile then
          assert(tableName<>"NoName", "tableOnFile = true and no table name given");
        end if;
        if not tableOnFile then
          assert(size(table,1) > 0 and size(table,2) > 0, "tableOnFile = false and parameter table is an empty matrix");
        end if;
        for i in 1:nout loop
          y[i] = p_offset[i] + tableTimeIpo(tableID, columns[i], time);
        end for;
        when initial() then
          tableID=tableTimeInit((if not tableOnFile then "NoName" else tableName),
                                (if not tableOnFile then "NoName" else fileName), table,
                                startTime, smoothness, extrapolation);
        end when;
      initial equation
          t_min=tableTimeTmin(tableID);
          t_max=tableTimeTmax(tableID);
      end CombiTimeTable;

        block BooleanConstant "Generate constant signal of type Boolean"
          parameter Boolean k=true "Constant output value";
          extends Interfaces.partialBooleanSource;
          annotation (
            Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={Line(points={{-80,0},{80,0}}, color={0,0,0}),
                Text(
                extent={{-150,-140},{150,-110}},
                lineColor={0,0,0},
                textString="%k")}),
            Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={2,2}), graphics={
              Line(
                points={{-70,0},{80,0}},
                color={0,0,255},
                thickness=0.5),
              Text(
                extent={{-69,20},{-49,0}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="k"),
              Text(
                extent={{-96,6},{-76,-4}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="true"),
              Text(
                extent={{-98,-58},{-72,-68}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="false")}),
            Documentation(info="<html>
<p>
The Boolean output y is a constant signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/BooleanConstant.png\">
</p>
</html>"));

        equation
          y = k;
        end BooleanConstant;

        block BooleanStep "Generate step signal of type Boolean"
          parameter Modelica.SIunits.Time startTime=0
          "Time instant of step start";
          parameter Boolean startValue = false "Output before startTime";

          extends Interfaces.partialBooleanSource;
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={Line(points={{-80,-70},{0,-70},{0,50},
                    {80,50}}, color={0,0,0}), Text(
                extent={{-150,-140},{150,-110}},
                lineColor={0,0,0},
                textString="%startTime")}),
                                  Diagram(coordinateSystem(preserveAspectRatio=
                  false, extent={{-100,-100},{100,100}}), graphics={
              Line(
                points={{-80,-70},{0,-70},{0,50},{80,50}},
                color={0,0,255},
                thickness=0.5),
              Text(
                extent={{-15,-74},{20,-82}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Polygon(
                points={{2,50},{-80,50},{2,50}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-66,62},{-22,48}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="not startValue"),
              Text(
                extent={{-68,-58},{-36,-72}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startValue")}),
            Documentation(info="<html>
<p>
The Boolean output y is a step signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/BooleanStep.png\">
</p>
</html>"));
        equation
         y = if time >= startTime then not startValue else startValue;
        end BooleanStep;

        block BooleanPulse "Generate pulse signal of type Boolean"

          parameter Real width(
            final min=Modelica.Constants.small,
            final max=100) = 50 "Width of pulse in % of period";
          parameter Modelica.SIunits.Time period(final min=Modelica.Constants.small,start=1)
          "Time for one period";
          parameter Modelica.SIunits.Time startTime=0
          "Time instant of first pulse";
          extends Modelica.Blocks.Interfaces.partialBooleanSource;
          annotation (
            Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={Text(
                extent={{-150,-140},{150,-110}},
                lineColor={0,0,0},
                textString="%period"), Line(points={{-80,-70},{-40,-70},{-40,44},{0,
                    44},{0,-70},{40,-70},{40,44},{79,44}}, color={0,0,0})}),
            Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Text(
                extent={{-60,-74},{-19,-82}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Line(
                points={{-78,-70},{-40,-70},{-40,20},{20,20},{20,-70},{50,-70},{50,
                    20},{100,20}},
                color={0,0,255},
                thickness=0.5),
              Line(points={{-40,61},{-40,21}}, color={95,95,95}),
              Line(points={{20,44},{20,20}}, color={95,95,95}),
              Line(points={{50,58},{50,20}}, color={95,95,95}),
              Line(points={{-40,53},{50,53}}, color={95,95,95}),
              Line(points={{-40,35},{20,35}}, color={95,95,95}),
              Text(
                extent={{-30,65},{16,55}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="period"),
              Text(
                extent={{-33,47},{14,37}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="width"),
              Line(points={{-70,20},{-41,20}}, color={95,95,95}),
              Polygon(
                points={{-40,35},{-31,37},{-31,33},{-40,35}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{20,35},{12,37},{12,33},{20,35}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-40,53},{-31,55},{-31,51},{-40,53}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{50,53},{42,55},{42,51},{50,53}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-95,26},{-66,17}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="true"),
              Text(
                extent={{-96,-60},{-75,-69}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="false")}),
            Documentation(info="<html>
<p>
The Boolean output y is a pulse signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/Pulse.png\">
</p>
</html>"));

      protected
          parameter Modelica.SIunits.Time Twidth=period*width/100
          "width of one pulse"                                              annotation(HideResult=true);
          discrete Modelica.SIunits.Time pulsStart "Start time of pulse" 
                                                     annotation(HideResult=true);
        initial equation
          pulsStart = startTime;
        equation
            when sample(startTime, period) then
              pulsStart = time;
            end when;
            y = time >= pulsStart and time < pulsStart + Twidth;
        end BooleanPulse;

        block SampleTrigger "Generate sample trigger signal"
          parameter Modelica.SIunits.Time period(final min=Modelica.Constants.small,start=0.01)
          "Sample period";
          parameter Modelica.SIunits.Time startTime=0
          "Time instant of first sample trigger";
          extends Interfaces.partialBooleanSource;

          annotation (
            Icon(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Line(points={{-60,-70},{-60,70}}, color={0,0,0}),
              Line(points={{-20,-70},{-20,70}}, color={0,0,0}),
              Line(points={{20,-70},{20,70}}, color={0,0,0}),
              Line(points={{60,-70},{60,70}}, color={0,0,0}),
              Text(
                extent={{-150,-140},{150,-110}},
                lineColor={0,0,0},
                textString="%period")}),
            Diagram(coordinateSystem(
              preserveAspectRatio=true,
              extent={{-100,-100},{100,100}},
              grid={1,1}), graphics={
              Text(
                extent={{-51,-72},{-11,-81}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Line(points={{-30,47},{-30,19}}, color={95,95,95}),
              Line(points={{0,47},{0,18}}, color={95,95,95}),
              Line(points={{-30,41},{0,41}}, color={95,95,95}),
              Text(
                extent={{-37,61},{9,49}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="period"),
              Line(points={{-73,19},{-30,19}}, color={95,95,95}),
              Polygon(
                points={{-30,41},{-21,43},{-21,39},{-30,41}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{0,41},{-8,43},{-8,39},{0,41}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-91,23},{-71,13}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="true"),
              Text(
                extent={{-90,-59},{-70,-68}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="false"),
              Line(
                points={{0,-70},{0,19}},
                color={0,0,255},
                thickness=0.5),
              Line(
                points={{-30,-70},{-30,19}},
                color={0,0,255},
                thickness=0.5),
              Line(
                points={{30,-70},{30,19}},
                color={0,0,255},
                thickness=0.5),
              Line(
                points={{60,-70},{60,19}},
                color={0,0,255},
                thickness=0.5)}),
            Documentation(info="<html>
<p>
The Boolean output y is a trigger signal where the output y is only <b>true</b>
at sample times (defined by parameter <b>period</b>) and is otherwise
<b>false</b>.
</p>

<p>
<img src=\"../Images/Blocks/Sources/SampleTrigger.png\">
</p>
</html>"));

        equation
          y = sample(startTime, period);
        end SampleTrigger;

        block BooleanTable
        "Generate a Boolean output signal based on a vector of time instants"

          parameter Boolean startValue = false
          "Start value of y. At time = table[1], y changes to 'not startValue'";
          parameter Modelica.SIunits.Time table[:]
          "Vector of time points. At every time point, the output y gets its opposite value (e.g. table={0,1})";
          extends Interfaces.partialBooleanSource;
          annotation (
            Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={Rectangle(
                extent={{-18,70},{32,-50}},
                lineColor={255,255,255},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid), Line(points={{-18,-50},{-18,70},{32,
                    70},{32,-50},{-18,-50},{-18,-20},{32,-20},{32,10},{-18,10},{-18,
                    40},{32,40},{32,70},{32,70},{32,-51}}, color={0,0,0})}),
            Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                  {100,100}}), graphics={
              Rectangle(
                extent={{-34,66},{16,-54}},
                lineColor={255,255,255},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-34,-54},{-34,66},{16,66},{16,-54},{-34,-54},{-34,-24},
                    {16,-24},{16,6},{-34,6},{-34,36},{16,36},{16,66},{16,66},{16,-55}},
                  color={0,0,0}),
              Text(
                extent={{-29,59},{10,44}},
                lineColor={0,0,0},
                textString="time")}),
            Documentation(info="<html>
<p>
The Boolean output y is a signal defined by parameter vector <b>table</b>.
In the vector time points are stored. At every time point, the output y
changes its value to the negated value of the previous one.
</p>

<p>
<img src=\"../Images/Blocks/Sources/BooleanTable.png\">
</p>
</html>"));

      protected
          function getFirstIndex "Get first index of table and check table"
            input Real table[:] "Vector of time instants";
            input Modelica.SIunits.Time simulationStartTime
            "Simulation start time";
            input Boolean startValue "Value of y for y < table[1]";
            output Integer index "First index to be used";
            output Modelica.SIunits.Time nextTime "Time instant of first event";
            output Boolean y "Value of y at simulationStartTime";
        protected
            Modelica.SIunits.Time t_last;
            Integer j;
            Integer n=size(table,1) "Number of table points";
          algorithm
            if size(table,1) == 0 then
               index :=0;
               nextTime :=-Modelica.Constants.inf;
               y :=startValue;
            elseif size(table,1) == 1 then
               index :=1;
               if table[1] > simulationStartTime then
                  nextTime :=table[1];
                  y        :=startValue;
               else
                  nextTime :=simulationStartTime;
                  y        :=startValue;
               end if;
            else

            // Check whether time values are strict monotonically increasing
              t_last :=table[1];
              for i in 2:n loop
                 assert(table[i] > t_last,
                   "Time values of table not strict monotonically increasing: table[" +
                   String(i-1) + "] = " + String(table[i-1]) + "table[" + String(i)   +
                   "] = " + String(table[i]));
              end for;

              // Determine first index in table
              j := 1;
              y := startValue;
              while j < n and table[j] <= simulationStartTime loop
                y :=not  y;
                j := j + 1;
              end while;

              if j == 1 then
                 nextTime := table[1];
                 y        := startValue;
              elseif j == n and table[n] <= simulationStartTime then
                 nextTime := simulationStartTime - 1;
                 y        :=not  y;
              else
                 nextTime := table[j];
              end if;

              index := j;
            end if;
          end getFirstIndex;

          parameter Integer n = size(table,1) "Number of table points";
          Modelica.SIunits.Time nextTime;
          Integer index "Index of actual table entry";
        initial algorithm
          (index, nextTime, y) :=getFirstIndex(table, time, startValue);
        algorithm
          when time >= pre(nextTime) and n > 0 then
             if index < n then
                index    := index + 1;
                nextTime := table[index];
                y        :=not  y;
             elseif index == n then
                index := index + 1;
                y     :=not  y;
             end if;
          end when;
        end BooleanTable;

      block IntegerConstant "Generate constant signal of type Integer"
        parameter Integer k(start=1) "Constant output value";
        extends Interfaces.IntegerSO;

        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,0},{80,0}}, color={0,0,0}),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="k=%k")}),
                                Diagram(coordinateSystem(preserveAspectRatio=true,
                extent={{-100,-100},{100,100}}), graphics={
              Polygon(
                points={{-80,90},{-86,68},{-74,68},{-80,90}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
              Line(
                points={{-80,0},{80,0}},
                color={0,0,255},
                thickness=0.5),
              Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-81,92},{-38,74}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y"),
              Text(
                extent={{66,-82},{94,-94}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Text(
                extent={{-101,8},{-81,-12}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="k")}),
          Documentation(info="<html>
<p>
The Integer output y is a constant signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/IntegerConstant.png\">
</p>
</html>"));
      equation
        y = k;
      end IntegerConstant;

      block IntegerStep "Generate step signal of type Integer"
        parameter Integer height=1 "Height of step";
        extends Interfaces.IntegerSignalSource;
        annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                  -100},{100,100}}), graphics={
              Line(points={{-80,68},{-80,-80}}, color={192,192,192}),
              Polygon(
                points={{-80,90},{-88,68},{-72,68},{-80,90}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-90,-70},{82,-70}}, color={192,192,192}),
              Polygon(
                points={{90,-70},{68,-62},{68,-78},{90,-70}},
                lineColor={192,192,192},
                fillColor={192,192,192},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,-70},{0,-70},{0,50},{80,50}}, color={0,0,0}),
              Text(
                extent={{-150,-150},{150,-110}},
                lineColor={0,0,0},
                textString="startTime=%startTime")}),
                                Diagram(coordinateSystem(preserveAspectRatio=true,
                extent={{-100,-100},{100,100}}), graphics={
              Polygon(
                points={{-80,88},{-86,68},{-74,68},{-80,88}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-80,68},{-80,-80}}, color={95,95,95}),
              Line(
                points={{-80,-18},{0,-18},{0,50},{80,50}},
                color={0,0,255},
                thickness=0.5),
              Line(points={{-90,-70},{82,-70}}, color={95,95,95}),
              Polygon(
                points={{90,-70},{70,-66},{70,-74},{90,-70}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{66,-78},{92,-88}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="time"),
              Text(
                extent={{-21,-76},{26,-88}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="startTime"),
              Line(points={{0,-17},{0,-71}}, color={95,95,95}),
              Text(
                extent={{-60,-36},{-12,-48}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="offset"),
              Line(points={{-13,50},{-13,-17}}, color={95,95,95}),
              Polygon(
                points={{2,50},{-19,50},{2,50}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-13,-17},{-16,-4},{-10,-4},{-13,-17},{-13,-17}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Polygon(
                points={{-13,50},{-16,37},{-9,37},{-13,50}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-58,22},{-12,10}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="height"),
              Polygon(
                points={{-13,-69},{-16,-56},{-10,-56},{-13,-69},{-13,-69}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Line(points={{-13,-18},{-13,-70}}, color={95,95,95}),
              Polygon(
                points={{-13,-18},{-16,-31},{-9,-31},{-13,-18}},
                lineColor={95,95,95},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-78,96},{-44,80}},
                lineColor={0,0,0},
                fillColor={95,95,95},
                fillPattern=FillPattern.Solid,
                textString="y")}),
          Documentation(info="<html>
<p>
The Integer output y is a step signal:
</p>

<p>
<img src=\"../Images/Blocks/Sources/IntegerStep.png\">
</p>
</html>"));
      equation
        y = offset + (if time < startTime then 0 else height);
      end IntegerStep;

    end Sources;

    package Tables
      "Library of blocks to interpolate in one and two-dimensional tables"
      extends Modelica.Icons.Library;
      model CombiTable1D
        "Table look-up in one dimension (matrix/file) with n inputs and n outputs "
        import Modelica.Blocks.Types;
        parameter Boolean tableOnFile=false
          "true, if table is defined on file or in function usertab" 
          annotation(Dialog(group="table data definition"));
        parameter Real table[:, :]=fill(0.0,0,2)
          "table matrix (grid = first column; e.g., table=[0,2])" 
             annotation(Dialog(group="table data definition", enable = not tableOnFile));
        parameter String tableName="NoName"
          "table name on file or in function usertab (see docu)" 
             annotation(Dialog(group="table data definition", enable = tableOnFile));
        parameter String fileName="NoName" "file where matrix is stored" 
             annotation(Dialog(group="table data definition", enable = tableOnFile,
                               __Dymola_loadSelector(filter="Text files (*.txt);;Matlab files (*.mat)",
                               caption="Open file in which table is present")));
        parameter Integer columns[:]=2:size(table, 2)
          "columns of table to be interpolated" 
        annotation(Dialog(group="table data interpretation"));
        parameter Modelica.Blocks.Types.Smoothness smoothness=Types.Smoothness.LinearSegments
          "smoothness of table interpolation" 
        annotation(Dialog(group="table data interpretation"));
        extends Modelica.Blocks.Interfaces.MIMOs(final n=size(columns, 1));
        annotation (
          Documentation(info="<html>
<p>
<b>Linear interpolation</b> in <b>one</b> dimension of a <b>table</b>.
Via parameter <b>columns</b> it can be defined how many columns of the
table are interpolated. If, e.g., columns={2,4}, it is assumed that 2 input
and 2 output signals are present and that the first output interpolates
the first input via column 2 and the second output interpolates the
second input via column 4 of the table matrix.
</p>
<p>
The grid points and function values are stored in a matrix \"table[i,j]\",
where the first column \"table[:,1]\" contains the grid points and the
other columns contain the data to be interpolated. Example:
</p>
<pre>
   table = [0,  0;
            1,  1;
            2,  4;
            4, 16]
   If, e.g., the input u = 1.0, the output y =  1.0,
       e.g., the input u = 1.5, the output y =  2.5,
       e.g., the input u = 2.0, the output y =  4.0,
       e.g., the input u =-1.0, the output y = -1.0 (i.e. extrapolation).
</pre>
<ul>
<li> The interpolation is <b>efficient</b>, because a search for a new interpolation
     starts at the interval used in the last call.</li>
<li> If the table has only <b>one row</b>, the table value is returned,
     independent of the value of the input signal.</li>
<li> If the input signal <b>u[i]</b> is <b>outside</b> of the defined <b>interval</b>, i.e.,
     u[i] &gt; table[size(table,1),i+1] or u[i] &lt; table[1,1], the corresponding
     value is also determined by linear
     interpolation through the last or first two points of the table.</li>
<li> The grid values (first column) have to be <b>strict</b>
     monotonically increasing.</li>
</ul>
<p>
The table matrix can be defined in the following ways:
</p>
<ol>
<li> Explicitly supplied as <b>parameter matrix</b> \"table\",
     and the other parameters have the following values:
<pre>
   tableName is \"NoName\" or has only blanks,
   fileName  is \"NoName\" or has only blanks.
</pre></li>
<li> <b>Read</b> from a <b>file</b> \"fileName\" where the matrix is stored as
      \"tableName\". Both ASCII and binary file format is possible.
      (the ASCII format is described below).
      It is most convenient to generate the binary file from Matlab
      (Matlab 4 storage format), e.g., by command
<pre>
   save tables.mat tab1 tab2 tab3 -V4
</pre>
      when the three tables tab1, tab2, tab3 should be
      used from the model.</li>
<li>  Statically stored in function \"usertab\" in file \"usertab.c\".
      The matrix is identified by \"tableName\". Parameter
      fileName = \"NoName\" or has only blanks.</li>
</ol>
<p>
Table definition methods (1) and (3) do <b>not</b> allocate dynamic memory,
and do not access files, whereas method (2) does. Therefore (1) and (3)
are suited for hardware-in-the-loop simulation (e.g. with dSpace hardware).
When the constant \"NO_FILE\" is defined in \"usertab.c\", all parts of the
source code of method (2) are removed by the C-preprocessor, such that
no dynamic memory allocation and no access to files takes place.
</p>
<p>
If tables are read from an ASCII-file, the file need to have the
following structure (\"-----\" is not part of the file content):
</p>
<pre>
-----------------------------------------------------
#1
double tab1(5,2)   # comment line
  0   0
  1   1
  2   4
  3   9
  4  16
double tab2(5,2)   # another comment line
  0   0
  2   2
  4   8
  6  18
  8  32
-----------------------------------------------------
</pre>
<p>
Note, that the first two characters in the file need to be
\"#1\". Afterwards, the corresponding matrix has to be declared
with type, name and actual dimensions. Finally, in successive
rows of the file, the elements of the matrix have to be given.
Several matrices may be defined one after another.
</p>
</HTML>
"),       Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Line(points={{-60,40},{-60,-40},{60,-40},{60,40},{30,40},{30,-40},{-30,
                    -40},{-30,40},{-60,40},{-60,20},{60,20},{60,0},{-60,0},{-60,-20},
                    {60,-20},{60,-40},{-60,-40},{-60,40},{60,40},{60,-40}}, color={
                    0,0,0}),
              Line(points={{0,40},{0,-40}}, color={0,0,0}),
              Rectangle(
                extent={{-60,40},{-30,20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-60,20},{-30,0}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-60,0},{-30,-20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-60,-20},{-30,-40}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Rectangle(
                extent={{-60,60},{60,-60}},
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Line(points={{-100,0},{-58,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255}),
              Text(
                extent={{-100,100},{100,64}},
                textString="1 dimensional linear table interpolation",
                lineColor={0,0,255}),
              Line(points={{-54,40},{-54,-40},{54,-40},{54,40},{28,40},{28,-40},{-28,
                    -40},{-28,40},{-54,40},{-54,20},{54,20},{54,0},{-54,0},{-54,-20},
                    {54,-20},{54,-40},{-54,-40},{-54,40},{54,40},{54,-40}}, color={
                    0,0,0}),
              Line(points={{0,40},{0,-40}}, color={0,0,0}),
              Rectangle(
                extent={{-54,40},{-28,20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-54,20},{-28,0}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-54,0},{-28,-20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-54,-20},{-28,-40}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-50,54},{-32,42}},
                textString="u[1]/[2]",
                lineColor={0,0,255}),
              Text(
                extent={{-24,54},{0,42}},
                textString="y[1]",
                lineColor={0,0,255}),
              Text(
                extent={{-2,-40},{30,-54}},
                textString="columns",
                lineColor={0,0,255}),
              Text(
                extent={{2,54},{26,42}},
                textString="y[2]",
                lineColor={0,0,255})}));

      protected
        Integer tableID;

        function tableInit
          input String tableName;
          input String fileName;
          input Real table[ :, :];
          input Modelica.Blocks.Types.Smoothness smoothness;
          output Integer tableID;
        external "C" tableID = ModelicaTables_CombiTable1D_init(
                       tableName, fileName, table, size(table, 1), size(table, 2),
                       smoothness);
          annotation(Library="ModelicaExternalC");
        end tableInit;

        function tableIpo
          input Integer tableID;
          input Integer icol;
          input Real u;
          output Real value;
        external "C" value = 
                           ModelicaTables_CombiTable1D_interpolate(tableID, icol, u);
          annotation(Library="ModelicaExternalC");
        end tableIpo;
      equation
        if tableOnFile then
          assert(tableName<>"NoName", "tableOnFile = true and no table name given");
        end if;
        if not tableOnFile then
          assert(size(table,1) > 0 and size(table,2) > 0, "tableOnFile = false and parameter table is an empty matrix");
        end if;

        for i in 1:n loop
          y[i] = if not tableOnFile and size(table,1)==1 then 
                   table[1, columns[i]] else tableIpo(tableID, columns[i], u[i]);
        end for;
        when initial() then
          tableID=tableInit(if tableOnFile then tableName else "NoName",
                            if tableOnFile then fileName else "NoName", table, smoothness);
        end when;
      end CombiTable1D;

      model CombiTable1Ds
        "Table look-up in one dimension (matrix/file) with one input and n outputs"

        import Modelica.Blocks.Types;
        parameter Boolean tableOnFile=false
          "true, if table is defined on file or in function usertab" 
          annotation(Dialog(group="table data definition"));
        parameter Real table[:, :]=fill(0.0,0,2)
          "table matrix (grid = first column; e.g., table=[0,2])" 
             annotation(Dialog(group="table data definition", enable = not tableOnFile));
        parameter String tableName="NoName"
          "table name on file or in function usertab (see docu)" 
             annotation(Dialog(group="table data definition", enable = tableOnFile));
        parameter String fileName="NoName" "file where matrix is stored" 
             annotation(Dialog(group="table data definition", enable = tableOnFile,
                               __Dymola_loadSelector(filter="Text files (*.txt);;Matlab files (*.mat)",
                               caption="Open file in which table is present")));
        parameter Integer columns[:]=2:size(table, 2)
          "columns of table to be interpolated" 
        annotation(Dialog(group="table data interpretation"));
        parameter Modelica.Blocks.Types.Smoothness smoothness=Types.Smoothness.LinearSegments
          "smoothness of table interpolation" 
        annotation(Dialog(group="table data interpretation"));
        extends Modelica.Blocks.Interfaces.SIMO(final nout=size(columns, 1));
        annotation (
          Documentation(info="<html>
<p>
<b>Linear interpolation</b> in <b>one</b> dimension of a <b>table</b>.
Via parameter <b>columns</b> it can be defined how many columns of the
table are interpolated. If, e.g., icol={2,4}, it is assumed that one input
and 2 output signals are present and that the first output interpolates
via column 2 and the second output interpolates via column 4 of the
table matrix.
</p>
<p>
The grid points and function values are stored in a matrix \"table[i,j]\",
where the first column \"table[:,1]\" contains the grid points and the
other columns contain the data to be interpolated. Example:
</p>
<pre>
   table = [0,  0;
            1,  1;
            2,  4;
            4, 16]
   If, e.g., the input u = 1.0, the output y =  1.0,
       e.g., the input u = 1.5, the output y =  2.5,
       e.g., the input u = 2.0, the output y =  4.0,
       e.g., the input u =-1.0, the output y = -1.0 (i.e. extrapolation).
</pre>
<ul>
<li> The interpolation is <b>efficient</b>, because a search for a new interpolation
     starts at the interval used in the last call.</li>
<li> If the table has only <b>one row</b>, the table value is returned,
     independent of the value of the input signal.</li>
<li> If the input signal <b>u</b> is <b>outside</b> of the defined <b>interval</b>, i.e.,
     u &gt; table[size(table,1),1] or u &lt; table[1,1], the corresponding
     value is also determined by linear
     interpolation through the last or first two points of the table.</li>
<li> The grid values (first column) have to be <b>strict</b>
     monotonically increasing.</li>
</ul>
<p>
The table matrix can be defined in the following ways:
</p>
<ol>
<li> Explicitly supplied as <b>parameter matrix</b> \"table\",
     and the other parameters have the following values:
<pre>
   tableName is \"NoName\" or has only blanks,
   fileName  is \"NoName\" or has only blanks.
</pre></li>
<li> <b>Read</b> from a <b>file</b> \"fileName\" where the matrix is stored as
      \"tableName\". Both ASCII and binary file format is possible.
      (the ASCII format is described below).
      It is most convenient to generate the binary file from Matlab
      (Matlab 4 storage format), e.g., by command
<pre>
   save tables.mat tab1 tab2 tab3 -V4
</pre>
      when the three tables tab1, tab2, tab3 should be
      used from the model.</li>
<li>  Statically stored in function \"usertab\" in file \"usertab.c\".
      The matrix is identified by \"tableName\". Parameter
      fileName = \"NoName\" or has only blanks.</li>
</ol>
<p>
Table definition methods (1) and (3) do <b>not</b> allocate dynamic memory,
and do not access files, whereas method (2) does. Therefore (1) and (3)
are suited for hardware-in-the-loop simulation (e.g. with dSpace hardware).
When the constant \"NO_FILE\" is defined, all parts of the
source code of method (2) are removed by the C-preprocessor, such that
no dynamic memory allocation and no access to files takes place.
</p>
<p>
If tables are read from an ASCII-file, the file need to have the
following structure (\"-----\" is not part of the file content):
</p>
<pre>
-----------------------------------------------------
#1
double tab1(5,2)   # comment line
  0   0
  1   1
  2   4
  3   9
  4  16
double tab2(5,2)   # another comment line
  0   0
  2   2
  4   8
  6  18
  8  32
-----------------------------------------------------
</pre>
<p>
Note, that the first two characters in the file need to be
\"#1\". Afterwards, the corresponding matrix has to be declared
with type, name and actual dimensions. Finally, in successive
rows of the file, the elements of the matrix have to be given.
Several matrices may be defined one after another.
</p>
</HTML>
"),       Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Line(points={{-60,40},{-60,-40},{60,-40},{60,40},{30,40},{30,-40},{-30,
                    -40},{-30,40},{-60,40},{-60,20},{60,20},{60,0},{-60,0},{-60,-20},
                    {60,-20},{60,-40},{-60,-40},{-60,40},{60,40},{60,-40}}, color={
                    0,0,0}),
              Line(points={{0,40},{0,-40}}, color={0,0,0}),
              Rectangle(
                extent={{-60,40},{-30,20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-60,20},{-30,0}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-60,0},{-30,-20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-60,-20},{-30,-40}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Rectangle(
                extent={{-60,60},{60,-60}},
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Line(points={{-100,0},{-58,0}}, color={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255}),
              Text(
                extent={{-100,100},{100,64}},
                textString="1 dimensional linear table interpolation",
                lineColor={0,0,255}),
              Line(points={{-54,40},{-54,-40},{54,-40},{54,40},{28,40},{28,-40},{-28,
                    -40},{-28,40},{-54,40},{-54,20},{54,20},{54,0},{-54,0},{-54,-20},
                    {54,-20},{54,-40},{-54,-40},{-54,40},{54,40},{54,-40}}, color={
                    0,0,0}),
              Line(points={{0,40},{0,-40}}, color={0,0,0}),
              Rectangle(
                extent={{-54,40},{-28,20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-54,20},{-28,0}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-54,0},{-28,-20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-54,-20},{-28,-40}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Text(
                extent={{-52,56},{-34,44}},
                textString="u",
                lineColor={0,0,255}),
              Text(
                extent={{-22,54},{2,42}},
                textString="y[1]",
                lineColor={0,0,255}),
              Text(
                extent={{4,54},{28,42}},
                textString="y[2]",
                lineColor={0,0,255}),
              Text(
                extent={{0,-40},{32,-54}},
                textString="columns",
                lineColor={0,0,255})}));

      protected
        Integer tableID;

        function tableInit
          input String tableName;
          input String fileName;
          input Real table[ :, :];
          input Modelica.Blocks.Types.Smoothness smoothness;
          output Integer tableID;
        external "C" tableID = ModelicaTables_CombiTable1D_init(
                       tableName, fileName, table, size(table, 1), size(table, 2),
                       smoothness);
          annotation(Library="ModelicaExternalC");
        end tableInit;

        function tableIpo
          input Integer tableID;
          input Integer icol;
          input Real u;
          output Real value;
        external "C" value = 
                           ModelicaTables_CombiTable1D_interpolate(tableID, icol, u);
          annotation(Library="ModelicaExternalC");
        end tableIpo;

      equation
        if tableOnFile then
          assert(tableName<>"NoName", "tableOnFile = true and no table name given");
        end if;
        if not tableOnFile then
          assert(size(table,1) > 0 and size(table,2) > 0, "tableOnFile = false and parameter table is an empty matrix");
        end if;

        for i in 1:nout loop
          y[i] = if not tableOnFile and size(table,1)==1 then 
                   table[1, columns[i]] else tableIpo(tableID, columns[i], u);
        end for;
        when initial() then
          tableID=tableInit(if tableOnFile then tableName else "NoName",
                            if tableOnFile then fileName else "NoName", table, smoothness);
        end when;
      end CombiTable1Ds;

      model CombiTable2D "Table look-up in two dimensions (matrix/file) "

        import Modelica.Blocks.Types;
        extends Modelica.Blocks.Interfaces.SI2SO;

        parameter Boolean tableOnFile=false
          "true, if table is defined on file or in function usertab" 
          annotation(Dialog(group="table data definition"));
        parameter Real table[:, :]=fill(0.0,0,2)
          "table matrix (grid u1 = first column, grid u2 = first row; e.g. table=[0,0;0,1])"
             annotation(Dialog(group="table data definition", enable = not tableOnFile));
        parameter String tableName="NoName"
          "table name on file or in function usertab (see docu)" 
             annotation(Dialog(group="table data definition", enable = tableOnFile));
        parameter String fileName="NoName" "file where matrix is stored" 
             annotation(Dialog(group="table data definition", enable = tableOnFile,
                               __Dymola_loadSelector(filter="Text files (*.txt);;Matlab files (*.mat)",
                               caption="Open file in which table is present")));
        parameter Modelica.Blocks.Types.Smoothness smoothness=Types.Smoothness.LinearSegments
          "smoothness of table interpolation" 
        annotation(Dialog(group="table data interpretation"));
        annotation (
          Documentation(info="<html>
<p>
<b>Linear interpolation</b> in <b>two</b> dimensions of a <b>table</b>.
The grid points and function values are stored in a matrix \"table[i,j]\",
where:
</p>
<ul>
<li> the first column \"table[2:,1]\" contains the u[1] grid points,</li>
<li> the first row \"table[1,2:]\" contains the u[2] grid points,</li>
<li> the other rows and columns contain the data to be interpolated.</li>
</ul>
<p>
Example:
</p>
<pre>
           |       |       |       |
           |  1.0  |  2.0  |  3.0  |  // u2
       ----*-------*-------*-------*
       1.0 |  1.0  |  3.0  |  5.0  |
       ----*-------*-------*-------*
       2.0 |  2.0  |  4.0  |  6.0  |
       ----*-------*-------*-------*
     // u1
   is defined as
      table = [0.0,   1.0,   2.0,   3.0;
               1.0,   1.0,   3.0,   5.0;
               2.0,   2.0,   4.0,   6.0]
   If, e.g. the input u is [1.0;1.0], the output y is 1.0,
       e.g. the input u is [2.0;1.5], the output y is 3.0.
</pre>
<ul>
<li> The interpolation is <b>efficient</b>, because a search for a new interpolation
     starts at the interval used in the last call.</li>
<li> If the table has only <b>one element</b>, the table value is returned,
     independent of the value of the input signal.</li>
<li> If the input signal <b>u1</b> or <b>u2</b> is <b>outside</b> of the defined <b>interval</b>,
     the corresponding value is also determined by linear
     interpolation through the last or first two points of the table.</li>
<li> The grid values (first column and first row) have to be <b>strict</b>
     monotonically increasing.</li>
</ul>
<p>
The table matrix can be defined in the following ways:
</p>
<ol>
<li> Explicitly supplied as <b>parameter matrix</b> \"table\",
     and the other parameters have the following values:
<pre>
   tableName is \"NoName\" or has only blanks,
   fileName  is \"NoName\" or has only blanks.
</pre></li>
<li> <b>Read</b> from a <b>file</b> \"fileName\" where the matrix is stored as
      \"tableName\". Both ASCII and binary file format is possible.
      (the ASCII format is described below).
      It is most convenient to generate the binary file from Matlab
      (Matlab 4 storage format), e.g., by command
<pre>
   save tables.mat tab1 tab2 tab3 -V4
</pre>
      when the three tables tab1, tab2, tab3 should be
      used from the model.</li>
<li>  Statically stored in function \"usertab\" in file \"usertab.c\".
      The matrix is identified by \"tableName\". Parameter
      fileName = \"NoName\" or has only blanks.</li>
</ol>
<p>
Table definition methods (1) and (3) do <b>not</b> allocate dynamic memory,
and do not access files, whereas method (2) does. Therefore (1) and (3)
are suited for hardware-in-the-loop simulation (e.g. with dSpace hardware).
When the constant \"NO_FILE\" is defined, all parts of the
source code of method (2) are removed by the C-preprocessor, such that
no dynamic memory allocation and no access to files takes place.
</p>
<p>
If tables are read from an ASCII-file, the file need to have the
following structure (\"-----\" is not part of the file content):
</p>
<pre>
-----------------------------------------------------
#1
double table2D_1(3,4)   # comment line
0.0  1.0  2.0  3.0  # u[2] grid points
1.0  1.0  3.0  5.0
2.0  2.0  4.0  6.0
 
double table2D_2(4,4)   # comment line
0.0  1.0  2.0  3.0  # u[2] grid points
1.0  1.0  3.0  5.0
2.0  2.0  4.0  6.0
3.0  3.0  5.0  7.0
-----------------------------------------------------
</pre>
<p>
Note, that the first two characters in the file need to be
\"#1\". Afterwards, the corresponding matrix has to be declared
with type, name and actual dimensions. Finally, in successive
rows of the file, the elements of the matrix have to be given.
Several matrices may be defined one after another.
The matrix elements are interpreted in exactly the same way
as if the matrix is given as a parameter. For example, the first
column \"table2D_1[2:,1]\" contains the u[1] grid points,
and the first row \"table2D_1[1,2:]\" contains the u[2] grid points.
</p>
 
</html>
"),       Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                  100}}), graphics={
              Line(points={{-60,40},{-60,-40},{60,-40},{60,40},{30,40},{30,-40},{-30,
                    -40},{-30,40},{-60,40},{-60,20},{60,20},{60,0},{-60,0},{-60,-20},
                    {60,-20},{60,-40},{-60,-40},{-60,40},{60,40},{60,-40}}, color={
                    0,0,0}),
              Line(points={{0,40},{0,-40}}, color={0,0,0}),
              Rectangle(
                extent={{-60,20},{-30,0}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-60,0},{-30,-20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-60,-20},{-30,-40}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-30,40},{0,20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{0,40},{30,20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{30,40},{60,20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Line(points={{-60,40},{-30,20}}, color={0,0,0}),
              Line(points={{-30,40},{-60,20}}, color={0,0,0})}),
          Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                  100,100}}), graphics={
              Rectangle(
                extent={{-60,60},{60,-60}},
                fillColor={235,235,235},
                fillPattern=FillPattern.Solid,
                lineColor={0,0,255}),
              Line(points={{60,0},{100,0}}, color={0,0,255}),
              Text(
                extent={{-100,100},{100,64}},
                textString="2 dimensional linear table interpolation",
                lineColor={0,0,255}),
              Line(points={{-54,40},{-54,-40},{54,-40},{54,40},{28,40},{28,-40},{-28,
                    -40},{-28,40},{-54,40},{-54,20},{54,20},{54,0},{-54,0},{-54,-20},
                    {54,-20},{54,-40},{-54,-40},{-54,40},{54,40},{54,-40}}, color={
                    0,0,0}),
              Line(points={{0,40},{0,-40}}, color={0,0,0}),
              Rectangle(
                extent={{-54,20},{-28,0}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-54,0},{-28,-20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-54,-20},{-28,-40}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{-28,40},{0,20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{0,40},{28,20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Rectangle(
                extent={{28,40},{54,20}},
                lineColor={0,0,0},
                fillColor={255,255,0},
                fillPattern=FillPattern.Solid),
              Line(points={{-54,40},{-28,20}}, color={0,0,0}),
              Line(points={{-28,40},{-54,20}}, color={0,0,0}),
              Text(
                extent={{-54,-40},{-30,-56}},
                textString="u1",
                lineColor={0,0,255}),
              Text(
                extent={{28,58},{52,44}},
                textString="u2",
                lineColor={0,0,255}),
              Text(
                extent={{-2,12},{32,-22}},
                textString="y",
                lineColor={0,0,255})}));
      protected
        Integer tableID;

        function tableInit
          input String tableName;
          input String fileName;
          input Real table[ :, :];
          input Modelica.Blocks.Types.Smoothness smoothness;
          output Integer tableID;
        external "C" tableID = ModelicaTables_CombiTable2D_init(
                       tableName, fileName, table, size(table, 1), size(table, 2),
                       smoothness);
          annotation(Library="ModelicaExternalC");
        end tableInit;

        function tableIpo
          input Integer tableID;
          input Real u1;
          input Real u2;
          output Real value;
        external "C" value = 
                           ModelicaTables_CombiTable2D_interpolate(tableID, u1, u2);
          annotation(Library="ModelicaExternalC");
        end tableIpo;

      equation
        if tableOnFile then
          assert(tableName<>"NoName", "tableOnFile = true and no table name given");
        end if;
        if not tableOnFile then
          assert(size(table,1) > 0 and size(table,2) > 0, "tableOnFile = false and parameter table is an empty matrix");
        end if;

        y = tableIpo(tableID, u1, u2);
        when initial() then
          tableID=tableInit(if tableOnFile then tableName else "NoName",
                            if tableOnFile then fileName else "NoName", table, smoothness);
        end when;
      end CombiTable2D;
      annotation (Documentation(info="<html>
<p>
This package contains blocks for one- and two-dimensional
interpolation in tables.
</p>
</html>"));
    end Tables;

    package Types
      "Library of constants and types with choices, especially to build menus"
      extends Modelica.Icons.Library;
      annotation ( Documentation(info="<HTML>
<p>
In this package <b>types</b> and <b>constants</b> are defined that are used
in library Modelica.Blocks. The types have additional annotation choices
definitions that define the menus to be built up in the graphical
user interface when the type is used as parameter in a declaration.
</p>
</HTML>"));
      type Smoothness = enumeration(
          LinearSegments "Table points are linearly interpolated",
          ContinuousDerivative
            "Table points are interpolated such that the first derivative is continuous")
        "Enumeration defining the smoothness of table interpolation" 
        annotation (Documentation(info="<html>
 
</html>"));
    type Extrapolation = enumeration(
          HoldLastPoint "Hold the last table point outside of the table scope", 

          LastTwoPoints
            "Extrapolate linearly through the last two table points outside of the table scope", 

          Periodic "Repeat the table scope periodically")
        "Enumeration defining the extrapolation of time table interpolation" 
            annotation ( Documentation(info="<html>
 
</html>"));

      type Init = enumeration(
          NoInit
            "No initialization (start values are used as guess values with fixed=false)", 

          SteadyState
            "Steady state initialization (derivatives of states are zero)",
          InitialState "Initialization with initial states",
          InitialOutput
            "Initialization with initial outputs (and steady state of the states if possibles)")
        "Enumeration defining initialization of a block" 
          annotation (Evaluate=true, Documentation(info="<html>
 
</html>"));

      type InitPID = enumeration(
          NoInit
            "No initialization (start values are used as guess values with fixed=false)", 

          SteadyState
            "Steady state initialization (derivatives of states are zero)",
          InitialState "Initialization with initial states",
          InitialOutput
            "Initialization with initial outputs (and steady state of the states if possibles)", 

          DoNotUse_InitialIntegratorState
            "Don't use, only for backward compatibility (initialize only integrator state)")
        "Enumeration defining initialization of PID and LimPID blocks" 
        annotation (Documentation(info="<html>
<p>
This initialization type is identical to Types.Init and has just one
additional option <b>DoNotUse_InitialIntegratorState</b>. This option
is introduced in order that the default initialization for the
Continuous.PID and Continuous.LimPID blocks are backward 
compatible. In Modelica 2.2, the integrators have been initialized
with their given states where as the D-part has not been initialized.
The option \"DoNotUse_InitialIntegratorState\" leads to this
initialization definition.
</p>
 
</html>"),       Evaluate=true);

      type SimpleController = enumeration(
          P "P controller",
          PI "PI controller",
          PD "PD controller",
          PID "PID controller")
        "Enumeration defining P, PI, PD, or PID simple controller type" 
          annotation (Evaluate=true, Documentation(info="<html>
 
</html>"));

    end Types;
  end Blocks;

  package Constants
    "Library of mathematical constants and constants of nature (e.g., pi, eps, R, sigma)"

    import SI = Modelica.SIunits;
    import NonSI = Modelica.SIunits.Conversions.NonSIunits;

    extends Modelica.Icons.Library2;

    // Mathematical constants
    final constant Real e=Modelica.Math.exp(1.0);
    final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
    final constant Real D2R=pi/180 "Degree to Radian";
    final constant Real R2D=180/pi "Radian to Degree";

    // Machine dependent constants
    // (the definition is a temporary fix since not adapted to the
    // machine where the Modelica translator is running)
    final constant Real eps=1.e-15 "Biggest number such that 1.0 + eps = 1.0";
    final constant Real small=1.e-60
      "Smallest number such that small and -small are representable on the machine";
    final constant Real inf=1.e+60
      "Biggest Real number such that inf and -inf are representable on the machine";
    final constant Integer Integer_inf=2147483647
      "Biggest Integer number such that Integer_inf and -Integer_inf are representable on the machine";

    // Constants of nature
    // (name, value, description from http://physics.nist.gov/cuu/Constants/)
    final constant SI.Velocity c=299792458 "Speed of light in vacuum";
    final constant SI.Acceleration g_n=9.80665
      "Standard acceleration of gravity on earth";
    final constant Real G(final unit="m3/(kg.s2)") = 6.6742e-11
      "Newtonian constant of gravitation";
    final constant SI.FaradayConstant F = 9.64853399e4
      "Faraday constant, C/mol";
    final constant Real h(final unit="J.s") = 6.6260693e-34 "Planck constant";
    final constant Real k(final unit="J/K") = 1.3806505e-23
      "Boltzmann constant";
    final constant Real R(final unit="J/(mol.K)") = 8.314472
      "Molar gas constant";
    final constant Real sigma(final unit="W/(m2.K4)") = 5.670400e-8
      "Stefan-Boltzmann constant";
    final constant Real N_A(final unit="1/mol") = 6.0221415e23
      "Avogadro constant";
    final constant Real mue_0(final unit="N/A2") = 4*pi*1.e-7
      "Magnetic constant";
    final constant Real epsilon_0(final unit="F/m") = 1/(mue_0*c*c)
      "Electric constant";
    final constant NonSI.Temperature_degC T_zero=-273.15
      "Absolute zero temperature";

    annotation (
      Documentation(info="<html>
<p>
This package provides often needed constants from mathematics, machine
dependent constants and constants from nature. The latter constants
(name, value, description) are from the following source:
</p>

<dl>
<dt>Peter J. Mohr and Barry N. Taylor (1999):</dt>
<dd><b>CODATA Recommended Values of the Fundamental Physical Constants: 1998</b>.
    Journal of Physical and Chemical Reference Data, Vol. 28, No. 6, 1999 and
    Reviews of Modern Physics, Vol. 72, No. 2, 2000. See also <a href=
\"http://physics.nist.gov/cuu/Constants/\">http://physics.nist.gov/cuu/Constants/</a></dd>
</dl>

<p>CODATA is the Committee on Data for Science and Technology.</p>

<dl>
<dt><b>Main Author:</b></dt>
<dd><a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
    Deutsches Zentrum f&uuml;r Luft und Raumfahrt e. V. (DLR)<br>
    Oberpfaffenhofen<br>
    Postfach 11 16<br>
    D-82230 We&szlig;ling<br>
    email: <a href=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</a></dd>
</dl>


<p>
Copyright &copy; 1998-2008, Modelica Association and DLR.
</p>
<p>
<i>This Modelica package is <b>free</b> software; it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b> 
<a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
</p><br>
</html>
",   revisions="<html>
<ul>
<li><i>Nov 8, 2004</i>
       by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
       Constants updated according to 2002 CODATA values.</li>
<li><i>Dec 9, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Constants updated according to 1998 CODATA values. Using names, values
       and description text from this source. Included magnetic and
       electric constant.</li>
<li><i>Sep 18, 1999</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Constants eps, inf, small introduced.</li>
<li><i>Nov 15, 1997</i>
       by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
       Realized.</li>
</ul>
</html>"),
      Invisible=true,
      Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
              100}}), graphics={
          Line(
            points={{-34,-38},{12,-38}},
            color={0,0,0},
            thickness=0.5),
          Line(
            points={{-20,-38},{-24,-48},{-28,-56},{-34,-64}},
            color={0,0,0},
            thickness=0.5),
          Line(
            points={{-2,-38},{2,-46},{8,-56},{14,-64}},
            color={0,0,0},
            thickness=0.5)}),
      Diagram(graphics={
          Rectangle(
            extent={{200,162},{380,312}},
            fillColor={235,235,235},
            fillPattern=FillPattern.Solid,
            lineColor={0,0,255}),
          Polygon(
            points={{200,312},{220,332},{400,332},{380,312},{200,312}},
            fillColor={235,235,235},
            fillPattern=FillPattern.Solid,
            lineColor={0,0,255}),
          Polygon(
            points={{400,332},{400,182},{380,162},{380,312},{400,332}},
            fillColor={235,235,235},
            fillPattern=FillPattern.Solid,
            lineColor={0,0,255}),
          Text(
            extent={{210,302},{370,272}},
            lineColor={160,160,164},
            fillColor={0,0,0},
            fillPattern=FillPattern.Solid,
            textString="Library"),
          Line(
            points={{266,224},{312,224}},
            color={0,0,0},
            thickness=1),
          Line(
            points={{280,224},{276,214},{272,206},{266,198}},
            color={0,0,0},
            thickness=1),
          Line(
            points={{298,224},{302,216},{308,206},{314,198}},
            color={0,0,0},
            thickness=1),
          Text(
            extent={{152,412},{458,334}},
            lineColor={255,0,0},
            textString="Modelica.Constants")}));
  end Constants;

  package Electrical
    "Library of electrical models (analog, digital, machines, multi-phase)"
  extends Modelica.Icons.Library2;

  annotation (
    Documentation(info="<html>
<p>
This library contains electrical components to build up analog and digital circuits,
as well as machines to model electrical motors and generators,
especially three phase induction machines such as an asynchronous motor.
</p>

</HTML>
"), Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
              100}}), graphics={
          Rectangle(extent={{-29,-13},{3,-27}}, lineColor={0,0,0}),
          Line(points={{37,-58},{62,-58}}, color={0,0,0}),
          Line(points={{36,-49},{61,-49}}, color={0,0,0}),
          Line(points={{-78,-50},{-43,-50}}, color={0,0,0}),
          Line(points={{-67,-55},{-55,-55}}, color={0,0,0}),
          Line(points={{-61,-50},{-61,-20},{-29,-20}}, color={0,0,0}),
          Line(points={{3,-20},{48,-20},{48,-49}}, color={0,0,0}),
          Line(points={{48,-58},{48,-78},{-61,-78},{-61,-55}}, color={0,0,0})}));
    package Analog "Library for analog electrical models"
    import SI = Modelica.SIunits;

      package Examples
        "Examples that demonstrate the usage of the Analog electrical components"
      extends Modelica.Icons.Library2;

      annotation (
        Documentation(info="<html>
<p>
This package contains examples that demonstrate the usage of the
components of the Electrical.Analog library.
</p>
 
</HTML>
",       revisions="<html>
<dl>
<dt>
<b>Main Authors:</b>
<dd>
<a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
    &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
    <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
    &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
    Fraunhofer Institute for Integrated Circuits<br>
    Design Automation Department<br>
    Zeunerstra&szlig;e 38<br>
    D-01069 Dresden<br>
<p>
<dt>
<b>Copyright:</b>
<dd>
Copyright &copy; 1998-2006, Modelica Association and Fraunhofer-Gesellschaft.<br>
<i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b> in the documentation of package
Modelica in file \"Modelica/package.mo\".</i><br>
<p>
</dl>
</html>"));

        model CauerLowPassAnalog "Cauer low pass filter with analog components"

          annotation (Diagram(coordinateSystem(
                  preserveAspectRatio=true, extent={{-200,-100},{200,100}}), graphics={
                Rectangle(
                  extent={{-62,32},{-58,28}},
                  lineColor={0,0,255},
                  fillColor={85,85,255},
                  fillPattern=FillPattern.Solid),
                Rectangle(
                  extent={{-2,28},{2,32}},
                  lineColor={0,0,255},
                  fillColor={85,85,255},
                  fillPattern=FillPattern.Solid),
                Rectangle(
                  extent={{58,32},{62,28}},
                  lineColor={0,0,255},
                  fillColor={85,85,255},
                  fillPattern=FillPattern.Solid),
                Rectangle(
                  extent={{58,-48},{62,-52}},
                  lineColor={0,0,255},
                  fillColor={85,85,255},
                  fillPattern=FillPattern.Solid),
                Rectangle(
                  extent={{-2,-48},{2,-52}},
                  lineColor={0,0,255},
                  fillColor={85,85,255},
                  fillPattern=FillPattern.Solid),
                Rectangle(
                  extent={{-62,-48},{-58,-52}},
                  lineColor={0,0,255},
                  fillColor={85,85,255},
                  fillPattern=FillPattern.Solid),
                Text(
                  extent={{-110,116},{100,64}},
                  textString="CauerLowPassAnalog",
                  lineColor={0,0,255})}),
            experiment(StopTime=60),
            Documentation(revisions="<html>
<ul>
<li><i>January 13, 2006</i> 
       by Christoph Clauss<br>
       included into Modelica Standard Library</li>
<li><i>September 15, 2005</i>
       by Peter Trappe designed and by Teresa Schlegel<br>
       initially modelled.</li>
</ul>
</html>",         info="<html>
 
<p>
The example Cauer Filter is a low-pass-filter of the fifth order. It is realized
using an analog network. The voltage source V is the input voltage (step),
and the R2.p.v is the filter output voltage. The pulse response is calculated.
<p>
The simulation end time should be 60. Please plot both V.p.v (input voltage) and R2.p.v (output voltage). 
<p>
</html>"),    Icon(coordinateSystem(preserveAspectRatio=true, extent={{-200,-100},{200,
                    100}}), graphics={
                Rectangle(
                  extent={{-80,-90},{100,60}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Polygon(
                  points={{-80,60},{-60,80},{120,80},{100,60},{-80,60}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Polygon(
                  points={{120,80},{120,-70},{100,-90},{100,60},{120,80}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Text(
                  extent={{-76,13},{97,-39}},
                  lineColor={0,0,255},
                  textString="Example"),
                Text(
                  extent={{-100,142},{140,83}},
                  lineColor={255,0,0},
                  textString="%name")}));

          parameter Modelica.SIunits.Inductance l1=1.304
            "filter coefficient I1";
          parameter Modelica.SIunits.Inductance l2=0.8586
            "filter coefficient I2";
          parameter Modelica.SIunits.Capacitance c1=1.072
            "filter coefficient c1";
          parameter Modelica.SIunits.Capacitance c2=1/(1.704992^2*l1)
            "filter coefficient c2";
          parameter Modelica.SIunits.Capacitance c3=1.682
            "filter coefficient c3";
          parameter Modelica.SIunits.Capacitance c4=1/(1.179945^2*l2)
            "filter coefficient c4";
          parameter Modelica.SIunits.Capacitance c5=0.7262
            "filter coefficient c5";
          Modelica.Electrical.Analog.Basic.Ground G 
            annotation (Placement(transformation(extent={{-10,-90},{10,-70}}, rotation=
                    0)));
          Modelica.Electrical.Analog.Basic.Capacitor C1(C=c1) 
            annotation (Placement(transformation(
                origin={-60,-20},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Capacitor C2(C=c2) 
            annotation (Placement(transformation(extent={{-40,20},{-20,40}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C3(C=c3) 
            annotation (Placement(transformation(
                origin={0,-20},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Capacitor C4(C=c4) 
            annotation (Placement(transformation(extent={{20,20},{40,40}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C5(C=c5) 
            annotation (Placement(transformation(
                origin={60,-20},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Inductor L1(L=l1) 
            annotation (Placement(transformation(extent={{-40,60},{-20,80}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Inductor L2(L=l2) 
            annotation (Placement(transformation(extent={{20,60},{40,80}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R1 
            annotation (Placement(transformation(extent={{-100,20},{-80,40}}, rotation=
                    0)));
          Modelica.Electrical.Analog.Basic.Resistor R2 
            annotation (Placement(transformation(
                origin={100,-20},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Sources.StepVoltage V(startTime=1, offset=0) 
            annotation (Placement(transformation(
                origin={-100,-10},
                extent={{-10,-10},{10,10}},
                rotation=270)));
        equation
          connect(R1.n,C1. p) annotation (Line(points={{-80,30},{-60,30},{-60,-10}},
                color={0,0,255}));
          connect(C1.n,G. p) annotation (Line(points={{-60,-30},{-60,-50},{0,-50},{0,
                  -70}}, color={0,0,255}));
          connect(R1.n,C2. p) 
            annotation (Line(points={{-80,30},{-40,30}}, color={0,0,255}));
          connect(L1.p,C2. p) 
            annotation (Line(points={{-40,70},{-40,30}}, color={0,0,255}));
          connect(L1.p,C1. p) annotation (Line(points={{-40,70},{-40,30},{-60,30},{-60,
                  -10}}, color={0,0,255}));
          connect(L1.n,C2. n) 
            annotation (Line(points={{-20,70},{-20,30}}, color={0,0,255}));
          connect(C2.n,C3. p) annotation (Line(points={{-20,30},{1.83697e-015,30},{
                  1.83697e-015,-10}}, color={0,0,255}));
          connect(C2.n,C4. p) 
            annotation (Line(points={{-20,30},{20,30}}, color={0,0,255}));
          connect(L1.n,C3. p) annotation (Line(points={{-20,70},{-20,30},{1.83697e-015,
                  30},{1.83697e-015,-10}}, color={0,0,255}));
          connect(L1.n,C4. p) annotation (Line(points={{-20,70},{-20,30},{20,30}},
                color={0,0,255}));
          connect(L2.p,C4. p) 
            annotation (Line(points={{20,70},{20,30}}, color={0,0,255}));
          connect(C2.n,L2. p) annotation (Line(points={{-20,30},{20,30},{20,70}}, color=
                 {0,0,255}));
          connect(C3.p,L2. p) annotation (Line(points={{1.83697e-015,-10},{0,-10},{0,30},
                  {20,30},{20,70}}, color={0,0,255}));
          connect(L2.n,C4. n) 
            annotation (Line(points={{40,70},{40,30}}, color={0,0,255}));
          connect(L2.n,C5. p) annotation (Line(points={{40,70},{40,30},{60,30},{60,-10}},
                color={0,0,255}));
          connect(L2.n,R2. p) annotation (Line(points={{40,70},{40,30},{100,30},{100,
                  -10}}, color={0,0,255}));
          connect(R2.n,G. p) annotation (Line(points={{100,-30},{100,-50},{0,-50},{0,
                  -70}}, color={0,0,255}));
          connect(C4.n,C5. p) annotation (Line(points={{40,30},{60,30},{60,-10}}, color=
                 {0,0,255}));
          connect(C4.n,R2. p) annotation (Line(points={{40,30},{100,30},{100,-10}},
                color={0,0,255}));
          connect(C3.n,G. p) annotation (Line(points={{-1.83697e-015,-30},{0,-30},{0,
                  -70}}, color={0,0,255}));
          connect(C5.n,G. p) annotation (Line(points={{60,-30},{60,-50},{0,-50},{0,-70}},
                color={0,0,255}));
          connect(C1.n,C3. n) annotation (Line(points={{-60,-30},{-60,-50},{0,-50},{0,
                  -30},{-1.83697e-015,-30}}, color={0,0,255}));
          connect(C1.n,C5. n) annotation (Line(points={{-60,-30},{-60,-50},{60,-50},{60,
                  -30}}, color={0,0,255}));
          connect(R2.n,C5. n) annotation (Line(points={{100,-30},{100,-50},{60,-50},{60,
                  -30}}, color={0,0,255}));
          connect(R2.n,C3. n) annotation (Line(points={{100,-30},{100,-50},{0,-50},{0,
                  -30},{-1.83697e-015,-30}}, color={0,0,255}));
          connect(R2.n,C1. n) annotation (Line(points={{100,-30},{100,-50},{-60,-50},{
                  -60,-30}}, color={0,0,255}));
          connect(C5.p,R2. p) annotation (Line(
              points={{60,-10},{60,30},{100,30},{100,-10}},
              color={0,0,255}));
          connect(R1.p, V.p) 
            annotation (Line(points={{-100,30},{-100,0}}, color={0,0,255}));
          connect(V.n, G.p)            annotation (Line(points={{-100,-20},{-100,-70},{
                  0,-70}}, color={0,0,255}));
        end CauerLowPassAnalog;

        model CauerLowPassOPV
          "Cauer low pass filter with operational amplifiers"

          annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-250,-200},{
                    250,200}}), graphics={Text(
                  extent={{-130,172},{80,120}},
                  textString="CauerLowPassOPV",
                  lineColor={0,0,255})}),
            experiment(StopTime=60),
            Documentation(revisions="<html>
<ul>
<li><i>January 13, 2006</i> 
       by Christoph Clauss<br>
       included into Modelica Standard Library</li>
<li><i>September 15, 2005</i>
       by by Peter Trappe designed and by Teresa Schlegel<br>
       initially modelled.</li>
</ul>
</html>",         info="<html>
The example Cauer Filter is a low-pass-filter of the fifth order. It is realized
using an analog network with operational amplifiers. The voltage source V is the input voltage (step),
and the OP5.out.v is the filter output voltage. The pulse response is calculated.
<p>
This model is identical to the CauerLowPassAnalog example, but inverting. To get the same response
as that of the CauerLowPassAnalog example, a negative voltage step is used as input.
<p>
The simulation end time should be 60. Please plot both V.v (which is the inverted input voltage) and OP5.p.v (output voltage). Compare this result with the CauerLowPassAnalog result.
<p>
During translation some warnings are issued concerning resistor values (Value=-1 not in range[0,1.e+100]).
Do not worry about it. The negative values are o.k.
<p>
</html>"),  Icon(coordinateSystem(preserveAspectRatio=true, extent={{-250,-200},{250,
                    200}}), graphics={
                Rectangle(
                  extent={{-100,-80},{80,70}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Polygon(
                  points={{-100,70},{-80,90},{100,90},{80,70},{-100,70}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Polygon(
                  points={{100,90},{100,-60},{80,-80},{80,70},{100,90}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Text(
                  extent={{-96,23},{77,-29}},
                  lineColor={0,0,255},
                  textString="Example"),
                Text(
                  extent={{-120,152},{120,93}},
                  lineColor={255,0,0},
                  textString="%name")}));

          parameter Modelica.SIunits.Capacitance l1=1.304
            "filter coefficient i1";
          parameter Modelica.SIunits.Capacitance l2=0.8586
            "filter coefficient i2";
          parameter Modelica.SIunits.Capacitance c1=1.072
            "filter coefficient c1";
          parameter Modelica.SIunits.Capacitance c2=1/(1.704992^2*l1)
            "filter coefficient c2";
          parameter Modelica.SIunits.Capacitance c3=1.682
            "filter coefficient c3";
          parameter Modelica.SIunits.Capacitance c4=1/(1.179945^2*l2)
            "filter coefficient c4";
          parameter Modelica.SIunits.Capacitance c5=0.7262
            "filter coefficient c5";
          Modelica.Electrical.Analog.Basic.Capacitor C1(C=c1 + c2) 
            annotation (Placement(transformation(extent={{-192,10},{-172,30}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Basic.Capacitor C2(C=c2) 
            annotation (Placement(transformation(extent={{-240,-90},{-220,-70}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C3(C=l1) 
            annotation (Placement(transformation(extent={{-90,10},{-70,30}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C4(C=c4) 
            annotation (Placement(transformation(extent={{-30,30},{-10,50}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C5(C=c2) 
            annotation (Placement(transformation(extent={{-30,-120},{-10,-100}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R1 
            annotation (Placement(transformation(extent={{-240,-50},{-220,-30}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R2 
            annotation (Placement(transformation(extent={{-240,-10},{-220,10}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R3 
            annotation (Placement(transformation(extent={{-193,50},{-173,70}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin Op1 
            annotation (Placement(transformation(extent={{-200,-70},{-160,-30}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground G 
            annotation (Placement(transformation(extent={{-188,-96},{-174,-80}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R4(R=-1) 
            annotation (Placement(transformation(extent={{-140,-60},{-120,-40}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R5(R=-1) 
            annotation (Placement(transformation(extent={{-140,-100},{-120,-80}},
                  rotation=0)));
          Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin Op2 
            annotation (Placement(transformation(extent={{-100,-70},{-60,-30}},
                  rotation=0)));
          Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin Op3 
            annotation (Placement(transformation(extent={{6,-70},{46,-30}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground G1 
            annotation (Placement(transformation(extent={{-87,-96},{-73,-80}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Basic.Resistor R6 
            annotation (Placement(transformation(extent={{-31,-10},{-11,10}}, rotation=
                    0)));
          Modelica.Electrical.Analog.Basic.Resistor R7 
            annotation (Placement(transformation(extent={{-31,-60},{-11,-40}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Basic.Capacitor C6(C=c2 + c3 + c4) 
            annotation (Placement(transformation(extent={{9,10},{29,30}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R8(R=-1) 
            annotation (Placement(transformation(extent={{60,-10},{80,10}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R9(R=-1) 
            annotation (Placement(transformation(extent={{60,-60},{80,-40}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R10 
            annotation (Placement(transformation(extent={{160,-60},{180,-40}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin Op4 
            annotation (Placement(transformation(extent={{100,-70},{140,-30}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin Op5 
            annotation (Placement(transformation(extent={{200,-70},{240,-30}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Basic.Capacitor C7(C=l2) 
            annotation (Placement(transformation(extent={{110,10},{130,30}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C8(C=c4) 
            annotation (Placement(transformation(extent={{160,-150},{180,-130}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C9(C=c4 + c5) 
            annotation (Placement(transformation(extent={{208,-10},{228,10}}, rotation=
                    0)));
          Modelica.Electrical.Analog.Basic.Resistor R11 
            annotation (Placement(transformation(extent={{209,30},{229,50}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n1 
            annotation (Placement(transformation(extent={{-214,-42},{-210,-38}},
                  rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n2 
            annotation (Placement(transformation(extent={{-214,-2},{-210,2}}, rotation=
                    0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n3 
            annotation (Placement(transformation(extent={{-214,18},{-210,22}}, rotation=
                   0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n4 
            annotation (Placement(transformation(
                origin={-160,20},
                extent={{2,2},{-2,-2}},
                rotation=180)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n5 
            annotation (Placement(transformation(extent={{-114,-52},{-110,-48}},
                  rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.PositivePin p1 
            annotation (Placement(transformation(extent={{-154,-142},{-148,-138}},
                  rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n6 
            annotation (Placement(transformation(extent={{-62,18},{-58,22}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n7 
            annotation (Placement(transformation(extent={{-6,-52},{-2,-48}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n8 
            annotation (Placement(transformation(extent={{-6,-2},{-2,2}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.PositivePin p2 
            annotation (Placement(transformation(extent={{-6,18},{-2,22}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.PositivePin out1 
            annotation (Placement(transformation(extent={{44,-142},{48,-138}}, rotation=
                   0)));
        protected
          Modelica.Electrical.Analog.Interfaces.PositivePin p3 
            annotation (Placement(transformation(extent={{58,58},{62,62}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n9 
            annotation (Placement(transformation(extent={{86,-2},{90,2}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n10 
            annotation (Placement(transformation(extent={{86,-52},{90,-48}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n11 
            annotation (Placement(transformation(extent={{138,18},{142,22}}, rotation=0)));
        public
          Modelica.Electrical.Analog.Basic.Ground G2 
            annotation (Placement(transformation(extent={{12,-96},{26,-80}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n12 
            annotation (Placement(transformation(extent={{238,38},{242,42}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n13 
            annotation (Placement(transformation(extent={{238,-2},{242,2}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.PositivePin p4 
            annotation (Placement(transformation(extent={{188,-2},{194,2}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n14 
            annotation (Placement(transformation(extent={{188,-52},{194,-48}}, rotation=
                   0)));
        public
          Modelica.Electrical.Analog.Basic.Ground G3 
            annotation (Placement(transformation(extent={{113,-96},{127,-80}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Basic.Ground G4 
            annotation (Placement(transformation(extent={{213,-96},{227,-80}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Sources.StepVoltage V(startTime=1) 
            annotation (Placement(transformation(
                origin={-240,-170},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 
            annotation (Placement(transformation(extent={{-246,-202},{-234,-190}},
                  rotation=0)));
        equation
          connect(Op1.in_p, G.p) annotation (Line(points={{-200,-60},{-200,-70},{-180,
                  -70},{-180,-80},{-181,-80}}, color={0,0,255}));
          connect(G1.p, Op2.in_p) annotation (Line(points={{-80,-80},{-80,-70},{-100,
                  -70},{-100,-60}}, color={0,0,255}));
          connect(R1.n, n1) annotation (Line(points={{-220,-40},{-212,-40}}, color={0,0,
                  255}));
          connect(n1, Op1.in_n) annotation (Line(points={{-212,-40},{-200,-40}}, color=
                  {0,0,255}));
          connect(C2.n, n1) annotation (Line(points={{-220,-80},{-212,-80},{-212,-40}},
                color={0,0,255}));
          connect(R2.n, n2) 
            annotation (Line(points={{-220,0},{-212,0}}, color={0,0,255}));
          connect(n1, n2) 
            annotation (Line(points={{-212,-40},{-212,0}}, color={0,0,255}));
          connect(n2, n3) 
            annotation (Line(points={{-212,0},{-212,20}}, color={0,0,255}));
          connect(n3, C1.p) 
            annotation (Line(points={{-212,20},{-192,20}}, color={0,0,255}));
          connect(n3, R3.p) annotation (Line(points={{-212,20},{-212,60},{-193,60}},
                color={0,0,255}));
          connect(C1.n, n4) 
            annotation (Line(points={{-172,20},{-160,20}}, color={0,0,255}));
          connect(R3.n, n4) annotation (Line(points={{-173,60},{-160,60},{-160,20}},
                color={0,0,255}));
          connect(n4, Op1.out) annotation (Line(points={{-160,20},{-160,-50}}, color={0,
                  0,255}));
          connect(R4.p, Op1.out) annotation (Line(points={{-140,-50},{-160,-50}}, color=
                 {0,0,255}));
          connect(C5.p, Op1.out) annotation (Line(points={{-30,-110},{-160,-110},{-160,
                  -50}}, color={0,0,255}));
          connect(R4.n, n5) annotation (Line(points={{-120,-50},{-112,-50}}, color={0,0,
                  255}));
          connect(n5, Op2.in_n) annotation (Line(points={{-112,-50},{-112,-40},{-100,
                  -40}}, color={0,0,255}));
          connect(C3.p, n5) annotation (Line(points={{-90,20},{-112,20},{-112,-50}},
                color={0,0,255}));
          connect(R5.n, n5) annotation (Line(points={{-120,-90},{-112,-90},{-112,-50}},
                color={0,0,255}));
          connect(R5.p, p1) annotation (Line(points={{-140,-90},{-151,-90},{-151,-140}},
                color={0,0,255}));
          connect(C2.p, p1) annotation (Line(points={{-240,-80},{-240,-140},{-151,-140}},
                color={0,0,255}));
          connect(C3.n, n6) 
            annotation (Line(points={{-70,20},{-60,20}}, color={0,0,255}));
          connect(n6, Op2.out) 
            annotation (Line(points={{-60,20},{-60,-50}}, color={0,0,255}));
          connect(R2.p, n6) annotation (Line(points={{-240,0},{-240,80},{-60,80},{-60,
                  20}}, color={0,0,255}));
          connect(Op2.out, R7.p) 
            annotation (Line(points={{-60,-50},{-31,-50}}, color={0,0,255}));
          connect(R7.n, n7) 
            annotation (Line(points={{-11,-50},{-4,-50}}, color={0,0,255}));
          connect(n7, Op3.in_n) annotation (Line(points={{-4,-50},{-4,-40},{6,-40}},
                color={0,0,255}));
          connect(C5.n, n7) annotation (Line(points={{-10,-110},{-4,-110},{-4,-50}},
                color={0,0,255}));
          connect(R6.n, n8) 
            annotation (Line(points={{-11,0},{-4,0}}, color={0,0,255}));
          connect(n7, n8) annotation (Line(points={{-4,-50},{-4,0},{-4,0}}, color={0,0,
                  255}));
          connect(C6.p, p2) 
            annotation (Line(points={{9,20},{-4,20}}, color={0,0,255}));
          connect(n8, p2) 
            annotation (Line(points={{-4,0},{-4,20}}, color={0,0,255}));
          connect(C4.n, p2) annotation (Line(points={{-10,40},{-4,40},{-4,20}}, color={
                  0,0,255}));
          connect(C6.n, Op3.out) annotation (Line(points={{29,20},{46,20},{46,-50}},
                color={0,0,255}));
          connect(R9.p, Op3.out) 
            annotation (Line(points={{60,-50},{46,-50}}, color={0,0,255}));
          connect(Op3.out, out1) 
            annotation (Line(points={{46,-50},{46,-140}}, color={0,0,255}));
          connect(p1, out1) annotation (Line(points={{-151,-140},{46,-140}}, color={0,0,
                  255}));
          connect(out1, C8.p) annotation (Line(points={{46,-140},{160,-140}}, color={0,
                  0,255}));
          connect(C4.p, p3) annotation (Line(points={{-30,40},{-40,40},{-40,60},{60,60}},
                color={0,0,255}));
          connect(p3, R8.p) 
            annotation (Line(points={{60,60},{60,0}}, color={0,0,255}));
          connect(R8.n, n9) 
            annotation (Line(points={{80,0},{88,0}}, color={0,0,255}));
          connect(n9, n10) 
            annotation (Line(points={{88,0},{88,-50}}, color={0,0,255}));
          connect(R9.n, n10) 
            annotation (Line(points={{80,-50},{88,-50}}, color={0,0,255}));
          connect(n10, Op4.in_n) annotation (Line(points={{88,-50},{88,-40},{100,-40}},
                color={0,0,255}));
          connect(n9, C7.p) annotation (Line(points={{88,0},{88,20},{110,20}}, color={0,
                  0,255}));
          connect(C7.n, n11) 
            annotation (Line(points={{130,20},{140,20}}, color={0,0,255}));
          connect(R6.p, n11) annotation (Line(points={{-31,0},{-48,0},{-48,80},{140,80},
                  {140,20}}, color={0,0,255}));
          connect(n11, Op4.out) 
            annotation (Line(points={{140,20},{140,-50}}, color={0,0,255}));
          connect(Op4.out, R10.p) 
            annotation (Line(points={{140,-50},{160,-50}}, color={0,0,255}));
          connect(G2.p, Op3.in_p) annotation (Line(points={{19,-80},{6,-80},{6,-60}},
                color={0,0,255}));
          connect(R11.n, n12) 
            annotation (Line(points={{229,40},{240,40}}, color={0,0,255}));
          connect(p3, n12) annotation (Line(points={{60,60},{240,60},{240,40}}, color={
                  0,0,255}));
          connect(C9.n, n13) 
            annotation (Line(points={{228,0},{240,0}}, color={0,0,255}));
          connect(n12, n13) 
            annotation (Line(points={{240,40},{240,0}}, color={0,0,255}));
          connect(n13, Op5.out) 
            annotation (Line(points={{240,0},{240,-50}}, color={0,0,255}));
          connect(C9.p, p4) 
            annotation (Line(points={{208,0},{191,0}}, color={0,0,255}));
          connect(R11.p, p4) annotation (Line(points={{209,40},{191,40},{191,0}}, color=
                 {0,0,255}));
          connect(R10.n, n14) 
            annotation (Line(points={{180,-50},{191,-50}}, color={0,0,255}));
          connect(p4, n14) 
            annotation (Line(points={{191,0},{191,-50}}, color={0,0,255}));
          connect(Op5.in_n, n14) annotation (Line(points={{200,-40},{191,-40},{191,-50}},
                color={0,0,255}));
          connect(C8.n, n14) annotation (Line(points={{180,-140},{191,-140},{191,-50}},
                color={0,0,255}));
          connect(Op4.in_p, G3.p) annotation (Line(points={{100,-60},{100,-80},{120,-80}},
                color={0,0,255}));
          connect(Op5.in_p, G4.p) annotation (Line(points={{200,-60},{200,-80},{220,-80}},
                color={0,0,255}));
          connect(V.p, Ground1.p)            annotation (Line(points={{-240,-180},{-240,
                  -190}}, color={0,0,255}));
          connect(V.n, R1.p)            annotation (Line(points={{-240,-160},{-250,-160},
                  {-250,-40},{-240,-40}}, color={0,0,255}));
        end CauerLowPassOPV;

        model CauerLowPassSC
          "Cauer low-pass filter with operational amplifiers and switched capacitors"
        model Rn "negative resistance"
          parameter Modelica.SIunits.Time clock=1 "clock";
          parameter Modelica.SIunits.Resistance R(min=Modelica.Constants.eps)=1
              "Resistance";
          Modelica.Blocks.Sources.BooleanPulse BooleanPulse1(period=clock) 
            annotation (Placement(transformation(extent={{-10,50},{10,70}}, rotation=0)));
          annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                      100,100}}),
                    graphics),
            Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                      100}}), graphics={
                  Bitmap(extent={{-62,6},{-62,14}}, fileName=""),
                  Rectangle(
                    extent={{-80,32},{80,-30}},
                    pattern=LinePattern.None,
                    lineColor={0,0,255}),
                  Text(
                    extent={{-30,-40},{30,-72}},
                    lineColor={0,0,0},
                    textString="R=%R"),
                  Line(points={{-74,0},{-80,0},{-60,0}}, color={85,255,85}),
                  Line(points={{-80,-20},{-60,-20},{-60,-16},{-40,-8},{-4,-8}}, color={
                        85,255,85}),
                  Line(points={{80,0},{60,0}}, color={85,255,85}),
                  Line(points={{-60,2},{-60,-4}}, color={170,255,170}),
                  Line(points={{-4,2},{-4,-18}}, color={85,255,85}),
                  Line(points={{4,2},{4,-18}}, color={85,255,85}),
                  Text(
                    extent={{-60,80},{60,40}},
                    lineColor={0,0,255},
                    textString="%name"),
                  Line(points={{-92,0},{-80,0}}, color={85,85,255}),
                  Line(points={{90,0},{80,0},{80,0}}, color={85,85,255}),
                  Line(points={{4,-8},{40,-8},{60,-4}}, color={85,255,85}),
                  Line(points={{60,0},{60,-4}}, color={85,255,85}),
                  Line(points={{60,-16},{60,-20},{80,-20}}, color={85,255,85})}));

          Modelica.Electrical.Analog.Basic.Capacitor Capacitor1(C=clock/R) 
            annotation (Placement(transformation(extent={{-20,-20},{20,20}}, rotation=0)));
          Modelica.Electrical.Analog.Ideal.IdealCommutingSwitch
              IdealCommutingSwitch1 
            annotation (Placement(transformation(
                  origin={-50,0},
                  extent={{-10,-10},{10,10}},
                  rotation=180)));
          Modelica.Electrical.Analog.Ideal.IdealCommutingSwitch
              IdealCommutingSwitch2 
            annotation (Placement(transformation(extent={{40,-10},{60,10}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 
            annotation (Placement(transformation(extent={{-66,-32},{-54,-20}}, rotation=
                     0)));
          Modelica.Electrical.Analog.Basic.Ground Ground2 
            annotation (Placement(transformation(extent={{54,-32},{66,-20}}, rotation=0)));
          Modelica.Electrical.Analog.Interfaces.NegativePin n1 
            annotation (Placement(transformation(extent={{-112,-10},{-92,10}}, rotation=
                     0)));
          Modelica.Electrical.Analog.Interfaces.NegativePin n2 
            annotation (Placement(transformation(extent={{90,-8},{110,12}}, rotation=0)));
        equation
          connect(IdealCommutingSwitch1.p,Capacitor1. p) annotation (Line(points={{-40,
                    -1.22465e-015},{-42,-1.22465e-015},{-44,0},{-20,0}}, color={0,0,255}));
          connect(Capacitor1.n,IdealCommutingSwitch2. p) 
            annotation (Line(points={{20,0},{40,0}}, color={0,0,255}));
          connect(IdealCommutingSwitch2.control,BooleanPulse1. y) annotation (Line(
                  points={{50,8},{50,30},{20,30},{20,60},{11,60}}, color={255,0,255}));
          connect(IdealCommutingSwitch1.control,BooleanPulse1. y) annotation (Line(
                  points={{-50,-8},{-50,30},{20,30},{20,60},{11,60}}, color={255,0,255}));
          connect(Ground2.p,IdealCommutingSwitch2. n2) annotation (Line(points={{60,-20},
                    {60,0}}, color={0,0,255}));
          connect(IdealCommutingSwitch2.n1,n2)  annotation (Line(
                points={{60,5},{80,5},{80,2},{100,2}},
                color={0,0,255}));
          connect(n1, IdealCommutingSwitch1.n2) annotation (Line(
                points={{-102,0},{-81,0},{-81,1.22465e-015},{-60,1.22465e-015}},
                color={0,0,255}));
          connect(Ground1.p, IdealCommutingSwitch1.n1) annotation (Line(
                points={{-60,-20},{-60,-5}},
                color={0,0,255}));
        end Rn;

        model Rp "positive resistance"

          annotation (Diagram(coordinateSystem(
                    preserveAspectRatio=true, extent={{-100,-100},{100,100}}),
                                                             graphics),
            Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{100,
                      100}}), graphics={
                  Bitmap(extent={{-62,4},{-62,12}}, fileName=""),
                  Rectangle(
                    extent={{-80,30},{80,-32}},
                    pattern=LinePattern.None,
                    lineColor={0,0,255}),
                  Line(points={{-92,0},{-80,0}}, color={85,85,255}),
                  Line(points={{80,0},{92,0}}, color={85,85,255}),
                  Text(
                    extent={{-40,-40},{32,-72}},
                    lineColor={0,0,0},
                    textString="R=%R"),
                  Line(points={{-74,0},{-80,0},{-60,0}}, color={85,255,85}),
                  Line(points={{-80,-20},{-60,-20},{-60,-16},{-40,-10},{-4,-10}}, color=
                       {85,255,85}),
                  Line(points={{4,-10},{40,-10},{60,-16},{60,-20},{80,-20}}, color={85,
                        255,85}),
                  Line(points={{80,0},{60,0}}, color={85,255,85}),
                  Line(points={{60,0},{60,-4}}, color={85,255,85}),
                  Line(points={{-60,0},{-60,-6}}, color={170,255,170}),
                  Line(points={{-4,0},{-4,-20}}, color={85,255,85}),
                  Line(points={{4,0},{4,-20}}, color={85,255,85}),
                  Text(
                    extent={{-60,80},{60,40}},
                    lineColor={0,0,255},
                    textString="%name")}));
          parameter Modelica.SIunits.Time clock=1 "clock";
          parameter Modelica.SIunits.Resistance R(min=Modelica.Constants.eps)=1
              "Resistance";
          Modelica.Blocks.Sources.BooleanPulse BooleanPulse1(period=clock) 
            annotation (Placement(transformation(extent={{-10,50},{10,70}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor Capacitor1(C=clock/R) 
            annotation (Placement(transformation(extent={{-20,-20},{20,20}}, rotation=0)));
          Modelica.Electrical.Analog.Ideal.IdealCommutingSwitch
              IdealCommutingSwitch1 
            annotation (Placement(transformation(
                  origin={-50,0},
                  extent={{-10,-10},{10,10}},
                  rotation=180)));
          Modelica.Electrical.Analog.Ideal.IdealCommutingSwitch
              IdealCommutingSwitch2 
            annotation (Placement(transformation(extent={{40,-10},{60,10}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 
            annotation (Placement(transformation(
                  origin={-59,46},
                  extent={{-5,-6},{5,6}},
                  rotation=180)));
          Modelica.Electrical.Analog.Basic.Ground Ground2 
            annotation (Placement(transformation(extent={{56,-44},{66,-32}}, rotation=0)));
          Modelica.Electrical.Analog.Interfaces.NegativePin n1 
            annotation (Placement(transformation(extent={{-112,-10},{-92,10}}, rotation=
                     0)));
          Modelica.Electrical.Analog.Interfaces.NegativePin n2 
            annotation (Placement(transformation(extent={{90,-8},{110,12}}, rotation=0)));
        equation
          connect(IdealCommutingSwitch1.p, Capacitor1.p) annotation (Line(points={{-40,
                    -1.22465e-015},{-42,-1.22465e-015},{-44,0},{-20,0}}, color={0,0,255}));
          connect(Capacitor1.n, IdealCommutingSwitch2.p) 
            annotation (Line(points={{20,0},{40,0}}, color={0,0,255}));
          connect(IdealCommutingSwitch2.control, BooleanPulse1.y) annotation (Line(
                  points={{50,8},{50,30},{20,30},{20,60},{11,60}}, color={255,0,255}));
          connect(IdealCommutingSwitch1.control, BooleanPulse1.y) annotation (Line(
                  points={{-50,-8},{-50,30},{20,30},{20,60},{11,60}}, color={255,0,255}));
          connect(Ground1.p, IdealCommutingSwitch1.n2) annotation (Line(points={{-59,40},
                    {-60,40},{-60,1.22465e-015}}, color={0,0,255}));
          connect(Ground2.p, IdealCommutingSwitch2.n2) annotation (Line(points={{61,-32},
                    {60,-32},{60,0}}, color={0,0,255}));
          connect(IdealCommutingSwitch1.n1, n1) annotation (Line(points={{-60,-5},{-99,
                    -5},{-99,0},{-102,0}}, color={0,0,255}));
          connect(IdealCommutingSwitch2.n1, n2) annotation (Line(
                points={{60,5},{80,5},{80,2},{100,2}},
                color={0,0,255}));
        end Rp;
          annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-250,-200},{
                    250,200}}), graphics={Text(
                  extent={{-100,180},{94,140}},
                  textString="CauerLowPassSC",
                  lineColor={0,0,255})}),
            experiment(StopTime=60, NumberOfIntervals=1500),
            Documentation(revisions="<html>
<ul>
<li><i>January 13, 2006</i> 
       by Christoph Clauss<br>
       included into Modelica Standard Library</li>
<li><i>September 15, 2005</i>
       by by Peter Trappe designed and by Teresa Schlegel<br>
       initially modelled.</li>
</ul>
</html>",         info="<html>
The example CauerLowPassSC is a low-pass-filter of the fifth order. It is realized
using an switched-capacitor network with operational amplifiers. The voltage source V is the input voltage (step),
and the OP5.out.v is the filter output voltage. The pulse response is calculated.
<p>
This model is identical to the CauerLowPassAnalog example, but inverting. To get the same response
as that of the CauerLowPassAnalog example, a negative voltage step is used as input.
<p>
This model is identical to the CauerLowPassOPV example. But the resistors are realized by
switched capacitors. There are two such resistors Rp (of value +1), and Rn (of value -1).
In this models the switching clock source is included. In a typical switched capacitor circuit
there would be a central clock source.
<p>
The simulation end time should be 60. Please plot both V.v (which is the inverted input voltage) and OP5.p.v (output voltage). Compare this result with the CauerLowPassAnalog result.
<p>
Due to the recharging of the capacitances after switching the performance of simulation is not as good as in the CauerLowPassOPV example.
<p>
</html>"),  Icon(coordinateSystem(preserveAspectRatio=true, extent={{-250,-200},{250,
                    200}}), graphics={
                Rectangle(
                  extent={{-100,-100},{80,50}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Polygon(
                  points={{-100,50},{-80,70},{100,70},{80,50},{-100,50}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Polygon(
                  points={{100,70},{100,-80},{80,-100},{80,50},{100,70}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Text(
                  extent={{-96,3},{77,-49}},
                  lineColor={0,0,255},
                  textString="Example"),
                Text(
                  extent={{-120,132},{120,73}},
                  lineColor={255,0,0},
                  textString="%name")}));

          parameter Modelica.SIunits.Capacitance l1=1.304
            "filter coefficient i1";
          parameter Modelica.SIunits.Capacitance l2=0.8586
            "filter coefficient i2";
          parameter Modelica.SIunits.Capacitance c1=1.072
            "filter coefficient c1";
          parameter Modelica.SIunits.Capacitance c2=1/(1.704992^2*l1)
            "filter coefficient c2";
          parameter Modelica.SIunits.Capacitance c3=1.682
            "filter coefficient c3";
          parameter Modelica.SIunits.Capacitance c4=1/(1.179945^2*l2)
            "filter coefficient c4";
          parameter Modelica.SIunits.Capacitance c5=0.7262
            "filter coefficient c5";
          Modelica.Electrical.Analog.Basic.Capacitor C1(C=c1 + c2) 
            annotation (Placement(transformation(extent={{-193,30},{-173,50}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Basic.Capacitor C2(C=c2) 
            annotation (Placement(transformation(extent={{-241,-70},{-221,-50}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C3(C=l1) 
            annotation (Placement(transformation(extent={{-91,30},{-71,50}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C4(C=c4) 
            annotation (Placement(transformation(extent={{-31,50},{-11,70}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C5(C=c2) 
            annotation (Placement(transformation(extent={{-31,-100},{-11,-80}},
                  rotation=0)));
          Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin Op1 
            annotation (Placement(transformation(extent={{-201,-50},{-161,-10}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground G 
            annotation (Placement(transformation(extent={{-189,-76},{-175,-60}},
                  rotation=0)));
          Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin Op2 
            annotation (Placement(transformation(extent={{-101,-50},{-61,-10}},
                  rotation=0)));
          Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin Op3 
            annotation (Placement(transformation(extent={{5,-50},{45,-10}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground G1 
            annotation (Placement(transformation(extent={{-88,-76},{-74,-60}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Basic.Capacitor C6(C=c2 + c3 + c4) 
            annotation (Placement(transformation(extent={{8,30},{28,50}}, rotation=0)));
          Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin Op4 
            annotation (Placement(transformation(extent={{99,-50},{139,-10}}, rotation=
                    0)));
          Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin Op5 
            annotation (Placement(transformation(extent={{199,-50},{239,-10}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Basic.Capacitor C7(C=l2) 
            annotation (Placement(transformation(extent={{109,30},{129,50}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C8(C=c4) 
            annotation (Placement(transformation(extent={{159,-130},{179,-110}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C9(C=c4 + c5) 
            annotation (Placement(transformation(extent={{207,10},{227,30}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n1 
            annotation (Placement(transformation(extent={{-215,-22},{-211,-18}},
                  rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n2 
            annotation (Placement(transformation(extent={{-215,18},{-211,22}}, rotation=
                   0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n3 
            annotation (Placement(transformation(extent={{-215,38},{-211,42}}, rotation=
                   0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n4 
            annotation (Placement(transformation(
                origin={-161,40},
                extent={{2,2},{-2,-2}},
                rotation=180)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n5 
            annotation (Placement(transformation(extent={{-115,-32},{-111,-28}},
                  rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.PositivePin p1 
            annotation (Placement(transformation(extent={{-155,-122},{-149,-118}},
                  rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n6 
            annotation (Placement(transformation(extent={{-63,38},{-59,42}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n7 
            annotation (Placement(transformation(extent={{-7,-32},{-3,-28}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n8 
            annotation (Placement(transformation(extent={{-7,18},{-3,22}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.PositivePin p2 
            annotation (Placement(transformation(extent={{-7,38},{-3,42}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.PositivePin out1 
            annotation (Placement(transformation(extent={{43,-122},{47,-118}}, rotation=
                   0)));
        protected
          Modelica.Electrical.Analog.Interfaces.PositivePin p3 
            annotation (Placement(transformation(extent={{57,78},{61,82}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n9 
            annotation (Placement(transformation(extent={{85,18},{89,22}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n10 
            annotation (Placement(transformation(extent={{85,-32},{89,-28}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n11 
            annotation (Placement(transformation(extent={{137,38},{141,42}}, rotation=0)));
        public
          Modelica.Electrical.Analog.Basic.Ground G2 
            annotation (Placement(transformation(extent={{11,-76},{25,-60}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n12 
            annotation (Placement(transformation(extent={{237,58},{241,62}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n13 
            annotation (Placement(transformation(extent={{237,18},{241,22}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.PositivePin p4 
            annotation (Placement(transformation(extent={{187,18},{193,22}}, rotation=0)));
        protected
          Modelica.Electrical.Analog.Interfaces.NegativePin n14 
            annotation (Placement(transformation(extent={{187,-32},{193,-28}}, rotation=
                   0)));
        public
          Modelica.Electrical.Analog.Basic.Ground G3 
            annotation (Placement(transformation(extent={{112,-76},{126,-60}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Basic.Ground G4 
            annotation (Placement(transformation(extent={{212,-76},{226,-60}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Sources.StepVoltage V(startTime=1) 
            annotation (Placement(transformation(
                origin={-241,-150},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 
            annotation (Placement(transformation(extent={{-247,-182},{-235,-170}},
                  rotation=0)));
          Rn R4(clock=0.1) annotation (Placement(transformation(extent={{-140,-40},{
                    -120,-20}}, rotation=0)));
          Rn R5(clock=0.1) annotation (Placement(transformation(extent={{-140,-80},{
                    -120,-60}}, rotation=0)));
          Rn R8(clock=0.1) annotation (Placement(transformation(extent={{60,10},{80,30}},
                  rotation=0)));
          Rn R9(clock=0.1) annotation (Placement(transformation(extent={{60,-40},{80,
                    -20}}, rotation=0)));
          Rp R1(clock=0.1) annotation (Placement(transformation(extent={{-240,-30},{
                    -220,-10}}, rotation=0)));
          Rp R2(clock=0.1) annotation (Placement(transformation(extent={{-240,10},{-220,
                    30}}, rotation=0)));
          Rp R3(clock=0.1) annotation (Placement(transformation(extent={{-200,70},{-180,
                    90}}, rotation=0)));
          Rp Rp1(clock=0.1) annotation (Placement(transformation(extent={{-32,10},{-12,
                    30}}, rotation=0)));
          Rp R7(clock=0.1) annotation (Placement(transformation(extent={{-32,-40},{-12,
                    -20}}, rotation=0)));
          Rp R10(clock=0.1) annotation (Placement(transformation(extent={{160,-40},{180,
                    -20}}, rotation=0)));
          Rp R11(clock=0.1) annotation (Placement(transformation(extent={{208,50},{228,
                    70}}, rotation=0)));
        equation
          connect(Op1.in_p,G. p) annotation (Line(points={{-201,-40},{-201,-50},{-181,
                  -50},{-181,-60},{-182,-60}}, color={0,0,255}));
          connect(G1.p,Op2. in_p) annotation (Line(points={{-81,-60},{-81,-50},{-101,
                  -50},{-101,-40}}, color={0,0,255}));
          connect(n1,Op1. in_n) annotation (Line(points={{-213,-20},{-201,-20}}, color=
                  {0,0,255}));
          connect(C2.n,n1)  annotation (Line(points={{-221,-60},{-213,-60},{-213,-20}},
                color={0,0,255}));
          connect(n1,n2) 
            annotation (Line(points={{-213,-20},{-213,20}}, color={0,0,255}));
          connect(n2,n3) 
            annotation (Line(points={{-213,20},{-213,40}}, color={0,0,255}));
          connect(n3,C1. p) 
            annotation (Line(points={{-213,40},{-193,40}}, color={0,0,255}));
          connect(C1.n,n4) 
            annotation (Line(points={{-173,40},{-161,40}}, color={0,0,255}));
          connect(n4,Op1. out) annotation (Line(points={{-161,40},{-161,-30}}, color={0,
                  0,255}));
          connect(C5.p,Op1. out) annotation (Line(points={{-31,-90},{-161,-90},{-161,
                  -30}}, color={0,0,255}));
          connect(n5,Op2. in_n) annotation (Line(points={{-113,-30},{-113,-20},{-101,
                  -20}}, color={0,0,255}));
          connect(C3.p,n5)  annotation (Line(points={{-91,40},{-113,40},{-113,-30}},
                color={0,0,255}));
          connect(C2.p,p1)  annotation (Line(points={{-241,-60},{-241,-120},{-152,-120}},
                color={0,0,255}));
          connect(C3.n,n6) 
            annotation (Line(points={{-71,40},{-61,40}}, color={0,0,255}));
          connect(n6,Op2. out) 
            annotation (Line(points={{-61,40},{-61,-30}}, color={0,0,255}));
          connect(n7,Op3. in_n) annotation (Line(points={{-5,-30},{-5,-20},{5,-20}},
                color={0,0,255}));
          connect(C5.n,n7)  annotation (Line(points={{-11,-90},{-5,-90},{-5,-30}},
                color={0,0,255}));
          connect(n7,n8)  annotation (Line(points={{-5,-30},{-5,20}}, color={0,0,255}));
          connect(C6.p,p2) 
            annotation (Line(points={{8,40},{-5,40}}, color={0,0,255}));
          connect(n8,p2) 
            annotation (Line(points={{-5,20},{-5,40}}, color={0,0,255}));
          connect(C4.n,p2)  annotation (Line(points={{-11,60},{-5,60},{-5,40}}, color={
                  0,0,255}));
          connect(C6.n,Op3. out) annotation (Line(points={{28,40},{45,40},{45,-30}},
                color={0,0,255}));
          connect(Op3.out,out1) 
            annotation (Line(points={{45,-30},{45,-120}}, color={0,0,255}));
          connect(p1,out1)  annotation (Line(points={{-152,-120},{45,-120}}, color={0,0,
                  255}));
          connect(out1,C8. p) annotation (Line(points={{45,-120},{159,-120}}, color={0,
                  0,255}));
          connect(C4.p,p3)  annotation (Line(points={{-31,60},{-41,60},{-41,80},{59,80}},
                color={0,0,255}));
          connect(n9,n10) 
            annotation (Line(points={{87,20},{87,-30}}, color={0,0,255}));
          connect(n10,Op4. in_n) annotation (Line(points={{87,-30},{87,-20},{99,-20}},
                color={0,0,255}));
          connect(n9,C7. p) annotation (Line(points={{87,20},{87,40},{109,40}}, color={
                  0,0,255}));
          connect(C7.n,n11) 
            annotation (Line(points={{129,40},{139,40}}, color={0,0,255}));
          connect(n11,Op4. out) 
            annotation (Line(points={{139,40},{139,-30}}, color={0,0,255}));
          connect(G2.p,Op3. in_p) annotation (Line(points={{18,-60},{5,-60},{5,-40}},
                color={0,0,255}));
          connect(p3,n12)  annotation (Line(points={{59,80},{239,80},{239,60}}, color={
                  0,0,255}));
          connect(C9.n,n13) 
            annotation (Line(points={{227,20},{239,20}}, color={0,0,255}));
          connect(n12,n13) 
            annotation (Line(points={{239,60},{239,20}}, color={0,0,255}));
          connect(n13,Op5. out) 
            annotation (Line(points={{239,20},{239,-30}}, color={0,0,255}));
          connect(C9.p,p4) 
            annotation (Line(points={{207,20},{190,20}}, color={0,0,255}));
          connect(p4,n14) 
            annotation (Line(points={{190,20},{190,-30}}, color={0,0,255}));
          connect(Op5.in_n,n14)  annotation (Line(points={{199,-20},{190,-20},{190,-30}},
                color={0,0,255}));
          connect(C8.n,n14)  annotation (Line(points={{179,-120},{190,-120},{190,-30}},
                color={0,0,255}));
          connect(Op4.in_p,G3. p) annotation (Line(points={{99,-40},{99,-60},{119,-60}},
                color={0,0,255}));
          connect(Op5.in_p,G4. p) annotation (Line(points={{199,-40},{199,-60},{219,-60}},
                color={0,0,255}));
          connect(V.p, Ground1.p)            annotation (Line(points={{-241,-160},{-241,
                  -170}}, color={0,0,255}));
          connect(R4.n2, n5) annotation (Line(
              points={{-120,-29.8},{-116,-29.8},{-116,-30},{-113,-30}},
              color={0,0,255}));
          connect(Op1.out, R4.n1) annotation (Line(
              points={{-161,-30},{-140.2,-30}},
              color={0,0,255}));
          connect(R5.n1, p1) annotation (Line(
              points={{-140.2,-70},{-152,-70},{-152,-120}},
              color={0,0,255}));
          connect(R5.n2, n5) annotation (Line(
              points={{-120,-69.8},{-116,-69.8},{-116,-70},{-113,-70},{-113,-30}},
              color={0,0,255}));
          connect(p3, R8.n1) annotation (Line(
              points={{59,80},{59.8,80},{59.8,20}},
              color={0,0,255}));
          connect(R8.n2, n9) annotation (Line(
              points={{80,20.2},{84,20.2},{84,20},{87,20}},
              color={0,0,255}));
          connect(Op3.out, R9.n1) annotation (Line(
              points={{45,-30},{59.8,-30}},
              color={0,0,255}));
          connect(R9.n2, n10) annotation (Line(
              points={{80,-29.8},{84,-29.8},{84,-30},{87,-30}},
              color={0,0,255}));
          connect(R1.n1, V.n)            annotation (Line(
              points={{-240.2,-20},{-250,-20},{-250,-130},{-241,-130},{-241,-140}},
              color={0,0,255}));
          connect(R1.n2, n1) annotation (Line(
              points={{-220,-19.8},{-216,-19.8},{-216,-20},{-213,-20}},
              color={0,0,255}));
          connect(R2.n2, n2) annotation (Line(
              points={{-220,20.2},{-218,20.2},{-218,20},{-213,20}},
              color={0,0,255}));
          connect(R2.n1, n6) annotation (Line(
              points={{-240.2,20},{-240,20},{-240,100},{-61,100},{-61,40}},
              color={0,0,255}));
          connect(R3.n1, n3) annotation (Line(
              points={{-200.2,80},{-213,80},{-213,40}},
              color={0,0,255}));
          connect(R3.n2, n4) annotation (Line(
              points={{-180,80.2},{-170,80.2},{-170,80},{-161,80},{-161,40}},
              color={0,0,255}));
          connect(Rp1.n2, n8) annotation (Line(
              points={{-12,20.2},{-8,20.2},{-8,20},{-5,20}},
              color={0,0,255}));
          connect(Rp1.n1, n11) annotation (Line(
              points={{-32.2,20},{-52,20},{-52,100},{139,100},{139,40}},
              color={0,0,255}));
          connect(Op2.out, R7.n1) annotation (Line(
              points={{-61,-30},{-32.2,-30}},
              color={0,0,255}));
          connect(R7.n2, n7) annotation (Line(
              points={{-12,-29.8},{-8,-29.8},{-8,-30},{-5,-30}},
              color={0,0,255}));
          connect(R10.n1, Op4.out) annotation (Line(
              points={{159.8,-30},{139,-30}},
              color={0,0,255}));
          connect(R10.n2, n14) annotation (Line(
              points={{180,-29.8},{186,-29.8},{186,-30},{190,-30}},
              color={0,0,255}));
          connect(R11.n2, n12) annotation (Line(
              points={{228,60.2},{234,60.2},{234,60},{239,60}},
              color={0,0,255}));
          connect(R11.n1, p4) annotation (Line(
              points={{207.8,60},{190,60},{190,20}},
              color={0,0,255}));
        end CauerLowPassSC;

        model CharacteristicIdealDiodes "Characteristic of ideal diodes"
          extends Modelica.Icons.Example;

          Modelica.Electrical.Analog.Ideal.IdealDiode Ideal(
            Ron=0, Goff=0) 
            annotation (Placement(transformation(extent={{0,40},{20,60}}, rotation=0)));
          Modelica.Electrical.Analog.Ideal.IdealDiode With_Ron_Goff(
            Ron=0.1, Goff=0.1) 
            annotation (Placement(transformation(extent={{0,0},{20,20}}, rotation=0)));
          Modelica.Electrical.Analog.Ideal.IdealDiode With_Ron_Goff_Vknee(
            Ron=0.2,
            Goff=0.2,
            Vknee=5) 
            annotation (Placement(transformation(extent={{0,-40},{20,-20}}, rotation=0)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1(
            V=10,
            offset=-9) 
            annotation (Placement(transformation(
                origin={-40,0},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 
          annotation (Placement(transformation(extent={{-50,-80},{-30,-60}}, rotation=0)));

          annotation (Diagram(graphics={Text(
                  extent={{-88,102},{92,48}},
                  textString="Characteristic Ideal Diodes",
                  lineColor={0,0,255})}),          Documentation(info="<HTML>
<P>
Three examples of ideal diodes are shown:<br><br>
the <b>totally ideal diode</b> (Ideal) with all parameters to be zero <br>
the <b>nearly ideal diode</b> with <i>Ron=0.1</i> and <i>Goff=0.1</i> <br>
the nearly ideal but <b>displaced diode</b> with <i>Vknee=5</i> and <i>Ron=0.1</i> and 
<i>Goff=0.1</i> <br><br>
The resistance and conductance are chosen untypically high since the slopes should
be seen in the graphics.
</P>
<P>
Simulate until T=1 s.
</P>
<P>
Plot in separate windows:<br> <br>
Ideal.i versus Ideal.v <br>
With_Ron_Goff.i versus With_Ron_Goff.v<br>
With_Ron_Goff_Vknee.i versus With_Ron_Goff_Vknee.v<br>
</P>
 
</HTML>
",         revisions="<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Mai 7, 2004   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</html>"));
          Modelica.Electrical.Analog.Basic.Resistor R1(R=1.e-3) 
            annotation (Placement(transformation(extent={{60,40},{80,60}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R2(R=1.e-3) 
            annotation (Placement(transformation(extent={{60,0},{80,20}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R3(R=1.e-3) 
            annotation (Placement(transformation(extent={{60,-40},{80,-20}}, rotation=0)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage2(
            V=10,
            offset=0) 
            annotation (Placement(transformation(
                origin={-60,40},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage3(
            V=10,
            offset=0) 
            annotation (Placement(transformation(
                origin={-20,-40},
                extent={{-10,-10},{10,10}},
                rotation=270)));

        annotation (Documentation(info="<HTML>
<P>
Three examples of ideal diodes are shown:<br><br>
the <b>totally ideal diode</b> (Ideal) with all parameters to be zero <br>
the <b>nearly ideal diode</b> with <i>Ron=0.1</i> and <i>Goff=0.1</i> <br>
the nearly ideal but <b>displaced diode</b> with <i>Vknee=5</i> and <i>Ron=0.1</i> and 
<i>Goff=0.1</i> <br><br>
The resistance and conductance are chosen untypically high since the slopes should
be seen in the graphics.
</P>
<P>
Simulate until T=1 s.
</P>
<P>
Plot in separate windows:<br> <br>
Ideal.i versus Ideal.v <br>
With_Ron_Goff.i versus With_Ron_Goff.v<br>
With_Ron_Goff_Vknee.i versus With_Ron_Goff_Vknee.v<br>
</P>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Mai 7, 2004   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</HTML>
"),       experiment(
             StopTime=1));
        equation
          connect(Ground1.p, SineVoltage1.n) 
          annotation (Line(points={{-40,-60},{-40,-10}}, color={0,0,255}));
          connect(Ideal.n, R1.p) 
          annotation (Line(points={{20,50},{60,50}}, color={0,0,255}));
          connect(With_Ron_Goff.n, R2.p) 
          annotation (Line(points={{20,10},{60,10}}, color={0,0,255}));
          connect(With_Ron_Goff_Vknee.n, R3.p) 
          annotation (Line(points={{20,-30},{60,-30}}, color={0,0,255}));
          connect(R1.n, R2.n) 
          annotation (Line(points={{80,50},{80,10}}, color={0,0,255}));
          connect(R2.n, R3.n) 
          annotation (Line(points={{80,10},{80,-30}}, color={0,0,255}));
          connect(R3.n, Ground1.p) 
          annotation (Line(points={{80,-30},{80,-60},{-40,-60}}, color={0,0,255}));
          connect(SineVoltage2.p, Ideal.p) 
          annotation (Line(points={{-60,50},{0,50}}, color={0,0,255}));
          connect(SineVoltage2.n, Ground1.p) 
          annotation (Line(points={{-60,30},{-60,-60},{-40,-60}}, color={0,0,255}));
          connect(SineVoltage1.p,With_Ron_Goff. p) 
          annotation (Line(points={{-40,10},{0,10}}, color={0,0,255}));
          connect(With_Ron_Goff_Vknee.p, SineVoltage3.p) 
          annotation (Line(points={{0,-30},{-20,-30}}, color={0,0,255}));
          connect(SineVoltage3.n, Ground1.p) 
          annotation (Line(points={{-20,-50},{-20,-60},{-40,-60}}, color={0,0,255}));
        end CharacteristicIdealDiodes;

        model CharacteristicThyristors "Characteristic of ideal thyristors"

          extends Modelica.Icons.Example;

          Modelica.Electrical.Analog.Ideal.IdealThyristor IdealThyristor1(
                            Vknee=5) 
                                   annotation (Placement(transformation(extent={{-20,0},
                    {0,20}}, rotation=0)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1(V=10,
              offset=0) 
                      annotation (Placement(transformation(
                origin={-40,-10},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 
          annotation (Placement(transformation(extent={{-50,-60},{-30,-40}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R3(R=1.e-3) 
          annotation (Placement(transformation(extent={{40,0},{60,20}}, rotation=0)));

        annotation (Diagram(graphics={Text(
                  extent={{-96,100},{98,60}},
                  textString="Characteristic Thyristors",
                  lineColor={0,0,255})}),        Documentation(info="<HTML>
<P>
Two examples of thyristors are shown:<br><br>
the <b>ideal thyristor</b>  <br>
and the <b>ideal GTO thyristor</b>  with <i>Vknee=5</i>  <br><br>
</P>
<P>
Simulate until T=2 s.
</P>
<P>
Plot in separate windows:<br> <br>
IdealThyristor1.i and IdealGTOThyristor1.i <br>
IdealThyristor1.v and IdealGTOThyristor1.v <br>
</P>
 
</HTML>
",         revisions="<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Mai 7, 2004   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</html>"));
          Modelica.Blocks.Sources.BooleanStep BooleanStep1(startValue=false,
              startTime=1.25) annotation (Placement(transformation(extent={{-60,40},{
                    -40,60}}, rotation=0)));
          Modelica.Electrical.Analog.Ideal.IdealGTOThyristor IdealGTOThyristor1
            (                  Vknee=0) 
                                      annotation (Placement(transformation(extent={{-20,
                    -30},{0,-10}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R1(R=1.e-3) 
          annotation (Placement(transformation(extent={{40,-30},{60,-10}}, rotation=0)));

        annotation (Documentation(info="<HTML>
<P>
Two examples of thyristors are shown:<br><br>
the <b>ideal thyristor</b>  <br>
and the <b>ideal GTO thyristor</b>  with <i>Vknee=5</i>  <br><br>
</P>
<P>
Simulate until T=2 s.
</P>
<P>
Plot in separate windows:<br> <br>
IdealThyristor1.i and IdealGTOThyristor1.i <br>
IdealThyristor1.v and IdealGTOThyristor1.v <br>
</P>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Mai 7, 2004   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</HTML>
"),       experiment(
             StopTime=2));
        equation
          connect(IdealThyristor1.n, R3.p) 
          annotation (Line(points={{0,10},{40,10}}, color={0,0,255}));
          connect(Ground1.p, SineVoltage1.n) 
          annotation (Line(points={{-40,-40},{-40,-20}}, color={0,0,255}));
          connect(SineVoltage1.p, IdealThyristor1.p) 
          annotation (Line(points={{-40,0},{-40,10},{-20,10}}, color={0,0,255}));
          connect(BooleanStep1.y, IdealThyristor1.fire) 
          annotation (Line(points={{-39,50},{-3,50},{-3,21}}, color={255,0,255}));
          connect(IdealGTOThyristor1.n, R1.p) 
          annotation (Line(points={{0,-20},{40,-20}}, color={0,0,255}));
          connect(R3.n, R1.n) 
          annotation (Line(points={{60,10},{60,-20}}, color={0,0,255}));
          connect(R1.n, Ground1.p) 
          annotation (Line(points={{60,-20},{60,-40},{-40,-40}}, color={0,0,255}));
          connect(IdealGTOThyristor1.p, IdealThyristor1.p) 
          annotation (Line(points={{-20,-20},{-20,10}}, color={0,0,255}));
          connect(IdealGTOThyristor1.fire, IdealThyristor1.fire) 
          annotation (Line(points={{-3,-9},{-3,-2.5},{-2,-2.5},{-2,5},{-3,5},{-3,21}},
                color={255,0,255}));
        end CharacteristicThyristors;

        encapsulated model ChuaCircuit "Chua's circuit, ns, V, A"
          import Modelica.Electrical.Analog.Basic;
          import Modelica.Electrical.Analog.Examples.Utilities;
          import Modelica.Icons;
          extends Icons.Example;

          annotation (
            Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics),
            Documentation(info="<html>
<p>
 Chua's circuit is the most simple nonlinear circuit which shows chaotic behaviour. The circuit consists of linear basic elements (capacitors, resistor, conductor, inductor), and one nonlinear element, which is called Chua's diode. The chaotic behaviour is simulated.
<p>
The simulation end time should be set to 5e4. To get the chaotic behaviour please plot C1.v. Choose C2.v as the independent variable.
<p>
<dl>
<dt>
<b>Reference:</b>
<dd>
Kennedy, M.P.: Three Steps to Chaos - Part I: Evolution. IEEE Transactions on CAS I 40 (1993)10, 640-656
</dd>
</dl>
 
</HTML>
",         revisions="<html>
<dt>
<b>Main Authors:</b>
<dd>
<a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
    &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
    <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
    &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
    Fraunhofer Institute for Integrated Circuits<br>
    Design Automation Department<br>
    Zeunerstra&szlig;e 38<br>
    D-01069 Dresden<br>
<p>
<dt>
<b>Copyright:</b>
<dd>
Copyright &copy; 1998-2006, Modelica Association and Fraunhofer-Gesellschaft.<br>
<i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b> in the documentation of package
Modelica in file \"Modelica/package.mo\".</i><br>
<p>
</dl>
</html>"),  experiment(StopTime=1));
          Basic.Inductor L(L=18) annotation (Placement(transformation(
                origin={-75,50},
                extent={{-25,-25},{25,25}},
                rotation=270)));
          Basic.Resistor Ro(R=12.5e-3) annotation (Placement(transformation(
                origin={-75,-5},
                extent={{-25,-25},{25,25}},
                rotation=270)));
          Basic.Conductor G(G=0.565) annotation (Placement(transformation(extent={{-25,
                    50},{25,100}}, rotation=0)));
          Basic.Capacitor C1(C=10, v(start=4)) annotation (Placement(transformation(
                origin={25,15},
                extent={{-25,-25},{25,25}},
                rotation=270)));
          Basic.Capacitor C2(C=100) annotation (Placement(transformation(
                origin={-25,15},
                extent={{-25,-25},{25,25}},
                rotation=270)));
          Utilities.NonlinearResistor Nr(
            Ga(min=-1) = -0.757576,
            Gb(min=-1) = -0.409091,
            Ve=1) annotation (Placement(transformation(
                origin={75,15},
                extent={{-25,-25},{25,25}},
                rotation=270)));
          Basic.Ground Gnd annotation (Placement(transformation(extent={{-25,-100},{25,
                    -50}}, rotation=0)));
        equation
          connect(L.p, G.p) annotation (Line(points={{-75,75},{-25,75}}));
          connect(G.n, Nr.p) annotation (Line(points={{25,75},{75,75},{75,40}}));
          connect(Nr.n, Gnd.p) annotation (Line(points={{75,-10},{75,-50},{0,-50}}));
          connect(C1.p, G.n) annotation (Line(points={{25,40},{25,75}}));
          connect(L.n, Ro.p) annotation (Line(points={{-75,25},{-75,20}}));
          connect(G.p, C2.p) annotation (Line(points={{-25,75},{-25,40}}));
          connect(C1.n, Gnd.p) annotation (Line(points={{25,-10},{25,-50},{0,-50}}));
          connect(C2.n, Gnd.p) annotation (Line(points={{-25,-10},{-25,-50},{0,-50}}));
          connect(Ro.n, Gnd.p) annotation (Line(points={{-75,-30},{-75,-50},{0,-50}}));
        end ChuaCircuit;

        encapsulated model DifferenceAmplifier
          "Simple NPN transistor amplifier circuit"
          import Modelica.Electrical.Analog.Basic;
          import Modelica.Electrical.Analog.Sources;
          import Modelica.Electrical.Analog.Examples.Utilities;
          import Modelica.Icons;
          extends Icons.Example;

          annotation (
            Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics),
            Documentation(info="<html>
<p>
It is a simple NPN transistor amplifier circuit. The voltage difference between R1.p and R3.n is amplified. The output signal is the voltage between R2.n and R4.n. In this example the voltage at V1 is amplified because R3.n is grounded.
<p>
The simulation end time should be set to 1e- 8. Please plot the input voltage V1.v, and the output voltages R2.n.v, and R4.n.v.
<p>
<dl>
<dt>
<b>Reference:</b>
<dd>
Tietze, U.; Schenk, Ch.: Halbleiter-Schaltungstechnik. Springer-Verlag Berlin Heidelberg NewYork 1980, p. 59
</dd>
</dl>
 
</HTML>
",         revisions="<html>
<dl>
<dt>
<b>Main Authors:</b>
<dd>
<a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
    &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
    <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
    &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
    Fraunhofer Institute for Integrated Circuits<br>
    Design Automation Department<br>
    Zeunerstra&szlig;e 38<br>
    D-01069 Dresden<br>
<p>
<dt>
<b>Copyright:</b>
<dd>
Copyright &copy; 1998-2006, Modelica Association and Fraunhofer-Gesellschaft.<br>
<i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b> in the documentation of package
Modelica in file \"Modelica/package.mo\".</i><br>
<p>
</dl>
</html>"),  experiment(StopTime=1));
          Sources.ExpSineVoltage V1(
            V=0.2,
            freqHz=0.2e9,
            damping=0.1e8) annotation (Placement(transformation(
                origin={-90,-50},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Sources.RampVoltage V2(V=15, duration=1e-9) annotation (Placement(
                transformation(
                origin={80,50},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Sources.RampCurrent I1(I=0.16, duration=1e-9) annotation (Placement(
                transformation(
                origin={-10,-50},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Basic.Resistor R1(R=0.0001) annotation (Placement(transformation(extent={{-90,
                    -20},{-70,0}}, rotation=0)));
          Basic.Resistor R2(R=100) annotation (Placement(transformation(
                origin={-40,30},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Basic.Resistor R3(R=0.0001) annotation (Placement(transformation(extent={{70,
                    -20},{90,0}}, rotation=0)));
          Basic.Resistor R4(R=100) annotation (Placement(transformation(
                origin={40,30},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Basic.Capacitor C1(C=1e-10) annotation (Placement(transformation(
                origin={-60,-50},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Basic.Capacitor C4(C=1e-10) annotation (Placement(transformation(extent={{10,
                    -14},{30,6}}, rotation=0)));
          Basic.Capacitor C5(C=1e-10) annotation (Placement(transformation(
                origin={10,-50},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Basic.Capacitor C2(C=1e-10) annotation (Placement(transformation(extent={{-30,
                    -14},{-10,6}}, rotation=0)));
          Basic.Capacitor C3(C=1e-10) annotation (Placement(transformation(
                origin={60,-50},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Basic.Ground Gnd1 annotation (Placement(transformation(extent={{-95,-80},{-85,
                    -70}}, rotation=0)));
          Basic.Ground Gnd9 annotation (Placement(transformation(extent={{75,20},{85,30}},
                  rotation=0)));
          Basic.Ground Gnd3 annotation (Placement(transformation(extent={{-15,-20},{-5,
                    -10}}, rotation=0)));
          Basic.Ground Gnd2 annotation (Placement(transformation(extent={{-65,-80},{-55,
                    -70}}, rotation=0)));
          Basic.Ground Gnd6 annotation (Placement(transformation(extent={{5,-20},{15,
                    -10}}, rotation=0)));
          Basic.Ground Gnd7 annotation (Placement(transformation(extent={{-15,-80},{-5,
                    -70}}, rotation=0)));
          Basic.Ground Gnd8 annotation (Placement(transformation(extent={{5,-80},{15,
                    -70}}, rotation=0)));
          Basic.Ground Gnd5 annotation (Placement(transformation(extent={{55,-80},{65,
                    -70}}, rotation=0)));
          Basic.Ground Gnd4 annotation (Placement(transformation(extent={{85,-50},{95,
                    -40}}, rotation=0)));
          Utilities.Transistor Transistor1 annotation (Placement(transformation(extent=
                    {{-60,-20},{-40,0}}, rotation=0)));
          Utilities.Transistor Transistor2 annotation (Placement(transformation(extent=
                    {{60,-20},{40,0}}, rotation=0)));
        equation
          connect(V1.n, Gnd1.p) annotation (Line(points={{-90,-60},{-90,-70}}));
          connect(C1.n, Gnd2.p) annotation (Line(points={{-60,-60},{-60,-70}}));
          connect(I1.n, Gnd7.p) annotation (Line(points={{-10,-60},{-10,-70}}));
          connect(C5.n, Gnd8.p) annotation (Line(points={{10,-60},{10,-70}}));
          connect(C3.n, Gnd5.p) annotation (Line(points={{60,-60},{60,-70}}));
          connect(R3.n, Gnd4.p) annotation (Line(points={{90,-10},{90,-40}}));
          connect(C2.n, Gnd3.p) annotation (Line(points={{-10,-4},{-10,-10}}));
          connect(C4.p, Gnd6.p) annotation (Line(points={{10,-4},{10,-10}}));
          connect(I1.p, C5.p) annotation (Line(points={{-10,-40},{10,-40}}));
          connect(R1.p, V1.p) annotation (Line(points={{-90,-10},{-90,-40}}));
          connect(R2.p, V2.p) annotation (Line(points={{-40,40},{-40,70},{80,70},{80,60}}));
          connect(R4.p, V2.p) annotation (Line(points={{40,40},{40,70},{80,70},{80,60}}));
          connect(V2.n, Gnd9.p) annotation (Line(points={{80,40},{80,30}}));
          connect(R1.n, Transistor1.b) annotation (Line(points={{-70,-10},{-60,-10}}));
          connect(Transistor1.b, C1.p) annotation (Line(points={{-60,-10},{-60,-40}}));
          connect(Transistor1.c, C2.p) annotation (Line(points={{-40,-4},{-30,-4}}));
          connect(R2.n, Transistor1.c) annotation (Line(points={{-40,20},{-40,-4}}));
          connect(Transistor1.e, I1.p) annotation (Line(points={{-40,-16},{-30,-16},{
                  -30,-40},{-10,-40}}));
          connect(Transistor2.b, R3.p) annotation (Line(points={{60,-10},{70,-10}}));
          connect(Transistor2.b, C3.p) annotation (Line(points={{60,-10},{60,-40}}));
          connect(C4.n, Transistor2.c) annotation (Line(points={{30,-4},{40,-4}}));
          connect(R4.n, Transistor2.c) annotation (Line(points={{40,20},{40,-4}}));
          connect(C5.p, Transistor2.e) annotation (Line(points={{10,-40},{30,-40},{30,
                  -16},{40,-16}}));
        end DifferenceAmplifier;

        model HeatingMOSInverter "Heating MOS Inverter"
          extends Modelica.Icons.Example;
          Modelica.Electrical.Analog.Basic.Ground G 
          annotation (Placement(transformation(extent={{-80,-40},{-60,-20}}, rotation=0)));
          Modelica.Electrical.Analog.Sources.SineVoltage Sin(V=5) 
          annotation (Placement(transformation(
                origin={-70,0},
                extent={{-10,-10},{10,10}},
                rotation=270)));

        annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-100,100},{-6,72}},
                  textString="Heating MOS Inverter",
                  lineColor={0,0,255})}),   Documentation(info="<HTML>
<P>
The heating MOS inverter shows a heat flow always if a transistor is leading.
</P>
<P>
Simulate until T=5 s.
</P>
<P>
Plot in separate windows:<br> <br>
Sin.p.v  and  Capacitor1.p.v <br>
HeatCapacitor1.port.T and H_PMOS.heatPort.T and H_NMOS.heatPort.T<br>
H_PMOS.heatPort.Q_flow and H_NMOS.heatPort.Q_flow<br>
</P>
 
</HTML>
",         revisions="<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Mai 6, 2004   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</html>"));
          Modelica.Electrical.Analog.Basic.Capacitor Capacitor1(C=0.00001) 
          annotation (Placement(transformation(
                origin={30,10},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Thermal.HeatTransfer.Components.HeatCapacitor HeatCapacitor1
            (                                                                   C=0.01) 
          annotation (Placement(transformation(
                origin={70,-60},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Thermal.HeatTransfer.Components.ThermalConductor TC1(G=0.01) 
          annotation (Placement(transformation(extent={{0,-50},{20,-30}}, rotation=0)));
          Semiconductors.HeatingPMOS H_PMOS 
          annotation (Placement(transformation(extent={{-40,40},{-20,60}}, rotation=0)));
          Semiconductors.HeatingNMOS H_NMOS 
          annotation (Placement(transformation(extent={{-40,0},{-20,20}}, rotation=0)));
          Modelica.Electrical.Analog.Sources.RampVoltage V(V=5, duration=1.e-2) 
          annotation (Placement(transformation(
                origin={50,50},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Thermal.HeatTransfer.Components.ThermalConductor TC2(G=0.01) 
          annotation (Placement(transformation(extent={{0,-90},{20,-70}}, rotation=0)));
          Modelica.Thermal.HeatTransfer.Sources.FixedTemperature
            FixedTemperature1(                                                     T=
                300) 
                   annotation (Placement(transformation(
                origin={90,-30},
                extent={{-10,-10},{10,10}},
                rotation=180)));
          Modelica.Thermal.HeatTransfer.Components.ThermalConductor TC3(G=0.01) 
          annotation (Placement(transformation(extent={{50,-40},{70,-20}}, rotation=0)));
        equation
          connect(Sin.n, G.p) 
          annotation (Line(points={{-70,-10},{-70,-20}}, color={0,0,255}));
          connect(Capacitor1.n, G.p) 
          annotation (Line(points={{30,0},{30,-20},{-70,-20}}, color={0,0,255}));
        annotation (Documentation(info="<HTML>
<P>
The heating MOS inverter shows a heat flow always if a transistor is leading.
</P>
<P>
Simulate until T=5 s.
</P>
<P>
Plot in separate windows:<br> <br>
Sin.p.v  and  Capacitor1.p.v <br>
HeatCapacitor1.port.T and H_PMOS.heatPort.T and H_NMOS.heatPort.T<br>
H_PMOS.heatPort.Q_flow and H_NMOS.heatPort.Q_flow<br>
</P>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Mai 6, 2004   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</HTML>
"),       experiment(
             StopTime=5));
          connect(H_NMOS.G, H_PMOS.G) 
          annotation (Line(points={{-40,5},{-40,45}}, color={0,0,255}));

          connect(H_NMOS.G, Sin.p) 
          annotation (Line(points={{-40,5},{-40,10},{-70,10}}, color={0,0,255}));
          connect(H_PMOS.S, H_NMOS.D) 
          annotation (Line(points={{-20,45},{-20,15}}, color={0,0,255}));
          connect(H_NMOS.D, Capacitor1.p) 
          annotation (Line(points={{-20,15},{-20,20},{30,20}}, color={0,0,255}));
          connect(H_NMOS.B, H_NMOS.S) 
          annotation (Line(points={{-20,10},{-20,5}}, color={0,0,255}));
          connect(H_NMOS.S, G.p) 
          annotation (Line(points={{-20,5},{-20,-20},{-70,-20}}, color={0,0,255}));
          connect(H_PMOS.B, H_PMOS.D) 
          annotation (Line(points={{-20,50},{-20,55}}, color={0,0,255}));
          connect(V.p, H_PMOS.D) 
          annotation (Line(points={{50,60},{-20,60},{-20,55}}, color={0,0,255}));
          connect(V.n, G.p) 
          annotation (Line(points={{50,40},{50,-20},{-70,-20}}, color={0,0,255}));
          connect(TC1.port_b, HeatCapacitor1.port) 
                                                 annotation (Line(points={{20,-40},{40,
                  -40},{40,-60},{60,-60}}, color={191,0,0}));
          connect(TC2.port_b, HeatCapacitor1.port) 
                                                 annotation (Line(points={{20,-80},{40,
                  -80},{40,-60},{60,-60}}, color={191,0,0}));
          connect(TC1.port_a, H_PMOS.heatPort) 
                                             annotation (Line(points={{0,-40},{-10,-40},
                  {-10,40},{-30,40}}, color={191,0,0}));
          connect(TC2.port_a, H_NMOS.heatPort) 
          annotation (Line(points={{0,-80},{-30,-80},{-30,0}}, color={191,0,0}));
          connect(TC3.port_b, FixedTemperature1.port) 
                                                    annotation (Line(points={{70,-30},{
                  80,-30}},                   color={191,0,0}));
          connect(TC3.port_a, HeatCapacitor1.port) 
                                                 annotation (Line(points={{50,-30},{40,
                  -30},{40,-60},{60,-60}}, color={191,0,0}));
        end HeatingMOSInverter;

        model HeatingNPN_OrGate "Heating NPN Or Gate"
          extends Modelica.Icons.Example;
          constant Modelica.SIunits.Capacitance CapVal=0;
          constant Modelica.SIunits.Time tauVal=0;

        annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-100,100},{-6,72}},
                  textString="Heating \"NPN or\" Gate",
                  lineColor={0,0,255})}),    Documentation(info="<HTML>
<P>
The heating \"NPN or\" gate shows a heat flow always if a transistor is leading.
</P>
<P>
Simulate until T=200 s.
</P>
<P>
Plot in separate windows:<br> <br>
V1.v and V2.v and C2.v <br>
HeatCapacitor1.port.T and T1.heatPort.T and T2.heatPort.T<br>
T1.heatPort.Q_flow and T2.heatPort.Q_flow<br>
</P>
 
</HTML>
",         revisions="<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Mai 6, 2004   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</html>"));
          Modelica.Thermal.HeatTransfer.Components.HeatCapacitor HeatCapacitor1
            (                                                                   C=0.1) 
          annotation (Placement(transformation(
                origin={76,-84},
                extent={{-10,-10},{10,10}},
                rotation=180)));
          Modelica.Thermal.HeatTransfer.Components.ThermalConductor TC1(G=0.01) 
          annotation (Placement(transformation(
                origin={90,-50},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Thermal.HeatTransfer.Components.ThermalConductor TC2(G=0.01) 
          annotation (Placement(transformation(
                origin={60,-50},
                extent={{-10,-10},{10,10}},
                rotation=270)));

        annotation (Documentation(info="<HTML>
<P>
The heating NPN nand gate shows a heat flow always if a transistor is leading.
</P>
<P>
Simulate until T=200 s.
</P>
<P>
Plot in separate windows:<br> <br>
V1.v and V2.v and C2.v <br>
HeatCapacitor1.port.T and T1.heatPort.T and T2.heatPort.T<br>
T1.heatPort.Q_flow and T2.heatPort.Q_flow<br>
</P>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Mai 6, 2004   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</HTML>
"),       experiment(
             StopTime=200));
          Modelica.Electrical.Analog.Sources.RampVoltage V(V=6, duration=5) 
          annotation (Placement(transformation(
                origin={90,38},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Sources.TrapezoidVoltage V1(
            V=6,
            startTime=55,
            rising=5,
            width=15,
            falling=5,
            period=50,
            nperiod=10) 
                      annotation (Placement(transformation(
                origin={-90,18},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Sources.TrapezoidVoltage V2(
            V=6,
            startTime=65,
            rising=5,
            width=15,
            falling=5,
            period=50,
            nperiod=10) 
                      annotation (Placement(transformation(
                origin={-50,-42},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Resistor R1(R=1800) 
          annotation (Placement(transformation(extent={{-90,48},{-70,68}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R2(R=1800) 
          annotation (Placement(transformation(extent={{-36,-22},{-16,-2}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor RI(R=40) 
          annotation (Placement(transformation(extent={{60,58},{80,78}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd 
          annotation (Placement(transformation(extent={{80,0},{100,20}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd1 
          annotation (Placement(transformation(extent={{-100,-22},{-80,-2}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd2 
          annotation (Placement(transformation(extent={{-60,-82},{-40,-62}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd3 
          annotation (Placement(transformation(extent={{-10,16},{10,36}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd4 
          annotation (Placement(transformation(extent={{30,-52},{50,-32}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Capacitor C1(C=CapVal) 
          annotation (Placement(transformation(
                origin={-70,38},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Capacitor C2(C=CapVal) 
          annotation (Placement(transformation(
                origin={60,42},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Capacitor C3(C=CapVal) 
          annotation (Placement(transformation(
                origin={-16,-40},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Ground Gnd5 
          annotation (Placement(transformation(extent={{-26,-76},{-6,-56}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd6 
          annotation (Placement(transformation(extent={{50,6},{70,26}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd7 
          annotation (Placement(transformation(extent={{-80,2},{-60,22}}, rotation=0)));
          Semiconductors.HeatingNPN T1(
            Bf=100,
            Br=1,
            Is=1.e-14,
            Vak=0,
            Tauf=tauVal,
            Taur=tauVal,
            Ccs=CapVal,
            Cje=CapVal,
            Cjc=CapVal,
            Phie=1,
            Me=0.5,
            Phic=1,
            Mc=0.5,
            Gbc=1.e-12,
            Gbe=1.e-12,
            EMax=40,
            vt_t(start=0.01, fixed=false)) 
                   annotation (Placement(transformation(extent={{-20,48},{0,68}},
                  rotation=0)));
          Semiconductors.HeatingNPN T2(
            Bf=100,
            Br=1,
            Is=1.e-14,
            Vak=0,
            Tauf=tauVal,
            Taur=tauVal,
            Ccs=CapVal,
            Cje=CapVal,
            Cjc=CapVal,
            Phie=1,
            Me=0.5,
            Phic=1,
            Mc=0.5,
            Gbc=1.e-12,
            Gbe=1.e-12,
            EMax=40,
            vt_t(start=0.01, fixed=false)) 
                   annotation (Placement(transformation(extent={{20,-22},{40,-2}},
                  rotation=0)));
        equation
          connect(Gnd1.p, V1.n) 
                              annotation (Line(points={{-90,-2},{-90,8}}));
          connect(V1.p, R1.p) 
                            annotation (Line(points={{-90,28},{-90,58}}));
          connect(RI.n, V.p) 
                           annotation (Line(points={{80,68},{90,68},{90,48}}));
          connect(Gnd.p, V.n) 
                            annotation (Line(points={{90,20},{90,28}}));
          connect(V2.p, R2.p) 
          annotation (Line(points={{-50,-32},{-50,-12},{-36,-12}}));
          connect(Gnd2.p, V2.n) 
                              annotation (Line(points={{-50,-62},{-50,-52}}));
          connect(Gnd7.p, C1.n) 
                              annotation (Line(points={{-70,22},{-70,28}}));
          connect(C2.p, RI.p) 
                            annotation (Line(points={{60,52},{60,68}}));
          connect(Gnd6.p, C2.n) 
                              annotation (Line(points={{60,26},{60,32}}));
          connect(C3.p, R2.n) 
          annotation (Line(points={{-16,-30},{-16,-21},{-16,-21},{-16,-12}}));
          connect(C1.p, R1.n) 
                            annotation (Line(points={{-70,48},{-70,58}}));
          connect(Gnd5.p, C3.n) 
          annotation (Line(points={{-16,-56},{-16,-53},{-16,-50},{-16,-50}}));
          connect(T1.B, R1.n) 
          annotation (Line(points={{-20,58},{-70,58}}, color={0,0,255}));
          connect(T1.E, Gnd3.p) 
          annotation (Line(points={{0,53},{0,36}}, color={0,0,255}));
          connect(RI.p, T1.C) 
                            annotation (Line(points={{60,68},{30,68},{30,63},{0,63}},
                color={0,0,255}));
          connect(T2.B, R2.n) 
          annotation (Line(points={{20,-12},{-16,-12}}, color={0,0,255}));
          connect(T2.E, Gnd4.p) 
          annotation (Line(points={{40,-17},{40,-32}}, color={0,0,255}));
          connect(T2.C, RI.p) 
          annotation (Line(points={{40,-7},{40,68},{60,68}}, color={0,0,255}));
          connect(TC1.port_b, HeatCapacitor1.port) 
                                                 annotation (Line(points={{90,-60},{84,
                  -60},{84,-74},{76,-74}}, color={191,0,0}));
          connect(TC2.port_b, HeatCapacitor1.port) 
                                                 annotation (Line(points={{60,-60},{68,
                  -60},{68,-74},{76,-74}}, color={191,0,0}));
          connect(TC2.port_a, T2.heatPort) 
          annotation (Line(points={{60,-40},{60,-22},{30,-22}}, color={191,0,0}));
          connect(TC1.port_a, T1.heatPort) 
                                         annotation (Line(points={{90,-40},{90,2},{-10,
                  2},{-10,48}}, color={191,0,0}));
        end HeatingNPN_OrGate;

        model HeatingRectifier "Heating rectifier"
          extends Modelica.Icons.Example;
          Modelica.Electrical.Analog.Semiconductors.HeatingDiode HeatingDiode1 
                        annotation (Placement(transformation(extent={{-20,40},{0,60}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground G 
          annotation (Placement(transformation(extent={{-80,0},{-60,20}}, rotation=0)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1 
          annotation (Placement(transformation(
                origin={-70,40},
                extent={{-10,-10},{10,10}},
                rotation=270)));

        annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={Text(
                  extent={{-94,102},{0,74}},
                  textString="HeatingRectifier",
                  lineColor={0,0,255})}),
                                        Documentation(info="<HTML>
<P>
The heating rectifier shows a heat flow always if the electrical capacitor is loaded.
</P>
<P>
Simulate until T=5 s.
</P>
<P>
Plot in separate windows:<br> <br>
SineVoltage1.v  and  Capacitor1.p.v <br>
HeatCapacitor1.port.T and HeatingDiode1.heatPort.T<br>
HeatingDiode1.heatPort.Q_flow<br>
</P>
 
</HTML>
",         revisions="<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Mai 6, 2004   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</html>"));
          Modelica.Electrical.Analog.Basic.Capacitor Capacitor1 
          annotation (Placement(transformation(extent={{20,40},{40,60}}, rotation=0)));
          Modelica.Thermal.HeatTransfer.Components.HeatCapacitor HeatCapacitor1
            (                                                                   C=1) 
          annotation (Placement(transformation(
                origin={-10,-50},
                extent={{-10,-10},{10,10}},
                rotation=180)));
          Modelica.Thermal.HeatTransfer.Components.ThermalConductor
            ThermalConductor1(                                                        G=10) 
          annotation (Placement(transformation(
                origin={-10,-10},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Resistor R(R=1) 
          annotation (Placement(transformation(extent={{20,70},{40,90}}, rotation=0)));
        equation
          connect(SineVoltage1.p, HeatingDiode1.p) 
          annotation (Line(points={{-70,50},{-20,50}}, color={0,0,255}));
          connect(SineVoltage1.n, G.p) 
          annotation (Line(points={{-70,30},{-70,20}}, color={0,0,255}));
          connect(Capacitor1.n, G.p) 
          annotation (Line(points={{40,50},{40,20},{-70,20}}, color={0,0,255}));
          connect(HeatingDiode1.n, Capacitor1.p) 
          annotation (Line(points={{0,50},{20,50}}, color={0,0,255}));
          connect(HeatingDiode1.heatPort, ThermalConductor1.port_a) 
                                                                  annotation (Line(
                points={{-10,40},{-10,20.5},{-10,0},{-10,0}}, color={191,0,0}));
          connect(ThermalConductor1.port_b, HeatCapacitor1.port) 
                                                               annotation (Line(points={{-10,-20},
                  {-10,-25.75},{-10,-25.75},{-10,-30.5},{-10,-40},{-10,-40}},
                color={191,0,0}));
          connect(R.p, Capacitor1.p) 
          annotation (Line(points={{20,80},{20,50}}, color={0,0,255}));
          connect(R.n, Capacitor1.n) 
          annotation (Line(points={{40,80},{40,50}}, color={0,0,255}));
        annotation (Documentation(info="<HTML>
<P>
The heating rectifier shows a heat flow always if the electrical capacitor is loaded.
</P>
<P>
Simulate until T=5 s.
</P>
<P>
Plot in separate windows:<br> <br>
SineVoltage1.v  and  Capacitor1.p.v <br>
HeatCapacitor1.port.T and HeatingDiode1.heatPort.T<br>
HeatingDiode1.heatPort.Q_flow<br>
</P>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Mai 6, 2004   </i>
       by Christoph Clauss<br> realized<br>
       </li>
</ul>
</HTML>
"),       experiment(
             StopTime=5));

        end HeatingRectifier;

        encapsulated model NandGate
          "CMOS NAND Gate (see Tietze/Schenk, page 157)"
          import Modelica.Electrical.Analog.Basic;
          import Modelica.Electrical.Analog.Sources;
          import Modelica.Electrical.Analog.Examples.Utilities;
          import Modelica.Icons;
          extends Icons.Example;

          annotation (
            Icon(graphics),
            Documentation(info="<html>
<p>
The nand gate is a basic CMOS building block. It consists of four CMOS transistors.
The output voltage Nand.y.v is low if and only if the two input voltages at Nand.x1.v and Nand.x2.v
are both high. In this way the nand functionality is realized.
<p>
The simulation end time should be set to 1e-7. Please plot the input voltages Nand.x1.v,
d Nand.x2.v, and the output voltage Nand.y.v.
<p>
<dl>
<dt>
<b>Reference:</b>
<dd>
Tietze, U.; Schenk, Ch.: Halbleiter-Schaltungstechnik. Springer-Verlag Berlin Heidelberg NewYork 1980, p. 157
<p>
</dd>
</dl>
</HTML>
",         revisions="<html>
<dl>
<dt>
<b>Main Authors:</b>
<dd>
<a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
    &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
    <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
    &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
    Fraunhofer Institute for Integrated Circuits<br>
    Design Automation Department<br>
    Zeunerstra&szlig;e 38<br>
    D-01069 Dresden<br>
<p>
<dt>
<b>Copyright:</b>
<dd>
Copyright &copy; 1998-2006, Modelica Association and Fraunhofer-Gesellschaft.<br>
<i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b> in the documentation of package
Modelica in file \"Modelica/package.mo\".</i><br>
<p>
</dl>
</html>"),  experiment(StopTime=1e-007));
          Sources.TrapezoidVoltage VIN1(
            V=3.5,
            startTime=20e-9,
            rising=1e-9,
            width=19e-9,
            falling=1.e-9,
            period=40e-9) annotation (Placement(transformation(
                origin={-70,20},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Sources.TrapezoidVoltage VIN2(
            V=3.5,
            startTime=10e-9,
            rising=1e-9,
            width=19e-9,
            falling=1.e-9,
            period=40e-9) annotation (Placement(transformation(
                origin={-70,-30},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Sources.RampVoltage VDD(V=5, duration=1e-9) annotation (Placement(
                transformation(
                origin={50,70},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Basic.Ground Gnd1 annotation (Placement(transformation(extent={{45,43},{55,53}},
                  rotation=0)));
          Basic.Ground Gnd4 annotation (Placement(transformation(extent={{-75,-5},{-65,
                    5}}, rotation=0)));
          Basic.Ground Gnd5 annotation (Placement(transformation(extent={{-75,-55},{-65,
                    -45}}, rotation=0)));
          Utilities.Nand Nand annotation (Placement(transformation(extent={{-40,-45},{
                    40,55}}, rotation=0)));
        equation
          connect(VDD.n, Gnd1.p) annotation (Line(points={{50,60},{50,53}}));
          connect(VIN1.n, Gnd4.p) annotation (Line(points={{-70,10},{-70,5}}));
          connect(VIN2.n, Gnd5.p) annotation (Line(points={{-70,-40},{-70,-45}}));
          connect(Nand.Vdd, VDD.p) annotation (Line(points={{0,55},{0,90},{50,90},{50,
                  80}}));
          connect(VIN1.p, Nand.x1) annotation (Line(points={{-70,30},{-40,30}}));
          connect(VIN2.p, Nand.x2) annotation (Line(points={{-70,-20},{-40,-20}}));
        end NandGate;

        model Rectifier "B6 diode bridge"
          extends Modelica.Icons.Example;
          import Modelica.Electrical.Analog.Ideal;
          parameter Modelica.SIunits.Voltage VAC=400 "RMS line-to-line";
          parameter Modelica.SIunits.Frequency f=50 "line frequency";
          parameter Modelica.SIunits.Inductance LAC=60E-6 "line inductor";
          parameter Modelica.SIunits.Resistance Ron=1E-3
            "diode forward resistance";
          parameter Modelica.SIunits.Conductance Goff=1E-3
            "diode backward conductance";
          parameter Modelica.SIunits.Voltage Vknee=2 "diode threshold voltage";
          parameter Modelica.SIunits.Capacitance CDC=15E-3 "DC capacitance";
          parameter Modelica.SIunits.Current IDC=500 "load current";
          output Modelica.SIunits.Voltage uDC;
          output Modelica.SIunits.Current iAC[3];
          output Modelica.SIunits.Voltage uAC[3];
          output Modelica.SIunits.Power Losses;

        annotation (
          Diagram(graphics={
                Text(
                  extent={{-80,90},{80,70}},
                  lineColor={0,0,0},
                  textString="Rectifier"),
                Line(points={{-16,18},{-16,2},{-18,6},{-14,6},{-16,2}}, color={0,0,0}),
                Line(points={{-30,22},{-26,20},{-30,18},{-30,22}}, color={0,0,0}),
                Line(points={{32,30},{32,-30},{30,-26},{34,-26},{32,-30}}, color={0,0,0}),
                Text(
                  extent={{-38,16},{-22,8}},
                  lineColor={0,0,0},
                  textString="iAC"),
                Text(
                  extent={{-14,8},{2,0}},
                  lineColor={0,0,0},
                  textString="uAC"),
                Text(
                  extent={{22,-16},{38,-24}},
                  lineColor={0,0,0},
                  textString="uDC")}),
          experiment(StopTime=0.1, Interval=1e-005),
          Documentation(info="<HTML>
<P>
The rectifier example shows a B6 diode bridge fed by a three phase sinusoidal voltage, loaded by a DC current.<br>
DC capacitors start at ideal no-load voltage, thus making easier initial transient.
</P>
<P>
Simulate until T=0.1 s.<br><br>
Plot in separate windows:<br><br>
uDC ... DC-voltage<br>
iAC ... AC-currents 1..3<br>
uAC ... AC-voltages 1..3 (distorted)<br>
Try different load currents iDC = 0..approximately 500 A.
</P>
<p>
You may watch Losses (of the whole diode bridge) trying different diode parameters.
</p>
 
</HTML>
",         revisions="<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Mai 7, 2004   </i>
       by Anton Haumer<br> realized<br>
       </li>
</ul>
</html>"));

          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1(freqHz=f,
               V=VAC*sqrt(2/3)) 
                              annotation (Placement(transformation(extent={{-70,10},{
                    -90,30}}, rotation=0)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage2(
            freqHz=f,
            phase=-2/3*Modelica.Constants.pi,
            V=VAC*sqrt(2/3)) 
                           annotation (Placement(transformation(extent={{-70,-10},{-90,
                    10}}, rotation=0)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage3(
            freqHz=f,
            phase=-4/3*Modelica.Constants.pi,
            V=VAC*sqrt(2/3)) 
                           annotation (Placement(transformation(extent={{-70,-30},{-90,
                    -10}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Inductor Inductor1(L=LAC) 
          annotation (Placement(transformation(extent={{-60,10},{-40,30}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Inductor Inductor2(L=LAC) 
          annotation (Placement(transformation(extent={{-60,-10},{-40,10}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Inductor Inductor3(L=LAC) 
          annotation (Placement(transformation(extent={{-60,-30},{-40,-10}}, rotation=0)));
          Ideal.IdealDiode IdealDiode1(
            Ron=Ron,
            Goff=Goff,
            Vknee=Vknee) 
            annotation (Placement(transformation(
                origin={-20,40},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Ideal.IdealDiode IdealDiode2(
            Ron=Ron,
            Goff=Goff,
            Vknee=Vknee) 
            annotation (Placement(transformation(
                origin={0,40},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Ideal.IdealDiode IdealDiode3(
            Ron=Ron,
            Goff=Goff,
            Vknee=Vknee) 
            annotation (Placement(transformation(
                origin={20,40},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Ideal.IdealDiode IdealDiode4(
            Ron=Ron,
            Goff=Goff,
            Vknee=Vknee) 
            annotation (Placement(transformation(
                origin={-20,-40},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Ideal.IdealDiode IdealDiode5(
            Ron=Ron,
            Goff=Goff,
            Vknee=Vknee) 
            annotation (Placement(transformation(
                origin={0,-40},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Ideal.IdealDiode IdealDiode6(
            Ron=Ron,
            Goff=Goff,
            Vknee=Vknee) 
            annotation (Placement(transformation(
                origin={20,-40},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Modelica.Electrical.Analog.Basic.Capacitor Capacitor1(C=2*CDC) 
          annotation (Placement(transformation(
                origin={40,40},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Capacitor Capacitor2(C=2*CDC) 
          annotation (Placement(transformation(
                origin={40,-40},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 
          annotation (Placement(transformation(extent={{40,-80},{60,-60}}, rotation=0)));
          Modelica.Electrical.Analog.Sources.SignalCurrent SignalCurrent1 
          annotation (Placement(transformation(
                origin={60,0},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Blocks.Sources.Constant Constant1(k=IDC) 
          annotation (Placement(transformation(extent={{100,-10},{80,10}}, rotation=0)));
        initial equation
          Capacitor1.v = VAC*sqrt(2)/2;
          Capacitor2.v = VAC*sqrt(2)/2;
        equation
          uDC = Capacitor1.v + Capacitor2.v;
          iAC = {Inductor1.i,Inductor2.i,Inductor3.i};
          uAC[1] = Inductor1.n.v - Inductor2.n.v;
          uAC[2] = Inductor2.n.v - Inductor3.n.v;
          uAC[3] = Inductor3.n.v - Inductor1.n.v;
          Losses = IdealDiode1.v*IdealDiode1.i + IdealDiode2.v*IdealDiode2.i +
            IdealDiode3.v*IdealDiode3.i + IdealDiode4.v*IdealDiode4.i +
            IdealDiode5.v*IdealDiode5.i + IdealDiode6.v*IdealDiode6.i;
          connect(SineVoltage1.n, SineVoltage2.n) 
            annotation (Line(points={{-90,20},{-90,0}}, color={0,0,255}));
          connect(SineVoltage2.n, SineVoltage3.n) 
            annotation (Line(points={{-90,0},{-90,-20}}, color={0,0,255}));
          connect(SineVoltage1.p, Inductor1.p) 
            annotation (Line(points={{-70,20},{-60,20}}, color={0,0,255}));
          connect(SineVoltage2.p, Inductor2.p) 
            annotation (Line(points={{-70,0},{-60,0}}, color={0,0,255}));
          connect(SineVoltage3.p, Inductor3.p) 
            annotation (Line(points={{-70,-20},{-60,-20}}, color={0,0,255}));
          connect(IdealDiode1.p, IdealDiode4.n) 
            annotation (Line(points={{-20,30},{-20,-30}}, color={0,0,255}));
          connect(IdealDiode2.p, IdealDiode5.n) 
            annotation (Line(points={{-6.12323e-016,30},{-6.12323e-016,16},{0,0},{0,-30},
                  {6.12323e-016,-30}}, color={0,0,255}));
          connect(IdealDiode3.p, IdealDiode6.n) 
            annotation (Line(points={{20,30},{20,-30}}, color={0,0,255}));
          connect(IdealDiode1.n, IdealDiode2.n) 
            annotation (Line(points={{-20,50},{6.12323e-016,50}}, color={0,0,255}));
          connect(IdealDiode2.n, IdealDiode3.n) 
            annotation (Line(points={{6.12323e-016,50},{20,50}}, color={0,0,255}));
          connect(IdealDiode4.p, IdealDiode5.p) 
            annotation (Line(points={{-20,-50},{-6.12323e-016,-50}}, color={0,0,255}));
          connect(IdealDiode5.p, IdealDiode6.p) 
            annotation (Line(points={{-6.12323e-016,-50},{20,-50}}, color={0,0,255}));
          connect(Capacitor2.n, IdealDiode6.p) 
            annotation (Line(points={{40,-50},{20,-50}}, color={0,0,255}));
          connect(IdealDiode3.n, Capacitor1.p) 
            annotation (Line(points={{20,50},{40,50}}, color={0,0,255}));
          connect(Capacitor1.n, Capacitor2.p) 
            annotation (Line(points={{40,30},{40,-30}}, color={0,0,255}));
          connect(Capacitor2.p, Ground1.p) 
            annotation (Line(points={{40,-30},{40,0},{50,0},{50,-60}}, color={0,0,255}));
          connect(Capacitor1.p, SignalCurrent1.p) 
            annotation (Line(points={{40,50},{60,50},{60,10}}, color={0,0,255}));
          connect(SignalCurrent1.n, Capacitor2.n) 
            annotation (Line(points={{60,-10},{60,-50},{40,-50}}, color={0,0,255}));
          connect(Constant1.y, SignalCurrent1.i) 
            annotation (Line(points={{79,0},{79,4.28626e-016},{67,4.28626e-016}}, color=
                 {0,0,255}));
          connect(Inductor1.n, IdealDiode1.p) 
            annotation (Line(points={{-40,20},{-20,20},{-20,30}}, color={0,0,255}));
          connect(Inductor2.n, IdealDiode2.p) 
            annotation (Line(points={{-40,0},{-6.12323e-016,0},{-6.12323e-016,30}},
                color={0,0,255}));
          connect(Inductor3.n, IdealDiode3.p) 
            annotation (Line(points={{-40,-20},{20,-20},{20,30}}, color={0,0,255}));
        end Rectifier;

        model ShowSaturatingInductor
          "Simple demo to show behaviour of SaturatingInductor component"
          extends Modelica.Icons.Example;
          parameter Modelica.SIunits.Inductance Lzer=2
            "Inductance near current=0";
          parameter Modelica.SIunits.Inductance Lnom=1
            "Nominal inductance at Nominal current";
          parameter Modelica.SIunits.Current Inom=1 "Nominal current";
          parameter Modelica.SIunits.Inductance Linf=0.5
            "Inductance at large currents";
          parameter Modelica.SIunits.Voltage U=1.25 "source voltage (peak)";
          parameter Modelica.SIunits.Frequency f=1/(2*Modelica.Constants.pi)
            "source frequency";
          parameter Modelica.SIunits.Angle phase=Modelica.Constants.pi/2
            "source voltage phase shift";
          output Modelica.SIunits.Voltage v
            "voltage drop over saturating inductor";
          output Modelica.SIunits.Current i
            "current across saturating inductor";
          annotation (
            Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                    100,100}}),
                    graphics),
            experiment(StopTime=6.2832, Interval=0.01),
            Documentation(info="<html>
  
</html>"));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1(
            V=U,
            phase=phase,
            freqHz=f) 
            annotation (Placement(transformation(
                origin={-20,0},
                extent={{-10,-10},{10,10}},
                rotation=270)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 
            annotation (Placement(transformation(extent={{-30,-30},{-10,-10}}, rotation=
                   0)));
          Modelica.Electrical.Analog.Basic.SaturatingInductor
            SaturatingInductance1(
            Lzer=Lzer,
            Lnom=Lnom,
            Inom=Inom,
            Linf=Linf) 
            annotation (Placement(transformation(
                origin={22,6},
                extent={{-10,-10},{10,10}},
                rotation=270)));
        equation
          v=SaturatingInductance1.v;
          i=SaturatingInductance1.i;
          connect(SineVoltage1.n, Ground1.p) annotation (Line(points={{-20,-10},{-20,
                  -10}}, color={0,0,255}));
          connect(SineVoltage1.n, SaturatingInductance1.n) annotation (Line(points={{-20,-10},
                  {22,-10},{22,-4}},          color={0,0,255}));
          connect(SaturatingInductance1.p, SineVoltage1.p) annotation (Line(points={{22,16},
                  {22,26},{-20,26},{-20,10}},     color={0,0,255}));
        end ShowSaturatingInductor;

        model ShowVariableResistor "Simple demo of a VariableResistor model"
           extends Modelica.Icons.Example;

          Modelica.Electrical.Analog.Basic.VariableResistor VariableResistor 
                            annotation (Placement(transformation(extent={{-20,-20},{0,0}},
                  rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 
          annotation (Placement(transformation(extent={{-100,-80},{-80,-60}}, rotation=
                    0)));
          Modelica.Electrical.Analog.Basic.Ground Ground2 
          annotation (Placement(transformation(extent={{60,-40},{80,-20}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R1 
          annotation (Placement(transformation(extent={{-60,40},{-40,60}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R2 
          annotation (Placement(transformation(extent={{-20,40},{0,60}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R3 
          annotation (Placement(transformation(extent={{20,40},{40,60}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R4 
          annotation (Placement(transformation(extent={{-60,-20},{-40,0}}, rotation=0)));
          Modelica.Electrical.Analog.Basic.Resistor R5 
          annotation (Placement(transformation(extent={{20,-20},{40,0}}, rotation=0)));

        annotation (Documentation(info="<HTML>
<P>
It is a simple test circuit for the VariableResistor. The VariableResistor
sould be compared with R2.
</P>
<P>
Simulate until T=1 s.
</P>
<P>
 
</HTML>
",         revisions="<html>
<p><b>Release Notes:</b></p>
<ul>
<li><i>Mai 6, 2004   </i>
       by Teresa Schlegel<br> realized<br>
       </li>
</ul>
</html>"),experiment(StopTime=1),
            Diagram(graphics={Text(
                  extent={{-100,112},{80,40}},
                  lineColor={0,0,255},
                  textString="Example VariableResistor")}));

        annotation(Diagram);
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1 
          annotation (Placement(transformation(
                origin={-90,-30},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Modelica.Blocks.Sources.Ramp Ramp1(height=5, offset=2) 
          annotation (Placement(transformation(
                origin={-10,20},
                extent={{-10,-10},{10,10}},
                rotation=270)));
        equation
          connect(R1.n, R2.p)             annotation (Line(points={{-40,50},{-20,50}},
                color={0,0,255}));
          connect(R2.n, R3.p)             annotation (Line(points={{0,50},{20,50}},
                color={0,0,255}));
          connect(R4.n, VariableResistor.p)       annotation (Line(points={{-40,-10},{
                  -20,-10}}, color={0,0,255}));
          connect(VariableResistor.n, R5.p)       annotation (Line(points={{0,-10},{20,
                  -10}}, color={0,0,255}));
          connect(R3.n, Ground2.p)      annotation (Line(points={{40,50},{70,50},{70,
                  -20}}, color={0,0,255}));
          connect(Ground2.p, R5.n)      annotation (Line(points={{70,-20},{70,-10},{40,
                  -10}}, color={0,0,255}));
          connect(SineVoltage1.p, Ground1.p) 
                                           annotation (Line(points={{-90,-40},{-90,-60}},
                color={0,0,255}));
          connect(SineVoltage1.n, R1.p)      annotation (Line(points={{-90,-20},{-90,50},
                  {-60,50}}, color={0,0,255}));
          connect(SineVoltage1.n, R4.p)      annotation (Line(points={{-90,-20},{-90,
                  -10},{-60,-10}}, color={0,0,255}));
          connect(Ramp1.y, VariableResistor.R)           annotation (Line(points={{-10,
                  9},{-10,4.5},{-10,1},{-10,1}}, color={0,0,255}));
        end ShowVariableResistor;

        package Utilities "Utility components used by package Examples"
        extends Modelica.Icons.Library2;

        annotation (
          Documentation(info="<html>
<p>
This package contains utility components used by package Examples.
</p>

</HTML>
",         revisions="<html>
<dl>
<dt>
<b>Main Authors:</b>
<dd>
<a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
    &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
    <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
    &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
    Fraunhofer Institute for Integrated Circuits<br>
    Design Automation Department<br>
    Zeunerstra&szlig;e 38<br>
    D-01069 Dresden<br>
<p>
<dt>
<b>Copyright:</b>
<dd>
Copyright &copy; 1998-2006, Modelica Association and Fraunhofer-Gesellschaft.<br>
<i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b> in the documentation of package
Modelica in file \"Modelica/package.mo\".</i><br>
<p>
</dl>
</html>"));
          model Nand "CMOS NAND Gate (see Tietze/Schenk, page 157)"

            annotation (
              Icon(coordinateSystem(
                  preserveAspectRatio=true,
                  extent={{-100,-100},{100,100}},
                  grid={1,1}), graphics={
                  Rectangle(
                    extent={{-50,70},{50,-70}},
                    lineColor={0,0,0},
                    fillColor={192,192,192},
                    fillPattern=FillPattern.Solid),
                  Ellipse(
                    extent={{50,5},{60,-5}},
                    lineColor={0,0,0},
                    pattern=LinePattern.None),
                  Text(
                    extent={{-16,50},{14,20}},
                    lineColor={0,0,0},
                    textString="&"),
                  Line(points={{60,0},{100,0}}, color={0,0,255}),
                  Line(points={{0,70},{0,100}}, color={0,0,255}),
                  Line(points={{-50,50},{-100,50}}, color={0,0,255}),
                  Line(points={{-50,-50},{-100,-50}}, color={0,0,255}),
                  Ellipse(extent={{50,5},{60,-5}}, lineColor={0,0,0}),
                  Text(
                    extent={{-100,34},{-90,24}},
                    textString="x1",
                    lineColor={0,0,255}),
                  Text(
                    extent={{-100,-65},{-90,-75}},
                    textString="x2",
                    lineColor={0,0,255}),
                  Text(
                    extent={{90,-15},{100,-25}},
                    textString="y",
                    lineColor={0,0,255})}),
              Documentation(info="<html>
<p>
The nand gate is a basic CMOS building block. It consists of four CMOS transistors.
<p>
<dl>
<dt>
<b>Reference:</b>
<dd>
Tietze, U.; Schenk, Ch.: Halbleiter-Schaltungstechnik. Springer-Verlag Berlin Heidelberg NewYork 1980, p. 157
<p>
</dd>
</dl>

</HTML>
",           revisions="<html>
<dl>
<dt>
<b>Main Authors:</b>
<dd>
<a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
    &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
    <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
    &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
    Fraunhofer Institute for Integrated Circuits<br>
    Design Automation Department<br>
    Zeunerstra&szlig;e 38<br>
    D-01069 Dresden<br>
<p>
<dt>
<b>Copyright:</b>
<dd>
Copyright &copy; 1998-2006, Modelica Association and Fraunhofer-Gesellschaft.<br>
<i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b> in the documentation of package
Modelica in file \"Modelica/package.mo\".</i><br>
<p>
</dl>
</html>"),    Diagram(coordinateSystem(
                  preserveAspectRatio=true,
                  extent={{-100,-100},{100,100}},
                  grid={1,1}), graphics));
            Semiconductors.PMOS TP1(
              W=6.5e-6,
              L=3.1e-6,
              Beta=1.05e-5,
              Vt=-1,
              K2=0.41,
              K5=0.8385,
              dW=-2.5e-6,
              dL=-2.1e-6) annotation (Placement(transformation(extent={{10,60},{30,80}},
                    rotation=0)));
            Semiconductors.PMOS TP2(
              W=6.5e-6,
              L=3.1e-6,
              Beta=1.05e-5,
              Vt=-1,
              K2=0.41,
              K5=0.8385,
              dW=-2.5e-6,
              dL=-2.1e-6) annotation (Placement(transformation(extent={{-40,45},{-20,65}},
                    rotation=0)));
            Semiconductors.NMOS TN1(
              W=6.5e-6,
              L=3.1e-6,
              Beta=4.1e-5,
              Vt=0.8,
              K2=1.144,
              K5=0.7311,
              dW=-2.5e-6,
              dL=-1.5e-6) annotation (Placement(transformation(extent={{10,15},{30,35}},
                    rotation=0)));
            Semiconductors.NMOS TN2(
              W=6.5e-6,
              L=3.1e-6,
              Beta=4.1e-5,
              Vt=0.8,
              K2=1.144,
              K5=0.7311,
              dW=-2.5e-6,
              dL=-1.5e-6) annotation (Placement(transformation(extent={{10,-25},{30,-5}},
                    rotation=0)));
            Basic.Capacitor C4(C=0.4e-13) annotation (Placement(transformation(
                  origin={60,30},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Basic.Capacitor C7(C=0.4e-13) annotation (Placement(transformation(
                  origin={55,-50},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Basic.Ground Gnd annotation (Placement(transformation(extent={{40,-25},{50,
                      -15}}, rotation=0)));
            Basic.Ground Gnd2 annotation (Placement(transformation(extent={{55,0},{65,10}},
                    rotation=0)));
            Basic.Ground Gnd3 annotation (Placement(transformation(extent={{50,-80},{60,
                      -70}}, rotation=0)));
            Basic.Ground Gnd6 annotation (Placement(transformation(extent={{-15,30},{-5,
                      40}}, rotation=0)));
            Basic.Ground Gnd7 annotation (Placement(transformation(extent={{40,15},{50,25}},
                    rotation=0)));
            Basic.Ground Gnd8 annotation (Placement(transformation(extent={{40,60},{50,70}},
                    rotation=0)));
            Interfaces.Pin x1 annotation (Placement(transformation(extent={{-110,40},{-90,
                      60}}, rotation=0)));
            Interfaces.Pin x2 annotation (Placement(transformation(extent={{-110,-60},{
                      -90,-40}}, rotation=0)));
            Interfaces.Pin Vdd annotation (Placement(transformation(extent={{-10,90},{10,
                      110}}, rotation=0)));
            Interfaces.Pin y annotation (Placement(transformation(extent={{90,-10},{110,
                      10}}, rotation=0)));
          equation
            connect(TN1.S, TN2.D) annotation (Line(points={{30,20},{30,-10}}));
            connect(TN2.B, Gnd.p) annotation (Line(points={{30,-15},{38,-15},{38,-15},{45,
                    -15}}));
            connect(TN2.D, C7.p) annotation (Line(points={{30,-10},{55,-10},{55,-40}}));
            connect(TN2.S, Gnd.p) annotation (Line(points={{30,-20},{38,-20},{38,-15},{45,
                    -15}}));
            connect(TP1.S, TN1.D) annotation (Line(points={{30,65},{30,30}}));
            connect(TP1.G, TN1.G) annotation (Line(points={{10,65},{10,20}}));
            connect(C4.n, Gnd2.p) annotation (Line(points={{60,20},{60,10}}));
            connect(C7.n, Gnd3.p) annotation (Line(points={{55,-60},{55,-70}}));
            connect(TP2.B, Gnd6.p) annotation (Line(points={{-20,55},{-10,55},{-10,40}}));
            connect(TN1.B, Gnd7.p) annotation (Line(points={{30,25},{45,25}}));
            connect(TP1.B, Gnd8.p) annotation (Line(points={{30,70},{45,70}}));
            connect(TP2.G, x1) annotation (Line(points={{-40,50},{-100,50}}));
            connect(TP2.G, TN2.G) annotation (Line(points={{-40,50},{-40,-20},{10,-20}}));
            connect(TN1.G, x2) annotation (Line(points={{10,20},{-70,20},{-70,-50},{-100,
                    -50}}));
            connect(TP2.S, TN1.D) annotation (Line(points={{-20,50},{30,50},{30,30}}));
            connect(TN1.D, C4.p) annotation (Line(points={{30,30},{30,50},{60,50},{60,40}}));
            connect(Vdd, TP1.D) annotation (Line(points={{0,100},{0,80},{30,80},{30,75}}));
            connect(TP2.D, Vdd) annotation (Line(points={{-20,60},{-20,80},{0,80},{0,100}}));
            connect(C4.p, y) annotation (Line(points={{60,40},{60,50},{80,50},{80,0},{100,
                    0}}));
          end Nand;

          model NonlinearResistor "Chua's resistor"
            extends Interfaces.OnePort;
            annotation (
              Icon(coordinateSystem(
                  preserveAspectRatio=true,
                  extent={{-100,-100},{100,100}},
                  grid={1,1}), graphics={
                  Rectangle(extent={{-70,30},{70,-30}}, lineColor={0,0,255}),
                  Line(points={{-90,0},{-70,0}}, color={0,0,255}),
                  Line(points={{70,0},{90,0}}, color={0,0,255}),
                  Line(points={{-50,-60},{50,60}}, color={0,0,255}),
                  Polygon(
                    points={{50,60},{38,52},{44,46},{50,60}},
                    fillColor={0,0,255},
                    fillPattern=FillPattern.Solid,
                    lineColor={0,0,255})}),
              Diagram(coordinateSystem(
                  preserveAspectRatio=true,
                  extent={{-100,-100},{100,100}},
                  grid={1,1}), graphics={
                  Rectangle(extent={{-70,30},{70,-30}}, lineColor={0,0,255}),
                  Line(points={{-90,0},{-70,0}}, color={0,0,255}),
                  Line(points={{70,0},{90,0}}, color={0,0,255}),
                  Line(points={{-50,-60},{50,60}}, color={0,0,255}),
                  Polygon(
                    points={{50,60},{38,52},{44,46},{50,60}},
                    fillColor={0,0,255},
                    fillPattern=FillPattern.Solid,
                    lineColor={0,0,255}),
                  Text(
                    extent={{-100,100},{100,70}},
                    textString="%name",
                    lineColor={0,0,255})}),
              Documentation(info="<html>
  
</html>"));

            parameter SI.Conductance Ga "conductance in inner voltage range";
            parameter SI.Conductance Gb "conductance in outer voltage range";
            parameter SI.Voltage Ve "inner voltage range limit";
          equation
            i = if (v < -Ve) then Gb*(v + Ve) - Ga*Ve else if (v > Ve) then Gb*(v - Ve)
               + Ga*Ve else Ga*v;
          end NonlinearResistor;

          model RealSwitch "ideal switch with resistance"

            Ideal.ControlledIdealCommutingSwitch S(level=2.5) annotation (Placement(
                  transformation(extent={{11.3333,18},{58,64.6667}}, rotation=0)));
            Basic.Resistor R(R=0.01) annotation (Placement(transformation(extent={{-66,16},
                      {-19.3333,62.6667}}, rotation=0)));
            Interfaces.Pin p annotation (Placement(transformation(extent={{-110,30},{-90,
                      50}}, rotation=0)));
            Interfaces.Pin n1 annotation (Placement(transformation(extent={{90,50},{110,
                      70}}, rotation=0)));
            Interfaces.Pin n2 annotation (Placement(transformation(extent={{90,4},{110,24}},
                    rotation=0)));
            Interfaces.Pin control annotation (Placement(transformation(extent={{24,90},{
                      44,110}}, rotation=0)));
          equation
            connect(p, R.p) annotation (Line(points={{-100,40},{-66,39.3333}}));
            connect(R.n, S.p) annotation (Line(points={{-19.3333,39.3333},{11.3333,
                    41.3334}}));
            connect(n1, S.n1) annotation (Line(points={{100,60},{58,53}}));
            connect(n2, S.n2) annotation (Line(points={{100,14},{58,41.3334}}));
            connect(control, S.control) annotation (Line(points={{34,100},{34.6666,
                    64.6667}}));
            annotation (
              Documentation(info="<html>
  
</html>"));
          end RealSwitch;

          model Transistor "transistor with resistance an capacitance"

            annotation (
              Icon(coordinateSystem(
                  preserveAspectRatio=true,
                  extent={{-100,-100},{100,100}},
                  grid={2,2}), graphics={
                  Rectangle(extent={{-80,80},{80,-80}}, lineColor={0,0,255}),
                  Line(points={{80,60},{100,60}}, color={0,0,255}),
                  Line(points={{80,-60},{100,-60}}, color={0,0,255}),
                  Line(points={{-100,0},{-80,0}}, color={0,0,255}),
                  Line(points={{-60,0},{-10,0}}, color={0,0,255}),
                  Line(points={{-10,40},{-10,-40}}, color={0,0,255}),
                  Line(points={{60,60},{40,60},{-10,10}}, color={0,0,255}),
                  Line(points={{-10,-10},{40,-60},{60,-60}}, color={0,0,255})}),
              Documentation(info="<html>
  
</html>"));
            Basic.Resistor rtb(R=0.05) annotation (Placement(transformation(extent={{-80,
                      -10},{-60,10}}, rotation=0)));
            Basic.Resistor rtc(R=0.1) annotation (Placement(transformation(extent={{40,0},
                      {60,20}}, rotation=0)));
            Basic.Capacitor ct(C=1e-10) annotation (Placement(transformation(
                  origin={-40,-30},
                  extent={{-10,-10},{10,10}},
                  rotation=270)));
            Semiconductors.NPN Tr(
              Bf=50,
              Br=0.1,
              Is=1e-16,
              Vak=0.02,
              Tauf=0.12e-9,
              Taur=5e-9,
              Ccs=1e-12,
              Cje=0.4e-12,
              Cjc=0.5e-12,
              Phie=0.8,
              Me=0.4,
              Phic=0.8,
              Mc=0.333,
              Gbc=1e-15,
              Gbe=1e-15,
              Vt=0.02585) annotation (Placement(transformation(extent={{-20,-20},{20,20}},
                    rotation=0)));
            Basic.Ground Ground1 annotation (Placement(transformation(extent={{-50,-80},{
                      -30,-60}}, rotation=0)));
            Interfaces.Pin c annotation (Placement(transformation(extent={{90,50},{110,70}},
                    rotation=0)));
            Interfaces.Pin b annotation (Placement(transformation(extent={{-110,-10},{-90,
                      10}}, rotation=0)));
            Interfaces.Pin e annotation (Placement(transformation(extent={{90,-70},{110,
                      -50}}, rotation=0)));
          equation
            connect(rtb.n, Tr.B) annotation (Line(points={{-60,0},{-20,0}}));
            connect(rtb.n, ct.p) annotation (Line(points={{-60,0},{-40,0},{-40,-20}}));
            connect(ct.n, Ground1.p) annotation (Line(points={{-40,-40},{-40,-60}}));
            connect(Tr.C, rtc.p) annotation (Line(points={{20,10},{40,10}}));
            connect(rtc.n, c) annotation (Line(points={{60,10},{80,10},{80,60},{100,60}}));
            connect(b, rtb.p) annotation (Line(points={{-100,0},{-80,0}}));
            connect(Tr.E, e) annotation (Line(points={{20,-10},{80,-10},{80,-60},{100,-60}}));
          end Transistor;
        end Utilities;
      end Examples;
    extends Modelica.Icons.Library2;

    annotation (
        __Dymola_classOrder={"Examples", "*"},
      Documentation(info="<html>
<p>
This package contains packages for analog electrical components:
<ul>
<li>Basic: basic components (resistor, capacitor, conductor, inductor, transformer, gyrator)</li>
<li>Semiconductors: semiconductor devices (diode, bipolar and MOS transistors)</li>
<li>Lines: transmission lines (lossy and lossless)</li>
<li>Ideal: ideal elements (switches, diode, transformer, idle, short, ...)</li>
<li>Sources: time-dependend and controlled voltage and current sources</li>
<li>Sensors: sensors to measure potential, voltage, and current</li>
</ul>
</p>
<dl>
<dt>
<b>Main Authors:</b></dt>
<dd>
<a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
    &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
    <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
    &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
    Fraunhofer Institute for Integrated Circuits<br>
    Design Automation Department<br>
    Zeunerstra&szlig;e 38<br>
    D-01069 Dresden</dd>
</dl>
 
 
<p>
Copyright &copy; 1998-2008, Modelica Association and Fraunhofer-Gesellschaft.
</p>
<p>
<i>This Modelica package is <b>free</b> software; it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b> 
<a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
</p><br>
</HTML>
"));
      package Basic
        "Basic electrical components such as resistor, capacitor, transformer"

        extends Modelica.Icons.Library;

        annotation (
      Documentation(info="<HTML>
<p>
This package contains basic analog electrical components.
</p>

</HTML>
",       revisions="<html>
<dl>
<dt>
<b>Main Authors:</b>
<dd>
<a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
    &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
    <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
    &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
    Fraunhofer Institute for Integrated Circuits<br>
    Design Automation Department<br>
    Zeunerstra&szlig;e 38<br>
    D-01069 Dresden<br>
<p>
</dl>
</html>"));
        model Ground "Ground node"
          Interfaces.Pin p annotation (Placement(transformation(
                origin={0,100},
                extent={{10,-10},{-10,10}},
                rotation=270)));
          annotation (
            Documentation(info="<HTML>
<P>
Ground of an electrical circuit. The potential at the
ground node is zero. Every electrical circuit has to contain
at least one ground object.
</P>
</HTML>
",       revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> 1998   </i>
       by Christoph Clauss<br> initially implemented<br>
       </li>
</ul>
</html>"),  Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Line(points={{-60,50},{60,50}}, color={0,0,255}),
                Line(points={{-40,30},{40,30}}, color={0,0,255}),
                Line(points={{-20,10},{20,10}}, color={0,0,255}),
                Line(points={{0,90},{0,50}}, color={0,0,255}),
                Text(
                  extent={{-144,-60},{138,0}},
                  textString="%name",
                  lineColor={0,0,255})}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Line(
                  points={{-60,50},{60,50}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(
                  points={{-40,30},{40,30}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(
                  points={{-20,10},{20,10}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(
                  points={{0,96},{0,50}},
                  thickness=0.5,
                  color={0,0,255}),
                Text(
                  extent={{-24,-38},{22,-6}},
                  textString="p.v=0",
                  lineColor={0,0,255})}));
        equation
          p.v = 0;
        end Ground;

        model Resistor "Ideal linear electrical resistor"
          extends Interfaces.OnePort;
          parameter SI.Resistance R(start=1) "Resistance";
          annotation (
            Documentation(info="<HTML>
<P>
The linear resistor connects the branch voltage <i>v</i> with the
branch current <i>i</i> by <i>i*R = v</i>.
The Resistance <i>R</i> is allowed to be positive, zero, or negative.
</P>
</HTML>
",       revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> 1998   </i>
       by Christoph Clauss<br> initially implemented<br>
       </li>
</ul>
</html>"),  Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Rectangle(
                  extent={{-70,30},{70,-30}},
                  lineColor={0,0,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{-90,0},{-70,0}}, color={0,0,255}),
                Line(points={{70,0},{90,0}}, color={0,0,255}),
                Text(
                  extent={{-144,-60},{144,-100}},
                  lineColor={0,0,0},
                  textString="R=%R"),
                Text(
                  extent={{-144,40},{144,100}},
                  textString="%name",
                  lineColor={0,0,255})}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Rectangle(extent={{-70,30},{70,-30}}, lineColor={0,0,255}),
                Line(points={{-96,0},{-70,0}}, color={0,0,255}),
                Line(points={{70,0},{96,0}}, color={0,0,255})}));
        equation
          R*i = v;
        end Resistor;

          model HeatingResistor "Temperature dependent electrical resistor"
            extends Modelica.Electrical.Analog.Interfaces.OnePort;

            parameter SI.Resistance R_ref(start=1)
            "Resistance at temperature T_ref";
            parameter SI.Temperature T_ref(start=300) "Reference temperature";
            parameter SI.LinearTemperatureCoefficient alpha(start=0)
            "Temperature coefficient of resistance (R = R_ref*(1 + alpha*(heatPort.T - T_ref))";

            SI.Resistance R
            "Resistance = R_ref*(1 + alpha*(heatPort.T - T_ref));";
            Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a heatPort annotation (Placement(
                transformation(
                origin={0,-100},
                extent={{10,-10},{-10,10}},
                rotation=270)));
            annotation (
              Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},
                    {100,100}}), graphics={
                Line(points={{-110,20},{-85,20}}, color={160,160,164}),
                Polygon(
                  points={{-95,23},{-85,20},{-95,17},{-95,23}},
                  lineColor={160,160,164},
                  fillColor={160,160,164},
                  fillPattern=FillPattern.Solid),
                Line(points={{90,20},{115,20}}, color={160,160,164}),
                Line(points={{-125,0},{-115,0}}, color={160,160,164}),
                Line(points={{-120,-5},{-120,5}}, color={160,160,164}),
                Text(
                  extent={{-110,25},{-90,45}},
                  lineColor={160,160,164},
                  textString="i"),
                Polygon(
                  points={{105,23},{115,20},{105,17},{105,23}},
                  lineColor={160,160,164},
                  fillColor={160,160,164},
                  fillPattern=FillPattern.Solid),
                Line(points={{115,0},{125,0}}, color={160,160,164}),
                Text(
                  extent={{90,45},{110,25}},
                  lineColor={160,160,164},
                  textString="i")}),
              Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                    100,100}}), graphics={
                Text(
                  extent={{-142,60},{143,118}},
                  textString="%name",
                  lineColor={0,0,255}),
                Line(points={{-90,0},{-70,0}}, color={0,0,255}),
                Line(points={{70,0},{90,0}}, color={0,0,255}),
                Rectangle(
                  extent={{-70,30},{70,-30}},
                  lineColor={0,0,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{0,-30},{0,-91}}, color={191,0,0}),
                Line(points={{-52,-50},{48,50}}, color={0,0,255}),
                Polygon(
                  points={{40,52},{50,42},{54,56},{40,52}},
                  lineColor={0,0,255},
                  fillColor={0,0,255},
                  fillPattern=FillPattern.Solid)}),
              Documentation(info="<HTML>
<p>This is a model for an electrical resistor where the generated heat
is dissipated to the environment via connector <b>heatPort</b> and where
the resistance R is temperature dependent according to the following
equation:</p>
<pre>    R = R_ref*(1 + alpha*(heatPort.T - T_ref))
</pre>
<p><b>alpha</b> is the <b>temperature coefficient of resistance</b>, which
is often abbreviated as <b>TCR</b>. In resistor catalogues, it is usually
defined as <b>X [ppm/K]</b> (parts per million, similarly to per centage)
meaning <b>X*1.e-6 [1/K]</b>. Resistors are available for 1 .. 7000 ppm/K,
i.e., alpha = 1e-6 .. 7e-3 1/K;</p>
 
<p>
Via parameter <b>useHeatPort</b> the heatPort connector can be enabled and disabled
(default = enabled). If it is disabled, the generated heat is transported implicitly
to an internal temperature source with a fixed temperature of T_ref.<br>
If the heatPort connector is enabled, it must be connected.
</p>
 
</HTML>
",           revisions=
                   "<html>
<ul>
<li><i>  </i>
       </li>
<li><i> 2002   </i>
       by Anton Haumer<br> initially implemented<br>
       </li>
</ul>
</html>"));
          equation
            assert(cardinality(heatPort) > 0, "Connector heatPort of HeatingResistor must be connected");
            R = R_ref*(1 + alpha*(heatPort.T - T_ref));
            v = R*i;
            heatPort.Q_flow = -v*i;
          end HeatingResistor;

        model Conductor "Ideal linear electrical conductor"
          extends Interfaces.OnePort;
          parameter SI.Conductance G(start=1) "Conductance";
          annotation (
            Documentation(info="<HTML>
<P>
The linear conductor connects the branch voltage <i>v</i> with the
branch current <i>i</i> by <i>i = v*G</i>.
The Conductance <i>G</i> is allowed to be positive, zero, or negative.
</P>
</HTML>
",       revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> 1998   </i>
       by Christoph Clauss<br> initially implemented<br>
       </li>
</ul>
</html>"),  Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Rectangle(
                  extent={{-70,30},{70,-30}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Rectangle(extent={{-70,30},{70,-30}}, lineColor={0,0,255}),
                Line(points={{-90,0},{-70,0}}, color={0,0,255}),
                Line(points={{70,0},{90,0}}, color={0,0,255}),
                Text(
                  extent={{-138,-60},{140,-100}},
                  lineColor={0,0,0},
                  pattern=LinePattern.None,
                  textString="G=%G"),
                Text(
                  extent={{-140,40},{142,100}},
                  textString="%name",
                  lineColor={0,0,255})}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Line(points={{-96,0},{-70,0}}, color={0,0,255}),
                Line(points={{70,0},{96,0}}, color={0,0,255}),
                Rectangle(extent={{-70,30},{70,-30}}, lineColor={0,0,255})}));
        equation
          i = G*v;
        end Conductor;

        model Capacitor "Ideal linear electrical capacitor"
          extends Interfaces.OnePort;
          parameter SI.Capacitance C(start=1) "Capacitance";
          annotation (
            Documentation(info="<HTML>
<p>
The linear capacitor connects the branch voltage <i>v</i> with the
branch current <i>i</i> by <i>i = C * dv/dt</i>.
The Capacitance <i>C</i> is allowed to be positive, zero, or negative.
</p>
</HTML>
",       revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> 1998   </i>
       by Christoph Clauss<br> initially implemented<br>
       </li>
</ul>
</html>"),  Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Line(
                  points={{-14,28},{-14,-28}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(
                  points={{14,28},{14,-28}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(points={{-90,0},{-14,0}}, color={0,0,255}),
                Line(points={{14,0},{90,0}}, color={0,0,255}),
                Text(
                  extent={{-136,-60},{136,-100}},
                  lineColor={0,0,0},
                  textString="C=%C"),
                Text(
                  extent={{-142,40},{140,100}},
                  textString="%name",
                  lineColor={0,0,255})}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Line(
                  points={{-20,40},{-20,-40}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(
                  points={{20,40},{20,-40}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(points={{-96,0},{-20,0}}, color={0,0,255}),
                Line(points={{20,0},{96,0}}, color={0,0,255})}));

        equation
          i = C*der(v);
        end Capacitor;

        model Inductor "Ideal linear electrical inductor"
          extends Interfaces.OnePort;
          parameter SI.Inductance L(start=1) "Inductance";
          annotation (
            Documentation(info="<HTML>
<P>
The linear inductor connects the branch voltage <i>v</i> with the
branch current <i>i</i> by  <i>v = L * di/dt</i>.
The Inductance <i>L</i> is allowed to be positive, zero, or negative.
</p>
</HTML>
",       revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> 1998   </i>
       by Christoph Clauss<br> initially implemented<br>
       </li>
</ul>
</html>"),  Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Ellipse(extent={{-60,-15},{-30,15}}, lineColor={0,0,255}),
                Ellipse(extent={{-30,-15},{0,15}}, lineColor={0,0,255}),
                Ellipse(extent={{0,-15},{30,15}}, lineColor={0,0,255}),
                Ellipse(extent={{30,-15},{60,15}}, lineColor={0,0,255}),
                Rectangle(
                  extent={{-60,-30},{60,0}},
                  lineColor={255,255,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{60,0},{90,0}}, color={0,0,255}),
                Line(points={{-90,0},{-60,0}}, color={0,0,255}),
                Text(
                  extent={{-138,-60},{144,-102}},
                  lineColor={0,0,0},
                  textString="L=%L"),
                Text(
                  extent={{-146,38},{148,100}},
                  textString="%name",
                  lineColor={0,0,255})}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={2,2}), graphics={
                Ellipse(extent={{-60,-15},{-30,15}}, lineColor={0,0,255}),
                Ellipse(extent={{-30,-15},{0,15}}, lineColor={0,0,255}),
                Ellipse(extent={{0,-15},{30,15}}, lineColor={0,0,255}),
                Ellipse(extent={{30,-15},{60,15}}, lineColor={0,0,255}),
                Rectangle(
                  extent={{-60,-30},{60,0}},
                  lineColor={255,255,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{60,0},{96,0}}, color={0,0,255}),
                Line(points={{-96,0},{-60,0}}, color={0,0,255})}));
        equation
          L*der(i) = v;
        end Inductor;

        model SaturatingInductor "Simple model of an inductor with saturation"
          extends Modelica.Electrical.Analog.Interfaces.OnePort;
          parameter Modelica.SIunits.Current Inom(start=1) "Nominal current";
          parameter Modelica.SIunits.Inductance Lnom(start=1)
            "Nominal inductance at Nominal current";
          parameter Modelica.SIunits.Inductance Lzer(start=2*Lnom)
            "Inductance near current=0";
          parameter Modelica.SIunits.Inductance Linf(start=Lnom/2)
            "Inductance at large currents";
          Modelica.SIunits.Inductance Lact(start=Lzer);
          Modelica.SIunits.MagneticFlux Psi;
        protected
          parameter Modelica.SIunits.Current Ipar(start=Inom/10, fixed=false);
          annotation (Icon(coordinateSystem(preserveAspectRatio=true, extent={{-100,
                    -100},{100,100}}), graphics={
                Ellipse(extent={{-60,-15},{-30,15}}, lineColor={0,0,255}),
                Ellipse(extent={{-30,-15},{0,15}}, lineColor={0,0,255}),
                Ellipse(extent={{0,-15},{30,15}}, lineColor={0,0,255}),
                Ellipse(extent={{30,-15},{60,15}}, lineColor={0,0,255}),
                Rectangle(
                  extent={{-60,-20},{62,0}},
                  lineColor={255,255,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{60,0},{90,0}}, color={0,0,255}),
                Line(points={{-90,0},{-60,0}}, color={0,0,255}),
                Rectangle(
                  extent={{-60,-10},{60,-20}},
                  lineColor={0,0,0},
                  fillPattern=FillPattern.Sphere,
                  fillColor={0,0,255}),
                Text(
                  extent={{-142,40},{148,102}},
                  textString="%name",
                  lineColor={0,0,255}),
                Text(
                  extent={{-150,-48},{150,-92}},
                  lineColor={0,0,0},
                  textString="Lnom=%Lnom")}),                     Documentation(info="<HTML>
<p>
This model approximates the behaviour of an inductor with the influence of saturation,
i.e. the value of the inductance depends on the current flowing through the inductor.
The inductance decreases as current increases.<br>
The parameters are:
<ul>
<li>Inom...nominal current</li>
<li>Lnom...nominal inductance at nominal current</li>
<li>Lzer...inductance near current = 0; Lzer has to be greater than Lnom</li>
<li>Linf...inductance at large currents; Linf has to be less than Lnom</li>
</ul>
</p>
</HTML>
",       revisions="<html>
<dl>
<p>
  <dt><b>Main Author:</b></dt>
  <dd>
  <a href=\"http://www.haumer.at/\">Anton Haumer</a><br>
  Technical Consulting & Electrical Engineering<br>
  A-3423 St.Andrae-Woerdern<br>Austria<br>
  email: <a href=\"mailto:a.haumer@haumer.at\">a.haumer@haumer.at</a>
  </dd>
</p>
<p>
  <dt><b>Release Notes:</b></dt>
  <dd>
  <ul>
  <li> May 27, 2004: Implemented by Anton Haumer</li>
  </ul>
  </dd>
</dl>
</html>"),  Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,-100},{
                    100,100}}), graphics={
                Ellipse(extent={{-60,-15},{-30,15}}, lineColor={0,0,255}),
                Ellipse(extent={{-30,-15},{0,15}}, lineColor={0,0,255}),
                Ellipse(extent={{0,-15},{30,15}}, lineColor={0,0,255}),
                Ellipse(extent={{30,-15},{60,15}}, lineColor={0,0,255}),
                Rectangle(
                  extent={{-60,-20},{62,0}},
                  lineColor={255,255,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{60,0},{96,0}}, color={0,0,255}),
                Line(points={{-96,0},{-60,0}}, color={0,0,255}),
                Rectangle(
                  extent={{-60,-10},{60,-20}},
                  lineColor={0,0,0},
                  fillPattern=FillPattern.Sphere,
                  fillColor={0,0,255})}));
        initial equation
          (Lnom - Linf) = (Lzer - Linf)*Ipar/Inom*(Modelica.Constants.pi/2-atan(Ipar/Inom));
        equation
          assert(Lzer > Lnom+Modelica.Constants.eps,
                 "Lzer (= " + String(Lzer) + ") has to be > Lnom (= " + String(Lnom) + ")");
          assert(Linf < Lnom-Modelica.Constants.eps,
                 "Linf (= " + String(Linf) + ") has to be < Lnom (= " + String(Lnom) + ")");
          (Lact - Linf)*i/Ipar = (Lzer - Linf)*noEvent(atan(i/Ipar));
          Psi = Lact*i;
          v = der(Psi);
        end SaturatingInductor;

        model Transformer "Transformer with two ports"
          extends Interfaces.TwoPort;
          parameter SI.Inductance L1(start=1) "Primary inductance";
          parameter SI.Inductance L2(start=1) "Secondary inductance";
          parameter SI.Inductance M(start=1) "Coupling inductance";
          annotation (
            Documentation(info="<HTML>
<p>The transformer is a two port. The left port voltage <i>v1</i>, left port current <i>i1</i>,
right port voltage <i>v2</i> and right port current <i>i2</i> are connected by the following
relation:</p>
<pre>         | v1 |         | L1   M  |  | i1' |
         |    |    =    |         |  |     |
         | v2 |         | M    L2 |  | i2' |</pre>
<p><i>L1</i>, <i>L2</i>, and <i>M</i> are the primary, secondary, and coupling inductances respectively.</p>
</html>
",       revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> 1998   </i>
       by Christoph Clauss<br> initially implemented<br>
       </li>
</ul>
</html>"),  Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics={
                Text(
                  extent={{-100,128},{100,70}},
                  textString="%name",
                  lineColor={0,0,255}),
                Ellipse(extent={{-45,-50},{-20,-25}}, lineColor={0,0,255}),
                Ellipse(extent={{-45,-25},{-20,0}}, lineColor={0,0,255}),
                Ellipse(extent={{-45,0},{-20,25}}, lineColor={0,0,255}),
                Ellipse(extent={{-45,25},{-20,50}}, lineColor={0,0,255}),
                Rectangle(
                  extent={{-72,-60},{-33,60}},
                  lineColor={255,255,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{-90,50},{-32,50}}, color={0,0,255}),
                Line(points={{-90,-50},{-32,-50}}, color={0,0,255}),
                Ellipse(extent={{20,-50},{45,-25}}, lineColor={0,0,255}),
                Ellipse(extent={{20,-25},{45,0}}, lineColor={0,0,255}),
                Ellipse(extent={{20,0},{45,25}}, lineColor={0,0,255}),
                Ellipse(extent={{20,25},{45,50}}, lineColor={0,0,255}),
                Rectangle(
                  extent={{33,-60},{72,60}},
                  lineColor={255,255,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{32,50},{90,50}}, color={0,0,255}),
                Line(points={{32,-50},{90,-50}}, color={0,0,255}),
                Text(
                  extent={{-89,18},{-60,-10}},
                  textString="L1",
                  lineColor={0,0,255}),
                Text(
                  extent={{64,18},{90,-10}},
                  textString="L2",
                  lineColor={0,0,255}),
                Text(
                  extent={{-18,-70},{20,-98}},
                  textString="M",
                  lineColor={0,0,255})}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics={
                Ellipse(extent={{-45,-50},{-20,-25}}, lineColor={0,0,255}),
                Ellipse(extent={{-45,-25},{-20,0}}, lineColor={0,0,255}),
                Ellipse(extent={{-45,0},{-20,25}}, lineColor={0,0,255}),
                Ellipse(extent={{-45,25},{-20,50}}, lineColor={0,0,255}),
                Rectangle(
                  extent={{-72,-60},{-33,60}},
                  lineColor={255,255,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{-96,50},{-32,50}}, color={0,0,255}),
                Line(points={{-96,-50},{-32,-50}}, color={0,0,255}),
                Ellipse(extent={{20,-50},{45,-25}}, lineColor={0,0,255}),
                Ellipse(extent={{20,-25},{45,0}}, lineColor={0,0,255}),
                Ellipse(extent={{20,0},{45,25}}, lineColor={0,0,255}),
                Ellipse(extent={{20,25},{45,50}}, lineColor={0,0,255}),
                Rectangle(
                  extent={{33,-60},{72,60}},
                  lineColor={255,255,255},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid),
                Line(points={{32,50},{96,50}}, color={0,0,255}),
                Line(points={{32,-50},{96,-50}}, color={0,0,255})}));
        equation
          v1 = L1*der(i1) + M*der(i2);
          v2 = M*der(i1) + L2*der(i2);
        end Transformer;

        model Gyrator "Gyrator"
          extends Interfaces.TwoPort;
          parameter SI.Conductance G1(start=1) "Gyration conductance";
          parameter SI.Conductance G2(start=1) "Gyration conductance";
          annotation (
            Documentation(info="<HTML>
<P>
A gyrator is a two-port element defined by the following equations:
</P>
<PRE>
    i1 =  G2 * v2
    i2 = -G1 * v1
</PRE>
<P>
where the constants <i>G1</i>, <i>G2</i> are called the gyration conductance.
</P>
</HTML>
",       revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> 1998   </i>
       by Christoph Clauss<br> initially implemented<br>
       </li>
</ul>
</html>"),  Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics={
                Rectangle(
                  extent={{-60,60},{60,-60}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Line(points={{-90,50},{-60,50}}, color={0,0,255}),
                Line(points={{-90,-50},{-60,-50}}, color={0,0,255}),
                Line(points={{60,50},{90,50}}, color={0,0,255}),
                Line(points={{60,-50},{90,-50}}, color={0,0,255}),
                Line(points={{-40,30},{40,30}}, color={0,0,255}),
                Line(points={{-20,-20},{20,-20}}, color={0,0,255}),
                Polygon(
                  points={{30,34},{40,30},{30,26},{30,34}},
                  fillColor={0,0,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Polygon(
                  points={{-26,-19},{-16,-15},{-16,-23},{-26,-19}},
                  fillColor={0,0,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Line(
                  points={{-5,10},{-10,-10}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(
                  points={{9,10},{4,-9}},
                  thickness=0.5,
                  color={0,0,255}),
                Line(
                  points={{-14,9},{16,10}},
                  thickness=0.5,
                  color={0,0,255}),
                Text(
                  extent={{-100,130},{100,69}},
                  textString="%name",
                  lineColor={0,0,255}),
                Text(
                  extent={{-29,59},{30,30}},
                  textString="G1",
                  lineColor={0,0,255}),
                Text(
                  extent={{-29,-29},{29,-58}},
                  textString="G2",
                  lineColor={0,0,255})}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics={
                Rectangle(extent={{-60,60},{60,-60}}, lineColor={0,0,255}),
                Line(points={{-96,50},{-60,50}}, color={0,0,255}),
                Line(points={{-96,-50},{-60,-50}}, color={0,0,255}),
                Line(points={{60,50},{96,50}}, color={0,0,255}),
                Line(points={{60,-50},{96,-50}}, color={0,0,255}),
                Line(points={{-40,30},{40,30}}, color={0,0,255}),
                Line(points={{-21,-22},{19,-22}}, color={0,0,255}),
                Polygon(
                  points={{30,34},{40,30},{30,26},{30,34}},
                  fillColor={0,0,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Polygon(
                  points={{-20,-30},{-10,-26},{-10,-34},{-20,-30}},
                  fillColor={0,0,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Line(
                  points={{-4,5},{-6,-5}},
                  thickness=1,
                  color={0,0,255}),
                Line(
                  points={{3,5},{1,-5}},
                  thickness=1,
                  color={0,0,255}),
                Line(
                  points={{-8,5},{7,5}},
                  thickness=1,
                  color={0,0,255}),
                Text(
                  extent={{-20,50},{20,35}},
                  textString="G1",
                  lineColor={0,0,255}),
                Text(
                  extent={{-20,-35},{20,-50}},
                  textString="G2",
                  lineColor={0,0,255})}));
        equation
          i1 = G2*v2;
          i2 = -G1*v1;
        end Gyrator;

        model EMF "Electromotoric force (electric/mechanic transformer)"
          parameter Boolean useSupport=false
            "= true, if support flange enabled, otherwise implicitly grounded" 
              annotation(Evaluate=true, HideResult=true, choices(__Dymola_checkBox=true));
          parameter SI.ElectricalTorqueConstant k(start=1)
            "Transformation coefficient";
          SI.Voltage v "Voltage drop between the two pins";
          SI.Current i "Current flowing from positive to negative pin";
          SI.Angle phi
            "Angle of shaft flange with respect to support (= flange.phi - support.phi)";
          SI.AngularVelocity w "Angular velocity of flange relatuve to support";
          Interfaces.PositivePin p annotation (Placement(transformation(
                origin={0,100},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Interfaces.NegativePin n annotation (Placement(transformation(
                origin={0,-100},
                extent={{-10,-10},{10,10}},
                rotation=90)));
          Modelica.Mechanics.Rotational.Interfaces.Flange_b flange 
            annotation (Placement(transformation(extent={{90,-10},{110,10}}, rotation=0)));
          Mechanics.Rotational.Interfaces.Support support if useSupport
            "Support/housing of emf shaft" 
            annotation (Placement(transformation(extent={{-110,-10},{-90,10}})));
          annotation (
            defaultComponentName="emf",
            Icon(
                coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics={
                Rectangle(
                  extent={{-85,10},{-36,-10}},
                  lineColor={0,0,0},
                  fillPattern=FillPattern.HorizontalCylinder,
                  fillColor={192,192,192}),
                Line(points={{0,90},{0,40}}, color={0,0,255}),
                Rectangle(
                  extent={{35,10},{100,-10}},
                  lineColor={0,0,0},
                  fillPattern=FillPattern.HorizontalCylinder,
                  fillColor={192,192,192}),
                Ellipse(
                  extent={{-40,40},{40,-40}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Line(points={{0,-90},{0,-40}}, color={0,0,255}),
                Text(
                  extent={{20,-40},{100,-100}},
                  textString="%name",
                  lineColor={0,0,255}),
                Text(
                  extent={{0,80},{148,44}},
                  lineColor={160,160,164},
                  textString="k=%k"),
                Line(
                  visible=not useSupport,
                  points={{-100,-30},{-40,-30}},
                  color={0,0,0}),
                Line(
                  visible=not useSupport,
                  points={{-100,-50},{-80,-30}},
                  color={0,0,0}),
                Line(
                  visible=not useSupport,
                  points={{-80,-50},{-60,-30}},
                  color={0,0,0}),
                Line(
                  visible=not useSupport,
                  points={{-60,-50},{-40,-30}},
                  color={0,0,0}),
                Line(
                  visible=not useSupport,
                  points={{-70,-30},{-70,-10}},
                  color={0,0,0})}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics={
                Polygon(
                  points={{-17,95},{-20,85},{-23,95},{-17,95}},
                  lineColor={160,160,164},
                  fillColor={160,160,164},
                  fillPattern=FillPattern.Solid),
                Line(points={{-20,110},{-20,85}}, color={160,160,164}),
                Text(
                  extent={{-40,110},{-30,90}},
                  lineColor={160,160,164},
                  fillColor={160,160,164},
                  fillPattern=FillPattern.Solid,
                  textString="i"),
                Line(points={{9,75},{19,75}}, color={192,192,192}),
                Line(points={{-20,-110},{-20,-85}}, color={160,160,164}),
                Polygon(
                  points={{-17,-100},{-20,-110},{-23,-100},{-17,-100}},
                  lineColor={160,160,164},
                  fillColor={160,160,164},
                  fillPattern=FillPattern.Solid),
                Text(
                  extent={{-40,-110},{-30,-90}},
                  lineColor={160,160,164},
                  textString="i"),
                Line(points={{8,-79},{18,-79}}, color={192,192,192}),
                Line(points={{14,80},{14,70}}, color={192,192,192})}),
            Documentation(info="<HTML>
<p>
EMF transforms electrical energy into rotational mechanical energy.
It is used as basic building block of an electrical motor. The mechanical
connector shaft can be connected to elements of the
Modelica.Mechanics.Rotational library. shaft.tau is the cut-torque,
flange.phi is the angle at the rotational connection.
</p>
</HTML>
",       revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> 1998   </i>
       by Martin Otter<br> initially implemented<br>
       </li>
</ul>
</html>"));
        protected
          Mechanics.Rotational.Components.Fixed fixed if not useSupport 
            annotation (Placement(transformation(extent={{-90,-20},{-70,0}})));
          Mechanics.Rotational.Interfaces.InternalSupport internalSupport(tau=-flange.tau) 
            annotation (Placement(transformation(extent={{-90,-10},{-70,10}})));
        equation
          v = p.v - n.v;
          0 = p.i + n.i;
          i = p.i;

          phi = flange.phi - internalSupport.phi;
          w = der(phi);
          k*w = v;
          flange.tau = -k*i;
          connect(internalSupport.flange, support) annotation (Line(
              points={{-80,0},{-100,0}},
              color={0,0,0},
              smooth=Smooth.None));
          connect(internalSupport.flange,fixed. flange) annotation (Line(
              points={{-80,0},{-80,-10}},
              color={0,0,0},
              smooth=Smooth.None));
        end EMF;

        model VCV "Linear voltage-controlled voltage source"
          extends Interfaces.TwoPort;
          parameter Real gain(start=1) "Voltage gain";
          annotation (
            Documentation(info="<HTML>
<p>
The linear voltage-controlled voltage source is a TwoPort.
The right port voltage v2 is controlled by the left port voltage v1
via
</p>
<pre>
    v2 = v1 * gain.
</pre>
<p>
The left port current is zero. Any voltage gain can be chosen.
</p>
</HTML>
",       revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> 1998   </i>
       by Christoph Clauss<br> initially implemented<br>
       </li>
</ul>
</html>"),  Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics={
                Rectangle(
                  extent={{-70,70},{70,-70}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Text(
                  extent={{-99,-79},{100,-129}},
                  textString="%name",
                  lineColor={0,0,255}),
                Line(points={{-90,50},{-30,50}}, color={0,0,255}),
                Line(points={{-30,-50},{-90,-50}}, color={0,0,255}),
                Line(points={{100,50},{30,50},{30,-50},{100,-50}}, color={0,0,255}),
                Ellipse(extent={{10,20},{50,-20}}, lineColor={0,0,255}),
                Line(points={{-20,60},{20,60}}, color={0,0,255}),
                Polygon(
                  points={{20,60},{10,63},{10,57},{20,60}},
                  fillColor={0,0,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255})}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics={
                Line(points={{-96,50},{-31,50}}, color={0,0,255}),
                Line(points={{-30,-50},{-96,-50}}, color={0,0,255}),
                Line(points={{96,50},{30,50},{30,-50},{96,-50}}, color={0,0,255}),
                Ellipse(extent={{10,20},{50,-20}}, lineColor={0,0,255}),
                Rectangle(extent={{-70,70},{70,-70}}, lineColor={0,0,255}),
                Line(points={{-20,60},{20,60}}, color={0,0,255}),
                Polygon(
                  points={{20,60},{10,63},{10,57},{20,60}},
                  fillColor={0,0,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255})}));
        equation
          v2 = v1*gain;
          i1 = 0;
        end VCV;

        model VCC "Linear voltage-controlled current source"
          extends Interfaces.TwoPort;
          parameter SI.Conductance transConductance(start=1) "Transconductance";
          annotation (
            Documentation(info="<HTML>
<p>
The linear voltage-controlled current source is a TwoPort.
The right port current i2 is controlled by the left port voltage v1
via
</p>
<pre>
    i2 = v1 * transConductance.
</pre>
<p>
The left port current is zero. Any transConductance can be chosen.
</p>
</HTML>
",       revisions="<html>
<ul>
<li><i>  </i>
       </li>
<li><i> 1998   </i>
       by Christoph Clauss<br> initially implemented<br>
       </li>
</ul>
</html>"),  Icon(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics={
                Rectangle(
                  extent={{-70,70},{70,-70}},
                  fillColor={255,255,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Text(
                  extent={{-99,-80},{100,-129}},
                  textString="%name",
                  lineColor={0,0,255}),
                Line(points={{-90,50},{-30,50}}, color={0,0,255}),
                Line(points={{-30,-50},{-90,-50}}, color={0,0,255}),
                Ellipse(extent={{10,20},{50,-20}}, lineColor={0,0,255}),
                Line(points={{-20,60},{20,60}}, color={0,0,255}),
                Polygon(
                  points={{20,60},{10,63},{10,57},{20,60}},
                  fillColor={0,0,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Line(points={{90,50},{30,50},{30,20}}, color={0,0,255}),
                Line(points={{91,-50},{30,-50},{30,-20}}, color={0,0,255}),
                Line(points={{10,0},{50,0}}, color={0,0,255})}),
            Diagram(coordinateSystem(
                preserveAspectRatio=true,
                extent={{-100,-100},{100,100}},
                grid={1,1}), graphics={
                Line(points={{-96,50},{-30,50}}, color={0,0,255}),
                Line(points={{-30,-50},{-96,-50}}, color={0,0,255}),
                Ellipse(extent={{10,20},{50,-20}}, lineColor={0,0,255}),
                Rectangle(extent={{-70,70},{70,-70}}, lineColor={0,0,255}),
                Line(points={{-20,60},{20,60}}, color={0,0,255}),
                Polygon(
                  points={{20,60},{10,63},{10,57},{20,60}},
                  fillColor={0,0,255},
                  fillPattern=FillPattern.Solid,
                  lineColor={0,0,255}),
                Line(points={{96,50},{30,50},{30,20}}, color={0,0,255}),
                Line(points={{96,-50},{30,-50},{30,-20}}, color={0,0,255}),
                Line(points={{10,0},{50,0}}, color={0,0,255})}));
        equation
          i2 = v1*transConductance;
          i1 = 0;
 