"class fmuModelInst\n"
"    extends ExternalObject;\n"
"    function constructor\n"
"      input fmuFunctions in_fmufun;\n"
"      input String in_instName;\n"
"      input String guid;\n"
"      input fmuCallbackFuns functions;\n"
"      input Boolean logFlag;\n"
"      output fmuModelInst inst;\n"
"      external \"C\" inst = fmiInstantiate(in_fmufun,in_instName,guid,functions,logFlag)       annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\");\n"
"    end constructor;\n"
"    function destructor\n"
"		input fmuModelInst in_inst;\n"
"      external \"C\" fmiFreeDummy(in_inst)       annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"    end destructor;\n"
"  end fmuModelInst;\n"
"  \n"
"  class fmuLoadDll \"load dll from FMU\"\n"
"    extends ExternalObject;\n"
"    function constructor\n"
"      input fmuFunctions in_fmufun;\n"
"      input String in_dllPath;\n"
"      output fmuLoadDll dummy;\n"
"      external \"C\" dummy = loadFMUDll(in_fmufun,in_dllPath)       annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\");\n"
"    end constructor;\n"
"    function destructor\n"
"      external \"C\" freeFMUDll()       annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"    end destructor;\n"
"  end fmuLoadDll;\n"
"  \n"
"  class fmuFunctions \"List of interface functions defined in FMI 1.0\"\n"
"    extends ExternalObject;\n"
"    function constructor\n"
"	  input String mid;\n"
"      input String dllPath;\n"
"      output fmuFunctions fmufun;\n"
"      external \"C\" fmufun = instantiateFMIFun(mid,dllPath)       annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\");\n"
"    end constructor;\n"
"    function destructor\n"
"      input fmuFunctions fmufun;\n"
"      external \"C\" fmiFreeDummy(fmufun)        annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"    end destructor;\n"
"  end fmuFunctions;\n"
"  \n"
"  class fmuCallbackFuns \"Construct for callbacks defined in FMU\"\n"
"    extends ExternalObject;\n"
"    function constructor\n"
"      output fmuCallbackFuns functions;\n"
"      external \"C\" functions = fmiCallbackFuns()       annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\");\n"
"    end constructor;\n"
"    function destructor\n"
"      input fmuCallbackFuns functions;\n"
"      external \"C\" fmiFreeDummy(functions)        annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"    end destructor;\n"
"  end fmuCallbackFuns;\n"
"  \n"
"  function fmuSetTime\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst inst;\n"
"    input Real in_time;\n"
"    external \"C\" fmiSetT(fmufun,inst,in_time)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuSetTime;\n"
"  \n"
"  function fmuSetContStates \"set values of continuous states\"\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst in_inst;\n"
"	input Integer nx;\n"
"    input Real x[nx];\n"
"    external \"C\" fmiSetContStates(fmufun,in_inst,x,nx)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuSetContStates;\n"
"  \n"
"  function fmuSetRealVR \"set values of real variables via value references\"\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst in_inst;\n"
"	input Integer nr;\n"
"    input Integer in_vr[nr];\n"
"    input Real in_rv[nr];\n"
"    external \"C\" fmiSetRealVR(fmufun,in_inst,in_vr,in_rv,nr)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuSetRealVR;\n"
"  \n"
"  function fmuSetIntegerVR \"set values of integer variables via value references\"\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst in_inst;\n"
"	input Integer ni;\n"
"    input Integer in_vr[ni];\n"
"    input Integer in_iv[ni];\n"
"    external \"C\" fmiSetIntegerVR(fmufun,in_inst,in_vr,in_iv,ni)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuSetIntegerVR;\n"
"  \n"
"  function fmuSetStringVR \"set values of string variables via value references\"\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst in_inst;\n"
"	input Integer ns;\n"
"    input Integer in_vr[ns];\n"
"    input String in_sv[ns];\n"
"    external \"C\" fmiSetStringVR(fmufun,in_inst,in_vr,in_sv,ns)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuSetStringVR;\n"
"  \n"
"  function fmuSetBooleanVR \"set values of boolean variables via value references\"\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst in_inst;\n"
"	input Integer nb;\n"
"    input Integer in_vr[nb];\n"
"    input Boolean in_bv[nb];\n"
"    external \"C\" fmiSetBooleanVR(fmufun,in_inst,in_vr,in_bv,nb)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuSetBooleanVR;\n"
"  \n"
"  function fmuGetContStates \"get values of continuous states\"\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst in_inst;\n"
"	input Integer nx;\n"
"    output Real in_x[nx];\n"
"    external \"C\" fmiGetContStates(fmufun,in_inst,in_x,nx)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuGetContStates;\n"
"  \n"
"  function fmuGetRealVR \"get values of real variables via value references\"\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst in_inst;\n"
"	input Integer nr;\n"
"    input Integer in_vr[nr];\n"
"    output Real rv[nr];\n"
"    external \"C\" fmiGetRealVR(fmufun,in_inst,in_vr,rv,nr)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuGetRealVR;\n"
"  \n"
"  function fmuGetIntegerVR \"get values of integer variables via value references\"\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst in_inst;\n"
"	input Integer ni;\n"
"    input Integer in_vr[ni];\n"
"    output Integer iv[ni];\n"
"    external \"C\" fmiGetIntegerVR(fmufun,in_inst,in_vr,iv,ni)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuGetIntegerVR;\n"
"  \n"
"  function fmuGetStringVR \"get values of string variables via value references\"\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst in_inst;\n"
"	input Integer ns;\n"
"    input Integer in_vr[ns];\n"
"    output String sv[ns];\n"
"    external \"C\" fmiGetStringVR(fmufun,in_inst,in_vr,sv,ns)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuGetStringVR;\n"
"  \n"
"  function fmuGetBooleanVR \"get values of boolean variables via value references\"\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst in_inst;\n"
"	input Integer nb;\n"
"    input Integer in_vr[nb];\n"
"    output Boolean bv[nb];\n"
"    external \"C\" fmiGetBooleanVR(fmufun,in_inst,in_vr,bv,nb)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuGetBooleanVR;\n"
"  \n"
"  function fmuGetDer \"function to calculate the derivatives\"\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst inst;\n"
"	input Integer nx;\n"
"    input Real x[nx];\n"
"    output Real der_x_out[nx];\n"
"    external \"C\" fmiGetDer(fmufun,inst,der_x_out,nx,x)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuGetDer;\n"
"  \n"
"  class fmuEventInfo\n"
"    extends ExternalObject;\n"
"    function constructor\n"
"      output fmuEventInfo evtInfo;\n"
"      external \"C\" evtInfo = fmiEvtInfo()       annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\");\n"
"    end constructor;\n"
"    function destructor\n"
"      input fmuEventInfo evtInfo;\n"
"      external \"C\" freefmiEvtInfo(evtInfo)       annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"    end destructor;\n"
"  end fmuEventInfo;\n"
"  \n"
"  class fmuBoolean\n"
"    extends ExternalObject;\n"
"    function constructor\n"
"      input Integer default;\n"
"      output fmuBoolean fmuBool;\n"
"      external \"C\" fmuBool = fmuBooleanInst(default)       annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\");\n"
"    end constructor;\n"
"    function destructor\n"
"      input fmuBoolean in_bool;\n"
"      external \"C\" freefmuBooleanInst(in_bool)       annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"    end destructor;\n"
"  end fmuBoolean;\n"
"  \n"
"  function fmuInit\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst inst;\n"
"    input Boolean tolControl;\n"
"    input Real relTol;\n"
"    input fmuEventInfo evtInfo;\n"
"    external \"C\" fmiInit(fmufun,inst,tolControl,relTol,evtInfo)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuInit;\n"
"  \n"
"  function fmuCompIntStep\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst inst;\n"
"    input fmuBoolean stepEvt;\n"
"    external \"C\" fmiCompIntStep(fmufun,inst,stepEvt)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuCompIntStep;\n"
"  \n"
"  function fmuGetTimeEvt\n"
"    input fmuEventInfo in_evtInfo;\n"
"    input Real in_time;\n"
"    input Real in_pretime;\n"
"    input fmuBoolean in_timeEvt;\n"
"    output Real out_nextTime;\n"
"    external \"C\" fmiGetTimeEvent(in_evtInfo,in_time,in_pretime,in_timeEvt,out_nextTime)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuGetTimeEvt;\n"
"  \n"
"  function fmuGetEventInd\n"
"    input fmuFunctions fmufun;\n"
"    input fmuModelInst inst;\n"
"    input Integer nz;\n"
"    output Real z[nz];\n"
"    external \"C\" fmiGetEventInd(fmufun,inst,z,nz)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuGetEventInd;\n"
"  \n"
"  function fmuStateEvtCheck\n"
"    input fmuBoolean stateEvt;\n"
"    input Integer nz;\n"
"    input Real z[nz];\n"
"    input Real prez[nz];\n"
"    external \"C\" fmuStateEventCheck(stateEvt,nz,z,prez)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuStateEvtCheck;\n"
"  \n"
"  function fmuEvtUpdate\n"
"    input fmuFunctions in_fmufun;\n"
"    input fmuModelInst in_inst;\n"
"    input fmuEventInfo in_evtInfo;\n"
"    input fmuBoolean timeEvt;\n"
"    input fmuBoolean stepEvt;\n"
"    input fmuBoolean stateEvt;\n"
"    input fmuBoolean interMediateRes;\n"
"    external \"C\" fmuEventUpdate(in_fmufun,in_inst,in_evtInfo,timeEvt,stepEvt,stateEvt,interMediateRes)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end fmuEvtUpdate;\n"
"  \n"
"  function fmuFreeAll	\n"
"	input fmuFunctions in_fmufun;\n"
"	input fmuModelInst in_inst;\n"
"	input fmuCallbackFuns functions;\n"
"	output fmuBoolean dummy;\n"
"	external \"C\" fmuFreeAll(in_fmufun,in_inst,functions,dummy) annotation(Include = \"#include <fmuWrapper.h>\", Library = \"fmuWrapper.o\");\n"
"  end fmuFreeAll;\n"
"  \n"
"  function PrintState\n"
"    input fmuModelInst in_fmu;\n"
"    input Real in_time;\n"
"    external \"C\" PrintModelStates(in_fmu,in_time)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end PrintState;\n"
"  \n"
"  function printVariable\n"
"    input Real var[:];\n"
"    input Integer n;\n"
"    input String varName;\n"
"    external \"C\" printVariables(var,n,varName)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end printVariable;\n"
"  \n"
"  function printIntVariable\n"
"    input Integer var[:];\n"
"    input Integer n;\n"
"    input String varName;\n"
"    external \"C\" printIntVariables(var,n,varName)     annotation(Include=\"#include <fmuWrapper.h>\",Library = \"fmuWrapper.o\"); \n"
"  end printIntVariable;\n"
"  \n"
"  function Bool2Int\n"
"    input Integer dim;\n"
"    input Boolean in_bv[dim];\n"
"    output Integer out_iv[dim];\n"
"  algorithm \n"
"    for i in 1:dim loop\n"
"          out_iv[i]:=if in_bv[i] then 1 else 0;\n"
"    end for;\n"
"  end Bool2Int;\n"
"  \n"
"  function Int2Bool\n"
"    input Integer dim;\n"
"    input Integer in_iv[dim];\n"
"    output Boolean out_bv[dim];\n"
"  algorithm \n"
"    for i in 1:dim loop\n"
"          out_bv[i]:=if in_iv[i] == 1 then true else false;\n"
"    end for;\n"
"  end Int2Bool;\n"
"  \n"