// $Id: WidgetSelectModModel.cpp 9744 2011-09-05 11:25:40Z hubert.thieriot $
/**
 * This file is part of OpenModelica.
 *
 * Copyright (c) 1998-CurrentYear, Open Source Modelica Consortium (OSMC),
 * c/o Linköpings universitet, Department of Computer and Information Science,
 * SE-58183 Linköping, Sweden.
 *
 * All rights reserved.
 *
 * THIS PROGRAM IS PROVIDED UNDER THE TERMS OF GPL VERSION 3 LICENSE OR 
 * THIS OSMC PUBLIC LICENSE (OSMC-PL). 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS PROGRAM CONSTITUTES RECIPIENT'S ACCEPTANCE
 * OF THE OSMC PUBLIC LICENSE OR THE GPL VERSION 3, ACCORDING TO RECIPIENTS CHOICE. 
 *
 * The OpenModelica software and the Open Source Modelica
 * Consortium (OSMC) Public License (OSMC-PL) are obtained
 * from OSMC, either from the above address,
 * from the URLs: http://www.ida.liu.se/projects/OpenModelica or  
 * http://www.openmodelica.org, and in the OpenModelica distribution. 
 * GNU version 3 is obtained from: http://www.gnu.org/copyleft/gpl.html.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without
 * even the implied warranty of  MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE, EXCEPT AS EXPRESSLY SET FORTH
 * IN THE BY RECIPIENT SELECTED SUBSIDIARY LICENSE CONDITIONS OF OSMC-PL.
 *
 * See the full OSMC Public License conditions for more details.
 *
 * Main contributor 2010, Hubert Thierot, CEP - ARMINES (France)
 * Main contributor 2010, Hubert Thierot, CEP - ARMINES (France)

 	@file WidgetSelectModModel.cpp
 	@brief Comments for file documentation.
 	@author Hubert Thieriot, hubert.thieriot@mines-paristech.fr
 	Company : CEP - ARMINES (France)
 	http://www-cep.ensmp.fr/english/
 	@version 
*/

#include "WidgetSelectModModel.h"
#include "ui_WidgetSelectModModel.h"
#include <QtGui/QErrorMessage>


        WidgetSelectModModel::WidgetSelectModModel(ModClassTree* modClassTree,QWidget *parent ):
QDialog(parent),
ui(new Ui::WidgetSelectModModelClass)
{
	ui->setupUi(this);
    _modClassTree = modClassTree;

	ui->treeView->setModel(modClassTree);
	connect(ui->treeView, SIGNAL(clicked(QModelIndex)),this, SLOT(onSelectedModClass(QModelIndex)));
	connect(ui->pushValidate,SIGNAL(clicked()),this,SLOT(accept()));
        connect(ui->pushCancel,SIGNAL(clicked()),this,SLOT(reject()));
	setSelectedModModel(NULL);
}

void WidgetSelectModModel::onSelectedModClass(QModelIndex index)
{
	if(index.isValid())
	{
        ModClass* modClass = static_cast<ModClass*>(index.internalPointer());
        setSelectedModModel(modClass);
	}
	else
		setSelectedModModel(NULL);
}

WidgetSelectModModel::~WidgetSelectModModel()
{
	delete ui;
}

void WidgetSelectModModel::setSelectedModModel(ModClass* modClass)
{
    selectedModel = dynamic_cast<ModModel*>(modClass);
		
		if(selectedModel)
    {
			ui->pushValidate->setEnabled(true);
        ui->pushValidate->setFocus();
    }
		else
			ui->pushValidate->setEnabled(false);
}

