#pragma once

// Output
#include <fstream>
using std::ios;
#define RESULTS_FILE "results.txt"
/**
Policy class to write simulation results in a text file
*/
template <unsigned long dim_1,unsigned long dim_2 > 
struct TextFileWriter
{
public:
	TextFileWriter(unsigned long size,string output_path)
		:_curser_position(0)
	{
		_output_path=output_path;
		stringstream res_output_path;
		res_output_path <<   output_path  <<RESULTS_FILE;
		_output_stream.open(res_output_path.str().c_str(), ios::out);
	}
	~TextFileWriter()
	{
	  if(_output_stream.is_open())
		 _output_stream.close();
	}

	void read(ublas::matrix<double>& R,ublas::matrix<double>& dR)
	{
		//not supported for file output

	}
	
	
	void read(const double& time,ublas::vector<double>& dv,ublas::vector<double>& v)
	{
		//not supported for file output
		
	}
	void read(ublas::matrix<double>& R,vector<unsigned int>& indices)
	{
		//not supported for file output

	}
	
	
	void write(const vector<string>& s_list)
	{
		string s;
		_output_stream<<"time"<<"\t";
		BOOST_FOREACH(s, s_list) 
		{
			_output_stream<<s<<"\t";

		}
		_output_stream<<std::endl;
			
	}
	
	void write(const char c)
	{
		_output_stream<<c;
	}
	
	void write(const ublas::vector<double>& v_list,const ublas::vector<double>& v2_list,double time)
	{
		_output_stream<<time<<"\t";
		double v,v2;
		BOOST_FOREACH(v, v_list) 
		{
			_output_stream<<v<<"\t";
		}
		BOOST_FOREACH(v2, v2_list) 
		{
			_output_stream<<v2<<"\t";
		}
		_output_stream<<std::endl;
	}
	
	void getTime(vector<double>& time)
	{
		
		//not supported for file output
			
	}
	unsigned long size()
	{
		//not supported for file output
		return 0;
	}
	void eraseAll()
	{
     	_curser_position=0;
		_output_stream.seekp(_curser_position);
	};
typedef ublas::vector<double, ublas::bounded_array<double,dim_1> > value_type_v;
typedef ublas::vector<double, ublas::bounded_array<double,dim_2> > value_type_dv;		
protected:
	std::fstream _output_stream;
	unsigned int		_curser_position;				///< Controls current Curser-Position
	string _output_path;
	

};
