#pragma once

#include "System/Newton/Interfaces/INewtonSettings.h"

class NewtonSettings :public INewtonSettings
{
public:
	NewtonSettings();
		/*max. Anzahl an Newtonititerationen pro Schritt (default: 25)*/
	virtual long int    getNewtMax();					
	virtual void		setNewtMax(long int);	
	/* Relative Toleranz fr die Newtoniteration (default: 1e-6)*/
	virtual double		getRtol();
	virtual void		setRtol(double);				
	/*Absolute Toleranz fr die Newtoniteration (default: 1e-6)*/
	virtual double		getAtol();						
	virtual void		setAtol(double);				
	/*Dmpfungsfaktor (default: 0.9)*/
	virtual double	    getDelta();							
	virtual void	    setDelta(double);
	virtual void load(string);
private:
	long int    iNewt_max;					///< max. Anzahl an Newtonititerationen pro Schritt (default: 25)

	double		dRtol;						///< Relative Toleranz fr die Newtoniteration (default: 1e-6)
	double		dAtol;						///< Absolute Toleranz fr die Newtoniteration (default: 1e-6)
	double	    dDelta;						///< Dmpfungsfaktor (default: 0.9)
};
