encapsulated package CodegenCpp
"
  file:        CodegenCpp.mo
  package:     CodegenCpp
  description: Generated by Susan.
  
  $Id: CodegenCpp.mo 11619 2012-03-30 19:57:54Z mahge930 $
"

public import Tpl;

public import SimCode;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_allEquations;
      String i_fileNamePrefix;
      list<SimCode.Function> i_modelInfo_functions;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name, functions = i_modelInfo_functions), fileNamePrefix = i_fileNamePrefix, allEquations = i_allEquations)) )
      equation
        txt_0 = simulationHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_1 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
        txt_2 = simulationCppFile(Tpl.emptyTxt, i_simCode);
        txt_3 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING(".cpp"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt_4 = simulationFunctionsHeaderFile(Tpl.emptyTxt, i_simCode, i_modelInfo_functions);
        Tpl.textFile(txt_4, "Functions.h");
        txt_5 = simulationFunctionsFile(Tpl.emptyTxt, i_simCode, i_modelInfo_functions);
        Tpl.textFile(txt_5, "Functions.cpp");
        txt_6 = simulationMakefile(Tpl.emptyTxt, i_simCode);
        txt_7 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_7 = Tpl.writeTok(txt_7, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_6, Tpl.textString(txt_7));
        txt = algloopfiles(txt, i_allEquations, i_simCode);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end translateModel;

public function translateFunctions
  input Tpl.Text in_txt;
  input SimCode.FunctionCode in_a_functionCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_functionCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.FUNCTIONCODE(name = _) )
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end translateFunctions;

public function simulationHeaderFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateHeaderInlcudeString(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = generateClassDeclarationCode(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end simulationHeaderFile;

public function algloopHeaderFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)),
           a_eq )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateAlgloopHeaderInlcudeString(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = generateAlgloopClassDeclarationCode(txt, i_simCode, a_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end algloopHeaderFile;

public function simulationFunctionsFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Function> in_a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_functions)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_functions;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _))),
           a_functions )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include \"Modelica.h\"\n",
                                    "#include \"Functions.h\"\n",
                                    "\n",
                                    " Functions::Functions()\n",
                                    " {\n",
                                    " }\n",
                                    "\n",
                                    " Functions::~Functions()\n",
                                    " {\n",
                                    " }\n",
                                    "  void Functions::Assert(bool cond,string msg)\n",
                                    "  {\n",
                                    "      if(!cond)\n",
                                    "          throw std::runtime_error(msg);\n",
                                    "  }\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = functionBodies(txt, a_functions, i_simCode);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end simulationFunctionsFile;

public function simulationFunctionsHeaderFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Function> in_a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_functions)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_functions;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _))),
           a_functions )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma once\n",
                                    "#include \"Math/Implementation/ArrayOperations.h\"\n",
                                    "#include \"Math/Implementation/Functions.h\"\n",
                                    " #include \"LibrariesConfig.h\"\n",
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Simulation code for FunctionCall functions generated by the OpenModelica Compiler.\n",
                                    "*\n",
                                    "*****************************************************************************/\n",
                                    "//external c functions\n",
                                    "extern \"C\" {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = externfunctionHeaderDefinition(txt, a_functions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = functionHeaderBodies1(txt, a_functions, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "class Functions\n",
                                    "   {\n",
                                    "    public:\n",
                                    "      Functions();\n",
                                    "     ~Functions();\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = functionHeaderBodies2(txt, a_functions, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("void Assert(bool cond,string msg);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    private:\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = functionHeaderBodies3(txt, a_functions, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("   };"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end simulationFunctionsHeaderFile;

protected function fun_33
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end matchcontinue;
end fun_33;

protected function fun_34
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER"));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_34;

protected function fun_35
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_33(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_34(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_35;

protected function lm_36
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_36(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_36(txt, rest);
      then txt;
  end matchcontinue;
end lm_36;

protected function fun_37
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_cflags;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(cflags = i_s_cflags)) )
      equation
        txt = Tpl.writeStr(txt, i_s_cflags);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_37;

protected function fun_38
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end matchcontinue;
end fun_38;

public function simulationMakefile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_algebraicEquations;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      Absyn.Path i_modelInfo_name;
      String i_makefileParams_cflags;
      list<String> i_makefileParams_includes;
      String i_makefileParams_omhome;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      Option<SimCode.SimulationSettings> i_sopt;
      Boolean ret_1;
      Tpl.Text l_extraCflags;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), makefileParams = SimCode.MAKEFILE_PARAMS(ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, omhome = i_makefileParams_omhome, includes = i_makefileParams_includes, cflags = i_makefileParams_cflags), simulationSettingsOpt = i_sopt, odeEquations = i_odeEquations, algebraicEquations = i_algebraicEquations, whenClauses = i_whenClauses, parameterEquations = i_parameterEquations)) )
      equation
        l_extraCflags = fun_35(Tpl.emptyTxt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "include ModelicaConfic.inc\n",
                                    "# Simulations use -O3 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=-O3\n",
                                    "CC="
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS_BASED_ON_INIT_FILE="));
        txt = Tpl.writeText(txt, l_extraCflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS=$(CFLAGS_BASED_ON_INIT_FILE) -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp\" -I\"$(BOOST_INCLUDE)\" "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_36(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_37(txt, i_sopt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS=-L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/bin\" -L$(BOOST_LIBS)\n",
                                    "\n",
                                    "MAINFILE="
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        ret_1 = Config.acceptMetaModelicaGrammar();
        txt = fun_38(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".cpp\n",
                                    "FUNCTIONFILE=Functions.cpp\n",
                                    "\n",
                                    ".PHONY: "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.softNewLine(txt);
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(": $(MAINFILE)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX) -shared -I. -o $(MODELICA_SYSTEM_LIB) $(MAINFILE) $(FUNCTIONFILE)  "));
        txt = algloopcppfilenames(txt, i_odeEquations, i_algebraicEquations, i_whenClauses, i_parameterEquations, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "   -L\"..//Test//Base/\"    $(CFLAGS)  $(LDFLAGS) -lSystem -lMath -lModelicaExternalC -Wl,-Bstatic  -Wl,-Bdynamic\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end simulationMakefile;

protected function fun_40
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.SimEqSystem> in_a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_allEquations)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquations;

    case ( txt,
           false,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimResidues=0;"));
      then txt;

    case ( txt,
           _,
           a_allEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimResidues="));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_40;

public function simulationCppFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<String> i_modelInfo_labels;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<DAE.ComponentRef> i_discreteModelVars;
      list<SimCode.SampleCondition> i_sampleConditions;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_algebraicEquations;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      SimCode.ModelInfo i_modelInfo;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name, labels = i_modelInfo_labels)), allEquations = i_allEquations, odeEquations = i_odeEquations, algebraicEquations = i_algebraicEquations, whenClauses = i_whenClauses, parameterEquations = i_parameterEquations, sampleConditions = i_sampleConditions, discreteModelVars = i_discreteModelVars, zeroCrossings = i_zeroCrossings)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" #include \"Modelica.h\"\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".h\"\n",
                                    "\n",
                                    "\n",
                                    "using boost::extensions::factory;\n",
                                    "BOOST_EXTENSION_TYPE_MAP_FUNCTION {\n",
                                    " types.get<std::map<std::string, factory<IDAESystem,IGlobalSettings&> > >()\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[\"ModelicaSystem\"].set<"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">();\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(IGlobalSettings& globalSettings)\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":SystemDefaultImplementation()\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = simulationInitFile(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "//Number of equations\n"
                                }, true));
        txt = dimension1(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimZeroFunc= "));
        txt = zerocrosslength(txt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "//Number of residues\n"
                                }, true));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_40(txt, ret_0, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//DAE\'s are not supported yet, Index reduction is enabled\n",
                                    "_dimAE = 0; // algebraic equations\n",
                                    "//Initialize the state vector\n",
                                    "SystemDefaultImplementation::init();\n",
                                    "//Instantiate auxiliary object for event handling functionality\n",
                                    "_event_handling.resetHelpVar =  boost::bind(&"
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::resetHelpVar, this, _1);\n",
                                    "_historyImpl = new HistoryImplType(globalSettings);\n"
                                }, true));
        txt = arrayReindex(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//Initialize array elements\n"));
        txt = arrayInit(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//Load Algloopsover library\n",
                                    "type_map types;\n",
                                    "\n",
                                    "std::string algsover_name(SYSTEM_LIB);\n",
                                    "if(!load_single_library(types, algsover_name))\n",
                                    "    throw std::invalid_argument(\"Algsover library could not be loaded\");\n",
                                    "std::map<std::string, factory<IAlgLoopSolverFactory> >::iterator iter;\n",
                                    "std::map<std::string, factory<IAlgLoopSolverFactory> >& factories(types.get());\n",
                                    "iter = factories.find(\"AlgLoopSolverFactory\");\n",
                                    "if (iter ==factories.end())\n",
                                    "{\n",
                                    "    throw std::invalid_argument(\"No AlgLoopSolverFactory  found\");\n",
                                    "}\n"
                                }, true));
        txt = generateAlgloopsolvers(txt, i_odeEquations, i_algebraicEquations, i_whenClauses, i_parameterEquations, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::~"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "()\n",
                                    "{\n",
                                    "delete _historyImpl;\n",
                                    "}\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = init(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::resetTimeEvents()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = resetTimeEvents(txt, i_sampleConditions, i_whenClauses, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Update(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = writeoutput(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = DefaultImplementationCode(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = checkForDiscreteEvents(txt, i_discreteModelVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = giveZeroFunc1(txt, i_zeroCrossings, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = giveConditions(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = setConditions(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = saveConditions(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = isODE(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = DimZeroFunc(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = DimInitEquations(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = DimUnfixedStates(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = DimUnfixedParameters(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = DimIntialResiduals(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = GetIntialStatus(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = SetIntialStatus(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = checkConditions(txt, i_zeroCrossings, i_whenClauses, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = handleSystemEvents(txt, i_zeroCrossings, i_whenClauses, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = saveall(txt, i_modelInfo, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = resethelpvar(txt, i_whenClauses, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = LabeledDAE(txt, i_modelInfo_labels, i_simCode);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end simulationCppFile;

protected function fun_42
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"Math/Implementation/ArrayOperations.h\""));
      then txt;
  end matchcontinue;
end fun_42;

protected function fun_43
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode a_simCode;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq,
           a_simCode )
      equation
        txt = algloopResiduals(txt, a_simCode, a_eq);
      then txt;
  end matchcontinue;
end fun_43;

protected function fun_44
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"Math/Implementation/ArrayOperations.h\""));
      then txt;
  end matchcontinue;
end fun_44;

protected function fun_45
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode a_simCode;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq,
           a_simCode )
      equation
        txt = algloopResiduals(txt, a_simCode, a_eq);
      then txt;
  end matchcontinue;
end fun_45;

protected function fun_46
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_iniAlgloopParamas;
  input Tpl.Text in_a_constructorParams;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_simCode, in_a_varDecls, in_a_iniAlgloopParamas, in_a_constructorParams, in_a_modelname)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_iniAlgloopParamas;
      Tpl.Text a_constructorParams;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_simCode,
           a_varDecls,
           a_iniAlgloopParamas,
           a_constructorParams,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" #include \"Modelica.h\"\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".h\"\n"));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_42(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::"));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(60));
        txt = Tpl.writeText(txt, a_constructorParams);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",double* z,double* zDot,EventHandling& event_handling\n",
                                    " )\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":AlgLoopDefaultImplementation()\n",
                                    ",_residuals(NULL)\n",
                                    ",_z(z)\n",
                                    ",_zDot(zDot)\n",
                                    ",_event_handling(event_handling)\n"
                                }, true));
        txt = alocateLinearSystem(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_iniAlgloopParamas);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        (txt, a_varDecls) = initAlgloopDimension(txt, i_eq, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::~"));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "()\n",
                                    " {\n",
                                    "            if(_residuals) delete [] _residuals;\n",
                                    " }\n"
                                }, true));
        txt = algloopRHSCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        ret_1 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_43(txt, ret_1, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initAlgloop(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = upateAlgloopNonLinear(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = upateAlgloopLinear(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = AlgloopDefaultImplementationCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = getAMatrixCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = isLinearCode(txt, a_simCode, i_eq);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(index = i_index)),
           a_simCode,
           a_varDecls,
           a_iniAlgloopParamas,
           a_constructorParams,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" #include \"Modelica.h\"\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".h\"\n"));
        ret_2 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_44(txt, ret_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::"));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(60));
        txt = Tpl.writeText(txt, a_constructorParams);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",double* z,double* zDot,EventHandling& event_handling\n",
                                    " )\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":AlgLoopDefaultImplementation()\n",
                                    ",_residuals(NULL)\n",
                                    ",_z(z)\n",
                                    ",_zDot(zDot)\n",
                                    ",_event_handling(event_handling)\n"
                                }, true));
        txt = alocateLinearSystem(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_iniAlgloopParamas);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        (txt, a_varDecls) = initAlgloopDimension(txt, i_eq, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::~"));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "()\n",
                                    " {\n",
                                    "            if(_residuals) delete [] _residuals;\n",
                                    " }\n"
                                }, true));
        txt = algloopRHSCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        ret_3 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_45(txt, ret_3, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initAlgloop(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = upateAlgloopNonLinear(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = upateAlgloopLinear(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = AlgloopDefaultImplementationCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = getAMatrixCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = isLinearCode(txt, a_simCode, i_eq);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _,
           _,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_46;

public function algloopCppFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_iniAlgloopParamas;
      Tpl.Text l_constructorParams;
      Tpl.Text l_arrayInit;
      Tpl.Text l_varDecls;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_varDecls = Tpl.emptyTxt;
        l_arrayInit = Tpl.emptyTxt;
        l_constructorParams = ConstructorParamAlgloop(Tpl.emptyTxt, i_modelInfo);
        (l_iniAlgloopParamas, l_arrayInit) = InitAlgloopParams(Tpl.emptyTxt, i_modelInfo, l_arrayInit);
        (txt, l_varDecls) = fun_46(txt, a_eq, i_simCode, l_varDecls, l_iniAlgloopParamas, l_constructorParams, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end algloopCppFile;

protected function lm_48
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_eq2 as SimCode.SES_ALGORITHM(statements = _)) :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq2, SimCode.contextOther, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_48(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_48(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_48;

protected function lm_49
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_eq2 as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq2, SimCode.contextOther, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_49(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_49(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_eq2_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_eq2_exp) :: rest,
           a_simCode,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq2_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_residuals["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_50(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_50(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_50;

protected function fun_51
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input Tpl.Text in_a_modelname;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eqn, in_a_modelname, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      SimCode.SimCode a_simCode;
      Integer i_index;
      list<SimCode.SimEqSystem> i_eq_eqs;
      Tpl.Text l_body;
      Tpl.Text l_prebody;
      Tpl.Text l_algs;
      Tpl.Text l_varDecls;

    case ( txt,
           SimCode.SES_NONLINEAR(eqs = i_eq_eqs, index = i_index),
           a_modelname,
           a_simCode )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_algs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_algs, l_varDecls) = lm_48(l_algs, i_eq_eqs, a_simCode, l_varDecls);
        l_algs = Tpl.popIter(l_algs);
        l_prebody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_prebody, l_varDecls) = lm_49(l_prebody, i_eq_eqs, a_simCode, l_varDecls);
        l_prebody = Tpl.popIter(l_prebody);
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, l_varDecls) = lm_50(l_body, i_eq_eqs, a_simCode, l_varDecls);
        l_body = Tpl.popIter(l_body);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::update(const IContinous::UPDATE command)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "     if(command & IContinous::CONTINOUS)\n",
                                    "    {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(9));
        txt = Tpl.writeText(txt, l_algs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_prebody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    }\n",
                                    "\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_51;

public function upateAlgloopNonLinear
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_eqn)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eqn;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eqn )
      equation
        System.tmpTickReset(0);
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_51(txt, a_eqn, l_modelname, i_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end upateAlgloopNonLinear;

protected function lm_53
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer i_col;
      Integer i_row;
      DAE.Exp i_eq_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_row, i_col, SimCode.SES_RESIDUAL(exp = i_eq_exp)) :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq_exp, SimCode.contextSimulationNonDiscrete, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_A["));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]["));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_53(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_53(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_53;

protected function lm_54
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer x_i0;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextSimulationNonDiscrete, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_b["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_54(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_54(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_54;

protected function fun_55
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input Tpl.Text in_a_modelname;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eqn, in_a_modelname, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      SimCode.SimCode a_simCode;
      Integer i_index;
      list<DAE.Exp> i_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<SimCode.SimVar> i_vars;
      Tpl.Text l_bvector;
      Tpl.Text l_Amatrix;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;
      Tpl.Text l_bname;
      Tpl.Text l_aname;
      Integer ret_3;
      Tpl.Text l_size;
      Integer ret_1;
      Tpl.Text l_uid;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, simJac = i_simJac, beqs = i_beqs, index = i_index),
           a_modelname,
           a_simCode )
      equation
        ret_1 = System.tmpTick();
        l_uid = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        ret_3 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        l_aname = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("A"));
        l_aname = Tpl.writeText(l_aname, l_uid);
        l_bname = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("b"));
        l_bname = Tpl.writeText(l_bname, l_uid);
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        l_Amatrix = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_Amatrix, l_varDecls, l_preExp) = lm_53(l_Amatrix, i_simJac, a_simCode, l_varDecls, l_preExp);
        l_Amatrix = Tpl.popIter(l_Amatrix);
        l_bvector = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bvector, l_varDecls, l_preExp) = lm_54(l_bvector, i_beqs, a_simCode, l_varDecls, l_preExp);
        l_bvector = Tpl.popIter(l_bvector);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("::update(const IContinous::UPDATE command)\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_Amatrix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_bvector);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_55;

public function upateAlgloopLinear
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_eqn)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eqn;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eqn )
      equation
        System.tmpTickReset(0);
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_55(txt, a_eqn, l_modelname, i_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end upateAlgloopLinear;

protected function fun_57
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           SimCode.SIMVAR(name = (i_cr as DAE.CREF_QUAL(ident = "$DER"))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inline_integrate("));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_57;

protected function lm_58
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_57(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_58(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_58(txt, rest);
      then txt;
  end matchcontinue;
end lm_58;

protected function fun_59
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_simvars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simvars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_simvars;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_simvars )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_58(txt, i_simvars);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_59;

public function inlineVars
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input list<SimCode.SimVar> in_a_simvars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_simvars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> a_simvars;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_simvars )
      equation
        txt = fun_59(txt, a_simvars);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end inlineVars;

protected function lm_61
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_simCode )
      equation
        txt = functionBody(txt, i_fn, false, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_61(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_61(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_61;

public function functionBodies
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_61(out_txt, a_functions, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end functionBodies;

public function functionBody
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_inFunc, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_inFunc,
           a_simCode )
      equation
        txt = functionBodyRegularFunction(txt, i_fn, a_inFunc, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_inFunc,
           a_simCode )
      equation
        txt = functionBodyExternalFunction(txt, i_fn, a_inFunc, a_simCode);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = _),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionBody;

protected function lm_64
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = extFunDef(txt, i_fn);
        txt = Tpl.nextIter(txt);
        txt = lm_64(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_64(txt, rest);
      then txt;
  end matchcontinue;
end lm_64;

public function externfunctionHeaderDefinition
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_64(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end externfunctionHeaderDefinition;

protected function lm_66
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_simCode )
      equation
        txt = functionHeaderBody1(txt, i_fn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_66(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_66(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_66;

public function functionHeaderBodies1
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_66(out_txt, a_functions, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end functionHeaderBodies1;

public function functionHeaderBody1
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderExternFunction(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = _),
           _ )
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionHeaderBody1;

protected function lm_69
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_simCode )
      equation
        txt = functionHeaderBody2(txt, i_fn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_69(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_69(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_69;

public function functionHeaderBodies2
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_69(out_txt, a_functions, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end functionHeaderBodies2;

public function functionHeaderBody2
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = _),
           _ )
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionHeaderBody2;

protected function lm_72
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_simCode )
      equation
        txt = functionHeaderBody3(txt, i_fn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_72(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_72(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_72;

public function functionHeaderBodies3
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_72(out_txt, a_functions, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end functionHeaderBodies3;

public function functionHeaderBody3
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = _),
           _ )
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionHeaderBody3;

public function extFunDef
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      String i_extName;
      SimCode.SimExtArg i_extReturn;
      String i_language;
      list<SimCode.SimExtArg> i_extArgs;
      Tpl.Text l_fargsStr;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, language = i_language, extReturn = i_extReturn, extName = i_extName) )
      equation
        l_fargsStr = extFunDefArgs(Tpl.emptyTxt, i_extArgs, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extern "));
        txt = extReturnType(txt, i_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_extName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunDef;

protected function fun_76
  input Tpl.Text in_txt;
  input String in_a_language;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_language, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 479, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_76;

public function extFunctionName
  input Tpl.Text txt;
  input String a_name;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_76(txt, a_language, a_name);
end extFunctionName;

protected function lm_78
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunDefArg(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_78(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_78(txt, rest);
      then txt;
  end matchcontinue;
end lm_78;

protected function fun_79
  input Tpl.Text in_txt;
  input String in_a_language;
  input list<SimCode.SimExtArg> in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_language, in_a_args)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> a_args;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_args )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_78(txt, a_args);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 486, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_79;

public function extFunDefArgs
  input Tpl.Text txt;
  input list<SimCode.SimExtArg> a_args;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_79(txt, a_language, a_args);
end extFunDefArgs;

public function extFunDefArg
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Type i_type__;
      Boolean i_ia;
      Boolean i_ii;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = i_ii, isArray = i_ia, type_ = i_t) )
      equation
        l_name = contextCref2(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        l_typeStr = extType2(Tpl.emptyTxt, i_t, i_ii, i_ia);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*"));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__) )
      equation
        l_typeStr = extType2(Tpl.emptyTxt, i_type__, true, false);
        txt = Tpl.writeText(txt, l_typeStr);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_t"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunDefArg;

protected function fun_82
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isInput;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_isInput)
    local
      Tpl.Text txt;
      Boolean a_isInput;
      DAE.Type i_type;
      Absyn.Path i_rname;
      DAE.Type i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char*"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty),
           a_isInput )
      equation
        txt = extType2(txt, i_ty, a_isInput, true);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void *"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = underscorePath(txt, i_rname);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           i_type,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external C type "));
        ret_0 = ExpressionDump.typeString(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 528, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_82;

protected function fun_83
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "const char*" )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const "));
      then txt;
  end matchcontinue;
end fun_83;

protected function fun_84
  input Tpl.Text in_txt;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;
      String str_0;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        str_0 = Tpl.textString(a_s);
        txt = fun_83(txt, str_0);
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end matchcontinue;
end fun_84;

protected function fun_85
  input Tpl.Text in_txt;
  input Boolean in_a_isInput;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isInput, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Tpl.Text a_s;

    case ( txt,
           false,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_s )
      equation
        txt = fun_84(txt, a_isArray, a_s);
      then txt;
  end matchcontinue;
end fun_85;

protected function fun_86
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isArray;
  input Boolean in_a_isInput;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_isArray, in_a_isInput, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Boolean a_isInput;
      Tpl.Text a_s;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           _,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_isInput,
           a_s )
      equation
        txt = fun_85(txt, a_isInput, a_isArray, a_s);
      then txt;
  end matchcontinue;
end fun_86;

public function extType2
  input Tpl.Text txt;
  input DAE.Type a_type;
  input Boolean a_isInput;
  input Boolean a_isArray;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_82(Tpl.emptyTxt, a_type, a_isInput);
  out_txt := fun_86(txt, a_type, a_isArray, a_isInput, l_s);
end extType2;

public function extReturnType
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.Type i_type__;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           SimCode.SIMEXTARG(type_ = i_type__) )
      equation
        txt = extType2(txt, i_type__, true, false);
      then txt;

    case ( txt,
           SimCode.SIMNOEXTARG() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp) )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Expression types are unsupported as return arguments "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 538, 36), Tpl.textString(txt_0));
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 539, 14), "Unsupported return argument");
      then txt;
  end matchcontinue;
end extReturnType;

protected function lm_89
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funReturnDefinition1(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_89(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_89(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_89;

protected function lm_90
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funReturnDefinition2(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_90(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_90(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_90;

public function functionHeaderRegularFunction1
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(name = i_name, outVars = i_outVars),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef tuple< "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_89(txt, i_outVars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >  "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "RetType;\n",
                                    "typedef tuple< "
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_90(txt, i_outVars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RefRetType;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionHeaderRegularFunction1;

protected function lm_92
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funReturnDefinition1(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_92(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_92(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_92;

public function functionHeaderExternFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name, outVars = i_outVars),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef tuple< "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_92(txt, i_outVars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >  "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionHeaderExternFunction;

protected function lm_94
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_94(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_94(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_94;

protected function lm_95
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_95(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_95(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_95;

public function functionHeaderRegularFunction2
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_funArgs;
      list<SimCode.Variable> i_functionArguments;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(name = i_name, functionArguments = i_functionArguments),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_94(txt, i_functionArguments, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name, funArgs = i_funArgs),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_95(txt, i_funArgs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionHeaderRegularFunction2;

protected function fun_97
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(name = i_name) )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name) )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_97;

public function functionHeaderRegularFunction3
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_97(txt, a_fn);
end functionHeaderRegularFunction3;

protected function fun_99
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType"));
      then txt;
  end matchcontinue;
end fun_99;

protected function lm_100
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varInits, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           a_varInits,
           a_varDecls )
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_simCode,
           a_varInits,
           a_varDecls )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_varInits) = varInit(txt, i_var, "", x_i1, a_varDecls, a_varInits, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varInits, a_varDecls) = lm_100(txt, rest, a_simCode, a_varInits, a_varDecls);
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varInits,
           a_varDecls )
      equation
        (txt, a_varInits, a_varDecls) = lm_100(txt, rest, a_simCode, a_varInits, a_varDecls);
      then (txt, a_varInits, a_varDecls);
  end matchcontinue;
end lm_100;

protected function lm_101
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = funStatement(txt, i_stmt, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_101(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_101(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_101;

protected function lm_102
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      SimCode.Function a_fn;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign) = varOutput(txt, a_fn, i_var, x_i1, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_102(txt, rest, a_simCode, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_fn);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_102(txt, rest, a_simCode, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_fn);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end matchcontinue;
end lm_102;

protected function lm_103
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_103(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_103(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_103;

protected function fun_104
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, a_fname);
      then txt;
  end matchcontinue;
end fun_104;

protected function lm_105
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_105(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_105(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_105;

protected function fun_106
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" out;"));
      then txt;
  end matchcontinue;
end fun_106;

protected function fun_107
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input Tpl.Text in_a_retType;
  input list<SimCode.Variable> in_a_outVars;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Variable> in_a_functionArguments;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_inFunc, in_a_retType, in_a_outVars, in_a_simCode, in_a_functionArguments, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      list<SimCode.Variable> a_outVars;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> a_functionArguments;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_retType,
           a_outVars,
           a_simCode,
           a_functionArguments,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int in_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(type_description * inArgs, type_description * outVar)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_105(txt, a_functionArguments, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_106(txt, a_outVars, a_retType);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//MMC_TRY_TOP()\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end matchcontinue;
end fun_107;

public function functionBodyRegularFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_inFunc, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_functionArguments;
      SimCode.Function i_fn;
      list<SimCode.Statement> i_body;
      list<SimCode.Variable> i_variableDeclarations;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_0___1;
      Tpl.Text l_outVarAssign;
      Tpl.Text l_outVarCopy;
      Tpl.Text l_outVarInits;
      Tpl.Text l_bodyPart;
      Tpl.Text l_0__;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, outVars = i_outVars, variableDeclarations = i_variableDeclarations, body = i_body, functionArguments = i_functionArguments)),
           a_inFunc,
           a_simCode )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_99(Tpl.emptyTxt, i_outVars, l_fname);
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_varInits, l_varDecls) = lm_100(l_0__, i_variableDeclarations, a_simCode, l_varInits, l_varDecls);
        l_0__ = Tpl.popIter(l_0__);
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bodyPart, l_varDecls) = lm_101(l_bodyPart, i_body, a_simCode, l_varDecls);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        l_outVarInits = Tpl.emptyTxt;
        l_outVarCopy = Tpl.emptyTxt;
        l_outVarAssign = Tpl.emptyTxt;
        l_0___1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0___1, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls) = lm_102(l_0___1, i_outVars, a_simCode, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls, i_fn);
        l_0___1 = Tpl.popIter(l_0___1);
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" Functions::"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_103(txt, i_functionArguments, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_outVarInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_bodyPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_outVarAssign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = fun_104(txt, i_outVars, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = fun_107(txt, a_inFunc, l_retType, i_outVars, a_simCode, i_functionArguments, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionBodyRegularFunction;

protected function fun_109
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType"));
      then txt;
  end matchcontinue;
end fun_109;

protected function fun_110
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, a_fname);
      then txt;
  end matchcontinue;
end fun_110;

protected function lm_111
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarInits, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_outVarInits, in_a_varDecls, in_a_retVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_retVar;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_simCode,
           a_outVarInits,
           a_varDecls,
           a_retVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits) = varInit(txt, i_var, Tpl.textString(a_retVar), x_i1, a_varDecls, a_outVarInits, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarInits, a_varDecls) = lm_111(txt, rest, a_simCode, a_outVarInits, a_varDecls, a_retVar);
      then (txt, a_outVarInits, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_outVarInits,
           a_varDecls,
           a_retVar )
      equation
        (txt, a_outVarInits, a_varDecls) = lm_111(txt, rest, a_simCode, a_outVarInits, a_varDecls, a_retVar);
      then (txt, a_outVarInits, a_varDecls);
  end matchcontinue;
end lm_111;

protected function lm_112
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_112(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_112(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_112;

protected function fun_113
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ptrT_"));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ptr_"));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=NULL;"));
      then txt;
  end matchcontinue;
end fun_113;

protected function lm_114
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) :: rest,
           a_simCode )
      equation
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_114(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_114(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_114;

protected function lm_115
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_arg;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_arg as SimCode.VARIABLE(name = _)) :: rest,
           a_simCode )
      equation
        txt = readInVar(txt, i_arg, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_115(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_115(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_115;

protected function lm_116
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest,
           a_simCode )
      equation
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_116(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_116(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_116;

protected function lm_117
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)) :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = writeOutVar(txt, i_var, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_117(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_117(txt, rest);
      then txt;
  end matchcontinue;
end lm_117;

protected function fun_118
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Variable> in_a_funArgs;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_inFunc, in_a_outVars, in_a_retType, in_a_simCode, in_a_funArgs, in_a_fname)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;
      Tpl.Text a_retType;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> a_funArgs;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_outVars,
           a_retType,
           a_simCode,
           a_funArgs,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int in_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(type_description * inArgs, type_description * outVar)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_114(txt, a_funArgs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" out;\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_115(txt, a_funArgs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MMC_TRY_TOP()\n",
                                    "out = _"
                                }, false));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_116(txt, a_funArgs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "MMC_CATCH_TOP(return 1)\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_117(txt, a_outVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end matchcontinue;
end fun_118;

public function functionBodyExternalFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_inFunc, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.SimCode a_simCode;
      String i_language;
      String i_extName;
      Boolean i_dynamicLoad;
      list<SimCode.Variable> i_funArgs;
      SimCode.Function i_efn;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_fnBody;
      Tpl.Text l_0__;
      Tpl.Text l_callPart;
      Tpl.Text l_outVarInits;
      Tpl.Text l_retVar;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           (i_efn as SimCode.EXTERNAL_FUNCTION(name = i_name, outVars = i_outVars, funArgs = i_funArgs, dynamicLoad = i_dynamicLoad, extName = i_extName, language = i_language)),
           a_inFunc,
           a_simCode )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_109(Tpl.emptyTxt, i_outVars, l_fname);
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_retVar = fun_110(Tpl.emptyTxt, i_outVars, l_fname);
        l_outVarInits = Tpl.emptyTxt;
        (l_callPart, l_preExp, l_varDecls) = extFunCall(Tpl.emptyTxt, i_efn, l_preExp, l_varDecls, a_simCode);
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_outVarInits, l_varDecls) = lm_111(l_0__, i_outVars, a_simCode, l_outVarInits, l_varDecls, l_retVar);
        l_0__ = Tpl.popIter(l_0__);
        l_fnBody = Tpl.writeText(Tpl.emptyTxt, l_retType);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING(" Functions::"));
        l_fnBody = Tpl.writeText(l_fnBody, l_fname);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("("));
        l_fnBody = Tpl.pushIter(l_fnBody, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_fnBody = lm_112(l_fnBody, i_funArgs, a_simCode);
        l_fnBody = Tpl.popIter(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING_LIST({
                                              ")\n",
                                              "{\n",
                                              "  /* functionBodyExternalFunction: varDecls */\n"
                                          }, true));
        l_fnBody = Tpl.pushBlock(l_fnBody, Tpl.BT_INDENT(2));
        l_fnBody = Tpl.writeText(l_fnBody, l_varDecls);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: preExp */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_preExp);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: outputAlloc */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_outVarInits);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: callPart */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_callPart);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE(" /* functionBodyExternalFunction: return */\n"));
        l_fnBody = Tpl.pushBlock(l_fnBody, Tpl.BT_INDENT(1));
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("return "));
        l_fnBody = Tpl.writeText(l_fnBody, l_retVar);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE(";\n"));
        l_fnBody = Tpl.popBlock(l_fnBody);
        l_fnBody = Tpl.popBlock(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("}"));
        txt = fun_113(txt, i_dynamicLoad, i_language, i_extName);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_fnBody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_118(txt, a_inFunc, i_outVars, l_retType, a_simCode, i_funArgs, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionBodyExternalFunction;

public function writeOutVar
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;
      SimCode.Variable i_var;
      DAE.Type i_ty;

    case ( txt,
           SimCode.VARIABLE(ty = (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_modelica_record(outVar, "));
        txt = writeOutVarRecordMembers(txt, i_ty, a_index, "");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_"));
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(outVar, &out.targTest8"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end writeOutVar;

protected function fun_121
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Integer in_a_index;
  input DAE.Ident in_a_subvar_name;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty, in_a_index, in_a_subvar_name, in_a_prefix)
    local
      Tpl.Text txt;
      Integer a_index;
      DAE.Ident a_subvar_name;
      String a_prefix;
      DAE.Type i_ty;
      Tpl.Text l_newPrefix;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = _)),
           a_index,
           a_subvar_name,
           a_prefix )
      equation
        l_newPrefix = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_newPrefix = Tpl.writeTok(l_newPrefix, Tpl.ST_STRING("."));
        l_newPrefix = Tpl.writeStr(l_newPrefix, a_subvar_name);
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = writeOutVarRecordMembers(txt, i_ty, a_index, Tpl.textString(l_newPrefix));
      then txt;

    case ( txt,
           i_ty,
           a_index,
           a_subvar_name,
           a_prefix )
      equation
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &(out.targTest7"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeStr(txt, a_prefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_subvar_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_121;

protected function lm_122
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Integer in_a_index;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_index, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Integer a_index;
      String a_prefix;
      DAE.Ident i_subvar_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           DAE.TYPES_VAR(ty = i_ty, name = i_subvar_name) :: rest,
           a_index,
           a_prefix )
      equation
        txt = fun_121(txt, i_ty, a_index, i_subvar_name, a_prefix);
        txt = Tpl.nextIter(txt);
        txt = lm_122(txt, rest, a_index, a_prefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_index,
           a_prefix )
      equation
        txt = lm_122(txt, rest, a_index, a_prefix);
      then txt;
  end matchcontinue;
end lm_122;

protected function fun_123
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_args)
    local
      Tpl.Text txt;
      Tpl.Text i_args;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_args )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_args);
      then txt;
  end matchcontinue;
end fun_123;

public function writeOutVarRecordMembers
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Integer in_a_index;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_index, in_a_prefix)
    local
      Tpl.Text txt;
      Integer a_index;
      String a_prefix;
      list<DAE.Var> i_vl;
      ClassInf.State i_n;
      Tpl.Text l_args;
      Absyn.Path ret_1;
      Tpl.Text l_basename;

    case ( txt,
           DAE.T_COMPLEX(varLst = i_vl, complexClassType = i_n),
           a_index,
           a_prefix )
      equation
        ret_1 = ClassInf.getStateName(i_n);
        l_basename = underscorePath(Tpl.emptyTxt, ret_1);
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_args = lm_122(l_args, i_vl, a_index, a_prefix);
        l_args = Tpl.popIter(l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = Tpl.writeText(txt, l_basename);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc"));
        txt = fun_123(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", TYPE_DESC_NONE"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end writeOutVarRecordMembers;

public function expTypeRW
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_INT"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_REAL"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_STRING"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_BOOL"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_INT"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ARRAY"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_RECORD"));
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_MMC"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_MMC"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end expTypeRW;

protected function fun_126
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(char**)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_126;

public function readInVar
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_name;
      DAE.ComponentRef i_cr;
      DAE.Type i_ty;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.VARIABLE(name = i_cr, ty = (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_modelica_record(&inArgs, "));
        txt_0 = contextCref(Tpl.emptyTxt, i_cr, SimCode.contextFunction, a_simCode);
        txt = readInVarRecordMembers(txt, i_ty, Tpl.textString(txt_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name, ty = (i_ty as DAE.T_STRING(varLst = _))),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_"));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&inArgs, "));
        ret_1 = Config.acceptMetaModelicaGrammar();
        txt = fun_126(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" &"));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_"));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&inArgs, &"));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end readInVar;

protected function fun_128
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.Ident in_a_subvar_name;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty, in_a_subvar_name, in_a_prefix)
    local
      Tpl.Text txt;
      DAE.Ident a_subvar_name;
      String a_prefix;
      DAE.Type i_ty;
      Tpl.Text l_newPrefix;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = _)),
           a_subvar_name,
           a_prefix )
      equation
        l_newPrefix = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_newPrefix = Tpl.writeTok(l_newPrefix, Tpl.ST_STRING("."));
        l_newPrefix = Tpl.writeStr(l_newPrefix, a_subvar_name);
        txt = readInVarRecordMembers(txt, i_ty, Tpl.textString(l_newPrefix));
      then txt;

    case ( txt,
           _,
           a_subvar_name,
           a_prefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&("));
        txt = Tpl.writeStr(txt, a_prefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_subvar_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_128;

protected function lm_129
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      String a_prefix;
      DAE.Ident i_subvar_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           DAE.TYPES_VAR(ty = i_ty, name = i_subvar_name) :: rest,
           a_prefix )
      equation
        txt = fun_128(txt, i_ty, i_subvar_name, a_prefix);
        txt = Tpl.nextIter(txt);
        txt = lm_129(txt, rest, a_prefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_prefix )
      equation
        txt = lm_129(txt, rest, a_prefix);
      then txt;
  end matchcontinue;
end lm_129;

public function readInVarRecordMembers
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_prefix)
    local
      Tpl.Text txt;
      String a_prefix;
      list<DAE.Var> i_vl;

    case ( txt,
           DAE.T_COMPLEX(varLst = i_vl),
           a_prefix )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_129(txt, i_vl, a_prefix);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end readInVarRecordMembers;

public function outDecl
  input Tpl.Text txt;
  input String a_ty;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_newVar;
algorithm
  l_newVar := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("out"));
  out_a_varDecls := Tpl.writeStr(a_varDecls, a_ty);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(" "));
  out_a_varDecls := Tpl.writeText(out_a_varDecls, l_newVar);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(";"));
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_newVar);
end outDecl;

protected function fun_132
  input Tpl.Text in_txt;
  input String in_a_language;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Function in_a_fun;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_language, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_fun)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Function a_fun;

    case ( txt,
           "C",
           a_simCode,
           a_varDecls,
           a_preExp,
           a_fun )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallC(txt, a_fun, a_preExp, a_varDecls, a_simCode);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_132;

public function extFunCall
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_fun, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fun;
      String i_language;

    case ( txt,
           (i_fun as SimCode.EXTERNAL_FUNCTION(language = i_language)),
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls, a_preExp) = fun_132(txt, i_language, a_simCode, a_varDecls, a_preExp, i_fun);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extFunCall;

protected function lm_134
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_arg :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardecl(txt, i_arg, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_134(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_134(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_134;

protected function fun_135
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName, in_a_fname)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("==NULL) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MODELICA_TERMINATE(\"dynamic external function "));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" not set!\")\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} else"));
      then txt;
  end matchcontinue;
end fun_135;

protected function lm_136
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extArg(txt, i_arg, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_136(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_136(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_136;

protected function fun_137
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c) )
      equation
        txt = extVarName2(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_137;

protected function fun_138
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_extReturn, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)),
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardecl(txt, i_extReturn, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_138;

protected function lm_139
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_fname)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_fname;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_arg :: rest,
           a_fname )
      equation
        txt = extFunCallVarcopy(txt, i_arg, Tpl.textString(a_fname));
        txt = Tpl.nextIter(txt);
        txt = lm_139(txt, rest, a_fname);
      then txt;

    case ( txt,
           _ :: rest,
           a_fname )
      equation
        txt = lm_139(txt, rest, a_fname);
      then txt;
  end matchcontinue;
end lm_139;

protected function fun_140
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extReturn, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)),
           a_fname )
      equation
        txt = extFunCallVarcopy(txt, i_extReturn, Tpl.textString(a_fname));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_140;

public function extFunCallC
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_fun, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimExtArg i_extReturn;
      String i_language;
      String i_extName;
      Boolean i_dynamicLoad;
      Absyn.Path i_name;
      list<SimCode.SimExtArg> i_extArgs;
      Tpl.Text l_returnAssign;
      Tpl.Text l_args;
      Tpl.Text l_dynamicCheck;
      Tpl.Text l_fname;
      list<SimCode.SimExtArg> ret_1;
      Tpl.Text l_varDecs;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, name = i_name, dynamicLoad = i_dynamicLoad, extName = i_extName, language = i_language, extReturn = i_extReturn),
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        ret_1 = List.union(i_extArgs, i_extArgs);
        l_varDecs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_varDecs, a_varDecls) = lm_134(l_varDecs, ret_1, a_varDecls);
        l_varDecs = Tpl.popIter(l_varDecs);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_dynamicCheck = fun_135(Tpl.emptyTxt, i_dynamicLoad, i_language, i_extName, l_fname);
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_args, a_varDecls, a_preExp) = lm_136(l_args, i_extArgs, a_simCode, a_varDecls, a_preExp);
        l_args = Tpl.popIter(l_args);
        l_returnAssign = fun_137(Tpl.emptyTxt, i_extReturn);
        txt = Tpl.writeText(txt, l_varDecs);
        txt = Tpl.softNewLine(txt);
        (txt, a_varDecls) = fun_138(txt, i_extReturn, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_dynamicCheck);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_returnAssign);
        txt = Tpl.writeStr(txt, i_extName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_139(txt, i_extArgs, l_fname);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_140(txt, i_extReturn, l_fname);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extFunCallC;

protected function fun_142
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input String in_a_fnName;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_oi, in_a_fnName, in_a_c)
    local
      Tpl.Text txt;
      String a_fnName;
      DAE.ComponentRef a_c;
      Integer i_oi;
      Tpl.Text l_assginEnd;
      Integer ret_2;
      Tpl.Text l_assginBegin;
      Tpl.Text l_cr;

    case ( txt,
           0,
           _,
           _ )
      then txt;

    case ( txt,
           i_oi,
           a_fnName,
           a_c )
      equation
        l_cr = extVarName2(Tpl.emptyTxt, a_c);
        l_assginBegin = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("get<"));
        ret_2 = intAdd(-1, i_oi);
        l_assginBegin = Tpl.writeStr(l_assginBegin, intString(ret_2));
        l_assginBegin = Tpl.writeTok(l_assginBegin, Tpl.ST_STRING(">("));
        l_assginEnd = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING(")"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_assginBegin);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fnName);
        txt = Tpl.writeText(txt, l_assginEnd);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_142;

public function extFunCallVarcopy
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input String in_a_fnName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_arg, in_a_fnName)
    local
      Tpl.Text txt;
      String a_fnName;
      DAE.ComponentRef i_c;
      Integer i_oi;

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = _, cref = i_c),
           a_fnName )
      equation
        txt = fun_142(txt, i_oi, a_fnName, i_c);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end extFunCallVarcopy;

public function expTypeModelica
  input Tpl.Text txt;
  input DAE.Type a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFlag(txt, a_ty, 2);
end expTypeModelica;

protected function fun_145
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_oi, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer i_oi;

    case ( txt,
           0,
           a_c )
      equation
        txt = contextCref2(txt, a_c, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_oi,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out.targTest5"));
        txt = Tpl.writeStr(txt, intString(i_oi));
      then txt;
  end matchcontinue;
end fun_145;

protected function fun_146
  input Tpl.Text in_txt;
  input DAE.Type in_a_t;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_t)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c_str()"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end matchcontinue;
end fun_146;

protected function fun_147
  input Tpl.Text in_txt;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_t, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_cr;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MMC_STRINGDATA("));
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end matchcontinue;
end fun_147;

protected function fun_148
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_t, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Type a_t;
      Tpl.Text a_cr;

    case ( txt,
           false,
           a_t,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
        txt = fun_146(txt, a_t);
      then txt;

    case ( txt,
           _,
           a_t,
           a_cr )
      equation
        txt = fun_147(txt, a_t, a_cr);
      then txt;
  end matchcontinue;
end fun_148;

protected function fun_149
  input Tpl.Text in_txt;
  input Integer in_a_outputIndex;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outputIndex, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer i_outputIndex;

    case ( txt,
           0,
           a_c )
      equation
        txt = contextCref2(txt, a_c, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_outputIndex,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out.targTest4"));
        txt = Tpl.writeStr(txt, intString(i_outputIndex));
      then txt;
  end matchcontinue;
end fun_149;

public function extArg
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_extArg, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Integer i_outputIndex;
      DAE.Type i_type__;
      DAE.Exp i_exp;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Integer i_oi;
      Tpl.Text l_dim;
      Tpl.Text l_typeStr;
      Boolean ret_3;
      Tpl.Text l_cr;
      Tpl.Text l_shortTypeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = i_oi, isArray = true, type_ = i_t),
           a_preExp,
           a_varDecls,
           _ )
      equation
        l_name = fun_145(Tpl.emptyTxt, i_oi, i_c);
        l_shortTypeStr = expTypeShort(Tpl.emptyTxt, i_t);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".data()"));
        txt = Tpl.popBlock(txt);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = 0, type_ = i_t),
           a_preExp,
           a_varDecls,
           _ )
      equation
        l_cr = contextCref2(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        ret_3 = Config.acceptMetaModelicaGrammar();
        txt = fun_148(txt, ret_3, i_t, l_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = _, type_ = _),
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = extVarName2(txt, i_c);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp),
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExternalCExp(txt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = i_c, type_ = i_type__, outputIndex = i_outputIndex, exp = i_exp),
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_typeStr = expTypeShort(Tpl.emptyTxt, i_type__);
        l_name = fun_149(Tpl.emptyTxt, i_outputIndex, i_c);
        (l_dim, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".shape()["));
        txt = Tpl.writeText(txt, l_dim);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -1]"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extArg;

protected function fun_151
  input Tpl.Text in_txt;
  input DAE.Type in_mArg;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.Exp a_exp;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Type ret_1;
      Tpl.Text l_shortTypeStr;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           a_exp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        ret_1 = Expression.typeof(a_exp);
        l_shortTypeStr = expTypeShort(Tpl.emptyTxt, ret_1);
        (txt, a_preExp, a_varDecls) = daeExp(txt, a_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").data()"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_exp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, a_exp, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_151;

public function daeExternalCExp
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  DAE.Type ret_0;
algorithm
  ret_0 := Expression.typeof(a_exp);
  (out_txt, out_a_preExp, out_a_varDecls) := fun_151(txt, ret_0, a_exp, a_context, a_preExp, a_varDecls, a_simCode);
end daeExternalCExp;

protected function fun_153
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ty, in_a_c, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Tpl.Text a_varDecls;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_ty,
           a_c,
           a_varDecls )
      equation
        a_varDecls = extType2(a_varDecls, i_ty, true, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName2(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = extVarName2(txt, a_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = extType2(txt, i_ty, true, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = contextCref2(txt, a_c, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_153;

protected function fun_154
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_oi, in_a_c, in_a_ty, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      DAE.Type a_ty;
      Tpl.Text a_varDecls;

    case ( txt,
           0,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_c,
           a_ty,
           a_varDecls )
      equation
        a_varDecls = extType2(a_varDecls, a_ty, true, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName2(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);
  end matchcontinue;
end fun_154;

public function extFunCallVardecl
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_arg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Integer i_oi;
      DAE.ComponentRef i_c;
      DAE.Type i_ty;

    case ( txt,
           SimCode.SIMEXTARG(isInput = true, isArray = false, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_153(txt, i_ty, i_c, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_154(txt, i_oi, i_c, i_ty, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end extFunCallVardecl;

protected function fun_156
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varAssign, out_a_varCopy, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_fname, in_a_varAssign, in_a_simCode, in_a_var_name, in_a_varCopy, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varCopy;
      Tpl.Text a_varDecls;
      Tpl.Text l_strVar;

    case ( txt,
           false,
           a_fname,
           a_varAssign,
           a_simCode,
           a_var_name,
           a_varCopy,
           a_varDecls )
      equation
        (l_strVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_string_t", a_varDecls);
        a_varCopy = Tpl.writeText(a_varCopy, l_strVar);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(" = strdup("));
        a_varCopy = contextCref(a_varCopy, a_var_name, SimCode.contextFunction, a_simCode);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(");"));
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = init_modelica_string("));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING_LIST({
                                                    ");\n",
                                                    "free("
                                                }, false));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           _,
           a_fname,
           a_varAssign,
           a_simCode,
           a_var_name,
           a_varCopy,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("= "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varCopy, a_varDecls);
  end matchcontinue;
end fun_156;

protected function lm_157
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_157(txt, rest, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varDecls, a_varInits) = lm_157(txt, rest, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end lm_157;

protected function fun_158
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_assginEnd;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_assginBegin;
  input Tpl.Text in_a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign) :=
  matchcontinue(in_txt, in_a_instDims, in_a_instDimsInit, in_a_varInits, in_a_simCode, in_a_var_name, in_a_assginEnd, in_a_fname, in_a_assginBegin, in_a_varAssign)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_assginEnd;
      Tpl.Text a_fname;
      Tpl.Text a_assginBegin;
      Tpl.Text a_varAssign;

    case ( txt,
           {},
           _,
           a_varInits,
           a_simCode,
           a_var_name,
           a_assginEnd,
           a_fname,
           a_assginBegin,
           a_varAssign )
      equation
        a_varAssign = Tpl.pushBlock(a_varAssign, Tpl.BT_INDENT(1));
        a_varAssign = Tpl.writeText(a_varAssign, a_assginBegin);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeText(a_varAssign, a_assginEnd);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.popBlock(a_varAssign);
      then (txt, a_varInits, a_varAssign);

    case ( txt,
           _,
           a_instDimsInit,
           a_varInits,
           a_simCode,
           a_var_name,
           a_assginEnd,
           a_fname,
           a_assginBegin,
           a_varAssign )
      equation
        a_varInits = Tpl.writeText(a_varInits, a_assginBegin);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_"));
        a_varInits = Tpl.writeText(a_varInits, a_fname);
        a_varInits = Tpl.writeText(a_varInits, a_assginEnd);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".resize((boost::extents["));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_LINE("]));\n"));
        a_varInits = Tpl.pushBlock(a_varInits, Tpl.BT_INDENT(4));
        a_varInits = Tpl.writeText(a_varInits, a_assginBegin);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_"));
        a_varInits = Tpl.writeText(a_varInits, a_fname);
        a_varInits = Tpl.writeText(a_varInits, a_assginEnd);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".reindex(1);"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.popBlock(a_varInits);
        a_varAssign = Tpl.writeText(a_varAssign, a_assginBegin);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeText(a_varAssign, a_assginEnd);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("="));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign);
  end matchcontinue;
end fun_158;

protected function fun_159
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_ix;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign, out_a_varCopy, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_var, in_a_ix, in_a_varInits, in_a_fname, in_a_varAssign, in_a_simCode, in_a_varCopy, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_ix;
      Tpl.Text a_varInits;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varCopy;
      Tpl.Text a_varDecls;
      String i_var_name_1;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_assginEnd;
      Tpl.Text l_assginBegin;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_marker;
      Boolean ret_0;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_STRING(varLst = _), name = i_var_name),
           _,
           a_varInits,
           a_fname,
           a_varAssign,
           a_simCode,
           a_varCopy,
           a_varDecls )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        (txt, a_varAssign, a_varCopy, a_varDecls) = fun_156(txt, ret_0, a_fname, a_varAssign, a_simCode, i_var_name, a_varCopy, a_varDecls);
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims),
           a_ix,
           a_varInits,
           a_fname,
           a_varAssign,
           a_simCode,
           a_varCopy,
           a_varDecls )
      equation
        l_marker = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction, a_simCode);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("/* varOutput varInits("));
        a_varInits = Tpl.writeText(a_varInits, l_marker);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(") */ "));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/* varOutput varAssign("));
        a_varAssign = Tpl.writeText(a_varAssign, l_marker);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(") */ "));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_157(l_instDimsInit, i_instDims, a_simCode, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        l_assginBegin = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("get<"));
        l_assginBegin = Tpl.writeStr(l_assginBegin, intString(a_ix));
        l_assginBegin = Tpl.writeTok(l_assginBegin, Tpl.ST_STRING(">("));
        l_assginEnd = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING(")"));
        (txt, a_varInits, a_varAssign) = fun_158(txt, i_instDims, l_instDimsInit, a_varInits, a_simCode, i_var_name, l_assginEnd, a_fname, l_assginBegin, a_varAssign);
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_var_name_1),
           _,
           a_varInits,
           a_fname,
           a_varAssign,
           _,
           a_varCopy,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = (modelica_fnptr) _"));
        a_varAssign = Tpl.writeStr(a_varAssign, i_var_name_1);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           _,
           _,
           a_varInits,
           _,
           a_varAssign,
           _,
           a_varCopy,
           a_varDecls )
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);
  end matchcontinue;
end fun_159;

public function varOutput
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.Variable in_a_var;
  input Integer in_a_ix;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varAssign;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varCopy, out_a_varAssign) :=
  matchcontinue(in_txt, in_a_fn, in_a_var, in_a_ix, in_a_varDecls, in_a_varInits, in_a_varCopy, in_a_varAssign, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;
      Integer a_ix;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varCopy;
      Tpl.Text a_varAssign;
      SimCode.SimCode a_simCode;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(name = i_name),
           a_var,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign,
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls) = fun_159(txt, a_var, a_ix, a_varInits, l_fname, a_varAssign, a_simCode, a_varCopy, a_varDecls);
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign,
           _ )
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);
  end matchcontinue;
end varOutput;

protected function fun_161
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "modelica_metatype" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = NULL"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_161;

protected function fun_162
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;

    case ( txt,
           "modelica_metatype",
           a_varName )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_162;

protected function fun_163
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_addRoot;
  input Tpl.Text in_a_initVar;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_typ;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_instDims, in_a_var_ty, in_a_addRoot, in_a_initVar, in_a_varName, in_a_typ)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;
      Tpl.Text a_addRoot;
      Tpl.Text a_initVar;
      Tpl.Text a_varName;
      Tpl.Text a_typ;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           _,
           a_addRoot,
           a_initVar,
           a_varName,
           a_typ )
      equation
        txt = Tpl.writeText(txt, a_typ);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeText(txt, a_initVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_addRoot);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           i_instDims,
           a_var_ty,
           a_addRoot,
           a_initVar,
           a_varName,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_instDims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeText(txt, a_initVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_addRoot);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end matchcontinue;
end fun_163;

protected function fun_164
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input Integer in_a_i;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outStruct, in_a_i, in_a_simCode, in_a_var_name)
    local
      Tpl.Text txt;
      Integer a_i;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      String i_outStruct;

    case ( txt,
           "",
           _,
           a_simCode,
           a_var_name )
      equation
        txt = contextCref(txt, a_var_name, SimCode.contextFunction, a_simCode);
      then txt;

    case ( txt,
           i_outStruct,
           a_i,
           _,
           _ )
      equation
        txt = Tpl.writeStr(txt, i_outStruct);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".targTest3"));
        txt = Tpl.writeStr(txt, intString(a_i));
      then txt;
  end matchcontinue;
end fun_164;

protected function lm_165
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_165(txt, rest, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varDecls, a_varInits) = lm_165(txt, rest, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end lm_165;

protected function fun_166
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_var_value, in_a_varDecls, in_a_varInits, in_a_simCode, in_a_var_name)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_varInits,
           a_simCode,
           a_var_name )
      equation
        l_defaultValue = contextCref(Tpl.emptyTxt, a_var_name, SimCode.contextFunction, a_simCode);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(" = "));
        (l_defaultValue, a_varInits, a_varDecls) = daeExp(l_defaultValue, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(";"));
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           a_varDecls,
           a_varInits,
           _,
           _ )
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end fun_166;

protected function fun_167
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outStruct, in_a_simCode, in_a_var_name)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;

    case ( txt,
           "",
           a_simCode,
           a_var_name )
      equation
        txt = contextCref(txt, a_var_name, SimCode.contextFunction, a_simCode);
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_var_name )
      equation
        txt = extVarName(txt, a_var_name, a_simCode);
      then txt;
  end matchcontinue;
end fun_167;

protected function fun_168
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input DAE.ComponentRef in_a_var_name;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_var_value, in_a_var_name, in_a_simCode, in_a_varDecls, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_varName, in_a_varInits)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varName;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;
      Tpl.Text l_defaultValue1;
      Tpl.Text l_var__name;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(i_exp),
           a_var_name,
           a_simCode,
           a_varDecls,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_varName,
           a_varInits )
      equation
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".resize((boost::extents["));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_LINE("]));\n"));
        a_varInits = Tpl.pushBlock(a_varInits, Tpl.BT_INDENT(6));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".reindex(1);"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.popBlock(a_varInits);
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits, a_simCode);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        l_var__name = fun_167(Tpl.emptyTxt, a_outStruct, a_simCode, a_var_name);
        l_defaultValue1 = Tpl.writeText(Tpl.emptyTxt, l_var__name);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(" = "));
        (l_defaultValue1, a_varInits, a_varDecls) = daeExp(l_defaultValue1, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(";"));
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           a_simCode,
           a_varDecls,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_varName,
           a_varInits )
      equation
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".resize((boost::extents["));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_LINE("]));\n"));
        a_varInits = Tpl.pushBlock(a_varInits, Tpl.BT_INDENT(6));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".reindex(1);"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.popBlock(a_varInits);
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits, a_simCode);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end fun_168;

protected function fun_169
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Option<DAE.Exp> in_a_var_value;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_instDims, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_varName, in_a_varDecls, in_a_varInits, in_a_simCode, in_a_var_name, in_a_var_value)
    local
      Tpl.Text txt;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Option<DAE.Exp> a_var_value;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_simCode,
           a_var_name,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_166(txt, a_var_value, a_varDecls, a_varInits, a_simCode, a_var_name);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_varName,
           a_varDecls,
           a_varInits,
           a_simCode,
           a_var_name,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_168(txt, a_var_value, a_var_name, a_simCode, a_varDecls, a_i, a_outStruct, a_var, a_instDimsInit, a_varName, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end fun_169;

public function varInit
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_varDecls, in_a_varInits, in_a_simCode)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      Option<DAE.Exp> i_var_value;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;
      SimCode.Variable i_var;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_ignore;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_varName_1;
      String str_5;
      Tpl.Text l_addRoot;
      String str_3;
      Tpl.Text l_initVar;
      Tpl.Text l_typ;
      Tpl.Text l_varName;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, ty = i_var_ty, value = i_var_value)),
           a_outStruct,
           a_i,
           a_varDecls,
           a_varInits,
           a_simCode )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction, a_simCode);
        l_typ = varType(Tpl.emptyTxt, i_var);
        str_3 = Tpl.textString(l_typ);
        l_initVar = fun_161(Tpl.emptyTxt, str_3);
        str_5 = Tpl.textString(l_typ);
        l_addRoot = fun_162(Tpl.emptyTxt, str_5, l_varName);
        a_varDecls = fun_163(a_varDecls, i_instDims, i_var_ty, l_addRoot, l_initVar, l_varName, l_typ);
        l_varName_1 = fun_164(Tpl.emptyTxt, a_outStruct, a_i, a_simCode, i_var_name);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_165(l_instDimsInit, i_instDims, a_simCode, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varDecls, a_varInits) = fun_169(txt, i_instDims, a_i, a_outStruct, i_var, l_instDimsInit, l_varName_1, a_varDecls, a_varInits, a_simCode, i_var_name, i_var_value);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           (i_var as SimCode.FUNCTION_PTR(name = _)),
           _,
           _,
           a_varDecls,
           a_varInits,
           _ )
      equation
        l_ignore = Tpl.emptyTxt;
        (a_varDecls, l_ignore) = functionArg(a_varDecls, i_var, l_ignore);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           _ )
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end varInit;

protected function lm_171
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = mmcVarType(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_171(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_171(txt, rest);
      then txt;
  end matchcontinue;
end lm_171;

protected function lm_172
  input Tpl.Text in_txt;
  input list<DAE.Type> in_items;
  input Tpl.Text in_a_rettype;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_rettype)
    local
      Tpl.Text txt;
      list<DAE.Type> rest;
      Tpl.Text a_rettype;
      Integer x_i1;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_rettype )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" targTest2"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.nextIter(txt);
        txt = lm_172(txt, rest, a_rettype);
      then txt;

    case ( txt,
           _ :: rest,
           a_rettype )
      equation
        txt = lm_172(txt, rest, a_rettype);
      then txt;
  end matchcontinue;
end lm_172;

protected function lm_173
  input Tpl.Text in_txt;
  input list<DAE.Type> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Type> rest;
      Integer x_i1;
      DAE.Type i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ty :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = mmcTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" targTest1"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_173(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_173(txt, rest);
      then txt;
  end matchcontinue;
end lm_173;

protected function fun_174
  input Tpl.Text in_txt;
  input list<DAE.Type> in_a_tys;
  input Tpl.Text in_a_rettype;
  input Tpl.Text in_a_typelist;
  input String in_a_name;
  input Tpl.Text in_a_varInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInit;
algorithm
  (out_txt, out_a_varInit) :=
  matchcontinue(in_txt, in_a_tys, in_a_rettype, in_a_typelist, in_a_name, in_a_varInit)
    local
      Tpl.Text txt;
      Tpl.Text a_rettype;
      Tpl.Text a_typelist;
      String a_name;
      Tpl.Text a_varInit;
      list<DAE.Type> i_tys;

    case ( txt,
           {},
           _,
           a_typelist,
           a_name,
           a_varInit )
      equation
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("_"));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(" = (void(*)("));
        a_varInit = Tpl.writeText(a_varInit, a_typelist);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(")) "));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_NEW_LINE());
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void(*_"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, a_typelist);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInit);

    case ( txt,
           i_tys,
           a_rettype,
           a_typelist,
           a_name,
           a_varInit )
      equation
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("_"));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(" = ("));
        a_varInit = Tpl.writeText(a_varInit, a_rettype);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("(*)("));
        a_varInit = Tpl.writeText(a_varInit, a_typelist);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(")) "));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(";"));
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_172(txt, i_tys, a_rettype);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_s\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_173(txt, i_tys);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*_"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, a_typelist);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInit);
  end matchcontinue;
end fun_174;

public function functionArg
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInit;
algorithm
  (out_txt, out_a_varInit) :=
  matchcontinue(in_txt, in_a_var, in_a_varInit)
    local
      Tpl.Text txt;
      Tpl.Text a_varInit;
      list<DAE.Type> i_tys;
      String i_name;
      list<SimCode.Variable> i_args;
      Tpl.Text l_rettype;
      Tpl.Text l_typelist;

    case ( txt,
           SimCode.FUNCTION_PTR(args = i_args, name = i_name, tys = i_tys),
           a_varInit )
      equation
        l_typelist = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_typelist = lm_171(l_typelist, i_args);
        l_typelist = Tpl.popIter(l_typelist);
        l_rettype = Tpl.writeStr(Tpl.emptyTxt, i_name);
        l_rettype = Tpl.writeTok(l_rettype, Tpl.ST_STRING("RetType"));
        (txt, a_varInit) = fun_174(txt, i_tys, l_rettype, l_typelist, i_name, a_varInit);
      then (txt, a_varInit);

    case ( txt,
           _,
           a_varInit )
      then (txt, a_varInit);
  end matchcontinue;
end functionArg;

public function mmcVarType
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = mmcTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end mmcVarType;

public function mmcTypeShort
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("array"));
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fnptr"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmcTypeShort:ERROR"));
      then txt;
  end matchcontinue;
end mmcTypeShort;

public function extVarName
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := contextCref(txt, a_cr, SimCode.contextFunction, a_simCode);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_ext"));
end extVarName;

public function extVarName2
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := contextCref2(txt, a_cr, SimCode.contextFunction);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_ext"));
end extVarName2;

protected function fun_180
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_value;
  input String in_a_lhsVarName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.SimCode in_a_simCode;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_value, in_a_lhsVarName, in_a_varDecls, in_a_varInits, in_a_i, in_a_outStruct, in_a_simCode, in_a_var_ty)
    local
      Tpl.Text txt;
      String a_lhsVarName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Integer a_i;
      String a_outStruct;
      SimCode.SimCode a_simCode;
      DAE.Type a_var_ty;
      DAE.Exp i_arr;
      DAE.ComponentRef i_cr;
      Tpl.Text l_arrayExp;

    case ( txt,
           SOME(DAE.CREF(componentRef = i_cr)),
           _,
           a_varDecls,
           a_varInits,
           a_i,
           a_outStruct,
           a_simCode,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data(&"));
        txt = contextCref(txt, i_cr, SimCode.contextFunction, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeStr(txt, a_outStruct);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".targTest9"));
        txt = Tpl.writeStr(txt, intString(a_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           SOME((i_arr as DAE.ARRAY(ty = _))),
           a_lhsVarName,
           a_varDecls,
           a_varInits,
           _,
           _,
           a_simCode,
           a_var_ty )
      equation
        (l_arrayExp, a_varInits, a_varDecls) = daeExp(Tpl.emptyTxt, i_arr, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data(&"));
        txt = Tpl.writeText(txt, l_arrayExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeStr(txt, a_lhsVarName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_varInits,
           _,
           _,
           _,
           _ )
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end fun_180;

public function varDefaultValue
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input String in_a_lhsVarName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_lhsVarName, in_a_varDecls, in_a_varInits, in_a_simCode)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      String a_lhsVarName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      DAE.Type i_var_ty;
      Option<DAE.Exp> i_value;

    case ( txt,
           SimCode.VARIABLE(value = i_value, ty = i_var_ty),
           a_outStruct,
           a_i,
           a_lhsVarName,
           a_varDecls,
           a_varInits,
           a_simCode )
      equation
        (txt, a_varDecls, a_varInits) = fun_180(txt, i_value, a_lhsVarName, a_varDecls, a_varInits, a_i, a_outStruct, a_simCode, i_var_ty);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           _ )
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end varDefaultValue;

public function funArgDefinition
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)),
           a_simCode )
      equation
        txt = varType1(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end funArgDefinition;

public function funExtArgDefinition
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extArg, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.Type i_type__;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, isArray = _, type_ = i_t),
           a_simCode )
      equation
        l_name = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction, a_simCode);
        l_typeStr = expTypeFlag(Tpl.emptyTxt, i_t, 5);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_name);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__),
           _ )
      equation
        l_typeStr = expTypeFlag(Tpl.emptyTxt, i_type__, 5);
        txt = Tpl.writeText(txt, l_typeStr);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_t"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end funExtArgDefinition;

protected function fun_184
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)) )
      equation
        txt = varType1(txt, i_var);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_184;

public function funReturnDefinition1
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_184(txt, a_var);
end funReturnDefinition1;

protected function fun_186
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)) )
      equation
        txt = varType2(txt, i_var);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_186;

public function funReturnDefinition2
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_186(txt, a_var);
end funReturnDefinition2;

protected function fun_188
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_instDims, in_a_var_ty)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;

    case ( txt,
           {},
           a_var_ty )
      equation
        txt = expTypeArrayIf(txt, a_var_ty);
      then txt;

    case ( txt,
           _,
           a_var_ty )
      equation
        txt = expTypeArray(txt, a_var_ty);
      then txt;
  end matchcontinue;
end fun_188;

public function varType
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims, ty = i_var_ty) )
      equation
        txt = fun_188(txt, i_instDims, i_var_ty);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end varType;

protected function fun_190
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_instDims, in_a_var_ty)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           a_var_ty )
      equation
        txt = expTypeFlag(txt, a_var_ty, 5);
      then txt;

    case ( txt,
           i_instDims,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_instDims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
      then txt;
  end matchcontinue;
end fun_190;

public function varType1
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims, ty = i_var_ty) )
      equation
        txt = fun_190(txt, i_instDims, i_var_ty);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end varType1;

protected function fun_192
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_instDims, in_a_var_ty)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           a_var_ty )
      equation
        txt = expTypeFlag(txt, a_var_ty, 5);
      then txt;

    case ( txt,
           i_instDims,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array_ref<"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_instDims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
      then txt;
  end matchcontinue;
end fun_192;

public function varType2
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims, ty = i_var_ty) )
      equation
        txt = fun_192(txt, i_instDims, i_var_ty);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end varType2;

protected function lm_194
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, SimCode.contextFunction, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_194(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_194(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_194;

public function funStatement
  input Tpl.Text in_txt;
  input SimCode.Statement in_a_stmt;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<DAE.Statement> i_statementLst;

    case ( txt,
           SimCode.ALGORITHM(statementLst = i_statementLst),
           a_varDecls,
           a_simCode )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_194(txt, i_statementLst, a_simCode, a_varDecls);
        txt = Tpl.popIter(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED FUN STATEMENT"));
      then (txt, a_varDecls);
  end matchcontinue;
end funStatement;

public function init
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_algebraicEquations;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SampleCondition> i_sampleConditions;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<SimCode.SimEqSystem> i_startValueEquations;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Tpl.Text l_initALgloopSolvers;
      Tpl.Text l_initBoundParameters;
      Tpl.Text l_initOutputIndices;
      Tpl.Text l_initEventHandling;
      Tpl.Text l_initTimeEventFunctions;
      Tpl.Text l_initZeroCrossings;
      Tpl.Text l_initFunctions;
      Tpl.Text l_initVariables;
      Tpl.Text l_varDecls;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), startValueEquations = i_startValueEquations, zeroCrossings = i_zeroCrossings, sampleConditions = i_sampleConditions, parameterEquations = i_parameterEquations, odeEquations = i_odeEquations, algebraicEquations = i_algebraicEquations, whenClauses = i_whenClauses)) )
      equation
        System.tmpTickReset(0);
        l_varDecls = Tpl.emptyTxt;
        l_initVariables = initvar(Tpl.emptyTxt, i_modelInfo, i_simCode);
        (l_initFunctions, l_varDecls) = functionInitial(Tpl.emptyTxt, i_startValueEquations, l_varDecls, i_simCode);
        (l_initZeroCrossings, l_varDecls) = functionOnlyZeroCrossing(Tpl.emptyTxt, i_zeroCrossings, l_varDecls, i_simCode);
        (l_initTimeEventFunctions, l_varDecls) = timeEventCondition(Tpl.emptyTxt, i_sampleConditions, l_varDecls, i_simCode);
        l_initEventHandling = eventHandlingInit(Tpl.emptyTxt, i_simCode);
        l_initOutputIndices = outputIndices(Tpl.emptyTxt, i_modelInfo);
        (l_initBoundParameters, l_varDecls) = boundParameters(Tpl.emptyTxt, i_parameterEquations, l_varDecls, i_simCode);
        l_initALgloopSolvers = initAlgloopsolvers(Tpl.emptyTxt, i_odeEquations, i_algebraicEquations, i_whenClauses, i_parameterEquations, i_simCode);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::init(double ts,double te)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_initVariables);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_initFunctions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("checkConditions(0,true);\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_initTimeEventFunctions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_initEventHandling);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.init(this,"));
        txt = helpvarlength(txt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "  vector<unsigned int> var_ouputs_idx;\n"
                                }, true));
        txt = Tpl.writeText(txt, l_initOutputIndices);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_historyImpl->setOutputs(var_ouputs_idx);\n",
                                    "_historyImpl->clear();\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_initALgloopSolvers);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//initialize equations\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_initBoundParameters);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    " }"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end init;

protected function fun_197
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_simCode, in_a_varDecls, in_a_modelname)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(index = i_index)),
           a_simCode,
           a_varDecls,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::init()\n",
                                    "{\n",
                                    "       AlgLoopDefaultImplementation::init();\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        (txt, a_varDecls) = initAlgloopEquation(txt, i_eq, a_varDecls, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("if(_residuals)\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      {\n",
                                    "          delete [] _residuals;\n",
                                    "          _residuals = NULL;\n",
                                    "      }\n",
                                    "      _residuals = new double[_dim[0]];\n",
                                    "\n",
                                    "  // Update the equations once before start of simulation\n",
                                    "  update(IContinous::ALL);\n",
                                    " }"
                                }, false));
      then (txt, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_simCode,
           a_varDecls,
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::init()\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::init();\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        (txt, a_varDecls) = initAlgloopEquation(txt, i_eq, a_varDecls, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "   // Update the equations once before start of simulation\n",
                                    "   update(IContinous::ALL);\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_197;

public function initAlgloop
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_varDecls;
      Tpl.Text l_initalgvars;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_initalgvars = initAlgloopvars(Tpl.emptyTxt, i_modelInfo, i_simCode);
        l_varDecls = Tpl.emptyTxt;
        (txt, l_varDecls) = fun_197(txt, a_eq, i_simCode, l_varDecls, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end initAlgloop;

protected function fun_199
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      Integer i_index;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveAMatrix(double* A_matrix)\n",
                                    "{\n",
                                    "\n",
                                    " }"
                                }, false));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveAMatrix(double* A_matrix)\n",
                                    "{\n",
                                    "     memcpy(A_matrix,_A.data(),_dim[0]*_dim[0]*sizeof(double));\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_199;

public function getAMatrixCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_varDecls;
      Tpl.Text l_initalgvars;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_initalgvars = initAlgloopvars(Tpl.emptyTxt, i_modelInfo, i_simCode);
        l_varDecls = Tpl.emptyTxt;
        txt = fun_199(txt, a_eq, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end getAMatrixCode;

protected function fun_201
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      Integer i_index;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveRHS(double* doubleResiduals, int* intResiduals, bool* boolResiduals)\n",
                                    "  {\n",
                                    "  if(doubleResiduals)\n",
                                    "      memcpy(doubleResiduals,_residuals,_dim[0]*sizeof(double));\n",
                                    "  }"
                                }, false));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveRHS(double* doubleResiduals, int* intResiduals, bool* boolResiduals)\n",
                                    "{\n",
                                    "    if(doubleResiduals)\n",
                                    "    memcpy(doubleResiduals,_b.data(),_dim[0]*sizeof(double));\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_201;

public function algloopRHSCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_varDecls;
      Tpl.Text l_initalgvars;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_initalgvars = initAlgloopvars(Tpl.emptyTxt, i_modelInfo, i_simCode);
        l_varDecls = Tpl.emptyTxt;
        txt = fun_201(txt, a_eq, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end algloopRHSCode;

protected function fun_203
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_simCode, in_a_modelname)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_cont;
      Integer i_index;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveDimResiduals(int index)\n",
                                    "{\n",
                                    "  if(index == 0) return _dim[0];\n",
                                    "  else if(index == 1) return _dim[1];\n",
                                    "  else if(index == 2) return _dim[2];\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveResiduals(double* doubleResiduals, int* intResiduals, bool* boolResiduals)\n",
                                    "{\n",
                                    "    ublas::matrix<double> A=toMatrix(_dim[0],_dim[0],_A.data());\n",
                                    "    double* doubleUnknowns = new double[_dim[0]];\n",
                                    "    int* intUnknowns = new int[_dim[1]];\n",
                                    "    bool* boolUnknowns = new bool[_dim[2]];\n",
                                    "    giveVars(doubleUnknowns,intUnknowns,boolUnknowns);\n",
                                    "    ublas::vector<double> x=toVector(_dim[0],doubleUnknowns);\n",
                                    "    ublas::vector<double> b=toVector(_dim[0],_b.data());\n",
                                    "    b=ublas::prod(ublas::trans(A),x)-b;\n",
                                    "    if(doubleResiduals) std::copy(b.data().begin(), b.data().end(), doubleResiduals);\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveDimResiduals(int index)\n",
                                    "{\n",
                                    "  if(index == 0) return _dim[0];\n",
                                    "  else if(index == 1) return _dim[1];\n",
                                    "  else if(index == 2) return _dim[2];\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveResiduals(double* doubleResiduals, int* intResiduals, bool* boolResiduals)\n",
                                    "{\n",
                                    "      if(doubleResiduals)\n",
                                    "    memcpy(doubleResiduals,_residuals,_dim[0]*sizeof(double));\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont),
           a_simCode,
           _ )
      equation
        txt = algloopResiduals(txt, a_simCode, i_cont);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_203;

public function algloopResiduals
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_203(txt, a_eq, i_simCode, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end algloopResiduals;

protected function fun_205
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      Integer i_index;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isLinear()\n",
                                    "{\n",
                                    "       return false;\n",
                                    " }"
                                }, false));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isLinear()\n",
                                    "{\n",
                                    "     return true;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_205;

public function isLinearCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_varDecls;
      Tpl.Text l_initalgvars;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_initalgvars = initAlgloopvars(Tpl.emptyTxt, i_modelInfo, i_simCode);
        l_varDecls = Tpl.emptyTxt;
        txt = fun_205(txt, a_eq, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end isLinearCode;

protected function lm_207
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref1(Tpl.emptyTxt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_xd["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_207(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_207(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_207;

protected function lm_208
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer i_col;
      Integer i_row;
      DAE.Exp i_eq_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_row, i_col, SimCode.SES_RESIDUAL(exp = i_eq_exp)) :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq_exp, SimCode.contextSimulationNonDiscrete, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_A["));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]["));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_208(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_208(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_208;

protected function lm_209
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer x_i0;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextSimulationNonDiscrete, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_b["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_209(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_209(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_209;

protected function fun_210
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<DAE.Exp> i_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<DAE.ComponentRef> i_crefs;
      Tpl.Text l_bvector;
      Tpl.Text l_Amatrix;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs),
           a_simCode )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_207(txt, i_crefs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(simJac = i_simJac, beqs = i_beqs),
           a_simCode )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        l_Amatrix = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_Amatrix, l_varDecls, l_preExp) = lm_208(l_Amatrix, i_simJac, a_simCode, l_varDecls, l_preExp);
        l_Amatrix = Tpl.popIter(l_Amatrix);
        l_bvector = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bvector, l_varDecls, l_preExp) = lm_209(l_bvector, i_beqs, a_simCode, l_varDecls, l_preExp);
        l_bvector = Tpl.popIter(l_bvector);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_Amatrix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_bvector);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_210;

public function initAlgloopEquation
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_210(txt, a_eq, a_simCode);
  out_a_varDecls := a_varDecls;
end initAlgloopEquation;

protected function lm_212
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref1(Tpl.emptyTxt, i_name, a_simCode);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("doubleUnknowns["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_212(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_212(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_212;

protected function lm_213
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("doubleUnknowns["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] ="));
        txt = cref1(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_213(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_213(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_213;

public function giveAlgloopvars
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars;
      list<DAE.ComponentRef> i_crefs;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs),
           a_simCode )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_212(txt, i_crefs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_213(txt, i_vars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = inlineVars(txt, SimCode.contextSimulationNonDiscrete, i_vars);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end giveAlgloopvars;

protected function lm_215
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = writeAlgloopvars2(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
        (txt, a_varDecls) = lm_215(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_215(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_215;

protected function lm_216
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_215(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_216(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_216(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_216;

public function writeAlgloopvars
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_continousEquations;
  input list<SimCode.SimEqSystem> a_discreteEquations;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_216(l_algloopsolver, a_continousEquations, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.writeText(txt, l_algloopsolver);
end writeAlgloopvars;

protected function lm_218
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_index)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_index;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_index )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = algloopvars"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_218(txt, rest, a_index);
      then txt;

    case ( txt,
           _ :: rest,
           a_index )
      equation
        txt = lm_218(txt, rest, a_index);
      then txt;
  end matchcontinue;
end lm_218;

protected function lm_219
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_algloopid;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_algloopid, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_algloopid;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_algloopid,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref1(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = algloopvars"));
        txt = Tpl.writeText(txt, a_algloopid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_219(txt, rest, a_algloopid, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_algloopid,
           a_simCode )
      equation
        txt = lm_219(txt, rest, a_algloopid, a_simCode);
      then txt;
  end matchcontinue;
end lm_219;

protected function fun_220
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars;
      Integer i_index;
      list<DAE.ComponentRef> i_crefs;
      Tpl.Text l_algloopid;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs, index = i_index),
           _ )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double algloopvars"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->giveVars(algloopvars"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",NULL,NULL);\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_218(txt, i_crefs, i_index);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, index = i_index),
           a_simCode )
      equation
        ret_2 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_algloopid = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double algloopvars"));
        txt = Tpl.writeText(txt, l_algloopid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->giveVars(algloopvars"));
        txt = Tpl.writeText(txt, l_algloopid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",NULL,NULL);\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_219(txt, i_vars, l_algloopid, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_220;

public function writeAlgloopvars2
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_220(txt, a_eq, a_simCode);
  out_a_varDecls := a_varDecls;
end writeAlgloopvars2;

protected function lm_222
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref1(Tpl.emptyTxt, i_name, a_simCode);
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  = doubleUnknowns["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_222(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_222(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_222;

protected function lm_223
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref1(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=doubleUnknowns["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_223(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_223(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_223;

public function setAlgloopvars
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars;
      list<DAE.ComponentRef> i_crefs;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs),
           a_simCode )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_222(txt, i_crefs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_223(txt, i_vars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = inlineVars(txt, SimCode.contextSimulationNonDiscrete, i_vars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end setAlgloopvars;

protected function fun_225
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars;
      list<DAE.ComponentRef> i_crefs;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs) )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  // Number of unknowns/equations according to type (0: double, 1: int, 2: bool)\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dim[0] = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "_dim[1] = 0;\n",
                                    "_dim[2] = 0;"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars) )
      equation
        ret_2 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  // Number of unknowns/equations according to type (0: double, 1: int, 2: bool)\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dim[0] = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "_dim[1] = 0;\n",
                                    "_dim[2] = 0;\n",
                                    "fill_array(_A,0.0);\n",
                                    "fill_array(_b,0.0);"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_225;

public function initAlgloopDimension
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_225(txt, a_eq);
  out_a_varDecls := a_varDecls;
end initAlgloopDimension;

public function alocateLinearSystem
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars) )
      equation
        ret_1 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",_A(boost::extents["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("],boost::fortran_storage_order())\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",_b(boost::extents["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end alocateLinearSystem;

public function Update
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_allEquations;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(allEquations = i_allEquations, whenClauses = i_whenClauses)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = update(txt, i_allEquations, i_whenClauses, i_simCode);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end Update;

protected function smf_229
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_it;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           i_eq,
           a_simCode )
      equation
        txt = writeoutputAlgloopsolvers(txt, i_eq, a_simCode);
      then txt;
  end matchcontinue;
end smf_229;

protected function lm_230
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqs :: rest,
           a_simCode )
      equation
        txt = smf_229(txt, i_eqs, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_230(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_230(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_230;

protected function lm_231
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqn :: rest,
           a_simCode )
      equation
        txt = writeoutput3(txt, i_eqn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_231(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_231(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_231;

protected function fun_232
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.SimEqSystem> in_a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_simCode, in_a_allEquations)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> a_allEquations;

    case ( txt,
           false,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_historyImpl->write(v,v2,time);"));
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_allEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("HistoryImplType::value_type_r v3("));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_230(txt, a_allEquations, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double residues [] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_231(txt, a_allEquations, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "for(int i=0;i<"
                                }, false));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";i++) v3(i) = residues[i];\n",
                                    "_historyImpl->write(v,v2,v3,time);"
                                }, false));
      then txt;
  end matchcontinue;
end fun_232;

public function writeoutput
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), allEquations = i_allEquations)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::writeOutput(const OUTPUT command)\n",
                                    "{\n",
                                    "\n",
                                    "   //Write head line\n",
                                    " if (command & HEAD_LINE)\n",
                                    " {\n",
                                    " vector<string> head;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("head+= "));
        txt = writeoutput1(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_historyImpl->write(head);\n",
                                    "}\n",
                                    "//Write the current values\n",
                                    "else\n",
                                    "{\n",
                                    "\n",
                                    "HistoryImplType::value_type_v v("
                                }, false));
        txt = numAlgvars(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numStatevars(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "HistoryImplType::value_type_dv v2("
                                }, false));
        txt = numDerivativevars(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = writeoutput2(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_232(txt, ret_0, i_simCode, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end writeoutput;

protected function fun_234
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double* doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->giveDimResiduals(0)];\n",
                                    "int* intResiduals"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new int[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->giveDimResiduals(1)];\n",
                                    "bool* boolResiduals"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new bool[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->giveDimResiduals(2)];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->giveResiduals(doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",intResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",boolResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end matchcontinue;
end fun_234;

protected function fun_235
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double* doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->giveDimResiduals(0)];\n",
                                    "int* intResiduals"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new int[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->giveDimResiduals(1)];\n",
                                    "bool* boolResiduals"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new bool[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->giveDimResiduals(2)];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->giveResiduals(doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",intResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",boolResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end matchcontinue;
end fun_235;

protected function fun_236
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double* doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->giveDimResiduals(0)];\n",
                                    "int* intResiduals"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new int[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->giveDimResiduals(1)];\n",
                                    "bool* boolResiduals"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new bool[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->giveDimResiduals(2)];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->giveResiduals(doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",intResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",boolResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end matchcontinue;
end fun_236;

public function writeoutputAlgloopsolvers
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_234(txt, a_simCode, l_num);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_235(txt, a_simCode, l_num);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(index = i_index),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_236(txt, a_simCode, l_num);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end writeoutputAlgloopsolvers;

protected function lm_238
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_e_index)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_e_index;
      Integer x_myindex2;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_e_index )
      equation
        x_myindex2 = Tpl.getIteri_i0(txt);
        txt = writeoutput4(txt, a_e_index, x_myindex2);
        txt = Tpl.nextIter(txt);
        txt = lm_238(txt, rest, a_e_index);
      then txt;

    case ( txt,
           _ :: rest,
           a_e_index )
      equation
        txt = lm_238(txt, rest, a_e_index);
      then txt;
  end matchcontinue;
end lm_238;

protected function lm_239
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_e_index)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Integer a_e_index;
      Integer x_myindex2;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_e_index )
      equation
        x_myindex2 = Tpl.getIteri_i0(txt);
        txt = writeoutput4(txt, a_e_index, x_myindex2);
        txt = Tpl.nextIter(txt);
        txt = lm_239(txt, rest, a_e_index);
      then txt;

    case ( txt,
           _ :: rest,
           a_e_index )
      equation
        txt = lm_239(txt, rest, a_e_index);
      then txt;
  end matchcontinue;
end lm_239;

public function writeoutput3
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eqn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_cont;
      list<SimCode.SimEqSystem> i_eqs;
      Integer i_e_index;
      list<SimCode.SimVar> i_vars;
      DAE.ComponentRef i_cref;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = _),
           _ )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref),
           a_simCode )
      equation
        txt = cref1(txt, i_cref, a_simCode);
      then txt;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = _),
           _ )
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = _),
           _ )
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, index = i_e_index),
           _ )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_238(txt, i_vars, i_e_index);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(eqs = i_eqs, index = i_e_index),
           _ )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_239(txt, i_eqs, i_e_index);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont),
           a_simCode )
      equation
        txt = writeoutput3(txt, i_cont, a_simCode);
      then txt;

    case ( txt,
           SimCode.SES_WHEN(left = _),
           _ )
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end writeoutput3;

public function writeoutput4
  input Tpl.Text txt;
  input Integer a_index;
  input Integer a_myindex2;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("*(doubleResiduals"));
  out_txt := Tpl.writeStr(out_txt, intString(a_index));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("+"));
  out_txt := Tpl.writeStr(out_txt, intString(a_myindex2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(")"));
end writeoutput4;

protected function fun_242
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.SimEqSystem> in_a_allEquations;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_allEquations, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquations;
      SimCode.ModelInfo a_modelInfo;

    case ( txt,
           false,
           _,
           a_modelInfo )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include \"policies/TextFileWriter.h\"\n",
                                    "typedef HistoryImpl<TextFileWriter,"
                                }, false));
        txt = numAlgvars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numStatevars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = numDerivativevars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",0> HistoryImplType;\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           a_allEquations,
           a_modelInfo )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include \"ReduceDAE/Interfaces/IReduceDAE.h\"\n",
                                    "#include \"policies/BufferReaderWriter.h\"\n",
                                    "typedef HistoryImpl<BufferReaderWriter,"
                                }, false));
        txt = numAlgvars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numStatevars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = numDerivativevars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "> HistoryImplType;\n",
                                    "\n"
                                }, true));
      then txt;
  end matchcontinue;
end fun_242;

public function generateHeaderInlcudeString
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.ModelInfo i_modelInfo;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_algebraicEquations;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), extObjInfo = SimCode.EXTOBJINFO(vars = _), odeEquations = i_odeEquations, algebraicEquations = i_algebraicEquations, whenClauses = i_whenClauses, parameterEquations = i_parameterEquations, allEquations = i_allEquations)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma once\n",
                                    "#define BOOST_EXTENSION_SYSTEM_DECL BOOST_EXTENSION_IMPORT_DECL\n",
                                    "#define BOOST_EXTENSION_EVENTHANDLING_DECL BOOST_EXTENSION_IMPORT_DECL\n",
                                    "#include <boost\\shared_ptr.hpp>\n",
                                    "#include \"System/Implementation/SystemDefaultImplementation.h\"\n",
                                    "#include \"Math/Implementation/ArrayOperations.h\"\n",
                                    "#include \"System/Implementation/EventHandling.h\"\n",
                                    "#include \"Settingsfactory/Interfaces/IGlobalSettings.h\"\n",
                                    "#include \"System/Interfaces/IAlgLoopSolverFactory.h\"\n",
                                    "#include \"System/Interfaces/IAlgLoopSolver.h\"\n",
                                    "#include \"Functions.h\"\n"
                                }, true));
        txt = algloopfilesInclude(txt, i_odeEquations, i_algebraicEquations, i_whenClauses, i_parameterEquations, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include \"DataExchange/Interfaces/IHistory.h\"\n",
                                    "#include \"HistoryImpl.h\"\n"
                                }, true));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_242(txt, ret_0, i_allEquations, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Simulation code for "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " generated by the OpenModelica Compiler.\n",
                                    "* System class "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " implements the Interface IDAESystem\n",
                                    "*\n",
                                    "*****************************************************************************/"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end generateHeaderInlcudeString;

public function generateAlgloopHeaderInlcudeString
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), extObjInfo = SimCode.EXTOBJINFO(vars = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma once\n",
                                    "#define BOOST_EXTENSION_ALGLOOPDEFAULTIMPL_DECL BOOST_EXTENSION_IMPORT_DECL\n",
                                    "#define BOOST_EXTENSION_EVENTHANDLING_DECL BOOST_EXTENSION_IMPORT_DECL\n",
                                    "#include \"System/Interfaces/IDAESystem.h\"\n",
                                    "#include \"System/Implementation/AlgLoopDefaultImplementation.h\"\n",
                                    "#include \"System/Implementation/EventHandling.h\"\n",
                                    "#include \"Functions.h\""
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end generateAlgloopHeaderInlcudeString;

protected function fun_245
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",public IReduceDAE "));
      then txt;
  end matchcontinue;
end fun_245;

public function generateClassDeclarationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_algebraicEquations;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      list<SimCode.SampleCondition> i_sampleConditions;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      SimCode.ModelInfo i_modelInfo;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), zeroCrossings = i_zeroCrossings, sampleConditions = i_sampleConditions, odeEquations = i_odeEquations, algebraicEquations = i_algebraicEquations, whenClauses = i_whenClauses, parameterEquations = i_parameterEquations)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": public IDAESystem ,public IContinous ,public IEvent ,public ISystemProperties, public  ISystemInitialization "));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_245(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",public SystemDefaultImplementation\n",
                                    "{\n",
                                    "public:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(IGlobalSettings& globalSettings);\n",
                                    "~"
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "();\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateMethodDeclarationCode(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "private:\n",
                                    "  //Methods:\n",
                                    "\n",
                                    "\n",
                                    "   void resetHelpVar(const int index);\n",
                                    "\n",
                                    "   //Variables:\n",
                                    "   EventHandling _event_handling;\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = MemberVariable(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = conditionvariable(txt, i_zeroCrossings, i_sampleConditions, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Functions _functions;\n",
                                    "HistoryImplType* _historyImpl;\n",
                                    "boost::shared_ptr<IAlgLoopSolverFactory>\n",
                                    "   _algLoopSolverFactory;    ///< Factory that provides an appropriate solver\n"
                                }, true));
        txt = generateAlgloopsolverVariables(txt, i_odeEquations, i_algebraicEquations, i_whenClauses, i_parameterEquations, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" };"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end generateClassDeclarationCode;

protected function fun_247
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_algvars;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_constructorParams;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_algvars, in_a_simCode, in_a_constructorParams, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_algvars;
      SimCode.SimCode a_simCode;
      Tpl.Text a_constructorParams;
      Tpl.Text a_modelname;
      Integer i_index;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_algvars,
           a_simCode,
           a_constructorParams,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ": public IAlgLoop, public AlgLoopDefaultImplementation\n",
                                    "{\n",
                                    "public:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(33));
        txt = Tpl.writeText(txt, a_constructorParams);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",double* z,double* zDot\n",
                                    ",EventHandling& event_handling\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "                                );\n",
                                    "~"
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "();\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateAlgloopMethodDeclarationCode(txt, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "private:\n",
                                    "  Functions _functions;\n",
                                    "  double         *_residuals;        ///< Auxillary variables\n",
                                    "  //states\n",
                                    "  double* _z;\n",
                                    "  //state derivatives\n",
                                    "  double* _zDot;\n",
                                    "  // A matrix\n",
                                    "  boost::multi_array<double,2> _A;\n",
                                    "  //b vector\n",
                                    "  boost::multi_array<double,1> _b;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, a_algvars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  EventHandling& _event_handling;\n",
                                    " };"
                                }, false));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_algvars,
           a_simCode,
           a_constructorParams,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ": public IAlgLoop, public AlgLoopDefaultImplementation\n",
                                    "{\n",
                                    "public:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(33));
        txt = Tpl.writeText(txt, a_constructorParams);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",double* z,double* zDot\n",
                                    ",EventHandling& event_handling\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "                                );\n",
                                    "~"
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "();\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateAlgloopMethodDeclarationCode(txt, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "private:\n",
                                    "  Functions _functions;\n",
                                    "  double         *_residuals;        ///< Auxillary variables\n",
                                    "  //states\n",
                                    "  double* _z;\n",
                                    "  //state derivatives\n",
                                    "  double* _zDot;\n",
                                    "  // A matrix\n",
                                    "  boost::multi_array<double,2> _A;\n",
                                    "  //b vector\n",
                                    "  boost::multi_array<double,1> _b;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, a_algvars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  EventHandling& _event_handling;\n",
                                    " };"
                                }, false));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_247;

public function generateAlgloopClassDeclarationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_constructorParams;
      Tpl.Text l_algvars;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_algvars = MemberVariableAlgloop(Tpl.emptyTxt, i_modelInfo);
        l_constructorParams = ConstructorParamAlgloop(Tpl.emptyTxt, i_modelInfo);
        txt = fun_247(txt, a_eq, l_algvars, i_simCode, l_constructorParams, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end generateAlgloopClassDeclarationCode;

protected function smf_249
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_it;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           i_eq,
           a_simCode )
      equation
        txt = writeoutputAlgloopsolvers(txt, i_eq, a_simCode);
      then txt;
  end matchcontinue;
end smf_249;

protected function lm_250
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqs :: rest,
           a_simCode )
      equation
        txt = smf_249(txt, i_eqs, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_250(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_250(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_250;

protected function lm_251
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqn :: rest,
           a_simCode )
      equation
        txt = writeoutput3(txt, i_eqn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_251(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_251(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_251;

protected function fun_252
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.SimEqSystem> in_a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_simCode, in_a_allEquations)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> a_allEquations;

    case ( txt,
           false,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    SystemDefaultImplementation::giveRHS(f,index);"));
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_allEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(index == IContinous::ALL_RESIDUES)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_250(txt, a_allEquations, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double residues [] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_251(txt, a_allEquations, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "for(int i=0;i<"
                                }, false));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";i++) *(f+i) = residues[i];\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "else SystemDefaultImplementation::giveRHS(f,index);"
                                }, false));
      then txt;
  end matchcontinue;
end fun_252;

public function DefaultImplementationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SampleCondition> i_sampleConditions;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_allEquations;
      Absyn.Path i_modelInfo_name;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), allEquations = i_allEquations, sampleConditions = i_sampleConditions)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  // Release instance\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::destroy()\n",
                                    "{\n",
                                    "    delete this;\n",
                                    "}\n",
                                    "\n",
                                    "// Set current integration time\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setTime(const double& t)\n",
                                    "{\n",
                                    "    SystemDefaultImplementation::setTime(t);\n",
                                    "}\n",
                                    "\n",
                                    "// Returns the vector with all time events\n",
                                    "event_times_type "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getTimeEvents()\n",
                                    "{\n",
                                    "    return _event_handling.getTimeEvents();\n",
                                    "}\n",
                                    "\n",
                                    "// Provide number (dimension) of variables according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimVars(const INDEX index) const\n",
                                    "{\n",
                                    "    return(SystemDefaultImplementation::getDimVars(index));\n",
                                    "}\n",
                                    "\n",
                                    "// Provide number (dimension) of right hand sides (equations and/or residuals) according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimRHS(const INDEX index ) const\n",
                                    "{\n",
                                    "     return(SystemDefaultImplementation::getDimRHS(index));\n",
                                    "}\n",
                                    "\n",
                                    "// Provide variables with given index to the system\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveVars(double* z, const INDEX index)\n",
                                    "{\n",
                                    "    SystemDefaultImplementation::giveVars(z,index);\n",
                                    "}\n",
                                    "\n",
                                    "// Set variables with given index to the system\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setVars(const double* z, const INDEX index)\n",
                                    "{\n",
                                    "    SystemDefaultImplementation::setVars(z,index);\n",
                                    "}\n",
                                    "\n",
                                    "// Provide the right hand side (according to the index)\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveRHS(double* f, const INDEX index)\n",
                                    "{\n"
                                }, true));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_252(txt, ret_0, i_simCode, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveJacobianSparsityPattern(SparcityPattern pattern)\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"giveJacobianSparsityPattern is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveJacobian(SparseMatrix matrix)\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"giveJacobian is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveMassSparsityPattern(SparcityPattern pattern)\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"giveMassSparsityPattern is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveMassMatrix(SparseMatrix matrix)\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"giveMassMatrix is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveConstraintSparsityPattern(SparcityPattern pattern)\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"giveConstraintSparsityPattern is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveConstraint(SparseMatrix matrix)\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"giveConstraint is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isAutonomous()\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"isAutonomous is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isTimeInvariant()\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"isTimeInvariant is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isAlgebraic()\n",
                                    "{\n",
                                    "  return false; // Indexreduction is enabled\n",
                                    "}\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isExplicit()\n",
                                    "{\n",
                                    "  return true; // At the moment only explicit form is supported\n",
                                    "}\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::hasConstantMass()\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"hasConstantMass is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::hasStateDependentMass()\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"hasStateDependentMass is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::provideSymbolicJacobian()\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"provideSymbolicJacobian is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::handleEvent(unsigned long index)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = handleEvent(txt, i_sampleConditions, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end DefaultImplementationCode;

protected function fun_254
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_simCode, in_a_modelname)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_simCode,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/// Provide number (dimension) of variables according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimVars(const IAlgLoop::DATATYPE type) const\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimVars(type));\n",
                                    "};\n",
                                    "\n",
                                    "/// Provide number (dimension) of residuals according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimRHS(const IAlgLoop::DATATYPE type ) const\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimRHS(type));\n",
                                    "};\n",
                                    "\n",
                                    "/// Provide number (dimension) of inputs according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimInputs(const IAlgLoop::DATATYPE type )\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimInputs(type));\n",
                                    "};\n",
                                    "\n",
                                    "/// Provide number (dimension) of outputs according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimOutputs(const IAlgLoop::DATATYPE type )\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimOutputs(type));\n",
                                    "};\n",
                                    "\n",
                                    "/// Add contraint value to algebraic loop\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::addInputs(const double* doubleInputs, const int* intInputs, const bool* boolInputs)\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::addInputs(doubleInputs, intInputs, boolInputs);\n",
                                    "};\n",
                                    "\n",
                                    "/// Add outputs of algebraic loop\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::addOutputs(double* doubleOutputs, int* intOutputs, bool* boolOutputs)\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::addOutputs(doubleOutputs, intOutputs, boolOutputs);;\n",
                                    "};\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "/// Provide variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveVars(double* doubleUnknowns, int* intUnknowns, bool* boolUnknowns)\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::giveVars(doubleUnknowns, intUnknowns, boolUnknowns);\n",
                                    "    //workaroud until names of algloop vars are replaced in simcode\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = giveAlgloopvars(txt, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "/// Set variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setVars(const double* doubleUnknowns, const int* intUnknowns, const bool* boolUnknowns)\n",
                                    "{\n",
                                    "    //workaroud until names of algloop vars are replaced in simcode\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = setAlgloopvars(txt, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("AlgLoopDefaultImplementation::setVars(doubleUnknowns, intUnknowns, boolUnknowns);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "/// Set stream for output\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setOutput(ostream* outputStream)\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::setOutput(outputStream);\n",
                                    "};"
                                }, false));
      then txt;

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(index = i_index)),
           a_simCode,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/// Provide number (dimension) of variables according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimVars(const IAlgLoop::DATATYPE type) const\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimVars(type));\n",
                                    "};\n",
                                    "\n",
                                    "/// Provide number (dimension) of residuals according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimRHS(const IAlgLoop::DATATYPE type ) const\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimRHS(type));\n",
                                    "};\n",
                                    "\n",
                                    "/// Provide number (dimension) of inputs according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimInputs(const IAlgLoop::DATATYPE type )\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimInputs(type));\n",
                                    "};\n",
                                    "\n",
                                    "/// Provide number (dimension) of outputs according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimOutputs(const IAlgLoop::DATATYPE type )\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimOutputs(type));\n",
                                    "};\n",
                                    "\n",
                                    "/// Add contraint value to algebraic loop\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::addInputs(const double* doubleInputs, const int* intInputs, const bool* boolInputs)\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::addInputs(doubleInputs, intInputs, boolInputs);\n",
                                    "};\n",
                                    "\n",
                                    "/// Add outputs of algebraic loop\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::addOutputs(double* doubleOutputs, int* intOutputs, bool* boolOutputs)\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::addOutputs(doubleOutputs, intOutputs, boolOutputs);;\n",
                                    "};\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "/// Provide variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveVars(double* doubleUnknowns, int* intUnknowns, bool* boolUnknowns)\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::giveVars(doubleUnknowns, intUnknowns, boolUnknowns);\n",
                                    "    //workaroud until names of algloop vars are replaced in simcode\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = giveAlgloopvars(txt, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "/// Set variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setVars(const double* doubleUnknowns, const int* intUnknowns, const bool* boolUnknowns)\n",
                                    "{\n",
                                    "    //workaroud until names of algloop vars are replaced in simcode\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = setAlgloopvars(txt, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("AlgLoopDefaultImplementation::setVars(doubleUnknowns, intUnknowns, boolUnknowns);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "/// Set stream for output\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setOutput(ostream* outputStream)\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::setOutput(outputStream);\n",
                                    "};"
                                }, false));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_254;

public function AlgloopDefaultImplementationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_254(txt, a_eq, i_simCode, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end AlgloopDefaultImplementationCode;

protected function fun_256
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Returns the history object to query simulation results\n",
                                    "virtual IHistory* getHistory();\n",
                                    "// Returns labels for a labeled DAE\n",
                                    "virtual label_list_type getLabels();\n",
                                    "//Sets all algebraic and state varibales for current time\n",
                                    "virtual void setVariables(const ublas::vector<double>& variables, const ublas::vector<double>& variables2);\n",
                                    "\n"
                                }, true));
      then txt;
  end matchcontinue;
end fun_256;

public function generateMethodDeclarationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "     //Releases the Modelica System\n",
                                    "    virtual void destroy();\n",
                                    "    //provide number (dimension) of variables according to the index\n",
                                    "    virtual int getDimVars(const INDEX index = ALL_VARS) const;\n",
                                    "    //Provide number (dimension) of right hand sides (equations and/or residuals) according to the index\n",
                                    "    virtual int getDimRHS(const INDEX index = ALL_VARS)const;\n",
                                    "      //Resets all time events\n",
                                    "    virtual void resetTimeEvents();\n",
                                    "    //Set current integration time\n",
                                    "    virtual void setTime(const double& t);\n",
                                    "    //Provide variables with given index to the system\n",
                                    "    virtual void giveVars(double* z, const INDEX index = ALL_VARS);\n",
                                    "    //Set variables with given index to the system\n",
                                    "    virtual void setVars(const double* z, const INDEX index = ALL_VARS);\n",
                                    "    //Update transfer behavior of the system of equations according to command given by solver\n",
                                    "    virtual void update(const UPDATE command =IContinous::UNDEF_UPDATE);\n",
                                    "    //Provide the right hand side (according to the index)\n",
                                    "    virtual void giveRHS(double* f, const INDEX index = ALL_VARS);\n",
                                    "    //Output routine (to be called by the solver after every successful integration step)\n",
                                    "    virtual void writeOutput(const OUTPUT command = UNDEF_OUTPUT);\n",
                                    "    //Provide pattern for Jacobian\n",
                                    "    virtual void giveJacobianSparsityPattern(SparcityPattern pattern);\n",
                                    "    //Provide Jacobian\n",
                                    "    virtual void giveJacobian(SparseMatrix matrix);\n",
                                    "    //Provide pattern for mass matrix\n",
                                    "    virtual void giveMassSparsityPattern(SparcityPattern pattern);\n",
                                    "    //Provide mass matrix\n",
                                    "    virtual void giveMassMatrix(SparseMatrix matrix);\n",
                                    "    //Provide pattern for global constraint jacobian\n",
                                    "    virtual void giveConstraintSparsityPattern(SparcityPattern pattern);\n",
                                    "    //Provide global constraint jacobian\n",
                                    "    virtual void giveConstraint(SparseMatrix matrix);\n",
                                    "    //Provide number (dimension) of zero functions\n",
                                    "    virtual int getDimZeroFunc();\n",
                                    "    //Provides current values of root/zero functions\n",
                                    "     virtual void giveZeroFunc(double* f);\n",
                                    "    virtual void giveConditions(bool* c);\n",
                                    "    virtual void setConditions(bool* c);\n",
                                    "    //Called to check conditions for event-handling\n",
                                    "    virtual void checkConditions(unsigned int, bool all);\n",
                                    "    virtual void saveConditions();\n",
                                    "    //Called to handle all  events occured at same time\n",
                                    "    virtual void handleSystemEvents(const bool* events);\n",
                                    "    //Called to handle an event\n",
                                    "    virtual void handleEvent(unsigned long index);\n",
                                    "    //Checks if a discrete variable has changed and triggers an event\n",
                                    "    virtual bool checkForDiscreteEvents();\n",
                                    "     //Saves all variables before an event is handled, is needed for the pre, edge and change operator\n",
                                    "    virtual void saveAll();\n",
                                    "    //Returns the vector with all time events\n",
                                    "    virtual event_times_type getTimeEvents();\n",
                                    "    // No input\n",
                                    "    virtual bool isAutonomous();\n",
                                    "    // Time is not present\n",
                                    "    virtual bool isTimeInvariant();\n",
                                    "    // M is regular\n",
                                    "    virtual bool isODE();\n",
                                    "    // M is singular\n",
                                    "    virtual bool isAlgebraic();\n",
                                    "    //M = identity\n",
                                    "    virtual bool isExplicit();\n",
                                    "    // M does not depend on t, z\n",
                                    "    virtual bool hasConstantMass();\n",
                                    "    // M depends on z\n",
                                    "    virtual bool hasStateDependentMass();\n",
                                    "    // System is able to provide the Jacobian symbolically\n",
                                    "    virtual bool provideSymbolicJacobian();\n",
                                    "    //Systeminitialization methods\n",
                                    "    virtual unsigned int getDimInitEquations() ;\n",
                                    "    virtual unsigned int getDimUnfixedStates() ;\n",
                                    "    virtual unsigned int getDimUnfixedParameters();\n",
                                    "    virtual unsigned int getDimIntialResiduals() ;\n",
                                    "    virtual bool initial();\n",
                                    "    virtual void setInitial(bool);\n",
                                    "    /// (Re-) initialize the system of equations and bounded parameters\n",
                                    "    virtual void init(double ts,double te);\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_256(txt, ret_0);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end generateMethodDeclarationCode;

protected function fun_258
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/// Provide dimensions of residuals for linear equation systems\n",
                                    "virtual int giveDimResiduals(int index);\n",
                                    "/// Provide the residuals for linear equation systems\n",
                                    "virtual void giveResiduals(double* doubleResiduals, int* intResiduals, bool* boolResiduals);"
                                }, false));
      then txt;
  end matchcontinue;
end fun_258;

public function generateAlgloopMethodDeclarationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    /// Provide number (dimension) of variables according to data type\n",
                                    "    virtual int getDimVars(const IAlgLoop::DATATYPE type = IAlgLoop::ALL) const    ;\n",
                                    "    /// Provide number (dimension) of residuals according to data type\n",
                                    "    virtual int getDimRHS(const IAlgLoop::DATATYPE type = IAlgLoop::ALL) const    ;\n",
                                    "    /// Provide number (dimension) of inputs according to data type\n",
                                    "    virtual int getDimInputs(const IAlgLoop::DATATYPE type = IAlgLoop::ALL)     ;\n",
                                    "    /// Provide number (dimension) of outputs according to data type\n",
                                    "    virtual int getDimOutputs(const IAlgLoop::DATATYPE type = IAlgLoop::ALL)    ;\n",
                                    "    /// Add contraint value to algebraic loop\n",
                                    "    virtual void addInputs(const double* doubleInputs, const int* intInputs, const bool* boolInputs);\n",
                                    "    /// Add outputs of algebraic loop\n",
                                    "    virtual void addOutputs(double* doubleOutputs, int* intOutputs, bool* boolOutputs)    ;\n",
                                    "    /// (Re-) initialize the system of equations\n",
                                    "    virtual void init();\n",
                                    "    /// Provide variables with given index to the system\n",
                                    "    virtual void giveVars(double* doubleUnknowns, int* intUnknowns, bool* boolUnknowns)    ;\n",
                                    "    /// Set variables with given index to the system\n",
                                    "    virtual void setVars(const double* doubleUnknowns, const int* intUnknowns, const bool* boolUnknowns)    ;\n",
                                    "    /// Update transfer behavior of the system of equations according to command given by solver\n",
                                    "    virtual void update(const  IContinous::UPDATE command =IContinous::UNDEF_UPDATE);\n",
                                    "    /// Provide the right hand side (according to the index)\n",
                                    "    virtual void giveRHS(double* doubleResiduals, int* intResiduals, bool* boolResiduals);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_258(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/// Output routine (to be called by the solver after every successful integration step)\n",
                                    "virtual void giveAMatrix(double* A_matrix);\n",
                                    "virtual bool isLinear();\n",
                                    "/// Set stream for output\n",
                                    "virtual void setOutput(ostream* outputStream)     ;\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end generateAlgloopMethodDeclarationCode;

protected function lm_260
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine2(txt, i_var, "algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_260(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_260(txt, rest);
      then txt;
  end matchcontinue;
end lm_260;

protected function lm_261
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine2(txt, i_var, "parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_261(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_261(txt, rest);
      then txt;
  end matchcontinue;
end lm_261;

protected function lm_262
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine2(txt, i_var, "aliasVars");
        txt = Tpl.nextIter(txt);
        txt = lm_262(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_262(txt, rest);
      then txt;
  end matchcontinue;
end lm_262;

protected function lm_263
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "int", i_var, "intVariables.algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_263(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_263(txt, rest);
      then txt;
  end matchcontinue;
end lm_263;

protected function lm_264
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "int", i_var, "intVariables.parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_264(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_264(txt, rest);
      then txt;
  end matchcontinue;
end lm_264;

protected function lm_265
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "int", i_var, "intVariables.AliasVars");
        txt = Tpl.nextIter(txt);
        txt = lm_265(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_265(txt, rest);
      then txt;
  end matchcontinue;
end lm_265;

protected function lm_266
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "bool", i_var, "boolVariables.algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_266(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_266(txt, rest);
      then txt;
  end matchcontinue;
end lm_266;

protected function lm_267
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "bool", i_var, "boolVariables.parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_267(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_267(txt, rest);
      then txt;
  end matchcontinue;
end lm_267;

protected function lm_268
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "bool ", i_var, "boolVariables.AliasVars");
        txt = Tpl.nextIter(txt);
        txt = lm_268(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_268(txt, rest);
      then txt;
  end matchcontinue;
end lm_268;

protected function lm_269
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "string", i_var, "stringVariables.algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_269(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_269(txt, rest);
      then txt;
  end matchcontinue;
end lm_269;

protected function lm_270
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "string", i_var, "stringVariables.parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_270(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_270(txt, rest);
      then txt;
  end matchcontinue;
end lm_270;

protected function lm_271
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "string", i_var, "stringVariables.AliasVars");
        txt = Tpl.nextIter(txt);
        txt = lm_271(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_271(txt, rest);
      then txt;
  end matchcontinue;
end lm_271;

protected function lm_272
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine2(txt, i_var, "constvariables");
        txt = Tpl.nextIter(txt);
        txt = lm_272(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_272(txt, rest);
      then txt;
  end matchcontinue;
end lm_272;

protected function lm_273
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "const int", i_var, "intConstvariables");
        txt = Tpl.nextIter(txt);
        txt = lm_273(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_273(txt, rest);
      then txt;
  end matchcontinue;
end lm_273;

protected function lm_274
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "const bool", i_var, "boolConstvariables");
        txt = Tpl.nextIter(txt);
        txt = lm_274(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_274(txt, rest);
      then txt;
  end matchcontinue;
end lm_274;

protected function lm_275
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "const string", i_var, "stringConstvariables");
        txt = Tpl.nextIter(txt);
        txt = lm_275(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_275(txt, rest);
      then txt;
  end matchcontinue;
end lm_275;

public function MemberVariable
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_260(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_261(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_262(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_263(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_264(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_265(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_266(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_267(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_268(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_269(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_270(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_271(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_272(txt, i_vars_constVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_273(txt, i_vars_intConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_274(txt, i_vars_boolConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_275(txt, i_vars_stringConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end MemberVariable;

protected function lm_277
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "algebraics", "");
        txt = Tpl.nextIter(txt);
        txt = lm_277(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_277(txt, rest);
      then txt;
  end matchcontinue;
end lm_277;

protected function fun_278
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_algVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_algVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_278;

protected function lm_279
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "parameters", "");
        txt = Tpl.nextIter(txt);
        txt = lm_279(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_279(txt, rest);
      then txt;
  end matchcontinue;
end lm_279;

protected function fun_280
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_280;

protected function lm_281
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "aliasVars", "");
        txt = Tpl.nextIter(txt);
        txt = lm_281(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_281(txt, rest);
      then txt;
  end matchcontinue;
end lm_281;

protected function fun_282
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_aliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_aliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_282;

protected function lm_283
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.algebraics", "");
        txt = Tpl.nextIter(txt);
        txt = lm_283(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_283(txt, rest);
      then txt;
  end matchcontinue;
end lm_283;

protected function fun_284
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_284;

protected function lm_285
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.parameters", "");
        txt = Tpl.nextIter(txt);
        txt = lm_285(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_285(txt, rest);
      then txt;
  end matchcontinue;
end lm_285;

protected function fun_286
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_286;

protected function lm_287
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.AliasVars", "");
        txt = Tpl.nextIter(txt);
        txt = lm_287(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_287(txt, rest);
      then txt;
  end matchcontinue;
end lm_287;

protected function fun_288
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_288;

protected function lm_289
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "bool", i_var, "boolVariables.algebraics", "");
        txt = Tpl.nextIter(txt);
        txt = lm_289(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_289(txt, rest);
      then txt;
  end matchcontinue;
end lm_289;

protected function fun_290
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_290;

protected function lm_291
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "bool", i_var, "boolVariables.parameters", "");
        txt = Tpl.nextIter(txt);
        txt = lm_291(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_291(txt, rest);
      then txt;
  end matchcontinue;
end lm_291;

protected function fun_292
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_292;

protected function lm_293
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "bool ", i_var, "boolVariables.AliasVars", "");
        txt = Tpl.nextIter(txt);
        txt = lm_293(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_293(txt, rest);
      then txt;
  end matchcontinue;
end lm_293;

protected function fun_294
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_294;

protected function lm_295
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.algebraics", "");
        txt = Tpl.nextIter(txt);
        txt = lm_295(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_295(txt, rest);
      then txt;
  end matchcontinue;
end lm_295;

protected function fun_296
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_296;

protected function lm_297
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.parameters", "");
        txt = Tpl.nextIter(txt);
        txt = lm_297(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_297(txt, rest);
      then txt;
  end matchcontinue;
end lm_297;

protected function fun_298
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_298;

protected function lm_299
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.AliasVars", "");
        txt = Tpl.nextIter(txt);
        txt = lm_299(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_299(txt, rest);
      then txt;
  end matchcontinue;
end lm_299;

protected function fun_300
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_300;

protected function lm_301
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "constvariables", "");
        txt = Tpl.nextIter(txt);
        txt = lm_301(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_301(txt, rest);
      then txt;
  end matchcontinue;
end lm_301;

protected function fun_302
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_constVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_constVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_302;

protected function lm_303
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "const int", i_var, "intConstvariables", "");
        txt = Tpl.nextIter(txt);
        txt = lm_303(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_303(txt, rest);
      then txt;
  end matchcontinue;
end lm_303;

protected function fun_304
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_304;

protected function lm_305
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "const bool", i_var, "boolConstvariables", "");
        txt = Tpl.nextIter(txt);
        txt = lm_305(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_305(txt, rest);
      then txt;
  end matchcontinue;
end lm_305;

protected function fun_306
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_306;

protected function lm_307
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "const string", i_var, "stringConstvariables", "");
        txt = Tpl.nextIter(txt);
        txt = lm_307(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_307(txt, rest);
      then txt;
  end matchcontinue;
end lm_307;

protected function fun_308
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_308;

public function MemberVariableAlgloop
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_277(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_278(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_279(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_280(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_281(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = fun_282(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_283(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_284(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_285(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_286(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_287(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = fun_288(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_289(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_290(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_291(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_292(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_293(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = fun_294(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_295(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_296(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_297(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_298(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_299(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_300(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_301(txt, i_vars_constVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = fun_302(txt, i_vars_constVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_303(txt, i_vars_intConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = fun_304(txt, i_vars_intConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_305(txt, i_vars_boolConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = fun_306(txt, i_vars_boolConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_307(txt, i_vars_stringConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = fun_308(txt, i_vars_stringConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end MemberVariableAlgloop;

protected function lm_310
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "algebraics", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_310(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_310(txt, rest);
      then txt;
  end matchcontinue;
end lm_310;

protected function fun_311
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_311;

protected function lm_312
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "parameters", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_312(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_312(txt, rest);
      then txt;
  end matchcontinue;
end lm_312;

protected function fun_313
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_aliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_aliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_313;

protected function lm_314
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "aliasVars", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_314(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_314(txt, rest);
      then txt;
  end matchcontinue;
end lm_314;

protected function fun_315
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_315;

protected function lm_316
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.algebraics", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_316(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_316(txt, rest);
      then txt;
  end matchcontinue;
end lm_316;

protected function fun_317
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_317;

protected function lm_318
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.parameters", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_318(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_318(txt, rest);
      then txt;
  end matchcontinue;
end lm_318;

protected function fun_319
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_319;

protected function lm_320
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.AliasVars", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_320(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_320(txt, rest);
      then txt;
  end matchcontinue;
end lm_320;

protected function fun_321
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_321;

protected function lm_322
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "bool", i_var, "boolVariables.algebraics", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_322(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_322(txt, rest);
      then txt;
  end matchcontinue;
end lm_322;

protected function fun_323
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_323;

protected function lm_324
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "bool", i_var, "boolVariables.parameters", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_324(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_324(txt, rest);
      then txt;
  end matchcontinue;
end lm_324;

protected function fun_325
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_325;

protected function lm_326
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "bool ", i_var, "boolVariables.AliasVars", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_326(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_326(txt, rest);
      then txt;
  end matchcontinue;
end lm_326;

protected function fun_327
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_327;

protected function lm_328
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.algebraics", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_328(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_328(txt, rest);
      then txt;
  end matchcontinue;
end lm_328;

protected function fun_329
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_329;

protected function lm_330
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.parameters", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_330(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_330(txt, rest);
      then txt;
  end matchcontinue;
end lm_330;

protected function fun_331
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_331;

protected function lm_332
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.AliasVars", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_332(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_332(txt, rest);
      then txt;
  end matchcontinue;
end lm_332;

protected function fun_333
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_constVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_constVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_333;

protected function lm_334
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "constvariables", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_334(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_334(txt, rest);
      then txt;
  end matchcontinue;
end lm_334;

protected function fun_335
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_335;

protected function lm_336
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "const int", i_var, "intConstvariables", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_336(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_336(txt, rest);
      then txt;
  end matchcontinue;
end lm_336;

protected function fun_337
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_337;

protected function lm_338
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "const bool", i_var, "boolConstvariables", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_338(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_338(txt, rest);
      then txt;
  end matchcontinue;
end lm_338;

protected function fun_339
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_339;

protected function lm_340
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "const string", i_var, "stringConstvariables", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_340(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_340(txt, rest);
      then txt;
  end matchcontinue;
end lm_340;

public function ConstructorParamAlgloop
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_310(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = fun_311(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_312(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_313(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_314(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_315(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_316(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_317(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_318(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_319(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_320(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_321(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_322(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_323(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_324(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_325(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_326(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_327(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_328(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = fun_329(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_330(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = fun_331(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_332(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_333(txt, i_vars_constVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_334(txt, i_vars_constVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_335(txt, i_vars_intConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_336(txt, i_vars_intConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_337(txt, i_vars_boolConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_338(txt, i_vars_boolConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_339(txt, i_vars_stringConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_340(txt, i_vars_stringConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end ConstructorParamAlgloop;

protected function lm_342
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_342(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_342(txt, rest);
      then txt;
  end matchcontinue;
end lm_342;

protected function fun_343
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_343;

protected function lm_344
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_344(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_344(txt, rest);
      then txt;
  end matchcontinue;
end lm_344;

protected function fun_345
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_aliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_aliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_345;

protected function lm_346
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_346(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_346(txt, rest);
      then txt;
  end matchcontinue;
end lm_346;

protected function fun_347
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_347;

protected function lm_348
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_348(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_348(txt, rest);
      then txt;
  end matchcontinue;
end lm_348;

protected function fun_349
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_349;

protected function lm_350
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_350(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_350(txt, rest);
      then txt;
  end matchcontinue;
end lm_350;

protected function fun_351
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_351;

protected function lm_352
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_352(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_352(txt, rest);
      then txt;
  end matchcontinue;
end lm_352;

protected function fun_353
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_353;

protected function lm_354
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_354(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_354(txt, rest);
      then txt;
  end matchcontinue;
end lm_354;

protected function fun_355
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_355;

protected function lm_356
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_356(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_356(txt, rest);
      then txt;
  end matchcontinue;
end lm_356;

protected function fun_357
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_357;

protected function lm_358
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_358(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_358(txt, rest);
      then txt;
  end matchcontinue;
end lm_358;

protected function fun_359
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_359;

protected function lm_360
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_360(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_360(txt, rest);
      then txt;
  end matchcontinue;
end lm_360;

protected function fun_361
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_361;

protected function lm_362
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_362(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_362(txt, rest);
      then txt;
  end matchcontinue;
end lm_362;

protected function fun_363
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_363;

protected function lm_364
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_364(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_364(txt, rest);
      then txt;
  end matchcontinue;
end lm_364;

protected function fun_365
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_constVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_constVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_365;

protected function lm_366
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_366(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_366(txt, rest);
      then txt;
  end matchcontinue;
end lm_366;

protected function fun_367
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_367;

protected function lm_368
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_368(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_368(txt, rest);
      then txt;
  end matchcontinue;
end lm_368;

protected function fun_369
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_369;

protected function lm_370
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_370(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_370(txt, rest);
      then txt;
  end matchcontinue;
end lm_370;

protected function fun_371
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_371;

protected function lm_372
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_372(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_372(txt, rest);
      then txt;
  end matchcontinue;
end lm_372;

public function CallAlgloopParams
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_342(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = fun_343(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_344(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_345(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_346(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_347(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_348(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_349(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_350(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_351(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_352(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_353(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_354(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_355(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_356(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_357(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_358(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_359(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_360(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = fun_361(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_362(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = fun_363(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_364(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_365(txt, i_vars_constVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_366(txt, i_vars_constVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_367(txt, i_vars_intConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_368(txt, i_vars_intConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_369(txt, i_vars_boolConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_370(txt, i_vars_boolConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_371(txt, i_vars_stringConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_372(txt, i_vars_stringConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end CallAlgloopParams;

protected function fun_374
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_algVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_algVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_374;

protected function lm_375
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "algebraics", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_375(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_375(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_375;

protected function fun_376
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_376;

protected function lm_377
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "parameters", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_377(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_377(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_377;

protected function fun_378
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_aliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_aliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_378;

protected function lm_379
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "aliasVars", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_379(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_379(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_379;

protected function fun_380
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_380;

protected function lm_381
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "intVariables.algebraics", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_381(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_381(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_381;

protected function fun_382
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_382;

protected function lm_383
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "intVariables.parameters", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_383(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_383(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_383;

protected function fun_384
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_384;

protected function lm_385
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "intVariables.AliasVars", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_385(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_385(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_385;

protected function fun_386
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_386;

protected function lm_387
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "boolVariables.algebraics", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_387(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_387(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_387;

protected function fun_388
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_388;

protected function lm_389
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "boolVariables.parameters", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_389(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_389(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_389;

protected function fun_390
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_390;

protected function lm_391
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "boolVariables.AliasVars", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_391(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_391(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_391;

protected function fun_392
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_392;

protected function lm_393
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "stringVariables.algebraics", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_393(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_393(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_393;

protected function fun_394
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_394;

protected function lm_395
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "stringVariables.parameters", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_395(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_395(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_395;

protected function fun_396
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_396;

protected function lm_397
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "stringVariables.AliasVars", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_397(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_397(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_397;

protected function fun_398
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_constVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_constVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_398;

protected function lm_399
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "constvariables", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_399(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_399(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_399;

protected function fun_400
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_intConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_400;

protected function lm_401
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "intConstvariables", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_401(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_401(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_401;

protected function fun_402
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_boolConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_402;

protected function lm_403
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "boolConstvariables", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_403(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_403(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_403;

protected function fun_404
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vars_stringConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end matchcontinue;
end fun_404;

protected function lm_405
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "stringConstvariables", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_405(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);

    case ( txt,
           _ :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = lm_405(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end matchcontinue;
end lm_405;

public function InitAlgloopParams
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  matchcontinue(in_txt, in_a_modelInfo, in_a_arrayInit)
    local
      Tpl.Text txt;
      Tpl.Text a_arrayInit;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)),
           a_arrayInit )
      equation
        txt = fun_374(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_375(txt, i_vars_algVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_376(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_377(txt, i_vars_paramVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_378(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_379(txt, i_vars_aliasVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_380(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_381(txt, i_vars_intAlgVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_382(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_383(txt, i_vars_intParamVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_384(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_385(txt, i_vars_intAliasVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_386(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_387(txt, i_vars_boolAlgVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_388(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_389(txt, i_vars_boolParamVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = fun_390(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_391(txt, i_vars_boolAliasVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_392(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_393(txt, i_vars_stringAlgVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_394(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_395(txt, i_vars_stringParamVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_396(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_397(txt, i_vars_stringAliasVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_398(txt, i_vars_constVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_399(txt, i_vars_constVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_400(txt, i_vars_intConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_401(txt, i_vars_intConstVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_402(txt, i_vars_boolConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_403(txt, i_vars_boolConstVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = fun_404(txt, i_vars_stringConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     ","
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_405(txt, i_vars_stringConstVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_arrayInit);

    case ( txt,
           _,
           a_arrayInit )
      then (txt, a_arrayInit);
  end matchcontinue;
end InitAlgloopParams;

protected function fun_407
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar, in_a_type)
    local
      Tpl.Text txt;
      String a_type;
      list<String> i_numArrayElement;
      DAE.Type i_type__;
      DAE.ComponentRef i_name;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, name = i_name),
           a_type )
      equation
        txt = Tpl.writeStr(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = i_numArrayElement, type_ = i_type__),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_numArrayElement);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = i_numArrayElement, type_ = i_type__),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_1 = listLength(i_numArrayElement);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_407;

public function MemberVariableDefine
  input Tpl.Text txt;
  input String a_type;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_407(txt, a_simVar, a_type);
end MemberVariableDefine;

protected function fun_409
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_type;
  input String in_a_pre;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar, in_a_type, in_a_pre)
    local
      Tpl.Text txt;
      String a_type;
      String a_pre;
      list<String> i_num;
      DAE.Type i_type__;
      DAE.ComponentRef i_name;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, name = i_name),
           a_type,
           a_pre )
      equation
        txt = Tpl.writeStr(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = cref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = i_num, type_ = i_type__),
           _,
           a_pre )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_num);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = arraycref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = i_num, type_ = i_type__),
           _,
           a_pre )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_1 = listLength(i_num);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = arraycref(txt, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_409;

public function MemberVariableDefineReference
  input Tpl.Text txt;
  input String a_type;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;
  input String a_pre;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_409(txt, a_simVar, a_type, a_pre);
end MemberVariableDefineReference;

protected function fun_411
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      list<String> i_num;
      DAE.ComponentRef i_name;
      DAE.Type i_type__;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, type_ = i_type__, name = i_name) )
      equation
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = i_num, type_ = i_type__) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_num);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = i_num, type_ = i_type__) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_1 = listLength(i_num);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_411;

public function MemberVariableDefine2
  input Tpl.Text txt;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_411(txt, a_simVar);
end MemberVariableDefine2;

protected function fun_413
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, name = i_name) )
      equation
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(_"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = _) )
      equation
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(_"));
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = _) )
      equation
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("( _"));
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_413;

public function InitAlgloopParam
  input Tpl.Text txt;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;
  input Tpl.Text a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  out_txt := fun_413(txt, a_simVar);
  out_a_arrayInit := a_arrayInit;
end InitAlgloopParam;

public function CallAlgloopParam
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, name = i_name) )
      equation
        txt = cref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = _) )
      equation
        txt = arraycref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = _) )
      equation
        txt = arraycref(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end CallAlgloopParam;

protected function fun_416
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_pre;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar, in_a_pre)
    local
      Tpl.Text txt;
      String a_pre;
      list<String> i_num;
      DAE.ComponentRef i_name;
      DAE.Type i_type__;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, type_ = i_type__, name = i_name),
           a_pre )
      equation
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = cref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = i_num, type_ = i_type__),
           a_pre )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_num);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = arraycref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = i_num, type_ = i_type__),
           a_pre )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_1 = listLength(i_num);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = arraycref(txt, i_name);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_416;

public function MemberVariableDefineReference2
  input Tpl.Text txt;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;
  input String a_pre;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_416(txt, a_simVar, a_pre);
end MemberVariableDefineReference2;

public function arrayConstruct
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stringAlgVars = i_vars_stringAlgVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)) )
      equation
        txt = arrayConstruct1(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_constVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_intConstVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_boolConstVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_stringConstVars);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end arrayConstruct;

protected function lm_419
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_419(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_419(txt, rest);
      then txt;
  end matchcontinue;
end lm_419;

protected function lm_420
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      list<String> i_v_numArrayElement;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(arrayCref = SOME(_), name = i_name, numArrayElement = i_v_numArrayElement) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(boost::extents["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_419(txt, i_v_numArrayElement);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
        txt = Tpl.nextIter(txt);
        txt = lm_420(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_420(txt, rest);
      then txt;
  end matchcontinue;
end lm_420;

public function arrayConstruct1
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_420(out_txt, a_varsLst);
  out_txt := Tpl.popIter(out_txt);
end arrayConstruct1;

public function variableType
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end variableType;

public function lastIdentOfPath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_modelName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelName)
    local
      Tpl.Text txt;
      String i_name;
      Absyn.Path i_path;

    case ( txt,
           Absyn.QUALIFIED(path = i_path) )
      equation
        txt = lastIdentOfPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = lastIdentOfPath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end lastIdentOfPath;

public function cref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefToCStr(txt, i_cr);
      then txt;
  end matchcontinue;
end cref;

public function cref2
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefToCStr(txt, i_cr);
      then txt;
  end matchcontinue;
end cref2;

public function crefToCStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsToCStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsToCStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_P_"));
        txt = crefToCStr(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end crefToCStr;

protected function lm_427
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptToCStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_427(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_427(txt, rest);
      then txt;
  end matchcontinue;
end lm_427;

public function subscriptsToCStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_427(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end matchcontinue;
end subscriptsToCStr;

public function subscriptToCStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end matchcontinue;
end subscriptToCStr;

public function arraycref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefToCStr1(txt, i_cr);
      then txt;
  end matchcontinue;
end arraycref;

public function crefToCStr1
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsToCStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_P_"));
        txt = crefToCStr1(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end crefToCStr1;

public function crefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      list<DAE.Subscript> i_subscriptLst;

    case ( txt,
           DAE.CREF_IDENT(ident = "xloc", subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_xd"));
        txt = subscriptsStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der("));
        txt = crefStr(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end crefStr;

protected function lm_433
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_433(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_433(txt, rest);
      then txt;
  end matchcontinue;
end lm_433;

public function subscriptsStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_433(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end matchcontinue;
end subscriptsStr;

public function subscriptStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end matchcontinue;
end subscriptStr;

public function simulationInitFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      SimCode.SimCode i_simCode;
      list<SimCode.SimVar> i_vars_constVars;
      SimCode.ModelInfo i_modelInfo;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(varInfo = SimCode.VARINFO(numHelpVars = _), vars = SimCode.SIMVARS(constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars))))) )
      equation
        txt = arrayConstruct(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_constVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_intConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_boolConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_stringConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_paramVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_intParamVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_boolParamVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_stringParamVars, i_simCode);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end simulationInitFile;

protected function fun_437
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v) )
      equation
        txt = initVal(txt, i_v);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;
  end matchcontinue;
end fun_437;

protected function lm_438
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Option<DAE.Exp> i_initialValue;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, name = i_name, initialValue = i_initialValue) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = fun_437(txt, i_initialValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.nextIter(txt);
        txt = lm_438(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_438(txt, rest);
      then txt;
  end matchcontinue;
end lm_438;

public function initVals
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_438(out_txt, a_varsLst);
  out_txt := Tpl.popIter(out_txt);
end initVals;

public function arrayInit
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      SimCode.SimCode i_simCode;
      list<SimCode.SimVar> i_vars_paramVars;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numHelpVars = _), vars = SimCode.SIMVARS(paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)))) )
      equation
        txt = initVals1(txt, i_vars_paramVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_intParamVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_boolParamVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_stringParamVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_constVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_intConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_boolConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_stringConstVars, i_simCode);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end arrayInit;

protected function lm_441
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_var as SimCode.SIMVAR(name = _)) :: rest,
           a_simCode )
      equation
        txt = initVals2(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_441(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_441(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_441;

public function initVals1
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_441(out_txt, a_varsLst, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end initVals1;

protected function fun_443
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v) )
      equation
        txt = initVal(txt, i_v);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;
  end matchcontinue;
end fun_443;

protected function fun_444
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      Option<DAE.Exp> i_initialValue;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}) )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name, initialValue = i_initialValue) )
      equation
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = fun_443(txt, i_initialValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_444;

public function initVals2
  input Tpl.Text txt;
  input SimCode.SimVar a_var;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_444(txt, a_var);
end initVals2;

public function arrayReindex
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stringAlgVars = i_vars_stringAlgVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)) )
      equation
        txt = arrayReindex1(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_constVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_intConstVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_boolConstVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_stringConstVars);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end arrayReindex;

protected function lm_447
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(arrayCref = SOME(_), name = i_name) :: rest )
      equation
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".reindex(1);"));
        txt = Tpl.nextIter(txt);
        txt = lm_447(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_447(txt, rest);
      then txt;
  end matchcontinue;
end lm_447;

public function arrayReindex1
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_447(out_txt, a_varsLst);
  out_txt := Tpl.popIter(out_txt);
end arrayReindex1;

protected function fun_449
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end matchcontinue;
end fun_449;

public function initVal
  input Tpl.Text in_txt;
  input DAE.Exp in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      Absyn.Path i_name;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = Util.escapeModelicaStringToCString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_449(txt, i_bool);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index, name = i_name) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*ENUM:"));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*ERROR* initial value of unknown type"));
      then txt;
  end matchcontinue;
end initVal;

public function dotPath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dotPath;

protected function lm_452
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_452(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_452(txt, rest);
      then txt;
  end matchcontinue;
end lm_452;

protected function lm_453
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_453(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_453(txt, rest);
      then txt;
  end matchcontinue;
end lm_453;

protected function lm_454
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_454(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_454(txt, rest);
      then txt;
  end matchcontinue;
end lm_454;

protected function lm_455
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_455(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_455(txt, rest);
      then txt;
  end matchcontinue;
end lm_455;

protected function lm_456
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_456(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_456(txt, rest);
      then txt;
  end matchcontinue;
end lm_456;

protected function smf_457
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_457;

protected function smf_458
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_458;

protected function smf_459
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_459;

protected function smf_460
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_460;

protected function smf_461
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_461;

public function writeoutput1
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt_0 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_0 = lm_452(txt_0, i_vars_algVars);
        txt_0 = Tpl.popIter(txt_0);
        txt_1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_1 = lm_453(txt_1, i_vars_intAlgVars);
        txt_1 = Tpl.popIter(txt_1);
        txt_2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_454(txt_2, i_vars_boolAlgVars);
        txt_2 = Tpl.popIter(txt_2);
        txt_3 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_3 = lm_455(txt_3, i_vars_stateVars);
        txt_3 = Tpl.popIter(txt_3);
        txt_4 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_4 = lm_456(txt_4, i_vars_derivativeVars);
        txt_4 = Tpl.popIter(txt_4);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_457(txt, txt_0);
        txt = smf_458(txt, txt_1);
        txt = smf_459(txt, txt_2);
        txt = smf_460(txt, txt_3);
        txt = smf_461(txt, txt_4);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end writeoutput1;

protected function lm_463
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqn :: rest )
      equation
        txt = numResidues2(txt, i_eqn);
        txt = Tpl.nextIter(txt);
        txt = lm_463(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_463(txt, rest);
      then txt;
  end matchcontinue;
end lm_463;

public function numResidues
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("+")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_463(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
end numResidues;

protected function lm_465
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
        txt = Tpl.nextIter(txt);
        txt = lm_465(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_465(txt, rest);
      then txt;
  end matchcontinue;
end lm_465;

protected function lm_466
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
        txt = Tpl.nextIter(txt);
        txt = lm_466(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_466(txt, rest);
      then txt;
  end matchcontinue;
end lm_466;

public function numResidues2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eqn)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem i_cont;
      list<SimCode.SimEqSystem> i_eqs;
      list<SimCode.SimVar> i_vars;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = _) )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = _) )
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = _) )
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("+")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_465(txt, i_vars);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(eqs = i_eqs) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("+")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_466(txt, i_eqs);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont) )
      equation
        txt = numResidues2(txt, i_cont);
      then txt;

    case ( txt,
           SimCode.SES_WHEN(left = _) )
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end numResidues2;

public function numStatevars
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numStateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end numStatevars;

public function numAlgvars
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numBoolAlgVars;
      Integer i_varInfo_numIntAlgVars;
      Integer i_varInfo_numAlgVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numAlgVars = i_varInfo_numAlgVars, numIntAlgVars = i_varInfo_numIntAlgVars, numBoolAlgVars = i_varInfo_numBoolAlgVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAlgVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end numAlgvars;

public function numAlgvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numAlgVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numAlgVars = i_varInfo_numAlgVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end numAlgvar;

public function numIntAlgvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numIntAlgVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numIntAlgVars = i_varInfo_numIntAlgVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAlgVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end numIntAlgvar;

public function numBoolAlgvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numBoolAlgVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numBoolAlgVars = i_varInfo_numBoolAlgVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAlgVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end numBoolAlgvar;

protected function fun_473
  input Tpl.Text in_txt;
  input Option<Integer> in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer i_val;

    case ( txt,
           SOME(i_val) )
      equation
        txt = Tpl.writeStr(txt, intString(i_val));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_473;

protected function fun_474
  input Tpl.Text in_txt;
  input Option<Integer> in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer i_val;

    case ( txt,
           SOME(i_val) )
      equation
        txt = Tpl.writeStr(txt, intString(i_val));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_474;

public function numDerivativevars
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Option<Integer> i_varInfo_dimODE2ndOrder;
      Option<Integer> i_varInfo_dimODE1stOrder;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(dimODE1stOrder = i_varInfo_dimODE1stOrder, dimODE2ndOrder = i_varInfo_dimODE2ndOrder)) )
      equation
        txt = fun_473(txt, i_varInfo_dimODE1stOrder);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = fun_474(txt, i_varInfo_dimODE2ndOrder);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end numDerivativevars;

protected function lm_476
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v("));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_476(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_476(txt, rest);
      then txt;
  end matchcontinue;
end lm_476;

protected function lm_477
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.ModelInfo a_modelInfo;
      Integer x_i1;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_modelInfo )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v("));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numAlgvar(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_477(txt, rest, a_modelInfo);
      then txt;

    case ( txt,
           _ :: rest,
           a_modelInfo )
      equation
        txt = lm_477(txt, rest, a_modelInfo);
      then txt;
  end matchcontinue;
end lm_477;

protected function lm_478
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.ModelInfo a_modelInfo;
      Integer x_i2;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_modelInfo )
      equation
        x_i2 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v("));
        txt = Tpl.writeStr(txt, intString(x_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+ "));
        txt = numAlgvar(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" +"));
        txt = numIntAlgvar(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_478(txt, rest, a_modelInfo);
      then txt;

    case ( txt,
           _ :: rest,
           a_modelInfo )
      equation
        txt = lm_478(txt, rest, a_modelInfo);
      then txt;
  end matchcontinue;
end lm_478;

protected function lm_479
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.ModelInfo a_modelInfo;
      Integer x_i3;
      Integer i_index;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(index = i_index) :: rest,
           a_modelInfo )
      equation
        x_i3 = Tpl.getIteri_i0(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v("));
        txt = Tpl.writeStr(txt, intString(x_i3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" +"));
        txt = numAlgvar(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" +"));
        txt = numIntAlgvar(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" +"));
        txt = numBoolAlgvar(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")=_z["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_479(txt, rest, a_modelInfo);
      then txt;

    case ( txt,
           _ :: rest,
           a_modelInfo )
      equation
        txt = lm_479(txt, rest, a_modelInfo);
      then txt;
  end matchcontinue;
end lm_479;

protected function lm_480
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i4;
      Integer i_index;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(index = i_index) :: rest )
      equation
        x_i4 = Tpl.getIteri_i0(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v2("));
        txt = Tpl.writeStr(txt, intString(x_i4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")=_zDot["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_480(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_480(txt, rest);
      then txt;
  end matchcontinue;
end lm_480;

public function writeoutput2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      SimCode.ModelInfo i_modelInfo;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           (i_modelInfo as SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_476(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_477(txt, i_vars_intAlgVars, i_modelInfo);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_478(txt, i_vars_boolAlgVars, i_modelInfo);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_479(txt, i_vars_stateVars, i_modelInfo);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_480(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end writeoutput2;

protected function lm_482
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.save("));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.nextIter(txt);
        txt = lm_482(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_482(txt, rest);
      then txt;
  end matchcontinue;
end lm_482;

protected function lm_483
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.save("));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.nextIter(txt);
        txt = lm_483(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_483(txt, rest);
      then txt;
  end matchcontinue;
end lm_483;

protected function lm_484
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.save("));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.nextIter(txt);
        txt = lm_484(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_484(txt, rest);
      then txt;
  end matchcontinue;
end lm_484;

protected function lm_485
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Integer i_index;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(index = i_index, name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.save(_z["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("],\""));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.nextIter(txt);
        txt = lm_485(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_485(txt, rest);
      then txt;
  end matchcontinue;
end lm_485;

protected function smf_486
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_486;

protected function smf_487
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_487;

protected function smf_488
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_488;

protected function smf_489
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_489;

protected function fun_490
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stateVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      Absyn.Path i_modelInfo_name;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stateVars = i_vars_stateVars), name = i_modelInfo_name)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::saveAll()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_0 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_0 = lm_482(txt_0, i_vars_algVars);
        txt_0 = Tpl.popIter(txt_0);
        txt_1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_1 = lm_483(txt_1, i_vars_intAlgVars);
        txt_1 = Tpl.popIter(txt_1);
        txt_2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_484(txt_2, i_vars_boolAlgVars);
        txt_2 = Tpl.popIter(txt_2);
        txt_3 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_3 = lm_485(txt_3, i_vars_stateVars);
        txt_3 = Tpl.popIter(txt_3);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_486(txt, txt_0);
        txt = smf_487(txt, txt_1);
        txt = smf_488(txt, txt_2);
        txt = smf_489(txt, txt_3);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " _event_handling.saveH();\n",
                                    "\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_490;

public function saveall
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_490(txt, a_simCode);
end saveall;

public function initvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars)),
           a_simCode )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = initValst(txt, i_vars_stateVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_derivativeVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_algVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_intAlgVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_boolAlgVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_aliasVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_intAliasVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_boolAliasVars, a_simCode);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end initvar;

public function initAlgloopvars
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars)),
           a_simCode )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = initValst(txt, i_vars_algVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_intAlgVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_boolAlgVars, a_simCode);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end initAlgloopvars;

protected function lm_494
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_494(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_494(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_494;

protected function lm_495
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_ALGORITHM(statements = _)) :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_495(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_495(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_495;

public function boundParameters
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_divbody;
  Tpl.Text l_body;
  Tpl.Text l_tmp;
algorithm
  l_tmp := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, out_a_varDecls) := lm_494(l_body, a_parameterEquations, a_simCode, a_varDecls);
  l_body := Tpl.popIter(l_body);
  l_divbody := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_divbody, out_a_varDecls) := lm_495(l_divbody, a_parameterEquations, a_simCode, out_a_varDecls);
  l_divbody := Tpl.popIter(l_divbody);
  out_txt := Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_divbody);
  out_txt := Tpl.popBlock(out_txt);
end boundParameters;

protected function fun_497
  input Tpl.Text in_txt;
  input Tpl.Text in_mArg;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeStr(txt, intString(a_index));
      then txt;
  end matchcontinue;
end fun_497;

protected function lm_498
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer i_index;
      SimCode.Causality i_causality;
      Tpl.Text txt_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(causality = i_causality, index = i_index) :: rest )
      equation
        txt_0 = isOutput(Tpl.emptyTxt, i_causality);
        txt = fun_497(txt, txt_0, i_index);
        txt = Tpl.nextIter(txt);
        txt = lm_498(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_498(txt, rest);
      then txt;
  end matchcontinue;
end lm_498;

protected function fun_499
  input Tpl.Text in_txt;
  input Tpl.Text in_mArg;
  input Integer in_a_index;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_index, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer a_index;
      SimCode.ModelInfo a_modelInfo;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_index,
           a_modelInfo )
      equation
        txt = numAlgvar(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(a_index));
      then txt;
  end matchcontinue;
end fun_499;

protected function lm_500
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.ModelInfo a_modelInfo;
      Integer i_index;
      SimCode.Causality i_causality;
      Tpl.Text txt_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(causality = i_causality, index = i_index) :: rest,
           a_modelInfo )
      equation
        txt_0 = isOutput(Tpl.emptyTxt, i_causality);
        txt = fun_499(txt, txt_0, i_index, a_modelInfo);
        txt = Tpl.nextIter(txt);
        txt = lm_500(txt, rest, a_modelInfo);
      then txt;

    case ( txt,
           _ :: rest,
           a_modelInfo )
      equation
        txt = lm_500(txt, rest, a_modelInfo);
      then txt;
  end matchcontinue;
end lm_500;

protected function fun_501
  input Tpl.Text in_txt;
  input Tpl.Text in_mArg;
  input Integer in_a_index;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_index, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer a_index;
      SimCode.ModelInfo a_modelInfo;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_index,
           a_modelInfo )
      equation
        txt = numAlgvar(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numIntAlgvar(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(a_index));
      then txt;
  end matchcontinue;
end fun_501;

protected function lm_502
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.ModelInfo a_modelInfo;
      Integer i_index;
      SimCode.Causality i_causality;
      Tpl.Text txt_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(causality = i_causality, index = i_index) :: rest,
           a_modelInfo )
      equation
        txt_0 = isOutput(Tpl.emptyTxt, i_causality);
        txt = fun_501(txt, txt_0, i_index, a_modelInfo);
        txt = Tpl.nextIter(txt);
        txt = lm_502(txt, rest, a_modelInfo);
      then txt;

    case ( txt,
           _ :: rest,
           a_modelInfo )
      equation
        txt = lm_502(txt, rest, a_modelInfo);
      then txt;
  end matchcontinue;
end lm_502;

protected function fun_503
  input Tpl.Text in_txt;
  input Tpl.Text in_mArg;
  input Integer in_a_index;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_index, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer a_index;
      SimCode.ModelInfo a_modelInfo;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_index,
           a_modelInfo )
      equation
        txt = numAlgvars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(a_index));
      then txt;
  end matchcontinue;
end fun_503;

protected function lm_504
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.ModelInfo a_modelInfo;
      Integer i_index;
      SimCode.Causality i_causality;
      Tpl.Text txt_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(causality = i_causality, index = i_index) :: rest,
           a_modelInfo )
      equation
        txt_0 = isOutput(Tpl.emptyTxt, i_causality);
        txt = fun_503(txt, txt_0, i_index, a_modelInfo);
        txt = Tpl.nextIter(txt);
        txt = lm_504(txt, rest, a_modelInfo);
      then txt;

    case ( txt,
           _ :: rest,
           a_modelInfo )
      equation
        txt = lm_504(txt, rest, a_modelInfo);
      then txt;
  end matchcontinue;
end lm_504;

protected function fun_505
  input Tpl.Text in_txt;
  input Tpl.Text in_mArg;
  input Integer in_a_index;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_index, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer a_index;
      SimCode.ModelInfo a_modelInfo;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_index,
           a_modelInfo )
      equation
        txt = numAlgvars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numStatevars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(a_index));
      then txt;
  end matchcontinue;
end fun_505;

protected function lm_506
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.ModelInfo a_modelInfo;
      Integer i_index;
      SimCode.Causality i_causality;
      Tpl.Text txt_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(causality = i_causality, index = i_index) :: rest,
           a_modelInfo )
      equation
        txt_0 = isOutput(Tpl.emptyTxt, i_causality);
        txt = fun_505(txt, txt_0, i_index, a_modelInfo);
        txt = Tpl.nextIter(txt);
        txt = lm_506(txt, rest, a_modelInfo);
      then txt;

    case ( txt,
           _ :: rest,
           a_modelInfo )
      equation
        txt = lm_506(txt, rest, a_modelInfo);
      then txt;
  end matchcontinue;
end lm_506;

protected function smf_507
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_507;

protected function smf_508
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_508;

protected function smf_509
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_509;

protected function smf_510
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_510;

protected function smf_511
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_511;

protected function fun_512
  input Tpl.Text in_txt;
  input Integer in_a_varInfo_numOutVars;
  input list<SimCode.SimVar> in_a_vars_derivativeVars;
  input list<SimCode.SimVar> in_a_vars_stateVars;
  input list<SimCode.SimVar> in_a_vars_boolAlgVars;
  input SimCode.ModelInfo in_a_modelInfo;
  input list<SimCode.SimVar> in_a_vars_intAlgVars;
  input list<SimCode.SimVar> in_a_vars_algVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_varInfo_numOutVars, in_a_vars_derivativeVars, in_a_vars_stateVars, in_a_vars_boolAlgVars, in_a_modelInfo, in_a_vars_intAlgVars, in_a_vars_algVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> a_vars_derivativeVars;
      list<SimCode.SimVar> a_vars_stateVars;
      list<SimCode.SimVar> a_vars_boolAlgVars;
      SimCode.ModelInfo a_modelInfo;
      list<SimCode.SimVar> a_vars_intAlgVars;
      list<SimCode.SimVar> a_vars_algVars;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           0,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_vars_derivativeVars,
           a_vars_stateVars,
           a_vars_boolAlgVars,
           a_modelInfo,
           a_vars_intAlgVars,
           a_vars_algVars )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var_ouputs_idx+="));
        txt_0 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_0 = lm_498(txt_0, a_vars_algVars);
        txt_0 = Tpl.popIter(txt_0);
        txt_1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_1 = lm_500(txt_1, a_vars_intAlgVars, a_modelInfo);
        txt_1 = Tpl.popIter(txt_1);
        txt_2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_502(txt_2, a_vars_boolAlgVars, a_modelInfo);
        txt_2 = Tpl.popIter(txt_2);
        txt_3 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_3 = lm_504(txt_3, a_vars_stateVars, a_modelInfo);
        txt_3 = Tpl.popIter(txt_3);
        txt_4 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_4 = lm_506(txt_4, a_vars_derivativeVars, a_modelInfo);
        txt_4 = Tpl.popIter(txt_4);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_507(txt, txt_0);
        txt = smf_508(txt, txt_1);
        txt = smf_509(txt, txt_2);
        txt = smf_510(txt, txt_3);
        txt = smf_511(txt, txt_4);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_512;

public function outputIndices
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      SimCode.ModelInfo i_modelInfo;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      Integer i_varInfo_numOutVars;

    case ( txt,
           (i_modelInfo as SimCode.MODELINFO(varInfo = SimCode.VARINFO(numOutVars = i_varInfo_numOutVars), vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars))) )
      equation
        txt = fun_512(txt, i_varInfo_numOutVars, i_vars_derivativeVars, i_vars_stateVars, i_vars_boolAlgVars, i_modelInfo, i_vars_intAlgVars, i_vars_algVars);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end outputIndices;

public function isOutput
  input Tpl.Text in_txt;
  input SimCode.Causality in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_c)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.OUTPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end isOutput;

protected function fun_515
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_sv_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_simCode, in_a_sv_name)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_sv_name;
      String i_vStr;

    case ( txt,
           (i_vStr as "0"),
           a_simCode,
           a_sv_name )
      equation
        txt = cref1(txt, a_sv_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";//"));
        txt = cref(txt, a_sv_name);
      then txt;

    case ( txt,
           (i_vStr as "0.0"),
           a_simCode,
           a_sv_name )
      equation
        txt = cref1(txt, a_sv_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";//"));
        txt = cref(txt, a_sv_name);
      then txt;

    case ( txt,
           (i_vStr as "(0)"),
           a_simCode,
           a_sv_name )
      equation
        txt = cref1(txt, a_sv_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";//"));
        txt = cref(txt, a_sv_name);
      then txt;

    case ( txt,
           "",
           a_simCode,
           a_sv_name )
      equation
        txt = cref1(txt, a_sv_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=0;//"));
        txt = cref(txt, a_sv_name);
      then txt;

    case ( txt,
           i_vStr,
           a_simCode,
           a_sv_name )
      equation
        txt = cref1(txt, a_sv_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";//"));
        txt = cref(txt, a_sv_name);
      then txt;
  end matchcontinue;
end fun_515;

protected function fun_516
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input DAE.ComponentRef in_a_sv_name;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_initialValue, in_a_sv_name, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_sv_name;
      SimCode.SimCode a_simCode;
      DAE.Exp i_v;
      String str_3;
      Tpl.Text txt_2;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;

    case ( txt,
           SOME(i_v),
           a_sv_name,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        (txt_2, l_preExp, l_varDecls) = daeExp(Tpl.emptyTxt, i_v, SimCode.contextOther, l_preExp, l_varDecls, a_simCode);
        str_3 = Tpl.textString(txt_2);
        txt = fun_515(txt, str_3, a_simCode, a_sv_name);
      then txt;

    case ( txt,
           _,
           a_sv_name,
           a_simCode )
      equation
        txt = cref1(txt, a_sv_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=0;"));
      then txt;
  end matchcontinue;
end fun_516;

protected function lm_517
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_sv_name;
      Option<DAE.Exp> i_initialValue;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(initialValue = i_initialValue, name = i_sv_name) :: rest,
           a_simCode )
      equation
        txt = fun_516(txt, i_initialValue, i_sv_name, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_517(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_517(txt, rest, a_simCode);
      then txt;
  end matchcontinue;
end lm_517;

public function initValst
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_517(out_txt, a_varsLst, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end initValst;

public function eventHandlingInit
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for(int i=0;i<="));
        txt = helpvarlength(txt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";++i) { handleEvent(i); }"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end eventHandlingInit;

protected function fun_520
  input Tpl.Text in_txt;
  input Option<Integer> in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer i_val;

    case ( txt,
           SOME(i_val) )
      equation
        txt = Tpl.writeStr(txt, intString(i_val));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_520;

protected function fun_521
  input Tpl.Text in_txt;
  input Option<Integer> in_a_dimODE1stOrder;
  input Option<Integer> in_a_vi_dimODE1stOrder;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dimODE1stOrder, in_a_vi_dimODE1stOrder)
    local
      Tpl.Text txt;
      Option<Integer> a_vi_dimODE1stOrder;

    case ( txt,
           SOME(_),
           a_vi_dimODE1stOrder )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimODE1stOrder = "));
        txt = fun_520(txt, a_vi_dimODE1stOrder);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_521;

protected function smf_522
  input Tpl.Text in_txt;
  input SimCode.VarInfo in_it;
  input Option<Integer> in_a_vi_dimODE1stOrder;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it, in_a_vi_dimODE1stOrder)
    local
      Tpl.Text txt;
      Option<Integer> a_vi_dimODE1stOrder;
      Option<Integer> i_dimODE1stOrder;

    case ( txt,
           SimCode.VARINFO(dimODE1stOrder = i_dimODE1stOrder),
           a_vi_dimODE1stOrder )
      equation
        txt = fun_521(txt, i_dimODE1stOrder, a_vi_dimODE1stOrder);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end smf_522;

protected function fun_523
  input Tpl.Text in_txt;
  input Option<Integer> in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer i_val;

    case ( txt,
           SOME(i_val) )
      equation
        txt = Tpl.writeStr(txt, intString(i_val));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_523;

protected function fun_524
  input Tpl.Text in_txt;
  input Option<Integer> in_a_dimODE2ndOrder;
  input Option<Integer> in_a_vi_dimODE2ndOrder;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dimODE2ndOrder, in_a_vi_dimODE2ndOrder)
    local
      Tpl.Text txt;
      Option<Integer> a_vi_dimODE2ndOrder;

    case ( txt,
           SOME(_),
           a_vi_dimODE2ndOrder )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimODE2ndOrder = "));
        txt = fun_523(txt, a_vi_dimODE2ndOrder);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_524;

protected function smf_525
  input Tpl.Text in_txt;
  input SimCode.VarInfo in_it;
  input Option<Integer> in_a_vi_dimODE2ndOrder;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it, in_a_vi_dimODE2ndOrder)
    local
      Tpl.Text txt;
      Option<Integer> a_vi_dimODE2ndOrder;
      Option<Integer> i_dimODE2ndOrder;

    case ( txt,
           SimCode.VARINFO(dimODE2ndOrder = i_dimODE2ndOrder),
           a_vi_dimODE2ndOrder )
      equation
        txt = fun_524(txt, i_dimODE2ndOrder, a_vi_dimODE2ndOrder);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end smf_525;

public function dimension1
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Option<Integer> i_vi_dimODE2ndOrder;
      Option<Integer> i_vi_dimODE1stOrder;
      SimCode.VarInfo i_modelInfo_varInfo;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = (i_modelInfo_varInfo as SimCode.VARINFO(dimODE1stOrder = i_vi_dimODE1stOrder, dimODE2ndOrder = i_vi_dimODE2ndOrder)))) )
      equation
        txt = smf_522(txt, i_modelInfo_varInfo, i_vi_dimODE1stOrder);
        txt = Tpl.softNewLine(txt);
        txt = smf_525(txt, i_modelInfo_varInfo, i_vi_dimODE2ndOrder);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dimension1;

public function isODE
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Integer i_vi_numStateVars;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_vi_numStateVars), name = i_modelInfo_name)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("::isODE()\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = Tpl.writeStr(txt, intString(i_vi_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">0 ;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" }"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end isODE;

protected function fun_528
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = arrayCrefStr(txt, a_cr);
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = arrayCrefCStr(txt, a_cr);
      then txt;
  end matchcontinue;
end fun_528;

public function contextArrayCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_528(txt, a_context, a_cr);
end contextArrayCref;

public function arrayCrefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = arrayCrefStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end arrayCrefStr;

protected function fun_531
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;
      ClassInf.State i_complexClassType;
      Absyn.Path ret_0;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_complexClassType) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        ret_0 = ClassInf.getStateName(i_complexClassType);
        txt = underscorePath(txt, ret_0);
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;
  end matchcontinue;
end fun_531;

protected function fun_532
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _))) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = fun_531(txt, i_ty);
      then txt;
  end matchcontinue;
end fun_532;

protected function fun_533
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = expTypeFlag(txt, i_ty, 2);
      then txt;
  end matchcontinue;
end fun_533;

protected function fun_534
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;
      DAE.Type i_ty;
      Integer ret_0;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims, ty = i_ty) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array_ref<"));
        txt = expTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_dims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = expTypeFlag(txt, i_ty, 2);
      then txt;
  end matchcontinue;
end fun_534;

protected function fun_535
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;
      DAE.Type i_ty;
      Integer ret_0;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims, ty = i_ty) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = expTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_dims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = expTypeFlag(txt, i_ty, 2);
      then txt;
  end matchcontinue;
end fun_535;

protected function fun_536
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;
      DAE.Type i_ty;
      Integer ret_0;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims, ty = i_ty) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = expTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_dims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_536;

protected function fun_537
  input Tpl.Text in_txt;
  input Integer in_a_flag;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_flag, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;

    case ( txt,
           1,
           a_ty )
      equation
        txt = expTypeShort(txt, a_ty);
      then txt;

    case ( txt,
           2,
           a_ty )
      equation
        txt = fun_532(txt, a_ty);
      then txt;

    case ( txt,
           3,
           a_ty )
      equation
        txt = expTypeShort(txt, a_ty);
      then txt;

    case ( txt,
           4,
           a_ty )
      equation
        txt = fun_533(txt, a_ty);
      then txt;

    case ( txt,
           5,
           a_ty )
      equation
        txt = fun_534(txt, a_ty);
      then txt;

    case ( txt,
           6,
           a_ty )
      equation
        txt = fun_535(txt, a_ty);
      then txt;

    case ( txt,
           7,
           a_ty )
      equation
        txt = fun_536(txt, a_ty);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_537;

public function expTypeFlag
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input Integer a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_537(txt, a_flag, a_ty);
end expTypeFlag;

public function expTypeArray
  input Tpl.Text txt;
  input DAE.Type a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFlag(txt, a_ty, 3);
end expTypeArray;

public function expTypeArrayforDim
  input Tpl.Text txt;
  input DAE.Type a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFlag(txt, a_ty, 6);
end expTypeArrayforDim;

protected function fun_541
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;
  end matchcontinue;
end fun_541;

public function expTypeShort
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type)
    local
      Tpl.Text txt;
      ClassInf.State i_complexClassType;
      DAE.Type i_ty;
      Absyn.Path ret_1;
      Boolean ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        txt = fun_541(txt, ret_0);
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_UNKNOWN(source = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("complex"));
      then txt;

    case ( txt,
           DAE.T_ANYTYPE(anyClassType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("complex"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("complex"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_complexClassType) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        ret_1 = ClassInf.getStateName(i_complexClassType);
        txt = underscorePath(txt, ret_1);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fnptr"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expTypeShort:ERROR"));
      then txt;
  end matchcontinue;
end expTypeShort;

public function dimension
  input Tpl.Text in_txt;
  input DAE.Dimension in_a_d;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_d)
    local
      Tpl.Text txt;
      Integer i_size;
      Integer i_integer;

    case ( txt,
           DAE.DIM_INTEGER(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.DIM_ENUM(size = i_size) )
      equation
        txt = Tpl.writeStr(txt, intString(i_size));
      then txt;

    case ( txt,
           DAE.DIM_UNKNOWN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("INVALID_DIMENSION"));
      then txt;
  end matchcontinue;
end dimension;

public function arrayCrefCStr
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("_"));
  out_txt := arrayCrefCStr2(out_txt, a_cr);
end arrayCrefCStr;

public function arrayCrefCStr2
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_P_"));
        txt = arrayCrefCStr2(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end arrayCrefCStr2;

public function underscorePath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end underscorePath;

public function replaceDotAndUnderscore
  input Tpl.Text in_txt;
  input String in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_str)
    local
      Tpl.Text txt;
      String i_name;
      String ret_3;
      Tpl.Text l_str__underscores;
      String ret_1;
      Tpl.Text l_str__dots;

    case ( txt,
           i_name )
      equation
        ret_1 = System.stringReplace(i_name, ".", "_");
        l_str__dots = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_3 = System.stringReplace(Tpl.textString(l_str__dots), "_", "__");
        l_str__underscores = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        txt = Tpl.writeText(txt, l_str__underscores);
      then txt;
  end matchcontinue;
end replaceDotAndUnderscore;

public function tempDecl
  input Tpl.Text txt;
  input String a_ty;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Integer ret_1;
  Tpl.Text l_newVar;
algorithm
  l_newVar := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("tmp"));
  ret_1 := System.tmpTick();
  l_newVar := Tpl.writeStr(l_newVar, intString(ret_1));
  out_a_varDecls := Tpl.writeStr(a_varDecls, a_ty);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(" "));
  out_a_varDecls := Tpl.writeText(out_a_varDecls, l_newVar);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(";"));
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_newVar);
end tempDecl;

protected function fun_549
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_cr, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      SimCode.SimCode a_simCode;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr,
           _ )
      equation
        txt = crefStr(txt, a_cr);
      then txt;

    case ( txt,
           _,
           a_cr,
           a_simCode )
      equation
        txt = cref1(txt, a_cr, a_simCode);
      then txt;
  end matchcontinue;
end fun_549;

public function contextCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_549(txt, a_context, a_cr, a_simCode);
end contextCref;

protected function fun_551
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = crefStr(txt, a_cr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_551;

public function contextCref2
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_551(txt, a_context, a_cr);
end contextCref2;

public function crefFunctionName
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        ret_1 = System.stringReplace(ret_0, "_", "__");
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        ret_2 = System.unquoteIdentifier(i_ident);
        ret_3 = System.stringReplace(ret_2, "_", "__");
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefFunctionName(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end crefFunctionName;

protected function lm_554
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_554(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_554(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_554;

public function functionInitial
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_startValueEquations;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_eqPart;
algorithm
  l_eqPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqPart, out_a_varDecls) := lm_554(l_eqPart, a_startValueEquations, a_simCode, a_varDecls);
  l_eqPart := Tpl.popIter(l_eqPart);
  out_txt := Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_eqPart);
  out_txt := Tpl.popBlock(out_txt);
end functionInitial;

public function equation_
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Integer i_index;
      SimCode.SimEqSystem i_e;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(cref = _)),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = equationSimpleAssign(txt, i_e, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = _)),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = equationAlgorithm(txt, i_e, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_WHEN(left = _)),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = equationWhen(txt, i_e, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = _)),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = equationArrayCallAssign(txt, i_e, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    " if(!(command & IContinous::RANKING))\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if(_algLoopSolver"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") _algLoopSolver"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("->solve(command);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else _algLoop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->init();\n",
                                    "//if(_algLoopSolver"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") _algLoopSolver"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->solve(command);\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    " if(!(command & IContinous::RANKING))\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if(_algLoopSolver"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") _algLoopSolver"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("->solve(command);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else _algLoop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->init();\n",
                                    "//if(_algLoopSolver"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") _algLoopSolver"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->solve(command);\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        (txt, a_varDecls) = equationMixed(txt, i_e, a_context, a_varDecls, a_simCode);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION"));
      then (txt, a_varDecls);
  end matchcontinue;
end equation_;

protected function lm_557
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_num;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preDisc;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preDisc;
algorithm
  (out_txt, out_a_varDecls, out_a_preDisc) :=
  matchcontinue(in_txt, in_items, in_a_num, in_a_simCode, in_a_varDecls, in_a_preDisc, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_num;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preDisc;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           a_preDisc,
           _ )
      then (txt, a_varDecls, a_preDisc);

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref) :: rest,
           a_num,
           a_simCode,
           a_varDecls,
           a_preDisc,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_expPart, a_preDisc, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preDisc, a_varDecls, a_simCode);
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "new_disc_vars"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preDisc) = lm_557(txt, rest, a_num, a_simCode, a_varDecls, a_preDisc, a_context);
      then (txt, a_varDecls, a_preDisc);

    case ( txt,
           _ :: rest,
           a_num,
           a_simCode,
           a_varDecls,
           a_preDisc,
           a_context )
      equation
        (txt, a_varDecls, a_preDisc) = lm_557(txt, rest, a_num, a_simCode, a_varDecls, a_preDisc, a_context);
      then (txt, a_varDecls, a_preDisc);
  end matchcontinue;
end lm_557;

protected function lm_558
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
        txt = lm_558(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_558(txt, rest);
      then txt;
  end matchcontinue;
end lm_558;

protected function lm_559
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_num)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_num;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_num )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pre_disc_vars"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_559(txt, rest, a_num);
      then txt;

    case ( txt,
           _ :: rest,
           a_num )
      equation
        txt = lm_559(txt, rest, a_num);
      then txt;
  end matchcontinue;
end lm_559;

protected function lm_560
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = cref(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_560(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_560(txt, rest);
      then txt;
  end matchcontinue;
end lm_560;

public function equationMixed
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> i_discEqs;
      Integer i_index;
      list<Integer> i_values;
      list<SimCode.SimVar> i_discVars;
      SimCode.SimEqSystem i_cont;
      Tpl.Text l_discvars2;
      Tpl.Text l_num;
      Tpl.Text l_preDisc;
      Integer ret_4;
      Tpl.Text l_valuesLenStr;
      Integer ret_2;
      Tpl.Text l_numDiscVarsStr;
      Tpl.Text l_contEqs;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont, discVars = i_discVars, values = i_values, index = i_index, discEqs = i_discEqs),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (l_contEqs, a_varDecls) = equation_(Tpl.emptyTxt, i_cont, a_context, a_varDecls, a_simCode);
        ret_2 = listLength(i_discVars);
        l_numDiscVarsStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        ret_4 = listLength(i_values);
        l_valuesLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        l_preDisc = Tpl.emptyTxt;
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        l_discvars2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_discvars2, a_varDecls, l_preDisc) = lm_557(l_discvars2, i_discEqs, l_num, a_simCode, a_varDecls, l_preDisc, a_context);
        l_discvars2 = Tpl.popIter(l_discvars2);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool values"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_valuesLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_558(txt, i_values);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "bool pre_disc_vars"
                                }, false));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "];\n",
                                    "bool new_disc_vars"
                                }, false));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "];\n",
                                    "bool restart"
                                }, false));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " = true;\n",
                                    "int iter"
                                }, false));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "=0;\n",
                                    "int max_iter"
                                }, false));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = Tpl.writeText(txt, l_valuesLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" / "));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")+1;\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("while(restart"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !(iter"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > max_iter"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "))\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_559(txt, i_discVars, l_num);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_contEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" checkConditions(0,true);\n"));
        txt = Tpl.writeText(txt, l_preDisc);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_discvars2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool* cur_disc_vars"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]= {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_560(txt, i_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("};\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restart"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=!(_event_handling.CheckDiscreteValues(values"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",pre_disc_vars"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",new_disc_vars"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",cur_disc_vars"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",iter"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_valuesLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "));\n",
                                    "iter"
                                }, false));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("++;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  }\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if(iter"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">max_iter"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && (restart"));
        txt = Tpl.writeText(txt, l_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " == true) )\n",
                                    "{\n",
                                    "    //throw std::runtime_error(\"Number of iteration steps exceeded for discrete varibales check . \");\n",
                                    "    cout << \"Number of iteration steps exceeded for discrete varibales check at time \" << time << std::endl;\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end equationMixed;

protected function lm_562
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = generateAlgloopsolvers2(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_562(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_562(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_562;

protected function lm_563
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_562(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_563(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_563(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_563;

public function generateAlgloopsolvers
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_continousEquations;
  input list<SimCode.SimEqSystem> a_discreteEquations;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_563(l_algloopsolver, a_continousEquations, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE(" _algLoopSolverFactory = boost::shared_ptr<IAlgLoopSolverFactory>(iter->second.create());\n"));
  out_txt := Tpl.writeText(out_txt, l_algloopsolver);
end generateAlgloopsolvers;

protected function fun_565
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name))),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" =  boost::shared_ptr<"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">(new "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(144));
        txt = CallAlgloopParams(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",_z,_zDot,_event_handling\n",
                                    ")\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "                                                                                                                                );\n",
                                    "_algLoopSolver"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = boost::shared_ptr<IAlgLoopSolver>(_algLoopSolverFactory->createAlgLoopSolver(_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".get()));"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_565;

protected function fun_566
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name))),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" =  boost::shared_ptr<"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">(new "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(144));
        txt = CallAlgloopParams(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",_z,_zDot,_event_handling\n",
                                    ")\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "                                                                                                                                );\n",
                                    "_algLoopSolver"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = boost::shared_ptr<IAlgLoopSolver>(_algLoopSolverFactory->createAlgLoopSolver(_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".get()));"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_566;

public function generateAlgloopsolvers2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_565(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_566(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = generateAlgloopsolvers2(txt, i_eq__sys, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end generateAlgloopsolvers2;

protected function lm_568
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = generateAlgloopsolverVariables2(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_568(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_568(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_568;

protected function lm_569
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_568(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_569(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_569(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_569;

public function generateAlgloopsolverVariables
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_continousEquations;
  input list<SimCode.SimEqSystem> a_discreteEquations;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_569(l_algloopsolver, a_continousEquations, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.writeText(txt, l_algloopsolver);
end generateAlgloopsolverVariables;

protected function fun_571
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::shared_ptr<"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">  //Algloop  which holds equation system\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  boost::shared_ptr<IAlgLoopSolver>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";        ///< Solver for algebraic loop */"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_571;

protected function fun_572
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::shared_ptr<"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">  //Algloop  which holds equation system\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  boost::shared_ptr<IAlgLoopSolver>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";        ///< Solver for algebraic loop */"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_572;

public function generateAlgloopsolverVariables2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_571(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_572(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = generateAlgloopsolverVariables2(txt, i_eq__sys, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end generateAlgloopsolverVariables2;

protected function lm_574
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = initAlgloopsolvers2(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
        (txt, a_varDecls) = lm_574(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_574(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_574;

protected function lm_575
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_574(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_575(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_575(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_575;

public function initAlgloopsolvers
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_continousEquations;
  input list<SimCode.SimEqSystem> a_discreteEquations;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_575(l_algloopsolver, a_continousEquations, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.writeText(txt, l_algloopsolver);
end initAlgloopsolvers;

protected function fun_577
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    // Initialize the solver\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if(_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->init();"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_577;

protected function fun_578
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    // Initialize the solver\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if(_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->init();"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_578;

public function initAlgloopsolvers2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_577(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_578(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = initAlgloopsolvers2(txt, i_eq__sys, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls);
  end matchcontinue;
end initAlgloopsolvers2;

protected function lm_580
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = algloopfilesInclude2(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_580(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_580(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_580;

protected function lm_581
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_580(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_581(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_581(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_581;

public function algloopfilesInclude
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_continousEquations;
  input list<SimCode.SimEqSystem> a_discreteEquations;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, l_varDecls) := lm_581(out_txt, a_continousEquations, a_simCode, l_varDecls);
  out_txt := Tpl.popIter(out_txt);
end algloopfilesInclude;

protected function fun_583
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".h \""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_583;

protected function fun_584
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".h \""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_584;

public function algloopfilesInclude2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_583(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_584(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = algloopfilesInclude2(txt, i_eq__sys, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end algloopfilesInclude2;

protected function lm_586
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = algloopfiles2(txt, i_eqs, SimCode.contextOther, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_586(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_586(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_586;

public function algloopfiles
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_586(l_algloopsolver, a_allEquations, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.writeText(txt, l_algloopsolver);
end algloopfiles;

protected function fun_588
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num, in_a_eq)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      SimCode.SimEqSystem a_eq;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_num,
           a_eq )
      equation
        txt_0 = algloopHeaderFile(Tpl.emptyTxt, i_simCode, a_eq);
        txt_1 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("Algloop"));
        txt_1 = Tpl.writeText(txt_1, a_num);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
        txt_2 = algloopCppFile(Tpl.emptyTxt, i_simCode, a_eq);
        txt_3 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("Algloop"));
        txt_3 = Tpl.writeText(txt_3, a_num);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING(".cpp"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_588;

protected function fun_589
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num, in_a_eq)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      SimCode.SimEqSystem a_eq;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_num,
           a_eq )
      equation
        txt_0 = algloopHeaderFile(Tpl.emptyTxt, i_simCode, a_eq);
        txt_1 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("Algloop"));
        txt_1 = Tpl.writeText(txt_1, a_num);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
        txt_2 = algloopCppFile(Tpl.emptyTxt, i_simCode, a_eq);
        txt_3 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("Algloop"));
        txt_3 = Tpl.writeText(txt_3, a_num);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING(".cpp"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_589;

protected function fun_590
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;
  input SimCode.SimEqSystem in_a_eq__sys;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num, in_a_eq__sys)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      SimCode.SimEqSystem a_eq__sys;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_num,
           a_eq__sys )
      equation
        txt_0 = algloopHeaderFile(Tpl.emptyTxt, i_simCode, a_eq__sys);
        txt_1 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("Algloop"));
        txt_1 = Tpl.writeText(txt_1, a_num);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
        txt_2 = algloopCppFile(Tpl.emptyTxt, i_simCode, a_eq__sys);
        txt_3 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("Algloop"));
        txt_3 = Tpl.writeText(txt_3, a_num);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING(".cpp"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_590;

protected function fun_591
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      SimCode.SimEqSystem i_e;
      SimCode.SimEqSystem i_eq;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_588(txt, a_simCode, l_num, i_eq);
      then txt;

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(index = i_index)),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_589(txt, a_simCode, l_num, i_e);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys, index = i_index),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_590(txt, a_simCode, l_num, i_eq__sys);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end matchcontinue;
end fun_591;

public function algloopfiles2
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_591(txt, a_eq, a_simCode);
  out_a_varDecls := a_varDecls;
end algloopfiles2;

protected function lm_593
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = algloopcppfilenames2(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
        (txt, a_varDecls) = lm_593(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_593(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_593;

protected function lm_594
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_593(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_594(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_594(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_594;

public function algloopcppfilenames
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_continousEquations;
  input list<SimCode.SimEqSystem> a_discreteEquations;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_594(l_algloopsolver, a_continousEquations, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.writeText(txt, l_algloopsolver);
end algloopcppfilenames;

protected function fun_596
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".cpp"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_596;

protected function fun_597
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".cpp"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_597;

public function algloopcppfilenames2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_596(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_597(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = algloopcppfilenames2(txt, i_eq__sys, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls);
  end matchcontinue;
end algloopcppfilenames2;

protected function fun_599
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_expPart;
  input DAE.ComponentRef in_a_eqn_componentRef;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_expPart, in_a_eqn_componentRef, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_expPart;
      DAE.ComponentRef a_eqn_componentRef;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Tpl.Text l_tvar;

    case ( txt,
           "boolean",
           a_expPart,
           a_eqn_componentRef,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "boolean_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           "int",
           a_expPart,
           a_eqn_componentRef,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "integer_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           "double",
           a_expPart,
           a_eqn_componentRef,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_599;

public function equationArrayCallAssign
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_eqn_componentRef;
      DAE.Exp i_eqn_exp;
      DAE.Exp i_exp;
      String str_3;
      Tpl.Text txt_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(exp = (i_eqn_exp as i_exp), componentRef = i_eqn_componentRef),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        txt_2 = expTypeFromExpShort(Tpl.emptyTxt, i_eqn_exp);
        str_3 = Tpl.textString(txt_2);
        (txt, a_varDecls) = fun_599(txt, str_3, l_expPart, i_eqn_componentRef, l_preExp, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end equationArrayCallAssign;

protected function fun_601
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_c;
  input String in_a_arr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_c, in_a_arr)
    local
      Tpl.Text txt;
      String a_arr;
      DAE.ComponentRef i_c;

    case ( txt,
           (i_c as DAE.CREF_QUAL(ident = "$DER")),
           a_arr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "inline_integrate_array(size_of_dimension_real_array("
                                }, false));
        txt = Tpl.writeStr(txt, a_arr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",1),"));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_601;

public function inlineArray
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input String in_a_arr;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_arr, in_a_c)
    local
      Tpl.Text txt;
      String a_arr;
      DAE.ComponentRef a_c;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_arr,
           a_c )
      equation
        txt = fun_601(txt, a_c, a_arr);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end inlineArray;

protected function lm_603
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.edge(_event_handling["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("],\"h"));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\")"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_603(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_603(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_603;

public function equationWhen
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_left;
      DAE.Exp i_right;
      list<tuple<DAE.Exp, Integer>> i_conditions;
      Tpl.Text l_rightExp;
      Tpl.Text l_preExp2;
      Tpl.Text l_helpIf;
      Tpl.Text l_helpInits;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_WHEN(conditions = i_conditions, right = i_right, left = i_left),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("||")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, a_varDecls, l_preExp) = lm_603(l_helpIf, i_conditions, a_simCode, a_varDecls, l_preExp, a_context);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_rightExp, l_preExp2, a_varDecls) = daeExp(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_helpInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp2);
        txt = Tpl.softNewLine(txt);
        txt = cref1(txt, i_left, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rightExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_equation"));
      then (txt, a_varDecls);
  end matchcontinue;
end equationWhen;

protected function lm_605
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Integer x_i0;
      SimCode.SimWhenClause i_when;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_when :: rest,
           a_simCode,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = helpvarvector1(txt, i_when, SimCode.contextOther, a_varDecls, x_i0, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_605(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_605(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_605;

public function helpvarvector
  input Tpl.Text txt;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_reinit;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_reinit := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_reinit, l_varDecls) := lm_605(l_reinit, a_whenClauses, a_simCode, l_varDecls);
  l_reinit := Tpl.popIter(l_reinit);
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_reinit);
  out_txt := Tpl.popBlock(out_txt);
end helpvarvector;

protected function lm_607
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("h["));
        a_preExp = Tpl.writeStr(a_preExp, intString(i_hidx));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("]="));
        a_preExp = Tpl.writeText(a_preExp, l_helpInit);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_607(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_607(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_607;

protected function fun_608
  input Tpl.Text in_txt;
  input SimCode.SimWhenClause in_a_whenClauses;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_whenClauses, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<tuple<DAE.Exp, Integer>> i_conditions;
      Tpl.Text l_helpIf;
      Tpl.Text l_helpInits;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(conditions = i_conditions),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, a_varDecls, l_preExp) = lm_607(l_helpIf, i_conditions, a_simCode, a_varDecls, l_preExp, a_context);
        l_helpIf = Tpl.popIter(l_helpIf);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_608;

public function helpvarvector1
  input Tpl.Text txt;
  input SimCode.SimWhenClause a_whenClauses;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Integer a_int;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_608(txt, a_whenClauses, a_context, a_varDecls, a_simCode);
end helpvarvector1;

protected function fun_610
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<SimCode.SimWhenClause> i_whenClauses;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), whenClauses = i_whenClauses)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::resetHelpVar(const int index)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = resethelpvar2(txt, i_whenClauses, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_610;

public function resethelpvar
  input Tpl.Text txt;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_610(txt, a_simCode);
end resethelpvar;

protected function lm_612
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Integer x_i0;
      SimCode.SimWhenClause i_when;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_when :: rest,
           a_simCode,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = resethelpvar1(txt, i_when, SimCode.contextOther, a_varDecls, x_i0, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_612(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_612(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_612;

public function resethelpvar2
  input Tpl.Text txt;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_reinit;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_reinit := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_reinit, l_varDecls) := lm_612(l_reinit, a_whenClauses, a_simCode, l_varDecls);
  l_reinit := Tpl.popIter(l_reinit);
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_reinit);
  out_txt := Tpl.popBlock(out_txt);
end resethelpvar2;

protected function lm_614
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if(index=="));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.setHelpVar("));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_helpInit);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("   "));
        txt = Tpl.popBlock(txt);
        (txt, a_varDecls, a_preExp) = lm_614(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_614(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_614;

protected function fun_615
  input Tpl.Text in_txt;
  input SimCode.SimWhenClause in_a_whenClauses;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_whenClauses, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<tuple<DAE.Exp, Integer>> i_conditions;
      Tpl.Text l_helpIf;
      Tpl.Text l_helpInits;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(conditions = i_conditions),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        (l_helpIf, a_varDecls, l_preExp) = lm_614(Tpl.emptyTxt, i_conditions, a_simCode, a_varDecls, l_preExp, a_context);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_615;

public function resethelpvar1
  input Tpl.Text txt;
  input SimCode.SimWhenClause a_whenClauses;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Integer a_int;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_615(txt, a_whenClauses, a_context, a_varDecls, a_simCode);
end resethelpvar1;

public function preCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("pre"));
  out_txt := representationCref(out_txt, a_cr, a_simCode);
end preCref;

public function equationSimpleAssign
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref1(txt, i_cref, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end equationSimpleAssign;

protected function fun_619
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(0)"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1)"));
      then txt;
  end matchcontinue;
end fun_619;

public function daeExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Exp i_expElse;
      DAE.Exp i_expThen;
      DAE.Exp i_expCond;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      DAE.Operator i_operator;
      String i_string;
      DAE.Exp i_e;
      Integer i_index;
      Boolean i_bool;
      Real i_real;
      Integer i_integer;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.RCONST(real = i_real),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.BCONST(bool = i_bool),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = fun_619(txt, i_bool);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CREF(componentRef = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CAST(ty = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCast(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CONS(car = _),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Cons not supported yet"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SCONST(string = i_string),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSconst(txt, i_string, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.UNARY(operator = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnary(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LBINARY(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpLbinary(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LUNARY(operator = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpLunary(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.BINARY(operator = i_operator, exp1 = i_exp1, exp2 = i_exp2),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpBinary(txt, i_operator, i_exp1, i_exp2, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.IFEXP(expCond = i_expCond, expThen = i_expThen, expElse = i_expElse),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpIf(txt, i_expCond, i_expThen, i_expElse, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.RELATION(operator = i_operator, index = i_index, exp1 = i_exp1, exp2 = i_exp2),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRelation(txt, i_operator, i_index, i_exp1, i_exp2, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CALL(path = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCall(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.ASUB(exp = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpAsub(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.MATRIX(ty = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMatrix(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.RANGE(ty = _),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Range not supported yet"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = _),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Asub not supported yet"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.TSUB(exp = _),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Tsub not supported yet"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.REDUCTION(reductionInfo = _),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Reduction not supported yet"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.ARRAY(ty = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpArray(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.SIZE(exp = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSize(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SHARED_LITERAL(index = _),
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ErrorExp"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExp;

protected function fun_621
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      Integer i_exp_index;

    case ( txt,
           DAE.SHARED_LITERAL(index = i_exp_index) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"_OMC_LIT"));
        txt = Tpl.writeStr(txt, intString(i_exp_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_621;

public function daeExpSharedLiteral
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_621(txt, a_exp);
  out_a_preExp := a_preExp;
  out_a_varDecls := a_varDecls;
end daeExpSharedLiteral;

public function daeExpSize
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Type i_exp_ty;
      DAE.Exp i_dim;
      DAE.Exp i_exp;
      Tpl.Text l_typeStr;
      Tpl.Text l_resVar;
      Tpl.Text l_dimPart;
      Tpl.Text l_expPart;

    case ( txt,
           DAE.SIZE(exp = (i_exp as DAE.CREF(ty = i_exp_ty)), sz = SOME(i_dim)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        (l_dimPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_dim, a_context, a_preExp, a_varDecls, a_simCode);
        (l_resVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "size_t", a_varDecls);
        l_typeStr = expTypeArray(Tpl.emptyTxt, i_exp_ty);
        a_preExp = Tpl.writeText(a_preExp, l_resVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_expPart);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(".shape()["));
        a_preExp = Tpl.writeText(a_preExp, l_dimPart);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("-1];"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_resVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size(X) not implemented"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpSize;

protected function lm_624
  input Tpl.Text in_txt;
  input list<list<DAE.Exp>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_preExp, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<list<DAE.Exp>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      list<DAE.Exp> i_row;
      Tpl.Text l_vars;

    case ( txt,
           {},
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_row :: rest,
           a_simCode,
           a_preExp,
           a_varDecls,
           a_context )
      equation
        (l_vars, a_varDecls, a_preExp) = daeExpMatrixRow(Tpl.emptyTxt, i_row, a_context, a_varDecls, a_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_vars);
        txt = Tpl.nextIter(txt);
        (txt, a_preExp, a_varDecls) = lm_624(txt, rest, a_simCode, a_preExp, a_varDecls, a_context);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_preExp,
           a_varDecls,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = lm_624(txt, rest, a_simCode, a_preExp, a_varDecls, a_context);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end lm_624;

public function daeExpMatrix
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<list<DAE.Exp>> i_m_matrix;
      list<DAE.Exp> i_row1;
      DAE.Type i_ty;
      Integer ret_10;
      Integer ret_9;
      Tpl.Text l_params;
      Integer ret_7;
      Tpl.Text l_dim__cols;
      Tpl.Text l_vals;
      Tpl.Text l_arrayVar;
      Tpl.Text l_arrayDim;
      Tpl.Text l_tmp;
      Tpl.Text l_arrayTypeStr;
      Tpl.Text l_typestr;

    case ( txt,
           DAE.MATRIX(matrix = {{}}, ty = i_ty),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        l_typestr = expTypeArray(Tpl.emptyTxt, i_ty);
        l_arrayTypeStr = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("boost::multi_array<"));
        l_arrayTypeStr = Tpl.writeText(l_arrayTypeStr, l_typestr);
        l_arrayTypeStr = Tpl.writeTok(l_arrayTypeStr, Tpl.ST_STRING(",2>"));
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayTypeStr), a_varDecls);
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MATRIX(matrix = {}, ty = i_ty),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        l_typestr = expTypeArray(Tpl.emptyTxt, i_ty);
        l_arrayTypeStr = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("boost::multi_array<"));
        l_arrayTypeStr = Tpl.writeText(l_arrayTypeStr, l_typestr);
        l_arrayTypeStr = Tpl.writeTok(l_arrayTypeStr, Tpl.ST_STRING(",2>"));
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayTypeStr), a_varDecls);
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MATRIX(matrix = (i_m_matrix as i_row1 :: _), ty = i_ty),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_arrayTypeStr = expTypeArray(Tpl.emptyTxt, i_ty);
        l_arrayDim = expTypeArrayforDim(Tpl.emptyTxt, i_ty);
        l_tmp = Tpl.emptyTxt;
        (l_arrayVar, l_tmp) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayTypeStr), l_tmp);
        l_vals = Tpl.emptyTxt;
        ret_7 = listLength(i_row1);
        l_dim__cols = Tpl.writeStr(Tpl.emptyTxt, intString(ret_7));
        l_params = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_params, a_preExp, a_varDecls) = lm_624(l_params, i_m_matrix, a_simCode, a_preExp, a_varDecls, a_context);
        l_params = Tpl.popIter(l_params);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(5));
        a_preExp = Tpl.writeText(a_preExp, l_arrayDim);
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(boost::extents["));
        ret_9 = listLength(i_m_matrix);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_9));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("]["));
        a_preExp = Tpl.writeText(a_preExp, l_dim__cols);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("]);\n"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(".reindex(1);\n"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayTypeStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" "));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_data[]={"));
        a_preExp = Tpl.writeText(a_preExp, l_params);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("};\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(4));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(".assign("));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_data,"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_data+ ("));
        ret_10 = listLength(i_m_matrix);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_10));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" * "));
        a_preExp = Tpl.writeText(a_preExp, l_dim__cols);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("));"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, l_arrayVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpMatrix;

protected function lm_626
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_e;
      Tpl.Text l_expVar;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_e :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_expVar, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_expVar);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_626(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_626(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_626;

public function daeExpMatrixRow
  input Tpl.Text txt;
  input list<DAE.Exp> a_row;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_preExp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
protected
  Tpl.Text l_varLstStr;
algorithm
  l_varLstStr := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_varLstStr, out_a_varDecls, out_a_preExp) := lm_626(l_varLstStr, a_row, a_simCode, a_varDecls, a_preExp, a_context);
  l_varLstStr := Tpl.popIter(l_varLstStr);
  out_txt := Tpl.writeText(txt, l_varLstStr);
end daeExpMatrixRow;

protected function lm_628
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_tmpVar;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmpVar;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_tmpVar, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_tmpVar, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_tmpVar;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_e;

    case ( txt,
           {},
           _,
           a_tmpVar,
           a_preExp,
           _ )
      then (txt, a_tmpVar, a_preExp);

    case ( txt,
           i_e :: rest,
           a_simCode,
           a_tmpVar,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_tmpVar) = daeExp(txt, i_e, a_context, a_preExp, a_tmpVar, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_tmpVar, a_preExp) = lm_628(txt, rest, a_simCode, a_tmpVar, a_preExp, a_context);
      then (txt, a_tmpVar, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_tmpVar,
           a_preExp,
           a_context )
      equation
        (txt, a_tmpVar, a_preExp) = lm_628(txt, rest, a_simCode, a_tmpVar, a_preExp, a_context);
      then (txt, a_tmpVar, a_preExp);
  end matchcontinue;
end lm_628;

public function daeExpArray
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<DAE.Exp> i_array;
      DAE.Type i_ty;
      Integer ret_6;
      Integer ret_5;
      Tpl.Text l_params;
      Tpl.Text l_tmpVar;
      Tpl.Text l_arrayVar;
      Tpl.Text l_arrayDim;
      Tpl.Text l_arrayTypeStr;

    case ( txt,
           DAE.ARRAY(ty = i_ty, array = i_array),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_arrayTypeStr = expTypeArray(Tpl.emptyTxt, i_ty);
        l_arrayDim = expTypeArrayforDim(Tpl.emptyTxt, i_ty);
        (l_arrayVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayTypeStr), a_varDecls);
        l_tmpVar = Tpl.emptyTxt;
        l_params = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_params, l_tmpVar, a_preExp) = lm_628(l_params, i_array, a_simCode, l_tmpVar, a_preExp, a_context);
        l_params = Tpl.popIter(l_params);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(3));
        a_preExp = Tpl.writeText(a_preExp, l_arrayDim);
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(boost::extents["));
        ret_5 = listLength(i_array);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_5));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("]);\n"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(".reindex(1);\n"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayTypeStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" "));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_data[]={"));
        a_preExp = Tpl.writeText(a_preExp, l_params);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("};\n"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(".assign("));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_data,"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_data+"));
        ret_6 = listLength(i_array);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_6));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, l_arrayVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpArray;

protected function fun_630
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inExp;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_inExp, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_idx;
      DAE.Exp i_e;
      Tpl.Text l_idx1;
      Tpl.Text l_e1;

    case ( txt,
           DAE.ASUB(exp = i_e, sub = {i_idx}),
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        (l_idx1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_idx, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_idx1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /* DAE.ASUB */"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_630;

protected function lm_631
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_res;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_res, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_res;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Integer x_i1;
      DAE.Exp i_e;
      Tpl.Text l_v;
      Tpl.Text l_casePreExp;
      Tpl.Text l_caseVarDecls;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_e :: rest,
           a_res,
           a_simCode,
           a_context )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_caseVarDecls = Tpl.emptyTxt;
        l_casePreExp = Tpl.emptyTxt;
        (l_v, l_casePreExp, l_caseVarDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, l_casePreExp, l_caseVarDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(": {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_caseVarDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_casePreExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "break;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_631(txt, rest, a_res, a_simCode, a_context);
      then txt;

    case ( txt,
           _ :: rest,
           a_res,
           a_simCode,
           a_context )
      equation
        txt = lm_631(txt, rest, a_res, a_simCode, a_context);
      then txt;
  end matchcontinue;
end lm_631;

protected function fun_632
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input list<DAE.Exp> in_a_subs;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_arrName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_context, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_subs, in_a_ecr, in_a_arrName)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      list<DAE.Exp> a_subs;
      DAE.Exp a_ecr;
      Tpl.Text a_arrName;
      SimCode.Context i_context;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           _,
           a_varDecls,
           a_preExp,
           _,
           _,
           a_arrName )
      equation
        txt = Tpl.writeText(txt, a_arrName);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_context,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_subs,
           a_ecr,
           a_arrName )
      equation
        (txt, a_preExp, a_varDecls) = arrayScalarRhs(txt, a_ecr, a_subs, Tpl.textString(a_arrName), i_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_632;

protected function lm_633
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_index;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_index :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExpASubIndex(txt, i_index, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_633(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_633(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_633;

protected function fun_634
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inExp;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_inExp, in_a_simCode, in_a_preExp, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Exp> i_indexes;
      DAE.Exp i_e;
      list<DAE.Exp> i_subs;
      DAE.Exp i_ecr;
      list<DAE.Exp> i_exp_array;
      DAE.Exp i_idx;
      DAE.Exp i_exp;
      Tpl.Text txt_12;
      String ret_12;
      Tpl.Text l_expIndexes;
      Tpl.Text l_exp;
      DAE.Exp ret_9;
      Tpl.Text l_arrName;
      Tpl.Text txt_6;
      String ret_6;
      Tpl.Text l_expl;
      Tpl.Text l_idx1;
      Tpl.Text txt_3;
      Tpl.Text l_res;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.ASUB(exp = (i_exp as DAE.ASUB(exp = _))),
           _,
           a_preExp,
           _,
           a_varDecls )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Nested array subscripting *should* have been handled by the routine creating the asub, but for some reason it was not: "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 4138, 11), Tpl.textString(txt_0));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = (i_exp as DAE.ARRAY(scalar = true, array = i_exp_array)), sub = {i_idx}),
           a_simCode,
           a_preExp,
           a_context,
           a_varDecls )
      equation
        txt_3 = expTypeFromExpModelica(Tpl.emptyTxt, i_exp);
        (l_res, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_3), a_varDecls);
        (l_idx1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_idx, a_context, a_preExp, a_varDecls, a_simCode);
        l_expl = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_expl = lm_631(l_expl, i_exp_array, l_res, a_simCode, a_context);
        l_expl = Tpl.popIter(l_expl);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("switch ("));
        a_preExp = Tpl.writeText(a_preExp, l_idx1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(") { /* ASUB */\n"));
        a_preExp = Tpl.writeText(a_preExp, l_expl);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              "default:\n",
                                              "  assert(NULL == \"index out of bounds\");\n",
                                              "}"
                                          }, false));
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = (i_exp as DAE.RANGE(ty = _)), sub = {_}),
           _,
           a_preExp,
           _,
           a_varDecls )
      equation
        txt_6 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("ASUB_EASY_CASE "));
        ret_6 = ExpressionDump.printExpStr(i_exp);
        txt_6 = Tpl.writeStr(txt_6, ret_6);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 4167, 11), Tpl.textString(txt_6));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = (i_ecr as DAE.CREF(componentRef = _)), sub = i_subs),
           a_simCode,
           a_preExp,
           a_context,
           a_varDecls )
      equation
        ret_9 = SimCode.buildCrefExpFromAsub(i_ecr, i_subs);
        (l_arrName, a_preExp, a_varDecls) = daeExpCrefRhs(Tpl.emptyTxt, ret_9, a_context, a_preExp, a_varDecls, a_simCode);
        (txt, a_varDecls, a_preExp) = fun_632(txt, a_context, a_simCode, a_varDecls, a_preExp, i_subs, i_ecr, l_arrName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = i_e, sub = i_indexes),
           a_simCode,
           a_preExp,
           a_context,
           a_varDecls )
      equation
        (l_exp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        l_expIndexes = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_expIndexes, a_varDecls, a_preExp) = lm_633(l_expIndexes, i_indexes, a_simCode, a_varDecls, a_preExp, a_context);
        l_expIndexes = Tpl.popIter(l_expIndexes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")["));
        txt = Tpl.writeText(txt, l_expIndexes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+1]"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           _,
           a_preExp,
           _,
           a_varDecls )
      equation
        txt_12 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OTHER_ASUB "));
        ret_12 = ExpressionDump.printExpStr(i_exp);
        txt_12 = Tpl.writeStr(txt_12, ret_12);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 4185, 11), Tpl.textString(txt_12));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_634;

protected function fun_635
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_inExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_inExp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.Exp a_inExp;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;

    case ( txt,
           "metatype",
           a_inExp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls, a_preExp) = fun_630(txt, a_inExp, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_inExp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = fun_634(txt, a_inExp, a_simCode, a_preExp, a_context, a_varDecls);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_635;

public function daeExpAsub
  input Tpl.Text txt;
  input DAE.Exp a_inExp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  String str_1;
  Tpl.Text txt_0;
algorithm
  txt_0 := expTypeFromExpShort(Tpl.emptyTxt, a_inExp);
  str_1 := Tpl.textString(txt_0);
  (out_txt, out_a_preExp, out_a_varDecls) := fun_635(txt, str_1, a_inExp, a_context, a_preExp, a_varDecls, a_simCode);
end daeExpAsub;

public function daeExpASubIndex
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Exp i_exp;
      Integer i_index;
      Integer i_integer;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        ret_0 = SimCode.incrementInt(i_integer, -1);
        txt = Tpl.writeStr(txt, intString(ret_0));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        ret_1 = SimCode.incrementInt(i_index, -1);
        txt = Tpl.writeStr(txt, intString(ret_1));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpASubIndex;

protected function lm_638
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_638(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_638(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_638;

protected function fun_639
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input Tpl.Text in_a_dimsValuesStr;
  input String in_a_arrName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_ecr_componentRef, in_a_dimsValuesStr, in_a_arrName)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      Tpl.Text a_dimsValuesStr;
      String a_arrName;

    case ( txt,
           "metatype_array",
           _,
           a_dimsValuesStr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeStr(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /*arrayScalarRhs*/"));
      then txt;

    case ( txt,
           _,
           a_ecr_componentRef,
           a_dimsValuesStr,
           _ )
      equation
        txt = arrayCrefCStr(txt, a_ecr_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end matchcontinue;
end fun_639;

public function arrayScalarRhs
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input list<DAE.Exp> in_a_subs;
  input String in_a_arrName;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_subs, in_a_arrName, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.Exp> a_subs;
      String a_arrName;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_ecr_componentRef;
      DAE.Type i_exp_ty;
      String str_4;
      Tpl.Text l_dimsValuesStr;
      Integer ret_2;
      Tpl.Text l_dimsLenStr;
      Tpl.Text l_arrayType;

    case ( txt,
           DAE.ASUB(exp = DAE.CREF(ty = i_exp_ty, componentRef = i_ecr_componentRef)),
           a_subs,
           a_arrName,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_arrayType = expTypeArray(Tpl.emptyTxt, i_exp_ty);
        ret_2 = listLength(a_subs);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_varDecls, a_preExp) = lm_638(l_dimsValuesStr, a_subs, a_simCode, a_varDecls, a_preExp, a_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        str_4 = Tpl.textString(l_arrayType);
        txt = fun_639(txt, str_4, i_ecr_componentRef, l_dimsValuesStr, a_arrName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end arrayScalarRhs;

protected function fun_641
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_expVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ty, in_a_preExp, in_a_exp, in_a_varDecls, in_a_expVar)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      DAE.Exp a_exp;
      Tpl.Text a_varDecls;
      Tpl.Text a_expVar;
      DAE.Type i_ty;
      Tpl.Text l_from;
      Tpl.Text l_to;
      Tpl.Text l_tvar;
      Tpl.Text l_arrayTypeStr;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((int)"));
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((double)"));
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((modelica_integer)"));
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_BOOL(varLst = _),
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((bool)"));
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_ARRAY(ty = i_ty),
           a_preExp,
           a_exp,
           a_varDecls,
           a_expVar )
      equation
        l_arrayTypeStr = expTypeArray(Tpl.emptyTxt, i_ty);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayTypeStr), a_varDecls);
        l_to = expTypeShort(Tpl.emptyTxt, i_ty);
        l_from = expTypeFromExpShort(Tpl.emptyTxt, a_exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("cast_"));
        a_preExp = Tpl.writeText(a_preExp, l_from);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_array_to_"));
        a_preExp = Tpl.writeText(a_preExp, l_to);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, a_expVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /* could not cast, using the variable as it is */"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_641;

public function daeExpCast
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Type i_ty;
      DAE.Exp i_exp;
      Tpl.Text l_expVar;

    case ( txt,
           DAE.CAST(exp = i_exp, ty = i_ty),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_expVar, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        (txt, a_preExp, a_varDecls) = fun_641(txt, i_ty, a_preExp, i_exp, a_varDecls, l_expVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpCast;

protected function lm_643
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_643(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_643(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_643;

protected function fun_644
  input Tpl.Text in_txt;
  input DAE.Type in_a_attr_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attr_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end matchcontinue;
end fun_644;

protected function fun_645
  input Tpl.Text in_txt;
  input DAE.Type in_a_arg_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_arg_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_645;

protected function fun_646
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_var1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_var1)
    local
      Tpl.Text txt;
      Tpl.Text a_var1;

    case ( txt,
           false,
           a_var1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("puts("));
        txt = Tpl.writeText(txt, a_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_var1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("print("));
        txt = Tpl.writeText(txt, a_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_646;

protected function lm_647
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_647(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_647(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_647;

protected function lm_648
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_648(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_648(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_648;

protected function fun_649
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end matchcontinue;
end fun_649;

protected function lm_650
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_650(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_650(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_650;

protected function fun_651
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end matchcontinue;
end fun_651;

protected function lm_652
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_652(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_652(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_652;

protected function fun_653
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end matchcontinue;
end fun_653;

protected function lm_654
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_654(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_654(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_654;

protected function fun_655
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end matchcontinue;
end fun_655;

protected function lm_656
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_656(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_656(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_656;

protected function fun_657
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end matchcontinue;
end fun_657;

protected function lm_658
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_dim;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_dim :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_dim, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_658(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_658(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_658;

protected function lm_659
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_array;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_array :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_array, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_659(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_659(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_659;

protected function lm_660
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_660(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_660(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_660;

protected function fun_661
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = DAE.T_NORETCALL(source = _))),
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_661;

protected function fun_662
  input Tpl.Text in_txt;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text i_retVar;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_retVar )
      equation
        txt = Tpl.writeText(txt, i_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;
  end matchcontinue;
end fun_662;

protected function fun_663
  input Tpl.Text in_txt;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text i_retVar;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_retVar )
      equation
        txt = Tpl.writeText(txt, i_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;
  end matchcontinue;
end fun_663;

protected function fun_664
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_argStr;
  input Tpl.Text in_a_funName;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_argStr, in_a_funName, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_argStr;
      Tpl.Text a_funName;
      Tpl.Text a_retVar;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_argStr,
           a_funName,
           a_retVar )
      equation
        txt = fun_662(txt, a_retVar);
        txt = Tpl.writeText(txt, a_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_argStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           a_argStr,
           a_funName,
           a_retVar )
      equation
        txt = fun_663(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions."));
        txt = Tpl.writeText(txt, a_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_argStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end matchcontinue;
end fun_664;

protected function fun_665
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attr_builtin, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("get<0>("));
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end matchcontinue;
end fun_665;

protected function fun_666
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_exp, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retVar;
      Boolean i_attr_builtin;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = DAE.T_NORETCALL(source = _))),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* NORETCALL */"));
      then txt;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(tuple_ = false, builtin = i_attr_builtin)),
           a_retVar )
      equation
        txt = fun_665(txt, i_attr_builtin, a_retVar);
      then txt;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(tuple_ = true)),
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_666;

public function daeExpCall
  input Tpl.Text in_txt;
  input DAE.Exp in_a_call;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_call, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Exp i_exp;
      Integer i_i;
      DAE.Exp i_s1;
      DAE.Exp i_toBeCasted;
      Integer i_index_1;
      DAE.Exp i_delayMax;
      DAE.Exp i_d;
      DAE.Exp i_e;
      DAE.Exp i_signdig;
      DAE.Exp i_leftjust;
      DAE.Exp i_minlen;
      DAE.Exp i_format;
      DAE.Exp i_s;
      DAE.Exp i_v2;
      DAE.Exp i_v1;
      DAE.Exp i_n;
      DAE.Exp i_A;
      list<DAE.Exp> i_arrays;
      DAE.Exp i_dim;
      list<DAE.Exp> i_dims;
      DAE.Exp i_val;
      DAE.Exp i_array;
      Boolean i_attr_builtin;
      Absyn.Path i_path;
      DAE.Type i_arg_ty;
      DAE.Type i_attr_ty;
      list<DAE.Exp> i_expLst;
      String i_string;
      DAE.Exp i_e2;
      DAE.Exp i_index;
      DAE.Exp i_interval;
      DAE.Exp i_start;
      DAE.ComponentRef i_arg_componentRef;
      DAE.Exp i_arg;
      DAE.Exp i_e1;
      Tpl.Text l_expPart;
      Tpl.Text l_castedVar;
      Tpl.Text l_signdigExp;
      Tpl.Text l_leftjustExp;
      Tpl.Text l_minlenExp;
      Tpl.Text l_formatExp;
      Tpl.Text l_sExp;
      Integer ret_32;
      Tpl.Text l_arrays__exp;
      Tpl.Text l_dim__exp;
      Integer ret_29;
      Integer ret_28;
      Tpl.Text l_tmp__type__str;
      Tpl.Text l_ty__str;
      Tpl.Text l_dimsExp;
      Tpl.Text l_valExp;
      Tpl.Text txt_23;
      Tpl.Text txt_22;
      Tpl.Text l_tvar;
      Tpl.Text l_arr__tp__str;
      Tpl.Text l_expVar;
      Tpl.Text l_tmpVar;
      Tpl.Text l_funName;
      Boolean ret_16;
      Tpl.Text l_cast;
      Tpl.Text l_retType;
      String ret_13;
      Tpl.Text l_var;
      Tpl.Text l_type;
      Tpl.Text l_retVar;
      Tpl.Text l_typeStr;
      Tpl.Text l_argStr;
      String ret_7;
      Tpl.Text l_var3;
      Tpl.Text l_var2;
      Tpl.Text l_eIndex;
      Tpl.Text l_eInterval;
      Tpl.Text l_eStart;
      Tpl.Text l_preExp;
      Tpl.Text l_var1;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "edge"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.edge("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "pre"), expLst = {(i_arg as DAE.CREF(componentRef = i_arg_componentRef))}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_arg, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.pre("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_arg_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {i_start, i_interval, i_index}),
           _,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_eStart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_start, SimCode.contextOther, l_preExp, a_varDecls, a_simCode);
        (l_eInterval, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_interval, SimCode.contextOther, l_preExp, a_varDecls, a_simCode);
        (l_eIndex, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_index, SimCode.contextOther, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeText(txt, l_eIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "initial")),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initial()"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "DIVISION"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("division("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" because "));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  == 0\")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "DIVISION"), expLst = {i_e1, i_e2, DAE.SCONST(string = i_string)}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        ret_7 = Util.escapeModelicaStringToCString(i_string);
        l_var3 = Tpl.writeStr(Tpl.emptyTxt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("division("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = Tpl.writeText(txt, l_var3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sign"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("sgn("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "DIVISION"), expLst = i_expLst),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_643(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_typeStr = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("double"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_typeStr), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = division("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",\"division by zero\");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "DIVISION_ARRAY_SCALAR"), expLst = {i_e1, i_e2, DAE.SCONST(string = i_string)}, attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_type = fun_644(Tpl.emptyTxt, i_attr_ty);
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        ret_13 = Util.escapeModelicaStringToCString(i_string);
        l_var3 = Tpl.writeStr(Tpl.emptyTxt, ret_13);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("division_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_scalar(&"));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",\""));
        a_preExp = Tpl.writeText(a_preExp, l_var3);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("\");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        txt = representationCref2(txt, i_arg_componentRef, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "pre"), expLst = {DAE.CREF(ty = i_arg_ty, componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        l_retType = expTypeArrayIf(Tpl.emptyTxt, i_arg_ty);
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        l_cast = fun_645(Tpl.emptyTxt, i_arg_ty);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_cast);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("pre("));
        a_preExp = cref(a_preExp, i_arg_componentRef);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "print"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        ret_16 = Config.acceptMetaModelicaGrammar();
        txt = fun_646(txt, ret_16, l_var1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "max"), attr = DAE.CALL_ATTR(ty = DAE.T_REAL(varLst = _)), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmax("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "max"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int_max((int)"));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",(int)"));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = DAE.T_REAL(varLst = _)), path = Absyn.IDENT(name = "min"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmin("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "min"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int_min((int)"));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",(int)"));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "abs"), expLst = {i_e1}, attr = DAE.CALL_ATTR(ty = DAE.T_INTEGER(varLst = _))),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("labs("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "abs"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fabs("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sqrt"), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_647(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_typeStr = expTypeShort(Tpl.emptyTxt, i_attr_ty);
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_typeStr), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = sqrt("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "sin")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_648(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeText(Tpl.emptyTxt, l_funName);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("_rettype"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_649(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "cos")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_650(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeText(Tpl.emptyTxt, l_funName);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("_rettype"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_651(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "tan")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_652(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeText(Tpl.emptyTxt, l_funName);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("_rettype"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_653(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "atan")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_654(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeText(Tpl.emptyTxt, l_funName);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("_rettype"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_655(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "exp")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_656(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeText(Tpl.emptyTxt, l_funName);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("_rettype"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_657(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "div"), expLst = {i_e1, i_e2}, attr = DAE.CALL_ATTR(ty = DAE.T_INTEGER(varLst = _))),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ldiv("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").quot"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "div"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("trunc("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "mod"), expLst = {i_e1, i_e2}, attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_mod_"));
        txt = expTypeShort(txt, i_attr_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "max"), expLst = {i_array}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_tmpVar = Tpl.emptyTxt;
        (l_expVar, a_preExp, l_tmpVar) = daeExp(Tpl.emptyTxt, i_array, a_context, a_preExp, l_tmpVar, a_simCode);
        l_arr__tp__str = expTypeFromExpArray(Tpl.emptyTxt, i_array);
        txt_22 = expTypeFromExpModelica(Tpl.emptyTxt, i_array);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_22), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = min_max<"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",1>("));
        a_preExp = Tpl.writeText(a_preExp, l_expVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(").second;"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "min"), expLst = {i_array}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_tmpVar = Tpl.emptyTxt;
        (l_expVar, a_preExp, l_tmpVar) = daeExp(Tpl.emptyTxt, i_array, a_context, a_preExp, l_tmpVar, a_simCode);
        l_arr__tp__str = expTypeFromExpArray(Tpl.emptyTxt, i_array);
        txt_23 = expTypeFromExpModelica(Tpl.emptyTxt, i_array);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_23), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = min_max<"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",1>("));
        a_preExp = Tpl.writeText(a_preExp, l_expVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(").first;"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "fill"), expLst = i_val :: i_dims, attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_valExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_val, a_context, a_preExp, a_varDecls, a_simCode);
        l_dimsExp = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsExp, a_varDecls, a_preExp) = lm_658(l_dimsExp, i_dims, a_simCode, a_varDecls, a_preExp, a_context);
        l_dimsExp = Tpl.popIter(l_dimsExp);
        l_ty__str = expTypeArray(Tpl.emptyTxt, i_attr_ty);
        l_tmp__type__str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("multi_array<"));
        l_tmp__type__str = Tpl.writeText(l_tmp__type__str, l_ty__str);
        l_tmp__type__str = Tpl.writeTok(l_tmp__type__str, Tpl.ST_STRING(","));
        ret_28 = listLength(i_dims);
        l_tmp__type__str = Tpl.writeStr(l_tmp__type__str, intString(ret_28));
        l_tmp__type__str = Tpl.writeTok(l_tmp__type__str, Tpl.ST_STRING(">"));
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_tmp__type__str), a_varDecls);
        a_varDecls = Tpl.writeText(a_varDecls, l_tvar);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(".resize((boost::extents["));
        a_varDecls = Tpl.writeText(a_varDecls, l_dimsExp);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_LINE("]));\n"));
        a_varDecls = Tpl.pushBlock(a_varDecls, Tpl.BT_INDENT(4));
        a_varDecls = Tpl.writeText(a_varDecls, l_tvar);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(".reindex(1);"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_varDecls = Tpl.popBlock(a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("fill_array<"));
        a_preExp = Tpl.writeText(a_preExp, l_ty__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(","));
        ret_29 = listLength(i_dims);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_29));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(">("));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_valExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "cat"), expLst = i_dim :: i_arrays, attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_dim__exp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_dim, a_context, a_preExp, a_varDecls, a_simCode);
        l_arrays__exp = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", &")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_arrays__exp, a_varDecls, a_preExp) = lm_659(l_arrays__exp, i_arrays, a_simCode, a_varDecls, a_preExp, a_context);
        l_arrays__exp = Tpl.popIter(l_arrays__exp);
        l_ty__str = expTypeArray(Tpl.emptyTxt, i_attr_ty);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_ty__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("cat_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_ty__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_dim__exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        ret_32 = listLength(i_arrays);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_32));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_arrays__exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "promote"), expLst = {i_A, i_n}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_A, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_n, a_context, a_preExp, a_varDecls, a_simCode);
        l_arr__tp__str = expTypeFromExpArray(Tpl.emptyTxt, i_A);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arr__tp__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("promote_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "transpose"), expLst = {i_A}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_A, a_context, a_preExp, a_varDecls, a_simCode);
        l_arr__tp__str = expTypeFromExpArray(Tpl.emptyTxt, i_A);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arr__tp__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("transpose_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "cross"), expLst = {i_v1, i_v2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_v1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_v2, a_context, a_preExp, a_varDecls, a_simCode);
        l_arr__tp__str = expTypeFromExpArray(Tpl.emptyTxt, i_v1);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arr__tp__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("cross_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "identity"), expLst = {i_A}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_A, a_context, a_preExp, a_varDecls, a_simCode);
        l_arr__tp__str = expTypeFromExpArray(Tpl.emptyTxt, i_A);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arr__tp__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("identity_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "rem"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        l_typeStr = expTypeFromExpShort(Tpl.emptyTxt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_rem_"));
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "String"), expLst = {i_s, i_format}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_string", a_varDecls);
        (l_sExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_s, a_context, a_preExp, a_varDecls, a_simCode);
        (l_formatExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_format, a_context, a_preExp, a_varDecls, a_simCode);
        l_typeStr = expTypeFromExpModelica(Tpl.emptyTxt, i_s);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_typeStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_to_modelica_string_format("));
        a_preExp = Tpl.writeText(a_preExp, l_sExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_formatExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "String"), expLst = {i_s, i_minlen, i_leftjust}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_string", a_varDecls);
        (l_sExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_s, a_context, a_preExp, a_varDecls, a_simCode);
        (l_minlenExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_minlen, a_context, a_preExp, a_varDecls, a_simCode);
        (l_leftjustExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_leftjust, a_context, a_preExp, a_varDecls, a_simCode);
        l_typeStr = expTypeFromExpModelica(Tpl.emptyTxt, i_s);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_typeStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_to_modelica_string("));
        a_preExp = Tpl.writeText(a_preExp, l_sExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_minlenExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_leftjustExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "String"), expLst = {i_s, i_minlen, i_leftjust, i_signdig}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_string", a_varDecls);
        (l_sExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_s, a_context, a_preExp, a_varDecls, a_simCode);
        (l_minlenExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_minlen, a_context, a_preExp, a_varDecls, a_simCode);
        (l_leftjustExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_leftjust, a_context, a_preExp, a_varDecls, a_simCode);
        (l_signdigExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_signdig, a_context, a_preExp, a_varDecls, a_simCode);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = double_to_modelica_string("));
        a_preExp = Tpl.writeText(a_preExp, l_sExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_minlenExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_leftjustExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_signdigExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "delay"), expLst = {DAE.ICONST(integer = i_index_1), i_e, i_d, i_delayMax}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "double", a_varDecls);
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_d, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var3, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_delayMax, a_context, a_preExp, a_varDecls, a_simCode);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = delayImpl("));
        a_preExp = Tpl.writeStr(a_preExp, intString(i_index_1));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", time, "));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var3);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "integer"), expLst = {i_toBeCasted}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_castedVar, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_toBeCasted, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((int)"));
        txt = Tpl.writeText(txt, l_castedVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "Integer"), expLst = {i_toBeCasted}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_castedVar, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_toBeCasted, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((int)"));
        txt = Tpl.writeText(txt, l_castedVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "clock"), expLst = {}),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_clock()"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "noEvent"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "anyString"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_anyString("));
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "mmc_get_field"), expLst = {i_s1, DAE.ICONST(integer = i_i)}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_metatype", a_varDecls);
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_s1, a_context, a_preExp, a_varDecls, a_simCode);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR("));
        a_preExp = Tpl.writeText(a_preExp, l_expPart);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("), "));
        a_preExp = Tpl.writeStr(a_preExp, intString(i_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("));"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CALL(attr = DAE.CALL_ATTR(ty = _), expLst = i_expLst, path = i_path)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_660(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeText(Tpl.emptyTxt, l_funName);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("RetType"));
        (l_retVar, a_varDecls) = fun_661(Tpl.emptyTxt, i_exp, a_varDecls, l_retType);
        a_preExp = fun_664(a_preExp, a_context, l_argStr, l_funName, l_retVar);
        txt = fun_666(txt, i_exp, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpCall;

public function expTypeFromExpShort
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlag(txt, a_exp, 1);
end expTypeFromExpShort;

public function expTypeFromExpModelica
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlag(txt, a_exp, 2);
end expTypeFromExpModelica;

public function expTypeFromExpArray
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlag(txt, a_exp, 3);
end expTypeFromExpArray;

protected function fun_671
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_msgVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_msgVar)
    local
      Tpl.Text txt;
      Tpl.Text a_msgVar;

    case ( txt,
           false,
           a_msgVar )
      equation
        txt = Tpl.writeText(txt, a_msgVar);
      then txt;

    case ( txt,
           _,
           a_msgVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MMC_STRINGDATA("));
        txt = Tpl.writeText(txt, a_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_671;

public function assertCommon
  input Tpl.Text txt;
  input DAE.Exp a_condition;
  input DAE.Exp a_message;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Absyn.Info a_info;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Boolean ret_4;
  Tpl.Text l_msgVar;
  Tpl.Text l_condVar;
  Tpl.Text l_preExpMsg;
  Tpl.Text l_preExpCond;
algorithm
  l_preExpCond := Tpl.emptyTxt;
  l_preExpMsg := Tpl.emptyTxt;
  (l_condVar, l_preExpCond, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_condition, a_context, l_preExpCond, a_varDecls, a_simCode);
  (l_msgVar, l_preExpMsg, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_message, a_context, l_preExpMsg, out_a_varDecls, a_simCode);
  out_txt := Tpl.writeText(txt, l_preExpCond);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("if (!"));
  out_txt := Tpl.writeText(out_txt, l_condVar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(") {\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_preExpMsg);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("omc_fileInfo info = {"));
  out_txt := infoArgs(out_txt, a_info);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "};\n",
                                       "MODELICA_ASSERT(info, "
                                   }, false));
  ret_4 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_671(out_txt, ret_4, l_msgVar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(");\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end assertCommon;

public function infoArgs
  input Tpl.Text in_txt;
  input Absyn.Info in_a_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_info)
    local
      Tpl.Text txt;
      Boolean i_isReadOnly;
      Integer i_columnNumberEnd;
      Integer i_lineNumberEnd;
      Integer i_columnNumberStart;
      Integer i_lineNumberStart;
      String i_fileName;

    case ( txt,
           Absyn.INFO(fileName = i_fileName, lineNumberStart = i_lineNumberStart, columnNumberStart = i_columnNumberStart, lineNumberEnd = i_lineNumberEnd, columnNumberEnd = i_columnNumberEnd, isReadOnly = i_isReadOnly) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_fileName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\","));
        txt = Tpl.writeStr(txt, intString(i_lineNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_columnNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_lineNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_columnNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_isReadOnly));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end infoArgs;

public function underscorePrefix
  input Tpl.Text in_txt;
  input Boolean in_a_builtin;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_builtin)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end underscorePrefix;

public function daeExpCallBuiltinPrefix
  input Tpl.Text in_txt;
  input Boolean in_a_builtin;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_builtin)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end daeExpCallBuiltinPrefix;

protected function fun_676
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_operator, in_a_e)
    local
      Tpl.Text txt;
      Tpl.Text a_e;

    case ( txt,
           DAE.NOT(ty = _),
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_676;

public function daeExpLunary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Operator i_operator;
      DAE.Exp i_exp;
      Tpl.Text l_e;

    case ( txt,
           DAE.LUNARY(exp = i_exp, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_e, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = fun_676(txt, i_operator, l_e);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpLunary;

protected function fun_678
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_operator, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.AND(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.OR(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpLbinary:ERR"));
      then txt;
  end matchcontinue;
end fun_678;

public function daeExpLbinary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           DAE.LBINARY(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = fun_678(txt, i_operator, l_e2, l_e1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpLbinary;

protected function fun_680
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.Dimensions in_a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty, in_a_dims)
    local
      Tpl.Text txt;
      DAE.Dimensions a_dims;
      DAE.Dimensions i_dims;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _), dims = i_dims),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<int,"));
        ret_0 = listLength(i_dims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _), dims = i_dims),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<int,"));
        ret_1 = listLength(i_dims);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           _,
           a_dims )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<double,"));
        ret_2 = listLength(a_dims);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;
  end matchcontinue;
end fun_680;

protected function fun_681
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;
  end matchcontinue;
end fun_681;

protected function fun_682
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.Dimensions in_a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty, in_a_dims)
    local
      Tpl.Text txt;
      DAE.Dimensions a_dims;
      DAE.Dimensions i_dims;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _), dims = i_dims),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<int,"));
        ret_0 = listLength(i_dims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _), dims = i_dims),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<int,"));
        ret_1 = listLength(i_dims);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           _,
           a_dims )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<double,"));
        ret_2 = listLength(a_dims);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;
  end matchcontinue;
end fun_682;

protected function fun_683
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;
  end matchcontinue;
end fun_683;

protected function fun_684
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end matchcontinue;
end fun_684;

protected function fun_685
  input Tpl.Text in_txt;
  input DAE.Operator in_a_it;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_it, in_a_preExp, in_a_varDecls, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      DAE.Dimensions i_dims;
      DAE.Type i_ty;
      Tpl.Text l_var;
      Integer ret_4;
      Integer ret_3;
      Tpl.Text l_var1;
      Tpl.Text l_type1;
      Tpl.Text l_type;

    case ( txt,
           DAE.ADD(ty = _),
           a_preExp,
           a_varDecls,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" + "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SUB(ty = _),
           a_preExp,
           a_varDecls,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL(ty = _),
           a_preExp,
           a_varDecls,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.DIV(ty = _),
           a_preExp,
           a_varDecls,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" / "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.POW(ty = _),
           a_preExp,
           a_varDecls,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pow("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.AND(ty = _),
           a_preExp,
           a_varDecls,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.OR(ty = _),
           a_preExp,
           a_varDecls,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL_ARRAY_SCALAR(ty = (i_ty as DAE.T_ARRAY(dims = i_dims))),
           a_preExp,
           a_varDecls,
           a_e2,
           a_e1 )
      equation
        l_type = fun_680(Tpl.emptyTxt, i_ty, i_dims);
        l_type1 = fun_681(Tpl.emptyTxt, i_ty);
        (l_var1, a_varDecls) = tempDecl1(Tpl.emptyTxt, Tpl.textString(l_type), Tpl.textString(a_e1), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("=multiply_array<"));
        a_preExp = Tpl.writeText(a_preExp, l_type1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(","));
        ret_3 = listLength(i_dims);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_3));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(">("));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL_MATRIX_PRODUCT(ty = (i_ty as DAE.T_ARRAY(dims = i_dims))),
           a_preExp,
           a_varDecls,
           a_e2,
           a_e1 )
      equation
        l_type = fun_682(Tpl.emptyTxt, i_ty, i_dims);
        l_type1 = fun_683(Tpl.emptyTxt, i_ty);
        (l_var1, a_varDecls) = tempDecl1(Tpl.emptyTxt, Tpl.textString(l_type), Tpl.textString(a_e1), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("=multiply_array<"));
        a_preExp = Tpl.writeText(a_preExp, l_type1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(","));
        ret_4 = listLength(i_dims);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_4));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(">("));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.DIV_ARRAY_SCALAR(ty = (i_ty as DAE.T_ARRAY(dims = _))),
           a_preExp,
           a_varDecls,
           a_e2,
           a_e1 )
      equation
        l_type = fun_684(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("div_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_scalar(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_685;

public function daeExpBinary
  input Tpl.Text txt;
  input DAE.Operator a_it;
  input DAE.Exp a_exp1;
  input DAE.Exp a_exp2;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_e2;
  Tpl.Text l_e1;
algorithm
  (l_e1, out_a_preExp, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_exp1, a_context, a_preExp, a_varDecls, a_simCode);
  (l_e2, out_a_preExp, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_exp2, a_context, out_a_preExp, out_a_varDecls, a_simCode);
  (out_txt, out_a_preExp, out_a_varDecls) := fun_685(txt, a_it, out_a_preExp, out_a_varDecls, l_e2, l_e1);
end daeExpBinary;

public function tempDecl1
  input Tpl.Text txt;
  input String a_ty;
  input String a_exp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_newVar1;
  Integer ret_1;
  Tpl.Text l_newVar;
algorithm
  l_newVar := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("tmp"));
  ret_1 := System.tmpTick();
  l_newVar := Tpl.writeStr(l_newVar, intString(ret_1));
  l_newVar1 := Tpl.writeText(Tpl.emptyTxt, l_newVar);
  l_newVar1 := Tpl.writeTok(l_newVar1, Tpl.ST_STRING("("));
  l_newVar1 := Tpl.writeStr(l_newVar1, a_exp);
  l_newVar1 := Tpl.writeTok(l_newVar1, Tpl.ST_STRING(")"));
  out_a_varDecls := Tpl.writeStr(a_varDecls, a_ty);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(" "));
  out_a_varDecls := Tpl.writeText(out_a_varDecls, l_newVar1);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(";"));
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_newVar);
end tempDecl1;

public function daeExpSconst
  input Tpl.Text txt;
  input String a_string;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("\""));
  ret_0 := Util.escapeModelicaStringToCString(a_string);
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_a_preExp := a_preExp;
  out_a_varDecls := a_varDecls;
end daeExpSconst;

protected function fun_689
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_e;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_operator, in_a_preExp, in_a_e)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_e;

    case ( txt,
           DAE.UMINUS(ty = _),
           a_preExp,
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(-"));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.UMINUS_ARR(ty = DAE.T_ARRAY(ty = DAE.T_REAL(varLst = _))),
           a_preExp,
           a_e )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("usub_real_array(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_e);
      then (txt, a_preExp);

    case ( txt,
           DAE.UMINUS_ARR(ty = _),
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unary minus for non-real arrays not implemented"));
      then (txt, a_preExp);

    case ( txt,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpUnary:ERR"));
      then (txt, a_preExp);
  end matchcontinue;
end fun_689;

public function daeExpUnary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Operator i_operator;
      DAE.Exp i_exp;
      Tpl.Text l_e;

    case ( txt,
           DAE.UNARY(exp = i_exp, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_e, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        (txt, a_preExp) = fun_689(txt, i_operator, a_preExp, l_e);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpUnary;

protected function fun_691
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input DAE.Type in_a_t;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_context, in_a_cr, in_a_t, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_exp)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      DAE.Type a_t;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp a_exp;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           _,
           _,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_exp )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs2(txt, a_exp, i_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_context,
           a_cr,
           a_t,
           a_simCode,
           a_varDecls,
           a_preExp,
           _ )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRecordCrefRhs(txt, a_t, a_cr, i_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_691;

public function daeExpCrefRhs
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_cr;
      DAE.Type i_t;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.CREF(componentRef = i_cr, ty = (i_t as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _))))),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls, a_preExp) = fun_691(txt, a_context, i_cr, i_t, a_simCode, a_varDecls, a_preExp, i_exp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_FUNC(builtin = _)),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((modelica_fnptr)boxptr_"));
        txt = crefFunctionName(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_VAR(functionType = _)),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((modelica_fnptr) _"));
        txt = crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs2(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpCrefRhs;

protected function lm_693
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      DAE.Var i_v;
      DAE.Exp ret_0;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_v :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.makeCrefRecordExp(a_cr, i_v);
        (txt, a_preExp, a_varDecls) = daeExp(txt, ret_0, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_693(txt, rest, a_simCode, a_varDecls, a_preExp, a_context, a_cr);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        (txt, a_varDecls, a_preExp) = lm_693(txt, rest, a_simCode, a_varDecls, a_preExp, a_context, a_cr);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_693;

public function daeExpRecordCrefRhs
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ty, in_a_cr, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      ClassInf.State i_record__state;
      list<DAE.Var> i_var__lst;
      Tpl.Text l_ret__var;
      Tpl.Text l_ret__type;
      Absyn.Path ret_2;
      Tpl.Text l_record__type__name;
      Tpl.Text l_vars;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_record__state, varLst = i_var__lst),
           a_cr,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_vars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_vars, a_varDecls, a_preExp) = lm_693(l_vars, i_var__lst, a_simCode, a_varDecls, a_preExp, a_context, a_cr);
        l_vars = Tpl.popIter(l_vars);
        ret_2 = ClassInf.getStateName(i_record__state);
        l_record__type__name = underscorePath(Tpl.emptyTxt, ret_2);
        l_ret__type = Tpl.writeText(Tpl.emptyTxt, l_record__type__name);
        l_ret__type = Tpl.writeTok(l_ret__type, Tpl.ST_STRING("RetType"));
        (l_ret__var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_ret__type), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_ret__var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = _functions."));
        a_preExp = Tpl.writeText(a_preExp, l_record__type__name);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_vars);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_ret__var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpRecordCrefRhs;

protected function lm_695
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_695(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_695(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_695;

protected function fun_696
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_dimsValuesStr;
  input Tpl.Text in_a_arrName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_dimsValuesStr, in_a_arrName)
    local
      Tpl.Text txt;
      Tpl.Text a_dimsValuesStr;
      Tpl.Text a_arrName;

    case ( txt,
           "metatype_array",
           a_dimsValuesStr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /* DAE.CREF */"));
      then txt;

    case ( txt,
           _,
           a_dimsValuesStr,
           a_arrName )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_696;

protected function fun_697
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_simCode, in_a_preExp, in_a_varDecls, in_a_ty, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      String str_8;
      list<DAE.Subscript> ret_7;
      Tpl.Text l_dimsValuesStr;
      DAE.ComponentRef ret_5;
      list<DAE.Subscript> ret_4;
      Tpl.Text l_spec1;
      Tpl.Text l_tmp;
      Tpl.Text l_arrayType;
      Tpl.Text l_arrName;

    case ( txt,
           false,
           a_simCode,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        l_arrName = contextArrayCref(Tpl.emptyTxt, a_cr, a_context);
        l_arrayType = expTypeArray(Tpl.emptyTxt, a_ty);
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayType), a_varDecls);
        ret_4 = ComponentReference.crefSubs(a_cr);
        (l_spec1, a_preExp, a_varDecls) = daeExpCrefRhsIndexSpec(Tpl.emptyTxt, ret_4, a_context, a_preExp, a_varDecls, a_simCode);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("index_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayType);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_arrName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_spec1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_simCode,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        ret_5 = ComponentReference.crefStripLastSubs(a_cr);
        l_arrName = contextCref(Tpl.emptyTxt, ret_5, a_context, a_simCode);
        l_arrayType = expTypeArray(Tpl.emptyTxt, a_ty);
        ret_7 = ComponentReference.crefSubs(a_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_varDecls, a_preExp) = lm_695(l_dimsValuesStr, ret_7, a_simCode, a_varDecls, a_preExp, a_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        str_8 = Tpl.textString(l_arrayType);
        txt = fun_696(txt, str_8, l_dimsValuesStr, l_arrName);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_697;

protected function fun_698
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_698;

protected function fun_699
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_simCode, in_a_preExp, in_a_varDecls, in_a_ty, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text l_cast;
      Boolean ret_0;

    case ( txt,
           false,
           a_simCode,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.crefSubIsScalar(a_cr);
        (txt, a_preExp, a_varDecls) = fun_697(txt, ret_0, a_simCode, a_preExp, a_varDecls, a_ty, a_context, a_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_simCode,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        l_cast = fun_698(Tpl.emptyTxt, a_ty);
        txt = Tpl.writeText(txt, l_cast);
        txt = contextCref(txt, a_cr, a_context, a_simCode);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_699;

protected function fun_700
  input Tpl.Text in_txt;
  input Tpl.Text in_a_box;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_box, in_a_simCode, in_a_preExp, in_a_varDecls, in_a_ty, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text i_box;
      Boolean ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_simCode,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.crefIsScalar(a_cr, a_context);
        (txt, a_preExp, a_varDecls) = fun_699(txt, ret_0, a_simCode, a_preExp, a_varDecls, a_ty, a_context, a_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_box,
           _,
           a_preExp,
           a_varDecls,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, i_box);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_700;

public function daeExpCrefRhs2
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Type i_ty;
      DAE.ComponentRef i_cr;
      DAE.Exp i_ecr;
      Tpl.Text l_box;

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = i_cr, ty = i_ty)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_box, a_preExp, a_varDecls) = daeExpCrefRhsArrayBox(Tpl.emptyTxt, i_ecr, a_context, a_preExp, a_varDecls, a_simCode);
        (txt, a_preExp, a_varDecls) = fun_700(txt, l_box, a_simCode, a_preExp, a_varDecls, i_ty, a_context, i_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpCrefRhs2;

protected function fun_702
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_sub;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_sub, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;
      Tpl.Text l_tmp;
      Tpl.Text l_expPart;

    case ( txt,
           DAE.INDEX(exp = i_exp),
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(0), make_index_array(1, (int) "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "), \'S\'\n",
                                    "\n"
                                }, true));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.WHOLEDIM(),
           _,
           a_varDecls,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1), (int*)0, \'W\'"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.SLICE(exp = i_exp),
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "int", a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = size_of_dimension_integer_array("));
        a_preExp = Tpl.writeText(a_preExp, l_expPart);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", 1);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int) "));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", integer_array_make_index_array(&"));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("), \'A\'"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_702;

protected function lm_703
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Subscript i_sub;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_sub :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = fun_702(txt, i_sub, a_simCode, a_varDecls, a_preExp, a_context);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_703(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_703(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_703;

public function daeExpCrefRhsIndexSpec
  input Tpl.Text txt;
  input list<DAE.Subscript> a_subs;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_tmp;
  Tpl.Text l_idx__str;
  Integer ret_1;
  Tpl.Text l_nridx__str;
algorithm
  ret_1 := listLength(a_subs);
  l_nridx__str := Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
  l_idx__str := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_idx__str, out_a_varDecls, out_a_preExp) := lm_703(l_idx__str, a_subs, a_simCode, a_varDecls, a_preExp, a_context);
  l_idx__str := Tpl.popIter(l_idx__str);
  (l_tmp, out_a_varDecls) := tempDecl(Tpl.emptyTxt, "index_spec_t", out_a_varDecls);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING("create_index_spec(&"));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_tmp);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(", "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_nridx__str);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(", "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_idx__str);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(");"));
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_tmp);
end daeExpCrefRhsIndexSpec;

protected function fun_705
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_ecr_componentRef;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_ecr_componentRef)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      Tpl.Text l_tmpArr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           _ )
      then txt;

    case ( txt,
           _,
           a_ecr_componentRef )
      equation
        l_tmpArr = arrayCrefCStr(Tpl.emptyTxt, a_ecr_componentRef);
        txt = Tpl.writeText(txt, l_tmpArr);
      then txt;
  end matchcontinue;
end fun_705;

protected function fun_706
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ecr, in_a_context)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      DAE.ComponentRef i_ecr_componentRef;

    case ( txt,
           DAE.CREF(ty = DAE.T_ARRAY(ty = _, dims = _), componentRef = i_ecr_componentRef),
           a_context )
      equation
        txt = fun_705(txt, a_context, i_ecr_componentRef);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_706;

public function daeExpCrefRhsArrayBox
  input Tpl.Text txt;
  input DAE.Exp a_ecr;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_706(txt, a_ecr, a_context);
  out_a_preExp := a_preExp;
  out_a_varDecls := a_varDecls;
end daeExpCrefRhsArrayBox;

public function cref1
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")),
           a_simCode )
      equation
        txt = representationCref(txt, i_cr, a_simCode);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time"),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           i_cr,
           a_simCode )
      equation
        txt = representationCref(txt, i_cr, a_simCode);
      then txt;
  end matchcontinue;
end cref1;

protected function fun_709
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_inCref;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_varKind, in_a_simCode, in_a_inCref)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_inCref;

    case ( txt,
           BackendDAE.STATE(),
           a_simCode,
           a_inCref )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = representationCref1(txt, a_inCref, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           BackendDAE.STATE_DER(),
           a_simCode,
           a_inCref )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = representationCref2(txt, a_inCref, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           a_inCref )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = cref(txt, a_inCref);
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_709;

protected function smf_710
  input Tpl.Text in_txt;
  input SimCode.SimVar in_it;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_inCref;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it, in_a_simCode, in_a_inCref)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_inCref;
      BackendDAE.VarKind i_varKind;

    case ( txt,
           SimCode.SIMVAR(varKind = i_varKind),
           a_simCode,
           a_inCref )
      equation
        txt = fun_709(txt, i_varKind, a_simCode, a_inCref);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end smf_710;

public function representationCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_inCref;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  SimCode.SimVar ret_0;
algorithm
  ret_0 := SimCode.cref2simvar(a_inCref, a_simCode);
  out_txt := smf_710(txt, ret_0, a_simCode, a_inCref);
end representationCref;

protected function fun_712
  input Tpl.Text in_txt;
  input Integer in_a_index;
  input DAE.ComponentRef in_a_inCref;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_index, in_a_inCref)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_inCref;
      Integer i_index;

    case ( txt,
           -1,
           a_inCref )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = cref2(txt, a_inCref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_index,
           _ )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_z["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] "));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_712;

protected function smf_713
  input Tpl.Text in_txt;
  input SimCode.SimVar in_it;
  input DAE.ComponentRef in_a_inCref;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it, in_a_inCref)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_inCref;
      Integer i_index;

    case ( txt,
           SimCode.SIMVAR(index = i_index),
           a_inCref )
      equation
        txt = fun_712(txt, i_index, a_inCref);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end smf_713;

public function representationCref1
  input Tpl.Text txt;
  input DAE.ComponentRef a_inCref;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  SimCode.SimVar ret_0;
algorithm
  ret_0 := SimCode.cref2simvar(a_inCref, a_simCode);
  out_txt := smf_713(txt, ret_0, a_inCref);
end representationCref1;

protected function smf_715
  input Tpl.Text in_txt;
  input SimCode.SimVar in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Integer i_index;

    case ( txt,
           SimCode.SIMVAR(index = i_index) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_zDot["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end smf_715;

public function representationCref2
  input Tpl.Text txt;
  input DAE.ComponentRef a_inCref;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  SimCode.SimVar ret_0;
algorithm
  ret_0 := SimCode.cref2simvar(a_inCref, a_simCode);
  out_txt := smf_715(txt, ret_0);
end representationCref2;

public function helpvarlength
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.HelpVarInfo> i_helpVarInfo;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SIMCODE(helpVarInfo = i_helpVarInfo) )
      equation
        ret_1 = listLength(i_helpVarInfo);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end helpvarlength;

public function zerocrosslength
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SIMCODE(zeroCrossings = i_zeroCrossings) )
      equation
        ret_1 = listLength(i_zeroCrossings);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end zerocrosslength;

public function DimZeroFunc
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimZeroFunc()\n",
                                    " {\n",
                                    "   return _dimZeroFunc;\n",
                                    " }"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end DimZeroFunc;

protected function fun_720
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input Absyn.Path in_a_modelInfo_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo, in_a_modelInfo_name)
    local
      Tpl.Text txt;
      Absyn.Path a_modelInfo_name;
      Integer i_varInfo_numInitEquations;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numInitEquations = i_varInfo_numInitEquations)),
           a_modelInfo_name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unsigned int "));
        txt = lastIdentOfPath(txt, a_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimInitEquations()\n",
                                    " {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInitEquations));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" }"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_720;

public function DimInitEquations
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      SimCode.ModelInfo i_modelInfo;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name))) )
      equation
        txt = fun_720(txt, i_modelInfo, i_modelInfo_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end DimInitEquations;

public function DimUnfixedStates
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unsigned int "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimUnfixedStates()\n",
                                    " {\n",
                                    "   return 0;\n",
                                    " }"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end DimUnfixedStates;

protected function fun_723
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input Absyn.Path in_a_modelInfo_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo, in_a_modelInfo_name)
    local
      Tpl.Text txt;
      Absyn.Path a_modelInfo_name;
      Integer i_varInfo_numResiduals;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numResiduals = i_varInfo_numResiduals)),
           a_modelInfo_name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unsigned int "));
        txt = lastIdentOfPath(txt, a_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimUnfixedParameters()\n",
                                    " {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numResiduals));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" }"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_723;

public function DimUnfixedParameters
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      SimCode.ModelInfo i_modelInfo;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name))) )
      equation
        txt = fun_723(txt, i_modelInfo, i_modelInfo_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end DimUnfixedParameters;

public function DimIntialResiduals
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unsigned int "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimIntialResiduals()\n",
                                    " {\n",
                                    "   return 0;\n",
                                    " }"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end DimIntialResiduals;

public function SetIntialStatus
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setInitial(bool status)\n",
                                    " {\n",
                                    "   _initial = status;\n",
                                    " }"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end SetIntialStatus;

public function GetIntialStatus
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::initial()\n",
                                    " {\n",
                                    "   return _initial;\n",
                                    " }"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end GetIntialStatus;

protected function fun_728
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_op, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.LESS(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_STRING(varLst = _)),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_STRING(varLst = _)),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_STRING(varLst = _)),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_STRING(varLst = _)),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") || ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") || ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpRelation:ERR"));
      then txt;
  end matchcontinue;
end fun_728;

protected function fun_729
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_op, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           DAE.LESS(ty = DAE.T_BOOL(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_STRING(varLst = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_INTEGER(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_REAL(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_BOOL(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_STRING(varLst = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_INTEGER(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_REAL(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_BOOL(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_STRING(varLst = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_INTEGER(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_REAL(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_BOOL(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_STRING(varLst = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_INTEGER(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_REAL(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_BOOL(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_STRING(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_INTEGER(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_REAL(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_BOOL(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_STRING(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_INTEGER(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_REAL(varLst = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_conditions1["));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpRelationCondition:ERR"));
      then txt;
  end matchcontinue;
end fun_729;

protected function fun_730
  input Tpl.Text in_txt;
  input Integer in_a_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input DAE.Operator in_a_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_index, in_a_e2, in_a_e1, in_a_op)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      DAE.Operator a_op;
      Integer i_index;

    case ( txt,
           -1,
           a_e2,
           a_e1,
           a_op )
      equation
        txt = fun_728(txt, a_op, a_e2, a_e1);
      then txt;

    case ( txt,
           i_index,
           _,
           _,
           a_op )
      equation
        txt = fun_729(txt, a_op, i_index);
      then txt;
  end matchcontinue;
end fun_730;

public function daeExpRelation
  input Tpl.Text txt;
  input DAE.Operator a_op;
  input Integer a_index;
  input DAE.Exp a_exp1;
  input DAE.Exp a_exp2;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_e2;
  Tpl.Text l_e1;
algorithm
  (l_e1, out_a_preExp, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_exp1, a_context, a_preExp, a_varDecls, a_simCode);
  (l_e2, out_a_preExp, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_exp2, a_context, out_a_preExp, out_a_varDecls, a_simCode);
  out_txt := fun_730(txt, a_index, l_e2, l_e1, a_op);
end daeExpRelation;

public function daeExpIf
  input Tpl.Text txt;
  input DAE.Exp a_cond;
  input DAE.Exp a_then__;
  input DAE.Exp a_else__;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_resVar;
  Tpl.Text l_resVarType;
  Tpl.Text l_condVar;
  Tpl.Text l_eElse;
  Tpl.Text l_preExpElse;
  Tpl.Text l_eThen;
  Tpl.Text l_preExpThen;
  Tpl.Text l_condExp;
algorithm
  (l_condExp, out_a_preExp, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_cond, a_context, a_preExp, a_varDecls, a_simCode);
  l_preExpThen := Tpl.emptyTxt;
  (l_eThen, l_preExpThen, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_then__, a_context, l_preExpThen, out_a_varDecls, a_simCode);
  l_preExpElse := Tpl.emptyTxt;
  (l_eElse, l_preExpElse, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_else__, a_context, l_preExpElse, out_a_varDecls, a_simCode);
  (l_condVar, out_a_varDecls) := tempDecl(Tpl.emptyTxt, "bool", out_a_varDecls);
  l_resVarType := expTypeFromExpArrayIf(Tpl.emptyTxt, a_then__);
  (l_resVar, out_a_varDecls) := tempDecl(Tpl.emptyTxt, Tpl.textString(l_resVarType), out_a_varDecls);
  out_a_preExp := Tpl.writeText(out_a_preExp, l_condVar);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(" = "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_condExp);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING_LIST({
                                                 ";\n",
                                                 "if ("
                                             }, false));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_condVar);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_LINE(") {\n"));
  out_a_preExp := Tpl.pushBlock(out_a_preExp, Tpl.BT_INDENT(2));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_preExpThen);
  out_a_preExp := Tpl.softNewLine(out_a_preExp);
  out_a_preExp := Tpl.writeText(out_a_preExp, l_resVar);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(" = "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_eThen);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_LINE(";\n"));
  out_a_preExp := Tpl.popBlock(out_a_preExp);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_LINE("} else {\n"));
  out_a_preExp := Tpl.pushBlock(out_a_preExp, Tpl.BT_INDENT(2));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_preExpElse);
  out_a_preExp := Tpl.softNewLine(out_a_preExp);
  out_a_preExp := Tpl.writeText(out_a_preExp, l_resVar);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(" = "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_eElse);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_LINE(";\n"));
  out_a_preExp := Tpl.popBlock(out_a_preExp);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING("}"));
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_resVar);
end daeExpIf;

public function expTypeFromExpArrayIf
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExp(txt, a_exp);
end expTypeFromExpArrayIf;

public function expTypeFromExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_it)
    local
      Tpl.Text txt;
      DAE.Exp i_expr;
      DAE.Exp i_exp;
      DAE.Type i_ty;
      DAE.Type i_attr_ty;
      DAE.Exp i_expThen;
      DAE.Operator i_operator;

    case ( txt,
           DAE.ICONST(integer = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.RCONST(real = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.SCONST(string = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           DAE.BCONST(bool = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.BINARY(operator = i_operator) )
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.UNARY(operator = i_operator) )
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.LBINARY(operator = i_operator) )
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.LUNARY(operator = i_operator) )
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.RELATION(exp1 = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.IFEXP(expThen = i_expThen) )
      equation
        txt = expTypeFromExp(txt, i_expThen);
      then txt;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = i_attr_ty)) )
      equation
        txt = expTypeShort(txt, i_attr_ty);
      then txt;

    case ( txt,
           DAE.ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MATRIX(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.RANGE(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.CAST(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.CREF(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.CODE(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.ASUB(exp = i_exp) )
      equation
        txt = expTypeFromExp(txt, i_exp);
      then txt;

    case ( txt,
           DAE.REDUCTION(expr = i_expr) )
      equation
        txt = expTypeFromExp(txt, i_expr);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expTypeFromExp:ERROR"));
      then txt;
  end matchcontinue;
end expTypeFromExp;

public function expTypeFromOp
  input Tpl.Text in_txt;
  input DAE.Operator in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_it)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           DAE.ADD(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.SUB(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.DIV(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.UMINUS(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.UMINUS_ARR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.ADD_ARR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.SUB_ARR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_ARR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.DIV_ARR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_ARRAY_SCALAR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.ADD_ARRAY_SCALAR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.SUB_SCALAR_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_SCALAR_PRODUCT(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_MATRIX_PRODUCT(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.DIV_ARRAY_SCALAR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.DIV_SCALAR_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW_ARRAY_SCALAR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW_SCALAR_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW_ARR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW_ARR2(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.LESS(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.GREATER(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.EQUAL(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.AND(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.OR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.NOT(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expTypeFromOp:ERROR"));
      then txt;
  end matchcontinue;
end expTypeFromOp;

protected function lm_736
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_736(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_736(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_736;

public function equationAlgorithm
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<DAE.Statement> i_statements;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = i_statements),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_736(txt, i_statements, a_simCode, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end equationAlgorithm;

protected function lm_738
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_it;

    case ( txt,
           {},
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_it :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_it, a_context, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_738(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_738(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_738;

protected function lm_739
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_739(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_739(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_739;

protected function lm_740
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_740(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_740(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_740;

public function algStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_it;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_it, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Statement i_it;
      DAE.Exp i_msg;
      DAE.Exp i_cond;
      DAE.Statement i_s;
      DAE.Ident i_iter;
      DAE.Exp i_rng;
      Boolean i_iterIsArray;
      DAE.Type i_type__;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_componentRef_ident;
      list<DAE.Subscript> i_subs;
      DAE.Exp i_exp1;
      DAE.Exp i_exp;
      DAE.Exp i_e;
      Tpl.Text l_msgExp;
      Tpl.Text l_var;
      Tpl.Text l_stmtStr;
      Tpl.Text l_identTypeShort;
      Tpl.Text l_identType;
      Tpl.Text l_condExp;
      Tpl.Text l_spec;
      Tpl.Text l_expPart2;
      Tpl.Text l_expPart1;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = DAE.CREF(componentRef = DAE.WILD()), exp = i_e),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(componentRef = _)), exp = i_exp),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        (txt, l_preExp, a_varDecls) = scalarLhsCref(txt, i_exp1, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = i_exp1, exp = i_exp),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls, a_simCode);
        (l_expPart2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN_ARR(componentRef = DAE.CREF_IDENT(subscriptLst = (i_subs as _ :: _), ident = i_componentRef_ident), exp = i_exp),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        (l_spec, l_preExp, a_varDecls) = daeExpCrefRhsIndexSpec(Tpl.emptyTxt, i_subs, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeStr(txt, i_componentRef_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".AssignSpec("));
        txt = Tpl.writeText(txt, l_spec);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".A);"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN_ARR(exp = i_exp, componentRef = i_componentRef),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = contextCref(txt, i_componentRef, a_context, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_IF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_condExp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_738(txt, i_statementLst, a_simCode, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        (txt, l_preExp, a_varDecls) = elseExpr(txt, i_else__, a_context, l_preExp, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_FOR(range = (i_rng as DAE.RANGE(ty = _)), type_ = i_type__, iterIsArray = i_iterIsArray, statementLst = i_statementLst, iter = i_iter),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_identType = expType(Tpl.emptyTxt, i_type__, i_iterIsArray);
        l_identTypeShort = expTypeShort(Tpl.emptyTxt, i_type__);
        l_stmtStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_stmtStr, a_varDecls) = lm_739(l_stmtStr, i_statementLst, a_simCode, a_varDecls, a_context);
        l_stmtStr = Tpl.popIter(l_stmtStr);
        (txt, l_stmtStr, a_varDecls) = algStmtForRange_impl(txt, i_rng, i_iter, Tpl.textString(l_identType), Tpl.textString(l_identTypeShort), l_stmtStr, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_WHILE(exp = i_exp, statementLst = i_statementLst),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_var, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("while (1) {\n"));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (!"));
        txt = Tpl.writeText(txt, l_var);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") break;\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_740(txt, i_statementLst, a_simCode, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_TUPLE_ASSIGN(type_ = _)),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = algStmtTupleAssign(txt, i_s, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSERT(cond = i_cond, msg = i_msg),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_condExp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_cond, a_context, l_preExp, a_varDecls, a_simCode);
        (l_msgExp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_msg, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Assert("));
        txt = Tpl.writeText(txt, l_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_msgExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_TERMINATE(msg = _),
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_TERMINATE_NI"));
      then (txt, a_varDecls);

    case ( txt,
           (i_it as DAE.STMT_WHEN(exp = _)),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = algStmtWhen(txt, i_it, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           (i_it as DAE.STMT_FOR(type_ = _)),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = algStmtForGeneric(txt, i_it, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_BREAK(source = _),
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break; //break stmt"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_FAILURE(body = _),
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_FAILURE_NI"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_TRY(tryBody = _),
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_TRY_NI"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_CATCH(catchBody = _),
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_CATCH_NI"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_THROW(source = _),
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_THROW_NI"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_RETURN(source = _),
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_RETURN_NI"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_NORETCALL(exp = _),
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_NORETCALL_NI"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_REINIT(var = _),
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_REINIT_NI"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT_IMPLEMENTED_ALG_STATEMENT"));
      then (txt, a_varDecls);
  end matchcontinue;
end algStatement;

protected function lm_742
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_742(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_742(txt, rest);
      then txt;
  end matchcontinue;
end lm_742;

protected function lm_743
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_retStruct;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_afterExp, in_a_context, in_a_retStruct)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      Tpl.Text a_retStruct;
      Integer x_i1;
      DAE.Exp i_cr;
      Tpl.Text l_rhsStr;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_afterExp,
           _,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_cr :: rest,
           a_simCode,
           a_varDecls,
           a_afterExp,
           a_context,
           a_retStruct )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_rhsStr = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("get<"));
        l_rhsStr = Tpl.writeStr(l_rhsStr, intString(x_i1));
        l_rhsStr = Tpl.writeTok(l_rhsStr, Tpl.ST_STRING(">("));
        l_rhsStr = Tpl.writeText(l_rhsStr, a_retStruct);
        l_rhsStr = Tpl.writeTok(l_rhsStr, Tpl.ST_STRING(")"));
        (txt, a_afterExp, a_varDecls) = writeLhsCref(txt, i_cr, Tpl.textString(l_rhsStr), a_context, a_afterExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_743(txt, rest, a_simCode, a_varDecls, a_afterExp, a_context, a_retStruct);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_afterExp,
           a_context,
           a_retStruct )
      equation
        (txt, a_varDecls, a_afterExp) = lm_743(txt, rest, a_simCode, a_varDecls, a_afterExp, a_context, a_retStruct);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end lm_743;

public function algStmtTupleAssign
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Exp i_exp;
      list<DAE.Exp> i_expExpLst;
      Tpl.Text l_lhsCrefs;
      Tpl.Text l_retStruct;
      String ret_4;
      Tpl.Text l_marker;
      Tpl.Text l_crefs;
      Tpl.Text l_afterExp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_TUPLE_ASSIGN(exp = (i_exp as DAE.CALL(path = _)), expExpLst = i_expExpLst),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        l_afterExp = Tpl.emptyTxt;
        l_crefs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_crefs = lm_742(l_crefs, i_expExpLst);
        l_crefs = Tpl.popIter(l_crefs);
        l_marker = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("("));
        l_marker = Tpl.writeText(l_marker, l_crefs);
        l_marker = Tpl.writeTok(l_marker, Tpl.ST_STRING(") = "));
        ret_4 = ExpressionDump.printExpStr(i_exp);
        l_marker = Tpl.writeStr(l_marker, ret_4);
        l_preExp = Tpl.writeTok(l_preExp, Tpl.ST_STRING("/* algStmtTupleAssign: preExp buffer created for "));
        l_preExp = Tpl.writeText(l_preExp, l_marker);
        l_preExp = Tpl.writeTok(l_preExp, Tpl.ST_STRING(" */"));
        l_preExp = Tpl.writeTok(l_preExp, Tpl.ST_NEW_LINE());
        l_afterExp = Tpl.writeTok(l_afterExp, Tpl.ST_STRING("/* algStmtTupleAssign: afterExp buffer created for "));
        l_afterExp = Tpl.writeText(l_afterExp, l_marker);
        l_afterExp = Tpl.writeTok(l_afterExp, Tpl.ST_STRING(" */"));
        l_afterExp = Tpl.writeTok(l_afterExp, Tpl.ST_NEW_LINE());
        (l_retStruct, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        l_lhsCrefs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_lhsCrefs, a_varDecls, l_afterExp) = lm_743(l_lhsCrefs, i_expExpLst, a_simCode, a_varDecls, l_afterExp, a_context, l_retStruct);
        l_lhsCrefs = Tpl.popIter(l_lhsCrefs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* algStmtTupleAssign: preExp printout "));
        txt = Tpl.writeText(txt, l_marker);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("*/\n"));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* algStmtTupleAssign: writeLhsCref "));
        txt = Tpl.writeText(txt, l_marker);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" */\n"));
        txt = Tpl.writeText(txt, l_lhsCrefs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* algStmtTupleAssign: afterExp printout "));
        txt = Tpl.writeText(txt, l_marker);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" */\n"));
        txt = Tpl.writeText(txt, l_afterExp);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 5310, 12), "algStmtTupleAssign failed");
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtTupleAssign;

public function error
  input Tpl.Text txt;
  input Absyn.Info a_srcInfo;
  input String a_errMessage;

  output Tpl.Text out_txt;
protected
  String ret_0;
algorithm
  Tpl.addSourceTemplateError(a_errMessage, a_srcInfo);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "\n",
                                   "#error \""
                               }, false));
  ret_0 := Error.infoStr(a_srcInfo);
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" "));
  out_txt := Tpl.writeStr(out_txt, a_errMessage);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end error;

public function errorMsg
  input Tpl.Text txt;
  input String a_errMessage;

  output Tpl.Text out_txt;
algorithm
  Tpl.addTemplateError(a_errMessage);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "\n",
                                   "#error \""
                               }, false));
  out_txt := Tpl.writeStr(out_txt, a_errMessage);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end errorMsg;

protected function lm_747
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_747(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_747(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_747;

public function algStmtForGeneric
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Ident i_iter;
      DAE.Exp i_range;
      list<DAE.Statement> i_statementLst;
      Boolean i_iterIsArray;
      DAE.Type i_type__;
      Tpl.Text l_stmtStr;
      Tpl.Text l_arrayType;
      Tpl.Text l_iterType;

    case ( txt,
           DAE.STMT_FOR(type_ = i_type__, iterIsArray = i_iterIsArray, statementLst = i_statementLst, range = i_range, iter = i_iter),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_iterType = expType(Tpl.emptyTxt, i_type__, i_iterIsArray);
        l_arrayType = expTypeArray(Tpl.emptyTxt, i_type__);
        l_stmtStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_stmtStr, a_varDecls) = lm_747(l_stmtStr, i_statementLst, a_simCode, a_varDecls, a_context);
        l_stmtStr = Tpl.popIter(l_stmtStr);
        (txt, l_stmtStr, a_varDecls) = algStmtForGeneric_impl(txt, i_range, i_iter, Tpl.textString(l_iterType), Tpl.textString(l_arrayType), i_iterIsArray, l_stmtStr, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtForGeneric;

public function algStmtForGeneric_impl
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input Absyn.Ident a_iterator;
  input String a_type;
  input String a_arrayType;
  input Boolean a_iterIsArray;
  input Tpl.Text a_body;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_body;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_evar;
  Tpl.Text l_tmpVar;
  Tpl.Text l_preExp;
  Tpl.Text l_iterName;
algorithm
  l_iterName := contextIteratorName(Tpl.emptyTxt, a_iterator, a_context);
  l_preExp := Tpl.emptyTxt;
  l_tmpVar := Tpl.emptyTxt;
  (l_evar, l_preExp, l_tmpVar) := daeExp(Tpl.emptyTxt, a_exp, a_context, l_preExp, l_tmpVar, a_simCode);
  out_txt := Tpl.writeText(txt, l_preExp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeStr(out_txt, a_type);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" "));
  out_txt := Tpl.writeText(out_txt, l_iterName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(";\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(1));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("BOOST_FOREACH( short "));
  out_txt := Tpl.writeText(out_txt, l_iterName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(",  "));
  out_txt := Tpl.writeText(out_txt, l_evar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(" ){\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(3));
  out_txt := Tpl.writeText(out_txt, a_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" }"));
  out_txt := Tpl.popBlock(out_txt);
  out_a_body := a_body;
  out_a_varDecls := a_varDecls;
end algStmtForGeneric_impl;

protected function fun_750
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Absyn.Ident in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Ident a_name;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;
  end matchcontinue;
end fun_750;

public function contextIteratorName
  input Tpl.Text txt;
  input Absyn.Ident a_name;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_750(txt, a_context, a_name);
end contextIteratorName;

protected function lm_752
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_idx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_idx :: rest )
      equation
        txt = edgeHelpVar(txt, intString(i_idx));
        txt = Tpl.nextIter(txt);
        txt = lm_752(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_752(txt, rest);
      then txt;
  end matchcontinue;
end lm_752;

protected function lm_753
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_753(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_753(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_753;

protected function fun_754
  input Tpl.Text in_txt;
  input DAE.Statement in_a_when;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_when, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      Option<DAE.Statement> i_elseWhen;
      list<DAE.Statement> i_statementLst;
      list<Integer> i_helpVarIndices;

    case ( txt,
           DAE.STMT_WHEN(helpVarIndices = i_helpVarIndices, statementLst = i_statementLst, elseWhen = i_elseWhen),
           a_simCode,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "if ("
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_752(txt, i_helpVarIndices);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_753(txt, i_statementLst, a_simCode, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        (txt, a_varDecls) = algStatementWhenElse(txt, i_elseWhen, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_754;

protected function fun_755
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Statement in_a_when;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_context, in_a_when, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.Statement a_when;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.SIMULATION(genDiscrete = true)),
           a_when,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = fun_754(txt, a_when, a_simCode, a_varDecls, i_context);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_755;

public function algStmtWhen
  input Tpl.Text txt;
  input DAE.Statement a_when;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_755(txt, a_context, a_when, a_varDecls, a_simCode);
end algStmtWhen;

protected function lm_757
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_idx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_idx :: rest )
      equation
        txt = edgeHelpVar(txt, intString(i_idx));
        txt = Tpl.nextIter(txt);
        txt = lm_757(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_757(txt, rest);
      then txt;
  end matchcontinue;
end lm_757;

protected function lm_758
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, SimCode.contextSimulationDiscrete, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_758(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_758(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_758;

public function algStatementWhenElse
  input Tpl.Text in_txt;
  input Option<DAE.Statement> in_a_stmt;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Option<DAE.Statement> i_when_elseWhen;
      list<DAE.Statement> i_when_statementLst;
      list<Integer> i_when_helpVarIndices;
      Tpl.Text l_elseCondStr;

    case ( txt,
           SOME(DAE.STMT_WHEN(helpVarIndices = i_when_helpVarIndices, statementLst = i_when_statementLst, elseWhen = i_when_elseWhen)),
           a_varDecls,
           a_simCode )
      equation
        l_elseCondStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_elseCondStr = lm_757(l_elseCondStr, i_when_helpVarIndices);
        l_elseCondStr = Tpl.popIter(l_elseCondStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if ("));
        txt = Tpl.writeText(txt, l_elseCondStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_758(txt, i_when_statementLst, a_simCode, a_varDecls);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        (txt, a_varDecls) = algStatementWhenElse(txt, i_when_elseWhen, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end algStatementWhenElse;

public function edgeHelpVar
  input Tpl.Text txt;
  input String a_idx;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.edge(_event_handling["));
  out_txt := Tpl.writeStr(out_txt, a_idx);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("],\"h"));
  out_txt := Tpl.writeStr(out_txt, a_idx);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\")"));
end edgeHelpVar;

protected function fun_761
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_expOption;
  input Tpl.Text in_a_body;
  input Tpl.Text in_a_stopValue;
  input Tpl.Text in_a_startValue;
  input Tpl.Text in_a_iterName;
  input String in_a_type;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_expOption, in_a_body, in_a_stopValue, in_a_startValue, in_a_iterName, in_a_type, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_body;
      Tpl.Text a_stopValue;
      Tpl.Text a_startValue;
      Tpl.Text a_iterName;
      String a_type;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_eo;
      Tpl.Text l_stepValue;
      Tpl.Text l_stepVar;

    case ( txt,
           SOME(i_eo),
           a_body,
           a_stopValue,
           a_startValue,
           a_iterName,
           a_type,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        l_stepVar = Tpl.emptyTxt;
        (l_stepValue, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eo, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for("));
        txt = Tpl.writeStr(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_startValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";("));
        txt = Tpl.writeText(txt, l_stepValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > 0? "));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<="));
        txt = Tpl.writeText(txt, a_stopValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : "));
        txt = Tpl.writeText(txt, a_stopValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<="));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("); "));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" += "));
        txt = Tpl.writeText(txt, l_stepValue);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_body,
           a_stopValue,
           a_startValue,
           a_iterName,
           a_type,
           _,
           a_varDecls,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for("));
        txt = Tpl.writeStr(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_startValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<="));
        txt = Tpl.writeText(txt, a_stopValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" += 1) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_761;

protected function fun_762
  input Tpl.Text in_txt;
  input DAE.Exp in_a_range;
  input Absyn.Ident in_a_iterator;
  input String in_a_type;
  input Tpl.Text in_a_body;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_range, in_a_iterator, in_a_type, in_a_body, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Ident a_iterator;
      String a_type;
      Tpl.Text a_body;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Option<DAE.Exp> i_expOption;
      DAE.Exp i_range;
      DAE.Exp i_exp;
      Tpl.Text l_res;
      Tpl.Text l_stopValue;
      Tpl.Text l_startValue;
      Tpl.Text l_preExp;
      Tpl.Text l_stopVar;
      Tpl.Text l_iterName;

    case ( txt,
           DAE.RANGE(exp = i_exp, range = i_range, expOption = i_expOption),
           a_iterator,
           a_type,
           a_body,
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_iterName = Tpl.writeStr(Tpl.emptyTxt, a_iterator);
        l_stopVar = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        (l_startValue, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        (l_stopValue, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_range, a_context, l_preExp, a_varDecls, a_simCode);
        (l_res, a_varDecls) = tempDecl(Tpl.emptyTxt, a_type, a_varDecls);
        (txt, a_varDecls, l_preExp) = fun_761(txt, i_expOption, a_body, l_stopValue, l_startValue, l_iterName, a_type, a_simCode, a_varDecls, l_preExp, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_762;

public function algStmtForRange_impl
  input Tpl.Text txt;
  input DAE.Exp a_range;
  input Absyn.Ident a_iterator;
  input String a_type;
  input String a_shortType;
  input Tpl.Text a_body;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_body;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_762(txt, a_range, a_iterator, a_type, a_body, a_context, a_varDecls, a_simCode);
  out_a_body := a_body;
end algStmtForRange_impl;

protected function fun_764
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_lhsStr;
  input String in_a_rhsStr;
  input DAE.Type in_a_t;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_lhsStr, in_a_rhsStr, in_a_t)
    local
      Tpl.Text txt;
      Tpl.Text a_lhsStr;
      String a_rhsStr;
      DAE.Type a_t;

    case ( txt,
           SimCode.SIMULATION(genDiscrete = _),
           a_lhsStr,
           a_rhsStr,
           a_t )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = expTypeShort(txt, a_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data_mem(&"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_lhsStr,
           a_rhsStr,
           _ )
      equation
        txt = Tpl.writeText(txt, a_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_764;

protected function fun_765
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_lhsStr;
  input String in_a_rhsStr;
  input DAE.Type in_a_t;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_lhsStr, in_a_rhsStr, in_a_t)
    local
      Tpl.Text txt;
      Tpl.Text a_lhsStr;
      String a_rhsStr;
      DAE.Type a_t;

    case ( txt,
           SimCode.SIMULATION(genDiscrete = _),
           a_lhsStr,
           a_rhsStr,
           a_t )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("usub_"));
        txt = expTypeShort(txt, a_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array(&"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "copy_"
                                }, false));
        txt = expTypeShort(txt, a_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data_mem(&"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_lhsStr,
           a_rhsStr,
           _ )
      equation
        txt = Tpl.writeText(txt, a_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = -"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_765;

public function writeLhsCref
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input String in_a_rhsStr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_rhsStr, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      String a_rhsStr;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Exp i_e;
      DAE.Type i_t;
      DAE.Exp i_exp;
      String ret_1;
      Tpl.Text l_lhsStr;

    case ( txt,
           DAE.CREF(componentRef = DAE.WILD()),
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CREF(ty = (i_t as DAE.T_ARRAY(ty = _)))),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = fun_764(txt, a_context, l_lhsStr, a_rhsStr, i_t);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.UNARY(exp = (i_e as DAE.CREF(ty = (i_t as DAE.T_ARRAY(ty = _))))),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        txt = fun_765(txt, a_context, l_lhsStr, a_rhsStr, i_t);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CREF(componentRef = _)),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.UNARY(exp = (i_e as DAE.CREF(componentRef = _))),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = -"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           a_rhsStr,
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* SimCodeC.tpl template: writeLhsCref: UNHANDLED LHwwS\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* "));
        ret_1 = ExpressionDump.printExpStr(i_exp);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
        txt = Tpl.popBlock(txt);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end writeLhsCref;

protected function fun_767
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_ecr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_mArg, in_a_ecr_componentRef, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context, in_a_ecr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_ecr;

    case ( txt,
           false,
           _,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context,
           a_ecr )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs(txt, a_ecr, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_ecr_componentRef,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context,
           _ )
      equation
        txt = contextCref(txt, a_ecr_componentRef, a_context, a_simCode);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_767;

public function scalarLhsCref
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Exp i_ecr;
      DAE.ComponentRef i_ecr_componentRef;
      Boolean ret_0;

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = (i_ecr_componentRef as DAE.CREF_IDENT(subscriptLst = _)))),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        ret_0 = SimCode.crefNoSub(i_ecr_componentRef);
        (txt, a_varDecls, a_preExp) = fun_767(txt, ret_0, i_ecr_componentRef, a_simCode, a_varDecls, a_preExp, a_context, i_ecr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = (i_ecr_componentRef as DAE.CREF_QUAL(ident = _))),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        txt = contextCref(txt, i_ecr_componentRef, a_context, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ONLY_IDENT_OR_QUAL_CREF_SUPPORTED_SLHS"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end scalarLhsCref;

protected function lm_769
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_it;

    case ( txt,
           {},
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_it :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_it, a_context, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_769(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_769(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_769;

protected function lm_770
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_it;

    case ( txt,
           {},
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_it :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_it, a_context, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_770(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_770(txt, rest, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_770;

protected function fun_771
  input Tpl.Text in_txt;
  input DAE.Else in_a_it;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_it, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_condExp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.NOELSE(),
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           DAE.ELSEIF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_condExp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else {\n"));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_769(txt, i_statementLst, a_simCode, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        (txt, l_preExp, a_varDecls) = elseExpr(txt, i_else__, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.ELSE(statementLst = i_statementLst),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_770(txt, i_statementLst, a_simCode, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_771;

public function elseExpr
  input Tpl.Text txt;
  input DAE.Else a_it;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_771(txt, a_it, a_context, a_varDecls, a_simCode);
  out_a_preExp := a_preExp;
end elseExpr;

protected function fun_773
  input Tpl.Text in_txt;
  input Boolean in_a_isArray;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isArray, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;

    case ( txt,
           false,
           a_ty )
      equation
        txt = expTypeShort(txt, a_ty);
      then txt;

    case ( txt,
           _,
           a_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expType_"));
        txt = expTypeArray1(txt, a_ty, 0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_NOT_YET"));
      then txt;
  end matchcontinue;
end fun_773;

public function expType
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input Boolean a_isArray;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_773(txt, a_isArray, a_ty);
end expType;

public function expTypeArrayIf
  input Tpl.Text txt;
  input DAE.Type a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFlag(txt, a_ty, 4);
end expTypeArrayIf;

public function expTypeArray1
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input Integer a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("SimArray"));
  out_txt := Tpl.writeStr(out_txt, intString(a_dims));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("<"));
  out_txt := expTypeShort(out_txt, a_ty);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(">"));
  out_txt := Tpl.popBlock(out_txt);
end expTypeArray1;

public function functionOnlyZeroCrossing
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Te