encapsulated package CodegenQSS
"
  file:        CodegenQSS.mo
  package:     CodegenQSS
  description: Generated by Susan.
  
  $Id: CodegenQSS.mo 11174 2012-02-23 06:08:32Z adrpo $
"

public import Tpl;

public import SimCode;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import CodegenC;

protected function fun_28
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;
  input Tpl.Text in_a_guid;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simulationSettingsOpt, in_a_guid, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_guid;
      SimCode.SimCode a_simCode;
      Tpl.Text txt_0;

    case ( txt,
           NONE(),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_guid,
           a_simCode )
      equation
        txt_0 = CodegenC.simulationInitFile(Tpl.emptyTxt, a_simCode, Tpl.textString(a_guid));
        Tpl.textFile(txt_0, "model_init.xml");
      then txt;
  end matchcontinue;
end fun_28;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_qssInfo)
    local
      Tpl.Text txt;
      BackendQSS.QSSinfo a_qssInfo;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      list<DAE.Exp> i_literals;
      list<SimCode.RecordDeclaration> i_recordDecls;
      list<SimCode.Function> i_modelInfo_functions;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      String ret_1;
      Tpl.Text l_guid;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = i_modelInfo_functions), fileNamePrefix = i_fileNamePrefix, recordDecls = i_recordDecls, literals = i_literals, simulationSettingsOpt = i_simulationSettingsOpt)),
           a_qssInfo )
      equation
        ret_1 = System.getUUIDStr();
        l_guid = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        txt_2 = simulationFile(Tpl.emptyTxt, i_simCode, a_qssInfo, Tpl.textString(l_guid));
        Tpl.textFile(txt_2, "modelica_funcs.cpp");
        txt_3 = CodegenC.simulationFunctionsHeaderFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_recordDecls);
        Tpl.textFile(txt_3, "model_functions.h");
        txt_4 = simulationFunctionsFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_literals);
        Tpl.textFile(txt_4, "model_functions.c");
        txt_5 = CodegenC.recordsFile(Tpl.emptyTxt, i_fileNamePrefix, i_recordDecls);
        Tpl.textFile(txt_5, "model_records.c");
        txt_6 = simulationMakefile(Tpl.emptyTxt, i_simCode);
        txt_7 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_7 = Tpl.writeTok(txt_7, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_6, Tpl.textString(txt_7));
        txt_8 = structureFile(Tpl.emptyTxt, i_simCode, a_qssInfo);
        Tpl.textFile(txt_8, "modelica_structure.pds");
        txt = fun_28(txt, i_simulationSettingsOpt, l_guid, i_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end translateModel;

protected function lm_30
  input Tpl.Text in_txt;
  input list<BackendDAE.Var> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.Var> rest;
      Integer x_i0;
      BackendDAE.Var i_i;
      Boolean ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_i :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        ret_0 = BackendVariable.isStateVar(i_i);
        txt = Tpl.writeStr(txt, Tpl.booleanString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "break;"
                                }, false));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_30(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_30(txt, rest);
      then txt;
  end matchcontinue;
end lm_30;

protected function fun_31
  input Tpl.Text in_txt;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_qssInfo)
    local
      Tpl.Text txt;
      list<BackendDAE.Var> i_outVarLst;

    case ( txt,
           BackendQSS.QSSINFO(outVarLst = i_outVarLst) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_30(txt, i_outVarLst);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_31;

protected function lm_32
  input Tpl.Text in_txt;
  input list<BackendDAE.Var> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.Var> rest;
      Integer x_i0;
      BackendDAE.Var i_i;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_i :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        ret_0 = BackendVariable.varIndex(i_i);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "break;"
                                }, false));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_32(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_32(txt, rest);
      then txt;
  end matchcontinue;
end lm_32;

protected function fun_33
  input Tpl.Text in_txt;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_qssInfo)
    local
      Tpl.Text txt;
      list<BackendDAE.Var> i_outVarLst;

    case ( txt,
           BackendQSS.QSSINFO(outVarLst = i_outVarLst) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_32(txt, i_outVarLst);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_33;

protected function lm_34
  input Tpl.Text in_txt;
  input list<BackendDAE.Var> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.Var> rest;
      Integer x_i0;
      BackendDAE.Var i_i;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_i :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        ret_0 = BackendVariable.varIndex(i_i);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "break;"
                                }, false));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_34(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_34(txt, rest);
      then txt;
  end matchcontinue;
end lm_34;

protected function fun_35
  input Tpl.Text in_txt;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_qssInfo)
    local
      Tpl.Text txt;
      list<BackendDAE.Var> i_outVarLst;

    case ( txt,
           BackendQSS.QSSINFO(outVarLst = i_outVarLst) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_34(txt, i_outVarLst);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_35;

public function simulationFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input BackendQSS.QSSinfo in_a_qssInfo;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_qssInfo, in_a_guid)
    local
      Tpl.Text txt;
      BackendQSS.QSSinfo a_qssInfo;
      String a_guid;
      list<DAE.ComponentRef> i_discreteModelVars;
      list<SimCode.SimEqSystem> i_removedEquations;
      list<SimCode.SimEqSystem> i_algebraicEquations;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_startValueEquations;
      SimCode.DelayedExpression i_delayedExps;
      list<SimCode.SimEqSystem> i_sampleEquations;
      list<SimCode.SampleCondition> i_sampleConditions;
      SimCode.ExtObjInfo i_extObjInfo;
      list<SimCode.HelpVarInfo> i_helpVarInfo;
      list<SimCode.SimWhenClause> i_whenClauses;
      Integer i_modelInfo_varInfo_numStateVars;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      Integer i_modelInfo_varInfo_numZeroCrossings;
      list<String> i_externalFunctionIncludes;
      list<SimCode.SimEqSystem> i_residualEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      String i_fileNamePrefix;
      SimCode.ModelInfo i_modelInfo;
      String i_modelInfo_directory;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      list<SimCode.SimWhenClause> ret_5;
      list<Integer> ret_4;
      list<Integer> ret_3;
      list<list<Integer>> ret_2;
      list<SimCode.SimEqSystem> ret_1;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = i_modelInfo_varInfo_numZeroCrossings, numStateVars = i_modelInfo_varInfo_numStateVars), name = i_modelInfo_name, directory = i_modelInfo_directory)), fileNamePrefix = i_fileNamePrefix, jacobianMatrixes = i_jacobianMatrixes, allEquations = i_allEquations, residualEquations = i_residualEquations, externalFunctionIncludes = i_externalFunctionIncludes, odeEquations = i_odeEquations, zeroCrossings = i_zeroCrossings, whenClauses = i_whenClauses, helpVarInfo = i_helpVarInfo, extObjInfo = i_extObjInfo, sampleConditions = i_sampleConditions, sampleEquations = i_sampleEquations, delayedExps = i_delayedExps, startValueEquations = i_startValueEquations, parameterEquations = i_parameterEquations, algebraicEquations = i_algebraicEquations, removedEquations = i_removedEquations, discreteModelVars = i_discreteModelVars)),
           a_qssInfo,
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include \"model_functions.c\"\n",
                                    "#define _OMC_SEED_HACK\n",
                                    "#define _OMC_SEED_HACK_2\n",
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "\n",
                                    "#ifdef _OMC_QSS\n",
                                    "extern \"C\" { // adrpo: this is needed for Visual C++ compilation to work!\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *model_name=\""));
        txt = CodegenC.dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "const char *model_fileprefix=\"model\";\n",
                                    "const char *model_dir=\""
                                }, false));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "#endif\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = globalData(txt, i_modelInfo, i_fileNamePrefix, a_guid);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_0 = SimCode.appendAllequations(i_jacobianMatrixes);
        ret_1 = SimCode.appendLists(ret_0, i_allEquations);
        txt = equationInfo(txt, ret_1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitialResidual(txt, i_residualEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionExtraResiduals(txt, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = externalFunctionIncludes(txt, i_externalFunctionIncludes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "int measure_time_flag = 1;\n",
                                    "#else\n",
                                    "int measure_time_flag = 0;\n",
                                    "#endif\n",
                                    "\n",
                                    "// fbergero, xfloros: Code for QSS methods\n",
                                    "#ifdef _OMC_QSS\n",
                                    "\n",
                                    "bool isState(int i)\n",
                                    "{\n",
                                    "  switch (i)\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = fun_31(txt, a_qssInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n",
                                    "int algNumber(int i)\n",
                                    "{\n",
                                    "  switch (i)\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = fun_33(txt, a_qssInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n",
                                    "int stateNumber(int i)\n",
                                    "{\n",
                                    "  switch (i)\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = fun_35(txt, a_qssInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n",
                                    "int\n",
                                    "startInteractiveSimulation(int, char**);\n",
                                    "int\n",
                                    "startNonInteractiveSimulation(int, char**);\n",
                                    "int\n",
                                    "initRuntimeAndSimulation(int, char**);\n"
                                }, true));
        ret_2 = BackendQSS.generateConnections(a_qssInfo);
        txt = generateIncidenceMatrix(txt, ret_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("extern int interactiveSimulation;\n"));
        ret_3 = BackendQSS.getAllInputs(a_qssInfo);
        txt = generateInputVars(txt, ret_3);
        txt = Tpl.softNewLine(txt);
        ret_4 = BackendQSS.getAllOutputs(a_qssInfo);
        txt = generateOutputVars(txt, ret_4);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef _OMC_OMPD_MAIN\n",
                                    "int\n",
                                    "main(int argc, char**argv)\n",
                                    "{\n",
                                    "  int retVal = -1;\n",
                                    "\n",
                                    "  if (initRuntimeAndSimulation(argc, argv)) //initRuntimeAndSimulation returns 1 if an error occurs\n",
                                    "    return 1;\n",
                                    "\n",
                                    "  if (interactiveSimulation) {\n",
                                    "    //cout << \"startInteractiveSimulation: \" << version << endl;\n",
                                    "    retVal = startInteractiveSimulation(argc, argv);\n",
                                    "  } else {\n",
                                    "    //cout << \"startNonInteractiveSimulation: \" << version << endl;\n",
                                    "    retVal = startNonInteractiveSimulation(argc, argv);\n",
                                    "  }\n",
                                    "\n",
                                    "  deInitializeDataStruc(globalData);\n",
                                    "  free(globalData);\n",
                                    "  fflush(NULL);\n",
                                    "  EXIT(retVal);\n",
                                    "}\n",
                                    "#endif\n",
                                    "\n",
                                    "#define condition_rettype bool\n",
                                    "void init_ompd();\n",
                                    "void clean_ompd();\n",
                                    "\n",
                                    "bool cond["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_modelInfo_varInfo_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "];\n",
                                    "\n",
                                    "void set_condition_to(unsigned int c, bool b) { cond[c]=b; }\n",
                                    "bool condition(unsigned int c) { return cond[c]; }\n",
                                    "\n",
                                    "//for QSS solver\n",
                                    "double rel_accuracy = 1e-5;\n",
                                    "double abs_accuracy = 1e-5;\n",
                                    "char* method = (char*)\"QSS3\";\n",
                                    "\n",
                                    "double state_values(int state)\n",
                                    "{\n",
                                    "  switch (state)\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = generateStateValues(txt, a_qssInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n",
                                    "double quantum_values(int state)\n",
                                    "{\n",
                                    "  return 0.0;\n",
                                    "}\n",
                                    "\n",
                                    "// integration method\n",
                                    "char* int_method() {\n",
                                    "  return method;\n",
                                    "}\n",
                                    "\n",
                                    "// settings\n",
                                    "double function_rel_acc() {\n",
                                    "  return rel_accuracy;\n",
                                    "}\n",
                                    "\n",
                                    "double function_abs_acc() {\n",
                                    "  return abs_accuracy;\n",
                                    "}\n",
                                    "\n",
                                    "int init_runtime()\n",
                                    "{\n",
                                    "  static bool init=false;\n",
                                    "  if (!init)\n",
                                    "  {\n",
                                    "    init=true;\n",
                                    "    init_ompd();\n",
                                    "  }\n",
                                    "  return 0;\n",
                                    "}\n",
                                    "\n",
                                    "void clean_runtime()\n",
                                    "{\n",
                                    "  static bool clean=false;\n",
                                    "  if (!clean)\n",
                                    "  {\n",
                                    "    clean=true;\n",
                                    "    clean_ompd();\n",
                                    "  }\n",
                                    "}\n"
                                }, true));
        txt = functionQssStaticBlocks(txt, i_odeEquations, i_zeroCrossings, a_qssInfo, i_modelInfo_varInfo_numStateVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_5 = BackendQSS.replaceCondWhens(i_whenClauses, i_helpVarInfo, i_zeroCrossings);
        txt = functionQssWhen(txt, ret_5, i_helpVarInfo, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionQssSample(txt, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionQssUpdateDiscrete(txt, i_allEquations, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt = functionSetLocalData(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitializeDataStruc(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCallExternalObjectConstructors(txt, i_extObjInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionDeInitializeDataStruc(txt, i_extObjInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionOutput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitSample(txt, i_sampleConditions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionSampleEquations(txt, i_sampleEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionStoreDelayed(txt, i_delayedExps);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitial(txt, i_startValueEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionBoundParameters(txt, i_parameterEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        (txt, _) = functionODE(txt, i_odeEquations, Tpl.strTokText(Tpl.ST_STRING("")));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionAlgebraic(txt, i_algebraicEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionAliasEquation(txt, i_removedEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionDAE(txt, i_allEquations, i_whenClauses, i_helpVarInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionOnlyZeroCrossing(txt, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCheckForDiscreteChanges(txt, i_discreteModelVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = generateLinearMatrixes(txt, i_jacobianMatrixes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionlinearmodel(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end simulationFile;

protected function fun_37
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_connections;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_connections, in_a_qssInfo)
    local
      Tpl.Text txt;
      Tpl.Text a_connections;
      BackendQSS.QSSinfo a_qssInfo;
      list<SimCode.HelpVarInfo> i_helpVarInfo;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      Integer i_varInfo_numStateVars;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars)), zeroCrossings = i_zeroCrossings, whenClauses = i_whenClauses, helpVarInfo = i_helpVarInfo),
           a_connections,
           a_qssInfo )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Root-Coordinator\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = generateIntegrators(txt, i_varInfo_numStateVars);
        txt = Tpl.softNewLine(txt);
        txt = generateStaticBlocks(txt, a_qssInfo, i_varInfo_numStateVars);
        txt = Tpl.softNewLine(txt);
        txt = generateZeroCrossingFunctions(txt, i_zeroCrossings, a_qssInfo, i_varInfo_numStateVars);
        txt = Tpl.softNewLine(txt);
        txt = generateCrossingDetector(txt, i_zeroCrossings, a_qssInfo);
        txt = Tpl.softNewLine(txt);
        txt = generateWhenBlocks(txt, i_whenClauses, i_helpVarInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Simulator\n",
                                    "  {\n",
                                    "    Path = modelica/outvars.h\n",
                                    "    Parameters = 0.0\n",
                                    "  }\n",
                                    "EIC\n",
                                    "  {\n",
                                    "  }\n",
                                    "EIC\n",
                                    "  {\n",
                                    "  }\n",
                                    "IC\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_connections);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  }\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_37;

public function structureFile
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input BackendQSS.QSSinfo a_qssInfo;

  output Tpl.Text out_txt;
protected
  list<list<Integer>> ret_2;
  Tpl.Text l_connections;
  Tpl.Text l_models;
algorithm
  l_models := Tpl.emptyTxt;
  ret_2 := BackendQSS.generateConnections(a_qssInfo);
  l_connections := generateConnections(Tpl.emptyTxt, ret_2);
  out_txt := fun_37(txt, a_simCode, l_connections, a_qssInfo);
end structureFile;

public function functionQssSample
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_sampleCode;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_sampleCode, l_varDecls) := functionQssSample2(Tpl.emptyTxt, a_zeroCrossings, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "void functionQssSample(unsigned int sampleIndex, double *out)\n",
                                   "{\n",
                                   "  state mem_state;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "mem_state = get_memory_state();\n",
                                       "switch (sampleIndex)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_sampleCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "restore_memory_state(mem_state);\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionQssSample;

protected function lm_40
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_interval;
      DAE.Exp i_start;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {i_start, i_interval})) :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = functionQssSample3(txt, x_i0, i_start, i_interval, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_40(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_40(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_40;

public function functionQssSample2
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_40(out_txt, a_zeroCrossings, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end functionQssSample2;

public function functionQssSample3
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_start;
  input DAE.Exp a_interval;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_e2;
  Tpl.Text l_e1;
  Tpl.Text l_preExp;
algorithm
  l_preExp := Tpl.emptyTxt;
  (l_e1, l_preExp, out_a_varDecls) := CodegenC.daeExp(Tpl.emptyTxt, a_start, SimCode.contextOther, l_preExp, a_varDecls);
  (l_e2, l_preExp, out_a_varDecls) := CodegenC.daeExp(Tpl.emptyTxt, a_interval, SimCode.contextOther, l_preExp, out_a_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("case "));
  out_txt := Tpl.writeStr(out_txt, intString(a_index1));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(":\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_preExp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("out[0] = "));
  out_txt := Tpl.writeText(out_txt, l_e1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ";\n",
                                       "out[1] = "
                                   }, false));
  out_txt := Tpl.writeText(out_txt, l_e2);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ";\n",
                                       "break;"
                                   }, false));
  out_txt := Tpl.popBlock(out_txt);
end functionQssSample3;

public function functionQssWhen
  input Tpl.Text txt;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.HelpVarInfo> a_helpVars;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_whenCases;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_whenCases, l_varDecls) := functionQssWhen2(Tpl.emptyTxt, a_whenClauses, a_helpVars, l_varDecls, a_zeroCrossings);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "bool functionQssWhen(unsigned int whenIndex, double t,double *out, double *in)\n",
                                   "{\n",
                                   "  state mem_state;\n",
                                   "  time = t;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "mem_state = get_memory_state();\n",
                                       "switch (whenIndex)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(3));
  out_txt := Tpl.writeText(out_txt, l_whenCases);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "return false;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionQssWhen;

protected function lm_44
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_zeroCrossings, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      Tpl.Text a_varDecls;
      Integer x_i0;
      Option<BackendDAE.WhenEquation> i_whenEq;
      list<BackendDAE.WhenOperator> i_reinits;
      list<tuple<DAE.Exp, Integer>> i_conditions;
      Tpl.Text l_equations;
      Tpl.Text l_cond;
      Tpl.Text l_saves;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(conditions = i_conditions, reinits = i_reinits, whenEq = i_whenEq) :: rest,
           a_zeroCrossings,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        l_saves = Tpl.emptyTxt;
        (l_cond, a_varDecls, l_preExp) = functionPreWhenCondition(Tpl.emptyTxt, i_conditions, a_varDecls, l_preExp, a_zeroCrossings);
        (l_equations, a_varDecls) = generateWhenEquations(Tpl.emptyTxt, i_reinits, i_whenEq, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":\n",
                                    "  #ifdef _OMC_OMPD\n",
                                    "  // Read inputs from in[]\n",
                                    "  #endif\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_cond);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_equations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_saves);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "restore_memory_state(mem_state);\n",
                                    "return true;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("} else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeText(txt, l_saves);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  restore_memory_state(mem_state);\n",
                                    "  return false;\n",
                                    "}\n",
                                    "break;"
                                }, false));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_44(txt, rest, a_zeroCrossings, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_zeroCrossings,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_44(txt, rest, a_zeroCrossings, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_44;

public function functionQssWhen2
  input Tpl.Text txt;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.HelpVarInfo> a_helpVars;
  input Tpl.Text a_varDecls;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_44(out_txt, a_whenClauses, a_zeroCrossings, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end functionQssWhen2;

protected function fun_46
  input Tpl.Text in_txt;
  input Option<BackendDAE.WhenEquation> in_a_whenEq;
  input list<BackendDAE.WhenOperator> in_a_reinits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_whenEq, in_a_reinits, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.WhenOperator> a_reinits;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_left;
      DAE.Exp i_right;
      Tpl.Text l_exp;
      Tpl.Text l_preExp;

    case ( txt,
           SOME(BackendDAE.WHEN_EQ(right = i_right, left = i_left)),
           a_reinits,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_exp, l_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_right, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = CodegenC.cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  = "));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        (txt, a_varDecls) = generateReinits(txt, a_reinits, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           NONE(),
           a_reinits,
           a_varDecls )
      equation
        (txt, a_varDecls) = generateReinits(txt, a_reinits, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_46;

public function generateWhenEquations
  input Tpl.Text txt;
  input list<BackendDAE.WhenOperator> a_reinits;
  input Option<BackendDAE.WhenEquation> a_whenEq;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_46(txt, a_whenEq, a_reinits, a_varDecls);
end generateWhenEquations;

protected function lm_48
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.WhenOperator> rest;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.REINIT(stateVar = i_stateVar, value = i_value) :: rest,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = CodegenC.cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // Reinit of var "));
        txt = CodegenC.cref(txt, i_stateVar);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_48(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_48(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_48;

public function generateReinits
  input Tpl.Text txt;
  input list<BackendDAE.WhenOperator> a_reinits;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_48(out_txt, a_reinits, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end generateReinits;

protected function fun_50
  input Tpl.Text in_txt;
  input DAE.Exp in_a_e;
  input Integer in_a_hvar;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_e, in_a_hvar, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_hvar;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_e;
      Integer i_i;
      Tpl.Text l_helpInit;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "samplecondition"), expLst = {DAE.ICONST(integer = i_i)}),
           _,
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("condition("));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_e,
           a_hvar,
           a_varDecls,
           a_preExp )
      equation
        (l_helpInit, a_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_e, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("localData->helpVars["));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_hvar));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("] = "));
        a_preExp = Tpl.writeText(a_preExp, l_helpInit);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "\n"
                                          }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->helpVars["));
        txt = Tpl.writeStr(txt, intString(a_hvar));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !localData->helpVars_saved["));
        txt = Tpl.writeStr(txt, intString(a_hvar));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer i_hvar;
      DAE.Exp i_e;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hvar) :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = fun_50(txt, i_e, i_hvar, a_varDecls, a_preExp);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_51(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_51(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_51;

public function functionPreWhenCondition
  input Tpl.Text txt;
  input list<tuple<DAE.Exp, Integer>> a_conditions;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_preExp;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls, out_a_preExp) := lm_51(out_txt, a_conditions, a_varDecls, a_preExp);
  out_txt := Tpl.popIter(out_txt);
end functionPreWhenCondition;

protected function fun_53
  input Tpl.Text in_txt;
  input BackendQSS.QSSinfo in_a_qssInfo;
  input list<list<SimCode.SimEqSystem>> in_a_derivativEquations;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;
  input Integer in_a_nStates;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_qssInfo, in_a_derivativEquations, in_a_zeroCrossings, in_a_nStates)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> a_derivativEquations;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      Integer a_nStates;
      list<BackendDAE.Var> i_outVarLst;
      BackendQSS.DevsStruct i_DEVSstructure;
      list<list<SimCode.SimEqSystem>> i_eqs;
      Integer ret_12;
      Tpl.Text l_zeroCross;
      Tpl.Text l_staticFun;
      Integer ret_9;
      Tpl.Text l_numZeroCross;
      Integer ret_7;
      Tpl.Text l_numPureStatic;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Tpl.Text l_numStatic;
      Tpl.Text l_tmp;
      Tpl.Text l_varDecls;

    case ( txt,
           BackendQSS.QSSINFO(eqs = i_eqs, DEVSstructure = i_DEVSstructure, outVarLst = i_outVarLst),
           a_derivativEquations,
           a_zeroCrossings,
           a_nStates )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_tmp = Tpl.emptyTxt;
        ret_3 = listLength(i_eqs);
        ret_4 = listLength(a_zeroCrossings);
        ret_5 = intAdd(ret_3, ret_4);
        l_numStatic = Tpl.writeStr(Tpl.emptyTxt, intString(ret_5));
        ret_7 = listLength(i_eqs);
        l_numPureStatic = Tpl.writeStr(Tpl.emptyTxt, intString(ret_7));
        ret_9 = listLength(a_zeroCrossings);
        l_numZeroCross = Tpl.writeStr(Tpl.emptyTxt, intString(ret_9));
        (l_staticFun, l_varDecls, l_tmp) = generateStaticFunc(Tpl.emptyTxt, a_derivativEquations, a_zeroCrossings, l_varDecls, i_DEVSstructure, i_eqs, i_outVarLst, a_nStates, l_tmp);
        ret_12 = listLength(i_eqs);
        (l_zeroCross, l_varDecls) = generateZeroCrossingsEq(Tpl.emptyTxt, ret_12, a_zeroCrossings, l_varDecls, i_DEVSstructure, i_outVarLst, a_nStates);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int staticBlocks = "));
        txt = Tpl.writeText(txt, l_numStatic);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "int staticPureBlocks = "
                                }, false));
        txt = Tpl.writeText(txt, l_numPureStatic);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "int zeroCrossings = "
                                }, false));
        txt = Tpl.writeText(txt, l_numZeroCross);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void function_staticBlocks(int staticFunctionIndex, double t, double *in, double *out)\n",
                                    "{\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Number of Static blocks: "));
        txt = Tpl.writeText(txt, l_numStatic);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "time = t;\n",
                                    "mem_state = get_memory_state();\n",
                                    "switch (staticFunctionIndex)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_staticFun);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("// Start of zero crossings functions\n"));
        txt = Tpl.writeText(txt, l_zeroCross);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "restore_memory_state(mem_state);\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_53;

public function functionQssStaticBlocks
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_derivativEquations;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input BackendQSS.QSSinfo a_qssInfo;
  input Integer a_nStates;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_53(txt, a_qssInfo, a_derivativEquations, a_zeroCrossings, a_nStates);
end functionQssStaticBlocks;

protected function lm_55
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input list<BackendDAE.Var> in_a_varLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_varLst)
    local
      Tpl.Text txt;
      list<Integer> rest;
      list<BackendDAE.Var> a_varLst;
      Integer x_i0;
      Integer i_i;
      DAE.ComponentRef ret_5;
      BackendDAE.Var ret_4;
      Integer ret_3;
      String ret_2;
      BackendDAE.Var ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_i :: rest,
           a_varLst )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Output "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" is var "));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] =  "));
        ret_0 = intAdd(i_i, -1);
        ret_1 = listNth(a_varLst, ret_0);
        ret_2 = BackendQSS.derPrefix(ret_1);
        txt = Tpl.writeStr(txt, ret_2);
        ret_3 = intAdd(i_i, -1);
        ret_4 = listNth(a_varLst, ret_3);
        ret_5 = BackendVariable.varCref(ret_4);
        txt = CodegenC.cref(txt, ret_5);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_55(txt, rest, a_varLst);
      then txt;

    case ( txt,
           _ :: rest,
           a_varLst )
      equation
        txt = lm_55(txt, rest, a_varLst);
      then txt;
  end matchcontinue;
end lm_55;

public function generateOutputs
  input Tpl.Text txt;
  input BackendQSS.DevsStruct a_devsst;
  input Integer a_index;
  input list<BackendDAE.Var> a_varLst;
  input Integer a_nStates;

  output Tpl.Text out_txt;
protected
  list<Integer> ret_2;
  Integer ret_1;
  Integer ret_0;
algorithm
  ret_0 := intAdd(1, a_nStates);
  ret_1 := intAdd(a_index, ret_0);
  ret_2 := BackendQSS.getOutputs(a_devsst, ret_1);
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_55(out_txt, ret_2, a_varLst);
  out_txt := Tpl.popIter(out_txt);
end generateOutputs;

protected function lm_57
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input list<BackendDAE.Var> in_a_varLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_varLst)
    local
      Tpl.Text txt;
      list<Integer> rest;
      list<BackendDAE.Var> a_varLst;
      Integer x_i0;
      Integer i_i;
      DAE.ComponentRef ret_2;
      BackendDAE.Var ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_i :: rest,
           a_varLst )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Input "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" is var "));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.softNewLine(txt);
        ret_0 = intAdd(i_i, -1);
        ret_1 = listNth(a_varLst, ret_0);
        ret_2 = BackendVariable.varCref(ret_1);
        txt = CodegenC.cref(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = in["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_57(txt, rest, a_varLst);
      then txt;

    case ( txt,
           _ :: rest,
           a_varLst )
      equation
        txt = lm_57(txt, rest, a_varLst);
      then txt;
  end matchcontinue;
end lm_57;

public function generateInputs
  input Tpl.Text txt;
  input BackendQSS.DevsStruct a_devsst;
  input Integer a_index;
  input list<BackendDAE.Var> a_varLst;
  input Integer a_nStates;

  output Tpl.Text out_txt;
protected
  list<Integer> ret_0;
algorithm
  ret_0 := BackendQSS.getInputs(a_devsst, a_index);
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_57(out_txt, ret_0, a_varLst);
  out_txt := Tpl.popIter(out_txt);
end generateInputs;

protected function lm_59
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls, in_a_zeroCrossings)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      SimCode.SimEqSystem i_eq;
      SimCode.SimEqSystem ret_0;

    case ( txt,
           {},
           a_tmp,
           a_varDecls,
           _ )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls,
           a_zeroCrossings )
      equation
        ret_0 = BackendQSS.replaceZC(i_eq, a_zeroCrossings);
        (txt, a_varDecls, a_tmp) = CodegenC.equation_(txt, ret_0, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_59(txt, rest, a_tmp, a_varDecls, a_zeroCrossings);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls,
           a_zeroCrossings )
      equation
        (txt, a_tmp, a_varDecls) = lm_59(txt, rest, a_tmp, a_varDecls, a_zeroCrossings);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_59;

protected function lm_60
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;
  input list<BackendDAE.Var> in_a_varLst;
  input Integer in_a_nStates;
  input BackendQSS.DevsStruct in_a_devsst;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls, in_a_zeroCrossings, in_a_varLst, in_a_nStates, in_a_devsst)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      list<BackendDAE.Var> a_varLst;
      Integer a_nStates;
      BackendQSS.DevsStruct a_devsst;
      Integer x_i0;
      list<SimCode.SimEqSystem> i_eqs;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           a_tmp,
           a_varDecls,
           _,
           _,
           _,
           _ )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_tmp,
           a_varDecls,
           a_zeroCrossings,
           a_varLst,
           a_nStates,
           a_devsst )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "case "
                                }, false));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":\n",
                                    "  {\n",
                                    "  // Read inputs from in[]\n",
                                    "  #ifdef _OMC_OMPD\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_0 = intAdd(x_i0, a_nStates);
        ret_1 = intAdd(ret_0, 1);
        txt = generateInputs(txt, a_devsst, ret_1, a_varLst, a_nStates);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endif\n",
                                    "\n",
                                    "// Evalute the static function\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_tmp, a_varDecls) = lm_59(txt, i_eqs, a_tmp, a_varDecls, a_zeroCrossings);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "// Write outputs to out[]\n",
                                    "#ifdef _OMC_OMPD\n"
                                }, true));
        txt = generateOutputs(txt, a_devsst, x_i0, a_varLst, a_nStates);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endif\n",
                                    "break;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_60(txt, rest, a_tmp, a_varDecls, a_zeroCrossings, a_varLst, a_nStates, a_devsst);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls,
           a_zeroCrossings,
           a_varLst,
           a_nStates,
           a_devsst )
      equation
        (txt, a_tmp, a_varDecls) = lm_60(txt, rest, a_tmp, a_varDecls, a_zeroCrossings, a_varLst, a_nStates, a_devsst);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_60;

public function generateStaticFunc
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_odeEq;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;
  input BackendQSS.DevsStruct a_devsst;
  input list<list<SimCode.SimEqSystem>> a_BLTblocks;
  input list<BackendDAE.Var> a_varLst;
  input Integer a_nStates;
  input Tpl.Text a_tmp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_tmp;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_tmp, out_a_varDecls) := lm_60(out_txt, a_BLTblocks, a_tmp, a_varDecls, a_zeroCrossings, a_varLst, a_nStates, a_devsst);
  out_txt := Tpl.popIter(out_txt);
end generateStaticFunc;

public function generateRelation
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;
  input String in_a_e1;
  input String in_a_e2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_op, in_a_e1, in_a_e2)
    local
      Tpl.Text txt;
      String a_e1;
      String a_e2;

    case ( txt,
           DAE.LESS(ty = _),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeStr(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeStr(txt, a_e2);
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeStr(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeStr(txt, a_e2);
      then txt;

    case ( txt,
           DAE.GREATER(ty = _),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeStr(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeStr(txt, a_e1);
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeStr(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeStr(txt, a_e1);
      then txt;

    case ( txt,
           DAE.EQUAL(ty = _),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeStr(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeStr(txt, a_e2);
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = _),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeStr(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeStr(txt, a_e1);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end generateRelation;

public function generateZCExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      Tpl.Text txt_3;
      String ret_3;
      Tpl.Text l_sub;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           DAE.RELATION(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e1, a_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_exp2, a_context, a_preExp, a_varDecls);
        l_sub = generateRelation(Tpl.emptyTxt, i_operator, Tpl.textString(l_e1), Tpl.textString(l_e2));
        txt = Tpl.writeText(txt, l_sub);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample")),
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_3 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unhandled expression in SimCodeQSS.generateZCExp: "));
        ret_3 = ExpressionDump.printExpStr(i_exp);
        txt_3 = Tpl.writeStr(txt_3, ret_3);
        txt = CodegenC.error(txt, Tpl.sourceInfo("CodegenQSS.tpl", 612, 14), Tpl.textString(txt_3));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end generateZCExp;

protected function fun_64
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relation__;
  input Tpl.Text in_a_zcExp;
  input Tpl.Text in_a_preExp;
  input list<BackendDAE.Var> in_a_varLst;
  input Integer in_a_nStates;
  input BackendQSS.DevsStruct in_a_devsst;
  input Integer in_a_offset;
  input Integer in_a_i0;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_relation__, in_a_zcExp, in_a_preExp, in_a_varLst, in_a_nStates, in_a_devsst, in_a_offset, in_a_i0)
    local
      Tpl.Text txt;
      Tpl.Text a_zcExp;
      Tpl.Text a_preExp;
      list<BackendDAE.Var> a_varLst;
      Integer a_nStates;
      BackendQSS.DevsStruct a_devsst;
      Integer a_offset;
      Integer a_i0;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample")),
           _,
           _,
           _,
           _,
           _,
           a_offset,
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "case "
                                }, false));
        ret_0 = intAdd(a_i0, a_offset);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":\n",
                                    "  // This zero crossing is a sample. This case should not be called\n",
                                    "  break;"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_zcExp,
           a_preExp,
           a_varLst,
           a_nStates,
           a_devsst,
           a_offset,
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "case "
                                }, false));
        ret_1 = intAdd(a_i0, a_offset);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":\n",
                                    "  {\n",
                                    "  #ifdef _OMC_OMPD\n",
                                    "  // Read inputs from in[]\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_2 = intAdd(1, a_nStates);
        ret_3 = intAdd(a_i0, ret_2);
        ret_4 = intAdd(a_offset, ret_3);
        txt = generateInputs(txt, a_devsst, ret_4, a_varLst, a_nStates);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endif\n",
                                    "// Evalute the ZeroCrossing function\n"
                                }, true));
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Write outputs to out[]\n",
                                    "out[0] = "
                                }, false));
        txt = Tpl.writeText(txt, a_zcExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "break;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_64;

protected function lm_65
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input list<BackendDAE.Var> in_a_varLst;
  input Integer in_a_nStates;
  input BackendQSS.DevsStruct in_a_devsst;
  input Integer in_a_offset;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varLst, in_a_nStates, in_a_devsst, in_a_offset, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      list<BackendDAE.Var> a_varLst;
      Integer a_nStates;
      BackendQSS.DevsStruct a_devsst;
      Integer a_offset;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_relation__;
      Tpl.Text l_zcExp;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest,
           a_varLst,
           a_nStates,
           a_devsst,
           a_offset,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_zcExp, l_preExp, a_varDecls) = generateZCExp(Tpl.emptyTxt, i_relation__, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = fun_64(txt, i_relation__, l_zcExp, l_preExp, a_varLst, a_nStates, a_devsst, a_offset, x_i0);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_65(txt, rest, a_varLst, a_nStates, a_devsst, a_offset, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varLst,
           a_nStates,
           a_devsst,
           a_offset,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_65(txt, rest, a_varLst, a_nStates, a_devsst, a_offset, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_65;

public function generateZeroCrossingsEq
  input Tpl.Text txt;
  input Integer a_offset;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;
  input BackendQSS.DevsStruct a_devsst;
  input list<BackendDAE.Var> a_varLst;
  input Integer a_nStates;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_65(out_txt, a_zeroCrossings, a_varLst, a_nStates, a_devsst, a_offset, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end generateZeroCrossingsEq;

protected function lm_67
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_zeroCrossings)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      SimCode.SimEqSystem i_eq;
      SimCode.SimEqSystem ret_0;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_varDecls,
           a_zeroCrossings )
      equation
        ret_0 = BackendQSS.replaceZC(i_eq, a_zeroCrossings);
        (txt, a_varDecls) = generateDiscUpdate(txt, ret_0, a_zeroCrossings, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_67(txt, rest, a_varDecls, a_zeroCrossings);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_zeroCrossings )
      equation
        (txt, a_varDecls) = lm_67(txt, rest, a_varDecls, a_zeroCrossings);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_67;

public function functionQssUpdateDiscrete
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqs;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_eqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqs, l_varDecls) := lm_67(l_eqs, a_allEquationsPlusWhen, l_varDecls, a_zeroCrossings);
  l_eqs := Tpl.popIter(l_eqs);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "void function_updateDepend(double t, int index)\n",
                                   "{\n",
                                   "  state mem_state;\n",
                                   "  time = t;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("mem_state = get_memory_state();\n"));
  out_txt := Tpl.writeText(out_txt, l_eqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("restore_memory_state(mem_state);\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionQssUpdateDiscrete;

protected function lm_69
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preDisc;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref) :: rest,
           a_varDecls )
      equation
        l_preDisc = Tpl.emptyTxt;
        (l_expPart, l_preDisc, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_exp, SimCode.contextSimulationDiscrete, l_preDisc, a_varDecls);
        txt = Tpl.writeText(txt, l_preDisc);
        txt = Tpl.softNewLine(txt);
        txt = CodegenC.cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_69(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_69(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_69;

protected function fun_70
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> i_discEqs;
      Tpl.Text l_disc;

    case ( txt,
           SimCode.SES_MIXED(discEqs = i_discEqs),
           a_varDecls )
      equation
        l_disc = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_disc, a_varDecls) = lm_69(l_disc, i_discEqs, a_varDecls);
        l_disc = Tpl.popIter(l_disc);
        txt = Tpl.writeText(txt, l_disc);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_70;

public function generateDiscUpdate
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_70(txt, a_eq, a_varDecls);
end generateDiscUpdate;

protected function lm_72
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Simulator\n",
                                    "  {\n",
                                    "    Path = modelica/modelica_qss_integrator.h\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Parameters = "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".0 // Index\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
        txt = Tpl.nextIter(txt);
        txt = lm_72(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_72(txt, rest);
      then txt;
  end matchcontinue;
end lm_72;

public function generateIntegrators
  input Tpl.Text txt;
  input Integer a_nStates;

  output Tpl.Text out_txt;
protected
  list<Integer> ret_0;
algorithm
  ret_0 := List.fill(0, a_nStates);
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_72(out_txt, ret_0);
  out_txt := Tpl.popIter(out_txt);
end generateIntegrators;

protected function lm_74
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input Integer in_a_nStates;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_nStates, in_a_qssInfo)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Integer a_nStates;
      BackendQSS.QSSinfo a_qssInfo;
      Integer x_i0;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_nStates,
           a_qssInfo )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Simulator\n",
                                    "  {\n",
                                    "    Path = modelica/modelica_qss_static.h\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Parameters = "));
        ret_0 = intAdd(1, a_nStates);
        ret_1 = intAdd(x_i0, ret_0);
        ret_2 = BackendQSS.numInputs(a_qssInfo, ret_1);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".0, "));
        ret_3 = intAdd(1, a_nStates);
        ret_4 = intAdd(x_i0, ret_3);
        ret_5 = BackendQSS.numOutputs(a_qssInfo, ret_4);
        txt = Tpl.writeStr(txt, intString(ret_5));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".0, "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".0 // Inputs, Outputs, Index\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
        txt = Tpl.nextIter(txt);
        txt = lm_74(txt, rest, a_nStates, a_qssInfo);
      then txt;

    case ( txt,
           _ :: rest,
           a_nStates,
           a_qssInfo )
      equation
        txt = lm_74(txt, rest, a_nStates, a_qssInfo);
      then txt;
  end matchcontinue;
end lm_74;

public function generateStaticBlocks
  input Tpl.Text in_txt;
  input BackendQSS.QSSinfo in_a_qssInfo;
  input Integer in_a_nStates;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_qssInfo, in_a_nStates)
    local
      Tpl.Text txt;
      Integer a_nStates;
      BackendQSS.QSSinfo i_qssInfo;
      list<list<SimCode.SimEqSystem>> i_eqs;

    case ( txt,
           (i_qssInfo as BackendQSS.QSSINFO(DEVSstructure = BackendQSS.DEVS_STRUCT(outLinks = _), eqs = i_eqs)),
           a_nStates )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_74(txt, i_eqs, a_nStates, i_qssInfo);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end generateStaticBlocks;

protected function lm_76
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input BackendQSS.QSSinfo in_a_qssInfo;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input Integer in_a_nStates;
  input list<list<SimCode.SimEqSystem>> in_a_eqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_qssInfo, in_a_varDecls, in_a_preExp, in_a_nStates, in_a_eqs)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      BackendQSS.QSSinfo a_qssInfo;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer a_nStates;
      list<list<SimCode.SimEqSystem>> a_eqs;
      Integer x_i0;
      DAE.Exp i_relation__;
      Integer ret_9;
      Integer ret_8;
      Integer ret_7;
      Integer ret_6;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = (i_relation__ as DAE.RELATION(exp1 = _))) :: rest,
           a_qssInfo,
           a_varDecls,
           a_preExp,
           a_nStates,
           a_eqs )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Simulator // Block # "));
        ret_0 = listLength(a_eqs);
        ret_1 = intAdd(ret_0, a_nStates);
        ret_2 = intAdd(ret_1, x_i0);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Path = modelica/modelica_qss_static.h // Crossing function "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" for "));
        (txt, a_preExp, a_varDecls) = CodegenC.daeExp(txt, i_relation__, SimCode.contextOther, a_preExp, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Parameters = "));
        ret_3 = listLength(a_eqs);
        ret_4 = intAdd(a_nStates, 1);
        ret_5 = intAdd(ret_3, ret_4);
        ret_6 = intAdd(x_i0, ret_5);
        ret_7 = BackendQSS.numInputs(a_qssInfo, ret_6);
        txt = Tpl.writeStr(txt, intString(ret_7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".0, 1.0, "));
        ret_8 = listLength(a_eqs);
        ret_9 = intAdd(x_i0, ret_8);
        txt = Tpl.writeStr(txt, intString(ret_9));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".0 // Inputs, Outputs, Index\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_76(txt, rest, a_qssInfo, a_varDecls, a_preExp, a_nStates, a_eqs);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_qssInfo,
           a_varDecls,
           a_preExp,
           a_nStates,
           a_eqs )
      equation
        (txt, a_varDecls, a_preExp) = lm_76(txt, rest, a_qssInfo, a_varDecls, a_preExp, a_nStates, a_eqs);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_76;

protected function fun_77
  input Tpl.Text in_txt;
  input BackendQSS.QSSinfo in_a_qssInfo;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;
  input Integer in_a_nStates;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_qssInfo, in_a_zeroCrossings, in_a_nStates)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      Integer a_nStates;
      BackendQSS.QSSinfo i_qssInfo;
      list<list<SimCode.SimEqSystem>> i_eqs;
      Tpl.Text l_preExp;
      Integer ret_2;
      Tpl.Text l_numStatic;
      Tpl.Text l_varDecls;

    case ( txt,
           (i_qssInfo as BackendQSS.QSSINFO(eqs = i_eqs)),
           a_zeroCrossings,
           a_nStates )
      equation
        l_varDecls = Tpl.emptyTxt;
        ret_2 = listLength(i_eqs);
        l_numStatic = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_preExp = Tpl.emptyTxt;
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varDecls, l_preExp) = lm_76(txt, a_zeroCrossings, i_qssInfo, l_varDecls, l_preExp, a_nStates, i_eqs);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_77;

public function generateZeroCrossingFunctions
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input BackendQSS.QSSinfo a_qssInfo;
  input Integer a_nStates;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_77(txt, a_qssInfo, a_zeroCrossings, a_nStates);
end generateZeroCrossingFunctions;

protected function lm_79
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer x_i0;
      DAE.Exp i_relation__;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = (i_relation__ as DAE.RELATION(exp1 = _))) :: rest,
           a_varDecls,
           a_preExp )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Simulator\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Path = modelica/modelica_qss_cross_detect.h // Crossing detector "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" for "));
        (txt, a_preExp, a_varDecls) = CodegenC.daeExp(txt, i_relation__, SimCode.contextOther, a_preExp, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Parameters = "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".0\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_79(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_79(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_79;

protected function fun_80
  input Tpl.Text in_txt;
  input BackendQSS.QSSinfo in_a_qssInfo;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_qssInfo, in_a_zeroCrossings)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> a_zeroCrossings;
      list<list<SimCode.SimEqSystem>> i_eqs;
      Tpl.Text l_preExp;
      Integer ret_2;
      Tpl.Text l_numStatic;
      Tpl.Text l_varDecls;

    case ( txt,
           BackendQSS.QSSINFO(eqs = i_eqs),
           a_zeroCrossings )
      equation
        l_varDecls = Tpl.emptyTxt;
        ret_2 = listLength(i_eqs);
        l_numStatic = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_preExp = Tpl.emptyTxt;
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varDecls, l_preExp) = lm_79(txt, a_zeroCrossings, l_varDecls, l_preExp);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_80;

public function generateCrossingDetector
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input BackendQSS.QSSinfo a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_80(txt, a_qssInfo, a_zeroCrossings);
end generateCrossingDetector;

protected function lm_82
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Simulator\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Path = modelica/modelica_when_discrete.h // When clause "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Parameters = (double)("));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("),2.0,3.0\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
        txt = Tpl.nextIter(txt);
        txt = lm_82(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_82(txt, rest);
      then txt;
  end matchcontinue;
end lm_82;

public function generateWhenBlocks
  input Tpl.Text txt;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.HelpVarInfo> a_helpVars;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_82(out_txt, a_whenClauses);
  out_txt := Tpl.popIter(out_txt);
end generateWhenBlocks;

protected function lm_84
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer x_i0;
      DAE.Exp i_interval;
      DAE.Exp i_start;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {i_start, i_interval})) :: rest,
           a_varDecls,
           a_preExp )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_e1, a_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_start, SimCode.contextOther, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_interval, SimCode.contextOther, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Simulator\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Path = modelica/modelica_sample.h // Sample block "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" for sample("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "Parameters = (double)("
                                }, false));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_84(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_84(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_84;

public function generateSampleBlocks
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_preExp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_preExp := Tpl.emptyTxt;
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, l_varDecls, l_preExp) := lm_84(out_txt, a_zeroCrossings, l_varDecls, l_preExp);
  out_txt := Tpl.popIter(out_txt);
end generateSampleBlocks;

protected function lm_86
  input Tpl.Text in_txt;
  input list<list<Integer>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<Integer>> rest;
      list<Integer> i_c;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_c :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        ret_0 = listNth(i_c, 0);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_1 = listNth(i_c, 1);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") ; ("));
        ret_2 = listNth(i_c, 2);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_3 = listNth(i_c, 3);
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_86(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_86(txt, rest);
      then txt;
  end matchcontinue;
end lm_86;

public function generateConnections
  input Tpl.Text txt;
  input list<list<Integer>> a_conns;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_86(out_txt, a_conns);
  out_txt := Tpl.popIter(out_txt);
end generateConnections;

protected function lm_88
  input Tpl.Text in_txt;
  input list<BackendDAE.Var> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.Var> rest;
      Integer x_i0;
      BackendDAE.Var i_var;
      DAE.ComponentRef ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return  "));
        ret_0 = BackendVariable.varCref(i_var);
        txt = CodegenC.cref(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_88(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_88(txt, rest);
      then txt;
  end matchcontinue;
end lm_88;

public function generateStateValues
  input Tpl.Text txt;
  input BackendQSS.QSSinfo a_qssInfo;

  output Tpl.Text out_txt;
protected
  list<BackendDAE.Var> ret_0;
algorithm
  ret_0 := BackendQSS.getStates(a_qssInfo);
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_88(out_txt, ret_0);
  out_txt := Tpl.popIter(out_txt);
end generateStateValues;

protected function fun_90
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end matchcontinue;
end fun_90;

protected function lm_91
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_91(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_91(txt, rest);
      then txt;
  end matchcontinue;
end lm_91;

protected function fun_92
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_92;

protected function fun_93
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end matchcontinue;
end fun_93;

protected function fun_94
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end matchcontinue;
end fun_94;

protected function fun_95
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER"));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_95;

protected function fun_96
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_94(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_95(txt, i_s_method);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -D_OMC_OMPD_LIB -D_OMC_OMPD_MAIN"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_96;

protected function fun_97
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "OSX" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lf2c"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-Wl,-Bstatic -lf2c -Wl,-Bdynamic"));
      then txt;
  end matchcontinue;
end fun_97;

public function simulationMakefile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      String i_makefileParams_senddatalibs;
      String i_makefileParams_ldflags;
      String i_makefileParams_cflags;
      String i_makefileParams_omhome;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      String ret_5;
      Tpl.Text l_extraCflags;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, omhome = i_makefileParams_omhome, cflags = i_makefileParams_cflags, ldflags = i_makefileParams_ldflags, senddatalibs = i_makefileParams_senddatalibs), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix) )
      equation
        l_dirExtra = fun_90(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_91(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_92(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_93(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_extraCflags = fun_96(Tpl.emptyTxt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O3 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=\n",
                                    "CC="
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS_BASED_ON_INIT_FILE="));
        txt = Tpl.writeText(txt, l_extraCflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS=$(CFLAGS_BASED_ON_INIT_FILE) -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc\" "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " -D_OMC_QSS -g -D_OMC_OMPD\n",
                                    "LDFLAGS=-L\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -lSimulationRuntimeQss "));
        txt = Tpl.writeStr(txt, i_makefileParams_ldflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SENDDATALIBS="));
        txt = Tpl.writeStr(txt, i_makefileParams_senddatalibs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "PERL=perl\n",
                                    "\n",
                                    ".PHONY: "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".conv.cpp model_functions.c model_functions.h model_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CXX) -I. -o "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(EXEEXT) "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv.cpp model_functions.c "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CFLAGS) $(LDFLAGS) -linteractive $(SENDDATALIBS) "));
        ret_5 = System.os();
        txt = fun_97(txt, ret_5);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" model_records.c\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".conv.cpp: modelica_funcs.cpp\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(PERL) "));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/share/omc/scripts/convert_lines.pl $< $@.tmp\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" @mv $@.tmp $@"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end simulationMakefile;

public function simulationFileHeader
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), extObjInfo = SimCode.EXTOBJINFO(vars = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Simulation code for "));
        txt = CodegenC.dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
        ret_0 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".\n",
                                    "\n",
                                    "#include \"modelica.h\"\n",
                                    "#include \"assert.h\"\n",
                                    "#include \"string.h\"\n",
                                    "#include \"simulation_runtime.h\"\n",
                                    "\n",
                                    "#include \"model_functions.h\"\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end simulationFileHeader;

protected function lm_100
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = CodegenC.literalExpConst(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_100(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_100(txt, rest);
      then txt;
  end matchcontinue;
end lm_100;

public function simulationFunctionsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "#include \"model_functions.h\"\n",
                                   "extern \"C\" {\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_100(out_txt, a_literals);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := CodegenC.functionBodies(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "\n"
                                   }, true));
end simulationFunctionsFile;

protected function lm_102
  input Tpl.Text in_txt;
  input list<list<Integer>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<Integer>> rest;
      list<Integer> i_c;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_c :: rest )
      equation
        ret_0 = listNth(i_c, 0);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_1 = listNth(i_c, 2);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.nextIter(txt);
        txt = lm_102(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_102(txt, rest);
      then txt;
  end matchcontinue;
end lm_102;

public function generateIncidenceMatrix
  input Tpl.Text txt;
  input list<list<Integer>> a_conns;

  output Tpl.Text out_txt;
protected
  Integer ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("int incidenceRows = "));
  ret_0 := listLength(a_conns);
  out_txt := Tpl.writeStr(out_txt, intString(ret_0));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ";\n",
                                       "int incidenceMatrix[] = { "
                                   }, false));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_102(out_txt, a_conns);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" };"));
end generateIncidenceMatrix;

protected function lm_104
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_i;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_i :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.nextIter(txt);
        txt = lm_104(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_104(txt, rest);
      then txt;
  end matchcontinue;
end lm_104;

public function generateInputVars
  input Tpl.Text txt;
  input list<Integer> a_vars__tuple;

  output Tpl.Text out_txt;
protected
  Integer ret_1;
  Integer ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("int inputMatrix[] = { "));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_104(out_txt, a_vars__tuple);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       " };\n",
                                       "int inputRows = "
                                   }, false));
  ret_0 := listLength(a_vars__tuple);
  ret_1 := intDiv(ret_0, 2);
  out_txt := Tpl.writeStr(out_txt, intString(ret_1));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(";"));
end generateInputVars;

protected function lm_106
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_i;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_i :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.nextIter(txt);
        txt = lm_106(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_106(txt, rest);
      then txt;
  end matchcontinue;
end lm_106;

public function generateOutputVars
  input Tpl.Text txt;
  input list<Integer> a_vars__tuple;

  output Tpl.Text out_txt;
protected
  Integer ret_1;
  Integer ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("int outputMatrix[] = { "));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_106(out_txt, a_vars__tuple);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       " };\n",
                                       "int outputRows = "
                                   }, false));
  ret_0 := listLength(a_vars__tuple);
  ret_1 := intDiv(ret_0, 2);
  out_txt := Tpl.writeStr(out_txt, intString(ret_1));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(";"));
end generateOutputVars;

protected function lm_108
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "states");
        txt = Tpl.nextIter(txt);
        txt = lm_108(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_108(txt, rest);
      then txt;
  end matchcontinue;
end lm_108;

protected function lm_109
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "statesDerivatives");
        txt = Tpl.nextIter(txt);
        txt = lm_109(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_109(txt, rest);
      then txt;
  end matchcontinue;
end lm_109;

protected function lm_110
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_110(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_110(txt, rest);
      then txt;
  end matchcontinue;
end lm_110;

protected function lm_111
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_111(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_111(txt, rest);
      then txt;
  end matchcontinue;
end lm_111;

protected function lm_112
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "extObjs");
        txt = Tpl.nextIter(txt);
        txt = lm_112(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_112(txt, rest);
      then txt;
  end matchcontinue;
end lm_112;

protected function lm_113
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "intVariables.algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_113(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_113(txt, rest);
      then txt;
  end matchcontinue;
end lm_113;

protected function lm_114
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "intVariables.parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_114(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_114(txt, rest);
      then txt;
  end matchcontinue;
end lm_114;

protected function lm_115
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "boolVariables.algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_115(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_115(txt, rest);
      then txt;
  end matchcontinue;
end lm_115;

protected function lm_116
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "boolVariables.parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_116(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_116(txt, rest);
      then txt;
  end matchcontinue;
end lm_116;

protected function lm_117
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "stringVariables.algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_117(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_117(txt, rest);
      then txt;
  end matchcontinue;
end lm_117;

protected function lm_118
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "stringVariables.parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_118(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_118(txt, rest);
      then txt;
  end matchcontinue;
end lm_118;

protected function lm_119
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "jacobianVars");
        txt = Tpl.nextIter(txt);
        txt = lm_119(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_119(txt, rest);
      then txt;
  end matchcontinue;
end lm_119;

protected function lm_120
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      Integer x_i0;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = CodegenC.functionName(txt, i_fn, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_index "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.nextIter(txt);
        txt = lm_120(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_120(txt, rest);
      then txt;
  end matchcontinue;
end lm_120;

protected function lm_121
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_121(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_121(txt, rest);
      then txt;
  end matchcontinue;
end lm_121;

protected function lm_122
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_122(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_122(txt, rest);
      then txt;
  end matchcontinue;
end lm_122;

protected function lm_123
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_123(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_123(txt, rest);
      then txt;
  end matchcontinue;
end lm_123;

protected function lm_124
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_124(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_124(txt, rest);
      then txt;
  end matchcontinue;
end lm_124;

protected function lm_125
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_125(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_125(txt, rest);
      then txt;
  end matchcontinue;
end lm_125;

protected function lm_126
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_126(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_126(txt, rest);
      then txt;
  end matchcontinue;
end lm_126;

protected function lm_127
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_127(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_127(txt, rest);
      then txt;
  end matchcontinue;
end lm_127;

protected function lm_128
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_128(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_128(txt, rest);
      then txt;
  end matchcontinue;
end lm_128;

protected function smf_129
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_129;

protected function smf_130
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_130;

protected function smf_131
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_131;

protected function smf_132
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_132;

protected function smf_133
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_133;

protected function smf_134
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_134;

protected function smf_135
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_135;

protected function smf_136
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_136;

protected function lm_137
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue, name = i_name) :: rest )
      equation
        txt = globalDataHasNominalValue(txt, i_nominalValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_137(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_137(txt, rest);
      then txt;
  end matchcontinue;
end lm_137;

protected function lm_138
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue, name = i_name) :: rest )
      equation
        txt = globalDataHasNominalValue(txt, i_nominalValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_138(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_138(txt, rest);
      then txt;
  end matchcontinue;
end lm_138;

protected function lm_139
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue, name = i_name) :: rest )
      equation
        txt = globalDataHasNominalValue(txt, i_nominalValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_139(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_139(txt, rest);
      then txt;
  end matchcontinue;
end lm_139;

protected function smf_140
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_140;

protected function smf_141
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_141;

protected function smf_142
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_142;

protected function lm_143
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue, name = i_name) :: rest )
      equation
        txt = globalDataNominalValue(txt, i_nominalValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_143(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_143(txt, rest);
      then txt;
  end matchcontinue;
end lm_143;

protected function lm_144
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue, name = i_name) :: rest )
      equation
        txt = globalDataNominalValue(txt, i_nominalValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_144(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_144(txt, rest);
      then txt;
  end matchcontinue;
end lm_144;

protected function lm_145
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue, name = i_name) :: rest )
      equation
        txt = globalDataNominalValue(txt, i_nominalValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_145(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_145(txt, rest);
      then txt;
  end matchcontinue;
end lm_145;

protected function smf_146
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_146;

protected function smf_147
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_147;

protected function smf_148
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_148;

protected function lm_149
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.Type i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_149(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_149(txt, rest);
      then txt;
  end matchcontinue;
end lm_149;

protected function lm_150
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.Type i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_150(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_150(txt, rest);
      then txt;
  end matchcontinue;
end lm_150;

protected function lm_151
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.Type i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_151(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_151(txt, rest);
      then txt;
  end matchcontinue;
end lm_151;

protected function lm_152
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.Type i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_152(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_152(txt, rest);
      then txt;
  end matchcontinue;
end lm_152;

protected function lm_153
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.Type i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_153(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_153(txt, rest);
      then txt;
  end matchcontinue;
end lm_153;

protected function lm_154
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.Type i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_154(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_154(txt, rest);
      then txt;
  end matchcontinue;
end lm_154;

protected function lm_155
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.Type i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_155(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_155(txt, rest);
      then txt;
  end matchcontinue;
end lm_155;

protected function lm_156
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.Type i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_156(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_156(txt, rest);
      then txt;
  end matchcontinue;
end lm_156;

protected function lm_157
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.Type i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = CodegenC.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_157(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_157(txt, rest);
      then txt;
  end matchcontinue;
end lm_157;

protected function smf_158
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_158;

protected function smf_159
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_159;

protected function smf_160
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_160;

protected function smf_161
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_161;

protected function smf_162
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_162;

protected function smf_163
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_163;

protected function smf_164
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_164;

protected function smf_165
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_165;

protected function smf_166
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_166;

protected function fun_167
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input String in_a_fileNamePrefix;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo, in_a_fileNamePrefix, in_a_guid)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;
      String a_guid;
      list<SimCode.SimVar> i_vars_extObjVars;
      list<SimCode.SimVar> i_vars_jacobianVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;
      String i_directory;
      Absyn.Path i_name;
      Integer i_varInfo_numJacobianVars;
      Integer i_varInfo_numBoolParams;
      Integer i_varInfo_numBoolAliasVars;
      Integer i_varInfo_numBoolAlgVars;
      Integer i_varInfo_numIntParams;
      Integer i_varInfo_numIntAliasVars;
      Integer i_varInfo_numIntAlgVars;
      Integer i_varInfo_numStringParamVars;
      Integer i_varInfo_numStringAliasVars;
      Integer i_varInfo_numStringAlgVars;
      list<SimCode.Function> i_functions;
      Integer i_varInfo_numExternalObjects;
      Integer i_varInfo_numResiduals;
      Integer i_varInfo_numInVars;
      Integer i_varInfo_numOutVars;
      Integer i_varInfo_numParams;
      Integer i_varInfo_numAlgAliasVars;
      Integer i_varInfo_numAlgVars;
      Integer i_varInfo_numStateVars;
      Integer i_varInfo_numTimeEvents;
      Integer i_varInfo_numZeroCrossings;
      Integer i_varInfo_numHelpVars;
      Tpl.Text txt_23;
      Tpl.Text txt_22;
      Tpl.Text txt_21;
      Tpl.Text txt_20;
      Tpl.Text txt_19;
      Tpl.Text txt_18;
      Tpl.Text txt_17;
      Tpl.Text txt_16;
      Tpl.Text txt_15;
      Tpl.Text txt_14;
      Tpl.Text txt_13;
      Tpl.Text txt_12;
      Tpl.Text txt_11;
      Tpl.Text txt_10;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Integer ret_0;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numHelpVars = i_varInfo_numHelpVars, numZeroCrossings = i_varInfo_numZeroCrossings, numTimeEvents = i_varInfo_numTimeEvents, numStateVars = i_varInfo_numStateVars, numAlgVars = i_varInfo_numAlgVars, numAlgAliasVars = i_varInfo_numAlgAliasVars, numParams = i_varInfo_numParams, numOutVars = i_varInfo_numOutVars, numInVars = i_varInfo_numInVars, numResiduals = i_varInfo_numResiduals, numExternalObjects = i_varInfo_numExternalObjects, numStringAlgVars = i_varInfo_numStringAlgVars, numStringAliasVars = i_varInfo_numStringAliasVars, numStringParamVars = i_varInfo_numStringParamVars, numIntAlgVars = i_varInfo_numIntAlgVars, numIntAliasVars = i_varInfo_numIntAliasVars, numIntParams = i_varInfo_numIntParams, numBoolAlgVars = i_varInfo_numBoolAlgVars, numBoolAliasVars = i_varInfo_numBoolAliasVars, numBoolParams = i_varInfo_numBoolParams, numJacobianVars = i_varInfo_numJacobianVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, jacobianVars = i_vars_jacobianVars, extObjVars = i_vars_extObjVars), functions = i_functions, name = i_name, directory = i_directory),
           a_fileNamePrefix,
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define MODEL_GUID  \"{"));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\" // to check if the init file match the model!\n",
                                    "#define NHELP "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numHelpVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of helper vars\n",
                                    "#define NG "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of zero crossings\n",
                                    "#define NG_SAM "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numTimeEvents));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of zero crossings that are samples\n",
                                    "#define NX "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  // number of states\n",
                                    "#define NY "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  // number of real variables\n",
                                    "#define NA "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  // number of alias variables\n",
                                    "#define NP "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of parameters\n",
                                    "#define NO "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of outputvar on topmodel\n",
                                    "#define NI "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of inputvar on topmodel\n",
                                    "#define NR "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numResiduals));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of residuals for initialialization function\n",
                                    "#define NEXT "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numExternalObjects));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of external objects\n",
                                    "#define NFUNC "
                                }, false));
        ret_0 = listLength(i_functions);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of functions used by the simulation\n",
                                    "#define MAXORD 5\n",
                                    "#define NYSTR "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of alg. string variables\n",
                                    "#define NASTR "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of alias string variables\n",
                                    "#define NPSTR "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of string parameters\n",
                                    "#define NYINT "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of alg. int variables\n",
                                    "#define NAINT "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of alias int variables\n",
                                    "#define NPINT "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of int parameters\n",
                                    "#define NYBOOL "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of alg. bool variables\n",
                                    "#define NABOOL "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of alias bool variables\n",
                                    "#define NPBOOL "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of bool parameters\n",
                                    "#define NJACVARS "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numJacobianVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of jacobian variables\n",
                                    "\n",
                                    "static DATA* localData = 0;\n",
                                    "#define time localData->timeValue\n",
                                    "#define $P$old$Ptime localData->oldTime\n",
                                    "#define $P$current_step_size globalData->current_stepsize\n",
                                    "\n",
                                    "#ifndef _OMC_QSS\n",
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" { // adrpo: this is needed for Visual C++ compilation to work!\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *model_name=\""));
        txt = CodegenC.dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "const char *model_fileprefix=\""
                                }, false));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "const char *model_dir=\""
                                }, false));
        txt = Tpl.writeStr(txt, i_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt = globalDataVarInfoArray(txt, "state_names", i_vars_stateVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "derivative_names", i_vars_derivativeVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "algvars_names", i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "param_names", i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "alias_names", i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "int_alg_names", i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "int_param_names", i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "int_alias_names", i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "bool_alg_names", i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "bool_param_names", i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "bool_alias_names", i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "string_alg_names", i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "string_param_names", i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "string_alias_names", i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "jacobian_names", i_vars_jacobianVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataFunctionInfoArray(txt, "function_names", i_functions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_108(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_109(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_110(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_111(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_112(txt, i_vars_extObjVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_113(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_114(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_115(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_116(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_117(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_118(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_119(txt, i_vars_jacobianVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_120(txt, i_functions);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void init_Alias(DATA* data)\n",
                                    "{\n"
                                }, true));
        txt = globalDataAliasVarArray(txt, "DATA_REAL_ALIAS", "omc__realAlias", i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataAliasVarArray(txt, "DATA_INT_ALIAS", "omc__intAlias", i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataAliasVarArray(txt, "DATA_BOOL_ALIAS", "omc__boolAlias", i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataAliasVarArray(txt, "DATA_STRING_ALIAS", "omc__stringAlias", i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if (data->nAlias)\n",
                                    "  memcpy(data->realAlias,omc__realAlias,sizeof(DATA_REAL_ALIAS)*data->nAlias);\n",
                                    "if (data->intVariables.nAlias)\n",
                                    "  memcpy(data->intVariables.alias,omc__intAlias,sizeof(DATA_INT_ALIAS)*data->intVariables.nAlias);\n",
                                    "if (data->boolVariables.nAlias)\n",
                                    "  memcpy(data->boolVariables.alias,omc__boolAlias,sizeof(DATA_BOOL_ALIAS)*data->boolVariables.nAlias);\n",
                                    "if (data->stringVariables.nAlias)\n",
                                    "  memcpy(data->stringVariables.alias,omc__stringAlias,sizeof(DATA_STRING_ALIAS)*data->stringVariables.nAlias);\n",
                                    "};\n",
                                    "\n",
                                    "static char init_fixed[NX+NX+NY+NYINT+NYBOOL+NP+NPINT+NPBOOL] = {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_1 = lm_121(txt_1, i_vars_stateVars);
        txt_1 = Tpl.popIter(txt_1);
        txt_2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_122(txt_2, i_vars_derivativeVars);
        txt_2 = Tpl.popIter(txt_2);
        txt_3 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_3 = lm_123(txt_3, i_vars_algVars);
        txt_3 = Tpl.popIter(txt_3);
        txt_4 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_4 = lm_124(txt_4, i_vars_intAlgVars);
        txt_4 = Tpl.popIter(txt_4);
        txt_5 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_5 = lm_125(txt_5, i_vars_boolAlgVars);
        txt_5 = Tpl.popIter(txt_5);
        txt_6 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_6 = lm_126(txt_6, i_vars_paramVars);
        txt_6 = Tpl.popIter(txt_6);
        txt_7 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_7 = lm_127(txt_7, i_vars_intParamVars);
        txt_7 = Tpl.popIter(txt_7);
        txt_8 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_8 = lm_128(txt_8, i_vars_boolParamVars);
        txt_8 = Tpl.popIter(txt_8);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_129(txt, txt_1);
        txt = smf_130(txt, txt_2);
        txt = smf_131(txt, txt_3);
        txt = smf_132(txt, txt_4);
        txt = smf_133(txt, txt_5);
        txt = smf_134(txt, txt_6);
        txt = smf_135(txt, txt_7);
        txt = smf_136(txt, txt_8);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "char hasNominalValue[NX+NY+NP] = {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_9 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_9 = lm_137(txt_9, i_vars_stateVars);
        txt_9 = Tpl.popIter(txt_9);
        txt_10 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_10 = lm_138(txt_10, i_vars_algVars);
        txt_10 = Tpl.popIter(txt_10);
        txt_11 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_11 = lm_139(txt_11, i_vars_paramVars);
        txt_11 = Tpl.popIter(txt_11);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_140(txt, txt_9);
        txt = smf_141(txt, txt_10);
        txt = smf_142(txt, txt_11);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "double nominalValue[NX+NY+NP] = {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_12 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_12 = lm_143(txt_12, i_vars_stateVars);
        txt_12 = Tpl.popIter(txt_12);
        txt_13 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_13 = lm_144(txt_13, i_vars_algVars);
        txt_13 = Tpl.popIter(txt_13);
        txt_14 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_14 = lm_145(txt_14, i_vars_paramVars);
        txt_14 = Tpl.popIter(txt_14);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_146(txt, txt_12);
        txt = smf_147(txt, txt_13);
        txt = smf_148(txt, txt_14);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "char var_attr[NX+NY+NYINT+NYBOOL+NYSTR+NP+NPINT+NPBOOL+NPSTR] = {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_15 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_15 = lm_149(txt_15, i_vars_stateVars);
        txt_15 = Tpl.popIter(txt_15);
        txt_16 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_16 = lm_150(txt_16, i_vars_algVars);
        txt_16 = Tpl.popIter(txt_16);
        txt_17 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_17 = lm_151(txt_17, i_vars_intAlgVars);
        txt_17 = Tpl.popIter(txt_17);
        txt_18 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_18 = lm_152(txt_18, i_vars_boolAlgVars);
        txt_18 = Tpl.popIter(txt_18);
        txt_19 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_19 = lm_153(txt_19, i_vars_stringAlgVars);
        txt_19 = Tpl.popIter(txt_19);
        txt_20 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_20 = lm_154(txt_20, i_vars_paramVars);
        txt_20 = Tpl.popIter(txt_20);
        txt_21 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_21 = lm_155(txt_21, i_vars_intParamVars);
        txt_21 = Tpl.popIter(txt_21);
        txt_22 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_22 = lm_156(txt_22, i_vars_boolParamVars);
        txt_22 = Tpl.popIter(txt_22);
        txt_23 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_23 = lm_157(txt_23, i_vars_stringParamVars);
        txt_23 = Tpl.popIter(txt_23);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_158(txt, txt_15);
        txt = smf_159(txt, txt_16);
        txt = smf_160(txt, txt_17);
        txt = smf_161(txt, txt_18);
        txt = smf_162(txt, txt_19);
        txt = smf_163(txt, txt_20);
        txt = smf_164(txt, txt_21);
        txt = smf_165(txt, txt_22);
        txt = smf_166(txt, txt_23);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_167;

public function globalData
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input String a_fileNamePrefix;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1000);
  out_txt := fun_167(txt, a_modelInfo, a_fileNamePrefix, a_guid);
end globalData;

protected function lm_169
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Absyn.Info i_info;
      String i_var_comment;
      DAE.ComponentRef i_var_name;
      String ret_3;
      String ret_2;
      Tpl.Text txt_1;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(source = DAE.SOURCE(info = (i_info as Absyn.INFO(fileName = _))), name = i_var_name, comment = i_var_comment) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt_1 = CodegenC.crefStr(Tpl.emptyTxt, i_var_name);
        ret_2 = System.escapedString(Tpl.textString(txt_1));
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",\""));
        ret_3 = Util.escapeModelicaStringToCString(i_var_comment);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",{"));
        txt = CodegenC.infoArgs(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}}"));
        txt = Tpl.nextIter(txt);
        txt = lm_169(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_169(txt, rest);
      then txt;
  end matchcontinue;
end lm_169;

protected function lm_170
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input String in_a_0__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_0__name)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      String a_0__name;
      Integer x_i0;
      DAE.ComponentRef i_var_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(source = DAE.SOURCE(info = Absyn.INFO(fileName = _)), name = i_var_name) :: rest,
           a_0__name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = CodegenC.cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
        txt = Tpl.nextIter(txt);
        txt = lm_170(txt, rest, a_0__name);
      then txt;

    case ( txt,
           _ :: rest,
           a_0__name )
      equation
        txt = lm_170(txt, rest, a_0__name);
      then txt;
  end matchcontinue;
end lm_170;

protected function fun_171
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_items;
  input String in_a_0__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_items, in_a_0__name)
    local
      Tpl.Text txt;
      String a_0__name;
      list<SimCode.SimVar> i_items;
      Integer ret_0;

    case ( txt,
           {},
           a_0__name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct omc_varInfo "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[1] = {{-1,\"\",\"\",omc_dummyFileInfo}};"));
      then txt;

    case ( txt,
           i_items,
           a_0__name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct omc_varInfo "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_169(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("};\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_170(txt, i_items, a_0__name);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_171;

public function globalDataVarInfoArray
  input Tpl.Text txt;
  input String a_0__name;
  input list<SimCode.SimVar> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_171(txt, a_items, a_0__name);
end globalDataVarInfoArray;

protected function lm_173
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;
      Absyn.Info ret_1;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = CodegenC.functionName(txt, i_fn, true);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",{"));
        ret_1 = SimCode.functionInfo(i_fn);
        txt = CodegenC.infoArgs(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}}"));
        txt = Tpl.nextIter(txt);
        txt = lm_173(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_173(txt, rest);
      then txt;
  end matchcontinue;
end lm_173;

protected function fun_174
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_a_items;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_items, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      list<SimCode.Function> i_items;
      Integer ret_0;

    case ( txt,
           {},
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct omc_functionInfo "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[1] = {{-1,\"\",omc_dummyFileInfo}};"));
      then txt;

    case ( txt,
           i_items,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct omc_functionInfo "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_173(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end matchcontinue;
end fun_174;

public function globalDataFunctionInfoArray
  input Tpl.Text txt;
  input String a_name;
  input list<SimCode.Function> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_174(txt, a_items, a_name);
end globalDataFunctionInfoArray;

protected function fun_176
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer i_index;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(aliasvar = SimCode.NOALIAS(), name = i_name, index = i_index),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_176;

protected function fun_177
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      DAE.ComponentRef i_name;
      Integer i_index;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMVAR(arrayCref = SOME(i_c), aliasvar = SimCode.NOALIAS(), index = i_index, name = i_name),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = CodegenC.cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$PRE"
                                }, false));
        txt = CodegenC.cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_saved["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$old"
                                }, false));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_old["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$old2"
                                }, false));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_old2["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$PRE"
                                }, false));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_saved["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = SimCode.NOALIAS(), name = i_name, index = i_index),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$old"
                                }, false));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_old["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$old2"
                                }, false));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_old2["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$PRE"
                                }, false));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_saved["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_177;

protected function fun_178
  input Tpl.Text in_txt;
  input String in_a_arrayName;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_arrayName, in_a_simVar)
    local
      Tpl.Text txt;
      SimCode.SimVar a_simVar;
      String i_arrayName;

    case ( txt,
           (i_arrayName as "jacobianVars"),
           a_simVar )
      equation
        txt = fun_176(txt, a_simVar, i_arrayName);
      then txt;

    case ( txt,
           i_arrayName,
           a_simVar )
      equation
        txt = fun_177(txt, a_simVar, i_arrayName);
      then txt;
  end matchcontinue;
end fun_178;

public function globalDataVarDefine
  input Tpl.Text txt;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_178(txt, a_arrayName, a_simVar);
end globalDataVarDefine;

protected function lm_180
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer i_index;
      SimCode.AliasVariable i_aliasvar;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = i_aliasvar, index = i_index) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = CodegenC.aliasVarNameType(txt, i_aliasvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_180(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_180(txt, rest);
      then txt;
  end matchcontinue;
end lm_180;

protected function fun_181
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_items;
  input String in_a_0__type;
  input String in_a_0__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_items, in_a_0__type, in_a_0__name)
    local
      Tpl.Text txt;
      String a_0__type;
      String a_0__name;
      list<SimCode.SimVar> i_items;
      Integer ret_0;

    case ( txt,
           {},
           a_0__type,
           a_0__name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_0__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[1] = {{0,0,-1}};"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_items,
           a_0__type,
           a_0__name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_0__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_180(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_181;

public function globalDataAliasVarArray
  input Tpl.Text txt;
  input String a_0__type;
  input String a_0__name;
  input list<SimCode.SimVar> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_181(txt, a_items, a_0__type, a_0__name);
end globalDataAliasVarArray;

protected function lm_183
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = CodegenC.cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo"));
        txt = Tpl.nextIter(txt);
        txt = lm_183(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_183(txt, rest);
      then txt;
  end matchcontinue;
end lm_183;

protected function fun_184
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_preBuf;
  input Integer in_a_i0;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preBuf;
algorithm
  (out_txt, out_a_preBuf) :=
  matchcontinue(in_txt, in_a_eq, in_a_preBuf, in_a_i0)
    local
      Tpl.Text txt;
      Tpl.Text a_preBuf;
      Integer a_i0;
      list<DAE.ComponentRef> i_crefs;
      Integer i_index;
      DAE.ComponentRef i_cref;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_var;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = _),
           a_preBuf,
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"SES_RESIDUAL "));
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",0,NULL"));
      then (txt, a_preBuf);

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref),
           a_preBuf,
           a_i0 )
      equation
        l_var = CodegenC.cref(Tpl.emptyTxt, i_cref);
        l_var = Tpl.writeTok(l_var, Tpl.ST_STRING("__varInfo"));
        a_preBuf = Tpl.writeTok(a_preBuf, Tpl.ST_STRING("const struct omc_varInfo *equationInfo_cref"));
        a_preBuf = Tpl.writeStr(a_preBuf, intString(a_i0));
        a_preBuf = Tpl.writeTok(a_preBuf, Tpl.ST_STRING(" = &"));
        a_preBuf = Tpl.writeText(a_preBuf, l_var);
        a_preBuf = Tpl.writeTok(a_preBuf, Tpl.ST_STRING(";"));
        a_preBuf = Tpl.writeTok(a_preBuf, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"SES_SIMPLE_ASSIGN "));
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",1,&equationInfo_cref"));
        txt = Tpl.writeStr(txt, intString(a_i0));
      then (txt, a_preBuf);

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = _),
           a_preBuf,
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"SES_ARRAY_CALL_ASSIGN "));
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",0,NULL"));
      then (txt, a_preBuf);

    case ( txt,
           SimCode.SES_ALGORITHM(statements = _),
           a_preBuf,
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"SES_ALGORITHM "));
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",0,NULL"));
      then (txt, a_preBuf);

    case ( txt,
           SimCode.SES_WHEN(left = _),
           a_preBuf,
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"SES_WHEN "));
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",0,NULL"));
      then (txt, a_preBuf);

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_preBuf,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"LINEAR"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",0,NULL"));
      then (txt, a_preBuf);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index, crefs = i_crefs),
           a_preBuf,
           _ )
      equation
        a_preBuf = Tpl.writeTok(a_preBuf, Tpl.ST_STRING("const struct omc_varInfo *residualFunc"));
        a_preBuf = Tpl.writeStr(a_preBuf, intString(i_index));
        a_preBuf = Tpl.writeTok(a_preBuf, Tpl.ST_STRING("_crefs["));
        ret_1 = listLength(i_crefs);
        a_preBuf = Tpl.writeStr(a_preBuf, intString(ret_1));
        a_preBuf = Tpl.writeTok(a_preBuf, Tpl.ST_STRING("] = {"));
        a_preBuf = Tpl.pushIter(a_preBuf, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        a_preBuf = lm_183(a_preBuf, i_crefs);
        a_preBuf = Tpl.popIter(a_preBuf);
        a_preBuf = Tpl.writeTok(a_preBuf, Tpl.ST_STRING("};"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"residualFunc"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\","));
        ret_2 = listLength(i_crefs);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",residualFunc"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_crefs"));
      then (txt, a_preBuf);

    case ( txt,
           SimCode.SES_MIXED(index = i_index),
           a_preBuf,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"MIXED"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",0,NULL"));
      then (txt, a_preBuf);

    case ( txt,
           _,
           a_preBuf,
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"unknown equation "));
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",0,NULL"));
      then (txt, a_preBuf);
  end matchcontinue;
end fun_184;

protected function lm_185
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_preBuf;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preBuf;
algorithm
  (out_txt, out_a_preBuf) :=
  matchcontinue(in_txt, in_items, in_a_preBuf)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_preBuf;
      Integer x_i0;
      SimCode.SimEqSystem i_eq;
      Integer ret_0;

    case ( txt,
           {},
           a_preBuf )
      then (txt, a_preBuf);

    case ( txt,
           i_eq :: rest,
           a_preBuf )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        (txt, a_preBuf) = fun_184(txt, i_eq, a_preBuf, x_i0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        (txt, a_preBuf) = lm_185(txt, rest, a_preBuf);
      then (txt, a_preBuf);

    case ( txt,
           _ :: rest,
           a_preBuf )
      equation
        (txt, a_preBuf) = lm_185(txt, rest, a_preBuf);
      then (txt, a_preBuf);
  end matchcontinue;
end lm_185;

protected function fun_186
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Integer in_a_i0;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_i0)
    local
      Tpl.Text txt;
      Integer a_i0;
      Integer i_index;

    case ( txt,
           SimCode.SES_MIXED(index = i_index),
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(a_i0));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(a_i0));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(a_i0));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_186;

protected function lm_187
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Integer x_i0;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = fun_186(txt, i_eq, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_187(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_187(txt, rest);
      then txt;
  end matchcontinue;
end lm_187;

protected function fun_188
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SES_MIXED(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+1"));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+1"));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+1"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_188;

protected function lm_189
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = fun_188(txt, i_eq);
        txt = lm_189(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_189(txt, rest);
      then txt;
  end matchcontinue;
end lm_189;

protected function fun_190
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Integer in_a_i0;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_i0)
    local
      Tpl.Text txt;
      Integer a_i0;

    case ( txt,
           SimCode.SES_MIXED(index = _),
           a_i0 )
      equation
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = _),
           a_i0 )
      equation
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = _),
           a_i0 )
      equation
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_190;

protected function lm_191
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Integer x_i0;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = fun_190(txt, i_eq, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_191(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_191(txt, rest);
      then txt;
  end matchcontinue;
end lm_191;

protected function fun_192
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Integer in_a_i0;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_i0)
    local
      Tpl.Text txt;
      Integer a_i0;
      Integer i_index;

    case ( txt,
           SimCode.SES_MIXED(index = i_index),
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(a_i0));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(a_i0));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(a_i0));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_192;

protected function lm_193
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Integer x_i0;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = fun_192(txt, i_eq, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_193(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_193(txt, rest);
      then txt;
  end matchcontinue;
end lm_193;

public function equationInfo
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_a_eqs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eqs)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_eqs;
      Integer ret_3;
      Integer ret_2;
      Tpl.Text l_res;
      Tpl.Text l_preBuf;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct omc_equationInfo equation_info[1] = {{0,NULL}};"));
      then txt;

    case ( txt,
           i_eqs )
      equation
        l_preBuf = Tpl.emptyTxt;
        l_res = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("const int nEquation = "));
        ret_2 = listLength(i_eqs);
        l_res = Tpl.writeStr(l_res, intString(ret_2));
        l_res = Tpl.writeTok(l_res, Tpl.ST_STRING_LIST({
                                        ";\n",
                                        "const struct omc_equationInfo equation_info["
                                    }, false));
        ret_3 = listLength(i_eqs);
        l_res = Tpl.writeStr(l_res, intString(ret_3));
        l_res = Tpl.writeTok(l_res, Tpl.ST_LINE("] = {\n"));
        l_res = Tpl.pushBlock(l_res, Tpl.BT_INDENT(2));
        l_res = Tpl.pushIter(l_res, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_res, l_preBuf) = lm_185(l_res, i_eqs, l_preBuf);
        l_res = Tpl.popIter(l_res);
        l_res = Tpl.softNewLine(l_res);
        l_res = Tpl.popBlock(l_res);
        l_res = Tpl.writeTok(l_res, Tpl.ST_STRING("};"));
        txt = Tpl.writeText(txt, l_preBuf);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_res);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_187(txt, i_eqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const int n_omc_equationInfo_reverse_prof_index = 0"));
        txt = lm_189(txt, i_eqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "const int omc_equationInfo_reverse_prof_index[] = {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_191(txt, i_eqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("};\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_193(txt, i_eqs);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end equationInfo;

public function functionSetLocalData
  input Tpl.Text txt;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "void setLocalData(DATA* data)\n",
                                   "{\n",
                                   "  localData = data;\n",
                                   "  init_Alias(data);\n",
                                   "}"
                               }, false));
end functionSetLocalData;

public function functionInitializeDataStruc
  input Tpl.Text txt;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "DATA* initializeDataStruc()\n",
                                   "{\n",
                                   "  DATA* returnData = (DATA*)malloc(sizeof(DATA));\n",
                                   "\n",
                                   "  if(!returnData) //error check\n",
                                   "    return 0;\n",
                                   "\n",
                                   "  memset(returnData,0,sizeof(DATA));\n",
                                   "  returnData->nStates = NX;\n",
                                   "  returnData->nAlgebraic = NY;\n",
                                   "  returnData->nAlias = NA;\n",
                                   "  returnData->nParameters = NP;\n",
                                   "  returnData->nInputVars = NI;\n",
                                   "  returnData->nOutputVars = NO;\n",
                                   "  returnData->nFunctions = NFUNC;\n",
                                   "  returnData->nEquations = nEquation;\n",
                                   "  returnData->nProfileBlocks = n_omc_equationInfo_reverse_prof_index;\n",
                                   "  returnData->nZeroCrossing = NG;\n",
                                   "  returnData->nRawSamples = NG_SAM;\n",
                                   "  returnData->nInitialResiduals = NR;\n",
                                   "  returnData->nHelpVars = NHELP;\n",
                                   "  returnData->stringVariables.nParameters = NPSTR;\n",
                                   "  returnData->stringVariables.nAlgebraic = NYSTR;\n",
                                   "  returnData->stringVariables.nAlias = NASTR;\n",
                                   "  returnData->intVariables.nParameters = NPINT;\n",
                                   "  returnData->intVariables.nAlgebraic = NYINT;\n",
                                   "  returnData->intVariables.nAlias = NAINT;\n",
                                   "  returnData->boolVariables.nParameters = NPBOOL;\n",
                                   "  returnData->boolVariables.nAlgebraic = NYBOOL;\n",
                                   "  returnData->boolVariables.nAlias = NABOOL;\n",
                                   "  returnData->nJacobianvars = NJACVARS;\n",
                                   "\n",
                                   "  returnData->initFixed = init_fixed;\n",
                                   "  returnData->var_attr = var_attr;\n",
                                   "  returnData->modelName = model_name;\n",
                                   "  returnData->modelFilePrefix = model_fileprefix;\n",
                                   "  returnData->modelGUID = MODEL_GUID;\n",
                                   "  returnData->statesNames = state_names;\n",
                                   "  returnData->stateDerivativesNames = derivative_names;\n",
                                   "  returnData->algebraicsNames = algvars_names;\n",
                                   "  returnData->int_alg_names = int_alg_names;\n",
                                   "  returnData->bool_alg_names = bool_alg_names;\n",
                                   "  returnData->string_alg_names = string_alg_names;\n",
                                   "  returnData->parametersNames = param_names;\n",
                                   "  returnData->int_param_names = int_param_names;\n",
                                   "  returnData->bool_param_names = bool_param_names;\n",
                                   "  returnData->string_param_names = string_param_names;\n",
                                   "  returnData->alias_names = alias_names;\n",
                                   "  returnData->int_alias_names = int_alias_names;\n",
                                   "  returnData->bool_alias_names = bool_alias_names;\n",
                                   "  returnData->string_alias_names = string_alias_names;\n",
                                   "  returnData->jacobian_names = jacobian_names;\n",
                                   "  returnData->functionNames = function_names;\n",
                                   "  returnData->equationInfo = equation_info;\n",
                                   "  returnData->equationInfo_reverse_prof_index = omc_equationInfo_reverse_prof_index;\n",
                                   "\n",
                                   "  if (NEXT) {\n",
                                   "    returnData->extObjs = (void**)malloc(sizeof(void*)*NEXT);\n",
                                   "    if (!returnData->extObjs) {\n",
                                   "      printf(\"error allocating external objects\\n\");\n",
                                   "      exit(-2);\n",
                                   "    }\n",
                                   "    memset(returnData->extObjs,0,sizeof(void*)*NEXT);\n",
                                   "  } else {\n",
                                   "    returnData->extObjs = 0;\n",
                                   "  }\n",
                                   "\n",
                                   "  return returnData;\n",
                                   "}\n",
                                   "\n"
                               }, true));
end functionInitializeDataStruc;

protected function lm_197
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_arg;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMVAR(initialValue = SOME(i_exp), name = i_var_name) :: rest,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_arg, l_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = CodegenC.cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_arg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "restore_memory_state(mem_state);"
                                }, false));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_197(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_197(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_197;

protected function lm_198
  input Tpl.Text in_txt;
  input list<SimCode.ExtAlias> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.ExtAlias> rest;
      DAE.ComponentRef i_var2;
      DAE.ComponentRef i_var1;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var1, i_var2) :: rest )
      equation
        txt = CodegenC.cref(txt, i_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = CodegenC.cref(txt, i_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_198(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_198(txt, rest);
      then txt;
  end matchcontinue;
end lm_198;

public function functionCallExternalObjectConstructors
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extObjInfo)
    local
      Tpl.Text txt;
      list<SimCode.ExtAlias> i_aliases;
      list<SimCode.SimVar> i_vars;
      Tpl.Text l_ctorCalls;
      Tpl.Text l_varDecls;
      Tpl.Text l_funDecls;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_vars, aliases = i_aliases) )
      equation
        l_funDecls = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_ctorCalls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_ctorCalls, l_varDecls) = lm_197(l_ctorCalls, i_vars, l_varDecls);
        l_ctorCalls = Tpl.popIter(l_ctorCalls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* Has to be performed after _init.xml file has been read */\n",
                                    "void callExternalObjectConstructors(DATA* localData) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "state mem_state;\n",
                                    "mem_state = get_memory_state();\n"
                                }, true));
        txt = Tpl.writeText(txt, l_ctorCalls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_198(txt, i_aliases);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionCallExternalObjectConstructors;

protected function lm_200
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_var_name;
      Absyn.Path i_ext_fullClassName;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(varKind = BackendDAE.EXTOBJ(fullClassName = i_ext_fullClassName), name = i_var_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = CodegenC.underscorePath(txt, i_ext_fullClassName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_destructor("));
        txt = CodegenC.cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_200(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_200(txt, rest);
      then txt;
  end matchcontinue;
end lm_200;

public function functionDeInitializeDataStruc
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extObjInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_extObjInfo_vars;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_extObjInfo_vars) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void deInitializeDataStruc(DATA* data)\n",
                                    "{\n",
                                    "  if (data->extObjs) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_200(txt, i_extObjInfo_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "free(data->extObjs);\n",
                                    "data->extObjs = 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionDeInitializeDataStruc;

protected function lm_202
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = localData->inputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_202(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_202(txt, rest);
      then txt;
  end matchcontinue;
end lm_202;

public function functionInput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_inputVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(inputVars = i_vars_inputVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int input_function()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_202(txt, i_vars_inputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionInput;

protected function lm_204
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->outputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_204(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_204(txt, rest);
      then txt;
  end matchcontinue;
end lm_204;

public function functionOutput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_outputVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(outputVars = i_vars_outputVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int output_function()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_204(txt, i_vars_outputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionOutput;

protected function fun_206
  input Tpl.Text in_txt;
  input Tpl.Text in_a_timeEventCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_timeEventCode)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int i = 0; // Current index"));
      then txt;
  end matchcontinue;
end fun_206;

public function functionInitSample
  input Tpl.Text txt;
  input list<SimCode.SampleCondition> a_sampleConditions;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_timeEventCode;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_timeEventCode, l_varDecls) := CodegenC.timeEventsTpl(Tpl.emptyTxt, a_sampleConditions, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* Initializes the raw time events of the simulation using the now\n",
                                   "   calcualted parameters. */\n",
                                   "void function_sampleInit()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := fun_206(out_txt, l_timeEventCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_timeEventCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitSample;

protected function lm_208
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = CodegenC.equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_208(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_208(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_208;

public function functionSampleEquations
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_sampleEqns;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqs;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqs, l_tmp, l_varDecls) := lm_208(l_eqs, a_sampleEqns, l_tmp, l_varDecls);
  l_eqs := Tpl.popIter(l_eqs);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int function_updateSample()\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_eqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionSampleEquations;

protected function lm_210
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = CodegenC.equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_210(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_210(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_210;

protected function lm_211
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      DAE.ComponentRef i_cref;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (sim_verbose >= LOG_INIT) { printf(\"Setting variable start value: %s(start=%f)\\n\", \""));
        txt = CodegenC.cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", ("));
        txt = CodegenC.crefType(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") "));
        txt = CodegenC.cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("); }"));
        txt = Tpl.nextIter(txt);
        txt = lm_211(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_211(txt, rest);
      then txt;
  end matchcontinue;
end lm_211;

public function functionInitial
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_startValueEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqPart, l_tmp, l_varDecls) := lm_210(l_eqPart, a_startValueEquations, l_tmp, l_varDecls);
  l_eqPart := Tpl.popIter(l_eqPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int initial_function()\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_eqPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_211(out_txt, a_startValueEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitial;

protected function fun_213
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      String ret_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.SCONST(string = _),
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->initialResiduals[i++] = 0;"));
      then (txt, a_varDecls);

    case ( txt,
           i_exp,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->initialResiduals[i++] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "if (sim_verbose == LOG_RES_INIT) { printf(\" Residual[%d] : "
                                }, false));
        ret_2 = ExpressionDump.printExpStr(i_exp);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = %f\\n\",i,localData->initialResiduals[i-1]); }"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_213;

protected function lm_214
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_exp) :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_213(txt, i_exp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_214(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_214(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_214;

public function functionInitialResidual
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_residualEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_body;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_varDecls) := lm_214(l_body, a_residualEquations, l_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "int initial_residual(double $P$_lambda)\n",
                                   "{\n",
                                   "  int i = 0;\n",
                                   "  state mem_state;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialResidual;

protected function lm_216
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq2 as SimCode.SES_ALGORITHM(statements = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = CodegenC.equation_(txt, i_eq2, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_216(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_216(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_216;

protected function lm_217
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq2 as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = CodegenC.equation_(txt, i_eq2, SimCode.contextOther, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_217(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_217(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_217;

protected function lm_218
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_eq2_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_eq2_exp) :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_eq2_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("res["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_218(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_218(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_218;

protected function fun_219
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eqn)
    local
      Tpl.Text txt;
      Integer i_index;
      list<SimCode.SimEqSystem> i_eq_eqs;
      SimCode.SimEqSystem i_eq_cont;
      Tpl.Text l_body;
      Tpl.Text l_prebody;
      Tpl.Text l_algs;
      Tpl.Text l_tmp;
      Tpl.Text l_varDecls;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq_cont) )
      equation
        ret_0 = List.fill(i_eq_cont, 1);
        txt = functionExtraResiduals(txt, ret_0);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(eqs = i_eq_eqs, index = i_index) )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_tmp = Tpl.emptyTxt;
        l_algs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_algs, l_tmp, l_varDecls) = lm_216(l_algs, i_eq_eqs, l_tmp, l_varDecls);
        l_algs = Tpl.popIter(l_algs);
        l_prebody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_prebody, l_tmp, l_varDecls) = lm_217(l_prebody, i_eq_eqs, l_tmp, l_varDecls);
        l_prebody = Tpl.popIter(l_prebody);
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, l_varDecls) = lm_218(l_body, i_eq_eqs, l_varDecls);
        l_body = Tpl.popIter(l_body);
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void residualFunc"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int *n, double* xloc, double* res, int* iflag)\n",
                                    "{\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ADD_NCALL_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",1);\n",
                                    "#endif\n",
                                    "mem_state = get_memory_state();\n"
                                }, true));
        txt = Tpl.writeText(txt, l_algs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_prebody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("restore_memory_state(mem_state);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_219;

protected function lm_220
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqn :: rest )
      equation
        txt = fun_219(txt, i_eqn);
        txt = Tpl.nextIter(txt);
        txt = lm_220(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_220(txt, rest);
      then txt;
  end matchcontinue;
end lm_220;

public function functionExtraResiduals
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_220(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
end functionExtraResiduals;

protected function lm_222
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = CodegenC.equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_222(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_222(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_222;

protected function lm_223
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_ALGORITHM(statements = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = CodegenC.equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_223(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_223(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_223;

public function functionBoundParameters
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_parameterEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_divbody;
  Tpl.Text l_body;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  System.tmpTickReset(0);
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_tmp, l_varDecls) := lm_222(l_body, a_parameterEquations, l_tmp, l_varDecls);
  l_body := Tpl.popIter(l_body);
  l_divbody := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_divbody, l_tmp, l_varDecls) := lm_223(l_divbody, a_parameterEquations, l_tmp, l_varDecls);
  l_divbody := Tpl.popIter(l_divbody);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int bound_parameters()\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_divbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionBoundParameters;

protected function lm_225
  input Tpl.Text in_txt;
  input list<tuple<Integer, DAE.Exp>> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<tuple<Integer, DAE.Exp>> rest;
      Tpl.Text a_varDecls;
      Integer i_id;
      DAE.Exp i_e;
      Tpl.Text l_eRes;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_id, i_e) :: rest,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_eRes, l_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_e, SimCode.contextSimulationNonDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("storeDelayedExpression("));
        txt = Tpl.writeStr(txt, intString(i_id));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_eRes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        (txt, a_varDecls) = lm_225(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_225(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_225;

protected function fun_226
  input Tpl.Text in_txt;
  input SimCode.DelayedExpression in_a_delayed;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_delayed, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<tuple<Integer, DAE.Exp>> i_delayedExps;

    case ( txt,
           SimCode.DELAYED_EXPRESSIONS(delayedExps = i_delayedExps),
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_225(txt, i_delayedExps, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_226;

protected function fun_227
  input Tpl.Text in_txt;
  input SimCode.DelayedExpression in_a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_delayed)
    local
      Tpl.Text txt;
      Integer i_maxDelayedIndex;

    case ( txt,
           SimCode.DELAYED_EXPRESSIONS(maxDelayedIndex = i_maxDelayedIndex) )
      equation
        txt = Tpl.writeStr(txt, intString(i_maxDelayedIndex));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_227;

public function functionStoreDelayed
  input Tpl.Text txt;
  input SimCode.DelayedExpression a_delayed;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_storePart;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_storePart, l_varDecls) := fun_226(Tpl.emptyTxt, a_delayed, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("int numDelayExpressionIndex = "));
  out_txt := fun_227(out_txt, a_delayed);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ";\n",
                                       "int function_storeDelayed()\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_storePart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionStoreDelayed;

public function functionWhenReinitStatement
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_reinit, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Absyn.Info i_info;
      DAE.Exp i_condition;
      DAE.Exp i_message;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_msgVar;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = CodegenC.cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.TERMINATE(message = i_message),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls) = CodegenC.daeExp(Tpl.emptyTxt, i_message, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  MODELICA_TERMINATE("));
        txt = Tpl.writeText(txt, l_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ASSERT(source = DAE.SOURCE(info = i_info), condition = i_condition, message = i_message),
           a_varDecls )
      equation
        (txt, a_varDecls) = CodegenC.assertCommon(txt, i_condition, i_message, SimCode.contextSimulationDiscrete, a_varDecls, i_info);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end functionWhenReinitStatement;

protected function lm_230
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_230(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_230(txt, rest);
      then txt;
  end matchcontinue;
end lm_230;

public function externalFunctionIncludes
  input Tpl.Text in_txt;
  input list<String> in_a_includes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_includes)
    local
      Tpl.Text txt;
      list<String> i_includes;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_includes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_230(txt, i_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif"
                                }, false));
      then txt;
  end matchcontinue;
end externalFunctionIncludes;

protected function lm_232
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Integer x_i1;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqs :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = CodegenC.functionODE_system(txt, i_eqs, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_232(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_232(txt, rest);
      then txt;
  end matchcontinue;
end lm_232;

protected function lm_233
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Integer x_i1;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("functionODE_system"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.nextIter(txt);
        txt = lm_233(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_233(txt, rest);
      then txt;
  end matchcontinue;
end lm_233;

protected function lm_234
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls2;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls2) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls2)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls2;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls2 )
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        (txt, a_varDecls2, a_tmp) = CodegenC.equation_(txt, i_eq, SimCode.contextInlineSolver, a_varDecls2, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls2) = lm_234(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        (txt, a_tmp, a_varDecls2) = lm_234(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);
  end matchcontinue;
end lm_234;

protected function lm_235
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls2;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls2) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls2)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls2;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           a_tmp,
           a_varDecls2 )
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           i_eqs :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_tmp, a_varDecls2) = lm_234(txt, i_eqs, a_tmp, a_varDecls2);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls2) = lm_235(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        (txt, a_tmp, a_varDecls2) = lm_235(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);
  end matchcontinue;
end lm_235;

protected function fun_236
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer ret_0;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           _ )
      equation
        ret_0 = Config.noProc();
        txt = Tpl.writeStr(txt, intString(ret_0));
      then txt;
  end matchcontinue;
end fun_236;

protected function fun_237
  input Tpl.Text in_txt;
  input Integer in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dynamic"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static"));
      then txt;
  end matchcontinue;
end fun_237;

protected function fun_238
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer ret_0;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp parallel for private(id,th_id) schedule("));
        ret_0 = Config.noProc();
        txt = fun_237(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_238;

protected function fun_239
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_stateContPartInline;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateContPartInline, in_a_varDecls2)
    local
      Tpl.Text txt;
      Tpl.Text a_stateContPartInline;
      Tpl.Text a_varDecls2;

    case ( txt,
           "inline-euler",
           a_stateContPartInline,
           a_varDecls2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// we need to access the inline define that we compiled the simulation with\n",
                                    "// from the simulation runtime.\n",
                                    "int functionODE_inline()\n",
                                    "{\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_varDecls2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "mem_state = get_memory_state();\n",
                                    "begin_inline();\n"
                                }, true));
        txt = Tpl.writeText(txt, a_stateContPartInline);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "end_inline();\n",
                                    "restore_memory_state(mem_state);\n",
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           "inline-rungekutta",
           a_stateContPartInline,
           a_varDecls2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// we need to access the inline define that we compiled the simulation with\n",
                                    "// from the simulation runtime.\n",
                                    "int functionODE_inline()\n",
                                    "{\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_varDecls2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "mem_state = get_memory_state();\n",
                                    "begin_inline();\n"
                                }, true));
        txt = Tpl.writeText(txt, a_stateContPartInline);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "end_inline();\n",
                                    "restore_memory_state(mem_state);\n",
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int functionODE_inline()\n",
                                    "{\n",
                                    "  return 0;\n",
                                    "}"
                                }, false));
      then txt;
  end matchcontinue;
end fun_239;

public function functionODE
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_derivativEquations;
  input Tpl.Text a_method;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_method;
protected
  String str_9;
  Boolean ret_8;
  Boolean ret_7;
  Tpl.Text l_stateContPartInline;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls2;
  Tpl.Text l_funcNames;
  Integer ret_2;
  Tpl.Text l_nFuncs;
  Tpl.Text l_funcs;
algorithm
  System.tmpTickReset(0);
  l_funcs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_funcs := lm_232(l_funcs, a_derivativEquations);
  l_funcs := Tpl.popIter(l_funcs);
  ret_2 := listLength(a_derivativEquations);
  l_nFuncs := Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
  l_funcNames := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_funcNames := lm_233(l_funcNames, a_derivativEquations);
  l_funcNames := Tpl.popIter(l_funcNames);
  l_varDecls2 := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_stateContPartInline := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_stateContPartInline, l_tmp, l_varDecls2) := lm_235(l_stateContPartInline, a_derivativEquations, l_tmp, l_varDecls2);
  l_stateContPartInline := Tpl.popIter(l_stateContPartInline);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_funcs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("static void (*functionODE_systems["));
  out_txt := Tpl.writeText(out_txt, l_nFuncs);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("])(int) = {\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_funcNames);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "};\n",
                                       "\n",
                                       "void function_initMemoryState()\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("push_memory_states("));
  ret_7 := Flags.isSet(Flags.OPENMP);
  out_txt := fun_236(out_txt, ret_7);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(");\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "\n",
                                       "int functionODE()\n",
                                       "{\n",
                                       "  int id,th_id;\n",
                                       "  state mem_state; /* We need to have separate memory pools for separate systems... */\n",
                                       "  mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  ret_8 := Flags.isSet(Flags.OPENMP);
  out_txt := fun_238(out_txt, ret_8);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("for (id=0; id<"));
  out_txt := Tpl.writeText(out_txt, l_nFuncs);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "; id++) {\n",
                                       "  th_id = omp_get_thread_num();\n",
                                       "  functionODE_systems[id](th_id);\n",
                                       "}\n",
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "#include <simulation_inline_solver.h>\n",
                                       "const char *_omc_force_solver=_OMC_FORCE_SOLVER;\n",
                                       "const int inline_work_states_ndims=_OMC_SOLVER_WORK_STATES_NDIMS;\n"
                                   }, true));
  str_9 := Tpl.textString(a_method);
  out_txt := fun_239(out_txt, str_9, l_stateContPartInline, l_varDecls2);
  out_a_method := a_method;
end functionODE;

protected function lm_241
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = CodegenC.equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_241(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_241(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_241;

public function functionAlgebraic
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_algebraicEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algEquations;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_algEquations := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algEquations, l_tmp, l_varDecls) := lm_241(l_algEquations, a_algebraicEquations, l_tmp, l_varDecls);
  l_algEquations := Tpl.popIter(l_algEquations);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* for continuous time variables */\n",
                                       "int functionAlgebraics()\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_algEquations);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAlgebraic;

protected function lm_243
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = CodegenC.equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_243(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_243(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_243;

public function functionAliasEquation
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_removedEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_removedPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_removedPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_removedPart, l_tmp, l_varDecls) := lm_243(l_removedPart, a_removedEquations, l_tmp, l_varDecls);
  l_removedPart := Tpl.popIter(l_removedPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* for continuous time variables */\n",
                                       "int functionAliasEquations()\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_removedPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAliasEquation;

protected function lm_245
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = CodegenC.equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_245(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_245(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_245;

protected function lm_246
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      SimCode.SimWhenClause i_when;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_when :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = CodegenC.genreinits(txt, i_when, a_varDecls, x_i0);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_246(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_246(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_246;

public function functionDAE
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.HelpVarInfo> a_helpVarInfo;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_reinit;
  Tpl.Text l_eqs;
  Tpl.Text l_tmp;
  Tpl.Text l_jens;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  System.tmpTickReset(0);
  l_jens := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqs, l_tmp, l_varDecls) := lm_245(l_eqs, a_allEquationsPlusWhen, l_tmp, l_varDecls);
  l_eqs := Tpl.popIter(l_eqs);
  l_reinit := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_reinit, l_varDecls) := lm_246(l_reinit, a_whenClauses, l_varDecls);
  l_reinit := Tpl.popIter(l_reinit);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int functionDAE(int *needToIterate)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "*needToIterate = 0;\n",
                                       "inUpdate=initial()?0:1;\n",
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_eqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_reinit);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "inUpdate=0;\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionDAE;

public function functionOnlyZeroCrossing
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_zeroCrossingsCode;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_zeroCrossingsCode, l_varDecls) := CodegenC.zeroCrossingsTpl2(Tpl.emptyTxt, a_zeroCrossings, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "int function_onlyZeroCrossings(double *gout,double *t)\n",
                                   "{\n",
                                   "  state mem_state;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_zeroCrossingsCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionOnlyZeroCrossing;

protected function fun_249
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_var;

    case ( txt,
           (i_var as DAE.CREF_QUAL(ident = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = CodegenC.cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != $P$PRE"));
        txt = CodegenC.cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") { if (sim_verbose >= LOG_EVENTS) { printf(\"Discrete Var "));
        txt = CodegenC.crefStr(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : "));
        txt = CodegenC.crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" to "));
        txt = CodegenC.crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\n\", $P$PRE"));
        txt = CodegenC.cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = CodegenC.cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("); }  needToIterate=1; }"));
      then txt;

    case ( txt,
           (i_var as DAE.CREF_IDENT(ident = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = CodegenC.cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != $P$PRE"));
        txt = CodegenC.cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") { if (sim_verbose >= LOG_EVENTS) { printf(\"Discrete Var "));
        txt = CodegenC.crefStr(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : "));
        txt = CodegenC.crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" to "));
        txt = CodegenC.crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\n\", $P$PRE"));
        txt = CodegenC.cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = CodegenC.cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("); }  needToIterate=1; }"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_249;

protected function lm_250
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_249(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_250(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_250(txt, rest);
      then txt;
  end matchcontinue;
end lm_250;

public function functionCheckForDiscreteChanges
  input Tpl.Text txt;
  input list<DAE.ComponentRef> a_discreteModelVars;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_changediscreteVars;
algorithm
  l_changediscreteVars := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_changediscreteVars := lm_250(l_changediscreteVars, a_discreteModelVars);
  l_changediscreteVars := Tpl.popIter(l_changediscreteVars);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "int checkForDiscreteChanges()\n",
                                   "{\n",
                                   "  int needToIterate = 0;\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_changediscreteVars);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return needToIterate;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionCheckForDiscreteChanges;

protected function lm_252
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = CodegenC.equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_252(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_252(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_252;

protected function lm_253
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = genoutVars(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_253(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_253(txt, rest);
      then txt;
  end matchcontinue;
end lm_253;

public function functionJac
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_jacEquations;
  input list<SimCode.SimVar> a_tmpVars;
  input String a_columnName;
  input String a_matrixName;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_outvars__;
  Tpl.Text l_eqns__;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqns__ := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqns__, l_tmp, l_varDecls) := lm_252(l_eqns__, a_jacEquations, l_tmp, l_varDecls);
  l_eqns__ := Tpl.popIter(l_eqns__);
  l_outvars__ := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_outvars__ := lm_253(l_outvars__, a_tmpVars);
  l_outvars__ := Tpl.popIter(l_outvars__);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int functionJac"));
  out_txt := Tpl.writeStr(out_txt, a_matrixName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_0(double *seed, double *out_col)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("mem_state = get_memory_state();\n"));
  out_txt := Tpl.writeText(out_txt, l_eqns__);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "// write column\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_outvars__);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int i;\n",
                                       "for(i=0;i<"
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, a_columnName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ";i++){\n",
                                       "    if (sim_verbose == LOG_JAC || sim_verbose == LOG_ENDJAC){\n",
                                       "      printf(\"col: col[%d] = %f \\n\",i,out_col[i]);\n",
                                       "    }\n",
                                       "}\n",
                                       "\n",
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionJac;

protected function fun_255
  input Tpl.Text in_txt;
  input Integer in_a_index;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_index, in_a_name)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_name;
      Integer i_index;

    case ( txt,
           -1,
           _ )
      then txt;

    case ( txt,
           i_index,
           a_name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out_col["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = CodegenC.cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_255;

public function genoutVars
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      Integer i_index;

    case ( txt,
           SimCode.SIMVAR(name = i_name, index = i_index) )
      equation
        txt = fun_255(txt, i_index, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end genoutVars;

protected function lm_257
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_matrixname)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String a_matrixname;
      String i_name;
      list<SimCode.SimVar> i_vars;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_eqs, i_vars, i_name) :: rest,
           a_matrixname )
      equation
        txt = functionJac(txt, i_eqs, i_vars, i_name, a_matrixname);
        txt = Tpl.nextIter(txt);
        txt = lm_257(txt, rest, a_matrixname);
      then txt;

    case ( txt,
           _ :: rest,
           a_matrixname )
      equation
        txt = lm_257(txt, rest, a_matrixname);
      then txt;
  end matchcontinue;
end lm_257;

protected function lm_258
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, _, i_name) :: rest )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_258(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_258(txt, rest);
      then txt;
  end matchcontinue;
end lm_258;

protected function fun_259
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input Integer in_a_i0;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var, in_a_i0)
    local
      Tpl.Text txt;
      Integer a_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(name = i_name),
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" seed["));
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_259;

protected function lm_260
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = fun_259(txt, i_var, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_260(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_260(txt, rest);
      then txt;
  end matchcontinue;
end lm_260;

protected function fun_261
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_seedVars;
  input list<SimCode.JacobianColumn> in_a_jacobianMatrix;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_seedVars, in_a_jacobianMatrix, in_a_matrixname)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> a_jacobianMatrix;
      String a_matrixname;
      list<SimCode.SimVar> i_seedVars;
      Integer ret_4;
      Tpl.Text l_index__;
      Tpl.Text l_writeJac__;
      Tpl.Text l_indexColumn;
      Tpl.Text l_jacMats;

    case ( txt,
           {},
           _,
           a_matrixname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int functionJac"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(double* jac){\n",
                                    "   return 0;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_seedVars,
           a_jacobianMatrix,
           a_matrixname )
      equation
        l_jacMats = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_jacMats = lm_257(l_jacMats, a_jacobianMatrix, a_matrixname);
        l_jacMats = Tpl.popIter(l_jacMats);
        l_indexColumn = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_indexColumn = lm_258(l_indexColumn, a_jacobianMatrix);
        l_indexColumn = Tpl.popIter(l_indexColumn);
        l_writeJac__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_writeJac__ = lm_260(l_writeJac__, i_seedVars);
        l_writeJac__ = Tpl.popIter(l_writeJac__);
        ret_4 = listLength(i_seedVars);
        l_index__ = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#define _OMC_SEED_HACK double *seed\n",
                                    "#define _OMC_SEED_HACK_2 seed\n"
                                }, true));
        txt = Tpl.writeText(txt, l_writeJac__);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_jacMats);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int functionJac"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(double* jac){\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double seed["));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "] = {0};\n",
                                    "double localtmp["
                                }, false));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "] = {0};\n",
                                    "int i,j,l,k;\n",
                                    "for(i=0,k=0;  i < "
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";i++){\n",
                                    "  seed[i] = 1;\n",
                                    "\n",
                                    "  if (sim_verbose == LOG_JAC || sim_verbose == LOG_ENDJAC){\n",
                                    "    printf(\"Caluculate one row:\\n\");\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for(l=0;  l < "));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";l++){\n",
                                    "  printf(\"seed: seed[%d]= %f\\n\",l,seed[l]);\n",
                                    "}\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("functionJac"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_0(seed,localtmp);\n",
                                    "seed[i] = 0;\n",
                                    "for(j=0; j < "
                                }, false));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";j++)\n",
                                    "  jac[k++] = localtmp[j];\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " return 0;\n",
                                    "}"
                                }, false));
      then txt;
  end matchcontinue;
end fun_261;

public function generateMatrix
  input Tpl.Text txt;
  input list<SimCode.JacobianColumn> a_jacobianMatrix;
  input list<SimCode.SimVar> a_seedVars;
  input String a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_261(txt, a_seedVars, a_jacobianMatrix, a_matrixname);
end generateMatrix;

protected function lm_263
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      String i_name;
      list<SimCode.SimVar> i_vars;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_mat, i_vars, i_name, _, _, _) :: rest )
      equation
        txt = generateMatrix(txt, i_mat, i_vars, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_263(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_263(txt, rest);
      then txt;
  end matchcontinue;
end lm_263;

public function generateLinearMatrixes
  input Tpl.Text txt;
  input list<SimCode.JacobianMatrix> a_JacobianMatrixes;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacMats;
algorithm
  l_jacMats := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                               "\n",
                                                                               "\n"
                                                                           }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_jacMats := lm_263(l_jacMats, a_JacobianMatrixes);
  l_jacMats := Tpl.popIter(l_jacMats);
  out_txt := Tpl.writeText(txt, l_jacMats);
end generateLinearMatrixes;

public function functionlinearmodel
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_outputVars;
      list<SimCode.SimVar> i_vars_inputVars;
      list<SimCode.SimVar> i_vars_stateVars;
      Absyn.Path i_name;
      Integer i_varInfo_numOutVars;
      Integer i_varInfo_numInVars;
      Integer i_varInfo_numStateVars;
      Tpl.Text l_vectorY;
      Tpl.Text l_vectorU;
      Tpl.Text l_vectorX;
      Tpl.Text l_matrixD;
      Tpl.Text l_matrixC;
      Tpl.Text l_matrixB;
      Tpl.Text l_matrixA;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars, numInVars = i_varInfo_numInVars, numOutVars = i_varInfo_numOutVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, inputVars = i_vars_inputVars, outputVars = i_vars_outputVars), name = i_name) )
      equation
        l_matrixA = CodegenC.genMatrix(Tpl.emptyTxt, "A", i_varInfo_numStateVars, i_varInfo_numStateVars);
        l_matrixB = CodegenC.genMatrix(Tpl.emptyTxt, "B", i_varInfo_numStateVars, i_varInfo_numInVars);
        l_matrixC = CodegenC.genMatrix(Tpl.emptyTxt, "C", i_varInfo_numOutVars, i_varInfo_numStateVars);
        l_matrixD = CodegenC.genMatrix(Tpl.emptyTxt, "D", i_varInfo_numOutVars, i_varInfo_numInVars);
        l_vectorX = CodegenC.genVector(Tpl.emptyTxt, "x", i_varInfo_numStateVars, 0);
        l_vectorU = CodegenC.genVector(Tpl.emptyTxt, "u", i_varInfo_numInVars, 1);
        l_vectorY = CodegenC.genVector(Tpl.emptyTxt, "y", i_varInfo_numOutVars, 2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("const char *linear_model_frame =\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"model linear_"));
        txt = CodegenC.dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\n  parameter Integer n = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // states \\n  parameter Integer k = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // top-level inputs \\n  parameter Integer l = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "; // top-level outputs \\n\"\n",
                                    "\"  parameter Real x0["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "] = {%s};\\n\"\n",
                                    "\"  parameter Real u0["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {%s};\\n\"\n"));
        txt = Tpl.writeText(txt, l_matrixA);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixB);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixC);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixD);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorX);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorU);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorY);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"\\n  "));
        txt = CodegenC.getVarName(txt, i_vars_stateVars, "x", i_varInfo_numStateVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = CodegenC.getVarName(txt, i_vars_inputVars, "u", i_varInfo_numInVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = CodegenC.getVarName(txt, i_vars_outputVars, "y", i_varInfo_numOutVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\n\"\n",
                                    "\"equation\\n  der(x) = A * x + B * u;\\n  y = C * x + D * u;\\nend linear_"
                                }, false));
        txt = CodegenC.dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\\n\"\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionlinearmodel;

public function globalDataFixedInt
  input Tpl.Text in_txt;
  input Boolean in_a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isFixed)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end globalDataFixedInt;

public function globalDataNominalValue
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_nominal;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_nominal)
    local
      Tpl.Text txt;
      DAE.Exp i_v;

    case ( txt,
           NONE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0 /* default */"));
      then txt;

    case ( txt,
           SOME(i_v) )
      equation
        txt = CodegenC.initVal(txt, i_v);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end globalDataNominalValue;

public function globalDataHasNominalValue
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_nominal;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_nominal)
    local
      Tpl.Text txt;

    case ( txt,
           NONE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           SOME(_) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end globalDataHasNominalValue;

public function globalDataAttrInt
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("2"));
      then txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("4"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("4"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("8"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end globalDataAttrInt;

public function globalDataDiscAttrInt
  input Tpl.Text in_txt;
  input Boolean in_a_isDiscrete;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isDiscrete)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("16"));
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end globalDataDiscAttrInt;

end CodegenQSS;