encapsulated package SCodeDumpTpl
"
  file:        SCodeDumpTpl.mo
  package:     SCodeDumpTpl
  description: Generated by Susan.
  
  $Id: TplCodegen.mo 9216 2011-05-31 10:52:47Z sjoelund.se $
"

public import Tpl;

public import Absyn;
public import Dump;
public import SCode;
public import Config;

public function dumpProgram
  input Tpl.Text txt;
  input list<SCode.Element> a_program;

  output Tpl.Text out_txt;
algorithm
  out_txt := dumpElements(txt, a_program, false);
end dumpProgram;

public function dumpElements
  input Tpl.Text txt;
  input list<SCode.Element> a_elements;
  input Boolean a_indent;

  output Tpl.Text out_txt;
algorithm
  out_txt := dumpElements2(txt, a_elements, "", a_indent, true, true);
end dumpElements;

protected function fun_8
  input Tpl.Text in_txt;
  input Boolean in_a_firstElement;
  input String in_a_prevSpacing;
  input Tpl.Text in_a_spacing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_firstElement, in_a_prevSpacing, in_a_spacing)
    local
      Tpl.Text txt;
      String a_prevSpacing;
      Tpl.Text a_spacing;

    case ( txt,
           false,
           a_prevSpacing,
           a_spacing )
      equation
        txt = dumpPreElementSpacing(txt, Tpl.textString(a_spacing), a_prevSpacing);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_8;

protected function fun_9
  input Tpl.Text in_txt;
  input Tpl.Text in_a_vis__str;
  input Boolean in_a_inPublicSection;
  input Boolean in_a_indent;
  input Tpl.Text in_a_spacing;
  input list<SCode.Element> in_a_rest__els;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_vis__str, in_a_inPublicSection, in_a_indent, in_a_spacing, in_a_rest__els)
    local
      Tpl.Text txt;
      Boolean a_inPublicSection;
      Boolean a_indent;
      Tpl.Text a_spacing;
      list<SCode.Element> a_rest__els;
      Boolean ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_inPublicSection,
           a_indent,
           a_spacing,
           a_rest__els )
      equation
        txt = dumpElements2(txt, a_rest__els, Tpl.textString(a_spacing), a_indent, false, a_inPublicSection);
      then txt;

    case ( txt,
           _,
           a_inPublicSection,
           a_indent,
           a_spacing,
           a_rest__els )
      equation
        ret_0 = boolNot(a_inPublicSection);
        txt = dumpElements2(txt, a_rest__els, Tpl.textString(a_spacing), a_indent, false, ret_0);
      then txt;
  end matchcontinue;
end fun_9;

protected function fun_10
  input Tpl.Text in_txt;
  input Tpl.Text in_a_rest__str;
  input Tpl.Text in_a_spacing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_rest__str, in_a_spacing)
    local
      Tpl.Text txt;
      Tpl.Text a_spacing;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_spacing )
      equation
        txt = Tpl.writeText(txt, a_spacing);
      then txt;
  end matchcontinue;
end fun_10;

protected function fun_11
  input Tpl.Text in_txt;
  input Boolean in_a_indent;
  input Tpl.Text in_a_rest__str;
  input Tpl.Text in_a_post__spacing;
  input Tpl.Text in_a_el__str;
  input Tpl.Text in_a_vis__str;
  input Tpl.Text in_a_pre__spacing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_indent, in_a_rest__str, in_a_post__spacing, in_a_el__str, in_a_vis__str, in_a_pre__spacing)
    local
      Tpl.Text txt;
      Tpl.Text a_rest__str;
      Tpl.Text a_post__spacing;
      Tpl.Text a_el__str;
      Tpl.Text a_vis__str;
      Tpl.Text a_pre__spacing;

    case ( txt,
           false,
           a_rest__str,
           a_post__spacing,
           a_el__str,
           a_vis__str,
           a_pre__spacing )
      equation
        txt = Tpl.writeText(txt, a_pre__spacing);
        txt = Tpl.writeText(txt, a_vis__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_el__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_post__spacing);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_rest__str);
      then txt;

    case ( txt,
           _,
           a_rest__str,
           a_post__spacing,
           a_el__str,
           a_vis__str,
           a_pre__spacing )
      equation
        txt = Tpl.writeText(txt, a_pre__spacing);
        txt = Tpl.writeText(txt, a_vis__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_el__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_post__spacing);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, a_rest__str);
      then txt;
  end matchcontinue;
end fun_11;

public function dumpElements2
  input Tpl.Text in_txt;
  input list<SCode.Element> in_a_elements;
  input String in_a_prevSpacing;
  input Boolean in_a_indent;
  input Boolean in_a_firstElement;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_elements, in_a_prevSpacing, in_a_indent, in_a_firstElement, in_a_inPublicSection)
    local
      Tpl.Text txt;
      String a_prevSpacing;
      Boolean a_indent;
      Boolean a_firstElement;
      Boolean a_inPublicSection;
      list<SCode.Element> i_rest__els;
      SCode.Element i_el;
      Tpl.Text l_elements__str;
      Tpl.Text l_post__spacing;
      Tpl.Text l_rest__str;
      Tpl.Text l_vis__str;
      Tpl.Text l_el__str;
      Tpl.Text l_pre__spacing;
      Tpl.Text l_spacing;

    case ( txt,
           i_el :: i_rest__els,
           a_prevSpacing,
           a_indent,
           a_firstElement,
           a_inPublicSection )
      equation
        l_spacing = dumpElementSpacing(Tpl.emptyTxt, i_el);
        l_pre__spacing = fun_8(Tpl.emptyTxt, a_firstElement, a_prevSpacing, l_spacing);
        l_el__str = dumpElement(Tpl.emptyTxt, i_el);
        l_vis__str = dumpElementVisibility(Tpl.emptyTxt, i_el, a_inPublicSection);
        l_rest__str = fun_9(Tpl.emptyTxt, l_vis__str, a_inPublicSection, a_indent, l_spacing, i_rest__els);
        l_post__spacing = fun_10(Tpl.emptyTxt, l_rest__str, l_spacing);
        l_elements__str = fun_11(Tpl.emptyTxt, a_indent, l_rest__str, l_post__spacing, l_el__str, l_vis__str, l_pre__spacing);
        txt = Tpl.writeText(txt, l_elements__str);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end dumpElements2;

protected function fun_13
  input Tpl.Text in_txt;
  input String in_a_prevSpacing;
  input String in_a_curSpacing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_prevSpacing, in_a_curSpacing)
    local
      Tpl.Text txt;
      String a_curSpacing;

    case ( txt,
           "",
           a_curSpacing )
      equation
        txt = Tpl.writeStr(txt, a_curSpacing);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_13;

public function dumpPreElementSpacing
  input Tpl.Text txt;
  input String a_curSpacing;
  input String a_prevSpacing;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_13(txt, a_prevSpacing, a_curSpacing);
end dumpPreElementSpacing;

public function dumpElementSpacing
  input Tpl.Text in_txt;
  input SCode.Element in_a_element;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_element)
    local
      Tpl.Text txt;
      SCode.ClassDef i_classDef;

    case ( txt,
           SCode.CLASS(classDef = i_classDef) )
      equation
        txt = dumpClassDefSpacing(txt, i_classDef);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpElementSpacing;

public function dumpClassDefSpacing
  input Tpl.Text in_txt;
  input SCode.ClassDef in_a_classDef;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_classDef)
    local
      Tpl.Text txt;
      SCode.ClassDef i_composition;
      Option<SCode.Comment> i_comment;

    case ( txt,
           SCode.PARTS(elementLst = {}, normalEquationLst = {}, initialEquationLst = {}, normalAlgorithmLst = {}, initialAlgorithmLst = {}, externalDecl = NONE(), annotationLst = {}, comment = i_comment) )
      equation
        txt = dumpCommentSpacing(txt, i_comment);
      then txt;

    case ( txt,
           SCode.CLASS_EXTENDS(composition = i_composition) )
      equation
        txt = dumpClassDefSpacing(txt, i_composition);
      then txt;

    case ( txt,
           SCode.PARTS(elementLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpClassDefSpacing;

public function dumpCommentSpacing
  input Tpl.Text in_txt;
  input Option<SCode.Comment> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_comment)
    local
      Tpl.Text txt;

    case ( txt,
           SOME(SCode.COMMENT(annotation_ = NONE())) )
      then txt;

    case ( txt,
           SOME(SCode.CLASS_COMMENT(annotations = {})) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end matchcontinue;
end dumpCommentSpacing;

public function dumpElement
  input Tpl.Text in_txt;
  input SCode.Element in_a_element;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_element)
    local
      Tpl.Text txt;
      SCode.Element i_element;

    case ( txt,
           (i_element as SCode.IMPORT(imp = _)) )
      equation
        txt = dumpImport(txt, i_element);
      then txt;

    case ( txt,
           (i_element as SCode.EXTENDS(baseClassPath = _)) )
      equation
        txt = dumpExtends(txt, i_element);
      then txt;

    case ( txt,
           (i_element as SCode.CLASS(name = _)) )
      equation
        txt = dumpClass(txt, i_element);
      then txt;

    case ( txt,
           (i_element as SCode.COMPONENT(name = _)) )
      equation
        txt = dumpComponent(txt, i_element);
      then txt;

    case ( txt,
           (i_element as SCode.DEFINEUNIT(name = _)) )
      equation
        txt = dumpDefineUnit(txt, i_element);
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpElement: Unknown element.");
      then txt;
  end matchcontinue;
end dumpElement;

public function dumpElementVisibility
  input Tpl.Text in_txt;
  input SCode.Element in_a_element;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_element, in_a_inPublicSection)
    local
      Tpl.Text txt;
      Boolean a_inPublicSection;
      SCode.Visibility i_vis;
      SCode.Visibility i_visibility;

    case ( txt,
           SCode.IMPORT(visibility = i_visibility),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_visibility, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.EXTENDS(visibility = i_visibility),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_visibility, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.CLASS(prefixes = SCode.PREFIXES(visibility = i_vis)),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_vis, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.COMPONENT(prefixes = SCode.PREFIXES(visibility = i_vis)),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_vis, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.DEFINEUNIT(visibility = i_visibility),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_visibility, a_inPublicSection);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end dumpElementVisibility;

protected function fun_20
  input Tpl.Text in_txt;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_inPublicSection)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("public"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_20;

protected function fun_21
  input Tpl.Text in_txt;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_inPublicSection)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("protected"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end matchcontinue;
end fun_21;

public function dumpSectionVisibility
  input Tpl.Text in_txt;
  input SCode.Visibility in_a_visibility;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_visibility, in_a_inPublicSection)
    local
      Tpl.Text txt;
      Boolean a_inPublicSection;

    case ( txt,
           SCode.PUBLIC(),
           a_inPublicSection )
      equation
        txt = fun_20(txt, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.PROTECTED(),
           a_inPublicSection )
      equation
        txt = fun_21(txt, a_inPublicSection);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end dumpSectionVisibility;

protected function fun_23
  input Tpl.Text in_txt;
  input Absyn.Import in_a_imp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_imp)
    local
      Tpl.Text txt;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.NAMED_IMPORT(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("import "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = dumpPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.QUAL_IMPORT(path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("import "));
        txt = dumpPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.UNQUAL_IMPORT(path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("import "));
        txt = dumpPath(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".*"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpImport: Unknown import.");
      then txt;
  end matchcontinue;
end fun_23;

public function dumpImport
  input Tpl.Text in_txt;
  input SCode.Element in_a_import;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_import)
    local
      Tpl.Text txt;
      Absyn.Import i_imp;
      SCode.Visibility i_visibility;
      Tpl.Text l_import__str;
      Tpl.Text l_visibility__str;

    case ( txt,
           SCode.IMPORT(visibility = i_visibility, imp = i_imp) )
      equation
        l_visibility__str = dumpVisibility(Tpl.emptyTxt, i_visibility);
        l_import__str = fun_23(Tpl.emptyTxt, i_imp);
        txt = Tpl.writeText(txt, l_visibility__str);
        txt = Tpl.writeText(txt, l_import__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpImport;

public function dumpExtends
  input Tpl.Text in_txt;
  input SCode.Element in_a_extends;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extends)
    local
      Tpl.Text txt;
      Option<SCode.Annotation> i_ann;
      SCode.Mod i_modifications;
      SCode.Visibility i_visibility;
      SCode.Path i_baseClassPath;
      Tpl.Text l_ann__str;
      Tpl.Text l_mod__str;
      Tpl.Text l_visibility__str;
      Tpl.Text l_bc__str;

    case ( txt,
           SCode.EXTENDS(baseClassPath = i_baseClassPath, visibility = i_visibility, modifications = i_modifications, ann = i_ann) )
      equation
        l_bc__str = dumpPath(Tpl.emptyTxt, i_baseClassPath);
        l_visibility__str = dumpVisibility(Tpl.emptyTxt, i_visibility);
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications);
        l_ann__str = dumpAnnotationOpt(Tpl.emptyTxt, i_ann);
        txt = Tpl.writeText(txt, l_visibility__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extends "));
        txt = Tpl.writeText(txt, l_bc__str);
        txt = Tpl.writeText(txt, l_mod__str);
        txt = Tpl.writeText(txt, l_ann__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpExtends;

public function dumpClass
  input Tpl.Text in_txt;
  input SCode.Element in_a_class;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_class)
    local
      Tpl.Text txt;
      SCode.Ident i_name;
      SCode.ClassDef i_classDef;
      SCode.Restriction i_restriction;
      SCode.Partial i_partialPrefix;
      SCode.Encapsulated i_encapsulatedPrefix;
      SCode.Prefixes i_prefixes;
      Tpl.Text l_footer__str;
      Tpl.Text l_header__str;
      Tpl.Text l_cdef__str;
      Tpl.Text l_prefixes__str;
      Tpl.Text l_res__str;
      Tpl.Text l_partial__str;
      Tpl.Text l_enc__str;
      Tpl.Text l_prefix__str;

    case ( txt,
           SCode.CLASS(prefixes = i_prefixes, encapsulatedPrefix = i_encapsulatedPrefix, partialPrefix = i_partialPrefix, restriction = i_restriction, classDef = i_classDef, name = i_name) )
      equation
        l_prefix__str = dumpPrefixes(Tpl.emptyTxt, i_prefixes);
        l_enc__str = dumpEncapsulated(Tpl.emptyTxt, i_encapsulatedPrefix);
        l_partial__str = dumpPartial(Tpl.emptyTxt, i_partialPrefix);
        l_res__str = dumpRestriction(Tpl.emptyTxt, i_restriction);
        l_prefixes__str = Tpl.writeText(Tpl.emptyTxt, l_prefix__str);
        l_prefixes__str = Tpl.writeText(l_prefixes__str, l_enc__str);
        l_prefixes__str = Tpl.writeText(l_prefixes__str, l_partial__str);
        l_prefixes__str = Tpl.writeText(l_prefixes__str, l_res__str);
        l_cdef__str = dumpClassDef(Tpl.emptyTxt, i_classDef);
        l_header__str = dumpClassHeader(Tpl.emptyTxt, i_classDef, i_name);
        l_footer__str = dumpClassFooter(Tpl.emptyTxt, i_classDef, Tpl.textString(l_cdef__str), i_name);
        txt = Tpl.writeText(txt, l_prefixes__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_header__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_footer__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpClass;

public function dumpClassHeader
  input Tpl.Text in_txt;
  input SCode.ClassDef in_a_classDef;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_classDef, in_a_name)
    local
      Tpl.Text txt;
      String a_name;

    case ( txt,
           SCode.CLASS_EXTENDS(baseClassName = _),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extends "));
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;
  end matchcontinue;
end dumpClassHeader;

protected function lm_28
  input Tpl.Text in_txt;
  input list<SCode.Annotation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Annotation> rest;
      SCode.Annotation i_ann;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ann :: rest )
      equation
        txt = dumpAnnotationElement(txt, i_ann);
        txt = Tpl.nextIter(txt);
        txt = lm_28(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_28(txt, rest);
      then txt;
  end matchcontinue;
end lm_28;

protected function fun_29
  input Tpl.Text in_txt;
  input Tpl.Text in_a_cdef__str;
  input Option<SCode.Comment> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cdef__str, in_a_comment)
    local
      Tpl.Text txt;
      Option<SCode.Comment> a_comment;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_comment )
      equation
        txt = dumpClassComment(txt, a_comment);
      then txt;

    case ( txt,
           _,
           a_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpClassComment(txt, a_comment);
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_29;

protected function lm_30
  input Tpl.Text in_txt;
  input list<SCode.Enum> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Enum> rest;
      SCode.Enum i_enum;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_enum :: rest )
      equation
        txt = dumpEnumLiteral(txt, i_enum);
        txt = Tpl.nextIter(txt);
        txt = lm_30(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_30(txt, rest);
      then txt;
  end matchcontinue;
end lm_30;

protected function fun_31
  input Tpl.Text in_txt;
  input list<SCode.Enum> in_a_enumLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_enumLst)
    local
      Tpl.Text txt;
      list<SCode.Enum> i_enumLst;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           i_enumLst )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_30(txt, i_enumLst);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_31;

protected function lm_32
  input Tpl.Text in_txt;
  input list<SCode.Ident> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Ident> rest;
      SCode.Ident i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_32(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_32(txt, rest);
      then txt;
  end matchcontinue;
end lm_32;

protected function lm_33
  input Tpl.Text in_txt;
  input list<Absyn.Path> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Path> rest;
      Absyn.Path i_path;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_path :: rest )
      equation
        txt = dumpPath(txt, i_path);
        txt = Tpl.nextIter(txt);
        txt = lm_33(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_33(txt, rest);
      then txt;
  end matchcontinue;
end lm_33;

public function dumpClassDef
  input Tpl.Text in_txt;
  input SCode.ClassDef in_a_classDef;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_classDef)
    local
      Tpl.Text txt;
      list<Absyn.Path> i_pathLst;
      list<SCode.Ident> i_derivedVariables;
      Absyn.Path i_functionPath;
      list<SCode.Enum> i_enumLst;
      SCode.Attributes i_attributes;
      Absyn.TypeSpec i_typeSpec;
      SCode.ClassDef i_composition;
      SCode.Mod i_modifications;
      Option<SCode.Comment> i_comment;
      list<SCode.Annotation> i_annotationLst;
      Option<SCode.ExternalDecl> i_externalDecl;
      list<SCode.AlgorithmSection> i_initialAlgorithmLst;
      list<SCode.AlgorithmSection> i_normalAlgorithmLst;
      list<SCode.Equation> i_initialEquationLst;
      list<SCode.Equation> i_normalEquationLst;
      list<SCode.Element> i_elementLst;
      Tpl.Text l_func__str;
      Tpl.Text l_enum__str;
      Tpl.Text l_attr__str;
      Tpl.Text l_type__str;
      Tpl.Text l_mod__str;
      Tpl.Text l_cmt__str;
      Tpl.Text l_cdef__str;
      Tpl.Text l_annl__str;
      Tpl.Text l_extdecl__str;
      Tpl.Text l_ial__str;
      Tpl.Text l_nal__str;
      Tpl.Text l_ieq__str;
      Tpl.Text l_neq__str;
      Tpl.Text l_el__str;

    case ( txt,
           SCode.PARTS(elementLst = i_elementLst, normalEquationLst = i_normalEquationLst, initialEquationLst = i_initialEquationLst, normalAlgorithmLst = i_normalAlgorithmLst, initialAlgorithmLst = i_initialAlgorithmLst, externalDecl = i_externalDecl, annotationLst = i_annotationLst, comment = i_comment) )
      equation
        l_el__str = dumpElements(Tpl.emptyTxt, i_elementLst, true);
        l_neq__str = dumpEquations(Tpl.emptyTxt, i_normalEquationLst, "equation");
        l_ieq__str = dumpEquations(Tpl.emptyTxt, i_initialEquationLst, "initial equation");
        l_nal__str = dumpAlgorithmSections(Tpl.emptyTxt, i_normalAlgorithmLst, "algorithm");
        l_ial__str = dumpAlgorithmSections(Tpl.emptyTxt, i_initialAlgorithmLst, "initial algorithm");
        l_extdecl__str = dumpExternalDeclOpt(Tpl.emptyTxt, i_externalDecl);
        l_annl__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_annl__str = lm_28(l_annl__str, i_annotationLst);
        l_annl__str = Tpl.popIter(l_annl__str);
        l_cdef__str = Tpl.writeText(Tpl.emptyTxt, l_el__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.pushBlock(l_cdef__str, Tpl.BT_INDENT(2));
        l_cdef__str = Tpl.writeText(l_cdef__str, l_annl__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.popBlock(l_cdef__str);
        l_cdef__str = Tpl.writeText(l_cdef__str, l_ieq__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.writeText(l_cdef__str, l_ial__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.writeText(l_cdef__str, l_neq__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.writeText(l_cdef__str, l_nal__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.pushBlock(l_cdef__str, Tpl.BT_INDENT(2));
        l_cdef__str = Tpl.writeText(l_cdef__str, l_extdecl__str);
        l_cdef__str = Tpl.popBlock(l_cdef__str);
        l_cmt__str = fun_29(Tpl.emptyTxt, l_cdef__str, i_comment);
        txt = Tpl.writeText(txt, l_cdef__str);
      then txt;

    case ( txt,
           SCode.CLASS_EXTENDS(modifications = i_modifications, composition = i_composition) )
      equation
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications);
        l_cdef__str = dumpClassDef(Tpl.emptyTxt, i_composition);
        txt = Tpl.writeText(txt, l_cdef__str);
      then txt;

    case ( txt,
           SCode.DERIVED(typeSpec = i_typeSpec, modifications = i_modifications, attributes = i_attributes, comment = i_comment) )
      equation
        l_type__str = dumpTypeSpec(Tpl.emptyTxt, i_typeSpec);
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications);
        l_attr__str = dumpAttributes(Tpl.emptyTxt, i_attributes);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = Tpl.writeText(txt, l_attr__str);
        txt = Tpl.writeText(txt, l_type__str);
        txt = Tpl.writeText(txt, l_mod__str);
        txt = Tpl.writeText(txt, l_cmt__str);
      then txt;

    case ( txt,
           SCode.ENUMERATION(enumLst = i_enumLst, comment = i_comment) )
      equation
        l_enum__str = fun_31(Tpl.emptyTxt, i_enumLst);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= enumeration("));
        txt = Tpl.writeText(txt, l_enum__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
      then txt;

    case ( txt,
           SCode.PDER(functionPath = i_functionPath, comment = i_comment, derivedVariables = i_derivedVariables) )
      equation
        l_func__str = dumpPath(Tpl.emptyTxt, i_functionPath);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= der("));
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_32(txt, i_derivedVariables);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
      then txt;

    case ( txt,
           SCode.OVERLOAD(comment = i_comment, pathLst = i_pathLst) )
      equation
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= overload("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_33(txt, i_pathLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpClassDef: Unknown class definition.");
      then txt;
  end matchcontinue;
end dumpClassDef;

protected function fun_35
  input Tpl.Text in_txt;
  input String in_a_cdefStr;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cdefStr, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      String i_cdefStr;

    case ( txt,
           "",
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           i_cdefStr,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeStr(txt, i_cdefStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeStr(txt, a_name);
      then txt;
  end matchcontinue;
end fun_35;

public function dumpClassFooter
  input Tpl.Text in_txt;
  input SCode.ClassDef in_a_classDef;
  input String in_a_cdefStr;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_classDef, in_a_cdefStr, in_a_name)
    local
      Tpl.Text txt;
      String a_cdefStr;
      String a_name;

    case ( txt,
           SCode.DERIVED(typeSpec = _),
           a_cdefStr,
           _ )
      equation
        txt = Tpl.writeStr(txt, a_cdefStr);
      then txt;

    case ( txt,
           SCode.ENUMERATION(enumLst = _),
           a_cdefStr,
           _ )
      equation
        txt = Tpl.writeStr(txt, a_cdefStr);
      then txt;

    case ( txt,
           SCode.PDER(functionPath = _),
           a_cdefStr,
           _ )
      equation
        txt = Tpl.writeStr(txt, a_cdefStr);
      then txt;

    case ( txt,
           _,
           a_cdefStr,
           a_name )
      equation
        txt = fun_35(txt, a_cdefStr, a_name);
      then txt;
  end matchcontinue;
end dumpClassFooter;

public function dumpClassComment
  input Tpl.Text in_txt;
  input Option<SCode.Comment> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      SCode.Comment i_cmt;

    case ( txt,
           SOME(SCode.CLASS_COMMENT(comment = SOME(i_cmt))) )
      equation
        txt = dumpComment(txt, i_cmt);
      then txt;

    case ( txt,
           SOME((i_cmt as SCode.COMMENT(annotation_ = _))) )
      equation
        txt = dumpComment(txt, i_cmt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpClassComment;

protected function fun_38
  input Tpl.Text in_txt;
  input Option<Absyn.Exp> in_a_condition;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_condition)
    local
      Tpl.Text txt;
      Absyn.Exp i_cond;

    case ( txt,
           SOME(i_cond) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = dumpExp(txt, i_cond);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_38;

public function dumpComponent
  input Tpl.Text in_txt;
  input SCode.Element in_a_component;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_component)
    local
      Tpl.Text txt;
      SCode.Ident i_name;
      Option<SCode.Comment> i_comment;
      Option<Absyn.Exp> i_condition;
      SCode.Mod i_modifications;
      Absyn.TypeSpec i_typeSpec;
      SCode.Attributes i_attributes;
      SCode.Prefixes i_prefixes;
      Tpl.Text l_cmt__str;
      Tpl.Text l_cond__str;
      Tpl.Text l_mod__str;
      Tpl.Text l_type__str;
      Tpl.Text l_attr__dim__str;
      Tpl.Text l_attr__pre__str;
      Tpl.Text l_cc__str;
      Tpl.Text l_prefix__str;

    case ( txt,
           SCode.COMPONENT(prefixes = i_prefixes, attributes = i_attributes, typeSpec = i_typeSpec, modifications = i_modifications, condition = i_condition, comment = i_comment, name = i_name) )
      equation
        l_prefix__str = dumpPrefixes(Tpl.emptyTxt, i_prefixes);
        l_cc__str = dumpReplaceableConstrainClass(Tpl.emptyTxt, i_prefixes);
        l_attr__pre__str = dumpAttributes(Tpl.emptyTxt, i_attributes);
        l_attr__dim__str = dumpAttributeDim(Tpl.emptyTxt, i_attributes);
        l_type__str = dumpTypeSpec(Tpl.emptyTxt, i_typeSpec);
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications);
        l_cond__str = fun_38(Tpl.emptyTxt, i_condition);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_prefix__str);
        txt = Tpl.writeText(txt, l_attr__pre__str);
        txt = Tpl.writeText(txt, l_type__str);
        txt = Tpl.writeText(txt, l_attr__dim__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeText(txt, l_mod__str);
        txt = Tpl.writeText(txt, l_cc__str);
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeText(txt, l_cmt__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpComponent;

protected function fun_40
  input Tpl.Text in_txt;
  input Option<String> in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      String i_e;

    case ( txt,
           SOME(i_e) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("exp = \""));
        txt = Tpl.writeStr(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_40;

protected function fun_41
  input Tpl.Text in_txt;
  input Option<Real> in_a_weight;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_weight)
    local
      Tpl.Text txt;
      Real i_w;

    case ( txt,
           SOME(i_w) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("weight = "));
        txt = Tpl.writeStr(txt, realString(i_w));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_41;

protected function smf_42
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_42;

protected function smf_43
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_43;

protected function fun_44
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_args__str)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
      then txt;
  end matchcontinue;
end fun_44;

protected function fun_45
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_args__str)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_45;

public function dumpDefineUnit
  input Tpl.Text in_txt;
  input SCode.Element in_a_defineUnit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_defineUnit)
    local
      Tpl.Text txt;
      SCode.Ident i_name;
      Option<Real> i_weight;
      Option<String> i_exp;
      SCode.Visibility i_visibility;
      Tpl.Text l_pe;
      Tpl.Text l_pb;
      Tpl.Text l_args__str;
      Tpl.Text l_weight__str;
      Tpl.Text l_exp__str;
      Tpl.Text l_vis__str;

    case ( txt,
           SCode.DEFINEUNIT(visibility = i_visibility, exp = i_exp, weight = i_weight, name = i_name) )
      equation
        l_vis__str = dumpVisibility(Tpl.emptyTxt, i_visibility);
        l_exp__str = fun_40(Tpl.emptyTxt, i_exp);
        l_weight__str = fun_41(Tpl.emptyTxt, i_weight);
        l_args__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_args__str = smf_42(l_args__str, l_exp__str);
        l_args__str = smf_43(l_args__str, l_weight__str);
        l_args__str = Tpl.popIter(l_args__str);
        l_pb = fun_44(Tpl.emptyTxt, l_args__str);
        l_pe = fun_45(Tpl.emptyTxt, l_args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("defineunit "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeText(txt, l_pb);
        txt = Tpl.writeText(txt, l_args__str);
        txt = Tpl.writeText(txt, l_pe);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpDefineUnit;

public function dumpEnumLiteral
  input Tpl.Text in_txt;
  input SCode.Enum in_a_enum;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_enum)
    local
      Tpl.Text txt;
      SCode.Ident i_literal;
      Option<SCode.Comment> i_comment;
      Tpl.Text l_cmt__str;

    case ( txt,
           SCode.ENUM(comment = i_comment, literal = i_literal) )
      equation
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeStr(txt, i_literal);
        txt = Tpl.writeText(txt, l_cmt__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpEnumLiteral;

protected function lm_48
  input Tpl.Text in_txt;
  input list<SCode.Equation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Equation> rest;
      SCode.Equation i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = dumpEquation(txt, i_eq);
        txt = Tpl.nextIter(txt);
        txt = lm_48(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_48(txt, rest);
      then txt;
  end matchcontinue;
end lm_48;

public function dumpEquations
  input Tpl.Text in_txt;
  input list<SCode.Equation> in_a_equations;
  input String in_a_label;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_equations, in_a_label)
    local
      Tpl.Text txt;
      String a_label;
      list<SCode.Equation> i_equations;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_equations,
           a_label )
      equation
        txt = Tpl.writeStr(txt, a_label);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_48(txt, i_equations);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end dumpEquations;

public function dumpEquation
  input Tpl.Text in_txt;
  input SCode.Equation in_a_equation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_equation)
    local
      Tpl.Text txt;
      SCode.EEquation i_eEquation;

    case ( txt,
           SCode.EQUATION(eEquation = i_eEquation) )
      equation
        txt = dumpEEquation(txt, i_eEquation);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpEquation;

public function dumpEEquation
  input Tpl.Text in_txt;
  input SCode.EEquation in_a_equation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_equation)
    local
      Tpl.Text txt;
      Absyn.FunctionArgs i_functionArgs;
      Absyn.ComponentRef i_functionName;
      Absyn.Exp i_expReinit;
      Absyn.ComponentRef i_cref;
      Absyn.Exp i_message;
      Absyn.Exp i_condition;
      Absyn.ComponentRef i_crefRight;
      Absyn.ComponentRef i_crefLeft;
      Option<SCode.Comment> i_comment;
      Absyn.Exp i_expRight;
      Absyn.Exp i_expLeft;
      SCode.EEquation i_equation;
      Tpl.Text l_args__str;
      Tpl.Text l_func__str;
      Tpl.Text l_exp__str;
      Tpl.Text l_cref__str;
      Tpl.Text l_msg__str;
      Tpl.Text l_cond__str;
      Tpl.Text l_cmt__str;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           (i_equation as SCode.EQ_IF(condition = _)) )
      equation
        txt = dumpIfEEquation(txt, i_equation);
      then txt;

    case ( txt,
           SCode.EQ_EQUALS(expLeft = i_expLeft, expRight = i_expRight, comment = i_comment) )
      equation
        l_lhs__str = dumpExp(Tpl.emptyTxt, i_expLeft);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_expRight);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.EQ_CONNECT(crefLeft = i_crefLeft, crefRight = i_crefRight, comment = i_comment) )
      equation
        l_lhs__str = dumpCref(Tpl.emptyTxt, i_crefLeft);
        l_rhs__str = dumpCref(Tpl.emptyTxt, i_crefRight);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("connect("));
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           (i_equation as SCode.EQ_FOR(index = _)) )
      equation
        txt = dumpForEEquation(txt, i_equation);
      then txt;

    case ( txt,
           (i_equation as SCode.EQ_WHEN(condition = _)) )
      equation
        txt = dumpWhenEEquation(txt, i_equation);
      then txt;

    case ( txt,
           SCode.EQ_ASSERT(condition = i_condition, message = i_message, comment = i_comment) )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, i_condition);
        l_msg__str = dumpExp(Tpl.emptyTxt, i_message);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assert("));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_msg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.EQ_TERMINATE(message = i_message, comment = i_comment) )
      equation
        l_msg__str = dumpExp(Tpl.emptyTxt, i_message);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("terminate("));
        txt = Tpl.writeText(txt, l_msg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.EQ_REINIT(cref = i_cref, expReinit = i_expReinit, comment = i_comment) )
      equation
        l_cref__str = dumpCref(Tpl.emptyTxt, i_cref);
        l_exp__str = dumpExp(Tpl.emptyTxt, i_expReinit);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("reinit("));
        txt = Tpl.writeText(txt, l_cref__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.EQ_NORETCALL(functionName = i_functionName, functionArgs = i_functionArgs, comment = i_comment) )
      equation
        l_func__str = dumpCref(Tpl.emptyTxt, i_functionName);
        l_args__str = dumpFunctionArgs(Tpl.emptyTxt, i_functionArgs);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpEEquation: Unknown EEquation.");
      then txt;
  end matchcontinue;
end dumpEEquation;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_52(txt, rest);
      then txt;
  end matchcontinue;
end lm_52;

protected function lm_53
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_53(txt, rest);
      then txt;
  end matchcontinue;
end lm_53;

protected function fun_54
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_a_elseBranch;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_elseBranch)
    local
      Tpl.Text txt;
      list<SCode.EEquation> i_elseBranch;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_elseBranch )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_53(txt, i_elseBranch);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_54;

public function dumpIfEEquation
  input Tpl.Text in_txt;
  input SCode.EEquation in_a_ifequation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ifequation)
    local
      Tpl.Text txt;
      list<SCode.EEquation> i_elseBranch;
      list<list<SCode.EEquation>> i_elseif__branches;
      list<Absyn.Exp> i_elseif__conds;
      list<SCode.EEquation> i_if__branch;
      Absyn.Exp i_if__cond;
      Tpl.Text l_else__str;
      Tpl.Text l_elseif__str;
      Tpl.Text l_if__branch__str;
      Tpl.Text l_if__cond__str;

    case ( txt,
           SCode.EQ_IF(condition = i_if__cond :: i_elseif__conds, thenBranch = i_if__branch :: i_elseif__branches, elseBranch = i_elseBranch) )
      equation
        l_if__cond__str = dumpExp(Tpl.emptyTxt, i_if__cond);
        l_if__branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_if__branch__str = lm_52(l_if__branch__str, i_if__branch);
        l_if__branch__str = Tpl.popIter(l_if__branch__str);
        l_elseif__str = dumpElseIfEEquation(Tpl.emptyTxt, i_elseif__conds, i_elseif__branches);
        l_else__str = fun_54(Tpl.emptyTxt, i_elseBranch);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_if__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_if__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_elseif__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_else__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end if;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpIfEEquation;

protected function lm_56
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_56(txt, rest);
      then txt;
  end matchcontinue;
end lm_56;

protected function fun_57
  input Tpl.Text in_txt;
  input list<list<SCode.EEquation>> in_a_branches;
  input list<Absyn.Exp> in_a_rest__conds;
  input Absyn.Exp in_a_cond;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_branches, in_a_rest__conds, in_a_cond)
    local
      Tpl.Text txt;
      list<Absyn.Exp> a_rest__conds;
      Absyn.Exp a_cond;
      list<list<SCode.EEquation>> i_rest__branches;
      list<SCode.EEquation> i_branch;
      Tpl.Text l_rest__str;
      Tpl.Text l_branch__str;
      Tpl.Text l_cond__str;

    case ( txt,
           i_branch :: i_rest__branches,
           a_rest__conds,
           a_cond )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, a_cond);
        l_branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_branch__str = lm_56(l_branch__str, i_branch);
        l_branch__str = Tpl.popIter(l_branch__str);
        l_rest__str = dumpElseIfEEquation(Tpl.emptyTxt, a_rest__conds, i_rest__branches);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elseif "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_rest__str);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_57;

public function dumpElseIfEEquation
  input Tpl.Text in_txt;
  input list<Absyn.Exp> in_a_condition;
  input list<list<SCode.EEquation>> in_a_branches;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_condition, in_a_branches)
    local
      Tpl.Text txt;
      list<list<SCode.EEquation>> a_branches;
      list<Absyn.Exp> i_rest__conds;
      Absyn.Exp i_cond;

    case ( txt,
           i_cond :: i_rest__conds,
           a_branches )
      equation
        txt = fun_57(txt, a_branches, i_rest__conds, i_cond);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end dumpElseIfEEquation;

protected function lm_59
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_59(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_59(txt, rest);
      then txt;
  end matchcontinue;
end lm_59;

public function dumpForEEquation
  input Tpl.Text in_txt;
  input SCode.EEquation in_a_for__equation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_for__equation)
    local
      Tpl.Text txt;
      SCode.Ident i_index;
      Option<SCode.Comment> i_comment;
      list<SCode.EEquation> i_eEquationLst;
      Absyn.Exp i_range;
      Tpl.Text l_cmt__str;
      Tpl.Text l_eq__str;
      Tpl.Text l_range__str;

    case ( txt,
           SCode.EQ_FOR(range = i_range, eEquationLst = i_eEquationLst, comment = i_comment, index = i_index) )
      equation
        l_range__str = dumpExp(Tpl.emptyTxt, i_range);
        l_eq__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_eq__str = lm_59(l_eq__str, i_eEquationLst);
        l_eq__str = Tpl.popIter(l_eq__str);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for "));
        txt = Tpl.writeStr(txt, i_index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" in "));
        txt = Tpl.writeText(txt, l_range__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" loop"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_eq__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpForEEquation;

protected function lm_61
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_61(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_61(txt, rest);
      then txt;
  end matchcontinue;
end lm_61;

protected function lm_62
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_62(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_62(txt, rest);
      then txt;
  end matchcontinue;
end lm_62;

protected function lm_63
  input Tpl.Text in_txt;
  input list<tuple<Absyn.Exp, list<SCode.EEquation>>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<Absyn.Exp, list<SCode.EEquation>>> rest;
      list<SCode.EEquation> i_else__body;
      Absyn.Exp i_else__cond;
      Tpl.Text l_else__body__str;
      Tpl.Text l_else__cond__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_else__cond, i_else__body) :: rest )
      equation
        l_else__cond__str = dumpExp(Tpl.emptyTxt, i_else__cond);
        l_else__body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_else__body__str = lm_62(l_else__body__str, i_else__body);
        l_else__body__str = Tpl.popIter(l_else__body__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elsewhen "));
        txt = Tpl.writeText(txt, l_else__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_else__body__str);
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_63(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_63(txt, rest);
      then txt;
  end matchcontinue;
end lm_63;

public function dumpWhenEEquation
  input Tpl.Text in_txt;
  input SCode.EEquation in_a_when__equation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_when__equation)
    local
      Tpl.Text txt;
      Option<SCode.Comment> i_comment;
      list<tuple<Absyn.Exp, list<SCode.EEquation>>> i_elseBranches;
      list<SCode.EEquation> i_eEquationLst;
      Absyn.Exp i_condition;
      Tpl.Text l_cmt__str;
      Tpl.Text l_else__str;
      Tpl.Text l_body__str;
      Tpl.Text l_cond__str;

    case ( txt,
           SCode.EQ_WHEN(condition = i_condition, eEquationLst = i_eEquationLst, elseBranches = i_elseBranches, comment = i_comment) )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, i_condition);
        l_body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__str = lm_61(l_body__str, i_eEquationLst);
        l_body__str = Tpl.popIter(l_body__str);
        l_else__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_else__str = lm_63(l_else__str, i_elseBranches);
        l_else__str = Tpl.popIter(l_else__str);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_else__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpWhenEEquation;

protected function lm_65
  input Tpl.Text in_txt;
  input list<SCode.AlgorithmSection> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.AlgorithmSection> rest;
      SCode.AlgorithmSection i_al;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_al :: rest )
      equation
        txt = dumpAlgorithmSection(txt, i_al);
        txt = Tpl.nextIter(txt);
        txt = lm_65(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_65(txt, rest);
      then txt;
  end matchcontinue;
end lm_65;

public function dumpAlgorithmSections
  input Tpl.Text in_txt;
  input list<SCode.AlgorithmSection> in_a_algorithms;
  input String in_a_label;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_algorithms, in_a_label)
    local
      Tpl.Text txt;
      String a_label;
      list<SCode.AlgorithmSection> i_algorithms;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_algorithms,
           a_label )
      equation
        txt = Tpl.writeStr(txt, a_label);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_65(txt, i_algorithms);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end dumpAlgorithmSections;

public function dumpAlgorithmSection
  input Tpl.Text in_txt;
  input SCode.AlgorithmSection in_a_algorithm;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_algorithm)
    local
      Tpl.Text txt;
      list<SCode.Statement> i_statements;

    case ( txt,
           SCode.ALGORITHM(statements = i_statements) )
      equation
        txt = dumpStatements(txt, i_statements);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpAlgorithmSection;

protected function lm_68
  input Tpl.Text in_txt;
  input list<SCode.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Statement> rest;
      SCode.Statement i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = dumpStatement(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_68(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_68(txt, rest);
      then txt;
  end matchcontinue;
end lm_68;

public function dumpStatements
  input Tpl.Text txt;
  input list<SCode.Statement> a_statements;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_68(out_txt, a_statements);
  out_txt := Tpl.popIter(out_txt);
end dumpStatements;

public function dumpStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_statement;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_statement)
    local
      Tpl.Text txt;
      Absyn.FunctionArgs i_functionArgs;
      Absyn.ComponentRef i_functionCall;
      SCode.Statement i_statement;
      Option<SCode.Comment> i_comment;
      Absyn.Exp i_value;
      Absyn.Exp i_assignComponent;
      Tpl.Text l_args__str;
      Tpl.Text l_func__str;
      Tpl.Text l_cmt__str;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           SCode.ALG_ASSIGN(assignComponent = i_assignComponent, value = i_value, comment = i_comment) )
      equation
        l_lhs__str = dumpExp(Tpl.emptyTxt, i_assignComponent);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_value);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" := "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_IF(boolExpr = _)) )
      equation
        txt = dumpIfStatement(txt, i_statement);
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_FOR(iterators = _)) )
      equation
        txt = dumpForStatement(txt, i_statement);
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_WHILE(boolExpr = _)) )
      equation
        txt = dumpWhileStatement(txt, i_statement);
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_WHEN_A(branches = _)) )
      equation
        txt = dumpWhenStatement(txt, i_statement);
      then txt;

    case ( txt,
           SCode.ALG_NORETCALL(functionCall = i_functionCall, functionArgs = i_functionArgs, comment = i_comment) )
      equation
        l_func__str = dumpCref(Tpl.emptyTxt, i_functionCall);
        l_args__str = dumpFunctionArgs(Tpl.emptyTxt, i_functionArgs);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.ALG_RETURN(comment = i_comment) )
      equation
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.ALG_BREAK(comment = i_comment) )
      equation
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpStatement: Unknown statement.");
      then txt;
  end matchcontinue;
end dumpStatement;

public function dumpIfStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_if__statement;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_if__statement)
    local
      Tpl.Text txt;
      Option<SCode.Comment> i_comment;
      list<SCode.Statement> i_elseBranch;
      list<tuple<Absyn.Exp, list<SCode.Statement>>> i_elseIfBranch;
      list<SCode.Statement> i_trueBranch;
      Absyn.Exp i_boolExpr;
      Tpl.Text l_cmt__str;
      Tpl.Text l_else__branch__str;
      Tpl.Text l_else__if__str;
      Tpl.Text l_true__branch__str;
      Tpl.Text l_cond__str;

    case ( txt,
           SCode.ALG_IF(boolExpr = i_boolExpr, trueBranch = i_trueBranch, elseIfBranch = i_elseIfBranch, elseBranch = i_elseBranch, comment = i_comment) )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, i_boolExpr);
        l_true__branch__str = dumpStatements(Tpl.emptyTxt, i_trueBranch);
        l_else__if__str = dumpElseIfStatements(Tpl.emptyTxt, i_elseIfBranch);
        l_else__branch__str = dumpStatements(Tpl.emptyTxt, i_elseBranch);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_true__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_else__if__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_else__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end if;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpIfStatement;

protected function lm_72
  input Tpl.Text in_txt;
  input list<tuple<Absyn.Exp, list<SCode.Statement>>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<Absyn.Exp, list<SCode.Statement>>> rest;
      list<SCode.Statement> i_body;
      Absyn.Exp i_cond;
      Tpl.Text l_body__str;
      Tpl.Text l_cond__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_cond, i_body) :: rest )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, i_cond);
        l_body__str = dumpStatements(Tpl.emptyTxt, i_body);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elseif "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_72(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_72(txt, rest);
      then txt;
  end matchcontinue;
end lm_72;

public function dumpElseIfStatements
  input Tpl.Text txt;
  input list<tuple<Absyn.Exp, list<SCode.Statement>>> a_else__if;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_72(out_txt, a_else__if);
  out_txt := Tpl.popIter(out_txt);
end dumpElseIfStatements;

protected function lm_74
  input Tpl.Text in_txt;
  input Absyn.ForIterators in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      Absyn.ForIterators rest;
      Absyn.ForIterator i_i;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_i :: rest )
      equation
        txt = dumpForIterator(txt, i_i);
        txt = Tpl.nextIter(txt);
        txt = lm_74(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_74(txt, rest);
      then txt;
  end matchcontinue;
end lm_74;

public function dumpForStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_for__statement;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_for__statement)
    local
      Tpl.Text txt;
      Option<SCode.Comment> i_comment;
      list<SCode.Statement> i_forBody;
      Absyn.ForIterators i_iterators;
      Tpl.Text l_cmt__str;
      Tpl.Text l_body__str;
      Tpl.Text l_iter__str;

    case ( txt,
           SCode.ALG_FOR(iterators = i_iterators, forBody = i_forBody, comment = i_comment) )
      equation
        l_iter__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_iter__str = lm_74(l_iter__str, i_iterators);
        l_iter__str = Tpl.popIter(l_iter__str);
        l_body__str = dumpStatements(Tpl.emptyTxt, i_forBody);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for "));
        txt = Tpl.writeText(txt, l_iter__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" loop"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpForStatement;

protected function fun_76
  input Tpl.Text in_txt;
  input Option<Absyn.Exp> in_a_range;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_range)
    local
      Tpl.Text txt;
      Absyn.Exp i_r;

    case ( txt,
           SOME(i_r) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("in "));
        txt = dumpExp(txt, i_r);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_76;

protected function fun_77
  input Tpl.Text in_txt;
  input Option<Absyn.Exp> in_a_guardExp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_guardExp)
    local
      Tpl.Text txt;
      Absyn.Exp i_g;

    case ( txt,
           SOME(i_g) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("guard "));
        txt = dumpExp(txt, i_g);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_77;

public function dumpForIterator
  input Tpl.Text in_txt;
  input Absyn.ForIterator in_a_iterator;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_iterator)
    local
      Tpl.Text txt;
      String i_name;
      Option<Absyn.Exp> i_guardExp;
      Option<Absyn.Exp> i_range;
      Tpl.Text l_guard__str;
      Tpl.Text l_range__str;

    case ( txt,
           Absyn.ITERATOR(range = i_range, guardExp = i_guardExp, name = i_name) )
      equation
        l_range__str = fun_76(Tpl.emptyTxt, i_range);
        l_guard__str = fun_77(Tpl.emptyTxt, i_guardExp);
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeText(txt, l_range__str);
        txt = Tpl.writeText(txt, l_guard__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpForIterator;

public function dumpWhileStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_while__statement;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_while__statement)
    local
      Tpl.Text txt;
      Option<SCode.Comment> i_comment;
      list<SCode.Statement> i_whileBody;
      Absyn.Exp i_boolExpr;
      Tpl.Text l_cmt__str;
      Tpl.Text l_body__str;
      Tpl.Text l_cond__str;

    case ( txt,
           SCode.ALG_WHILE(boolExpr = i_boolExpr, whileBody = i_whileBody, comment = i_comment) )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, i_boolExpr);
        l_body__str = dumpStatements(Tpl.emptyTxt, i_whileBody);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("while "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" loop\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end while;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpWhileStatement;

protected function lm_80
  input Tpl.Text in_txt;
  input list<tuple<Absyn.Exp, list<SCode.Statement>>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<Absyn.Exp, list<SCode.Statement>>> rest;
      list<SCode.Statement> i_ew__body;
      Absyn.Exp i_ew__cond;
      Tpl.Text l_ew__body__str;
      Tpl.Text l_ew__cond__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_ew__cond, i_ew__body) :: rest )
      equation
        l_ew__cond__str = dumpExp(Tpl.emptyTxt, i_ew__cond);
        l_ew__body__str = dumpStatements(Tpl.emptyTxt, i_ew__body);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elsewhen "));
        txt = Tpl.writeText(txt, l_ew__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_ew__body__str);
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_80(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_80(txt, rest);
      then txt;
  end matchcontinue;
end lm_80;

public function dumpWhenStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_when__statement;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_when__statement)
    local
      Tpl.Text txt;
      Option<SCode.Comment> i_comment;
      list<tuple<Absyn.Exp, list<SCode.Statement>>> i_elsewhens;
      list<SCode.Statement> i_when__body;
      Absyn.Exp i_when__cond;
      Tpl.Text l_cmt__str;
      Tpl.Text l_elsewhen__str;
      Tpl.Text l_when__body__str;
      Tpl.Text l_when__cond__str;

    case ( txt,
           SCode.ALG_WHEN_A(branches = (i_when__cond, i_when__body) :: i_elsewhens, comment = i_comment) )
      equation
        l_when__cond__str = dumpExp(Tpl.emptyTxt, i_when__cond);
        l_when__body__str = dumpStatements(Tpl.emptyTxt, i_when__body);
        l_elsewhen__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_elsewhen__str = lm_80(l_elsewhen__str, i_elsewhens);
        l_elsewhen__str = Tpl.popIter(l_elsewhen__str);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, l_when__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_when__body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_elsewhen__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpWhenStatement;

protected function lm_82
  input Tpl.Text in_txt;
  input list<Absyn.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Exp> rest;
      Absyn.Exp i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpExp(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_82(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_82(txt, rest);
      then txt;
  end matchcontinue;
end lm_82;

protected function lm_83
  input Tpl.Text in_txt;
  input list<Absyn.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Exp> rest;
      Absyn.Exp i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpExp(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_83(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_83(txt, rest);
      then txt;
  end matchcontinue;
end lm_83;

protected function lm_84
  input Tpl.Text in_txt;
  input list<list<Absyn.Exp>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<Absyn.Exp>> rest;
      list<Absyn.Exp> i_row;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_row :: rest )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_83(txt, i_row);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_84(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_84(txt, rest);
      then txt;
  end matchcontinue;
end lm_84;

protected function lm_85
  input Tpl.Text in_txt;
  input list<Absyn.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Exp> rest;
      Absyn.Exp i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpExp(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_85(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_85(txt, rest);
      then txt;
  end matchcontinue;
end lm_85;

protected function lm_86
  input Tpl.Text in_txt;
  input list<Absyn.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Exp> rest;
      Absyn.Exp i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpExp(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_86(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_86(txt, rest);
      then txt;
  end matchcontinue;
end lm_86;

public function dumpExp
  input Tpl.Text in_txt;
  input Absyn.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      list<Absyn.Exp> i_exps;
      Absyn.Exp i_rest;
      Absyn.Exp i_head;
      list<Absyn.Exp> i_expressions;
      Absyn.Exp i_stop;
      Absyn.Exp i_step;
      Absyn.Exp i_start;
      list<list<Absyn.Exp>> i_matrix;
      list<Absyn.Exp> i_arrayExp;
      Absyn.FunctionArgs i_functionArgs;
      Absyn.ComponentRef i_function__;
      Absyn.Exp i_exp;
      Absyn.Operator i_op;
      Absyn.Exp i_exp2;
      Absyn.Exp i_e;
      Absyn.Exp i_exp1;
      Boolean i_value_3;
      String i_value_2;
      Absyn.ComponentRef i_componentRef;
      Real i_value_1;
      Integer i_value;
      Tpl.Text l_list__str;
      Tpl.Text l_rest__str;
      Tpl.Text l_head__str;
      Tpl.Text l_tuple__str;
      Tpl.Text l_stop__str;
      Tpl.Text l_step__str;
      Tpl.Text l_start__str;
      Tpl.Text l_matrix__str;
      Tpl.Text l_array__str;
      Tpl.Text l_args__str;
      Tpl.Text l_func__str;
      Tpl.Text l_exp__str;
      Tpl.Text l_op__str;
      Tpl.Text l_lhs__str;
      Tpl.Text l_rhs__str;

    case ( txt,
           Absyn.INTEGER(value = i_value) )
      equation
        txt = Tpl.writeStr(txt, intString(i_value));
      then txt;

    case ( txt,
           Absyn.REAL(value = i_value_1) )
      equation
        txt = Tpl.writeStr(txt, realString(i_value_1));
      then txt;

    case ( txt,
           Absyn.CREF(componentRef = i_componentRef) )
      equation
        txt = dumpCref(txt, i_componentRef);
      then txt;

    case ( txt,
           Absyn.STRING(value = i_value_2) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_value_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           Absyn.BOOL(value = i_value_3) )
      equation
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_value_3));
      then txt;

    case ( txt,
           (i_e as Absyn.BINARY(exp1 = i_exp1, exp2 = i_exp2, op = i_op)) )
      equation
        l_rhs__str = dumpOperand(Tpl.emptyTxt, i_exp1, i_e);
        l_lhs__str = dumpOperand(Tpl.emptyTxt, i_exp2, i_e);
        l_op__str = dumpOperator(Tpl.emptyTxt, i_op);
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_op__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_lhs__str);
      then txt;

    case ( txt,
           (i_e as Absyn.UNARY(exp = i_exp, op = i_op)) )
      equation
        l_exp__str = dumpOperand(Tpl.emptyTxt, i_exp, i_e);
        l_op__str = dumpOperator(Tpl.emptyTxt, i_op);
        txt = Tpl.writeText(txt, l_op__str);
        txt = Tpl.writeText(txt, l_exp__str);
      then txt;

    case ( txt,
           (i_e as Absyn.LBINARY(exp1 = i_exp1, exp2 = i_exp2, op = i_op)) )
      equation
        l_rhs__str = dumpOperand(Tpl.emptyTxt, i_exp1, i_e);
        l_lhs__str = dumpOperand(Tpl.emptyTxt, i_exp2, i_e);
        l_op__str = dumpOperator(Tpl.emptyTxt, i_op);
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_op__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_lhs__str);
      then txt;

    case ( txt,
           (i_e as Absyn.LUNARY(exp = i_exp, op = i_op)) )
      equation
        l_exp__str = dumpOperand(Tpl.emptyTxt, i_exp, i_e);
        l_op__str = dumpOperator(Tpl.emptyTxt, i_op);
        txt = Tpl.writeText(txt, l_op__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_exp__str);
      then txt;

    case ( txt,
           (i_e as Absyn.RELATION(exp1 = i_exp1, exp2 = i_exp2, op = i_op)) )
      equation
        l_rhs__str = dumpOperand(Tpl.emptyTxt, i_exp1, i_e);
        l_lhs__str = dumpOperand(Tpl.emptyTxt, i_exp2, i_e);
        l_op__str = dumpOperator(Tpl.emptyTxt, i_op);
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_op__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_lhs__str);
      then txt;

    case ( txt,
           (i_exp as Absyn.IFEXP(ifExp = _)) )
      equation
        txt = dumpIfExp(txt, i_exp);
      then txt;

    case ( txt,
           Absyn.CALL(function_ = i_function__, functionArgs = i_functionArgs) )
      equation
        l_func__str = dumpCref(Tpl.emptyTxt, i_function__);
        l_args__str = dumpFunctionArgs(Tpl.emptyTxt, i_functionArgs);
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           Absyn.ARRAY(arrayExp = i_arrayExp) )
      equation
        l_array__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_array__str = lm_82(l_array__str, i_arrayExp);
        l_array__str = Tpl.popIter(l_array__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, l_array__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           Absyn.MATRIX(matrix = i_matrix) )
      equation
        l_matrix__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("; ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_matrix__str = lm_84(l_matrix__str, i_matrix);
        l_matrix__str = Tpl.popIter(l_matrix__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_matrix__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           (i_e as Absyn.RANGE(step = SOME(i_step), start = i_start, stop = i_stop)) )
      equation
        l_start__str = dumpOperand(Tpl.emptyTxt, i_start, i_e);
        l_step__str = dumpOperand(Tpl.emptyTxt, i_step, i_e);
        l_stop__str = dumpOperand(Tpl.emptyTxt, i_stop, i_e);
        txt = Tpl.writeText(txt, l_start__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        txt = Tpl.writeText(txt, l_step__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        txt = Tpl.writeText(txt, l_stop__str);
      then txt;

    case ( txt,
           (i_e as Absyn.RANGE(step = NONE(), start = i_start, stop = i_stop)) )
      equation
        l_start__str = dumpOperand(Tpl.emptyTxt, i_start, i_e);
        l_stop__str = dumpOperand(Tpl.emptyTxt, i_stop, i_e);
        txt = Tpl.writeText(txt, l_start__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        txt = Tpl.writeText(txt, l_stop__str);
      then txt;

    case ( txt,
           Absyn.TUPLE(expressions = i_expressions) )
      equation
        l_tuple__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_tuple__str = lm_85(l_tuple__str, i_expressions);
        l_tuple__str = Tpl.popIter(l_tuple__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_tuple__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           Absyn.END() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end"));
      then txt;

    case ( txt,
           Absyn.AS(id = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("as"));
      then txt;

    case ( txt,
           Absyn.CONS(head = i_head, rest = i_rest) )
      equation
        l_head__str = dumpExp(Tpl.emptyTxt, i_head);
        l_rest__str = dumpExp(Tpl.emptyTxt, i_rest);
        txt = Tpl.writeText(txt, l_head__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" :: "));
        txt = Tpl.writeText(txt, l_rest__str);
      then txt;

    case ( txt,
           (i_exp as Absyn.MATCHEXP(matchTy = _)) )
      equation
        txt = dumpMatchExp(txt, i_exp);
      then txt;

    case ( txt,
           Absyn.LIST(exps = i_exps) )
      equation
        l_list__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_list__str = lm_86(l_list__str, i_exps);
        l_list__str = Tpl.popIter(l_list__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, l_list__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpExp;

protected function fun_88
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_op__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_op__str)
    local
      Tpl.Text txt;
      Tpl.Text a_op__str;

    case ( txt,
           false,
           a_op__str )
      equation
        txt = Tpl.writeText(txt, a_op__str);
      then txt;

    case ( txt,
           _,
           a_op__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_op__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_88;

public function dumpOperand
  input Tpl.Text txt;
  input Absyn.Exp a_operand;
  input Absyn.Exp a_operation;

  output Tpl.Text out_txt;
protected
  Boolean ret_3;
  Integer ret_2;
  Integer ret_1;
  Tpl.Text l_op__str;
algorithm
  l_op__str := dumpExp(Tpl.emptyTxt, a_operand);
  ret_1 := Dump.expPriority(a_operation);
  ret_2 := Dump.expPriority(a_operand);
  ret_3 := intLt(ret_1, ret_2);
  out_txt := fun_88(txt, ret_3, l_op__str);
end dumpOperand;

public function dumpIfExp
  input Tpl.Text in_txt;
  input Absyn.Exp in_a_if__exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_if__exp)
    local
      Tpl.Text txt;
      list<tuple<Absyn.Exp, Absyn.Exp>> i_elseIfBranch;
      Absyn.Exp i_elseBranch;
      Absyn.Exp i_trueBranch;
      Absyn.Exp i_ifExp;
      Tpl.Text l_else__if__str;
      Tpl.Text l_else__branch__str;
      Tpl.Text l_true__branch__str;
      Tpl.Text l_cond__str;

    case ( txt,
           Absyn.IFEXP(ifExp = i_ifExp, trueBranch = i_trueBranch, elseBranch = i_elseBranch, elseIfBranch = i_elseIfBranch) )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, i_ifExp);
        l_true__branch__str = dumpExp(Tpl.emptyTxt, i_trueBranch);
        l_else__branch__str = dumpExp(Tpl.emptyTxt, i_elseBranch);
        l_else__if__str = dumpElseIfExp(Tpl.emptyTxt, i_elseIfBranch);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then "));
        txt = Tpl.writeText(txt, l_true__branch__str);
        txt = Tpl.writeText(txt, l_else__if__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" else "));
        txt = Tpl.writeText(txt, l_else__branch__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpIfExp;

protected function lm_91
  input Tpl.Text in_txt;
  input list<tuple<Absyn.Exp, Absyn.Exp>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<Absyn.Exp, Absyn.Exp>> rest;
      Absyn.Exp i_branch;
      Absyn.Exp i_cond;
      Tpl.Text l_branch__str;
      Tpl.Text l_cond__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_cond, i_branch) :: rest )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, i_cond);
        l_branch__str = dumpExp(Tpl.emptyTxt, i_branch);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elseif "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then "));
        txt = Tpl.writeText(txt, l_branch__str);
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_91(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_91(txt, rest);
      then txt;
  end matchcontinue;
end lm_91;

public function dumpElseIfExp
  input Tpl.Text txt;
  input list<tuple<Absyn.Exp, Absyn.Exp>> a_else__if;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_91(out_txt, a_else__if);
  out_txt := Tpl.popIter(out_txt);
end dumpElseIfExp;

public function dumpMatchExp
  input Tpl.Text txt;
  input Absyn.Exp a_match__exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("MATCH_EXP"));
end dumpMatchExp;

public function dumpOperator
  input Tpl.Text in_txt;
  input Absyn.Operator in_a_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_op)
    local
      Tpl.Text txt;

    case ( txt,
           Absyn.ADD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
      then txt;

    case ( txt,
           Absyn.SUB() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
      then txt;

    case ( txt,
           Absyn.MUL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           Absyn.DIV() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
      then txt;

    case ( txt,
           Absyn.POW() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("^"));
      then txt;

    case ( txt,
           Absyn.UPLUS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
      then txt;

    case ( txt,
           Absyn.UMINUS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
      then txt;

    case ( txt,
           Absyn.ADD_EW() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".+"));
      then txt;

    case ( txt,
           Absyn.SUB_EW() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".-"));
      then txt;

    case ( txt,
           Absyn.MUL_EW() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".*"));
      then txt;

    case ( txt,
           Absyn.DIV_EW() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("./"));
      then txt;

    case ( txt,
           Absyn.POW_EW() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".^"));
      then txt;

    case ( txt,
           Absyn.UPLUS_EW() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".+"));
      then txt;

    case ( txt,
           Absyn.UMINUS_EW() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".-"));
      then txt;

    case ( txt,
           Absyn.AND() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("and"));
      then txt;

    case ( txt,
           Absyn.OR() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("or"));
      then txt;

    case ( txt,
           Absyn.NOT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("not"));
      then txt;

    case ( txt,
           Absyn.LESS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<"));
      then txt;

    case ( txt,
           Absyn.LESSEQ() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<="));
      then txt;

    case ( txt,
           Absyn.GREATER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           Absyn.GREATEREQ() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">="));
      then txt;

    case ( txt,
           Absyn.EQUAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=="));
      then txt;

    case ( txt,
           Absyn.NEQUAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpOperator;

public function dumpCref
  input Tpl.Text in_txt;
  input Absyn.ComponentRef in_a_cref;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cref)
    local
      Tpl.Text txt;
      Absyn.ComponentRef i_cref;
      Absyn.ComponentRef i_componentRef;
      list<Absyn.Subscript> i_subscripts;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.CREF_QUAL(name = i_name, subscripts = i_subscripts, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpSubscripts(txt, i_subscripts);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dumpCref(txt, i_componentRef);
      then txt;

    case ( txt,
           Absyn.CREF_IDENT(name = i_name, subscripts = i_subscripts) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpSubscripts(txt, i_subscripts);
      then txt;

    case ( txt,
           Absyn.CREF_FULLYQUALIFIED(componentRef = i_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dumpCref(txt, i_componentRef);
      then txt;

    case ( txt,
           Absyn.WILD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           Absyn.ALLWILD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__"));
      then txt;

    case ( txt,
           (i_cref as Absyn.CREF_INVALID(componentRef = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("INVALID("));
        txt = dumpCref(txt, i_cref);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpCref;

protected function lm_96
  input Tpl.Text in_txt;
  input list<Absyn.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Exp> rest;
      Absyn.Exp i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = dumpExp(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_96(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_96(txt, rest);
      then txt;
  end matchcontinue;
end lm_96;

protected function lm_97
  input Tpl.Text in_txt;
  input list<Absyn.NamedArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.NamedArg> rest;
      Absyn.NamedArg i_narg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_narg :: rest )
      equation
        txt = dumpNamedArg(txt, i_narg);
        txt = Tpl.nextIter(txt);
        txt = lm_97(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_97(txt, rest);
      then txt;
  end matchcontinue;
end lm_97;

protected function fun_98
  input Tpl.Text in_txt;
  input list<Absyn.NamedArg> in_a_argNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_argNames)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
      then txt;
  end matchcontinue;
end fun_98;

protected function fun_99
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args__str;
  input list<Absyn.NamedArg> in_a_argNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_args__str, in_a_argNames)
    local
      Tpl.Text txt;
      list<Absyn.NamedArg> a_argNames;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_argNames )
      equation
        txt = fun_98(txt, a_argNames);
      then txt;
  end matchcontinue;
end fun_99;

protected function lm_100
  input Tpl.Text in_txt;
  input Absyn.ForIterators in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      Absyn.ForIterators rest;
      Absyn.ForIterator i_i;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_i :: rest )
      equation
        txt = dumpForIterator(txt, i_i);
        txt = Tpl.nextIter(txt);
        txt = lm_100(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_100(txt, rest);
      then txt;
  end matchcontinue;
end lm_100;

public function dumpFunctionArgs
  input Tpl.Text in_txt;
  input Absyn.FunctionArgs in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_args)
    local
      Tpl.Text txt;
      Absyn.ForIterators i_iterators;
      Absyn.Exp i_exp;
      list<Absyn.NamedArg> i_argNames;
      list<Absyn.Exp> i_args;
      Tpl.Text l_iter__str;
      Tpl.Text l_exp__str;
      Tpl.Text l_separator;
      Tpl.Text l_namedargs__str;
      Tpl.Text l_args__str;

    case ( txt,
           Absyn.FUNCTIONARGS(args = i_args, argNames = i_argNames) )
      equation
        l_args__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_args__str = lm_96(l_args__str, i_args);
        l_args__str = Tpl.popIter(l_args__str);
        l_namedargs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_namedargs__str = lm_97(l_namedargs__str, i_argNames);
        l_namedargs__str = Tpl.popIter(l_namedargs__str);
        l_separator = fun_99(Tpl.emptyTxt, l_args__str, i_argNames);
        txt = Tpl.writeText(txt, l_args__str);
        txt = Tpl.writeText(txt, l_separator);
        txt = Tpl.writeText(txt, l_namedargs__str);
      then txt;

    case ( txt,
           Absyn.FOR_ITER_FARG(exp = i_exp, iterators = i_iterators) )
      equation
        l_exp__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_iter__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_iter__str = lm_100(l_iter__str, i_iterators);
        l_iter__str = Tpl.popIter(l_iter__str);
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" for "));
        txt = Tpl.writeText(txt, l_iter__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpFunctionArgs;

public function dumpNamedArg
  input Tpl.Text in_txt;
  input Absyn.NamedArg in_a_narg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_narg)
    local
      Tpl.Text txt;
      Absyn.Exp i_argValue;
      Absyn.Ident i_argName;

    case ( txt,
           Absyn.NAMEDARG(argName = i_argName, argValue = i_argValue) )
      equation
        txt = Tpl.writeStr(txt, i_argName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = dumpExp(txt, i_argValue);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpNamedArg;

public function dumpPrefixes
  input Tpl.Text in_txt;
  input SCode.Prefixes in_a_prefixes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_prefixes)
    local
      Tpl.Text txt;
      SCode.Replaceable i_replaceablePrefix;
      Absyn.InnerOuter i_innerOuter;
      SCode.Final i_finalPrefix;
      SCode.Redeclare i_redeclarePrefix;
      Tpl.Text l_replaceable__str;
      Tpl.Text l_io__str;
      Tpl.Text l_final__str;
      Tpl.Text l_redeclare__str;

    case ( txt,
           SCode.PREFIXES(redeclarePrefix = i_redeclarePrefix, finalPrefix = i_finalPrefix, innerOuter = i_innerOuter, replaceablePrefix = i_replaceablePrefix) )
      equation
        l_redeclare__str = dumpRedeclare(Tpl.emptyTxt, i_redeclarePrefix);
        l_final__str = dumpFinal(Tpl.emptyTxt, i_finalPrefix);
        l_io__str = dumpInnerOuter(Tpl.emptyTxt, i_innerOuter);
        l_replaceable__str = dumpReplaceable(Tpl.emptyTxt, i_replaceablePrefix);
        txt = Tpl.writeText(txt, l_redeclare__str);
        txt = Tpl.writeText(txt, l_final__str);
        txt = Tpl.writeText(txt, l_io__str);
        txt = Tpl.writeText(txt, l_replaceable__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpPrefixes;

public function dumpVisibility
  input Tpl.Text in_txt;
  input SCode.Visibility in_a_visibility;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_visibility)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.PROTECTED() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("protected "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpVisibility;

public function dumpRedeclare
  input Tpl.Text in_txt;
  input SCode.Redeclare in_a_redeclare;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_redeclare)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.REDECLARE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("redeclare "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpRedeclare;

public function dumpFinal
  input Tpl.Text in_txt;
  input SCode.Final in_a_final;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_final)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.FINAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("final "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpFinal;

public function dumpInnerOuter
  input Tpl.Text in_txt;
  input Absyn.InnerOuter in_a_innerOuter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_innerOuter)
    local
      Tpl.Text txt;

    case ( txt,
           Absyn.INNER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inner "));
      then txt;

    case ( txt,
           Absyn.OUTER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("outer "));
      then txt;

    case ( txt,
           Absyn.INNER_OUTER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inner outer "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpInnerOuter;

public function dumpReplaceable
  input Tpl.Text in_txt;
  input SCode.Replaceable in_a_replaceable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_replaceable)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.REPLACEABLE(cc = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("replaceable "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpReplaceable;

public function dumpReplaceableConstrainClass
  input Tpl.Text in_txt;
  input SCode.Prefixes in_a_replaceable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_replaceable)
    local
      Tpl.Text txt;
      SCode.Mod i_cc__mod;
      Absyn.Path i_cc__path;
      Tpl.Text l_mod__str;
      Tpl.Text l_path__str;

    case ( txt,
           SCode.PREFIXES(replaceablePrefix = SCode.REPLACEABLE(cc = SOME(SCode.CONSTRAINCLASS(constrainingClass = i_cc__path, modifier = i_cc__mod)))) )
      equation
        l_path__str = dumpPath(Tpl.emptyTxt, i_cc__path);
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_cc__mod);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constrainedby "));
        txt = Tpl.writeText(txt, l_path__str);
        txt = Tpl.writeText(txt, l_mod__str);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpReplaceableConstrainClass;

public function dumpEach
  input Tpl.Text in_txt;
  input SCode.Each in_a_each;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_each)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.EACH() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("each "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpEach;

public function dumpEncapsulated
  input Tpl.Text in_txt;
  input SCode.Encapsulated in_a_encapsulated;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_encapsulated)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.ENCAPSULATED() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("encapsulated "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpEncapsulated;

public function dumpPartial
  input Tpl.Text in_txt;
  input SCode.Partial in_a_partial;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_partial)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.PARTIAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("partial "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpPartial;

protected function fun_113
  input Tpl.Text in_txt;
  input Boolean in_a_isExpandable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isExpandable)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("connector"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expandable connector"));
      then txt;
  end matchcontinue;
end fun_113;

public function dumpRestriction
  input Tpl.Text in_txt;
  input SCode.Restriction in_a_restriction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_restriction)
    local
      Tpl.Text txt;
      SCode.FunctionRestriction i_functionRestriction;
      Boolean i_isExpandable;

    case ( txt,
           SCode.R_CLASS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class"));
      then txt;

    case ( txt,
           SCode.R_OPTIMIZATION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("optimization"));
      then txt;

    case ( txt,
           SCode.R_MODEL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("model"));
      then txt;

    case ( txt,
           SCode.R_RECORD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("record"));
      then txt;

    case ( txt,
           SCode.R_BLOCK() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("block"));
      then txt;

    case ( txt,
           SCode.R_CONNECTOR(isExpandable = i_isExpandable) )
      equation
        txt = fun_113(txt, i_isExpandable);
      then txt;

    case ( txt,
           SCode.R_OPERATOR() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("operator"));
      then txt;

    case ( txt,
           SCode.R_OPERATOR_RECORD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("operator record"));
      then txt;

    case ( txt,
           SCode.R_TYPE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("type"));
      then txt;

    case ( txt,
           SCode.R_PACKAGE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("package"));
      then txt;

    case ( txt,
           SCode.R_FUNCTION(functionRestriction = i_functionRestriction) )
      equation
        txt = dumpFunctionRestriction(txt, i_functionRestriction);
      then txt;

    case ( txt,
           SCode.R_ENUMERATION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("enumeration"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_INTEGER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("IntegerType"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_REAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RealType"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_STRING() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StringType"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_BOOLEAN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("BooleanType"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_ENUMERATION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EnumType"));
      then txt;

    case ( txt,
           SCode.R_METARECORD(name = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("record"));
      then txt;

    case ( txt,
           SCode.R_UNIONTYPE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("uniontype"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDimp.dumpRestriction: Unknown restriction.");
      then txt;
  end matchcontinue;
end dumpRestriction;

public function dumpFunctionRestriction
  input Tpl.Text in_txt;
  input SCode.FunctionRestriction in_a_funcRest;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_funcRest)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.FR_NORMAL_FUNCTION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
      then txt;

    case ( txt,
           SCode.FR_OPERATOR_FUNCTION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("operator function"));
      then txt;

    case ( txt,
           SCode.FR_EXTERNAL_FUNCTION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
      then txt;

    case ( txt,
           SCode.FR_RECORD_CONSTRUCTOR() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDimp.dumpFunctionRestriction: Unknown Function restriction.");
      then txt;
  end matchcontinue;
end dumpFunctionRestriction;

protected function lm_116
  input Tpl.Text in_txt;
  input list<SCode.SubMod> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.SubMod> rest;
      SCode.SubMod i_submod;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_submod :: rest )
      equation
        txt = dumpSubModifier(txt, i_submod);
        txt = Tpl.nextIter(txt);
        txt = lm_116(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_116(txt, rest);
      then txt;
  end matchcontinue;
end lm_116;

protected function fun_117
  input Tpl.Text in_txt;
  input list<SCode.SubMod> in_a_subModLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subModLst)
    local
      Tpl.Text txt;
      list<SCode.SubMod> i_subModLst;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subModLst )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_116(txt, i_subModLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_117;

public function dumpModifier
  input Tpl.Text in_txt;
  input SCode.Mod in_a_modifier;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modifier)
    local
      Tpl.Text txt;
      list<SCode.SubMod> i_subModLst;
      Option<tuple<Absyn.Exp, Boolean>> i_binding;
      Tpl.Text l_submod__str;
      Tpl.Text l_binding__str;

    case ( txt,
           SCode.MOD(binding = i_binding, subModLst = i_subModLst) )
      equation
        l_binding__str = dumpModifierBinding(Tpl.emptyTxt, i_binding);
        l_submod__str = fun_117(Tpl.emptyTxt, i_subModLst);
        txt = Tpl.writeText(txt, l_submod__str);
        txt = Tpl.writeText(txt, l_binding__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpModifier;

public function dumpModifierPrefix
  input Tpl.Text in_txt;
  input SCode.Mod in_a_modifier;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modifier)
    local
      Tpl.Text txt;
      SCode.Each i_eachPrefix;
      SCode.Final i_finalPrefix;
      Tpl.Text l_each__str;
      Tpl.Text l_final__str;

    case ( txt,
           SCode.MOD(finalPrefix = i_finalPrefix, eachPrefix = i_eachPrefix) )
      equation
        l_final__str = dumpFinal(Tpl.emptyTxt, i_finalPrefix);
        l_each__str = dumpEach(Tpl.emptyTxt, i_eachPrefix);
        txt = Tpl.writeText(txt, l_final__str);
        txt = Tpl.writeText(txt, l_each__str);
      then txt;

    case ( txt,
           SCode.REDECL(finalPrefix = i_finalPrefix, eachPrefix = i_eachPrefix) )
      equation
        l_final__str = dumpFinal(Tpl.emptyTxt, i_finalPrefix);
        l_each__str = dumpEach(Tpl.emptyTxt, i_eachPrefix);
        txt = Tpl.writeText(txt, l_final__str);
        txt = Tpl.writeText(txt, l_each__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpModifierPrefix;

public function dumpRedeclModifier
  input Tpl.Text in_txt;
  input SCode.Mod in_a_modifier;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modifier)
    local
      Tpl.Text txt;
      SCode.Element i_element;
      SCode.Each i_eachPrefix;
      Tpl.Text l_each__str;

    case ( txt,
           SCode.REDECL(eachPrefix = i_eachPrefix, element = i_element) )
      equation
        l_each__str = dumpEach(Tpl.emptyTxt, i_eachPrefix);
        txt = Tpl.writeText(txt, l_each__str);
        txt = dumpElement(txt, i_element);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpRedeclModifier;

public function dumpModifierBinding
  input Tpl.Text in_txt;
  input Option<tuple<Absyn.Exp, Boolean>> in_a_binding;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_binding)
    local
      Tpl.Text txt;
      Absyn.Exp i_exp;

    case ( txt,
           SOME((i_exp, _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = dumpExp(txt, i_exp);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpModifierBinding;

public function dumpSubModifier
  input Tpl.Text in_txt;
  input SCode.SubMod in_a_submod;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_submod)
    local
      Tpl.Text txt;
      list<SCode.Subscript> i_subscriptLst;
      SCode.Mod i_an;
      SCode.Ident i_ident;
      SCode.Mod i_A;

    case ( txt,
           SCode.NAMEMOD(A = (i_A as SCode.MOD(finalPrefix = _)), ident = i_ident) )
      equation
        txt = dumpModifierPrefix(txt, i_A);
        txt = Tpl.writeStr(txt, i_ident);
        txt = dumpModifier(txt, i_A);
      then txt;

    case ( txt,
           SCode.NAMEMOD(A = (i_A as SCode.REDECL(finalPrefix = _))) )
      equation
        txt = dumpRedeclModifier(txt, i_A);
      then txt;

    case ( txt,
           SCode.IDXMOD(an = i_an, subscriptLst = i_subscriptLst) )
      equation
        txt = dumpModifierPrefix(txt, i_an);
        txt = dumpSubscripts(txt, i_subscriptLst);
        txt = dumpModifier(txt, i_an);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpSubModifier;

public function dumpAttributes
  input Tpl.Text in_txt;
  input SCode.Attributes in_a_attributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attributes)
    local
      Tpl.Text txt;
      Absyn.Direction i_direction;
      SCode.Variability i_variability;
      SCode.Parallelism i_parallelism;
      SCode.Stream i_streamPrefix;
      SCode.Flow i_flowPrefix;
      Tpl.Text l_dir__str;
      Tpl.Text l_var__str;
      Tpl.Text l_prl__str;
      Tpl.Text l_stream__str;
      Tpl.Text l_flow__str;

    case ( txt,
           SCode.ATTR(flowPrefix = i_flowPrefix, streamPrefix = i_streamPrefix, parallelism = i_parallelism, variability = i_variability, direction = i_direction) )
      equation
        l_flow__str = dumpFlow(Tpl.emptyTxt, i_flowPrefix);
        l_stream__str = dumpStream(Tpl.emptyTxt, i_streamPrefix);
        l_prl__str = dumpParallelism(Tpl.emptyTxt, i_parallelism);
        l_var__str = dumpVariability(Tpl.emptyTxt, i_variability);
        l_dir__str = dumpDirection(Tpl.emptyTxt, i_direction);
        txt = Tpl.writeText(txt, l_prl__str);
        txt = Tpl.writeText(txt, l_dir__str);
        txt = Tpl.writeText(txt, l_var__str);
        txt = Tpl.writeText(txt, l_flow__str);
        txt = Tpl.writeText(txt, l_stream__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpAttributes;

public function dumpFlow
  input Tpl.Text in_txt;
  input SCode.Flow in_a_flow;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_flow)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.FLOW() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("flow "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpFlow;

public function dumpStream
  input Tpl.Text in_txt;
  input SCode.Stream in_a_stream;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_stream)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.STREAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("stream "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpStream;

public function dumpParallelism
  input Tpl.Text in_txt;
  input SCode.Parallelism in_a_parallelism;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_parallelism)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.PARGLOBAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parglobal "));
      then txt;

    case ( txt,
           SCode.PARLOCAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parlocal "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpParallelism;

public function dumpVariability
  input Tpl.Text in_txt;
  input SCode.Variability in_a_variability;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_variability)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.DISCRETE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("discrete "));
      then txt;

    case ( txt,
           SCode.PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parameter "));
      then txt;

    case ( txt,
           SCode.CONST() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpVariability;

public function dumpDirection
  input Tpl.Text in_txt;
  input Absyn.Direction in_a_direction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_direction)
    local
      Tpl.Text txt;

    case ( txt,
           Absyn.INPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("input "));
      then txt;

    case ( txt,
           Absyn.OUTPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpDirection;

public function dumpAttributeDim
  input Tpl.Text in_txt;
  input SCode.Attributes in_a_attributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attributes)
    local
      Tpl.Text txt;
      Absyn.ArrayDim i_arrayDims;

    case ( txt,
           SCode.ATTR(arrayDims = i_arrayDims) )
      equation
        txt = dumpSubscripts(txt, i_arrayDims);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpAttributeDim;

public function dumpArrayDimOpt
  input Tpl.Text in_txt;
  input Option<Absyn.ArrayDim> in_a_arraydim;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_arraydim)
    local
      Tpl.Text txt;
      Absyn.ArrayDim i_ad;

    case ( txt,
           SOME(i_ad) )
      equation
        txt = dumpSubscripts(txt, i_ad);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpArrayDimOpt;

protected function lm_131
  input Tpl.Text in_txt;
  input list<Absyn.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Subscript> rest;
      Absyn.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = dumpSubscript(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_131(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_131(txt, rest);
      then txt;
  end matchcontinue;
end lm_131;

public function dumpSubscripts
  input Tpl.Text in_txt;
  input list<Absyn.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<Absyn.Subscript> i_subscripts;
      Tpl.Text l_sub__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        l_sub__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_sub__str = lm_131(l_sub__str, i_subscripts);
        l_sub__str = Tpl.popIter(l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end matchcontinue;
end dumpSubscripts;

public function dumpSubscript
  input Tpl.Text in_txt;
  input Absyn.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Absyn.Exp i_subscript;

    case ( txt,
           Absyn.NOSUB() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           Absyn.SUBSCRIPT(subscript = i_subscript) )
      equation
        txt = dumpExp(txt, i_subscript);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpSubscript;

public function dumpAnnotationOpt
  input Tpl.Text in_txt;
  input Option<SCode.Annotation> in_a_annotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_annotation)
    local
      Tpl.Text txt;
      SCode.Annotation i_ann;

    case ( txt,
           SOME(i_ann) )
      equation
        txt = dumpAnnotation(txt, i_ann);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpAnnotationOpt;

protected function fun_135
  input Tpl.Text in_txt;
  input SCode.Annotation in_a_annotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_annotation)
    local
      Tpl.Text txt;
      SCode.Mod i_modification;

    case ( txt,
           SCode.ANNOTATION(modification = i_modification) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("annotation"));
        txt = dumpModifier(txt, i_modification);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_135;

protected function fun_136
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SCode.Annotation in_a_annotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_annotation)
    local
      Tpl.Text txt;
      SCode.Annotation a_annotation;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_annotation )
      equation
        txt = fun_135(txt, a_annotation);
      then txt;
  end matchcontinue;
end fun_136;

public function dumpAnnotation
  input Tpl.Text txt;
  input SCode.Annotation a_annotation;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := Config.showAnnotations();
  out_txt := fun_136(txt, ret_0, a_annotation);
end dumpAnnotation;

protected function fun_138
  input Tpl.Text in_txt;
  input Tpl.Text in_a_annstr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_annstr)
    local
      Tpl.Text txt;
      Tpl.Text i_annstr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_annstr )
      equation
        txt = Tpl.writeText(txt, i_annstr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_138;

public function dumpAnnotationElement
  input Tpl.Text txt;
  input SCode.Annotation a_annotation;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_annstr;
algorithm
  l_annstr := dumpAnnotation(Tpl.emptyTxt, a_annotation);
  out_txt := fun_138(txt, l_annstr);
end dumpAnnotationElement;

public function dumpExternalDeclOpt
  input Tpl.Text in_txt;
  input Option<SCode.ExternalDecl> in_a_externalDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_externalDecl)
    local
      Tpl.Text txt;
      SCode.ExternalDecl i_extdecl;

    case ( txt,
           SOME(i_extdecl) )
      equation
        txt = dumpExternalDecl(txt, i_extdecl);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpExternalDeclOpt;

protected function fun_141
  input Tpl.Text in_txt;
  input Option<SCode.Ident> in_a_funcName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_funcName)
    local
      Tpl.Text txt;
      SCode.Ident i_name;

    case ( txt,
           SOME(i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_141;

protected function lm_142
  input Tpl.Text in_txt;
  input list<Absyn.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Exp> rest;
      Absyn.Exp i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = dumpExp(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_142(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_142(txt, rest);
      then txt;
  end matchcontinue;
end lm_142;

protected function fun_143
  input Tpl.Text in_txt;
  input Tpl.Text in_a_func__name__str;
  input Tpl.Text in_a_func__args__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_func__name__str, in_a_func__args__str)
    local
      Tpl.Text txt;
      Tpl.Text a_func__args__str;
      Tpl.Text i_func__name__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           i_func__name__str,
           a_func__args__str )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, i_func__name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_func__args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_143;

protected function fun_144
  input Tpl.Text in_txt;
  input Option<String> in_a_lang;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_lang)
    local
      Tpl.Text txt;
      String i_l;

    case ( txt,
           SOME(i_l) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_l);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_144;

protected function fun_145
  input Tpl.Text in_txt;
  input Option<Absyn.ComponentRef> in_a_output__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_output__)
    local
      Tpl.Text txt;
      Absyn.ComponentRef i_name;

    case ( txt,
           SOME(i_name) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = dumpCref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ="));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_145;

public function dumpExternalDecl
  input Tpl.Text in_txt;
  input SCode.ExternalDecl in_a_externalDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_externalDecl)
    local
      Tpl.Text txt;
      Option<Absyn.ComponentRef> i_output__;
      Option<String> i_lang;
      list<Absyn.Exp> i_args;
      Option<SCode.Ident> i_funcName;
      Tpl.Text l_output__str;
      Tpl.Text l_lang__str;
      Tpl.Text l_func__str;
      Tpl.Text l_func__args__str;
      Tpl.Text l_func__name__str;

    case ( txt,
           SCode.EXTERNALDECL(funcName = i_funcName, args = i_args, lang = i_lang, output_ = i_output__) )
      equation
        l_func__name__str = fun_141(Tpl.emptyTxt, i_funcName);
        l_func__args__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_func__args__str = lm_142(l_func__args__str, i_args);
        l_func__args__str = Tpl.popIter(l_func__args__str);
        l_func__str = fun_143(Tpl.emptyTxt, l_func__name__str, l_func__args__str);
        l_lang__str = fun_144(Tpl.emptyTxt, i_lang);
        l_output__str = fun_145(Tpl.emptyTxt, i_output__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external"));
        txt = Tpl.writeText(txt, l_lang__str);
        txt = Tpl.writeText(txt, l_output__str);
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpExternalDecl;

public function dumpCommentOpt
  input Tpl.Text in_txt;
  input Option<SCode.Comment> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      SCode.Comment i_cmt;

    case ( txt,
           SOME(i_cmt) )
      equation
        txt = dumpComment(txt, i_cmt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpCommentOpt;

protected function lm_148
  input Tpl.Text in_txt;
  input list<SCode.Annotation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Annotation> rest;
      SCode.Annotation i_ann;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ann :: rest )
      equation
        txt = dumpAnnotation(txt, i_ann);
        txt = Tpl.nextIter(txt);
        txt = lm_148(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_148(txt, rest);
      then txt;
  end matchcontinue;
end lm_148;

protected function fun_149
  input Tpl.Text in_txt;
  input SCode.Comment in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      Option<SCode.Comment> i_comment_1;
      list<SCode.Annotation> i_annotations;
      Option<String> i_comment;
      Option<SCode.Annotation> i_annotation__;
      Tpl.Text l_annl__str;
      Tpl.Text l_cmt__str;
      Tpl.Text l_ann__str;

    case ( txt,
           SCode.COMMENT(annotation_ = i_annotation__, comment = i_comment) )
      equation
        l_ann__str = dumpAnnotationOpt(Tpl.emptyTxt, i_annotation__);
        l_cmt__str = dumpCommentStr(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeText(txt, l_ann__str);
      then txt;

    case ( txt,
           SCode.CLASS_COMMENT(annotations = i_annotations, comment = i_comment_1) )
      equation
        l_annl__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_annl__str = lm_148(l_annl__str, i_annotations);
        l_annl__str = Tpl.popIter(l_annl__str);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment_1);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeText(txt, l_annl__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_149;

protected function fun_150
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SCode.Comment in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_comment)
    local
      Tpl.Text txt;
      SCode.Comment a_comment;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_comment )
      equation
        txt = fun_149(txt, a_comment);
      then txt;
  end matchcontinue;
end fun_150;

public function dumpComment
  input Tpl.Text txt;
  input SCode.Comment a_comment;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := Config.showAnnotations();
  out_txt := fun_150(txt, ret_0, a_comment);
end dumpComment;

public function dumpCommentStr
  input Tpl.Text in_txt;
  input Option<String> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_cmt;

    case ( txt,
           SOME(i_cmt) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_cmt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpCommentStr;

public function dumpPath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_path)
    local
      Tpl.Text txt;
      Absyn.Ident i_name;
      Absyn.Path i_path;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dumpPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dumpPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpPath: Unknown path.");
      then txt;
  end matchcontinue;
end dumpPath;

protected function lm_154
  input Tpl.Text in_txt;
  input list<Absyn.TypeSpec> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.TypeSpec> rest;
      Absyn.TypeSpec i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ty :: rest )
      equation
        txt = dumpTypeSpec(txt, i_ty);
        txt = Tpl.nextIter(txt);
        txt = lm_154(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_154(txt, rest);
      then txt;
  end matchcontinue;
end lm_154;

public function dumpTypeSpec
  input Tpl.Text in_txt;
  input Absyn.TypeSpec in_a_typeSpec;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_typeSpec)
    local
      Tpl.Text txt;
      list<Absyn.TypeSpec> i_typeSpecs;
      Option<Absyn.ArrayDim> i_arrayDim;
      Absyn.Path i_path;
      Tpl.Text l_ty__str;
      Tpl.Text l_arraydim__str;
      Tpl.Text l_path__str;

    case ( txt,
           Absyn.TPATH(path = i_path, arrayDim = i_arrayDim) )
      equation
        l_path__str = dumpPath(Tpl.emptyTxt, i_path);
        l_arraydim__str = dumpArrayDimOpt(Tpl.emptyTxt, i_arrayDim);
        txt = Tpl.writeText(txt, l_path__str);
        txt = Tpl.writeText(txt, l_arraydim__str);
      then txt;

    case ( txt,
           Absyn.TCOMPLEX(path = i_path, typeSpecs = i_typeSpecs, arrayDim = i_arrayDim) )
      equation
        l_path__str = dumpPath(Tpl.emptyTxt, i_path);
        l_ty__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_ty__str = lm_154(l_ty__str, i_typeSpecs);
        l_ty__str = Tpl.popIter(l_ty__str);
        l_arraydim__str = dumpArrayDimOpt(Tpl.emptyTxt, i_arrayDim);
        txt = Tpl.writeText(txt, l_path__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<"));
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
        txt = Tpl.writeText(txt, l_arraydim__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dumpTypeSpec;

public function errorMsg
  input Tpl.Text txt;
  input String a_errMessage;

  output Tpl.Text out_txt;
algorithm
  Tpl.addTemplateError(a_errMessage);
  out_txt := Tpl.writeStr(txt, a_errMessage);
end errorMsg;

end SCodeDumpTpl;