/*
 * This file is part of OpenModelica.
 *
 * Copyright (c) 1998-CurrentYear, Linkping University,
 * Department of Computer and Information Science,
 * SE-58183 Linkping, Sweden.
 *
 * All rights reserved.
 *
 * THIS PROGRAM IS PROVIDED UNDER THE TERMS OF GPL VERSION 3 
 * AND THIS OSMC PUBLIC LICENSE (OSMC-PL). 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS PROGRAM CONSTITUTES RECIPIENT'S  
 * ACCEPTANCE OF THE OSMC PUBLIC LICENSE.
 *
 * The OpenModelica software and the Open Source Modelica
 * Consortium (OSMC) Public License (OSMC-PL) are obtained
 * from Linkping University, either from the above address,
 * from the URLs: http://www.ida.liu.se/projects/OpenModelica or  
 * http://www.openmodelica.org, and in the OpenModelica distribution. 
 * GNU version 3 is obtained from: http://www.gnu.org/copyleft/gpl.html.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without
 * even the implied warranty of  MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE, EXCEPT AS EXPRESSLY SET FORTH
 * IN THE BY RECIPIENT SELECTED SUBSIDIARY LICENSE CONDITIONS
 * OF OSMC-PL.
 *
 * See the full OSMC Public License conditions for more details.
 *
 */
 

/*

 Common hader file included by other headers in the openCLRuntime

 Mahder.Gebremedhin@liu.se  2012-03-31 
   
*/



#ifndef _OMC_OCL_COMMON_HEADER
#define _OMC_OCL_COMMON_HEADER

#include <stdio.h>
#include <CL/cl.h>
#include <openmodelica.h>
#include <stdarg.h>



#define MAX_DEVICE 4
#define SHOW_DEVICE_SELECTION
//#define SHOW_ARG_SET_ERRORS
#define DEFAULT_DEVICE 1
#define OCL_BUFFER_SIZE_FRACTION 4


// DEFINED IN: omc_ocl_util
extern void ocl_initialize();
extern void ocl_error_check(int operation, cl_int error_code);
extern cl_program ocl_build_p_from_src(const char* source, int isfile);
//



typedef cl_mem device_integer;
typedef cl_mem device_real;


struct dev_buff{
 cl_mem buffer;
 modelica_integer size;
};

typedef struct dev_buff device_buffer;


typedef struct dev_arr{
 cl_mem data;
 cl_mem info_dev;
 modelica_integer* info;
} device_array;

typedef device_array device_integer_array;
typedef device_array device_real_array;

enum ocl_error {OCL_BUILD_PROGRAM, OCL_CREATE_KERNEL, OCL_CREATE_BUFFER, OCL_CREATE_CONTEXT, 
                OCL_CREATE_COMMAND_QUEUE, OCL_SET_KER_ARGS, OCL_ENQUE_ND_RANGE_KERNEL, OCL_COPY_DEV_TO_DEV,
                OCL_COPY_HOST_TO_DEV,OCL_COPY_DEV_TO_HOST};

#endif
