encapsulated package CodegenC
"
  file:        CodegenC.mo
  package:     CodegenC
  description: Generated by Susan.
"

public import Tpl;

public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCode;
public import HpcOmScheduler;
public import CodegenUtil;

protected function fun_32
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;
  input String in_a_fileNamePrefix;
  input Tpl.Text in_a_guid;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simulationSettingsOpt, in_a_fileNamePrefix, in_a_guid, in_a_simCode)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;
      Tpl.Text a_guid;
      SimCode.SimCode a_simCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           NONE(),
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_fileNamePrefix,
           a_guid,
           a_simCode )
      equation
        txt_0 = simulationInitFile(Tpl.emptyTxt, a_simCode, Tpl.textString(a_guid));
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, a_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_init.xml"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end match;
end fun_32;

protected function fun_33
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Function> in_a_modelInfo_functions;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_modelInfo_functions, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_modelInfo_functions;
      String a_fileNamePrefix;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_modelInfo_functions,
           a_fileNamePrefix )
      equation
        txt_0 = simulationParModelicaKernelsFile(Tpl.emptyTxt, a_fileNamePrefix, a_modelInfo_functions);
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, a_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_kernels.cl"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end match;
end fun_33;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      list<DAE.Exp> i_literals;
      list<SimCode.RecordDeclaration> i_recordDecls;
      list<SimCode.Function> i_modelInfo_functions;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Boolean ret_17;
      Tpl.Text txt_16;
      Tpl.Text txt_15;
      Tpl.Text txt_14;
      Tpl.Text txt_13;
      Tpl.Text l_0__;
      Tpl.Text txt_11;
      Tpl.Text txt_10;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      String ret_3;
      Tpl.Text l_target;
      String ret_1;
      Tpl.Text l_guid;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = i_modelInfo_functions), fileNamePrefix = i_fileNamePrefix, recordDecls = i_recordDecls, literals = i_literals, simulationSettingsOpt = i_simulationSettingsOpt)) )
      equation
        ret_1 = System.getUUIDStr();
        l_guid = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_3 = Config.simulationCodeTarget();
        l_target = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        txt_4 = simulationMakefile(Tpl.emptyTxt, Tpl.textString(l_target), i_simCode);
        txt_5 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_4, Tpl.textString(txt_5));
        txt_6 = simulationFunctionsHeaderFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_recordDecls);
        txt_7 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_7 = Tpl.writeTok(txt_7, Tpl.ST_STRING("_functions.h"));
        Tpl.textFile(txt_6, Tpl.textString(txt_7));
        txt_8 = simulationFunctionsFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_literals);
        txt_9 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_9 = Tpl.writeTok(txt_9, Tpl.ST_STRING("_functions.c"));
        Tpl.textFileConvertLines(txt_8, Tpl.textString(txt_9));
        txt_10 = recordsFile(Tpl.emptyTxt, i_fileNamePrefix, i_recordDecls);
        txt_11 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_11 = Tpl.writeTok(txt_11, Tpl.ST_STRING("_records.c"));
        Tpl.textFile(txt_10, Tpl.textString(txt_11));
        l_0__ = fun_32(Tpl.emptyTxt, i_simulationSettingsOpt, i_fileNamePrefix, l_guid, i_simCode);
        txt_13 = simulationHeaderFile(Tpl.emptyTxt, i_simCode, Tpl.textString(l_guid));
        txt_14 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_14 = Tpl.writeTok(txt_14, Tpl.ST_STRING("_model.h"));
        Tpl.textFile(txt_13, Tpl.textString(txt_14));
        txt_15 = simulationFile(Tpl.emptyTxt, i_simCode, Tpl.textString(l_guid));
        txt_16 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_16 = Tpl.writeTok(txt_16, Tpl.ST_STRING(".c"));
        Tpl.textFileConvertLines(txt_15, Tpl.textString(txt_16));
        ret_17 = Config.acceptParModelicaGrammar();
        txt = fun_33(txt, ret_17, i_modelInfo_functions, i_fileNamePrefix);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end translateModel;

protected function fun_35
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;
  input Tpl.Text in_a_filePrefix;
  input SimCode.FunctionCode in_a_functionCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_mainFunction, in_a_filePrefix, in_a_functionCode)
    local
      Tpl.Text txt;
      Tpl.Text a_filePrefix;
      SimCode.FunctionCode a_functionCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           NONE(),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_filePrefix,
           a_functionCode )
      equation
        txt_0 = functionsMakefile(Tpl.emptyTxt, a_functionCode);
        txt_1 = Tpl.writeText(Tpl.emptyTxt, a_filePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end match;
end fun_35;

protected function fun_36
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Function> in_a_functions;
  input Option<SimCode.Function> in_a_mainFunction;
  input Tpl.Text in_a_filePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_functions, in_a_mainFunction, in_a_filePrefix)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_functions;
      Option<SimCode.Function> a_mainFunction;
      Tpl.Text a_filePrefix;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_functions,
           a_mainFunction,
           a_filePrefix )
      equation
        txt_0 = functionsParModelicaKernelsFile(Tpl.emptyTxt, Tpl.textString(a_filePrefix), a_mainFunction, a_functions);
        txt_1 = Tpl.writeText(Tpl.emptyTxt, a_filePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_kernels.cl"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end match;
end fun_36;

public function translateFunctions
  input Tpl.Text in_txt;
  input SimCode.FunctionCode in_a_functionCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_functionCode)
    local
      Tpl.Text txt;
      list<DAE.Exp> i_literals;
      list<String> i_externalFunctionIncludes;
      list<SimCode.RecordDeclaration> i_extraRecordDecls;
      list<SimCode.Function> i_functions;
      SimCode.FunctionCode i_functionCode;
      Option<SimCode.Function> i_mainFunction;
      String i_name;
      Boolean ret_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text l_0__;
      Tpl.Text l_filePrefix;

    case ( txt,
           (i_functionCode as SimCode.FUNCTIONCODE(name = i_name, mainFunction = i_mainFunction, functions = i_functions, extraRecordDecls = i_extraRecordDecls, externalFunctionIncludes = i_externalFunctionIncludes, literals = i_literals)) )
      equation
        l_filePrefix = Tpl.writeStr(Tpl.emptyTxt, i_name);
        l_0__ = fun_35(Tpl.emptyTxt, i_mainFunction, l_filePrefix, i_functionCode);
        txt_2 = functionsHeaderFile(Tpl.emptyTxt, Tpl.textString(l_filePrefix), i_mainFunction, i_functions, i_extraRecordDecls, i_externalFunctionIncludes);
        txt_3 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt_4 = functionsFile(Tpl.emptyTxt, Tpl.textString(l_filePrefix), i_mainFunction, i_functions, i_literals);
        txt_5 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING(".c"));
        Tpl.textFileConvertLines(txt_4, Tpl.textString(txt_5));
        txt_6 = recordsFile(Tpl.emptyTxt, Tpl.textString(l_filePrefix), i_extraRecordDecls);
        txt_7 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_7 = Tpl.writeTok(txt_7, Tpl.ST_STRING("_records.c"));
        Tpl.textFile(txt_6, Tpl.textString(txt_7));
        ret_8 = Config.acceptParModelicaGrammar();
        txt = fun_36(txt, ret_8, i_functions, i_mainFunction, l_filePrefix);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end translateFunctions;

protected function fun_38
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      BackendDAE.SampleLookup i_sampleLookup;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), sampleLookup = i_sampleLookup, jacobianMatrixes = i_jacobianMatrixes) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* Simulation code for "));
        txt = CodegenUtil.dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
        ret_0 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(". */\n"));
        txt = variableDefinitions(txt, i_modelInfo, i_sampleLookup);
        txt = Tpl.softNewLine(txt);
        txt = variableDefinitionsJacobians(txt, i_jacobianMatrixes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_38;

public function simulationHeaderFile
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_38(txt, a_simCode);
end simulationHeaderFile;

protected function fun_40
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define HPCOM"));
      then txt;
  end match;
end fun_40;

protected function fun_41
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simulationSettingsOpt)
    local
      Tpl.Text txt;
      String i_settings_method;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(method = i_settings_method)) )
      equation
        txt = Tpl.writeStr(txt, i_settings_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_41;

protected function fun_42
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimCode in_a_simCode;
  input list<DAE.ClassAttributes> in_a_classAttributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_classAttributes)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<DAE.ClassAttributes> a_classAttributes;

    case ( txt,
           false,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int mayer(DATA* data, modelica_real* res){return -1;}\n",
                                    "     int lagrange(DATA* data, modelica_real* res){return -1;}"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_classAttributes )
      equation
        txt = optimizationComponents(txt, a_classAttributes, a_simCode);
      then txt;
  end match;
end fun_42;

public function simulationFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      list<DAE.ClassAttributes> i_classAttributes;
      list<SimCode.SimEqSystem> i_algorithmAndEquationAsserts;
      list<DAE.ComponentRef> i_discreteModelVars;
      list<BackendDAE.ZeroCrossing> i_relations;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<list<SimCode.SimEqSystem>> i_algebraicEquations;
      Option<HpcOmScheduler.ScheduleSimCode> i_hpcOmSchedule;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      list<SimCode.SimWhenClause> i_whenClauses;
      Boolean i_useHomotopy;
      Boolean i_useSymbolicInitialization;
      list<SimCode.SimEqSystem> i_residualEquations;
      list<SimCode.SimEqSystem> i_startValueEquations;
      BackendDAE.SampleLookup i_sampleLookup;
      list<SimCode.StateSet> i_stateSets;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_inlineEquations;
      list<SimCode.SimEqSystem> i_initialEquations;
      SimCode.ExtObjInfo i_extObjInfo;
      SimCode.DelayedExpression i_delayedExps;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.ModelInfo i_modelInfo;
      String i_fileNamePrefix;
      list<String> i_externalFunctionIncludes;
      SimCode.SimCode i_simCode;
      Boolean ret_6;
      list<SimCode.SimEqSystem> ret_5;
      list<SimCode.SimEqSystem> ret_4;
      Tpl.Text txt_3;
      list<SimCode.SimEqSystem> ret_2;
      list<SimCode.SimEqSystem> ret_1;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(externalFunctionIncludes = i_externalFunctionIncludes, fileNamePrefix = i_fileNamePrefix, modelInfo = i_modelInfo, allEquations = i_allEquations, jacobianMatrixes = i_jacobianMatrixes, delayedExps = i_delayedExps, extObjInfo = i_extObjInfo, initialEquations = i_initialEquations, inlineEquations = i_inlineEquations, parameterEquations = i_parameterEquations, stateSets = i_stateSets, sampleLookup = i_sampleLookup, startValueEquations = i_startValueEquations, residualEquations = i_residualEquations, useSymbolicInitialization = i_useSymbolicInitialization, useHomotopy = i_useHomotopy, whenClauses = i_whenClauses, odeEquations = i_odeEquations, simulationSettingsOpt = i_simulationSettingsOpt, hpcOmSchedule = i_hpcOmSchedule, algebraicEquations = i_algebraicEquations, zeroCrossings = i_zeroCrossings, relations = i_relations, discreteModelVars = i_discreteModelVars, algorithmAndEquationAsserts = i_algorithmAndEquationAsserts, classAttributes = i_classAttributes)),
           a_guid )
      equation
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = externalFunctionIncludes(txt, i_externalFunctionIncludes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_model.h\"\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.c\"\n",
                                    "/* dummy VARINFO and FILEINFO */\n",
                                    "const FILE_INFO dummyFILE_INFO = omc_dummyFileInfo;\n",
                                    "const VAR_INFO dummyVAR_INFO = omc_dummyVarInfo;\n",
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "int measure_time_flag = 1;\n",
                                    "#else\n",
                                    "int measure_time_flag = 0;\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        ret_0 = Flags.isSet(Flags.HPCOM);
        txt = fun_40(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#if defined(HPCOM)\n",
                                    "  #if !defined(_OPENMP)\n",
                                    "    #error \"HPCOM requires OpenMP or the results are wrong\"\n",
                                    "  #endif\n",
                                    "  #include <omp.h>\n",
                                    "  #include <perform_simulation.c>\n",
                                    "#elif defined(_OPENMP)\n",
                                    "  #include <omp.h>\n",
                                    "  #include <omp_perform_simulation.c>\n",
                                    "#else\n",
                                    "  #include <perform_simulation.c>\n",
                                    "  /* dummy omp defines */\n",
                                    "  #define omp_get_max_threads() 1\n",
                                    "#endif\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = functionInitializeDataStruc(txt, i_modelInfo, i_fileNamePrefix, a_guid, i_allEquations, i_jacobianMatrixes, i_delayedExps);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = functionCallExternalObjectConstructors(txt, i_extObjInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCallExternalObjectDestructors(txt, i_extObjInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionNonLinearResiduals(txt, i_initialEquations);
        txt = Tpl.softNewLine(txt);
        txt = functionNonLinearResiduals(txt, i_inlineEquations);
        txt = Tpl.softNewLine(txt);
        txt = functionNonLinearResiduals(txt, i_parameterEquations);
        txt = Tpl.softNewLine(txt);
        txt = functionNonLinearResiduals(txt, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitialNonLinearSystems(txt, i_initialEquations, i_inlineEquations, i_parameterEquations, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_1 = SimCodeUtil.collectAllJacobianEquations(i_jacobianMatrixes);
        txt = functionSetupLinearSystems(txt, i_initialEquations, i_inlineEquations, i_parameterEquations, i_allEquations, ret_1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_2 = SimCodeUtil.collectAllJacobianEquations(i_jacobianMatrixes);
        txt = functionInitialLinearSystems(txt, i_initialEquations, i_inlineEquations, i_parameterEquations, i_allEquations, ret_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitialStateSets(txt, i_stateSets);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionOutput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitSample(txt, i_sampleLookup);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionStoreDelayed(txt, i_delayedExps);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionUpdateBoundStartValues(txt, i_startValueEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitialResidual(txt, i_residualEquations);
        txt = Tpl.softNewLine(txt);
        txt = functionInitialEquations(txt, i_useSymbolicInitialization, i_useHomotopy, i_initialEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInlineEquations(txt, i_inlineEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionUpdateBoundParameters(txt, i_parameterEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionDAE(txt, i_allEquations, i_whenClauses);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_3 = fun_41(Tpl.emptyTxt, i_simulationSettingsOpt);
        (txt, txt_3) = functionODE(txt, i_odeEquations, txt_3, i_hpcOmSchedule);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionAlgebraic(txt, i_algebraicEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionZeroCrossing(txt, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionRelations(txt, i_relations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCheckForDiscreteChanges(txt, i_discreteModelVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionAssertsforCheck(txt, i_algorithmAndEquationAsserts);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_4 = SimCodeUtil.collectAllJacobianEquations(i_jacobianMatrixes);
        txt = functionSetupMixedSystems(txt, i_initialEquations, i_inlineEquations, i_parameterEquations, i_allEquations, ret_4);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_5 = SimCodeUtil.collectAllJacobianEquations(i_jacobianMatrixes);
        txt = functionInitialMixedSystems(txt, i_initialEquations, i_inlineEquations, i_parameterEquations, i_allEquations, ret_5);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionAnalyticJacobians(txt, i_jacobianMatrixes);
        txt = Tpl.softNewLine(txt);
        ret_6 = Config.acceptOptimicaGrammar();
        txt = fun_42(txt, ret_6, i_simCode, i_classAttributes);
        txt = Tpl.softNewLine(txt);
        txt = functionlinearmodel(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif\n",
                                    "\n",
                                    "/* forward the main in the simulation runtime */\n",
                                    "extern int _main_SimulationRuntime(int argc, char**argv, DATA *data);\n",
                                    "\n",
                                    "/* call the simulation runtime main from our main! */\n",
                                    "int main(int argc, char**argv)\n",
                                    "{\n",
                                    "  DATA data;\n",
                                    "  setupDataStruc(&data);\n",
                                    "  return _main_SimulationRuntime(argc, argv, &data);\n",
                                    "}\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end simulationFile;

public function simulationFileHeader
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), extObjInfo = SimCode.EXTOBJINFO(vars = _), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* Simulation code for "));
        txt = CodegenUtil.dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
        ret_0 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ". */\n",
                                    "\n",
                                    "#include \"openmodelica.h\"\n",
                                    "#include \"openmodelica_func.h\"\n",
                                    "#include \"simulation_data.h\"\n",
                                    "#include \"simulation_info_xml.h\"\n",
                                    "#include \"simulation_runtime.h\"\n",
                                    "#include \"omc_error.h\"\n",
                                    "#include \"model_help.h\"\n",
                                    "\n",
                                    "#include <assert.h>\n",
                                    "#include <string.h>\n",
                                    "\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.h\"\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationFileHeader;

protected function fun_45
  input Tpl.Text in_txt;
  input SimCode.DelayedExpression in_a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_delayed)
    local
      Tpl.Text txt;
      Integer i_maxDelayedIndex;

    case ( txt,
           SimCode.DELAYED_EXPRESSIONS(maxDelayedIndex = i_maxDelayedIndex) )
      equation
        txt = Tpl.writeStr(txt, intString(i_maxDelayedIndex));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_45;

protected function fun_46
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input String in_a_fileNamePrefix;
  input String in_a_guid;
  input list<SimCode.JacobianMatrix> in_a_symJacs;
  input SimCode.DelayedExpression in_a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_fileNamePrefix, in_a_guid, in_a_symJacs, in_a_delayed)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;
      String a_guid;
      list<SimCode.JacobianMatrix> a_symJacs;
      SimCode.DelayedExpression a_delayed;
      Integer i_varInfo_numInlineVars;
      Integer i_varInfo_numStateSets;
      Integer i_varInfo_numNonLinearSystems;
      Integer i_varInfo_numLinearSystems;
      Integer i_varInfo_numMixedSystems;
      Integer i_varInfo_numEquations;
      list<SimCode.Function> i_functions;
      Integer i_varInfo_numExternalObjects;
      Integer i_varInfo_numInitialResiduals;
      Integer i_varInfo_numInitialAlgorithms;
      Integer i_varInfo_numInitialEquations;
      Integer i_varInfo_numMathEventFunctions;
      Integer i_varInfo_numRelations;
      Integer i_varInfo_numTimeEvents;
      Integer i_varInfo_numZeroCrossings;
      Integer i_varInfo_numStringAliasVars;
      Integer i_varInfo_numBoolAliasVars;
      Integer i_varInfo_numIntAliasVars;
      Integer i_varInfo_numAlgAliasVars;
      Integer i_varInfo_numOutVars;
      Integer i_varInfo_numInVars;
      Integer i_varInfo_numStringParamVars;
      Integer i_varInfo_numBoolParams;
      Integer i_varInfo_numIntParams;
      Integer i_varInfo_numParams;
      Integer i_varInfo_numStringAlgVars;
      Integer i_varInfo_numBoolAlgVars;
      Integer i_varInfo_numIntAlgVars;
      Integer i_varInfo_numDiscreteReal;
      Integer i_varInfo_numAlgVars;
      Integer i_varInfo_numStateVars;
      String i_directory;
      Absyn.Path i_name;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars, numAlgVars = i_varInfo_numAlgVars, numDiscreteReal = i_varInfo_numDiscreteReal, numIntAlgVars = i_varInfo_numIntAlgVars, numBoolAlgVars = i_varInfo_numBoolAlgVars, numStringAlgVars = i_varInfo_numStringAlgVars, numParams = i_varInfo_numParams, numIntParams = i_varInfo_numIntParams, numBoolParams = i_varInfo_numBoolParams, numStringParamVars = i_varInfo_numStringParamVars, numInVars = i_varInfo_numInVars, numOutVars = i_varInfo_numOutVars, numAlgAliasVars = i_varInfo_numAlgAliasVars, numIntAliasVars = i_varInfo_numIntAliasVars, numBoolAliasVars = i_varInfo_numBoolAliasVars, numStringAliasVars = i_varInfo_numStringAliasVars, numZeroCrossings = i_varInfo_numZeroCrossings, numTimeEvents = i_varInfo_numTimeEvents, numRelations = i_varInfo_numRelations, numMathEventFunctions = i_varInfo_numMathEventFunctions, numInitialEquations = i_varInfo_numInitialEquations, numInitialAlgorithms = i_varInfo_numInitialAlgorithms, numInitialResiduals = i_varInfo_numInitialResiduals, numExternalObjects = i_varInfo_numExternalObjects, numEquations = i_varInfo_numEquations, numMixedSystems = i_varInfo_numMixedSystems, numLinearSystems = i_varInfo_numLinearSystems, numNonLinearSystems = i_varInfo_numNonLinearSystems, numStateSets = i_varInfo_numStateSets, numInlineVars = i_varInfo_numInlineVars), name = i_name, directory = i_directory, functions = i_functions),
           a_fileNamePrefix,
           a_guid,
           a_symJacs,
           a_delayed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->modelData.modelName = \""));
        txt = CodegenUtil.dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "data->modelData.modelFilePrefix = \""
                                }, false));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "data->modelData.modelDir = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "data->modelData.modelGUID = \"{"
                                }, false));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\";\n",
                                    "#ifdef OPENMODELICA_XML_FROM_FILE_AT_RUNTIME\n",
                                    "data->modelData.initXMLData = NULL;\n",
                                    "data->modelData.modelDataXml.infoXMLData = NULL;\n",
                                    "#else\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_init.c\"\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_info.c\"\n",
                                    "#endif\n",
                                    "\n",
                                    "data->modelData.nStates = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nVariablesReal = 2*"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nDiscreteReal = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numDiscreteReal));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nVariablesInteger = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nVariablesBoolean = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nVariablesString = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nParametersReal = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nParametersInteger = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nParametersBoolean = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nParametersString = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nInputVars = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nOutputVars = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nJacobians = "
                                }, false));
        ret_0 = listLength(a_symJacs);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "data->modelData.nAliasReal = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nAliasInteger = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nAliasBoolean = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nAliasString = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "data->modelData.nZeroCrossings = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nSamples = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numTimeEvents));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nRelations = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numRelations));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nMathEvents = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numMathEventFunctions));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nInitEquations = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInitialEquations));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nInitAlgorithms = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInitialAlgorithms));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nInitResiduals = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInitialResiduals));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";    /* data->modelData.nInitEquations + data->modelData.nInitAlgorithms */\n",
                                    "data->modelData.nExtObjs = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numExternalObjects));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.modelDataXml.fileName = \""
                                }, false));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_info.xml\";\n",
                                    "data->modelData.modelDataXml.nFunctions = "
                                }, false));
        ret_1 = listLength(i_functions);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.modelDataXml.nProfileBlocks = 0;\n",
                                    "data->modelData.modelDataXml.nEquations = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numEquations));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nMixedSystems = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numMixedSystems));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nLinearSystems = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numLinearSystems));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nNonLinearSystems = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numNonLinearSystems));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nStateSets = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateSets));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nInlineVars = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInlineVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "data->modelData.nDelayExpressions = "
                                }, false));
        txt = fun_45(txt, a_delayed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_46;

public function populateModelInfo
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input String a_fileNamePrefix;
  input String a_guid;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.JacobianMatrix> a_symJacs;
  input SimCode.DelayedExpression a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_46(txt, a_modelInfo, a_fileNamePrefix, a_guid, a_symJacs, a_delayed);
end populateModelInfo;

public function functionInitializeDataStruc
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input String a_fileNamePrefix;
  input String a_guid;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.JacobianMatrix> a_symJacs;
  input SimCode.DelayedExpression a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "#define threadData data->threadData\n",
                                   "void setupDataStruc(DATA *data)\n",
                                   "{\n",
                                   "  ASSERT(data, \"Error while initialize Data\");\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := populateModelInfo(out_txt, a_modelInfo, a_fileNamePrefix, a_guid, a_allEquations, a_symJacs, a_delayed);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitializeDataStruc;

public function functionSimProfDef
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Integer in_a_value;
  input Tpl.Text in_a_reverseProf;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reverseProf;
algorithm
  (out_txt, out_a_reverseProf) :=
  match(in_txt, in_a_eq, in_a_value, in_a_reverseProf)
    local
      Tpl.Text txt;
      Integer a_value;
      Tpl.Text a_reverseProf;
      Integer i_index;

    case ( txt,
           SimCode.SES_MIXED(index = i_index),
           a_value,
           a_reverseProf )
      equation
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING("data->modelData.equationInfo_reverse_prof_index["));
        a_reverseProf = Tpl.writeStr(a_reverseProf, intString(a_value));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING("] = "));
        a_reverseProf = Tpl.writeStr(a_reverseProf, intString(i_index));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING(";"));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(a_value));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_reverseProf);

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_value,
           a_reverseProf )
      equation
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING("data->modelData.equationInfo_reverse_prof_index["));
        a_reverseProf = Tpl.writeStr(a_reverseProf, intString(a_value));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING("] = "));
        a_reverseProf = Tpl.writeStr(a_reverseProf, intString(i_index));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING(";"));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(a_value));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_reverseProf);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_value,
           a_reverseProf )
      equation
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING("data->modelData.equationInfo_reverse_prof_index["));
        a_reverseProf = Tpl.writeStr(a_reverseProf, intString(a_value));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING("] = "));
        a_reverseProf = Tpl.writeStr(a_reverseProf, intString(i_index));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING(";"));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(a_value));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_reverseProf);

    case ( txt,
           _,
           _,
           a_reverseProf )
      then (txt, a_reverseProf);
  end match;
end functionSimProfDef;

public function functionInitializeDataStruc2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input list<SimCode.SimEqSystem> in_a_allEquations;
  input list<SimCode.StateSet> in_a_stateSets;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_allEquations, in_a_stateSets)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquations;
      list<SimCode.StateSet> a_stateSets;
      list<SimCode.Function> i_functions;
      Integer i_vi_numEquations;
      Integer ret_4;
      Tpl.Text l_nProfileBlocks;
      Tpl.Text l_eqnInfo;
      Tpl.Text l_reverseProf;
      Tpl.Text l_eqnsDefines;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numEquations = i_vi_numEquations), functions = i_functions),
           a_allEquations,
           a_stateSets )
      equation
        l_eqnsDefines = Tpl.emptyTxt;
        l_reverseProf = Tpl.emptyTxt;
        (l_eqnInfo, l_eqnsDefines, l_reverseProf) = equationInfo(Tpl.emptyTxt, a_allEquations, a_stateSets, l_eqnsDefines, l_reverseProf, i_vi_numEquations);
        ret_4 = System.tmpTick();
        l_nProfileBlocks = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Some empty lines, since emptyCount is not implemented in susan! */\n"));
        txt = Tpl.writeText(txt, l_eqnsDefines);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void setupDataStruc2(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = globalDataFunctionInfoArray(txt, "function_names", i_functions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "memcpy(data->modelData.functionNames, &funcInfo, data->modelData.nFunctions*sizeof(FUNCTION_INFO));\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_eqnInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "memcpy(data->modelData.equationInfo, &equationInfo, data->modelData.nEquations*sizeof(EQUATION_INFO));\n",
                                    "data->modelData.nProfileBlocks = "
                                }, false));
        txt = Tpl.writeText(txt, l_nProfileBlocks);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.equationInfo_reverse_prof_index = (int*) malloc(data->modelData.nProfileBlocks*sizeof(int));\n"
                                }, true));
        txt = Tpl.writeText(txt, l_reverseProf);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end functionInitializeDataStruc2;

protected function lm_51
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;
  end match;
end lm_51;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = globalDataVarDefine(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_52;

protected function lm_53
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "inlineVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest);
      then txt;
  end match;
end lm_53;

protected function lm_54
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = globalDataVarDefine(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_54(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_54;

protected function lm_55
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_55(txt, rest);
      then txt;
  end match;
end lm_55;

protected function lm_56
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "extObjs");
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest);
      then txt;
  end match;
end lm_56;

protected function lm_57
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_57(txt, rest);
      then txt;
  end match;
end lm_57;

protected function lm_58
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_58(txt, rest);
      then txt;
  end match;
end lm_58;

protected function lm_59
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_59(txt, rest);
      then txt;
  end match;
end lm_59;

protected function lm_60
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_60(txt, rest);
      then txt;
  end match;
end lm_60;

protected function lm_61
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_61(txt, rest);
      then txt;
  end match;
end lm_61;

protected function lm_62
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_62(txt, rest);
      then txt;
  end match;
end lm_62;

protected function lm_63
  input Tpl.Text in_txt;
  input list<tuple<Integer, DAE.Exp, DAE.Exp>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<Integer, DAE.Exp, DAE.Exp>> rest;
      Integer i_index;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_index, _, _) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define $P$sample"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo.samples["));
        ret_0 = intSub(i_index, 1);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
        txt = Tpl.nextIter(txt);
        txt = lm_63(txt, rest);
      then txt;
  end match;
end lm_63;

protected function fun_64
  input Tpl.Text in_txt;
  input BackendDAE.SampleLookup in_a_sampleLookup;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sampleLookup)
    local
      Tpl.Text txt;
      list<tuple<Integer, DAE.Exp, DAE.Exp>> i_lookup;

    case ( txt,
           BackendDAE.SAMPLE_LOOKUP(lookup = i_lookup) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_63(txt, i_lookup);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_64;

protected function lm_65
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      Integer x_i0;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = functionName(txt, i_fn, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_index "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.nextIter(txt);
        txt = lm_65(txt, rest);
      then txt;
  end match;
end lm_65;

protected function fun_66
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input BackendDAE.SampleLookup in_a_sampleLookup;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_sampleLookup)
    local
      Tpl.Text txt;
      BackendDAE.SampleLookup a_sampleLookup;
      list<SimCode.Function> i_functions;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_extObjVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_inlineVars;
      Integer i_numStateVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_numStateVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, inlineVars = i_vars_inlineVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars, extObjVars = i_vars_extObjVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars), functions = i_functions),
           a_sampleLookup )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#define time data->localData[0]->timeValue\n",
                                    "\n",
                                    "/* States */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_51(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* StatesDerivatives */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_52(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* InlineSolver Vars */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_53(txt, i_vars_inlineVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic Vars */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_54(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic Parameter */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_55(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* External Objects */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_56(txt, i_vars_extObjVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic Integer Vars */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_57(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic Integer Parameter */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_58(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic Boolean Vars */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_59(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic Boolean Parameters */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_60(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic String Variables */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_61(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic String Parameter */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_62(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* sample */\n"
                                }, true));
        txt = fun_64(txt, a_sampleLookup);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_65(txt, i_functions);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_66;

public function variableDefinitions
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input BackendDAE.SampleLookup a_sampleLookup;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1000);
  out_txt := fun_66(txt, a_modelInfo, a_sampleLookup);
end variableDefinitions;

protected function lm_68
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;
      Absyn.Info ret_1;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = functionName(txt, i_fn, true);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",{"));
        ret_1 = SimCodeUtil.functionInfo(i_fn);
        txt = infoArgs(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}}"));
        txt = Tpl.nextIter(txt);
        txt = lm_68(txt, rest);
      then txt;
  end match;
end lm_68;

protected function fun_69
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> i_items;
      Integer ret_0;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct FUNCTION_INFO funcInfo[1] = {{-1,\"\",omc_dummyFileInfo}};"));
      then txt;

    case ( txt,
           i_items )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct FUNCTION_INFO funcInfo["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_68(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end match;
end fun_69;

public function globalDataFunctionInfoArray
  input Tpl.Text txt;
  input String a_name;
  input list<SimCode.Function> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_69(txt, a_items);
end globalDataFunctionInfoArray;

public function globalDataParDefine
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      DAE.ComponentRef i_name;
      Integer i_index;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMVAR(arrayCref = SOME(i_c), aliasvar = SimCode.NOALIAS(), index = i_index, name = i_name),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].attribute\n",
                                    "#define $P$ATTRIBUTE$P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $P$ATTRIBUTE"));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define _"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) "));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].info"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = SimCode.NOALIAS(), name = i_name, index = i_index),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define _"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) "));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define $P$ATTRIBUTE"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].attribute\n",
                                    "#define $P$ATTRIBUTE$P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $P$ATTRIBUTE"));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].info"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end globalDataParDefine;

public function globalDataVarDefine
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      DAE.ComponentRef i_name;
      Integer i_index;
      DAE.ComponentRef i_c;
      Integer ret_14;
      Integer ret_13;
      Integer ret_12;
      Integer ret_11;
      Integer ret_10;
      Integer ret_9;
      Integer ret_8;
      Integer ret_7;
      Integer ret_6;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_tmp;

    case ( txt,
           SimCode.SIMVAR(arrayCref = SOME(i_c), aliasvar = SimCode.NOALIAS(), index = i_index, name = i_name),
           a_arrayName,
           a_offset )
      equation
        ret_1 = System.tmpTick();
        l_tmp = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define _"));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) data->localData[i]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_2 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(0)\n",
                                    "#define _"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) data->localData[i]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_3 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(0)\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pre["));
        ret_4 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pre["));
        ret_5 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_5));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_6 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].attribute\n",
                                    "#define $P$ATTRIBUTE$P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $P$ATTRIBUTE"));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_7 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].info\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_8 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].info"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = SimCode.NOALIAS(), name = i_name, index = i_index),
           a_arrayName,
           a_offset )
      equation
        ret_9 = System.tmpTick();
        l_tmp = Tpl.writeStr(Tpl.emptyTxt, intString(ret_9));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define _"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) data->localData[i]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_10 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_10));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define _$P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) $P$PRE"));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(0)\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pre["));
        ret_11 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_11));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_12 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_12));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].attribute\n",
                                    "#define $P$ATTRIBUTE$P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $P$ATTRIBUTE"));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_13 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_13));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].info\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_14 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_14));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].info"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end globalDataVarDefine;

protected function lm_73
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer i_index;
      SimCode.AliasVariable i_aliasvar;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = i_aliasvar, index = i_index) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = aliasVarNameType(txt, i_aliasvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_73(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_73(txt, rest);
      then txt;
  end match;
end lm_73;

protected function fun_74
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_items;
  input String in_a_0__type;
  input String in_a_0__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_items, in_a_0__type, in_a_0__name)
    local
      Tpl.Text txt;
      String a_0__type;
      String a_0__name;
      list<SimCode.SimVar> i_items;
      Integer ret_0;

    case ( txt,
           {},
           a_0__type,
           a_0__name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_0__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[1] = {{0,0,-1}};"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_items,
           a_0__type,
           a_0__name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_0__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_73(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_74;

public function globalDataAliasVarArray
  input Tpl.Text txt;
  input String a_0__type;
  input String a_0__name;
  input list<SimCode.SimVar> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_74(txt, a_items, a_0__type, a_0__name);
end globalDataAliasVarArray;

protected function lm_76
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      Integer x_index0;
      list<SimCode.SimVar> i_diffedVars;
      list<SimCode.SimVar> i_diffVars;
      String i_name;
      list<SimCode.SimVar> i_seedVars;
      list<SimCode.JacobianColumn> i_jacColumn;
      Tpl.Text l_sparseDef;
      Tpl.Text l_varsDef;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_jacColumn, i_seedVars, i_name, (_, (i_diffVars, i_diffedVars)), _, _) :: rest )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        l_varsDef = variableDefinitionsJacobians2(Tpl.emptyTxt, x_index0, i_jacColumn, i_seedVars, i_name);
        l_sparseDef = defineSparseIndexes(Tpl.emptyTxt, i_diffVars, i_diffedVars, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(_MSC_VER)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const int INDEX_JAC_"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, intString(x_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "int functionJac"
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_column(void* data);\n",
                                    "int initialAnalyticJacobian"
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(void* data);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(_MSC_VER)\n",
                                    "}\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varsDef);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_sparseDef);
        txt = Tpl.nextIter(txt);
        txt = lm_76(txt, rest);
      then txt;
  end match;
end lm_76;

public function variableDefinitionsJacobians
  input Tpl.Text txt;
  input list<SimCode.JacobianMatrix> a_JacobianMatrixes;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_analyticVars;
algorithm
  l_analyticVars := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_analyticVars := lm_76(l_analyticVars, a_JacobianMatrixes);
  l_analyticVars := Tpl.popIter(l_analyticVars);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("/* Jacobian Variables */\n"));
  out_txt := Tpl.writeText(out_txt, l_analyticVars);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end variableDefinitionsJacobians;

protected function lm_78
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input String in_a_name;
  input Integer in_a_indexJacobian;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name, in_a_indexJacobian)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      String a_name;
      Integer a_indexJacobian;
      Integer x_index0;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_name,
           a_indexJacobian )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = jacobianVarDefine(txt, i_var, "jacobianVarsSeed", a_indexJacobian, x_index0, a_name);
        txt = Tpl.nextIter(txt);
        txt = lm_78(txt, rest, a_name, a_indexJacobian);
      then txt;
  end match;
end lm_78;

protected function lm_79
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input String in_a_name;
  input Integer in_a_indexJacobian;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name, in_a_indexJacobian)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      String a_name;
      Integer a_indexJacobian;
      Integer x_index0;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_name,
           a_indexJacobian )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = jacobianVarDefine(txt, i_var, "jacobianVars", a_indexJacobian, x_index0, a_name);
        txt = Tpl.nextIter(txt);
        txt = lm_79(txt, rest, a_name, a_indexJacobian);
      then txt;
  end match;
end lm_79;

protected function lm_80
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input String in_a_name;
  input Integer in_a_indexJacobian;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name, in_a_indexJacobian)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String a_name;
      Integer a_indexJacobian;
      list<SimCode.SimVar> i_vars;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           (_, i_vars, _) :: rest,
           a_name,
           a_indexJacobian )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_79(txt, i_vars, a_name, a_indexJacobian);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_80(txt, rest, a_name, a_indexJacobian);
      then txt;
  end match;
end lm_80;

public function variableDefinitionsJacobians2
  input Tpl.Text txt;
  input Integer a_indexJacobian;
  input list<SimCode.JacobianColumn> a_jacobianColumn;
  input list<SimCode.SimVar> a_seedVars;
  input String a_name;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_columnVarsResult;
  Tpl.Text l_seedVarsResult;
algorithm
  l_seedVarsResult := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_seedVarsResult := lm_78(l_seedVarsResult, a_seedVars, a_name, a_indexJacobian);
  l_seedVarsResult := Tpl.popIter(l_seedVarsResult);
  l_columnVarsResult := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                        "\n",
                                                                                        "\n"
                                                                                    }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_columnVarsResult := lm_80(l_columnVarsResult, a_jacobianColumn, a_name, a_indexJacobian);
  l_columnVarsResult := Tpl.popIter(l_columnVarsResult);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(" */\n"));
  out_txt := Tpl.writeText(out_txt, l_seedVarsResult);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_columnVarsResult);
end variableDefinitionsJacobians2;

protected function fun_82
  input Tpl.Text in_txt;
  input Integer in_a_index;
  input Integer in_a_index0;
  input Integer in_a_indexJac;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_index, in_a_index0, in_a_indexJac, in_a_name)
    local
      Tpl.Text txt;
      Integer a_index0;
      Integer a_indexJac;
      DAE.ComponentRef a_name;
      Integer i_index;

    case ( txt,
           -1,
           a_index0,
           a_indexJac,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo.analyticJacobians["));
        txt = Tpl.writeStr(txt, intString(a_indexJac));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].tmpVars["));
        txt = Tpl.writeStr(txt, intString(a_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo dummyVAR_INFO"));
      then txt;

    case ( txt,
           i_index,
           _,
           a_indexJac,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo.analyticJacobians["));
        txt = Tpl.writeStr(txt, intString(a_indexJac));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].resultVars["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo dummyVAR_INFO"));
      then txt;
  end match;
end fun_82;

protected function fun_83
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input Integer in_a_index0;
  input Integer in_a_indexJac;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_index0, in_a_indexJac)
    local
      Tpl.Text txt;
      Integer a_index0;
      Integer a_indexJac;
      DAE.ComponentRef i_name;
      Integer i_index;

    case ( txt,
           SimCode.SIMVAR(aliasvar = SimCode.NOALIAS(), name = i_name, index = i_index),
           a_index0,
           a_indexJac )
      equation
        txt = fun_82(txt, i_index, a_index0, a_indexJac, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_83;

protected function fun_84
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input Integer in_a_index0;
  input Integer in_a_indexJac;
  input String in_a_matrixName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_index0, in_a_indexJac, in_a_matrixName)
    local
      Tpl.Text txt;
      Integer a_index0;
      Integer a_indexJac;
      String a_matrixName;
      DAE.ComponentRef i_name;
      Integer ret_1;
      Tpl.Text l_tmp;

    case ( txt,
           SimCode.SIMVAR(aliasvar = SimCode.NOALIAS(), name = i_name),
           a_index0,
           a_indexJac,
           a_matrixName )
      equation
        ret_1 = System.tmpTick();
        l_tmp = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixName);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo.analyticJacobians["));
        txt = Tpl.writeStr(txt, intString(a_indexJac));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].seedVars["));
        txt = Tpl.writeStr(txt, intString(a_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixName);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo dummyVAR_INFO"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_84;

protected function fun_85
  input Tpl.Text in_txt;
  input String in_a_array;
  input SimCode.SimVar in_a_simVar;
  input Integer in_a_indexJac;
  input Integer in_a_index0;
  input String in_a_matrixName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_array, in_a_simVar, in_a_indexJac, in_a_index0, in_a_matrixName)
    local
      Tpl.Text txt;
      SimCode.SimVar a_simVar;
      Integer a_indexJac;
      Integer a_index0;
      String a_matrixName;

    case ( txt,
           "jacobianVars",
           a_simVar,
           a_indexJac,
           a_index0,
           _ )
      equation
        txt = fun_83(txt, a_simVar, a_index0, a_indexJac);
      then txt;

    case ( txt,
           "jacobianVarsSeed",
           a_simVar,
           a_indexJac,
           a_index0,
           a_matrixName )
      equation
        txt = fun_84(txt, a_simVar, a_index0, a_indexJac, a_matrixName);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_85;

public function jacobianVarDefine
  input Tpl.Text txt;
  input SimCode.SimVar a_simVar;
  input String a_array;
  input Integer a_indexJac;
  input Integer a_index0;
  input String a_matrixName;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_85(txt, a_array, a_simVar, a_indexJac, a_index0, a_matrixName);
end jacobianVarDefine;

protected function lm_87
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input String in_a_matrixName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_matrixName)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      String a_matrixName;
      Integer x_index0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_matrixName )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$indexdiff "));
        txt = Tpl.writeStr(txt, intString(x_index0));
        txt = Tpl.nextIter(txt);
        txt = lm_87(txt, rest, a_matrixName);
      then txt;

    case ( txt,
           _ :: rest,
           a_matrixName )
      equation
        txt = lm_87(txt, rest, a_matrixName);
      then txt;
  end match;
end lm_87;

protected function lm_88
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input String in_a_matrixName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_matrixName)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      String a_matrixName;
      Integer x_index0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_matrixName )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$indexdiffed "));
        txt = Tpl.writeStr(txt, intString(x_index0));
        txt = Tpl.nextIter(txt);
        txt = lm_88(txt, rest, a_matrixName);
      then txt;

    case ( txt,
           _ :: rest,
           a_matrixName )
      equation
        txt = lm_88(txt, rest, a_matrixName);
      then txt;
  end match;
end lm_88;

public function defineSparseIndexes
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_diffVars;
  input list<SimCode.SimVar> a_diffedVars;
  input String a_matrixName;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_diffedVarsResult;
  Tpl.Text l_diffVarsResult;
algorithm
  l_diffVarsResult := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_diffVarsResult := lm_87(l_diffVarsResult, a_diffVars, a_matrixName);
  l_diffVarsResult := Tpl.popIter(l_diffVarsResult);
  l_diffedVarsResult := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_diffedVarsResult := lm_88(l_diffedVarsResult, a_diffedVars, a_matrixName);
  l_diffedVarsResult := Tpl.popIter(l_diffedVarsResult);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
  out_txt := Tpl.writeStr(out_txt, a_matrixName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(" sparse indexes */\n"));
  out_txt := Tpl.writeText(out_txt, l_diffVarsResult);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_diffedVarsResult);
end defineSparseIndexes;

public function aliasVarNameType
  input Tpl.Text in_txt;
  input SimCode.AliasVariable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_varName;

    case ( txt,
           SimCode.NOALIAS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0,0"));
      then txt;

    case ( txt,
           SimCode.ALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = cref(txt, i_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",0"));
      then txt;

    case ( txt,
           SimCode.NEGATEDALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = cref(txt, i_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",1"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end aliasVarNameType;

protected function lm_91
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_arg;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMVAR(initialValue = SOME(i_exp), name = i_var_name) :: rest,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_arg, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_arg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "restore_memory_state(mem_state);"
                                }, false));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_91(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_91(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_91;

protected function lm_92
  input Tpl.Text in_txt;
  input list<SimCode.ExtAlias> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.ExtAlias> rest;
      DAE.ComponentRef i_var2;
      DAE.ComponentRef i_var1;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var1, i_var2) :: rest )
      equation
        txt = cref(txt, i_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = cref(txt, i_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_92(txt, rest);
      then txt;
  end match;
end lm_92;

public function functionCallExternalObjectConstructors
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extObjInfo)
    local
      Tpl.Text txt;
      list<SimCode.ExtAlias> i_aliases;
      list<SimCode.SimVar> i_vars;
      Tpl.Text l_ctorCalls;
      Tpl.Text l_varDecls;
      Tpl.Text l_funDecls;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_vars, aliases = i_aliases) )
      equation
        l_funDecls = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_ctorCalls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_ctorCalls, l_varDecls) = lm_91(l_ctorCalls, i_vars, l_varDecls);
        l_ctorCalls = Tpl.popIter(l_ctorCalls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* Has to be performed after _init.xml file has been read */\n",
                                    "void callExternalObjectConstructors(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "state mem_state;\n",
                                    "mem_state = get_memory_state();\n",
                                    "/* data->simulationInfo.extObjs = NULL; */\n",
                                    "INFO(LOG_DEBUG, \"call external Object Constructors\");\n"
                                }, true));
        txt = Tpl.writeText(txt, l_ctorCalls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_92(txt, i_aliases);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("INFO(LOG_DEBUG, \"call external Object Constructors finished\");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionCallExternalObjectConstructors;

protected function lm_94
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_var_name;
      Absyn.Path i_ext_fullClassName;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(varKind = BackendDAE.EXTOBJ(fullClassName = i_ext_fullClassName), name = i_var_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omc_"));
        txt = underscorePath(txt, i_ext_fullClassName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_destructor(threadData,"));
        txt = cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_94(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_94(txt, rest);
      then txt;
  end match;
end lm_94;

public function functionCallExternalObjectDestructors
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extObjInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_extObjInfo_vars;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_extObjInfo_vars) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void callExternalObjectDestructors(DATA *data)\n",
                                    "{\n",
                                    "  if(data->simulationInfo.extObjs)\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_94(txt, i_extObjInfo_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "free(data->simulationInfo.extObjs);\n",
                                    "data->simulationInfo.extObjs = 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionCallExternalObjectDestructors;

protected function lm_96
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = data->simulationInfo.inputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_96(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_96(txt, rest);
      then txt;
  end match;
end lm_96;

public function functionInput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_inputVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(inputVars = i_vars_inputVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int input_function(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_96(txt, i_vars_inputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionInput;

protected function lm_98
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.outputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_98(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_98(txt, rest);
      then txt;
  end match;
end lm_98;

public function functionOutput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_outputVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(outputVars = i_vars_outputVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int output_function(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_98(txt, i_vars_outputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionOutput;

protected function lm_100
  input Tpl.Text in_txt;
  input list<tuple<Integer, DAE.Exp, DAE.Exp>> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<tuple<Integer, DAE.Exp, DAE.Exp>> rest;
      Tpl.Text a_varDecls;
      Integer i_index;
      DAE.Exp i_interval;
      DAE.Exp i_start;
      Tpl.Text l_e2;
      Tpl.Text l_e1;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_index, i_start, i_interval) :: rest,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_start, SimCode.contextOther, l_preExp, a_varDecls);
        (l_e2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_interval, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* $P$sample"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "data->modelData.samplesInfo[i].index = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.samplesInfo[i].start = "
                                }, false));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.samplesInfo[i].interval = "
                                }, false));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "ASSERT(data->modelData.samplesInfo[i].interval > 0.0, \"sample-interval <= 0.0\");\n",
                                    "i++;"
                                }, false));
        (txt, a_varDecls) = lm_100(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_100;

protected function fun_101
  input Tpl.Text in_txt;
  input BackendDAE.SampleLookup in_a_sampleLookup;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_sampleLookup, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<tuple<Integer, DAE.Exp, DAE.Exp>> i_lookup;

    case ( txt,
           BackendDAE.SAMPLE_LOOKUP(lookup = i_lookup),
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_100(txt, i_lookup, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_101;

public function functionInitSample
  input Tpl.Text txt;
  input BackendDAE.SampleLookup a_sampleLookup;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* Initializes the raw time events of the simulation using the now\n",
                                   "   calcualted parameters. */\n",
                                   "void function_initSample(DATA *data)\n",
                                   "{\n",
                                   "  long i=0;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  (out_txt, l_varDecls) := fun_101(out_txt, a_sampleLookup, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitSample;

public function functionInitialMixedSystems
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initialEquations;
  input list<SimCode.SimEqSystem> a_inlineEquations;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.SimEqSystem> a_jacobianEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacobianbody;
  Tpl.Text l_body;
  Tpl.Text l_parambody;
  Tpl.Text l_inlinebody;
  Tpl.Text l_initbody;
algorithm
  l_initbody := functionInitialMixedSystemsTemp(Tpl.emptyTxt, a_initialEquations);
  l_inlinebody := functionInitialMixedSystemsTemp(Tpl.emptyTxt, a_inlineEquations);
  l_parambody := functionInitialMixedSystemsTemp(Tpl.emptyTxt, a_parameterEquations);
  l_body := functionInitialMixedSystemsTemp(Tpl.emptyTxt, a_allEquations);
  l_jacobianbody := functionInitialMixedSystemsTemp(Tpl.emptyTxt, a_jacobianEquations);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* funtion initialize mixed systems */\n",
                                   "void initialMixedSystem(MIXED_SYSTEM_DATA* mixedSystemData)\n",
                                   "{\n",
                                   "  /* initial mixed systems */\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_initbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* inline mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_inlinebody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* parameter mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_parambody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* model mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* jacobians mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_jacobianbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialMixedSystems;

protected function fun_104
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn)
    local
      Tpl.Text txt;
      Integer i_index;
      Integer i_indexMixedSystem;
      list<SimCode.SimVar> i_discVars;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_MIXED(discVars = i_discVars, indexMixedSystem = i_indexMixedSystem, index = i_index) )
      equation
        ret_1 = listLength(i_discVars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mixedSystemData["));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].equationIndex = "));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "mixedSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].size = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "mixedSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].solveContinuousPart = updateContinuousPart"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "mixedSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].updateIterationExps = updateIterationExpMixedSystem"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_104;

protected function lm_105
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqn :: rest )
      equation
        txt = fun_104(txt, i_eqn);
        txt = Tpl.nextIter(txt);
        txt = lm_105(txt, rest);
      then txt;
  end match;
end lm_105;

public function functionInitialMixedSystemsTemp
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_105(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
end functionInitialMixedSystemsTemp;

public function functionSetupMixedSystems
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initialEquations;
  input list<SimCode.SimEqSystem> a_inlineEquations;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.SimEqSystem> a_jacobianEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacobianbody;
  Tpl.Text l_body;
  Tpl.Text l_parambody;
  Tpl.Text l_inlinebody;
  Tpl.Text l_initbody;
algorithm
  l_initbody := functionSetupMixedSystemsTemp(Tpl.emptyTxt, a_initialEquations);
  l_inlinebody := functionSetupMixedSystemsTemp(Tpl.emptyTxt, a_inlineEquations);
  l_parambody := functionSetupMixedSystemsTemp(Tpl.emptyTxt, a_parameterEquations);
  l_body := functionSetupMixedSystemsTemp(Tpl.emptyTxt, a_allEquations);
  l_jacobianbody := functionSetupMixedSystemsTemp(Tpl.emptyTxt, a_jacobianEquations);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("/* initial mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_initbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* inline mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_inlinebody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* parameter mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_parambody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* model mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* jacobians mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_jacobianbody);
end functionSetupMixedSystems;

protected function fun_108
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_cont;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cont)
    local
      Tpl.Text txt;
      Integer i_indexNonLinearSystem;
      Integer i_indexLinearSystem;

    case ( txt,
           SimCode.SES_LINEAR(indexLinearSystem = i_indexLinearSystem) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.linearSystemData["));
        txt = Tpl.writeStr(txt, intString(i_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].solved"));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(indexNonLinearSystem = i_indexNonLinearSystem) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.nonlinearSystemData["));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].solved"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_108;

protected function lm_109
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preDisc;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preDisc;
algorithm
  (out_txt, out_a_varDecls, out_a_preDisc) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preDisc)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preDisc;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           a_varDecls,
           a_preDisc )
      then (txt, a_varDecls, a_preDisc);

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref) :: rest,
           a_varDecls,
           a_preDisc )
      equation
        (l_expPart, a_preDisc, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextSimulationDiscrete, a_preDisc, a_varDecls);
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preDisc) = lm_109(txt, rest, a_varDecls, a_preDisc);
      then (txt, a_varDecls, a_preDisc);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preDisc )
      equation
        (txt, a_varDecls, a_preDisc) = lm_109(txt, rest, a_varDecls, a_preDisc);
      then (txt, a_varDecls, a_preDisc);
  end match;
end lm_109;

protected function fun_110
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn)
    local
      Tpl.Text txt;
      Integer i_indexMixedSystem;
      Integer i_index;
      list<SimCode.SimEqSystem> i_discEqs;
      SimCode.SimEqSystem i_cont;
      Tpl.Text l_discExp;
      Tpl.Text l_varDecls;
      Tpl.Text l_preDisc;
      Tpl.Text l_solvedContinuous;
      Tpl.Text l_contEqsIndex;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont, discEqs = i_discEqs, index = i_index, indexMixedSystem = i_indexMixedSystem) )
      equation
        l_contEqsIndex = equationIndex(Tpl.emptyTxt, i_cont);
        l_solvedContinuous = fun_108(Tpl.emptyTxt, i_cont);
        l_preDisc = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_discExp = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_discExp, l_varDecls, l_preDisc) = lm_109(l_discExp, i_discEqs, l_varDecls, l_preDisc);
        l_discExp = Tpl.popIter(l_discExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void updateContinuousPart"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void *inData)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) inData;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("eqFunction_"));
        txt = Tpl.writeText(txt, l_contEqsIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(data);\n",
                                    "data->simulationInfo.mixedSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].continuous_solution = "));
        txt = Tpl.writeText(txt, l_solvedContinuous);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "void updateIterationExpMixedSystem"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void *inData)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) inData;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_preDisc);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_discExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_110;

protected function lm_111
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqn :: rest )
      equation
        txt = fun_110(txt, i_eqn);
        txt = Tpl.nextIter(txt);
        txt = lm_111(txt, rest);
      then txt;
  end match;
end lm_111;

public function functionSetupMixedSystemsTemp
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_111(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
end functionSetupMixedSystemsTemp;

public function functionInitialLinearSystems
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initialEquations;
  input list<SimCode.SimEqSystem> a_inlineEquations;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.SimEqSystem> a_jacobianEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacobianbody;
  Tpl.Text l_body;
  Tpl.Text l_parambody;
  Tpl.Text l_inlinebody;
  Tpl.Text l_initbody;
algorithm
  l_initbody := functionInitialLinearSystemsTemp(Tpl.emptyTxt, a_initialEquations);
  l_inlinebody := functionInitialLinearSystemsTemp(Tpl.emptyTxt, a_inlineEquations);
  l_parambody := functionInitialLinearSystemsTemp(Tpl.emptyTxt, a_parameterEquations);
  l_body := functionInitialLinearSystemsTemp(Tpl.emptyTxt, a_allEquations);
  l_jacobianbody := functionInitialLinearSystemsTemp(Tpl.emptyTxt, a_jacobianEquations);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* funtion initialize linear systems */\n",
                                   "void initialLinearSystem(LINEAR_SYSTEM_DATA* linearSystemData)\n",
                                   "{\n",
                                   "  /* initial linear systems */\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_initbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* inline linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_inlinebody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* parameter linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_parambody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* model linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* jacobians linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_jacobianbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialLinearSystems;

protected function fun_114
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn)
    local
      Tpl.Text txt;
      Integer i_index;
      Integer i_indexLinearSystem;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<SimCode.SimVar> i_vars;
      SimCode.SimEqSystem i_eq_cont;
      Integer ret_4;
      Tpl.Text l_nnz;
      Integer ret_2;
      Tpl.Text l_size;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq_cont) )
      equation
        ret_0 = List.fill(i_eq_cont, 1);
        txt = functionInitialLinearSystemsTemp(txt, ret_0);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, simJac = i_simJac, indexLinearSystem = i_indexLinearSystem, index = i_index) )
      equation
        ret_2 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        ret_4 = listLength(i_simJac);
        l_nnz = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("linearSystemData["));
        txt = Tpl.writeStr(txt, intString(i_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].equationIndex = "));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].size = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nnz = "));
        txt = Tpl.writeText(txt, l_nnz);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].setA = setLinearMatrixA"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].setb = setLinearVectorb"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_114;

protected function lm_115
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqn :: rest )
      equation
        txt = fun_114(txt, i_eqn);
        txt = Tpl.nextIter(txt);
        txt = lm_115(txt, rest);
      then txt;
  end match;
end lm_115;

public function functionInitialLinearSystemsTemp
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_115(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
end functionInitialLinearSystemsTemp;

public function functionSetupLinearSystems
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initialEquations;
  input list<SimCode.SimEqSystem> a_inlineEquations;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.SimEqSystem> a_jacobianEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacobianbody;
  Tpl.Text l_body;
  Tpl.Text l_parambody;
  Tpl.Text l_inlinebody;
  Tpl.Text l_initbody;
algorithm
  l_initbody := functionSetupLinearSystemsTemp(Tpl.emptyTxt, a_initialEquations);
  l_inlinebody := functionSetupLinearSystemsTemp(Tpl.emptyTxt, a_inlineEquations);
  l_parambody := functionSetupLinearSystemsTemp(Tpl.emptyTxt, a_parameterEquations);
  l_body := functionSetupLinearSystemsTemp(Tpl.emptyTxt, a_allEquations);
  l_jacobianbody := functionSetupLinearSystemsTemp(Tpl.emptyTxt, a_jacobianEquations);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("/* initial linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_initbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* inline linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_inlinebody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* parameter linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_parambody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* model linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* jacobians linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_jacobianbody);
end functionSetupLinearSystems;

protected function lm_118
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      Integer i_col;
      Integer i_row;
      DAE.Exp i_eq_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_row, i_col, SimCode.SES_RESIDUAL(exp = i_eq_exp)) :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("linearSystemData->setAElement("));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", linearSystemData);"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_118(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_118(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_118;

protected function lm_119
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls2;
algorithm
  (out_txt, out_a_varDecls2) :=
  match(in_txt, in_items, in_a_varDecls2)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls2;
      Integer x_i0;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls2 )
      then (txt, a_varDecls2);

    case ( txt,
           i_exp :: rest,
           a_varDecls2 )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls2) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls2);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("linearSystemData->b["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] =  "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls2) = lm_119(txt, rest, a_varDecls2);
      then (txt, a_varDecls2);
  end match;
end lm_119;

protected function fun_120
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn)
    local
      Tpl.Text txt;
      Integer i_index;
      list<DAE.Exp> i_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      SimCode.SimEqSystem i_eq_cont;
      Tpl.Text l_vectorb;
      Tpl.Text l_varDecls2;
      Tpl.Text l_MatrixA;
      Tpl.Text l_varDecls;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq_cont) )
      equation
        ret_0 = List.fill(i_eq_cont, 1);
        txt = functionSetupLinearSystemsTemp(txt, ret_0);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(simJac = i_simJac, beqs = i_beqs, index = i_index) )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_MatrixA = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_MatrixA, l_varDecls) = lm_118(l_MatrixA, i_simJac, l_varDecls);
        l_MatrixA = Tpl.popIter(l_MatrixA);
        l_varDecls2 = Tpl.emptyTxt;
        l_vectorb = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_vectorb, l_varDecls2) = lm_119(l_vectorb, i_beqs, l_varDecls2);
        l_vectorb = Tpl.popIter(l_vectorb);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void setLinearMatrixA"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void *inData, void *systemData)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) inData;\n",
                                    "  LINEAR_SYSTEM_DATA* linearSystemData = (LINEAR_SYSTEM_DATA*) systemData;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_MatrixA);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "void setLinearVectorb"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void *inData, void *systemData)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) inData;\n",
                                    "  LINEAR_SYSTEM_DATA* linearSystemData = (LINEAR_SYSTEM_DATA*) systemData;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorb);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_120;

protected function lm_121
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqn :: rest )
      equation
        txt = fun_120(txt, i_eqn);
        txt = Tpl.nextIter(txt);
        txt = lm_121(txt, rest);
      then txt;
  end match;
end lm_121;

public function functionSetupLinearSystemsTemp
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_121(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
end functionSetupLinearSystemsTemp;

public function functionInitialNonLinearSystems
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initialEquations;
  input list<SimCode.SimEqSystem> a_inlineEquations;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_body;
  Tpl.Text l_parambody;
  Tpl.Text l_inlinebody;
  Tpl.Text l_initbody;
algorithm
  l_initbody := functionInitialNonLinearSystemsTemp(Tpl.emptyTxt, a_initialEquations);
  l_inlinebody := functionInitialNonLinearSystemsTemp(Tpl.emptyTxt, a_inlineEquations);
  l_parambody := functionInitialNonLinearSystemsTemp(Tpl.emptyTxt, a_parameterEquations);
  l_body := functionInitialNonLinearSystemsTemp(Tpl.emptyTxt, a_allEquations);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* funtion initialize non-linear systems */\n",
                                   "void initialNonLinearSystem(NONLINEAR_SYSTEM_DATA* nonLinearSystemData)\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_initbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_inlinebody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_parambody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialNonLinearSystems;

protected function fun_124
  input Tpl.Text in_txt;
  input Boolean in_a_linearTearing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_linearTearing)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_124;

protected function fun_125
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_jacobianMatrix;
  input Integer in_a_eq_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_jacobianMatrix, in_a_eq_index)
    local
      Tpl.Text txt;
      Integer a_eq_index;

    case ( txt,
           SOME(_),
           a_eq_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("functionJacNLSJac"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_column"));
      then txt;

    case ( txt,
           NONE(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NULL"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_125;

protected function fun_126
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_jacobianMatrix;
  input Integer in_a_eq_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_jacobianMatrix, in_a_eq_index)
    local
      Tpl.Text txt;
      Integer a_eq_index;

    case ( txt,
           SOME(_),
           a_eq_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initialAnalyticJacobianNLSJac"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
      then txt;

    case ( txt,
           NONE(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NULL"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_126;

protected function fun_127
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_jacobianMatrix;
  input Integer in_a_eq_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_jacobianMatrix, in_a_eq_index)
    local
      Tpl.Text txt;
      Integer a_eq_index;

    case ( txt,
           SOME(_),
           a_eq_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("INDEX_JAC_NLSJac"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
      then txt;

    case ( txt,
           NONE(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-1"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_127;

protected function fun_128
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn)
    local
      Tpl.Text txt;
      Integer i_index;
      Integer i_indexNonLinearSystem;
      list<SimCode.SimEqSystem> i_eqs;
      Integer i_eq_index;
      Option<SimCode.JacobianMatrix> i_jacobianMatrix;
      Boolean i_linearTearing;
      list<DAE.ComponentRef> i_crefs;
      SimCode.SimEqSystem i_eq_cont;
      Tpl.Text l_innerEqs;
      Tpl.Text l_jacIndex;
      Tpl.Text l_initialJac;
      Tpl.Text l_generatedJac;
      Tpl.Text l_newtonStep;
      Integer ret_2;
      Tpl.Text l_size;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq_cont) )
      equation
        ret_0 = List.fill(i_eq_cont, 1);
        txt = functionInitialNonLinearSystemsTemp(txt, ret_0);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs, linearTearing = i_linearTearing, jacobianMatrix = i_jacobianMatrix, index = (i_index as i_eq_index), eqs = i_eqs, indexNonLinearSystem = i_indexNonLinearSystem) )
      equation
        ret_2 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_newtonStep = fun_124(Tpl.emptyTxt, i_linearTearing);
        l_generatedJac = fun_125(Tpl.emptyTxt, i_jacobianMatrix, i_eq_index);
        l_initialJac = fun_126(Tpl.emptyTxt, i_jacobianMatrix, i_eq_index);
        l_jacIndex = fun_127(Tpl.emptyTxt, i_jacobianMatrix, i_eq_index);
        l_innerEqs = functionInitialNonLinearSystemsTemp(Tpl.emptyTxt, i_eqs);
        txt = Tpl.writeText(txt, l_innerEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nonLinearSystemData["));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].equationIndex = "));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].size = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].method = "));
        txt = Tpl.writeText(txt, l_newtonStep);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].residualFunc = residualFunc"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].analyticalJacobianColumn = "));
        txt = Tpl.writeText(txt, l_generatedJac);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].initialAnalyticalJacobian = "));
        txt = Tpl.writeText(txt, l_initialJac);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].jacobianIndex = "));
        txt = Tpl.writeText(txt, l_jacIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].initializeStaticNLSData = initializeStaticNLSData"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_128;

protected function lm_129
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqn :: rest )
      equation
        txt = fun_128(txt, i_eqn);
        txt = Tpl.nextIter(txt);
        txt = lm_129(txt, rest);
      then txt;
  end match;
end lm_129;

public function functionInitialNonLinearSystemsTemp
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_129(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
end functionInitialNonLinearSystemsTemp;

public function functionExtraResidualsPreBody
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_eqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) :=
  match(in_txt, in_a_eq, in_a_varDecls, in_a_eqs)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_eqs;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           SimCode.SES_RESIDUAL(index = _),
           a_varDecls,
           a_eqs )
      then (txt, a_varDecls, a_eqs);

    case ( txt,
           i_eq,
           a_varDecls,
           a_eqs )
      equation
        (txt, a_varDecls, a_eqs) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_eqs);
      then (txt, a_varDecls, a_eqs);
  end match;
end functionExtraResidualsPreBody;

public function equationNamesExtraResidualsPreBody
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           SimCode.SES_RESIDUAL(index = _) )
      then txt;

    case ( txt,
           i_eq )
      equation
        txt = equationNames_(txt, i_eq, SimCode.contextSimulationDiscrete);
      then txt;
  end match;
end equationNamesExtraResidualsPreBody;

protected function lm_133
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer x_i0;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = xloc["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_133(txt, rest);
      then txt;
  end match;
end lm_133;

protected function lm_134
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* static nls data for "));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "nlsData->nominal[i] = $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".nominal;\n",
                                    "nlsData->min[i]     = $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".min;\n",
                                    "nlsData->max[i++]   = $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".max;"));
        txt = Tpl.nextIter(txt);
        txt = lm_134(txt, rest);
      then txt;
  end match;
end lm_134;

protected function lm_135
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq2 :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = functionExtraResidualsPreBody(txt, i_eq2, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_135(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_135;

protected function lm_136
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_eq2_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_eq2_exp) :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq2_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("res["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_136(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_136(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_136;

protected function fun_137
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn)
    local
      Tpl.Text txt;
      Integer i_index;
      list<SimCode.SimEqSystem> i_eq_eqs;
      list<DAE.ComponentRef> i_crefs;
      list<SimCode.SimEqSystem> i_eqs;
      SimCode.SimEqSystem i_eq_cont;
      Tpl.Text l_body;
      Tpl.Text l_prebody;
      Tpl.Text l_body__initializeStaticNLSData;
      Tpl.Text l_xlocs;
      Tpl.Text l_innerEqs;
      Tpl.Text l_tmp;
      Tpl.Text l_varDecls;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq_cont) )
      equation
        ret_0 = List.fill(i_eq_cont, 1);
        txt = functionNonLinearResiduals(txt, ret_0);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(eqs = (i_eq_eqs as i_eqs), crefs = i_crefs, index = i_index) )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_tmp = Tpl.emptyTxt;
        l_innerEqs = functionNonLinearResiduals(Tpl.emptyTxt, i_eqs);
        l_xlocs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_xlocs = lm_133(l_xlocs, i_crefs);
        l_xlocs = Tpl.popIter(l_xlocs);
        l_body__initializeStaticNLSData = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__initializeStaticNLSData = lm_134(l_body__initializeStaticNLSData, i_crefs);
        l_body__initializeStaticNLSData = Tpl.popIter(l_body__initializeStaticNLSData);
        l_prebody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_prebody, l_tmp, l_varDecls) = lm_135(l_prebody, i_eq_eqs, l_tmp, l_varDecls);
        l_prebody = Tpl.popIter(l_prebody);
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, l_varDecls) = lm_136(l_body, i_eq_eqs, l_varDecls);
        l_body = Tpl.popIter(l_body);
        txt = Tpl.writeText(txt, l_innerEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void initializeStaticNLSData"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void *inData, void *inNlsData)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) inData;\n",
                                    "  NONLINEAR_SYSTEM_DATA* nlsData = (NONLINEAR_SYSTEM_DATA*) inNlsData;\n",
                                    "  int i=0;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__initializeStaticNLSData);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "void residualFunc"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* dataIn, double* xloc, double* res, integer* iflag)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) dataIn;\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ADD_NCALL_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ").profileBlockIndex,1);\n",
                                    "#endif\n",
                                    "mem_state = get_memory_state();\n"
                                }, true));
        txt = Tpl.writeText(txt, l_xlocs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_prebody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("restore_memory_state(mem_state);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_137;

protected function lm_138
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqn :: rest )
      equation
        txt = fun_137(txt, i_eqn);
        txt = Tpl.nextIter(txt);
        txt = lm_138(txt, rest);
      then txt;
  end match;
end lm_138;

public function functionNonLinearResiduals
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_138(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
end functionNonLinearResiduals;

protected function lm_140
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_i1)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_i1;
      Integer x_i2;
      DAE.ComponentRef i_s;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_s :: rest,
           a_i1 )
      equation
        x_i2 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("statesetData["));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].states["));
        txt = Tpl.writeStr(txt, intString(x_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = &"));
        txt = cref(txt, i_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo;"));
        txt = Tpl.nextIter(txt);
        txt = lm_140(txt, rest, a_i1);
      then txt;
  end match;
end lm_140;

protected function lm_141
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_i1)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_i1;
      Integer x_i2;
      DAE.ComponentRef i_cstate;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_cstate :: rest,
           a_i1 )
      equation
        x_i2 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("statesetData["));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].statescandidates["));
        txt = Tpl.writeStr(txt, intString(x_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = &"));
        txt = cref(txt, i_cstate);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo;"));
        txt = Tpl.nextIter(txt);
        txt = lm_141(txt, rest, a_i1);
      then txt;
  end match;
end lm_141;

protected function fun_142
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_set, in_a_i1)
    local
      Tpl.Text txt;
      Integer a_i1;
      DAE.ComponentRef i_crA;
      Integer i_nStates;
      Integer i_nCandidates;
      list<DAE.ComponentRef> i_statescandidates;
      list<DAE.ComponentRef> i_states;
      Integer i_set_index;
      Tpl.Text l_statescandidatesvars;
      Tpl.Text l_statesvars;
      Tpl.Text l_jacIndex;
      Tpl.Text l_initialJac;
      Tpl.Text l_generatedJac;

    case ( txt,
           SimCode.SES_STATESET(index = i_set_index, states = i_states, statescandidates = i_statescandidates, nCandidates = i_nCandidates, nStates = i_nStates, crA = i_crA),
           a_i1 )
      equation
        l_generatedJac = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("functionJacStateSetJac"));
        l_generatedJac = Tpl.writeStr(l_generatedJac, intString(i_set_index));
        l_generatedJac = Tpl.writeTok(l_generatedJac, Tpl.ST_STRING("_column"));
        l_initialJac = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("initialAnalyticJacobianStateSetJac"));
        l_initialJac = Tpl.writeStr(l_initialJac, intString(i_set_index));
        l_jacIndex = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("INDEX_JAC_StateSetJac"));
        l_jacIndex = Tpl.writeStr(l_jacIndex, intString(i_set_index));
        l_statesvars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_statesvars = lm_140(l_statesvars, i_states, a_i1);
        l_statesvars = Tpl.popIter(l_statesvars);
        l_statescandidatesvars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_statescandidatesvars = lm_141(l_statescandidatesvars, i_statescandidates, a_i1);
        l_statescandidatesvars = Tpl.popIter(l_statescandidatesvars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("statesetData["));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nCandidates = "));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nStates = "));
        txt = Tpl.writeStr(txt, intString(i_nStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nDummyStates = "));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        txt = Tpl.writeStr(txt, intString(i_nStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].states = (VAR_INFO**) calloc("));
        txt = Tpl.writeStr(txt, intString(i_nStates));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",sizeof(VAR_INFO));\n"));
        txt = Tpl.writeText(txt, l_statesvars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("statesetData["));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].statescandidates = (VAR_INFO**) calloc("));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",sizeof(VAR_INFO));\n"));
        txt = Tpl.writeText(txt, l_statescandidatesvars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("statesetData["));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].A = &"));
        txt = cref(txt, i_crA);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "__varInfo;\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].rowPivot = (modelica_integer*) calloc("));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        txt = Tpl.writeStr(txt, intString(i_nStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",sizeof(modelica_integer));\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].colPivot = (modelica_integer*) calloc("));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",sizeof(modelica_integer));\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].J = (modelica_real*) calloc("));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*("));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        txt = Tpl.writeStr(txt, intString(i_nStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "),sizeof(modelica_real));\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].analyticalJacobianColumn = "));
        txt = Tpl.writeText(txt, l_generatedJac);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].initialAnalyticalJacobian = "));
        txt = Tpl.writeText(txt, l_initialJac);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].jacobianIndex = "));
        txt = Tpl.writeText(txt, l_jacIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_142;

protected function lm_143
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_set :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_142(txt, i_set, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_143(txt, rest);
      then txt;
  end match;
end lm_143;

public function functionInitialStateSets
  input Tpl.Text txt;
  input list<SimCode.StateSet> a_stateSets;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_body;
algorithm
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                            "\n",
                                                                            "\n"
                                                                        }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_body := lm_143(l_body, a_stateSets);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* funtion initialize state sets */\n",
                                   "void initializeStateSets(STATE_SET_DATA* statesetData, DATA *data)\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialStateSets;

protected function lm_145
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(index = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_145(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_145(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_145;

protected function lm_146
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      DAE.ComponentRef i_cref;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("INFO2(LOG_INIT, \"%s(start="));
        txt = crefToPrintfArg(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")\", "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo.name, ("));
        txt = crefType(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P$ATTRIBUTE"));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".start = "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_146(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_146(txt, rest);
      then txt;
  end match;
end lm_146;

public function functionUpdateBoundStartValues
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_startValueEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqPart, l_tmp, l_varDecls) := lm_145(l_eqPart, a_startValueEquations, l_tmp, l_varDecls);
  l_eqPart := Tpl.popIter(l_eqPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int updateBoundStartValues(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_eqPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "INFO(LOG_INIT, \"updating start-values\");\n",
                                       "INDENT(LOG_INIT);\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_146(out_txt, a_startValueEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "RELEASE(LOG_INIT);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionUpdateBoundStartValues;

protected function lm_148
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state(mem_state);"));
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_148(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_148;

public function functionUpdateBoundParameters
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_parameterEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_body;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  System.tmpTickReset(0);
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_tmp, l_varDecls) := lm_148(l_body, a_parameterEquations, l_tmp, l_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int updateBoundParameters(DATA *data)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("mem_state = get_memory_state();\n"));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionUpdateBoundParameters;

protected function fun_150
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.SCONST(string = _),
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initialResiduals[i++] = 0;"));
      then (txt, a_varDecls);

    case ( txt,
           i_exp,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initialResiduals[i++] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "INFO3(LOG_RES_INIT, \"[%d]: %s = %g\", i, initialResidualDescription[i-1], initialResiduals[i-1]);"
                                }, false));
      then (txt, a_varDecls);
  end match;
end fun_150;

public function functionInitialResidualBody
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_eqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) :=
  match(in_txt, in_a_eq, in_a_varDecls, in_a_eqs)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_eqs;
      SimCode.SimEqSystem i_eq;
      DAE.Exp i_exp;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_exp),
           a_varDecls,
           a_eqs )
      equation
        (txt, a_varDecls) = fun_150(txt, i_exp, a_varDecls);
      then (txt, a_varDecls, a_eqs);

    case ( txt,
           i_eq,
           a_varDecls,
           a_eqs )
      equation
        (txt, a_varDecls, a_eqs) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_eqs);
      then (txt, a_varDecls, a_eqs);
  end match;
end functionInitialResidualBody;

protected function fun_152
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      String ret_0;

    case ( txt,
           DAE.SCONST(string = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"0\", "));
      then txt;

    case ( txt,
           i_exp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", "));
      then txt;
  end match;
end fun_152;

protected function lm_153
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_exp) :: rest )
      equation
        txt = fun_152(txt, i_exp);
        txt = Tpl.nextIter(txt);
        txt = lm_153(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_153(txt, rest);
      then txt;
  end match;
end lm_153;

protected function lm_154
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq2 :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = functionInitialResidualBody(txt, i_eq2, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_154(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_154;

protected function fun_155
  input Tpl.Text in_txt;
  input Tpl.Text in_a_resDesc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_resDesc)
    local
      Tpl.Text txt;
      Tpl.Text i_resDesc;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *initialResidualDescription[1] = {\"empty\"};"));
      then txt;

    case ( txt,
           i_resDesc )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "const char *initialResidualDescription[] =\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, i_resDesc);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end match;
end fun_155;

public function functionInitialResidual
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_residualEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_desc;
  Tpl.Text l_body;
  Tpl.Text l_resDesc;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_resDesc := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_resDesc := lm_153(l_resDesc, a_residualEquations);
  l_resDesc := Tpl.popIter(l_resDesc);
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_tmp, l_varDecls) := lm_154(l_body, a_residualEquations, l_tmp, l_varDecls);
  l_body := Tpl.popIter(l_body);
  l_desc := fun_155(Tpl.emptyTxt, l_resDesc);
  out_txt := Tpl.writeText(txt, l_desc);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int initial_residual(DATA *data, double *initialResiduals)\n",
                                       "{\n",
                                       "  int i = 0;\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n",
                                       "INFO(LOG_RES_INIT, \"updating initial residuals\");\n",
                                       "INDENT(LOG_RES_INIT);\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "RELEASE(LOG_RES_INIT);\n",
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialResidual;

protected function lm_157
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state(mem_state);"));
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_157(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_157;

protected function fun_158
  input Tpl.Text in_txt;
  input Boolean in_a_useSymbolicInitialization;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_useSymbolicInitialization)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_158;

protected function fun_159
  input Tpl.Text in_txt;
  input Boolean in_a_useHomotopy;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_useHomotopy)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_159;

protected function fun_160
  input Tpl.Text in_txt;
  input Boolean in_a_useSymbolicInitialization;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_useSymbolicInitialization)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ERROR0(LOG_INIT, \"The symbolic initialization was not generated.\");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_160;

public function functionInitialEquations
  input Tpl.Text txt;
  input Boolean a_useSymbolicInitialization;
  input Boolean a_useHomotopy;
  input list<SimCode.SimEqSystem> a_initalEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_errorMsg;
  Tpl.Text l_useHomotopyToInt;
  Tpl.Text l_useSymbolicInitializationToInt;
  Tpl.Text l_body;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  System.tmpTickReset(0);
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_tmp, l_varDecls) := lm_157(l_body, a_initalEquations, l_tmp, l_varDecls);
  l_body := Tpl.popIter(l_body);
  l_useSymbolicInitializationToInt := fun_158(Tpl.emptyTxt, a_useSymbolicInitialization);
  l_useHomotopyToInt := fun_159(Tpl.emptyTxt, a_useHomotopy);
  l_errorMsg := fun_160(Tpl.emptyTxt, a_useSymbolicInitialization);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("const int useSymbolicInitialization = "));
  out_txt := Tpl.writeText(out_txt, l_useSymbolicInitializationToInt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("; /* "));
  out_txt := Tpl.writeStr(out_txt, Tpl.booleanString(a_useSymbolicInitialization));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       " */\n",
                                       "const int useHomotopy = "
                                   }, false));
  out_txt := Tpl.writeText(out_txt, l_useHomotopyToInt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("; /* "));
  out_txt := Tpl.writeStr(out_txt, Tpl.booleanString(a_useHomotopy));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       " */\n",
                                       "int functionInitialEquations(DATA *data)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_errorMsg);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("data->simulationInfo.discreteCall = 1;\n"));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "data->simulationInfo.discreteCall = 0;\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialEquations;

protected function lm_162
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_162(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_162;

public function functionInlineEquations
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_inlineEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_body;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  System.tmpTickReset(0);
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_tmp, l_varDecls) := lm_162(l_body, a_inlineEquations, l_tmp, l_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int functionInlineEquations(DATA *data)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInlineEquations;

protected function lm_164
  input Tpl.Text in_txt;
  input list<tuple<Integer, tuple<DAE.Exp, DAE.Exp, DAE.Exp>>> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<tuple<Integer, tuple<DAE.Exp, DAE.Exp, DAE.Exp>>> rest;
      Tpl.Text a_varDecls;
      Integer i_id;
      DAE.Exp i_delayMax;
      DAE.Exp i_d;
      DAE.Exp i_e;
      Tpl.Text l_delayExpMax;
      Tpl.Text l_delayExp;
      Tpl.Text l_eRes;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_id, (i_e, i_d, i_delayMax)) :: rest,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_eRes, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, SimCode.contextSimulationNonDiscrete, l_preExp, a_varDecls);
        (l_delayExp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_d, SimCode.contextSimulationNonDiscrete, l_preExp, a_varDecls);
        (l_delayExpMax, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_delayMax, SimCode.contextSimulationNonDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("storeDelayedExpression(data, "));
        txt = Tpl.writeStr(txt, intString(i_id));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_eRes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", time, "));
        txt = Tpl.writeText(txt, l_delayExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_delayExpMax);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        (txt, a_varDecls) = lm_164(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_164;

protected function fun_165
  input Tpl.Text in_txt;
  input SimCode.DelayedExpression in_a_delayed;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_delayed, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<tuple<Integer, tuple<DAE.Exp, DAE.Exp, DAE.Exp>>> i_delayedExps;

    case ( txt,
           SimCode.DELAYED_EXPRESSIONS(delayedExps = i_delayedExps),
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_164(txt, i_delayedExps, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_165;

public function functionStoreDelayed
  input Tpl.Text txt;
  input SimCode.DelayedExpression a_delayed;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_storePart;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_storePart, l_varDecls) := fun_165(Tpl.emptyTxt, a_delayed, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "int function_storeDelayed(DATA *data)\n",
                                   "{\n",
                                   "  state mem_state;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_storePart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionStoreDelayed;

public function functionWhenReinitStatement
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_reinit, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Absyn.Info i_info;
      DAE.Exp i_level;
      DAE.Exp i_condition;
      DAE.ElementSource i_source;
      DAE.Exp i_message;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      list<DAE.Exp> ret_4;
      Absyn.Info ret_3;
      Tpl.Text l_msgVar;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.TERMINATE(message = i_message, source = i_source),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_message, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("FILE_INFO info = {"));
        ret_3 = DAEUtil.getElementSourceFileInfo(i_source);
        txt = infoArgs(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "omc_terminate(info, "
                                }, false));
        txt = Tpl.writeText(txt, l_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ASSERT(source = DAE.SOURCE(info = i_info), condition = i_condition, message = i_message, level = i_level),
           a_varDecls )
      equation
        ret_4 = List.fill(i_message, 1);
        (txt, a_varDecls) = assertCommon(txt, i_condition, ret_4, i_level, SimCode.contextSimulationDiscrete, a_varDecls, i_info);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end functionWhenReinitStatement;

protected function lm_168
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("|| ("));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !$P$PRE"));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* edge */)"));
        txt = Tpl.popBlock(txt);
        txt = lm_168(txt, rest);
      then txt;
  end match;
end lm_168;

protected function fun_169
  input Tpl.Text in_txt;
  input Boolean in_a_initialCall;
  input Tpl.Text in_a_varDecls;
  input list<BackendDAE.WhenOperator> in_a_reinits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_initialCall, in_a_varDecls, in_a_reinits)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<BackendDAE.WhenOperator> a_reinits;

    case ( txt,
           true,
           a_varDecls,
           a_reinits )
      equation
        (txt, a_varDecls) = functionWhenReinitStatementThen(txt, true, a_reinits, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* nothing to do */"));
      then (txt, a_varDecls);
  end match;
end fun_169;

protected function fun_170
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_a_reinits;
  input Tpl.Text in_a_ifthen;
  input Tpl.Text in_a_helpIf;
  input Tpl.Text in_a_initial__assign;
  input Integer in_a_int;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_reinits, in_a_ifthen, in_a_helpIf, in_a_initial__assign, in_a_int)
    local
      Tpl.Text txt;
      Tpl.Text a_ifthen;
      Tpl.Text a_helpIf;
      Tpl.Text a_initial__assign;
      Integer a_int;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_ifthen,
           a_helpIf,
           a_initial__assign,
           a_int )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* for whenclause index "));
        txt = Tpl.writeStr(txt, intString(a_int));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "if(initial())\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_initial__assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "else if(0"
                                }, false));
        txt = Tpl.writeText(txt, a_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_ifthen);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_170;

public function genreinits
  input Tpl.Text in_txt;
  input SimCode.SimWhenClause in_a_whenClauses;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_int;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_whenClauses, in_a_varDecls, in_a_int)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Integer a_int;
      Boolean i_initialCall;
      list<BackendDAE.WhenOperator> i_reinits;
      list<DAE.ComponentRef> i_conditions;
      Tpl.Text l_initial__assign;
      Tpl.Text l_ifthen;
      Tpl.Text l_helpIf;

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(conditions = i_conditions, reinits = i_reinits, initialCall = i_initialCall),
           a_varDecls,
           a_int )
      equation
        l_helpIf = lm_168(Tpl.emptyTxt, i_conditions);
        (l_ifthen, a_varDecls) = functionWhenReinitStatementThen(Tpl.emptyTxt, false, i_reinits, a_varDecls);
        (l_initial__assign, a_varDecls) = fun_169(Tpl.emptyTxt, i_initialCall, a_varDecls, i_reinits);
        txt = fun_170(txt, i_reinits, l_ifthen, l_helpIf, l_initial__assign, a_int);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end match;
end genreinits;

protected function fun_172
  input Tpl.Text in_txt;
  input DAE.Type in_mArg;
  input DAE.ComponentRef in_a_stateVar;
  input Tpl.Text in_a_val;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stateVar, in_a_val)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_stateVar;
      Tpl.Text a_val;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           a_stateVar,
           a_val )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_real_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_stateVar,
           a_val )
      equation
        txt = cref(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_172;

protected function fun_173
  input Tpl.Text in_txt;
  input Boolean in_a_initialCall;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialCall)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.needToIterate = 1;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_173;

protected function lm_174
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        (txt, a_varDecls, a_preExp) = lm_174(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_174;

protected function fun_175
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input Boolean in_a_initialCall;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_reinit, in_a_initialCall, in_a_varDecls)
    local
      Tpl.Text txt;
      Boolean a_initialCall;
      Tpl.Text a_varDecls;
      Absyn.Path i_functionName;
      list<DAE.Exp> i_functionArgs;
      Absyn.Info i_info;
      DAE.Exp i_level;
      DAE.Exp i_condition;
      DAE.ElementSource i_source;
      DAE.Exp i_message;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_funName;
      Tpl.Text l_argStr;
      list<DAE.Exp> ret_7;
      Absyn.Info ret_6;
      Tpl.Text l_msgVar;
      Tpl.Text l_needToIterate;
      DAE.Type ret_3;
      Tpl.Text l_lhs;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_initialCall,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        ret_3 = ComponentReference.crefLastType(i_stateVar);
        l_lhs = fun_172(Tpl.emptyTxt, ret_3, i_stateVar, l_val);
        l_needToIterate = fun_173(Tpl.emptyTxt, a_initialCall);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("INFO1(LOG_EVENTS, \"|        | reinit "));
        txt = cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  = %f\", "));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_lhs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_needToIterate);
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.TERMINATE(message = i_message, source = i_source),
           _,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_message, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("FILE_INFO info = {"));
        ret_6 = DAEUtil.getElementSourceFileInfo(i_source);
        txt = infoArgs(txt, ret_6);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "omc_terminate(info, "
                                }, false));
        txt = Tpl.writeText(txt, l_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ASSERT(source = DAE.SOURCE(info = i_info), condition = i_condition, message = i_message, level = i_level),
           _,
           a_varDecls )
      equation
        ret_7 = List.fill(i_message, 1);
        (txt, a_varDecls) = assertCommon(txt, i_condition, ret_7, i_level, SimCode.contextSimulationDiscrete, a_varDecls, i_info);
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.NORETCALL(functionArgs = i_functionArgs, functionName = i_functionName),
           _,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_argStr, a_varDecls, l_preExp) = lm_174(Tpl.emptyTxt, i_functionArgs, a_varDecls, l_preExp);
        l_funName = underscorePath(Tpl.emptyTxt, i_functionName);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omc_"));
        txt = Tpl.writeText(txt, l_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData"));
        txt = Tpl.writeText(txt, l_argStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_175;

protected function lm_176
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_items;
  input Boolean in_a_initialCall;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_initialCall, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.WhenOperator> rest;
      Boolean a_initialCall;
      Tpl.Text a_varDecls;
      BackendDAE.WhenOperator i_reinit;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_reinit :: rest,
           a_initialCall,
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_175(txt, i_reinit, a_initialCall, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_176(txt, rest, a_initialCall, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_176;

public function functionWhenReinitStatementThen
  input Tpl.Text txt;
  input Boolean a_initialCall;
  input list<BackendDAE.WhenOperator> a_reinits;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_body;
algorithm
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, out_a_varDecls) := lm_176(l_body, a_reinits, a_initialCall, a_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.writeText(txt, l_body);
end functionWhenReinitStatementThen;

protected function lm_178
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input Option<HpcOmScheduler.ScheduleSimCode> in_a_hpcOmScheduleOpt;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_hpcOmScheduleOpt, in_a_name)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Option<HpcOmScheduler.ScheduleSimCode> a_hpcOmScheduleOpt;
      String a_name;
      Integer x_i0;
      list<SimCode.SimEqSystem> i_eq;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_hpcOmScheduleOpt,
           a_name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = functionXXX_system_HPCOM(txt, i_eq, a_name, x_i0, a_hpcOmScheduleOpt);
        txt = Tpl.nextIter(txt);
        txt = lm_178(txt, rest, a_hpcOmScheduleOpt, a_name);
      then txt;
  end match;
end lm_178;

protected function lm_179
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      String a_name;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_system"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.nextIter(txt);
        txt = lm_179(txt, rest, a_name);
      then txt;
  end match;
end lm_179;

protected function fun_180
  input Tpl.Text in_txt;
  input Integer in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dynamic"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static"));
      then txt;
  end match;
end fun_180;

protected function fun_181
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer ret_0;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp parallel for private(id) schedule("));
        ret_0 = Config.noProc();
        txt = fun_180(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_181;

protected function fun_182
  input Tpl.Text in_txt;
  input Integer in_mArg;
  input Tpl.Text in_a_varDecls;
  input list<list<SimCode.SimEqSystem>> in_a_eqs;
  input Tpl.Text in_a_funcs;
  input String in_a_name;
  input Tpl.Text in_a_loop;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_loop;
algorithm
  (out_txt, out_a_varDecls, out_a_loop) :=
  match(in_txt, in_mArg, in_a_varDecls, in_a_eqs, in_a_funcs, in_a_name, in_a_loop)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<list<SimCode.SimEqSystem>> a_eqs;
      Tpl.Text a_funcs;
      String a_name;
      Tpl.Text a_loop;
      Integer i_nFuncs;
      Boolean ret_2;
      Tpl.Text l_head;
      Tpl.Text l_funcNames;

    case ( txt,
           0,
           a_varDecls,
           _,
           _,
           a_name,
           a_loop )
      equation
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("/* no "));
        a_loop = Tpl.writeStr(a_loop, a_name);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING(" systems */"));
      then (txt, a_varDecls, a_loop);

    case ( txt,
           1,
           a_varDecls,
           _,
           a_funcs,
           a_name,
           a_loop )
      equation
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("function"));
        a_loop = Tpl.writeStr(a_loop, a_name);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("_system0(data);"));
        txt = Tpl.writeText(txt, a_funcs);
      then (txt, a_varDecls, a_loop);

    case ( txt,
           i_nFuncs,
           a_varDecls,
           a_eqs,
           a_funcs,
           a_name,
           a_loop )
      equation
        l_funcNames = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_funcNames = lm_179(l_funcNames, a_eqs, a_name);
        l_funcNames = Tpl.popIter(l_funcNames);
        ret_2 = Flags.isSet(Flags.OPENMP);
        l_head = fun_181(Tpl.emptyTxt, ret_2);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("int id;"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_loop = Tpl.writeText(a_loop, l_head);
        a_loop = Tpl.softNewLine(a_loop);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("for(id=0; id<"));
        a_loop = Tpl.writeStr(a_loop, intString(i_nFuncs));
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_LINE("; id++) {\n"));
        a_loop = Tpl.pushBlock(a_loop, Tpl.BT_INDENT(2));
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("function"));
        a_loop = Tpl.writeStr(a_loop, a_name);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_LINE("_systems[id](data);\n"));
        a_loop = Tpl.popBlock(a_loop);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("}"));
        txt = Tpl.writeText(txt, a_funcs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static void (*function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_systems["));
        txt = Tpl.writeStr(txt, intString(i_nFuncs));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("])(DATA *) = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_funcNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then (txt, a_varDecls, a_loop);
  end match;
end fun_182;

public function functionXXX_systems_HPCOM
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_eqs;
  input String a_name;
  input Tpl.Text a_loop;
  input Tpl.Text a_varDecls;
  input Option<HpcOmScheduler.ScheduleSimCode> a_hpcOmScheduleOpt;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_loop;
  output Tpl.Text out_a_varDecls;
protected
  Integer ret_1;
  Tpl.Text l_funcs;
algorithm
  l_funcs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_funcs := lm_178(l_funcs, a_eqs, a_hpcOmScheduleOpt, a_name);
  l_funcs := Tpl.popIter(l_funcs);
  ret_1 := listLength(a_eqs);
  (out_txt, out_a_varDecls, out_a_loop) := fun_182(txt, ret_1, a_varDecls, a_eqs, l_funcs, a_name, a_loop);
end functionXXX_systems_HPCOM;

protected function lm_184
  input Tpl.Text in_txt;
  input list<list<Integer>> in_items;
  input String in_a_name;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<list<Integer>> rest;
      String a_name;
      list<SimCode.SimEqSystem> a_derivativEquations;
      list<Integer> i_eqs;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_eqs :: rest,
           a_name,
           a_derivativEquations )
      equation
        txt = functionXXX_system0_HPCOM_Level(txt, a_derivativEquations, a_name, i_eqs);
        txt = Tpl.nextIter(txt);
        txt = lm_184(txt, rest, a_name, a_derivativEquations);
      then txt;
  end match;
end lm_184;

protected function lm_185
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_idx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_idx :: rest )
      equation
        txt = function_HPCOM_createLock(txt, i_idx);
        txt = Tpl.nextIter(txt);
        txt = lm_185(txt, rest);
      then txt;
  end match;
end lm_185;

protected function lm_186
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_idx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_idx :: rest )
      equation
        txt = function_HPCOM_initializeLock(txt, i_idx);
        txt = Tpl.nextIter(txt);
        txt = lm_186(txt, rest);
      then txt;
  end match;
end lm_186;

protected function lm_187
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_idx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_idx :: rest )
      equation
        txt = function_HPCOM_assignLock(txt, i_idx);
        txt = Tpl.nextIter(txt);
        txt = lm_187(txt, rest);
      then txt;
  end match;
end lm_187;

protected function fun_188
  input Tpl.Text in_txt;
  input Option<HpcOmScheduler.ScheduleSimCode> in_a_hpcOmScheduleOpt;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;
  input String in_a_name;
  input Integer in_a_n;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmScheduleOpt, in_a_derivativEquations, in_a_name, in_a_n)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_derivativEquations;
      String a_name;
      Integer a_n;
      list<String> i_hpcOmSchedule_lockIdc;
      list<list<HpcOmScheduler.Task>> i_hpcOmSchedule_threadTasks;
      list<list<Integer>> i_hpcOmSchedule_eqsOfLevels;
      Tpl.Text l_assignLocks;
      Tpl.Text l_initlocks;
      Tpl.Text l_locks;
      Tpl.Text l_taskEqs;
      Tpl.Text l_odeEqs;

    case ( txt,
           SOME(HpcOmScheduler.LEVELSCHEDULESC(eqsOfLevels = i_hpcOmSchedule_eqsOfLevels)),
           a_derivativEquations,
           a_name,
           a_n )
      equation
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_odeEqs = lm_184(l_odeEqs, i_hpcOmSchedule_eqsOfLevels, a_name, a_derivativEquations);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static void function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_system"));
        txt = Tpl.writeStr(txt, intString(a_n));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data)\n",
                                    "{\n",
                                    "  state mem_state;\n",
                                    "  mem_state = get_memory_state();\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_odeEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("restore_memory_state(mem_state);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           SOME(HpcOmScheduler.THREADSCHEDULESC(threadTasks = i_hpcOmSchedule_threadTasks, lockIdc = i_hpcOmSchedule_lockIdc)),
           a_derivativEquations,
           a_name,
           a_n )
      equation
        l_taskEqs = functionXXX_system0_HPCOM_Thread(Tpl.emptyTxt, a_derivativEquations, a_name, i_hpcOmSchedule_threadTasks);
        l_locks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_locks = lm_185(l_locks, i_hpcOmSchedule_lockIdc);
        l_locks = Tpl.popIter(l_locks);
        l_initlocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_initlocks = lm_186(l_initlocks, i_hpcOmSchedule_lockIdc);
        l_initlocks = Tpl.popIter(l_initlocks);
        l_assignLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_assignLocks = lm_187(l_assignLocks, i_hpcOmSchedule_lockIdc);
        l_assignLocks = Tpl.popIter(l_assignLocks);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "static int initialized = 0;\n",
                                    "static void function"
                                }, false));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_system"));
        txt = Tpl.writeStr(txt, intString(a_n));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data)\n",
                                    "{\n",
                                    "  state mem_state;\n",
                                    "  mem_state = get_memory_state();\n",
                                    "  omp_set_dynamic(0);\n",
                                    "  //create locks\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_locks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(!initialized)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_initlocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//set locks\n"
                                }, true));
        txt = Tpl.writeText(txt, l_assignLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "initialized = 1;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_taskEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("restore_memory_state(mem_state);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_188;

public function functionXXX_system_HPCOM
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input Integer a_n;
  input Option<HpcOmScheduler.ScheduleSimCode> a_hpcOmScheduleOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_188(txt, a_hpcOmScheduleOpt, a_derivativEquations, a_name, a_n);
end functionXXX_system_HPCOM;

protected function lm_190
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<Integer> rest;
      list<SimCode.SimEqSystem> a_derivativEquations;
      Integer i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_derivativEquations )
      equation
        txt = equationNamesHPCOM_(txt, i_eq, a_derivativEquations, SimCode.contextSimulationNonDiscrete);
        txt = Tpl.nextIter(txt);
        txt = lm_190(txt, rest, a_derivativEquations);
      then txt;
  end match;
end lm_190;

public function functionXXX_system0_HPCOM_Level
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input list<Integer> a_eqsOfLevel;

  output Tpl.Text out_txt;
protected
  Integer ret_1;
  Tpl.Text l_odeEqs;
algorithm
  l_odeEqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_odeEqs := lm_190(l_odeEqs, a_eqsOfLevel, a_derivativEquations);
  l_odeEqs := Tpl.popIter(l_odeEqs);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp parallel sections num_threads("));
  ret_1 := Flags.getConfigInt(Flags.NUM_PROC);
  out_txt := Tpl.writeStr(out_txt, intString(ret_1));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ")\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(3));
  out_txt := Tpl.writeText(out_txt, l_odeEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionXXX_system0_HPCOM_Level;

protected function lm_192
  input Tpl.Text in_txt;
  input list<list<HpcOmScheduler.Task>> in_items;
  input String in_a_name;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<list<HpcOmScheduler.Task>> rest;
      String a_name;
      list<SimCode.SimEqSystem> a_derivativEquations;
      list<HpcOmScheduler.Task> i_tt;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_tt :: rest,
           a_name,
           a_derivativEquations )
      equation
        txt = functionXXX_system0_HPCOM_Thread0(txt, a_derivativEquations, a_name, i_tt);
        txt = Tpl.nextIter(txt);
        txt = lm_192(txt, rest, a_name, a_derivativEquations);
      then txt;
  end match;
end lm_192;

public function functionXXX_system0_HPCOM_Thread
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input list<list<HpcOmScheduler.Task>> a_threadTasks;

  output Tpl.Text out_txt;
protected
  Integer ret_1;
  Tpl.Text l_odeEqs;
algorithm
  l_odeEqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_odeEqs := lm_192(l_odeEqs, a_threadTasks, a_name, a_derivativEquations);
  l_odeEqs := Tpl.popIter(l_odeEqs);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp parallel sections num_threads("));
  ret_1 := Flags.getConfigInt(Flags.NUM_PROC);
  out_txt := Tpl.writeStr(out_txt, intString(ret_1));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ")\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(3));
  out_txt := Tpl.writeText(out_txt, l_odeEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionXXX_system0_HPCOM_Thread;

protected function lm_194
  input Tpl.Text in_txt;
  input list<HpcOmScheduler.Task> in_items;
  input String in_a_name;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<HpcOmScheduler.Task> rest;
      String a_name;
      list<SimCode.SimEqSystem> a_derivativEquations;
      HpcOmScheduler.Task i_tt;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_tt :: rest,
           a_name,
           a_derivativEquations )
      equation
        txt = function_HPCOM_Task(txt, a_derivativEquations, a_name, i_tt);
        txt = Tpl.nextIter(txt);
        txt = lm_194(txt, rest, a_name, a_derivativEquations);
      then txt;
  end match;
end lm_194;

public function functionXXX_system0_HPCOM_Thread0
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input list<HpcOmScheduler.Task> a_threadTaskList;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_threadTasks;
algorithm
  l_threadTasks := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_threadTasks := lm_194(l_threadTasks, a_threadTaskList, a_name, a_derivativEquations);
  l_threadTasks := Tpl.popIter(l_threadTasks);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "#pragma omp section\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_threadTasks);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionXXX_system0_HPCOM_Thread0;

protected function lm_196
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<Integer> rest;
      list<SimCode.SimEqSystem> a_derivativEquations;
      Integer i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_derivativEquations )
      equation
        txt = equationNamesHPCOM_Thread_(txt, i_eq, a_derivativEquations, SimCode.contextSimulationNonDiscrete);
        txt = Tpl.nextIter(txt);
        txt = lm_196(txt, rest, a_derivativEquations);
      then txt;
  end match;
end lm_196;

protected function fun_197
  input Tpl.Text in_txt;
  input HpcOmScheduler.Task in_a_iTask;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iTask, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_derivativEquations;
      String i_task_lockId;
      Integer i_task_index;
      list<Integer> i_task_eqIdc;
      Tpl.Text l_odeEqs;

    case ( txt,
           HpcOmScheduler.CALCTASK(eqIdc = i_task_eqIdc, index = i_task_index),
           a_derivativEquations )
      equation
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_odeEqs = lm_196(l_odeEqs, i_task_eqIdc, a_derivativEquations);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Task "));
        txt = Tpl.writeStr(txt, intString(i_task_index));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_odeEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// End Task "));
        txt = Tpl.writeStr(txt, intString(i_task_index));
      then txt;

    case ( txt,
           HpcOmScheduler.ASSIGNLOCKTASK(lockId = i_task_lockId),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//Assign lock "));
        txt = Tpl.writeStr(txt, i_task_lockId);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omp_set_lock(&lock_"));
        txt = Tpl.writeStr(txt, i_task_lockId);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           HpcOmScheduler.RELEASELOCKTASK(lockId = i_task_lockId),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//Release lock "));
        txt = Tpl.writeStr(txt, i_task_lockId);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omp_unset_lock(&lock_"));
        txt = Tpl.writeStr(txt, i_task_lockId);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_197;

public function function_HPCOM_Task
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input HpcOmScheduler.Task a_iTask;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_197(txt, a_iTask, a_derivativEquations);
end function_HPCOM_Task;

public function function_HPCOM_initializeLock
  input Tpl.Text txt;
  input String a_lockIdx;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("omp_init_lock(&lock_"));
  out_txt := Tpl.writeStr(out_txt, a_lockIdx);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(");"));
end function_HPCOM_initializeLock;

public function function_HPCOM_createLock
  input Tpl.Text txt;
  input String a_lockIdx;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("static omp_lock_t lock_"));
  out_txt := Tpl.writeStr(out_txt, a_lockIdx);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(";"));
end function_HPCOM_createLock;

public function function_HPCOM_assignLock
  input Tpl.Text txt;
  input String a_lockIdx;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("omp_set_lock(&lock_"));
  out_txt := Tpl.writeStr(out_txt, a_lockIdx);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(");"));
end function_HPCOM_assignLock;

protected function fun_202
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_mArg;
  input Integer in_a_idx;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_idx, in_a_derivativEquations)
    local
      Tpl.Text txt;
      Integer a_idx;
      list<SimCode.SimEqSystem> a_derivativEquations;
      SimCode.SimEqSystem ret_1;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_idx,
           a_derivativEquations )
      equation
        ret_1 = HpcOmSimCode.getSimCodeEqByIndex(a_derivativEquations, a_idx);
        l_ix = equationIndex(Tpl.emptyTxt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma omp section\n",
                                    "{\n",
                                    "#ifdef _OMC_MEASURE_TIME\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQEXT("));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endif\n",
                                    "eqFunction_"
                                }, false));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(data);\n",
                                    "#ifdef _OMC_MEASURE_TIME\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQEXT("));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endif\n",
                                    "}"
                                }, false));
      then txt;
  end match;
end fun_202;

protected function fun_203
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_mArg;
  input Integer in_a_idx;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_idx, in_a_derivativEquations)
    local
      Tpl.Text txt;
      Integer a_idx;
      list<SimCode.SimEqSystem> a_derivativEquations;
      SimCode.SimEqSystem ret_1;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_idx,
           a_derivativEquations )
      equation
        ret_1 = HpcOmSimCode.getSimCodeEqByIndex(a_derivativEquations, a_idx);
        l_ix = equationIndex(Tpl.emptyTxt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("#ifdef _OMC_MEASURE_TIME\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQEXT("));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endif\n",
                                    "eqFunction_"
                                }, false));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(data);\n",
                                    "#ifdef _OMC_MEASURE_TIME\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQEXT("));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#endif"));
      then txt;
  end match;
end fun_203;

protected function fun_204
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Integer in_a_idx;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_idx, in_a_derivativEquations)
    local
      Tpl.Text txt;
      Integer a_idx;
      list<SimCode.SimEqSystem> a_derivativEquations;
      SimCode.SimEqSystem ret_1;
      SimCode.SimEqSystem ret_0;

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = true),
           a_idx,
           a_derivativEquations )
      equation
        ret_0 = HpcOmSimCode.getSimCodeEqByIndex(a_derivativEquations, a_idx);
        txt = fun_202(txt, ret_0, a_idx, a_derivativEquations);
      then txt;

    case ( txt,
           _,
           a_idx,
           a_derivativEquations )
      equation
        ret_1 = HpcOmSimCode.getSimCodeEqByIndex(a_derivativEquations, a_idx);
        txt = fun_203(txt, ret_1, a_idx, a_derivativEquations);
      then txt;
  end match;
end fun_204;

public function equationNamesHPCOM_Thread_
  input Tpl.Text txt;
  input Integer a_idx;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_204(txt, a_context, a_idx, a_derivativEquations);
end equationNamesHPCOM_Thread_;

protected function fun_206
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_mArg;
  input Integer in_a_idx;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_idx, in_a_derivativEquations)
    local
      Tpl.Text txt;
      Integer a_idx;
      list<SimCode.SimEqSystem> a_derivativEquations;
      SimCode.SimEqSystem ret_1;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_idx,
           a_derivativEquations )
      equation
        ret_1 = HpcOmSimCode.getSimCodeEqByIndex(a_derivativEquations, a_idx);
        l_ix = equationIndex(Tpl.emptyTxt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma omp section\n",
                                    "{\n",
                                    "    #ifdef _OMC_MEASURE_TIME\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQEXT("));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    #endif\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("eqFunction_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(data);\n",
                                    "#ifdef _OMC_MEASURE_TIME\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQEXT("));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("#endif\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_206;

protected function fun_207
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_mArg;
  input Integer in_a_idx;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_idx, in_a_derivativEquations)
    local
      Tpl.Text txt;
      Integer a_idx;
      list<SimCode.SimEqSystem> a_derivativEquations;
      SimCode.SimEqSystem ret_1;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_idx,
           a_derivativEquations )
      equation
        ret_1 = HpcOmSimCode.getSimCodeEqByIndex(a_derivativEquations, a_idx);
        l_ix = equationIndex(Tpl.emptyTxt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma omp section\n",
                                    "{\n",
                                    "    #ifdef _OMC_MEASURE_TIME\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQEXT("));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    #endif\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("eqFunction_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(data);\n",
                                    "#ifdef _OMC_MEASURE_TIME\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQEXT("));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("#endif\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_207;

protected function fun_208
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Integer in_a_idx;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_idx, in_a_derivativEquations)
    local
      Tpl.Text txt;
      Integer a_idx;
      list<SimCode.SimEqSystem> a_derivativEquations;
      SimCode.SimEqSystem ret_1;
      SimCode.SimEqSystem ret_0;

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = true),
           a_idx,
           a_derivativEquations )
      equation
        ret_0 = HpcOmSimCode.getSimCodeEqByIndex(a_derivativEquations, a_idx);
        txt = fun_206(txt, ret_0, a_idx, a_derivativEquations);
      then txt;

    case ( txt,
           _,
           a_idx,
           a_derivativEquations )
      equation
        ret_1 = HpcOmSimCode.getSimCodeEqByIndex(a_derivativEquations, a_idx);
        txt = fun_207(txt, ret_1, a_idx, a_derivativEquations);
      then txt;
  end match;
end fun_208;

public function equationNamesHPCOM_
  input Tpl.Text txt;
  input Integer a_idx;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_208(txt, a_context, a_idx, a_derivativEquations);
end equationNamesHPCOM_;

protected function lm_210
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = equationNames_(txt, i_eq, SimCode.contextSimulationNonDiscrete);
        txt = Tpl.nextIter(txt);
        txt = lm_210(txt, rest);
      then txt;
  end match;
end lm_210;

public function functionXXX_system
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input Integer a_n;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_odeEqs;
algorithm
  l_odeEqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_odeEqs := lm_210(l_odeEqs, a_derivativEquations);
  l_odeEqs := Tpl.popIter(l_odeEqs);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("static void function"));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_system"));
  out_txt := Tpl.writeStr(out_txt, intString(a_n));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n",
                                       "  state mem_state;\n",
                                       "  mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_odeEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("restore_memory_state(mem_state);\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionXXX_system;

protected function lm_212
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      String a_name;
      Integer x_i0;
      list<SimCode.SimEqSystem> i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = functionXXX_system(txt, i_eq, a_name, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_212(txt, rest, a_name);
      then txt;
  end match;
end lm_212;

protected function lm_213
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      String a_name;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_system"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.nextIter(txt);
        txt = lm_213(txt, rest, a_name);
      then txt;
  end match;
end lm_213;

protected function fun_214
  input Tpl.Text in_txt;
  input Integer in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dynamic"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static"));
      then txt;
  end match;
end fun_214;

protected function fun_215
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer ret_0;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp parallel for private(id) schedule("));
        ret_0 = Config.noProc();
        txt = fun_214(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_215;

protected function fun_216
  input Tpl.Text in_txt;
  input Integer in_mArg;
  input Tpl.Text in_a_varDecls;
  input list<list<SimCode.SimEqSystem>> in_a_eqs;
  input Tpl.Text in_a_funcs;
  input String in_a_name;
  input Tpl.Text in_a_loop;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_loop;
algorithm
  (out_txt, out_a_varDecls, out_a_loop) :=
  match(in_txt, in_mArg, in_a_varDecls, in_a_eqs, in_a_funcs, in_a_name, in_a_loop)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<list<SimCode.SimEqSystem>> a_eqs;
      Tpl.Text a_funcs;
      String a_name;
      Tpl.Text a_loop;
      Integer i_nFuncs;
      Boolean ret_2;
      Tpl.Text l_head;
      Tpl.Text l_funcNames;

    case ( txt,
           0,
           a_varDecls,
           _,
           _,
           a_name,
           a_loop )
      equation
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("/* no "));
        a_loop = Tpl.writeStr(a_loop, a_name);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING(" systems */"));
      then (txt, a_varDecls, a_loop);

    case ( txt,
           1,
           a_varDecls,
           _,
           a_funcs,
           a_name,
           a_loop )
      equation
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("function"));
        a_loop = Tpl.writeStr(a_loop, a_name);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("_system0(data);"));
        txt = Tpl.writeText(txt, a_funcs);
      then (txt, a_varDecls, a_loop);

    case ( txt,
           i_nFuncs,
           a_varDecls,
           a_eqs,
           a_funcs,
           a_name,
           a_loop )
      equation
        l_funcNames = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_funcNames = lm_213(l_funcNames, a_eqs, a_name);
        l_funcNames = Tpl.popIter(l_funcNames);
        ret_2 = Flags.isSet(Flags.OPENMP);
        l_head = fun_215(Tpl.emptyTxt, ret_2);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("int id;"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_loop = Tpl.writeText(a_loop, l_head);
        a_loop = Tpl.softNewLine(a_loop);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("for(id=0; id<"));
        a_loop = Tpl.writeStr(a_loop, intString(i_nFuncs));
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_LINE("; id++) {\n"));
        a_loop = Tpl.pushBlock(a_loop, Tpl.BT_INDENT(2));
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("function"));
        a_loop = Tpl.writeStr(a_loop, a_name);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_LINE("_systems[id](data);\n"));
        a_loop = Tpl.popBlock(a_loop);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("}"));
        txt = Tpl.writeText(txt, a_funcs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static void (*function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_systems["));
        txt = Tpl.writeStr(txt, intString(i_nFuncs));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("])(DATA *) = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_funcNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then (txt, a_varDecls, a_loop);
  end match;
end fun_216;

public function functionXXX_systems
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_eqs;
  input String a_name;
  input Tpl.Text a_loop;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_loop;
  output Tpl.Text out_a_varDecls;
protected
  Integer ret_1;
  Tpl.Text l_funcs;
algorithm
  l_funcs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_funcs := lm_212(l_funcs, a_eqs, a_name);
  l_funcs := Tpl.popIter(l_funcs);
  ret_1 := listLength(a_eqs);
  (out_txt, out_a_varDecls, out_a_loop) := fun_216(txt, ret_1, a_varDecls, a_eqs, l_funcs, a_name, a_loop);
end functionXXX_systems;

protected function fun_218
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Option<HpcOmScheduler.ScheduleSimCode> in_a_hpcOmSchedule;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_loop;
  input list<list<SimCode.SimEqSystem>> in_a_derivativEquations;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_loop;
algorithm
  (out_txt, out_a_varDecls, out_a_loop) :=
  match(in_txt, in_mArg, in_a_hpcOmSchedule, in_a_varDecls, in_a_loop, in_a_derivativEquations)
    local
      Tpl.Text txt;
      Option<HpcOmScheduler.ScheduleSimCode> a_hpcOmSchedule;
      Tpl.Text a_varDecls;
      Tpl.Text a_loop;
      list<list<SimCode.SimEqSystem>> a_derivativEquations;

    case ( txt,
           false,
           _,
           a_varDecls,
           a_loop,
           a_derivativEquations )
      equation
        (txt, a_loop, a_varDecls) = functionXXX_systems(txt, a_derivativEquations, "ODE", a_loop, a_varDecls);
      then (txt, a_varDecls, a_loop);

    case ( txt,
           _,
           a_hpcOmSchedule,
           a_varDecls,
           a_loop,
           a_derivativEquations )
      equation
        (txt, a_loop, a_varDecls) = functionXXX_systems_HPCOM(txt, a_derivativEquations, "ODE", a_loop, a_varDecls, a_hpcOmSchedule);
      then (txt, a_varDecls, a_loop);
  end match;
end fun_218;

protected function lm_219
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls2;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls2) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls2)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls2;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls2 )
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        (txt, a_varDecls2, a_tmp) = equation_(txt, i_eq, SimCode.contextInlineSolver, a_varDecls2, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls2) = lm_219(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);
  end match;
end lm_219;

protected function lm_220
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls2;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls2) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls2)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls2;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           a_tmp,
           a_varDecls2 )
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           i_eqs :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_tmp, a_varDecls2) = lm_219(txt, i_eqs, a_tmp, a_varDecls2);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls2) = lm_220(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);
  end match;
end lm_220;

protected function fun_221
  input Tpl.Text in_txt;
  input Integer in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer ret_0;

    case ( txt,
           0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omp_get_max_threads()"));
      then txt;

    case ( txt,
           _ )
      equation
        ret_0 = Config.noProc();
        txt = Tpl.writeStr(txt, intString(ret_0));
      then txt;
  end match;
end fun_221;

protected function fun_222
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_stateContPartInline;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stateContPartInline, in_a_varDecls2)
    local
      Tpl.Text txt;
      Tpl.Text a_stateContPartInline;
      Tpl.Text a_varDecls2;

    case ( txt,
           "inline-euler",
           a_stateContPartInline,
           a_varDecls2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*\n",
                                    " * we need to access the inline define that we compiled the simulation with\n",
                                    " * from the simulation runtime.\n",
                                    " */\n",
                                    "int functionODE_inline(DATA* data, double stepSize)\n",
                                    "{\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_varDecls2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "data->simulationInfo.discreteCall = 0;\n",
                                    "mem_state = get_memory_state();\n",
                                    "begin_inline();\n"
                                }, true));
        txt = Tpl.writeText(txt, a_stateContPartInline);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "end_inline();\n",
                                    "restore_memory_state(mem_state);\n",
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           "inline-rungekutta",
           a_stateContPartInline,
           a_varDecls2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*\n",
                                    " * we need to access the inline define that we compiled the simulation with\n",
                                    " * from the simulation runtime.\n",
                                    " */\n",
                                    "int functionODE_inline(DATA* data, double stepSize)\n",
                                    "{\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_varDecls2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "data->simulationInfo.discreteCall = 0;\n",
                                    "mem_state = get_memory_state();\n",
                                    "begin_inline();\n"
                                }, true));
        txt = Tpl.writeText(txt, a_stateContPartInline);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "end_inline();\n",
                                    "restore_memory_state(mem_state);\n",
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int functionODE_inline(DATA* data, double stepSize)\n",
                                    "{\n",
                                    "  return 0;\n",
                                    "}"
                                }, false));
      then txt;
  end match;
end fun_222;

public function functionODE
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_derivativEquations;
  input Tpl.Text a_method;
  input Option<HpcOmScheduler.ScheduleSimCode> a_hpcOmSchedule;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_method;
protected
  String str_8;
  Integer ret_7;
  Tpl.Text l_stateContPartInline;
  Tpl.Text l_tmp;
  Boolean ret_4;
  Tpl.Text l_systems;
  Tpl.Text l_loop;
  Tpl.Text l_varDecls;
  Tpl.Text l_varDecls2;
algorithm
  System.tmpTickReset(0);
  l_varDecls2 := Tpl.emptyTxt;
  l_varDecls := Tpl.emptyTxt;
  l_loop := Tpl.emptyTxt;
  ret_4 := Flags.isSet(Flags.HPCOM);
  (l_systems, l_varDecls, l_loop) := fun_218(Tpl.emptyTxt, ret_4, a_hpcOmSchedule, l_varDecls, l_loop, a_derivativEquations);
  l_tmp := Tpl.emptyTxt;
  l_stateContPartInline := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_stateContPartInline, l_tmp, l_varDecls2) := lm_220(l_stateContPartInline, a_derivativEquations, l_tmp, l_varDecls2);
  l_stateContPartInline := Tpl.popIter(l_stateContPartInline);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_systems);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "void function_initMemoryState()\n",
                                       "{\n",
                                       "#ifdef _OPENMP\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("push_memory_states("));
  ret_7 := Config.noProc();
  out_txt := fun_221(out_txt, ret_7);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ");\n",
                                       "get_thread_index = omp_get_thread_num;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#else\n",
                                       "  push_memory_states(1);\n",
                                       "#endif\n",
                                       "}\n",
                                       "\n",
                                       "int functionODE(DATA *data)\n",
                                       "{\n",
                                       "#ifdef _OMC_MEASURE_TIME\n",
                                       "  rt_tick(SIM_TIMER_FUNCTION_ODE);\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "state mem_state; /* We need to have separate memory pools for separate systems... */\n",
                                       "mem_state = get_memory_state();\n",
                                       "\n",
                                       "data->simulationInfo.discreteCall = 0;\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_loop);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("restore_memory_state(mem_state);\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#ifdef _OMC_MEASURE_TIME\n",
                                       "  rt_accumulate(SIM_TIMER_FUNCTION_ODE);\n",
                                       "#endif\n",
                                       "\n",
                                       "  return 0;\n",
                                       "}\n",
                                       "\n",
                                       "#include <simulation_inline_solver.h>\n",
                                       "const char *_omc_force_solver=_OMC_FORCE_SOLVER;\n",
                                       "const int inline_work_states_ndims=_OMC_SOLVER_WORK_STATES_NDIMS;\n"
                                   }, true));
  str_8 := Tpl.textString(a_method);
  out_txt := fun_222(out_txt, str_8, l_stateContPartInline, l_varDecls2);
  out_a_method := a_method;
end functionODE;

public function functionAlgebraic
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_algebraicEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_systems;
  Tpl.Text l_loop;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_loop := Tpl.emptyTxt;
  (l_systems, l_loop, l_varDecls) := functionXXX_systems(Tpl.emptyTxt, a_algebraicEquations, "Alg", l_loop, l_varDecls);
  out_txt := Tpl.writeText(txt, l_systems);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* for continuous time variables */\n",
                                       "int functionAlgebraics(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("data->simulationInfo.discreteCall = 0;\n"));
  out_txt := Tpl.writeText(out_txt, l_loop);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("return 0;\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAlgebraic;

protected function lm_225
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_225(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_225;

public function functionAliasEquation
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_removedEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_removedPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_removedPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_removedPart, l_tmp, l_varDecls) := lm_225(l_removedPart, a_removedEquations, l_tmp, l_varDecls);
  l_removedPart := Tpl.popIter(l_removedPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* for continuous time variables */\n",
                                       "int functionAliasEquations(DATA *data)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "data->simulationInfo.discreteCall = 0;\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_removedPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAliasEquation;

protected function lm_227
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_227(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_227;

protected function lm_228
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      SimCode.SimWhenClause i_when;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_when :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = genreinits(txt, i_when, a_varDecls, x_i0);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_228(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_228;

public function functionDAE
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<SimCode.SimWhenClause> a_whenClauses;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_reinit;
  Tpl.Text l_eqs;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqs, l_tmp, l_varDecls) := lm_227(l_eqs, a_allEquationsPlusWhen, l_tmp, l_varDecls);
  l_eqs := Tpl.popIter(l_eqs);
  l_reinit := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_reinit, l_varDecls) := lm_228(l_reinit, a_whenClauses, l_varDecls);
  l_reinit := Tpl.popIter(l_reinit);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int functionDAE(DATA *data)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "data->simulationInfo.needToIterate = 0;\n",
                                       "data->simulationInfo.discreteCall = 1;\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_eqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_reinit);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionDAE;

protected function lm_230
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      DAE.Exp i_relation__;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = ExpressionDump.printExpStr(i_relation__);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", "));
        txt = Tpl.nextIter(txt);
        txt = lm_230(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_230(txt, rest);
      then txt;
  end match;
end lm_230;

protected function fun_231
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;
  input Tpl.Text in_a_resDesc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_zeroCrossings, in_a_resDesc)
    local
      Tpl.Text txt;
      Tpl.Text a_resDesc;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *zeroCrossingDescription[1] = {\"empty\"};"));
      then txt;

    case ( txt,
           _,
           a_resDesc )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "const char *zeroCrossingDescription[] =\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_resDesc);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end match;
end fun_231;

public function functionZeroCrossing
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_desc;
  Tpl.Text l_resDesc;
  Tpl.Text l_zeroCrossingsCode;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_zeroCrossingsCode, l_varDecls) := zeroCrossingsTpl(Tpl.emptyTxt, a_zeroCrossings, l_varDecls);
  l_resDesc := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_resDesc := lm_230(l_resDesc, a_zeroCrossings);
  l_resDesc := Tpl.popIter(l_resDesc);
  l_desc := fun_231(Tpl.emptyTxt, a_zeroCrossings, l_resDesc);
  out_txt := Tpl.writeText(txt, l_desc);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "int function_ZeroCrossings(DATA *data, double *gout, double *t)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_zeroCrossingsCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionZeroCrossing;

protected function lm_233
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_relation__;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = zeroCrossingTpl(txt, x_i0, i_relation__, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_233(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_233(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_233;

public function zeroCrossingsTpl
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_233(out_txt, a_zeroCrossings, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end zeroCrossingsTpl;

protected function fun_235
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relation;
  input Integer in_a_index1;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_relation, in_a_index1, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_index1;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp2;
      DAE.Exp i_idx;
      DAE.Exp i_exp1;
      DAE.Exp i_exp;
      Tpl.Text txt_4;
      Tpl.Text l_e2;
      Tpl.Text l_indx;
      Tpl.Text l_e1;
      Tpl.Text l_preExp;

    case ( txt,
           (i_exp as DAE.RELATION(exp1 = _)),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextZeroCross, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", ("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")?1:-1);"));
      then (txt, a_varDecls);

    case ( txt,
           (i_exp1 as DAE.LBINARY(exp1 = _)),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", ("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")?1:-1);"));
      then (txt, a_varDecls);

    case ( txt,
           (i_exp1 as DAE.LUNARY(operator = _)),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("?1:-1);"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {_, _, _}),
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "integer"), expLst = {i_exp1, i_idx}),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, l_preExp, a_varDecls);
        (l_indx, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_idx, SimCode.contextZeroCross, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", (floor("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != floor(data->simulationInfo.mathEventsValuePre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]))?1:-1);"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "floor"), expLst = {i_exp1, i_idx}),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, l_preExp, a_varDecls);
        (l_indx, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_idx, SimCode.contextZeroCross, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", (floor("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != floor(data->simulationInfo.mathEventsValuePre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]))?1:-1);"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "ceil"), expLst = {i_exp1, i_idx}),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, l_preExp, a_varDecls);
        (l_indx, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_idx, SimCode.contextZeroCross, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", (ceil("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != ceil(data->simulationInfo.mathEventsValuePre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]))?1:-1);"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "div"), expLst = {i_exp1, i_exp2, i_idx}),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, l_preExp, a_varDecls);
        (l_e2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, SimCode.contextZeroCross, l_preExp, a_varDecls);
        (l_indx, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_idx, SimCode.contextZeroCross, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", (trunc("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != trunc(data->simulationInfo.mathEventsValuePre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]/data->simulationInfo.mathEventsValuePre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+1]))?1:-1);"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_index1,
           a_varDecls )
      equation
        txt_4 = Tpl.pushBlock(Tpl.emptyTxt, Tpl.BT_INDENT(1));
        txt_4 = Tpl.writeTok(txt_4, Tpl.ST_STRING("UNKNOWN ZERO CROSSING for "));
        txt_4 = Tpl.writeStr(txt_4, intString(a_index1));
        txt_4 = Tpl.popBlock(txt_4);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 2121, 11), Tpl.textString(txt_4));
      then (txt, a_varDecls);
  end match;
end fun_235;

public function zeroCrossingTpl
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_relation;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_235(txt, a_relation, a_index1, a_varDecls);
end zeroCrossingTpl;

protected function lm_237
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      DAE.Exp i_relation__;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = ExpressionDump.printExpStr(i_relation__);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", "));
        txt = Tpl.nextIter(txt);
        txt = lm_237(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_237(txt, rest);
      then txt;
  end match;
end lm_237;

protected function fun_238
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_a_relations;
  input Tpl.Text in_a_resDesc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_relations, in_a_resDesc)
    local
      Tpl.Text txt;
      Tpl.Text a_resDesc;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *relationDescription[1] = {\"empty\"};"));
      then txt;

    case ( txt,
           _,
           a_resDesc )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "const char *relationDescription[] =\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_resDesc);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end match;
end fun_238;

public function functionRelations
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_relations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_desc;
  Tpl.Text l_resDesc;
  Tpl.Text l_relationsCodeElse;
  Tpl.Text l_relationsCode;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_relationsCode, l_varDecls) := relationsTpl(Tpl.emptyTxt, a_relations, SimCode.contextZeroCross, l_varDecls);
  (l_relationsCodeElse, l_varDecls) := relationsTpl(Tpl.emptyTxt, a_relations, SimCode.contextOther, l_varDecls);
  l_resDesc := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_resDesc := lm_237(l_resDesc, a_relations);
  l_resDesc := Tpl.popIter(l_resDesc);
  l_desc := fun_238(Tpl.emptyTxt, a_relations, l_resDesc);
  out_txt := Tpl.writeText(txt, l_desc);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "int function_updateRelations(DATA *data, int evalforZeroCross)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n",
                                       "if(evalforZeroCross)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_relationsCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "else\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_relationsCodeElse);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionRelations;

protected function lm_240
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.Exp i_relation__;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest,
           a_varDecls,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = relationTpl(txt, x_i0, i_relation__, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_240(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_240(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_240;

public function relationsTpl
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_relations;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_240(out_txt, a_relations, a_varDecls, a_context);
  out_txt := Tpl.popIter(out_txt);
end relationsTpl;

protected function fun_242
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relation;
  input Integer in_a_index1;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_relation, in_a_index1, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_index1;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      Tpl.Text l_res;
      Tpl.Text l_preExp;

    case ( txt,
           (i_exp as DAE.RELATION(exp1 = _)),
           a_index1,
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_res, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.relations["));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_index1,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* UNKNOWN Relation for "));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then (txt, a_varDecls);
  end match;
end fun_242;

public function relationTpl
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_relation;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_242(txt, a_relation, a_index1, a_context, a_varDecls);
end relationTpl;

protected function fun_244
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_var;

    case ( txt,
           (i_var as DAE.CREF_QUAL(ident = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if("));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DEBUG2(LOG_EVENTS, \"discrete var changed: "));
        txt = CodegenUtil.crefStr(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" from "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" to "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "needToIterate = 1;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           (i_var as DAE.CREF_IDENT(ident = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if("));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DEBUG2(LOG_EVENTS, \"discrete var changed: "));
        txt = CodegenUtil.crefStr(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" from "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" to "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "needToIterate = 1;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_244;

protected function lm_245
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_244(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_245(txt, rest);
      then txt;
  end match;
end lm_245;

public function functionCheckForDiscreteChanges
  input Tpl.Text txt;
  input list<DAE.ComponentRef> a_discreteModelVars;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_changediscreteVars;
algorithm
  l_changediscreteVars := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_changediscreteVars := lm_245(l_changediscreteVars, a_discreteModelVars);
  l_changediscreteVars := Tpl.popIter(l_changediscreteVars);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "int checkForDiscreteChanges(DATA *data)\n",
                                   "{\n",
                                   "  int needToIterate = 0;\n",
                                   "\n",
                                   "  DEBUG(LOG_EVENTS, \"check for discrete changes\");\n",
                                   "  INDENT(LOG_EVENTS);\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_changediscreteVars);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "RELEASE(LOG_EVENTS);\n",
                                       "\n",
                                       "return needToIterate;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionCheckForDiscreteChanges;

protected function fun_247
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      Tpl.Text txt_0;

    case ( txt,
           "modelica_real",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%g"));
      then txt;

    case ( txt,
           "modelica_integer",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%ld"));
      then txt;

    case ( txt,
           "modelica_boolean",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%d"));
      then txt;

    case ( txt,
           "modelica_string",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%s"));
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Do not know what printf argument to give "));
        txt_0 = CodegenUtil.crefStr(txt_0, a_cr);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 2237, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_247;

public function crefToPrintfArg
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
protected
  String str_1;
  Tpl.Text txt_0;
algorithm
  txt_0 := crefType(Tpl.emptyTxt, a_cr);
  str_1 := Tpl.textString(txt_0);
  out_txt := fun_247(txt, str_1, a_cr);
end crefToPrintfArg;

public function crefType
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Type i_identType;

    case ( txt,
           DAE.CREF_IDENT(identType = i_identType) )
      equation
        txt = expTypeModelica(txt, i_identType);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(componentRef = i_componentRef) )
      equation
        txt = crefType(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("crefType:ERROR"));
      then txt;
  end match;
end crefType;

protected function lm_250
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_250(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_250;

public function functionAssertsforCheck
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_algAndEqAssertsEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algAndEqAssertsPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_algAndEqAssertsPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algAndEqAssertsPart, l_tmp, l_varDecls) := lm_250(l_algAndEqAssertsPart, a_algAndEqAssertsEquations, l_tmp, l_varDecls);
  l_algAndEqAssertsPart := Tpl.popIter(l_algAndEqAssertsPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* function to check assert after a step is done */\n",
                                       "int checkForAsserts(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_algAndEqAssertsPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAssertsforCheck;

public function defvars
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_item;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_item)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(name = i_name) )
      equation
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end defvars;

public function functionlinearmodel
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_outputVars;
      list<SimCode.SimVar> i_vars_inputVars;
      list<SimCode.SimVar> i_vars_stateVars;
      Absyn.Path i_name;
      Integer i_varInfo_numOutVars;
      Integer i_varInfo_numInVars;
      Integer i_varInfo_numStateVars;
      Tpl.Text l_vectorY;
      Tpl.Text l_vectorU;
      Tpl.Text l_vectorX;
      Tpl.Text l_matrixD;
      Tpl.Text l_matrixC;
      Tpl.Text l_matrixB;
      Tpl.Text l_matrixA;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars, numInVars = i_varInfo_numInVars, numOutVars = i_varInfo_numOutVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, inputVars = i_vars_inputVars, outputVars = i_vars_outputVars), name = i_name) )
      equation
        l_matrixA = genMatrix(Tpl.emptyTxt, "A", i_varInfo_numStateVars, i_varInfo_numStateVars);
        l_matrixB = genMatrix(Tpl.emptyTxt, "B", i_varInfo_numStateVars, i_varInfo_numInVars);
        l_matrixC = genMatrix(Tpl.emptyTxt, "C", i_varInfo_numOutVars, i_varInfo_numStateVars);
        l_matrixD = genMatrix(Tpl.emptyTxt, "D", i_varInfo_numOutVars, i_varInfo_numInVars);
        l_vectorX = genVector(Tpl.emptyTxt, "x", i_varInfo_numStateVars, 0);
        l_vectorU = genVector(Tpl.emptyTxt, "u", i_varInfo_numInVars, 1);
        l_vectorY = genVector(Tpl.emptyTxt, "y", i_varInfo_numOutVars, 2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("const char *linear_model_frame =\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"model linear_"));
        txt = underscorePath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\n  parameter Integer n = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // states \\n  parameter Integer k = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // top-level inputs \\n  parameter Integer l = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "; // top-level outputs \\n\"\n",
                                    "\"  parameter Real x0["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "] = {%s};\\n\"\n",
                                    "\"  parameter Real u0["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {%s};\\n\"\n"));
        txt = Tpl.writeText(txt, l_matrixA);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixB);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixC);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixD);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorX);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorU);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorY);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"\\n  "));
        txt = getVarName(txt, i_vars_stateVars, "x", i_varInfo_numStateVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = getVarName(txt, i_vars_inputVars, "u", i_varInfo_numInVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = getVarName(txt, i_vars_outputVars, "y", i_varInfo_numOutVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\n\"\n",
                                    "\"equation\\n  der(x) = A * x + B * u;\\n  y = C * x + D * u;\\nend linear_"
                                }, false));
        txt = underscorePath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\\n\"\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionlinearmodel;

protected function fun_254
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input Tpl.Text in_a_rest;
  input Tpl.Text in_a_arrindex;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_rest, in_a_arrindex, in_a_arrayName)
    local
      Tpl.Text txt;
      Tpl.Text a_rest;
      Tpl.Text a_arrindex;
      String a_arrayName;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(name = i_name),
           a_rest,
           a_arrindex,
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefM(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, a_arrindex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n  "));
        txt = Tpl.writeText(txt, a_rest);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_254;

public function getVarName
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_simVars;
  input String in_a_arrayName;
  input Integer in_a_arraySize;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVars, in_a_arrayName, in_a_arraySize)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_arraySize;
      SimCode.SimVar i_var;
      list<SimCode.SimVar> i_restVars;
      Integer ret_3;
      Integer ret_2;
      Tpl.Text l_arrindex;
      Tpl.Text l_rest;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: i_restVars,
           a_arrayName,
           a_arraySize )
      equation
        l_rest = getVarName(Tpl.emptyTxt, i_restVars, a_arrayName, a_arraySize);
        ret_2 = listLength(i_restVars);
        ret_3 = SimCodeUtil.decrementInt(a_arraySize, ret_2);
        l_arrindex = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        txt = fun_254(txt, i_var, l_rest, l_arrindex, a_arrayName);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end getVarName;

protected function fun_256
  input Tpl.Text in_txt;
  input Integer in_a_col;
  input Integer in_a_row;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_col, in_a_row, in_a_name)
    local
      Tpl.Text txt;
      Integer a_row;
      String a_name;
      Integer i_col;

    case ( txt,
           (i_col as 0),
           a_row,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  parameter Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = zeros("));
        txt = Tpl.writeStr(txt, intString(a_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");%s\\n\""));
      then txt;

    case ( txt,
           i_col,
           a_row,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  parameter Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = [%s];\\n\""));
      then txt;
  end match;
end fun_256;

protected function fun_257
  input Tpl.Text in_txt;
  input Integer in_a_row;
  input String in_a_name;
  input Integer in_a_col;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_row, in_a_name, in_a_col)
    local
      Tpl.Text txt;
      String a_name;
      Integer a_col;
      Integer i_row;

    case ( txt,
           (i_row as 0),
           a_name,
           a_col )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  parameter Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = zeros("));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");%s\\n\""));
      then txt;

    case ( txt,
           i_row,
           a_name,
           a_col )
      equation
        txt = fun_256(txt, a_col, i_row, a_name);
      then txt;
  end match;
end fun_257;

public function genMatrix
  input Tpl.Text txt;
  input String a_name;
  input Integer a_row;
  input Integer a_col;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_257(txt, a_row, a_name, a_col);
end genMatrix;

protected function fun_259
  input Tpl.Text in_txt;
  input Integer in_a_numIn;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_numIn, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      Integer i_numIn;

    case ( txt,
           (i_numIn as 0),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;

    case ( txt,
           i_numIn,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("](start="));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0);\\n\""));
      then txt;
  end match;
end fun_259;

protected function fun_260
  input Tpl.Text in_txt;
  input Integer in_a_numIn;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_numIn, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      Integer i_numIn;

    case ( txt,
           (i_numIn as 0),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  input Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;

    case ( txt,
           i_numIn,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  input Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("](start= "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0);\\n\""));
      then txt;
  end match;
end fun_260;

protected function fun_261
  input Tpl.Text in_txt;
  input Integer in_a_numIn;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_numIn, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      Integer i_numIn;

    case ( txt,
           (i_numIn as 0),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  output Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;

    case ( txt,
           i_numIn,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  output Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;
  end match;
end fun_261;

protected function fun_262
  input Tpl.Text in_txt;
  input Integer in_a_flag;
  input String in_a_name;
  input Integer in_a_numIn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag, in_a_name, in_a_numIn)
    local
      Tpl.Text txt;
      String a_name;
      Integer a_numIn;

    case ( txt,
           0,
           a_name,
           a_numIn )
      equation
        txt = fun_259(txt, a_numIn, a_name);
      then txt;

    case ( txt,
           1,
           a_name,
           a_numIn )
      equation
        txt = fun_260(txt, a_numIn, a_name);
      then txt;

    case ( txt,
           2,
           a_name,
           a_numIn )
      equation
        txt = fun_261(txt, a_numIn, a_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_262;

public function genVector
  input Tpl.Text txt;
  input String a_name;
  input Integer a_numIn;
  input Integer a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_262(txt, a_flag, a_name, a_numIn);
end genVector;

protected function lm_264
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      Integer i_maxColor;
      list<list<DAE.ComponentRef>> i_colorList;
      list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> i_sparsepattern;
      String i_name;
      list<SimCode.SimVar> i_vars;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_mat, i_vars, i_name, (i_sparsepattern, (_, _)), i_colorList, i_maxColor) :: rest )
      equation
        txt = initialAnalyticJacobians(txt, i_mat, i_vars, i_name, i_sparsepattern, i_colorList, i_maxColor);
        txt = Tpl.nextIter(txt);
        txt = lm_264(txt, rest);
      then txt;
  end match;
end lm_264;

protected function lm_265
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      String i_name;
      list<SimCode.SimVar> i_vars;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_mat, i_vars, i_name, _, _, _) :: rest )
      equation
        txt = generateMatrix(txt, i_mat, i_vars, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_265(txt, rest);
      then txt;
  end match;
end lm_265;

public function functionAnalyticJacobians
  input Tpl.Text txt;
  input list<SimCode.JacobianMatrix> a_JacobianMatrixes;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacMats;
  Tpl.Text l_initialjacMats;
algorithm
  l_initialjacMats := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_initialjacMats := lm_264(l_initialjacMats, a_JacobianMatrixes);
  l_initialjacMats := Tpl.popIter(l_initialjacMats);
  l_jacMats := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_jacMats := lm_265(l_jacMats, a_JacobianMatrixes);
  l_jacMats := Tpl.popIter(l_jacMats);
  out_txt := Tpl.writeText(txt, l_initialjacMats);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_jacMats);
end functionAnalyticJacobians;

protected function lm_267
  input Tpl.Text in_txt;
  input list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> in_items;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_matrixname)
    local
      Tpl.Text txt;
      list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> rest;
      String a_matrixname;
      list<DAE.ComponentRef> i_indexes;
      DAE.ComponentRef i_cref;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_cref, i_indexes) :: rest,
           a_matrixname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex["));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$indexdiff] = "));
        ret_0 = listLength(i_indexes);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_267(txt, rest, a_matrixname);
      then txt;
  end match;
end lm_267;

protected function lm_268
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input list<DAE.ComponentRef> in_a_indexes;
  input String in_a_matrixname;
  input DAE.ComponentRef in_a_cref;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_indexes, in_a_matrixname, in_a_cref)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      list<DAE.ComponentRef> a_indexes;
      String a_matrixname;
      DAE.ComponentRef a_cref;
      Integer x_index0;
      DAE.ComponentRef i_indexrow;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_indexrow :: rest,
           a_indexes,
           a_matrixname,
           a_cref )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("i = data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex["));
        txt = cref(txt, a_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$indexdiff] - "));
        ret_0 = listLength(a_indexes);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.index[i+"
                                }, false));
        txt = Tpl.writeStr(txt, intString(x_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_indexrow);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$indexdiffed;"));
        txt = Tpl.nextIter(txt);
        txt = lm_268(txt, rest, a_indexes, a_matrixname, a_cref);
      then txt;
  end match;
end lm_268;

protected function lm_269
  input Tpl.Text in_txt;
  input list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> in_items;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_matrixname)
    local
      Tpl.Text txt;
      list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> rest;
      String a_matrixname;
      DAE.ComponentRef i_cref;
      list<DAE.ComponentRef> i_indexes;
      Tpl.Text l_indexrows;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_cref, i_indexes) :: rest,
           a_matrixname )
      equation
        l_indexrows = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_indexrows = lm_268(l_indexrows, i_indexes, i_indexes, a_matrixname, i_cref);
        l_indexrows = Tpl.popIter(l_indexrows);
        txt = Tpl.writeText(txt, l_indexrows);
        txt = Tpl.nextIter(txt);
        txt = lm_269(txt, rest, a_matrixname);
      then txt;
  end match;
end lm_269;

protected function lm_270
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_index0;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_index0, in_a_matrixname)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_index0;
      String a_matrixname;
      DAE.ComponentRef i_i__index;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_i__index :: rest,
           a_index0,
           a_matrixname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.analyticJacobians[index].sparsePattern.colorCols["));
        txt = cref(txt, i_i__index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$indexdiff] = "));
        ret_0 = intAdd(a_index0, 1);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_270(txt, rest, a_index0, a_matrixname);
      then txt;
  end match;
end lm_270;

protected function lm_271
  input Tpl.Text in_txt;
  input list<list<DAE.ComponentRef>> in_items;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_matrixname)
    local
      Tpl.Text txt;
      list<list<DAE.ComponentRef>> rest;
      String a_matrixname;
      Integer x_index0;
      list<DAE.ComponentRef> i_indexes;
      Tpl.Text l_colorCol;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_indexes :: rest,
           a_matrixname )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        l_colorCol = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_colorCol = lm_270(l_colorCol, i_indexes, x_index0, a_matrixname);
        l_colorCol = Tpl.popIter(l_colorCol);
        txt = Tpl.writeText(txt, l_colorCol);
        txt = Tpl.nextIter(txt);
        txt = lm_271(txt, rest, a_matrixname);
      then txt;
  end match;
end lm_271;

protected function lm_272
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String i_indxColumn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, _, i_indxColumn) :: rest )
      equation
        txt = Tpl.writeStr(txt, i_indxColumn);
        txt = Tpl.nextIter(txt);
        txt = lm_272(txt, rest);
      then txt;
  end match;
end lm_272;

protected function lm_273
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      list<SimCode.SimVar> i_vars;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, i_vars, _) :: rest )
      equation
        ret_0 = listLength(i_vars);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.nextIter(txt);
        txt = lm_273(txt, rest);
      then txt;
  end match;
end lm_273;

protected function fun_274
  input Tpl.Text in_txt;
  input list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> in_a_sparsepattern;
  input Integer in_a_maxColor;
  input list<SimCode.SimVar> in_a_seedVars;
  input list<SimCode.JacobianColumn> in_a_jacobianColumn;
  input list<list<DAE.ComponentRef>> in_a_colorList;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sparsepattern, in_a_maxColor, in_a_seedVars, in_a_jacobianColumn, in_a_colorList, in_a_matrixname)
    local
      Tpl.Text txt;
      Integer a_maxColor;
      list<SimCode.SimVar> a_seedVars;
      list<SimCode.JacobianColumn> a_jacobianColumn;
      list<list<DAE.ComponentRef>> a_colorList;
      String a_matrixname;
      list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> i_sparsepattern;
      Integer ret_11;
      Tpl.Text l_index__;
      Tpl.Text l_tmpvarsSize;
      Tpl.Text l_indexColumn;
      Tpl.Text l_colorArray;
      Tpl.Text l_indexElems;
      Tpl.Text l_leadindex;
      Integer ret_4;
      Tpl.Text l_sizeleadindex;
      Integer ret_2;
      list<list<DAE.ComponentRef>> ret_1;
      Tpl.Text l_sp__size__index;

    case ( txt,
           {(_, {})},
           _,
           _,
           _,
           _,
           a_matrixname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int initialAnalyticJacobian"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* inData)\n",
                                    "{\n",
                                    "  return 1;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           i_sparsepattern,
           a_maxColor,
           a_seedVars,
           a_jacobianColumn,
           a_colorList,
           a_matrixname )
      equation
        ret_1 = Util.splitTuple212List(i_sparsepattern);
        ret_2 = List.lengthListElements(ret_1);
        l_sp__size__index = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        ret_4 = listLength(i_sparsepattern);
        l_sizeleadindex = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        l_leadindex = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_leadindex = lm_267(l_leadindex, i_sparsepattern, a_matrixname);
        l_leadindex = Tpl.popIter(l_leadindex);
        l_indexElems = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_indexElems = lm_269(l_indexElems, i_sparsepattern, a_matrixname);
        l_indexElems = Tpl.popIter(l_indexElems);
        l_colorArray = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_colorArray = lm_271(l_colorArray, a_colorList, a_matrixname);
        l_colorArray = Tpl.popIter(l_colorArray);
        l_indexColumn = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_indexColumn = lm_272(l_indexColumn, a_jacobianColumn);
        l_indexColumn = Tpl.popIter(l_indexColumn);
        l_tmpvarsSize = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_tmpvarsSize = lm_273(l_tmpvarsSize, a_jacobianColumn);
        l_tmpvarsSize = Tpl.popIter(l_tmpvarsSize);
        ret_11 = listLength(a_seedVars);
        l_index__ = Tpl.writeStr(Tpl.emptyTxt, intString(ret_11));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int initialAnalyticJacobian"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* inData)\n",
                                    "{\n",
                                    "  DATA* data = ((DATA*)inData);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int index = INDEX_JAC_"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "int i;\n",
                                    "\n",
                                    "data->simulationInfo.analyticJacobians[index].sizeCols = "
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.analyticJacobians[index].sizeRows = "
                                }, false));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.analyticJacobians[index].seedVars = (modelica_real*) calloc("
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",sizeof(modelica_real));\n",
                                    "data->simulationInfo.analyticJacobians[index].resultVars = (modelica_real*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(modelica_real));\n",
                                    "data->simulationInfo.analyticJacobians[index].tmpVars = (modelica_real*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_tmpvarsSize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(modelica_real));\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex = (unsigned int*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_sizeleadindex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(int));\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.index = (unsigned int*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_sp__size__index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(int));\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.colorCols = (unsigned int*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(int));\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.maxColors = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_maxColor));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.analyticJacobians[index].jacobian = NULL;\n",
                                    "\n",
                                    "/* write column ptr of compressed sparse column*/\n"
                                }, true));
        txt = Tpl.writeText(txt, l_leadindex);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for(i=1;i<"));
        txt = Tpl.writeText(txt, l_sizeleadindex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";++i)\n",
                                    "    data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex[i] += data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex[i-1];\n",
                                    "\n",
                                    "\n",
                                    "/* write index */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_indexElems);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* write color array */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_colorArray);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_274;

protected function fun_275
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_seedVars;
  input list<SimCode.JacobianColumn> in_a_jacobianColumn;
  input String in_a_matrixname;
  input list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> in_a_sparsepattern;
  input list<list<DAE.ComponentRef>> in_a_colorList;
  input Integer in_a_maxColor;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_seedVars, in_a_jacobianColumn, in_a_matrixname, in_a_sparsepattern, in_a_colorList, in_a_maxColor)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> a_jacobianColumn;
      String a_matrixname;
      list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> a_sparsepattern;
      list<list<DAE.ComponentRef>> a_colorList;
      Integer a_maxColor;
      list<SimCode.SimVar> i_seedVars;

    case ( txt,
           {},
           _,
           a_matrixname,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int initialAnalyticJacobian"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* inData)\n",
                                    "{\n",
                                    "  return 1;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           i_seedVars,
           a_jacobianColumn,
           a_matrixname,
           a_sparsepattern,
           a_colorList,
           a_maxColor )
      equation
        txt = fun_274(txt, a_sparsepattern, a_maxColor, i_seedVars, a_jacobianColumn, a_colorList, a_matrixname);
      then txt;
  end match;
end fun_275;

public function initialAnalyticJacobians
  input Tpl.Text txt;
  input list<SimCode.JacobianColumn> a_jacobianColumn;
  input list<SimCode.SimVar> a_seedVars;
  input String a_matrixname;
  input list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> a_sparsepattern;
  input list<list<DAE.ComponentRef>> a_colorList;
  input Integer a_maxColor;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_275(txt, a_seedVars, a_jacobianColumn, a_matrixname, a_sparsepattern, a_colorList, a_maxColor);
end initialAnalyticJacobians;

protected function lm_277
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String i_indxColumn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, _, i_indxColumn) :: rest )
      equation
        txt = Tpl.writeStr(txt, i_indxColumn);
        txt = lm_277(txt, rest);
      then txt;
  end match;
end lm_277;

protected function lm_278
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_matrixname)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String a_matrixname;
      String i_indxColumn;
      list<SimCode.SimVar> i_vars;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_eqs, i_vars, i_indxColumn) :: rest,
           a_matrixname )
      equation
        txt = functionJac(txt, i_eqs, i_vars, i_indxColumn, a_matrixname);
        txt = Tpl.nextIter(txt);
        txt = lm_278(txt, rest, a_matrixname);
      then txt;
  end match;
end lm_278;

protected function lm_279
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String i_indxColumn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, _, i_indxColumn) :: rest )
      equation
        txt = Tpl.writeStr(txt, i_indxColumn);
        txt = Tpl.nextIter(txt);
        txt = lm_279(txt, rest);
      then txt;
  end match;
end lm_279;

protected function fun_280
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_seedVars;
  input list<SimCode.JacobianColumn> in_a_jacobianColumn;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_seedVars, in_a_jacobianColumn, in_a_matrixname)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> a_jacobianColumn;
      String a_matrixname;
      Tpl.Text l_indexColumn;
      Tpl.Text l_jacMats;

    case ( txt,
           {},
           _,
           a_matrixname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int functionJac"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_column(void* data)\n",
                                    "{\n",
                                    "  return 0;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_jacobianColumn,
           a_matrixname )
      equation
        l_jacMats = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_jacMats = lm_278(l_jacMats, a_jacobianColumn, a_matrixname);
        l_jacMats = Tpl.popIter(l_jacMats);
        l_indexColumn = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_indexColumn = lm_279(l_indexColumn, a_jacobianColumn);
        l_indexColumn = Tpl.popIter(l_indexColumn);
        txt = Tpl.writeText(txt, l_jacMats);
      then txt;
  end match;
end fun_280;

protected function fun_281
  input Tpl.Text in_txt;
  input String in_mArg;
  input list<SimCode.JacobianColumn> in_a_jacobianColumn;
  input list<SimCode.SimVar> in_a_seedVars;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_jacobianColumn, in_a_seedVars, in_a_matrixname)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> a_jacobianColumn;
      list<SimCode.SimVar> a_seedVars;
      String a_matrixname;

    case ( txt,
           "0",
           _,
           _,
           a_matrixname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int functionJac"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_column(void* data)\n",
                                    "{\n",
                                    "  return 0;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_jacobianColumn,
           a_seedVars,
           a_matrixname )
      equation
        txt = fun_280(txt, a_seedVars, a_jacobianColumn, a_matrixname);
      then txt;
  end match;
end fun_281;

public function generateMatrix
  input Tpl.Text txt;
  input list<SimCode.JacobianColumn> a_jacobianColumn;
  input list<SimCode.SimVar> a_seedVars;
  input String a_matrixname;

  output Tpl.Text out_txt;
protected
  String str_1;
  Tpl.Text l_indxColumn;
algorithm
  l_indxColumn := lm_277(Tpl.emptyTxt, a_jacobianColumn);
  str_1 := Tpl.textString(l_indxColumn);
  out_txt := fun_281(txt, str_1, a_jacobianColumn, a_seedVars, a_matrixname);
end generateMatrix;

protected function lm_283
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_283(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_283;

public function functionJac
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_jacEquations;
  input list<SimCode.SimVar> a_tmpVars;
  input String a_columnLength;
  input String a_matrixName;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqns__;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqns__ := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqns__, l_tmp, l_varDecls) := lm_283(l_eqns__, a_jacEquations, l_tmp, l_varDecls);
  l_eqns__ := Tpl.popIter(l_eqns__);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int functionJac"));
  out_txt := Tpl.writeStr(out_txt, a_matrixName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_column(void* inData)\n",
                                       "{\n",
                                       "  state mem_state;\n",
                                       "  DATA* data = ((DATA*)inData);\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int index = INDEX_JAC_"));
  out_txt := Tpl.writeStr(out_txt, a_matrixName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(";\n"));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("mem_state = get_memory_state();\n"));
  out_txt := Tpl.writeText(out_txt, l_eqns__);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionJac;

protected function lm_285
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
        txt = lm_285(txt, rest);
      then txt;
  end match;
end lm_285;

public function intArr
  input Tpl.Text txt;
  input list<Integer> a_values;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_285(out_txt, a_values);
  out_txt := Tpl.popIter(out_txt);
end intArr;

public function equationIndex
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      Integer i_index;

    case ( txt,
           SimCode.SES_RESIDUAL(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_IFEQUATION(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_MIXED(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_WHEN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end equationIndex;

protected function lm_288
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_stmt;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_stmt :: rest )
      equation
        ret_0 = DAEDump.ppStmtStr(i_stmt, 2);
        ret_1 = System.stringReplace(ret_0, "/*", "(*");
        ret_2 = System.stringReplace(ret_1, "*/", "*)");
        txt = Tpl.writeStr(txt, ret_2);
        txt = lm_288(txt, rest);
      then txt;
  end match;
end lm_288;

protected function lm_289
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_cr) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<var>"));
        txt = CodegenUtil.crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</var>"));
        txt = Tpl.nextIter(txt);
        txt = lm_289(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_289(txt, rest);
      then txt;
  end match;
end lm_289;

protected function lm_290
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cell>"));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        ret_1 = System.stringReplace(ret_0, "/*", "(*");
        ret_2 = System.stringReplace(ret_1, "*/", "*)");
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cell>"));
        txt = Tpl.nextIter(txt);
        txt = lm_290(txt, rest);
      then txt;
  end match;
end lm_290;

protected function fun_291
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      DAE.Exp i_e_exp;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_e_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<residual>"));
        ret_0 = ExpressionDump.printExpStr(i_e_exp);
        ret_1 = System.stringReplace(ret_0, "/*", "(*");
        ret_2 = System.stringReplace(ret_1, "*/", "*)");
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</residual>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_291;

protected function lm_292
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      SimCode.SimEqSystem i_eq;
      Integer i_i2;
      Integer i_i1;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_i1, i_i2, i_eq) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cell row=\""));
        txt = Tpl.writeStr(txt, intString(i_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" col=\""));
        txt = Tpl.writeStr(txt, intString(i_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = fun_291(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cell>"));
        txt = lm_292(txt, rest);
      then txt;
  end match;
end lm_292;

protected function lm_293
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = CodegenUtil.crefStr(txt, i_cr);
        txt = Tpl.nextIter(txt);
        txt = lm_293(txt, rest);
      then txt;
  end match;
end lm_293;

protected function lm_294
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = equationIndex(txt, i_eq);
        txt = Tpl.nextIter(txt);
        txt = lm_294(txt, rest);
      then txt;
  end match;
end lm_294;

protected function lm_295
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_cr) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<var>"));
        txt = CodegenUtil.crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</var>"));
        txt = Tpl.nextIter(txt);
        txt = lm_295(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_295(txt, rest);
      then txt;
  end match;
end lm_295;

protected function lm_296
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<discrete index=\""));
        txt = equationIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = lm_296(txt, rest);
      then txt;
  end match;
end lm_296;

protected function lm_297
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cond;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cond :: rest )
      equation
        txt = CodegenUtil.crefStr(txt, i_cond);
        txt = Tpl.nextIter(txt);
        txt = lm_297(txt, rest);
      then txt;
  end match;
end lm_297;

protected function lm_298
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> rest;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, i_eqs) :: rest )
      equation
        txt = dumpEqs(txt, i_eqs);
        txt = lm_298(txt, rest);
      then txt;
  end match;
end lm_298;

protected function fun_299
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_elsebranch;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> i_ifbranches;
      DAE.Exp i_e_right;
      DAE.ComponentRef i_e_left;
      list<DAE.ComponentRef> i_conditions;
      list<SimCode.SimVar> i_e_discVars;
      list<SimCode.SimEqSystem> i_e_discEqs;
      SimCode.SimEqSystem i_e_cont;
      list<SimCode.SimEqSystem> i_e_eqs;
      list<DAE.ComponentRef> i_e_crefs;
      Integer i_indexNonLinearSystem;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<DAE.Exp> i_beqs;
      list<SimCode.SimVar> i_e_vars;
      list<DAE.Statement> i_e_statements;
      DAE.ComponentRef i_e_componentRef;
      DAE.ComponentRef i_e_cref;
      DAE.Exp i_e_exp;
      SimCode.SimEqSystem i_e;
      Tpl.Text l_elsebr;
      Tpl.Text l_branches;
      String ret_12;
      String ret_11;
      String ret_10;
      list<SimCode.SimEqSystem> ret_9;
      String ret_8;
      String ret_7;
      String ret_6;
      String ret_5;
      String ret_4;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           (i_e as SimCode.SES_RESIDUAL(exp = i_e_exp)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: RESIDUAL\n",
                                    "\n"
                                }, true));
        ret_0 = ExpressionDump.printExpStr(i_e_exp);
        ret_1 = System.stringReplace(ret_0, "/*", "(*");
        ret_2 = System.stringReplace(ret_1, "*/", "*)");
        txt = Tpl.writeStr(txt, ret_2);
      then txt;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(cref = i_e_cref, exp = i_e_exp)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("type: SIMPLE_ASSIGN\n"));
        txt = CodegenUtil.crefStr(txt, i_e_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        ret_3 = ExpressionDump.printExpStr(i_e_exp);
        ret_4 = System.stringReplace(ret_3, "/*", "(*");
        ret_5 = System.stringReplace(ret_4, "*/", "*)");
        txt = Tpl.writeStr(txt, ret_5);
      then txt;

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = i_e_componentRef, exp = i_e_exp)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: ARRAY_CALL_ASSIGN\n",
                                    "\n"
                                }, true));
        txt = CodegenUtil.crefStr(txt, i_e_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        ret_6 = ExpressionDump.printExpStr(i_e_exp);
        ret_7 = System.stringReplace(ret_6, "/*", "(*");
        ret_8 = System.stringReplace(ret_7, "*/", "*)");
        txt = Tpl.writeStr(txt, ret_8);
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("empty algorithm"));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = (i_e_statements as _ :: _))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: ALGORITHM\n",
                                    "\n"
                                }, true));
        txt = lm_288(txt, i_e_statements);
      then txt;

    case ( txt,
           (i_e as SimCode.SES_LINEAR(vars = i_e_vars, beqs = i_beqs, simJac = i_simJac)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: LINEAR\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_289(txt, i_e_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<row>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_290(txt, i_beqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</row>\n",
                                    "<matrix>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = lm_292(txt, i_simJac);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</matrix>"));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(indexNonLinearSystem = i_indexNonLinearSystem, crefs = i_e_crefs, eqs = i_e_eqs)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("indexNonlinear: "));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: NONLINEAR\n",
                                    "\n",
                                    "vars: {"
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_293(txt, i_e_crefs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "eqns: {"
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_294(txt, i_e_eqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_MIXED(cont = i_e_cont, discEqs = i_e_discEqs, discVars = i_e_discVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: MIXED\n",
                                    "\n"
                                }, true));
        ret_9 = List.fill(i_e_cont, 1);
        txt = dumpEqs(txt, ret_9);
        txt = Tpl.softNewLine(txt);
        txt = dumpEqs(txt, i_e_discEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "<mixed>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<continuous index=\""));
        txt = equationIndex(txt, i_e_cont);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\" />\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_295(txt, i_e_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = lm_296(txt, i_e_discEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</mixed>"));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_WHEN(conditions = i_conditions, left = i_e_left, right = i_e_right)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: WHEN\n",
                                    "\n",
                                    "when {"
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_297(txt, i_conditions);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("} then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = CodegenUtil.crefStr(txt, i_e_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        ret_10 = ExpressionDump.printExpStr(i_e_right);
        ret_11 = System.stringReplace(ret_10, "/*", "(*");
        ret_12 = System.stringReplace(ret_11, "*/", "*)");
        txt = Tpl.writeStr(txt, ret_12);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_IFEQUATION(ifbranches = i_ifbranches, elsebranch = i_elsebranch)) )
      equation
        l_branches = lm_298(Tpl.emptyTxt, i_ifbranches);
        l_elsebr = dumpEqs(Tpl.emptyTxt, i_elsebranch);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: IFEQUATION\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_branches);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_elsebr);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unknown equation"));
      then txt;
  end match;
end fun_299;

protected function lm_300
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = fun_299(txt, i_eq);
        txt = lm_300(txt, rest);
      then txt;
  end match;
end lm_300;

public function dumpEqs
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_eqs;

  output Tpl.Text out_txt;
algorithm
  out_txt := lm_300(txt, a_eqs);
end dumpEqs;

protected function fun_302
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = true) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;
  end match;
end fun_302;

protected function fun_303
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_tempeqns;
  input Tpl.Text in_a_varD;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tempeqns;
  output Tpl.Text out_a_varD;
algorithm
  (out_txt, out_a_tempeqns, out_a_varD) :=
  match(in_txt, in_a_eq, in_a_tempeqns, in_a_varD, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_tempeqns;
      Tpl.Text a_varD;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_e;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(index = _)),
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationSimpleAssign(txt, i_e, a_context, a_varD);
      then (txt, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(index = _)),
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationArrayCallAssign(txt, i_e, a_context, a_varD);
      then (txt, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_IFEQUATION(index = _)),
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_tempeqns) = equationIfEquationAssign(txt, i_e, a_context, a_varD, a_tempeqns);
      then (txt, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(index = _)),
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationAlgorithm(txt, i_e, a_context, a_varD);
      then (txt, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_LINEAR(index = _)),
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationLinear(txt, i_e, a_context, a_varD);
      then (txt, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(index = _)),
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationNonlinear(txt, i_e, a_context, a_varD);
      then (txt, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_WHEN(index = _)),
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationWhen(txt, i_e, a_context, a_varD);
      then (txt, a_tempeqns, a_varD);

    case ( txt,
           SimCode.SES_RESIDUAL(index = _),
           a_tempeqns,
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION SES_RESIDUAL"));
      then (txt, a_tempeqns, a_varD);

    case ( txt,
           SimCode.SES_MIXED(index = _),
           a_tempeqns,
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION SES_MIXED"));
      then (txt, a_tempeqns, a_varD);

    case ( txt,
           _,
           a_tempeqns,
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION equation_"));
      then (txt, a_tempeqns, a_varD);
  end match;
end fun_303;

protected function fun_304
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_eqs;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqs;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqs, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_eqs, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_eqs;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_eq;
      SimCode.SimEqSystem i_e;
      list<SimCode.SimEqSystem> ret_6;
      Tpl.Text l_x;
      Tpl.Text l_disc;
      Tpl.Text l_tempeqns;
      Tpl.Text l_varD;
      Tpl.Text l_tmp;
      Tpl.Text l_ix;

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_eqs,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls, a_eqs) = equationMixed(txt, i_e, a_context, a_varDecls, a_eqs);
      then (txt, a_eqs, a_varDecls);

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           a_eqs,
           a_varDecls,
           _ )
      then (txt, a_eqs, a_varDecls);

    case ( txt,
           i_eq,
           a_eqs,
           a_varDecls,
           a_context )
      equation
        l_ix = equationIndex(Tpl.emptyTxt, i_eq);
        l_tmp = Tpl.emptyTxt;
        l_varD = Tpl.emptyTxt;
        l_tempeqns = Tpl.emptyTxt;
        l_disc = fun_302(Tpl.emptyTxt, a_context);
        (l_x, l_tempeqns, l_varD) = fun_303(Tpl.emptyTxt, i_eq, l_tempeqns, l_varD, a_context);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_NEW_LINE());
        a_eqs = Tpl.writeText(a_eqs, l_tempeqns);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_LINE("/*\n"));
        a_eqs = Tpl.pushBlock(a_eqs, Tpl.BT_INDENT(1));
        ret_6 = List.fill(i_eq, 1);
        a_eqs = dumpEqs(a_eqs, ret_6);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_LINE("*/\n"));
        a_eqs = Tpl.popBlock(a_eqs);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING("static void eqFunction_"));
        a_eqs = Tpl.writeText(a_eqs, l_ix);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING_LIST({
                                        "(DATA *data)\n",
                                        "{\n"
                                    }, true));
        a_eqs = Tpl.pushBlock(a_eqs, Tpl.BT_INDENT(2));
        a_eqs = Tpl.writeText(a_eqs, l_varD);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.writeText(a_eqs, l_x);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.popBlock(a_eqs);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING("}"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("eqFunction_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(data);"));
      then (txt, a_eqs, a_varDecls);
  end match;
end fun_304;

protected function fun_305
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_eqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) :=
  match(in_txt, in_a_context, in_a_eq, in_a_varDecls, in_a_eqs)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      Tpl.Text a_varDecls;
      Tpl.Text a_eqs;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.INLINE_CONTEXT()),
           a_eq,
           a_varDecls,
           a_eqs )
      equation
        (txt, a_varDecls) = old_equation_(txt, a_eq, i_context, a_varDecls);
      then (txt, a_varDecls, a_eqs);

    case ( txt,
           i_context,
           a_eq,
           a_varDecls,
           a_eqs )
      equation
        (txt, a_eqs, a_varDecls) = fun_304(txt, a_eq, a_eqs, a_varDecls, i_context);
      then (txt, a_varDecls, a_eqs);
  end match;
end fun_305;

public function equation_
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_eqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) := fun_305(txt, a_context, a_eq, a_varDecls, a_eqs);
end equation_;

protected function fun_307
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem i_eq;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}) )
      then txt;

    case ( txt,
           i_eq )
      equation
        l_ix = equationIndex(Tpl.emptyTxt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("#ifdef _OMC_MEASURE_TIME\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQEXT("));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endif\n",
                                    "eqFunction_"
                                }, false));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(data);\n",
                                    "#ifdef _OMC_MEASURE_TIME\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQEXT("));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#endif"));
      then txt;
  end match;
end fun_307;

protected function fun_308
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem i_eq;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}) )
      then txt;

    case ( txt,
           i_eq )
      equation
        l_ix = equationIndex(Tpl.emptyTxt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("#ifdef _OMC_MEASURE_TIME\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQEXT("));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endif\n",
                                    "eqFunction_"
                                }, false));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(data);\n",
                                    "#ifdef _OMC_MEASURE_TIME\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQEXT("));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#endif"));
      then txt;
  end match;
end fun_308;

protected function fun_309
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = true),
           a_eq )
      equation
        txt = fun_307(txt, a_eq);
      then txt;

    case ( txt,
           _,
           a_eq )
      equation
        txt = fun_308(txt, a_eq);
      then txt;
  end match;
end fun_309;

public function equationNames_
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_309(txt, a_context, a_eq);
end equationNames_;

public function old_equation_
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_e;

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationSimpleAssign(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationSimpleAssign(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationArrayCallAssign(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationAlgorithm(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_LINEAR(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationLinear(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationNonlinear(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_WHEN(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationWhen(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION old_equation_"));
      then (txt, a_varDecls);
  end match;
end old_equation_;

protected function fun_312
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_tmp, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_e;
      Integer ret_6;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationSimpleAssign(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_1 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationArrayCallAssign(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_2 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationAlgorithm(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_LINEAR(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_3 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationLinear(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_4 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls, a_tmp) = equationMixed(txt, i_e, a_context, a_varDecls, a_tmp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_5 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_5));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationNonlinear(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_WHEN(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_6 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_6));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationWhen(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _,
           a_tmp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION myequation_"));
      then (txt, a_tmp, a_varDecls);
  end match;
end fun_312;

public function myequation_
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_tmp;
algorithm
  l_tmp := Tpl.emptyTxt;
  (out_txt, l_tmp, out_a_varDecls) := fun_312(txt, a_eq, l_tmp, a_varDecls, a_context);
end myequation_;

protected function fun_314
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_c;
  input String in_a_arr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_c, in_a_arr)
    local
      Tpl.Text txt;
      String a_arr;
      DAE.ComponentRef i_c;

    case ( txt,
           (i_c as DAE.CREF_QUAL(ident = "$DER")),
           a_arr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "inline_integrate_array(size_of_dimension_real_array("
                                }, false));
        txt = Tpl.writeStr(txt, a_arr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",1),"));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_314;

public function inlineArray
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input String in_a_arr;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_arr, in_a_c)
    local
      Tpl.Text txt;
      String a_arr;
      DAE.ComponentRef a_c;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_arr,
           a_c )
      equation
        txt = fun_314(txt, a_c, a_arr);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end inlineArray;

protected function fun_316
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           SimCode.SIMVAR(name = (i_cr as DAE.CREF_QUAL(ident = "$DER"))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inline_integrate("));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_316;

protected function lm_317
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_316(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_317(txt, rest);
      then txt;
  end match;
end lm_317;

protected function fun_318
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_simvars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simvars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_simvars;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_simvars )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_317(txt, i_simvars);
        txt = Tpl.popIter(txt);
      then txt;
  end match;
end fun_318;

public function inlineVars
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input list<SimCode.SimVar> in_a_simvars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_simvars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> a_simvars;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_simvars )
      equation
        txt = fun_318(txt, a_simvars);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end inlineVars;

protected function fun_320
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_QUAL(ident = "$DER")) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inline_integrate("));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_320;

protected function lm_321
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = fun_320(txt, i_cr);
        txt = Tpl.nextIter(txt);
        txt = lm_321(txt, rest);
      then txt;
  end match;
end lm_321;

protected function fun_322
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_a_crefs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_crefs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> i_crefs;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_crefs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_321(txt, i_crefs);
        txt = Tpl.popIter(txt);
      then txt;
  end match;
end fun_322;

public function inlineCrefs
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input list<DAE.ComponentRef> in_a_crefs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_crefs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> a_crefs;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_crefs )
      equation
        txt = fun_322(txt, a_crefs);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end inlineCrefs;

protected function fun_324
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_QUAL(ident = "$DER")) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "inline_integrate("
                                }, false));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_324;

public function inlineCref
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_cr )
      equation
        txt = fun_324(txt, a_cr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end inlineCref;

public function equationSimpleAssign
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cref;
      SimCode.SimEqSystem i_eq;
      DAE.Exp i_exp;
      Absyn.Info ret_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref)),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        ret_2 = SimCodeUtil.eqInfo(i_eq);
        txt = modelicaLine(txt, ret_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = inlineCref(txt, a_context, i_cref);
        txt = Tpl.softNewLine(txt);
        txt = endModelicaLine(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end equationSimpleAssign;

protected function fun_327
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_eqn_exp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_eqn_componentRef;
  input Tpl.Text in_a_expPart;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_eqn_exp, in_a_context, in_a_eqn_componentRef, in_a_expPart, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Exp a_eqn_exp;
      SimCode.Context a_context;
      DAE.ComponentRef a_eqn_componentRef;
      Tpl.Text a_expPart;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Tpl.Text txt_1;
      String ret_1;
      Tpl.Text l_tvar;

    case ( txt,
           "boolean",
           _,
           a_context,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "boolean_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_boolean_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(l_tvar), a_eqn_componentRef);
      then (txt, a_varDecls);

    case ( txt,
           "integer",
           _,
           a_context,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "integer_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_integer_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(l_tvar), a_eqn_componentRef);
      then (txt, a_varDecls);

    case ( txt,
           "real",
           _,
           a_context,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_real_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(a_expPart), a_eqn_componentRef);
      then (txt, a_varDecls);

    case ( txt,
           "string",
           _,
           a_context,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_string_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(a_expPart), a_eqn_componentRef);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_eqn_exp,
           _,
           _,
           _,
           _,
           a_varDecls )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("No runtime support for this sort of array call: "));
        ret_1 = ExpressionDump.printExpStr(a_eqn_exp);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 2938, 14), Tpl.textString(txt_1));
      then (txt, a_varDecls);
  end match;
end fun_327;

protected function fun_328
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_eqn_componentRef;
      DAE.Exp i_eqn_exp;
      DAE.Exp i_exp;
      String str_3;
      Tpl.Text txt_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(exp = (i_eqn_exp as i_exp), componentRef = i_eqn_componentRef),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt_2 = expTypeFromExpShort(Tpl.emptyTxt, i_eqn_exp);
        str_3 = Tpl.textString(txt_2);
        (txt, a_varDecls) = fun_327(txt, str_3, i_eqn_exp, a_context, i_eqn_componentRef, l_expPart, l_preExp, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_328;

public function equationArrayCallAssign
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Absyn.Info ret_0;
algorithm
  ret_0 := SimCodeUtil.eqInfo(a_eq);
  out_txt := modelicaLine(txt, ret_0);
  out_txt := Tpl.softNewLine(out_txt);
  (out_txt, out_a_varDecls) := fun_328(out_txt, a_eq, a_context, a_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := endModelicaLine(out_txt);
end equationArrayCallAssign;

protected function lm_330
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_330(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_330;

public function equationAlgorithm
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_statements;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = i_statements),
           a_context,
           a_varDecls )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_330(txt, i_statements, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end equationAlgorithm;

protected function lm_332
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_indexLinearSystem;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_indexLinearSystem)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_indexLinearSystem;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_indexLinearSystem )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = data->simulationInfo.linearSystemData["));
        txt = Tpl.writeStr(txt, intString(a_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].x["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_332(txt, rest, a_indexLinearSystem);
      then txt;

    case ( txt,
           _ :: rest,
           a_indexLinearSystem )
      equation
        txt = lm_332(txt, rest, a_indexLinearSystem);
      then txt;
  end match;
end lm_332;

protected function fun_333
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_context)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      list<SimCode.SimVar> i_vars;
      Integer i_indexLinearSystem;
      Integer i_index;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index, indexLinearSystem = i_indexLinearSystem, vars = i_vars),
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_TICK_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").profileBlockIndex);"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* Linear equation system */\n",
                                    "solve_linear_system(data, "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_332(txt, i_vars, i_indexLinearSystem);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = inlineVars(txt, a_context, i_vars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ACC_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ").profileBlockIndex);\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_333;

public function equationLinear
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_333(txt, a_eq, a_context);
  out_a_varDecls := a_varDecls;
end equationLinear;

protected function lm_335
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_eqn_indexMixedSystem;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_eqn_indexMixedSystem)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_eqn_indexMixedSystem;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_eqn_indexMixedSystem )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.mixedSystemData["));
        txt = Tpl.writeStr(txt, intString(a_eqn_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].iterationVarsPtr["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = (modelica_boolean*)&"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_335(txt, rest, a_eqn_indexMixedSystem);
      then txt;

    case ( txt,
           _ :: rest,
           a_eqn_indexMixedSystem )
      equation
        txt = lm_335(txt, rest, a_eqn_indexMixedSystem);
      then txt;
  end match;
end lm_335;

protected function lm_336
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_eqn_indexMixedSystem;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_eqn_indexMixedSystem)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_eqn_indexMixedSystem;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_eqn_indexMixedSystem )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.mixedSystemData["));
        txt = Tpl.writeStr(txt, intString(a_eqn_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].iterationPreVarsPtr["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = (modelica_boolean*)&$P$PRE"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_336(txt, rest, a_eqn_indexMixedSystem);
      then txt;

    case ( txt,
           _ :: rest,
           a_eqn_indexMixedSystem )
      equation
        txt = lm_336(txt, rest, a_eqn_indexMixedSystem);
      then txt;
  end match;
end lm_336;

public function equationMixed
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_tmp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_tmp;
algorithm
  (out_txt, out_a_varDecls, out_a_tmp) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_tmp)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_tmp;
      Integer i_indexMixedSystem;
      Integer i_eqn_indexMixedSystem;
      Integer i_index;
      list<SimCode.SimVar> i_discVars;
      SimCode.SimEqSystem i_cont;
      Integer ret_2;
      Tpl.Text l_numDiscVarsStr;
      Tpl.Text l_contEqs;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont, discVars = i_discVars, index = i_index, indexMixedSystem = (i_indexMixedSystem as i_eqn_indexMixedSystem)),
           a_context,
           a_varDecls,
           a_tmp )
      equation
        (l_contEqs, a_varDecls, a_tmp) = equation_(Tpl.emptyTxt, i_cont, a_context, a_varDecls, a_tmp);
        ret_2 = listLength(i_discVars);
        l_numDiscVarsStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_TICK_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ").profileBlockIndex);\n",
                                    "#endif\n",
                                    "/* Continuous equation part in "
                                }, false));
        txt = Tpl.writeText(txt, l_contEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_335(txt, i_discVars, i_eqn_indexMixedSystem);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_336(txt, i_discVars, i_eqn_indexMixedSystem);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "solve_mixed_system(data, "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ACC_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ").profileBlockIndex);\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_tmp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_tmp )
      then (txt, a_varDecls, a_tmp);
  end match;
end equationMixed;

protected function lm_338
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq2 :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = functionExtraResidualsPreBody(txt, i_eq2, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_338(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_338;

protected function lm_339
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_indexNonLinearSystem;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_indexNonLinearSystem)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_indexNonLinearSystem;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_indexNonLinearSystem )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.nonlinearSystemData["));
        txt = Tpl.writeStr(txt, intString(a_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nlsx["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.nonlinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nlsxOld["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = _"));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(1) /*old*/;\n",
                                    "data->simulationInfo.nonlinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nlsxExtrapolation["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = extraPolate(data, _"));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1) /*old*/, _"));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(2) /*old2*/);"));
        txt = Tpl.nextIter(txt);
        txt = lm_339(txt, rest, a_indexNonLinearSystem);
      then txt;
  end match;
end lm_339;

protected function lm_340
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_indexNonLinearSystem;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_indexNonLinearSystem)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_indexNonLinearSystem;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_indexNonLinearSystem )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = data->simulationInfo.nonlinearSystemData["));
        txt = Tpl.writeStr(txt, intString(a_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nlsx["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_340(txt, rest, a_indexNonLinearSystem);
      then txt;
  end match;
end lm_340;

public function equationNonlinear
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Integer i_index;
      Integer i_indexNonLinearSystem;
      list<SimCode.SimEqSystem> i_eqs;
      list<DAE.ComponentRef> i_crefs;
      Tpl.Text l_nonlinindx;
      Tpl.Text l_innerBody;
      Tpl.Text l_tmp;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs, eqs = i_eqs, indexNonLinearSystem = i_indexNonLinearSystem, index = i_index),
           a_context,
           a_varDecls )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        l_tmp = Tpl.emptyTxt;
        l_innerBody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_innerBody, l_tmp, a_varDecls) = lm_338(l_innerBody, i_eqs, l_tmp, a_varDecls);
        l_innerBody = Tpl.popIter(l_innerBody);
        l_nonlinindx = Tpl.writeStr(Tpl.emptyTxt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_TICK_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ").profileBlockIndex);\n",
                                    "SIM_PROF_ADD_NCALL_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ").profileBlockIndex,-1);\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* extrapolate data */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_339(txt, i_crefs, i_indexNonLinearSystem);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("solve_nonlinear_system(data, "));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "/* write solution */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_340(txt, i_crefs, i_indexNonLinearSystem);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = inlineCrefs(txt, a_context, i_crefs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* update inner equations */\n"));
        txt = Tpl.writeText(txt, l_innerBody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ACC_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ").profileBlockIndex);\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end equationNonlinear;

public function equationNamesExtraResidualsPreBodyInline
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_context)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      DAE.ComponentRef i_cref;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref),
           a_context )
      equation
        txt = inlineCref(txt, a_context, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end equationNamesExtraResidualsPreBodyInline;

protected function lm_343
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("|| ("));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !$P$PRE"));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* edge */)"));
        txt = Tpl.popBlock(txt);
        txt = lm_343(txt, rest);
      then txt;
  end match;
end lm_343;

protected function fun_344
  input Tpl.Text in_txt;
  input Boolean in_a_initialCall;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_right;
  input DAE.ComponentRef in_a_left;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_initialCall, in_a_varDecls, in_a_context, in_a_right, in_a_left)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Exp a_right;
      DAE.ComponentRef a_left;
      DAE.Type ret_0;

    case ( txt,
           false,
           a_varDecls,
           _,
           _,
           a_left )
      equation
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_context,
           a_right,
           a_left )
      equation
        ret_0 = Expression.typeof(a_right);
        (txt, a_varDecls) = whenAssign(txt, a_left, ret_0, a_right, a_context, a_varDecls);
      then (txt, a_varDecls);
  end match;
end fun_344;

protected function lm_345
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("|| ("));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !$P$PRE"));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* edge */)"));
        txt = Tpl.popBlock(txt);
        txt = lm_345(txt, rest);
      then txt;
  end match;
end lm_345;

protected function fun_346
  input Tpl.Text in_txt;
  input Boolean in_a_initialCall;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_right;
  input DAE.ComponentRef in_a_left;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_initialCall, in_a_varDecls, in_a_context, in_a_right, in_a_left)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Exp a_right;
      DAE.ComponentRef a_left;
      DAE.Type ret_0;

    case ( txt,
           false,
           a_varDecls,
           _,
           _,
           a_left )
      equation
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_context,
           a_right,
           a_left )
      equation
        ret_0 = Expression.typeof(a_right);
        (txt, a_varDecls) = whenAssign(txt, a_left, ret_0, a_right, a_context, a_varDecls);
      then (txt, a_varDecls);
  end match;
end fun_346;

public function equationWhen
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_elseWhenEq;
      DAE.Exp i_right;
      DAE.ComponentRef i_left;
      Boolean i_initialCall;
      list<DAE.ComponentRef> i_conditions;
      Tpl.Text l_elseWhen;
      DAE.Type ret_4;
      DAE.Type ret_3;
      Tpl.Text l_assign;
      Tpl.Text l_initial__assign;
      Tpl.Text l_helpIf;

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = NONE(), initialCall = i_initialCall),
           a_context,
           a_varDecls )
      equation
        l_helpIf = lm_343(Tpl.emptyTxt, i_conditions);
        (l_initial__assign, a_varDecls) = fun_344(Tpl.emptyTxt, i_initialCall, a_varDecls, a_context, i_right, i_left);
        ret_3 = Expression.typeof(i_right);
        (l_assign, a_varDecls) = whenAssign(Tpl.emptyTxt, i_left, ret_3, i_right, a_context, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(initial())\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_initial__assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "else if(0"
                                }, false));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "else\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = SOME(i_elseWhenEq), initialCall = i_initialCall),
           a_context,
           a_varDecls )
      equation
        l_helpIf = lm_345(Tpl.emptyTxt, i_conditions);
        (l_initial__assign, a_varDecls) = fun_346(Tpl.emptyTxt, i_initialCall, a_varDecls, a_context, i_right, i_left);
        ret_4 = Expression.typeof(i_right);
        (l_assign, a_varDecls) = whenAssign(Tpl.emptyTxt, i_left, ret_4, i_right, a_context, a_varDecls);
        (l_elseWhen, a_varDecls) = equationElseWhen(Tpl.emptyTxt, i_elseWhenEq, a_context, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(initial())\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_initial__assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "else if(0"
                                }, false));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_elseWhen);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "else\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end equationWhen;

protected function lm_348
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("|| ("));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !$P$PRE"));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* edge */)"));
        txt = Tpl.popBlock(txt);
        txt = lm_348(txt, rest);
      then txt;
  end match;
end lm_348;

protected function lm_349
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("|| ("));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !$P$PRE"));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* edge */)"));
        txt = Tpl.popBlock(txt);
        txt = lm_349(txt, rest);
      then txt;
  end match;
end lm_349;

public function equationElseWhen
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_elseWhenEq;
      DAE.Exp i_right;
      DAE.ComponentRef i_left;
      list<DAE.ComponentRef> i_conditions;
      Tpl.Text l_elseWhen;
      DAE.Type ret_3;
      DAE.Type ret_2;
      Tpl.Text l_assign;
      Tpl.Text l_helpIf;

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = NONE()),
           a_context,
           a_varDecls )
      equation
        l_helpIf = lm_348(Tpl.emptyTxt, i_conditions);
        ret_2 = Expression.typeof(i_right);
        (l_assign, a_varDecls) = whenAssign(Tpl.emptyTxt, i_left, ret_2, i_right, a_context, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if(0"));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = SOME(i_elseWhenEq)),
           a_context,
           a_varDecls )
      equation
        l_helpIf = lm_349(Tpl.emptyTxt, i_conditions);
        ret_3 = Expression.typeof(i_right);
        (l_assign, a_varDecls) = whenAssign(Tpl.emptyTxt, i_left, ret_3, i_right, a_context, a_varDecls);
        (l_elseWhen, a_varDecls) = equationElseWhen(Tpl.emptyTxt, i_elseWhenEq, a_context, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if(0"));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_elseWhen);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end equationElseWhen;

protected function fun_351
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_right;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_left;
  input Tpl.Text in_a_expPart;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_right, in_a_context, in_a_left, in_a_expPart, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Exp a_right;
      SimCode.Context a_context;
      DAE.ComponentRef a_left;
      Tpl.Text a_expPart;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Tpl.Text txt_1;
      String ret_1;
      Tpl.Text l_tvar;

    case ( txt,
           "boolean",
           _,
           a_context,
           a_left,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "boolean_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_boolean_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(l_tvar), a_left);
      then (txt, a_varDecls);

    case ( txt,
           "integer",
           _,
           a_context,
           a_left,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "integer_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_integer_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(l_tvar), a_left);
      then (txt, a_varDecls);

    case ( txt,
           "real",
           _,
           a_context,
           a_left,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_real_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(a_expPart), a_left);
      then (txt, a_varDecls);

    case ( txt,
           "string",
           _,
           a_context,
           a_left,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_string_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(a_expPart), a_left);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_right,
           _,
           a_left,
           _,
           _,
           a_varDecls )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("No runtime support for this sort of array call: "));
        txt_1 = cref(txt_1, a_left);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(" = "));
        ret_1 = ExpressionDump.printExpStr(a_right);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 3166, 13), Tpl.textString(txt_1));
      then (txt, a_varDecls);
  end match;
end fun_351;

protected function fun_352
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_left;
  input DAE.Exp in_a_right;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_ty, in_a_left, in_a_right, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_left;
      DAE.Exp a_right;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text l_exp;
      String str_3;
      Tpl.Text txt_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           a_left,
           a_right,
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_right, a_context, l_preExp, a_varDecls);
        txt_2 = expTypeFromExpShort(Tpl.emptyTxt, a_right);
        str_3 = Tpl.textString(txt_2);
        (txt, a_varDecls) = fun_351(txt, str_3, a_right, a_context, a_left, l_expPart, l_preExp, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_left,
           a_right,
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_exp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_right, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);
  end match;
end fun_352;

public function whenAssign
  input Tpl.Text txt;
  input DAE.ComponentRef a_left;
  input DAE.Type a_ty;
  input DAE.Exp a_right;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_352(txt, a_ty, a_left, a_right, a_context, a_varDecls);
end whenAssign;

protected function lm_354
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_eqnsDecls;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqnsDecls;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqnsDecls, out_a_varDecls) :=
  match(in_txt, in_items, in_a_eqnsDecls, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_eqnsDecls;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_eqn;
      Tpl.Text l_eqnStr;

    case ( txt,
           {},
           a_eqnsDecls,
           a_varDecls,
           _ )
      then (txt, a_eqnsDecls, a_varDecls);

    case ( txt,
           i_eqn :: rest,
           a_eqnsDecls,
           a_varDecls,
           a_context )
      equation
        (l_eqnStr, a_varDecls, a_eqnsDecls) = equation_(Tpl.emptyTxt, i_eqn, a_context, a_varDecls, a_eqnsDecls);
        txt = Tpl.writeText(txt, l_eqnStr);
        txt = Tpl.nextIter(txt);
        (txt, a_eqnsDecls, a_varDecls) = lm_354(txt, rest, a_eqnsDecls, a_varDecls, a_context);
      then (txt, a_eqnsDecls, a_varDecls);
  end match;
end lm_354;

protected function fun_355
  input Tpl.Text in_txt;
  input Integer in_a_index0;
  input Tpl.Text in_a_condition;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_index0, in_a_condition)
    local
      Tpl.Text txt;
      Tpl.Text a_condition;

    case ( txt,
           0,
           a_condition )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if("));
        txt = Tpl.writeText(txt, a_condition);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_condition )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if("));
        txt = Tpl.writeText(txt, a_condition);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_355;

protected function lm_356
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> in_items;
  input Tpl.Text in_a_eqnsDecls;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqnsDecls;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_eqnsDecls, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_eqnsDecls, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> rest;
      Tpl.Text a_eqnsDecls;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer x_index0;
      list<SimCode.SimEqSystem> i_eqns;
      DAE.Exp i_e;
      Tpl.Text l_conditionline;
      Tpl.Text l_ifequations;
      Tpl.Text l_condition;

    case ( txt,
           {},
           a_eqnsDecls,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_eqnsDecls, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_eqns) :: rest,
           a_eqnsDecls,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        (l_condition, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        l_ifequations = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_ifequations, a_eqnsDecls, a_varDecls) = lm_354(l_ifequations, i_eqns, a_eqnsDecls, a_varDecls, a_context);
        l_ifequations = Tpl.popIter(l_ifequations);
        l_conditionline = fun_355(Tpl.emptyTxt, x_index0, l_condition);
        txt = Tpl.writeText(txt, l_conditionline);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_ifequations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        (txt, a_eqnsDecls, a_varDecls, a_preExp) = lm_356(txt, rest, a_eqnsDecls, a_varDecls, a_preExp, a_context);
      then (txt, a_eqnsDecls, a_varDecls, a_preExp);
  end match;
end lm_356;

protected function lm_357
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_eqnsDecls;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqnsDecls;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqnsDecls, out_a_varDecls) :=
  match(in_txt, in_items, in_a_eqnsDecls, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_eqnsDecls;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_eqn;
      Tpl.Text l_eqnStr;

    case ( txt,
           {},
           a_eqnsDecls,
           a_varDecls,
           _ )
      then (txt, a_eqnsDecls, a_varDecls);

    case ( txt,
           i_eqn :: rest,
           a_eqnsDecls,
           a_varDecls,
           a_context )
      equation
        (l_eqnStr, a_varDecls, a_eqnsDecls) = equation_(Tpl.emptyTxt, i_eqn, a_context, a_varDecls, a_eqnsDecls);
        txt = Tpl.writeText(txt, l_eqnStr);
        txt = Tpl.nextIter(txt);
        (txt, a_eqnsDecls, a_varDecls) = lm_357(txt, rest, a_eqnsDecls, a_varDecls, a_context);
      then (txt, a_eqnsDecls, a_varDecls);
  end match;
end lm_357;

public function equationIfEquationAssign
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_eqnsDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqnsDecls;
algorithm
  (out_txt, out_a_varDecls, out_a_eqnsDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_eqnsDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_eqnsDecls;
      list<SimCode.SimEqSystem> i_elsebranch;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> i_ifbranches;
      Tpl.Text l_elseequations;
      Tpl.Text l_IfEquation;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_IFEQUATION(ifbranches = i_ifbranches, elsebranch = i_elsebranch),
           a_context,
           a_varDecls,
           a_eqnsDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_IfEquation = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_IfEquation, a_eqnsDecls, a_varDecls, l_preExp) = lm_356(l_IfEquation, i_ifbranches, a_eqnsDecls, a_varDecls, l_preExp, a_context);
        l_IfEquation = Tpl.popIter(l_IfEquation);
        l_elseequations = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_elseequations, a_eqnsDecls, a_varDecls) = lm_357(l_elseequations, i_elsebranch, a_eqnsDecls, a_varDecls, a_context);
        l_elseequations = Tpl.popIter(l_elseequations);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_IfEquation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "else\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_elseequations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls, a_eqnsDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_eqnsDecls )
      then (txt, a_varDecls, a_eqnsDecls);
  end match;
end equationIfEquationAssign;

protected function lm_359
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = literalExpConst(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_359(txt, rest);
      then txt;
  end match;
end lm_359;

public function simulationFunctionsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_functions.h\"\n",
                                       "#ifdef __cplusplus\n",
                                       "extern \"C\" {\n",
                                       "#endif\n",
                                       "\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_359(out_txt, a_literals);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionBodies(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
end simulationFunctionsFile;

public function simulationParModelicaKernelsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  System.parForTickReset(0);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "#include \"OCLRuntimeUtil_new.cl\"\n",
                                   "\n",
                                   "// ParModelica Parallel Function headers.\n"
                               }, true));
  out_txt := functionHeadersParModelica(out_txt, a_filePrefix, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "// Headers finish here.\n",
                                       "\n"
                                   }, true));
  out_txt := functionBodiesParModelica(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "\n"
                                   }, true));
end simulationParModelicaKernelsFile;

protected function fun_362
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_mainFunction)
    local
      Tpl.Text txt;
      SimCode.Function i_fn;

    case ( txt,
           SOME(i_fn) )
      equation
        txt = functionBodyParModelica(txt, i_fn, true);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_362;

public function functionsParModelicaKernelsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input Option<SimCode.Function> a_mainFunction;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  System.parForTickReset(0);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "#include \"OCLRuntimeUtil_new.cl\"\n",
                                   "\n",
                                   "// ParModelica Parallel Function headers.\n"
                               }, true));
  out_txt := functionHeadersParModelica(out_txt, a_filePrefix, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "// Headers finish here.\n",
                                       "\n"
                                   }, true));
  out_txt := fun_362(out_txt, a_mainFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionBodiesParModelica(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "\n"
                                   }, true));
end functionsParModelicaKernelsFile;

protected function lm_364
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclaration(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_364(txt, rest);
      then txt;
  end match;
end lm_364;

public function recordsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.RecordDeclaration> a_recordDecls;

  output Tpl.Text out_txt;
protected
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/* Additional record code for "));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
  ret_0 := Settings.getVersionNr();
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ". */\n",
                                       "#include \"meta_modelica.h\"\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_364(out_txt, a_recordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end recordsFile;

protected function lm_366
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclarationHeader(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_366(txt, rest);
      then txt;
  end match;
end lm_366;

public function simulationFunctionsHeaderFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;
  input list<SimCode.RecordDeclaration> a_recordDecls;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#ifndef "));
  ret_0 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "__H\n",
                                       "#define "
                                   }, false));
  ret_1 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__H\n"));
  out_txt := commonHeader(out_txt, a_filePrefix);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#include \"simulation_runtime.h\"\n",
                                       "#ifdef __cplusplus\n",
                                       "extern \"C\" {\n",
                                       "#endif\n"
                                   }, true));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                        "\n",
                                                                        "\n"
                                                                    }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_366(out_txt, a_recordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := functionHeaders(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end simulationFunctionsHeaderFile;

public function functionHeadersParModelica
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#ifndef "));
  ret_0 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "__H\n",
                                       "#define "
                                   }, false));
  ret_1 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "__H\n",
                                       "//#include \"helper.cl\"\n",
                                       "\n"
                                   }, true));
  out_txt := parallelFunctionHeadersImpl(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end functionHeadersParModelica;

protected function fun_369
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_369;

protected function lm_370
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_370(txt, rest);
      then txt;
  end match;
end lm_370;

protected function fun_371
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_371;

protected function fun_372
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_372;

protected function fun_373
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("OMOCLRuntime.lib OpenCL.lib"));
      then txt;
  end match;
end fun_373;

protected function fun_374
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end match;
end fun_374;

protected function fun_375
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER "));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK "));
      then txt;

    case ( txt,
           "dassljac" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_JACOBIAN "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_375;

protected function fun_376
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_374(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_375(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_376;

protected function fun_377
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/openmp"));
      then txt;
  end match;
end fun_377;

protected function fun_378
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      String i_makefileParams_omhome;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      Boolean ret_7;
      Tpl.Text l_extraCflags;
      Boolean ret_5;
      Tpl.Text l_ParModelicaLibs;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, omhome = i_makefileParams_omhome), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix) )
      equation
        l_dirExtra = fun_369(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_370(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_371(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_372(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        ret_5 = Config.acceptParModelicaGrammar();
        l_ParModelicaLibs = fun_373(Tpl.emptyTxt, ret_5);
        l_extraCflags = fun_376(Tpl.emptyTxt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O2 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=\n",
                                    "MODELICAUSERCFLAGS=\n",
                                    "CXX=cl\n",
                                    "EXEEXT=.exe\n",
                                    "DLLEXT=.dll\n",
                                    "\n",
                                    "# /Od - Optimization disabled\n",
                                    "# /EHa enable C++ EH (w/ SEH exceptions)\n",
                                    "# /fp:except - consider floating-point exceptions when generating code\n",
                                    "# /arch:SSE2 - enable use of instructions available with SSE2 enabled CPUs\n",
                                    "# /I - Include Directories\n",
                                    "# /DNOMINMAX - Define NOMINMAX (does what it says)\n",
                                    "# /TP - Use C++ Compiler\n",
                                    "CFLAGS=/Od /ZI /EHa /fp:except /I\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc\" /I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/msvc/\" /I. /DNOMINMAX /TP /DNO_INTERACTIVE_DEPENDENCY /DOPENMODELICA_XML_FROM_FILE_AT_RUNTIME "));
        ret_7 = Flags.isSet(Flags.HPCOM);
        txt = fun_377(txt, ret_7);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "# /ZI enable Edit and Continue debug info\n",
                                    "CDFLAGS = /ZI\n",
                                    "\n",
                                    "# /MD - link with MSVCRT.LIB\n",
                                    "# /link - [linker options and libraries]\n",
                                    "# /LIBPATH: - Directories where libs can be found\n",
                                    "LDFLAGS=/MD /link /NODEFAULTLIB:libcmt /STACK:0x2000000 /pdb:\""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".pdb\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/msvc/\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/msvc/release/\" "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " f2c.lib initialization.lib libexpat.lib math-support.lib meta.lib results.lib simulation.lib solver.lib sundials_kinsol.lib sundials_nvecserial.lib util.lib lapack_win32_MT.lib lis.lib  gc-lib.lib user32.lib pthreadVC2.lib\n",
                                    "\n",
                                    "# /MDd link with MSVCRTD.LIB debug lib\n",
                                    "# lib names should not be appended with a d just switch to lib/omc/msvc/debug\n",
                                    "\n",
                                    "\n",
                                    "FILEPREFIX="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MAINFILE=$(FILEPREFIX).c\n",
                                    "MAINOBJ=$(FILEPREFIX).obj\n",
                                    "GENERATEDFILES=$(MAINFILE) $(FILEPREFIX)_functions.c $(FILEPREFIX)_functions.h $(FILEPREFIX)_records.c $(FILEPREFIX).makefile\n",
                                    "\n",
                                    "$(FILEPREFIX)$(EXEEXT): $(MAINOBJ) $(FILEPREFIX)_records.c $(FILEPREFIX)_functions.c $(FILEPREFIX)_functions.h\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX) /Fe$(FILEPREFIX)$(EXEEXT) $(MAINFILE) $(FILEPREFIX)_records.c $(CFLAGS) $(LDFLAGS)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_378;

protected function fun_379
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_379;

protected function lm_380
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_380(txt, rest);
      then txt;
  end match;
end lm_380;

protected function fun_381
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_381;

protected function fun_382
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_382;

protected function fun_383
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lOMOCLRuntime -lOpenCL"));
      then txt;
  end match;
end fun_383;

protected function fun_384
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end match;
end fun_384;

protected function fun_385
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER "));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK "));
      then txt;

    case ( txt,
           "dassljac" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_JACOBIAN "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_385;

protected function fun_386
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_384(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_385(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_386;

protected function fun_387
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-O0 -g"));
      then txt;
  end match;
end fun_387;

protected function fun_388
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_makefileParams_ccompiler;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_makefileParams_ccompiler)
    local
      Tpl.Text txt;
      String a_makefileParams_ccompiler;

    case ( txt,
           false,
           a_makefileParams_ccompiler )
      equation
        txt = Tpl.writeStr(txt, a_makefileParams_ccompiler);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("g++"));
      then txt;
  end match;
end fun_388;

protected function fun_389
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_cflags;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(cflags = i_s_cflags)) )
      equation
        txt = Tpl.writeStr(txt, i_s_cflags);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_389;

protected function lm_390
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_390(txt, rest);
      then txt;
  end match;
end lm_390;

protected function fun_391
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-Wl,-whole-archive "));
      then txt;
  end match;
end fun_391;

protected function fun_392
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -Wl,-no-whole-archive"));
      then txt;
  end match;
end fun_392;

protected function fun_393
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -ldl"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_393;

protected function fun_394
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("--stack,0x2000000,"));
      then txt;
  end match;
end fun_394;

protected function fun_395
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "OSX" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lf2c -llis"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-Wl,-Bstatic -lf2c -Wl,-Bdynamic -llis"));
      then txt;
  end match;
end fun_395;

protected function fun_396
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_makefileParams_runtimelibs;
  input String in_a_makefileParams_ldflags;
  input Tpl.Text in_a_ParModelicaLibs;
  input String in_a_makefileParams_platform;
  input String in_a_makefileParams_omhome;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_makefileParams_runtimelibs, in_a_makefileParams_ldflags, in_a_ParModelicaLibs, in_a_makefileParams_platform, in_a_makefileParams_omhome)
    local
      Tpl.Text txt;
      String a_makefileParams_runtimelibs;
      String a_makefileParams_ldflags;
      Tpl.Text a_ParModelicaLibs;
      String a_makefileParams_platform;
      String a_makefileParams_omhome;
      String ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_makefileParams_runtimelibs,
           a_makefileParams_ldflags,
           a_ParModelicaLibs,
           a_makefileParams_platform,
           a_makefileParams_omhome )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -L\""));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib\" -Wl,"));
        ret_0 = stringEq(a_makefileParams_platform, "win32");
        txt = fun_394(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-rpath,\""));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -Wl,-rpath,\""));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib\" $(LIBSIMULATIONRUNTIMEC) -linteractive "));
        txt = Tpl.writeText(txt, a_ParModelicaLibs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_makefileParams_ldflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_makefileParams_runtimelibs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        ret_1 = System.os();
        txt = fun_395(txt, ret_1);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           a_makefileParams_omhome )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\'"));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/emcc\' -lexpat -lSimulationRuntimeC -lf2c -s TOTAL_MEMORY=536870912 -s MAX_SETJMPS=20000 -s OUTLINING_LIMIT=20000"));
      then txt;
  end match;
end fun_396;

protected function fun_397
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      String i_makefileParams_runtimelibs;
      String i_makefileParams_ldflags;
      String i_makefileParams_platform;
      list<String> i_makefileParams_includes;
      String i_makefileParams_omhome;
      String i_makefileParams_cflags;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      Boolean ret_27;
      String ret_26;
      Boolean ret_25;
      Boolean ret_24;
      Boolean ret_23;
      Boolean ret_22;
      Boolean ret_21;
      Boolean ret_20;
      Boolean ret_19;
      String ret_18;
      Boolean ret_17;
      Boolean ret_16;
      Boolean ret_15;
      Boolean ret_14;
      Boolean ret_13;
      Boolean ret_12;
      String ret_11;
      Boolean ret_10;
      Boolean ret_9;
      Boolean ret_8;
      Boolean ret_7;
      Tpl.Text l_extraCflags;
      Boolean ret_5;
      Tpl.Text l_ParModelicaLibs;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, cflags = i_makefileParams_cflags, omhome = i_makefileParams_omhome, includes = i_makefileParams_includes, platform = i_makefileParams_platform, ldflags = i_makefileParams_ldflags, runtimelibs = i_makefileParams_runtimelibs), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix) )
      equation
        l_dirExtra = fun_379(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_380(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_381(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_382(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        ret_5 = Config.acceptParModelicaGrammar();
        l_ParModelicaLibs = fun_383(Tpl.emptyTxt, ret_5);
        l_extraCflags = fun_386(Tpl.emptyTxt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O3 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL="
                                }, false));
        ret_7 = Config.acceptMetaModelicaGrammar();
        ret_8 = Flags.isSet(Flags.GEN_DEBUG_SYMBOLS);
        ret_9 = boolOr(ret_7, ret_8);
        txt = fun_387(txt, ret_9);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CC="));
        ret_10 = Config.acceptParModelicaGrammar();
        txt = fun_388(txt, ret_10, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS_BASED_ON_INIT_FILE="));
        txt = Tpl.writeText(txt, l_extraCflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS=$(CFLAGS_BASED_ON_INIT_FILE) "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_389(txt, i_sopt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CPPFLAGS=-I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc\" -I. "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_390(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " -DOPENMODELICA_XML_FROM_FILE_AT_RUNTIME\n",
                                    "LIBSIMULATIONRUNTIMEC="
                                }, false));
        ret_11 = System.os();
        ret_12 = stringEq(ret_11, "OSX");
        ret_13 = boolNot(ret_12);
        ret_14 = Config.acceptMetaModelicaGrammar();
        ret_15 = Flags.isSet(Flags.GEN_DEBUG_SYMBOLS);
        ret_16 = boolOr(ret_14, ret_15);
        ret_17 = boolAnd(ret_13, ret_16);
        txt = fun_391(txt, ret_17);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lSimulationRuntimeC "));
        ret_18 = System.os();
        ret_19 = stringEq(ret_18, "OSX");
        ret_20 = boolNot(ret_19);
        ret_21 = Config.acceptMetaModelicaGrammar();
        ret_22 = Flags.isSet(Flags.GEN_DEBUG_SYMBOLS);
        ret_23 = boolOr(ret_21, ret_22);
        ret_24 = boolAnd(ret_20, ret_23);
        txt = fun_392(txt, ret_24);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        ret_25 = stringEq(i_makefileParams_platform, "win32");
        txt = fun_393(txt, ret_25);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS="));
        ret_26 = Config.simCodeTarget();
        ret_27 = stringEq(ret_26, "JavaScript");
        txt = fun_396(txt, ret_27, i_makefileParams_runtimelibs, i_makefileParams_ldflags, l_ParModelicaLibs, i_makefileParams_platform, i_makefileParams_omhome);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "PERL=perl\n",
                                    "FILEPREFIX="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MAINFILE=$(FILEPREFIX).c\n",
                                    "MAINOBJ=$(FILEPREFIX).o\n",
                                    "GENERATEDFILES=$(MAINFILE) $(FILEPREFIX)_functions.c $(FILEPREFIX)_functions.h $(FILEPREFIX)_records.c $(FILEPREFIX).makefile\n",
                                    "\n",
                                    ".PHONY: omc_main_target clean bundle\n",
                                    "\n",
                                    "# This is to make sure that "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_records.c is always compiled.\n",
                                    ".PHONY: $(FILEPREFIX)_records.c\n",
                                    "\n",
                                    "omc_main_target: $(MAINOBJ) $(FILEPREFIX)_records.o $(FILEPREFIX)_functions.c $(FILEPREFIX)_functions.h\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX) -I. -o $(FILEPREFIX)$(EXEEXT) $(MAINOBJ) $(FILEPREFIX)_records.o $(CPPFLAGS) "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " $(CFLAGS) $(LDFLAGS)\n",
                                    "\n",
                                    "clean:\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "@rm -f $(FILEPREFIX)_records.o $(MAINOBJ)\n",
                                    "\n",
                                    "bundle:\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("@tar -cvf $(FILEPREFIX)_Files.tar $(GENERATEDFILES)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_397;

public function simulationMakefile
  input Tpl.Text in_txt;
  input String in_a_target;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_target, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      String i_target;
      Tpl.Text txt_0;

    case ( txt,
           "msvc",
           a_simCode )
      equation
        txt = fun_378(txt, a_simCode);
      then txt;

    case ( txt,
           "gcc",
           a_simCode )
      equation
        txt = fun_397(txt, a_simCode);
      then txt;

    case ( txt,
           i_target,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Target "));
        txt_0 = Tpl.writeStr(txt_0, i_target);
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_STRING(" is not handled!"));
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 3449, 9), Tpl.textString(txt_0));
      then txt;
  end match;
end simulationMakefile;

public function xsdateTime
  input Tpl.Text in_txt;
  input Util.DateTime in_a_dt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dt)
    local
      Tpl.Text txt;
      Integer i_sec;
      Integer i_min;
      Integer i_hour;
      Integer i_mday;
      Integer i_mon;
      Integer i_year;
      String ret_4;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           Util.DATETIME(year = i_year, mon = i_mon, mday = i_mday, hour = i_hour, min = i_min, sec = i_sec) )
      equation
        txt = Tpl.writeStr(txt, intString(i_year));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_0 = SimCodeUtil.twodigit(i_mon);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_1 = SimCodeUtil.twodigit(i_mday);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("T"));
        ret_2 = SimCodeUtil.twodigit(i_hour);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_3 = SimCodeUtil.twodigit(i_min);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_4 = SimCodeUtil.twodigit(i_sec);
        txt = Tpl.writeStr(txt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Z"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end xsdateTime;

public function simulationInitFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.ModelInfo i_modelInfo;
      String i_s_variableFilter;
      String i_s_outputFormat;
      String i_s_method;
      Real i_s_tolerance;
      Real i_s_stepSize;
      Real i_s_stopTime;
      Real i_s_startTime;
      Integer i_vi_numBoolParams;
      Integer i_vi_numBoolAliasVars;
      Integer i_vi_numBoolAlgVars;
      Integer i_vi_numStringParamVars;
      Integer i_vi_numStringAliasVars;
      Integer i_vi_numStringAlgVars;
      Integer i_vi_numIntParams;
      Integer i_vi_numIntAliasVars;
      Integer i_vi_numIntAlgVars;
      Integer i_vi_numParams;
      Integer i_vi_numAlgAliasVars;
      Integer i_vi_numAlgVars;
      Integer i_vi_numStateVars;
      list<SimCode.Function> i_functions;
      Integer i_vi_numExternalObjects;
      Integer i_vi_numInitialResiduals;
      Integer i_vi_numOutVars;
      Integer i_vi_numInVars;
      Integer i_vi_numTimeEvents;
      Integer i_vi_numZeroCrossings;
      String i_makefileParams_omhome;
      Absyn.Path i_modelInfo_name;
      Integer ret_6;
      Util.DateTime ret_5;
      String ret_4;
      String ret_3;
      Tpl.Text txt_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(functions = i_functions, varInfo = SimCode.VARINFO(numZeroCrossings = i_vi_numZeroCrossings, numTimeEvents = i_vi_numTimeEvents, numInVars = i_vi_numInVars, numOutVars = i_vi_numOutVars, numInitialResiduals = i_vi_numInitialResiduals, numExternalObjects = i_vi_numExternalObjects, numStateVars = i_vi_numStateVars, numAlgVars = i_vi_numAlgVars, numAlgAliasVars = i_vi_numAlgAliasVars, numParams = i_vi_numParams, numIntAlgVars = i_vi_numIntAlgVars, numIntAliasVars = i_vi_numIntAliasVars, numIntParams = i_vi_numIntParams, numStringAlgVars = i_vi_numStringAlgVars, numStringAliasVars = i_vi_numStringAliasVars, numStringParamVars = i_vi_numStringParamVars, numBoolAlgVars = i_vi_numBoolAlgVars, numBoolAliasVars = i_vi_numBoolAliasVars, numBoolParams = i_vi_numBoolParams), vars = SimCode.SIMVARS(stateVars = _), name = i_modelInfo_name)), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_s_startTime, stopTime = i_s_stopTime, stepSize = i_s_stepSize, tolerance = i_s_tolerance, method = i_s_method, outputFormat = i_s_outputFormat, variableFilter = i_s_variableFilter)), makefileParams = SimCode.MAKEFILE_PARAMS(omhome = i_makefileParams_omhome)),
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<?xml version = \"1.0\" encoding=\"UTF-8\"?>\n",
                                    "\n",
                                    "<!-- description of the model interface using an extention of the FMI standard -->\n",
                                    "<fmiModelDescription\n",
                                    "  fmiVersion                          = \"1.0\"\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelName                           = \""));
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_modelInfo_name);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelIdentifier                     = \""
                                }, false));
        txt_2 = underscorePath(Tpl.emptyTxt, i_modelInfo_name);
        ret_3 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_2));
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "\n",
                                    "OPENMODELICAHOME                    = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "\n",
                                    "guid                                = \"{"
                                }, false));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\"\n",
                                    "\n",
                                    "generationTool                      = \"OpenModelica Compiler "
                                }, false));
        ret_4 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "generationDateAndTime               = \""
                                }, false));
        ret_5 = Util.getCurrentDateTime();
        txt = xsdateTime(txt, ret_5);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "\n",
                                    "variableNamingConvention            = \"structured\"\n",
                                    "\n",
                                    "numberOfEventIndicators             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfEventIndicators             = \"NG:       number of zero crossings,                           FMI\"\n",
                                    "numberOfTimeEvents                  = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numTimeEvents));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfTimeEvents                  = \"NG_SAM:   number of zero crossings that are samples,          OMC\"\n",
                                    "\n",
                                    "numberOfInputVariables              = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfInputVariables              = \"NI:       number of inputvar on topmodel,                     OMC\"\n",
                                    "numberOfOutputVariables             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfOutputVariables             = \"NO:       number of outputvar on topmodel,                    OMC\"\n",
                                    "\n",
                                    "numberOfResidualsForInitialization  = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numInitialResiduals));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfResidualsForInitialization  = \"NR:       number of residuals for initialialization function, OMC\"\n",
                                    "numberOfExternalObjects             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numExternalObjects));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfExternalObjects             = \"NEXT:     number of external objects,                         OMC\"\n",
                                    "numberOfFunctions                   = \""
                                }, false));
        ret_6 = listLength(i_functions);
        txt = Tpl.writeStr(txt, intString(ret_6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfFunctions                   = \"NFUNC:    number of functions used by the simulation,         OMC\"\n",
                                    "\n",
                                    "numberOfContinuousStates            = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfContinuousStates            = \"NX:       number of states,                                   FMI\"\n",
                                    "numberOfRealAlgebraicVariables      = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfRealAlgebraicVariables      = \"NY:       number of real variables,                           OMC\"\n",
                                    "numberOfRealAlgebraicAliasVariables = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numAlgAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfRealAlgebraicAliasVariables = \"NA:       number of alias variables,                          OMC\"\n",
                                    "numberOfRealParameters              = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfRealParameters              = \"NP:       number of parameters,                               OMC\"\n",
                                    "\n",
                                    "numberOfIntegerAlgebraicVariables   = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfIntegerAlgebraicVariables   = \"NYINT:    number of alg. int variables,                       OMC\"\n",
                                    "numberOfIntegerAliasVariables       = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfIntegerAliasVariables       = \"NAINT:    number of alias int variables,                      OMC\"\n",
                                    "numberOfIntegerParameters           = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfIntegerParameters           = \"NPINT:    number of int parameters,                           OMC\"\n",
                                    "\n",
                                    "numberOfStringAlgebraicVariables    = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfStringAlgebraicVariables    = \"NYSTR:    number of alg. string variables,                    OMC\"\n",
                                    "numberOfStringAliasVariables        = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfStringAliasVariables        = \"NASTR:    number of alias string variables,                   OMC\"\n",
                                    "numberOfStringParameters            = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfStringParameters            = \"NPSTR:    number of string parameters,                        OMC\"\n",
                                    "\n",
                                    "numberOfBooleanAlgebraicVariables   = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfBooleanAlgebraicVariables   = \"NYBOOL:   number of alg. bool variables,                      OMC\"\n",
                                    "numberOfBooleanAliasVariables       = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfBooleanAliasVariables       = \"NABOOL:   number of alias bool variables,                     OMC\"\n",
                                    "numberOfBooleanParameters           = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfBooleanParameters           = \"NPBOOL:   number of bool parameters,                          OMC\" >\n",
                                    "\n",
                                    "\n",
                                    "<!-- startTime, stopTime, tolerance are FMI specific, all others are OMC specific -->\n",
                                    "<DefaultExperiment\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("startTime      = \""));
        txt = Tpl.writeStr(txt, realString(i_s_startTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "stopTime       = \""
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_s_stopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "stepSize       = \""
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_s_stepSize));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "tolerance      = \""
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_s_tolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "solver         = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_method);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "outputFormat   = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_outputFormat);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "variableFilter = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_variableFilter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\" />\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<!-- variables in the model -->\n"));
        txt = ModelVariables(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</fmiModelDescription>\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end simulationInitFile;

protected function fun_401
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define __OPENMODELICA__METAMODELICA"));
      then txt;
  end match;
end fun_401;

protected function fun_402
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"meta_modelica.h\""));
      then txt;
  end match;
end fun_402;

protected function fun_403
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_filePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_filePrefix)
    local
      Tpl.Text txt;
      String a_filePrefix;
      Integer ret_0;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_filePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include <omc_ocl_interface.h>\n",
                                    "/* the OpenCL Kernels file name needed in libOMOCLRuntime.a */\n",
                                    "const char* omc_ocl_kernels_source = \""
                                }, false));
        txt = Tpl.writeStr(txt, a_filePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_kernels.cl\";\n",
                                    "/* the OpenCL program. Made global to avoid repeated builds */\n",
                                    "extern cl_program omc_ocl_program;\n",
                                    "/* The default OpenCL device. If not set (=0) show the selection option.*/\n",
                                    "unsigned int default_ocl_device = "
                                }, false));
        ret_0 = Config.getDefaultOpenCLDevice();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_403;

public function commonHeader
  input Tpl.Text txt;
  input String a_filePrefix;

  output Tpl.Text out_txt;
protected
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  ret_0 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_401(txt, ret_0);
  out_txt := Tpl.softNewLine(out_txt);
  ret_1 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_402(out_txt, ret_1);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#include \"modelica.h\"\n",
                                       "#include <stdio.h>\n",
                                       "#include <stdlib.h>\n",
                                       "#include <errno.h>\n"
                                   }, true));
  ret_2 := Config.acceptParModelicaGrammar();
  out_txt := fun_403(out_txt, ret_2, a_filePrefix);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end commonHeader;

protected function lm_405
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = literalExpConst(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_405(txt, rest);
      then txt;
  end match;
end lm_405;

protected function fun_406
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_mainFunction)
    local
      Tpl.Text txt;

    case ( txt,
           NONE() )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void (*omc_assert)(FILE_INFO info,const char *msg,...) = omc_assert_function;\n",
                                    "void (*omc_assert_warning)(FILE_INFO info,const char *msg,...) = omc_assert_warning_function;\n",
                                    "void (*omc_terminate)(FILE_INFO info,const char *msg,...) = omc_terminate_function;\n",
                                    "void (*omc_throw)() = omc_throw_function;"
                                }, false));
      then txt;
  end match;
end fun_406;

protected function fun_407
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_mainFunction)
    local
      Tpl.Text txt;
      SimCode.Function i_fn;

    case ( txt,
           SOME(i_fn) )
      equation
        txt = functionBody(txt, i_fn, true);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_407;

public function functionsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input Option<SimCode.Function> a_mainFunction;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(".h\"\n"));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_405(out_txt, a_literals);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("#include \"modelica.h\"\n"));
  out_txt := fun_406(out_txt, a_mainFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := fun_407(out_txt, a_mainFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionBodies(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end functionsFile;

protected function lm_409
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclarationHeader(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_409(txt, rest);
      then txt;
  end match;
end lm_409;

protected function fun_410
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_mainFunction)
    local
      Tpl.Text txt;
      SimCode.Function i_fn;

    case ( txt,
           SOME(i_fn) )
      equation
        txt = functionHeader(txt, i_fn, true);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_410;

public function functionsHeaderFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input Option<SimCode.Function> a_mainFunction;
  input list<SimCode.Function> a_functions;
  input list<SimCode.RecordDeclaration> a_extraRecordDecls;
  input list<String> a_includes;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#ifndef "));
  ret_0 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "__H\n",
                                       "#define "
                                   }, false));
  ret_1 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__H\n"));
  out_txt := commonHeader(out_txt, a_filePrefix);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#ifdef __cplusplus\n",
                                       "extern \"C\" {\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_409(out_txt, a_extraRecordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := fun_410(out_txt, a_mainFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionHeaders(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := externalFunctionIncludes(out_txt, a_includes);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif\n",
                                       "#endif\n"
                                   }, true));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end functionsHeaderFile;

protected function lm_412
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_412(txt, rest);
      then txt;
  end match;
end lm_412;

protected function fun_413
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lOMOCLRuntime -lOpenCL"));
      then txt;
  end match;
end fun_413;

protected function fun_414
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -g"));
      then txt;
  end match;
end fun_414;

protected function fun_415
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_makefileParams_ccompiler;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_makefileParams_ccompiler)
    local
      Tpl.Text txt;
      String a_makefileParams_ccompiler;

    case ( txt,
           false,
           a_makefileParams_ccompiler )
      equation
        txt = Tpl.writeStr(txt, a_makefileParams_ccompiler);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("g++"));
      then txt;
  end match;
end fun_415;

protected function lm_416
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_416(txt, rest);
      then txt;
  end match;
end lm_416;

public function functionsMakefile
  input Tpl.Text in_txt;
  input SimCode.FunctionCode in_a_fnCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fnCode)
    local
      Tpl.Text txt;
      String i_name;
      String i_makefileParams_runtimelibs;
      String i_makefileParams_ldflags;
      String i_makefileParams_cflags;
      list<String> i_makefileParams_includes;
      String i_makefileParams_omhome;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      list<String> i_makefileParams_libs;
      Boolean ret_6;
      Boolean ret_5;
      Boolean ret_4;
      Boolean ret_3;
      Boolean ret_2;
      Tpl.Text l_ParModelicaLibs;
      Tpl.Text l_libsStr;

    case ( txt,
           SimCode.FUNCTIONCODE(makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, omhome = i_makefileParams_omhome, includes = i_makefileParams_includes, cflags = i_makefileParams_cflags, ldflags = i_makefileParams_ldflags, runtimelibs = i_makefileParams_runtimelibs), name = i_name) )
      equation
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_412(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        ret_2 = Config.acceptParModelicaGrammar();
        l_ParModelicaLibs = fun_413(Tpl.emptyTxt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Dynamic loading uses -O0 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=-O0"
                                }, false));
        ret_3 = Config.acceptMetaModelicaGrammar();
        ret_4 = Flags.isSet(Flags.GEN_DEBUG_SYMBOLS);
        ret_5 = boolOr(ret_3, ret_4);
        txt = fun_414(txt, ret_5);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CC="));
        ret_6 = Config.acceptParModelicaGrammar();
        txt = fun_415(txt, ret_6, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS= -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc\" "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_416(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS= -L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -Wl,-rpath,\'"));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\' -lOpenModelicaRuntimeC "));
        txt = Tpl.writeText(txt, l_ParModelicaLibs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_ldflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_runtimelibs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "PERL=perl\n",
                                    "MAINFILE="
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".c\n",
                                    "\n",
                                    ".PHONY: "
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": $(MAINFILE) "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".h "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CC) $(CFLAGS) -c -o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".o $(MAINFILE)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CC) $(CFLAGS) -c -o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(LINK) -o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o "));
        txt = Tpl.writeText(txt, l_libsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CFLAGS) $(LDFLAGS) -lm"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionsMakefile;

protected function lm_418
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_418(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_418(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_418;

protected function fun_419
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr, in_a_context)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      DAE.ComponentRef i_cr;
      ClassInf.State i_record__state;
      String ret_12;
      Tpl.Text txt_11;
      list<DAE.Subscript> ret_10;
      Tpl.Text l_dimsValuesStr;
      Integer ret_8;
      list<DAE.Subscript> ret_7;
      Tpl.Text l_dimsLenStr;
      Tpl.Text txt_5;
      Tpl.Text l_recPtr;
      Absyn.Path ret_3;
      Tpl.Text l_rec__name;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;

    case ( txt,
           (i_cr as DAE.CREF_QUAL(identType = DAE.T_ARRAY(ty = DAE.T_COMPLEX(complexClassType = i_record__state)), ident = i_ident, componentRef = i_componentRef)),
           a_context )
      equation
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        ret_3 = ClassInf.getStateName(i_record__state);
        l_rec__name = underscorePath(Tpl.emptyTxt, ret_3);
        txt_5 = Tpl.writeText(Tpl.emptyTxt, l_rec__name);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING("*"));
        (l_recPtr, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_5), l_varDecls);
        ret_7 = ComponentReference.crefSubs(i_cr);
        ret_8 = listLength(ret_7);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_8));
        ret_10 = ComponentReference.crefSubs(i_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, l_varDecls, l_preExp) = lm_418(l_dimsValuesStr, ret_10, l_varDecls, l_preExp, a_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(("));
        txt = Tpl.writeText(txt, l_rec__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*)(generic_array_element_addr(&_"));
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", sizeof("));
        txt = Tpl.writeText(txt, l_rec__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("), "));
        txt = Tpl.writeText(txt, l_dimsLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")))->"));
        txt = contextCref(txt, i_componentRef, a_context);
      then txt;

    case ( txt,
           i_cr,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt_11 = CodegenUtil.crefStr(Tpl.emptyTxt, i_cr);
        ret_12 = System.unquoteIdentifier(Tpl.textString(txt_11));
        txt = Tpl.writeStr(txt, ret_12);
      then txt;
  end match;
end fun_419;

protected function lm_420
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_420(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_420(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_420;

protected function fun_421
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr, in_a_context)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      DAE.ComponentRef i_cr;
      ClassInf.State i_record__state;
      String ret_12;
      Tpl.Text txt_11;
      list<DAE.Subscript> ret_10;
      Tpl.Text l_dimsValuesStr;
      Integer ret_8;
      list<DAE.Subscript> ret_7;
      Tpl.Text l_dimsLenStr;
      Tpl.Text txt_5;
      Tpl.Text l_recPtr;
      Absyn.Path ret_3;
      Tpl.Text l_rec__name;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;

    case ( txt,
           (i_cr as DAE.CREF_QUAL(identType = DAE.T_ARRAY(ty = DAE.T_COMPLEX(complexClassType = i_record__state)), ident = i_ident, componentRef = i_componentRef)),
           a_context )
      equation
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        ret_3 = ClassInf.getStateName(i_record__state);
        l_rec__name = underscorePath(Tpl.emptyTxt, ret_3);
        txt_5 = Tpl.writeText(Tpl.emptyTxt, l_rec__name);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING("*"));
        (l_recPtr, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_5), l_varDecls);
        ret_7 = ComponentReference.crefSubs(i_cr);
        ret_8 = listLength(ret_7);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_8));
        ret_10 = ComponentReference.crefSubs(i_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, l_varDecls, l_preExp) = lm_420(l_dimsValuesStr, ret_10, l_varDecls, l_preExp, a_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(("));
        txt = Tpl.writeText(txt, l_rec__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*)(generic_array_element_addr(&_"));
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", sizeof("));
        txt = Tpl.writeText(txt, l_rec__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("), "));
        txt = Tpl.writeText(txt, l_dimsLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")))->"));
        txt = contextCref(txt, i_componentRef, a_context);
      then txt;

    case ( txt,
           i_cr,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt_11 = CodegenUtil.crefStr(Tpl.emptyTxt, i_cr);
        ret_12 = System.unquoteIdentifier(Tpl.textString(txt_11));
        txt = Tpl.writeStr(txt, ret_12);
      then txt;
  end match;
end fun_421;

protected function fun_422
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           a_cr )
      equation
        txt = fun_419(txt, a_cr, i_context);
      then txt;

    case ( txt,
           (i_context as SimCode.PARALLEL_FUNCTION_CONTEXT()),
           a_cr )
      equation
        txt = fun_421(txt, a_cr, i_context);
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = cref(txt, a_cr);
      then txt;
  end match;
end fun_422;

public function contextCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_422(txt, a_context, a_cr);
end contextCref;

protected function fun_424
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Absyn.Ident in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Ident a_name;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           SimCode.PARALLEL_FUNCTION_CONTEXT(),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = Tpl.writeStr(txt, a_name);
      then txt;
  end match;
end fun_424;

public function contextIteratorName
  input Tpl.Text txt;
  input Absyn.Ident a_name;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_424(txt, a_context, a_name);
end contextIteratorName;

public function cref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = CodegenUtil.crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = crefToCStr(txt, i_cr);
      then txt;
  end match;
end cref;

public function crefToCStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
        txt = subscriptsToCStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsToCStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = crefToCStr(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefToCStr;

protected function lm_428
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptToCStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_428(txt, rest);
      then txt;
  end match;
end lm_428;

public function subscriptsToCStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$lB"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("$c")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_428(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$rB"));
      then txt;
  end match;
end subscriptsToCStr;

protected function fun_430
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Integer i_i;
      Tpl.Text l_index;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;

    case ( txt,
           DAE.ICONST(integer = i_i) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_i) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           i_exp )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        (l_index, l_preExp, l_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, l_varDecls);
        txt = Tpl.writeText(txt, l_index);
      then txt;
  end match;
end fun_430;

public function subscriptToCStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Integer i_i;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           DAE.INDEX(exp = i_exp) )
      equation
        txt = fun_430(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end match;
end subscriptToCStr;

public function crefM
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = CodegenUtil.crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("P"));
        txt = crefToMStr(txt, i_cr);
      then txt;
  end match;
end crefM;

public function crefToMStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
        txt = subscriptsToMStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsToMStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("P"));
        txt = crefToMStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefToMStr;

protected function lm_434
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptToMStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_434(txt, rest);
      then txt;
  end match;
end lm_434;

public function subscriptsToMStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("lB"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("c")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_434(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rB"));
      then txt;
  end match;
end subscriptsToMStr;

protected function fun_436
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Integer i_i;
      Tpl.Text l_index;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;

    case ( txt,
           DAE.ICONST(integer = i_i) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_i) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           i_exp )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        (l_index, l_preExp, l_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, l_varDecls);
        txt = Tpl.writeText(txt, l_index);
      then txt;
  end match;
end fun_436;

public function subscriptToMStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Integer i_i;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           DAE.INDEX(exp = i_exp) )
      equation
        txt = fun_436(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end match;
end subscriptToMStr;

protected function fun_438
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = arrayCrefStr(txt, a_cr);
      then txt;

    case ( txt,
           SimCode.PARALLEL_FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = arrayCrefStr(txt, a_cr);
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = arrayCrefCStr(txt, a_cr);
      then txt;
  end match;
end fun_438;

public function contextArrayCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_438(txt, a_context, a_cr);
end contextArrayCref;

public function arrayCrefCStr
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
  out_txt := arrayCrefCStr2(out_txt, a_cr);
end arrayCrefCStr;

public function arrayCrefCStr2
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsToCStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = arrayCrefCStr2(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end arrayCrefCStr2;

public function arrayCrefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("._"));
        txt = arrayCrefStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end arrayCrefStr;

public function expCref
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ecr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_arg_componentRef;
      DAE.ComponentRef i_componentRef;

    case ( txt,
           DAE.CREF(componentRef = i_componentRef) )
      equation
        txt = cref(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P$DER"));
        txt = cref(txt, i_arg_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ERROR_NOT_A_CREF"));
      then txt;
  end match;
end expCref;

public function crefFunctionName
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        ret_1 = System.stringReplace(ret_0, "_", "__");
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        ret_2 = System.unquoteIdentifier(i_ident);
        ret_3 = System.stringReplace(ret_2, "_", "__");
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefFunctionName(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end crefFunctionName;

public function replaceDotAndUnderscore
  input Tpl.Text in_txt;
  input String in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_str)
    local
      Tpl.Text txt;
      String i_name;
      String ret_4;
      String ret_3;
      Tpl.Text l_str__underscores;
      String ret_1;
      Tpl.Text l_str__dots;

    case ( txt,
           i_name )
      equation
        ret_1 = System.stringReplace(i_name, ".", "_");
        l_str__dots = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_3 = System.stringReplace(Tpl.textString(l_str__dots), "_", "__");
        l_str__underscores = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        ret_4 = System.unquoteIdentifier(Tpl.textString(l_str__underscores));
        txt = Tpl.writeStr(txt, ret_4);
      then txt;
  end match;
end replaceDotAndUnderscore;

public function underscorePath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end underscorePath;

protected function lm_447
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_447(txt, rest);
      then txt;
  end match;
end lm_447;

public function externalFunctionIncludes
  input Tpl.Text in_txt;
  input list<String> in_a_includes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_includes)
    local
      Tpl.Text txt;
      list<String> i_includes;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_includes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_447(txt, i_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif"
                                }, false));
      then txt;
  end match;
end externalFunctionIncludes;

protected function lm_449
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = functionHeader(txt, i_fn, false);
        txt = Tpl.nextIter(txt);
        txt = lm_449(txt, rest);
      then txt;
  end match;
end lm_449;

public function functionHeaders
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_449(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end functionHeaders;

protected function lm_451
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = parallelFunctionHeader(txt, i_fn, false);
        txt = Tpl.nextIter(txt);
        txt = lm_451(txt, rest);
      then txt;
  end match;
end lm_451;

public function parallelFunctionHeadersImpl
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_451(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end parallelFunctionHeadersImpl;

protected function lm_453
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = lm_453(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_453(txt, rest);
      then txt;
  end match;
end lm_453;

protected function lm_454
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = funArgBoxedDefinition(txt, i_var);
        txt = lm_454(txt, rest);
      then txt;
  end match;
end lm_454;

protected function fun_455
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Variable> in_a_funArgs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_funArgs)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_funArgs;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_funArgs )
      equation
        txt = lm_454(txt, a_funArgs);
      then txt;
  end match;
end fun_455;

protected function fun_456
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_funArgsBoxedStr;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_funArgsBoxedStr, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_funArgsBoxedStr;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_funArgsBoxedStr,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "DLLExport\n",
                                    "modelica_metatype boxptr_"
                                }, false));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData_t *"));
        txt = Tpl.writeText(txt, a_funArgsBoxedStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_456;

public function functionHeader
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      list<SimCode.Variable> i_funArgs;
      SimCode.Function i_fn;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Variable> i_functionArguments;
      Absyn.Path i_name;
      Boolean ret_15;
      Tpl.Text l_boxedHeader;
      Boolean ret_13;
      Tpl.Text l_funArgsBoxedStr;
      Tpl.Text l_funArgsStr;
      Tpl.Text l_fname;
      Boolean ret_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Boolean ret_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Boolean ret_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, functionArguments = i_functionArguments, outVars = i_outVars)),
           a_inFunc )
      equation
        txt_0 = underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderNormal(txt, Tpl.textString(txt_0), i_functionArguments, i_outVars, a_inFunc, false);
        txt = Tpl.softNewLine(txt);
        txt_1 = underscorePath(Tpl.emptyTxt, i_name);
        ret_2 = SimCodeUtil.isBoxedFunction(i_fn);
        txt = functionHeaderBoxed(txt, Tpl.textString(txt_1), i_functionArguments, i_outVars, ret_2, false);
      then txt;

    case ( txt,
           SimCode.KERNEL_FUNCTION(name = i_name, functionArguments = i_functionArguments, outVars = i_outVars),
           _ )
      equation
        txt_3 = underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderKernelFunctionInterface(txt, Tpl.textString(txt_3), i_functionArguments, i_outVars);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(dynamicLoad = true, name = i_name, funArgs = i_funArgs, outVars = i_outVars)),
           a_inFunc )
      equation
        txt_4 = underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderNormal(txt, Tpl.textString(txt_4), i_funArgs, i_outVars, a_inFunc, true);
        txt = Tpl.softNewLine(txt);
        txt_5 = underscorePath(Tpl.emptyTxt, i_name);
        ret_6 = SimCodeUtil.isBoxedFunction(i_fn);
        txt = functionHeaderBoxed(txt, Tpl.textString(txt_5), i_funArgs, i_outVars, ret_6, true);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = extFunDefDynamic(txt, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name, funArgs = i_funArgs, outVars = i_outVars)),
           a_inFunc )
      equation
        txt_7 = underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderNormal(txt, Tpl.textString(txt_7), i_funArgs, i_outVars, a_inFunc, false);
        txt = Tpl.softNewLine(txt);
        txt_8 = underscorePath(Tpl.emptyTxt, i_name);
        ret_9 = SimCodeUtil.isBoxedFunction(i_fn);
        txt = functionHeaderBoxed(txt, Tpl.textString(txt_8), i_funArgs, i_outVars, ret_9, false);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = extFunDef(txt, i_fn);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs),
           _ )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_funArgsStr = lm_453(Tpl.emptyTxt, i_funArgs);
        ret_13 = Config.acceptMetaModelicaGrammar();
        l_funArgsBoxedStr = fun_455(Tpl.emptyTxt, ret_13, i_funArgs);
        ret_15 = Config.acceptMetaModelicaGrammar();
        l_boxedHeader = fun_456(Tpl.emptyTxt, ret_15, l_funArgsBoxedStr, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_rettype_s {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" c1;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_rettype;\n",
                                    "\n",
                                    "DLLExport\n"
                                }, true));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype omc_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData_t *threadData"));
        txt = Tpl.writeText(txt, l_funArgsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "); /* record head */\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_boxedHeader);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionHeader;

public function parallelFunctionHeader
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Variable> i_functionArguments;
      Absyn.Path i_name;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.PARALLEL_FUNCTION(name = i_name, functionArguments = i_functionArguments, outVars = i_outVars),
           a_inFunc )
      equation
        txt_0 = underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderParallelImpl(txt, Tpl.textString(txt_0), i_functionArguments, i_outVars, a_inFunc, false);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end parallelFunctionHeader;

protected function lm_459
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_459(txt, rest);
      then txt;
  end match;
end lm_459;

protected function lm_460
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_fname)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      String a_fname;
      Integer x_i1;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_fname )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype_"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" c"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.nextIter(txt);
        txt = lm_460(txt, rest, a_fname);
      then txt;
  end match;
end lm_460;

protected function lm_461
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_461(txt, rest);
      then txt;
  end match;
end lm_461;

protected function fun_462
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_461(txt, i_dims);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_462;

protected function fun_463
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_boxed, in_a_var)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;

    case ( txt,
           false,
           a_var )
      equation
        txt = varType(txt, a_var);
      then txt;

    case ( txt,
           _,
           a_var )
      equation
        txt = varTypeBoxed(txt, a_var);
      then txt;
  end match;
end fun_463;

protected function fun_464
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_i1;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_i1, in_a_boxed)
    local
      Tpl.Text txt;
      Integer a_i1;
      Boolean a_boxed;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;
      DAE.Type i_ty;
      Tpl.Text l_typeStr;
      Tpl.Text l_dimStr;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = i_ty, name = i_name)),
           a_i1,
           a_boxed )
      equation
        l_dimStr = fun_462(Tpl.emptyTxt, i_ty);
        l_typeStr = fun_463(Tpl.emptyTxt, a_boxed, i_var);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" c"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = Tpl.writeText(txt, l_dimStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_i1,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr c"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = Tpl.writeStr(txt, i_name_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_464;

protected function lm_465
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_boxed)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_boxed;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_boxed )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_464(txt, i_var, x_i1, a_boxed);
        txt = Tpl.nextIter(txt);
        txt = lm_465(txt, rest, a_boxed);
      then txt;
  end match;
end lm_465;

protected function fun_466
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fargsStr;
  input Boolean in_a_boxed;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fargsStr, in_a_boxed, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStr;
      Boolean a_boxed;
      String a_fname;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_outVars,
           a_fargsStr,
           a_boxed,
           a_fname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_460(txt, i_outVars, a_fname);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_rettype_s\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_465(txt, i_outVars, a_boxed);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_rettype;\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype omc_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
      then txt;
  end match;
end fun_466;

public function functionHeaderParallelImpl
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_inFunc;
  input Boolean a_boxed;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_fargsStr;
algorithm
  l_fargsStr := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_fargsStr := lm_459(l_fargsStr, a_fargs);
  l_fargsStr := Tpl.popIter(l_fargsStr);
  out_txt := fun_466(txt, a_outVars, l_fargsStr, a_boxed, a_fname);
end functionHeaderParallelImpl;

protected function lm_468
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"_"));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.nextIter(txt);
        txt = lm_468(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_468(txt, rest);
      then txt;
  end match;
end lm_468;

protected function lm_469
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_name :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.nextIter(txt);
        txt = lm_469(txt, rest);
      then txt;
  end match;
end lm_469;

public function recordDeclaration
  input Tpl.Text in_txt;
  input SimCode.RecordDeclaration in_a_recDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_recDecl)
    local
      Tpl.Text txt;
      list<String> i_fieldNames;
      Absyn.Path i_path;
      list<SimCode.Variable> i_variables;
      Absyn.Path i_defPath;
      Integer ret_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Integer ret_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.RECORD_DECL_FULL(defPath = i_defPath, variables = i_variables) )
      equation
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_defPath);
        txt_1 = underscorePath(Tpl.emptyTxt, i_defPath);
        txt_2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_468(txt_2, i_variables);
        txt_2 = Tpl.popIter(txt_2);
        ret_3 = listLength(i_variables);
        txt = recordDefinition(txt, Tpl.textString(txt_0), Tpl.textString(txt_1), Tpl.textString(txt_2), ret_3);
      then txt;

    case ( txt,
           SimCode.RECORD_DECL_DEF(path = i_path, fieldNames = i_fieldNames) )
      equation
        txt_4 = CodegenUtil.dotPath(Tpl.emptyTxt, i_path);
        txt_5 = underscorePath(Tpl.emptyTxt, i_path);
        txt_6 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_6 = lm_469(txt_6, i_fieldNames);
        txt_6 = Tpl.popIter(txt_6);
        ret_7 = listLength(i_fieldNames);
        txt = recordDefinition(txt, Tpl.textString(txt_4), Tpl.textString(txt_5), Tpl.textString(txt_6), ret_7);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end recordDeclaration;

protected function lm_471
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_var_name;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name)) :: rest )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = CodegenUtil.crefStr(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_471(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_471(txt, rest);
      then txt;
  end match;
end lm_471;

public function recordDeclarationHeader
  input Tpl.Text in_txt;
  input SimCode.RecordDeclaration in_a_recDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_recDecl)
    local
      Tpl.Text txt;
      list<String> i_fieldNames;
      Absyn.Path i_path;
      Absyn.Path i_defPath;
      list<SimCode.Variable> i_variables;
      String i_name;
      Integer ret_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Integer ret_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.RECORD_DECL_FULL(name = i_name, variables = i_variables, defPath = i_defPath) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_s {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_471(txt, i_variables);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "typedef base_array_t "
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_array;\n",
                                    "\n"
                                }, true));
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_defPath);
        txt_1 = underscorePath(Tpl.emptyTxt, i_defPath);
        ret_2 = listLength(i_variables);
        txt = recordDefinitionHeader(txt, Tpl.textString(txt_0), Tpl.textString(txt_1), ret_2);
      then txt;

    case ( txt,
           SimCode.RECORD_DECL_DEF(path = i_path, fieldNames = i_fieldNames) )
      equation
        txt_3 = CodegenUtil.dotPath(Tpl.emptyTxt, i_path);
        txt_4 = underscorePath(Tpl.emptyTxt, i_path);
        ret_5 = listLength(i_fieldNames);
        txt = recordDefinitionHeader(txt, Tpl.textString(txt_3), Tpl.textString(txt_4), ret_5);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end recordDeclarationHeader;

protected function fun_473
  input Tpl.Text in_txt;
  input Integer in_a_numFields;
  input String in_a_fieldNames;
  input String in_a_encName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_numFields, in_a_fieldNames, in_a_encName)
    local
      Tpl.Text txt;
      String a_fieldNames;
      String a_encName;
      Integer i_numFields;

    case ( txt,
           0,
           _,
           a_encName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char* "));
        txt = Tpl.writeStr(txt, a_encName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc__fields[1] = {\"no fields\"};"));
      then txt;

    case ( txt,
           i_numFields,
           a_fieldNames,
           a_encName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char* "));
        txt = Tpl.writeStr(txt, a_encName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc__fields["));
        txt = Tpl.writeStr(txt, intString(i_numFields));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = {"));
        txt = Tpl.writeStr(txt, a_fieldNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end match;
end fun_473;

public function recordDefinition
  input Tpl.Text txt;
  input String a_origName;
  input String a_encName;
  input String a_fieldNames;
  input Integer a_numFields;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_fieldsDescription;
algorithm
  l_fieldsDescription := fun_473(Tpl.emptyTxt, a_numFields, a_fieldNames, a_encName);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__desc_added 1\n"));
  out_txt := Tpl.writeText(out_txt, l_fieldsDescription);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("struct record_description "));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__desc = {\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\", /* package_record__X */\n",
                                       "\""
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, a_origName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("\", /* package.record_X */\n"));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__desc__fields\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("};"));
end recordDefinition;

public function recordDefinitionHeader
  input Tpl.Text txt;
  input String a_origName;
  input String a_encName;
  input Integer a_numFields;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("extern struct record_description "));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("__desc;"));
end recordDefinitionHeader;

public function functionHeaderNormal
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_inFunc;
  input Boolean a_dynamicLoad;

  output Tpl.Text out_txt;
algorithm
  out_txt := functionHeaderImpl(txt, a_fname, a_fargs, a_outVars, a_inFunc, false, a_dynamicLoad);
end functionHeaderNormal;

protected function fun_477
  input Tpl.Text in_txt;
  input Boolean in_a_isBoxed;
  input Boolean in_a_dynamicLoad;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_fargs;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isBoxed, in_a_dynamicLoad, in_a_outVars, in_a_fargs, in_a_fname)
    local
      Tpl.Text txt;
      Boolean a_dynamicLoad;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_fargs;
      String a_fname;

    case ( txt,
           false,
           a_dynamicLoad,
           a_outVars,
           a_fargs,
           a_fname )
      equation
        txt = functionHeaderImpl(txt, a_fname, a_fargs, a_outVars, false, true, a_dynamicLoad);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define boxptr_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" omc_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_477;

protected function fun_478
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fname;
  input list<SimCode.Variable> in_a_fargs;
  input list<SimCode.Variable> in_a_outVars;
  input Boolean in_a_isBoxed;
  input Boolean in_a_dynamicLoad;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fname, in_a_fargs, in_a_outVars, in_a_isBoxed, in_a_dynamicLoad)
    local
      Tpl.Text txt;
      String a_fname;
      list<SimCode.Variable> a_fargs;
      list<SimCode.Variable> a_outVars;
      Boolean a_isBoxed;
      Boolean a_dynamicLoad;

    case ( txt,
           false,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname,
           a_fargs,
           a_outVars,
           a_isBoxed,
           a_dynamicLoad )
      equation
        txt = fun_477(txt, a_isBoxed, a_dynamicLoad, a_outVars, a_fargs, a_fname);
      then txt;
  end match;
end fun_478;

public function functionHeaderBoxed
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_isBoxed;
  input Boolean a_dynamicLoad;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_478(txt, ret_0, a_fname, a_fargs, a_outVars, a_isBoxed, a_dynamicLoad);
end functionHeaderBoxed;

protected function lm_480
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = funArgDefinition(txt, i_var);
        txt = lm_480(txt, rest);
      then txt;
  end match;
end lm_480;

protected function lm_481
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = funArgBoxedDefinition(txt, i_var);
        txt = lm_481(txt, rest);
      then txt;
  end match;
end lm_481;

protected function fun_482
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input list<SimCode.Variable> in_a_fargs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_boxed, in_a_fargs)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_fargs;

    case ( txt,
           false,
           a_fargs )
      equation
        txt = lm_480(txt, a_fargs);
      then txt;

    case ( txt,
           _,
           a_fargs )
      equation
        txt = lm_481(txt, a_fargs);
      then txt;
  end match;
end fun_482;

protected function fun_483
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_boxed)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boxed"));
      then txt;
  end match;
end fun_483;

protected function fun_484
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_boxed)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omc"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boxptr"));
      then txt;
  end match;
end fun_484;

protected function fun_485
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inFunc, in_a_fname)
    local
      Tpl.Text txt;
      String a_fname;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "DLLExport\n",
                                    "int in_"
                                }, false));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(type_description * inArgs, type_description * outVar);"));
      then txt;
  end match;
end fun_485;

protected function fun_486
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input String in_a_fname;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_boxed, in_a_fname, in_a_inFunc)
    local
      Tpl.Text txt;
      String a_fname;
      Boolean a_inFunc;

    case ( txt,
           false,
           a_fname,
           a_inFunc )
      equation
        txt = fun_485(txt, a_inFunc, a_fname);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_486;

protected function fun_487
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input Tpl.Text in_a_fargsStr;
  input String in_a_fname;
  input Tpl.Text in_a_boxPtrStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dynamicLoad, in_a_fargsStr, in_a_fname, in_a_boxPtrStr)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStr;
      String a_fname;
      Tpl.Text a_boxPtrStr;

    case ( txt,
           false,
           a_fargsStr,
           a_fname,
           a_boxPtrStr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLExport"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_boxPtrStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData_t *threadData"));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_487;

protected function lm_488
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_488(txt, rest);
      then txt;
  end match;
end lm_488;

protected function fun_489
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_488(txt, i_dims);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_489;

protected function fun_490
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_boxed, in_a_var)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;

    case ( txt,
           false,
           a_var )
      equation
        txt = varType(txt, a_var);
      then txt;

    case ( txt,
           _,
           a_var )
      equation
        txt = varTypeBoxed(txt, a_var);
      then txt;
  end match;
end fun_490;

protected function fun_491
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_i1;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_i1, in_a_boxed)
    local
      Tpl.Text txt;
      Integer a_i1;
      Boolean a_boxed;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;
      DAE.Type i_ty;
      Tpl.Text l_typeStr;
      Tpl.Text l_dimStr;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = i_ty, name = i_name)),
           a_i1,
           a_boxed )
      equation
        l_dimStr = fun_489(Tpl.emptyTxt, i_ty);
        l_typeStr = fun_490(Tpl.emptyTxt, a_boxed, i_var);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" c"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = Tpl.writeText(txt, l_dimStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_i1,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr c"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = Tpl.writeStr(txt, i_name_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_491;

protected function lm_492
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_boxed)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_boxed;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_boxed )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_491(txt, i_var, x_i1, a_boxed);
        txt = Tpl.nextIter(txt);
        txt = lm_492(txt, rest, a_boxed);
      then txt;
  end match;
end lm_492;

protected function fun_493
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input Tpl.Text in_a_fargsStr;
  input Tpl.Text in_a_boxPtrStr;
  input Tpl.Text in_a_boxStr;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dynamicLoad, in_a_fargsStr, in_a_boxPtrStr, in_a_boxStr, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStr;
      Tpl.Text a_boxPtrStr;
      Tpl.Text a_boxStr;
      String a_fname;

    case ( txt,
           false,
           a_fargsStr,
           a_boxPtrStr,
           a_boxStr,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLExport"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
        txt = Tpl.writeText(txt, a_boxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_boxPtrStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData_t *threadData"));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_493;

protected function fun_494
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_inFnStr;
  input Boolean in_a_boxed;
  input Tpl.Text in_a_boxStr;
  input Tpl.Text in_a_fargsStr;
  input String in_a_fname;
  input Tpl.Text in_a_boxPtrStr;
  input Boolean in_a_dynamicLoad;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_inFnStr, in_a_boxed, in_a_boxStr, in_a_fargsStr, in_a_fname, in_a_boxPtrStr, in_a_dynamicLoad)
    local
      Tpl.Text txt;
      Tpl.Text a_inFnStr;
      Boolean a_boxed;
      Tpl.Text a_boxStr;
      Tpl.Text a_fargsStr;
      String a_fname;
      Tpl.Text a_boxPtrStr;
      Boolean a_dynamicLoad;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           {},
           _,
           _,
           _,
           a_fargsStr,
           a_fname,
           a_boxPtrStr,
           a_dynamicLoad )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_487(txt, a_dynamicLoad, a_fargsStr, a_fname, a_boxPtrStr);
      then txt;

    case ( txt,
           i_outVars,
           a_inFnStr,
           a_boxed,
           a_boxStr,
           a_fargsStr,
           a_fname,
           a_boxPtrStr,
           a_dynamicLoad )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
        txt = Tpl.writeText(txt, a_boxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_s {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_492(txt, i_outVars, a_boxed);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
        txt = Tpl.writeText(txt, a_boxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, a_inFnStr);
        txt = Tpl.softNewLine(txt);
        txt = fun_493(txt, a_dynamicLoad, a_fargsStr, a_boxPtrStr, a_boxStr, a_fname);
      then txt;
  end match;
end fun_494;

public function functionHeaderImpl
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_inFunc;
  input Boolean a_boxed;
  input Boolean a_dynamicLoad;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_inFnStr;
  Tpl.Text l_boxPtrStr;
  Tpl.Text l_boxStr;
  Tpl.Text l_fargsStr;
algorithm
  l_fargsStr := fun_482(Tpl.emptyTxt, a_boxed, a_fargs);
  l_boxStr := fun_483(Tpl.emptyTxt, a_boxed);
  l_boxPtrStr := fun_484(Tpl.emptyTxt, a_boxed);
  l_inFnStr := fun_486(Tpl.emptyTxt, a_boxed, a_fname, a_inFunc);
  out_txt := fun_494(txt, a_outVars, l_inFnStr, a_boxed, l_boxStr, l_fargsStr, a_fname, l_boxPtrStr, a_dynamicLoad);
end functionHeaderImpl;

protected function lm_496
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinitionKernelFunctionInterface(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_496(txt, rest);
      then txt;
  end match;
end lm_496;

protected function lm_497
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_497(txt, rest);
      then txt;
  end match;
end lm_497;

protected function fun_498
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_497(txt, i_dims);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_498;

protected function fun_499
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_i1)
    local
      Tpl.Text txt;
      Integer a_i1;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;
      DAE.Type i_ty;
      Tpl.Text l_typeStr;
      Tpl.Text l_dimStr;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = i_ty, name = i_name)),
           a_i1 )
      equation
        l_dimStr = fun_498(Tpl.emptyTxt, i_ty);
        l_typeStr = varType(Tpl.emptyTxt, i_var);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" c"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = Tpl.writeText(txt, l_dimStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_i1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr c"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = Tpl.writeStr(txt, i_name_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_499;

protected function lm_500
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_499(txt, i_var, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_500(txt, rest);
      then txt;
  end match;
end lm_500;

protected function fun_501
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fargsStr;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fargsStr, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStr;
      String a_fname;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           {},
           a_fargsStr,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void _"
                                }, false));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           i_outVars,
           a_fargsStr,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_rettype_s {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_500(txt, i_outVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_rettype;\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype omc_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_501;

public function functionHeaderKernelFunctionInterface
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_fargsStr;
algorithm
  l_fargsStr := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_fargsStr := lm_496(l_fargsStr, a_fargs);
  l_fargsStr := Tpl.popIter(l_fargsStr);
  out_txt := fun_501(txt, a_outVars, l_fargsStr, a_fname);
end functionHeaderKernelFunctionInterface;

public function funArgName
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.VARIABLE(name = i_name) )
      equation
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end funArgName;

public function funArgDefinition
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end funArgDefinition;

public function funArgDefinitionKernelFunctionInterface
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = DAE.T_ARRAY(ty = _), name = i_name)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("device_"));
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Invalid function argument to Kernel function Interface."));
      then txt;
  end match;
end funArgDefinitionKernelFunctionInterface;

protected function fun_506
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_varName, in_a_var_ty)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;

    case ( txt,
           {},
           a_varName,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           _,
           a_varName,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* data_"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    __global modelica_integer* info_"));
        txt = Tpl.writeText(txt, a_varName);
      then txt;
  end match;
end fun_506;

public function funArgDefinitionKernelFunctionBody
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      list<DAE.Exp> i_instDims;
      DAE.Type i_var_ty;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(ty = (i_var_ty as DAE.T_ARRAY(ty = _)), name = i_var_name) )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_"));
        txt = expTypeShort(txt, i_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* data_"));
        txt = Tpl.writeText(txt, l_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    __global modelica_integer* info_"));
        txt = Tpl.writeText(txt, l_varName);
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, ty = i_var_ty) )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction);
        txt = fun_506(txt, i_instDims, l_varName, i_var_ty);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#error Unknown variable type in as function argument funArgDefinitionKernelFunctionBody"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end funArgDefinitionKernelFunctionBody;

protected function fun_508
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_parArgList;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_parArgList;
algorithm
  (out_txt, out_a_parArgList) :=
  match(in_txt, in_a_instDims, in_a_varName, in_a_var_ty, in_a_parArgList)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;
      Tpl.Text a_parArgList;

    case ( txt,
           {},
           a_varName,
           a_var_ty,
           a_parArgList )
      equation
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING(","));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_NEW_LINE());
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("    modelica_"));
        a_parArgList = expTypeShort(a_parArgList, a_var_ty);
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING(" "));
        a_parArgList = Tpl.writeText(a_parArgList, a_varName);
      then (txt, a_parArgList);

    case ( txt,
           _,
           a_varName,
           a_var_ty,
           a_parArgList )
      equation
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING(","));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_NEW_LINE());
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("    __global modelica_"));
        a_parArgList = expTypeShort(a_parArgList, a_var_ty);
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("* data_"));
        a_parArgList = Tpl.writeText(a_parArgList, a_varName);
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING(","));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_NEW_LINE());
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("    __global modelica_integer* info_"));
        a_parArgList = Tpl.writeText(a_parArgList, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_parArgList);
  end match;
end fun_508;

public function funArgDefinitionKernelFunctionBody2
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_parArgList;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_parArgList;
algorithm
  (out_txt, out_a_parArgList) :=
  match(in_txt, in_a_var, in_a_parArgList)
    local
      Tpl.Text txt;
      Tpl.Text a_parArgList;
      list<DAE.Exp> i_instDims;
      DAE.Type i_var_ty;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(ty = (i_var_ty as DAE.T_ARRAY(ty = _)), name = i_var_name),
           a_parArgList )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction);
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING(","));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_NEW_LINE());
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("    __global modelica_"));
        a_parArgList = expTypeShort(a_parArgList, i_var_ty);
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("* data_"));
        a_parArgList = Tpl.writeText(a_parArgList, l_varName);
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING(","));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_NEW_LINE());
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("    __global modelica_integer* info_"));
        a_parArgList = Tpl.writeText(a_parArgList, l_varName);
      then (txt, a_parArgList);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, ty = i_var_ty),
           a_parArgList )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction);
        (txt, a_parArgList) = fun_508(txt, i_instDims, l_varName, i_var_ty, a_parArgList);
      then (txt, a_parArgList);

    case ( txt,
           _,
           a_parArgList )
      equation
        a_parArgList = Tpl.pushBlock(a_parArgList, Tpl.BT_INDENT(4));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("#error Unknown variable type in as function argument funArgDefinitionKernelFunctionBody2"));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_NEW_LINE());
        a_parArgList = Tpl.popBlock(a_parArgList);
      then (txt, a_parArgList);
  end match;
end funArgDefinitionKernelFunctionBody2;

protected function fun_510
  input Tpl.Text in_txt;
  input DAE.Type in_a_cref_identType;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cref_identType, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)),
           a_varName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_integer* data_"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_integer* info_"));
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_REAL(varLst = _)),
           a_varName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_real* data_"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_integer* info_"));
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Template error in parFunArgDefinitionFromLooptupleVar"));
      then txt;
  end match;
end fun_510;

protected function fun_511
  input Tpl.Text in_txt;
  input DAE.Type in_a_cref_identType;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cref_identType, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_varName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_integer "));
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_varName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_real "));
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Tempalte error in parFunArgDefinitionFromLooptupleVar"));
      then txt;
  end match;
end fun_511;

public function parFunArgDefinitionFromLooptupleVar
  input Tpl.Text in_txt;
  input tuple<DAE.ComponentRef, Absyn.Info> in_a_tupleVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_tupleVar)
    local
      Tpl.Text txt;
      DAE.Type i_cref_identType;
      DAE.ComponentRef i_cref;
      Tpl.Text l_varName;

    case ( txt,
           ((i_cref as DAE.CREF_IDENT(identType = (i_cref_identType as DAE.T_ARRAY(ty = _)))), _) )
      equation
        l_varName = contextArrayCref(Tpl.emptyTxt, i_cref, SimCode.contextParallelFunction);
        txt = fun_510(txt, i_cref_identType, l_varName);
      then txt;

    case ( txt,
           ((i_cref as DAE.CREF_IDENT(identType = i_cref_identType)), _) )
      equation
        l_varName = contextArrayCref(Tpl.emptyTxt, i_cref, SimCode.contextParallelFunction);
        txt = fun_511(txt, i_cref_identType, l_varName);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end parFunArgDefinitionFromLooptupleVar;

protected function fun_513
  input Tpl.Text in_txt;
  input DAE.Type in_a_cref_identType;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_reconstructedArrs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reconstructedArrs;
algorithm
  (out_txt, out_a_reconstructedArrs) :=
  match(in_txt, in_a_cref_identType, in_a_varName, in_a_reconstructedArrs)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      Tpl.Text a_reconstructedArrs;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)),
           a_varName,
           a_reconstructedArrs )
      equation
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("integer_array "));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".data = data_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".ndims = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("[0]; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".dim_size = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(" + 1; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
      then (txt, a_reconstructedArrs);

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_REAL(varLst = _)),
           a_varName,
           a_reconstructedArrs )
      equation
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("real_array "));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".data = data_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".ndims = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("[0]; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".dim_size = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(" + 1; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
      then (txt, a_reconstructedArrs);

    case ( txt,
           _,
           _,
           a_reconstructedArrs )
      equation
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("#wiered variable in kerenl reconstruction of arrays"));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
      then (txt, a_reconstructedArrs);
  end match;
end fun_513;

public function reconstructKernelArraysFromLooptupleVars
  input Tpl.Text in_txt;
  input tuple<DAE.ComponentRef, Absyn.Info> in_a_tupleVar;
  input Tpl.Text in_a_reconstructedArrs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reconstructedArrs;
algorithm
  (out_txt, out_a_reconstructedArrs) :=
  match(in_txt, in_a_tupleVar, in_a_reconstructedArrs)
    local
      Tpl.Text txt;
      Tpl.Text a_reconstructedArrs;
      DAE.Type i_cref_identType;
      DAE.ComponentRef i_cref;
      Tpl.Text l_varName;

    case ( txt,
           ((i_cref as DAE.CREF_IDENT(identType = (i_cref_identType as DAE.T_ARRAY(ty = _)))), _),
           a_reconstructedArrs )
      equation
        l_varName = contextArrayCref(Tpl.emptyTxt, i_cref, SimCode.contextParallelFunction);
        (txt, a_reconstructedArrs) = fun_513(txt, i_cref_identType, l_varName, a_reconstructedArrs);
      then (txt, a_reconstructedArrs);

    case ( txt,
           _,
           a_reconstructedArrs )
      then (txt, a_reconstructedArrs);
  end match;
end reconstructKernelArraysFromLooptupleVars;

protected function fun_515
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_reconstructedArrs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reconstructedArrs;
algorithm
  (out_txt, out_a_reconstructedArrs) :=
  match(in_txt, in_a_instDims, in_a_varName, in_a_var_ty, in_a_reconstructedArrs)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;
      Tpl.Text a_reconstructedArrs;

    case ( txt,
           {},
           _,
           _,
           a_reconstructedArrs )
      then (txt, a_reconstructedArrs);

    case ( txt,
           _,
           a_varName,
           a_var_ty,
           a_reconstructedArrs )
      equation
        a_reconstructedArrs = expTypeShort(a_reconstructedArrs, a_var_ty);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("_array "));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".data = data_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".ndims = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("[0]; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".dim_size = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(" + 1; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_reconstructedArrs);
  end match;
end fun_515;

public function reconstructKernelArrays
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_reconstructedArrs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reconstructedArrs;
algorithm
  (out_txt, out_a_reconstructedArrs) :=
  match(in_txt, in_a_var, in_a_reconstructedArrs)
    local
      Tpl.Text txt;
      Tpl.Text a_reconstructedArrs;
      list<DAE.Exp> i_instDims;
      DAE.Type i_var_ty;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(ty = (i_var_ty as DAE.T_ARRAY(ty = _)), name = i_var_name),
           a_reconstructedArrs )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction);
        a_reconstructedArrs = expTypeShort(a_reconstructedArrs, i_var_ty);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("_array "));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".data = data_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".ndims = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("[0]; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".dim_size = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(" + 1; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
      then (txt, a_reconstructedArrs);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, ty = i_var_ty),
           a_reconstructedArrs )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction);
        (txt, a_reconstructedArrs) = fun_515(txt, i_instDims, l_varName, i_var_ty, a_reconstructedArrs);
      then (txt, a_reconstructedArrs);

    case ( txt,
           _,
           a_reconstructedArrs )
      equation
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("#wiered variable in kerenl reconstruction of arrays"));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
      then (txt, a_reconstructedArrs);
  end match;
end reconstructKernelArrays;

public function funArgBoxedDefinition
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.VARIABLE(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end funArgBoxedDefinition;

public function extFunDef
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;
      list<SimCode.SimExtArg> i_extArgs;
      String i_language;
      String i_extName;
      Tpl.Text l_fargsStr;
      Tpl.Text l_fn__name;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extName = i_extName, language = i_language, extArgs = i_extArgs, extReturn = i_extReturn) )
      equation
        l_fn__name = extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        l_fargsStr = extFunDefArgs(Tpl.emptyTxt, i_extArgs, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extern "));
        txt = extReturnType(txt, i_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end extFunDef;

public function extFunDefDynamic
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;
      list<SimCode.SimExtArg> i_extArgs;
      String i_language;
      String i_extName;
      Tpl.Text l_fargsStr;
      Tpl.Text l_fn__name;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extName = i_extName, language = i_language, extArgs = i_extArgs, extReturn = i_extReturn) )
      equation
        l_fn__name = extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        l_fargsStr = extFunDefArgs(Tpl.emptyTxt, i_extArgs, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef "));
        txt = extReturnType(txt, i_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" (*ptrT_"));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, l_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "extern ptrT_"
                                }, false));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ptr_"));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end extFunDefDynamic;

protected function fun_520
  input Tpl.Text in_txt;
  input String in_a_language;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_language, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           "FORTRAN 77",
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4292, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_520;

public function extFunctionName
  input Tpl.Text txt;
  input String a_name;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_520(txt, a_language, a_name);
end extFunctionName;

protected function lm_522
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunDefArg(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_522(txt, rest);
      then txt;
  end match;
end lm_522;

protected function lm_523
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunDefArgF77(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_523(txt, rest);
      then txt;
  end match;
end lm_523;

protected function fun_524
  input Tpl.Text in_txt;
  input String in_a_language;
  input list<SimCode.SimExtArg> in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_language, in_a_args)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> a_args;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_args )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_522(txt, a_args);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           "FORTRAN 77",
           a_args )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_523(txt, a_args);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4300, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_524;

public function extFunDefArgs
  input Tpl.Text txt;
  input list<SimCode.SimExtArg> a_args;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_524(txt, a_language, a_args);
end extFunDefArgs;

public function extReturnType
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.Type i_type__;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           SimCode.SIMEXTARG(type_ = i_type__) )
      equation
        txt = extType(txt, i_type__, true, false);
      then txt;

    case ( txt,
           SimCode.SIMNOEXTARG() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp) )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Expression types are unsupported as return arguments "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4309, 36), Tpl.textString(txt_0));
      then txt;

    case ( txt,
           _ )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4310, 14), "Unsupported return argument");
      then txt;
  end match;
end extReturnType;

protected function fun_527
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isInput;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isInput)
    local
      Tpl.Text txt;
      Boolean a_isInput;
      DAE.Type i_type;
      Absyn.Path i_rname;
      DAE.Type i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char*"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty),
           a_isInput )
      equation
        txt = extType(txt, i_ty, a_isInput, true);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void *"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)),
           _ )
      equation
        txt = underscorePath(txt, i_rname);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr"));
      then txt;

    case ( txt,
           i_type,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external C type "));
        ret_0 = Types.unparseType(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4333, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_527;

protected function fun_528
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "const char*" )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const "));
      then txt;
  end match;
end fun_528;

protected function fun_529
  input Tpl.Text in_txt;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;
      String str_0;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        str_0 = Tpl.textString(a_s);
        txt = fun_528(txt, str_0);
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end match;
end fun_529;

protected function fun_530
  input Tpl.Text in_txt;
  input Boolean in_a_isInput;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isInput, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Tpl.Text a_s;

    case ( txt,
           false,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_s )
      equation
        txt = fun_529(txt, a_isArray, a_s);
      then txt;
  end match;
end fun_530;

protected function fun_531
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isArray;
  input Boolean in_a_isInput;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isArray, in_a_isInput, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Boolean a_isInput;
      Tpl.Text a_s;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           _,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_isInput,
           a_s )
      equation
        txt = fun_530(txt, a_isInput, a_isArray, a_s);
      then txt;
  end match;
end fun_531;

public function extType
  input Tpl.Text txt;
  input DAE.Type a_type;
  input Boolean a_isInput;
  input Boolean a_isArray;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_527(Tpl.emptyTxt, a_type, a_isInput);
  out_txt := fun_531(txt, a_type, a_isArray, a_isInput, l_s);
end extType;

protected function fun_533
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;
      DAE.Type i_type;
      Absyn.Path i_rname;
      DAE.Type i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("char"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = extTypeF77(txt, i_ty, true);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)) )
      equation
        txt = underscorePath(txt, i_rname);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           i_type )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external F77 type "));
        ret_0 = Types.unparseType(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4352, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_533;

protected function fun_534
  input Tpl.Text in_txt;
  input Boolean in_a_isReference;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isReference, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end match;
end fun_534;

protected function fun_535
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isReference;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isReference, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isReference;
      Tpl.Text a_s;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isReference,
           a_s )
      equation
        txt = fun_534(txt, a_isReference, a_s);
      then txt;
  end match;
end fun_535;

public function extTypeF77
  input Tpl.Text txt;
  input DAE.Type a_type;
  input Boolean a_isReference;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_533(Tpl.emptyTxt, a_type);
  out_txt := fun_535(txt, a_type, a_isReference, l_s);
end extTypeF77;

public function extFunDefArg
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Type i_type__;
      Boolean i_ia;
      Boolean i_ii;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = i_ii, isArray = i_ia, type_ = i_t) )
      equation
        l_name = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        l_typeStr = extType(Tpl.emptyTxt, i_t, i_ii, i_ia);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*"));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__) )
      equation
        l_typeStr = extType(Tpl.emptyTxt, i_type__, true, false);
        txt = Tpl.writeText(txt, l_typeStr);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_t"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end extFunDefArg;

public function extFunDefArgF77
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Type i_type__;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, type_ = i_t) )
      equation
        l_name = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        l_typeStr = extTypeF77(Tpl.emptyTxt, i_t, true);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*"));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__) )
      equation
        txt = extTypeF77(txt, i_type__, true);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int *"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end extFunDefArgF77;

protected function fun_539
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = underscorePath(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = CodegenUtil.dotPath(txt, a_name);
      then txt;
  end match;
end fun_539;

protected function fun_540
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = underscorePath(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = CodegenUtil.dotPath(txt, a_name);
      then txt;
  end match;
end fun_540;

protected function fun_541
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = underscorePath(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = CodegenUtil.dotPath(txt, a_name);
      then txt;
  end match;
end fun_541;

public function functionName
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_dotPath;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_dotPath)
    local
      Tpl.Text txt;
      Boolean a_dotPath;
      Absyn.Path i_name;

    case ( txt,
           SimCode.FUNCTION(name = i_name),
           a_dotPath )
      equation
        txt = fun_539(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name),
           a_dotPath )
      equation
        txt = fun_540(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name),
           a_dotPath )
      equation
        txt = fun_541(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionName;

protected function lm_543
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = functionBody(txt, i_fn, false);
        txt = Tpl.nextIter(txt);
        txt = lm_543(txt, rest);
      then txt;
  end match;
end lm_543;

public function functionBodies
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_543(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end functionBodies;

protected function lm_545
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = functionBodyParModelica(txt, i_fn, false);
        txt = Tpl.nextIter(txt);
        txt = lm_545(txt, rest);
      then txt;
  end match;
end lm_545;

public function functionBodiesParModelica
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_545(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end functionBodiesParModelica;

public function functionBody
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = functionBodyRegularFunction(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           (i_fn as SimCode.KERNEL_FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = functionBodyKernelFunctionInterface(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = functionBodyExternalFunction(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           _ )
      equation
        txt = functionBodyRecordConstructor(txt, i_fn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionBody;

public function functionBodyParModelica
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = extractParforBodies(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           (i_fn as SimCode.KERNEL_FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = functionBodyKernelFunction(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           (i_fn as SimCode.PARALLEL_FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = functionBodyParallelFunction(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionBodyParModelica;

protected function fun_549
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_var_name)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;

    case ( txt,
           "modelica_metatype",
           a_var_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_549;

protected function fun_550
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input SimCode.Variable in_a_var;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty, in_a_var, in_a_var_name)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;
      DAE.ComponentRef a_var_name;
      String str_1;
      Tpl.Text l_typ;

    case ( txt,
           DAE.T_METATYPE(ty = _),
           _,
           a_var_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _),
           _,
           a_var_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;

    case ( txt,
           _,
           a_var,
           a_var_name )
      equation
        l_typ = varType(Tpl.emptyTxt, a_var);
        str_1 = Tpl.textString(l_typ);
        txt = fun_549(txt, str_1, a_var_name);
      then txt;
  end match;
end fun_550;

public function addRoots
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      SimCode.Variable i_var;
      DAE.ComponentRef i_var_name;
      DAE.Type i_ty;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = i_ty, name = i_var_name)) )
      equation
        txt = fun_550(txt, i_ty, i_var, i_var_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end addRoots;

protected function lm_552
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = extractParFors(txt, i_stmt, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_552(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_552;

protected function fun_553
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Statement> i_body;
      Tpl.Text l_bodyPart;
      Tpl.Text l_varDecls;

    case ( txt,
           SimCode.FUNCTION(body = i_body) )
      equation
        System.tmpTickReset(1);
        System.tmpTickResetIndex(0, 1);
        l_varDecls = Tpl.emptyTxt;
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bodyPart, l_varDecls) = lm_552(l_bodyPart, i_body, l_varDecls);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        txt = Tpl.writeText(txt, l_bodyPart);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_553;

public function extractParforBodies
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input Boolean a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_553(txt, a_fn);
end extractParforBodies;

protected function fun_555
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
      then txt;
  end match;
end fun_555;

protected function fun_556
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_outVars, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end match;
end fun_556;

protected function fun_557
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_557;

protected function lm_558
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varFrees;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varFrees;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varFrees, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varFrees, in_a_varInits, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varFrees;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varFrees,
           a_varInits,
           a_varDecls )
      then (txt, a_varFrees, a_varInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_varFrees,
           a_varInits,
           a_varDecls )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_varInits, a_varFrees) = varInit(txt, i_var, "", x_i1, a_varDecls, a_varInits, a_varFrees);
        txt = Tpl.nextIter(txt);
        (txt, a_varFrees, a_varInits, a_varDecls) = lm_558(txt, rest, a_varFrees, a_varInits, a_varDecls);
      then (txt, a_varFrees, a_varInits, a_varDecls);
  end match;
end lm_558;

protected function lm_559
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = addRoots(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_559(txt, rest);
      then txt;
  end match;
end lm_559;

protected function lm_560
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = addRoots(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_560(txt, rest);
      then txt;
  end match;
end lm_560;

protected function lm_561
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varInits) :=
  match(in_txt, in_items, in_a_varInits)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varInits;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varInits )
      then (txt, a_varInits);

    case ( txt,
           i_var :: rest,
           a_varInits )
      equation
        (txt, a_varInits) = functionArg(txt, i_var, a_varInits);
        txt = Tpl.nextIter(txt);
        (txt, a_varInits) = lm_561(txt, rest, a_varInits);
      then (txt, a_varInits);
  end match;
end lm_561;

protected function lm_562
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = funStatement(txt, i_stmt, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_562(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_562;

protected function lm_563
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_retVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_retVar;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_retVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign) = varOutput(txt, i_var, Tpl.textString(a_retVar), x_i1, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_563(txt, rest, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_retVar);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end match;
end lm_563;

protected function fun_564
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.Function a_fn;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fn )
      equation
        txt = functionBodyBoxed(txt, a_fn);
      then txt;
  end match;
end fun_564;

protected function lm_565
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = funArgDefinition(txt, i_var);
        txt = lm_565(txt, rest);
      then txt;
  end match;
end lm_565;

protected function fun_566
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_local_state_type mmc_GC_local_state = mmc_GC_save_roots_state(\"_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;
  end match;
end fun_566;

protected function fun_567
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_addRootsInputs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_addRootsInputs)
    local
      Tpl.Text txt;
      Tpl.Text a_addRootsInputs;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_addRootsInputs )
      equation
        txt = Tpl.writeText(txt, a_addRootsInputs);
      then txt;
  end match;
end fun_567;

protected function fun_568
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_568;

protected function fun_569
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_569;

protected function fun_570
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_undo_roots_state(mmc_GC_local_state);"));
      then txt;
  end match;
end fun_570;

protected function fun_571
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varFrees;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varFrees)
    local
      Tpl.Text txt;
      Tpl.Text a_varFrees;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_varFrees )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* Free GPU/OpenCL CPU memory */"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_varFrees);
      then txt;
  end match;
end fun_571;

protected function fun_572
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retVar;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retVar )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_572;

protected function fun_573
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (!mmc_GC_state) mmc_GC_init(mmc_GC_settings_default);"));
      then txt;
  end match;
end fun_573;

protected function lm_574
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinition(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_574(txt, rest);
      then txt;
  end match;
end lm_574;

protected function fun_575
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" out;"));
      then txt;
  end match;
end fun_575;

protected function lm_576
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = readInVar(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_576(txt, rest);
      then txt;
  end match;
end lm_576;

protected function fun_577
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out = "));
      then txt;
  end match;
end fun_577;

protected function lm_578
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = funArgName(txt, i_var);
        txt = lm_578(txt, rest);
      then txt;
  end match;
end lm_578;

protected function lm_579
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = writeOutVar(txt, i_var, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_579(txt, rest);
      then txt;
  end match;
end lm_579;

protected function fun_580
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_noretcall(outVar);"));
      then txt;

    case ( txt,
           i_outVars )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_579(txt, i_outVars);
        txt = Tpl.popIter(txt);
      then txt;
  end match;
end fun_580;

protected function fun_581
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input Tpl.Text in_a_retType;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_functionArguments;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inFunc, in_a_retType, in_a_outVars, in_a_functionArguments, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_functionArguments;
      Tpl.Text a_fname;
      Boolean ret_0;

    case ( txt,
           false,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_retType,
           a_outVars,
           a_functionArguments,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "DLLExport\n",
                                    "int in_"
                                }, false));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(type_description * inArgs, type_description * outVar)\n",
                                    "{\n",
                                    "  void* states = push_memory_states(1);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_0 = Config.acceptMetaModelicaGrammar();
        txt = fun_573(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_574(txt, a_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_575(txt, a_outVars, a_retType);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_576(txt, a_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MMC_INIT();\n",
                                    "MMC_TRY_TOP()\n"
                                }, true));
        txt = fun_577(txt, a_outVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omc_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData"));
        txt = lm_578(txt, a_functionArguments);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "MMC_CATCH_TOP(return 1)\n"
                                }, true));
        txt = fun_580(txt, a_outVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fflush(NULL);\n",
                                    "pop_memory_states(states);\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_581;

public function functionBodyRegularFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.Function i_fn;
      list<SimCode.Statement> i_body;
      list<SimCode.Variable> i_functionArguments;
      list<SimCode.Variable> i_variableDeclarations;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Boolean ret_24;
      Boolean ret_23;
      Boolean ret_22;
      Boolean ret_21;
      Boolean ret_20;
      Boolean ret_19;
      Boolean ret_18;
      Tpl.Text l_boxedFn;
      Tpl.Text l_0___1;
      Tpl.Text l_outVarAssign;
      Tpl.Text l_outVarCopy;
      Tpl.Text l_outVarInits;
      Tpl.Text l_bodyPart;
      Tpl.Text l_funArgs;
      Tpl.Text l_addRootsOutputs;
      Tpl.Text l_addRootsInputs;
      Tpl.Text l_0__;
      Boolean ret_7;
      Tpl.Text l_stateVar;
      Tpl.Text l_retVar;
      Tpl.Text l_varFrees;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, outVars = i_outVars, variableDeclarations = i_variableDeclarations, functionArguments = i_functionArguments, body = i_body)),
           a_inFunc )
      equation
        System.tmpTickReset(1);
        System.tmpTickResetIndex(0, 1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_555(Tpl.emptyTxt, i_outVars, l_fname);
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_varFrees = Tpl.emptyTxt;
        (l_retVar, l_varDecls) = fun_556(Tpl.emptyTxt, i_outVars, l_varDecls, l_retType);
        ret_7 = Config.acceptMetaModelicaGrammar();
        (l_stateVar, l_varDecls) = fun_557(Tpl.emptyTxt, ret_7, l_varDecls);
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_varFrees, l_varInits, l_varDecls) = lm_558(l_0__, i_variableDeclarations, l_varFrees, l_varInits, l_varDecls);
        l_0__ = Tpl.popIter(l_0__);
        l_addRootsInputs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_addRootsInputs = lm_559(l_addRootsInputs, i_functionArguments);
        l_addRootsInputs = Tpl.popIter(l_addRootsInputs);
        l_addRootsOutputs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_addRootsOutputs = lm_560(l_addRootsOutputs, i_outVars);
        l_addRootsOutputs = Tpl.popIter(l_addRootsOutputs);
        l_funArgs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_funArgs, l_varInits) = lm_561(l_funArgs, i_functionArguments, l_varInits);
        l_funArgs = Tpl.popIter(l_funArgs);
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bodyPart, l_varDecls) = lm_562(l_bodyPart, i_body, l_varDecls);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        l_outVarInits = Tpl.emptyTxt;
        l_outVarCopy = Tpl.emptyTxt;
        l_outVarAssign = Tpl.emptyTxt;
        l_0___1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0___1, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls) = lm_563(l_0___1, i_outVars, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls, l_retVar);
        l_0___1 = Tpl.popIter(l_0___1);
        l_varDecls = addRootsTempArray(l_varDecls);
        ret_18 = Config.acceptMetaModelicaGrammar();
        l_boxedFn = fun_564(Tpl.emptyTxt, ret_18, i_fn);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("DLLExport\n"));
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" omc_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData_t *threadData"));
        txt = lm_565(txt, i_functionArguments);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n",
                                    "  /* functionBodyRegularFunction: GC: save roots mark when you enter the function */\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_19 = Config.acceptMetaModelicaGrammar();
        txt = fun_566(txt, ret_19, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: GC: adding inputs as roots! */\n"));
        ret_20 = Config.acceptMetaModelicaGrammar();
        txt = fun_567(txt, ret_20, l_addRootsInputs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: arguments */\n"));
        txt = Tpl.writeText(txt, l_funArgs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: locals */\n"));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_tailrecursive:\n",
                                    "/* functionBodyRegularFunction: out inits */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_outVarInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: state in */\n"));
        ret_21 = Config.acceptMetaModelicaGrammar();
        txt = fun_568(txt, ret_21, l_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: var inits */\n"));
        txt = Tpl.writeText(txt, l_varInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: body */\n"));
        txt = Tpl.writeText(txt, l_bodyPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_return:\n",
                                    "/* functionBodyRegularFunction: out var copy */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_outVarCopy);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: state out */\n"));
        ret_22 = Config.acceptMetaModelicaGrammar();
        txt = fun_569(txt, ret_22, l_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: out var assign */\n"));
        txt = Tpl.writeText(txt, l_outVarAssign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* GC: pop the mark! */\n"));
        ret_23 = Config.acceptMetaModelicaGrammar();
        txt = fun_570(txt, ret_23);
        txt = Tpl.softNewLine(txt);
        ret_24 = Config.acceptParModelicaGrammar();
        txt = fun_571(txt, ret_24, l_varFrees);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* functionBodyRegularFunction: return the outs */\n",
                                    "return "
                                }, false));
        txt = fun_572(txt, i_outVars, l_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = fun_581(txt, a_inFunc, l_retType, i_outVars, i_functionArguments, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_boxedFn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionBodyRegularFunction;

protected function fun_583
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_583;

protected function lm_584
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varFrees;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varFrees;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varFrees, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varFrees, in_a_varInits, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varFrees;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varFrees,
           a_varInits,
           a_varDecls )
      then (txt, a_varFrees, a_varInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_varFrees,
           a_varInits,
           a_varDecls )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_varInits, a_varFrees) = varInit(txt, i_var, "", x_i1, a_varDecls, a_varInits, a_varFrees);
        txt = Tpl.nextIter(txt);
        (txt, a_varFrees, a_varInits, a_varDecls) = lm_584(txt, rest, a_varFrees, a_varInits, a_varDecls);
      then (txt, a_varFrees, a_varInits, a_varDecls);
  end match;
end lm_584;

protected function lm_585
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varInits) :=
  match(in_txt, in_items, in_a_varInits)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varInits;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varInits )
      then (txt, a_varInits);

    case ( txt,
           i_var :: rest,
           a_varInits )
      equation
        (txt, a_varInits) = functionArg(txt, i_var, a_varInits);
        txt = Tpl.nextIter(txt);
        (txt, a_varInits) = lm_585(txt, rest, a_varInits);
      then (txt, a_varInits);
  end match;
end lm_585;

protected function lm_586
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinitionKernelFunctionBody(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_586(txt, rest);
      then txt;
  end match;
end lm_586;

protected function lm_587
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_argStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_argStr;
algorithm
  (out_txt, out_a_argStr) :=
  match(in_txt, in_items, in_a_argStr)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_argStr;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_argStr )
      then (txt, a_argStr);

    case ( txt,
           i_var :: rest,
           a_argStr )
      equation
        (txt, a_argStr) = funArgDefinitionKernelFunctionBody2(txt, i_var, a_argStr);
        txt = Tpl.nextIter(txt);
        (txt, a_argStr) = lm_587(txt, rest, a_argStr);
      then (txt, a_argStr);
  end match;
end lm_587;

protected function lm_588
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_reconstrucedArrays;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reconstrucedArrays;
algorithm
  (out_txt, out_a_reconstrucedArrays) :=
  match(in_txt, in_items, in_a_reconstrucedArrays)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_reconstrucedArrays;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_reconstrucedArrays )
      then (txt, a_reconstrucedArrays);

    case ( txt,
           i_var :: rest,
           a_reconstrucedArrays )
      equation
        (txt, a_reconstrucedArrays) = reconstructKernelArrays(txt, i_var, a_reconstrucedArrays);
        (txt, a_reconstrucedArrays) = lm_588(txt, rest, a_reconstrucedArrays);
      then (txt, a_reconstrucedArrays);
  end match;
end lm_588;

protected function lm_589
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_reconstrucedArrays;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reconstrucedArrays;
algorithm
  (out_txt, out_a_reconstrucedArrays) :=
  match(in_txt, in_items, in_a_reconstrucedArrays)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_reconstrucedArrays;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_reconstrucedArrays )
      then (txt, a_reconstrucedArrays);

    case ( txt,
           i_var :: rest,
           a_reconstrucedArrays )
      equation
        (txt, a_reconstrucedArrays) = reconstructKernelArrays(txt, i_var, a_reconstrucedArrays);
        (txt, a_reconstrucedArrays) = lm_589(txt, rest, a_reconstrucedArrays);
      then (txt, a_reconstrucedArrays);
  end match;
end lm_589;

protected function lm_590
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = parModelicafunStatement(txt, i_stmt, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_590(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_590;

protected function fun_591
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Statement> i_body;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Variable> i_functionArguments;
      list<SimCode.Variable> i_variableDeclarations;
      Absyn.Path i_name;
      Tpl.Text l_bodyPart;
      Tpl.Text l_0___3;
      Tpl.Text l_0___2;
      Tpl.Text l_reconstrucedArrays;
      Tpl.Text l_0___1;
      Tpl.Text l_argStr;
      Tpl.Text l_funArgs;
      Tpl.Text l_0__;
      Boolean ret_5;
      Tpl.Text l_stateVar;
      Tpl.Text l_varFrees;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.KERNEL_FUNCTION(name = i_name, variableDeclarations = i_variableDeclarations, functionArguments = i_functionArguments, outVars = i_outVars, body = i_body) )
      equation
        System.tmpTickReset(1);
        System.tmpTickResetIndex(0, 1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_varFrees = Tpl.emptyTxt;
        ret_5 = Config.acceptMetaModelicaGrammar();
        (l_stateVar, l_varDecls) = fun_583(Tpl.emptyTxt, ret_5, l_varDecls);
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_varFrees, l_varInits, l_varDecls) = lm_584(l_0__, i_variableDeclarations, l_varFrees, l_varInits, l_varDecls);
        l_0__ = Tpl.popIter(l_0__);
        l_funArgs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_funArgs, l_varInits) = lm_585(l_funArgs, i_functionArguments, l_varInits);
        l_funArgs = Tpl.popIter(l_funArgs);
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                   ", \n",
                                                                                   "    "
                                                                               }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_argStr = lm_586(l_argStr, i_functionArguments);
        l_argStr = Tpl.popIter(l_argStr);
        l_0___1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0___1, l_argStr) = lm_587(l_0___1, i_outVars, l_argStr);
        l_0___1 = Tpl.popIter(l_0___1);
        l_reconstrucedArrays = Tpl.emptyTxt;
        (l_0___2, l_reconstrucedArrays) = lm_588(Tpl.emptyTxt, i_functionArguments, l_reconstrucedArrays);
        (l_0___3, l_reconstrucedArrays) = lm_589(Tpl.emptyTxt, i_outVars, l_reconstrucedArrays);
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bodyPart, l_varDecls) = lm_590(l_bodyPart, i_body, l_varDecls);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        l_varDecls = addRootsTempArray(l_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "__kernel void omc_"
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeText(txt, l_argStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "  /* functionBodyKernelFunction: Reconstruct Arrays */\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_reconstrucedArrays);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* functionBodyKernelFunction: locals */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* functionBodyKernelFunction: state in */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " = get_memory_state();\n",
                                    "/* functionBodyKernelFunction: var inits */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyKernelFunction: body */\n"));
        txt = Tpl.writeText(txt, l_bodyPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* functionBodyKernelFunction: state out */\n",
                                    "restore_memory_state("
                                }, false));
        txt = Tpl.writeText(txt, l_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n",
                                    "/* Free GPU/OpenCL CPU memory */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varFrees);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_591;

public function functionBodyKernelFunction
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input Boolean a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_591(txt, a_fn);
end functionBodyKernelFunction;

protected function fun_593
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
      then txt;
  end match;
end fun_593;

protected function fun_594
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_outVars, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end match;
end fun_594;

protected function fun_595
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_595;

protected function lm_596
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varFrees;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varFrees;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varFrees, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varFrees, in_a_varInits, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varFrees;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varFrees,
           a_varInits,
           a_varDecls )
      then (txt, a_varFrees, a_varInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_varFrees,
           a_varInits,
           a_varDecls )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_varInits, a_varFrees) = varInitParallel(txt, i_var, "", x_i1, a_varDecls, a_varInits, a_varFrees);
        txt = Tpl.nextIter(txt);
        (txt, a_varFrees, a_varInits, a_varDecls) = lm_596(txt, rest, a_varFrees, a_varInits, a_varDecls);
      then (txt, a_varFrees, a_varInits, a_varDecls);
  end match;
end lm_596;

protected function lm_597
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varInits) :=
  match(in_txt, in_items, in_a_varInits)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varInits;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varInits )
      then (txt, a_varInits);

    case ( txt,
           i_var :: rest,
           a_varInits )
      equation
        (txt, a_varInits) = functionArg(txt, i_var, a_varInits);
        txt = Tpl.nextIter(txt);
        (txt, a_varInits) = lm_597(txt, rest, a_varInits);
      then (txt, a_varInits);
  end match;
end lm_597;

protected function lm_598
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = parModelicafunStatement(txt, i_stmt, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_598(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_598;

protected function lm_599
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_retVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_retVar;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_retVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign) = varOutputParallel(txt, i_var, Tpl.textString(a_retVar), x_i1, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_599(txt, rest, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_retVar);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end match;
end lm_599;

protected function lm_600
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_600(txt, rest);
      then txt;
  end match;
end lm_600;

protected function fun_601
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retVar;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retVar )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_601;

protected function fun_602
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Statement> i_body;
      list<SimCode.Variable> i_functionArguments;
      list<SimCode.Variable> i_variableDeclarations;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_0__1;
      Tpl.Text l_outVarAssign;
      Tpl.Text l_outVarCopy;
      Tpl.Text l_outVarInits;
      Tpl.Text l_bodyPart;
      Tpl.Text l_funArgs;
      Tpl.Text l_0__;
      Boolean ret_7;
      Tpl.Text l_stateVar;
      Tpl.Text l_retVar;
      Tpl.Text l_varFrees;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.PARALLEL_FUNCTION(name = i_name, outVars = i_outVars, variableDeclarations = i_variableDeclarations, functionArguments = i_functionArguments, body = i_body) )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_593(Tpl.emptyTxt, i_outVars, l_fname);
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_varFrees = Tpl.emptyTxt;
        (l_retVar, l_varDecls) = fun_594(Tpl.emptyTxt, i_outVars, l_varDecls, l_retType);
        ret_7 = Config.acceptMetaModelicaGrammar();
        (l_stateVar, l_varDecls) = fun_595(Tpl.emptyTxt, ret_7, l_varDecls);
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_varFrees, l_varInits, l_varDecls) = lm_596(l_0__, i_variableDeclarations, l_varFrees, l_varInits, l_varDecls);
        l_0__ = Tpl.popIter(l_0__);
        l_funArgs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_funArgs, l_varInits) = lm_597(l_funArgs, i_functionArguments, l_varInits);
        l_funArgs = Tpl.popIter(l_funArgs);
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bodyPart, l_varDecls) = lm_598(l_bodyPart, i_body, l_varDecls);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        l_outVarInits = Tpl.emptyTxt;
        l_outVarCopy = Tpl.emptyTxt;
        l_outVarAssign = Tpl.emptyTxt;
        l_0__1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__1, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls) = lm_599(l_0__1, i_outVars, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls, l_retVar);
        l_0__1 = Tpl.popIter(l_0__1);
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" omc_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_600(txt, i_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_funArgs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_outVarInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " = get_memory_state();\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_bodyPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_outVarCopy);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, l_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.writeText(txt, l_outVarAssign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/*mahge: Free unwanted meomory allocated*/\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varFrees);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "return"
                                }, false));
        txt = fun_601(txt, i_outVars, l_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_602;

public function functionBodyParallelFunction
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input Boolean a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_602(txt, a_fn);
end functionBodyParallelFunction;

protected function fun_604
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
      then txt;
  end match;
end fun_604;

protected function fun_605
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_outVars, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end match;
end fun_605;

protected function fun_606
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_606;

protected function lm_607
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varInits) :=
  match(in_txt, in_items, in_a_varInits)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varInits;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varInits )
      then (txt, a_varInits);

    case ( txt,
           i_var :: rest,
           a_varInits )
      equation
        (txt, a_varInits) = functionArg(txt, i_var, a_varInits);
        txt = Tpl.nextIter(txt);
        (txt, a_varInits) = lm_607(txt, rest, a_varInits);
      then (txt, a_varInits);
  end match;
end lm_607;

protected function lm_608
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_retVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_retVar;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_retVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign) = varOutputKernelInterface(txt, i_var, Tpl.textString(a_retVar), x_i1, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_608(txt, rest, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_retVar);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end match;
end lm_608;

protected function lm_609
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_kernelArgSets;
  input Tpl.Text in_a_kernel__arg__number;
  input Tpl.Text in_a_cl__kernelVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_kernelArgSets;
  output Tpl.Text out_a_kernel__arg__number;
  output Tpl.Text out_a_cl__kernelVar;
algorithm
  (out_txt, out_a_kernelArgSets, out_a_kernel__arg__number, out_a_cl__kernelVar) :=
  match(in_txt, in_items, in_a_kernelArgSets, in_a_kernel__arg__number, in_a_cl__kernelVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_kernelArgSets;
      Tpl.Text a_kernel__arg__number;
      Tpl.Text a_cl__kernelVar;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_kernelArgSets,
           a_kernel__arg__number,
           a_cl__kernelVar )
      then (txt, a_kernelArgSets, a_kernel__arg__number, a_cl__kernelVar);

    case ( txt,
           i_var :: rest,
           a_kernelArgSets,
           a_kernel__arg__number,
           a_cl__kernelVar )
      equation
        (txt, a_cl__kernelVar, a_kernel__arg__number, a_kernelArgSets) = setKernelArg_ith(txt, i_var, a_cl__kernelVar, a_kernel__arg__number, a_kernelArgSets);
        (txt, a_kernelArgSets, a_kernel__arg__number, a_cl__kernelVar) = lm_609(txt, rest, a_kernelArgSets, a_kernel__arg__number, a_cl__kernelVar);
      then (txt, a_kernelArgSets, a_kernel__arg__number, a_cl__kernelVar);
  end match;
end lm_609;

protected function lm_610
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_kernelArgSets;
  input Tpl.Text in_a_kernel__arg__number;
  input Tpl.Text in_a_cl__kernelVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_kernelArgSets;
  output Tpl.Text out_a_kernel__arg__number;
  output Tpl.Text out_a_cl__kernelVar;
algorithm
  (out_txt, out_a_kernelArgSets, out_a_kernel__arg__number, out_a_cl__kernelVar) :=
  match(in_txt, in_items, in_a_kernelArgSets, in_a_kernel__arg__number, in_a_cl__kernelVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_kernelArgSets;
      Tpl.Text a_kernel__arg__number;
      Tpl.Text a_cl__kernelVar;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_kernelArgSets,
           a_kernel__arg__number,
           a_cl__kernelVar )
      then (txt, a_kernelArgSets, a_kernel__arg__number, a_cl__kernelVar);

    case ( txt,
           i_var :: rest,
           a_kernelArgSets,
           a_kernel__arg__number,
           a_cl__kernelVar )
      equation
        (txt, a_cl__kernelVar, a_kernel__arg__number, a_kernelArgSets) = setKernelArg_ith(txt, i_var, a_cl__kernelVar, a_kernel__arg__number, a_kernelArgSets);
        (txt, a_kernelArgSets, a_kernel__arg__number, a_cl__kernelVar) = lm_610(txt, rest, a_kernelArgSets, a_kernel__arg__number, a_cl__kernelVar);
      then (txt, a_kernelArgSets, a_kernel__arg__number, a_cl__kernelVar);
  end match;
end lm_610;

protected function lm_611
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinitionKernelFunctionInterface(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_611(txt, rest);
      then txt;
  end match;
end lm_611;

protected function fun_612
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_612;

protected function fun_613
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_613;

protected function fun_614
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retVar;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retVar )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_614;

protected function fun_615
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_functionArguments;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Boolean ret_19;
      Boolean ret_18;
      Tpl.Text l_0___1;
      Tpl.Text l_0__;
      Tpl.Text l_kernelArgSets;
      Tpl.Text l_kernel__arg__number;
      Tpl.Text l_cl__kernelVar;
      Tpl.Text l_0__1;
      Tpl.Text l_outVarAssign;
      Tpl.Text l_outVarCopy;
      Tpl.Text l_outVarInits;
      Tpl.Text l_funArgs;
      Boolean ret_7;
      Tpl.Text l_stateVar;
      Tpl.Text l_retVar;
      Tpl.Text l_varFrees;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.KERNEL_FUNCTION(name = i_name, outVars = i_outVars, functionArguments = i_functionArguments) )
      equation
        System.tmpTickReset(1);
        System.tmpTickResetIndex(0, 1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_604(Tpl.emptyTxt, i_outVars, l_fname);
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_varFrees = Tpl.emptyTxt;
        (l_retVar, l_varDecls) = fun_605(Tpl.emptyTxt, i_outVars, l_varDecls, l_retType);
        ret_7 = Config.acceptMetaModelicaGrammar();
        (l_stateVar, l_varDecls) = fun_606(Tpl.emptyTxt, ret_7, l_varDecls);
        l_funArgs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_funArgs, l_varInits) = lm_607(l_funArgs, i_functionArguments, l_varInits);
        l_funArgs = Tpl.popIter(l_funArgs);
        l_outVarInits = Tpl.emptyTxt;
        l_outVarCopy = Tpl.emptyTxt;
        l_outVarAssign = Tpl.emptyTxt;
        l_0__1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__1, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls) = lm_608(l_0__1, i_outVars, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls, l_retVar);
        l_0__1 = Tpl.popIter(l_0__1);
        (l_cl__kernelVar, l_varDecls) = tempDecl(Tpl.emptyTxt, "cl_kernel", l_varDecls);
        l_kernel__arg__number = Tpl.writeText(Tpl.emptyTxt, l_fname);
        l_kernel__arg__number = Tpl.writeTok(l_kernel__arg__number, Tpl.ST_STRING("_arg_nr"));
        l_kernelArgSets = Tpl.emptyTxt;
        (l_0__, l_kernelArgSets, l_kernel__arg__number, l_cl__kernelVar) = lm_609(Tpl.emptyTxt, i_functionArguments, l_kernelArgSets, l_kernel__arg__number, l_cl__kernelVar);
        (l_0___1, l_kernelArgSets, l_kernel__arg__number, l_cl__kernelVar) = lm_610(Tpl.emptyTxt, i_outVars, l_kernelArgSets, l_kernel__arg__number, l_cl__kernelVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Interface function to "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" defined in parallelFunctions.cl file. */\n"));
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" omc_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_611(txt, i_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_funArgs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_outVarInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_18 = Config.acceptMetaModelicaGrammar();
        txt = fun_612(txt, ret_18, l_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_varInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* functionBodyKernelFunctionInterface : "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " Kernel creation and execution */\n",
                                    "int "
                                }, false));
        txt = Tpl.writeText(txt, l_kernel__arg__number);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" = 0;\n"));
        txt = Tpl.writeText(txt, l_cl__kernelVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ocl_create_kernel(omc_ocl_program, \"omc_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\");\n"));
        txt = Tpl.writeText(txt, l_kernelArgSets);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ocl_execute_kernel("));
        txt = Tpl.writeText(txt, l_cl__kernelVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "clReleaseKernel("
                                }, false));
        txt = Tpl.writeText(txt, l_cl__kernelVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "/*functionBodyKernelFunctionInterface : "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " kernel execution ends here.*/\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_outVarCopy);
        txt = Tpl.softNewLine(txt);
        ret_19 = Config.acceptMetaModelicaGrammar();
        txt = fun_613(txt, ret_19, l_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_outVarAssign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/*mahge: Free unwanted meomory allocated*/\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varFrees);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "return"
                                }, false));
        txt = fun_614(txt, i_outVars, l_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_615;

public function functionBodyKernelFunctionInterface
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input Boolean a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_615(txt, a_fn);
end functionBodyKernelFunctionInterface;

protected function fun_617
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_argNr;
  input Tpl.Text in_a_KernelName;
  input Tpl.Text in_a_parVarList;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_parVarList;
algorithm
  (out_txt, out_a_parVarList) :=
  match(in_txt, in_a_instDims, in_a_varName, in_a_argNr, in_a_KernelName, in_a_parVarList)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      Tpl.Text a_argNr;
      Tpl.Text a_KernelName;
      Tpl.Text a_parVarList;

    case ( txt,
           {},
           a_varName,
           a_argNr,
           a_KernelName,
           a_parVarList )
      equation
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("ocl_set_kernel_arg("));
        a_parVarList = Tpl.writeText(a_parVarList, a_KernelName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, a_varName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("); ++"));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("; "));
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_NEW_LINE());
      then (txt, a_parVarList);

    case ( txt,
           _,
           a_varName,
           a_argNr,
           a_KernelName,
           a_parVarList )
      equation
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("ocl_set_kernel_arg("));
        a_parVarList = Tpl.writeText(a_parVarList, a_KernelName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, a_varName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(".data); ++"));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("; "));
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_NEW_LINE());
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("ocl_set_kernel_arg("));
        a_parVarList = Tpl.writeText(a_parVarList, a_KernelName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, a_varName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(".info_dev); ++"));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("; "));
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_NEW_LINE());
      then (txt, a_parVarList);
  end match;
end fun_617;

protected function fun_618
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_KernelName;
  input Tpl.Text in_a_argNr;
  input Tpl.Text in_a_parVarList;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_parVarList;
algorithm
  (out_txt, out_a_parVarList) :=
  match(in_txt, in_a_var, in_a_KernelName, in_a_argNr, in_a_parVarList)
    local
      Tpl.Text txt;
      Tpl.Text a_KernelName;
      Tpl.Text a_argNr;
      Tpl.Text a_parVarList;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_ARRAY(ty = _), name = i_var_name),
           a_KernelName,
           a_argNr,
           a_parVarList )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("ocl_set_kernel_arg("));
        a_parVarList = Tpl.writeText(a_parVarList, a_KernelName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, l_varName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(".data); ++"));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("; "));
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_NEW_LINE());
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("ocl_set_kernel_arg("));
        a_parVarList = Tpl.writeText(a_parVarList, a_KernelName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, l_varName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(".info_dev); ++"));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("; "));
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_NEW_LINE());
      then (txt, a_parVarList);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims),
           a_KernelName,
           a_argNr,
           a_parVarList )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction);
        (txt, a_parVarList) = fun_617(txt, i_instDims, l_varName, a_argNr, a_KernelName, a_parVarList);
      then (txt, a_parVarList);

    case ( txt,
           _,
           _,
           _,
           a_parVarList )
      then (txt, a_parVarList);
  end match;
end fun_618;

public function setKernelArg_ith
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input Tpl.Text a_KernelName;
  input Tpl.Text a_argNr;
  input Tpl.Text a_parVarList;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_KernelName;
  output Tpl.Text out_a_argNr;
  output Tpl.Text out_a_parVarList;
algorithm
  (out_txt, out_a_parVarList) := fun_618(txt, a_var, a_KernelName, a_argNr, a_parVarList);
  out_a_KernelName := a_KernelName;
  out_a_argNr := a_argNr;
end setKernelArg_ith;

protected function fun_620
  input Tpl.Text in_txt;
  input tuple<DAE.ComponentRef, Absyn.Info> in_a_tupleVar;
  input Tpl.Text in_a_KernelName;
  input Tpl.Text in_a_argNr;
  input Tpl.Text in_a_parVarList;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_parVarList;
algorithm
  (out_txt, out_a_parVarList) :=
  match(in_txt, in_a_tupleVar, in_a_KernelName, in_a_argNr, in_a_parVarList, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_KernelName;
      Tpl.Text a_argNr;
      Tpl.Text a_parVarList;
      SimCode.Context a_context;
      DAE.ComponentRef i_cref;
      Tpl.Text l_varName;

    case ( txt,
           ((i_cref as DAE.CREF_IDENT(identType = DAE.T_ARRAY(ty = _))), _),
           a_KernelName,
           a_argNr,
           a_parVarList,
           a_context )
      equation
        l_varName = contextArrayCref(Tpl.emptyTxt, i_cref, a_context);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("ocl_set_kernel_arg("));
        a_parVarList = Tpl.writeText(a_parVarList, a_KernelName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, l_varName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(".data); ++"));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("; "));
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_NEW_LINE());
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("ocl_set_kernel_arg("));
        a_parVarList = Tpl.writeText(a_parVarList, a_KernelName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, l_varName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(".info_dev); ++"));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("; "));
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_NEW_LINE());
      then (txt, a_parVarList);

    case ( txt,
           ((i_cref as DAE.CREF_IDENT(ident = _)), _),
           a_KernelName,
           a_argNr,
           a_parVarList,
           a_context )
      equation
        l_varName = contextArrayCref(Tpl.emptyTxt, i_cref, a_context);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("ocl_set_kernel_arg("));
        a_parVarList = Tpl.writeText(a_parVarList, a_KernelName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING(", "));
        a_parVarList = Tpl.writeText(a_parVarList, l_varName);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("); ++"));
        a_parVarList = Tpl.writeText(a_parVarList, a_argNr);
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_STRING("; "));
        a_parVarList = Tpl.writeTok(a_parVarList, Tpl.ST_NEW_LINE());
      then (txt, a_parVarList);

    case ( txt,
           _,
           _,
           _,
           a_parVarList,
           _ )
      then (txt, a_parVarList);
  end match;
end fun_620;

public function setKernelArgFormTupleLoopVars_ith
  input Tpl.Text txt;
  input tuple<DAE.ComponentRef, Absyn.Info> a_tupleVar;
  input Tpl.Text a_KernelName;
  input Tpl.Text a_argNr;
  input Tpl.Text a_parVarList;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_KernelName;
  output Tpl.Text out_a_argNr;
  output Tpl.Text out_a_parVarList;
algorithm
  (out_txt, out_a_parVarList) := fun_620(txt, a_tupleVar, a_KernelName, a_argNr, a_parVarList, a_context);
  out_a_KernelName := a_KernelName;
  out_a_argNr := a_argNr;
end setKernelArgFormTupleLoopVars_ith;

protected function fun_622
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
      then txt;
  end match;
end fun_622;

protected function fun_623
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_outVars, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = outDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end match;
end fun_623;

protected function fun_624
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_624;

protected function lm_625
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varFrees;
  input Tpl.Text in_a_outputAlloc;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varFrees;
  output Tpl.Text out_a_outputAlloc;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varFrees, out_a_outputAlloc, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varFrees, in_a_outputAlloc, in_a_varDecls, in_a_retVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varFrees;
      Tpl.Text a_outputAlloc;
      Tpl.Text a_varDecls;
      Tpl.Text a_retVar;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varFrees,
           a_outputAlloc,
           a_varDecls,
           _ )
      then (txt, a_varFrees, a_outputAlloc, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_varFrees,
           a_outputAlloc,
           a_varDecls,
           a_retVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outputAlloc, a_varFrees) = varInit(txt, i_var, Tpl.textString(a_retVar), x_i1, a_varDecls, a_outputAlloc, a_varFrees);
        txt = Tpl.nextIter(txt);
        (txt, a_varFrees, a_outputAlloc, a_varDecls) = lm_625(txt, rest, a_varFrees, a_outputAlloc, a_varDecls, a_retVar);
      then (txt, a_varFrees, a_outputAlloc, a_varDecls);
  end match;
end lm_625;

protected function fun_626
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.Function a_fn;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fn )
      equation
        txt = functionBodyBoxed(txt, a_fn);
      then txt;
  end match;
end fun_626;

protected function fun_627
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_arg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arg)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;
      DAE.Type i_ty;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) )
      equation
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr _"));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_627;

protected function lm_628
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = fun_627(txt, i_arg);
        txt = lm_628(txt, rest);
      then txt;
  end match;
end lm_628;

protected function fun_629
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;
  end match;
end fun_629;

protected function fun_630
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_630;

protected function fun_631
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retVar;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end match;
end fun_631;

protected function fun_632
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ptrT_"));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ptr_"));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=NULL;"));
      then txt;
  end match;
end fun_632;

protected function fun_633
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (!mmc_GC_state) mmc_GC_init(mmc_GC_settings_default);"));
      then txt;
  end match;
end fun_633;

protected function lm_634
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      DAE.Type i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) :: rest )
      equation
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_634(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_634(txt, rest);
      then txt;
  end match;
end lm_634;

protected function fun_635
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" out;"));
      then txt;
  end match;
end fun_635;

protected function lm_636
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_arg as SimCode.VARIABLE(name = _)) :: rest )
      equation
        txt = readInVar(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_636(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_636(txt, rest);
      then txt;
  end match;
end lm_636;

protected function fun_637
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out = "));
      then txt;
  end match;
end fun_637;

protected function lm_638
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = lm_638(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_638(txt, rest);
      then txt;
  end match;
end lm_638;

protected function lm_639
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = writeOutVar(txt, i_var, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_639(txt, rest);
      then txt;
  end match;
end lm_639;

protected function fun_640
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_noretcall(outVar);"));
      then txt;

    case ( txt,
           i_outVars )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_639(txt, i_outVars);
        txt = Tpl.popIter(txt);
      then txt;
  end match;
end fun_640;

protected function fun_641
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input Tpl.Text in_a_retType;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_funArgs;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inFunc, in_a_retType, in_a_outVars, in_a_funArgs, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_funArgs;
      Tpl.Text a_fname;
      Boolean ret_0;

    case ( txt,
           false,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_retType,
           a_outVars,
           a_funArgs,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "DLLExport\n",
                                    "int in_"
                                }, false));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(type_description * inArgs, type_description * outVar)\n",
                                    "{\n",
                                    "  void* states = push_memory_states(1);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_0 = Config.acceptMetaModelicaGrammar();
        txt = fun_633(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_634(txt, a_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_635(txt, a_outVars, a_retType);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_636(txt, a_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MMC_INIT();\n",
                                    "MMC_TRY_TOP()\n"
                                }, true));
        txt = fun_637(txt, a_outVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omc_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData"));
        txt = lm_638(txt, a_funArgs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "MMC_CATCH_TOP(return 1)\n"
                                }, true));
        txt = fun_640(txt, a_outVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fflush(NULL);\n",
                                    "pop_memory_states(states);\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_641;

public function functionBodyExternalFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      String i_language;
      String i_extName;
      Boolean i_dynamicLoad;
      list<SimCode.Variable> i_funArgs;
      SimCode.Function i_efn;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_fnBody;
      Boolean ret_12;
      Tpl.Text l_boxedFn;
      Tpl.Text l_0__;
      Tpl.Text l_callPart;
      Boolean ret_8;
      Tpl.Text l_stateVar;
      Tpl.Text l_outputAlloc;
      Tpl.Text l_retVar;
      Tpl.Text l_varFrees;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           (i_efn as SimCode.EXTERNAL_FUNCTION(name = i_name, outVars = i_outVars, funArgs = i_funArgs, dynamicLoad = i_dynamicLoad, extName = i_extName, language = i_language)),
           a_inFunc )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_622(Tpl.emptyTxt, i_outVars, l_fname);
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_varFrees = Tpl.emptyTxt;
        (l_retVar, l_varDecls) = fun_623(Tpl.emptyTxt, i_outVars, l_varDecls, l_retType);
        l_outputAlloc = Tpl.emptyTxt;
        ret_8 = Config.acceptMetaModelicaGrammar();
        (l_stateVar, l_varDecls) = fun_624(Tpl.emptyTxt, ret_8, l_varDecls);
        (l_callPart, l_preExp, l_varDecls) = extFunCall(Tpl.emptyTxt, i_efn, l_preExp, l_varDecls);
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_varFrees, l_outputAlloc, l_varDecls) = lm_625(l_0__, i_outVars, l_varFrees, l_outputAlloc, l_varDecls, l_retVar);
        l_0__ = Tpl.popIter(l_0__);
        ret_12 = Config.acceptMetaModelicaGrammar();
        l_boxedFn = fun_626(Tpl.emptyTxt, ret_12, i_efn);
        l_fnBody = Tpl.writeText(Tpl.emptyTxt, l_retType);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING(" omc_"));
        l_fnBody = Tpl.writeText(l_fnBody, l_fname);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("(threadData_t *threadData"));
        l_fnBody = lm_628(l_fnBody, i_funArgs);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING_LIST({
                                              ")\n",
                                              "{\n",
                                              "  /* functionBodyExternalFunction: varDecls */\n"
                                          }, true));
        l_fnBody = Tpl.pushBlock(l_fnBody, Tpl.BT_INDENT(2));
        l_fnBody = Tpl.writeText(l_fnBody, l_varDecls);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = fun_629(l_fnBody, false, l_stateVar);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: preExp */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_preExp);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: outputAlloc */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_outputAlloc);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: callPart */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_callPart);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = fun_630(l_fnBody, false, l_stateVar);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING_LIST({
                                              "/* functionBodyExternalFunction: return */\n",
                                              "return "
                                          }, false));
        l_fnBody = fun_631(l_fnBody, i_outVars, l_retVar);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE(";\n"));
        l_fnBody = Tpl.popBlock(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("}"));
        txt = fun_632(txt, i_dynamicLoad, i_language, i_extName);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_fnBody);
        txt = Tpl.softNewLine(txt);
        txt = fun_641(txt, a_inFunc, l_retType, i_outVars, i_funArgs, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_boxedFn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionBodyExternalFunction;

protected function lm_643
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_structVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varInits, in_a_varDecls, in_a_structVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_structVar;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varInits,
           a_varDecls,
           _ )
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_varInits,
           a_varDecls,
           a_structVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_varInits) = varInitRecord(txt, i_var, x_i1, Tpl.textString(a_structVar), a_varDecls, a_varInits);
        txt = Tpl.nextIter(txt);
        (txt, a_varInits, a_varDecls) = lm_643(txt, rest, a_varInits, a_varDecls, a_structVar);
      then (txt, a_varInits, a_varDecls);
  end match;
end lm_643;

protected function fun_644
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.Function a_fn;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fn )
      equation
        txt = functionBodyBoxed(txt, a_fn);
      then txt;
  end match;
end fun_644;

protected function lm_645
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      DAE.Type i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = lm_645(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_645(txt, rest);
      then txt;
  end match;
end lm_645;

protected function lm_646
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_structVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_structVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_structVar;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest,
           a_structVar )
      equation
        txt = Tpl.writeText(txt, a_structVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("._"));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_646(txt, rest, a_structVar);
      then txt;

    case ( txt,
           _ :: rest,
           a_structVar )
      equation
        txt = lm_646(txt, rest, a_structVar);
      then txt;
  end match;
end lm_646;

public function functionBodyRecordConstructor
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_funArgs;
      SimCode.Function i_fn;
      list<SimCode.Variable> i_locals;
      Absyn.Path i_name;
      Boolean ret_10;
      Tpl.Text l_boxedFn;
      Tpl.Text l_0__;
      Tpl.Text l_structVar;
      Tpl.Text l_structType;
      Tpl.Text l_retVar;
      Tpl.Text l_retType;
      Tpl.Text l_fname;
      Tpl.Text l_varFrees;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = i_name, locals = i_locals, funArgs = i_funArgs)) )
      equation
        System.tmpTickReset(1);
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_varFrees = Tpl.emptyTxt;
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = Tpl.writeText(Tpl.emptyTxt, l_fname);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("_rettype"));
        (l_retVar, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), l_varDecls);
        l_structType = Tpl.writeText(Tpl.emptyTxt, l_fname);
        (l_structVar, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_structType), l_varDecls);
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_varInits, l_varDecls) = lm_643(l_0__, i_locals, l_varInits, l_varDecls, l_structVar);
        l_0__ = Tpl.popIter(l_0__);
        ret_10 = Config.acceptMetaModelicaGrammar();
        l_boxedFn = fun_644(Tpl.emptyTxt, ret_10, i_fn);
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" omc_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData_t *threadData"));
        txt = lm_645(txt, i_funArgs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_646(txt, i_funArgs, l_structVar);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c1 = "));
        txt = Tpl.writeText(txt, l_structVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "return "
                                }, false));
        txt = Tpl.writeText(txt, l_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_boxedFn);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionBodyRecordConstructor;

protected function lm_648
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_648(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_648;

protected function fun_649
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var_value, in_a_varDecls, in_a_varInits, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varName;
      DAE.Exp i_exp;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_varInits,
           a_varName )
      equation
        l_defaultValue = Tpl.writeText(Tpl.emptyTxt, a_varName);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(" = "));
        (l_defaultValue, a_varInits, a_varDecls) = daeExp(l_defaultValue, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(";"));
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           a_varDecls,
           a_varInits,
           _ )
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_649;

protected function fun_650
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var_value, in_a_varDecls, in_a_i, in_a_var, in_a_instDimsInit, in_a_instDims, in_a_varName, in_a_var_ty, in_a_varInits)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Integer a_i;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      list<DAE.Exp> a_instDims;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;
      Integer ret_3;
      Tpl.Text l_defaultValue1;
      Tpl.Text l_defaultValue;
      Integer ret_0;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_i,
           a_var,
           a_instDimsInit,
           a_instDims,
           a_varName,
           a_var_ty,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_0 = listLength(a_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, "", a_i, Tpl.textString(a_varName), a_varDecls, a_varInits);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        l_defaultValue1 = Tpl.writeText(Tpl.emptyTxt, a_varName);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(" = "));
        (l_defaultValue1, a_varInits, a_varDecls) = daeExp(l_defaultValue1, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(";"));
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           a_varDecls,
           a_i,
           a_var,
           a_instDimsInit,
           a_instDims,
           a_varName,
           a_var_ty,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_3 = listLength(a_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_3));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, "", a_i, Tpl.textString(a_varName), a_varDecls, a_varInits);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_650;

protected function fun_651
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Integer in_a_i;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varName;
  input Option<DAE.Exp> in_a_var_value;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_instDims, in_a_i, in_a_var, in_a_instDimsInit, in_a_var_ty, in_a_varDecls, in_a_varInits, in_a_varName, in_a_var_value)
    local
      Tpl.Text txt;
      Integer a_i;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      DAE.Type a_var_ty;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varName;
      Option<DAE.Exp> a_var_value;
      list<DAE.Exp> i_instDims;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varName,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_649(txt, a_var_value, a_varDecls, a_varInits, a_varName);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_instDims,
           a_i,
           a_var,
           a_instDimsInit,
           a_var_ty,
           a_varDecls,
           a_varInits,
           a_varName,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_650(txt, a_var_value, a_varDecls, a_i, a_var, a_instDimsInit, i_instDims, a_varName, a_var_ty, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_651;

public function varInitRecord
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_i;
  input String in_a_prefix;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var, in_a_i, in_a_prefix, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      Integer a_i;
      String a_prefix;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Type i_var_ty;
      Option<DAE.Exp> i_var_value;
      list<DAE.Exp> i_instDims;
      SimCode.Variable i_var;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_ignore;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_varName;

    case ( txt,
           (i_var as SimCode.VARIABLE(parallelism = DAE.NON_PARALLEL(), name = i_var_name, instDims = i_instDims, value = i_var_value, ty = i_var_ty)),
           a_i,
           a_prefix,
           a_varDecls,
           a_varInits )
      equation
        l_varName = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_varName = Tpl.writeTok(l_varName, Tpl.ST_STRING("._"));
        l_varName = crefToCStr(l_varName, i_var_name);
        a_varInits = initRecordMembers(a_varInits, i_var);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_648(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varDecls, a_varInits) = fun_651(txt, i_instDims, a_i, i_var, l_instDimsInit, i_var_ty, a_varDecls, a_varInits, l_varName, i_var_value);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           (i_var as SimCode.FUNCTION_PTR(name = _)),
           _,
           _,
           a_varDecls,
           a_varInits )
      equation
        l_ignore = Tpl.emptyTxt;
        (a_varDecls, l_ignore) = functionArg(a_varDecls, i_var, l_ignore);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4975, 12), "Unknown local variable type in record");
      then (txt, a_varDecls, a_varInits);
  end match;
end varInitRecord;

protected function fun_653
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_functionArguments;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_outVars, in_a_functionArguments, in_a_name)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_functionArguments;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_outVars,
           a_functionArguments,
           a_name )
      equation
        txt = functionBodyBoxedImpl(txt, a_name, a_functionArguments, a_outVars);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_653;

protected function fun_654
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_funArgs;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_outVars, in_a_funArgs, in_a_name)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_funArgs;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_outVars,
           a_funArgs,
           a_name )
      equation
        txt = functionBodyBoxedImpl(txt, a_name, a_funArgs, a_outVars);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_654;

public function functionBodyBoxed
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_funArgs;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Variable> i_functionArguments;
      Absyn.Path i_name;
      SimCode.Function i_fn;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, functionArguments = i_functionArguments, outVars = i_outVars)) )
      equation
        ret_0 = SimCodeUtil.isBoxedFunction(i_fn);
        txt = fun_653(txt, ret_0, i_outVars, i_functionArguments, i_name);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name, funArgs = i_funArgs, outVars = i_outVars)) )
      equation
        ret_1 = SimCodeUtil.isBoxedFunction(i_fn);
        txt = fun_654(txt, ret_1, i_outVars, i_funArgs, i_name);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)) )
      equation
        txt = boxRecordConstructor(txt, i_fn);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionBodyBoxed;

protected function fun_656
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outvars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
      then txt;
  end match;
end fun_656;

protected function fun_657
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outvars, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boxed"));
      then txt;
  end match;
end fun_657;

protected function fun_658
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retTypeBoxed;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_outvars, in_a_varDecls, in_a_retTypeBoxed)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retTypeBoxed;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retTypeBoxed )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retTypeBoxed), a_varDecls);
      then (txt, a_varDecls);
  end match;
end fun_658;

protected function fun_659
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_outvars, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end match;
end fun_659;

protected function fun_660
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_660;

protected function lm_661
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varBox;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varBox;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varBox, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varBox, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varBox;
      Tpl.Text a_varDecls;
      SimCode.Variable i_arg;

    case ( txt,
           {},
           a_varBox,
           a_varDecls )
      then (txt, a_varBox, a_varDecls);

    case ( txt,
           i_arg :: rest,
           a_varBox,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        (txt, a_varDecls, a_varBox) = funArgUnbox(txt, i_arg, a_varDecls, a_varBox);
        (txt, a_varBox, a_varDecls) = lm_661(txt, rest, a_varBox, a_varDecls);
      then (txt, a_varBox, a_varDecls);
  end match;
end lm_661;

protected function lm_662
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varUnbox;
  input Tpl.Text in_a_retVar;
  input Tpl.Text in_a_funRetVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varUnbox;
algorithm
  (out_txt, out_a_varDecls, out_a_varUnbox) :=
  match(in_txt, in_items, in_a_varDecls, in_a_varUnbox, in_a_retVar, in_a_funRetVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varUnbox;
      Tpl.Text a_retVar;
      Tpl.Text a_funRetVar;
      Integer x_i1;
      DAE.Type i_ty;
      Tpl.Text l_arg;

    case ( txt,
           {},
           a_varDecls,
           a_varUnbox,
           _,
           _ )
      then (txt, a_varDecls, a_varUnbox);

    case ( txt,
           SimCode.VARIABLE(ty = i_ty) :: rest,
           a_varDecls,
           a_varUnbox,
           a_retVar,
           a_funRetVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_arg = Tpl.writeText(Tpl.emptyTxt, a_funRetVar);
        l_arg = Tpl.writeTok(l_arg, Tpl.ST_STRING(".c"));
        l_arg = Tpl.writeStr(l_arg, intString(x_i1));
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        (txt, a_varUnbox, a_varDecls) = funArgBox(txt, Tpl.textString(l_arg), i_ty, a_varUnbox, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varUnbox) = lm_662(txt, rest, a_varDecls, a_varUnbox, a_retVar, a_funRetVar);
      then (txt, a_varDecls, a_varUnbox);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_varUnbox,
           a_retVar,
           a_funRetVar )
      equation
        (txt, a_varDecls, a_varUnbox) = lm_662(txt, rest, a_varDecls, a_varUnbox, a_retVar, a_funRetVar);
      then (txt, a_varDecls, a_varUnbox);
  end match;
end lm_662;

protected function lm_663
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = funArgBoxedDefinition(txt, i_var);
        txt = lm_663(txt, rest);
      then txt;
  end match;
end lm_663;

protected function fun_664
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_local_state_type mmc_GC_local_state = mmc_GC_save_roots_state(\"boxptr__"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;
  end match;
end fun_664;

protected function fun_665
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_665;

protected function fun_666
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_funRetVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outvars, in_a_funRetVar)
    local
      Tpl.Text txt;
      Tpl.Text a_funRetVar;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_funRetVar )
      equation
        txt = Tpl.writeText(txt, a_funRetVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;
  end match;
end fun_666;

protected function fun_667
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_667;

protected function fun_668
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_undo_roots_state(mmc_GC_local_state);"));
      then txt;
  end match;
end fun_668;

public function functionBodyBoxedImpl
  input Tpl.Text txt;
  input Absyn.Path a_name;
  input list<SimCode.Variable> a_funargs;
  input list<SimCode.Variable> a_outvars;

  output Tpl.Text out_txt;
protected
  Boolean ret_15;
  Boolean ret_14;
  Boolean ret_13;
  Boolean ret_12;
  Tpl.Text l_retStr;
  Tpl.Text l_args;
  Tpl.Text l_varUnbox;
  Tpl.Text l_varBox;
  Boolean ret_7;
  Tpl.Text l_stateVar;
  Tpl.Text l_funRetVar;
  Tpl.Text l_retVar;
  Tpl.Text l_varDecls;
  Tpl.Text l_retTypeBoxed;
  Tpl.Text l_retType;
  Tpl.Text l_fname;
algorithm
  System.tmpTickReset(1);
  System.tmpTickResetIndex(0, 1);
  l_fname := underscorePath(Tpl.emptyTxt, a_name);
  l_retType := fun_656(Tpl.emptyTxt, a_outvars, l_fname);
  l_retTypeBoxed := fun_657(Tpl.emptyTxt, a_outvars, l_retType);
  l_varDecls := Tpl.emptyTxt;
  (l_retVar, l_varDecls) := fun_658(Tpl.emptyTxt, a_outvars, l_varDecls, l_retTypeBoxed);
  (l_funRetVar, l_varDecls) := fun_659(Tpl.emptyTxt, a_outvars, l_varDecls, l_retType);
  ret_7 := Config.acceptMetaModelicaGrammar();
  (l_stateVar, l_varDecls) := fun_660(Tpl.emptyTxt, ret_7, l_varDecls);
  l_varBox := Tpl.emptyTxt;
  l_varUnbox := Tpl.emptyTxt;
  (l_args, l_varBox, l_varDecls) := lm_661(Tpl.emptyTxt, a_funargs, l_varBox, l_varDecls);
  l_retStr := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_retStr, l_varDecls, l_varUnbox) := lm_662(l_retStr, a_outvars, l_varDecls, l_varUnbox, l_retVar, l_funRetVar);
  l_retStr := Tpl.popIter(l_retStr);
  out_txt := Tpl.writeText(txt, l_retTypeBoxed);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" boxptr_"));
  out_txt := Tpl.writeText(out_txt, l_fname);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("(threadData_t *threadData"));
  out_txt := lm_663(out_txt, a_funargs);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ")\n",
                                       "{\n",
                                       "  /* GC: save roots mark when you enter the function */\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  ret_12 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_664(out_txt, ret_12, l_fname);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := addRootsTempArray(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  ret_13 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_665(out_txt, ret_13, l_stateVar);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_varBox);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := fun_666(out_txt, a_outvars, l_funRetVar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("omc_"));
  out_txt := Tpl.writeText(out_txt, l_fname);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("(threadData"));
  out_txt := Tpl.writeText(out_txt, l_args);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(");\n"));
  out_txt := Tpl.writeText(out_txt, l_varUnbox);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_retStr);
  out_txt := Tpl.softNewLine(out_txt);
  ret_14 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_667(out_txt, ret_14, l_stateVar);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* GC: pop roots mark when you exit the function */\n"));
  ret_15 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_668(out_txt, ret_15);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("return "));
  out_txt := Tpl.writeText(out_txt, l_retVar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(";\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionBodyBoxedImpl;

protected function fun_670
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.VARIABLE(name = i_name) )
      equation
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 5039, 17), "boxRecordConstructor:Unknown variable");
      then txt;
  end match;
end fun_670;

protected function lm_671
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_670(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_671(txt, rest);
      then txt;
  end match;
end lm_671;

protected function lm_672
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = funArgBoxedDefinition(txt, i_var);
        txt = lm_672(txt, rest);
      then txt;
  end match;
end lm_672;

public function boxRecordConstructor
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_funArgs;
      Absyn.Path i_name;
      Integer ret_4;
      Integer ret_3;
      Tpl.Text l_funArgCount;
      Tpl.Text l_funArgsStr;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs) )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_funArgsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_funArgsStr = lm_671(l_funArgsStr, i_funArgs);
        l_funArgsStr = Tpl.popIter(l_funArgsStr);
        ret_3 = listLength(i_funArgs);
        ret_4 = SimCodeUtil.incrementInt(ret_3, 1);
        l_funArgCount = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype boxptr_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData_t *threadData"));
        txt = lm_672(txt, i_funArgs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return mmc_mk_box"));
        txt = Tpl.writeText(txt, l_funArgCount);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(3, &"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc, "));
        txt = Tpl.writeText(txt, l_funArgsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end boxRecordConstructor;

public function funArgUnbox
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varBox;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varBox;
algorithm
  (out_txt, out_a_varDecls, out_a_varBox) :=
  match(in_txt, in_a_var, in_a_varDecls, in_a_varBox)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varBox;
      String i_name_1;
      DAE.Type i_ty;
      DAE.ComponentRef i_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(name = i_name, ty = i_ty),
           a_varDecls,
           a_varBox )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_name, SimCode.contextFunction);
        (txt, a_varBox, a_varDecls) = unboxVariable(txt, Tpl.textString(l_varName), i_ty, a_varBox, a_varDecls);
      then (txt, a_varDecls, a_varBox);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_varDecls,
           a_varBox )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then (txt, a_varDecls, a_varBox);

    case ( txt,
           _,
           a_varDecls,
           a_varBox )
      then (txt, a_varDecls, a_varBox);
  end match;
end funArgUnbox;

protected function fun_675
  input Tpl.Text in_txt;
  input DAE.Type in_a_varType;
  input String in_a_varName;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_varType, in_a_varName, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_varName;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type i_varType;
      Tpl.Text l_tmpVar;
      Tpl.Text l_ty;
      Tpl.Text l_shortType;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_METATYPE(ty = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_METABOXED(ty = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_varType as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _))),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = unboxRecord(txt, a_varName, i_varType, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_varType,
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        l_shortType = mmcTypeShort(Tpl.emptyTxt, i_varType);
        l_ty = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("modelica_"));
        l_ty = Tpl.writeText(l_ty, l_shortType);
        (l_tmpVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_ty), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmpVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = mmc_unbox_"));
        a_preExp = Tpl.writeText(a_preExp, l_shortType);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeStr(a_preExp, a_varName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpVar);
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_675;

public function unboxVariable
  input Tpl.Text txt;
  input String a_varName;
  input DAE.Type a_varType;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) := fun_675(txt, a_varType, a_varName, a_preExp, a_varDecls);
end unboxVariable;

protected function lm_677
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Tpl.Text in_a_tmpVar;
  input String in_a_recordVar;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmpVar, in_a_recordVar, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Tpl.Text a_tmpVar;
      String a_recordVar;
      Tpl.Text a_varDecls;
      Integer x_offset;
      DAE.Ident i_compname;
      DAE.Type i_ty;
      Tpl.Text l_unboxStr;
      Tpl.Text l_unboxBuf;
      Tpl.Text l_untagTmp;
      Tpl.Text l_varType;

    case ( txt,
           {},
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           DAE.TYPES_VAR(name = i_compname, ty = i_ty) :: rest,
           a_tmpVar,
           a_recordVar,
           a_varDecls )
      equation
        x_offset = Tpl.getIteri_i0(txt);
        l_varType = mmcTypeShort(Tpl.emptyTxt, i_ty);
        (l_untagTmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_metatype", a_varDecls);
        l_unboxBuf = Tpl.emptyTxt;
        (l_unboxStr, l_unboxBuf, a_varDecls) = unboxVariable(Tpl.emptyTxt, Tpl.textString(l_untagTmp), i_ty, l_unboxBuf, a_varDecls);
        txt = Tpl.writeText(txt, l_untagTmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = (MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR("));
        txt = Tpl.writeStr(txt, a_recordVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("), "));
        txt = Tpl.writeStr(txt, intString(x_offset));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")));\n"));
        txt = Tpl.writeText(txt, l_unboxBuf);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_tmpVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("._"));
        txt = Tpl.writeStr(txt, i_compname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_unboxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_677(txt, rest, a_tmpVar, a_recordVar, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmpVar,
           a_recordVar,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_677(txt, rest, a_tmpVar, a_recordVar, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_677;

protected function fun_678
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input String in_a_recordVar;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_ty, in_a_recordVar, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_recordVar;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.Var> i_vars;
      Absyn.Path i_path;
      Tpl.Text txt_1;
      Tpl.Text l_tmpVar;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_path), varLst = i_vars),
           a_recordVar,
           a_preExp,
           a_varDecls )
      equation
        txt_1 = underscorePath(Tpl.emptyTxt, i_path);
        (l_tmpVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        a_preExp = Tpl.pushIter(a_preExp, Tpl.ITER_OPTIONS(2, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (a_preExp, a_varDecls) = lm_677(a_preExp, i_vars, l_tmpVar, a_recordVar, a_varDecls);
        a_preExp = Tpl.popIter(a_preExp);
        txt = Tpl.writeText(txt, l_tmpVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_678;

public function unboxRecord
  input Tpl.Text txt;
  input String a_recordVar;
  input DAE.Type a_ty;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) := fun_678(txt, a_ty, a_recordVar, a_preExp, a_varDecls);
end unboxRecord;

protected function fun_680
  input Tpl.Text in_txt;
  input Tpl.Text in_a_constructorType;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varUnbox;
  input DAE.Type in_a_ty;
  input String in_a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varUnbox;
algorithm
  (out_txt, out_a_varDecls, out_a_varUnbox) :=
  match(in_txt, in_a_constructorType, in_a_varDecls, in_a_varUnbox, in_a_ty, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varUnbox;
      DAE.Type a_ty;
      String a_varName;
      Tpl.Text i_constructorType;
      Tpl.Text l_tmpVar;
      Tpl.Text l_constructor;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_varDecls,
           a_varUnbox,
           _,
           a_varName )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_varDecls, a_varUnbox);

    case ( txt,
           i_constructorType,
           a_varDecls,
           a_varUnbox,
           a_ty,
           a_varName )
      equation
        (l_constructor, a_varUnbox, a_varDecls) = mmcConstructor(Tpl.emptyTxt, a_ty, a_varName, a_varUnbox, a_varDecls);
        (l_tmpVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(i_constructorType), a_varDecls);
        a_varUnbox = Tpl.writeText(a_varUnbox, l_tmpVar);
        a_varUnbox = Tpl.writeTok(a_varUnbox, Tpl.ST_STRING(" = "));
        a_varUnbox = Tpl.writeText(a_varUnbox, l_constructor);
        a_varUnbox = Tpl.writeTok(a_varUnbox, Tpl.ST_STRING(";"));
        a_varUnbox = Tpl.writeTok(a_varUnbox, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpVar);
      then (txt, a_varDecls, a_varUnbox);
  end match;
end fun_680;

public function funArgBox
  input Tpl.Text txt;
  input String a_varName;
  input DAE.Type a_ty;
  input Tpl.Text a_varUnbox;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varUnbox;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_constructorType;
algorithm
  l_constructorType := mmcConstructorType(Tpl.emptyTxt, a_ty);
  (out_txt, out_a_varDecls, out_a_varUnbox) := fun_680(txt, l_constructorType, a_varDecls, a_varUnbox, a_ty, a_varName);
end funArgBox;

public function mmcConstructorType
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end mmcConstructorType;

protected function lm_683
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input String in_a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_varName)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      String a_varName;
      DAE.Type i_ty;
      DAE.Ident i_name;
      Tpl.Text l_varname;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.TYPES_VAR(name = i_name, ty = i_ty) :: rest,
           a_varDecls,
           a_preExp,
           a_varName )
      equation
        l_varname = Tpl.writeStr(Tpl.emptyTxt, a_varName);
        l_varname = Tpl.writeTok(l_varname, Tpl.ST_STRING("._"));
        l_varname = Tpl.writeStr(l_varname, i_name);
        (txt, a_preExp, a_varDecls) = funArgBox(txt, Tpl.textString(l_varname), i_ty, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_683(txt, rest, a_varDecls, a_preExp, a_varName);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_varName )
      equation
        (txt, a_varDecls, a_preExp) = lm_683(txt, rest, a_varDecls, a_preExp, a_varName);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_683;

public function mmcConstructor
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input String in_a_varName;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_type, in_a_varName, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_varName;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Absyn.Path i_path;
      list<DAE.Var> i_vars;
      Tpl.Text l_varsStr;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_varCount;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_icon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_BOOL(varLst = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_icon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_rcon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_string("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_icon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_ARRAY(ty = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_acon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_path), varLst = i_vars),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        ret_1 = listLength(i_vars);
        ret_2 = SimCodeUtil.incrementInt(ret_1, 1);
        l_varCount = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_varsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_varsStr, a_varDecls, a_preExp) = lm_683(l_varsStr, i_vars, a_varDecls, a_preExp, a_varName);
        l_varsStr = Tpl.popIter(l_varsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_box"));
        txt = Tpl.writeText(txt, l_varCount);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(3, &"));
        txt = underscorePath(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc, "));
        txt = Tpl.writeText(txt, l_varsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_COMPLEX(complexClassType = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_box("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end mmcConstructor;

protected function fun_685
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(char**)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_685;

public function readInVar
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      DAE.ComponentRef i_cr;
      DAE.Type i_ty;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.VARIABLE(name = i_cr, ty = (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_modelica_record(&inArgs, "));
        txt_0 = contextCref(Tpl.emptyTxt, i_cr, SimCode.contextFunction);
        txt = readInVarRecordMembers(txt, i_ty, Tpl.textString(txt_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name, ty = (i_ty as DAE.T_STRING(varLst = _))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_"));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&inArgs, "));
        ret_1 = Config.acceptMetaModelicaGrammar();
        txt = fun_685(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" &"));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_"));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&inArgs, &"));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end readInVar;

protected function fun_687
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.Ident in_a_subvar_name;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty, in_a_subvar_name, in_a_prefix)
    local
      Tpl.Text txt;
      DAE.Ident a_subvar_name;
      String a_prefix;
      DAE.Type i_ty;
      Tpl.Text l_newPrefix;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = _)),
           a_subvar_name,
           a_prefix )
      equation
        l_newPrefix = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_newPrefix = Tpl.writeTok(l_newPrefix, Tpl.ST_STRING("._"));
        l_newPrefix = Tpl.writeStr(l_newPrefix, a_subvar_name);
        txt = readInVarRecordMembers(txt, i_ty, Tpl.textString(l_newPrefix));
      then txt;

    case ( txt,
           _,
           a_subvar_name,
           a_prefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&("));
        txt = Tpl.writeStr(txt, a_prefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("._"));
        txt = Tpl.writeStr(txt, a_subvar_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_687;

protected function lm_688
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      String a_prefix;
      DAE.Ident i_subvar_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           DAE.TYPES_VAR(ty = i_ty, name = i_subvar_name) :: rest,
           a_prefix )
      equation
        txt = fun_687(txt, i_ty, i_subvar_name, a_prefix);
        txt = Tpl.nextIter(txt);
        txt = lm_688(txt, rest, a_prefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_prefix )
      equation
        txt = lm_688(txt, rest, a_prefix);
      then txt;
  end match;
end lm_688;

public function readInVarRecordMembers
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_prefix)
    local
      Tpl.Text txt;
      String a_prefix;
      list<DAE.Var> i_vl;

    case ( txt,
           DAE.T_COMPLEX(varLst = i_vl),
           a_prefix )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_688(txt, i_vl, a_prefix);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end readInVarRecordMembers;

public function writeOutVar
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;
      SimCode.Variable i_var;
      DAE.Type i_ty;

    case ( txt,
           SimCode.VARIABLE(ty = (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_modelica_record(outVar, "));
        txt = writeOutVarRecordMembers(txt, i_ty, a_index, "");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_"));
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(outVar, &out.c"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end writeOutVar;

protected function fun_691
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Integer in_a_index;
  input DAE.Ident in_a_subvar_name;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty, in_a_index, in_a_subvar_name, in_a_prefix)
    local
      Tpl.Text txt;
      Integer a_index;
      DAE.Ident a_subvar_name;
      String a_prefix;
      DAE.Type i_ty;
      Tpl.Text l_newPrefix;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = _)),
           a_index,
           a_subvar_name,
           a_prefix )
      equation
        l_newPrefix = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_newPrefix = Tpl.writeTok(l_newPrefix, Tpl.ST_STRING("._"));
        l_newPrefix = Tpl.writeStr(l_newPrefix, a_subvar_name);
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = writeOutVarRecordMembers(txt, i_ty, a_index, Tpl.textString(l_newPrefix));
      then txt;

    case ( txt,
           i_ty,
           a_index,
           a_subvar_name,
           a_prefix )
      equation
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &(out.c"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeStr(txt, a_prefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("._"));
        txt = Tpl.writeStr(txt, a_subvar_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_691;

protected function lm_692
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Integer in_a_index;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_index, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Integer a_index;
      String a_prefix;
      DAE.Ident i_subvar_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           DAE.TYPES_VAR(ty = i_ty, name = i_subvar_name) :: rest,
           a_index,
           a_prefix )
      equation
        txt = fun_691(txt, i_ty, a_index, i_subvar_name, a_prefix);
        txt = Tpl.nextIter(txt);
        txt = lm_692(txt, rest, a_index, a_prefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_index,
           a_prefix )
      equation
        txt = lm_692(txt, rest, a_index, a_prefix);
      then txt;
  end match;
end lm_692;

protected function fun_693
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_args)
    local
      Tpl.Text txt;
      Tpl.Text i_args;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_args )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_args);
      then txt;
  end match;
end fun_693;

public function writeOutVarRecordMembers
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Integer in_a_index;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_index, in_a_prefix)
    local
      Tpl.Text txt;
      Integer a_index;
      String a_prefix;
      list<DAE.Var> i_vl;
      ClassInf.State i_n;
      Tpl.Text l_args;
      Absyn.Path ret_1;
      Tpl.Text l_basename;

    case ( txt,
           DAE.T_COMPLEX(varLst = i_vl, complexClassType = i_n),
           a_index,
           a_prefix )
      equation
        ret_1 = ClassInf.getStateName(i_n);
        l_basename = underscorePath(Tpl.emptyTxt, ret_1);
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_args = lm_692(l_args, i_vl, a_index, a_prefix);
        l_args = Tpl.popIter(l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = Tpl.writeText(txt, l_basename);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc"));
        txt = fun_693(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", TYPE_DESC_NONE"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end writeOutVarRecordMembers;

protected function fun_695
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "modelica_metatype" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = NULL"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_695;

protected function fun_696
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;

    case ( txt,
           "modelica_metatype",
           a_varName )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_696;

protected function fun_697
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input Tpl.Text in_a_addRoot;
  input Tpl.Text in_a_initVar;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_typ;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outStruct, in_a_addRoot, in_a_initVar, in_a_varName, in_a_typ)
    local
      Tpl.Text txt;
      Tpl.Text a_addRoot;
      Tpl.Text a_initVar;
      Tpl.Text a_varName;
      Tpl.Text a_typ;

    case ( txt,
           "",
           a_addRoot,
           a_initVar,
           a_varName,
           a_typ )
      equation
        txt = Tpl.writeText(txt, a_typ);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeText(txt, a_initVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_addRoot);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_697;

protected function fun_698
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input Integer in_a_i;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outStruct, in_a_i, in_a_var_name)
    local
      Tpl.Text txt;
      Integer a_i;
      DAE.ComponentRef a_var_name;
      String i_outStruct;

    case ( txt,
           "",
           _,
           a_var_name )
      equation
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_outStruct,
           a_i,
           _ )
      equation
        txt = Tpl.writeStr(txt, i_outStruct);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c"));
        txt = Tpl.writeStr(txt, intString(a_i));
      then txt;
  end match;
end fun_698;

protected function lm_699
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_699(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_699;

protected function fun_700
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var_value, in_a_varDecls, in_a_varInits, in_a_var_name)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.ComponentRef a_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_varInits,
           a_var_name )
      equation
        l_defaultValue = contextCref(Tpl.emptyTxt, a_var_name, SimCode.contextFunction);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(" = "));
        (l_defaultValue, a_varInits, a_varDecls) = daeExp(l_defaultValue, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(";"));
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           a_varDecls,
           a_varInits,
           _ )
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_700;

protected function fun_701
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varName;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_a_var_value, in_a_varInits, in_a_varDecls, in_a_varName, in_a_i, in_a_outStruct, in_a_var)
    local
      Tpl.Text txt;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_varName;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(_),
           a_varInits,
           a_varDecls,
           a_varName,
           a_i,
           a_outStruct,
           a_var )
      equation
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           _,
           a_varInits,
           a_varDecls,
           _,
           _,
           _,
           _ )
      then (txt, a_varInits, a_varDecls);
  end match;
end fun_701;

protected function fun_702
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outStruct, in_a_var_name)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;

    case ( txt,
           "",
           a_var_name )
      equation
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           _,
           a_var_name )
      equation
        txt = extVarName(txt, a_var_name);
      then txt;
  end match;
end fun_702;

protected function fun_703
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var_value, in_a_var_name, in_a_varDecls, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_instDims, in_a_varName, in_a_var_ty, in_a_varInits)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varDecls;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      list<DAE.Exp> a_instDims;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;
      Integer ret_4;
      Tpl.Text l_defaultValue1;
      Tpl.Text l_var__name;
      Tpl.Text l_defaultValue;
      Integer ret_0;

    case ( txt,
           SOME(i_exp),
           a_var_name,
           a_varDecls,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_instDims,
           a_varName,
           a_var_ty,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_0 = listLength(a_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        l_var__name = fun_702(Tpl.emptyTxt, a_outStruct, a_var_name);
        l_defaultValue1 = Tpl.writeText(Tpl.emptyTxt, a_varName);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(" = "));
        (l_defaultValue1, a_varInits, a_varDecls) = daeExp(l_defaultValue1, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(";"));
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_instDims,
           a_varName,
           a_var_ty,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_4 = listLength(a_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_4));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_703;

protected function fun_704
  input Tpl.Text in_txt;
  input DAE.Type in_a_var_ty;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Option<DAE.Exp> in_a_var_value;
  input Tpl.Text in_a_instDimsInit;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var_ty, in_a_var_name, in_a_varDecls, in_a_i, in_a_outStruct, in_a_var, in_a_var_value, in_a_instDimsInit, in_a_instDims, in_a_varName, in_a_varInits)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varDecls;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Option<DAE.Exp> a_var_value;
      Tpl.Text a_instDimsInit;
      list<DAE.Exp> a_instDims;
      Tpl.Text a_varName;
      Tpl.Text a_varInits;
      DAE.Type i_var_ty;
      Integer ret_0;

    case ( txt,
           (i_var_ty as DAE.T_COMPLEX(complexClassType = _)),
           _,
           a_varDecls,
           a_i,
           a_outStruct,
           a_var,
           a_var_value,
           a_instDimsInit,
           a_instDims,
           a_varName,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_generic_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", sizeof("));
        a_varInits = expTypeShort(a_varInits, i_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("), "));
        ret_0 = listLength(a_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (txt, a_varInits, a_varDecls) = fun_701(txt, a_var_value, a_varInits, a_varDecls, a_varName, a_i, a_outStruct, a_var);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_var_ty,
           a_var_name,
           a_varDecls,
           a_i,
           a_outStruct,
           a_var,
           a_var_value,
           a_instDimsInit,
           a_instDims,
           a_varName,
           a_varInits )
      equation
        (txt, a_varDecls, a_varInits) = fun_703(txt, a_var_value, a_var_name, a_varDecls, a_i, a_outStruct, a_var, a_instDimsInit, a_instDims, a_varName, i_var_ty, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_704;

protected function fun_705
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input DAE.ComponentRef in_a_var_name;
  input Option<DAE.Exp> in_a_var_value;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_instDims, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_varName, in_a_var_ty, in_a_varDecls, in_a_varInits, in_a_var_name, in_a_var_value)
    local
      Tpl.Text txt;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.ComponentRef a_var_name;
      Option<DAE.Exp> a_var_value;
      list<DAE.Exp> i_instDims;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_var_name,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_700(txt, a_var_value, a_varDecls, a_varInits, a_var_name);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_instDims,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_varName,
           a_var_ty,
           a_varDecls,
           a_varInits,
           a_var_name,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_704(txt, a_var_ty, a_var_name, a_varDecls, a_i, a_outStruct, a_var, a_var_value, a_instDimsInit, i_instDims, a_varName, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_705;

public function varInit
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varFrees;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varFrees;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varFrees) :=
  match(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_varDecls, in_a_varInits, in_a_varFrees)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varFrees;
      DAE.Type i_var_ty;
      Option<DAE.Exp> i_var_value;
      list<DAE.Exp> i_instDims;
      SimCode.Variable i_var;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_ignore;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_varName_1;
      String str_5;
      Tpl.Text l_addRoot;
      String str_3;
      Tpl.Text l_initVar;
      Tpl.Text l_typ;
      Tpl.Text l_varName;

    case ( txt,
           (i_var as SimCode.VARIABLE(parallelism = DAE.NON_PARALLEL(), name = i_var_name, instDims = i_instDims, value = i_var_value, ty = i_var_ty)),
           a_outStruct,
           a_i,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction);
        l_typ = varType(Tpl.emptyTxt, i_var);
        str_3 = Tpl.textString(l_typ);
        l_initVar = fun_695(Tpl.emptyTxt, str_3);
        str_5 = Tpl.textString(l_typ);
        l_addRoot = fun_696(Tpl.emptyTxt, str_5, l_varName);
        a_varDecls = fun_697(a_varDecls, a_outStruct, l_addRoot, l_initVar, l_varName, l_typ);
        l_varName_1 = fun_698(Tpl.emptyTxt, a_outStruct, a_i, i_var_name);
        a_varInits = initRecordMembers(a_varInits, i_var);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_699(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varDecls, a_varInits) = fun_705(txt, i_instDims, a_i, a_outStruct, i_var, l_instDimsInit, l_varName_1, i_var_ty, a_varDecls, a_varInits, i_var_name, i_var_value);
      then (txt, a_varDecls, a_varInits, a_varFrees);

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)),
           a_outStruct,
           a_i,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        (txt, a_varDecls, a_varInits, a_varFrees) = parVarInit(txt, i_var, a_outStruct, a_i, a_varDecls, a_varInits, a_varFrees);
      then (txt, a_varDecls, a_varInits, a_varFrees);

    case ( txt,
           (i_var as SimCode.FUNCTION_PTR(name = _)),
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        l_ignore = Tpl.emptyTxt;
        (a_varDecls, l_ignore) = functionArg(a_varDecls, i_var, l_ignore);
      then (txt, a_varDecls, a_varInits, a_varFrees);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 5268, 12), "Unknown local variable type");
      then (txt, a_varDecls, a_varInits, a_varFrees);
  end match;
end varInit;

protected function lm_707
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_707(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_707;

protected function fun_708
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input Tpl.Text in_a_varInits;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varName;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_a_var_value, in_a_varInits, in_a_var_name, in_a_varName, in_a_var, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varInits;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varName;
      SimCode.Variable a_var;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(i_exp),
           a_varInits,
           a_var_name,
           a_varName,
           a_var,
           a_varDecls )
      equation
        a_varDecls = varType(a_varDecls, a_var);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = Tpl.writeText(a_varDecls, a_varName);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        l_defaultValue = contextCref(Tpl.emptyTxt, a_var_name, SimCode.contextFunction);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(" = "));
        (l_defaultValue, a_varInits, a_varDecls) = daeExp(l_defaultValue, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(";"));
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           _,
           a_varInits,
           _,
           a_varName,
           a_var,
           a_varDecls )
      equation
        a_varDecls = varType(a_varDecls, a_var);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = Tpl.writeText(a_varDecls, a_varName);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varDecls);
  end match;
end fun_708;

protected function fun_709
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_varFrees;
  input Integer in_a_i;
  input String in_a_outStruct;
  input Tpl.Text in_a_instDimsInit;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varInits;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varName;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varDecls;
  input Option<DAE.Exp> in_a_var_value;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varFrees;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varFrees, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_a_instDims, in_a_varFrees, in_a_i, in_a_outStruct, in_a_instDimsInit, in_a_var_ty, in_a_varInits, in_a_var_name, in_a_varName, in_a_var, in_a_varDecls, in_a_var_value)
    local
      Tpl.Text txt;
      Tpl.Text a_varFrees;
      Integer a_i;
      String a_outStruct;
      Tpl.Text a_instDimsInit;
      DAE.Type a_var_ty;
      Tpl.Text a_varInits;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varName;
      SimCode.Variable a_var;
      Tpl.Text a_varDecls;
      Option<DAE.Exp> a_var_value;
      list<DAE.Exp> i_instDims;
      Tpl.Text l_defaultValue;
      Integer ret_0;

    case ( txt,
           {},
           a_varFrees,
           _,
           _,
           _,
           _,
           a_varInits,
           a_var_name,
           a_varName,
           a_var,
           a_varDecls,
           a_var_value )
      equation
        (txt, a_varInits, a_varDecls) = fun_708(txt, a_var_value, a_varInits, a_var_name, a_varName, a_var, a_varDecls);
      then (txt, a_varFrees, a_varInits, a_varDecls);

    case ( txt,
           i_instDims,
           a_varFrees,
           a_i,
           a_outStruct,
           a_instDimsInit,
           a_var_ty,
           a_varInits,
           _,
           a_varName,
           a_var,
           a_varDecls,
           _ )
      equation
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("device_"));
        a_varDecls = expTypeShort(a_varDecls, a_var_ty);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("_array "));
        a_varDecls = Tpl.writeText(a_varDecls, a_varName);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_0 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        a_varFrees = Tpl.writeTok(a_varFrees, Tpl.ST_STRING("free_device_array(&"));
        a_varFrees = Tpl.writeText(a_varFrees, a_varName);
        a_varFrees = Tpl.writeTok(a_varFrees, Tpl.ST_STRING(");"));
        a_varFrees = Tpl.writeTok(a_varFrees, Tpl.ST_NEW_LINE());
      then (txt, a_varFrees, a_varInits, a_varDecls);
  end match;
end fun_709;

public function parVarInit
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varFrees;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varFrees;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varFrees) :=
  match(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_varDecls, in_a_varInits, in_a_varFrees)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varFrees;
      DAE.Type i_var_ty;
      SimCode.Variable i_var;
      Option<DAE.Exp> i_var_value;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_varName;

    case ( txt,
           (i_var as SimCode.VARIABLE(parallelism = DAE.PARGLOBAL(), name = i_var_name, instDims = i_instDims, value = i_var_value, ty = i_var_ty)),
           a_outStruct,
           a_i,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_707(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varFrees, a_varInits, a_varDecls) = fun_709(txt, i_instDims, a_varFrees, a_i, a_outStruct, l_instDimsInit, i_var_ty, a_varInits, i_var_name, l_varName, i_var, a_varDecls, i_var_value);
      then (txt, a_varDecls, a_varInits, a_varFrees);

    case ( txt,
           SimCode.VARIABLE(parallelism = DAE.PARLOCAL()),
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("#PARLOCAL variable type should not be allowed here. FIXME!!"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits, a_varFrees);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("#error Unknown parallel variable type"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 5310, 9), "parVarInit:error Unknown parallel variable type");
      then (txt, a_varDecls, a_varInits, a_varFrees);
  end match;
end parVarInit;

protected function fun_711
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input DAE.ComponentRef in_a_var_name;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outStruct, in_a_var_name, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;
      SimCode.Variable a_var;

    case ( txt,
           "",
           a_var_name,
           a_var )
      equation
        txt = varType(txt, a_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_711;

protected function fun_712
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input Integer in_a_i;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outStruct, in_a_i, in_a_var_name)
    local
      Tpl.Text txt;
      Integer a_i;
      DAE.ComponentRef a_var_name;
      String i_outStruct;

    case ( txt,
           "",
           _,
           a_var_name )
      equation
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_outStruct,
           a_i,
           _ )
      equation
        txt = Tpl.writeStr(txt, i_outStruct);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".targ"));
        txt = Tpl.writeStr(txt, intString(a_i));
      then txt;
  end match;
end fun_712;

protected function lm_713
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_713(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_713;

protected function fun_714
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var_value, in_a_varDecls, in_a_varInits, in_a_var_name)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.ComponentRef a_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_varInits,
           a_var_name )
      equation
        l_defaultValue = contextCref(Tpl.emptyTxt, a_var_name, SimCode.contextFunction);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(" = "));
        (l_defaultValue, a_varInits, a_varDecls) = daeExp(l_defaultValue, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(";"));
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           a_varDecls,
           a_varInits,
           _ )
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_714;

protected function fun_715
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input DAE.ComponentRef in_a_var_name;
  input Option<DAE.Exp> in_a_var_value;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_instDims, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_varName, in_a_var_ty, in_a_varDecls, in_a_varInits, in_a_var_name, in_a_var_value)
    local
      Tpl.Text txt;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.ComponentRef a_var_name;
      Option<DAE.Exp> a_var_value;
      list<DAE.Exp> i_instDims;
      Tpl.Text l_defaultValue;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_var_name,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_714(txt, a_var_value, a_varDecls, a_varInits, a_var_name);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_instDims,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_varName,
           a_var_ty,
           a_varDecls,
           a_varInits,
           _,
           _ )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array_c99_"));
        ret_0 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_1 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_1));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", memory_state);"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_715;

protected function fun_716
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Type i_var_ty;
      Option<DAE.Exp> i_var_value;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      SimCode.Variable i_var;
      Tpl.Text l_ignore;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_varName;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, value = i_var_value, ty = i_var_ty)),
           a_outStruct,
           a_i,
           a_varDecls,
           a_varInits )
      equation
        a_varDecls = fun_711(a_varDecls, a_outStruct, i_var_name, i_var);
        l_varName = fun_712(Tpl.emptyTxt, a_outStruct, a_i, i_var_name);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_713(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varDecls, a_varInits) = fun_715(txt, i_instDims, a_i, a_outStruct, i_var, l_instDimsInit, l_varName, i_var_ty, a_varDecls, a_varInits, i_var_name, i_var_value);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           (i_var as SimCode.FUNCTION_PTR(name = _)),
           _,
           _,
           a_varDecls,
           a_varInits )
      equation
        l_ignore = Tpl.emptyTxt;
        (a_varDecls, l_ignore) = functionArg(a_varDecls, i_var, l_ignore);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits )
      equation
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("#error Unknown local variable type"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 5343, 9), "varInitParallel:error Unknown local variable type");
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_716;

public function varInitParallel
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input String a_outStruct;
  input Integer a_i;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_varInits;
  input Tpl.Text a_varFrees;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varFrees;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) := fun_716(txt, a_var, a_outStruct, a_i, a_varDecls, a_varInits);
  out_a_varFrees := a_varFrees;
end varInitParallel;

protected function fun_718
  input Tpl.Text in_txt;
  input Boolean in_a_arr_scalar;
  input DAE.Exp in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arr_scalar, in_a_e)
    local
      Tpl.Text txt;
      DAE.Exp a_e;

    case ( txt,
           false,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
      then txt;

    case ( txt,
           _,
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = expTypeFromExpModelica(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_718;

protected function lm_719
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_rec__name;
  input Boolean in_a_arr_scalar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_varName, in_a_rec__name, in_a_arr_scalar)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Tpl.Text a_varName;
      Tpl.Text a_rec__name;
      Boolean a_arr_scalar;
      Integer x_i1;
      DAE.Exp i_e;
      Tpl.Text l_prefix;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_e :: rest,
           a_varDecls,
           a_preExp,
           a_varName,
           a_rec__name,
           a_arr_scalar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_prefix = fun_718(Tpl.emptyTxt, a_arr_scalar, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*(("));
        txt = Tpl.writeText(txt, a_rec__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*)generic_array_element_addr(&"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", sizeof("));
        txt = Tpl.writeText(txt, a_rec__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("), 1, "));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))) = "));
        txt = Tpl.writeText(txt, l_prefix);
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_e, SimCode.contextFunction, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_719(txt, rest, a_varDecls, a_preExp, a_varName, a_rec__name, a_arr_scalar);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_719;

protected function fun_720
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_value;
  input String in_a_lhsVarName;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;
  input DAE.ComponentRef in_a_var_name;
  input Integer in_a_i;
  input String in_a_outStruct;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_a_value, in_a_lhsVarName, in_a_varInits, in_a_varDecls, in_a_var_name, in_a_i, in_a_outStruct, in_a_var_ty)
    local
      Tpl.Text txt;
      String a_lhsVarName;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      DAE.ComponentRef a_var_name;
      Integer a_i;
      String a_outStruct;
      DAE.Type a_var_ty;
      DAE.Exp i_arr;
      Boolean i_arr_scalar;
      list<DAE.Exp> i_arr_array;
      ClassInf.State i_record__state;
      DAE.ComponentRef i_cr;
      Tpl.Text l_arrayExp;
      Tpl.Text l_params;
      Tpl.Text l_preExp;
      Absyn.Path ret_2;
      Tpl.Text l_rec__name;
      Tpl.Text l_varName;

    case ( txt,
           SOME(DAE.CREF(componentRef = i_cr)),
           _,
           a_varInits,
           a_varDecls,
           _,
           a_i,
           a_outStruct,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data(&"));
        txt = contextCref(txt, i_cr, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeStr(txt, a_outStruct);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c"));
        txt = Tpl.writeStr(txt, intString(a_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           SOME(DAE.ARRAY(ty = DAE.T_ARRAY(ty = DAE.T_COMPLEX(complexClassType = i_record__state)), array = i_arr_array, scalar = i_arr_scalar)),
           _,
           a_varInits,
           a_varDecls,
           a_var_name,
           _,
           _,
           _ )
      equation
        l_varName = contextCref(Tpl.emptyTxt, a_var_name, SimCode.contextFunction);
        ret_2 = ClassInf.getStateName(i_record__state);
        l_rec__name = underscorePath(Tpl.emptyTxt, ret_2);
        l_preExp = Tpl.emptyTxt;
        l_params = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_params, a_varDecls, l_preExp) = lm_719(l_params, i_arr_array, a_varDecls, l_preExp, l_varName, l_rec__name, i_arr_scalar);
        l_params = Tpl.popIter(l_params);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_params);
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           SOME((i_arr as DAE.ARRAY(ty = _))),
           a_lhsVarName,
           a_varInits,
           a_varDecls,
           _,
           _,
           _,
           a_var_ty )
      equation
        (l_arrayExp, a_varInits, a_varDecls) = daeExp(Tpl.emptyTxt, i_arr, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data(&"));
        txt = Tpl.writeText(txt, l_arrayExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeStr(txt, a_lhsVarName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           _,
           _,
           a_varInits,
           a_varDecls,
           _,
           _,
           _,
           _ )
      then (txt, a_varInits, a_varDecls);
  end match;
end fun_720;

public function varDefaultValue
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input String in_a_lhsVarName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_lhsVarName, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      String a_lhsVarName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.ComponentRef i_var_name;
      DAE.Type i_var_ty;
      Option<DAE.Exp> i_value;

    case ( txt,
           SimCode.VARIABLE(value = i_value, ty = i_var_ty, name = i_var_name),
           a_outStruct,
           a_i,
           a_lhsVarName,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = fun_720(txt, i_value, a_lhsVarName, a_varInits, a_varDecls, i_var_name, a_i, a_outStruct, i_var_ty);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);
  end match;
end varDefaultValue;

protected function lm_722
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = mmcVarType(txt, i_arg);
        txt = lm_722(txt, rest);
      then txt;
  end match;
end lm_722;

protected function lm_723
  input Tpl.Text in_txt;
  input list<DAE.Type> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Type> rest;
      Integer x_i1;
      DAE.Type i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ty :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = mmcTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" c"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_723(txt, rest);
      then txt;
  end match;
end lm_723;

protected function fun_724
  input Tpl.Text in_txt;
  input list<DAE.Type> in_a_tys;
  input Tpl.Text in_a_rettype;
  input Tpl.Text in_a_typelist;
  input String in_a_name;
  input Tpl.Text in_a_varInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInit;
algorithm
  (out_txt, out_a_varInit) :=
  match(in_txt, in_a_tys, in_a_rettype, in_a_typelist, in_a_name, in_a_varInit)
    local
      Tpl.Text txt;
      Tpl.Text a_rettype;
      Tpl.Text a_typelist;
      String a_name;
      Tpl.Text a_varInit;
      list<DAE.Type> i_tys;

    case ( txt,
           {},
           _,
           a_typelist,
           a_name,
           a_varInit )
      equation
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("omc_"));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(" = (void(*)(threadData_t *"));
        a_varInit = Tpl.writeText(a_varInit, a_typelist);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(")) "));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(";"));
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void(*omc_"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")(threadData_t *"));
        txt = Tpl.writeText(txt, a_typelist);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInit);

    case ( txt,
           i_tys,
           a_rettype,
           a_typelist,
           a_name,
           a_varInit )
      equation
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("omc_"));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(" = ("));
        a_varInit = Tpl.writeText(a_varInit, a_rettype);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("(*)(threadData_t *"));
        a_varInit = Tpl.writeText(a_varInit, a_typelist);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(")) "));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(";"));
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_s {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_723(txt, i_tys);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*omc_"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")(threadData_t *"));
        txt = Tpl.writeText(txt, a_typelist);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInit);
  end match;
end fun_724;

public function functionArg
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInit;
algorithm
  (out_txt, out_a_varInit) :=
  match(in_txt, in_a_var, in_a_varInit)
    local
      Tpl.Text txt;
      Tpl.Text a_varInit;
      list<DAE.Type> i_tys;
      String i_name;
      list<SimCode.Variable> i_args;
      Tpl.Text l_rettype;
      Tpl.Text l_typelist;

    case ( txt,
           SimCode.FUNCTION_PTR(args = i_args, name = i_name, tys = i_tys),
           a_varInit )
      equation
        l_typelist = lm_722(Tpl.emptyTxt, i_args);
        l_rettype = Tpl.writeStr(Tpl.emptyTxt, i_name);
        l_rettype = Tpl.writeTok(l_rettype, Tpl.ST_STRING("_rettype"));
        (txt, a_varInit) = fun_724(txt, i_tys, l_rettype, l_typelist, i_name, a_varInit);
      then (txt, a_varInit);

    case ( txt,
           _,
           a_varInit )
      then (txt, a_varInit);
  end match;
end functionArg;

protected function lm_726
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_726(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_726;

protected function fun_727
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input DAE.Type in_a_var_ty;
  input DAE.ComponentRef in_a_var_name;
  input Integer in_a_ix;
  input String in_a_dest;
  input Tpl.Text in_a_varAssign;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varAssign, out_a_varInits) :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_var_ty, in_a_var_name, in_a_ix, in_a_dest, in_a_varAssign, in_a_var, in_a_varInits)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      DAE.Type a_var_ty;
      DAE.ComponentRef a_var_name;
      Integer a_ix;
      String a_dest;
      Tpl.Text a_varAssign;
      SimCode.Variable a_var;
      Tpl.Text a_varInits;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           a_var,
           a_varInits )
      equation
        a_varInits = initRecordMembers(a_varInits, a_var);
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);

    case ( txt,
           i_instDims,
           a_instDimsInit,
           a_var_ty,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           _,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeStr(a_varInits, a_dest);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".c"));
        a_varInits = Tpl.writeStr(a_varInits, intString(a_ix));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_0 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("copy_"));
        a_varAssign = expTypeShort(a_varAssign, a_var_ty);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_array_data(&"));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(", &"));
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);
  end match;
end fun_727;

protected function fun_728
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_dest;
  input Integer in_a_ix;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varAssign) :=
  match(in_txt, in_a_var, in_a_dest, in_a_ix, in_a_varDecls, in_a_varInits, in_a_varAssign)
    local
      Tpl.Text txt;
      String a_dest;
      Integer a_ix;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varAssign;
      String i_var_name_1;
      DAE.Type i_var_ty;
      DAE.ComponentRef i_var_name;
      SimCode.Variable i_var;
      list<DAE.Exp> i_instDims;
      Tpl.Text l_instDimsInit;

    case ( txt,
           (i_var as SimCode.VARIABLE(instDims = i_instDims, name = i_var_name, ty = i_var_ty)),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varAssign )
      equation
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_726(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varAssign, a_varInits) = fun_727(txt, i_instDims, l_instDimsInit, i_var_ty, i_var_name, a_ix, a_dest, a_varAssign, i_var, a_varInits);
      then (txt, a_varDecls, a_varInits, a_varAssign);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_var_name_1),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varAssign )
      equation
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = (modelica_fnptr) omc_"));
        a_varAssign = Tpl.writeStr(a_varAssign, i_var_name_1);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits, a_varAssign);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varAssign )
      then (txt, a_varDecls, a_varInits, a_varAssign);
  end match;
end fun_728;

public function varOutput
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input String a_dest;
  input Integer a_ix;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_varInits;
  input Tpl.Text a_varCopy;
  input Tpl.Text a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varAssign) := fun_728(txt, a_var, a_dest, a_ix, a_varDecls, a_varInits, a_varAssign);
  out_a_varCopy := a_varCopy;
end varOutput;

protected function fun_730
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varAssign;
  input Tpl.Text in_a_varCopy;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varCopy;
algorithm
  (out_txt, out_a_varAssign, out_a_varCopy) :=
  match(in_txt, in_mArg, in_a_varAssign, in_a_varCopy)
    local
      Tpl.Text txt;
      Tpl.Text a_varAssign;
      Tpl.Text a_varCopy;

    case ( txt,
           false,
           a_varAssign,
           a_varCopy )
      equation
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING("String Variables not Allowed in ParModelica."));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("   String Variables not Allowed in ParModelica."));
      then (txt, a_varAssign, a_varCopy);

    case ( txt,
           _,
           a_varAssign,
           a_varCopy )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("How did you get here??"));
      then (txt, a_varAssign, a_varCopy);
  end match;
end fun_730;

protected function lm_731
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_731(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_731;

protected function fun_732
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varAssign;
  input DAE.Type in_a_var_ty;
  input Integer in_a_ix;
  input String in_a_dest;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varAssign, out_a_varInits) :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_var_name, in_a_varAssign, in_a_var_ty, in_a_ix, in_a_dest, in_a_varInits)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varAssign;
      DAE.Type a_var_ty;
      Integer a_ix;
      String a_dest;
      Tpl.Text a_varInits;
      list<DAE.Exp> i_instDims;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           a_var_name,
           a_varAssign,
           a_var_ty,
           a_ix,
           a_dest,
           a_varInits )
      equation
        a_varInits = Tpl.writeStr(a_varInits, a_dest);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".c"));
        a_varInits = Tpl.writeStr(a_varInits, intString(a_ix));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(" = ocl_device_alloc(sizeof(modelica_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("));"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("copy_assignment_helper_"));
        a_varAssign = expTypeShort(a_varAssign, a_var_ty);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("(&"));
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(", &"));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);

    case ( txt,
           i_instDims,
           a_instDimsInit,
           a_var_name,
           a_varAssign,
           a_var_ty,
           a_ix,
           a_dest,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array_c99_"));
        ret_0 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("(&"));
        a_varInits = Tpl.writeStr(a_varInits, a_dest);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".c"));
        a_varInits = Tpl.writeStr(a_varInits, intString(a_ix));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_1 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_1));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", memory_state);"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("copy_"));
        a_varAssign = expTypeShort(a_varAssign, a_var_ty);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_array_data(&"));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(", &"));
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);
  end match;
end fun_732;

protected function lm_733
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_733(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_733;

protected function fun_734
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varAssign;
  input DAE.Type in_a_var_ty;
  input Integer in_a_ix;
  input String in_a_dest;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varAssign, out_a_varInits) :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_var_name, in_a_varAssign, in_a_var_ty, in_a_ix, in_a_dest, in_a_varInits)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varAssign;
      DAE.Type a_var_ty;
      Integer a_ix;
      String a_dest;
      Tpl.Text a_varInits;
      list<DAE.Exp> i_instDims;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           a_var_name,
           a_varAssign,
           a_var_ty,
           a_ix,
           a_dest,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("LOCAL HERE!! "));
        a_varInits = Tpl.writeStr(a_varInits, a_dest);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".c"));
        a_varInits = Tpl.writeStr(a_varInits, intString(a_ix));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(" = ocl_device_alloc(sizeof(modelica_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("));"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("LOCAL HERE!! copy_assignment_helper_"));
        a_varAssign = expTypeShort(a_varAssign, a_var_ty);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("(&"));
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(", &"));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);

    case ( txt,
           i_instDims,
           a_instDimsInit,
           a_var_name,
           a_varAssign,
           a_var_ty,
           a_ix,
           a_dest,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array_c99_"));
        ret_0 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("(&"));
        a_varInits = Tpl.writeStr(a_varInits, a_dest);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".c"));
        a_varInits = Tpl.writeStr(a_varInits, intString(a_ix));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_1 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_1));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", memory_state);"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("copy_"));
        a_varAssign = expTypeShort(a_varAssign, a_var_ty);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_array_data(&"));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(", &"));
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);
  end match;
end fun_734;

protected function lm_735
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_735(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_735;

protected function fun_736
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input DAE.Type in_a_var_ty;
  input DAE.ComponentRef in_a_var_name;
  input Integer in_a_ix;
  input String in_a_dest;
  input Tpl.Text in_a_varAssign;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varAssign, out_a_varInits) :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_var_ty, in_a_var_name, in_a_ix, in_a_dest, in_a_varAssign, in_a_var, in_a_varInits)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      DAE.Type a_var_ty;
      DAE.ComponentRef a_var_name;
      Integer a_ix;
      String a_dest;
      Tpl.Text a_varAssign;
      SimCode.Variable a_var;
      Tpl.Text a_varInits;
      list<DAE.Exp> i_instDims;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           a_var,
           a_varInits )
      equation
        a_varInits = initRecordMembers(a_varInits, a_var);
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);

    case ( txt,
           i_instDims,
           a_instDimsInit,
           a_var_ty,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           _,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array_c99_"));
        ret_0 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("(&"));
        a_varInits = Tpl.writeStr(a_varInits, a_dest);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".c"));
        a_varInits = Tpl.writeStr(a_varInits, intString(a_ix));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_1 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_1));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", memory_state);"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("copy_"));
        a_varAssign = expTypeShort(a_varAssign, a_var_ty);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_array_data(&"));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(", &"));
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);
  end match;
end fun_736;

public function varOutputParallel
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_dest;
  input Integer in_a_ix;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varCopy, out_a_varAssign) :=
  match(in_txt, in_a_var, in_a_dest, in_a_ix, in_a_varDecls, in_a_varInits, in_a_varCopy, in_a_varAssign)
    local
      Tpl.Text txt;
      String a_dest;
      Integer a_ix;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varCopy;
      Tpl.Text a_varAssign;
      String i_var_name_1;
      SimCode.Variable i_var;
      DAE.ComponentRef i_var_name;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;
      Tpl.Text l_instDimsInit;
      Boolean ret_0;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_STRING(varLst = _)),
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        (txt, a_varAssign, a_varCopy) = fun_730(txt, ret_0, a_varAssign, a_varCopy);
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           SimCode.VARIABLE(parallelism = DAE.PARGLOBAL(), instDims = i_instDims, ty = i_var_ty, name = i_var_name),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      equation
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_731(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varAssign, a_varInits) = fun_732(txt, i_instDims, l_instDimsInit, i_var_name, a_varAssign, i_var_ty, a_ix, a_dest, a_varInits);
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           SimCode.VARIABLE(parallelism = DAE.PARLOCAL(), instDims = i_instDims, ty = i_var_ty, name = i_var_name),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      equation
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_733(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varAssign, a_varInits) = fun_734(txt, i_instDims, l_instDimsInit, i_var_name, a_varAssign, i_var_ty, a_ix, a_dest, a_varInits);
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           (i_var as SimCode.VARIABLE(instDims = i_instDims, name = i_var_name, ty = i_var_ty)),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      equation
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_735(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varAssign, a_varInits) = fun_736(txt, i_instDims, l_instDimsInit, i_var_ty, i_var_name, a_ix, a_dest, a_varAssign, i_var, a_varInits);
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_var_name_1),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      equation
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = (modelica_fnptr) _"));
        a_varAssign = Tpl.writeStr(a_varAssign, i_var_name_1);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);
  end match;
end varOutputParallel;

protected function lm_738
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_738(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_738;

protected function fun_739
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input DAE.ComponentRef in_a_var_name;
  input Integer in_a_ix;
  input String in_a_dest;
  input Tpl.Text in_a_varAssign;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varAssign, out_a_varInits) :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_var_name, in_a_ix, in_a_dest, in_a_varAssign, in_a_var_ty, in_a_varName, in_a_varInits)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      DAE.ComponentRef a_var_name;
      Integer a_ix;
      String a_dest;
      Tpl.Text a_varAssign;
      DAE.Type a_var_ty;
      Tpl.Text a_varName;
      Tpl.Text a_varInits;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           _,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           a_var_ty,
           a_varName,
           a_varInits )
      equation
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(" = ocl_device_alloc(sizeof(modelica_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("));"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);

    case ( txt,
           i_instDims,
           a_instDimsInit,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           a_var_ty,
           a_varName,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_0 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);
  end match;
end fun_739;

protected function lm_740
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_740(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_740;

protected function fun_741
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input DAE.ComponentRef in_a_var_name;
  input Integer in_a_ix;
  input String in_a_dest;
  input Tpl.Text in_a_varAssign;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varAssign, out_a_varInits) :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_var_name, in_a_ix, in_a_dest, in_a_varAssign, in_a_var_ty, in_a_varName, in_a_varInits)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      DAE.ComponentRef a_var_name;
      Integer a_ix;
      String a_dest;
      Tpl.Text a_varAssign;
      DAE.Type a_var_ty;
      Tpl.Text a_varName;
      Tpl.Text a_varInits;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           _,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           a_var_ty,
           a_varName,
           a_varInits )
      equation
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(" = ocl_device_alloc(sizeof(modelica_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("));"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);

    case ( txt,
           i_instDims,
           a_instDimsInit,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           a_var_ty,
           a_varName,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_0 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);
  end match;
end fun_741;

protected function lm_742
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_742(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_742;

protected function fun_743
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;
  input DAE.ComponentRef in_a_var_name;
  input Integer in_a_ix;
  input String in_a_dest;
  input Tpl.Text in_a_varAssign;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varAssign, out_a_varInits) :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_varName, in_a_var_ty, in_a_var_name, in_a_ix, in_a_dest, in_a_varAssign, in_a_var, in_a_varInits)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;
      DAE.ComponentRef a_var_name;
      Integer a_ix;
      String a_dest;
      Tpl.Text a_varAssign;
      SimCode.Variable a_var;
      Tpl.Text a_varInits;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           _,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           a_var,
           a_varInits )
      equation
        a_varInits = initRecordMembers(a_varInits, a_var);
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);

    case ( txt,
           i_instDims,
           a_instDimsInit,
           a_varName,
           a_var_ty,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           _,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_0 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);
  end match;
end fun_743;

protected function fun_744
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_dest;
  input Integer in_a_ix;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varAssign) :=
  match(in_txt, in_a_var, in_a_dest, in_a_ix, in_a_varDecls, in_a_varInits, in_a_varAssign)
    local
      Tpl.Text txt;
      String a_dest;
      Integer a_ix;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varAssign;
      String i_var_name_1;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      SimCode.Variable i_var;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_varName;

    case ( txt,
           (i_var as SimCode.VARIABLE(parallelism = DAE.PARGLOBAL(), name = i_var_name, instDims = i_instDims, ty = i_var_ty)),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varAssign )
      equation
        a_varDecls = varType(a_varDecls, i_var);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = contextCref(a_varDecls, i_var_name, SimCode.contextFunction);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_738(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varAssign, a_varInits) = fun_739(txt, i_instDims, l_instDimsInit, i_var_name, a_ix, a_dest, a_varAssign, i_var_ty, l_varName, a_varInits);
      then (txt, a_varDecls, a_varInits, a_varAssign);

    case ( txt,
           (i_var as SimCode.VARIABLE(parallelism = DAE.PARLOCAL(), name = i_var_name, instDims = i_instDims, ty = i_var_ty)),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varAssign )
      equation
        a_varDecls = varType(a_varDecls, i_var);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = contextCref(a_varDecls, i_var_name, SimCode.contextFunction);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_740(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varAssign, a_varInits) = fun_741(txt, i_instDims, l_instDimsInit, i_var_name, a_ix, a_dest, a_varAssign, i_var_ty, l_varName, a_varInits);
      then (txt, a_varDecls, a_varInits, a_varAssign);

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, ty = i_var_ty)),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varAssign )
      equation
        a_varDecls = varType(a_varDecls, i_var);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = contextCref(a_varDecls, i_var_name, SimCode.contextFunction);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_742(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varAssign, a_varInits) = fun_743(txt, i_instDims, l_instDimsInit, l_varName, i_var_ty, i_var_name, a_ix, a_dest, a_varAssign, i_var, a_varInits);
      then (txt, a_varDecls, a_varInits, a_varAssign);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_var_name_1),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varAssign )
      equation
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = (modelica_fnptr) _"));
        a_varAssign = Tpl.writeStr(a_varAssign, i_var_name_1);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits, a_varAssign);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varAssign )
      then (txt, a_varDecls, a_varInits, a_varAssign);
  end match;
end fun_744;

public function varOutputKernelInterface
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input String a_dest;
  input Integer a_ix;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_varInits;
  input Tpl.Text a_varCopy;
  input Tpl.Text a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varAssign) := fun_744(txt, a_var, a_dest, a_ix, a_varDecls, a_varInits, a_varAssign);
  out_a_varCopy := a_varCopy;
end varOutputKernelInterface;

protected function lm_746
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varName;
algorithm
  (out_txt, out_a_varName) :=
  match(in_txt, in_items, in_a_varName)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Tpl.Text a_varName;
      DAE.Var i_v;

    case ( txt,
           {},
           a_varName )
      then (txt, a_varName);

    case ( txt,
           i_v :: rest,
           a_varName )
      equation
        (txt, a_varName) = recordMemberInit(txt, i_v, a_varName);
        txt = Tpl.nextIter(txt);
        (txt, a_varName) = lm_746(txt, rest, a_varName);
      then (txt, a_varName);
  end match;
end lm_746;

public function initRecordMembers
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      list<DAE.Var> i_ty_varLst;
      DAE.ComponentRef i_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _), varLst = i_ty_varLst), name = i_name) )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_name, SimCode.contextFunction);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varName) = lm_746(txt, i_ty_varLst, l_varName);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end initRecordMembers;

protected function lm_748
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_748(txt, rest);
      then txt;
  end match;
end lm_748;

protected function fun_749
  input Tpl.Text in_txt;
  input DAE.Var in_a_v;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_v, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      DAE.Ident i_name;
      DAE.Dimensions i_ty_dims;
      DAE.Type i_ty;
      Integer ret_2;
      Tpl.Text l_dims;
      Tpl.Text l_arrayType;

    case ( txt,
           DAE.TYPES_VAR(ty = (i_ty as DAE.T_ARRAY(dims = i_ty_dims)), name = i_name),
           a_varName )
      equation
        l_arrayType = expType(Tpl.emptyTxt, i_ty, true);
        l_dims = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dims = lm_748(l_dims, i_ty_dims);
        l_dims = Tpl.popIter(l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("alloc_"));
        txt = Tpl.writeText(txt, l_arrayType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("._"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        ret_2 = listLength(i_ty_dims);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_749;

public function recordMemberInit
  input Tpl.Text txt;
  input DAE.Var a_v;
  input Tpl.Text a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varName;
algorithm
  out_txt := fun_749(txt, a_v, a_varName);
  out_a_varName := a_varName;
end recordMemberInit;

public function extVarName
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := contextCref(txt, a_cr, SimCode.contextFunction);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_ext"));
end extVarName;

protected function fun_752
  input Tpl.Text in_txt;
  input String in_a_language;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Function in_a_fun;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_language, in_a_varDecls, in_a_preExp, in_a_fun)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Function a_fun;

    case ( txt,
           "C",
           a_varDecls,
           a_preExp,
           a_fun )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallC(txt, a_fun, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           "FORTRAN 77",
           a_varDecls,
           a_preExp,
           a_fun )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallF77(txt, a_fun, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_752;

public function extFunCall
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_fun, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.Function i_fun;
      String i_language;

    case ( txt,
           (i_fun as SimCode.EXTERNAL_FUNCTION(language = i_language)),
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_752(txt, i_language, a_varDecls, a_preExp, i_fun);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end extFunCall;

protected function lm_754
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_arg :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardecl(txt, i_arg, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_754(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_754;

protected function fun_755
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;

    case ( txt,
           false,
           _,
           a_extName )
      equation
        txt = Tpl.writeStr(txt, a_extName);
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ptr_"));
        txt = extFunctionName(txt, a_extName, a_language);
      then txt;
  end match;
end fun_755;

protected function fun_756
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;
  input Absyn.Info in_a_info;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName, in_a_info, in_a_fname)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;
      Absyn.Info a_info;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName,
           a_info,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if("));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "==NULL)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("FILE_INFO info = {"));
        txt = infoArgs(txt, a_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "omc_terminate(info, \"dynamic external function "
                                }, false));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" not set!\");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} else"));
      then txt;
  end match;
end fun_756;

protected function lm_757
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extArg(txt, i_arg, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_757(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_757;

protected function fun_758
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c) )
      equation
        txt = extVarName(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_758;

protected function fun_759
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_extReturn, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)),
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardecl(txt, i_extReturn, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_759;

protected function lm_760
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunCallVarcopy(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_760(txt, rest);
      then txt;
  end match;
end lm_760;

protected function fun_761
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)) )
      equation
        txt = extFunCallVarcopy(txt, i_extReturn);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_761;

public function extFunCallC
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_fun, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_extReturn;
      Absyn.Info i_info;
      String i_language;
      String i_extName;
      Boolean i_dynamicLoad;
      list<SimCode.SimExtArg> i_extArgs;
      Tpl.Text l_returnAssign;
      Tpl.Text l_args;
      Tpl.Text l_dynamicCheck;
      Tpl.Text l_fname;
      list<SimCode.SimExtArg> ret_1;
      Tpl.Text l_varDecs;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, dynamicLoad = i_dynamicLoad, extName = i_extName, language = i_language, info = i_info, extReturn = i_extReturn),
           a_preExp,
           a_varDecls )
      equation
        ret_1 = List.union(i_extArgs, i_extArgs);
        l_varDecs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_varDecs, a_varDecls) = lm_754(l_varDecs, ret_1, a_varDecls);
        l_varDecs = Tpl.popIter(l_varDecs);
        l_fname = fun_755(Tpl.emptyTxt, i_dynamicLoad, i_language, i_extName);
        l_dynamicCheck = fun_756(Tpl.emptyTxt, i_dynamicLoad, i_language, i_extName, i_info, l_fname);
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_args, a_varDecls, a_preExp) = lm_757(l_args, i_extArgs, a_varDecls, a_preExp);
        l_args = Tpl.popIter(l_args);
        l_returnAssign = fun_758(Tpl.emptyTxt, i_extReturn);
        txt = Tpl.writeText(txt, l_varDecs);
        txt = Tpl.softNewLine(txt);
        (txt, a_varDecls) = fun_759(txt, i_extReturn, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_dynamicCheck);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_returnAssign);
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_760(txt, i_extArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_761(txt, i_extReturn);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end extFunCallC;

protected function lm_763
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_arg :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardeclF77(txt, i_arg, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_763(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_763;

protected function lm_764
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Variable i_arg;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallBiVarF77(txt, i_arg, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_764(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_764;

protected function lm_765
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extArgF77(txt, i_arg, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_765(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_765;

protected function fun_766
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c) )
      equation
        txt = extVarName(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_766;

protected function fun_767
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_extReturn, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)),
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardeclF77(txt, i_extReturn, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_767;

protected function lm_768
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunCallVarcopyF77(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_768(txt, rest);
      then txt;
  end match;
end lm_768;

protected function fun_769
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)) )
      equation
        txt = extFunCallVarcopyF77(txt, i_extReturn);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_769;

public function extFunCallF77
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_fun, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      String i_extName;
      SimCode.SimExtArg i_extReturn;
      list<SimCode.Variable> i_biVars;
      list<SimCode.SimExtArg> i_extArgs;
      list<SimCode.SimExtArg> ret_5;
      Tpl.Text l_returnAssign;
      Tpl.Text l_args;
      Tpl.Text l_biVarDecs;
      list<SimCode.SimExtArg> ret_1;
      Tpl.Text l_varDecs;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, biVars = i_biVars, extReturn = i_extReturn, extName = i_extName),
           a_preExp,
           a_varDecls )
      equation
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("/* extFunCallF77: varDecs */"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        ret_1 = List.union(i_extArgs, i_extArgs);
        l_varDecs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_varDecs, a_varDecls) = lm_763(l_varDecs, ret_1, a_varDecls);
        l_varDecs = Tpl.popIter(l_varDecs);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("/* extFunCallF77: biVarDecs */"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("/* extFunCallF77: biVarDecs */"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        l_biVarDecs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_biVarDecs, a_varDecls, a_preExp) = lm_764(l_biVarDecs, i_biVars, a_varDecls, a_preExp);
        l_biVarDecs = Tpl.popIter(l_biVarDecs);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("/* extFunCallF77: args */"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("/* extFunCallF77: args */"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_args, a_varDecls, a_preExp) = lm_765(l_args, i_extArgs, a_varDecls, a_preExp);
        l_args = Tpl.popIter(l_args);
        l_returnAssign = fun_766(Tpl.emptyTxt, i_extReturn);
        txt = Tpl.writeText(txt, l_varDecs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_biVarDecs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* extFunCallF77: extReturn */\n"));
        (txt, a_varDecls) = fun_767(txt, i_extReturn, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* extFunCallF77: CALL */\n"));
        txt = Tpl.writeText(txt, l_returnAssign);
        txt = Tpl.writeStr(txt, i_extName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_("));
        txt = Tpl.writeText(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "/* extFunCallF77: copy args */\n"
                                }, true));
        ret_5 = List.union(i_extArgs, i_extArgs);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_768(txt, ret_5);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* extFunCallF77: copy return */\n"));
        txt = fun_769(txt, i_extReturn);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end extFunCallF77;

protected function fun_771
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;

    case ( txt,
           "integer",
           a_c )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pack_integer_array(&"));
        txt = contextCref(txt, a_c, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_771;

protected function fun_772
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_ty, in_a_c, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Tpl.Text a_varDecls;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_ty,
           a_c,
           a_varDecls )
      equation
        a_varDecls = extType(a_varDecls, i_ty, true, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = extVarName(txt, a_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = extType(txt, i_ty, true, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = contextCref(txt, a_c, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);
  end match;
end fun_772;

protected function fun_773
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_oi, in_a_c, in_a_ty, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      DAE.Type a_ty;
      Tpl.Text a_varDecls;

    case ( txt,
           0,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_c,
           a_ty,
           a_varDecls )
      equation
        a_varDecls = extType(a_varDecls, a_ty, true, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);
  end match;
end fun_773;

public function extFunCallVardecl
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_arg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Integer i_oi;
      DAE.ComponentRef i_c;
      DAE.Type i_ty;
      String str_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.SIMEXTARG(isInput = true, isArray = true, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        txt_0 = expTypeShort(Tpl.emptyTxt, i_ty);
        str_1 = Tpl.textString(txt_0);
        txt = fun_771(txt, str_1, i_c);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(isInput = true, isArray = false, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_772(txt, i_ty, i_c, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_773(txt, i_oi, i_c, i_ty, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end extFunCallVardecl;

protected function fun_775
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_default__val;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_default__val)
    local
      Tpl.Text txt;
      Tpl.Text a_default__val;

    case ( txt,
           "",
           _ )
      then txt;

    case ( txt,
           _,
           a_default__val )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = Tpl.writeText(txt, a_default__val);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_775;

protected function fun_776
  input Tpl.Text in_txt;
  input Boolean in_a_ea_hasBinding;
  input Tpl.Text in_a_default__val;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ea_hasBinding, in_a_default__val)
    local
      Tpl.Text txt;
      Tpl.Text a_default__val;
      String str_0;

    case ( txt,
           false,
           a_default__val )
      equation
        str_0 = Tpl.textString(a_default__val);
        txt = fun_775(txt, str_0, a_default__val);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_776;

protected function fun_777
  input Tpl.Text in_txt;
  input Boolean in_a_ia;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_varDecls;
  input Boolean in_a_ea_hasBinding;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_ia, in_a_oi, in_a_c, in_a_varDecls, in_a_ea_hasBinding, in_a_ty)
    local
      Tpl.Text txt;
      Integer a_oi;
      DAE.ComponentRef a_c;
      Tpl.Text a_varDecls;
      Boolean a_ea_hasBinding;
      DAE.Type a_ty;
      Tpl.Text l_default__exp;
      Tpl.Text l_default__val;

    case ( txt,
           false,
           _,
           a_c,
           a_varDecls,
           a_ea_hasBinding,
           a_ty )
      equation
        l_default__val = typeDefaultValue(Tpl.emptyTxt, a_ty);
        l_default__exp = fun_776(Tpl.emptyTxt, a_ea_hasBinding, l_default__val);
        a_varDecls = extTypeF77(a_varDecls, a_ty, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, a_c);
        a_varDecls = Tpl.writeText(a_varDecls, l_default__exp);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_oi,
           a_c,
           a_varDecls,
           _,
           a_ty )
      equation
        a_varDecls = expTypeArrayIf(a_varDecls, a_ty);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("convert_alloc_"));
        txt = expTypeArray(txt, a_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_to_f77(&out.c"));
        txt = Tpl.writeStr(txt, intString(a_oi));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = extVarName(txt, a_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);
  end match;
end fun_777;

protected function fun_778
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_varDecls;
  input Boolean in_a_ea_hasBinding;
  input DAE.Type in_a_ty;
  input Boolean in_a_ia;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_oi, in_a_c, in_a_varDecls, in_a_ea_hasBinding, in_a_ty, in_a_ia)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Tpl.Text a_varDecls;
      Boolean a_ea_hasBinding;
      DAE.Type a_ty;
      Boolean a_ia;
      Integer i_oi;

    case ( txt,
           0,
           _,
           a_varDecls,
           _,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_oi,
           a_c,
           a_varDecls,
           a_ea_hasBinding,
           a_ty,
           a_ia )
      equation
        (txt, a_varDecls) = fun_777(txt, a_ia, i_oi, a_c, a_varDecls, a_ea_hasBinding, a_ty);
      then (txt, a_varDecls);
  end match;
end fun_778;

public function extFunCallVardeclF77
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_arg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Boolean i_ea_hasBinding;
      Boolean i_ia;
      Integer i_oi;
      DAE.ComponentRef i_c;
      DAE.Type i_ty;

    case ( txt,
           SimCode.SIMEXTARG(isInput = true, isArray = true, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        a_varDecls = expTypeArrayIf(a_varDecls, i_ty);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, i_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("convert_alloc_"));
        txt = expTypeArray(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_to_f77(&"));
        txt = contextCref(txt, i_c, SimCode.contextFunction);
        txt = Tpl.writeTok(tx