encapsulated package CodegenCpp
"
  file:        CodegenCpp.mo
  package:     CodegenCpp
  description: Generated by Susan.
"

public import Tpl;

public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCode;
public import HpcOmScheduler;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      String i_fileNamePrefix;
      list<DAE.Exp> i_literals;
      list<SimCode.Function> i_modelInfo_functions;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> ret_10;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      String ret_1;
      Tpl.Text l_target;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name, functions = i_modelInfo_functions), literals = i_literals, fileNamePrefix = i_fileNamePrefix, allEquations = i_allEquations, initialEquations = i_initialEquations)) )
      equation
        ret_1 = Config.simulationCodeTarget();
        l_target = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        txt_2 = simulationHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_3 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt_4 = simulationCppFile(Tpl.emptyTxt, i_simCode);
        txt_5 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING(".cpp"));
        Tpl.textFile(txt_4, Tpl.textString(txt_5));
        txt_6 = simulationFunctionsHeaderFile(Tpl.emptyTxt, i_simCode, i_modelInfo_functions, i_literals);
        Tpl.textFile(txt_6, "Functions.h");
        txt_7 = simulationFunctionsFile(Tpl.emptyTxt, i_simCode, i_modelInfo_functions, i_literals);
        Tpl.textFile(txt_7, "Functions.cpp");
        txt_8 = simulationMakefile(Tpl.emptyTxt, Tpl.textString(l_target), i_simCode);
        txt_9 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_9 = Tpl.writeTok(txt_9, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_8, Tpl.textString(txt_9));
        ret_10 = listAppend(i_allEquations, i_initialEquations);
        txt = algloopfiles(txt, ret_10, i_simCode);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end translateModel;

public function translateFunctions
  input Tpl.Text in_txt;
  input SimCode.FunctionCode in_a_functionCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_functionCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.FUNCTIONCODE(name = _) )
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end translateFunctions;

public function simulationHeaderFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateHeaderInlcudeString(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = generateClassDeclarationCode(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationHeaderFile;

public function algloopHeaderFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)),
           a_eq )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateAlgloopHeaderInlcudeString(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = generateAlgloopClassDeclarationCode(txt, i_simCode, a_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end algloopHeaderFile;

protected function lm_35
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = literalExpConstImpl(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_35(txt, rest);
      then txt;
  end match;
end lm_35;

protected function fun_36
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Function> in_a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_functions)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_functions;
      SimCode.SimCode i_simCode;
      list<DAE.Exp> i_literals;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), literals = i_literals)),
           a_functions )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include \"Modelica.h\"\n",
                                    "#include \"Functions.h\"\n",
                                    "\n",
                                    " Functions::Functions()\n",
                                    " {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_35(txt, i_literals);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n",
                                    " Functions::~Functions()\n",
                                    " {\n",
                                    " }\n",
                                    "  void Functions::Assert(bool cond,string msg)\n",
                                    "  {\n",
                                    "      if(!cond)\n",
                                    "          throw std::runtime_error(msg);\n",
                                    "  }\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = functionBodies(txt, a_functions, i_simCode);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_36;

public function simulationFunctionsFile
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_36(txt, a_simCode, a_functions);
end simulationFunctionsFile;

protected function lm_38
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = literalExpConst(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_38(txt, rest);
      then txt;
  end match;
end lm_38;

protected function fun_39
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Function> in_a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_functions)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_functions;
      list<DAE.Exp> i_literals;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), literals = i_literals)),
           a_functions )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma once\n",
                                    "#include \"Math/ArrayOperations.h\"\n",
                                    "#include \"Math/Functions.h\"\n",
                                    "#include \"Math/Utility.h\"\n",
                                    "#include \"LibrariesConfig.h\"\n",
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Simulation code for FunctionCall functions generated by the OpenModelica Compiler.\n",
                                    "*\n",
                                    "*****************************************************************************/\n",
                                    "//external c functions\n",
                                    "extern \"C\" {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = externfunctionHeaderDefinition(txt, a_functions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = functionHeaderBodies1(txt, a_functions, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "class Functions\n",
                                    "   {\n",
                                    "    public:\n",
                                    "      Functions();\n",
                                    "     ~Functions();\n",
                                    "     //Modelica functions\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = functionHeaderBodies2(txt, a_functions, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void Assert(bool cond,string msg);\n",
                                    "\n",
                                    "//Literals\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_38(txt, i_literals);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "   private:\n",
                                    "     //Function return variables\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = functionHeaderBodies3(txt, a_functions, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("   };"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_39;

public function simulationFunctionsHeaderFile
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_39(txt, a_simCode, a_functions);
end simulationFunctionsHeaderFile;

protected function fun_41
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_41;

protected function lm_42
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_42(txt, rest);
      then txt;
  end match;
end lm_42;

protected function fun_43
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_43;

protected function fun_44
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_44;

protected function fun_45
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lOMOCLRuntime -lOpenCL"));
      then txt;
  end match;
end fun_45;

protected function fun_46
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end match;
end fun_46;

protected function fun_47
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER "));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK "));
      then txt;

    case ( txt,
           "dassljac" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_JACOBIAN "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_47;

protected function fun_48
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_46(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_47(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_48;

protected function fun_49
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end match;
end fun_49;

protected function fun_50
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_initialEquations;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_allEquations;
      Absyn.Path i_modelInfo_name;
      String i_fileNamePrefix;
      String i_makefileParams_omhome;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      list<SimCode.SimEqSystem> ret_8;
      Boolean ret_7;
      Tpl.Text l_extraCflags;
      Boolean ret_5;
      Tpl.Text l_ParModelicaLibs;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory, name = i_modelInfo_name), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, omhome = i_makefileParams_omhome), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix, allEquations = i_allEquations, initialEquations = i_initialEquations)) )
      equation
        l_dirExtra = fun_41(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_42(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_43(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_44(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        ret_5 = Config.acceptParModelicaGrammar();
        l_ParModelicaLibs = fun_45(Tpl.emptyTxt, ret_5);
        l_extraCflags = fun_48(Tpl.emptyTxt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O3 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=\n",
                                    "MODELICAUSERCFLAGS=\n",
                                    "CXX=cl\n",
                                    "EXEEXT=.exe\n",
                                    "DLLEXT=.dll\n",
                                    "include "
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/include/omc/cpp/ModelicaConfic.inc\n",
                                    "# /Od - Optimization disabled\n",
                                    "# /EHa enable C++ EH (w/ SEH exceptions)\n",
                                    "# /fp:except - consider floating-point exceptions when generating code\n",
                                    "# /arch:SSE2 - enable use of instructions available with SSE2 enabled CPUs\n",
                                    "# /I - Include Directories\n",
                                    "# /DNOMINMAX - Define NOMINMAX (does what it says)\n",
                                    "# /TP - Use C++ Compiler\n",
                                    "CFLAGS=  /ZI /Od /EHa /MP /fp:except /I\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp/Core/\" /I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/include/omc/cpp/\" -I\"$(BOOST_INCLUDE)\" /I. /DNOMINMAX /TP /DNO_INTERACTIVE_DEPENDENCY\n",
                                    "\n",
                                    "# /ZI enable Edit and Continue debug info\n",
                                    "CDFLAGS = /ZI\n",
                                    "\n",
                                    "# /MD - link with MSVCRT.LIB\n",
                                    "# /link - [linker options and libraries]\n",
                                    "# /LIBPATH: - Directories where libs can be found\n",
                                    "#LDFLAGS=/MDd   /link /DLL /NOENTRY /LIBPATH:\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp/msvc\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/bin\" /LIBPATH:\"$(BOOST_LIBS)\" OMCppSystem.lib OMCppMath.lib OMCppModelicaExternalC.lib\n",
                                    "LDFLAGS=/MD /Debug  /link /DLL /NOENTRY /LIBPATH:\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp/msvc\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/bin\" /LIBPATH:\"$(BOOST_LIBS)\" OMCppSystem.lib OMCppMath.lib OMCppModelicaExternalC.lib\n",
                                    "# /MDd link with MSVCRTD.LIB debug lib\n",
                                    "# lib names should not be appended with a d just switch to lib/omc/cpp\n",
                                    "\n",
                                    "\n",
                                    "FILEPREFIX="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "FUNCTIONFILE=Functions.cpp\n",
                                    "MAINFILE="
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        ret_7 = Config.acceptMetaModelicaGrammar();
        txt = fun_49(txt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".cpp\n",
                                    "MAINOBJ=$(MODELICA_SYSTEM_LIB)\n",
                                    "GENERATEDFILES=$(MAINFILE) $(FUNCTIONFILE)  "
                                }, false));
        txt = algloopcppfilenames(txt, i_allEquations, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "$(MODELICA_SYSTEM_LIB)$(DLLEXT):\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX) /Fe$(MODELICA_SYSTEM_LIB) $(MAINFILE) $(FUNCTIONFILE)  "));
        ret_8 = listAppend(i_allEquations, i_initialEquations);
        txt = algloopcppfilenames(txt, ret_8, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CFLAGS) $(LDFLAGS)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_50;

protected function fun_51
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end match;
end fun_51;

protected function fun_52
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER"));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_52;

protected function fun_53
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_51(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_52(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_53;

protected function lm_54
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_54(txt, rest);
      then txt;
  end match;
end lm_54;

protected function fun_55
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_cflags;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(cflags = i_s_cflags)) )
      equation
        txt = Tpl.writeStr(txt, i_s_cflags);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_55;

protected function fun_56
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end match;
end fun_56;

protected function fun_57
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      Absyn.Path i_modelInfo_name;
      String i_makefileParams_cflags;
      list<String> i_makefileParams_includes;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      String i_makefileParams_omhome;
      Option<SimCode.SimulationSettings> i_sopt;
      list<SimCode.SimEqSystem> ret_2;
      Boolean ret_1;
      Tpl.Text l_extraCflags;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), makefileParams = SimCode.MAKEFILE_PARAMS(omhome = i_makefileParams_omhome, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, includes = i_makefileParams_includes, cflags = i_makefileParams_cflags), simulationSettingsOpt = i_sopt, allEquations = i_allEquations, initialEquations = i_initialEquations)) )
      equation
        l_extraCflags = fun_53(Tpl.emptyTxt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "include "
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/include/omc/cpp/ModelicaConfic.inc\n",
                                    "# Simulations use -O0 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=-O0\n",
                                    "CC="
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS_BASED_ON_INIT_FILE="));
        txt = Tpl.writeText(txt, l_extraCflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS=$(CFLAGS_BASED_ON_INIT_FILE) -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp/Core\" -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp/\"  -I\"$(BOOST_INCLUDE)\" "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_54(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_55(txt, i_sopt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS=-L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/lib/omc/cpp\"    -L\"$(BOOST_LIBS)\"\n",
                                    "\n",
                                    "MAINFILE="
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        ret_1 = Config.acceptMetaModelicaGrammar();
        txt = fun_56(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".cpp\n",
                                    "FUNCTIONFILE=Functions.cpp\n",
                                    "\n",
                                    ".PHONY: "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.softNewLine(txt);
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(": $(MAINFILE)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX) -shared -I. -o $(MODELICA_SYSTEM_LIB) $(MAINFILE) $(FUNCTIONFILE)  "));
        ret_2 = listAppend(i_allEquations, i_initialEquations);
        txt = algloopcppfilenames(txt, ret_2, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "     $(CFLAGS)  $(LDFLAGS) -lOMCppSystem -lOMCppMath -lOMCppModelicaExternalC -Wl,-Bstatic  -Wl,-Bdynamic\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_57;

public function simulationMakefile
  input Tpl.Text in_txt;
  input String in_a_target;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_target, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;

    case ( txt,
           "msvc",
           a_simCode )
      equation
        txt = fun_50(txt, a_simCode);
      then txt;

    case ( txt,
           "gcc",
           a_simCode )
      equation
        txt = fun_57(txt, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end simulationMakefile;

protected function fun_59
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.SimEqSystem> in_a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_allEquations)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquations;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_allEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimResidues="));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_59;

public function simulationCppFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      list<String> i_modelInfo_labels;
      list<SimCode.SimWhenClause> i_whenClauses;
      BackendDAE.SampleLookup i_sampleLookup;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<DAE.ComponentRef> i_discreteModelVars;
      SimCode.ModelInfo i_modelInfo;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      list<SimCode.SimEqSystem> ret_2;
      list<SimCode.SimEqSystem> ret_1;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name, labels = i_modelInfo_labels)), allEquations = i_allEquations, discreteModelVars = i_discreteModelVars, zeroCrossings = i_zeroCrossings, initialEquations = i_initialEquations, sampleLookup = i_sampleLookup, whenClauses = i_whenClauses, jacobianMatrixes = i_jacobianMatrixes)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" #include \"Modelica.h\"\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".h\"\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "using boost::extensions::factory;\n",
                                    " BOOST_EXTENSION_TYPE_MAP_FUNCTION {\n",
                                    "  types.get<std::map<std::string, factory<IMixedSystem,IGlobalSettings*,boost::shared_ptr<IAlgLoopSolverFactory>,boost::shared_ptr<ISimData> > > >()\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[\"ModelicaSystem\"].set<"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">();\n",
                                    "}\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(IGlobalSettings* globalSettings,boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory,boost::shared_ptr<ISimData> simData)\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " :SystemDefaultImplementation(*globalSettings)\n",
                                    "  ,_algLoopSolverFactory(nonlinsolverfactory)\n",
                                    "  ,_simData(simData)\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = simulationInitFile(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "//Number of equations\n"
                                }, true));
        txt = dimension1(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimZeroFunc= "));
        txt = zerocrosslength(txt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "_dimTimeEvent = "
                                }, false));
        txt = timeeventlength(txt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "//Number of residues\n"
                                }, true));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_59(txt, ret_0, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//DAE\'s are not supported yet, Index reduction is enabled\n",
                                    "_dimAE = 0; // algebraic equations\n",
                                    "//Initialize the state vector\n",
                                    "SystemDefaultImplementation::initialize();\n",
                                    "//Instantiate auxiliary object for event handling functionality\n",
                                    "_event_handling.getCondition =  boost::bind(&"
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getCondition, this, _1);\n",
                                    "_historyImpl = new HistoryImplType(*globalSettings);\n"
                                }, true));
        txt = arrayReindex(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//Initialize array elements\n"));
        txt = initializeArrayElements(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n",
                                    "}\n"
                                }, true));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::~"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "()\n",
                                    "{\n",
                                    "delete _historyImpl;\n",
                                    "}\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = init(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Update(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = writeoutput(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = DefaultImplementationCode(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = checkForDiscreteEvents(txt, i_discreteModelVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = giveZeroFunc1(txt, i_zeroCrossings, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = setConditions(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = geConditions(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        ret_1 = listAppend(i_allEquations, i_initialEquations);
        txt = generateStepCompleted(txt, ret_1, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = generatehandleTimeEvent(txt, i_sampleLookup, i_simCode);
        txt = Tpl.softNewLine(txt);
        ret_2 = listAppend(i_allEquations, i_initialEquations);
        txt = generateDimTimeEvent(txt, ret_2, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = generateTimeEvent(txt, i_sampleLookup, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = isODE(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = DimZeroFunc(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = GetIntialStatus(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = SetIntialStatus(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = getCondition(txt, i_zeroCrossings, i_whenClauses, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = handleSystemEvents(txt, i_zeroCrossings, i_whenClauses, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = saveall(txt, i_modelInfo, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = savediscreteVars(txt, i_modelInfo, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = LabeledDAE(txt, i_modelInfo_labels, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = functionAnalyticJacobians(txt, i_jacobianMatrixes, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = giveVariables(txt, i_modelInfo);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationCppFile;

protected function fun_61
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"Math/ArrayOperations.h\""));
      then txt;
  end match;
end fun_61;

protected function fun_62
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode a_simCode;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq,
           a_simCode )
      equation
        txt = algloopResiduals(txt, a_simCode, a_eq);
      then txt;
  end match;
end fun_62;

protected function fun_63
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"Math/ArrayOperations.h\""));
      then txt;
  end match;
end fun_63;

protected function fun_64
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode a_simCode;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq,
           a_simCode )
      equation
        txt = algloopResiduals(txt, a_simCode, a_eq);
      then txt;
  end match;
end fun_64;

protected function fun_65
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Absyn.Path in_a_modelInfo_name;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_simCode, in_a_varDecls, in_a_modelInfo_name, in_a_modelname)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Absyn.Path a_modelInfo_name;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_simCode,
           a_varDecls,
           a_modelInfo_name,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" #include \"Modelica.h\"\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".h\"\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = lastIdentOfPath(txt, a_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".h\"\n"));
        txt = Tpl.popBlock(txt);
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_61(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::"));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("* system, double* z,double* zDot,bool* conditions, EventHandling& event_handling )\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":AlgLoopDefaultImplementation()\n",
                                    ",_system(system)\n",
                                    ",__z(z)\n",
                                    ",__zDot(zDot)\n",
                                    ",_conditions(conditions)\n",
                                    ",_event_handling(event_handling)\n"
                                }, true));
        txt = alocateLinearSystem(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    " {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        (txt, a_varDecls) = initAlgloopDimension(txt, i_eq, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::~"));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "()\n",
                                    " {\n",
                                    "\n",
                                    " }\n"
                                }, true));
        txt = algloopRHSCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        ret_1 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_62(txt, ret_1, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initAlgloop(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = upateAlgloopNonLinear(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = upateAlgloopLinear(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = AlgloopDefaultImplementationCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = getAMatrixCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = isLinearCode(txt, a_simCode, i_eq);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(index = i_index)),
           a_simCode,
           a_varDecls,
           a_modelInfo_name,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" #include \"Modelica.h\"\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".h\"\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = lastIdentOfPath(txt, a_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".h\"\n"));
        txt = Tpl.popBlock(txt);
        ret_2 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_63(txt, ret_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::"));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("* system, double* z,double* zDot,bool* conditions, EventHandling& event_handling )\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":AlgLoopDefaultImplementation()\n",
                                    ",_system(system)\n",
                                    ",__z(z)\n",
                                    ",__zDot(zDot)\n",
                                    ",_conditions(conditions)\n",
                                    ",_event_handling(event_handling)\n"
                                }, true));
        txt = alocateLinearSystem(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    " {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        (txt, a_varDecls) = initAlgloopDimension(txt, i_eq, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::~"));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "()\n",
                                    " {\n",
                                    "\n",
                                    " }\n"
                                }, true));
        txt = algloopRHSCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        ret_3 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_64(txt, ret_3, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initAlgloop(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = upateAlgloopNonLinear(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = upateAlgloopLinear(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = AlgloopDefaultImplementationCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = getAMatrixCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = isLinearCode(txt, a_simCode, i_eq);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);
  end match;
end fun_65;

public function algloopCppFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_iniAlgloopParamas;
      Tpl.Text l_constructorParams;
      Tpl.Text l_arrayInit;
      Tpl.Text l_varDecls;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_varDecls = Tpl.emptyTxt;
        l_arrayInit = Tpl.emptyTxt;
        l_constructorParams = ConstructorParamAlgloop(Tpl.emptyTxt, i_modelInfo);
        (l_iniAlgloopParamas, l_arrayInit) = InitAlgloopParams(Tpl.emptyTxt, i_modelInfo, l_arrayInit);
        (txt, l_varDecls) = fun_65(txt, a_eq, i_simCode, l_varDecls, i_modelInfo_name, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end algloopCppFile;

protected function lm_67
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_eq2 as SimCode.SES_ALGORITHM(index = _)) :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq2, SimCode.contextAlgloop, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_67(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_67(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_67;

protected function lm_68
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_eq2 as SimCode.SES_SIMPLE_ASSIGN(index = _)) :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq2, SimCode.contextAlgloop, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_68(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_68(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_68;

protected function lm_69
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_eq2_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_eq2_exp) :: rest,
           a_simCode,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq2_exp, SimCode.contextAlgloop, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__xd["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_69(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_69(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_69;

protected function fun_70
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input Tpl.Text in_a_modelname;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_modelname, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      SimCode.SimCode a_simCode;
      Integer i_index;
      list<SimCode.SimEqSystem> i_eq_eqs;
      Tpl.Text l_body;
      Tpl.Text l_prebody;
      Tpl.Text l_algs;
      Tpl.Text l_varDecls;

    case ( txt,
           SimCode.SES_NONLINEAR(eqs = i_eq_eqs, index = i_index),
           a_modelname,
           a_simCode )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_algs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_algs, l_varDecls) = lm_67(l_algs, i_eq_eqs, a_simCode, l_varDecls);
        l_algs = Tpl.popIter(l_algs);
        l_prebody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_prebody, l_varDecls) = lm_68(l_prebody, i_eq_eqs, a_simCode, l_varDecls);
        l_prebody = Tpl.popIter(l_prebody);
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, l_varDecls) = lm_69(l_body, i_eq_eqs, a_simCode, l_varDecls);
        l_body = Tpl.popIter(l_body);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluate(const IContinuous::UPDATETYPE command)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, l_algs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_prebody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_70;

public function upateAlgloopNonLinear
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eqn)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eqn;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eqn )
      equation
        System.tmpTickReset(0);
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_70(txt, a_eqn, l_modelname, i_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end upateAlgloopNonLinear;

protected function lm_72
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer i_col;
      Integer i_row;
      DAE.Exp i_eq_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_row, i_col, SimCode.SES_RESIDUAL(exp = i_eq_exp)) :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq_exp, SimCode.contextAlgloop, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__A["));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]["));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_72(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_72(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_72;

protected function lm_73
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer x_i0;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextAlgloop, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__b["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_73(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_73;

protected function fun_74
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input Tpl.Text in_a_modelname;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_modelname, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      SimCode.SimCode a_simCode;
      Integer i_index;
      list<DAE.Exp> i_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<SimCode.SimVar> i_vars;
      Tpl.Text l_bvector;
      Tpl.Text l_Amatrix;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;
      Tpl.Text l_bname;
      Tpl.Text l_aname;
      Integer ret_3;
      Tpl.Text l_size;
      Integer ret_1;
      Tpl.Text l_uid;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, simJac = i_simJac, beqs = i_beqs, index = i_index),
           a_modelname,
           a_simCode )
      equation
        ret_1 = System.tmpTick();
        l_uid = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        ret_3 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        l_aname = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("A"));
        l_aname = Tpl.writeText(l_aname, l_uid);
        l_bname = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("b"));
        l_bname = Tpl.writeText(l_bname, l_uid);
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        l_Amatrix = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_Amatrix, l_varDecls, l_preExp) = lm_72(l_Amatrix, i_simJac, a_simCode, l_varDecls, l_preExp);
        l_Amatrix = Tpl.popIter(l_Amatrix);
        l_bvector = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bvector, l_varDecls, l_preExp) = lm_73(l_bvector, i_beqs, a_simCode, l_varDecls, l_preExp);
        l_bvector = Tpl.popIter(l_bvector);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("::evaluate(const IContinuous::UPDATETYPE command)\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_Amatrix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_bvector);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_74;

public function upateAlgloopLinear
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eqn)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eqn;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eqn )
      equation
        System.tmpTickReset(0);
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_74(txt, a_eqn, l_modelname, i_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end upateAlgloopLinear;

protected function fun_76
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           SimCode.SIMVAR(name = (i_cr as DAE.CREF_QUAL(ident = "$DER"))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inline_integrate("));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_76;

protected function lm_77
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_76(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_77(txt, rest);
      then txt;
  end match;
end lm_77;

protected function fun_78
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_simvars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simvars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_simvars;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_simvars )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_77(txt, i_simvars);
        txt = Tpl.popIter(txt);
      then txt;
  end match;
end fun_78;

public function inlineVars
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input list<SimCode.SimVar> in_a_simvars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_simvars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> a_simvars;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_simvars )
      equation
        txt = fun_78(txt, a_simvars);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end inlineVars;

protected function lm_80
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_simCode )
      equation
        txt = functionBody(txt, i_fn, false, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_80(txt, rest, a_simCode);
      then txt;
  end match;
end lm_80;

public function functionBodies
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_80(out_txt, a_functions, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end functionBodies;

protected function fun_82
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode, in_a_inFunc)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_inFunc;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode,
           a_inFunc )
      equation
        txt = functionBodyRegularFunction(txt, i_fn, a_inFunc, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode,
           a_inFunc )
      equation
        txt = functionBodyExternalFunction(txt, i_fn, a_inFunc, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           _,
           _ )
      equation
        txt = functionBodyRecordConstructor(txt, i_fn);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_82;

protected function fun_83
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_inFunc;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_inFunc, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_inFunc;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_inFunc,
           a_fn )
      equation
        txt = fun_82(txt, a_fn, a_simCode, a_inFunc);
      then txt;
  end match;
end fun_83;

protected function fun_84
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode, in_a_inFunc)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_inFunc;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode,
           a_inFunc )
      equation
        txt = functionBodyRegularFunction(txt, i_fn, a_inFunc, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode,
           a_inFunc )
      equation
        txt = functionBodyExternalFunction(txt, i_fn, a_inFunc, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           _,
           _ )
      equation
        txt = functionBodyRecordConstructor(txt, i_fn);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_84;

protected function fun_85
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_inFunc;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_inFunc, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_inFunc;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_inFunc,
           a_fn )
      equation
        txt = fun_84(txt, a_fn, a_simCode, a_inFunc);
      then txt;
  end match;
end fun_85;

protected function fun_86
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode, in_a_inFunc)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_inFunc;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode,
           a_inFunc )
      equation
        txt = functionBodyRegularFunction(txt, i_fn, a_inFunc, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode,
           a_inFunc )
      equation
        txt = functionBodyExternalFunction(txt, i_fn, a_inFunc, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           _,
           _ )
      equation
        txt = functionBodyRecordConstructor(txt, i_fn);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_86;

protected function fun_87
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_inFunc;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_inFunc, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_inFunc;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_inFunc,
           a_fn )
      equation
        txt = fun_86(txt, a_fn, a_simCode, a_inFunc);
      then txt;
  end match;
end fun_87;

public function functionBody
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;
      Absyn.Path i_name;
      String str_3;
      String str_2;
      String str_1;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name)),
           a_inFunc,
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        str_1 = Tpl.textString(l_fname);
        txt = fun_83(txt, str_1, a_simCode, a_inFunc, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name)),
           a_inFunc,
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        str_2 = Tpl.textString(l_fname);
        txt = fun_85(txt, str_2, a_simCode, a_inFunc, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = i_name)),
           a_inFunc,
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        str_3 = Tpl.textString(l_fname);
        txt = fun_87(txt, str_3, a_simCode, a_inFunc, i_fn);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end functionBody;

protected function lm_89
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = extFunDef(txt, i_fn);
        txt = Tpl.nextIter(txt);
        txt = lm_89(txt, rest);
      then txt;
  end match;
end lm_89;

public function externfunctionHeaderDefinition
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_89(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end externfunctionHeaderDefinition;

protected function lm_91
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.SimCode a_simCode;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_rd :: rest,
           a_simCode )
      equation
        txt = recordDeclarationHeader(txt, i_rd, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_91(txt, rest, a_simCode);
      then txt;
  end match;
end lm_91;

protected function lm_92
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_simCode )
      equation
        txt = functionHeaderBody1(txt, i_fn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_92(txt, rest, a_simCode);
      then txt;
  end match;
end lm_92;

protected function fun_93
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Function> in_a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_functions)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_functions;
      SimCode.SimCode i_simCode;
      list<SimCode.RecordDeclaration> i_recordDecls;
      Tpl.Text l_rettypedecls;
      Tpl.Text l_recorddecls;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), recordDecls = i_recordDecls)),
           a_functions )
      equation
        l_recorddecls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_recorddecls = lm_91(l_recorddecls, i_recordDecls, i_simCode);
        l_recorddecls = Tpl.popIter(l_recorddecls);
        l_rettypedecls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_rettypedecls = lm_92(l_rettypedecls, a_functions, i_simCode);
        l_rettypedecls = Tpl.popIter(l_rettypedecls);
        txt = Tpl.writeText(txt, l_recorddecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_rettypedecls);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_93;

public function functionHeaderBodies1
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_93(txt, a_simCode, a_functions);
end functionHeaderBodies1;

protected function fun_95
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderExternFunction(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_95;

protected function fun_96
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_fn )
      equation
        txt = fun_95(txt, a_fn, a_simCode);
      then txt;
  end match;
end fun_96;

protected function fun_97
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderExternFunction(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_97;

protected function fun_98
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_fn )
      equation
        txt = fun_97(txt, a_fn, a_simCode);
      then txt;
  end match;
end fun_98;

protected function fun_99
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderExternFunction(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_99;

protected function fun_100
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_fn )
      equation
        txt = fun_99(txt, a_fn, a_simCode);
      then txt;
  end match;
end fun_100;

public function functionHeaderBody1
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;
      Absyn.Path i_name;
      String str_3;
      String str_2;
      String str_1;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name)),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        str_1 = Tpl.textString(l_fname);
        txt = fun_96(txt, str_1, a_simCode, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name)),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        str_2 = Tpl.textString(l_fname);
        txt = fun_98(txt, str_2, a_simCode, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = i_name)),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        str_3 = Tpl.textString(l_fname);
        txt = fun_100(txt, str_3, a_simCode, i_fn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionHeaderBody1;

protected function lm_102
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_simCode )
      equation
        txt = functionHeaderBody2(txt, i_fn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_102(txt, rest, a_simCode);
      then txt;
  end match;
end lm_102;

public function functionHeaderBodies2
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_102(out_txt, a_functions, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end functionHeaderBodies2;

protected function fun_104
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRecordConstruct(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_104;

protected function fun_105
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_fn )
      equation
        txt = fun_104(txt, a_fn, a_simCode);
      then txt;
  end match;
end fun_105;

protected function fun_106
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRecordConstruct(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_106;

protected function fun_107
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_fn )
      equation
        txt = fun_106(txt, a_fn, a_simCode);
      then txt;
  end match;
end fun_107;

protected function fun_108
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRecordConstruct(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_108;

protected function fun_109
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_fn )
      equation
        txt = fun_108(txt, a_fn, a_simCode);
      then txt;
  end match;
end fun_109;

public function functionHeaderBody2
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;
      Absyn.Path i_name;
      String str_3;
      String str_2;
      String str_1;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name)),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        str_1 = Tpl.textString(l_fname);
        txt = fun_105(txt, str_1, a_simCode, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name)),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        str_2 = Tpl.textString(l_fname);
        txt = fun_107(txt, str_2, a_simCode, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = i_name)),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        str_3 = Tpl.textString(l_fname);
        txt = fun_109(txt, str_3, a_simCode, i_fn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionHeaderBody2;

protected function lm_111
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_simCode )
      equation
        txt = functionHeaderBody3(txt, i_fn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_111(txt, rest, a_simCode);
      then txt;
  end match;
end lm_111;

public function functionHeaderBodies3
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_111(out_txt, a_functions, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end functionHeaderBodies3;

protected function fun_113
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = _),
           _ )
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_113;

protected function fun_114
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_fn )
      equation
        txt = fun_113(txt, a_fn, a_simCode);
      then txt;
  end match;
end fun_114;

protected function fun_115
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = _),
           _ )
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_115;

protected function fun_116
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_fn )
      equation
        txt = fun_115(txt, a_fn, a_simCode);
      then txt;
  end match;
end fun_116;

protected function fun_117
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = _),
           _ )
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_117;

protected function fun_118
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_fn )
      equation
        txt = fun_117(txt, a_fn, a_simCode);
      then txt;
  end match;
end fun_118;

public function functionHeaderBody3
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;
      Absyn.Path i_name;
      String str_3;
      String str_2;
      String str_1;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name)),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        str_1 = Tpl.textString(l_fname);
        txt = fun_114(txt, str_1, a_simCode, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name)),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        str_2 = Tpl.textString(l_fname);
        txt = fun_116(txt, str_2, a_simCode, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = i_name)),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        str_3 = Tpl.textString(l_fname);
        txt = fun_118(txt, str_3, a_simCode, i_fn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionHeaderBody3;

protected function fun_120
  input Tpl.Text in_txt;
  input String in_a_extName;
  input Tpl.Text in_a_fargsStr;
  input SimCode.SimExtArg in_a_return;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extName, in_a_fargsStr, in_a_return)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStr;
      SimCode.SimExtArg a_return;
      String i_extName;

    case ( txt,
           "OpenModelica_regex",
           _,
           _ )
      then txt;

    case ( txt,
           "ModelicaInternal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "ModelicaInternal_fullPathName",
           _,
           _ )
      then txt;

    case ( txt,
           i_extName,
           a_fargsStr,
           a_return )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extern "));
        txt = extReturnType(txt, a_return);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_extName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_120;

public function extFunDef
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_return;
      String i_extName;
      String i_language;
      list<SimCode.SimExtArg> i_extArgs;
      Tpl.Text l_fargsStr;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extReturn = i_return, extArgs = i_extArgs, language = i_language, extName = i_extName) )
      equation
        l_fargsStr = extFunDefArgs(Tpl.emptyTxt, i_extArgs, i_language);
        txt = fun_120(txt, i_extName, l_fargsStr, i_return);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end extFunDef;

protected function fun_122
  input Tpl.Text in_txt;
  input String in_a_language;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_language, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 657, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_122;

public function extFunctionName
  input Tpl.Text txt;
  input String a_name;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_122(txt, a_language, a_name);
end extFunctionName;

protected function lm_124
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunDefArg(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_124(txt, rest);
      then txt;
  end match;
end lm_124;

protected function fun_125
  input Tpl.Text in_txt;
  input String in_a_language;
  input list<SimCode.SimExtArg> in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_language, in_a_args)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> a_args;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_args )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_124(txt, a_args);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 664, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_125;

public function extFunDefArgs
  input Tpl.Text txt;
  input list<SimCode.SimExtArg> a_args;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_125(txt, a_language, a_args);
end extFunDefArgs;

public function extFunDefArg
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Type i_type__;
      Boolean i_ia;
      Boolean i_ii;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = i_ii, isArray = i_ia, type_ = i_t) )
      equation
        l_name = contextCref2(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        l_typeStr = extType2(Tpl.emptyTxt, i_t, i_ii, i_ia);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*"));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__) )
      equation
        l_typeStr = extType2(Tpl.emptyTxt, i_type__, true, false);
        txt = Tpl.writeText(txt, l_typeStr);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_t"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end extFunDefArg;

protected function fun_128
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isInput;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isInput)
    local
      Tpl.Text txt;
      Boolean a_isInput;
      DAE.Type i_type;
      Absyn.Path i_rname;
      DAE.Type i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char*"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty),
           a_isInput )
      equation
        txt = extType2(txt, i_ty, a_isInput, true);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void *"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = underscorePath(txt, i_rname);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           i_type,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external C type "));
        ret_0 = Types.unparseType(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 706, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_128;

protected function fun_129
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "const char*" )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const "));
      then txt;
  end match;
end fun_129;

protected function fun_130
  input Tpl.Text in_txt;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;
      String str_0;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        str_0 = Tpl.textString(a_s);
        txt = fun_129(txt, str_0);
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end match;
end fun_130;

protected function fun_131
  input Tpl.Text in_txt;
  input Boolean in_a_isInput;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isInput, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Tpl.Text a_s;

    case ( txt,
           false,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_s )
      equation
        txt = fun_130(txt, a_isArray, a_s);
      then txt;
  end match;
end fun_131;

protected function fun_132
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isArray;
  input Boolean in_a_isInput;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isArray, in_a_isInput, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Boolean a_isInput;
      Tpl.Text a_s;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           _,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_isInput,
           a_s )
      equation
        txt = fun_131(txt, a_isInput, a_isArray, a_s);
      then txt;
  end match;
end fun_132;

public function extType2
  input Tpl.Text txt;
  input DAE.Type a_type;
  input Boolean a_isInput;
  input Boolean a_isArray;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_128(Tpl.emptyTxt, a_type, a_isInput);
  out_txt := fun_132(txt, a_type, a_isArray, a_isInput, l_s);
end extType2;

public function extReturnType
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.Type i_type__;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           SimCode.SIMEXTARG(type_ = i_type__) )
      equation
        txt = extType2(txt, i_type__, true, false);
      then txt;

    case ( txt,
           SimCode.SIMNOEXTARG() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp) )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Expression types are unsupported as return arguments "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 716, 36), Tpl.textString(txt_0));
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 717, 14), "Unsupported return argument");
      then txt;
  end match;
end extReturnType;

protected function lm_135
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funReturnDefinition1(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_135(txt, rest, a_simCode);
      then txt;
  end match;
end lm_135;

protected function lm_136
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funReturnDefinition2(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_136(txt, rest, a_simCode);
      then txt;
  end match;
end lm_136;

public function functionHeaderRegularFunction1
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_vars;
      SimCode.Variable i_var;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(outVars = {i_var}, name = i_name),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /*default return type*/\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef "));
        txt = funReturnDefinition1(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "RetType;\n",
                                    "typedef "
                                }, false));
        txt = funReturnDefinition2(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RefRetType;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.FUNCTION(outVars = (i_vars as _ :: _), name = i_name),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /*tuple return type*/\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef boost::tuple< "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_135(txt, i_vars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >  "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "RetType;\n",
                                    "typedef boost::tuple< "
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_136(txt, i_vars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RefRetType;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name),
           _ )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "typedef "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionHeaderRegularFunction1;

protected function lm_138
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) :: rest )
      equation
        txt = varType2(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_138(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_138(txt, rest);
      then txt;
  end match;
end lm_138;

protected function fun_139
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_funArgs;
      Absyn.Path i_name;
      Tpl.Text l_funArgsStr;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs) )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_funArgsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_funArgsStr = lm_138(l_funArgsStr, i_funArgs);
        l_funArgsStr = Tpl.popIter(l_funArgsStr);
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_funArgsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_139;

public function functionHeaderRecordConstruct
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_139(txt, a_fn);
end functionHeaderRecordConstruct;

protected function lm_141
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funReturnDefinition1(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_141(txt, rest, a_simCode);
      then txt;
  end match;
end lm_141;

public function functionHeaderExternFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_outVars;
      SimCode.Variable i_var;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(outVars = {i_var}, name = i_name),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef  "));
        txt = funReturnDefinition1(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(outVars = (i_outVars as _ :: _), name = i_name),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef boost::tuple< "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_141(txt, i_outVars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >  "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionHeaderExternFunction;

protected function lm_143
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)) :: rest,
           a_simCode )
      equation
        txt = recordDeclarationHeaderArrayAllocate(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_143(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_143(txt, rest, a_simCode);
      then txt;
  end match;
end lm_143;

protected function lm_144
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_var_name;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name)) :: rest )
      equation
        txt = varType1(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_144(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_144(txt, rest);
      then txt;
  end match;
end lm_144;

public function recordDeclarationHeader
  input Tpl.Text in_txt;
  input SimCode.RecordDeclaration in_a_recDecl;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_recDecl, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_variables;
      String i_name;

    case ( txt,
           SimCode.RECORD_DECL_FULL(name = i_name, variables = i_variables),
           a_simCode )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Type\n",
                                    "{\n",
                                    "   //Constructor allocates arrays\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Type()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_143(txt, i_variables, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "//Public  Members\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_144(txt, i_variables);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;

    case ( txt,
           SimCode.RECORD_DECL_DEF(path = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RECORD DECL DEF"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end recordDeclarationHeader;

protected function lm_146
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = dimension(txt, i_exp);
        txt = Tpl.nextIter(txt);
        txt = lm_146(txt, rest);
      then txt;
  end match;
end lm_146;

protected function fun_147
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_v;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_v)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      DAE.Dimensions i_ty_dims;
      Tpl.Text l_arrayname;
      Tpl.Text l_instDimsInit;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_ARRAY(dims = i_ty_dims), name = i_name) )
      equation
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_instDimsInit = lm_146(l_instDimsInit, i_ty_dims);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        l_arrayname = crefStr(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_arrayname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".resize((boost::extents["));
        txt = Tpl.writeText(txt, l_instDimsInit);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("]));\n"));
        txt = Tpl.writeText(txt, l_arrayname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".reindex(1);"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_147;

public function recordDeclarationHeaderArrayAllocate
  input Tpl.Text txt;
  input SimCode.Variable a_v;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_147(txt, a_v);
end recordDeclarationHeaderArrayAllocate;

protected function lm_149
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) :: rest )
      equation
        txt = varType2(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_149(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_149(txt, rest);
      then txt;
  end match;
end lm_149;

protected function lm_150
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_structVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_structVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_structVar;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest,
           a_structVar )
      equation
        txt = Tpl.writeText(txt, a_structVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_150(txt, rest, a_structVar);
      then txt;

    case ( txt,
           _ :: rest,
           a_structVar )
      equation
        txt = lm_150(txt, rest, a_structVar);
      then txt;
  end match;
end lm_150;

public function functionBodyRecordConstructor
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_funArgs;
      Absyn.Path i_name;
      Tpl.Text l_structVar;
      Tpl.Text l_structType;
      Tpl.Text l_retVar;
      Tpl.Text l_retType;
      Tpl.Text l_fname;
      Tpl.Text l_varDecls;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs) )
      equation
        System.tmpTickReset(1);
        l_varDecls = Tpl.emptyTxt;
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = Tpl.writeText(Tpl.emptyTxt, l_fname);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("Type"));
        (l_retVar, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), l_varDecls);
        l_structType = Tpl.writeText(Tpl.emptyTxt, l_fname);
        l_structType = Tpl.writeTok(l_structType, Tpl.ST_STRING("Type"));
        (l_structVar, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_structType), l_varDecls);
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" Functions::"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_149(txt, i_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_150(txt, i_funArgs, l_structVar);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = Tpl.writeText(txt, l_structVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionBodyRecordConstructor;

protected function fun_152
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Integer in_a_exp_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_exp_index)
    local
      Tpl.Text txt;
      Integer a_exp_index;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_exp_index )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_OMC_LIT"));
        txt = Tpl.writeStr(txt, intString(a_exp_index));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           a_exp_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions._OMC_LIT"));
        txt = Tpl.writeStr(txt, intString(a_exp_index));
      then txt;
  end match;
end fun_152;

protected function fun_153
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp, in_a_context)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Integer i_exp_index;

    case ( txt,
           DAE.SHARED_LITERAL(index = i_exp_index),
           a_context )
      equation
        txt = fun_152(txt, a_context, i_exp_index);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_153;

public function daeExpSharedLiteral
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_153(txt, a_exp, a_context);
  out_a_preExp := a_preExp;
  out_a_varDecls := a_varDecls;
end daeExpSharedLiteral;

protected function lm_155
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_155(txt, rest, a_simCode);
      then txt;
  end match;
end lm_155;

protected function lm_156
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_156(txt, rest, a_simCode);
      then txt;
  end match;
end lm_156;

public function functionHeaderRegularFunction2
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_funArgs;
      list<SimCode.Variable> i_functionArguments;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(name = i_name, functionArguments = i_functionArguments),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_155(txt, i_functionArguments, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name, funArgs = i_funArgs),
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_156(txt, i_funArgs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionHeaderRegularFunction2;

protected function fun_158
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(name = i_name) )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name) )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_158;

public function functionHeaderRegularFunction3
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_158(txt, a_fn);
end functionHeaderRegularFunction3;

protected function fun_160
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType"));
      then txt;
  end match;
end fun_160;

protected function lm_161
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varInits, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           a_varInits,
           a_varDecls )
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_simCode,
           a_varInits,
           a_varDecls )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_varInits) = varInit(txt, i_var, "", x_i1, a_varDecls, a_varInits, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varInits, a_varDecls) = lm_161(txt, rest, a_simCode, a_varInits, a_varDecls);
      then (txt, a_varInits, a_varDecls);
  end match;
end lm_161;

protected function lm_162
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = funStatement(txt, i_stmt, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_162(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_162;

protected function lm_163
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      SimCode.Function a_fn;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign) = varOutput(txt, a_fn, i_var, x_i1, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_163(txt, rest, a_simCode, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_fn);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end match;
end lm_163;

protected function lm_164
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      SimCode.Function a_fn;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign) = varOutputTuple(txt, a_fn, i_var, x_i1, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_164(txt, rest, a_simCode, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_fn);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end match;
end lm_164;

protected function fun_165
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_a_outVars, in_a_simCode, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      SimCode.Function a_fn;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           (i_outVars as {_}),
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_163(txt, i_outVars, a_simCode, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_fn);
        txt = Tpl.popIter(txt);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_outVars,
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_164(txt, i_outVars, a_simCode, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_fn);
        txt = Tpl.popIter(txt);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end match;
end fun_165;

protected function lm_166
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_166(txt, rest, a_simCode);
      then txt;
  end match;
end lm_166;

protected function fun_167
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, a_fname);
      then txt;
  end match;
end fun_167;

protected function lm_168
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_168(txt, rest, a_simCode);
      then txt;
  end match;
end lm_168;

protected function fun_169
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" out;"));
      then txt;
  end match;
end fun_169;

protected function fun_170
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input Tpl.Text in_a_retType;
  input list<SimCode.Variable> in_a_outVars;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Variable> in_a_functionArguments;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inFunc, in_a_retType, in_a_outVars, in_a_simCode, in_a_functionArguments, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      list<SimCode.Variable> a_outVars;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> a_functionArguments;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_retType,
           a_outVars,
           a_simCode,
           a_functionArguments,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int in_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(type_description * inArgs, type_description * outVar)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_168(txt, a_functionArguments, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_169(txt, a_outVars, a_retType);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//MMC_TRY_TOP()\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_170;

public function functionBodyRegularFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_functionArguments;
      SimCode.Function i_fn;
      list<SimCode.Statement> i_body;
      list<SimCode.Variable> i_variableDeclarations;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_0___1;
      Tpl.Text l_outVarAssign;
      Tpl.Text l_outVarCopy;
      Tpl.Text l_outVarInits;
      Tpl.Text l_bodyPart;
      Tpl.Text l_0__;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, outVars = i_outVars, variableDeclarations = i_variableDeclarations, body = i_body, functionArguments = i_functionArguments)),
           a_inFunc,
           a_simCode )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_160(Tpl.emptyTxt, i_outVars, l_fname);
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_varInits, l_varDecls) = lm_161(l_0__, i_variableDeclarations, a_simCode, l_varInits, l_varDecls);
        l_0__ = Tpl.popIter(l_0__);
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bodyPart, l_varDecls) = lm_162(l_bodyPart, i_body, a_simCode, l_varDecls);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        l_outVarInits = Tpl.emptyTxt;
        l_outVarCopy = Tpl.emptyTxt;
        l_outVarAssign = Tpl.emptyTxt;
        (l_0___1, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls) = fun_165(Tpl.emptyTxt, i_outVars, a_simCode, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls, i_fn);
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" Functions::"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_166(txt, i_functionArguments, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_outVarInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_bodyPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_outVarAssign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = fun_167(txt, i_outVars, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = fun_170(txt, a_inFunc, l_retType, i_outVars, a_simCode, i_functionArguments, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end functionBodyRegularFunction;

protected function fun_172
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType"));
      then txt;
  end match;
end fun_172;

protected function fun_173
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, a_fname);
      then txt;
  end match;
end fun_173;

protected function lm_174
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_outVarInits, in_a_varDecls, in_a_retVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_retVar;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_simCode,
           a_outVarInits,
           a_varDecls,
           a_retVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits) = varInit(txt, i_var, Tpl.textString(a_retVar), x_i1, a_varDecls, a_outVarInits, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarInits, a_varDecls) = lm_174(txt, rest, a_simCode, a_outVarInits, a_varDecls, a_retVar);
      then (txt, a_outVarInits, a_varDecls);
  end match;
end lm_174;

protected function lm_175
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_175(txt, rest, a_simCode);
      then txt;
  end match;
end lm_175;

protected function fun_176
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ptrT_"));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ptr_"));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=NULL;"));
      then txt;
  end match;
end fun_176;

protected function lm_177
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) :: rest,
           a_simCode )
      equation
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_177(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_177(txt, rest, a_simCode);
      then txt;
  end match;
end lm_177;

protected function lm_178
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_arg;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_arg as SimCode.VARIABLE(name = _)) :: rest,
           a_simCode )
      equation
        txt = readInVar(txt, i_arg, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_178(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_178(txt, rest, a_simCode);
      then txt;
  end match;
end lm_178;

protected function lm_179
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest,
           a_simCode )
      equation
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_179(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_179(txt, rest, a_simCode);
      then txt;
  end match;
end lm_179;

protected function lm_180
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)) :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = writeOutVar(txt, i_var, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_180(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_180(txt, rest);
      then txt;
  end match;
end lm_180;

protected function fun_181
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Variable> in_a_funArgs;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inFunc, in_a_outVars, in_a_retType, in_a_simCode, in_a_funArgs, in_a_fname)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;
      Tpl.Text a_retType;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> a_funArgs;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_outVars,
           a_retType,
           a_simCode,
           a_funArgs,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int in_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(type_description * inArgs, type_description * outVar)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_177(txt, a_funArgs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" out;\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_178(txt, a_funArgs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MMC_TRY_TOP()\n",
                                    "out = _"
                                }, false));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_179(txt, a_funArgs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "MMC_CATCH_TOP(return 1)\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_180(txt, a_outVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_181;

public function functionBodyExternalFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.SimCode a_simCode;
      String i_language;
      String i_extName;
      Boolean i_dynamicLoad;
      list<SimCode.Variable> i_funArgs;
      SimCode.Function i_efn;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_fnBody;
      Tpl.Text l_0__;
      Tpl.Text l_callPart;
      Tpl.Text l_outVarInits;
      Tpl.Text l_retVar;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           (i_efn as SimCode.EXTERNAL_FUNCTION(name = i_name, outVars = i_outVars, funArgs = i_funArgs, dynamicLoad = i_dynamicLoad, extName = i_extName, language = i_language)),
           a_inFunc,
           a_simCode )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_172(Tpl.emptyTxt, i_outVars, l_fname);
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_retVar = fun_173(Tpl.emptyTxt, i_outVars, l_fname);
        l_outVarInits = Tpl.emptyTxt;
        (l_callPart, l_preExp, l_varDecls) = extFunCall(Tpl.emptyTxt, i_efn, l_preExp, l_varDecls, a_simCode);
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_outVarInits, l_varDecls) = lm_174(l_0__, i_outVars, a_simCode, l_outVarInits, l_varDecls, l_retVar);
        l_0__ = Tpl.popIter(l_0__);
        l_fnBody = Tpl.writeText(Tpl.emptyTxt, l_retType);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING(" Functions::"));
        l_fnBody = Tpl.writeText(l_fnBody, l_fname);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("("));
        l_fnBody = Tpl.pushIter(l_fnBody, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_fnBody = lm_175(l_fnBody, i_funArgs, a_simCode);
        l_fnBody = Tpl.popIter(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING_LIST({
                                              ")\n",
                                              "{\n",
                                              "  /* functionBodyExternalFunction: varDecls */\n"
                                          }, true));
        l_fnBody = Tpl.pushBlock(l_fnBody, Tpl.BT_INDENT(2));
        l_fnBody = Tpl.writeText(l_fnBody, l_varDecls);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: preExp */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_preExp);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: outputAlloc */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_outVarInits);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: callPart */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_callPart);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE(" /* functionBodyExternalFunction: return */\n"));
        l_fnBody = Tpl.pushBlock(l_fnBody, Tpl.BT_INDENT(1));
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("return "));
        l_fnBody = Tpl.writeText(l_fnBody, l_retVar);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE(";\n"));
        l_fnBody = Tpl.popBlock(l_fnBody);
        l_fnBody = Tpl.popBlock(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("}"));
        txt = fun_176(txt, i_dynamicLoad, i_language, i_extName);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_fnBody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_181(txt, a_inFunc, i_outVars, l_retType, a_simCode, i_funArgs, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end functionBodyExternalFunction;

public function writeOutVar
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;
      SimCode.Variable i_var;
      DAE.Type i_ty;

    case ( txt,
           SimCode.VARIABLE(ty = (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_modelica_record(outVar, "));
        txt = writeOutVarRecordMembers(txt, i_ty, a_index, "");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_"));
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(outVar, &out.targTest8"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end writeOutVar;

protected function fun_184
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Integer in_a_index;
  input DAE.Ident in_a_subvar_name;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty, in_a_index, in_a_subvar_name, in_a_prefix)
    local
      Tpl.Text txt;
      Integer a_index;
      DAE.Ident a_subvar_name;
      String a_prefix;
      DAE.Type i_ty;
      Tpl.Text l_newPrefix;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = _)),
           a_index,
           a_subvar_name,
           a_prefix )
      equation
        l_newPrefix = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_newPrefix = Tpl.writeTok(l_newPrefix, Tpl.ST_STRING("."));
        l_newPrefix = Tpl.writeStr(l_newPrefix, a_subvar_name);
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = writeOutVarRecordMembers(txt, i_ty, a_index, Tpl.textString(l_newPrefix));
      then txt;

    case ( txt,
           i_ty,
           a_index,
           a_subvar_name,
           a_prefix )
      equation
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &(out.targTest7"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeStr(txt, a_prefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_subvar_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_184;

protected function lm_185
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Integer in_a_index;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_index, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Integer a_index;
      String a_prefix;
      DAE.Ident i_subvar_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           DAE.TYPES_VAR(ty = i_ty, name = i_subvar_name) :: rest,
           a_index,
           a_prefix )
      equation
        txt = fun_184(txt, i_ty, a_index, i_subvar_name, a_prefix);
        txt = Tpl.nextIter(txt);
        txt = lm_185(txt, rest, a_index, a_prefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_index,
           a_prefix )
      equation
        txt = lm_185(txt, rest, a_index, a_prefix);
      then txt;
  end match;
end lm_185;

protected function fun_186
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_args)
    local
      Tpl.Text txt;
      Tpl.Text i_args;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_args )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_args);
      then txt;
  end match;
end fun_186;

public function writeOutVarRecordMembers
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Integer in_a_index;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_index, in_a_prefix)
    local
      Tpl.Text txt;
      Integer a_index;
      String a_prefix;
      list<DAE.Var> i_vl;
      ClassInf.State i_n;
      Tpl.Text l_args;
      Absyn.Path ret_1;
      Tpl.Text l_basename;

    case ( txt,
           DAE.T_COMPLEX(varLst = i_vl, complexClassType = i_n),
           a_index,
           a_prefix )
      equation
        ret_1 = ClassInf.getStateName(i_n);
        l_basename = underscorePath(Tpl.emptyTxt, ret_1);
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_args = lm_185(l_args, i_vl, a_index, a_prefix);
        l_args = Tpl.popIter(l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = Tpl.writeText(txt, l_basename);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc"));
        txt = fun_186(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", TYPE_DESC_NONE"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end writeOutVarRecordMembers;

public function expTypeRW
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_INT"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_REAL"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_STRING"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_BOOL"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_INT"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ARRAY"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_RECORD"));
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_MMC"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_MMC"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end expTypeRW;

protected function fun_189
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(char**)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_189;

public function readInVar
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_name;
      DAE.ComponentRef i_cr;
      DAE.Type i_ty;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.VARIABLE(name = i_cr, ty = (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_modelica_record(&inArgs, "));
        txt_0 = contextCref(Tpl.emptyTxt, i_cr, SimCode.contextFunction, a_simCode);
        txt = readInVarRecordMembers(txt, i_ty, Tpl.textString(txt_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name, ty = (i_ty as DAE.T_STRING(varLst = _))),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_"));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&inArgs, "));
        ret_1 = Config.acceptMetaModelicaGrammar();
        txt = fun_189(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" &"));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_"));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&inArgs, &"));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end readInVar;

protected function fun_191
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.Ident in_a_subvar_name;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty, in_a_subvar_name, in_a_prefix)
    local
      Tpl.Text txt;
      DAE.Ident a_subvar_name;
      String a_prefix;
      DAE.Type i_ty;
      Tpl.Text l_newPrefix;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = _)),
           a_subvar_name,
           a_prefix )
      equation
        l_newPrefix = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_newPrefix = Tpl.writeTok(l_newPrefix, Tpl.ST_STRING("."));
        l_newPrefix = Tpl.writeStr(l_newPrefix, a_subvar_name);
        txt = readInVarRecordMembers(txt, i_ty, Tpl.textString(l_newPrefix));
      then txt;

    case ( txt,
           _,
           a_subvar_name,
           a_prefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&("));
        txt = Tpl.writeStr(txt, a_prefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_subvar_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_191;

protected function lm_192
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      String a_prefix;
      DAE.Ident i_subvar_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           DAE.TYPES_VAR(ty = i_ty, name = i_subvar_name) :: rest,
           a_prefix )
      equation
        txt = fun_191(txt, i_ty, i_subvar_name, a_prefix);
        txt = Tpl.nextIter(txt);
        txt = lm_192(txt, rest, a_prefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_prefix )
      equation
        txt = lm_192(txt, rest, a_prefix);
      then txt;
  end match;
end lm_192;

public function readInVarRecordMembers
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_prefix)
    local
      Tpl.Text txt;
      String a_prefix;
      list<DAE.Var> i_vl;

    case ( txt,
           DAE.T_COMPLEX(varLst = i_vl),
           a_prefix )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_192(txt, i_vl, a_prefix);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end readInVarRecordMembers;

public function outDecl
  input Tpl.Text txt;
  input String a_ty;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_newVar;
algorithm
  l_newVar := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("out"));
  out_a_varDecls := Tpl.writeStr(a_varDecls, a_ty);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(" "));
  out_a_varDecls := Tpl.writeText(out_a_varDecls, l_newVar);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(";"));
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_newVar);
end outDecl;

protected function fun_195
  input Tpl.Text in_txt;
  input String in_a_language;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Function in_a_fun;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_language, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_fun)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Function a_fun;

    case ( txt,
           "C",
           a_simCode,
           a_varDecls,
           a_preExp,
           a_fun )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallC(txt, a_fun, a_preExp, a_varDecls, a_simCode);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_195;

public function extFunCall
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_fun, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fun;
      String i_language;

    case ( txt,
           (i_fun as SimCode.EXTERNAL_FUNCTION(language = i_language)),
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls, a_preExp) = fun_195(txt, i_language, a_simCode, a_varDecls, a_preExp, i_fun);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end match;
end extFunCall;

protected function lm_197
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_arg :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardecl(txt, i_arg, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_197(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_197;

protected function fun_198
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName, in_a_fname)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("==NULL) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MODELICA_TERMINATE(\"dynamic external function "));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" not set!\")\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} else"));
      then txt;
  end match;
end fun_198;

protected function lm_199
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extArg(txt, i_arg, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_199(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_199;

protected function fun_200
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c) )
      equation
        txt = extVarName2(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_200;

protected function fun_201
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_extReturn, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)),
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardecl(txt, i_extReturn, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_201;

protected function lm_202
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_fname)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_fname;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_arg :: rest,
           a_fname )
      equation
        txt = extFunCallVarcopy(txt, i_arg, Tpl.textString(a_fname));
        txt = Tpl.nextIter(txt);
        txt = lm_202(txt, rest, a_fname);
      then txt;
  end match;
end lm_202;

protected function fun_203
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extReturn, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)),
           a_fname )
      equation
        txt = extFunCallVarcopy(txt, i_extReturn, Tpl.textString(a_fname));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_203;

public function extFunCallC
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_fun, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimExtArg i_extReturn;
      String i_language;
      String i_extName;
      Boolean i_dynamicLoad;
      Absyn.Path i_name;
      list<SimCode.SimExtArg> i_extArgs;
      Tpl.Text l_returnAssign;
      Tpl.Text l_args;
      Tpl.Text l_dynamicCheck;
      Tpl.Text l_fname;
      list<SimCode.SimExtArg> ret_1;
      Tpl.Text l_varDecs;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, name = i_name, dynamicLoad = i_dynamicLoad, extName = i_extName, language = i_language, extReturn = i_extReturn),
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        ret_1 = List.union(i_extArgs, i_extArgs);
        l_varDecs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_varDecs, a_varDecls) = lm_197(l_varDecs, ret_1, a_varDecls);
        l_varDecs = Tpl.popIter(l_varDecs);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_dynamicCheck = fun_198(Tpl.emptyTxt, i_dynamicLoad, i_language, i_extName, l_fname);
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_args, a_varDecls, a_preExp) = lm_199(l_args, i_extArgs, a_simCode, a_varDecls, a_preExp);
        l_args = Tpl.popIter(l_args);
        l_returnAssign = fun_200(Tpl.emptyTxt, i_extReturn);
        txt = Tpl.writeText(txt, l_varDecs);
        txt = Tpl.softNewLine(txt);
        (txt, a_varDecls) = fun_201(txt, i_extReturn, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_dynamicCheck);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_returnAssign);
        txt = Tpl.writeStr(txt, i_extName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_202(txt, i_extArgs, l_fname);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_203(txt, i_extReturn, l_fname);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end match;
end extFunCallC;

protected function fun_205
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input String in_a_fnName;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_oi, in_a_fnName, in_a_c)
    local
      Tpl.Text txt;
      String a_fnName;
      DAE.ComponentRef a_c;
      Tpl.Text l_cr;

    case ( txt,
           0,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_fnName,
           a_c )
      equation
        l_cr = extVarName2(Tpl.emptyTxt, a_c);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fnName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_205;

public function extFunCallVarcopy
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input String in_a_fnName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arg, in_a_fnName)
    local
      Tpl.Text txt;
      String a_fnName;
      DAE.ComponentRef i_c;
      Integer i_oi;

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = _, cref = i_c),
           a_fnName )
      equation
        txt = fun_205(txt, i_oi, a_fnName, i_c);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end extFunCallVarcopy;

protected function fun_207
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input String in_a_fnName;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_oi, in_a_fnName, in_a_c)
    local
      Tpl.Text txt;
      String a_fnName;
      DAE.ComponentRef a_c;
      Integer i_oi;
      Tpl.Text l_assginEnd;
      Integer ret_2;
      Tpl.Text l_assginBegin;
      Tpl.Text l_cr;

    case ( txt,
           0,
           _,
           _ )
      then txt;

    case ( txt,
           i_oi,
           a_fnName,
           a_c )
      equation
        l_cr = extVarName2(Tpl.emptyTxt, a_c);
        l_assginBegin = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("get<"));
        ret_2 = intAdd(-1, i_oi);
        l_assginBegin = Tpl.writeStr(l_assginBegin, intString(ret_2));
        l_assginBegin = Tpl.writeTok(l_assginBegin, Tpl.ST_STRING(">("));
        l_assginEnd = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING(")"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_assginBegin);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fnName);
        txt = Tpl.writeText(txt, l_assginEnd);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_207;

public function extFunCallVarcopyTuple
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input String in_a_fnName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arg, in_a_fnName)
    local
      Tpl.Text txt;
      String a_fnName;
      DAE.ComponentRef i_c;
      Integer i_oi;

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = _, cref = i_c),
           a_fnName )
      equation
        txt = fun_207(txt, i_oi, a_fnName, i_c);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end extFunCallVarcopyTuple;

public function expTypeModelica
  input Tpl.Text txt;
  input DAE.Type a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFlag(txt, a_ty, 2);
end expTypeModelica;

protected function fun_210
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_oi, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer i_oi;

    case ( txt,
           0,
           a_c )
      equation
        txt = contextCref2(txt, a_c, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_oi,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out.targTest5"));
        txt = Tpl.writeStr(txt, intString(i_oi));
      then txt;
  end match;
end fun_210;

protected function fun_211
  input Tpl.Text in_txt;
  input DAE.Type in_a_t;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_t)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c_str()"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end match;
end fun_211;

protected function fun_212
  input Tpl.Text in_txt;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_t, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_cr;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MMC_STRINGDATA("));
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end match;
end fun_212;

protected function fun_213
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_t, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Type a_t;
      Tpl.Text a_cr;

    case ( txt,
           false,
           a_t,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
        txt = fun_211(txt, a_t);
      then txt;

    case ( txt,
           _,
           a_t,
           a_cr )
      equation
        txt = fun_212(txt, a_t, a_cr);
      then txt;
  end match;
end fun_213;

protected function fun_214
  input Tpl.Text in_txt;
  input Integer in_a_outputIndex;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outputIndex, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer i_outputIndex;

    case ( txt,
           0,
           a_c )
      equation
        txt = contextCref2(txt, a_c, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_outputIndex,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out.targTest4"));
        txt = Tpl.writeStr(txt, intString(i_outputIndex));
      then txt;
  end match;
end fun_214;

public function extArg
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_extArg, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Integer i_outputIndex;
      DAE.Type i_type__;
      DAE.Exp i_exp;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Integer i_oi;
      Tpl.Text l_dim;
      Tpl.Text l_typeStr;
      Boolean ret_3;
      Tpl.Text l_cr;
      Tpl.Text l_shortTypeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = i_oi, isArray = true, type_ = i_t),
           a_preExp,
           a_varDecls,
           _ )
      equation
        l_name = fun_210(Tpl.emptyTxt, i_oi, i_c);
        l_shortTypeStr = expTypeShort(Tpl.emptyTxt, i_t);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".data()"));
        txt = Tpl.popBlock(txt);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = 0, type_ = i_t),
           a_preExp,
           a_varDecls,
           _ )
      equation
        l_cr = contextCref2(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        ret_3 = Config.acceptMetaModelicaGrammar();
        txt = fun_213(txt, ret_3, i_t, l_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = _, type_ = _),
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = extVarName2(txt, i_c);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp),
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExternalCExp(txt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = i_c, type_ = i_type__, outputIndex = i_outputIndex, exp = i_exp),
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_typeStr = expTypeShort(Tpl.emptyTxt, i_type__);
        l_name = fun_214(Tpl.emptyTxt, i_outputIndex, i_c);
        (l_dim, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".shape()["));
        txt = Tpl.writeText(txt, l_dim);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -1]"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end match;
end extArg;

protected function fun_216
  input Tpl.Text in_txt;
  input DAE.Type in_mArg;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.Exp a_exp;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Type ret_1;
      Tpl.Text l_shortTypeStr;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           a_exp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        ret_1 = Expression.typeof(a_exp);
        l_shortTypeStr = expTypeShort(Tpl.emptyTxt, ret_1);
        (txt, a_preExp, a_varDecls) = daeExp(txt, a_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").data()"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_exp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, a_exp, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_216;

public function daeExternalCExp
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  DAE.Type ret_0;
algorithm
  ret_0 := Expression.typeof(a_exp);
  (out_txt, out_a_preExp, out_a_varDecls) := fun_216(txt, ret_0, a_exp, a_context, a_preExp, a_varDecls, a_simCode);
end daeExternalCExp;

protected function fun_218
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_ty, in_a_c, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Tpl.Text a_varDecls;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_ty,
           a_c,
           a_varDecls )
      equation
        a_varDecls = extType2(a_varDecls, i_ty, true, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName2(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = extVarName2(txt, a_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = extType2(txt, i_ty, true, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = contextCref2(txt, a_c, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);
  end match;
end fun_218;

protected function fun_219
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_oi, in_a_c, in_a_ty, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      DAE.Type a_ty;
      Tpl.Text a_varDecls;

    case ( txt,
           0,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_c,
           a_ty,
           a_varDecls )
      equation
        a_varDecls = extType2(a_varDecls, a_ty, true, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName2(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);
  end match;
end fun_219;

public function extFunCallVardecl
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_arg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Integer i_oi;
      DAE.ComponentRef i_c;
      DAE.Type i_ty;

    case ( txt,
           SimCode.SIMEXTARG(isInput = true, isArray = false, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_218(txt, i_ty, i_c, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_219(txt, i_oi, i_c, i_ty, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end extFunCallVardecl;

protected function fun_221
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varAssign, out_a_varCopy, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_fname, in_a_varAssign, in_a_simCode, in_a_var_name, in_a_varCopy, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varCopy;
      Tpl.Text a_varDecls;
      Tpl.Text l_strVar;

    case ( txt,
           false,
           a_fname,
           a_varAssign,
           a_simCode,
           a_var_name,
           a_varCopy,
           a_varDecls )
      equation
        (l_strVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_string_t", a_varDecls);
        a_varCopy = Tpl.writeText(a_varCopy, l_strVar);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(" = strdup("));
        a_varCopy = contextCref(a_varCopy, a_var_name, SimCode.contextFunction, a_simCode);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(");"));
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = init_modelica_string("));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING_LIST({
                                                    ");\n",
                                                    "free("
                                                }, false));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           _,
           a_fname,
           a_varAssign,
           a_simCode,
           a_var_name,
           a_varCopy,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("= "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varCopy, a_varDecls);
  end match;
end fun_221;

protected function lm_222
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_222(txt, rest, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_222;

protected function fun_223
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign) :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_varInits, in_a_simCode, in_a_var_name, in_a_fname, in_a_varAssign)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;

    case ( txt,
           {},
           _,
           a_varInits,
           a_simCode,
           a_var_name,
           a_fname,
           a_varAssign )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign);

    case ( txt,
           _,
           a_instDimsInit,
           a_varInits,
           a_simCode,
           a_var_name,
           a_fname,
           a_varAssign )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_"));
        a_varInits = Tpl.writeText(a_varInits, a_fname);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".resize((boost::extents["));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_LINE("]));\n"));
        a_varInits = Tpl.pushBlock(a_varInits, Tpl.BT_INDENT(4));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_"));
        a_varInits = Tpl.writeText(a_varInits, a_fname);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".reindex(1);"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.popBlock(a_varInits);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("="));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign);
  end match;
end fun_223;

protected function fun_224
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign, out_a_varCopy, out_a_varDecls) :=
  match(in_txt, in_a_var, in_a_varInits, in_a_fname, in_a_varAssign, in_a_simCode, in_a_varCopy, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varInits;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varCopy;
      Tpl.Text a_varDecls;
      String i_var_name_1;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_marker;
      Boolean ret_0;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_STRING(varLst = _), name = i_var_name),
           a_varInits,
           a_fname,
           a_varAssign,
           a_simCode,
           a_varCopy,
           a_varDecls )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        (txt, a_varAssign, a_varCopy, a_varDecls) = fun_221(txt, ret_0, a_fname, a_varAssign, a_simCode, i_var_name, a_varCopy, a_varDecls);
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims),
           a_varInits,
           a_fname,
           a_varAssign,
           a_simCode,
           a_varCopy,
           a_varDecls )
      equation
        l_marker = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction, a_simCode);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("/* varOutput varInits("));
        a_varInits = Tpl.writeText(a_varInits, l_marker);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(") */ "));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/* varOutput varAssign("));
        a_varAssign = Tpl.writeText(a_varAssign, l_marker);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(") */ "));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_222(l_instDimsInit, i_instDims, a_simCode, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varInits, a_varAssign) = fun_223(txt, i_instDims, l_instDimsInit, a_varInits, a_simCode, i_var_name, a_fname, a_varAssign);
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_var_name_1),
           a_varInits,
           a_fname,
           a_varAssign,
           _,
           a_varCopy,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = (modelica_fnptr) _"));
        a_varAssign = Tpl.writeStr(a_varAssign, i_var_name_1);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           _,
           a_varInits,
           _,
           a_varAssign,
           _,
           a_varCopy,
           a_varDecls )
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);
  end match;
end fun_224;

protected function fun_225
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varAssign;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varCopy, out_a_varAssign) :=
  match(in_txt, in_a_fn, in_a_var, in_a_varDecls, in_a_varInits, in_a_varCopy, in_a_varAssign, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varCopy;
      Tpl.Text a_varAssign;
      SimCode.SimCode a_simCode;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(name = i_name),
           a_var,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign,
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls) = fun_224(txt, a_var, a_varInits, l_fname, a_varAssign, a_simCode, a_varCopy, a_varDecls);
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign,
           _ )
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);
  end match;
end fun_225;

public function varOutput
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input SimCode.Variable a_var;
  input Integer a_ix;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_varInits;
  input Tpl.Text a_varCopy;
  input Tpl.Text a_varAssign;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varCopy, out_a_varAssign) := fun_225(txt, a_fn, a_var, a_varDecls, a_varInits, a_varCopy, a_varAssign, a_simCode);
end varOutput;

protected function fun_227
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varAssign, out_a_varCopy, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_fname, in_a_varAssign, in_a_simCode, in_a_var_name, in_a_varCopy, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varCopy;
      Tpl.Text a_varDecls;
      Tpl.Text l_strVar;

    case ( txt,
           false,
           a_fname,
           a_varAssign,
           a_simCode,
           a_var_name,
           a_varCopy,
           a_varDecls )
      equation
        (l_strVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_string_t", a_varDecls);
        a_varCopy = Tpl.writeText(a_varCopy, l_strVar);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(" = strdup("));
        a_varCopy = contextCref(a_varCopy, a_var_name, SimCode.contextFunction, a_simCode);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(");"));
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = init_modelica_string("));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING_LIST({
                                                    ");\n",
                                                    "free("
                                                }, false));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           _,
           a_fname,
           a_varAssign,
           a_simCode,
           a_var_name,
           a_varCopy,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("= "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varCopy, a_varDecls);
  end match;
end fun_227;

protected function lm_228
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_228(txt, rest, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_228;

protected function fun_229
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_assginEnd;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_assginBegin;
  input Tpl.Text in_a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign) :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_varInits, in_a_simCode, in_a_var_name, in_a_assginEnd, in_a_fname, in_a_assginBegin, in_a_varAssign)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_assginEnd;
      Tpl.Text a_fname;
      Tpl.Text a_assginBegin;
      Tpl.Text a_varAssign;

    case ( txt,
           {},
           _,
           a_varInits,
           a_simCode,
           a_var_name,
           a_assginEnd,
           a_fname,
           a_assginBegin,
           a_varAssign )
      equation
        a_varAssign = Tpl.pushBlock(a_varAssign, Tpl.BT_INDENT(1));
        a_varAssign = Tpl.writeText(a_varAssign, a_assginBegin);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeText(a_varAssign, a_assginEnd);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.popBlock(a_varAssign);
      then (txt, a_varInits, a_varAssign);

    case ( txt,
           _,
           a_instDimsInit,
           a_varInits,
           a_simCode,
           a_var_name,
           a_assginEnd,
           a_fname,
           a_assginBegin,
           a_varAssign )
      equation
        a_varInits = Tpl.writeText(a_varInits, a_assginBegin);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_"));
        a_varInits = Tpl.writeText(a_varInits, a_fname);
        a_varInits = Tpl.writeText(a_varInits, a_assginEnd);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".resize((boost::extents["));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_LINE("]));\n"));
        a_varInits = Tpl.pushBlock(a_varInits, Tpl.BT_INDENT(4));
        a_varInits = Tpl.writeText(a_varInits, a_assginBegin);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_"));
        a_varInits = Tpl.writeText(a_varInits, a_fname);
        a_varInits = Tpl.writeText(a_varInits, a_assginEnd);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".reindex(1);"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.popBlock(a_varInits);
        a_varAssign = Tpl.writeText(a_varAssign, a_assginBegin);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeText(a_varAssign, a_assginEnd);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("="));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign);
  end match;
end fun_229;

protected function fun_230
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_ix;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign, out_a_varCopy, out_a_varDecls) :=
  match(in_txt, in_a_var, in_a_ix, in_a_varInits, in_a_fname, in_a_varAssign, in_a_simCode, in_a_varCopy, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_ix;
      Tpl.Text a_varInits;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varCopy;
      Tpl.Text a_varDecls;
      String i_var_name_1;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_assginEnd;
      Tpl.Text l_assginBegin;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_marker;
      Boolean ret_0;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_STRING(varLst = _), name = i_var_name),
           _,
           a_varInits,
           a_fname,
           a_varAssign,
           a_simCode,
           a_varCopy,
           a_varDecls )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        (txt, a_varAssign, a_varCopy, a_varDecls) = fun_227(txt, ret_0, a_fname, a_varAssign, a_simCode, i_var_name, a_varCopy, a_varDecls);
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims),
           a_ix,
           a_varInits,
           a_fname,
           a_varAssign,
           a_simCode,
           a_varCopy,
           a_varDecls )
      equation
        l_marker = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction, a_simCode);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("/* varOutput varInits("));
        a_varInits = Tpl.writeText(a_varInits, l_marker);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(") */ "));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/* varOutput varAssign("));
        a_varAssign = Tpl.writeText(a_varAssign, l_marker);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(") */ "));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_228(l_instDimsInit, i_instDims, a_simCode, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        l_assginBegin = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("get<"));
        l_assginBegin = Tpl.writeStr(l_assginBegin, intString(a_ix));
        l_assginBegin = Tpl.writeTok(l_assginBegin, Tpl.ST_STRING(">("));
        l_assginEnd = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING(")"));
        (txt, a_varInits, a_varAssign) = fun_229(txt, i_instDims, l_instDimsInit, a_varInits, a_simCode, i_var_name, l_assginEnd, a_fname, l_assginBegin, a_varAssign);
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_var_name_1),
           _,
           a_varInits,
           a_fname,
           a_varAssign,
           _,
           a_varCopy,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = (modelica_fnptr) _"));
        a_varAssign = Tpl.writeStr(a_varAssign, i_var_name_1);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           _,
           _,
           a_varInits,
           _,
           a_varAssign,
           _,
           a_varCopy,
           a_varDecls )
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);
  end match;
end fun_230;

public function varOutputTuple
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.Variable in_a_var;
  input Integer in_a_ix;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varAssign;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varCopy, out_a_varAssign) :=
  match(in_txt, in_a_fn, in_a_var, in_a_ix, in_a_varDecls, in_a_varInits, in_a_varCopy, in_a_varAssign, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;
      Integer a_ix;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varCopy;
      Tpl.Text a_varAssign;
      SimCode.SimCode a_simCode;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(name = i_name),
           a_var,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign,
           a_simCode )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls) = fun_230(txt, a_var, a_ix, a_varInits, l_fname, a_varAssign, a_simCode, a_varCopy, a_varDecls);
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign,
           _ )
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);
  end match;
end varOutputTuple;

protected function fun_232
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "modelica_metatype" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = NULL"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_232;

protected function fun_233
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;

    case ( txt,
           "modelica_metatype",
           a_varName )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_233;

protected function fun_234
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_addRoot;
  input Tpl.Text in_a_initVar;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_typ;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_var_ty, in_a_addRoot, in_a_initVar, in_a_varName, in_a_typ)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;
      Tpl.Text a_addRoot;
      Tpl.Text a_initVar;
      Tpl.Text a_varName;
      Tpl.Text a_typ;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           _,
           a_addRoot,
           a_initVar,
           a_varName,
           a_typ )
      equation
        txt = Tpl.writeText(txt, a_typ);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeText(txt, a_initVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_addRoot);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           i_instDims,
           a_var_ty,
           a_addRoot,
           a_initVar,
           a_varName,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_instDims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeText(txt, a_initVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_addRoot);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_234;

protected function fun_235
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input Integer in_a_i;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outStruct, in_a_i, in_a_simCode, in_a_var_name)
    local
      Tpl.Text txt;
      Integer a_i;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      String i_outStruct;

    case ( txt,
           "",
           _,
           a_simCode,
           a_var_name )
      equation
        txt = contextCref(txt, a_var_name, SimCode.contextFunction, a_simCode);
      then txt;

    case ( txt,
           i_outStruct,
           a_i,
           _,
           _ )
      equation
        txt = Tpl.writeStr(txt, i_outStruct);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".targTest3"));
        txt = Tpl.writeStr(txt, intString(a_i));
      then txt;
  end match;
end fun_235;

protected function lm_236
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_236(txt, rest, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_236;

protected function fun_237
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var_value, in_a_varDecls, in_a_varInits, in_a_simCode, in_a_var_name)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_varInits,
           a_simCode,
           a_var_name )
      equation
        l_defaultValue = contextCref(Tpl.emptyTxt, a_var_name, SimCode.contextFunction, a_simCode);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(" = "));
        (l_defaultValue, a_varInits, a_varDecls) = daeExp(l_defaultValue, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(";"));
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           a_varDecls,
           a_varInits,
           _,
           _ )
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_237;

protected function fun_238
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outStruct, in_a_simCode, in_a_var_name)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;

    case ( txt,
           "",
           a_simCode,
           a_var_name )
      equation
        txt = contextCref(txt, a_var_name, SimCode.contextFunction, a_simCode);
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_var_name )
      equation
        txt = extVarName(txt, a_var_name, a_simCode);
      then txt;
  end match;
end fun_238;

protected function fun_239
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input DAE.ComponentRef in_a_var_name;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var_value, in_a_var_name, in_a_simCode, in_a_varDecls, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_varName, in_a_varInits)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varName;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;
      Tpl.Text l_defaultValue1;
      Tpl.Text l_var__name;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(i_exp),
           a_var_name,
           a_simCode,
           a_varDecls,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_varName,
           a_varInits )
      equation
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".resize((boost::extents["));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_LINE("]));\n"));
        a_varInits = Tpl.pushBlock(a_varInits, Tpl.BT_INDENT(6));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".reindex(1);"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.popBlock(a_varInits);
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits, a_simCode);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        l_var__name = fun_238(Tpl.emptyTxt, a_outStruct, a_simCode, a_var_name);
        l_defaultValue1 = Tpl.writeText(Tpl.emptyTxt, l_var__name);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(" = "));
        (l_defaultValue1, a_varInits, a_varDecls) = daeExp(l_defaultValue1, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(";"));
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           a_simCode,
           a_varDecls,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_varName,
           a_varInits )
      equation
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".resize((boost::extents["));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_LINE("]));\n"));
        a_varInits = Tpl.pushBlock(a_varInits, Tpl.BT_INDENT(6));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".reindex(1);"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.popBlock(a_varInits);
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits, a_simCode);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_239;

protected function fun_240
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Option<DAE.Exp> in_a_var_value;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_instDims, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_varName, in_a_varDecls, in_a_varInits, in_a_simCode, in_a_var_name, in_a_var_value)
    local
      Tpl.Text txt;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Option<DAE.Exp> a_var_value;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_simCode,
           a_var_name,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_237(txt, a_var_value, a_varDecls, a_varInits, a_simCode, a_var_name);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_varName,
           a_varDecls,
           a_varInits,
           a_simCode,
           a_var_name,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_239(txt, a_var_value, a_var_name, a_simCode, a_varDecls, a_i, a_outStruct, a_var, a_instDimsInit, a_varName, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_240;

public function varInit
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_varDecls, in_a_varInits, in_a_simCode)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      Option<DAE.Exp> i_var_value;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;
      SimCode.Variable i_var;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_ignore;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_varName_1;
      String str_5;
      Tpl.Text l_addRoot;
      String str_3;
      Tpl.Text l_initVar;
      Tpl.Text l_typ;
      Tpl.Text l_varName;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, ty = i_var_ty, value = i_var_value)),
           a_outStruct,
           a_i,
           a_varDecls,
           a_varInits,
           a_simCode )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction, a_simCode);
        l_typ = varType(Tpl.emptyTxt, i_var);
        str_3 = Tpl.textString(l_typ);
        l_initVar = fun_232(Tpl.emptyTxt, str_3);
        str_5 = Tpl.textString(l_typ);
        l_addRoot = fun_233(Tpl.emptyTxt, str_5, l_varName);
        a_varDecls = fun_234(a_varDecls, i_instDims, i_var_ty, l_addRoot, l_initVar, l_varName, l_typ);
        l_varName_1 = fun_235(Tpl.emptyTxt, a_outStruct, a_i, a_simCode, i_var_name);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_236(l_instDimsInit, i_instDims, a_simCode, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varDecls, a_varInits) = fun_240(txt, i_instDims, a_i, a_outStruct, i_var, l_instDimsInit, l_varName_1, a_varDecls, a_varInits, a_simCode, i_var_name, i_var_value);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           (i_var as SimCode.FUNCTION_PTR(name = _)),
           _,
           _,
           a_varDecls,
           a_varInits,
           _ )
      equation
        l_ignore = Tpl.emptyTxt;
        (a_varDecls, l_ignore) = functionArg(a_varDecls, i_var, l_ignore);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           _ )
      then (txt, a_varDecls, a_varInits);
  end match;
end varInit;

protected function lm_242
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = mmcVarType(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_242(txt, rest);
      then txt;
  end match;
end lm_242;

protected function lm_243
  input Tpl.Text in_txt;
  input list<DAE.Type> in_items;
  input Tpl.Text in_a_rettype;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_rettype)
    local
      Tpl.Text txt;
      list<DAE.Type> rest;
      Tpl.Text a_rettype;
      Integer x_i1;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_rettype )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" targTest2"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.nextIter(txt);
        txt = lm_243(txt, rest, a_rettype);
      then txt;
  end match;
end lm_243;

protected function lm_244
  input Tpl.Text in_txt;
  input list<DAE.Type> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Type> rest;
      Integer x_i1;
      DAE.Type i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ty :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = mmcTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" targTest1"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_244(txt, rest);
      then txt;
  end match;
end lm_244;

protected function fun_245
  input Tpl.Text in_txt;
  input list<DAE.Type> in_a_tys;
  input Tpl.Text in_a_rettype;
  input Tpl.Text in_a_typelist;
  input String in_a_name;
  input Tpl.Text in_a_varInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInit;
algorithm
  (out_txt, out_a_varInit) :=
  match(in_txt, in_a_tys, in_a_rettype, in_a_typelist, in_a_name, in_a_varInit)
    local
      Tpl.Text txt;
      Tpl.Text a_rettype;
      Tpl.Text a_typelist;
      String a_name;
      Tpl.Text a_varInit;
      list<DAE.Type> i_tys;

    case ( txt,
           {},
           _,
           a_typelist,
           a_name,
           a_varInit )
      equation
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("_"));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(" = (void(*)("));
        a_varInit = Tpl.writeText(a_varInit, a_typelist);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(")) "));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_NEW_LINE());
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void(*_"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, a_typelist);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInit);

    case ( txt,
           i_tys,
           a_rettype,
           a_typelist,
           a_name,
           a_varInit )
      equation
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("_"));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(" = ("));
        a_varInit = Tpl.writeText(a_varInit, a_rettype);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("(*)("));
        a_varInit = Tpl.writeText(a_varInit, a_typelist);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(")) "));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(";"));
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_243(txt, i_tys, a_rettype);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_s\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_244(txt, i_tys);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*_"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, a_typelist);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInit);
  end match;
end fun_245;

public function functionArg
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInit;
algorithm
  (out_txt, out_a_varInit) :=
  match(in_txt, in_a_var, in_a_varInit)
    local
      Tpl.Text txt;
      Tpl.Text a_varInit;
      list<DAE.Type> i_tys;
      String i_name;
      list<SimCode.Variable> i_args;
      Tpl.Text l_rettype;
      Tpl.Text l_typelist;

    case ( txt,
           SimCode.FUNCTION_PTR(args = i_args, name = i_name, tys = i_tys),
           a_varInit )
      equation
        l_typelist = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_typelist = lm_242(l_typelist, i_args);
        l_typelist = Tpl.popIter(l_typelist);
        l_rettype = Tpl.writeStr(Tpl.emptyTxt, i_name);
        l_rettype = Tpl.writeTok(l_rettype, Tpl.ST_STRING("RetType"));
        (txt, a_varInit) = fun_245(txt, i_tys, l_rettype, l_typelist, i_name, a_varInit);
      then (txt, a_varInit);

    case ( txt,
           _,
           a_varInit )
      then (txt, a_varInit);
  end match;
end functionArg;

public function mmcVarType
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = mmcTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end mmcVarType;

public function mmcTypeShort
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("array"));
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fnptr"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmcTypeShort:ERROR"));
      then txt;
  end match;
end mmcTypeShort;

public function extVarName
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := contextCref(txt, a_cr, SimCode.contextFunction, a_simCode);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_ext"));
end extVarName;

public function extVarName2
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := contextCref2(txt, a_cr, SimCode.contextFunction);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_ext"));
end extVarName2;

protected function fun_251
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_value;
  input String in_a_lhsVarName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_value, in_a_lhsVarName, in_a_varDecls, in_a_varInits, in_a_i, in_a_outStruct, in_a_simCode)
    local
      Tpl.Text txt;
      String a_lhsVarName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Integer a_i;
      String a_outStruct;
      SimCode.SimCode a_simCode;
      DAE.Exp i_arr;
      DAE.ComponentRef i_cr;
      Tpl.Text l_arrayExp;

    case ( txt,
           SOME(DAE.CREF(componentRef = i_cr)),
           _,
           a_varDecls,
           a_varInits,
           a_i,
           a_outStruct,
           a_simCode )
      equation
        txt = contextCref(txt, i_cr, SimCode.contextFunction, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" =  "));
        txt = Tpl.writeStr(txt, a_outStruct);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".targTest9"));
        txt = Tpl.writeStr(txt, intString(a_i));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           SOME((i_arr as DAE.ARRAY(ty = _))),
           a_lhsVarName,
           a_varDecls,
           a_varInits,
           _,
           _,
           a_simCode )
      equation
        (l_arrayExp, a_varInits, a_varDecls) = daeExp(Tpl.emptyTxt, i_arr, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode);
        txt = Tpl.writeStr(txt, a_lhsVarName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_arrayExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_varInits,
           _,
           _,
           _ )
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_251;

public function varDefaultValue
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input String in_a_lhsVarName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_lhsVarName, in_a_varDecls, in_a_varInits, in_a_simCode)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      String a_lhsVarName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      Option<DAE.Exp> i_value;

    case ( txt,
           SimCode.VARIABLE(value = i_value),
           a_outStruct,
           a_i,
           a_lhsVarName,
           a_varDecls,
           a_varInits,
           a_simCode )
      equation
        (txt, a_varDecls, a_varInits) = fun_251(txt, i_value, a_lhsVarName, a_varDecls, a_varInits, a_i, a_outStruct, a_simCode);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           _ )
      then (txt, a_varDecls, a_varInits);
  end match;
end varDefaultValue;

public function funArgDefinition
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)),
           a_simCode )
      equation
        txt = varType1(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end funArgDefinition;

public function funExtArgDefinition
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extArg, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.Type i_type__;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, isArray = _, type_ = i_t),
           a_simCode )
      equation
        l_name = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction, a_simCode);
        l_typeStr = expTypeFlag(Tpl.emptyTxt, i_t, 5);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_name);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__),
           _ )
      equation
        l_typeStr = expTypeFlag(Tpl.emptyTxt, i_type__, 5);
        txt = Tpl.writeText(txt, l_typeStr);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_t"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end funExtArgDefinition;

protected function fun_255
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)) )
      equation
        txt = varType1(txt, i_var);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_255;

public function funReturnDefinition1
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_255(txt, a_var);
end funReturnDefinition1;

protected function fun_257
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)) )
      equation
        txt = varType2(txt, i_var);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_257;

public function funReturnDefinition2
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_257(txt, a_var);
end funReturnDefinition2;

protected function fun_259
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_var_ty)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;

    case ( txt,
           {},
           a_var_ty )
      equation
        txt = expTypeArrayIf(txt, a_var_ty);
      then txt;

    case ( txt,
           _,
           a_var_ty )
      equation
        txt = expTypeArray(txt, a_var_ty);
      then txt;
  end match;
end fun_259;

public function varType
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims, ty = i_var_ty) )
      equation
        txt = fun_259(txt, i_instDims, i_var_ty);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end varType;

protected function fun_261
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_var_ty)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           a_var_ty )
      equation
        txt = expTypeFlag(txt, a_var_ty, 6);
      then txt;

    case ( txt,
           i_instDims,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_instDims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
      then txt;
  end match;
end fun_261;

public function varType1
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims, ty = i_var_ty) )
      equation
        txt = fun_261(txt, i_instDims, i_var_ty);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end varType1;

protected function fun_263
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_var_ty)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           a_var_ty )
      equation
        txt = expTypeFlag(txt, a_var_ty, 5);
      then txt;

    case ( txt,
           i_instDims,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array_ref<"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_instDims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
      then txt;
  end match;
end fun_263;

public function varType2
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims, ty = i_var_ty) )
      equation
        txt = fun_263(txt, i_instDims, i_var_ty);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end varType2;

protected function lm_265
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, SimCode.contextFunction, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_265(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_265;

public function funStatement
  input Tpl.Text in_txt;
  input SimCode.Statement in_a_stmt;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<DAE.Statement> i_statementLst;

    case ( txt,
           SimCode.ALGORITHM(statementLst = i_statementLst),
           a_varDecls,
           a_simCode )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_265(txt, i_statementLst, a_simCode, a_varDecls);
        txt = Tpl.popIter(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED FUN STATEMENT"));
      then (txt, a_varDecls);
  end match;
end funStatement;

public function init
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_allEquations;
      Absyn.Path i_modelInfo_name;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<list<SimCode.SimEqSystem>> i_algebraicEquations;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<SimCode.SimEqSystem> i_startValueEquations;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      list<SimCode.SimEqSystem> ret_8;
      Tpl.Text l_initialequations;
      Tpl.Text l_initALgloopSolvers;
      Tpl.Text l_initOutputIndices;
      Tpl.Text l_initEventHandling;
      Tpl.Text l_initZeroCrossings;
      Tpl.Text l_initFunctions;
      Tpl.Text l_initVariables;
      Tpl.Text l_varDecls;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), startValueEquations = i_startValueEquations, zeroCrossings = i_zeroCrossings, odeEquations = i_odeEquations, algebraicEquations = i_algebraicEquations, whenClauses = i_whenClauses, parameterEquations = i_parameterEquations, initialEquations = i_initialEquations, allEquations = i_allEquations)) )
      equation
        System.tmpTickReset(0);
        l_varDecls = Tpl.emptyTxt;
        l_initVariables = initvar(Tpl.emptyTxt, i_modelInfo, i_simCode);
        (l_initFunctions, l_varDecls) = functionInitial(Tpl.emptyTxt, i_startValueEquations, l_varDecls, i_simCode);
        (l_initZeroCrossings, l_varDecls) = functionOnlyZeroCrossing(Tpl.emptyTxt, i_zeroCrossings, l_varDecls, i_simCode);
        l_initEventHandling = eventHandlingInit(Tpl.emptyTxt, i_simCode);
        l_initOutputIndices = outputIndices(Tpl.emptyTxt, i_modelInfo);
        l_initALgloopSolvers = initAlgloopsolvers(Tpl.emptyTxt, i_odeEquations, i_algebraicEquations, i_whenClauses, i_parameterEquations, i_simCode);
        l_initialequations = functionInitialEquations(Tpl.emptyTxt, i_initialEquations, i_simCode);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::initialize()\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        ret_8 = listAppend(i_allEquations, i_initialEquations);
        txt = generateAlgloopsolvers(txt, ret_8, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_simTime = 0.0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  _historyImpl->init();\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_initVariables);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_initFunctions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.initialize(this,"));
        txt = helpvarlength(txt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_initEventHandling);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  map<unsigned int,string> var_ouputs_idx;\n"));
        txt = Tpl.writeText(txt, l_initOutputIndices);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_historyImpl->setOutputs(var_ouputs_idx);\n",
                                    "_historyImpl->clear();\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_initALgloopSolvers);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "initEquations();\n",
                                    "for(int i=0;i<_dimZeroFunc;i++)\n",
                                    "{\n",
                                    "   getCondition(i);\n",
                                    "}\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "initialAnalyticJacobian();\n",
                                    "saveAll();\n",
                                    "  }\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::initEquations()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_initialequations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end init;

protected function lm_268
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq, SimCode.contextAlgloopInitialisation, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_268(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_268;

public function functionInitialEquations
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initalEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_body;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_varDecls) := lm_268(l_body, a_initalEquations, a_simCode, l_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/*Initial equations*/\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       " /*Initial equations end*/\n",
                                       "\n",
                                       "\n"
                                   }, true));
end functionInitialEquations;

protected function fun_270
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_simCode, in_a_varDecls, in_a_modelname)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(index = i_index)),
           a_simCode,
           a_varDecls,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::initialize()\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        (txt, a_varDecls) = initAlgloopEquation(txt, i_eq, a_varDecls, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "     AlgLoopDefaultImplementation::initialize();\n",
                                    "\n",
                                    "  // Update the equations once before start of simulation\n",
                                    "  evaluate(IContinuous::ALL);\n",
                                    " }"
                                }, false));
      then (txt, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_simCode,
           a_varDecls,
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::initialize()\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        (txt, a_varDecls) = initAlgloopEquation(txt, i_eq, a_varDecls, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "   // Update the equations once before start of simulation\n",
                                    "   evaluate(IContinuous::ALL);\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end match;
end fun_270;

public function initAlgloop
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_varDecls;
      Tpl.Text l_initalgvars;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_initalgvars = initAlgloopvars(Tpl.emptyTxt, i_modelInfo, i_simCode);
        l_varDecls = Tpl.emptyTxt;
        (txt, l_varDecls) = fun_270(txt, a_eq, i_simCode, l_varDecls, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end initAlgloop;

protected function fun_272
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      Integer i_index;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getSystemMatrix(double* A_matrix)\n",
                                    "{\n",
                                    "\n",
                                    " }"
                                }, false));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getSystemMatrix(double* A_matrix)\n",
                                    "{\n",
                                    "     memcpy(A_matrix,__A.data(),_dimAEq*_dimAEq*sizeof(double));\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_272;

public function getAMatrixCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_varDecls;
      Tpl.Text l_initalgvars;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_initalgvars = initAlgloopvars(Tpl.emptyTxt, i_modelInfo, i_simCode);
        l_varDecls = Tpl.emptyTxt;
        txt = fun_272(txt, a_eq, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end getAMatrixCode;

protected function fun_274
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      Integer i_index;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getRHS(double* residuals)\n",
                                    "  {\n",
                                    "      if (isLinear())\n",
                                    "      {\n",
                                    "          for(size_t i=0; i<_dimAEq; ++i)\n",
                                    "              residuals[i] = __b[i];\n",
                                    "      }\n",
                                    "      else\n",
                                    "          AlgLoopDefaultImplementation::getRHS(residuals);\n",
                                    "  }"
                                }, false));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getRHS(double* residuals)\n",
                                    "  {\n",
                                    "      if (isLinear())\n",
                                    "      {\n",
                                    "          for(size_t i=0; i<_dimAEq; ++i)\n",
                                    "              residuals[i] = __b[i];\n",
                                    "      }\n",
                                    "      else\n",
                                    "          AlgLoopDefaultImplementation::getRHS(residuals);\n",
                                    "  }"
                                }, false));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_274;

public function algloopRHSCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_varDecls;
      Tpl.Text l_initalgvars;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_initalgvars = initAlgloopvars(Tpl.emptyTxt, i_modelInfo, i_simCode);
        l_varDecls = Tpl.emptyTxt;
        txt = fun_274(txt, a_eq, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end algloopRHSCode;

protected function fun_276
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode, in_a_modelname)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_cont;
      Integer i_index;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimRHS()\n",
                                    "{\n",
                                    "  return _dimAEq;\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getRHS(double* vars)\n",
                                    "{\n",
                                    "    ublas::matrix<double> A=toMatrix(_dimAEq,_dimAEq,__A.data());\n",
                                    "    double* doubleUnknowns = new double[_dimAEq];\n",
                                    "    getReal(doubleUnknowns);\n",
                                    "    ublas::vector<double> x=toVector(_dimAEq,doubleUnknowns);\n",
                                    "    ublas::vector<double> b=toVector(_dimAEq,__b.data());\n",
                                    "    b=ublas::prod(ublas::trans(A),x)-b;\n",
                                    "    if(vars) std::copy(b.data().begin(), b.data().end(), vars);\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveDimRHS()\n",
                                    "{\n",
                                    "  return _dimAEq;\n",
                                    "\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getRHS(double* vars)\n",
                                    "{\n",
                                    "      AlgLoopDefaultImplementation:::getRHS(vars)\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont),
           a_simCode,
           _ )
      equation
        txt = algloopResiduals(txt, a_simCode, i_cont);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_276;

public function algloopResiduals
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_276(txt, a_eq, i_simCode, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end algloopResiduals;

protected function fun_278
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      Integer i_index;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isLinear()\n",
                                    "{\n",
                                    "       return false;\n",
                                    " }"
                                }, false));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isLinear()\n",
                                    "{\n",
                                    "     return true;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_278;

public function isLinearCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_varDecls;
      Tpl.Text l_initalgvars;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_initalgvars = initAlgloopvars(Tpl.emptyTxt, i_modelInfo, i_simCode);
        l_varDecls = Tpl.emptyTxt;
        txt = fun_278(txt, a_eq, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end isLinearCode;

protected function lm_280
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref1(Tpl.emptyTxt, i_name, a_simCode, SimCode.contextAlgloop);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__xd["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_280(txt, rest, a_simCode);
      then txt;
  end match;
end lm_280;

protected function lm_281
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer i_col;
      Integer i_row;
      DAE.Exp i_eq_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_row, i_col, SimCode.SES_RESIDUAL(exp = i_eq_exp)) :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq_exp, SimCode.contextAlgloop, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__A["));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]["));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_281(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_281(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_281;

protected function lm_282
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer x_i0;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextAlgloop, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__b["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_282(txt, rest, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_282;

protected function fun_283
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<DAE.Exp> i_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<DAE.ComponentRef> i_crefs;
      Tpl.Text l_bvector;
      Tpl.Text l_Amatrix;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs),
           a_simCode )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_280(txt, i_crefs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(simJac = i_simJac, beqs = i_beqs),
           a_simCode )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        l_Amatrix = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_Amatrix, l_varDecls, l_preExp) = lm_281(l_Amatrix, i_simJac, a_simCode, l_varDecls, l_preExp);
        l_Amatrix = Tpl.popIter(l_Amatrix);
        l_bvector = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bvector, l_varDecls, l_preExp) = lm_282(l_bvector, i_beqs, a_simCode, l_varDecls, l_preExp);
        l_bvector = Tpl.popIter(l_bvector);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_Amatrix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_bvector);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_283;

public function initAlgloopEquation
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_283(txt, a_eq, a_simCode);
  out_a_varDecls := a_varDecls;
end initAlgloopEquation;

protected function lm_285
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref1(Tpl.emptyTxt, i_name, a_simCode, SimCode.contextAlgloop);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("vars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_285(txt, rest, a_simCode);
      then txt;
  end match;
end lm_285;

protected function lm_286
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("vars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] ="));
        txt = cref1(txt, i_name, a_simCode, SimCode.contextAlgloop);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_286(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_286(txt, rest, a_simCode);
      then txt;
  end match;
end lm_286;

public function giveAlgloopvars
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars;
      list<DAE.ComponentRef> i_crefs;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs),
           a_simCode )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_285(txt, i_crefs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars),
           a_simCode )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_286(txt, i_vars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = inlineVars(txt, SimCode.contextSimulationNonDiscrete, i_vars);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end giveAlgloopvars;

protected function lm_288
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = writeAlgloopvars2(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
        (txt, a_varDecls) = lm_288(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_288;

protected function lm_289
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_288(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_289(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_289;

public function writeAlgloopvars
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_continousEquations;
  input list<SimCode.SimEqSystem> a_discreteEquations;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_289(l_algloopsolver, a_continousEquations, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.writeText(txt, l_algloopsolver);
end writeAlgloopvars;

protected function lm_291
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_index)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_index;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_index )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = algloopvars"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_291(txt, rest, a_index);
      then txt;
  end match;
end lm_291;

protected function lm_292
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_algloopid;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_algloopid, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_algloopid;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_algloopid,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref1(txt, i_name, a_simCode, SimCode.contextAlgloop);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = algloopvars"));
        txt = Tpl.writeText(txt, a_algloopid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_292(txt, rest, a_algloopid, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_algloopid,
           a_simCode )
      equation
        txt = lm_292(txt, rest, a_algloopid, a_simCode);
      then txt;
  end match;
end lm_292;

protected function fun_293
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars;
      Integer i_index;
      list<DAE.ComponentRef> i_crefs;
      Tpl.Text l_algloopid;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs, index = i_index),
           _ )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double algloopvars"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->getReal(algloopvars"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_291(txt, i_crefs, i_index);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, index = i_index),
           a_simCode )
      equation
        ret_2 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_algloopid = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double algloopvars"));
        txt = Tpl.writeText(txt, l_algloopid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->getReal(algloopvars"));
        txt = Tpl.writeText(txt, l_algloopid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",NULL,NULL);\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_292(txt, i_vars, l_algloopid, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_293;

public function writeAlgloopvars2
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_293(txt, a_eq, a_simCode);
  out_a_varDecls := a_varDecls;
end writeAlgloopvars2;

protected function lm_295
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref1(Tpl.emptyTxt, i_name, a_simCode, SimCode.contextAlgloop);
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  = vars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_295(txt, rest, a_simCode);
      then txt;
  end match;
end lm_295;

protected function lm_296
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref1(txt, i_name, a_simCode, SimCode.contextAlgloop);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=vars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_296(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_296(txt, rest, a_simCode);
      then txt;
  end match;
end lm_296;

public function setAlgloopvars
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars;
      list<DAE.ComponentRef> i_crefs;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs),
           a_simCode )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_295(txt, i_crefs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_296(txt, i_vars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = inlineVars(txt, SimCode.contextSimulationNonDiscrete, i_vars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end setAlgloopvars;

protected function fun_298
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars;
      list<DAE.ComponentRef> i_crefs;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs) )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  // Number of unknowns equations\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimAEq = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "_constraintType = IAlgLoop::REAL;\n",
                                    "__xd.resize("
                                }, false));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_xd_init.resize("));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars) )
      equation
        ret_2 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  // Number of unknowns/equations according to type (0: double, 1: int, 2: bool)\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimAEq = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "fill_array(__A,0.0);\n",
                                    "fill_array(__b,0.0);"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_298;

public function initAlgloopDimension
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_298(txt, a_eq);
  out_a_varDecls := a_varDecls;
end initAlgloopDimension;

public function alocateLinearSystem
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars) )
      equation
        ret_1 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",__A(boost::extents["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("],boost::fortran_storage_order())\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",__b(boost::extents["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end alocateLinearSystem;

public function Update
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_allEquations;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(allEquations = i_allEquations, whenClauses = i_whenClauses)) )
      equation
        txt = update(txt, i_allEquations, i_whenClauses, i_simCode, SimCode.contextOther);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end Update;

protected function smf_302
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_it;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           i_eq,
           a_simCode )
      equation
        txt = writeoutputAlgloopsolvers(txt, i_eq, a_simCode);
      then txt;
  end match;
end smf_302;

protected function lm_303
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqs :: rest,
           a_simCode )
      equation
        txt = smf_302(txt, i_eqs, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_303(txt, rest, a_simCode);
      then txt;
  end match;
end lm_303;

protected function lm_304
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqn :: rest,
           a_simCode )
      equation
        txt = writeoutput3(txt, i_eqn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_304(txt, rest, a_simCode);
      then txt;
  end match;
end lm_304;

protected function fun_305
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.SimEqSystem> in_a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_allEquations)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> a_allEquations;

    case ( txt,
           false,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_historyImpl->write(v,v2,_simTime);"));
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_allEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("HistoryImplType::value_type_r v3("));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_303(txt, a_allEquations, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double residues [] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_304(txt, a_allEquations, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "for(int i=0;i<"
                                }, false));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";i++) v3(i) = residues[i];\n",
                                    "_historyImpl->write(v,v2,v3,_simTime);"
                                }, false));
      then txt;
  end match;
end fun_305;

public function writeoutput
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), allEquations = i_allEquations)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::writeOutput(const OUTPUT command)\n",
                                    "{\n",
                                    "\n",
                                    " //Write head line\n",
                                    " if (command & HEAD_LINE)\n",
                                    " {\n",
                                    "   vector<string> head;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("head+= "));
        txt = writeoutput1(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_historyImpl->write(head);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    " //Write the current values\n",
                                    " else\n",
                                    " {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("HistoryImplType::value_type_v v("));
        txt = numAlgvars(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numInOutvars(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numAliasvars(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numStatevars(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "HistoryImplType::value_type_dv v2("
                                }, false));
        txt = numDerivativevars(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = writeoutput2(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_305(txt, ret_0, i_simCode, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "  saveAll();\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end writeoutput;

protected function fun_307
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double* doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->getDimRHS()];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->getRHS(doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end match;
end fun_307;

protected function fun_308
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double* doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->getDimRHS()];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->getRHS(doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end match;
end fun_308;

protected function fun_309
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double* doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->getDimRHS()];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->getRHS(doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end match;
end fun_309;

public function writeoutputAlgloopsolvers
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_307(txt, a_simCode, l_num);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_308(txt, a_simCode, l_num);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(index = i_index),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_309(txt, a_simCode, l_num);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end writeoutputAlgloopsolvers;

protected function lm_311
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_e_index)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_e_index;
      Integer x_myindex2;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_e_index )
      equation
        x_myindex2 = Tpl.getIteri_i0(txt);
        txt = writeoutput4(txt, a_e_index, x_myindex2);
        txt = Tpl.nextIter(txt);
        txt = lm_311(txt, rest, a_e_index);
      then txt;
  end match;
end lm_311;

protected function lm_312
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_e_index)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Integer a_e_index;
      Integer x_myindex2;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_e_index )
      equation
        x_myindex2 = Tpl.getIteri_i0(txt);
        txt = writeoutput4(txt, a_e_index, x_myindex2);
        txt = Tpl.nextIter(txt);
        txt = lm_312(txt, rest, a_e_index);
      then txt;
  end match;
end lm_312;

public function writeoutput3
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_cont;
      list<SimCode.SimEqSystem> i_eqs;
      Integer i_e_index;
      list<SimCode.SimVar> i_vars;
      DAE.ComponentRef i_cref;

    case ( txt,
           SimCode.SES_RESIDUAL(index = _),
           _ )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref),
           a_simCode )
      equation
        txt = cref1(txt, i_cref, a_simCode, SimCode.contextOther);
      then txt;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(index = _),
           _ )
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(index = _),
           _ )
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, index = i_e_index),
           _ )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_311(txt, i_vars, i_e_index);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(eqs = i_eqs, index = i_e_index),
           _ )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_312(txt, i_eqs, i_e_index);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont),
           a_simCode )
      equation
        txt = writeoutput3(txt, i_cont, a_simCode);
      then txt;

    case ( txt,
           SimCode.SES_WHEN(index = _),
           _ )
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end writeoutput3;

public function writeoutput4
  input Tpl.Text txt;
  input Integer a_index;
  input Integer a_myindex2;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("*(doubleResiduals"));
  out_txt := Tpl.writeStr(out_txt, intString(a_index));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("+"));
  out_txt := Tpl.writeStr(out_txt, intString(a_myindex2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(")"));
end writeoutput4;

protected function fun_315
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.SimEqSystem> in_a_allEquations;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_allEquations, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquations;
      SimCode.ModelInfo a_modelInfo;

    case ( txt,
           false,
           _,
           a_modelInfo )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include \"DataExchange/Policies/TextfileWriter.h\"\n",
                                    "typedef HistoryImpl<TextFileWriter,"
                                }, false));
        txt = numAlgvars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numInOutvars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numAliasvars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numStatevars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = numDerivativevars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",0> HistoryImplType;\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           a_allEquations,
           a_modelInfo )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include \"ReduceDAE/Interfaces/IReduceDAE.h\"\n",
                                    "#include \"DataExchange/Policies/BufferReaderWriter.h\"\n",
                                    "typedef HistoryImpl<BufferReaderWriter,"
                                }, false));
        txt = numAlgvars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numInOutvars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numAliasvars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numStatevars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = numDerivativevars(txt, a_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "> HistoryImplType;\n",
                                    "\n"
                                }, true));
      then txt;
  end match;
end fun_315;

public function generateHeaderInlcudeString
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      SimCode.ModelInfo i_modelInfo;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      Boolean ret_1;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), extObjInfo = SimCode.EXTOBJINFO(vars = _), allEquations = i_allEquations, initialEquations = i_initialEquations)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma once\n",
                                    "#define BOOST_EXTENSION_SYSTEM_DECL BOOST_EXTENSION_EXPORT_DECL\n",
                                    "#define BOOST_EXTENSION_EVENTHANDLING_DECL BOOST_EXTENSION_EXPORT_DECL\n",
                                    "#include \"System/EventHandling.h\"\n",
                                    "#include \"System/SystemDefaultImplementation.h\"\n",
                                    "#include \"Functions.h\"\n",
                                    "#include \"HistoryImpl.h\"\n"
                                }, true));
        ret_0 = listAppend(i_allEquations, i_initialEquations);
        txt = algloopfilesInclude(txt, ret_0, i_simCode);
        txt = Tpl.softNewLine(txt);
        ret_1 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_315(txt, ret_1, i_allEquations, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Simulation code for "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " generated by the OpenModelica Compiler.\n",
                                    "* System class "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " implements the Interface IMixedSystem\n",
                                    "*\n",
                                    "*****************************************************************************/"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end generateHeaderInlcudeString;

public function generateAlgloopHeaderInlcudeString
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), extObjInfo = SimCode.EXTOBJINFO(vars = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma once\n",
                                    "#define BOOST_EXTENSION_ALGLOOPDEFAULTIMPL_DECL BOOST_EXTENSION_EXPORT_DECL\n",
                                    "#define BOOST_EXTENSION_EVENTHANDLING_DECL BOOST_EXTENSION_EXPORT_DECL\n",
                                    "#include \"System/IMixedSystem.h\"\n",
                                    "#include \"System/AlgLoopDefaultImplementation.h\"\n",
                                    "#include \"System/EventHandling.h\"\n",
                                    "#include \"Functions.h\"\n",
                                    "class "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end generateAlgloopHeaderInlcudeString;

protected function fun_318
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", public IReduceDAE"));
      then txt;
  end match;
end fun_318;

public function generateClassDeclarationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      SimCode.ModelInfo i_modelInfo;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      Absyn.Path i_modelInfo_name;
      list<SimCode.SimEqSystem> ret_2;
      list<SimCode.SimEqSystem> ret_1;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), allEquations = i_allEquations, initialEquations = i_initialEquations, zeroCrossings = i_zeroCrossings, jacobianMatrixes = i_jacobianMatrixes)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": public IMixedSystem, public IContinuous, public IEvent,  public ITime, public ISystemProperties, public ISystemInitialization"));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_318(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ", public SystemDefaultImplementation\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        ret_1 = listAppend(i_allEquations, i_initialEquations);
        txt = generatefriendAlgloops(txt, ret_1, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("public:\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(IGlobalSettings* globalSettings,boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactor,boost::shared_ptr<ISimData>);\n",
                                    "\n",
                                    "~"
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "();\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateMethodDeclarationCode(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "bool getCondition(unsigned int index);\n",
                                    "private:\n",
                                    "  //Methods:\n",
                                    "   void initEquations();\n",
                                    "\n",
                                    "\n",
                                    "   void initialAnalyticJacobian();\n",
                                    "   void calcJacobianColumn();\n",
                                    "   //Variables:\n",
                                    "   EventHandling _event_handling;\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = MemberVariable(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = conditionvariable(txt, i_zeroCrossings, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Functions _functions;\n",
                                    "HistoryImplType* _historyImpl;\n",
                                    "SparseMatrix _jacobian;\n",
                                    "ublas::vector<double> _jac_y;\n",
                                    "ublas::vector<double> _jac_tmp;\n",
                                    "ublas::vector<double> _jac_x;\n",
                                    "boost::shared_ptr<IAlgLoopSolverFactory>\n",
                                    "   _algLoopSolverFactory;    ///< Factory that provides an appropriate solver\n"
                                }, true));
        ret_2 = listAppend(i_allEquations, i_initialEquations);
        txt = generateAlgloopsolverVariables(txt, ret_2, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//workaround for jacobian variables\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = variableDefinitionsJacobians(txt, i_jacobianMatrixes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  boost::shared_ptr<ISimData> _simData;\n",
                                    "\n",
                                    " };"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end generateClassDeclarationCode;

protected function fun_320
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode, in_a_modelname)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_modelname;
      Integer i_index;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_simCode,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ": public IAlgLoop, public AlgLoopDefaultImplementation\n",
                                    "{\n",
                                    "public:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(    "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "* system\n",
                                    "                                  ,double* z,double* zDot, bool* conditions\n",
                                    "                                 ,EventHandling& event_handling\n",
                                    "                                );\n",
                                    "~"
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "();\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateAlgloopMethodDeclarationCode(txt, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "private:\n",
                                    "  Functions _functions;\n",
                                    "  //states\n",
                                    "  double* __z;\n",
                                    "  //state derivatives\n",
                                    "  double* __zDot;\n",
                                    "  // A matrix\n",
                                    "  boost::multi_array<double,2> __A;\n",
                                    "  //b vector\n",
                                    "  boost::multi_array<double,1> __b;\n",
                                    "  bool* _conditions;\n",
                                    "\n",
                                    "  EventHandling& _event_handling;\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("* _system;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" };"));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_simCode,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ": public IAlgLoop, public AlgLoopDefaultImplementation\n",
                                    "{\n",
                                    "public:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(    "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "* system\n",
                                    "                                  ,double* z,double* zDot, bool* conditions\n",
                                    "                                 ,EventHandling& event_handling\n",
                                    "                                );\n",
                                    "~"
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "();\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateAlgloopMethodDeclarationCode(txt, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "private:\n",
                                    "  Functions _functions;\n",
                                    "  //states\n",
                                    "  double* __z;\n",
                                    "  //state derivatives\n",
                                    "  double* __zDot;\n",
                                    "  // A matrix\n",
                                    "  boost::multi_array<double,2> __A;\n",
                                    "  //b vector\n",
                                    "  boost::multi_array<double,1> __b;\n",
                                    "  bool* _conditions;\n",
                                    "\n",
                                    "  EventHandling& _event_handling;\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("* _system;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" };"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_320;

public function generateAlgloopClassDeclarationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_constructorParams;
      Tpl.Text l_algvars;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_algvars = MemberVariableAlgloop(Tpl.emptyTxt, i_modelInfo);
        l_constructorParams = ConstructorParamAlgloop(Tpl.emptyTxt, i_modelInfo);
        txt = fun_320(txt, a_eq, i_simCode, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end generateAlgloopClassDeclarationCode;

protected function smf_322
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_it;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           i_eq,
           a_simCode )
      equation
        txt = writeoutputAlgloopsolvers(txt, i_eq, a_simCode);
      then txt;
  end match;
end smf_322;

protected function lm_323
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqs :: rest,
           a_simCode )
      equation
        txt = smf_322(txt, i_eqs, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_323(txt, rest, a_simCode);
      then txt;
  end match;
end lm_323;

protected function lm_324
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqn :: rest,
           a_simCode )
      equation
        txt = writeoutput3(txt, i_eqn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_324(txt, rest, a_simCode);
      then txt;
  end match;
end lm_324;

protected function fun_325
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.SimEqSystem> in_a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_allEquations)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> a_allEquations;

    case ( txt,
           false,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    SystemDefaultImplementation::getRHS(f);"));
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_allEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(index == IContinuous::ALL_RESIDUES)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_323(txt, a_allEquations, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double residues [] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_324(txt, a_allEquations, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "for(int i=0;i<"
                                }, false));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";i++) *(f+i) = residues[i];\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "else SystemDefaultImplementation::getRHS(f);"
                                }, false));
      then txt;
  end match;
end fun_325;

public function DefaultImplementationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_allEquations;
      Absyn.Path i_modelInfo_name;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), allEquations = i_allEquations)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  // Release instance\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::destroy()\n",
                                    "{\n",
                                    "    delete this;\n",
                                    "}\n",
                                    "\n",
                                    "// Set current integration time\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setTime(const double& t)\n",
                                    "{\n",
                                    "    SystemDefaultImplementation::setTime(t);\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "// Provide number (dimension) of variables according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimContinuousStates() const\n",
                                    "{\n",
                                    "    return(SystemDefaultImplementation::getDimContinuousStates());\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "// Provide number (dimension) of variables according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimBoolean() const\n",
                                    "{\n",
                                    "    return(SystemDefaultImplementation::getDimBoolean());\n",
                                    "}\n",
                                    "\n",
                                    "// Provide number (dimension) of variables according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimInteger() const\n",
                                    "{\n",
                                    "    return(SystemDefaultImplementation::getDimInteger());\n",
                                    "}\n",
                                    "// Provide number (dimension) of variables according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimReal() const\n",
                                    "{\n",
                                    "    return(SystemDefaultImplementation::getDimReal());\n",
                                    "}\n",
                                    "\n",
                                    "// Provide number (dimension) of variables according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimString() const\n",
                                    "{\n",
                                    "    return(SystemDefaultImplementation::getDimString());\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "// Provide number (dimension) of right hand sides (equations and/or residuals) according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimRHS() const\n",
                                    "{\n",
                                    "     return(SystemDefaultImplementation::getDimRHS());\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getBoolean(bool* z)\n",
                                    "{\n",
                                    "\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getInteger(int* z)\n",
                                    "{\n",
                                    "\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getContinuousStates(double* z)\n",
                                    "{\n",
                                    "    SystemDefaultImplementation::getContinuousStates(z);\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getReal(double* z)\n",
                                    "{\n",
                                    "\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getString(string* z)\n",
                                    "{\n",
                                    "\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setBoolean(const bool* z)\n",
                                    "{\n",
                                    "\n",
                                    "}\n",
                                    "// Provide variables with given index to the system\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setInteger(const int* z)\n",
                                    "{\n",
                                    "\n",
                                    "}\n",
                                    "// Provide variables with given index to the system\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setReal(const double* z)\n",
                                    "{\n",
                                    "\n",
                                    "}\n",
                                    "// Provide variables with given index to the system\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setString(const string*  z)\n",
                                    "{\n",
                                    "\n",
                                    "}\n",
                                    "\n",
                                    "// Set variables with given index to the system\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setContinuousStates(const double* z)\n",
                                    "{\n",
                                    "    SystemDefaultImplementation::setContinuousStates(z);\n",
                                    "}\n",
                                    "\n",
                                    "// Provide the right hand side (according to the index)\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getRHS(double* f)\n",
                                    "{\n"
                                }, true));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_325(txt, ret_0, i_simCode, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isStepEvent()\n",
                                    "{\n",
                                    "    throw std::runtime_error(\"isAutonomous is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isAlgebraic()\n",
                                    "{\n",
                                    "  return false; // Indexreduction is enabled\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "IHistory* "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getHistory()\n",
                                    "{\n",
                                    "   return _historyImpl;\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::provideSymbolicJacobian()\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"provideSymbolicJacobian is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::handleEvent(const bool* events)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = handleEvent(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end DefaultImplementationCode;

protected function fun_327
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode, in_a_modelname)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_simCode,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/// Provide number (dimension) of variables according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimReal() const\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimReal());\n",
                                    "};\n",
                                    "\n",
                                    "/// Provide number (dimension) of residuals according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimRHS( ) const\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimRHS());\n",
                                    "};\n",
                                    "\n",
                                    "\n",
                                    "/// Provide variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getReal(double* vars)\n",
                                    "{\n",
                                    "\n",
                                    "    AlgLoopDefaultImplementation::getReal(vars);\n",
                                    "    //workaroud until names of algloop vars are replaced in simcode\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = giveAlgloopvars(txt, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "/// Set variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setReal(const double* vars)\n",
                                    "{\n",
                                    "\n",
                                    "    //workaround until names of algloop vars are replaced in simcode\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = setAlgloopvars(txt, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("AlgLoopDefaultImplementation::setReal(vars);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "/// Set stream for output\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setOutput(ostream* outputStream)\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::setOutput(outputStream);\n",
                                    "};"
                                }, false));
      then txt;

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(index = i_index)),
           a_simCode,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/// Provide number (dimension) of variables according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimReal() const\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimReal());\n",
                                    "};\n",
                                    "\n",
                                    "/// Provide number (dimension) of residuals according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimRHS( ) const\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimRHS());\n",
                                    "};\n",
                                    "\n",
                                    "\n",
                                    "/// Provide variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getReal(double* vars)\n",
                                    "{\n",
                                    "\n",
                                    "    AlgLoopDefaultImplementation::getReal(vars);\n",
                                    "    //workaroud until names of algloop vars are replaced in simcode\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = giveAlgloopvars(txt, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "/// Set variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setReal(const double* vars)\n",
                                    "{\n",
                                    "\n",
                                    "    //workaround until names of algloop vars are replaced in simcode\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = setAlgloopvars(txt, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("AlgLoopDefaultImplementation::setReal(vars);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "/// Set stream for output\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setOutput(ostream* outputStream)\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::setOutput(outputStream);\n",
                                    "};"
                                }, false));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_327;

public function AlgloopDefaultImplementationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_327(txt, a_eq, i_simCode, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end AlgloopDefaultImplementationCode;

protected function fun_329
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "// Returns labels for a labeled DAE\n",
                                    "virtual label_list_type getLabels();\n",
                                    "//Sets all algebraic and state varibales for current time\n",
                                    "virtual void setVariables(const ublas::vector<double>& variables, const ublas::vector<double>& variables2);\n",
                                    "\n"
                                }, true));
      then txt;
  end match;
end fun_329;

public function generateMethodDeclarationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "     //Releases the Modelica System\n",
                                    "    virtual void destroy();\n",
                                    "    //provide number (dimension) of variables according to the index\n",
                                    "    virtual int getDimContinuousStates() const;\n",
                                    "      /// Provide number (dimension) of boolean variables\n",
                                    "    virtual int getDimBoolean() const;\n",
                                    "    /// Provide number (dimension) of integer variables\n",
                                    "    virtual int getDimInteger() const;\n",
                                    "    /// Provide number (dimension) of real variables\n",
                                    "    virtual int getDimReal() const ;\n",
                                    "    /// Provide number (dimension) of string variables\n",
                                    "    virtual int getDimString() const ;\n",
                                    "    //Provide number (dimension) of right hand sides (equations and/or residuals) according to the index\n",
                                    "    virtual int getDimRHS()const;\n",
                                    "      //Resets all time events\n",
                                    "\n",
                                    "\n",
                                    "    //Provide variables with given index to the system\n",
                                    "    virtual void getContinuousStates(double* z);\n",
                                    "    //Set variables with given index to the system\n",
                                    "    virtual void setContinuousStates(const double* z);\n",
                                    "    //Update transfer behavior of the system of equations according to command given by solver\n",
                                    "    virtual bool evaluate(const UPDATETYPE command =IContinuous::UNDEF_UPDATE);\n",
                                    "\n",
                                    "    //Provide the right hand side (according to the index)\n",
                                    "    virtual void getRHS(double* f);\n",
                                    "    //Output routine (to be called by the solver after every successful integration step)\n",
                                    "    virtual void writeOutput(const OUTPUT command = UNDEF_OUTPUT);\n",
                                    "\n",
                                    "    //Provide Jacobian\n",
                                    "    virtual void getJacobian(SparseMatrix& matrix);\n",
                                    "     //Provide number (dimension) of zero functions\n",
                                    "    virtual int getDimZeroFunc();\n",
                                    "    //Provides current values of root/zero functions\n",
                                    "     virtual void getZeroFunc(double* f);\n",
                                    "      virtual void setConditions(bool* c);\n",
                                    "    virtual void getConditions(bool* c);\n",
                                    "\n",
                                    "\n",
                                    "     //Called to handle all  events occured at same time\n",
                                    "    virtual bool handleSystemEvents( bool* events);\n",
                                    "    //Called to handle an event\n",
                                    "    virtual void handleEvent(const bool* events);\n",
                                    "    //Checks if a discrete variable has changed and triggers an event\n",
                                    "    virtual bool checkForDiscreteEvents();\n",
                                    "    virtual bool isStepEvent();\n",
                                    "     //Saves all variables before an event is handled, is needed for the pre, edge and change operator\n",
                                    "    virtual void saveAll();\n",
                                    "    virtual void saveDiscreteVars();\n",
                                    "    // M is regular\n",
                                    "    virtual bool isODE();\n",
                                    "    // M is singular\n",
                                    "    virtual bool isAlgebraic();\n",
                                    "\n",
                                    "\n",
                                    "    virtual int getDimTimeEvent() const;\n",
                                    "    //gibt die Time events (Startzeit und Frequenz) zurück\n",
                                    "    virtual void getTimeEvent(time_event_type& time_events);\n",
                                    "    //Wird vom Solver zur Behandlung der Time events aufgerufen (wenn zero_sign[i] = 0  kein time event,zero_sign[i] = n  Anzahl von vorgekommen time events )\n",
                                    "    virtual void handleTimeEvent(int* time_events);\n",
                                    "    /// Set current integration time\n",
                                    "    virtual void setTime(const double& time);\n",
                                    "\n",
                                    "    // System is able to provide the Jacobian symbolically\n",
                                    "    virtual bool provideSymbolicJacobian();\n",
                                    "    virtual bool initial();\n",
                                    "    virtual void setInitial(bool);\n",
                                    "    /// (Re-) initialize the system of equations and bounded parameters\n",
                                    "    virtual void initialize();\n",
                                    " // Returns the history object to query simulation results\n",
                                    "   virtual IHistory* getHistory();\n",
                                    "   virtual void stepCompleted(double time);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_329(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "bool getReal(int handle, double& value);\n",
                                    "bool getInteger(int handle, int& value);\n",
                                    "bool getBoolean(int handle, bool& value);\n",
                                    "\n",
                                    "bool setReal(int handle, double& value);\n",
                                    "bool setInteger(int handle, int& value);\n",
                                    "bool setBoolean(int handle, bool& value);\n",
                                    "\n",
                                    "\n",
                                    " /// Provide boolean variables\n",
                                    "virtual void getBoolean(bool* z);\n",
                                    "/// Provide integer variables\n",
                                    "virtual void getInteger(int* z);\n",
                                    "/// Provide real variables\n",
                                    "virtual void getReal(double* z);\n",
                                    "/// Provide real variables\n",
                                    "virtual void getString(std::string* z);\n",
                                    "/// Provide boolean variables\n",
                                    "virtual void setBoolean(const bool* z);\n",
                                    "/// Provide integer variables\n",
                                    "virtual void setInteger(const int* z);\n",
                                    "/// Provide real variables\n",
                                    "virtual void setReal(const double* z);\n",
                                    "/// Provide real variables\n",
                                    "virtual void setString(const std::string* z);\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end generateMethodDeclarationCode;

protected function fun_331
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/// Provide dimensions of residuals for linear equation systems\n",
                                    "virtual int giveDimResiduals(int index);\n",
                                    "/// Provide the residuals for linear equation systems\n",
                                    "virtual void giveResiduals(double* vars);"
                                }, false));
      then txt;
  end match;
end fun_331;

public function generateAlgloopMethodDeclarationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    /// Provide number (dimension) of variables according to data type\n",
                                    "    virtual int getDimReal() const    ;\n",
                                    "    /// Provide number (dimension) of residuals according to data type\n",
                                    "    virtual int getDimRHS() const    ;\n",
                                    "     /// (Re-) initialize the system of equations\n",
                                    "    virtual void initialize();\n",
                                    "    /// Provide variables with given index to the system\n",
                                    "    virtual void getReal(double* vars)    ;\n",
                                    "    /// Set variables with given index to the system\n",
                                    "    virtual void setReal(const double* vars)    ;\n",
                                    "    /// Update transfer behavior of the system of equations according to command given by solver\n",
                                    "    virtual void evaluate(const  IContinuous::UPDATETYPE command =IContinuous::UNDEF_UPDATE);\n",
                                    "    /// Provide the right hand side (according to the index)\n",
                                    "    virtual void getRHS(double* vars);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_331(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/// Output routine (to be called by the solver after every successful integration step)\n",
                                    "virtual void getSystemMatrix(double* A_matrix);\n",
                                    "virtual bool isLinear();\n",
                                    "/// Set stream for output\n",
                                    "virtual void setOutput(ostream* outputStream)     ;\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end generateAlgloopMethodDeclarationCode;

protected function lm_333
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine2(txt, i_var, "algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_333(txt, rest);
      then txt;
  end match;
end lm_333;

protected function lm_334
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine2(txt, i_var, "parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_334(txt, rest);
      then txt;
  end match;
end lm_334;

protected function lm_335
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine2(txt, i_var, "aliasVars");
        txt = Tpl.nextIter(txt);
        txt = lm_335(txt, rest);
      then txt;
  end match;
end lm_335;

protected function lm_336
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "int", i_var, "intVariables.algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_336(txt, rest);
      then txt;
  end match;
end lm_336;

protected function lm_337
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "int", i_var, "intVariables.parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_337(txt, rest);
      then txt;
  end match;
end lm_337;

protected function lm_338
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "int", i_var, "intVariables.AliasVars");
        txt = Tpl.nextIter(txt);
        txt = lm_338(txt, rest);
      then txt;
  end match;
end lm_338;

protected function lm_339
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "bool", i_var, "boolVariables.algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_339(txt, rest);
      then txt;
  end match;
end lm_339;

protected function lm_340
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "bool", i_var, "boolVariables.parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_340(txt, rest);
      then txt;
  end match;
end lm_340;

protected function lm_341
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "bool ", i_var, "boolVariables.AliasVars");
        txt = Tpl.nextIter(txt);
        txt = lm_341(txt, rest);
      then txt;
  end match;
end lm_341;

protected function lm_342
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "string", i_var, "stringVariables.algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_342(txt, rest);
      then txt;
  end match;
end lm_342;

protected function lm_343
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "string", i_var, "stringVariables.parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_343(txt, rest);
      then txt;
  end match;
end lm_343;

protected function lm_344
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "string", i_var, "stringVariables.AliasVars");
        txt = Tpl.nextIter(txt);
        txt = lm_344(txt, rest);
      then txt;
  end match;
end lm_344;

protected function lm_345
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine2(txt, i_var, "constvariables");
        txt = Tpl.nextIter(txt);
        txt = lm_345(txt, rest);
      then txt;
  end match;
end lm_345;

protected function lm_346
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "const int", i_var, "intConstvariables");
        txt = Tpl.nextIter(txt);
        txt = lm_346(txt, rest);
      then txt;
  end match;
end lm_346;

protected function lm_347
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "const bool", i_var, "boolConstvariables");
        txt = Tpl.nextIter(txt);
        txt = lm_347(txt, rest);
      then txt;
  end match;
end lm_347;

protected function lm_348
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefine(txt, "const string", i_var, "stringConstvariables");
        txt = Tpl.nextIter(txt);
        txt = lm_348(txt, rest);
      then txt;
  end match;
end lm_348;

protected function lm_349
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = VariableAliasDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_349(txt, rest);
      then txt;
  end match;
end lm_349;

protected function lm_350
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = VariableAliasDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_350(txt, rest);
      then txt;
  end match;
end lm_350;

public function MemberVariable
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars, stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars)) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_333(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_334(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_335(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_336(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_337(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_338(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_339(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_340(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_341(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_342(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_343(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_344(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_345(txt, i_vars_constVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_346(txt, i_vars_intConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_347(txt, i_vars_boolConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_348(txt, i_vars_stringConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_349(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_350(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end MemberVariable;

public function VariableAliasDefinition
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      Integer i_index;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(varKind = BackendDAE.STATE(index = _), name = i_name, index = i_index) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" __z["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(varKind = BackendDAE.STATE_DER(), name = i_name, index = i_index) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" __zDot["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end VariableAliasDefinition;

protected function lm_353
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "algebraics", "");
        txt = Tpl.nextIter(txt);
        txt = lm_353(txt, rest);
      then txt;
  end match;
end lm_353;

protected function fun_354
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_algVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_algVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_354;

protected function lm_355
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "parameters", "");
        txt = Tpl.nextIter(txt);
        txt = lm_355(txt, rest);
      then txt;
  end match;
end lm_355;

protected function fun_356
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_356;

protected function lm_357
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "aliasVars", "");
        txt = Tpl.nextIter(txt);
        txt = lm_357(txt, rest);
      then txt;
  end match;
end lm_357;

protected function fun_358
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_aliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_aliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_358;

protected function lm_359
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.algebraics", "");
        txt = Tpl.nextIter(txt);
        txt = lm_359(txt, rest);
      then txt;
  end match;
end lm_359;

protected function fun_360
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_360;

protected function lm_361
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.parameters", "");
        txt = Tpl.nextIter(txt);
        txt = lm_361(txt, rest);
      then txt;
  end match;
end lm_361;

protected function fun_362
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_362;

protected function lm_363
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.AliasVars", "");
        txt = Tpl.nextIter(txt);
        txt = lm_363(txt, rest);
      then txt;
  end match;
end lm_363;

protected function fun_364
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_364;

protected function lm_365
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "bool", i_var, "boolVariables.algebraics", "");
        txt = Tpl.nextIter(txt);
        txt = lm_365(txt, rest);
      then txt;
  end match;
end lm_365;

protected function fun_366
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_366;

protected function lm_367
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "bool", i_var, "boolVariables.parameters", "");
        txt = Tpl.nextIter(txt);
        txt = lm_367(txt, rest);
      then txt;
  end match;
end lm_367;

protected function fun_368
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_368;

protected function lm_369
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "bool ", i_var, "boolVariables.AliasVars", "");
        txt = Tpl.nextIter(txt);
        txt = lm_369(txt, rest);
      then txt;
  end match;
end lm_369;

protected function fun_370
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_370;

protected function lm_371
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.algebraics", "");
        txt = Tpl.nextIter(txt);
        txt = lm_371(txt, rest);
      then txt;
  end match;
end lm_371;

protected function fun_372
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_372;

protected function lm_373
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.parameters", "");
        txt = Tpl.nextIter(txt);
        txt = lm_373(txt, rest);
      then txt;
  end match;
end lm_373;

protected function fun_374
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_374;

protected function lm_375
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.AliasVars", "");
        txt = Tpl.nextIter(txt);
        txt = lm_375(txt, rest);
      then txt;
  end match;
end lm_375;

protected function fun_376
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_376;

protected function lm_377
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "constvariables", "");
        txt = Tpl.nextIter(txt);
        txt = lm_377(txt, rest);
      then txt;
  end match;
end lm_377;

protected function fun_378
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_constVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_constVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_378;

protected function lm_379
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "const int", i_var, "intConstvariables", "");
        txt = Tpl.nextIter(txt);
        txt = lm_379(txt, rest);
      then txt;
  end match;
end lm_379;

protected function fun_380
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_380;

protected function lm_381
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "const bool", i_var, "boolConstvariables", "");
        txt = Tpl.nextIter(txt);
        txt = lm_381(txt, rest);
      then txt;
  end match;
end lm_381;

protected function fun_382
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_382;

protected function lm_383
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "const string", i_var, "stringConstvariables", "");
        txt = Tpl.nextIter(txt);
        txt = lm_383(txt, rest);
      then txt;
  end match;
end lm_383;

protected function fun_384
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_384;

public function MemberVariableAlgloop
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_353(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = fun_354(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_355(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_356(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_357(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = fun_358(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_359(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = fun_360(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_361(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = fun_362(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_363(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = fun_364(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_365(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = fun_366(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_367(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = fun_368(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_369(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = fun_370(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_371(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = fun_372(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_373(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = fun_374(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_375(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = fun_376(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_377(txt, i_vars_constVars);
        txt = Tpl.popIter(txt);
        txt = fun_378(txt, i_vars_constVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_379(txt, i_vars_intConstVars);
        txt = Tpl.popIter(txt);
        txt = fun_380(txt, i_vars_intConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_381(txt, i_vars_boolConstVars);
        txt = Tpl.popIter(txt);
        txt = fun_382(txt, i_vars_boolConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_383(txt, i_vars_stringConstVars);
        txt = Tpl.popIter(txt);
        txt = fun_384(txt, i_vars_stringConstVars);
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end MemberVariableAlgloop;

protected function lm_386
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "algebraics", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_386(txt, rest);
      then txt;
  end match;
end lm_386;

protected function fun_387
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_algVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_algVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_387;

protected function lm_388
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "parameters", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_388(txt, rest);
      then txt;
  end match;
end lm_388;

protected function fun_389
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_389;

protected function lm_390
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "aliasVars", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_390(txt, rest);
      then txt;
  end match;
end lm_390;

protected function fun_391
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_aliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_aliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_391;

protected function lm_392
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.algebraics", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_392(txt, rest);
      then txt;
  end match;
end lm_392;

protected function fun_393
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_393;

protected function lm_394
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.parameters", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_394(txt, rest);
      then txt;
  end match;
end lm_394;

protected function fun_395
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_395;

protected function lm_396
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.AliasVars", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_396(txt, rest);
      then txt;
  end match;
end lm_396;

protected function fun_397
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_397;

protected function lm_398
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "bool", i_var, "boolVariables.algebraics", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_398(txt, rest);
      then txt;
  end match;
end lm_398;

protected function fun_399
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_399;

protected function lm_400
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "bool", i_var, "boolVariables.parameters", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_400(txt, rest);
      then txt;
  end match;
end lm_400;

protected function fun_401
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_401;

protected function lm_402
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "bool ", i_var, "boolVariables.AliasVars", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_402(txt, rest);
      then txt;
  end match;
end lm_402;

protected function fun_403
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_403;

protected function lm_404
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.algebraics", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_404(txt, rest);
      then txt;
  end match;
end lm_404;

protected function fun_405
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_405;

protected function lm_406
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.parameters", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_406(txt, rest);
      then txt;
  end match;
end lm_406;

protected function fun_407
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_407;

protected function lm_408
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.AliasVars", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_408(txt, rest);
      then txt;
  end match;
end lm_408;

protected function fun_409
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_409;

protected function lm_410
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "constvariables", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_410(txt, rest);
      then txt;
  end match;
end lm_410;

protected function fun_411
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_constVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_constVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_411;

protected function lm_412
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "const int", i_var, "intConstvariables", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_412(txt, rest);
      then txt;
  end match;
end lm_412;

protected function fun_413
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_413;

protected function lm_414
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "const bool", i_var, "boolConstvariables", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_414(txt, rest);
      then txt;
  end match;
end lm_414;

protected function fun_415
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_415;

protected function lm_416
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = MemberVariableDefineReference(txt, "const string", i_var, "stringConstvariables", "_");
        txt = Tpl.nextIter(txt);
        txt = lm_416(txt, rest);
      then txt;
  end match;
end lm_416;

protected function fun_417
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_417;

public function ConstructorParamAlgloop
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_386(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = fun_387(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_388(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = fun_389(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_390(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = fun_391(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_392(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_393(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_394(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_395(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_396(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = fun_397(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_398(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = fun_399(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_400(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = fun_401(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_402(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = fun_403(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_404(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = fun_405(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_406(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = fun_407(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_408(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = fun_409(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_410(txt, i_vars_constVars);
        txt = Tpl.popIter(txt);
        txt = fun_411(txt, i_vars_constVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_412(txt, i_vars_intConstVars);
        txt = Tpl.popIter(txt);
        txt = fun_413(txt, i_vars_intConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_414(txt, i_vars_boolConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_415(txt, i_vars_boolConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_416(txt, i_vars_stringConstVars);
        txt = Tpl.popIter(txt);
        txt = fun_417(txt, i_vars_stringConstVars);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ConstructorParamAlgloop;

protected function lm_419
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_419(txt, rest);
      then txt;
  end match;
end lm_419;

protected function fun_420
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_algVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_algVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_420;

protected function lm_421
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_421(txt, rest);
      then txt;
  end match;
end lm_421;

protected function fun_422
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_422;

protected function lm_423
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_423(txt, rest);
      then txt;
  end match;
end lm_423;

protected function fun_424
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_aliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_aliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_424;

protected function lm_425
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_425(txt, rest);
      then txt;
  end match;
end lm_425;

protected function fun_426
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_426;

protected function lm_427
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_427(txt, rest);
      then txt;
  end match;
end lm_427;

protected function fun_428
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_428;

protected function lm_429
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_429(txt, rest);
      then txt;
  end match;
end lm_429;

protected function fun_430
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_430;

protected function lm_431
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_431(txt, rest);
      then txt;
  end match;
end lm_431;

protected function fun_432
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_432;

protected function lm_433
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_433(txt, rest);
      then txt;
  end match;
end lm_433;

protected function fun_434
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_434;

protected function lm_435
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_435(txt, rest);
      then txt;
  end match;
end lm_435;

protected function fun_436
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_436;

protected function lm_437
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_437(txt, rest);
      then txt;
  end match;
end lm_437;

protected function fun_438
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_438;

protected function lm_439
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_439(txt, rest);
      then txt;
  end match;
end lm_439;

protected function fun_440
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_440;

protected function lm_441
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_441(txt, rest);
      then txt;
  end match;
end lm_441;

protected function fun_442
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_442;

protected function lm_443
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_443(txt, rest);
      then txt;
  end match;
end lm_443;

protected function fun_444
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_constVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_constVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_444;

protected function lm_445
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_445(txt, rest);
      then txt;
  end match;
end lm_445;

protected function fun_446
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_446;

protected function lm_447
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_447(txt, rest);
      then txt;
  end match;
end lm_447;

protected function fun_448
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_448;

protected function lm_449
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = CallAlgloopParam(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_449(txt, rest);
      then txt;
  end match;
end lm_449;

protected function fun_450
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_450;

public function CallAlgloopParams
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_419(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_420(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_421(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_422(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_423(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = fun_424(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_425(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = fun_426(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_427(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = fun_428(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_429(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = fun_430(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_431(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = fun_432(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_433(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = fun_434(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_435(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_436(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_437(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = fun_438(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_439(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = fun_440(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_441(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = fun_442(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_443(txt, i_vars_constVars);
        txt = Tpl.popIter(txt);
        txt = fun_444(txt, i_vars_constVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_445(txt, i_vars_intConstVars);
        txt = Tpl.popIter(txt);
        txt = fun_446(txt, i_vars_intConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_447(txt, i_vars_boolConstVars);
        txt = Tpl.popIter(txt);
        txt = fun_448(txt, i_vars_boolConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_449(txt, i_vars_stringConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_450(txt, i_vars_stringConstVars);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end CallAlgloopParams;

protected function lm_452
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "algebraics", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_452(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_452;

protected function fun_453
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_algVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_algVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_453;

protected function lm_454
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "parameters", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_454(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_454;

protected function fun_455
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_455;

protected function lm_456
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "aliasVars", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_456(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_456;

protected function fun_457
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_aliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_aliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_457;

protected function lm_458
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "intVariables.algebraics", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_458(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_458;

protected function fun_459
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_459;

protected function lm_460
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "intVariables.parameters", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_460(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_460;

protected function fun_461
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_461;

protected function lm_462
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "intVariables.AliasVars", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_462(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_462;

protected function fun_463
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_463;

protected function lm_464
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "boolVariables.algebraics", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_464(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_464;

protected function fun_465
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_465;

protected function lm_466
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "boolVariables.parameters", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_466(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_466;

protected function fun_467
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_467;

protected function lm_468
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "boolVariables.AliasVars", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_468(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_468;

protected function fun_469
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_469;

protected function fun_470
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_470;

protected function lm_471
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "stringVariables.algebraics", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_471(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_471;

protected function fun_472
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_472;

protected function lm_473
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "stringVariables.parameters", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_473(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_473;

protected function fun_474
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_474;

protected function lm_475
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "stringVariables.AliasVars", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_475(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_475;

protected function fun_476
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_476;

protected function lm_477
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "constvariables", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_477(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_477;

protected function fun_478
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_constVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_constVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_478;

protected function lm_479
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "intConstvariables", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_479(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_479;

protected function fun_480
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_intConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_480;

protected function lm_481
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "boolConstvariables", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_481(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_481;

protected function fun_482
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_boolConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_482;

protected function lm_483
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_arrayInit;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "stringConstvariables", a_arrayInit);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_483(txt, rest, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_483;

protected function fun_484
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_vars_stringConstVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringConstVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_484;

public function InitAlgloopParams
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_a_modelInfo, in_a_arrayInit)
    local
      Tpl.Text txt;
      Tpl.Text a_arrayInit;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)),
           a_arrayInit )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  /* vars.algVars */\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_452(txt, i_vars_algVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_453(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* vars.paramVars */\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_454(txt, i_vars_paramVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_455(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.aliasVars */\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_456(txt, i_vars_aliasVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_457(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* vars.intAlgVars */\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_458(txt, i_vars_intAlgVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_459(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.intParamVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_460(txt, i_vars_intParamVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_461(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.intAliasVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_462(txt, i_vars_intAliasVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_463(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.boolAlgVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_464(txt, i_vars_boolAlgVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_465(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.boolParamVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_466(txt, i_vars_boolParamVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_467(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.boolAliasVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_468(txt, i_vars_boolAliasVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_469(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.stringAlgVars */\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = fun_470(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_471(txt, i_vars_stringAlgVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_472(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.stringParamVars */\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_473(txt, i_vars_stringParamVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_474(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* vars.stringAliasVars */\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_475(txt, i_vars_stringAliasVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_476(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.constVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_477(txt, i_vars_constVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_478(txt, i_vars_constVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.intConstVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_479(txt, i_vars_intConstVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_480(txt, i_vars_intConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.boolConstVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_481(txt, i_vars_boolConstVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_482(txt, i_vars_boolConstVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.stringConstVars */\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_483(txt, i_vars_stringConstVars, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_484(txt, i_vars_stringConstVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_arrayInit);

    case ( txt,
           _,
           a_arrayInit )
      then (txt, a_arrayInit);
  end match;
end InitAlgloopParams;

protected function fun_486
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName, in_a_varType)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      Tpl.Text a_varType;

    case ( txt,
           "0",
           a_varName,
           a_varType )
      equation
        txt = Tpl.writeText(txt, a_varType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_486;

protected function fun_487
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_type)
    local
      Tpl.Text txt;
      String a_type;
      list<String> i_numArrayElement;
      DAE.Type i_type__;
      DAE.ComponentRef i_name;
      String str_5;
      Tpl.Text l_varType;
      Tpl.Text l_varName;
      Tpl.Text l_dims;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, name = i_name),
           a_type )
      equation
        txt = Tpl.writeStr(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = i_numArrayElement, type_ = i_type__),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_numArrayElement);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = i_numArrayElement, type_ = i_type__),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_1 = listLength(i_numArrayElement);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = _ :: _, name = i_name, type_ = i_type__),
           _ )
      equation
        l_dims = Tpl.emptyTxt;
        (l_varName, l_dims) = arraycref2(Tpl.emptyTxt, i_name, l_dims);
        l_varType = variableType(Tpl.emptyTxt, i_type__);
        str_5 = Tpl.textString(l_dims);
        txt = fun_486(txt, str_5, l_varName, l_varType);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_487;

public function MemberVariableDefine
  input Tpl.Text txt;
  input String a_type;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_487(txt, a_simVar, a_type);
end MemberVariableDefine;

protected function fun_489
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;
  input String in_a_pre;
  input Tpl.Text in_a_varType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName, in_a_pre, in_a_varType)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      String a_pre;
      Tpl.Text a_varType;

    case ( txt,
           "0",
           a_varName,
           a_pre,
           a_varType )
      equation
        txt = Tpl.writeText(txt, a_varType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_489;

protected function fun_490
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_type;
  input String in_a_pre;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_type, in_a_pre)
    local
      Tpl.Text txt;
      String a_type;
      String a_pre;
      list<String> i_num;
      DAE.Type i_type__;
      DAE.ComponentRef i_name;
      String str_5;
      Tpl.Text l_varType;
      Tpl.Text l_varName;
      Tpl.Text l_dims;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, name = i_name),
           a_type,
           a_pre )
      equation
        txt = Tpl.writeStr(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = cref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = i_num, type_ = i_type__),
           _,
           a_pre )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_num);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = arraycref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = i_num, type_ = i_type__),
           _,
           a_pre )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_1 = listLength(i_num);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = arraycref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = _ :: _, name = i_name, type_ = i_type__),
           _,
           a_pre )
      equation
        l_dims = Tpl.emptyTxt;
        (l_varName, l_dims) = arraycref2(Tpl.emptyTxt, i_name, l_dims);
        l_varType = variableType(Tpl.emptyTxt, i_type__);
        str_5 = Tpl.textString(l_dims);
        txt = fun_489(txt, str_5, l_varName, a_pre, l_varType);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_490;

public function MemberVariableDefineReference
  input Tpl.Text txt;
  input String a_type;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;
  input String a_pre;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_490(txt, a_simVar, a_type, a_pre);
end MemberVariableDefineReference;

protected function fun_492
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName, in_a_varType)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      Tpl.Text a_varType;

    case ( txt,
           "0",
           a_varName,
           a_varType )
      equation
        txt = Tpl.writeText(txt, a_varType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           a_varName,
           a_varType )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
        txt = Tpl.writeText(txt, a_varType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; */"));
      then txt;
  end match;
end fun_492;

protected function fun_493
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      DAE.Type i_type__;
      String str_4;
      Tpl.Text l_varType;
      Tpl.Text l_varName;
      Tpl.Text l_arrayName;
      Tpl.Text l_dims;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, type_ = i_type__, name = i_name) )
      equation
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = _, type_ = i_type__) )
      equation
        l_dims = Tpl.emptyTxt;
        (l_arrayName, l_dims) = arraycref2(Tpl.emptyTxt, i_name, l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">  "));
        txt = Tpl.writeText(txt, l_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = _, type_ = i_type__) )
      equation
        l_dims = Tpl.emptyTxt;
        (l_arrayName, l_dims) = arraycref2(Tpl.emptyTxt, i_name, l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = Tpl.writeText(txt, l_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = _ :: _, name = i_name, type_ = i_type__) )
      equation
        l_dims = Tpl.emptyTxt;
        (l_varName, l_dims) = arraycref2(Tpl.emptyTxt, i_name, l_dims);
        l_varType = variableType(Tpl.emptyTxt, i_type__);
        str_4 = Tpl.textString(l_dims);
        txt = fun_492(txt, str_4, l_varName, l_varType);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_493;

public function MemberVariableDefine2
  input Tpl.Text txt;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_493(txt, a_simVar);
end MemberVariableDefine2;

protected function fun_495
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;

    case ( txt,
           "0",
           a_varName )
      equation
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(_"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_495;

protected function fun_496
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      String str_2;
      Tpl.Text l_varName;
      Tpl.Text l_dims;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, name = i_name) )
      equation
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(_"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = _) )
      equation
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(_"));
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = _) )
      equation
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("( _"));
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = _ :: _, name = i_name) )
      equation
        l_dims = Tpl.emptyTxt;
        (l_varName, l_dims) = arraycref2(Tpl.emptyTxt, i_name, l_dims);
        str_2 = Tpl.textString(l_dims);
        txt = fun_495(txt, str_2, l_varName);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_496;

public function InitAlgloopParam
  input Tpl.Text txt;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;
  input Tpl.Text a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  out_txt := fun_496(txt, a_simVar);
  out_a_arrayInit := a_arrayInit;
end InitAlgloopParam;

protected function fun_498
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;

    case ( txt,
           "0",
           a_varName )
      equation
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_498;

public function CallAlgloopParam
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      String str_2;
      Tpl.Text l_varName;
      Tpl.Text l_dims;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, name = i_name) )
      equation
        txt = cref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = _) )
      equation
        txt = arraycref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = _) )
      equation
        txt = arraycref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = _ :: _, name = i_name) )
      equation
        l_dims = Tpl.emptyTxt;
        (l_varName, l_dims) = arraycref2(Tpl.emptyTxt, i_name, l_dims);
        str_2 = Tpl.textString(l_dims);
        txt = fun_498(txt, str_2, l_varName);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end CallAlgloopParam;

protected function fun_500
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;
  input String in_a_pre;
  input Tpl.Text in_a_varType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName, in_a_pre, in_a_varType)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      String a_pre;
      Tpl.Text a_varType;

    case ( txt,
           "0",
           a_varName,
           a_pre,
           a_varType )
      equation
        txt = Tpl.writeText(txt, a_varType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_500;

protected function fun_501
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_pre;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_pre)
    local
      Tpl.Text txt;
      String a_pre;
      list<String> i_num;
      DAE.ComponentRef i_name;
      DAE.Type i_type__;
      String str_5;
      Tpl.Text l_varType;
      Tpl.Text l_varName;
      Tpl.Text l_dims;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}, type_ = i_type__, name = i_name),
           a_pre )
      equation
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = cref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = i_num, type_ = i_type__),
           a_pre )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_num);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = arraycref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = i_num, type_ = i_type__),
           a_pre )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_1 = listLength(i_num);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">& "));
        txt = Tpl.writeStr(txt, a_pre);
        txt = arraycref(txt, i_name);
      then txt;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = _ :: _, name = i_name, type_ = i_type__),
           a_pre )
      equation
        l_dims = Tpl.emptyTxt;
        (l_varName, l_dims) = arraycref2(Tpl.emptyTxt, i_name, l_dims);
        l_varType = variableType(Tpl.emptyTxt, i_type__);
        str_5 = Tpl.textString(l_dims);
        txt = fun_500(txt, str_5, l_varName, a_pre, l_varType);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_501;

public function MemberVariableDefineReference2
  input Tpl.Text txt;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;
  input String a_pre;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_501(txt, a_simVar, a_pre);
end MemberVariableDefineReference2;

public function arrayConstruct
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stringAlgVars = i_vars_stringAlgVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)) )
      equation
        txt = arrayConstruct1(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_constVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_intConstVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_boolConstVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayConstruct1(txt, i_vars_stringConstVars);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end arrayConstruct;

protected function lm_504
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      list<String> i_v_numArrayElement;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(arrayCref = SOME(_), name = i_name, numArrayElement = i_v_numArrayElement) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(boost::extents"));
        txt = boostextentDims(txt, i_name, i_v_numArrayElement);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.nextIter(txt);
        txt = lm_504(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_504(txt, rest);
      then txt;
  end match;
end lm_504;

public function arrayConstruct1
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_504(out_txt, a_varsLst);
  out_txt := Tpl.popIter(out_txt);
end arrayConstruct1;

public function variableType
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end variableType;

public function lastIdentOfPath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_modelName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelName)
    local
      Tpl.Text txt;
      String i_name;
      Absyn.Path i_path;

    case ( txt,
           Absyn.QUALIFIED(path = i_path) )
      equation
        txt = lastIdentOfPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = lastIdentOfPath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end lastIdentOfPath;

public function cref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_simTime"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefToCStr(txt, i_cr);
      then txt;
  end match;
end cref;

public function localcref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_simTime"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = crefToCStr(txt, i_cr);
      then txt;
  end match;
end localcref;

public function cref2
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefToCStr(txt, i_cr);
      then txt;
  end match;
end cref2;

public function crefToCStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsToCStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsToCStrForArray(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_P_"));
        txt = crefToCStr(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefToCStr;

protected function lm_512
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptToCStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_512(txt, rest);
      then txt;
  end match;
end lm_512;

public function subscriptsToCStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_512(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end subscriptsToCStr;

public function subscriptToCStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end match;
end subscriptToCStr;

public function arraycref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefToCStr1(txt, i_cr);
      then txt;
  end match;
end arraycref;

public function arraycref2
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_dims;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_dims;
algorithm
  (out_txt, out_a_dims) :=
  match(in_txt, in_a_cr, in_a_dims)
    local
      Tpl.Text txt;
      Tpl.Text a_dims;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")),
           a_dims )
      equation
        txt = crefStr(txt, i_cr);
      then (txt, a_dims);

    case ( txt,
           DAE.CREF_IDENT(ident = "time"),
           a_dims )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then (txt, a_dims);

    case ( txt,
           DAE.WILD(),
           a_dims )
      then (txt, a_dims);

    case ( txt,
           i_cr,
           a_dims )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        (txt, a_dims) = crefToCStrForArray(txt, i_cr, a_dims);
      then (txt, a_dims);
  end match;
end arraycref2;

protected function lm_517
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_517(txt, rest);
      then txt;
  end match;
end lm_517;

public function boostextentDims
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input list<String> in_a_arraydims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr, in_a_arraydims)
    local
      Tpl.Text txt;
      list<String> a_arraydims;
      DAE.ComponentRef i_c;
      list<DAE.Subscript> i_dims;
      list<String> ret_1;
      Integer ret_0;

    case ( txt,
           DAE.CREF_IDENT(subscriptLst = i_dims),
           a_arraydims )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = listLength(i_dims);
        ret_1 = List.lastN(a_arraydims, ret_0);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_517(txt, ret_1);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(componentRef = i_c),
           a_arraydims )
      equation
        txt = boostextentDims(txt, i_c, a_arraydims);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end boostextentDims;

public function crefToCStrForArray
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_dims;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_dims;
algorithm
  (out_txt, out_a_dims) :=
  match(in_txt, in_a_cr, in_a_dims)
    local
      Tpl.Text txt;
      Tpl.Text a_dims;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      list<DAE.Subscript> i_subscriptLst;
      Integer ret_0;

    case ( txt,
           DAE.CREF_IDENT(subscriptLst = i_subscriptLst, ident = i_ident),
           a_dims )
      equation
        ret_0 = listLength(i_subscriptLst);
        a_dims = Tpl.writeStr(a_dims, intString(ret_0));
        txt = Tpl.writeStr(txt, i_ident);
      then (txt, a_dims);

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef),
           a_dims )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsToCStrForArray(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_P_"));
        (txt, a_dims) = crefToCStrForArray(txt, i_componentRef, a_dims);
      then (txt, a_dims);

    case ( txt,
           DAE.WILD(),
           a_dims )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_dims);

    case ( txt,
           _,
           a_dims )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then (txt, a_dims);
  end match;
end crefToCStrForArray;

public function crefToCStr1
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsToCStrForArray(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_P_"));
        txt = crefToCStr1(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.WILD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefToCStr1;

protected function lm_521
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptToCStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_521(txt, rest);
      then txt;
  end match;
end lm_521;

public function subscriptsToCStrForArray
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("$c")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_521(txt, i_subscripts);
        txt = Tpl.popIter(txt);
      then txt;
  end match;
end subscriptsToCStrForArray;

public function crefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      list<DAE.Subscript> i_subscriptLst;

    case ( txt,
           DAE.CREF_IDENT(ident = "xloc", subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__xd"));
        txt = subscriptsStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der("));
        txt = crefStr(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefStr;

protected function lm_524
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_524(txt, rest);
      then txt;
  end match;
end lm_524;

public function subscriptsStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_524(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end subscriptsStr;

public function subscriptStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end match;
end subscriptStr;

public function simulationInitFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      SimCode.SimCode i_simCode;
      list<SimCode.SimVar> i_vars_constVars;
      SimCode.ModelInfo i_modelInfo;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = _), vars = SimCode.SIMVARS(constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars))))) )
      equation
        txt = arrayConstruct(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = initconstVals(txt, i_vars_constVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initconstVals(txt, i_vars_intConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initconstVals(txt, i_vars_boolConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initconstVals(txt, i_vars_stringConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initconstVals(txt, i_vars_paramVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initconstVals(txt, i_vars_intParamVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initconstVals(txt, i_vars_boolParamVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initconstVals(txt, i_vars_stringParamVars, i_simCode);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationInitFile;

protected function lm_528
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_var as SimCode.SIMVAR(name = _)) :: rest,
           a_simCode )
      equation
        txt = initconstValue(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_528(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_528(txt, rest, a_simCode);
      then txt;
  end match;
end lm_528;

public function initconstVals
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_528(out_txt, a_varsLst, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end initconstVals;

protected function fun_530
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(\"\")"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(0)"));
      then txt;
  end match;
end fun_530;

protected function fun_531
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input DAE.Type in_a_type;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_type, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.Type a_type;
      SimCode.SimCode a_simCode;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v),
           _,
           a_simCode )
      equation
        txt = initconstValue2(txt, i_v, a_simCode);
      then txt;

    case ( txt,
           _,
           a_type,
           _ )
      equation
        txt = fun_530(txt, a_type);
      then txt;
  end match;
end fun_531;

public function initconstValue
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.Type i_type;
      Option<DAE.Exp> i_initialValue;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = _ :: _),
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type, name = i_name, initialValue = i_initialValue),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = fun_531(txt, i_initialValue, i_type, a_simCode);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end initconstValue;

protected function fun_533
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      String i_vStr;

    case ( txt,
           (i_vStr as "0") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           (i_vStr as "0.0") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           (i_vStr as "(0)") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           (i_vStr as "") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           i_vStr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_533;

public function initconstValue2
  input Tpl.Text in_txt;
  input DAE.Exp in_a_initialValue;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.Exp i_v;
      String str_3;
      Tpl.Text txt_2;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;

    case ( txt,
           i_v,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        (txt_2, l_preExp, l_varDecls) = daeExp(Tpl.emptyTxt, i_v, SimCode.contextOther, l_preExp, l_varDecls, a_simCode);
        str_3 = Tpl.textString(txt_2);
        txt = fun_533(txt, str_3);
      then txt;
  end match;
end initconstValue2;

public function initializeArrayElements
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      SimCode.SimCode i_simCode;
      list<SimCode.SimVar> i_vars_constVars;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = _), vars = SimCode.SIMVARS(constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars)))) )
      equation
        txt = initValsArray(txt, i_vars_constVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValsArray(txt, i_vars_intConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValsArray(txt, i_vars_boolConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValsArray(txt, i_vars_stringConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValsArray(txt, i_vars_paramVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValsArray(txt, i_vars_intParamVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValsArray(txt, i_vars_boolParamVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initValsArray(txt, i_vars_stringParamVars, i_simCode);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end initializeArrayElements;

protected function lm_536
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.Exp i_v;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = _ :: _, initialValue = SOME(i_v), name = i_name) :: rest )
      equation
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = initVal(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_536(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_536(txt, rest);
      then txt;
  end match;
end lm_536;

public function initValsArray
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_536(out_txt, a_varsLst);
  out_txt := Tpl.popIter(out_txt);
end initValsArray;

public function arrayInit
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      SimCode.SimCode i_simCode;
      list<SimCode.SimVar> i_vars_paramVars;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = _), vars = SimCode.SIMVARS(paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)))) )
      equation
        txt = initVals1(txt, i_vars_paramVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_intParamVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_boolParamVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_stringParamVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_constVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_intConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_boolConstVars, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals1(txt, i_vars_stringConstVars, i_simCode);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end arrayInit;

protected function lm_539
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_var as SimCode.SIMVAR(name = _)) :: rest,
           a_simCode )
      equation
        txt = initVals2(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_539(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_539(txt, rest, a_simCode);
      then txt;
  end match;
end lm_539;

public function initVals1
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_539(out_txt, a_varsLst, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end initVals1;

protected function fun_541
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v) )
      equation
        txt = initVal(txt, i_v);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;
  end match;
end fun_541;

protected function fun_542
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      Option<DAE.Exp> i_initialValue;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(numArrayElement = {}) )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name, initialValue = i_initialValue) )
      equation
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = fun_541(txt, i_initialValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_542;

public function initVals2
  input Tpl.Text txt;
  input SimCode.SimVar a_var;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_542(txt, a_var);
end initVals2;

public function arrayReindex
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stringAlgVars = i_vars_stringAlgVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)) )
      equation
        txt = arrayReindex1(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_constVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_intConstVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_boolConstVars);
        txt = Tpl.softNewLine(txt);
        txt = arrayReindex1(txt, i_vars_stringConstVars);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end arrayReindex;

protected function lm_545
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(arrayCref = SOME(_), name = i_name) :: rest )
      equation
        txt = arraycref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".reindex(1);"));
        txt = Tpl.nextIter(txt);
        txt = lm_545(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_545(txt, rest);
      then txt;
  end match;
end lm_545;

public function arrayReindex1
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_545(out_txt, a_varsLst);
  out_txt := Tpl.popIter(out_txt);
end arrayReindex1;

protected function fun_547
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end match;
end fun_547;

public function initVal
  input Tpl.Text in_txt;
  input DAE.Exp in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      Absyn.Path i_name;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = Util.escapeModelicaStringToCString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_547(txt, i_bool);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index, name = i_name) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*ENUM:"));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*ERROR* initial value of unknown type"));
      then txt;
  end match;
end initVal;

public function dotPath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dotPath;

protected function lm_550
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_550(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_550(txt, rest);
      then txt;
  end match;
end lm_550;

protected function lm_551
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_551(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_551(txt, rest);
      then txt;
  end match;
end lm_551;

protected function lm_552
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_552(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_552(txt, rest);
      then txt;
  end match;
end lm_552;

protected function lm_553
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_553(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_553(txt, rest);
      then txt;
  end match;
end lm_553;

protected function lm_554
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_554(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_554(txt, rest);
      then txt;
  end match;
end lm_554;

protected function lm_555
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_555(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_555(txt, rest);
      then txt;
  end match;
end lm_555;

protected function lm_556
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_556(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_556(txt, rest);
      then txt;
  end match;
end lm_556;

protected function lm_557
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_557(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_557(txt, rest);
      then txt;
  end match;
end lm_557;

protected function lm_558
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_558(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_558(txt, rest);
      then txt;
  end match;
end lm_558;

protected function lm_559
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_559(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_559(txt, rest);
      then txt;
  end match;
end lm_559;

protected function smf_560
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_560;

protected function smf_561
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_561;

protected function smf_562
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_562;

protected function smf_563
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_563;

protected function smf_564
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_564;

protected function smf_565
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_565;

protected function smf_566
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_566;

protected function smf_567
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_567;

protected function smf_568
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_568;

protected function smf_569
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_569;

public function writeoutput1
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_outputVars;
      list<SimCode.SimVar> i_vars_inputVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, inputVars = i_vars_inputVars, outputVars = i_vars_outputVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars, stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt_0 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_0 = lm_550(txt_0, i_vars_algVars);
        txt_0 = Tpl.popIter(txt_0);
        txt_1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_1 = lm_551(txt_1, i_vars_intAlgVars);
        txt_1 = Tpl.popIter(txt_1);
        txt_2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_552(txt_2, i_vars_boolAlgVars);
        txt_2 = Tpl.popIter(txt_2);
        txt_3 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_3 = lm_553(txt_3, i_vars_inputVars);
        txt_3 = Tpl.popIter(txt_3);
        txt_4 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_4 = lm_554(txt_4, i_vars_outputVars);
        txt_4 = Tpl.popIter(txt_4);
        txt_5 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_5 = lm_555(txt_5, i_vars_aliasVars);
        txt_5 = Tpl.popIter(txt_5);
        txt_6 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_6 = lm_556(txt_6, i_vars_intAliasVars);
        txt_6 = Tpl.popIter(txt_6);
        txt_7 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_7 = lm_557(txt_7, i_vars_boolAliasVars);
        txt_7 = Tpl.popIter(txt_7);
        txt_8 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_8 = lm_558(txt_8, i_vars_stateVars);
        txt_8 = Tpl.popIter(txt_8);
        txt_9 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_9 = lm_559(txt_9, i_vars_derivativeVars);
        txt_9 = Tpl.popIter(txt_9);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_560(txt, txt_0);
        txt = smf_561(txt, txt_1);
        txt = smf_562(txt, txt_2);
        txt = smf_563(txt, txt_3);
        txt = smf_564(txt, txt_4);
        txt = smf_565(txt, txt_5);
        txt = smf_566(txt, txt_6);
        txt = smf_567(txt, txt_7);
        txt = smf_568(txt, txt_8);
        txt = smf_569(txt, txt_9);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end writeoutput1;

protected function lm_571
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqn :: rest )
      equation
        txt = numResidues2(txt, i_eqn);
        txt = Tpl.nextIter(txt);
        txt = lm_571(txt, rest);
      then txt;
  end match;
end lm_571;

public function numResidues
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("+")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_571(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
end numResidues;

protected function lm_573
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
        txt = Tpl.nextIter(txt);
        txt = lm_573(txt, rest);
      then txt;
  end match;
end lm_573;

protected function lm_574
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
        txt = Tpl.nextIter(txt);
        txt = lm_574(txt, rest);
      then txt;
  end match;
end lm_574;

public function numResidues2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem i_cont;
      list<SimCode.SimEqSystem> i_eqs;
      list<SimCode.SimVar> i_vars;

    case ( txt,
           SimCode.SES_RESIDUAL(index = _) )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(index = _) )
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(index = _) )
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("+")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_573(txt, i_vars);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(eqs = i_eqs) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("+")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_574(txt, i_eqs);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont) )
      equation
        txt = numResidues2(txt, i_cont);
      then txt;

    case ( txt,
           SimCode.SES_WHEN(index = _) )
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numResidues2;

public function numStatevars
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numStateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numStatevars;

public function numAlgvars
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numBoolAlgVars;
      Integer i_varInfo_numIntAlgVars;
      Integer i_varInfo_numAlgVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numAlgVars = i_varInfo_numAlgVars, numIntAlgVars = i_varInfo_numIntAlgVars, numBoolAlgVars = i_varInfo_numBoolAlgVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAlgVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numAlgvars;

public function numInOutvars
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numOutVars;
      Integer i_varInfo_numInVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numInVars = i_varInfo_numInVars, numOutVars = i_varInfo_numOutVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numInOutvars;

public function numAliasvars
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numBoolAliasVars;
      Integer i_varInfo_numIntAliasVars;
      Integer i_varInfo_numAlgAliasVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numAlgAliasVars = i_varInfo_numAlgAliasVars, numIntAliasVars = i_varInfo_numIntAliasVars, numBoolAliasVars = i_varInfo_numBoolAliasVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAliasVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numAliasvars;

public function numAlgvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numAlgVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numAlgVars = i_varInfo_numAlgVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numAlgvar;

public function numIntAlgvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numIntAlgVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numIntAlgVars = i_varInfo_numIntAlgVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAlgVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numIntAlgvar;

public function numBoolAlgvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numBoolAlgVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numBoolAlgVars = i_varInfo_numBoolAlgVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAlgVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numBoolAlgvar;

public function numInputvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numInVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numInVars = i_varInfo_numInVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numInputvar;

public function numOutputvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numOutVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numOutVars = i_varInfo_numOutVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numOutputvar;

public function numAliasvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numAlgAliasVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numAlgAliasVars = i_varInfo_numAlgAliasVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgAliasVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numAliasvar;

public function numIntAliasvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numIntAliasVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numIntAliasVars = i_varInfo_numIntAliasVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAliasVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numIntAliasvar;

public function numBoolAliasvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Integer i_varInfo_numBoolAliasVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numBoolAliasVars = i_varInfo_numBoolAliasVars)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAliasVars));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numBoolAliasvar;

protected function fun_588
  input Tpl.Text in_txt;
  input Option<Integer> in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer i_val;

    case ( txt,
           SOME(i_val) )
      equation
        txt = Tpl.writeStr(txt, intString(i_val));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_588;

protected function fun_589
  input Tpl.Text in_txt;
  input Option<Integer> in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer i_val;

    case ( txt,
           SOME(i_val) )
      equation
        txt = Tpl.writeStr(txt, intString(i_val));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_589;

public function numDerivativevars
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Option<Integer> i_varInfo_dimODE2ndOrder;
      Option<Integer> i_varInfo_dimODE1stOrder;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(dimODE1stOrder = i_varInfo_dimODE1stOrder, dimODE2ndOrder = i_varInfo_dimODE2ndOrder)) )
      equation
        txt = fun_588(txt, i_varInfo_dimODE1stOrder);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = fun_589(txt, i_varInfo_dimODE2ndOrder);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end numDerivativevars;

public function getAliasVar
  input Tpl.Text in_txt;
  input SimCode.AliasVariable in_a_aliasvar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_aliasvar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_varName;

    case ( txt,
           SimCode.NOALIAS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("noAlias"));
      then txt;

    case ( txt,
           SimCode.ALIAS(varName = i_varName) )
      equation
        txt = cref(txt, i_varName);
      then txt;

    case ( txt,
           SimCode.NEGATEDALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        txt = cref(txt, i_varName);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("noAlias"));
      then txt;
  end match;
end getAliasVar;

protected function lm_592
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v(algVarsStart+"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_592(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_592(txt, rest);
      then txt;
  end match;
end lm_592;

protected function lm_593
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i1;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v(intAlgVarsStart+"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_593(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_593(txt, rest);
      then txt;
  end match;
end lm_593;

protected function lm_594
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i2;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i2 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v(boolAlgVarsStart+"));
        txt = Tpl.writeStr(txt, intString(x_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_594(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_594(txt, rest);
      then txt;
  end match;
end lm_594;

protected function lm_595
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i3;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i3 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v(inputVarsStart+"));
        txt = Tpl.writeStr(txt, intString(x_i3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_595(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_595(txt, rest);
      then txt;
  end match;
end lm_595;

protected function lm_596
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i4;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i4 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v(outputVarsStart+"));
        txt = Tpl.writeStr(txt, intString(x_i4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_596(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_596(txt, rest);
      then txt;
  end match;
end lm_596;

protected function lm_597
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i5;
      SimCode.AliasVariable i_aliasvar;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = i_aliasvar) :: rest )
      equation
        x_i5 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v(aliasVarsStart+"));
        txt = Tpl.writeStr(txt, intString(x_i5));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = getAliasVar(txt, i_aliasvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_597(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_597(txt, rest);
      then txt;
  end match;
end lm_597;

protected function lm_598
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i6;
      SimCode.AliasVariable i_aliasvar;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = i_aliasvar) :: rest )
      equation
        x_i6 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v(intAliasVarsStart+"));
        txt = Tpl.writeStr(txt, intString(x_i6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = getAliasVar(txt, i_aliasvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_598(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_598(txt, rest);
      then txt;
  end match;
end lm_598;

protected function lm_599
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i7;
      SimCode.AliasVariable i_aliasvar;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = i_aliasvar) :: rest )
      equation
        x_i7 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v(boolAliasVarsStart+"));
        txt = Tpl.writeStr(txt, intString(x_i7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = getAliasVar(txt, i_aliasvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_599(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_599(txt, rest);
      then txt;
  end match;
end lm_599;

protected function lm_600
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i8;
      Integer i_index;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(index = i_index) :: rest )
      equation
        x_i8 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v(stateVarsStart+"));
        txt = Tpl.writeStr(txt, intString(x_i8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")=__z["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; "));
        txt = Tpl.nextIter(txt);
        txt = lm_600(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_600(txt, rest);
      then txt;
  end match;
end lm_600;

protected function lm_601
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i9;
      Integer i_index;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(index = i_index) :: rest )
      equation
        x_i9 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("v2("));
        txt = Tpl.writeStr(txt, intString(x_i9));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")=__zDot["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; "));
        txt = Tpl.nextIter(txt);
        txt = lm_601(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_601(txt, rest);
      then txt;
  end match;
end lm_601;

public function writeoutput2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_outputVars;
      list<SimCode.SimVar> i_vars_inputVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      SimCode.ModelInfo i_modelInfo;

    case ( txt,
           (i_modelInfo as SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, inputVars = i_vars_inputVars, outputVars = i_vars_outputVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars, stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    const int algVarsStart = 0;\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const int intAlgVarsStart    = algVarsStart       + "));
        txt = numAlgvar(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "const int boolAlgVarsStart   = intAlgVarsStart    + "
                                }, false));
        txt = numIntAlgvar(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "const int inputVarsStart     = boolAlgVarsStart   + "
                                }, false));
        txt = numBoolAlgvar(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "const int outputVarsStart    = inputVarsStart     + "
                                }, false));
        txt = numInputvar(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "const int aliasVarsStart     = outputVarsStart    + "
                                }, false));
        txt = numOutputvar(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "const int intAliasVarsStart  = aliasVarsStart     + "
                                }, false));
        txt = numAliasvar(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "const int boolAliasVarsStart = intAliasVarsStart  + "
                                }, false));
        txt = numIntAliasvar(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "const int stateVarsStart     = boolAliasVarsStart + "
                                }, false));
        txt = numBoolAliasvar(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_592(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_593(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_594(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_595(txt, i_vars_inputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_596(txt, i_vars_outputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_597(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_598(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_599(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_600(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_601(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end writeoutput2;

protected function lm_603
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.save("));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.nextIter(txt);
        txt = lm_603(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_603(txt, rest);
      then txt;
  end match;
end lm_603;

protected function lm_604
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.save("));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.nextIter(txt);
        txt = lm_604(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_604(txt, rest);
      then txt;
  end match;
end lm_604;

protected function lm_605
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.save("));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.nextIter(txt);
        txt = lm_605(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_605(txt, rest);
      then txt;
  end match;
end lm_605;

protected function lm_606
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Integer i_index;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(index = i_index, name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.save(__z["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("],\""));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.nextIter(txt);
        txt = lm_606(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_606(txt, rest);
      then txt;
  end match;
end lm_606;

protected function smf_607
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_607;

protected function smf_608
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_608;

protected function smf_609
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_609;

protected function smf_610
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_610;

protected function fun_611
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stateVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      Absyn.Path i_modelInfo_name;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stateVars = i_vars_stateVars), name = i_modelInfo_name)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::saveAll()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_0 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_0 = lm_603(txt_0, i_vars_algVars);
        txt_0 = Tpl.popIter(txt_0);
        txt_1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_1 = lm_604(txt_1, i_vars_intAlgVars);
        txt_1 = Tpl.popIter(txt_1);
        txt_2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_605(txt_2, i_vars_boolAlgVars);
        txt_2 = Tpl.popIter(txt_2);
        txt_3 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_3 = lm_606(txt_3, i_vars_stateVars);
        txt_3 = Tpl.popIter(txt_3);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_607(txt, txt_0);
        txt = smf_608(txt, txt_1);
        txt = smf_609(txt, txt_2);
        txt = smf_610(txt, txt_3);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " _event_handling.saveH();\n",
                                    "\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_611;

public function saveall
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_611(txt, a_simCode);
end saveall;

protected function lm_613
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.saveDiscreteVar("));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.nextIter(txt);
        txt = lm_613(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_613(txt, rest);
      then txt;
  end match;
end lm_613;

protected function lm_614
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.saveDiscreteVar("));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.nextIter(txt);
        txt = lm_614(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_614(txt, rest);
      then txt;
  end match;
end lm_614;

protected function lm_615
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.saveDiscreteVar("));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.nextIter(txt);
        txt = lm_615(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_615(txt, rest);
      then txt;
  end match;
end lm_615;

protected function smf_616
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_616;

protected function smf_617
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_617;

protected function smf_618
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_618;

protected function fun_619
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      Absyn.Path i_modelInfo_name;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars), name = i_modelInfo_name)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::saveDiscreteVars()\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_0 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_0 = lm_613(txt_0, i_vars_algVars);
        txt_0 = Tpl.popIter(txt_0);
        txt_1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_1 = lm_614(txt_1, i_vars_intAlgVars);
        txt_1 = Tpl.popIter(txt_1);
        txt_2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_615(txt_2, i_vars_boolAlgVars);
        txt_2 = Tpl.popIter(txt_2);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_616(txt, txt_0);
        txt = smf_617(txt, txt_1);
        txt = smf_618(txt, txt_2);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_619;

public function savediscreteVars
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_619(txt, a_simCode);
end savediscreteVars;

public function initvar
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars, paramVars = i_vars_paramVars)),
           a_simCode )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = initValst(txt, i_vars_stateVars, a_simCode, SimCode.contextOther);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_derivativeVars, a_simCode, SimCode.contextOther);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_algVars, a_simCode, SimCode.contextOther);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_intAlgVars, a_simCode, SimCode.contextOther);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_boolAlgVars, a_simCode, SimCode.contextOther);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_aliasVars, a_simCode, SimCode.contextOther);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_intAliasVars, a_simCode, SimCode.contextOther);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_boolAliasVars, a_simCode, SimCode.contextOther);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_paramVars, a_simCode, SimCode.contextOther);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end initvar;

public function initAlgloopvars
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars)),
           a_simCode )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = initValst(txt, i_vars_algVars, a_simCode, SimCode.contextAlgloop);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_intAlgVars, a_simCode, SimCode.contextAlgloop);
        txt = Tpl.softNewLine(txt);
        txt = initValst(txt, i_vars_boolAlgVars, a_simCode, SimCode.contextAlgloop);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end initAlgloopvars;

protected function lm_623
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(index = _)) :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_623(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_623(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_623;

protected function lm_624
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_ALGORITHM(index = _)) :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_624(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_624(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_624;

public function boundParameters
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_divbody;
  Tpl.Text l_body;
  Tpl.Text l_tmp;
algorithm
  l_tmp := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, out_a_varDecls) := lm_623(l_body, a_parameterEquations, a_simCode, a_varDecls);
  l_body := Tpl.popIter(l_body);
  l_divbody := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_divbody, out_a_varDecls) := lm_624(l_divbody, a_parameterEquations, a_simCode, out_a_varDecls);
  l_divbody := Tpl.popIter(l_divbody);
  out_txt := Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_divbody);
  out_txt := Tpl.popBlock(out_txt);
end boundParameters;

protected function lm_626
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Integer i_index;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(index = i_index, name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\")"));
        txt = Tpl.nextIter(txt);
        txt = lm_626(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_626(txt, rest);
      then txt;
  end match;
end lm_626;

protected function smf_627
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
      then txt;
  end match;
end smf_627;

protected function fun_628
  input Tpl.Text in_txt;
  input Integer in_a_varInfo_numOutVars;
  input list<SimCode.SimVar> in_a_vars_outputVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varInfo_numOutVars, in_a_vars_outputVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> a_vars_outputVars;
      Tpl.Text txt_0;

    case ( txt,
           0,
           _ )
      then txt;

    case ( txt,
           _,
           a_vars_outputVars )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var_ouputs_idx =  boost::assign::map_list_of "));
        txt_0 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_0 = lm_626(txt_0, a_vars_outputVars);
        txt_0 = Tpl.popIter(txt_0);
        txt = smf_627(txt, txt_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_628;

public function outputIndices
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_outputVars;
      Integer i_varInfo_numOutVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numOutVars = i_varInfo_numOutVars), vars = SimCode.SIMVARS(outputVars = i_vars_outputVars)) )
      equation
        txt = fun_628(txt, i_varInfo_numOutVars, i_vars_outputVars);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end outputIndices;

public function isOutput
  input Tpl.Text in_txt;
  input SimCode.Causality in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_c)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.OUTPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end isOutput;

protected function fun_631
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_sv_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_context, in_a_simCode, in_a_sv_name)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_sv_name;
      String i_vStr;

    case ( txt,
           (i_vStr as "0"),
           a_context,
           a_simCode,
           a_sv_name )
      equation
        txt = cref1(txt, a_sv_name, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";//"));
        txt = cref(txt, a_sv_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_start_values[\""));
        txt = cref(txt, a_sv_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"]="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_vStr as "0.0"),
           a_context,
           a_simCode,
           a_sv_name )
      equation
        txt = cref1(txt, a_sv_name, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";//"));
        txt = cref(txt, a_sv_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_start_values[\""));
        txt = cref(txt, a_sv_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"]="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_vStr as "(0)"),
           a_context,
           a_simCode,
           a_sv_name )
      equation
        txt = cref1(txt, a_sv_name, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";//"));
        txt = cref(txt, a_sv_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_start_values[\""));
        txt = cref(txt, a_sv_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"]="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_vStr as ""),
           a_context,
           a_simCode,
           a_sv_name )
      equation
        txt = cref1(txt, a_sv_name, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=0;//"));
        txt = cref(txt, a_sv_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_start_values[\""));
        txt = cref(txt, a_sv_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"]="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_vStr,
           a_context,
           a_simCode,
           a_sv_name )
      equation
        txt = cref1(txt, a_sv_name, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";//"));
        txt = cref(txt, a_sv_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_start_values[\""));
        txt = cref(txt, a_sv_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"]="));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_631;

protected function fun_632
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input DAE.Type in_a_sv_type__;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_sv_name;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_sv_type__, in_a_context, in_a_sv_name, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.Type a_sv_type__;
      SimCode.Context a_context;
      DAE.ComponentRef a_sv_name;
      SimCode.SimCode a_simCode;
      DAE.Exp i_v;
      String str_3;
      Tpl.Text txt_2;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;

    case ( txt,
           SOME(i_v),
           _,
           a_context,
           a_sv_name,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        (txt_2, l_preExp, l_varDecls) = daeExp(Tpl.emptyTxt, i_v, SimCode.contextOther, l_preExp, l_varDecls, a_simCode);
        str_3 = Tpl.textString(txt_2);
        txt = fun_631(txt, str_3, a_context, a_simCode, a_sv_name);
      then txt;

    case ( txt,
           _,
           a_sv_type__,
           a_context,
           a_sv_name,
           a_simCode )
      equation
        txt = cref1(txt, a_sv_name, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = startValue(txt, a_sv_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_start_values[\""));
        txt = cref(txt, a_sv_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"]="));
        txt = startValue(txt, a_sv_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_632;

protected function lm_633
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      DAE.Type i_sv_type__;
      DAE.ComponentRef i_sv_name;
      Option<DAE.Exp> i_initialValue;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(initialValue = i_initialValue, name = i_sv_name, type_ = i_sv_type__) :: rest,
           a_context,
           a_simCode )
      equation
        txt = fun_632(txt, i_initialValue, i_sv_type__, a_context, i_sv_name, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_633(txt, rest, a_context, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_context,
           a_simCode )
      equation
        txt = lm_633(txt, rest, a_context, a_simCode);
      then txt;
  end match;
end lm_633;

public function initValst
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;
  input SimCode.SimCode a_simCode;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_633(out_txt, a_varsLst, a_context, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end initValst;

public function startValue
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0.0"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("empty"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end startValue;

protected function fun_636
  input Tpl.Text in_txt;
  input Integer in_a_vi_numZeroCrossings;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vi_numZeroCrossings)
    local
      Tpl.Text txt;
      Integer i_vi_numZeroCrossings;

    case ( txt,
           0 )
      then txt;

    case ( txt,
           i_vi_numZeroCrossings )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool events["));
        txt = Tpl.writeStr(txt, intString(i_vi_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("];\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("memset(events,true,"));
        txt = Tpl.writeStr(txt, intString(i_vi_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for(int i=0;i<="));
        txt = Tpl.writeStr(txt, intString(i_vi_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";++i) { handleEvent(events); }"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_636;

public function eventHandlingInit
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Integer i_vi_numZeroCrossings;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = i_vi_numZeroCrossings))) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = fun_636(txt, i_vi_numZeroCrossings);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end eventHandlingInit;

public function dimension1
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Integer i_vi_numParams;
      Integer i_vi_numAlgVars;
      Integer i_vi_numStringParamVars;
      Integer i_vi_numStringAlgVars;
      Integer i_vi_numIntParams;
      Integer i_vi_numIntAlgVars;
      Integer i_vi_numBoolParams;
      Integer i_vi_numBoolAlgVars;
      Integer i_vi_numStateVars;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_vi_numStateVars, numBoolAlgVars = i_vi_numBoolAlgVars, numBoolParams = i_vi_numBoolParams, numIntAlgVars = i_vi_numIntAlgVars, numIntParams = i_vi_numIntParams, numStringAlgVars = i_vi_numStringAlgVars, numStringParamVars = i_vi_numStringParamVars, numAlgVars = i_vi_numAlgVars, numParams = i_vi_numParams))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimContinuousStates = "));
        txt = Tpl.writeStr(txt, intString(i_vi_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "_dimRHS = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "_dimBoolean ="
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" + "));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "_dimInteger ="
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  + "));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "_dimString ="
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" + "));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimReal ="));
        txt = Tpl.writeStr(txt, intString(i_vi_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" + "));
        txt = Tpl.writeStr(txt, intString(i_vi_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dimension1;

public function isODE
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Integer i_vi_numStateVars;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_vi_numStateVars), name = i_modelInfo_name)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("::isODE()\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = Tpl.writeStr(txt, intString(i_vi_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">0 ;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" }"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end isODE;

protected function fun_640
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = arrayCrefStr(txt, a_cr);
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = arrayCrefCStr(txt, a_cr);
      then txt;
  end match;
end fun_640;

public function contextArrayCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_640(txt, a_context, a_cr);
end contextArrayCref;

public function arrayCrefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = arrayCrefStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end arrayCrefStr;

protected function fun_643
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;
      ClassInf.State i_complexClassType;
      Absyn.Path ret_0;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_complexClassType) )
      equation
        ret_0 = ClassInf.getStateName(i_complexClassType);
        txt = underscorePath(txt, ret_0);
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;
  end match;
end fun_643;

protected function fun_644
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;
      Absyn.Path i_rname;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)) )
      equation
        txt = underscorePath(txt, i_rname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type"));
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = fun_643(txt, i_ty);
      then txt;
  end match;
end fun_644;

protected function fun_645
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _))) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = fun_644(txt, i_ty);
      then txt;
  end match;
end fun_645;

protected function fun_646
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = expTypeFlag(txt, i_ty, 2);
      then txt;
  end match;
end fun_646;

protected function fun_647
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;
      DAE.Type i_ty;
      Integer ret_0;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims, ty = i_ty) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array_ref<"));
        txt = expTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_dims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = expTypeFlag(txt, i_ty, 2);
      then txt;
  end match;
end fun_647;

protected function fun_648
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;
      DAE.Type i_ty;
      Integer ret_0;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims, ty = i_ty) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = expTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_dims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = expTypeFlag(txt, i_ty, 2);
      then txt;
  end match;
end fun_648;

protected function fun_649
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;
      DAE.Type i_ty;
      Integer ret_0;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims, ty = i_ty) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = expTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = listLength(i_dims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_649;

protected function fun_650
  input Tpl.Text in_txt;
  input Integer in_a_flag;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;

    case ( txt,
           1,
           a_ty )
      equation
        txt = expTypeShort(txt, a_ty);
      then txt;

    case ( txt,
           2,
           a_ty )
      equation
        txt = fun_645(txt, a_ty);
      then txt;

    case ( txt,
           3,
           a_ty )
      equation
        txt = expTypeShort(txt, a_ty);
      then txt;

    case ( txt,
           4,
           a_ty )
      equation
        txt = fun_646(txt, a_ty);
      then txt;

    case ( txt,
           5,
           a_ty )
      equation
        txt = fun_647(txt, a_ty);
      then txt;

    case ( txt,
           6,
           a_ty )
      equation
        txt = fun_648(txt, a_ty);
      then txt;

    case ( txt,
           7,
           a_ty )
      equation
        txt = fun_649(txt, a_ty);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_650;

public function expTypeFlag
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input Integer a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_650(txt, a_flag, a_ty);
end expTypeFlag;

public function expTypeArray
  input Tpl.Text txt;
  input DAE.Type a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFlag(txt, a_ty, 3);
end expTypeArray;

public function expTypeArrayforDim
  input Tpl.Text txt;
  input DAE.Type a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFlag(txt, a_ty, 6);
end expTypeArrayforDim;

protected function fun_654
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;
  end match;
end fun_654;

public function expTypeShort
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;
      DAE.Type i_ty;
      Boolean ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        txt = fun_654(txt, ret_0);
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_UNKNOWN(source = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("complex"));
      then txt;

    case ( txt,
           DAE.T_ANYTYPE(anyClassType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("complex"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("complex"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("complex"));
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fnptr"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expTypeShort:ERROR"));
      then txt;
  end match;
end expTypeShort;

public function dimension
  input Tpl.Text in_txt;
  input DAE.Dimension in_a_d;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_d)
    local
      Tpl.Text txt;
      Integer i_size;
      Integer i_integer;

    case ( txt,
           DAE.DIM_INTEGER(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.DIM_ENUM(size = i_size) )
      equation
        txt = Tpl.writeStr(txt, intString(i_size));
      then txt;

    case ( txt,
           DAE.DIM_UNKNOWN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("INVALID_DIMENSION"));
      then txt;
  end match;
end dimension;

public function arrayCrefCStr
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("_"));
  out_txt := arrayCrefCStr2(out_txt, a_cr);
end arrayCrefCStr;

public function arrayCrefCStr2
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_P_"));
        txt = arrayCrefCStr2(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end arrayCrefCStr2;

public function underscorePath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end underscorePath;

public function replaceDotAndUnderscore
  input Tpl.Text in_txt;
  input String in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_str)
    local
      Tpl.Text txt;
      String i_name;
      String ret_3;
      Tpl.Text l_str__underscores;
      String ret_1;
      Tpl.Text l_str__dots;

    case ( txt,
           i_name )
      equation
        ret_1 = System.stringReplace(i_name, ".", "_");
        l_str__dots = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_3 = System.stringReplace(Tpl.textString(l_str__dots), "_", "__");
        l_str__underscores = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        txt = Tpl.writeText(txt, l_str__underscores);
      then txt;
  end match;
end replaceDotAndUnderscore;

public function tempDecl
  input Tpl.Text txt;
  input String a_ty;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Integer ret_1;
  Tpl.Text l_newVar;
algorithm
  l_newVar := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("tmp"));
  ret_1 := System.tmpTick();
  l_newVar := Tpl.writeStr(l_newVar, intString(ret_1));
  out_a_varDecls := Tpl.writeStr(a_varDecls, a_ty);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(" "));
  out_a_varDecls := Tpl.writeText(out_a_varDecls, l_newVar);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(";"));
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_newVar);
end tempDecl;

protected function fun_662
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_simCode, in_a_cr)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_cr;
      SimCode.Context i_context;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           _,
           a_cr )
      equation
        txt_0 = crefStr(Tpl.emptyTxt, a_cr);
        ret_1 = System.unquoteIdentifier(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           i_context,
           a_simCode,
           a_cr )
      equation
        txt = cref1(txt, a_cr, a_simCode, i_context);
      then txt;
  end match;
end fun_662;

public function contextCref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_cr;
      DAE.ComponentRef i_componentRef;

    case ( txt,
           DAE.CREF_QUAL(ident = "$PRE", componentRef = i_componentRef),
           a_context,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.pre("));
        txt = contextCref(txt, i_componentRef, a_context, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\")"));
      then txt;

    case ( txt,
           i_cr,
           a_context,
           a_simCode )
      equation
        txt = fun_662(txt, a_context, a_simCode, i_cr);
      then txt;
  end match;
end contextCref;

protected function fun_664
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = crefStr(txt, a_cr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_664;

public function contextCref2
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_664(txt, a_context, a_cr);
end contextCref2;

public function crefFunctionName
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        ret_1 = System.stringReplace(ret_0, "_", "__");
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        ret_2 = System.unquoteIdentifier(i_ident);
        ret_3 = System.stringReplace(ret_2, "_", "__");
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefFunctionName(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end crefFunctionName;

protected function lm_667
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(index = _)) :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_667(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_667(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_667;

public function functionInitial
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_startValueEquations;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_eqPart;
algorithm
  l_eqPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqPart, out_a_varDecls) := lm_667(l_eqPart, a_startValueEquations, a_simCode, a_varDecls);
  l_eqPart := Tpl.popIter(l_eqPart);
  out_txt := Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_eqPart);
  out_txt := Tpl.popBlock(out_txt);
end functionInitial;

protected function fun_669
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           SimCode.ALGLOOP_CONTEXT(genInitialisation = true),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "  try\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->solve();\n",
                                    "       }\n",
                                    "catch(std::exception &ex)\n",
                                    "   {\n",
                                    "        throw std::invalid_argument(\"Nonlinear solver stopped at time \" + boost::lexical_cast<string>(_simTime) + \" with error: \" + ex.what());\n",
                                    "    }"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n",
                                    "try\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("->solve(command);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  catch(std::exception &ex)\n",
                                    "   {\n",
                                    "         throw std::invalid_argument(\"Nonlinear solver stopped at time \" + boost::lexical_cast<string>(_simTime) + \" with error: \" + ex.what());\n",
                                    "   }\n",
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
      then txt;
  end match;
end fun_669;

protected function fun_670
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           SimCode.ALGLOOP_CONTEXT(genInitialisation = true),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "  try\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->solve();\n",
                                    "       }\n",
                                    "catch(std::exception &ex)\n",
                                    "   {\n",
                                    "        throw std::invalid_argument(\"Nonlinear solver stopped at time \" + boost::lexical_cast<string>(_simTime) + \" with error: \" + ex.what());\n",
                                    "    }"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n",
                                    "try\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("->solve(command);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  catch(std::exception &ex)\n",
                                    "   {\n",
                                    "         throw std::invalid_argument(\"Nonlinear solver stopped at time \" + boost::lexical_cast<string>(_simTime) + \" with error: \" + ex.what());\n",
                                    "   }\n",
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
      then txt;
  end match;
end fun_670;

public function equation_
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Integer i_index;
      SimCode.SimEqSystem i_e;
      Tpl.Text l_i;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(index = _)),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = equationSimpleAssign(txt, i_e, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(index = _)),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = equationAlgorithm(txt, i_e, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_WHEN(index = _)),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = equationWhen(txt, i_e, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(index = _)),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = equationArrayCallAssign(txt, i_e, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_context,
           a_varDecls,
           _ )
      equation
        l_i = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_669(txt, a_context, i_index);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_context,
           a_varDecls,
           _ )
      equation
        l_i = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_670(txt, a_context, i_index);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_MIXED(index = _),
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    throw std::runtime_error(\"Mixed systems are not supported yet\");"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION"));
      then (txt, a_varDecls);
  end match;
end equation_;

protected function lm_672
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_num;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preDisc;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preDisc;
algorithm
  (out_txt, out_a_varDecls, out_a_preDisc) :=
  match(in_txt, in_items, in_a_num, in_a_simCode, in_a_varDecls, in_a_preDisc, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_num;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preDisc;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           a_preDisc,
           _ )
      then (txt, a_varDecls, a_preDisc);

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref) :: rest,
           a_num,
           a_simCode,
           a_varDecls,
           a_preDisc,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_expPart, a_preDisc, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preDisc, a_varDecls, a_simCode);
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "new_disc_vars"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preDisc) = lm_672(txt, rest, a_num, a_simCode, a_varDecls, a_preDisc, a_context);
      then (txt, a_varDecls, a_preDisc);

    case ( txt,
           _ :: rest,
           a_num,
           a_simCode,
           a_varDecls,
           a_preDisc,
           a_context )
      equation
        (txt, a_varDecls, a_preDisc) = lm_672(txt, rest, a_num, a_simCode, a_varDecls, a_preDisc, a_context);
      then (txt, a_varDecls, a_preDisc);
  end match;
end lm_672;

public function equationMixed
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> i_discEqs;
      Integer i_index;
      list<SimCode.SimVar> i_discVars;
      SimCode.SimEqSystem i_cont;
      Tpl.Text l_discvars2;
      Tpl.Text l_num;
      Tpl.Text l_preDisc;
      Integer ret_2;
      Tpl.Text l_numDiscVarsStr;
      Tpl.Text l_contEqs;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont, discVars = i_discVars, index = i_index, discEqs = i_discEqs),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (l_contEqs, a_varDecls) = equation_(Tpl.emptyTxt, i_cont, a_context, a_varDecls, a_simCode);
        ret_2 = listLength(i_discVars);
        l_numDiscVarsStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_preDisc = Tpl.emptyTxt;
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        l_discvars2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_discvars2, a_varDecls, l_preDisc) = lm_672(l_discvars2, i_discEqs, l_num, a_simCode, a_varDecls, l_preDisc, a_context);
        l_discvars2 = Tpl.popIter(l_discvars2);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end match;
end equationMixed;

protected function fun_674
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_algloopsolver;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_algloopsolver)
    local
      Tpl.Text txt;
      Tpl.Text a_algloopsolver;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_algloopsolver )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::stepCompleted(double time)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_algloopsolver);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "saveAll();\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_674;

public function generateStepCompleted
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := generateStepCompleted2(Tpl.emptyTxt, a_allEquations, a_simCode);
  out_txt := fun_674(txt, a_simCode, l_algloopsolver);
end generateStepCompleted;

protected function fun_676
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::handleTimeEvent(int* time_events)\n",
                                    "{\n",
                                    "for(int i = 0;i<_dimTimeEvent;i++)\n",
                                    "{\n",
                                    "\n",
                                    "  if(time_events[i]!=_time_event_counter[i])\n",
                                    "       _time_conditions[i] = true;\n",
                                    "   else\n",
                                    "     _time_conditions[i] = false;\n",
                                    "\n",
                                    "\n",
                                    " }\n",
                                    "  memcpy(_time_event_counter,time_events,(int)_dimTimeEvent*sizeof(int));\n",
                                    " }"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_676;

public function generatehandleTimeEvent
  input Tpl.Text txt;
  input BackendDAE.SampleLookup a_sampleLookup;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_676(txt, a_simCode);
end generatehandleTimeEvent;

protected function fun_678
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimTimeEvent() const\n",
                                    "{\n",
                                    "  return _dimTimeEvent;\n",
                                    " }"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_678;

public function generateDimTimeEvent
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_678(txt, a_simCode);
end generateDimTimeEvent;

protected function lm_680
  input Tpl.Text in_txt;
  input list<tuple<Integer, DAE.Exp, DAE.Exp>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<tuple<Integer, DAE.Exp, DAE.Exp>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      DAE.Exp i_interval;
      DAE.Exp i_start;
      Tpl.Text l_e2;
      Tpl.Text l_e1;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (_, i_start, i_interval) :: rest,
           a_simCode,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_start, SimCode.contextOther, l_preExp, a_varDecls, a_simCode);
        (l_e2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_interval, SimCode.contextOther, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time_events.push_back(std::make_pair("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("));"));
        txt = Tpl.popBlock(txt);
        (txt, a_varDecls) = lm_680(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_680;

protected function fun_681
  input Tpl.Text in_txt;
  input BackendDAE.SampleLookup in_a_sampleLookup;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_sampleLookup, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      list<tuple<Integer, DAE.Exp, DAE.Exp>> i_lookup;

    case ( txt,
           BackendDAE.SAMPLE_LOOKUP(lookup = i_lookup),
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_680(txt, i_lookup, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_681;

protected function fun_682
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      BackendDAE.SampleLookup i_sampleLookup;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_varDecls;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), sampleLookup = i_sampleLookup)) )
      equation
        l_varDecls = Tpl.emptyTxt;
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getTimeEvent(time_event_type& time_events)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        (txt, l_varDecls) = fun_681(txt, i_sampleLookup, i_simCode, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" }"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_682;

public function generateTimeEvent
  input Tpl.Text txt;
  input BackendDAE.SampleLookup a_sampleLookup;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_682(txt, a_simCode);
end generateTimeEvent;

protected function smf_684
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_it;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_it, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           i_eq,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = generateStepCompleted3(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
      then (txt, a_varDecls);
  end match;
end smf_684;

protected function lm_685
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = smf_684(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_685(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_685;

public function generateStepCompleted2
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_685(l_algloopsolver, a_allEquations, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
  out_txt := Tpl.writeText(out_txt, l_algloopsolver);
  out_txt := Tpl.popBlock(out_txt);
end generateStepCompleted2;

protected function fun_687
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->stepCompleted(_simTime);"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_687;

protected function fun_688
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->stepCompleted(_simTime);"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_688;

public function generateStepCompleted3
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_687(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_688(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = generateStepCompleted3(txt, i_eq__sys, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end match;
end generateStepCompleted3;

protected function smf_690
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_it;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_it, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           i_eq,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = generateAlgloopsolvers2(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
      then (txt, a_varDecls);
  end match;
end smf_690;

protected function lm_691
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = smf_690(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_691(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_691;

public function generateAlgloopsolvers
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_691(l_algloopsolver, a_allEquations, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
  out_txt := Tpl.writeText(out_txt, l_algloopsolver);
  out_txt := Tpl.popBlock(out_txt);
end generateAlgloopsolvers;

protected function smf_693
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_it;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           i_eq,
           a_simCode )
      equation
        txt = generatefriendAlgloops2(txt, i_eq, a_simCode);
      then txt;
  end match;
end smf_693;

protected function lm_694
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqs :: rest,
           a_simCode )
      equation
        txt = smf_693(txt, i_eqs, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_694(txt, rest, a_simCode);
      then txt;
  end match;
end lm_694;

public function generatefriendAlgloops
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_friendalgloops;
algorithm
  l_friendalgloops := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_friendalgloops := lm_694(l_friendalgloops, a_allEquations, a_simCode);
  l_friendalgloops := Tpl.popIter(l_friendalgloops);
  out_txt := Tpl.writeText(txt, l_friendalgloops);
end generatefriendAlgloops;

protected function fun_696
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("friend class "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_696;

protected function fun_697
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("friend class "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_697;

public function generatefriendAlgloops2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_696(txt, a_simCode, l_num);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_697(txt, a_simCode, l_num);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_simCode )
      equation
        txt = generatefriendAlgloops2(txt, i_eq__sys, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end generatefriendAlgloops2;

protected function fun_699
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" =  boost::shared_ptr<"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">(new "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(this,__z,__zDot,_conditions,_event_handling )\n",
                                    "                                                                                                                                );\n",
                                    "_algLoopSolver"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = boost::shared_ptr<IAlgLoopSolver>(_algLoopSolverFactory->createAlgLoopSolver(_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".get()));"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_699;

protected function fun_700
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" =  boost::shared_ptr<"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">(new "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(this,__z,__zDot,_conditions,_event_handling )\n",
                                    "                                                                                                                                );\n",
                                    "_algLoopSolver"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = boost::shared_ptr<IAlgLoopSolver>(_algLoopSolverFactory->createAlgLoopSolver(_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".get()));"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_700;

public function generateAlgloopsolvers2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_699(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_700(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = generateAlgloopsolvers2(txt, i_eq__sys, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end match;
end generateAlgloopsolvers2;

protected function smf_702
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_it;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_it, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           i_eq,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = generateAlgloopsolverVariables2(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
      then (txt, a_varDecls);
  end match;
end smf_702;

protected function lm_703
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = smf_702(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_703(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_703;

public function generateAlgloopsolverVariables
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_703(l_algloopsolver, a_allEquationsPlusWhen, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.writeText(txt, l_algloopsolver);
end generateAlgloopsolverVariables;

protected function fun_705
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::shared_ptr<"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">  //Algloop  which holds equation system\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  boost::shared_ptr<IAlgLoopSolver>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";        ///< Solver for algebraic loop */"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_705;

protected function fun_706
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::shared_ptr<"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">  //Algloop  which holds equation system\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  boost::shared_ptr<IAlgLoopSolver>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";        ///< Solver for algebraic loop */"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_706;

public function generateAlgloopsolverVariables2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_705(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_706(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = generateAlgloopsolverVariables2(txt, i_eq__sys, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end match;
end generateAlgloopsolverVariables2;

protected function lm_708
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = initAlgloopsolvers2(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
        (txt, a_varDecls) = lm_708(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_708;

protected function lm_709
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_708(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_709(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_709;

public function initAlgloopsolvers
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_continousEquations;
  input list<list<SimCode.SimEqSystem>> a_discreteEquations;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_709(l_algloopsolver, a_continousEquations, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.writeText(txt, l_algloopsolver);
end initAlgloopsolvers;

protected function fun_711
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    // Initialize the solver\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if(_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->initialize();"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_711;

protected function fun_712
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    // Initialize the solver\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if(_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_algLoopSolver"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->initialize();"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_712;

public function initAlgloopsolvers2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_711(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_712(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = initAlgloopsolvers2(txt, i_eq__sys, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls);
  end match;
end initAlgloopsolvers2;

protected function smf_714
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_it;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_it, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           i_eq,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = algloopfilesInclude2(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
      then (txt, a_varDecls);
  end match;
end smf_714;

protected function lm_715
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = smf_714(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_715(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_715;

public function algloopfilesInclude
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, l_varDecls) := lm_715(out_txt, a_allEquations, a_simCode, l_varDecls);
  out_txt := Tpl.popIter(out_txt);
end algloopfilesInclude;

protected function fun_717
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".h\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_717;

protected function fun_718
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".h\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_718;

public function algloopfilesInclude2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_717(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_718(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = algloopfilesInclude2(txt, i_eq__sys, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end match;
end algloopfilesInclude2;

protected function lm_720
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = algloopfiles2(txt, i_eqs, SimCode.contextOther, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_720(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_720;

public function algloopfiles
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_720(l_algloopsolver, a_allEquations, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.writeText(txt, l_algloopsolver);
end algloopfiles;

protected function fun_722
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num, in_a_eq)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      SimCode.SimEqSystem a_eq;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_num,
           a_eq )
      equation
        txt_0 = algloopHeaderFile(Tpl.emptyTxt, i_simCode, a_eq);
        txt_1 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("Algloop"));
        txt_1 = Tpl.writeText(txt_1, a_num);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
        txt_2 = algloopCppFile(Tpl.emptyTxt, i_simCode, a_eq);
        txt_3 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("Algloop"));
        txt_3 = Tpl.writeText(txt_3, a_num);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING(".cpp"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_722;

protected function fun_723
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num, in_a_eq)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      SimCode.SimEqSystem a_eq;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_num,
           a_eq )
      equation
        txt_0 = algloopHeaderFile(Tpl.emptyTxt, i_simCode, a_eq);
        txt_1 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("Algloop"));
        txt_1 = Tpl.writeText(txt_1, a_num);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
        txt_2 = algloopCppFile(Tpl.emptyTxt, i_simCode, a_eq);
        txt_3 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("Algloop"));
        txt_3 = Tpl.writeText(txt_3, a_num);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING(".cpp"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_723;

protected function fun_724
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq__sys;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq__sys)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq__sys;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eq__sys )
      equation
        txt_0 = algloopHeaderFile(Tpl.emptyTxt, i_simCode, a_eq__sys);
        txt_1 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("Algloop"));
        txt_1 = algloopfilesindex(txt_1, a_eq__sys);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
        txt_2 = algloopCppFile(Tpl.emptyTxt, i_simCode, a_eq__sys);
        txt_3 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("Algloop"));
        txt_3 = algloopfilesindex(txt_3, a_eq__sys);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING(".cpp"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_724;

protected function fun_725
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      SimCode.SimEqSystem i_e;
      SimCode.SimEqSystem i_eq;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_722(txt, a_simCode, l_num, i_eq);
      then txt;

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(index = i_index)),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_723(txt, a_simCode, l_num, i_e);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_simCode )
      equation
        txt = fun_724(txt, a_simCode, i_eq__sys);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end match;
end fun_725;

public function algloopfiles2
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_725(txt, a_eq, a_simCode);
  out_a_varDecls := a_varDecls;
end algloopfiles2;

public function algloopfilesindex
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      Integer i_index;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_MIXED(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end match;
end algloopfilesindex;

protected function smf_728
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_it;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_it, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           i_eq,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = algloopcppfilenames2(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode);
      then (txt, a_varDecls);
  end match;
end smf_728;

protected function lm_729
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = smf_728(txt, i_eqs, a_simCode, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_729(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_729;

public function algloopcppfilenames
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_729(l_algloopsolver, a_allEquations, a_simCode, l_varDecls);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.writeText(txt, l_algloopsolver);
end algloopcppfilenames;

protected function fun_731
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".cpp"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_731;

protected function fun_732
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_num )
      equation
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".cpp"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_732;

public function algloopcppfilenames2
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq__sys;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_731(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_varDecls,
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_732(txt, a_simCode, l_num);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq__sys),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls) = algloopcppfilenames2(txt, i_eq__sys, a_context, a_varDecls, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls);
  end match;
end algloopcppfilenames2;

protected function fun_734
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_expPart;
  input DAE.ComponentRef in_a_eqn_componentRef;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_expPart, in_a_eqn_componentRef, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_expPart;
      DAE.ComponentRef a_eqn_componentRef;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Tpl.Text l_tvar;

    case ( txt,
           "boolean",
           a_expPart,
           a_eqn_componentRef,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "boolean_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           "int",
           a_expPart,
           a_eqn_componentRef,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "integer_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           "double",
           a_expPart,
           a_eqn_componentRef,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_734;

public function equationArrayCallAssign
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_eqn_componentRef;
      DAE.Exp i_eqn_exp;
      DAE.Exp i_exp;
      String str_3;
      Tpl.Text txt_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(exp = (i_eqn_exp as i_exp), componentRef = i_eqn_componentRef),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        txt_2 = expTypeFromExpShort(Tpl.emptyTxt, i_eqn_exp);
        str_3 = Tpl.textString(txt_2);
        (txt, a_varDecls) = fun_734(txt, str_3, l_expPart, i_eqn_componentRef, l_preExp, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end match;
end equationArrayCallAssign;

protected function fun_736
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_c;
  input String in_a_arr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_c, in_a_arr)
    local
      Tpl.Text txt;
      String a_arr;
      DAE.ComponentRef i_c;

    case ( txt,
           (i_c as DAE.CREF_QUAL(ident = "$DER")),
           a_arr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inline_integrate_array(size_of_dimension_real_array("));
        txt = Tpl.writeStr(txt, a_arr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",1),"));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_736;

public function inlineArray
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input String in_a_arr;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_arr, in_a_c)
    local
      Tpl.Text txt;
      String a_arr;
      DAE.ComponentRef a_c;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_arr,
           a_c )
      equation
        txt = fun_736(txt, a_c, a_arr);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end inlineArray;

protected function lm_738
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_e;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_e :: rest,
           a_context,
           a_simCode )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("|| ("));
        txt = cref1(txt, i_e, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !_event_handling.pre("));
        txt = cref1(txt, i_e, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref1(txt, i_e, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"))"));
        txt = Tpl.popBlock(txt);
        txt = lm_738(txt, rest, a_context, a_simCode);
      then txt;
  end match;
end lm_738;

public function equationWhen
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_left;
      DAE.Exp i_right;
      list<DAE.ComponentRef> i_conditions;
      Tpl.Text l_rightExp;
      Tpl.Text l_preExp;
      Tpl.Text l_helpIf;

    case ( txt,
           SimCode.SES_WHEN(conditions = i_conditions, right = i_right, left = i_left),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_helpIf = lm_738(Tpl.emptyTxt, i_conditions, a_context, a_simCode);
        l_preExp = Tpl.emptyTxt;
        (l_rightExp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_right, a_context, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(initial()) {\n",
                                    "  ; /* not implemented yet */\n",
                                    "}\n",
                                    "else if (0"
                                }, false));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref1(txt, i_left, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rightExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_equation"));
      then (txt, a_varDecls);
  end match;
end equationWhen;

protected function lm_740
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Integer x_i0;
      SimCode.SimWhenClause i_when;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_when :: rest,
           a_simCode,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = helpvarvector1(txt, i_when, SimCode.contextOther, a_varDecls, x_i0, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_740(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_740;

public function helpvarvector
  input Tpl.Text txt;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_reinit;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_reinit := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_reinit, l_varDecls) := lm_740(l_reinit, a_whenClauses, a_simCode, l_varDecls);
  l_reinit := Tpl.popIter(l_reinit);
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_reinit);
  out_txt := Tpl.popBlock(out_txt);
end helpvarvector;

protected function lm_742
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_e :: rest,
           a_context,
           a_simCode )
      equation
        l_helpInit = cref1(Tpl.emptyTxt, i_e, a_simCode, a_context);
        txt = Tpl.nextIter(txt);
        txt = lm_742(txt, rest, a_context, a_simCode);
      then txt;
  end match;
end lm_742;

protected function fun_743
  input Tpl.Text in_txt;
  input SimCode.SimWhenClause in_a_whenClauses;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_whenClauses, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      list<DAE.ComponentRef> i_conditions;
      Tpl.Text l_helpIf;
      Tpl.Text l_helpInits;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(conditions = i_conditions),
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_helpIf = lm_742(l_helpIf, i_conditions, a_context, a_simCode);
        l_helpIf = Tpl.popIter(l_helpIf);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_743;

public function helpvarvector1
  input Tpl.Text txt;
  input SimCode.SimWhenClause a_whenClauses;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Integer a_int;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_743(txt, a_whenClauses, a_context, a_simCode);
  out_a_varDecls := a_varDecls;
end helpvarvector1;

public function preCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.SimCode a_simCode;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("pre"));
  out_txt := representationCref(out_txt, a_cr, a_simCode, a_context);
end preCref;

protected function fun_746
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_expPart;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_cref;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp, in_a_preExp, in_a_expPart, in_a_context, in_a_simCode, in_a_cref)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_expPart;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_cref;

    case ( txt,
           DAE.CREF(ty = DAE.T_ARRAY(ty = _)),
           _,
           a_expPart,
           a_context,
           a_simCode,
           a_cref )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//Array assign\n"));
        txt = cref1(txt, a_cref, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           a_preExp,
           a_expPart,
           a_context,
           a_simCode,
           a_cref )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref1(txt, a_cref, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_746;

protected function fun_747
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cref;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_expPart;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cref, in_a_context, in_a_simCode, in_a_exp, in_a_expPart, in_a_preExp)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      DAE.Exp a_exp;
      Tpl.Text a_expPart;
      Tpl.Text a_preExp;
      DAE.ComponentRef i_cref;
      DAE.ComponentRef i_componentRef;

    case ( txt,
           DAE.CREF_QUAL(ident = "$PRE", componentRef = i_componentRef),
           _,
           _,
           _,
           a_expPart,
           a_preExp )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.save("));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_cref,
           a_context,
           a_simCode,
           a_exp,
           a_expPart,
           a_preExp )
      equation
        txt = fun_746(txt, a_exp, a_preExp, a_expPart, a_context, a_simCode, i_cref);
      then txt;
  end match;
end fun_747;

public function equationSimpleAssign
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref),
           a_context,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode);
        txt = fun_747(txt, i_cref, a_context, a_simCode, i_exp, l_expPart, l_preExp);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end match;
end equationSimpleAssign;

protected function fun_749
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end match;
end fun_749;

public function daeExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Exp i_exp;
      DAE.Exp i_expElse;
      DAE.Exp i_expThen;
      DAE.Exp i_expCond;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      DAE.Operator i_operator;
      String i_string;
      DAE.Exp i_e;
      Integer i_index;
      Boolean i_bool;
      Real i_real;
      Integer i_integer;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.RCONST(real = i_real),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.BCONST(bool = i_bool),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = fun_749(txt, i_bool);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CREF(componentRef = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CAST(ty = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCast(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CONS(car = _),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Cons not supported yet"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SCONST(string = i_string),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSconst(txt, i_string, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.UNARY(operator = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnary(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LBINARY(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpLbinary(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LUNARY(operator = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpLunary(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.BINARY(operator = i_operator, exp1 = i_exp1, exp2 = i_exp2),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpBinary(txt, i_operator, i_exp1, i_exp2, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.IFEXP(expCond = i_expCond, expThen = i_expThen, expElse = i_expElse),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpIf(txt, i_expCond, i_expThen, i_expElse, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.RELATION(operator = i_operator, index = i_index, exp1 = i_exp1, exp2 = i_exp2),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRelation(txt, i_operator, i_index, i_exp1, i_exp2, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CALL(path = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCall(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.RECORD(path = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRecord(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.ASUB(exp = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpAsub(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.MATRIX(ty = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMatrix(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.RANGE(ty = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRange(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = _),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Asub not supported yet"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.TSUB(exp = _),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Tsub not supported yet"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.REDUCTION(reductionInfo = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpReduction(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.ARRAY(ty = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpArray(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.SIZE(exp = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSize(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.SHARED_LITERAL(index = _)),
           a_context,
           a_preExp,
           a_varDecls,
           _ )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSharedLiteral(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown exp:"));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 4841, 14), Tpl.textString(txt_0));
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExp;

protected function fun_751
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_step;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_step, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_stepExp;

    case ( txt,
           SOME(i_stepExp),
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_stepExp, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_751;

public function daeExpRange
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Option<DAE.Exp> i_step;
      DAE.Exp i_stop;
      DAE.Exp i_start;
      DAE.Type i_ty;
      Tpl.Text l_step__exp;
      Tpl.Text txt_4;
      Tpl.Text l_tmp;
      Tpl.Text l_stop__exp;
      Tpl.Text l_start__exp;
      Tpl.Text l_ty__str;

    case ( txt,
           DAE.RANGE(ty = i_ty, start = i_start, stop = i_stop, step = i_step),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_ty__str = expTypeArray(Tpl.emptyTxt, i_ty);
        (l_start__exp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_start, a_context, a_preExp, a_varDecls, a_simCode);
        (l_stop__exp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_stop, a_context, a_preExp, a_varDecls, a_simCode);
        txt_4 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("multi_array<"));
        txt_4 = Tpl.writeText(txt_4, l_ty__str);
        txt_4 = Tpl.writeTok(txt_4, Tpl.ST_STRING(",1>"));
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_4), a_varDecls);
        (l_step__exp, a_varDecls, a_preExp) = fun_751(Tpl.emptyTxt, i_step, a_simCode, a_varDecls, a_preExp, a_context);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("int num_elems =("));
        a_preExp = Tpl.writeText(a_preExp, l_stop__exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("-"));
        a_preExp = Tpl.writeText(a_preExp, l_start__exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeText(a_preExp, l_step__exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("+1;\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(4));
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(".resize((boost::extents[num_elems]));\n"));
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ".reindex(1);\n",
                                              "for(int i= 1;i<=num_elems;i++)\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(4));
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("[i] ="));
        a_preExp = Tpl.writeText(a_preExp, l_start__exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("+(i-1)*"));
        a_preExp = Tpl.writeText(a_preExp, l_step__exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(";\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpRange;

protected function fun_753
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_tmpVarDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmpVarDecls;
algorithm
  (out_txt, out_a_tmpVarDecls) :=
  match(in_txt, in_mArg, in_a_tmpVarDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_tmpVarDecls;

    case ( txt,
           "modelica_metatype",
           a_tmpVarDecls )
      then (txt, a_tmpVarDecls);

    case ( txt,
           _,
           a_tmpVarDecls )
      equation
        (txt, a_tmpVarDecls) = tempDecl(txt, "int", a_tmpVarDecls);
      then (txt, a_tmpVarDecls);
  end match;
end fun_753;

protected function fun_754
  input Tpl.Text in_txt;
  input Absyn.Path in_a_ri_path;
  input Tpl.Text in_a_tmpVarDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmpVarDecls;
algorithm
  (out_txt, out_a_tmpVarDecls) :=
  match(in_txt, in_a_ri_path, in_a_tmpVarDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_tmpVarDecls;

    case ( txt,
           Absyn.IDENT(name = "array"),
           a_tmpVarDecls )
      equation
        (txt, a_tmpVarDecls) = tempDecl(txt, "int", a_tmpVarDecls);
      then (txt, a_tmpVarDecls);

    case ( txt,
           _,
           a_tmpVarDecls )
      then (txt, a_tmpVarDecls);
  end match;
end fun_754;

protected function fun_755
  input Tpl.Text in_txt;
  input Option<Values.Value> in_a_ri_defaultValue;
  input Tpl.Text in_a_tmpVarDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmpVarDecls;
algorithm
  (out_txt, out_a_tmpVarDecls) :=
  match(in_txt, in_a_ri_defaultValue, in_a_tmpVarDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_tmpVarDecls;

    case ( txt,
           NONE(),
           a_tmpVarDecls )
      equation
        (txt, a_tmpVarDecls) = tempDecl(txt, "int", a_tmpVarDecls);
      then (txt, a_tmpVarDecls);

    case ( txt,
           _,
           a_tmpVarDecls )
      then (txt, a_tmpVarDecls);
  end match;
end fun_755;

protected function fun_756
  input Tpl.Text in_txt;
  input Absyn.Path in_a_ri_path;
  input Tpl.Text in_a_tmpVarDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmpVarDecls;
algorithm
  (out_txt, out_a_tmpVarDecls) :=
  match(in_txt, in_a_ri_path, in_a_tmpVarDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_tmpVarDecls;

    case ( txt,
           Absyn.IDENT(name = "list"),
           a_tmpVarDecls )
      equation
        (txt, a_tmpVarDecls) = tempDecl(txt, "modelica_metatype*", a_tmpVarDecls);
      then (txt, a_tmpVarDecls);

    case ( txt,
           _,
           a_tmpVarDecls )
      then (txt, a_tmpVarDecls);
  end match;
end fun_756;

protected function fun_757
  input Tpl.Text in_txt;
  input Option<Values.Value> in_a_ri_defaultValue;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_tmpVarDecls;
  input Tpl.Text in_a_preDefault;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmpVarDecls;
  output Tpl.Text out_a_preDefault;
algorithm
  (out_txt, out_a_tmpVarDecls, out_a_preDefault) :=
  match(in_txt, in_a_ri_defaultValue, in_a_simCode, in_a_tmpVarDecls, in_a_preDefault, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_tmpVarDecls;
      Tpl.Text a_preDefault;
      SimCode.Context a_context;
      Values.Value i_v;
      DAE.Exp ret_0;

    case ( txt,
           SOME(i_v),
           a_simCode,
           a_tmpVarDecls,
           a_preDefault,
           a_context )
      equation
        ret_0 = ValuesUtil.valueExp(i_v);
        (txt, a_preDefault, a_tmpVarDecls) = daeExp(txt, ret_0, a_context, a_preDefault, a_tmpVarDecls, a_simCode);
      then (txt, a_tmpVarDecls, a_preDefault);

    case ( txt,
           _,
           _,
           a_tmpVarDecls,
           a_preDefault,
           _ )
      then (txt, a_tmpVarDecls, a_preDefault);
  end match;
end fun_757;

protected function fun_758
  input Tpl.Text in_txt;
  input Absyn.Path in_a_ri_path;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_tmpVarDecls;
  input Tpl.Text in_a_preDefault;
  input SimCode.Context in_a_context;
  input Option<Values.Value> in_a_ri_defaultValue;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmpVarDecls;
  output Tpl.Text out_a_preDefault;
algorithm
  (out_txt, out_a_tmpVarDecls, out_a_preDefault) :=
  match(in_txt, in_a_ri_path, in_a_simCode, in_a_tmpVarDecls, in_a_preDefault, in_a_context, in_a_ri_defaultValue)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_tmpVarDecls;
      Tpl.Text a_preDefault;
      SimCode.Context a_context;
      Option<Values.Value> a_ri_defaultValue;

    case ( txt,
           Absyn.IDENT(name = "array"),
           _,
           a_tmpVarDecls,
           a_preDefault,
           _,
           _ )
      then (txt, a_tmpVarDecls, a_preDefault);

    case ( txt,
           _,
           a_simCode,
           a_tmpVarDecls,
           a_preDefault,
           a_context,
           a_ri_defaultValue )
      equation
        (txt, a_tmpVarDecls, a_preDefault) = fun_757(txt, a_ri_defaultValue, a_simCode, a_tmpVarDecls, a_preDefault, a_context);
      then (txt, a_tmpVarDecls, a_preDefault);
  end match;
end fun_758;

protected function fun_759
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_iter_guardExp;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_tmpVarDecls;
  input Tpl.Text in_a_guardExpPre;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmpVarDecls;
  output Tpl.Text out_a_guardExpPre;
algorithm
  (out_txt, out_a_tmpVarDecls, out_a_guardExpPre) :=
  match(in_txt, in_a_iter_guardExp, in_a_simCode, in_a_tmpVarDecls, in_a_guardExpPre, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_tmpVarDecls;
      Tpl.Text a_guardExpPre;
      SimCode.Context a_context;
      DAE.Exp i_grd;

    case ( txt,
           SOME(i_grd),
           a_simCode,
           a_tmpVarDecls,
           a_guardExpPre,
           a_context )
      equation
        (txt, a_guardExpPre, a_tmpVarDecls) = daeExp(txt, i_grd, a_context, a_guardExpPre, a_tmpVarDecls, a_simCode);
      then (txt, a_tmpVarDecls, a_guardExpPre);

    case ( txt,
           _,
           _,
           a_tmpVarDecls,
           a_guardExpPre,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then (txt, a_tmpVarDecls, a_guardExpPre);
  end match;
end fun_759;

protected function fun_760
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_loopVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_loopVar)
    local
      Tpl.Text txt;
      Tpl.Text a_loopVar;

    case ( txt,
           "modelica_metatype",
           a_loopVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("listEmpty("));
        txt = Tpl.writeText(txt, a_loopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_loopVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0 == "));
        txt = Tpl.writeText(txt, a_loopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".shape()[0]"));
      then txt;
  end match;
end fun_760;

protected function fun_761
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_loopVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_loopVar)
    local
      Tpl.Text txt;
      Tpl.Text a_loopVar;

    case ( txt,
           "modelica_metatype",
           a_loopVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("listLength("));
        txt = Tpl.writeText(txt, a_loopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_loopVar )
      equation
        txt = Tpl.writeText(txt, a_loopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".shape()[0]"));
      then txt;
  end match;
end fun_761;

protected function fun_762
  input Tpl.Text in_txt;
  input Option<Values.Value> in_a_ri_defaultValue;
  input Tpl.Text in_a_reductionBodyExpr;
  input Tpl.Text in_a_fExpStr;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_foundFirst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ri_defaultValue, in_a_reductionBodyExpr, in_a_fExpStr, in_a_res, in_a_foundFirst)
    local
      Tpl.Text txt;
      Tpl.Text a_reductionBodyExpr;
      Tpl.Text a_fExpStr;
      Tpl.Text a_res;
      Tpl.Text a_foundFirst;

    case ( txt,
           NONE(),
           a_reductionBodyExpr,
           a_fExpStr,
           a_res,
           a_foundFirst )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if("));
        txt = Tpl.writeText(txt, a_foundFirst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_fExpStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "else\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_reductionBodyExpr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, a_foundFirst);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" = 1;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           a_fExpStr,
           a_res,
           _ )
      equation
        txt = Tpl.writeText(txt, a_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_fExpStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_762;

protected function fun_763
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_ri_foldExp;
  input Tpl.Text in_a_reductionBodyExpr;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_foundFirst;
  input Option<Values.Value> in_a_ri_defaultValue;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_tmpVarDecls;
  input Tpl.Text in_a_bodyExpPre;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmpVarDecls;
  output Tpl.Text out_a_bodyExpPre;
algorithm
  (out_txt, out_a_tmpVarDecls, out_a_bodyExpPre) :=
  match(in_txt, in_a_ri_foldExp, in_a_reductionBodyExpr, in_a_res, in_a_foundFirst, in_a_ri_defaultValue, in_a_simCode, in_a_tmpVarDecls, in_a_bodyExpPre, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_reductionBodyExpr;
      Tpl.Text a_res;
      Tpl.Text a_foundFirst;
      Option<Values.Value> a_ri_defaultValue;
      SimCode.SimCode a_simCode;
      Tpl.Text a_tmpVarDecls;
      Tpl.Text a_bodyExpPre;
      SimCode.Context a_context;
      DAE.Exp i_fExp;
      Tpl.Text l_fExpStr;
      Tpl.Text l_foldExpPre;

    case ( txt,
           SOME(i_fExp),
           a_reductionBodyExpr,
           a_res,
           a_foundFirst,
           a_ri_defaultValue,
           a_simCode,
           a_tmpVarDecls,
           a_bodyExpPre,
           a_context )
      equation
        l_foldExpPre = Tpl.emptyTxt;
        (l_fExpStr, a_bodyExpPre, a_tmpVarDecls) = daeExp(Tpl.emptyTxt, i_fExp, a_context, a_bodyExpPre, a_tmpVarDecls, a_simCode);
        txt = fun_762(txt, a_ri_defaultValue, a_reductionBodyExpr, l_fExpStr, a_res, a_foundFirst);
      then (txt, a_tmpVarDecls, a_bodyExpPre);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           a_tmpVarDecls,
           a_bodyExpPre,
           _ )
      then (txt, a_tmpVarDecls, a_bodyExpPre);
  end match;
end fun_763;

protected function fun_764
  input Tpl.Text in_txt;
  input Absyn.Path in_a_ri_path;
  input Tpl.Text in_a_foundFirst;
  input Option<Values.Value> in_a_ri_defaultValue;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_tmpVarDecls;
  input Tpl.Text in_a_bodyExpPre;
  input SimCode.Context in_a_context;
  input Option<DAE.Exp> in_a_ri_foldExp;
  input Tpl.Text in_a_arrIndex;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_reductionBodyExpr;
  input Tpl.Text in_a_resTail;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmpVarDecls;
  output Tpl.Text out_a_bodyExpPre;
algorithm
  (out_txt, out_a_tmpVarDecls, out_a_bodyExpPre) :=
  match(in_txt, in_a_ri_path, in_a_foundFirst, in_a_ri_defaultValue, in_a_simCode, in_a_tmpVarDecls, in_a_bodyExpPre, in_a_context, in_a_ri_foldExp, in_a_arrIndex, in_a_res, in_a_reductionBodyExpr, in_a_resTail)
    local
      Tpl.Text txt;
      Tpl.Text a_foundFirst;
      Option<Values.Value> a_ri_defaultValue;
      SimCode.SimCode a_simCode;
      Tpl.Text a_tmpVarDecls;
      Tpl.Text a_bodyExpPre;
      SimCode.Context a_context;
      Option<DAE.Exp> a_ri_foldExp;
      Tpl.Text a_arrIndex;
      Tpl.Text a_res;
      Tpl.Text a_reductionBodyExpr;
      Tpl.Text a_resTail;

    case ( txt,
           Absyn.IDENT(name = "list"),
           _,
           _,
           _,
           a_tmpVarDecls,
           a_bodyExpPre,
           _,
           _,
           _,
           _,
           a_reductionBodyExpr,
           a_resTail )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
        txt = Tpl.writeText(txt, a_resTail);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = mmc_mk_cons("));
        txt = Tpl.writeText(txt, a_reductionBodyExpr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",0);\n"));
        txt = Tpl.writeText(txt, a_resTail);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = &MMC_CDR(*"));
        txt = Tpl.writeText(txt, a_resTail);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_tmpVarDecls, a_bodyExpPre);

    case ( txt,
           Absyn.IDENT(name = "listReverse"),
           _,
           _,
           _,
           a_tmpVarDecls,
           a_bodyExpPre,
           _,
           _,
           _,
           a_res,
           a_reductionBodyExpr,
           _ )
      equation
        txt = Tpl.writeText(txt, a_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = mmc_mk_cons("));
        txt = Tpl.writeText(txt, a_reductionBodyExpr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_tmpVarDecls, a_bodyExpPre);

    case ( txt,
           Absyn.IDENT(name = "array"),
           _,
           _,
           _,
           a_tmpVarDecls,
           a_bodyExpPre,
           _,
           _,
           a_arrIndex,
           a_res,
           a_reductionBodyExpr,
           _ )
      equation
        txt = Tpl.writeText(txt, a_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, a_arrIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("++] = "));
        txt = Tpl.writeText(txt, a_reductionBodyExpr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_tmpVarDecls, a_bodyExpPre);

    case ( txt,
           _,
           a_foundFirst,
           a_ri_defaultValue,
           a_simCode,
           a_tmpVarDecls,
           a_bodyExpPre,
           a_context,
           a_ri_foldExp,
           _,
           a_res,
           a_reductionBodyExpr,
           _ )
      equation
        (txt, a_tmpVarDecls, a_bodyExpPre) = fun_763(txt, a_ri_foldExp, a_reductionBodyExpr, a_res, a_foundFirst, a_ri_defaultValue, a_simCode, a_tmpVarDecls, a_bodyExpPre, a_context);
      then (txt, a_tmpVarDecls, a_bodyExpPre);
  end match;
end fun_764;

protected function fun_765
  input Tpl.Text in_txt;
  input Option<Values.Value> in_a_ri_defaultValue;
  input Tpl.Text in_a_defaultValue;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_preDefault;
  input Absyn.Path in_a_ri_path;
  input Tpl.Text in_a_foundFirst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ri_defaultValue, in_a_defaultValue, in_a_res, in_a_preDefault, in_a_ri_path, in_a_foundFirst)
    local
      Tpl.Text txt;
      Tpl.Text a_defaultValue;
      Tpl.Text a_res;
      Tpl.Text a_preDefault;
      Absyn.Path a_ri_path;
      Tpl.Text a_foundFirst;

    case ( txt,
           NONE(),
           _,
           _,
           _,
           a_ri_path,
           a_foundFirst )
      equation
        txt = Tpl.writeText(txt, a_foundFirst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0; /* "));
        txt = dotPath(txt, a_ri_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" lacks default-value */"));
      then txt;

    case ( txt,
           _,
           a_defaultValue,
           a_res,
           a_preDefault,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, a_preDefault);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* defaultValue */"));
      then txt;
  end match;
end fun_765;

protected function fun_766
  input Tpl.Text in_txt;
  input Absyn.Path in_a_ri_path;
  input Tpl.Text in_a_defaultValue;
  input Tpl.Text in_a_preDefault;
  input Tpl.Text in_a_foundFirst;
  input Option<Values.Value> in_a_ri_defaultValue;
  input Tpl.Text in_a_length;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_arrayTypeResult;
  input Tpl.Text in_a_arrIndex;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ri_path, in_a_defaultValue, in_a_preDefault, in_a_foundFirst, in_a_ri_defaultValue, in_a_length, in_a_res, in_a_arrayTypeResult, in_a_arrIndex)
    local
      Tpl.Text txt;
      Tpl.Text a_defaultValue;
      Tpl.Text a_preDefault;
      Tpl.Text a_foundFirst;
      Option<Values.Value> a_ri_defaultValue;
      Tpl.Text a_length;
      Tpl.Text a_res;
      Tpl.Text a_arrayTypeResult;
      Tpl.Text a_arrIndex;
      Absyn.Path i_ri_path;

    case ( txt,
           Absyn.IDENT(name = "array"),
           _,
           _,
           _,
           _,
           a_length,
           a_res,
           a_arrayTypeResult,
           a_arrIndex )
      equation
        txt = Tpl.writeText(txt, a_arrIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " = 1;\n",
                                    "simple_alloc_1d_"
                                }, false));
        txt = Tpl.writeText(txt, a_arrayTypeResult);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeText(txt, a_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_length);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           i_ri_path,
           a_defaultValue,
           a_preDefault,
           a_foundFirst,
           a_ri_defaultValue,
           _,
           a_res,
           _,
           _ )
      equation
        txt = fun_765(txt, a_ri_defaultValue, a_defaultValue, a_res, a_preDefault, i_ri_path, a_foundFirst);
      then txt;
  end match;
end fun_766;

protected function fun_767
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_firstIndex;
  input Tpl.Text in_a_loopVar;
  input Tpl.Text in_a_iteratorName;
  input Tpl.Text in_a_identType;
  input Tpl.Text in_a_empty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_firstIndex, in_a_loopVar, in_a_iteratorName, in_a_identType, in_a_empty)
    local
      Tpl.Text txt;
      Tpl.Text a_firstIndex;
      Tpl.Text a_loopVar;
      Tpl.Text a_iteratorName;
      Tpl.Text a_identType;
      Tpl.Text a_empty;

    case ( txt,
           "modelica_metatype",
           _,
           a_loopVar,
           a_iteratorName,
           a_identType,
           a_empty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("while(!"));
        txt = Tpl.writeText(txt, a_empty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_identType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_iteratorName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, a_iteratorName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = MMC_CAR("));
        txt = Tpl.writeText(txt, a_loopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.writeText(txt, a_loopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = MMC_CDR("));
        txt = Tpl.writeText(txt, a_loopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           a_firstIndex,
           a_loopVar,
           a_iteratorName,
           a_identType,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("while("));
        txt = Tpl.writeText(txt, a_firstIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_loopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".shape()[0])\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_identType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_iteratorName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, a_iteratorName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_loopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, a_firstIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "++];\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_767;

protected function fun_768
  input Tpl.Text in_txt;
  input DAE.Type in_mArg;
  input Tpl.Text in_a_rangeExp;
  input Tpl.Text in_a_loopVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_rangeExp, in_a_loopVar)
    local
      Tpl.Text txt;
      Tpl.Text a_rangeExp;
      Tpl.Text a_loopVar;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           a_rangeExp,
           a_loopVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assign_array( "));
        txt = Tpl.writeText(txt, a_loopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_rangeExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_rangeExp,
           a_loopVar )
      equation
        txt = Tpl.writeText(txt, a_loopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_rangeExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_768;

protected function fun_769
  input Tpl.Text in_txt;
  input Tpl.Text in_a_firstIndex;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_firstIndex)
    local
      Tpl.Text txt;
      Tpl.Text i_firstIndex;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_firstIndex )
      equation
        txt = Tpl.writeText(txt, i_firstIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 1;"));
      then txt;
  end match;
end fun_769;

protected function fun_770
  input Tpl.Text in_txt;
  input Tpl.Text in_a_resTail;
  input Tpl.Text in_a_res;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_resTail, in_a_res)
    local
      Tpl.Text txt;
      Tpl.Text a_res;
      Tpl.Text i_resTail;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           i_resTail,
           a_res )
      equation
        txt = Tpl.writeText(txt, i_resTail);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = &"));
        txt = Tpl.writeText(txt, a_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_770;

protected function fun_771
  input Tpl.Text in_txt;
  input Option<Values.Value> in_a_ri_defaultValue;
  input Tpl.Text in_a_foundFirst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ri_defaultValue, in_a_foundFirst)
    local
      Tpl.Text txt;
      Tpl.Text a_foundFirst;

    case ( txt,
           NONE(),
           a_foundFirst )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (!"));
        txt = Tpl.writeText(txt, a_foundFirst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") MMC_THROW();"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_771;

protected function fun_772
  input Tpl.Text in_txt;
  input Tpl.Text in_a_resTail;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_resTail)
    local
      Tpl.Text txt;
      Tpl.Text i_resTail;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_resTail )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
        txt = Tpl.writeText(txt, i_resTail);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = mmc_mk_nil();"));
      then txt;
  end match;
end fun_772;

public function daeExpReduction
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Exp i_exp;
      String i_iter_id;
      Option<DAE.Exp> i_ri_foldExp;
      DAE.Exp i_r_expr;
      Option<DAE.Exp> i_iter_guardExp;
      Option<Values.Value> i_ri_defaultValue;
      Absyn.Path i_ri_path;
      DAE.Exp i_r;
      DAE.Exp i_iter_exp;
      Tpl.Text txt_40;
      String ret_40;
      DAE.Type ret_39;
      Tpl.Text l_loopvarassign;
      Tpl.Text l_loopTail;
      String str_36;
      Tpl.Text l_loopHead;
      Tpl.Text l_iteratorName;
      Tpl.Text l_firstValue;
      Tpl.Text l_foldExp;
      Tpl.Text l_reductionBodyExprWork;
      DAE.Type ret_30;
      Tpl.Text l_bodyExprType;
      DAE.ComponentRef ret_28;
      Tpl.Text l_reductionBodyExpr;
      String str_26;
      Tpl.Text l_length;
      String str_24;
      Tpl.Text l_empty;
      Tpl.Text l_guardCond;
      Tpl.Text l_defaultValue;
      Tpl.Text l_resTail;
      Tpl.Text l_preDefault;
      Tpl.Text l_resTmp;
      DAE.ComponentRef ret_17;
      Tpl.Text l_res;
      DAE.Type ret_15;
      Tpl.Text l_resType;
      Tpl.Text l_rangeExp;
      Tpl.Text l_foundFirst;
      Tpl.Text l_arrIndex;
      String str_10;
      Tpl.Text l_firstIndex;
      Tpl.Text l_arrayTypeResult;
      Tpl.Text l_loopVar;
      Tpl.Text l_arrayType;
      Tpl.Text l_identType;
      Tpl.Text l_rangeExpPre;
      Tpl.Text l_guardExpPre;
      Tpl.Text l_bodyExpPre;
      Tpl.Text l_tmpExpPre;
      Tpl.Text l_tmpVarDecls;

    case ( txt,
           (i_r as DAE.REDUCTION(reductionInfo = DAE.REDUCTIONINFO(path = i_ri_path, defaultValue = i_ri_defaultValue, foldExp = i_ri_foldExp), iterators = {DAE.REDUCTIONITER(exp = i_iter_exp, guardExp = i_iter_guardExp, id = i_iter_id)}, expr = i_r_expr)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_tmpVarDecls = Tpl.emptyTxt;
        l_tmpExpPre = Tpl.emptyTxt;
        l_bodyExpPre = Tpl.emptyTxt;
        l_guardExpPre = Tpl.emptyTxt;
        l_rangeExpPre = Tpl.emptyTxt;
        l_identType = expTypeFromExpModelica(Tpl.emptyTxt, i_iter_exp);
        l_arrayType = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Test"));
        (l_loopVar, l_rangeExpPre, l_tmpVarDecls) = expTypeFromExpArrayIf(Tpl.emptyTxt, i_iter_exp, a_context, l_rangeExpPre, l_tmpVarDecls, a_simCode);
        l_arrayTypeResult = expTypeFromExpArray(Tpl.emptyTxt, i_r);
        str_10 = Tpl.textString(l_identType);
        (l_firstIndex, l_tmpVarDecls) = fun_753(Tpl.emptyTxt, str_10, l_tmpVarDecls);
        (l_arrIndex, l_tmpVarDecls) = fun_754(Tpl.emptyTxt, i_ri_path, l_tmpVarDecls);
        (l_foundFirst, l_tmpVarDecls) = fun_755(Tpl.emptyTxt, i_ri_defaultValue, l_tmpVarDecls);
        (l_rangeExp, l_rangeExpPre, l_tmpVarDecls) = daeExp(Tpl.emptyTxt, i_iter_exp, a_context, l_rangeExpPre, l_tmpVarDecls, a_simCode);
        ret_15 = Expression.typeof(i_r);
        l_resType = expTypeArrayIf(Tpl.emptyTxt, ret_15);
        ret_17 = ComponentReference.makeUntypedCrefIdent("$reductionFoldTmpB");
        l_res = contextCref(Tpl.emptyTxt, ret_17, a_context, a_simCode);
        l_tmpVarDecls = Tpl.writeText(l_tmpVarDecls, l_resType);
        l_tmpVarDecls = Tpl.writeTok(l_tmpVarDecls, Tpl.ST_STRING(" "));
        l_tmpVarDecls = Tpl.writeText(l_tmpVarDecls, l_res);
        l_tmpVarDecls = Tpl.writeTok(l_tmpVarDecls, Tpl.ST_STRING(";"));
        l_tmpVarDecls = Tpl.writeTok(l_tmpVarDecls, Tpl.ST_NEW_LINE());
        (l_resTmp, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_resType), a_varDecls);
        l_preDefault = Tpl.emptyTxt;
        (l_resTail, l_tmpVarDecls) = fun_756(Tpl.emptyTxt, i_ri_path, l_tmpVarDecls);
        (l_defaultValue, l_tmpVarDecls, l_preDefault) = fun_758(Tpl.emptyTxt, i_ri_path, a_simCode, l_tmpVarDecls, l_preDefault, a_context, i_ri_defaultValue);
        (l_guardCond, l_tmpVarDecls, l_guardExpPre) = fun_759(Tpl.emptyTxt, i_iter_guardExp, a_simCode, l_tmpVarDecls, l_guardExpPre, a_context);
        str_24 = Tpl.textString(l_identType);
        l_empty = fun_760(Tpl.emptyTxt, str_24, l_loopVar);
        str_26 = Tpl.textString(l_identType);
        l_length = fun_761(Tpl.emptyTxt, str_26, l_loopVar);
        ret_28 = ComponentReference.makeUntypedCrefIdent("$reductionFoldTmpA");
        l_reductionBodyExpr = contextCref(Tpl.emptyTxt, ret_28, a_context, a_simCode);
        ret_30 = Expression.typeof(i_r_expr);
        l_bodyExprType = expTypeArrayIf(Tpl.emptyTxt, ret_30);
        (l_reductionBodyExprWork, l_bodyExpPre, l_tmpVarDecls) = daeExp(Tpl.emptyTxt, i_r_expr, a_context, l_bodyExpPre, l_tmpVarDecls, a_simCode);
        l_tmpVarDecls = Tpl.writeText(l_tmpVarDecls, l_bodyExprType);
        l_tmpVarDecls = Tpl.writeTok(l_tmpVarDecls, Tpl.ST_STRING(" "));
        l_tmpVarDecls = Tpl.writeText(l_tmpVarDecls, l_reductionBodyExpr);
        l_tmpVarDecls = Tpl.writeTok(l_tmpVarDecls, Tpl.ST_STRING(";"));
        l_tmpVarDecls = Tpl.writeTok(l_tmpVarDecls, Tpl.ST_NEW_LINE());
        l_bodyExpPre = Tpl.writeText(l_bodyExpPre, l_reductionBodyExpr);
        l_bodyExpPre = Tpl.writeTok(l_bodyExpPre, Tpl.ST_STRING(" = "));
        l_bodyExpPre = Tpl.writeText(l_bodyExpPre, l_reductionBodyExprWork);
        l_bodyExpPre = Tpl.writeTok(l_bodyExpPre, Tpl.ST_STRING(";"));
        l_bodyExpPre = Tpl.writeTok(l_bodyExpPre, Tpl.ST_NEW_LINE());
        (l_foldExp, l_tmpVarDecls, l_bodyExpPre) = fun_764(Tpl.emptyTxt, i_ri_path, l_foundFirst, i_ri_defaultValue, a_simCode, l_tmpVarDecls, l_bodyExpPre, a_context, i_ri_foldExp, l_arrIndex, l_res, l_reductionBodyExpr, l_resTail);
        l_firstValue = fun_766(Tpl.emptyTxt, i_ri_path, l_defaultValue, l_preDefault, l_foundFirst, i_ri_defaultValue, l_length, l_res, l_arrayTypeResult, l_arrIndex);
        l_iteratorName = contextIteratorName(Tpl.emptyTxt, i_iter_id, a_context);
        str_36 = Tpl.textString(l_identType);
        l_loopHead = fun_767(Tpl.emptyTxt, str_36, l_firstIndex, l_loopVar, l_iteratorName, l_identType, l_empty);
        l_loopTail = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("}"));
        ret_39 = Expression.typeof(i_iter_exp);
        l_loopvarassign = fun_768(Tpl.emptyTxt, ret_39, l_rangeExp, l_loopVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("{\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_tmpVarDecls);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_rangeExpPre);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_loopvarassign);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = fun_769(a_preExp, l_firstIndex);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_firstValue);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = fun_770(a_preExp, l_resTail, l_res);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_loopHead);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_guardExpPre);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("if("));
        a_preExp = Tpl.writeText(a_preExp, l_guardCond);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ")\n",
                                              "{\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_bodyExpPre);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_foldExp);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("}\n"));
        a_preExp = Tpl.writeText(a_preExp, l_loopTail);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = fun_771(a_preExp, i_ri_defaultValue, l_foundFirst);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = fun_772(a_preExp, l_resTail);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_resTmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(";\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("}"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_resTmp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt_40 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Code generation does not support multiple iterators: "));
        ret_40 = ExpressionDump.printExpStr(i_exp);
        txt_40 = Tpl.writeStr(txt_40, ret_40);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 4997, 14), Tpl.textString(txt_40));
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpReduction;

public function daeExpSize
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Type i_exp_ty;
      DAE.Exp i_dim;
      DAE.Exp i_exp;
      Tpl.Text l_typeStr;
      Tpl.Text l_resVar;
      Tpl.Text l_dimPart;
      Tpl.Text l_expPart;

    case ( txt,
           DAE.SIZE(exp = (i_exp as DAE.CREF(ty = i_exp_ty)), sz = SOME(i_dim)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        (l_dimPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_dim, a_context, a_preExp, a_varDecls, a_simCode);
        (l_resVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "size_t", a_varDecls);
        l_typeStr = expTypeArray(Tpl.emptyTxt, i_exp_ty);
        a_preExp = Tpl.writeText(a_preExp, l_resVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_expPart);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(".shape()["));
        a_preExp = Tpl.writeText(a_preExp, l_dimPart);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("-1];"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_resVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size(X) not implemented"));
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpSize;

protected function lm_775
  input Tpl.Text in_txt;
  input list<list<DAE.Exp>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_preExp, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<list<DAE.Exp>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      list<DAE.Exp> i_row;
      Tpl.Text l_vars;

    case ( txt,
           {},
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_row :: rest,
           a_simCode,
           a_preExp,
           a_varDecls,
           a_context )
      equation
        (l_vars, a_varDecls, a_preExp) = daeExpMatrixRow(Tpl.emptyTxt, i_row, a_context, a_varDecls, a_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_vars);
        txt = Tpl.nextIter(txt);
        (txt, a_preExp, a_varDecls) = lm_775(txt, rest, a_simCode, a_preExp, a_varDecls, a_context);
      then (txt, a_preExp, a_varDecls);
  end match;
end lm_775;

public function daeExpMatrix
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<list<DAE.Exp>> i_m_matrix;
      list<DAE.Exp> i_row1;
      DAE.Type i_ty;
      Integer ret_10;
      Integer ret_9;
      Tpl.Text l_params;
      Integer ret_7;
      Tpl.Text l_dim__cols;
      Tpl.Text l_vals;
      Tpl.Text l_arrayVar;
      Tpl.Text l_arrayDim;
      Tpl.Text l_tmp;
      Tpl.Text l_arrayTypeStr;
      Tpl.Text l_typestr;

    case ( txt,
           DAE.MATRIX(matrix = {{}}, ty = i_ty),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        l_typestr = expTypeArray(Tpl.emptyTxt, i_ty);
        l_arrayTypeStr = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("boost::multi_array<"));
        l_arrayTypeStr = Tpl.writeText(l_arrayTypeStr, l_typestr);
        l_arrayTypeStr = Tpl.writeTok(l_arrayTypeStr, Tpl.ST_STRING(",2>"));
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayTypeStr), a_varDecls);
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MATRIX(matrix = {}, ty = i_ty),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        l_typestr = expTypeArray(Tpl.emptyTxt, i_ty);
        l_arrayTypeStr = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("boost::multi_array<"));
        l_arrayTypeStr = Tpl.writeText(l_arrayTypeStr, l_typestr);
        l_arrayTypeStr = Tpl.writeTok(l_arrayTypeStr, Tpl.ST_STRING(",2>"));
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayTypeStr), a_varDecls);
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MATRIX(matrix = (i_m_matrix as i_row1 :: _), ty = i_ty),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_arrayTypeStr = expTypeArray(Tpl.emptyTxt, i_ty);
        l_arrayDim = expTypeArrayforDim(Tpl.emptyTxt, i_ty);
        l_tmp = Tpl.emptyTxt;
        (l_arrayVar, l_tmp) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayTypeStr), l_tmp);
        l_vals = Tpl.emptyTxt;
        ret_7 = listLength(i_row1);
        l_dim__cols = Tpl.writeStr(Tpl.emptyTxt, intString(ret_7));
        l_params = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_params, a_preExp, a_varDecls) = lm_775(l_params, i_m_matrix, a_simCode, a_preExp, a_varDecls, a_context);
        l_params = Tpl.popIter(l_params);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(5));
        a_preExp = Tpl.writeText(a_preExp, l_arrayDim);
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(boost::extents["));
        ret_9 = listLength(i_m_matrix);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_9));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("]["));
        a_preExp = Tpl.writeText(a_preExp, l_dim__cols);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("]);\n"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(".reindex(1);\n"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayTypeStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" "));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_data[]={"));
        a_preExp = Tpl.writeText(a_preExp, l_params);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("};\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(4));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(".assign("));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_data,"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_data+ ("));
        ret_10 = listLength(i_m_matrix);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_10));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" * "));
        a_preExp = Tpl.writeText(a_preExp, l_dim__cols);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("));"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, l_arrayVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpMatrix;

protected function lm_777
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_e;
      Tpl.Text l_expVar;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_e :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_expVar, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_expVar);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_777(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_777;

public function daeExpMatrixRow
  input Tpl.Text txt;
  input list<DAE.Exp> a_row;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_preExp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
protected
  Tpl.Text l_varLstStr;
algorithm
  l_varLstStr := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_varLstStr, out_a_varDecls, out_a_preExp) := lm_777(l_varLstStr, a_row, a_simCode, a_varDecls, a_preExp, a_context);
  l_varLstStr := Tpl.popIter(l_varLstStr);
  out_txt := Tpl.writeText(txt, l_varLstStr);
end daeExpMatrixRow;

protected function lm_779
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_e;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_e :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_779(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_779;

public function daeExpArray
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<DAE.Exp> i_array;
      DAE.Type i_ty;
      Integer ret_7;
      Integer ret_6;
      Tpl.Text l_params;
      Tpl.Text l_tmpVar;
      Tpl.Text l_arrayVar;
      Tpl.Text l_tmpdecl;
      Tpl.Text l_arrayDim;
      Tpl.Text l_arrayTypeStr;

    case ( txt,
           DAE.ARRAY(ty = i_ty, array = i_array),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_arrayTypeStr = expTypeArray(Tpl.emptyTxt, i_ty);
        l_arrayDim = expTypeArrayforDim(Tpl.emptyTxt, i_ty);
        l_tmpdecl = Tpl.emptyTxt;
        (l_arrayVar, l_tmpdecl) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayTypeStr), l_tmpdecl);
        l_tmpVar = Tpl.emptyTxt;
        l_params = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_params, a_varDecls, a_preExp) = lm_779(l_params, i_array, a_simCode, a_varDecls, a_preExp, a_context);
        l_params = Tpl.popIter(l_params);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              "\n",
                                              "   //tmp array\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(3));
        a_preExp = Tpl.writeText(a_preExp, l_arrayDim);
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(boost::extents["));
        ret_6 = listLength(i_array);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_6));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("]);\n"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(".reindex(1);\n"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayTypeStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" "));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_data[]={"));
        a_preExp = Tpl.writeText(a_preExp, l_params);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("};\n"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(".assign("));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_data,"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_data+"));
        ret_7 = listLength(i_array);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_7));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, l_arrayVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpArray;

protected function fun_781
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inExp;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_inExp, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_idx;
      DAE.Exp i_e;
      Tpl.Text l_idx1;
      Tpl.Text l_e1;

    case ( txt,
           DAE.ASUB(exp = i_e, sub = {i_idx}),
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        (l_idx1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_idx, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_idx1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /* DAE.ASUB */"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_781;

protected function lm_782
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_res;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_res, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_res;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Integer x_i1;
      DAE.Exp i_e;
      Tpl.Text l_v;
      Tpl.Text l_casePreExp;
      Tpl.Text l_caseVarDecls;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_e :: rest,
           a_res,
           a_simCode,
           a_context )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_caseVarDecls = Tpl.emptyTxt;
        l_casePreExp = Tpl.emptyTxt;
        (l_v, l_casePreExp, l_caseVarDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, l_casePreExp, l_caseVarDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(": {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_caseVarDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_casePreExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "break;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_782(txt, rest, a_res, a_simCode, a_context);
      then txt;
  end match;
end lm_782;

protected function fun_783
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input list<DAE.Exp> in_a_subs;
  input DAE.Type in_a_ecr_ty;
  input Tpl.Text in_a_arrName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_subs, in_a_ecr_ty, in_a_arrName)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      list<DAE.Exp> a_subs;
      DAE.Type a_ecr_ty;
      Tpl.Text a_arrName;
      SimCode.Context i_context;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           _,
           a_varDecls,
           a_preExp,
           _,
           _,
           a_arrName )
      equation
        txt = Tpl.writeText(txt, a_arrName);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_context,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_subs,
           a_ecr_ty,
           a_arrName )
      equation
        (txt, a_preExp, a_varDecls) = arrayScalarRhs(txt, a_ecr_ty, a_subs, Tpl.textString(a_arrName), i_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_783;

protected function lm_784
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_index;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_index :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExpASubIndex(txt, i_index, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_784(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_784;

protected function fun_785
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inExp;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_inExp, in_a_simCode, in_a_preExp, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Exp> i_indexes;
      DAE.Exp i_e;
      DAE.Type i_ecr_ty;
      list<DAE.Exp> i_subs;
      DAE.Exp i_ecr;
      list<DAE.Exp> i_exp_array;
      DAE.Exp i_idx;
      DAE.Exp i_exp;
      Tpl.Text txt_12;
      String ret_12;
      Tpl.Text l_expIndexes;
      Tpl.Text l_exp;
      DAE.Exp ret_9;
      Tpl.Text l_arrName;
      Tpl.Text txt_6;
      String ret_6;
      Tpl.Text l_expl;
      Tpl.Text l_idx1;
      Tpl.Text txt_3;
      Tpl.Text l_res;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.ASUB(exp = (i_exp as DAE.ASUB(exp = _))),
           _,
           a_preExp,
           _,
           a_varDecls )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Nested array subscripting *should* have been handled by the routine creating the asub, but for some reason it was not: "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 5125, 11), Tpl.textString(txt_0));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = (i_exp as DAE.ARRAY(scalar = true, array = i_exp_array)), sub = {i_idx}),
           a_simCode,
           a_preExp,
           a_context,
           a_varDecls )
      equation
        txt_3 = expTypeFromExpModelica(Tpl.emptyTxt, i_exp);
        (l_res, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_3), a_varDecls);
        (l_idx1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_idx, a_context, a_preExp, a_varDecls, a_simCode);
        l_expl = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_expl = lm_782(l_expl, i_exp_array, l_res, a_simCode, a_context);
        l_expl = Tpl.popIter(l_expl);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("switch ("));
        a_preExp = Tpl.writeText(a_preExp, l_idx1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(") { /* ASUB */\n"));
        a_preExp = Tpl.writeText(a_preExp, l_expl);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              "default:\n",
                                              "  assert(NULL == \"index out of bounds\");\n",
                                              "}"
                                          }, false));
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = (i_exp as DAE.RANGE(ty = _)), sub = {_}),
           _,
           a_preExp,
           _,
           a_varDecls )
      equation
        txt_6 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("ASUB_EASY_CASE "));
        ret_6 = ExpressionDump.printExpStr(i_exp);
        txt_6 = Tpl.writeStr(txt_6, ret_6);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 5154, 11), Tpl.textString(txt_6));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = (i_ecr as DAE.CREF(ty = i_ecr_ty)), sub = i_subs),
           a_simCode,
           a_preExp,
           a_context,
           a_varDecls )
      equation
        ret_9 = SimCodeUtil.buildCrefExpFromAsub(i_ecr, i_subs);
        (l_arrName, a_preExp, a_varDecls) = daeExpCrefRhs(Tpl.emptyTxt, ret_9, a_context, a_preExp, a_varDecls, a_simCode);
        (txt, a_varDecls, a_preExp) = fun_783(txt, a_context, a_simCode, a_varDecls, a_preExp, i_subs, i_ecr_ty, l_arrName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = i_e, sub = i_indexes),
           a_simCode,
           a_preExp,
           a_context,
           a_varDecls )
      equation
        (l_exp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        l_expIndexes = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_expIndexes, a_varDecls, a_preExp) = lm_784(l_expIndexes, i_indexes, a_simCode, a_varDecls, a_preExp, a_context);
        l_expIndexes = Tpl.popIter(l_expIndexes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")["));
        txt = Tpl.writeText(txt, l_expIndexes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           _,
           a_preExp,
           _,
           a_varDecls )
      equation
        txt_12 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OTHER_ASUB "));
        ret_12 = ExpressionDump.printExpStr(i_exp);
        txt_12 = Tpl.writeStr(txt_12, ret_12);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 5173, 11), Tpl.textString(txt_12));
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_785;

protected function fun_786
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_inExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_inExp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.Exp a_inExp;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;

    case ( txt,
           "metatype",
           a_inExp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_varDecls, a_preExp) = fun_781(txt, a_inExp, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_inExp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = fun_785(txt, a_inExp, a_simCode, a_preExp, a_context, a_varDecls);
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_786;

public function daeExpAsub
  input Tpl.Text txt;
  input DAE.Exp a_inExp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  String str_1;
  Tpl.Text txt_0;
algorithm
  txt_0 := expTypeFromExpShort(Tpl.emptyTxt, a_inExp);
  str_1 := Tpl.textString(txt_0);
  (out_txt, out_a_preExp, out_a_varDecls) := fun_786(txt, str_1, a_inExp, a_context, a_preExp, a_varDecls, a_simCode);
end daeExpAsub;

public function daeExpASubIndex
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Exp i_exp;
      Integer i_index;
      Integer i_integer;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpASubIndex;

protected function lm_789
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_789(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_789;

protected function fun_790
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_dimsValuesStr;
  input String in_a_arrName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_dimsValuesStr, in_a_arrName)
    local
      Tpl.Text txt;
      Tpl.Text a_dimsValuesStr;
      String a_arrName;

    case ( txt,
           "metatype_array",
           a_dimsValuesStr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeStr(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /*arrayScalarRhs*/"));
      then txt;

    case ( txt,
           _,
           a_dimsValuesStr,
           a_arrName )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeStr(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] "));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_790;

public function arrayScalarRhs
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input list<DAE.Exp> a_subs;
  input String a_arrName;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  String str_4;
  Tpl.Text l_dimsValuesStr;
  Integer ret_2;
  Tpl.Text l_dimsLenStr;
  Tpl.Text l_arrayType;
algorithm
  l_arrayType := expTypeArray(Tpl.emptyTxt, a_ty);
  ret_2 := listLength(a_subs);
  l_dimsLenStr := Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
  l_dimsValuesStr := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_dimsValuesStr, out_a_varDecls, out_a_preExp) := lm_789(l_dimsValuesStr, a_subs, a_simCode, a_varDecls, a_preExp, a_context);
  l_dimsValuesStr := Tpl.popIter(l_dimsValuesStr);
  str_4 := Tpl.textString(l_arrayType);
  out_txt := fun_790(txt, str_4, l_dimsValuesStr, a_arrName);
end arrayScalarRhs;

protected function fun_792
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_expVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_ty, in_a_preExp, in_a_exp, in_a_varDecls, in_a_expVar)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      DAE.Exp a_exp;
      Tpl.Text a_varDecls;
      Tpl.Text a_expVar;
      DAE.Type i_ty;
      Tpl.Text l_from;
      Tpl.Text l_to;
      Tpl.Text l_tvar;
      Tpl.Text l_arrayTypeStr;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((int)"));
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((double)"));
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((modelica_integer)"));
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_BOOL(varLst = _),
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((bool)"));
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_ARRAY(ty = i_ty),
           a_preExp,
           a_exp,
           a_varDecls,
           a_expVar )
      equation
        l_arrayTypeStr = expTypeArray(Tpl.emptyTxt, i_ty);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayTypeStr), a_varDecls);
        l_to = expTypeShort(Tpl.emptyTxt, i_ty);
        l_from = expTypeFromExpShort(Tpl.emptyTxt, a_exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("cast_"));
        a_preExp = Tpl.writeText(a_preExp, l_from);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_array_to_"));
        a_preExp = Tpl.writeText(a_preExp, l_to);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, a_expVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /* could not cast, using the variable as it is */"));
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_792;

public function daeExpCast
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Type i_ty;
      DAE.Exp i_exp;
      Tpl.Text l_expVar;

    case ( txt,
           DAE.CAST(exp = i_exp, ty = i_ty),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_expVar, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        (txt, a_preExp, a_varDecls) = fun_792(txt, i_ty, a_preExp, i_exp, a_varDecls, l_expVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpCast;

protected function lm_794
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, String>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_name;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context, in_a_name)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, String>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Tpl.Text a_name;
      DAE.Exp i_exp;
      String i_compn;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_exp, i_compn) :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context,
           a_name )
      equation
        txt = Tpl.writeText(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, i_compn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        (txt, a_varDecls, a_preExp) = lm_794(txt, rest, a_simCode, a_varDecls, a_preExp, a_context, a_name);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_794;

public function daeExpRecord
  input Tpl.Text in_txt;
  input DAE.Exp in_a_rec;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_rec, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<String> i_comp;
      list<DAE.Exp> i_exps;
      Absyn.Path i_path;
      list<tuple<DAE.Exp, String>> ret_3;
      Tpl.Text l_ass;
      Tpl.Text txt_1;
      Tpl.Text l_name;

    case ( txt,
           DAE.RECORD(path = i_path, exps = i_exps, comp = i_comp),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        txt_1 = underscorePath(Tpl.emptyTxt, i_path);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("Type"));
        (l_name, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        ret_3 = List.threadTuple(i_exps, i_comp);
        (l_ass, a_varDecls, a_preExp) = lm_794(Tpl.emptyTxt, ret_3, a_simCode, a_varDecls, a_preExp, a_context, l_name);
        a_preExp = Tpl.writeText(a_preExp, l_ass);
        txt = Tpl.writeText(txt, l_name);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpRecord;

protected function fun_796
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.ALGLOOP_CONTEXT(genInitialisation = false) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_system->initial()"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initial()"));
      then txt;
  end match;
end fun_796;

protected function lm_797
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_797(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_797;

protected function fun_798
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;
  end match;
end fun_798;

protected function fun_799
  input Tpl.Text in_txt;
  input DAE.Type in_a_arg_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arg_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_799;

protected function fun_800
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_var1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_var1)
    local
      Tpl.Text txt;
      Tpl.Text a_var1;

    case ( txt,
           false,
           a_var1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("puts("));
        txt = Tpl.writeText(txt, a_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_var1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("print("));
        txt = Tpl.writeText(txt, a_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_800;

protected function lm_801
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_801(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_801;

protected function lm_802
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_802(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_802;

protected function fun_803
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end match;
end fun_803;

protected function lm_804
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_804(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_804;

protected function fun_805
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end match;
end fun_805;

protected function lm_806
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_806(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_806;

protected function fun_807
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end match;
end fun_807;

protected function lm_808
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_808(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_808;

protected function fun_809
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end match;
end fun_809;

protected function lm_810
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_810(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_810;

protected function fun_811
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end match;
end fun_811;

protected function lm_812
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_812(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_812;

protected function fun_813
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end match;
end fun_813;

protected function lm_814
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_814(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_814;

protected function fun_815
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end match;
end fun_815;

protected function lm_816
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_816(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_816;

protected function lm_817
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_817(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_817;

protected function lm_818
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_818(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_818;

protected function fun_819
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end match;
end fun_819;

protected function lm_820
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_dim;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_dim :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_dim, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_820(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_820;

protected function lm_821
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_array;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_array :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_array, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_821(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_821;

protected function fun_822
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;
  end match;
end fun_822;

protected function lm_823
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_823(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_823;

protected function fun_824
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_argStr;
  input Tpl.Text in_a_funName;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_argStr, in_a_funName, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_argStr;
      Tpl.Text a_funName;
      Tpl.Text a_retVar;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_argStr,
           a_funName,
           a_retVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("array_assign("));
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_argStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("));"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           a_argStr,
           a_funName,
           a_retVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assign_array("));
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ,_functions."));
        txt = Tpl.writeText(txt, a_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_argStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("));"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_824;

protected function lm_825
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_825(txt, rest, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_825;

protected function fun_826
  input Tpl.Text in_txt;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text i_retVar;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_retVar )
      equation
        txt = Tpl.writeText(txt, i_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;
  end match;
end fun_826;

protected function fun_827
  input Tpl.Text in_txt;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text i_retVar;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_retVar )
      equation
        txt = Tpl.writeText(txt, i_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;
  end match;
end fun_827;

protected function fun_828
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_argStr;
  input Tpl.Text in_a_funName;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_argStr, in_a_funName, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_argStr;
      Tpl.Text a_funName;
      Tpl.Text a_retVar;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_argStr,
           a_funName,
           a_retVar )
      equation
        txt = fun_826(txt, a_retVar);
        txt = Tpl.writeText(txt, a_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_argStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           a_argStr,
           a_funName,
           a_retVar )
      equation
        txt = fun_827(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions."));
        txt = Tpl.writeText(txt, a_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_argStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_828;

protected function fun_829
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_funName;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input list<DAE.Exp> in_a_explist;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_mArg, in_a_funName, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context, in_a_explist)
    local
      Tpl.Text txt;
      Tpl.Text a_funName;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      list<DAE.Exp> a_explist;
      Tpl.Text l_retVar;
      Tpl.Text l_retType;
      Tpl.Text l_argStr;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"noName\""));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_funName,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context,
           a_explist )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_825(l_argStr, a_explist, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_retType = Tpl.writeText(Tpl.emptyTxt, a_funName);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("RetType"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = fun_828(a_preExp, a_context, l_argStr, a_funName, l_retVar);
        txt = Tpl.writeText(txt, l_retVar);
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_829;

public function daeExpCall
  input Tpl.Text in_txt;
  input DAE.Exp in_a_call;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_call, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      list<DAE.Exp> i_explist;
      Integer i_i;
      DAE.Exp i_s1;
      DAE.Exp i_toBeCasted;
      DAE.Exp i_delayMax;
      DAE.Exp i_d;
      DAE.Exp i_e;
      DAE.Exp i_signdig;
      DAE.Exp i_leftjust;
      DAE.Exp i_minlen;
      DAE.Exp i_format;
      DAE.Exp i_s;
      DAE.Exp i_v2;
      DAE.Exp i_v1;
      DAE.Exp i_n;
      DAE.Exp i_A;
      list<DAE.Exp> i_arrays;
      DAE.Exp i_dim;
      list<DAE.Exp> i_dims_1;
      DAE.Exp i_val;
      DAE.Exp i_array;
      Boolean i_attr_builtin;
      Absyn.Path i_path;
      DAE.Type i_attr_ty;
      DAE.Exp i_index_1;
      DAE.Exp i_inExp;
      DAE.Type i_arg_ty;
      DAE.Exp i_e3;
      DAE.Dimensions i_dims;
      DAE.Type i_ty;
      list<DAE.Exp> i_expLst;
      String i_string;
      DAE.Exp i_e2;
      Integer i_index;
      DAE.Exp i_interval;
      DAE.Exp i_start;
      DAE.ComponentRef i_arg_componentRef;
      DAE.Exp i_arg;
      DAE.Exp i_e1;
      String str_48;
      Integer ret_47;
      Tpl.Text l_arraytpye;
      Tpl.Text l_expPart;
      Tpl.Text l_castedVar;
      Tpl.Text l_signdigExp;
      Tpl.Text l_leftjustExp;
      Tpl.Text l_minlenExp;
      Tpl.Text l_formatExp;
      Tpl.Text l_sExp;
      Tpl.Text txt_37;
      Integer ret_37;
      Integer ret_36;
      Tpl.Text l_arrays__exp;
      Tpl.Text l_dim__exp;
      Integer ret_33;
      Integer ret_32;
      Tpl.Text l_tmp__type__str;
      Tpl.Text l_ty__str;
      Tpl.Text l_dimsExp;
      Tpl.Text l_valExp;
      Tpl.Text txt_27;
      Tpl.Text txt_26;
      Tpl.Text l_tvar;
      Tpl.Text l_arr__tp__str;
      Tpl.Text l_expVar;
      Tpl.Text l_tmpVar;
      Tpl.Text l_funName;
      Tpl.Text l_constIndex;
      Tpl.Text l_exp;
      Boolean ret_18;
      Tpl.Text l_cast;
      Tpl.Text l_retType;
      Integer ret_15;
      Tpl.Text txt_13;
      Integer ret_13;
      Tpl.Text l_var;
      Tpl.Text l_type;
      Tpl.Text l_retVar;
      Tpl.Text l_typeStr;
      Tpl.Text l_argStr;
      String ret_7;
      Tpl.Text l_var3;
      Tpl.Text l_var2;
      Integer ret_4;
      Tpl.Text l_eInterval;
      Tpl.Text l_eStart;
      Tpl.Text l_preExp;
      Tpl.Text l_var1;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "edge"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.edge("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "pre"), expLst = {(i_arg as DAE.CREF(componentRef = i_arg_componentRef))}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_arg, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.pre("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_arg_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {DAE.ICONST(integer = i_index), i_start, i_interval}),
           _,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_eStart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_start, SimCode.contextOther, l_preExp, a_varDecls, a_simCode);
        (l_eInterval, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_interval, SimCode.contextOther, l_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_time_conditions["));
        ret_4 = intSub(i_index, 1);
        txt = Tpl.writeStr(txt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "initial")),
           a_context,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = fun_796(txt, a_context);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "DIVISION"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("division("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" because "));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  == 0\")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "DIVISION"), expLst = {i_e1, i_e2, DAE.SCONST(string = i_string)}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        ret_7 = Util.escapeModelicaStringToCString(i_string);
        l_var3 = Tpl.writeStr(Tpl.emptyTxt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("division("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = Tpl.writeText(txt, l_var3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sign"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("sgn("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "DIVISION"), expLst = i_expLst),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_797(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_typeStr = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("double"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_typeStr), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = division("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = (i_ty as DAE.T_ARRAY(dims = i_dims))), path = Absyn.IDENT(name = "DIVISION_ARRAY_SCALAR"), expLst = {i_e1, i_e2, (i_e3 as DAE.SHARED_LITERAL(index = _))}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_type = fun_798(Tpl.emptyTxt, i_ty);
        txt_13 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("multi_array<"));
        txt_13 = Tpl.writeText(txt_13, l_type);
        txt_13 = Tpl.writeTok(txt_13, Tpl.ST_STRING(","));
        ret_13 = listLength(i_dims);
        txt_13 = Tpl.writeStr(txt_13, intString(ret_13));
        txt_13 = Tpl.writeTok(txt_13, Tpl.ST_STRING(">"));
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_13), a_varDecls);
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var3, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e3, a_context, a_preExp, a_varDecls, a_simCode);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("assign_array("));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",divide_array<"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(","));
        ret_15 = listLength(i_dims);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_15));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(">("));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("));"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        txt = representationCrefDerVar(txt, i_arg_componentRef, a_simCode, a_context);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "pre"), expLst = {DAE.CREF(ty = i_arg_ty, componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        l_retType = expTypeArrayIf(Tpl.emptyTxt, i_arg_ty);
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        l_cast = fun_799(Tpl.emptyTxt, i_arg_ty);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_cast);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("pre("));
        a_preExp = cref(a_preExp, i_arg_componentRef);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "print"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        ret_18 = Config.acceptMetaModelicaGrammar();
        txt = fun_800(txt, ret_18, l_var1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "integer"), expLst = {i_inExp, i_index_1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_exp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_inExp, a_context, a_preExp, a_varDecls, a_simCode);
        (l_constIndex, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_index_1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::numeric_cast<int>("));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "floor"), expLst = {i_inExp, i_index_1}, attr = DAE.CALL_ATTR(ty = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_exp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_inExp, a_context, a_preExp, a_varDecls, a_simCode);
        (l_constIndex, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_index_1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("std::floor("));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "ceil"), expLst = {i_inExp, i_index_1}, attr = DAE.CALL_ATTR(ty = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_exp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_inExp, a_context, a_preExp, a_varDecls, a_simCode);
        (l_constIndex, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_index_1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("std::ceil("));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "integer"), expLst = {i_inExp}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_exp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_inExp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::numeric_cast<int>("));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "modelica_mod_int"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%"));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "max"), attr = DAE.CALL_ATTR(ty = DAE.T_REAL(varLst = _)), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("max("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "max"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int_max((int)"));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",(int)"));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = DAE.T_REAL(varLst = _)), path = Absyn.IDENT(name = "min"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("min("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "min"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int_min((int)"));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",(int)"));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "abs"), expLst = {i_e1}, attr = DAE.CALL_ATTR(ty = DAE.T_INTEGER(varLst = _))),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("labs("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "abs"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fabs("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sqrt"), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_801(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_typeStr = expTypeShort(Tpl.emptyTxt, i_attr_ty);
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_typeStr), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = sqrt("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "sin")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_802(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("double"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_803(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "cos")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_804(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("double"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_805(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "log")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_806(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("double"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_807(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "acos")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_808(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("double"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_809(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "tan")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_810(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("double"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_811(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "tanh")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_812(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("double"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_813(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "atan")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_814(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("double"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_815(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "atan2"), expLst = (i_expLst as {_, _}), attr = DAE.CALL_ATTR(ty = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_816(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_retType = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("double"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = std::atan2("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "smooth"), expLst = (i_expLst as {_, _}), attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_817(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_retType = expTypeShort(Tpl.emptyTxt, i_attr_ty);
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = smooth("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = (i_path as Absyn.IDENT(name = "exp")), expLst = (i_expLst as {_}), attr = DAE.CALL_ATTR(builtin = i_attr_builtin)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_818(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("double"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = daeExpCallBuiltinPrefix(a_preExp, i_attr_builtin);
        a_preExp = Tpl.writeText(a_preExp, l_funName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = fun_819(txt, i_attr_builtin, l_retType, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "div"), expLst = {i_e1, i_e2}, attr = DAE.CALL_ATTR(ty = DAE.T_INTEGER(varLst = _))),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ldiv("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").quot"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "div"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::math::trunc("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "mod"), expLst = {i_e1, i_e2}, attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_mod_"));
        txt = expTypeShort(txt, i_attr_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "semiLinear"), expLst = {i_e1, i_e2, _}, attr = DAE.CALL_ATTR(ty = _)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var3, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("semiLinear("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "max"), expLst = {i_array}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_tmpVar = Tpl.emptyTxt;
        (l_expVar, a_preExp, l_tmpVar) = daeExp(Tpl.emptyTxt, i_array, a_context, a_preExp, l_tmpVar, a_simCode);
        l_arr__tp__str = expTypeFromExpArray(Tpl.emptyTxt, i_array);
        txt_26 = expTypeFromExpModelica(Tpl.emptyTxt, i_array);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_26), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = min_max<"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",1>("));
        a_preExp = Tpl.writeText(a_preExp, l_expVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(").second;"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "min"), expLst = {i_array}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_tmpVar = Tpl.emptyTxt;
        (l_expVar, a_preExp, l_tmpVar) = daeExp(Tpl.emptyTxt, i_array, a_context, a_preExp, l_tmpVar, a_simCode);
        l_arr__tp__str = expTypeFromExpArray(Tpl.emptyTxt, i_array);
        txt_27 = expTypeFromExpModelica(Tpl.emptyTxt, i_array);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_27), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = min_max<"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",1>("));
        a_preExp = Tpl.writeText(a_preExp, l_expVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(").first;"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "fill"), expLst = i_val :: i_dims_1, attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_valExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_val, a_context, a_preExp, a_varDecls, a_simCode);
        l_dimsExp = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsExp, a_varDecls, a_preExp) = lm_820(l_dimsExp, i_dims_1, a_simCode, a_varDecls, a_preExp, a_context);
        l_dimsExp = Tpl.popIter(l_dimsExp);
        l_ty__str = expTypeArray(Tpl.emptyTxt, i_attr_ty);
        l_tmp__type__str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("multi_array<"));
        l_tmp__type__str = Tpl.writeText(l_tmp__type__str, l_ty__str);
        l_tmp__type__str = Tpl.writeTok(l_tmp__type__str, Tpl.ST_STRING(","));
        ret_32 = listLength(i_dims_1);
        l_tmp__type__str = Tpl.writeStr(l_tmp__type__str, intString(ret_32));
        l_tmp__type__str = Tpl.writeTok(l_tmp__type__str, Tpl.ST_STRING(">"));
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_tmp__type__str), a_varDecls);
        a_varDecls = Tpl.writeText(a_varDecls, l_tvar);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(".resize((boost::extents["));
        a_varDecls = Tpl.writeText(a_varDecls, l_dimsExp);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_LINE("]));\n"));
        a_varDecls = Tpl.pushBlock(a_varDecls, Tpl.BT_INDENT(4));
        a_varDecls = Tpl.writeText(a_varDecls, l_tvar);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(".reindex(1);"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_varDecls = Tpl.popBlock(a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("fill_array<"));
        a_preExp = Tpl.writeText(a_preExp, l_ty__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(","));
        ret_33 = listLength(i_dims_1);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_33));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(">("));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_valExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "$_start"), expLst = {i_arg}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCallStart(txt, i_arg, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "cat"), expLst = i_dim :: i_arrays, attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_dim__exp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_dim, a_context, a_preExp, a_varDecls, a_simCode);
        l_arrays__exp = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", &")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_arrays__exp, a_varDecls, a_preExp) = lm_821(l_arrays__exp, i_arrays, a_simCode, a_varDecls, a_preExp, a_context);
        l_arrays__exp = Tpl.popIter(l_arrays__exp);
        l_ty__str = expTypeArray(Tpl.emptyTxt, i_attr_ty);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_ty__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("cat_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_ty__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_dim__exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        ret_36 = listLength(i_arrays);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_36));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_arrays__exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "promote"), expLst = {i_A, i_n}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_A, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_n, a_context, a_preExp, a_varDecls, a_simCode);
        l_arr__tp__str = expTypeFromExpArray(Tpl.emptyTxt, i_A);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arr__tp__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("promote_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "transpose"), expLst = {i_A}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_A, a_context, a_preExp, a_varDecls, a_simCode);
        l_arr__tp__str = expTypeFromExpArray(Tpl.emptyTxt, i_A);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arr__tp__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("transpose_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "cross"), expLst = {i_v1, i_v2}, attr = DAE.CALL_ATTR(ty = (i_ty as DAE.T_ARRAY(dims = i_dims)))),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_v1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_v2, a_context, a_preExp, a_varDecls, a_simCode);
        l_type = fun_822(Tpl.emptyTxt, i_ty);
        txt_37 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("multi_array<"));
        txt_37 = Tpl.writeText(txt_37, l_type);
        txt_37 = Tpl.writeTok(txt_37, Tpl.ST_STRING(","));
        ret_37 = listLength(i_dims);
        txt_37 = Tpl.writeStr(txt_37, intString(ret_37));
        txt_37 = Tpl.writeTok(txt_37, Tpl.ST_STRING(">"));
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_37), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("assign_array("));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",cross_array<"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(">("));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(","));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("));"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "identity"), expLst = {i_A}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_A, a_context, a_preExp, a_varDecls, a_simCode);
        l_arr__tp__str = expTypeFromExpArray(Tpl.emptyTxt, i_A);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arr__tp__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("identity_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "rem"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls, a_simCode);
        l_typeStr = expTypeFromExpShort(Tpl.emptyTxt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_rem_"));
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "String"), expLst = {i_s, i_format}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "string", a_varDecls);
        (l_sExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_s, a_context, a_preExp, a_varDecls, a_simCode);
        (l_formatExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_format, a_context, a_preExp, a_varDecls, a_simCode);
        l_typeStr = expTypeFromExpModelica(Tpl.emptyTxt, i_s);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = lexical_cast<std::string>("));
        a_preExp = Tpl.writeText(a_preExp, l_sExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "String"), expLst = {i_s, i_minlen, i_leftjust}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "string", a_varDecls);
        (l_sExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_s, a_context, a_preExp, a_varDecls, a_simCode);
        (l_minlenExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_minlen, a_context, a_preExp, a_varDecls, a_simCode);
        (l_leftjustExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_leftjust, a_context, a_preExp, a_varDecls, a_simCode);
        l_typeStr = expTypeFromExpModelica(Tpl.emptyTxt, i_s);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = lexical_cast<string>("));
        a_preExp = Tpl.writeText(a_preExp, l_sExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "String"), expLst = {i_s, i_minlen, i_leftjust, i_signdig}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "string", a_varDecls);
        (l_sExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_s, a_context, a_preExp, a_varDecls, a_simCode);
        (l_minlenExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_minlen, a_context, a_preExp, a_varDecls, a_simCode);
        (l_leftjustExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_leftjust, a_context, a_preExp, a_varDecls, a_simCode);
        (l_signdigExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_signdig, a_context, a_preExp, a_varDecls, a_simCode);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = lexical_cast<string>("));
        a_preExp = Tpl.writeText(a_preExp, l_sExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "delay"), expLst = {DAE.ICONST(integer = i_index), i_e, i_d, i_delayMax}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "double", a_varDecls);
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_d, a_context, a_preExp, a_varDecls, a_simCode);
        (l_var3, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_delayMax, a_context, a_preExp, a_varDecls, a_simCode);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = delayImpl("));
        a_preExp = Tpl.writeStr(a_preExp, intString(i_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", time, "));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var3);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "integer"), expLst = {i_toBeCasted}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_castedVar, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_toBeCasted, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((int)"));
        txt = Tpl.writeText(txt, l_castedVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "Integer"), expLst = {i_toBeCasted}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_castedVar, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_toBeCasted, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((int)"));
        txt = Tpl.writeText(txt, l_castedVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "clock"), expLst = {}),
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_clock()"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "noEvent"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "anyString"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_anyString("));
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_e1, a_context, a_preExp, a_varDecls, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "mmc_get_field"), expLst = {i_s1, DAE.ICONST(integer = i_i)}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_metatype", a_varDecls);
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_s1, a_context, a_preExp, a_varDecls, a_simCode);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR("));
        a_preExp = Tpl.writeText(a_preExp, l_expPart);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("), "));
        a_preExp = Tpl.writeStr(a_preExp, intString(i_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("));"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = DAE.T_NORETCALL(source = _))),
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = DAE.T_ARRAY(ty = i_ty, dims = i_dims)), expLst = i_expLst, path = i_path),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, a_preExp) = lm_823(l_argStr, i_expLst, a_simCode, a_varDecls, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        l_retType = Tpl.writeText(Tpl.emptyTxt, l_funName);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("RetType"));
        (l_retVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), a_varDecls);
        l_arraytpye = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("multi_array_ref<"));
        l_arraytpye = expTypeShort(l_arraytpye, i_ty);
        l_arraytpye = Tpl.writeTok(l_arraytpye, Tpl.ST_STRING(","));
        ret_47 = listLength(i_dims);
        l_arraytpye = Tpl.writeStr(l_arraytpye, intString(ret_47));
        l_arraytpye = Tpl.writeTok(l_arraytpye, Tpl.ST_STRING(">"));
        a_preExp = fun_824(a_preExp, a_context, l_argStr, l_funName, l_retVar);
        txt = Tpl.writeText(txt, l_retVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(expLst = i_explist, attr = DAE.CALL_ATTR(ty = _), path = i_path),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        str_48 = Tpl.textString(l_funName);
        (txt, a_varDecls, a_preExp) = fun_829(txt, str_48, l_funName, a_simCode, a_varDecls, a_preExp, a_context, i_explist);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpCall;

public function daeExpCallStart
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Exp i_exp;
      DAE.Exp i_sub__exp;
      DAE.ComponentRef i_cr_componentRef;
      Tpl.Text txt_2;
      String ret_2;
      Tpl.Text l_cref;
      Tpl.Text l_offset;

    case ( txt,
           DAE.CREF(componentRef = i_cr_componentRef),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("getStartValue("));
        txt = cref1(txt, i_cr_componentRef, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = cref(txt, i_cr_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = DAE.CREF(componentRef = i_cr_componentRef), sub = {i_sub__exp}),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_offset, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_sub__exp, a_context, a_preExp, a_varDecls, a_simCode);
        l_cref = cref1(Tpl.emptyTxt, i_cr_componentRef, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*(&$P$ATTRIBUTE"));
        txt = cref(txt, i_cr_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".start + "));
        txt = Tpl.writeText(txt, l_offset);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           _,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt_2 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Code generation does not support start("));
        ret_2 = ExpressionDump.printExpStr(i_exp);
        txt_2 = Tpl.writeStr(txt_2, ret_2);
        txt_2 = Tpl.writeTok(txt_2, Tpl.ST_STRING(")"));
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 5712, 11), Tpl.textString(txt_2));
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpCallStart;

public function expTypeFromExpShort
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlag(txt, a_exp, 1);
end expTypeFromExpShort;

public function expTypeFromExpModelica
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlag(txt, a_exp, 2);
end expTypeFromExpModelica;

public function expTypeFromExpArray
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlag(txt, a_exp, 3);
end expTypeFromExpArray;

protected function fun_835
  input Tpl.Text in_txt;
  input Tpl.Text in_a_msgVar;
  input Tpl.Text in_a_condVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_msgVar, in_a_condVar)
    local
      Tpl.Text txt;
      Tpl.Text a_condVar;
      Tpl.Text i_msgVar;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_condVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Assert("));
        txt = Tpl.writeText(txt, a_condVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\"\");"));
      then txt;

    case ( txt,
           i_msgVar,
           a_condVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Assert("));
        txt = Tpl.writeText(txt, a_condVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, i_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_835;

public function assertCommon
  input Tpl.Text txt;
  input DAE.Exp a_condition;
  input DAE.Exp a_message;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Absyn.Info a_info;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_msgVar;
  Tpl.Text l_condVar;
  Tpl.Text l_preExpMsg;
  Tpl.Text l_preExpCond;
algorithm
  l_preExpCond := Tpl.emptyTxt;
  l_preExpMsg := Tpl.emptyTxt;
  (l_condVar, l_preExpCond, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_condition, a_context, l_preExpCond, a_varDecls, a_simCode);
  (l_msgVar, l_preExpMsg, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_message, a_context, l_preExpMsg, out_a_varDecls, a_simCode);
  out_txt := Tpl.writeText(txt, l_preExpCond);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_preExpMsg);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := fun_835(out_txt, l_msgVar, l_condVar);
end assertCommon;

public function infoArgs
  input Tpl.Text in_txt;
  input Absyn.Info in_a_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_info)
    local
      Tpl.Text txt;
      Boolean i_isReadOnly;
      Integer i_columnNumberEnd;
      Integer i_lineNumberEnd;
      Integer i_columnNumberStart;
      Integer i_lineNumberStart;
      String i_fileName;

    case ( txt,
           Absyn.INFO(fileName = i_fileName, lineNumberStart = i_lineNumberStart, columnNumberStart = i_columnNumberStart, lineNumberEnd = i_lineNumberEnd, columnNumberEnd = i_columnNumberEnd, isReadOnly = i_isReadOnly) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_fileName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\","));
        txt = Tpl.writeStr(txt, intString(i_lineNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_columnNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_lineNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_columnNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_isReadOnly));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end infoArgs;

public function underscorePrefix
  input Tpl.Text in_txt;
  input Boolean in_a_builtin;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_builtin)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end underscorePrefix;

public function daeExpCallBuiltinPrefix
  input Tpl.Text in_txt;
  input Boolean in_a_builtin;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_builtin)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end daeExpCallBuiltinPrefix;

protected function fun_840
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_operator, in_a_e)
    local
      Tpl.Text txt;
      Tpl.Text a_e;

    case ( txt,
           DAE.NOT(ty = _),
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_840;

public function daeExpLunary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Operator i_operator;
      DAE.Exp i_exp;
      Tpl.Text l_e;

    case ( txt,
           DAE.LUNARY(exp = i_exp, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_e, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls, a_simCode);
        txt = fun_840(txt, i_operator, l_e);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpLunary;

protected function fun_842
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_operator, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.AND(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.OR(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpLbinary:ERR"));
      then txt;
  end match;
end fun_842;

public function daeExpLbinary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           DAE.LBINARY(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, a_context, a_preExp, a_varDecls, a_simCode);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, a_context, a_preExp, a_varDecls, a_simCode);
        txt = fun_842(txt, i_operator, l_e2, l_e1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpLbinary;

protected function fun_844
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.Dimensions in_a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty, in_a_dims)
    local
      Tpl.Text txt;
      DAE.Dimensions a_dims;
      DAE.Dimensions i_dims;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _), dims = i_dims),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<int,"));
        ret_0 = listLength(i_dims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _), dims = i_dims),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<int,"));
        ret_1 = listLength(i_dims);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           _,
           a_dims )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<double,"));
        ret_2 = listLength(a_dims);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;
  end match;
end fun_844;

protected function fun_845
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;
  end match;
end fun_845;

protected function fun_846
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.Dimensions in_a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty, in_a_dims)
    local
      Tpl.Text txt;
      DAE.Dimensions a_dims;
      DAE.Dimensions i_dims;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _), dims = i_dims),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<int,"));
     