encapsulated package CodegenFMU
"
  file:        CodegenFMU.mo
  package:     CodegenFMU
  description: Generated by Susan.
"

public import Tpl;

public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCode;
public import HpcOmScheduler;
public import CodegenUtil;
public import CodegenC;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<DAE.Exp> i_literals;
      list<SimCode.RecordDeclaration> i_recordDecls;
      list<SimCode.Function> i_modelInfo_functions;
      String i_fileNamePrefix;
      Tpl.Text txt_23;
      Tpl.Text txt_22;
      Tpl.Text txt_21;
      Tpl.Text txt_20;
      Tpl.Text txt_19;
      Tpl.Text txt_18;
      Tpl.Text txt_17;
      Tpl.Text txt_16;
      Tpl.Text txt_15;
      Tpl.Text txt_14;
      Tpl.Text txt_13;
      Tpl.Text txt_12;
      Tpl.Text txt_11;
      Tpl.Text txt_10;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      String ret_3;
      Tpl.Text l_target;
      String ret_1;
      Tpl.Text l_guid;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = i_modelInfo_functions), fileNamePrefix = i_fileNamePrefix, recordDecls = i_recordDecls, literals = i_literals)) )
      equation
        ret_1 = System.getUUIDStr();
        l_guid = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_3 = Config.simulationCodeTarget();
        l_target = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        txt_4 = CodegenC.simulationFunctionsHeaderFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_recordDecls);
        txt_5 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING("_functions.h"));
        Tpl.textFile(txt_4, Tpl.textString(txt_5));
        txt_6 = CodegenC.simulationFunctionsFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_literals);
        txt_7 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_7 = Tpl.writeTok(txt_7, Tpl.ST_STRING("_functions.c"));
        Tpl.textFile(txt_6, Tpl.textString(txt_7));
        txt_8 = CodegenC.recordsFile(Tpl.emptyTxt, i_fileNamePrefix, i_recordDecls);
        txt_9 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_9 = Tpl.writeTok(txt_9, Tpl.ST_STRING("_records.c"));
        Tpl.textFile(txt_8, Tpl.textString(txt_9));
        txt_10 = CodegenC.simulationHeaderFile(Tpl.emptyTxt, i_simCode, Tpl.textString(l_guid));
        txt_11 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_11 = Tpl.writeTok(txt_11, Tpl.ST_STRING("_model.h"));
        Tpl.textFile(txt_10, Tpl.textString(txt_11));
        txt_12 = CodegenC.simulationFile(Tpl.emptyTxt, i_simCode, Tpl.textString(l_guid));
        txt_13 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_13 = Tpl.writeTok(txt_13, Tpl.ST_STRING(".c"));
        Tpl.textFile(txt_12, Tpl.textString(txt_13));
        txt_14 = CodegenC.simulationInitFile(Tpl.emptyTxt, i_simCode, Tpl.textString(l_guid));
        (txt_15, txt_14) = simulationInitFileCString(Tpl.emptyTxt, txt_14);
        txt_16 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_16 = Tpl.writeTok(txt_16, Tpl.ST_STRING("_init.c"));
        Tpl.textFile(txt_15, Tpl.textString(txt_16));
        txt_17 = fmumodel_identifierFile(Tpl.emptyTxt, i_simCode, Tpl.textString(l_guid));
        txt_18 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_18 = Tpl.writeTok(txt_18, Tpl.ST_STRING("_FMU.c"));
        Tpl.textFile(txt_17, Tpl.textString(txt_18));
        txt_19 = fmuModelDescriptionFile(Tpl.emptyTxt, i_simCode, Tpl.textString(l_guid));
        Tpl.textFile(txt_19, "modelDescription.xml");
        txt_20 = fmudeffile(Tpl.emptyTxt, i_simCode);
        txt_21 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_21 = Tpl.writeTok(txt_21, Tpl.ST_STRING(".def"));
        Tpl.textFile(txt_20, Tpl.textString(txt_21));
        txt_22 = fmuMakefile(Tpl.emptyTxt, Tpl.textString(l_target), i_simCode);
        txt_23 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_23 = Tpl.writeTok(txt_23, Tpl.ST_STRING("_FMU.makefile"));
        Tpl.textFile(txt_22, Tpl.textString(txt_23));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end translateModel;

public function simulationInitFileCString
  input Tpl.Text txt;
  input Tpl.Text a_text;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_text;
protected
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("data->modelData.initXMLData = \""));
  ret_0 := Util.escapeModelicaStringToCString(Tpl.textString(a_text));
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\";"));
  out_a_text := a_text;
end simulationInitFileCString;

public function fmuModelDescriptionFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)),
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"));
        txt = fmiModelDescription(txt, i_simCode, a_guid);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmuModelDescriptionFile;

public function fmiModelDescription
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.ModelInfo i_modelInfo;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(simulationSettingsOpt = i_simulationSettingsOpt, modelInfo = i_modelInfo)),
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fmiModelDescription\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = fmiModelDescriptionAttributes(txt, i_simCode, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = DefaultExperiment(txt, i_simulationSettingsOpt);
        txt = Tpl.softNewLine(txt);
        txt = ModelVariables(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fmiModelDescription>"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmiModelDescription;

protected function fun_37
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.SimVar> in_a_listStates;
  input Integer in_a_vi_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_listStates, in_a_vi_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> a_listStates;
      Integer a_vi_numStateVars;

    case ( txt,
           false,
           _,
           a_vi_numStateVars )
      equation
        txt = Tpl.writeStr(txt, intString(a_vi_numStateVars));
      then txt;

    case ( txt,
           _,
           a_listStates,
           _ )
      equation
        txt = statesnumwithDummy(txt, a_listStates);
      then txt;
  end match;
end fun_37;

public function fmiModelDescriptionAttributes
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      Integer i_vi_numZeroCrossings;
      list<SimCode.SimVar> i_listStates;
      Integer i_vi_numStateVars;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_numberOfEventIndicators;
      Boolean ret_13;
      Tpl.Text l_numberOfContinuousStates;
      Tpl.Text l_variableNamingConvention;
      Util.DateTime ret_10;
      Tpl.Text l_generationDateAndTime;
      String ret_8;
      Tpl.Text l_generationTool;
      Tpl.Text l_version;
      Tpl.Text l_author;
      Tpl.Text l_description;
      String ret_3;
      Tpl.Text l_modelIdentifier;
      Tpl.Text l_modelName;
      Tpl.Text l_fmiVersion;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_vi_numStateVars, numZeroCrossings = i_vi_numZeroCrossings), vars = SimCode.SIMVARS(stateVars = i_listStates), name = i_modelInfo_name), fileNamePrefix = i_fileNamePrefix),
           a_guid )
      equation
        l_fmiVersion = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("1.0"));
        l_modelName = CodegenUtil.dotPath(Tpl.emptyTxt, i_modelInfo_name);
        ret_3 = System.stringReplace(i_fileNamePrefix, ".", "_");
        l_modelIdentifier = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        l_description = Tpl.emptyTxt;
        l_author = Tpl.emptyTxt;
        l_version = Tpl.emptyTxt;
        l_generationTool = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OpenModelica Compiler "));
        ret_8 = Settings.getVersionNr();
        l_generationTool = Tpl.writeStr(l_generationTool, ret_8);
        ret_10 = Util.getCurrentDateTime();
        l_generationDateAndTime = xsdateTime(Tpl.emptyTxt, ret_10);
        l_variableNamingConvention = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("structured"));
        ret_13 = intEq(i_vi_numStateVars, 1);
        l_numberOfContinuousStates = fun_37(Tpl.emptyTxt, ret_13, i_listStates, i_vi_numStateVars);
        l_numberOfEventIndicators = Tpl.writeStr(Tpl.emptyTxt, intString(i_vi_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmiVersion=\""));
        txt = Tpl.writeText(txt, l_fmiVersion);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelName=\""
                                }, false));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelIdentifier=\""
                                }, false));
        txt = Tpl.writeText(txt, l_modelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "guid=\"{"
                                }, false));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\"\n",
                                    "generationTool=\""
                                }, false));
        txt = Tpl.writeText(txt, l_generationTool);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "generationDateAndTime=\""
                                }, false));
        txt = Tpl.writeText(txt, l_generationDateAndTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "variableNamingConvention=\""
                                }, false));
        txt = Tpl.writeText(txt, l_variableNamingConvention);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "numberOfContinuousStates=\""
                                }, false));
        txt = Tpl.writeText(txt, l_numberOfContinuousStates);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "numberOfEventIndicators=\""
                                }, false));
        txt = Tpl.writeText(txt, l_numberOfEventIndicators);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmiModelDescriptionAttributes;

protected function fun_39
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;
  end match;
end fun_39;

protected function fun_40
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.SIMVAR(name = i_name) )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "$dummy");
        txt = fun_39(txt, ret_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_40;

protected function lm_41
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_40(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_41(txt, rest);
      then txt;
  end match;
end lm_41;

public function statesnumwithDummy
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_vars;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_41(out_txt, a_vars);
  out_txt := Tpl.popIter(out_txt);
end statesnumwithDummy;

public function xsdateTime
  input Tpl.Text in_txt;
  input Util.DateTime in_a_dt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dt)
    local
      Tpl.Text txt;
      Integer i_sec;
      Integer i_min;
      Integer i_hour;
      Integer i_mday;
      Integer i_mon;
      Integer i_year;
      String ret_4;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           Util.DATETIME(year = i_year, mon = i_mon, mday = i_mday, hour = i_hour, min = i_min, sec = i_sec) )
      equation
        txt = Tpl.writeStr(txt, intString(i_year));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_0 = SimCodeUtil.twodigit(i_mon);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_1 = SimCodeUtil.twodigit(i_mday);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("T"));
        ret_2 = SimCodeUtil.twodigit(i_hour);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_3 = SimCodeUtil.twodigit(i_min);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_4 = SimCodeUtil.twodigit(i_sec);
        txt = Tpl.writeStr(txt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Z"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end xsdateTime;

public function UnitDefinitions
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMCODE(modelInfo = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<UnitDefinitions>\n",
                                    "</UnitDefinitions>"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end UnitDefinitions;

public function TypeDefinitions
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMCODE(modelInfo = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<TypeDefinitions>\n",
                                    "</TypeDefinitions>"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end TypeDefinitions;

public function DefaultExperiment
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simulationSettingsOpt)
    local
      Tpl.Text txt;
      SimCode.SimulationSettings i_v;

    case ( txt,
           SOME(i_v) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<DefaultExperiment "));
        txt = DefaultExperimentAttribute(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end DefaultExperiment;

public function DefaultExperimentAttribute
  input Tpl.Text in_txt;
  input SimCode.SimulationSettings in_a_simulationSettings;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simulationSettings)
    local
      Tpl.Text txt;
      Real i_tolerance;
      Real i_stopTime;
      Real i_startTime;

    case ( txt,
           SimCode.SIMULATION_SETTINGS(startTime = i_startTime, stopTime = i_stopTime, tolerance = i_tolerance) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("startTime=\""));
        txt = Tpl.writeStr(txt, realString(i_startTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" stopTime=\""));
        txt = Tpl.writeStr(txt, realString(i_stopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" tolerance=\""));
        txt = Tpl.writeStr(txt, realString(i_tolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end DefaultExperimentAttribute;

public function VendorAnnotations
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMCODE(modelInfo = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<VendorAnnotations>\n",
                                    "</VendorAnnotations>"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end VendorAnnotations;

protected function lm_49
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_49(txt, rest);
      then txt;
  end match;
end lm_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;
  end match;
end lm_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;
  end match;
end lm_51;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest);
      then txt;
  end match;
end lm_52;

protected function lm_53
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest);
      then txt;
  end match;
end lm_53;

protected function lm_54
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_54(txt, rest);
      then txt;
  end match;
end lm_54;

protected function lm_55
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_55(txt, rest);
      then txt;
  end match;
end lm_55;

protected function lm_56
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest);
      then txt;
  end match;
end lm_56;

protected function lm_57
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_57(txt, rest);
      then txt;
  end match;
end lm_57;

protected function lm_58
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_58(txt, rest);
      then txt;
  end match;
end lm_58;

protected function lm_59
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_59(txt, rest);
      then txt;
  end match;
end lm_59;

protected function lm_60
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_60(txt, rest);
      then txt;
  end match;
end lm_60;

protected function lm_61
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_61(txt, rest);
      then txt;
  end match;
end lm_61;

protected function lm_62
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariable(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_62(txt, rest);
      then txt;
  end match;
end lm_62;

public function ModelVariables
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      SimCode.ModelInfo i_modelInfo;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           (i_modelInfo as SimCode.MODELINFO(vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<ModelVariables>\n"));
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_49(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_50(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_51(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_52(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_53(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_54(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_55(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_56(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_57(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_58(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_59(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_60(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_61(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_62(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = externalFunctions(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</ModelVariables>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ModelVariables;

protected function fun_64
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Boolean in_a_isFixed;
  input Option<DAE.Exp> in_a_initialValue;
  input String in_a_displayUnit;
  input String in_a_unit;
  input DAE.Type in_a_type__;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_isFixed, in_a_initialValue, in_a_displayUnit, in_a_unit, in_a_type__, in_a_simVar)
    local
      Tpl.Text txt;
      Boolean a_isFixed;
      Option<DAE.Exp> a_initialValue;
      String a_displayUnit;
      String a_unit;
      DAE.Type a_type__;
      SimCode.SimVar a_simVar;

    case ( txt,
           false,
           a_isFixed,
           a_initialValue,
           a_displayUnit,
           a_unit,
           a_type__,
           a_simVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<ScalarVariable\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = ScalarVariableAttribute(txt, a_simVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = ScalarVariableType(txt, a_type__, a_unit, a_displayUnit, a_initialValue, a_isFixed);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</ScalarVariable>"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_64;

protected function fun_65
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Boolean in_a_isFixed;
  input Option<DAE.Exp> in_a_initialValue;
  input String in_a_displayUnit;
  input String in_a_unit;
  input DAE.Type in_a_type__;
  input SimCode.SimVar in_a_simVar;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_isFixed, in_a_initialValue, in_a_displayUnit, in_a_unit, in_a_type__, in_a_simVar, in_a_name)
    local
      Tpl.Text txt;
      Boolean a_isFixed;
      Option<DAE.Exp> a_initialValue;
      String a_displayUnit;
      String a_unit;
      DAE.Type a_type__;
      SimCode.SimVar a_simVar;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_isFixed,
           a_initialValue,
           a_displayUnit,
           a_unit,
           a_type__,
           a_simVar,
           a_name )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_64(txt, ret_1, a_isFixed, a_initialValue, a_displayUnit, a_unit, a_type__, a_simVar);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_65;

public function ScalarVariable
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      Boolean i_isFixed;
      Option<DAE.Exp> i_initialValue;
      String i_displayUnit;
      String i_unit;
      DAE.Type i_type__;
      SimCode.SimVar i_simVar;
      DAE.ComponentRef i_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simVar as SimCode.SIMVAR(name = i_name, type_ = i_type__, unit = i_unit, displayUnit = i_displayUnit, initialValue = i_initialValue, isFixed = i_isFixed)) )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "$dummy");
        txt = fun_65(txt, ret_1, i_isFixed, i_initialValue, i_displayUnit, i_unit, i_type__, i_simVar, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariable;

protected function fun_67
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;
      String ret_0;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("description=\""));
        ret_0 = Util.escapeModelicaStringToXmlString(i_comment);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_67;

public function ScalarVariableAttribute
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      SimCode.Causality i_causality;
      SimCode.AliasVariable i_aliasvar;
      String i_comment;
      BackendDAE.VarKind i_varKind;
      String ret_7;
      Tpl.Text txt_6;
      Tpl.Text l_caus;
      Tpl.Text l_alias;
      Tpl.Text l_description;
      Tpl.Text l_variability;
      Integer ret_1;
      Tpl.Text l_valueReference;

    case ( txt,
           SimCode.SIMVAR(varKind = i_varKind, comment = i_comment, aliasvar = i_aliasvar, causality = i_causality, name = i_name) )
      equation
        ret_1 = System.tmpTick();
        l_valueReference = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        l_variability = getVariablity(Tpl.emptyTxt, i_varKind);
        l_description = fun_67(Tpl.emptyTxt, i_comment);
        l_alias = getAliasVar(Tpl.emptyTxt, i_aliasvar);
        l_caus = getCausality(Tpl.emptyTxt, i_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("name=\""));
        txt_6 = CodegenUtil.crefStrNoUnderscore(Tpl.emptyTxt, i_name);
        ret_7 = System.stringReplace(Tpl.textString(txt_6), "$", "_D_");
        txt = Tpl.writeStr(txt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "valueReference=\""
                                }, false));
        txt = Tpl.writeText(txt, l_valueReference);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"\n"));
        txt = Tpl.writeText(txt, l_description);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("variability=\""));
        txt = Tpl.writeText(txt, l_variability);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "causality=\""
                                }, false));
        txt = Tpl.writeText(txt, l_caus);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "alias=\""
                                }, false));
        txt = Tpl.writeText(txt, l_alias);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableAttribute;

public function getCausality
  input Tpl.Text in_txt;
  input SimCode.Causality in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_c)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.NONECAUS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("none"));
      then txt;

    case ( txt,
           SimCode.INTERNAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("internal"));
      then txt;

    case ( txt,
           SimCode.OUTPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output"));
      then txt;

    case ( txt,
           SimCode.INPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("input"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getCausality;

public function getVariablity
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varKind)
    local
      Tpl.Text txt;

    case ( txt,
           BackendDAE.DISCRETE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("discrete"));
      then txt;

    case ( txt,
           BackendDAE.PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parameter"));
      then txt;

    case ( txt,
           BackendDAE.CONST() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("continuous"));
      then txt;
  end match;
end getVariablity;

public function getAliasVar
  input Tpl.Text in_txt;
  input SimCode.AliasVariable in_a_aliasvar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_aliasvar)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.NOALIAS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("noAlias"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("noAlias"));
      then txt;
  end match;
end getAliasVar;

protected function fun_72
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;
  input Option<DAE.Exp> in_a_initialValue;
  input Boolean in_a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__, in_a_initialValue, in_a_isFixed)
    local
      Tpl.Text txt;
      Option<DAE.Exp> a_initialValue;
      Boolean a_isFixed;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Integer"));
        txt = ScalarVariableTypeCommonAttribute(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Real"));
        txt = ScalarVariableTypeCommonAttribute(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Boolean"));
        txt = ScalarVariableTypeCommonAttribute(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<String"));
        txt = StringVariableTypeCommonAttribute(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Integer"));
        txt = ScalarVariableTypeCommonAttribute(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKOWN_TYPE"));
      then txt;
  end match;
end fun_72;

public function ScalarVariableType
  input Tpl.Text txt;
  input DAE.Type a_type__;
  input String a_unit;
  input String a_displayUnit;
  input Option<DAE.Exp> a_initialValue;
  input Boolean a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_72(txt, a_type__, a_initialValue, a_isFixed);
end ScalarVariableType;

public function ScalarVariableTypeCommonAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input Boolean in_a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_isFixed)
    local
      Tpl.Text txt;
      Boolean a_isFixed;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp),
           a_isFixed )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = initVal(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" fixed=\""));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_isFixed));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end ScalarVariableTypeCommonAttribute;

public function StringVariableTypeCommonAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input Boolean in_a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_isFixed)
    local
      Tpl.Text txt;
      Boolean a_isFixed;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp),
           a_isFixed )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start="));
        txt = initVal(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" fixed=\""));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_isFixed));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end StringVariableTypeCommonAttribute;

protected function fun_76
  input Tpl.Text in_txt;
  input String in_a_unit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_unit)
    local
      Tpl.Text txt;
      String i_unit;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_unit )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unit=\""));
        txt = Tpl.writeStr(txt, i_unit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_76;

protected function fun_77
  input Tpl.Text in_txt;
  input String in_a_displayUnit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_displayUnit)
    local
      Tpl.Text txt;
      String i_displayUnit;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_displayUnit )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("displayUnit=\""));
        txt = Tpl.writeStr(txt, i_displayUnit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_77;

public function ScalarVariableTypeRealAttribute
  input Tpl.Text txt;
  input String a_unit;
  input String a_displayUnit;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_displayUnit__;
  Tpl.Text l_unit__;
algorithm
  l_unit__ := fun_76(Tpl.emptyTxt, a_unit);
  l_displayUnit__ := fun_77(Tpl.emptyTxt, a_displayUnit);
  out_txt := Tpl.writeText(txt, l_unit__);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" "));
  out_txt := Tpl.writeText(out_txt, l_displayUnit__);
end ScalarVariableTypeRealAttribute;

protected function lm_79
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = externalFunction(txt, i_fn);
        txt = Tpl.nextIter(txt);
        txt = lm_79(txt, rest);
      then txt;
  end match;
end lm_79;

public function externalFunctions
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.Function> i_functions;

    case ( txt,
           SimCode.MODELINFO(functions = i_functions) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_79(txt, i_functions);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end externalFunctions;

public function externalFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      String i_language;
      String i_extName;
      Integer ret_1;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(dynamicLoad = true, extName = i_extName, language = i_language) )
      equation
        l_fname = CodegenC.extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<ExternalFunction\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("name=\""));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "valueReference=\""
                                }, false));
        ret_1 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end externalFunction;

public function fmumodel_identifierFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      String i_fileNamePrefix;
      String ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(fileNamePrefix = i_fileNamePrefix, modelInfo = i_modelInfo)),
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "// define class name and unique id\n",
                                    "#define MODEL_IDENTIFIER "
                                }, false));
        ret_0 = System.stringReplace(i_fileNamePrefix, ".", "_");
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define MODEL_GUID \"{"));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\"\n",
                                    "\n",
                                    "// include fmu header files, typedefs and macros\n",
                                    "#include <stdio.h>\n",
                                    "#include <string.h>\n",
                                    "#include <assert.h>\n",
                                    "#include \"openmodelica.h\"\n",
                                    "#include \"openmodelica_func.h\"\n",
                                    "#include \"simulation_data.h\"\n",
                                    "#include \"omc_error.h\"\n",
                                    "#include \"fmiModelTypes.h\"\n",
                                    "#include \"fmiModelFunctions.h\"\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.h\"\n",
                                    "#include \"initialization.h\"\n",
                                    "#include \"events.h\"\n",
                                    "#include \"fmu_model_interface.h\"\n",
                                    "\n",
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "\n",
                                    "void setStartValues(ModelInstance *comp);\n",
                                    "void setDefaultStartValues(ModelInstance *comp);\n",
                                    "void eventUpdate(ModelInstance* comp, fmiEventInfo* eventInfo);\n",
                                    "fmiReal getReal(ModelInstance* comp, const fmiValueReference vr);\n",
                                    "fmiStatus setReal(ModelInstance* comp, const fmiValueReference vr, const fmiReal value);\n",
                                    "fmiInteger getInteger(ModelInstance* comp, const fmiValueReference vr);\n",
                                    "fmiStatus setInteger(ModelInstance* comp, const fmiValueReference vr, const fmiInteger value);\n",
                                    "fmiBoolean getBoolean(ModelInstance* comp, const fmiValueReference vr);\n",
                                    "fmiStatus setBoolean(ModelInstance* comp, const fmiValueReference vr, const fmiBoolean value);\n",
                                    "fmiString getString(ModelInstance* comp, const fmiValueReference vr);\n",
                                    "fmiStatus setExternalFunction(ModelInstance* c, const fmiValueReference vr, const void* value);\n",
                                    "\n"
                                }, true));
        txt = ModelDefineData(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "// implementation of the Model Exchange functions\n",
                                    "#include \"fmu_model_interface.c\"\n",
                                    "\n"
                                }, true));
        txt = setDefaultStartValues(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setStartValues(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = eventUpdateFunction(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = getRealFunction(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setRealFunction(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = getIntegerFunction(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setIntegerFunction(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = getBooleanFunction(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setBooleanFunction(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = getStringFunction(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setExternalFunction(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmumodel_identifierFile;

protected function fun_83
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.SimVar> in_a_listStates;
  input Integer in_a_varInfo_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_listStates, in_a_varInfo_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> a_listStates;
      Integer a_varInfo_numStateVars;

    case ( txt,
           false,
           _,
           a_varInfo_numStateVars )
      equation
        txt = Tpl.writeStr(txt, intString(a_varInfo_numStateVars));
      then txt;

    case ( txt,
           _,
           a_listStates,
           _ )
      equation
        txt = statesnumwithDummy(txt, a_listStates);
      then txt;
  end match;
end fun_83;

protected function lm_84
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_84(txt, rest);
      then txt;
  end match;
end lm_84;

protected function lm_85
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_85(txt, rest);
      then txt;
  end match;
end lm_85;

protected function lm_86
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_86(txt, rest);
      then txt;
  end match;
end lm_86;

protected function lm_87
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_87(txt, rest);
      then txt;
  end match;
end lm_87;

protected function lm_88
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_88(txt, rest);
      then txt;
  end match;
end lm_88;

protected function lm_89
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_89(txt, rest);
      then txt;
  end match;
end lm_89;

protected function lm_90
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_90(txt, rest);
      then txt;
  end match;
end lm_90;

protected function lm_91
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_91(txt, rest);
      then txt;
  end match;
end lm_91;

protected function lm_92
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_92(txt, rest);
      then txt;
  end match;
end lm_92;

protected function lm_93
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_93(txt, rest);
      then txt;
  end match;
end lm_93;

protected function lm_94
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_94(txt, rest);
      then txt;
  end match;
end lm_94;

protected function lm_95
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_95(txt, rest);
      then txt;
  end match;
end lm_95;

protected function lm_96
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_96(txt, rest);
      then txt;
  end match;
end lm_96;

protected function lm_97
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_97(txt, rest);
      then txt;
  end match;
end lm_97;

protected function fun_98
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_name)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = CodegenC.cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_98;

protected function lm_99
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "$dummy");
        txt = fun_98(txt, ret_1, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_99(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_99(txt, rest);
      then txt;
  end match;
end lm_99;

protected function fun_100
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_name)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = CodegenC.cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_100;

protected function lm_101
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_100(txt, ret_1, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_101(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_101(txt, rest);
      then txt;
  end match;
end lm_101;

protected function lm_102
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = defineExternalFunction(txt, i_fn);
        txt = Tpl.nextIter(txt);
        txt = lm_102(txt, rest);
      then txt;
  end match;
end lm_102;

public function ModelDefineData
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;
      list<SimCode.Function> i_functions;
      Integer i_varInfo_numZeroCrossings;
      list<SimCode.SimVar> i_listStates;
      Integer i_varInfo_numBoolAliasVars;
      Integer i_varInfo_numBoolParams;
      Integer i_varInfo_numBoolAlgVars;
      Integer i_varInfo_numStringAliasVars;
      Integer i_varInfo_numStringParamVars;
      Integer i_varInfo_numStringAlgVars;
      Integer i_varInfo_numIntAliasVars;
      Integer i_varInfo_numIntParams;
      Integer i_varInfo_numIntAlgVars;
      Integer i_varInfo_numAlgAliasVars;
      Integer i_varInfo_numParams;
      Integer i_varInfo_numAlgVars;
      Integer i_varInfo_numStateVars;
      Integer ret_15;
      Boolean ret_14;
      Integer ret_13;
      Integer ret_12;
      Tpl.Text l_numberOfBooleans;
      Integer ret_10;
      Integer ret_9;
      Tpl.Text l_numberOfStrings;
      Integer ret_7;
      Integer ret_6;
      Tpl.Text l_numberOfIntegers;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_numberOfReals;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars, numAlgVars = i_varInfo_numAlgVars, numParams = i_varInfo_numParams, numAlgAliasVars = i_varInfo_numAlgAliasVars, numIntAlgVars = i_varInfo_numIntAlgVars, numIntParams = i_varInfo_numIntParams, numIntAliasVars = i_varInfo_numIntAliasVars, numStringAlgVars = i_varInfo_numStringAlgVars, numStringParamVars = i_varInfo_numStringParamVars, numStringAliasVars = i_varInfo_numStringAliasVars, numBoolAlgVars = i_varInfo_numBoolAlgVars, numBoolParams = i_varInfo_numBoolParams, numBoolAliasVars = i_varInfo_numBoolAliasVars, numZeroCrossings = i_varInfo_numZeroCrossings), vars = SimCode.SIMVARS(stateVars = (i_vars_stateVars as i_listStates), derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars), functions = i_functions) )
      equation
        ret_1 = intMul(i_varInfo_numStateVars, 2);
        ret_2 = intAdd(i_varInfo_numParams, i_varInfo_numAlgAliasVars);
        ret_3 = intAdd(i_varInfo_numAlgVars, ret_2);
        ret_4 = intAdd(ret_1, ret_3);
        l_numberOfReals = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        ret_6 = intAdd(i_varInfo_numIntParams, i_varInfo_numIntAliasVars);
        ret_7 = intAdd(i_varInfo_numIntAlgVars, ret_6);
        l_numberOfIntegers = Tpl.writeStr(Tpl.emptyTxt, intString(ret_7));
        ret_9 = intAdd(i_varInfo_numStringParamVars, i_varInfo_numStringAliasVars);
        ret_10 = intAdd(i_varInfo_numStringAlgVars, ret_9);
        l_numberOfStrings = Tpl.writeStr(Tpl.emptyTxt, intString(ret_10));
        ret_12 = intAdd(i_varInfo_numBoolParams, i_varInfo_numBoolAliasVars);
        ret_13 = intAdd(i_varInfo_numBoolAlgVars, ret_12);
        l_numberOfBooleans = Tpl.writeStr(Tpl.emptyTxt, intString(ret_13));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// define model size\n",
                                    "#define NUMBER_OF_STATES "
                                }, false));
        ret_14 = intEq(i_varInfo_numStateVars, 1);
        txt = fun_83(txt, ret_14, i_listStates, i_varInfo_numStateVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_EVENT_INDICATORS "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numZeroCrossings));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_REALS "));
        txt = Tpl.writeText(txt, l_numberOfReals);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_INTEGERS "));
        txt = Tpl.writeText(txt, l_numberOfIntegers);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_STRINGS "));
        txt = Tpl.writeText(txt, l_numberOfStrings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_BOOLEANS "));
        txt = Tpl.writeText(txt, l_numberOfBooleans);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_EXTERNALFUNCTIONS "));
        ret_15 = SimCodeUtil.countDynamicExternalFunctions(i_functions);
        txt = Tpl.writeStr(txt, intString(ret_15));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "// define variable data for model\n"
                                }, true));
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_84(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_85(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_86(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_87(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_88(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_89(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_90(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_91(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_92(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_93(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_94(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_95(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_96(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_97(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "// define initial state vector as vector of value references\n",
                                    "#define STATES { "
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_99(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "#define STATESDERIVATIVES { "
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_101(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n"
                                }, true));
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_102(txt, i_functions);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ModelDefineData;

public function dervativeNameCStyle
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der_"));
        txt = CodegenUtil.crefStr(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dervativeNameCStyle;

protected function fun_105
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_105;

protected function fun_106
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_description;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_description, in_a_name)
    local
      Tpl.Text txt;
      Tpl.Text a_description;
      DAE.ComponentRef a_name;
      Integer ret_0;

    case ( txt,
           false,
           a_description,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = CodegenC.cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ "));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_description);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_106;

protected function fun_107
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_description;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_description, in_a_name)
    local
      Tpl.Text txt;
      Tpl.Text a_description;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_description,
           a_name )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_106(txt, ret_1, a_description, a_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_107;

public function DefineVariables
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      String i_comment;
      Boolean ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_description;

    case ( txt,
           SimCode.SIMVAR(comment = i_comment, name = i_name) )
      equation
        l_description = fun_105(Tpl.emptyTxt, i_comment);
        txt_1 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_2 = stringEq(Tpl.textString(txt_1), "$dummy");
        txt = fun_107(txt, ret_2, l_description, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end DefineVariables;

public function defineExternalFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      String i_language;
      String i_extName;
      Integer ret_1;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(dynamicLoad = true, extName = i_extName, language = i_language) )
      equation
        l_fname = CodegenC.extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define $P"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        ret_1 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_1));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end defineExternalFunction;

protected function lm_110
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initValsDefault(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_110(txt, rest);
      then txt;
  end match;
end lm_110;

protected function lm_111
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = initValsDefault(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_111(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_111;

protected function lm_112
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = initValsDefault(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_112(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_112;

protected function lm_113
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initValsDefault(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_113(txt, rest);
      then txt;
  end match;
end lm_113;

protected function lm_114
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initValsDefault(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_114(txt, rest);
      then txt;
  end match;
end lm_114;

protected function lm_115
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initValsDefault(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_115(txt, rest);
      then txt;
  end match;
end lm_115;

protected function lm_116
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParamsDefault(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_116(txt, rest);
      then txt;
  end match;
end lm_116;

protected function lm_117
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParamsDefault(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_117(txt, rest);
      then txt;
  end match;
end lm_117;

protected function lm_118
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParamsDefault(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_118(txt, rest);
      then txt;
  end match;
end lm_118;

protected function lm_119
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParamsDefault(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_119(txt, rest);
      then txt;
  end match;
end lm_119;

public function setDefaultStartValues
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_numStateVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stringAlgVars = i_vars_stringAlgVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Set values for all variables that define a start value\n",
                                    "void setDefaultStartValues(ModelInstance *comp) {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_110(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_111(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_112(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_113(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_114(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_115(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_116(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_117(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_118(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_119(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setDefaultStartValues;

protected function lm_121
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initVals(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_121(txt, rest);
      then txt;
  end match;
end lm_121;

protected function lm_122
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = initVals(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_122(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_122;

protected function lm_123
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = initVals(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_123(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_123;

protected function lm_124
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initVals(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_124(txt, rest);
      then txt;
  end match;
end lm_124;

protected function lm_125
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initVals(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_125(txt, rest);
      then txt;
  end match;
end lm_125;

protected function lm_126
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initVals(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_126(txt, rest);
      then txt;
  end match;
end lm_126;

protected function lm_127
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParams(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_127(txt, rest);
      then txt;
  end match;
end lm_127;

protected function lm_128
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParams(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_128(txt, rest);
      then txt;
  end match;
end lm_128;

protected function lm_129
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParams(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_129(txt, rest);
      then txt;
  end match;
end lm_129;

protected function lm_130
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParams(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_130(txt, rest);
      then txt;
  end match;
end lm_130;

public function setStartValues
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_numStateVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stringAlgVars = i_vars_stringAlgVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Set values for all variables that define a start value\n",
                                    "void setStartValues(ModelInstance *comp) {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_121(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_122(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_123(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_124(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_125(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_126(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_127(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_128(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_129(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_130(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setStartValues;

protected function lm_132
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      DAE.ComponentRef i_cref;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (sim_verbose) { printf(\"Setting variable start value: %s(start=%f)\\n\", \""));
        txt = CodegenC.cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", "));
        txt = CodegenC.cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("); }"));
        txt = Tpl.nextIter(txt);
        txt = lm_132(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_132(txt, rest);
      then txt;
  end match;
end lm_132;

public function initializeFunction
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqPart;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_eqPart := Tpl.emptyTxt;
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "// Used to set the first time event, if any.\n",
                                   "void initialize(ModelInstance* comp, fmiEventInfo* eventInfo) {\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_eqPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_132(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end initializeFunction;

protected function fun_134
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_str;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("comp->fmuData->modelData."));
        l_str = Tpl.writeStr(l_str, a_arrayName);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("Data["));
        ret_1 = intAdd(a_index, a_offset);
        l_str = Tpl.writeStr(l_str, intString(ret_1));
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("].attribute.start"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" =  comp->fmuData->localData[0]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_2 = intAdd(a_index, a_offset);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_134;

protected function fun_135
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName, in_a_name)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName,
           a_name )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_134(txt, ret_1, a_offset, a_index, a_arrayName);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_135;

public function initVals
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      Integer i_index;
      DAE.ComponentRef i_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.SIMVAR(name = i_name, index = i_index),
           a_arrayName,
           a_offset )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "$dummy");
        txt = fun_135(txt, ret_1, a_offset, i_index, a_arrayName, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end initVals;

public function initParams
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer i_index;
      Tpl.Text l_str;

    case ( txt,
           SimCode.SIMVAR(index = i_index),
           a_arrayName )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("comp->fmuData->modelData."));
        l_str = Tpl.writeStr(l_str, a_arrayName);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("Data["));
        l_str = Tpl.writeStr(l_str, intString(i_index));
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("].attribute.start"));
        txt = Tpl.writeText(txt, l_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = comp->fmuData->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end initParams;

protected function fun_138
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;
  input Tpl.Text in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__, in_a_str)
    local
      Tpl.Text txt;
      Tpl.Text a_str;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = \"\";"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKOWN_TYPE"));
      then txt;
  end match;
end fun_138;

protected function fun_139
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input DAE.Type in_a_type__;
  input Tpl.Text in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_type__, in_a_str)
    local
      Tpl.Text txt;
      DAE.Type a_type__;
      Tpl.Text a_str;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v),
           _,
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = initVal(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           NONE(),
           a_type__,
           a_str )
      equation
        txt = fun_138(txt, a_type__, a_str);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_139;

public function initValsDefault
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      DAE.Type i_type__;
      Option<DAE.Exp> i_initialValue;
      Integer i_index;
      Integer ret_1;
      Tpl.Text l_str;

    case ( txt,
           SimCode.SIMVAR(index = i_index, type_ = i_type__, initialValue = i_initialValue),
           a_arrayName,
           a_offset )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("comp->fmuData->modelData."));
        l_str = Tpl.writeStr(l_str, a_arrayName);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("Data["));
        ret_1 = intAdd(i_index, a_offset);
        l_str = Tpl.writeStr(l_str, intString(ret_1));
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("].attribute.start"));
        txt = fun_139(txt, i_initialValue, i_type__, l_str);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end initValsDefault;

protected function fun_141
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input Tpl.Text in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_str)
    local
      Tpl.Text txt;
      Tpl.Text a_str;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = initVal(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_141;

public function initParamsDefault
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Option<DAE.Exp> i_initialValue;
      Integer i_index;
      Tpl.Text l_str;

    case ( txt,
           SimCode.SIMVAR(index = i_index, initialValue = i_initialValue),
           a_arrayName )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("comp->fmuData->modelData."));
        l_str = Tpl.writeStr(l_str, a_arrayName);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("Data["));
        l_str = Tpl.writeStr(l_str, intString(i_index));
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("].attribute.start"));
        txt = fun_141(txt, i_initialValue, l_str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end initParamsDefault;

protected function fun_143
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_143;

public function initVal
  input Tpl.Text in_txt;
  input DAE.Exp in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      Absyn.Path i_name;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = Util.escapeModelicaStringToXmlString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_143(txt, i_bool);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index, name = i_name) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*ENUM:"));
        txt = CodegenUtil.dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*ERROR* initial value of unknown type"));
      then txt;
  end match;
end initVal;

public function eventUpdateFunction
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMCODE(modelInfo = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Used to set the next time event, if any.\n",
                                    "void eventUpdate(ModelInstance* comp, fmiEventInfo* eventInfo) {\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end eventUpdateFunction;

protected function lm_146
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVars(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_146(txt, rest);
      then txt;
  end match;
end lm_146;

protected function lm_147
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = SwitchVars(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_147(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_147;

protected function lm_148
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = SwitchVars(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_148(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_148;

protected function lm_149
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParameters(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_149(txt, rest);
      then txt;
  end match;
end lm_149;

protected function lm_150
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVars(txt, i_var, "Real", "-");
        txt = Tpl.nextIter(txt);
        txt = lm_150(txt, rest);
      then txt;
  end match;
end lm_150;

public function getRealFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars), varInfo = SimCode.VARINFO(numStateVars = i_numStateVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiReal getReal(ModelInstance* comp, const fmiValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_146(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_147(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_148(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_149(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_150(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmiError;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getRealFunction;

protected function lm_152
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVarsSet(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_152(txt, rest);
      then txt;
  end match;
end lm_152;

protected function lm_153
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = SwitchVarsSet(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_153(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_153;

protected function lm_154
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = SwitchVarsSet(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_154(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_154;

protected function lm_155
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParametersSet(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_155(txt, rest);
      then txt;
  end match;
end lm_155;

protected function lm_156
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVarsSet(txt, i_var, "Real", "-");
        txt = Tpl.nextIter(txt);
        txt = lm_156(txt, rest);
      then txt;
  end match;
end lm_156;

public function setRealFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars), varInfo = SimCode.VARINFO(numStateVars = i_numStateVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiStatus setReal(ModelInstance* comp, const fmiValueReference vr, const fmiReal value) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_152(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_153(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_154(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_155(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_156(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmiError;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  return fmiOK;\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setRealFunction;

protected function lm_158
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVars(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_158(txt, rest);
      then txt;
  end match;
end lm_158;

protected function lm_159
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParameters(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_159(txt, rest);
      then txt;
  end match;
end lm_159;

protected function lm_160
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVars(txt, i_var, "Integer", "-");
        txt = Tpl.nextIter(txt);
        txt = lm_160(txt, rest);
      then txt;
  end match;
end lm_160;

public function getIntegerFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiInteger getInteger(ModelInstance* comp, const fmiValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_158(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_159(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_160(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getIntegerFunction;

protected function lm_162
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVarsSet(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_162(txt, rest);
      then txt;
  end match;
end lm_162;

protected function lm_163
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParametersSet(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_163(txt, rest);
      then txt;
  end match;
end lm_163;

protected function lm_164
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVarsSet(txt, i_var, "Integer", "-");
        txt = Tpl.nextIter(txt);
        txt = lm_164(txt, rest);
      then txt;
  end match;
end lm_164;

public function setIntegerFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiStatus setInteger(ModelInstance* comp, const fmiValueReference vr, const fmiInteger value) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_162(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_163(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_164(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmiError;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  return fmiOK;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setIntegerFunction;

protected function lm_166
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVars(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_166(txt, rest);
      then txt;
  end match;
end lm_166;

protected function lm_167
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParameters(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_167(txt, rest);
      then txt;
  end match;
end lm_167;

protected function lm_168
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVars(txt, i_var, "Boolean", "!");
        txt = Tpl.nextIter(txt);
        txt = lm_168(txt, rest);
      then txt;
  end match;
end lm_168;

public function getBooleanFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiBoolean getBoolean(ModelInstance* comp, const fmiValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_166(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_167(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_168(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getBooleanFunction;

protected function lm_170
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVarsSet(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_170(txt, rest);
      then txt;
  end match;
end lm_170;

protected function lm_171
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParametersSet(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_171(txt, rest);
      then txt;
  end match;
end lm_171;

protected function lm_172
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVarsSet(txt, i_var, "Boolean", "!");
        txt = Tpl.nextIter(txt);
        txt = lm_172(txt, rest);
      then txt;
  end match;
end lm_172;

public function setBooleanFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiStatus setBoolean(ModelInstance* comp, const fmiValueReference vr, const fmiBoolean value) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_170(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_171(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_172(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmiError;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  return fmiOK;\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setBooleanFunction;

protected function lm_174
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVars(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_174(txt, rest);
      then txt;
  end match;
end lm_174;

protected function lm_175
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParameters(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_175(txt, rest);
      then txt;
  end match;
end lm_175;

protected function lm_176
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVars(txt, i_var, "string", "");
        txt = Tpl.nextIter(txt);
        txt = lm_176(txt, rest);
      then txt;
  end match;
end lm_176;

public function getStringFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiString getString(ModelInstance* comp, const fmiValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_174(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_175(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_176(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getStringFunction;

protected function lm_178
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVarsSet(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_178(txt, rest);
      then txt;
  end match;
end lm_178;

protected function lm_179
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParametersSet(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_179(txt, rest);
      then txt;
  end match;
end lm_179;

protected function lm_180
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVarsSet(txt, i_var, "String", "");
        txt = Tpl.nextIter(txt);
        txt = lm_180(txt, rest);
      then txt;
  end match;
end lm_180;

public function setStringFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiString getString(ModelInstance* comp, const fmiValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_178(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_179(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_180(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setStringFunction;

public function setExternalFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.Function> i_functions;
      Tpl.Text l_externalFuncs;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(stateVars = _), functions = i_functions) )
      equation
        l_externalFuncs = setExternalFunctionsSwitch(Tpl.emptyTxt, i_functions);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiStatus setExternalFunction(ModelInstance* c, const fmiValueReference vr, const void* value){\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_externalFuncs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmiError;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  return fmiOK;\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setExternalFunction;

protected function lm_183
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = setExternalFunctionSwitch(txt, i_fn);
        txt = Tpl.nextIter(txt);
        txt = lm_183(txt, rest);
      then txt;
  end match;
end lm_183;

public function setExternalFunctionsSwitch
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_183(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end setExternalFunctionsSwitch;

public function setExternalFunctionSwitch
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      String i_language;
      String i_extName;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(dynamicLoad = true, extName = i_extName, language = i_language) )
      equation
        l_fname = CodegenC.extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case $P"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : ptr_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=(ptrT_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")value; break;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setExternalFunctionSwitch;

protected function fun_186
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_186;

protected function fun_187
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName, in_a_name)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      DAE.ComponentRef a_name;
      Integer ret_0;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = CodegenC.cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ : return comp->fmuData->localData[0]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = intAdd(a_index, a_offset);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; break;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_187;

protected function fun_188
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName, in_a_name)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName,
           a_name )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_187(txt, ret_1, a_offset, a_index, a_arrayName, a_name);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_188;

public function SwitchVars
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      Integer i_index;
      DAE.ComponentRef i_name;
      String i_comment;
      Boolean ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_description;

    case ( txt,
           SimCode.SIMVAR(comment = i_comment, name = i_name, index = i_index),
           a_arrayName,
           a_offset )
      equation
        l_description = fun_186(Tpl.emptyTxt, i_comment);
        txt_1 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_2 = stringEq(Tpl.textString(txt_1), "$dummy");
        txt = fun_188(txt, ret_2, a_offset, i_index, a_arrayName, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end SwitchVars;

protected function fun_190
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_190;

public function SwitchParameters
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer i_index;
      DAE.ComponentRef i_name;
      String i_comment;
      Tpl.Text l_description;

    case ( txt,
           SimCode.SIMVAR(comment = i_comment, name = i_name, index = i_index),
           a_arrayName )
      equation
        l_description = fun_190(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ : return comp->fmuData->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; break;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end SwitchParameters;

protected function fun_192
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_192;

protected function fun_193
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_varName;
  input String in_a_arrayName;
  input Tpl.Text in_a_crefName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName, in_a_arrayName, in_a_crefName)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_varName;
      String a_arrayName;
      Tpl.Text a_crefName;

    case ( txt,
           false,
           a_varName,
           a_arrayName,
           a_crefName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeText(txt, a_crefName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : return get"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(comp, "));
        txt = CodegenC.cref(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_); break;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           a_crefName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeText(txt, a_crefName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : return comp->fmuData->localData[0]->timeValue; break;"));
      then txt;
  end match;
end fun_193;

protected function fun_194
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_varName;
  input String in_a_arrayName;
  input String in_a_negate;
  input Tpl.Text in_a_crefName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName, in_a_arrayName, in_a_negate, in_a_crefName)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_varName;
      String a_arrayName;
      String a_negate;
      Tpl.Text a_crefName;

    case ( txt,
           false,
           a_varName,
           a_arrayName,
           a_negate,
           a_crefName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeText(txt, a_crefName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : return ("));
        txt = Tpl.writeStr(txt, a_negate);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" get"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(comp, "));
        txt = CodegenC.cref(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_)); break;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           a_crefName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeText(txt, a_crefName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : return comp->fmuData->localData[0]->timeValue; break;"));
      then txt;
  end match;
end fun_194;

protected function fun_195
  input Tpl.Text in_txt;
  input SimCode.AliasVariable in_a_aliasvar;
  input String in_a_negate;
  input String in_a_arrayName;
  input Tpl.Text in_a_crefName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_aliasvar, in_a_negate, in_a_arrayName, in_a_crefName)
    local
      Tpl.Text txt;
      String a_negate;
      String a_arrayName;
      Tpl.Text a_crefName;
      DAE.ComponentRef i_varName;
      Boolean ret_3;
      Tpl.Text txt_2;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.ALIAS(varName = i_varName),
           _,
           a_arrayName,
           a_crefName )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_varName);
        ret_1 = stringEq(Tpl.textString(txt_0), "time");
        txt = fun_193(txt, ret_1, i_varName, a_arrayName, a_crefName);
      then txt;

    case ( txt,
           SimCode.NEGATEDALIAS(varName = i_varName),
           a_negate,
           a_arrayName,
           a_crefName )
      equation
        txt_2 = CodegenUtil.crefStr(Tpl.emptyTxt, i_varName);
        ret_3 = stringEq(Tpl.textString(txt_2), "time");
        txt = fun_194(txt, ret_3, i_varName, a_arrayName, a_negate, a_crefName);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_195;

public function SwitchAliasVars
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;
  input String in_a_negate;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName, in_a_negate)
    local
      Tpl.Text txt;
      String a_arrayName;
      String a_negate;
      SimCode.AliasVariable i_aliasvar;
      DAE.ComponentRef i_name;
      String i_comment;
      Tpl.Text l_crefName;
      Tpl.Text l_description;

    case ( txt,
           SimCode.SIMVAR(comment = i_comment, name = i_name, aliasvar = i_aliasvar),
           a_arrayName,
           a_negate )
      equation
        l_description = fun_192(Tpl.emptyTxt, i_comment);
        l_crefName = CodegenC.cref(Tpl.emptyTxt, i_name);
        l_crefName = Tpl.writeTok(l_crefName, Tpl.ST_STRING("_"));
        txt = fun_195(txt, i_aliasvar, a_negate, a_arrayName, l_crefName);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end SwitchAliasVars;

protected function fun_197
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_197;

protected function fun_198
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName, in_a_name)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      DAE.ComponentRef a_name;
      Integer ret_0;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = CodegenC.cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ : comp->fmuData->localData[0]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = intAdd(a_index, a_offset);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]=value; break;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_198;

protected function fun_199
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName, in_a_name)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName,
           a_name )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_198(txt, ret_1, a_offset, a_index, a_arrayName, a_name);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_199;

public function SwitchVarsSet
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      Integer i_index;
      DAE.ComponentRef i_name;
      String i_comment;
      Boolean ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_description;

    case ( txt,
           SimCode.SIMVAR(comment = i_comment, name = i_name, index = i_index),
           a_arrayName,
           a_offset )
      equation
        l_description = fun_197(Tpl.emptyTxt, i_comment);
        txt_1 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_2 = stringEq(Tpl.textString(txt_1), "$dummy");
        txt = fun_199(txt, ret_2, a_offset, i_index, a_arrayName, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end SwitchVarsSet;

protected function fun_201
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_201;

public function SwitchParametersSet
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer i_index;
      DAE.ComponentRef i_name;
      String i_comment;
      Tpl.Text l_description;

    case ( txt,
           SimCode.SIMVAR(comment = i_comment, name = i_name, index = i_index),
           a_arrayName )
      equation
        l_description = fun_201(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ : comp->fmuData->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]=value; break;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end SwitchParametersSet;

protected function fun_203
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_203;

protected function fun_204
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_varName;
  input String in_a_arrayName;
  input Tpl.Text in_a_crefName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName, in_a_arrayName, in_a_crefName)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_varName;
      String a_arrayName;
      Tpl.Text a_crefName;

    case ( txt,
           false,
           a_varName,
           a_arrayName,
           a_crefName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeText(txt, a_crefName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : return set"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(comp, "));
        txt = CodegenC.cref(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_, value); break;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_204;

protected function fun_205
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_negate;
  input DAE.ComponentRef in_a_varName;
  input String in_a_arrayName;
  input Tpl.Text in_a_crefName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_negate, in_a_varName, in_a_arrayName, in_a_crefName)
    local
      Tpl.Text txt;
      String a_negate;
      DAE.ComponentRef a_varName;
      String a_arrayName;
      Tpl.Text a_crefName;

    case ( txt,
           false,
           a_negate,
           a_varName,
           a_arrayName,
           a_crefName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeText(txt, a_crefName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : return set"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(comp, "));
        txt = CodegenC.cref(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_, ("));
        txt = Tpl.writeStr(txt, a_negate);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" value)); break;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_205;

protected function fun_206
  input Tpl.Text in_txt;
  input SimCode.AliasVariable in_a_aliasvar;
  input String in_a_negate;
  input String in_a_arrayName;
  input Tpl.Text in_a_crefName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_aliasvar, in_a_negate, in_a_arrayName, in_a_crefName)
    local
      Tpl.Text txt;
      String a_negate;
      String a_arrayName;
      Tpl.Text a_crefName;
      DAE.ComponentRef i_varName;
      Boolean ret_3;
      Tpl.Text txt_2;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.ALIAS(varName = i_varName),
           _,
           a_arrayName,
           a_crefName )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_varName);
        ret_1 = stringEq(Tpl.textString(txt_0), "time");
        txt = fun_204(txt, ret_1, i_varName, a_arrayName, a_crefName);
      then txt;

    case ( txt,
           SimCode.NEGATEDALIAS(varName = i_varName),
           a_negate,
           a_arrayName,
           a_crefName )
      equation
        txt_2 = CodegenUtil.crefStr(Tpl.emptyTxt, i_varName);
        ret_3 = stringEq(Tpl.textString(txt_2), "time");
        txt = fun_205(txt, ret_3, a_negate, i_varName, a_arrayName, a_crefName);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_206;

public function SwitchAliasVarsSet
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;
  input String in_a_negate;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName, in_a_negate)
    local
      Tpl.Text txt;
      String a_arrayName;
      String a_negate;
      SimCode.AliasVariable i_aliasvar;
      DAE.ComponentRef i_name;
      String i_comment;
      Tpl.Text l_crefName;
      Tpl.Text l_description;

    case ( txt,
           SimCode.SIMVAR(comment = i_comment, name = i_name, aliasvar = i_aliasvar),
           a_arrayName,
           a_negate )
      equation
        l_description = fun_203(Tpl.emptyTxt, i_comment);
        l_crefName = CodegenC.cref(Tpl.emptyTxt, i_name);
        l_crefName = Tpl.writeTok(l_crefName, Tpl.ST_STRING("_"));
        txt = fun_206(txt, i_aliasvar, a_negate, a_arrayName, l_crefName);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end SwitchAliasVarsSet;

protected function fun_208
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "OSX" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lf2c -llis"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-Wl,-Bstatic -lf2c -Wl,-Bdynamic -llis"));
      then txt;
  end match;
end fun_208;

protected function fun_209
  input Tpl.Text in_txt;
  input String in_a_platform;
  input String in_a_libsPos2;
  input String in_a_libsPos1;
  input String in_a_dirExtra;
  input String in_a_omhome;
  input Tpl.Text in_a_fmudirname;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_platform, in_a_libsPos2, in_a_libsPos1, in_a_dirExtra, in_a_omhome, in_a_fmudirname, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      String a_libsPos2;
      String a_libsPos1;
      String a_dirExtra;
      String a_omhome;
      Tpl.Text a_fmudirname;
      String a_fileNamePrefix;
      String i_platform;
      String ret_0;

    case ( txt,
           (i_platform as "win32"),
           a_libsPos2,
           a_libsPos1,
           a_dirExtra,
           a_omhome,
           a_fmudirname,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU: "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".def "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".dll\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" dlltool -d "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".def --dllname "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".dll --output-lib "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".lib --kill-at\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".dll "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".lib "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_model.h "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_model.h\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.c "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_FMU.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_info.c "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_info.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_init.c "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_init.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.c "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_functions.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.h "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_functions.h\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.c "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp modelDescription.xml "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/modelDescription.xml\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/libexec/gnuplot/binary/libexpat-1.dll "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cd "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&& rm -f ../"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".fmu&& zip -r ../"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".fmu *\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" rm -rf "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" rm -f "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".def "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.libs "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.makefile "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_records.o\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".dll: clean "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.o\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CXX) -shared -I. -o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".dll "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o  $(CPPFLAGS) "));
        txt = Tpl.writeStr(txt, a_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " $(CFLAGS) $(LDFLAGS) -Wl,-Bstatic -lf2c -Wl,-Bdynamic -llis -Wl,--kill-at\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"mkdir.exe\" -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"mkdir.exe\" -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/binaries\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"mkdir.exe\" -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"mkdir.exe\" -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources"));
      then txt;

    case ( txt,
           _,
           a_libsPos2,
           a_libsPos1,
           a_dirExtra,
           _,
           a_fmudirname,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU: "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.o\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CXX) -shared -I. -o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o $(CPPFLAGS) "));
        txt = Tpl.writeStr(txt, a_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CFLAGS) $(LDFLAGS) "));
        ret_0 = System.os();
        txt = fun_208(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" mkdir -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" mkdir -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/binaries\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" mkdir -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/binaries/$(PLATFORM)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" mkdir -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/sources\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/binaries/$(PLATFORM)/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.libs "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/binaries/$(PLATFORM)/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_model.h "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_model.h\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_info.c "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_info.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_init.c "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_init.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.c "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_FMU.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.c "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_functions.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.h "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_functions.h\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.c "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp modelDescription.xml "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/modelDescription.xml\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cd "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; rm -f ../"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".fmu && zip -r ../"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".fmu *\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" rm -rf "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" rm -f "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".def "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.libs "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.makefile "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_records.o\n",
                                    "\n"
                                }, true));
      then txt;
  end match;
end fun_209;

public function getPlatformString2
  input Tpl.Text txt;
  input String a_platform;
  input String a_fileNamePrefix;
  input String a_dirExtra;
  input String a_libsPos1;
  input String a_libsPos2;
  input String a_omhome;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_fmudirname;
algorithm
  l_fmudirname := Tpl.writeStr(Tpl.emptyTxt, a_fileNamePrefix);
  l_fmudirname := Tpl.writeTok(l_fmudirname, Tpl.ST_STRING(".fmutmp"));
  out_txt := fun_209(txt, a_platform, a_libsPos2, a_libsPos1, a_dirExtra, a_omhome, l_fmudirname, a_fileNamePrefix);
end getPlatformString2;

protected function fun_211
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_211;

protected function lm_212
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_212(txt, rest);
      then txt;
  end match;
end lm_212;

protected function fun_213
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_213;

protected function fun_214
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_214;

protected function fun_215
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end match;
end fun_215;

protected function fun_216
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER"));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_216;

protected function fun_217
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_215(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_216(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_217;

protected function fun_218
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_makefileParams_omhome;
      String i_makefileParams_platform;
      Option<SimCode.SimulationSettings> i_sopt;
      String i_fileNamePrefix;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      String ret_7;
      Tpl.Text l_compilecmds;
      Tpl.Text l_extraCflags;
      Tpl.Text l_fmudirname;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, platform = i_makefileParams_platform, omhome = i_makefileParams_omhome), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix) )
      equation
        l_dirExtra = fun_211(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_212(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_213(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_214(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_fmudirname = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        l_fmudirname = Tpl.writeTok(l_fmudirname, Tpl.ST_STRING(".fmutmp"));
        l_extraCflags = fun_217(Tpl.emptyTxt, i_sopt);
        l_compilecmds = getPlatformString2(Tpl.emptyTxt, i_makefileParams_platform, i_fileNamePrefix, Tpl.textString(l_dirExtra), Tpl.textString(l_libsPos1), Tpl.textString(l_libsPos2), i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O3 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=\n",
                                    "MODELICAUSERCFLAGS=\n",
                                    "CXX=cl\n",
                                    "EXEEXT=.exe\n",
                                    "DLLEXT=.dll\n",
                                    "FMUEXT=.fmu\n",
                                    "PLATLINUX = linux32\n",
                                    "PLATWIN32 = win32\n",
                                    "\n",
                                    "# /Od - Optimization disabled\n",
                                    "# /EHa enable C++ EH (w/ SEH exceptions)\n",
                                    "# /fp:except - consider floating-point exceptions when generating code\n",
                                    "# /arch:SSE2 - enable use of instructions available with SSE2 enabled CPUs\n",
                                    "# /I - Include Directories\n",
                                    "# /DNOMINMAX - Define NOMINMAX (does what it says)\n",
                                    "# /TP - Use C++ Compiler\n",
                                    "CFLAGS=/Od /ZI /EHa /fp:except /I\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/include/omc\" /I. /DNOMINMAX /TP /DNO_INTERACTIVE_DEPENDENCY\n",
                                    "\n",
                                    "# /ZI enable Edit and Continue debug info\n",
                                    "CDFLAGS = /ZI\n",
                                    "\n",
                                    "# /MD - link with MSVCRT.LIB\n",
                                    "# /link - [linker options and libraries]\n",
                                    "# /LIBPATH: - Directories where libs can be found\n",
                                    "LDFLAGS=/MD /link /dll /debug /pdb:\""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".pdb\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/msvc/\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/msvc/release/\" "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " f2c.lib initialization.lib libexpat.lib math-support.lib meta.lib ModelicaExternalC.lib results.lib simulation.lib solver.lib sundials_kinsol.lib sundials_nvecserial.lib util.lib lapack_win32_MT.lib\n",
                                    "\n",
                                    "# /MDd link with MSVCRTD.LIB debug lib\n",
                                    "# lib names should not be appended with a d just switch to lib/omc/msvc/debug\n",
                                    "\n",
                                    "\n",
                                    "FILEPREFIX="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MAINFILE=$(FILEPREFIX).c\n",
                                    "MAINOBJ=$(FILEPREFIX).obj\n",
                                    "GENERATEDFILES=$(MAINFILE) $(FILEPREFIX)_functions.c $(FILEPREFIX)_functions.h $(FILEPREFIX)_records.c $(FILEPREFIX).makefile\n",
                                    "\n",
                                    "$(FILEPREFIX)$(FMUEXT): $(FILEPREFIX)$(DLLEXT) modelDescription.xml\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if not exist "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\binaries\\$(PLATWIN32) mkdir "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\binaries\\$(PLATWIN32)\n",
                                    "if not exist "
                                }, false));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources mkdir "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\sources\n",
                                    "\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".dll "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\binaries\\$(PLATWIN32)\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".lib "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\binaries\\$(PLATWIN32)\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".pdb "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\binaries\\$(PLATWIN32)\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".c\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_model.h "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_model.h\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.c "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_FMU.c\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_info.c "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_info.c\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_init.c "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_init.c\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.c "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.c\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.h "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.h\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.c "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_records.c\n",
                                    "copy modelDescription.xml "
                                }, false));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\modelDescription.xml\n",
                                    "copy "
                                }, false));
        ret_7 = System.stringReplace(i_makefileParams_omhome, "/", "\\");
        txt = Tpl.writeStr(txt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\lib\\omc\\libexec\\gnuplot\\binary\\libexpat-1.dll "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\binaries\\$(PLATWIN32)\n",
                                    "cd "
                                }, false));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"$(MINGW)\\bin\\zip.exe\" -r ../"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".fmu *\n",
                                    "cd ..\n",
                                    "rmdir /S /Q "
                                }, false));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "$(FILEPREFIX)$(DLLEXT): $(MAINOBJ) $(FILEPREFIX)_records.c $(FILEPREFIX)_functions.c $(FILEPREFIX)_functions.h\n",
                                    "    $(CXX) /Fe$(FILEPREFIX)$(DLLEXT) $(MAINFILE) $(FILEPREFIX)_FMU.c $(FILEPREFIX)_records.c $(CFLAGS) $(LDFLAGS)"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_218;

protected function fun_219
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_219;

protected function lm_220
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_220(txt, rest);
      then txt;
  end match;
end lm_220;

protected function fun_221
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_221;

protected function fun_222
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_222;

protected function fun_223
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end match;
end fun_223;

protected function fun_224
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER"));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_224;

protected function fun_225
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_223(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_224(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_225;

protected function fun_226
  input Tpl.Text in_txt;
  input String in_a_makefileParams_platform;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_makefileParams_platform)
    local
      Tpl.Text txt;
      String i_makefileParams_platform;

    case ( txt,
           "linux-i686" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("linux32"));
      then txt;

    case ( txt,
           i_makefileParams_platform )
      equation
        txt = Tpl.writeStr(txt, i_makefileParams_platform);
      then txt;
  end match;
end fun_226;

protected function fun_227
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_cflags;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(cflags = i_s_cflags)) )
      equation
        txt = Tpl.writeStr(txt, i_s_cflags);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_227;

protected function lm_228
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_228(txt, rest);
      then txt;
  end match;
end lm_228;

protected function fun_229
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end match;
end fun_229;

protected function fun_230
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end match;
end fun_230;

protected function fun_231
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_makefileParams_runtimelibs;
      String i_makefileParams_ldflags;
      list<String> i_makefileParams_includes;
      String i_makefileParams_cflags;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      String i_makefileParams_omhome;
      String i_fileNamePrefix;
      String i_makefileParams_platform;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      Boolean ret_8;
      Boolean ret_7;
      Tpl.Text l_platformstr;
      Tpl.Text l_compilecmds;
      Tpl.Text l_extraCflags;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, platform = i_makefileParams_platform, omhome = i_makefileParams_omhome, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, cflags = i_makefileParams_cflags, includes = i_makefileParams_includes, ldflags = i_makefileParams_ldflags, runtimelibs = i_makefileParams_runtimelibs), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix) )
      equation
        l_dirExtra = fun_219(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_220(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_221(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_222(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_extraCflags = fun_225(Tpl.emptyTxt, i_sopt);
        l_compilecmds = getPlatformString2(Tpl.emptyTxt, i_makefileParams_platform, i_fileNamePrefix, Tpl.textString(l_dirExtra), Tpl.textString(l_libsPos1), Tpl.textString(l_libsPos2), i_makefileParams_omhome);
        l_platformstr = fun_226(Tpl.emptyTxt, i_makefileParams_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulation of the fmu with dymola does not work\n",
                                    "# with inline-small-functions\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=-O #-O2  -fno-inline-small-functions\n",
                                    "CC="
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS_BASED_ON_INIT_FILE="));
        txt = Tpl.writeText(txt, l_extraCflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("PLATFORM = "));
        txt = Tpl.writeText(txt, l_platformstr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("PLAT34 = "));
        txt = Tpl.writeStr(txt, i_makefileParams_platform);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS=$(CFLAGS_BASED_ON_INIT_FILE) -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc\" "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_227(txt, i_sopt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CPPFLAGS=-I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc\" -I. "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_228(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS=-L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -Wl,-rpath,\'"));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\' -lSimulationRuntimeC -linteractive "));
        txt = Tpl.writeStr(txt, i_makefileParams_ldflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_runtimelibs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "PERL=perl\n",
                                    "MAINFILE="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU"));
        ret_7 = Config.acceptMetaModelicaGrammar();
        txt = fun_229(txt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".c\n",
                                    "MAINOBJ="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU"));
        ret_8 = Config.acceptMetaModelicaGrammar();
        txt = fun_230(txt, ret_8);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".o\n",
                                    "\n",
                                    "PHONY: "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_FMU\n"));
        txt = Tpl.writeText(txt, l_compilecmds);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv.c: "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(PERL) "));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/share/omc/scripts/convert_lines.pl $< $@.tmp\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " @mv $@.tmp $@\n",
                                    "$(MAINOBJ): $(MAINFILE) "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.h\n",
                                    "clean:\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" @rm -f "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o $(MAINOBJ) "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_231;

public function fmuMakefile
  input Tpl.Text in_txt;
  input String in_a_target;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_target, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      String i_target;
      Tpl.Text txt_0;

    case ( txt,
           "msvc",
           a_simCode )
      equation
        txt = fun_218(txt, a_simCode);
      then txt;

    case ( txt,
           "gcc",
           a_simCode )
      equation
        txt = fun_231(txt, a_simCode);
      then txt;

    case ( txt,
           i_target,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("target "));
        txt_0 = Tpl.writeStr(txt_0, i_target);
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_STRING(" is not handled!"));
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenFMU.tpl", 1185, 9), Tpl.textString(txt_0));
      then txt;
  end match;
end fmuMakefile;

public function fmudeffile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), makefileParams = SimCode.MAKEFILE_PARAMS(ccompiler = _), simulationSettingsOpt = _, fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("EXPORTS\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiCompletedIntegratorStep @1\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiEventUpdate @2\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiFreeModelInstance @3\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetBoolean @4\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetContinuousStates @5\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetDerivatives @6\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetEventIndicators @7\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetInteger @8\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetModelTypesPlatform @9\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetNominalContinuousStates @10\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetReal @11\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetStateValueReferences @12\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetString @13\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetVersion @14\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiInitialize @15\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiInstantiateModel @16\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetBoolean @17\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetContinuousStates @18\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetDebugLogging @19\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetExternalFunction @20\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetInteger @21\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetReal @22\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetString @23\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetTime @24\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_fmiTerminate @25"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fmudeffile;

protected function fun_234
  input Tpl.Text in_txt;
  input FMI.Info in_a_fmiInfo;
  input FMI.FmiImport in_a_fmi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiInfo, in_a_fmi)
    local
      Tpl.Text txt;
      FMI.FmiImport a_fmi;

    case ( txt,
           FMI.INFO(fmiVersion = "1.0", fmiType = 0),
           a_fmi )
      equation
        txt = importFMU1ModelExchange(txt, a_fmi);
      then txt;

    case ( txt,
           FMI.INFO(fmiVersion = "1.0", fmiType = 1),
           a_fmi )
      equation
        txt = importFMU1CoSimulationStandAlone(txt, a_fmi);
      then txt;

    case ( txt,
           FMI.INFO(fmiVersion = "2.0", fmiType = 1),
           a_fmi )
      equation
        txt = importFMU2ModelExchange(txt, a_fmi);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_234;

public function importFMUModelica
  input Tpl.Text in_txt;
  input FMI.FmiImport in_a_fmi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmi)
    local
      Tpl.Text txt;
      FMI.FmiImport i_fmi;
      FMI.Info i_fmiInfo;

    case ( txt,
           (i_fmi as FMI.FMIIMPORT(fmiInfo = (i_fmiInfo as FMI.INFO(fmiVersion = _)))) )
      equation
        txt = fun_234(txt, i_fmiInfo, i_fmi);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end importFMUModelica;

protected function fun_236
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fmiInfo_fmiDescription;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiDescription)
    local
      Tpl.Text txt;
      String a_fmiInfo_fmiDescription;

    case ( txt,
           false,
           a_fmiInfo_fmiDescription )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \""));
        txt = Tpl.writeStr(txt, a_fmiInfo_fmiDescription);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_236;

protected function fun_237
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realInputVariablesReturnNames;

    case ( txt,
           false,
           a_realInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_realInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_237;

protected function fun_238
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerInputVariablesReturnNames;

    case ( txt,
           false,
           a_integerInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_integerInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_238;

protected function fun_239
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanInputVariablesReturnNames;

    case ( txt,
           false,
           a_booleanInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_booleanInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_239;

protected function fun_240
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringInputVariablesReturnNames;

    case ( txt,
           false,
           a_stringInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_stringInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_240;

protected function fun_241
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  fmi_x := fmi1Functions.fmi1GetContinuousStates(fmi1me, numberOfContinuousStates, flowParamsStart);"));
      then txt;
  end match;
end fun_241;

protected function fun_242
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realInputVariablesNames;
  input Tpl.Text in_a_realInputVariablesVRs;
  input Tpl.Text in_a_realInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realInputVariablesNames, in_a_realInputVariablesVRs, in_a_realInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realInputVariablesNames;
      Tpl.Text a_realInputVariablesVRs;
      Tpl.Text a_realInputVariablesReturnNames;

    case ( txt,
           false,
           a_realInputVariablesNames,
           a_realInputVariablesVRs,
           a_realInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_realInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1SetReal(fmi1me, {"));
        txt = Tpl.writeText(txt, a_realInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_realInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_242;

protected function fun_243
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerInputVariablesNames;
  input Tpl.Text in_a_integerInputVariablesVRs;
  input Tpl.Text in_a_integerInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerInputVariablesNames, in_a_integerInputVariablesVRs, in_a_integerInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerInputVariablesNames;
      Tpl.Text a_integerInputVariablesVRs;
      Tpl.Text a_integerInputVariablesReturnNames;

    case ( txt,
           false,
           a_integerInputVariablesNames,
           a_integerInputVariablesVRs,
           a_integerInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_integerInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1SetInteger(fmi1me, {"));
        txt = Tpl.writeText(txt, a_integerInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_integerInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_243;

protected function fun_244
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanInputVariablesNames;
  input Tpl.Text in_a_booleanInputVariablesVRs;
  input Tpl.Text in_a_booleanInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanInputVariablesNames, in_a_booleanInputVariablesVRs, in_a_booleanInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanInputVariablesNames;
      Tpl.Text a_booleanInputVariablesVRs;
      Tpl.Text a_booleanInputVariablesReturnNames;

    case ( txt,
           false,
           a_booleanInputVariablesNames,
           a_booleanInputVariablesVRs,
           a_booleanInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1SetBoolean(fmi1me, {"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_244;

protected function fun_245
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringStartVariablesNames;
  input Tpl.Text in_a_stringInputVariablesVRs;
  input Tpl.Text in_a_stringInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringStartVariablesNames, in_a_stringInputVariablesVRs, in_a_stringInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringStartVariablesNames;
      Tpl.Text a_stringInputVariablesVRs;
      Tpl.Text a_stringInputVariablesReturnNames;

    case ( txt,
           false,
           a_stringStartVariablesNames,
           a_stringInputVariablesVRs,
           a_stringInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_stringInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1SetString(fmi1me, {"));
        txt = Tpl.writeText(txt, a_stringInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_stringStartVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_245;

protected function fun_246
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realOutputVariablesVRs;
  input Tpl.Text in_a_realOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realOutputVariablesVRs, in_a_realOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realOutputVariablesVRs;
      Tpl.Text a_realOutputVariablesNames;

    case ( txt,
           false,
           a_realOutputVariablesVRs,
           a_realOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_realOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetReal(fmi1me, {"));
        txt = Tpl.writeText(txt, a_realOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_246;

protected function fun_247
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerOutputVariablesVRs;
  input Tpl.Text in_a_integerOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerOutputVariablesVRs, in_a_integerOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerOutputVariablesVRs;
      Tpl.Text a_integerOutputVariablesNames;

    case ( txt,
           false,
           a_integerOutputVariablesVRs,
           a_integerOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_integerOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetInteger(fmi1me, {"));
        txt = Tpl.writeText(txt, a_integerOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_247;

protected function fun_248
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanOutputVariablesVRs;
  input Tpl.Text in_a_booleanOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanOutputVariablesVRs, in_a_booleanOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanOutputVariablesVRs;
      Tpl.Text a_booleanOutputVariablesNames;

    case ( txt,
           false,
           a_booleanOutputVariablesVRs,
           a_booleanOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_booleanOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetBoolean(fmi1me, {"));
        txt = Tpl.writeText(txt, a_booleanOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_248;

protected function fun_249
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringOutputVariablesVRs;
  input Tpl.Text in_a_stringOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringOutputVariablesVRs, in_a_stringOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringOutputVariablesVRs;
      Tpl.Text a_stringOutputVariablesNames;

    case ( txt,
           false,
           a_stringOutputVariablesVRs,
           a_stringOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_stringOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetString(fmi1me, {"));
        txt = Tpl.writeText(txt, a_stringOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_249;

protected function lm_250
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_eventIndicator;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eventIndicator :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("change(fmi_z_positive["));
        txt = Tpl.writeStr(txt, intString(i_eventIndicator));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
        txt = Tpl.nextIter(txt);
        txt = lm_250(txt, rest);
      then txt;
  end match;
end lm_250;

protected function fun_251
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<Integer> in_a_fmiInfo_fmiNumberOfEventIndicators;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiNumberOfEventIndicators)
    local
      Tpl.Text txt;
      list<Integer> a_fmiInfo_fmiNumberOfEventIndicators;

    case ( txt,
           false,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  when {not initial(), triggerDSSEvent > flowStatesInputs, nextEventTime < time} then"));
      then txt;

    case ( txt,
           _,
           a_fmiInfo_fmiNumberOfEventIndicators )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when {("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" or ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_250(txt, a_fmiInfo_fmiNumberOfEventIndicators);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") and not initial(),triggerDSSEvent > flowStatesInputs, nextEventTime < time} then"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_251;

protected function lm_252
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_continuousStates;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_continuousStates :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("reinit(fmi_x["));
        txt = Tpl.writeStr(txt, intString(i_continuousStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("], fmi_x_new["));
        txt = Tpl.writeStr(txt, intString(i_continuousStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]);"));
        txt = Tpl.nextIter(txt);
        txt = lm_252(txt, rest);
      then txt;
  end match;
end lm_252;

protected function fun_253
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<Integer> in_a_fmiInfo_fmiNumberOfContinuousStates;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiNumberOfContinuousStates)
    local
      Tpl.Text txt;
      list<Integer> a_fmiInfo_fmiNumberOfContinuousStates;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fmiInfo_fmiNumberOfContinuousStates )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    if newStatesAvailable then\n",
                                    "      fmi_x_new := fmi1Functions.fmi1GetContinuousStates(fmi1me, numberOfContinuousStates, flowStatesInputs);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_252(txt, a_fmiInfo_fmiNumberOfContinuousStates);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    end if;"));
      then txt;
  end match;
end fun_253;

protected function fun_254
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_254;

protected function fun_255
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_255;

protected function fun_256
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_256;

protected function fun_257
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_257;

protected function fun_258
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_258;

protected function fun_259
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_259;

protected function fun_260
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_260;

protected function fun_261
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_261;

protected function fun_262
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_262;

protected function fun_263
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_263;

protected function fun_264
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_264;

protected function fun_265
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_265;

protected function fun_266
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_266;

protected function fun_267
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_267;

protected function fun_268
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_268;

protected function fun_269
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_269;

protected function fun_270
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_270;

protected function fun_271
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_271;

public function importFMU1ModelExchange
  input Tpl.Text in_txt;
  input FMI.FmiImport in_a_fmi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmi)
    local
      Tpl.Text txt;
      String i_platform;
      Real i_fmiExperimentAnnotation_fmiExperimentTolerance;
      Real i_fmiExperimentAnnotation_fmiExperimentStopTime;
      Real i_fmiExperimentAnnotation_fmiExperimentStartTime;
      list<Integer> i_fmiInfo_fmiNumberOfEventIndicators;
      list<Integer> i_fmiInfo_fmiNumberOfContinuousStates;
      Boolean i_generateOutputConnectors;
      Boolean i_generateInputConnectors;
      Boolean i_fmiDebugOutput;
      Integer i_fmiLogLevel;
      String i_fmuWorkingDirectory;
      String i_fmuFileName;
      String i_fmiInfo_fmiDescription;
      FMI.Info i_fmiInfo;
      String i_fmiInfo_fmiModelIdentifier;
      list<FMI.ModelVariables> i_fmiModelVariablesList;
      String ret_68;
      Boolean ret_67;
      Boolean ret_66;
      Boolean ret_65;
      Boolean ret_64;
      Boolean ret_63;
      Boolean ret_62;
      Boolean ret_61;
      Boolean ret_60;
      Boolean ret_59;
      Boolean ret_58;
      Boolean ret_57;
      Boolean ret_56;
      Boolean ret_55;
      Boolean ret_54;
      Boolean ret_53;
      Boolean ret_52;
      Boolean ret_51;
      Boolean ret_50;
      Boolean ret_49;
      Integer ret_48;
      Boolean ret_47;
      Integer ret_46;
      Boolean ret_45;
      Boolean ret_44;
      Boolean ret_43;
      Boolean ret_42;
      Boolean ret_41;
      Boolean ret_40;
      Boolean ret_39;
      Boolean ret_38;
      Boolean ret_37;
      Boolean ret_36;
      Boolean ret_35;
      Boolean ret_34;
      Boolean ret_33;
      Boolean ret_32;
      Boolean ret_31;
      Boolean ret_30;
      Boolean ret_29;
      Integer ret_28;
      Boolean ret_27;
      Boolean ret_26;
      Boolean ret_25;
      Boolean ret_24;
      Integer ret_23;
      Integer ret_22;
      Boolean ret_21;
      String ret_20;
      Tpl.Text l_stringOutputVariablesNames;
      Tpl.Text l_stringOutputVariablesVRs;
      Tpl.Text l_booleanOutputVariablesNames;
      Tpl.Text l_booleanOutputVariablesVRs;
      Tpl.Text l_integerOutputVariablesNames;
      Tpl.Text l_integerOutputVariablesVRs;
      Tpl.Text l_realOutputVariablesNames;
      Tpl.Text l_realOutputVariablesVRs;
      Tpl.Text l_stringInputVariablesReturnNames;
      Tpl.Text l_stringStartVariablesNames;
      Tpl.Text l_stringInputVariablesVRs;
      Tpl.Text l_booleanInputVariablesReturnNames;
      Tpl.Text l_booleanInputVariablesNames;
      Tpl.Text l_booleanInputVariablesVRs;
      Tpl.Text l_integerInputVariablesReturnNames;
      Tpl.Text l_integerInputVariablesNames;
      Tpl.Text l_integerInputVariablesVRs;
      Tpl.Text l_realInputVariablesReturnNames;
      Tpl.Text l_realInputVariablesNames;
      Tpl.Text l_realInputVariablesVRs;

    case ( txt,
           FMI.FMIIMPORT(fmiInfo = (i_fmiInfo as FMI.INFO(fmiModelIdentifier = i_fmiInfo_fmiModelIdentifier, fmiDescription = i_fmiInfo_fmiDescription, fmiNumberOfContinuousStates = i_fmiInfo_fmiNumberOfContinuousStates, fmiNumberOfEventIndicators = i_fmiInfo_fmiNumberOfEventIndicators)), fmiExperimentAnnotation = FMI.EXPERIMENTANNOTATION(fmiExperimentStartTime = i_fmiExperimentAnnotation_fmiExperimentStartTime, fmiExperimentStopTime = i_fmiExperimentAnnotation_fmiExperimentStopTime, fmiExperimentTolerance = i_fmiExperimentAnnotation_fmiExperimentTolerance), fmiModelVariablesList = i_fmiModelVariablesList, fmuFileName = i_fmuFileName, fmuWorkingDirectory = i_fmuWorkingDirectory, fmiLogLevel = i_fmiLogLevel, fmiDebugOutput = i_fmiDebugOutput, generateInputConnectors = i_generateInputConnectors, generateOutputConnectors = i_generateOutputConnectors, platform = i_platform) )
      equation
        l_realInputVariablesVRs = dumpInputRealVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realInputVariablesNames = dumpInputRealVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realInputVariablesReturnNames = dumpInputRealVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesVRs = dumpInputIntegerVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesNames = dumpInputIntegerVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesReturnNames = dumpInputIntegerVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesVRs = dumpInputBooleanVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesNames = dumpInputBooleanVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesReturnNames = dumpInputBooleanVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringInputVariablesVRs = dumpInputStringVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringStartVariablesNames = dumpInputStringVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringInputVariablesReturnNames = dumpInputStringVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realOutputVariablesVRs = dumpOutputRealVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realOutputVariablesNames = dumpOutputRealVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerOutputVariablesVRs = dumpOutputIntegerVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerOutputVariablesNames = dumpOutputIntegerVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanOutputVariablesVRs = dumpOutputBooleanVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanOutputVariablesNames = dumpOutputBooleanVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringOutputVariablesVRs = dumpOutputStringVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringOutputVariablesNames = dumpOutputStringVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("model "));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        ret_20 = FMI.getFMIType(i_fmiInfo);
        txt = Tpl.writeStr(txt, ret_20);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU"));
        ret_21 = stringEq(i_fmiInfo_fmiDescription, "");
        txt = fun_236(txt, ret_21, i_fmiInfo_fmiDescription);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant String fmuLocation = \""));
        txt = Tpl.writeStr(txt, i_fmuFileName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "constant String fmuWorkingDir = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fmuWorkingDirectory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "parameter Integer logLevel = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_fmiLogLevel));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"log level used during the loading of FMU\" annotation (Dialog(tab=\"FMI\", group=\"Enable logging\"));\n",
                                    "parameter Boolean debugLogging = "
                                }, false));
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_fmiDebugOutput));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"enables the FMU simulation logging\" annotation (Dialog(tab=\"FMI\", group=\"Enable logging\"));\n",
                                    "FMI1ModelExchange fmi1me = FMI1ModelExchange(logLevel, fmuWorkingDir, \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\", debugLogging);\n"));
        txt = dumpFMIModelVariablesList(txt, i_fmiModelVariablesList, i_generateInputConnectors, i_generateOutputConnectors);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant Integer numberOfContinuousStates = "));
        ret_22 = listLength(i_fmiInfo_fmiNumberOfContinuousStates);
        txt = Tpl.writeStr(txt, intString(ret_22));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "Real fmi_x[numberOfContinuousStates] \"States\";\n",
                                    "Real fmi_x_new[numberOfContinuousStates] \"New States\";\n",
                                    "constant Integer numberOfEventIndicators = "
                                }, false));
        ret_23 = listLength(i_fmiInfo_fmiNumberOfEventIndicators);
        txt = Tpl.writeStr(txt, intString(ret_23));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "Real fmi_z[numberOfEventIndicators] \"Events Indicators\";\n",
                                    "Boolean fmi_z_positive[numberOfEventIndicators];\n",
                                    "Real flowTime;\n",
                                    "parameter Real flowParamsStart(fixed=false);\n"
                                }, true));
        ret_24 = stringEq(Tpl.textString(l_realInputVariablesVRs), "");
        txt = fun_237(txt, ret_24, l_realInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_25 = stringEq(Tpl.textString(l_integerInputVariablesVRs), "");
        txt = fun_238(txt, ret_25, l_integerInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_26 = stringEq(Tpl.textString(l_booleanInputVariablesVRs), "");
        txt = fun_239(txt, ret_26, l_booleanInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_27 = stringEq(Tpl.textString(l_stringInputVariablesVRs), "");
        txt = fun_240(txt, ret_27, l_stringInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Real flowStatesInputs;\n",
                                    "Boolean callEventUpdate;\n",
                                    "constant Boolean intermediateResults = false;\n",
                                    "Boolean newStatesAvailable;\n",
                                    "Real triggerDSSEvent;\n",
                                    "Real nextEventTime;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "initial algorithm\n",
                                    "  flowParamsStart := 0;\n"
                                }, true));
        ret_28 = listLength(i_fmiInfo_fmiNumberOfContinuousStates);
        ret_29 = intGt(ret_28, 0);
        txt = fun_241(txt, ret_29);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "equation\n",
                                    "  flowTime = fmi1Functions.fmi1SetTime(fmi1me, time);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_30 = stringEq(Tpl.textString(l_realInputVariablesVRs), "");
        txt = fun_242(txt, ret_30, l_realInputVariablesNames, l_realInputVariablesVRs, l_realInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_31 = stringEq(Tpl.textString(l_integerInputVariablesVRs), "");
        txt = fun_243(txt, ret_31, l_integerInputVariablesNames, l_integerInputVariablesVRs, l_integerInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_32 = stringEq(Tpl.textString(l_booleanInputVariablesVRs), "");
        txt = fun_244(txt, ret_32, l_booleanInputVariablesNames, l_booleanInputVariablesVRs, l_booleanInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_33 = stringEq(Tpl.textString(l_stringInputVariablesVRs), "");
        txt = fun_245(txt, ret_33, l_stringStartVariablesNames, l_stringInputVariablesVRs, l_stringInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "flowStatesInputs = fmi1Functions.fmi1SetContinuousStates(fmi1me, fmi_x, flowParamsStart + flowTime);\n",
                                    "der(fmi_x) = fmi1Functions.fmi1GetDerivatives(fmi1me, numberOfContinuousStates, flowStatesInputs);\n",
                                    "fmi_z  = fmi1Functions.fmi1GetEventIndicators(fmi1me, numberOfEventIndicators, flowStatesInputs);\n",
                                    "for i in 1:size(fmi_z,1) loop\n",
                                    "  fmi_z_positive[i] = if not terminal() then fmi_z[i] > 0 else pre(fmi_z_positive[i]);\n",
                                    "end for;\n",
                                    "callEventUpdate = fmi1Functions.fmi1CompletedIntegratorStep(fmi1me, flowStatesInputs);\n",
                                    "triggerDSSEvent = noEvent(if callEventUpdate then flowStatesInputs+1.0 else flowStatesInputs-1.0);\n",
                                    "nextEventTime = fmi1Functions.fmi1nextEventTime(fmi1me, flowStatesInputs);\n"
                                }, true));
        ret_34 = stringEq(Tpl.textString(l_realOutputVariablesNames), "");
        ret_35 = stringEq(Tpl.textString(l_realOutputVariablesVRs), "");
        ret_36 = boolAnd(ret_34, ret_35);
        txt = fun_246(txt, ret_36, l_realOutputVariablesVRs, l_realOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_37 = stringEq(Tpl.textString(l_integerOutputVariablesNames), "");
        ret_38 = stringEq(Tpl.textString(l_integerOutputVariablesVRs), "");
        ret_39 = boolAnd(ret_37, ret_38);
        txt = fun_247(txt, ret_39, l_integerOutputVariablesVRs, l_integerOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_40 = stringEq(Tpl.textString(l_booleanOutputVariablesNames), "");
        ret_41 = stringEq(Tpl.textString(l_booleanOutputVariablesVRs), "");
        ret_42 = boolAnd(ret_40, ret_41);
        txt = fun_248(txt, ret_42, l_booleanOutputVariablesVRs, l_booleanOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_43 = stringEq(Tpl.textString(l_stringOutputVariablesNames), "");
        ret_44 = stringEq(Tpl.textString(l_stringOutputVariablesVRs), "");
        ret_45 = boolAnd(ret_43, ret_44);
        txt = fun_249(txt, ret_45, l_stringOutputVariablesVRs, l_stringOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("algorithm\n"));
        ret_46 = listLength(i_fmiInfo_fmiNumberOfEventIndicators);
        ret_47 = intGt(ret_46, 0);
        txt = fun_251(txt, ret_47, i_fmiInfo_fmiNumberOfEventIndicators);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    (newStatesAvailable) := fmi1Functions.fmi1EventUpdate(fmi1me, intermediateResults, flowStatesInputs);\n"));
        ret_48 = listLength(i_fmiInfo_fmiNumberOfContinuousStates);
        ret_49 = intGt(ret_48, 0);
        txt = fun_253(txt, ret_49, i_fmiInfo_fmiNumberOfContinuousStates);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  end when;\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("annotation(experiment(StartTime="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStartTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", StopTime="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", Tolerance="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentTolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "));\n",
                                    "annotation (Icon(graphics={\n",
                                    "    Rectangle(\n",
                                    "      extent={{-100,100},{100,-100}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      fillColor={240,240,240},\n",
                                    "      fillPattern=FillPattern.Solid,\n",
                                    "      lineThickness=0.5),\n",
                                    "    Text(\n",
                                    "      extent={{-100,40},{100,0}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      textString=\"%name\"),\n",
                                    "    Text(\n",
                                    "      extent={{-100,-50},{100,-90}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      textString=\"V1.0\")}));\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "protected\n",
                                    "  class FMI1ModelExchange\n",
                                    "    extends ExternalObject;\n",
                                    "      function constructor\n",
                                    "        input Integer logLevel;\n",
                                    "        input String workingDirectory;\n",
                                    "        input String instanceName;\n",
                                    "        input Boolean debugLogging;\n",
                                    "        output FMI1ModelExchange fmi1me;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1me = FMI1ModelExchangeConstructor_OMC(logLevel, workingDirectory, instanceName, debugLogging) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_50 = stringEq(i_platform, "win32");
        txt = fun_254(txt, ret_50);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      end constructor;\n",
                                    "\n",
                                    "      function destructor\n",
                                    "        input FMI1ModelExchange fmi1me;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" FMI1ModelExchangeDestructor_OMC(fmi1me) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_51 = stringEq(i_platform, "win32");
        txt = fun_255(txt, ret_51);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      end destructor;\n",
                                    "  end FMI1ModelExchange;\n",
                                    "\n",
                                    "  package fmi1Functions\n",
                                    "    function fmi1SetTime\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Real inTime;\n",
                                    "      output Real status;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" status = fmi1SetTime_OMC(fmi1me, inTime) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_52 = stringEq(i_platform, "win32");
        txt = fun_256(txt, ret_52);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1SetTime;\n",
                                    "\n",
                                    "    function fmi1GetContinuousStates\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Integer numberOfContinuousStates;\n",
                                    "      input Real inFlowParams;\n",
                                    "      output Real fmi_x[numberOfContinuousStates];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetContinuousStates_OMC(fmi1me, numberOfContinuousStates, inFlowParams, fmi_x) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_53 = stringEq(i_platform, "win32");
        txt = fun_257(txt, ret_53);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1GetContinuousStates;\n",
                                    "\n",
                                    "    function fmi1SetContinuousStates\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Real fmi_x[:];\n",
                                    "      input Real inFlowParams;\n",
                                    "      output Real outFlowStates;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outFlowStates = fmi1SetContinuousStates_OMC(fmi1me, size(fmi_x, 1), inFlowParams, fmi_x) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_54 = stringEq(i_platform, "win32");
        txt = fun_258(txt, ret_54);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1SetContinuousStates;\n",
                                    "\n",
                                    "    function fmi1GetDerivatives\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Integer numberOfContinuousStates;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Real fmi_x[numberOfContinuousStates];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetDerivatives_OMC(fmi1me, numberOfContinuousStates, inFlowStates, fmi_x) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_55 = stringEq(i_platform, "win32");
        txt = fun_259(txt, ret_55);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1GetDerivatives;\n",
                                    "\n",
                                    "    function fmi1GetEventIndicators\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Integer numberOfEventIndicators;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Real fmi_z[numberOfEventIndicators];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetEventIndicators_OMC(fmi1me, numberOfEventIndicators, inFlowStates, fmi_z) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_56 = stringEq(i_platform, "win32");
        txt = fun_260(txt, ret_56);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1GetEventIndicators;\n",
                                    "\n",
                                    "    function fmi1GetReal\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Real realValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output Real realValues[size(realValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetReal_OMC(fmi1me, size(realValuesReferences, 1), realValuesReferences, inFlowStatesInput, realValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_57 = stringEq(i_platform, "win32");
        txt = fun_261(txt, ret_57);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1GetReal;\n",
                                    "\n",
                                    "    function fmi1SetReal\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Real realValuesReferences[:];\n",
                                    "      input Real realValues[size(realValuesReferences, 1)];\n",
                                    "      output Real out_Values[size(realValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetReal_OMC(fmi1me, size(realValuesReferences, 1), realValuesReferences, realValues, out_Values, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_58 = stringEq(i_platform, "win32");
        txt = fun_262(txt, ret_58);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1SetReal;\n",
                                    "\n",
                                    "    function fmi1GetInteger\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Real integerValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output Integer integerValues[size(integerValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetInteger_OMC(fmi1me, size(integerValuesReferences, 1), integerValuesReferences, inFlowStatesInput, integerValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_59 = stringEq(i_platform, "win32");
        txt = fun_263(txt, ret_59);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1GetInteger;\n",
                                    "\n",
                                    "    function fmi1SetInteger\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Real integerValuesReferences[:];\n",
                                    "      input Integer integerValues[size(integerValuesReferences, 1)];\n",
                                    "      output Real out_Values[size(integerValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetInteger_OMC(fmi1me, size(integerValuesReferences, 1), integerValuesReferences, integerValues, out_Values, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_60 = stringEq(i_platform, "win32");
        txt = fun_264(txt, ret_60);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1SetInteger;\n",
                                    "\n",
                                    "    function fmi1GetBoolean\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Real booleanValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output Boolean booleanValues[size(booleanValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetBoolean_OMC(fmi1me, size(booleanValuesReferences, 1), booleanValuesReferences, inFlowStatesInput, booleanValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_61 = stringEq(i_platform, "win32");
        txt = fun_265(txt, ret_61);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1GetBoolean;\n",
                                    "\n",
                                    "    function fmi1SetBoolean\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Real booleanValuesReferences[:];\n",
                                    "      input Boolean booleanValues[size(booleanValuesReferences, 1)];\n",
                                    "      output Real out_Values[size(booleanValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetBoolean_OMC(fmi1me, size(booleanValuesReferences, 1), booleanValuesReferences, booleanValues, out_Values, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_62 = stringEq(i_platform, "win32");
        txt = fun_266(txt, ret_62);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1SetBoolean;\n",
                                    "\n",
                                    "    function fmi1GetString\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Real stringValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output String stringValues[size(stringValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetString_OMC(fmi1me, size(stringValuesReferences, 1), stringValuesReferences, inFlowStatesInput, stringValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_63 = stringEq(i_platform, "win32");
        txt = fun_267(txt, ret_63);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1GetString;\n",
                                    "\n",
                                    "    function fmi1SetString\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Real stringValuesReferences[:];\n",
                                    "      input String stringValues[size(stringValuesReferences, 1)];\n",
                                    "      output Real out_Values[size(stringValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetString_OMC(fmi1me, size(stringValuesReferences, 1), stringValuesReferences, stringValues, out_Values, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_64 = stringEq(i_platform, "win32");
        txt = fun_268(txt, ret_64);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1SetString;\n",
                                    "\n",
                                    "    function fmi1EventUpdate\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Boolean intermediateResults;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Boolean outNewStatesAvailable;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outNewStatesAvailable = fmi1EventUpdate_OMC(fmi1me, intermediateResults, inFlowStates) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_65 = stringEq(i_platform, "win32");
        txt = fun_269(txt, ret_65);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1EventUpdate;\n",
                                    "\n",
                                    "    function fmi1nextEventTime\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Real outNewnextTime;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outNewnextTime = fmi1nextEventTime_OMC(fmi1me, inFlowStates) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_66 = stringEq(i_platform, "win32");
        txt = fun_270(txt, ret_66);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1nextEventTime;\n",
                                    "\n",
                                    "    function fmi1CompletedIntegratorStep\n",
                                    "      input FMI1ModelExchange fmi1me;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Boolean outCallEventUpdate;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outCallEventUpdate = fmi1CompletedIntegratorStep_OMC(fmi1me, inFlowStates) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_67 = stringEq(i_platform, "win32");
        txt = fun_271(txt, ret_67);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1CompletedIntegratorStep;\n",
                                    "  end fmi1Functions;\n",
                                    "\n",
                                    "  package fmiStatus\n",
                                    "    constant Integer fmiOK=0;\n",
                                    "    constant Integer fmiWarning=1;\n",
                                    "    constant Integer fmiDiscard=2;\n",
                                    "    constant Integer fmiError=3;\n",
                                    "    constant Integer fmiFatal=4;\n",
                                    "    constant Integer fmiPending=5;\n",
                                    "  end fmiStatus;\n",
                                    "end "
                                }, false));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        ret_68 = FMI.getFMIType(i_fmiInfo);
        txt = Tpl.writeStr(txt, ret_68);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end importFMU1ModelExchange;

protected function fun_273
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fmiInfo_fmiDescription;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiDescription)
    local
      Tpl.Text txt;
      String a_fmiInfo_fmiDescription;

    case ( txt,
           false,
           a_fmiInfo_fmiDescription )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \""));
        txt = Tpl.writeStr(txt, a_fmiInfo_fmiDescription);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_273;

protected function fun_274
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realInputVariablesReturnNames;

    case ( txt,
           false,
           a_realInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_realInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_274;

protected function fun_275
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerInputVariablesReturnNames;

    case ( txt,
           false,
           a_integerInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_integerInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_275;

protected function fun_276
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanInputVariablesReturnNames;

    case ( txt,
           false,
           a_booleanInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_booleanInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_276;

protected function fun_277
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringInputVariablesReturnNames;

    case ( txt,
           false,
           a_stringInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_stringInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_277;

protected function fun_278
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  fmi_x := fmi2Functions.fmi2GetContinuousStates(fmi2me, numberOfContinuousStates, flowParamsStart);"));
      then txt;
  end match;
end fun_278;

protected function fun_279
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realInputVariablesNames;
  input Tpl.Text in_a_realInputVariablesVRs;
  input Tpl.Text in_a_realInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realInputVariablesNames, in_a_realInputVariablesVRs, in_a_realInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realInputVariablesNames;
      Tpl.Text a_realInputVariablesVRs;
      Tpl.Text a_realInputVariablesReturnNames;

    case ( txt,
           false,
           a_realInputVariablesNames,
           a_realInputVariablesVRs,
           a_realInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_realInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi2Functions.fmi2SetReal(fmi2me, {"));
        txt = Tpl.writeText(txt, a_realInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_realInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_279;

protected function fun_280
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerInputVariablesNames;
  input Tpl.Text in_a_integerInputVariablesVRs;
  input Tpl.Text in_a_integerInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerInputVariablesNames, in_a_integerInputVariablesVRs, in_a_integerInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerInputVariablesNames;
      Tpl.Text a_integerInputVariablesVRs;
      Tpl.Text a_integerInputVariablesReturnNames;

    case ( txt,
           false,
           a_integerInputVariablesNames,
           a_integerInputVariablesVRs,
           a_integerInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_integerInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi2Functions.fmi2SetInteger(fmi2me, {"));
        txt = Tpl.writeText(txt, a_integerInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_integerInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_280;

protected function fun_281
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanInputVariablesNames;
  input Tpl.Text in_a_booleanInputVariablesVRs;
  input Tpl.Text in_a_booleanInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanInputVariablesNames, in_a_booleanInputVariablesVRs, in_a_booleanInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanInputVariablesNames;
      Tpl.Text a_booleanInputVariablesVRs;
      Tpl.Text a_booleanInputVariablesReturnNames;

    case ( txt,
           false,
           a_booleanInputVariablesNames,
           a_booleanInputVariablesVRs,
           a_booleanInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi2Functions.fmi2SetBoolean(fmi2me, {"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_281;

protected function fun_282
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringStartVariablesNames;
  input Tpl.Text in_a_stringInputVariablesVRs;
  input Tpl.Text in_a_stringInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringStartVariablesNames, in_a_stringInputVariablesVRs, in_a_stringInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringStartVariablesNames;
      Tpl.Text a_stringInputVariablesVRs;
      Tpl.Text a_stringInputVariablesReturnNames;

    case ( txt,
           false,
           a_stringStartVariablesNames,
           a_stringInputVariablesVRs,
           a_stringInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_stringInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi2Functions.fmi2SetString(fmi2me, {"));
        txt = Tpl.writeText(txt, a_stringInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_stringStartVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_282;

protected function fun_283
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realOutputVariablesVRs;
  input Tpl.Text in_a_realOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realOutputVariablesVRs, in_a_realOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realOutputVariablesVRs;
      Tpl.Text a_realOutputVariablesNames;

    case ( txt,
           false,
           a_realOutputVariablesVRs,
           a_realOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_realOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi2Functions.fmi2GetReal(fmi2me, {"));
        txt = Tpl.writeText(txt, a_realOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_283;

protected function fun_284
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerOutputVariablesVRs;
  input Tpl.Text in_a_integerOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerOutputVariablesVRs, in_a_integerOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerOutputVariablesVRs;
      Tpl.Text a_integerOutputVariablesNames;

    case ( txt,
           false,
           a_integerOutputVariablesVRs,
           a_integerOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_integerOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi2Functions.fmi2GetInteger(fmi2me, {"));
        txt = Tpl.writeText(txt, a_integerOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_284;

protected function fun_285
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanOutputVariablesVRs;
  input Tpl.Text in_a_booleanOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanOutputVariablesVRs, in_a_booleanOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanOutputVariablesVRs;
      Tpl.Text a_booleanOutputVariablesNames;

    case ( txt,
           false,
           a_booleanOutputVariablesVRs,
           a_booleanOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_booleanOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi2Functions.fmi2GetBoolean(fmi2me, {"));
        txt = Tpl.writeText(txt, a_booleanOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_285;

protected function fun_286
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringOutputVariablesVRs;
  input Tpl.Text in_a_stringOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringOutputVariablesVRs, in_a_stringOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringOutputVariablesVRs;
      Tpl.Text a_stringOutputVariablesNames;

    case ( txt,
           false,
           a_stringOutputVariablesVRs,
           a_stringOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_stringOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi2Functions.fmi2GetString(fmi2me, {"));
        txt = Tpl.writeText(txt, a_stringOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_286;

protected function lm_287
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_eventIndicator;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eventIndicator :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("change(fmi_z_positive["));
        txt = Tpl.writeStr(txt, intString(i_eventIndicator));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
        txt = Tpl.nextIter(txt);
        txt = lm_287(txt, rest);
      then txt;
  end match;
end lm_287;

protected function fun_288
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<Integer> in_a_fmiInfo_fmiNumberOfEventIndicators;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiNumberOfEventIndicators)
    local
      Tpl.Text txt;
      list<Integer> a_fmiInfo_fmiNumberOfEventIndicators;

    case ( txt,
           false,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  when {not initial(), triggerDSSEvent > flowStatesInputs, nextEventTime < time} then"));
      then txt;

    case ( txt,
           _,
           a_fmiInfo_fmiNumberOfEventIndicators )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when {("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" or ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_287(txt, a_fmiInfo_fmiNumberOfEventIndicators);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") and not initial(),triggerDSSEvent > flowStatesInputs, nextEventTime < time} then"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_288;

protected function lm_289
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_continuousStates;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_continuousStates :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("reinit(fmi_x["));
        txt = Tpl.writeStr(txt, intString(i_continuousStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("], fmi_x_new["));
        txt = Tpl.writeStr(txt, intString(i_continuousStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]);"));
        txt = Tpl.nextIter(txt);
        txt = lm_289(txt, rest);
      then txt;
  end match;
end lm_289;

protected function fun_290
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<Integer> in_a_fmiInfo_fmiNumberOfContinuousStates;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiNumberOfContinuousStates)
    local
      Tpl.Text txt;
      list<Integer> a_fmiInfo_fmiNumberOfContinuousStates;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fmiInfo_fmiNumberOfContinuousStates )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    if newStatesAvailable then\n",
                                    "      fmi_x_new := fmi2Functions.fmi2GetContinuousStates(fmi2me, numberOfContinuousStates, flowStatesInputs);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_289(txt, a_fmiInfo_fmiNumberOfContinuousStates);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    end if;"));
      then txt;
  end match;
end fun_290;

protected function fun_291
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_291;

protected function fun_292
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_292;

protected function fun_293
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_293;

protected function fun_294
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_294;

protected function fun_295
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_295;

protected function fun_296
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_296;

protected function fun_297
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_297;

protected function fun_298
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_298;

protected function fun_299
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_299;

protected function fun_300
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_300;

protected function fun_301
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_301;

protected function fun_302
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_302;

protected function fun_303
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_303;

protected function fun_304
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_304;

protected function fun_305
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_305;

protected function fun_306
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_306;

protected function fun_307
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_307;

protected function fun_308
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_308;

public function importFMU2ModelExchange
  input Tpl.Text in_txt;
  input FMI.FmiImport in_a_fmi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmi)
    local
      Tpl.Text txt;
      String i_platform;
      Real i_fmiExperimentAnnotation_fmiExperimentTolerance;
      Real i_fmiExperimentAnnotation_fmiExperimentStopTime;
      Real i_fmiExperimentAnnotation_fmiExperimentStartTime;
      list<Integer> i_fmiInfo_fmiNumberOfEventIndicators;
      list<Integer> i_fmiInfo_fmiNumberOfContinuousStates;
      Boolean i_generateOutputConnectors;
      Boolean i_generateInputConnectors;
      Boolean i_fmiDebugOutput;
      Integer i_fmiLogLevel;
      String i_fmuWorkingDirectory;
      String i_fmuFileName;
      String i_fmiInfo_fmiDescription;
      FMI.Info i_fmiInfo;
      String i_fmiInfo_fmiModelIdentifier;
      list<FMI.ModelVariables> i_fmiModelVariablesList;
      String ret_68;
      Boolean ret_67;
      Boolean ret_66;
      Boolean ret_65;
      Boolean ret_64;
      Boolean ret_63;
      Boolean ret_62;
      Boolean ret_61;
      Boolean ret_60;
      Boolean ret_59;
      Boolean ret_58;
      Boolean ret_57;
      Boolean ret_56;
      Boolean ret_55;
      Boolean ret_54;
      Boolean ret_53;
      Boolean ret_52;
      Boolean ret_51;
      Boolean ret_50;
      Boolean ret_49;
      Integer ret_48;
      Boolean ret_47;
      Integer ret_46;
      Boolean ret_45;
      Boolean ret_44;
      Boolean ret_43;
      Boolean ret_42;
      Boolean ret_41;
      Boolean ret_40;
      Boolean ret_39;
      Boolean ret_38;
      Boolean ret_37;
      Boolean ret_36;
      Boolean ret_35;
      Boolean ret_34;
      Boolean ret_33;
      Boolean ret_32;
      Boolean ret_31;
      Boolean ret_30;
      Boolean ret_29;
      Integer ret_28;
      Boolean ret_27;
      Boolean ret_26;
      Boolean ret_25;
      Boolean ret_24;
      Integer ret_23;
      Integer ret_22;
      Boolean ret_21;
      String ret_20;
      Tpl.Text l_stringOutputVariablesNames;
      Tpl.Text l_stringOutputVariablesVRs;
      Tpl.Text l_booleanOutputVariablesNames;
      Tpl.Text l_booleanOutputVariablesVRs;
      Tpl.Text l_integerOutputVariablesNames;
      Tpl.Text l_integerOutputVariablesVRs;
      Tpl.Text l_realOutputVariablesNames;
      Tpl.Text l_realOutputVariablesVRs;
      Tpl.Text l_stringInputVariablesReturnNames;
      Tpl.Text l_stringStartVariablesNames;
      Tpl.Text l_stringInputVariablesVRs;
      Tpl.Text l_booleanInputVariablesReturnNames;
      Tpl.Text l_booleanInputVariablesNames;
      Tpl.Text l_booleanInputVariablesVRs;
      Tpl.Text l_integerInputVariablesReturnNames;
      Tpl.Text l_integerInputVariablesNames;
      Tpl.Text l_integerInputVariablesVRs;
      Tpl.Text l_realInputVariablesReturnNames;
      Tpl.Text l_realInputVariablesNames;
      Tpl.Text l_realInputVariablesVRs;

    case ( txt,
           FMI.FMIIMPORT(fmiInfo = (i_fmiInfo as FMI.INFO(fmiModelIdentifier = i_fmiInfo_fmiModelIdentifier, fmiDescription = i_fmiInfo_fmiDescription, fmiNumberOfContinuousStates = i_fmiInfo_fmiNumberOfContinuousStates, fmiNumberOfEventIndicators = i_fmiInfo_fmiNumberOfEventIndicators)), fmiExperimentAnnotation = FMI.EXPERIMENTANNOTATION(fmiExperimentStartTime = i_fmiExperimentAnnotation_fmiExperimentStartTime, fmiExperimentStopTime = i_fmiExperimentAnnotation_fmiExperimentStopTime, fmiExperimentTolerance = i_fmiExperimentAnnotation_fmiExperimentTolerance), fmiModelVariablesList = i_fmiModelVariablesList, fmuFileName = i_fmuFileName, fmuWorkingDirectory = i_fmuWorkingDirectory, fmiLogLevel = i_fmiLogLevel, fmiDebugOutput = i_fmiDebugOutput, generateInputConnectors = i_generateInputConnectors, generateOutputConnectors = i_generateOutputConnectors, platform = i_platform) )
      equation
        l_realInputVariablesVRs = dumpInputRealVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realInputVariablesNames = dumpInputRealVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realInputVariablesReturnNames = dumpInputRealVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesVRs = dumpInputIntegerVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesNames = dumpInputIntegerVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesReturnNames = dumpInputIntegerVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesVRs = dumpInputBooleanVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesNames = dumpInputBooleanVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesReturnNames = dumpInputBooleanVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringInputVariablesVRs = dumpInputStringVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringStartVariablesNames = dumpInputStringVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringInputVariablesReturnNames = dumpInputStringVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realOutputVariablesVRs = dumpOutputRealVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realOutputVariablesNames = dumpOutputRealVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerOutputVariablesVRs = dumpOutputIntegerVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerOutputVariablesNames = dumpOutputIntegerVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanOutputVariablesVRs = dumpOutputBooleanVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanOutputVariablesNames = dumpOutputBooleanVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringOutputVariablesVRs = dumpOutputStringVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringOutputVariablesNames = dumpOutputStringVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("model "));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        ret_20 = FMI.getFMIType(i_fmiInfo);
        txt = Tpl.writeStr(txt, ret_20);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU"));
        ret_21 = stringEq(i_fmiInfo_fmiDescription, "");
        txt = fun_273(txt, ret_21, i_fmiInfo_fmiDescription);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant String fmuFile = \""));
        txt = Tpl.writeStr(txt, i_fmuFileName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "constant String fmuWorkingDir = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fmuWorkingDirectory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "parameter Integer logLevel = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_fmiLogLevel));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"log level used during the loading of FMU\" annotation (Dialog(tab=\"FMI\", group=\"Enable logging\"));\n",
                                    "parameter Boolean debugLogging = "
                                }, false));
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_fmiDebugOutput));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"enables the FMU simulation logging\" annotation (Dialog(tab=\"FMI\", group=\"Enable logging\"));\n",
                                    "FMI2ModelExchange fmi2me = FMI2ModelExchange(logLevel, fmuWorkingDir, \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\", debugLogging);\n"));
        txt = dumpFMIModelVariablesList(txt, i_fmiModelVariablesList, i_generateInputConnectors, i_generateOutputConnectors);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant Integer numberOfContinuousStates = "));
        ret_22 = listLength(i_fmiInfo_fmiNumberOfContinuousStates);
        txt = Tpl.writeStr(txt, intString(ret_22));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "Real fmi_x[numberOfContinuousStates] \"States\";\n",
                                    "Real fmi_x_new[numberOfContinuousStates] \"New States\";\n",
                                    "constant Integer numberOfEventIndicators = "
                                }, false));
        ret_23 = listLength(i_fmiInfo_fmiNumberOfEventIndicators);
        txt = Tpl.writeStr(txt, intString(ret_23));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "Real fmi_z[numberOfEventIndicators] \"Events Indicators\";\n",
                                    "Boolean fmi_z_positive[numberOfEventIndicators];\n",
                                    "Real flowTime;\n",
                                    "parameter Real flowParamsStart(fixed=false);\n"
                                }, true));
        ret_24 = stringEq(Tpl.textString(l_realInputVariablesVRs), "");
        txt = fun_274(txt, ret_24, l_realInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_25 = stringEq(Tpl.textString(l_integerInputVariablesVRs), "");
        txt = fun_275(txt, ret_25, l_integerInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_26 = stringEq(Tpl.textString(l_booleanInputVariablesVRs), "");
        txt = fun_276(txt, ret_26, l_booleanInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_27 = stringEq(Tpl.textString(l_stringInputVariablesVRs), "");
        txt = fun_277(txt, ret_27, l_stringInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Real flowStatesInputs;\n",
                                    "Boolean callEventUpdate;\n",
                                    "constant Boolean intermediateResults = false;\n",
                                    "Boolean newStatesAvailable;\n",
                                    "Real triggerDSSEvent;\n",
                                    "Real nextEventTime;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "initial algorithm\n",
                                    "  flowParamsStart := 0;\n"
                                }, true));
        ret_28 = listLength(i_fmiInfo_fmiNumberOfContinuousStates);
        ret_29 = intGt(ret_28, 0);
        txt = fun_278(txt, ret_29);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "equation\n",
                                    "  flowTime = fmi2Functions.fmi2SetTime(fmi2me, time);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_30 = stringEq(Tpl.textString(l_realInputVariablesVRs), "");
        txt = fun_279(txt, ret_30, l_realInputVariablesNames, l_realInputVariablesVRs, l_realInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_31 = stringEq(Tpl.textString(l_integerInputVariablesVRs), "");
        txt = fun_280(txt, ret_31, l_integerInputVariablesNames, l_integerInputVariablesVRs, l_integerInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_32 = stringEq(Tpl.textString(l_booleanInputVariablesVRs), "");
        txt = fun_281(txt, ret_32, l_booleanInputVariablesNames, l_booleanInputVariablesVRs, l_booleanInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_33 = stringEq(Tpl.textString(l_stringInputVariablesVRs), "");
        txt = fun_282(txt, ret_33, l_stringStartVariablesNames, l_stringInputVariablesVRs, l_stringInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "flowStatesInputs = fmi2Functions.fmi2SetContinuousStates(fmi2me, fmi_x, flowParamsStart + flowTime);\n",
                                    "der(fmi_x) = fmi2Functions.fmi2GetDerivatives(fmi2me, numberOfContinuousStates, flowStatesInputs);\n",
                                    "fmi_z  = fmi2Functions.fmi2GetEventIndicators(fmi2me, numberOfEventIndicators, flowStatesInputs);\n",
                                    "for i in 1:size(fmi_z,1) loop\n",
                                    "  fmi_z_positive[i] = if not terminal() then fmi_z[i] > 0 else pre(fmi_z_positive[i]);\n",
                                    "end for;\n",
                                    "callEventUpdate = fmi2Functions.fmi2CompletedIntegratorStep(fmi2me, flowStatesInputs);\n",
                                    "triggerDSSEvent = noEvent(if callEventUpdate then flowStatesInputs+1.0 else flowStatesInputs-1.0);\n",
                                    "nextEventTime = fmi2Functions.fmi2nextEventTime(fmi2me, flowStatesInputs);\n"
                                }, true));
        ret_34 = stringEq(Tpl.textString(l_realOutputVariablesNames), "");
        ret_35 = stringEq(Tpl.textString(l_realOutputVariablesVRs), "");
        ret_36 = boolAnd(ret_34, ret_35);
        txt = fun_283(txt, ret_36, l_realOutputVariablesVRs, l_realOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_37 = stringEq(Tpl.textString(l_integerOutputVariablesNames), "");
        ret_38 = stringEq(Tpl.textString(l_integerOutputVariablesVRs), "");
        ret_39 = boolAnd(ret_37, ret_38);
        txt = fun_284(txt, ret_39, l_integerOutputVariablesVRs, l_integerOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_40 = stringEq(Tpl.textString(l_booleanOutputVariablesNames), "");
        ret_41 = stringEq(Tpl.textString(l_booleanOutputVariablesVRs), "");
        ret_42 = boolAnd(ret_40, ret_41);
        txt = fun_285(txt, ret_42, l_booleanOutputVariablesVRs, l_booleanOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_43 = stringEq(Tpl.textString(l_stringOutputVariablesNames), "");
        ret_44 = stringEq(Tpl.textString(l_stringOutputVariablesVRs), "");
        ret_45 = boolAnd(ret_43, ret_44);
        txt = fun_286(txt, ret_45, l_stringOutputVariablesVRs, l_stringOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("algorithm\n"));
        ret_46 = listLength(i_fmiInfo_fmiNumberOfEventIndicators);
        ret_47 = intGt(ret_46, 0);
        txt = fun_288(txt, ret_47, i_fmiInfo_fmiNumberOfEventIndicators);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    (newStatesAvailable) := fmi2Functions.fmi2EventUpdate(fmi2me, intermediateResults, flowStatesInputs);\n"));
        ret_48 = listLength(i_fmiInfo_fmiNumberOfContinuousStates);
        ret_49 = intGt(ret_48, 0);
        txt = fun_290(txt, ret_49, i_fmiInfo_fmiNumberOfContinuousStates);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  end when;\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("annotation(experiment(StartTime="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStartTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", StopTime="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", Tolerance="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentTolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "));\n",
                                    "annotation (Icon(graphics={\n",
                                    "    Rectangle(\n",
                                    "      extent={{-100,100},{100,-100}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      fillColor={240,240,240},\n",
                                    "      fillPattern=FillPattern.Solid,\n",
                                    "      lineThickness=0.5),\n",
                                    "    Text(\n",
                                    "      extent={{-100,40},{100,0}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      textString=\"%name\"),\n",
                                    "    Text(\n",
                                    "      extent={{-100,-50},{100,-90}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      textString=\"V2.0\")}));\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "protected\n",
                                    "  class FMI2ModelExchange\n",
                                    "    extends ExternalObject;\n",
                                    "      function constructor\n",
                                    "        input Integer logLevel;\n",
                                    "        input String workingDirectory;\n",
                                    "        input String instanceName;\n",
                                    "        input Boolean debugLogging;\n",
                                    "        output FMI2ModelExchange fmi2me;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2me = FMI2ModelExchangeConstructor_OMC(logLevel, workingDirectory, instanceName, debugLogging) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_50 = stringEq(i_platform, "win32");
        txt = fun_291(txt, ret_50);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      end constructor;\n",
                                    "\n",
                                    "      function destructor\n",
                                    "        input FMI2ModelExchange fmi2me;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" FMI2ModelExchangeDestructor_OMC(fmi2me) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_51 = stringEq(i_platform, "win32");
        txt = fun_292(txt, ret_51);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      end destructor;\n",
                                    "  end FMI2ModelExchange;\n",
                                    "\n",
                                    "  package fmi2Functions\n",
                                    "    function fmi2SetTime\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real inTime;\n",
                                    "      output Real status;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" status = fmi2SetTime_OMC(fmi2me, inTime) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_52 = stringEq(i_platform, "win32");
        txt = fun_293(txt, ret_52);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2SetTime;\n",
                                    "\n",
                                    "    function fmi2GetContinuousStates\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Integer numberOfContinuousStates;\n",
                                    "      input Real inFlowParams;\n",
                                    "      output Real fmi_x[numberOfContinuousStates];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetContinuousStates_OMC(fmi2me, numberOfContinuousStates, inFlowParams, fmi_x) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_53 = stringEq(i_platform, "win32");
        txt = fun_294(txt, ret_53);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetContinuousStates;\n",
                                    "\n",
                                    "    function fmi2SetContinuousStates\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real fmi_x[:];\n",
                                    "      input Real inFlowParams;\n",
                                    "      output Real outFlowStates;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outFlowStates = fmi2SetContinuousStates_OMC(fmi2me, size(fmi_x, 1), inFlowParams, fmi_x) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_54 = stringEq(i_platform, "win32");
        txt = fun_295(txt, ret_54);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2SetContinuousStates;\n",
                                    "\n",
                                    "    function fmi2GetDerivatives\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Integer numberOfContinuousStates;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Real fmi_x[numberOfContinuousStates];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetDerivatives_OMC(fmi2me, numberOfContinuousStates, inFlowStates, fmi_x) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_55 = stringEq(i_platform, "win32");
        txt = fun_296(txt, ret_55);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetDerivatives;\n",
                                    "\n",
                                    "    function fmi2GetEventIndicators\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Integer numberOfEventIndicators;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Real fmi_z[numberOfEventIndicators];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetEventIndicators_OMC(fmi2me, numberOfEventIndicators, inFlowStates, fmi_z) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_56 = stringEq(i_platform, "win32");
        txt = fun_297(txt, ret_56);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetEventIndicators;\n",
                                    "\n",
                                    "    function fmi2GetReal\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real realValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output Real realValues[size(realValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetReal_OMC(fmi2me, size(realValuesReferences, 1), realValuesReferences, inFlowStatesInput, realValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_57 = stringEq(i_platform, "win32");
        txt = fun_298(txt, ret_57);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetReal;\n",
                                    "\n",
                                    "    function fmi2SetReal\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real realValuesReferences[:];\n",
                                    "      input Real realValues[size(realValuesReferences, 1)];\n",
                                    "      output Real out_Values[size(realValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2SetReal_OMC(fmi2me, size(realValuesReferences, 1), realValuesReferences, realValues, out_Values, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_58 = stringEq(i_platform, "win32");
        txt = fun_299(txt, ret_58);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2SetReal;\n",
                                    "\n",
                                    "    function fmi2GetInteger\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real integerValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output Integer integerValues[size(integerValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetInteger_OMC(fmi2me, size(integerValuesReferences, 1), integerValuesReferences, inFlowStatesInput, integerValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_59 = stringEq(i_platform, "win32");
        txt = fun_300(txt, ret_59);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetInteger;\n",
                                    "\n",
                                    "    function fmi2SetInteger\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real integerValuesReferences[:];\n",
                                    "      input Integer integerValues[size(integerValuesReferences, 1)];\n",
                                    "      output Real out_Values[size(integerValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2SetInteger_OMC(fmi2me, size(integerValuesReferences, 1), integerValuesReferences, integerValues, out_Values, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_60 = stringEq(i_platform, "win32");
        txt = fun_301(txt, ret_60);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2SetInteger;\n",
                                    "\n",
                                    "    function fmi2GetBoolean\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real booleanValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output Boolean booleanValues[size(booleanValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetBoolean_OMC(fmi2me, size(booleanValuesReferences, 1), booleanValuesReferences, inFlowStatesInput, booleanValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_61 = stringEq(i_platform, "win32");
        txt = fun_302(txt, ret_61);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetBoolean;\n",
                                    "\n",
                                    "    function fmi2SetBoolean\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real booleanValuesReferences[:];\n",
                                    "      input Boolean booleanValues[size(booleanValuesReferences, 1)];\n",
                                    "      output Real out_Values[size(booleanValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2SetBoolean_OMC(fmi2me, size(booleanValuesReferences, 1), booleanValuesReferences, booleanValues, out_Values, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_62 = stringEq(i_platform, "win32");
        txt = fun_303(txt, ret_62);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2SetBoolean;\n",
                                    "\n",
                                    "    function fmi2GetString\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real stringValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output String stringValues[size(stringValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetString_OMC(fmi2me, size(stringValuesReferences, 1), stringValuesReferences, inFlowStatesInput, stringValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_63 = stringEq(i_platform, "win32");
        txt = fun_304(txt, ret_63);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetString;\n",
                                    "\n",
                                    "    function fmi2SetString\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real stringValuesReferences[:];\n",
                                    "      input String stringValues[size(stringValuesReferences, 1)];\n",
                                    "      output Real out_Values[size(stringValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2SetString_OMC(fmi2me, size(stringValuesReferences, 1), stringValuesReferences, stringValues, out_Values, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_64 = stringEq(i_platform, "win32");
        txt = fun_305(txt, ret_64);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2SetString;\n",
                                    "\n",
                                    "    function fmi2EventUpdate\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Boolean intermediateResults;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Boolean outNewStatesAvailable;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outNewStatesAvailable = fmi2EventUpdate_OMC(fmi2me, intermediateResults, inFlowStates) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_65 = stringEq(i_platform, "win32");
        txt = fun_306(txt, ret_65);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2EventUpdate;\n",
                                    "\n",
                                    "    function fmi2nextEventTime\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Real outNewnextTime;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outNewnextTime = fmi2nextEventTime_OMC(fmi2me, inFlowStates) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_66 = stringEq(i_platform, "win32");
        txt = fun_307(txt, ret_66);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2nextEventTime;\n",
                                    "\n",
                                    "    function fmi2CompletedIntegratorStep\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Boolean outCallEventUpdate;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outCallEventUpdate = fmi2CompletedIntegratorStep_OMC(fmi2me, inFlowStates) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_67 = stringEq(i_platform, "win32");
        txt = fun_308(txt, ret_67);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2CompletedIntegratorStep;\n",
                                    "  end fmi2Functions;\n",
                                    "\n",
                                    "  package fmiStatus\n",
                                    "    constant Integer fmiOK=0;\n",
                                    "    constant Integer fmiWarning=1;\n",
                                    "    constant Integer fmiDiscard=2;\n",
                                    "    constant Integer fmiError=3;\n",
                                    "    constant Integer fmiFatal=4;\n",
                                    "    constant Integer fmiPending=5;\n",
                                    "  end fmiStatus;\n",
                                    "end "
                                }, false));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        ret_68 = FMI.getFMIType(i_fmiInfo);
        txt = Tpl.writeStr(txt, ret_68);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end importFMU2ModelExchange;

protected function fun_310
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fmiInfo_fmiDescription;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiDescription)
    local
      Tpl.Text txt;
      String a_fmiInfo_fmiDescription;

    case ( txt,
           false,
           a_fmiInfo_fmiDescription )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \""));
        txt = Tpl.writeStr(txt, a_fmiInfo_fmiDescription);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_310;

protected function fun_311
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realOutputVariablesVRs;
  input Tpl.Text in_a_realOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realOutputVariablesVRs, in_a_realOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realOutputVariablesVRs;
      Tpl.Text a_realOutputVariablesNames;

    case ( txt,
           false,
           a_realOutputVariablesVRs,
           a_realOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_realOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetReal(fmi1cs, {"));
        txt = Tpl.writeText(txt, a_realOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowControl);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_311;

protected function fun_312
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerOutputVariablesVRs;
  input Tpl.Text in_a_integerOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerOutputVariablesVRs, in_a_integerOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerOutputVariablesVRs;
      Tpl.Text a_integerOutputVariablesNames;

    case ( txt,
           false,
           a_integerOutputVariablesVRs,
           a_integerOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_integerOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetInteger(fmi1cs, {"));
        txt = Tpl.writeText(txt, a_integerOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowControl);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_312;

protected function fun_313
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanOutputVariablesVRs;
  input Tpl.Text in_a_booleanOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanOutputVariablesVRs, in_a_booleanOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanOutputVariablesVRs;
      Tpl.Text a_booleanOutputVariablesNames;

    case ( txt,
           false,
           a_booleanOutputVariablesVRs,
           a_booleanOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_booleanOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetBoolean(fmi1cs, {"));
        txt = Tpl.writeText(txt, a_booleanOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowControl);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_313;

protected function fun_314
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringOutputVariablesVRs;
  input Tpl.Text in_a_stringOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringOutputVariablesVRs, in_a_stringOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringOutputVariablesVRs;
      Tpl.Text a_stringOutputVariablesNames;

    case ( txt,
           false,
           a_stringOutputVariablesVRs,
           a_stringOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_stringOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetString(fmi1cs, {"));
        txt = Tpl.writeText(txt, a_stringOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowControl);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_314;

protected function fun_315
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_315;

protected function fun_316
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_316;

protected function fun_317
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_317;

protected function fun_318
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_318;

protected function fun_319
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_319;

protected function fun_320
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_320;

protected function fun_321
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_321;

protected function fun_322
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_322;

protected function fun_323
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_323;

protected function fun_324
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_324;

protected function fun_325
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_325;

public function importFMU1CoSimulationStandAlone
  input Tpl.Text in_txt;
  input FMI.FmiImport in_a_fmi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmi)
    local
      Tpl.Text txt;
      String i_platform;
      Real i_fmiExperimentAnnotation_fmiExperimentTolerance;
      Boolean i_generateOutputConnectors;
      Boolean i_generateInputConnectors;
      Real i_fmiExperimentAnnotation_fmiExperimentStopTime;
      Real i_fmiExperimentAnnotation_fmiExperimentStartTime;
      Boolean i_fmiDebugOutput;
      Integer i_fmiLogLevel;
      String i_fmuWorkingDirectory;
      String i_fmuFileName;
      String i_fmiInfo_fmiDescription;
      FMI.Info i_fmiInfo;
      String i_fmiInfo_fmiModelIdentifier;
      list<FMI.ModelVariables> i_fmiModelVariablesList;
      String ret_45;
      Boolean ret_44;
      Boolean ret_43;
      Boolean ret_42;
      Boolean ret_41;
      Boolean ret_40;
      Boolean ret_39;
      Boolean ret_38;
      Boolean ret_37;
      Boolean ret_36;
      Boolean ret_35;
      Boolean ret_34;
      Boolean ret_33;
      Boolean ret_32;
      Boolean ret_31;
      Boolean ret_30;
      Boolean ret_29;
      Boolean ret_28;
      Boolean ret_27;
      Boolean ret_26;
      Boolean ret_25;
      Boolean ret_24;
      Boolean ret_23;
      Boolean ret_22;
      Boolean ret_21;
      String ret_20;
      Tpl.Text l_stringOutputVariablesNames;
      Tpl.Text l_stringOutputVariablesVRs;
      Tpl.Text l_booleanOutputVariablesNames;
      Tpl.Text l_booleanOutputVariablesVRs;
      Tpl.Text l_integerOutputVariablesNames;
      Tpl.Text l_integerOutputVariablesVRs;
      Tpl.Text l_realOutputVariablesNames;
      Tpl.Text l_realOutputVariablesVRs;
      Tpl.Text l_stringInputVariablesReturnNames;
      Tpl.Text l_stringStartVariablesNames;
      Tpl.Text l_stringInputVariablesVRs;
      Tpl.Text l_booleanInputVariablesReturnNames;
      Tpl.Text l_booleanInputVariablesNames;
      Tpl.Text l_booleanInputVariablesVRs;
      Tpl.Text l_integerInputVariablesReturnNames;
      Tpl.Text l_integerInputVariablesNames;
      Tpl.Text l_integerInputVariablesVRs;
      Tpl.Text l_realInputVariablesReturnNames;
      Tpl.Text l_realInputVariablesNames;
      Tpl.Text l_realInputVariablesVRs;

    case ( txt,
           FMI.FMIIMPORT(fmiInfo = (i_fmiInfo as FMI.INFO(fmiModelIdentifier = i_fmiInfo_fmiModelIdentifier, fmiDescription = i_fmiInfo_fmiDescription)), fmiExperimentAnnotation = FMI.EXPERIMENTANNOTATION(fmiExperimentStartTime = i_fmiExperimentAnnotation_fmiExperimentStartTime, fmiExperimentStopTime = i_fmiExperimentAnnotation_fmiExperimentStopTime, fmiExperimentTolerance = i_fmiExperimentAnnotation_fmiExperimentTolerance), fmiModelVariablesList = i_fmiModelVariablesList, fmuFileName = i_fmuFileName, fmuWorkingDirectory = i_fmuWorkingDirectory, fmiLogLevel = i_fmiLogLevel, fmiDebugOutput = i_fmiDebugOutput, generateInputConnectors = i_generateInputConnectors, generateOutputConnectors = i_generateOutputConnectors, platform = i_platform) )
      equation
        l_realInputVariablesVRs = dumpInputRealVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realInputVariablesNames = dumpInputRealVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realInputVariablesReturnNames = dumpInputRealVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesVRs = dumpInputIntegerVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesNames = dumpInputIntegerVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesReturnNames = dumpInputIntegerVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesVRs = dumpInputBooleanVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesNames = dumpInputBooleanVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesReturnNames = dumpInputBooleanVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringInputVariablesVRs = dumpInputStringVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringStartVariablesNames = dumpInputStringVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringInputVariablesReturnNames = dumpInputStringVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realOutputVariablesVRs = dumpOutputRealVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realOutputVariablesNames = dumpOutputRealVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerOutputVariablesVRs = dumpOutputIntegerVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerOutputVariablesNames = dumpOutputIntegerVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanOutputVariablesVRs = dumpOutputBooleanVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanOutputVariablesNames = dumpOutputBooleanVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringOutputVariablesVRs = dumpOutputStringVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringOutputVariablesNames = dumpOutputStringVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("model "));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        ret_20 = FMI.getFMIType(i_fmiInfo);
        txt = Tpl.writeStr(txt, ret_20);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU"));
        ret_21 = stringEq(i_fmiInfo_fmiDescription, "");
        txt = fun_310(txt, ret_21, i_fmiInfo_fmiDescription);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant String fmuLocation = \""));
        txt = Tpl.writeStr(txt, i_fmuFileName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "constant String fmuWorkingDir = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fmuWorkingDirectory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "parameter Integer logLevel = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_fmiLogLevel));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"log level used during the loading of FMU\" annotation (Dialog(tab=\"FMI\", group=\"Enable logging\"));\n",
                                    "parameter Boolean debugLogging = "
                                }, false));
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_fmiDebugOutput));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"enables the FMU simulation logging\" annotation (Dialog(tab=\"FMI\", group=\"Enable logging\"));\n",
                                    "constant String mimeType = \"\";\n",
                                    "constant Real timeout = 0.0;\n",
                                    "constant Boolean visible = false;\n",
                                    "constant Boolean interactive = false;\n",
                                    "parameter Real StartTime = "
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStartTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"start time used to initialize the slave\" annotation (Dialog(tab=\"FMI\", group=\"Step time\"));\n",
                                    "parameter Real StopTime = "
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"stop time used to initialize the slave\" annotation (Dialog(tab=\"FMI\", group=\"Step time\"));\n",
                                    "parameter Real communicationStepSize = (StopTime-StartTime)/500 \"step size used by fmiDoStep\" annotation (Dialog(tab=\"FMI\", group=\"Step time\"));\n",
                                    "constant Boolean stopTimeDefined = false;\n",
                                    "FMI1CoSimulation fmi1cs = FMI1CoSimulation(logLevel, fmuWorkingDir, \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\", debugLogging, fmuLocation, mimeType, timeout, visible, interactive, StartTime, stopTimeDefined, StopTime);\n"));
        txt = dumpFMIModelVariablesList(txt, i_fmiModelVariablesList, i_generateInputConnectors, i_generateOutputConnectors);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Real flowControl;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "equation\n",
                                    "  flowControl = fmi1Functions.fmi1DoStep(fmi1cs, time, communicationStepSize, true);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_22 = stringEq(Tpl.textString(l_realOutputVariablesNames), "");
        ret_23 = stringEq(Tpl.textString(l_realOutputVariablesVRs), "");
        ret_24 = boolAnd(ret_22, ret_23);
        txt = fun_311(txt, ret_24, l_realOutputVariablesVRs, l_realOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_25 = stringEq(Tpl.textString(l_integerOutputVariablesNames), "");
        ret_26 = stringEq(Tpl.textString(l_integerOutputVariablesVRs), "");
        ret_27 = boolAnd(ret_25, ret_26);
        txt = fun_312(txt, ret_27, l_integerOutputVariablesVRs, l_integerOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_28 = stringEq(Tpl.textString(l_booleanOutputVariablesNames), "");
        ret_29 = stringEq(Tpl.textString(l_booleanOutputVariablesVRs), "");
        ret_30 = boolAnd(ret_28, ret_29);
        txt = fun_313(txt, ret_30, l_booleanOutputVariablesVRs, l_booleanOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_31 = stringEq(Tpl.textString(l_stringOutputVariablesNames), "");
        ret_32 = stringEq(Tpl.textString(l_stringOutputVariablesVRs), "");
        ret_33 = boolAnd(ret_31, ret_32);
        txt = fun_314(txt, ret_33, l_stringOutputVariablesVRs, l_stringOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("annotation(experiment(StartTime="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStartTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", StopTime="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", Tolerance="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentTolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "));\n",
                                    "annotation (Icon(graphics={\n",
                                    "    Rectangle(\n",
                                    "      extent={{-100,100},{100,-100}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      fillColor={240,240,240},\n",
                                    "      fillPattern=FillPattern.Solid,\n",
                                    "      lineThickness=0.5),\n",
                                    "    Text(\n",
                                    "      extent={{-100,40},{100,0}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      textString=\"%name\"),\n",
                                    "    Text(\n",
                                    "      extent={{-100,-50},{100,-90}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      textString=\"V1.0\")}));\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "protected\n",
                                    "  class FMI1CoSimulation\n",
                                    "    extends ExternalObject;\n",
                                    "      function constructor\n",
                                    "        input Integer fmiLogLevel;\n",
                                    "        input String workingDirectory;\n",
                                    "        input String instanceName;\n",
                                    "        input Boolean debugLogging;\n",
                                    "        input String fmuLocation;\n",
                                    "        input String mimeType;\n",
                                    "        input Real timeOut;\n",
                                    "        input Boolean visible;\n",
                                    "        input Boolean interactive;\n",
                                    "        input Real tStart;\n",
                                    "        input Boolean stopTimeDefined;\n",
                                    "        input Real tStop;\n",
                                    "        output FMI1CoSimulation fmi1cs;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1cs = FMI1CoSimulationConstructor_OMC(fmiLogLevel, workingDirectory, instanceName, debugLogging, fmuLocation, mimeType, timeOut, visible, interactive, tStart, stopTimeDefined, tStop) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_34 = stringEq(i_platform, "win32");
        txt = fun_315(txt, ret_34);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      end constructor;\n",
                                    "\n",
                                    "      function destructor\n",
                                    "        input FMI1CoSimulation fmi1cs;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" FMI1CoSimulationDestructor_OMC(fmi1cs) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_35 = stringEq(i_platform, "win32");
        txt = fun_316(txt, ret_35);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      end destructor;\n",
                                    "  end FMI1CoSimulation;\n",
                                    "\n",
                                    "  package fmi1Functions\n",
                                    "    function fmi1DoStep\n",
                                    "      input FMI1CoSimulation fmi1cs;\n",
                                    "      input Real currentCommunicationPoint;\n",
                                    "      input Real communicationStepSize;\n",
                                    "      input Boolean newStep;\n",
                                    "      output Real outFlowControl;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outFlowControl = fmi1DoStep_OMC(fmi1cs, currentCommunicationPoint, communicationStepSize, newStep) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_36 = stringEq(i_platform, "win32");
        txt = fun_317(txt, ret_36);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1DoStep;\n",
                                    "\n",
                                    "    function fmi1GetReal\n",
                                    "      input FMI1CoSimulation fmi1cs;\n",
                                    "      input Real realValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output Real realValues[size(realValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetReal_OMC(fmi1cs, size(realValuesReferences, 1), realValuesReferences, inFlowStatesInput, realValues, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_37 = stringEq(i_platform, "win32");
        txt = fun_318(txt, ret_37);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1GetReal;\n",
                                    "\n",
                                    "    function fmi1SetReal\n",
                                    "      input FMI1CoSimulation fmi1cs;\n",
                                    "      input Real realValuesReferences[:];\n",
                                    "      input Real realValues[size(realValuesReferences, 1)];\n",
                                    "      output Real out_Values[size(realValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetReal_OMC(fmi1cs, size(realValuesReferences, 1), realValuesReferences, realValues, out_Values, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_38 = stringEq(i_platform, "win32");
        txt = fun_319(txt, ret_38);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1SetReal;\n",
                                    "\n",
                                    "    function fmi1GetInteger\n",
                                    "      input FMI1CoSimulation fmi1cs;\n",
                                    "      input Real integerValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output Integer integerValues[size(integerValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetInteger_OMC(fmi1cs, size(integerValuesReferences, 1), integerValuesReferences, inFlowStatesInput, integerValues, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_39 = stringEq(i_platform, "win32");
        txt = fun_320(txt, ret_39);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1GetInteger;\n",
                                    "\n",
                                    "    function fmi1SetInteger\n",
                                    "      input FMI1CoSimulation fmi1cs;\n",
                                    "      input Real integerValuesReferences[:];\n",
                                    "      input Integer integerValues[size(integerValuesReferences, 1)];\n",
                                    "      output Real out_Values[size(integerValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetInteger_OMC(fmi1cs, size(integerValuesReferences, 1), integerValuesReferences, integerValues, out_Values, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_40 = stringEq(i_platform, "win32");
        txt = fun_321(txt, ret_40);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1SetInteger;\n",
                                    "\n",
                                    "    function fmi1GetBoolean\n",
                                    "      input FMI1CoSimulation fmi1cs;\n",
                                    "      input Real booleanValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output Boolean booleanValues[size(booleanValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetBoolean_OMC(fmi1cs, size(booleanValuesReferences, 1), booleanValuesReferences, inFlowStatesInput, booleanValues, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_41 = stringEq(i_platform, "win32");
        txt = fun_322(txt, ret_41);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1GetBoolean;\n",
                                    "\n",
                                    "    function fmi1SetBoolean\n",
                                    "      input FMI1CoSimulation fmi1cs;\n",
                                    "      input Real booleanValuesReferences[:];\n",
                                    "      input Boolean booleanValues[size(booleanValuesReferences, 1)];\n",
                                    "      output Real out_Values[size(booleanValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetBoolean_OMC(fmi1cs, size(booleanValuesReferences, 1), booleanValuesReferences, booleanValues, out_Values, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_42 = stringEq(i_platform, "win32");
        txt = fun_323(txt, ret_42);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1SetBoolean;\n",
                                    "\n",
                                    "    function fmi1GetString\n",
                                    "      input FMI1CoSimulation fmi1cs;\n",
                                    "      input Real stringValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output String stringValues[size(stringValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetString_OMC(fmi1cs, size(stringValuesReferences, 1), stringValuesReferences, inFlowStatesInput, stringValues, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_43 = stringEq(i_platform, "win32");
        txt = fun_324(txt, ret_43);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1GetString;\n",
                                    "\n",
                                    "    function fmi1SetString\n",
                                    "      input FMI1CoSimulation fmi1cs;\n",
                                    "      input Real stringValuesReferences[:];\n",
                                    "      input String stringValues[size(stringValuesReferences, 1)];\n",
                                    "      output Real out_Values[size(stringValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetString_OMC(fmi1cs, size(stringValuesReferences, 1), stringValuesReferences, stringValues, out_Values, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_44 = stringEq(i_platform, "win32");
        txt = fun_325(txt, ret_44);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi1SetString;\n",
                                    "  end fmi1Functions;\n",
                                    "\n",
                                    "  package fmiStatus\n",
                                    "    constant Integer fmiOK=0;\n",
                                    "    constant Integer fmiWarning=1;\n",
                                    "    constant Integer fmiDiscard=2;\n",
                                    "    constant Integer fmiError=3;\n",
                                    "    constant Integer fmiFatal=4;\n",
                                    "    constant Integer fmiPending=5;\n",
                                    "  end fmiStatus;\n",
                                    "end "
                                }, false));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        ret_45 = FMI.getFMIType(i_fmiInfo);
        txt = Tpl.writeStr(txt, ret_45);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end importFMU1CoSimulationStandAlone;

protected function lm_327
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;
  input Boolean in_a_generateOutputConnectors;
  input Boolean in_a_generateInputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_generateOutputConnectors, in_a_generateInputConnectors)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      Boolean a_generateOutputConnectors;
      Boolean a_generateInputConnectors;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest,
           a_generateOutputConnectors,
           a_generateInputConnectors )
      equation
        txt = dumpFMIModelVariable(txt, i_fmiModelVariable, a_generateInputConnectors, a_generateOutputConnectors);
        txt = Tpl.nextIter(txt);
        txt = lm_327(txt, rest, a_generateOutputConnectors, a_generateInputConnectors);
      then txt;
  end match;
end lm_327;

public function dumpFMIModelVariablesList
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;
  input Boolean a_generateInputConnectors;
  input Boolean a_generateOutputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_327(out_txt, a_fmiModelVariablesList, a_generateOutputConnectors, a_generateInputConnectors);
  out_txt := Tpl.popIter(out_txt);
end dumpFMIModelVariablesList;

public function dumpFMIModelVariable
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;
  input Boolean in_a_generateInputConnectors;
  input Boolean in_a_generateOutputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable, in_a_generateInputConnectors, in_a_generateOutputConnectors)
    local
      Tpl.Text txt;
      Boolean a_generateInputConnectors;
      Boolean a_generateOutputConnectors;
      String i_startValue_3;
      Boolean i_startValue_2;
      Integer i_startValue_1;
      Integer i_y2Placement;
      Integer i_y1Placement;
      Integer i_x2Placement;
      Integer i_x1Placement;
      String i_description;
      Boolean i_isFixed;
      Real i_startValue;
      Boolean i_hasStartValue;
      String i_name;
      String i_baseType;
      String i_causality;
      String i_variability;

    case ( txt,
           FMI.REALVARIABLE(variability = i_variability, causality = i_causality, baseType = i_baseType, name = i_name, hasStartValue = i_hasStartValue, startValue = i_startValue, isFixed = i_isFixed, description = i_description, x1Placement = i_x1Placement, x2Placement = i_x2Placement, y1Placement = i_y1Placement, y2Placement = i_y2Placement),
           a_generateInputConnectors,
           a_generateOutputConnectors )
      equation
        txt = dumpFMIModelVariableVariability(txt, i_variability);
        txt = dumpFMIModelVariableCausalityAndBaseType(txt, i_causality, i_baseType, a_generateInputConnectors, a_generateOutputConnectors);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpFMIRealModelVariableStartValue(txt, i_hasStartValue, i_startValue, i_isFixed);
        txt = dumpFMIModelVariableDescription(txt, i_description);
        txt = dumpFMIModelVariablePlacementAnnotation(txt, i_x1Placement, i_x2Placement, i_y1Placement, i_y2Placement, a_generateInputConnectors, a_generateOutputConnectors, i_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           FMI.INTEGERVARIABLE(variability = i_variability, causality = i_causality, baseType = i_baseType, name = i_name, hasStartValue = i_hasStartValue, startValue = i_startValue_1, isFixed = i_isFixed, description = i_description, x1Placement = i_x1Placement, x2Placement = i_x2Placement, y1Placement = i_y1Placement, y2Placement = i_y2Placement),
           a_generateInputConnectors,
           a_generateOutputConnectors )
      equation
        txt = dumpFMIModelVariableVariability(txt, i_variability);
        txt = dumpFMIModelVariableCausalityAndBaseType(txt, i_causality, i_baseType, a_generateInputConnectors, a_generateOutputConnectors);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpFMIIntegerModelVariableStartValue(txt, i_hasStartValue, i_startValue_1, i_isFixed);
        txt = dumpFMIModelVariableDescription(txt, i_description);
        txt = dumpFMIModelVariablePlacementAnnotation(txt, i_x1Placement, i_x2Placement, i_y1Placement, i_y2Placement, a_generateInputConnectors, a_generateOutputConnectors, i_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           FMI.BOOLEANVARIABLE(variability = i_variability, causality = i_causality, baseType = i_baseType, name = i_name, hasStartValue = i_hasStartValue, startValue = i_startValue_2, isFixed = i_isFixed, description = i_description, x1Placement = i_x1Placement, x2Placement = i_x2Placement, y1Placement = i_y1Placement, y2Placement = i_y2Placement),
           a_generateInputConnectors,
           a_generateOutputConnectors )
      equation
        txt = dumpFMIModelVariableVariability(txt, i_variability);
        txt = dumpFMIModelVariableCausalityAndBaseType(txt, i_causality, i_baseType, a_generateInputConnectors, a_generateOutputConnectors);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpFMIBooleanModelVariableStartValue(txt, i_hasStartValue, i_startValue_2, i_isFixed);
        txt = dumpFMIModelVariableDescription(txt, i_description);
        txt = dumpFMIModelVariablePlacementAnnotation(txt, i_x1Placement, i_x2Placement, i_y1Placement, i_y2Placement, a_generateInputConnectors, a_generateOutputConnectors, i_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           FMI.STRINGVARIABLE(variability = i_variability, causality = i_causality, baseType = i_baseType, name = i_name, hasStartValue = i_hasStartValue, startValue = i_startValue_3, isFixed = i_isFixed, description = i_description, x1Placement = i_x1Placement, x2Placement = i_x2Placement, y1Placement = i_y1Placement, y2Placement = i_y2Placement),
           a_generateInputConnectors,
           a_generateOutputConnectors )
      equation
        txt = dumpFMIModelVariableVariability(txt, i_variability);
        txt = dumpFMIModelVariableCausalityAndBaseType(txt, i_causality, i_baseType, a_generateInputConnectors, a_generateOutputConnectors);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpFMIStringModelVariableStartValue(txt, i_hasStartValue, i_startValue_3, i_isFixed);
        txt = dumpFMIModelVariableDescription(txt, i_description);
        txt = dumpFMIModelVariablePlacementAnnotation(txt, i_x1Placement, i_x2Placement, i_y1Placement, i_y2Placement, a_generateInputConnectors, a_generateOutputConnectors, i_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           FMI.ENUMERATIONVARIABLE(variability = i_variability, causality = i_causality, baseType = i_baseType, name = i_name, hasStartValue = i_hasStartValue, startValue = i_startValue_1, isFixed = i_isFixed, description = i_description, x1Placement = i_x1Placement, x2Placement = i_x2Placement, y1Placement = i_y1Placement, y2Placement = i_y2Placement),
           a_generateInputConnectors,
           a_generateOutputConnectors )
      equation
        txt = dumpFMIModelVariableVariability(txt, i_variability);
        txt = dumpFMIModelVariableCausalityAndBaseType(txt, i_causality, i_baseType, a_generateInputConnectors, a_generateOutputConnectors);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpFMIIntegerModelVariableStartValue(txt, i_hasStartValue, i_startValue_1, i_isFixed);
        txt = dumpFMIModelVariableDescription(txt, i_description);
        txt = dumpFMIModelVariablePlacementAnnotation(txt, i_x1Placement, i_x2Placement, i_y1Placement, i_y2Placement, a_generateInputConnectors, a_generateOutputConnectors, i_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpFMIModelVariable;

protected function fun_330
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_variability;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_variability)
    local
      Tpl.Text txt;
      String a_variability;

    case ( txt,
           false,
           a_variability )
      equation
        txt = Tpl.writeStr(txt, a_variability);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_330;

public function dumpFMIModelVariableVariability
  input Tpl.Text txt;
  input String a_variability;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := stringEq(a_variability, "");
  out_txt := fun_330(txt, ret_0, a_variability);
end dumpFMIModelVariableVariability;

protected function fun_332
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_baseType;
  input String in_a_causality;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_baseType, in_a_causality)
    local
      Tpl.Text txt;
      String a_baseType;
      String a_causality;

    case ( txt,
           false,
           a_baseType,
           a_causality )
      equation
        txt = Tpl.writeStr(txt, a_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_baseType);
      then txt;

    case ( txt,
           _,
           a_baseType,
           _ )
      equation
        txt = Tpl.writeStr(txt, a_baseType);
      then txt;
  end match;
end fun_332;

protected function fun_333
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_baseType;
  input String in_a_causality;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_baseType, in_a_causality)
    local
      Tpl.Text txt;
      String a_baseType;
      String a_causality;
      Boolean ret_0;

    case ( txt,
           false,
           a_baseType,
           a_causality )
      equation
        ret_0 = stringEq(a_causality, "");
        txt = fun_332(txt, ret_0, a_baseType, a_causality);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Modelica.Blocks.Interfaces.BooleanOutput"));
      then txt;
  end match;
end fun_333;

protected function fun_334
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_baseType;
  input String in_a_causality;
  input Boolean in_a_generateOutputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_baseType, in_a_causality, in_a_generateOutputConnectors)
    local
      Tpl.Text txt;
      String a_baseType;
      String a_causality;
      Boolean a_generateOutputConnectors;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_baseType,
           a_causality,
           a_generateOutputConnectors )
      equation
        ret_0 = stringEq(a_causality, "output");
        ret_1 = stringEq(a_baseType, "Boolean");
        ret_2 = boolAnd(ret_0, ret_1);
        ret_3 = boolAnd(a_generateOutputConnectors, ret_2);
        txt = fun_333(txt, ret_3, a_baseType, a_causality);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Modelica.Blocks.Interfaces.IntegerOutput"));
      then txt;
  end match;
end fun_334;

protected function fun_335
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_baseType;
  input String in_a_causality;
  input Boolean in_a_generateOutputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_baseType, in_a_causality, in_a_generateOutputConnectors)
    local
      Tpl.Text txt;
      String a_baseType;
      String a_causality;
      Boolean a_generateOutputConnectors;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_baseType,
           a_causality,
           a_generateOutputConnectors )
      equation
        ret_0 = stringEq(a_causality, "output");
        ret_1 = stringEq(a_baseType, "Integer");
        ret_2 = boolAnd(ret_0, ret_1);
        ret_3 = boolAnd(a_generateOutputConnectors, ret_2);
        txt = fun_334(txt, ret_3, a_baseType, a_causality, a_generateOutputConnectors);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Modelica.Blocks.Interfaces.RealOutput"));
      then txt;
  end match;
end fun_335;

protected function fun_336
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_baseType;
  input String in_a_causality;
  input Boolean in_a_generateOutputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_baseType, in_a_causality, in_a_generateOutputConnectors)
    local
      Tpl.Text txt;
      String a_baseType;
      String a_causality;
      Boolean a_generateOutputConnectors;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_baseType,
           a_causality,
           a_generateOutputConnectors )
      equation
        ret_0 = stringEq(a_causality, "output");
        ret_1 = stringEq(a_baseType, "Real");
        ret_2 = boolAnd(ret_0, ret_1);
        ret_3 = boolAnd(a_generateOutputConnectors, ret_2);
        txt = fun_335(txt, ret_3, a_baseType, a_causality, a_generateOutputConnectors);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Modelica.Blocks.Interfaces.BooleanInput"));
      then txt;
  end match;
end fun_336;

protected function fun_337
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Boolean in_a_generateOutputConnectors;
  input String in_a_baseType;
  input String in_a_causality;
  input Boolean in_a_generateInputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_generateOutputConnectors, in_a_baseType, in_a_causality, in_a_generateInputConnectors)
    local
      Tpl.Text txt;
      Boolean a_generateOutputConnectors;
      String a_baseType;
      String a_causality;
      Boolean a_generateInputConnectors;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_generateOutputConnectors,
           a_baseType,
           a_causality,
           a_generateInputConnectors )
      equation
        ret_0 = stringEq(a_causality, "input");
        ret_1 = stringEq(a_baseType, "Boolean");
        ret_2 = boolAnd(ret_0, ret_1);
        ret_3 = boolAnd(a_generateInputConnectors, ret_2);
        txt = fun_336(txt, ret_3, a_baseType, a_causality, a_generateOutputConnectors);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Modelica.Blocks.Interfaces.IntegerInput"));
      then txt;
  end match;
end fun_337;

protected function fun_338
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_causality;
  input String in_a_baseType;
  input Boolean in_a_generateInputConnectors;
  input Boolean in_a_generateOutputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_causality, in_a_baseType, in_a_generateInputConnectors, in_a_generateOutputConnectors)
    local
      Tpl.Text txt;
      String a_causality;
      String a_baseType;
      Boolean a_generateInputConnectors;
      Boolean a_generateOutputConnectors;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_causality,
           a_baseType,
           a_generateInputConnectors,
           a_generateOutputConnectors )
      equation
        ret_0 = stringEq(a_causality, "input");
        ret_1 = stringEq(a_baseType, "Integer");
        ret_2 = boolAnd(ret_0, ret_1);
        ret_3 = boolAnd(a_generateInputConnectors, ret_2);
        txt = fun_337(txt, ret_3, a_generateOutputConnectors, a_baseType, a_causality, a_generateInputConnectors);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Modelica.Blocks.Interfaces.RealInput"));
      then txt;
  end match;
end fun_338;

public function dumpFMIModelVariableCausalityAndBaseType
  input Tpl.Text txt;
  input String a_causality;
  input String a_baseType;
  input Boolean a_generateInputConnectors;
  input Boolean a_generateOutputConnectors;

  output Tpl.Text out_txt;
protected
  Boolean ret_3;
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  ret_0 := stringEq(a_causality, "input");
  ret_1 := stringEq(a_baseType, "Real");
  ret_2 := boolAnd(ret_0, ret_1);
  ret_3 := boolAnd(a_generateInputConnectors, ret_2);
  out_txt := fun_338(txt, ret_3, a_causality, a_baseType, a_generateInputConnectors, a_generateOutputConnectors);
end dumpFMIModelVariableCausalityAndBaseType;

protected function fun_340
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_causality;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_causality)
    local
      Tpl.Text txt;
      String a_causality;

    case ( txt,
           false,
           a_causality )
      equation
        txt = Tpl.writeStr(txt, a_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_340;

public function dumpFMIModelVariableCausality
  input Tpl.Text txt;
  input String a_causality;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := stringEq(a_causality, "");
  out_txt := fun_340(txt, ret_0, a_causality);
end dumpFMIModelVariableCausality;

protected function fun_342
  input Tpl.Text in_txt;
  input Boolean in_a_hasStartValue;
  input Real in_a_startValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hasStartValue, in_a_startValue)
    local
      Tpl.Text txt;
      Real a_startValue;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_startValue )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(start="));
        txt = Tpl.writeStr(txt, realString(a_startValue));
      then txt;
  end match;
end fun_342;

protected function fun_343
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",fixed=true"));
      then txt;
  end match;
end fun_343;

protected function fun_344
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(fixed=true"));
      then txt;
  end match;
end fun_344;

protected function fun_345
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_345;

public function dumpFMIRealModelVariableStartValue
  input Tpl.Text txt;
  input Boolean a_hasStartValue;
  input Real a_startValue;
  input Boolean a_isFixed;

  output Tpl.Text out_txt;
protected
  Boolean ret_3;
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  out_txt := fun_342(txt, a_hasStartValue, a_startValue);
  ret_0 := boolAnd(a_hasStartValue, a_isFixed);
  out_txt := fun_343(out_txt, ret_0);
  ret_1 := boolNot(a_hasStartValue);
  ret_2 := boolAnd(ret_1, a_isFixed);
  out_txt := fun_344(out_txt, ret_2);
  ret_3 := boolOr(a_hasStartValue, a_isFixed);
  out_txt := fun_345(out_txt, ret_3);
end dumpFMIRealModelVariableStartValue;

protected function fun_347
  input Tpl.Text in_txt;
  input Boolean in_a_hasStartValue;
  input Integer in_a_startValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hasStartValue, in_a_startValue)
    local
      Tpl.Text txt;
      Integer a_startValue;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_startValue )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(start="));
        txt = Tpl.writeStr(txt, intString(a_startValue));
      then txt;
  end match;
end fun_347;

protected function fun_348
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",fixed=true"));
      then txt;
  end match;
end fun_348;

protected function fun_349
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(fixed=true"));
      then txt;
  end match;
end fun_349;

protected function fun_350
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_350;

public function dumpFMIIntegerModelVariableStartValue
  input Tpl.Text txt;
  input Boolean a_hasStartValue;
  input Integer a_startValue;
  input Boolean a_isFixed;

  output Tpl.Text out_txt;
protected
  Boolean ret_3;
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  out_txt := fun_347(txt, a_hasStartValue, a_startValue);
  ret_0 := boolAnd(a_hasStartValue, a_isFixed);
  out_txt := fun_348(out_txt, ret_0);
  ret_1 := boolNot(a_hasStartValue);
  ret_2 := boolAnd(ret_1, a_isFixed);
  out_txt := fun_349(out_txt, ret_2);
  ret_3 := boolOr(a_hasStartValue, a_isFixed);
  out_txt := fun_350(out_txt, ret_3);
end dumpFMIIntegerModelVariableStartValue;

protected function fun_352
  input Tpl.Text in_txt;
  input Boolean in_a_hasStartValue;
  input Boolean in_a_startValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hasStartValue, in_a_startValue)
    local
      Tpl.Text txt;
      Boolean a_startValue;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_startValue )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(start="));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_startValue));
      then txt;
  end match;
end fun_352;

protected function fun_353
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",fixed=true"));
      then txt;
  end match;
end fun_353;

protected function fun_354
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(fixed=true"));
      then txt;
  end match;
end fun_354;

protected function fun_355
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_355;

public function dumpFMIBooleanModelVariableStartValue
  input Tpl.Text txt;
  input Boolean a_hasStartValue;
  input Boolean a_startValue;
  input Boolean a_isFixed;

  output Tpl.Text out_txt;
protected
  Boolean ret_3;
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  out_txt := fun_352(txt, a_hasStartValue, a_startValue);
  ret_0 := boolAnd(a_hasStartValue, a_isFixed);
  out_txt := fun_353(out_txt, ret_0);
  ret_1 := boolNot(a_hasStartValue);
  ret_2 := boolAnd(ret_1, a_isFixed);
  out_txt := fun_354(out_txt, ret_2);
  ret_3 := boolOr(a_hasStartValue, a_isFixed);
  out_txt := fun_355(out_txt, ret_3);
end dumpFMIBooleanModelVariableStartValue;

protected function fun_357
  input Tpl.Text in_txt;
  input Boolean in_a_hasStartValue;
  input String in_a_startValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hasStartValue, in_a_startValue)
    local
      Tpl.Text txt;
      String a_startValue;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_startValue )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(start=\""));
        txt = Tpl.writeStr(txt, a_startValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_357;

protected function fun_358
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",fixed=true"));
      then txt;
  end match;
end fun_358;

protected function fun_359
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(fixed=true"));
      then txt;
  end match;
end fun_359;

protected function fun_360
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_360;

public function dumpFMIStringModelVariableStartValue
  input Tpl.Text txt;
  input Boolean a_hasStartValue;
  input String a_startValue;
  input Boolean a_isFixed;

  output Tpl.Text out_txt;
protected
  Boolean ret_3;
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  out_txt := fun_357(txt, a_hasStartValue, a_startValue);
  ret_0 := boolAnd(a_hasStartValue, a_isFixed);
  out_txt := fun_358(out_txt, ret_0);
  ret_1 := boolNot(a_hasStartValue);
  ret_2 := boolAnd(ret_1, a_isFixed);
  out_txt := fun_359(out_txt, ret_2);
  ret_3 := boolOr(a_hasStartValue, a_isFixed);
  out_txt := fun_360(out_txt, ret_3);
end dumpFMIStringModelVariableStartValue;

protected function fun_362
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_description;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_description)
    local
      Tpl.Text txt;
      String a_description;

    case ( txt,
           false,
           a_description )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \""));
        txt = Tpl.writeStr(txt, a_description);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_362;

public function dumpFMIModelVariableDescription
  input Tpl.Text txt;
  input String a_description;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := stringEq(a_description, "");
  out_txt := fun_362(txt, ret_0, a_description);
end dumpFMIModelVariableDescription;

protected function fun_364
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_y2Placement;
  input Integer in_a_x2Placement;
  input Integer in_a_y1Placement;
  input Integer in_a_x1Placement;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_y2Placement, in_a_x2Placement, in_a_y1Placement, in_a_x1Placement)
    local
      Tpl.Text txt;
      Integer a_y2Placement;
      Integer a_x2Placement;
      Integer a_y1Placement;
      Integer a_x1Placement;

    case ( txt,
           false,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_y2Placement,
           a_x2Placement,
           a_y1Placement,
           a_x1Placement )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" annotation(Placement(transformation(extent={{"));
        txt = Tpl.writeStr(txt, intString(a_x1Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_y1Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("},{"));
        txt = Tpl.writeStr(txt, intString(a_x2Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_y2Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}})))"));
      then txt;
  end match;
end fun_364;

protected function fun_365
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_x1Placement;
  input Integer in_a_x2Placement;
  input Integer in_a_y1Placement;
  input Integer in_a_y2Placement;
  input Boolean in_a_generateOutputConnectors;
  input String in_a_causality;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_x1Placement, in_a_x2Placement, in_a_y1Placement, in_a_y2Placement, in_a_generateOutputConnectors, in_a_causality)
    local
      Tpl.Text txt;
      Integer a_x1Placement;
      Integer a_x2Placement;
      Integer a_y1Placement;
      Integer a_y2Placement;
      Boolean a_generateOutputConnectors;
      String a_causality;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_x1Placement,
           a_x2Placement,
           a_y1Placement,
           a_y2Placement,
           a_generateOutputConnectors,
           a_causality )
      equation
        ret_0 = stringEq(a_causality, "output");
        ret_1 = boolAnd(a_generateOutputConnectors, ret_0);
        txt = fun_364(txt, ret_1, a_y2Placement, a_x2Placement, a_y1Placement, a_x1Placement);
      then txt;

    case ( txt,
           _,
           a_x1Placement,
           a_x2Placement,
           a_y1Placement,
           a_y2Placement,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" annotation(Placement(transformation(extent={{"));
        txt = Tpl.writeStr(txt, intString(a_x1Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_y1Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("},{"));
        txt = Tpl.writeStr(txt, intString(a_x2Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_y2Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}})))"));
      then txt;
  end match;
end fun_365;

public function dumpFMIModelVariablePlacementAnnotation
  input Tpl.Text txt;
  input Integer a_x1Placement;
  input Integer a_x2Placement;
  input Integer a_y1Placement;
  input Integer a_y2Placement;
  input Boolean a_generateInputConnectors;
  input Boolean a_generateOutputConnectors;
  input String a_causality;

  output Tpl.Text out_txt;
protected
  Boolean ret_1;
  Boolean ret_0;
algorithm
  ret_0 := stringEq(a_causality, "input");
  ret_1 := boolAnd(a_generateInputConnectors, ret_0);
  out_txt := fun_365(txt, ret_1, a_x1Placement, a_x2Placement, a_y1Placement, a_y2Placement, a_generateOutputConnectors, a_causality);
end dumpFMIModelVariablePlacementAnnotation;

protected function lm_367
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputRealVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_367(txt, rest);
      then txt;
  end match;
end lm_367;

public function dumpInputRealVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_367(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputRealVariablesVRs;

public function dumpInputRealVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.REALVARIABLE(causality = "input", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputRealVariableVR;

protected function lm_370
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputRealVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_370(txt, rest);
      then txt;
  end match;
end lm_370;

public function dumpInputRealVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_370(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputRealVariablesNames;

public function dumpInputRealVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.REALVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputRealVariableName;

protected function lm_373
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputRealVariableReturnName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_373(txt, rest);
      then txt;
  end match;
end lm_373;

public function dumpInputRealVariablesReturnNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_373(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputRealVariablesReturnNames;

public function dumpInputRealVariableReturnName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.REALVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi_input_"));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputRealVariableReturnName;

protected function lm_376
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputIntegerVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_376(txt, rest);
      then txt;
  end match;
end lm_376;

public function dumpInputIntegerVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_376(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputIntegerVariablesVRs;

public function dumpInputIntegerVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.INTEGERVARIABLE(causality = "input", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputIntegerVariableVR;

protected function lm_379
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputIntegerVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_379(txt, rest);
      then txt;
  end match;
end lm_379;

public function dumpInputIntegerVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_379(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputIntegerVariablesNames;

public function dumpInputIntegerVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.INTEGERVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputIntegerVariableName;

protected function lm_382
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputIntegerVariableReturnName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_382(txt, rest);
      then txt;
  end match;
end lm_382;

public function dumpInputIntegerVariablesReturnNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_382(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputIntegerVariablesReturnNames;

public function dumpInputIntegerVariableReturnName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.INTEGERVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi_input_"));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputIntegerVariableReturnName;

protected function lm_385
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputBooleanVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_385(txt, rest);
      then txt;
  end match;
end lm_385;

public function dumpInputBooleanVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_385(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputBooleanVariablesVRs;

public function dumpInputBooleanVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.BOOLEANVARIABLE(causality = "input", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputBooleanVariableVR;

protected function lm_388
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputBooleanVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_388(txt, rest);
      then txt;
  end match;
end lm_388;

public function dumpInputBooleanVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_388(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputBooleanVariablesNames;

public function dumpInputBooleanVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.BOOLEANVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputBooleanVariableName;

protected function lm_391
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputBooleanVariableReturnName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_391(txt, rest);
      then txt;
  end match;
end lm_391;

public function dumpInputBooleanVariablesReturnNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_391(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputBooleanVariablesReturnNames;

public function dumpInputBooleanVariableReturnName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.BOOLEANVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi_input_"));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputBooleanVariableReturnName;

protected function lm_394
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputStringVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_394(txt, rest);
      then txt;
  end match;
end lm_394;

public function dumpInputStringVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_394(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputStringVariablesVRs;

public function dumpInputStringVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.STRINGVARIABLE(causality = "input", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputStringVariableVR;

protected function lm_397
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputStringVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_397(txt, rest);
      then txt;
  end match;
end lm_397;

public function dumpInputStringVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_397(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputStringVariablesNames;

public function dumpInputStringVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.STRINGVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputStringVariableName;

protected function lm_400
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputStringVariableReturnName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_400(txt, rest);
      then txt;
  end match;
end lm_400;

public function dumpInputStringVariablesReturnNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_400(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputStringVariablesReturnNames;

public function dumpInputStringVariableReturnName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.STRINGVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi_input_"));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputStringVariableReturnName;

protected function lm_403
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputRealVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_403(txt, rest);
      then txt;
  end match;
end lm_403;

public function dumpOutputRealVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_403(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputRealVariablesVRs;

public function dumpOutputRealVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.REALVARIABLE(variability = "", causality = "", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           FMI.REALVARIABLE(variability = "", causality = "output", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputRealVariableVR;

protected function lm_406
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputRealVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_406(txt, rest);
      then txt;
  end match;
end lm_406;

public function dumpOutputRealVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_406(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputRealVariablesNames;

public function dumpOutputRealVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.REALVARIABLE(variability = "", causality = "", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           FMI.REALVARIABLE(variability = "", causality = "output", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputRealVariableName;

protected function lm_409
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputIntegerVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_409(txt, rest);
      then txt;
  end match;
end lm_409;

public function dumpOutputIntegerVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_409(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputIntegerVariablesVRs;

public function dumpOutputIntegerVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.INTEGERVARIABLE(variability = "", causality = "", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           FMI.INTEGERVARIABLE(variability = "", causality = "output", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputIntegerVariableVR;

protected function lm_412
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputIntegerVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_412(txt, rest);
      then txt;
  end match;
end lm_412;

public function dumpOutputIntegerVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_412(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputIntegerVariablesNames;

public function dumpOutputIntegerVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.INTEGERVARIABLE(variability = "", causality = "", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           FMI.INTEGERVARIABLE(variability = "", causality = "output", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputIntegerVariableName;

protected function lm_415
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputBooleanVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_415(txt, rest);
      then txt;
  end match;
end lm_415;

public function dumpOutputBooleanVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_415(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputBooleanVariablesVRs;

public function dumpOutputBooleanVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.BOOLEANVARIABLE(variability = "", causality = "", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           FMI.BOOLEANVARIABLE(variability = "", causality = "output", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputBooleanVariableVR;

protected function lm_418
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputBooleanVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_418(txt, rest);
      then txt;
  end match;
end lm_418;

public function dumpOutputBooleanVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_418(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputBooleanVariablesNames;

public function dumpOutputBooleanVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.BOOLEANVARIABLE(variability = "", causality = "", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           FMI.BOOLEANVARIABLE(variability = "", causality = "output", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputBooleanVariableName;

protected function lm_421
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputStringVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_421(txt, rest);
      then txt;
  end match;
end lm_421;

public function dumpOutputStringVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_421(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputStringVariablesVRs;

public function dumpOutputStringVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.STRINGVARIABLE(variability = "", causality = "", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           FMI.STRINGVARIABLE(variability = "", causality = "output", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputStringVariableVR;

protected function lm_424
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputStringVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_424(txt, rest);
      then txt;
  end match;
end lm_424;

public function dumpOutputStringVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_424(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputStringVariablesNames;

public function dumpOutputStringVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.STRINGVARIABLE(variability = "", causality = "", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           FMI.STRINGVARIABLE(variability = "", causality = "output", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputStringVariableName;

end CodegenFMU;