encapsulated package CodegenFMUCpp
"
  file:        CodegenFMUCpp.mo
  package:     CodegenFMUCpp
  description: Generated by Susan.
"

public import Tpl;

public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCode;
public import HpcOmScheduler;
public import CodegenUtil;
public import CodegenCpp;
public import CodegenFMU;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      String i_fileNamePrefix;
      list<DAE.Exp> i_literals;
      list<SimCode.Function> i_modelInfo_functions;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      list<SimCode.SimEqSystem> ret_18;
      Tpl.Text txt_17;
      Tpl.Text txt_16;
      Tpl.Text txt_15;
      Tpl.Text txt_14;
      Tpl.Text txt_13;
      Tpl.Text txt_12;
      Tpl.Text txt_11;
      Tpl.Text txt_10;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text l_name;
      String ret_3;
      Tpl.Text l_target;
      String ret_1;
      Tpl.Text l_guid;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name, functions = i_modelInfo_functions), literals = i_literals, fileNamePrefix = i_fileNamePrefix, allEquations = i_allEquations, initialEquations = i_initialEquations)) )
      equation
        ret_1 = System.getUUIDStr();
        l_guid = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_3 = Config.simulationCodeTarget();
        l_target = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        l_name = CodegenCpp.lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_5 = CodegenCpp.simulationHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_6 = Tpl.writeText(Tpl.emptyTxt, l_name);
        txt_6 = Tpl.writeTok(txt_6, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_5, Tpl.textString(txt_6));
        txt_7 = CodegenCpp.simulationCppFile(Tpl.emptyTxt, i_simCode);
        txt_8 = Tpl.writeText(Tpl.emptyTxt, l_name);
        txt_8 = Tpl.writeTok(txt_8, Tpl.ST_STRING(".cpp"));
        Tpl.textFile(txt_7, Tpl.textString(txt_8));
        txt_9 = CodegenCpp.simulationFunctionsHeaderFile(Tpl.emptyTxt, i_simCode, i_modelInfo_functions, i_literals);
        Tpl.textFile(txt_9, "Functions.h");
        txt_10 = CodegenCpp.simulationFunctionsFile(Tpl.emptyTxt, i_simCode, i_modelInfo_functions, i_literals);
        Tpl.textFile(txt_10, "Functions.cpp");
        txt_11 = fmuModelWrapperFile(Tpl.emptyTxt, i_simCode, Tpl.textString(l_guid), Tpl.textString(l_name));
        txt_12 = Tpl.writeText(Tpl.emptyTxt, l_name);
        txt_12 = Tpl.writeTok(txt_12, Tpl.ST_STRING("FMU.cpp"));
        Tpl.textFile(txt_11, Tpl.textString(txt_12));
        txt_13 = fmuModelDescriptionFileCpp(Tpl.emptyTxt, i_simCode, Tpl.textString(l_guid));
        Tpl.textFile(txt_13, "modelDescription.xml");
        txt_14 = CodegenFMU.fmudeffile(Tpl.emptyTxt, i_simCode);
        txt_15 = Tpl.writeText(Tpl.emptyTxt, l_name);
        txt_15 = Tpl.writeTok(txt_15, Tpl.ST_STRING(".def"));
        Tpl.textFile(txt_14, Tpl.textString(txt_15));
        txt_16 = fmuMakefile(Tpl.emptyTxt, Tpl.textString(l_target), i_simCode);
        txt_17 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_17 = Tpl.writeTok(txt_17, Tpl.ST_STRING("_FMU.makefile"));
        Tpl.textFile(txt_16, Tpl.textString(txt_17));
        ret_18 = listAppend(i_allEquations, i_initialEquations);
        txt = CodegenCpp.algloopfiles(txt, ret_18, i_simCode);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end translateModel;

public function fmuModelDescriptionFileCpp
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)),
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"));
        txt = fmiModelDescriptionCpp(txt, i_simCode, a_guid);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmuModelDescriptionFileCpp;

public function fmiModelDescriptionCpp
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.ModelInfo i_modelInfo;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(simulationSettingsOpt = i_simulationSettingsOpt, modelInfo = i_modelInfo)),
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fmiModelDescription\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = fmiModelDescriptionAttributesCpp(txt, i_simCode, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = CodegenFMU.DefaultExperiment(txt, i_simulationSettingsOpt);
        txt = Tpl.softNewLine(txt);
        txt = CodegenFMU.ModelVariables(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fmiModelDescription>"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmiModelDescriptionCpp;

public function fmiModelDescriptionAttributesCpp
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.SimCode i_simCode;
      Integer i_vi_numStateVars;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_numberOfEventIndicators;
      Tpl.Text l_numberOfContinuousStates;
      Tpl.Text l_variableNamingConvention;
      Util.DateTime ret_10;
      Tpl.Text l_generationDateAndTime;
      String ret_8;
      Tpl.Text l_generationTool;
      Tpl.Text l_version;
      Tpl.Text l_author;
      Tpl.Text l_description;
      String ret_3;
      Tpl.Text l_modelIdentifier;
      Tpl.Text l_modelName;
      Tpl.Text l_fmiVersion;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_vi_numStateVars), vars = SimCode.SIMVARS(stateVars = _), name = i_modelInfo_name), fileNamePrefix = i_fileNamePrefix)),
           a_guid )
      equation
        l_fmiVersion = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("1.0"));
        l_modelName = CodegenUtil.dotPath(Tpl.emptyTxt, i_modelInfo_name);
        ret_3 = System.stringReplace(i_fileNamePrefix, ".", "_");
        l_modelIdentifier = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        l_description = Tpl.emptyTxt;
        l_author = Tpl.emptyTxt;
        l_version = Tpl.emptyTxt;
        l_generationTool = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OpenModelica Compiler "));
        ret_8 = Settings.getVersionNr();
        l_generationTool = Tpl.writeStr(l_generationTool, ret_8);
        ret_10 = Util.getCurrentDateTime();
        l_generationDateAndTime = CodegenFMU.xsdateTime(Tpl.emptyTxt, ret_10);
        l_variableNamingConvention = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("structured"));
        l_numberOfContinuousStates = Tpl.writeStr(Tpl.emptyTxt, intString(i_vi_numStateVars));
        l_numberOfEventIndicators = CodegenCpp.zerocrosslength(Tpl.emptyTxt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmiVersion=\""));
        txt = Tpl.writeText(txt, l_fmiVersion);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelName=\""
                                }, false));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelIdentifier=\""
                                }, false));
        txt = Tpl.writeText(txt, l_modelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "guid=\"{"
                                }, false));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\"\n",
                                    "generationTool=\""
                                }, false));
        txt = Tpl.writeText(txt, l_generationTool);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "generationDateAndTime=\""
                                }, false));
        txt = Tpl.writeText(txt, l_generationDateAndTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "variableNamingConvention=\""
                                }, false));
        txt = Tpl.writeText(txt, l_variableNamingConvention);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "numberOfContinuousStates=\""
                                }, false));
        txt = Tpl.writeText(txt, l_numberOfContinuousStates);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "numberOfEventIndicators=\""
                                }, false));
        txt = Tpl.writeText(txt, l_numberOfEventIndicators);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmiModelDescriptionAttributesCpp;

protected function fun_38
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;
      String ret_1;
      Tpl.Text l_modelName;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), fileNamePrefix = i_fileNamePrefix)),
           a_guid )
      equation
        l_modelName = CodegenCpp.lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// define class name and unique id\n",
                                    "#define MODEL_IDENTIFIER "
                                }, false));
        ret_1 = System.stringReplace(i_fileNamePrefix, ".", "_");
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define MODEL_GUID \"{"));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\"\n",
                                    "\n",
                                    "#include \"Modelica.h\"\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".h\"\n",
                                    "\n"
                                }, true));
        txt = ModelDefineData(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_EVENT_INDICATORS "));
        txt = CodegenCpp.zerocrosslength(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#include \"FMU/FMUWrapper.cpp\"\n",
                                    "\n",
                                    "#define OBJECTCONSTRUCTOR (new FMUWrapper(instanceName, GUID, functions, loggingOn))\n",
                                    "#include \"FMU/FMULibInterface.cpp\"\n",
                                    "\n",
                                    "#if 0\n"
                                }, true));
        txt = setDefaultStartValues(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setStartValues(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setExternalFunction(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endif\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_38;

public function fmuModelWrapperFile
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;
  input String a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_38(txt, a_simCode, a_guid);
end fmuModelWrapperFile;

protected function lm_40
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = defineExternalFunction(txt, i_fn);
        txt = Tpl.nextIter(txt);
        txt = lm_40(txt, rest);
      then txt;
  end match;
end lm_40;

public function ModelDefineData
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.Function> i_functions;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = _), vars = SimCode.SIMVARS(stateVars = _), functions = i_functions) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* TODO: implement external functions in FMU wrapper for c++ target\n"));
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_40(txt, i_functions);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ModelDefineData;

protected function fun_42
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_42;

protected function fun_43
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_description;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_description, in_a_name)
    local
      Tpl.Text txt;
      Tpl.Text a_description;
      DAE.ComponentRef a_name;
      Integer ret_0;

    case ( txt,
           false,
           a_description,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = CodegenCpp.cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ "));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_description);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_43;

protected function fun_44
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_description;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_description, in_a_name)
    local
      Tpl.Text txt;
      Tpl.Text a_description;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_description,
           a_name )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_43(txt, ret_1, a_description, a_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_44;

public function DefineVariables
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      String i_comment;
      Boolean ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_description;

    case ( txt,
           SimCode.SIMVAR(comment = i_comment, name = i_name) )
      equation
        l_description = fun_42(Tpl.emptyTxt, i_comment);
        txt_1 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_2 = stringEq(Tpl.textString(txt_1), "$dummy");
        txt = fun_44(txt, ret_2, l_description, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end DefineVariables;

public function defineExternalFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      String i_language;
      String i_extName;
      Integer ret_1;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(dynamicLoad = true, extName = i_extName, language = i_language) )
      equation
        l_fname = CodegenCpp.extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define $P"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        ret_1 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_1));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end defineExternalFunction;

protected function lm_47
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initValsDefault(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_47(txt, rest);
      then txt;
  end match;
end lm_47;

protected function lm_48
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = initValsDefault(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_48(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_48;

protected function lm_49
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = initValsDefault(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_49(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initValsDefault(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;
  end match;
end lm_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initValsDefault(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;
  end match;
end lm_51;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initValsDefault(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest);
      then txt;
  end match;
end lm_52;

protected function lm_53
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParamsDefault(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest);
      then txt;
  end match;
end lm_53;

protected function lm_54
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParamsDefault(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_54(txt, rest);
      then txt;
  end match;
end lm_54;

protected function lm_55
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParamsDefault(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_55(txt, rest);
      then txt;
  end match;
end lm_55;

protected function lm_56
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParamsDefault(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest);
      then txt;
  end match;
end lm_56;

public function setDefaultStartValues
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_numStateVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stringAlgVars = i_vars_stringAlgVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Set values for all variables that define a start value\n",
                                    "void setDefaultStartValues(ModelInstance *comp) {\n",
                                    "/*\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_47(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_48(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_49(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_50(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_51(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_52(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_53(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_54(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_55(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_56(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*/\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setDefaultStartValues;

protected function lm_58
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initVals(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_58(txt, rest);
      then txt;
  end match;
end lm_58;

protected function lm_59
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = initVals(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_59(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_59;

protected function lm_60
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = initVals(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_60(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_60;

protected function lm_61
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initVals(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_61(txt, rest);
      then txt;
  end match;
end lm_61;

protected function lm_62
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initVals(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_62(txt, rest);
      then txt;
  end match;
end lm_62;

protected function lm_63
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initVals(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_63(txt, rest);
      then txt;
  end match;
end lm_63;

protected function lm_64
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParams(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_64(txt, rest);
      then txt;
  end match;
end lm_64;

protected function lm_65
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParams(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_65(txt, rest);
      then txt;
  end match;
end lm_65;

protected function lm_66
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParams(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_66(txt, rest);
      then txt;
  end match;
end lm_66;

protected function lm_67
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParams(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_67(txt, rest);
      then txt;
  end match;
end lm_67;

public function setStartValues
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_numStateVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stringAlgVars = i_vars_stringAlgVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Set values for all variables that define a start value\n",
                                    "void setStartValues(ModelInstance *comp) {\n",
                                    "/*\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_58(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_59(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_60(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_61(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_62(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_63(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_64(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_65(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_66(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_67(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*/\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setStartValues;

protected function fun_69
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_str;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("comp->fmuData->modelData."));
        l_str = Tpl.writeStr(l_str, a_arrayName);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("Data["));
        ret_1 = intAdd(a_index, a_offset);
        l_str = Tpl.writeStr(l_str, intString(ret_1));
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("].attribute.start"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" =  comp->fmuData->localData[0]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_2 = intAdd(a_index, a_offset);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_69;

protected function fun_70
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName, in_a_name)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName,
           a_name )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_69(txt, ret_1, a_offset, a_index, a_arrayName);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_70;

public function initVals
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      Integer i_index;
      DAE.ComponentRef i_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.SIMVAR(name = i_name, index = i_index),
           a_arrayName,
           a_offset )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "$dummy");
        txt = fun_70(txt, ret_1, a_offset, i_index, a_arrayName, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end initVals;

public function initParams
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer i_index;
      Tpl.Text l_str;

    case ( txt,
           SimCode.SIMVAR(index = i_index),
           a_arrayName )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("comp->fmuData->modelData."));
        l_str = Tpl.writeStr(l_str, a_arrayName);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("Data["));
        l_str = Tpl.writeStr(l_str, intString(i_index));
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("].attribute.start"));
        txt = Tpl.writeText(txt, l_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = comp->fmuData->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end initParams;

protected function fun_73
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;
  input Tpl.Text in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__, in_a_str)
    local
      Tpl.Text txt;
      Tpl.Text a_str;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = \"\";"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKOWN_TYPE"));
      then txt;
  end match;
end fun_73;

protected function fun_74
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input DAE.Type in_a_type__;
  input Tpl.Text in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_type__, in_a_str)
    local
      Tpl.Text txt;
      DAE.Type a_type__;
      Tpl.Text a_str;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v),
           _,
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = initVal(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           NONE(),
           a_type__,
           a_str )
      equation
        txt = fun_73(txt, a_type__, a_str);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_74;

public function initValsDefault
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      DAE.Type i_type__;
      Option<DAE.Exp> i_initialValue;
      Integer i_index;
      Integer ret_1;
      Tpl.Text l_str;

    case ( txt,
           SimCode.SIMVAR(index = i_index, type_ = i_type__, initialValue = i_initialValue),
           a_arrayName,
           a_offset )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("comp->fmuData->modelData."));
        l_str = Tpl.writeStr(l_str, a_arrayName);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("Data["));
        ret_1 = intAdd(i_index, a_offset);
        l_str = Tpl.writeStr(l_str, intString(ret_1));
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("].attribute.start"));
        txt = fun_74(txt, i_initialValue, i_type__, l_str);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end initValsDefault;

protected function fun_76
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input Tpl.Text in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_str)
    local
      Tpl.Text txt;
      Tpl.Text a_str;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = initVal(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_76;

public function initParamsDefault
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Option<DAE.Exp> i_initialValue;
      Integer i_index;
      Tpl.Text l_str;

    case ( txt,
           SimCode.SIMVAR(index = i_index, initialValue = i_initialValue),
           a_arrayName )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("comp->fmuData->modelData."));
        l_str = Tpl.writeStr(l_str, a_arrayName);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("Data["));
        l_str = Tpl.writeStr(l_str, intString(i_index));
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("].attribute.start"));
        txt = fun_76(txt, i_initialValue, l_str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end initParamsDefault;

protected function fun_78
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_78;

public function initVal
  input Tpl.Text in_txt;
  input DAE.Exp in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      Absyn.Path i_name;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = Util.escapeModelicaStringToXmlString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_78(txt, i_bool);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index, name = i_name) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*ENUM:"));
        txt = CodegenUtil.dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*ERROR* initial value of unknown type"));
      then txt;
  end match;
end initVal;

public function setExternalFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.Function> i_functions;
      Tpl.Text l_externalFuncs;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(stateVars = _), functions = i_functions) )
      equation
        l_externalFuncs = setExternalFunctionsSwitch(Tpl.emptyTxt, i_functions);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiStatus setExternalFunction(ModelInstance* c, const fmiValueReference vr, const void* value){\n",
                                    "  switch (vr) {\n",
                                    "  /*\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_externalFuncs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  */\n",
                                    "      default:\n",
                                    "          return fmiError;\n",
                                    "  }\n",
                                    "  return fmiOK;\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setExternalFunction;

protected function lm_81
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = setExternalFunctionSwitch(txt, i_fn);
        txt = Tpl.nextIter(txt);
        txt = lm_81(txt, rest);
      then txt;
  end match;
end lm_81;

public function setExternalFunctionsSwitch
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_81(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end setExternalFunctionsSwitch;

public function setExternalFunctionSwitch
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      String i_language;
      String i_extName;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(dynamicLoad = true, extName = i_extName, language = i_language) )
      equation
        l_fname = CodegenCpp.extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case $P"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : ptr_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=(ptrT_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")value; break;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setExternalFunctionSwitch;

protected function fun_84
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "OSX" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lf2c"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-Wl,-Bstatic -lf2c -Wl,-Bdynamic"));
      then txt;
  end match;
end fun_84;

protected function fun_85
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "OSX" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lf2c"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-Wl,-Bstatic -lf2c -Wl,-Bdynamic"));
      then txt;
  end match;
end fun_85;

public function getPlatformString2
  input Tpl.Text in_txt;
  input String in_a_platform;
  input String in_a_fileNamePrefix;
  input String in_a_dirExtra;
  input String in_a_libsPos1;
  input String in_a_libsPos2;
  input String in_a_omhome;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_platform, in_a_fileNamePrefix, in_a_dirExtra, in_a_libsPos1, in_a_libsPos2, in_a_omhome)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;
      String a_dirExtra;
      String a_libsPos1;
      String a_libsPos2;
      String a_omhome;
      String i_platform;
      String ret_1;
      String ret_0;

    case ( txt,
           (i_platform as "win32"),
           a_fileNamePrefix,
           a_dirExtra,
           a_libsPos1,
           a_libsPos2,
           a_omhome )
      equation
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU: "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".def "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".dll\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" dlltool -d "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".def --dllname "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".dll --output-lib "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".lib --kill-at\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".dll "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".lib "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp _"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".h "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/_"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".h\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.c "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_FMU.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.c "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_functions.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.h "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_functions.h\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.c "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp modelDescription.xml "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/modelDescription.xml\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/libexec/gnuplot/binary/libexpat-1.dll "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cd "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&& rm -f ../"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".fmu&& zip -r ../"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".fmu *\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" rm -rf "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" rm -f "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".def "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.libs "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.makefile "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_records.o\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".dll: clean "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.o\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CXX) -shared -I. -o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".dll "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o  $(CPPFLAGS) "));
        txt = Tpl.writeStr(txt, a_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CFLAGS) $(LDFLAGS) "));
        ret_0 = System.os();
        txt = fun_84(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " -Wl,--kill-at\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"mkdir.exe\" -p "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"mkdir.exe\" -p "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/binaries\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"mkdir.exe\" -p "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"mkdir.exe\" -p "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources"));
      then txt;

    case ( txt,
           i_platform,
           a_fileNamePrefix,
           a_dirExtra,
           a_libsPos1,
           a_libsPos2,
           _ )
      equation
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU: "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.o\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CXX) -shared -I. -o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o $(CPPFLAGS) "));
        txt = Tpl.writeStr(txt, a_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CFLAGS) $(LDFLAGS) "));
        ret_1 = System.os();
        txt = fun_85(txt, ret_1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" mkdir -p "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" mkdir -p "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/binaries\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" mkdir -p "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" mkdir -p "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/sources\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.libs "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp _"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".h "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/_"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".h\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.c "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_FMU.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.c "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_functions.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.h "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_functions.h\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.c "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/sources/"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cp modelDescription.xml "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/modelDescription.xml\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" cd "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; rm -f ../"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".fmu && zip -r ../"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".fmu *\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" rm -rf "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" rm -f "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".def "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.libs "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.makefile "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_records.o\n",
                                    "\n"
                                }, true));
      then txt;
  end match;
end getPlatformString2;

protected function fun_87
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_87;

protected function lm_88
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_88(txt, rest);
      then txt;
  end match;
end lm_88;

protected function fun_89
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_89;

protected function fun_90
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_90;

protected function fun_91
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lOMOCLRuntime -lOpenCL"));
      then txt;
  end match;
end fun_91;

protected function fun_92
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end match;
end fun_92;

protected function fun_93
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER "));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK "));
      then txt;

    case ( txt,
           "dassljac" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_JACOBIAN "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_93;

protected function fun_94
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_92(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_93(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_94;

protected function fun_95
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end match;
end fun_95;

protected function fun_96
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_allEquations;
      Absyn.Path i_modelInfo_name;
      String i_fileNamePrefix;
      String i_makefileParams_omhome;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      Boolean ret_7;
      Tpl.Text l_extraCflags;
      Boolean ret_5;
      Tpl.Text l_ParModelicaLibs;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory, name = i_modelInfo_name), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, omhome = i_makefileParams_omhome), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix, allEquations = i_allEquations)) )
      equation
        l_dirExtra = fun_87(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_88(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_89(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_90(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        ret_5 = Config.acceptParModelicaGrammar();
        l_ParModelicaLibs = fun_91(Tpl.emptyTxt, ret_5);
        l_extraCflags = fun_94(Tpl.emptyTxt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O3 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=\n",
                                    "MODELICAUSERCFLAGS=\n",
                                    "CXX=cl\n",
                                    "EXEEXT=.exe\n",
                                    "DLLEXT=.dll\n",
                                    "include "
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/include/omc/cpp/ModelicaConfic.inc\n",
                                    "# /Od - Optimization disabled\n",
                                    "# /EHa enable C++ EH (w/ SEH exceptions)\n",
                                    "# /fp:except - consider floating-point exceptions when generating code\n",
                                    "# /arch:SSE2 - enable use of instructions available with SSE2 enabled CPUs\n",
                                    "# /I - Include Directories\n",
                                    "# /DNOMINMAX - Define NOMINMAX (does what it says)\n",
                                    "# /TP - Use C++ Compiler\n",
                                    "CFLAGS=/Od /EHa /MP /fp:except /I\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/include/omc/cpp/\" -I\"$(BOOST_INCLUDE)\" /I. /DNOMINMAX /TP /DNO_INTERACTIVE_DEPENDENCY\n",
                                    "\n",
                                    "# /ZI enable Edit and Continue debug info\n",
                                    "CDFLAGS = /ZI\n",
                                    "\n",
                                    "# /MD - link with MSVCRT.LIB\n",
                                    "# /link - [linker options and libraries]\n",
                                    "# /LIBPATH: - Directories where libs can be found\n",
                                    "LDFLAGS=/MD   /link /DLL /NOENTRY /LIBPATH:\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp/\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/bin\" OMCppSystem.lib OMCppMath.lib OMCppModelicaExternalC.lib\n",
                                    "\n",
                                    "# /MDd link with MSVCRTD.LIB debug lib\n",
                                    "# lib names should not be appended with a d just switch to lib/omc/cpp\n",
                                    "\n",
                                    "\n",
                                    "FILEPREFIX="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "FUNCTIONFILE=Functions.cpp\n",
                                    "MAINFILE="
                                }, false));
        txt = CodegenCpp.lastIdentOfPath(txt, i_modelInfo_name);
        ret_7 = Config.acceptMetaModelicaGrammar();
        txt = fun_95(txt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".cpp\n",
                                    "MAINFILEFMU="
                                }, false));
        txt = CodegenCpp.lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "FMU.cpp\n",
                                    "MAINOBJ=$(MODELICA_SYSTEM_LIB)\n",
                                    "GENERATEDFILES=$(MAINFILEFMU) $(MAINFILE) $(FUNCTIONFILE)  "
                                }, false));
        txt = CodegenCpp.algloopcppfilenames(txt, i_allEquations, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "$(MODELICA_SYSTEM_LIB)$(DLLEXT):\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX) /Fe$(MODELICA_SYSTEM_LIB) $(MAINFILEFMU) $(MAINFILE) $(FUNCTIONFILE)  "));
        txt = CodegenCpp.algloopcppfilenames(txt, i_allEquations, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CFLAGS) $(LDFLAGS)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_96;

protected function fun_97
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end match;
end fun_97;

protected function fun_98
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER"));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_98;

protected function fun_99
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_97(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_98(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_99;

protected function lm_100
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_100(txt, rest);
      then txt;
  end match;
end lm_100;

protected function fun_101
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_cflags;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(cflags = i_s_cflags)) )
      equation
        txt = Tpl.writeStr(txt, i_s_cflags);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_101;

protected function fun_102
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      String i_makefileParams_cflags;
      list<String> i_makefileParams_includes;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      String i_makefileParams_omhome;
      Absyn.Path i_modelInfo_name;
      Option<SimCode.SimulationSettings> i_sopt;
      list<SimCode.SimEqSystem> ret_2;
      Tpl.Text l_modelName;
      Tpl.Text l_extraCflags;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), makefileParams = SimCode.MAKEFILE_PARAMS(omhome = i_makefileParams_omhome, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, includes = i_makefileParams_includes, cflags = i_makefileParams_cflags), simulationSettingsOpt = i_sopt, allEquations = i_allEquations, initialEquations = i_initialEquations)) )
      equation
        l_extraCflags = fun_99(Tpl.emptyTxt, i_sopt);
        l_modelName = CodegenCpp.lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "include "
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/include/omc/cpp/ModelicaConfic.inc\n",
                                    "# Simulations use -O0 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=-O0\n",
                                    "CC="
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS_BASED_ON_INIT_FILE="));
        txt = Tpl.writeText(txt, l_extraCflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "CFLAGS=$(CFLAGS_BASED_ON_INIT_FILE) -I\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp\" -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp/Core\" -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp/SimCoreFactory\" -I\"$(BOOST_INCLUDE)\" "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_100(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_101(txt, i_sopt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS=-L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/lib/omc/cpp\" -L$(BOOST_LIBS)\n",
                                    "\n",
                                    "SRC="
                                }, false));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".cpp\n",
                                    "SRC+= "
                                }, false));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "FMU.cpp\n",
                                    "SRC+= Functions.cpp\n",
                                    "SRC+= "
                                }, false));
        ret_2 = listAppend(i_allEquations, i_initialEquations);
        txt = CodegenCpp.algloopcppfilenames(txt, ret_2, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "LIBS= -lOMCppSystem_static -lOMCppDataExchange_static -lOMCppOMCFactory\n",
                                    "LIBS+= $(BOOST_SYSTEM_LIB) $(BOOST_FILESYSTEM_LIB) $(BOOST_SERIALIZATION_LIB)\n",
                                    "LIBS+= $(LINUX_LIB_DL)\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".fmu: $(SRC)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX) -shared -I. -o "));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("$(DLLEXT) $(SRC) $(CFLAGS) $(LDFLAGS) $(LIBS)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("rm -rf binaries\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("mkdir binaries\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("mkdir \"binaries/$(FMI_ARCH_DIR)\"\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cp "));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("$(DLLEXT) \"binaries/$(FMI_ARCH_DIR)/\"\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rm -f "));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".fmu\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("zip -r \""));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".fmu\" modelDescription.xml binaries binaries/$(FMI_ARCH_DIR) binaries/$(FMI_ARCH_DIR)/"));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("$(DLLEXT)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "rm -rf binaries\n",
                                    "\n",
                                    ".PHONY: clean\n",
                                    "clean:\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rm $(SRC) "));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "$(DLLEXT)\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_102;

public function fmuMakefile
  input Tpl.Text in_txt;
  input String in_a_target;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_target, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;

    case ( txt,
           "msvc",
           a_simCode )
      equation
        txt = fun_96(txt, a_simCode);
      then txt;

    case ( txt,
           "gcc",
           a_simCode )
      equation
        txt = fun_102(txt, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmuMakefile;

end CodegenFMUCpp;