encapsulated package CodegenXML
"
  file:        CodegenXML.mo
  package:     CodegenXML
  description: Generated by Susan.
"

public import Tpl;

public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCode;
public import HpcOmScheduler;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))) )
      equation
        txt_0 = generateXml(Tpl.emptyTxt, i_simCode);
        txt_1 = dotPathXml(Tpl.emptyTxt, i_modelInfo_name);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".xml"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end translateModel;

public function generateXml
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ClassAttributes> i_classAttributes;
      list<SimCode.Function> i_modelInfo_functions;
      list<SimCode.RecordDeclaration> i_recordDecls;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.ModelInfo i_modelInfo;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      SimCode.SimCode i_simCode;
      String ret_1;
      Tpl.Text l_guid;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(functions = i_modelInfo_functions)), simulationSettingsOpt = i_simulationSettingsOpt, allEquations = i_allEquations, whenClauses = i_whenClauses, initialEquations = i_initialEquations, recordDecls = i_recordDecls, classAttributes = i_classAttributes)) )
      equation
        ret_1 = System.getUUIDStr();
        l_guid = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n",
                                    "<OpenModelicaModelDescription\n",
                                    "  xmlns:exp=\"https://svn.jmodelica.org/trunk/XML/daeExpressions.xsd\"\n",
                                    "  xmlns:equ=\"https://svn.jmodelica.org/trunk/XML/daeEquations.xsd\"\n",
                                    "  xmlns:fun=\"https://svn.jmodelica.org/trunk/XML/daeFunctions.xsd\"\n",
                                    "  xmlns:opt=\"https://svn.jmodelica.org/trunk/XML/daeOptimization.xsd\"\n",
                                    "  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = modelDescriptionXml(txt, i_simCode, Tpl.textString(l_guid));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "\n"
                                }, true));
        txt = vendorAnnotationsXml(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = defaultExperiment(txt, i_simulationSettingsOpt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = modelVariablesXml(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = bindingEquationsXml(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = equationsXml(txt, i_allEquations, i_whenClauses);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = initialEquationsXml(txt, i_initialEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = algorithmicEquationsXml(txt, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = recordsXml(txt, i_recordDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionsXml(txt, i_modelInfo_functions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = objectiveFunctionXml(txt, i_classAttributes, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</OpenModelicaModelDescription>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end generateXml;

public function vendorAnnotationsXml
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String ret_1;
      Tpl.Text l_generationTool;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = _))) )
      equation
        l_generationTool = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OpenModelica Compiler "));
        ret_1 = Settings.getVersionNr();
        l_generationTool = Tpl.writeStr(l_generationTool, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<VendorAnnotations>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Tool name=\""));
        txt = Tpl.writeText(txt, l_generationTool);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"> </Tool>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</VendorAnnotations>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end vendorAnnotationsXml;

public function modelDescriptionXml
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      Integer i_modelInfo_varInfo_numZeroCrossings;
      Integer i_modelInfo_varInfo_numStateVars;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_numberOfEventIndicators;
      Tpl.Text l_numberOfContinuousStates;
      Tpl.Text l_variableNamingConvention;
      Util.DateTime ret_8;
      Tpl.Text l_generationDateAndTime;
      Tpl.Text l_version;
      Tpl.Text l_author;
      Tpl.Text l_description;
      String ret_3;
      Tpl.Text l_modelIdentifier;
      Tpl.Text l_modelName;
      Tpl.Text l_fmiVersion;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_modelInfo_varInfo_numStateVars, numZeroCrossings = i_modelInfo_varInfo_numZeroCrossings), name = i_modelInfo_name), fileNamePrefix = i_fileNamePrefix),
           a_guid )
      equation
        l_fmiVersion = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("1.0"));
        l_modelName = dotPathXml(Tpl.emptyTxt, i_modelInfo_name);
        ret_3 = System.stringReplace(i_fileNamePrefix, ".", "_");
        l_modelIdentifier = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        l_description = Tpl.emptyTxt;
        l_author = Tpl.emptyTxt;
        l_version = Tpl.emptyTxt;
        ret_8 = Util.getCurrentDateTime();
        l_generationDateAndTime = xsdateTimeXml(Tpl.emptyTxt, ret_8);
        l_variableNamingConvention = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Structured"));
        l_numberOfContinuousStates = Tpl.writeStr(Tpl.emptyTxt, intString(i_modelInfo_varInfo_numStateVars));
        l_numberOfEventIndicators = Tpl.writeStr(Tpl.emptyTxt, intString(i_modelInfo_varInfo_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmiVersion=\""));
        txt = Tpl.writeText(txt, l_fmiVersion);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelName=\""
                                }, false));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelIdentifier=\""
                                }, false));
        txt = Tpl.writeText(txt, l_modelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "guid=\"{"
                                }, false));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\"\n",
                                    "generationDateAndTime=\""
                                }, false));
        txt = Tpl.writeText(txt, l_generationDateAndTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "variableNamingConvention=\""
                                }, false));
        txt = Tpl.writeText(txt, l_variableNamingConvention);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "numberOfContinuousStates=\""
                                }, false));
        txt = Tpl.writeText(txt, l_numberOfContinuousStates);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "numberOfEventIndicators=\""
                                }, false));
        txt = Tpl.writeText(txt, l_numberOfEventIndicators);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end modelDescriptionXml;

public function xsdateTimeXml
  input Tpl.Text in_txt;
  input Util.DateTime in_a_dt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dt)
    local
      Tpl.Text txt;
      Integer i_sec;
      Integer i_min;
      Integer i_hour;
      Integer i_mday;
      Integer i_mon;
      Integer i_year;
      String ret_4;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           Util.DATETIME(year = i_year, mon = i_mon, mday = i_mday, hour = i_hour, min = i_min, sec = i_sec) )
      equation
        txt = Tpl.writeStr(txt, intString(i_year));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_0 = SimCodeUtil.twodigit(i_mon);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_1 = SimCodeUtil.twodigit(i_mday);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("T"));
        ret_2 = SimCodeUtil.twodigit(i_hour);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_3 = SimCodeUtil.twodigit(i_min);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_4 = SimCodeUtil.twodigit(i_sec);
        txt = Tpl.writeStr(txt, ret_4);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end xsdateTimeXml;

public function defaultExperiment
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simulationSettingsOpt)
    local
      Tpl.Text txt;
      Real i_de_tolerance;
      Real i_de_stopTime;
      Real i_de_startTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(startTime = i_de_startTime, stopTime = i_de_stopTime, tolerance = i_de_tolerance)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defaultExperiment startTime=\""));
        txt = Tpl.writeStr(txt, realString(i_de_startTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" stopTime=\""));
        txt = Tpl.writeStr(txt, realString(i_de_stopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" tolerance=\""));
        txt = Tpl.writeStr(txt, realString(i_de_tolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end defaultExperiment;

protected function lm_37
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_37(txt, rest);
      then txt;
  end match;
end lm_37;

protected function lm_38
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_38(txt, rest);
      then txt;
  end match;
end lm_38;

protected function lm_39
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_39(txt, rest);
      then txt;
  end match;
end lm_39;

protected function lm_40
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_40(txt, rest);
      then txt;
  end match;
end lm_40;

protected function lm_41
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_41(txt, rest);
      then txt;
  end match;
end lm_41;

protected function lm_42
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_42(txt, rest);
      then txt;
  end match;
end lm_42;

protected function lm_43
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_43(txt, rest);
      then txt;
  end match;
end lm_43;

protected function lm_44
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_44(txt, rest);
      then txt;
  end match;
end lm_44;

protected function lm_45
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_45(txt, rest);
      then txt;
  end match;
end lm_45;

protected function lm_46
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_46(txt, rest);
      then txt;
  end match;
end lm_46;

protected function lm_47
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_47(txt, rest);
      then txt;
  end match;
end lm_47;

protected function lm_48
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_48(txt, rest);
      then txt;
  end match;
end lm_48;

protected function lm_49
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_49(txt, rest);
      then txt;
  end match;
end lm_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;
  end match;
end lm_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;
  end match;
end lm_51;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest);
      then txt;
  end match;
end lm_52;

protected function lm_53
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest);
      then txt;
  end match;
end lm_53;

protected function lm_54
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_54(txt, rest);
      then txt;
  end match;
end lm_54;

protected function lm_55
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_55(txt, rest);
      then txt;
  end match;
end lm_55;

protected function lm_56
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = ScalarVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest);
      then txt;
  end match;
end lm_56;

public function modelVariablesXml
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringConstVars;
      list<SimCode.SimVar> i_vars_boolConstVars;
      list<SimCode.SimVar> i_vars_intConstVars;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_extObjVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_outputVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, outputVars = i_vars_outputVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, extObjVars = i_vars_extObjVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<ModelVariables>\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_37(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_38(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_39(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_40(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_41(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_42(txt, i_vars_outputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_43(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_44(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_45(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_46(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_47(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_48(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_49(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_50(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_51(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_52(txt, i_vars_extObjVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_53(txt, i_vars_constVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_54(txt, i_vars_intConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_55(txt, i_vars_boolConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_56(txt, i_vars_stringConstVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</ModelVariables>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end modelVariablesXml;

protected function fun_58
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simVar)
    local
      Tpl.Text txt;
      SimCode.SimVar a_simVar;

    case ( txt,
           false,
           a_simVar )
      equation
        txt = ScalarVariableAttributesXml(txt, a_simVar);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_58;

protected function fun_59
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimVar in_a_simVar;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simVar, in_a_name)
    local
      Tpl.Text txt;
      SimCode.SimVar a_simVar;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_simVar,
           a_name )
      equation
        txt_0 = crefStrXml(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_58(txt, ret_1, a_simVar);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_59;

public function ScalarVariableXml
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      SimCode.SimVar i_simVar;
      DAE.ComponentRef i_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simVar as SimCode.SIMVAR(name = i_name)) )
      equation
        txt_0 = crefStrXml(Tpl.emptyTxt, i_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "$dummy");
        txt = fun_59(txt, ret_1, i_simVar, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableXml;

protected function fun_61
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;
      String ret_0;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("description=\""));
        ret_0 = Util.escapeModelicaStringToXmlString(i_comment);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_61;

public function ScalarVariableAttributesXml
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      Boolean i_isFixed;
      Option<DAE.Exp> i_initialValue;
      Option<DAE.Exp> i_maxValue;
      Option<DAE.Exp> i_minValue;
      String i_displayUnit;
      String i_unit;
      DAE.Type i_type__;
      DAE.ComponentRef i_name;
      SimCode.Causality i_causality;
      SimCode.AliasVariable i_aliasvar;
      String i_comment;
      BackendDAE.VarKind i_varKind;
      Tpl.Text l_variableCategory;
      Tpl.Text l_caus;
      Tpl.Text l_alias;
      Tpl.Text l_description;
      Tpl.Text l_variability;
      Integer ret_1;
      Tpl.Text l_valueReference;

    case ( txt,
           SimCode.SIMVAR(varKind = i_varKind, comment = i_comment, aliasvar = i_aliasvar, causality = i_causality, name = i_name, type_ = i_type__, unit = i_unit, displayUnit = i_displayUnit, minValue = i_minValue, maxValue = i_maxValue, initialValue = i_initialValue, isFixed = i_isFixed) )
      equation
        ret_1 = System.tmpTick();
        l_valueReference = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        l_variability = getVariablityXml(Tpl.emptyTxt, i_varKind);
        l_description = fun_61(Tpl.emptyTxt, i_comment);
        l_alias = getAliasVarXml(Tpl.emptyTxt, i_aliasvar);
        l_caus = getCausalityXml(Tpl.emptyTxt, i_causality);
        l_variableCategory = variableCategoryXml(Tpl.emptyTxt, i_varKind);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<ScalarVariable name=\""));
        txt = crefStrXml(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.writeText(txt, l_description);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" valueReference=\""));
        txt = Tpl.writeText(txt, l_valueReference);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" variability=\""));
        txt = Tpl.writeText(txt, l_variability);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" causality=\""));
        txt = Tpl.writeText(txt, l_caus);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" alias=\""));
        txt = Tpl.writeText(txt, l_alias);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = ScalarVariableTypeXml(txt, i_type__, i_unit, i_displayUnit, i_minValue, i_maxValue, i_initialValue, i_isFixed);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<QualifiedName>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = qualifiedNamePartXml(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</QualifiedName>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<isLinearTimedVariables>\n",
                                    "  <TimePoint index=\"0\" isLinear=\"true\"/>\n",
                                    "</isLinearTimedVariables>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<VariableCategory>"));
        txt = Tpl.writeText(txt, l_variableCategory);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</VariableCategory>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</ScalarVariable> "));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableAttributesXml;

public function getCausalityXml
  input Tpl.Text in_txt;
  input SimCode.Causality in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_c)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.NONECAUS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("none"));
      then txt;

    case ( txt,
           SimCode.INTERNAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("internal"));
      then txt;

    case ( txt,
           SimCode.OUTPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output"));
      then txt;

    case ( txt,
           SimCode.INPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("input"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getCausalityXml;

public function getVariablityXml
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varKind)
    local
      Tpl.Text txt;

    case ( txt,
           BackendDAE.DISCRETE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("discrete"));
      then txt;

    case ( txt,
           BackendDAE.PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parameter"));
      then txt;

    case ( txt,
           BackendDAE.CONST() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("continuous"));
      then txt;
  end match;
end getVariablityXml;

public function getAliasVarXml
  input Tpl.Text in_txt;
  input SimCode.AliasVariable in_a_aliasvar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_aliasvar)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.NOALIAS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("noAlias"));
      then txt;

    case ( txt,
           SimCode.ALIAS(varName = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("alias"));
      then txt;

    case ( txt,
           SimCode.NEGATEDALIAS(varName = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("negatedAlias"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("noAlias"));
      then txt;
  end match;
end getAliasVarXml;

public function variableCategoryXml
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varKind)
    local
      Tpl.Text txt;

    case ( txt,
           BackendDAE.VARIABLE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("algebraic"));
      then txt;

    case ( txt,
           BackendDAE.STATE(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("state"));
      then txt;

    case ( txt,
           BackendDAE.STATE_DER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("derivative"));
      then txt;

    case ( txt,
           BackendDAE.DUMMY_DER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("algebraic"));
      then txt;

    case ( txt,
           BackendDAE.DUMMY_STATE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("algebraic"));
      then txt;

    case ( txt,
           BackendDAE.DISCRETE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("algebraic"));
      then txt;

    case ( txt,
           BackendDAE.PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("independentParameter"));
      then txt;

    case ( txt,
           BackendDAE.CONST() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("independentConstant"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 243, 14), "Unexpected simVarTypeName varKind");
      then txt;
  end match;
end variableCategoryXml;

public function ScalarVariableTypeXml
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;
  input String in_a_unit;
  input String in_a_displayUnit;
  input Option<DAE.Exp> in_a_minValue;
  input Option<DAE.Exp> in_a_maxValue;
  input Option<DAE.Exp> in_a_initialValue;
  input Boolean in_a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__, in_a_unit, in_a_displayUnit, in_a_minValue, in_a_maxValue, in_a_initialValue, in_a_isFixed)
    local
      Tpl.Text txt;
      String a_unit;
      String a_displayUnit;
      Option<DAE.Exp> a_minValue;
      Option<DAE.Exp> a_maxValue;
      Option<DAE.Exp> a_initialValue;
      Boolean a_isFixed;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           _,
           _,
           a_minValue,
           a_maxValue,
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Integer "));
        txt = ScalarVariableTypeCommonAttributeXml(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = ScalarVariableTypeMinAttribute(txt, a_minValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = ScalarVariableTypeMaxAttribute(txt, a_maxValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_unit,
           a_displayUnit,
           a_minValue,
           a_maxValue,
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Real "));
        txt = ScalarVariableTypeCommonAttributeXml(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = ScalarVariableTypeMinAttribute(txt, a_minValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = ScalarVariableTypeMaxAttribute(txt, a_maxValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = ScalarVariableTypeRealAttributeXml(txt, a_unit, a_displayUnit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           _,
           _,
           _,
           _,
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Boolean "));
        txt = ScalarVariableTypeCommonAttributeXml(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _,
           _,
           _,
           _,
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<String "));
        txt = ScalarVariableTypeCommonAttributeXml(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           _,
           _,
           _,
           _,
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Real "));
        txt = ScalarVariableTypeCommonAttributeXml(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKOWN_TYPE"));
      then txt;
  end match;
end ScalarVariableTypeXml;

public function ScalarVariableTypeCommonAttributeXml
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input Boolean in_a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_isFixed)
    local
      Tpl.Text txt;
      Boolean a_isFixed;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp),
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" fixed=\""));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_isFixed));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end ScalarVariableTypeCommonAttributeXml;

public function ScalarVariableTypeMinAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_minValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_minValue)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("min=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableTypeMinAttribute;

public function ScalarVariableTypeMaxAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_maxValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_maxValue)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("max=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableTypeMaxAttribute;

protected function fun_71
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_71;

public function initValXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      Absyn.Path i_name;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = Util.escapeModelicaStringToXmlString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_71(txt, i_bool);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index, name = i_name) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*ENUM:"));
        txt = dotPathXml(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*ERROR* initial value of unknown type"));
      then txt;
  end match;
end initValXml;

protected function fun_73
  input Tpl.Text in_txt;
  input String in_a_unit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_unit)
    local
      Tpl.Text txt;
      String i_unit;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_unit )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unit=\""));
        txt = Tpl.writeStr(txt, i_unit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_73;

protected function fun_74
  input Tpl.Text in_txt;
  input String in_a_displayUnit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_displayUnit)
    local
      Tpl.Text txt;
      String i_displayUnit;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_displayUnit )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("displayUnit=\""));
        txt = Tpl.writeStr(txt, i_displayUnit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_74;

public function ScalarVariableTypeRealAttributeXml
  input Tpl.Text txt;
  input String a_unit;
  input String a_displayUnit;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_displayUnit__;
  Tpl.Text l_unit__;
algorithm
  l_unit__ := fun_73(Tpl.emptyTxt, a_unit);
  l_displayUnit__ := fun_74(Tpl.emptyTxt, a_displayUnit);
  out_txt := Tpl.writeText(txt, l_unit__);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" "));
  out_txt := Tpl.writeText(out_txt, l_displayUnit__);
end ScalarVariableTypeRealAttributeXml;

protected function fun_76
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt_0 = crefStrXml(Tpl.emptyTxt, a_cr);
        ret_1 = System.unquoteIdentifier(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = crefXml(txt, a_cr);
      then txt;
  end match;
end fun_76;

public function contextCrefXml
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_76(txt, a_context, a_cr);
end contextCrefXml;

protected function fun_78
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Absyn.Ident in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Ident a_name;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;
  end match;
end fun_78;

public function contextIteratorNameXml
  input Tpl.Text txt;
  input Absyn.Ident a_name;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_78(txt, a_context, a_name);
end contextIteratorNameXml;

public function crefXml
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = crefStrXml(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:Time>time</exp:Time>"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = crefToXmlStr(txt, i_cr);
      then txt;
  end match;
end crefXml;

protected function fun_81
  input Tpl.Text in_txt;
  input Tpl.Text in_a_arrayTest;
  input list<DAE.Subscript> in_a_subscriptLst;
  input DAE.Ident in_a_ident;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arrayTest, in_a_subscriptLst, in_a_ident)
    local
      Tpl.Text txt;
      list<DAE.Subscript> a_subscriptLst;
      DAE.Ident a_ident;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           a_ident )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = Tpl.writeStr(txt, a_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
      then txt;

    case ( txt,
           _,
           a_subscriptLst,
           a_ident )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = Tpl.writeStr(txt, a_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = arraysubscriptsStrXml(txt, a_subscriptLst);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:QualifiedNamePart>"));
      then txt;
  end match;
end fun_81;

protected function fun_82
  input Tpl.Text in_txt;
  input Tpl.Text in_a_arrayTest;
  input list<DAE.Subscript> in_a_subscriptLst;
  input DAE.ComponentRef in_a_componentRef;
  input DAE.Ident in_a_ident;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arrayTest, in_a_subscriptLst, in_a_componentRef, in_a_ident)
    local
      Tpl.Text txt;
      list<DAE.Subscript> a_subscriptLst;
      DAE.ComponentRef a_componentRef;
      DAE.Ident a_ident;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           a_componentRef,
           a_ident )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = Tpl.writeStr(txt, a_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = qualifiedNamePartXml(txt, a_componentRef);
      then txt;

    case ( txt,
           _,
           a_subscriptLst,
           a_componentRef,
           a_ident )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = Tpl.writeStr(txt, a_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = arraysubscriptsStrXml(txt, a_subscriptLst);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = qualifiedNamePartXml(txt, a_componentRef);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:QualifiedNamePart>"));
      then txt;
  end match;
end fun_82;

public function qualifiedNamePartXml
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      list<DAE.Subscript> i_subscriptLst;
      Tpl.Text l_arrayTest;

    case ( txt,
           DAE.CREF_IDENT(subscriptLst = i_subscriptLst, ident = i_ident) )
      equation
        l_arrayTest = arraysubscriptsStrXml(Tpl.emptyTxt, i_subscriptLst);
        txt = fun_81(txt, l_arrayTest, i_subscriptLst, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef) )
      equation
        txt = qualifiedNamePartXml(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(subscriptLst = i_subscriptLst, ident = i_ident, componentRef = i_componentRef) )
      equation
        l_arrayTest = arraysubscriptsStrXml(Tpl.emptyTxt, i_subscriptLst);
        txt = fun_82(txt, l_arrayTest, i_subscriptLst, i_componentRef, i_ident);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end qualifiedNamePartXml;

protected function lm_84
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = arraysubscriptStrXml(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_84(txt, rest);
      then txt;
  end match;
end lm_84;

public function arraysubscriptsStrXml
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:ArraySubscripts>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_84(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:ArraySubscripts>"));
      then txt;
  end match;
end arraysubscriptsStrXml;

public function arraysubscriptStrXml
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:IndexExpression>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:IntegerLiteral>"));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</exp:IntegerLiteral>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:IndexExpression>"));
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:IndexExpression>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:IntegerLiteral>"));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</exp:IntegerLiteral>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:IndexExpression>"));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end match;
end arraysubscriptStrXml;

public function crefToXmlStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      String i_instant;
      DAE.ComponentRef i_componentRef;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Identifier>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = qualifiedNamePartXml(txt, i_cr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Identifier>"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Der>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = crefToXmlStr(txt, i_componentRef);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Der>"));
      then txt;

    case ( txt,
           (i_cr as DAE.CREF_QUAL(ident = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Identifier>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = qualifiedNamePartXml(txt, i_cr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Identifier>"));
      then txt;

    case ( txt,
           DAE.OPTIMICA_ATTR_INST_CREF(componentRef = i_componentRef, instant = i_instant) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:TimedVariable timePointIndex = \"0\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = crefToXmlStr(txt, i_componentRef);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:Instant>"));
        txt = Tpl.writeStr(txt, i_instant);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</exp:Instant>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:TimedVariable>"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefToXmlStr;

public function crefStrXml
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStrXml(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der("));
        txt = crefStrXml(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStrXml(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStrXml(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefStrXml;

protected function fun_89
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = arrayCrefStrXml(txt, a_cr);
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = arrayCrefXmlStr(txt, a_cr);
      then txt;
  end match;
end fun_89;

public function contextArrayCrefXml
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_89(txt, a_context, a_cr);
end contextArrayCrefXml;

public function arrayCrefXmlStr
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := arrayCrefXmlStr2(txt, a_cr);
end arrayCrefXmlStr;

public function arrayCrefXmlStr2
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:QualifiedName>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsStrXml(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = arrayCrefXmlStr2(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("testing array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end arrayCrefXmlStr2;

public function arrayCrefStrXml
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Identifier>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamepart name =\""));
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Identifier>"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = arrayCrefStrXml(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end arrayCrefStrXml;

protected function lm_94
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptStrXml(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_94(txt, rest);
      then txt;
  end match;
end lm_94;

public function subscriptsStrXml
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_94(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end subscriptsStrXml;

public function subscriptStrXml
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end match;
end subscriptStrXml;

public function expCrefXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ecr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_arg_componentRef;
      DAE.ComponentRef i_componentRef;

    case ( txt,
           DAE.CREF(componentRef = i_componentRef) )
      equation
        txt = crefXml(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Der>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = crefXml(txt, i_arg_componentRef);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Der>"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ERROR_NOT_A_CREF"));
      then txt;
  end match;
end expCrefXml;

public function crefFunctionNameXml
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        ret_1 = System.stringReplace(ret_0, "_", "__");
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        ret_2 = System.unquoteIdentifier(i_ident);
        ret_3 = System.stringReplace(ret_2, "_", "__");
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefFunctionNameXml(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end crefFunctionNameXml;

public function dotPathXml
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dotPathXml(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = dotPathXml(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dotPathXml;

public function replaceDotAndUnderscoreXml
  input Tpl.Text in_txt;
  input String in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_str)
    local
      Tpl.Text txt;
      String i_name;
      String ret_4;
      String ret_3;
      Tpl.Text l_str__underscores;
      String ret_1;
      Tpl.Text l_str__dots;

    case ( txt,
           i_name )
      equation
        ret_1 = System.stringReplace(i_name, ".", "_");
        l_str__dots = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_3 = System.stringReplace(Tpl.textString(l_str__dots), "_", "__");
        l_str__underscores = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        ret_4 = System.unquoteIdentifier(Tpl.textString(l_str__underscores));
        txt = Tpl.writeStr(txt, ret_4);
      then txt;
  end match;
end replaceDotAndUnderscoreXml;

public function underscorePathXml
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = underscorePathXml(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = Tpl.writeStr(txt, i_name_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = underscorePathXml(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end underscorePathXml;

public function functionWhenReinitStatementXml
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_reinit, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Absyn.Info i_info;
      DAE.Exp i_condition;
      DAE.Exp i_message;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_msgVar;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Reinit>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = crefXml(txt, i_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Reinit>"));
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.TERMINATE(message = i_message),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_message, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_msgVar);
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ASSERT(source = DAE.SOURCE(info = i_info), condition = i_condition, message = i_message),
           a_varDecls )
      equation
        (txt, a_varDecls) = assertCommonXml(txt, i_condition, i_message, SimCode.contextSimulationDiscrete, a_varDecls, i_info);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end functionWhenReinitStatementXml;

protected function lm_103
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Tpl.Text in_a_helpInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
algorithm
  (out_txt, out_a_helpInits) :=
  match(in_txt, in_items, in_a_helpInits)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Tpl.Text a_helpInits;
      DAE.ComponentRef i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits )
      then (txt, a_helpInits);

    case ( txt,
           i_e :: rest,
           a_helpInits )
      equation
        l_helpInit = crefToXmlStr(Tpl.emptyTxt, i_e);
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits) = lm_103(txt, rest, a_helpInits);
      then (txt, a_helpInits);
  end match;
end lm_103;

protected function fun_104
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_helpInits;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_preExp, in_a_helpInits)
    local
      Tpl.Text txt;
      Tpl.Text a_helpInits;
      Tpl.Text i_preExp;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_helpInits )
      equation
        txt = Tpl.writeText(txt, a_helpInits);
      then txt;

    case ( txt,
           i_preExp,
           _ )
      equation
        txt = Tpl.writeText(txt, i_preExp);
      then txt;
  end match;
end fun_104;

protected function fun_105
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_a_reinits;
  input Tpl.Text in_a_ifthen;
  input Tpl.Text in_a_cond;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_reinits, in_a_ifthen, in_a_cond)
    local
      Tpl.Text txt;
      Tpl.Text a_ifthen;
      Tpl.Text a_cond;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_ifthen,
           a_cond )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<equ:When>\n",
                                    "  <equ:Condition>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_cond);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </equ:Condition>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_ifthen);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equ:When>"));
      then txt;
  end match;
end fun_105;

protected function fun_106
  input Tpl.Text in_txt;
  input SimCode.SimWhenClause in_a_whenClauses;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_whenClauses, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<BackendDAE.WhenOperator> i_reinits;
      list<DAE.ComponentRef> i_conditions;
      Tpl.Text l_cond;
      Tpl.Text l_ifthen;
      Tpl.Text l_helpIf;
      Tpl.Text l_helpInits;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(conditions = i_conditions, reinits = i_reinits),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, l_helpInits) = lm_103(l_helpIf, i_conditions, l_helpInits);
        l_helpIf = Tpl.popIter(l_helpIf);
        (l_ifthen, a_varDecls) = functionWhenReinitStatementThenXml(Tpl.emptyTxt, i_reinits, a_varDecls);
        l_cond = fun_104(Tpl.emptyTxt, l_preExp, l_helpInits);
        txt = fun_105(txt, i_reinits, l_ifthen, l_cond);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_106;

public function genreinitsXml
  input Tpl.Text txt;
  input SimCode.SimWhenClause a_whenClauses;
  input Tpl.Text a_varDecls;
  input Integer a_int;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_106(txt, a_whenClauses, a_varDecls);
end genreinitsXml;

protected function fun_108
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_reinit, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Absyn.Info i_info;
      DAE.Exp i_condition;
      DAE.Exp i_message;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_msgVar;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Reinit>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = crefXml(txt, i_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Reinit>"));
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.TERMINATE(message = i_message),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_message, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_msgVar);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ASSERT(source = DAE.SOURCE(info = i_info), condition = i_condition, message = i_message),
           a_varDecls )
      equation
        (txt, a_varDecls) = assertCommonXml(txt, i_condition, i_message, SimCode.contextSimulationDiscrete, a_varDecls, i_info);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_108;

protected function lm_109
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.WhenOperator> rest;
      Tpl.Text a_varDecls;
      BackendDAE.WhenOperator i_reinit;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_reinit :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_108(txt, i_reinit, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_109(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_109;

public function functionWhenReinitStatementThenXml
  input Tpl.Text txt;
  input list<BackendDAE.WhenOperator> a_reinits;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_body;
algorithm
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, out_a_varDecls) := lm_109(l_body, a_reinits, a_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.writeText(txt, l_body);
end functionWhenReinitStatementThenXml;

protected function lm_111
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = bindingEquationXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_111(txt, rest);
      then txt;
  end match;
end lm_111;

protected function lm_112
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = bindingEquationXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_112(txt, rest);
      then txt;
  end match;
end lm_112;

protected function lm_113
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = bindingEquationXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_113(txt, rest);
      then txt;
  end match;
end lm_113;

protected function lm_114
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = bindingEquationXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_114(txt, rest);
      then txt;
  end match;
end lm_114;

public function bindingEquationsXml
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = _), vars = SimCode.SIMVARS(paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<equ:BindingEquations>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_111(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_112(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_113(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_114(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equ:BindingEquations>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end bindingEquationsXml;

protected function fun_116
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      DAE.Exp i_exp;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;

    case ( txt,
           SOME(i_exp),
           a_varName )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<equ:BindingEquation>\n",
                                    "  <equ:Parameter>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </equ:Parameter>\n",
                                    "  <equ:BindingExp>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        (txt, l_preExp, l_varDecls) = daeExpXml(txt, i_exp, SimCode.contextOther, l_preExp, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </equ:BindingExp>\n",
                                    "</equ:BindingEquation>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_116;

public function bindingEquationXml
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      Option<DAE.Exp> i_initialValue;
      DAE.ComponentRef i_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.SIMVAR(name = i_name, initialValue = i_initialValue) )
      equation
        l_varName = qualifiedNamePartXml(Tpl.emptyTxt, i_name);
        txt = fun_116(txt, i_initialValue, l_varName);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end bindingEquationXml;

protected function lm_118
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_Xml(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_118(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_118;

protected function lm_119
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      SimCode.SimWhenClause i_when;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_when :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = genreinitsXml(txt, i_when, a_varDecls, x_i0);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_119(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_119;

public function equationsXml
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<SimCode.SimWhenClause> a_whenClauses;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_reinit;
  Tpl.Text l_eqs;
  Tpl.Text l_tmp;
  Tpl.Text l_jens;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  System.tmpTickReset(0);
  l_jens := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqs, l_tmp, l_varDecls) := lm_118(l_eqs, a_allEquationsPlusWhen, l_tmp, l_varDecls);
  l_eqs := Tpl.popIter(l_eqs);
  l_reinit := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_reinit, l_varDecls) := lm_119(l_reinit, a_whenClauses, l_varDecls);
  l_reinit := Tpl.popIter(l_reinit);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("<equ:DynamicEquations>\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_eqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_reinit);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("</equ:DynamicEquations>"));
end equationsXml;

protected function lm_121
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationAlgorithmXml(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_121(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_121;

public function algorithmicEquationsXml
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algs;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algs, l_varDecls) := lm_121(l_algs, a_allEquations, l_varDecls);
  l_algs := Tpl.popIter(l_algs);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Algorithm>\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_algs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("</fun:Algorithm>"));
end algorithmicEquationsXml;

protected function lm_123
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatementXml(txt, i_stmt, SimCode.contextFunction, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_123(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_123;

protected function fun_124
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_statements;
      Tpl.Text l_alg;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = i_statements),
           a_varDecls )
      equation
        l_alg = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_alg, a_varDecls) = lm_123(l_alg, i_statements, a_varDecls);
        l_alg = Tpl.popIter(l_alg);
        txt = Tpl.writeText(txt, l_alg);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_124;

public function equationAlgorithmXml
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_124(txt, a_eq, a_varDecls);
end equationAlgorithmXml;

protected function lm_126
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_Xml(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_126(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_126;

public function initialEquationsXml
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initalEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_initialEqn;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_initialEqn := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_initialEqn, l_tmp, l_varDecls) := lm_126(l_initialEqn, a_initalEquations, l_tmp, l_varDecls);
  l_initialEqn := Tpl.popIter(l_initialEqn);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("<equ:InitialEquations>\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(1));
  out_txt := Tpl.writeText(out_txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("</equ:InitialEquations>"));
end initialEquationsXml;

protected function fun_128
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varD;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varD;
algorithm
  (out_txt, out_a_varD) :=
  match(in_txt, in_a_eq, in_a_varD, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varD;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_e;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(index = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationSimpleAssignXml(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(index = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationArrayCallAssignXml(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           SimCode.SES_LINEAR(index = _),
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varD);

    case ( txt,
           SimCode.SES_NONLINEAR(index = _),
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varD);

    case ( txt,
           SimCode.SES_WHEN(index = _),
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varD);

    case ( txt,
           _,
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION"));
      then (txt, a_varD);
  end match;
end fun_128;

protected function fun_129
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_eqs;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqs;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqs, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_eqs, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_eqs;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_eq;
      SimCode.SimEqSystem i_e;
      Tpl.Text l_x;
      Tpl.Text l_varD;
      Tpl.Text l_tmp;
      Integer ret_1;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_MIXED(index = _),
           a_eqs,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_eqs, a_varDecls);

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           a_eqs,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_eqs, a_varDecls);

    case ( txt,
           SimCode.SES_ALGORITHM(index = _),
           a_eqs,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_eqs, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_WHEN(index = _)),
           a_eqs,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = equationWhenXml(txt, i_e, a_context, a_varDecls);
      then (txt, a_eqs, a_varDecls);

    case ( txt,
           i_eq,
           a_eqs,
           a_varDecls,
           a_context )
      equation
        ret_1 = System.tmpTickIndex(10);
        l_ix = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        l_tmp = Tpl.emptyTxt;
        l_varD = Tpl.emptyTxt;
        (l_x, l_varD) = fun_128(Tpl.emptyTxt, i_eq, l_varD, a_context);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING_LIST({
                                        "<equ:Equation>\n",
                                        "  <exp:Sub>\n"
                                    }, true));
        a_eqs = Tpl.pushBlock(a_eqs, Tpl.BT_INDENT(4));
        a_eqs = Tpl.writeText(a_eqs, l_x);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.popBlock(a_eqs);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING_LIST({
                                        "  </exp:Sub>\n",
                                        "</equ:Equation>  "
                                    }, false));
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_NEW_LINE());
      then (txt, a_eqs, a_varDecls);
  end match;
end fun_129;

protected function fun_130
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_eqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) :=
  match(in_txt, in_a_context, in_a_eq, in_a_varDecls, in_a_eqs)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      Tpl.Text a_varDecls;
      Tpl.Text a_eqs;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.INLINE_CONTEXT()),
           a_eq,
           a_varDecls,
           a_eqs )
      equation
        (txt, a_varDecls) = old_equation_Xml(txt, a_eq, i_context, a_varDecls);
      then (txt, a_varDecls, a_eqs);

    case ( txt,
           i_context,
           a_eq,
           a_varDecls,
           a_eqs )
      equation
        (txt, a_eqs, a_varDecls) = fun_129(txt, a_eq, a_eqs, a_varDecls, i_context);
      then (txt, a_varDecls, a_eqs);
  end match;
end fun_130;

public function equation_Xml
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_eqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) := fun_130(txt, a_context, a_eq, a_varDecls, a_eqs);
end equation_Xml;

public function old_equation_Xml
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_e;

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationSimpleAssignXml(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationSimpleAssignXml(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationArrayCallAssignXml(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_ALGORITHM(index = _),
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_LINEAR(index = _),
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_NONLINEAR(index = _),
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_WHEN(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationWhenXml(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION"));
      then (txt, a_varDecls);
  end match;
end old_equation_Xml;

protected function fun_133
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_expPart;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_preExp, in_a_expPart)
    local
      Tpl.Text txt;
      Tpl.Text a_expPart;
      Tpl.Text i_preExp;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_expPart )
      equation
        txt = Tpl.writeText(txt, a_expPart);
      then txt;

    case ( txt,
           i_preExp,
           _ )
      equation
        txt = Tpl.writeText(txt, i_preExp);
      then txt;
  end match;
end fun_133;

public function equationSimpleAssignXml
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_result;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        l_result = fun_133(Tpl.emptyTxt, l_preExp, l_expPart);
        txt = crefXml(txt, i_cref);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_result);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end equationSimpleAssignXml;

protected function fun_135
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_eqn_exp;
  input DAE.ComponentRef in_a_eqn_componentRef;
  input Tpl.Text in_a_expPart;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eqn_exp, in_a_eqn_componentRef, in_a_expPart)
    local
      Tpl.Text txt;
      DAE.Exp a_eqn_exp;
      DAE.ComponentRef a_eqn_componentRef;
      Tpl.Text a_expPart;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           "boolean",
           _,
           a_eqn_componentRef,
           a_expPart )
      equation
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.softNewLine(txt);
        txt = crefXml(txt, a_eqn_componentRef);
      then txt;

    case ( txt,
           "integer",
           _,
           a_eqn_componentRef,
           a_expPart )
      equation
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.softNewLine(txt);
        txt = crefXml(txt, a_eqn_componentRef);
      then txt;

    case ( txt,
           "real",
           _,
           a_eqn_componentRef,
           a_expPart )
      equation
        txt = crefXml(txt, a_eqn_componentRef);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_expPart);
      then txt;

    case ( txt,
           _,
           a_eqn_exp,
           _,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("No runtime support for this sort of array call: "));
        ret_0 = ExpressionDump.printExpStr(a_eqn_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 851, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_135;

public function equationArrayCallAssignXml
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_eqn_componentRef;
      DAE.Exp i_eqn_exp;
      DAE.Exp i_exp;
      String str_3;
      Tpl.Text txt_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(exp = (i_eqn_exp as i_exp), componentRef = i_eqn_componentRef),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt_2 = expTypeFromExpShortXml(Tpl.emptyTxt, i_eqn_exp);
        str_3 = Tpl.textString(txt_2);
        txt = fun_135(txt, str_3, i_eqn_exp, i_eqn_componentRef, l_expPart);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end equationArrayCallAssignXml;

protected function lm_137
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Tpl.Text in_a_helpInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
algorithm
  (out_txt, out_a_helpInits) :=
  match(in_txt, in_items, in_a_helpInits)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Tpl.Text a_helpInits;
      DAE.ComponentRef i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits )
      then (txt, a_helpInits);

    case ( txt,
           i_e :: rest,
           a_helpInits )
      equation
        l_helpInit = crefToXmlStr(Tpl.emptyTxt, i_e);
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_NEW_LINE());
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits) = lm_137(txt, rest, a_helpInits);
      then (txt, a_helpInits);
  end match;
end lm_137;

protected function fun_138
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_helpInits;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_preExp, in_a_helpInits)
    local
      Tpl.Text txt;
      Tpl.Text a_helpInits;
      Tpl.Text i_preExp;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_helpInits )
      equation
        txt = Tpl.writeText(txt, a_helpInits);
      then txt;

    case ( txt,
           i_preExp,
           _ )
      equation
        txt = Tpl.writeText(txt, i_preExp);
      then txt;
  end match;
end fun_138;

protected function lm_139
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Tpl.Text in_a_helpInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
algorithm
  (out_txt, out_a_helpInits) :=
  match(in_txt, in_items, in_a_helpInits)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Tpl.Text a_helpInits;
      DAE.ComponentRef i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits )
      then (txt, a_helpInits);

    case ( txt,
           i_e :: rest,
           a_helpInits )
      equation
        l_helpInit = crefToXmlStr(Tpl.emptyTxt, i_e);
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_NEW_LINE());
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits) = lm_139(txt, rest, a_helpInits);
      then (txt, a_helpInits);
  end match;
end lm_139;

protected function fun_140
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_helpInits;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_preExp, in_a_helpInits)
    local
      Tpl.Text txt;
      Tpl.Text a_helpInits;
      Tpl.Text i_preExp;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_helpInits )
      equation
        txt = Tpl.writeText(txt, a_helpInits);
      then txt;

    case ( txt,
           i_preExp,
           _ )
      equation
        txt = Tpl.writeText(txt, i_preExp);
      then txt;
  end match;
end fun_140;

public function equationWhenXml
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_elseWhenEq;
      DAE.ComponentRef i_left;
      DAE.Exp i_right;
      list<DAE.ComponentRef> i_conditions;
      Tpl.Text l_elseWhen;
      Tpl.Text l_cond;
      Tpl.Text l_exp;
      Tpl.Text l_preExp2;
      Tpl.Text l_helpIf;
      Tpl.Text l_helpInits;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = NONE()),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, l_helpInits) = lm_137(l_helpIf, i_conditions, l_helpInits);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_exp, l_preExp2, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls);
        l_cond = fun_138(Tpl.emptyTxt, l_preExp, l_helpInits);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<equ:When>\n",
                                    "  <equ:Condition>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_cond);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </equ:Condition>\n",
                                    "  <eq:Equation>\n",
                                    "    <exp:Sub>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = crefXml(txt, i_left);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    </exp:Sub>\n",
                                    "  </eq:Equation>\n",
                                    "</equ:When>"
                                }, false));
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = SOME(i_elseWhenEq)),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, l_helpInits) = lm_139(l_helpIf, i_conditions, l_helpInits);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_exp, l_preExp2, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls);
        (l_elseWhen, l_preExp, l_helpInits, a_varDecls) = equationElseWhenXml(Tpl.emptyTxt, i_elseWhenEq, a_context, l_preExp, l_helpInits, a_varDecls);
        l_cond = fun_140(Tpl.emptyTxt, l_preExp, l_helpInits);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<equ:When>\n",
                                    "  <equ:Condition>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_cond);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </equ:Condition>\n",
                                    "  <eq:Equation>\n",
                                    "    <exp:Sub>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = crefXml(txt, i_left);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    </exp:Sub>\n",
                                    "  </eq:Equation>\n",
                                    "</equ:When>\n"
                                }, true));
        txt = Tpl.writeText(txt, l_elseWhen);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end equationWhenXml;

protected function lm_142
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Tpl.Text in_a_helpInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
algorithm
  (out_txt, out_a_helpInits) :=
  match(in_txt, in_items, in_a_helpInits)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Tpl.Text a_helpInits;
      DAE.ComponentRef i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits )
      then (txt, a_helpInits);

    case ( txt,
           i_e :: rest,
           a_helpInits )
      equation
        l_helpInit = crefToXmlStr(Tpl.emptyTxt, i_e);
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_NEW_LINE());
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits) = lm_142(txt, rest, a_helpInits);
      then (txt, a_helpInits);
  end match;
end lm_142;

protected function fun_143
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_helpInits;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_preExp, in_a_helpInits)
    local
      Tpl.Text txt;
      Tpl.Text a_helpInits;
      Tpl.Text i_preExp;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_helpInits )
      equation
        txt = Tpl.writeText(txt, a_helpInits);
      then txt;

    case ( txt,
           i_preExp,
           _ )
      equation
        txt = Tpl.writeText(txt, i_preExp);
      then txt;
  end match;
end fun_143;

protected function lm_144
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Tpl.Text in_a_helpInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
algorithm
  (out_txt, out_a_helpInits) :=
  match(in_txt, in_items, in_a_helpInits)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Tpl.Text a_helpInits;
      DAE.ComponentRef i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits )
      then (txt, a_helpInits);

    case ( txt,
           i_e :: rest,
           a_helpInits )
      equation
        l_helpInit = crefToXmlStr(Tpl.emptyTxt, i_e);
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_NEW_LINE());
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits) = lm_144(txt, rest, a_helpInits);
      then (txt, a_helpInits);
  end match;
end lm_144;

protected function fun_145
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_helpInits;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_preExp, in_a_helpInits)
    local
      Tpl.Text txt;
      Tpl.Text a_helpInits;
      Tpl.Text i_preExp;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_helpInits )
      equation
        txt = Tpl.writeText(txt, a_helpInits);
      then txt;

    case ( txt,
           i_preExp,
           _ )
      equation
        txt = Tpl.writeText(txt, i_preExp);
      then txt;
  end match;
end fun_145;

public function equationElseWhenXml
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_helpInits, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_preExp, in_a_helpInits, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_elseWhenEq;
      DAE.ComponentRef i_left;
      DAE.Exp i_right;
      list<DAE.ComponentRef> i_conditions;
      Tpl.Text l_elseWhen;
      Tpl.Text l_cond;
      Tpl.Text l_exp;
      Tpl.Text l_preExp2;
      Tpl.Text l_helpIf;

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = NONE()),
           a_context,
           a_preExp,
           a_helpInits,
           a_varDecls )
      equation
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, a_helpInits) = lm_142(l_helpIf, i_conditions, a_helpInits);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_exp, l_preExp2, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls);
        l_cond = fun_143(Tpl.emptyTxt, a_preExp, a_helpInits);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<equ:ElseWhen>\n",
                                    "  <equ:Condition>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_cond);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </equ:Condition>\n",
                                    "  <eq:Equation>\n",
                                    "    <exp:Sub>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = crefXml(txt, i_left);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    </exp:Sub>\n",
                                    "  </eq:Equation>\n",
                                    "</equ:ElseWhen>"
                                }, false));
      then (txt, a_preExp, a_helpInits, a_varDecls);

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = SOME(i_elseWhenEq)),
           a_context,
           a_preExp,
           a_helpInits,
           a_varDecls )
      equation
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, a_helpInits) = lm_144(l_helpIf, i_conditions, a_helpInits);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_exp, l_preExp2, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls);
        (l_elseWhen, a_preExp, a_helpInits, a_varDecls) = equationElseWhenXml(Tpl.emptyTxt, i_elseWhenEq, a_context, a_preExp, a_helpInits, a_varDecls);
        l_cond = fun_145(Tpl.emptyTxt, a_preExp, a_helpInits);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<equ:ElseWhen>\n",
                                    "  <equ:Condition>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_cond);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </equ:Condition>\n",
                                    "  <eq:Equation>\n",
                                    "    <exp:Sub>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = crefXml(txt, i_left);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("testwhen3\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    </exp:Sub>\n",
                                    "  </eq:Equation>\n",
                                    "</equ:ElseWhen>\n"
                                }, true));
        txt = Tpl.writeText(txt, l_elseWhen);
      then (txt, a_preExp, a_helpInits, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_helpInits,
           a_varDecls )
      then (txt, a_preExp, a_helpInits, a_varDecls);
  end match;
end equationElseWhenXml;

protected function lm_147
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclarationXml(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_147(txt, rest);
      then txt;
  end match;
end lm_147;

public function recordsXml
  input Tpl.Text txt;
  input list<SimCode.RecordDeclaration> a_recordDecls;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("<fun:RecordsList>\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_147(out_txt, a_recordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("</fun:RecordsList>"));
end recordsXml;

protected function lm_149
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = recordBodyXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_149(txt, rest);
      then txt;
  end match;
end lm_149;

public function recordDeclarationXml
  input Tpl.Text in_txt;
  input SimCode.RecordDeclaration in_a_recDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_recDecl)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_variables;
      String i_name;

    case ( txt,
           SimCode.RECORD_DECL_FULL(name = i_name, variables = i_variables) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:Record>\n",
                                    "  <fun:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart  name =\'"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\'/>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </fun:Name>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_149(txt, i_variables);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Record>"));
      then txt;

    case ( txt,
           SimCode.RECORD_DECL_DEF(path = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  Record Declaration definition is not yet implemented"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end recordDeclarationXml;

public function recordBodyXml
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_var_name;
      SimCode.Variable i_var;
      DAE.ComponentRef i_name;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)), name = i_name)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:Field  type=\"Record\">\n",
                                    "  <fun:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = contextCrefXml(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Name>\n",
                                    "  <fun:Record>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = varTypeXml(txt, i_var);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Record>\n",
                                    "</fun:Field>"
                                }, false));
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<fun:Field  type=\""));
        txt = varTypeXml(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <fun:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = crefStrXml(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Name>\n",
                                    "</fun:Field>"
                                }, false));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end recordBodyXml;

protected function lm_152
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = functionXml(txt, i_fn);
        txt = Tpl.nextIter(txt);
        txt = lm_152(txt, rest);
      then txt;
  end match;
end lm_152;

public function functionsXml
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("<fun:FunctionList>\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_152(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("</fun:FunctionList>"));
end functionsXml;

public function functionXml
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)) )
      equation
        txt = regularFunctionXml(txt, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)) )
      equation
        txt = externalFunctionXml(txt, i_fn);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = _) )
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionXml;

protected function lm_155
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = funStatementXml(txt, i_stmt, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_155(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_155;

protected function lm_156
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funOutputVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_156(txt, rest);
      then txt;
  end match;
end lm_156;

protected function lm_157
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinitionXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_157(txt, rest);
      then txt;
  end match;
end lm_157;

public function regularFunctionXml
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_functionArguments;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Statement> i_body;
      Absyn.Path i_name;
      Tpl.Text l_bodyPart;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(name = i_name, body = i_body, outVars = i_outVars, functionArguments = i_functionArguments) )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePathXml(Tpl.emptyTxt, i_name);
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bodyPart, l_varDecls) = lm_155(l_bodyPart, i_body, l_varDecls);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:Function>\n",
                                    "  <fun:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </fun:Name>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_156(txt, i_outVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_157(txt, i_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Algorithm>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_bodyPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</fun:Algorithm>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Function> "));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end regularFunctionXml;

protected function lm_159
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funOutputVariableXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_159(txt, rest);
      then txt;
  end match;
end lm_159;

protected function lm_160
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinitionXml(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_160(txt, rest);
      then txt;
  end match;
end lm_160;

public function externalFunctionXml
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_funArgs;
      list<SimCode.Variable> i_outVars;
      SimCode.Function i_efn;
      Absyn.Path i_name;
      Tpl.Text l_callPart;
      Tpl.Text l_fname;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;

    case ( txt,
           (i_efn as SimCode.EXTERNAL_FUNCTION(name = i_name, outVars = i_outVars, funArgs = i_funArgs)) )
      equation
        System.tmpTickReset(1);
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_fname = underscorePathXml(Tpl.emptyTxt, i_name);
        (l_callPart, l_preExp, l_varDecls) = extFunCallXml(Tpl.emptyTxt, i_efn, l_preExp, l_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:Function>\n",
                                    "  <fun:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </fun:Name>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_159(txt, i_outVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_160(txt, i_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Algorithm>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_callPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</fun:Algorithm>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Function> "));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end externalFunctionXml;

public function funArgNameXml
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.VARIABLE(name = i_name) )
      equation
        txt = contextCrefXml(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end funArgNameXml;

public function funOutputVariableXml
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      SimCode.Variable i_var;
      DAE.ComponentRef i_name;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)), name = i_name)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:OutputVariable type=\"Record\">\n",
                                    "  <fun:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = contextCrefXml(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Name>\n",
                                    "  <fun:Record>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = varTypeXml(txt, i_var);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Record>\n",
                                    "</fun:OutputVariable>"
                                }, false));
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<fun:OutputVariable type=\""));
        txt = varTypeXml(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <fun:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = contextCrefXml(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Name>\n",
                                    "</fun:OutputVariable>"
                                }, false));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end funOutputVariableXml;

public function funArgDefinitionXml
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      SimCode.Variable i_var;
      DAE.ComponentRef i_name;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)), name = i_name)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:InputVariable type=\"Record\">\n",
                                    "  <fun:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = contextCrefXml(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Name>\n",
                                    "  <fun:Record>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = varTypeXml(txt, i_var);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Record>\n",
                                    "</fun:InputVariable>"
                                }, false));
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<fun:InputVariable type=\""));
        txt = varTypeXml(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <fun:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = contextCrefXml(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Name>\n",
                                    "</fun:InputVariable>"
                                }, false));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end funArgDefinitionXml;

public function funVarDeclarationsXml
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<fun:protectedVariable type=\""));
        txt = varTypeXml(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <fun:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = contextCrefXml(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Name>\n",
                                    "</fun:ProtectedVariable>"
                                }, false));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end funVarDeclarationsXml;

protected function fun_166
  input Tpl.Text in_txt;
  input String in_a_language;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_language, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedName name=\""));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
      then txt;

    case ( txt,
           "FORTRAN 77",
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedName name=\""));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 1175, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_166;

public function extFunctionNameXml
  input Tpl.Text txt;
  input String a_name;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_166(txt, a_language, a_name);
end extFunctionNameXml;

protected function fun_168
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isInput;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isInput)
    local
      Tpl.Text txt;
      Boolean a_isInput;
      DAE.Type i_type;
      Absyn.Path i_rname;
      DAE.Type i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char*"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty),
           a_isInput )
      equation
        txt = extTypeXml(txt, i_ty, a_isInput, true);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void *"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = underscorePathXml(txt, i_rname);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           i_type,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external C type "));
        ret_0 = Types.unparseType(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 1193, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_168;

protected function fun_169
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "const char*" )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const "));
      then txt;
  end match;
end fun_169;

protected function fun_170
  input Tpl.Text in_txt;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;
      String str_0;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        str_0 = Tpl.textString(a_s);
        txt = fun_169(txt, str_0);
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end match;
end fun_170;

protected function fun_171
  input Tpl.Text in_txt;
  input Boolean in_a_isInput;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isInput, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Tpl.Text a_s;

    case ( txt,
           false,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_s )
      equation
        txt = fun_170(txt, a_isArray, a_s);
      then txt;
  end match;
end fun_171;

protected function fun_172
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isArray;
  input Boolean in_a_isInput;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isArray, in_a_isInput, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Boolean a_isInput;
      Tpl.Text a_s;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           _,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_isInput,
           a_s )
      equation
        txt = fun_171(txt, a_isInput, a_isArray, a_s);
      then txt;
  end match;
end fun_172;

public function extTypeXml
  input Tpl.Text txt;
  input DAE.Type a_type;
  input Boolean a_isInput;
  input Boolean a_isArray;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_168(Tpl.emptyTxt, a_type, a_isInput);
  out_txt := fun_172(txt, a_type, a_isArray, a_isInput, l_s);
end extTypeXml;

protected function fun_174
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;
      DAE.Type i_type;
      Absyn.Path i_rname;
      DAE.Type i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("char"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = extTypeF77Xml(txt, i_ty, true);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = underscorePathXml(txt, i_rname);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           i_type )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external F77 type "));
        ret_0 = Types.unparseType(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 1212, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_174;

protected function fun_175
  input Tpl.Text in_txt;
  input Boolean in_a_isReference;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isReference, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end match;
end fun_175;

protected function fun_176
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isReference;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isReference, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isReference;
      Tpl.Text a_s;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isReference,
           a_s )
      equation
        txt = fun_175(txt, a_isReference, a_s);
      then txt;
  end match;
end fun_176;

public function extTypeF77Xml
  input Tpl.Text txt;
  input DAE.Type a_type;
  input Boolean a_isReference;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_174(Tpl.emptyTxt, a_type);
  out_txt := fun_176(txt, a_type, a_isReference, l_s);
end extTypeF77Xml;

protected function fun_178
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = underscorePathXml(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = dotPathXml(txt, a_name);
      then txt;
  end match;
end fun_178;

protected function fun_179
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = underscorePathXml(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = dotPathXml(txt, a_name);
      then txt;
  end match;
end fun_179;

protected function fun_180
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = underscorePathXml(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = dotPathXml(txt, a_name);
      then txt;
  end match;
end fun_180;

public function functionNameXml
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_dotPath;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_dotPath)
    local
      Tpl.Text txt;
      Boolean a_dotPath;
      Absyn.Path i_name;

    case ( txt,
           SimCode.FUNCTION(name = i_name),
           a_dotPath )
      equation
        txt = fun_178(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name),
           a_dotPath )
      equation
        txt = fun_179(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name),
           a_dotPath )
      equation
        txt = fun_180(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionNameXml;

public function extVarNameXml
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := crefXml(txt, a_cr);
end extVarNameXml;

protected function fun_183
  input Tpl.Text in_txt;
  input String in_a_language;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Function in_a_fun;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_language, in_a_varDecls, in_a_preExp, in_a_fun)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Function a_fun;

    case ( txt,
           "C",
           a_varDecls,
           a_preExp,
           a_fun )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallCXml(txt, a_fun, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           "FORTRAN 77",
           a_varDecls,
           a_preExp,
           a_fun )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallF77Xml(txt, a_fun, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_183;

public function extFunCallXml
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_fun, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.Function i_fun;
      String i_language;

    case ( txt,
           (i_fun as SimCode.EXTERNAL_FUNCTION(language = i_language)),
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_183(txt, i_language, a_varDecls, a_preExp, i_fun);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end extFunCallXml;

protected function lm_185
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extArgCXml(txt, i_arg, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_185(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_185;

protected function fun_186
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c) )
      equation
        txt = extVarNameXml(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_186;

public function extFunCallCXml
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_fun, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      String i_extName;
      SimCode.SimExtArg i_extReturn;
      list<SimCode.SimExtArg> i_extArgs;
      Tpl.Text l_returnAssign;
      Tpl.Text l_args;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, extReturn = i_extReturn, extName = i_extName),
           a_preExp,
           a_varDecls )
      equation
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                 "\n",
                                                                                 " "
                                                                             }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_args, a_varDecls, a_preExp) = lm_185(l_args, i_extArgs, a_varDecls, a_preExp);
        l_args = Tpl.popIter(l_args);
        l_returnAssign = fun_186(Tpl.emptyTxt, i_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Assign>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_returnAssign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<exp:Expression>\n",
                                    "  <exp:FunctionCall>\n",
                                    "    <exp:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = Tpl.writeStr(txt, i_extName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\" />\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    </exp:Name>\n",
                                    "    <exp:Arguments>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_args);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    </exp:Arguments>\n",
                                    "  </exp:FunctionCall>\n",
                                    "</exp:Expression>\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Assign>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end extFunCallCXml;

protected function lm_188
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extArgF77Xml(txt, i_arg, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_188(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_188;

protected function fun_189
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c) )
      equation
        txt = extVarNameXml(txt, i_c);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_189;

public function extFunCallF77Xml
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_fun, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      String i_extName;
      SimCode.SimExtArg i_extReturn;
      list<SimCode.SimExtArg> i_extArgs;
      Tpl.Text l_returnAssign;
      Tpl.Text l_args;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, extReturn = i_extReturn, extName = i_extName),
           a_preExp,
           a_varDecls )
      equation
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_args, a_varDecls, a_preExp) = lm_188(l_args, i_extArgs, a_varDecls, a_preExp);
        l_args = Tpl.popIter(l_args);
        l_returnAssign = fun_189(Tpl.emptyTxt, i_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Assign>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_returnAssign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<exp:Expression>\n",
                                    "  <exp:FunctionCall>\n",
                                    "    <exp:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = Tpl.writeStr(txt, i_extName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\" />\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    </exp:Name>\n",
                                    "    <exp:Arguments>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_args);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    </exp:Arguments>\n",
                                    "  </exp:FunctionCall>\n",
                                    "</exp:Expression>\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Assign>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end extFunCallF77Xml;

public function extArgCXml
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_extArg, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.ComponentRef i_c;
      Tpl.Text l_dim;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = _, isArray = true, type_ = _),
           a_preExp,
           a_varDecls )
      equation
        txt = extVarNameXml(txt, i_c);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = 0, type_ = _),
           a_preExp,
           a_varDecls )
      equation
        txt = extVarNameXml(txt, i_c);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = _, type_ = _),
           a_preExp,
           a_varDecls )
      equation
        txt = extVarNameXml(txt, i_c);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp),
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExternalXmlExp(txt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("test daeexternal xml"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = i_c, exp = i_exp),
           a_preExp,
           a_varDecls )
      equation
        l_name = extVarNameXml(Tpl.emptyTxt, i_c);
        (l_dim, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Size>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_dim);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:size>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end extArgCXml;

public function extArgF77Xml
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_extArg, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.ComponentRef i_c;
      Tpl.Text l_name;
      Tpl.Text l_dim;
      Tpl.Text l_texp;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isArray = true, type_ = _),
           a_preExp,
           a_varDecls )
      equation
        txt = extVarNameXml(txt, i_c);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = _, type_ = DAE.T_INTEGER(varLst = _)),
           a_preExp,
           a_varDecls )
      equation
        txt = extVarNameXml(txt, i_c);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = _, type_ = DAE.T_STRING(varLst = _)),
           a_preExp,
           a_varDecls )
      equation
        txt = extVarNameXml(txt, i_c);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = _, type_ = _),
           a_preExp,
           a_varDecls )
      equation
        txt = extVarNameXml(txt, i_c);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp, type_ = DAE.T_STRING(varLst = _)),
           a_preExp,
           a_varDecls )
      equation
        (l_texp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_texp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = i_c, exp = i_exp),
           a_preExp,
           a_varDecls )
      equation
        (l_dim, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        l_name = extVarNameXml(Tpl.emptyTxt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Size>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_dim);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:size>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end extArgF77Xml;

protected function lm_193
  input Tpl.Text in_txt;
  input list<DAE.ClassAttributes> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ClassAttributes> rest;
      SimCode.SimCode a_simCode;
      DAE.ClassAttributes i_classAttribute;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_classAttribute :: rest,
           a_simCode )
      equation
        txt = classAttributesXml(txt, i_classAttribute, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_193(txt, rest, a_simCode);
      then txt;
  end match;
end lm_193;

public function objectiveFunctionXml
  input Tpl.Text txt;
  input list<DAE.ClassAttributes> a_classAttributes;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_193(out_txt, a_classAttributes, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end objectiveFunctionXml;

protected function fun_195
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_objetiveE;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_objetiveE, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<opt:ObjectiveFunction>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_exp, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</opt:ObjectiveFunction>"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_195;

protected function fun_196
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_objectiveIntegrandE;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_objectiveIntegrandE, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<opt:IntegrandObjectiveFunction>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_exp, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</opt:IntegrandObjectiveFunction>"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_196;

protected function fun_197
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_startTimeE;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_startTimeE, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<opt:IntervalStartTime>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<opt:Value>"));
        (txt, a_preExp, a_varDecls) = daeExpValueXml(txt, i_exp, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</opt:Value>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</opt:IntervalStartTime>"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_197;

protected function fun_198
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_finalTimeE;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_finalTimeE, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<opt:IntervalFinalTime>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<opt:Value>"));
        (txt, a_preExp, a_varDecls) = daeExpValueXml(txt, i_exp, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</opt:Value>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</opt:IntervalFinalTime>"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_198;

protected function fun_199
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_startTimeE;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_startTimeE, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("index = \""));
        (txt, a_preExp, a_varDecls) = daeExpValueXml(txt, i_exp, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_199;

protected function fun_200
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_finalTimeE;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_finalTimeE, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("value = \""));
        (txt, a_preExp, a_varDecls) = daeExpValueXml(txt, i_exp, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_200;

protected function fun_201
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.Constraint> i_constraints;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), constraints = i_constraints) )
      equation
        txt = constraintsXml(txt, i_constraints);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_201;

public function classAttributesXml
  input Tpl.Text in_txt;
  input DAE.ClassAttributes in_a_classAttribute;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_classAttribute, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Option<DAE.Exp> i_finalTimeE;
      Option<DAE.Exp> i_startTimeE;
      Option<DAE.Exp> i_objectiveIntegrandE;
      Option<DAE.Exp> i_objetiveE;
      Tpl.Text l_constraints;
      Tpl.Text l_timePointValue;
      Tpl.Text l_timePointIndex;
      Tpl.Text l_finalTime;
      Tpl.Text l_startTime;
      Tpl.Text l_objectiveIntegrand;
      Tpl.Text l_objectiveFunction;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;

    case ( txt,
           DAE.OPTIMIZATION_ATTRS(objetiveE = i_objetiveE, objectiveIntegrandE = i_objectiveIntegrandE, startTimeE = i_startTimeE, finalTimeE = i_finalTimeE),
           a_simCode )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        (l_objectiveFunction, l_varDecls, l_preExp) = fun_195(Tpl.emptyTxt, i_objetiveE, l_varDecls, l_preExp);
        (l_objectiveIntegrand, l_varDecls, l_preExp) = fun_196(Tpl.emptyTxt, i_objectiveIntegrandE, l_varDecls, l_preExp);
        (l_startTime, l_varDecls, l_preExp) = fun_197(Tpl.emptyTxt, i_startTimeE, l_varDecls, l_preExp);
        (l_finalTime, l_varDecls, l_preExp) = fun_198(Tpl.emptyTxt, i_finalTimeE, l_varDecls, l_preExp);
        (l_timePointIndex, l_varDecls, l_preExp) = fun_199(Tpl.emptyTxt, i_startTimeE, l_varDecls, l_preExp);
        (l_timePointValue, l_varDecls, l_preExp) = fun_200(Tpl.emptyTxt, i_finalTimeE, l_varDecls, l_preExp);
        l_constraints = fun_201(Tpl.emptyTxt, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<opt:Optimization>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_objectiveFunction);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_objectiveIntegrand);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_startTime);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_finalTime);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<opt:TimePoints>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<opt:TimePoint "));
        txt = Tpl.writeText(txt, l_timePointIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_timePointValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "</opt:TimePoint>\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</opt:TimePoints>\n",
                                    "<opt:PathConstraints>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_constraints);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</opt:PathConstraints>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</opt:Optimization>"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 1434, 16), "Unknown Optimization attribute");
      then txt;
  end match;
end classAttributesXml;

protected function lm_203
  input Tpl.Text in_txt;
  input list<DAE.Constraint> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Constraint> rest;
      DAE.Constraint i_constraint;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_constraint :: rest )
      equation
        txt = constraintXml(txt, i_constraint);
        txt = Tpl.nextIter(txt);
        txt = lm_203(txt, rest);
      then txt;
  end match;
end lm_203;

public function constraintsXml
  input Tpl.Text txt;
  input list<DAE.Constraint> a_constraints;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_203(out_txt, a_constraints);
  out_txt := Tpl.popIter(out_txt);
end constraintsXml;

protected function lm_205
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_constraint;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_constraint :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = daeExpConstraintXml(txt, i_constraint, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_205(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_205;

public function constraintXml
  input Tpl.Text in_txt;
  input DAE.Constraint in_a_cons;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cons)
    local
      Tpl.Text txt;
      list<DAE.Exp> i_constraintLst;
      Tpl.Text l_constrain;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;

    case ( txt,
           DAE.CONSTRAINT_EXPS(constraintLst = i_constraintLst) )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        l_constrain = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_constrain, l_varDecls, l_preExp) = lm_205(l_constrain, i_constraintLst, l_varDecls, l_preExp);
        l_constrain = Tpl.popIter(l_constrain);
        txt = Tpl.writeText(txt, l_constrain);
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 1457, 16), "Unknown Constraint List");
      then txt;
  end match;
end constraintXml;

protected function lm_207
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatementXml(txt, i_stmt, SimCode.contextFunction, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_207(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_207;

public function funStatementXml
  input Tpl.Text in_txt;
  input SimCode.Statement in_a_stmt;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_statementLst;

    case ( txt,
           SimCode.ALGORITHM(statementLst = i_statementLst),
           a_varDecls )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_207(txt, i_statementLst, a_varDecls);
        txt = Tpl.popIter(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED FUN STATEMENT"));
      then (txt, a_varDecls);
  end match;
end funStatementXml;

protected function fun_209
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_s;

    case ( txt,
           (i_s as DAE.STMT_ASSIGN(type_ = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtAssignXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_ASSIGN_ARR(type_ = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtAssignArrXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_TUPLE_ASSIGN(type_ = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtTupleAssignXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_IF(exp = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtIfXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_FOR(type_ = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtForXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_WHILE(exp = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtWhileXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_ASSERT(cond = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtAssertXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_TERMINATE(msg = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtTerminateXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_WHEN(exp = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtWhenXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_BREAK(source = _),
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<fun:Break/>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_RETURN(source = _),
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<fun:Return/>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_NORETCALL(exp = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtNoretcallXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_REINIT(var = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtReinitXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 1493, 14), "ALG_STATEMENT NYI");
      then (txt, a_varDecls);
  end match;
end fun_209;

public function algStatementXml
  input Tpl.Text txt;
  input DAE.Statement a_stmt;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_res;
algorithm
  (l_res, out_a_varDecls) := fun_209(Tpl.emptyTxt, a_stmt, a_varDecls, a_context);
  out_txt := Tpl.writeText(txt, l_res);
end algStatementXml;

protected function fun_211
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input DAE.Exp in_a_val;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_val, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      DAE.Exp a_val;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Exp i_idx;
      DAE.Exp i_arr;
      Tpl.Text l_val1;
      Tpl.Text l_idx1;
      Tpl.Text l_arr1;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.ASUB(exp = i_arr, sub = {i_idx}),
           a_val,
           a_varDecls,
           a_context )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_arr1, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_arr, a_context, l_preExp, a_varDecls);
        (l_idx1, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_idx, a_context, l_preExp, a_varDecls);
        (l_val1, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_val, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_arr1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_idx1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_val1);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end match;
end fun_211;

protected function fun_212
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_exp1;
  input DAE.Exp in_a_val;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_exp1, in_a_val, in_a_varDecls, in_a_context, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp a_exp1;
      DAE.Exp a_val;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Exp a_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_varPart;
      Tpl.Text l_preExp;

    case ( txt,
           "metatype",
           _,
           a_val,
           a_varDecls,
           a_context,
           a_exp )
      equation
        (txt, a_varDecls) = fun_211(txt, a_exp, a_val, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_exp1,
           a_val,
           a_varDecls,
           a_context,
           _ )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = daeExpAsubXml(Tpl.emptyTxt, a_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_val, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Assign>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Expression>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</fun:Expression>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Assign>"));
      then (txt, a_varDecls);
  end match;
end fun_212;

public function algStmtAssignXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_val;
      DAE.Exp i_exp;
      DAE.Exp i_exp1;
      DAE.Exp i_e;
      Tpl.Text l_expPart2;
      Tpl.Text l_expPart1;
      String str_4;
      Tpl.Text txt_3;
      Tpl.Text l_varPart;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = DAE.CREF(componentRef = DAE.WILD()), exp = i_e),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:Assign>\n",
                                    "  <fun:Expression>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Expression>\n",
                                    "</fun:Assign>"
                                }, false));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(ty = DAE.T_FUNCTION_REFERENCE_VAR(functionType = _))), exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = scalarLhsCrefXml(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Assign>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Expression>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</fun:Expression>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Assign>"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(ty = DAE.T_FUNCTION_REFERENCE_FUNC(builtin = _))), exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = scalarLhsCrefXml(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Assign>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Expression>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</fun:Expression>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Assign>"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(componentRef = _)), exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = scalarLhsCrefXml(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Assign>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Expression>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</fun:Expression>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Assign>"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.ASUB(exp = _)), exp = (i_exp as i_val)),
           a_context,
           a_varDecls )
      equation
        txt_3 = expTypeFromExpShortXml(Tpl.emptyTxt, i_exp);
        str_4 = Tpl.textString(txt_3);
        (txt, a_varDecls) = fun_212(txt, str_4, i_exp1, i_val, a_varDecls, a_context, i_exp);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = i_exp1, exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart1, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart2, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Assign>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Expression>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_expPart2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</fun:Expression>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Assign>"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtAssignXml;

protected function fun_214
  input Tpl.Text in_txt;
  input Tpl.Text in_a_ispec;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_expPart;
  input DAE.Type in_a_t;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_ispec, in_a_varDecls, in_a_preExp, in_a_context, in_a_cr, in_a_expPart, in_a_t)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text a_expPart;
      DAE.Type a_t;
      Tpl.Text i_ispec;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_varDecls,
           a_preExp,
           a_context,
           a_cr,
           a_expPart,
           a_t )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Assign>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = copyArrayDataXml(txt, a_t, Tpl.textString(a_expPart), a_cr, a_context);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Expression>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</fun:Expression>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Assign>"));
      then (txt, a_varDecls);

    case ( txt,
           i_ispec,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr,
           a_expPart,
           a_t )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        (txt, a_varDecls) = indexedAssignXml(txt, a_t, Tpl.textString(a_expPart), a_cr, Tpl.textString(i_ispec), a_context, a_varDecls);
      then (txt, a_varDecls);
  end match;
end fun_214;

public function algStmtAssignArrXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Type i_t;
      DAE.ComponentRef i_cr;
      DAE.Exp i_e;
      Tpl.Text l_ispec;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_ASSIGN_ARR(exp = i_e, componentRef = i_cr, type_ = i_t),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e, a_context, l_preExp, a_varDecls);
        (l_ispec, l_preExp, a_varDecls) = indexSpecFromCrefXml(Tpl.emptyTxt, i_cr, a_context, l_preExp, a_varDecls);
        (txt, a_varDecls) = fun_214(txt, l_ispec, a_varDecls, l_preExp, a_context, i_cr, l_expPart, i_t);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtAssignArrXml;

protected function fun_216
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input String in_a_ispec;
  input String in_a_exp;
  input Tpl.Text in_a_cref;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_ispec, in_a_exp, in_a_cref)
    local
      Tpl.Text txt;
      String a_ispec;
      String a_exp;
      Tpl.Text a_cref;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           _,
           _,
           a_cref )
      equation
        txt = Tpl.writeText(txt, a_cref);
      then txt;

    case ( txt,
           _,
           a_ispec,
           a_exp,
           a_cref )
      equation
        txt = Tpl.writeStr(txt, a_exp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeStr(txt, a_ispec);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_cref);
      then txt;
  end match;
end fun_216;

public function indexedAssignXml
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input String a_exp;
  input DAE.ComponentRef a_cr;
  input String a_ispec;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_cref;
  Tpl.Text l_type;
algorithm
  l_type := expTypeArrayXml(Tpl.emptyTxt, a_ty);
  l_cref := contextArrayCrefXml(Tpl.emptyTxt, a_cr, a_context);
  out_txt := fun_216(txt, a_context, a_ispec, a_exp, l_cref);
  out_a_varDecls := a_varDecls;
end indexedAssignXml;

protected function fun_218
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_cref;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_cref)
    local
      Tpl.Text txt;
      Tpl.Text a_cref;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cref )
      equation
        txt = Tpl.writeText(txt, a_cref);
      then txt;

    case ( txt,
           _,
           a_cref )
      equation
        txt = Tpl.writeText(txt, a_cref);
      then txt;
  end match;
end fun_218;

public function copyArrayDataXml
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input String a_exp;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_cref;
  Tpl.Text l_type;
algorithm
  l_type := expTypeArrayXml(Tpl.emptyTxt, a_ty);
  l_cref := contextArrayCrefXml(Tpl.emptyTxt, a_cr, a_context);
  out_txt := fun_218(txt, a_context, l_cref);
end copyArrayDataXml;

protected function lm_220
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_220(txt, rest);
      then txt;
  end match;
end lm_220;

protected function lm_221
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_retStruct;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context, in_a_retStruct)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      Tpl.Text a_retStruct;
      Integer x_i1;
      DAE.Exp i_cr;
      Tpl.Text l_rhsStr;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_cr :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_retStruct )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_rhsStr = Tpl.writeText(Tpl.emptyTxt, a_retStruct);
        l_rhsStr = Tpl.writeTok(l_rhsStr, Tpl.ST_STRING(".targ"));
        l_rhsStr = Tpl.writeStr(l_rhsStr, intString(x_i1));
        (txt, a_afterExp, a_varDecls) = writeLhsCrefXml(txt, i_cr, Tpl.textString(l_rhsStr), a_context, a_afterExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_221(txt, rest, a_varDecls, a_afterExp, a_context, a_retStruct);
      then (txt, a_varDecls, a_afterExp);
  end match;
end lm_221;

protected function lm_222
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_prefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      Tpl.Text a_prefix;
      Integer x_i1;
      DAE.Exp i_cr;
      Tpl.Text l_rhsStr;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_cr :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_prefix )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_rhsStr = Tpl.writeText(Tpl.emptyTxt, a_prefix);
        l_rhsStr = Tpl.writeTok(l_rhsStr, Tpl.ST_STRING("_targ"));
        l_rhsStr = Tpl.writeStr(l_rhsStr, intString(x_i1));
        (txt, a_afterExp, a_varDecls) = writeLhsCrefXml(txt, i_cr, Tpl.textString(l_rhsStr), a_context, a_afterExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_222(txt, rest, a_varDecls, a_afterExp, a_context, a_prefix);
      then (txt, a_varDecls, a_afterExp);
  end match;
end lm_222;

protected function fun_223
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "modelica_metatype" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = NULL"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_223;

protected function fun_224
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_rhsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_rhsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_rhsStr;

    case ( txt,
           "modelica_metatype",
           a_rhsStr )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = Tpl.writeText(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = Tpl.writeText(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_224;

protected function lm_225
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_prefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_prefix;
      Integer x_i1;
      DAE.Exp i_cr;
      String str_5;
      Tpl.Text l_addRoot;
      String str_3;
      Tpl.Text l_initVar;
      Tpl.Text l_typ;
      Tpl.Text l_rhsStr;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_cr :: rest,
           a_varDecls,
           a_prefix )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_rhsStr = Tpl.writeText(Tpl.emptyTxt, a_prefix);
        l_rhsStr = Tpl.writeTok(l_rhsStr, Tpl.ST_STRING("_targ"));
        l_rhsStr = Tpl.writeStr(l_rhsStr, intString(x_i1));
        l_typ = expTypeFromExpModelicaXml(Tpl.emptyTxt, i_cr);
        str_3 = Tpl.textString(l_typ);
        l_initVar = fun_223(Tpl.emptyTxt, str_3);
        str_5 = Tpl.textString(l_typ);
        l_addRoot = fun_224(Tpl.emptyTxt, str_5, l_rhsStr);
        a_varDecls = Tpl.writeText(a_varDecls, l_typ);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = Tpl.writeText(a_varDecls, l_rhsStr);
        a_varDecls = Tpl.writeText(a_varDecls, l_initVar);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeText(a_varDecls, l_addRoot);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_225(txt, rest, a_varDecls, a_prefix);
      then (txt, a_varDecls);
  end match;
end lm_225;

public function algStmtTupleAssignXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      list<DAE.Exp> i_expExpLst;
      Integer ret_8;
      Tpl.Text l_prefix;
      Tpl.Text l_lhsCrefs;
      Tpl.Text l_retStruct;
      String ret_4;
      Tpl.Text l_marker;
      Tpl.Text l_crefs;
      Tpl.Text l_afterExp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_TUPLE_ASSIGN(exp = (i_exp as DAE.CALL(path = _)), expExpLst = i_expExpLst),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_afterExp = Tpl.emptyTxt;
        l_crefs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_crefs = lm_220(l_crefs, i_expExpLst);
        l_crefs = Tpl.popIter(l_crefs);
        l_marker = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("("));
        l_marker = Tpl.writeText(l_marker, l_crefs);
        l_marker = Tpl.writeTok(l_marker, Tpl.ST_STRING(") = "));
        ret_4 = ExpressionDump.printExpStr(i_exp);
        l_marker = Tpl.writeStr(l_marker, ret_4);
        l_preExp = Tpl.writeTok(l_preExp, Tpl.ST_STRING("/* algStmtTupleAssign: preExp buffer created for "));
        l_preExp = Tpl.writeText(l_preExp, l_marker);
        l_preExp = Tpl.writeTok(l_preExp, Tpl.ST_STRING(" */"));
        l_preExp = Tpl.writeTok(l_preExp, Tpl.ST_NEW_LINE());
        l_afterExp = Tpl.writeTok(l_afterExp, Tpl.ST_STRING("/* algStmtTupleAssign: afterExp buffer created for "));
        l_afterExp = Tpl.writeText(l_afterExp, l_marker);
        l_afterExp = Tpl.writeTok(l_afterExp, Tpl.ST_STRING(" */"));
        l_afterExp = Tpl.writeTok(l_afterExp, Tpl.ST_NEW_LINE());
        (l_retStruct, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        l_lhsCrefs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_lhsCrefs, a_varDecls, l_afterExp) = lm_221(l_lhsCrefs, i_expExpLst, a_varDecls, l_afterExp, a_context, l_retStruct);
        l_lhsCrefs = Tpl.popIter(l_lhsCrefs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:FunctionCallStatement>\n",
                                    "  <fun:OutputArgument>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_lhsCrefs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </fun:OutputArgument>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_retStruct);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:FunctionCallStatement>"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_TUPLE_ASSIGN(exp = DAE.MATCHEXPRESSION(matchType = _), expExpLst = i_expExpLst),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_afterExp = Tpl.emptyTxt;
        l_prefix = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("tmp"));
        ret_8 = System.tmpTick();
        l_prefix = Tpl.writeStr(l_prefix, intString(ret_8));
        l_lhsCrefs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_lhsCrefs, a_varDecls, l_afterExp) = lm_222(l_lhsCrefs, i_expExpLst, a_varDecls, l_afterExp, a_context, l_prefix);
        l_lhsCrefs = Tpl.popIter(l_lhsCrefs);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_225(txt, i_expExpLst, a_varDecls, l_prefix);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_lhsCrefs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_afterExp);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 1686, 12), "algStmtTupleAssign failed");
      then (txt, a_varDecls);
  end match;
end algStmtTupleAssignXml;

protected function fun_227
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_lhsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_lhsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_lhsStr;

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = _),
           a_lhsStr )
      equation
        txt = Tpl.writeText(txt, a_lhsStr);
      then txt;

    case ( txt,
           _,
           a_lhsStr )
      equation
        txt = Tpl.writeText(txt, a_lhsStr);
      then txt;
  end match;
end fun_227;

protected function fun_228
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_lhsStr;
  input String in_a_rhsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_lhsStr, in_a_rhsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_lhsStr;
      String a_rhsStr;

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = _),
           a_lhsStr,
           a_rhsStr )
      equation
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_lhsStr);
      then txt;

    case ( txt,
           _,
           a_lhsStr,
           _ )
      equation
        txt = Tpl.writeText(txt, a_lhsStr);
      then txt;
  end match;
end fun_228;

public function writeLhsCrefXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input String in_a_rhsStr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_rhsStr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_rhsStr;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_e;
      DAE.Exp i_exp;
      String ret_1;
      Tpl.Text l_lhsStr;

    case ( txt,
           DAE.CREF(componentRef = DAE.WILD()),
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<fun:EmptyOutputArgument></fun:EmptyOutputArgument>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CREF(ty = DAE.T_ARRAY(ty = _))),
           _,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCrefXml(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        txt = fun_227(txt, a_context, l_lhsStr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.UNARY(exp = (i_e as DAE.CREF(ty = DAE.T_ARRAY(ty = _)))),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCrefXml(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        txt = fun_228(txt, a_context, l_lhsStr, a_rhsStr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CREF(componentRef = _)),
           _,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCrefXml(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_lhsStr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.UNARY(exp = (i_e as DAE.CREF(componentRef = _))),
           _,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCrefXml(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_lhsStr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           a_rhsStr,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* SimCodeC.tpl template: writeLhsCref: UNHANDLED LHS\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* "));
        ret_1 = ExpressionDump.printExpStr(i_exp);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
        txt = Tpl.popBlock(txt);
      then (txt, a_preExp, a_varDecls);
  end match;
end writeLhsCrefXml;

protected function lm_230
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatementXml(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_230(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_230;

public function algStmtIfXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_condExp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_IF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_condExp, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:If>\n",
                                    "  <fun:Condition>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_condExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Condition>\n",
                                    "  <fun:Statements>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_230(txt, i_statementLst, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </fun:Statements>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        (txt, a_varDecls) = elseExprXml(txt, i_else__, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:If>"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtIfXml;

public function algStmtForXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Statement i_s;

    case ( txt,
           (i_s as DAE.STMT_FOR(range = DAE.RANGE(ty = _))),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStmtForRangeXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_FOR(type_ = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStmtForGenericXml(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtForXml;

protected function lm_233
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatementXml(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_233(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_233;

public function algStmtForRangeXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Ident i_iter;
      DAE.Exp i_rng;
      list<DAE.Statement> i_statementLst;
      Boolean i_iterIsArray;
      DAE.Type i_type__;
      Tpl.Text l_stmtStr;
      Tpl.Text l_identTypeShort;
      Tpl.Text l_identType;

    case ( txt,
           DAE.STMT_FOR(range = (i_rng as DAE.RANGE(ty = _)), type_ = i_type__, iterIsArray = i_iterIsArray, statementLst = i_statementLst, iter = i_iter),
           a_context,
           a_varDecls )
      equation
        l_identType = expTypeXml(Tpl.emptyTxt, i_type__, i_iterIsArray);
        l_identTypeShort = expTypeShortXml(Tpl.emptyTxt, i_type__);
        l_stmtStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_stmtStr, a_varDecls) = lm_233(l_stmtStr, i_statementLst, a_varDecls, a_context);
        l_stmtStr = Tpl.popIter(l_stmtStr);
        (txt, l_stmtStr, a_varDecls) = algStmtForRange_implXml(txt, i_rng, i_iter, Tpl.textString(l_identType), Tpl.textString(l_identTypeShort), l_stmtStr, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtForRangeXml;

protected function fun_235
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_step;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_step, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_eo;

    case ( txt,
           SOME(i_eo),
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_eo, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_235;

protected function fun_236
  input Tpl.Text in_txt;
  input DAE.Exp in_a_range;
  input Absyn.Ident in_a_iterator;
  input Tpl.Text in_a_body;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_range, in_a_iterator, in_a_body, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      Absyn.Ident a_iterator;
      Tpl.Text a_body;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_stop;
      Option<DAE.Exp> i_step;
      DAE.Exp i_start;
      Tpl.Text l_stopValue;
      Tpl.Text l_stepValue;
      Tpl.Text l_startValue;
      Tpl.Text l_preExp;
      Tpl.Text l_iterName;

    case ( txt,
           DAE.RANGE(start = i_start, step = i_step, stop = i_stop),
           a_iterator,
           a_body,
           a_context,
           a_varDecls )
      equation
        l_iterName = contextIteratorNameXml(Tpl.emptyTxt, a_iterator, a_context);
        l_preExp = Tpl.emptyTxt;
        (l_startValue, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_start, a_context, l_preExp, a_varDecls);
        (l_stepValue, a_varDecls, l_preExp) = fun_235(Tpl.emptyTxt, i_step, a_varDecls, l_preExp, a_context);
        (l_stopValue, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_stop, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:For>\n",
                                    "  <fun:Index>\n",
                                    "    <fun:IterationVariable>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = Tpl.writeText(txt, l_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    </fun:IterationVariable>\n",
                                    "    <fun:IterationSet>\n",
                                    "      <exp:Range>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeText(txt, l_startValue);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_stepValue);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_stopValue);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      </exp:Range>\n",
                                    "    </fun:IterationSet>\n",
                                    "  </fun:Index>\n",
                                    "  <fun:Statements>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Statements>\n",
                                    "</fun:For>"
                                }, false));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_236;

public function algStmtForRange_implXml
  input Tpl.Text txt;
  input DAE.Exp a_range;
  input Absyn.Ident a_iterator;
  input String a_type;
  input String a_shortType;
  input Tpl.Text a_body;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_body;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_236(txt, a_range, a_iterator, a_body, a_context, a_varDecls);
  out_a_body := a_body;
end algStmtForRange_implXml;

protected function lm_238
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatementXml(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_238(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_238;

public function algStmtForGenericXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Ident i_iter;
      DAE.Exp i_range;
      list<DAE.Statement> i_statementLst;
      Boolean i_iterIsArray;
      DAE.Type i_type__;
      Tpl.Text l_stmtStr;
      Tpl.Text l_arrayType;
      Tpl.Text l_iterType;

    case ( txt,
           DAE.STMT_FOR(type_ = i_type__, iterIsArray = i_iterIsArray, statementLst = i_statementLst, range = i_range, iter = i_iter),
           a_context,
           a_varDecls )
      equation
        l_iterType = expTypeXml(Tpl.emptyTxt, i_type__, i_iterIsArray);
        l_arrayType = expTypeArrayXml(Tpl.emptyTxt, i_type__);
        l_stmtStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_stmtStr, a_varDecls) = lm_238(l_stmtStr, i_statementLst, a_varDecls, a_context);
        l_stmtStr = Tpl.popIter(l_stmtStr);
        (txt, l_stmtStr, a_varDecls) = algStmtForGeneric_implXml(txt, i_range, i_iter, Tpl.textString(l_iterType), Tpl.textString(l_arrayType), i_iterIsArray, l_stmtStr, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtForGenericXml;

public function algStmtForGeneric_implXml
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input Absyn.Ident a_iterator;
  input String a_type;
  input String a_arrayType;
  input Boolean a_iterIsArray;
  input Tpl.Text a_body;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_body;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_evar;
  Tpl.Text l_preExp;
  Tpl.Text l_iterName;
algorithm
  l_iterName := contextIteratorNameXml(Tpl.emptyTxt, a_iterator, a_context);
  l_preExp := Tpl.emptyTxt;
  (l_evar, l_preExp, out_a_varDecls) := daeExpXml(Tpl.emptyTxt, a_exp, a_context, l_preExp, a_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "<fun:For>\n",
                                   "  <fun:Index>\n",
                                   "    <fun:IterationVariable>\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(6));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
  out_txt := Tpl.writeText(out_txt, l_iterName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("\"/>\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "    </fun:IterationVariable>\n",
                                       "    <fun:IterationSet>\n",
                                       "      <exp:Array>\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(8));
  out_txt := Tpl.writeText(out_txt, l_preExp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "      </exp:Array>\n",
                                       "    </fun:IterationSet>\n",
                                       "  </fun:Index>\n",
                                       "  <fun:Statements>\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(6));
  out_txt := Tpl.writeText(out_txt, a_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "  </fun:Statements>\n",
                                       "</fun:For>"
                                   }, false));
  out_a_body := a_body;
end algStmtForGeneric_implXml;

protected function lm_241
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatementXml(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_241(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_241;

public function algStmtWhileXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_var;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_WHILE(exp = i_exp, statementLst = i_statementLst),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_var, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:While>\n",
                                    "  <fun:Condition>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_var);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Condition>\n",
                                    "  <fun:Statements>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_241(txt, i_statementLst, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Statements>\n",
                                    "</fun:While>"
                                }, false));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtWhileXml;

public function algStmtAssertXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Absyn.Info i_info;
      DAE.Exp i_msg;
      DAE.Exp i_cond;

    case ( txt,
           DAE.STMT_ASSERT(source = DAE.SOURCE(info = i_info), cond = i_cond, msg = i_msg),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = assertCommonXml(txt, i_cond, i_msg, a_context, a_varDecls, i_info);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtAssertXml;

public function algStmtTerminateXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_msg;
      Tpl.Text l_msgVar;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_TERMINATE(msg = i_msg),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_msg, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_msgVar);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtTerminateXml;

public function algStmtNoretcallXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_NORETCALL(exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtNoretcallXml;

protected function lm_246
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = crefToXmlStr(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_246(txt, rest);
      then txt;
  end match;
end lm_246;

protected function lm_247
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatementXml(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_247(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_247;

public function algStmtWhenXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_when;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_when, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Option<DAE.Statement> i_elseWhen;
      list<DAE.Statement> i_statementLst;
      list<DAE.ComponentRef> i_conditions;
      Tpl.Text l_else;
      Tpl.Text l_statements;
      Tpl.Text l_cond;

    case ( txt,
           DAE.STMT_WHEN(conditions = i_conditions, statementLst = i_statementLst, elseWhen = i_elseWhen),
           a_context,
           a_varDecls )
      equation
        l_cond = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_cond = lm_246(l_cond, i_conditions);
        l_cond = Tpl.popIter(l_cond);
        l_statements = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_statements, a_varDecls) = lm_247(l_statements, i_statementLst, a_varDecls, a_context);
        l_statements = Tpl.popIter(l_statements);
        (l_else, a_varDecls) = algStatementWhenElseXml(Tpl.emptyTxt, i_elseWhen, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:When>\n",
                                    "  <fun:Condition>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_cond);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Condition>\n",
                                    "  <fun:Statements>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_statements);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </fun:Statements>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_else);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtWhenXml;

protected function lm_249
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatementXml(txt, i_stmt, SimCode.contextSimulationDiscrete, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_249(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_249;

protected function lm_250
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = crefToXmlStr(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_250(txt, rest);
      then txt;
  end match;
end lm_250;

public function algStatementWhenElseXml
  input Tpl.Text in_txt;
  input Option<DAE.Statement> in_a_stmt;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<DAE.ComponentRef> i_when_conditions;
      Option<DAE.Statement> i_when_elseWhen;
      list<DAE.Statement> i_when_statementLst;
      Tpl.Text l_elseCondStr;
      Tpl.Text l_else;
      Tpl.Text l_statements;

    case ( txt,
           SOME(DAE.STMT_WHEN(statementLst = i_when_statementLst, elseWhen = i_when_elseWhen, conditions = i_when_conditions)),
           a_varDecls )
      equation
        l_statements = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_statements, a_varDecls) = lm_249(l_statements, i_when_statementLst, a_varDecls);
        l_statements = Tpl.popIter(l_statements);
        (l_else, a_varDecls) = algStatementWhenElseXml(Tpl.emptyTxt, i_when_elseWhen, a_varDecls);
        l_elseCondStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                        "\n",
                                                                                        " "
                                                                                    }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_elseCondStr = lm_250(l_elseCondStr, i_when_conditions);
        l_elseCondStr = Tpl.popIter(l_elseCondStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Condition>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_elseCondStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</fun:Condition>\n",
                                    "<fun:Statements>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_statements);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</fun:Statements>\n"));
        txt = Tpl.writeText(txt, l_else);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:When>"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStatementWhenElseXml;

public function algStmtReinitXml
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_value;
      DAE.Exp i_var;
      Tpl.Text l_expPart2;
      Tpl.Text l_expPart1;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_REINIT(var = i_var, value = i_value),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart1, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_var, a_context, l_preExp, a_varDecls);
        (l_expPart2, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_value, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Reinit>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Reinit>"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtReinitXml;

public function indexSpecFromCrefXml
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_cr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.Subscript> i_subs;

    case ( txt,
           DAE.CREF_IDENT(subscriptLst = (i_subs as _ :: _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhsIndexSpecXml(txt, i_subs, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end indexSpecFromCrefXml;

protected function lm_254
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatementXml(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_254(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_254;

protected function lm_255
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatementXml(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_255(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_255;

public function elseExprXml
  input Tpl.Text in_txt;
  input DAE.Else in_a_else__;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_else__, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_condExp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.NOELSE(),
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           DAE.ELSEIF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_condExp, l_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:ElseIf>\n",
                                    "  <fun:Condition>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_condExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </fun:Condition>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_254(txt, i_statementLst, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</fun:ElseIf>\n"));
        (txt, a_varDecls) = elseExprXml(txt, i_else__, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           DAE.ELSE(statementLst = i_statementLst),
           a_context,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fun:Else>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_255(txt, i_statementLst, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Else>"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end elseExprXml;

protected function fun_257
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_ecr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_mArg, in_a_ecr_componentRef, in_a_varDecls, in_a_preExp, in_a_context, in_a_ecr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_ecr;

    case ( txt,
           false,
           _,
           a_varDecls,
           a_preExp,
           a_context,
           a_ecr )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefLhsXml(txt, a_ecr, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_ecr_componentRef,
           a_varDecls,
           a_preExp,
           _,
           _ )
      equation
        txt = crefXml(txt, a_ecr_componentRef);
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_257;

public function scalarLhsCrefXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_ecr;
      DAE.ComponentRef i_ecr_componentRef;
      DAE.ComponentRef i_cr;
      Boolean ret_0;

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_VAR(functionType = _)),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = crefStrXml(txt, i_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = (i_ecr_componentRef as DAE.CREF_IDENT(ident = _)))),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        ret_0 = SimCodeUtil.crefNoSub(i_ecr_componentRef);
        (txt, a_varDecls, a_preExp) = fun_257(txt, ret_0, i_ecr_componentRef, a_varDecls, a_preExp, a_context, i_ecr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = (i_ecr_componentRef as DAE.CREF_QUAL(ident = _))),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = crefXml(txt, i_ecr_componentRef);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = DAE.WILD()),
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ONLY_IDENT_OR_QUAL_CREF_SUPPORTED_SLHS"));
      then (txt, a_preExp, a_varDecls);
  end match;
end scalarLhsCrefXml;

protected function fun_259
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_259;

public function daeExpXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Exp i_e;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:IntegerLiteral>"));
        txt = Tpl.writeStr(txt, intString(i_integer));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:IntegerLiteral>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.RCONST(real = i_real),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:RealLiteral>"));
        txt = Tpl.writeStr(txt, realString(i_real));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:RealLiteral>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SCONST(string = i_string),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:StringLiteral>"));
        (txt, a_preExp, a_varDecls) = daeExpSconstXml(txt, i_string, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:StringLiteral>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.BCONST(bool = i_bool),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:BooleanLiteral>"));
        txt = fun_259(txt, i_bool);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:BooleanLiteral>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CREF(componentRef = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhsXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.BINARY(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpBinaryXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.UNARY(operator = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnaryXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LBINARY(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpLbinaryXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LUNARY(operator = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpLunaryXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.RELATION(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRelationXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.IFEXP(expCond = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpIfXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CALL(path = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCallXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.ARRAY(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpArrayXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.MATRIX(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMatrixXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.RANGE(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRangeXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CAST(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCastXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.ASUB(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpAsubXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.TSUB(exp = i_exp),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_exp, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.SIZE(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSizeXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.TUPLE(PR = _),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Tuple Not yet Implemented"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.BOX(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpBoxXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.UNBOX(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnboxXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.SHARED_LITERAL(index = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSharedLiteralXml(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown expression: "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 2063, 14), Tpl.textString(txt_0));
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpXml;

protected function fun_261
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      Real i_real;
      Integer i_integer;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_261;

public function daeExpValueXml
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_261(txt, a_exp);
  out_a_preExp := a_preExp;
  out_a_varDecls := a_varDecls;
end daeExpValueXml;

protected function fun_263
  input Tpl.Text in_txt;
  input DAE.Type in_mArg;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Exp a_exp;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           a_exp,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, a_exp, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_263;

public function daeExternalXmlExp
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  DAE.Type ret_0;
algorithm
  ret_0 := Expression.typeof(a_exp);
  (out_txt, out_a_preExp, out_a_varDecls) := fun_263(txt, ret_0, a_exp, a_context, a_preExp, a_varDecls);
end daeExternalXmlExp;

public function daeExpSconstXml
  input Tpl.Text txt;
  input String a_string;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("\""));
  ret_0 := Util.escapeModelicaStringToCString(a_string);
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_a_preExp := a_preExp;
  out_a_varDecls := a_varDecls;
end daeExpSconstXml;

protected function fun_266
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_cr, in_a_t, in_a_varDecls, in_a_preExp, in_a_exp)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      DAE.Type a_t;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp a_exp;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           _,
           _,
           a_varDecls,
           a_preExp,
           a_exp )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs2Xml(txt, a_exp, i_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_context,
           a_cr,
           a_t,
           a_varDecls,
           a_preExp,
           _ )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRecordCrefRhsXml(txt, a_t, a_cr, i_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_266;

public function daeExpCrefRhsXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cr;
      DAE.Type i_t;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.CREF(componentRef = i_cr, ty = (i_t as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _))))),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_266(txt, a_context, i_cr, i_t, a_varDecls, a_preExp, i_exp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_FUNC(builtin = _)),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = crefFunctionNameXml(txt, i_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_VAR(functionType = _)),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = crefStrXml(txt, i_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs2Xml(txt, i_exp, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpCrefRhsXml;

protected function lm_268
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_268(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_268(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_268;

protected function lm_269
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_269(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_269(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_269;

protected function fun_270
  input Tpl.Text in_txt;
  input DAE.Type in_mArg;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_arrName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_mArg, in_a_ecr, in_a_varDecls, in_a_preExp, in_a_context, in_a_cr, in_a_arrName)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text a_arrName;
      DAE.Dimensions i_et_dims;
      Tpl.Text txt_1;
      String ret_1;
      list<DAE.Subscript> ret_0;

    case ( txt,
           DAE.T_ARRAY(dims = i_et_dims),
           _,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")["));
        ret_0 = ComponentReference.crefSubs(a_cr);
        (txt, a_preExp, a_varDecls) = threadDimSubListXml(txt, i_et_dims, ret_0, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_ecr,
           a_varDecls,
           a_preExp,
           _,
           _,
           _ )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Indexing non-array "));
        ret_1 = ExpressionDump.printExpStr(a_ecr);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 2178, 28), Tpl.textString(txt_1));
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_270;

protected function fun_271
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_arrName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_ecr, in_a_arrName, in_a_varDecls, in_a_preExp, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_arrName;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.ComponentRef a_cr;
      SimCode.Context i_context;
      DAE.Type ret_2;
      list<DAE.Subscript> ret_1;
      Tpl.Text l_dimsValuesStr;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           _,
           a_arrName,
           a_varDecls,
           a_preExp,
           a_cr )
      equation
        ret_1 = ComponentReference.crefSubs(a_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                          "\n",
                                                                                          " "
                                                                                      }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_varDecls, a_preExp) = lm_269(l_dimsValuesStr, ret_1, a_varDecls, a_preExp, i_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Identifier>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <exp:ArraySubscripts>\n",
                                    "    <exp:IndexExpression>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_dimsValuesStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    </exp:IndexExpression>\n",
                                    "  </exp:ArraySubscripts>\n",
                                    "</exp:QualifiedNamePart>\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Identifier>"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_context,
           a_ecr,
           a_arrName,
           a_varDecls,
           a_preExp,
           a_cr )
      equation
        ret_2 = ComponentReference.crefLastType(a_cr);
        (txt, a_varDecls, a_preExp) = fun_270(txt, ret_2, a_ecr, a_varDecls, a_preExp, i_context, a_cr, a_arrName);
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_271;

protected function fun_272
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_arrName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_mArg, in_a_ecr, in_a_arrName, in_a_varDecls, in_a_preExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_arrName;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      list<DAE.Subscript> ret_1;
      Tpl.Text l_dimsValuesStr;

    case ( txt,
           "metatype_array",
           _,
           a_arrName,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        ret_1 = ComponentReference.crefSubs(a_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_varDecls, a_preExp) = lm_268(l_dimsValuesStr, ret_1, a_varDecls, a_preExp, a_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /* DAE.CREF */"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_ecr,
           a_arrName,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        (txt, a_varDecls, a_preExp) = fun_271(txt, a_context, a_ecr, a_arrName, a_varDecls, a_preExp, a_cr);
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_272;

protected function fun_273
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_ecr, in_a_preExp, in_a_varDecls, in_a_ty, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      String str_9;
      Integer ret_8;
      list<DAE.Subscript> ret_7;
      Tpl.Text l_dimsLenStr;
      DAE.ComponentRef ret_5;
      list<DAE.Subscript> ret_4;
      Tpl.Text l_spec1;
      Tpl.Text l_tmp;
      Tpl.Text l_arrayType;
      Tpl.Text l_arrName;

    case ( txt,
           false,
           _,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        l_arrName = contextArrayCrefXml(Tpl.emptyTxt, a_cr, a_context);
        l_arrayType = expTypeArrayXml(Tpl.emptyTxt, a_ty);
        (l_tmp, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_arrayType), a_varDecls);
        ret_4 = ComponentReference.crefSubs(a_cr);
        (l_spec1, a_preExp, a_varDecls) = daeExpCrefRhsIndexSpecXml(Tpl.emptyTxt, ret_4, a_context, a_preExp, a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_arrName);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_spec1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_ecr,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        ret_5 = ComponentReference.crefStripLastSubs(a_cr);
        l_arrName = contextCrefXml(Tpl.emptyTxt, ret_5, a_context);
        l_arrayType = expTypeArrayXml(Tpl.emptyTxt, a_ty);
        ret_7 = ComponentReference.crefSubs(a_cr);
        ret_8 = listLength(ret_7);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_8));
        str_9 = Tpl.textString(l_arrayType);
        (txt, a_varDecls, a_preExp) = fun_272(txt, str_9, a_ecr, l_arrName, a_varDecls, a_preExp, a_context, a_cr);
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_273;

protected function fun_274
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_ecr_componentRef, in_a_ecr, in_a_preExp, in_a_varDecls, in_a_ty, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      DAE.Exp a_ecr;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Boolean ret_0;

    case ( txt,
           false,
           _,
           a_ecr,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        ret_0 = SimCodeUtil.crefSubIsScalar(a_cr);
        (txt, a_preExp, a_varDecls) = fun_273(txt, ret_0, a_ecr, a_preExp, a_varDecls, a_ty, a_context, a_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_ecr_componentRef,
           _,
           a_preExp,
           a_varDecls,
           _,
           _,
           _ )
      equation
        txt = crefXml(txt, a_ecr_componentRef);
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_274;

protected function fun_275
  input Tpl.Text in_txt;
  input Tpl.Text in_a_box;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_box, in_a_ecr_componentRef, in_a_ecr, in_a_preExp, in_a_varDecls, in_a_ty, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      DAE.Exp a_ecr;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text i_box;
      Boolean ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_ecr_componentRef,
           a_ecr,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        ret_0 = SimCodeUtil.crefIsScalar(a_cr, a_context);
        (txt, a_preExp, a_varDecls) = fun_274(txt, ret_0, a_ecr_componentRef, a_ecr, a_preExp, a_varDecls, a_ty, a_context, a_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_box,
           _,
           _,
           a_preExp,
           a_varDecls,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, i_box);
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_275;

public function daeExpCrefRhs2Xml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_ecr_componentRef;
      DAE.Type i_ty;
      DAE.ComponentRef i_cr;
      DAE.Exp i_ecr;
      Tpl.Text txt_1;
      String ret_1;
      Tpl.Text l_box;

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = (i_ecr_componentRef as i_cr), ty = i_ty)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_box, a_preExp, a_varDecls) = daeExpCrefRhsArrayBoxXml(Tpl.emptyTxt, i_ecr, a_context, a_preExp, a_varDecls);
        (txt, a_preExp, a_varDecls) = fun_275(txt, l_box, i_ecr_componentRef, i_ecr, a_preExp, a_varDecls, i_ty, a_context, i_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_ecr,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("daeExpCrefRhs2: UNHANDLED EXPRESSION: "));
        ret_1 = ExpressionDump.printExpStr(i_ecr);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 2195, 11), Tpl.textString(txt_1));
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpCrefRhs2Xml;

protected function fun_277
  input Tpl.Text in_txt;
  input DAE.Dimension in_a_dim;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dim)
    local
      Tpl.Text txt;
      Integer i_size;
      Integer i_integer;

    case ( txt,
           DAE.DIM_INTEGER(integer = i_integer) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.DIM_ENUM(size = i_size) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
        txt = Tpl.writeStr(txt, intString(i_size));
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 2214, 22), "Non-constant dimension in simulation context");
      then txt;
  end match;
end fun_277;

protected function lm_278
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Dimension> rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = fun_277(txt, i_dim);
        txt = lm_278(txt, rest);
      then txt;
  end match;
end lm_278;

protected function fun_279
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subrest;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input list<DAE.Dimension> in_a_dimrest;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_subrest, in_a_varDecls, in_a_preExp, in_a_context, in_a_dimrest)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      list<DAE.Dimension> a_dimrest;
      list<DAE.Subscript> i_subrest;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_subrest,
           a_varDecls,
           a_preExp,
           a_context,
           a_dimrest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        (txt, a_preExp, a_varDecls) = threadDimSubListXml(txt, a_dimrest, i_subrest, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_279;

protected function fun_280
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_a_dims;
  input list<DAE.Subscript> in_a_subrest;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_sub_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_dims, in_a_subrest, in_a_varDecls, in_a_preExp, in_a_context, in_a_sub_exp)
    local
      Tpl.Text txt;
      list<DAE.Subscript> a_subrest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_sub_exp;
      list<DAE.Dimension> i_dimrest;
      Tpl.Text l_estr;

    case ( txt,
           _ :: i_dimrest,
           a_subrest,
           a_varDecls,
           a_preExp,
           a_context,
           a_sub_exp )
      equation
        (l_estr, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_sub_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(("));
        txt = Tpl.writeText(txt, l_estr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = lm_278(txt, i_dimrest);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        (txt, a_varDecls, a_preExp) = fun_279(txt, a_subrest, a_varDecls, a_preExp, a_context, i_dimrest);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 2216, 18), "Less subscripts that dimensions in indexing cref? That\'s odd!");
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_280;

protected function fun_281
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subs;
  input list<DAE.Dimension> in_a_dims;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_subs, in_a_dims, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Dimension> a_dims;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.Subscript> i_subrest;
      DAE.Exp i_sub_exp;

    case ( txt,
           {},
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 2202, 22), "Empty dimensions in indexing cref?");
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.INDEX(exp = i_sub_exp) :: i_subrest,
           a_dims,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_280(txt, a_dims, i_subrest, a_varDecls, a_preExp, a_context, i_sub_exp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 2217, 14), "Non-index subscript in indexing cref? That\'s odd!");
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_281;

public function threadDimSubListXml
  input Tpl.Text txt;
  input list<DAE.Dimension> a_dims;
  input list<DAE.Subscript> a_subs;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) := fun_281(txt, a_subs, a_dims, a_context, a_preExp, a_varDecls);
end threadDimSubListXml;

protected function fun_283
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_sub;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_sub, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;
      Tpl.Text l_tmp;
      Tpl.Text l_str;
      Tpl.Text l_expPart;

    case ( txt,
           DAE.INDEX(exp = i_exp),
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        l_str = Tpl.writeText(Tpl.emptyTxt, l_expPart);
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.WHOLEDIM(),
           a_varDecls,
           a_preExp,
           _ )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(1), (int*)0, \'W\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.SLICE(exp = i_exp),
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (l_tmp, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_integer", a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = size_of_dimension_integer_array("));
        a_preExp = Tpl.writeText(a_preExp, l_expPart);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", 1);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(int) "));
        l_str = Tpl.writeText(l_str, l_tmp);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING(", integer_array_make_index_array(&"));
        l_str = Tpl.writeText(l_str, l_expPart);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("), \'A\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_283;

protected function lm_284
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Subscript i_sub;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_sub :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = fun_283(txt, i_sub, a_varDecls, a_preExp, a_context);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_284(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_284;

public function daeExpCrefRhsIndexSpecXml
  input Tpl.Text txt;
  input list<DAE.Subscript> a_subs;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_tmp;
  Tpl.Text l_idx__str;
  Integer ret_1;
  Tpl.Text l_nridx__str;
algorithm
  ret_1 := listLength(a_subs);
  l_nridx__str := Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
  l_idx__str := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_idx__str, out_a_varDecls, out_a_preExp) := lm_284(l_idx__str, a_subs, a_varDecls, a_preExp, a_context);
  l_idx__str := Tpl.popIter(l_idx__str);
  (l_tmp, out_a_varDecls) := tempDeclXml(Tpl.emptyTxt, "index_spec_t", out_a_varDecls);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING("create_index_spec(&"));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_tmp);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(", "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_nridx__str);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(", "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_idx__str);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(");"));
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_tmp);
end daeExpCrefRhsIndexSpecXml;

protected function lm_286
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimensionXml(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_286(txt, rest);
      then txt;
  end match;
end lm_286;

protected function fun_287
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input Tpl.Text in_a_preExp;
  input DAE.Dimensions in_a_dims;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_aty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_context, in_a_ecr_componentRef, in_a_preExp, in_a_dims, in_a_varDecls, in_a_aty)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      Tpl.Text a_preExp;
      DAE.Dimensions a_dims;
      Tpl.Text a_varDecls;
      DAE.Type a_aty;
      Tpl.Text l_type;
      Tpl.Text l_dimsValuesStr;
      Integer ret_3;
      Tpl.Text l_dimsLenStr;
      Tpl.Text txt_1;
      Tpl.Text l_tmpArr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           _,
           a_preExp,
           _,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_ecr_componentRef,
           a_preExp,
           a_dims,
           a_varDecls,
           a_aty )
      equation
        txt_1 = expTypeArrayXml(Tpl.emptyTxt, a_aty);
        (l_tmpArr, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        ret_3 = listLength(a_dims);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dimsValuesStr = lm_286(l_dimsValuesStr, a_dims);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        l_type = expTypeShortXml(Tpl.emptyTxt, a_aty);
        a_preExp = arrayCrefXmlStr(a_preExp, a_ecr_componentRef);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpArr);
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_287;

public function daeExpCrefRhsArrayBoxXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_ecr_componentRef;
      DAE.Dimensions i_dims;
      DAE.Type i_aty;

    case ( txt,
           DAE.CREF(ty = DAE.T_ARRAY(ty = i_aty, dims = i_dims), componentRef = i_ecr_componentRef),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = fun_287(txt, a_context, i_ecr_componentRef, a_preExp, i_dims, a_varDecls, i_aty);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpCrefRhsArrayBoxXml;

protected function lm_289
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      DAE.Var i_v;
      DAE.Exp ret_0;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_v :: rest,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        ret_0 = SimCodeUtil.makeCrefRecordExp(a_cr, i_v);
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, ret_0, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_289(txt, rest, a_varDecls, a_preExp, a_context, a_cr);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_289;

public function daeExpRecordCrefRhsXml
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_ty, in_a_cr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.Var> i_var__lst;
      Tpl.Text l_vars;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = _, varLst = i_var__lst),
           a_cr,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        l_vars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                 "\n",
                                                                                 " "
                                                                             }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_vars, a_varDecls, a_preExp) = lm_289(l_vars, i_var__lst, a_varDecls, a_preExp, a_context, a_cr);
        l_vars = Tpl.popIter(l_vars);
        txt = Tpl.writeText(txt, l_vars);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpRecordCrefRhsXml;

protected function fun_291
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  match(in_txt, in_a_context, in_a_cr, in_a_t, in_a_varDecls, in_a_afterExp, in_a_exp)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      DAE.Type a_t;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      DAE.Exp a_exp;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           _,
           _,
           a_varDecls,
           a_afterExp,
           a_exp )
      equation
        (txt, a_afterExp, a_varDecls) = daeExpCrefLhs2Xml(txt, a_exp, i_context, a_afterExp, a_varDecls);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_context,
           a_cr,
           a_t,
           a_varDecls,
           a_afterExp,
           _ )
      equation
        (txt, a_afterExp, a_varDecls) = daeExpRecordCrefLhsXml(txt, a_t, a_cr, i_context, a_afterExp, a_varDecls);
      then (txt, a_varDecls, a_afterExp);
  end match;
end fun_291;

public function daeExpCrefLhsXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_afterExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_afterExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_afterExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cr;
      DAE.Type i_t;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.CREF(componentRef = i_cr, ty = (i_t as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _))))),
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_afterExp) = fun_291(txt, a_context, i_cr, i_t, a_varDecls, a_afterExp, i_exp);
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_FUNC(builtin = _)),
           _,
           a_afterExp,
           a_varDecls )
      equation
        txt = crefFunctionNameXml(txt, i_cr);
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_VAR(functionType = _)),
           _,
           a_afterExp,
           a_varDecls )
      equation
        txt = crefStrXml(txt, i_cr);
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           i_exp,
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        (txt, a_afterExp, a_varDecls) = daeExpCrefLhs2Xml(txt, i_exp, a_context, a_afterExp, a_varDecls);
      then (txt, a_afterExp, a_varDecls);
  end match;
end daeExpCrefLhsXml;

protected function lm_293
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (txt, a_afterExp, a_varDecls) = daeExpXml(txt, i_exp, a_context, a_afterExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_293(txt, rest, a_varDecls, a_afterExp, a_context);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (txt, a_varDecls, a_afterExp) = lm_293(txt, rest, a_varDecls, a_afterExp, a_context);
      then (txt, a_varDecls, a_afterExp);
  end match;
end lm_293;

protected function fun_294
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_dimsValuesStr;
  input Tpl.Text in_a_arrName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_dimsValuesStr, in_a_arrName)
    local
      Tpl.Text txt;
      Tpl.Text a_dimsValuesStr;
      Tpl.Text a_arrName;

    case ( txt,
           "metatype_array",
           a_dimsValuesStr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /* DAE.CREF */"));
      then txt;

    case ( txt,
           _,
           a_dimsValuesStr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Identifier>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:QualifiedNamePart name=\""));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <exp:ArraySubscripts>\n",
                                    "    <exp:IndexExpression>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    </exp:IndexExpression>\n",
                                    "  </exp:ArraySubscripts>\n",
                                    "</exp:QualifiedNamePart>\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Identifier>"));
      then txt;
  end match;
end fun_294;

protected function fun_295
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_afterExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  match(in_txt, in_mArg, in_a_varDecls, in_a_ty, in_a_context, in_a_cr, in_a_ecr, in_a_afterExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      DAE.Exp a_ecr;
      Tpl.Text a_afterExp;
      String str_13;
      list<DAE.Subscript> ret_12;
      Tpl.Text l_dimsValuesStr;
      Integer ret_10;
      list<DAE.Subscript> ret_9;
      Tpl.Text l_dimsLenStr;
      DAE.ComponentRef ret_7;
      String ret_6;
      list<DAE.Subscript> ret_5;
      Tpl.Text l_spec1;
      Tpl.Text l_tmp;
      Tpl.Text l_arrayType;
      Tpl.Text l_arrName;
      String ret_0;

    case ( txt,
           false,
           a_varDecls,
           a_ty,
           a_context,
           a_cr,
           a_ecr,
           a_afterExp )
      equation
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("/* daeExpCrefLhs2 SLICE("));
        ret_0 = ExpressionDump.printExpStr(a_ecr);
        a_afterExp = Tpl.writeStr(a_afterExp, ret_0);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(") afterExp  */"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        l_arrName = contextArrayCrefXml(Tpl.emptyTxt, a_cr, a_context);
        l_arrayType = expTypeArrayXml(Tpl.emptyTxt, a_ty);
        (l_tmp, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_arrayType), a_varDecls);
        ret_5 = ComponentReference.crefSubs(a_cr);
        (l_spec1, a_afterExp, a_varDecls) = daeExpCrefLhsIndexSpecXml(Tpl.emptyTxt, ret_5, a_context, a_afterExp, a_varDecls);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("indexed_assign_"));
        a_afterExp = Tpl.writeText(a_afterExp, l_arrayType);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("(&"));
        a_afterExp = Tpl.writeText(a_afterExp, l_tmp);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", &"));
        a_afterExp = Tpl.writeText(a_afterExp, l_arrName);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", &"));
        a_afterExp = Tpl.writeText(a_afterExp, l_spec1);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(");"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _,
           a_varDecls,
           a_ty,
           a_context,
           a_cr,
           a_ecr,
           a_afterExp )
      equation
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("/* daeExpCrefLhs2 SCALAR("));
        ret_6 = ExpressionDump.printExpStr(a_ecr);
        a_afterExp = Tpl.writeStr(a_afterExp, ret_6);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(") afterExp  */"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        ret_7 = ComponentReference.crefStripLastSubs(a_cr);
        l_arrName = contextCrefXml(Tpl.emptyTxt, ret_7, a_context);
        l_arrayType = expTypeArrayXml(Tpl.emptyTxt, a_ty);
        ret_9 = ComponentReference.crefSubs(a_cr);
        ret_10 = listLength(ret_9);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_10));
        ret_12 = ComponentReference.crefSubs(a_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_varDecls, a_afterExp) = lm_293(l_dimsValuesStr, ret_12, a_varDecls, a_afterExp, a_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        str_13 = Tpl.textString(l_arrayType);
        txt = fun_294(txt, str_13, l_dimsValuesStr, l_arrName);
      then (txt, a_varDecls, a_afterExp);
  end match;
end fun_295;

protected function fun_296
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_afterExp;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  match(in_txt, in_mArg, in_a_varDecls, in_a_ty, in_a_context, in_a_ecr, in_a_afterExp, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.Exp a_ecr;
      Tpl.Text a_afterExp;
      DAE.ComponentRef a_cr;
      Boolean ret_0;

    case ( txt,
           false,
           a_varDecls,
           a_ty,
           a_context,
           a_ecr,
           a_afterExp,
           a_cr )
      equation
        ret_0 = SimCodeUtil.crefSubIsScalar(a_cr);
        (txt, a_varDecls, a_afterExp) = fun_295(txt, ret_0, a_varDecls, a_ty, a_context, a_cr, a_ecr, a_afterExp);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _,
           a_varDecls,
           _,
           a_context,
           _,
           a_afterExp,
           a_cr )
      equation
        txt = contextCrefXml(txt, a_cr, a_context);
      then (txt, a_varDecls, a_afterExp);
  end match;
end fun_296;

protected function fun_297
  input Tpl.Text in_txt;
  input Tpl.Text in_a_box;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  match(in_txt, in_a_box, in_a_varDecls, in_a_ty, in_a_ecr, in_a_afterExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      DAE.Exp a_ecr;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text i_box;
      Boolean ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_varDecls,
           a_ty,
           a_ecr,
           a_afterExp,
           a_context,
           a_cr )
      equation
        ret_0 = SimCodeUtil.crefIsScalar(a_cr, a_context);
        (txt, a_varDecls, a_afterExp) = fun_296(txt, ret_0, a_varDecls, a_ty, a_context, a_ecr, a_afterExp, a_cr);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_box,
           a_varDecls,
           _,
           _,
           a_afterExp,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, i_box);
      then (txt, a_varDecls, a_afterExp);
  end match;
end fun_297;

public function daeExpCrefLhs2Xml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_afterExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  match(in_txt, in_a_ecr, in_a_context, in_a_afterExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_afterExp;
      Tpl.Text a_varDecls;
      DAE.Type i_ty;
      DAE.ComponentRef i_cr;
      DAE.Exp i_ecr;
      String ret_3;
      String ret_2;
      Tpl.Text l_box;
      String ret_0;

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = i_cr, ty = i_ty)),
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("/* daeExpCrefLhs2 begin afterExp ("));
        ret_0 = ExpressionDump.printExpStr(i_ecr);
        a_afterExp = Tpl.writeStr(a_afterExp, ret_0);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(") */"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        (l_box, a_afterExp, a_varDecls) = daeExpCrefLhsArrayBoxXml(Tpl.emptyTxt, i_ecr, a_context, a_afterExp, a_varDecls);
        (txt, a_varDecls, a_afterExp) = fun_297(txt, l_box, a_varDecls, i_ty, i_ecr, a_afterExp, a_context, i_cr);
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           i_ecr,
           _,
           a_afterExp,
           a_varDecls )
      equation
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("/* daeExpCrefLhs2 UNHANDLED("));
        ret_2 = ExpressionDump.printExpStr(i_ecr);
        a_afterExp = Tpl.writeStr(a_afterExp, ret_2);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(") afterExp */"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* SimCodeC.tpl template: daeExpCrefLhs2: UNHANDLED EXPRESSION:\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* "));
        ret_3 = ExpressionDump.printExpStr(i_ecr);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
        txt = Tpl.popBlock(txt);
      then (txt, a_afterExp, a_varDecls);
  end match;
end daeExpCrefLhs2Xml;

protected function fun_299
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_sub;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  match(in_txt, in_a_sub, in_a_varDecls, in_a_afterExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;
      Tpl.Text l_tmp;
      Tpl.Text l_str;
      Tpl.Text l_expPart;

    case ( txt,
           DAE.INDEX(exp = i_exp),
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (l_expPart, a_afterExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, a_afterExp, a_varDecls);
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(0), make_index_array(1, (int) "));
        l_str = Tpl.writeText(l_str, l_expPart);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("), \'S\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           DAE.WHOLEDIM(),
           a_varDecls,
           a_afterExp,
           _ )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(1), (int*)0, \'W\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           DAE.SLICE(exp = i_exp),
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (l_expPart, a_afterExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, a_afterExp, a_varDecls);
        (l_tmp, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_integer", a_varDecls);
        a_afterExp = Tpl.writeText(a_afterExp, l_tmp);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(" = size_of_dimension_integer_array("));
        a_afterExp = Tpl.writeText(a_afterExp, l_expPart);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", 1);"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(int) "));
        l_str = Tpl.writeText(l_str, l_tmp);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING(", integer_array_make_index_array(&"));
        l_str = Tpl.writeText(l_str, l_expPart);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("), \'A\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _,
           a_varDecls,
           a_afterExp,
           _ )
      then (txt, a_varDecls, a_afterExp);
  end match;
end fun_299;

protected function lm_300
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.Subscript i_sub;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_sub :: rest,
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (txt, a_varDecls, a_afterExp) = fun_299(txt, i_sub, a_varDecls, a_afterExp, a_context);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_300(txt, rest, a_varDecls, a_afterExp, a_context);
      then (txt, a_varDecls, a_afterExp);
  end match;
end lm_300;

public function daeExpCrefLhsIndexSpecXml
  input Tpl.Text txt;
  input list<DAE.Subscript> a_subs;
  input SimCode.Context a_context;
  input Tpl.Text a_afterExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_tmp;
  Tpl.Text l_idx__str;
  Integer ret_1;
  Tpl.Text l_nridx__str;
algorithm
  ret_1 := listLength(a_subs);
  l_nridx__str := Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
  l_idx__str := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_idx__str, out_a_varDecls, out_a_afterExp) := lm_300(l_idx__str, a_subs, a_varDecls, a_afterExp, a_context);
  l_idx__str := Tpl.popIter(l_idx__str);
  (l_tmp, out_a_varDecls) := tempDeclXml(Tpl.emptyTxt, "index_spec_t", out_a_varDecls);
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_STRING("create_index_spec(&"));
  out_a_afterExp := Tpl.writeText(out_a_afterExp, l_tmp);
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_STRING(", "));
  out_a_afterExp := Tpl.writeText(out_a_afterExp, l_nridx__str);
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_STRING(", "));
  out_a_afterExp := Tpl.writeText(out_a_afterExp, l_idx__str);
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_STRING(");"));
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_tmp);
end daeExpCrefLhsIndexSpecXml;

protected function lm_302
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimensionXml(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_302(txt, rest);
      then txt;
  end match;
end lm_302;

protected function fun_303
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input Tpl.Text in_a_afterExp;
  input DAE.Dimensions in_a_dims;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_aty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  match(in_txt, in_a_context, in_a_ecr_componentRef, in_a_afterExp, in_a_dims, in_a_varDecls, in_a_aty)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      Tpl.Text a_afterExp;
      DAE.Dimensions a_dims;
      Tpl.Text a_varDecls;
      DAE.Type a_aty;
      Tpl.Text l_type;
      Tpl.Text l_dimsValuesStr;
      Integer ret_3;
      Tpl.Text l_dimsLenStr;
      Tpl.Text txt_1;
      Tpl.Text l_tmpArr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           _,
           a_afterExp,
           _,
           a_varDecls,
           _ )
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           _,
           a_ecr_componentRef,
           a_afterExp,
           a_dims,
           a_varDecls,
           a_aty )
      equation
        txt_1 = expTypeArrayXml(Tpl.emptyTxt, a_aty);
        (l_tmpArr, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        ret_3 = listLength(a_dims);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dimsValuesStr = lm_302(l_dimsValuesStr, a_dims);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        l_type = expTypeShortXml(Tpl.emptyTxt, a_aty);
        a_afterExp = Tpl.writeText(a_afterExp, l_type);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("_array_create(&"));
        a_afterExp = Tpl.writeText(a_afterExp, l_tmpArr);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", ((modelica_"));
        a_afterExp = Tpl.writeText(a_afterExp, l_type);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("*)&("));
        a_afterExp = arrayCrefXmlStr(a_afterExp, a_ecr_componentRef);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(")), "));
        a_afterExp = Tpl.writeText(a_afterExp, l_dimsLenStr);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", "));
        a_afterExp = Tpl.writeText(a_afterExp, l_dimsValuesStr);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(");"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpArr);
      then (txt, a_afterExp, a_varDecls);
  end match;
end fun_303;

public function daeExpCrefLhsArrayBoxXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_afterExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  match(in_txt, in_a_ecr, in_a_context, in_a_afterExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_afterExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_ecr_componentRef;
      DAE.Dimensions i_dims;
      DAE.Type i_aty;

    case ( txt,
           DAE.CREF(ty = DAE.T_ARRAY(ty = i_aty, dims = i_dims), componentRef = i_ecr_componentRef),
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        (txt, a_afterExp, a_varDecls) = fun_303(txt, a_context, i_ecr_componentRef, a_afterExp, i_dims, a_varDecls, i_aty);
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_afterExp,
           a_varDecls )
      then (txt, a_afterExp, a_varDecls);
  end match;
end daeExpCrefLhsArrayBoxXml;

protected function lm_305
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      DAE.Var i_v;
      DAE.Exp ret_0;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_v :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_cr )
      equation
        ret_0 = SimCodeUtil.makeCrefRecordExp(a_cr, i_v);
        (txt, a_afterExp, a_varDecls) = daeExpXml(txt, ret_0, a_context, a_afterExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_305(txt, rest, a_varDecls, a_afterExp, a_context, a_cr);
      then (txt, a_varDecls, a_afterExp);
  end match;
end lm_305;

public function daeExpRecordCrefLhsXml
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_afterExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  match(in_txt, in_a_ty, in_a_cr, in_a_context, in_a_afterExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      SimCode.Context a_context;
      Tpl.Text a_afterExp;
      Tpl.Text a_varDecls;
      ClassInf.State i_record__state;
      list<DAE.Var> i_var__lst;
      Tpl.Text l_ret__var;
      Tpl.Text l_ret__type;
      Absyn.Path ret_2;
      Tpl.Text l_record__type__name;
      Tpl.Text l_vars;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_record__state, varLst = i_var__lst),
           a_cr,
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        l_vars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_vars, a_varDecls, a_afterExp) = lm_305(l_vars, i_var__lst, a_varDecls, a_afterExp, a_context, a_cr);
        l_vars = Tpl.popIter(l_vars);
        ret_2 = ClassInf.getStateName(i_record__state);
        l_record__type__name = underscorePathXml(Tpl.emptyTxt, ret_2);
        l_ret__type = Tpl.writeText(Tpl.emptyTxt, l_record__type__name);
        l_ret__type = Tpl.writeTok(l_ret__type, Tpl.ST_STRING("_rettype"));
        (l_ret__var, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_ret__type), a_varDecls);
        a_afterExp = Tpl.writeText(a_afterExp, l_ret__var);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(" = _"));
        a_afterExp = Tpl.writeText(a_afterExp, l_record__type__name);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("("));
        a_afterExp = Tpl.writeText(a_afterExp, l_vars);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(");"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_ret__var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, l_ret__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_afterExp,
           a_varDecls )
      then (txt, a_afterExp, a_varDecls);
  end match;
end daeExpRecordCrefLhsXml;

protected function fun_307
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end match;
end fun_307;

protected function fun_308
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end match;
end fun_308;

protected function fun_309
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end match;
end fun_309;

protected function fun_310
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_scalar"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_scalar"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_scalar"));
      then txt;
  end match;
end fun_310;

protected function fun_311
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real"));
      then txt;
  end match;
end fun_311;

protected function fun_312
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end match;
end fun_312;

protected function fun_313
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_operator, in_a_varDecls, in_a_preExp, in_a_context, in_a_exp, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_exp;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      DAE.Type i_ty;
      Tpl.Text l_typeShort;
      Tpl.Text l_var;
      Tpl.Text l_type;

    case ( txt,
           DAE.ADD(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Add>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Add>"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.SUB(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Sub>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Sub>"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.MUL(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Mul>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Mul>"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.DIV(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Div>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Div>"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.POW(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Pow>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Pow>"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.UMINUS(ty = _),
           a_varDecls,
           a_preExp,
           a_context,
           a_exp,
           _,
           _ )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnaryXml(txt, a_exp, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.ADD_ARR(ty = i_ty),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        l_type = fun_307(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:Add>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:Add> "));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.SUB_ARR(ty = i_ty),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        l_type = fun_308(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:Sub>\n"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:Sub> "));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.MUL_ARR(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for MUL_ARR"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.DIV_ARR(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for DIV_ARR"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.MUL_ARRAY_SCALAR(ty = i_ty),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        l_type = fun_309(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:Mul>\n"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:Mul> "));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.ADD_ARRAY_SCALAR(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for ADD_ARRAY_SCALAR"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.SUB_SCALAR_ARRAY(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for SUB_SCALAR_ARRAY"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.MUL_SCALAR_PRODUCT(ty = i_ty),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        l_type = fun_310(Tpl.emptyTxt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mul_"));
        txt = Tpl.writeText(txt, l_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_product(&"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.MUL_MATRIX_PRODUCT(ty = i_ty),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        l_typeShort = fun_311(Tpl.emptyTxt, i_ty);
        l_type = Tpl.writeText(Tpl.emptyTxt, l_typeShort);
        l_type = Tpl.writeTok(l_type, Tpl.ST_STRING("_array"));
        (l_var, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:Mul>\n"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:Mul> "));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.DIV_ARRAY_SCALAR(ty = i_ty),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        l_type = fun_312(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:Div>\n"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:Div> "));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.DIV_SCALAR_ARRAY(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for DIV_SCALAR_ARRAY"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.POW_ARRAY_SCALAR(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for POW_ARRAY_SCALAR"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.POW_SCALAR_ARRAY(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for POW_SCALAR_ARRAY"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.POW_ARR(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for POW_ARR"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.POW_ARR2(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for POW_ARR2"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR"));
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_313;

public function daeExpBinaryXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           (i_exp as DAE.BINARY(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp2, a_context, a_preExp, a_varDecls);
        (txt, a_varDecls, a_preExp) = fun_313(txt, i_operator, a_varDecls, a_preExp, a_context, i_exp, l_e2, l_e1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpBinaryXml;

protected function fun_315
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_operator, in_a_e)
    local
      Tpl.Text txt;
      Tpl.Text a_e;

    case ( txt,
           DAE.UMINUS(ty = _),
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  <exp:Neg>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  </exp:Neg>"));
      then txt;

    case ( txt,
           DAE.UMINUS_ARR(ty = DAE.T_ARRAY(ty = DAE.T_REAL(varLst = _))),
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  <exp:Neg>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  </exp:Neg>"));
      then txt;

    case ( txt,
           DAE.UMINUS_ARR(ty = _),
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 2597, 34), "unary minus for non-real arrays not implemented");
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 2598, 14), "daeExpUnary:ERR");
      then txt;
  end match;
end fun_315;

public function daeExpUnaryXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_operator;
      DAE.Exp i_exp;
      Tpl.Text l_e;

    case ( txt,
           DAE.UNARY(exp = i_exp, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        txt = fun_315(txt, i_operator, l_e);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpUnaryXml;

protected function fun_317
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_operator, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.AND(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:And>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:And>"));
      then txt;

    case ( txt,
           DAE.OR(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Or>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Or>"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpLbinary:ERR"));
      then txt;
  end match;
end fun_317;

public function daeExpLbinaryXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           DAE.LBINARY(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp2, a_context, a_preExp, a_varDecls);
        txt = fun_317(txt, i_operator, l_e2, l_e1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpLbinaryXml;

protected function fun_319
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_operator, in_a_e)
    local
      Tpl.Text txt;
      Tpl.Text a_e;

    case ( txt,
           DAE.NOT(ty = _),
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Not>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Not>"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_319;

public function daeExpLunaryXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_operator;
      DAE.Exp i_exp;
      Tpl.Text l_e;

    case ( txt,
           DAE.LUNARY(exp = i_exp, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        txt = fun_319(txt, i_operator, l_e);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpLunaryXml;

protected function fun_321
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_rel_operator, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.LESS(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringCompare("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") < 0)"));
      then txt;

    case ( txt,
           DAE.LESS(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:LogLt>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:LogLt>"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringCompare("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") > 0)"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:LogGt>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:LogGt>"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringCompare("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") <= 0)"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:LogLeq>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:LogLeq>"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringCompare("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") >= 0)"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:LogGeq>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:LogGeq>"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") || ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringEqual("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:LogEq>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:LogEq>"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") || ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!stringEqual("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:LogNeq>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:LogNeq>"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpRelation:ERR"));
      then txt;
  end match;
end fun_321;

protected function fun_322
  input Tpl.Text in_txt;
  input Tpl.Text in_a_simRel;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_simRel, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_context, in_a_rel_exp1)
    local
      Tpl.Text txt;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      Tpl.Text i_simRel;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        txt = fun_321(txt, a_rel_operator, l_e2, l_e1);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_simRel,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, i_simRel);
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_322;

public function daeExpRelationXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_rel_operator;
      DAE.Exp i_rel_exp2;
      DAE.Exp i_rel_exp1;
      DAE.Exp i_rel;
      Tpl.Text l_simRel;

    case ( txt,
           (i_rel as DAE.RELATION(exp1 = i_rel_exp1, exp2 = i_rel_exp2, operator = i_rel_operator)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_simRel, a_preExp, a_varDecls) = daeExpRelationSimXml(Tpl.emptyTxt, i_rel, a_context, a_preExp, a_varDecls);
        (txt, a_varDecls, a_preExp) = fun_322(txt, l_simRel, i_rel_operator, i_rel_exp2, a_varDecls, a_preExp, a_context, i_rel_exp1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpRelationXml;

protected function fun_324
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_rel_operator, in_a_res, in_a_e2, in_a_e1, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_res;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_preExp;

    case ( txt,
           DAE.LESS(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:LogLt>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogLt> "));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:LogLeq>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogLeq> "));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATER(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:LogGt>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogGt> "));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:LogGeq>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogGeq> "));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end match;
end fun_324;

protected function fun_325
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_rel_operator, in_a_res, in_a_e2, in_a_e1, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_res;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_preExp;

    case ( txt,
           DAE.LESS(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("  <exp:LogLt>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(4));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogLt>"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("  <exp:LogLeq>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(4));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("<exp:LogLeq> "));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATER(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("  <exp:LogGt>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(4));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogGt>"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("  <exp:LogGeq>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(4));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogGeq>"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end match;
end fun_325;

protected function fun_326
  input Tpl.Text in_txt;
  input Option<tuple<DAE.Exp, Integer, Integer>> in_a_rel_optionExpisASUB;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_rel_optionExpisASUB, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_context, in_a_rel_exp1)
    local
      Tpl.Text txt;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      DAE.Exp i_exp;
      Tpl.Text l_iterator;
      Tpl.Text l_res;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           NONE(),
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        (txt, a_preExp) = fun_324(txt, a_rel_operator, l_res, l_e2, l_e1, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           SOME((i_exp, _, _)),
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_iterator, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        (txt, a_preExp) = fun_325(txt, a_rel_operator, l_res, l_e2, l_e1, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_326;

protected function fun_327
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_rel_operator, in_a_res, in_a_e2, in_a_e1, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_res;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_preExp;

    case ( txt,
           DAE.LESS(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:LogLt>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogLt>"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:LogLeq>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogLeq> "));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATER(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:LogGt>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogGt>"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:LogGeq>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogGeq>"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end match;
end fun_327;

protected function fun_328
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_rel_operator, in_a_res, in_a_e2, in_a_e1, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_res;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_preExp;

    case ( txt,
           DAE.LESS(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("    <exp:LogLt>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(6));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(4));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogLt>"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("    <exp:LogLeq>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(6));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(4));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogLeq> "));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATER(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("    <exp:LogGt>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(6));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(4));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogGt>"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_res,
           a_e2,
           a_e1,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("    <exp:LogGeq>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(6));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(4));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:LogGeq>"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end match;
end fun_328;

protected function fun_329
  input Tpl.Text in_txt;
  input Option<tuple<DAE.Exp, Integer, Integer>> in_a_rel_optionExpisASUB;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_rel_optionExpisASUB, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_context, in_a_rel_exp1)
    local
      Tpl.Text txt;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      DAE.Exp i_exp;
      Tpl.Text l_iterator;
      Tpl.Text l_res;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           NONE(),
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        (txt, a_preExp) = fun_327(txt, a_rel_operator, l_res, l_e2, l_e1, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           SOME((i_exp, _, _)),
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        (l_iterator, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (txt, a_preExp) = fun_328(txt, a_rel_operator, l_res, l_e2, l_e1, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_329;

protected function fun_330
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_rel_exp1;
  input Option<tuple<DAE.Exp, Integer, Integer>> in_a_rel_optionExpisASUB;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_rel_exp1, in_a_rel_optionExpisASUB)
    local
      Tpl.Text txt;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp a_rel_exp1;
      Option<tuple<DAE.Exp, Integer, Integer>> a_rel_optionExpisASUB;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.SIMULATION_CONTEXT(genDiscrete = false)),
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_rel_exp1,
           a_rel_optionExpisASUB )
      equation
        (txt, a_varDecls, a_preExp) = fun_326(txt, a_rel_optionExpisASUB, a_rel_operator, a_rel_exp2, a_varDecls, a_preExp, i_context, a_rel_exp1);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_context as SimCode.SIMULATION_CONTEXT(genDiscrete = true)),
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_rel_exp1,
           a_rel_optionExpisASUB )
      equation
        (txt, a_varDecls, a_preExp) = fun_329(txt, a_rel_optionExpisASUB, a_rel_operator, a_rel_exp2, a_varDecls, a_preExp, i_context, a_rel_exp1);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_330;

public function daeExpRelationSimXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_rel_operator;
      DAE.Exp i_rel_exp2;
      DAE.Exp i_rel_exp1;
      Option<tuple<DAE.Exp, Integer, Integer>> i_rel_optionExpisASUB;

    case ( txt,
           DAE.RELATION(optionExpisASUB = i_rel_optionExpisASUB, exp1 = i_rel_exp1, exp2 = i_rel_exp2, operator = i_rel_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_330(txt, a_context, i_rel_operator, i_rel_exp2, a_varDecls, a_preExp, i_rel_exp1, i_rel_optionExpisASUB);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpRelationSimXml;

protected function fun_332
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_rel_operator, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.EQUAL(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<opt:ConstraintEqu>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</opt:ConstraintEqu> "));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<opt:ConstraintLeq>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</opt:ConstraintLeq> "));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<opt:ConstraintGeq>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</opt:ConstraintGeq> "));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  \"The XML schema does only support =, >= , <=  operators for constraints\""));
      then txt;
  end match;
end fun_332;

protected function fun_333
  input Tpl.Text in_txt;
  input Option<tuple<DAE.Exp, Integer, Integer>> in_a_rel_optionExpisASUB;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_rel_optionExpisASUB, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_context, in_a_rel_exp1)
    local
      Tpl.Text txt;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      Tpl.Text l_res;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           NONE(),
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        txt = fun_332(txt, a_rel_operator, l_e2, l_e1);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_333;

protected function fun_334
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_rel_exp1;
  input Option<tuple<DAE.Exp, Integer, Integer>> in_a_rel_optionExpisASUB;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_rel_exp1, in_a_rel_optionExpisASUB)
    local
      Tpl.Text txt;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp a_rel_exp1;
      Option<tuple<DAE.Exp, Integer, Integer>> a_rel_optionExpisASUB;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.SIMULATION_CONTEXT(genDiscrete = true)),
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_rel_exp1,
           a_rel_optionExpisASUB )
      equation
        (txt, a_varDecls, a_preExp) = fun_333(txt, a_rel_optionExpisASUB, a_rel_operator, a_rel_exp2, a_varDecls, a_preExp, i_context, a_rel_exp1);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_334;

public function daeExpConstraintXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_rel_operator;
      DAE.Exp i_rel_exp2;
      DAE.Exp i_rel_exp1;
      Option<tuple<DAE.Exp, Integer, Integer>> i_rel_optionExpisASUB;

    case ( txt,
           DAE.RELATION(optionExpisASUB = i_rel_optionExpisASUB, exp1 = i_rel_exp1, exp2 = i_rel_exp2, operator = i_rel_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_334(txt, a_context, i_rel_operator, i_rel_exp2, a_varDecls, a_preExp, i_rel_exp1, i_rel_optionExpisASUB);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpConstraintXml;

protected function fun_336
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("x"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_336;

protected function fun_337
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExpElse;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_preExpElse, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp a_exp;
      Boolean ret_1;
      DAE.Type ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_exp )
      equation
        ret_0 = Expression.typeof(a_exp);
        ret_1 = Expression.isArrayType(ret_0);
        txt = fun_336(txt, ret_1);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_337;

protected function fun_338
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExpThen;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_preExpElse;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_preExpThen, in_a_exp, in_a_preExpElse)
    local
      Tpl.Text txt;
      DAE.Exp a_exp;
      Tpl.Text a_preExpElse;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_exp,
           a_preExpElse )
      equation
        txt = fun_337(txt, a_preExpElse, a_exp);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_338;

protected function fun_339
  input Tpl.Text in_txt;
  input Tpl.Text in_a_shortIfExp;
  input Tpl.Text in_a_eElse;
  input Tpl.Text in_a_eThen;
  input Tpl.Text in_a_condExp;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_expThen;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_shortIfExp, in_a_eElse, in_a_eThen, in_a_condExp, in_a_preExp, in_a_expThen, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_eElse;
      Tpl.Text a_eThen;
      Tpl.Text a_condExp;
      Tpl.Text a_preExp;
      DAE.Exp a_expThen;
      Tpl.Text a_varDecls;
      Tpl.Text l_resVar;
      Tpl.Text l_resVarType;
      Tpl.Text l_condVar;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           _,
           _,
           a_preExp,
           a_expThen,
           a_varDecls )
      equation
        (l_condVar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        l_resVarType = expTypeFromExpArrayIfXml(Tpl.emptyTxt, a_expThen);
        (l_resVar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_resVarType), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_resVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_eElse,
           a_eThen,
           a_condExp,
           a_preExp,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<fun:If>\n",
                                    "  <fun:Condition>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_condExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Condition>\n",
                                    "  <fun:Statements>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_eThen);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </fun:Statements>\n",
                                    "</fun:If>\n",
                                    "<fun:Else>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_eElse);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fun:Else>"));
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_339;

public function daeExpIfXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Exp i_expElse;
      DAE.Exp i_expThen;
      DAE.Exp i_expCond;
      Tpl.Text l_shortIfExp;
      Tpl.Text l_eElse;
      Tpl.Text l_preExpElse;
      Tpl.Text l_eThen;
      Tpl.Text l_preExpThen;
      Tpl.Text l_condExp;

    case ( txt,
           (i_exp as DAE.IFEXP(expCond = i_expCond, expThen = i_expThen, expElse = i_expElse)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_condExp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_expCond, a_context, a_preExp, a_varDecls);
        l_preExpThen = Tpl.emptyTxt;
        (l_eThen, l_preExpThen, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_expThen, a_context, l_preExpThen, a_varDecls);
        l_preExpElse = Tpl.emptyTxt;
        (l_eElse, l_preExpElse, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_expElse, a_context, l_preExpElse, a_varDecls);
        l_shortIfExp = fun_338(Tpl.emptyTxt, l_preExpThen, i_exp, l_preExpElse);
        (txt, a_preExp, a_varDecls) = fun_339(txt, l_shortIfExp, l_eElse, l_eThen, l_condExp, a_preExp, i_expThen, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpIfXml;

protected function fun_341
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end match;
end fun_341;

protected function fun_342
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_var1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_var1)
    local
      Tpl.Text txt;
      Tpl.Text a_var1;

    case ( txt,
           false,
           a_var1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("puts("));
        txt = Tpl.writeText(txt, a_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_var1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("print("));
        txt = Tpl.writeText(txt, a_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_342;

protected function lm_343
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_dim;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_dim :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_dim, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_343(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_343;

protected function lm_344
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_array;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_array :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_array, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_344(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_344;

protected function lm_345
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_345(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_345;

protected function fun_346
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_argStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_preExp, in_a_argStr)
    local
      Tpl.Text txt;
      Tpl.Text a_argStr;
      Tpl.Text i_preExp;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_argStr )
      equation
        txt = Tpl.writeText(txt, a_argStr);
      then txt;

    case ( txt,
           i_preExp,
           _ )
      equation
        txt = Tpl.writeText(txt, i_preExp);
      then txt;
  end match;
end fun_346;

protected function fun_347
  input Tpl.Text in_txt;
  input DAE.Type in_a_attr_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_ty)
    local
      Tpl.Text txt;
      DAE.Type i_attr_ty;

    case ( txt,
           DAE.T_NORETCALL(source = _) )
      then txt;

    case ( txt,
           i_attr_ty )
      equation
        txt = expTypeModelicaXml(txt, i_attr_ty);
      then txt;
  end match;
end fun_347;

protected function fun_348
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input DAE.Type in_a_attr_ty;
  input Tpl.Text in_a_funName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_builtin, in_a_attr_ty, in_a_funName)
    local
      Tpl.Text txt;
      DAE.Type a_attr_ty;
      Tpl.Text a_funName;

    case ( txt,
           false,
           _,
           a_funName )
      equation
        txt = Tpl.writeText(txt, a_funName);
      then txt;

    case ( txt,
           _,
           a_attr_ty,
           _ )
      equation
        txt = fun_347(txt, a_attr_ty);
      then txt;
  end match;
end fun_348;

protected function fun_349
  input Tpl.Text in_txt;
  input DAE.Type in_a_attr_ty;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_attr_ty, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           DAE.T_NORETCALL(source = _),
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = tempDeclXml(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end match;
end fun_349;

protected function fun_350
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_builtinFunctionName;
  input Tpl.Text in_a_result;
  input Tpl.Text in_a_funName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_builtin, in_a_builtinFunctionName, in_a_result, in_a_funName)
    local
      Tpl.Text txt;
      Tpl.Text a_builtinFunctionName;
      Tpl.Text a_result;
      Tpl.Text a_funName;

    case ( txt,
           false,
           _,
           a_result,
           a_funName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<exp:FunctionCall>\n",
                                    "  <exp:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_funName);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </exp:Name>\n",
                                    "  <exp:Arguments>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_result);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </exp:Arguments>\n",
                                    "</exp:FunctionCall>"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_builtinFunctionName,
           a_result,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp:"));
        txt = Tpl.writeText(txt, a_builtinFunctionName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_result);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:"));
        txt = Tpl.writeText(txt, a_builtinFunctionName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;
  end match;
end fun_350;

protected function fun_351
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_builtinFunctionName;
  input Tpl.Text in_a_result;
  input Tpl.Text in_a_funName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp, in_a_builtinFunctionName, in_a_result, in_a_funName)
    local
      Tpl.Text txt;
      Tpl.Text a_builtinFunctionName;
      Tpl.Text a_result;
      Tpl.Text a_funName;
      Boolean i_attr_builtin;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = DAE.T_NORETCALL(source = _))),
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* NORETCALL */"));
      then txt;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(tuple_ = false, builtin = i_attr_builtin)),
           a_builtinFunctionName,
           a_result,
           a_funName )
      equation
        txt = fun_350(txt, i_attr_builtin, a_builtinFunctionName, a_result, a_funName);
      then txt;

    case ( txt,
           _,
           _,
           a_result,
           a_funName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<exp:FunctionCall>\n",
                                    "  <exp:Name>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_funName);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </exp:Name>\n",
                                    "  <exp:Arguments>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_result);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </exp:Arguments>\n",
                                    "</exp:FunctionCall>"
                                }, false));
      then txt;
  end match;
end fun_351;

public function daeExpCallXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_call;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_call, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type i_attr_ty;
      Boolean i_attr_builtin;
      Absyn.Path i_path;
      list<String> i_tail_vars;
      list<DAE.Exp> i_expLst;
      Integer i_i;
      DAE.Exp i_s1;
      DAE.Exp i_toBeCasted;
      Integer i_index;
      DAE.Exp i_delayMax;
      DAE.Exp i_d;
      DAE.Exp i_signdig;
      DAE.Exp i_leftjust;
      DAE.Exp i_minlen;
      DAE.Exp i_format;
      DAE.Exp i_s;
      DAE.Exp i_v2;
      DAE.Exp i_v1;
      DAE.Exp i_n;
      DAE.Exp i_A;
      list<DAE.Exp> i_arrays;
      DAE.Exp i_dim;
      DAE.Exp i_call;
      list<DAE.Exp> i_dims;
      DAE.Exp i_val;
      DAE.Exp i_array;
      DAE.Exp i_e;
      DAE.Exp i_arg;
      DAE.ComponentRef i_arg_componentRef;
      DAE.Exp i_exp;
      DAE.Exp i_e3;
      DAE.Type i_ty;
      String i_string;
      DAE.Exp i_e2;
      DAE.Exp i_e1;
      Tpl.Text l_retVar;
      Tpl.Text l_retType;
      Tpl.Text l_funName;
      Tpl.Text l_builtinFunctionName;
      Tpl.Text l_result;
      Tpl.Text l_preExp;
      String ret_43;
      Tpl.Text l_res;
      Tpl.Text l_expPart;
      Tpl.Text l_castedVar;
      Tpl.Text l_signdigExp;
      Tpl.Text l_leftjustExp;
      Tpl.Text l_minlenExp;
      Tpl.Text l_formatExp;
      Tpl.Text l_sExp;
      Tpl.Text l_typeStr;
      Integer ret_33;
      Tpl.Text l_arrays__exp;
      Tpl.Text l_dim__exp;
      Tpl.Text txt_29;
      String ret_29;
      Integer ret_28;
      Tpl.Text l_dimsExp;
      Tpl.Text l_valExp;
      Tpl.Text txt_25;
      Tpl.Text txt_24;
      Tpl.Text l_tvar;
      Tpl.Text l_arr__tp__str;
      Tpl.Text l_expVar;
      Tpl.Text l_argStr;
      DAE.Exp ret_19;
      DAE.Exp ret_18;
      Tpl.Text l_retPre;
      Tpl.Text l_ty__str;
      Tpl.Text l_arr;
      Boolean ret_14;
      Tpl.Text txt_12;
      String ret_12;
      Tpl.Text txt_10;
      String ret_10;
      Tpl.Text txt_8;
      String ret_8;
      Tpl.Text txt_6;
      String ret_6;
      Tpl.Text l_var;
      Tpl.Text l_type;
      String ret_3;
      Tpl.Text l_var3;
      Tpl.Text l_var2;
      Tpl.Text l_var1;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "DIVISION"), expLst = {i_e1, i_e2, DAE.SCONST(string = i_string)}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls);
        ret_3 = Util.escapeModelicaStringToCString(i_string);
        l_var3 = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Div>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Div>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = i_ty), path = Absyn.IDENT(name = "DIVISION_ARRAY_SCALAR"), expLst = {i_e1, i_e2, (i_e3 as DAE.SHARED_LITERAL(index = _))}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        l_type = fun_341(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls);
        (l_var3, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e3, a_context, a_preExp, a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("division_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_scalar(&"));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var3);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CALL(path = Absyn.IDENT(name = "DIVISION_ARRAY_SCALAR"))),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_6 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Code generation does not support "));
        ret_6 = ExpressionDump.printExpStr(i_exp);
        txt_6 = Tpl.writeStr(txt_6, ret_6);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 3019, 11), Tpl.textString(txt_6));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Der>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = crefXml(txt, i_arg_componentRef);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Der>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {i_exp}),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_8 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Code generation does not support der("));
        ret_8 = ExpressionDump.printExpStr(i_exp);
        txt_8 = Tpl.writeStr(txt_8, ret_8);
        txt_8 = Tpl.writeTok(txt_8, Tpl.ST_STRING(")"));
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 3028, 11), Tpl.textString(txt_8));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "pre"), expLst = {i_arg}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCallPreXml(txt, i_arg, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "$_start"), expLst = {i_arg}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCallPreXml(txt, i_arg, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "edge"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = crefXml(txt, i_arg_componentRef);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "edge"), expLst = {i_exp}),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_10 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Code generation does not support edge("));
        ret_10 = ExpressionDump.printExpStr(i_exp);
        txt_10 = Tpl.writeStr(txt_10, ret_10);
        txt_10 = Tpl.writeTok(txt_10, Tpl.ST_STRING(")"));
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 3039, 11), Tpl.textString(txt_10));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "change"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = crefXml(txt, i_arg_componentRef);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "change"), expLst = {i_exp}),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_12 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Code generation does not support change("));
        ret_12 = ExpressionDump.printExpStr(i_exp);
        txt_12 = Tpl.writeStr(txt_12, ret_12);
        txt_12 = Tpl.writeTok(txt_12, Tpl.ST_STRING(")"));
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 3045, 11), Tpl.textString(txt_12));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "print"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        ret_14 = Config.acceptMetaModelicaGrammar();
        txt = fun_342(txt, ret_14, l_var1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "max"), attr = DAE.CALL_ATTR(ty = DAE.T_REAL(varLst = _)), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Max>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Max>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "max"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Max>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Max>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sum"), attr = DAE.CALL_ATTR(ty = i_ty), expLst = {i_e}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_arr, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        l_ty__str = expTypeArrayXml(Tpl.emptyTxt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("sum_"));
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeText(txt, l_arr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "min"), attr = DAE.CALL_ATTR(ty = DAE.T_REAL(varLst = _)), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Min>\n"));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Min>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "min"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Min>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Min>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "abs"), expLst = {i_e1}, attr = DAE.CALL_ATTR(ty = DAE.T_INTEGER(varLst = _))),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Abs>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Abs>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "abs"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Abs>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Abs>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sqrt"), expLst = {i_e1}, attr = DAE.CALL_ATTR(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        ret_18 = SimCodeUtil.createAssertforSqrt(i_e1);
        ret_19 = SimCodeUtil.createDAEString("Model error: Argument of sqrt should be >= 0");
        (l_retPre, a_varDecls) = assertCommonXml(Tpl.emptyTxt, ret_18, ret_19, a_context, a_varDecls, Absyn.dummyInfo);
        (l_argStr, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_retPre);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Sqrt>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_argStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Sqrt>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "div"), expLst = {i_e1, i_e2}, attr = DAE.CALL_ATTR(ty = DAE.T_INTEGER(varLst = _))),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ldiv("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").quot testcallC"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "div"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("trunc("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")testcallB"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "mod"), expLst = {i_e1, i_e2}, attr = DAE.CALL_ATTR(ty = i_ty)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_mod_"));
        txt = expTypeShortXml(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "max"), attr = DAE.CALL_ATTR(ty = i_ty), expLst = {i_array}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_expVar, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_array, a_context, a_preExp, a_varDecls);
        l_arr__tp__str = expTypeArrayXml(Tpl.emptyTxt, i_ty);
        txt_24 = expTypeModelicaXml(Tpl.emptyTxt, i_ty);
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(txt_24), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = max_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_expVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "min"), attr = DAE.CALL_ATTR(ty = i_ty), expLst = {i_array}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_expVar, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_array, a_context, a_preExp, a_varDecls);
        l_arr__tp__str = expTypeArrayXml(Tpl.emptyTxt, i_ty);
        txt_25 = expTypeModelicaXml(Tpl.emptyTxt, i_ty);
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(txt_25), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = min_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_expVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "fill"), expLst = i_val :: i_dims, attr = DAE.CALL_ATTR(ty = i_ty)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_valExp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_val, a_context, a_preExp, a_varDecls);
        l_dimsExp = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsExp, a_varDecls, a_preExp) = lm_343(l_dimsExp, i_dims, a_varDecls, a_preExp, a_context);
        l_dimsExp = Tpl.popIter(l_dimsExp);
        l_ty__str = expTypeArrayXml(Tpl.emptyTxt, i_ty);
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_ty__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("fill_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_ty__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_valExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        ret_28 = listLength(i_dims);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_28));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_dimsExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_call as DAE.CALL(path = Absyn.IDENT(name = "vector"))),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_29 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("vector() call does not have a C implementation "));
        ret_29 = ExpressionDump.printExpStr(i_call);
        txt_29 = Tpl.writeStr(txt_29, ret_29);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 3160, 11), Tpl.textString(txt_29));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "cat"), expLst = i_dim :: i_arrays, attr = DAE.CALL_ATTR(ty = i_ty)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_dim__exp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_dim, a_context, a_preExp, a_varDecls);
        l_arrays__exp = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", &")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_arrays__exp, a_varDecls, a_preExp) = lm_344(l_arrays__exp, i_arrays, a_varDecls, a_preExp, a_context);
        l_arrays__exp = Tpl.popIter(l_arrays__exp);
        l_ty__str = expTypeArrayXml(Tpl.emptyTxt, i_ty);
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_ty__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("cat_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_ty__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_dim__exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        ret_33 = listLength(i_arrays);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_33));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_arrays__exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" where is cat2"));
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "promote"), expLst = {i_A, i_n}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_A, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_n, a_context, a_preExp, a_varDecls);
        l_arr__tp__str = expTypeFromExpArrayXml(Tpl.emptyTxt, i_A);
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_arr__tp__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("promote_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "transpose"), expLst = {i_A}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_A, a_context, a_preExp, a_varDecls);
        l_arr__tp__str = expTypeFromExpArrayXml(Tpl.emptyTxt, i_A);
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_arr__tp__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("transpose_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "cross"), expLst = {i_v1, i_v2}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_v1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_v2, a_context, a_preExp, a_varDecls);
        l_arr__tp__str = expTypeFromExpArrayXml(Tpl.emptyTxt, i_v1);
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_arr__tp__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("cross_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "identity"), expLst = {i_A}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_A, a_context, a_preExp, a_varDecls);
        l_arr__tp__str = expTypeFromExpArrayXml(Tpl.emptyTxt, i_A);
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_arr__tp__str), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("identity_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arr__tp__str);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "rem"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls);
        l_typeStr = expTypeFromExpShortXml(Tpl.emptyTxt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_rem_"));
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "String"), expLst = {i_s, i_format}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_string", a_varDecls);
        (l_sExp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_s, a_context, a_preExp, a_varDecls);
        (l_formatExp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_format, a_context, a_preExp, a_varDecls);
        l_typeStr = expTypeFromExpModelicaXml(Tpl.emptyTxt, i_s);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_typeStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_to_modelica_string_format("));
        a_preExp = Tpl.writeText(a_preExp, l_sExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_formatExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "String"), expLst = {i_s, i_minlen, i_leftjust}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_string", a_varDecls);
        (l_sExp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_s, a_context, a_preExp, a_varDecls);
        (l_minlenExp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_minlen, a_context, a_preExp, a_varDecls);
        (l_leftjustExp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_leftjust, a_context, a_preExp, a_varDecls);
        l_typeStr = expTypeFromExpModelicaXml(Tpl.emptyTxt, i_s);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_typeStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_to_modelica_string("));
        a_preExp = Tpl.writeText(a_preExp, l_sExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_minlenExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_leftjustExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "String"), expLst = {i_s, i_minlen, i_leftjust, i_signdig}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_string", a_varDecls);
        (l_sExp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_s, a_context, a_preExp, a_varDecls);
        (l_minlenExp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_minlen, a_context, a_preExp, a_varDecls);
        (l_leftjustExp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_leftjust, a_context, a_preExp, a_varDecls);
        (l_signdigExp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_signdig, a_context, a_preExp, a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = modelica_real_to_modelica_string("));
        a_preExp = Tpl.writeText(a_preExp, l_sExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_minlenExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_leftjustExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_signdigExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "delay"), expLst = {DAE.ICONST(integer = i_index), i_e, i_d, i_delayMax}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_real", a_varDecls);
        (l_var1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_d, a_context, a_preExp, a_varDecls);
        (l_var3, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_delayMax, a_context, a_preExp, a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = delayImplXml("));
        a_preExp = Tpl.writeStr(a_preExp, intString(i_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", time, "));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var3);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Delay>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_var3);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Delay>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "integer"), expLst = {i_toBeCasted}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_castedVar, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_toBeCasted, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_castedVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "Integer"), expLst = {i_toBeCasted}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_castedVar, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_toBeCasted, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_castedVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "clock"), expLst = {}),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_clock()"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "noEvent"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_e1, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "anyString"), expLst = {i_e1}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_e1, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "mmc_get_field"), expLst = {i_s1, DAE.ICONST(integer = i_i)}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, "modelica_metatype", a_varDecls);
        (l_expPart, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_s1, a_context, a_preExp, a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR("));
        a_preExp = Tpl.writeText(a_preExp, l_expPart);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("), "));
        a_preExp = Tpl.writeStr(a_preExp, intString(i_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("));"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "mmc_unbox_record"), expLst = {_}, attr = DAE.CALL_ATTR(ty = _)),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  \"mmc_unbox_record\" is not necessary"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CALL(attr = DAE.CALL_ATTR(tailCall = DAE.TAIL(vars = i_tail_vars)), expLst = i_expLst)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        l_res = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("/* Tail recursive call "));
        ret_43 = ExpressionDump.printExpStr(i_exp);
        l_res = Tpl.writeStr(l_res, ret_43);
        l_res = Tpl.writeTok(l_res, Tpl.ST_LINE(" */\n"));
        (l_res, a_preExp, a_varDecls) = daeExpTailCallXml(l_res, i_expLst, i_tail_vars, a_context, a_preExp, a_varDecls);
        l_res = Tpl.writeTok(l_res, Tpl.ST_STRING_LIST({
                                        "goto _tailrecursive;\n",
                                        "/* TODO: Make sure any eventual dead code below is never generated */"
                                    }, false));
        a_preExp = Tpl.writeText(a_preExp, l_res);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CALL(attr = DAE.CALL_ATTR(builtin = i_attr_builtin, ty = i_attr_ty), expLst = i_expLst, path = i_path)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_varDecls, l_preExp) = lm_345(l_argStr, i_expLst, a_varDecls, l_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_result = fun_346(Tpl.emptyTxt, l_preExp, l_argStr);
        l_builtinFunctionName = builtinFunctionNameXml(Tpl.emptyTxt, i_path);
        l_funName = underscorePathXml(Tpl.emptyTxt, i_path);
        l_retType = fun_348(Tpl.emptyTxt, i_attr_builtin, i_attr_ty, l_funName);
        (l_retVar, a_varDecls) = fun_349(Tpl.emptyTxt, i_attr_ty, a_varDecls, l_retType);
        txt = fun_351(txt, i_exp, l_builtinFunctionName, l_result, l_funName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpCallXml;

public function builtinFunctionNameXml
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_path)
    local
      Tpl.Text txt;

    case ( txt,
           Absyn.IDENT(name = "DIVISION") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Div"));
      then txt;

    case ( txt,
           Absyn.IDENT(name = "ADDITION") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Add"));
      then txt;

    case ( txt,
           Absyn.IDENT(name = "SUBTRACTION") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Sub"));
      then txt;

    case ( txt,
           Absyn.IDENT(name = "POWER") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pow"));
      then txt;

    case ( txt,
           Absyn.IDENT(name = "sin") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Sin"));
      then txt;

    case ( txt,
           Absyn.IDENT(name = "cos") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Cos"));
      then txt;

    case ( txt,
           Absyn.IDENT(name = "exp") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Exp"));
      then txt;

    case ( txt,
           Absyn.IDENT(name = "sample") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Sample"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Builtin Function is not yet implemented "));
      then txt;
  end match;
end builtinFunctionNameXml;

protected function fun_354
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input list<String> in_a_vrest;
  input list<DAE.Exp> in_a_erest;
  input Tpl.Text in_a_exp;
  input String in_a_v;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_mArg, in_a_varDecls, in_a_preExp, in_a_context, in_a_vrest, in_a_erest, in_a_exp, in_a_v)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      list<String> a_vrest;
      list<DAE.Exp> a_erest;
      Tpl.Text a_exp;
      String a_v;

    case ( txt,
           false,
           a_varDecls,
           a_preExp,
           a_context,
           a_vrest,
           a_erest,
           a_exp,
           a_v )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        (txt, a_preExp, a_varDecls) = daeExpTailCallXml(txt, a_erest, a_vrest, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           a_context,
           a_vrest,
           a_erest,
           _,
           _ )
      equation
        (txt, a_preExp, a_varDecls) = daeExpTailCallXml(txt, a_erest, a_vrest, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_354;

protected function fun_355
  input Tpl.Text in_txt;
  input DAE.Exp in_a_e;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input list<String> in_a_vrest;
  input list<DAE.Exp> in_a_erest;
  input Tpl.Text in_a_exp;
  input String in_a_v;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_e, in_a_varDecls, in_a_preExp, in_a_context, in_a_vrest, in_a_erest, in_a_exp, in_a_v)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      list<String> a_vrest;
      list<DAE.Exp> a_erest;
      Tpl.Text a_exp;
      String a_v;
      DAE.ComponentRef i_cr;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_VAR(functionType = _)),
           a_varDecls,
           a_preExp,
           a_context,
           a_vrest,
           a_erest,
           a_exp,
           a_v )
      equation
        txt_0 = crefStrXml(Tpl.emptyTxt, i_cr);
        ret_1 = stringEq(a_v, Tpl.textString(txt_0));
        (txt, a_varDecls, a_preExp) = fun_354(txt, ret_1, a_varDecls, a_preExp, a_context, a_vrest, a_erest, a_exp, a_v);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           a_context,
           a_vrest,
           a_erest,
           a_exp,
           a_v )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        (txt, a_preExp, a_varDecls) = daeExpTailCallXml(txt, a_erest, a_vrest, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_355;

protected function fun_356
  input Tpl.Text in_txt;
  input list<String> in_a_vs;
  input list<DAE.Exp> in_a_erest;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_e;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_vs, in_a_erest, in_a_varDecls, in_a_preExp, in_a_context, in_a_e)
    local
      Tpl.Text txt;
      list<DAE.Exp> a_erest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_e;
      list<String> i_vrest;
      String i_v;
      Tpl.Text l_exp;

    case ( txt,
           i_v :: i_vrest,
           a_erest,
           a_varDecls,
           a_preExp,
           a_context,
           a_e )
      equation
        (l_exp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, a_e, a_context, a_preExp, a_varDecls);
        (txt, a_varDecls, a_preExp) = fun_355(txt, a_e, a_varDecls, a_preExp, a_context, i_vrest, a_erest, l_exp, i_v);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_356;

public function daeExpTailCallXml
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_es;
  input list<String> in_a_vs;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_es, in_a_vs, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<String> a_vs;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.Exp> i_erest;
      DAE.Exp i_e;

    case ( txt,
           i_e :: i_erest,
           a_vs,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_356(txt, a_vs, i_erest, a_varDecls, a_preExp, a_context, i_e);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpTailCallXml;

public function daeExpCallBuiltinPrefixXml
  input Tpl.Text in_txt;
  input Boolean in_a_builtin;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_builtin)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end daeExpCallBuiltinPrefixXml;

protected function lm_359
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_e;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_e :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_e, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_359(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_359;

public function daeExpArrayXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.Exp> i_array;
      Tpl.Text l_params;

    case ( txt,
           DAE.ARRAY(array = i_array),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        l_params = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_params, a_varDecls, a_preExp) = lm_359(l_params, i_array, a_varDecls, a_preExp, a_context);
        l_params = Tpl.popIter(l_params);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:Array>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_params);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:Array>"));
        txt = Tpl.writeText(txt, l_params);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpArrayXml;

protected function lm_361
  input Tpl.Text in_txt;
  input list<list<DAE.Exp>> in_items;
  input Tpl.Text in_a_vars2;
  input Tpl.Text in_a_promote;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_arrayTypeStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_vars2;
  output Tpl.Text out_a_promote;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_vars2, out_a_promote, out_a_varDecls) :=
  match(in_txt, in_items, in_a_vars2, in_a_promote, in_a_context, in_a_varDecls, in_a_arrayTypeStr)
    local
      Tpl.Text txt;
      list<list<DAE.Exp>> rest;
      Tpl.Text a_vars2;
      Tpl.Text a_promote;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_arrayTypeStr;
      list<DAE.Exp> i_row;
      Tpl.Text l_vars;
      Tpl.Text l_tmp;

    case ( txt,
           {},
           a_vars2,
           a_promote,
           _,
           a_varDecls,
           _ )
      then (txt, a_vars2, a_promote, a_varDecls);

    case ( txt,
           i_row :: rest,
           a_vars2,
           a_promote,
           a_context,
           a_varDecls,
           a_arrayTypeStr )
      equation
        (l_tmp, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(a_arrayTypeStr), a_varDecls);
        (l_vars, a_promote, a_varDecls) = daeExpMatrixRowXml(Tpl.emptyTxt, i_row, Tpl.textString(a_arrayTypeStr), a_context, a_promote, a_varDecls);
        a_vars2 = Tpl.writeTok(a_vars2, Tpl.ST_STRING(", &"));
        a_vars2 = Tpl.writeText(a_vars2, l_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_vars2, a_promote, a_varDecls) = lm_361(txt, rest, a_vars2, a_promote, a_context, a_varDecls, a_arrayTypeStr);
      then (txt, a_vars2, a_promote, a_varDecls);
  end match;
end lm_361;

public function daeExpMatrixXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<list<DAE.Exp>> i_m_matrix;
      DAE.Type i_m_ty;
      Tpl.Text l_tmp;
      Tpl.Text l_catAlloc;
      Tpl.Text l_promote;
      Tpl.Text l_vars2;
      Tpl.Text l_arrayTypeStr;

    case ( txt,
           DAE.MATRIX(matrix = {{}}),
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MATRIX(matrix = {}),
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MATRIX(ty = i_m_ty, matrix = i_m_matrix),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        l_arrayTypeStr = expTypeArrayXml(Tpl.emptyTxt, i_m_ty);
        l_vars2 = Tpl.emptyTxt;
        l_promote = Tpl.emptyTxt;
        l_catAlloc = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_catAlloc, l_vars2, l_promote, a_varDecls) = lm_361(l_catAlloc, i_m_matrix, l_vars2, l_promote, a_context, a_varDecls, l_arrayTypeStr);
        l_catAlloc = Tpl.popIter(l_catAlloc);
        a_preExp = Tpl.writeText(a_preExp, l_promote);
        a_preExp = Tpl.writeText(a_preExp, l_catAlloc);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        (l_tmp, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_arrayTypeStr), a_varDecls);
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpMatrixXml;

protected function lm_363
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varLstStr;
  input String in_a_arrayTypeStr;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varLstStr;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varLstStr, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varLstStr, in_a_arrayTypeStr, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varLstStr;
      String a_arrayTypeStr;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_e;
      Tpl.Text l_tmp;
      Tpl.Text l_expVar;

    case ( txt,
           {},
           a_varLstStr,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varLstStr, a_varDecls, a_preExp);

    case ( txt,
           i_e :: rest,
           a_varLstStr,
           a_arrayTypeStr,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_expVar, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        (l_tmp, a_varDecls) = tempDeclXml(Tpl.emptyTxt, a_arrayTypeStr, a_varDecls);
        a_varLstStr = Tpl.writeTok(a_varLstStr, Tpl.ST_STRING(", &"));
        a_varLstStr = Tpl.writeText(a_varLstStr, l_tmp);
        txt = Tpl.writeText(txt, l_expVar);
        txt = Tpl.nextIter(txt);
        (txt, a_varLstStr, a_varDecls, a_preExp) = lm_363(txt, rest, a_varLstStr, a_arrayTypeStr, a_varDecls, a_preExp, a_context);
      then (txt, a_varLstStr, a_varDecls, a_preExp);
  end match;
end lm_363;

public function daeExpMatrixRowXml
  input Tpl.Text txt;
  input list<DAE.Exp> a_row;
  input String a_arrayTypeStr;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_preExp2;
  Tpl.Text l_varLstStr;
algorithm
  l_varLstStr := Tpl.emptyTxt;
  l_preExp2 := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_preExp2, l_varLstStr, out_a_varDecls, out_a_preExp) := lm_363(l_preExp2, a_row, l_varLstStr, a_arrayTypeStr, a_varDecls, a_preExp, a_context);
  l_preExp2 := Tpl.popIter(l_preExp2);
  l_preExp2 := Tpl.writeTok(l_preExp2, Tpl.ST_NEW_LINE());
  out_a_preExp := Tpl.writeText(out_a_preExp, l_preExp2);
  out_txt := Tpl.writeText(txt, l_varLstStr);
end daeExpMatrixRowXml;

protected function fun_365
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_step;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_step, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_stepExp;

    case ( txt,
           SOME(i_stepExp),
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_stepExp, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_365;

public function daeExpRangeXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Option<DAE.Exp> i_step;
      DAE.Exp i_stop;
      DAE.Exp i_start;
      DAE.Type i_ty;
      Tpl.Text l_step__exp;
      Tpl.Text l_tmp;
      Tpl.Text l_stop__exp;
      Tpl.Text l_start__exp;
      Tpl.Text l_ty__str;

    case ( txt,
           DAE.RANGE(ty = i_ty, start = i_start, stop = i_stop, step = i_step),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        l_ty__str = expTypeArrayXml(Tpl.emptyTxt, i_ty);
        (l_start__exp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_start, a_context, a_preExp, a_varDecls);
        (l_stop__exp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_stop, a_context, a_preExp, a_varDecls);
        (l_tmp, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_ty__str), a_varDecls);
        (l_step__exp, a_varDecls, a_preExp) = fun_365(Tpl.emptyTxt, i_step, a_varDecls, a_preExp, a_context);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("<exp:Range>\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_start__exp);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_step__exp);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_stop__exp);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("</exp:Range>"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpRangeXml;

protected function fun_367
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_expVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_ty, in_a_preExp, in_a_exp, in_a_varDecls, in_a_expVar)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      DAE.Exp a_exp;
      Tpl.Text a_varDecls;
      Tpl.Text a_expVar;
      DAE.Type i_ty;
      Tpl.Text l_from;
      Tpl.Text l_to;
      Tpl.Text l_tvar;
      Tpl.Text l_arrayTypeStr;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeText(txt, a_expVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeText(txt, a_expVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeText(txt, a_expVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_BOOL(varLst = _),
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeText(txt, a_expVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_ARRAY(ty = i_ty),
           a_preExp,
           a_exp,
           a_varDecls,
           a_expVar )
      equation
        l_arrayTypeStr = expTypeArrayXml(Tpl.emptyTxt, i_ty);
        (l_tvar, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(l_arrayTypeStr), a_varDecls);
        l_to = expTypeShortXml(Tpl.emptyTxt, i_ty);
        l_from = expTypeFromExpShortXml(Tpl.emptyTxt, a_exp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("cast_"));
        a_preExp = Tpl.writeText(a_preExp, l_from);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_array_to_"));
        a_preExp = Tpl.writeText(a_preExp, l_to);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, a_expVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           _,
           a_varDecls,
           a_expVar )
      equation
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* could not cast, using the variable as it is */"));
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_367;

public function daeExpCastXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type i_ty;
      DAE.Exp i_exp;
      Tpl.Text l_expVar;

    case ( txt,
           DAE.CAST(exp = i_exp, ty = i_ty),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_expVar, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (txt, a_preExp, a_varDecls) = fun_367(txt, i_ty, a_preExp, i_exp, a_varDecls, l_expVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpCastXml;

protected function fun_369
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inExp;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_inExp, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_idx;
      DAE.Exp i_e;
      Tpl.Text l_idx1;
      Tpl.Text l_e1;

    case ( txt,
           DAE.ASUB(exp = i_e, sub = {i_idx}),
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        (l_idx1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_idx, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_idx1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /* DAE.ASUB */"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_369;

protected function lm_370
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_res;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_res, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_res;
      SimCode.Context a_context;
      Integer x_i1;
      DAE.Exp i_e;
      Tpl.Text l_v;
      Tpl.Text l_casePreExp;
      Tpl.Text l_caseVarDecls;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_e :: rest,
           a_res,
           a_context )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_caseVarDecls = Tpl.emptyTxt;
        l_casePreExp = Tpl.emptyTxt;
        (l_v, l_casePreExp, l_caseVarDecls) = daeExpXml(Tpl.emptyTxt, i_e, a_context, l_casePreExp, l_caseVarDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(": {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_caseVarDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_casePreExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "break;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_370(txt, rest, a_res, a_context);
      then txt;
  end match;
end lm_370;

protected function fun_371
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input list<DAE.Exp> in_a_subs;
  input DAE.Type in_a_ecr_ty;
  input Tpl.Text in_a_arrName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_varDecls, in_a_preExp, in_a_subs, in_a_ecr_ty, in_a_arrName)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      list<DAE.Exp> a_subs;
      DAE.Type a_ecr_ty;
      Tpl.Text a_arrName;
      SimCode.Context i_context;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_arrName )
      equation
        txt = Tpl.writeText(txt, a_arrName);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_context,
           a_varDecls,
           a_preExp,
           a_subs,
           a_ecr_ty,
           a_arrName )
      equation
        (txt, a_preExp, a_varDecls) = arrayScalarRhsXml(txt, a_ecr_ty, a_subs, Tpl.textString(a_arrName), i_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Asub array scalar RHS"));
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_371;

protected function lm_372
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_index;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_index :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExpASubIndexXml(txt, i_index, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_372(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_372;

protected function fun_373
  input Tpl.Text in_txt;
  input Integer in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           1 )
      then txt;

    case ( txt,
           i_i )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("D"));
      then txt;
  end match;
end fun_373;

protected function fun_374
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inExp;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_inExp, in_a_preExp, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Exp> i_indexes;
      DAE.Exp i_e;
      DAE.Type i_ecr_ty;
      list<DAE.Exp> i_subs;
      DAE.Exp i_ecr;
      list<DAE.Exp> i_exp_array;
      DAE.Exp i_idx;
      DAE.Exp i_exp;
      Tpl.Text txt_14;
      String ret_14;
      Integer ret_13;
      Tpl.Text l_expIndexes;
      Tpl.Text l_typeShort;
      Tpl.Text l_exp;
      DAE.Exp ret_9;
      Tpl.Text l_arrName;
      Tpl.Text txt_6;
      String ret_6;
      Tpl.Text l_expl;
      Tpl.Text l_idx1;
      Tpl.Text txt_3;
      Tpl.Text l_res;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.ASUB(exp = (i_exp as DAE.ASUB(exp = _))),
           a_preExp,
           _,
           a_varDecls )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Nested array subscripting *should* have been handled by the routine creating the asub, but for some reason it was not: "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 3499, 11), Tpl.textString(txt_0));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = (i_exp as DAE.ARRAY(scalar = true, array = i_exp_array)), sub = {i_idx}),
           a_preExp,
           a_context,
           a_varDecls )
      equation
        txt_3 = expTypeFromExpModelicaXml(Tpl.emptyTxt, i_exp);
        (l_res, a_varDecls) = tempDeclXml(Tpl.emptyTxt, Tpl.textString(txt_3), a_varDecls);
        l_res = Tpl.writeTok(l_res, Tpl.ST_STRING(" asub tmp test"));
        (l_idx1, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_idx, a_context, a_preExp, a_varDecls);
        l_expl = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_expl = lm_370(l_expl, i_exp_array, l_res, a_context);
        l_expl = Tpl.popIter(l_expl);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("switch ("));
        a_preExp = Tpl.writeText(a_preExp, l_idx1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(") { /* ASUB */\n"));
        a_preExp = Tpl.writeText(a_preExp, l_expl);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              "default:\n",
                                              "  assert(NULL == \"index out of bounds\");\n",
                                              "}"
                                          }, false));
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = (i_exp as DAE.RANGE(ty = _)), sub = {_}),
           a_preExp,
           _,
           a_varDecls )
      equation
        txt_6 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("ASUB_EASY_CASE "));
        ret_6 = ExpressionDump.printExpStr(i_exp);
        txt_6 = Tpl.writeStr(txt_6, ret_6);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 3528, 11), Tpl.textString(txt_6));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = (i_ecr as DAE.CREF(ty = i_ecr_ty)), sub = i_subs),
           a_preExp,
           a_context,
           a_varDecls )
      equation
        ret_9 = SimCodeUtil.buildCrefExpFromAsub(i_ecr, i_subs);
        (l_arrName, a_preExp, a_varDecls) = daeExpCrefRhsXml(Tpl.emptyTxt, ret_9, a_context, a_preExp, a_varDecls);
        (txt, a_varDecls, a_preExp) = fun_371(txt, a_context, a_varDecls, a_preExp, i_subs, i_ecr_ty, l_arrName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ASUB(exp = i_e, sub = i_indexes),
           a_preExp,
           a_context,
           a_varDecls )
      equation
        (l_exp, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        l_typeShort = expTypeFromExpShortXml(Tpl.emptyTxt, i_e);
        l_expIndexes = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_expIndexes, a_varDecls, a_preExp) = lm_372(l_expIndexes, i_indexes, a_varDecls, a_preExp, a_context);
        l_expIndexes = Tpl.popIter(l_expIndexes);
        txt = Tpl.writeText(txt, l_typeShort);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_get"));
        ret_13 = listLength(i_indexes);
        txt = fun_373(txt, ret_13);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_expIndexes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           a_preExp,
           _,
           a_varDecls )
      equation
        txt_14 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OTHER_ASUB "));
        ret_14 = ExpressionDump.printExpStr(i_exp);
        txt_14 = Tpl.writeStr(txt_14, ret_14);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 3545, 11), Tpl.textString(txt_14));
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_374;

protected function fun_375
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_inExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_inExp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Exp a_inExp;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;

    case ( txt,
           "metatype",
           a_inExp,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_369(txt, a_inExp, a_varDecls, a_preExp, a_context);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_inExp,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = fun_374(txt, a_inExp, a_preExp, a_context, a_varDecls);
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_375;

public function daeExpAsubXml
  input Tpl.Text txt;
  input DAE.Exp a_inExp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  String str_1;
  Tpl.Text txt_0;
algorithm
  txt_0 := expTypeFromExpShortXml(Tpl.emptyTxt, a_inExp);
  str_1 := Tpl.textString(txt_0);
  (out_txt, out_a_preExp, out_a_varDecls) := fun_375(txt, str_1, a_inExp, a_context, a_preExp, a_varDecls);
end daeExpAsubXml;

public function daeExpASubIndexXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      Integer i_index;
      Integer i_integer;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           a_preExp,
           a_varDecls )
      equation
        ret_0 = SimCodeUtil.incrementInt(i_integer, -1);
        txt = Tpl.writeStr(txt, intString(ret_0));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index),
           _,
           a_preExp,
           a_varDecls )
      equation
        ret_1 = SimCodeUtil.incrementInt(i_index, -1);
        txt = Tpl.writeStr(txt, intString(ret_1));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_exp, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpASubIndexXml;

protected function fun_378
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.ComponentRef i_cr_componentRef;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.CREF(componentRef = i_cr_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Pre>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = crefXml(txt, i_cr_componentRef);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Pre>"));
      then txt;

    case ( txt,
           DAE.ASUB(exp = DAE.CREF(componentRef = _), sub = {_}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"case ASUB(exp = cr as CREF(__), sub = {sub_exp}) is not yet implemented\""));
      then txt;

    case ( txt,
           i_exp )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Code generation does not support pre("));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_STRING(")"));
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 3572, 11), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_378;

public function daeExpCallPreXml
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_378(txt, a_exp);
  out_a_preExp := a_preExp;
  out_a_varDecls := a_varDecls;
end daeExpCallPreXml;

public function daeExpSizeXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_dim;
      DAE.Exp i_exp;
      Tpl.Text l_dimPart;
      Tpl.Text l_expPart;

    case ( txt,
           DAE.SIZE(exp = (i_exp as DAE.CREF(componentRef = _)), sz = SOME(i_dim)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (l_dimPart, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_dim, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<exp:Size>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_dimPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp:Size>"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size(X) not implemented"));
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpSizeXml;

public function daeExpBoxXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp_exp;
      Tpl.Text l_res;

    case ( txt,
           DAE.BOX(exp = i_exp_exp),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_res, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpBoxXml;

public function daeExpUnboxXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp_exp;
      Tpl.Text l_res;

    case ( txt,
           DAE.UNBOX(exp = i_exp_exp),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_res, a_preExp, a_varDecls) = daeExpXml(Tpl.emptyTxt, i_exp_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpUnboxXml;

protected function fun_383
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.SHARED_LITERAL(index = _) )
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_383;

public function daeExpSharedLiteralXml
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_383(txt, a_exp);
  out_a_preExp := a_preExp;
  out_a_varDecls := a_varDecls;
end daeExpSharedLiteralXml;

protected function lm_385
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExpXml(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_385(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_385;

protected function fun_386
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_dimsValuesStr;
  input String in_a_arrName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_dimsValuesStr, in_a_arrName)
    local
      Tpl.Text txt;
      Tpl.Text a_dimsValuesStr;
      String a_arrName;

    case ( txt,
           "metatype_array",
           a_dimsValuesStr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeStr(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /*arrayScalarRhs*/"));
      then txt;

    case ( txt,
           _,
           a_dimsValuesStr,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " wrong LHS\n",
                                    "    <exp:ArraySubscripts>\n",
                                    "      <exp:IndexExpression>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      </exp:IndexExpression>\n",
                                    "    </exp:ArraySubscripts>\n",
                                    "  </exp:QualifiedNamepart>\n",
                                    "</exp:QualifiedName>"
                                }, false));
      then txt;
  end match;
end fun_386;

public function arrayScalarRhsXml
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input list<DAE.Exp> a_subs;
  input String a_arrName;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  String str_4;
  Tpl.Text l_dimsValuesStr;
  Integer ret_2;
  Tpl.Text l_dimsLenStr;
  Tpl.Text l_arrayType;
algorithm
  l_arrayType := expTypeArrayXml(Tpl.emptyTxt, a_ty);
  ret_2 := listLength(a_subs);
  l_dimsLenStr := Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
  l_dimsValuesStr := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_dimsValuesStr, out_a_varDecls, out_a_preExp) := lm_385(l_dimsValuesStr, a_subs, a_varDecls, a_preExp, a_context);
  l_dimsValuesStr := Tpl.popIter(l_dimsValuesStr);
  str_4 := Tpl.textString(l_arrayType);
  out_txt := fun_386(txt, str_4, l_dimsValuesStr, a_arrName);
end arrayScalarRhsXml;

public function outDeclXml
  input Tpl.Text txt;
  input String a_ty;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_newVar;
algorithm
  l_newVar := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("out"));
  out_a_varDecls := Tpl.writeStr(a_varDecls, a_ty);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(" "));
  out_a_varDecls := Tpl.writeText(out_a_varDecls, l_newVar);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(";"));
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_newVar);
end outDeclXml;

protected function fun_389
  input Tpl.Text in_txt;
  input String in_a_ty;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_ty, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      String i_ty;
      Integer ret_4;
      Tpl.Text l_newVarIx;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           "modelica_metatype",
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("tmpMeta["));
        ret_0 = System.tmpTickIndex(1);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_varDecls);

    case ( txt,
           "metamodelica_string",
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("tmpMeta["));
        ret_1 = System.tmpTickIndex(1);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_varDecls);

    case ( txt,
           "metamodelica_string_const",
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("tmpMeta["));
        ret_2 = System.tmpTickIndex(1);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_varDecls);

    case ( txt,
           i_ty,
           a_varDecls )
      equation
        l_newVarIx = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("tmp"));
        ret_4 = System.tmpTick();
        l_newVarIx = Tpl.writeStr(l_newVarIx, intString(ret_4));
        a_varDecls = Tpl.writeStr(a_varDecls, i_ty);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = Tpl.writeText(a_varDecls, l_newVarIx);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_newVarIx);
      then (txt, a_varDecls);
  end match;
end fun_389;

public function tempDeclXml
  input Tpl.Text txt;
  input String a_ty;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_newVar;
algorithm
  (l_newVar, out_a_varDecls) := fun_389(Tpl.emptyTxt, a_ty, a_varDecls);
  out_txt := Tpl.writeText(txt, l_newVar);
end tempDeclXml;

public function tempDeclConstXml
  input Tpl.Text txt;
  input String a_ty;
  input String a_val;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Integer ret_1;
  Tpl.Text l_newVar;
algorithm
  l_newVar := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("tmp"));
  ret_1 := System.tmpTick();
  l_newVar := Tpl.writeStr(l_newVar, intString(ret_1));
  out_a_varDecls := Tpl.writeStr(a_varDecls, a_ty);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(" "));
  out_a_varDecls := Tpl.writeText(out_a_varDecls, l_newVar);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(" = "));
  out_a_varDecls := Tpl.writeStr(out_a_varDecls, a_val);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(";"));
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_newVar);
end tempDeclConstXml;

protected function fun_392
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_var_ty)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;

    case ( txt,
           {},
           a_var_ty )
      equation
        txt = expTypeArrayIfXml(txt, a_var_ty);
      then txt;

    case ( txt,
           _,
           a_var_ty )
      equation
        txt = expTypeArrayXml(txt, a_var_ty);
      then txt;
  end match;
end fun_392;

public function varTypeXml
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims, ty = i_var_ty) )
      equation
        txt = fun_392(txt, i_instDims, i_var_ty);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end varTypeXml;

public function varTypeBoxedXml
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.VARIABLE(name = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end varTypeBoxedXml;

public function expTypeRWXml
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_INT"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_REAL"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_STRING"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_BOOL"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_INT"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeRWXml(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ARRAY"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_RECORD"));
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_MMC"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_MMC"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end expTypeRWXml;

protected function fun_396
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;
  end match;
end fun_396;

public function expTypeShortXml
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;
      DAE.Type i_type;
      ClassInf.State i_complexClassType;
      DAE.Type i_ty;
      Tpl.Text txt_2;
      String ret_2;
      Absyn.Path ret_1;
      Boolean ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        txt = fun_396(txt, ret_0);
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boolean"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShortXml(txt, i_ty);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("complex"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_complexClassType) )
      equation
        ret_1 = ClassInf.getStateName(i_complexClassType);
        txt = underscorePathXml(txt, ret_1);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fnptr"));
      then txt;

    case ( txt,
           DAE.T_UNKNOWN(source = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("complex"));
      then txt;

    case ( txt,
           DAE.T_ANYTYPE(anyClassType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("complex"));
      then txt;

    case ( txt,
           i_type )
      equation
        txt_2 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("expTypeShortXml:"));
        ret_2 = Types.unparseType(i_type);
        txt_2 = Tpl.writeStr(txt_2, ret_2);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 3736, 14), Tpl.textString(txt_2));
      then txt;
  end match;
end expTypeShortXml;

public function mmcVarTypeXml
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = mmcTypeShortXml(txt, i_ty);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end mmcVarTypeXml;

public function mmcTypeShortXml
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("array"));
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fnptr"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmcTypeShort:ERROR"));
      then txt;
  end match;
end mmcTypeShortXml;

protected function fun_400
  input Tpl.Text in_txt;
  input Boolean in_a_array;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_array, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;

    case ( txt,
           true,
           a_ty )
      equation
        txt = expTypeArrayXml(txt, a_ty);
      then txt;

    case ( txt,
           false,
           a_ty )
      equation
        txt = expTypeModelicaXml(txt, a_ty);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_400;

public function expTypeXml
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input Boolean a_array;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_400(txt, a_array, a_ty);
end expTypeXml;

public function expTypeModelicaXml
  input Tpl.Text txt;
  input DAE.Type a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFlagXml(txt, a_ty, 2);
end expTypeModelicaXml;

public function expTypeArrayXml
  input Tpl.Text txt;
  input DAE.Type a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFlagXml(txt, a_ty, 3);
end expTypeArrayXml;

public function expTypeArrayIfXml
  input Tpl.Text txt;
  input DAE.Type a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFlagXml(txt, a_ty, 4);
end expTypeArrayIfXml;

public function expTypeFromExpShortXml
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlagXml(txt, a_exp, 1);
end expTypeFromExpShortXml;

public function expTypeFromExpModelicaXml
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlagXml(txt, a_exp, 2);
end expTypeFromExpModelicaXml;

public function expTypeFromExpArrayXml
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlagXml(txt, a_exp, 3);
end expTypeFromExpArrayXml;

public function expTypeFromExpArrayIfXml
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlagXml(txt, a_exp, 4);
end expTypeFromExpArrayIfXml;

protected function fun_409
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;
      ClassInf.State i_complexClassType;
      Absyn.Path ret_0;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_complexClassType) )
      equation
        ret_0 = ClassInf.getStateName(i_complexClassType);
        txt = underscorePathXml(txt, ret_0);
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = expTypeShortXml(txt, i_ty);
      then txt;
  end match;
end fun_409;

protected function fun_410
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _))) )
      equation
        txt = expTypeShortXml(txt, i_ty);
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = fun_409(txt, i_ty);
      then txt;
  end match;
end fun_410;

protected function fun_411
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShortXml(txt, i_ty);
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = expTypeFlagXml(txt, i_ty, 2);
      then txt;
  end match;
end fun_411;

protected function fun_412
  input Tpl.Text in_txt;
  input Integer in_a_flag;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;

    case ( txt,
           1,
           a_ty )
      equation
        txt = expTypeShortXml(txt, a_ty);
      then txt;

    case ( txt,
           2,
           a_ty )
      equation
        txt = fun_410(txt, a_ty);
      then txt;

    case ( txt,
           3,
           a_ty )
      equation
        txt = expTypeShortXml(txt, a_ty);
      then txt;

    case ( txt,
           4,
           a_ty )
      equation
        txt = fun_411(txt, a_ty);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_412;

public function expTypeFlagXml
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input Integer a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_412(txt, a_flag, a_ty);
end expTypeFlagXml;

protected function fun_414
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           8 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_integer"));
      then txt;
  end match;
end fun_414;

protected function fun_415
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_real"));
      then txt;
  end match;
end fun_415;

protected function fun_416
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_string"));
      then txt;
  end match;
end fun_416;

protected function fun_417
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;
  end match;
end fun_417;

protected function fun_418
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_flag)
    local
      Tpl.Text txt;
      Integer a_flag;

    case ( txt,
           false,
           a_flag )
      equation
        txt = fun_416(txt, a_flag);
      then txt;

    case ( txt,
           _,
           a_flag )
      equation
        txt = fun_417(txt, a_flag);
      then txt;
  end match;
end fun_418;

protected function fun_419
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boolean"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_boolean"));
      then txt;
  end match;
end fun_419;

protected function fun_420
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           8 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_integer"));
      then txt;
  end match;
end fun_420;

protected function fun_421
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;
  end match;
end fun_421;

protected function fun_422
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;
  end match;
end fun_422;

protected function fun_423
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;
  end match;
end fun_423;

protected function fun_424
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;
  end match;
end fun_424;

protected function fun_425
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;
  end match;
end fun_425;

public function expTypeFromExpFlagXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp, in_a_flag)
    local
      Tpl.Text txt;
      Integer a_flag;
      DAE.Exp i_exp;
      DAE.Exp i_c;
      DAE.Type i_c_ty;
      DAE.Type i_attr_ty;
      DAE.Exp i_expThen;
      DAE.Operator i_e_operator;
      Tpl.Text txt_7;
      String ret_7;
      DAE.Type ret_6;
      DAE.Type ret_5;
      DAE.Type ret_4;
      DAE.Type ret_3;
      DAE.Type ret_2;
      DAE.Type ret_1;
      Boolean ret_0;

    case ( txt,
           DAE.ICONST(integer = _),
           a_flag )
      equation
        txt = fun_414(txt, a_flag);
      then txt;

    case ( txt,
           DAE.RCONST(real = _),
           a_flag )
      equation
        txt = fun_415(txt, a_flag);
      then txt;

    case ( txt,
           DAE.SCONST(string = _),
           a_flag )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        txt = fun_418(txt, ret_0, a_flag);
      then txt;

    case ( txt,
           DAE.BCONST(bool = _),
           a_flag )
      equation
        txt = fun_419(txt, a_flag);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(name = _),
           a_flag )
      equation
        txt = fun_420(txt, a_flag);
      then txt;

    case ( txt,
           DAE.BINARY(operator = i_e_operator),
           a_flag )
      equation
        txt = expTypeFromOpFlagXml(txt, i_e_operator, a_flag);
      then txt;

    case ( txt,
           DAE.UNARY(operator = i_e_operator),
           a_flag )
      equation
        txt = expTypeFromOpFlagXml(txt, i_e_operator, a_flag);
      then txt;

    case ( txt,
           DAE.LBINARY(operator = i_e_operator),
           a_flag )
      equation
        txt = expTypeFromOpFlagXml(txt, i_e_operator, a_flag);
      then txt;

    case ( txt,
           DAE.LUNARY(operator = i_e_operator),
           a_flag )
      equation
        txt = expTypeFromOpFlagXml(txt, i_e_operator, a_flag);
      then txt;

    case ( txt,
           DAE.RELATION(operator = i_e_operator),
           a_flag )
      equation
        txt = expTypeFromOpFlagXml(txt, i_e_operator, a_flag);
      then txt;

    case ( txt,
           DAE.IFEXP(expThen = i_expThen),
           a_flag )
      equation
        txt = expTypeFromExpFlagXml(txt, i_expThen, a_flag);
      then txt;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_attr_ty, a_flag);
      then txt;

    case ( txt,
           DAE.ARRAY(ty = i_c_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_c_ty, a_flag);
      then txt;

    case ( txt,
           DAE.MATRIX(ty = i_c_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_c_ty, a_flag);
      then txt;

    case ( txt,
           DAE.RANGE(ty = i_c_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_c_ty, a_flag);
      then txt;

    case ( txt,
           DAE.CAST(ty = i_c_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_c_ty, a_flag);
      then txt;

    case ( txt,
           DAE.CREF(ty = i_c_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_c_ty, a_flag);
      then txt;

    case ( txt,
           DAE.CODE(ty = i_c_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_c_ty, a_flag);
      then txt;

    case ( txt,
           (i_c as DAE.ASUB(exp = _)),
           a_flag )
      equation
        ret_1 = Expression.typeof(i_c);
        txt = expTypeFlagXml(txt, ret_1, a_flag);
      then txt;

    case ( txt,
           (i_exp as DAE.REDUCTION(reductionInfo = _)),
           a_flag )
      equation
        ret_2 = Expression.typeof(i_exp);
        txt = expTypeFlagXml(txt, ret_2, a_flag);
      then txt;

    case ( txt,
           DAE.BOX(exp = i_exp),
           a_flag )
      equation
        ret_3 = Expression.typeof(i_exp);
        txt = expTypeFlagXml(txt, ret_3, a_flag);
      then txt;

    case ( txt,
           (i_exp as DAE.CONS(car = _)),
           a_flag )
      equation
        ret_4 = Expression.typeof(i_exp);
        txt = expTypeFlagXml(txt, ret_4, a_flag);
      then txt;

    case ( txt,
           (i_exp as DAE.LIST(valList = _)),
           a_flag )
      equation
        ret_5 = Expression.typeof(i_exp);
        txt = expTypeFlagXml(txt, ret_5, a_flag);
      then txt;

    case ( txt,
           DAE.SIZE(exp = i_exp),
           a_flag )
      equation
        ret_6 = Expression.typeof(i_exp);
        txt = expTypeFlagXml(txt, ret_6, a_flag);
      then txt;

    case ( txt,
           DAE.META_TUPLE(listExp = _),
           a_flag )
      equation
        txt = fun_421(txt, a_flag);
      then txt;

    case ( txt,
           DAE.META_OPTION(exp = _),
           a_flag )
      equation
        txt = fun_422(txt, a_flag);
      then txt;

    case ( txt,
           DAE.MATCHEXPRESSION(matchType = _),
           a_flag )
      equation
        txt = fun_423(txt, a_flag);
      then txt;

    case ( txt,
           DAE.METARECORDCALL(path = _),
           a_flag )
      equation
        txt = fun_424(txt, a_flag);
      then txt;

    case ( txt,
           DAE.BOX(exp = _),
           a_flag )
      equation
        txt = fun_425(txt, a_flag);
      then txt;

    case ( txt,
           DAE.UNBOX(ty = i_c_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_c_ty, a_flag);
      then txt;

    case ( txt,
           DAE.SHARED_LITERAL(ty = i_c_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_c_ty, a_flag);
      then txt;

    case ( txt,
           i_exp,
           _ )
      equation
        txt_7 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("expTypeFromExpFlag:"));
        ret_7 = ExpressionDump.printExpStr(i_exp);
        txt_7 = Tpl.writeStr(txt_7, ret_7);
        txt = error(txt, Tpl.sourceInfo("CodegenXML.tpl", 3873, 14), Tpl.textString(txt_7));
      then txt;
  end match;
end expTypeFromExpFlagXml;

protected function fun_427
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boolean"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_boolean"));
      then txt;
  end match;
end fun_427;

protected function fun_428
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boolean"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_boolean"));
      then txt;
  end match;
end fun_428;

protected function fun_429
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boolean"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_boolean"));
      then txt;
  end match;
end fun_429;

public function expTypeFromOpFlagXml
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_op, in_a_flag)
    local
      Tpl.Text txt;
      Integer a_flag;
      DAE.Type i_o_ty;

    case ( txt,
           DAE.ADD(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.SUB(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.MUL(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.DIV(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.POW(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.UMINUS(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.UMINUS_ARR(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.ADD_ARR(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.SUB_ARR(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.MUL_ARR(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.DIV_ARR(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.MUL_ARRAY_SCALAR(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.ADD_ARRAY_SCALAR(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.SUB_SCALAR_ARRAY(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.MUL_SCALAR_PRODUCT(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.MUL_MATRIX_PRODUCT(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.DIV_ARRAY_SCALAR(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.DIV_SCALAR_ARRAY(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.POW_ARRAY_SCALAR(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.POW_SCALAR_ARRAY(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.POW_ARR(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.POW_ARR2(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.LESS(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.GREATER(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.EQUAL(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlagXml(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.AND(ty = _),
           a_flag )
      equation
        txt = fun_427(txt, a_flag);
      then txt;

    case ( txt,
           DAE.OR(ty = _),
           a_flag )
      equation
        txt = fun_428(txt, a_flag);
      then txt;

    case ( txt,
           DAE.NOT(ty = _),
           a_flag )
      equation
        txt = fun_429(txt, a_flag);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expTypeFromOpFlag:ERROR"));
      then txt;
  end match;
end expTypeFromOpFlagXml;

public function dimensionXml
  input Tpl.Text in_txt;
  input DAE.Dimension in_a_d;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_d)
    local
      Tpl.Text txt;
      Integer i_size;
      Integer i_integer;

    case ( txt,
           DAE.DIM_INTEGER(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.DIM_ENUM(size = i_size) )
      equation
        txt = Tpl.writeStr(txt, intString(i_size));
      then txt;

    case ( txt,
           DAE.DIM_UNKNOWN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("INVALID_DIMENSION"));
      then txt;
  end match;
end dimensionXml;

public function assertCommonXml
  input Tpl.Text txt;
  input DAE.Exp a_condition;
  input DAE.Exp a_message;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Absyn.Info a_info;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_msgVar;
  Tpl.Text l_condVar;
  Tpl.Text l_preExpMsg;
  Tpl.Text l_preExpCond;
algorithm
  l_preExpCond := Tpl.emptyTxt;
  l_preExpMsg := Tpl.emptyTxt;
  (l_condVar, l_preExpCond, out_a_varDecls) := daeExpXml(Tpl.emptyTxt, a_condition, a_context, l_preExpCond, a_varDecls);
  (l_msgVar, l_preExpMsg, out_a_varDecls) := daeExpXml(Tpl.emptyTxt, a_message, a_context, l_preExpMsg, out_a_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "<fun:Assertion>\n",
                                   "  <fun:Condition>\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(4));
  out_txt := Tpl.writeText(out_txt, l_condVar);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "  </fun:Condition>\n",
                                       "  <fun:Message>\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(4));
  out_txt := Tpl.writeText(out_txt, l_msgVar);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "  </fun:Message>\n",
                                       "</fun:Assertion>"
                                   }, false));
end assertCommonXml;

public function error
  input Tpl.Text txt;
  input Absyn.Info a_srcInfo;
  input String a_errMessage;

  output Tpl.Text out_txt;
protected
  String ret_0;
algorithm
  Tpl.addSourceTemplateError(a_errMessage, a_srcInfo);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "\n",
                                   "#error \""
                               }, false));
  ret_0 := Error.infoStr(a_srcInfo);
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" "));
  out_txt := Tpl.writeStr(out_txt, a_errMessage);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end error;

public function modelicaLineXml
  input Tpl.Text in_txt;
  input Absyn.Info in_a_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_info)
    local
      Tpl.Text txt;
      Absyn.Info i_info;
      String ret_0;

    case ( txt,
           Absyn.INFO(columnNumberStart = 0) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* Dummy Line */"));
      then txt;

    case ( txt,
           i_info )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*#modelicaLine "));
        ret_0 = Error.infoStr(i_info);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;
  end match;
end modelicaLineXml;

public function endModelicaLineXml
  input Tpl.Text txt;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/*#endModelicaLine*/"));
end endModelicaLineXml;

end CodegenXML;