encapsulated package DAEDumpTpl
"
  file:        DAEDumpTpl.mo
  package:     DAEDumpTpl
  description: Generated by Susan.
"

public import Tpl;

public import ExpressionDumpTpl;
public import ClassInf;
public import Absyn;
public import SCode;
public import DAEDump;
public import DAE;
protected import AbsynDumpTpl;
protected import SCodeDumpTpl;

protected function lm_9
  input Tpl.Text in_txt;
  input list<DAEDump.compWithSplitElements> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAEDump.compWithSplitElements> rest;
      DAEDump.compWithSplitElements i_dae;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dae :: rest )
      equation
        txt = dumpComp(txt, i_dae);
        txt = Tpl.nextIter(txt);
        txt = lm_9(txt, rest);
      then txt;
  end match;
end lm_9;

protected function fun_10
  input Tpl.Text in_txt;
  input DAEDump.functionList in_a_funLists;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_funLists)
    local
      Tpl.Text txt;
      list<DAE.Function> i_funcs;

    case ( txt,
           DAEDump.FUNCTION_LIST(funcs = i_funcs) )
      equation
        txt = dumpFunctions(txt, i_funcs);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_10;

protected function fun_11
  input Tpl.Text in_txt;
  input Tpl.Text in_a_fun__str;
  input Tpl.Text in_a_comp__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fun__str, in_a_comp__str)
    local
      Tpl.Text txt;
      Tpl.Text a_comp__str;
      Tpl.Text i_fun__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_comp__str )
      equation
        txt = Tpl.writeText(txt, a_comp__str);
      then txt;

    case ( txt,
           i_fun__str,
           a_comp__str )
      equation
        txt = Tpl.writeText(txt, i_fun__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_comp__str);
      then txt;
  end match;
end fun_11;

public function dumpDAE
  input Tpl.Text txt;
  input list<DAEDump.compWithSplitElements> a_fixedDaeList;
  input DAEDump.functionList a_funLists;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_fun__str;
  Tpl.Text l_comp__str;
algorithm
  l_comp__str := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_comp__str := lm_9(l_comp__str, a_fixedDaeList);
  l_comp__str := Tpl.popIter(l_comp__str);
  l_fun__str := fun_10(Tpl.emptyTxt, a_funLists);
  out_txt := fun_11(txt, l_fun__str, l_comp__str);
end dumpDAE;

public function dumpComp
  input Tpl.Text in_txt;
  input DAEDump.compWithSplitElements in_a_fixedDae;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fixedDae)
    local
      Tpl.Text txt;
      DAEDump.splitElements i_spltElems;
      String i_name;
      Option<SCode.Comment> i_comment;
      Tpl.Text l_cmt__str;

    case ( txt,
           DAEDump.COMP_WITH_SPLIT(comment = i_comment, name = i_name, spltElems = i_spltElems) )
      equation
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = dumpCompStream(txt, i_spltElems);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpComp;

public function dumpCompStream
  input Tpl.Text in_txt;
  input DAEDump.splitElements in_a_elems;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elems)
    local
      Tpl.Text txt;
      list<DAE.Element> i_a;
      list<DAE.Element> i_e;
      list<DAE.Element> i_ia;
      list<DAE.Element> i_ie;
      list<DAE.Element> i_v;
      Tpl.Text l_al__str;
      Tpl.Text l_eq__str;
      Tpl.Text l_ial__str;
      Tpl.Text l_ieq__str;
      Tpl.Text l_var__str;

    case ( txt,
           DAEDump.SPLIT_ELEMENTS(v = i_v, ie = i_ie, ia = i_ia, e = i_e, a = i_a) )
      equation
        l_var__str = dumpVars(Tpl.emptyTxt, i_v);
        l_ieq__str = dumpInitialEquations(Tpl.emptyTxt, i_ie, "initial equation");
        l_ial__str = dumpInitialAlgorithms(Tpl.emptyTxt, i_ia, "initial algorithm");
        l_eq__str = dumpEquations(Tpl.emptyTxt, i_e, "equation");
        l_al__str = dumpAlgorithms(Tpl.emptyTxt, i_a, "algorithm");
        txt = Tpl.writeText(txt, l_var__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_ieq__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_ial__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_eq__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_al__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpCompStream;

protected function lm_15
  input Tpl.Text in_txt;
  input list<DAE.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Function> rest;
      DAE.Function i_func;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_func :: rest )
      equation
        txt = dumpFunction(txt, i_func);
        txt = Tpl.nextIter(txt);
        txt = lm_15(txt, rest);
      then txt;
  end match;
end lm_15;

public function dumpFunctions
  input Tpl.Text txt;
  input list<DAE.Function> a_funcs;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_15(out_txt, a_funcs);
  out_txt := Tpl.popIter(out_txt);
end dumpFunctions;

public function dumpFunction
  input Tpl.Text in_txt;
  input DAE.Function in_a_function;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_function)
    local
      Tpl.Text txt;
      DAE.Type i_type__;
      list<DAE.FunctionDefinition> i_functions;
      Absyn.Path i_path;
      Option<SCode.Comment> i_comment;
      Tpl.Text l_cmt__str;

    case ( txt,
           DAE.FUNCTION(functions = DAE.FUNCTION_EXT(externalDecl = DAE.EXTERNALDECL(language = "builtin")) :: _) )
      then txt;

    case ( txt,
           DAE.FUNCTION(comment = i_comment, path = i_path, functions = i_functions) )
      equation
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function "));
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_path);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = dumpFunctionDefinitions(txt, i_functions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.RECORD_CONSTRUCTOR(path = i_path, type_ = i_type__) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function "));
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"Automatically generated record constructor for "));
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpRecordInputVarStr(txt, i_type__);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output "));
        txt = dumpPathLastIndent(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" res;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFunction;

protected function lm_18
  input Tpl.Text in_txt;
  input list<DAE.FunctionDefinition> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.FunctionDefinition> rest;
      DAE.FunctionDefinition i_func;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_func :: rest )
      equation
        txt = dumpFunctionDefinition(txt, i_func);
        txt = Tpl.nextIter(txt);
        txt = lm_18(txt, rest);
      then txt;
  end match;
end lm_18;

public function dumpFunctionDefinitions
  input Tpl.Text txt;
  input list<DAE.FunctionDefinition> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_18(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end dumpFunctionDefinitions;

public function dumpFunctionDefinition
  input Tpl.Text in_txt;
  input DAE.FunctionDefinition in_a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_functions)
    local
      Tpl.Text txt;
      DAE.ExternalDecl i_externalDecl;
      list<DAE.Element> i_body;

    case ( txt,
           DAE.FUNCTION_DEF(body = i_body) )
      equation
        txt = dumpElements(txt, i_body);
      then txt;

    case ( txt,
           DAE.FUNCTION_EXT(body = i_body, externalDecl = i_externalDecl) )
      equation
        txt = dumpElements(txt, i_body);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = dumpExternalDecl(txt, i_externalDecl);
      then txt;

    case ( txt,
           DAE.FUNCTION_DER_MAPPER(derivedFunction = _) )
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFunctionDefinition;

protected function fun_21
  input Tpl.Text in_txt;
  input Tpl.Text in_a_func__name__str;
  input Tpl.Text in_a_func__args__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_func__name__str, in_a_func__args__str)
    local
      Tpl.Text txt;
      Tpl.Text a_func__args__str;
      Tpl.Text i_func__name__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           i_func__name__str,
           a_func__args__str )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, i_func__name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_func__args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_21;

protected function fun_22
  input Tpl.Text in_txt;
  input Tpl.Text in_a_ext__output__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ext__output__str)
    local
      Tpl.Text txt;
      Tpl.Text i_ext__output__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_ext__output__str )
      equation
        txt = Tpl.writeText(txt, i_ext__output__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ="));
      then txt;
  end match;
end fun_22;

public function dumpExternalDecl
  input Tpl.Text in_txt;
  input DAE.ExternalDecl in_a_externalDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_externalDecl)
    local
      Tpl.Text txt;
      String i_language;
      DAE.ExtArg i_returnArg;
      list<DAE.ExtArg> i_args;
      String i_name;
      Tpl.Text l_lang__str;
      Tpl.Text l_output__str;
      Tpl.Text l_ext__output__str;
      Tpl.Text l_func__str;
      Tpl.Text l_func__args__str;
      Tpl.Text l_func__name__str;

    case ( txt,
           DAE.EXTERNALDECL(name = i_name, args = i_args, returnArg = i_returnArg, language = i_language) )
      equation
        l_func__name__str = Tpl.writeStr(Tpl.emptyTxt, i_name);
        l_func__args__str = dumpExtArgs(Tpl.emptyTxt, i_args);
        l_func__str = fun_21(Tpl.emptyTxt, l_func__name__str, l_func__args__str);
        l_ext__output__str = dumpExtArg(Tpl.emptyTxt, i_returnArg);
        l_output__str = fun_22(Tpl.emptyTxt, l_ext__output__str);
        l_lang__str = Tpl.writeStr(Tpl.emptyTxt, i_language);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \""));
        txt = Tpl.writeText(txt, l_lang__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" "));
        txt = Tpl.writeText(txt, l_output__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpExternalDecl;

protected function lm_24
  input Tpl.Text in_txt;
  input list<DAE.ExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ExtArg> rest;
      DAE.ExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = dumpExtArg(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_24(txt, rest);
      then txt;
  end match;
end lm_24;

public function dumpExtArgs
  input Tpl.Text txt;
  input list<DAE.ExtArg> a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_24(out_txt, a_args);
  out_txt := Tpl.popIter(out_txt);
end dumpExtArgs;

public function dumpExtArg
  input Tpl.Text in_txt;
  input DAE.ExtArg in_a_arg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arg)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.ComponentRef i_componentRef;

    case ( txt,
           DAE.EXTARG(componentRef = i_componentRef) )
      equation
        txt = dumpCref(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.EXTARGEXP(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           DAE.EXTARGSIZE(componentRef = i_componentRef, exp = i_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size("));
        txt = dumpCref(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = dumpExp(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpExtArg;

public function dumpRecordInputVarStr
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__)
    local
      Tpl.Text txt;
      DAE.Type i_funcResultType;
      list<DAE.Var> i_varLst;

    case ( txt,
           DAE.T_COMPLEX(varLst = i_varLst) )
      equation
        txt = dumpRecordVars(txt, i_varLst);
      then txt;

    case ( txt,
           DAE.T_FUNCTION(funcResultType = i_funcResultType) )
      equation
        txt = dumpRecordInputVarStr(txt, i_funcResultType);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpRecordInputVarStr;

protected function lm_28
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      DAE.Var i_v;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_v :: rest )
      equation
        txt = dumpRecordVar(txt, i_v);
        txt = Tpl.nextIter(txt);
        txt = lm_28(txt, rest);
      then txt;
  end match;
end lm_28;

public function dumpRecordVars
  input Tpl.Text txt;
  input list<DAE.Var> a_varLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_28(out_txt, a_varLst);
  out_txt := Tpl.popIter(out_txt);
end dumpRecordVars;

public function dumpRecordVar
  input Tpl.Text in_txt;
  input DAE.Var in_a_v;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_v)
    local
      Tpl.Text txt;
      DAE.Binding i_binding;
      DAE.Ident i_name;
      DAE.Type i_ty;
      Tpl.Text l_varType;

    case ( txt,
           DAE.TYPES_VAR(attributes = DAE.ATTR(visibility = SCode.PROTECTED()), ty = i_ty, name = i_name, binding = i_binding) )
      equation
        l_varType = dumpVarType(Tpl.emptyTxt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("protected "));
        txt = Tpl.writeText(txt, l_varType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpRecordVarBinding(txt, i_binding);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.TYPES_VAR(attributes = DAE.ATTR(variability = SCode.CONST()), ty = i_ty, name = i_name, binding = i_binding) )
      equation
        l_varType = dumpVarType(Tpl.emptyTxt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant "));
        txt = Tpl.writeText(txt, l_varType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpRecordVarBinding(txt, i_binding);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.TYPES_VAR(ty = i_ty, name = i_name, binding = i_binding) )
      equation
        l_varType = dumpVarType(Tpl.emptyTxt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("input "));
        txt = Tpl.writeText(txt, l_varType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpRecordVarBinding(txt, i_binding);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpRecordVar;

public function dumpRecordVarBinding
  input Tpl.Text in_txt;
  input DAE.Binding in_a_binding;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_binding)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           DAE.UNBOUND() )
      then txt;

    case ( txt,
           DAE.EQBOUND(exp = i_exp) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = dumpExp(txt, i_exp);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           DAE.VALBOUND(valBound = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("value bound***** check what to display"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpRecordVarBinding;

protected function lm_32
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_lst;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lst :: rest )
      equation
        txt = dumpElement(txt, i_lst);
        txt = Tpl.nextIter(txt);
        txt = lm_32(txt, rest);
      then txt;
  end match;
end lm_32;

public function dumpElements
  input Tpl.Text txt;
  input list<DAE.Element> a_dAElist;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_32(out_txt, a_dAElist);
  out_txt := Tpl.popIter(out_txt);
end dumpElements;

public function dumpElement
  input Tpl.Text in_txt;
  input DAE.Element in_a_lst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lst)
    local
      Tpl.Text txt;
      DAE.Algorithm i_algorithm__;
      DAE.Element i_lst;

    case ( txt,
           (i_lst as DAE.VAR(componentRef = _)) )
      equation
        txt = dumpVar(txt, i_lst, true);
      then txt;

    case ( txt,
           DAE.INITIALALGORITHM(algorithm_ = i_algorithm__) )
      equation
        txt = dumpAlgorithmElement(txt, i_algorithm__, "initial algorithm");
      then txt;

    case ( txt,
           DAE.ALGORITHM(algorithm_ = i_algorithm__) )
      equation
        txt = dumpAlgorithmElement(txt, i_algorithm__, "algorithm");
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Element not found"));
      then txt;
  end match;
end dumpElement;

public function dumpAlgorithmElement
  input Tpl.Text in_txt;
  input DAE.Algorithm in_a_algorithm__;
  input String in_a_label;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_algorithm__, in_a_label)
    local
      Tpl.Text txt;
      String a_label;
      list<DAE.Statement> i_statementLst;

    case ( txt,
           DAE.ALGORITHM_STMTS(statementLst = i_statementLst),
           a_label )
      equation
        txt = Tpl.writeStr(txt, a_label);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpStatements(txt, i_statementLst);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpAlgorithmElement;

protected function lm_36
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = dumpVar(txt, i_var, false);
        txt = Tpl.nextIter(txt);
        txt = lm_36(txt, rest);
      then txt;
  end match;
end lm_36;

public function dumpVars
  input Tpl.Text txt;
  input list<DAE.Element> a_v;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_36(out_txt, a_v);
  out_txt := Tpl.popIter(out_txt);
end dumpVars;

protected function fun_38
  input Tpl.Text in_txt;
  input Option<DAE.VariableAttributes> in_a_variableAttributesOption;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_variableAttributesOption)
    local
      Tpl.Text txt;
      DAE.VariableAttributes i_VariableAttributes;

    case ( txt,
           SOME(i_VariableAttributes) )
      equation
        txt = dumpFinalPrefix(txt, i_VariableAttributes);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_38;

protected function fun_39
  input Tpl.Text in_txt;
  input Boolean in_a_printTypeDimension;
  input DAE.InstDims in_a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_printTypeDimension, in_a_dims)
    local
      Tpl.Text txt;
      DAE.InstDims a_dims;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_dims )
      equation
        txt = dumpTypeDimensions(txt, a_dims);
      then txt;
  end match;
end fun_39;

protected function fun_40
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_binding;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_binding)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_40;

protected function fun_41
  input Tpl.Text in_txt;
  input Option<DAE.VariableAttributes> in_a_variableAttributesOption;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_variableAttributesOption)
    local
      Tpl.Text txt;
      DAE.VariableAttributes i_VariableAttributes;

    case ( txt,
           SOME(i_VariableAttributes) )
      equation
        txt = dumpVariableAttributesStr(txt, i_VariableAttributes);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_41;

protected function fun_42
  input Tpl.Text in_txt;
  input Tpl.Text in_a_bindingExp;
  input Tpl.Text in_a_cmt__str;
  input Tpl.Text in_a_varAttr;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_dim__str;
  input Tpl.Text in_a_varType;
  input Tpl.Text in_a_varDirection;
  input Tpl.Text in_a_varKind;
  input Tpl.Text in_a_varParallelism;
  input Tpl.Text in_a_varVisibility;
  input Tpl.Text in_a_final;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bindingExp, in_a_cmt__str, in_a_varAttr, in_a_varName, in_a_dim__str, in_a_varType, in_a_varDirection, in_a_varKind, in_a_varParallelism, in_a_varVisibility, in_a_final)
    local
      Tpl.Text txt;
      Tpl.Text a_cmt__str;
      Tpl.Text a_varAttr;
      Tpl.Text a_varName;
      Tpl.Text a_dim__str;
      Tpl.Text a_varType;
      Tpl.Text a_varDirection;
      Tpl.Text a_varKind;
      Tpl.Text a_varParallelism;
      Tpl.Text a_varVisibility;
      Tpl.Text a_final;
      Tpl.Text i_bindingExp;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_cmt__str,
           a_varAttr,
           a_varName,
           a_dim__str,
           a_varType,
           a_varDirection,
           a_varKind,
           a_varParallelism,
           a_varVisibility,
           a_final )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_final);
        txt = Tpl.writeText(txt, a_varVisibility);
        txt = Tpl.writeText(txt, a_varParallelism);
        txt = Tpl.writeText(txt, a_varKind);
        txt = Tpl.writeText(txt, a_varDirection);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varType);
        txt = Tpl.writeText(txt, a_dim__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeText(txt, a_varAttr);
        txt = Tpl.writeText(txt, a_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_bindingExp,
           a_cmt__str,
           a_varAttr,
           a_varName,
           a_dim__str,
           a_varType,
           a_varDirection,
           a_varKind,
           a_varParallelism,
           a_varVisibility,
           a_final )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_final);
        txt = Tpl.writeText(txt, a_varVisibility);
        txt = Tpl.writeText(txt, a_varParallelism);
        txt = Tpl.writeText(txt, a_varKind);
        txt = Tpl.writeText(txt, a_varDirection);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varType);
        txt = Tpl.writeText(txt, a_dim__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeText(txt, a_varAttr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, i_bindingExp);
        txt = Tpl.writeText(txt, a_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_42;

public function dumpVar
  input Tpl.Text in_txt;
  input DAE.Element in_a_lst;
  input Boolean in_a_printTypeDimension;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lst, in_a_printTypeDimension)
    local
      Tpl.Text txt;
      Boolean a_printTypeDimension;
      Option<SCode.Comment> i_absynCommentOption;
      Option<DAE.Exp> i_binding;
      DAE.ComponentRef i_componentRef;
      DAE.InstDims i_dims;
      DAE.Type i_ty;
      DAE.VarDirection i_direction;
      DAE.VarKind i_kind;
      DAE.VarParallelism i_parallelism;
      DAE.VarVisibility i_protection;
      Option<DAE.VariableAttributes> i_variableAttributesOption;
      Tpl.Text l_cmt__str;
      Tpl.Text l_varAttr;
      Tpl.Text l_bindingExp;
      Tpl.Text l_varName;
      Tpl.Text l_dim__str;
      Tpl.Text l_varType;
      Tpl.Text l_varDirection;
      Tpl.Text l_varKind;
      Tpl.Text l_varParallelism;
      Tpl.Text l_varVisibility;
      Tpl.Text l_final;

    case ( txt,
           DAE.VAR(variableAttributesOption = i_variableAttributesOption, protection = i_protection, parallelism = i_parallelism, kind = i_kind, direction = i_direction, ty = i_ty, dims = i_dims, componentRef = i_componentRef, binding = i_binding, absynCommentOption = i_absynCommentOption),
           a_printTypeDimension )
      equation
        l_final = fun_38(Tpl.emptyTxt, i_variableAttributesOption);
        l_varVisibility = dumpVarVisibility(Tpl.emptyTxt, i_protection);
        l_varParallelism = dumpVarParallelism(Tpl.emptyTxt, i_parallelism);
        l_varKind = dumpVarKind(Tpl.emptyTxt, i_kind);
        l_varDirection = dumpVarDirection(Tpl.emptyTxt, i_direction);
        l_varType = dumpVarType(Tpl.emptyTxt, i_ty);
        l_dim__str = fun_39(Tpl.emptyTxt, a_printTypeDimension, i_dims);
        l_varName = dumpCref(Tpl.emptyTxt, i_componentRef);
        l_bindingExp = fun_40(Tpl.emptyTxt, i_binding);
        l_varAttr = fun_41(Tpl.emptyTxt, i_variableAttributesOption);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_absynCommentOption);
        txt = fun_42(txt, l_bindingExp, l_cmt__str, l_varAttr, l_varName, l_dim__str, l_varType, l_varDirection, l_varKind, l_varParallelism, l_varVisibility, l_final);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpVar;

public function dumpFinalPrefix
  input Tpl.Text in_txt;
  input DAE.VariableAttributes in_a_varAttr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varAttr)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.VAR_ATTR_REAL(finalPrefix = SOME(true)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" final"));
      then txt;

    case ( txt,
           DAE.VAR_ATTR_INT(finalPrefix = SOME(true)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" final"));
      then txt;

    case ( txt,
           DAE.VAR_ATTR_BOOL(finalPrefix = SOME(true)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" final"));
      then txt;

    case ( txt,
           DAE.VAR_ATTR_STRING(finalPrefix = SOME(true)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" final"));
      then txt;

    case ( txt,
           DAE.VAR_ATTR_ENUMERATION(finalPrefix = SOME(true)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" final"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFinalPrefix;

public function dumpVarVisibility
  input Tpl.Text in_txt;
  input DAE.VarVisibility in_a_protection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_protection)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.PROTECTED() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" protected"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVarVisibility;

public function dumpVarParallelism
  input Tpl.Text in_txt;
  input DAE.VarParallelism in_a_parallelism;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_parallelism)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.PARGLOBAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" parglobal"));
      then txt;

    case ( txt,
           DAE.PARLOCAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" parlocal"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVarParallelism;

public function dumpVarKind
  input Tpl.Text in_txt;
  input DAE.VarKind in_a_kind;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_kind)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.CONST() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" constant"));
      then txt;

    case ( txt,
           DAE.PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" parameter"));
      then txt;

    case ( txt,
           DAE.DISCRETE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" discrete"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVarKind;

public function dumpVarDirection
  input Tpl.Text in_txt;
  input DAE.VarDirection in_a_direction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_direction)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.INPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" input"));
      then txt;

    case ( txt,
           DAE.OUTPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" output"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVarDirection;

public function dumpVarType
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      Absyn.Path i_rname;
      DAE.Dimensions i_dims;
      DAE.Type i_ty;
      list<DAE.Var> i_varLst;
      list<DAE.Var> i_literalVarLst;

    case ( txt,
           DAE.T_INTEGER(varLst = {}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Integer"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = {}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = {}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("String"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = {}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Boolean"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(literalVarLst = i_literalVarLst) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("enumeration("));
        txt = dumpEnumVars(txt, i_literalVarLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.T_INTEGER(varLst = i_varLst) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Integer("));
        txt = dumpVarAttributes(txt, i_varLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = i_varLst) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real("));
        txt = dumpVarAttributes(txt, i_varLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = i_varLst) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("String("));
        txt = dumpVarAttributes(txt, i_varLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = i_varLst) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Bool("));
        txt = dumpVarAttributes(txt, i_varLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty, dims = i_dims) )
      equation
        txt = dumpVarType(txt, i_ty);
        txt = dumpDimensions(txt, i_dims);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)) )
      equation
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_rname);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("variable type not yet implemented"));
      then txt;
  end match;
end dumpVarType;

protected function lm_50
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      DAE.Var i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = dumpEnumVar(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;
  end match;
end lm_50;

public function dumpEnumVars
  input Tpl.Text txt;
  input list<DAE.Var> a_literalVarLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_50(out_txt, a_literalVarLst);
  out_txt := Tpl.popIter(out_txt);
end dumpEnumVars;

public function dumpEnumVar
  input Tpl.Text in_txt;
  input DAE.Var in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Ident i_name;

    case ( txt,
           DAE.TYPES_VAR(name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpEnumVar;

protected function lm_53
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      DAE.Var i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = dumpVarAttribute(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest);
      then txt;
  end match;
end lm_53;

public function dumpVarAttributes
  input Tpl.Text txt;
  input list<DAE.Var> a_literalVarLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_53(out_txt, a_literalVarLst);
  out_txt := Tpl.popIter(out_txt);
end dumpVarAttributes;

public function dumpVarAttribute
  input Tpl.Text in_txt;
  input DAE.Var in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Exp i_e;
      DAE.Ident i_name;

    case ( txt,
           DAE.TYPES_VAR(binding = DAE.EQBOUND(exp = i_e), name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("="));
        txt = dumpExp(txt, i_e);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVarAttribute;

protected function lm_56
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Dimension> rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dumpDimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest);
      then txt;
  end match;
end lm_56;

public function dumpDimensions
  input Tpl.Text txt;
  input list<DAE.Dimension> a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_56(out_txt, a_dims);
  out_txt := Tpl.popIter(out_txt);
end dumpDimensions;

public function dumpDimension
  input Tpl.Text in_txt;
  input DAE.Dimension in_a_dim;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dim)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Absyn.Path i_enumTypeName;
      Integer i_integer;

    case ( txt,
           DAE.DIM_INTEGER(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.DIM_ENUM(enumTypeName = i_enumTypeName) )
      equation
        txt = AbsynDumpTpl.dumpPath(txt, i_enumTypeName);
      then txt;

    case ( txt,
           DAE.DIM_EXP(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           DAE.DIM_UNKNOWN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpDimension;

protected function smf_59
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_59;

protected function smf_60
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_60;

protected function smf_61
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_61;

protected function smf_62
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_62;

protected function smf_63
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_63;

protected function smf_64
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_64;

protected function smf_65
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_65;

protected function smf_66
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_66;

protected function smf_67
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_67;

protected function fun_68
  input Tpl.Text in_txt;
  input Tpl.Text in_a_attrs__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attrs__str)
    local
      Tpl.Text txt;
      Tpl.Text i_attrs__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_attrs__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_attrs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_68;

protected function smf_69
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_69;

protected function smf_70
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_70;

protected function smf_71
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_71;

protected function smf_72
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_72;

protected function fun_73
  input Tpl.Text in_txt;
  input Tpl.Text in_a_attrs__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attrs__str)
    local
      Tpl.Text txt;
      Tpl.Text i_attrs__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_attrs__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_attrs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_73;

protected function smf_74
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_74;

protected function smf_75
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_75;

protected function smf_76
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_76;

protected function fun_77
  input Tpl.Text in_txt;
  input Tpl.Text in_a_attrs__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attrs__str)
    local
      Tpl.Text txt;
      Tpl.Text i_attrs__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_attrs__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_attrs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_77;

protected function smf_78
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_78;

protected function smf_79
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_79;

protected function fun_80
  input Tpl.Text in_txt;
  input Tpl.Text in_a_attrs__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attrs__str)
    local
      Tpl.Text txt;
      Tpl.Text i_attrs__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_attrs__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_attrs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_80;

protected function smf_81
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_81;

protected function smf_82
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_82;

protected function smf_83
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_83;

protected function smf_84
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_84;

protected function fun_85
  input Tpl.Text in_txt;
  input Tpl.Text in_a_attrs__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attrs__str)
    local
      Tpl.Text txt;
      Tpl.Text i_attrs__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_attrs__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_attrs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_85;

public function dumpVariableAttributesStr
  input Tpl.Text in_txt;
  input DAE.VariableAttributes in_a_variableAttributesOption;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_variableAttributesOption)
    local
      Tpl.Text txt;
      Option<DAE.Exp> i_start;
      Option<DAE.Uncertainty> i_uncertainOption;
      Option<DAE.StateSelect> i_stateSelectOption;
      Option<DAE.Exp> i_nominal;
      tuple<Option<DAE.Exp>, Option<DAE.Exp>> i_min;
      Option<DAE.Exp> i_fixed;
      Option<DAE.Exp> i_initial__;
      Option<DAE.Exp> i_displayUnit;
      Option<DAE.Exp> i_unit;
      Option<DAE.Exp> i_quantity;
      Tpl.Text l_attrs__str;
      Tpl.Text l_uncertainty__str;
      Tpl.Text l_stateSel__str;
      Tpl.Text l_nominal__str;
      Tpl.Text l_min__max__str;
      Tpl.Text l_fixed__str;
      Tpl.Text l_start__str;
      Tpl.Text l_displayunit__str;
      Tpl.Text l_unit__str;
      Tpl.Text l_quantity__str;

    case ( txt,
           DAE.VAR_ATTR_REAL(quantity = i_quantity, unit = i_unit, displayUnit = i_displayUnit, initial_ = i_initial__, fixed = i_fixed, min = i_min, nominal = i_nominal, stateSelectOption = i_stateSelectOption, uncertainOption = i_uncertainOption) )
      equation
        l_quantity__str = dumpQuantityAttribute(Tpl.emptyTxt, i_quantity);
        l_unit__str = dumpUnitAttribute(Tpl.emptyTxt, i_unit);
        l_displayunit__str = dumpDisplayUnitAttribute(Tpl.emptyTxt, i_displayUnit);
        l_start__str = dumpInitialAttribute(Tpl.emptyTxt, i_initial__);
        l_fixed__str = dumpFixedAttribute(Tpl.emptyTxt, i_fixed);
        l_min__max__str = dumpMinMaxAttribute(Tpl.emptyTxt, i_min);
        l_nominal__str = dumpNominalAttribute(Tpl.emptyTxt, i_nominal);
        l_stateSel__str = dumpStateSelectStrs(Tpl.emptyTxt, i_stateSelectOption);
        l_uncertainty__str = dumpUncertaintyStrs(Tpl.emptyTxt, i_uncertainOption);
        l_attrs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attrs__str = smf_59(l_attrs__str, l_quantity__str);
        l_attrs__str = smf_60(l_attrs__str, l_unit__str);
        l_attrs__str = smf_61(l_attrs__str, l_displayunit__str);
        l_attrs__str = smf_62(l_attrs__str, l_min__max__str);
        l_attrs__str = smf_63(l_attrs__str, l_start__str);
        l_attrs__str = smf_64(l_attrs__str, l_fixed__str);
        l_attrs__str = smf_65(l_attrs__str, l_nominal__str);
        l_attrs__str = smf_66(l_attrs__str, l_stateSel__str);
        l_attrs__str = smf_67(l_attrs__str, l_uncertainty__str);
        l_attrs__str = Tpl.popIter(l_attrs__str);
        txt = fun_68(txt, l_attrs__str);
      then txt;

    case ( txt,
           DAE.VAR_ATTR_INT(quantity = i_quantity, initial_ = i_initial__, fixed = i_fixed, min = i_min) )
      equation
        l_quantity__str = dumpQuantityAttribute(Tpl.emptyTxt, i_quantity);
        l_start__str = dumpInitialAttribute(Tpl.emptyTxt, i_initial__);
        l_fixed__str = dumpFixedAttribute(Tpl.emptyTxt, i_fixed);
        l_min__max__str = dumpMinMaxAttribute(Tpl.emptyTxt, i_min);
        l_attrs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attrs__str = smf_69(l_attrs__str, l_quantity__str);
        l_attrs__str = smf_70(l_attrs__str, l_min__max__str);
        l_attrs__str = smf_71(l_attrs__str, l_start__str);
        l_attrs__str = smf_72(l_attrs__str, l_fixed__str);
        l_attrs__str = Tpl.popIter(l_attrs__str);
        txt = fun_73(txt, l_attrs__str);
      then txt;

    case ( txt,
           DAE.VAR_ATTR_BOOL(quantity = i_quantity, initial_ = i_initial__, fixed = i_fixed) )
      equation
        l_quantity__str = dumpQuantityAttribute(Tpl.emptyTxt, i_quantity);
        l_start__str = dumpInitialAttribute(Tpl.emptyTxt, i_initial__);
        l_fixed__str = dumpFixedAttribute(Tpl.emptyTxt, i_fixed);
        l_attrs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attrs__str = smf_74(l_attrs__str, l_quantity__str);
        l_attrs__str = smf_75(l_attrs__str, l_start__str);
        l_attrs__str = smf_76(l_attrs__str, l_fixed__str);
        l_attrs__str = Tpl.popIter(l_attrs__str);
        txt = fun_77(txt, l_attrs__str);
      then txt;

    case ( txt,
           DAE.VAR_ATTR_STRING(quantity = i_quantity, initial_ = i_initial__) )
      equation
        l_quantity__str = dumpQuantityAttribute(Tpl.emptyTxt, i_quantity);
        l_start__str = dumpInitialAttribute(Tpl.emptyTxt, i_initial__);
        l_attrs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attrs__str = smf_78(l_attrs__str, l_quantity__str);
        l_attrs__str = smf_79(l_attrs__str, l_start__str);
        l_attrs__str = Tpl.popIter(l_attrs__str);
        txt = fun_80(txt, l_attrs__str);
      then txt;

    case ( txt,
           DAE.VAR_ATTR_ENUMERATION(quantity = i_quantity, start = i_start, fixed = i_fixed, min = i_min) )
      equation
        l_quantity__str = dumpQuantityAttribute(Tpl.emptyTxt, i_quantity);
        l_start__str = dumpInitialAttribute(Tpl.emptyTxt, i_start);
        l_fixed__str = dumpFixedAttribute(Tpl.emptyTxt, i_fixed);
        l_min__max__str = dumpMinMaxAttribute(Tpl.emptyTxt, i_min);
        l_attrs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attrs__str = smf_81(l_attrs__str, l_quantity__str);
        l_attrs__str = smf_82(l_attrs__str, l_min__max__str);
        l_attrs__str = smf_83(l_attrs__str, l_start__str);
        l_attrs__str = smf_84(l_attrs__str, l_fixed__str);
        l_attrs__str = Tpl.popIter(l_attrs__str);
        txt = fun_85(txt, l_attrs__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVariableAttributesStr;

public function dumpQuantityAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_quantity;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_quantity)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("quantity = "));
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpQuantityAttribute;

public function dumpUnitAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_unit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_unit)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unit = "));
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpUnitAttribute;

public function dumpDisplayUnitAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_displayUnit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_displayUnit)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("displayUnit = "));
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpDisplayUnitAttribute;

public function dumpInitialAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initial__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initial__)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start = "));
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInitialAttribute;

public function dumpFixedAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_fixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fixed)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fixed = "));
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFixedAttribute;

public function dumpMinMaxAttribute
  input Tpl.Text in_txt;
  input tuple<Option<DAE.Exp>, Option<DAE.Exp>> in_a_min;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_min)
    local
      Tpl.Text txt;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;

    case ( txt,
           (SOME(i_exp1), SOME(i_exp2)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("min = "));
        txt = dumpExp(txt, i_exp1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", max = "));
        txt = dumpExp(txt, i_exp2);
      then txt;

    case ( txt,
           (NONE(), SOME(i_exp2)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("max = "));
        txt = dumpExp(txt, i_exp2);
      then txt;

    case ( txt,
           (SOME(i_exp1), NONE()) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("min = "));
        txt = dumpExp(txt, i_exp1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpMinMaxAttribute;

public function dumpNominalAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_nominal;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nominal)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nominal = "));
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpNominalAttribute;

public function dumpStateSelectStrs
  input Tpl.Text in_txt;
  input Option<DAE.StateSelect> in_a_stateS;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stateS)
    local
      Tpl.Text txt;
      DAE.StateSelect i_StateSelect;

    case ( txt,
           SOME(i_StateSelect) )
      equation
        txt = dumpStateSelectStr(txt, i_StateSelect);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpStateSelectStrs;

public function dumpStateSelectStr
  input Tpl.Text in_txt;
  input DAE.StateSelect in_a_stateS;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stateS)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.NEVER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("stateSelect = StateSelect.never"));
      then txt;

    case ( txt,
           DAE.AVOID() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("stateSelect = StateSelect.avoid"));
      then txt;

    case ( txt,
           DAE.DEFAULT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("stateSelect = StateSelect.default"));
      then txt;

    case ( txt,
           DAE.PREFER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("stateSelect = StateSelect.prefer"));
      then txt;

    case ( txt,
           DAE.ALWAYS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("stateSelect = StateSelect.always"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpStateSelectStr;

public function dumpUncertaintyStrs
  input Tpl.Text in_txt;
  input Option<DAE.Uncertainty> in_a_uncertain;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_uncertain)
    local
      Tpl.Text txt;
      DAE.Uncertainty i_Uncertainty;

    case ( txt,
           SOME(i_Uncertainty) )
      equation
        txt = dumpUncertaintyStr(txt, i_Uncertainty);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpUncertaintyStrs;

public function dumpUncertaintyStr
  input Tpl.Text in_txt;
  input DAE.Uncertainty in_a_uncertain;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_uncertain)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.GIVEN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("uncertainty = Uncertainty.given"));
      then txt;

    case ( txt,
           DAE.SOUGHT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("uncertainty = Uncertainty.sought"));
      then txt;

    case ( txt,
           DAE.REFINE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("uncertainty = Uncertainty.refine"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpUncertaintyStr;

public function dumpCref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = dumpSubscripts(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dumpCref(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = (i_ident as "$DER"), subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der("));
        txt = Tpl.writeStr(txt, i_ident);
        txt = dumpSubscripts(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = dumpSubscripts(txt, i_subscriptLst);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpCref;

protected function lm_99
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = dumpSubscript(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_99(txt, rest);
      then txt;
  end match;
end lm_99;

public function dumpTypeDimensions
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscriptLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscriptLst)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscriptLst;
      Tpl.Text l_sub__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscriptLst )
      equation
        l_sub__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_sub__str = lm_99(l_sub__str, i_subscriptLst);
        l_sub__str = Tpl.popIter(l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end dumpTypeDimensions;

protected function lm_101
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = dumpSubscript(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_101(txt, rest);
      then txt;
  end match;
end lm_101;

public function dumpSubscripts
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscriptLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscriptLst)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscriptLst;
      Tpl.Text l_sub__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscriptLst )
      equation
        l_sub__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_sub__str = lm_101(l_sub__str, i_subscriptLst);
        l_sub__str = Tpl.popIter(l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end dumpSubscripts;

public function dumpSubscript
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           DAE.SLICE(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           DAE.INDEX(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           DAE.WHOLE_NONEXP(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpSubscript;

protected function lm_104
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_ineq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ineq :: rest )
      equation
        txt = dumpInitialEquation(txt, i_ineq);
        txt = Tpl.nextIter(txt);
        txt = lm_104(txt, rest);
      then txt;
  end match;
end lm_104;

public function dumpInitialEquations
  input Tpl.Text in_txt;
  input list<DAE.Element> in_a_ie;
  input String in_a_label;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ie, in_a_label)
    local
      Tpl.Text txt;
      String a_label;
      list<DAE.Element> i_ie;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_ie,
           a_label )
      equation
        txt = Tpl.writeStr(txt, a_label);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_104(txt, i_ie);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end dumpInitialEquations;

public function dumpInitialEquation
  input Tpl.Text in_txt;
  input DAE.Element in_a_lst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lst)
    local
      Tpl.Text txt;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      DAE.Element i_lst;
      DAE.Exp i_rhs;
      DAE.Exp i_lhs;
      DAE.Exp i_array;
      DAE.Exp i_exp;
      DAE.ComponentRef i_componentRef;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           DAE.INITIALDEFINE(componentRef = i_componentRef, exp = i_exp) )
      equation
        l_lhs__str = dumpCref(Tpl.emptyTxt, i_componentRef);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_exp);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.INITIAL_ARRAY_EQUATION(exp = i_exp, array = i_array) )
      equation
        l_lhs__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_array);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.INITIAL_COMPLEX_EQUATION(lhs = i_lhs, rhs = i_rhs) )
      equation
        l_lhs__str = dumpExp(Tpl.emptyTxt, i_lhs);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_rhs);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           (i_lst as DAE.INITIAL_IF_EQUATION(condition1 = _)) )
      equation
        txt = dumpInitialIfEquation(txt, i_lst);
      then txt;

    case ( txt,
           DAE.INITIALEQUATION(exp1 = i_exp1, exp2 = i_exp2) )
      equation
        l_lhs__str = dumpExp(Tpl.emptyTxt, i_exp1);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_exp2);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInitialEquation;

protected function lm_107
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_107(txt, rest);
      then txt;
  end match;
end lm_107;

protected function lm_108
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_108(txt, rest);
      then txt;
  end match;
end lm_108;

protected function fun_109
  input Tpl.Text in_txt;
  input list<DAE.Element> in_a_equations3;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_equations3)
    local
      Tpl.Text txt;
      list<DAE.Element> i_equations3;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_equations3 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_108(txt, i_equations3);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_109;

public function dumpInitialIfEquation
  input Tpl.Text in_txt;
  input DAE.Element in_a_lst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lst)
    local
      Tpl.Text txt;
      list<DAE.Element> i_equations3;
      list<list<DAE.Element>> i_elseif__branches;
      list<DAE.Exp> i_elseif__conds;
      list<DAE.Element> i_if__branch;
      DAE.Exp i_if__cond;
      Tpl.Text l_else__str;
      Tpl.Text l_elseif__str;
      Tpl.Text l_if__branch__str;
      Tpl.Text l_if__cond__str;

    case ( txt,
           DAE.INITIAL_IF_EQUATION(condition1 = i_if__cond :: i_elseif__conds, equations2 = i_if__branch :: i_elseif__branches, equations3 = i_equations3) )
      equation
        l_if__cond__str = dumpExp(Tpl.emptyTxt, i_if__cond);
        l_if__branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_if__branch__str = lm_107(l_if__branch__str, i_if__branch);
        l_if__branch__str = Tpl.popIter(l_if__branch__str);
        l_elseif__str = dumpElseIfEquation(Tpl.emptyTxt, i_elseif__conds, i_elseif__branches);
        l_else__str = fun_109(Tpl.emptyTxt, i_equations3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_if__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.writeText(txt, l_if__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_elseif__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_else__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end if;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInitialIfEquation;

protected function lm_111
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = dumpEquation(txt, i_eq);
        txt = Tpl.nextIter(txt);
        txt = lm_111(txt, rest);
      then txt;
  end match;
end lm_111;

public function dumpEquations
  input Tpl.Text in_txt;
  input list<DAE.Element> in_a_e;
  input String in_a_label;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_e, in_a_label)
    local
      Tpl.Text txt;
      String a_label;
      list<DAE.Element> i_e;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_e,
           a_label )
      equation
        txt = Tpl.writeStr(txt, a_label);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_111(txt, i_e);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end dumpEquations;

public function dumpEquation
  input Tpl.Text in_txt;
  input DAE.Element in_a_lst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lst)
    local
      Tpl.Text txt;
      DAE.Exp i_message;
      DAE.Exp i_condition;
      DAE.Element i_lst;
      DAE.ComponentRef i_componentRef;
      DAE.Exp i_rhs;
      DAE.Exp i_lhs;
      DAE.Exp i_array;
      DAE.ComponentRef i_cr2;
      DAE.ComponentRef i_cr1;
      DAE.ElementSource i_source;
      DAE.Exp i_scalar;
      DAE.Exp i_exp;
      Tpl.Text l_exp__str;
      Tpl.Text l_cref__str;
      Tpl.Text l_msg__str;
      Tpl.Text l_cond__str;
      Tpl.Text l_rhs__cref;
      Tpl.Text l_lhs__cref;
      Tpl.Text l_source__src;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           DAE.EQUATION(exp = i_exp, scalar = i_scalar, source = i_source) )
      equation
        l_lhs__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_scalar);
        l_source__src = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeText(txt, l_source__src);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.EQUEQUATION(cr1 = i_cr1, cr2 = i_cr2, source = i_source) )
      equation
        l_lhs__cref = dumpCref(Tpl.emptyTxt, i_cr1);
        l_rhs__cref = dumpCref(Tpl.emptyTxt, i_cr2);
        l_source__src = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeText(txt, l_lhs__cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rhs__cref);
        txt = Tpl.writeText(txt, l_source__src);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.ARRAY_EQUATION(exp = i_exp, array = i_array, source = i_source) )
      equation
        l_lhs__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_array);
        l_source__src = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeText(txt, l_source__src);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.COMPLEX_EQUATION(lhs = i_lhs, rhs = i_rhs, source = i_source) )
      equation
        l_lhs__str = dumpExp(Tpl.emptyTxt, i_lhs);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_rhs);
        l_source__src = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeText(txt, l_source__src);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.DEFINE(componentRef = i_componentRef, exp = i_exp, source = i_source) )
      equation
        l_lhs__str = dumpCref(Tpl.emptyTxt, i_componentRef);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_source__src = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeText(txt, l_source__src);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           (i_lst as DAE.WHEN_EQUATION(condition = _)) )
      equation
        txt = dumpWhenEquation(txt, i_lst);
      then txt;

    case ( txt,
           (i_lst as DAE.IF_EQUATION(condition1 = _)) )
      equation
        txt = dumpIfEquation(txt, i_lst);
      then txt;

    case ( txt,
           DAE.ASSERT(condition = i_condition, message = i_message, source = i_source) )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, i_condition);
        l_msg__str = dumpExp(Tpl.emptyTxt, i_message);
        l_source__src = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assert("));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_msg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_source__src);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.TERMINATE(message = i_message, source = i_source) )
      equation
        l_msg__str = dumpExp(Tpl.emptyTxt, i_message);
        l_source__src = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("terminate("));
        txt = Tpl.writeText(txt, l_msg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_source__src);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.REINIT(componentRef = i_componentRef, exp = i_exp, source = i_source) )
      equation
        l_cref__str = dumpCref(Tpl.emptyTxt, i_componentRef);
        l_exp__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_source__src = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("reinit("));
        txt = Tpl.writeText(txt, l_cref__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_source__src);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.NORETCALL(source = i_source) )
      equation
        l_source__src = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NO_RETURN_CALL"));
        txt = Tpl.writeText(txt, l_source__src);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN EQUATION TYPE"));
      then txt;
  end match;
end dumpEquation;

protected function lm_114
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_114(txt, rest);
      then txt;
  end match;
end lm_114;

protected function fun_115
  input Tpl.Text in_txt;
  input DAE.Element in_a_lst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lst)
    local
      Tpl.Text txt;
      DAE.Element i_Element;

    case ( txt,
           DAE.WHEN_EQUATION(elsewhen_ = SOME(i_Element)) )
      equation
        txt = dumpEquation(txt, i_Element);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_115;

protected function fun_116
  input Tpl.Text in_txt;
  input Tpl.Text in_a_elsewhen__str;
  input Tpl.Text in_a_body__str;
  input Tpl.Text in_a_when__cond__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elsewhen__str, in_a_body__str, in_a_when__cond__str)
    local
      Tpl.Text txt;
      Tpl.Text a_body__str;
      Tpl.Text a_when__cond__str;
      Tpl.Text i_elsewhen__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_body__str,
           a_when__cond__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, a_when__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
      then txt;

    case ( txt,
           i_elsewhen__str,
           a_body__str,
           a_when__cond__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, a_when__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else"));
        txt = Tpl.writeText(txt, i_elsewhen__str);
      then txt;
  end match;
end fun_116;

public function dumpWhenEquation
  input Tpl.Text in_txt;
  input DAE.Element in_a_lst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lst)
    local
      Tpl.Text txt;
      DAE.Element i_lst;
      list<DAE.Element> i_equations;
      DAE.Exp i_condition;
      Tpl.Text l_elsewhen__str;
      Tpl.Text l_body__str;
      Tpl.Text l_when__cond__str;

    case ( txt,
           (i_lst as DAE.WHEN_EQUATION(condition = i_condition, equations = i_equations)) )
      equation
        l_when__cond__str = dumpExp(Tpl.emptyTxt, i_condition);
        l_body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__str = lm_114(l_body__str, i_equations);
        l_body__str = Tpl.popIter(l_body__str);
        l_elsewhen__str = fun_115(Tpl.emptyTxt, i_lst);
        txt = fun_116(txt, l_elsewhen__str, l_body__str, l_when__cond__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpWhenEquation;

protected function lm_118
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_118(txt, rest);
      then txt;
  end match;
end lm_118;

protected function lm_119
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_119(txt, rest);
      then txt;
  end match;
end lm_119;

protected function fun_120
  input Tpl.Text in_txt;
  input list<DAE.Element> in_a_equations3;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_equations3)
    local
      Tpl.Text txt;
      list<DAE.Element> i_equations3;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_equations3 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_119(txt, i_equations3);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_120;

public function dumpIfEquation
  input Tpl.Text in_txt;
  input DAE.Element in_a_lst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lst)
    local
      Tpl.Text txt;
      list<DAE.Element> i_equations3;
      list<list<DAE.Element>> i_elseif__branches;
      list<DAE.Exp> i_elseif__conds;
      list<DAE.Element> i_if__branch;
      DAE.Exp i_if__cond;
      Tpl.Text l_else__str;
      Tpl.Text l_elseif__str;
      Tpl.Text l_if__branch__str;
      Tpl.Text l_if__cond__str;

    case ( txt,
           DAE.IF_EQUATION(condition1 = i_if__cond :: i_elseif__conds, equations2 = i_if__branch :: i_elseif__branches, equations3 = i_equations3) )
      equation
        l_if__cond__str = dumpExp(Tpl.emptyTxt, i_if__cond);
        l_if__branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_if__branch__str = lm_118(l_if__branch__str, i_if__branch);
        l_if__branch__str = Tpl.popIter(l_if__branch__str);
        l_elseif__str = dumpElseIfEquation(Tpl.emptyTxt, i_elseif__conds, i_elseif__branches);
        l_else__str = fun_120(Tpl.emptyTxt, i_equations3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_if__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_if__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_elseif__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_else__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end if;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpIfEquation;

protected function lm_122
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_122(txt, rest);
      then txt;
  end match;
end lm_122;

protected function fun_123
  input Tpl.Text in_txt;
  input list<list<DAE.Element>> in_a_equations;
  input list<DAE.Exp> in_a_rest__conds;
  input DAE.Exp in_a_cond;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_equations, in_a_rest__conds, in_a_cond)
    local
      Tpl.Text txt;
      list<DAE.Exp> a_rest__conds;
      DAE.Exp a_cond;
      list<list<DAE.Element>> i_rest__branches;
      list<DAE.Element> i_branch;
      Tpl.Text l_rest__str;
      Tpl.Text l_branch__str;
      Tpl.Text l_cond__str;

    case ( txt,
           i_branch :: i_rest__branches,
           a_rest__conds,
           a_cond )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, a_cond);
        l_branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_branch__str = lm_122(l_branch__str, i_branch);
        l_branch__str = Tpl.popIter(l_branch__str);
        l_rest__str = dumpElseIfEquation(Tpl.emptyTxt, a_rest__conds, i_rest__branches);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elseif "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_rest__str);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_123;

public function dumpElseIfEquation
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_condition1;
  input list<list<DAE.Element>> in_a_equations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_condition1, in_a_equations)
    local
      Tpl.Text txt;
      list<list<DAE.Element>> a_equations;
      list<DAE.Exp> i_rest__conds;
      DAE.Exp i_cond;

    case ( txt,
           i_cond :: i_rest__conds,
           a_equations )
      equation
        txt = fun_123(txt, a_equations, i_rest__conds, i_cond);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpElseIfEquation;

protected function lm_125
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_alg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_alg :: rest )
      equation
        txt = dumpInitialAlgorithm(txt, i_alg);
        txt = Tpl.nextIter(txt);
        txt = lm_125(txt, rest);
      then txt;
  end match;
end lm_125;

public function dumpInitialAlgorithms
  input Tpl.Text in_txt;
  input list<DAE.Element> in_a_ia;
  input String in_a_label;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ia, in_a_label)
    local
      Tpl.Text txt;
      String a_label;
      list<DAE.Element> i_ia;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_ia,
           a_label )
      equation
        txt = Tpl.writeStr(txt, a_label);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_125(txt, i_ia);
        txt = Tpl.popIter(txt);
      then txt;
  end match;
end dumpInitialAlgorithms;

public function dumpInitialAlgorithm
  input Tpl.Text in_txt;
  input DAE.Element in_a_alg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_alg)
    local
      Tpl.Text txt;
      DAE.Algorithm i_algorithm__;

    case ( txt,
           DAE.INITIALALGORITHM(algorithm_ = i_algorithm__) )
      equation
        txt = dumpAlgorithmStatement(txt, i_algorithm__);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInitialAlgorithm;

protected function lm_128
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_alg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_alg :: rest )
      equation
        txt = dumpAlgorithm(txt, i_alg);
        txt = Tpl.nextIter(txt);
        txt = lm_128(txt, rest);
      then txt;
  end match;
end lm_128;

public function dumpAlgorithms
  input Tpl.Text in_txt;
  input list<DAE.Element> in_a_a;
  input String in_a_label;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_a, in_a_label)
    local
      Tpl.Text txt;
      String a_label;
      list<DAE.Element> i_a;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_a,
           a_label )
      equation
        txt = Tpl.writeStr(txt, a_label);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_128(txt, i_a);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end dumpAlgorithms;

public function dumpAlgorithm
  input Tpl.Text in_txt;
  input DAE.Element in_a_alg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_alg)
    local
      Tpl.Text txt;
      DAE.Algorithm i_algorithm__;

    case ( txt,
           DAE.ALGORITHM(algorithm_ = i_algorithm__) )
      equation
        txt = dumpAlgorithmStatement(txt, i_algorithm__);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAlgorithm;

public function dumpAlgorithmStatement
  input Tpl.Text in_txt;
  input DAE.Algorithm in_a_algorithm__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_algorithm__)
    local
      Tpl.Text txt;
      list<DAE.Statement> i_statementLst;

    case ( txt,
           DAE.ALGORITHM_STMTS(statementLst = i_statementLst) )
      equation
        txt = dumpStatements(txt, i_statementLst);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAlgorithmStatement;

protected function lm_132
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_stmt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_stmt :: rest )
      equation
        txt = dumpStatement(txt, i_stmt);
        txt = Tpl.nextIter(txt);
        txt = lm_132(txt, rest);
      then txt;
  end match;
end lm_132;

public function dumpStatements
  input Tpl.Text txt;
  input list<DAE.Statement> a_stmts;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_132(out_txt, a_stmts);
  out_txt := Tpl.popIter(out_txt);
end dumpStatements;

public function dumpStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Statement i_stmt;
      DAE.Exp i_exp;
      DAE.Exp i_exp1;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = i_exp1, exp = i_exp) )
      equation
        l_lhs__str = dumpExp(Tpl.emptyTxt, i_exp1);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_exp);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" := "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_TUPLE_ASSIGN(expExpLst = _)) )
      equation
        txt = dumpTupleAssignStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_ASSIGN_ARR(componentRef = _)) )
      equation
        txt = dumpArrayAssignStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_IF(exp = _)) )
      equation
        txt = dumpIfStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_FOR(iterIsArray = _)) )
      equation
        txt = dumpForStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_WHILE(exp = _)) )
      equation
        txt = dumpWhileStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_WHEN(exp = _)) )
      equation
        txt = dumpWhenStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_ASSERT(cond = _)) )
      equation
        txt = dumpAssertStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_TERMINATE(msg = _)) )
      equation
        txt = dumpTerminateStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_REINIT(var = _)) )
      equation
        txt = dumpReinitStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_NORETCALL(exp = _)) )
      equation
        txt = dumpNoReturnCallStatement(txt, i_stmt);
      then txt;

    case ( txt,
           DAE.STMT_RETURN(source = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return;"));
      then txt;

    case ( txt,
           DAE.STMT_BREAK(source = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break;"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "DAEDump.dumpStatement: Unknown statement.");
      then txt;
  end match;
end dumpStatement;

protected function lm_135
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpExp(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_135(txt, rest);
      then txt;
  end match;
end lm_135;

public function dumpTupleAssignStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      list<DAE.Exp> i_expExpLst;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           DAE.STMT_TUPLE_ASSIGN(expExpLst = i_expExpLst, exp = i_exp) )
      equation
        l_lhs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_lhs__str = lm_135(l_lhs__str, i_expExpLst);
        l_lhs__str = Tpl.popIter(l_lhs__str);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") := "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpTupleAssignStatement;

public function dumpArrayAssignStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.ComponentRef i_componentRef;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           DAE.STMT_ASSIGN_ARR(componentRef = i_componentRef, exp = i_exp) )
      equation
        l_lhs__str = dumpCref(Tpl.emptyTxt, i_componentRef);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_exp);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" := "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpArrayAssignStatement;

protected function lm_138
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpStatement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_138(txt, rest);
      then txt;
  end match;
end lm_138;

public function dumpIfStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_else__if__str;
      Tpl.Text l_true__branch__str;
      Tpl.Text l_if__cond__str;

    case ( txt,
           DAE.STMT_IF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__) )
      equation
        l_if__cond__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_true__branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_true__branch__str = lm_138(l_true__branch__str, i_statementLst);
        l_true__branch__str = Tpl.popIter(l_true__branch__str);
        l_else__if__str = dumpElseIfStatements(Tpl.emptyTxt, i_else__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_if__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_true__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_else__if__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end if;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpIfStatement;

protected function lm_140
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpStatement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_140(txt, rest);
      then txt;
  end match;
end lm_140;

protected function lm_141
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpStatement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_141(txt, rest);
      then txt;
  end match;
end lm_141;

public function dumpElseIfStatements
  input Tpl.Text in_txt;
  input DAE.Else in_a_else__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_else__)
    local
      Tpl.Text txt;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_else__body__str;
      Tpl.Text l_else__str;
      Tpl.Text l_elseif__body__str;
      Tpl.Text l_elseif__cond__str;

    case ( txt,
           DAE.ELSEIF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__) )
      equation
        l_elseif__cond__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_elseif__body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_elseif__body__str = lm_140(l_elseif__body__str, i_statementLst);
        l_elseif__body__str = Tpl.popIter(l_elseif__body__str);
        l_else__str = dumpElseIfStatements(Tpl.emptyTxt, i_else__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elseif "));
        txt = Tpl.writeText(txt, l_elseif__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_elseif__body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_else__str);
      then txt;

    case ( txt,
           DAE.ELSE(statementLst = i_statementLst) )
      equation
        l_else__body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_else__body__str = lm_141(l_else__body__str, i_statementLst);
        l_else__body__str = Tpl.popIter(l_else__body__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_else__body__str);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpElseIfStatements;

protected function lm_143
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpStatement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_143(txt, rest);
      then txt;
  end match;
end lm_143;

public function dumpForStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Ident i_iter;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_range;
      Tpl.Text l_alg__str;
      Tpl.Text l_range__str;

    case ( txt,
           DAE.STMT_FOR(range = i_range, statementLst = i_statementLst, iter = i_iter) )
      equation
        l_range__str = dumpExp(Tpl.emptyTxt, i_range);
        l_alg__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_alg__str = lm_143(l_alg__str, i_statementLst);
        l_alg__str = Tpl.popIter(l_alg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for "));
        txt = Tpl.writeStr(txt, i_iter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" in "));
        txt = Tpl.writeText(txt, l_range__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" loop\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_alg__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpForStatement;

protected function lm_145
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpStatement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_145(txt, rest);
      then txt;
  end match;
end lm_145;

public function dumpWhileStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_body__str;
      Tpl.Text l_while__cond;

    case ( txt,
           DAE.STMT_WHILE(exp = i_exp, statementLst = i_statementLst) )
      equation
        l_while__cond = dumpExp(Tpl.emptyTxt, i_exp);
        l_body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__str = lm_145(l_body__str, i_statementLst);
        l_body__str = Tpl.popIter(l_body__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("while "));
        txt = Tpl.writeText(txt, l_while__cond);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" loop\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end while;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpWhileStatement;

protected function lm_147
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpStatement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_147(txt, rest);
      then txt;
  end match;
end lm_147;

protected function fun_148
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Statement i_Statement;

    case ( txt,
           DAE.STMT_WHEN(elseWhen = SOME(i_Statement)) )
      equation
        txt = dumpStatement(txt, i_Statement);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_148;

protected function fun_149
  input Tpl.Text in_txt;
  input Tpl.Text in_a_elsewhen__str;
  input Tpl.Text in_a_body__str;
  input Tpl.Text in_a_when__cond__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elsewhen__str, in_a_body__str, in_a_when__cond__str)
    local
      Tpl.Text txt;
      Tpl.Text a_body__str;
      Tpl.Text a_when__cond__str;
      Tpl.Text i_elsewhen__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_body__str,
           a_when__cond__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, a_when__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
      then txt;

    case ( txt,
           i_elsewhen__str,
           a_body__str,
           a_when__cond__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, a_when__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else"));
        txt = Tpl.writeText(txt, i_elsewhen__str);
      then txt;
  end match;
end fun_149;

public function dumpWhenStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Statement i_stmt;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_elsewhen__str;
      Tpl.Text l_body__str;
      Tpl.Text l_when__cond__str;

    case ( txt,
           (i_stmt as DAE.STMT_WHEN(exp = i_exp, statementLst = i_statementLst)) )
      equation
        l_when__cond__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__str = lm_147(l_body__str, i_statementLst);
        l_body__str = Tpl.popIter(l_body__str);
        l_elsewhen__str = fun_148(Tpl.emptyTxt, i_stmt);
        txt = fun_149(txt, l_elsewhen__str, l_body__str, l_when__cond__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpWhenStatement;

public function dumpAssertStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Exp i_msg;
      DAE.Exp i_cond;
      Tpl.Text l_assert__msg;
      Tpl.Text l_assert__cond;

    case ( txt,
           DAE.STMT_ASSERT(cond = i_cond, msg = i_msg) )
      equation
        l_assert__cond = dumpExp(Tpl.emptyTxt, i_cond);
        l_assert__msg = dumpExp(Tpl.emptyTxt, i_msg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assert("));
        txt = Tpl.writeText(txt, l_assert__cond);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_assert__msg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAssertStatement;

public function dumpTerminateStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Exp i_msg;
      Tpl.Text l_msg__str;

    case ( txt,
           DAE.STMT_TERMINATE(msg = i_msg) )
      equation
        l_msg__str = dumpExp(Tpl.emptyTxt, i_msg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("terminate("));
        txt = Tpl.writeText(txt, l_msg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpTerminateStatement;

public function dumpReinitStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Exp i_value;
      DAE.Exp i_var;
      Tpl.Text l_new__exp__str;
      Tpl.Text l_exp__str;

    case ( txt,
           DAE.STMT_REINIT(var = i_var, value = i_value) )
      equation
        l_exp__str = dumpExp(Tpl.emptyTxt, i_var);
        l_new__exp__str = dumpExp(Tpl.emptyTxt, i_value);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("reinit("));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_new__exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpReinitStatement;

public function dumpNoReturnCallStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Tpl.Text l_exp__str;

    case ( txt,
           DAE.STMT_NORETCALL(exp = i_exp) )
      equation
        l_exp__str = dumpExp(Tpl.emptyTxt, i_exp);
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpNoReturnCallStatement;

public function dumpExp
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := ExpressionDumpTpl.dumpExp(txt, a_exp, "\"");
end dumpExp;

public function dumpCommentOpt
  input Tpl.Text in_txt;
  input Option<SCode.Comment> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      SCode.Comment i_cmt;

    case ( txt,
           SOME(i_cmt) )
      equation
        txt = dumpComment(txt, i_cmt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpCommentOpt;

public function dumpComment
  input Tpl.Text in_txt;
  input SCode.Comment in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      Option<String> i_comment;
      Tpl.Text l_cmt__str;

    case ( txt,
           SCode.COMMENT(comment = i_comment) )
      equation
        l_cmt__str = dumpCommentStr(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_cmt__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpComment;

public function dumpCommentStr
  input Tpl.Text in_txt;
  input Option<String> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_cmt;

    case ( txt,
           SOME(i_cmt) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_cmt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpCommentStr;

public function dumpPathLastIndent
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_path)
    local
      Tpl.Text txt;
      Absyn.Ident i_name;
      Absyn.Path i_path;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = dumpPathLastIndent(txt, i_path);
      then txt;

    case ( txt,
           Absyn.QUALIFIED(path = i_path) )
      equation
        txt = dumpPathLastIndent(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "dumpPathLastIndent: Unknown path.");
      then txt;
  end match;
end dumpPathLastIndent;

protected function lm_160
  input Tpl.Text in_txt;
  input list<SCode.Comment> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Comment> rest;
      SCode.Comment i_c;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_c :: rest )
      equation
        txt = dumpComment(txt, i_c);
        txt = Tpl.nextIter(txt);
        txt = lm_160(txt, rest);
      then txt;
  end match;
end lm_160;

public function dumpSource
  input Tpl.Text in_txt;
  input DAE.ElementSource in_a_source;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_source)
    local
      Tpl.Text txt;
      list<SCode.Comment> i_comment;
      Tpl.Text l_cmt;

    case ( txt,
           DAE.SOURCE(comment = i_comment) )
      equation
        l_cmt = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_cmt = lm_160(l_cmt, i_comment);
        l_cmt = Tpl.popIter(l_cmt);
        txt = Tpl.writeText(txt, l_cmt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpSource;

public function errorMsg
  input Tpl.Text txt;
  input String a_errMessage;

  output Tpl.Text out_txt;
algorithm
  Tpl.addTemplateError(a_errMessage);
  out_txt := Tpl.writeStr(txt, a_errMessage);
end errorMsg;

end DAEDumpTpl;