encapsulated package NFInstDumpTpl
"
  file:        NFInstDumpTpl.mo
  package:     NFInstDumpTpl
  description: Generated by Susan.
"

public import Tpl;

public import Absyn;
public import NFConnect2;
public import DAE;
public import Expression;
public import NFInstDump;
public import NFInstTypes;
protected import AbsynDumpTpl;
protected import ExpressionDumpTpl;

public function dumpModel
  input Tpl.Text txt;
  input String a_name;
  input NFInstTypes.Class a_cls;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("class "));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := dumpClass(out_txt, a_cls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("end "));
  out_txt := Tpl.writeStr(out_txt, a_name);
end dumpModel;

public function dumpComponent
  input Tpl.Text in_txt;
  input NFInstTypes.Component in_a_component;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_component)
    local
      Tpl.Text txt;
      Absyn.Path i_in;
      DAE.Type i_ty;
      NFInstTypes.Component i_component;
      DAE.Type i_baseType;
      NFInstTypes.Binding i_binding;
      Absyn.Path i_name;
      Tpl.Text l_inner__str;
      Tpl.Text l_outer__str;
      String ret_4;
      Tpl.Text l_dims__str;
      Tpl.Text l_ty__str;
      Tpl.Text l_bind__str;
      Tpl.Text l_name__str;

    case ( txt,
           (i_component as NFInstTypes.UNTYPED_COMPONENT(name = i_name, binding = i_binding, baseType = i_baseType)) )
      equation
        l_name__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_name);
        l_bind__str = dumpBinding(Tpl.emptyTxt, i_binding);
        l_ty__str = ExpressionDumpTpl.dumpType(Tpl.emptyTxt, i_baseType);
        ret_4 = NFInstDump.dumpUntypedComponentDims(i_component);
        l_dims__str = Tpl.writeStr(Tpl.emptyTxt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeText(txt, l_dims__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeText(txt, l_bind__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           NFInstTypes.TYPED_COMPONENT(name = i_name, binding = i_binding, ty = i_ty) )
      equation
        l_name__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_name);
        l_bind__str = dumpBinding(Tpl.emptyTxt, i_binding);
        l_ty__str = ExpressionDumpTpl.dumpType(Tpl.emptyTxt, i_ty);
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeText(txt, l_bind__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           NFInstTypes.CONDITIONAL_COMPONENT(name = i_name) )
      equation
        l_name__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("conditional "));
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           NFInstTypes.DELETED_COMPONENT(name = i_name) )
      equation
        l_name__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("deleted "));
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           NFInstTypes.OUTER_COMPONENT(innerName = SOME(i_in), name = i_name) )
      equation
        l_outer__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_name);
        l_inner__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_in);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("outer "));
        txt = Tpl.writeText(txt, l_outer__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -> "));
        txt = Tpl.writeText(txt, l_inner__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           NFInstTypes.OUTER_COMPONENT(name = i_name) )
      equation
        l_outer__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("outer "));
        txt = Tpl.writeText(txt, l_outer__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           NFInstTypes.PACKAGE(name = i_name) )
      equation
        l_name__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("package "));
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpComponent;

protected function fun_11
  input Tpl.Text in_txt;
  input Tpl.Text in_a_cls__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cls__str)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_11;

public function dumpElement
  input Tpl.Text in_txt;
  input NFInstTypes.Element in_a_element;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_element)
    local
      Tpl.Text txt;
      NFInstTypes.Class i_cls;
      NFInstTypes.Component i_component;
      Tpl.Text l_sep__str;
      Tpl.Text l_cls__str;
      Tpl.Text l_comp__str;

    case ( txt,
           NFInstTypes.ELEMENT(component = i_component, cls = i_cls) )
      equation
        l_comp__str = dumpComponent(Tpl.emptyTxt, i_component);
        l_cls__str = dumpClass(Tpl.emptyTxt, i_cls);
        l_sep__str = fun_11(Tpl.emptyTxt, l_cls__str);
        txt = Tpl.writeText(txt, l_comp__str);
        txt = Tpl.writeText(txt, l_sep__str);
        txt = Tpl.writeText(txt, l_cls__str);
      then txt;

    case ( txt,
           NFInstTypes.CONDITIONAL_ELEMENT(component = i_component) )
      equation
        l_comp__str = dumpComponent(Tpl.emptyTxt, i_component);
        txt = Tpl.writeText(txt, l_comp__str);
      then txt;

    case ( txt,
           NFInstTypes.EXTENDED_ELEMENTS(cls = i_cls) )
      equation
        l_cls__str = dumpClass(Tpl.emptyTxt, i_cls);
        txt = Tpl.writeText(txt, l_cls__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpElement;

protected function lm_13
  input Tpl.Text in_txt;
  input list<NFInstTypes.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<NFInstTypes.Element> rest;
      NFInstTypes.Element i_comp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_comp :: rest )
      equation
        txt = dumpElement(txt, i_comp);
        txt = Tpl.nextIter(txt);
        txt = lm_13(txt, rest);
      then txt;
  end match;
end lm_13;

protected function lm_14
  input Tpl.Text in_txt;
  input list<NFInstTypes.Equation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<NFInstTypes.Equation> rest;
      NFInstTypes.Equation i_ieq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ieq :: rest )
      equation
        txt = dumpEquation(txt, i_ieq);
        txt = Tpl.nextIter(txt);
        txt = lm_14(txt, rest);
      then txt;
  end match;
end lm_14;

protected function lm_15
  input Tpl.Text in_txt;
  input list<NFInstTypes.Equation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<NFInstTypes.Equation> rest;
      NFInstTypes.Equation i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = dumpEquation(txt, i_eq);
        txt = Tpl.nextIter(txt);
        txt = lm_15(txt, rest);
      then txt;
  end match;
end lm_15;

protected function fun_16
  input Tpl.Text in_txt;
  input Tpl.Text in_a_comp__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comp__str)
    local
      Tpl.Text txt;
      Tpl.Text i_comp__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_comp__str )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, i_comp__str);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_16;

protected function fun_17
  input Tpl.Text in_txt;
  input Tpl.Text in_a_eq__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq__str)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end equation;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_17;

protected function fun_18
  input Tpl.Text in_txt;
  input Tpl.Text in_a_ieq__str;
  input Tpl.Text in_a_eq__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ieq__str, in_a_eq__str)
    local
      Tpl.Text txt;
      Tpl.Text a_eq__str;
      Tpl.Text i_ieq__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           i_ieq__str,
           a_eq__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "initial equation\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, i_ieq__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = fun_17(txt, a_eq__str);
      then txt;
  end match;
end fun_18;

protected function fun_19
  input Tpl.Text in_txt;
  input Tpl.Text in_a_eq__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq__str)
    local
      Tpl.Text txt;
      Tpl.Text i_eq__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_eq__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "equation\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, i_eq__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end equation;"));
      then txt;
  end match;
end fun_19;

public function dumpClass
  input Tpl.Text in_txt;
  input NFInstTypes.Class in_a_cls;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cls)
    local
      Tpl.Text txt;
      list<NFInstTypes.Equation> i_equations;
      list<NFInstTypes.Equation> i_initialEquations;
      list<NFInstTypes.Element> i_components;
      Tpl.Text l_eq__seq__str;
      Tpl.Text l_ieq__seq__str;
      Tpl.Text l_comp__seq__str;
      Tpl.Text l_eq__str;
      Tpl.Text l_ieq__str;
      Tpl.Text l_comp__str;

    case ( txt,
           NFInstTypes.COMPLEX_CLASS(components = i_components, initialEquations = i_initialEquations, equations = i_equations) )
      equation
        l_comp__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_comp__str = lm_13(l_comp__str, i_components);
        l_comp__str = Tpl.popIter(l_comp__str);
        l_ieq__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_ieq__str = lm_14(l_ieq__str, i_initialEquations);
        l_ieq__str = Tpl.popIter(l_ieq__str);
        l_eq__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_eq__str = lm_15(l_eq__str, i_equations);
        l_eq__str = Tpl.popIter(l_eq__str);
        l_comp__seq__str = fun_16(Tpl.emptyTxt, l_comp__str);
        l_ieq__seq__str = fun_18(Tpl.emptyTxt, l_ieq__str, l_eq__str);
        l_eq__seq__str = fun_19(Tpl.emptyTxt, l_eq__str);
        txt = Tpl.writeText(txt, l_comp__seq__str);
        txt = Tpl.writeText(txt, l_ieq__seq__str);
        txt = Tpl.writeText(txt, l_eq__seq__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpClass;

public function dumpExp
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := ExpressionDumpTpl.dumpExp(txt, a_exp, "\"");
end dumpExp;

protected function fun_22
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_range;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_range)
    local
      Tpl.Text txt;
      DAE.Exp i_range__exp;

    case ( txt,
           SOME(i_range__exp) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("in "));
        txt = dumpExp(txt, i_range__exp);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_22;

protected function lm_23
  input Tpl.Text in_txt;
  input list<NFInstTypes.Equation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<NFInstTypes.Equation> rest;
      NFInstTypes.Equation i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = dumpEquation(txt, i_eq);
        txt = Tpl.nextIter(txt);
        txt = lm_23(txt, rest);
      then txt;
  end match;
end lm_23;

public function dumpEquation
  input Tpl.Text in_txt;
  input NFInstTypes.Equation in_a_equation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_equation)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.Exp i_reinitExp;
      DAE.ComponentRef i_cref;
      DAE.Exp i_message;
      DAE.Exp i_condition;
      Integer i_index;
      String i_name;
      list<NFInstTypes.Equation> i_body;
      Option<DAE.Exp> i_range;
      DAE.Type i_indexType;
      NFConnect2.Face i_rhsFace;
      NFConnect2.Face i_lhsFace;
      DAE.ComponentRef i_rhs_1;
      DAE.ComponentRef i_lhs_1;
      DAE.Exp i_rhs;
      DAE.Exp i_lhs;
      Tpl.Text l_exp__str;
      Tpl.Text l_cref__str;
      Tpl.Text l_msg__str;
      Tpl.Text l_cond__str;
      Tpl.Text l_eql__str;
      Tpl.Text l_range__str;
      Tpl.Text l_ty__str;
      Tpl.Text l_rhs__face__str;
      Tpl.Text l_lhs__face__str;
      DAE.Type ret_5;
      Tpl.Text l_rhs__ty__str;
      DAE.Type ret_3;
      Tpl.Text l_lhs__ty__str;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           NFInstTypes.EQUALITY_EQUATION(lhs = i_lhs, rhs = i_rhs) )
      equation
        l_lhs__str = dumpExp(Tpl.emptyTxt, i_lhs);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_rhs);
        ret_3 = Expression.typeof(i_lhs);
        l_lhs__ty__str = ExpressionDumpTpl.dumpType(Tpl.emptyTxt, ret_3);
        ret_5 = Expression.typeof(i_rhs);
        l_rhs__ty__str = ExpressionDumpTpl.dumpType(Tpl.emptyTxt, ret_5);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" {"));
        txt = Tpl.writeText(txt, l_lhs__ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = {"));
        txt = Tpl.writeText(txt, l_rhs__ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           NFInstTypes.CONNECT_EQUATION(lhs = i_lhs_1, rhs = i_rhs_1, lhsFace = i_lhsFace, rhsFace = i_rhsFace) )
      equation
        l_lhs__str = ExpressionDumpTpl.dumpCref(Tpl.emptyTxt, i_lhs_1);
        l_rhs__str = ExpressionDumpTpl.dumpCref(Tpl.emptyTxt, i_rhs_1);
        l_lhs__face__str = dumpFace(Tpl.emptyTxt, i_lhsFace);
        l_rhs__face__str = dumpFace(Tpl.emptyTxt, i_rhsFace);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("connect("));
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <"));
        txt = Tpl.writeText(txt, l_lhs__face__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">, "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <"));
        txt = Tpl.writeText(txt, l_rhs__face__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">);"));
      then txt;

    case ( txt,
           NFInstTypes.FOR_EQUATION(indexType = i_indexType, range = i_range, body = i_body, name = i_name, index = i_index) )
      equation
        l_ty__str = ExpressionDumpTpl.dumpType(Tpl.emptyTxt, i_indexType);
        l_range__str = fun_22(Tpl.emptyTxt, i_range);
        l_eql__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_eql__str = lm_23(l_eql__str, i_body);
        l_eql__str = Tpl.popIter(l_eql__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for {"));
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* index "));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.writeText(txt, l_range__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" loop\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_eql__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for;"));
      then txt;

    case ( txt,
           NFInstTypes.IF_EQUATION(branches = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if equation;"));
      then txt;

    case ( txt,
           NFInstTypes.ASSERT_EQUATION(condition = i_condition, message = i_message) )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, i_condition);
        l_msg__str = dumpExp(Tpl.emptyTxt, i_message);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assert("));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_msg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           NFInstTypes.TERMINATE_EQUATION(message = i_message) )
      equation
        l_msg__str = dumpExp(Tpl.emptyTxt, i_message);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("terminate("));
        txt = Tpl.writeText(txt, l_msg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           NFInstTypes.REINIT_EQUATION(cref = i_cref, reinitExp = i_reinitExp) )
      equation
        l_cref__str = ExpressionDumpTpl.dumpCref(Tpl.emptyTxt, i_cref);
        l_exp__str = dumpExp(Tpl.emptyTxt, i_reinitExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("reinit("));
        txt = Tpl.writeText(txt, l_cref__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           NFInstTypes.NORETCALL_EQUATION(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dumpEquation: IMPLEMENT ME"));
      then txt;
  end match;
end dumpEquation;

public function dumpBinding
  input Tpl.Text in_txt;
  input NFInstTypes.Binding in_a_binding;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_binding)
    local
      Tpl.Text txt;
      DAE.Type i_bindingType;
      DAE.Exp i_bindingExp;
      Absyn.Exp i_aexp;
      Tpl.Text l_ty__str;
      Tpl.Text l_exp__str;

    case ( txt,
           NFInstTypes.RAW_BINDING(bindingExp = i_aexp) )
      equation
        l_exp__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_aexp);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= <RAW> "));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           NFInstTypes.UNTYPED_BINDING(bindingExp = i_bindingExp) )
      equation
        l_exp__str = dumpExp(Tpl.emptyTxt, i_bindingExp);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           NFInstTypes.TYPED_BINDING(bindingExp = i_bindingExp, bindingType = i_bindingType) )
      equation
        l_exp__str = dumpExp(Tpl.emptyTxt, i_bindingExp);
        l_ty__str = ExpressionDumpTpl.dumpType(Tpl.emptyTxt, i_bindingType);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= ("));
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") "));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpBinding;

protected function fun_26
  input Tpl.Text in_txt;
  input DAE.Dimensions in_a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dims)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dims )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = ExpressionDumpTpl.dumpDimensions(txt, i_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end fun_26;

protected function fun_27
  input Tpl.Text in_txt;
  input Tpl.Text in_a_rest__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_rest__str)
    local
      Tpl.Text txt;
      Tpl.Text i_rest__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_rest__str )
      equation
        txt = Tpl.writeText(txt, i_rest__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
      then txt;
  end match;
end fun_27;

public function dumpPrefix
  input Tpl.Text in_txt;
  input NFInstTypes.Prefix in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_prefix)
    local
      Tpl.Text txt;
      String i_name;
      NFInstTypes.Prefix i_restPrefix;
      DAE.Dimensions i_dims;
      Tpl.Text l_pre__str;
      Tpl.Text l_rest__str;
      Tpl.Text l_dims__str;

    case ( txt,
           NFInstTypes.PREFIX(dims = i_dims, restPrefix = i_restPrefix, name = i_name) )
      equation
        l_dims__str = fun_26(Tpl.emptyTxt, i_dims);
        l_rest__str = dumpPrefix(Tpl.emptyTxt, i_restPrefix);
        l_pre__str = fun_27(Tpl.emptyTxt, l_rest__str);
        txt = Tpl.writeText(txt, l_pre__str);
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeText(txt, l_dims__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpPrefix;

protected function lm_29
  input Tpl.Text in_txt;
  input list<NFConnect2.Connection> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<NFConnect2.Connection> rest;
      NFConnect2.Connection i_c;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_c :: rest )
      equation
        txt = dumpConnection(txt, i_c);
        txt = Tpl.nextIter(txt);
        txt = lm_29(txt, rest);
      then txt;
  end match;
end lm_29;

public function dumpConnections
  input Tpl.Text in_txt;
  input NFConnect2.Connections in_a_conn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_conn)
    local
      Tpl.Text txt;
      list<NFConnect2.Connection> i_connections;
      Tpl.Text l_conn__str;

    case ( txt,
           NFConnect2.CONNECTIONS(connections = i_connections) )
      equation
        l_conn__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_conn__str = lm_29(l_conn__str, i_connections);
        l_conn__str = Tpl.popIter(l_conn__str);
        txt = Tpl.writeText(txt, l_conn__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpConnections;

public function dumpConnection
  input Tpl.Text in_txt;
  input NFConnect2.Connection in_a_connection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_connection)
    local
      Tpl.Text txt;
      NFConnect2.Connector i_rhs;
      NFConnect2.Connector i_lhs;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           NFConnect2.CONNECTION(lhs = i_lhs, rhs = i_rhs) )
      equation
        l_lhs__str = dumpConnector(Tpl.emptyTxt, i_lhs);
        l_rhs__str = dumpConnector(Tpl.emptyTxt, i_rhs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("connect("));
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpConnection;

public function dumpConnector
  input Tpl.Text in_txt;
  input NFConnect2.Connector in_a_connector;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_connector)
    local
      Tpl.Text txt;
      NFConnect2.Face i_face;
      DAE.ComponentRef i_name;
      Tpl.Text l_face__str;
      Tpl.Text l_name__str;

    case ( txt,
           NFConnect2.CONNECTOR(name = i_name, face = i_face) )
      equation
        l_name__str = ExpressionDumpTpl.dumpCref(Tpl.emptyTxt, i_name);
        l_face__str = dumpFace(Tpl.emptyTxt, i_face);
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <"));
        txt = Tpl.writeText(txt, l_face__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpConnector;

public function dumpFace
  input Tpl.Text in_txt;
  input NFConnect2.Face in_a_face;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_face)
    local
      Tpl.Text txt;

    case ( txt,
           NFConnect2.INSIDE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inside"));
      then txt;

    case ( txt,
           NFConnect2.OUTSIDE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("outside"));
      then txt;

    case ( txt,
           NFConnect2.NO_FACE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("no_face"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFace;

public function dumpDimension
  input Tpl.Text in_txt;
  input NFInstTypes.Dimension in_a_dim;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dim)
    local
      Tpl.Text txt;
      DAE.Dimension i_dimension;

    case ( txt,
           NFInstTypes.UNTYPED_DIMENSION(dimension = i_dimension) )
      equation
        txt = ExpressionDumpTpl.dumpDimension(txt, i_dimension);
      then txt;

    case ( txt,
           NFInstTypes.TYPED_DIMENSION(dimension = i_dimension) )
      equation
        txt = ExpressionDumpTpl.dumpDimension(txt, i_dimension);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpDimension;

public function errorMsg
  input Tpl.Text txt;
  input String a_errMessage;

  output Tpl.Text out_txt;
algorithm
  Tpl.addTemplateError(a_errMessage);
  out_txt := Tpl.writeStr(txt, a_errMessage);
end errorMsg;

end NFInstDumpTpl;