encapsulated package SCodeDumpTpl
"
  file:        SCodeDumpTpl.mo
  package:     SCodeDumpTpl
  description: Generated by Susan.
"

public import Tpl;

public import Absyn;
public import Dump;
public import SCode;
public import Config;
protected import AbsynDumpTpl;

public function dumpProgram
  input Tpl.Text txt;
  input list<SCode.Element> a_program;

  output Tpl.Text out_txt;
algorithm
  out_txt := dumpElements(txt, a_program, false);
end dumpProgram;

public function dumpElements
  input Tpl.Text txt;
  input list<SCode.Element> a_elements;
  input Boolean a_indent;

  output Tpl.Text out_txt;
algorithm
  out_txt := dumpElements2(txt, a_elements, "", a_indent, true, true);
end dumpElements;

protected function fun_9
  input Tpl.Text in_txt;
  input Boolean in_a_firstElement;
  input String in_a_prevSpacing;
  input Tpl.Text in_a_spacing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_firstElement, in_a_prevSpacing, in_a_spacing)
    local
      Tpl.Text txt;
      String a_prevSpacing;
      Tpl.Text a_spacing;

    case ( txt,
           false,
           a_prevSpacing,
           a_spacing )
      equation
        txt = dumpPreElementSpacing(txt, Tpl.textString(a_spacing), a_prevSpacing);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_9;

protected function fun_10
  input Tpl.Text in_txt;
  input Tpl.Text in_a_vis__str;
  input Boolean in_a_inPublicSection;
  input Boolean in_a_indent;
  input Tpl.Text in_a_spacing;
  input list<SCode.Element> in_a_rest__els;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vis__str, in_a_inPublicSection, in_a_indent, in_a_spacing, in_a_rest__els)
    local
      Tpl.Text txt;
      Boolean a_inPublicSection;
      Boolean a_indent;
      Tpl.Text a_spacing;
      list<SCode.Element> a_rest__els;
      Boolean ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_inPublicSection,
           a_indent,
           a_spacing,
           a_rest__els )
      equation
        txt = dumpElements2(txt, a_rest__els, Tpl.textString(a_spacing), a_indent, false, a_inPublicSection);
      then txt;

    case ( txt,
           _,
           a_inPublicSection,
           a_indent,
           a_spacing,
           a_rest__els )
      equation
        ret_0 = boolNot(a_inPublicSection);
        txt = dumpElements2(txt, a_rest__els, Tpl.textString(a_spacing), a_indent, false, ret_0);
      then txt;
  end match;
end fun_10;

protected function fun_11
  input Tpl.Text in_txt;
  input Tpl.Text in_a_rest__str;
  input Tpl.Text in_a_spacing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_rest__str, in_a_spacing)
    local
      Tpl.Text txt;
      Tpl.Text a_spacing;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_spacing )
      equation
        txt = Tpl.writeText(txt, a_spacing);
      then txt;
  end match;
end fun_11;

protected function fun_12
  input Tpl.Text in_txt;
  input Boolean in_a_indent;
  input Tpl.Text in_a_rest__str;
  input Tpl.Text in_a_post__spacing;
  input Tpl.Text in_a_el__str;
  input Tpl.Text in_a_vis__str;
  input Tpl.Text in_a_pre__spacing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_indent, in_a_rest__str, in_a_post__spacing, in_a_el__str, in_a_vis__str, in_a_pre__spacing)
    local
      Tpl.Text txt;
      Tpl.Text a_rest__str;
      Tpl.Text a_post__spacing;
      Tpl.Text a_el__str;
      Tpl.Text a_vis__str;
      Tpl.Text a_pre__spacing;

    case ( txt,
           false,
           a_rest__str,
           a_post__spacing,
           a_el__str,
           a_vis__str,
           a_pre__spacing )
      equation
        txt = Tpl.writeText(txt, a_pre__spacing);
        txt = Tpl.writeText(txt, a_vis__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_el__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_post__spacing);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_rest__str);
      then txt;

    case ( txt,
           _,
           a_rest__str,
           a_post__spacing,
           a_el__str,
           a_vis__str,
           a_pre__spacing )
      equation
        txt = Tpl.writeText(txt, a_pre__spacing);
        txt = Tpl.writeText(txt, a_vis__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_el__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_post__spacing);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, a_rest__str);
      then txt;
  end match;
end fun_12;

public function dumpElements2
  input Tpl.Text in_txt;
  input list<SCode.Element> in_a_elements;
  input String in_a_prevSpacing;
  input Boolean in_a_indent;
  input Boolean in_a_firstElement;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elements, in_a_prevSpacing, in_a_indent, in_a_firstElement, in_a_inPublicSection)
    local
      Tpl.Text txt;
      String a_prevSpacing;
      Boolean a_indent;
      Boolean a_firstElement;
      Boolean a_inPublicSection;
      list<SCode.Element> i_rest__els;
      SCode.Element i_el;
      Tpl.Text l_elements__str;
      Tpl.Text l_post__spacing;
      Tpl.Text l_rest__str;
      Tpl.Text l_vis__str;
      Tpl.Text l_el__str;
      Tpl.Text l_pre__spacing;
      Tpl.Text l_spacing;

    case ( txt,
           i_el :: i_rest__els,
           a_prevSpacing,
           a_indent,
           a_firstElement,
           a_inPublicSection )
      equation
        l_spacing = dumpElementSpacing(Tpl.emptyTxt, i_el);
        l_pre__spacing = fun_9(Tpl.emptyTxt, a_firstElement, a_prevSpacing, l_spacing);
        l_el__str = dumpElement(Tpl.emptyTxt, i_el, "");
        l_vis__str = dumpElementVisibility(Tpl.emptyTxt, i_el, a_inPublicSection);
        l_rest__str = fun_10(Tpl.emptyTxt, l_vis__str, a_inPublicSection, a_indent, l_spacing, i_rest__els);
        l_post__spacing = fun_11(Tpl.emptyTxt, l_rest__str, l_spacing);
        l_elements__str = fun_12(Tpl.emptyTxt, a_indent, l_rest__str, l_post__spacing, l_el__str, l_vis__str, l_pre__spacing);
        txt = Tpl.writeText(txt, l_elements__str);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpElements2;

protected function fun_14
  input Tpl.Text in_txt;
  input String in_a_prevSpacing;
  input String in_a_curSpacing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_prevSpacing, in_a_curSpacing)
    local
      Tpl.Text txt;
      String a_curSpacing;

    case ( txt,
           "",
           a_curSpacing )
      equation
        txt = Tpl.writeStr(txt, a_curSpacing);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_14;

public function dumpPreElementSpacing
  input Tpl.Text txt;
  input String a_curSpacing;
  input String a_prevSpacing;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_14(txt, a_prevSpacing, a_curSpacing);
end dumpPreElementSpacing;

public function dumpElementSpacing
  input Tpl.Text in_txt;
  input SCode.Element in_a_element;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_element)
    local
      Tpl.Text txt;
      SCode.ClassDef i_classDef;

    case ( txt,
           SCode.CLASS(classDef = i_classDef) )
      equation
        txt = dumpClassDefSpacing(txt, i_classDef);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpElementSpacing;

public function dumpClassDefSpacing
  input Tpl.Text in_txt;
  input SCode.ClassDef in_a_classDef;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_classDef)
    local
      Tpl.Text txt;
      SCode.ClassDef i_composition;

    case ( txt,
           SCode.CLASS_EXTENDS(composition = i_composition) )
      equation
        txt = dumpClassDefSpacing(txt, i_composition);
      then txt;

    case ( txt,
           SCode.PARTS(elementLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpClassDefSpacing;

public function dumpElement
  input Tpl.Text in_txt;
  input SCode.Element in_a_element;
  input String in_a_each;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_element, in_a_each)
    local
      Tpl.Text txt;
      String a_each;
      SCode.Element i_element;

    case ( txt,
           (i_element as SCode.IMPORT(imp = _)),
           _ )
      equation
        txt = dumpImport(txt, i_element);
      then txt;

    case ( txt,
           (i_element as SCode.EXTENDS(baseClassPath = _)),
           _ )
      equation
        txt = dumpExtends(txt, i_element);
      then txt;

    case ( txt,
           (i_element as SCode.CLASS(name = _)),
           a_each )
      equation
        txt = dumpClass(txt, i_element, a_each);
      then txt;

    case ( txt,
           (i_element as SCode.COMPONENT(name = _)),
           a_each )
      equation
        txt = dumpComponent(txt, i_element, a_each);
      then txt;

    case ( txt,
           (i_element as SCode.DEFINEUNIT(name = _)),
           _ )
      equation
        txt = dumpDefineUnit(txt, i_element);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpElement: Unknown element.");
      then txt;
  end match;
end dumpElement;

public function dumpElementVisibility
  input Tpl.Text in_txt;
  input SCode.Element in_a_element;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_element, in_a_inPublicSection)
    local
      Tpl.Text txt;
      Boolean a_inPublicSection;
      SCode.Visibility i_vis;
      SCode.Visibility i_visibility;

    case ( txt,
           SCode.IMPORT(visibility = i_visibility),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_visibility, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.EXTENDS(visibility = i_visibility),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_visibility, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.CLASS(prefixes = SCode.PREFIXES(visibility = i_vis)),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_vis, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.COMPONENT(prefixes = SCode.PREFIXES(visibility = i_vis)),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_vis, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.DEFINEUNIT(visibility = i_visibility),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_visibility, a_inPublicSection);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpElementVisibility;

protected function fun_20
  input Tpl.Text in_txt;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inPublicSection)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("public"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_20;

protected function fun_21
  input Tpl.Text in_txt;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inPublicSection)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("protected"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_21;

public function dumpSectionVisibility
  input Tpl.Text in_txt;
  input SCode.Visibility in_a_visibility;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_visibility, in_a_inPublicSection)
    local
      Tpl.Text txt;
      Boolean a_inPublicSection;

    case ( txt,
           SCode.PUBLIC(),
           a_inPublicSection )
      equation
        txt = fun_20(txt, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.PROTECTED(),
           a_inPublicSection )
      equation
        txt = fun_21(txt, a_inPublicSection);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpSectionVisibility;

protected function fun_23
  input Tpl.Text in_txt;
  input Absyn.Import in_a_imp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_imp)
    local
      Tpl.Text txt;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.NAMED_IMPORT(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("import "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = AbsynDumpTpl.dumpPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.QUAL_IMPORT(path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("import "));
        txt = AbsynDumpTpl.dumpPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.UNQUAL_IMPORT(path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("import "));
        txt = AbsynDumpTpl.dumpPath(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".*"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpImport: Unknown import.");
      then txt;
  end match;
end fun_23;

public function dumpImport
  input Tpl.Text in_txt;
  input SCode.Element in_a_import;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_import)
    local
      Tpl.Text txt;
      Absyn.Import i_imp;
      SCode.Visibility i_visibility;
      Tpl.Text l_import__str;
      Tpl.Text l_visibility__str;

    case ( txt,
           SCode.IMPORT(visibility = i_visibility, imp = i_imp) )
      equation
        l_visibility__str = dumpVisibility(Tpl.emptyTxt, i_visibility);
        l_import__str = fun_23(Tpl.emptyTxt, i_imp);
        txt = Tpl.writeText(txt, l_visibility__str);
        txt = Tpl.writeText(txt, l_import__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpImport;

public function dumpExtends
  input Tpl.Text in_txt;
  input SCode.Element in_a_extends;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extends)
    local
      Tpl.Text txt;
      Option<SCode.Annotation> i_ann;
      SCode.Mod i_modifications;
      SCode.Visibility i_visibility;
      SCode.Path i_baseClassPath;
      Tpl.Text l_ann__str;
      Tpl.Text l_mod__str;
      Tpl.Text l_visibility__str;
      Tpl.Text l_bc__str;

    case ( txt,
           SCode.EXTENDS(baseClassPath = i_baseClassPath, visibility = i_visibility, modifications = i_modifications, ann = i_ann) )
      equation
        l_bc__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_baseClassPath);
        l_visibility__str = dumpVisibility(Tpl.emptyTxt, i_visibility);
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications);
        l_ann__str = dumpAnnotationOpt(Tpl.emptyTxt, i_ann);
        txt = Tpl.writeText(txt, l_visibility__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extends "));
        txt = Tpl.writeText(txt, l_bc__str);
        txt = Tpl.writeText(txt, l_mod__str);
        txt = Tpl.writeText(txt, l_ann__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpExtends;

public function dumpClass
  input Tpl.Text in_txt;
  input SCode.Element in_a_class;
  input String in_a_each;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_class, in_a_each)
    local
      Tpl.Text txt;
      String a_each;
      SCode.Ident i_name;
      SCode.Comment i_cmt;
      SCode.ClassDef i_classDef;
      SCode.Restriction i_restriction;
      SCode.Partial i_partialPrefix;
      SCode.Encapsulated i_encapsulatedPrefix;
      SCode.Prefixes i_prefixes;
      Tpl.Text l_footer__str;
      Tpl.Text l_header__str;
      Tpl.Text l_cc__str;
      Tpl.Text l_ann__str;
      Tpl.Text l_cmt__str;
      Tpl.Text l_cdef__str;
      Tpl.Text l_prefixes__str;
      Tpl.Text l_res__str;
      Tpl.Text l_partial__str;
      Tpl.Text l_enc__str;
      Tpl.Text l_prefix__str;

    case ( txt,
           SCode.CLASS(prefixes = i_prefixes, encapsulatedPrefix = i_encapsulatedPrefix, partialPrefix = i_partialPrefix, restriction = i_restriction, classDef = i_classDef, cmt = i_cmt, name = i_name),
           a_each )
      equation
        l_prefix__str = dumpPrefixes(Tpl.emptyTxt, i_prefixes, a_each);
        l_enc__str = dumpEncapsulated(Tpl.emptyTxt, i_encapsulatedPrefix);
        l_partial__str = dumpPartial(Tpl.emptyTxt, i_partialPrefix);
        l_res__str = dumpRestriction(Tpl.emptyTxt, i_restriction);
        l_prefixes__str = Tpl.writeText(Tpl.emptyTxt, l_prefix__str);
        l_prefixes__str = Tpl.writeText(l_prefixes__str, l_enc__str);
        l_prefixes__str = Tpl.writeText(l_prefixes__str, l_partial__str);
        l_prefixes__str = Tpl.writeText(l_prefixes__str, l_res__str);
        l_cdef__str = dumpClassDef(Tpl.emptyTxt, i_classDef);
        l_cmt__str = dumpClassComment(Tpl.emptyTxt, i_cmt);
        l_ann__str = dumpClassAnnotation(Tpl.emptyTxt, i_cmt);
        l_cc__str = dumpReplaceableConstrainClass(Tpl.emptyTxt, i_prefixes);
        l_header__str = dumpClassHeader(Tpl.emptyTxt, i_classDef, i_name, Tpl.textString(l_cmt__str));
        l_footer__str = dumpClassFooter(Tpl.emptyTxt, i_classDef, Tpl.textString(l_cdef__str), i_name, Tpl.textString(l_cmt__str), Tpl.textString(l_ann__str), Tpl.textString(l_cc__str));
        txt = Tpl.writeText(txt, l_prefixes__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_header__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_footer__str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpClass;

public function dumpClassHeader
  input Tpl.Text in_txt;
  input SCode.ClassDef in_a_classDef;
  input String in_a_name;
  input String in_a_cmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_classDef, in_a_name, in_a_cmt)
    local
      Tpl.Text txt;
      String a_name;
      String a_cmt;

    case ( txt,
           SCode.CLASS_EXTENDS(baseClassName = _),
           a_name,
           a_cmt )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extends "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_cmt);
      then txt;

    case ( txt,
           SCode.PARTS(elementLst = _),
           a_name,
           a_cmt )
      equation
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_cmt);
      then txt;

    case ( txt,
           _,
           a_name,
           _ )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;
  end match;
end dumpClassHeader;

protected function lm_28
  input Tpl.Text in_txt;
  input list<SCode.Enum> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Enum> rest;
      SCode.Enum i_enum;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_enum :: rest )
      equation
        txt = dumpEnumLiteral(txt, i_enum);
        txt = Tpl.nextIter(txt);
        txt = lm_28(txt, rest);
      then txt;
  end match;
end lm_28;

protected function fun_29
  input Tpl.Text in_txt;
  input list<SCode.Enum> in_a_enumLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_enumLst)
    local
      Tpl.Text txt;
      list<SCode.Enum> i_enumLst;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           i_enumLst )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_28(txt, i_enumLst);
        txt = Tpl.popIter(txt);
      then txt;
  end match;
end fun_29;

protected function lm_30
  input Tpl.Text in_txt;
  input list<SCode.Ident> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Ident> rest;
      SCode.Ident i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_30(txt, rest);
      then txt;
  end match;
end lm_30;

protected function lm_31
  input Tpl.Text in_txt;
  input list<Absyn.Path> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Path> rest;
      Absyn.Path i_path;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_path :: rest )
      equation
        txt = AbsynDumpTpl.dumpPath(txt, i_path);
        txt = Tpl.nextIter(txt);
        txt = lm_31(txt, rest);
      then txt;
  end match;
end lm_31;

public function dumpClassDef
  input Tpl.Text in_txt;
  input SCode.ClassDef in_a_classDef;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_classDef)
    local
      Tpl.Text txt;
      list<Absyn.Path> i_pathLst;
      list<SCode.Ident> i_derivedVariables;
      Absyn.Path i_functionPath;
      list<SCode.Enum> i_enumLst;
      SCode.Attributes i_attributes;
      Absyn.TypeSpec i_typeSpec;
      SCode.ClassDef i_composition;
      SCode.Mod i_modifications;
      Option<SCode.ExternalDecl> i_externalDecl;
      list<SCode.AlgorithmSection> i_initialAlgorithmLst;
      list<SCode.AlgorithmSection> i_normalAlgorithmLst;
      list<SCode.Equation> i_initialEquationLst;
      list<SCode.Equation> i_normalEquationLst;
      list<SCode.Element> i_elementLst;
      Tpl.Text l_func__str;
      Tpl.Text l_enum__str;
      Tpl.Text l_attr__str;
      Tpl.Text l_type__str;
      Tpl.Text l_mod__str;
      Tpl.Text l_cdef__str;
      Tpl.Text l_extdecl__str;
      Tpl.Text l_ial__str;
      Tpl.Text l_nal__str;
      Tpl.Text l_ieq__str;
      Tpl.Text l_neq__str;
      Tpl.Text l_el__str;

    case ( txt,
           SCode.PARTS(elementLst = i_elementLst, normalEquationLst = i_normalEquationLst, initialEquationLst = i_initialEquationLst, normalAlgorithmLst = i_normalAlgorithmLst, initialAlgorithmLst = i_initialAlgorithmLst, externalDecl = i_externalDecl) )
      equation
        l_el__str = dumpElements(Tpl.emptyTxt, i_elementLst, true);
        l_neq__str = dumpEquations(Tpl.emptyTxt, i_normalEquationLst, "equation");
        l_ieq__str = dumpEquations(Tpl.emptyTxt, i_initialEquationLst, "initial equation");
        l_nal__str = dumpAlgorithmSections(Tpl.emptyTxt, i_normalAlgorithmLst, "algorithm");
        l_ial__str = dumpAlgorithmSections(Tpl.emptyTxt, i_initialAlgorithmLst, "initial algorithm");
        l_extdecl__str = dumpExternalDeclOpt(Tpl.emptyTxt, i_externalDecl);
        l_cdef__str = Tpl.writeText(Tpl.emptyTxt, l_el__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.writeText(l_cdef__str, l_ieq__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.writeText(l_cdef__str, l_ial__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.writeText(l_cdef__str, l_neq__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.writeText(l_cdef__str, l_nal__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.pushBlock(l_cdef__str, Tpl.BT_INDENT(2));
        l_cdef__str = Tpl.writeText(l_cdef__str, l_extdecl__str);
        l_cdef__str = Tpl.popBlock(l_cdef__str);
        txt = Tpl.writeText(txt, l_cdef__str);
      then txt;

    case ( txt,
           SCode.CLASS_EXTENDS(modifications = i_modifications, composition = i_composition) )
      equation
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications);
        l_cdef__str = dumpClassDef(Tpl.emptyTxt, i_composition);
        txt = Tpl.writeText(txt, l_cdef__str);
      then txt;

    case ( txt,
           SCode.DERIVED(typeSpec = i_typeSpec, modifications = i_modifications, attributes = i_attributes) )
      equation
        l_type__str = AbsynDumpTpl.dumpTypeSpec(Tpl.emptyTxt, i_typeSpec);
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications);
        l_attr__str = dumpAttributes(Tpl.emptyTxt, i_attributes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = Tpl.writeText(txt, l_attr__str);
        txt = Tpl.writeText(txt, l_type__str);
        txt = Tpl.writeText(txt, l_mod__str);
      then txt;

    case ( txt,
           SCode.ENUMERATION(enumLst = i_enumLst) )
      equation
        l_enum__str = fun_29(Tpl.emptyTxt, i_enumLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= enumeration("));
        txt = Tpl.writeText(txt, l_enum__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           SCode.PDER(functionPath = i_functionPath, derivedVariables = i_derivedVariables) )
      equation
        l_func__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_functionPath);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= der("));
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_30(txt, i_derivedVariables);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           SCode.OVERLOAD(pathLst = i_pathLst) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= overload("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_31(txt, i_pathLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpClassDef: Unknown class definition.");
      then txt;
  end match;
end dumpClassDef;

protected function fun_33
  input Tpl.Text in_txt;
  input String in_a_ann;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ann)
    local
      Tpl.Text txt;
      String i_ann;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_ann )
      equation
        txt = Tpl.writeStr(txt, i_ann);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
      then txt;
  end match;
end fun_33;

protected function fun_34
  input Tpl.Text in_txt;
  input String in_a_cdefStr;
  input String in_a_cc__str;
  input String in_a_name;
  input Tpl.Text in_a_annstr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cdefStr, in_a_cc__str, in_a_name, in_a_annstr)
    local
      Tpl.Text txt;
      String a_cc__str;
      String a_name;
      Tpl.Text a_annstr;
      String i_cdefStr;

    case ( txt,
           "",
           a_cc__str,
           a_name,
           a_annstr )
      equation
        txt = Tpl.writeText(txt, a_annstr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeStr(txt, a_cc__str);
      then txt;

    case ( txt,
           i_cdefStr,
           a_cc__str,
           a_name,
           a_annstr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeStr(txt, i_cdefStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_annstr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeStr(txt, a_cc__str);
      then txt;
  end match;
end fun_34;

public function dumpClassFooter
  input Tpl.Text in_txt;
  input SCode.ClassDef in_a_classDef;
  input String in_a_cdefStr;
  input String in_a_name;
  input String in_a_cmt;
  input String in_a_ann;
  input String in_a_cc__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_classDef, in_a_cdefStr, in_a_name, in_a_cmt, in_a_ann, in_a_cc__str)
    local
      Tpl.Text txt;
      String a_cdefStr;
      String a_name;
      String a_cmt;
      String a_ann;
      String a_cc__str;
      Tpl.Text l_annstr;

    case ( txt,
           SCode.DERIVED(typeSpec = _),
           a_cdefStr,
           _,
           a_cmt,
           a_ann,
           a_cc__str )
      equation
        txt = Tpl.writeStr(txt, a_cdefStr);
        txt = Tpl.writeStr(txt, a_cmt);
        txt = Tpl.writeStr(txt, a_ann);
        txt = Tpl.writeStr(txt, a_cc__str);
      then txt;

    case ( txt,
           SCode.ENUMERATION(enumLst = _),
           a_cdefStr,
           _,
           a_cmt,
           a_ann,
           a_cc__str )
      equation
        txt = Tpl.writeStr(txt, a_cdefStr);
        txt = Tpl.writeStr(txt, a_cmt);
        txt = Tpl.writeStr(txt, a_ann);
        txt = Tpl.writeStr(txt, a_cc__str);
      then txt;

    case ( txt,
           SCode.PDER(functionPath = _),
           a_cdefStr,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeStr(txt, a_cdefStr);
      then txt;

    case ( txt,
           _,
           a_cdefStr,
           a_name,
           _,
           a_ann,
           a_cc__str )
      equation
        l_annstr = fun_33(Tpl.emptyTxt, a_ann);
        txt = fun_34(txt, a_cdefStr, a_cc__str, a_name, l_annstr);
      then txt;
  end match;
end dumpClassFooter;

protected function fun_36
  input Tpl.Text in_txt;
  input SCode.Comment in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      Option<String> i_comment;

    case ( txt,
           SCode.COMMENT(comment = i_comment) )
      equation
        txt = dumpCommentStr(txt, i_comment);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_36;

protected function fun_37
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SCode.Comment in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_comment)
    local
      Tpl.Text txt;
      SCode.Comment a_comment;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_comment )
      equation
        txt = fun_36(txt, a_comment);
      then txt;
  end match;
end fun_37;

public function dumpClassComment
  input Tpl.Text txt;
  input SCode.Comment a_comment;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := Config.showAnnotations();
  out_txt := fun_37(txt, ret_0, a_comment);
end dumpClassComment;

protected function fun_39
  input Tpl.Text in_txt;
  input SCode.Comment in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      Option<SCode.Annotation> i_annotation__;

    case ( txt,
           SCode.COMMENT(annotation_ = i_annotation__) )
      equation
        txt = dumpAnnotationOpt(txt, i_annotation__);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_39;

protected function fun_40
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SCode.Comment in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_comment)
    local
      Tpl.Text txt;
      SCode.Comment a_comment;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_comment )
      equation
        txt = fun_39(txt, a_comment);
      then txt;
  end match;
end fun_40;

public function dumpClassAnnotation
  input Tpl.Text txt;
  input SCode.Comment a_comment;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := Config.showAnnotations();
  out_txt := fun_40(txt, ret_0, a_comment);
end dumpClassAnnotation;

protected function fun_42
  input Tpl.Text in_txt;
  input Option<Absyn.Exp> in_a_condition;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_condition)
    local
      Tpl.Text txt;
      Absyn.Exp i_cond;

    case ( txt,
           SOME(i_cond) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = AbsynDumpTpl.dumpExp(txt, i_cond);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_42;

public function dumpComponent
  input Tpl.Text in_txt;
  input SCode.Element in_a_component;
  input String in_a_each;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_component, in_a_each)
    local
      Tpl.Text txt;
      String a_each;
      SCode.Ident i_name;
      SCode.Comment i_comment;
      Option<Absyn.Exp> i_condition;
      SCode.Mod i_modifications;
      Absyn.TypeSpec i_typeSpec;
      SCode.Attributes i_attributes;
      SCode.Prefixes i_prefixes;
      Tpl.Text l_cmt__str;
      Tpl.Text l_cond__str;
      Tpl.Text l_mod__str;
      Tpl.Text l_type__str;
      Tpl.Text l_attr__dim__str;
      Tpl.Text l_attr__pre__str;
      Tpl.Text l_cc__str;
      Tpl.Text l_prefix__str;

    case ( txt,
           SCode.COMPONENT(prefixes = i_prefixes, attributes = i_attributes, typeSpec = i_typeSpec, modifications = i_modifications, condition = i_condition, comment = i_comment, name = i_name),
           a_each )
      equation
        l_prefix__str = dumpPrefixes(Tpl.emptyTxt, i_prefixes, a_each);
        l_cc__str = dumpReplaceableConstrainClass(Tpl.emptyTxt, i_prefixes);
        l_attr__pre__str = dumpAttributes(Tpl.emptyTxt, i_attributes);
        l_attr__dim__str = dumpAttributeDim(Tpl.emptyTxt, i_attributes);
        l_type__str = AbsynDumpTpl.dumpTypeSpec(Tpl.emptyTxt, i_typeSpec);
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications);
        l_cond__str = fun_42(Tpl.emptyTxt, i_condition);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_prefix__str);
        txt = Tpl.writeText(txt, l_attr__pre__str);
        txt = Tpl.writeText(txt, l_type__str);
        txt = Tpl.writeText(txt, l_attr__dim__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeText(txt, l_mod__str);
        txt = Tpl.writeText(txt, l_cc__str);
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeText(txt, l_cmt__str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpComponent;

protected function fun_44
  input Tpl.Text in_txt;
  input Option<String> in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      String i_e;

    case ( txt,
           SOME(i_e) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("exp = \""));
        txt = Tpl.writeStr(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_44;

protected function fun_45
  input Tpl.Text in_txt;
  input Option<Real> in_a_weight;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_weight)
    local
      Tpl.Text txt;
      Real i_w;

    case ( txt,
           SOME(i_w) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("weight = "));
        txt = Tpl.writeStr(txt, realString(i_w));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_45;

protected function smf_46
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_46;

protected function smf_47
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_47;

protected function fun_48
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_args__str)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
      then txt;
  end match;
end fun_48;

protected function fun_49
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_args__str)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_49;

public function dumpDefineUnit
  input Tpl.Text in_txt;
  input SCode.Element in_a_defineUnit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_defineUnit)
    local
      Tpl.Text txt;
      SCode.Ident i_name;
      Option<Real> i_weight;
      Option<String> i_exp;
      SCode.Visibility i_visibility;
      Tpl.Text l_pe;
      Tpl.Text l_pb;
      Tpl.Text l_args__str;
      Tpl.Text l_weight__str;
      Tpl.Text l_exp__str;
      Tpl.Text l_vis__str;

    case ( txt,
           SCode.DEFINEUNIT(visibility = i_visibility, exp = i_exp, weight = i_weight, name = i_name) )
      equation
        l_vis__str = dumpVisibility(Tpl.emptyTxt, i_visibility);
        l_exp__str = fun_44(Tpl.emptyTxt, i_exp);
        l_weight__str = fun_45(Tpl.emptyTxt, i_weight);
        l_args__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_args__str = smf_46(l_args__str, l_exp__str);
        l_args__str = smf_47(l_args__str, l_weight__str);
        l_args__str = Tpl.popIter(l_args__str);
        l_pb = fun_48(Tpl.emptyTxt, l_args__str);
        l_pe = fun_49(Tpl.emptyTxt, l_args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("defineunit "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeText(txt, l_pb);
        txt = Tpl.writeText(txt, l_args__str);
        txt = Tpl.writeText(txt, l_pe);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpDefineUnit;

public function dumpEnumLiteral
  input Tpl.Text in_txt;
  input SCode.Enum in_a_enum;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_enum)
    local
      Tpl.Text txt;
      SCode.Ident i_literal;
      SCode.Comment i_comment;
      Tpl.Text l_cmt__str;

    case ( txt,
           SCode.ENUM(comment = i_comment, literal = i_literal) )
      equation
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeStr(txt, i_literal);
        txt = Tpl.writeText(txt, l_cmt__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpEnumLiteral;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SCode.Equation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Equation> rest;
      SCode.Equation i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = dumpEquation(txt, i_eq);
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest);
      then txt;
  end match;
end lm_52;

public function dumpEquations
  input Tpl.Text in_txt;
  input list<SCode.Equation> in_a_equations;
  input String in_a_label;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_equations, in_a_label)
    local
      Tpl.Text txt;
      String a_label;
      list<SCode.Equation> i_equations;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_equations,
           a_label )
      equation
        txt = Tpl.writeStr(txt, a_label);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_52(txt, i_equations);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end dumpEquations;

public function dumpEquation
  input Tpl.Text in_txt;
  input SCode.Equation in_a_equation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_equation)
    local
      Tpl.Text txt;
      SCode.EEquation i_eEquation;

    case ( txt,
           SCode.EQUATION(eEquation = i_eEquation) )
      equation
        txt = dumpEEquation(txt, i_eEquation);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpEquation;

public function dumpEEquation
  input Tpl.Text in_txt;
  input SCode.EEquation in_a_equation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_equation)
    local
      Tpl.Text txt;
      Absyn.Exp i_exp;
      Absyn.Exp i_expReinit;
      Absyn.ComponentRef i_cref;
      Absyn.Exp i_message;
      Absyn.Exp i_condition;
      Absyn.ComponentRef i_crefRight;
      Absyn.ComponentRef i_crefLeft;
      SCode.Comment i_comment;
      Absyn.Exp i_expRight;
      Absyn.Exp i_expLeft;
      SCode.EEquation i_equation;
      Tpl.Text l_exp__str;
      Tpl.Text l_cref__str;
      Tpl.Text l_msg__str;
      Tpl.Text l_cond__str;
      Tpl.Text l_cmt__str;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           (i_equation as SCode.EQ_IF(condition = _)) )
      equation
        txt = dumpIfEEquation(txt, i_equation);
      then txt;

    case ( txt,
           SCode.EQ_EQUALS(expLeft = i_expLeft, expRight = i_expRight, comment = i_comment) )
      equation
        l_lhs__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_expLeft);
        l_rhs__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_expRight);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.EQ_CONNECT(crefLeft = i_crefLeft, crefRight = i_crefRight, comment = i_comment) )
      equation
        l_lhs__str = AbsynDumpTpl.dumpCref(Tpl.emptyTxt, i_crefLeft);
        l_rhs__str = AbsynDumpTpl.dumpCref(Tpl.emptyTxt, i_crefRight);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("connect("));
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           (i_equation as SCode.EQ_FOR(index = _)) )
      equation
        txt = dumpForEEquation(txt, i_equation);
      then txt;

    case ( txt,
           (i_equation as SCode.EQ_WHEN(condition = _)) )
      equation
        txt = dumpWhenEEquation(txt, i_equation);
      then txt;

    case ( txt,
           SCode.EQ_ASSERT(condition = i_condition, message = i_message, comment = i_comment) )
      equation
        l_cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_condition);
        l_msg__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_message);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assert("));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_msg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.EQ_TERMINATE(message = i_message, comment = i_comment) )
      equation
        l_msg__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_message);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("terminate("));
        txt = Tpl.writeText(txt, l_msg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.EQ_REINIT(cref = i_cref, expReinit = i_expReinit, comment = i_comment) )
      equation
        l_cref__str = AbsynDumpTpl.dumpCref(Tpl.emptyTxt, i_cref);
        l_exp__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_expReinit);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("reinit("));
        txt = Tpl.writeText(txt, l_cref__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.EQ_NORETCALL(exp = i_exp, comment = i_comment) )
      equation
        l_exp__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_exp);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpEEquation: Unknown EEquation.");
      then txt;
  end match;
end dumpEEquation;

protected function lm_56
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest);
      then txt;
  end match;
end lm_56;

protected function lm_57
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_57(txt, rest);
      then txt;
  end match;
end lm_57;

protected function fun_58
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_a_elseBranch;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elseBranch)
    local
      Tpl.Text txt;
      list<SCode.EEquation> i_elseBranch;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_elseBranch )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_57(txt, i_elseBranch);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_58;

public function dumpIfEEquation
  input Tpl.Text in_txt;
  input SCode.EEquation in_a_ifequation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ifequation)
    local
      Tpl.Text txt;
      list<SCode.EEquation> i_elseBranch;
      list<list<SCode.EEquation>> i_elseif__branches;
      list<Absyn.Exp> i_elseif__conds;
      list<SCode.EEquation> i_if__branch;
      Absyn.Exp i_if__cond;
      Tpl.Text l_else__str;
      Tpl.Text l_elseif__str;
      Tpl.Text l_if__branch__str;
      Tpl.Text l_if__cond__str;

    case ( txt,
           SCode.EQ_IF(condition = i_if__cond :: i_elseif__conds, thenBranch = i_if__branch :: i_elseif__branches, elseBranch = i_elseBranch) )
      equation
        l_if__cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_if__cond);
        l_if__branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_if__branch__str = lm_56(l_if__branch__str, i_if__branch);
        l_if__branch__str = Tpl.popIter(l_if__branch__str);
        l_elseif__str = dumpElseIfEEquation(Tpl.emptyTxt, i_elseif__conds, i_elseif__branches);
        l_else__str = fun_58(Tpl.emptyTxt, i_elseBranch);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_if__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_if__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_elseif__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_else__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end if;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpIfEEquation;

protected function lm_60
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_60(txt, rest);
      then txt;
  end match;
end lm_60;

protected function fun_61
  input Tpl.Text in_txt;
  input list<list<SCode.EEquation>> in_a_branches;
  input list<Absyn.Exp> in_a_rest__conds;
  input Absyn.Exp in_a_cond;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_branches, in_a_rest__conds, in_a_cond)
    local
      Tpl.Text txt;
      list<Absyn.Exp> a_rest__conds;
      Absyn.Exp a_cond;
      list<list<SCode.EEquation>> i_rest__branches;
      list<SCode.EEquation> i_branch;
      Tpl.Text l_rest__str;
      Tpl.Text l_branch__str;
      Tpl.Text l_cond__str;

    case ( txt,
           i_branch :: i_rest__branches,
           a_rest__conds,
           a_cond )
      equation
        l_cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, a_cond);
        l_branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_branch__str = lm_60(l_branch__str, i_branch);
        l_branch__str = Tpl.popIter(l_branch__str);
        l_rest__str = dumpElseIfEEquation(Tpl.emptyTxt, a_rest__conds, i_rest__branches);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elseif "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_rest__str);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_61;

public function dumpElseIfEEquation
  input Tpl.Text in_txt;
  input list<Absyn.Exp> in_a_condition;
  input list<list<SCode.EEquation>> in_a_branches;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_condition, in_a_branches)
    local
      Tpl.Text txt;
      list<list<SCode.EEquation>> a_branches;
      list<Absyn.Exp> i_rest__conds;
      Absyn.Exp i_cond;

    case ( txt,
           i_cond :: i_rest__conds,
           a_branches )
      equation
        txt = fun_61(txt, a_branches, i_rest__conds, i_cond);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpElseIfEEquation;

protected function lm_63
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_63(txt, rest);
      then txt;
  end match;
end lm_63;

protected function lm_64
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_64(txt, rest);
      then txt;
  end match;
end lm_64;

public function dumpForEEquation
  input Tpl.Text in_txt;
  input SCode.EEquation in_a_for__equation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_for__equation)
    local
      Tpl.Text txt;
      SCode.Ident i_index;
      SCode.Comment i_comment;
      list<SCode.EEquation> i_eEquationLst;
      Absyn.Exp i_range;
      Tpl.Text l_cmt__str;
      Tpl.Text l_eq__str;
      Tpl.Text l_range__str;

    case ( txt,
           SCode.EQ_FOR(range = SOME(i_range), eEquationLst = i_eEquationLst, comment = i_comment, index = i_index) )
      equation
        l_range__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_range);
        l_eq__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_eq__str = lm_63(l_eq__str, i_eEquationLst);
        l_eq__str = Tpl.popIter(l_eq__str);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for "));
        txt = Tpl.writeStr(txt, i_index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" in "));
        txt = Tpl.writeText(txt, l_range__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" loop"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_eq__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for;"));
      then txt;

    case ( txt,
           SCode.EQ_FOR(eEquationLst = i_eEquationLst, comment = i_comment, index = i_index) )
      equation
        l_eq__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_eq__str = lm_64(l_eq__str, i_eEquationLst);
        l_eq__str = Tpl.popIter(l_eq__str);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for "));
        txt = Tpl.writeStr(txt, i_index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" loop"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_eq__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpForEEquation;

protected function lm_66
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_66(txt, rest);
      then txt;
  end match;
end lm_66;

protected function lm_67
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCode.EEquation i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEEquation(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_67(txt, rest);
      then txt;
  end match;
end lm_67;

protected function lm_68
  input Tpl.Text in_txt;
  input list<tuple<Absyn.Exp, list<SCode.EEquation>>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<Absyn.Exp, list<SCode.EEquation>>> rest;
      list<SCode.EEquation> i_else__body;
      Absyn.Exp i_else__cond;
      Tpl.Text l_else__body__str;
      Tpl.Text l_else__cond__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_else__cond, i_else__body) :: rest )
      equation
        l_else__cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_else__cond);
        l_else__body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_else__body__str = lm_67(l_else__body__str, i_else__body);
        l_else__body__str = Tpl.popIter(l_else__body__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elsewhen "));
        txt = Tpl.writeText(txt, l_else__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_else__body__str);
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_68(txt, rest);
      then txt;
  end match;
end lm_68;

public function dumpWhenEEquation
  input Tpl.Text in_txt;
  input SCode.EEquation in_a_when__equation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_when__equation)
    local
      Tpl.Text txt;
      SCode.Comment i_comment;
      list<tuple<Absyn.Exp, list<SCode.EEquation>>> i_elseBranches;
      list<SCode.EEquation> i_eEquationLst;
      Absyn.Exp i_condition;
      Tpl.Text l_cmt__str;
      Tpl.Text l_else__str;
      Tpl.Text l_body__str;
      Tpl.Text l_cond__str;

    case ( txt,
           SCode.EQ_WHEN(condition = i_condition, eEquationLst = i_eEquationLst, elseBranches = i_elseBranches, comment = i_comment) )
      equation
        l_cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_condition);
        l_body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__str = lm_66(l_body__str, i_eEquationLst);
        l_body__str = Tpl.popIter(l_body__str);
        l_else__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_else__str = lm_68(l_else__str, i_elseBranches);
        l_else__str = Tpl.popIter(l_else__str);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_else__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpWhenEEquation;

protected function lm_70
  input Tpl.Text in_txt;
  input list<SCode.AlgorithmSection> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.AlgorithmSection> rest;
      SCode.AlgorithmSection i_al;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_al :: rest )
      equation
        txt = dumpAlgorithmSection(txt, i_al);
        txt = Tpl.nextIter(txt);
        txt = lm_70(txt, rest);
      then txt;
  end match;
end lm_70;

public function dumpAlgorithmSections
  input Tpl.Text in_txt;
  input list<SCode.AlgorithmSection> in_a_algorithms;
  input String in_a_label;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_algorithms, in_a_label)
    local
      Tpl.Text txt;
      String a_label;
      list<SCode.AlgorithmSection> i_algorithms;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_algorithms,
           a_label )
      equation
        txt = Tpl.writeStr(txt, a_label);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_70(txt, i_algorithms);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end dumpAlgorithmSections;

public function dumpAlgorithmSection
  input Tpl.Text in_txt;
  input SCode.AlgorithmSection in_a_algorithm;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_algorithm)
    local
      Tpl.Text txt;
      list<SCode.Statement> i_statements;

    case ( txt,
           SCode.ALGORITHM(statements = i_statements) )
      equation
        txt = dumpStatements(txt, i_statements);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAlgorithmSection;

protected function lm_73
  input Tpl.Text in_txt;
  input list<SCode.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Statement> rest;
      SCode.Statement i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = dumpStatement(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_73(txt, rest);
      then txt;
  end match;
end lm_73;

public function dumpStatements
  input Tpl.Text txt;
  input list<SCode.Statement> a_statements;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_73(out_txt, a_statements);
  out_txt := Tpl.popIter(out_txt);
end dumpStatements;

public function dumpStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_statement;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_statement)
    local
      Tpl.Text txt;
      Absyn.Exp i_exp;
      SCode.Statement i_statement;
      SCode.Comment i_comment;
      Absyn.Exp i_value;
      Absyn.Exp i_assignComponent;
      Tpl.Text l_exp__str;
      Tpl.Text l_cmt__str;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           SCode.ALG_ASSIGN(assignComponent = i_assignComponent, value = i_value, comment = i_comment) )
      equation
        l_lhs__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_assignComponent);
        l_rhs__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_value);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" := "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_IF(boolExpr = _)) )
      equation
        txt = dumpIfStatement(txt, i_statement);
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_FOR(index = _)) )
      equation
        txt = dumpForStatement(txt, i_statement);
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_WHILE(boolExpr = _)) )
      equation
        txt = dumpWhileStatement(txt, i_statement);
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_WHEN_A(branches = _)) )
      equation
        txt = dumpWhenStatement(txt, i_statement);
      then txt;

    case ( txt,
           SCode.ALG_NORETCALL(exp = i_exp, comment = i_comment) )
      equation
        l_exp__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_exp);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.ALG_RETURN(comment = i_comment) )
      equation
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.ALG_BREAK(comment = i_comment) )
      equation
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpStatement: Unknown statement.");
      then txt;
  end match;
end dumpStatement;

public function dumpIfStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_if__statement;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_if__statement)
    local
      Tpl.Text txt;
      SCode.Comment i_comment;
      list<SCode.Statement> i_elseBranch;
      list<tuple<Absyn.Exp, list<SCode.Statement>>> i_elseIfBranch;
      list<SCode.Statement> i_trueBranch;
      Absyn.Exp i_boolExpr;
      Tpl.Text l_cmt__str;
      Tpl.Text l_else__branch__str;
      Tpl.Text l_else__if__str;
      Tpl.Text l_true__branch__str;
      Tpl.Text l_cond__str;

    case ( txt,
           SCode.ALG_IF(boolExpr = i_boolExpr, trueBranch = i_trueBranch, elseIfBranch = i_elseIfBranch, elseBranch = i_elseBranch, comment = i_comment) )
      equation
        l_cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_boolExpr);
        l_true__branch__str = dumpStatements(Tpl.emptyTxt, i_trueBranch);
        l_else__if__str = dumpElseIfStatements(Tpl.emptyTxt, i_elseIfBranch);
        l_else__branch__str = dumpStatements(Tpl.emptyTxt, i_elseBranch);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_true__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_else__if__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_else__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end if;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpIfStatement;

protected function lm_77
  input Tpl.Text in_txt;
  input list<tuple<Absyn.Exp, list<SCode.Statement>>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<Absyn.Exp, list<SCode.Statement>>> rest;
      list<SCode.Statement> i_body;
      Absyn.Exp i_cond;
      Tpl.Text l_body__str;
      Tpl.Text l_cond__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_cond, i_body) :: rest )
      equation
        l_cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_cond);
        l_body__str = dumpStatements(Tpl.emptyTxt, i_body);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elseif "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_77(txt, rest);
      then txt;
  end match;
end lm_77;

public function dumpElseIfStatements
  input Tpl.Text txt;
  input list<tuple<Absyn.Exp, list<SCode.Statement>>> a_else__if;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_77(out_txt, a_else__if);
  out_txt := Tpl.popIter(out_txt);
end dumpElseIfStatements;

public function dumpForStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_for__statement;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_for__statement)
    local
      Tpl.Text txt;
      String i_index;
      SCode.Comment i_comment;
      list<SCode.Statement> i_forBody;
      Absyn.Exp i_e;
      Tpl.Text l_cmt__str;
      Tpl.Text l_body__str;
      Tpl.Text l_range__str;

    case ( txt,
           SCode.ALG_FOR(range = SOME(i_e), forBody = i_forBody, comment = i_comment, index = i_index) )
      equation
        l_range__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_e);
        l_body__str = dumpStatements(Tpl.emptyTxt, i_forBody);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for "));
        txt = Tpl.writeStr(txt, i_index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" in "));
        txt = Tpl.writeText(txt, l_range__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" loop"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for;"));
      then txt;

    case ( txt,
           SCode.ALG_FOR(forBody = i_forBody, comment = i_comment, index = i_index) )
      equation
        l_body__str = dumpStatements(Tpl.emptyTxt, i_forBody);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for "));
        txt = Tpl.writeStr(txt, i_index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" loop"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpForStatement;

public function dumpWhileStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_while__statement;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_while__statement)
    local
      Tpl.Text txt;
      SCode.Comment i_comment;
      list<SCode.Statement> i_whileBody;
      Absyn.Exp i_boolExpr;
      Tpl.Text l_cmt__str;
      Tpl.Text l_body__str;
      Tpl.Text l_cond__str;

    case ( txt,
           SCode.ALG_WHILE(boolExpr = i_boolExpr, whileBody = i_whileBody, comment = i_comment) )
      equation
        l_cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_boolExpr);
        l_body__str = dumpStatements(Tpl.emptyTxt, i_whileBody);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("while "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" loop\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end while;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpWhileStatement;

protected function lm_81
  input Tpl.Text in_txt;
  input list<tuple<Absyn.Exp, list<SCode.Statement>>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<Absyn.Exp, list<SCode.Statement>>> rest;
      list<SCode.Statement> i_ew__body;
      Absyn.Exp i_ew__cond;
      Tpl.Text l_ew__body__str;
      Tpl.Text l_ew__cond__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_ew__cond, i_ew__body) :: rest )
      equation
        l_ew__cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_ew__cond);
        l_ew__body__str = dumpStatements(Tpl.emptyTxt, i_ew__body);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elsewhen "));
        txt = Tpl.writeText(txt, l_ew__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_ew__body__str);
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_81(txt, rest);
      then txt;
  end match;
end lm_81;

public function dumpWhenStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_when__statement;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_when__statement)
    local
      Tpl.Text txt;
      SCode.Comment i_comment;
      list<tuple<Absyn.Exp, list<SCode.Statement>>> i_elsewhens;
      list<SCode.Statement> i_when__body;
      Absyn.Exp i_when__cond;
      Tpl.Text l_cmt__str;
      Tpl.Text l_elsewhen__str;
      Tpl.Text l_when__body__str;
      Tpl.Text l_when__cond__str;

    case ( txt,
           SCode.ALG_WHEN_A(branches = (i_when__cond, i_when__body) :: i_elsewhens, comment = i_comment) )
      equation
        l_when__cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_when__cond);
        l_when__body__str = dumpStatements(Tpl.emptyTxt, i_when__body);
        l_elsewhen__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_elsewhen__str = lm_81(l_elsewhen__str, i_elsewhens);
        l_elsewhen__str = Tpl.popIter(l_elsewhen__str);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, l_when__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_when__body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_elsewhen__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpWhenStatement;

public function dumpPrefixes
  input Tpl.Text in_txt;
  input SCode.Prefixes in_a_prefixes;
  input String in_a_each;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_prefixes, in_a_each)
    local
      Tpl.Text txt;
      String a_each;
      SCode.Replaceable i_replaceablePrefix;
      Absyn.InnerOuter i_innerOuter;
      SCode.Final i_finalPrefix;
      SCode.Redeclare i_redeclarePrefix;
      Tpl.Text l_replaceable__str;
      Tpl.Text l_io__str;
      Tpl.Text l_final__str;
      Tpl.Text l_redeclare__str;

    case ( txt,
           SCode.PREFIXES(redeclarePrefix = i_redeclarePrefix, finalPrefix = i_finalPrefix, innerOuter = i_innerOuter, replaceablePrefix = i_replaceablePrefix),
           a_each )
      equation
        l_redeclare__str = dumpRedeclare(Tpl.emptyTxt, i_redeclarePrefix);
        l_final__str = dumpFinal(Tpl.emptyTxt, i_finalPrefix);
        l_io__str = dumpInnerOuter(Tpl.emptyTxt, i_innerOuter);
        l_replaceable__str = dumpReplaceable(Tpl.emptyTxt, i_replaceablePrefix);
        txt = Tpl.writeText(txt, l_redeclare__str);
        txt = Tpl.writeStr(txt, a_each);
        txt = Tpl.writeText(txt, l_final__str);
        txt = Tpl.writeText(txt, l_io__str);
        txt = Tpl.writeText(txt, l_replaceable__str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpPrefixes;

public function dumpVisibility
  input Tpl.Text in_txt;
  input SCode.Visibility in_a_visibility;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_visibility)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.PROTECTED() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("protected "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVisibility;

public function dumpRedeclare
  input Tpl.Text in_txt;
  input SCode.Redeclare in_a_redeclare;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_redeclare)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.REDECLARE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("redeclare "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpRedeclare;

public function dumpFinal
  input Tpl.Text in_txt;
  input SCode.Final in_a_final;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_final)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.FINAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("final "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFinal;

public function dumpInnerOuter
  input Tpl.Text in_txt;
  input Absyn.InnerOuter in_a_innerOuter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_innerOuter)
    local
      Tpl.Text txt;

    case ( txt,
           Absyn.INNER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inner "));
      then txt;

    case ( txt,
           Absyn.OUTER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("outer "));
      then txt;

    case ( txt,
           Absyn.INNER_OUTER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inner outer "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInnerOuter;

public function dumpReplaceable
  input Tpl.Text in_txt;
  input SCode.Replaceable in_a_replaceable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_replaceable)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.REPLACEABLE(cc = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("replaceable "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpReplaceable;

public function dumpReplaceableConstrainClass
  input Tpl.Text in_txt;
  input SCode.Prefixes in_a_replaceable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_replaceable)
    local
      Tpl.Text txt;
      SCode.Mod i_cc__mod;
      Absyn.Path i_cc__path;
      Tpl.Text l_mod__str;
      Tpl.Text l_path__str;

    case ( txt,
           SCode.PREFIXES(replaceablePrefix = SCode.REPLACEABLE(cc = SOME(SCode.CONSTRAINCLASS(constrainingClass = i_cc__path, modifier = i_cc__mod)))) )
      equation
        l_path__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_cc__path);
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_cc__mod);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constrainedby "));
        txt = Tpl.writeText(txt, l_path__str);
        txt = Tpl.writeText(txt, l_mod__str);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpReplaceableConstrainClass;

public function dumpEach
  input Tpl.Text in_txt;
  input SCode.Each in_a_each;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_each)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.EACH() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("each "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpEach;

public function dumpEncapsulated
  input Tpl.Text in_txt;
  input SCode.Encapsulated in_a_encapsulated;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_encapsulated)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.ENCAPSULATED() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("encapsulated "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpEncapsulated;

public function dumpPartial
  input Tpl.Text in_txt;
  input SCode.Partial in_a_partial;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_partial)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.PARTIAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("partial "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpPartial;

protected function fun_93
  input Tpl.Text in_txt;
  input Boolean in_a_isExpandable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isExpandable)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("connector"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expandable connector"));
      then txt;
  end match;
end fun_93;

public function dumpRestriction
  input Tpl.Text in_txt;
  input SCode.Restriction in_a_restriction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_restriction)
    local
      Tpl.Text txt;
      SCode.FunctionRestriction i_functionRestriction;
      Boolean i_isExpandable;

    case ( txt,
           SCode.R_CLASS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class"));
      then txt;

    case ( txt,
           SCode.R_OPTIMIZATION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("optimization"));
      then txt;

    case ( txt,
           SCode.R_MODEL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("model"));
      then txt;

    case ( txt,
           SCode.R_RECORD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("record"));
      then txt;

    case ( txt,
           SCode.R_BLOCK() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("block"));
      then txt;

    case ( txt,
           SCode.R_CONNECTOR(isExpandable = i_isExpandable) )
      equation
        txt = fun_93(txt, i_isExpandable);
      then txt;

    case ( txt,
           SCode.R_OPERATOR() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("operator"));
      then txt;

    case ( txt,
           SCode.R_OPERATOR_RECORD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("operator record"));
      then txt;

    case ( txt,
           SCode.R_TYPE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("type"));
      then txt;

    case ( txt,
           SCode.R_PACKAGE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("package"));
      then txt;

    case ( txt,
           SCode.R_FUNCTION(functionRestriction = i_functionRestriction) )
      equation
        txt = dumpFunctionRestriction(txt, i_functionRestriction);
      then txt;

    case ( txt,
           SCode.R_ENUMERATION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("enumeration"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_INTEGER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("IntegerType"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_REAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RealType"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_STRING() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StringType"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_BOOLEAN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("BooleanType"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_ENUMERATION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EnumType"));
      then txt;

    case ( txt,
           SCode.R_METARECORD(name = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("record"));
      then txt;

    case ( txt,
           SCode.R_UNIONTYPE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("uniontype"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpRestriction: Unknown restriction.");
      then txt;
  end match;
end dumpRestriction;

protected function fun_95
  input Tpl.Text in_txt;
  input Boolean in_a_isImpure;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isImpure)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("impure function"));
      then txt;
  end match;
end fun_95;

protected function fun_96
  input Tpl.Text in_txt;
  input Boolean in_a_isImpure;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isImpure)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("impure function"));
      then txt;
  end match;
end fun_96;

public function dumpFunctionRestriction
  input Tpl.Text in_txt;
  input SCode.FunctionRestriction in_a_funcRest;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_funcRest)
    local
      Tpl.Text txt;
      Boolean i_isImpure;

    case ( txt,
           SCode.FR_NORMAL_FUNCTION(isImpure = i_isImpure) )
      equation
        txt = fun_95(txt, i_isImpure);
      then txt;

    case ( txt,
           SCode.FR_EXTERNAL_FUNCTION(isImpure = i_isImpure) )
      equation
        txt = fun_96(txt, i_isImpure);
      then txt;

    case ( txt,
           SCode.FR_OPERATOR_FUNCTION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("operator function"));
      then txt;

    case ( txt,
           SCode.FR_RECORD_CONSTRUCTOR() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpFunctionRestriction: Unknown Function restriction.");
      then txt;
  end match;
end dumpFunctionRestriction;

protected function lm_98
  input Tpl.Text in_txt;
  input list<SCode.SubMod> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.SubMod> rest;
      SCode.SubMod i_submod;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_submod :: rest )
      equation
        txt = dumpSubModifier(txt, i_submod);
        txt = Tpl.nextIter(txt);
        txt = lm_98(txt, rest);
      then txt;
  end match;
end lm_98;

protected function fun_99
  input Tpl.Text in_txt;
  input list<SCode.SubMod> in_a_subModLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subModLst)
    local
      Tpl.Text txt;
      list<SCode.SubMod> i_subModLst;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subModLst )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_98(txt, i_subModLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_99;

public function dumpModifier
  input Tpl.Text in_txt;
  input SCode.Mod in_a_modifier;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modifier)
    local
      Tpl.Text txt;
      list<SCode.SubMod> i_subModLst;
      Option<tuple<Absyn.Exp, Boolean>> i_binding;
      Tpl.Text l_submod__str;
      Tpl.Text l_binding__str;

    case ( txt,
           SCode.MOD(binding = i_binding, subModLst = i_subModLst) )
      equation
        l_binding__str = dumpModifierBinding(Tpl.emptyTxt, i_binding);
        l_submod__str = fun_99(Tpl.emptyTxt, i_subModLst);
        txt = Tpl.writeText(txt, l_submod__str);
        txt = Tpl.writeText(txt, l_binding__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpModifier;

public function dumpModifierPrefix
  input Tpl.Text in_txt;
  input SCode.Mod in_a_modifier;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modifier)
    local
      Tpl.Text txt;
      SCode.Each i_eachPrefix;
      SCode.Final i_finalPrefix;
      Tpl.Text l_each__str;
      Tpl.Text l_final__str;

    case ( txt,
           SCode.MOD(finalPrefix = i_finalPrefix, eachPrefix = i_eachPrefix) )
      equation
        l_final__str = dumpFinal(Tpl.emptyTxt, i_finalPrefix);
        l_each__str = dumpEach(Tpl.emptyTxt, i_eachPrefix);
        txt = Tpl.writeText(txt, l_each__str);
        txt = Tpl.writeText(txt, l_final__str);
      then txt;

    case ( txt,
           SCode.REDECL(finalPrefix = i_finalPrefix, eachPrefix = i_eachPrefix) )
      equation
        l_final__str = dumpFinal(Tpl.emptyTxt, i_finalPrefix);
        l_each__str = dumpEach(Tpl.emptyTxt, i_eachPrefix);
        txt = Tpl.writeText(txt, l_each__str);
        txt = Tpl.writeText(txt, l_final__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpModifierPrefix;

public function dumpRedeclModifier
  input Tpl.Text in_txt;
  input SCode.Mod in_a_modifier;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modifier)
    local
      Tpl.Text txt;
      SCode.Element i_element;
      SCode.Each i_eachPrefix;
      Tpl.Text l_each__str;

    case ( txt,
           SCode.REDECL(eachPrefix = i_eachPrefix, element = i_element) )
      equation
        l_each__str = dumpEach(Tpl.emptyTxt, i_eachPrefix);
        txt = dumpElement(txt, i_element, Tpl.textString(l_each__str));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpRedeclModifier;

public function dumpModifierBinding
  input Tpl.Text in_txt;
  input Option<tuple<Absyn.Exp, Boolean>> in_a_binding;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_binding)
    local
      Tpl.Text txt;
      Absyn.Exp i_exp;

    case ( txt,
           SOME((i_exp, _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = AbsynDumpTpl.dumpExp(txt, i_exp);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpModifierBinding;

public function dumpSubModifier
  input Tpl.Text in_txt;
  input SCode.SubMod in_a_submod;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_submod)
    local
      Tpl.Text txt;
      SCode.Ident i_ident;
      SCode.Mod i_A;

    case ( txt,
           SCode.NAMEMOD(A = (i_A as SCode.MOD(finalPrefix = _)), ident = i_ident) )
      equation
        txt = dumpModifierPrefix(txt, i_A);
        txt = Tpl.writeStr(txt, i_ident);
        txt = dumpModifier(txt, i_A);
      then txt;

    case ( txt,
           SCode.NAMEMOD(A = (i_A as SCode.REDECL(finalPrefix = _))) )
      equation
        txt = dumpRedeclModifier(txt, i_A);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpSubModifier;

public function dumpAttributes
  input Tpl.Text in_txt;
  input SCode.Attributes in_a_attributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attributes)
    local
      Tpl.Text txt;
      Absyn.Direction i_direction;
      SCode.Variability i_variability;
      SCode.Parallelism i_parallelism;
      SCode.ConnectorType i_connectorType;
      Tpl.Text l_dir__str;
      Tpl.Text l_var__str;
      Tpl.Text l_prl__str;
      Tpl.Text l_ct__str;

    case ( txt,
           SCode.ATTR(connectorType = i_connectorType, parallelism = i_parallelism, variability = i_variability, direction = i_direction) )
      equation
        l_ct__str = dumpConnectorType(Tpl.emptyTxt, i_connectorType);
        l_prl__str = dumpParallelism(Tpl.emptyTxt, i_parallelism);
        l_var__str = dumpVariability(Tpl.emptyTxt, i_variability);
        l_dir__str = dumpDirection(Tpl.emptyTxt, i_direction);
        txt = Tpl.writeText(txt, l_prl__str);
        txt = Tpl.writeText(txt, l_dir__str);
        txt = Tpl.writeText(txt, l_var__str);
        txt = Tpl.writeText(txt, l_ct__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAttributes;

public function dumpConnectorType
  input Tpl.Text in_txt;
  input SCode.ConnectorType in_a_connectorType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_connectorType)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.FLOW() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("flow "));
      then txt;

    case ( txt,
           SCode.STREAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("stream "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpConnectorType;

public function dumpParallelism
  input Tpl.Text in_txt;
  input SCode.Parallelism in_a_parallelism;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_parallelism)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.PARGLOBAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parglobal "));
      then txt;

    case ( txt,
           SCode.PARLOCAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parlocal "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpParallelism;

public function dumpVariability
  input Tpl.Text in_txt;
  input SCode.Variability in_a_variability;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_variability)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.DISCRETE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("discrete "));
      then txt;

    case ( txt,
           SCode.PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parameter "));
      then txt;

    case ( txt,
           SCode.CONST() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVariability;

public function dumpDirection
  input Tpl.Text in_txt;
  input Absyn.Direction in_a_direction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_direction)
    local
      Tpl.Text txt;

    case ( txt,
           Absyn.INPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("input "));
      then txt;

    case ( txt,
           Absyn.OUTPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpDirection;

public function dumpAttributeDim
  input Tpl.Text in_txt;
  input SCode.Attributes in_a_attributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attributes)
    local
      Tpl.Text txt;
      Absyn.ArrayDim i_arrayDims;

    case ( txt,
           SCode.ATTR(arrayDims = i_arrayDims) )
      equation
        txt = AbsynDumpTpl.dumpSubscripts(txt, i_arrayDims);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAttributeDim;

public function dumpAnnotationOpt
  input Tpl.Text in_txt;
  input Option<SCode.Annotation> in_a_annotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_annotation)
    local
      Tpl.Text txt;
      SCode.Annotation i_ann;

    case ( txt,
           SOME(i_ann) )
      equation
        txt = dumpAnnotation(txt, i_ann);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAnnotationOpt;

protected function fun_112
  input Tpl.Text in_txt;
  input Tpl.Text in_a_modifStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modifStr)
    local
      Tpl.Text txt;
      Tpl.Text i_modifStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("()"));
      then txt;

    case ( txt,
           i_modifStr )
      equation
        txt = Tpl.writeText(txt, i_modifStr);
      then txt;
  end match;
end fun_112;

protected function fun_113
  input Tpl.Text in_txt;
  input SCode.Annotation in_a_annotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_annotation)
    local
      Tpl.Text txt;
      SCode.Mod i_modification;
      Tpl.Text l_annStr;
      Tpl.Text l_modifStr;

    case ( txt,
           SCode.ANNOTATION(modification = i_modification) )
      equation
        l_modifStr = dumpModifier(Tpl.emptyTxt, i_modification);
        l_annStr = fun_112(Tpl.emptyTxt, l_modifStr);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("annotation"));
        txt = Tpl.writeText(txt, l_annStr);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_113;

protected function fun_114
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SCode.Annotation in_a_annotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_annotation)
    local
      Tpl.Text txt;
      SCode.Annotation a_annotation;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_annotation )
      equation
        txt = fun_113(txt, a_annotation);
      then txt;
  end match;
end fun_114;

public function dumpAnnotation
  input Tpl.Text txt;
  input SCode.Annotation a_annotation;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := Config.showAnnotations();
  out_txt := fun_114(txt, ret_0, a_annotation);
end dumpAnnotation;

protected function fun_116
  input Tpl.Text in_txt;
  input Tpl.Text in_a_annstr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_annstr)
    local
      Tpl.Text txt;
      Tpl.Text i_annstr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_annstr )
      equation
        txt = Tpl.writeText(txt, i_annstr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_116;

public function dumpAnnotationElement
  input Tpl.Text txt;
  input SCode.Annotation a_annotation;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_annstr;
algorithm
  l_annstr := dumpAnnotation(Tpl.emptyTxt, a_annotation);
  out_txt := fun_116(txt, l_annstr);
end dumpAnnotationElement;

public function dumpExternalDeclOpt
  input Tpl.Text in_txt;
  input Option<SCode.ExternalDecl> in_a_externalDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_externalDecl)
    local
      Tpl.Text txt;
      SCode.ExternalDecl i_extdecl;

    case ( txt,
           SOME(i_extdecl) )
      equation
        txt = dumpExternalDecl(txt, i_extdecl);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpExternalDeclOpt;

protected function fun_119
  input Tpl.Text in_txt;
  input Option<SCode.Ident> in_a_funcName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_funcName)
    local
      Tpl.Text txt;
      SCode.Ident i_name;

    case ( txt,
           SOME(i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_119;

protected function lm_120
  input Tpl.Text in_txt;
  input list<Absyn.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Exp> rest;
      Absyn.Exp i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = AbsynDumpTpl.dumpExp(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_120(txt, rest);
      then txt;
  end match;
end lm_120;

protected function fun_121
  input Tpl.Text in_txt;
  input Tpl.Text in_a_func__name__str;
  input Tpl.Text in_a_func__args__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_func__name__str, in_a_func__args__str)
    local
      Tpl.Text txt;
      Tpl.Text a_func__args__str;
      Tpl.Text i_func__name__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           i_func__name__str,
           a_func__args__str )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, i_func__name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_func__args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_121;

protected function fun_122
  input Tpl.Text in_txt;
  input Option<String> in_a_lang;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lang)
    local
      Tpl.Text txt;
      String i_l;

    case ( txt,
           SOME(i_l) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_l);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_122;

protected function fun_123
  input Tpl.Text in_txt;
  input Option<Absyn.ComponentRef> in_a_output__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_output__)
    local
      Tpl.Text txt;
      Absyn.ComponentRef i_name;

    case ( txt,
           SOME(i_name) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = AbsynDumpTpl.dumpCref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ="));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_123;

public function dumpExternalDecl
  input Tpl.Text in_txt;
  input SCode.ExternalDecl in_a_externalDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_externalDecl)
    local
      Tpl.Text txt;
      Option<Absyn.ComponentRef> i_output__;
      Option<String> i_lang;
      list<Absyn.Exp> i_args;
      Option<SCode.Ident> i_funcName;
      Tpl.Text l_output__str;
      Tpl.Text l_lang__str;
      Tpl.Text l_func__str;
      Tpl.Text l_func__args__str;
      Tpl.Text l_func__name__str;

    case ( txt,
           SCode.EXTERNALDECL(funcName = i_funcName, args = i_args, lang = i_lang, output_ = i_output__) )
      equation
        l_func__name__str = fun_119(Tpl.emptyTxt, i_funcName);
        l_func__args__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_func__args__str = lm_120(l_func__args__str, i_args);
        l_func__args__str = Tpl.popIter(l_func__args__str);
        l_func__str = fun_121(Tpl.emptyTxt, l_func__name__str, l_func__args__str);
        l_lang__str = fun_122(Tpl.emptyTxt, i_lang);
        l_output__str = fun_123(Tpl.emptyTxt, i_output__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external"));
        txt = Tpl.writeText(txt, l_lang__str);
        txt = Tpl.writeText(txt, l_output__str);
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpExternalDecl;

public function dumpCommentOpt
  input Tpl.Text in_txt;
  input Option<SCode.Comment> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      SCode.Comment i_cmt;

    case ( txt,
           SOME(i_cmt) )
      equation
        txt = dumpComment(txt, i_cmt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpCommentOpt;

protected function fun_126
  input Tpl.Text in_txt;
  input SCode.Comment in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      Option<String> i_comment;
      Option<SCode.Annotation> i_annotation__;
      Tpl.Text l_cmt__str;
      Tpl.Text l_ann__str;

    case ( txt,
           SCode.COMMENT(annotation_ = i_annotation__, comment = i_comment) )
      equation
        l_ann__str = dumpAnnotationOpt(Tpl.emptyTxt, i_annotation__);
        l_cmt__str = dumpCommentStr(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeText(txt, l_ann__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_126;

protected function fun_127
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SCode.Comment in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_comment)
    local
      Tpl.Text txt;
      SCode.Comment a_comment;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_comment )
      equation
        txt = fun_126(txt, a_comment);
      then txt;
  end match;
end fun_127;

public function dumpComment
  input Tpl.Text txt;
  input SCode.Comment a_comment;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := Config.showAnnotations();
  out_txt := fun_127(txt, ret_0, a_comment);
end dumpComment;

public function dumpCommentStr
  input Tpl.Text in_txt;
  input Option<String> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_cmt;

    case ( txt,
           SOME(i_cmt) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_cmt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpCommentStr;

public function errorMsg
  input Tpl.Text txt;
  input String a_errMessage;

  output Tpl.Text out_txt;
algorithm
  Tpl.addTemplateError(a_errMessage);
  out_txt := Tpl.writeStr(txt, a_errMessage);
end errorMsg;

end SCodeDumpTpl;