#pragma once

/**
Auxiliary  class to handle system events
Implements the Modelica pre,edge,change operators
Holds a help vector for the discrete variables
Holds an event queue to handle all events occured at the same time
*/
typedef boost::function<bool (unsigned int)> getCondition_type;
class BOOST_EXTENSION_EVENTHANDLING_DECL EventHandling
{
public:
    EventHandling();
    ~EventHandling(void);
    //Inits the event variables
    void initialize(IMixedSystem* system,int dim);
    //Returns the help vector 
    void getHelpVars(double* h);
    //sets the help vector
    void setHelpVars(const double* h);
    //returns the dimension of the help vector
    int getDimHelpVars() const;



    //saves a variable in _pre_vars vector
    void save(double var,string key);
    //saves all helpvariables
    void saveH();
    void setHelpVar(unsigned int i,double var);
    const double& operator[](unsigned int i) const;
    //Implementation of the Modelica pre  operator
    double pre(double var,string key);
    //Implementation of the Modelica edge  operator
    bool edge(double var,string key);
    //Implementation of the Modelica change  operator
    bool change(double var,string key);
      //Adds an event to the eventqueue
    void addEvent(long index);
    //removes an event from the eventqueue
    void removeEvent(long index);
    //Handles  all events occured a the same time. Returns true if a second event iteration is needed
    bool IterateEventQueue(bool& state_vars_reinitialized);

    void saveDiscreteVar(double var,string key);
    bool changeDiscreteVar(double var,string key);
   
  
    getCondition_type  getCondition;
private:
    //Stores all varibales occured before an event
    unordered_map<string,double> _pre_vars;
    //stores all eventes
    unordered_map<string,double> _pre_discrete_vars; // i guess this was used in a wrong way. it might be obsolete.
    IMixedSystem* _system;
    //Helpvarsvector for discrete variables
    double* _h;
    //Dimesion of Helpvarsvector
    int _dimH;
     event_times_type _time_events;
};
