#ifndef BackendDAEUtil__H
#define BackendDAEUtil__H
#define __OPENMODELICA__METAMODELICA
#include "meta_modelica.h"

#include "modelica.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#ifdef __cplusplus
extern "C" {
#endif

extern struct record_description Absyn_Info_INFO__desc;
extern struct record_description Absyn_Msg_NO__MSG__desc;
extern struct record_description Absyn_Path_IDENT__desc;
extern struct record_description Absyn_TimeStamp_TIMESTAMP__desc;
extern struct record_description BackendDAE_BackendDAE_DAE__desc;
extern struct record_description BackendDAE_EqSystem_EQSYSTEM__desc;
extern struct record_description BackendDAE_Equation_EQUATION__desc;
extern struct record_description BackendDAE_Equation_RESIDUAL__EQUATION__desc;
extern struct record_description BackendDAE_EquationConstraints_EXACT__desc;
extern struct record_description BackendDAE_EventInfo_EVENT__INFO__desc;
extern struct record_description BackendDAE_IndexReduction_INDEX__REDUCTION__desc;
extern struct record_description BackendDAE_IndexType_NORMAL__desc;
extern struct record_description BackendDAE_IndexType_SOLVABLE__desc;
extern struct record_description BackendDAE_JacobianType_JAC__CONSTANT__desc;
extern struct record_description BackendDAE_JacobianType_JAC__NONLINEAR__desc;
extern struct record_description BackendDAE_JacobianType_JAC__NO__ANALYTIC__desc;
extern struct record_description BackendDAE_JacobianType_JAC__TIME__VARYING__desc;
extern struct record_description BackendDAE_Matching_MATCHING__desc;
extern struct record_description BackendDAE_Matching_NO__MATCHING__desc;
extern struct record_description BackendDAE_SampleLookup_SAMPLE__LOOKUP__desc;
extern struct record_description BackendDAE_Shared_SHARED__desc;
extern struct record_description BackendDAE_Solvability_SOLVABILITY__CONST__desc;
extern struct record_description BackendDAE_Solvability_SOLVABILITY__CONSTONE__desc;
extern struct record_description BackendDAE_Solvability_SOLVABILITY__NONLINEAR__desc;
extern struct record_description BackendDAE_Solvability_SOLVABILITY__PARAMETER__desc;
extern struct record_description BackendDAE_Solvability_SOLVABILITY__SOLVED__desc;
extern struct record_description BackendDAE_Solvability_SOLVABILITY__TIMEVARYING__desc;
extern struct record_description BackendDAE_Solvability_SOLVABILITY__UNSOLVABLE__desc;
extern struct record_description BackendDAE_StrongComponent_SINGLEEQUATION__desc;
extern struct record_description BackendDAE_Var_VAR__desc;
extern struct record_description BackendDAE_VarKind_VARIABLE__desc;
extern struct record_description BinaryTree_BinTree_TREENODE__desc;
extern struct record_description DAE_Algorithm_ALGORITHM__STMTS__desc;
extern struct record_description DAE_CallAttributes_CALL__ATTR__desc;
extern struct record_description DAE_ConnectorType_NON__CONNECTOR__desc;
extern struct record_description DAE_Dimension_DIM__INTEGER__desc;
extern struct record_description DAE_Distribution_DISTRIBUTION__desc;
extern struct record_description DAE_ElementSource_SOURCE__desc;
extern struct record_description DAE_Else_ELSE__desc;
extern struct record_description DAE_Else_ELSEIF__desc;
extern struct record_description DAE_Else_NOELSE__desc;
extern struct record_description DAE_Exp_ARRAY__desc;
extern struct record_description DAE_Exp_CALL__desc;
extern struct record_description DAE_Exp_ICONST__desc;
extern struct record_description DAE_Exp_IFEXP__desc;
extern struct record_description DAE_Exp_MATRIX__desc;
extern struct record_description DAE_Exp_RCONST__desc;
extern struct record_description DAE_InlineType_NORM__INLINE__desc;
extern struct record_description DAE_InlineType_NO__INLINE__desc;
extern struct record_description DAE_Statement_STMT__FOR__desc;
extern struct record_description DAE_Statement_STMT__IF__desc;
extern struct record_description DAE_Statement_STMT__WHEN__desc;
extern struct record_description DAE_Statement_STMT__WHILE__desc;
extern struct record_description DAE_Subscript_INDEX__desc;
extern struct record_description DAE_Subscript_SLICE__desc;
extern struct record_description DAE_Subscript_WHOLEDIM__desc;
extern struct record_description DAE_TailCall_NO__TAIL__desc;
extern struct record_description DAE_Type_T__INTEGER__desc;
extern struct record_description DAE_Type_T__REAL__desc;
extern struct record_description DAE_VarDirection_BIDIR__desc;
extern struct record_description DAE_VarParallelism_NON__PARALLEL__desc;
extern struct record_description DAE_VariableAttributes_VAR__ATTR__BOOL__desc;
extern struct record_description DAE_VariableAttributes_VAR__ATTR__ENUMERATION__desc;
extern struct record_description DAE_VariableAttributes_VAR__ATTR__INT__desc;
extern struct record_description DAE_VariableAttributes_VAR__ATTR__REAL__desc;
extern struct record_description DAE_VariableAttributes_VAR__ATTR__STRING__desc;
extern struct record_description Error_Message_MESSAGE__desc;
extern struct record_description Error_MessageType_SYMBOLIC__desc;
extern struct record_description Error_MessageType_TRANSLATION__desc;
extern struct record_description Error_Severity_ERROR__desc;
extern struct record_description Flags_ConfigFlag_CONFIG__FLAG__desc;
extern struct record_description Flags_DebugFlag_DEBUG__FLAG__desc;
extern struct record_description Flags_FlagData_BOOL__FLAG__desc;
extern struct record_description Flags_FlagVisibility_EXTERNAL__desc;
extern struct record_description Flags_FlagVisibility_INTERNAL__desc;
extern struct record_description Util_Status_FAILURE__desc;
extern struct record_description Util_Status_SUCCESS__desc;
extern struct record_description Util_TranslatableContent_gettext__desc;

DLLExport
void omc_BackendDAEUtil_checkBackendDAEWithErrorMsg(threadData_t *threadData, modelica_metatype _inBackendDAE);
#define boxptr_BackendDAEUtil_checkBackendDAEWithErrorMsg omc_BackendDAEUtil_checkBackendDAEWithErrorMsg


DLLExport
void omc_BackendDAEUtil_printcheckBackendDAEWithErrorMsg(threadData_t *threadData, modelica_metatype _inExpCrefs, modelica_metatype _inWrongEqns);
#define boxptr_BackendDAEUtil_printcheckBackendDAEWithErrorMsg omc_BackendDAEUtil_printcheckBackendDAEWithErrorMsg


DLLExport
void omc_BackendDAEUtil_printEqnSizeError(threadData_t *threadData, modelica_metatype _inEqn);
#define boxptr_BackendDAEUtil_printEqnSizeError omc_BackendDAEUtil_printEqnSizeError

typedef struct BackendDAEUtil_checkBackendDAE_rettype_s {
  modelica_metatype c1; /* outExpCrefs */
  modelica_metatype c2; /* outWrongEqns */
} BackendDAEUtil_checkBackendDAE_rettype;
DLLExport
BackendDAEUtil_checkBackendDAE_rettype omc_BackendDAEUtil_checkBackendDAE(threadData_t *threadData, modelica_metatype _inBackendDAE);
#define boxptr_BackendDAEUtil_checkBackendDAE omc_BackendDAEUtil_checkBackendDAE

typedef struct BackendDAEUtil_checkBackendDAEExp_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_checkBackendDAEExp_rettype;
DLLExport
BackendDAEUtil_checkBackendDAEExp_rettype omc_BackendDAEUtil_checkBackendDAEExp(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_checkBackendDAEExp omc_BackendDAEUtil_checkBackendDAEExp

typedef struct BackendDAEUtil_traversecheckBackendDAEExp_rettype_s {
  modelica_metatype c1; /* outTuple */
} BackendDAEUtil_traversecheckBackendDAEExp_rettype;
DLLExport
BackendDAEUtil_traversecheckBackendDAEExp_rettype omc_BackendDAEUtil_traversecheckBackendDAEExp(threadData_t *threadData, modelica_metatype _inTuple);
#define boxptr_BackendDAEUtil_traversecheckBackendDAEExp omc_BackendDAEUtil_traversecheckBackendDAEExp

typedef struct BackendDAEUtil_makeIterVariable_rettype_s {
  modelica_metatype c1; /* backendVar */
} BackendDAEUtil_makeIterVariable_rettype;
DLLExport
BackendDAEUtil_makeIterVariable_rettype omc_BackendDAEUtil_makeIterVariable(threadData_t *threadData, modelica_metatype _iter);
#define boxptr_BackendDAEUtil_makeIterVariable omc_BackendDAEUtil_makeIterVariable

typedef struct BackendDAEUtil_checkEquationSize_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_checkEquationSize_rettype;
DLLExport
BackendDAEUtil_checkEquationSize_rettype omc_BackendDAEUtil_checkEquationSize(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_checkEquationSize omc_BackendDAEUtil_checkEquationSize


DLLExport
void omc_BackendDAEUtil_checkAssertCondition(threadData_t *threadData, modelica_metatype _cond, modelica_metatype _message, modelica_metatype _level, modelica_metatype _info);
#define boxptr_BackendDAEUtil_checkAssertCondition omc_BackendDAEUtil_checkAssertCondition

typedef struct BackendDAEUtil_createEmptyBackendDAE_rettype_s {
  modelica_metatype c1; /* outBDAE */
} BackendDAEUtil_createEmptyBackendDAE_rettype;
DLLExport
BackendDAEUtil_createEmptyBackendDAE_rettype omc_BackendDAEUtil_createEmptyBackendDAE(threadData_t *threadData, modelica_metatype _inBDAEType);
#define boxptr_BackendDAEUtil_createEmptyBackendDAE omc_BackendDAEUtil_createEmptyBackendDAE

typedef struct BackendDAEUtil_copyBackendDAE_rettype_s {
  modelica_metatype c1; /* outBDAE */
} BackendDAEUtil_copyBackendDAE_rettype;
DLLExport
BackendDAEUtil_copyBackendDAE_rettype omc_BackendDAEUtil_copyBackendDAE(threadData_t *threadData, modelica_metatype _inBDAE);
#define boxptr_BackendDAEUtil_copyBackendDAE omc_BackendDAEUtil_copyBackendDAE

typedef struct BackendDAEUtil_copyBackendDAEEqSystem_rettype_s {
  modelica_metatype c1; /* outSysts */
  modelica_metatype c2; /* outShared */
} BackendDAEUtil_copyBackendDAEEqSystem_rettype;
DLLExport
BackendDAEUtil_copyBackendDAEEqSystem_rettype omc_BackendDAEUtil_copyBackendDAEEqSystem(threadData_t *threadData, modelica_metatype _inSysts, modelica_metatype _inShared);
#define boxptr_BackendDAEUtil_copyBackendDAEEqSystem omc_BackendDAEUtil_copyBackendDAEEqSystem

typedef struct BackendDAEUtil_copyBackendDAEShared_rettype_s {
  modelica_metatype c1; /* outShared */
} BackendDAEUtil_copyBackendDAEShared_rettype;
DLLExport
BackendDAEUtil_copyBackendDAEShared_rettype omc_BackendDAEUtil_copyBackendDAEShared(threadData_t *threadData, modelica_metatype _inShared);
#define boxptr_BackendDAEUtil_copyBackendDAEShared omc_BackendDAEUtil_copyBackendDAEShared

typedef struct BackendDAEUtil_copyMatching_rettype_s {
  modelica_metatype c1; /* outMatching */
} BackendDAEUtil_copyMatching_rettype;
DLLExport
BackendDAEUtil_copyMatching_rettype omc_BackendDAEUtil_copyMatching(threadData_t *threadData, modelica_metatype _inMatching);
#define boxptr_BackendDAEUtil_copyMatching omc_BackendDAEUtil_copyMatching

typedef struct BackendDAEUtil_addBackendDAESharedJacobian_rettype_s {
  modelica_metatype c1; /* outShared */
} BackendDAEUtil_addBackendDAESharedJacobian_rettype;
DLLExport
BackendDAEUtil_addBackendDAESharedJacobian_rettype omc_BackendDAEUtil_addBackendDAESharedJacobian(threadData_t *threadData, modelica_metatype _inSymJac, modelica_metatype _inSparsePattern, modelica_metatype _inSparseColoring, modelica_metatype _inShared);
#define boxptr_BackendDAEUtil_addBackendDAESharedJacobian omc_BackendDAEUtil_addBackendDAESharedJacobian

typedef struct BackendDAEUtil_addBackendDAESharedJacobians_rettype_s {
  modelica_metatype c1; /* outShared */
} BackendDAEUtil_addBackendDAESharedJacobians_rettype;
DLLExport
BackendDAEUtil_addBackendDAESharedJacobians_rettype omc_BackendDAEUtil_addBackendDAESharedJacobians(threadData_t *threadData, modelica_metatype _inSymJac, modelica_metatype _inShared);
#define boxptr_BackendDAEUtil_addBackendDAESharedJacobians omc_BackendDAEUtil_addBackendDAESharedJacobians

typedef struct BackendDAEUtil_addBackendDAESharedJacobianSparsePattern_rettype_s {
  modelica_metatype c1; /* outShared */
} BackendDAEUtil_addBackendDAESharedJacobianSparsePattern_rettype;
DLLExport
BackendDAEUtil_addBackendDAESharedJacobianSparsePattern_rettype omc_BackendDAEUtil_addBackendDAESharedJacobianSparsePattern(threadData_t *threadData, modelica_metatype _inSparsePattern, modelica_metatype _inSparseColoring, modelica_integer _inIndex, modelica_metatype _inShared);
typedef struct BackendDAEUtil_addBackendDAESharedJacobianSparsePattern_rettypeboxed_s {
  modelica_metatype c1; /* outShared */
} BackendDAEUtil_addBackendDAESharedJacobianSparsePattern_rettypeboxed;
DLLExport
BackendDAEUtil_addBackendDAESharedJacobianSparsePattern_rettypeboxed boxptr_BackendDAEUtil_addBackendDAESharedJacobianSparsePattern(threadData_t *threadData, modelica_metatype _inSparsePattern, modelica_metatype _inSparseColoring, modelica_metatype _inIndex, modelica_metatype _inShared);
typedef struct BackendDAEUtil_addBackendDAEKnVars_rettype_s {
  modelica_metatype c1; /* outBDAE */
} BackendDAEUtil_addBackendDAEKnVars_rettype;
DLLExport
BackendDAEUtil_addBackendDAEKnVars_rettype omc_BackendDAEUtil_addBackendDAEKnVars(threadData_t *threadData, modelica_metatype _inKnVars, modelica_metatype _inBDAE);
#define boxptr_BackendDAEUtil_addBackendDAEKnVars omc_BackendDAEUtil_addBackendDAEKnVars

typedef struct BackendDAEUtil_addBackendDAEFunctionTree_rettype_s {
  modelica_metatype c1; /* outBDAE */
} BackendDAEUtil_addBackendDAEFunctionTree_rettype;
DLLExport
BackendDAEUtil_addBackendDAEFunctionTree_rettype omc_BackendDAEUtil_addBackendDAEFunctionTree(threadData_t *threadData, modelica_metatype _inFunctionTree, modelica_metatype _inBDAE);
#define boxptr_BackendDAEUtil_addBackendDAEFunctionTree omc_BackendDAEUtil_addBackendDAEFunctionTree

typedef struct BackendDAEUtil_addVarsToEqSystem_rettype_s {
  modelica_metatype c1; /* osyst */
} BackendDAEUtil_addVarsToEqSystem_rettype;
DLLExport
BackendDAEUtil_addVarsToEqSystem_rettype omc_BackendDAEUtil_addVarsToEqSystem(threadData_t *threadData, modelica_metatype _syst, modelica_metatype _varlst);
#define boxptr_BackendDAEUtil_addVarsToEqSystem omc_BackendDAEUtil_addVarsToEqSystem

typedef struct BackendDAEUtil_addDummyStateIfNeeded_rettype_s {
  modelica_metatype c1; /* outBackendDAE */
} BackendDAEUtil_addDummyStateIfNeeded_rettype;
DLLExport
BackendDAEUtil_addDummyStateIfNeeded_rettype omc_BackendDAEUtil_addDummyStateIfNeeded(threadData_t *threadData, modelica_metatype _inBackendDAE);
#define boxptr_BackendDAEUtil_addDummyStateIfNeeded omc_BackendDAEUtil_addDummyStateIfNeeded

typedef struct BackendDAEUtil_addDummyStateIfNeeded1_rettype_s {
  modelica_boolean c1; /* oContainsNoStates */
} BackendDAEUtil_addDummyStateIfNeeded1_rettype;
DLLExport
BackendDAEUtil_addDummyStateIfNeeded1_rettype omc_BackendDAEUtil_addDummyStateIfNeeded1(threadData_t *threadData, modelica_metatype _iSysts);
typedef struct BackendDAEUtil_addDummyStateIfNeeded1_rettypeboxed_s {
  modelica_metatype c1; /* oContainsNoStates */
} BackendDAEUtil_addDummyStateIfNeeded1_rettypeboxed;
DLLExport
BackendDAEUtil_addDummyStateIfNeeded1_rettypeboxed boxptr_BackendDAEUtil_addDummyStateIfNeeded1(threadData_t *threadData, modelica_metatype _iSysts);
typedef struct BackendDAEUtil_traverserVaraddDummyStateIfNeeded_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_traverserVaraddDummyStateIfNeeded_rettype;
DLLExport
BackendDAEUtil_traverserVaraddDummyStateIfNeeded_rettype omc_BackendDAEUtil_traverserVaraddDummyStateIfNeeded(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_traverserVaraddDummyStateIfNeeded omc_BackendDAEUtil_traverserVaraddDummyStateIfNeeded

typedef struct BackendDAEUtil_addDummyState_rettype_s {
  modelica_metatype c1; /* osysts */
} BackendDAEUtil_addDummyState_rettype;
DLLExport
BackendDAEUtil_addDummyState_rettype omc_BackendDAEUtil_addDummyState(threadData_t *threadData, modelica_metatype _isysts);
#define boxptr_BackendDAEUtil_addDummyState omc_BackendDAEUtil_addDummyState

typedef struct BackendDAEUtil_calculateSizes_rettype_s {
  modelica_integer c1; /* outnx */
  modelica_integer c2; /* outny */
  modelica_integer c3; /* outnp */
  modelica_integer c4; /* outng */
  modelica_integer c5; /* outng_sample */
  modelica_integer c6; /* outnext */
  modelica_integer c7; /* outny_string */
  modelica_integer c8; /* outnp_string */
  modelica_integer c9; /* outny_int */
  modelica_integer c10; /* outnp_int */
  modelica_integer c11; /* outny_bool */
  modelica_integer c12; /* outnp_bool */
} BackendDAEUtil_calculateSizes_rettype;
DLLExport
BackendDAEUtil_calculateSizes_rettype omc_BackendDAEUtil_calculateSizes(threadData_t *threadData, modelica_metatype _inBackendDAE);
typedef struct BackendDAEUtil_calculateSizes_rettypeboxed_s {
  modelica_metatype c1; /* outnx */
  modelica_metatype c2; /* outny */
  modelica_metatype c3; /* outnp */
  modelica_metatype c4; /* outng */
  modelica_metatype c5; /* outng_sample */
  modelica_metatype c6; /* outnext */
  modelica_metatype c7; /* outny_string */
  modelica_metatype c8; /* outnp_string */
  modelica_metatype c9; /* outny_int */
  modelica_metatype c10; /* outnp_int */
  modelica_metatype c11; /* outny_bool */
  modelica_metatype c12; /* outnp_bool */
} BackendDAEUtil_calculateSizes_rettypeboxed;
DLLExport
BackendDAEUtil_calculateSizes_rettypeboxed boxptr_BackendDAEUtil_calculateSizes(threadData_t *threadData, modelica_metatype _inBackendDAE);
typedef struct BackendDAEUtil_calculateNumberZeroCrossings_rettype_s {
  modelica_integer c1; /* zc */
  modelica_integer c2; /* sample */
} BackendDAEUtil_calculateNumberZeroCrossings_rettype;
DLLExport
BackendDAEUtil_calculateNumberZeroCrossings_rettype omc_BackendDAEUtil_calculateNumberZeroCrossings(threadData_t *threadData, modelica_metatype _zcLst, modelica_integer _inZc_index, modelica_integer _inSample_index);
typedef struct BackendDAEUtil_calculateNumberZeroCrossings_rettypeboxed_s {
  modelica_metatype c1; /* zc */
  modelica_metatype c2; /* sample */
} BackendDAEUtil_calculateNumberZeroCrossings_rettypeboxed;
DLLExport
BackendDAEUtil_calculateNumberZeroCrossings_rettypeboxed boxptr_BackendDAEUtil_calculateNumberZeroCrossings(threadData_t *threadData, modelica_metatype _zcLst, modelica_metatype _inZc_index, modelica_metatype _inSample_index);
typedef struct BackendDAEUtil_calculateParamSizes_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_calculateParamSizes_rettype;
DLLExport
BackendDAEUtil_calculateParamSizes_rettype omc_BackendDAEUtil_calculateParamSizes(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_calculateParamSizes omc_BackendDAEUtil_calculateParamSizes

typedef struct BackendDAEUtil_calculateVarSizes_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_calculateVarSizes_rettype;
DLLExport
BackendDAEUtil_calculateVarSizes_rettype omc_BackendDAEUtil_calculateVarSizes(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_calculateVarSizes omc_BackendDAEUtil_calculateVarSizes

typedef struct BackendDAEUtil_numberOfZeroCrossings_rettype_s {
  modelica_integer c1; /* outNumZeroCrossings */
  modelica_integer c2; /* outNumTimeEvents */
  modelica_integer c3; /* outNumRelations */
  modelica_integer c4; /* outNumMathEventFunctions */
} BackendDAEUtil_numberOfZeroCrossings_rettype;
DLLExport
BackendDAEUtil_numberOfZeroCrossings_rettype omc_BackendDAEUtil_numberOfZeroCrossings(threadData_t *threadData, modelica_metatype _inBackendDAE);
typedef struct BackendDAEUtil_numberOfZeroCrossings_rettypeboxed_s {
  modelica_metatype c1; /* outNumZeroCrossings */
  modelica_metatype c2; /* outNumTimeEvents */
  modelica_metatype c3; /* outNumRelations */
  modelica_metatype c4; /* outNumMathEventFunctions */
} BackendDAEUtil_numberOfZeroCrossings_rettypeboxed;
DLLExport
BackendDAEUtil_numberOfZeroCrossings_rettypeboxed boxptr_BackendDAEUtil_numberOfZeroCrossings(threadData_t *threadData, modelica_metatype _inBackendDAE);
typedef struct BackendDAEUtil_numberOfDiscreteVars_rettype_s {
  modelica_integer c1; /* outNumDiscreteReal */
} BackendDAEUtil_numberOfDiscreteVars_rettype;
DLLExport
BackendDAEUtil_numberOfDiscreteVars_rettype omc_BackendDAEUtil_numberOfDiscreteVars(threadData_t *threadData, modelica_metatype _inBackendDAE);
typedef struct BackendDAEUtil_numberOfDiscreteVars_rettypeboxed_s {
  modelica_metatype c1; /* outNumDiscreteReal */
} BackendDAEUtil_numberOfDiscreteVars_rettypeboxed;
DLLExport
BackendDAEUtil_numberOfDiscreteVars_rettypeboxed boxptr_BackendDAEUtil_numberOfDiscreteVars(threadData_t *threadData, modelica_metatype _inBackendDAE);
typedef struct BackendDAEUtil_countDiscreteVars_rettype_s {
  modelica_integer c1; /* outNumDiscreteVars */
} BackendDAEUtil_countDiscreteVars_rettype;
DLLExport
BackendDAEUtil_countDiscreteVars_rettype omc_BackendDAEUtil_countDiscreteVars(threadData_t *threadData, modelica_metatype _inDAE);
typedef struct BackendDAEUtil_countDiscreteVars_rettypeboxed_s {
  modelica_metatype c1; /* outNumDiscreteVars */
} BackendDAEUtil_countDiscreteVars_rettypeboxed;
DLLExport
BackendDAEUtil_countDiscreteVars_rettypeboxed boxptr_BackendDAEUtil_countDiscreteVars(threadData_t *threadData, modelica_metatype _inDAE);
typedef struct BackendDAEUtil_countDiscreteVars1_rettype_s {
  modelica_integer c1; /* outNumDiscreteVars */
} BackendDAEUtil_countDiscreteVars1_rettype;
DLLExport
BackendDAEUtil_countDiscreteVars1_rettype omc_BackendDAEUtil_countDiscreteVars1(threadData_t *threadData, modelica_metatype _inEqSystems);
typedef struct BackendDAEUtil_countDiscreteVars1_rettypeboxed_s {
  modelica_metatype c1; /* outNumDiscreteVars */
} BackendDAEUtil_countDiscreteVars1_rettypeboxed;
DLLExport
BackendDAEUtil_countDiscreteVars1_rettypeboxed boxptr_BackendDAEUtil_countDiscreteVars1(threadData_t *threadData, modelica_metatype _inEqSystems);
typedef struct BackendDAEUtil_countDiscreteVars2_rettype_s {
  modelica_integer c1; /* outNumDiscreteVars */
} BackendDAEUtil_countDiscreteVars2_rettype;
DLLExport
BackendDAEUtil_countDiscreteVars2_rettype omc_BackendDAEUtil_countDiscreteVars2(threadData_t *threadData, modelica_metatype _inEqSystem, modelica_integer _inNumDiscreteVars);
typedef struct BackendDAEUtil_countDiscreteVars2_rettypeboxed_s {
  modelica_metatype c1; /* outNumDiscreteVars */
} BackendDAEUtil_countDiscreteVars2_rettypeboxed;
DLLExport
BackendDAEUtil_countDiscreteVars2_rettypeboxed boxptr_BackendDAEUtil_countDiscreteVars2(threadData_t *threadData, modelica_metatype _inEqSystem, modelica_metatype _inNumDiscreteVars);
typedef struct BackendDAEUtil_countDiscreteVars3_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_countDiscreteVars3_rettype;
DLLExport
BackendDAEUtil_countDiscreteVars3_rettype omc_BackendDAEUtil_countDiscreteVars3(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_countDiscreteVars3 omc_BackendDAEUtil_countDiscreteVars3

typedef struct BackendDAEUtil_calculateValues_rettype_s {
  modelica_metatype c1; /* outBackendDAE */
} BackendDAEUtil_calculateValues_rettype;
DLLExport
BackendDAEUtil_calculateValues_rettype omc_BackendDAEUtil_calculateValues(threadData_t *threadData, modelica_metatype _inBackendDAE);
#define boxptr_BackendDAEUtil_calculateValues omc_BackendDAEUtil_calculateValues

typedef struct BackendDAEUtil_calculateValue_rettype_s {
  modelica_metatype c1; /* outVar */
} BackendDAEUtil_calculateValue_rettype;
DLLExport
BackendDAEUtil_calculateValue_rettype omc_BackendDAEUtil_calculateValue(threadData_t *threadData, modelica_metatype _inVar, modelica_metatype _cache, modelica_metatype _env, modelica_metatype _vars);
#define boxptr_BackendDAEUtil_calculateValue omc_BackendDAEUtil_calculateValue

typedef struct BackendDAEUtil_replaceCrefsWithValues_rettype_s {
  modelica_metatype c1; /* outTuple */
} BackendDAEUtil_replaceCrefsWithValues_rettype;
DLLExport
BackendDAEUtil_replaceCrefsWithValues_rettype omc_BackendDAEUtil_replaceCrefsWithValues(threadData_t *threadData, modelica_metatype _inTuple);
#define boxptr_BackendDAEUtil_replaceCrefsWithValues omc_BackendDAEUtil_replaceCrefsWithValues

typedef struct BackendDAEUtil_makeExpType_rettype_s {
  modelica_metatype c1; /* outType */
} BackendDAEUtil_makeExpType_rettype;
DLLExport
BackendDAEUtil_makeExpType_rettype omc_BackendDAEUtil_makeExpType(threadData_t *threadData, modelica_metatype _inType);
#define boxptr_BackendDAEUtil_makeExpType omc_BackendDAEUtil_makeExpType

typedef struct BackendDAEUtil_addAliasVariables_rettype_s {
  modelica_metatype c1; /* outAliasVariables */
} BackendDAEUtil_addAliasVariables_rettype;
DLLExport
BackendDAEUtil_addAliasVariables_rettype omc_BackendDAEUtil_addAliasVariables(threadData_t *threadData, modelica_metatype _inVars, modelica_metatype _inAliasVariables);
#define boxptr_BackendDAEUtil_addAliasVariables omc_BackendDAEUtil_addAliasVariables

typedef struct BackendDAEUtil_isDiscreteEquation_rettype_s {
  modelica_boolean c1; /* b */
} BackendDAEUtil_isDiscreteEquation_rettype;
DLLExport
BackendDAEUtil_isDiscreteEquation_rettype omc_BackendDAEUtil_isDiscreteEquation(threadData_t *threadData, modelica_metatype _eqn, modelica_metatype _vars, modelica_metatype _knvars);
typedef struct BackendDAEUtil_isDiscreteEquation_rettypeboxed_s {
  modelica_metatype c1; /* b */
} BackendDAEUtil_isDiscreteEquation_rettypeboxed;
DLLExport
BackendDAEUtil_isDiscreteEquation_rettypeboxed boxptr_BackendDAEUtil_isDiscreteEquation(threadData_t *threadData, modelica_metatype _eqn, modelica_metatype _vars, modelica_metatype _knvars);
typedef struct BackendDAEUtil_isDiscreteExp_rettype_s {
  modelica_boolean c1; /* outBoolean */
} BackendDAEUtil_isDiscreteExp_rettype;
DLLExport
BackendDAEUtil_isDiscreteExp_rettype omc_BackendDAEUtil_isDiscreteExp(threadData_t *threadData, modelica_metatype _inExp, modelica_metatype _inVariables, modelica_metatype _knvars);
typedef struct BackendDAEUtil_isDiscreteExp_rettypeboxed_s {
  modelica_metatype c1; /* outBoolean */
} BackendDAEUtil_isDiscreteExp_rettypeboxed;
DLLExport
BackendDAEUtil_isDiscreteExp_rettypeboxed boxptr_BackendDAEUtil_isDiscreteExp(threadData_t *threadData, modelica_metatype _inExp, modelica_metatype _inVariables, modelica_metatype _knvars);
typedef struct BackendDAEUtil_isDiscreteExp1_rettype_s {
  modelica_metatype c1; /* outExp */
} BackendDAEUtil_isDiscreteExp1_rettype;
DLLExport
BackendDAEUtil_isDiscreteExp1_rettype omc_BackendDAEUtil_isDiscreteExp1(threadData_t *threadData, modelica_metatype _inExp);
#define boxptr_BackendDAEUtil_isDiscreteExp1 omc_BackendDAEUtil_isDiscreteExp1

typedef struct BackendDAEUtil_traversingisDiscreteExpFinder_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_traversingisDiscreteExpFinder_rettype;
DLLExport
BackendDAEUtil_traversingisDiscreteExpFinder_rettype omc_BackendDAEUtil_traversingisDiscreteExpFinder(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_traversingisDiscreteExpFinder omc_BackendDAEUtil_traversingisDiscreteExpFinder

typedef struct BackendDAEUtil_isVarDiscrete_rettype_s {
  modelica_boolean c1; /* res */
} BackendDAEUtil_isVarDiscrete_rettype;
DLLExport
BackendDAEUtil_isVarDiscrete_rettype omc_BackendDAEUtil_isVarDiscrete(threadData_t *threadData, modelica_metatype _var);
typedef struct BackendDAEUtil_isVarDiscrete_rettypeboxed_s {
  modelica_metatype c1; /* res */
} BackendDAEUtil_isVarDiscrete_rettypeboxed;
DLLExport
BackendDAEUtil_isVarDiscrete_rettypeboxed boxptr_BackendDAEUtil_isVarDiscrete(threadData_t *threadData, modelica_metatype _var);
typedef struct BackendDAEUtil_isKindDiscrete_rettype_s {
  modelica_boolean c1; /* outBoolean */
} BackendDAEUtil_isKindDiscrete_rettype;
DLLExport
BackendDAEUtil_isKindDiscrete_rettype omc_BackendDAEUtil_isKindDiscrete(threadData_t *threadData, modelica_metatype _inVarKind);
typedef struct BackendDAEUtil_isKindDiscrete_rettypeboxed_s {
  modelica_metatype c1; /* outBoolean */
} BackendDAEUtil_isKindDiscrete_rettypeboxed;
DLLExport
BackendDAEUtil_isKindDiscrete_rettypeboxed boxptr_BackendDAEUtil_isKindDiscrete(threadData_t *threadData, modelica_metatype _inVarKind);
typedef struct BackendDAEUtil_statesAndVarsExp_rettype_s {
  modelica_metatype c1; /* exps */
} BackendDAEUtil_statesAndVarsExp_rettype;
DLLExport
BackendDAEUtil_statesAndVarsExp_rettype omc_BackendDAEUtil_statesAndVarsExp(threadData_t *threadData, modelica_metatype _inExp, modelica_metatype _inVariables);
#define boxptr_BackendDAEUtil_statesAndVarsExp omc_BackendDAEUtil_statesAndVarsExp

typedef struct BackendDAEUtil_traversingstatesAndVarsExpFinder_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_traversingstatesAndVarsExpFinder_rettype;
DLLExport
BackendDAEUtil_traversingstatesAndVarsExpFinder_rettype omc_BackendDAEUtil_traversingstatesAndVarsExpFinder(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_traversingstatesAndVarsExpFinder omc_BackendDAEUtil_traversingstatesAndVarsExpFinder

typedef struct BackendDAEUtil_isLoopDependent_rettype_s {
  modelica_boolean c1; /* isDependent */
} BackendDAEUtil_isLoopDependent_rettype;
DLLExport
BackendDAEUtil_isLoopDependent_rettype omc_BackendDAEUtil_isLoopDependent(threadData_t *threadData, modelica_metatype _varExp, modelica_metatype _iteratorExp);
typedef struct BackendDAEUtil_isLoopDependent_rettypeboxed_s {
  modelica_metatype c1; /* isDependent */
} BackendDAEUtil_isLoopDependent_rettypeboxed;
DLLExport
BackendDAEUtil_isLoopDependent_rettypeboxed boxptr_BackendDAEUtil_isLoopDependent(threadData_t *threadData, modelica_metatype _varExp, modelica_metatype _iteratorExp);
typedef struct BackendDAEUtil_isLoopDependentHelper_rettype_s {
  modelica_boolean c1; /* isDependent */
} BackendDAEUtil_isLoopDependentHelper_rettype;
DLLExport
BackendDAEUtil_isLoopDependentHelper_rettype omc_BackendDAEUtil_isLoopDependentHelper(threadData_t *threadData, modelica_metatype _subscripts, modelica_metatype _iteratorExp);
typedef struct BackendDAEUtil_isLoopDependentHelper_rettypeboxed_s {
  modelica_metatype c1; /* isDependent */
} BackendDAEUtil_isLoopDependentHelper_rettypeboxed;
DLLExport
BackendDAEUtil_isLoopDependentHelper_rettypeboxed boxptr_BackendDAEUtil_isLoopDependentHelper(threadData_t *threadData, modelica_metatype _subscripts, modelica_metatype _iteratorExp);
typedef struct BackendDAEUtil_devectorizeArrayVar_rettype_s {
  modelica_metatype c1; /* newArrayVar */
} BackendDAEUtil_devectorizeArrayVar_rettype;
DLLExport
BackendDAEUtil_devectorizeArrayVar_rettype omc_BackendDAEUtil_devectorizeArrayVar(threadData_t *threadData, modelica_metatype _arrayVar);
#define boxptr_BackendDAEUtil_devectorizeArrayVar omc_BackendDAEUtil_devectorizeArrayVar

typedef struct BackendDAEUtil_explodeArrayVars_rettype_s {
  modelica_metatype c1; /* arrayElements */
} BackendDAEUtil_explodeArrayVars_rettype;
DLLExport
BackendDAEUtil_explodeArrayVars_rettype omc_BackendDAEUtil_explodeArrayVars(threadData_t *threadData, modelica_metatype _arrayVar, modelica_metatype _iteratorExp, modelica_metatype _rangeExpr, modelica_metatype _vars);
#define boxptr_BackendDAEUtil_explodeArrayVars omc_BackendDAEUtil_explodeArrayVars

typedef struct BackendDAEUtil_rangeIntExprs_rettype_s {
  modelica_metatype c1; /* integers */
} BackendDAEUtil_rangeIntExprs_rettype;
DLLExport
BackendDAEUtil_rangeIntExprs_rettype omc_BackendDAEUtil_rangeIntExprs(threadData_t *threadData, modelica_metatype _range);
#define boxptr_BackendDAEUtil_rangeIntExprs omc_BackendDAEUtil_rangeIntExprs

typedef struct BackendDAEUtil_equationNth_rettype_s {
  modelica_metatype c1; /* outEquation */
} BackendDAEUtil_equationNth_rettype;
DLLExport
BackendDAEUtil_equationNth_rettype omc_BackendDAEUtil_equationNth(threadData_t *threadData, modelica_metatype _inEquationArray, modelica_integer _inInteger);
typedef struct BackendDAEUtil_equationNth_rettypeboxed_s {
  modelica_metatype c1; /* outEquation */
} BackendDAEUtil_equationNth_rettypeboxed;
DLLExport
BackendDAEUtil_equationNth_rettypeboxed boxptr_BackendDAEUtil_equationNth(threadData_t *threadData, modelica_metatype _inEquationArray, modelica_metatype _inInteger);
typedef struct BackendDAEUtil_daeSize_rettype_s {
  modelica_integer c1; /* size */
} BackendDAEUtil_daeSize_rettype;
DLLExport
BackendDAEUtil_daeSize_rettype omc_BackendDAEUtil_daeSize(threadData_t *threadData, modelica_metatype _dae);
typedef struct BackendDAEUtil_daeSize_rettypeboxed_s {
  modelica_metatype c1; /* size */
} BackendDAEUtil_daeSize_rettypeboxed;
DLLExport
BackendDAEUtil_daeSize_rettypeboxed boxptr_BackendDAEUtil_daeSize(threadData_t *threadData, modelica_metatype _dae);
typedef struct BackendDAEUtil_systemSize_rettype_s {
  modelica_integer c1; /* n */
} BackendDAEUtil_systemSize_rettype;
DLLExport
BackendDAEUtil_systemSize_rettype omc_BackendDAEUtil_systemSize(threadData_t *threadData, modelica_metatype _syst);
typedef struct BackendDAEUtil_systemSize_rettypeboxed_s {
  modelica_metatype c1; /* n */
} BackendDAEUtil_systemSize_rettypeboxed;
DLLExport
BackendDAEUtil_systemSize_rettypeboxed boxptr_BackendDAEUtil_systemSize(threadData_t *threadData, modelica_metatype _syst);
typedef struct BackendDAEUtil_equationSize_rettype_s {
  modelica_integer c1; /* outInteger */
} BackendDAEUtil_equationSize_rettype;
DLLExport
BackendDAEUtil_equationSize_rettype omc_BackendDAEUtil_equationSize(threadData_t *threadData, modelica_metatype _inEquationArray);
typedef struct BackendDAEUtil_equationSize_rettypeboxed_s {
  modelica_metatype c1; /* outInteger */
} BackendDAEUtil_equationSize_rettypeboxed;
DLLExport
BackendDAEUtil_equationSize_rettypeboxed boxptr_BackendDAEUtil_equationSize(threadData_t *threadData, modelica_metatype _inEquationArray);
typedef struct BackendDAEUtil_equationArraySizeDAE_rettype_s {
  modelica_integer c1; /* n */
} BackendDAEUtil_equationArraySizeDAE_rettype;
DLLExport
BackendDAEUtil_equationArraySizeDAE_rettype omc_BackendDAEUtil_equationArraySizeDAE(threadData_t *threadData, modelica_metatype _dae);
typedef struct BackendDAEUtil_equationArraySizeDAE_rettypeboxed_s {
  modelica_metatype c1; /* n */
} BackendDAEUtil_equationArraySizeDAE_rettypeboxed;
DLLExport
BackendDAEUtil_equationArraySizeDAE_rettypeboxed boxptr_BackendDAEUtil_equationArraySizeDAE(threadData_t *threadData, modelica_metatype _dae);
typedef struct BackendDAEUtil_equationArraySize_rettype_s {
  modelica_integer c1; /* outInteger */
} BackendDAEUtil_equationArraySize_rettype;
DLLExport
BackendDAEUtil_equationArraySize_rettype omc_BackendDAEUtil_equationArraySize(threadData_t *threadData, modelica_metatype _inEquationArray);
typedef struct BackendDAEUtil_equationArraySize_rettypeboxed_s {
  modelica_metatype c1; /* outInteger */
} BackendDAEUtil_equationArraySize_rettypeboxed;
DLLExport
BackendDAEUtil_equationArraySize_rettypeboxed boxptr_BackendDAEUtil_equationArraySize(threadData_t *threadData, modelica_metatype _inEquationArray);
typedef struct BackendDAEUtil_generateArrayElements_rettype_s {
  modelica_metatype c1; /* newElements */
} BackendDAEUtil_generateArrayElements_rettype;
DLLExport
BackendDAEUtil_generateArrayElements_rettype omc_BackendDAEUtil_generateArrayElements(threadData_t *threadData, modelica_metatype _clones, modelica_metatype _indices, modelica_metatype _iteratorExp);
#define boxptr_BackendDAEUtil_generateArrayElements omc_BackendDAEUtil_generateArrayElements

typedef struct BackendDAEUtil_simplifySubscripts_rettype_s {
  modelica_metatype c1; /* maybeCref */
} BackendDAEUtil_simplifySubscripts_rettype;
DLLExport
BackendDAEUtil_simplifySubscripts_rettype omc_BackendDAEUtil_simplifySubscripts(threadData_t *threadData, modelica_metatype _asub);
#define boxptr_BackendDAEUtil_simplifySubscripts omc_BackendDAEUtil_simplifySubscripts

typedef struct BackendDAEUtil_simplifySubscript_rettype_s {
  modelica_metatype c1; /* simplifiedSub */
} BackendDAEUtil_simplifySubscript_rettype;
DLLExport
BackendDAEUtil_simplifySubscript_rettype omc_BackendDAEUtil_simplifySubscript(threadData_t *threadData, modelica_metatype _sub);
#define boxptr_BackendDAEUtil_simplifySubscript omc_BackendDAEUtil_simplifySubscript

typedef struct BackendDAEUtil_generateStatePartition_rettype_s {
  modelica_metatype c1; /* outCompsStates */
  modelica_metatype c2; /* outCompsNoStates */
} BackendDAEUtil_generateStatePartition_rettype;
DLLExport
BackendDAEUtil_generateStatePartition_rettype omc_BackendDAEUtil_generateStatePartition(threadData_t *threadData, modelica_metatype _syst);
#define boxptr_BackendDAEUtil_generateStatePartition omc_BackendDAEUtil_generateStatePartition

typedef struct BackendDAEUtil_splitBlocks_rettype_s {
  modelica_metatype c1; /* outCompsStates */
  modelica_metatype c2; /* outCompsNoStates */
} BackendDAEUtil_splitBlocks_rettype;
DLLExport
BackendDAEUtil_splitBlocks_rettype omc_BackendDAEUtil_splitBlocks(threadData_t *threadData, modelica_metatype _inComps, modelica_metatype _inIntegerArray);
#define boxptr_BackendDAEUtil_splitBlocks omc_BackendDAEUtil_splitBlocks

typedef struct BackendDAEUtil_blockIsDynamic_rettype_s {
  modelica_boolean c1; /* outBoolean */
} BackendDAEUtil_blockIsDynamic_rettype;
DLLExport
BackendDAEUtil_blockIsDynamic_rettype omc_BackendDAEUtil_blockIsDynamic(threadData_t *threadData, modelica_metatype _inIntegerLst, modelica_metatype _inIntegerArray);
typedef struct BackendDAEUtil_blockIsDynamic_rettypeboxed_s {
  modelica_metatype c1; /* outBoolean */
} BackendDAEUtil_blockIsDynamic_rettypeboxed;
DLLExport
BackendDAEUtil_blockIsDynamic_rettypeboxed boxptr_BackendDAEUtil_blockIsDynamic(threadData_t *threadData, modelica_metatype _inIntegerLst, modelica_metatype _inIntegerArray);
typedef struct BackendDAEUtil_markStateEquations_rettype_s {
  modelica_metatype c1; /* outIntegerArray */
} BackendDAEUtil_markStateEquations_rettype;
DLLExport
BackendDAEUtil_markStateEquations_rettype omc_BackendDAEUtil_markStateEquations(threadData_t *threadData, modelica_metatype _syst, modelica_metatype _arr, modelica_metatype _ass1);
#define boxptr_BackendDAEUtil_markStateEquations omc_BackendDAEUtil_markStateEquations

typedef struct BackendDAEUtil_markStateEquationsWork_rettype_s {
  modelica_metatype c1; /* oMark */
} BackendDAEUtil_markStateEquationsWork_rettype;
DLLExport
BackendDAEUtil_markStateEquationsWork_rettype omc_BackendDAEUtil_markStateEquationsWork(threadData_t *threadData, modelica_metatype _inEqns, modelica_metatype _nextQueue, modelica_metatype _m, modelica_metatype _ass1, modelica_metatype _iMark);
#define boxptr_BackendDAEUtil_markStateEquationsWork omc_BackendDAEUtil_markStateEquationsWork

typedef struct BackendDAEUtil_consNotMarked_rettype_s {
  modelica_metatype c1; /* oQueue */
} BackendDAEUtil_consNotMarked_rettype;
DLLExport
BackendDAEUtil_consNotMarked_rettype omc_BackendDAEUtil_consNotMarked(threadData_t *threadData, modelica_integer _e, modelica_metatype _mark, modelica_metatype _iQueue);
typedef struct BackendDAEUtil_consNotMarked_rettypeboxed_s {
  modelica_metatype c1; /* oQueue */
} BackendDAEUtil_consNotMarked_rettypeboxed;
DLLExport
BackendDAEUtil_consNotMarked_rettypeboxed boxptr_BackendDAEUtil_consNotMarked(threadData_t *threadData, modelica_metatype _e, modelica_metatype _mark, modelica_metatype _iQueue);
typedef struct BackendDAEUtil_removeNegative_rettype_s {
  modelica_metatype c1; /* lst_1 */
} BackendDAEUtil_removeNegative_rettype;
DLLExport
BackendDAEUtil_removeNegative_rettype omc_BackendDAEUtil_removeNegative(threadData_t *threadData, modelica_metatype _lst);
#define boxptr_BackendDAEUtil_removeNegative omc_BackendDAEUtil_removeNegative

typedef struct BackendDAEUtil_eqnsForVarWithStates_rettype_s {
  modelica_metatype c1; /* outIntegerLst */
} BackendDAEUtil_eqnsForVarWithStates_rettype;
DLLExport
BackendDAEUtil_eqnsForVarWithStates_rettype omc_BackendDAEUtil_eqnsForVarWithStates(threadData_t *threadData, modelica_metatype _inIncidenceMatrixT, modelica_integer _inInteger);
typedef struct BackendDAEUtil_eqnsForVarWithStates_rettypeboxed_s {
  modelica_metatype c1; /* outIntegerLst */
} BackendDAEUtil_eqnsForVarWithStates_rettypeboxed;
DLLExport
BackendDAEUtil_eqnsForVarWithStates_rettypeboxed boxptr_BackendDAEUtil_eqnsForVarWithStates(threadData_t *threadData, modelica_metatype _inIncidenceMatrixT, modelica_metatype _inInteger);
typedef struct BackendDAEUtil_varsInEqn_rettype_s {
  modelica_metatype c1; /* outIntegerLst */
} BackendDAEUtil_varsInEqn_rettype;
DLLExport
BackendDAEUtil_varsInEqn_rettype omc_BackendDAEUtil_varsInEqn(threadData_t *threadData, modelica_metatype _m, modelica_integer _indx);
typedef struct BackendDAEUtil_varsInEqn_rettypeboxed_s {
  modelica_metatype c1; /* outIntegerLst */
} BackendDAEUtil_varsInEqn_rettypeboxed;
DLLExport
BackendDAEUtil_varsInEqn_rettypeboxed boxptr_BackendDAEUtil_varsInEqn(threadData_t *threadData, modelica_metatype _m, modelica_metatype _indx);
typedef struct BackendDAEUtil_varsInEqnEnhanced_rettype_s {
  modelica_metatype c1; /* outIntegerLst */
} BackendDAEUtil_varsInEqnEnhanced_rettype;
DLLExport
BackendDAEUtil_varsInEqnEnhanced_rettype omc_BackendDAEUtil_varsInEqnEnhanced(threadData_t *threadData, modelica_metatype _m, modelica_integer _indx);
typedef struct BackendDAEUtil_varsInEqnEnhanced_rettypeboxed_s {
  modelica_metatype c1; /* outIntegerLst */
} BackendDAEUtil_varsInEqnEnhanced_rettypeboxed;
DLLExport
BackendDAEUtil_varsInEqnEnhanced_rettypeboxed boxptr_BackendDAEUtil_varsInEqnEnhanced(threadData_t *threadData, modelica_metatype _m, modelica_metatype _indx);
typedef struct BackendDAEUtil_varsInEqnEnhanced1_rettype_s {
  modelica_metatype c1; /* oAcc */
} BackendDAEUtil_varsInEqnEnhanced1_rettype;
DLLExport
BackendDAEUtil_varsInEqnEnhanced1_rettype omc_BackendDAEUtil_varsInEqnEnhanced1(threadData_t *threadData, modelica_metatype _m, modelica_metatype _iAcc);
#define boxptr_BackendDAEUtil_varsInEqnEnhanced1 omc_BackendDAEUtil_varsInEqnEnhanced1

typedef struct BackendDAEUtil_subscript2dCombinations_rettype_s {
  modelica_metatype c1; /* outExpSubscriptLstLst */
} BackendDAEUtil_subscript2dCombinations_rettype;
DLLExport
BackendDAEUtil_subscript2dCombinations_rettype omc_BackendDAEUtil_subscript2dCombinations(threadData_t *threadData, modelica_metatype _inExpSubscriptLstLst1, modelica_metatype _inExpSubscriptLstLst2);
#define boxptr_BackendDAEUtil_subscript2dCombinations omc_BackendDAEUtil_subscript2dCombinations

typedef struct BackendDAEUtil_subscript2dCombinations2_rettype_s {
  modelica_metatype c1; /* outExpSubscriptLstLst */
} BackendDAEUtil_subscript2dCombinations2_rettype;
DLLExport
BackendDAEUtil_subscript2dCombinations2_rettype omc_BackendDAEUtil_subscript2dCombinations2(threadData_t *threadData, modelica_metatype _inExpSubscriptLst, modelica_metatype _inExpSubscriptLstLst);
#define boxptr_BackendDAEUtil_subscript2dCombinations2 omc_BackendDAEUtil_subscript2dCombinations2

typedef struct BackendDAEUtil_splitoutEquationAndVars_rettype_s {
  modelica_metatype c1; /* outEqns */
  modelica_metatype c2; /* outVars */
} BackendDAEUtil_splitoutEquationAndVars_rettype;
DLLExport
BackendDAEUtil_splitoutEquationAndVars_rettype omc_BackendDAEUtil_splitoutEquationAndVars(threadData_t *threadData, modelica_metatype _inNeededBlocks, modelica_metatype _inEqns, modelica_metatype _inVars, modelica_metatype _inEqnsNew, modelica_metatype _inVarsNew);
#define boxptr_BackendDAEUtil_splitoutEquationAndVars omc_BackendDAEUtil_splitoutEquationAndVars

typedef struct BackendDAEUtil_whenClauseAddDAE_rettype_s {
  modelica_metatype c1; /* oshared */
} BackendDAEUtil_whenClauseAddDAE_rettype;
DLLExport
BackendDAEUtil_whenClauseAddDAE_rettype omc_BackendDAEUtil_whenClauseAddDAE(threadData_t *threadData, modelica_metatype _inWcLst, modelica_metatype _shared);
#define boxptr_BackendDAEUtil_whenClauseAddDAE omc_BackendDAEUtil_whenClauseAddDAE

typedef struct BackendDAEUtil_getStrongComponents_rettype_s {
  modelica_metatype c1; /* outComps */
} BackendDAEUtil_getStrongComponents_rettype;
DLLExport
BackendDAEUtil_getStrongComponents_rettype omc_BackendDAEUtil_getStrongComponents(threadData_t *threadData, modelica_metatype _syst);
#define boxptr_BackendDAEUtil_getStrongComponents omc_BackendDAEUtil_getStrongComponents

typedef struct BackendDAEUtil_getFunctions_rettype_s {
  modelica_metatype c1; /* functionTree */
} BackendDAEUtil_getFunctions_rettype;
DLLExport
BackendDAEUtil_getFunctions_rettype omc_BackendDAEUtil_getFunctions(threadData_t *threadData, modelica_metatype _shared);
#define boxptr_BackendDAEUtil_getFunctions omc_BackendDAEUtil_getFunctions

typedef struct BackendDAEUtil_extendArrExp_rettype_s {
  modelica_metatype c1; /* otpl */
} BackendDAEUtil_extendArrExp_rettype;
DLLExport
BackendDAEUtil_extendArrExp_rettype omc_BackendDAEUtil_extendArrExp(threadData_t *threadData, modelica_metatype _itpl);
#define boxptr_BackendDAEUtil_extendArrExp omc_BackendDAEUtil_extendArrExp

typedef struct BackendDAEUtil_traversingextendArrExp_rettype_s {
  modelica_metatype c1; /* outExp */
} BackendDAEUtil_traversingextendArrExp_rettype;
DLLExport
BackendDAEUtil_traversingextendArrExp_rettype omc_BackendDAEUtil_traversingextendArrExp(threadData_t *threadData, modelica_metatype _inExp);
#define boxptr_BackendDAEUtil_traversingextendArrExp omc_BackendDAEUtil_traversingextendArrExp

typedef struct BackendDAEUtil_makeMatrix_rettype_s {
  modelica_metatype c1; /* scalar */
} BackendDAEUtil_makeMatrix_rettype;
DLLExport
BackendDAEUtil_makeMatrix_rettype omc_BackendDAEUtil_makeMatrix(threadData_t *threadData, modelica_metatype _expl, modelica_integer _r, modelica_integer _n, modelica_metatype _incol);
typedef struct BackendDAEUtil_makeMatrix_rettypeboxed_s {
  modelica_metatype c1; /* scalar */
} BackendDAEUtil_makeMatrix_rettypeboxed;
DLLExport
BackendDAEUtil_makeMatrix_rettypeboxed boxptr_BackendDAEUtil_makeMatrix(threadData_t *threadData, modelica_metatype _expl, modelica_metatype _r, modelica_metatype _n, modelica_metatype _incol);
typedef struct BackendDAEUtil_removediscreteAssingments_rettype_s {
  modelica_metatype c1; /* outStmts */
} BackendDAEUtil_removediscreteAssingments_rettype;
DLLExport
BackendDAEUtil_removediscreteAssingments_rettype omc_BackendDAEUtil_removediscreteAssingments(threadData_t *threadData, modelica_metatype _inStmts, modelica_metatype _inVars);
#define boxptr_BackendDAEUtil_removediscreteAssingments omc_BackendDAEUtil_removediscreteAssingments

typedef struct BackendDAEUtil_removediscreteAssingmentsElse_rettype_s {
  modelica_metatype c1; /* outElse */
} BackendDAEUtil_removediscreteAssingmentsElse_rettype;
DLLExport
BackendDAEUtil_removediscreteAssingmentsElse_rettype omc_BackendDAEUtil_removediscreteAssingmentsElse(threadData_t *threadData, modelica_metatype _inElse, modelica_metatype _inVars);
#define boxptr_BackendDAEUtil_removediscreteAssingmentsElse omc_BackendDAEUtil_removediscreteAssingmentsElse

typedef struct BackendDAEUtil_collateAlgorithm_rettype_s {
  modelica_metatype c1; /* outAlg */
} BackendDAEUtil_collateAlgorithm_rettype;
DLLExport
BackendDAEUtil_collateAlgorithm_rettype omc_BackendDAEUtil_collateAlgorithm(threadData_t *threadData, modelica_metatype _inAlg, modelica_metatype _infuncs);
#define boxptr_BackendDAEUtil_collateAlgorithm omc_BackendDAEUtil_collateAlgorithm

typedef struct BackendDAEUtil_collateArrExpStmt_rettype_s {
  modelica_metatype c1; /* otpl */
} BackendDAEUtil_collateArrExpStmt_rettype;
DLLExport
BackendDAEUtil_collateArrExpStmt_rettype omc_BackendDAEUtil_collateArrExpStmt(threadData_t *threadData, modelica_metatype _itpl);
#define boxptr_BackendDAEUtil_collateArrExpStmt omc_BackendDAEUtil_collateArrExpStmt

typedef struct BackendDAEUtil_traversingcollateArrExpStmt_rettype_s {
  modelica_metatype c1; /* outExp */
} BackendDAEUtil_traversingcollateArrExpStmt_rettype;
DLLExport
BackendDAEUtil_traversingcollateArrExpStmt_rettype omc_BackendDAEUtil_traversingcollateArrExpStmt(threadData_t *threadData, modelica_metatype _inExp);
#define boxptr_BackendDAEUtil_traversingcollateArrExpStmt omc_BackendDAEUtil_traversingcollateArrExpStmt

typedef struct BackendDAEUtil_collateArrExpList_rettype_s {
  modelica_metatype c1; /* outexpl */
} BackendDAEUtil_collateArrExpList_rettype;
DLLExport
BackendDAEUtil_collateArrExpList_rettype omc_BackendDAEUtil_collateArrExpList(threadData_t *threadData, modelica_metatype _iexpl, modelica_metatype _optfunc);
#define boxptr_BackendDAEUtil_collateArrExpList omc_BackendDAEUtil_collateArrExpList

typedef struct BackendDAEUtil_collateArrExp_rettype_s {
  modelica_metatype c1; /* otpl */
} BackendDAEUtil_collateArrExp_rettype;
DLLExport
BackendDAEUtil_collateArrExp_rettype omc_BackendDAEUtil_collateArrExp(threadData_t *threadData, modelica_metatype _itpl);
#define boxptr_BackendDAEUtil_collateArrExp omc_BackendDAEUtil_collateArrExp

typedef struct BackendDAEUtil_traversingcollateArrExp_rettype_s {
  modelica_metatype c1; /* outExp */
} BackendDAEUtil_traversingcollateArrExp_rettype;
DLLExport
BackendDAEUtil_traversingcollateArrExp_rettype omc_BackendDAEUtil_traversingcollateArrExp(threadData_t *threadData, modelica_metatype _inExp);
#define boxptr_BackendDAEUtil_traversingcollateArrExp omc_BackendDAEUtil_traversingcollateArrExp

typedef struct BackendDAEUtil_dimensionsToRange_rettype_s {
  modelica_metatype c1; /* outRangelist */
} BackendDAEUtil_dimensionsToRange_rettype;
DLLExport
BackendDAEUtil_dimensionsToRange_rettype omc_BackendDAEUtil_dimensionsToRange(threadData_t *threadData, modelica_metatype _idims);
#define boxptr_BackendDAEUtil_dimensionsToRange omc_BackendDAEUtil_dimensionsToRange

typedef struct BackendDAEUtil_rangesToSubscript_rettype_s {
  modelica_metatype c1; /* outSubs */
} BackendDAEUtil_rangesToSubscript_rettype;
DLLExport
BackendDAEUtil_rangesToSubscript_rettype omc_BackendDAEUtil_rangesToSubscript(threadData_t *threadData, modelica_metatype _inRange);
#define boxptr_BackendDAEUtil_rangesToSubscript omc_BackendDAEUtil_rangesToSubscript

typedef struct BackendDAEUtil_rangesToSubscripts_rettype_s {
  modelica_metatype c1; /* outSubslst */
} BackendDAEUtil_rangesToSubscripts_rettype;
DLLExport
BackendDAEUtil_rangesToSubscripts_rettype omc_BackendDAEUtil_rangesToSubscripts(threadData_t *threadData, modelica_metatype _inRangelist);
#define boxptr_BackendDAEUtil_rangesToSubscripts omc_BackendDAEUtil_rangesToSubscripts

typedef struct BackendDAEUtil_rangesToSubscripts1_rettype_s {
  modelica_metatype c1; /* outSubslst */
} BackendDAEUtil_rangesToSubscripts1_rettype;
DLLExport
BackendDAEUtil_rangesToSubscripts1_rettype omc_BackendDAEUtil_rangesToSubscripts1(threadData_t *threadData, modelica_metatype _inSub, modelica_metatype _inRangelist);
#define boxptr_BackendDAEUtil_rangesToSubscripts1 omc_BackendDAEUtil_rangesToSubscripts1

typedef struct BackendDAEUtil_getEquationBlock_rettype_s {
  modelica_metatype c1; /* outComp */
} BackendDAEUtil_getEquationBlock_rettype;
DLLExport
BackendDAEUtil_getEquationBlock_rettype omc_BackendDAEUtil_getEquationBlock(threadData_t *threadData, modelica_integer _inInteger, modelica_metatype _inComps);
typedef struct BackendDAEUtil_getEquationBlock_rettypeboxed_s {
  modelica_metatype c1; /* outComp */
} BackendDAEUtil_getEquationBlock_rettypeboxed;
DLLExport
BackendDAEUtil_getEquationBlock_rettypeboxed boxptr_BackendDAEUtil_getEquationBlock(threadData_t *threadData, modelica_metatype _inInteger, modelica_metatype _inComps);
typedef struct BackendDAEUtil_incidenceMatrix_rettype_s {
  modelica_metatype c1; /* outIncidenceMatrix */
  modelica_metatype c2; /* outIncidenceMatrixT */
} BackendDAEUtil_incidenceMatrix_rettype;
DLLExport
BackendDAEUtil_incidenceMatrix_rettype omc_BackendDAEUtil_incidenceMatrix(threadData_t *threadData, modelica_metatype _inEqSystem, modelica_metatype _inIndexType, modelica_metatype _functionTree);
#define boxptr_BackendDAEUtil_incidenceMatrix omc_BackendDAEUtil_incidenceMatrix

typedef struct BackendDAEUtil_incidenceMatrixScalar_rettype_s {
  modelica_metatype c1; /* outIncidenceMatrix */
  modelica_metatype c2; /* outIncidenceMatrixT */
  modelica_metatype c3; /* outMapEqnIncRow */
  modelica_metatype c4; /* outMapIncRowEqn */
} BackendDAEUtil_incidenceMatrixScalar_rettype;
DLLExport
BackendDAEUtil_incidenceMatrixScalar_rettype omc_BackendDAEUtil_incidenceMatrixScalar(threadData_t *threadData, modelica_metatype _syst, modelica_metatype _inIndexType, modelica_metatype _functionTree);
#define boxptr_BackendDAEUtil_incidenceMatrixScalar omc_BackendDAEUtil_incidenceMatrixScalar

typedef struct BackendDAEUtil_applyIndexType_rettype_s {
  modelica_metatype c1; /* outLst */
} BackendDAEUtil_applyIndexType_rettype;
DLLExport
BackendDAEUtil_applyIndexType_rettype omc_BackendDAEUtil_applyIndexType(threadData_t *threadData, modelica_metatype _inLst, modelica_metatype _inIndexType);
#define boxptr_BackendDAEUtil_applyIndexType omc_BackendDAEUtil_applyIndexType

typedef struct BackendDAEUtil_incidenceMatrixDispatch_rettype_s {
  modelica_metatype c1; /* outIncidenceArray */
  modelica_metatype c2; /* outIncidenceArrayT */
} BackendDAEUtil_incidenceMatrixDispatch_rettype;
DLLExport
BackendDAEUtil_incidenceMatrixDispatch_rettype omc_BackendDAEUtil_incidenceMatrixDispatch(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _inEqsArr, modelica_metatype _inIncidenceArray, modelica_metatype _inIncidenceArrayT, modelica_integer _index, modelica_integer _numberOfEqs, modelica_boolean _stop, modelica_metatype _inIndexType, modelica_metatype _functionTree);
typedef struct BackendDAEUtil_incidenceMatrixDispatch_rettypeboxed_s {
  modelica_metatype c1; /* outIncidenceArray */
  modelica_metatype c2; /* outIncidenceArrayT */
} BackendDAEUtil_incidenceMatrixDispatch_rettypeboxed;
DLLExport
BackendDAEUtil_incidenceMatrixDispatch_rettypeboxed boxptr_BackendDAEUtil_incidenceMatrixDispatch(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _inEqsArr, modelica_metatype _inIncidenceArray, modelica_metatype _inIncidenceArrayT, modelica_metatype _index, modelica_metatype _numberOfEqs, modelica_metatype _stop, modelica_metatype _inIndexType, modelica_metatype _functionTree);
typedef struct BackendDAEUtil_incidenceMatrixDispatchScalar_rettype_s {
  modelica_metatype c1; /* outIncidenceArray */
  modelica_metatype c2; /* outIncidenceArrayT */
  modelica_metatype c3; /* omapEqnIncRow */
  modelica_metatype c4; /* omapIncRowEqn */
} BackendDAEUtil_incidenceMatrixDispatchScalar_rettype;
DLLExport
BackendDAEUtil_incidenceMatrixDispatchScalar_rettype omc_BackendDAEUtil_incidenceMatrixDispatchScalar(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _inEqsArr, modelica_metatype _inIncidenceArray, modelica_metatype _inIncidenceArrayT, modelica_integer _index, modelica_integer _numberOfEqs, modelica_boolean _stop, modelica_metatype _inIndexType, modelica_metatype _functionTree, modelica_integer _inRowSize, modelica_metatype _imapEqnIncRow, modelica_metatype _imapIncRowEqn);
typedef struct BackendDAEUtil_incidenceMatrixDispatchScalar_rettypeboxed_s {
  modelica_metatype c1; /* outIncidenceArray */
  modelica_metatype c2; /* outIncidenceArrayT */
  modelica_metatype c3; /* omapEqnIncRow */
  modelica_metatype c4; /* omapIncRowEqn */
} BackendDAEUtil_incidenceMatrixDispatchScalar_rettypeboxed;
DLLExport
BackendDAEUtil_incidenceMatrixDispatchScalar_rettypeboxed boxptr_BackendDAEUtil_incidenceMatrixDispatchScalar(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _inEqsArr, modelica_metatype _inIncidenceArray, modelica_metatype _inIncidenceArrayT, modelica_metatype _index, modelica_metatype _numberOfEqs, modelica_metatype _stop, modelica_metatype _inIndexType, modelica_metatype _functionTree, modelica_metatype _inRowSize, modelica_metatype _imapEqnIncRow, modelica_metatype _imapIncRowEqn);
typedef struct BackendDAEUtil_fillincidenceMatrixT_rettype_s {
  modelica_metatype c1; /* outIncidenceArrayT */
} BackendDAEUtil_fillincidenceMatrixT_rettype;
DLLExport
BackendDAEUtil_fillincidenceMatrixT_rettype omc_BackendDAEUtil_fillincidenceMatrixT(threadData_t *threadData, modelica_metatype _eqns, modelica_metatype _eqnsindxs, modelica_metatype _inIncidenceArrayT);
#define boxptr_BackendDAEUtil_fillincidenceMatrixT omc_BackendDAEUtil_fillincidenceMatrixT

typedef struct BackendDAEUtil_incidenceRow_rettype_s {
  modelica_metatype c1; /* outIntegerLst */
  modelica_integer c2; /* rowSize */
} BackendDAEUtil_incidenceRow_rettype;
DLLExport
BackendDAEUtil_incidenceRow_rettype omc_BackendDAEUtil_incidenceRow(threadData_t *threadData, modelica_metatype _inEquation, modelica_metatype _vars, modelica_metatype _inIndexType, modelica_metatype _functionTree, modelica_metatype _iRow);
typedef struct BackendDAEUtil_incidenceRow_rettypeboxed_s {
  modelica_metatype c1; /* outIntegerLst */
  modelica_metatype c2; /* rowSize */
} BackendDAEUtil_incidenceRow_rettypeboxed;
DLLExport
BackendDAEUtil_incidenceRow_rettypeboxed boxptr_BackendDAEUtil_incidenceRow(threadData_t *threadData, modelica_metatype _inEquation, modelica_metatype _vars, modelica_metatype _inIndexType, modelica_metatype _functionTree, modelica_metatype _iRow);
typedef struct BackendDAEUtil_incidenceRowLst_rettype_s {
  modelica_metatype c1; /* outIntegerLst */
  modelica_integer c2; /* rowSize */
} BackendDAEUtil_incidenceRowLst_rettype;
DLLExport
BackendDAEUtil_incidenceRowLst_rettype omc_BackendDAEUtil_incidenceRowLst(threadData_t *threadData, modelica_metatype _inEquation, modelica_metatype _inVariables, modelica_metatype _inIndexType, modelica_metatype _functionTree, modelica_metatype _inIntegerLst, modelica_integer _inRowSize);
typedef struct BackendDAEUtil_incidenceRowLst_rettypeboxed_s {
  modelica_metatype c1; /* outIntegerLst */
  modelica_metatype c2; /* rowSize */
} BackendDAEUtil_incidenceRowLst_rettypeboxed;
DLLExport
BackendDAEUtil_incidenceRowLst_rettypeboxed boxptr_BackendDAEUtil_incidenceRowLst(threadData_t *threadData, modelica_metatype _inEquation, modelica_metatype _inVariables, modelica_metatype _inIndexType, modelica_metatype _functionTree, modelica_metatype _inIntegerLst, modelica_metatype _inRowSize);
typedef struct BackendDAEUtil_incidenceRowLstLst_rettype_s {
  modelica_metatype c1; /* outIntegerLst */
  modelica_integer c2; /* rowSize */
} BackendDAEUtil_incidenceRowLstLst_rettype;
DLLExport
BackendDAEUtil_incidenceRowLstLst_rettype omc_BackendDAEUtil_incidenceRowLstLst(threadData_t *threadData, modelica_metatype _inEquation, modelica_metatype _inVariables, modelica_metatype _inIndexType, modelica_metatype _functionTree, modelica_metatype _inIntegerLst, modelica_integer _inRowSize);
typedef struct BackendDAEUtil_incidenceRowLstLst_rettypeboxed_s {
  modelica_metatype c1; /* outIntegerLst */
  modelica_metatype c2; /* rowSize */
} BackendDAEUtil_incidenceRowLstLst_rettypeboxed;
DLLExport
BackendDAEUtil_incidenceRowLstLst_rettypeboxed boxptr_BackendDAEUtil_incidenceRowLstLst(threadData_t *threadData, modelica_metatype _inEquation, modelica_metatype _inVariables, modelica_metatype _inIndexType, modelica_metatype _functionTree, modelica_metatype _inIntegerLst, modelica_metatype _inRowSize);
typedef struct BackendDAEUtil_incidenceRowWhen_rettype_s {
  modelica_metatype c1; /* outIntegerLst */
} BackendDAEUtil_incidenceRowWhen_rettype;
DLLExport
BackendDAEUtil_incidenceRowWhen_rettype omc_BackendDAEUtil_incidenceRowWhen(threadData_t *threadData, modelica_metatype _inVariables, modelica_metatype _inEquation, modelica_metatype _inIndexType, modelica_metatype _functionTree, modelica_metatype _inRow);
#define boxptr_BackendDAEUtil_incidenceRowWhen omc_BackendDAEUtil_incidenceRowWhen

typedef struct BackendDAEUtil_incidenceRowAlgorithm_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_incidenceRowAlgorithm_rettype;
DLLExport
BackendDAEUtil_incidenceRowAlgorithm_rettype omc_BackendDAEUtil_incidenceRowAlgorithm(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_incidenceRowAlgorithm omc_BackendDAEUtil_incidenceRowAlgorithm

typedef struct BackendDAEUtil_incidenceRow1_rettype_s {
  modelica_metatype c1; /* outArg1 */
} BackendDAEUtil_incidenceRow1_rettype;
DLLExport
BackendDAEUtil_incidenceRow1_rettype omc_BackendDAEUtil_incidenceRow1(threadData_t *threadData, modelica_metatype _inList, modelica_fnptr inFunc, modelica_metatype _inArg, modelica_metatype _inArg1, modelica_metatype _inArg2, modelica_metatype _inArg3);
#define boxptr_BackendDAEUtil_incidenceRow1 omc_BackendDAEUtil_incidenceRow1

typedef struct BackendDAEUtil_incidenceRowExp_rettype_s {
  modelica_metatype c1; /* outIntegerLst */
} BackendDAEUtil_incidenceRowExp_rettype;
DLLExport
BackendDAEUtil_incidenceRowExp_rettype omc_BackendDAEUtil_incidenceRowExp(threadData_t *threadData, modelica_metatype _inExp, modelica_metatype _inVariables, modelica_metatype _inIntegerLst, modelica_metatype _functionTree, modelica_metatype _inIndexType);
#define boxptr_BackendDAEUtil_incidenceRowExp omc_BackendDAEUtil_incidenceRowExp

typedef struct BackendDAEUtil_traversingincidenceRowExpSolvableFinder_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_traversingincidenceRowExpSolvableFinder_rettype;
DLLExport
BackendDAEUtil_traversingincidenceRowExpSolvableFinder_rettype omc_BackendDAEUtil_traversingincidenceRowExpSolvableFinder(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_traversingincidenceRowExpSolvableFinder omc_BackendDAEUtil_traversingincidenceRowExpSolvableFinder

typedef struct BackendDAEUtil_traversingincidenceRowExpFinder_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_traversingincidenceRowExpFinder_rettype;
DLLExport
BackendDAEUtil_traversingincidenceRowExpFinder_rettype omc_BackendDAEUtil_traversingincidenceRowExpFinder(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_traversingincidenceRowExpFinder omc_BackendDAEUtil_traversingincidenceRowExpFinder

typedef struct BackendDAEUtil_incidenceRowExp1_rettype_s {
  modelica_metatype c1; /* outVarIndxLst */
} BackendDAEUtil_incidenceRowExp1_rettype;
DLLExport
BackendDAEUtil_incidenceRowExp1_rettype omc_BackendDAEUtil_incidenceRowExp1(threadData_t *threadData, modelica_metatype _inVarLst, modelica_metatype _inIntegerLst, modelica_metatype _inVarIndxLst, modelica_integer _diffindex);
typedef struct BackendDAEUtil_incidenceRowExp1_rettypeboxed_s {
  modelica_metatype c1; /* outVarIndxLst */
} BackendDAEUtil_incidenceRowExp1_rettypeboxed;
DLLExport
BackendDAEUtil_incidenceRowExp1_rettypeboxed boxptr_BackendDAEUtil_incidenceRowExp1(threadData_t *threadData, modelica_metatype _inVarLst, modelica_metatype _inIntegerLst, modelica_metatype _inVarIndxLst, modelica_metatype _diffindex);
typedef struct BackendDAEUtil_traversingincidenceRowExpFinderwithInput_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_traversingincidenceRowExpFinderwithInput_rettype;
DLLExport
BackendDAEUtil_traversingincidenceRowExpFinderwithInput_rettype omc_BackendDAEUtil_traversingincidenceRowExpFinderwithInput(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_traversingincidenceRowExpFinderwithInput omc_BackendDAEUtil_traversingincidenceRowExpFinderwithInput

typedef struct BackendDAEUtil_incidenceRowExp1withInput_rettype_s {
  modelica_metatype c1; /* outIntegerLst */
} BackendDAEUtil_incidenceRowExp1withInput_rettype;
DLLExport
BackendDAEUtil_incidenceRowExp1withInput_rettype omc_BackendDAEUtil_incidenceRowExp1withInput(threadData_t *threadData, modelica_metatype _inVarLst, modelica_metatype _inIntegerLst, modelica_metatype _vars, modelica_integer _diffindex);
typedef struct BackendDAEUtil_incidenceRowExp1withInput_rettypeboxed_s {
  modelica_metatype c1; /* outIntegerLst */
} BackendDAEUtil_incidenceRowExp1withInput_rettypeboxed;
DLLExport
BackendDAEUtil_incidenceRowExp1withInput_rettypeboxed boxptr_BackendDAEUtil_incidenceRowExp1withInput(threadData_t *threadData, modelica_metatype _inVarLst, modelica_metatype _inIntegerLst, modelica_metatype _vars, modelica_metatype _diffindex);
typedef struct BackendDAEUtil_transposeMatrix_rettype_s {
  modelica_metatype c1; /* mt */
} BackendDAEUtil_transposeMatrix_rettype;
DLLExport
BackendDAEUtil_transposeMatrix_rettype omc_BackendDAEUtil_transposeMatrix(threadData_t *threadData, modelica_metatype _m, modelica_integer _nRowsMt);
typedef struct BackendDAEUtil_transposeMatrix_rettypeboxed_s {
  modelica_metatype c1; /* mt */
} BackendDAEUtil_transposeMatrix_rettypeboxed;
DLLExport
BackendDAEUtil_transposeMatrix_rettypeboxed boxptr_BackendDAEUtil_transposeMatrix(threadData_t *threadData, modelica_metatype _m, modelica_metatype _nRowsMt);
typedef struct BackendDAEUtil_transposeRow_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_transposeRow_rettype;
DLLExport
BackendDAEUtil_transposeRow_rettype omc_BackendDAEUtil_transposeRow(threadData_t *threadData, modelica_metatype _row, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_transposeRow omc_BackendDAEUtil_transposeRow

typedef struct BackendDAEUtil_absIncidenceMatrix_rettype_s {
  modelica_metatype c1; /* res */
} BackendDAEUtil_absIncidenceMatrix_rettype;
DLLExport
BackendDAEUtil_absIncidenceMatrix_rettype omc_BackendDAEUtil_absIncidenceMatrix(threadData_t *threadData, modelica_metatype _m);
#define boxptr_BackendDAEUtil_absIncidenceMatrix omc_BackendDAEUtil_absIncidenceMatrix

typedef struct BackendDAEUtil_varsIncidenceMatrix_rettype_s {
  modelica_metatype c1; /* res */
} BackendDAEUtil_varsIncidenceMatrix_rettype;
DLLExport
BackendDAEUtil_varsIncidenceMatrix_rettype omc_BackendDAEUtil_varsIncidenceMatrix(threadData_t *threadData, modelica_metatype _m);
#define boxptr_BackendDAEUtil_varsIncidenceMatrix omc_BackendDAEUtil_varsIncidenceMatrix

typedef struct BackendDAEUtil_updateIncidenceMatrix_rettype_s {
  modelica_metatype c1; /* osyst */
} BackendDAEUtil_updateIncidenceMatrix_rettype;
DLLExport
BackendDAEUtil_updateIncidenceMatrix_rettype omc_BackendDAEUtil_updateIncidenceMatrix(threadData_t *threadData, modelica_metatype _syst, modelica_metatype _inIndxType, modelica_metatype _functionTree, modelica_metatype _inIntegerLst);
#define boxptr_BackendDAEUtil_updateIncidenceMatrix omc_BackendDAEUtil_updateIncidenceMatrix

typedef struct BackendDAEUtil_updateIncidenceMatrix1_rettype_s {
  modelica_metatype c1; /* outIncidenceMatrix */
  modelica_metatype c2; /* outIncidenceMatrixT */
} BackendDAEUtil_updateIncidenceMatrix1_rettype;
DLLExport
BackendDAEUtil_updateIncidenceMatrix1_rettype omc_BackendDAEUtil_updateIncidenceMatrix1(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _daeeqns, modelica_metatype _inIndxType, modelica_metatype _functionTree, modelica_metatype _m, modelica_metatype _mt, modelica_metatype _inIntegerLst);
#define boxptr_BackendDAEUtil_updateIncidenceMatrix1 omc_BackendDAEUtil_updateIncidenceMatrix1

typedef struct BackendDAEUtil_updateIncidenceMatrixScalar_rettype_s {
  modelica_metatype c1; /* osyst */
  modelica_metatype c2; /* oMapEqnIncRow */
  modelica_metatype c3; /* oMapIncRowEqn */
} BackendDAEUtil_updateIncidenceMatrixScalar_rettype;
DLLExport
BackendDAEUtil_updateIncidenceMatrixScalar_rettype omc_BackendDAEUtil_updateIncidenceMatrixScalar(threadData_t *threadData, modelica_metatype _syst, modelica_metatype _inIndxType, modelica_metatype _functionTree, modelica_metatype _inIntegerLst, modelica_metatype _iMapEqnIncRow, modelica_metatype _iMapIncRowEqn);
#define boxptr_BackendDAEUtil_updateIncidenceMatrixScalar omc_BackendDAEUtil_updateIncidenceMatrixScalar

typedef struct BackendDAEUtil_updateIncidenceMatrixScalar1_rettype_s {
  modelica_metatype c1; /* outIncidenceMatrix */
  modelica_metatype c2; /* outIncidenceMatrixT */
  modelica_metatype c3; /* oMapEqnIncRow */
  modelica_metatype c4; /* oMapIncRowEqn */
} BackendDAEUtil_updateIncidenceMatrixScalar1_rettype;
DLLExport
BackendDAEUtil_updateIncidenceMatrixScalar1_rettype omc_BackendDAEUtil_updateIncidenceMatrixScalar1(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _daeeqns, modelica_metatype _m, modelica_metatype _mt, modelica_metatype _inIntegerLst, modelica_metatype _iMapEqnIncRow, modelica_metatype _iMapIncRowEqn, modelica_metatype _inIndxType, modelica_metatype _functionTree);
#define boxptr_BackendDAEUtil_updateIncidenceMatrixScalar1 omc_BackendDAEUtil_updateIncidenceMatrixScalar1

typedef struct BackendDAEUtil_updateIncidenceMatrixScalar2_rettype_s {
  modelica_metatype c1; /* outIncidenceMatrix */
  modelica_metatype c2; /* outIncidenceMatrixT */
  modelica_metatype c3; /* oMapEqnIncRow */
  modelica_metatype c4; /* oMapIncRowEqn */
} BackendDAEUtil_updateIncidenceMatrixScalar2_rettype;
DLLExport
BackendDAEUtil_updateIncidenceMatrixScalar2_rettype omc_BackendDAEUtil_updateIncidenceMatrixScalar2(threadData_t *threadData, modelica_integer _index, modelica_integer _n, modelica_integer _size, modelica_metatype _vars, modelica_metatype _daeeqns, modelica_metatype _m, modelica_metatype _mt, modelica_metatype _iMapEqnIncRow, modelica_metatype _iMapIncRowEqn, modelica_metatype _inIndxType, modelica_metatype _functionTree);
typedef struct BackendDAEUtil_updateIncidenceMatrixScalar2_rettypeboxed_s {
  modelica_metatype c1; /* outIncidenceMatrix */
  modelica_metatype c2; /* outIncidenceMatrixT */
  modelica_metatype c3; /* oMapEqnIncRow */
  modelica_metatype c4; /* oMapIncRowEqn */
} BackendDAEUtil_updateIncidenceMatrixScalar2_rettypeboxed;
DLLExport
BackendDAEUtil_updateIncidenceMatrixScalar2_rettypeboxed boxptr_BackendDAEUtil_updateIncidenceMatrixScalar2(threadData_t *threadData, modelica_metatype _index, modelica_metatype _n, modelica_metatype _size, modelica_metatype _vars, modelica_metatype _daeeqns, modelica_metatype _m, modelica_metatype _mt, modelica_metatype _iMapEqnIncRow, modelica_metatype _iMapIncRowEqn, modelica_metatype _inIndxType, modelica_metatype _functionTree);
typedef struct BackendDAEUtil_getOldVars_rettype_s {
  modelica_metatype c1; /* oldvars */
} BackendDAEUtil_getOldVars_rettype;
DLLExport
BackendDAEUtil_getOldVars_rettype omc_BackendDAEUtil_getOldVars(threadData_t *threadData, modelica_metatype _m, modelica_integer _pos);
typedef struct BackendDAEUtil_getOldVars_rettypeboxed_s {
  modelica_metatype c1; /* oldvars */
} BackendDAEUtil_getOldVars_rettypeboxed;
DLLExport
BackendDAEUtil_getOldVars_rettypeboxed boxptr_BackendDAEUtil_getOldVars(threadData_t *threadData, modelica_metatype _m, modelica_metatype _pos);
typedef struct BackendDAEUtil_removeValuefromMatrix_rettype_s {
  modelica_metatype c1; /* outIncidenceMatrixT */
} BackendDAEUtil_removeValuefromMatrix_rettype;
DLLExport
BackendDAEUtil_removeValuefromMatrix_rettype omc_BackendDAEUtil_removeValuefromMatrix(threadData_t *threadData, modelica_integer _inValue, modelica_metatype _inIntegerLst, modelica_metatype _inIncidenceMatrixT);
typedef struct BackendDAEUtil_removeValuefromMatrix_rettypeboxed_s {
  modelica_metatype c1; /* outIncidenceMatrixT */
} BackendDAEUtil_removeValuefromMatrix_rettypeboxed;
DLLExport
BackendDAEUtil_removeValuefromMatrix_rettypeboxed boxptr_BackendDAEUtil_removeValuefromMatrix(threadData_t *threadData, modelica_metatype _inValue, modelica_metatype _inIntegerLst, modelica_metatype _inIncidenceMatrixT);
typedef struct BackendDAEUtil_addValuetoMatrix_rettype_s {
  modelica_metatype c1; /* outIncidenceMatrixT */
} BackendDAEUtil_addValuetoMatrix_rettype;
DLLExport
BackendDAEUtil_addValuetoMatrix_rettype omc_BackendDAEUtil_addValuetoMatrix(threadData_t *threadData, modelica_integer _inValue, modelica_metatype _inIntegerLst, modelica_metatype _inIncidenceMatrixT);
typedef struct BackendDAEUtil_addValuetoMatrix_rettypeboxed_s {
  modelica_metatype c1; /* outIncidenceMatrixT */
} BackendDAEUtil_addValuetoMatrix_rettypeboxed;
DLLExport
BackendDAEUtil_addValuetoMatrix_rettypeboxed boxptr_BackendDAEUtil_addValuetoMatrix(threadData_t *threadData, modelica_metatype _inValue, modelica_metatype _inIntegerLst, modelica_metatype _inIncidenceMatrixT);
typedef struct BackendDAEUtil_copyIncidenceMatrix_rettype_s {
  modelica_metatype c1; /* outM */
} BackendDAEUtil_copyIncidenceMatrix_rettype;
DLLExport
BackendDAEUtil_copyIncidenceMatrix_rettype omc_BackendDAEUtil_copyIncidenceMatrix(threadData_t *threadData, modelica_metatype _inM);
#define boxptr_BackendDAEUtil_copyIncidenceMatrix omc_BackendDAEUtil_copyIncidenceMatrix

typedef struct BackendDAEUtil_getIncidenceMatrixfromOptionForMapEqSystem_rettype_s {
  modelica_metatype c1; /* osyst */
  modelica_metatype c2; /* oshared */
} BackendDAEUtil_getIncidenceMatrixfromOptionForMapEqSystem_rettype;
DLLExport
BackendDAEUtil_getIncidenceMatrixfromOptionForMapEqSystem_rettype omc_BackendDAEUtil_getIncidenceMatrixfromOptionForMapEqSystem(threadData_t *threadData, modelica_metatype _syst, modelica_metatype _inIndxType, modelica_metatype _shared);
#define boxptr_BackendDAEUtil_getIncidenceMatrixfromOptionForMapEqSystem omc_BackendDAEUtil_getIncidenceMatrixfromOptionForMapEqSystem

typedef struct BackendDAEUtil_getIncidenceMatrixfromOption_rettype_s {
  modelica_metatype c1; /* osyst */
  modelica_metatype c2; /* outM */
  modelica_metatype c3; /* outMT */
} BackendDAEUtil_getIncidenceMatrixfromOption_rettype;
DLLExport
BackendDAEUtil_getIncidenceMatrixfromOption_rettype omc_BackendDAEUtil_getIncidenceMatrixfromOption(threadData_t *threadData, modelica_metatype _syst, modelica_metatype _inIndxType, modelica_metatype _functionTree);
#define boxptr_BackendDAEUtil_getIncidenceMatrixfromOption omc_BackendDAEUtil_getIncidenceMatrixfromOption

typedef struct BackendDAEUtil_getIncidenceMatrix_rettype_s {
  modelica_metatype c1; /* outEqSystem */
  modelica_metatype c2; /* outM */
  modelica_metatype c3; /* outMT */
} BackendDAEUtil_getIncidenceMatrix_rettype;
DLLExport
BackendDAEUtil_getIncidenceMatrix_rettype omc_BackendDAEUtil_getIncidenceMatrix(threadData_t *threadData, modelica_metatype _inEqSystem, modelica_metatype _inIndxType, modelica_metatype _functionTree);
#define boxptr_BackendDAEUtil_getIncidenceMatrix omc_BackendDAEUtil_getIncidenceMatrix

typedef struct BackendDAEUtil_getIncidenceMatrixScalar_rettype_s {
  modelica_metatype c1; /* osyst */
  modelica_metatype c2; /* outM */
  modelica_metatype c3; /* outMT */
  modelica_metatype c4; /* outMapEqnIncRow */
  modelica_metatype c5; /* outMapIncRowEqn */
} BackendDAEUtil_getIncidenceMatrixScalar_rettype;
DLLExport
BackendDAEUtil_getIncidenceMatrixScalar_rettype omc_BackendDAEUtil_getIncidenceMatrixScalar(threadData_t *threadData, modelica_metatype _syst, modelica_metatype _inIndxType, modelica_metatype _functionTree);
#define boxptr_BackendDAEUtil_getIncidenceMatrixScalar omc_BackendDAEUtil_getIncidenceMatrixScalar

typedef struct BackendDAEUtil_traverseStmts_rettype_s {
  modelica_metatype c1; /* oextraArg */
} BackendDAEUtil_traverseStmts_rettype;
DLLExport
BackendDAEUtil_traverseStmts_rettype omc_BackendDAEUtil_traverseStmts(threadData_t *threadData, modelica_metatype _inStmts, modelica_fnptr func, modelica_metatype _iextraArg);
#define boxptr_BackendDAEUtil_traverseStmts omc_BackendDAEUtil_traverseStmts

typedef struct BackendDAEUtil_traverseStmtsElse_rettype_s {
  modelica_metatype c1; /* oextraArg */
} BackendDAEUtil_traverseStmtsElse_rettype;
DLLExport
BackendDAEUtil_traverseStmtsElse_rettype omc_BackendDAEUtil_traverseStmtsElse(threadData_t *threadData, modelica_metatype _inElse, modelica_fnptr func, modelica_metatype _iextraArg);
#define boxptr_BackendDAEUtil_traverseStmtsElse omc_BackendDAEUtil_traverseStmtsElse

typedef struct BackendDAEUtil_getAdjacencyMatrixEnhancedScalar_rettype_s {
  modelica_metatype c1; /* outIncidenceMatrix */
  modelica_metatype c2; /* outIncidenceMatrixT */
  modelica_metatype c3; /* outMapEqnIncRow */
  modelica_metatype c4; /* outMapIncRowEqn */
} BackendDAEUtil_getAdjacencyMatrixEnhancedScalar_rettype;
DLLExport
BackendDAEUtil_getAdjacencyMatrixEnhancedScalar_rettype omc_BackendDAEUtil_getAdjacencyMatrixEnhancedScalar(threadData_t *threadData, modelica_metatype _syst, modelica_metatype _shared);
#define boxptr_BackendDAEUtil_getAdjacencyMatrixEnhancedScalar omc_BackendDAEUtil_getAdjacencyMatrixEnhancedScalar

typedef struct BackendDAEUtil_adjacencyMatrixDispatchEnhancedScalar_rettype_s {
  modelica_metatype c1; /* outIncidenceArray */
  modelica_metatype c2; /* outIncidenceArrayT */
  modelica_metatype c3; /* omapEqnIncRow */
  modelica_metatype c4; /* omapIncRowEqn */
} BackendDAEUtil_adjacencyMatrixDispatchEnhancedScalar_rettype;
DLLExport
BackendDAEUtil_adjacencyMatrixDispatchEnhancedScalar_rettype omc_BackendDAEUtil_adjacencyMatrixDispatchEnhancedScalar(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _eqArr, modelica_metatype _inIncidenceArray, modelica_metatype _inIncidenceArrayT, modelica_integer _index, modelica_integer _numberOfEqs, modelica_boolean _stop, modelica_metatype _rowmark, modelica_metatype _kvars, modelica_integer _inRowSize, modelica_metatype _imapEqnIncRow, modelica_metatype _imapIncRowEqn);
typedef struct BackendDAEUtil_adjacencyMatrixDispatchEnhancedScalar_rettypeboxed_s {
  modelica_metatype c1; /* outIncidenceArray */
  modelica_metatype c2; /* outIncidenceArrayT */
  modelica_metatype c3; /* omapEqnIncRow */
  modelica_metatype c4; /* omapIncRowEqn */
} BackendDAEUtil_adjacencyMatrixDispatchEnhancedScalar_rettypeboxed;
DLLExport
BackendDAEUtil_adjacencyMatrixDispatchEnhancedScalar_rettypeboxed boxptr_BackendDAEUtil_adjacencyMatrixDispatchEnhancedScalar(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _eqArr, modelica_metatype _inIncidenceArray, modelica_metatype _inIncidenceArrayT, modelica_metatype _index, modelica_metatype _numberOfEqs, modelica_metatype _stop, modelica_metatype _rowmark, modelica_metatype _kvars, modelica_metatype _inRowSize, modelica_metatype _imapEqnIncRow, modelica_metatype _imapIncRowEqn);
typedef struct BackendDAEUtil_getAdjacencyMatrixEnhanced_rettype_s {
  modelica_metatype c1; /* outIncidenceMatrix */
  modelica_metatype c2; /* outIncidenceMatrixT */
} BackendDAEUtil_getAdjacencyMatrixEnhanced_rettype;
DLLExport
BackendDAEUtil_getAdjacencyMatrixEnhanced_rettype omc_BackendDAEUtil_getAdjacencyMatrixEnhanced(threadData_t *threadData, modelica_metatype _syst, modelica_metatype _shared);
#define boxptr_BackendDAEUtil_getAdjacencyMatrixEnhanced omc_BackendDAEUtil_getAdjacencyMatrixEnhanced

typedef struct BackendDAEUtil_adjacencyMatrixDispatchEnhanced_rettype_s {
  modelica_metatype c1; /* outIncidenceArray */
  modelica_metatype c2; /* outIncidenceArrayT */
} BackendDAEUtil_adjacencyMatrixDispatchEnhanced_rettype;
DLLExport
BackendDAEUtil_adjacencyMatrixDispatchEnhanced_rettype omc_BackendDAEUtil_adjacencyMatrixDispatchEnhanced(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _eqArr, modelica_metatype _inIncidenceArray, modelica_metatype _inIncidenceArrayT, modelica_integer _index, modelica_integer _numberOfEqs, modelica_boolean _stop, modelica_metatype _rowmark, modelica_metatype _kvars);
typedef struct BackendDAEUtil_adjacencyMatrixDispatchEnhanced_rettypeboxed_s {
  modelica_metatype c1; /* outIncidenceArray */
  modelica_metatype c2; /* outIncidenceArrayT */
} BackendDAEUtil_adjacencyMatrixDispatchEnhanced_rettypeboxed;
DLLExport
BackendDAEUtil_adjacencyMatrixDispatchEnhanced_rettypeboxed boxptr_BackendDAEUtil_adjacencyMatrixDispatchEnhanced(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _eqArr, modelica_metatype _inIncidenceArray, modelica_metatype _inIncidenceArrayT, modelica_metatype _index, modelica_metatype _numberOfEqs, modelica_metatype _stop, modelica_metatype _rowmark, modelica_metatype _kvars);
typedef struct BackendDAEUtil_fillincAdjacencyMatrixTEnhanced_rettype_s {
  modelica_metatype c1; /* outIncidenceArrayT */
} BackendDAEUtil_fillincAdjacencyMatrixTEnhanced_rettype;
DLLExport
BackendDAEUtil_fillincAdjacencyMatrixTEnhanced_rettype omc_BackendDAEUtil_fillincAdjacencyMatrixTEnhanced(threadData_t *threadData, modelica_metatype _eqns, modelica_metatype _eqnsindxs, modelica_metatype _inIncidenceArrayT);
#define boxptr_BackendDAEUtil_fillincAdjacencyMatrixTEnhanced omc_BackendDAEUtil_fillincAdjacencyMatrixTEnhanced

typedef struct BackendDAEUtil_adjacencyRowEnhanced_rettype_s {
  modelica_metatype c1; /* outRow */
  modelica_integer c2; /* size */
} BackendDAEUtil_adjacencyRowEnhanced_rettype;
DLLExport
BackendDAEUtil_adjacencyRowEnhanced_rettype omc_BackendDAEUtil_adjacencyRowEnhanced(threadData_t *threadData, modelica_metatype _inVariables, modelica_metatype _inEquation, modelica_integer _mark, modelica_metatype _rowmark, modelica_metatype _kvars);
typedef struct BackendDAEUtil_adjacencyRowEnhanced_rettypeboxed_s {
  modelica_metatype c1; /* outRow */
  modelica_metatype c2; /* size */
} BackendDAEUtil_adjacencyRowEnhanced_rettypeboxed;
DLLExport
BackendDAEUtil_adjacencyRowEnhanced_rettypeboxed boxptr_BackendDAEUtil_adjacencyRowEnhanced(threadData_t *threadData, modelica_metatype _inVariables, modelica_metatype _inEquation, modelica_metatype _mark, modelica_metatype _rowmark, modelica_metatype _kvars);
typedef struct BackendDAEUtil_adjacencyRowEnhancedEqnLstIfBranches_rettype_s {
  modelica_metatype c1; /* outLstAllBranch */
  modelica_metatype c2; /* outRow */
  modelica_integer c3; /* oSize */
} BackendDAEUtil_adjacencyRowEnhancedEqnLstIfBranches_rettype;
DLLExport
BackendDAEUtil_adjacencyRowEnhancedEqnLstIfBranches_rettype omc_BackendDAEUtil_adjacencyRowEnhancedEqnLstIfBranches(threadData_t *threadData, modelica_metatype _iEqns, modelica_metatype _inVariables, modelica_integer _mark, modelica_metatype _rowmark, modelica_metatype _kvars, modelica_metatype _inLstAllBranch, modelica_metatype _iRow, modelica_integer _iSize);
typedef struct BackendDAEUtil_adjacencyRowEnhancedEqnLstIfBranches_rettypeboxed_s {
  modelica_metatype c1; /* outLstAllBranch */
  modelica_metatype c2; /* outRow */
  modelica_metatype c3; /* oSize */
} BackendDAEUtil_adjacencyRowEnhancedEqnLstIfBranches_rettypeboxed;
DLLExport
BackendDAEUtil_adjacencyRowEnhancedEqnLstIfBranches_rettypeboxed boxptr_BackendDAEUtil_adjacencyRowEnhancedEqnLstIfBranches(threadData_t *threadData, modelica_metatype _iEqns, modelica_metatype _inVariables, modelica_metatype _mark, modelica_metatype _rowmark, modelica_metatype _kvars, modelica_metatype _inLstAllBranch, modelica_metatype _iRow, modelica_metatype _iSize);
typedef struct BackendDAEUtil_adjacencyRowEnhancedEqnLst_rettype_s {
  modelica_metatype c1; /* outRow */
  modelica_integer c2; /* oSize */
} BackendDAEUtil_adjacencyRowEnhancedEqnLst_rettype;
DLLExport
BackendDAEUtil_adjacencyRowEnhancedEqnLst_rettype omc_BackendDAEUtil_adjacencyRowEnhancedEqnLst(threadData_t *threadData, modelica_metatype _iEqns, modelica_metatype _inVariables, modelica_integer _mark, modelica_metatype _rowmark, modelica_metatype _kvars, modelica_metatype _iRow, modelica_integer _iSize);
typedef struct BackendDAEUtil_adjacencyRowEnhancedEqnLst_rettypeboxed_s {
  modelica_metatype c1; /* outRow */
  modelica_metatype c2; /* oSize */
} BackendDAEUtil_adjacencyRowEnhancedEqnLst_rettypeboxed;
DLLExport
BackendDAEUtil_adjacencyRowEnhancedEqnLst_rettypeboxed boxptr_BackendDAEUtil_adjacencyRowEnhancedEqnLst(threadData_t *threadData, modelica_metatype _iEqns, modelica_metatype _inVariables, modelica_metatype _mark, modelica_metatype _rowmark, modelica_metatype _kvars, modelica_metatype _iRow, modelica_metatype _iSize);
typedef struct BackendDAEUtil_adjacencyRowAlgorithmOutputs_rettype_s {
  modelica_metatype c1; /* outRow */
} BackendDAEUtil_adjacencyRowAlgorithmOutputs_rettype;
DLLExport
BackendDAEUtil_adjacencyRowAlgorithmOutputs_rettype omc_BackendDAEUtil_adjacencyRowAlgorithmOutputs(threadData_t *threadData, modelica_metatype _algOutputs, modelica_metatype _inVariables, modelica_integer _mark, modelica_metatype _rowmark, modelica_metatype _iRow);
typedef struct BackendDAEUtil_adjacencyRowAlgorithmOutputs_rettypeboxed_s {
  modelica_metatype c1; /* outRow */
} BackendDAEUtil_adjacencyRowAlgorithmOutputs_rettypeboxed;
DLLExport
BackendDAEUtil_adjacencyRowAlgorithmOutputs_rettypeboxed boxptr_BackendDAEUtil_adjacencyRowAlgorithmOutputs(threadData_t *threadData, modelica_metatype _algOutputs, modelica_metatype _inVariables, modelica_metatype _mark, modelica_metatype _rowmark, modelica_metatype _iRow);
typedef struct BackendDAEUtil_adjacencyRowAlgorithmOutputs1_rettype_s {
  modelica_metatype c1; /* outRow */
} BackendDAEUtil_adjacencyRowAlgorithmOutputs1_rettype;
DLLExport
BackendDAEUtil_adjacencyRowAlgorithmOutputs1_rettype omc_BackendDAEUtil_adjacencyRowAlgorithmOutputs1(threadData_t *threadData, modelica_metatype _vindx, modelica_integer _mark, modelica_metatype _rowmark, modelica_metatype _iRow);
typedef struct BackendDAEUtil_adjacencyRowAlgorithmOutputs1_rettypeboxed_s {
  modelica_metatype c1; /* outRow */
} BackendDAEUtil_adjacencyRowAlgorithmOutputs1_rettypeboxed;
DLLExport
BackendDAEUtil_adjacencyRowAlgorithmOutputs1_rettypeboxed boxptr_BackendDAEUtil_adjacencyRowAlgorithmOutputs1(threadData_t *threadData, modelica_metatype _vindx, modelica_metatype _mark, modelica_metatype _rowmark, modelica_metatype _iRow);
typedef struct BackendDAEUtil_adjacencyRowAlgorithmInputs_rettype_s {
  modelica_metatype c1; /* oTpl */
} BackendDAEUtil_adjacencyRowAlgorithmInputs_rettype;
DLLExport
BackendDAEUtil_adjacencyRowAlgorithmInputs_rettype omc_BackendDAEUtil_adjacencyRowAlgorithmInputs(threadData_t *threadData, modelica_metatype _iTpl);
#define boxptr_BackendDAEUtil_adjacencyRowAlgorithmInputs omc_BackendDAEUtil_adjacencyRowAlgorithmInputs

typedef struct BackendDAEUtil_adjacencyRowAlgorithmInputs1_rettype_s {
  modelica_metatype c1; /* outRow */
} BackendDAEUtil_adjacencyRowAlgorithmInputs1_rettype;
DLLExport
BackendDAEUtil_adjacencyRowAlgorithmInputs1_rettype omc_BackendDAEUtil_adjacencyRowAlgorithmInputs1(threadData_t *threadData, modelica_metatype _vindx, modelica_integer _mark, modelica_metatype _rowmark, modelica_metatype _iRow);
typedef struct BackendDAEUtil_adjacencyRowAlgorithmInputs1_rettypeboxed_s {
  modelica_metatype c1; /* outRow */
} BackendDAEUtil_adjacencyRowAlgorithmInputs1_rettypeboxed;
DLLExport
BackendDAEUtil_adjacencyRowAlgorithmInputs1_rettypeboxed boxptr_BackendDAEUtil_adjacencyRowAlgorithmInputs1(threadData_t *threadData, modelica_metatype _vindx, modelica_metatype _mark, modelica_metatype _rowmark, modelica_metatype _iRow);
typedef struct BackendDAEUtil_adjacencyRowWhenEnhanced_rettype_s {
  modelica_metatype c1; /* outRow */
} BackendDAEUtil_adjacencyRowWhenEnhanced_rettype;
DLLExport
BackendDAEUtil_adjacencyRowWhenEnhanced_rettype omc_BackendDAEUtil_adjacencyRowWhenEnhanced(threadData_t *threadData, modelica_metatype _inVariables, modelica_metatype _inEquation, modelica_integer _mark, modelica_metatype _rowmark, modelica_metatype _kvars, modelica_metatype _iRow);
typedef struct BackendDAEUtil_adjacencyRowWhenEnhanced_rettypeboxed_s {
  modelica_metatype c1; /* outRow */
} BackendDAEUtil_adjacencyRowWhenEnhanced_rettypeboxed;
DLLExport
BackendDAEUtil_adjacencyRowWhenEnhanced_rettypeboxed boxptr_BackendDAEUtil_adjacencyRowWhenEnhanced(threadData_t *threadData, modelica_metatype _inVariables, modelica_metatype _inEquation, modelica_metatype _mark, modelica_metatype _rowmark, modelica_metatype _kvars, modelica_metatype _iRow);
typedef struct BackendDAEUtil_markNegativ_rettype_s {
  modelica_integer c1; /* oMark */
} BackendDAEUtil_markNegativ_rettype;
DLLExport
BackendDAEUtil_markNegativ_rettype omc_BackendDAEUtil_markNegativ(threadData_t *threadData, modelica_integer _indx, modelica_metatype _rowmark, modelica_integer _mark);
typedef struct BackendDAEUtil_markNegativ_rettypeboxed_s {
  modelica_metatype c1; /* oMark */
} BackendDAEUtil_markNegativ_rettypeboxed;
DLLExport
BackendDAEUtil_markNegativ_rettypeboxed boxptr_BackendDAEUtil_markNegativ(threadData_t *threadData, modelica_metatype _indx, modelica_metatype _rowmark, modelica_metatype _mark);
typedef struct BackendDAEUtil_adjacencyRowEnhanced1_rettype_s {
  modelica_metatype c1; /* outRow */
} BackendDAEUtil_adjacencyRowEnhanced1_rettype;
DLLExport
BackendDAEUtil_adjacencyRowEnhanced1_rettype omc_BackendDAEUtil_adjacencyRowEnhanced1(threadData_t *threadData, modelica_metatype _lst, modelica_metatype _e1, modelica_metatype _e2, modelica_metatype _vars, modelica_metatype _kvars, modelica_integer _mark, modelica_metatype _rowmark, modelica_metatype _inRow);
typedef struct BackendDAEUtil_adjacencyRowEnhanced1_rettypeboxed_s {
  modelica_metatype c1; /* outRow */
} BackendDAEUtil_adjacencyRowEnhanced1_rettypeboxed;
DLLExport
BackendDAEUtil_adjacencyRowEnhanced1_rettypeboxed boxptr_BackendDAEUtil_adjacencyRowEnhanced1(threadData_t *threadData, modelica_metatype _lst, modelica_metatype _e1, modelica_metatype _e2, modelica_metatype _vars, modelica_metatype _kvars, modelica_metatype _mark, modelica_metatype _rowmark, modelica_metatype _inRow);
typedef struct BackendDAEUtil_expCrefLstHasCref_rettype_s {
  modelica_boolean c1; /* outB */
} BackendDAEUtil_expCrefLstHasCref_rettype;
DLLExport
BackendDAEUtil_expCrefLstHasCref_rettype omc_BackendDAEUtil_expCrefLstHasCref(threadData_t *threadData, modelica_metatype _iExpLst, modelica_metatype _inCr);
typedef struct BackendDAEUtil_expCrefLstHasCref_rettypeboxed_s {
  modelica_metatype c1; /* outB */
} BackendDAEUtil_expCrefLstHasCref_rettypeboxed;
DLLExport
BackendDAEUtil_expCrefLstHasCref_rettypeboxed boxptr_BackendDAEUtil_expCrefLstHasCref(threadData_t *threadData, modelica_metatype _iExpLst, modelica_metatype _inCr);
typedef struct BackendDAEUtil_adjacencyRowEnhanced2_rettype_s {
  modelica_metatype c1; /* oSolvab */
} BackendDAEUtil_adjacencyRowEnhanced2_rettype;
DLLExport
BackendDAEUtil_adjacencyRowEnhanced2_rettype omc_BackendDAEUtil_adjacencyRowEnhanced2(threadData_t *threadData, modelica_metatype _cr, modelica_metatype _e, modelica_metatype _crlst, modelica_metatype _vars, modelica_metatype _kvars);
#define boxptr_BackendDAEUtil_adjacencyRowEnhanced2 omc_BackendDAEUtil_adjacencyRowEnhanced2

typedef struct BackendDAEUtil_adjacencyRowEnhanced3_rettype_s {
  modelica_metatype c1; /* oSolvab */
} BackendDAEUtil_adjacencyRowEnhanced3_rettype;
DLLExport
BackendDAEUtil_adjacencyRowEnhanced3_rettype omc_BackendDAEUtil_adjacencyRowEnhanced3(threadData_t *threadData, modelica_boolean _b1, modelica_boolean _b2, modelica_metatype _cr, modelica_metatype _e, modelica_metatype _crlst, modelica_metatype _vars, modelica_metatype _kvars);
typedef struct BackendDAEUtil_adjacencyRowEnhanced3_rettypeboxed_s {
  modelica_metatype c1; /* oSolvab */
} BackendDAEUtil_adjacencyRowEnhanced3_rettypeboxed;
DLLExport
BackendDAEUtil_adjacencyRowEnhanced3_rettypeboxed boxptr_BackendDAEUtil_adjacencyRowEnhanced3(threadData_t *threadData, modelica_metatype _b1, modelica_metatype _b2, modelica_metatype _cr, modelica_metatype _e, modelica_metatype _crlst, modelica_metatype _vars, modelica_metatype _kvars);
typedef struct BackendDAEUtil_replaceVartraverser_rettype_s {
  modelica_metatype c1; /* outExp */
} BackendDAEUtil_replaceVartraverser_rettype;
DLLExport
BackendDAEUtil_replaceVartraverser_rettype omc_BackendDAEUtil_replaceVartraverser(threadData_t *threadData, modelica_metatype _inExp);
#define boxptr_BackendDAEUtil_replaceVartraverser omc_BackendDAEUtil_replaceVartraverser

typedef struct BackendDAEUtil_adjacencyRowExpEnhanced_rettype_s {
  modelica_metatype c1; /* outRow */
} BackendDAEUtil_adjacencyRowExpEnhanced_rettype;
DLLExport
BackendDAEUtil_adjacencyRowExpEnhanced_rettype omc_BackendDAEUtil_adjacencyRowExpEnhanced(threadData_t *threadData, modelica_metatype _inExp, modelica_metatype _inVariables, modelica_metatype _inTpl, modelica_metatype _inRow);
#define boxptr_BackendDAEUtil_adjacencyRowExpEnhanced omc_BackendDAEUtil_adjacencyRowExpEnhanced

typedef struct BackendDAEUtil_traversingadjacencyRowExpSolvableEnhancedFinder_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_traversingadjacencyRowExpSolvableEnhancedFinder_rettype;
DLLExport
BackendDAEUtil_traversingadjacencyRowExpSolvableEnhancedFinder_rettype omc_BackendDAEUtil_traversingadjacencyRowExpSolvableEnhancedFinder(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_traversingadjacencyRowExpSolvableEnhancedFinder omc_BackendDAEUtil_traversingadjacencyRowExpSolvableEnhancedFinder

typedef struct BackendDAEUtil_markBranchVars_rettype_s {
  modelica_metatype c1; /* outTuple */
} BackendDAEUtil_markBranchVars_rettype;
DLLExport
BackendDAEUtil_markBranchVars_rettype omc_BackendDAEUtil_markBranchVars(threadData_t *threadData, modelica_metatype _inTuple);
#define boxptr_BackendDAEUtil_markBranchVars omc_BackendDAEUtil_markBranchVars


DLLExport
void omc_BackendDAEUtil_markBranchVars1(threadData_t *threadData, modelica_metatype _varlst, modelica_metatype _iIlst, modelica_integer _mark, modelica_metatype _rowmark, modelica_metatype _bt);

DLLExport
void boxptr_BackendDAEUtil_markBranchVars1(threadData_t *threadData, modelica_metatype _varlst, modelica_metatype _iIlst, modelica_metatype _mark, modelica_metatype _rowmark, modelica_metatype _bt);
typedef struct BackendDAEUtil_getIfExpBranchVarOccurency_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_getIfExpBranchVarOccurency_rettype;
DLLExport
BackendDAEUtil_getIfExpBranchVarOccurency_rettype omc_BackendDAEUtil_getIfExpBranchVarOccurency(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_getIfExpBranchVarOccurency omc_BackendDAEUtil_getIfExpBranchVarOccurency

typedef struct BackendDAEUtil_adjacencyRowExpEnhanced1_rettype_s {
  modelica_metatype c1; /* outIntegerLst */
} BackendDAEUtil_adjacencyRowExpEnhanced1_rettype;
DLLExport
BackendDAEUtil_adjacencyRowExpEnhanced1_rettype omc_BackendDAEUtil_adjacencyRowExpEnhanced1(threadData_t *threadData, modelica_metatype _inVarLst, modelica_metatype _inIntegerLst, modelica_metatype _vars, modelica_boolean _notinder, modelica_integer _mark, modelica_metatype _rowmark, modelica_boolean _unsolvable);
typedef struct BackendDAEUtil_adjacencyRowExpEnhanced1_rettypeboxed_s {
  modelica_metatype c1; /* outIntegerLst */
} BackendDAEUtil_adjacencyRowExpEnhanced1_rettypeboxed;
DLLExport
BackendDAEUtil_adjacencyRowExpEnhanced1_rettypeboxed boxptr_BackendDAEUtil_adjacencyRowExpEnhanced1(threadData_t *threadData, modelica_metatype _inVarLst, modelica_metatype _inIntegerLst, modelica_metatype _vars, modelica_metatype _notinder, modelica_metatype _mark, modelica_metatype _rowmark, modelica_metatype _unsolvable);
typedef struct BackendDAEUtil_solvabilityWights_rettype_s {
  modelica_integer c1; /* i */
} BackendDAEUtil_solvabilityWights_rettype;
DLLExport
BackendDAEUtil_solvabilityWights_rettype omc_BackendDAEUtil_solvabilityWights(threadData_t *threadData, modelica_metatype _solva);
typedef struct BackendDAEUtil_solvabilityWights_rettypeboxed_s {
  modelica_metatype c1; /* i */
} BackendDAEUtil_solvabilityWights_rettypeboxed;
DLLExport
BackendDAEUtil_solvabilityWights_rettypeboxed boxptr_BackendDAEUtil_solvabilityWights(threadData_t *threadData, modelica_metatype _solva);
typedef struct BackendDAEUtil_solvabilityCMP_rettype_s {
  modelica_boolean c1; /* b */
} BackendDAEUtil_solvabilityCMP_rettype;
DLLExport
BackendDAEUtil_solvabilityCMP_rettype omc_BackendDAEUtil_solvabilityCMP(threadData_t *threadData, modelica_metatype _sa, modelica_metatype _sb);
typedef struct BackendDAEUtil_solvabilityCMP_rettypeboxed_s {
  modelica_metatype c1; /* b */
} BackendDAEUtil_solvabilityCMP_rettypeboxed;
DLLExport
BackendDAEUtil_solvabilityCMP_rettypeboxed boxptr_BackendDAEUtil_solvabilityCMP(threadData_t *threadData, modelica_metatype _sa, modelica_metatype _sb);
typedef struct BackendDAEUtil_calculateJacobian_rettype_s {
  modelica_metatype c1; /* outTplIntegerIntegerEquationLstOption */
} BackendDAEUtil_calculateJacobian_rettype;
DLLExport
BackendDAEUtil_calculateJacobian_rettype omc_BackendDAEUtil_calculateJacobian(threadData_t *threadData, modelica_metatype _inVariables, modelica_metatype _inEquationArray, modelica_metatype _inIncidenceMatrix, modelica_boolean _differentiateIfExp, modelica_metatype _iShared);
typedef struct BackendDAEUtil_calculateJacobian_rettypeboxed_s {
  modelica_metatype c1; /* outTplIntegerIntegerEquationLstOption */
} BackendDAEUtil_calculateJacobian_rettypeboxed;
DLLExport
BackendDAEUtil_calculateJacobian_rettypeboxed boxptr_BackendDAEUtil_calculateJacobian(threadData_t *threadData, modelica_metatype _inVariables, modelica_metatype _inEquationArray, modelica_metatype _inIncidenceMatrix, modelica_metatype _differentiateIfExp, modelica_metatype _iShared);
typedef struct BackendDAEUtil_calculateJacobianEnhanced_rettype_s {
  modelica_metatype c1; /* outTplIntegerIntegerEquationLstOption */
} BackendDAEUtil_calculateJacobianEnhanced_rettype;
DLLExport
BackendDAEUtil_calculateJacobianEnhanced_rettype omc_BackendDAEUtil_calculateJacobianEnhanced(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _eqns, modelica_metatype _m, modelica_boolean _differentiateIfExp, modelica_metatype _iShared);
typedef struct BackendDAEUtil_calculateJacobianEnhanced_rettypeboxed_s {
  modelica_metatype c1; /* outTplIntegerIntegerEquationLstOption */
} BackendDAEUtil_calculateJacobianEnhanced_rettypeboxed;
DLLExport
BackendDAEUtil_calculateJacobianEnhanced_rettypeboxed boxptr_BackendDAEUtil_calculateJacobianEnhanced(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _eqns, modelica_metatype _m, modelica_metatype _differentiateIfExp, modelica_metatype _iShared);
typedef struct BackendDAEUtil_traverseequationToResidualForm_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_traverseequationToResidualForm_rettype;
DLLExport
BackendDAEUtil_traverseequationToResidualForm_rettype omc_BackendDAEUtil_traverseequationToResidualForm(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_traverseequationToResidualForm omc_BackendDAEUtil_traverseequationToResidualForm

typedef struct BackendDAEUtil_traverseEquationToScalarResidualForm_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_traverseEquationToScalarResidualForm_rettype;
DLLExport
BackendDAEUtil_traverseEquationToScalarResidualForm_rettype omc_BackendDAEUtil_traverseEquationToScalarResidualForm(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_traverseEquationToScalarResidualForm omc_BackendDAEUtil_traverseEquationToScalarResidualForm

typedef struct BackendDAEUtil_calculateJacobianRows_rettype_s {
  modelica_metatype c1; /* outLst */
} BackendDAEUtil_calculateJacobianRows_rettype;
DLLExport
BackendDAEUtil_calculateJacobianRows_rettype omc_BackendDAEUtil_calculateJacobianRows(threadData_t *threadData, modelica_metatype _inEquationLst, modelica_metatype _vars, modelica_metatype _m, modelica_integer _eqn_indx, modelica_integer _scalar_eqn_indx, modelica_boolean _differentiateIfExp, modelica_metatype _iShared, modelica_fnptr varsInEqn, modelica_metatype _iAcc);
typedef struct BackendDAEUtil_calculateJacobianRows_rettypeboxed_s {
  modelica_metatype c1; /* outLst */
} BackendDAEUtil_calculateJacobianRows_rettypeboxed;
DLLExport
BackendDAEUtil_calculateJacobianRows_rettypeboxed boxptr_BackendDAEUtil_calculateJacobianRows(threadData_t *threadData, modelica_metatype _inEquationLst, modelica_metatype _vars, modelica_metatype _m, modelica_metatype _eqn_indx, modelica_metatype _scalar_eqn_indx, modelica_metatype _differentiateIfExp, modelica_metatype _iShared, modelica_fnptr varsInEqn, modelica_metatype _iAcc);
typedef struct BackendDAEUtil_calculateJacobianRow_rettype_s {
  modelica_metatype c1; /* outLst */
  modelica_integer c2; /* size */
} BackendDAEUtil_calculateJacobianRow_rettype;
DLLExport
BackendDAEUtil_calculateJacobianRow_rettype omc_BackendDAEUtil_calculateJacobianRow(threadData_t *threadData, modelica_metatype _inEquation, modelica_metatype _vars, modelica_metatype _m, modelica_integer _eqn_indx, modelica_integer _scalar_eqn_indx, modelica_boolean _differentiateIfExp, modelica_metatype _iShared, modelica_fnptr fvarsInEqn, modelica_metatype _iAcc);
typedef struct BackendDAEUtil_calculateJacobianRow_rettypeboxed_s {
  modelica_metatype c1; /* outLst */
  modelica_metatype c2; /* size */
} BackendDAEUtil_calculateJacobianRow_rettypeboxed;
DLLExport
BackendDAEUtil_calculateJacobianRow_rettypeboxed boxptr_BackendDAEUtil_calculateJacobianRow(threadData_t *threadData, modelica_metatype _inEquation, modelica_metatype _vars, modelica_metatype _m, modelica_metatype _eqn_indx, modelica_metatype _scalar_eqn_indx, modelica_metatype _differentiateIfExp, modelica_metatype _iShared, modelica_fnptr fvarsInEqn, modelica_metatype _iAcc);
typedef struct BackendDAEUtil_getArrayEquationSub_rettype_s {
  modelica_metatype c1; /* outSubs */
  modelica_metatype c2; /* outList */
} BackendDAEUtil_getArrayEquationSub_rettype;
DLLExport
BackendDAEUtil_getArrayEquationSub_rettype omc_BackendDAEUtil_getArrayEquationSub(threadData_t *threadData, modelica_integer _Index, modelica_metatype _inAD, modelica_metatype _inList);
typedef struct BackendDAEUtil_getArrayEquationSub_rettypeboxed_s {
  modelica_metatype c1; /* outSubs */
  modelica_metatype c2; /* outList */
} BackendDAEUtil_getArrayEquationSub_rettypeboxed;
DLLExport
BackendDAEUtil_getArrayEquationSub_rettypeboxed boxptr_BackendDAEUtil_getArrayEquationSub(threadData_t *threadData, modelica_metatype _Index, modelica_metatype _inAD, modelica_metatype _inList);
typedef struct BackendDAEUtil_arrayDimensionsToRange_rettype_s {
  modelica_metatype c1; /* outRangelist */
} BackendDAEUtil_arrayDimensionsToRange_rettype;
DLLExport
BackendDAEUtil_arrayDimensionsToRange_rettype omc_BackendDAEUtil_arrayDimensionsToRange(threadData_t *threadData, modelica_metatype _idims);
#define boxptr_BackendDAEUtil_arrayDimensionsToRange omc_BackendDAEUtil_arrayDimensionsToRange

typedef struct BackendDAEUtil_calculateJacobianRowLst_rettype_s {
  modelica_metatype c1; /* outLst */
} BackendDAEUtil_calculateJacobianRowLst_rettype;
DLLExport
BackendDAEUtil_calculateJacobianRowLst_rettype omc_BackendDAEUtil_calculateJacobianRowLst(threadData_t *threadData, modelica_metatype _inExps, modelica_metatype _vars, modelica_integer _eqn_indx, modelica_metatype _inIntegerLst, modelica_boolean _differentiateIfExp, modelica_metatype _iShared, modelica_metatype _source, modelica_metatype _iAcc);
typedef struct BackendDAEUtil_calculateJacobianRowLst_rettypeboxed_s {
  modelica_metatype c1; /* outLst */
} BackendDAEUtil_calculateJacobianRowLst_rettypeboxed;
DLLExport
BackendDAEUtil_calculateJacobianRowLst_rettypeboxed boxptr_BackendDAEUtil_calculateJacobianRowLst(threadData_t *threadData, modelica_metatype _inExps, modelica_metatype _vars, modelica_metatype _eqn_indx, modelica_metatype _inIntegerLst, modelica_metatype _differentiateIfExp, modelica_metatype _iShared, modelica_metatype _source, modelica_metatype _iAcc);
typedef struct BackendDAEUtil_calculateJacobianRow2_rettype_s {
  modelica_metatype c1; /* outLst */
} BackendDAEUtil_calculateJacobianRow2_rettype;
DLLExport
BackendDAEUtil_calculateJacobianRow2_rettype omc_BackendDAEUtil_calculateJacobianRow2(threadData_t *threadData, modelica_metatype _inExp, modelica_metatype _vars, modelica_integer _eqn_indx, modelica_metatype _inIntegerLst, modelica_boolean _differentiateIfExp, modelica_metatype _iShared, modelica_metatype _source, modelica_metatype _iAcc);
typedef struct BackendDAEUtil_calculateJacobianRow2_rettypeboxed_s {
  modelica_metatype c1; /* outLst */
} BackendDAEUtil_calculateJacobianRow2_rettypeboxed;
DLLExport
BackendDAEUtil_calculateJacobianRow2_rettypeboxed boxptr_BackendDAEUtil_calculateJacobianRow2(threadData_t *threadData, modelica_metatype _inExp, modelica_metatype _vars, modelica_metatype _eqn_indx, modelica_metatype _inIntegerLst, modelica_metatype _differentiateIfExp, modelica_metatype _iShared, modelica_metatype _source, modelica_metatype _iAcc);
typedef struct BackendDAEUtil_calculateJacobianRow3_rettype_s {
  modelica_metatype c1; /* outLst */
} BackendDAEUtil_calculateJacobianRow3_rettype;
DLLExport
BackendDAEUtil_calculateJacobianRow3_rettype omc_BackendDAEUtil_calculateJacobianRow3(threadData_t *threadData, modelica_integer _eqn_indx, modelica_integer _vindx, modelica_metatype _inExp, modelica_metatype _source, modelica_metatype _iAcc);
typedef struct BackendDAEUtil_calculateJacobianRow3_rettypeboxed_s {
  modelica_metatype c1; /* outLst */
} BackendDAEUtil_calculateJacobianRow3_rettypeboxed;
DLLExport
BackendDAEUtil_calculateJacobianRow3_rettypeboxed boxptr_BackendDAEUtil_calculateJacobianRow3(threadData_t *threadData, modelica_metatype _eqn_indx, modelica_metatype _vindx, modelica_metatype _inExp, modelica_metatype _source, modelica_metatype _iAcc);
typedef struct BackendDAEUtil_analyzeJacobian_rettype_s {
  modelica_metatype c1; /* outJacobianType */
  modelica_boolean c2; /* jacConstant */
} BackendDAEUtil_analyzeJacobian_rettype;
DLLExport
BackendDAEUtil_analyzeJacobian_rettype omc_BackendDAEUtil_analyzeJacobian(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _eqns, modelica_metatype _inTplIntegerIntegerEquationLstOption);
typedef struct BackendDAEUtil_analyzeJacobian_rettypeboxed_s {
  modelica_metatype c1; /* outJacobianType */
  modelica_metatype c2; /* jacConstant */
} BackendDAEUtil_analyzeJacobian_rettypeboxed;
DLLExport
BackendDAEUtil_analyzeJacobian_rettypeboxed boxptr_BackendDAEUtil_analyzeJacobian(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _eqns, modelica_metatype _inTplIntegerIntegerEquationLstOption);
typedef struct BackendDAEUtil_varsNotInRelations_rettype_s {
  modelica_metatype c1; /* outTplExpBoolTypeA */
} BackendDAEUtil_varsNotInRelations_rettype;
DLLExport
BackendDAEUtil_varsNotInRelations_rettype omc_BackendDAEUtil_varsNotInRelations(threadData_t *threadData, modelica_metatype _inTplExpTypeA);
#define boxptr_BackendDAEUtil_varsNotInRelations omc_BackendDAEUtil_varsNotInRelations

typedef struct BackendDAEUtil_rhsConstant_rettype_s {
  modelica_boolean c1; /* outBoolean */
} BackendDAEUtil_rhsConstant_rettype;
DLLExport
BackendDAEUtil_rhsConstant_rettype omc_BackendDAEUtil_rhsConstant(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _eqns);
typedef struct BackendDAEUtil_rhsConstant_rettypeboxed_s {
  modelica_metatype c1; /* outBoolean */
} BackendDAEUtil_rhsConstant_rettypeboxed;
DLLExport
BackendDAEUtil_rhsConstant_rettypeboxed boxptr_BackendDAEUtil_rhsConstant(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _eqns);
typedef struct BackendDAEUtil_rhsConstant2_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_rhsConstant2_rettype;
DLLExport
BackendDAEUtil_rhsConstant2_rettype omc_BackendDAEUtil_rhsConstant2(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_rhsConstant2 omc_BackendDAEUtil_rhsConstant2

typedef struct BackendDAEUtil_jacobianConstant_rettype_s {
  modelica_boolean c1; /* outBoolean */
} BackendDAEUtil_jacobianConstant_rettype;
DLLExport
BackendDAEUtil_jacobianConstant_rettype omc_BackendDAEUtil_jacobianConstant(threadData_t *threadData, modelica_metatype _inTplIntegerIntegerEquationLst);
typedef struct BackendDAEUtil_jacobianConstant_rettypeboxed_s {
  modelica_metatype c1; /* outBoolean */
} BackendDAEUtil_jacobianConstant_rettypeboxed;
DLLExport
BackendDAEUtil_jacobianConstant_rettypeboxed boxptr_BackendDAEUtil_jacobianConstant(threadData_t *threadData, modelica_metatype _inTplIntegerIntegerEquationLst);
typedef struct BackendDAEUtil_jacobianNonlinear_rettype_s {
  modelica_boolean c1; /* outBoolean */
} BackendDAEUtil_jacobianNonlinear_rettype;
DLLExport
BackendDAEUtil_jacobianNonlinear_rettype omc_BackendDAEUtil_jacobianNonlinear(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _inTplIntegerIntegerEquationLst);
typedef struct BackendDAEUtil_jacobianNonlinear_rettypeboxed_s {
  modelica_metatype c1; /* outBoolean */
} BackendDAEUtil_jacobianNonlinear_rettypeboxed;
DLLExport
BackendDAEUtil_jacobianNonlinear_rettypeboxed boxptr_BackendDAEUtil_jacobianNonlinear(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _inTplIntegerIntegerEquationLst);
typedef struct BackendDAEUtil_jacobianNonlinearExp_rettype_s {
  modelica_boolean c1; /* outBoolean */
} BackendDAEUtil_jacobianNonlinearExp_rettype;
DLLExport
BackendDAEUtil_jacobianNonlinearExp_rettype omc_BackendDAEUtil_jacobianNonlinearExp(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _inExp);
typedef struct BackendDAEUtil_jacobianNonlinearExp_rettypeboxed_s {
  modelica_metatype c1; /* outBoolean */
} BackendDAEUtil_jacobianNonlinearExp_rettypeboxed;
DLLExport
BackendDAEUtil_jacobianNonlinearExp_rettypeboxed boxptr_BackendDAEUtil_jacobianNonlinearExp(threadData_t *threadData, modelica_metatype _vars, modelica_metatype _inExp);
typedef struct BackendDAEUtil_traverserjacobianNonlinearExp_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_traverserjacobianNonlinearExp_rettype;
DLLExport
BackendDAEUtil_traverserjacobianNonlinearExp_rettype omc_BackendDAEUtil_traverserjacobianNonlinearExp(threadData_t *threadData, modelica_metatype _tpl);
#define boxptr_BackendDAEUtil_traverserjacobianNonlinearExp omc_BackendDAEUtil_traverserjacobianNonlinearExp

typedef struct BackendDAEUtil_containAnyVar_rettype_s {
  modelica_boolean c1; /* outBoolean */
} BackendDAEUtil_containAnyVar_rettype;
DLLExport
BackendDAEUtil_containAnyVar_rettype omc_BackendDAEUtil_containAnyVar(threadData_t *threadData, modelica_metatype _inExpComponentRefLst, modelica_metatype _inVariables);
typedef struct BackendDAEUtil_containAnyVar_rettypeboxed_s {
  modelica_metatype c1; /* outBoolean */
} BackendDAEUtil_containAnyVar_rettypeboxed;
DLLExport
BackendDAEUtil_containAnyVar_rettypeboxed boxptr_BackendDAEUtil_containAnyVar(threadData_t *threadData, modelica_metatype _inExpComponentRefLst, modelica_metatype _inVariables);
typedef struct BackendDAEUtil_getEqnSysRhs_rettype_s {
  modelica_metatype c1; /* outRhsExps */
  modelica_metatype c2; /* outSources */
} BackendDAEUtil_getEqnSysRhs_rettype;
DLLExport
BackendDAEUtil_getEqnSysRhs_rettype omc_BackendDAEUtil_getEqnSysRhs(threadData_t *threadData, modelica_metatype _inEqns, modelica_metatype _inVariables, modelica_metatype _funcs);
#define boxptr_BackendDAEUtil_getEqnSysRhs omc_BackendDAEUtil_getEqnSysRhs

typedef struct BackendDAEUtil_equationToExp_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_equationToExp_rettype;
DLLExport
BackendDAEUtil_equationToExp_rettype omc_BackendDAEUtil_equationToExp(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_equationToExp omc_BackendDAEUtil_equationToExp

typedef struct BackendDAEUtil_getEqnsysRhsExp_rettype_s {
  modelica_metatype c1; /* outExp */
} BackendDAEUtil_getEqnsysRhsExp_rettype;
DLLExport
BackendDAEUtil_getEqnsysRhsExp_rettype omc_BackendDAEUtil_getEqnsysRhsExp(threadData_t *threadData, modelica_metatype _inExp, modelica_metatype _inVariables, modelica_metatype _funcs, modelica_metatype _oRepl);
#define boxptr_BackendDAEUtil_getEqnsysRhsExp omc_BackendDAEUtil_getEqnsysRhsExp

typedef struct BackendDAEUtil_getEqnsysRhsExp1_rettype_s {
  modelica_metatype c1; /* outTplExpBoolTypeA */
} BackendDAEUtil_getEqnsysRhsExp1_rettype;
DLLExport
BackendDAEUtil_getEqnsysRhsExp1_rettype omc_BackendDAEUtil_getEqnsysRhsExp1(threadData_t *threadData, modelica_metatype _inTplExpTypeA);
#define boxptr_BackendDAEUtil_getEqnsysRhsExp1 omc_BackendDAEUtil_getEqnsysRhsExp1

typedef struct BackendDAEUtil_getEqnsysRhsExp3_rettype_s {
  modelica_metatype c1; /* oExp */
  modelica_boolean c2; /* notfound */
} BackendDAEUtil_getEqnsysRhsExp3_rettype;
DLLExport
BackendDAEUtil_getEqnsysRhsExp3_rettype omc_BackendDAEUtil_getEqnsysRhsExp3(threadData_t *threadData, modelica_boolean _b, modelica_metatype _inExp, modelica_metatype _iTpl);
typedef struct BackendDAEUtil_getEqnsysRhsExp3_rettypeboxed_s {
  modelica_metatype c1; /* oExp */
  modelica_metatype c2; /* notfound */
} BackendDAEUtil_getEqnsysRhsExp3_rettypeboxed;
DLLExport
BackendDAEUtil_getEqnsysRhsExp3_rettypeboxed boxptr_BackendDAEUtil_getEqnsysRhsExp3(threadData_t *threadData, modelica_metatype _b, modelica_metatype _inExp, modelica_metatype _iTpl);
typedef struct BackendDAEUtil_getEqnsysRhsExp2_rettype_s {
  modelica_metatype c1; /* outTplExpBoolTypeA */
} BackendDAEUtil_getEqnsysRhsExp2_rettype;
DLLExport
BackendDAEUtil_getEqnsysRhsExp2_rettype omc_BackendDAEUtil_getEqnsysRhsExp2(threadData_t *threadData, modelica_metatype _inTplExpTypeA);
#define boxptr_BackendDAEUtil_getEqnsysRhsExp2 omc_BackendDAEUtil_getEqnsysRhsExp2

typedef struct BackendDAEUtil_makeZeroReplacements_rettype_s {
  modelica_metatype c1; /* repl */
} BackendDAEUtil_makeZeroReplacements_rettype;
DLLExport
BackendDAEUtil_makeZeroReplacements_rettype omc_BackendDAEUtil_makeZeroReplacements(threadData_t *threadData, modelica_metatype _vars);
#define boxptr_BackendDAEUtil_makeZeroReplacements omc_BackendDAEUtil_makeZeroReplacements

typedef struct BackendDAEUtil_makeZeroReplacement_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_makeZeroReplacement_rettype;
DLLExport
BackendDAEUtil_makeZeroReplacement_rettype omc_BackendDAEUtil_makeZeroReplacement(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_makeZeroReplacement omc_BackendDAEUtil_makeZeroReplacement

typedef struct BackendDAEUtil_traverseBackendDAEExps_rettype_s {
  modelica_metatype c1; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExps_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExps_rettype omc_BackendDAEUtil_traverseBackendDAEExps(threadData_t *threadData, modelica_metatype _inBackendDAE, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExps omc_BackendDAEUtil_traverseBackendDAEExps

typedef struct BackendDAEUtil_traverseBackendDAEExpsNoCopyWithUpdate_rettype_s {
  modelica_metatype c1; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsNoCopyWithUpdate_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsNoCopyWithUpdate_rettype omc_BackendDAEUtil_traverseBackendDAEExpsNoCopyWithUpdate(threadData_t *threadData, modelica_metatype _inBackendDAE, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsNoCopyWithUpdate omc_BackendDAEUtil_traverseBackendDAEExpsNoCopyWithUpdate

typedef struct BackendDAEUtil_traverseBackendDAEExpsEqSystem_rettype_s {
  modelica_metatype c1; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsEqSystem_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsEqSystem_rettype omc_BackendDAEUtil_traverseBackendDAEExpsEqSystem(threadData_t *threadData, modelica_metatype _syst, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsEqSystem omc_BackendDAEUtil_traverseBackendDAEExpsEqSystem

typedef struct BackendDAEUtil_traverseBackendDAEExpsEqSystemWithUpdate_rettype_s {
  modelica_metatype c1; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsEqSystemWithUpdate_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsEqSystemWithUpdate_rettype omc_BackendDAEUtil_traverseBackendDAEExpsEqSystemWithUpdate(threadData_t *threadData, modelica_metatype _syst, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsEqSystemWithUpdate omc_BackendDAEUtil_traverseBackendDAEExpsEqSystemWithUpdate

typedef struct BackendDAEUtil_traverseBackendDAEExpsVars_rettype_s {
  modelica_metatype c1; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsVars_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsVars_rettype omc_BackendDAEUtil_traverseBackendDAEExpsVars(threadData_t *threadData, modelica_metatype _inVariables, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsVars omc_BackendDAEUtil_traverseBackendDAEExpsVars

typedef struct BackendDAEUtil_traverseBackendDAEExpsVarsWithUpdate_rettype_s {
  modelica_metatype c1; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsVarsWithUpdate_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsVarsWithUpdate_rettype omc_BackendDAEUtil_traverseBackendDAEExpsVarsWithUpdate(threadData_t *threadData, modelica_metatype _inVariables, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsVarsWithUpdate omc_BackendDAEUtil_traverseBackendDAEExpsVarsWithUpdate

typedef struct BackendDAEUtil_traverseBackendDAEArrayNoCopy_rettype_s {
  modelica_metatype c1; /* outTypeB */
} BackendDAEUtil_traverseBackendDAEArrayNoCopy_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEArrayNoCopy_rettype omc_BackendDAEUtil_traverseBackendDAEArrayNoCopy(threadData_t *threadData, modelica_metatype _inArray, modelica_fnptr func, modelica_fnptr arrayfunc, modelica_integer _pos, modelica_integer _len, modelica_metatype _inTypeB);
typedef struct BackendDAEUtil_traverseBackendDAEArrayNoCopy_rettypeboxed_s {
  modelica_metatype c1; /* outTypeB */
} BackendDAEUtil_traverseBackendDAEArrayNoCopy_rettypeboxed;
DLLExport
BackendDAEUtil_traverseBackendDAEArrayNoCopy_rettypeboxed boxptr_BackendDAEUtil_traverseBackendDAEArrayNoCopy(threadData_t *threadData, modelica_metatype _inArray, modelica_fnptr func, modelica_fnptr arrayfunc, modelica_metatype _pos, modelica_metatype _len, modelica_metatype _inTypeB);
typedef struct BackendDAEUtil_traverseBackendDAEArrayNoCopy__work_rettype_s {
  modelica_metatype c1; /* outTypeB */
} BackendDAEUtil_traverseBackendDAEArrayNoCopy__work_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEArrayNoCopy__work_rettype omc_BackendDAEUtil_traverseBackendDAEArrayNoCopy__work(threadData_t *threadData, modelica_boolean _stop, modelica_metatype _inArray, modelica_fnptr func, modelica_fnptr arrayfunc, modelica_integer _pos, modelica_integer _len, modelica_metatype _inTypeB);
typedef struct BackendDAEUtil_traverseBackendDAEArrayNoCopy__work_rettypeboxed_s {
  modelica_metatype c1; /* outTypeB */
} BackendDAEUtil_traverseBackendDAEArrayNoCopy__work_rettypeboxed;
DLLExport
BackendDAEUtil_traverseBackendDAEArrayNoCopy__work_rettypeboxed boxptr_BackendDAEUtil_traverseBackendDAEArrayNoCopy__work(threadData_t *threadData, modelica_metatype _stop, modelica_metatype _inArray, modelica_fnptr func, modelica_fnptr arrayfunc, modelica_metatype _pos, modelica_metatype _len, modelica_metatype _inTypeB);
typedef struct BackendDAEUtil_traverseBackendDAEArrayNoCopyWithStop_rettype_s {
  modelica_metatype c1; /* outTypeB */
} BackendDAEUtil_traverseBackendDAEArrayNoCopyWithStop_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEArrayNoCopyWithStop_rettype omc_BackendDAEUtil_traverseBackendDAEArrayNoCopyWithStop(threadData_t *threadData, modelica_metatype _inArray, modelica_fnptr func, modelica_fnptr arrayfunc, modelica_integer _pos, modelica_integer _len, modelica_metatype _inTypeB);
typedef struct BackendDAEUtil_traverseBackendDAEArrayNoCopyWithStop_rettypeboxed_s {
  modelica_metatype c1; /* outTypeB */
} BackendDAEUtil_traverseBackendDAEArrayNoCopyWithStop_rettypeboxed;
DLLExport
BackendDAEUtil_traverseBackendDAEArrayNoCopyWithStop_rettypeboxed boxptr_BackendDAEUtil_traverseBackendDAEArrayNoCopyWithStop(threadData_t *threadData, modelica_metatype _inArray, modelica_fnptr func, modelica_fnptr arrayfunc, modelica_metatype _pos, modelica_metatype _len, modelica_metatype _inTypeB);
typedef struct BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdate_rettype_s {
  modelica_metatype c1; /* outArray */
  modelica_metatype c2; /* outTypeB */
} BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdate_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdate_rettype omc_BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdate(threadData_t *threadData, modelica_metatype _inArray, modelica_fnptr func, modelica_fnptr arrayfunc, modelica_integer _pos, modelica_integer _len, modelica_metatype _inTypeB);
typedef struct BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdate_rettypeboxed_s {
  modelica_metatype c1; /* outArray */
  modelica_metatype c2; /* outTypeB */
} BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdate_rettypeboxed;
DLLExport
BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdate_rettypeboxed boxptr_BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdate(threadData_t *threadData, modelica_metatype _inArray, modelica_fnptr func, modelica_fnptr arrayfunc, modelica_metatype _pos, modelica_metatype _len, modelica_metatype _inTypeB);
typedef struct BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdateWork_rettype_s {
  modelica_metatype c1; /* outArray */
  modelica_metatype c2; /* outTypeB */
} BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdateWork_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdateWork_rettype omc_BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdateWork(threadData_t *threadData, modelica_boolean _inStop, modelica_metatype _inArray, modelica_fnptr func, modelica_fnptr arrayfunc, modelica_integer _pos, modelica_integer _len, modelica_metatype _inTypeB);
typedef struct BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdateWork_rettypeboxed_s {
  modelica_metatype c1; /* outArray */
  modelica_metatype c2; /* outTypeB */
} BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdateWork_rettypeboxed;
DLLExport
BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdateWork_rettypeboxed boxptr_BackendDAEUtil_traverseBackendDAEArrayNoCopyWithUpdateWork(threadData_t *threadData, modelica_metatype _inStop, modelica_metatype _inArray, modelica_fnptr func, modelica_fnptr arrayfunc, modelica_metatype _pos, modelica_metatype _len, modelica_metatype _inTypeB);
typedef struct BackendDAEUtil_arrayUpdateCond_rettype_s {
  modelica_metatype c1; /* outArray */
} BackendDAEUtil_arrayUpdateCond_rettype;
DLLExport
BackendDAEUtil_arrayUpdateCond_rettype omc_BackendDAEUtil_arrayUpdateCond(threadData_t *threadData, modelica_boolean _b, modelica_metatype _inArray, modelica_integer _pos, modelica_metatype _a);
typedef struct BackendDAEUtil_arrayUpdateCond_rettypeboxed_s {
  modelica_metatype c1; /* outArray */
} BackendDAEUtil_arrayUpdateCond_rettypeboxed;
DLLExport
BackendDAEUtil_arrayUpdateCond_rettypeboxed boxptr_BackendDAEUtil_arrayUpdateCond(threadData_t *threadData, modelica_metatype _b, modelica_metatype _inArray, modelica_metatype _pos, modelica_metatype _a);
typedef struct BackendDAEUtil_traverseBackendDAEExpsVar_rettype_s {
  modelica_metatype c1; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsVar_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsVar_rettype omc_BackendDAEUtil_traverseBackendDAEExpsVar(threadData_t *threadData, modelica_metatype _inVar, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsVar omc_BackendDAEUtil_traverseBackendDAEExpsVar

typedef struct BackendDAEUtil_traverseBackendDAEExpsVarWithUpdate_rettype_s {
  modelica_metatype c1; /* ovar */
  modelica_metatype c2; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsVarWithUpdate_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsVarWithUpdate_rettype omc_BackendDAEUtil_traverseBackendDAEExpsVarWithUpdate(threadData_t *threadData, modelica_metatype _inVar, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsVarWithUpdate omc_BackendDAEUtil_traverseBackendDAEExpsVarWithUpdate

typedef struct BackendDAEUtil_traverseBackendDAEVarAttr_rettype_s {
  modelica_metatype c1; /* outAttr */
  modelica_metatype c2; /* outExtraArg */
} BackendDAEUtil_traverseBackendDAEVarAttr_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEVarAttr_rettype omc_BackendDAEUtil_traverseBackendDAEVarAttr(threadData_t *threadData, modelica_metatype _attr, modelica_fnptr func, modelica_metatype _extraArg);
#define boxptr_BackendDAEUtil_traverseBackendDAEVarAttr omc_BackendDAEUtil_traverseBackendDAEVarAttr

typedef struct BackendDAEUtil_traverseBackendDAEAttrDistribution_rettype_s {
  modelica_metatype c1; /* outDistOpt */
  modelica_metatype c2; /* outExtraArg */
} BackendDAEUtil_traverseBackendDAEAttrDistribution_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEAttrDistribution_rettype omc_BackendDAEUtil_traverseBackendDAEAttrDistribution(threadData_t *threadData, modelica_metatype _distOpt, modelica_fnptr func, modelica_metatype _extraArg);
#define boxptr_BackendDAEUtil_traverseBackendDAEAttrDistribution omc_BackendDAEUtil_traverseBackendDAEAttrDistribution

typedef struct BackendDAEUtil_traverseBackendDAEExpsSubscriptWithUpdate_rettype_s {
  modelica_metatype c1; /* outSubscript */
  modelica_metatype c2; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsSubscriptWithUpdate_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsSubscriptWithUpdate_rettype omc_BackendDAEUtil_traverseBackendDAEExpsSubscriptWithUpdate(threadData_t *threadData, modelica_metatype _inSubscript, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsSubscriptWithUpdate omc_BackendDAEUtil_traverseBackendDAEExpsSubscriptWithUpdate

typedef struct BackendDAEUtil_traverseBackendDAEExpsEqns_rettype_s {
  modelica_metatype c1; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsEqns_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsEqns_rettype omc_BackendDAEUtil_traverseBackendDAEExpsEqns(threadData_t *threadData, modelica_metatype _inEquationArray, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsEqns omc_BackendDAEUtil_traverseBackendDAEExpsEqns

typedef struct BackendDAEUtil_traverseBackendDAEExpsEqnsWithStop_rettype_s {
  modelica_metatype c1; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsEqnsWithStop_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsEqnsWithStop_rettype omc_BackendDAEUtil_traverseBackendDAEExpsEqnsWithStop(threadData_t *threadData, modelica_metatype _inEquationArray, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsEqnsWithStop omc_BackendDAEUtil_traverseBackendDAEExpsEqnsWithStop

typedef struct BackendDAEUtil_traverseBackendDAEExpsEqnsWithUpdate_rettype_s {
  modelica_metatype c1; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsEqnsWithUpdate_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsEqnsWithUpdate_rettype omc_BackendDAEUtil_traverseBackendDAEExpsEqnsWithUpdate(threadData_t *threadData, modelica_metatype _inEquationArray, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsEqnsWithUpdate omc_BackendDAEUtil_traverseBackendDAEExpsEqnsWithUpdate

typedef struct BackendDAEUtil_traverseBackendDAEExpsOptEqn_rettype_s {
  modelica_metatype c1; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsOptEqn_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsOptEqn_rettype omc_BackendDAEUtil_traverseBackendDAEExpsOptEqn(threadData_t *threadData, modelica_metatype _inEquation, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsOptEqn omc_BackendDAEUtil_traverseBackendDAEExpsOptEqn

typedef struct BackendDAEUtil_traverseBackendDAEExpsOptEqnWithStop_rettype_s {
  modelica_boolean c1; /* outBoolean */
  modelica_metatype c2; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsOptEqnWithStop_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsOptEqnWithStop_rettype omc_BackendDAEUtil_traverseBackendDAEExpsOptEqnWithStop(threadData_t *threadData, modelica_metatype _inEquation, modelica_fnptr func, modelica_metatype _inTypeA);
typedef struct BackendDAEUtil_traverseBackendDAEExpsOptEqnWithStop_rettypeboxed_s {
  modelica_metatype c1; /* outBoolean */
  modelica_metatype c2; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsOptEqnWithStop_rettypeboxed;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsOptEqnWithStop_rettypeboxed boxptr_BackendDAEUtil_traverseBackendDAEExpsOptEqnWithStop(threadData_t *threadData, modelica_metatype _inEquation, modelica_fnptr func, modelica_metatype _inTypeA);
typedef struct BackendDAEUtil_traverseBackendDAEExpsOptEqnWithUpdate_rettype_s {
  modelica_metatype c1; /* outEquation */
  modelica_metatype c2; /* outTypeA */
} BackendDAEUtil_traverseBackendDAEExpsOptEqnWithUpdate_rettype;
DLLExport
BackendDAEUtil_traverseBackendDAEExpsOptEqnWithUpdate_rettype omc_BackendDAEUtil_traverseBackendDAEExpsOptEqnWithUpdate(threadData_t *threadData, modelica_metatype _inEquation, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseBackendDAEExpsOptEqnWithUpdate omc_BackendDAEUtil_traverseBackendDAEExpsOptEqnWithUpdate

typedef struct BackendDAEUtil_traverseAlgorithmExps_rettype_s {
  modelica_metatype c1; /* outTypeA */
} BackendDAEUtil_traverseAlgorithmExps_rettype;
DLLExport
BackendDAEUtil_traverseAlgorithmExps_rettype omc_BackendDAEUtil_traverseAlgorithmExps(threadData_t *threadData, modelica_metatype _inAlgorithm, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseAlgorithmExps omc_BackendDAEUtil_traverseAlgorithmExps

typedef struct BackendDAEUtil_traverseAlgorithmExpsWithUpdate_rettype_s {
  modelica_metatype c1; /* outAlgorithm */
  modelica_metatype c2; /* outTypeA */
} BackendDAEUtil_traverseAlgorithmExpsWithUpdate_rettype;
DLLExport
BackendDAEUtil_traverseAlgorithmExpsWithUpdate_rettype omc_BackendDAEUtil_traverseAlgorithmExpsWithUpdate(threadData_t *threadData, modelica_metatype _inAlgorithm, modelica_fnptr func, modelica_metatype _inTypeA);
#define boxptr_BackendDAEUtil_traverseAlgorithmExpsWithUpdate omc_BackendDAEUtil_traverseAlgorithmExpsWithUpdate

typedef struct BackendDAEUtil_getSolvedSystem_rettype_s {
  modelica_metatype c1; /* outSODE */
} BackendDAEUtil_getSolvedSystem_rettype;
DLLExport
BackendDAEUtil_getSolvedSystem_rettype omc_BackendDAEUtil_getSolvedSystem(threadData_t *threadData, modelica_metatype _inDAE, modelica_metatype _strPreOptModules, modelica_metatype _strmatchingAlgorithm, modelica_metatype _strdaeHandler, modelica_metatype _strPostOptModules);
#define boxptr_BackendDAEUtil_getSolvedSystem omc_BackendDAEUtil_getSolvedSystem

typedef struct BackendDAEUtil_preOptimizeBackendDAE_rettype_s {
  modelica_metatype c1; /* outDAE */
} BackendDAEUtil_preOptimizeBackendDAE_rettype;
DLLExport
BackendDAEUtil_preOptimizeBackendDAE_rettype omc_BackendDAEUtil_preOptimizeBackendDAE(threadData_t *threadData, modelica_metatype _inDAE, modelica_metatype _strPreOptModules);
#define boxptr_BackendDAEUtil_preOptimizeBackendDAE omc_BackendDAEUtil_preOptimizeBackendDAE

typedef struct BackendDAEUtil_preOptimizeDAE_rettype_s {
  modelica_metatype c1; /* outDAE */
  modelica_metatype c2; /* status */
} BackendDAEUtil_preOptimizeDAE_rettype;
DLLExport
BackendDAEUtil_preOptimizeDAE_rettype omc_BackendDAEUtil_preOptimizeDAE(threadData_t *threadData, modelica_metatype _inDAE, modelica_metatype _optModules);
#define boxptr_BackendDAEUtil_preOptimizeDAE omc_BackendDAEUtil_preOptimizeDAE

typedef struct BackendDAEUtil_transformBackendDAE_rettype_s {
  modelica_metatype c1; /* outDAE */
} BackendDAEUtil_transformBackendDAE_rettype;
DLLExport
BackendDAEUtil_transformBackendDAE_rettype omc_BackendDAEUtil_transformBackendDAE(threadData_t *threadData, modelica_metatype _inDAE, modelica_metatype _inMatchingOptions, modelica_metatype _strmatchingAlgorithm, modelica_metatype _strindexReductionMethod);
#define boxptr_BackendDAEUtil_transformBackendDAE omc_BackendDAEUtil_transformBackendDAE

typedef struct BackendDAEUtil_causalizeDAE_rettype_s {
  modelica_metatype c1; /* outDAE */
} BackendDAEUtil_causalizeDAE_rettype;
DLLExport
BackendDAEUtil_causalizeDAE_rettype omc_BackendDAEUtil_causalizeDAE(threadData_t *threadData, modelica_metatype _inDAE, modelica_metatype _inMatchingOptions, modelica_metatype _matchingAlgorithm, modelica_metatype _stateDeselection, modelica_boolean _dolateinline);
typedef struct BackendDAEUtil_causalizeDAE_rettypeboxed_s {
  modelica_metatype c1; /* outDAE */
} BackendDAEUtil_causalizeDAE_rettypeboxed;
DLLExport
BackendDAEUtil_causalizeDAE_rettypeboxed boxptr_BackendDAEUtil_causalizeDAE(threadData_t *threadData, modelica_metatype _inDAE, modelica_metatype _inMatchingOptions, modelica_metatype _matchingAlgorithm, modelica_metatype _stateDeselection, modelica_metatype _dolateinline);
typedef struct BackendDAEUtil_mapCausalizeDAE_rettype_s {
  modelica_metatype c1; /* osysts */
  modelica_metatype c2; /* oshared */
  modelica_metatype c3; /* oargs */
  modelica_boolean c4; /* oCausalized */
} BackendDAEUtil_mapCausalizeDAE_rettype;
DLLExport
BackendDAEUtil_mapCausalizeDAE_rettype omc_BackendDAEUtil_mapCausalizeDAE(threadData_t *threadData, modelica_metatype _isysts, modelica_metatype _ishared, modelica_metatype _inMatchingOptions, modelica_metatype _matchingAlgorithm, modelica_metatype _stateDeselection, modelica_metatype _acc, modelica_metatype _acc1, modelica_boolean _iCausalized);
typedef struct BackendDAEUtil_mapCausalizeDAE_rettypeboxed_s {
  modelica_metatype c1; /* osysts */
  modelica_metatype c2; /* oshared */
  modelica_metatype c3; /* oargs */
  modelica_metatype c4; /* oCausalized */
} BackendDAEUtil_mapCausalizeDAE_rettypeboxed;
DLLExport
BackendDAEUtil_mapCausalizeDAE_rettypeboxed boxptr_BackendDAEUtil_mapCausalizeDAE(threadData_t *threadData, modelica_metatype _isysts, modelica_metatype _ishared, modelica_metatype _inMatchingOptions, modelica_metatype _matchingAlgorithm, modelica_metatype _stateDeselection, modelica_metatype _acc, modelica_metatype _acc1, modelica_metatype _iCausalized);
typedef struct BackendDAEUtil_causalizeDAEWork_rettype_s {
  modelica_metatype c1; /* osyst */
  modelica_metatype c2; /* oshared */
  modelica_metatype c3; /* oArg */
  modelica_boolean c4; /* oCausalized */
} BackendDAEUtil_causalizeDAEWork_rettype;
DLLExport
BackendDAEUtil_causalizeDAEWork_rettype omc_BackendDAEUtil_causalizeDAEWork(threadData_t *threadData, modelica_metatype _isyst, modelica_metatype _ishared, modelica_metatype _inMatchingOptions, modelica_metatype _matchingAlgorithm, modelica_metatype _stateDeselection, modelica_boolean _iCausalized);
typedef struct BackendDAEUtil_causalizeDAEWork_rettypeboxed_s {
  modelica_metatype c1; /* osyst */
  modelica_metatype c2; /* oshared */
  modelica_metatype c3; /* oArg */
  modelica_metatype c4; /* oCausalized */
} BackendDAEUtil_causalizeDAEWork_rettypeboxed;
DLLExport
BackendDAEUtil_causalizeDAEWork_rettypeboxed boxptr_BackendDAEUtil_causalizeDAEWork(threadData_t *threadData, modelica_metatype _isyst, modelica_metatype _ishared, modelica_metatype _inMatchingOptions, modelica_metatype _matchingAlgorithm, modelica_metatype _stateDeselection, modelica_metatype _iCausalized);
typedef struct BackendDAEUtil_stateDeselectionDAE_rettype_s {
  modelica_metatype c1; /* outDAE */
} BackendDAEUtil_stateDeselectionDAE_rettype;
DLLExport
BackendDAEUtil_stateDeselectionDAE_rettype omc_BackendDAEUtil_stateDeselectionDAE(threadData_t *threadData, modelica_boolean _causalized, modelica_metatype _inDAE, modelica_metatype _args, modelica_metatype _stateDeselection);
typedef struct BackendDAEUtil_stateDeselectionDAE_rettypeboxed_s {
  modelica_metatype c1; /* outDAE */
} BackendDAEUtil_stateDeselectionDAE_rettypeboxed;
DLLExport
BackendDAEUtil_stateDeselectionDAE_rettypeboxed boxptr_BackendDAEUtil_stateDeselectionDAE(threadData_t *threadData, modelica_metatype _causalized, modelica_metatype _inDAE, modelica_metatype _args, modelica_metatype _stateDeselection);
typedef struct BackendDAEUtil_mapSortEqnsDAE_rettype_s {
  modelica_metatype c1; /* osysts */
  modelica_metatype c2; /* oshared */
} BackendDAEUtil_mapSortEqnsDAE_rettype;
DLLExport
BackendDAEUtil_mapSortEqnsDAE_rettype omc_BackendDAEUtil_mapSortEqnsDAE(threadData_t *threadData, modelica_metatype _isysts, modelica_metatype _ishared, modelica_metatype _acc);
#define boxptr_BackendDAEUtil_mapSortEqnsDAE omc_BackendDAEUtil_mapSortEqnsDAE

typedef struct BackendDAEUtil_sortEqnsDAEWork_rettype_s {
  modelica_metatype c1; /* osyst */
  modelica_metatype c2; /* oshared */
} BackendDAEUtil_sortEqnsDAEWork_rettype;
DLLExport
BackendDAEUtil_sortEqnsDAEWork_rettype omc_BackendDAEUtil_sortEqnsDAEWork(threadData_t *threadData, modelica_metatype _isyst, modelica_metatype _ishared);
#define boxptr_BackendDAEUtil_sortEqnsDAEWork omc_BackendDAEUtil_sortEqnsDAEWork


DLLExport
void omc_BackendDAEUtil_dumpStrongComponents(threadData_t *threadData, modelica_metatype _isyst, modelica_metatype _ishared);
#define boxptr_BackendDAEUtil_dumpStrongComponents omc_BackendDAEUtil_dumpStrongComponents

typedef struct BackendDAEUtil_postOptimizeDAE_rettype_s {
  modelica_metatype c1; /* outDAE */
  modelica_metatype c2; /* status */
} BackendDAEUtil_postOptimizeDAE_rettype;
DLLExport
BackendDAEUtil_postOptimizeDAE_rettype omc_BackendDAEUtil_postOptimizeDAE(threadData_t *threadData, modelica_metatype _inDAE, modelica_metatype _optModules, modelica_metatype _matchingAlgorithm, modelica_metatype _daeHandler);
#define boxptr_BackendDAEUtil_postOptimizeDAE omc_BackendDAEUtil_postOptimizeDAE

typedef struct BackendDAEUtil_getSolvedSystemforJacobians_rettype_s {
  modelica_metatype c1; /* outSODE */
} BackendDAEUtil_getSolvedSystemforJacobians_rettype;
DLLExport
BackendDAEUtil_getSolvedSystemforJacobians_rettype omc_BackendDAEUtil_getSolvedSystemforJacobians(threadData_t *threadData, modelica_metatype _inDAE, modelica_metatype _strPreOptModules, modelica_metatype _strmatchingAlgorithm, modelica_metatype _strdaeHandler, modelica_metatype _strpostOptModules);
#define boxptr_BackendDAEUtil_getSolvedSystemforJacobians omc_BackendDAEUtil_getSolvedSystemforJacobians

typedef struct BackendDAEUtil_getIndexReductionMethodString_rettype_s {
  modelica_metatype c1; /* strIndexReductionMethod */
} BackendDAEUtil_getIndexReductionMethodString_rettype;
DLLExport
BackendDAEUtil_getIndexReductionMethodString_rettype omc_BackendDAEUtil_getIndexReductionMethodString(threadData_t *threadData);
#define boxptr_BackendDAEUtil_getIndexReductionMethodString omc_BackendDAEUtil_getIndexReductionMethodString

typedef struct BackendDAEUtil_getIndexReductionMethod_rettype_s {
  modelica_metatype c1; /* IndexReductionMethod */
} BackendDAEUtil_getIndexReductionMethod_rettype;
DLLExport
BackendDAEUtil_getIndexReductionMethod_rettype omc_BackendDAEUtil_getIndexReductionMethod(threadData_t *threadData, modelica_metatype _ostrIndexReductionMethod);
#define boxptr_BackendDAEUtil_getIndexReductionMethod omc_BackendDAEUtil_getIndexReductionMethod

typedef struct BackendDAEUtil_selectIndexReductionMethod_rettype_s {
  modelica_metatype c1; /* outIndexReductionMethod */
} BackendDAEUtil_selectIndexReductionMethod_rettype;
DLLExport
BackendDAEUtil_selectIndexReductionMethod_rettype omc_BackendDAEUtil_selectIndexReductionMethod(threadData_t *threadData, modelica_metatype _strIndexReductionMethod, modelica_metatype _inIndexReductionMethods);
#define boxptr_BackendDAEUtil_selectIndexReductionMethod omc_BackendDAEUtil_selectIndexReductionMethod

typedef struct BackendDAEUtil_getMatchingAlgorithmString_rettype_s {
  modelica_metatype c1; /* strMatchingAlgorithm */
} BackendDAEUtil_getMatchingAlgorithmString_rettype;
DLLExport
BackendDAEUtil_getMatchingAlgorithmString_rettype omc_BackendDAEUtil_getMatchingAlgorithmString(threadData_t *threadData);
#define boxptr_BackendDAEUtil_getMatchingAlgorithmString omc_BackendDAEUtil_getMatchingAlgorithmString

typedef struct BackendDAEUtil_getMatchingAlgorithm_rettype_s {
  modelica_metatype c1; /* matchingAlgorithm */
} BackendDAEUtil_getMatchingAlgorithm_rettype;
DLLExport
BackendDAEUtil_getMatchingAlgorithm_rettype omc_BackendDAEUtil_getMatchingAlgorithm(threadData_t *threadData, modelica_metatype _ostrMatchingAlgorithm);
#define boxptr_BackendDAEUtil_getMatchingAlgorithm omc_BackendDAEUtil_getMatchingAlgorithm

typedef struct BackendDAEUtil_selectMatchingAlgorithm_rettype_s {
  modelica_metatype c1; /* outMatchingAlgorithm */
} BackendDAEUtil_selectMatchingAlgorithm_rettype;
DLLExport
BackendDAEUtil_selectMatchingAlgorithm_rettype omc_BackendDAEUtil_selectMatchingAlgorithm(threadData_t *threadData, modelica_metatype _strMatchingAlgorithm, modelica_metatype _inMatchingAlgorithms);
#define boxptr_BackendDAEUtil_selectMatchingAlgorithm omc_BackendDAEUtil_selectMatchingAlgorithm

typedef struct BackendDAEUtil_getPreOptModulesString_rettype_s {
  modelica_metatype c1; /* strPreOptModules */
} BackendDAEUtil_getPreOptModulesString_rettype;
DLLExport
BackendDAEUtil_getPreOptModulesString_rettype omc_BackendDAEUtil_getPreOptModulesString(threadData_t *threadData);
#define boxptr_BackendDAEUtil_getPreOptModulesString omc_BackendDAEUtil_getPreOptModulesString

typedef struct BackendDAEUtil_getPreOptModules_rettype_s {
  modelica_metatype c1; /* preOptModules */
} BackendDAEUtil_getPreOptModules_rettype;
DLLExport
BackendDAEUtil_getPreOptModules_rettype omc_BackendDAEUtil_getPreOptModules(threadData_t *threadData, modelica_metatype _ostrPreOptModules);
#define boxptr_BackendDAEUtil_getPreOptModules omc_BackendDAEUtil_getPreOptModules

typedef struct BackendDAEUtil_getPostOptModulesString_rettype_s {
  modelica_metatype c1; /* strpostOptModules */
} BackendDAEUtil_getPostOptModulesString_rettype;
DLLExport
BackendDAEUtil_getPostOptModulesString_rettype omc_BackendDAEUtil_getPostOptModulesString(threadData_t *threadData);
#define boxptr_BackendDAEUtil_getPostOptModulesString omc_BackendDAEUtil_getPostOptModulesString

typedef struct BackendDAEUtil_getPostOptModules_rettype_s {
  modelica_metatype c1; /* postOptModules */
} BackendDAEUtil_getPostOptModules_rettype;
DLLExport
BackendDAEUtil_getPostOptModules_rettype omc_BackendDAEUtil_getPostOptModules(threadData_t *threadData, modelica_metatype _ostrpostOptModules);
#define boxptr_BackendDAEUtil_getPostOptModules omc_BackendDAEUtil_getPostOptModules

typedef struct BackendDAEUtil_selectOptModules_rettype_s {
  modelica_metatype c1; /* outOptModules */
} BackendDAEUtil_selectOptModules_rettype;
DLLExport
BackendDAEUtil_selectOptModules_rettype omc_BackendDAEUtil_selectOptModules(threadData_t *threadData, modelica_metatype _strOptModules, modelica_metatype _inOptModules, modelica_metatype _accumulator);
#define boxptr_BackendDAEUtil_selectOptModules omc_BackendDAEUtil_selectOptModules

typedef struct BackendDAEUtil_selectOptModules1_rettype_s {
  modelica_metatype c1; /* outOptModule */
} BackendDAEUtil_selectOptModules1_rettype;
DLLExport
BackendDAEUtil_selectOptModules1_rettype omc_BackendDAEUtil_selectOptModules1(threadData_t *threadData, modelica_metatype _strOptModule, modelica_metatype _inOptModules);
#define boxptr_BackendDAEUtil_selectOptModules1 omc_BackendDAEUtil_selectOptModules1


DLLExport
void omc_BackendDAEUtil_profilerinit(threadData_t *threadData);
#define boxptr_BackendDAEUtil_profilerinit omc_BackendDAEUtil_profilerinit


DLLExport
void omc_BackendDAEUtil_profilerresults(threadData_t *threadData);
#define boxptr_BackendDAEUtil_profilerresults omc_BackendDAEUtil_profilerresults

typedef struct BackendDAEUtil_profilertime1_rettype_s {
  modelica_real c1; /* t1 */
} BackendDAEUtil_profilertime1_rettype;
DLLExport
BackendDAEUtil_profilertime1_rettype omc_BackendDAEUtil_profilertime1(threadData_t *threadData);
typedef struct BackendDAEUtil_profilertime1_rettypeboxed_s {
  modelica_metatype c1; /* t1 */
} BackendDAEUtil_profilertime1_rettypeboxed;
DLLExport
BackendDAEUtil_profilertime1_rettypeboxed boxptr_BackendDAEUtil_profilertime1(threadData_t *threadData);
typedef struct BackendDAEUtil_profilertime2_rettype_s {
  modelica_real c1; /* t2 */
} BackendDAEUtil_profilertime2_rettype;
DLLExport
BackendDAEUtil_profilertime2_rettype omc_BackendDAEUtil_profilertime2(threadData_t *threadData);
typedef struct BackendDAEUtil_profilertime2_rettypeboxed_s {
  modelica_metatype c1; /* t2 */
} BackendDAEUtil_profilertime2_rettypeboxed;
DLLExport
BackendDAEUtil_profilertime2_rettypeboxed boxptr_BackendDAEUtil_profilertime2(threadData_t *threadData);

DLLExport
void omc_BackendDAEUtil_profilerstart1(threadData_t *threadData);
#define boxptr_BackendDAEUtil_profilerstart1 omc_BackendDAEUtil_profilerstart1


DLLExport
void omc_BackendDAEUtil_profilerstart2(threadData_t *threadData);
#define boxptr_BackendDAEUtil_profilerstart2 omc_BackendDAEUtil_profilerstart2


DLLExport
void omc_BackendDAEUtil_profilerstop1(threadData_t *threadData);
#define boxptr_BackendDAEUtil_profilerstop1 omc_BackendDAEUtil_profilerstop1


DLLExport
void omc_BackendDAEUtil_profilerstop2(threadData_t *threadData);
#define boxptr_BackendDAEUtil_profilerstop2 omc_BackendDAEUtil_profilerstop2


DLLExport
void omc_BackendDAEUtil_profilerreset1(threadData_t *threadData);
#define boxptr_BackendDAEUtil_profilerreset1 omc_BackendDAEUtil_profilerreset1


DLLExport
void omc_BackendDAEUtil_profilerreset2(threadData_t *threadData);
#define boxptr_BackendDAEUtil_profilerreset2 omc_BackendDAEUtil_profilerreset2

typedef struct BackendDAEUtil_profilertock1_rettype_s {
  modelica_real c1; /* t */
} BackendDAEUtil_profilertock1_rettype;
DLLExport
BackendDAEUtil_profilertock1_rettype omc_BackendDAEUtil_profilertock1(threadData_t *threadData);
typedef struct BackendDAEUtil_profilertock1_rettypeboxed_s {
  modelica_metatype c1; /* t */
} BackendDAEUtil_profilertock1_rettypeboxed;
DLLExport
BackendDAEUtil_profilertock1_rettypeboxed boxptr_BackendDAEUtil_profilertock1(threadData_t *threadData);
typedef struct BackendDAEUtil_mapEqSystem1_rettype_s {
  modelica_metatype c1; /* odae */
} BackendDAEUtil_mapEqSystem1_rettype;
DLLExport
BackendDAEUtil_mapEqSystem1_rettype omc_BackendDAEUtil_mapEqSystem1(threadData_t *threadData, modelica_metatype _dae, modelica_fnptr func, modelica_metatype _a);
#define boxptr_BackendDAEUtil_mapEqSystem1 omc_BackendDAEUtil_mapEqSystem1

typedef struct BackendDAEUtil_mapEqSystemAndFold1_rettype_s {
  modelica_metatype c1; /* odae */
  modelica_metatype c2; /* extra */
} BackendDAEUtil_mapEqSystemAndFold1_rettype;
DLLExport
BackendDAEUtil_mapEqSystemAndFold1_rettype omc_BackendDAEUtil_mapEqSystemAndFold1(threadData_t *threadData, modelica_metatype _dae, modelica_fnptr func, modelica_metatype _a, modelica_metatype _initialExtra);
#define boxptr_BackendDAEUtil_mapEqSystemAndFold1 omc_BackendDAEUtil_mapEqSystemAndFold1

typedef struct BackendDAEUtil_mapEqSystemAndFold_rettype_s {
  modelica_metatype c1; /* odae */
  modelica_metatype c2; /* extra */
} BackendDAEUtil_mapEqSystemAndFold_rettype;
DLLExport
BackendDAEUtil_mapEqSystemAndFold_rettype omc_BackendDAEUtil_mapEqSystemAndFold(threadData_t *threadData, modelica_metatype _dae, modelica_fnptr func, modelica_metatype _initialExtra);
#define boxptr_BackendDAEUtil_mapEqSystemAndFold omc_BackendDAEUtil_mapEqSystemAndFold

typedef struct BackendDAEUtil_foldEqSystem_rettype_s {
  modelica_metatype c1; /* extra */
} BackendDAEUtil_foldEqSystem_rettype;
DLLExport
BackendDAEUtil_foldEqSystem_rettype omc_BackendDAEUtil_foldEqSystem(threadData_t *threadData, modelica_metatype _dae, modelica_fnptr func, modelica_metatype _initialExtra);
#define boxptr_BackendDAEUtil_foldEqSystem omc_BackendDAEUtil_foldEqSystem

typedef struct BackendDAEUtil_mapEqSystem_rettype_s {
  modelica_metatype c1; /* odae */
} BackendDAEUtil_mapEqSystem_rettype;
DLLExport
BackendDAEUtil_mapEqSystem_rettype omc_BackendDAEUtil_mapEqSystem(threadData_t *threadData, modelica_metatype _dae, modelica_fnptr func);
#define boxptr_BackendDAEUtil_mapEqSystem omc_BackendDAEUtil_mapEqSystem

typedef struct BackendDAEUtil_nonEmptySystem_rettype_s {
  modelica_boolean c1; /* nonEmpty */
} BackendDAEUtil_nonEmptySystem_rettype;
DLLExport
BackendDAEUtil_nonEmptySystem_rettype omc_BackendDAEUtil_nonEmptySystem(threadData_t *threadData, modelica_metatype _syst);
typedef struct BackendDAEUtil_nonEmptySystem_rettypeboxed_s {
  modelica_metatype c1; /* nonEmpty */
} BackendDAEUtil_nonEmptySystem_rettypeboxed;
DLLExport
BackendDAEUtil_nonEmptySystem_rettypeboxed boxptr_BackendDAEUtil_nonEmptySystem(threadData_t *threadData, modelica_metatype _syst);
typedef struct BackendDAEUtil_setEqSystemMatching_rettype_s {
  modelica_metatype c1; /* osyst */
} BackendDAEUtil_setEqSystemMatching_rettype;
DLLExport
BackendDAEUtil_setEqSystemMatching_rettype omc_BackendDAEUtil_setEqSystemMatching(threadData_t *threadData, modelica_metatype _syst, modelica_metatype _matching);
#define boxptr_BackendDAEUtil_setEqSystemMatching omc_BackendDAEUtil_setEqSystemMatching

typedef struct BackendDAEUtil_filterEmptySystems_rettype_s {
  modelica_metatype c1; /* osysts */
} BackendDAEUtil_filterEmptySystems_rettype;
DLLExport
BackendDAEUtil_filterEmptySystems_rettype omc_BackendDAEUtil_filterEmptySystems(threadData_t *threadData, modelica_metatype _systs);
#define boxptr_BackendDAEUtil_filterEmptySystems omc_BackendDAEUtil_filterEmptySystems

typedef struct BackendDAEUtil_filterEmptySystems2_rettype_s {
  modelica_metatype c1; /* olst */
} BackendDAEUtil_filterEmptySystems2_rettype;
DLLExport
BackendDAEUtil_filterEmptySystems2_rettype omc_BackendDAEUtil_filterEmptySystems2(threadData_t *threadData, modelica_metatype _systs, modelica_metatype _full);
#define boxptr_BackendDAEUtil_filterEmptySystems2 omc_BackendDAEUtil_filterEmptySystems2

typedef struct BackendDAEUtil_getAllVarLst_rettype_s {
  modelica_metatype c1; /* varLst */
} BackendDAEUtil_getAllVarLst_rettype;
DLLExport
BackendDAEUtil_getAllVarLst_rettype omc_BackendDAEUtil_getAllVarLst(threadData_t *threadData, modelica_metatype _dae);
#define boxptr_BackendDAEUtil_getAllVarLst omc_BackendDAEUtil_getAllVarLst

typedef struct BackendDAEUtil_getAlgorithms_rettype_s {
  modelica_metatype c1; /* algs */
} BackendDAEUtil_getAlgorithms_rettype;
DLLExport
BackendDAEUtil_getAlgorithms_rettype omc_BackendDAEUtil_getAlgorithms(threadData_t *threadData, modelica_metatype _dae);
#define boxptr_BackendDAEUtil_getAlgorithms omc_BackendDAEUtil_getAlgorithms

typedef struct BackendDAEUtil_collectAlgorithmsFromEqSystem_rettype_s {
  modelica_metatype c1; /* oalglst */
} BackendDAEUtil_collectAlgorithmsFromEqSystem_rettype;
DLLExport
BackendDAEUtil_collectAlgorithmsFromEqSystem_rettype omc_BackendDAEUtil_collectAlgorithmsFromEqSystem(threadData_t *threadData, modelica_metatype _syst, modelica_metatype _alglst);
#define boxptr_BackendDAEUtil_collectAlgorithmsFromEqSystem omc_BackendDAEUtil_collectAlgorithmsFromEqSystem

typedef struct BackendDAEUtil_collectAlgorithms_rettype_s {
  modelica_metatype c1; /* outTpl */
} BackendDAEUtil_collectAlgorithms_rettype;
DLLExport
BackendDAEUtil_collectAlgorithms_rettype omc_BackendDAEUtil_collectAlgorithms(threadData_t *threadData, modelica_metatype _inTpl);
#define boxptr_BackendDAEUtil_collectAlgorithms omc_BackendDAEUtil_collectAlgorithms
#ifdef __cplusplus
extern "C" {
#endif
#include "Absyn.h"
#include "Algorithm.h"
#include "BackendDAECreate.h"
#include "BackendDAEOptimize.h"
#include "BackendDAETransform.h"
#include "BackendDAEUtil.h"
#include "BackendDump.h"
#include "BackendEquation.h"
#include "BackendVarTransform.h"
#include "BackendVariable.h"
#include "BinaryTree.h"
#include "Causalize.h"
#include "Ceval.h"
#include "CheckModel.h"
#include "ComponentReference.h"
#include "Config.h"
#include "DAEDump.h"
#include "DAEUtil.h"
#include "Debug.h"
#include "Derive.h"
#include "Env.h"
#include "Error.h"
#include "EvaluateParameter.h"
#include "Expression.h"
#include "ExpressionDump.h"
#include "ExpressionSimplify.h"
#include "Flags.h"
#include "IndexReduction.h"
#include "Inline.h"
#include "List.h"
#include "Matching.h"
#include "OnRelaxation.h"
#include "RemoveSimpleEquations.h"
#include "System.h"
#include "Tearing.h"
#include "Types.h"
#include "Util.h"
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
}
#endif
#endif

