encapsulated package CodegenCppHpcom
"
  file:        CodegenCppHpcom.mo
  package:     CodegenCppHpcom
  description: Generated by Susan.
"

public import Tpl;

public import SimCodeVar;
public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import SCodeDump;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCodeMain;
public import HpcOmSimCode;
public import HpcOmMemory;
public import HpcOmScheduler;
public import CodegenUtil;
public import CodegenCpp;

protected function fun_37
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;

    case ( txt,
           false,
           a_simCode )
      equation
        txt = simulationMainFile(txt, a_simCode);
      then txt;

    case ( txt,
           _,
           a_simCode )
      equation
        txt = simulationMainFileAnalyzation(txt, a_simCode);
      then txt;
  end match;
end fun_37;

protected function lm_38
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_hpcOmMemory, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> i_eqs;
      Boolean ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           (i_eqs, _, _) :: rest,
           a_hpcOmMemory,
           a_simCode )
      equation
        ret_0 = Util.isSome(a_hpcOmMemory);
        txt = CodegenCpp.algloopfiles(txt, i_eqs, a_simCode, SimCode.contextAlgloopJacobian, ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_38(txt, rest, a_hpcOmMemory, a_simCode);
      then txt;
  end match;
end lm_38;

protected function lm_39
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_hpcOmMemory, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCode.SimCode a_simCode;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           (i_mat, _, _, _, _, _, _) :: rest,
           a_hpcOmMemory,
           a_simCode )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_38(txt, i_mat, a_hpcOmMemory, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_39(txt, rest, a_hpcOmMemory, a_simCode);
      then txt;
  end match;
end lm_39;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      list<String> i_externalFunctionIncludes;
      list<DAE.Exp> i_literals;
      list<SimCode.Function> i_modelInfo_functions;
      Option<HpcOmSimCode.MemoryMap> i_hpcOmMemory;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_59;
      Tpl.Text txt_58;
      Tpl.Text txt_57;
      Tpl.Text txt_56;
      list<SimCode.SimEqSystem> ret_55;
      Boolean ret_54;
      list<SimCode.SimEqSystem> ret_53;
      Tpl.Text l_alg;
      Tpl.Text l_jac;
      Tpl.Text txt_50;
      Tpl.Text txt_49;
      Tpl.Text txt_48;
      Tpl.Text txt_47;
      Tpl.Text txt_46;
      Tpl.Text txt_45;
      Boolean ret_44;
      Tpl.Text txt_43;
      Tpl.Text txt_42;
      Tpl.Text txt_41;
      Tpl.Text txt_40;
      Tpl.Text txt_39;
      Tpl.Text txt_38;
      Tpl.Text txt_37;
      Tpl.Text txt_36;
      Tpl.Text txt_35;
      Tpl.Text txt_34;
      Boolean ret_33;
      Tpl.Text txt_32;
      Tpl.Text txt_31;
      Boolean ret_30;
      Tpl.Text txt_29;
      Tpl.Text txt_28;
      Tpl.Text txt_27;
      Tpl.Text txt_26;
      Boolean ret_25;
      Tpl.Text txt_24;
      Tpl.Text txt_23;
      Tpl.Text txt_22;
      Tpl.Text txt_21;
      Tpl.Text txt_20;
      Tpl.Text txt_19;
      Tpl.Text txt_18;
      Tpl.Text txt_17;
      Tpl.Text txt_16;
      Tpl.Text txt_15;
      Tpl.Text txt_14;
      Tpl.Text txt_13;
      Boolean ret_12;
      Tpl.Text txt_11;
      Tpl.Text txt_10;
      Boolean ret_9;
      Tpl.Text txt_8;
      Boolean ret_7;
      Tpl.Text txt_6;
      Boolean ret_5;
      Tpl.Text txt_4;
      Tpl.Text txt_2;
      Boolean ret_2;
      String ret_1;
      Tpl.Text l_target;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = i_modelInfo_functions), makefileParams = SimCode.MAKEFILE_PARAMS(ccompiler = _), fileNamePrefix = i_fileNamePrefix, hpcOmMemory = i_hpcOmMemory, literals = i_literals, externalFunctionIncludes = i_externalFunctionIncludes, jacobianMatrixes = i_jacobianMatrixes, allEquations = i_allEquations, initialEquations = i_initialEquations)),
           a_useFlatArrayNotation )
      equation
        ret_1 = Config.simulationCodeTarget();
        l_target = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_2 = Flags.isSet(Flags.HPCOM_ANALYZATION_MODE);
        txt_2 = fun_37(Tpl.emptyTxt, ret_2, i_simCode);
        txt_4 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_4 = Tpl.writeStr(txt_4, i_fileNamePrefix);
        txt_4 = Tpl.writeTok(txt_4, Tpl.ST_STRING("Main.cpp"));
        Tpl.textFile(txt_2, Tpl.textString(txt_4));
        ret_5 = Util.isSome(i_hpcOmMemory);
        txt_6 = generateAdditionalIncludes(Tpl.emptyTxt, i_simCode, ret_5);
        ret_7 = Util.isSome(i_hpcOmMemory);
        txt_8 = generateAdditionalProtectedMemberDeclaration(Tpl.emptyTxt, i_simCode, ret_7);
        ret_9 = Util.isSome(i_hpcOmMemory);
        txt_10 = CodegenCpp.simulationHeaderFile(Tpl.emptyTxt, i_simCode, Tpl.textString(txt_6), Tpl.textString(txt_8), false, ret_9);
        txt_11 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_11 = Tpl.writeStr(txt_11, i_fileNamePrefix);
        txt_11 = Tpl.writeTok(txt_11, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_10, Tpl.textString(txt_11));
        ret_12 = Util.isSome(i_hpcOmMemory);
        txt_13 = simulationCppFile(Tpl.emptyTxt, i_simCode, ret_12);
        txt_14 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_14 = Tpl.writeStr(txt_14, i_fileNamePrefix);
        txt_14 = Tpl.writeTok(txt_14, Tpl.ST_STRING(".cpp"));
        Tpl.textFile(txt_13, Tpl.textString(txt_14));
        txt_15 = CodegenCpp.simulationFunctionsHeaderFile(Tpl.emptyTxt, i_simCode, i_modelInfo_functions, i_literals, false);
        txt_16 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_16 = Tpl.writeStr(txt_16, i_fileNamePrefix);
        txt_16 = Tpl.writeTok(txt_16, Tpl.ST_STRING("Functions.h"));
        Tpl.textFile(txt_15, Tpl.textString(txt_16));
        txt_17 = CodegenCpp.simulationFunctionsFile(Tpl.emptyTxt, i_simCode, i_modelInfo_functions, i_literals, i_externalFunctionIncludes, false);
        txt_18 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_18 = Tpl.writeStr(txt_18, i_fileNamePrefix);
        txt_18 = Tpl.writeTok(txt_18, Tpl.ST_STRING("Functions.cpp"));
        Tpl.textFile(txt_17, Tpl.textString(txt_18));
        txt_19 = CodegenCpp.simulationTypesHeaderFile(Tpl.emptyTxt, i_simCode, i_modelInfo_functions, i_literals, a_useFlatArrayNotation);
        txt_20 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_20 = Tpl.writeStr(txt_20, i_fileNamePrefix);
        txt_20 = Tpl.writeTok(txt_20, Tpl.ST_STRING("Types.h"));
        Tpl.textFile(txt_19, Tpl.textString(txt_20));
        txt_21 = simulationMakefile(Tpl.emptyTxt, Tpl.textString(l_target), i_simCode);
        txt_22 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_22 = Tpl.writeTok(txt_22, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_21, Tpl.textString(txt_22));
        txt_23 = CodegenCpp.simulationInitHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_24 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_24 = Tpl.writeStr(txt_24, i_fileNamePrefix);
        txt_24 = Tpl.writeTok(txt_24, Tpl.ST_STRING("Initialize.h"));
        Tpl.textFile(txt_23, Tpl.textString(txt_24));
        ret_25 = Util.isSome(i_hpcOmMemory);
        txt_26 = CodegenCpp.simulationInitCppFile(Tpl.emptyTxt, i_simCode, ret_25);
        txt_27 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_27 = Tpl.writeStr(txt_27, i_fileNamePrefix);
        txt_27 = Tpl.writeTok(txt_27, Tpl.ST_STRING("Initialize.cpp"));
        Tpl.textFile(txt_26, Tpl.textString(txt_27));
        txt_28 = CodegenCpp.simulationJacobianHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_29 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_29 = Tpl.writeStr(txt_29, i_fileNamePrefix);
        txt_29 = Tpl.writeTok(txt_29, Tpl.ST_STRING("Jacobian.h"));
        Tpl.textFile(txt_28, Tpl.textString(txt_29));
        ret_30 = Util.isSome(i_hpcOmMemory);
        txt_31 = CodegenCpp.simulationJacobianCppFile(Tpl.emptyTxt, i_simCode, ret_30);
        txt_32 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_32 = Tpl.writeStr(txt_32, i_fileNamePrefix);
        txt_32 = Tpl.writeTok(txt_32, Tpl.ST_STRING("Jacobian.cpp"));
        Tpl.textFile(txt_31, Tpl.textString(txt_32));
        ret_33 = Util.isSome(i_hpcOmMemory);
        txt_34 = CodegenCpp.simulationStateSelectionCppFile(Tpl.emptyTxt, i_simCode, ret_33);
        txt_35 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_35 = Tpl.writeStr(txt_35, i_fileNamePrefix);
        txt_35 = Tpl.writeTok(txt_35, Tpl.ST_STRING("StateSelection.cpp"));
        Tpl.textFile(txt_34, Tpl.textString(txt_35));
        txt_36 = CodegenCpp.simulationStateSelectionHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_37 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_37 = Tpl.writeStr(txt_37, i_fileNamePrefix);
        txt_37 = Tpl.writeTok(txt_37, Tpl.ST_STRING("StateSelection.h"));
        Tpl.textFile(txt_36, Tpl.textString(txt_37));
        txt_38 = CodegenCpp.simulationExtensionHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_39 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_39 = Tpl.writeStr(txt_39, i_fileNamePrefix);
        txt_39 = Tpl.writeTok(txt_39, Tpl.ST_STRING("Extension.h"));
        Tpl.textFile(txt_38, Tpl.textString(txt_39));
        txt_40 = CodegenCpp.simulationExtensionCppFile(Tpl.emptyTxt, i_simCode);
        txt_41 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_41 = Tpl.writeStr(txt_41, i_fileNamePrefix);
        txt_41 = Tpl.writeTok(txt_41, Tpl.ST_STRING("Extension.cpp"));
        Tpl.textFile(txt_40, Tpl.textString(txt_41));
        txt_42 = CodegenCpp.simulationWriteOutputHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_43 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_43 = Tpl.writeStr(txt_43, i_fileNamePrefix);
        txt_43 = Tpl.writeTok(txt_43, Tpl.ST_STRING("WriteOutput.h"));
        Tpl.textFile(txt_42, Tpl.textString(txt_43));
        ret_44 = Util.isSome(i_hpcOmMemory);
        txt_45 = CodegenCpp.simulationWriteOutputCppFile(Tpl.emptyTxt, i_simCode, ret_44);
        txt_46 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_46 = Tpl.writeStr(txt_46, i_fileNamePrefix);
        txt_46 = Tpl.writeTok(txt_46, Tpl.ST_STRING("WriteOutput.cpp"));
        Tpl.textFile(txt_45, Tpl.textString(txt_46));
        txt_47 = CodegenCpp.simulationFactoryFile(Tpl.emptyTxt, i_simCode);
        txt_48 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_48 = Tpl.writeStr(txt_48, i_fileNamePrefix);
        txt_48 = Tpl.writeTok(txt_48, Tpl.ST_STRING("FactoryExport.cpp"));
        Tpl.textFile(txt_47, Tpl.textString(txt_48));
        txt_49 = simulationMainRunScript(Tpl.emptyTxt, i_simCode);
        txt_50 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_50 = CodegenCpp.simulationMainRunScriptSuffix(txt_50, i_simCode);
        Tpl.textFile(txt_49, Tpl.textString(txt_50));
        l_jac = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_jac = lm_39(l_jac, i_jacobianMatrixes, i_hpcOmMemory, i_simCode);
        l_jac = Tpl.popIter(l_jac);
        ret_53 = listAppend(i_allEquations, i_initialEquations);
        ret_54 = Util.isSome(i_hpcOmMemory);
        l_alg = CodegenCpp.algloopfiles(Tpl.emptyTxt, ret_53, i_simCode, SimCode.contextAlgloop, ret_54);
        ret_55 = listAppend(i_allEquations, i_initialEquations);
        txt_56 = CodegenCpp.algloopMainfile(Tpl.emptyTxt, ret_55, i_simCode, SimCode.contextAlgloop);
        txt_57 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_57 = Tpl.writeStr(txt_57, i_fileNamePrefix);
        txt_57 = Tpl.writeTok(txt_57, Tpl.ST_STRING("AlgLoopMain.cpp"));
        Tpl.textFile(txt_56, Tpl.textString(txt_57));
        txt_58 = CodegenCpp.calcHelperMainfile(Tpl.emptyTxt, i_simCode);
        txt_59 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_59 = Tpl.writeStr(txt_59, i_fileNamePrefix);
        txt_59 = Tpl.writeTok(txt_59, Tpl.ST_STRING("CalcHelperMain.cpp"));
        Tpl.textFile(txt_58, Tpl.textString(txt_59));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end translateModel;

public function Update
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_allEquations;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(allEquations = i_allEquations, whenClauses = i_whenClauses)),
           a_useFlatArrayNotation )
      equation
        txt = update(txt, i_allEquations, i_whenClauses, i_simCode, SimCode.contextOther, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end Update;

protected function fun_42
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "   #ifdef ANALYZATION_MODE\n",
                                    "    #include <boost/shared_ptr.hpp>\n",
                                    "    #include <boost/weak_ptr.hpp>\n",
                                    "    #include <boost/numeric/ublas/vector.hpp>\n",
                                    "    #include <boost/numeric/ublas/matrix.hpp>\n",
                                    "    #include <string>\n",
                                    "    #include <vector>\n",
                                    "    #include <map>\n",
                                    "    using std::string;\n",
                                    "    using std::vector;\n",
                                    "    using std::map;\n",
                                    "    #include <SimCoreFactory/Policies/FactoryConfig.h>\n",
                                    "    #include <SimController/ISimController.h>\n",
                                    "    #include <System/IMixedSystem.h>\n",
                                    "\n",
                                    "    #include <boost/numeric/ublas/matrix_sparse.hpp>\n",
                                    "    typedef uBlas::compressed_matrix<double, uBlas::column_major, 0, uBlas::unbounded_array<int>, uBlas::unbounded_array<double> > SparseMatrix;\n",
                                    "   #endif\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = generateHpcomSpecificIncludes(txt, i_simCode);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_42;

public function generateAdditionalIncludes
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_42(txt, a_simCode);
end generateAdditionalIncludes;

protected function fun_44
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "openmp" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return (long unsigned int)omp_get_thread_num();"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "boost::hash<std::string> string_hash;\n",
                                    "return (long unsigned int)string_hash(boost::lexical_cast<std::string>(boost::this_thread::get_id()));"
                                }, false));
      then txt;
  end match;
end fun_44;

protected function fun_45
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* std::vector<MeasureTimeData> measureTimeArrayHpcom;\n",
                                    "MeasureTimeValues *measuredStartValuesODE, *measuredEndValuesODE; */"
                                }, false));
      then txt;
  end match;
end fun_45;

public function generateAdditionalProtectedMemberDeclaration
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.ModelInfo i_modelInfo;
      Option<HpcOmSimCode.MemoryMap> i_hpcOmMemory;
      Option<HpcOmSimCode.Schedule> i_hpcOmSchedule;
      Boolean ret_8;
      Boolean ret_7;
      String ret_6;
      String str_5;
      String ret_4;
      Tpl.Text l_type;
      Tpl.Text l_addHpcomArrayHeaders;
      Tpl.Text l_addHpcomVarHeaders;
      Tpl.Text l_addHpcomFunctionHeaders;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = _)), hpcOmSchedule = i_hpcOmSchedule, hpcOmMemory = i_hpcOmMemory),
           a_useFlatArrayNotation )
      equation
        l_addHpcomFunctionHeaders = getAddHpcomFunctionHeaders(Tpl.emptyTxt, i_hpcOmSchedule);
        l_addHpcomVarHeaders = getAddHpcomVarHeaders(Tpl.emptyTxt, i_hpcOmSchedule);
        l_addHpcomArrayHeaders = getAddHpcomVarArrays(Tpl.emptyTxt, i_hpcOmMemory);
        ret_4 = Flags.getConfigString(Flags.HPCOM_CODE);
        l_type = Tpl.writeStr(Tpl.emptyTxt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// HPCOM\n",
                                    "#ifdef __GNUC__\n",
                                    "    #define VARARRAY_ALIGN_PRE\n",
                                    "    #define VARARRAY_ALIGN_POST __attribute__((aligned(0x40)))\n",
                                    "#else\n",
                                    "    #define VARARRAY_ALIGN_PRE __declspec(align(64))\n",
                                    "    #define VARARRAY_ALIGN_POST\n",
                                    "#endif\n",
                                    "\n",
                                    "static long unsigned int getThreadNumber()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        str_5 = Tpl.textString(l_type);
        txt = fun_44(txt, str_5);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_addHpcomFunctionHeaders);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_addHpcomArrayHeaders);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_addHpcomVarHeaders);
        txt = Tpl.softNewLine(txt);
        txt = MemberVariable(txt, i_modelInfo, i_hpcOmMemory, a_useFlatArrayNotation, false);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_6 = Flags.getConfigString(Flags.PROFILING_LEVEL);
        ret_7 = stringEq(ret_6, "none");
        ret_8 = boolNot(ret_7);
        txt = fun_45(txt, ret_8);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end generateAdditionalProtectedMemberDeclaration;

protected function fun_47
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "openmp" )
      then txt;

    case ( txt,
           "tbb" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "struct VoidBody {\n",
                                    "    boost::function<void(void)> void_function;\n",
                                    "    VoidBody(boost::function<void(void)> void_function) : void_function(void_function) { }\n",
                                    "    void operator()( tbb::flow::continue_msg ) const\n",
                                    "    {\n",
                                    "        void_function();\n",
                                    "    }\n",
                                    "};"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_47;

protected function fun_48
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.Schedule> in_a_hpcOmScheduleOpt;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmScheduleOpt, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_type;
      String str_0;

    case ( txt,
           SOME(HpcOmSimCode.TASKDEPSCHEDULE(tasks = _)),
           a_type )
      equation
        str_0 = Tpl.textString(a_type);
        txt = fun_47(txt, str_0);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_48;

public function getAddHpcomStructHeaders
  input Tpl.Text txt;
  input Option<HpcOmSimCode.Schedule> a_hpcOmScheduleOpt;

  output Tpl.Text out_txt;
protected
  String ret_1;
  Tpl.Text l_type;
algorithm
  ret_1 := Flags.getConfigString(Flags.HPCOM_CODE);
  l_type := Tpl.writeStr(Tpl.emptyTxt, ret_1);
  out_txt := fun_48(txt, a_hpcOmScheduleOpt, l_type);
end getAddHpcomStructHeaders;

protected function lm_50
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void evaluateThreadFunc"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("();"));
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;
  end match;
end lm_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void evaluateThreadFunc"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("();"));
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;
  end match;
end lm_51;

protected function fun_52
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      list<Integer> ret_4;
      Integer ret_3;
      list<Integer> ret_2;
      Integer ret_1;
      Tpl.Text l_threadFuncs;

    case ( txt,
           "pthreads" )
      equation
        ret_1 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_2 = List.intRange(ret_1);
        l_threadFuncs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadFuncs = lm_50(l_threadFuncs, ret_2);
        l_threadFuncs = Tpl.popIter(l_threadFuncs);
        txt = Tpl.writeText(txt, l_threadFuncs);
      then txt;

    case ( txt,
           "pthreads_spin" )
      equation
        ret_3 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_4 = List.intRange(ret_3);
        l_threadFuncs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadFuncs = lm_51(l_threadFuncs, ret_4);
        l_threadFuncs = Tpl.popIter(l_threadFuncs);
        txt = Tpl.writeText(txt, l_threadFuncs);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_52;

protected function lm_53
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      Tpl.Text a_type;
      HpcOmSimCode.Task i_task;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_task :: rest,
           a_type )
      equation
        txt = createLockByDepTask(txt, i_task, "lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest, a_type);
      then txt;
  end match;
end lm_53;

protected function lm_54
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = generateThreadFunctionHeaderDecl(txt, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_54(txt, rest);
      then txt;
  end match;
end lm_54;

protected function fun_55
  input Tpl.Text in_txt;
  input String in_mArg;
  input array<list<HpcOmSimCode.Task>> in_a_hpcOmSchedule_threadTasks;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_hpcOmSchedule_threadTasks)
    local
      Tpl.Text txt;
      array<list<HpcOmSimCode.Task>> a_hpcOmSchedule_threadTasks;
      list<list<HpcOmSimCode.Task>> ret_1;
      Tpl.Text l_headers;

    case ( txt,
           "openmp",
           _ )
      then txt;

    case ( txt,
           _,
           a_hpcOmSchedule_threadTasks )
      equation
        ret_1 = arrayList(a_hpcOmSchedule_threadTasks);
        l_headers = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_headers = lm_54(l_headers, ret_1);
        l_headers = Tpl.popIter(l_headers);
        txt = Tpl.writeText(txt, l_headers);
      then txt;
  end match;
end fun_55;

protected function lm_56
  input Tpl.Text in_txt;
  input list<tuple<HpcOmSimCode.Task, list<Integer>>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<HpcOmSimCode.Task, list<Integer>>> rest;
      tuple<HpcOmSimCode.Task, list<Integer>> i_task;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_task :: rest )
      equation
        txt = getAddHpcomFuncHeadersTaskDep(txt, i_task);
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest);
      then txt;
  end match;
end lm_56;

protected function fun_57
  input Tpl.Text in_txt;
  input String in_mArg;
  input Option<HpcOmSimCode.Schedule> in_a_hpcOmScheduleOpt;
  input list<tuple<HpcOmSimCode.Task, list<Integer>>> in_a_hpcOmSchedule_tasks;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_hpcOmScheduleOpt, in_a_hpcOmSchedule_tasks)
    local
      Tpl.Text txt;
      Option<HpcOmSimCode.Schedule> a_hpcOmScheduleOpt;
      list<tuple<HpcOmSimCode.Task, list<Integer>>> a_hpcOmSchedule_tasks;
      Tpl.Text l_voidfuncs;

    case ( txt,
           "openmp",
           _,
           _ )
      then txt;

    case ( txt,
           "tbb",
           a_hpcOmScheduleOpt,
           a_hpcOmSchedule_tasks )
      equation
        l_voidfuncs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_voidfuncs = lm_56(l_voidfuncs, a_hpcOmSchedule_tasks);
        l_voidfuncs = Tpl.popIter(l_voidfuncs);
        txt = getAddHpcomStructHeaders(txt, a_hpcOmScheduleOpt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_voidfuncs);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_57;

protected function fun_58
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.Schedule> in_a_hpcOmScheduleOpt;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmScheduleOpt, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_type;
      Option<HpcOmSimCode.Schedule> i_hpcOmScheduleOpt;
      list<tuple<HpcOmSimCode.Task, list<Integer>>> i_hpcOmSchedule_tasks;
      array<list<HpcOmSimCode.Task>> i_hpcOmSchedule_threadTasks;
      list<HpcOmSimCode.Task> i_hpcOmSchedule_outgoingDepTasks;
      String str_3;
      String str_2;
      Tpl.Text l_locks;
      String str_0;

    case ( txt,
           SOME(HpcOmSimCode.LEVELSCHEDULE(useFixedAssignments = true)),
           a_type )
      equation
        str_0 = Tpl.textString(a_type);
        txt = fun_52(txt, str_0);
      then txt;

    case ( txt,
           SOME(HpcOmSimCode.THREADSCHEDULE(outgoingDepTasks = i_hpcOmSchedule_outgoingDepTasks, threadTasks = i_hpcOmSchedule_threadTasks)),
           a_type )
      equation
        l_locks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_locks = lm_53(l_locks, i_hpcOmSchedule_outgoingDepTasks, a_type);
        l_locks = Tpl.popIter(l_locks);
        str_2 = Tpl.textString(a_type);
        txt = fun_55(txt, str_2, i_hpcOmSchedule_threadTasks);
      then txt;

    case ( txt,
           (i_hpcOmScheduleOpt as SOME(HpcOmSimCode.TASKDEPSCHEDULE(tasks = i_hpcOmSchedule_tasks))),
           a_type )
      equation
        str_3 = Tpl.textString(a_type);
        txt = fun_57(txt, str_3, i_hpcOmScheduleOpt, i_hpcOmSchedule_tasks);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_58;

public function getAddHpcomFunctionHeaders
  input Tpl.Text txt;
  input Option<HpcOmSimCode.Schedule> a_hpcOmScheduleOpt;

  output Tpl.Text out_txt;
protected
  String ret_1;
  Tpl.Text l_type;
algorithm
  ret_1 := Flags.getConfigString(Flags.HPCOM_CODE);
  l_type := Tpl.writeStr(Tpl.emptyTxt, ret_1);
  out_txt := fun_58(txt, a_hpcOmScheduleOpt, l_type);
end getAddHpcomFunctionHeaders;

protected function fun_60
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_floatArraySize;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_floatArraySize)
    local
      Tpl.Text txt;
      Integer a_floatArraySize;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_floatArraySize )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("VARARRAY_ALIGN_PRE double varArray1["));
        txt = Tpl.writeStr(txt, intString(a_floatArraySize));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] VARARRAY_ALIGN_POST ; //float variables"));
      then txt;
  end match;
end fun_60;

protected function fun_61
  input Tpl.Text in_txt;
  input HpcOmSimCode.MemoryMap in_a_hpcomMemoryMap;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcomMemoryMap)
    local
      Tpl.Text txt;
      Integer i_floatArraySize;
      Boolean ret_0;

    case ( txt,
           HpcOmSimCode.MEMORYMAP_ARRAY(floatArraySize = i_floatArraySize) )
      equation
        ret_0 = intGt(i_floatArraySize, 0);
        txt = fun_60(txt, ret_0, i_floatArraySize);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_61;

public function getAddHpcomVarArrays
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.MemoryMap> in_a_optHpcomMemoryMap;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_optHpcomMemoryMap)
    local
      Tpl.Text txt;
      HpcOmSimCode.MemoryMap i_hpcomMemoryMap;

    case ( txt,
           SOME(i_hpcomMemoryMap) )
      equation
        txt = fun_61(txt, i_hpcomMemoryMap);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getAddHpcomVarArrays;

protected function lm_63
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = generateThreadHeaderDecl(txt, x_i0, Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_63(txt, rest, a_type);
      then txt;
  end match;
end lm_63;

protected function lm_64
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = generateThreadHeaderDecl(txt, x_i0, Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_64(txt, rest, a_type);
      then txt;
  end match;
end lm_64;

protected function fun_65
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_type;
      Integer ret_9;
      Integer ret_8;
      Integer ret_7;
      list<Integer> ret_6;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      list<Integer> ret_1;
      Integer ret_0;

    case ( txt,
           "pthreads",
           a_type )
      equation
        ret_0 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_1 = List.intRange(ret_0);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_63(txt, ret_1, a_type);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        ret_2 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_3 = intAdd(1, ret_2);
        txt = createBarrierByName(txt, "evaluateBarrier", "", ret_3, Tpl.textString(a_type));
        txt = Tpl.softNewLine(txt);
        ret_4 = Flags.getConfigInt(Flags.NUM_PROC);
        txt = createBarrierByName(txt, "levelBarrier", "", ret_4, Tpl.textString(a_type));
        txt = Tpl.softNewLine(txt);
        txt = createLockByLockName(txt, "measureTimeArrayLock", "", Tpl.textString(a_type));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "bool _simulationFinished;\n",
                                    "UPDATETYPE _command;"
                                }, false));
      then txt;

    case ( txt,
           "pthreads_spin",
           a_type )
      equation
        ret_5 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_6 = List.intRange(ret_5);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_64(txt, ret_6, a_type);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        ret_7 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_8 = intAdd(1, ret_7);
        txt = createBarrierByName(txt, "evaluateBarrier", "", ret_8, Tpl.textString(a_type));
        txt = Tpl.softNewLine(txt);
        ret_9 = Flags.getConfigInt(Flags.NUM_PROC);
        txt = createBarrierByName(txt, "levelBarrier", "", ret_9, Tpl.textString(a_type));
        txt = Tpl.softNewLine(txt);
        txt = createLockByLockName(txt, "measureTimeArrayLock", "", Tpl.textString(a_type));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "bool _simulationFinished;\n",
                                    "UPDATETYPE _command;"
                                }, false));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_65;

protected function lm_66
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      Tpl.Text a_type;
      HpcOmSimCode.Task i_task;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_task :: rest,
           a_type )
      equation
        txt = createLockByDepTask(txt, i_task, "lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_66(txt, rest, a_type);
      then txt;
  end match;
end lm_66;

protected function lm_67
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = generateThreadHeaderDecl(txt, x_i0, Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_67(txt, rest, a_type);
      then txt;
  end match;
end lm_67;

protected function lm_68
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = createLockByLockName(txt, intString(x_i0), "th_lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_68(txt, rest, a_type);
      then txt;
  end match;
end lm_68;

protected function lm_69
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = createLockByLockName(txt, intString(x_i0), "th_lock1", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_69(txt, rest, a_type);
      then txt;
  end match;
end lm_69;

protected function fun_70
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_type;
  input array<list<HpcOmSimCode.Task>> in_a_hpcOmSchedule_threadTasks;
  input Tpl.Text in_a_threadDecl;
  input Tpl.Text in_a_locks;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_type, in_a_hpcOmSchedule_threadTasks, in_a_threadDecl, in_a_locks)
    local
      Tpl.Text txt;
      Tpl.Text a_type;
      array<list<HpcOmSimCode.Task>> a_hpcOmSchedule_threadTasks;
      Tpl.Text a_threadDecl;
      Tpl.Text a_locks;
      list<list<HpcOmSimCode.Task>> ret_3;
      Tpl.Text l_thLocks1;
      list<list<HpcOmSimCode.Task>> ret_1;
      Tpl.Text l_thLocks;

    case ( txt,
           "openmp",
           _,
           _,
           a_threadDecl,
           a_locks )
      equation
        txt = Tpl.writeText(txt, a_locks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_threadDecl);
      then txt;

    case ( txt,
           "mpi",
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//BLABLUB"));
      then txt;

    case ( txt,
           _,
           a_type,
           a_hpcOmSchedule_threadTasks,
           a_threadDecl,
           a_locks )
      equation
        ret_1 = arrayList(a_hpcOmSchedule_threadTasks);
        l_thLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_thLocks = lm_68(l_thLocks, ret_1, a_type);
        l_thLocks = Tpl.popIter(l_thLocks);
        ret_3 = arrayList(a_hpcOmSchedule_threadTasks);
        l_thLocks1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_thLocks1 = lm_69(l_thLocks1, ret_3, a_type);
        l_thLocks1 = Tpl.popIter(l_thLocks1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "bool terminateThreads;\n",
                                    "UPDATETYPE command;\n"
                                }, true));
        txt = Tpl.writeText(txt, a_locks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_thLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_thLocks1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_threadDecl);
      then txt;
  end match;
end fun_70;

protected function fun_71
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "openmp" )
      then txt;

    case ( txt,
           "tbb" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    tbb::flow::graph tbb_graph;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_71;

protected function fun_72
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.Schedule> in_a_hpcOmScheduleOpt;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmScheduleOpt, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_type;
      array<list<HpcOmSimCode.Task>> i_hpcOmSchedule_threadTasks;
      list<HpcOmSimCode.Task> i_hpcOmSchedule_outgoingDepTasks;
      String str_5;
      String str_4;
      list<list<HpcOmSimCode.Task>> ret_3;
      Tpl.Text l_threadDecl;
      Tpl.Text l_locks;
      String str_0;

    case ( txt,
           SOME(HpcOmSimCode.LEVELSCHEDULE(useFixedAssignments = true)),
           a_type )
      equation
        str_0 = Tpl.textString(a_type);
        txt = fun_65(txt, str_0, a_type);
      then txt;

    case ( txt,
           SOME(HpcOmSimCode.THREADSCHEDULE(outgoingDepTasks = i_hpcOmSchedule_outgoingDepTasks, threadTasks = i_hpcOmSchedule_threadTasks)),
           a_type )
      equation
        l_locks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_locks = lm_66(l_locks, i_hpcOmSchedule_outgoingDepTasks, a_type);
        l_locks = Tpl.popIter(l_locks);
        ret_3 = arrayList(i_hpcOmSchedule_threadTasks);
        l_threadDecl = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadDecl = lm_67(l_threadDecl, ret_3, a_type);
        l_threadDecl = Tpl.popIter(l_threadDecl);
        str_4 = Tpl.textString(a_type);
        txt = fun_70(txt, str_4, a_type, i_hpcOmSchedule_threadTasks, l_threadDecl, l_locks);
      then txt;

    case ( txt,
           SOME(HpcOmSimCode.TASKDEPSCHEDULE(tasks = _)),
           a_type )
      equation
        str_5 = Tpl.textString(a_type);
        txt = fun_71(txt, str_5);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_72;

public function getAddHpcomVarHeaders
  input Tpl.Text txt;
  input Option<HpcOmSimCode.Schedule> a_hpcOmScheduleOpt;

  output Tpl.Text out_txt;
protected
  String ret_1;
  Tpl.Text l_type;
algorithm
  ret_1 := Flags.getConfigString(Flags.HPCOM_CODE);
  l_type := Tpl.writeStr(Tpl.emptyTxt, ret_1);
  out_txt := fun_72(txt, a_hpcOmScheduleOpt, l_type);
end getAddHpcomVarHeaders;

public function getAddHpcomFuncHeadersTaskDep
  input Tpl.Text in_txt;
  input tuple<HpcOmSimCode.Task, list<Integer>> in_a_taskIn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_taskIn)
    local
      Tpl.Text txt;
      Integer i_task_index;

    case ( txt,
           (HpcOmSimCode.CALCTASK(index = i_task_index), _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void task_func_"));
        txt = Tpl.writeStr(txt, intString(i_task_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("();"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getAddHpcomFuncHeadersTaskDep;

protected function fun_75
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "openmp" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include <omp.h>"));
      then txt;

    case ( txt,
           "pthreads" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include <boost/smart_ptr/detail/spinlock.hpp>\n",
                                    "#include <boost/thread/mutex.hpp>\n",
                                    "#include <boost/thread.hpp>\n",
                                    "#include <boost/thread/barrier.hpp>"
                                }, false));
      then txt;

    case ( txt,
           "pthreads_spin" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include <boost/smart_ptr/detail/spinlock.hpp>\n",
                                    "#include <boost/thread/mutex.hpp>\n",
                                    "#include <boost/thread.hpp>\n",
                                    "#include <boost/thread/barrier.hpp>"
                                }, false));
      then txt;

    case ( txt,
           "tbb" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include <tbb/tbb.h>\n",
                                    "#include <tbb/flow_graph.h>\n",
                                    "#include <boost/function.hpp>\n",
                                    "#include <boost/bind.hpp>"
                                }, false));
      then txt;

    case ( txt,
           "mpi" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include <mpi.h>"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include <boost/thread/mutex.hpp>\n",
                                    "#include <boost/thread.hpp>"
                                }, false));
      then txt;
  end match;
end fun_75;

public function generateHpcomSpecificIncludes
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  String str_2;
  String ret_1;
  Tpl.Text l_type;
algorithm
  ret_1 := Flags.getConfigString(Flags.HPCOM_CODE);
  l_type := Tpl.writeStr(Tpl.emptyTxt, ret_1);
  str_2 := Tpl.textString(l_type);
  out_txt := fun_75(txt, str_2);
end generateHpcomSpecificIncludes;

protected function fun_77
  input Tpl.Text in_txt;
  input String in_a_iType;
  input Integer in_a_threadIdx;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_threadIdx)
    local
      Tpl.Text txt;
      Integer a_threadIdx;

    case ( txt,
           "openmp",
           _ )
      then txt;

    case ( txt,
           _,
           a_threadIdx )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::thread* evaluateThread"));
        txt = Tpl.writeStr(txt, intString(a_threadIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_77;

public function generateThreadHeaderDecl
  input Tpl.Text txt;
  input Integer a_threadIdx;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_77(txt, a_iType, a_threadIdx);
end generateThreadHeaderDecl;

public function generateThreadFunctionHeaderDecl
  input Tpl.Text txt;
  input Integer a_threadIdx;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("void evaluateThreadFunc"));
  out_txt := Tpl.writeStr(out_txt, intString(a_threadIdx));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("();"));
end generateThreadFunctionHeaderDecl;

protected function fun_80
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.SimEqSystem> in_a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_allEquations)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquations;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_allEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimResidues="));
        txt = CodegenCpp.numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_80;

protected function fun_81
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Absyn.Path in_a_modelInfo_name;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_modelInfo_name, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path a_modelInfo_name;
      SimCode.SimCode a_simCode;
      Integer ret_1;
      Tpl.Text l_numOfEqs;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_modelInfo_name,
           a_simCode )
      equation
        ret_1 = SimCodeUtil.getMaxSimEqSystemIndex(a_simCode);
        l_numOfEqs = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("measureTimeProfileBlocksArray = std::vector<MeasureTimeData>("));
        txt = Tpl.writeText(txt, l_numOfEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "MeasureTime::addResultContentBlock(\""
                                }, false));
        txt = CodegenUtil.dotPath(txt, a_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\",\"profileBlocks\",&measureTimeProfileBlocksArray);\n",
                                    "measureTimeFunctionsArray = std::vector<MeasureTimeData>(3); //1 evaluateODE ; 2 evaluateAll; 3 writeOutput\n",
                                    "MeasureTime::addResultContentBlock(\""
                                }, false));
        txt = CodegenUtil.dotPath(txt, a_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\",\"functions\",&measureTimeFunctionsArray);\n",
                                    "measuredProfileBlockStartValues = MeasureTime::getZeroValues();\n",
                                    "measuredProfileBlockEndValues = MeasureTime::getZeroValues();\n",
                                    "measuredFunctionStartValues = MeasureTime::getZeroValues();\n",
                                    "measuredFunctionEndValues = MeasureTime::getZeroValues();\n",
                                    "\n",
                                    "for(int i = 0; i < "
                                }, false));
        txt = Tpl.writeText(txt, l_numOfEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "; i++)\n",
                                    "{\n",
                                    "    ostringstream ss;\n",
                                    "    ss << i;\n",
                                    "    measureTimeProfileBlocksArray[i] = MeasureTimeData(ss.str());\n",
                                    "}\n",
                                    "\n",
                                    "measureTimeFunctionsArray[0] = MeasureTimeData(\"evaluateODE\");\n",
                                    "measureTimeFunctionsArray[1] = MeasureTimeData(\"evaluateAll\");\n",
                                    "measureTimeFunctionsArray[2] = MeasureTimeData(\"writeOutput\");"
                                }, false));
      then txt;
  end match;
end fun_81;

public function simulationCppFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      list<String> i_modelInfo_labels;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<BackendDAE.TimeEvent> i_timeEvents;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<DAE.ComponentRef> i_discreteModelVars;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.SimCode i_simCode;
      Option<HpcOmSimCode.MemoryMap> i_hpcOmMemory;
      SimCode.ModelInfo i_modelInfo;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;
      Option<HpcOmSimCode.Schedule> i_hpcOmSchedule;
      list<SimCode.SimEqSystem> ret_12;
      list<SimCode.SimEqSystem> ret_11;
      Boolean ret_10;
      Boolean ret_9;
      String ret_8;
      Boolean ret_7;
      Tpl.Text l_className;
      String ret_5;
      Tpl.Text l_type;
      Tpl.Text l_hpcomDestructorExtension;
      Tpl.Text l_hpcomMemberVariableDefinition;
      Tpl.Text txt_1;
      Tpl.Text l_hpcomConstructorExtension;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name, labels = i_modelInfo_labels)), hpcOmSchedule = i_hpcOmSchedule, fileNamePrefix = i_fileNamePrefix, hpcOmMemory = i_hpcOmMemory, allEquations = i_allEquations, discreteModelVars = i_discreteModelVars, zeroCrossings = i_zeroCrossings, initialEquations = i_initialEquations, timeEvents = i_timeEvents, whenClauses = i_whenClauses)),
           a_useFlatArrayNotation )
      equation
        txt_1 = CodegenCpp.lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_hpcomConstructorExtension = getHpcomConstructorExtension(Tpl.emptyTxt, i_hpcOmSchedule, Tpl.textString(txt_1));
        l_hpcomMemberVariableDefinition = getHpcomMemberVariableDefinition(Tpl.emptyTxt, i_hpcOmSchedule);
        l_hpcomDestructorExtension = getHpcomDestructorExtension(Tpl.emptyTxt, i_hpcOmSchedule);
        ret_5 = Flags.getConfigString(Flags.HPCOM_CODE);
        l_type = Tpl.writeStr(Tpl.emptyTxt, ret_5);
        l_className = CodegenCpp.lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " #include <Core/Modelica.h>\n",
                                    " #include <Core/ModelicaDefine.h>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Functions.h\"\n",
                                    "\n",
                                    " /* Constructor */\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_className);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::"));
        txt = Tpl.writeText(txt, l_className);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(IGlobalSettings* globalSettings,boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory,boost::shared_ptr<ISimData> simData)\n",
                                    "    :SystemDefaultImplementation(globalSettings)\n",
                                    "    ,_algLoopSolverFactory(nonlinsolverfactory)\n",
                                    "    ,_simData(simData)\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_hpcomMemberVariableDefinition);
        txt = Tpl.softNewLine(txt);
        txt = MemberVariable(txt, i_modelInfo, i_hpcOmMemory, a_useFlatArrayNotation, true);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.simulationInitFile(txt, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "//I don\'t know why this line is necessary if we link statically, but without it a segfault occurs\n",
                                    "_global_settings = globalSettings;\n",
                                    "//Number of equations\n"
                                }, true));
        txt = CodegenCpp.dimension1(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimZeroFunc= "));
        txt = CodegenCpp.zerocrosslength(txt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "_dimTimeEvent = "
                                }, false));
        txt = CodegenCpp.timeeventlength(txt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "//Number of residues\n"
                                }, true));
        ret_7 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_80(txt, ret_7, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        ret_8 = Flags.getConfigString(Flags.PROFILING_LEVEL);
        ret_9 = stringEq(ret_8, "none");
        ret_10 = boolNot(ret_9);
        txt = fun_81(txt, ret_10, i_modelInfo_name, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//DAE\'s are not supported yet, Index reduction is enabled\n",
                                    "_dimAE = 0; // algebraic equations\n",
                                    "//Initialize the state vector\n",
                                    "SystemDefaultImplementation::initialize();\n",
                                    "//Instantiate auxiliary object for event handling functionality\n",
                                    "_event_handling.getCondition =  boost::bind(&"
                                }, false));
        txt = Tpl.writeText(txt, l_className);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getCondition, this, _1);\n",
                                    " //Todo: arrayReindex(modelInfo,useFlatArrayNotation)\n",
                                    "//Initialize array elements\n"
                                }, true));
        txt = CodegenCpp.initializeArrayElements(txt, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "_functions = new Functions(_simTime,__z,__zDot,_initial,_terminate);\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_hpcomConstructorExtension);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "}\n"
                                }, true));
        txt = CodegenCpp.lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::~"));
        txt = CodegenCpp.lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "()\n",
                                    "{\n",
                                    "    if(_functions != NULL)\n",
                                    "        delete _functions;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_hpcomDestructorExtension);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Update(txt, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = CodegenCpp.DefaultImplementationCode(txt, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.checkForDiscreteEvents(txt, i_discreteModelVars, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.giveZeroFunc1(txt, i_zeroCrossings, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.setConditions(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.geConditions(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.isConsistent(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        ret_11 = listAppend(i_allEquations, i_initialEquations);
        txt = CodegenCpp.generateStepCompleted(txt, ret_11, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.generatehandleTimeEvent(txt, i_timeEvents, i_simCode);
        txt = Tpl.softNewLine(txt);
        ret_12 = listAppend(i_allEquations, i_initialEquations);
        txt = CodegenCpp.generateDimTimeEvent(txt, ret_12, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.generateTimeEvent(txt, i_timeEvents, i_simCode, false);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = CodegenCpp.isODE(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.DimZeroFunc(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = CodegenCpp.getCondition(txt, i_zeroCrossings, i_whenClauses, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.handleSystemEvents(txt, i_zeroCrossings, i_whenClauses, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.saveall(txt, i_modelInfo, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.initPrevars(txt, i_modelInfo, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.savediscreteVars(txt, i_modelInfo, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = CodegenCpp.LabeledDAE(txt, i_modelInfo_labels, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = CodegenCpp.giveVariables(txt, i_modelInfo, a_useFlatArrayNotation, i_simCode);
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end simulationCppFile;

protected function fun_83
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_type;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           "pthreads",
           a_type )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",_command(IContinuous::UNDEF_UPDATE)\n",
                                    ",_simulationFinished(false)\n",
                                    ","
                                }, false));
        ret_0 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_1 = intAdd(1, ret_0);
        txt = initializeBarrierByName(txt, "evaluateBarrier", "", ret_1, Tpl.textString(a_type));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_2 = Flags.getConfigInt(Flags.NUM_PROC);
        txt = initializeBarrierByName(txt, "levelBarrier", "", ret_2, Tpl.textString(a_type));
      then txt;

    case ( txt,
           "pthreads_spin",
           a_type )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",_command(IContinuous::UNDEF_UPDATE)\n",
                                    ",_simulationFinished(false)\n",
                                    ","
                                }, false));
        ret_3 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_4 = intAdd(1, ret_3);
        txt = initializeBarrierByName(txt, "evaluateBarrier", "", ret_4, Tpl.textString(a_type));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_5 = Flags.getConfigInt(Flags.NUM_PROC);
        txt = initializeBarrierByName(txt, "levelBarrier", "", ret_5, Tpl.textString(a_type));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_83;

protected function fun_84
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.Schedule> in_a_hpcOmScheduleOpt;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmScheduleOpt, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_type;
      String str_0;

    case ( txt,
           SOME(HpcOmSimCode.LEVELSCHEDULE(useFixedAssignments = true)),
           a_type )
      equation
        str_0 = Tpl.textString(a_type);
        txt = fun_83(txt, str_0, a_type);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_84;

public function getHpcomMemberVariableDefinition
  input Tpl.Text txt;
  input Option<HpcOmSimCode.Schedule> a_hpcOmScheduleOpt;

  output Tpl.Text out_txt;
protected
  String ret_1;
  Tpl.Text l_type;
algorithm
  ret_1 := Flags.getConfigString(Flags.HPCOM_CODE);
  l_type := Tpl.writeStr(Tpl.emptyTxt, ret_1);
  out_txt := fun_84(txt, a_hpcOmScheduleOpt, l_type);
end getHpcomMemberVariableDefinition;

protected function lm_86
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_type)
    local
      Tpl.Text txt;
      list<Integer> rest;
      String a_modelNamePrefixStr;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_modelNamePrefixStr,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = generateThread(txt, x_i0, Tpl.textString(a_type), a_modelNamePrefixStr, "evaluateThreadFunc");
        txt = Tpl.nextIter(txt);
        txt = lm_86(txt, rest, a_modelNamePrefixStr, a_type);
      then txt;
  end match;
end lm_86;

protected function lm_87
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_type)
    local
      Tpl.Text txt;
      list<Integer> rest;
      String a_modelNamePrefixStr;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_modelNamePrefixStr,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = generateThread(txt, x_i0, Tpl.textString(a_type), a_modelNamePrefixStr, "evaluateThreadFunc");
        txt = Tpl.nextIter(txt);
        txt = lm_87(txt, rest, a_modelNamePrefixStr, a_type);
      then txt;
  end match;
end lm_87;

protected function fun_88
  input Tpl.Text in_txt;
  input String in_mArg;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_modelNamePrefixStr, in_a_type)
    local
      Tpl.Text txt;
      String a_modelNamePrefixStr;
      Tpl.Text a_type;
      list<Integer> ret_4;
      Integer ret_3;
      list<Integer> ret_2;
      Integer ret_1;
      Tpl.Text l_threadFuncs;

    case ( txt,
           "pthreads",
           a_modelNamePrefixStr,
           a_type )
      equation
        ret_1 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_2 = List.intRange(ret_1);
        l_threadFuncs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadFuncs = lm_86(l_threadFuncs, ret_2, a_modelNamePrefixStr, a_type);
        l_threadFuncs = Tpl.popIter(l_threadFuncs);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_threadFuncs);
      then txt;

    case ( txt,
           "pthreads_spin",
           a_modelNamePrefixStr,
           a_type )
      equation
        ret_3 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_4 = List.intRange(ret_3);
        l_threadFuncs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadFuncs = lm_87(l_threadFuncs, ret_4, a_modelNamePrefixStr, a_type);
        l_threadFuncs = Tpl.popIter(l_threadFuncs);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_threadFuncs);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_88;

protected function lm_89
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      Tpl.Text a_type;
      HpcOmSimCode.Task i_task;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_task :: rest,
           a_type )
      equation
        txt = initializeLockByDepTask(txt, i_task, "lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_89(txt, rest, a_type);
      then txt;
  end match;
end lm_89;

protected function lm_90
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      Tpl.Text a_type;
      HpcOmSimCode.Task i_task;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_task :: rest,
           a_type )
      equation
        txt = assignLockByDepTask(txt, i_task, "lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_90(txt, rest, a_type);
      then txt;
  end match;
end lm_90;

protected function lm_91
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      String a_modelNamePrefixStr;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_modelNamePrefixStr,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = generateThread(txt, x_i0, Tpl.textString(a_type), a_modelNamePrefixStr, "evaluateThreadFunc");
        txt = Tpl.nextIter(txt);
        txt = lm_91(txt, rest, a_modelNamePrefixStr, a_type);
      then txt;
  end match;
end lm_91;

protected function lm_92
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = initializeLockByLockName(txt, intString(x_i0), "th_lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_92(txt, rest, a_type);
      then txt;
  end match;
end lm_92;

protected function lm_93
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = initializeLockByLockName(txt, intString(x_i0), "th_lock1", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_93(txt, rest, a_type);
      then txt;
  end match;
end lm_93;

protected function lm_94
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = assignLockByLockName(txt, intString(x_i0), "th_lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_94(txt, rest, a_type);
      then txt;
  end match;
end lm_94;

protected function lm_95
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = assignLockByLockName(txt, intString(x_i0), "th_lock1", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_95(txt, rest, a_type);
      then txt;
  end match;
end lm_95;

protected function fun_96
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_assignLocks;
  input Tpl.Text in_a_type;
  input array<list<HpcOmSimCode.Task>> in_a_hpcOmSchedule_threadTasks;
  input Tpl.Text in_a_initlocks;
  input Tpl.Text in_a_threadFuncs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_assignLocks, in_a_type, in_a_hpcOmSchedule_threadTasks, in_a_initlocks, in_a_threadFuncs)
    local
      Tpl.Text txt;
      Tpl.Text a_assignLocks;
      Tpl.Text a_type;
      array<list<HpcOmSimCode.Task>> a_hpcOmSchedule_threadTasks;
      Tpl.Text a_initlocks;
      Tpl.Text a_threadFuncs;
      list<list<HpcOmSimCode.Task>> ret_7;
      Tpl.Text l_threadAssignLocks1;
      list<list<HpcOmSimCode.Task>> ret_5;
      Tpl.Text l_threadAssignLocks;
      list<list<HpcOmSimCode.Task>> ret_3;
      Tpl.Text l_threadLocksInit1;
      list<list<HpcOmSimCode.Task>> ret_1;
      Tpl.Text l_threadLocksInit;

    case ( txt,
           "openmp",
           _,
           _,
           _,
           a_initlocks,
           a_threadFuncs )
      equation
        txt = Tpl.writeText(txt, a_threadFuncs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_initlocks);
      then txt;

    case ( txt,
           "mpi",
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//MFlehmig: Initialize MPI related stuff"));
      then txt;

    case ( txt,
           _,
           a_assignLocks,
           a_type,
           a_hpcOmSchedule_threadTasks,
           a_initlocks,
           a_threadFuncs )
      equation
        ret_1 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadLocksInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadLocksInit = lm_92(l_threadLocksInit, ret_1, a_type);
        l_threadLocksInit = Tpl.popIter(l_threadLocksInit);
        ret_3 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadLocksInit1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadLocksInit1 = lm_93(l_threadLocksInit1, ret_3, a_type);
        l_threadLocksInit1 = Tpl.popIter(l_threadLocksInit1);
        ret_5 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadAssignLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadAssignLocks = lm_94(l_threadAssignLocks, ret_5, a_type);
        l_threadAssignLocks = Tpl.popIter(l_threadAssignLocks);
        ret_7 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadAssignLocks1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadAssignLocks1 = lm_95(l_threadAssignLocks1, ret_7, a_type);
        l_threadAssignLocks1 = Tpl.popIter(l_threadAssignLocks1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    terminateThreads = false;\n",
                                    "    command = IContinuous::UNDEF_UPDATE;\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_initlocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadLocksInit);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadLocksInit1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_assignLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadAssignLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadAssignLocks1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_threadFuncs);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_96;

protected function fun_97
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.Schedule> in_a_hpcOmScheduleOpt;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmScheduleOpt, in_a_modelNamePrefixStr, in_a_type)
    local
      Tpl.Text txt;
      String a_modelNamePrefixStr;
      Tpl.Text a_type;
      array<list<HpcOmSimCode.Task>> i_hpcOmSchedule_threadTasks;
      list<HpcOmSimCode.Task> i_hpcOmSchedule_outgoingDepTasks;
      String str_5;
      list<list<HpcOmSimCode.Task>> ret_4;
      Tpl.Text l_threadFuncs;
      Tpl.Text l_assignLocks;
      Tpl.Text l_initlocks;
      String str_0;

    case ( txt,
           SOME(HpcOmSimCode.LEVELSCHEDULE(useFixedAssignments = true)),
           a_modelNamePrefixStr,
           a_type )
      equation
        str_0 = Tpl.textString(a_type);
        txt = fun_88(txt, str_0, a_modelNamePrefixStr, a_type);
      then txt;

    case ( txt,
           SOME(HpcOmSimCode.THREADSCHEDULE(outgoingDepTasks = i_hpcOmSchedule_outgoingDepTasks, threadTasks = i_hpcOmSchedule_threadTasks)),
           a_modelNamePrefixStr,
           a_type )
      equation
        l_initlocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_initlocks = lm_89(l_initlocks, i_hpcOmSchedule_outgoingDepTasks, a_type);
        l_initlocks = Tpl.popIter(l_initlocks);
        l_assignLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_assignLocks = lm_90(l_assignLocks, i_hpcOmSchedule_outgoingDepTasks, a_type);
        l_assignLocks = Tpl.popIter(l_assignLocks);
        ret_4 = arrayList(i_hpcOmSchedule_threadTasks);
        l_threadFuncs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadFuncs = lm_91(l_threadFuncs, ret_4, a_modelNamePrefixStr, a_type);
        l_threadFuncs = Tpl.popIter(l_threadFuncs);
        str_5 = Tpl.textString(a_type);
        txt = fun_96(txt, str_5, l_assignLocks, a_type, i_hpcOmSchedule_threadTasks, l_initlocks, l_threadFuncs);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_97;

public function getHpcomConstructorExtension
  input Tpl.Text txt;
  input Option<HpcOmSimCode.Schedule> a_hpcOmScheduleOpt;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
protected
  String ret_1;
  Tpl.Text l_type;
algorithm
  ret_1 := Flags.getConfigString(Flags.HPCOM_CODE);
  l_type := Tpl.writeStr(Tpl.emptyTxt, ret_1);
  out_txt := fun_97(txt, a_hpcOmScheduleOpt, a_modelNamePrefixStr, l_type);
end getHpcomConstructorExtension;

protected function fun_99
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "pthreads" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_simulationFinished = true;\n",
                                    "_evaluateBarrier.wait();\n",
                                    "_evaluateBarrier.wait();"
                                }, false));
      then txt;

    case ( txt,
           "pthreads_spin" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_simulationFinished = true;\n",
                                    "_evaluateBarrier.wait();\n",
                                    "_evaluateBarrier.wait();"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_99;

protected function lm_100
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      Tpl.Text a_type;
      HpcOmSimCode.Task i_task;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_task :: rest,
           a_type )
      equation
        txt = destroyLockByDepTask(txt, i_task, "lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_100(txt, rest, a_type);
      then txt;
  end match;
end lm_100;

protected function lm_101
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_destroyThread(txt, intString(x_i0), Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_101(txt, rest, a_type);
      then txt;
  end match;
end lm_101;

protected function lm_102
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_joinThread(txt, intString(x_i0), Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_102(txt, rest, a_type);
      then txt;
  end match;
end lm_102;

protected function lm_103
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = releaseLockByLockName(txt, intString(x_i0), "th_lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_103(txt, rest, a_type);
      then txt;
  end match;
end lm_103;

protected function fun_104
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_destroyThreads;
  input Tpl.Text in_a_type;
  input array<list<HpcOmSimCode.Task>> in_a_hpcOmSchedule_threadTasks;
  input Tpl.Text in_a_destroylocks;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_destroyThreads, in_a_type, in_a_hpcOmSchedule_threadTasks, in_a_destroylocks)
    local
      Tpl.Text txt;
      Tpl.Text a_destroyThreads;
      Tpl.Text a_type;
      array<list<HpcOmSimCode.Task>> a_hpcOmSchedule_threadTasks;
      Tpl.Text a_destroylocks;
      list<list<HpcOmSimCode.Task>> ret_3;
      Tpl.Text l_threadReleaseLocks;
      list<list<HpcOmSimCode.Task>> ret_1;
      Tpl.Text l_joinThreads;

    case ( txt,
           "openmp",
           _,
           _,
           _,
           a_destroylocks )
      equation
        txt = Tpl.writeText(txt, a_destroylocks);
      then txt;

    case ( txt,
           "mpi",
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//MF: Destruct MPI related stuff - nothing at the moment."));
      then txt;

    case ( txt,
           _,
           a_destroyThreads,
           a_type,
           a_hpcOmSchedule_threadTasks,
           a_destroylocks )
      equation
        ret_1 = arrayList(a_hpcOmSchedule_threadTasks);
        l_joinThreads = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_joinThreads = lm_102(l_joinThreads, ret_1, a_type);
        l_joinThreads = Tpl.popIter(l_joinThreads);
        ret_3 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadReleaseLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadReleaseLocks = lm_103(l_threadReleaseLocks, ret_3, a_type);
        l_threadReleaseLocks = Tpl.popIter(l_threadReleaseLocks);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("terminateThreads = true;\n"));
        txt = Tpl.writeText(txt, l_threadReleaseLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_joinThreads);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_destroylocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_destroyThreads);
      then txt;
  end match;
end fun_104;

protected function fun_105
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.Schedule> in_a_hpcOmScheduleOpt;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmScheduleOpt, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_type;
      array<list<HpcOmSimCode.Task>> i_hpcOmSchedule_threadTasks;
      list<HpcOmSimCode.Task> i_hpcOmSchedule_outgoingDepTasks;
      String str_4;
      list<list<HpcOmSimCode.Task>> ret_3;
      Tpl.Text l_destroyThreads;
      Tpl.Text l_destroylocks;
      String str_0;

    case ( txt,
           SOME(HpcOmSimCode.LEVELSCHEDULE(useFixedAssignments = true)),
           a_type )
      equation
        str_0 = Tpl.textString(a_type);
        txt = fun_99(txt, str_0);
      then txt;

    case ( txt,
           SOME(HpcOmSimCode.THREADSCHEDULE(outgoingDepTasks = i_hpcOmSchedule_outgoingDepTasks, threadTasks = i_hpcOmSchedule_threadTasks)),
           a_type )
      equation
        l_destroylocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_destroylocks = lm_100(l_destroylocks, i_hpcOmSchedule_outgoingDepTasks, a_type);
        l_destroylocks = Tpl.popIter(l_destroylocks);
        ret_3 = arrayList(i_hpcOmSchedule_threadTasks);
        l_destroyThreads = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_destroyThreads = lm_101(l_destroyThreads, ret_3, a_type);
        l_destroyThreads = Tpl.popIter(l_destroyThreads);
        str_4 = Tpl.textString(a_type);
        txt = fun_104(txt, str_4, l_destroyThreads, a_type, i_hpcOmSchedule_threadTasks, l_destroylocks);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_105;

public function getHpcomDestructorExtension
  input Tpl.Text txt;
  input Option<HpcOmSimCode.Schedule> a_hpcOmScheduleOpt;

  output Tpl.Text out_txt;
protected
  String ret_1;
  Tpl.Text l_type;
algorithm
  ret_1 := Flags.getConfigString(Flags.HPCOM_CODE);
  l_type := Tpl.writeStr(Tpl.emptyTxt, ret_1);
  out_txt := fun_105(txt, a_hpcOmScheduleOpt, l_type);
end getHpcomDestructorExtension;

protected function fun_107
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.Context in_a_context;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation, in_a_context, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.Context a_context;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      list<SimCode.SimEqSystem> i_equationsForZeroCrossings;
      list<SimCode.SimEqSystem> i_allEquations;
      Option<HpcOmSimCode.Schedule> i_hpcOmSchedule;
      SimCode.SimCode i_simCode;
      list<SimCode.SimWhenClause> i_whenClauses;
      Absyn.Path i_modelInfo_name;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      Tpl.Text txt_1;
      Tpl.Text l_parCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), odeEquations = i_odeEquations, whenClauses = i_whenClauses, hpcOmSchedule = i_hpcOmSchedule, allEquations = i_allEquations, equationsForZeroCrossings = i_equationsForZeroCrossings)),
           a_useFlatArrayNotation,
           a_context,
           a_allEquationsPlusWhen )
      equation
        txt_1 = CodegenCpp.lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_parCode = update2(Tpl.emptyTxt, a_allEquationsPlusWhen, i_odeEquations, i_modelInfo_name, i_whenClauses, i_simCode, i_hpcOmSchedule, a_context, Tpl.textString(txt_1), a_useFlatArrayNotation);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = CodegenCpp.equationFunctions(txt, i_allEquations, i_whenClauses, i_simCode, SimCode.contextSimulationDiscrete, a_useFlatArrayNotation, false);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = CodegenCpp.createEvaluateAll(txt, i_allEquations, i_whenClauses, i_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = CodegenCpp.createEvaluateZeroFuncs(txt, i_equationsForZeroCrossings, i_simCode, SimCode.contextOther);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = createEvaluateConditions(txt, i_simCode, a_allEquationsPlusWhen, i_whenClauses, i_modelInfo_name, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_parCode);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_107;

public function update
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input SimCode.SimCode a_simCode;
  input SimCode.Context a_context;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  out_txt := fun_107(txt, a_simCode, a_useFlatArrayNotation, a_context, a_allEquationsPlusWhen);
end update;

protected function lm_109
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls, _) = CodegenCpp.equation_function_call(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_simCode, Tpl.strTokText(Tpl.ST_STRING("evaluate")));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_109(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_109;

protected function lm_110
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_context, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Integer x_i0;
      SimCode.SimWhenClause i_when;

    case ( txt,
           {},
           _,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_when :: rest,
           a_useFlatArrayNotation,
           a_context,
           a_simCode,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = CodegenCpp.genreinits(txt, i_when, a_varDecls, x_i0, a_simCode, a_context, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_110(txt, rest, a_useFlatArrayNotation, a_context, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_110;

protected function fun_111
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Absyn.Path in_a_name;
  input SimCode.Context in_a_context;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_name, in_a_context, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Absyn.Path a_name;
      SimCode.Context a_context;
      Boolean a_useFlatArrayNotation;
      list<SimCode.SimWhenClause> i_whenClauses;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_equationsForConditions;
      Integer ret_3;
      Tpl.Text l_reinit;
      Tpl.Text l_eqs;
      Tpl.Text l_varDecls;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(equationsForConditions = i_equationsForConditions, whenClauses = i_whenClauses)),
           a_name,
           a_context,
           a_useFlatArrayNotation )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_eqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_eqs, l_varDecls) = lm_109(l_eqs, i_equationsForConditions, i_simCode, l_varDecls);
        l_eqs = Tpl.popIter(l_eqs);
        l_reinit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_reinit, l_varDecls) = lm_110(l_reinit, i_whenClauses, a_useFlatArrayNotation, a_context, i_simCode, l_varDecls);
        l_reinit = Tpl.popIter(l_reinit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluateConditions(const UPDATETYPE command)\n",
                                    "{\n",
                                    "    bool state_var_reinitialized = false;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//length: "));
        ret_3 = listLength(i_equationsForConditions);
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_eqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_reinit);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return state_var_reinitialized;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_111;

public function createEvaluateConditions
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input Absyn.Path a_name;
  input SimCode.Context a_context;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_111(txt, a_simCode, a_name, a_context, a_useFlatArrayNotation);
end createEvaluateConditions;

protected function lm_113
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.TaskList> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_type;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_type, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.TaskList> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_type;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      HpcOmSimCode.TaskList i_tasks;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_tasks :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_type,
           a_allEquationsPlusWhen )
      equation
        (txt, a_varDecls) = function_HPCOM_Level(txt, a_allEquationsPlusWhen, i_tasks, Tpl.textString(a_type), a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_113(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_type, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_113;

protected function fun_114
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer ret_0;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//MeasureTimeValues **threadValues = new MeasureTimeValues*["));
        ret_0 = Flags.getConfigInt(Flags.NUM_PROC);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
      then txt;
  end match;
end fun_114;

protected function fun_115
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*MeasureTimeValues *valuesStart = MeasureTime::getZeroValues();\n",
                                    "MeasureTimeValues *valuesEnd = MeasureTime::getZeroValues();\n",
                                    "MeasureTime::getInstance()->initializeThread(getThreadNumber);\n"
                                }, true));
        txt = CodegenCpp.generateMeasureTimeStartCode(txt, "valuesStart");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;
  end match;
end fun_115;

protected function fun_116
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*MeasureTime::getTimeValuesEnd(valuesEnd);\n",
                                    "valuesEnd->sub(valuesStart);\n",
                                    "valuesEnd->sub(MeasureTime::getOverhead());\n",
                                    "#pragma omp critical\n",
                                    "{\n",
                                    "    measureTimeArrayHpcom[0].sumMeasuredValues->add(valuesEnd);\n",
                                    "}\n",
                                    "delete valuesStart;\n",
                                    "delete valuesEnd;*/"
                                }, false));
      then txt;
  end match;
end fun_116;

protected function fun_117
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*delete threadValues;\n",
                                    "++(measureTimeArrayHpcom[0].numCalcs);*/"
                                }, false));
      then txt;
  end match;
end fun_117;

protected function fun_118
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_type;
  input Tpl.Text in_a_odeEqs;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_type, in_a_odeEqs, in_a_name)
    local
      Tpl.Text txt;
      Tpl.Text a_type;
      Tpl.Text a_odeEqs;
      Absyn.Path a_name;
      Boolean ret_12;
      Boolean ret_11;
      String ret_10;
      Boolean ret_9;
      Boolean ret_8;
      String ret_7;
      Boolean ret_6;
      Boolean ret_5;
      String ret_4;
      Integer ret_3;
      Boolean ret_2;
      Boolean ret_1;
      String ret_0;

    case ( txt,
           "openmp",
           _,
           a_odeEqs,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluateODE(const UPDATETYPE command)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = CodegenCpp.generateMeasureTimeStartCode(txt, "measuredFunctionStartValues");
        txt = Tpl.softNewLine(txt);
        ret_0 = Flags.getConfigString(Flags.PROFILING_LEVEL);
        ret_1 = stringEq(ret_0, "none");
        ret_2 = boolNot(ret_1);
        txt = fun_114(txt, ret_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp parallel num_threads("));
        ret_3 = Flags.getConfigInt(Flags.NUM_PROC);
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        ret_4 = Flags.getConfigString(Flags.PROFILING_LEVEL);
        ret_5 = stringEq(ret_4, "none");
        ret_6 = boolNot(ret_5);
        txt = fun_115(txt, ret_6);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_odeEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_7 = Flags.getConfigString(Flags.PROFILING_LEVEL);
        ret_8 = stringEq(ret_7, "none");
        ret_9 = boolNot(ret_8);
        txt = fun_116(txt, ret_9);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        ret_10 = Flags.getConfigString(Flags.PROFILING_LEVEL);
        ret_11 = stringEq(ret_10, "none");
        ret_12 = boolNot(ret_11);
        txt = fun_117(txt, ret_12);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = CodegenCpp.generateMeasureTimeEndCode(txt, "measuredFunctionStartValues", "measuredFunctionEndValues", "measureTimeFunctionsArray[0]");
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           "mpi",
           _,
           _,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// MFlehmig: MPI with level scheduling\n",
                                    "void "
                                }, false));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluateODE(const UPDATETYPE command)\n",
                                    "{\n",
                                    "  //ToDo\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_type,
           _,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluateODE(const UPDATETYPE command)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("throw std::runtime_error(\"Type "));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" is unsupported for level scheduling.\");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_118;

protected function lm_119
  input Tpl.Text in_txt;
  input list<list<list<HpcOmSimCode.Task>>> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Absyn.Path in_a_name;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_type;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_name, in_a_varDecls, in_a_type, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<list<list<HpcOmSimCode.Task>>> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Absyn.Path a_name;
      Tpl.Text a_varDecls;
      Tpl.Text a_type;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      Integer x_i0;
      list<list<HpcOmSimCode.Task>> i_tasks;

    case ( txt,
           {},
           _,
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_tasks :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_name,
           a_varDecls,
           a_type,
           a_allEquationsPlusWhen )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = generateLevelFixedCodeForThread(txt, a_allEquationsPlusWhen, i_tasks, x_i0, Tpl.textString(a_type), a_varDecls, a_name, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_119(txt, rest, a_useFlatArrayNotation, a_simCode, a_name, a_varDecls, a_type, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_119;

protected function lm_120
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Tpl.Text a_type;
      Integer i_tt;
      Tpl.Text txt_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_tt :: rest,
           a_type )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("threadLock"));
        txt_0 = Tpl.writeStr(txt_0, intString(i_tt));
        txt = createLockByLockName(txt, Tpl.textString(txt_0), "", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_120(txt, rest, a_type);
      then txt;
  end match;
end lm_120;

protected function lm_121
  input Tpl.Text in_txt;
  input list<list<list<HpcOmSimCode.Task>>> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Absyn.Path in_a_name;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_type;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_name, in_a_varDecls, in_a_type, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<list<list<HpcOmSimCode.Task>>> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Absyn.Path a_name;
      Tpl.Text a_varDecls;
      Tpl.Text a_type;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      Integer x_i0;
      list<list<HpcOmSimCode.Task>> i_tasks;

    case ( txt,
           {},
           _,
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_tasks :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_name,
           a_varDecls,
           a_type,
           a_allEquationsPlusWhen )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = generateLevelFixedCodeForThread(txt, a_allEquationsPlusWhen, i_tasks, x_i0, Tpl.textString(a_type), a_varDecls, a_name, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_121(txt, rest, a_useFlatArrayNotation, a_simCode, a_name, a_varDecls, a_type, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_121;

protected function lm_122
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Tpl.Text a_type;
      Integer i_tt;
      Tpl.Text txt_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_tt :: rest,
           a_type )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("threadLock"));
        txt_0 = Tpl.writeStr(txt_0, intString(i_tt));
        txt = createLockByLockName(txt, Tpl.textString(txt_0), "", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_122(txt, rest, a_type);
      then txt;
  end match;
end lm_122;

protected function fun_123
  input Tpl.Text in_txt;
  input String in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Absyn.Path in_a_name;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_type;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;
  input HpcOmSimCode.Schedule in_a_hpcOmSchedule;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_name, in_a_varDecls, in_a_type, in_a_allEquationsPlusWhen, in_a_hpcOmSchedule)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Absyn.Path a_name;
      Tpl.Text a_varDecls;
      Tpl.Text a_type;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      HpcOmSimCode.Schedule a_hpcOmSchedule;
      list<Integer> ret_11;
      Integer ret_10;
      list<list<list<HpcOmSimCode.Task>>> ret_9;
      array<list<list<HpcOmSimCode.Task>>> ret_8;
      Integer ret_7;
      list<Integer> ret_6;
      Integer ret_5;
      Tpl.Text l_threadLocks;
      list<list<list<HpcOmSimCode.Task>>> ret_3;
      array<list<list<HpcOmSimCode.Task>>> ret_2;
      Integer ret_1;
      Tpl.Text l_eqsFuncs;

    case ( txt,
           "pthreads",
           a_useFlatArrayNotation,
           a_simCode,
           a_name,
           a_varDecls,
           a_type,
           a_allEquationsPlusWhen,
           a_hpcOmSchedule )
      equation
        ret_1 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_2 = HpcOmScheduler.convertFixedLevelScheduleToTaskLists(a_hpcOmSchedule, ret_1);
        ret_3 = arrayList(ret_2);
        l_eqsFuncs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_eqsFuncs, a_varDecls) = lm_119(l_eqsFuncs, ret_3, a_useFlatArrayNotation, a_simCode, a_name, a_varDecls, a_type, a_allEquationsPlusWhen);
        l_eqsFuncs = Tpl.popIter(l_eqsFuncs);
        ret_5 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_6 = List.intRange(ret_5);
        l_threadLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadLocks = lm_120(l_threadLocks, ret_6, a_type);
        l_threadLocks = Tpl.popIter(l_threadLocks);
        txt = Tpl.writeText(txt, l_eqsFuncs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void "
                                }, false));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluateODE(const UPDATETYPE command)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*"));
        txt = CodegenCpp.generateMeasureTimeStartCode(txt, "measuredFunctionStartValues");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*/\n",
                                    "this->_command = command;\n",
                                    "_evaluateBarrier.wait(); //start calculation\n",
                                    "_evaluateBarrier.wait(); //calculation finished\n",
                                    "/*"
                                }, false));
        txt = CodegenCpp.generateMeasureTimeEndCode(txt, "measuredFunctionStartValues", "measuredFunctionEndValues", "measureTimeFunctionsArray[0]");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("*/\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           "pthreads_spin",
           a_useFlatArrayNotation,
           a_simCode,
           a_name,
           a_varDecls,
           a_type,
           a_allEquationsPlusWhen,
           a_hpcOmSchedule )
      equation
        ret_7 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_8 = HpcOmScheduler.convertFixedLevelScheduleToTaskLists(a_hpcOmSchedule, ret_7);
        ret_9 = arrayList(ret_8);
        l_eqsFuncs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_eqsFuncs, a_varDecls) = lm_121(l_eqsFuncs, ret_9, a_useFlatArrayNotation, a_simCode, a_name, a_varDecls, a_type, a_allEquationsPlusWhen);
        l_eqsFuncs = Tpl.popIter(l_eqsFuncs);
        ret_10 = Flags.getConfigInt(Flags.NUM_PROC);
        ret_11 = List.intRange(ret_10);
        l_threadLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadLocks = lm_122(l_threadLocks, ret_11, a_type);
        l_threadLocks = Tpl.popIter(l_threadLocks);
        txt = Tpl.writeText(txt, l_eqsFuncs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void "
                                }, false));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluateODE(const UPDATETYPE command)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*"));
        txt = CodegenCpp.generateMeasureTimeStartCode(txt, "measuredFunctionStartValues");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*/\n",
                                    "this->_command = command;\n",
                                    "_evaluateBarrier.wait(); //start calculation\n",
                                    "_evaluateBarrier.wait(); //calculation finished\n",
                                    "/*"
                                }, false));
        txt = CodegenCpp.generateMeasureTimeEndCode(txt, "measuredFunctionStartValues", "measuredFunctionEndValues", "measureTimeFunctionsArray[0]");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("*/\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           _,
           _,
           _ )
      then (txt, a_varDecls);
  end match;
end fun_123;

protected function lm_124
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_type;
  input array<list<HpcOmSimCode.Task>> in_a_hpcOmSchedule_threadTasks;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_modelNamePrefixStr, in_a_type, in_a_hpcOmSchedule_threadTasks, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      String a_modelNamePrefixStr;
      Tpl.Text a_type;
      array<list<HpcOmSimCode.Task>> a_hpcOmSchedule_threadTasks;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      Integer x_i0;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _,
           _,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_modelNamePrefixStr,
           a_type,
           a_hpcOmSchedule_threadTasks,
           a_allEquationsPlusWhen )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = generateThreadFunc(txt, a_allEquationsPlusWhen, a_hpcOmSchedule_threadTasks, Tpl.textString(a_type), x_i0, a_modelNamePrefixStr, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_124(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_modelNamePrefixStr, a_type, a_hpcOmSchedule_threadTasks, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_124;

protected function lm_125
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = assignLockByLockName(txt, intString(x_i0), "th_lock1", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_125(txt, rest, a_type);
      then txt;
  end match;
end lm_125;

protected function lm_126
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = releaseLockByLockName(txt, intString(x_i0), "th_lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_126(txt, rest, a_type);
      then txt;
  end match;
end lm_126;

protected function fun_127
  input Tpl.Text in_txt;
  input String in_mArg;
  input String in_a_modelNamePrefixStr;
  input Absyn.Path in_a_name;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_type;
  input array<list<HpcOmSimCode.Task>> in_a_hpcOmSchedule_threadTasks;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_modelNamePrefixStr, in_a_name, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_type, in_a_hpcOmSchedule_threadTasks, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      String a_modelNamePrefixStr;
      Absyn.Path a_name;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_type;
      array<list<HpcOmSimCode.Task>> a_hpcOmSchedule_threadTasks;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      list<list<HpcOmSimCode.Task>> ret_6;
      Tpl.Text l_threadReleaseLocks;
      list<list<HpcOmSimCode.Task>> ret_4;
      Tpl.Text l_threadAssignLocks1;
      list<list<HpcOmSimCode.Task>> ret_2;
      Tpl.Text l_threadFuncs;
      Tpl.Text l_taskEqs;

    case ( txt,
           "openmp",
           _,
           a_name,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_type,
           a_hpcOmSchedule_threadTasks,
           a_allEquationsPlusWhen )
      equation
        (l_taskEqs, a_varDecls) = function_HPCOM_Thread(Tpl.emptyTxt, a_allEquationsPlusWhen, a_hpcOmSchedule_threadTasks, Tpl.textString(a_type), a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//using type: "));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluateODE(const UPDATETYPE command)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_taskEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           "mpi",
           _,
           a_name,
           _,
           _,
           a_varDecls,
           a_type,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//using type: "));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " and threadscheduling\n",
                                    "void "
                                }, false));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluateODE(const UPDATETYPE command)\n",
                                    "{\n",
                                    "  // MFlehmig: Todo\n",
                                    "\n",
                                    "}"
                                }, false));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_modelNamePrefixStr,
           a_name,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_type,
           a_hpcOmSchedule_threadTasks,
           a_allEquationsPlusWhen )
      equation
        ret_2 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadFuncs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_threadFuncs, a_varDecls) = lm_124(l_threadFuncs, ret_2, a_useFlatArrayNotation, a_simCode, a_varDecls, a_modelNamePrefixStr, a_type, a_hpcOmSchedule_threadTasks, a_allEquationsPlusWhen);
        l_threadFuncs = Tpl.popIter(l_threadFuncs);
        ret_4 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadAssignLocks1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadAssignLocks1 = lm_125(l_threadAssignLocks1, ret_4, a_type);
        l_threadAssignLocks1 = Tpl.popIter(l_threadAssignLocks1);
        ret_6 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadReleaseLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadReleaseLocks = lm_126(l_threadReleaseLocks, ret_6, a_type);
        l_threadReleaseLocks = Tpl.popIter(l_threadReleaseLocks);
        txt = Tpl.writeText(txt, l_threadFuncs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//using type: "
                                }, false));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluateODE(const UPDATETYPE command)\n",
                                    "{\n",
                                    "\n",
                                    "  this->command = command;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_threadReleaseLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadAssignLocks1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);
  end match;
end fun_127;

protected function fun_128
  input Tpl.Text in_txt;
  input String in_mArg;
  input Absyn.Path in_a_name;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_type;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;
  input list<tuple<HpcOmSimCode.Task, list<Integer>>> in_a_hpcOmSchedule_tasks;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_name, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_type, in_a_allEquationsPlusWhen, in_a_hpcOmSchedule_tasks)
    local
      Tpl.Text txt;
      Absyn.Path a_name;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_type;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      list<tuple<HpcOmSimCode.Task, list<Integer>>> a_hpcOmSchedule_tasks;
      Tpl.Text l_taskFuncs;
      Tpl.Text l_taskNodes;
      Tpl.Text l_taskEqs;

    case ( txt,
           "openmp",
           a_name,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_type,
           a_allEquationsPlusWhen,
           a_hpcOmSchedule_tasks )
      equation
        (l_taskEqs, a_varDecls) = function_HPCOM_TaskDep(Tpl.emptyTxt, a_hpcOmSchedule_tasks, a_allEquationsPlusWhen, Tpl.textString(a_type), a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//using type: "));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluateODE(const UPDATETYPE command)\n",
                                    "{\n",
                                    "\n",
                                    "  omp_set_dynamic(1);\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_taskEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           "tbb",
           a_name,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_type,
           a_allEquationsPlusWhen,
           a_hpcOmSchedule_tasks )
      equation
        (l_taskNodes, a_varDecls) = function_HPCOM_TaskDep_tbb(Tpl.emptyTxt, a_hpcOmSchedule_tasks, a_allEquationsPlusWhen, Tpl.textString(a_type), a_name, a_varDecls, a_simCode, a_useFlatArrayNotation);
        (l_taskFuncs, a_varDecls) = function_HPCOM_TaskDep_voidfunc(Tpl.emptyTxt, a_hpcOmSchedule_tasks, a_allEquationsPlusWhen, Tpl.textString(a_type), a_name, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//using type: "));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//void functions for functionhandling in tbb_nodes\n"
                                }, true));
        txt = Tpl.writeText(txt, l_taskFuncs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void "
                                }, false));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluateODE(const UPDATETYPE command)\n",
                                    "{\n",
                                    "  using namespace tbb::flow;\n",
                                    "\n",
                                    "\n",
                                    "  // Declaration of nodes and edges\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_taskNodes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           _,
           _,
           _ )
      then (txt, a_varDecls);
  end match;
end fun_128;

protected function fun_129
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.Schedule> in_a_hpcOmScheduleOpt;
  input String in_a_modelNamePrefixStr;
  input Absyn.Path in_a_name;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_type;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.SimWhenClause> in_a_whenClauses;
  input list<list<SimCode.SimEqSystem>> in_a_odeEquations;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_hpcOmScheduleOpt, in_a_modelNamePrefixStr, in_a_name, in_a_useFlatArrayNotation, in_a_varDecls, in_a_type, in_a_allEquationsPlusWhen, in_a_context, in_a_simCode, in_a_whenClauses, in_a_odeEquations)
    local
      Tpl.Text txt;
      String a_modelNamePrefixStr;
      Absyn.Path a_name;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDecls;
      Tpl.Text a_type;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      list<SimCode.SimWhenClause> a_whenClauses;
      list<list<SimCode.SimEqSystem>> a_odeEquations;
      list<tuple<HpcOmSimCode.Task, list<Integer>>> i_hpcOmSchedule_tasks;
      array<list<HpcOmSimCode.Task>> i_hpcOmSchedule_threadTasks;
      HpcOmSimCode.Schedule i_hpcOmSchedule;
      list<HpcOmSimCode.TaskList> i_tasksOfLevels;
      String str_4;
      String str_3;
      String str_2;
      String str_1;
      Tpl.Text l_odeEqs;

    case ( txt,
           SOME(HpcOmSimCode.EMPTYSCHEDULE()),
           _,
           _,
           _,
           a_varDecls,
           _,
           _,
           a_context,
           a_simCode,
           a_whenClauses,
           a_odeEquations )
      equation
        txt = CodegenCpp.createEvaluate(txt, a_odeEquations, a_whenClauses, a_simCode, a_context);
      then (txt, a_varDecls);

    case ( txt,
           SOME(HpcOmSimCode.LEVELSCHEDULE(useFixedAssignments = false, tasksOfLevels = i_tasksOfLevels)),
           _,
           a_name,
           a_useFlatArrayNotation,
           a_varDecls,
           a_type,
           a_allEquationsPlusWhen,
           _,
           a_simCode,
           _,
           _ )
      equation
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_odeEqs, a_varDecls) = lm_113(l_odeEqs, i_tasksOfLevels, a_useFlatArrayNotation, a_simCode, a_varDecls, a_type, a_allEquationsPlusWhen);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        str_1 = Tpl.textString(a_type);
        txt = fun_118(txt, str_1, a_type, l_odeEqs, a_name);
      then (txt, a_varDecls);

    case ( txt,
           SOME((i_hpcOmSchedule as HpcOmSimCode.LEVELSCHEDULE(useFixedAssignments = true, tasksOfLevels = _))),
           _,
           a_name,
           a_useFlatArrayNotation,
           a_varDecls,
           a_type,
           a_allEquationsPlusWhen,
           _,
           a_simCode,
           _,
           _ )
      equation
        str_2 = Tpl.textString(a_type);
        (txt, a_varDecls) = fun_123(txt, str_2, a_useFlatArrayNotation, a_simCode, a_name, a_varDecls, a_type, a_allEquationsPlusWhen, i_hpcOmSchedule);
      then (txt, a_varDecls);

    case ( txt,
           SOME(HpcOmSimCode.THREADSCHEDULE(threadTasks = i_hpcOmSchedule_threadTasks)),
           a_modelNamePrefixStr,
           a_name,
           a_useFlatArrayNotation,
           a_varDecls,
           a_type,
           a_allEquationsPlusWhen,
           _,
           a_simCode,
           _,
           _ )
      equation
        str_3 = Tpl.textString(a_type);
        (txt, a_varDecls) = fun_127(txt, str_3, a_modelNamePrefixStr, a_name, a_useFlatArrayNotation, a_simCode, a_varDecls, a_type, i_hpcOmSchedule_threadTasks, a_allEquationsPlusWhen);
      then (txt, a_varDecls);

    case ( txt,
           SOME(HpcOmSimCode.TASKDEPSCHEDULE(tasks = i_hpcOmSchedule_tasks)),
           _,
           a_name,
           a_useFlatArrayNotation,
           a_varDecls,
           a_type,
           a_allEquationsPlusWhen,
           _,
           a_simCode,
           _,
           _ )
      equation
        str_4 = Tpl.textString(a_type);
        (txt, a_varDecls) = fun_128(txt, str_4, a_name, a_useFlatArrayNotation, a_simCode, a_varDecls, a_type, a_allEquationsPlusWhen, i_hpcOmSchedule_tasks);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           _,
           _,
           _,
           _,
           _,
           _ )
      then (txt, a_varDecls);
  end match;
end fun_129;

public function update2
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<list<SimCode.SimEqSystem>> a_odeEquations;
  input Absyn.Path a_name;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input SimCode.SimCode a_simCode;
  input Option<HpcOmSimCode.Schedule> a_hpcOmScheduleOpt;
  input SimCode.Context a_context;
  input String a_modelNamePrefixStr;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
protected
  String ret_2;
  Tpl.Text l_type;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  ret_2 := Flags.getConfigString(Flags.HPCOM_CODE);
  l_type := Tpl.writeStr(Tpl.emptyTxt, ret_2);
  (out_txt, l_varDecls) := fun_129(txt, a_hpcOmScheduleOpt, a_modelNamePrefixStr, a_name, a_useFlatArrayNotation, l_varDecls, l_type, a_allEquationsPlusWhen, a_context, a_simCode, a_whenClauses, a_odeEquations);
end update2;

protected function lm_131
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input String in_a_iType;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_iType, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      String a_iType;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      HpcOmSimCode.Task i_task;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_task :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_iType,
           a_allEquationsPlusWhen )
      equation
        (txt, a_varDecls) = function_HPCOM_Level0(txt, a_allEquationsPlusWhen, i_task, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_131(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_131;

protected function lm_132
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input String in_a_iType;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_iType, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      String a_iType;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      HpcOmSimCode.Task i_task;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_task :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_iType,
           a_allEquationsPlusWhen )
      equation
        (txt, a_varDecls) = function_HPCOM_Level0(txt, a_allEquationsPlusWhen, i_task, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_132(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_132;

protected function fun_133
  input Tpl.Text in_txt;
  input HpcOmSimCode.TaskList in_a_tasksOfLevel;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;
  input String in_a_iType;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_tasksOfLevel, in_a_allEquationsPlusWhen, in_a_iType, in_a_varDecls, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      String a_iType;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      list<HpcOmSimCode.Task> i_tasks;
      Tpl.Text l_odeEqs;

    case ( txt,
           HpcOmSimCode.PARALLELTASKLIST(tasks = i_tasks),
           a_allEquationsPlusWhen,
           a_iType,
           a_varDecls,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_odeEqs, a_varDecls) = lm_131(l_odeEqs, i_tasks, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma omp sections\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_odeEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           HpcOmSimCode.SERIALTASKLIST(tasks = i_tasks),
           a_allEquationsPlusWhen,
           a_iType,
           a_varDecls,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_odeEqs, a_varDecls) = lm_132(l_odeEqs, i_tasks, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma omp master\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_odeEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "#pragma omp barrier"
                                }, false));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);
  end match;
end fun_133;

public function function_HPCOM_Level
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input HpcOmSimCode.TaskList a_tasksOfLevel;
  input String a_iType;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_133(txt, a_tasksOfLevel, a_allEquationsPlusWhen, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
end function_HPCOM_Level;

public function function_HPCOM_Level0
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input HpcOmSimCode.Task a_iTask;
  input String a_iType;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "#pragma omp section\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(4));
  (out_txt, out_a_varDecls) := function_HPCOM_Task(out_txt, a_allEquationsPlusWhen, a_iTask, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end function_HPCOM_Level0;

protected function lm_136
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input String in_a_iType;
  input Integer in_a_iThreadIdx;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_iType, in_a_iThreadIdx, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      String a_iType;
      Integer a_iThreadIdx;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      list<HpcOmSimCode.Task> i_tasks;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_tasks :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_iType,
           a_iThreadIdx,
           a_allEquationsPlusWhen )
      equation
        (txt, a_varDecls) = generateLevelFixedCodeForThreadLevel(txt, a_allEquationsPlusWhen, i_tasks, a_iThreadIdx, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_136(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_iThreadIdx, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_136;

protected function fun_137
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MeasureTimeValues *valuesStart = MeasureTime::getZeroValues();\n",
                                    "MeasureTimeValues *valuesEnd = MeasureTime::getZeroValues();\n",
                                    "MeasureTime::getInstance()->initializeThread(getThreadNumber);\n",
                                    "//"
                                }, false));
        txt = CodegenCpp.generateMeasureTimeStartCode(txt, "valuesStart");
      then txt;
  end match;
end fun_137;

protected function fun_138
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = CodegenCpp.generateMeasureTimeStartCode(txt, "valuesStart");
      then txt;
  end match;
end fun_138;

protected function fun_139
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("measureTimeArrayHpcom[0].numCalcs--;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_139;

protected function fun_140
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_iThreadIdx;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_iThreadIdx)
    local
      Tpl.Text txt;
      Integer a_iThreadIdx;
      Boolean ret_0;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_iThreadIdx )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//MeasureTime::getTimeValuesEnd(valuesEnd);\n",
                                    "//valuesEnd->sub(valuesStart);\n",
                                    "//valuesEnd->sub(MeasureTime::getOverhead());\n",
                                    "\n",
                                    "//_measureTimeArrayLock.lock();\n",
                                    "//measureTimeArrayHpcom[0].sumMeasuredValues->add(valuesEnd);\n"
                                }, true));
        ret_0 = intEq(a_iThreadIdx, 0);
        txt = fun_139(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//_measureTimeArrayLock.unlock();\n"));
        txt = CodegenCpp.generateMeasureTimeEndCode(txt, "valuesStart", "valuesEnd", "measureTimeFunctionsArray[0]");
      then txt;
  end match;
end fun_140;

protected function fun_141
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "delete valuesStart;\n",
                                    "delete valuesEnd;"
                                }, false));
      then txt;
  end match;
end fun_141;

public function generateLevelFixedCodeForThread
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<list<HpcOmSimCode.Task>> a_tasksOfLevels;
  input Integer a_iThreadIdx;
  input String a_iType;
  input Tpl.Text a_varDecls;
  input Absyn.Path a_name;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Boolean ret_12;
  Boolean ret_11;
  String ret_10;
  Boolean ret_9;
  Boolean ret_8;
  String ret_7;
  Boolean ret_6;
  Boolean ret_5;
  String ret_4;
  Boolean ret_3;
  Boolean ret_2;
  String ret_1;
  Tpl.Text l_odeEqs;
algorithm
  l_odeEqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_odeEqs, out_a_varDecls) := lm_136(l_odeEqs, a_tasksOfLevels, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_iThreadIdx, a_allEquationsPlusWhen);
  l_odeEqs := Tpl.popIter(l_odeEqs);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("void "));
  out_txt := CodegenCpp.lastIdentOfPath(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("::evaluateThreadFunc"));
  out_txt := Tpl.writeStr(out_txt, intString(a_iThreadIdx));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "()\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  ret_1 := Flags.getConfigString(Flags.PROFILING_LEVEL);
  ret_2 := stringEq(ret_1, "none");
  ret_3 := boolNot(ret_2);
  out_txt := fun_137(out_txt, ret_3);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "while(!_simulationFinished)\n",
                                       "{\n",
                                       "    _evaluateBarrier.wait();\n",
                                       "    if(_simulationFinished)\n",
                                       "    {\n",
                                       "        _evaluateBarrier.wait();\n",
                                       "        break;\n",
                                       "    }\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(4));
  ret_4 := Flags.getConfigString(Flags.PROFILING_LEVEL);
  ret_5 := stringEq(ret_4, "none");
  ret_6 := boolNot(ret_5);
  out_txt := fun_138(out_txt, ret_6);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_odeEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  ret_7 := Flags.getConfigString(Flags.PROFILING_LEVEL);
  ret_8 := stringEq(ret_7, "none");
  ret_9 := boolNot(ret_8);
  out_txt := fun_140(out_txt, ret_9, a_iThreadIdx);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "_evaluateBarrier.wait();\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("}\n"));
  ret_10 := Flags.getConfigString(Flags.PROFILING_LEVEL);
  ret_11 := stringEq(ret_10, "none");
  ret_12 := boolNot(ret_11);
  out_txt := fun_141(out_txt, ret_12);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end generateLevelFixedCodeForThread;

protected function lm_143
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input String in_a_iType;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_iType, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      String a_iType;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      HpcOmSimCode.Task i_t;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_t :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_iType,
           a_allEquationsPlusWhen )
      equation
        (txt, a_varDecls) = function_HPCOM_Task(txt, a_allEquationsPlusWhen, i_t, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_143(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_143;

protected function fun_144
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_144;

public function generateLevelFixedCodeForThreadLevel
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<HpcOmSimCode.Task> a_tasksOfLevel;
  input Integer a_iThreadIdx;
  input String a_iType;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Boolean ret_1;
  Tpl.Text l_tasks;
algorithm
  l_tasks := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_tasks, out_a_varDecls) := lm_143(l_tasks, a_tasksOfLevel, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
  l_tasks := Tpl.popIter(l_tasks);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("//Start of Level\n"));
  ret_1 := stringEq(Tpl.textString(l_tasks), "");
  out_txt := fun_144(out_txt, ret_1);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_tasks);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_levelBarrier.wait();\n",
                                       "//End of Level"
                                   }, false));
end generateLevelFixedCodeForThreadLevel;

protected function lm_146
  input Tpl.Text in_txt;
  input list<tuple<HpcOmSimCode.Task, list<Integer>>> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input String in_a_iType;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_iType, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<tuple<HpcOmSimCode.Task, list<Integer>>> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      String a_iType;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      tuple<HpcOmSimCode.Task, list<Integer>> i_t;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_t :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_iType,
           a_allEquationsPlusWhen )
      equation
        (txt, a_varDecls) = function_HPCOM_TaskDep0(txt, i_t, a_allEquationsPlusWhen, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_146(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_146;

public function function_HPCOM_TaskDep
  input Tpl.Text txt;
  input list<tuple<HpcOmSimCode.Task, list<Integer>>> a_tasks;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input String a_iType;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_odeEqs;
algorithm
  l_odeEqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_odeEqs, out_a_varDecls) := lm_146(l_odeEqs, a_tasks, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
  l_odeEqs := Tpl.popIter(l_odeEqs);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "\n",
                                   "int t[0];\n",
                                   "#pragma omp parallel\n",
                                   "{\n",
                                   "  #pragma omp master\n",
                                   "  {\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(6));
  out_txt := Tpl.writeText(out_txt, l_odeEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "  }\n",
                                       "}"
                                   }, false));
end function_HPCOM_TaskDep;

protected function lm_148
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_p;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_p :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("t["));
        txt = Tpl.writeStr(txt, intString(i_p));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
        txt = Tpl.nextIter(txt);
        txt = lm_148(txt, rest);
      then txt;
  end match;
end lm_148;

protected function lm_149
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_p;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_p :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_p));
        txt = Tpl.nextIter(txt);
        txt = lm_149(txt, rest);
      then txt;
  end match;
end lm_149;

protected function fun_150
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_parentDependencies;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_parentDependencies)
    local
      Tpl.Text txt;
      Tpl.Text a_parentDependencies;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_parentDependencies )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("depend(in:"));
        txt = Tpl.writeText(txt, a_parentDependencies);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") "));
      then txt;
  end match;
end fun_150;

public function function_HPCOM_TaskDep0
  input Tpl.Text in_txt;
  input tuple<HpcOmSimCode.Task, list<Integer>> in_a_taskIn;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;
  input String in_a_iType;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_taskIn, in_a_allEquationsPlusWhen, in_a_iType, in_a_varDecls, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      String a_iType;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Integer i_task_index;
      list<Integer> i_parents;
      HpcOmSimCode.Task i_task;
      Boolean ret_5;
      Integer ret_4;
      Tpl.Text l_depIn;
      Tpl.Text l_taskDependencies;
      Tpl.Text l_parentDependencies;
      Tpl.Text l_taskEqs;

    case ( txt,
           ((i_task as HpcOmSimCode.CALCTASK(index = i_task_index)), i_parents),
           a_allEquationsPlusWhen,
           a_iType,
           a_varDecls,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        (l_taskEqs, a_varDecls) = function_HPCOM_Task(Tpl.emptyTxt, a_allEquationsPlusWhen, i_task, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
        l_parentDependencies = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_parentDependencies = lm_148(l_parentDependencies, i_parents);
        l_parentDependencies = Tpl.popIter(l_parentDependencies);
        l_taskDependencies = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_taskDependencies = lm_149(l_taskDependencies, i_parents);
        l_taskDependencies = Tpl.popIter(l_taskDependencies);
        ret_4 = listLength(i_parents);
        ret_5 = intGt(ret_4, 0);
        l_depIn = fun_150(Tpl.emptyTxt, ret_5, l_parentDependencies);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//TG_NODE: "));
        txt = Tpl.writeStr(txt, intString(i_task_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" TG_PARENTS: "));
        txt = Tpl.writeText(txt, l_taskDependencies);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp task "));
        txt = Tpl.writeText(txt, l_depIn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("depend(out:t["));
        txt = Tpl.writeStr(txt, intString(i_task_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "])\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_taskEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);
  end match;
end function_HPCOM_TaskDep0;

protected function lm_152
  input Tpl.Text in_txt;
  input list<tuple<HpcOmSimCode.Task, list<Integer>>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Absyn.Path in_a_name;
  input String in_a_iType;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls, in_a_name, in_a_iType, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<tuple<HpcOmSimCode.Task, list<Integer>>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Absyn.Path a_name;
      String a_iType;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      tuple<HpcOmSimCode.Task, list<Integer>> i_t;

    case ( txt,
           {},
           _,
           a_varDecls,
           _,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_t :: rest,
           a_simCode,
           a_varDecls,
           a_name,
           a_iType,
           a_allEquationsPlusWhen )
      equation
        (txt, a_varDecls) = function_HPCOM_TaskDep_tbb0(txt, i_t, a_allEquationsPlusWhen, a_iType, a_name, a_varDecls, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_152(txt, rest, a_simCode, a_varDecls, a_name, a_iType, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_152;

public function function_HPCOM_TaskDep_tbb
  input Tpl.Text txt;
  input list<tuple<HpcOmSimCode.Task, list<Integer>>> a_tasks;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input String a_iType;
  input Absyn.Path a_name;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_noteEqs;
algorithm
  l_noteEqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_noteEqs, out_a_varDecls) := lm_152(l_noteEqs, a_tasks, a_simCode, a_varDecls, a_name, a_iType, a_allEquationsPlusWhen);
  l_noteEqs := Tpl.popIter(l_noteEqs);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "      //Init base node\n",
                                   "      broadcast_node< continue_msg > tbb_start(tbb_graph);\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(6));
  out_txt := Tpl.writeText(out_txt, l_noteEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "//Start\n",
                                       "tbb_start.try_put(continue_msg());\n",
                                       "tbb_graph.wait_for_all();\n",
                                       "//End"
                                   }, false));
  out_txt := Tpl.popBlock(out_txt);
end function_HPCOM_TaskDep_tbb;

protected function lm_154
  input Tpl.Text in_txt;
  input list<tuple<HpcOmSimCode.Task, list<Integer>>> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Absyn.Path in_a_name;
  input String in_a_iType;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_name, in_a_iType, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<tuple<HpcOmSimCode.Task, list<Integer>>> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Absyn.Path a_name;
      String a_iType;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      tuple<HpcOmSimCode.Task, list<Integer>> i_t;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_t :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_name,
           a_iType,
           a_allEquationsPlusWhen )
      equation
        (txt, a_varDecls) = function_HPCOM_TaskDep_voidfunc0(txt, i_t, a_allEquationsPlusWhen, a_iType, a_name, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_154(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_name, a_iType, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_154;

public function function_HPCOM_TaskDep_voidfunc
  input Tpl.Text txt;
  input list<tuple<HpcOmSimCode.Task, list<Integer>>> a_tasks;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input String a_iType;
  input Absyn.Path a_name;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_funcTasks;
algorithm
  l_funcTasks := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_funcTasks, out_a_varDecls) := lm_154(l_funcTasks, a_tasks, a_useFlatArrayNotation, a_simCode, a_varDecls, a_name, a_iType, a_allEquationsPlusWhen);
  l_funcTasks := Tpl.popIter(l_funcTasks);
  out_txt := Tpl.writeText(txt, l_funcTasks);
end function_HPCOM_TaskDep_voidfunc;

protected function lm_156
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input Integer in_a_task_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_task_index)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer a_task_index;
      Integer i_p;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_p :: rest,
           a_task_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("make_edge(tbb_task_"));
        txt = Tpl.writeStr(txt, intString(i_p));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",tbb_task_"));
        txt = Tpl.writeStr(txt, intString(a_task_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_156(txt, rest, a_task_index);
      then txt;
  end match;
end lm_156;

protected function fun_157
  input Tpl.Text in_txt;
  input tuple<HpcOmSimCode.Task, list<Integer>> in_a_taskIn;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_taskIn, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;
      Integer i_task_index;
      list<Integer> i_parents;
      Tpl.Text l_parentEdges;

    case ( txt,
           (HpcOmSimCode.CALCTASK(index = i_task_index), i_parents),
           a_name )
      equation
        l_parentEdges = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_parentEdges = lm_156(l_parentEdges, i_parents, i_task_index);
        l_parentEdges = Tpl.popIter(l_parentEdges);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("continue_node < continue_msg > tbb_task_"));
        txt = Tpl.writeStr(txt, intString(i_task_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(tbb_graph,VoidBody(boost::bind<void>(&"));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::task_func_"));
        txt = Tpl.writeStr(txt, intString(i_task_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",this)));\n"));
        txt = Tpl.writeText(txt, l_parentEdges);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_157;

public function function_HPCOM_TaskDep_tbb0
  input Tpl.Text txt;
  input tuple<HpcOmSimCode.Task, list<Integer>> a_taskIn;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input String a_iType;
  input Absyn.Path a_name;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_157(txt, a_taskIn, a_name);
  out_a_varDecls := a_varDecls;
end function_HPCOM_TaskDep_tbb0;

protected function fun_159
  input Tpl.Text in_txt;
  input tuple<HpcOmSimCode.Task, list<Integer>> in_a_taskIn;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;
  input String in_a_iType;
  input Absyn.Path in_a_name;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_taskIn, in_a_allEquationsPlusWhen, in_a_iType, in_a_name, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      String a_iType;
      Absyn.Path a_name;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Integer i_task_index;
      HpcOmSimCode.Task i_task;
      Tpl.Text l_taskEqs;
      Tpl.Text l_tempvarDecl;

    case ( txt,
           ((i_task as HpcOmSimCode.CALCTASK(index = i_task_index)), _),
           a_allEquationsPlusWhen,
           a_iType,
           a_name,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_tempvarDecl = Tpl.emptyTxt;
        (l_taskEqs, l_tempvarDecl) = function_HPCOM_Task(Tpl.emptyTxt, a_allEquationsPlusWhen, i_task, a_iType, l_tempvarDecl, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = CodegenCpp.lastIdentOfPath(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::task_func_"));
        txt = Tpl.writeStr(txt, intString(i_task_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_tempvarDecl);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_taskEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_159;

public function function_HPCOM_TaskDep_voidfunc0
  input Tpl.Text txt;
  input tuple<HpcOmSimCode.Task, list<Integer>> a_taskIn;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input String a_iType;
  input Absyn.Path a_name;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_159(txt, a_taskIn, a_allEquationsPlusWhen, a_iType, a_name, a_simCode, a_useFlatArrayNotation);
  out_a_varDecls := a_varDecls;
end function_HPCOM_TaskDep_voidfunc0;

protected function lm_161
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input String in_a_iType;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_iType, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      String a_iType;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      Integer x_i0;
      list<HpcOmSimCode.Task> i_tt;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_tt :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_iType,
           a_allEquationsPlusWhen )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = function_HPCOM_Thread0(txt, a_allEquationsPlusWhen, i_tt, x_i0, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_161(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_161;

protected function lm_162
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input String in_a_iType;
  input array<list<HpcOmSimCode.Task>> in_a_threadTasks;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_iType, in_a_threadTasks)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      String a_iType;
      array<list<HpcOmSimCode.Task>> a_threadTasks;
      Integer x_i0;
      list<HpcOmSimCode.Task> ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_iType,
           a_threadTasks )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        ret_0 = intAdd(x_i0, 1);
        ret_1 = arrayGet(a_threadTasks, ret_0);
        txt = function_HPCOM_assignThreadLocks(txt, ret_1, "lock", x_i0, a_iType);
        txt = Tpl.nextIter(txt);
        txt = lm_162(txt, rest, a_iType, a_threadTasks);
      then txt;
  end match;
end lm_162;

protected function lm_163
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input String in_a_iType;
  input array<list<HpcOmSimCode.Task>> in_a_threadTasks;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_iType, in_a_threadTasks)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      String a_iType;
      array<list<HpcOmSimCode.Task>> a_threadTasks;
      Integer x_i0;
      list<HpcOmSimCode.Task> ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_iType,
           a_threadTasks )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        ret_0 = intAdd(x_i0, 1);
        ret_1 = arrayGet(a_threadTasks, ret_0);
        txt = function_HPCOM_releaseThreadLocks(txt, ret_1, "lock", x_i0, a_iType);
        txt = Tpl.nextIter(txt);
        txt = lm_163(txt, rest, a_iType, a_threadTasks);
      then txt;
  end match;
end lm_163;

protected function lm_164
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input String in_a_iType;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_iType, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      String a_iType;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      Integer x_i0;
      list<HpcOmSimCode.Task> i_tt;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_tt :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_iType,
           a_allEquationsPlusWhen )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = function_HPCOM_Thread0(txt, a_allEquationsPlusWhen, i_tt, x_i0, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_164(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_164;

protected function lm_165
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input String in_a_iType;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_iType, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      String a_iType;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      Integer x_i0;
      list<HpcOmSimCode.Task> i_tt;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_tt :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_iType,
           a_allEquationsPlusWhen )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = function_HPCOM_Thread0(txt, a_allEquationsPlusWhen, i_tt, x_i0, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_165(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_165;

protected function fun_166
  input Tpl.Text in_txt;
  input String in_a_iType;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;
  input array<list<HpcOmSimCode.Task>> in_a_threadTasks;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_iType, in_a_allEquationsPlusWhen, in_a_threadTasks, in_a_varDecls, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      array<list<HpcOmSimCode.Task>> a_threadTasks;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      String i_iType;
      list<list<HpcOmSimCode.Task>> ret_8;
      list<list<HpcOmSimCode.Task>> ret_7;
      Integer ret_6;
      list<list<HpcOmSimCode.Task>> ret_5;
      Tpl.Text l_threadReleaseLocks;
      list<list<HpcOmSimCode.Task>> ret_3;
      Tpl.Text l_threadAssignLocks;
      list<list<HpcOmSimCode.Task>> ret_1;
      Tpl.Text l_odeEqs;

    case ( txt,
           (i_iType as "openmp"),
           a_allEquationsPlusWhen,
           a_threadTasks,
           a_varDecls,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        ret_1 = arrayList(a_threadTasks);
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_odeEqs, a_varDecls) = lm_161(l_odeEqs, ret_1, a_useFlatArrayNotation, a_simCode, a_varDecls, i_iType, a_allEquationsPlusWhen);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        ret_3 = arrayList(a_threadTasks);
        l_threadAssignLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadAssignLocks = lm_162(l_threadAssignLocks, ret_3, i_iType, a_threadTasks);
        l_threadAssignLocks = Tpl.popIter(l_threadAssignLocks);
        ret_5 = arrayList(a_threadTasks);
        l_threadReleaseLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadReleaseLocks = lm_163(l_threadReleaseLocks, ret_5, i_iType, a_threadTasks);
        l_threadReleaseLocks = Tpl.popIter(l_threadReleaseLocks);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if (omp_get_dynamic())\n",
                                    "  omp_set_dynamic(0);\n",
                                    "#pragma omp parallel num_threads("
                                }, false));
        ret_6 = arrayLength(a_threadTasks);
        txt = Tpl.writeStr(txt, intString(ret_6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n",
                                    "   int threadNum = omp_get_thread_num();\n",
                                    "\n",
                                    "   //Assign locks first\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, l_threadAssignLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("#pragma omp barrier\n"));
        txt = Tpl.writeText(txt, l_odeEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma omp barrier\n",
                                    "//Release locks after calculation\n"
                                }, true));
        txt = Tpl.writeText(txt, l_threadReleaseLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           (i_iType as "mpi"),
           a_allEquationsPlusWhen,
           a_threadTasks,
           a_varDecls,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        ret_7 = arrayList(a_threadTasks);
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_odeEqs, a_varDecls) = lm_164(l_odeEqs, ret_7, a_useFlatArrayNotation, a_simCode, a_varDecls, i_iType, a_allEquationsPlusWhen);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int world_rank;\n",
                                    "MPI_Comm_rank(MPI_COMM_WORLD, &world_rank);\n"
                                }, true));
        txt = Tpl.writeText(txt, l_odeEqs);
      then (txt, a_varDecls);

    case ( txt,
           i_iType,
           a_allEquationsPlusWhen,
           a_threadTasks,
           a_varDecls,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        ret_8 = arrayList(a_threadTasks);
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_odeEqs, a_varDecls) = lm_165(l_odeEqs, ret_8, a_useFlatArrayNotation, a_simCode, a_varDecls, i_iType, a_allEquationsPlusWhen);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        txt = Tpl.writeText(txt, l_odeEqs);
      then (txt, a_varDecls);
  end match;
end fun_166;

public function function_HPCOM_Thread
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input array<list<HpcOmSimCode.Task>> a_threadTasks;
  input String a_iType;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_166(txt, a_iType, a_allEquationsPlusWhen, a_threadTasks, a_varDecls, a_simCode, a_useFlatArrayNotation);
end function_HPCOM_Thread;

public function generateThreadFunc
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input array<list<HpcOmSimCode.Task>> a_threadTasks;
  input String a_iType;
  input Integer a_idx;
  input String a_modelNamePrefixStr;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_relLock;
  Tpl.Text l_assLock;
  list<HpcOmSimCode.Task> ret_3;
  Integer ret_2;
  Tpl.Text l_taskEqs;
  Tpl.Text l_varDeclsLoc;
algorithm
  l_varDeclsLoc := Tpl.emptyTxt;
  ret_2 := intAdd(a_idx, 1);
  ret_3 := arrayGet(a_threadTasks, ret_2);
  (l_taskEqs, l_varDeclsLoc) := function_HPCOM_Thread0(Tpl.emptyTxt, a_allEquationsPlusWhen, ret_3, a_idx, a_iType, l_varDeclsLoc, a_simCode, a_useFlatArrayNotation);
  l_assLock := assignLockByLockName(Tpl.emptyTxt, intString(a_idx), "th_lock", a_iType);
  l_relLock := releaseLockByLockName(Tpl.emptyTxt, intString(a_idx), "th_lock1", a_iType);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("void "));
  out_txt := Tpl.writeStr(out_txt, a_modelNamePrefixStr);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("::evaluateThreadFunc"));
  out_txt := Tpl.writeStr(out_txt, intString(a_idx));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "()\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDeclsLoc);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "while(1)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_assLock);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "if(terminateThreads)\n",
                                       "   return;\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_taskEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_relLock);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("}\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
  out_a_varDecls := a_varDecls;
end generateThreadFunc;

protected function fun_169
  input Tpl.Text in_txt;
  input HpcOmSimCode.Task in_a_tt;
  input String in_a_iType;
  input String in_a_iLockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_tt, in_a_iType, in_a_iLockPrefix)
    local
      Tpl.Text txt;
      String a_iType;
      String a_iLockPrefix;
      HpcOmSimCode.Task i_task;

    case ( txt,
           (i_task as HpcOmSimCode.DEPTASK(outgoing = false)),
           a_iType,
           a_iLockPrefix )
      equation
        txt = assignLockByDepTask(txt, i_task, a_iLockPrefix, a_iType);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_169;

protected function lm_170
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input String in_a_iType;
  input String in_a_iLockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_iType, in_a_iLockPrefix)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      String a_iType;
      String a_iLockPrefix;
      HpcOmSimCode.Task i_tt;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_tt :: rest,
           a_iType,
           a_iLockPrefix )
      equation
        txt = fun_169(txt, i_tt, a_iType, a_iLockPrefix);
        txt = Tpl.nextIter(txt);
        txt = lm_170(txt, rest, a_iType, a_iLockPrefix);
      then txt;
  end match;
end lm_170;

public function function_HPCOM_assignThreadLocks
  input Tpl.Text txt;
  input list<HpcOmSimCode.Task> a_iThreadTasks;
  input String a_iLockPrefix;
  input Integer a_iThreadNum;
  input String a_iType;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_lockAssign;
algorithm
  l_lockAssign := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_lockAssign := lm_170(l_lockAssign, a_iThreadTasks, a_iType, a_iLockPrefix);
  l_lockAssign := Tpl.popIter(l_lockAssign);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("if(threadNum == "));
  out_txt := Tpl.writeStr(out_txt, intString(a_iThreadNum));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ")\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_lockAssign);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end function_HPCOM_assignThreadLocks;

protected function fun_172
  input Tpl.Text in_txt;
  input HpcOmSimCode.Task in_a_tt;
  input String in_a_iType;
  input String in_a_iLockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_tt, in_a_iType, in_a_iLockPrefix)
    local
      Tpl.Text txt;
      String a_iType;
      String a_iLockPrefix;
      HpcOmSimCode.Task i_tt;

    case ( txt,
           (i_tt as HpcOmSimCode.DEPTASK(outgoing = true)),
           a_iType,
           a_iLockPrefix )
      equation
        txt = releaseLockByDepTask(txt, i_tt, a_iLockPrefix, a_iType);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_172;

protected function lm_173
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input String in_a_iType;
  input String in_a_iLockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_iType, in_a_iLockPrefix)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      String a_iType;
      String a_iLockPrefix;
      HpcOmSimCode.Task i_tt;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_tt :: rest,
           a_iType,
           a_iLockPrefix )
      equation
        txt = fun_172(txt, i_tt, a_iType, a_iLockPrefix);
        txt = Tpl.nextIter(txt);
        txt = lm_173(txt, rest, a_iType, a_iLockPrefix);
      then txt;
  end match;
end lm_173;

public function function_HPCOM_releaseThreadLocks
  input Tpl.Text txt;
  input list<HpcOmSimCode.Task> a_iThreadTasks;
  input String a_iLockPrefix;
  input Integer a_iThreadNum;
  input String a_iType;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_lockAssign;
algorithm
  l_lockAssign := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_lockAssign := lm_173(l_lockAssign, a_iThreadTasks, a_iType, a_iLockPrefix);
  l_lockAssign := Tpl.popIter(l_lockAssign);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("if(threadNum == "));
  out_txt := Tpl.writeStr(out_txt, intString(a_iThreadNum));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ")\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_lockAssign);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end function_HPCOM_releaseThreadLocks;

protected function lm_175
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input String in_a_iType;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_iType, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      String a_iType;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      HpcOmSimCode.Task i_tt;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_tt :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_iType,
           a_allEquationsPlusWhen )
      equation
        (txt, a_varDecls) = function_HPCOM_Task(txt, a_allEquationsPlusWhen, i_tt, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_175(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_175;

protected function fun_176
  input Tpl.Text in_txt;
  input String in_a_iType;
  input Tpl.Text in_a_threadTasks;
  input Integer in_a_iThreadNum;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_threadTasks, in_a_iThreadNum)
    local
      Tpl.Text txt;
      Tpl.Text a_threadTasks;
      Integer a_iThreadNum;

    case ( txt,
           "openmp",
           a_threadTasks,
           a_iThreadNum )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if(threadNum == "));
        txt = Tpl.writeStr(txt, intString(a_iThreadNum));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_threadTasks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           "pthreads",
           a_threadTasks,
           _ )
      equation
        txt = Tpl.writeText(txt, a_threadTasks);
      then txt;

    case ( txt,
           "pthreads_spin",
           a_threadTasks,
           _ )
      equation
        txt = Tpl.writeText(txt, a_threadTasks);
      then txt;

    case ( txt,
           "mpi",
           a_threadTasks,
           a_iThreadNum )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (world_rank == "));
        txt = Tpl.writeStr(txt, intString(a_iThreadNum));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_threadTasks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_176;

public function function_HPCOM_Thread0
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<HpcOmSimCode.Task> a_threadTaskList;
  input Integer a_iThreadNum;
  input String a_iType;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_threadTasks;
algorithm
  l_threadTasks := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_threadTasks, out_a_varDecls) := lm_175(l_threadTasks, a_threadTaskList, a_useFlatArrayNotation, a_simCode, a_varDecls, a_iType, a_allEquationsPlusWhen);
  l_threadTasks := Tpl.popIter(l_threadTasks);
  out_txt := fun_176(txt, a_iType, l_threadTasks, a_iThreadNum);
end function_HPCOM_Thread0;

protected function lm_178
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      Integer i_eq;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_allEquationsPlusWhen )
      equation
        (txt, a_varDecls) = equationNamesHPCOM_(txt, i_eq, a_allEquationsPlusWhen, SimCode.contextSimulationNonDiscrete, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_178(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_178;

protected function lm_179
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      Integer i_eq;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_allEquationsPlusWhen )
      equation
        (txt, a_varDecls) = equationNamesHPCOM_(txt, i_eq, a_allEquationsPlusWhen, SimCode.contextSimulationNonDiscrete, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_179(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_allEquationsPlusWhen);
      then (txt, a_varDecls);
  end match;
end lm_179;

protected function lm_180
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_task;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_task :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_task));
        txt = Tpl.nextIter(txt);
        txt = lm_180(txt, rest);
      then txt;
  end match;
end lm_180;

protected function fun_181
  input Tpl.Text in_txt;
  input HpcOmSimCode.Task in_a_iTask;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;
  input String in_a_iType;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_iTask, in_a_allEquationsPlusWhen, in_a_iType, in_a_varDecls, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
      String a_iType;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      HpcOmSimCode.Task i_task;
      list<Integer> i_task_nodeIdc;
      Integer i_task_index;
      list<Integer> i_task_eqIdc;
      Tpl.Text l_relLck;
      Tpl.Text l_assLck;
      Tpl.Text l_taskStr;
      Tpl.Text l_varDeclsLocal;
      Tpl.Text l_odeEqs;

    case ( txt,
           HpcOmSimCode.CALCTASK(eqIdc = i_task_eqIdc, index = i_task_index),
           a_allEquationsPlusWhen,
           _,
           a_varDecls,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_odeEqs, a_varDecls) = lm_178(l_odeEqs, i_task_eqIdc, a_useFlatArrayNotation, a_simCode, a_varDecls, a_allEquationsPlusWhen);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        l_varDeclsLocal = Tpl.emptyTxt;
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Task "));
        txt = Tpl.writeStr(txt, intString(i_task_index));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_odeEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// End Task "));
        txt = Tpl.writeStr(txt, intString(i_task_index));
      then (txt, a_varDecls);

    case ( txt,
           HpcOmSimCode.CALCTASK_LEVEL(eqIdc = i_task_eqIdc, nodeIdc = i_task_nodeIdc),
           a_allEquationsPlusWhen,
           _,
           a_varDecls,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_odeEqs, a_varDecls) = lm_179(l_odeEqs, i_task_eqIdc, a_useFlatArrayNotation, a_simCode, a_varDecls, a_allEquationsPlusWhen);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        l_taskStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_taskStr = lm_180(l_taskStr, i_task_nodeIdc);
        l_taskStr = Tpl.popIter(l_taskStr);
        l_varDeclsLocal = Tpl.emptyTxt;
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Tasks "));
        txt = Tpl.writeText(txt, l_taskStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_odeEqs);
      then (txt, a_varDecls);

    case ( txt,
           (i_task as HpcOmSimCode.DEPTASK(outgoing = false)),
           _,
           a_iType,
           a_varDecls,
           _,
           _ )
      equation
        l_assLck = assignLockByDepTask(Tpl.emptyTxt, i_task, "lock", a_iType);
        txt = Tpl.writeText(txt, l_assLck);
      then (txt, a_varDecls);

    case ( txt,
           (i_task as HpcOmSimCode.DEPTASK(outgoing = true)),
           _,
           a_iType,
           a_varDecls,
           _,
           _ )
      equation
        l_relLck = releaseLockByDepTask(Tpl.emptyTxt, i_task, "lock", a_iType);
        txt = Tpl.writeText(txt, l_relLck);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);
  end match;
end fun_181;

public function function_HPCOM_Task
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input HpcOmSimCode.Task a_iTask;
  input String a_iType;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_181(txt, a_iTask, a_allEquationsPlusWhen, a_iType, a_varDecls, a_simCode, a_useFlatArrayNotation);
end function_HPCOM_Task;

public function equationNamesHPCOM_
  input Tpl.Text txt;
  input Integer a_idx;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  SimCode.SimEqSystem ret_1;
  Tpl.Text l_eq;
algorithm
  ret_1 := HpcOmSimCodeMain.getSimCodeEqByIndex(a_allEquationsPlusWhen, a_idx);
  (l_eq, out_a_varDecls) := equationHPCOM_(Tpl.emptyTxt, ret_1, a_idx, a_context, a_varDecls, a_simCode, a_useFlatArrayNotation);
  out_txt := Tpl.writeText(txt, l_eq);
end equationNamesHPCOM_;

public function equationHPCOM_
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input Integer a_idx;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls, _) := CodegenCpp.equation_function_call(txt, a_eq, a_context, a_varDecls, a_simCode, Tpl.strTokText(Tpl.ST_STRING("evaluate")));
end equationHPCOM_;

protected function fun_185
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_threadIdx;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_threadIdx)
    local
      Tpl.Text txt;
      String a_threadIdx;

    case ( txt,
           "openmp",
           _ )
      then txt;

    case ( txt,
           _,
           a_threadIdx )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("evaluateThread"));
        txt = Tpl.writeStr(txt, a_threadIdx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->join();"));
      then txt;
  end match;
end fun_185;

public function function_HPCOM_joinThread
  input Tpl.Text txt;
  input String a_threadIdx;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_185(txt, a_iType, a_threadIdx);
end function_HPCOM_joinThread;

protected function fun_187
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_threadIdx;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_threadIdx)
    local
      Tpl.Text txt;
      String a_threadIdx;

    case ( txt,
           "openmp",
           _ )
      then txt;

    case ( txt,
           _,
           a_threadIdx )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("delete evaluateThread"));
        txt = Tpl.writeStr(txt, a_threadIdx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_187;

public function function_HPCOM_destroyThread
  input Tpl.Text txt;
  input String a_threadIdx;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_187(txt, a_iType, a_threadIdx);
end function_HPCOM_destroyThread;

protected function fun_189
  input Tpl.Text in_txt;
  input String in_a_iType;
  input Integer in_a_threadIdx;
  input String in_a_modelNamePrefixStr;
  input String in_a_funcName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_threadIdx, in_a_modelNamePrefixStr, in_a_funcName)
    local
      Tpl.Text txt;
      Integer a_threadIdx;
      String a_modelNamePrefixStr;
      String a_funcName;

    case ( txt,
           "openmp",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_threadIdx,
           a_modelNamePrefixStr,
           a_funcName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("evaluateThread"));
        txt = Tpl.writeStr(txt, intString(a_threadIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new boost::thread(boost::bind(&"));
        txt = Tpl.writeStr(txt, a_modelNamePrefixStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::"));
        txt = Tpl.writeStr(txt, a_funcName);
        txt = Tpl.writeStr(txt, intString(a_threadIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", this));"));
      then txt;
  end match;
end fun_189;

public function generateThread
  input Tpl.Text txt;
  input Integer a_threadIdx;
  input String a_iType;
  input String a_modelNamePrefixStr;
  input String a_funcName;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_189(txt, a_iType, a_threadIdx, a_modelNamePrefixStr, a_funcName);
end generateThread;

public function getLockNameByDepTask
  input Tpl.Text in_txt;
  input HpcOmSimCode.Task in_a_depTask;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_depTask)
    local
      Tpl.Text txt;
      Integer i_targetIdx;
      Integer i_sourceIdx;

    case ( txt,
           HpcOmSimCode.DEPTASK(sourceTask = HpcOmSimCode.CALCTASK(index = i_sourceIdx), targetTask = HpcOmSimCode.CALCTASK(index = i_targetIdx)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_sourceIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(i_targetIdx));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("invalidLockTask"));
      then txt;
  end match;
end getLockNameByDepTask;

public function initializeLockByDepTask
  input Tpl.Text txt;
  input HpcOmSimCode.Task a_depTask;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_lockName;
algorithm
  l_lockName := getLockNameByDepTask(Tpl.emptyTxt, a_depTask);
  out_txt := initializeLockByLockName(txt, Tpl.textString(l_lockName), a_lockPrefix, a_iType);
end initializeLockByDepTask;

protected function fun_193
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_lockName;
  input String in_a_lockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_lockName, in_a_lockPrefix)
    local
      Tpl.Text txt;
      String a_lockName;
      String a_lockPrefix;

    case ( txt,
           "openmp",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omp_init_lock(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           "pthreads",
           _,
           _ )
      then txt;

    case ( txt,
           "pthreads_spin",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = BOOST_DETAIL_SPINLOCK_INIT;"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_193;

public function initializeLockByLockName
  input Tpl.Text txt;
  input String a_lockName;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_193(txt, a_iType, a_lockName, a_lockPrefix);
end initializeLockByLockName;

protected function fun_195
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_lockName;
  input String in_a_lockPrefix;
  input Integer in_a_numberOfThreads;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_lockName, in_a_lockPrefix, in_a_numberOfThreads)
    local
      Tpl.Text txt;
      String a_lockName;
      String a_lockPrefix;
      Integer a_numberOfThreads;

    case ( txt,
           "pthreads",
           a_lockName,
           a_lockPrefix,
           a_numberOfThreads )
      equation
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeStr(txt, intString(a_numberOfThreads));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           "pthreads_spin",
           a_lockName,
           a_lockPrefix,
           a_numberOfThreads )
      equation
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeStr(txt, intString(a_numberOfThreads));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_195;

public function initializeBarrierByName
  input Tpl.Text txt;
  input String a_lockName;
  input String a_lockPrefix;
  input Integer a_numberOfThreads;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_195(txt, a_iType, a_lockName, a_lockPrefix, a_numberOfThreads);
end initializeBarrierByName;

public function createLockByDepTask
  input Tpl.Text txt;
  input HpcOmSimCode.Task a_depTask;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_lockName;
algorithm
  l_lockName := getLockNameByDepTask(Tpl.emptyTxt, a_depTask);
  out_txt := createLockByLockName(txt, Tpl.textString(l_lockName), a_lockPrefix, a_iType);
end createLockByDepTask;

protected function fun_198
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_lockName;
  input String in_a_lockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_lockName, in_a_lockPrefix)
    local
      Tpl.Text txt;
      String a_lockName;
      String a_lockPrefix;

    case ( txt,
           "openmp",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omp_lock_t "));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           "pthreads",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::mutex "));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           "pthreads_spin",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::detail::spinlock "));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_198;

public function createLockByLockName
  input Tpl.Text txt;
  input String a_lockName;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_198(txt, a_iType, a_lockName, a_lockPrefix);
end createLockByLockName;

protected function fun_200
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_lockName;
  input String in_a_lockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_lockName, in_a_lockPrefix)
    local
      Tpl.Text txt;
      String a_lockName;
      String a_lockPrefix;

    case ( txt,
           "pthreads",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::barrier "));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           "pthreads_spin",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::barrier "));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_200;

public function createBarrierByName
  input Tpl.Text txt;
  input String a_lockName;
  input String a_lockPrefix;
  input Integer a_numOfThreads;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_200(txt, a_iType, a_lockName, a_lockPrefix);
end createBarrierByName;

public function destroyLockByDepTask
  input Tpl.Text txt;
  input HpcOmSimCode.Task a_depTask;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_lockName;
algorithm
  l_lockName := getLockNameByDepTask(Tpl.emptyTxt, a_depTask);
  out_txt := destroyLockByLockName(txt, Tpl.textString(l_lockName), a_lockPrefix, a_iType);
end destroyLockByDepTask;

protected function fun_203
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_lockName;
  input String in_a_lockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_lockName, in_a_lockPrefix)
    local
      Tpl.Text txt;
      String a_lockName;
      String a_lockPrefix;

    case ( txt,
           "openmp",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omp_destroy_lock(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_203;

public function destroyLockByLockName
  input Tpl.Text txt;
  input String a_lockName;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_203(txt, a_iType, a_lockName, a_lockPrefix);
end destroyLockByLockName;

public function assignLockByDepTask
  input Tpl.Text txt;
  input HpcOmSimCode.Task a_depTask;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_lockName;
algorithm
  l_lockName := getLockNameByDepTask(Tpl.emptyTxt, a_depTask);
  out_txt := assignLockByLockName(txt, Tpl.textString(l_lockName), a_lockPrefix, a_iType);
end assignLockByDepTask;

protected function fun_206
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_lockName;
  input String in_a_lockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_lockName, in_a_lockPrefix)
    local
      Tpl.Text txt;
      String a_lockName;
      String a_lockPrefix;

    case ( txt,
           "openmp",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omp_set_lock(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           "pthreads",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".lock();"));
      then txt;

    case ( txt,
           "pthreads_spin",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".lock();"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_206;

public function assignLockByLockName
  input Tpl.Text txt;
  input String a_lockName;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_206(txt, a_iType, a_lockName, a_lockPrefix);
end assignLockByLockName;

public function releaseLockByDepTask
  input Tpl.Text txt;
  input HpcOmSimCode.Task a_depTask;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_lockName;
algorithm
  l_lockName := getLockNameByDepTask(Tpl.emptyTxt, a_depTask);
  out_txt := releaseLockByLockName(txt, Tpl.textString(l_lockName), a_lockPrefix, a_iType);
end releaseLockByDepTask;

protected function fun_209
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_lockName;
  input String in_a_lockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_lockName, in_a_lockPrefix)
    local
      Tpl.Text txt;
      String a_lockName;
      String a_lockPrefix;

    case ( txt,
           "openmp",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omp_unset_lock(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           "pthreads",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".unlock();"));
      then txt;

    case ( txt,
           "pthreads_spin",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".unlock();"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_209;

public function releaseLockByLockName
  input Tpl.Text txt;
  input String a_lockName;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_209(txt, a_iType, a_lockName, a_lockPrefix);
end releaseLockByLockName;

public function simulationMainFileAnalyzation
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_makefileParams_dllext;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), makefileParams = SimCode.MAKEFILE_PARAMS(dllext = i_makefileParams_dllext), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifndef BOOST_ALL_DYN_LINK\n",
                                    "#define BOOST_ALL_DYN_LINK\n",
                                    "  #endif\n",
                                    "#include <boost/shared_ptr.hpp>\n",
                                    "#include <boost/weak_ptr.hpp>\n",
                                    "#include <boost/numeric/ublas/vector.hpp>\n",
                                    "#include <boost/numeric/ublas/matrix.hpp>\n",
                                    "#include <string>\n",
                                    "#include <vector>\n",
                                    "#include <map>\n",
                                    "using std::string;\n",
                                    "using std::vector;\n",
                                    "using std::map;\n",
                                    "\n",
                                    "#ifdef ANALYZATION_MODE\n",
                                    "#include \"Solver/IAlgLoopSolver.h\"\n",
                                    "#include \"DataExchange/SimData.h\"\n",
                                    "#include \"System/IContinuous.h\"\n",
                                    "#include \"System/IMixedSystem.h\"\n",
                                    "#include \"System/IWriteOutput.h\"\n",
                                    "#include \"System/IEvent.h\"\n",
                                    "#include \"System/ITime.h\"\n",
                                    "#include \"System/ISystemProperties.h\"\n",
                                    "#include \"System/ISystemInitialization.h\"\n",
                                    "#include \"System/IStateSelection.h\"\n",
                                    "#include \"SimCoreFactory/OMCFactory/StaticOMCFactory.h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = CodegenUtil.dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension.h\"\n",
                                    "//namespace ublas = boost::numeric::ublas;\n",
                                    "boost::shared_ptr<ISimData> createSimData()\n",
                                    "{\n",
                                    "  boost::shared_ptr<ISimData> sp( new SimData() );\n",
                                    "  return sp;\n",
                                    "}\n",
                                    "\n",
                                    "boost::shared_ptr<IMixedSystem> createSystem(IGlobalSettings* globalSettings, boost::shared_ptr<IAlgLoopSolverFactory> algLoopSolverFactory, boost::shared_ptr<ISimData> simData)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::shared_ptr<IMixedSystem> sp( new "));
        txt = CodegenCpp.lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension(globalSettings, algLoopSolverFactory, simData) );\n",
                                    "return sp;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "#else\n",
                                    "namespace ublas = boost::numeric::ublas;\n",
                                    "#endif\n",
                                    "\n",
                                    "#include <SimCoreFactory/Policies/FactoryConfig.h>\n",
                                    "#include <SimController/ISimController.h>\n",
                                    "\n",
                                    "#if defined(_MSC_VER) || defined(__MINGW32__)\n",
                                    "#include <tchar.h>\n",
                                    "int _tmain(int argc, const _TCHAR* argv[])\n",
                                    "#else\n",
                                    "int main(int argc, const char* argv[])\n",
                                    "#endif\n",
                                    "{\n",
                                    "    try\n",
                                    "    {\n",
                                    "    boost::shared_ptr<OMCFactory>  _factory =  boost::shared_ptr<OMCFactory>(new StaticOMCFactory());\n",
                                    "          //SimController to start simulation\n",
                                    "\n",
                                    "          std::pair<boost::shared_ptr<ISimController>,SimSettings> simulation =  _factory->createSimulation(argc,argv);\n",
                                    "\n",
                                    "\n",
                                    "      //create Modelica system\n",
                                    "       #ifdef ANALYZATION_MODE\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(10));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("std::pair<boost::weak_ptr<IMixedSystem>,boost::weak_ptr<ISimData> > system = simulation.first->LoadSystem(&createSimData, &createSystem, \""));
        txt = CodegenCpp.lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("       #else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(10));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("std::pair<boost::weak_ptr<IMixedSystem>,boost::weak_ptr<ISimData> > system = simulation.first->LoadSystem(\"OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",\""));
        txt = CodegenCpp.lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "       #endif\n",
                                    "          simulation.first->Start(system.first,simulation.second);\n",
                                    "\n",
                                    "\n",
                                    "    }\n",
                                    "    catch(std::exception& ex)\n",
                                    "    {\n",
                                    "        std::string error = ex.what();\n",
                                    "        std::cerr << \"Simulation stopped: \"<<  error ;\n",
                                    "        return 1;\n",
                                    "    }\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationMainFileAnalyzation;

public function MPIInMainFile
  input Tpl.Text in_txt;
  input String in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           "mpi" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "char** argvNotConst = const_cast<char**>(argv);\n",
                                    "MPI_Init(&argc, &argvNotConst);\n",
                                    "int world_rank, world_size;\n",
                                    "MPI_Comm_size(MPI_COMM_WORLD, &world_size);\n",
                                    "MPI_Comm_rank(MPI_COMM_WORLD, &world_rank);\n",
                                    "\n",
                                    "std::cout << \"Hello World! This is MPI process \" << world_rank\n",
                                    "          << \" of \" << world_size << \" processes.\"  << endl;"
                                }, false));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end match;
end MPIInMainFile;

public function IncludeMPIHeader
  input Tpl.Text txt;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#include <mpi.h>"));
end IncludeMPIHeader;

protected function fun_214
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "mpi" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MPI_Finalize();"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_214;

protected function fun_215
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "mpi" )
      equation
        txt = IncludeMPIHeader(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_215;

protected function fun_216
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_MPIFinalize;
  input Tpl.Text in_a_MPICode;
  input Tpl.Text in_a_MPIHeaderInclude;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_MPIFinalize, in_a_MPICode, in_a_MPIHeaderInclude)
    local
      Tpl.Text txt;
      Tpl.Text a_MPIFinalize;
      Tpl.Text a_MPICode;
      Tpl.Text a_MPIHeaderInclude;
      Absyn.Path i_modelInfo_name;
      String i_makefileParams_dllext;
      String i_fileNamePrefix;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), makefileParams = SimCode.MAKEFILE_PARAMS(dllext = i_makefileParams_dllext), fileNamePrefix = i_fileNamePrefix),
           a_MPIFinalize,
           a_MPICode,
           a_MPIHeaderInclude )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifndef BOOST_ALL_DYN_LINK\n",
                                    "  #define BOOST_ALL_DYN_LINK\n",
                                    "#endif\n",
                                    "\n",
                                    "#include \"Modelica.h\"\n",
                                    "#include \"ModelicaDefine.h\"\n",
                                    "#include <SimCoreFactory/Policies/FactoryConfig.h>\n",
                                    "#include <SimController/ISimController.h>\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, a_MPIHeaderInclude);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#if defined(_MSC_VER) || defined(__MINGW32__)\n",
                                    "  #include <tchar.h>\n",
                                    "  int _tmain(int argc, const _TCHAR* argv[])\n",
                                    "#else\n",
                                    "  int main(int argc, const char* argv[])\n",
                                    "#endif\n",
                                    "{\n",
                                    "  try\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_MPICode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "boost::shared_ptr<OMCFactory> _factory = boost::shared_ptr<OMCFactory>(new OMCFactory());\n",
                                    "//SimController to start simulation\n",
                                    "std::pair<boost::shared_ptr<ISimController>, SimSettings> simulation = _factory->createSimulation(argc, argv);\n",
                                    "\n",
                                    "//Create Modelica system\n",
                                    "std::pair<boost::shared_ptr<IMixedSystem>,boost::shared_ptr<ISimData> > system = simulation.first->LoadSystem(\"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", \""));
        txt = CodegenCpp.lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\");\n",
                                    "\n",
                                    "simulation.first->Start(system.first, simulation.second, \""
                                }, false));
        txt = CodegenCpp.lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\");\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, a_MPIFinalize);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  catch(std::exception& ex)\n",
                                    "  {\n",
                                    "    //std::string error = ex.what();\n",
                                    "    std::cerr << \"Simulation stopped: \" << ex.what() << endl; //error;\n",
                                    "    return 1;\n",
                                    "  }\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_216;

public function simulationMainFile
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  String str_6;
  Tpl.Text l_MPIHeaderInclude;
  String str_4;
  Tpl.Text l_MPIFinalize;
  Tpl.Text l_MPICode;
  String ret_1;
  Tpl.Text l_type;
algorithm
  ret_1 := Flags.getConfigString(Flags.HPCOM_CODE);
  l_type := Tpl.writeStr(Tpl.emptyTxt, ret_1);
  l_MPICode := MPIInMainFile(Tpl.emptyTxt, Tpl.textString(l_type));
  str_4 := Tpl.textString(l_type);
  l_MPIFinalize := fun_214(Tpl.emptyTxt, str_4);
  str_6 := Tpl.textString(l_type);
  l_MPIHeaderInclude := fun_215(Tpl.emptyTxt, str_6);
  out_txt := fun_216(txt, a_simCode, l_MPIFinalize, l_MPICode, l_MPIHeaderInclude);
end simulationMainFile;

public function MPIRunCommandInRunScript
  input Tpl.Text in_txt;
  input String in_a_type;
  input Tpl.Text in_a_getNumOfProcs;
  input Tpl.Text in_a_executionCommand;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_getNumOfProcs;
  output Tpl.Text out_a_executionCommand;
algorithm
  (out_txt, out_a_getNumOfProcs, out_a_executionCommand) :=
  match(in_txt, in_a_type, in_a_getNumOfProcs, in_a_executionCommand)
    local
      Tpl.Text txt;
      Tpl.Text a_getNumOfProcs;
      Tpl.Text a_executionCommand;

    case ( txt,
           "mpi",
           a_getNumOfProcs,
           a_executionCommand )
      equation
        a_executionCommand = Tpl.writeTok(a_executionCommand, Tpl.ST_STRING("mpirun -np ${NPROCESSORS}"));
        a_getNumOfProcs = Tpl.writeTok(a_getNumOfProcs, Tpl.ST_STRING_LIST({
                                                            "\n",
                                                            "if [ $# -gt 0 ]; then\n",
                                                            "  NPROCESSORS=$1\n",
                                                            "else\n",
                                                            "  NPROCESSORS=1\n",
                                                            "fi\n",
                                                            "\n"
                                                        }, true));
      then (txt, a_getNumOfProcs, a_executionCommand);

    case ( txt,
           _,
           a_getNumOfProcs,
           a_executionCommand )
      equation
        a_executionCommand = Tpl.writeTok(a_executionCommand, Tpl.ST_STRING("exec"));
      then (txt, a_getNumOfProcs, a_executionCommand);
  end match;
end MPIRunCommandInRunScript;

protected function fun_219
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_executionCommand;
  input Tpl.Text in_a_getNumOfProcs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_executionCommand, in_a_getNumOfProcs)
    local
      Tpl.Text txt;
      Tpl.Text a_executionCommand;
      Tpl.Text a_getNumOfProcs;
      String i_settings_outputFormat;
      SimCode.SimCode i_simCode;
      String i_fileNamePrefix;
      String i_makefileParams_omhome;
      String i_makefileParams_compileDir;
      String i_settings_method;
      Real i_settings_tolerance;
      Integer i_settings_numberOfIntervals;
      Real i_settings_stepSize;
      Real i_settings_stopTime;
      Real i_settings_startTime;
      Boolean ret_9;
      String ret_8;
      Tpl.Text l_home;
      Tpl.Text l_moLib;
      Tpl.Text l_solver;
      Tpl.Text l_tol;
      Tpl.Text l_intervals;
      Tpl.Text l_stepsize;
      Tpl.Text l_end;
      Tpl.Text l_start;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), makefileParams = SimCode.MAKEFILE_PARAMS(compileDir = i_makefileParams_compileDir, omhome = i_makefileParams_omhome), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_settings_startTime, stopTime = i_settings_stopTime, stepSize = i_settings_stepSize, numberOfIntervals = i_settings_numberOfIntervals, tolerance = i_settings_tolerance, method = i_settings_method, outputFormat = i_settings_outputFormat)), fileNamePrefix = i_fileNamePrefix)),
           a_executionCommand,
           a_getNumOfProcs )
      equation
        l_start = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_startTime));
        l_end = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stopTime));
        l_stepsize = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stepSize));
        l_intervals = Tpl.writeStr(Tpl.emptyTxt, intString(i_settings_numberOfIntervals));
        l_tol = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_tolerance));
        l_solver = Tpl.writeStr(Tpl.emptyTxt, i_settings_method);
        l_moLib = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_compileDir);
        l_home = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("#!/bin/sh\n"));
        txt = Tpl.writeText(txt, a_getNumOfProcs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_executionCommand);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ./OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Main -s "));
        txt = Tpl.writeText(txt, l_start);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -e "));
        txt = Tpl.writeText(txt, l_end);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -f "));
        txt = Tpl.writeText(txt, l_stepsize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -v "));
        txt = Tpl.writeText(txt, l_intervals);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -y "));
        txt = Tpl.writeText(txt, l_tol);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -i "));
        txt = Tpl.writeText(txt, l_solver);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -r "));
        ret_8 = Config.simulationCodeTarget();
        txt = CodegenCpp.simulationLibDir(txt, ret_8, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -m "));
        txt = Tpl.writeText(txt, l_moLib);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -R "));
        ret_9 = Config.getRunningTestsuite();
        txt = CodegenCpp.simulationResults(txt, ret_9, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -o "));
        txt = Tpl.writeStr(txt, i_settings_outputFormat);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $*"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_219;

protected function fun_220
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_executionCommand;
  input Tpl.Text in_a_getNumOfProcs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_executionCommand, in_a_getNumOfProcs)
    local
      Tpl.Text txt;
      Tpl.Text a_executionCommand;
      Tpl.Text a_getNumOfProcs;
      String i_settings_outputFormat;
      SimCode.SimCode i_simCode;
      String i_fileNamePrefix;
      String i_makefileParams_omhome;
      String i_makefileParams_compileDir;
      String i_settings_method;
      Real i_settings_tolerance;
      Integer i_settings_numberOfIntervals;
      Real i_settings_stepSize;
      Real i_settings_stopTime;
      Real i_settings_startTime;
      Boolean ret_9;
      String ret_8;
      Tpl.Text l_home;
      Tpl.Text l_moLib;
      Tpl.Text l_solver;
      Tpl.Text l_tol;
      Tpl.Text l_intervals;
      Tpl.Text l_stepsize;
      Tpl.Text l_end;
      Tpl.Text l_start;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), makefileParams = SimCode.MAKEFILE_PARAMS(compileDir = i_makefileParams_compileDir, omhome = i_makefileParams_omhome), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_settings_startTime, stopTime = i_settings_stopTime, stepSize = i_settings_stepSize, numberOfIntervals = i_settings_numberOfIntervals, tolerance = i_settings_tolerance, method = i_settings_method, outputFormat = i_settings_outputFormat)), fileNamePrefix = i_fileNamePrefix)),
           a_executionCommand,
           a_getNumOfProcs )
      equation
        l_start = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_startTime));
        l_end = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stopTime));
        l_stepsize = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stepSize));
        l_intervals = Tpl.writeStr(Tpl.emptyTxt, intString(i_settings_numberOfIntervals));
        l_tol = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_tolerance));
        l_solver = Tpl.writeStr(Tpl.emptyTxt, i_settings_method);
        l_moLib = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_compileDir);
        l_home = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("#!/bin/sh\n"));
        txt = Tpl.writeText(txt, a_getNumOfProcs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_executionCommand);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ./OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Main -s "));
        txt = Tpl.writeText(txt, l_start);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -e "));
        txt = Tpl.writeText(txt, l_end);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -f "));
        txt = Tpl.writeText(txt, l_stepsize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -v "));
        txt = Tpl.writeText(txt, l_intervals);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -y "));
        txt = Tpl.writeText(txt, l_tol);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -i "));
        txt = Tpl.writeText(txt, l_solver);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -r "));
        ret_8 = Config.simulationCodeTarget();
        txt = CodegenCpp.simulationLibDir(txt, ret_8, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -m "));
        txt = Tpl.writeText(txt, l_moLib);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -R "));
        ret_9 = Config.getRunningTestsuite();
        txt = CodegenCpp.simulationResults(txt, ret_9, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -o "));
        txt = Tpl.writeStr(txt, i_settings_outputFormat);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $*"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_220;

protected function fun_221
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_settings_outputFormat;
      SimCode.SimCode i_simCode;
      String i_fileNamePrefix;
      String i_makefileParams_omhome;
      String i_makefileParams_compileDir;
      String i_settings_method;
      Real i_settings_tolerance;
      Integer i_settings_numberOfIntervals;
      Real i_settings_stepSize;
      Real i_settings_stopTime;
      Real i_settings_startTime;
      Boolean ret_9;
      String ret_8;
      Tpl.Text l_home;
      Tpl.Text l_moLib;
      Tpl.Text l_solver;
      Tpl.Text l_tol;
      Tpl.Text l_intervals;
      Tpl.Text l_stepsize;
      Tpl.Text l_end;
      Tpl.Text l_start;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), makefileParams = SimCode.MAKEFILE_PARAMS(compileDir = i_makefileParams_compileDir, omhome = i_makefileParams_omhome), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_settings_startTime, stopTime = i_settings_stopTime, stepSize = i_settings_stepSize, numberOfIntervals = i_settings_numberOfIntervals, tolerance = i_settings_tolerance, method = i_settings_method, outputFormat = i_settings_outputFormat)), fileNamePrefix = i_fileNamePrefix)) )
      equation
        l_start = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_startTime));
        l_end = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stopTime));
        l_stepsize = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stepSize));
        l_intervals = Tpl.writeStr(Tpl.emptyTxt, intString(i_settings_numberOfIntervals));
        l_tol = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_tolerance));
        l_solver = Tpl.writeStr(Tpl.emptyTxt, i_settings_method);
        l_moLib = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_compileDir);
        l_home = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("@echo off\n"));
        txt = Tpl.writeText(txt, l_moLib);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Main.exe -s "));
        txt = Tpl.writeText(txt, l_start);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -e "));
        txt = Tpl.writeText(txt, l_end);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -f "));
        txt = Tpl.writeText(txt, l_stepsize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -v "));
        txt = Tpl.writeText(txt, l_intervals);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -y "));
        txt = Tpl.writeText(txt, l_tol);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -i "));
        txt = Tpl.writeText(txt, l_solver);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -r "));
        ret_8 = Config.simulationCodeTarget();
        txt = CodegenCpp.simulationLibDir(txt, ret_8, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -m "));
        txt = Tpl.writeText(txt, l_moLib);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -R "));
        ret_9 = Config.getRunningTestsuite();
        txt = CodegenCpp.simulationResults(txt, ret_9, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -o "));
        txt = Tpl.writeStr(txt, i_settings_outputFormat);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_221;

protected function fun_222
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_settings_outputFormat;
      SimCode.SimCode i_simCode;
      String i_fileNamePrefix;
      String i_makefileParams_omhome;
      String i_makefileParams_compileDir;
      String i_settings_method;
      Real i_settings_tolerance;
      Integer i_settings_numberOfIntervals;
      Real i_settings_stepSize;
      Real i_settings_stopTime;
      Real i_settings_startTime;
      Boolean ret_9;
      String ret_8;
      Tpl.Text l_home;
      Tpl.Text l_moLib;
      Tpl.Text l_solver;
      Tpl.Text l_tol;
      Tpl.Text l_intervals;
      Tpl.Text l_stepsize;
      Tpl.Text l_end;
      Tpl.Text l_start;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), makefileParams = SimCode.MAKEFILE_PARAMS(compileDir = i_makefileParams_compileDir, omhome = i_makefileParams_omhome), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_settings_startTime, stopTime = i_settings_stopTime, stepSize = i_settings_stepSize, numberOfIntervals = i_settings_numberOfIntervals, tolerance = i_settings_tolerance, method = i_settings_method, outputFormat = i_settings_outputFormat)), fileNamePrefix = i_fileNamePrefix)) )
      equation
        l_start = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_startTime));
        l_end = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stopTime));
        l_stepsize = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stepSize));
        l_intervals = Tpl.writeStr(Tpl.emptyTxt, intString(i_settings_numberOfIntervals));
        l_tol = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_tolerance));
        l_solver = Tpl.writeStr(Tpl.emptyTxt, i_settings_method);
        l_moLib = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_compileDir);
        l_home = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("@echo off\n"));
        txt = Tpl.writeText(txt, l_moLib);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Main.exe -s "));
        txt = Tpl.writeText(txt, l_start);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -e "));
        txt = Tpl.writeText(txt, l_end);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -f "));
        txt = Tpl.writeText(txt, l_stepsize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -v "));
        txt = Tpl.writeText(txt, l_intervals);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -y "));
        txt = Tpl.writeText(txt, l_tol);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -i "));
        txt = Tpl.writeText(txt, l_solver);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -r "));
        ret_8 = Config.simulationCodeTarget();
        txt = CodegenCpp.simulationLibDir(txt, ret_8, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -m "));
        txt = Tpl.writeText(txt, l_moLib);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -R "));
        ret_9 = Config.getRunningTestsuite();
        txt = CodegenCpp.simulationResults(txt, ret_9, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -o "));
        txt = Tpl.writeStr(txt, i_settings_outputFormat);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_222;

protected function fun_223
  input Tpl.Text in_txt;
  input String in_a_makefileParams_platform;
  input Tpl.Text in_a_executionCommand;
  input Tpl.Text in_a_getNumOfProcs;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_makefileParams_platform, in_a_executionCommand, in_a_getNumOfProcs, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_executionCommand;
      Tpl.Text a_getNumOfProcs;
      SimCode.SimCode a_simCode;

    case ( txt,
           "linux64",
           a_executionCommand,
           a_getNumOfProcs,
           a_simCode )
      equation
        txt = fun_219(txt, a_simCode, a_executionCommand, a_getNumOfProcs);
      then txt;

    case ( txt,
           "linux32",
           a_executionCommand,
           a_getNumOfProcs,
           a_simCode )
      equation
        txt = fun_220(txt, a_simCode, a_executionCommand, a_getNumOfProcs);
      then txt;

    case ( txt,
           "win32",
           _,
           _,
           a_simCode )
      equation
        txt = fun_221(txt, a_simCode);
      then txt;

    case ( txt,
           "win64",
           _,
           _,
           a_simCode )
      equation
        txt = fun_222(txt, a_simCode);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_223;

protected function fun_224
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_executionCommand;
  input Tpl.Text in_a_getNumOfProcs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_executionCommand, in_a_getNumOfProcs)
    local
      Tpl.Text txt;
      Tpl.Text a_executionCommand;
      Tpl.Text a_getNumOfProcs;
      SimCode.SimCode i_simCode;
      String i_makefileParams_platform;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(makefileParams = SimCode.MAKEFILE_PARAMS(platform = i_makefileParams_platform))),
           a_executionCommand,
           a_getNumOfProcs )
      equation
        txt = fun_223(txt, i_makefileParams_platform, a_executionCommand, a_getNumOfProcs, i_simCode);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_224;

public function simulationMainRunScript
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_0__;
  Tpl.Text l_executionCommand;
  Tpl.Text l_getNumOfProcs;
  String ret_1;
  Tpl.Text l_type;
algorithm
  ret_1 := Flags.getConfigString(Flags.HPCOM_CODE);
  l_type := Tpl.writeStr(Tpl.emptyTxt, ret_1);
  l_getNumOfProcs := Tpl.emptyTxt;
  l_executionCommand := Tpl.emptyTxt;
  (l_0__, l_getNumOfProcs, l_executionCommand) := MPIRunCommandInRunScript(Tpl.emptyTxt, Tpl.textString(l_type), l_getNumOfProcs, l_executionCommand);
  out_txt := fun_224(txt, a_simCode, l_executionCommand, l_getNumOfProcs);
end simulationMainRunScript;

protected function fun_226
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -fopenmp"));
      then txt;
  end match;
end fun_226;

protected function fun_227
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -D ANALYZATION_MODE -I\"$(SUNDIALS_INCLUDE)\" -I\"$(SUNDIALS_INCLUDE)/kinsol\" -I\"$(SUNDIALS_INCLUDE)/nvector\""));
      then txt;
  end match;
end fun_227;

protected function fun_228
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/openmp"));
      then txt;
  end match;
end fun_228;

protected function fun_229
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/DANALYZATION_MODE /I\"$(SUNDIALS_INCLUDE)\" /I\"$(SUNDIALS_INCLUDE)/kinsol\" /I\"$(SUNDIALS_INCLUDE)/nvector\""));
      then txt;
  end match;
end fun_229;

protected function fun_230
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lOMCppOMCFactory $(BASE_LIB)"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(LIBOMCPPOMCFACTORY) $(LIBOMCPPSIMCONTROLLER) $(LIBOMCPPSIMULATIONSETTINGS) $(LIBOMCPPSYSTEM) $(LIBOMCPPDATAEXCHANGE) $(LIBOMCPPNEWTON) $(LIBOMCPPUMFPACK) $(LIBOMCPPKINSOL) $(LIBOMCPPCVODE) $(LIBOMCPPSOLVER) $(LIBOMCPPMATH) $(LIBOMCPPMODELICAUTILITIES) $(SUNDIALS_LIBS) $(LAPACK_LIBS) $(BASE_LIB)"));
      then txt;
  end match;
end fun_230;

protected function fun_231
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-ltbb"));
      then txt;
  end match;
end fun_231;

protected function fun_232
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end match;
end fun_232;

public function simulationMakefile
  input Tpl.Text txt;
  input String a_target;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Boolean ret_14;
  Boolean ret_13;
  Tpl.Text l_compileForMPI;
  Tpl.Text l_additionalLinkerFlags__MSVC;
  Boolean ret_10;
  Boolean ret_9;
  Tpl.Text l_additionalLinkerFlags__GCC;
  Boolean ret_7;
  Boolean ret_6;
  Tpl.Text l_additionalCFlags__MSVC;
  Boolean ret_4;
  Boolean ret_3;
  Tpl.Text l_additionalCFlags__GCC;
  String ret_1;
  Tpl.Text l_type;
algorithm
  ret_1 := Flags.getConfigString(Flags.HPCOM_CODE);
  l_type := Tpl.writeStr(Tpl.emptyTxt, ret_1);
  l_additionalCFlags__GCC := Tpl.emptyTxt;
  ret_3 := stringEq(Tpl.textString(l_type), "openmp");
  l_additionalCFlags__GCC := fun_226(l_additionalCFlags__GCC, ret_3);
  ret_4 := Flags.isSet(Flags.HPCOM_ANALYZATION_MODE);
  l_additionalCFlags__GCC := fun_227(l_additionalCFlags__GCC, ret_4);
  l_additionalCFlags__MSVC := Tpl.emptyTxt;
  ret_6 := stringEq(Tpl.textString(l_type), "openmp");
  l_additionalCFlags__MSVC := fun_228(l_additionalCFlags__MSVC, ret_6);
  ret_7 := Flags.isSet(Flags.HPCOM_ANALYZATION_MODE);
  l_additionalCFlags__MSVC := fun_229(l_additionalCFlags__MSVC, ret_7);
  l_additionalLinkerFlags__GCC := Tpl.emptyTxt;
  ret_9 := Flags.isSet(Flags.HPCOM_ANALYZATION_MODE);
  l_additionalLinkerFlags__GCC := fun_230(l_additionalLinkerFlags__GCC, ret_9);
  ret_10 := stringEq(Tpl.textString(l_type), "tbb");
  l_additionalLinkerFlags__GCC := fun_231(l_additionalLinkerFlags__GCC, ret_10);
  l_additionalLinkerFlags__MSVC := Tpl.emptyTxt;
  l_compileForMPI := Tpl.emptyTxt;
  ret_13 := stringEq(Tpl.textString(l_type), "mpi");
  l_compileForMPI := fun_232(l_compileForMPI, ret_13);
  ret_14 := Util.stringBool(Tpl.textString(l_compileForMPI));
  out_txt := CodegenCpp.simulationMakefile(txt, a_target, a_simCode, Tpl.textString(l_additionalLinkerFlags__GCC), Tpl.textString(l_additionalCFlags__MSVC), Tpl.textString(l_additionalCFlags__GCC), Tpl.textString(l_additionalLinkerFlags__MSVC), ret_14);
end simulationMakefile;

protected function lm_234
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine2(txt, i_var, "algebraics", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_234(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_234;

protected function lm_235
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine2(txt, i_var, "algebraics", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_235(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_235;

protected function lm_236
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine2(txt, i_var, "parameters", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_236(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_236;

protected function lm_237
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine2(txt, i_var, "aliasVars", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_237(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_237;

protected function lm_238
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "int", i_var, "intVariables.algebraics", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_238(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_238;

protected function lm_239
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "int", i_var, "intVariables.parameters", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_239(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_239;

protected function lm_240
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "int", i_var, "intVariables.AliasVars", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_240(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_240;

protected function lm_241
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "bool", i_var, "boolVariables.algebraics", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_241(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_241;

protected function lm_242
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "bool", i_var, "boolVariables.parameters", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_242(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_242;

protected function lm_243
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "bool ", i_var, "boolVariables.AliasVars", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_243(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_243;

protected function lm_244
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "string", i_var, "stringVariables.algebraics", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_244(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_244;

protected function lm_245
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "string", i_var, "stringVariables.parameters", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_245(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_245;

protected function lm_246
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "string", i_var, "stringVariables.AliasVars", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_246(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_246;

protected function lm_247
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine2(txt, i_var, "constvariables", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_247(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_247;

protected function lm_248
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "const int", i_var, "intConstvariables", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_248(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_248;

protected function lm_249
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "const bool", i_var, "boolConstvariables", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_249(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_249;

protected function lm_250
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "const string", i_var, "stringConstvariables", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_250(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_250;

protected function lm_251
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_hpcOmMemory )
      equation
        txt = MemberVariableDefine(txt, "void*", i_var, "extObjVars", a_hpcOmMemory, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_251(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
      then txt;
  end match;
end lm_251;

public function MemberVariable
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemory;
  input Boolean in_a_useFlatArrayNotation;
  input Boolean in_a_createConstructorDeclaration;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_hpcOmMemory, in_a_useFlatArrayNotation, in_a_createConstructorDeclaration)
    local
      Tpl.Text txt;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemory;
      Boolean a_useFlatArrayNotation;
      Boolean a_createConstructorDeclaration;
      list<SimCodeVar.SimVar> i_vars_extObjVars;
      list<SimCodeVar.SimVar> i_vars_stringConstVars;
      list<SimCodeVar.SimVar> i_vars_boolConstVars;
      list<SimCodeVar.SimVar> i_vars_intConstVars;
      list<SimCodeVar.SimVar> i_vars_constVars;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, constVars = i_vars_constVars, intConstVars = i_vars_intConstVars, boolConstVars = i_vars_boolConstVars, stringConstVars = i_vars_stringConstVars, extObjVars = i_vars_extObjVars)),
           a_hpcOmMemory,
           a_useFlatArrayNotation,
           a_createConstructorDeclaration )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_234(txt, i_vars_algVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_235(txt, i_vars_discreteAlgVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_236(txt, i_vars_paramVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_237(txt, i_vars_aliasVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_238(txt, i_vars_intAlgVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_239(txt, i_vars_intParamVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_240(txt, i_vars_intAliasVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_241(txt, i_vars_boolAlgVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_242(txt, i_vars_boolParamVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_243(txt, i_vars_boolAliasVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_244(txt, i_vars_stringAlgVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_245(txt, i_vars_stringParamVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_246(txt, i_vars_stringAliasVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_247(txt, i_vars_constVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_248(txt, i_vars_intConstVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_249(txt, i_vars_boolConstVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_250(txt, i_vars_stringConstVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_251(txt, i_vars_extObjVars, a_createConstructorDeclaration, a_useFlatArrayNotation, a_hpcOmMemory);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end MemberVariable;

protected function fun_253
  input Tpl.Text in_txt;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input DAE.ComponentRef in_a_simVar_name;
  input DAE.Type in_a_simVar_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_simVar_name, in_a_simVar_type__)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      DAE.ComponentRef a_simVar_name;
      DAE.Type a_simVar_type__;

    case ( txt,
           false,
           a_useFlatArrayNotation,
           a_simVar_name,
           a_simVar_type__ )
      equation
        txt = CodegenCpp.variableType(txt, a_simVar_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = CodegenCpp.cref(txt, a_simVar_name, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //no cacheMap defined"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_253;

protected function fun_254
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemoryOpt;
  input DAE.ComponentRef in_a_simVar_name;
  input DAE.Type in_a_simVar_type__;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input SimCodeVar.SimVar in_a_simVar;
  input DAE.ComponentRef in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmMemoryOpt, in_a_simVar_name, in_a_simVar_type__, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_simVar, in_a_varName)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_simVar_name;
      DAE.Type a_simVar_type__;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar a_simVar;
      DAE.ComponentRef a_varName;
      HpcOmSimCode.MemoryMap i_hpcOmMemory;
      Option<tuple<Integer, Integer>> ret_0;

    case ( txt,
           SOME(i_hpcOmMemory),
           _,
           _,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_simVar,
           a_varName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("// case 2 MemberVariableDefine\n"));
        ret_0 = HpcOmMemory.getPositionMappingByArrayName(i_hpcOmMemory, a_varName);
        txt = MemberVariableDefine3(txt, ret_0, a_simVar, a_useFlatArrayNotation, a_createConstructorDeclaration);
      then txt;

    case ( txt,
           _,
           a_simVar_name,
           a_simVar_type__,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           _,
           _ )
      equation
        txt = fun_253(txt, a_createConstructorDeclaration, a_useFlatArrayNotation, a_simVar_name, a_simVar_type__);
      then txt;
  end match;
end fun_254;

protected function lm_255
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input DAE.Type in_a_varType;
  input HpcOmSimCode.MemoryMap in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_varType, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      DAE.Type a_varType;
      HpcOmSimCode.MemoryMap a_hpcOmMemory;
      DAE.ComponentRef i_crefLocal;
      Option<tuple<Integer, Integer>> ret_0;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_crefLocal :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_varType,
           a_hpcOmMemory )
      equation
        ret_0 = HpcOmMemory.getPositionMappingByArrayName(a_hpcOmMemory, i_crefLocal);
        txt = MemberVariableDefine4(txt, ret_0, i_crefLocal, a_varType, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_255(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_varType, a_hpcOmMemory);
      then txt;
  end match;
end lm_255;

protected function lm_256
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = lm_256(txt, rest);
      then txt;
  end match;
end lm_256;

protected function fun_257
  input Tpl.Text in_txt;
  input Boolean in_a_createConstructorDeclaration;
  input Tpl.Text in_a_arrayName;
  input Tpl.Text in_a_arraysize;
  input DAE.Type in_a_v_type__;
  input Tpl.Text in_a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_createConstructorDeclaration, in_a_arrayName, in_a_arraysize, in_a_v_type__, in_a_dims)
    local
      Tpl.Text txt;
      Tpl.Text a_arrayName;
      Tpl.Text a_arraysize;
      DAE.Type a_v_type__;
      Tpl.Text a_dims;

    case ( txt,
           false,
           a_arrayName,
           a_arraysize,
           a_v_type__,
           a_dims )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StatArrayDim"));
        txt = Tpl.writeText(txt, a_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<"));
        txt = CodegenCpp.variableType(txt, a_v_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_arraysize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">  "));
        txt = Tpl.writeText(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //no cacheMap defined"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_257;

protected function fun_258
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemoryOpt;
  input Tpl.Text in_a_arrayName;
  input Tpl.Text in_a_arraysize;
  input DAE.Type in_a_v_type__;
  input Tpl.Text in_a_dims;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input DAE.Type in_a_varType;
  input list<String> in_a_num;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmMemoryOpt, in_a_arrayName, in_a_arraysize, in_a_v_type__, in_a_dims, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_varType, in_a_num, in_a_name)
    local
      Tpl.Text txt;
      Tpl.Text a_arrayName;
      Tpl.Text a_arraysize;
      DAE.Type a_v_type__;
      Tpl.Text a_dims;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      DAE.Type a_varType;
      list<String> a_num;
      DAE.ComponentRef a_name;
      HpcOmSimCode.MemoryMap i_hpcOmMemory;
      list<DAE.ComponentRef> ret_1;
      Tpl.Text l_varDeclarations;

    case ( txt,
           SOME(i_hpcOmMemory),
           _,
           _,
           _,
           a_dims,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_varType,
           a_num,
           a_name )
      equation
        ret_1 = HpcOmMemory.expandCref(a_name, a_num);
        l_varDeclarations = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_varDeclarations = lm_255(l_varDeclarations, ret_1, a_createConstructorDeclaration, a_useFlatArrayNotation, a_varType, i_hpcOmMemory);
        l_varDeclarations = Tpl.popIter(l_varDeclarations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// case 3 MemberVariableDefine dims:"));
        txt = Tpl.writeText(txt, a_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" nums:"));
        txt = lm_256(txt, a_num);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varDeclarations);
      then txt;

    case ( txt,
           _,
           a_arrayName,
           a_arraysize,
           a_v_type__,
           a_dims,
           a_createConstructorDeclaration,
           _,
           _,
           _,
           _ )
      equation
        txt = fun_257(txt, a_createConstructorDeclaration, a_arrayName, a_arraysize, a_v_type__, a_dims);
      then txt;
  end match;
end fun_258;

protected function fun_259
  input Tpl.Text in_txt;
  input Boolean in_a_createConstructorDeclaration;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_createConstructorDeclaration, in_a_varName, in_a_varType)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      Tpl.Text a_varType;

    case ( txt,
           false,
           a_varName,
           a_varType )
      equation
        txt = Tpl.writeText(txt, a_varType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_259;

protected function fun_260
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varType;
  input Boolean in_a_createConstructorDeclaration;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName, in_a_varType, in_a_createConstructorDeclaration)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      Tpl.Text a_varType;
      Boolean a_createConstructorDeclaration;

    case ( txt,
           "0",
           a_varName,
           a_varType,
           a_createConstructorDeclaration )
      equation
        txt = fun_259(txt, a_createConstructorDeclaration, a_varName, a_varType);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_260;

protected function fun_261
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemoryOpt;
  input Boolean in_a_useFlatArrayNotation;
  input Boolean in_a_createConstructorDeclaration;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_hpcOmMemoryOpt, in_a_useFlatArrayNotation, in_a_createConstructorDeclaration)
    local
      Tpl.Text txt;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemoryOpt;
      Boolean a_useFlatArrayNotation;
      Boolean a_createConstructorDeclaration;
      DAE.Type i_v_type__;
      DAE.Type i_varType;
      list<String> i_num;
      list<String> i_v_numArrayElement;
      DAE.Type i_type__;
      DAE.ComponentRef i_name;
      DAE.ComponentRef i_simVar_name;
      DAE.Type i_simVar_type__;
      SimCodeVar.SimVar i_simVar;
      DAE.ComponentRef i_varName;
      String str_6;
      Tpl.Text l_varType;
      Tpl.Text l_varName;
      Tpl.Text l_arraysize;
      Tpl.Text l_typeString;
      Tpl.Text l_arrayName;
      Tpl.Text l_dims;

    case ( txt,
           SimCodeVar.SIMVAR(numArrayElement = {}, arrayCref = NONE(), name = DAE.CREF_IDENT(subscriptLst = _ :: _)),
           _,
           _,
           _ )
      then txt;

    case ( txt,
           (i_simVar as SimCodeVar.SIMVAR(name = (i_simVar_name as i_varName), numArrayElement = {}, arrayCref = NONE(), type_ = i_simVar_type__)),
           a_hpcOmMemoryOpt,
           a_useFlatArrayNotation,
           a_createConstructorDeclaration )
      equation
        txt = fun_254(txt, a_hpcOmMemoryOpt, i_simVar_name, i_simVar_type__, a_createConstructorDeclaration, a_useFlatArrayNotation, i_simVar, i_varName);
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(_), numArrayElement = _, type_ = i_type__),
           _,
           _,
           _ )
      equation
        l_dims = Tpl.emptyTxt;
        (l_arrayName, l_dims) = CodegenCpp.arraycref2(Tpl.emptyTxt, i_name, l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("multi_array<"));
        txt = CodegenCpp.variableType(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">  "));
        txt = Tpl.writeText(txt, l_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = (i_v_numArrayElement as i_num), type_ = (i_type__ as (i_v_type__ as i_varType))),
           a_hpcOmMemoryOpt,
           a_useFlatArrayNotation,
           a_createConstructorDeclaration )
      equation
        l_dims = Tpl.emptyTxt;
        (l_arrayName, l_dims) = CodegenCpp.arraycref2(Tpl.emptyTxt, i_name, l_dims);
        l_typeString = CodegenCpp.variableType(Tpl.emptyTxt, i_type__);
        l_arraysize = CodegenCpp.arrayextentDims(Tpl.emptyTxt, i_name, i_v_numArrayElement);
        txt = fun_258(txt, a_hpcOmMemoryOpt, l_arrayName, l_arraysize, i_v_type__, l_dims, a_createConstructorDeclaration, a_useFlatArrayNotation, i_varType, i_num, i_name);
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(numArrayElement = _ :: _, name = i_name, type_ = i_type__),
           _,
           _,
           a_createConstructorDeclaration )
      equation
        l_dims = Tpl.emptyTxt;
        (l_varName, l_dims) = CodegenCpp.arraycref2(Tpl.emptyTxt, i_name, l_dims);
        l_varType = CodegenCpp.variableType(Tpl.emptyTxt, i_type__);
        str_6 = Tpl.textString(l_dims);
        txt = fun_260(txt, str_6, l_varName, l_varType, a_createConstructorDeclaration);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_261;

public function MemberVariableDefine
  input Tpl.Text txt;
  input String a_type;
  input SimCodeVar.SimVar a_simVar;
  input String a_arrayName;
  input Option<HpcOmSimCode.MemoryMap> a_hpcOmMemoryOpt;
  input Boolean a_useFlatArrayNotation;
  input Boolean a_createConstructorDeclaration;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_261(txt, a_simVar, a_hpcOmMemoryOpt, a_useFlatArrayNotation, a_createConstructorDeclaration);
end MemberVariableDefine;

protected function fun_263
  input Tpl.Text in_txt;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input DAE.ComponentRef in_a_simVar_name;
  input DAE.Type in_a_simVar_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_simVar_name, in_a_simVar_type__)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      DAE.ComponentRef a_simVar_name;
      DAE.Type a_simVar_type__;

    case ( txt,
           false,
           a_useFlatArrayNotation,
           a_simVar_name,
           a_simVar_type__ )
      equation
        txt = CodegenCpp.variableType(txt, a_simVar_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = CodegenCpp.cref(txt, a_simVar_name, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //no cacheMap defined"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_263;

protected function fun_264
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemoryOpt;
  input DAE.ComponentRef in_a_simVar_name;
  input DAE.Type in_a_simVar_type__;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input SimCodeVar.SimVar in_a_simVar;
  input DAE.ComponentRef in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmMemoryOpt, in_a_simVar_name, in_a_simVar_type__, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_simVar, in_a_varName)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_simVar_name;
      DAE.Type a_simVar_type__;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar a_simVar;
      DAE.ComponentRef a_varName;
      HpcOmSimCode.MemoryMap i_hpcOmMemory;
      Option<tuple<Integer, Integer>> ret_0;

    case ( txt,
           SOME(i_hpcOmMemory),
           _,
           _,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_simVar,
           a_varName )
      equation
        ret_0 = HpcOmMemory.getPositionMappingByArrayName(i_hpcOmMemory, a_varName);
        txt = MemberVariableDefine3(txt, ret_0, a_simVar, a_useFlatArrayNotation, a_createConstructorDeclaration);
      then txt;

    case ( txt,
           _,
           a_simVar_name,
           a_simVar_type__,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           _,
           _ )
      equation
        txt = fun_263(txt, a_createConstructorDeclaration, a_useFlatArrayNotation, a_simVar_name, a_simVar_type__);
      then txt;
  end match;
end fun_264;

protected function lm_265
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input DAE.Type in_a_varType;
  input HpcOmSimCode.MemoryMap in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_varType, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      DAE.Type a_varType;
      HpcOmSimCode.MemoryMap a_hpcOmMemory;
      DAE.ComponentRef i_crefLocal;
      Option<tuple<Integer, Integer>> ret_0;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_crefLocal :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_varType,
           a_hpcOmMemory )
      equation
        ret_0 = HpcOmMemory.getPositionMappingByArrayName(a_hpcOmMemory, i_crefLocal);
        txt = MemberVariableDefine4(txt, ret_0, i_crefLocal, a_varType, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_265(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_varType, a_hpcOmMemory);
      then txt;
  end match;
end lm_265;

protected function fun_266
  input Tpl.Text in_txt;
  input Boolean in_a_createConstructorDeclaration;
  input Tpl.Text in_a_arrayName;
  input Tpl.Text in_a_arraysize;
  input Tpl.Text in_a_typeString;
  input Tpl.Text in_a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_createConstructorDeclaration, in_a_arrayName, in_a_arraysize, in_a_typeString, in_a_dims)
    local
      Tpl.Text txt;
      Tpl.Text a_arrayName;
      Tpl.Text a_arraysize;
      Tpl.Text a_typeString;
      Tpl.Text a_dims;

    case ( txt,
           false,
           a_arrayName,
           a_arraysize,
           a_typeString,
           a_dims )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StatArrayDim"));
        txt = Tpl.writeText(txt, a_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<"));
        txt = Tpl.writeText(txt, a_typeString);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_arraysize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = Tpl.writeText(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //no cacheMap defined"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_266;

protected function fun_267
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemoryOpt;
  input Tpl.Text in_a_arrayName;
  input Tpl.Text in_a_arraysize;
  input Tpl.Text in_a_typeString;
  input Tpl.Text in_a_dims;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input DAE.Type in_a_varType;
  input list<String> in_a_num;
  input DAE.ComponentRef in_a_arrayCrefLocal;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmMemoryOpt, in_a_arrayName, in_a_arraysize, in_a_typeString, in_a_dims, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_varType, in_a_num, in_a_arrayCrefLocal)
    local
      Tpl.Text txt;
      Tpl.Text a_arrayName;
      Tpl.Text a_arraysize;
      Tpl.Text a_typeString;
      Tpl.Text a_dims;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      DAE.Type a_varType;
      list<String> a_num;
      DAE.ComponentRef a_arrayCrefLocal;
      HpcOmSimCode.MemoryMap i_hpcOmMemory;
      list<DAE.ComponentRef> ret_1;
      Tpl.Text l_varDeclarations;

    case ( txt,
           SOME(i_hpcOmMemory),
           _,
           _,
           _,
           _,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_varType,
           a_num,
           a_arrayCrefLocal )
      equation
        ret_1 = HpcOmMemory.expandCref(a_arrayCrefLocal, a_num);
        l_varDeclarations = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_varDeclarations = lm_265(l_varDeclarations, ret_1, a_createConstructorDeclaration, a_useFlatArrayNotation, a_varType, i_hpcOmMemory);
        l_varDeclarations = Tpl.popIter(l_varDeclarations);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("// case 2 MemberVariableDefine2\n"));
        txt = Tpl.writeText(txt, l_varDeclarations);
      then txt;

    case ( txt,
           _,
           a_arrayName,
           a_arraysize,
           a_typeString,
           a_dims,
           a_createConstructorDeclaration,
           _,
           _,
           _,
           _ )
      equation
        txt = fun_266(txt, a_createConstructorDeclaration, a_arrayName, a_arraysize, a_typeString, a_dims);
      then txt;
  end match;
end fun_267;

protected function lm_268
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input DAE.Type in_a_varType;
  input HpcOmSimCode.MemoryMap in_a_hpcOmMemory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_varType, in_a_hpcOmMemory)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      DAE.Type a_varType;
      HpcOmSimCode.MemoryMap a_hpcOmMemory;
      DAE.ComponentRef i_crefLocal;
      Option<tuple<Integer, Integer>> ret_0;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_crefLocal :: rest,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_varType,
           a_hpcOmMemory )
      equation
        ret_0 = HpcOmMemory.getPositionMappingByArrayName(a_hpcOmMemory, i_crefLocal);
        txt = MemberVariableDefine4(txt, ret_0, i_crefLocal, a_varType, a_useFlatArrayNotation, a_createConstructorDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_268(txt, rest, a_createConstructorDeclaration, a_useFlatArrayNotation, a_varType, a_hpcOmMemory);
      then txt;
  end match;
end lm_268;

protected function lm_269
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = lm_269(txt, rest);
      then txt;
  end match;
end lm_269;

protected function fun_270
  input Tpl.Text in_txt;
  input Boolean in_a_createConstructorDeclaration;
  input Tpl.Text in_a_arrayName;
  input Tpl.Text in_a_arraysize;
  input Tpl.Text in_a_typeString;
  input Tpl.Text in_a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_createConstructorDeclaration, in_a_arrayName, in_a_arraysize, in_a_typeString, in_a_dims)
    local
      Tpl.Text txt;
      Tpl.Text a_arrayName;
      Tpl.Text a_arraysize;
      Tpl.Text a_typeString;
      Tpl.Text a_dims;

    case ( txt,
           false,
           a_arrayName,
           a_arraysize,
           a_typeString,
           a_dims )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StatArrayDim"));
        txt = Tpl.writeText(txt, a_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<"));
        txt = Tpl.writeText(txt, a_typeString);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_arraysize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = Tpl.writeText(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //no cacheMap defined"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_270;

protected function fun_271
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemoryOpt;
  input Tpl.Text in_a_arrayName;
  input Tpl.Text in_a_arraysize;
  input Tpl.Text in_a_typeString;
  input Tpl.Text in_a_dims;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input DAE.Type in_a_varType;
  input list<String> in_a_num;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmMemoryOpt, in_a_arrayName, in_a_arraysize, in_a_typeString, in_a_dims, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_varType, in_a_num, in_a_name)
    local
      Tpl.Text txt;
      Tpl.Text a_arrayName;
      Tpl.Text a_arraysize;
      Tpl.Text a_typeString;
      Tpl.Text a_dims;
      Boolean a_createConstructorDeclaration;
      Boolean a_useFlatArrayNotation;
      DAE.Type a_varType;
      list<String> a_num;
      DAE.ComponentRef a_name;
      HpcOmSimCode.MemoryMap i_hpcOmMemory;
      list<DAE.ComponentRef> ret_1;
      Tpl.Text l_varDeclarations;

    case ( txt,
           SOME(i_hpcOmMemory),
           _,
           _,
           _,
           a_dims,
           a_createConstructorDeclaration,
           a_useFlatArrayNotation,
           a_varType,
           a_num,
           a_name )
      equation
        ret_1 = HpcOmMemory.expandCref(a_name, a_num);
        l_varDeclarations = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_varDeclarations = lm_268(l_varDeclarations, ret_1, a_createConstructorDeclaration, a_useFlatArrayNotation, a_varType, i_hpcOmMemory);
        l_varDeclarations = Tpl.popIter(l_varDeclarations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// case 3 MemberVariableDefine2 dims:"));
        txt = Tpl.writeText(txt, a_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" nums:"));
        txt = lm_269(txt, a_num);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varDeclarations);
      then txt;

    case ( txt,
           _,
           a_arrayName,
           a_arraysize,
           a_typeString,
           a_dims,
           a_createConstructorDeclaration,
           _,
           _,
           _,
           _ )
      equation
        txt = fun_270(txt, a_createConstructorDeclaration, a_arrayName, a_arraysize, a_typeString, a_dims);
      then txt;
  end match;
end fun_271;

protected function fun_272
  input Tpl.Text in_txt;
  input Boolean in_a_createConstructorDeclaration;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_createConstructorDeclaration, in_a_varName, in_a_varType)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      Tpl.Text a_varType;

    case ( txt,
           false,
           a_varName,
           a_varType )
      equation
        txt = Tpl.writeText(txt, a_varType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_272;

protected function fun_273
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varType;
  input Boolean in_a_createConstructorDeclaration;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName, in_a_varType, in_a_createConstructorDeclaration)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      Tpl.Text a_varType;
      Boolean a_createConstructorDeclaration;

    case ( txt,
           "0",
           a_varName,
           a_varType,
           a_createConstructorDeclaration )
      equation
        txt = fun_272(txt, a_createConstructorDeclaration, a_varName, a_varType);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_273;

protected function fun_274
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input Option<HpcOmSimCode.MemoryMap> in_a_hpcOmMemoryOpt;
  input Boolean in_a_useFlatArrayNotation;
  input Boolean in_a_createConstructorDeclaration;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_hpcOmMemoryOpt, in_a_useFlatArrayNotation, in_a_createConstructorDeclaration)
    local
      Tpl.Text txt;
      Option<HpcOmSimCode.MemoryMap> a_hpcOmMemoryOpt;
      Boolean a_useFlatArrayNotation;
      Boolean a_createConstructorDeclaration;
      DAE.Type i_varType;
      list<String> i_num;
      DAE.ComponentRef i_arrayCrefLocal;
      list<String> i_v_numArrayElement;
      DAE.Type i_type__;
      DAE.ComponentRef i_name;
      DAE.ComponentRef i_simVar_name;
      DAE.Type i_simVar_type__;
      SimCodeVar.SimVar i_simVar;
      DAE.ComponentRef i_varName;
      String str_6;
      Tpl.Text l_varType;
      Tpl.Text l_varName;
      Tpl.Text l_arraysize;
      Tpl.Text l_typeString;
      Tpl.Text l_arrayName;
      Tpl.Text l_dims;

    case ( txt,
           SimCodeVar.SIMVAR(numArrayElement = {}, arrayCref = NONE(), name = DAE.CREF_IDENT(subscriptLst = _ :: _)),
           _,
           _,
           _ )
      then txt;

    case ( txt,
           (i_simVar as SimCodeVar.SIMVAR(name = (i_simVar_name as i_varName), numArrayElement = {}, arrayCref = NONE(), type_ = i_simVar_type__)),
           a_hpcOmMemoryOpt,
           a_useFlatArrayNotation,
           a_createConstructorDeclaration )
      equation
        txt = fun_264(txt, a_hpcOmMemoryOpt, i_simVar_name, i_simVar_type__, a_createConstructorDeclaration, a_useFlatArrayNotation, i_simVar, i_varName);
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = (i_name as DAE.CREF_IDENT(ident = _)), arrayCref = SOME(i_arrayCrefLocal), numArrayElement = (i_v_numArrayElement as i_num), type_ = (i_type__ as i_varType)),
           a_hpcOmMemoryOpt,
           a_useFlatArrayNotation,
           a_createConstructorDeclaration )
      equation
        l_dims = Tpl.emptyTxt;
        (l_arrayName, l_dims) = CodegenCpp.arraycref2(Tpl.emptyTxt, i_name, l_dims);
        l_typeString = CodegenCpp.variableType(Tpl.emptyTxt, i_type__);
        l_arraysize = CodegenCpp.arrayextentDims(Tpl.emptyTxt, i_name, i_v_numArrayElement);
        txt = fun_267(txt, a_hpcOmMemoryOpt, l_arrayName, l_arraysize, l_typeString, l_dims, a_createConstructorDeclaration, a_useFlatArrayNotation, i_varType, i_num, i_arrayCrefLocal);
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = (i_name as DAE.CREF_QUAL(ident = _)), arrayCref = SOME(_), numArrayElement = (i_v_numArrayElement as i_num), type_ = (i_type__ as i_varType)),
           a_hpcOmMemoryOpt,
           a_useFlatArrayNotation,
           a_createConstructorDeclaration )
      equation
        l_dims = Tpl.emptyTxt;
        (l_arrayName, l_dims) = CodegenCpp.arraycref2(Tpl.emptyTxt, i_name, l_dims);
        l_typeString = CodegenCpp.variableType(Tpl.emptyTxt, i_type__);
        l_arraysize = CodegenCpp.arrayextentDims(Tpl.emptyTxt, i_name, i_v_numArrayElement);
        txt = fun_271(txt, a_hpcOmMemoryOpt, l_arrayName, l_arraysize, l_typeString, l_dims, a_createConstructorDeclaration, a_useFlatArrayNotation, i_varType, i_num, i_name);
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(numArrayElement = _ :: _, name = i_name, type_ = i_type__),
           _,
           _,
           a_createConstructorDeclaration )
      equation
        l_dims = Tpl.emptyTxt;
        (l_varName, l_dims) = CodegenCpp.arraycref2(Tpl.emptyTxt, i_name, l_dims);
        l_varType = CodegenCpp.variableType(Tpl.emptyTxt, i_type__);
        str_6 = Tpl.textString(l_dims);
        txt = fun_273(txt, str_6, l_varName, l_varType, a_createConstructorDeclaration);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_274;

public function MemberVariableDefine2
  input Tpl.Text txt;
  input SimCodeVar.SimVar a_simVar;
  input String a_arrayName;
  input Option<HpcOmSimCode.MemoryMap> a_hpcOmMemoryOpt;
  input Boolean a_useFlatArrayNotation;
  input Boolean a_createConstructorDeclaration;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_274(txt, a_simVar, a_hpcOmMemoryOpt, a_useFlatArrayNotation, a_createConstructorDeclaration);
end MemberVariableDefine2;

protected function fun_276
  input Tpl.Text in_txt;
  input Boolean in_a_createConstructorDeclaration;
  input Integer in_a_varIdx;
  input Integer in_a_arrayIdx;
  input Boolean in_a_useFlatArrayNotation;
  input DAE.ComponentRef in_a_name;
  input DAE.Type in_a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_createConstructorDeclaration, in_a_varIdx, in_a_arrayIdx, in_a_useFlatArrayNotation, in_a_name, in_a_type__)
    local
      Tpl.Text txt;
      Integer a_varIdx;
      Integer a_arrayIdx;
      Boolean a_useFlatArrayNotation;
      DAE.ComponentRef a_name;
      DAE.Type a_type__;

    case ( txt,
           false,
           a_varIdx,
           a_arrayIdx,
           a_useFlatArrayNotation,
           a_name,
           a_type__ )
      equation
        txt = CodegenCpp.variableType(txt, a_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("& "));
        txt = CodegenCpp.cref(txt, a_name, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";// = varArray"));
        txt = Tpl.writeStr(txt, intString(a_arrayIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_varIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] - MemberVariableDefine3"));
      then txt;

    case ( txt,
           _,
           a_varIdx,
           a_arrayIdx,
           a_useFlatArrayNotation,
           a_name,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = CodegenCpp.cref(txt, a_name, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(varArray"));
        txt = Tpl.writeStr(txt, intString(a_arrayIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_varIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
      then txt;
  end match;
end fun_276;

protected function fun_277
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input Integer in_a_varIdx;
  input Integer in_a_arrayIdx;
  input Boolean in_a_useFlatArrayNotation;
  input Boolean in_a_createConstructorDeclaration;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_varIdx, in_a_arrayIdx, in_a_useFlatArrayNotation, in_a_createConstructorDeclaration)
    local
      Tpl.Text txt;
      Integer a_varIdx;
      Integer a_arrayIdx;
      Boolean a_useFlatArrayNotation;
      Boolean a_createConstructorDeclaration;
      DAE.ComponentRef i_name;
      DAE.Type i_type__;

    case ( txt,
           SimCodeVar.SIMVAR(type_ = i_type__, name = i_name),
           a_varIdx,
           a_arrayIdx,
           a_useFlatArrayNotation,
           a_createConstructorDeclaration )
      equation
        txt = fun_276(txt, a_createConstructorDeclaration, a_varIdx, a_arrayIdx, a_useFlatArrayNotation, i_name, i_type__);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_277;

protected function fun_278
  input Tpl.Text in_txt;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input DAE.ComponentRef in_a_name;
  input DAE.Type in_a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_name, in_a_type__)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      DAE.ComponentRef a_name;
      DAE.Type a_type__;

    case ( txt,
           false,
           a_useFlatArrayNotation,
           a_name,
           a_type__ )
      equation
        txt = CodegenCpp.variableType(txt, a_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = CodegenCpp.cref(txt, a_name, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //not optimized"));
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_name,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* no varIdx found for variable "));
        txt = CodegenCpp.cref(txt, a_name, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;
  end match;
end fun_278;

protected function fun_279
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input Boolean in_a_useFlatArrayNotation;
  input Boolean in_a_createConstructorDeclaration;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_useFlatArrayNotation, in_a_createConstructorDeclaration)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      Boolean a_createConstructorDeclaration;
      DAE.ComponentRef i_name;
      DAE.Type i_type__;

    case ( txt,
           SimCodeVar.SIMVAR(type_ = i_type__, name = i_name),
           a_useFlatArrayNotation,
           a_createConstructorDeclaration )
      equation
        txt = fun_278(txt, a_createConstructorDeclaration, a_useFlatArrayNotation, i_name, i_type__);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_279;

public function MemberVariableDefine3
  input Tpl.Text in_txt;
  input Option<tuple<Integer, Integer>> in_a_optVarArrayAssignment;
  input SimCodeVar.SimVar in_a_simVar;
  input Boolean in_a_useFlatArrayNotation;
  input Boolean in_a_createConstructorDeclaration;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_optVarArrayAssignment, in_a_simVar, in_a_useFlatArrayNotation, in_a_createConstructorDeclaration)
    local
      Tpl.Text txt;
      SimCodeVar.SimVar a_simVar;
      Boolean a_useFlatArrayNotation;
      Boolean a_createConstructorDeclaration;
      Integer i_varIdx;
      Integer i_arrayIdx;

    case ( txt,
           SOME((i_varIdx, i_arrayIdx)),
           a_simVar,
           a_useFlatArrayNotation,
           a_createConstructorDeclaration )
      equation
        txt = fun_277(txt, a_simVar, i_varIdx, i_arrayIdx, a_useFlatArrayNotation, a_createConstructorDeclaration);
      then txt;

    case ( txt,
           _,
           a_simVar,
           a_useFlatArrayNotation,
           a_createConstructorDeclaration )
      equation
        txt = fun_279(txt, a_simVar, a_useFlatArrayNotation, a_createConstructorDeclaration);
      then txt;
  end match;
end MemberVariableDefine3;

protected function fun_281
  input Tpl.Text in_txt;
  input Boolean in_a_createConstructorDeclaration;
  input Integer in_a_varIdx;
  input Integer in_a_arrayIdx;
  input Boolean in_a_useFlatArrayNotation;
  input DAE.ComponentRef in_a_varName;
  input DAE.Type in_a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_createConstructorDeclaration, in_a_varIdx, in_a_arrayIdx, in_a_useFlatArrayNotation, in_a_varName, in_a_type__)
    local
      Tpl.Text txt;
      Integer a_varIdx;
      Integer a_arrayIdx;
      Boolean a_useFlatArrayNotation;
      DAE.ComponentRef a_varName;
      DAE.Type a_type__;

    case ( txt,
           false,
           a_varIdx,
           a_arrayIdx,
           a_useFlatArrayNotation,
           a_varName,
           a_type__ )
      equation
        txt = CodegenCpp.variableType(txt, a_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("& "));
        txt = CodegenCpp.cref(txt, a_varName, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";// = varArray"));
        txt = Tpl.writeStr(txt, intString(a_arrayIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_varIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] - MemberVariableDefine4"));
      then txt;

    case ( txt,
           _,
           a_varIdx,
           a_arrayIdx,
           a_useFlatArrayNotation,
           a_varName,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = CodegenCpp.cref(txt, a_varName, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(varArray"));
        txt = Tpl.writeStr(txt, intString(a_arrayIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_varIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
      then txt;
  end match;
end fun_281;

protected function fun_282
  input Tpl.Text in_txt;
  input Boolean in_a_createConstructorDeclaration;
  input Boolean in_a_useFlatArrayNotation;
  input DAE.ComponentRef in_a_varName;
  input DAE.Type in_a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_createConstructorDeclaration, in_a_useFlatArrayNotation, in_a_varName, in_a_type__)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      DAE.ComponentRef a_varName;
      DAE.Type a_type__;

    case ( txt,
           false,
           a_useFlatArrayNotation,
           a_varName,
           a_type__ )
      equation
        txt = CodegenCpp.variableType(txt, a_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = CodegenCpp.cref(txt, a_varName, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_varName,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* no varIdx found for variable "));
        txt = CodegenCpp.cref(txt, a_varName, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;
  end match;
end fun_282;

public function MemberVariableDefine4
  input Tpl.Text in_txt;
  input Option<tuple<Integer, Integer>> in_a_optVarArrayAssignment;
  input DAE.ComponentRef in_a_varName;
  input DAE.Type in_a_type__;
  input Boolean in_a_useFlatArrayNotation;
  input Boolean in_a_createConstructorDeclaration;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_optVarArrayAssignment, in_a_varName, in_a_type__, in_a_useFlatArrayNotation, in_a_createConstructorDeclaration)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_varName;
      DAE.Type a_type__;
      Boolean a_useFlatArrayNotation;
      Boolean a_createConstructorDeclaration;
      Integer i_varIdx;
      Integer i_arrayIdx;

    case ( txt,
           SOME((i_varIdx, i_arrayIdx)),
           a_varName,
           a_type__,
           a_useFlatArrayNotation,
           a_createConstructorDeclaration )
      equation
        txt = fun_281(txt, a_createConstructorDeclaration, i_varIdx, i_arrayIdx, a_useFlatArrayNotation, a_varName, a_type__);
      then txt;

    case ( txt,
           _,
           a_varName,
           a_type__,
           a_useFlatArrayNotation,
           a_createConstructorDeclaration )
      equation
        txt = fun_282(txt, a_createConstructorDeclaration, a_useFlatArrayNotation, a_varName, a_type__);
      then txt;
  end match;
end MemberVariableDefine4;

annotation(__OpenModelica_Interface="backend");
end CodegenCppHpcom;