encapsulated package CodegenJS
"
  file:        CodegenJS.mo
  package:     CodegenJS
  description: Generated by Susan.
"

public import Tpl;

public import SimCodeVar;
public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import SCodeDump;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCodeMain;
public import HpcOmSimCode;
public import HpcOmMemory;
public import HpcOmScheduler;
public import CodegenUtil;

public function markdownFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(fileNamePrefix = i_fileNamePrefix)) )
      equation
        txt_0 = markdownContents(Tpl.emptyTxt, i_simCode);
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".md"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
        txt_2 = nodeJSDriver(Tpl.emptyTxt, i_simCode);
        txt_3 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("_node.js"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end markdownFile;

public function nodeJSDriver
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_s_outputFormat;
      String i_fileNamePrefix;

    case ( txt,
           SimCode.SIMCODE(simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(outputFormat = i_s_outputFormat)), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#!/usr/bin/nodejs --max-old-space-size=8192\n",
                                    "var fs = require(\'fs\');\n",
                                    "\n",
                                    "var initXML = fs.readFileSync(\'./"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_init.xml\');\n",
                                    "\n",
                                    "var mod = require(\'./"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".js\');\n",
                                    "mod.FS_createDataFile(\"/\", \'"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_init.xml\', initXML, true, false);\n",
                                    "mod.FS_createLazyFile(\"/\", \'"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_info.xml\', \'"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_info.xml\', true, false);\n",
                                    "mod.callMain(process.argv.slice(2));\n",
                                    "\n",
                                    "var fname = \'"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_res."));
        txt = Tpl.writeStr(txt, i_s_outputFormat);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\';\n",
                                    "var content = mod.OpenModelica_readFile(fname);\n",
                                    "fs.writeFileSync(fname,content);"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end nodeJSDriver;

public function markdownContents
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      Real i_s_tolerance;
      Integer i_s_numberOfIntervals;
      Real i_s_stopTime;
      Absyn.Path i_modelInfo_name;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = _, varInfo = SimCode.VARINFO(numZeroCrossings = _), vars = SimCodeVar.SIMVARS(stateVars = _), name = i_modelInfo_name), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(stopTime = i_s_stopTime, numberOfIntervals = i_s_numberOfIntervals, tolerance = i_s_tolerance)), makefileParams = SimCode.MAKEFILE_PARAMS(ccompiler = _), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# OpenModelica simulation example\n",
                                    "## "
                                }, false));
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_modelInfo_name);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "```yaml script=scriptloader\n",
                                    "- lib/tinytimer.js\n",
                                    "```\n",
                                    "\n",
                                    "<style media=\"screen\" type=\"text/css\">\n",
                                    "label {font-weight:normal; size: 0.9em}\n",
                                    "</style>\n",
                                    "\n",
                                    "<br/>\n",
                                    "<br/>\n",
                                    "\n",
                                    "<div id=\"status\" style=\"text-align:center\"><span id=\"statustext\">\n",
                                    "Simulation loading</span>. &nbsp Time: <span id=\"statustimer\"> </span></div>\n",
                                    "\n",
                                    "<br/>\n",
                                    "\n",
                                    "<div class = \"row\">\n",
                                    "<div class = \"col-md-4\">\n",
                                    "\n",
                                    "<br/>\n",
                                    "<br/>\n",
                                    "<br/>\n",
                                    "<br/>\n",
                                    "\n",
                                    "```yaml jquery=dform\n",
                                    "class : form-horizontal\n",
                                    "col1class : col-sm-7\n",
                                    "col2class : col-sm-5\n",
                                    "html:\n",
                                    "  - name: stopTime\n",
                                    "    type: number\n",
                                    "    bs3caption: Stop time, sec\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("value: "));
        txt = Tpl.writeStr(txt, realString(i_s_stopTime));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  - name: intervals\n",
                                    "    type: number\n",
                                    "    bs3caption: Output intervals\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("value: "));
        txt = Tpl.writeStr(txt, intString(i_s_numberOfIntervals));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  - name: tolerance\n",
                                    "    type: number\n",
                                    "    bs3caption: Tolerance\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("value: "));
        txt = Tpl.writeStr(txt, realString(i_s_tolerance));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "```\n",
                                    "\n",
                                    "```js\n",
                                    "if (typeof(isRunning) == \"undefined\") isRunning = false\n",
                                    "\n",
                                    "if (typeof(timer) != \"undefined\") {clearInterval(timer.interval); timer = null};\n",
                                    "\n",
                                    "$(\"#statustext\").html(\'Simulation running\')\n",
                                    "$(\"#statustimer\").html(\"\");\n",
                                    "$(\'#statustimer\').tinyTimer({ from: Date.now() });\n",
                                    "\n",
                                    "timer = $(\"#statustimer\").data(\"tinyTimer\")\n",
                                    "\n",
                                    "// Start the simulation!\n",
                                    "basename = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "\n",
                                    "if (typeof(wworker) != \"undefined\" && isRunning) wworker.terminate();\n",
                                    "if (typeof(wworker) == \"undefined\" || isRunning) {\n",
                                    "  wworker = new Worker(basename + \".js\");\n",
                                    "  isRunning = true\n",
                                    "  wworker.addEventListener(\'error\', function(event) {\n",
                                    "  });\n",
                                    "  // read the csv file with the simulation results\n",
                                    "  wworker.addEventListener(\"message\", function(e) {\n",
                                    "    var data = e.data;\n",
                                    "    if (data.preloaded) {\n",
                                    "      preloadComplete = true;\n",
                                    "      wworker.postMessage({basename: basename, override: {stopTime: stopTime, tolerance: tolerance, stepSize: +stopTime / intervals}});\n",
                                    "      return;\n",
                                    "    }\n",
                                    "    $(\"#statustext\").html(e.data.status)\n",
                                    "    timer.stop();\n",
                                    "    isRunning = false\n",
                                    "    x = $.csv.toArrays(e.data.csv, {onParseValue: $.csv.hooks.castToScalar})\n",
                                    "\n",
                                    "    // `header` has the column names. The first is the time, and the rest\n",
                                    "    // of the columns are the variables.\n",
                                    "    header = x.slice(0,1)[0]\n",
                                    "\n",
                                    "    // Select graph variables with a select box based on the header values\n",
                                    "    if (typeof(graphvar) == \"undefined\") graphvar = header[1];\n",
                                    "    if (typeof(graphvarX) == \"undefined\") graphvarX = header[0];\n",
                                    "\n",
                                    "    var jsonform = {\n",
                                    "      html: {\n",
                                    "        type: \"select\",\n",
                                    "        bs3caption: \"Plot variable\",\n",
                                    "        name: \"graphvar\",\n",
                                    "        selectvalue: graphvar,\n",
                                    "        choices: header\n",
                                    "    }};\n",
                                    "    var jsonformX = {\n",
                                    "      html: {\n",
                                    "        type: \"select\",\n",
                                    "        bs3caption: \"\",\n",
                                    "        name: \"graphvarX\",\n",
                                    "        selectvalue: graphvarX,\n",
                                    "        choices: header\n",
                                    "    }};\n",
                                    "    updatefun = function (evt) {\n",
                                    "        calculate_forms();\n",
                                    "        $(\"#plotdiv\").calculate();\n",
                                    "    }\n",
                                    "\n",
                                    "\n",
                                    "    $(\"#yaxisform\").html(\"\");\n",
                                    "    $(\"#yaxisform\").dform(jsonform);\n",
                                    "    $(\"#yaxisform\").change(updatefun);\n",
                                    "    $(\"#xaxisform\").html(\"\");\n",
                                    "    $(\"#xaxisform\").dform(jsonformX);\n",
                                    "    $(\"#xaxisform\").change(updatefun);\n",
                                    "    $(\"#plotdiv\").calculate();\n",
                                    "\n",
                                    "}, false);\n",
                                    "}\n",
                                    "wworker.postMessage({basename: basename, preload: true})\n",
                                    "```\n",
                                    "\n",
                                    "</div>\n",
                                    "\n",
                                    "<div class = \"col-md-1\">\n",
                                    "</div>\n",
                                    "\n",
                                    "\n",
                                    "<div class = \"col-md-7\">\n",
                                    "\n",
                                    "<!-- Nav tabs -->\n",
                                    "<ul class=\"nav nav-tabs\" id=\"mytab\">\n",
                                    "  <li class=\"active\"><a href=\"#model\" data-toggle=\"tab\">Model</a></li>\n",
                                    "  <li><a href=\"#results\" data-toggle=\"tab\">Results</a></li>\n",
                                    "</ul>\n",
                                    "\n",
                                    "<!-- Tab panes -->\n",
                                    "<div class=\"tab-content\">\n",
                                    "  <!-- Model pane -->\n",
                                    "  <div class=\"tab-pane active\" id=\"model\">\n",
                                    "\n",
                                    "<img src=\""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".svg\" style=\"width:100%; background-color:#ffffff; border:2px solid gray\" />\n",
                                    "\n",
                                    "  </div>\n",
                                    "\n",
                                    "  <!-- Results pane -->\n",
                                    "  <div class=\"tab-pane\" id=\"results\">\n",
                                    "\n",
                                    "</br>\n",
                                    "\n",
                                    "<div id=\"yaxisform\" style=\"width:15em; position:relative\"> </div>\n",
                                    "\n",
                                    "```js id=plotdiv\n",
                                    "if (typeof(header) != \"undefined\") {\n",
                                    "    $(\"#mytab a:last\").tab(\"show\"); // Select last tab\n",
                                    "    yidx = header.indexOf(graphvar);\n",
                                    "    xidx = header.indexOf(graphvarX);\n",
                                    "    // pick out the column to plot\n",
                                    "    series = x.slice(1).map(function(x) {return [x[xidx], x[yidx]];});\n",
                                    "    plot([series]);\n",
                                    "}\n",
                                    "```\n",
                                    "\n",
                                    "<div id=\"xaxisform\" class=\"center-block\" style=\"text-align:center; width:15em; position:relative\"> </div>\n",
                                    "\n",
                                    "\n",
                                    "  </div>\n",
                                    "</div>\n",
                                    "\n",
                                    "</div>\n",
                                    "</div>\n",
                                    "\n",
                                    "\n",
                                    "## Comments\n",
                                    "\n",
                                    "This simulation model is from a [Modelica](http://modelica.org) model.\n",
                                    "Modelica is a language for simulating electrical, thermal, and\n",
                                    "mechanical, systems. [OpenModelica](http://openmodelica.org) was used\n",
                                    "to compile this model to C. Then, [Emscripten](http://emscripten.org/)\n",
                                    "was used to compile the C code to JavaScript.\n",
                                    "\n",
                                    "For more information on compiling OpenModelica to JavaScript, see\n",
                                    "[here](https://github.com/tshort/openmodelica-javascript).\n",
                                    "\n",
                                    "The user interface was created in\n",
                                    "[mdpad](http://tshort.github.io/mdpad/). See\n",
                                    "["
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".md]("));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".md) for the Markdown code\n",
                                    "for this page."
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end markdownContents;

annotation(__OpenModelica_Interface="backend");
end CodegenJS;