encapsulated package CodegenModelica
"
  file:        CodegenModelica.mo
  package:     CodegenModelica
  description: Generated by Susan.
"

public import Tpl;

public import ExpressionDump;
public import BackendDAE;
public import BackendVariable;
public import BackendEquation;
public import BackendDump;
public import DAE;
public import CodegenUtil;

protected function fun_9
  input Tpl.Text in_txt;
  input DAE.Type in_a_var_varType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var_varType)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Integer"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("String"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Boolean"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("enumeration"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("?unknown?"));
      then txt;
  end match;
end fun_9;

protected function fun_10
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_start;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_start)
    local
      Tpl.Text txt;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           SOME(i_e) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start="));
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_10;

protected function fun_11
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_fixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fixed)
    local
      Tpl.Text txt;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           SOME(i_e) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fixed="));
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_11;

protected function fun_12
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_nominal;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nominal)
    local
      Tpl.Text txt;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           SOME(i_e) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nominal="));
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_12;

protected function fun_13
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_min;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_min)
    local
      Tpl.Text txt;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           SOME(i_e) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("min="));
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_13;

protected function fun_14
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_max;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_max)
    local
      Tpl.Text txt;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           SOME(i_e) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("max="));
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_14;

protected function fun_15
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_start;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_start)
    local
      Tpl.Text txt;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           SOME(i_e) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start="));
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_15;

protected function fun_16
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_fixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fixed)
    local
      Tpl.Text txt;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           SOME(i_e) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fixed="));
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_16;

protected function fun_17
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_start;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_start)
    local
      Tpl.Text txt;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           SOME(i_e) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start="));
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_17;

protected function fun_18
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_fixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fixed)
    local
      Tpl.Text txt;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           SOME(i_e) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fixed="));
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_18;

protected function fun_19
  input Tpl.Text in_txt;
  input DAE.VariableAttributes in_a_v;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_v)
    local
      Tpl.Text txt;
      Option<DAE.Exp> i_max;
      Option<DAE.Exp> i_min;
      Option<DAE.Exp> i_nominal;
      Option<DAE.Exp> i_fixed;
      Option<DAE.Exp> i_start;
      Tpl.Text l_maxStr;
      Tpl.Text l_minStr;
      Tpl.Text l_nominalStr;
      Tpl.Text l_fixedStr;
      Tpl.Text l_startStr;

    case ( txt,
           DAE.VAR_ATTR_REAL(start = i_start, fixed = i_fixed, nominal = i_nominal, min = i_min, max = i_max) )
      equation
        l_startStr = fun_10(Tpl.emptyTxt, i_start);
        l_fixedStr = fun_11(Tpl.emptyTxt, i_fixed);
        l_nominalStr = fun_12(Tpl.emptyTxt, i_nominal);
        l_minStr = fun_13(Tpl.emptyTxt, i_min);
        l_maxStr = fun_14(Tpl.emptyTxt, i_max);
        txt = Tpl.writeText(txt, l_startStr);
        txt = Tpl.writeText(txt, l_fixedStr);
        txt = Tpl.writeText(txt, l_nominalStr);
        txt = Tpl.writeText(txt, l_minStr);
        txt = Tpl.writeText(txt, l_maxStr);
      then txt;

    case ( txt,
           DAE.VAR_ATTR_INT(start = i_start, fixed = i_fixed) )
      equation
        l_startStr = fun_15(Tpl.emptyTxt, i_start);
        l_fixedStr = fun_16(Tpl.emptyTxt, i_fixed);
        txt = Tpl.writeText(txt, l_startStr);
        txt = Tpl.writeText(txt, l_fixedStr);
      then txt;

    case ( txt,
           DAE.VAR_ATTR_BOOL(start = i_start, fixed = i_fixed) )
      equation
        l_startStr = fun_17(Tpl.emptyTxt, i_start);
        l_fixedStr = fun_18(Tpl.emptyTxt, i_fixed);
        txt = Tpl.writeText(txt, l_startStr);
        txt = Tpl.writeText(txt, l_fixedStr);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("?unknown?"));
      then txt;
  end match;
end fun_19;

protected function fun_20
  input Tpl.Text in_txt;
  input Option<DAE.VariableAttributes> in_a_var_values;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var_values)
    local
      Tpl.Text txt;
      DAE.VariableAttributes i_v;

    case ( txt,
           SOME(i_v) )
      equation
        txt = fun_19(txt, i_v);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_20;

protected function lm_21
  input Tpl.Text in_txt;
  input list<BackendDAE.Var> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.Var> rest;
      DAE.ComponentRef i_var_varName;
      Option<DAE.VariableAttributes> i_var_values;
      DAE.Type i_var_varType;
      Tpl.Text l_attrStr;
      Tpl.Text l_typeStr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           BackendDAE.VAR(varType = i_var_varType, values = i_var_values, varName = i_var_varName) :: rest )
      equation
        l_typeStr = fun_9(Tpl.emptyTxt, i_var_varType);
        l_attrStr = fun_20(Tpl.emptyTxt, i_var_values);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = CodegenUtil.crefStr(txt, i_var_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_attrStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_21(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_21(txt, rest);
      then txt;
  end match;
end lm_21;

protected function lm_22
  input Tpl.Text in_txt;
  input BackendDAE.EqSystems in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      BackendDAE.EqSystems rest;
      Integer x_clusterID;
      BackendDAE.Variables i_eqSystem_orderedVars;
      list<BackendDAE.Var> ret_1;
      Tpl.Text l_varDeclaration;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           BackendDAE.EQSYSTEM(orderedVars = i_eqSystem_orderedVars) :: rest )
      equation
        x_clusterID = Tpl.getIteri_i0(txt);
        ret_1 = BackendVariable.varList(i_eqSystem_orderedVars);
        l_varDeclaration = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_varDeclaration = lm_21(l_varDeclaration, ret_1);
        l_varDeclaration = Tpl.popIter(l_varDeclaration);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* system #"));
        txt = Tpl.writeStr(txt, intString(x_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" */\n"));
        txt = Tpl.writeText(txt, l_varDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_22(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_22(txt, rest);
      then txt;
  end match;
end lm_22;

protected function lm_23
  input Tpl.Text in_txt;
  input list<BackendDAE.Equation> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.Equation> rest;
      BackendDAE.Equation i_eq;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        ret_0 = BackendDump.equationString(i_eq);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_23(txt, rest);
      then txt;
  end match;
end lm_23;

protected function lm_24
  input Tpl.Text in_txt;
  input BackendDAE.EqSystems in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      BackendDAE.EqSystems rest;
      Integer x_clusterID;
      BackendDAE.EquationArray i_eqSystem_orderedEqs;
      list<BackendDAE.Equation> ret_1;
      Tpl.Text l_eqnDeclaration;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           BackendDAE.EQSYSTEM(orderedEqs = i_eqSystem_orderedEqs) :: rest )
      equation
        x_clusterID = Tpl.getIteri_i0(txt);
        ret_1 = BackendEquation.equationList(i_eqSystem_orderedEqs);
        l_eqnDeclaration = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_eqnDeclaration = lm_23(l_eqnDeclaration, ret_1);
        l_eqnDeclaration = Tpl.popIter(l_eqnDeclaration);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* system #"));
        txt = Tpl.writeStr(txt, intString(x_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" */\n"));
        txt = Tpl.writeText(txt, l_eqnDeclaration);
        txt = Tpl.nextIter(txt);
        txt = lm_24(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_24(txt, rest);
      then txt;
  end match;
end lm_24;

public function dumpBackendDAE
  input Tpl.Text in_txt;
  input BackendDAE.BackendDAE in_a_backendDAE;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_backendDAE)
    local
      Tpl.Text txt;
      String i_info_fileNamePrefix;
      BackendDAE.EqSystems i_eqs;
      Tpl.Text l_eqn;
      Tpl.Text l_var;

    case ( txt,
           BackendDAE.DAE(eqs = i_eqs, shared = BackendDAE.SHARED(info = BackendDAE.EXTRA_INFO(fileNamePrefix = i_info_fileNamePrefix))) )
      equation
        l_var = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                "\n",
                                                                                "\n"
                                                                            }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_var = lm_22(l_var, i_eqs);
        l_var = Tpl.popIter(l_var);
        l_eqn = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                "\n",
                                                                                "\n"
                                                                            }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_eqn = lm_24(l_eqn, i_eqs);
        l_eqn = Tpl.popIter(l_eqn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* This is probably not complete. */\n",
                                    "model "
                                }, false));
        txt = Tpl.writeStr(txt, i_info_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_var);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("equation\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_eqn);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeStr(txt, i_info_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpBackendDAE;

annotation(__OpenModelica_Interface="backend");
end CodegenModelica;