encapsulated package DAEDumpTpl
"
  file:        DAEDumpTpl.mo
  package:     DAEDumpTpl
  description: Generated by Susan.
"

public import Tpl;

public import ExpressionDumpTpl;
public import ClassInf;
public import Config;
public import Absyn;
public import SCode;
public import DAEDump;
public import DAE;
public import SCodeDump;
public import System;
protected import AbsynDumpTpl;
protected import SCodeDumpTpl;

protected function lm_12
  input Tpl.Text in_txt;
  input list<DAEDump.compWithSplitElements> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAEDump.compWithSplitElements> rest;
      DAEDump.compWithSplitElements i_dae;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dae :: rest )
      equation
        txt = dumpComp(txt, i_dae);
        txt = Tpl.nextIter(txt);
        txt = lm_12(txt, rest);
      then txt;
  end match;
end lm_12;

protected function fun_13
  input Tpl.Text in_txt;
  input DAEDump.functionList in_a_funLists;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_funLists)
    local
      Tpl.Text txt;
      list<DAE.Function> i_funcs;

    case ( txt,
           DAEDump.FUNCTION_LIST(funcs = i_funcs) )
      equation
        txt = dumpFunctions(txt, i_funcs);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_13;

protected function fun_14
  input Tpl.Text in_txt;
  input Tpl.Text in_a_fun__str;
  input Tpl.Text in_a_comp__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fun__str, in_a_comp__str)
    local
      Tpl.Text txt;
      Tpl.Text a_comp__str;
      Tpl.Text i_fun__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_comp__str )
      equation
        txt = Tpl.writeText(txt, a_comp__str);
      then txt;

    case ( txt,
           i_fun__str,
           a_comp__str )
      equation
        txt = Tpl.writeText(txt, i_fun__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_comp__str);
      then txt;
  end match;
end fun_14;

public function dumpDAE
  input Tpl.Text txt;
  input list<DAEDump.compWithSplitElements> a_fixedDaeList;
  input DAEDump.functionList a_funLists;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_fun__str;
  Tpl.Text l_comp__str;
algorithm
  l_comp__str := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_comp__str := lm_12(l_comp__str, a_fixedDaeList);
  l_comp__str := Tpl.popIter(l_comp__str);
  l_fun__str := fun_13(Tpl.emptyTxt, a_funLists);
  out_txt := fun_14(txt, l_fun__str, l_comp__str);
end dumpDAE;

protected function fun_16
  input Tpl.Text in_txt;
  input Tpl.Text in_a_ann__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ann__str)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
      then txt;
  end match;
end fun_16;

public function dumpComp
  input Tpl.Text in_txt;
  input DAEDump.compWithSplitElements in_a_fixedDae;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fixedDae)
    local
      Tpl.Text txt;
      DAEDump.splitElements i_spltElems;
      String i_name;
      Option<SCode.Comment> i_comment;
      Tpl.Text l_ann__str;
      Tpl.Text l_cmt__str;

    case ( txt,
           DAEDump.COMP_WITH_SPLIT(comment = i_comment, name = i_name, spltElems = i_spltElems) )
      equation
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        l_ann__str = dumpClassAnnotation(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = dumpCompStream(txt, i_spltElems);
        txt = Tpl.softNewLine(txt);
        txt = fun_16(txt, l_ann__str);
        txt = Tpl.writeText(txt, l_ann__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpComp;

public function dumpCompStream
  input Tpl.Text in_txt;
  input DAEDump.splitElements in_a_elems;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elems)
    local
      Tpl.Text txt;
      list<DAE.Element> i_a;
      list<DAE.Element> i_e;
      list<DAE.Element> i_ia;
      list<DAE.Element> i_ie;
      list<DAE.Element> i_v;
      Tpl.Text l_al__str;
      Tpl.Text l_eq__str;
      Tpl.Text l_ial__str;
      Tpl.Text l_ieq__str;
      Tpl.Text l_var__str;

    case ( txt,
           DAEDump.SPLIT_ELEMENTS(v = i_v, ie = i_ie, ia = i_ia, e = i_e, a = i_a) )
      equation
        l_var__str = dumpVars(Tpl.emptyTxt, i_v);
        l_ieq__str = dumpInitialEquationSection(Tpl.emptyTxt, i_ie);
        l_ial__str = dumpInitialAlgorithmSection(Tpl.emptyTxt, i_ia);
        l_eq__str = dumpEquationSection(Tpl.emptyTxt, i_e);
        l_al__str = dumpAlgorithmSection(Tpl.emptyTxt, i_a);
        txt = Tpl.writeText(txt, l_var__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_ieq__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_ial__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_eq__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_al__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpCompStream;

protected function lm_19
  input Tpl.Text in_txt;
  input list<DAE.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Function> rest;
      DAE.Function i_func;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_func :: rest )
      equation
        txt = dumpFunction(txt, i_func);
        txt = Tpl.nextIter(txt);
        txt = lm_19(txt, rest);
      then txt;
  end match;
end lm_19;

public function dumpFunctions
  input Tpl.Text txt;
  input list<DAE.Function> a_funcs;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_19(out_txt, a_funcs);
  out_txt := Tpl.popIter(out_txt);
end dumpFunctions;

protected function fun_21
  input Tpl.Text in_txt;
  input Boolean in_a_isImpure;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isImpure)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("impure "));
      then txt;
  end match;
end fun_21;

protected function fun_22
  input Tpl.Text in_txt;
  input Tpl.Text in_a_ann__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ann__str)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
      then txt;
  end match;
end fun_22;

public function dumpFunction
  input Tpl.Text in_txt;
  input DAE.Function in_a_function;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_function)
    local
      Tpl.Text txt;
      DAE.Type i_type__;
      list<DAE.FunctionDefinition> i_functions;
      Absyn.Path i_path;
      Boolean i_isImpure;
      Option<SCode.Comment> i_comment;
      DAE.InlineType i_inlineType;
      Tpl.Text l_impure__str;
      Tpl.Text l_ann__str;
      Tpl.Text l_cmt__str;
      Tpl.Text l_inline__str;

    case ( txt,
           DAE.FUNCTION(inlineType = i_inlineType, comment = i_comment, isImpure = i_isImpure, path = i_path, functions = i_functions) )
      equation
        l_inline__str = dumpInlineType(Tpl.emptyTxt, i_inlineType);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        l_ann__str = dumpClassAnnotation(Tpl.emptyTxt, i_comment);
        l_impure__str = fun_21(Tpl.emptyTxt, i_isImpure);
        txt = Tpl.writeText(txt, l_impure__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function "));
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_path);
        txt = Tpl.writeText(txt, l_inline__str);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = dumpFunctionDefinitions(txt, i_functions);
        txt = Tpl.softNewLine(txt);
        txt = fun_22(txt, l_ann__str);
        txt = Tpl.writeText(txt, l_ann__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.RECORD_CONSTRUCTOR(path = i_path, type_ = i_type__) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function "));
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"Automatically generated record constructor for "));
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpRecordInputVarStr(txt, i_type__);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output "));
        txt = dumpPathLastIndent(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" res;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFunction;

protected function lm_24
  input Tpl.Text in_txt;
  input list<DAE.FunctionDefinition> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.FunctionDefinition> rest;
      DAE.FunctionDefinition i_func;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_func :: rest )
      equation
        txt = dumpFunctionDefinition(txt, i_func);
        txt = Tpl.nextIter(txt);
        txt = lm_24(txt, rest);
      then txt;
  end match;
end lm_24;

public function dumpFunctionDefinitions
  input Tpl.Text txt;
  input list<DAE.FunctionDefinition> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_24(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end dumpFunctionDefinitions;

public function dumpFunctionDefinition
  input Tpl.Text in_txt;
  input DAE.FunctionDefinition in_a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_functions)
    local
      Tpl.Text txt;
      DAE.ExternalDecl i_externalDecl;
      list<DAE.Element> i_body;

    case ( txt,
           DAE.FUNCTION_DEF(body = i_body) )
      equation
        txt = dumpFunctionBody(txt, i_body);
      then txt;

    case ( txt,
           DAE.FUNCTION_EXT(body = i_body, externalDecl = i_externalDecl) )
      equation
        txt = dumpFunctionBody(txt, i_body);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = dumpExternalDecl(txt, i_externalDecl);
      then txt;

    case ( txt,
           DAE.FUNCTION_DER_MAPPER(derivedFunction = _) )
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFunctionDefinition;

protected function fun_27
  input Tpl.Text in_txt;
  input Tpl.Text in_a_func__name__str;
  input Tpl.Text in_a_func__args__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_func__name__str, in_a_func__args__str)
    local
      Tpl.Text txt;
      Tpl.Text a_func__args__str;
      Tpl.Text i_func__name__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           i_func__name__str,
           a_func__args__str )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, i_func__name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_func__args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_27;

protected function fun_28
  input Tpl.Text in_txt;
  input Tpl.Text in_a_ext__output__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ext__output__str)
    local
      Tpl.Text txt;
      Tpl.Text i_ext__output__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_ext__output__str )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, i_ext__output__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ="));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_28;

public function dumpExternalDecl
  input Tpl.Text in_txt;
  input DAE.ExternalDecl in_a_externalDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_externalDecl)
    local
      Tpl.Text txt;
      String i_language;
      DAE.ExtArg i_returnArg;
      list<DAE.ExtArg> i_args;
      String i_name;
      Tpl.Text l_lang__str;
      Tpl.Text l_output__str;
      Tpl.Text l_ext__output__str;
      Tpl.Text l_func__str;
      Tpl.Text l_func__args__str;
      Tpl.Text l_func__name__str;

    case ( txt,
           DAE.EXTERNALDECL(name = i_name, args = i_args, returnArg = i_returnArg, language = i_language) )
      equation
        l_func__name__str = Tpl.writeStr(Tpl.emptyTxt, i_name);
        l_func__args__str = dumpExtArgs(Tpl.emptyTxt, i_args);
        l_func__str = fun_27(Tpl.emptyTxt, l_func__name__str, l_func__args__str);
        l_ext__output__str = dumpExtArg(Tpl.emptyTxt, i_returnArg);
        l_output__str = fun_28(Tpl.emptyTxt, l_ext__output__str);
        l_lang__str = Tpl.writeStr(Tpl.emptyTxt, i_language);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \""));
        txt = Tpl.writeText(txt, l_lang__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeText(txt, l_output__str);
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpExternalDecl;

protected function lm_30
  input Tpl.Text in_txt;
  input list<DAE.ExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ExtArg> rest;
      DAE.ExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = dumpExtArg(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_30(txt, rest);
      then txt;
  end match;
end lm_30;

public function dumpExtArgs
  input Tpl.Text txt;
  input list<DAE.ExtArg> a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_30(out_txt, a_args);
  out_txt := Tpl.popIter(out_txt);
end dumpExtArgs;

public function dumpExtArg
  input Tpl.Text in_txt;
  input DAE.ExtArg in_a_arg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arg)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.ComponentRef i_componentRef;

    case ( txt,
           DAE.EXTARG(componentRef = i_componentRef) )
      equation
        txt = dumpCref(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.EXTARGEXP(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           DAE.EXTARGSIZE(componentRef = i_componentRef, exp = i_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size("));
        txt = dumpCref(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = dumpExp(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpExtArg;

public function dumpRecordInputVarStr
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__)
    local
      Tpl.Text txt;
      DAE.Type i_funcResultType;
      list<DAE.Var> i_varLst;

    case ( txt,
           DAE.T_COMPLEX(varLst = i_varLst) )
      equation
        txt = dumpRecordVars(txt, i_varLst);
      then txt;

    case ( txt,
           DAE.T_FUNCTION(funcResultType = i_funcResultType) )
      equation
        txt = dumpRecordInputVarStr(txt, i_funcResultType);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpRecordInputVarStr;

protected function lm_34
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      DAE.Var i_v;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_v :: rest )
      equation
        txt = dumpRecordVar(txt, i_v);
        txt = Tpl.nextIter(txt);
        txt = lm_34(txt, rest);
      then txt;
  end match;
end lm_34;

public function dumpRecordVars
  input Tpl.Text txt;
  input list<DAE.Var> a_varLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_34(out_txt, a_varLst);
  out_txt := Tpl.popIter(out_txt);
end dumpRecordVars;

public function dumpRecordVar
  input Tpl.Text in_txt;
  input DAE.Var in_a_v;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_v)
    local
      Tpl.Text txt;
      DAE.Ident i_name;
      DAE.Type i_ty;
      DAE.Binding i_binding;
      DAE.Attributes i_attributes;
      Tpl.Text l_ty__str;
      Tpl.Text l_attr;
      Tpl.Text l_binding__str;
      Tpl.Text l_attr__str;

    case ( txt,
           DAE.TYPES_VAR(attributes = i_attributes, binding = i_binding, ty = i_ty, name = i_name) )
      equation
        l_attr__str = dumpRecordConstructorInputAttr(Tpl.emptyTxt, i_attributes);
        l_binding__str = dumpRecordConstructorBinding(Tpl.emptyTxt, i_binding);
        l_attr = Tpl.emptyTxt;
        (l_ty__str, l_attr) = dumpType(Tpl.emptyTxt, i_ty, l_attr);
        txt = Tpl.writeText(txt, l_attr__str);
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeText(txt, l_attr);
        txt = Tpl.writeText(txt, l_binding__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpRecordVar;

public function dumpRecordConstructorInputAttr
  input Tpl.Text in_txt;
  input DAE.Attributes in_a_attr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ATTR(visibility = SCode.PROTECTED()) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("protected "));
      then txt;

    case ( txt,
           DAE.ATTR(variability = SCode.CONST()) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("input "));
      then txt;
  end match;
end dumpRecordConstructorInputAttr;

public function dumpRecordConstructorBinding
  input Tpl.Text in_txt;
  input DAE.Binding in_a_binding;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_binding)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           DAE.UNBOUND() )
      then txt;

    case ( txt,
           DAE.EQBOUND(exp = i_exp) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = dumpExp(txt, i_exp);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpRecordConstructorBinding;

public function dumpRecordVarBinding
  input Tpl.Text in_txt;
  input DAE.Binding in_a_binding;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_binding)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           DAE.UNBOUND() )
      then txt;

    case ( txt,
           DAE.EQBOUND(exp = i_exp) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = dumpExp(txt, i_exp);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           DAE.VALBOUND(valBound = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("value bound***** check what to display"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpRecordVarBinding;

protected function lm_40
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_lst;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lst :: rest )
      equation
        txt = dumpFunctionElement(txt, i_lst);
        txt = Tpl.nextIter(txt);
        txt = lm_40(txt, rest);
      then txt;
  end match;
end lm_40;

public function dumpFunctionBody
  input Tpl.Text txt;
  input list<DAE.Element> a_dAElist;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_40(out_txt, a_dAElist);
  out_txt := Tpl.popIter(out_txt);
end dumpFunctionBody;

public function dumpFunctionElement
  input Tpl.Text in_txt;
  input DAE.Element in_a_lst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lst)
    local
      Tpl.Text txt;
      DAE.Algorithm i_algorithm__;
      DAE.Element i_lst;

    case ( txt,
           (i_lst as DAE.VAR(componentRef = _)) )
      equation
        txt = dumpVar(txt, i_lst, true);
      then txt;

    case ( txt,
           DAE.INITIALALGORITHM(algorithm_ = i_algorithm__) )
      equation
        txt = dumpFunctionAlgorithm(txt, i_algorithm__, "initial algorithm");
      then txt;

    case ( txt,
           DAE.ALGORITHM(algorithm_ = i_algorithm__) )
      equation
        txt = dumpFunctionAlgorithm(txt, i_algorithm__, "algorithm");
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Element not found"));
      then txt;
  end match;
end dumpFunctionElement;

public function dumpFunctionAlgorithm
  input Tpl.Text in_txt;
  input DAE.Algorithm in_a_algorithm__;
  input String in_a_label;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_algorithm__, in_a_label)
    local
      Tpl.Text txt;
      String a_label;
      list<DAE.Statement> i_statementLst;

    case ( txt,
           DAE.ALGORITHM_STMTS(statementLst = i_statementLst),
           a_label )
      equation
        txt = Tpl.writeStr(txt, a_label);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpStatements(txt, i_statementLst);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpFunctionAlgorithm;

public function dumpInlineType
  input Tpl.Text in_txt;
  input DAE.InlineType in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.AFTER_INDEX_RED_INLINE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"Inline after index reduction\""));
      then txt;

    case ( txt,
           DAE.NORM_INLINE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \"Inline before index reduction\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInlineType;

protected function lm_45
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = dumpVar(txt, i_var, false);
        txt = Tpl.nextIter(txt);
        txt = lm_45(txt, rest);
      then txt;
  end match;
end lm_45;

public function dumpVars
  input Tpl.Text txt;
  input list<DAE.Element> a_v;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_45(out_txt, a_v);
  out_txt := Tpl.popIter(out_txt);
end dumpVars;

protected function fun_47
  input Tpl.Text in_txt;
  input Option<DAE.VariableAttributes> in_a_variableAttributesOption;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_variableAttributesOption)
    local
      Tpl.Text txt;
      DAE.VariableAttributes i_VariableAttributes;

    case ( txt,
           SOME(i_VariableAttributes) )
      equation
        txt = dumpFinalPrefix(txt, i_VariableAttributes);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_47;

protected function fun_48
  input Tpl.Text in_txt;
  input Boolean in_a_printTypeDimension;
  input DAE.InstDims in_a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_printTypeDimension, in_a_dims)
    local
      Tpl.Text txt;
      DAE.InstDims a_dims;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_dims )
      equation
        txt = dumpTypeDimensions(txt, a_dims);
      then txt;
  end match;
end fun_48;

protected function fun_49
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_binding;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_binding)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_49;

protected function fun_50
  input Tpl.Text in_txt;
  input Option<DAE.VariableAttributes> in_a_variableAttributesOption;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_variableAttributesOption)
    local
      Tpl.Text txt;
      DAE.VariableAttributes i_VariableAttributes;

    case ( txt,
           SOME(i_VariableAttributes) )
      equation
        txt = dumpVariableAttributes(txt, i_VariableAttributes);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_50;

protected function fun_51
  input Tpl.Text in_txt;
  input Tpl.Text in_a_bindingExp;
  input Tpl.Text in_a_ann__str;
  input Tpl.Text in_a_cmt__str;
  input Tpl.Text in_a_varAttr;
  input Tpl.Text in_a_attr;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_dim__str;
  input Tpl.Text in_a_varType;
  input Tpl.Text in_a_varDirection;
  input Tpl.Text in_a_varKind;
  input Tpl.Text in_a_varParallelism;
  input Tpl.Text in_a_final;
  input Tpl.Text in_a_varVisibility;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bindingExp, in_a_ann__str, in_a_cmt__str, in_a_varAttr, in_a_attr, in_a_varName, in_a_dim__str, in_a_varType, in_a_varDirection, in_a_varKind, in_a_varParallelism, in_a_final, in_a_varVisibility)
    local
      Tpl.Text txt;
      Tpl.Text a_ann__str;
      Tpl.Text a_cmt__str;
      Tpl.Text a_varAttr;
      Tpl.Text a_attr;
      Tpl.Text a_varName;
      Tpl.Text a_dim__str;
      Tpl.Text a_varType;
      Tpl.Text a_varDirection;
      Tpl.Text a_varKind;
      Tpl.Text a_varParallelism;
      Tpl.Text a_final;
      Tpl.Text a_varVisibility;
      Tpl.Text i_bindingExp;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_ann__str,
           a_cmt__str,
           a_varAttr,
           a_attr,
           a_varName,
           a_dim__str,
           a_varType,
           a_varDirection,
           a_varKind,
           a_varParallelism,
           a_final,
           a_varVisibility )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_varVisibility);
        txt = Tpl.writeText(txt, a_final);
        txt = Tpl.writeText(txt, a_varParallelism);
        txt = Tpl.writeText(txt, a_varKind);
        txt = Tpl.writeText(txt, a_varDirection);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varType);
        txt = Tpl.writeText(txt, a_dim__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeText(txt, a_attr);
        txt = Tpl.writeText(txt, a_varAttr);
        txt = Tpl.writeText(txt, a_cmt__str);
        txt = Tpl.writeText(txt, a_ann__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_bindingExp,
           a_ann__str,
           a_cmt__str,
           a_varAttr,
           a_attr,
           a_varName,
           a_dim__str,
           a_varType,
           a_varDirection,
           a_varKind,
           a_varParallelism,
           a_final,
           a_varVisibility )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_varVisibility);
        txt = Tpl.writeText(txt, a_final);
        txt = Tpl.writeText(txt, a_varParallelism);
        txt = Tpl.writeText(txt, a_varKind);
        txt = Tpl.writeText(txt, a_varDirection);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varType);
        txt = Tpl.writeText(txt, a_dim__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeText(txt, a_attr);
        txt = Tpl.writeText(txt, a_varAttr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, i_bindingExp);
        txt = Tpl.writeText(txt, a_cmt__str);
        txt = Tpl.writeText(txt, a_ann__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_51;

public function dumpVar
  input Tpl.Text in_txt;
  input DAE.Element in_a_lst;
  input Boolean in_a_printTypeDimension;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lst, in_a_printTypeDimension)
    local
      Tpl.Text txt;
      Boolean a_printTypeDimension;
      Option<SCode.Comment> i_comment;
      Option<DAE.Exp> i_binding;
      DAE.ComponentRef i_componentRef;
      DAE.InstDims i_dims;
      DAE.Type i_ty;
      DAE.VarDirection i_direction;
      DAE.VarKind i_kind;
      DAE.VarParallelism i_parallelism;
      DAE.VarVisibility i_protection;
      Option<DAE.VariableAttributes> i_variableAttributesOption;
      Tpl.Text l_ann__str;
      Tpl.Text l_cmt__str;
      Tpl.Text l_varAttr;
      Tpl.Text l_bindingExp;
      Tpl.Text l_varName;
      Tpl.Text l_dim__str;
      Tpl.Text l_varType;
      Tpl.Text l_attr;
      Tpl.Text l_varDirection;
      Tpl.Text l_varKind;
      Tpl.Text l_varParallelism;
      Tpl.Text l_varVisibility;
      Tpl.Text l_final;

    case ( txt,
           DAE.VAR(variableAttributesOption = i_variableAttributesOption, protection = i_protection, parallelism = i_parallelism, kind = i_kind, direction = i_direction, ty = i_ty, dims = i_dims, componentRef = i_componentRef, binding = i_binding, comment = i_comment),
           a_printTypeDimension )
      equation
        l_final = fun_47(Tpl.emptyTxt, i_variableAttributesOption);
        l_varVisibility = dumpVarVisibility(Tpl.emptyTxt, i_protection);
        l_varParallelism = dumpVarParallelism(Tpl.emptyTxt, i_parallelism);
        l_varKind = dumpVarKind(Tpl.emptyTxt, i_kind);
        l_varDirection = dumpVarDirection(Tpl.emptyTxt, i_direction);
        l_attr = Tpl.emptyTxt;
        (l_varType, l_attr) = dumpType(Tpl.emptyTxt, i_ty, l_attr);
        l_dim__str = fun_48(Tpl.emptyTxt, a_printTypeDimension, i_dims);
        l_varName = dumpCref(Tpl.emptyTxt, i_componentRef);
        l_bindingExp = fun_49(Tpl.emptyTxt, i_binding);
        l_varAttr = fun_50(Tpl.emptyTxt, i_variableAttributesOption);
        l_cmt__str = dumpCommentOpt(Tpl.emptyTxt, i_comment);
        l_ann__str = dumpCompAnnotation(Tpl.emptyTxt, i_comment);
        txt = fun_51(txt, l_bindingExp, l_ann__str, l_cmt__str, l_varAttr, l_attr, l_varName, l_dim__str, l_varType, l_varDirection, l_varKind, l_varParallelism, l_final, l_varVisibility);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpVar;

public function dumpFinalPrefix
  input Tpl.Text in_txt;
  input DAE.VariableAttributes in_a_varAttr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varAttr)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.VAR_ATTR_REAL(finalPrefix = SOME(true)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" final"));
      then txt;

    case ( txt,
           DAE.VAR_ATTR_INT(finalPrefix = SOME(true)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" final"));
      then txt;

    case ( txt,
           DAE.VAR_ATTR_BOOL(finalPrefix = SOME(true)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" final"));
      then txt;

    case ( txt,
           DAE.VAR_ATTR_STRING(finalPrefix = SOME(true)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" final"));
      then txt;

    case ( txt,
           DAE.VAR_ATTR_ENUMERATION(finalPrefix = SOME(true)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" final"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFinalPrefix;

public function dumpVarVisibility
  input Tpl.Text in_txt;
  input DAE.VarVisibility in_a_protection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_protection)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.PROTECTED() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" protected"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVarVisibility;

public function dumpVarParallelism
  input Tpl.Text in_txt;
  input DAE.VarParallelism in_a_parallelism;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_parallelism)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.PARGLOBAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" parglobal"));
      then txt;

    case ( txt,
           DAE.PARLOCAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" parlocal"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVarParallelism;

public function dumpVarKind
  input Tpl.Text in_txt;
  input DAE.VarKind in_a_kind;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_kind)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.CONST() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" constant"));
      then txt;

    case ( txt,
           DAE.PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" parameter"));
      then txt;

    case ( txt,
           DAE.DISCRETE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" discrete"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVarKind;

public function dumpVarDirection
  input Tpl.Text in_txt;
  input DAE.VarDirection in_a_direction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_direction)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.INPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" input"));
      then txt;

    case ( txt,
           DAE.OUTPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" output"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVarDirection;

protected function lm_58
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_58(txt, rest);
      then txt;
  end match;
end lm_58;

public function dumpType
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_attributes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_attributes;
algorithm
  (out_txt, out_a_attributes) :=
  match(in_txt, in_a_ty, in_a_attributes)
    local
      Tpl.Text txt;
      Tpl.Text a_attributes;
      DAE.Type i_optionType;
      Absyn.Path i_p;
      String i_name;
      DAE.Type i_listType;
      list<DAE.Type> i_types;
      list<DAE.Type> i_tupleType;
      DAE.Type i_complexType;
      ClassInf.State i_complexClassType;
      Absyn.Path i_rname;
      DAE.Dimensions i_dims;
      DAE.Type i_ty;
      list<String> i_names;
      list<DAE.Var> i_varLst;
      Absyn.Path ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_lit__str;

    case ( txt,
           DAE.T_INTEGER(varLst = i_varLst),
           a_attributes )
      equation
        a_attributes = dumpVarAttributes(a_attributes, i_varLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Integer"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_REAL(varLst = i_varLst),
           a_attributes )
      equation
        a_attributes = dumpVarAttributes(a_attributes, i_varLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_STRING(varLst = i_varLst),
           a_attributes )
      equation
        a_attributes = dumpVarAttributes(a_attributes, i_varLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("String"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_BOOL(varLst = i_varLst),
           a_attributes )
      equation
        a_attributes = dumpVarAttributes(a_attributes, i_varLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Boolean"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_CLOCK(varLst = i_varLst),
           a_attributes )
      equation
        a_attributes = dumpVarAttributes(a_attributes, i_varLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Clock"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_ENUMERATION(names = i_names),
           a_attributes )
      equation
        l_lit__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_lit__str = lm_58(l_lit__str, i_names);
        l_lit__str = Tpl.popIter(l_lit__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("enumeration("));
        txt = Tpl.writeText(txt, l_lit__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_ARRAY(ty = i_ty, dims = i_dims),
           a_attributes )
      equation
        txt_1 = dumpDimensions(Tpl.emptyTxt, i_dims);
        (txt, a_attributes) = dumpArrayType(txt, i_ty, Tpl.textString(txt_1), a_attributes);
      then (txt, a_attributes);

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)),
           a_attributes )
      equation
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_rname);
      then (txt, a_attributes);

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_complexClassType),
           a_attributes )
      equation
        ret_2 = ClassInf.getStateName(i_complexClassType);
        txt = AbsynDumpTpl.dumpPath(txt, ret_2);
      then (txt, a_attributes);

    case ( txt,
           DAE.T_SUBTYPE_BASIC(complexType = i_complexType),
           a_attributes )
      equation
        (txt, a_attributes) = dumpType(txt, i_complexType, a_attributes);
      then (txt, a_attributes);

    case ( txt,
           (i_ty as DAE.T_FUNCTION(funcArg = _)),
           a_attributes )
      equation
        txt = dumpFunctionType(txt, i_ty);
      then (txt, a_attributes);

    case ( txt,
           DAE.T_TUPLE(tupleType = i_tupleType),
           a_attributes )
      equation
        txt = dumpTupleType(txt, i_tupleType, "(", ")");
      then (txt, a_attributes);

    case ( txt,
           DAE.T_METATUPLE(types = i_types),
           a_attributes )
      equation
        txt = dumpTupleType(txt, i_types, "tuple<", ">");
      then (txt, a_attributes);

    case ( txt,
           DAE.T_METALIST(listType = i_listType),
           a_attributes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("list<"));
        (txt, a_attributes) = dumpType(txt, i_listType, a_attributes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_METAARRAY(ty = i_ty),
           a_attributes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("array<"));
        (txt, a_attributes) = dumpType(txt, i_ty, a_attributes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_METAPOLYMORPHIC(name = i_name),
           a_attributes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("polymorphic<"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_METAUNIONTYPE(source = {i_p}),
           a_attributes )
      equation
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_p);
      then (txt, a_attributes);

    case ( txt,
           DAE.T_METARECORD(source = {i_p}),
           a_attributes )
      equation
        txt = AbsynDumpTpl.dumpPathNoQual(txt, i_p);
      then (txt, a_attributes);

    case ( txt,
           DAE.T_METABOXED(ty = i_ty),
           a_attributes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#"));
        (txt, a_attributes) = dumpType(txt, i_ty, a_attributes);
      then (txt, a_attributes);

    case ( txt,
           DAE.T_METAOPTION(optionType = DAE.T_UNKNOWN(source = _)),
           a_attributes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Option<Any>"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_METAOPTION(optionType = i_optionType),
           a_attributes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Option<"));
        (txt, a_attributes) = dumpType(txt, i_optionType, a_attributes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_METATYPE(ty = i_ty),
           a_attributes )
      equation
        (txt, a_attributes) = dumpType(txt, i_ty, a_attributes);
      then (txt, a_attributes);

    case ( txt,
           DAE.T_NORETCALL(source = _),
           a_attributes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#T_NORETCALL#"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_UNKNOWN(source = _),
           a_attributes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#T_UNKNOWN#"));
      then (txt, a_attributes);

    case ( txt,
           DAE.T_ANYTYPE(anyClassType = _),
           a_attributes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#T_ANYTYPE#"));
      then (txt, a_attributes);

    case ( txt,
           _,
           a_attributes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DAEDumpTpl.dumpType: Not yet implemented"));
      then (txt, a_attributes);
  end match;
end dumpType;

protected function fun_60
  input Tpl.Text in_txt;
  input String in_a_dims__accum;
  input Tpl.Text in_a_dims__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dims__accum, in_a_dims__str)
    local
      Tpl.Text txt;
      Tpl.Text a_dims__str;
      String i_dims__accum;

    case ( txt,
           "",
           a_dims__str )
      equation
        txt = Tpl.writeText(txt, a_dims__str);
      then txt;

    case ( txt,
           i_dims__accum,
           a_dims__str )
      equation
        txt = Tpl.writeStr(txt, i_dims__accum);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_dims__str);
      then txt;
  end match;
end fun_60;

protected function fun_61
  input Tpl.Text in_txt;
  input String in_a_dims__accum;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dims__accum)
    local
      Tpl.Text txt;
      String i_dims__accum;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_dims__accum )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, i_dims__accum);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end fun_61;

public function dumpArrayType
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input String in_a_dims__accum;
  input Tpl.Text in_a_attributes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_attributes;
algorithm
  (out_txt, out_a_attributes) :=
  match(in_txt, in_a_ty, in_a_dims__accum, in_a_attributes)
    local
      Tpl.Text txt;
      String a_dims__accum;
      Tpl.Text a_attributes;
      DAE.Type i_ty;
      DAE.Dimensions i_dims;
      Tpl.Text l_ty__str;
      Tpl.Text l_dims__accum__str;
      Tpl.Text l_dims__str;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims, ty = i_ty),
           a_dims__accum,
           a_attributes )
      equation
        l_dims__str = dumpDimensions(Tpl.emptyTxt, i_dims);
        l_dims__accum__str = fun_60(Tpl.emptyTxt, a_dims__accum, l_dims__str);
        (txt, a_attributes) = dumpArrayType(txt, i_ty, Tpl.textString(l_dims__accum__str), a_attributes);
      then (txt, a_attributes);

    case ( txt,
           i_ty,
           a_dims__accum,
           a_attributes )
      equation
        (l_ty__str, a_attributes) = dumpType(Tpl.emptyTxt, i_ty, a_attributes);
        l_dims__str = fun_61(Tpl.emptyTxt, a_dims__accum);
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeText(txt, l_dims__str);
      then (txt, a_attributes);
  end match;
end dumpArrayType;

protected function lm_63
  input Tpl.Text in_txt;
  input list<DAE.Type> in_items;
  input Tpl.Text in_a_attr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_attr;
algorithm
  (out_txt, out_a_attr) :=
  match(in_txt, in_items, in_a_attr)
    local
      Tpl.Text txt;
      list<DAE.Type> rest;
      Tpl.Text a_attr;
      DAE.Type i_ty;

    case ( txt,
           {},
           a_attr )
      then (txt, a_attr);

    case ( txt,
           i_ty :: rest,
           a_attr )
      equation
        (txt, a_attr) = dumpType(txt, i_ty, a_attr);
        txt = Tpl.nextIter(txt);
        (txt, a_attr) = lm_63(txt, rest, a_attr);
      then (txt, a_attr);
  end match;
end lm_63;

public function dumpTupleType
  input Tpl.Text txt;
  input list<DAE.Type> a_tys;
  input String a_ty__begin;
  input String a_ty__end;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_attr;
algorithm
  l_attr := Tpl.emptyTxt;
  out_txt := Tpl.writeStr(txt, a_ty__begin);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, l_attr) := lm_63(out_txt, a_tys, l_attr);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.writeStr(out_txt, a_ty__end);
end dumpTupleType;

protected function lm_65
  input Tpl.Text in_txt;
  input list<DAE.FuncArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.FuncArg> rest;
      DAE.FuncArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = dumpFuncArg(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_65(txt, rest);
      then txt;
  end match;
end lm_65;

protected function lm_66
  input Tpl.Text in_txt;
  input DAE.TypeSource in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.TypeSource rest;
      Absyn.Path i_src;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_src :: rest )
      equation
        txt = AbsynDumpTpl.dumpPath(txt, i_src);
        txt = Tpl.nextIter(txt);
        txt = lm_66(txt, rest);
      then txt;
  end match;
end lm_66;

public function dumpFunctionType
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_funcResultType;
      DAE.TypeSource i_source;
      list<DAE.FuncArg> i_funcArg;
      Tpl.Text l_res__str;
      Tpl.Text l_attr;
      Tpl.Text l_src__str;
      Tpl.Text l_args__str;

    case ( txt,
           DAE.T_FUNCTION(funcArg = i_funcArg, source = i_source, funcResultType = i_funcResultType) )
      equation
        l_args__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_args__str = lm_65(l_args__str, i_funcArg);
        l_args__str = Tpl.popIter(l_args__str);
        l_src__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_src__str = lm_66(l_src__str, i_source);
        l_src__str = Tpl.popIter(l_src__str);
        l_attr = Tpl.emptyTxt;
        (l_res__str, l_attr) = dumpType(Tpl.emptyTxt, i_funcResultType, l_attr);
        txt = Tpl.writeText(txt, l_src__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function>("));
        txt = Tpl.writeText(txt, l_args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") => "));
        txt = Tpl.writeText(txt, l_res__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFunctionType;

protected function fun_68
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_defaultBinding;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_defaultBinding)
    local
      Tpl.Text txt;
      DAE.Exp i_bexp;

    case ( txt,
           SOME(i_bexp) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":= "));
        txt = dumpExp(txt, i_bexp);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_68;

public function dumpFuncArg
  input Tpl.Text in_txt;
  input DAE.FuncArg in_a_arg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arg)
    local
      Tpl.Text txt;
      String i_name;
      Option<DAE.Exp> i_defaultBinding;
      DAE.VarParallelism i_par;
      DAE.Const i_const;
      DAE.Type i_ty;
      Tpl.Text l_binding__str;
      Tpl.Text l_p__str;
      Tpl.Text l_c__str;
      Tpl.Text l_ty__str;
      Tpl.Text l_attr;

    case ( txt,
           DAE.FUNCARG(ty = i_ty, const = i_const, par = i_par, defaultBinding = i_defaultBinding, name = i_name) )
      equation
        l_attr = Tpl.emptyTxt;
        (l_ty__str, l_attr) = dumpType(Tpl.emptyTxt, i_ty, l_attr);
        l_c__str = dumpConst(Tpl.emptyTxt, i_const);
        l_p__str = dumpParallelism(Tpl.emptyTxt, i_par);
        l_binding__str = fun_68(Tpl.emptyTxt, i_defaultBinding);
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_c__str);
        txt = Tpl.writeText(txt, l_p__str);
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeText(txt, l_binding__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFuncArg;

public function dumpConst
  input Tpl.Text in_txt;
  input DAE.Const in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_c)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.C_PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parameter "));
      then txt;

    case ( txt,
           DAE.C_CONST() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpConst;

public function dumpParallelism
  input Tpl.Text in_txt;
  input DAE.VarParallelism in_a_p;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_p)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.PARGLOBAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parglobal "));
      then txt;

    case ( txt,
           DAE.PARLOCAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parlocal "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpParallelism;

protected function lm_72
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      DAE.Var i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = dumpVarAttribute(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_72(txt, rest);
      then txt;
  end match;
end lm_72;

public function dumpVarAttributes
  input Tpl.Text in_txt;
  input list<DAE.Var> in_a_literalVarLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_literalVarLst)
    local
      Tpl.Text txt;
      list<DAE.Var> i_literalVarLst;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literalVarLst )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_72(txt, i_literalVarLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end dumpVarAttributes;

public function dumpVarAttribute
  input Tpl.Text in_txt;
  input DAE.Var in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Exp i_e;
      DAE.Ident i_name;

    case ( txt,
           DAE.TYPES_VAR(binding = DAE.EQBOUND(exp = i_e), name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = dumpExp(txt, i_e);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVarAttribute;

protected function lm_75
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Dimension> rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dumpDimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_75(txt, rest);
      then txt;
  end match;
end lm_75;

public function dumpDimensions
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dims)
    local
      Tpl.Text txt;
      list<DAE.Dimension> i_dims;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dims )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_75(txt, i_dims);
        txt = Tpl.popIter(txt);
      then txt;
  end match;
end dumpDimensions;

public function dumpDimension
  input Tpl.Text in_txt;
  input DAE.Dimension in_a_dim;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dim)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Absyn.Path i_enumTypeName;
      Integer i_integer;

    case ( txt,
           DAE.DIM_INTEGER(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.DIM_ENUM(enumTypeName = i_enumTypeName) )
      equation
        txt = AbsynDumpTpl.dumpPath(txt, i_enumTypeName);
      then txt;

    case ( txt,
           DAE.DIM_EXP(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           DAE.DIM_UNKNOWN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpDimension;

protected function smf_78
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_78;

protected function smf_79
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_79;

protected function smf_80
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_80;

protected function smf_81
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_81;

protected function smf_82
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_82;

protected function smf_83
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_83;

protected function smf_84
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_84;

protected function smf_85
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_85;

protected function smf_86
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_86;

protected function smf_87
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_87;

protected function smf_88
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_88;

protected function smf_89
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_89;

protected function fun_90
  input Tpl.Text in_txt;
  input Tpl.Text in_a_attrs__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attrs__str)
    local
      Tpl.Text txt;
      Tpl.Text i_attrs__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_attrs__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_attrs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_90;

protected function smf_91
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_91;

protected function smf_92
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_92;

protected function smf_93
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_93;

protected function smf_94
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_94;

protected function smf_95
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_95;

protected function smf_96
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_96;

protected function smf_97
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_97;

protected function smf_98
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_98;

protected function fun_99
  input Tpl.Text in_txt;
  input Tpl.Text in_a_attrs__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attrs__str)
    local
      Tpl.Text txt;
      Tpl.Text i_attrs__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_attrs__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_attrs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_99;

protected function smf_100
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_100;

protected function smf_101
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_101;

protected function smf_102
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_102;

protected function smf_103
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_103;

protected function fun_104
  input Tpl.Text in_txt;
  input Tpl.Text in_a_attrs__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attrs__str)
    local
      Tpl.Text txt;
      Tpl.Text i_attrs__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_attrs__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_attrs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_104;

protected function smf_105
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_105;

protected function smf_106
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_106;

protected function smf_107
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_107;

protected function fun_108
  input Tpl.Text in_txt;
  input Tpl.Text in_a_attrs__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attrs__str)
    local
      Tpl.Text txt;
      Tpl.Text i_attrs__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_attrs__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_attrs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_108;

protected function smf_109
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_109;

protected function smf_110
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_110;

protected function smf_111
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_111;

protected function smf_112
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_112;

protected function smf_113
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_113;

protected function smf_114
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_114;

protected function fun_115
  input Tpl.Text in_txt;
  input Tpl.Text in_a_attrs__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attrs__str)
    local
      Tpl.Text txt;
      Tpl.Text i_attrs__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_attrs__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_attrs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_115;

public function dumpVariableAttributes
  input Tpl.Text in_txt;
  input DAE.VariableAttributes in_a_variableAttributesOption;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_variableAttributesOption)
    local
      Tpl.Text txt;
      Option<DAE.Exp> i_startOrigin;
      Option<DAE.Distribution> i_distributionOption;
      Option<DAE.Uncertainty> i_uncertainOption;
      Option<DAE.StateSelect> i_stateSelectOption;
      Option<DAE.Exp> i_nominal;
      Option<DAE.Exp> i_fixed;
      Option<DAE.Exp> i_start;
      Option<DAE.Exp> i_max;
      Option<DAE.Exp> i_min;
      Option<DAE.Exp> i_displayUnit;
      Option<DAE.Exp> i_unit;
      Option<DAE.Exp> i_quantity;
      Tpl.Text l_attrs__str;
      Tpl.Text l_so__str;
      Tpl.Text l_dist__str;
      Tpl.Text l_uncert__str;
      Tpl.Text l_statesel__str;
      Tpl.Text l_nominal__str;
      Tpl.Text l_fixed__str;
      Tpl.Text l_start__str;
      Tpl.Text l_max__str;
      Tpl.Text l_min__str;
      Tpl.Text l_displayunit__str;
      Tpl.Text l_unit__str;
      Tpl.Text l_quantity__str;

    case ( txt,
           DAE.VAR_ATTR_REAL(quantity = i_quantity, unit = i_unit, displayUnit = i_displayUnit, min = i_min, max = i_max, start = i_start, fixed = i_fixed, nominal = i_nominal, stateSelectOption = i_stateSelectOption, uncertainOption = i_uncertainOption, distributionOption = i_distributionOption, startOrigin = i_startOrigin) )
      equation
        l_quantity__str = dumpExpAttrOpt(Tpl.emptyTxt, i_quantity, "quantity");
        l_unit__str = dumpExpAttrOpt(Tpl.emptyTxt, i_unit, "unit");
        l_displayunit__str = dumpExpAttrOpt(Tpl.emptyTxt, i_displayUnit, "displayUnit");
        l_min__str = dumpExpAttrOpt(Tpl.emptyTxt, i_min, "min");
        l_max__str = dumpExpAttrOpt(Tpl.emptyTxt, i_max, "max");
        l_start__str = dumpExpAttrOpt(Tpl.emptyTxt, i_start, "start");
        l_fixed__str = dumpExpAttrOpt(Tpl.emptyTxt, i_fixed, "fixed");
        l_nominal__str = dumpExpAttrOpt(Tpl.emptyTxt, i_nominal, "nominal");
        l_statesel__str = dumpStateSelectAttrOpt(Tpl.emptyTxt, i_stateSelectOption);
        l_uncert__str = dumpUncertaintyAttrOpt(Tpl.emptyTxt, i_uncertainOption);
        l_dist__str = dumpDistributionAttrOpt(Tpl.emptyTxt, i_distributionOption);
        l_so__str = dumpStartOriginAttrOpt(Tpl.emptyTxt, i_startOrigin);
        l_attrs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attrs__str = smf_78(l_attrs__str, l_quantity__str);
        l_attrs__str = smf_79(l_attrs__str, l_unit__str);
        l_attrs__str = smf_80(l_attrs__str, l_displayunit__str);
        l_attrs__str = smf_81(l_attrs__str, l_min__str);
        l_attrs__str = smf_82(l_attrs__str, l_max__str);
        l_attrs__str = smf_83(l_attrs__str, l_start__str);
        l_attrs__str = smf_84(l_attrs__str, l_fixed__str);
        l_attrs__str = smf_85(l_attrs__str, l_nominal__str);
        l_attrs__str = smf_86(l_attrs__str, l_statesel__str);
        l_attrs__str = smf_87(l_attrs__str, l_uncert__str);
        l_attrs__str = smf_88(l_attrs__str, l_dist__str);
        l_attrs__str = smf_89(l_attrs__str, l_so__str);
        l_attrs__str = Tpl.popIter(l_attrs__str);
        txt = fun_90(txt, l_attrs__str);
      then txt;

    case ( txt,
           DAE.VAR_ATTR_INT(quantity = i_quantity, min = i_min, max = i_max, start = i_start, fixed = i_fixed, uncertainOption = i_uncertainOption, distributionOption = i_distributionOption, startOrigin = i_startOrigin) )
      equation
        l_quantity__str = dumpExpAttrOpt(Tpl.emptyTxt, i_quantity, "quantity");
        l_min__str = dumpExpAttrOpt(Tpl.emptyTxt, i_min, "min");
        l_max__str = dumpExpAttrOpt(Tpl.emptyTxt, i_max, "max");
        l_start__str = dumpExpAttrOpt(Tpl.emptyTxt, i_start, "start");
        l_fixed__str = dumpExpAttrOpt(Tpl.emptyTxt, i_fixed, "fixed");
        l_uncert__str = dumpUncertaintyAttrOpt(Tpl.emptyTxt, i_uncertainOption);
        l_dist__str = dumpDistributionAttrOpt(Tpl.emptyTxt, i_distributionOption);
        l_so__str = dumpStartOriginAttrOpt(Tpl.emptyTxt, i_startOrigin);
        l_attrs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attrs__str = smf_91(l_attrs__str, l_quantity__str);
        l_attrs__str = smf_92(l_attrs__str, l_min__str);
        l_attrs__str = smf_93(l_attrs__str, l_max__str);
        l_attrs__str = smf_94(l_attrs__str, l_start__str);
        l_attrs__str = smf_95(l_attrs__str, l_fixed__str);
        l_attrs__str = smf_96(l_attrs__str, l_uncert__str);
        l_attrs__str = smf_97(l_attrs__str, l_dist__str);
        l_attrs__str = smf_98(l_attrs__str, l_so__str);
        l_attrs__str = Tpl.popIter(l_attrs__str);
        txt = fun_99(txt, l_attrs__str);
      then txt;

    case ( txt,
           DAE.VAR_ATTR_BOOL(quantity = i_quantity, start = i_start, fixed = i_fixed, startOrigin = i_startOrigin) )
      equation
        l_quantity__str = dumpExpAttrOpt(Tpl.emptyTxt, i_quantity, "quantity");
        l_start__str = dumpExpAttrOpt(Tpl.emptyTxt, i_start, "start");
        l_fixed__str = dumpExpAttrOpt(Tpl.emptyTxt, i_fixed, "fixed");
        l_so__str = dumpStartOriginAttrOpt(Tpl.emptyTxt, i_startOrigin);
        l_attrs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attrs__str = smf_100(l_attrs__str, l_quantity__str);
        l_attrs__str = smf_101(l_attrs__str, l_start__str);
        l_attrs__str = smf_102(l_attrs__str, l_fixed__str);
        l_attrs__str = smf_103(l_attrs__str, l_so__str);
        l_attrs__str = Tpl.popIter(l_attrs__str);
        txt = fun_104(txt, l_attrs__str);
      then txt;

    case ( txt,
           DAE.VAR_ATTR_STRING(quantity = i_quantity, start = i_start, startOrigin = i_startOrigin) )
      equation
        l_quantity__str = dumpExpAttrOpt(Tpl.emptyTxt, i_quantity, "quantity");
        l_start__str = dumpExpAttrOpt(Tpl.emptyTxt, i_start, "start");
        l_so__str = dumpStartOriginAttrOpt(Tpl.emptyTxt, i_startOrigin);
        l_attrs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attrs__str = smf_105(l_attrs__str, l_quantity__str);
        l_attrs__str = smf_106(l_attrs__str, l_start__str);
        l_attrs__str = smf_107(l_attrs__str, l_so__str);
        l_attrs__str = Tpl.popIter(l_attrs__str);
        txt = fun_108(txt, l_attrs__str);
      then txt;

    case ( txt,
           DAE.VAR_ATTR_ENUMERATION(quantity = i_quantity, min = i_min, max = i_max, start = i_start, fixed = i_fixed, startOrigin = i_startOrigin) )
      equation
        l_quantity__str = dumpExpAttrOpt(Tpl.emptyTxt, i_quantity, "quantity");
        l_min__str = dumpExpAttrOpt(Tpl.emptyTxt, i_min, "min");
        l_max__str = dumpExpAttrOpt(Tpl.emptyTxt, i_max, "max");
        l_start__str = dumpExpAttrOpt(Tpl.emptyTxt, i_start, "start");
        l_fixed__str = dumpExpAttrOpt(Tpl.emptyTxt, i_fixed, "fixed");
        l_so__str = dumpStartOriginAttrOpt(Tpl.emptyTxt, i_startOrigin);
        l_attrs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attrs__str = smf_109(l_attrs__str, l_quantity__str);
        l_attrs__str = smf_110(l_attrs__str, l_min__str);
        l_attrs__str = smf_111(l_attrs__str, l_max__str);
        l_attrs__str = smf_112(l_attrs__str, l_start__str);
        l_attrs__str = smf_113(l_attrs__str, l_fixed__str);
        l_attrs__str = smf_114(l_attrs__str, l_so__str);
        l_attrs__str = Tpl.popIter(l_attrs__str);
        txt = fun_115(txt, l_attrs__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVariableAttributes;

public function dumpExpAttrOpt
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_exp;
  input String in_a_attr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp, in_a_attr)
    local
      Tpl.Text txt;
      String a_attr;
      DAE.Exp i_e;

    case ( txt,
           SOME(i_e),
           a_attr )
      equation
        txt = Tpl.writeStr(txt, a_attr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = dumpExp(txt, i_e);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpExpAttrOpt;

public function dumpStateSelectAttrOpt
  input Tpl.Text in_txt;
  input Option<DAE.StateSelect> in_a_stateSelect;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stateSelect)
    local
      Tpl.Text txt;
      DAE.StateSelect i_ss;

    case ( txt,
           SOME(i_ss) )
      equation
        txt = dumpStateSelectAttr(txt, i_ss);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpStateSelectAttrOpt;

public function dumpStateSelectAttr
  input Tpl.Text txt;
  input DAE.StateSelect a_stateSelect;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("stateSelect = "));
  out_txt := dumpStateSelect(out_txt, a_stateSelect);
end dumpStateSelectAttr;

public function dumpStateSelect
  input Tpl.Text in_txt;
  input DAE.StateSelect in_a_stateSelect;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stateSelect)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.NEVER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StateSelect.never"));
      then txt;

    case ( txt,
           DAE.AVOID() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StateSelect.avoid"));
      then txt;

    case ( txt,
           DAE.DEFAULT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StateSelect.default"));
      then txt;

    case ( txt,
           DAE.PREFER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StateSelect.prefer"));
      then txt;

    case ( txt,
           DAE.ALWAYS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StateSelect.always"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpStateSelect;

public function dumpUncertaintyAttrOpt
  input Tpl.Text in_txt;
  input Option<DAE.Uncertainty> in_a_uncertainty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_uncertainty)
    local
      Tpl.Text txt;
      DAE.Uncertainty i_u;

    case ( txt,
           SOME(i_u) )
      equation
        txt = dumpUncertaintyAttr(txt, i_u);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpUncertaintyAttrOpt;

public function dumpUncertaintyAttr
  input Tpl.Text txt;
  input DAE.Uncertainty a_uncertainty;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("uncertainty = "));
  out_txt := dumpUncertainty(out_txt, a_uncertainty);
end dumpUncertaintyAttr;

public function dumpUncertainty
  input Tpl.Text in_txt;
  input DAE.Uncertainty in_a_uncertainty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_uncertainty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.GIVEN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Uncertainty.given"));
      then txt;

    case ( txt,
           DAE.SOUGHT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Uncertainty.sought"));
      then txt;

    case ( txt,
           DAE.REFINE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Uncertainty.refine"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpUncertainty;

public function dumpDistributionAttrOpt
  input Tpl.Text in_txt;
  input Option<DAE.Distribution> in_a_distribution;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_distribution)
    local
      Tpl.Text txt;
      DAE.Distribution i_d;

    case ( txt,
           SOME(i_d) )
      equation
        txt = dumpDistributionAttr(txt, i_d);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpDistributionAttrOpt;

public function dumpDistributionAttr
  input Tpl.Text txt;
  input DAE.Distribution a_distribution;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("distribution = "));
  out_txt := dumpDistribution(out_txt, a_distribution);
end dumpDistributionAttr;

public function dumpDistribution
  input Tpl.Text in_txt;
  input DAE.Distribution in_a_distribution;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_distribution)
    local
      Tpl.Text txt;
      DAE.Exp i_paramNames;
      DAE.Exp i_params;
      DAE.Exp i_name;
      Tpl.Text l_paramnames__str;
      Tpl.Text l_params__str;
      Tpl.Text l_name__str;

    case ( txt,
           DAE.DISTRIBUTION(name = i_name, params = i_params, paramNames = i_paramNames) )
      equation
        l_name__str = dumpExp(Tpl.emptyTxt, i_name);
        l_params__str = dumpExp(Tpl.emptyTxt, i_params);
        l_paramnames__str = dumpExp(Tpl.emptyTxt, i_paramNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Distribution(name = "));
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", params = "));
        txt = Tpl.writeText(txt, l_params__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", paramNames = "));
        txt = Tpl.writeText(txt, l_paramnames__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpDistribution;

protected function fun_127
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Option<DAE.Exp> in_a_startOrigin;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_startOrigin)
    local
      Tpl.Text txt;
      Option<DAE.Exp> a_startOrigin;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_startOrigin )
      equation
        txt = dumpExpAttrOpt(txt, a_startOrigin, "startOrigin");
      then txt;
  end match;
end fun_127;

public function dumpStartOriginAttrOpt
  input Tpl.Text txt;
  input Option<DAE.Exp> a_startOrigin;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := Config.showStartOrigin();
  out_txt := fun_127(txt, ret_0, a_startOrigin);
end dumpStartOriginAttrOpt;

public function dumpCref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = dumpSubscripts(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dumpCref(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = (i_ident as "$DER"), subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der("));
        txt = Tpl.writeStr(txt, i_ident);
        txt = dumpSubscripts(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = dumpSubscripts(txt, i_subscriptLst);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpCref;

protected function lm_130
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Dimension> rest;
      DAE.Dimension i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = dumpDimension(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_130(txt, rest);
      then txt;
  end match;
end lm_130;

public function dumpTypeDimensions
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_a_dimensionLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dimensionLst)
    local
      Tpl.Text txt;
      list<DAE.Dimension> i_dimensionLst;
      Tpl.Text l_sub__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dimensionLst )
      equation
        l_sub__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_sub__str = lm_130(l_sub__str, i_dimensionLst);
        l_sub__str = Tpl.popIter(l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end dumpTypeDimensions;

protected function lm_132
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = dumpSubscript(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_132(txt, rest);
      then txt;
  end match;
end lm_132;

public function dumpSubscripts
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscriptLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscriptLst)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscriptLst;
      Tpl.Text l_sub__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscriptLst )
      equation
        l_sub__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_sub__str = lm_132(l_sub__str, i_subscriptLst);
        l_sub__str = Tpl.popIter(l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end dumpSubscripts;

public function dumpSubscript
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           DAE.SLICE(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           DAE.INDEX(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           DAE.WHOLE_NONEXP(exp = i_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1:"));
        txt = dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpSubscript;

protected function lm_135
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_ineq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ineq :: rest )
      equation
        txt = dumpEquationElement(txt, i_ineq);
        txt = Tpl.nextIter(txt);
        txt = lm_135(txt, rest);
      then txt;
  end match;
end lm_135;

public function dumpInitialEquationSection
  input Tpl.Text in_txt;
  input list<DAE.Element> in_a_ie;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ie)
    local
      Tpl.Text txt;
      list<DAE.Element> i_ie;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ie )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("initial equation\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_135(txt, i_ie);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end dumpInitialEquationSection;

protected function lm_137
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = dumpEquationElement(txt, i_eq);
        txt = Tpl.nextIter(txt);
        txt = lm_137(txt, rest);
      then txt;
  end match;
end lm_137;

public function dumpEquationSection
  input Tpl.Text in_txt;
  input list<DAE.Element> in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_e)
    local
      Tpl.Text txt;
      list<DAE.Element> i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("equation\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_137(txt, i_e);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end dumpEquationSection;

public function dumpEquationElement
  input Tpl.Text in_txt;
  input DAE.Element in_a_lst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lst)
    local
      Tpl.Text txt;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      DAE.Exp i_level;
      DAE.Exp i_message;
      DAE.Exp i_condition;
      list<DAE.Element> i_equations3;
      list<list<DAE.Element>> i_equations2;
      list<DAE.Exp> i_condition1;
      DAE.Element i_lst;
      DAE.ComponentRef i_componentRef;
      DAE.Exp i_rhs;
      DAE.Exp i_lhs;
      DAE.Exp i_array;
      DAE.ComponentRef i_cr2;
      DAE.ComponentRef i_cr1;
      DAE.ElementSource i_source;
      DAE.Exp i_scalar;
      DAE.Exp i_exp;

    case ( txt,
           DAE.EQUATION(exp = i_exp, scalar = i_scalar, source = i_source) )
      equation
        txt = dumpEquation(txt, i_exp, i_scalar, i_source);
      then txt;

    case ( txt,
           DAE.EQUEQUATION(cr1 = i_cr1, cr2 = i_cr2, source = i_source) )
      equation
        txt = dumpEquEquation(txt, i_cr1, i_cr2, i_source);
      then txt;

    case ( txt,
           DAE.ARRAY_EQUATION(exp = i_exp, array = i_array, source = i_source) )
      equation
        txt = dumpEquation(txt, i_exp, i_array, i_source);
      then txt;

    case ( txt,
           DAE.COMPLEX_EQUATION(lhs = i_lhs, rhs = i_rhs, source = i_source) )
      equation
        txt = dumpEquation(txt, i_lhs, i_rhs, i_source);
      then txt;

    case ( txt,
           DAE.DEFINE(componentRef = i_componentRef, exp = i_exp, source = i_source) )
      equation
        txt = dumpDefine(txt, i_componentRef, i_exp, i_source);
      then txt;

    case ( txt,
           (i_lst as DAE.WHEN_EQUATION(condition = _)) )
      equation
        txt = dumpWhenEquation(txt, i_lst);
      then txt;

    case ( txt,
           DAE.IF_EQUATION(condition1 = i_condition1, equations2 = i_equations2, equations3 = i_equations3, source = i_source) )
      equation
        txt = dumpIfEquation(txt, i_condition1, i_equations2, i_equations3, i_source);
      then txt;

    case ( txt,
           DAE.ASSERT(condition = i_condition, message = i_message, level = i_level, source = i_source) )
      equation
        txt = dumpAssert(txt, i_condition, i_message, i_level, i_source);
      then txt;

    case ( txt,
           DAE.TERMINATE(message = i_message, source = i_source) )
      equation
        txt = dumpTerminate(txt, i_message, i_source);
      then txt;

    case ( txt,
           DAE.REINIT(componentRef = i_componentRef, exp = i_exp, source = i_source) )
      equation
        txt = dumpReinit(txt, i_componentRef, i_exp, i_source);
      then txt;

    case ( txt,
           DAE.NORETCALL(exp = i_exp, source = i_source) )
      equation
        txt = dumpNoRetCall(txt, i_exp, i_source);
      then txt;

    case ( txt,
           DAE.INITIALDEFINE(componentRef = i_componentRef, exp = i_exp, source = i_source) )
      equation
        txt = dumpDefine(txt, i_componentRef, i_exp, i_source);
      then txt;

    case ( txt,
           DAE.INITIAL_ARRAY_EQUATION(exp = i_exp, array = i_array, source = i_source) )
      equation
        txt = dumpEquation(txt, i_exp, i_array, i_source);
      then txt;

    case ( txt,
           DAE.INITIAL_COMPLEX_EQUATION(lhs = i_lhs, rhs = i_rhs, source = i_source) )
      equation
        txt = dumpEquation(txt, i_lhs, i_rhs, i_source);
      then txt;

    case ( txt,
           DAE.INITIAL_IF_EQUATION(condition1 = i_condition1, equations2 = i_equations2, equations3 = i_equations3, source = i_source) )
      equation
        txt = dumpIfEquation(txt, i_condition1, i_equations2, i_equations3, i_source);
      then txt;

    case ( txt,
           DAE.INITIALEQUATION(exp1 = i_exp1, exp2 = i_exp2, source = i_source) )
      equation
        txt = dumpEquation(txt, i_exp1, i_exp2, i_source);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN EQUATION TYPE"));
      then txt;
  end match;
end dumpEquationElement;

protected function fun_140
  input Tpl.Text in_txt;
  input DAE.Exp in_a_lhs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lhs)
    local
      Tpl.Text txt;
      DAE.Exp i_lhs;

    case ( txt,
           (i_lhs as DAE.IFEXP(expCond = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = dumpExp(txt, i_lhs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           i_lhs )
      equation
        txt = dumpExp(txt, i_lhs);
      then txt;
  end match;
end fun_140;

public function dumpEquation
  input Tpl.Text txt;
  input DAE.Exp a_lhs;
  input DAE.Exp a_rhs;
  input DAE.ElementSource a_src;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_src__str;
  Tpl.Text l_rhs__str;
  Tpl.Text l_lhs__str;
algorithm
  l_lhs__str := fun_140(Tpl.emptyTxt, a_lhs);
  l_rhs__str := dumpExp(Tpl.emptyTxt, a_rhs);
  l_src__str := dumpSource(Tpl.emptyTxt, a_src);
  out_txt := Tpl.writeText(txt, l_lhs__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" = "));
  out_txt := Tpl.writeText(out_txt, l_rhs__str);
  out_txt := Tpl.writeText(out_txt, l_src__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(";"));
end dumpEquation;

public function dumpEquEquation
  input Tpl.Text txt;
  input DAE.ComponentRef a_lhs;
  input DAE.ComponentRef a_rhs;
  input DAE.ElementSource a_src;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_src__str;
  Tpl.Text l_rhs__str;
  Tpl.Text l_lhs__str;
algorithm
  l_lhs__str := dumpCref(Tpl.emptyTxt, a_lhs);
  l_rhs__str := dumpCref(Tpl.emptyTxt, a_rhs);
  l_src__str := dumpSource(Tpl.emptyTxt, a_src);
  out_txt := Tpl.writeText(txt, l_lhs__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" = "));
  out_txt := Tpl.writeText(out_txt, l_rhs__str);
  out_txt := Tpl.writeText(out_txt, l_src__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(";"));
end dumpEquEquation;

public function dumpDefine
  input Tpl.Text txt;
  input DAE.ComponentRef a_lhs;
  input DAE.Exp a_rhs;
  input DAE.ElementSource a_src;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_src__str;
  Tpl.Text l_rhs__str;
  Tpl.Text l_lhs__str;
algorithm
  l_lhs__str := dumpCref(Tpl.emptyTxt, a_lhs);
  l_rhs__str := dumpExp(Tpl.emptyTxt, a_rhs);
  l_src__str := dumpSource(Tpl.emptyTxt, a_src);
  out_txt := Tpl.writeText(txt, l_lhs__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" = "));
  out_txt := Tpl.writeText(out_txt, l_rhs__str);
  out_txt := Tpl.writeText(out_txt, l_src__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(";"));
end dumpDefine;

protected function fun_144
  input Tpl.Text in_txt;
  input DAE.Exp in_a_lvl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lvl)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = 2) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", AssertionLevel.warning"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_144;

public function dumpAssert
  input Tpl.Text txt;
  input DAE.Exp a_cond;
  input DAE.Exp a_msg;
  input DAE.Exp a_lvl;
  input DAE.ElementSource a_src;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_src__str;
  Tpl.Text l_lvl__str;
  Tpl.Text l_msg__str;
  Tpl.Text l_cond__str;
algorithm
  l_cond__str := dumpExp(Tpl.emptyTxt, a_cond);
  l_msg__str := dumpExp(Tpl.emptyTxt, a_msg);
  l_lvl__str := fun_144(Tpl.emptyTxt, a_lvl);
  l_src__str := dumpSource(Tpl.emptyTxt, a_src);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("assert("));
  out_txt := Tpl.writeText(out_txt, l_cond__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(", "));
  out_txt := Tpl.writeText(out_txt, l_msg__str);
  out_txt := Tpl.writeText(out_txt, l_lvl__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(")"));
  out_txt := Tpl.writeText(out_txt, l_src__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(";"));
end dumpAssert;

public function dumpTerminate
  input Tpl.Text txt;
  input DAE.Exp a_msg;
  input DAE.ElementSource a_src;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_src__str;
  Tpl.Text l_msg__str;
algorithm
  l_msg__str := dumpExp(Tpl.emptyTxt, a_msg);
  l_src__str := dumpSource(Tpl.emptyTxt, a_src);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("terminate("));
  out_txt := Tpl.writeText(out_txt, l_msg__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(")"));
  out_txt := Tpl.writeText(out_txt, l_src__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(";"));
end dumpTerminate;

public function dumpReinit
  input Tpl.Text txt;
  input DAE.ComponentRef a_cref;
  input DAE.Exp a_exp;
  input DAE.ElementSource a_src;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_src__str;
  Tpl.Text l_exp__str;
  Tpl.Text l_cref__str;
algorithm
  l_cref__str := dumpCref(Tpl.emptyTxt, a_cref);
  l_exp__str := dumpExp(Tpl.emptyTxt, a_exp);
  l_src__str := dumpSource(Tpl.emptyTxt, a_src);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("reinit("));
  out_txt := Tpl.writeText(out_txt, l_cref__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(", "));
  out_txt := Tpl.writeText(out_txt, l_exp__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(")"));
  out_txt := Tpl.writeText(out_txt, l_src__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(";"));
end dumpReinit;

public function dumpNoRetCall
  input Tpl.Text txt;
  input DAE.Exp a_call__exp;
  input DAE.ElementSource a_src;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_src__str;
  Tpl.Text l_call__str;
algorithm
  l_call__str := dumpExp(Tpl.emptyTxt, a_call__exp);
  l_src__str := dumpSource(Tpl.emptyTxt, a_src);
  out_txt := Tpl.writeText(txt, l_call__str);
  out_txt := Tpl.writeText(out_txt, l_src__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(";"));
end dumpNoRetCall;

protected function lm_149
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEquationElement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_149(txt, rest);
      then txt;
  end match;
end lm_149;

protected function fun_150
  input Tpl.Text in_txt;
  input Option<DAE.Element> in_a_elsewhen__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elsewhen__)
    local
      Tpl.Text txt;
      DAE.Element i_el;

    case ( txt,
           SOME(i_el) )
      equation
        txt = dumpWhenEquation(txt, i_el);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_150;

protected function fun_151
  input Tpl.Text in_txt;
  input Tpl.Text in_a_elsewhen__str;
  input Tpl.Text in_a_src__str;
  input Tpl.Text in_a_body__str;
  input Tpl.Text in_a_when__cond__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elsewhen__str, in_a_src__str, in_a_body__str, in_a_when__cond__str)
    local
      Tpl.Text txt;
      Tpl.Text a_src__str;
      Tpl.Text a_body__str;
      Tpl.Text a_when__cond__str;
      Tpl.Text i_elsewhen__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_src__str,
           a_body__str,
           a_when__cond__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, a_when__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when"));
        txt = Tpl.writeText(txt, a_src__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           i_elsewhen__str,
           _,
           a_body__str,
           a_when__cond__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, a_when__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else"));
        txt = Tpl.writeText(txt, i_elsewhen__str);
      then txt;
  end match;
end fun_151;

public function dumpWhenEquation
  input Tpl.Text in_txt;
  input DAE.Element in_a_lst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lst)
    local
      Tpl.Text txt;
      DAE.ElementSource i_source;
      Option<DAE.Element> i_elsewhen__;
      list<DAE.Element> i_equations;
      DAE.Exp i_condition;
      Tpl.Text l_src__str;
      Tpl.Text l_elsewhen__str;
      Tpl.Text l_body__str;
      Tpl.Text l_when__cond__str;

    case ( txt,
           DAE.WHEN_EQUATION(condition = i_condition, equations = i_equations, elsewhen_ = i_elsewhen__, source = i_source) )
      equation
        l_when__cond__str = dumpExp(Tpl.emptyTxt, i_condition);
        l_body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__str = lm_149(l_body__str, i_equations);
        l_body__str = Tpl.popIter(l_body__str);
        l_elsewhen__str = fun_150(Tpl.emptyTxt, i_elsewhen__);
        l_src__str = dumpSource(Tpl.emptyTxt, i_source);
        txt = fun_151(txt, l_elsewhen__str, l_src__str, l_body__str, l_when__cond__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpWhenEquation;

protected function lm_153
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEquationElement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_153(txt, rest);
      then txt;
  end match;
end lm_153;

protected function lm_154
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEquationElement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_154(txt, rest);
      then txt;
  end match;
end lm_154;

protected function fun_155
  input Tpl.Text in_txt;
  input list<DAE.Element> in_a_else__branch;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_else__branch)
    local
      Tpl.Text txt;
      list<DAE.Element> i_else__branch;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_else__branch )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_154(txt, i_else__branch);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_155;

protected function fun_156
  input Tpl.Text in_txt;
  input list<list<DAE.Element>> in_a_branches;
  input DAE.ElementSource in_a_src;
  input list<DAE.Element> in_a_else__branch;
  input list<DAE.Exp> in_a_elseif__conds;
  input DAE.Exp in_a_if__cond;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_branches, in_a_src, in_a_else__branch, in_a_elseif__conds, in_a_if__cond)
    local
      Tpl.Text txt;
      DAE.ElementSource a_src;
      list<DAE.Element> a_else__branch;
      list<DAE.Exp> a_elseif__conds;
      DAE.Exp a_if__cond;
      list<list<DAE.Element>> i_elseif__branches;
      list<DAE.Element> i_if__branch;
      Tpl.Text l_src__str;
      Tpl.Text l_else__str;
      Tpl.Text l_elseif__str;
      Tpl.Text l_if__branch__str;
      Tpl.Text l_if__cond__str;

    case ( txt,
           i_if__branch :: i_elseif__branches,
           a_src,
           a_else__branch,
           a_elseif__conds,
           a_if__cond )
      equation
        l_if__cond__str = dumpExp(Tpl.emptyTxt, a_if__cond);
        l_if__branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_if__branch__str = lm_153(l_if__branch__str, i_if__branch);
        l_if__branch__str = Tpl.popIter(l_if__branch__str);
        l_elseif__str = dumpElseIfEquation(Tpl.emptyTxt, a_elseif__conds, i_elseif__branches);
        l_else__str = fun_155(Tpl.emptyTxt, a_else__branch);
        l_src__str = dumpSource(Tpl.emptyTxt, a_src);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_if__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_if__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_elseif__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_else__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end if"));
        txt = Tpl.writeText(txt, l_src__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_156;

public function dumpIfEquation
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_conds;
  input list<list<DAE.Element>> in_a_branches;
  input list<DAE.Element> in_a_else__branch;
  input DAE.ElementSource in_a_src;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_conds, in_a_branches, in_a_else__branch, in_a_src)
    local
      Tpl.Text txt;
      list<list<DAE.Element>> a_branches;
      list<DAE.Element> a_else__branch;
      DAE.ElementSource a_src;
      list<DAE.Exp> i_elseif__conds;
      DAE.Exp i_if__cond;

    case ( txt,
           i_if__cond :: i_elseif__conds,
           a_branches,
           a_else__branch,
           a_src )
      equation
        txt = fun_156(txt, a_branches, a_src, a_else__branch, i_elseif__conds, i_if__cond);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpIfEquation;

protected function lm_158
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpEquationElement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_158(txt, rest);
      then txt;
  end match;
end lm_158;

protected function fun_159
  input Tpl.Text in_txt;
  input list<list<DAE.Element>> in_a_equations;
  input list<DAE.Exp> in_a_rest__conds;
  input DAE.Exp in_a_cond;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_equations, in_a_rest__conds, in_a_cond)
    local
      Tpl.Text txt;
      list<DAE.Exp> a_rest__conds;
      DAE.Exp a_cond;
      list<list<DAE.Element>> i_rest__branches;
      list<DAE.Element> i_branch;
      Tpl.Text l_rest__str;
      Tpl.Text l_branch__str;
      Tpl.Text l_cond__str;

    case ( txt,
           i_branch :: i_rest__branches,
           a_rest__conds,
           a_cond )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, a_cond);
        l_branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_branch__str = lm_158(l_branch__str, i_branch);
        l_branch__str = Tpl.popIter(l_branch__str);
        l_rest__str = dumpElseIfEquation(Tpl.emptyTxt, a_rest__conds, i_rest__branches);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elseif "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_rest__str);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_159;

public function dumpElseIfEquation
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_condition1;
  input list<list<DAE.Element>> in_a_equations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_condition1, in_a_equations)
    local
      Tpl.Text txt;
      list<list<DAE.Element>> a_equations;
      list<DAE.Exp> i_rest__conds;
      DAE.Exp i_cond;

    case ( txt,
           i_cond :: i_rest__conds,
           a_equations )
      equation
        txt = fun_159(txt, a_equations, i_rest__conds, i_cond);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpElseIfEquation;

protected function lm_161
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_alg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_alg :: rest )
      equation
        txt = dumpInitialAlgorithm(txt, i_alg);
        txt = Tpl.nextIter(txt);
        txt = lm_161(txt, rest);
      then txt;
  end match;
end lm_161;

public function dumpInitialAlgorithmSection
  input Tpl.Text txt;
  input list<DAE.Element> a_ia;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_161(out_txt, a_ia);
  out_txt := Tpl.popIter(out_txt);
end dumpInitialAlgorithmSection;

public function dumpInitialAlgorithm
  input Tpl.Text in_txt;
  input DAE.Element in_a_alg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_alg)
    local
      Tpl.Text txt;
      DAE.Algorithm i_algorithm__;

    case ( txt,
           DAE.INITIALALGORITHM(algorithm_ = i_algorithm__) )
      equation
        txt = dumpAlgorithm(txt, i_algorithm__, "initial algorithm");
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInitialAlgorithm;

protected function lm_164
  input Tpl.Text in_txt;
  input list<DAE.Element> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Element> rest;
      DAE.Element i_alg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_alg :: rest )
      equation
        txt = dumpAlgorithmElement(txt, i_alg);
        txt = Tpl.nextIter(txt);
        txt = lm_164(txt, rest);
      then txt;
  end match;
end lm_164;

public function dumpAlgorithmSection
  input Tpl.Text txt;
  input list<DAE.Element> a_a;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_164(out_txt, a_a);
  out_txt := Tpl.popIter(out_txt);
end dumpAlgorithmSection;

public function dumpAlgorithmElement
  input Tpl.Text in_txt;
  input DAE.Element in_a_alg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_alg)
    local
      Tpl.Text txt;
      DAE.Algorithm i_algorithm__;

    case ( txt,
           DAE.ALGORITHM(algorithm_ = i_algorithm__) )
      equation
        txt = dumpAlgorithm(txt, i_algorithm__, "algorithm");
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAlgorithmElement;

public function dumpAlgorithm
  input Tpl.Text in_txt;
  input DAE.Algorithm in_a_algorithm__;
  input String in_a_header;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_algorithm__, in_a_header)
    local
      Tpl.Text txt;
      String a_header;
      list<DAE.Statement> i_statementLst;

    case ( txt,
           DAE.ALGORITHM_STMTS(statementLst = i_statementLst),
           a_header )
      equation
        txt = Tpl.writeStr(txt, a_header);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpStatements(txt, i_statementLst);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpAlgorithm;

protected function lm_168
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_stmt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_stmt :: rest )
      equation
        txt = dumpStatement(txt, i_stmt);
        txt = Tpl.nextIter(txt);
        txt = lm_168(txt, rest);
      then txt;
  end match;
end lm_168;

public function dumpStatements
  input Tpl.Text txt;
  input list<DAE.Statement> a_stmts;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_168(out_txt, a_stmts);
  out_txt := Tpl.popIter(out_txt);
end dumpStatements;

public function dumpStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Exp i_level;
      DAE.Exp i_msg;
      DAE.Exp i_cond;
      DAE.Statement i_stmt;
      DAE.ElementSource i_source;
      DAE.Exp i_exp;
      DAE.Exp i_exp1;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = i_exp1, exp = i_exp, source = i_source) )
      equation
        txt = dumpAssignment(txt, i_exp1, i_exp, i_source);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_TUPLE_ASSIGN(expExpLst = _)) )
      equation
        txt = dumpTupleAssignStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_ASSIGN_ARR(componentRef = _)) )
      equation
        txt = dumpArrayAssignStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_IF(exp = _)) )
      equation
        txt = dumpIfStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_FOR(iterIsArray = _)) )
      equation
        txt = dumpForStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_WHILE(exp = _)) )
      equation
        txt = dumpWhileStatement(txt, i_stmt);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_WHEN(exp = _)) )
      equation
        txt = dumpWhenStatement(txt, i_stmt);
      then txt;

    case ( txt,
           DAE.STMT_ASSERT(cond = i_cond, msg = i_msg, level = i_level, source = i_source) )
      equation
        txt = dumpAssert(txt, i_cond, i_msg, i_level, i_source);
      then txt;

    case ( txt,
           DAE.STMT_TERMINATE(msg = i_msg, source = i_source) )
      equation
        txt = dumpTerminate(txt, i_msg, i_source);
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_REINIT(var = _)) )
      equation
        txt = dumpReinitStatement(txt, i_stmt);
      then txt;

    case ( txt,
           DAE.STMT_NORETCALL(exp = i_exp, source = i_source) )
      equation
        txt = dumpNoRetCall(txt, i_exp, i_source);
      then txt;

    case ( txt,
           DAE.STMT_RETURN(source = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return;"));
      then txt;

    case ( txt,
           DAE.STMT_BREAK(source = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break;"));
      then txt;

    case ( txt,
           DAE.STMT_CONTINUE(source = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("continue;"));
      then txt;

    case ( txt,
           DAE.STMT_FAILURE(body = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fail();"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "DAEDump.dumpStatement: Unknown statement.");
      then txt;
  end match;
end dumpStatement;

protected function fun_171
  input Tpl.Text in_txt;
  input DAE.Exp in_a_lhs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lhs)
    local
      Tpl.Text txt;
      DAE.Exp i_lhs;

    case ( txt,
           (i_lhs as DAE.IFEXP(expCond = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = dumpExp(txt, i_lhs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           i_lhs )
      equation
        txt = dumpExp(txt, i_lhs);
      then txt;
  end match;
end fun_171;

public function dumpAssignment
  input Tpl.Text txt;
  input DAE.Exp a_lhs;
  input DAE.Exp a_rhs;
  input DAE.ElementSource a_src;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_src__str;
  Tpl.Text l_rhs__str;
  Tpl.Text l_lhs__str;
algorithm
  l_lhs__str := fun_171(Tpl.emptyTxt, a_lhs);
  l_rhs__str := dumpExp(Tpl.emptyTxt, a_rhs);
  l_src__str := dumpSource(Tpl.emptyTxt, a_src);
  out_txt := Tpl.writeText(txt, l_lhs__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" := "));
  out_txt := Tpl.writeText(out_txt, l_rhs__str);
  out_txt := Tpl.writeText(out_txt, l_src__str);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(";"));
end dumpAssignment;

protected function lm_173
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpExp(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_173(txt, rest);
      then txt;
  end match;
end lm_173;

public function dumpTupleAssignStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.ElementSource i_source;
      DAE.Exp i_exp;
      list<DAE.Exp> i_expExpLst;
      Tpl.Text l_src__str;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           DAE.STMT_TUPLE_ASSIGN(expExpLst = i_expExpLst, exp = i_exp, source = i_source) )
      equation
        l_lhs__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_lhs__str = lm_173(l_lhs__str, i_expExpLst);
        l_lhs__str = Tpl.popIter(l_lhs__str);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_src__str = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") := "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeText(txt, l_src__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpTupleAssignStatement;

public function dumpArrayAssignStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.ElementSource i_source;
      DAE.Exp i_exp;
      DAE.ComponentRef i_componentRef;
      Tpl.Text l_src__str;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           DAE.STMT_ASSIGN_ARR(componentRef = i_componentRef, exp = i_exp, source = i_source) )
      equation
        l_lhs__str = dumpCref(Tpl.emptyTxt, i_componentRef);
        l_rhs__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_src__str = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" := "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeText(txt, l_src__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpArrayAssignStatement;

protected function lm_176
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpStatement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_176(txt, rest);
      then txt;
  end match;
end lm_176;

public function dumpIfStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.ElementSource i_source;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_src__str;
      Tpl.Text l_else__if__str;
      Tpl.Text l_true__branch__str;
      Tpl.Text l_if__cond__str;

    case ( txt,
           DAE.STMT_IF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__, source = i_source) )
      equation
        l_if__cond__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_true__branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_true__branch__str = lm_176(l_true__branch__str, i_statementLst);
        l_true__branch__str = Tpl.popIter(l_true__branch__str);
        l_else__if__str = dumpElseIfStatements(Tpl.emptyTxt, i_else__);
        l_src__str = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_if__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_true__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_else__if__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end if"));
        txt = Tpl.writeText(txt, l_src__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpIfStatement;

protected function lm_178
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpStatement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_178(txt, rest);
      then txt;
  end match;
end lm_178;

protected function lm_179
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpStatement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_179(txt, rest);
      then txt;
  end match;
end lm_179;

public function dumpElseIfStatements
  input Tpl.Text in_txt;
  input DAE.Else in_a_else__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_else__)
    local
      Tpl.Text txt;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_else__body__str;
      Tpl.Text l_else__str;
      Tpl.Text l_elseif__body__str;
      Tpl.Text l_elseif__cond__str;

    case ( txt,
           DAE.ELSEIF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__) )
      equation
        l_elseif__cond__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_elseif__body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_elseif__body__str = lm_178(l_elseif__body__str, i_statementLst);
        l_elseif__body__str = Tpl.popIter(l_elseif__body__str);
        l_else__str = dumpElseIfStatements(Tpl.emptyTxt, i_else__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elseif "));
        txt = Tpl.writeText(txt, l_elseif__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_elseif__body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_else__str);
      then txt;

    case ( txt,
           DAE.ELSE(statementLst = i_statementLst) )
      equation
        l_else__body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_else__body__str = lm_179(l_else__body__str, i_statementLst);
        l_else__body__str = Tpl.popIter(l_else__body__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_else__body__str);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpElseIfStatements;

protected function lm_181
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpStatement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_181(txt, rest);
      then txt;
  end match;
end lm_181;

public function dumpForStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.Ident i_iter;
      DAE.ElementSource i_source;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_range;
      Tpl.Text l_src__str;
      Tpl.Text l_alg__str;
      Tpl.Text l_range__str;

    case ( txt,
           DAE.STMT_FOR(range = i_range, statementLst = i_statementLst, source = i_source, iter = i_iter) )
      equation
        l_range__str = dumpExp(Tpl.emptyTxt, i_range);
        l_alg__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_alg__str = lm_181(l_alg__str, i_statementLst);
        l_alg__str = Tpl.popIter(l_alg__str);
        l_src__str = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for "));
        txt = Tpl.writeStr(txt, i_iter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" in "));
        txt = Tpl.writeText(txt, l_range__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" loop\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_alg__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for"));
        txt = Tpl.writeText(txt, l_src__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpForStatement;

protected function lm_183
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpStatement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_183(txt, rest);
      then txt;
  end match;
end lm_183;

public function dumpWhileStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.ElementSource i_source;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_src__str;
      Tpl.Text l_body__str;
      Tpl.Text l_while__cond;

    case ( txt,
           DAE.STMT_WHILE(exp = i_exp, statementLst = i_statementLst, source = i_source) )
      equation
        l_while__cond = dumpExp(Tpl.emptyTxt, i_exp);
        l_body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__str = lm_183(l_body__str, i_statementLst);
        l_body__str = Tpl.popIter(l_body__str);
        l_src__str = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("while "));
        txt = Tpl.writeText(txt, l_while__cond);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" loop\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end while"));
        txt = Tpl.writeText(txt, l_src__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpWhileStatement;

protected function lm_185
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = dumpStatement(txt, i_e);
        txt = Tpl.nextIter(txt);
        txt = lm_185(txt, rest);
      then txt;
  end match;
end lm_185;

protected function fun_186
  input Tpl.Text in_txt;
  input Option<DAE.Statement> in_a_elseWhen;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elseWhen)
    local
      Tpl.Text txt;
      DAE.Statement i_ew;

    case ( txt,
           SOME(i_ew) )
      equation
        txt = dumpWhenStatement(txt, i_ew);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_186;

protected function fun_187
  input Tpl.Text in_txt;
  input Tpl.Text in_a_elsewhen__str;
  input Tpl.Text in_a_src__str;
  input Tpl.Text in_a_body__str;
  input Tpl.Text in_a_when__cond__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elsewhen__str, in_a_src__str, in_a_body__str, in_a_when__cond__str)
    local
      Tpl.Text txt;
      Tpl.Text a_src__str;
      Tpl.Text a_body__str;
      Tpl.Text a_when__cond__str;
      Tpl.Text i_elsewhen__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_src__str,
           a_body__str,
           a_when__cond__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, a_when__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when"));
        txt = Tpl.writeText(txt, a_src__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           i_elsewhen__str,
           _,
           a_body__str,
           a_when__cond__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, a_when__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else"));
        txt = Tpl.writeText(txt, i_elsewhen__str);
      then txt;
  end match;
end fun_187;

public function dumpWhenStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.ElementSource i_source;
      Option<DAE.Statement> i_elseWhen;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_src__str;
      Tpl.Text l_elsewhen__str;
      Tpl.Text l_body__str;
      Tpl.Text l_when__cond__str;

    case ( txt,
           DAE.STMT_WHEN(exp = i_exp, statementLst = i_statementLst, elseWhen = i_elseWhen, source = i_source) )
      equation
        l_when__cond__str = dumpExp(Tpl.emptyTxt, i_exp);
        l_body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__str = lm_185(l_body__str, i_statementLst);
        l_body__str = Tpl.popIter(l_body__str);
        l_elsewhen__str = fun_186(Tpl.emptyTxt, i_elseWhen);
        l_src__str = dumpSource(Tpl.emptyTxt, i_source);
        txt = fun_187(txt, l_elsewhen__str, l_src__str, l_body__str, l_when__cond__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpWhenStatement;

public function dumpReinitStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt)
    local
      Tpl.Text txt;
      DAE.ElementSource i_source;
      DAE.Exp i_value;
      DAE.Exp i_var;
      Tpl.Text l_src__str;
      Tpl.Text l_new__exp__str;
      Tpl.Text l_exp__str;

    case ( txt,
           DAE.STMT_REINIT(var = i_var, value = i_value, source = i_source) )
      equation
        l_exp__str = dumpExp(Tpl.emptyTxt, i_var);
        l_new__exp__str = dumpExp(Tpl.emptyTxt, i_value);
        l_src__str = dumpSource(Tpl.emptyTxt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("reinit("));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_new__exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_src__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpReinitStatement;

public function dumpExp
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := ExpressionDumpTpl.dumpExp(txt, a_exp, "\"");
end dumpExp;

protected function fun_191
  input Tpl.Text in_txt;
  input Tpl.Text in_a_cmt__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cmt__str)
    local
      Tpl.Text txt;
      Tpl.Text i_cmt__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_cmt__str )
      equation
        txt = Tpl.writeText(txt, i_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_191;

public function dumpClassAnnotation
  input Tpl.Text txt;
  input Option<SCode.Comment> a_comment;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_cmt__str;
algorithm
  l_cmt__str := dumpCommentAnnotation(Tpl.emptyTxt, a_comment);
  out_txt := fun_191(txt, l_cmt__str);
end dumpClassAnnotation;

protected function fun_193
  input Tpl.Text in_txt;
  input Tpl.Text in_a_cmt__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cmt__str)
    local
      Tpl.Text txt;
      Tpl.Text i_cmt__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_cmt__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, i_cmt__str);
      then txt;
  end match;
end fun_193;

public function dumpCompAnnotation
  input Tpl.Text txt;
  input Option<SCode.Comment> a_comment;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_cmt__str;
algorithm
  l_cmt__str := dumpCommentAnnotation(Tpl.emptyTxt, a_comment);
  out_txt := fun_193(txt, l_cmt__str);
end dumpCompAnnotation;

protected function fun_195
  input Tpl.Text in_txt;
  input Option<SCode.Comment> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      SCode.Mod i_ann__mod;

    case ( txt,
           SOME(SCode.COMMENT(annotation_ = SOME(SCode.ANNOTATION(modification = i_ann__mod)))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("annotation"));
        txt = SCodeDumpTpl.dumpModifier(txt, i_ann__mod, SCodeDump.defaultOptions);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_195;

protected function fun_196
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Option<SCode.Comment> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_comment)
    local
      Tpl.Text txt;
      Option<SCode.Comment> a_comment;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_comment )
      equation
        txt = fun_195(txt, a_comment);
      then txt;
  end match;
end fun_196;

public function dumpCommentAnnotation
  input Tpl.Text txt;
  input Option<SCode.Comment> a_comment;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := Config.showAnnotations();
  out_txt := fun_196(txt, ret_0, a_comment);
end dumpCommentAnnotation;

public function dumpCommentOpt
  input Tpl.Text in_txt;
  input Option<SCode.Comment> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      SCode.Comment i_cmt;

    case ( txt,
           SOME(i_cmt) )
      equation
        txt = dumpComment(txt, i_cmt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpCommentOpt;

public function dumpComment
  input Tpl.Text in_txt;
  input SCode.Comment in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      Option<String> i_comment;

    case ( txt,
           SCode.COMMENT(comment = i_comment) )
      equation
        txt = dumpCommentStr(txt, i_comment);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpComment;

public function dumpCommentStr
  input Tpl.Text in_txt;
  input Option<String> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_cmt;
      String ret_0;

    case ( txt,
           SOME(i_cmt) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = System.escapedString(i_cmt, false);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpCommentStr;

public function dumpPathLastIndent
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_path)
    local
      Tpl.Text txt;
      Absyn.Ident i_name;
      Absyn.Path i_path;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = dumpPathLastIndent(txt, i_path);
      then txt;

    case ( txt,
           Absyn.QUALIFIED(path = i_path) )
      equation
        txt = dumpPathLastIndent(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "dumpPathLastIndent: Unknown path.");
      then txt;
  end match;
end dumpPathLastIndent;

protected function lm_202
  input Tpl.Text in_txt;
  input list<SCode.Comment> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Comment> rest;
      SCode.Comment i_c;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_c :: rest )
      equation
        txt = dumpComment(txt, i_c);
        txt = Tpl.nextIter(txt);
        txt = lm_202(txt, rest);
      then txt;
  end match;
end lm_202;

public function dumpSource
  input Tpl.Text in_txt;
  input DAE.ElementSource in_a_source;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_source)
    local
      Tpl.Text txt;
      list<SCode.Comment> i_comment;

    case ( txt,
           DAE.SOURCE(comment = i_comment) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" + ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_202(txt, i_comment);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpSource;

public function errorMsg
  input Tpl.Text txt;
  input String a_errMessage;

  output Tpl.Text out_txt;
algorithm
  Tpl.addTemplateError(a_errMessage);
  out_txt := Tpl.writeStr(txt, a_errMessage);
end errorMsg;

annotation(__OpenModelica_Interface="frontend");
end DAEDumpTpl;