encapsulated package ExpressionDumpTpl
"
  file:        ExpressionDumpTpl.mo
  package:     ExpressionDumpTpl
  description: Generated by Susan.
"

public import Tpl;

public import Absyn;
public import ClassInf;
public import DAE;
public import Dump;
public import Expression;
public import System;
public import Config;
public import Types;
protected import AbsynDumpTpl;
protected import DAEDumpTpl;

protected function fun_11
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;
  end match;
end fun_11;

protected function fun_12
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;
      String ret_0;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*"));
        ret_0 = Types.unparseType(a_ty);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/ "));
      then txt;
  end match;
end fun_12;

protected function fun_13
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Type in_a_attr_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_attr_ty)
    local
      Tpl.Text txt;
      DAE.Type a_attr_ty;
      String ret_0;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_attr_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*"));
        ret_0 = Types.unparseType(a_attr_ty);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/ "));
      then txt;
  end match;
end fun_13;

protected function fun_14
  input Tpl.Text in_txt;
  input Boolean in_a_scalar;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_scalar, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;
      String ret_1;
      String ret_0;

    case ( txt,
           false,
           a_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* non-scalar "));
        ret_0 = Types.unparseType(a_ty);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */ "));
      then txt;

    case ( txt,
           _,
           a_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* scalar "));
        ret_1 = Types.unparseType(a_ty);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;
  end match;
end fun_14;

protected function fun_15
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Type in_a_ty;
  input Boolean in_a_scalar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ty, in_a_scalar)
    local
      Tpl.Text txt;
      DAE.Type a_ty;
      Boolean a_scalar;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_ty,
           a_scalar )
      equation
        txt = fun_14(txt, a_scalar, a_ty);
      then txt;
  end match;
end fun_15;

protected function lm_16
  input Tpl.Text in_txt;
  input list<list<DAE.Exp>> in_items;
  input String in_a_stringDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_stringDelimiter)
    local
      Tpl.Text txt;
      list<list<DAE.Exp>> rest;
      String a_stringDelimiter;
      list<DAE.Exp> i_row;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_row :: rest,
           a_stringDelimiter )
      equation
        txt = dumpExpList(txt, i_row, a_stringDelimiter, ", ");
        txt = Tpl.nextIter(txt);
        txt = lm_16(txt, rest, a_stringDelimiter);
      then txt;
  end match;
end lm_16;

protected function fun_17
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;
      String ret_0;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* matrix "));
        ret_0 = Types.unparseType(a_ty);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */ "));
      then txt;
  end match;
end fun_17;

protected function fun_18
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_step;
  input DAE.Exp in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_step, in_a_e)
    local
      Tpl.Text txt;
      DAE.Exp a_e;
      DAE.Exp i_step;

    case ( txt,
           SOME(i_step),
           a_e )
      equation
        txt = dumpOperand(txt, i_step, a_e, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_18;

protected function fun_19
  input Tpl.Text in_txt;
  input Tpl.Text in_a_needs__paren;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_needs__paren)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
      then txt;
  end match;
end fun_19;

protected function fun_20
  input Tpl.Text in_txt;
  input Tpl.Text in_a_needs__paren;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_needs__paren)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_20;

protected function fun_21
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*ASUB*/"));
      then txt;
  end match;
end fun_21;

protected function fun_22
  input Tpl.Text in_txt;
  input Tpl.Text in_a_needs__paren;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_needs__paren)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
      then txt;
  end match;
end fun_22;

protected function fun_23
  input Tpl.Text in_txt;
  input Tpl.Text in_a_needs__paren;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_needs__paren)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_23;

protected function fun_24
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_sz;
  input String in_a_stringDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sz, in_a_stringDelimiter)
    local
      Tpl.Text txt;
      String a_stringDelimiter;
      DAE.Exp i_dim;

    case ( txt,
           SOME(i_dim),
           a_stringDelimiter )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = dumpExp(txt, i_dim, a_stringDelimiter);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_24;

protected function lm_25
  input Tpl.Text in_txt;
  input DAE.ReductionIterators in_items;
  input String in_a_stringDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_stringDelimiter)
    local
      Tpl.Text txt;
      DAE.ReductionIterators rest;
      String a_stringDelimiter;
      DAE.ReductionIterator i_it;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_it :: rest,
           a_stringDelimiter )
      equation
        txt = dumpReductionIterator(txt, i_it, a_stringDelimiter);
        txt = Tpl.nextIter(txt);
        txt = lm_25(txt, rest, a_stringDelimiter);
      then txt;
  end match;
end lm_25;

protected function fun_26
  input Tpl.Text in_txt;
  input Absyn.ReductionIterType in_a_ri_iterType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ri_iterType)
    local
      Tpl.Text txt;

    case ( txt,
           Absyn.THREAD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("threaded "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_26;

protected function lm_27
  input Tpl.Text in_txt;
  input list<DAE.MatchCase> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.MatchCase> rest;
      DAE.MatchCase i_c;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_c :: rest )
      equation
        txt = dumpMatchCase(txt, i_c);
        txt = Tpl.nextIter(txt);
        txt = lm_27(txt, rest);
      then txt;
  end match;
end lm_27;

protected function fun_28
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;
  input String in_a_stringDelimiter;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index, in_a_stringDelimiter, in_a_exp)
    local
      Tpl.Text txt;
      Integer a_index;
      String a_stringDelimiter;
      DAE.Exp a_exp;

    case ( txt,
           false,
           _,
           a_stringDelimiter,
           a_exp )
      equation
        txt = dumpExp(txt, a_exp, a_stringDelimiter);
      then txt;

    case ( txt,
           _,
           a_index,
           a_stringDelimiter,
           a_exp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* Shared literal "));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */ "));
        txt = dumpExp(txt, a_exp, a_stringDelimiter);
      then txt;
  end match;
end fun_28;

protected function fun_29
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*pattern*/"));
      then txt;
  end match;
end fun_29;

public function dumpExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input String in_a_stringDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp, in_a_stringDelimiter)
    local
      Tpl.Text txt;
      String a_stringDelimiter;
      DAE.Pattern i_pattern;
      list<DAE.MatchCase> i_cases;
      list<DAE.Exp> i_inputs;
      DAE.MatchType i_matchType;
      list<DAE.Exp> i_args;
      list<DAE.Exp> i_listExp;
      DAE.Exp i_cdr;
      DAE.Exp i_car;
      list<DAE.Exp> i_valList;
      Absyn.ReductionIterType i_ri_iterType;
      DAE.ReductionIterators i_iterators;
      DAE.Exp i_expr;
      Absyn.Path i_ri_path;
      String i_tyStr;
      String i_scope;
      DAE.ComponentRef i_name_1;
      Absyn.CodeNode i_code;
      Option<DAE.Exp> i_sz;
      Integer i_ix;
      list<DAE.Exp> i_sub;
      list<DAE.Exp> i_PR;
      DAE.Exp i_stop;
      Option<DAE.Exp> i_step;
      DAE.Exp i_start;
      list<list<DAE.Exp>> i_matrix;
      Boolean i_scalar;
      list<DAE.Exp> i_array;
      list<DAE.Exp> i_expList;
      list<DAE.Exp> i_exps;
      DAE.Type i_attr_ty;
      list<DAE.Exp> i_expLst;
      Absyn.Path i_path;
      DAE.Exp i_expElse;
      DAE.Exp i_expThen;
      DAE.Exp i_expCond;
      DAE.Exp i_exp;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_e;
      DAE.Exp i_exp1;
      DAE.ComponentRef i_componentRef;
      DAE.Type i_ty;
      Absyn.Path i_name;
      Integer i_index;
      DAE.ClockKind i_clk;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      Boolean ret_41;
      Boolean ret_40;
      Tpl.Text l_case__str;
      Tpl.Text l_inputs__str;
      Tpl.Text l_match__ty;
      Tpl.Text l_args__str;
      Tpl.Text l_cdr__str;
      Tpl.Text l_car__str;
      Tpl.Text l_expl__str;
      Tpl.Text l_iter__str;
      Tpl.Text l_name__str;
      String ret_30;
      Tpl.Text l_code__str;
      Tpl.Text l_dim__str;
      Boolean ret_27;
      Tpl.Text l_sub__str;
      Tpl.Text l_rparen;
      Tpl.Text l_lparen;
      Tpl.Text l_needs__paren;
      Tpl.Text l_ty__str;
      Tpl.Text l_tuple__str;
      Tpl.Text l_stop__str;
      Tpl.Text l_step__str;
      Tpl.Text l_start__str;
      Boolean ret_17;
      Tpl.Text l_mat__str;
      Boolean ret_15;
      Tpl.Text l_expl;
      Boolean ret_13;
      Tpl.Text l_argl;
      Tpl.Text l_func__str;
      Tpl.Text l_else__str;
      Tpl.Text l_then__str;
      Tpl.Text l_cond__str;
      Tpl.Text l_exp__str;
      Tpl.Text l_op__str;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;
      Boolean ret_3;
      Boolean ret_2;
      String ret_1;
      Tpl.Text l_str;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _ )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real),
           _ )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string),
           a_stringDelimiter )
      equation
        ret_1 = System.escapedString(i_string, false);
        l_str = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        txt = Tpl.writeStr(txt, a_stringDelimiter);
        txt = Tpl.writeText(txt, l_str);
        txt = Tpl.writeStr(txt, a_stringDelimiter);
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool),
           _ )
      equation
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_bool));
      then txt;

    case ( txt,
           DAE.CLKCONST(clk = i_clk),
           a_stringDelimiter )
      equation
        txt = dumpClockKind(txt, i_clk, a_stringDelimiter);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index, name = i_name),
           _ )
      equation
        ret_2 = Config.typeinfo();
        txt = fun_11(txt, ret_2, i_index);
        txt = AbsynDumpTpl.dumpPath(txt, i_name);
      then txt;

    case ( txt,
           DAE.CREF(ty = i_ty, componentRef = i_componentRef),
           _ )
      equation
        ret_3 = Config.typeinfo();
        txt = fun_12(txt, ret_3, i_ty);
        txt = dumpCref(txt, i_componentRef);
      then txt;

    case ( txt,
           (i_e as DAE.BINARY(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator)),
           _ )
      equation
        l_lhs__str = dumpOperand(Tpl.emptyTxt, i_exp1, i_e, true);
        l_rhs__str = dumpOperand(Tpl.emptyTxt, i_exp2, i_e, false);
        l_op__str = dumpBinOp(Tpl.emptyTxt, i_operator);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_op__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_rhs__str);
      then txt;

    case ( txt,
           (i_e as DAE.UNARY(exp = i_exp, operator = i_operator)),
           _ )
      equation
        l_exp__str = dumpOperand(Tpl.emptyTxt, i_exp, i_e, false);
        l_op__str = dumpUnaryOp(Tpl.emptyTxt, i_operator);
        txt = Tpl.writeText(txt, l_op__str);
        txt = Tpl.writeText(txt, l_exp__str);
      then txt;

    case ( txt,
           (i_e as DAE.LBINARY(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator)),
           _ )
      equation
        l_lhs__str = dumpOperand(Tpl.emptyTxt, i_exp1, i_e, true);
        l_rhs__str = dumpOperand(Tpl.emptyTxt, i_exp2, i_e, false);
        l_op__str = dumpLogicalBinOp(Tpl.emptyTxt, i_operator);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_op__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_rhs__str);
      then txt;

    case ( txt,
           (i_e as DAE.LUNARY(exp = i_exp, operator = i_operator)),
           _ )
      equation
        l_exp__str = dumpOperand(Tpl.emptyTxt, i_exp, i_e, false);
        l_op__str = dumpLogicalUnaryOp(Tpl.emptyTxt, i_operator);
        txt = Tpl.writeText(txt, l_op__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_exp__str);
      then txt;

    case ( txt,
           (i_e as DAE.RELATION(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator)),
           _ )
      equation
        l_lhs__str = dumpOperand(Tpl.emptyTxt, i_exp1, i_e, true);
        l_rhs__str = dumpOperand(Tpl.emptyTxt, i_exp2, i_e, false);
        l_op__str = dumpRelationOp(Tpl.emptyTxt, i_operator);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_op__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_rhs__str);
      then txt;

    case ( txt,
           DAE.IFEXP(expCond = i_expCond, expThen = i_expThen, expElse = i_expElse),
           a_stringDelimiter )
      equation
        l_cond__str = dumpExp(Tpl.emptyTxt, i_expCond, a_stringDelimiter);
        l_then__str = dumpExp(Tpl.emptyTxt, i_expThen, a_stringDelimiter);
        l_else__str = dumpExp(Tpl.emptyTxt, i_expElse, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then "));
        txt = Tpl.writeText(txt, l_then__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" else "));
        txt = Tpl.writeText(txt, l_else__str);
      then txt;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(builtin = true, ty = i_attr_ty), path = i_path, expLst = i_expLst),
           a_stringDelimiter )
      equation
        l_func__str = AbsynDumpTpl.dumpPathNoQual(Tpl.emptyTxt, i_path);
        l_argl = dumpExpList(Tpl.emptyTxt, i_expLst, a_stringDelimiter, ", ");
        ret_13 = Config.typeinfo();
        txt = fun_13(txt, ret_13, i_attr_ty);
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_argl);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CALL(path = i_path, expLst = i_expLst),
           a_stringDelimiter )
      equation
        l_func__str = AbsynDumpTpl.dumpPathNoQual(Tpl.emptyTxt, i_path);
        l_argl = dumpExpList(Tpl.emptyTxt, i_expLst, a_stringDelimiter, ", ");
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_argl);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.RECORD(path = i_path, exps = i_exps),
           a_stringDelimiter )
      equation
        l_func__str = AbsynDumpTpl.dumpPathNoQual(Tpl.emptyTxt, i_path);
        l_argl = dumpExpList(Tpl.emptyTxt, i_exps, a_stringDelimiter, ", ");
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_argl);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.PARTEVALFUNCTION(path = i_path, expList = i_expList),
           a_stringDelimiter )
      equation
        l_func__str = AbsynDumpTpl.dumpPathNoQual(Tpl.emptyTxt, i_path);
        l_argl = dumpExpList(Tpl.emptyTxt, i_expList, a_stringDelimiter, ", ");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function "));
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_argl);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.ARRAY(array = i_array, scalar = i_scalar, ty = i_ty),
           a_stringDelimiter )
      equation
        l_expl = dumpExpList(Tpl.emptyTxt, i_array, a_stringDelimiter, ", ");
        ret_15 = Config.typeinfo();
        txt = fun_15(txt, ret_15, i_ty, i_scalar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, l_expl);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           DAE.MATRIX(matrix = i_matrix, ty = i_ty),
           a_stringDelimiter )
      equation
        l_mat__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("}, {")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_mat__str = lm_16(l_mat__str, i_matrix, a_stringDelimiter);
        l_mat__str = Tpl.popIter(l_mat__str);
        ret_17 = Config.typeinfo();
        txt = fun_17(txt, ret_17, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{{"));
        txt = Tpl.writeText(txt, l_mat__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}}"));
      then txt;

    case ( txt,
           (i_e as DAE.RANGE(start = i_start, step = i_step, stop = i_stop)),
           _ )
      equation
        l_start__str = dumpOperand(Tpl.emptyTxt, i_start, i_e, false);
        l_step__str = fun_18(Tpl.emptyTxt, i_step, i_e);
        l_stop__str = dumpOperand(Tpl.emptyTxt, i_stop, i_e, false);
        txt = Tpl.writeText(txt, l_start__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        txt = Tpl.writeText(txt, l_step__str);
        txt = Tpl.writeText(txt, l_stop__str);
      then txt;

    case ( txt,
           DAE.TUPLE(PR = i_PR),
           a_stringDelimiter )
      equation
        l_tuple__str = dumpExpList(Tpl.emptyTxt, i_PR, a_stringDelimiter, ", ");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_tuple__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CAST(exp = i_exp, ty = i_ty),
           a_stringDelimiter )
      equation
        l_exp__str = dumpExp(Tpl.emptyTxt, i_exp, a_stringDelimiter);
        l_ty__str = dumpType(Tpl.emptyTxt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*"));
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/("));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.ASUB(exp = i_exp, sub = i_sub),
           a_stringDelimiter )
      equation
        l_needs__paren = parenthesizeSubExp(Tpl.emptyTxt, i_exp);
        l_lparen = fun_19(Tpl.emptyTxt, l_needs__paren);
        l_rparen = fun_20(Tpl.emptyTxt, l_needs__paren);
        l_exp__str = dumpExp(Tpl.emptyTxt, i_exp, a_stringDelimiter);
        l_sub__str = dumpExpList(Tpl.emptyTxt, i_sub, a_stringDelimiter, ", ");
        txt = Tpl.writeText(txt, l_lparen);
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeText(txt, l_rparen);
        ret_27 = Config.typeinfo();
        txt = fun_21(txt, ret_27);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.TSUB(exp = i_exp, ix = i_ix),
           a_stringDelimiter )
      equation
        l_needs__paren = parenthesizeSubExp(Tpl.emptyTxt, i_exp);
        l_lparen = fun_22(Tpl.emptyTxt, l_needs__paren);
        l_rparen = fun_23(Tpl.emptyTxt, l_needs__paren);
        l_exp__str = dumpExp(Tpl.emptyTxt, i_exp, a_stringDelimiter);
        txt = Tpl.writeText(txt, l_lparen);
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeText(txt, l_rparen);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_ix));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.SIZE(exp = i_exp, sz = i_sz),
           a_stringDelimiter )
      equation
        l_exp__str = dumpExp(Tpl.emptyTxt, i_exp, a_stringDelimiter);
        l_dim__str = fun_24(Tpl.emptyTxt, i_sz, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size("));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeText(txt, l_dim__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CODE(code = i_code),
           _ )
      equation
        ret_30 = Dump.printCodeStr(i_code);
        l_code__str = Tpl.writeStr(Tpl.emptyTxt, ret_30);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$Code("));
        txt = Tpl.writeText(txt, l_code__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EMPTY(name = i_name_1, scope = i_scope, tyStr = i_tyStr),
           _ )
      equation
        l_name__str = dumpCref(Tpl.emptyTxt, i_name_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<EMPTY(scope: "));
        txt = Tpl.writeStr(txt, i_scope);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", name: "));
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", ty: "));
        txt = Tpl.writeStr(txt, i_tyStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")>"));
      then txt;

    case ( txt,
           DAE.REDUCTION(reductionInfo = DAE.REDUCTIONINFO(path = i_ri_path, iterType = i_ri_iterType), expr = i_expr, iterators = i_iterators),
           a_stringDelimiter )
      equation
        l_name__str = AbsynDumpTpl.dumpPathNoQual(Tpl.emptyTxt, i_ri_path);
        l_exp__str = dumpExp(Tpl.emptyTxt, i_expr, a_stringDelimiter);
        l_iter__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_iter__str = lm_25(l_iter__str, i_iterators, a_stringDelimiter);
        l_iter__str = Tpl.popIter(l_iter__str);
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" for "));
        txt = fun_26(txt, i_ri_iterType);
        txt = Tpl.writeText(txt, l_iter__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LIST(valList = i_valList),
           a_stringDelimiter )
      equation
        l_expl__str = dumpExpList(Tpl.emptyTxt, i_valList, a_stringDelimiter, ", ");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("List("));
        txt = Tpl.writeText(txt, l_expl__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CONS(car = i_car, cdr = i_cdr),
           a_stringDelimiter )
      equation
        l_car__str = dumpExp(Tpl.emptyTxt, i_car, a_stringDelimiter);
        l_cdr__str = dumpExp(Tpl.emptyTxt, i_cdr, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("listCons("));
        txt = Tpl.writeText(txt, l_car__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_cdr__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.META_TUPLE(listExp = i_listExp),
           a_stringDelimiter )
      equation
        l_tuple__str = dumpExpList(Tpl.emptyTxt, i_listExp, a_stringDelimiter, ", ");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Tuple("));
        txt = Tpl.writeText(txt, l_tuple__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.META_OPTION(exp = SOME(i_exp)),
           a_stringDelimiter )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SOME("));
        txt = dumpExp(txt, i_exp, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.META_OPTION(exp = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NONE()"));
      then txt;

    case ( txt,
           DAE.METARECORDCALL(path = i_path, args = i_args),
           a_stringDelimiter )
      equation
        l_name__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_path);
        l_args__str = dumpExpList(Tpl.emptyTxt, i_args, a_stringDelimiter, ", ");
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.MATCHEXPRESSION(matchType = i_matchType, inputs = i_inputs, cases = i_cases),
           a_stringDelimiter )
      equation
        l_match__ty = dumpMatchType(Tpl.emptyTxt, i_matchType);
        l_inputs__str = dumpExpList(Tpl.emptyTxt, i_inputs, a_stringDelimiter, ", ");
        l_case__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_case__str = lm_27(l_case__str, i_cases);
        l_case__str = Tpl.popIter(l_case__str);
        txt = Tpl.writeText(txt, l_match__ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ("));
        txt = Tpl.writeText(txt, l_inputs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_case__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeText(txt, l_match__ty);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           DAE.BOX(exp = i_exp),
           a_stringDelimiter )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#("));
        txt = dumpExp(txt, i_exp, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.UNBOX(exp = i_exp),
           a_stringDelimiter )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unbox("));
        txt = dumpExp(txt, i_exp, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.SHARED_LITERAL(exp = i_exp, index = i_index),
           a_stringDelimiter )
      equation
        ret_40 = Config.typeinfo();
        txt = fun_28(txt, ret_40, i_index, a_stringDelimiter, i_exp);
      then txt;

    case ( txt,
           DAE.PATTERN(pattern = i_pattern),
           _ )
      equation
        ret_41 = Config.typeinfo();
        txt = fun_29(txt, ret_41);
        txt = dumpPattern(txt, i_pattern);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = errorMsg(txt, "ExpressionDumpTpl.dumpExp: Unknown expression.");
      then txt;
  end match;
end dumpExp;

public function parenthesizeSubExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ICONST(integer = _) )
      then txt;

    case ( txt,
           DAE.RCONST(real = _) )
      then txt;

    case ( txt,
           DAE.SCONST(string = _) )
      then txt;

    case ( txt,
           DAE.BCONST(bool = _) )
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(name = _) )
      then txt;

    case ( txt,
           DAE.CREF(componentRef = _) )
      then txt;

    case ( txt,
           DAE.CALL(path = _) )
      then txt;

    case ( txt,
           DAE.ARRAY(ty = _) )
      then txt;

    case ( txt,
           DAE.MATRIX(ty = _) )
      then txt;

    case ( txt,
           DAE.TUPLE(PR = _) )
      then txt;

    case ( txt,
           DAE.CAST(ty = _) )
      then txt;

    case ( txt,
           DAE.SIZE(exp = _) )
      then txt;

    case ( txt,
           DAE.REDUCTION(reductionInfo = _) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("y"));
      then txt;
  end match;
end parenthesizeSubExp;

protected function lm_32
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input String in_a_stringDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_stringDelimiter)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      String a_stringDelimiter;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_exp :: rest,
           a_stringDelimiter )
      equation
        txt = dumpExp(txt, i_exp, a_stringDelimiter);
        txt = Tpl.nextIter(txt);
        txt = lm_32(txt, rest, a_stringDelimiter);
      then txt;
  end match;
end lm_32;

public function dumpExpList
  input Tpl.Text txt;
  input list<DAE.Exp> a_expl;
  input String a_stringDelimiter;
  input String a_expDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(a_expDelimiter)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_32(out_txt, a_expl, a_stringDelimiter);
  out_txt := Tpl.popIter(out_txt);
end dumpExpList;

protected function lm_34
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input String in_a_stringDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_stringDelimiter)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      String a_stringDelimiter;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_exp :: rest,
           a_stringDelimiter )
      equation
        txt = dumpExpCrefs(txt, i_exp, a_stringDelimiter);
        txt = Tpl.nextIter(txt);
        txt = lm_34(txt, rest, a_stringDelimiter);
      then txt;
  end match;
end lm_34;

public function dumpExpListCrefs
  input Tpl.Text txt;
  input list<DAE.Exp> a_expl;
  input String a_stringDelimiter;
  input String a_expDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(a_expDelimiter)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_34(out_txt, a_expl, a_stringDelimiter);
  out_txt := Tpl.popIter(out_txt);
end dumpExpListCrefs;

public function dumpClockKind
  input Tpl.Text in_txt;
  input DAE.ClockKind in_a_clk;
  input String in_a_stringDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_clk, in_a_stringDelimiter)
    local
      Tpl.Text txt;
      String a_stringDelimiter;
      String i_solverMethod;
      DAE.ClockKind i_c;
      Real i_startInterval;
      DAE.Exp i_condition;
      DAE.Exp i_interval;
      Integer i_resolution;
      DAE.Exp i_intervalCounter;
      Tpl.Text l_clk__str;
      Tpl.Text l_condition__str;
      Tpl.Text l_interval__str;
      Tpl.Text l_ic__str;

    case ( txt,
           DAE.INFERRED_CLOCK(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Clock()"));
      then txt;

    case ( txt,
           DAE.INTEGER_CLOCK(intervalCounter = i_intervalCounter, resolution = i_resolution),
           a_stringDelimiter )
      equation
        l_ic__str = dumpExp(Tpl.emptyTxt, i_intervalCounter, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Clock("));
        txt = Tpl.writeText(txt, l_ic__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_resolution));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.REAL_CLOCK(interval = i_interval),
           a_stringDelimiter )
      equation
        l_interval__str = dumpExp(Tpl.emptyTxt, i_interval, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Clock("));
        txt = Tpl.writeText(txt, l_interval__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.BOOLEAN_CLOCK(condition = i_condition, startInterval = i_startInterval),
           a_stringDelimiter )
      equation
        l_condition__str = dumpExp(Tpl.emptyTxt, i_condition, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Clock("));
        txt = Tpl.writeText(txt, l_condition__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, realString(i_startInterval));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.SOLVER_CLOCK(c = i_c, solverMethod = i_solverMethod),
           a_stringDelimiter )
      equation
        l_clk__str = dumpClockKind(Tpl.emptyTxt, i_c, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Clock("));
        txt = Tpl.writeText(txt, l_clk__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, i_solverMethod);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpClockKind;

public function dumpCref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cref;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cref)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      Integer i_index;
      DAE.Ident i_ident;
      list<DAE.Subscript> i_subscriptLst;
      Tpl.Text l_cref__str;
      Tpl.Text l_sub__str;

    case ( txt,
           DAE.CREF_IDENT(subscriptLst = i_subscriptLst, ident = i_ident) )
      equation
        l_sub__str = dumpSubscripts(Tpl.emptyTxt, i_subscriptLst);
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeText(txt, l_sub__str);
      then txt;

    case ( txt,
           DAE.CREF_ITER(subscriptLst = i_subscriptLst, ident = i_ident, index = i_index) )
      equation
        l_sub__str = dumpSubscripts(Tpl.emptyTxt, i_subscriptLst);
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeText(txt, l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* iter index "));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(subscriptLst = i_subscriptLst, componentRef = i_componentRef, ident = i_ident) )
      equation
        l_sub__str = dumpSubscripts(Tpl.emptyTxt, i_subscriptLst);
        l_cref__str = dumpCref(Tpl.emptyTxt, i_componentRef);
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeText(txt, l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, l_cref__str);
      then txt;

    case ( txt,
           DAE.WILD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "ExpressionDumpTpl.dumpCref: unknown cref");
      then txt;
  end match;
end dumpCref;

protected function lm_38
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_sub;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_sub :: rest )
      equation
        txt = dumpSubscript(txt, i_sub);
        txt = Tpl.nextIter(txt);
        txt = lm_38(txt, rest);
      then txt;
  end match;
end lm_38;

public function dumpSubscripts
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;
      Tpl.Text l_sub__str;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        l_sub__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_sub__str = lm_38(l_sub__str, i_subscripts);
        l_sub__str = Tpl.popIter(l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end dumpSubscripts;

public function dumpSubscript
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           DAE.SLICE(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp, "\"");
      then txt;

    case ( txt,
           DAE.INDEX(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp, "\"");
      then txt;

    case ( txt,
           DAE.WHOLE_NONEXP(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp, "\"");
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpSubscript;

public function dumpReductionIterator
  input Tpl.Text in_txt;
  input DAE.ReductionIterator in_a_iterator;
  input String in_a_stringDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iterator, in_a_stringDelimiter)
    local
      Tpl.Text txt;
      String a_stringDelimiter;
      DAE.Exp i_gexp;
      String i_id;
      DAE.Exp i_exp;
      Tpl.Text l_guard__str;
      Tpl.Text l_exp__str;

    case ( txt,
           DAE.REDUCTIONITER(guardExp = NONE(), exp = i_exp, id = i_id),
           a_stringDelimiter )
      equation
        l_exp__str = dumpExp(Tpl.emptyTxt, i_exp, a_stringDelimiter);
        txt = Tpl.writeStr(txt, i_id);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" in "));
        txt = Tpl.writeText(txt, l_exp__str);
      then txt;

    case ( txt,
           DAE.REDUCTIONITER(guardExp = SOME(i_gexp), exp = i_exp, id = i_id),
           a_stringDelimiter )
      equation
        l_exp__str = dumpExp(Tpl.emptyTxt, i_exp, a_stringDelimiter);
        l_guard__str = dumpExp(Tpl.emptyTxt, i_gexp, a_stringDelimiter);
        txt = Tpl.writeStr(txt, i_id);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" guard "));
        txt = Tpl.writeText(txt, l_guard__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" in "));
        txt = Tpl.writeText(txt, l_exp__str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpReductionIterator;

protected function fun_42
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_op__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_op__str)
    local
      Tpl.Text txt;
      Tpl.Text a_op__str;

    case ( txt,
           false,
           a_op__str )
      equation
        txt = Tpl.writeText(txt, a_op__str);
      then txt;

    case ( txt,
           _,
           a_op__str )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_op__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_42;

public function dumpOperand
  input Tpl.Text txt;
  input DAE.Exp a_operand;
  input DAE.Exp a_operation;
  input Boolean a_lhs;

  output Tpl.Text out_txt;
protected
  Boolean ret_1;
  Tpl.Text l_op__str;
algorithm
  l_op__str := dumpExp(Tpl.emptyTxt, a_operand, "\"");
  ret_1 := Expression.shouldParenthesize(a_operand, a_operation, a_lhs);
  out_txt := fun_42(txt, ret_1, l_op__str);
end dumpOperand;

protected function fun_44
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_op)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ADD(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
      then txt;

    case ( txt,
           DAE.SUB(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
      then txt;

    case ( txt,
           DAE.MUL(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           DAE.DIV(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
      then txt;

    case ( txt,
           DAE.POW(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("^"));
      then txt;

    case ( txt,
           DAE.ADD_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
      then txt;

    case ( txt,
           DAE.SUB_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
      then txt;

    case ( txt,
           DAE.MUL_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".*"));
      then txt;

    case ( txt,
           DAE.DIV_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("./"));
      then txt;

    case ( txt,
           DAE.POW_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("^"));
      then txt;

    case ( txt,
           DAE.POW_ARR2(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".^"));
      then txt;

    case ( txt,
           DAE.MUL_ARRAY_SCALAR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           DAE.ADD_ARRAY_SCALAR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".+"));
      then txt;

    case ( txt,
           DAE.SUB_SCALAR_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".-"));
      then txt;

    case ( txt,
           DAE.POW_SCALAR_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".^"));
      then txt;

    case ( txt,
           DAE.POW_ARRAY_SCALAR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".^"));
      then txt;

    case ( txt,
           DAE.MUL_SCALAR_PRODUCT(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           DAE.MUL_MATRIX_PRODUCT(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           DAE.DIV_SCALAR_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("./"));
      then txt;

    case ( txt,
           DAE.DIV_ARRAY_SCALAR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "ExpressionDumpTpl.dumpBinOp: Unknown operator.");
      then txt;
  end match;
end fun_44;

protected function fun_45
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_op)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ADD(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
      then txt;

    case ( txt,
           DAE.SUB(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
      then txt;

    case ( txt,
           DAE.MUL(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           DAE.DIV(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
      then txt;

    case ( txt,
           DAE.POW(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("^"));
      then txt;

    case ( txt,
           DAE.ADD_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+ /* ADD_ARR */"));
      then txt;

    case ( txt,
           DAE.SUB_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("- /* SUB_ARR */"));
      then txt;

    case ( txt,
           DAE.MUL_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".* /* MUL_ARR */"));
      then txt;

    case ( txt,
           DAE.DIV_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("./ /* DIV_ARR */"));
      then txt;

    case ( txt,
           DAE.POW_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("^ /* POW_ARR */"));
      then txt;

    case ( txt,
           DAE.POW_ARR2(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".^ /* POW_ARR2 */"));
      then txt;

    case ( txt,
           DAE.MUL_ARRAY_SCALAR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* /* MUL_ARR_SCA */"));
      then txt;

    case ( txt,
           DAE.ADD_ARRAY_SCALAR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".+ /* ADD_ARR_SCA */"));
      then txt;

    case ( txt,
           DAE.SUB_SCALAR_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".- /* SUB_SCA_ARR */"));
      then txt;

    case ( txt,
           DAE.POW_SCALAR_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".^ /* POW_SCA_ARR */"));
      then txt;

    case ( txt,
           DAE.POW_ARRAY_SCALAR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".^ /* POW_ARR_SCA */"));
      then txt;

    case ( txt,
           DAE.MUL_SCALAR_PRODUCT(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* /* MUL_SCA_PRO */"));
      then txt;

    case ( txt,
           DAE.MUL_MATRIX_PRODUCT(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* /* MUL_MAT_PRO */"));
      then txt;

    case ( txt,
           DAE.DIV_SCALAR_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/ /* DIV_SCA_ARR */"));
      then txt;

    case ( txt,
           DAE.DIV_ARRAY_SCALAR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/ /* DIV_ARR_SCA */"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "ExpressionDumpTpl.dumpBinOp: Unknown operator.");
      then txt;
  end match;
end fun_45;

protected function fun_46
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Operator in_a_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_op)
    local
      Tpl.Text txt;
      DAE.Operator a_op;

    case ( txt,
           false,
           a_op )
      equation
        txt = fun_44(txt, a_op);
      then txt;

    case ( txt,
           _,
           a_op )
      equation
        txt = fun_45(txt, a_op);
      then txt;
  end match;
end fun_46;

public function dumpBinOp
  input Tpl.Text txt;
  input DAE.Operator a_op;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := Config.typeinfo();
  out_txt := fun_46(txt, ret_0, a_op);
end dumpBinOp;

public function dumpUnaryOp
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_op)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.UMINUS(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
      then txt;

    case ( txt,
           DAE.UMINUS_ARR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
      then txt;

    case ( txt,
           DAE.ADD(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "ExpressionDumpTpl.dumpUnaryOp: Unknown operator.");
      then txt;
  end match;
end dumpUnaryOp;

public function dumpLogicalBinOp
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_op)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.AND(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("and"));
      then txt;

    case ( txt,
           DAE.OR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("or"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "ExpressionDumpTpl.dumpLogicalBinOp: Unknown operator.");
      then txt;
  end match;
end dumpLogicalBinOp;

public function dumpLogicalUnaryOp
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_op)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.NOT(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("not"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "ExpressionDumpTpl.dumpLogicalUnaryOp: Unknown operator.");
      then txt;
  end match;
end dumpLogicalUnaryOp;

public function dumpRelationOp
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_op)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.LESS(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<="));
      then txt;

    case ( txt,
           DAE.GREATER(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">="));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=="));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<>"));
      then txt;

    case ( txt,
           DAE.USERDEFINED(fqName = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("USERDEFINED"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "ExpressionDumpTpl.dumpRelationOp: Unknown operator.");
      then txt;
  end match;
end dumpRelationOp;

protected function lm_52
  input Tpl.Text in_txt;
  input list<DAE.FuncArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.FuncArg> rest;
      DAE.FuncArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = dumpFuncArg(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest);
      then txt;
  end match;
end lm_52;

protected function lm_53
  input Tpl.Text in_txt;
  input list<DAE.Type> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Type> rest;
      DAE.Type i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ty :: rest )
      equation
        txt = dumpType(txt, i_ty);
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest);
      then txt;
  end match;
end lm_53;

protected function lm_54
  input Tpl.Text in_txt;
  input list<DAE.Type> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Type> rest;
      DAE.Type i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ty :: rest )
      equation
        txt = dumpType(txt, i_ty);
        txt = Tpl.nextIter(txt);
        txt = lm_54(txt, rest);
      then txt;
  end match;
end lm_54;

public function dumpType
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      String i_name;
      Absyn.Path i_p;
      DAE.Type i_optionType;
      list<DAE.Type> i_types;
      DAE.Type i_listType;
      list<DAE.Type> i_tupleType;
      DAE.Type i_functionType;
      DAE.Type i_funcResultType;
      list<DAE.FuncArg> i_funcArg;
      ClassInf.State i_complexClassType;
      DAE.Type i_ty;
      DAE.Dimensions i_dims;
      Absyn.Path i_path;
      Tpl.Text l_ret__str;
      Tpl.Text l_arg__str;
      Tpl.Text l_ty__str;
      Tpl.Text l_dim__str;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Integer"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Bool"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("String"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(path = i_path) )
      equation
        txt = AbsynDumpTpl.dumpPath(txt, i_path);
      then txt;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims, ty = i_ty) )
      equation
        l_dim__str = dumpDimensions(Tpl.emptyTxt, i_dims);
        l_ty__str = dumpType(Tpl.emptyTxt, i_ty);
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_dim__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_complexClassType) )
      equation
        txt = dumpClassState(txt, i_complexClassType);
      then txt;

    case ( txt,
           DAE.T_SUBTYPE_BASIC(complexClassType = i_complexClassType) )
      equation
        txt = dumpClassState(txt, i_complexClassType);
      then txt;

    case ( txt,
           DAE.T_FUNCTION(funcArg = i_funcArg, funcResultType = i_funcResultType) )
      equation
        l_arg__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_arg__str = lm_52(l_arg__str, i_funcArg);
        l_arg__str = Tpl.popIter(l_arg__str);
        l_ret__str = dumpType(Tpl.emptyTxt, i_funcResultType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function>("));
        txt = Tpl.writeText(txt, l_arg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") => "));
        txt = Tpl.writeText(txt, l_ret__str);
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = i_functionType) )
      equation
        txt = dumpType(txt, i_functionType);
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_FUNC(functionType = i_functionType) )
      equation
        txt = dumpType(txt, i_functionType);
      then txt;

    case ( txt,
           DAE.T_TUPLE(tupleType = i_tupleType) )
      equation
        l_ty__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_ty__str = lm_53(l_ty__str, i_tupleType);
        l_ty__str = Tpl.popIter(l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_ty__str);
      then txt;

    case ( txt,
           DAE.T_CODE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#T_CODE#"));
      then txt;

    case ( txt,
           DAE.T_METALIST(listType = i_listType) )
      equation
        l_ty__str = dumpType(Tpl.emptyTxt, i_listType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("list<"));
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           DAE.T_METATUPLE(types = i_types) )
      equation
        l_ty__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_ty__str = lm_54(l_ty__str, i_types);
        l_ty__str = Tpl.popIter(l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("tuple<"));
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           DAE.T_METAOPTION(optionType = i_optionType) )
      equation
        l_ty__str = dumpType(Tpl.emptyTxt, i_optionType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Option<"));
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           DAE.T_METAUNIONTYPE(source = {i_p}) )
      equation
        txt = AbsynDumpTpl.dumpPath(txt, i_p);
      then txt;

    case ( txt,
           DAE.T_METARECORD(source = {i_p}) )
      equation
        txt = AbsynDumpTpl.dumpPath(txt, i_p);
      then txt;

    case ( txt,
           DAE.T_METAARRAY(ty = i_ty) )
      equation
        l_ty__str = dumpType(Tpl.emptyTxt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("array<"));
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = i_ty) )
      equation
        txt = dumpType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.T_METAPOLYMORPHIC(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("polymorphic<"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">"));
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = i_ty) )
      equation
        txt = dumpType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.T_UNKNOWN(source = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#T_UNKNOWN#"));
      then txt;

    case ( txt,
           DAE.T_ANYTYPE(anyClassType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Any"));
      then txt;

    case ( txt,
           DAE.T_NORETCALL(source = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#T_NORETCALL#"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpType;

public function dumpFuncArg
  input Tpl.Text in_txt;
  input DAE.FuncArg in_a_arg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arg)
    local
      Tpl.Text txt;
      String i_arg_name;

    case ( txt,
           DAE.FUNCARG(name = i_arg_name) )
      equation
        txt = Tpl.writeStr(txt, i_arg_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFuncArg;

protected function lm_57
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dumpDimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_57(txt, rest);
      then txt;
  end match;
end lm_57;

public function dumpDimensions
  input Tpl.Text txt;
  input DAE.Dimensions a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_57(out_txt, a_dims);
  out_txt := Tpl.popIter(out_txt);
end dumpDimensions;

public function dumpDimension
  input Tpl.Text in_txt;
  input DAE.Dimension in_a_dim;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dim)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Absyn.Path i_enumTypeName;
      Integer i_integer;

    case ( txt,
           DAE.DIM_INTEGER(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.DIM_ENUM(enumTypeName = i_enumTypeName) )
      equation
        txt = AbsynDumpTpl.dumpPath(txt, i_enumTypeName);
      then txt;

    case ( txt,
           DAE.DIM_EXP(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp, "\"");
      then txt;

    case ( txt,
           DAE.DIM_UNKNOWN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpDimension;

public function dumpClassState
  input Tpl.Text txt;
  input ClassInf.State a_state;

  output Tpl.Text out_txt;
protected
  Absyn.Path ret_0;
algorithm
  ret_0 := ClassInf.getStateName(a_state);
  out_txt := AbsynDumpTpl.dumpPath(txt, ret_0);
end dumpClassState;

public function dumpMatchType
  input Tpl.Text in_txt;
  input DAE.MatchType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.MATCHCONTINUE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("matchcontinue"));
      then txt;

    case ( txt,
           DAE.MATCH(switch = NONE()) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("match"));
      then txt;

    case ( txt,
           DAE.MATCH(switch = SOME(_)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("match /* switch */"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpMatchType;

public function dumpMatchCase
  input Tpl.Text in_txt;
  input DAE.MatchCase in_a_mcase;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_mcase)
    local
      Tpl.Text txt;
      list<DAE.Statement> i_body;
      DAE.Exp i_result;
      list<DAE.Pattern> i_patterns;
      Tpl.Text l_body__str;
      Tpl.Text l_res__str;
      Tpl.Text l_pat__str;

    case ( txt,
           DAE.CASE(body = {}, result = SOME(i_result), patterns = i_patterns) )
      equation
        l_pat__str = dumpPatterns(Tpl.emptyTxt, i_patterns);
        l_res__str = dumpExp(Tpl.emptyTxt, i_result, "\"");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case ("));
        txt = Tpl.writeText(txt, l_pat__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") then "));
        txt = Tpl.writeText(txt, l_res__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.CASE(body = {}, result = NONE(), patterns = i_patterns) )
      equation
        l_pat__str = dumpPatterns(Tpl.emptyTxt, i_patterns);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case ("));
        txt = Tpl.writeText(txt, l_pat__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") then fail();"));
      then txt;

    case ( txt,
           DAE.CASE(result = SOME(i_result), patterns = i_patterns, body = i_body) )
      equation
        l_pat__str = dumpPatterns(Tpl.emptyTxt, i_patterns);
        l_res__str = dumpExp(Tpl.emptyTxt, i_result, "\"");
        l_body__str = DAEDumpTpl.dumpStatements(Tpl.emptyTxt, i_body);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case ("));
        txt = Tpl.writeText(txt, l_pat__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "  algorithm\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_res__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           DAE.CASE(patterns = i_patterns, body = i_body) )
      equation
        l_pat__str = dumpPatterns(Tpl.emptyTxt, i_patterns);
        l_body__str = DAEDumpTpl.dumpStatements(Tpl.emptyTxt, i_body);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case ("));
        txt = Tpl.writeText(txt, l_pat__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "  algorithm\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  then\n",
                                    "    fail();"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpMatchCase;

protected function lm_63
  input Tpl.Text in_txt;
  input list<DAE.Pattern> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Pattern> rest;
      DAE.Pattern i_pat;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_pat :: rest )
      equation
        txt = dumpPattern(txt, i_pat);
        txt = Tpl.nextIter(txt);
        txt = lm_63(txt, rest);
      then txt;
  end match;
end lm_63;

public function dumpPatterns
  input Tpl.Text txt;
  input list<DAE.Pattern> a_patterns;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_63(out_txt, a_patterns);
  out_txt := Tpl.popIter(out_txt);
end dumpPatterns;

protected function lm_65
  input Tpl.Text in_txt;
  input list<tuple<DAE.Pattern, String, DAE.Type>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<DAE.Pattern, String, DAE.Type>> rest;
      tuple<DAE.Pattern, String, DAE.Type> i_pat;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_pat :: rest )
      equation
        txt = dumpNamedPattern(txt, i_pat);
        txt = Tpl.nextIter(txt);
        txt = lm_65(txt, rest);
      then txt;
  end match;
end lm_65;

public function dumpPattern
  input Tpl.Text in_txt;
  input DAE.Pattern in_a_pattern;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_pattern)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.Pattern i_tail;
      DAE.Pattern i_head;
      list<tuple<DAE.Pattern, String, DAE.Type>> i_patterns_1;
      Absyn.Path i_name;
      list<DAE.Pattern> i_patterns;
      DAE.Pattern i_pat;
      String i_id;
      Tpl.Text l_pat__str;
      Tpl.Text l_name__str;

    case ( txt,
           DAE.PAT_WILD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           DAE.PAT_AS(pat = DAE.PAT_WILD(), id = i_id) )
      equation
        txt = Tpl.writeStr(txt, i_id);
      then txt;

    case ( txt,
           DAE.PAT_AS_FUNC_PTR(pat = DAE.PAT_WILD(), id = i_id) )
      equation
        txt = Tpl.writeStr(txt, i_id);
      then txt;

    case ( txt,
           DAE.PAT_SOME(pat = i_pat) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SOME("));
        txt = dumpPattern(txt, i_pat);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.PAT_META_TUPLE(patterns = i_patterns) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = dumpPatterns(txt, i_patterns);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.PAT_CALL_TUPLE(patterns = i_patterns) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = dumpPatterns(txt, i_patterns);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.PAT_CALL(name = i_name, patterns = i_patterns) )
      equation
        l_name__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_name);
        l_pat__str = dumpPatterns(Tpl.emptyTxt, i_patterns);
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_pat__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.PAT_CALL_NAMED(name = i_name, patterns = i_patterns_1) )
      equation
        l_name__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_name);
        l_pat__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_pat__str = lm_65(l_pat__str, i_patterns_1);
        l_pat__str = Tpl.popIter(l_pat__str);
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_pat__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.PAT_CONS(head = i_head, tail = i_tail) )
      equation
        txt = dumpPattern(txt, i_head);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::"));
        txt = dumpPattern(txt, i_tail);
      then txt;

    case ( txt,
           DAE.PAT_CONSTANT(exp = i_exp) )
      equation
        txt = dumpExp(txt, i_exp, "\"");
      then txt;

    case ( txt,
           DAE.PAT_AS(id = i_id, pat = i_pat) )
      equation
        txt = Tpl.writeStr(txt, i_id);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" as "));
        txt = dumpPattern(txt, i_pat);
      then txt;

    case ( txt,
           DAE.PAT_AS_FUNC_PTR(id = i_id, pat = i_pat) )
      equation
        txt = Tpl.writeStr(txt, i_id);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" as "));
        txt = dumpPattern(txt, i_pat);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*PATTERN*"));
      then txt;
  end match;
end dumpPattern;

public function dumpNamedPattern
  input Tpl.Text in_txt;
  input tuple<DAE.Pattern, String, DAE.Type> in_a_pattern;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_pattern)
    local
      Tpl.Text txt;
      DAE.Pattern i_pat;
      String i_id;

    case ( txt,
           (i_pat, i_id, _) )
      equation
        txt = Tpl.writeStr(txt, i_id);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = dumpPattern(txt, i_pat);
      then txt;
  end match;
end dumpNamedPattern;

protected function fun_68
  input Tpl.Text in_txt;
  input Boolean in_a_scalar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_scalar)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* non-scalar */ "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* scalar */ "));
      then txt;
  end match;
end fun_68;

protected function fun_69
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Boolean in_a_scalar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_scalar)
    local
      Tpl.Text txt;
      Boolean a_scalar;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_scalar )
      equation
        txt = fun_68(txt, a_scalar);
      then txt;
  end match;
end fun_69;

protected function lm_70
  input Tpl.Text in_txt;
  input list<list<DAE.Exp>> in_items;
  input String in_a_stringDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_stringDelimiter)
    local
      Tpl.Text txt;
      list<list<DAE.Exp>> rest;
      String a_stringDelimiter;
      list<DAE.Exp> i_row;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_row :: rest,
           a_stringDelimiter )
      equation
        txt = dumpExpList(txt, i_row, a_stringDelimiter, ", ");
        txt = Tpl.nextIter(txt);
        txt = lm_70(txt, rest, a_stringDelimiter);
      then txt;
  end match;
end lm_70;

protected function fun_71
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;
      String ret_0;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* matrix "));
        ret_0 = Types.unparseType(a_ty);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */ "));
      then txt;
  end match;
end fun_71;

protected function fun_72
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_step;
  input DAE.Exp in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_step, in_a_e)
    local
      Tpl.Text txt;
      DAE.Exp a_e;
      DAE.Exp i_step;

    case ( txt,
           SOME(i_step),
           a_e )
      equation
        txt = dumpOperand(txt, i_step, a_e, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_72;

protected function fun_73
  input Tpl.Text in_txt;
  input Tpl.Text in_a_needs__paren;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_needs__paren)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
      then txt;
  end match;
end fun_73;

protected function fun_74
  input Tpl.Text in_txt;
  input Tpl.Text in_a_needs__paren;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_needs__paren)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_74;

protected function fun_75
  input Tpl.Text in_txt;
  input Tpl.Text in_a_needs__paren;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_needs__paren)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
      then txt;
  end match;
end fun_75;

protected function fun_76
  input Tpl.Text in_txt;
  input Tpl.Text in_a_needs__paren;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_needs__paren)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_76;

protected function fun_77
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_sz;
  input String in_a_stringDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sz, in_a_stringDelimiter)
    local
      Tpl.Text txt;
      String a_stringDelimiter;
      DAE.Exp i_dim;

    case ( txt,
           SOME(i_dim),
           a_stringDelimiter )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = dumpExp(txt, i_dim, a_stringDelimiter);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_77;

protected function lm_78
  input Tpl.Text in_txt;
  input DAE.ReductionIterators in_items;
  input String in_a_stringDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_stringDelimiter)
    local
      Tpl.Text txt;
      DAE.ReductionIterators rest;
      String a_stringDelimiter;
      DAE.ReductionIterator i_it;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_it :: rest,
           a_stringDelimiter )
      equation
        txt = dumpReductionIterator(txt, i_it, a_stringDelimiter);
        txt = Tpl.nextIter(txt);
        txt = lm_78(txt, rest, a_stringDelimiter);
      then txt;
  end match;
end lm_78;

protected function fun_79
  input Tpl.Text in_txt;
  input Absyn.ReductionIterType in_a_ri_iterType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ri_iterType)
    local
      Tpl.Text txt;

    case ( txt,
           Absyn.THREAD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("threaded "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_79;

protected function lm_80
  input Tpl.Text in_txt;
  input list<DAE.MatchCase> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.MatchCase> rest;
      DAE.MatchCase i_c;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_c :: rest )
      equation
        txt = dumpMatchCase(txt, i_c);
        txt = Tpl.nextIter(txt);
        txt = lm_80(txt, rest);
      then txt;
  end match;
end lm_80;

public function dumpExpCrefs
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input String in_a_stringDelimiter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp, in_a_stringDelimiter)
    local
      Tpl.Text txt;
      String a_stringDelimiter;
      DAE.Pattern i_pattern;
      list<DAE.MatchCase> i_cases;
      list<DAE.Exp> i_inputs;
      DAE.MatchType i_matchType;
      list<DAE.Exp> i_args;
      list<DAE.Exp> i_listExp;
      DAE.Exp i_cdr;
      DAE.Exp i_car;
      list<DAE.Exp> i_valList;
      Absyn.ReductionIterType i_ri_iterType;
      DAE.ReductionIterators i_iterators;
      DAE.Exp i_expr;
      String i_tyStr;
      String i_scope;
      DAE.ComponentRef i_name_1;
      Absyn.CodeNode i_code;
      Option<DAE.Exp> i_sz;
      Integer i_ix;
      list<DAE.Exp> i_sub;
      list<DAE.Exp> i_PR;
      DAE.Exp i_stop;
      Option<DAE.Exp> i_step;
      DAE.Exp i_start;
      DAE.Type i_ty;
      list<list<DAE.Exp>> i_matrix;
      Boolean i_scalar;
      list<DAE.Exp> i_array;
      list<DAE.Exp> i_expList;
      Absyn.Path i_path;
      list<DAE.Exp> i_expLst;
      DAE.Exp i_expElse;
      DAE.Exp i_expThen;
      DAE.Exp i_expCond;
      DAE.Operator i_operator;
      DAE.Exp i_e;
      DAE.Exp i_exp;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      DAE.ComponentRef i_componentRef;
      Absyn.Path i_name;
      Tpl.Text l_case__str;
      Tpl.Text l_inputs__str;
      Tpl.Text l_match__ty;
      Tpl.Text l_args__str;
      Tpl.Text l_cdr__str;
      Tpl.Text l_car__str;
      Tpl.Text l_expl__str;
      Tpl.Text l_iter__str;
      Tpl.Text l_name__str;
      String ret_23;
      Tpl.Text l_code__str;
      Tpl.Text l_dim__str;
      Tpl.Text l_sub__str;
      Tpl.Text l_rparen;
      Tpl.Text l_lparen;
      Tpl.Text l_needs__paren;
      Tpl.Text l_tuple__str;
      Tpl.Text l_stop__str;
      Tpl.Text l_step__str;
      Tpl.Text l_start__str;
      Boolean ret_12;
      Tpl.Text l_mat__str;
      Boolean ret_10;
      Tpl.Text l_expl;
      Tpl.Text l_func__str;
      Tpl.Text l_argl;
      Tpl.Text l_else__str;
      Tpl.Text l_then__str;
      Tpl.Text l_cond__str;
      Tpl.Text l_op__str;
      Tpl.Text l_exp__str;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           DAE.ICONST(integer = _),
           _ )
      then txt;

    case ( txt,
           DAE.RCONST(real = _),
           _ )
      then txt;

    case ( txt,
           DAE.SCONST(string = _),
           _ )
      then txt;

    case ( txt,
           DAE.BCONST(bool = _),
           _ )
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(name = i_name),
           _ )
      equation
        txt = AbsynDumpTpl.dumpPath(txt, i_name);
      then txt;

    case ( txt,
           DAE.CREF(componentRef = i_componentRef),
           _ )
      equation
        txt = dumpCref(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.BINARY(exp1 = i_exp1, exp2 = i_exp2),
           a_stringDelimiter )
      equation
        l_lhs__str = dumpExpCrefs(Tpl.emptyTxt, i_exp1, a_stringDelimiter);
        l_rhs__str = dumpExpCrefs(Tpl.emptyTxt, i_exp2, a_stringDelimiter);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_rhs__str);
      then txt;

    case ( txt,
           (i_e as DAE.UNARY(exp = i_exp, operator = i_operator)),
           _ )
      equation
        l_exp__str = dumpOperand(Tpl.emptyTxt, i_exp, i_e, false);
        l_op__str = dumpUnaryOp(Tpl.emptyTxt, i_operator);
        txt = Tpl.writeText(txt, l_op__str);
        txt = Tpl.writeText(txt, l_exp__str);
      then txt;

    case ( txt,
           DAE.LBINARY(exp1 = i_exp1, exp2 = i_exp2),
           a_stringDelimiter )
      equation
        l_lhs__str = dumpExpCrefs(Tpl.emptyTxt, i_exp1, a_stringDelimiter);
        l_rhs__str = dumpExpCrefs(Tpl.emptyTxt, i_exp2, a_stringDelimiter);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_rhs__str);
      then txt;

    case ( txt,
           DAE.LUNARY(exp = i_exp),
           a_stringDelimiter )
      equation
        l_lhs__str = dumpExpCrefs(Tpl.emptyTxt, i_exp, a_stringDelimiter);
        txt = Tpl.writeText(txt, l_lhs__str);
      then txt;

    case ( txt,
           DAE.RELATION(exp1 = i_exp1, exp2 = i_exp2),
           a_stringDelimiter )
      equation
        l_lhs__str = dumpExpCrefs(Tpl.emptyTxt, i_exp1, a_stringDelimiter);
        l_rhs__str = dumpExpCrefs(Tpl.emptyTxt, i_exp2, a_stringDelimiter);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_rhs__str);
      then txt;

    case ( txt,
           DAE.IFEXP(expCond = i_expCond, expThen = i_expThen, expElse = i_expElse),
           a_stringDelimiter )
      equation
        l_cond__str = dumpExpCrefs(Tpl.emptyTxt, i_expCond, a_stringDelimiter);
        l_then__str = dumpExpCrefs(Tpl.emptyTxt, i_expThen, a_stringDelimiter);
        l_else__str = dumpExpCrefs(Tpl.emptyTxt, i_expElse, a_stringDelimiter);
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_then__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_else__str);
      then txt;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(builtin = true), expLst = i_expLst),
           a_stringDelimiter )
      equation
        l_argl = dumpExpListCrefs(Tpl.emptyTxt, i_expLst, a_stringDelimiter, " ");
        txt = Tpl.writeText(txt, l_argl);
      then txt;

    case ( txt,
           DAE.CALL(expLst = i_expLst),
           a_stringDelimiter )
      equation
        l_argl = dumpExpListCrefs(Tpl.emptyTxt, i_expLst, a_stringDelimiter, " ");
        txt = Tpl.writeText(txt, l_argl);
      then txt;

    case ( txt,
           DAE.PARTEVALFUNCTION(path = i_path, expList = i_expList),
           a_stringDelimiter )
      equation
        l_func__str = AbsynDumpTpl.dumpPathNoQual(Tpl.emptyTxt, i_path);
        l_argl = dumpExpList(Tpl.emptyTxt, i_expList, a_stringDelimiter, ", ");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function "));
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_argl);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.ARRAY(array = i_array, scalar = i_scalar),
           a_stringDelimiter )
      equation
        l_expl = dumpExpList(Tpl.emptyTxt, i_array, a_stringDelimiter, ", ");
        ret_10 = Config.typeinfo();
        txt = fun_69(txt, ret_10, i_scalar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, l_expl);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           DAE.MATRIX(matrix = i_matrix, ty = i_ty),
           a_stringDelimiter )
      equation
        l_mat__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("}, {")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_mat__str = lm_70(l_mat__str, i_matrix, a_stringDelimiter);
        l_mat__str = Tpl.popIter(l_mat__str);
        ret_12 = Config.typeinfo();
        txt = fun_71(txt, ret_12, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{{"));
        txt = Tpl.writeText(txt, l_mat__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}}"));
      then txt;

    case ( txt,
           (i_e as DAE.RANGE(start = i_start, step = i_step, stop = i_stop)),
           _ )
      equation
        l_start__str = dumpOperand(Tpl.emptyTxt, i_start, i_e, false);
        l_step__str = fun_72(Tpl.emptyTxt, i_step, i_e);
        l_stop__str = dumpOperand(Tpl.emptyTxt, i_stop, i_e, false);
        txt = Tpl.writeText(txt, l_start__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        txt = Tpl.writeText(txt, l_step__str);
        txt = Tpl.writeText(txt, l_stop__str);
      then txt;

    case ( txt,
           DAE.TUPLE(PR = {}),
           _ )
      then txt;

    case ( txt,
           DAE.TUPLE(PR = i_PR),
           a_stringDelimiter )
      equation
        l_tuple__str = dumpExpList(Tpl.emptyTxt, i_PR, a_stringDelimiter, ", ");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_tuple__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CAST(exp = i_exp),
           a_stringDelimiter )
      equation
        l_exp__str = dumpExpCrefs(Tpl.emptyTxt, i_exp, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.ASUB(exp = i_exp, sub = i_sub),
           a_stringDelimiter )
      equation
        l_needs__paren = parenthesizeSubExp(Tpl.emptyTxt, i_exp);
        l_lparen = fun_73(Tpl.emptyTxt, l_needs__paren);
        l_rparen = fun_74(Tpl.emptyTxt, l_needs__paren);
        l_exp__str = dumpExp(Tpl.emptyTxt, i_exp, a_stringDelimiter);
        l_sub__str = dumpExpList(Tpl.emptyTxt, i_sub, a_stringDelimiter, ", ");
        txt = Tpl.writeText(txt, l_lparen);
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeText(txt, l_rparen);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_sub__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.TSUB(exp = i_exp, ix = i_ix),
           a_stringDelimiter )
      equation
        l_needs__paren = parenthesizeSubExp(Tpl.emptyTxt, i_exp);
        l_lparen = fun_75(Tpl.emptyTxt, l_needs__paren);
        l_rparen = fun_76(Tpl.emptyTxt, l_needs__paren);
        l_exp__str = dumpExp(Tpl.emptyTxt, i_exp, a_stringDelimiter);
        txt = Tpl.writeText(txt, l_lparen);
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeText(txt, l_rparen);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_ix));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           DAE.SIZE(exp = i_exp, sz = i_sz),
           a_stringDelimiter )
      equation
        l_exp__str = dumpExp(Tpl.emptyTxt, i_exp, a_stringDelimiter);
        l_dim__str = fun_77(Tpl.emptyTxt, i_sz, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size("));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeText(txt, l_dim__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CODE(code = i_code),
           _ )
      equation
        ret_23 = Dump.printCodeStr(i_code);
        l_code__str = Tpl.writeStr(Tpl.emptyTxt, ret_23);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$Code("));
        txt = Tpl.writeText(txt, l_code__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EMPTY(name = i_name_1, scope = i_scope, tyStr = i_tyStr),
           _ )
      equation
        l_name__str = dumpCref(Tpl.emptyTxt, i_name_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<EMPTY(scope: "));
        txt = Tpl.writeStr(txt, i_scope);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", name: "));
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", ty: "));
        txt = Tpl.writeStr(txt, i_tyStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")>"));
      then txt;

    case ( txt,
           DAE.REDUCTION(reductionInfo = DAE.REDUCTIONINFO(path = i_name, iterType = i_ri_iterType), expr = i_expr, iterators = i_iterators),
           a_stringDelimiter )
      equation
        l_name__str = AbsynDumpTpl.dumpPathNoQual(Tpl.emptyTxt, i_name);
        l_exp__str = dumpExp(Tpl.emptyTxt, i_expr, a_stringDelimiter);
        l_iter__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_iter__str = lm_78(l_iter__str, i_iterators, a_stringDelimiter);
        l_iter__str = Tpl.popIter(l_iter__str);
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" for "));
        txt = fun_79(txt, i_ri_iterType);
        txt = Tpl.writeText(txt, l_iter__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LIST(valList = i_valList),
           a_stringDelimiter )
      equation
        l_expl__str = dumpExpList(Tpl.emptyTxt, i_valList, a_stringDelimiter, ", ");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("List("));
        txt = Tpl.writeText(txt, l_expl__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CONS(car = i_car, cdr = i_cdr),
           a_stringDelimiter )
      equation
        l_car__str = dumpExp(Tpl.emptyTxt, i_car, a_stringDelimiter);
        l_cdr__str = dumpExp(Tpl.emptyTxt, i_cdr, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("listCons("));
        txt = Tpl.writeText(txt, l_car__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_cdr__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.META_TUPLE(listExp = i_listExp),
           a_stringDelimiter )
      equation
        l_tuple__str = dumpExpList(Tpl.emptyTxt, i_listExp, a_stringDelimiter, ", ");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Tuple("));
        txt = Tpl.writeText(txt, l_tuple__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.META_OPTION(exp = SOME(i_exp)),
           a_stringDelimiter )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SOME("));
        txt = dumpExp(txt, i_exp, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.META_OPTION(exp = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NONE()"));
      then txt;

    case ( txt,
           DAE.METARECORDCALL(path = i_path, args = i_args),
           a_stringDelimiter )
      equation
        l_name__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_path);
        l_args__str = dumpExpList(Tpl.emptyTxt, i_args, a_stringDelimiter, ", ");
        txt = Tpl.writeText(txt, l_name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.MATCHEXPRESSION(matchType = i_matchType, inputs = i_inputs, cases = i_cases),
           a_stringDelimiter )
      equation
        l_match__ty = dumpMatchType(Tpl.emptyTxt, i_matchType);
        l_inputs__str = dumpExpList(Tpl.emptyTxt, i_inputs, a_stringDelimiter, ", ");
        l_case__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_case__str = lm_80(l_case__str, i_cases);
        l_case__str = Tpl.popIter(l_case__str);
        txt = Tpl.writeText(txt, l_match__ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ("));
        txt = Tpl.writeText(txt, l_inputs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_case__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeText(txt, l_match__ty);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           DAE.BOX(exp = i_exp),
           a_stringDelimiter )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#("));
        txt = dumpExp(txt, i_exp, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.UNBOX(exp = i_exp),
           a_stringDelimiter )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unbox("));
        txt = dumpExp(txt, i_exp, a_stringDelimiter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.SHARED_LITERAL(exp = i_exp),
           a_stringDelimiter )
      equation
        txt = dumpExpCrefs(txt, i_exp, a_stringDelimiter);
      then txt;

    case ( txt,
           DAE.PATTERN(pattern = i_pattern),
           _ )
      equation
        txt = dumpPattern(txt, i_pattern);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = errorMsg(txt, "ExpressionDumpTpl.dumpExp: Unknown expression.");
      then txt;
  end match;
end dumpExpCrefs;

public function errorMsg
  input Tpl.Text txt;
  input String a_errMessage;

  output Tpl.Text out_txt;
algorithm
  Tpl.addTemplateError(a_errMessage);
  out_txt := Tpl.writeStr(txt, a_errMessage);
end errorMsg;

annotation(__OpenModelica_Interface="frontend");
end ExpressionDumpTpl;