encapsulated package GraphMLDumpTpl
"
  file:        GraphMLDumpTpl.mo
  package:     GraphMLDumpTpl
  description: Generated by Susan.
"

public import Tpl;

public import Util;
public import GraphML;

public function dumpGraphInfo
  input Tpl.Text txt;
  input GraphML.GraphInfo a_graphInfo;
  input String a_fileName;

  output Tpl.Text out_txt;
protected
  Tpl.Text txt_0;
algorithm
  txt_0 := dumpGraphInfoInternal(Tpl.emptyTxt, a_graphInfo);
  Tpl.textFile(txt_0, a_fileName);
  out_txt := txt;
end dumpGraphInfo;

protected function lm_5
  input Tpl.Text in_txt;
  input list<GraphML.Attribute> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<GraphML.Attribute> rest;
      GraphML.Attribute i_att;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_att :: rest )
      equation
        txt = dumpAttDef(txt, i_att);
        txt = Tpl.nextIter(txt);
        txt = lm_5(txt, rest);
      then txt;
  end match;
end lm_5;

protected function lm_6
  input Tpl.Text in_txt;
  input list<GraphML.Edge> in_items;
  input array<GraphML.Attribute> in_a_attributes;
  input String in_a_graphInfo_graphEdgeKey;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_attributes, in_a_graphInfo_graphEdgeKey)
    local
      Tpl.Text txt;
      list<GraphML.Edge> rest;
      array<GraphML.Attribute> a_attributes;
      String a_graphInfo_graphEdgeKey;
      GraphML.Edge i_edge;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_edge :: rest,
           a_attributes,
           a_graphInfo_graphEdgeKey )
      equation
        txt = dumpEdge(txt, i_edge, a_graphInfo_graphEdgeKey, a_attributes);
        txt = Tpl.nextIter(txt);
        txt = lm_6(txt, rest, a_attributes, a_graphInfo_graphEdgeKey);
      then txt;
  end match;
end lm_6;

public function dumpGraphInfoInternal
  input Tpl.Text in_txt;
  input GraphML.GraphInfo in_a_graphInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_graphInfo)
    local
      Tpl.Text txt;
      array<GraphML.Node> i_nodes;
      array<GraphML.Graph> i_graphs;
      String i_graphEdgeKey;
      String i_graphNodeKey;
      String i_graphInfo_graphEdgeKey;
      list<GraphML.Edge> i_edges;
      array<GraphML.Attribute> i_attributes;
      GraphML.Graph ret_5;
      Integer ret_4;
      Integer ret_3;
      Tpl.Text l_edgeDump;
      list<GraphML.Attribute> ret_1;
      Tpl.Text l_attDefDump;

    case ( txt,
           GraphML.GRAPHINFOARR(attributes = i_attributes, edges = i_edges, graphEdgeKey = (i_graphEdgeKey as i_graphInfo_graphEdgeKey), graphNodeKey = i_graphNodeKey, graphs = i_graphs, nodes = i_nodes) )
      equation
        ret_1 = arrayList(i_attributes);
        l_attDefDump = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attDefDump = lm_5(l_attDefDump, ret_1);
        l_attDefDump = Tpl.popIter(l_attDefDump);
        l_edgeDump = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_edgeDump = lm_6(l_edgeDump, i_edges, i_attributes, i_graphInfo_graphEdgeKey);
        l_edgeDump = Tpl.popIter(l_edgeDump);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n",
                                    "<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:y=\"http://www.yworks.com/xml/graphml\" xmlns:yed=\"http://www.yworks.com/xml/yed/3\" xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://www.yworks.com/xml/schema/graphml/1.1/ygraphml.xsd\">\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<key for=\"node\" id=\""));
        txt = Tpl.writeStr(txt, i_graphNodeKey);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\" yfiles.type=\"nodegraphics\"/>\n",
                                    "<key attr.name=\"description\" attr.type=\"string\" for=\"node\" id=\"ddesc\" />\n",
                                    "<key for=\"edge\" id=\""
                                }, false));
        txt = Tpl.writeStr(txt, i_graphEdgeKey);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\" yfiles.type=\"edgegraphics\"/>\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_attDefDump);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "<!-- Graph Idx: "
                                }, false));
        ret_3 = arrayLength(i_graphs);
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" -->\n"));
        ret_4 = arrayLength(i_graphs);
        ret_5 = arrayGet(i_graphs, ret_4);
        txt = dumpGraph(txt, ret_5, i_graphs, i_nodes, Tpl.textString(l_edgeDump), i_graphNodeKey, i_attributes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</graphml>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpGraphInfoInternal;

protected function lm_8
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input array<GraphML.Attribute> in_a_graphAttributes;
  input String in_a_graphNodeKey;
  input array<GraphML.Graph> in_a_allGraphs;
  input array<GraphML.Node> in_a_allNodes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_graphAttributes, in_a_graphNodeKey, in_a_allGraphs, in_a_allNodes)
    local
      Tpl.Text txt;
      list<Integer> rest;
      array<GraphML.Attribute> a_graphAttributes;
      String a_graphNodeKey;
      array<GraphML.Graph> a_allGraphs;
      array<GraphML.Node> a_allNodes;
      Integer i_idc;
      GraphML.Node ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_idc :: rest,
           a_graphAttributes,
           a_graphNodeKey,
           a_allGraphs,
           a_allNodes )
      equation
        ret_0 = arrayLength(a_allNodes);
        ret_1 = intSub(ret_0, i_idc);
        ret_2 = intAdd(1, ret_1);
        ret_3 = arrayGet(a_allNodes, ret_2);
        txt = dumpNode(txt, ret_3, a_allGraphs, a_allNodes, a_graphNodeKey, a_graphAttributes);
        txt = Tpl.nextIter(txt);
        txt = lm_8(txt, rest, a_graphAttributes, a_graphNodeKey, a_allGraphs, a_allNodes);
      then txt;
  end match;
end lm_8;

protected function lm_9
  input Tpl.Text in_txt;
  input list<tuple<Integer, String>> in_items;
  input array<GraphML.Attribute> in_a_graphAttributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_graphAttributes)
    local
      Tpl.Text txt;
      list<tuple<Integer, String>> rest;
      array<GraphML.Attribute> a_graphAttributes;
      tuple<Integer, String> i_val;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_val :: rest,
           a_graphAttributes )
      equation
        txt = dumpAttKey(txt, i_val, a_graphAttributes);
        txt = Tpl.nextIter(txt);
        txt = lm_9(txt, rest, a_graphAttributes);
      then txt;
  end match;
end lm_9;

public function dumpGraph
  input Tpl.Text in_txt;
  input GraphML.Graph in_a_graph;
  input array<GraphML.Graph> in_a_allGraphs;
  input array<GraphML.Node> in_a_allNodes;
  input String in_a_edgeDesc;
  input String in_a_graphNodeKey;
  input array<GraphML.Attribute> in_a_graphAttributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_graph, in_a_allGraphs, in_a_allNodes, in_a_edgeDesc, in_a_graphNodeKey, in_a_graphAttributes)
    local
      Tpl.Text txt;
      array<GraphML.Graph> a_allGraphs;
      array<GraphML.Node> a_allNodes;
      String a_edgeDesc;
      String a_graphNodeKey;
      array<GraphML.Attribute> a_graphAttributes;
      String i_id;
      Boolean i_directed;
      list<tuple<Integer, String>> i_attValues;
      list<Integer> i_nodeIdc;
      Tpl.Text l_attKeys;
      Tpl.Text l_graphNodes;

    case ( txt,
           GraphML.GRAPH(nodeIdc = i_nodeIdc, attValues = i_attValues, directed = i_directed, id = i_id),
           a_allGraphs,
           a_allNodes,
           a_edgeDesc,
           a_graphNodeKey,
           a_graphAttributes )
      equation
        l_graphNodes = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_graphNodes = lm_8(l_graphNodes, i_nodeIdc, a_graphAttributes, a_graphNodeKey, a_allGraphs, a_allNodes);
        l_graphNodes = Tpl.popIter(l_graphNodes);
        l_attKeys = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attKeys = lm_9(l_attKeys, i_attValues, a_graphAttributes);
        l_attKeys = Tpl.popIter(l_attKeys);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<graph edgedefault=\""));
        txt = dumpDirected(txt, i_directed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" id=\""));
        txt = Tpl.writeStr(txt, i_id);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_attKeys);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_graphNodes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeStr(txt, a_edgeDesc);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</graph>"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpGraph;

protected function lm_11
  input Tpl.Text in_txt;
  input list<GraphML.NodeLabel> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<GraphML.NodeLabel> rest;
      GraphML.NodeLabel i_label;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_label :: rest )
      equation
        txt = dumpNodeLabel(txt, i_label);
        txt = Tpl.nextIter(txt);
        txt = lm_11(txt, rest);
      then txt;
  end match;
end lm_11;

protected function lm_12
  input Tpl.Text in_txt;
  input list<tuple<Integer, String>> in_items;
  input array<GraphML.Attribute> in_a_graphAttributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_graphAttributes)
    local
      Tpl.Text txt;
      list<tuple<Integer, String>> rest;
      array<GraphML.Attribute> a_graphAttributes;
      tuple<Integer, String> i_val;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_val :: rest,
           a_graphAttributes )
      equation
        txt = dumpAttKey(txt, i_val, a_graphAttributes);
        txt = Tpl.nextIter(txt);
        txt = lm_12(txt, rest, a_graphAttributes);
      then txt;
  end match;
end lm_12;

protected function fun_13
  input Tpl.Text in_txt;
  input Option<String> in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      String i_val;

    case ( txt,
           SOME(i_val) )
      equation
        txt = Tpl.writeStr(txt, i_val);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_13;

protected function fun_14
  input Tpl.Text in_txt;
  input Boolean in_a_isFolded;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isFolded)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("group"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("folder"));
      then txt;
  end match;
end fun_14;

protected function fun_15
  input Tpl.Text in_txt;
  input Boolean in_a_isFolded;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isFolded)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_15;

public function dumpNode
  input Tpl.Text in_txt;
  input GraphML.Node in_a_node;
  input array<GraphML.Graph> in_a_allGraphs;
  input array<GraphML.Node> in_a_allNodes;
  input String in_a_graphNodeKey;
  input array<GraphML.Attribute> in_a_graphAttributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_node, in_a_allGraphs, in_a_allNodes, in_a_graphNodeKey, in_a_graphAttributes)
    local
      Tpl.Text txt;
      array<GraphML.Graph> a_allGraphs;
      array<GraphML.Node> a_allNodes;
      String a_graphNodeKey;
      array<GraphML.Attribute> a_graphAttributes;
      Integer i_internalGraphIdx;
      String i_header;
      Boolean i_isFolded;
      GraphML.ShapeType i_shapeType;
      String i_color;
      Option<String> i_optDesc;
      String i_id;
      list<tuple<Integer, String>> i_attValues;
      list<GraphML.NodeLabel> i_nodeLabels;
      GraphML.Graph ret_10;
      Integer ret_9;
      Integer ret_8;
      Integer ret_7;
      Integer ret_6;
      Integer ret_5;
      Integer ret_4;
      Tpl.Text l_activeType;
      Tpl.Text l_folderType;
      Tpl.Text l_attKeys;
      Tpl.Text l_nodeLabelDump;

    case ( txt,
           GraphML.NODE(nodeLabels = i_nodeLabels, attValues = i_attValues, id = i_id, optDesc = i_optDesc, color = i_color, shapeType = i_shapeType),
           _,
           _,
           a_graphNodeKey,
           a_graphAttributes )
      equation
        l_nodeLabelDump = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_nodeLabelDump = lm_11(l_nodeLabelDump, i_nodeLabels);
        l_nodeLabelDump = Tpl.popIter(l_nodeLabelDump);
        l_attKeys = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attKeys = lm_12(l_attKeys, i_attValues, a_graphAttributes);
        l_attKeys = Tpl.popIter(l_attKeys);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<node id=\""));
        txt = Tpl.writeStr(txt, i_id);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_attKeys);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<data key=\"ddesc\"><![CDATA["));
        txt = fun_13(txt, i_optDesc);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]]></data>\n",
                                    "<data key=\""
                                }, false));
        txt = Tpl.writeStr(txt, a_graphNodeKey);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "    <y:ShapeNode>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<y:Fill color=\"#"));
        txt = Tpl.writeStr(txt, i_color);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\" transparent=\"false\"/>\n",
                                    "<y:BorderStyle color=\"#000000\" type=\"line\" width=\"1.0\"/>\n"
                                }, true));
        txt = Tpl.writeText(txt, l_nodeLabelDump);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<y:Shape type=\""));
        txt = dumpShapeType(txt, i_shapeType);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    </y:ShapeNode>\n",
                                    "</data>\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</node>"));
      then txt;

    case ( txt,
           GraphML.GROUPNODE(isFolded = i_isFolded, id = i_id, header = i_header, internalGraphIdx = i_internalGraphIdx),
           a_allGraphs,
           a_allNodes,
           a_graphNodeKey,
           a_graphAttributes )
      equation
        l_folderType = fun_14(Tpl.emptyTxt, i_isFolded);
        l_activeType = fun_15(Tpl.emptyTxt, i_isFolded);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<node id=\""));
        txt = Tpl.writeStr(txt, i_id);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" yfiles.foldertype=\""));
        txt = Tpl.writeText(txt, l_folderType);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<data key=\""));
        txt = Tpl.writeStr(txt, a_graphNodeKey);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <y:ProxyAutoBoundsNode>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<y:Realizers active=\""));
        txt = Tpl.writeText(txt, l_activeType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <y:GroupNode>\n",
                                    "    <y:Fill color=\"#F5F5F5\" transparent=\"false\"/>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<y:NodeLabel alignment=\"right\" autoSizePolicy=\"node_width\" backgroundColor=\"#EBEBEB\" borderDistance=\"0.0\" fontFamily=\"Dialog\" fontSize=\"15\" fontStyle=\"plain\" hasLineColor=\"false\" modelName=\"internal\" modelPosition=\"t\" textColor=\"#000000\" visible=\"true\">"));
        txt = Tpl.writeStr(txt, i_header);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</y:NodeLabel>\n",
                                    "<y:Shape type=\"roundrectangle\"/>\n",
                                    "<y:State closed=\"false\" closedHeight=\"50.0\" closedWidth=\"50.0\" innerGraphDisplayEnabled=\"false\"/>\n",
                                    "<y:Insets bottom=\"15\" bottomF=\"15.0\" left=\"15\" leftF=\"15.0\" right=\"15\" rightF=\"15.0\" top=\"15\" topF=\"15.0\"/>\n",
                                    "<y:BorderInsets bottom=\"0\" bottomF=\"0.0\" left=\"0\" leftF=\"0.0\" right=\"0\" rightF=\"0.0\" top=\"0\" topF=\"0.0\"/>\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </y:GroupNode>\n",
                                    "  <y:GroupNode>\n",
                                    "    <y:Geometry height=\"50.0\" width=\"50.0\" x=\"0.0\" y=\"60.0\"/>\n",
                                    "    <y:Fill color=\"#F5F5F5\" transparent=\"false\"/>\n",
                                    "    <y:BorderStyle color=\"#000000\" type=\"dashed\" width=\"1.0\"/>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<y:NodeLabel alignment=\"right\" autoSizePolicy=\"node_width\" backgroundColor=\"#EBEBEB\" borderDistance=\"0.0\" fontFamily=\"Dialog\" fontSize=\"15\" fontStyle=\"plain\" hasLineColor=\"false\" height=\"22.37646484375\" modelName=\"internal\" modelPosition=\"t\" textColor=\"#000000\" visible=\"true\">"));
        txt = Tpl.writeStr(txt, i_header);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</y:NodeLabel>\n",
                                    "<y:Shape type=\"roundrectangle\"/>\n",
                                    "<y:State closed=\"true\" closedHeight=\"50.0\" closedWidth=\"50.0\" innerGraphDisplayEnabled=\"false\"/>\n",
                                    "<y:Insets bottom=\"5\" bottomF=\"5.0\" left=\"5\" leftF=\"5.0\" right=\"5\" rightF=\"5.0\" top=\"5\" topF=\"5.0\"/>\n",
                                    "<y:BorderInsets bottom=\"0\" bottomF=\"0.0\" left=\"0\" leftF=\"0.0\" right=\"0\" rightF=\"0.0\" top=\"0\" topF=\"0.0\"/>\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </y:GroupNode>\n",
                                    "</y:Realizers>\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </y:ProxyAutoBoundsNode>\n",
                                    "</data>\n",
                                    "<!-- Graph Idx: "
                                }, false));
        ret_4 = arrayLength(a_allGraphs);
        ret_5 = intSub(ret_4, i_internalGraphIdx);
        ret_6 = intAdd(1, ret_5);
        txt = Tpl.writeStr(txt, intString(ret_6));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" -->\n"));
        ret_7 = arrayLength(a_allGraphs);
        ret_8 = intSub(ret_7, i_internalGraphIdx);
        ret_9 = intAdd(1, ret_8);
        ret_10 = arrayGet(a_allGraphs, ret_9);
        txt = dumpGraph(txt, ret_10, a_allGraphs, a_allNodes, "", a_graphNodeKey, a_graphAttributes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</node>"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpNode;

protected function lm_17
  input Tpl.Text in_txt;
  input list<GraphML.EdgeLabel> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<GraphML.EdgeLabel> rest;
      GraphML.EdgeLabel i_label;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_label :: rest )
      equation
        txt = dumpEdgeLabel(txt, i_label);
        txt = Tpl.nextIter(txt);
        txt = lm_17(txt, rest);
      then txt;
  end match;
end lm_17;

protected function lm_18
  input Tpl.Text in_txt;
  input list<tuple<Integer, String>> in_items;
  input array<GraphML.Attribute> in_a_graphAttributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_graphAttributes)
    local
      Tpl.Text txt;
      list<tuple<Integer, String>> rest;
      array<GraphML.Attribute> a_graphAttributes;
      tuple<Integer, String> i_val;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_val :: rest,
           a_graphAttributes )
      equation
        txt = dumpAttKey(txt, i_val, a_graphAttributes);
        txt = Tpl.nextIter(txt);
        txt = lm_18(txt, rest, a_graphAttributes);
      then txt;
  end match;
end lm_18;

public function dumpEdge
  input Tpl.Text in_txt;
  input GraphML.Edge in_a_edge;
  input String in_a_graphEdgeKey;
  input array<GraphML.Attribute> in_a_graphAttributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_edge, in_a_graphEdgeKey, in_a_graphAttributes)
    local
      Tpl.Text txt;
      String a_graphEdgeKey;
      array<GraphML.Attribute> a_graphAttributes;
      Boolean i_smooth;
      tuple<GraphML.ArrowType, GraphML.ArrowType> i_arrows;
      Real i_lineWidth;
      GraphML.LineType i_lineType;
      String i_color;
      String i_target;
      String i_source;
      String i_id;
      list<tuple<Integer, String>> i_attValues;
      list<GraphML.EdgeLabel> i_edgeLabels;
      GraphML.ArrowType ret_3;
      GraphML.ArrowType ret_2;
      Tpl.Text l_attKeys;
      Tpl.Text l_edgeLabelDump;

    case ( txt,
           GraphML.EDGE(edgeLabels = i_edgeLabels, attValues = i_attValues, id = i_id, source = i_source, target = i_target, color = i_color, lineType = i_lineType, lineWidth = i_lineWidth, arrows = i_arrows, smooth = i_smooth),
           a_graphEdgeKey,
           a_graphAttributes )
      equation
        l_edgeLabelDump = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_edgeLabelDump = lm_17(l_edgeLabelDump, i_edgeLabels);
        l_edgeLabelDump = Tpl.popIter(l_edgeLabelDump);
        l_attKeys = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attKeys = lm_18(l_attKeys, i_attValues, a_graphAttributes);
        l_attKeys = Tpl.popIter(l_attKeys);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<edge id=\""));
        txt = Tpl.writeStr(txt, i_id);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" source=\""));
        txt = Tpl.writeStr(txt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" target=\""));
        txt = Tpl.writeStr(txt, i_target);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_attKeys);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<data key=\""));
        txt = Tpl.writeStr(txt, a_graphEdgeKey);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <y:PolyLineEdge>\n",
                                    "    <y:Path sx=\"0.0\" sy=\"0.0\" tx=\"0.0\" ty=\"0.0\"/>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<y:LineStyle color=\"#"));
        txt = Tpl.writeStr(txt, i_color);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" type=\""));
        txt = dumpLineType(txt, i_lineType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" width=\""));
        txt = Tpl.writeStr(txt, realString(i_lineWidth));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"/>\n",
                                    "<y:Arrows source=\""
                                }, false));
        ret_2 = Util.tuple21(i_arrows);
        txt = dumpArrowType(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" target=\""));
        ret_3 = Util.tuple22(i_arrows);
        txt = dumpArrowType(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"/>\n",
                                    "<y:BendStyle smoothed=\""
                                }, false));
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_smooth));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"/>\n"));
        txt = Tpl.writeText(txt, l_edgeLabelDump);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </y:PolyLineEdge>\n",
                                    "</data>\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</edge>"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpEdge;

public function dumpEdgeLabel
  input Tpl.Text in_txt;
  input GraphML.EdgeLabel in_a_edgeLabel;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_edgeLabel)
    local
      Tpl.Text txt;
      String i_text;
      Integer i_fontSize;
      Option<String> i_backgroundColor;
      Tpl.Text l_bgColor;

    case ( txt,
           GraphML.EDGELABEL(backgroundColor = i_backgroundColor, fontSize = i_fontSize, text = i_text) )
      equation
        l_bgColor = dumpColorOpt(Tpl.emptyTxt, i_backgroundColor);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<y:EdgeLabel alignment=\"center\" distance=\"2.0\" fontFamily=\"Dialog\" "));
        txt = Tpl.writeText(txt, l_bgColor);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" fontSize=\""));
        txt = Tpl.writeStr(txt, intString(i_fontSize));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" fontStyle=\"plain\" hasBackgroundColor=\"false\" hasLineColor=\"false\" modelName=\"side_slider\" preferredPlacement=\"anywhere\" visible=\"true\">"));
        txt = Tpl.writeStr(txt, i_text);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</y:EdgeLabel>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpEdgeLabel;

public function dumpNodeLabel
  input Tpl.Text in_txt;
  input GraphML.NodeLabel in_a_nodeLabel;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nodeLabel)
    local
      Tpl.Text txt;
      String i_position;
      String i_text;
      GraphML.FontStyle i_fontStyle;
      Option<String> i_backgroundColor;
      Tpl.Text l_bgColor;

    case ( txt,
           GraphML.NODELABEL_INTERNAL(backgroundColor = i_backgroundColor, fontStyle = i_fontStyle, text = i_text) )
      equation
        l_bgColor = dumpColorOpt(Tpl.emptyTxt, i_backgroundColor);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<y:NodeLabel alignment=\"center\" autoSizePolicy=\"content\" "));
        txt = Tpl.writeText(txt, l_bgColor);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" fontFamily=\"Dialog\" fontSize=\"12\" fontStyle=\""));
        txt = dumpFontStyle(txt, i_fontStyle);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" hasLineColor=\"false\" modelName=\"internal\" modelPosition=\"c\" textColor=\"#000000\" visible=\"true\">"));
        txt = Tpl.writeStr(txt, i_text);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</y:NodeLabel>"));
      then txt;

    case ( txt,
           GraphML.NODELABEL_CORNER(backgroundColor = i_backgroundColor, fontStyle = i_fontStyle, position = i_position, text = i_text) )
      equation
        l_bgColor = dumpColorOpt(Tpl.emptyTxt, i_backgroundColor);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<y:NodeLabel alignment=\"center\" autoSizePolicy=\"content\" "));
        txt = Tpl.writeText(txt, l_bgColor);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" fontFamily=\"Dialog\" fontSize=\"12\" fontStyle=\""));
        txt = dumpFontStyle(txt, i_fontStyle);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" hasLineColor=\"false\" modelName=\"corners\" modelPosition=\""));
        txt = Tpl.writeStr(txt, i_position);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" textColor=\"#000000\" visible=\"true\">"));
        txt = Tpl.writeStr(txt, i_text);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</y:NodeLabel>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpNodeLabel;

protected function fun_22
  input Tpl.Text in_txt;
  input GraphML.Attribute in_mArg;
  input String in_a_val;
  input Integer in_a_idx;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_val, in_a_idx)
    local
      Tpl.Text txt;
      String a_val;
      Integer a_idx;

    case ( txt,
           GraphML.ATTRIBUTE(attType = GraphML.TYPE_STRING()),
           a_val,
           a_idx )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<data key=\"cust"));
        txt = Tpl.writeStr(txt, intString(a_idx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"><![CDATA["));
        txt = Tpl.writeStr(txt, a_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]]></data>"));
      then txt;

    case ( txt,
           _,
           a_val,
           a_idx )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<data key=\"cust"));
        txt = Tpl.writeStr(txt, intString(a_idx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = Tpl.writeStr(txt, a_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</data>"));
      then txt;
  end match;
end fun_22;

public function dumpAttKey
  input Tpl.Text in_txt;
  input tuple<Integer, String> in_a_key;
  input array<GraphML.Attribute> in_a_graphAttributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_key, in_a_graphAttributes)
    local
      Tpl.Text txt;
      array<GraphML.Attribute> a_graphAttributes;
      String i_val;
      Integer i_idx;
      GraphML.Attribute ret_0;

    case ( txt,
           (i_idx, i_val),
           a_graphAttributes )
      equation
        ret_0 = arrayGet(a_graphAttributes, i_idx);
        txt = fun_22(txt, ret_0, i_val, i_idx);
      then txt;
  end match;
end dumpAttKey;

public function dumpAttDef
  input Tpl.Text in_txt;
  input GraphML.Attribute in_a_attribute;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attribute)
    local
      Tpl.Text txt;
      String i_defaultValue;
      Integer i_attIdx;
      GraphML.AttributeTarget i_attTarget;
      GraphML.AttributeType i_attType;
      String i_name;

    case ( txt,
           GraphML.ATTRIBUTE(name = i_name, attType = i_attType, attTarget = i_attTarget, attIdx = i_attIdx, defaultValue = i_defaultValue) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<key attr.name=\""));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" attr.type=\""));
        txt = dumpAttType(txt, i_attType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" for=\""));
        txt = dumpAttTarget(txt, i_attTarget);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" id=\"cust"));
        txt = Tpl.writeStr(txt, intString(i_attIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<default>"));
        txt = Tpl.writeStr(txt, i_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</default>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</key>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAttDef;

public function dumpAttType
  input Tpl.Text in_txt;
  input GraphML.AttributeType in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           GraphML.TYPE_STRING() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           GraphML.TYPE_BOOLEAN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boolean"));
      then txt;

    case ( txt,
           GraphML.TYPE_INTEGER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           GraphML.TYPE_DOUBLE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAttType;

public function dumpAttTarget
  input Tpl.Text in_txt;
  input GraphML.AttributeTarget in_a_target;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_target)
    local
      Tpl.Text txt;

    case ( txt,
           GraphML.TARGET_NODE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("node"));
      then txt;

    case ( txt,
           GraphML.TARGET_EDGE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("edge"));
      then txt;

    case ( txt,
           GraphML.TARGET_GRAPH() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("graph"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAttTarget;

public function dumpDirected
  input Tpl.Text in_txt;
  input Boolean in_a_directed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_directed)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("directed"));
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("undirected"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpDirected;

public function dumpColorOpt
  input Tpl.Text in_txt;
  input Option<String> in_a_colorOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_colorOpt)
    local
      Tpl.Text txt;
      String i_col;

    case ( txt,
           SOME(i_col) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("backgroundColor=\"#"));
        txt = Tpl.writeStr(txt, i_col);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpColorOpt;

public function dumpFontStyle
  input Tpl.Text in_txt;
  input GraphML.FontStyle in_a_fontStyle;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fontStyle)
    local
      Tpl.Text txt;

    case ( txt,
           GraphML.FONTPLAIN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("plain"));
      then txt;

    case ( txt,
           GraphML.FONTBOLD() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bold"));
      then txt;

    case ( txt,
           GraphML.FONTITALIC() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("italic"));
      then txt;

    case ( txt,
           GraphML.FONTBOLDITALIC() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bolditalic"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFontStyle;

public function dumpLineType
  input Tpl.Text in_txt;
  input GraphML.LineType in_a_lineType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lineType)
    local
      Tpl.Text txt;

    case ( txt,
           GraphML.LINE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("line"));
      then txt;

    case ( txt,
           GraphML.DASHED() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dashed"));
      then txt;

    case ( txt,
           GraphML.DASHEDDOTTED() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dasheddotted"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpLineType;

public function dumpArrowType
  input Tpl.Text in_txt;
  input GraphML.ArrowType in_a_arrowType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arrowType)
    local
      Tpl.Text txt;

    case ( txt,
           GraphML.ARROWSTANDART() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("standard"));
      then txt;

    case ( txt,
           GraphML.ARROWNONE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("none"));
      then txt;

    case ( txt,
           GraphML.ARROWCONCAVE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("concave"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpArrowType;

public function dumpShapeType
  input Tpl.Text in_txt;
  input GraphML.ShapeType in_a_shape;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_shape)
    local
      Tpl.Text txt;

    case ( txt,
           GraphML.RECTANGLE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rectangle"));
      then txt;

    case ( txt,
           GraphML.ROUNDRECTANGLE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("roundrectangle"));
      then txt;

    case ( txt,
           GraphML.ELLIPSE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ellipse"));
      then txt;

    case ( txt,
           GraphML.PARALLELOGRAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parallelogram"));
      then txt;

    case ( txt,
           GraphML.HEXAGON() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("hexagon"));
      then txt;

    case ( txt,
           GraphML.TRIANGLE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("triangle"));
      then txt;

    case ( txt,
           GraphML.OCTAGON() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("octagon"));
      then txt;

    case ( txt,
           GraphML.DIAMOND() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("diamond"));
      then txt;

    case ( txt,
           GraphML.TRAPEZOID() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("trapezoid"));
      then txt;

    case ( txt,
           GraphML.TRAPEZOID2() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("trapezoid2"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpShapeType;

annotation(__OpenModelica_Interface="susan");
end GraphMLDumpTpl;