encapsulated package SCodeDumpTpl
"
  file:        SCodeDumpTpl.mo
  package:     SCodeDumpTpl
  description: Generated by Susan.
"

public import Tpl;

public import Absyn;
public import Dump;
public import SCode;
public import SCodeDump;
public import Config;
public import System;
protected import AbsynDumpTpl;

public function dumpProgram
  input Tpl.Text txt;
  input list<SCode.Element> a_program;
  input SCodeDump.SCodeDumpOptions a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt := dumpElements(txt, a_program, false, a_options);
end dumpProgram;

public function dumpElements
  input Tpl.Text txt;
  input list<SCode.Element> a_elements;
  input Boolean a_indent;
  input SCodeDump.SCodeDumpOptions a_options;

  output Tpl.Text out_txt;
protected
  list<SCode.Element> ret_0;
algorithm
  ret_0 := SCodeDump.filterElements(a_elements, a_options);
  out_txt := dumpElements2(txt, ret_0, "", a_indent, true, true, a_options);
end dumpElements;

protected function fun_11
  input Tpl.Text in_txt;
  input Boolean in_a_firstElement;
  input String in_a_prevSpacing;
  input Tpl.Text in_a_spacing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_firstElement, in_a_prevSpacing, in_a_spacing)
    local
      Tpl.Text txt;
      String a_prevSpacing;
      Tpl.Text a_spacing;

    case ( txt,
           false,
           a_prevSpacing,
           a_spacing )
      equation
        txt = dumpPreElementSpacing(txt, Tpl.textString(a_spacing), a_prevSpacing);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_11;

protected function fun_12
  input Tpl.Text in_txt;
  input Tpl.Text in_a_vis__str;
  input SCodeDump.SCodeDumpOptions in_a_options;
  input Boolean in_a_inPublicSection;
  input Boolean in_a_indent;
  input Tpl.Text in_a_spacing;
  input list<SCode.Element> in_a_rest__els;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vis__str, in_a_options, in_a_inPublicSection, in_a_indent, in_a_spacing, in_a_rest__els)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      Boolean a_inPublicSection;
      Boolean a_indent;
      Tpl.Text a_spacing;
      list<SCode.Element> a_rest__els;
      Boolean ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_options,
           a_inPublicSection,
           a_indent,
           a_spacing,
           a_rest__els )
      equation
        txt = dumpElements2(txt, a_rest__els, Tpl.textString(a_spacing), a_indent, false, a_inPublicSection, a_options);
      then txt;

    case ( txt,
           _,
           a_options,
           a_inPublicSection,
           a_indent,
           a_spacing,
           a_rest__els )
      equation
        ret_0 = boolNot(a_inPublicSection);
        txt = dumpElements2(txt, a_rest__els, Tpl.textString(a_spacing), a_indent, false, ret_0, a_options);
      then txt;
  end match;
end fun_12;

protected function fun_13
  input Tpl.Text in_txt;
  input Tpl.Text in_a_rest__str;
  input Tpl.Text in_a_spacing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_rest__str, in_a_spacing)
    local
      Tpl.Text txt;
      Tpl.Text a_spacing;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_spacing )
      equation
        txt = Tpl.writeText(txt, a_spacing);
      then txt;
  end match;
end fun_13;

protected function fun_14
  input Tpl.Text in_txt;
  input Boolean in_a_indent;
  input Tpl.Text in_a_rest__str;
  input Tpl.Text in_a_post__spacing;
  input Tpl.Text in_a_el__str;
  input Tpl.Text in_a_vis__str;
  input Tpl.Text in_a_pre__spacing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_indent, in_a_rest__str, in_a_post__spacing, in_a_el__str, in_a_vis__str, in_a_pre__spacing)
    local
      Tpl.Text txt;
      Tpl.Text a_rest__str;
      Tpl.Text a_post__spacing;
      Tpl.Text a_el__str;
      Tpl.Text a_vis__str;
      Tpl.Text a_pre__spacing;

    case ( txt,
           false,
           a_rest__str,
           a_post__spacing,
           a_el__str,
           a_vis__str,
           a_pre__spacing )
      equation
        txt = Tpl.writeText(txt, a_pre__spacing);
        txt = Tpl.writeText(txt, a_vis__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_el__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_post__spacing);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_rest__str);
      then txt;

    case ( txt,
           _,
           a_rest__str,
           a_post__spacing,
           a_el__str,
           a_vis__str,
           a_pre__spacing )
      equation
        txt = Tpl.writeText(txt, a_pre__spacing);
        txt = Tpl.writeText(txt, a_vis__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_el__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_post__spacing);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, a_rest__str);
      then txt;
  end match;
end fun_14;

public function dumpElements2
  input Tpl.Text in_txt;
  input list<SCode.Element> in_a_elements;
  input String in_a_prevSpacing;
  input Boolean in_a_indent;
  input Boolean in_a_firstElement;
  input Boolean in_a_inPublicSection;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elements, in_a_prevSpacing, in_a_indent, in_a_firstElement, in_a_inPublicSection, in_a_options)
    local
      Tpl.Text txt;
      String a_prevSpacing;
      Boolean a_indent;
      Boolean a_firstElement;
      Boolean a_inPublicSection;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.Element> i_rest__els;
      SCode.Element i_el;
      Tpl.Text l_elements__str;
      Tpl.Text l_post__spacing;
      Tpl.Text l_rest__str;
      Tpl.Text l_vis__str;
      Tpl.Text l_el__str;
      Tpl.Text l_pre__spacing;
      Tpl.Text l_spacing;

    case ( txt,
           i_el :: i_rest__els,
           a_prevSpacing,
           a_indent,
           a_firstElement,
           a_inPublicSection,
           a_options )
      equation
        l_spacing = dumpElementSpacing(Tpl.emptyTxt, i_el);
        l_pre__spacing = fun_11(Tpl.emptyTxt, a_firstElement, a_prevSpacing, l_spacing);
        l_el__str = dumpElement(Tpl.emptyTxt, i_el, "", a_options);
        l_vis__str = dumpElementVisibility(Tpl.emptyTxt, i_el, a_inPublicSection);
        l_rest__str = fun_12(Tpl.emptyTxt, l_vis__str, a_options, a_inPublicSection, a_indent, l_spacing, i_rest__els);
        l_post__spacing = fun_13(Tpl.emptyTxt, l_rest__str, l_spacing);
        l_elements__str = fun_14(Tpl.emptyTxt, a_indent, l_rest__str, l_post__spacing, l_el__str, l_vis__str, l_pre__spacing);
        txt = Tpl.writeText(txt, l_elements__str);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpElements2;

protected function fun_16
  input Tpl.Text in_txt;
  input String in_a_prevSpacing;
  input String in_a_curSpacing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_prevSpacing, in_a_curSpacing)
    local
      Tpl.Text txt;
      String a_curSpacing;

    case ( txt,
           "",
           a_curSpacing )
      equation
        txt = Tpl.writeStr(txt, a_curSpacing);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_16;

public function dumpPreElementSpacing
  input Tpl.Text txt;
  input String a_curSpacing;
  input String a_prevSpacing;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_16(txt, a_prevSpacing, a_curSpacing);
end dumpPreElementSpacing;

public function dumpElementSpacing
  input Tpl.Text in_txt;
  input SCode.Element in_a_element;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_element)
    local
      Tpl.Text txt;
      SCode.ClassDef i_classDef;

    case ( txt,
           SCode.CLASS(classDef = i_classDef) )
      equation
        txt = dumpClassDefSpacing(txt, i_classDef);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpElementSpacing;

public function dumpClassDefSpacing
  input Tpl.Text in_txt;
  input SCode.ClassDef in_a_classDef;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_classDef)
    local
      Tpl.Text txt;
      SCode.ClassDef i_composition;

    case ( txt,
           SCode.CLASS_EXTENDS(composition = i_composition) )
      equation
        txt = dumpClassDefSpacing(txt, i_composition);
      then txt;

    case ( txt,
           SCode.PARTS(elementLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpClassDefSpacing;

public function dumpElement
  input Tpl.Text in_txt;
  input SCode.Element in_a_element;
  input String in_a_each;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_element, in_a_each, in_a_options)
    local
      Tpl.Text txt;
      String a_each;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Element i_element;

    case ( txt,
           (i_element as SCode.IMPORT(imp = _)),
           _,
           _ )
      equation
        txt = dumpImport(txt, i_element);
      then txt;

    case ( txt,
           (i_element as SCode.EXTENDS(baseClassPath = _)),
           _,
           a_options )
      equation
        txt = dumpExtends(txt, i_element, a_options);
      then txt;

    case ( txt,
           (i_element as SCode.CLASS(name = _)),
           a_each,
           a_options )
      equation
        txt = dumpClass(txt, i_element, a_each, a_options);
      then txt;

    case ( txt,
           (i_element as SCode.COMPONENT(name = _)),
           a_each,
           a_options )
      equation
        txt = dumpComponent(txt, i_element, a_each, a_options);
      then txt;

    case ( txt,
           (i_element as SCode.DEFINEUNIT(name = _)),
           _,
           _ )
      equation
        txt = dumpDefineUnit(txt, i_element);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpElement: Unknown element.");
      then txt;
  end match;
end dumpElement;

public function dumpElementVisibility
  input Tpl.Text in_txt;
  input SCode.Element in_a_element;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_element, in_a_inPublicSection)
    local
      Tpl.Text txt;
      Boolean a_inPublicSection;
      SCode.Visibility i_vis;
      SCode.Visibility i_visibility;

    case ( txt,
           SCode.IMPORT(visibility = i_visibility),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_visibility, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.EXTENDS(visibility = i_visibility),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_visibility, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.CLASS(prefixes = SCode.PREFIXES(visibility = i_vis)),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_vis, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.COMPONENT(prefixes = SCode.PREFIXES(visibility = i_vis)),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_vis, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.DEFINEUNIT(visibility = i_visibility),
           a_inPublicSection )
      equation
        txt = dumpSectionVisibility(txt, i_visibility, a_inPublicSection);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpElementVisibility;

protected function fun_22
  input Tpl.Text in_txt;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inPublicSection)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("public"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_22;

protected function fun_23
  input Tpl.Text in_txt;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inPublicSection)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("protected"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_23;

public function dumpSectionVisibility
  input Tpl.Text in_txt;
  input SCode.Visibility in_a_visibility;
  input Boolean in_a_inPublicSection;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_visibility, in_a_inPublicSection)
    local
      Tpl.Text txt;
      Boolean a_inPublicSection;

    case ( txt,
           SCode.PUBLIC(),
           a_inPublicSection )
      equation
        txt = fun_22(txt, a_inPublicSection);
      then txt;

    case ( txt,
           SCode.PROTECTED(),
           a_inPublicSection )
      equation
        txt = fun_23(txt, a_inPublicSection);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpSectionVisibility;

protected function fun_25
  input Tpl.Text in_txt;
  input Absyn.Import in_a_imp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_imp)
    local
      Tpl.Text txt;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.NAMED_IMPORT(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("import "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = AbsynDumpTpl.dumpPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.QUAL_IMPORT(path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("import "));
        txt = AbsynDumpTpl.dumpPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.UNQUAL_IMPORT(path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("import "));
        txt = AbsynDumpTpl.dumpPath(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".*"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpImport: Unknown import.");
      then txt;
  end match;
end fun_25;

public function dumpImport
  input Tpl.Text in_txt;
  input SCode.Element in_a_import;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_import)
    local
      Tpl.Text txt;
      Absyn.Import i_imp;
      SCode.Visibility i_visibility;
      Tpl.Text l_import__str;
      Tpl.Text l_visibility__str;

    case ( txt,
           SCode.IMPORT(visibility = i_visibility, imp = i_imp) )
      equation
        l_visibility__str = dumpVisibility(Tpl.emptyTxt, i_visibility);
        l_import__str = fun_25(Tpl.emptyTxt, i_imp);
        txt = Tpl.writeText(txt, l_visibility__str);
        txt = Tpl.writeText(txt, l_import__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpImport;

public function dumpExtends
  input Tpl.Text in_txt;
  input SCode.Element in_a_extends;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extends, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      Option<SCode.Annotation> i_ann;
      SCode.Mod i_modifications;
      SCode.Visibility i_visibility;
      SCode.Path i_baseClassPath;
      Tpl.Text l_ann__str;
      Tpl.Text l_mod__str;
      Tpl.Text l_visibility__str;
      Tpl.Text l_bc__str;

    case ( txt,
           SCode.EXTENDS(baseClassPath = i_baseClassPath, visibility = i_visibility, modifications = i_modifications, ann = i_ann),
           a_options )
      equation
        l_bc__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_baseClassPath);
        l_visibility__str = dumpVisibility(Tpl.emptyTxt, i_visibility);
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications, a_options);
        l_ann__str = dumpAnnotationOpt(Tpl.emptyTxt, i_ann, a_options);
        txt = Tpl.writeText(txt, l_visibility__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extends "));
        txt = Tpl.writeText(txt, l_bc__str);
        txt = Tpl.writeText(txt, l_mod__str);
        txt = Tpl.writeText(txt, l_ann__str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpExtends;

public function dumpClass
  input Tpl.Text in_txt;
  input SCode.Element in_a_class;
  input String in_a_each;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_class, in_a_each, in_a_options)
    local
      Tpl.Text txt;
      String a_each;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Ident i_name;
      SCode.Comment i_cmt;
      SCode.ClassDef i_classDef;
      SCode.Restriction i_restriction;
      SCode.Partial i_partialPrefix;
      SCode.Encapsulated i_encapsulatedPrefix;
      SCode.Prefixes i_prefixes;
      Tpl.Text l_footer__str;
      Tpl.Text l_header__str;
      Tpl.Text l_cc__str;
      Tpl.Text l_ann__str;
      Tpl.Text l_cmt__str;
      Tpl.Text l_cdef__str;
      Tpl.Text l_prefixes__str;
      Tpl.Text l_res__str;
      Tpl.Text l_partial__str;
      Tpl.Text l_enc__str;
      Tpl.Text l_prefix__str;

    case ( txt,
           SCode.CLASS(prefixes = i_prefixes, encapsulatedPrefix = i_encapsulatedPrefix, partialPrefix = i_partialPrefix, restriction = i_restriction, classDef = i_classDef, cmt = i_cmt, name = i_name),
           a_each,
           a_options )
      equation
        l_prefix__str = dumpPrefixes(Tpl.emptyTxt, i_prefixes, a_each);
        l_enc__str = dumpEncapsulated(Tpl.emptyTxt, i_encapsulatedPrefix);
        l_partial__str = dumpPartial(Tpl.emptyTxt, i_partialPrefix);
        l_res__str = dumpRestriction(Tpl.emptyTxt, i_restriction);
        l_prefixes__str = Tpl.writeText(Tpl.emptyTxt, l_prefix__str);
        l_prefixes__str = Tpl.writeText(l_prefixes__str, l_enc__str);
        l_prefixes__str = Tpl.writeText(l_prefixes__str, l_partial__str);
        l_prefixes__str = Tpl.writeText(l_prefixes__str, l_res__str);
        l_cdef__str = dumpClassDef(Tpl.emptyTxt, i_classDef, a_options);
        l_cmt__str = dumpClassComment(Tpl.emptyTxt, i_cmt);
        l_ann__str = dumpClassAnnotation(Tpl.emptyTxt, i_cmt, a_options);
        l_cc__str = dumpReplaceableConstrainClass(Tpl.emptyTxt, i_prefixes, a_options);
        l_header__str = dumpClassHeader(Tpl.emptyTxt, i_classDef, i_name, Tpl.textString(l_cmt__str), a_options);
        l_footer__str = dumpClassFooter(Tpl.emptyTxt, i_classDef, Tpl.textString(l_cdef__str), i_name, Tpl.textString(l_cmt__str), Tpl.textString(l_ann__str), Tpl.textString(l_cc__str));
        txt = Tpl.writeText(txt, l_prefixes__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_header__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_footer__str);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpClass;

public function dumpClassHeader
  input Tpl.Text in_txt;
  input SCode.ClassDef in_a_classDef;
  input String in_a_name;
  input String in_a_cmt;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_classDef, in_a_name, in_a_cmt, in_a_options)
    local
      Tpl.Text txt;
      String a_name;
      String a_cmt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Mod i_modifications;
      Tpl.Text l_mod__str;

    case ( txt,
           SCode.CLASS_EXTENDS(modifications = i_modifications),
           a_name,
           a_cmt,
           a_options )
      equation
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extends "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeText(txt, l_mod__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_cmt);
      then txt;

    case ( txt,
           SCode.PARTS(elementLst = _),
           a_name,
           a_cmt,
           _ )
      equation
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_cmt);
      then txt;

    case ( txt,
           _,
           a_name,
           _,
           _ )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;
  end match;
end dumpClassHeader;

protected function fun_30
  input Tpl.Text in_txt;
  input SCodeDump.SCodeDumpOptions in_a_options;
  input list<SCode.AlgorithmSection> in_a_p_normalAlgorithmLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_options, in_a_p_normalAlgorithmLst)
    local
      Tpl.Text txt;
      list<SCode.AlgorithmSection> a_p_normalAlgorithmLst;
      SCodeDump.SCodeDumpOptions i_options;

    case ( txt,
           (i_options as SCodeDump.OPTIONS(stripAlgorithmSections = false)),
           a_p_normalAlgorithmLst )
      equation
        txt = dumpAlgorithmSections(txt, a_p_normalAlgorithmLst, "algorithm", i_options);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_30;

protected function fun_31
  input Tpl.Text in_txt;
  input SCodeDump.SCodeDumpOptions in_a_options;
  input list<SCode.AlgorithmSection> in_a_p_initialAlgorithmLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_options, in_a_p_initialAlgorithmLst)
    local
      Tpl.Text txt;
      list<SCode.AlgorithmSection> a_p_initialAlgorithmLst;
      SCodeDump.SCodeDumpOptions i_options;

    case ( txt,
           (i_options as SCodeDump.OPTIONS(stripAlgorithmSections = false)),
           a_p_initialAlgorithmLst )
      equation
        txt = dumpAlgorithmSections(txt, a_p_initialAlgorithmLst, "initial algorithm", i_options);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_31;

protected function lm_32
  input Tpl.Text in_txt;
  input list<SCode.Enum> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.Enum> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Enum i_enum;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_enum :: rest,
           a_options )
      equation
        txt = dumpEnumLiteral(txt, i_enum, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_32(txt, rest, a_options);
      then txt;
  end match;
end lm_32;

protected function fun_33
  input Tpl.Text in_txt;
  input list<SCode.Enum> in_a_enumLst;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_enumLst, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.Enum> i_enumLst;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           i_enumLst,
           a_options )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_32(txt, i_enumLst, a_options);
        txt = Tpl.popIter(txt);
      then txt;
  end match;
end fun_33;

protected function lm_34
  input Tpl.Text in_txt;
  input list<SCode.Ident> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SCode.Ident> rest;
      SCode.Ident i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_34(txt, rest);
      then txt;
  end match;
end lm_34;

protected function lm_35
  input Tpl.Text in_txt;
  input list<Absyn.Path> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Path> rest;
      Absyn.Path i_path;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_path :: rest )
      equation
        txt = AbsynDumpTpl.dumpPath(txt, i_path);
        txt = Tpl.nextIter(txt);
        txt = lm_35(txt, rest);
      then txt;
  end match;
end lm_35;

public function dumpClassDef
  input Tpl.Text in_txt;
  input SCode.ClassDef in_a_classDef;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_classDef, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      list<Absyn.Path> i_pathLst;
      list<SCode.Ident> i_derivedVariables;
      Absyn.Path i_functionPath;
      list<SCode.Enum> i_enumLst;
      SCode.Attributes i_attributes;
      Absyn.TypeSpec i_typeSpec;
      SCode.ClassDef i_composition;
      SCode.Mod i_modifications;
      Option<SCode.ExternalDecl> i_p_externalDecl;
      list<SCode.AlgorithmSection> i_p_initialAlgorithmLst;
      list<SCode.AlgorithmSection> i_p_normalAlgorithmLst;
      list<SCode.Equation> i_initialEquationLst;
      list<SCode.Equation> i_normalEquationLst;
      list<SCode.Element> i_elementLst;
      Tpl.Text l_func__str;
      Tpl.Text l_enum__str;
      Tpl.Text l_attr__str;
      Tpl.Text l_type__str;
      Tpl.Text l_mod__str;
      Tpl.Text l_cdef__str;
      Tpl.Text l_extdecl__str;
      Tpl.Text l_ial__str;
      Tpl.Text l_nal__str;
      Tpl.Text l_ieq__str;
      Tpl.Text l_neq__str;
      Tpl.Text l_el__str;

    case ( txt,
           SCode.PARTS(elementLst = i_elementLst, normalEquationLst = i_normalEquationLst, initialEquationLst = i_initialEquationLst, normalAlgorithmLst = i_p_normalAlgorithmLst, initialAlgorithmLst = i_p_initialAlgorithmLst, externalDecl = i_p_externalDecl),
           a_options )
      equation
        l_el__str = dumpElements(Tpl.emptyTxt, i_elementLst, true, a_options);
        l_neq__str = dumpEquations(Tpl.emptyTxt, i_normalEquationLst, "equation", a_options);
        l_ieq__str = dumpEquations(Tpl.emptyTxt, i_initialEquationLst, "initial equation", a_options);
        l_nal__str = fun_30(Tpl.emptyTxt, a_options, i_p_normalAlgorithmLst);
        l_ial__str = fun_31(Tpl.emptyTxt, a_options, i_p_initialAlgorithmLst);
        l_extdecl__str = dumpExternalDeclOpt(Tpl.emptyTxt, i_p_externalDecl, a_options);
        l_cdef__str = Tpl.writeText(Tpl.emptyTxt, l_el__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.writeText(l_cdef__str, l_ieq__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.writeText(l_cdef__str, l_ial__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.writeText(l_cdef__str, l_neq__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.writeText(l_cdef__str, l_nal__str);
        l_cdef__str = Tpl.softNewLine(l_cdef__str);
        l_cdef__str = Tpl.pushBlock(l_cdef__str, Tpl.BT_INDENT(2));
        l_cdef__str = Tpl.writeText(l_cdef__str, l_extdecl__str);
        l_cdef__str = Tpl.popBlock(l_cdef__str);
        txt = Tpl.writeText(txt, l_cdef__str);
      then txt;

    case ( txt,
           SCode.CLASS_EXTENDS(modifications = i_modifications, composition = i_composition),
           a_options )
      equation
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications, a_options);
        l_cdef__str = dumpClassDef(Tpl.emptyTxt, i_composition, a_options);
        txt = Tpl.writeText(txt, l_cdef__str);
      then txt;

    case ( txt,
           SCode.DERIVED(typeSpec = i_typeSpec, modifications = i_modifications, attributes = i_attributes),
           a_options )
      equation
        l_type__str = AbsynDumpTpl.dumpTypeSpec(Tpl.emptyTxt, i_typeSpec);
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications, a_options);
        l_attr__str = dumpAttributes(Tpl.emptyTxt, i_attributes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = Tpl.writeText(txt, l_attr__str);
        txt = Tpl.writeText(txt, l_type__str);
        txt = Tpl.writeText(txt, l_mod__str);
      then txt;

    case ( txt,
           SCode.ENUMERATION(enumLst = i_enumLst),
           a_options )
      equation
        l_enum__str = fun_33(Tpl.emptyTxt, i_enumLst, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= enumeration("));
        txt = Tpl.writeText(txt, l_enum__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           SCode.PDER(functionPath = i_functionPath, derivedVariables = i_derivedVariables),
           _ )
      equation
        l_func__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_functionPath);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= der("));
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_34(txt, i_derivedVariables);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           SCode.OVERLOAD(pathLst = i_pathLst),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= overload("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_35(txt, i_pathLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpClassDef: Unknown class definition.");
      then txt;
  end match;
end dumpClassDef;

protected function fun_37
  input Tpl.Text in_txt;
  input String in_a_ann;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ann)
    local
      Tpl.Text txt;
      String i_ann;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_ann )
      equation
        txt = Tpl.writeStr(txt, i_ann);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
      then txt;
  end match;
end fun_37;

protected function fun_38
  input Tpl.Text in_txt;
  input Tpl.Text in_a_annstr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_annstr)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end match;
end fun_38;

protected function fun_39
  input Tpl.Text in_txt;
  input String in_a_cdefStr;
  input String in_a_cc__str;
  input String in_a_name;
  input Tpl.Text in_a_annstr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cdefStr, in_a_cc__str, in_a_name, in_a_annstr)
    local
      Tpl.Text txt;
      String a_cc__str;
      String a_name;
      Tpl.Text a_annstr;
      String i_cdefStr;

    case ( txt,
           "",
           a_cc__str,
           a_name,
           a_annstr )
      equation
        txt = Tpl.writeText(txt, a_annstr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeStr(txt, a_cc__str);
      then txt;

    case ( txt,
           i_cdefStr,
           a_cc__str,
           a_name,
           a_annstr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeStr(txt, i_cdefStr);
        txt = Tpl.softNewLine(txt);
        txt = fun_38(txt, a_annstr);
        txt = Tpl.writeText(txt, a_annstr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeStr(txt, a_cc__str);
      then txt;
  end match;
end fun_39;

public function dumpClassFooter
  input Tpl.Text in_txt;
  input SCode.ClassDef in_a_classDef;
  input String in_a_cdefStr;
  input String in_a_name;
  input String in_a_cmt;
  input String in_a_ann;
  input String in_a_cc__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_classDef, in_a_cdefStr, in_a_name, in_a_cmt, in_a_ann, in_a_cc__str)
    local
      Tpl.Text txt;
      String a_cdefStr;
      String a_name;
      String a_cmt;
      String a_ann;
      String a_cc__str;
      Tpl.Text l_annstr;

    case ( txt,
           SCode.DERIVED(typeSpec = _),
           a_cdefStr,
           _,
           a_cmt,
           a_ann,
           a_cc__str )
      equation
        txt = Tpl.writeStr(txt, a_cdefStr);
        txt = Tpl.writeStr(txt, a_cmt);
        txt = Tpl.writeStr(txt, a_ann);
        txt = Tpl.writeStr(txt, a_cc__str);
      then txt;

    case ( txt,
           SCode.ENUMERATION(enumLst = _),
           a_cdefStr,
           _,
           a_cmt,
           a_ann,
           a_cc__str )
      equation
        txt = Tpl.writeStr(txt, a_cdefStr);
        txt = Tpl.writeStr(txt, a_cmt);
        txt = Tpl.writeStr(txt, a_ann);
        txt = Tpl.writeStr(txt, a_cc__str);
      then txt;

    case ( txt,
           SCode.PDER(functionPath = _),
           a_cdefStr,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeStr(txt, a_cdefStr);
      then txt;

    case ( txt,
           _,
           a_cdefStr,
           a_name,
           _,
           a_ann,
           a_cc__str )
      equation
        l_annstr = fun_37(Tpl.emptyTxt, a_ann);
        txt = fun_39(txt, a_cdefStr, a_cc__str, a_name, l_annstr);
      then txt;
  end match;
end dumpClassFooter;

public function dumpClassComment
  input Tpl.Text in_txt;
  input SCode.Comment in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      Option<String> i_comment;

    case ( txt,
           SCode.COMMENT(comment = i_comment) )
      equation
        txt = dumpCommentStr(txt, i_comment);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpClassComment;

public function dumpClassAnnotation
  input Tpl.Text in_txt;
  input SCode.Comment in_a_comment;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      Option<SCode.Annotation> i_annotation__;

    case ( txt,
           SCode.COMMENT(annotation_ = i_annotation__),
           a_options )
      equation
        txt = dumpAnnotationOpt(txt, i_annotation__, a_options);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpClassAnnotation;

protected function fun_43
  input Tpl.Text in_txt;
  input Option<Absyn.Exp> in_a_condition;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_condition)
    local
      Tpl.Text txt;
      Absyn.Exp i_cond;

    case ( txt,
           SOME(i_cond) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = AbsynDumpTpl.dumpExp(txt, i_cond);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_43;

public function dumpComponent
  input Tpl.Text in_txt;
  input SCode.Element in_a_component;
  input String in_a_each;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_component, in_a_each, in_a_options)
    local
      Tpl.Text txt;
      String a_each;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Ident i_name;
      SCode.Comment i_comment;
      Option<Absyn.Exp> i_condition;
      SCode.Mod i_modifications;
      Absyn.TypeSpec i_typeSpec;
      SCode.Attributes i_attributes;
      SCode.Prefixes i_prefixes;
      Tpl.Text l_cmt__str;
      Tpl.Text l_cond__str;
      Tpl.Text l_mod__str;
      Tpl.Text l_type__str;
      Tpl.Text l_attr__dim__str;
      Tpl.Text l_attr__pre__str;
      Tpl.Text l_cc__str;
      Tpl.Text l_prefix__str;

    case ( txt,
           SCode.COMPONENT(prefixes = i_prefixes, attributes = i_attributes, typeSpec = i_typeSpec, modifications = i_modifications, condition = i_condition, comment = i_comment, name = i_name),
           a_each,
           a_options )
      equation
        l_prefix__str = dumpPrefixes(Tpl.emptyTxt, i_prefixes, a_each);
        l_cc__str = dumpReplaceableConstrainClass(Tpl.emptyTxt, i_prefixes, a_options);
        l_attr__pre__str = dumpAttributes(Tpl.emptyTxt, i_attributes);
        l_attr__dim__str = dumpAttributeDim(Tpl.emptyTxt, i_attributes);
        l_type__str = AbsynDumpTpl.dumpTypeSpec(Tpl.emptyTxt, i_typeSpec);
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_modifications, a_options);
        l_cond__str = fun_43(Tpl.emptyTxt, i_condition);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeText(txt, l_prefix__str);
        txt = Tpl.writeText(txt, l_attr__pre__str);
        txt = Tpl.writeText(txt, l_type__str);
        txt = Tpl.writeText(txt, l_attr__dim__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeText(txt, l_mod__str);
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeText(txt, l_cc__str);
        txt = Tpl.writeText(txt, l_cmt__str);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpComponent;

protected function fun_45
  input Tpl.Text in_txt;
  input Option<String> in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      String i_e;

    case ( txt,
           SOME(i_e) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("exp = \""));
        txt = Tpl.writeStr(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_45;

protected function fun_46
  input Tpl.Text in_txt;
  input Option<Real> in_a_weight;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_weight)
    local
      Tpl.Text txt;
      Real i_w;

    case ( txt,
           SOME(i_w) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("weight = "));
        txt = Tpl.writeStr(txt, realString(i_w));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_46;

protected function smf_47
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_47;

protected function smf_48
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_48;

protected function fun_49
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_args__str)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
      then txt;
  end match;
end fun_49;

protected function fun_50
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_args__str)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_50;

public function dumpDefineUnit
  input Tpl.Text in_txt;
  input SCode.Element in_a_defineUnit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_defineUnit)
    local
      Tpl.Text txt;
      SCode.Ident i_name;
      Option<Real> i_weight;
      Option<String> i_exp;
      SCode.Visibility i_visibility;
      Tpl.Text l_pe;
      Tpl.Text l_pb;
      Tpl.Text l_args__str;
      Tpl.Text l_weight__str;
      Tpl.Text l_exp__str;
      Tpl.Text l_vis__str;

    case ( txt,
           SCode.DEFINEUNIT(visibility = i_visibility, exp = i_exp, weight = i_weight, name = i_name) )
      equation
        l_vis__str = dumpVisibility(Tpl.emptyTxt, i_visibility);
        l_exp__str = fun_45(Tpl.emptyTxt, i_exp);
        l_weight__str = fun_46(Tpl.emptyTxt, i_weight);
        l_args__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_args__str = smf_47(l_args__str, l_exp__str);
        l_args__str = smf_48(l_args__str, l_weight__str);
        l_args__str = Tpl.popIter(l_args__str);
        l_pb = fun_49(Tpl.emptyTxt, l_args__str);
        l_pe = fun_50(Tpl.emptyTxt, l_args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("defineunit "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeText(txt, l_pb);
        txt = Tpl.writeText(txt, l_args__str);
        txt = Tpl.writeText(txt, l_pe);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpDefineUnit;

public function dumpEnumLiteral
  input Tpl.Text in_txt;
  input SCode.Enum in_a_enum;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_enum, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Ident i_literal;
      SCode.Comment i_comment;
      Tpl.Text l_cmt__str;

    case ( txt,
           SCode.ENUM(comment = i_comment, literal = i_literal),
           a_options )
      equation
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeStr(txt, i_literal);
        txt = Tpl.writeText(txt, l_cmt__str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpEnumLiteral;

protected function lm_53
  input Tpl.Text in_txt;
  input list<SCode.Equation> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.Equation> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Equation i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_options )
      equation
        txt = dumpEquation(txt, i_eq, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest, a_options);
      then txt;
  end match;
end lm_53;

public function dumpEquations
  input Tpl.Text in_txt;
  input list<SCode.Equation> in_a_equations;
  input String in_a_label;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_equations, in_a_label, in_a_options)
    local
      Tpl.Text txt;
      String a_label;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.Equation> i_equations;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_equations,
           a_label,
           a_options )
      equation
        txt = Tpl.writeStr(txt, a_label);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_53(txt, i_equations, a_options);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end dumpEquations;

public function dumpEquation
  input Tpl.Text in_txt;
  input SCode.Equation in_a_equation;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_equation, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.EEquation i_eEquation;

    case ( txt,
           SCode.EQUATION(eEquation = i_eEquation),
           a_options )
      equation
        txt = dumpEEquation(txt, i_eEquation, a_options);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpEquation;

public function dumpEEquation
  input Tpl.Text in_txt;
  input SCode.EEquation in_a_equation;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_equation, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      Absyn.Exp i_exp;
      Absyn.Exp i_expReinit;
      Absyn.ComponentRef i_cref;
      Absyn.Exp i_message;
      Absyn.Exp i_condition;
      Absyn.ComponentRef i_crefRight;
      Absyn.ComponentRef i_crefLeft;
      SCode.Comment i_comment;
      Absyn.Exp i_expRight;
      Absyn.Exp i_expLeft;
      SCode.EEquation i_equation;
      Tpl.Text l_exp__str;
      Tpl.Text l_cref__str;
      Tpl.Text l_msg__str;
      Tpl.Text l_cond__str;
      Tpl.Text l_cmt__str;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           (i_equation as SCode.EQ_IF(condition = _)),
           a_options )
      equation
        txt = dumpIfEEquation(txt, i_equation, a_options);
      then txt;

    case ( txt,
           SCode.EQ_EQUALS(expLeft = i_expLeft, expRight = i_expRight, comment = i_comment),
           a_options )
      equation
        l_lhs__str = AbsynDumpTpl.dumpLhsExp(Tpl.emptyTxt, i_expLeft);
        l_rhs__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_expRight);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.EQ_CONNECT(crefLeft = i_crefLeft, crefRight = i_crefRight, comment = i_comment),
           a_options )
      equation
        l_lhs__str = AbsynDumpTpl.dumpCref(Tpl.emptyTxt, i_crefLeft);
        l_rhs__str = AbsynDumpTpl.dumpCref(Tpl.emptyTxt, i_crefRight);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("connect("));
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           (i_equation as SCode.EQ_FOR(index = _)),
           a_options )
      equation
        txt = dumpForEEquation(txt, i_equation, a_options);
      then txt;

    case ( txt,
           (i_equation as SCode.EQ_WHEN(condition = _)),
           a_options )
      equation
        txt = dumpWhenEEquation(txt, i_equation, a_options);
      then txt;

    case ( txt,
           SCode.EQ_ASSERT(condition = i_condition, message = i_message, comment = i_comment),
           a_options )
      equation
        l_cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_condition);
        l_msg__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_message);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assert("));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_msg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.EQ_TERMINATE(message = i_message, comment = i_comment),
           a_options )
      equation
        l_msg__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_message);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("terminate("));
        txt = Tpl.writeText(txt, l_msg__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.EQ_REINIT(cref = i_cref, expReinit = i_expReinit, comment = i_comment),
           a_options )
      equation
        l_cref__str = AbsynDumpTpl.dumpCref(Tpl.emptyTxt, i_cref);
        l_exp__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_expReinit);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("reinit("));
        txt = Tpl.writeText(txt, l_cref__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.EQ_NORETCALL(exp = i_exp, comment = i_comment),
           a_options )
      equation
        l_exp__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_exp);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpEEquation: Unknown EEquation.");
      then txt;
  end match;
end dumpEEquation;

protected function lm_57
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.EEquation i_e;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_e :: rest,
           a_options )
      equation
        txt = dumpEEquation(txt, i_e, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_57(txt, rest, a_options);
      then txt;
  end match;
end lm_57;

protected function lm_58
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.EEquation i_e;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_e :: rest,
           a_options )
      equation
        txt = dumpEEquation(txt, i_e, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_58(txt, rest, a_options);
      then txt;
  end match;
end lm_58;

protected function fun_59
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_a_elseBranch;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elseBranch, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.EEquation> i_elseBranch;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_elseBranch,
           a_options )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_58(txt, i_elseBranch, a_options);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_59;

public function dumpIfEEquation
  input Tpl.Text in_txt;
  input SCode.EEquation in_a_ifequation;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ifequation, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.EEquation> i_elseBranch;
      list<list<SCode.EEquation>> i_elseif__branches;
      list<Absyn.Exp> i_elseif__conds;
      list<SCode.EEquation> i_if__branch;
      Absyn.Exp i_if__cond;
      Tpl.Text l_else__str;
      Tpl.Text l_elseif__str;
      Tpl.Text l_if__branch__str;
      Tpl.Text l_if__cond__str;

    case ( txt,
           SCode.EQ_IF(condition = i_if__cond :: i_elseif__conds, thenBranch = i_if__branch :: i_elseif__branches, elseBranch = i_elseBranch),
           a_options )
      equation
        l_if__cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_if__cond);
        l_if__branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_if__branch__str = lm_57(l_if__branch__str, i_if__branch, a_options);
        l_if__branch__str = Tpl.popIter(l_if__branch__str);
        l_elseif__str = dumpElseIfEEquation(Tpl.emptyTxt, i_elseif__conds, i_elseif__branches, a_options);
        l_else__str = fun_59(Tpl.emptyTxt, i_elseBranch, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_if__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_if__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_elseif__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_else__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end if;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpIfEEquation;

protected function lm_61
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.EEquation i_e;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_e :: rest,
           a_options )
      equation
        txt = dumpEEquation(txt, i_e, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_61(txt, rest, a_options);
      then txt;
  end match;
end lm_61;

protected function fun_62
  input Tpl.Text in_txt;
  input list<list<SCode.EEquation>> in_a_branches;
  input list<Absyn.Exp> in_a_rest__conds;
  input SCodeDump.SCodeDumpOptions in_a_options;
  input Absyn.Exp in_a_cond;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_branches, in_a_rest__conds, in_a_options, in_a_cond)
    local
      Tpl.Text txt;
      list<Absyn.Exp> a_rest__conds;
      SCodeDump.SCodeDumpOptions a_options;
      Absyn.Exp a_cond;
      list<list<SCode.EEquation>> i_rest__branches;
      list<SCode.EEquation> i_branch;
      Tpl.Text l_rest__str;
      Tpl.Text l_branch__str;
      Tpl.Text l_cond__str;

    case ( txt,
           i_branch :: i_rest__branches,
           a_rest__conds,
           a_options,
           a_cond )
      equation
        l_cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, a_cond);
        l_branch__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_branch__str = lm_61(l_branch__str, i_branch, a_options);
        l_branch__str = Tpl.popIter(l_branch__str);
        l_rest__str = dumpElseIfEEquation(Tpl.emptyTxt, a_rest__conds, i_rest__branches, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elseif "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_rest__str);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_62;

public function dumpElseIfEEquation
  input Tpl.Text in_txt;
  input list<Absyn.Exp> in_a_condition;
  input list<list<SCode.EEquation>> in_a_branches;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_condition, in_a_branches, in_a_options)
    local
      Tpl.Text txt;
      list<list<SCode.EEquation>> a_branches;
      SCodeDump.SCodeDumpOptions a_options;
      list<Absyn.Exp> i_rest__conds;
      Absyn.Exp i_cond;

    case ( txt,
           i_cond :: i_rest__conds,
           a_branches,
           a_options )
      equation
        txt = fun_62(txt, a_branches, i_rest__conds, a_options, i_cond);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpElseIfEEquation;

protected function lm_64
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.EEquation i_e;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_e :: rest,
           a_options )
      equation
        txt = dumpEEquation(txt, i_e, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_64(txt, rest, a_options);
      then txt;
  end match;
end lm_64;

protected function lm_65
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.EEquation i_e;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_e :: rest,
           a_options )
      equation
        txt = dumpEEquation(txt, i_e, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_65(txt, rest, a_options);
      then txt;
  end match;
end lm_65;

public function dumpForEEquation
  input Tpl.Text in_txt;
  input SCode.EEquation in_a_for__equation;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_for__equation, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Ident i_index;
      SCode.Comment i_comment;
      list<SCode.EEquation> i_eEquationLst;
      Absyn.Exp i_range;
      Tpl.Text l_cmt__str;
      Tpl.Text l_eq__str;
      Tpl.Text l_range__str;

    case ( txt,
           SCode.EQ_FOR(range = SOME(i_range), eEquationLst = i_eEquationLst, comment = i_comment, index = i_index),
           a_options )
      equation
        l_range__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_range);
        l_eq__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_eq__str = lm_64(l_eq__str, i_eEquationLst, a_options);
        l_eq__str = Tpl.popIter(l_eq__str);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for "));
        txt = Tpl.writeStr(txt, i_index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" in "));
        txt = Tpl.writeText(txt, l_range__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" loop"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_eq__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for;"));
      then txt;

    case ( txt,
           SCode.EQ_FOR(eEquationLst = i_eEquationLst, comment = i_comment, index = i_index),
           a_options )
      equation
        l_eq__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_eq__str = lm_65(l_eq__str, i_eEquationLst, a_options);
        l_eq__str = Tpl.popIter(l_eq__str);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for "));
        txt = Tpl.writeStr(txt, i_index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" loop"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_eq__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpForEEquation;

protected function lm_67
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.EEquation i_e;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_e :: rest,
           a_options )
      equation
        txt = dumpEEquation(txt, i_e, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_67(txt, rest, a_options);
      then txt;
  end match;
end lm_67;

protected function lm_68
  input Tpl.Text in_txt;
  input list<SCode.EEquation> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.EEquation> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.EEquation i_e;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_e :: rest,
           a_options )
      equation
        txt = dumpEEquation(txt, i_e, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_68(txt, rest, a_options);
      then txt;
  end match;
end lm_68;

protected function lm_69
  input Tpl.Text in_txt;
  input list<tuple<Absyn.Exp, list<SCode.EEquation>>> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<tuple<Absyn.Exp, list<SCode.EEquation>>> rest;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.EEquation> i_else__body;
      Absyn.Exp i_else__cond;
      Tpl.Text l_else__body__str;
      Tpl.Text l_else__cond__str;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_else__cond, i_else__body) :: rest,
           a_options )
      equation
        l_else__cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_else__cond);
        l_else__body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_else__body__str = lm_68(l_else__body__str, i_else__body, a_options);
        l_else__body__str = Tpl.popIter(l_else__body__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elsewhen "));
        txt = Tpl.writeText(txt, l_else__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_else__body__str);
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_69(txt, rest, a_options);
      then txt;
  end match;
end lm_69;

public function dumpWhenEEquation
  input Tpl.Text in_txt;
  input SCode.EEquation in_a_when__equation;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_when__equation, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Comment i_comment;
      list<tuple<Absyn.Exp, list<SCode.EEquation>>> i_elseBranches;
      list<SCode.EEquation> i_eEquationLst;
      Absyn.Exp i_condition;
      Tpl.Text l_cmt__str;
      Tpl.Text l_else__str;
      Tpl.Text l_body__str;
      Tpl.Text l_cond__str;

    case ( txt,
           SCode.EQ_WHEN(condition = i_condition, eEquationLst = i_eEquationLst, elseBranches = i_elseBranches, comment = i_comment),
           a_options )
      equation
        l_cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_condition);
        l_body__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__str = lm_67(l_body__str, i_eEquationLst, a_options);
        l_body__str = Tpl.popIter(l_body__str);
        l_else__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_else__str = lm_69(l_else__str, i_elseBranches, a_options);
        l_else__str = Tpl.popIter(l_else__str);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_else__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpWhenEEquation;

protected function lm_71
  input Tpl.Text in_txt;
  input list<SCode.AlgorithmSection> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.AlgorithmSection> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.AlgorithmSection i_al;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_al :: rest,
           a_options )
      equation
        txt = dumpAlgorithmSection(txt, i_al, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_71(txt, rest, a_options);
      then txt;
  end match;
end lm_71;

public function dumpAlgorithmSections
  input Tpl.Text in_txt;
  input list<SCode.AlgorithmSection> in_a_algorithms;
  input String in_a_label;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_algorithms, in_a_label, in_a_options)
    local
      Tpl.Text txt;
      String a_label;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.AlgorithmSection> i_algorithms;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_algorithms,
           a_label,
           a_options )
      equation
        txt = Tpl.writeStr(txt, a_label);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_71(txt, i_algorithms, a_options);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end dumpAlgorithmSections;

public function dumpAlgorithmSection
  input Tpl.Text in_txt;
  input SCode.AlgorithmSection in_a_algorithm;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_algorithm, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.Statement> i_statements;

    case ( txt,
           SCode.ALGORITHM(statements = i_statements),
           a_options )
      equation
        txt = dumpStatements(txt, i_statements, a_options);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpAlgorithmSection;

protected function lm_74
  input Tpl.Text in_txt;
  input list<SCode.Statement> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.Statement> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Statement i_s;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_s :: rest,
           a_options )
      equation
        txt = dumpStatement(txt, i_s, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_74(txt, rest, a_options);
      then txt;
  end match;
end lm_74;

public function dumpStatements
  input Tpl.Text txt;
  input list<SCode.Statement> a_statements;
  input SCodeDump.SCodeDumpOptions a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_74(out_txt, a_statements, a_options);
  out_txt := Tpl.popIter(out_txt);
end dumpStatements;

public function dumpStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_statement;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_statement, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Statement i_stmt;
      Absyn.Exp i_exp;
      SCode.Statement i_statement;
      SCode.Comment i_comment;
      Absyn.Exp i_value;
      Absyn.Exp i_assignComponent;
      Tpl.Text l_exp__str;
      Tpl.Text l_cmt__str;
      Tpl.Text l_rhs__str;
      Tpl.Text l_lhs__str;

    case ( txt,
           SCode.ALG_ASSIGN(assignComponent = i_assignComponent, value = i_value, comment = i_comment),
           a_options )
      equation
        l_lhs__str = AbsynDumpTpl.dumpLhsExp(Tpl.emptyTxt, i_assignComponent);
        l_rhs__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_value);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeText(txt, l_lhs__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" := "));
        txt = Tpl.writeText(txt, l_rhs__str);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_IF(boolExpr = _)),
           a_options )
      equation
        txt = dumpIfStatement(txt, i_statement, a_options);
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_FOR(index = _)),
           a_options )
      equation
        txt = dumpForStatement(txt, i_statement, a_options);
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_WHILE(boolExpr = _)),
           a_options )
      equation
        txt = dumpWhileStatement(txt, i_statement, a_options);
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_WHEN_A(branches = _)),
           a_options )
      equation
        txt = dumpWhenStatement(txt, i_statement, a_options);
      then txt;

    case ( txt,
           SCode.ALG_NORETCALL(exp = i_exp, comment = i_comment),
           a_options )
      equation
        l_exp__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_exp);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeText(txt, l_exp__str);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.ALG_RETURN(comment = i_comment),
           a_options )
      equation
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.ALG_BREAK(comment = i_comment),
           a_options )
      equation
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SCode.ALG_FAILURE(stmts = {i_stmt}, comment = i_comment),
           a_options )
      equation
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("failure("));
        txt = dumpStatement(txt, i_stmt, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           (i_statement as SCode.ALG_TRY(body = _)),
           a_options )
      equation
        txt = dumpTryStatement(txt, i_statement, a_options);
      then txt;

    case ( txt,
           SCode.ALG_CONTINUE(comment = i_comment),
           a_options )
      equation
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("continue"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpStatement: Unknown statement.");
      then txt;
  end match;
end dumpStatement;

public function dumpIfStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_if__statement;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_if__statement, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Comment i_comment;
      list<SCode.Statement> i_elseBranch;
      list<tuple<Absyn.Exp, list<SCode.Statement>>> i_elseIfBranch;
      list<SCode.Statement> i_trueBranch;
      Absyn.Exp i_boolExpr;
      Tpl.Text l_cmt__str;
      Tpl.Text l_else__branch__str;
      Tpl.Text l_else__if__str;
      Tpl.Text l_true__branch__str;
      Tpl.Text l_cond__str;

    case ( txt,
           SCode.ALG_IF(boolExpr = i_boolExpr, trueBranch = i_trueBranch, elseIfBranch = i_elseIfBranch, elseBranch = i_elseBranch, comment = i_comment),
           a_options )
      equation
        l_cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_boolExpr);
        l_true__branch__str = dumpStatements(Tpl.emptyTxt, i_trueBranch, a_options);
        l_else__if__str = dumpElseIfStatements(Tpl.emptyTxt, i_elseIfBranch, a_options);
        l_else__branch__str = dumpStatements(Tpl.emptyTxt, i_elseBranch, a_options);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_true__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_else__if__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_else__branch__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end if;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpIfStatement;

protected function lm_78
  input Tpl.Text in_txt;
  input list<tuple<Absyn.Exp, list<SCode.Statement>>> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<tuple<Absyn.Exp, list<SCode.Statement>>> rest;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.Statement> i_body;
      Absyn.Exp i_cond;
      Tpl.Text l_body__str;
      Tpl.Text l_cond__str;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_cond, i_body) :: rest,
           a_options )
      equation
        l_cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_cond);
        l_body__str = dumpStatements(Tpl.emptyTxt, i_body, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elseif "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_78(txt, rest, a_options);
      then txt;
  end match;
end lm_78;

public function dumpElseIfStatements
  input Tpl.Text txt;
  input list<tuple<Absyn.Exp, list<SCode.Statement>>> a_else__if;
  input SCodeDump.SCodeDumpOptions a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_78(out_txt, a_else__if, a_options);
  out_txt := Tpl.popIter(out_txt);
end dumpElseIfStatements;

public function dumpForStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_for__statement;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_for__statement, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      String i_index;
      SCode.Comment i_comment;
      list<SCode.Statement> i_forBody;
      Absyn.Exp i_e;
      Tpl.Text l_cmt__str;
      Tpl.Text l_body__str;
      Tpl.Text l_range__str;

    case ( txt,
           SCode.ALG_FOR(range = SOME(i_e), forBody = i_forBody, comment = i_comment, index = i_index),
           a_options )
      equation
        l_range__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_e);
        l_body__str = dumpStatements(Tpl.emptyTxt, i_forBody, a_options);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for "));
        txt = Tpl.writeStr(txt, i_index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" in "));
        txt = Tpl.writeText(txt, l_range__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" loop"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for;"));
      then txt;

    case ( txt,
           SCode.ALG_FOR(forBody = i_forBody, comment = i_comment, index = i_index),
           a_options )
      equation
        l_body__str = dumpStatements(Tpl.emptyTxt, i_forBody, a_options);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for "));
        txt = Tpl.writeStr(txt, i_index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" loop"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end for;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpForStatement;

public function dumpWhileStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_while__statement;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_while__statement, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Comment i_comment;
      list<SCode.Statement> i_whileBody;
      Absyn.Exp i_boolExpr;
      Tpl.Text l_cmt__str;
      Tpl.Text l_body__str;
      Tpl.Text l_cond__str;

    case ( txt,
           SCode.ALG_WHILE(boolExpr = i_boolExpr, whileBody = i_whileBody, comment = i_comment),
           a_options )
      equation
        l_cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_boolExpr);
        l_body__str = dumpStatements(Tpl.emptyTxt, i_whileBody, a_options);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("while "));
        txt = Tpl.writeText(txt, l_cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" loop\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end while;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpWhileStatement;

protected function lm_82
  input Tpl.Text in_txt;
  input list<tuple<Absyn.Exp, list<SCode.Statement>>> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<tuple<Absyn.Exp, list<SCode.Statement>>> rest;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.Statement> i_ew__body;
      Absyn.Exp i_ew__cond;
      Tpl.Text l_ew__body__str;
      Tpl.Text l_ew__cond__str;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_ew__cond, i_ew__body) :: rest,
           a_options )
      equation
        l_ew__cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_ew__cond);
        l_ew__body__str = dumpStatements(Tpl.emptyTxt, i_ew__body, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elsewhen "));
        txt = Tpl.writeText(txt, l_ew__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_ew__body__str);
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_82(txt, rest, a_options);
      then txt;
  end match;
end lm_82;

public function dumpWhenStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_when__statement;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_when__statement, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Comment i_comment;
      list<tuple<Absyn.Exp, list<SCode.Statement>>> i_elsewhens;
      list<SCode.Statement> i_when__body;
      Absyn.Exp i_when__cond;
      Tpl.Text l_cmt__str;
      Tpl.Text l_elsewhen__str;
      Tpl.Text l_when__body__str;
      Tpl.Text l_when__cond__str;

    case ( txt,
           SCode.ALG_WHEN_A(branches = (i_when__cond, i_when__body) :: i_elsewhens, comment = i_comment),
           a_options )
      equation
        l_when__cond__str = AbsynDumpTpl.dumpExp(Tpl.emptyTxt, i_when__cond);
        l_when__body__str = dumpStatements(Tpl.emptyTxt, i_when__body, a_options);
        l_elsewhen__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_elsewhen__str = lm_82(l_elsewhen__str, i_elsewhens, a_options);
        l_elsewhen__str = Tpl.popIter(l_elsewhen__str);
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        txt = Tpl.writeText(txt, l_when__cond__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_when__body__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_elsewhen__str);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpWhenStatement;

public function dumpTryStatement
  input Tpl.Text in_txt;
  input SCode.Statement in_a_try__statement;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_try__statement, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.Statement> i_elseBody;
      list<SCode.Statement> i_body;
      SCode.Comment i_comment;
      Tpl.Text l_algs2;
      Tpl.Text l_algs1;
      Tpl.Text l_cmt__str;

    case ( txt,
           SCode.ALG_TRY(comment = i_comment, body = i_body, elseBody = i_elseBody),
           a_options )
      equation
        l_cmt__str = dumpComment(Tpl.emptyTxt, i_comment, a_options);
        l_algs1 = dumpStatements(Tpl.emptyTxt, i_body, a_options);
        l_algs2 = dumpStatements(Tpl.emptyTxt, i_elseBody, a_options);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("try\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_algs1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_algs2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end try"));
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpTryStatement;

public function dumpPrefixes
  input Tpl.Text in_txt;
  input SCode.Prefixes in_a_prefixes;
  input String in_a_each;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_prefixes, in_a_each)
    local
      Tpl.Text txt;
      String a_each;
      SCode.Replaceable i_replaceablePrefix;
      Absyn.InnerOuter i_innerOuter;
      SCode.Final i_finalPrefix;
      SCode.Redeclare i_redeclarePrefix;
      Tpl.Text l_replaceable__str;
      Tpl.Text l_io__str;
      Tpl.Text l_final__str;
      Tpl.Text l_redeclare__str;

    case ( txt,
           SCode.PREFIXES(redeclarePrefix = i_redeclarePrefix, finalPrefix = i_finalPrefix, innerOuter = i_innerOuter, replaceablePrefix = i_replaceablePrefix),
           a_each )
      equation
        l_redeclare__str = dumpRedeclare(Tpl.emptyTxt, i_redeclarePrefix);
        l_final__str = dumpFinal(Tpl.emptyTxt, i_finalPrefix);
        l_io__str = dumpInnerOuter(Tpl.emptyTxt, i_innerOuter);
        l_replaceable__str = dumpReplaceable(Tpl.emptyTxt, i_replaceablePrefix);
        txt = Tpl.writeText(txt, l_redeclare__str);
        txt = Tpl.writeStr(txt, a_each);
        txt = Tpl.writeText(txt, l_final__str);
        txt = Tpl.writeText(txt, l_io__str);
        txt = Tpl.writeText(txt, l_replaceable__str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpPrefixes;

public function dumpVisibility
  input Tpl.Text in_txt;
  input SCode.Visibility in_a_visibility;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_visibility)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.PROTECTED() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("protected "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVisibility;

public function dumpRedeclare
  input Tpl.Text in_txt;
  input SCode.Redeclare in_a_redeclare;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_redeclare)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.REDECLARE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("redeclare "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpRedeclare;

public function dumpFinal
  input Tpl.Text in_txt;
  input SCode.Final in_a_final;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_final)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.FINAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("final "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFinal;

public function dumpInnerOuter
  input Tpl.Text in_txt;
  input Absyn.InnerOuter in_a_innerOuter;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_innerOuter)
    local
      Tpl.Text txt;

    case ( txt,
           Absyn.INNER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inner "));
      then txt;

    case ( txt,
           Absyn.OUTER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("outer "));
      then txt;

    case ( txt,
           Absyn.INNER_OUTER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inner outer "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInnerOuter;

public function dumpReplaceable
  input Tpl.Text in_txt;
  input SCode.Replaceable in_a_replaceable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_replaceable)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.REPLACEABLE(cc = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("replaceable "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpReplaceable;

public function dumpReplaceableConstrainClass
  input Tpl.Text in_txt;
  input SCode.Prefixes in_a_replaceable;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_replaceable, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Mod i_cc__mod;
      Absyn.Path i_cc__path;
      Tpl.Text l_mod__str;
      Tpl.Text l_path__str;

    case ( txt,
           SCode.PREFIXES(replaceablePrefix = SCode.REPLACEABLE(cc = SOME(SCode.CONSTRAINCLASS(constrainingClass = i_cc__path, modifier = i_cc__mod)))),
           a_options )
      equation
        l_path__str = AbsynDumpTpl.dumpPath(Tpl.emptyTxt, i_cc__path);
        l_mod__str = dumpModifier(Tpl.emptyTxt, i_cc__mod, a_options);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constrainedby "));
        txt = Tpl.writeText(txt, l_path__str);
        txt = Tpl.writeText(txt, l_mod__str);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpReplaceableConstrainClass;

public function dumpEach
  input Tpl.Text in_txt;
  input SCode.Each in_a_each;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_each)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.EACH() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("each "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpEach;

public function dumpEncapsulated
  input Tpl.Text in_txt;
  input SCode.Encapsulated in_a_encapsulated;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_encapsulated)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.ENCAPSULATED() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("encapsulated "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpEncapsulated;

public function dumpPartial
  input Tpl.Text in_txt;
  input SCode.Partial in_a_partial;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_partial)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.PARTIAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("partial "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpPartial;

protected function fun_95
  input Tpl.Text in_txt;
  input Boolean in_a_isOperator;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isOperator)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("record"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("operator record"));
      then txt;
  end match;
end fun_95;

protected function fun_96
  input Tpl.Text in_txt;
  input Boolean in_a_isExpandable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isExpandable)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("connector"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expandable connector"));
      then txt;
  end match;
end fun_96;

public function dumpRestriction
  input Tpl.Text in_txt;
  input SCode.Restriction in_a_restriction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_restriction)
    local
      Tpl.Text txt;
      SCode.FunctionRestriction i_functionRestriction;
      Boolean i_isExpandable;
      Boolean i_isOperator;

    case ( txt,
           SCode.R_CLASS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class"));
      then txt;

    case ( txt,
           SCode.R_OPTIMIZATION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("optimization"));
      then txt;

    case ( txt,
           SCode.R_MODEL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("model"));
      then txt;

    case ( txt,
           SCode.R_RECORD(isOperator = i_isOperator) )
      equation
        txt = fun_95(txt, i_isOperator);
      then txt;

    case ( txt,
           SCode.R_OPERATOR() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("operator"));
      then txt;

    case ( txt,
           SCode.R_BLOCK() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("block"));
      then txt;

    case ( txt,
           SCode.R_CONNECTOR(isExpandable = i_isExpandable) )
      equation
        txt = fun_96(txt, i_isExpandable);
      then txt;

    case ( txt,
           SCode.R_OPERATOR() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("operator"));
      then txt;

    case ( txt,
           SCode.R_TYPE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("type"));
      then txt;

    case ( txt,
           SCode.R_PACKAGE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("package"));
      then txt;

    case ( txt,
           SCode.R_FUNCTION(functionRestriction = i_functionRestriction) )
      equation
        txt = dumpFunctionRestriction(txt, i_functionRestriction);
      then txt;

    case ( txt,
           SCode.R_ENUMERATION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("enumeration"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_INTEGER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("IntegerType"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_REAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RealType"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_STRING() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StringType"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_BOOLEAN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("BooleanType"));
      then txt;

    case ( txt,
           SCode.R_PREDEFINED_ENUMERATION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EnumType"));
      then txt;

    case ( txt,
           SCode.R_METARECORD(name = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("record"));
      then txt;

    case ( txt,
           SCode.R_UNIONTYPE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("uniontype"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpRestriction: Unknown restriction.");
      then txt;
  end match;
end dumpRestriction;

protected function fun_98
  input Tpl.Text in_txt;
  input Boolean in_a_isImpure;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isImpure)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("impure function"));
      then txt;
  end match;
end fun_98;

protected function fun_99
  input Tpl.Text in_txt;
  input Boolean in_a_isImpure;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isImpure)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("impure function"));
      then txt;
  end match;
end fun_99;

public function dumpFunctionRestriction
  input Tpl.Text in_txt;
  input SCode.FunctionRestriction in_a_funcRest;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_funcRest)
    local
      Tpl.Text txt;
      Boolean i_isImpure;

    case ( txt,
           SCode.FR_NORMAL_FUNCTION(isImpure = i_isImpure) )
      equation
        txt = fun_98(txt, i_isImpure);
      then txt;

    case ( txt,
           SCode.FR_EXTERNAL_FUNCTION(isImpure = i_isImpure) )
      equation
        txt = fun_99(txt, i_isImpure);
      then txt;

    case ( txt,
           SCode.FR_OPERATOR_FUNCTION() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("operator function"));
      then txt;

    case ( txt,
           SCode.FR_RECORD_CONSTRUCTOR() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = errorMsg(txt, "SCodeDump.dumpFunctionRestriction: Unknown Function restriction.");
      then txt;
  end match;
end dumpFunctionRestriction;

protected function lm_101
  input Tpl.Text in_txt;
  input list<SCode.SubMod> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.SubMod> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.SubMod i_submod;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_submod :: rest,
           a_options )
      equation
        txt = dumpSubModifier(txt, i_submod, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_101(txt, rest, a_options);
      then txt;
  end match;
end lm_101;

protected function fun_102
  input Tpl.Text in_txt;
  input list<SCode.SubMod> in_a_subModLst;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subModLst, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.SubMod> i_subModLst;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_subModLst,
           a_options )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_101(txt, i_subModLst, a_options);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_102;

public function dumpModifier
  input Tpl.Text in_txt;
  input SCode.Mod in_a_modifier;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modifier, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.SubMod> i_subModLst;
      Option<tuple<Absyn.Exp, Boolean>> i_binding;
      Tpl.Text l_submod__str;
      Tpl.Text l_binding__str;

    case ( txt,
           SCode.MOD(binding = i_binding, subModLst = i_subModLst),
           a_options )
      equation
        l_binding__str = dumpModifierBinding(Tpl.emptyTxt, i_binding);
        l_submod__str = fun_102(Tpl.emptyTxt, i_subModLst, a_options);
        txt = Tpl.writeText(txt, l_submod__str);
        txt = Tpl.writeText(txt, l_binding__str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpModifier;

protected function lm_104
  input Tpl.Text in_txt;
  input list<SCode.SubMod> in_items;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_options)
    local
      Tpl.Text txt;
      list<SCode.SubMod> rest;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.SubMod i_submod;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_submod :: rest,
           a_options )
      equation
        txt = dumpAnnotationSubModifier(txt, i_submod, a_options);
        txt = Tpl.nextIter(txt);
        txt = lm_104(txt, rest, a_options);
      then txt;
  end match;
end lm_104;

protected function fun_105
  input Tpl.Text in_txt;
  input Tpl.Text in_a_text;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_text)
    local
      Tpl.Text txt;
      Tpl.Text i_text;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_text )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_text);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_105;

public function dumpAnnotationModifier
  input Tpl.Text in_txt;
  input SCode.Mod in_a_modifier;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modifier, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      list<SCode.SubMod> i_subModLst;
      Option<tuple<Absyn.Exp, Boolean>> i_binding;
      Tpl.Text l_submod__str;
      Tpl.Text l_text;
      Tpl.Text l_binding__str;

    case ( txt,
           SCode.MOD(binding = i_binding, subModLst = i_subModLst),
           a_options )
      equation
        l_binding__str = dumpModifierBinding(Tpl.emptyTxt, i_binding);
        l_text = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_text = lm_104(l_text, i_subModLst, a_options);
        l_text = Tpl.popIter(l_text);
        l_submod__str = fun_105(Tpl.emptyTxt, l_text);
        txt = Tpl.writeText(txt, l_submod__str);
        txt = Tpl.writeText(txt, l_binding__str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpAnnotationModifier;

public function dumpModifierPrefix
  input Tpl.Text in_txt;
  input SCode.Mod in_a_modifier;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modifier)
    local
      Tpl.Text txt;
      SCode.Each i_eachPrefix;
      SCode.Final i_finalPrefix;
      Tpl.Text l_each__str;
      Tpl.Text l_final__str;

    case ( txt,
           SCode.MOD(finalPrefix = i_finalPrefix, eachPrefix = i_eachPrefix) )
      equation
        l_final__str = dumpFinal(Tpl.emptyTxt, i_finalPrefix);
        l_each__str = dumpEach(Tpl.emptyTxt, i_eachPrefix);
        txt = Tpl.writeText(txt, l_each__str);
        txt = Tpl.writeText(txt, l_final__str);
      then txt;

    case ( txt,
           SCode.REDECL(finalPrefix = i_finalPrefix, eachPrefix = i_eachPrefix) )
      equation
        l_final__str = dumpFinal(Tpl.emptyTxt, i_finalPrefix);
        l_each__str = dumpEach(Tpl.emptyTxt, i_eachPrefix);
        txt = Tpl.writeText(txt, l_each__str);
        txt = Tpl.writeText(txt, l_final__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpModifierPrefix;

public function dumpRedeclModifier
  input Tpl.Text in_txt;
  input SCode.Mod in_a_modifier;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modifier, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Element i_element;
      SCode.Each i_eachPrefix;
      Tpl.Text l_each__str;

    case ( txt,
           SCode.REDECL(eachPrefix = i_eachPrefix, element = i_element),
           a_options )
      equation
        l_each__str = dumpEach(Tpl.emptyTxt, i_eachPrefix);
        txt = dumpElement(txt, i_element, Tpl.textString(l_each__str), a_options);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpRedeclModifier;

public function dumpModifierBinding
  input Tpl.Text in_txt;
  input Option<tuple<Absyn.Exp, Boolean>> in_a_binding;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_binding)
    local
      Tpl.Text txt;
      Absyn.Exp i_exp;

    case ( txt,
           SOME((i_exp, _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = AbsynDumpTpl.dumpExp(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpModifierBinding;

public function dumpSubModifier
  input Tpl.Text in_txt;
  input SCode.SubMod in_a_submod;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_submod, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Ident i_ident;
      SCode.Mod i_mod;

    case ( txt,
           SCode.NAMEMOD(mod = (i_mod as SCode.MOD(finalPrefix = _)), ident = i_ident),
           a_options )
      equation
        txt = dumpModifierPrefix(txt, i_mod);
        txt = Tpl.writeStr(txt, i_ident);
        txt = dumpModifier(txt, i_mod, a_options);
      then txt;

    case ( txt,
           SCode.NAMEMOD(mod = (i_mod as SCode.REDECL(finalPrefix = _))),
           a_options )
      equation
        txt = dumpRedeclModifier(txt, i_mod, a_options);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpSubModifier;

protected function fun_111
  input Tpl.Text in_txt;
  input SCode.Ident in_a_ident;
  input SCodeDump.SCodeDumpOptions in_a_options;
  input SCode.Mod in_a_nameMod;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ident, in_a_options, in_a_nameMod)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Mod a_nameMod;
      SCode.Ident i_ident;

    case ( txt,
           "choices",
           _,
           _ )
      then txt;

    case ( txt,
           "Documentation",
           _,
           _ )
      then txt;

    case ( txt,
           "Dialog",
           _,
           _ )
      then txt;

    case ( txt,
           "Diagram",
           _,
           _ )
      then txt;

    case ( txt,
           "Icon",
           _,
           _ )
      then txt;

    case ( txt,
           "Line",
           _,
           _ )
      then txt;

    case ( txt,
           "Placement",
           _,
           _ )
      then txt;

    case ( txt,
           "preferredView",
           _,
           _ )
      then txt;

    case ( txt,
           "conversion",
           _,
           _ )
      then txt;

    case ( txt,
           "defaultComponentName",
           _,
           _ )
      then txt;

    case ( txt,
           "revisionId",
           _,
           _ )
      then txt;

    case ( txt,
           "uses",
           _,
           _ )
      then txt;

    case ( txt,
           i_ident,
           a_options,
           a_nameMod )
      equation
        txt = dumpModifierPrefix(txt, a_nameMod);
        txt = Tpl.writeStr(txt, i_ident);
        txt = dumpAnnotationModifier(txt, a_nameMod, a_options);
      then txt;
  end match;
end fun_111;

protected function fun_112
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SCode.Mod in_a_mod;
  input SCodeDump.SCodeDumpOptions in_a_options;
  input SCode.Mod in_a_nameMod;
  input SCode.Ident in_a_ident;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_mod, in_a_options, in_a_nameMod, in_a_ident)
    local
      Tpl.Text txt;
      SCode.Mod a_mod;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Mod a_nameMod;
      SCode.Ident a_ident;

    case ( txt,
           false,
           _,
           a_options,
           a_nameMod,
           a_ident )
      equation
        txt = fun_111(txt, a_ident, a_options, a_nameMod);
      then txt;

    case ( txt,
           _,
           a_mod,
           a_options,
           a_nameMod,
           a_ident )
      equation
        txt = dumpModifierPrefix(txt, a_mod);
        txt = Tpl.writeStr(txt, a_ident);
        txt = dumpAnnotationModifier(txt, a_nameMod, a_options);
      then txt;
  end match;
end fun_112;

public function dumpAnnotationSubModifier
  input Tpl.Text in_txt;
  input SCode.SubMod in_a_submod;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_submod, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Mod i_mod;
      SCode.Mod i_nameMod;
      SCode.Ident i_ident;
      Boolean ret_0;

    case ( txt,
           SCode.NAMEMOD(mod = (i_nameMod as (i_mod as SCode.MOD(finalPrefix = _))), ident = i_ident),
           a_options )
      equation
        ret_0 = Config.showAnnotations();
        txt = fun_112(txt, ret_0, i_mod, a_options, i_nameMod, i_ident);
      then txt;

    case ( txt,
           SCode.NAMEMOD(mod = (i_mod as SCode.REDECL(finalPrefix = _))),
           a_options )
      equation
        txt = dumpRedeclModifier(txt, i_mod, a_options);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpAnnotationSubModifier;

public function dumpAttributes
  input Tpl.Text in_txt;
  input SCode.Attributes in_a_attributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attributes)
    local
      Tpl.Text txt;
      Absyn.Direction i_direction;
      SCode.Variability i_variability;
      SCode.Parallelism i_parallelism;
      SCode.ConnectorType i_connectorType;
      Tpl.Text l_dir__str;
      Tpl.Text l_var__str;
      Tpl.Text l_prl__str;
      Tpl.Text l_ct__str;

    case ( txt,
           SCode.ATTR(connectorType = i_connectorType, parallelism = i_parallelism, variability = i_variability, direction = i_direction) )
      equation
        l_ct__str = dumpConnectorType(Tpl.emptyTxt, i_connectorType);
        l_prl__str = dumpParallelism(Tpl.emptyTxt, i_parallelism);
        l_var__str = dumpVariability(Tpl.emptyTxt, i_variability);
        l_dir__str = dumpDirection(Tpl.emptyTxt, i_direction);
        txt = Tpl.writeText(txt, l_prl__str);
        txt = Tpl.writeText(txt, l_var__str);
        txt = Tpl.writeText(txt, l_dir__str);
        txt = Tpl.writeText(txt, l_ct__str);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAttributes;

public function dumpConnectorType
  input Tpl.Text in_txt;
  input SCode.ConnectorType in_a_connectorType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_connectorType)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.FLOW() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("flow "));
      then txt;

    case ( txt,
           SCode.STREAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("stream "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpConnectorType;

public function dumpParallelism
  input Tpl.Text in_txt;
  input SCode.Parallelism in_a_parallelism;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_parallelism)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.PARGLOBAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parglobal "));
      then txt;

    case ( txt,
           SCode.PARLOCAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parlocal "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpParallelism;

public function dumpVariability
  input Tpl.Text in_txt;
  input SCode.Variability in_a_variability;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_variability)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.DISCRETE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("discrete "));
      then txt;

    case ( txt,
           SCode.PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parameter "));
      then txt;

    case ( txt,
           SCode.CONST() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpVariability;

public function dumpDirection
  input Tpl.Text in_txt;
  input Absyn.Direction in_a_direction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_direction)
    local
      Tpl.Text txt;

    case ( txt,
           Absyn.INPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("input "));
      then txt;

    case ( txt,
           Absyn.OUTPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpDirection;

public function dumpAttributeDim
  input Tpl.Text in_txt;
  input SCode.Attributes in_a_attributes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attributes)
    local
      Tpl.Text txt;
      Absyn.ArrayDim i_arrayDims;

    case ( txt,
           SCode.ATTR(arrayDims = i_arrayDims) )
      equation
        txt = AbsynDumpTpl.dumpSubscripts(txt, i_arrayDims);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAttributeDim;

public function dumpAnnotationOpt
  input Tpl.Text in_txt;
  input Option<SCode.Annotation> in_a_annotation;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_annotation, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Annotation i_ann;

    case ( txt,
           SOME(i_ann),
           a_options )
      equation
        txt = dumpAnnotation(txt, i_ann, a_options);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpAnnotationOpt;

protected function fun_121
  input Tpl.Text in_txt;
  input Tpl.Text in_a_modifStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modifStr)
    local
      Tpl.Text txt;
      Tpl.Text i_modifStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_modifStr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("annotation"));
        txt = Tpl.writeText(txt, i_modifStr);
      then txt;
  end match;
end fun_121;

public function dumpAnnotation
  input Tpl.Text in_txt;
  input SCode.Annotation in_a_annotation;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_annotation, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Mod i_modification;
      Tpl.Text l_modifStr;

    case ( txt,
           SCode.ANNOTATION(modification = i_modification),
           a_options )
      equation
        l_modifStr = dumpAnnotationModifier(Tpl.emptyTxt, i_modification, a_options);
        txt = fun_121(txt, l_modifStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpAnnotation;

protected function fun_123
  input Tpl.Text in_txt;
  input Tpl.Text in_a_annstr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_annstr)
    local
      Tpl.Text txt;
      Tpl.Text i_annstr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_annstr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, i_annstr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_123;

public function dumpAnnotationElement
  input Tpl.Text txt;
  input SCode.Annotation a_annotation;
  input SCodeDump.SCodeDumpOptions a_options;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_annstr;
algorithm
  l_annstr := dumpAnnotation(Tpl.emptyTxt, a_annotation, a_options);
  out_txt := fun_123(txt, l_annstr);
end dumpAnnotationElement;

public function dumpExternalDeclOpt
  input Tpl.Text in_txt;
  input Option<SCode.ExternalDecl> in_a_externalDecl;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_externalDecl, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.ExternalDecl i_extdecl;

    case ( txt,
           SOME(i_extdecl),
           a_options )
      equation
        txt = dumpExternalDecl(txt, i_extdecl, a_options);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpExternalDeclOpt;

protected function fun_126
  input Tpl.Text in_txt;
  input Option<SCode.Ident> in_a_funcName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_funcName)
    local
      Tpl.Text txt;
      SCode.Ident i_name;

    case ( txt,
           SOME(i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_126;

protected function lm_127
  input Tpl.Text in_txt;
  input list<Absyn.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Exp> rest;
      Absyn.Exp i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = AbsynDumpTpl.dumpExp(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_127(txt, rest);
      then txt;
  end match;
end lm_127;

protected function fun_128
  input Tpl.Text in_txt;
  input Tpl.Text in_a_func__name__str;
  input Tpl.Text in_a_func__args__str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_func__name__str, in_a_func__args__str)
    local
      Tpl.Text txt;
      Tpl.Text a_func__args__str;
      Tpl.Text i_func__name__str;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           i_func__name__str,
           a_func__args__str )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, i_func__name__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_func__args__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_128;

protected function fun_129
  input Tpl.Text in_txt;
  input Option<String> in_a_lang;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lang)
    local
      Tpl.Text txt;
      String i_l;

    case ( txt,
           SOME(i_l) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_l);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_129;

protected function fun_130
  input Tpl.Text in_txt;
  input Option<Absyn.ComponentRef> in_a_output__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_output__)
    local
      Tpl.Text txt;
      Absyn.ComponentRef i_name;

    case ( txt,
           SOME(i_name) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = AbsynDumpTpl.dumpCref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ="));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_130;

public function dumpExternalDecl
  input Tpl.Text in_txt;
  input SCode.ExternalDecl in_a_externalDecl;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_externalDecl, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      Option<Absyn.ComponentRef> i_output__;
      Option<SCode.Annotation> i_annotation__;
      Option<String> i_lang;
      list<Absyn.Exp> i_args;
      Option<SCode.Ident> i_funcName;
      Tpl.Text l_output__str;
      Tpl.Text l_ann__str;
      Tpl.Text l_lang__str;
      Tpl.Text l_func__str;
      Tpl.Text l_func__args__str;
      Tpl.Text l_func__name__str;

    case ( txt,
           SCode.EXTERNALDECL(funcName = i_funcName, args = i_args, lang = i_lang, annotation_ = i_annotation__, output_ = i_output__),
           a_options )
      equation
        l_func__name__str = fun_126(Tpl.emptyTxt, i_funcName);
        l_func__args__str = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_func__args__str = lm_127(l_func__args__str, i_args);
        l_func__args__str = Tpl.popIter(l_func__args__str);
        l_func__str = fun_128(Tpl.emptyTxt, l_func__name__str, l_func__args__str);
        l_lang__str = fun_129(Tpl.emptyTxt, i_lang);
        l_ann__str = dumpAnnotationOpt(Tpl.emptyTxt, i_annotation__, a_options);
        l_output__str = fun_130(Tpl.emptyTxt, i_output__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external"));
        txt = Tpl.writeText(txt, l_lang__str);
        txt = Tpl.writeText(txt, l_output__str);
        txt = Tpl.writeText(txt, l_func__str);
        txt = Tpl.writeText(txt, l_ann__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpExternalDecl;

public function dumpCommentOpt
  input Tpl.Text in_txt;
  input Option<SCode.Comment> in_a_comment;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      SCode.Comment i_cmt;

    case ( txt,
           SOME(i_cmt),
           a_options )
      equation
        txt = dumpComment(txt, i_cmt, a_options);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpCommentOpt;

public function dumpComment
  input Tpl.Text in_txt;
  input SCode.Comment in_a_comment;
  input SCodeDump.SCodeDumpOptions in_a_options;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment, in_a_options)
    local
      Tpl.Text txt;
      SCodeDump.SCodeDumpOptions a_options;
      Option<String> i_comment;
      Option<SCode.Annotation> i_annotation__;
      Tpl.Text l_cmt__str;
      Tpl.Text l_ann__str;

    case ( txt,
           SCode.COMMENT(annotation_ = i_annotation__, comment = i_comment),
           a_options )
      equation
        l_ann__str = dumpAnnotationOpt(Tpl.emptyTxt, i_annotation__, a_options);
        l_cmt__str = dumpCommentStr(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeText(txt, l_cmt__str);
        txt = Tpl.writeText(txt, l_ann__str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpComment;

public function dumpCommentStr
  input Tpl.Text in_txt;
  input Option<String> in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_cmt;
      String ret_0;

    case ( txt,
           SOME(i_cmt) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = System.escapedString(i_cmt, false);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpCommentStr;

public function errorMsg
  input Tpl.Text txt;
  input String a_errMessage;

  output Tpl.Text out_txt;
algorithm
  Tpl.addTemplateError(a_errMessage);
  out_txt := Tpl.writeStr(txt, a_errMessage);
end errorMsg;

annotation(__OpenModelica_Interface="frontend");
end SCodeDumpTpl;