// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// t-eobreeder.cpp
//   This program test the breeder object
// (c) GeNeura Team, 1998 
/* 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Contact: todos@geneura.ugr.es, http://geneura.ugr.es
            
*/
//-----------------------------------------------------------------------------

#ifndef __GNUG__
// to avoid long name warnings
#pragma warning(disable:4786)
#endif // __GNUG__

#include <ga/eoBin.h>  // eoBin, eoPop, eoBreeder
#include <eoPop.h>
#include <ga/eoBitOp.h>
#include <eoProportionalOpSel.h>
#include <eoBreeder.h>

//-----------------------------------------------------------------------------

typedef eoBin<float> Chrom;

#include "binary_value.h"

//-----------------------------------------------------------------------------

main()
{
  const unsigned POP_SIZE = 8, CHROM_SIZE = 4;
  unsigned i;

  eoBinRandom<Chrom> random;
  eoPop<Chrom> pop; 

  BinaryValue eval;
  
  for (i = 0; i < POP_SIZE; ++i)
    {
      Chrom chrom(CHROM_SIZE);
      random(chrom);
      eval(chrom);
      pop.push_back(chrom);
    }
  
  std::cout << "population:" << std::endl;
  for (i = 0; i < pop.size(); ++i)
    std::cout << pop[i] << " " << pop[i].fitness() << std::endl;

  eoBinBitFlip<Chrom> bitflip;
  eoBinCrossover<Chrom> xover;
  eoProportionalOpSel<Chrom> propSel;
  eoBreeder<Chrom> breeder( propSel );
  propSel.addOp(bitflip, 0.25);
  propSel.addOp(xover, 0.75);

  breeder(pop);

  // reevaluation of fitness 
  for_each(pop.begin(), pop.end(), BinaryValue());

  std::cout << "new population:" << std::endl;
  for (i = 0; i < pop.size(); ++i)
    std::cout << pop[i] << " " << pop[i].fitness() << std::endl;

  return 0;
}

//-----------------------------------------------------------------------------
