/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.basicRenderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.graphstream.graph.Element;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.swingViewer.util.Camera;
import org.graphstream.ui.swingViewer.util.DefaultCamera;
import org.graphstream.ui.swingViewer.util.FontCache;

public abstract class ElementRenderer {
    protected boolean hadEvents = false;
    protected Font textFont;
    protected Color textColor;
    protected int textSize;

    public void render(StyleGroup group, Graphics2D g, Camera camera) {
        GraphicElement ge;
        this.setupRenderingPass(group, g, camera);
        this.pushStyle(group, g, camera);
        for (Element element : group.bulkElements()) {
            ge = (GraphicElement)element;
            if (camera.isVisible(ge)) {
                this.renderElement(group, g, camera, ge);
                continue;
            }
            this.elementInvisible(group, g, camera, ge);
        }
        if (group.hasDynamicElements()) {
            for (Element element : group.dynamicElements()) {
                ge = (GraphicElement)element;
                if (camera.isVisible(ge)) {
                    if (group.elementHasEvents(ge)) continue;
                    this.pushDynStyle(group, g, camera, ge);
                    this.renderElement(group, g, camera, ge);
                    continue;
                }
                this.elementInvisible(group, g, camera, ge);
            }
        }
        if (group.hasEventElements()) {
            for (StyleGroup.ElementEvents elementEvents : group.elementsEvents()) {
                ge = (GraphicElement)elementEvents.getElement();
                if (camera.isVisible(ge)) {
                    elementEvents.activate();
                    this.pushStyle(group, g, camera);
                    this.renderElement(group, g, camera, ge);
                    elementEvents.deactivate();
                    continue;
                }
                this.elementInvisible(group, g, camera, ge);
            }
            this.hadEvents = true;
        } else {
            this.hadEvents = false;
        }
    }

    protected abstract void setupRenderingPass(StyleGroup var1, Graphics2D var2, Camera var3);

    protected abstract void pushStyle(StyleGroup var1, Graphics2D var2, Camera var3);

    protected abstract void pushDynStyle(StyleGroup var1, Graphics2D var2, Camera var3, GraphicElement var4);

    protected abstract void renderElement(StyleGroup var1, Graphics2D var2, Camera var3, GraphicElement var4);

    protected abstract void elementInvisible(StyleGroup var1, Graphics2D var2, Camera var3, GraphicElement var4);

    protected void configureText(StyleGroup group, Camera camera) {
        String fontName = group.getTextFont();
        StyleConstants.TextStyle textStyle = group.getTextStyle();
        this.textSize = (int)group.getTextSize().value;
        this.textColor = group.getTextColor(0);
        this.textFont = FontCache.defaultFontCache().getFont(fontName, textStyle, this.textSize);
    }

    protected void renderText(StyleGroup group, Graphics2D g, Camera camera, GraphicElement element) {
        String label = element.getLabel();
        if (label != null && group.getTextMode() != StyleConstants.TextMode.HIDDEN && group.getTextVisibilityMode() != StyleConstants.TextVisibilityMode.HIDDEN) {
            double w;
            Point3 p = null;
            GraphicSprite s = null;
            Point2D.Double pos = null;
            if (element instanceof GraphicSprite) {
                s = (GraphicSprite)element;
                pos = ((DefaultCamera)camera).getSpritePosition(s, new Point2D.Double(), StyleConstants.Units.GU);
            }
            if (pos != null && s.getUnits() == StyleConstants.Units.PX) {
                w = camera.getMetrics().lengthToPx(group.getSize(), 0);
                p = camera.transformGuToPx(pos.x, pos.y, 0.0);
                p.x += w / 2.0;
            } else if (s != null && s.getUnits() == StyleConstants.Units.PERCENTS) {
                w = camera.getMetrics().lengthToPx(group.getSize(), 0);
                p = camera.transformGuToPx(camera.getMetrics().viewport[2] * pos.x, camera.getMetrics().viewport[3] * pos.y, 0.0);
                p.x += w / 2.0;
            } else {
                w = camera.getMetrics().lengthToGu(group.getSize(), 0);
                p = camera.transformGuToPx(element.getX() + w / 2.0, element.getY(), 0.0);
            }
            AffineTransform Tx = g.getTransform();
            Color c = g.getColor();
            g.setColor(this.textColor);
            g.setFont(this.textFont);
            g.setTransform(new AffineTransform());
            g.drawString(label, (float)p.x, (float)(p.y + (double)(this.textSize / 3)));
            g.setTransform(Tx);
            g.setColor(c);
        }
    }

    protected Color interpolateColor(StyleGroup group, GraphicElement element) {
        Color color = group.getFillColor(0);
        int n = group.getFillColorCount();
        if (n > 1) {
            if (element.hasNumber("ui.color") && n > 1) {
                double value = element.getNumber("ui.color");
                if (value < 0.0) {
                    value = 0.0;
                } else if (value > 1.0) {
                    value = 1.0;
                }
                if (value == 1.0) {
                    color = group.getFillColor(n - 1);
                } else if (value != 0.0) {
                    double div = 1.0f / (float)(n - 1);
                    int col = (int)(value / div);
                    div = (value - div * (double)col) / div;
                    Color color0 = group.getFillColor(col);
                    Color color1 = group.getFillColor(col + 1);
                    double red = ((double)color0.getRed() * (1.0 - div) + (double)color1.getRed() * div) / 255.0;
                    double green = ((double)color0.getGreen() * (1.0 - div) + (double)color1.getGreen() * div) / 255.0;
                    double blue = ((double)color0.getBlue() * (1.0 - div) + (double)color1.getBlue() * div) / 255.0;
                    double alpha = ((double)color0.getAlpha() * (1.0 - div) + (double)color1.getAlpha() * div) / 255.0;
                    color = new Color((float)red, (float)green, (float)blue, (float)alpha);
                }
            } else if (element.hasAttribute("ui.color", Color.class)) {
                color = (Color)element.getAttribute("ui.color");
            }
        } else if (element.hasAttribute("ui.color", Color.class)) {
            color = (Color)element.getAttribute("ui.color");
        }
        return color;
    }
}

