#ifndef OpenModelicaScriptingAPI__H
#define OpenModelicaScriptingAPI__H
#include "meta/meta_modelica.h"
#include "util/modelica.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#ifdef __cplusplus
extern "C" {
#endif

extern struct record_description Absyn_CodeNode_C__TYPENAME__desc;

extern struct record_description Absyn_Msg_MSG__desc;

extern struct record_description SourceInfo_SOURCEINFO__desc;

extern struct record_description Values_Value_BOOL__desc;

extern struct record_description Values_Value_CODE__desc;

extern struct record_description Values_Value_INTEGER__desc;

extern struct record_description Values_Value_REAL__desc;

extern struct record_description Values_Value_STRING__desc;


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_loadFile(threadData_t *threadData, modelica_string _fileName, modelica_string _encoding, modelica_boolean _uses, modelica_boolean _notify, modelica_boolean _requireExactVersion, modelica_boolean _allowWithin);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_loadFile(threadData_t *threadData, modelica_metatype _fileName, modelica_metatype _encoding, modelica_metatype _uses, modelica_metatype _notify, modelica_metatype _requireExactVersion, modelica_metatype _allowWithin);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadFile,0}};
#define boxvar_OpenModelicaScriptingAPI_loadFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFile)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_loadFiles(threadData_t *threadData, modelica_metatype _fileNames, modelica_string _encoding, modelica_integer _numThreads, modelica_boolean _uses, modelica_boolean _notify, modelica_boolean _requireExactVersion, modelica_boolean _allowWithin);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_loadFiles(threadData_t *threadData, modelica_metatype _fileNames, modelica_metatype _encoding, modelica_metatype _numThreads, modelica_metatype _uses, modelica_metatype _notify, modelica_metatype _requireExactVersion, modelica_metatype _allowWithin);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFiles,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadFiles,0}};
#define boxvar_OpenModelicaScriptingAPI_loadFiles MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFiles)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_parseEncryptedPackage(threadData_t *threadData, modelica_string _fileName, modelica_string _workdir);
#define boxptr_OpenModelicaScriptingAPI_parseEncryptedPackage omc_OpenModelicaScriptingAPI_parseEncryptedPackage
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_parseEncryptedPackage,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_parseEncryptedPackage,0}};
#define boxvar_OpenModelicaScriptingAPI_parseEncryptedPackage MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_parseEncryptedPackage)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_loadEncryptedPackage(threadData_t *threadData, modelica_string _fileName, modelica_string _workdir, modelica_boolean _skipUnzip, modelica_boolean _uses, modelica_boolean _notify, modelica_boolean _requireExactVersion);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_loadEncryptedPackage(threadData_t *threadData, modelica_metatype _fileName, modelica_metatype _workdir, modelica_metatype _skipUnzip, modelica_metatype _uses, modelica_metatype _notify, modelica_metatype _requireExactVersion);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadEncryptedPackage,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadEncryptedPackage,0}};
#define boxvar_OpenModelicaScriptingAPI_loadEncryptedPackage MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadEncryptedPackage)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_reloadClass(threadData_t *threadData, modelica_string _name, modelica_string _encoding);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_reloadClass(threadData_t *threadData, modelica_metatype _name, modelica_metatype _encoding);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_reloadClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_reloadClass,0}};
#define boxvar_OpenModelicaScriptingAPI_reloadClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_reloadClass)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_loadString(threadData_t *threadData, modelica_string _data, modelica_string _filename, modelica_string _encoding, modelica_boolean _merge, modelica_boolean _uses, modelica_boolean _notify, modelica_boolean _requireExactVersion);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_loadString(threadData_t *threadData, modelica_metatype _data, modelica_metatype _filename, modelica_metatype _encoding, modelica_metatype _merge, modelica_metatype _uses, modelica_metatype _notify, modelica_metatype _requireExactVersion);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadString,0}};
#define boxvar_OpenModelicaScriptingAPI_loadString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadString)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_loadClassContentString(threadData_t *threadData, modelica_string _data, modelica_string _className, modelica_integer _offsetX, modelica_integer _offsetY);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_loadClassContentString(threadData_t *threadData, modelica_metatype _data, modelica_metatype _className, modelica_metatype _offsetX, modelica_metatype _offsetY);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadClassContentString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadClassContentString,0}};
#define boxvar_OpenModelicaScriptingAPI_loadClassContentString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadClassContentString)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_parseString(threadData_t *threadData, modelica_string _data, modelica_string _filename);
#define boxptr_OpenModelicaScriptingAPI_parseString omc_OpenModelicaScriptingAPI_parseString
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_parseString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_parseString,0}};
#define boxvar_OpenModelicaScriptingAPI_parseString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_parseString)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_parseFile(threadData_t *threadData, modelica_string _filename, modelica_string _encoding);
#define boxptr_OpenModelicaScriptingAPI_parseFile omc_OpenModelicaScriptingAPI_parseFile
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_parseFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_parseFile,0}};
#define boxvar_OpenModelicaScriptingAPI_parseFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_parseFile)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_loadFileInteractiveQualified(threadData_t *threadData, modelica_string _filename, modelica_string _encoding);
#define boxptr_OpenModelicaScriptingAPI_loadFileInteractiveQualified omc_OpenModelicaScriptingAPI_loadFileInteractiveQualified
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFileInteractiveQualified,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadFileInteractiveQualified,0}};
#define boxvar_OpenModelicaScriptingAPI_loadFileInteractiveQualified MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFileInteractiveQualified)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_loadFileInteractive(threadData_t *threadData, modelica_string _filename, modelica_string _encoding, modelica_boolean _uses, modelica_boolean _notify, modelica_boolean _requireExactVersion);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_loadFileInteractive(threadData_t *threadData, modelica_metatype _filename, modelica_metatype _encoding, modelica_metatype _uses, modelica_metatype _notify, modelica_metatype _requireExactVersion);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFileInteractive,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadFileInteractive,0}};
#define boxvar_OpenModelicaScriptingAPI_loadFileInteractive MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadFileInteractive)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_system(threadData_t *threadData, modelica_string _callStr, modelica_string _outputFile);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_system(threadData_t *threadData, modelica_metatype _callStr, modelica_metatype _outputFile);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_system,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_system,0}};
#define boxvar_OpenModelicaScriptingAPI_system MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_system)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_system__parallel(threadData_t *threadData, modelica_metatype _callStr, modelica_integer _numThreads);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_system__parallel(threadData_t *threadData, modelica_metatype _callStr, modelica_metatype _numThreads);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_system__parallel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_system__parallel,0}};
#define boxvar_OpenModelicaScriptingAPI_system__parallel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_system__parallel)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_saveAll(threadData_t *threadData, modelica_string _fileName);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_saveAll(threadData_t *threadData, modelica_metatype _fileName);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveAll,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_saveAll,0}};
#define boxvar_OpenModelicaScriptingAPI_saveAll MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveAll)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_help(threadData_t *threadData, modelica_string _topic);
#define boxptr_OpenModelicaScriptingAPI_help omc_OpenModelicaScriptingAPI_help
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_help,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_help,0}};
#define boxvar_OpenModelicaScriptingAPI_help MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_help)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_clear(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_clear(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clear,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_clear,0}};
#define boxvar_OpenModelicaScriptingAPI_clear MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clear)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_clearProgram(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_clearProgram(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearProgram,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_clearProgram,0}};
#define boxvar_OpenModelicaScriptingAPI_clearProgram MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearProgram)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_clearVariables(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_clearVariables(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearVariables,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_clearVariables,0}};
#define boxvar_OpenModelicaScriptingAPI_clearVariables MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearVariables)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_generateHeader(threadData_t *threadData, modelica_string _fileName);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_generateHeader(threadData_t *threadData, modelica_metatype _fileName);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateHeader,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateHeader,0}};
#define boxvar_OpenModelicaScriptingAPI_generateHeader MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateHeader)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_generateJuliaHeader(threadData_t *threadData, modelica_string _fileName);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_generateJuliaHeader(threadData_t *threadData, modelica_metatype _fileName);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateJuliaHeader,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateJuliaHeader,0}};
#define boxvar_OpenModelicaScriptingAPI_generateJuliaHeader MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateJuliaHeader)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_generateSeparateCode(threadData_t *threadData, modelica_string _className, modelica_boolean _cleanCache);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_generateSeparateCode(threadData_t *threadData, modelica_metatype _className, modelica_metatype _cleanCache);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateSeparateCode,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateSeparateCode,0}};
#define boxvar_OpenModelicaScriptingAPI_generateSeparateCode MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateSeparateCode)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_generateSeparateCodeDependencies(threadData_t *threadData, modelica_string _stampSuffix);
#define boxptr_OpenModelicaScriptingAPI_generateSeparateCodeDependencies omc_OpenModelicaScriptingAPI_generateSeparateCodeDependencies
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateSeparateCodeDependencies,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateSeparateCodeDependencies,0}};
#define boxvar_OpenModelicaScriptingAPI_generateSeparateCodeDependencies MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateSeparateCodeDependencies)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_generateSeparateCodeDependenciesMakefile(threadData_t *threadData, modelica_string _filename, modelica_string _directory, modelica_string _suffix);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_generateSeparateCodeDependenciesMakefile(threadData_t *threadData, modelica_metatype _filename, modelica_metatype _directory, modelica_metatype _suffix);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateSeparateCodeDependenciesMakefile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateSeparateCodeDependenciesMakefile,0}};
#define boxvar_OpenModelicaScriptingAPI_generateSeparateCodeDependenciesMakefile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateSeparateCodeDependenciesMakefile)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getLinker(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getLinker omc_OpenModelicaScriptingAPI_getLinker
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLinker,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getLinker,0}};
#define boxvar_OpenModelicaScriptingAPI_getLinker MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLinker)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setLinker(threadData_t *threadData, modelica_string _linker);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setLinker(threadData_t *threadData, modelica_metatype _linker);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setLinker,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setLinker,0}};
#define boxvar_OpenModelicaScriptingAPI_setLinker MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setLinker)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getLinkerFlags(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getLinkerFlags omc_OpenModelicaScriptingAPI_getLinkerFlags
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLinkerFlags,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getLinkerFlags,0}};
#define boxvar_OpenModelicaScriptingAPI_getLinkerFlags MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLinkerFlags)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setLinkerFlags(threadData_t *threadData, modelica_string _linkerFlags);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setLinkerFlags(threadData_t *threadData, modelica_metatype _linkerFlags);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setLinkerFlags,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setLinkerFlags,0}};
#define boxvar_OpenModelicaScriptingAPI_setLinkerFlags MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setLinkerFlags)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getCompiler(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getCompiler omc_OpenModelicaScriptingAPI_getCompiler
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCompiler,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getCompiler,0}};
#define boxvar_OpenModelicaScriptingAPI_getCompiler MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCompiler)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setCompiler(threadData_t *threadData, modelica_string _compiler);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setCompiler(threadData_t *threadData, modelica_metatype _compiler);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCompiler,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setCompiler,0}};
#define boxvar_OpenModelicaScriptingAPI_setCompiler MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCompiler)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getCFlags(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getCFlags omc_OpenModelicaScriptingAPI_getCFlags
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCFlags,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getCFlags,0}};
#define boxvar_OpenModelicaScriptingAPI_getCFlags MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCFlags)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setCFlags(threadData_t *threadData, modelica_string _inString);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setCFlags(threadData_t *threadData, modelica_metatype _inString);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCFlags,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setCFlags,0}};
#define boxvar_OpenModelicaScriptingAPI_setCFlags MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCFlags)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getCXXCompiler(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getCXXCompiler omc_OpenModelicaScriptingAPI_getCXXCompiler
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCXXCompiler,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getCXXCompiler,0}};
#define boxvar_OpenModelicaScriptingAPI_getCXXCompiler MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCXXCompiler)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setCXXCompiler(threadData_t *threadData, modelica_string _compiler);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setCXXCompiler(threadData_t *threadData, modelica_metatype _compiler);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCXXCompiler,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setCXXCompiler,0}};
#define boxvar_OpenModelicaScriptingAPI_setCXXCompiler MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCXXCompiler)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setTempDirectoryPath(threadData_t *threadData, modelica_string _tempDirectoryPath);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setTempDirectoryPath(threadData_t *threadData, modelica_metatype _tempDirectoryPath);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setTempDirectoryPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setTempDirectoryPath,0}};
#define boxvar_OpenModelicaScriptingAPI_setTempDirectoryPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setTempDirectoryPath)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getTempDirectoryPath(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getTempDirectoryPath omc_OpenModelicaScriptingAPI_getTempDirectoryPath
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTempDirectoryPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getTempDirectoryPath,0}};
#define boxvar_OpenModelicaScriptingAPI_getTempDirectoryPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTempDirectoryPath)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getEnvironmentVar(threadData_t *threadData, modelica_string _var);
#define boxptr_OpenModelicaScriptingAPI_getEnvironmentVar omc_OpenModelicaScriptingAPI_getEnvironmentVar
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEnvironmentVar,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getEnvironmentVar,0}};
#define boxvar_OpenModelicaScriptingAPI_getEnvironmentVar MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEnvironmentVar)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setEnvironmentVar(threadData_t *threadData, modelica_string _var, modelica_string _value);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setEnvironmentVar(threadData_t *threadData, modelica_metatype _var, modelica_metatype _value);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setEnvironmentVar,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setEnvironmentVar,0}};
#define boxvar_OpenModelicaScriptingAPI_setEnvironmentVar MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setEnvironmentVar)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setInstallationDirectoryPath(threadData_t *threadData, modelica_string _installationDirectoryPath);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setInstallationDirectoryPath(threadData_t *threadData, modelica_metatype _installationDirectoryPath);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setInstallationDirectoryPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setInstallationDirectoryPath,0}};
#define boxvar_OpenModelicaScriptingAPI_setInstallationDirectoryPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setInstallationDirectoryPath)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getInstallationDirectoryPath(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getInstallationDirectoryPath omc_OpenModelicaScriptingAPI_getInstallationDirectoryPath
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInstallationDirectoryPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInstallationDirectoryPath,0}};
#define boxvar_OpenModelicaScriptingAPI_getInstallationDirectoryPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInstallationDirectoryPath)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setModelicaPath(threadData_t *threadData, modelica_string _modelicaPath);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setModelicaPath(threadData_t *threadData, modelica_metatype _modelicaPath);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setModelicaPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setModelicaPath,0}};
#define boxvar_OpenModelicaScriptingAPI_setModelicaPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setModelicaPath)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getModelicaPath(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getModelicaPath omc_OpenModelicaScriptingAPI_getModelicaPath
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getModelicaPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getModelicaPath,0}};
#define boxvar_OpenModelicaScriptingAPI_getModelicaPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getModelicaPath)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getHomeDirectoryPath(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getHomeDirectoryPath omc_OpenModelicaScriptingAPI_getHomeDirectoryPath
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getHomeDirectoryPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getHomeDirectoryPath,0}};
#define boxvar_OpenModelicaScriptingAPI_getHomeDirectoryPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getHomeDirectoryPath)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setCompilerFlags(threadData_t *threadData, modelica_string _compilerFlags);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setCompilerFlags(threadData_t *threadData, modelica_metatype _compilerFlags);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCompilerFlags,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setCompilerFlags,0}};
#define boxvar_OpenModelicaScriptingAPI_setCompilerFlags MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCompilerFlags)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_enableNewInstantiation(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_enableNewInstantiation(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_enableNewInstantiation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_enableNewInstantiation,0}};
#define boxvar_OpenModelicaScriptingAPI_enableNewInstantiation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_enableNewInstantiation)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_disableNewInstantiation(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_disableNewInstantiation(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_disableNewInstantiation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_disableNewInstantiation,0}};
#define boxvar_OpenModelicaScriptingAPI_disableNewInstantiation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_disableNewInstantiation)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_clearDebugFlags(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_clearDebugFlags(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearDebugFlags,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_clearDebugFlags,0}};
#define boxvar_OpenModelicaScriptingAPI_clearDebugFlags MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearDebugFlags)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getMatchingAlgorithm(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getMatchingAlgorithm omc_OpenModelicaScriptingAPI_getMatchingAlgorithm
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getMatchingAlgorithm,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getMatchingAlgorithm,0}};
#define boxvar_OpenModelicaScriptingAPI_getMatchingAlgorithm MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getMatchingAlgorithm)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms(threadData_t *threadData, modelica_metatype *out_res2);
#define boxptr_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms omc_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms,0}};
#define boxvar_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableMatchingAlgorithms)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getIndexReductionMethod(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getIndexReductionMethod omc_OpenModelicaScriptingAPI_getIndexReductionMethod
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getIndexReductionMethod,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getIndexReductionMethod,0}};
#define boxvar_OpenModelicaScriptingAPI_getIndexReductionMethod MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getIndexReductionMethod)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods(threadData_t *threadData, modelica_metatype *out_res2);
#define boxptr_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods omc_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods,0}};
#define boxvar_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableIndexReductionMethods)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getTearingMethod(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getTearingMethod omc_OpenModelicaScriptingAPI_getTearingMethod
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTearingMethod,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getTearingMethod,0}};
#define boxvar_OpenModelicaScriptingAPI_getTearingMethod MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTearingMethod)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getAvailableTearingMethods(threadData_t *threadData, modelica_metatype *out_res2);
#define boxptr_OpenModelicaScriptingAPI_getAvailableTearingMethods omc_OpenModelicaScriptingAPI_getAvailableTearingMethods
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableTearingMethods,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAvailableTearingMethods,0}};
#define boxvar_OpenModelicaScriptingAPI_getAvailableTearingMethods MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableTearingMethods)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setCommandLineOptions(threadData_t *threadData, modelica_string _options);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setCommandLineOptions(threadData_t *threadData, modelica_metatype _options);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCommandLineOptions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setCommandLineOptions,0}};
#define boxvar_OpenModelicaScriptingAPI_setCommandLineOptions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setCommandLineOptions)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getCommandLineOptions(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getCommandLineOptions omc_OpenModelicaScriptingAPI_getCommandLineOptions
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCommandLineOptions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getCommandLineOptions,0}};
#define boxvar_OpenModelicaScriptingAPI_getCommandLineOptions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getCommandLineOptions)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getConfigFlagValidOptions(threadData_t *threadData, modelica_string _flag, modelica_string *out_res2, modelica_metatype *out_res3);
#define boxptr_OpenModelicaScriptingAPI_getConfigFlagValidOptions omc_OpenModelicaScriptingAPI_getConfigFlagValidOptions
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getConfigFlagValidOptions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getConfigFlagValidOptions,0}};
#define boxvar_OpenModelicaScriptingAPI_getConfigFlagValidOptions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getConfigFlagValidOptions)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_clearCommandLineOptions(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_clearCommandLineOptions(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearCommandLineOptions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_clearCommandLineOptions,0}};
#define boxvar_OpenModelicaScriptingAPI_clearCommandLineOptions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearCommandLineOptions)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getVersion(threadData_t *threadData, modelica_string _cl);
#define boxptr_OpenModelicaScriptingAPI_getVersion omc_OpenModelicaScriptingAPI_getVersion
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getVersion,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getVersion,0}};
#define boxvar_OpenModelicaScriptingAPI_getVersion MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getVersion)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_regularFileExists(threadData_t *threadData, modelica_string _fileName);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_regularFileExists(threadData_t *threadData, modelica_metatype _fileName);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_regularFileExists,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_regularFileExists,0}};
#define boxvar_OpenModelicaScriptingAPI_regularFileExists MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_regularFileExists)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_directoryExists(threadData_t *threadData, modelica_string _dirName);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_directoryExists(threadData_t *threadData, modelica_metatype _dirName);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_directoryExists,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_directoryExists,0}};
#define boxvar_OpenModelicaScriptingAPI_directoryExists MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_directoryExists)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_stat(threadData_t *threadData, modelica_string _fileName, modelica_real *out_res2, modelica_real *out_res3);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_stat(threadData_t *threadData, modelica_metatype _fileName, modelica_metatype *out_res2, modelica_metatype *out_res3);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_stat,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_stat,0}};
#define boxvar_OpenModelicaScriptingAPI_stat MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_stat)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_readFile(threadData_t *threadData, modelica_string _fileName);
#define boxptr_OpenModelicaScriptingAPI_readFile omc_OpenModelicaScriptingAPI_readFile
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_readFile,0}};
#define boxvar_OpenModelicaScriptingAPI_readFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readFile)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_writeFile(threadData_t *threadData, modelica_string _fileName, modelica_string _data, modelica_boolean _append);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_writeFile(threadData_t *threadData, modelica_metatype _fileName, modelica_metatype _data, modelica_metatype _append);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_writeFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_writeFile,0}};
#define boxvar_OpenModelicaScriptingAPI_writeFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_writeFile)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_compareFilesAndMove(threadData_t *threadData, modelica_string _newFile, modelica_string _oldFile);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_compareFilesAndMove(threadData_t *threadData, modelica_metatype _newFile, modelica_metatype _oldFile);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_compareFilesAndMove,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_compareFilesAndMove,0}};
#define boxvar_OpenModelicaScriptingAPI_compareFilesAndMove MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_compareFilesAndMove)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_compareFiles(threadData_t *threadData, modelica_string _file1, modelica_string _file2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_compareFiles(threadData_t *threadData, modelica_metatype _file1, modelica_metatype _file2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_compareFiles,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_compareFiles,0}};
#define boxvar_OpenModelicaScriptingAPI_compareFiles MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_compareFiles)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_alarm(threadData_t *threadData, modelica_integer _seconds);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_alarm(threadData_t *threadData, modelica_metatype _seconds);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_alarm,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_alarm,0}};
#define boxvar_OpenModelicaScriptingAPI_alarm MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_alarm)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getErrorString(threadData_t *threadData, modelica_boolean _warningsAsErrors);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getErrorString(threadData_t *threadData, modelica_metatype _warningsAsErrors);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getErrorString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getErrorString,0}};
#define boxvar_OpenModelicaScriptingAPI_getErrorString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getErrorString)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_countMessages(threadData_t *threadData, modelica_integer *out_res2, modelica_integer *out_res3);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_countMessages(threadData_t *threadData, modelica_metatype *out_res2, modelica_metatype *out_res3);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_countMessages,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_countMessages,0}};
#define boxvar_OpenModelicaScriptingAPI_countMessages MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_countMessages)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_clearMessages(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_clearMessages(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearMessages,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_clearMessages,0}};
#define boxvar_OpenModelicaScriptingAPI_clearMessages MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_clearMessages)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_runScript(threadData_t *threadData, modelica_string _fileName);
#define boxptr_OpenModelicaScriptingAPI_runScript omc_OpenModelicaScriptingAPI_runScript
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_runScript,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_runScript,0}};
#define boxvar_OpenModelicaScriptingAPI_runScript MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_runScript)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_echo(threadData_t *threadData, modelica_boolean _setEcho);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_echo(threadData_t *threadData, modelica_metatype _setEcho);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_echo,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_echo,0}};
#define boxvar_OpenModelicaScriptingAPI_echo MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_echo)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getAnnotationVersion(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getAnnotationVersion omc_OpenModelicaScriptingAPI_getAnnotationVersion
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAnnotationVersion,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAnnotationVersion,0}};
#define boxvar_OpenModelicaScriptingAPI_getAnnotationVersion MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAnnotationVersion)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_getNoSimplify(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNoSimplify(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNoSimplify,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNoSimplify,0}};
#define boxvar_OpenModelicaScriptingAPI_getNoSimplify MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNoSimplify)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setNoSimplify(threadData_t *threadData, modelica_boolean _noSimplify);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setNoSimplify(threadData_t *threadData, modelica_metatype _noSimplify);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setNoSimplify,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setNoSimplify,0}};
#define boxvar_OpenModelicaScriptingAPI_setNoSimplify MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setNoSimplify)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getVectorizationLimit(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getVectorizationLimit(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getVectorizationLimit,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getVectorizationLimit,0}};
#define boxvar_OpenModelicaScriptingAPI_getVectorizationLimit MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getVectorizationLimit)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getDefaultOpenCLDevice(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getDefaultOpenCLDevice(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDefaultOpenCLDevice,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getDefaultOpenCLDevice,0}};
#define boxvar_OpenModelicaScriptingAPI_getDefaultOpenCLDevice MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDefaultOpenCLDevice)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setShowAnnotations(threadData_t *threadData, modelica_boolean _show);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setShowAnnotations(threadData_t *threadData, modelica_metatype _show);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setShowAnnotations,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setShowAnnotations,0}};
#define boxvar_OpenModelicaScriptingAPI_setShowAnnotations MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setShowAnnotations)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_getShowAnnotations(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getShowAnnotations(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getShowAnnotations,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getShowAnnotations,0}};
#define boxvar_OpenModelicaScriptingAPI_getShowAnnotations MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getShowAnnotations)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_getOrderConnections(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getOrderConnections(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getOrderConnections,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getOrderConnections,0}};
#define boxvar_OpenModelicaScriptingAPI_getOrderConnections MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getOrderConnections)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getLanguageStandard(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getLanguageStandard omc_OpenModelicaScriptingAPI_getLanguageStandard
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLanguageStandard,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getLanguageStandard,0}};
#define boxvar_OpenModelicaScriptingAPI_getLanguageStandard MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLanguageStandard)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getAstAsCorbaString(threadData_t *threadData, modelica_string _fileName);
#define boxptr_OpenModelicaScriptingAPI_getAstAsCorbaString omc_OpenModelicaScriptingAPI_getAstAsCorbaString
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAstAsCorbaString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAstAsCorbaString,0}};
#define boxvar_OpenModelicaScriptingAPI_getAstAsCorbaString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAstAsCorbaString)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_cd(threadData_t *threadData, modelica_string _newWorkingDirectory);
#define boxptr_OpenModelicaScriptingAPI_cd omc_OpenModelicaScriptingAPI_cd
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_cd,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_cd,0}};
#define boxvar_OpenModelicaScriptingAPI_cd MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_cd)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_mkdir(threadData_t *threadData, modelica_string _newDirectory);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_mkdir(threadData_t *threadData, modelica_metatype _newDirectory);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_mkdir,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_mkdir,0}};
#define boxvar_OpenModelicaScriptingAPI_mkdir MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_mkdir)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_copy(threadData_t *threadData, modelica_string _source, modelica_string _destination);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_copy(threadData_t *threadData, modelica_metatype _source, modelica_metatype _destination);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_copy,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_copy,0}};
#define boxvar_OpenModelicaScriptingAPI_copy MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_copy)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_remove(threadData_t *threadData, modelica_string _path);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_remove(threadData_t *threadData, modelica_metatype _path);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_remove,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_remove,0}};
#define boxvar_OpenModelicaScriptingAPI_remove MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_remove)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_checkModel(threadData_t *threadData, modelica_string _className);
#define boxptr_OpenModelicaScriptingAPI_checkModel omc_OpenModelicaScriptingAPI_checkModel
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_checkModel,0}};
#define boxvar_OpenModelicaScriptingAPI_checkModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkModel)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_checkAllModelsRecursive(threadData_t *threadData, modelica_string _className, modelica_boolean _checkProtected);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_checkAllModelsRecursive(threadData_t *threadData, modelica_metatype _className, modelica_metatype _checkProtected);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkAllModelsRecursive,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_checkAllModelsRecursive,0}};
#define boxvar_OpenModelicaScriptingAPI_checkAllModelsRecursive MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkAllModelsRecursive)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_instantiateModel(threadData_t *threadData, modelica_string _className);
#define boxptr_OpenModelicaScriptingAPI_instantiateModel omc_OpenModelicaScriptingAPI_instantiateModel
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_instantiateModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_instantiateModel,0}};
#define boxvar_OpenModelicaScriptingAPI_instantiateModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_instantiateModel)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_generateCode(threadData_t *threadData, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_generateCode(threadData_t *threadData, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateCode,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateCode,0}};
#define boxvar_OpenModelicaScriptingAPI_generateCode MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateCode)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_loadModel(threadData_t *threadData, modelica_string _className, modelica_metatype _priorityVersion, modelica_boolean _notify, modelica_string _languageStandard, modelica_boolean _requireExactVersion);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_loadModel(threadData_t *threadData, modelica_metatype _className, modelica_metatype _priorityVersion, modelica_metatype _notify, modelica_metatype _languageStandard, modelica_metatype _requireExactVersion);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadModel,0}};
#define boxvar_OpenModelicaScriptingAPI_loadModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadModel)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_deleteFile(threadData_t *threadData, modelica_string _fileName);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_deleteFile(threadData_t *threadData, modelica_metatype _fileName);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deleteFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_deleteFile,0}};
#define boxvar_OpenModelicaScriptingAPI_deleteFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deleteFile)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_saveModel(threadData_t *threadData, modelica_string _fileName, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_saveModel(threadData_t *threadData, modelica_metatype _fileName, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_saveModel,0}};
#define boxvar_OpenModelicaScriptingAPI_saveModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveModel)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_saveTotalModel(threadData_t *threadData, modelica_string _fileName, modelica_string _className, modelica_boolean _stripAnnotations, modelica_boolean _stripComments, modelica_boolean _obfuscate);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_saveTotalModel(threadData_t *threadData, modelica_metatype _fileName, modelica_metatype _className, modelica_metatype _stripAnnotations, modelica_metatype _stripComments, modelica_metatype _obfuscate);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveTotalModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_saveTotalModel,0}};
#define boxvar_OpenModelicaScriptingAPI_saveTotalModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveTotalModel)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_saveTotalModelDebug(threadData_t *threadData, modelica_string _filename, modelica_string _className, modelica_boolean _stripAnnotations, modelica_boolean _stripComments, modelica_boolean _obfuscate);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_saveTotalModelDebug(threadData_t *threadData, modelica_metatype _filename, modelica_metatype _className, modelica_metatype _stripAnnotations, modelica_metatype _stripComments, modelica_metatype _obfuscate);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveTotalModelDebug,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_saveTotalModelDebug,0}};
#define boxvar_OpenModelicaScriptingAPI_saveTotalModelDebug MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_saveTotalModelDebug)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_save(threadData_t *threadData, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_save(threadData_t *threadData, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_save,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_save,0}};
#define boxvar_OpenModelicaScriptingAPI_save MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_save)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_translateGraphics(threadData_t *threadData, modelica_string _className);
#define boxptr_OpenModelicaScriptingAPI_translateGraphics omc_OpenModelicaScriptingAPI_translateGraphics
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_translateGraphics,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_translateGraphics,0}};
#define boxvar_OpenModelicaScriptingAPI_translateGraphics MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_translateGraphics)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_dumpXMLDAE(threadData_t *threadData, modelica_string _className, modelica_string _translationLevel, modelica_boolean _addOriginalAdjacencyMatrix, modelica_boolean _addSolvingInfo, modelica_boolean _addMathMLCode, modelica_boolean _dumpResiduals, modelica_string _fileNamePrefix, modelica_string _rewriteRulesFile, modelica_string *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_dumpXMLDAE(threadData_t *threadData, modelica_metatype _className, modelica_metatype _translationLevel, modelica_metatype _addOriginalAdjacencyMatrix, modelica_metatype _addSolvingInfo, modelica_metatype _addMathMLCode, modelica_metatype _dumpResiduals, modelica_metatype _fileNamePrefix, modelica_metatype _rewriteRulesFile, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_dumpXMLDAE,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_dumpXMLDAE,0}};
#define boxvar_OpenModelicaScriptingAPI_dumpXMLDAE MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_dumpXMLDAE)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_convertUnits(threadData_t *threadData, modelica_string _s1, modelica_string _s2, modelica_real *out_res2, modelica_real *out_res3);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_convertUnits(threadData_t *threadData, modelica_metatype _s1, modelica_metatype _s2, modelica_metatype *out_res2, modelica_metatype *out_res3);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_convertUnits,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_convertUnits,0}};
#define boxvar_OpenModelicaScriptingAPI_convertUnits MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_convertUnits)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getDerivedUnits(threadData_t *threadData, modelica_string _baseUnit);
#define boxptr_OpenModelicaScriptingAPI_getDerivedUnits omc_OpenModelicaScriptingAPI_getDerivedUnits
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDerivedUnits,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getDerivedUnits,0}};
#define boxvar_OpenModelicaScriptingAPI_getDerivedUnits MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDerivedUnits)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_listVariables(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_listVariables omc_OpenModelicaScriptingAPI_listVariables
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_listVariables,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_listVariables,0}};
#define boxvar_OpenModelicaScriptingAPI_listVariables MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_listVariables)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_strtok(threadData_t *threadData, modelica_string _string, modelica_string _token);
#define boxptr_OpenModelicaScriptingAPI_strtok omc_OpenModelicaScriptingAPI_strtok
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_strtok,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_strtok,0}};
#define boxvar_OpenModelicaScriptingAPI_strtok MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_strtok)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_stringSplit(threadData_t *threadData, modelica_string _string, modelica_string _token);
#define boxptr_OpenModelicaScriptingAPI_stringSplit omc_OpenModelicaScriptingAPI_stringSplit
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_stringSplit,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_stringSplit,0}};
#define boxvar_OpenModelicaScriptingAPI_stringSplit MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_stringSplit)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_stringReplace(threadData_t *threadData, modelica_string _str, modelica_string _source, modelica_string _target);
#define boxptr_OpenModelicaScriptingAPI_stringReplace omc_OpenModelicaScriptingAPI_stringReplace
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_stringReplace,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_stringReplace,0}};
#define boxvar_OpenModelicaScriptingAPI_stringReplace MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_stringReplace)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_listFile(threadData_t *threadData, modelica_string _class_, modelica_boolean _nestedClasses);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_listFile(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _nestedClasses);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_listFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_listFile,0}};
#define boxvar_OpenModelicaScriptingAPI_listFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_listFile)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_exportToFigaro(threadData_t *threadData, modelica_string _path, modelica_string _directory, modelica_string _database, modelica_string _mode, modelica_string _options, modelica_string _processor);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_exportToFigaro(threadData_t *threadData, modelica_metatype _path, modelica_metatype _directory, modelica_metatype _database, modelica_metatype _mode, modelica_metatype _options, modelica_metatype _processor);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_exportToFigaro,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_exportToFigaro,0}};
#define boxvar_OpenModelicaScriptingAPI_exportToFigaro MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_exportToFigaro)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_inferBindings(threadData_t *threadData, modelica_string _path);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_inferBindings(threadData_t *threadData, modelica_metatype _path);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_inferBindings,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_inferBindings,0}};
#define boxvar_OpenModelicaScriptingAPI_inferBindings MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_inferBindings)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_generateVerificationScenarios(threadData_t *threadData, modelica_string _path);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_generateVerificationScenarios(threadData_t *threadData, modelica_metatype _path);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateVerificationScenarios,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateVerificationScenarios,0}};
#define boxvar_OpenModelicaScriptingAPI_generateVerificationScenarios MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateVerificationScenarios)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_rewriteBlockCall(threadData_t *threadData, modelica_string _className, modelica_string _inDefs);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_rewriteBlockCall(threadData_t *threadData, modelica_metatype _className, modelica_metatype _inDefs);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_rewriteBlockCall,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_rewriteBlockCall,0}};
#define boxvar_OpenModelicaScriptingAPI_rewriteBlockCall MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_rewriteBlockCall)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_realpath(threadData_t *threadData, modelica_string _name);
#define boxptr_OpenModelicaScriptingAPI_realpath omc_OpenModelicaScriptingAPI_realpath
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_realpath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_realpath,0}};
#define boxvar_OpenModelicaScriptingAPI_realpath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_realpath)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_uriToFilename(threadData_t *threadData, modelica_string _uri);
#define boxptr_OpenModelicaScriptingAPI_uriToFilename omc_OpenModelicaScriptingAPI_uriToFilename
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_uriToFilename,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_uriToFilename,0}};
#define boxvar_OpenModelicaScriptingAPI_uriToFilename MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_uriToFilename)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getLoadedLibraries(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getLoadedLibraries omc_OpenModelicaScriptingAPI_getLoadedLibraries
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLoadedLibraries,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getLoadedLibraries,0}};
#define boxvar_OpenModelicaScriptingAPI_getLoadedLibraries MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getLoadedLibraries)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_solveLinearSystem(threadData_t *threadData, modelica_metatype _A, modelica_metatype _B, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_solveLinearSystem(threadData_t *threadData, modelica_metatype _A, modelica_metatype _B, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_solveLinearSystem,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_solveLinearSystem,0}};
#define boxvar_OpenModelicaScriptingAPI_solveLinearSystem MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_solveLinearSystem)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_importFMU(threadData_t *threadData, modelica_string _filename, modelica_string _workdir, modelica_integer _loglevel, modelica_boolean _fullPath, modelica_boolean _debugLogging, modelica_boolean _generateInputConnectors, modelica_boolean _generateOutputConnectors, modelica_string _modelName);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_importFMU(threadData_t *threadData, modelica_metatype _filename, modelica_metatype _workdir, modelica_metatype _loglevel, modelica_metatype _fullPath, modelica_metatype _debugLogging, modelica_metatype _generateInputConnectors, modelica_metatype _generateOutputConnectors, modelica_metatype _modelName);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_importFMU,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_importFMU,0}};
#define boxvar_OpenModelicaScriptingAPI_importFMU MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_importFMU)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_importFMUModelDescription(threadData_t *threadData, modelica_string _filename, modelica_string _workdir, modelica_integer _loglevel, modelica_boolean _fullPath, modelica_boolean _debugLogging, modelica_boolean _generateInputConnectors, modelica_boolean _generateOutputConnectors);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_importFMUModelDescription(threadData_t *threadData, modelica_metatype _filename, modelica_metatype _workdir, modelica_metatype _loglevel, modelica_metatype _fullPath, modelica_metatype _debugLogging, modelica_metatype _generateInputConnectors, modelica_metatype _generateOutputConnectors);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_importFMUModelDescription,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_importFMUModelDescription,0}};
#define boxvar_OpenModelicaScriptingAPI_importFMUModelDescription MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_importFMUModelDescription)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_translateModelFMU(threadData_t *threadData, modelica_string _className, modelica_string _version, modelica_string _fmuType, modelica_string _fileNamePrefix, modelica_metatype _platforms, modelica_boolean _includeResources);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_translateModelFMU(threadData_t *threadData, modelica_metatype _className, modelica_metatype _version, modelica_metatype _fmuType, modelica_metatype _fileNamePrefix, modelica_metatype _platforms, modelica_metatype _includeResources);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_translateModelFMU,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_translateModelFMU,0}};
#define boxvar_OpenModelicaScriptingAPI_translateModelFMU MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_translateModelFMU)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_buildModelFMU(threadData_t *threadData, modelica_string _className, modelica_string _version, modelica_string _fmuType, modelica_string _fileNamePrefix, modelica_metatype _platforms, modelica_boolean _includeResources);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_buildModelFMU(threadData_t *threadData, modelica_metatype _className, modelica_metatype _version, modelica_metatype _fmuType, modelica_metatype _fileNamePrefix, modelica_metatype _platforms, modelica_metatype _includeResources);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_buildModelFMU,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_buildModelFMU,0}};
#define boxvar_OpenModelicaScriptingAPI_buildModelFMU MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_buildModelFMU)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_buildEncryptedPackage(threadData_t *threadData, modelica_string _className, modelica_boolean _encrypt);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_buildEncryptedPackage(threadData_t *threadData, modelica_metatype _className, modelica_metatype _encrypt);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_buildEncryptedPackage,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_buildEncryptedPackage,0}};
#define boxvar_OpenModelicaScriptingAPI_buildEncryptedPackage MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_buildEncryptedPackage)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_buildLabel(threadData_t *threadData, modelica_string _className, modelica_real _startTime, modelica_real _stopTime, modelica_integer _numberOfIntervals, modelica_real _tolerance, modelica_string _method, modelica_string _fileNamePrefix, modelica_string _options, modelica_string _outputFormat, modelica_string _variableFilter, modelica_string _cflags, modelica_string _simflags);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_buildLabel(threadData_t *threadData, modelica_metatype _className, modelica_metatype _startTime, modelica_metatype _stopTime, modelica_metatype _numberOfIntervals, modelica_metatype _tolerance, modelica_metatype _method, modelica_metatype _fileNamePrefix, modelica_metatype _options, modelica_metatype _outputFormat, modelica_metatype _variableFilter, modelica_metatype _cflags, modelica_metatype _simflags);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_buildLabel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_buildLabel,0}};
#define boxvar_OpenModelicaScriptingAPI_buildLabel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_buildLabel)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_reduceTerms(threadData_t *threadData, modelica_string _className, modelica_real _startTime, modelica_real _stopTime, modelica_integer _numberOfIntervals, modelica_real _tolerance, modelica_string _method, modelica_string _fileNamePrefix, modelica_string _options, modelica_string _outputFormat, modelica_string _variableFilter, modelica_string _cflags, modelica_string _simflags, modelica_string _labelstoCancel);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_reduceTerms(threadData_t *threadData, modelica_metatype _className, modelica_metatype _startTime, modelica_metatype _stopTime, modelica_metatype _numberOfIntervals, modelica_metatype _tolerance, modelica_metatype _method, modelica_metatype _fileNamePrefix, modelica_metatype _options, modelica_metatype _outputFormat, modelica_metatype _variableFilter, modelica_metatype _cflags, modelica_metatype _simflags, modelica_metatype _labelstoCancel);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_reduceTerms,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_reduceTerms,0}};
#define boxvar_OpenModelicaScriptingAPI_reduceTerms MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_reduceTerms)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_createModel(threadData_t *threadData, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_createModel(threadData_t *threadData, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_createModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_createModel,0}};
#define boxvar_OpenModelicaScriptingAPI_createModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_createModel)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_newModel(threadData_t *threadData, modelica_string _className, modelica_string _withinPath);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_newModel(threadData_t *threadData, modelica_metatype _className, modelica_metatype _withinPath);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_newModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_newModel,0}};
#define boxvar_OpenModelicaScriptingAPI_newModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_newModel)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_moveClass(threadData_t *threadData, modelica_string _className, modelica_integer _offset);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_moveClass(threadData_t *threadData, modelica_metatype _className, modelica_metatype _offset);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_moveClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_moveClass,0}};
#define boxvar_OpenModelicaScriptingAPI_moveClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_moveClass)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_moveClassToTop(threadData_t *threadData, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_moveClassToTop(threadData_t *threadData, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_moveClassToTop,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_moveClassToTop,0}};
#define boxvar_OpenModelicaScriptingAPI_moveClassToTop MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_moveClassToTop)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_moveClassToBottom(threadData_t *threadData, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_moveClassToBottom(threadData_t *threadData, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_moveClassToBottom,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_moveClassToBottom,0}};
#define boxvar_OpenModelicaScriptingAPI_moveClassToBottom MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_moveClassToBottom)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_copyClass(threadData_t *threadData, modelica_string _className, modelica_string _newClassName, modelica_string _withIn);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_copyClass(threadData_t *threadData, modelica_metatype _className, modelica_metatype _newClassName, modelica_metatype _withIn);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_copyClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_copyClass,0}};
#define boxvar_OpenModelicaScriptingAPI_copyClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_copyClass)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_renameClass(threadData_t *threadData, modelica_string _oldName, modelica_string _newName);
#define boxptr_OpenModelicaScriptingAPI_renameClass omc_OpenModelicaScriptingAPI_renameClass
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_renameClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_renameClass,0}};
#define boxvar_OpenModelicaScriptingAPI_renameClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_renameClass)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_deleteClass(threadData_t *threadData, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_deleteClass(threadData_t *threadData, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deleteClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_deleteClass,0}};
#define boxvar_OpenModelicaScriptingAPI_deleteClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deleteClass)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_refactorClass(threadData_t *threadData, modelica_string _className);
#define boxptr_OpenModelicaScriptingAPI_refactorClass omc_OpenModelicaScriptingAPI_refactorClass
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_refactorClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_refactorClass,0}};
#define boxvar_OpenModelicaScriptingAPI_refactorClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_refactorClass)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getSourceFile(threadData_t *threadData, modelica_string _class_);
#define boxptr_OpenModelicaScriptingAPI_getSourceFile omc_OpenModelicaScriptingAPI_getSourceFile
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getSourceFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getSourceFile,0}};
#define boxvar_OpenModelicaScriptingAPI_getSourceFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getSourceFile)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setSourceFile(threadData_t *threadData, modelica_string _class_, modelica_string _filename);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setSourceFile(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _filename);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setSourceFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setSourceFile,0}};
#define boxvar_OpenModelicaScriptingAPI_setSourceFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setSourceFile)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isShortDefinition(threadData_t *threadData, modelica_string _class_);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isShortDefinition(threadData_t *threadData, modelica_metatype _class_);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isShortDefinition,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isShortDefinition,0}};
#define boxvar_OpenModelicaScriptingAPI_isShortDefinition MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isShortDefinition)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setClassComment(threadData_t *threadData, modelica_string _class_, modelica_string _filename);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setClassComment(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _filename);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setClassComment,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setClassComment,0}};
#define boxvar_OpenModelicaScriptingAPI_setClassComment MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setClassComment)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getClassNames(threadData_t *threadData, modelica_string _class_, modelica_boolean _recursive, modelica_boolean _qualified, modelica_boolean _sort, modelica_boolean _builtin, modelica_boolean _showProtected, modelica_boolean _includeConstants);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getClassNames(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _recursive, modelica_metatype _qualified, modelica_metatype _sort, modelica_metatype _builtin, modelica_metatype _showProtected, modelica_metatype _includeConstants);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getClassNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getClassNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassNames)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getUsedClassNames(threadData_t *threadData, modelica_string _className);
#define boxptr_OpenModelicaScriptingAPI_getUsedClassNames omc_OpenModelicaScriptingAPI_getUsedClassNames
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getUsedClassNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getUsedClassNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getUsedClassNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getUsedClassNames)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getPackages(threadData_t *threadData, modelica_string _class_);
#define boxptr_OpenModelicaScriptingAPI_getPackages omc_OpenModelicaScriptingAPI_getPackages
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getPackages,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getPackages,0}};
#define boxvar_OpenModelicaScriptingAPI_getPackages MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getPackages)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getAllSubtypeOf(threadData_t *threadData, modelica_string _className, modelica_string _parentClass, modelica_boolean _qualified, modelica_boolean _includePartial, modelica_boolean _sort);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getAllSubtypeOf(threadData_t *threadData, modelica_metatype _className, modelica_metatype _parentClass, modelica_metatype _qualified, modelica_metatype _includePartial, modelica_metatype _sort);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAllSubtypeOf,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAllSubtypeOf,0}};
#define boxvar_OpenModelicaScriptingAPI_getAllSubtypeOf MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAllSubtypeOf)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getReplaceableChoices(threadData_t *threadData, modelica_string _baseClass, modelica_string _parentClass, modelica_boolean _includePartial, modelica_boolean _sort);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getReplaceableChoices(threadData_t *threadData, modelica_metatype _baseClass, modelica_metatype _parentClass, modelica_metatype _includePartial, modelica_metatype _sort);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getReplaceableChoices,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getReplaceableChoices,0}};
#define boxvar_OpenModelicaScriptingAPI_getReplaceableChoices MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getReplaceableChoices)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_plotAll(threadData_t *threadData, modelica_boolean _externalWindow, modelica_string _fileName, modelica_string _title, modelica_string _grid, modelica_boolean _logX, modelica_boolean _logY, modelica_string _xLabel, modelica_string _yLabel, modelica_metatype _xRange, modelica_metatype _yRange, modelica_real _curveWidth, modelica_integer _curveStyle, modelica_string _legendPosition, modelica_string _footer, modelica_boolean _autoScale, modelica_boolean _forceOMPlot, modelica_string _yAxis, modelica_string _yLabelRight, modelica_metatype _yRangeRight);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_plotAll(threadData_t *threadData, modelica_metatype _externalWindow, modelica_metatype _fileName, modelica_metatype _title, modelica_metatype _grid, modelica_metatype _logX, modelica_metatype _logY, modelica_metatype _xLabel, modelica_metatype _yLabel, modelica_metatype _xRange, modelica_metatype _yRange, modelica_metatype _curveWidth, modelica_metatype _curveStyle, modelica_metatype _legendPosition, modelica_metatype _footer, modelica_metatype _autoScale, modelica_metatype _forceOMPlot, modelica_metatype _yAxis, modelica_metatype _yLabelRight, modelica_metatype _yRangeRight);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_plotAll,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_plotAll,0}};
#define boxvar_OpenModelicaScriptingAPI_plotAll MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_plotAll)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_readSimulationResultSize(threadData_t *threadData, modelica_string _fileName);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_readSimulationResultSize(threadData_t *threadData, modelica_metatype _fileName);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readSimulationResultSize,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_readSimulationResultSize,0}};
#define boxvar_OpenModelicaScriptingAPI_readSimulationResultSize MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readSimulationResultSize)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_readSimulationResultVars(threadData_t *threadData, modelica_string _fileName, modelica_boolean _readParameters, modelica_boolean _openmodelicaStyle);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_readSimulationResultVars(threadData_t *threadData, modelica_metatype _fileName, modelica_metatype _readParameters, modelica_metatype _openmodelicaStyle);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readSimulationResultVars,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_readSimulationResultVars,0}};
#define boxvar_OpenModelicaScriptingAPI_readSimulationResultVars MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_readSimulationResultVars)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_filterSimulationResults(threadData_t *threadData, modelica_string _inFile, modelica_string _outFile, modelica_metatype _vars, modelica_integer _numberOfIntervals, modelica_boolean _removeDescription, modelica_boolean _hintReadAllVars);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_filterSimulationResults(threadData_t *threadData, modelica_metatype _inFile, modelica_metatype _outFile, modelica_metatype _vars, modelica_metatype _numberOfIntervals, modelica_metatype _removeDescription, modelica_metatype _hintReadAllVars);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_filterSimulationResults,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_filterSimulationResults,0}};
#define boxvar_OpenModelicaScriptingAPI_filterSimulationResults MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_filterSimulationResults)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_compareSimulationResults(threadData_t *threadData, modelica_string _filename, modelica_string _reffilename, modelica_string _logfilename, modelica_real _relTol, modelica_real _absTol, modelica_metatype _vars);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_compareSimulationResults(threadData_t *threadData, modelica_metatype _filename, modelica_metatype _reffilename, modelica_metatype _logfilename, modelica_metatype _relTol, modelica_metatype _absTol, modelica_metatype _vars);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_compareSimulationResults,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_compareSimulationResults,0}};
#define boxvar_OpenModelicaScriptingAPI_compareSimulationResults MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_compareSimulationResults)


DLLDirection
modelica_real omc_OpenModelicaScriptingAPI_deltaSimulationResults(threadData_t *threadData, modelica_string _filename, modelica_string _reffilename, modelica_string _method, modelica_metatype _vars);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_deltaSimulationResults(threadData_t *threadData, modelica_metatype _filename, modelica_metatype _reffilename, modelica_metatype _method, modelica_metatype _vars);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deltaSimulationResults,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_deltaSimulationResults,0}};
#define boxvar_OpenModelicaScriptingAPI_deltaSimulationResults MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deltaSimulationResults)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_diffSimulationResults(threadData_t *threadData, modelica_string _actualFile, modelica_string _expectedFile, modelica_string _diffPrefix, modelica_real _relTol, modelica_real _relTolDiffMinMax, modelica_real _rangeDelta, modelica_metatype _vars, modelica_boolean _keepEqualResults, modelica_metatype *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_diffSimulationResults(threadData_t *threadData, modelica_metatype _actualFile, modelica_metatype _expectedFile, modelica_metatype _diffPrefix, modelica_metatype _relTol, modelica_metatype _relTolDiffMinMax, modelica_metatype _rangeDelta, modelica_metatype _vars, modelica_metatype _keepEqualResults, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_diffSimulationResults,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_diffSimulationResults,0}};
#define boxvar_OpenModelicaScriptingAPI_diffSimulationResults MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_diffSimulationResults)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_diffSimulationResultsHtml(threadData_t *threadData, modelica_string _var, modelica_string _actualFile, modelica_string _expectedFile, modelica_real _relTol, modelica_real _relTolDiffMinMax, modelica_real _rangeDelta);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_diffSimulationResultsHtml(threadData_t *threadData, modelica_metatype _var, modelica_metatype _actualFile, modelica_metatype _expectedFile, modelica_metatype _relTol, modelica_metatype _relTolDiffMinMax, modelica_metatype _rangeDelta);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_diffSimulationResultsHtml,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_diffSimulationResultsHtml,0}};
#define boxvar_OpenModelicaScriptingAPI_diffSimulationResultsHtml MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_diffSimulationResultsHtml)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_checkTaskGraph(threadData_t *threadData, modelica_string _filename, modelica_string _reffilename);
#define boxptr_OpenModelicaScriptingAPI_checkTaskGraph omc_OpenModelicaScriptingAPI_checkTaskGraph
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkTaskGraph,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_checkTaskGraph,0}};
#define boxvar_OpenModelicaScriptingAPI_checkTaskGraph MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkTaskGraph)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_checkCodeGraph(threadData_t *threadData, modelica_string _graphfile, modelica_string _codefile);
#define boxptr_OpenModelicaScriptingAPI_checkCodeGraph omc_OpenModelicaScriptingAPI_checkCodeGraph
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkCodeGraph,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_checkCodeGraph,0}};
#define boxvar_OpenModelicaScriptingAPI_checkCodeGraph MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkCodeGraph)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_closeSimulationResultFile(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_closeSimulationResultFile(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_closeSimulationResultFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_closeSimulationResultFile,0}};
#define boxvar_OpenModelicaScriptingAPI_closeSimulationResultFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_closeSimulationResultFile)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_deleteComponent(threadData_t *threadData, modelica_string _componentName, modelica_string _classPath);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_deleteComponent(threadData_t *threadData, modelica_metatype _componentName, modelica_metatype _classPath);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deleteComponent,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_deleteComponent,0}};
#define boxvar_OpenModelicaScriptingAPI_deleteComponent MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deleteComponent)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getParameterNames(threadData_t *threadData, modelica_string _class_);
#define boxptr_OpenModelicaScriptingAPI_getParameterNames omc_OpenModelicaScriptingAPI_getParameterNames
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getParameterNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getParameterNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getParameterNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getParameterNames)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getParameterValue(threadData_t *threadData, modelica_string _class_, modelica_string _parameterName);
#define boxptr_OpenModelicaScriptingAPI_getParameterValue omc_OpenModelicaScriptingAPI_getParameterValue
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getParameterValue,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getParameterValue,0}};
#define boxvar_OpenModelicaScriptingAPI_getParameterValue MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getParameterValue)


DLLDirection
void omc_OpenModelicaScriptingAPI_getComponents(threadData_t *threadData, modelica_string _className, modelica_boolean _useQuotes);
DLLDirection
void boxptr_OpenModelicaScriptingAPI_getComponents(threadData_t *threadData, modelica_metatype _className, modelica_metatype _useQuotes);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponents,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getComponents,0}};
#define boxvar_OpenModelicaScriptingAPI_getComponents MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponents)


DLLDirection
void omc_OpenModelicaScriptingAPI_getElements(threadData_t *threadData, modelica_string _className, modelica_boolean _useQuotes);
DLLDirection
void boxptr_OpenModelicaScriptingAPI_getElements(threadData_t *threadData, modelica_metatype _className, modelica_metatype _useQuotes);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getElements,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getElements,0}};
#define boxvar_OpenModelicaScriptingAPI_getElements MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getElements)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getComponentModifierNames(threadData_t *threadData, modelica_string _class_, modelica_string _componentName);
#define boxptr_OpenModelicaScriptingAPI_getComponentModifierNames omc_OpenModelicaScriptingAPI_getComponentModifierNames
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponentModifierNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getComponentModifierNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getComponentModifierNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponentModifierNames)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getComponentModifierValue(threadData_t *threadData, modelica_string _class_, modelica_string _modifier);
#define boxptr_OpenModelicaScriptingAPI_getComponentModifierValue omc_OpenModelicaScriptingAPI_getComponentModifierValue
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponentModifierValue,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getComponentModifierValue,0}};
#define boxvar_OpenModelicaScriptingAPI_getComponentModifierValue MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponentModifierValue)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getComponentModifierValues(threadData_t *threadData, modelica_string _class_, modelica_string _modifier);
#define boxptr_OpenModelicaScriptingAPI_getComponentModifierValues omc_OpenModelicaScriptingAPI_getComponentModifierValues
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponentModifierValues,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getComponentModifierValues,0}};
#define boxvar_OpenModelicaScriptingAPI_getComponentModifierValues MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponentModifierValues)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_removeComponentModifiers(threadData_t *threadData, modelica_string _class_, modelica_string _componentName, modelica_boolean _keepRedeclares);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_removeComponentModifiers(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _componentName, modelica_metatype _keepRedeclares);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_removeComponentModifiers,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_removeComponentModifiers,0}};
#define boxvar_OpenModelicaScriptingAPI_removeComponentModifiers MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_removeComponentModifiers)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getElementModifierNames(threadData_t *threadData, modelica_string _className, modelica_string _elementName);
#define boxptr_OpenModelicaScriptingAPI_getElementModifierNames omc_OpenModelicaScriptingAPI_getElementModifierNames
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getElementModifierNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getElementModifierNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getElementModifierNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getElementModifierNames)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getExtendsModifierNames(threadData_t *threadData, modelica_string _className, modelica_string _extendsName, modelica_boolean _useQuotes);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getExtendsModifierNames(threadData_t *threadData, modelica_metatype _className, modelica_metatype _extendsName, modelica_metatype _useQuotes);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getExtendsModifierNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getExtendsModifierNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getExtendsModifierNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getExtendsModifierNames)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getElementModifierValue(threadData_t *threadData, modelica_string _className, modelica_string _modifier);
#define boxptr_OpenModelicaScriptingAPI_getElementModifierValue omc_OpenModelicaScriptingAPI_getElementModifierValue
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getElementModifierValue,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getElementModifierValue,0}};
#define boxvar_OpenModelicaScriptingAPI_getElementModifierValue MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getElementModifierValue)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getElementModifierValues(threadData_t *threadData, modelica_string _className, modelica_string _modifier);
#define boxptr_OpenModelicaScriptingAPI_getElementModifierValues omc_OpenModelicaScriptingAPI_getElementModifierValues
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getElementModifierValues,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getElementModifierValues,0}};
#define boxvar_OpenModelicaScriptingAPI_getElementModifierValues MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getElementModifierValues)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_removeElementModifiers(threadData_t *threadData, modelica_string _className, modelica_string _componentName, modelica_boolean _keepRedeclares);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_removeElementModifiers(threadData_t *threadData, modelica_metatype _className, modelica_metatype _componentName, modelica_metatype _keepRedeclares);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_removeElementModifiers,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_removeElementModifiers,0}};
#define boxvar_OpenModelicaScriptingAPI_removeElementModifiers MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_removeElementModifiers)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isExtendsModifierFinal(threadData_t *threadData, modelica_string _className, modelica_string _extendsName, modelica_string _modifierName);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isExtendsModifierFinal(threadData_t *threadData, modelica_metatype _className, modelica_metatype _extendsName, modelica_metatype _modifierName);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isExtendsModifierFinal,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isExtendsModifierFinal,0}};
#define boxvar_OpenModelicaScriptingAPI_isExtendsModifierFinal MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isExtendsModifierFinal)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getComponentCount(threadData_t *threadData, modelica_string _classPath);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getComponentCount(threadData_t *threadData, modelica_metatype _classPath);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponentCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getComponentCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getComponentCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponentCount)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getNthComponentCondition(threadData_t *threadData, modelica_string _className, modelica_integer _n);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthComponentCondition(threadData_t *threadData, modelica_metatype _className, modelica_metatype _n);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthComponentCondition,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthComponentCondition,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthComponentCondition MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthComponentCondition)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getElementAnnotation(threadData_t *threadData, modelica_string _elementName);
#define boxptr_OpenModelicaScriptingAPI_getElementAnnotation omc_OpenModelicaScriptingAPI_getElementAnnotation
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getElementAnnotation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getElementAnnotation,0}};
#define boxvar_OpenModelicaScriptingAPI_getElementAnnotation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getElementAnnotation)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getInstantiatedParametersAndValues(threadData_t *threadData, modelica_string _cls);
#define boxptr_OpenModelicaScriptingAPI_getInstantiatedParametersAndValues omc_OpenModelicaScriptingAPI_getInstantiatedParametersAndValues
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInstantiatedParametersAndValues,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInstantiatedParametersAndValues,0}};
#define boxvar_OpenModelicaScriptingAPI_getInstantiatedParametersAndValues MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInstantiatedParametersAndValues)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_removeExtendsModifiers(threadData_t *threadData, modelica_string _className, modelica_string _baseClassName, modelica_boolean _keepRedeclares);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_removeExtendsModifiers(threadData_t *threadData, modelica_metatype _className, modelica_metatype _baseClassName, modelica_metatype _keepRedeclares);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_removeExtendsModifiers,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_removeExtendsModifiers,0}};
#define boxvar_OpenModelicaScriptingAPI_removeExtendsModifiers MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_removeExtendsModifiers)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getComponentComment(threadData_t *threadData, modelica_string _className, modelica_string _componentName);
#define boxptr_OpenModelicaScriptingAPI_getComponentComment omc_OpenModelicaScriptingAPI_getComponentComment
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponentComment,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getComponentComment,0}};
#define boxvar_OpenModelicaScriptingAPI_getComponentComment MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getComponentComment)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setComponentComment(threadData_t *threadData, modelica_string _className, modelica_string _componentName, modelica_string _comment);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setComponentComment(threadData_t *threadData, modelica_metatype _className, modelica_metatype _componentName, modelica_metatype _comment);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setComponentComment,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setComponentComment,0}};
#define boxvar_OpenModelicaScriptingAPI_setComponentComment MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setComponentComment)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setComponentProperties(threadData_t *threadData, modelica_string _className, modelica_string _componentName, modelica_metatype _prefixArray, modelica_metatype _variability, modelica_metatype _innerOuter, modelica_metatype _direction);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setComponentProperties(threadData_t *threadData, modelica_metatype _className, modelica_metatype _componentName, modelica_metatype _prefixArray, modelica_metatype _variability, modelica_metatype _innerOuter, modelica_metatype _direction);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setComponentProperties,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setComponentProperties,0}};
#define boxvar_OpenModelicaScriptingAPI_setComponentProperties MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setComponentProperties)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getConnectorCount(threadData_t *threadData, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getConnectorCount(threadData_t *threadData, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getConnectorCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getConnectorCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getConnectorCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getConnectorCount)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_updateConnectionAnnotation(threadData_t *threadData, modelica_string _className, modelica_string _from, modelica_string _to, modelica_string _annotate);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_updateConnectionAnnotation(threadData_t *threadData, modelica_metatype _className, modelica_metatype _from, modelica_metatype _to, modelica_metatype _annotate);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_updateConnectionAnnotation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_updateConnectionAnnotation,0}};
#define boxvar_OpenModelicaScriptingAPI_updateConnectionAnnotation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_updateConnectionAnnotation)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_updateConnectionNames(threadData_t *threadData, modelica_string _className, modelica_string _from, modelica_string _to, modelica_string _fromNew, modelica_string _toNew);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_updateConnectionNames(threadData_t *threadData, modelica_metatype _className, modelica_metatype _from, modelica_metatype _to, modelica_metatype _fromNew, modelica_metatype _toNew);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_updateConnectionNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_updateConnectionNames,0}};
#define boxvar_OpenModelicaScriptingAPI_updateConnectionNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_updateConnectionNames)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getConnectionCount(threadData_t *threadData, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getConnectionCount(threadData_t *threadData, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getConnectionCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getConnectionCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getConnectionCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getConnectionCount)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getNthConnection(threadData_t *threadData, modelica_string _className, modelica_integer _index);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthConnection(threadData_t *threadData, modelica_metatype _className, modelica_metatype _index);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthConnection,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthConnection,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthConnection MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthConnection)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getConnectionList(threadData_t *threadData, modelica_string _className);
#define boxptr_OpenModelicaScriptingAPI_getConnectionList omc_OpenModelicaScriptingAPI_getConnectionList
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getConnectionList,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getConnectionList,0}};
#define boxvar_OpenModelicaScriptingAPI_getConnectionList MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getConnectionList)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getAlgorithmCount(threadData_t *threadData, modelica_string _class_);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getAlgorithmCount(threadData_t *threadData, modelica_metatype _class_);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAlgorithmCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAlgorithmCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getAlgorithmCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAlgorithmCount)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getNthAlgorithm(threadData_t *threadData, modelica_string _class_, modelica_integer _index);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthAlgorithm(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _index);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthAlgorithm,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthAlgorithm,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthAlgorithm MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthAlgorithm)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getInitialAlgorithmCount(threadData_t *threadData, modelica_string _class_);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getInitialAlgorithmCount(threadData_t *threadData, modelica_metatype _class_);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialAlgorithmCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInitialAlgorithmCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getInitialAlgorithmCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialAlgorithmCount)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getNthInitialAlgorithm(threadData_t *threadData, modelica_string _class_, modelica_integer _index);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthInitialAlgorithm(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _index);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialAlgorithm,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthInitialAlgorithm,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthInitialAlgorithm MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialAlgorithm)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getAlgorithmItemsCount(threadData_t *threadData, modelica_string _class_);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getAlgorithmItemsCount(threadData_t *threadData, modelica_metatype _class_);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAlgorithmItemsCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAlgorithmItemsCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getAlgorithmItemsCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAlgorithmItemsCount)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getNthAlgorithmItem(threadData_t *threadData, modelica_string _class_, modelica_integer _index);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthAlgorithmItem(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _index);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthAlgorithmItem,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthAlgorithmItem,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthAlgorithmItem MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthAlgorithmItem)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getInitialAlgorithmItemsCount(threadData_t *threadData, modelica_string _class_);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getInitialAlgorithmItemsCount(threadData_t *threadData, modelica_metatype _class_);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialAlgorithmItemsCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInitialAlgorithmItemsCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getInitialAlgorithmItemsCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialAlgorithmItemsCount)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getNthInitialAlgorithmItem(threadData_t *threadData, modelica_string _class_, modelica_integer _index);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthInitialAlgorithmItem(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _index);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialAlgorithmItem,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthInitialAlgorithmItem,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthInitialAlgorithmItem MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialAlgorithmItem)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getEquationCount(threadData_t *threadData, modelica_string _class_);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getEquationCount(threadData_t *threadData, modelica_metatype _class_);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEquationCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getEquationCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getEquationCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEquationCount)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getNthEquation(threadData_t *threadData, modelica_string _class_, modelica_integer _index);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthEquation(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _index);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthEquation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthEquation,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthEquation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthEquation)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getInitialEquationCount(threadData_t *threadData, modelica_string _class_);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getInitialEquationCount(threadData_t *threadData, modelica_metatype _class_);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialEquationCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInitialEquationCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getInitialEquationCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialEquationCount)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getNthInitialEquation(threadData_t *threadData, modelica_string _class_, modelica_integer _index);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthInitialEquation(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _index);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialEquation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthInitialEquation,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthInitialEquation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialEquation)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getEquationItemsCount(threadData_t *threadData, modelica_string _class_);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getEquationItemsCount(threadData_t *threadData, modelica_metatype _class_);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEquationItemsCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getEquationItemsCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getEquationItemsCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEquationItemsCount)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getNthEquationItem(threadData_t *threadData, modelica_string _class_, modelica_integer _index);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthEquationItem(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _index);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthEquationItem,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthEquationItem,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthEquationItem MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthEquationItem)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getInitialEquationItemsCount(threadData_t *threadData, modelica_string _class_);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getInitialEquationItemsCount(threadData_t *threadData, modelica_metatype _class_);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialEquationItemsCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInitialEquationItemsCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getInitialEquationItemsCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialEquationItemsCount)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getNthInitialEquationItem(threadData_t *threadData, modelica_string _class_, modelica_integer _index);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthInitialEquationItem(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _index);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialEquationItem,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthInitialEquationItem,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthInitialEquationItem MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInitialEquationItem)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getAnnotationCount(threadData_t *threadData, modelica_string _class_);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getAnnotationCount(threadData_t *threadData, modelica_metatype _class_);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAnnotationCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAnnotationCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getAnnotationCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAnnotationCount)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getNthAnnotationString(threadData_t *threadData, modelica_string _class_, modelica_integer _index);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthAnnotationString(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _index);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthAnnotationString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthAnnotationString,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthAnnotationString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthAnnotationString)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getImportCount(threadData_t *threadData, modelica_string _class_);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getImportCount(threadData_t *threadData, modelica_metatype _class_);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getImportCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getImportCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getImportCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getImportCount)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getMMfileTotalDependencies(threadData_t *threadData, modelica_string _in_package_name, modelica_string _public_imports_dir);
#define boxptr_OpenModelicaScriptingAPI_getMMfileTotalDependencies omc_OpenModelicaScriptingAPI_getMMfileTotalDependencies
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getMMfileTotalDependencies,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getMMfileTotalDependencies,0}};
#define boxvar_OpenModelicaScriptingAPI_getMMfileTotalDependencies MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getMMfileTotalDependencies)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getImportedNames(threadData_t *threadData, modelica_string _class_, modelica_metatype *out_res2);
#define boxptr_OpenModelicaScriptingAPI_getImportedNames omc_OpenModelicaScriptingAPI_getImportedNames
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getImportedNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getImportedNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getImportedNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getImportedNames)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getNthImport(threadData_t *threadData, modelica_string _class_, modelica_integer _index);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthImport(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _index);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthImport,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthImport,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthImport MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthImport)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_iconv(threadData_t *threadData, modelica_string _string, modelica_string _from, modelica_string _to);
#define boxptr_OpenModelicaScriptingAPI_iconv omc_OpenModelicaScriptingAPI_iconv
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_iconv,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_iconv,0}};
#define boxvar_OpenModelicaScriptingAPI_iconv MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_iconv)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getDocumentationAnnotation(threadData_t *threadData, modelica_string _cl);
#define boxptr_OpenModelicaScriptingAPI_getDocumentationAnnotation omc_OpenModelicaScriptingAPI_getDocumentationAnnotation
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDocumentationAnnotation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getDocumentationAnnotation,0}};
#define boxvar_OpenModelicaScriptingAPI_getDocumentationAnnotation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDocumentationAnnotation)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_setDocumentationAnnotation(threadData_t *threadData, modelica_string _class_, modelica_string _info, modelica_string _revisions);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_setDocumentationAnnotation(threadData_t *threadData, modelica_metatype _class_, modelica_metatype _info, modelica_metatype _revisions);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setDocumentationAnnotation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_setDocumentationAnnotation,0}};
#define boxvar_OpenModelicaScriptingAPI_setDocumentationAnnotation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_setDocumentationAnnotation)


DLLDirection
modelica_real omc_OpenModelicaScriptingAPI_getTimeStamp(threadData_t *threadData, modelica_string _cl, modelica_string *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getTimeStamp(threadData_t *threadData, modelica_metatype _cl, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTimeStamp,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getTimeStamp,0}};
#define boxvar_OpenModelicaScriptingAPI_getTimeStamp MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTimeStamp)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_stringTypeName(threadData_t *threadData, modelica_string _str);
#define boxptr_OpenModelicaScriptingAPI_stringTypeName omc_OpenModelicaScriptingAPI_stringTypeName
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_stringTypeName,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_stringTypeName,0}};
#define boxvar_OpenModelicaScriptingAPI_stringTypeName MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_stringTypeName)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_typeNameString(threadData_t *threadData, modelica_string _cl);
#define boxptr_OpenModelicaScriptingAPI_typeNameString omc_OpenModelicaScriptingAPI_typeNameString
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_typeNameString,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_typeNameString,0}};
#define boxvar_OpenModelicaScriptingAPI_typeNameString MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_typeNameString)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_typeNameStrings(threadData_t *threadData, modelica_string _cl);
#define boxptr_OpenModelicaScriptingAPI_typeNameStrings omc_OpenModelicaScriptingAPI_typeNameStrings
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_typeNameStrings,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_typeNameStrings,0}};
#define boxvar_OpenModelicaScriptingAPI_typeNameStrings MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_typeNameStrings)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getClassComment(threadData_t *threadData, modelica_string _cl);
#define boxptr_OpenModelicaScriptingAPI_getClassComment omc_OpenModelicaScriptingAPI_getClassComment
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassComment,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getClassComment,0}};
#define boxvar_OpenModelicaScriptingAPI_getClassComment MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassComment)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_dirname(threadData_t *threadData, modelica_string _path);
#define boxptr_OpenModelicaScriptingAPI_dirname omc_OpenModelicaScriptingAPI_dirname
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_dirname,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_dirname,0}};
#define boxvar_OpenModelicaScriptingAPI_dirname MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_dirname)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_basename(threadData_t *threadData, modelica_string _path);
#define boxptr_OpenModelicaScriptingAPI_basename omc_OpenModelicaScriptingAPI_basename
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_basename,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_basename,0}};
#define boxvar_OpenModelicaScriptingAPI_basename MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_basename)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_existClass(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_existClass(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_existClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_existClass,0}};
#define boxvar_OpenModelicaScriptingAPI_existClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_existClass)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getClassRestriction(threadData_t *threadData, modelica_string _cl);
#define boxptr_OpenModelicaScriptingAPI_getClassRestriction omc_OpenModelicaScriptingAPI_getClassRestriction
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassRestriction,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getClassRestriction,0}};
#define boxvar_OpenModelicaScriptingAPI_getClassRestriction MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassRestriction)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isType(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isType(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isType,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isType,0}};
#define boxvar_OpenModelicaScriptingAPI_isType MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isType)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isPackage(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isPackage(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isPackage,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isPackage,0}};
#define boxvar_OpenModelicaScriptingAPI_isPackage MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isPackage)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isClass(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isClass(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isClass,0}};
#define boxvar_OpenModelicaScriptingAPI_isClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isClass)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isRecord(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isRecord(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isRecord,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isRecord,0}};
#define boxvar_OpenModelicaScriptingAPI_isRecord MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isRecord)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isBlock(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isBlock(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isBlock,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isBlock,0}};
#define boxvar_OpenModelicaScriptingAPI_isBlock MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isBlock)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isFunction(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isFunction(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isFunction,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isFunction,0}};
#define boxvar_OpenModelicaScriptingAPI_isFunction MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isFunction)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isPartial(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isPartial(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isPartial,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isPartial,0}};
#define boxvar_OpenModelicaScriptingAPI_isPartial MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isPartial)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isReplaceable(threadData_t *threadData, modelica_string _element);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isReplaceable(threadData_t *threadData, modelica_metatype _element);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isReplaceable,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isReplaceable,0}};
#define boxvar_OpenModelicaScriptingAPI_isReplaceable MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isReplaceable)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isRedeclare(threadData_t *threadData, modelica_string _element);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isRedeclare(threadData_t *threadData, modelica_metatype _element);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isRedeclare,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isRedeclare,0}};
#define boxvar_OpenModelicaScriptingAPI_isRedeclare MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isRedeclare)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isModel(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isModel(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isModel,0}};
#define boxvar_OpenModelicaScriptingAPI_isModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isModel)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isConnector(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isConnector(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isConnector,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isConnector,0}};
#define boxvar_OpenModelicaScriptingAPI_isConnector MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isConnector)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isOptimization(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isOptimization(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOptimization,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isOptimization,0}};
#define boxvar_OpenModelicaScriptingAPI_isOptimization MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOptimization)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isEnumeration(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isEnumeration(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isEnumeration,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isEnumeration,0}};
#define boxvar_OpenModelicaScriptingAPI_isEnumeration MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isEnumeration)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isOperator(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isOperator(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOperator,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isOperator,0}};
#define boxvar_OpenModelicaScriptingAPI_isOperator MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOperator)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isOperatorRecord(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isOperatorRecord(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOperatorRecord,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isOperatorRecord,0}};
#define boxvar_OpenModelicaScriptingAPI_isOperatorRecord MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOperatorRecord)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isOperatorFunction(threadData_t *threadData, modelica_string _cl);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isOperatorFunction(threadData_t *threadData, modelica_metatype _cl);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOperatorFunction,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isOperatorFunction,0}};
#define boxvar_OpenModelicaScriptingAPI_isOperatorFunction MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isOperatorFunction)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isProtectedClass(threadData_t *threadData, modelica_string _cl, modelica_string _c2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isProtectedClass(threadData_t *threadData, modelica_metatype _cl, modelica_metatype _c2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isProtectedClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isProtectedClass,0}};
#define boxvar_OpenModelicaScriptingAPI_isProtectedClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isProtectedClass)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getBuiltinType(threadData_t *threadData, modelica_string _cl);
#define boxptr_OpenModelicaScriptingAPI_getBuiltinType omc_OpenModelicaScriptingAPI_getBuiltinType
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getBuiltinType,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getBuiltinType,0}};
#define boxvar_OpenModelicaScriptingAPI_getBuiltinType MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getBuiltinType)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isPrimitive(threadData_t *threadData, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isPrimitive(threadData_t *threadData, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isPrimitive,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isPrimitive,0}};
#define boxvar_OpenModelicaScriptingAPI_isPrimitive MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isPrimitive)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isParameter(threadData_t *threadData, modelica_string _componentName, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isParameter(threadData_t *threadData, modelica_metatype _componentName, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isParameter,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isParameter,0}};
#define boxvar_OpenModelicaScriptingAPI_isParameter MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isParameter)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isConstant(threadData_t *threadData, modelica_string _componentName, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isConstant(threadData_t *threadData, modelica_metatype _componentName, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isConstant,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isConstant,0}};
#define boxvar_OpenModelicaScriptingAPI_isConstant MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isConstant)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isProtected(threadData_t *threadData, modelica_string _componentName, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isProtected(threadData_t *threadData, modelica_metatype _componentName, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isProtected,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isProtected,0}};
#define boxvar_OpenModelicaScriptingAPI_isProtected MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isProtected)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_getInheritanceCount(threadData_t *threadData, modelica_string _className);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getInheritanceCount(threadData_t *threadData, modelica_metatype _className);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInheritanceCount,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInheritanceCount,0}};
#define boxvar_OpenModelicaScriptingAPI_getInheritanceCount MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInheritanceCount)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getInheritedClasses(threadData_t *threadData, modelica_string _name);
#define boxptr_OpenModelicaScriptingAPI_getInheritedClasses omc_OpenModelicaScriptingAPI_getInheritedClasses
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInheritedClasses,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInheritedClasses,0}};
#define boxvar_OpenModelicaScriptingAPI_getInheritedClasses MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInheritedClasses)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getNthInheritedClass(threadData_t *threadData, modelica_string _className, modelica_integer _n);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getNthInheritedClass(threadData_t *threadData, modelica_metatype _className, modelica_metatype _n);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInheritedClass,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getNthInheritedClass,0}};
#define boxvar_OpenModelicaScriptingAPI_getNthInheritedClass MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getNthInheritedClass)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_isExperiment(threadData_t *threadData, modelica_string _name);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_isExperiment(threadData_t *threadData, modelica_metatype _name);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isExperiment,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_isExperiment,0}};
#define boxvar_OpenModelicaScriptingAPI_isExperiment MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_isExperiment)


DLLDirection
modelica_real omc_OpenModelicaScriptingAPI_getSimulationOptions(threadData_t *threadData, modelica_string _name, modelica_real _defaultStartTime, modelica_real _defaultStopTime, modelica_real _defaultTolerance, modelica_integer _defaultNumberOfIntervals, modelica_real _defaultInterval, modelica_real *out_res2, modelica_real *out_res3, modelica_integer *out_res4, modelica_real *out_res5);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getSimulationOptions(threadData_t *threadData, modelica_metatype _name, modelica_metatype _defaultStartTime, modelica_metatype _defaultStopTime, modelica_metatype _defaultTolerance, modelica_metatype _defaultNumberOfIntervals, modelica_metatype _defaultInterval, modelica_metatype *out_res2, modelica_metatype *out_res3, modelica_metatype *out_res4, modelica_metatype *out_res5);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getSimulationOptions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getSimulationOptions,0}};
#define boxvar_OpenModelicaScriptingAPI_getSimulationOptions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getSimulationOptions)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getAnnotationNamedModifiers(threadData_t *threadData, modelica_string _className, modelica_string _annotationName);
#define boxptr_OpenModelicaScriptingAPI_getAnnotationNamedModifiers omc_OpenModelicaScriptingAPI_getAnnotationNamedModifiers
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAnnotationNamedModifiers,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAnnotationNamedModifiers,0}};
#define boxvar_OpenModelicaScriptingAPI_getAnnotationNamedModifiers MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAnnotationNamedModifiers)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getAnnotationModifierValue(threadData_t *threadData, modelica_string _className, modelica_string _annotationName, modelica_string _modifierName);
#define boxptr_OpenModelicaScriptingAPI_getAnnotationModifierValue omc_OpenModelicaScriptingAPI_getAnnotationModifierValue
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAnnotationModifierValue,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAnnotationModifierValue,0}};
#define boxvar_OpenModelicaScriptingAPI_getAnnotationModifierValue MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAnnotationModifierValue)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_classAnnotationExists(threadData_t *threadData, modelica_string _className, modelica_string _annotationName);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_classAnnotationExists(threadData_t *threadData, modelica_metatype _className, modelica_metatype _annotationName);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_classAnnotationExists,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_classAnnotationExists,0}};
#define boxvar_OpenModelicaScriptingAPI_classAnnotationExists MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_classAnnotationExists)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_getBooleanClassAnnotation(threadData_t *threadData, modelica_string _className, modelica_string _annotationName);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getBooleanClassAnnotation(threadData_t *threadData, modelica_metatype _className, modelica_metatype _annotationName);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getBooleanClassAnnotation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getBooleanClassAnnotation,0}};
#define boxvar_OpenModelicaScriptingAPI_getBooleanClassAnnotation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getBooleanClassAnnotation)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_extendsFrom(threadData_t *threadData, modelica_string _className, modelica_string _baseClassName);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_extendsFrom(threadData_t *threadData, modelica_metatype _className, modelica_metatype _baseClassName);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_extendsFrom,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_extendsFrom,0}};
#define boxvar_OpenModelicaScriptingAPI_extendsFrom MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_extendsFrom)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_searchClassNames(threadData_t *threadData, modelica_string _searchText, modelica_boolean _findInText);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_searchClassNames(threadData_t *threadData, modelica_metatype _searchText, modelica_metatype _findInText);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_searchClassNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_searchClassNames,0}};
#define boxvar_OpenModelicaScriptingAPI_searchClassNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_searchClassNames)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getAvailableLibraries(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_getAvailableLibraries omc_OpenModelicaScriptingAPI_getAvailableLibraries
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableLibraries,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAvailableLibraries,0}};
#define boxvar_OpenModelicaScriptingAPI_getAvailableLibraries MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableLibraries)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getAvailableLibraryVersions(threadData_t *threadData, modelica_string _libraryName);
#define boxptr_OpenModelicaScriptingAPI_getAvailableLibraryVersions omc_OpenModelicaScriptingAPI_getAvailableLibraryVersions
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableLibraryVersions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAvailableLibraryVersions,0}};
#define boxvar_OpenModelicaScriptingAPI_getAvailableLibraryVersions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailableLibraryVersions)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_installPackage(threadData_t *threadData, modelica_string _pkg, modelica_string _version, modelica_boolean _exactMatch);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_installPackage(threadData_t *threadData, modelica_metatype _pkg, modelica_metatype _version, modelica_metatype _exactMatch);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_installPackage,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_installPackage,0}};
#define boxvar_OpenModelicaScriptingAPI_installPackage MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_installPackage)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_updatePackageIndex(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_updatePackageIndex(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_updatePackageIndex,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_updatePackageIndex,0}};
#define boxvar_OpenModelicaScriptingAPI_updatePackageIndex MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_updatePackageIndex)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getAvailablePackageVersions(threadData_t *threadData, modelica_string _pkg, modelica_string _version);
#define boxptr_OpenModelicaScriptingAPI_getAvailablePackageVersions omc_OpenModelicaScriptingAPI_getAvailablePackageVersions
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailablePackageVersions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAvailablePackageVersions,0}};
#define boxvar_OpenModelicaScriptingAPI_getAvailablePackageVersions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailablePackageVersions)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getAvailablePackageConversionsTo(threadData_t *threadData, modelica_string _pkg, modelica_string _version);
#define boxptr_OpenModelicaScriptingAPI_getAvailablePackageConversionsTo omc_OpenModelicaScriptingAPI_getAvailablePackageConversionsTo
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailablePackageConversionsTo,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAvailablePackageConversionsTo,0}};
#define boxvar_OpenModelicaScriptingAPI_getAvailablePackageConversionsTo MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailablePackageConversionsTo)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getAvailablePackageConversionsFrom(threadData_t *threadData, modelica_string _pkg, modelica_string _version);
#define boxptr_OpenModelicaScriptingAPI_getAvailablePackageConversionsFrom omc_OpenModelicaScriptingAPI_getAvailablePackageConversionsFrom
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailablePackageConversionsFrom,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getAvailablePackageConversionsFrom,0}};
#define boxvar_OpenModelicaScriptingAPI_getAvailablePackageConversionsFrom MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getAvailablePackageConversionsFrom)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_upgradeInstalledPackages(threadData_t *threadData, modelica_boolean _installNewestVersions);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_upgradeInstalledPackages(threadData_t *threadData, modelica_metatype _installNewestVersions);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_upgradeInstalledPackages,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_upgradeInstalledPackages,0}};
#define boxvar_OpenModelicaScriptingAPI_upgradeInstalledPackages MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_upgradeInstalledPackages)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getUses(threadData_t *threadData, modelica_string _pack);
#define boxptr_OpenModelicaScriptingAPI_getUses omc_OpenModelicaScriptingAPI_getUses
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getUses,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getUses,0}};
#define boxvar_OpenModelicaScriptingAPI_getUses MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getUses)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getConversionsFromVersions(threadData_t *threadData, modelica_string _pack, modelica_metatype *out_res2);
#define boxptr_OpenModelicaScriptingAPI_getConversionsFromVersions omc_OpenModelicaScriptingAPI_getConversionsFromVersions
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getConversionsFromVersions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getConversionsFromVersions,0}};
#define boxvar_OpenModelicaScriptingAPI_getConversionsFromVersions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getConversionsFromVersions)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getDerivedClassModifierNames(threadData_t *threadData, modelica_string _className);
#define boxptr_OpenModelicaScriptingAPI_getDerivedClassModifierNames omc_OpenModelicaScriptingAPI_getDerivedClassModifierNames
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDerivedClassModifierNames,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getDerivedClassModifierNames,0}};
#define boxvar_OpenModelicaScriptingAPI_getDerivedClassModifierNames MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDerivedClassModifierNames)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getDerivedClassModifierValue(threadData_t *threadData, modelica_string _className, modelica_string _modifierName);
#define boxptr_OpenModelicaScriptingAPI_getDerivedClassModifierValue omc_OpenModelicaScriptingAPI_getDerivedClassModifierValue
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDerivedClassModifierValue,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getDerivedClassModifierValue,0}};
#define boxvar_OpenModelicaScriptingAPI_getDerivedClassModifierValue MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDerivedClassModifierValue)


DLLDirection
void omc_OpenModelicaScriptingAPI_generateEntryPoint(threadData_t *threadData, modelica_string _fileName, modelica_string _entryPoint, modelica_string _url);
#define boxptr_OpenModelicaScriptingAPI_generateEntryPoint omc_OpenModelicaScriptingAPI_generateEntryPoint
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateEntryPoint,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateEntryPoint,0}};
#define boxvar_OpenModelicaScriptingAPI_generateEntryPoint MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateEntryPoint)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_numProcessors(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_numProcessors(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_numProcessors,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_numProcessors,0}};
#define boxvar_OpenModelicaScriptingAPI_numProcessors MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_numProcessors)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_runScriptParallel(threadData_t *threadData, modelica_metatype _scripts, modelica_integer _numThreads, modelica_boolean _useThreads);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_runScriptParallel(threadData_t *threadData, modelica_metatype _scripts, modelica_metatype _numThreads, modelica_metatype _useThreads);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_runScriptParallel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_runScriptParallel,0}};
#define boxvar_OpenModelicaScriptingAPI_runScriptParallel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_runScriptParallel)


DLLDirection
void omc_OpenModelicaScriptingAPI_exit(threadData_t *threadData, modelica_integer _status);
DLLDirection
void boxptr_OpenModelicaScriptingAPI_exit(threadData_t *threadData, modelica_metatype _status);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_exit,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_exit,0}};
#define boxvar_OpenModelicaScriptingAPI_exit MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_exit)


DLLDirection
void omc_OpenModelicaScriptingAPI_threadWorkFailed(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_threadWorkFailed omc_OpenModelicaScriptingAPI_threadWorkFailed
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_threadWorkFailed,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_threadWorkFailed,0}};
#define boxvar_OpenModelicaScriptingAPI_threadWorkFailed MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_threadWorkFailed)


DLLDirection
modelica_real omc_OpenModelicaScriptingAPI_getMemorySize(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getMemorySize(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getMemorySize,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getMemorySize,0}};
#define boxvar_OpenModelicaScriptingAPI_getMemorySize MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getMemorySize)


DLLDirection
void omc_OpenModelicaScriptingAPI_GC__gcollect__and__unmap(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_GC__gcollect__and__unmap omc_OpenModelicaScriptingAPI_GC__gcollect__and__unmap
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_GC__gcollect__and__unmap,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_GC__gcollect__and__unmap,0}};
#define boxvar_OpenModelicaScriptingAPI_GC__gcollect__and__unmap MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_GC__gcollect__and__unmap)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_GC__expand__hp(threadData_t *threadData, modelica_integer _size);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_GC__expand__hp(threadData_t *threadData, modelica_metatype _size);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_GC__expand__hp,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_GC__expand__hp,0}};
#define boxvar_OpenModelicaScriptingAPI_GC__expand__hp MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_GC__expand__hp)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_GC__set__max__heap__size(threadData_t *threadData, modelica_integer _size);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_GC__set__max__heap__size(threadData_t *threadData, modelica_metatype _size);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_GC__set__max__heap__size,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_GC__set__max__heap__size,0}};
#define boxvar_OpenModelicaScriptingAPI_GC__set__max__heap__size MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_GC__set__max__heap__size)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_checkInterfaceOfPackages(threadData_t *threadData, modelica_string _cl, modelica_metatype _dependencyMatrix);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_checkInterfaceOfPackages(threadData_t *threadData, modelica_metatype _cl, modelica_metatype _dependencyMatrix);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkInterfaceOfPackages,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_checkInterfaceOfPackages,0}};
#define boxvar_OpenModelicaScriptingAPI_checkInterfaceOfPackages MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_checkInterfaceOfPackages)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_sortStrings(threadData_t *threadData, modelica_metatype _arr);
#define boxptr_OpenModelicaScriptingAPI_sortStrings omc_OpenModelicaScriptingAPI_sortStrings
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_sortStrings,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_sortStrings,0}};
#define boxvar_OpenModelicaScriptingAPI_sortStrings MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_sortStrings)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getClassInformation(threadData_t *threadData, modelica_string _cl, modelica_string *out_res2, modelica_boolean *out_res3, modelica_boolean *out_res4, modelica_boolean *out_res5, modelica_string *out_res6, modelica_boolean *out_res7, modelica_integer *out_res8, modelica_integer *out_res9, modelica_integer *out_res10, modelica_integer *out_res11, modelica_metatype *out_res12, modelica_boolean *out_res13, modelica_boolean *out_res14, modelica_string *out_res15, modelica_string *out_res16, modelica_boolean *out_res17, modelica_string *out_res18, modelica_string *out_res19, modelica_string *out_res20, modelica_string *out_res21, modelica_string *out_res22);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getClassInformation(threadData_t *threadData, modelica_metatype _cl, modelica_metatype *out_res2, modelica_metatype *out_res3, modelica_metatype *out_res4, modelica_metatype *out_res5, modelica_metatype *out_res6, modelica_metatype *out_res7, modelica_metatype *out_res8, modelica_metatype *out_res9, modelica_metatype *out_res10, modelica_metatype *out_res11, modelica_metatype *out_res12, modelica_metatype *out_res13, modelica_metatype *out_res14, modelica_metatype *out_res15, modelica_metatype *out_res16, modelica_metatype *out_res17, modelica_metatype *out_res18, modelica_metatype *out_res19, modelica_metatype *out_res20, modelica_metatype *out_res21, modelica_metatype *out_res22);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassInformation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getClassInformation,0}};
#define boxvar_OpenModelicaScriptingAPI_getClassInformation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getClassInformation)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getDefaultComponentName(threadData_t *threadData, modelica_string _cl);
#define boxptr_OpenModelicaScriptingAPI_getDefaultComponentName omc_OpenModelicaScriptingAPI_getDefaultComponentName
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDefaultComponentName,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getDefaultComponentName,0}};
#define boxvar_OpenModelicaScriptingAPI_getDefaultComponentName MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDefaultComponentName)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getDefaultComponentPrefixes(threadData_t *threadData, modelica_string _cl);
#define boxptr_OpenModelicaScriptingAPI_getDefaultComponentPrefixes omc_OpenModelicaScriptingAPI_getDefaultComponentPrefixes
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDefaultComponentPrefixes,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getDefaultComponentPrefixes,0}};
#define boxvar_OpenModelicaScriptingAPI_getDefaultComponentPrefixes MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDefaultComponentPrefixes)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getEnumerationLiterals(threadData_t *threadData, modelica_string _className);
#define boxptr_OpenModelicaScriptingAPI_getEnumerationLiterals omc_OpenModelicaScriptingAPI_getEnumerationLiterals
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEnumerationLiterals,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getEnumerationLiterals,0}};
#define boxvar_OpenModelicaScriptingAPI_getEnumerationLiterals MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getEnumerationLiterals)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getTransitions(threadData_t *threadData, modelica_string _cl);
#define boxptr_OpenModelicaScriptingAPI_getTransitions omc_OpenModelicaScriptingAPI_getTransitions
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTransitions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getTransitions,0}};
#define boxvar_OpenModelicaScriptingAPI_getTransitions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getTransitions)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_deleteTransition(threadData_t *threadData, modelica_string _cl, modelica_string _from, modelica_string _to, modelica_string _condition, modelica_boolean _immediate, modelica_boolean _reset, modelica_boolean _synchronize, modelica_integer _priority);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_deleteTransition(threadData_t *threadData, modelica_metatype _cl, modelica_metatype _from, modelica_metatype _to, modelica_metatype _condition, modelica_metatype _immediate, modelica_metatype _reset, modelica_metatype _synchronize, modelica_metatype _priority);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deleteTransition,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_deleteTransition,0}};
#define boxvar_OpenModelicaScriptingAPI_deleteTransition MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deleteTransition)


DLLDirection
modelica_metatype omc_OpenModelicaScriptingAPI_getInitialStates(threadData_t *threadData, modelica_string _cl);
#define boxptr_OpenModelicaScriptingAPI_getInitialStates omc_OpenModelicaScriptingAPI_getInitialStates
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialStates,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getInitialStates,0}};
#define boxvar_OpenModelicaScriptingAPI_getInitialStates MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getInitialStates)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_deleteInitialState(threadData_t *threadData, modelica_string _cl, modelica_string _state);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_deleteInitialState(threadData_t *threadData, modelica_metatype _cl, modelica_metatype _state);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deleteInitialState,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_deleteInitialState,0}};
#define boxvar_OpenModelicaScriptingAPI_deleteInitialState MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_deleteInitialState)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_generateScriptingAPI(threadData_t *threadData, modelica_string _cl, modelica_string _name, modelica_string *out_res2, modelica_string *out_res3, modelica_string *out_res4);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_generateScriptingAPI(threadData_t *threadData, modelica_metatype _cl, modelica_metatype _name, modelica_metatype *out_res2, modelica_metatype *out_res3, modelica_metatype *out_res4);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateScriptingAPI,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_generateScriptingAPI,0}};
#define boxvar_OpenModelicaScriptingAPI_generateScriptingAPI MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_generateScriptingAPI)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_runConversionScript(threadData_t *threadData, modelica_string _packageToConvert, modelica_string _scriptFile);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_runConversionScript(threadData_t *threadData, modelica_metatype _packageToConvert, modelica_metatype _scriptFile);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_runConversionScript,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_runConversionScript,0}};
#define boxvar_OpenModelicaScriptingAPI_runConversionScript MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_runConversionScript)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_convertPackageToLibrary(threadData_t *threadData, modelica_string _packageToConvert, modelica_string _library, modelica_string _libraryVersion);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_convertPackageToLibrary(threadData_t *threadData, modelica_metatype _packageToConvert, modelica_metatype _library, modelica_metatype _libraryVersion);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_convertPackageToLibrary,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_convertPackageToLibrary,0}};
#define boxvar_OpenModelicaScriptingAPI_convertPackageToLibrary MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_convertPackageToLibrary)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getModelInstance(threadData_t *threadData, modelica_string _className, modelica_string _modifier, modelica_boolean _prettyPrint);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getModelInstance(threadData_t *threadData, modelica_metatype _className, modelica_metatype _modifier, modelica_metatype _prettyPrint);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getModelInstance,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getModelInstance,0}};
#define boxvar_OpenModelicaScriptingAPI_getModelInstance MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getModelInstance)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getModelInstanceAnnotation(threadData_t *threadData, modelica_string _className, modelica_metatype _filter, modelica_boolean _prettyPrint);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getModelInstanceAnnotation(threadData_t *threadData, modelica_metatype _className, modelica_metatype _filter, modelica_metatype _prettyPrint);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getModelInstanceAnnotation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getModelInstanceAnnotation,0}};
#define boxvar_OpenModelicaScriptingAPI_getModelInstanceAnnotation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getModelInstanceAnnotation)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_modifierToJSON(threadData_t *threadData, modelica_string _modifier, modelica_boolean _prettyPrint);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_modifierToJSON(threadData_t *threadData, modelica_metatype _modifier, modelica_metatype _prettyPrint);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_modifierToJSON,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_modifierToJSON,0}};
#define boxvar_OpenModelicaScriptingAPI_modifierToJSON MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_modifierToJSON)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_storeAST(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_storeAST(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_storeAST,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_storeAST,0}};
#define boxvar_OpenModelicaScriptingAPI_storeAST MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_storeAST)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_restoreAST(threadData_t *threadData, modelica_integer _id);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_restoreAST(threadData_t *threadData, modelica_metatype _id);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_restoreAST,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_restoreAST,0}};
#define boxvar_OpenModelicaScriptingAPI_restoreAST MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_restoreAST)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_qualifyPath(threadData_t *threadData, modelica_string _classPath, modelica_string _path);
#define boxptr_OpenModelicaScriptingAPI_qualifyPath omc_OpenModelicaScriptingAPI_qualifyPath
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_qualifyPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_qualifyPath,0}};
#define boxvar_OpenModelicaScriptingAPI_qualifyPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_qualifyPath)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_getDefinitions(threadData_t *threadData, modelica_boolean _addFunctions);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_getDefinitions(threadData_t *threadData, modelica_metatype _addFunctions);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDefinitions,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_getDefinitions,0}};
#define boxvar_OpenModelicaScriptingAPI_getDefinitions MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_getDefinitions)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_reverseLookup(threadData_t *threadData, modelica_string _name, modelica_string _scope, modelica_boolean _exactMatch, modelica_boolean _prettyPrint);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_reverseLookup(threadData_t *threadData, modelica_metatype _name, modelica_metatype _scope, modelica_metatype _exactMatch, modelica_metatype _prettyPrint);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_reverseLookup,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_reverseLookup,0}};
#define boxvar_OpenModelicaScriptingAPI_reverseLookup MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_reverseLookup)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_loadOMSimulator(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_loadOMSimulator(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadOMSimulator,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_loadOMSimulator,0}};
#define boxvar_OpenModelicaScriptingAPI_loadOMSimulator MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_loadOMSimulator)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_unloadOMSimulator(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_unloadOMSimulator(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_unloadOMSimulator,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_unloadOMSimulator,0}};
#define boxvar_OpenModelicaScriptingAPI_unloadOMSimulator MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_unloadOMSimulator)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__addBus(threadData_t *threadData, modelica_string _cref);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__addBus(threadData_t *threadData, modelica_metatype _cref);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addBus,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__addBus,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__addBus MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addBus)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__addConnection(threadData_t *threadData, modelica_string _crefA, modelica_string _crefB);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__addConnection(threadData_t *threadData, modelica_metatype _crefA, modelica_metatype _crefB);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addConnection,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__addConnection,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__addConnection MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addConnection)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__addConnectorToBus(threadData_t *threadData, modelica_string _busCref, modelica_string _connectorCref);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__addConnectorToBus(threadData_t *threadData, modelica_metatype _busCref, modelica_metatype _connectorCref);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addConnectorToBus,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__addConnectorToBus,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__addConnectorToBus MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addConnectorToBus)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__addConnectorToTLMBus(threadData_t *threadData, modelica_string _busCref, modelica_string _connectorCref, modelica_string _type_);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__addConnectorToTLMBus(threadData_t *threadData, modelica_metatype _busCref, modelica_metatype _connectorCref, modelica_metatype _type_);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addConnectorToTLMBus,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__addConnectorToTLMBus,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__addConnectorToTLMBus MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addConnectorToTLMBus)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__addDynamicValueIndicator(threadData_t *threadData, modelica_string _signal, modelica_string _lower, modelica_string _upper, modelica_real _stepSize);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__addDynamicValueIndicator(threadData_t *threadData, modelica_metatype _signal, modelica_metatype _lower, modelica_metatype _upper, modelica_metatype _stepSize);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addDynamicValueIndicator,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__addDynamicValueIndicator,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__addDynamicValueIndicator MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addDynamicValueIndicator)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__addEventIndicator(threadData_t *threadData, modelica_string _signal);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__addEventIndicator(threadData_t *threadData, modelica_metatype _signal);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addEventIndicator,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__addEventIndicator,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__addEventIndicator MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addEventIndicator)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__addExternalModel(threadData_t *threadData, modelica_string _cref, modelica_string _path, modelica_string _startscript);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__addExternalModel(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _path, modelica_metatype _startscript);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addExternalModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__addExternalModel,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__addExternalModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addExternalModel)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__addSignalsToResults(threadData_t *threadData, modelica_string _cref, modelica_string _regex);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__addSignalsToResults(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _regex);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addSignalsToResults,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__addSignalsToResults,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__addSignalsToResults MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addSignalsToResults)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__addStaticValueIndicator(threadData_t *threadData, modelica_string _signal, modelica_real _lower, modelica_real _upper, modelica_real _stepSize);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__addStaticValueIndicator(threadData_t *threadData, modelica_metatype _signal, modelica_metatype _lower, modelica_metatype _upper, modelica_metatype _stepSize);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addStaticValueIndicator,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__addStaticValueIndicator,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__addStaticValueIndicator MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addStaticValueIndicator)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__addSubModel(threadData_t *threadData, modelica_string _cref, modelica_string _fmuPath);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__addSubModel(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _fmuPath);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addSubModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__addSubModel,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__addSubModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addSubModel)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__addTimeIndicator(threadData_t *threadData, modelica_string _signal);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__addTimeIndicator(threadData_t *threadData, modelica_metatype _signal);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addTimeIndicator,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__addTimeIndicator,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__addTimeIndicator MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addTimeIndicator)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__addTLMConnection(threadData_t *threadData, modelica_string _crefA, modelica_string _crefB, modelica_real _delay, modelica_real _alpha, modelica_real _linearimpedance, modelica_real _angularimpedance);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__addTLMConnection(threadData_t *threadData, modelica_metatype _crefA, modelica_metatype _crefB, modelica_metatype _delay, modelica_metatype _alpha, modelica_metatype _linearimpedance, modelica_metatype _angularimpedance);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addTLMConnection,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__addTLMConnection,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__addTLMConnection MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__addTLMConnection)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__compareSimulationResults(threadData_t *threadData, modelica_string _filenameA, modelica_string _filenameB, modelica_string _var, modelica_real _relTol, modelica_real _absTol);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__compareSimulationResults(threadData_t *threadData, modelica_metatype _filenameA, modelica_metatype _filenameB, modelica_metatype _var, modelica_metatype _relTol, modelica_metatype _absTol);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__compareSimulationResults,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__compareSimulationResults,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__compareSimulationResults MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__compareSimulationResults)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__copySystem(threadData_t *threadData, modelica_string _source, modelica_string _target);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__copySystem(threadData_t *threadData, modelica_metatype _source, modelica_metatype _target);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__copySystem,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__copySystem,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__copySystem MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__copySystem)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__delete(threadData_t *threadData, modelica_string _cref);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__delete(threadData_t *threadData, modelica_metatype _cref);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__delete,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__delete,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__delete MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__delete)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__deleteConnection(threadData_t *threadData, modelica_string _crefA, modelica_string _crefB);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__deleteConnection(threadData_t *threadData, modelica_metatype _crefA, modelica_metatype _crefB);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__deleteConnection,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__deleteConnection,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__deleteConnection MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__deleteConnection)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__deleteConnectorFromBus(threadData_t *threadData, modelica_string _busCref, modelica_string _connectorCref);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__deleteConnectorFromBus(threadData_t *threadData, modelica_metatype _busCref, modelica_metatype _connectorCref);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__deleteConnectorFromBus,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__deleteConnectorFromBus,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__deleteConnectorFromBus MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__deleteConnectorFromBus)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__deleteConnectorFromTLMBus(threadData_t *threadData, modelica_string _busCref, modelica_string _connectorCref);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__deleteConnectorFromTLMBus(threadData_t *threadData, modelica_metatype _busCref, modelica_metatype _connectorCref);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__deleteConnectorFromTLMBus,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__deleteConnectorFromTLMBus,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__deleteConnectorFromTLMBus MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__deleteConnectorFromTLMBus)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__export(threadData_t *threadData, modelica_string _cref, modelica_string _filename);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__export(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _filename);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__export,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__export,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__export MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__export)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__exportDependencyGraphs(threadData_t *threadData, modelica_string _cref, modelica_string _initialization, modelica_string _event, modelica_string _simulation);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__exportDependencyGraphs(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _initialization, modelica_metatype _event, modelica_metatype _simulation);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__exportDependencyGraphs,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__exportDependencyGraphs,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__exportDependencyGraphs MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__exportDependencyGraphs)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_oms__exportSnapshot(threadData_t *threadData, modelica_string _cref, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__exportSnapshot(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__exportSnapshot,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__exportSnapshot,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__exportSnapshot MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__exportSnapshot)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__extractFMIKind(threadData_t *threadData, modelica_string _filename, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__extractFMIKind(threadData_t *threadData, modelica_metatype _filename, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__extractFMIKind,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__extractFMIKind,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__extractFMIKind MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__extractFMIKind)


DLLDirection
modelica_boolean omc_OpenModelicaScriptingAPI_oms__getBoolean(threadData_t *threadData, modelica_string _cref, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__getBoolean(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getBoolean,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getBoolean,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getBoolean MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getBoolean)


DLLDirection
modelica_real omc_OpenModelicaScriptingAPI_oms__getFixedStepSize(threadData_t *threadData, modelica_string _cref, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__getFixedStepSize(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getFixedStepSize,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getFixedStepSize,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getFixedStepSize MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getFixedStepSize)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__getInteger(threadData_t *threadData, modelica_string _cref, modelica_integer _value);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__getInteger(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _value);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getInteger,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getInteger,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getInteger MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getInteger)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__getModelState(threadData_t *threadData, modelica_string _cref, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__getModelState(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getModelState,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getModelState,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getModelState MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getModelState)


DLLDirection
modelica_real omc_OpenModelicaScriptingAPI_oms__getReal(threadData_t *threadData, modelica_string _cref, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__getReal(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getReal,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getReal,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getReal MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getReal)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__getSolver(threadData_t *threadData, modelica_string _cref, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__getSolver(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getSolver,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getSolver,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getSolver MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getSolver)


DLLDirection
modelica_real omc_OpenModelicaScriptingAPI_oms__getStartTime(threadData_t *threadData, modelica_string _cref, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__getStartTime(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getStartTime,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getStartTime,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getStartTime MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getStartTime)


DLLDirection
modelica_real omc_OpenModelicaScriptingAPI_oms__getStopTime(threadData_t *threadData, modelica_string _cref, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__getStopTime(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getStopTime,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getStopTime,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getStopTime MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getStopTime)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_oms__getSubModelPath(threadData_t *threadData, modelica_string _cref, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__getSubModelPath(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getSubModelPath,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getSubModelPath,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getSubModelPath MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getSubModelPath)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__getSystemType(threadData_t *threadData, modelica_string _cref, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__getSystemType(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getSystemType,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getSystemType,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getSystemType MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getSystemType)


DLLDirection
modelica_real omc_OpenModelicaScriptingAPI_oms__getTolerance(threadData_t *threadData, modelica_string _cref, modelica_real *out_res2, modelica_integer *out_res3);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__getTolerance(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2, modelica_metatype *out_res3);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getTolerance,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getTolerance,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getTolerance MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getTolerance)


DLLDirection
modelica_real omc_OpenModelicaScriptingAPI_oms__getVariableStepSize(threadData_t *threadData, modelica_string _cref, modelica_real *out_res2, modelica_real *out_res3, modelica_integer *out_res4);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__getVariableStepSize(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2, modelica_metatype *out_res3, modelica_metatype *out_res4);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getVariableStepSize,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getVariableStepSize,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getVariableStepSize MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getVariableStepSize)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_oms__importFile(threadData_t *threadData, modelica_string _filename, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__importFile(threadData_t *threadData, modelica_metatype _filename, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__importFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__importFile,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__importFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__importFile)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__importSnapshot(threadData_t *threadData, modelica_string _cref, modelica_string _snapshot);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__importSnapshot(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _snapshot);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__importSnapshot,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__importSnapshot,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__importSnapshot MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__importSnapshot)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__initialize(threadData_t *threadData, modelica_string _cref);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__initialize(threadData_t *threadData, modelica_metatype _cref);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__initialize,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__initialize,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__initialize MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__initialize)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__instantiate(threadData_t *threadData, modelica_string _cref);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__instantiate(threadData_t *threadData, modelica_metatype _cref);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__instantiate,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__instantiate,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__instantiate MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__instantiate)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_oms__list(threadData_t *threadData, modelica_string _cref, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__list(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__list,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__list,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__list MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__list)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_oms__listUnconnectedConnectors(threadData_t *threadData, modelica_string _cref, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__listUnconnectedConnectors(threadData_t *threadData, modelica_metatype _cref, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__listUnconnectedConnectors,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__listUnconnectedConnectors,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__listUnconnectedConnectors MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__listUnconnectedConnectors)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_oms__loadSnapshot(threadData_t *threadData, modelica_string _cref, modelica_string _snapshot, modelica_integer *out_res2);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__loadSnapshot(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _snapshot, modelica_metatype *out_res2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__loadSnapshot,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__loadSnapshot,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__loadSnapshot MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__loadSnapshot)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__newModel(threadData_t *threadData, modelica_string _cref);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__newModel(threadData_t *threadData, modelica_metatype _cref);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__newModel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__newModel,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__newModel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__newModel)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__removeSignalsFromResults(threadData_t *threadData, modelica_string _cref, modelica_string _regex);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__removeSignalsFromResults(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _regex);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__removeSignalsFromResults,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__removeSignalsFromResults,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__removeSignalsFromResults MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__removeSignalsFromResults)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__rename(threadData_t *threadData, modelica_string _cref, modelica_string _newCref);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__rename(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _newCref);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__rename,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__rename,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__rename MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__rename)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__reset(threadData_t *threadData, modelica_string _cref);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__reset(threadData_t *threadData, modelica_metatype _cref);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__reset,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__reset,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__reset MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__reset)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__RunFile(threadData_t *threadData, modelica_string _filename);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__RunFile(threadData_t *threadData, modelica_metatype _filename);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__RunFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__RunFile,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__RunFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__RunFile)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setBoolean(threadData_t *threadData, modelica_string _cref, modelica_boolean _value);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setBoolean(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _value);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setBoolean,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setBoolean,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setBoolean MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setBoolean)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setCommandLineOption(threadData_t *threadData, modelica_string _cmd);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setCommandLineOption(threadData_t *threadData, modelica_metatype _cmd);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setCommandLineOption,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setCommandLineOption,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setCommandLineOption MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setCommandLineOption)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setFixedStepSize(threadData_t *threadData, modelica_string _cref, modelica_real _stepSize);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setFixedStepSize(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _stepSize);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setFixedStepSize,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setFixedStepSize,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setFixedStepSize MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setFixedStepSize)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setInteger(threadData_t *threadData, modelica_string _cref, modelica_integer _value);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setInteger(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _value);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setInteger,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setInteger,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setInteger MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setInteger)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setLogFile(threadData_t *threadData, modelica_string _filename);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setLogFile(threadData_t *threadData, modelica_metatype _filename);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setLogFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setLogFile,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setLogFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setLogFile)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setLoggingInterval(threadData_t *threadData, modelica_string _cref, modelica_real _loggingInterval);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setLoggingInterval(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _loggingInterval);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setLoggingInterval,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setLoggingInterval,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setLoggingInterval MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setLoggingInterval)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setLoggingLevel(threadData_t *threadData, modelica_integer _logLevel);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setLoggingLevel(threadData_t *threadData, modelica_metatype _logLevel);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setLoggingLevel,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setLoggingLevel,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setLoggingLevel MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setLoggingLevel)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setReal(threadData_t *threadData, modelica_string _cref, modelica_real _value);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setReal(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _value);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setReal,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setReal,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setReal MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setReal)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setRealInputDerivative(threadData_t *threadData, modelica_string _cref, modelica_real _value);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setRealInputDerivative(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _value);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setRealInputDerivative,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setRealInputDerivative,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setRealInputDerivative MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setRealInputDerivative)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setResultFile(threadData_t *threadData, modelica_string _cref, modelica_string _filename, modelica_integer _bufferSize);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setResultFile(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _filename, modelica_metatype _bufferSize);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setResultFile,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setResultFile,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setResultFile MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setResultFile)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setSignalFilter(threadData_t *threadData, modelica_string _cref, modelica_string _regex);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setSignalFilter(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _regex);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setSignalFilter,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setSignalFilter,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setSignalFilter MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setSignalFilter)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setStartTime(threadData_t *threadData, modelica_string _cref, modelica_real _startTime);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setStartTime(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _startTime);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setStartTime,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setStartTime,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setStartTime MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setStartTime)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setStopTime(threadData_t *threadData, modelica_string _cref, modelica_real _stopTime);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setStopTime(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _stopTime);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setStopTime,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setStopTime,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setStopTime MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setStopTime)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setTempDirectory(threadData_t *threadData, modelica_string _newTempDir);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setTempDirectory(threadData_t *threadData, modelica_metatype _newTempDir);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setTempDirectory,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setTempDirectory,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setTempDirectory MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setTempDirectory)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setTLMPositionAndOrientation(threadData_t *threadData, modelica_string _cref, modelica_real _x1, modelica_real _x2, modelica_real _x3, modelica_real _A11, modelica_real _A12, modelica_real _A13, modelica_real _A21, modelica_real _A22, modelica_real _A23, modelica_real _A31, modelica_real _A32, modelica_real _A33);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setTLMPositionAndOrientation(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _x1, modelica_metatype _x2, modelica_metatype _x3, modelica_metatype _A11, modelica_metatype _A12, modelica_metatype _A13, modelica_metatype _A21, modelica_metatype _A22, modelica_metatype _A23, modelica_metatype _A31, modelica_metatype _A32, modelica_metatype _A33);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setTLMPositionAndOrientation,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setTLMPositionAndOrientation,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setTLMPositionAndOrientation MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setTLMPositionAndOrientation)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setTLMSocketData(threadData_t *threadData, modelica_string _cref, modelica_string _address, modelica_integer _managerPort, modelica_integer _monitorPort);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setTLMSocketData(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _address, modelica_metatype _managerPort, modelica_metatype _monitorPort);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setTLMSocketData,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setTLMSocketData,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setTLMSocketData MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setTLMSocketData)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setTolerance(threadData_t *threadData, modelica_string _cref, modelica_real _absoluteTolerance, modelica_real _relativeTolerance);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setTolerance(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _absoluteTolerance, modelica_metatype _relativeTolerance);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setTolerance,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setTolerance,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setTolerance MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setTolerance)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setVariableStepSize(threadData_t *threadData, modelica_string _cref, modelica_real _initialStepSize, modelica_real _minimumStepSize, modelica_real _maximumStepSize);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setVariableStepSize(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _initialStepSize, modelica_metatype _minimumStepSize, modelica_metatype _maximumStepSize);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setVariableStepSize,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setVariableStepSize,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setVariableStepSize MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setVariableStepSize)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__setWorkingDirectory(threadData_t *threadData, modelica_string _newWorkingDir);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__setWorkingDirectory(threadData_t *threadData, modelica_metatype _newWorkingDir);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setWorkingDirectory,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__setWorkingDirectory,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__setWorkingDirectory MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__setWorkingDirectory)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__simulate(threadData_t *threadData, modelica_string _cref);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__simulate(threadData_t *threadData, modelica_metatype _cref);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__simulate,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__simulate,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__simulate MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__simulate)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__stepUntil(threadData_t *threadData, modelica_string _cref, modelica_real _stopTime);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__stepUntil(threadData_t *threadData, modelica_metatype _cref, modelica_metatype _stopTime);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__stepUntil,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__stepUntil,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__stepUntil MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__stepUntil)


DLLDirection
modelica_integer omc_OpenModelicaScriptingAPI_oms__terminate(threadData_t *threadData, modelica_string _cref);
DLLDirection
modelica_metatype boxptr_OpenModelicaScriptingAPI_oms__terminate(threadData_t *threadData, modelica_metatype _cref);
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__terminate,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__terminate,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__terminate MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__terminate)


DLLDirection
modelica_string omc_OpenModelicaScriptingAPI_oms__getVersion(threadData_t *threadData);
#define boxptr_OpenModelicaScriptingAPI_oms__getVersion omc_OpenModelicaScriptingAPI_oms__getVersion
static const MMC_DEFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getVersion,2,0) {(void*) boxptr_OpenModelicaScriptingAPI_oms__getVersion,0}};
#define boxvar_OpenModelicaScriptingAPI_oms__getVersion MMC_REFSTRUCTLIT(boxvar_lit_OpenModelicaScriptingAPI_oms__getVersion)

#ifdef __cplusplus
}
#endif
#endif
