/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.gjt.sp.jedit.BeanShellFacade;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.gui.BeanShellErrorDialog;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class BeanShell {
    private static final BeanShellFacade<View> bsh = new MyBeanShellFacade();
    private static boolean running;

    static void init() {
        Log.log(3, BeanShell.class, "Beanshell Init");
    }

    public static void evalSelection(View view, JEditTextArea jEditTextArea) {
        bsh.evalSelection(view, jEditTextArea);
    }

    public static void showEvaluateDialog(View view) {
        String string = GUIUtilities.input(view, "beanshell-eval-input", null);
        if (string != null) {
            if (!string.endsWith(";")) {
                string = string + ";";
            }
            int n = view.getInputHandler().getRepeatCount();
            if (view.getMacroRecorder() != null) {
                view.getMacroRecorder().record(n, string);
            }
            Object object = null;
            try {
                for (int i = 0; i < n; ++i) {
                    object = bsh._eval(view, bsh.getNameSpace(), string);
                }
            }
            catch (Throwable throwable) {
                Log.log(9, BeanShell.class, throwable);
                bsh.handleException(view, null, throwable);
            }
            if (object != null) {
                Object[] objectArray = new String[]{object.toString()};
                GUIUtilities.message(view, "beanshell-eval", objectArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showEvaluateLinesDialog(View view) {
        String string = GUIUtilities.input(view, "beanshell-eval-line", null);
        JEditTextArea jEditTextArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        if (string == null || string.length() == 0) {
            return;
        }
        Selection[] selectionArray = jEditTextArea.getSelection();
        if (selectionArray.length == 0) {
            view.getToolkit().beep();
            return;
        }
        if (!string.endsWith(";")) {
            string = string + ";";
        }
        String string2 = "int[] lines = textArea.getSelectedLines();\nfor(int i = 0; i < lines.length; i++)\n{\nline = lines[i];\nindex = line - lines[0];\nstart = buffer.getLineStartOffset(line);\nend = buffer.getLineEndOffset(line);\ntext = buffer.getText(start,end - start - 1);\nnewText = " + string + "\n" + "if(newText != null)\n" + "{\n" + "buffer.remove(start,end - start - 1);\n" + "buffer.insert(start,String.valueOf(newText));\n" + "}\n" + "}\n";
        if (view.getMacroRecorder() != null) {
            view.getMacroRecorder().record(1, string2);
        }
        try {
            buffer.beginCompoundEdit();
            bsh.eval(view, string2);
        }
        finally {
            buffer.endCompoundEdit();
        }
        jEditTextArea.selectNone();
    }

    public static void runScript(View view, String string, Reader reader, boolean bl) {
        try {
            BeanShell._runScript(view, string, reader, bl);
        }
        catch (Throwable throwable) {
            Log.log(9, BeanShell.class, throwable);
            bsh.handleException(view, string, throwable);
        }
    }

    public static void runScript(View view, String string, Reader reader, NameSpace nameSpace) {
        try {
            BeanShell._runScript(view, string, reader, nameSpace);
        }
        catch (Throwable throwable) {
            Log.log(9, BeanShell.class, throwable);
            bsh.handleException(view, string, throwable);
        }
    }

    public static void _runScript(View view, String string, Reader reader, boolean bl) throws Exception {
        BeanShell._runScript(view, string, reader, bl ? new NameSpace(bsh.getNameSpace(), "namespace") : bsh.getNameSpace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _runScript(View view, String string, Reader reader, NameSpace nameSpace) throws Exception {
        Log.log(3, BeanShell.class, "Running script " + string);
        Interpreter interpreter = BeanShellFacade.createInterpreter(nameSpace);
        try {
            if (reader == null) {
                Buffer buffer = jEdit.openTemporary(null, null, string, false);
                if (!buffer.isLoaded()) {
                    VFSManager.waitForRequests();
                }
                reader = new StringReader(buffer.getText(0, buffer.getLength()));
            }
            bsh.setupDefaultVariables(nameSpace, view);
            interpreter.set("scriptPath", string);
            running = true;
            interpreter.eval(reader, nameSpace, string);
        }
        catch (Exception exception) {
            BeanShellFacade.unwrapException(exception);
        }
        finally {
            running = false;
            try {
                if (nameSpace == bsh.getNameSpace()) {
                    bsh.resetDefaultVariables(nameSpace);
                    interpreter.unset("scriptPath");
                }
            }
            catch (EvalError evalError) {}
        }
    }

    public static Object eval(View view, NameSpace nameSpace, String string) {
        return bsh.eval(view, nameSpace, string);
    }

    public static Object _eval(View view, NameSpace nameSpace, String string) throws Exception {
        return bsh._eval(view, nameSpace, string);
    }

    public static BshMethod cacheBlock(String string, String string2, boolean bl) throws Exception {
        return bsh.cacheBlock(string, string2, bl);
    }

    public static Object runCachedBlock(BshMethod bshMethod, View view, NameSpace nameSpace) throws Exception {
        return bsh.runCachedBlock(bshMethod, view, nameSpace);
    }

    public static boolean isScriptRunning() {
        return running;
    }

    public static NameSpace getNameSpace() {
        return bsh.getNameSpace();
    }

    static void resetClassManager() {
        bsh.resetClassManager();
    }

    private static class MyBeanShellFacade
    extends BeanShellFacade<View> {
        private MyBeanShellFacade() {
            this.classManager.setClassLoader(new JARClassLoader());
        }

        @Override
        protected void init() {
            super.init();
            this.global.importPackage("org.gjt.sp.jedit.browser");
            this.global.importPackage("org.gjt.sp.jedit.bufferset");
            this.global.importPackage("org.gjt.sp.jedit.statusbar");
            this.global.importPackage("org.gjt.sp.jedit.gui");
            this.global.importPackage("org.gjt.sp.jedit.help");
            this.global.importPackage("org.gjt.sp.jedit.io");
            this.global.importPackage("org.gjt.sp.jedit.menu");
            this.global.importPackage("org.gjt.sp.jedit.msg");
            this.global.importPackage("org.gjt.sp.jedit.options");
            this.global.importPackage("org.gjt.sp.jedit.pluginmgr");
            this.global.importPackage("org.gjt.sp.jedit.print");
            this.global.importPackage("org.gjt.sp.jedit.search");
        }

        @Override
        protected void setupDefaultVariables(NameSpace nameSpace, View view) throws UtilEvalError {
            if (view != null) {
                EditPane editPane = view.getEditPane();
                this.setVariable(nameSpace, "view", view);
                this.setVariable(nameSpace, "editPane", editPane);
                this.setVariable(nameSpace, "buffer", editPane.getBuffer());
                this.setVariable(nameSpace, "textArea", editPane.getTextArea());
                this.setVariable(nameSpace, "wm", view.getDockableWindowManager());
            }
        }

        @Override
        protected void resetDefaultVariables(NameSpace nameSpace) throws UtilEvalError {
            nameSpace.setVariable("view", null, false);
            nameSpace.setVariable("editPane", null, false);
            nameSpace.setVariable("buffer", null, false);
            nameSpace.setVariable("textArea", null, false);
            nameSpace.setVariable("wm", null, false);
        }

        @Override
        protected void handleException(View view, String string, Throwable throwable) {
            if (throwable instanceof IOException) {
                VFSManager.error(view, string, "ioerror.read-error", new String[]{throwable.toString()});
            } else {
                new BeanShellErrorDialog(view, throwable);
            }
        }
    }
}

