/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.EnhancedMenu;
import org.gjt.sp.util.Log;

public abstract class EditPlugin {
    PluginJAR jar;

    public void start() {
    }

    public void stop() {
    }

    public File getPluginHome() {
        return EditPlugin.getPluginHome(this.getClassName());
    }

    public static File getPluginHome(Class<? extends EditPlugin> clazz) {
        return EditPlugin.getPluginHome(clazz.getName());
    }

    public static File getPluginHome(EditPlugin editPlugin) {
        return EditPlugin.getPluginHome(editPlugin.getClassName());
    }

    private static File getPluginHome(String string) {
        String string2 = jEdit.getSettingsDirectory();
        if (string2 == null) {
            return null;
        }
        File file = new File(string2, "plugins");
        if (!file.isDirectory() && !file.mkdir()) {
            Log.log(9, EditPlugin.class, "Can't create directory:" + file.getAbsolutePath());
        }
        return new File(file, string);
    }

    public static InputStream getResourceAsStream(Class<? extends EditPlugin> clazz, String string) {
        return EditPlugin.getResourceAsStream(clazz.getName(), string);
    }

    public static InputStream getResourceAsStream(EditPlugin editPlugin, String string) {
        return EditPlugin.getResourceAsStream(editPlugin.getClassName(), string);
    }

    private static InputStream getResourceAsStream(String string, String string2) {
        try {
            File file = EditPlugin.getResourcePath(string, string2);
            if (file == null || !file.exists()) {
                return null;
            }
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static OutputStream getResourceAsOutputStream(Class<? extends EditPlugin> clazz, String string) {
        return EditPlugin.getResourceAsOutputStream(clazz.getName(), string);
    }

    public static OutputStream getResourceAsOutputStream(EditPlugin editPlugin, String string) {
        return EditPlugin.getResourceAsOutputStream(editPlugin.getClassName(), string);
    }

    private static OutputStream getResourceAsOutputStream(String string, String string2) {
        try {
            File file = EditPlugin.getResourcePath(string, string2);
            if (file == null) {
                return null;
            }
            File file2 = file.getParentFile();
            if (!file2.exists() && !file2.mkdirs()) {
                Log.log(9, EditPlugin.class, "Unable to create folder " + file2.getPath());
                return null;
            }
            return new FileOutputStream(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File getResourcePath(Class<? extends EditPlugin> clazz, String string) {
        return EditPlugin.getResourcePath(clazz.getName(), string);
    }

    public static File getResourcePath(EditPlugin editPlugin, String string) {
        return EditPlugin.getResourcePath(editPlugin.getClassName(), string);
    }

    private static File getResourcePath(String string, String string2) {
        File file = EditPlugin.getPluginHome(string);
        if (file == null) {
            return null;
        }
        return new File(file, string2);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public PluginJAR getPluginJAR() {
        return this.jar;
    }

    public final JMenuItem createMenuItems() {
        if (this instanceof Broken) {
            return null;
        }
        String string = jEdit.getProperty("plugin." + this.getClassName() + ".menu-item");
        if (string != null) {
            return GUIUtilities.loadMenuItem(string);
        }
        String string2 = "plugin." + this.getClassName() + ".menu";
        String string3 = "plugin." + this.getClassName() + ".menu.code";
        if (jEdit.getProperty(string2) != null || jEdit.getProperty(string3) != null) {
            String string4 = jEdit.getProperty("plugin." + this.getClassName() + ".name");
            return new EnhancedMenu(string2, string4);
        }
        return null;
    }

    public final JMenuItem createBrowserMenuItems() {
        if (this instanceof Broken) {
            return null;
        }
        String string = jEdit.getProperty("plugin." + this.getClassName() + ".browser-menu-item");
        if (string != null) {
            return GUIUtilities.loadMenuItem(VFSBrowser.getActionContext(), string, false);
        }
        String string2 = "plugin." + this.getClassName() + ".browser-menu";
        String string3 = "plugin." + this.getClassName() + ".browser-menu.code";
        if (jEdit.getProperty(string2) != null || jEdit.getProperty(string3) != null) {
            String string4 = jEdit.getProperty("plugin." + this.getClassName() + ".name");
            return new EnhancedMenu(string2, string4, VFSBrowser.getActionContext());
        }
        return null;
    }

    public static class Deferred
    extends EditPlugin {
        private final String clazz;

        @Override
        public String getClassName() {
            return this.clazz;
        }

        Deferred(PluginJAR pluginJAR, String string) {
            this.jar = pluginJAR;
            this.clazz = string;
        }

        EditPlugin loadPluginClass() {
            return null;
        }

        public String toString() {
            return "Deferred[" + this.clazz + ']';
        }
    }

    public static class Broken
    extends EditPlugin {
        private final String clazz;

        @Override
        public String getClassName() {
            return this.clazz;
        }

        Broken(PluginJAR pluginJAR, String string) {
            this.jar = pluginJAR;
            this.clazz = string;
        }
    }
}

