/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.buffer.DummyFoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class PluginJAR {
    private final String path;
    private String cachePath;
    private final File file;
    private final JARClassLoader classLoader;
    private ZipFile zipFile;
    private Properties properties;
    private String[] classes;
    private String[] resources;
    private ActionSet actions;
    private ActionSet browserActions;
    private EditPlugin plugin;
    private URL dockablesURI;
    private URL servicesURI;
    private boolean activated;
    private final Set<String> theseRequireMe = new LinkedHashSet<String>();
    private final Set<String> theseUseMe = new LinkedHashSet<String>();
    private final Set<String> weRequireThese = new LinkedHashSet<String>();
    private final Set<String> weUseThese = new LinkedHashSet<String>();

    public static PluginJAR load(String string, boolean bl) {
        String string2;
        Object object;
        Object object2;
        Object object3;
        PluginJAR pluginJAR = jEdit.getPluginJAR(string);
        if (pluginJAR != null && pluginJAR.getPlugin() != null) {
            return pluginJAR;
        }
        jEdit.addPluginJAR(string);
        pluginJAR = jEdit.getPluginJAR(string);
        EditPlugin editPlugin = pluginJAR.getPlugin();
        if (editPlugin == null) {
            return pluginJAR;
        }
        String string3 = editPlugin.getClassName();
        if (bl) {
            object3 = PluginJAR.getDependencySet(string3);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                string2 = PluginJAR.findPlugin((String)object);
                if (string2 == null) {
                    Log.log(7, PluginJAR.class, "Unable to load dependency " + (String)object + " the plugin is not installed");
                    continue;
                }
                PluginJAR.load(string2, true);
            }
        }
        if ((object3 = jEdit.getProperty("plugin." + string3 + ".jars")) != null) {
            object2 = MiscUtilities.getParentOfPath(string);
            object = new StringTokenizer((String)object3);
            while (((StringTokenizer)object).hasMoreTokens()) {
                string2 = MiscUtilities.constructPath((String)object2, ((StringTokenizer)object).nextToken());
                PluginJAR pluginJAR2 = jEdit.getPluginJAR(string2);
                if (pluginJAR2 != null) continue;
                jEdit.addPluginJAR(string2);
            }
        }
        pluginJAR.checkDependencies();
        pluginJAR.activatePluginIfNecessary();
        jEdit.propertiesChanged();
        return pluginJAR;
    }

    public String getPath() {
        return this.path;
    }

    public static String findPlugin(String string) {
        EditPlugin editPlugin = jEdit.getPlugin(string);
        if (editPlugin != null) {
            return editPlugin.getPluginJAR().getPath();
        }
        for (String string2 : jEdit.getNotLoadedPluginJARs()) {
            PluginJAR pluginJAR = new PluginJAR(new File(string2));
            if (!pluginJAR.containsClass(string)) continue;
            return string2;
        }
        return null;
    }

    boolean containsClass(String string) {
        try {
            this.getZipFile();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = enumeration.nextElement().toString();
            if (!string3.endsWith(".class") || !(string2 = string3.substring(0, string3.length() - 6).replace('/', '.')).equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public static Set<String> getDependencySet(String string) {
        String string2;
        Set<String> set = new LinkedHashSet<String>();
        int n = 0;
        while ((string2 = jEdit.getProperty("plugin." + string + ".depend." + n++)) != null) {
            PluginDepends pluginDepends;
            try {
                pluginDepends = PluginJAR.getPluginDepends(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.log(9, PluginJAR.class, string + " has an invalid dependency: " + string2);
                continue;
            }
            if (!pluginDepends.what.equals("plugin")) continue;
            int n2 = pluginDepends.arg.indexOf(32);
            if (n2 == -1) {
                Log.log(9, PluginJAR.class, string + " has an invalid dependency: " + string2 + " (version is missing)");
                continue;
            }
            String string3 = pluginDepends.arg.substring(0, n2);
            String string4 = pluginDepends.arg.substring(n2 + 1);
            Set<String> set2 = PluginJAR.getDependencySet(string3);
            set2.add(string3);
            set2.addAll(set);
            set = set2;
        }
        return set;
    }

    public File getFile() {
        return this.file;
    }

    public JARClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized ZipFile getZipFile() throws IOException {
        if (this.zipFile == null) {
            Log.log(1, this, "Opening " + this.path);
            this.zipFile = new ZipFile(this.path);
        }
        return this.zipFile;
    }

    public ActionSet getActionSet() {
        return this.actions;
    }

    public ActionSet getBrowserActionSet() {
        return this.browserActions;
    }

    public boolean checkDependencies() {
        Object object;
        Object object2;
        String string;
        Object[] objectArray;
        Object object3;
        String string2;
        if (this.plugin == null) {
            return true;
        }
        int n = 0;
        boolean bl = true;
        String string3 = this.plugin.getClassName();
        while ((string2 = jEdit.getProperty("plugin." + string3 + ".depend." + n++)) != null) {
            try {
                object3 = PluginJAR.getPluginDepends(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.log(9, this, string3 + " has an invalid" + " dependency: " + string2);
                bl = false;
                continue;
            }
            if (((PluginDepends)object3).what.equals("jdk")) {
                if (((PluginDepends)object3).optional || StandardUtilities.compareStrings(System.getProperty("java.version"), ((PluginDepends)object3).arg, false) >= 0) continue;
                Object[] objectArray2 = new String[]{((PluginDepends)object3).arg, System.getProperty("java.version")};
                jEdit.pluginError(this.path, "plugin-error.dep-jdk", objectArray2);
                bl = false;
                continue;
            }
            if (((PluginDepends)object3).what.equals("jedit")) {
                if (((PluginDepends)object3).arg.length() != 11) {
                    Log.log(9, this, "Invalid jEdit version number: " + ((PluginDepends)object3).arg);
                    bl = false;
                }
                if (((PluginDepends)object3).optional || StandardUtilities.compareStrings(jEdit.getBuild(), ((PluginDepends)object3).arg, false) >= 0) continue;
                String string4 = MiscUtilities.buildToVersion(((PluginDepends)object3).arg);
                objectArray = new String[]{string4, jEdit.getVersion()};
                jEdit.pluginError(this.path, "plugin-error.dep-jedit", objectArray);
                bl = false;
                continue;
            }
            if (((PluginDepends)object3).what.equals("plugin")) {
                Object[] objectArray3;
                int n2 = ((PluginDepends)object3).arg.indexOf(32);
                if (n2 == -1) {
                    Log.log(9, this, string3 + " has an invalid dependency: " + string2 + " (version is missing)");
                    bl = false;
                    continue;
                }
                objectArray = ((PluginDepends)object3).arg.substring(0, n2);
                string = ((PluginDepends)object3).arg.substring(n2 + 1);
                object2 = jEdit.getProperty("plugin." + (String)objectArray + ".version");
                object = jEdit.getPlugin((String)objectArray, false);
                if (object == null) {
                    if (((PluginDepends)object3).optional) continue;
                    objectArray3 = new String[]{string, objectArray};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin.no-version", objectArray3);
                    bl = false;
                    continue;
                }
                if (StandardUtilities.compareStrings((String)object2, string, false) < 0) {
                    if (((PluginDepends)object3).optional) continue;
                    objectArray3 = new String[]{string, objectArray, object2};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin", objectArray3);
                    bl = false;
                    continue;
                }
                if (object instanceof EditPlugin.Broken) {
                    if (((PluginDepends)object3).optional) continue;
                    objectArray3 = new String[]{objectArray};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin.broken", objectArray3);
                    bl = false;
                    continue;
                }
                objectArray3 = ((EditPlugin)object).getPluginJAR();
                if (((PluginDepends)object3).optional) {
                    objectArray3.theseUseMe.add(this.path);
                    this.weUseThese.add(objectArray3.getPath());
                    continue;
                }
                objectArray3.theseRequireMe.add(this.path);
                this.weRequireThese.add(objectArray3.getPath());
                continue;
            }
            if (((PluginDepends)object3).what.equals("class")) {
                if (((PluginDepends)object3).optional) continue;
                try {
                    this.classLoader.loadClass(((PluginDepends)object3).arg, false);
                }
                catch (Exception exception) {
                    objectArray = new String[]{((PluginDepends)object3).arg};
                    jEdit.pluginError(this.path, "plugin-error.dep-class", objectArray);
                    bl = false;
                }
                continue;
            }
            Log.log(9, this, string3 + " has unknown" + " dependency: " + string2);
            bl = false;
        }
        object3 = jEdit.getProperty("plugin." + this.plugin.getClassName() + ".jars");
        if (object3 != null) {
            String string5 = MiscUtilities.getParentOfPath(this.path);
            objectArray = new StringTokenizer((String)object3);
            while (objectArray.hasMoreTokens()) {
                string = MiscUtilities.constructPath(string5, objectArray.nextToken());
                object2 = jEdit.getPluginJAR(string);
                if (object2 == null) {
                    object = new String[]{string};
                    jEdit.pluginError(this.path, "plugin-error.missing-jar", (Object[])object);
                    bl = false;
                    continue;
                }
                this.weRequireThese.add(string);
                ((PluginJAR)object2).theseRequireMe.add(this.path);
            }
        }
        if (!bl) {
            this.breakPlugin();
        }
        return bl;
    }

    public Set<String> getRequiredJars() {
        return this.weRequireThese;
    }

    private static PluginDepends getPluginDepends(String string) throws IllegalArgumentException {
        boolean bl;
        if (string.startsWith("optional ")) {
            bl = true;
            string = string.substring("optional ".length());
        } else {
            bl = false;
        }
        int n = string.indexOf(32);
        if (n == -1) {
            throw new IllegalArgumentException("wrong dependency");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        PluginDepends pluginDepends = new PluginDepends();
        pluginDepends.what = string2;
        pluginDepends.arg = string3;
        pluginDepends.optional = bl;
        return pluginDepends;
    }

    public static void transitiveClosure(String[] stringArray, List<String> list) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (list.contains(string)) continue;
            list.add(string);
            PluginJAR pluginJAR = jEdit.getPluginJAR(string);
            PluginJAR.transitiveClosure(pluginJAR.getDependentPlugins(), list);
        }
    }

    public String[] getDependentPlugins() {
        return this.theseRequireMe.toArray(new String[this.theseRequireMe.size()]);
    }

    public EditPlugin getPlugin() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activatePlugin() {
        Object object = this;
        synchronized (object) {
            if (this.activated) {
                return;
            }
            this.activated = true;
        }
        if (!(this.plugin instanceof EditPlugin.Deferred)) {
            return;
        }
        object = this.plugin.getClassName();
        try {
            Class clazz = this.classLoader.loadClass((String)object, false);
            int n = clazz.getModifiers();
            if (Modifier.isInterface(n) || Modifier.isAbstract(n) || !EditPlugin.class.isAssignableFrom(clazz)) {
                Log.log(9, this, "Plugin has properties but does not extend EditPlugin: " + (String)object);
                this.breakPlugin();
                return;
            }
            this.plugin = (EditPlugin)clazz.newInstance();
            this.plugin.jar = this;
        }
        catch (Throwable throwable) {
            this.breakPlugin();
            Log.log(9, this, "Error while starting plugin " + (String)object);
            Log.log(9, this, throwable);
            Object[] objectArray = new String[]{throwable.toString()};
            jEdit.pluginError(this.path, "plugin-error.start-error", objectArray);
            return;
        }
        if (jEdit.isMainThread() || SwingUtilities.isEventDispatchThread()) {
            this.startPlugin();
        } else {
            this.startPluginLater();
        }
        EditBus.sendAsync(new PluginUpdate(this, PluginUpdate.ACTIVATED, false));
    }

    public void activatePluginIfNecessary() {
        String string = MiscUtilities.getFileName(this.getPath());
        jEdit.unsetProperty("plugin-blacklist." + string);
        if (!(this.plugin instanceof EditPlugin.Deferred) || this.plugin == null) {
            return;
        }
        String string2 = this.plugin.getClassName();
        String string3 = jEdit.getProperty("plugin." + string2 + ".activate");
        if (string3 == null) {
            if (!jEdit.isMainThread()) {
                this.breakPlugin();
                jEdit.pluginError(this.path, "plugin-error.not-42", null);
            } else {
                this.activatePlugin();
            }
        } else {
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                boolean bl2 = jEdit.getBooleanProperty(string4);
                if (!bl2) continue;
                Log.log(1, this, "Activating " + string2 + " because of " + string4);
                bl = true;
                break;
            }
            if (bl) {
                this.activatePlugin();
            }
        }
    }

    public void deactivatePlugin(boolean bl) {
        Object object;
        if (!this.activated) {
            return;
        }
        if (!bl) {
            for (object = jEdit.getFirstBuffer(); object != null; object = ((Buffer)object).getNext()) {
                if (((JEditBuffer)object).getFoldHandler() == null || ((JEditBuffer)object).getFoldHandler().getClass().getClassLoader() != this.classLoader) continue;
                ((JEditBuffer)object).setFoldHandler(new DummyFoldHandler());
            }
        }
        if (this.plugin != null && !(this.plugin instanceof EditPlugin.Broken)) {
            if (this.plugin instanceof EBPlugin || this.plugin.getClass().getAnnotation(EditBus.EBHandler.class) != null) {
                EditBus.removeFromBus(this.plugin);
            }
            try {
                this.plugin.stop();
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Error while stopping plugin:");
                Log.log(9, this, throwable);
            }
            this.plugin = new EditPlugin.Deferred(this, this.plugin.getClassName());
            EditBus.send(new PluginUpdate(this, PluginUpdate.DEACTIVATED, bl));
            if (!bl && (object = jEdit.getProperty("plugin." + this.plugin.getClassName() + ".activate")) == null) {
                this.breakPlugin();
                jEdit.pluginError(this.path, "plugin-error.not-42", null);
            }
        }
        this.activated = false;
    }

    public URL getDockablesURI() {
        return this.dockablesURI;
    }

    public URL getServicesURI() {
        return this.servicesURI;
    }

    public String toString() {
        if (this.plugin == null) {
            return this.path;
        }
        return this.path + ",class=" + this.plugin.getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static PluginCacheEntry getPluginCache(PluginJAR pluginJAR) {
        PluginCacheEntry pluginCacheEntry;
        String string = pluginJAR.getCachePath();
        if (string == null) {
            return null;
        }
        DataInputStream dataInputStream = null;
        try {
            PluginCacheEntry pluginCacheEntry2 = new PluginCacheEntry();
            pluginCacheEntry2.plugin = pluginJAR;
            pluginCacheEntry2.modTime = pluginJAR.getFile().lastModified();
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            if (pluginCacheEntry2.read(dataInputStream)) {
                PluginCacheEntry pluginCacheEntry3 = pluginCacheEntry2;
                IOUtilities.closeQuietly(dataInputStream);
                return pluginCacheEntry3;
            }
            pluginCacheEntry = null;
            IOUtilities.closeQuietly(dataInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            PluginCacheEntry pluginCacheEntry4 = null;
            return pluginCacheEntry4;
        }
        catch (IOException iOException) {
            Log.log(9, PluginJAR.class, iOException);
            PluginCacheEntry pluginCacheEntry5 = null;
            return pluginCacheEntry5;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtilities.closeQuietly(dataInputStream);
        }
        return pluginCacheEntry;
    }

    static void setPluginCache(PluginJAR pluginJAR, PluginCacheEntry pluginCacheEntry) {
        String string = pluginJAR.getCachePath();
        if (string == null) {
            return;
        }
        Log.log(1, PluginJAR.class, "Writing " + string);
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            pluginCacheEntry.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            Log.log(9, PluginJAR.class, iOException);
            IOUtilities.closeQuietly(dataOutputStream);
            new File(string).delete();
        }
    }

    public PluginJAR(File file) {
        this.path = file.getPath();
        String string = jEdit.getJARCacheDirectory();
        if (string != null) {
            this.cachePath = MiscUtilities.constructPath(string, file.getName() + ".summary");
        }
        this.file = file;
        this.classLoader = new JARClassLoader(this);
        this.actions = new ActionSet();
    }

    void init() {
        PluginCacheEntry pluginCacheEntry = PluginJAR.getPluginCache(this);
        if (pluginCacheEntry != null) {
            this.loadCache(pluginCacheEntry);
            this.classLoader.activate();
        } else {
            try {
                pluginCacheEntry = this.generateCache();
                if (pluginCacheEntry != null) {
                    PluginJAR.setPluginCache(this, pluginCacheEntry);
                    this.classLoader.activate();
                }
            }
            catch (IOException iOException) {
                Log.log(9, this, "Cannot load plugin " + this.path);
                Log.log(9, this, iOException);
                Object[] objectArray = new String[]{iOException.toString()};
                jEdit.pluginError(this.path, "plugin-error.load-error", objectArray);
                this.uninit(false);
            }
        }
    }

    void uninit(boolean bl) {
        this.deactivatePlugin(bl);
        if (!bl) {
            PluginJAR pluginJAR;
            for (String string : this.weRequireThese) {
                pluginJAR = jEdit.getPluginJAR(string);
                if (pluginJAR == null) continue;
                pluginJAR.theseRequireMe.remove(this.path);
            }
            for (String string : this.weUseThese) {
                pluginJAR = jEdit.getPluginJAR(string);
                if (pluginJAR == null) continue;
                pluginJAR.theseUseMe.remove(this.path);
            }
            this.classLoader.deactivate();
            BeanShell.resetClassManager();
            if (this.actions != null) {
                jEdit.removeActionSet(this.actions);
            }
            if (this.browserActions != null) {
                VFSBrowser.getActionContext().removeActionSet(this.browserActions);
            }
            DockableWindowFactory.getInstance().unloadDockableWindows(this);
            ServiceManager.unloadServices(this);
            jEdit.removePluginProps(this.properties);
            try {
                if (this.zipFile != null) {
                    this.zipFile.close();
                    this.zipFile = null;
                }
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
            }
        }
    }

    String[] getClasses() {
        return this.classes;
    }

    public String[] getResources() {
        return this.resources;
    }

    private void actionsPresentButNotCoreClass() {
        Log.log(7, this, this.getPath() + " has an actions.xml but no plugin core class");
        this.actions.setLabel("MISSING PLUGIN CORE CLASS");
    }

    private void loadCache(PluginCacheEntry pluginCacheEntry) {
        String string;
        this.classes = pluginCacheEntry.classes;
        this.resources = pluginCacheEntry.resources;
        if (pluginCacheEntry.cachedProperties != null) {
            this.properties = pluginCacheEntry.cachedProperties;
            jEdit.addPluginProps(pluginCacheEntry.cachedProperties);
        }
        if (pluginCacheEntry.actionsURI != null && pluginCacheEntry.cachedActionNames != null) {
            this.actions = new ActionSet(this, pluginCacheEntry.cachedActionNames, pluginCacheEntry.cachedActionToggleFlags, pluginCacheEntry.actionsURI);
        }
        if (pluginCacheEntry.browserActionsURI != null && pluginCacheEntry.cachedBrowserActionNames != null) {
            this.browserActions = new ActionSet(this, pluginCacheEntry.cachedBrowserActionNames, pluginCacheEntry.cachedBrowserActionToggleFlags, pluginCacheEntry.browserActionsURI);
            string = jEdit.getProperty("plugin." + pluginCacheEntry.pluginClass + ".name");
            this.browserActions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{string}));
            VFSBrowser.getActionContext().addActionSet(this.browserActions);
        }
        if (pluginCacheEntry.dockablesURI != null && pluginCacheEntry.cachedDockableNames != null && pluginCacheEntry.cachedDockableActionFlags != null && pluginCacheEntry.cachedDockableMovableFlags != null) {
            this.dockablesURI = pluginCacheEntry.dockablesURI;
            DockableWindowFactory.getInstance().cacheDockableWindows(this, pluginCacheEntry.cachedDockableNames, pluginCacheEntry.cachedDockableActionFlags, pluginCacheEntry.cachedDockableMovableFlags);
        }
        if (this.actions.size() != 0) {
            jEdit.addActionSet(this.actions);
        }
        if (pluginCacheEntry.servicesURI != null && pluginCacheEntry.cachedServices != null) {
            this.servicesURI = pluginCacheEntry.servicesURI;
            for (int i = 0; i < pluginCacheEntry.cachedServices.length; ++i) {
                ServiceManager.Descriptor descriptor = pluginCacheEntry.cachedServices[i];
                ServiceManager.registerService(descriptor);
            }
        }
        if (pluginCacheEntry.pluginClass != null) {
            if (jEdit.getPlugin(pluginCacheEntry.pluginClass) != null) {
                jEdit.pluginError(this.path, "plugin-error.already-loaded", null);
                this.uninit(false);
            } else {
                string = jEdit.getProperty("plugin." + pluginCacheEntry.pluginClass + ".name");
                this.actions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{string}));
                this.plugin = new EditPlugin.Deferred(this, pluginCacheEntry.pluginClass);
            }
        } else if (this.actions.size() != 0) {
            this.actionsPresentButNotCoreClass();
        }
    }

    public PluginCacheEntry generateCache() throws IOException {
        Object object;
        Object object2;
        this.properties = new Properties();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        ZipFile zipFile = this.getZipFile();
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        PluginCacheEntry pluginCacheEntry = new PluginCacheEntry();
        pluginCacheEntry.modTime = this.file.lastModified();
        pluginCacheEntry.cachedProperties = new Properties();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            String string = ((ZipEntry)object2).getName();
            String string2 = string.toLowerCase();
            if (string2.equals("actions.xml")) {
                pluginCacheEntry.actionsURI = this.classLoader.getResource(string);
                continue;
            }
            if (string2.equals("browser.actions.xml")) {
                pluginCacheEntry.browserActionsURI = this.classLoader.getResource(string);
                continue;
            }
            if (string2.equals("dockables.xml")) {
                pluginCacheEntry.dockablesURI = this.dockablesURI = this.classLoader.getResource(string);
                continue;
            }
            if (string2.equals("services.xml")) {
                pluginCacheEntry.servicesURI = this.servicesURI = this.classLoader.getResource(string);
                continue;
            }
            if (string2.endsWith(".props")) {
                object = this.classLoader.getResourceAsStream(string);
                this.properties.load((InputStream)object);
                ((InputStream)object).close();
                continue;
            }
            if (string.endsWith(".class")) {
                object = MiscUtilities.fileToClass(string);
                if (((String)object).endsWith("Plugin")) {
                    linkedList3.add(object);
                }
                linkedList.add(object);
                continue;
            }
            linkedList2.add(string);
        }
        pluginCacheEntry.cachedProperties = this.properties;
        jEdit.addPluginProps(this.properties);
        pluginCacheEntry.classes = linkedList.toArray(new String[linkedList.size()]);
        this.classes = pluginCacheEntry.classes;
        pluginCacheEntry.resources = linkedList2.toArray(new String[linkedList2.size()]);
        this.resources = pluginCacheEntry.resources;
        object2 = null;
        for (String string : linkedList3) {
            object = jEdit.getProperty("plugin." + string + ".name");
            String string2 = jEdit.getProperty("plugin." + string + ".version");
            if (object == null || string2 == null) {
                Log.log(7, this, "Ignoring: " + string);
                continue;
            }
            pluginCacheEntry.pluginClass = string;
            if (jEdit.getPlugin(string) != null) {
                jEdit.pluginError(this.path, "plugin-error.already-loaded", null);
                return null;
            }
            this.plugin = new EditPlugin.Deferred(this, string);
            object2 = object;
            break;
        }
        if (pluginCacheEntry.actionsURI != null) {
            this.actions = new ActionSet(this, null, null, pluginCacheEntry.actionsURI);
            this.actions.load();
            pluginCacheEntry.cachedActionNames = this.actions.getCacheableActionNames();
            pluginCacheEntry.cachedActionToggleFlags = new boolean[pluginCacheEntry.cachedActionNames.length];
            for (int i = 0; i < pluginCacheEntry.cachedActionNames.length; ++i) {
                pluginCacheEntry.cachedActionToggleFlags[i] = jEdit.getBooleanProperty(pluginCacheEntry.cachedActionNames[i] + ".toggle");
            }
        }
        if (pluginCacheEntry.browserActionsURI != null) {
            this.browserActions = new ActionSet(this, null, null, pluginCacheEntry.browserActionsURI);
            this.browserActions.load();
            VFSBrowser.getActionContext().addActionSet(this.browserActions);
            pluginCacheEntry.cachedBrowserActionNames = this.browserActions.getCacheableActionNames();
            pluginCacheEntry.cachedBrowserActionToggleFlags = new boolean[pluginCacheEntry.cachedBrowserActionNames.length];
            for (int i = 0; i < pluginCacheEntry.cachedBrowserActionNames.length; ++i) {
                pluginCacheEntry.cachedBrowserActionToggleFlags[i] = jEdit.getBooleanProperty(pluginCacheEntry.cachedBrowserActionNames[i] + ".toggle");
            }
        }
        if (this.dockablesURI != null) {
            DockableWindowFactory.getInstance().loadDockableWindows(this, this.dockablesURI, pluginCacheEntry);
        }
        if (this.actions.size() != 0) {
            if (object2 != null) {
                this.actions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{object2}));
            } else {
                this.actionsPresentButNotCoreClass();
            }
            jEdit.addActionSet(this.actions);
        }
        if (this.servicesURI != null) {
            ServiceManager.loadServices(this, this.servicesURI, pluginCacheEntry);
        }
        return pluginCacheEntry;
    }

    private void startPlugin() {
        Object[] objectArray;
        try {
            this.plugin.start();
        }
        catch (Throwable throwable) {
            this.breakPlugin();
            Log.log(9, this, "Error while starting plugin " + this.plugin.getClassName());
            Log.log(9, this, throwable);
            objectArray = new String[]{throwable.toString()};
            jEdit.pluginError(this.path, "plugin-error.start-error", objectArray);
        }
        if (this.plugin instanceof EBPlugin || this.plugin.getClass().getAnnotation(EditBus.EBHandler.class) != null) {
            if (jEdit.getProperty("plugin." + this.plugin.getClassName() + ".activate") == null) {
                ((EBComponent)((Object)this.plugin)).handleMessage(new PropertiesChanged(null));
            }
            EditBus.addToBus(this.plugin);
        }
        for (Buffer buffer = jEdit.getFirstBuffer(); buffer != null; buffer = buffer.getNext()) {
            objectArray = FoldHandler.getFoldHandler(buffer.getStringProperty("folding"));
            if (buffer.getFoldHandler() == null || objectArray == null || objectArray == buffer.getFoldHandler()) continue;
            buffer.setFoldHandler((FoldHandler)objectArray);
        }
    }

    private void startPluginLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!PluginJAR.this.activated) {
                    return;
                }
                PluginJAR.this.startPlugin();
            }
        });
    }

    private void breakPlugin() {
        this.plugin = new EditPlugin.Broken(this, this.plugin.getClassName());
        this.uninit(false);
        jEdit.addPluginProps(this.properties);
    }

    public static class PluginCacheEntry {
        public static final int MAGIC = -1214061534;
        public PluginJAR plugin;
        public long modTime;
        public String[] classes;
        public String[] resources;
        public URL actionsURI;
        public String[] cachedActionNames;
        public boolean[] cachedActionToggleFlags;
        public URL browserActionsURI;
        public String[] cachedBrowserActionNames;
        public boolean[] cachedBrowserActionToggleFlags;
        public URL dockablesURI;
        public String[] cachedDockableNames;
        public boolean[] cachedDockableActionFlags;
        public boolean[] cachedDockableMovableFlags;
        public URL servicesURI;
        ServiceManager.Descriptor[] cachedServices;
        public Properties cachedProperties;
        public String pluginClass;

        public boolean read(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n != -1214061534) {
                return false;
            }
            String string = PluginCacheEntry.readString(dataInputStream);
            if (!string.equals(jEdit.getBuild())) {
                return false;
            }
            long l = dataInputStream.readLong();
            if (l != this.modTime) {
                return false;
            }
            this.actionsURI = PluginCacheEntry.readURI(dataInputStream);
            this.cachedActionNames = PluginCacheEntry.readStringArray(dataInputStream);
            this.cachedActionToggleFlags = PluginCacheEntry.readBooleanArray(dataInputStream);
            this.browserActionsURI = PluginCacheEntry.readURI(dataInputStream);
            this.cachedBrowserActionNames = PluginCacheEntry.readStringArray(dataInputStream);
            this.cachedBrowserActionToggleFlags = PluginCacheEntry.readBooleanArray(dataInputStream);
            this.dockablesURI = PluginCacheEntry.readURI(dataInputStream);
            this.cachedDockableNames = PluginCacheEntry.readStringArray(dataInputStream);
            this.cachedDockableActionFlags = PluginCacheEntry.readBooleanArray(dataInputStream);
            this.cachedDockableMovableFlags = PluginCacheEntry.readBooleanArray(dataInputStream);
            this.servicesURI = PluginCacheEntry.readURI(dataInputStream);
            int n2 = dataInputStream.readInt();
            if (n2 == 0) {
                this.cachedServices = null;
            } else {
                this.cachedServices = new ServiceManager.Descriptor[n2];
                for (int i = 0; i < n2; ++i) {
                    ServiceManager.Descriptor descriptor;
                    this.cachedServices[i] = descriptor = new ServiceManager.Descriptor(PluginCacheEntry.readString(dataInputStream), PluginCacheEntry.readString(dataInputStream), null, this.plugin);
                }
            }
            this.classes = PluginCacheEntry.readStringArray(dataInputStream);
            this.resources = PluginCacheEntry.readStringArray(dataInputStream);
            this.cachedProperties = PluginCacheEntry.readMap(dataInputStream);
            this.pluginClass = PluginCacheEntry.readString(dataInputStream);
            return true;
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(-1214061534);
            PluginCacheEntry.writeString(dataOutputStream, jEdit.getBuild());
            dataOutputStream.writeLong(this.modTime);
            PluginCacheEntry.writeString(dataOutputStream, this.actionsURI);
            PluginCacheEntry.writeStringArray(dataOutputStream, this.cachedActionNames);
            PluginCacheEntry.writeBooleanArray(dataOutputStream, this.cachedActionToggleFlags);
            PluginCacheEntry.writeString(dataOutputStream, this.browserActionsURI);
            PluginCacheEntry.writeStringArray(dataOutputStream, this.cachedBrowserActionNames);
            PluginCacheEntry.writeBooleanArray(dataOutputStream, this.cachedBrowserActionToggleFlags);
            PluginCacheEntry.writeString(dataOutputStream, this.dockablesURI);
            PluginCacheEntry.writeStringArray(dataOutputStream, this.cachedDockableNames);
            PluginCacheEntry.writeBooleanArray(dataOutputStream, this.cachedDockableActionFlags);
            PluginCacheEntry.writeBooleanArray(dataOutputStream, this.cachedDockableMovableFlags);
            PluginCacheEntry.writeString(dataOutputStream, this.servicesURI);
            if (this.cachedServices == null) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(this.cachedServices.length);
                for (int i = 0; i < this.cachedServices.length; ++i) {
                    PluginCacheEntry.writeString(dataOutputStream, this.cachedServices[i].clazz);
                    PluginCacheEntry.writeString(dataOutputStream, this.cachedServices[i].name);
                }
            }
            PluginCacheEntry.writeStringArray(dataOutputStream, this.classes);
            PluginCacheEntry.writeStringArray(dataOutputStream, this.resources);
            PluginCacheEntry.writeMap(dataOutputStream, this.cachedProperties);
            PluginCacheEntry.writeString(dataOutputStream, this.pluginClass);
        }

        private static String readString(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n == 0) {
                return null;
            }
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = dataInputStream.readChar();
            }
            return new String(cArray);
        }

        private static URL readURI(DataInputStream dataInputStream) throws IOException {
            String string = PluginCacheEntry.readString(dataInputStream);
            if (string == null) {
                return null;
            }
            return new URL(string);
        }

        private static String[] readStringArray(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n == 0) {
                return null;
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = PluginCacheEntry.readString(dataInputStream);
            }
            return stringArray;
        }

        private static boolean[] readBooleanArray(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n == 0) {
                return null;
            }
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = dataInputStream.readBoolean();
            }
            return blArray;
        }

        private static Properties readMap(DataInputStream dataInputStream) throws IOException {
            Properties properties = new Properties();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                String string = PluginCacheEntry.readString(dataInputStream);
                String string2 = PluginCacheEntry.readString(dataInputStream);
                if (string2 == null) {
                    string2 = "";
                }
                properties.put(string, string2);
            }
            return properties;
        }

        private static void writeString(DataOutputStream dataOutputStream, Object object) throws IOException {
            if (object == null) {
                dataOutputStream.writeInt(0);
            } else {
                String string = object.toString();
                dataOutputStream.writeInt(string.length());
                dataOutputStream.writeChars(string);
            }
        }

        private static void writeStringArray(DataOutputStream dataOutputStream, String[] stringArray) throws IOException {
            if (stringArray == null) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    PluginCacheEntry.writeString(dataOutputStream, stringArray[i]);
                }
            }
        }

        private static void writeBooleanArray(DataOutputStream dataOutputStream, boolean[] blArray) throws IOException {
            if (blArray == null) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(blArray.length);
                for (int i = 0; i < blArray.length; ++i) {
                    dataOutputStream.writeBoolean(blArray[i]);
                }
            }
        }

        private static void writeMap(DataOutputStream dataOutputStream, Map map) throws IOException {
            dataOutputStream.writeInt(map.size());
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                PluginCacheEntry.writeString(dataOutputStream, entry.getKey());
                PluginCacheEntry.writeString(dataOutputStream, entry.getValue());
            }
        }
    }

    private static class PluginDepends {
        String what;
        String arg;
        boolean optional;

        private PluginDepends() {
        }
    }
}

