/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.util.StandardUtilities;

public class TextUtilities {
    public static final int BRACKET_MATCH_LIMIT = 10000;
    public static final int WHITESPACE = 0;
    public static final int WORD_CHAR = 1;
    public static final int SYMBOL = 2;
    public static final int MIXED = 0;
    public static final int LOWER_CASE = 1;
    public static final int UPPER_CASE = 2;
    public static final int TITLE_CASE = 3;

    public static Token getTokenAtOffset(Token token, int n) {
        if (n == 0 && token.id == 127) {
            return token;
        }
        while (true) {
            if (token.id == 127) {
                throw new ArrayIndexOutOfBoundsException("offset > line length");
            }
            if (token.offset + token.length > n) {
                return token;
            }
            token = token.next;
        }
    }

    public static char getComplementaryBracket(char c, boolean[] blArray) {
        switch (c) {
            case '(': {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return ')';
            }
            case ')': {
                if (blArray != null) {
                    blArray[0] = false;
                }
                return '(';
            }
            case '[': {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return ']';
            }
            case ']': {
                if (blArray != null) {
                    blArray[0] = false;
                }
                return '[';
            }
            case '{': {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return '}';
            }
            case '}': {
                if (blArray != null) {
                    blArray[0] = false;
                }
                return '{';
            }
            case '<': {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return '>';
            }
            case '>': {
                if (blArray != null) {
                    blArray[0] = false;
                }
                return '<';
            }
        }
        return '\u0000';
    }

    public static int findMatchingBracket(JEditBuffer jEditBuffer, int n, int n2) {
        if (n2 < 0 || n2 >= jEditBuffer.getLineLength(n)) {
            throw new ArrayIndexOutOfBoundsException(n2 + ":" + jEditBuffer.getLineLength(n));
        }
        Segment segment = new Segment();
        jEditBuffer.getLineText(n, segment);
        char c = segment.array[segment.offset + n2];
        boolean[] blArray = new boolean[1];
        char c2 = TextUtilities.getComplementaryBracket(c, blArray);
        if (c2 == '\u0000') {
            return -1;
        }
        int n3 = 1;
        DefaultTokenHandler defaultTokenHandler = new DefaultTokenHandler();
        jEditBuffer.markTokens(n, defaultTokenHandler);
        byte by = TextUtilities.getTokenAtOffset((Token)defaultTokenHandler.getTokens(), (int)n2).id;
        boolean bl = true;
        int n4 = n;
        if (blArray[0]) {
            ++n2;
            while (true) {
                for (int i = n2; i < segment.count; ++i) {
                    char c3 = segment.array[segment.offset + i];
                    if (c3 == c) {
                        if (!bl) {
                            defaultTokenHandler.init();
                            jEditBuffer.markTokens(n, defaultTokenHandler);
                            bl = true;
                        }
                        if (TextUtilities.getTokenAtOffset((Token)defaultTokenHandler.getTokens(), (int)i).id != by) continue;
                        ++n3;
                        continue;
                    }
                    if (c3 != c2) continue;
                    if (!bl) {
                        defaultTokenHandler.init();
                        jEditBuffer.markTokens(n, defaultTokenHandler);
                        bl = true;
                    }
                    if (TextUtilities.getTokenAtOffset((Token)defaultTokenHandler.getTokens(), (int)i).id != by || --n3 != 0) continue;
                    return jEditBuffer.getLineStartOffset(n) + i;
                }
                if (++n < jEditBuffer.getLineCount() && n - n4 <= 10000) {
                    jEditBuffer.getLineText(n, segment);
                    n2 = 0;
                    bl = false;
                    continue;
                }
                break;
            }
        } else {
            --n2;
            while (true) {
                for (int i = n2; i >= 0; --i) {
                    char c4 = segment.array[segment.offset + i];
                    if (c4 == c) {
                        if (!bl) {
                            defaultTokenHandler.init();
                            jEditBuffer.markTokens(n, defaultTokenHandler);
                            bl = true;
                        }
                        if (TextUtilities.getTokenAtOffset((Token)defaultTokenHandler.getTokens(), (int)i).id != by) continue;
                        ++n3;
                        continue;
                    }
                    if (c4 != c2) continue;
                    if (!bl) {
                        defaultTokenHandler.init();
                        jEditBuffer.markTokens(n, defaultTokenHandler);
                        bl = true;
                    }
                    if (TextUtilities.getTokenAtOffset((Token)defaultTokenHandler.getTokens(), (int)i).id != by || --n3 != 0) continue;
                    return jEditBuffer.getLineStartOffset(n) + i;
                }
                if (--n < 0 || n4 - n > 10000) break;
                jEditBuffer.getLineText(n, segment);
                n2 = segment.count - 1;
                bl = false;
            }
        }
        return -1;
    }

    public static String join(Collection<String> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
        } else {
            return "";
        }
        while (iterator.hasNext()) {
            stringBuilder.append(string);
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString();
    }

    public static int findWordStart(String string, int n, String string2) {
        return TextUtilities.findWordStart(string, n, string2, true, false);
    }

    public static int findWordStart(CharSequence charSequence, int n, String string) {
        return TextUtilities.findWordStart(charSequence, n, string, true, false, false);
    }

    public static int findWordStart(String string, int n, String string2, boolean bl) {
        return TextUtilities.findWordStart(string, n, string2, bl, false);
    }

    public static int findWordStart(String string, int n, String string2, boolean bl, boolean bl2) {
        return TextUtilities.findWordStart(string, n, string2, bl, false, bl2);
    }

    public static int findWordStart(String string, int n, String string2, boolean bl, boolean bl2, boolean bl3) {
        return TextUtilities.findWordStart((CharSequence)string, n, string2, bl, bl2, bl3);
    }

    public static int findWordStart(CharSequence charSequence, int n, String string, boolean bl, boolean bl2, boolean bl3) {
        return TextUtilities.findWordStart(charSequence, n, string, bl, bl2, bl3, false);
    }

    public static int findWordStart(CharSequence charSequence, int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        char c = charSequence.charAt(n);
        if (string == null) {
            string = "";
        }
        int n2 = TextUtilities.getCharType(c, string);
        block5: for (int i = n; i >= 0; --i) {
            char c2 = c;
            c = charSequence.charAt(i);
            switch (n2) {
                case 0: {
                    if (Character.isWhitespace(c)) continue block5;
                    if (!bl4) {
                        return i + 1;
                    }
                    if (Character.isLetterOrDigit(c) || string.indexOf(c) != -1) {
                        n2 = 1;
                        continue block5;
                    }
                    n2 = 2;
                    continue block5;
                }
                case 1: {
                    if (bl2 && Character.isUpperCase(c) && !Character.isUpperCase(c2) && Character.isLetterOrDigit(c2)) {
                        return i;
                    }
                    if (bl2 && !Character.isUpperCase(c) && Character.isUpperCase(c2)) {
                        return i + 1;
                    }
                    if (Character.isLetterOrDigit(c) || string.indexOf(c) != -1) continue block5;
                    if (Character.isWhitespace(c) && bl3 && !bl4) {
                        n2 = 0;
                        continue block5;
                    }
                    return i + 1;
                }
                case 2: {
                    if (!bl && n != i) {
                        return i + 1;
                    }
                    if (Character.isWhitespace(c)) {
                        if (bl3 && !bl4) {
                            n2 = 0;
                            continue block5;
                        }
                        return i + 1;
                    }
                    if (!Character.isLetterOrDigit(c) && string.indexOf(c) == -1) continue block5;
                    return i + 1;
                }
            }
        }
        return 0;
    }

    public static int findWordEnd(String string, int n, String string2) {
        return TextUtilities.findWordEnd(string, n, string2, true);
    }

    public static int findWordEnd(CharSequence charSequence, int n, String string) {
        return TextUtilities.findWordEnd(charSequence, n, string, true, false, false);
    }

    public static int findWordEnd(String string, int n, String string2, boolean bl) {
        return TextUtilities.findWordEnd(string, n, string2, bl, false);
    }

    public static int findWordEnd(String string, int n, String string2, boolean bl, boolean bl2) {
        return TextUtilities.findWordEnd(string, n, string2, bl, false, bl2);
    }

    public static int findWordEnd(String string, int n, String string2, boolean bl, boolean bl2, boolean bl3) {
        return TextUtilities.findWordEnd((CharSequence)string, n, string2, bl, bl2, bl3);
    }

    public static int findWordEnd(CharSequence charSequence, int n, String string, boolean bl, boolean bl2, boolean bl3) {
        if (n != 0) {
            --n;
        }
        char c = charSequence.charAt(n);
        if (string == null) {
            string = "";
        }
        int n2 = TextUtilities.getCharType(c, string);
        block5: for (int i = n; i < charSequence.length(); ++i) {
            char c2 = c;
            c = charSequence.charAt(i);
            switch (n2) {
                case 0: {
                    if (Character.isWhitespace(c)) continue block5;
                    return i;
                }
                case 1: {
                    if (bl2 && i > n + 1 && !Character.isUpperCase(c) && Character.isLetterOrDigit(c) && Character.isUpperCase(c2)) {
                        return i - 1;
                    }
                    if (bl2 && Character.isUpperCase(c) && !Character.isUpperCase(c2)) {
                        return i;
                    }
                    if (Character.isLetterOrDigit(c) || string.indexOf(c) != -1) continue block5;
                    if (Character.isWhitespace(c) && bl3) {
                        n2 = 0;
                        continue block5;
                    }
                    return i;
                }
                case 2: {
                    if (!bl && i != n) {
                        return i;
                    }
                    if (Character.isWhitespace(c)) {
                        if (bl3) {
                            n2 = 0;
                            continue block5;
                        }
                        return i;
                    }
                    if (!Character.isLetterOrDigit(c) && string.indexOf(c) == -1) continue block5;
                    return i;
                }
            }
        }
        return charSequence.length();
    }

    public static int getCharType(char c, String string) {
        int n = Character.isWhitespace(c) ? 0 : (Character.isLetterOrDigit(c) || string.indexOf(c) != -1 ? 1 : 2);
        return n;
    }

    public static String spacesToTabs(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case ' ': {
                    ++n3;
                    ++n2;
                    continue block5;
                }
                case '\t': {
                    int n4 = n - n2 % n;
                    n2 += n4;
                    n3 += n4;
                    continue block5;
                }
                case '\n': {
                    if (n3 != 0) {
                        stringBuilder.append(StandardUtilities.createWhiteSpace(n3, n, n2 - n3));
                    }
                    n3 = 0;
                    n2 = 0;
                    stringBuilder.append('\n');
                    continue block5;
                }
                default: {
                    if (n3 != 0) {
                        stringBuilder.append(StandardUtilities.createWhiteSpace(n3, n, n2 - n3));
                        n3 = 0;
                    }
                    stringBuilder.append(string.charAt(i));
                    ++n2;
                }
            }
        }
        if (n3 != 0) {
            stringBuilder.append(StandardUtilities.createWhiteSpace(n3, n, n2 - n3));
        }
        return stringBuilder.toString();
    }

    public static String tabsToSpaces(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\t': {
                    int n3 = n - n2 % n;
                    n2 += n3;
                    while (--n3 >= 0) {
                        stringBuilder.append(' ');
                    }
                    continue block4;
                }
                case '\n': {
                    n2 = 0;
                    stringBuilder.append(string.charAt(i));
                    continue block4;
                }
                default: {
                    ++n2;
                    stringBuilder.append(string.charAt(i));
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String format(String string, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = 0;
        while ((n3 = string.indexOf("\n\n", n4)) != -1) {
            TextUtilities.formatParagraph(string.substring(n4, n3), n, n2, stringBuilder);
            stringBuilder.append("\n\n");
            n4 = n3 + 2;
        }
        if (n4 != string.length()) {
            TextUtilities.formatParagraph(string.substring(n4), n, n2, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static int indexIgnoringWhitespace(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            ++n2;
        }
        return n2;
    }

    public static int ignoringWhitespaceIndex(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (!Character.isWhitespace(string.charAt(n3))) {
                ++n2;
            }
            if (n2 > n) {
                return n3;
            }
            if (n3 == string.length() - 1) {
                return n3 + 1;
            }
            ++n3;
        }
    }

    public static int getStringCase(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return 0;
        }
        int n = -1;
        char c = charSequence.charAt(0);
        if (Character.isLetter(c)) {
            n = Character.isUpperCase(c) ? 2 : 1;
        }
        block4: for (int i = 1; i < charSequence.length(); ++i) {
            c = charSequence.charAt(i);
            if (!Character.isLetter(c)) continue;
            switch (n) {
                case 2: {
                    if (!Character.isLowerCase(c)) continue block4;
                    if (i == 1) {
                        n = 3;
                        continue block4;
                    }
                    return 0;
                }
                case 1: 
                case 3: {
                    if (!Character.isUpperCase(c)) continue block4;
                    return 0;
                }
            }
        }
        return n;
    }

    public static int getStringCase(String string) {
        return TextUtilities.getStringCase((CharSequence)string);
    }

    public static String toTitleCase(String string) {
        if (string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1).toLowerCase();
    }

    public static String escapeText(String string) {
        String string2 = string.replace("\\E", "\\\\E");
        return "\\Q" + string2 + "\\E";
    }

    private static void formatParagraph(String string, int n, int n2, StringBuilder stringBuilder) {
        int n3 = StandardUtilities.getLeadingWhiteSpace(string);
        String string2 = string.substring(0, n3);
        int n4 = StandardUtilities.getLeadingWhiteSpaceWidth(string, n2);
        stringBuilder.append(string2);
        int n5 = n4;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (n5 != n4) {
                if (n5 + string3.length() + 1 > n) {
                    stringBuilder.append('\n');
                    stringBuilder.append(string2);
                    n5 = n4;
                } else {
                    stringBuilder.append(' ');
                    ++n5;
                }
            }
            stringBuilder.append(string3);
            n5 += string3.length();
        }
    }

    public static void indexIgnoringWhitespace(String string, int n, int n2, StringBuffer stringBuffer) {
        int n3 = StandardUtilities.getLeadingWhiteSpace(string);
        String string2 = string.substring(0, n3);
        int n4 = StandardUtilities.getLeadingWhiteSpaceWidth(string, n2);
        stringBuffer.append(string2);
        int n5 = n4;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (n5 != n4) {
                if (n5 + string3.length() + 1 > n) {
                    stringBuffer.append('\n');
                    stringBuffer.append(string2);
                    n5 = n4;
                } else {
                    stringBuffer.append(' ');
                    ++n5;
                }
            }
            stringBuffer.append(string3);
            n5 += string3.length();
        }
    }
}

