/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public abstract class DockableWindowManager
extends JPanel {
    public static final String FLOATING = "floating";
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String BOTTOM = "bottom";
    public static final String RIGHT = "right";
    private final Map<PluginJAR, Set<String>> plugins = new HashMap<PluginJAR, Set<String>>();
    private final Map<String, String> positions = new HashMap<String, String>();
    protected View view;
    protected DockableWindowFactory factory;
    protected Map<String, JComponent> windows = new HashMap<String, JComponent>();
    private boolean tBottom;
    private boolean tTop;
    private boolean tLeft;
    private boolean tRight;
    private boolean closeToggle = true;
    private static final String ALTERNATE_LAYOUT_PROP = "view.docking.alternateLayout";
    private boolean alternateLayout;

    public DockableWindowManager(View view, DockableWindowFactory dockableWindowFactory, View.ViewConfig viewConfig) {
        this.view = view;
        this.factory = dockableWindowFactory;
        this.alternateLayout = jEdit.getBooleanProperty(ALTERNATE_LAYOUT_PROP);
    }

    public abstract void setMainPanel(JPanel var1);

    public abstract void showDockableWindow(String var1);

    public abstract void hideDockableWindow(String var1);

    public abstract void disposeDockableWindow(String var1);

    public abstract JComponent floatDockableWindow(String var1);

    public abstract boolean isDockableWindowDocked(String var1);

    public abstract boolean isDockableWindowVisible(String var1);

    public abstract void closeCurrentArea();

    public abstract DockingLayout getDockingLayout(View.ViewConfig var1);

    public abstract DockingArea getLeftDockingArea();

    public abstract DockingArea getRightDockingArea();

    public abstract DockingArea getTopDockingArea();

    public abstract DockingArea getBottomDockingArea();

    public void init() {
        EditBus.addToBus(this);
        Iterator<DockableWindowFactory.Window> iterator = this.factory.getDockableWindowIterator();
        while (iterator.hasNext()) {
            DockableWindowFactory.Window window = iterator.next();
            String string = window.name;
            this.positions.put(string, this.getDockablePosition(string));
            this.addPluginDockable(window.plugin, string);
        }
    }

    public void close() {
        EditBus.removeFromBus(this);
    }

    public void applyDockingLayout(DockingLayout dockingLayout) {
        for (Map.Entry<String, String> entry : this.positions.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string2.equals(FLOATING)) continue;
            this.showDockableWindow(string);
        }
    }

    public void addDockableWindow(String string) {
        this.showDockableWindow(string);
    }

    public void removeDockableWindow(String string) {
        this.hideDockableWindow(string);
    }

    public void toggleDockableWindow(String string) {
        if (this.isDockableWindowVisible(string)) {
            this.removeDockableWindow(string);
        } else {
            this.addDockableWindow(string);
        }
    }

    public JComponent getDockableWindow(String string) {
        return this.getDockable(string);
    }

    public void toggleDockAreas() {
        if (this.closeToggle) {
            this.tTop = this.getTopDockingArea().getCurrent() != null;
            this.tLeft = this.getLeftDockingArea().getCurrent() != null;
            this.tRight = this.getRightDockingArea().getCurrent() != null;
            this.tBottom = this.getBottomDockingArea().getCurrent() != null;
            this.getBottomDockingArea().show(null);
            this.getTopDockingArea().show(null);
            this.getRightDockingArea().show(null);
            this.getLeftDockingArea().show(null);
        } else {
            if (this.tBottom) {
                this.getBottomDockingArea().showMostRecent();
            }
            if (this.tLeft) {
                this.getLeftDockingArea().showMostRecent();
            }
            if (this.tRight) {
                this.getRightDockingArea().showMostRecent();
            }
            if (this.tTop) {
                this.getTopDockingArea().showMostRecent();
            }
        }
        this.view.closeAllMenus();
        this.closeToggle = !this.closeToggle;
        this.view.getTextArea().requestFocus();
    }

    public void dockableTitleChanged(String string, String string2) {
    }

    public KeyListener closeListener(String string) {
        return new KeyHandler(string);
    }

    public View getView() {
        return this.view;
    }

    public JComponent getDockable(String string) {
        return this.windows.get(string);
    }

    public String getDockableTitle(String string) {
        return this.longTitle(string);
    }

    public void setDockableTitle(String string, String string2) {
        String string3 = this.getLongTitlePropertyName(string);
        String string4 = jEdit.getProperty(string3);
        jEdit.setProperty(string3, string2);
        this.firePropertyChange(string3, string4, string2);
        this.dockableTitleChanged(string, string2);
    }

    public static String[] getRegisteredDockableWindows() {
        return DockableWindowFactory.getInstance().getRegisteredDockableWindows();
    }

    public static String getDockableWindowPluginName(String string) {
        String string2 = DockableWindowFactory.getInstance().getDockableWindowPluginClass(string);
        if (string2 == null) {
            return null;
        }
        return jEdit.getProperty("plugin." + string2 + ".name");
    }

    public void setDockingLayout(DockingLayout dockingLayout) {
        this.applyDockingLayout(dockingLayout);
        this.applyAlternateLayout(this.alternateLayout);
    }

    private void addPluginDockable(PluginJAR pluginJAR, String string) {
        Set<String> set = this.plugins.get(pluginJAR);
        if (set == null) {
            set = new HashSet<String>();
            this.plugins.put(pluginJAR, set);
        }
        set.add(string);
    }

    @EditBus.EBHandler
    public void handleDockableWindowUpdate(DockableWindowUpdate dockableWindowUpdate) {
        if (dockableWindowUpdate.getWhat() == DockableWindowUpdate.PROPERTIES_CHANGED) {
            this.propertiesChanged();
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        this.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handlePluginUpdate(PluginUpdate pluginUpdate) {
        Set<String> set;
        if (pluginUpdate.getWhat() == PluginUpdate.LOADED) {
            Iterator<DockableWindowFactory.Window> iterator = this.factory.getDockableWindowIterator();
            while (iterator.hasNext()) {
                DockableWindowFactory.Window window = iterator.next();
                if (window.plugin != pluginUpdate.getPluginJAR()) continue;
                String string = this.getDockablePosition(window.name);
                this.positions.put(window.name, string);
                this.addPluginDockable(window.plugin, window.name);
                this.dockableLoaded(window.name, string);
            }
            this.propertiesChanged();
        } else if (!(pluginUpdate.isExiting() || pluginUpdate.getWhat() != PluginUpdate.DEACTIVATED && pluginUpdate.getWhat() != PluginUpdate.UNLOADED || (set = this.plugins.remove(pluginUpdate.getPluginJAR())) == null)) {
            for (String string : set) {
                this.disposeDockableWindow(string);
                this.windows.remove(string);
            }
        }
    }

    public String longTitle(String string) {
        String string2 = jEdit.getProperty(this.getLongTitlePropertyName(string));
        if (string2 == null) {
            return this.shortTitle(string);
        }
        return string2;
    }

    public String shortTitle(String string) {
        String string2 = jEdit.getProperty(string + ".title");
        if (string2 == null) {
            return "NO TITLE PROPERTY: " + string;
        }
        return string2;
    }

    protected void applyAlternateLayout(boolean bl) {
    }

    protected void dockableLoaded(String string, String string2) {
    }

    protected void dockingPositionChanged(String string, String string2, String string3) {
    }

    protected boolean getAlternateLayoutProp() {
        return this.alternateLayout;
    }

    protected void propertiesChanged() {
        if (this.view.isPlainView()) {
            return;
        }
        boolean bl = jEdit.getBooleanProperty(ALTERNATE_LAYOUT_PROP);
        if (bl != this.alternateLayout) {
            this.alternateLayout = bl;
            this.applyAlternateLayout(bl);
        }
        String[] stringArray = this.factory.getRegisteredDockableWindows();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = this.positions.get(string);
            String string3 = this.getDockablePosition(string);
            if (string2 != null && string3.equals(string2)) continue;
            this.positions.put(string, string3);
            this.dockingPositionChanged(string, string2, string3);
        }
    }

    protected JComponent createDockable(String string) {
        DockableWindowFactory.Window window = this.factory.getDockableWindowFactory(string);
        if (window == null) {
            Log.log(9, this, "Unknown dockable window: " + string);
            return null;
        }
        String string2 = this.getDockablePosition(string);
        JComponent jComponent = window.createDockableWindow(this.view, string2);
        if (jComponent != null) {
            this.windows.put(string, jComponent);
        }
        return jComponent;
    }

    protected String getDockablePosition(String string) {
        return jEdit.getProperty(string + ".dock-position", FLOATING);
    }

    protected void focusDockable(String string) {
        JComponent jComponent = this.getDockable(string);
        if (jComponent == null) {
            return;
        }
        if (jComponent instanceof DefaultFocusComponent) {
            ((DefaultFocusComponent)((Object)jComponent)).focusOnDefaultComponent();
        } else {
            jComponent.requestFocus();
        }
    }

    protected String getLongTitlePropertyName(String string) {
        return string + ".longtitle";
    }

    public static abstract class DockingLayout {
        public static final int NO_VIEW_INDEX = -1;

        public abstract boolean loadLayout(String var1, int var2);

        public abstract boolean saveLayout(String var1, int var2);

        public abstract String getName();

        public void setPlainView(boolean bl) {
        }

        public String[] getSavedLayouts() {
            String string = this.getLayoutDirectory();
            if (string == null) {
                return null;
            }
            File file = new File(string);
            File[] fileArray = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(".xml");
                }
            });
            String[] stringArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = DockingLayout.fileToLayout(fileArray[i].getName());
            }
            return stringArray;
        }

        private static String fileToLayout(String string) {
            return string.replaceFirst(".xml", "");
        }

        private static String layoutToFile(String string, int n) {
            StringBuilder stringBuilder = new StringBuilder(string);
            if (n != -1) {
                stringBuilder.append("-view").append(n);
            }
            stringBuilder.append(".xml");
            return stringBuilder.toString();
        }

        public String getLayoutFilename(String string, int n) {
            String string2 = this.getLayoutDirectory();
            if (string2 == null) {
                return null;
            }
            return string2 + File.separator + DockingLayout.layoutToFile(string, n);
        }

        private String getLayoutDirectory() {
            String string = this.getName();
            if (string == null) {
                return null;
            }
            String string2 = jEdit.getSettingsDirectory();
            if (string2 == null) {
                return null;
            }
            File file = new File(string2 = string2 + File.separator + string);
            if (!file.exists()) {
                file.mkdir();
            }
            return string2;
        }
    }

    class KeyHandler
    extends KeyAdapter {
        static final String action = "close-docking-area";
        private List<KeyEventTranslator.Key> b1;
        private List<KeyEventTranslator.Key> b2;
        private final String name;
        private int match1;
        private int match2;

        KeyHandler(String string) {
            String string2 = jEdit.getProperty("close-docking-area.shortcut");
            String string3 = jEdit.getProperty("close-docking-area.shortcut2");
            if (string2 != null) {
                this.b1 = this.parseShortcut(string2);
            }
            if (string3 != null) {
                this.b2 = this.parseShortcut(string3);
            }
            this.name = string;
            this.match2 = 0;
            this.match1 = 0;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.b1 != null) {
                this.match1 = this.match(keyEvent, this.b1, this.match1);
            }
            if (this.b2 != null) {
                this.match2 = this.match(keyEvent, this.b2, this.match2);
            }
            if (this.match1 > 0 && this.match1 == this.b1.size() || this.match2 > 0 && this.match2 == this.b2.size()) {
                DockableWindowManager.this.hideDockableWindow(this.name);
                this.match2 = 0;
                this.match1 = 0;
            }
        }

        private int match(KeyEvent keyEvent, List<KeyEventTranslator.Key> list, int n) {
            char c = keyEvent.getKeyChar();
            if (list != null && c == list.get((int)n).key) {
                return n + 1;
            }
            return 0;
        }

        private List<KeyEventTranslator.Key> parseShortcut(String string) {
            String[] stringArray = string.split("\\s+");
            ArrayList<KeyEventTranslator.Key> arrayList = new ArrayList<KeyEventTranslator.Key>(stringArray.length);
            for (String string2 : stringArray) {
                if (string2.length() <= 0) continue;
                arrayList.add(KeyEventTranslator.parseKey(string2));
            }
            return arrayList;
        }
    }

    public static interface DockingArea {
        public void showMostRecent();

        public String getCurrent();

        public void show(String var1);

        public String[] getDockables();
    }
}

